// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
struct __attribute__((packed)) aB_B_BFu0c { bool v1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aB_B_BFu0i { bool v1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aB_B_BFu0ll { bool v1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aB_B_BFu0s { bool v1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aB_BFu0c { bool v1; unsigned char :0; };
struct __attribute__((packed)) aB_BFu0c_B { bool v1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aB_BFu0c_BFu0c { bool v1; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aB_BFu0c_BFu0i { bool v1; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aB_BFu0c_BFu0ll { bool v1; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu0c_BFu0s { bool v1; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aB_BFu0c_BFu15i { bool v1; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aB_BFu0c_BFu15ll { bool v1; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aB_BFu0c_BFu15s { bool v1; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aB_BFu0c_BFu16i { bool v1; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aB_BFu0c_BFu16ll { bool v1; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aB_BFu0c_BFu16s { bool v1; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aB_BFu0c_BFu17i { bool v1; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aB_BFu0c_BFu17ll { bool v1; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aB_BFu0c_BFu1c { bool v1; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aB_BFu0c_BFu1i { bool v1; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aB_BFu0c_BFu1ll { bool v1; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aB_BFu0c_BFu1s { bool v1; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aB_BFu0c_BFu31i { bool v1; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aB_BFu0c_BFu31ll { bool v1; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aB_BFu0c_BFu32i { bool v1; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aB_BFu0c_BFu32ll { bool v1; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aB_BFu0c_BFu33 { bool v1; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aB_BFu0c_BFu7c { bool v1; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aB_BFu0c_BFu7i { bool v1; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aB_BFu0c_BFu7ll { bool v1; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aB_BFu0c_BFu7s { bool v1; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aB_BFu0c_BFu8c { bool v1; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aB_BFu0c_BFu8i { bool v1; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aB_BFu0c_BFu8ll { bool v1; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aB_BFu0c_BFu8s { bool v1; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aB_BFu0c_BFu9i { bool v1; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aB_BFu0c_BFu9ll { bool v1; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aB_BFu0c_BFu9s { bool v1; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aB_BFu0c_C { bool v1; unsigned char :0; char v2; };
struct __attribute__((packed)) aB_BFu0c_D { bool v1; unsigned char :0; double v2; };
struct __attribute__((packed)) aB_BFu0c_F { bool v1; unsigned char :0; float v2; };
struct __attribute__((packed)) aB_BFu0c_I { bool v1; unsigned char :0; int v2; };
struct __attribute__((packed)) aB_BFu0c_Ip { bool v1; unsigned char :0; int * v2; };
struct __attribute__((packed)) aB_BFu0c_L { bool v1; unsigned char :0; long long v2; };
struct __attribute__((packed)) aB_BFu0c_S { bool v1; unsigned char :0; short v2; };
struct __attribute__((packed)) aB_BFu0c_Uc { bool v1; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aB_BFu0c_Ui { bool v1; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aB_BFu0c_Ul { bool v1; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aB_BFu0c_Us { bool v1; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aB_BFu0c_Vp { bool v1; unsigned char :0; void * v2; };
struct __attribute__((packed)) aB_BFu0i { bool v1; unsigned int :0; };
struct __attribute__((packed)) aB_BFu0i_B { bool v1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aB_BFu0i_BFu0c { bool v1; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aB_BFu0i_BFu0i { bool v1; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aB_BFu0i_BFu0ll { bool v1; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu0i_BFu0s { bool v1; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aB_BFu0i_BFu15i { bool v1; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aB_BFu0i_BFu15ll { bool v1; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aB_BFu0i_BFu15s { bool v1; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aB_BFu0i_BFu16i { bool v1; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aB_BFu0i_BFu16ll { bool v1; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aB_BFu0i_BFu16s { bool v1; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aB_BFu0i_BFu17i { bool v1; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aB_BFu0i_BFu17ll { bool v1; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aB_BFu0i_BFu1c { bool v1; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aB_BFu0i_BFu1i { bool v1; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aB_BFu0i_BFu1ll { bool v1; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aB_BFu0i_BFu1s { bool v1; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aB_BFu0i_BFu31i { bool v1; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aB_BFu0i_BFu31ll { bool v1; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aB_BFu0i_BFu32i { bool v1; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aB_BFu0i_BFu32ll { bool v1; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aB_BFu0i_BFu33 { bool v1; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aB_BFu0i_BFu7c { bool v1; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aB_BFu0i_BFu7i { bool v1; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aB_BFu0i_BFu7ll { bool v1; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aB_BFu0i_BFu7s { bool v1; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aB_BFu0i_BFu8c { bool v1; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aB_BFu0i_BFu8i { bool v1; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aB_BFu0i_BFu8ll { bool v1; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aB_BFu0i_BFu8s { bool v1; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aB_BFu0i_BFu9i { bool v1; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aB_BFu0i_BFu9ll { bool v1; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aB_BFu0i_BFu9s { bool v1; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aB_BFu0i_C { bool v1; unsigned int :0; char v2; };
struct __attribute__((packed)) aB_BFu0i_D { bool v1; unsigned int :0; double v2; };
struct __attribute__((packed)) aB_BFu0i_F { bool v1; unsigned int :0; float v2; };
struct __attribute__((packed)) aB_BFu0i_I { bool v1; unsigned int :0; int v2; };
struct __attribute__((packed)) aB_BFu0i_Ip { bool v1; unsigned int :0; int * v2; };
struct __attribute__((packed)) aB_BFu0i_L { bool v1; unsigned int :0; long long v2; };
struct __attribute__((packed)) aB_BFu0i_S { bool v1; unsigned int :0; short v2; };
struct __attribute__((packed)) aB_BFu0i_Uc { bool v1; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aB_BFu0i_Ui { bool v1; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aB_BFu0i_Ul { bool v1; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aB_BFu0i_Us { bool v1; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aB_BFu0i_Vp { bool v1; unsigned int :0; void * v2; };
struct __attribute__((packed)) aB_BFu0ll { bool v1; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu0ll_B { bool v1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aB_BFu0ll_BFu0c { bool v1; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aB_BFu0ll_BFu0i { bool v1; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aB_BFu0ll_BFu0ll { bool v1; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu0ll_BFu0s { bool v1; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aB_BFu0ll_BFu15i { bool v1; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aB_BFu0ll_BFu15ll { bool v1; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aB_BFu0ll_BFu15s { bool v1; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aB_BFu0ll_BFu16i { bool v1; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aB_BFu0ll_BFu16ll { bool v1; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aB_BFu0ll_BFu16s { bool v1; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aB_BFu0ll_BFu17i { bool v1; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aB_BFu0ll_BFu17ll { bool v1; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aB_BFu0ll_BFu1c { bool v1; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aB_BFu0ll_BFu1i { bool v1; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aB_BFu0ll_BFu1ll { bool v1; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aB_BFu0ll_BFu1s { bool v1; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aB_BFu0ll_BFu31i { bool v1; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aB_BFu0ll_BFu31ll { bool v1; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aB_BFu0ll_BFu32i { bool v1; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aB_BFu0ll_BFu32ll { bool v1; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aB_BFu0ll_BFu33 { bool v1; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aB_BFu0ll_BFu7c { bool v1; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aB_BFu0ll_BFu7i { bool v1; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aB_BFu0ll_BFu7ll { bool v1; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aB_BFu0ll_BFu7s { bool v1; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aB_BFu0ll_BFu8c { bool v1; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aB_BFu0ll_BFu8i { bool v1; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aB_BFu0ll_BFu8ll { bool v1; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aB_BFu0ll_BFu8s { bool v1; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aB_BFu0ll_BFu9i { bool v1; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aB_BFu0ll_BFu9ll { bool v1; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aB_BFu0ll_BFu9s { bool v1; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aB_BFu0ll_C { bool v1; unsigned long long :0; char v2; };
struct __attribute__((packed)) aB_BFu0ll_D { bool v1; unsigned long long :0; double v2; };
struct __attribute__((packed)) aB_BFu0ll_F { bool v1; unsigned long long :0; float v2; };
struct __attribute__((packed)) aB_BFu0ll_I { bool v1; unsigned long long :0; int v2; };
struct __attribute__((packed)) aB_BFu0ll_Ip { bool v1; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aB_BFu0ll_L { bool v1; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aB_BFu0ll_S { bool v1; unsigned long long :0; short v2; };
struct __attribute__((packed)) aB_BFu0ll_Uc { bool v1; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aB_BFu0ll_Ui { bool v1; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aB_BFu0ll_Ul { bool v1; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aB_BFu0ll_Us { bool v1; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aB_BFu0ll_Vp { bool v1; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aB_BFu0s { bool v1; unsigned short :0; };
struct __attribute__((packed)) aB_BFu0s_B { bool v1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aB_BFu0s_BFu0c { bool v1; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aB_BFu0s_BFu0i { bool v1; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aB_BFu0s_BFu0ll { bool v1; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu0s_BFu0s { bool v1; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aB_BFu0s_BFu15i { bool v1; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aB_BFu0s_BFu15ll { bool v1; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aB_BFu0s_BFu15s { bool v1; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aB_BFu0s_BFu16i { bool v1; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aB_BFu0s_BFu16ll { bool v1; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aB_BFu0s_BFu16s { bool v1; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aB_BFu0s_BFu17i { bool v1; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aB_BFu0s_BFu17ll { bool v1; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aB_BFu0s_BFu1c { bool v1; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aB_BFu0s_BFu1i { bool v1; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aB_BFu0s_BFu1ll { bool v1; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aB_BFu0s_BFu1s { bool v1; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aB_BFu0s_BFu31i { bool v1; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aB_BFu0s_BFu31ll { bool v1; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aB_BFu0s_BFu32i { bool v1; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aB_BFu0s_BFu32ll { bool v1; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aB_BFu0s_BFu33 { bool v1; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aB_BFu0s_BFu7c { bool v1; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aB_BFu0s_BFu7i { bool v1; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aB_BFu0s_BFu7ll { bool v1; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aB_BFu0s_BFu7s { bool v1; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aB_BFu0s_BFu8c { bool v1; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aB_BFu0s_BFu8i { bool v1; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aB_BFu0s_BFu8ll { bool v1; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aB_BFu0s_BFu8s { bool v1; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aB_BFu0s_BFu9i { bool v1; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aB_BFu0s_BFu9ll { bool v1; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aB_BFu0s_BFu9s { bool v1; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aB_BFu0s_C { bool v1; unsigned short :0; char v2; };
struct __attribute__((packed)) aB_BFu0s_D { bool v1; unsigned short :0; double v2; };
struct __attribute__((packed)) aB_BFu0s_F { bool v1; unsigned short :0; float v2; };
struct __attribute__((packed)) aB_BFu0s_I { bool v1; unsigned short :0; int v2; };
struct __attribute__((packed)) aB_BFu0s_Ip { bool v1; unsigned short :0; int * v2; };
struct __attribute__((packed)) aB_BFu0s_L { bool v1; unsigned short :0; long long v2; };
struct __attribute__((packed)) aB_BFu0s_S { bool v1; unsigned short :0; short v2; };
struct __attribute__((packed)) aB_BFu0s_Uc { bool v1; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aB_BFu0s_Ui { bool v1; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aB_BFu0s_Ul { bool v1; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aB_BFu0s_Us { bool v1; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aB_BFu0s_Vp { bool v1; unsigned short :0; void * v2; };
struct __attribute__((packed)) aB_BFu15i_BFu0c { bool v1; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aB_BFu15i_BFu0i { bool v1; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aB_BFu15i_BFu0ll { bool v1; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu15i_BFu0s { bool v1; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aB_BFu15ll_BFu0c { bool v1; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aB_BFu15ll_BFu0i { bool v1; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aB_BFu15ll_BFu0ll { bool v1; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu15ll_BFu0s { bool v1; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aB_BFu15s_BFu0c { bool v1; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aB_BFu15s_BFu0i { bool v1; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aB_BFu15s_BFu0ll { bool v1; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu15s_BFu0s { bool v1; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aB_BFu16i_BFu0c { bool v1; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aB_BFu16i_BFu0i { bool v1; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aB_BFu16i_BFu0ll { bool v1; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu16i_BFu0s { bool v1; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aB_BFu16ll_BFu0c { bool v1; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aB_BFu16ll_BFu0i { bool v1; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aB_BFu16ll_BFu0ll { bool v1; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu16ll_BFu0s { bool v1; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aB_BFu16s_BFu0c { bool v1; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aB_BFu16s_BFu0i { bool v1; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aB_BFu16s_BFu0ll { bool v1; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu16s_BFu0s { bool v1; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aB_BFu17i_BFu0c { bool v1; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aB_BFu17i_BFu0i { bool v1; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aB_BFu17i_BFu0ll { bool v1; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu17i_BFu0s { bool v1; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aB_BFu17ll_BFu0c { bool v1; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aB_BFu17ll_BFu0i { bool v1; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aB_BFu17ll_BFu0ll { bool v1; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu17ll_BFu0s { bool v1; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aB_BFu1c_BFu0c { bool v1; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aB_BFu1c_BFu0i { bool v1; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aB_BFu1c_BFu0ll { bool v1; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu1c_BFu0s { bool v1; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aB_BFu1i_BFu0c { bool v1; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aB_BFu1i_BFu0i { bool v1; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aB_BFu1i_BFu0ll { bool v1; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu1i_BFu0s { bool v1; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aB_BFu1ll_BFu0c { bool v1; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aB_BFu1ll_BFu0i { bool v1; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aB_BFu1ll_BFu0ll { bool v1; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu1ll_BFu0s { bool v1; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aB_BFu1s_BFu0c { bool v1; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aB_BFu1s_BFu0i { bool v1; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aB_BFu1s_BFu0ll { bool v1; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu1s_BFu0s { bool v1; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aB_BFu31i_BFu0c { bool v1; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aB_BFu31i_BFu0i { bool v1; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aB_BFu31i_BFu0ll { bool v1; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu31i_BFu0s { bool v1; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aB_BFu31ll_BFu0c { bool v1; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aB_BFu31ll_BFu0i { bool v1; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aB_BFu31ll_BFu0ll { bool v1; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu31ll_BFu0s { bool v1; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aB_BFu32i_BFu0c { bool v1; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aB_BFu32i_BFu0i { bool v1; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aB_BFu32i_BFu0ll { bool v1; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu32i_BFu0s { bool v1; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aB_BFu32ll_BFu0c { bool v1; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aB_BFu32ll_BFu0i { bool v1; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aB_BFu32ll_BFu0ll { bool v1; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu32ll_BFu0s { bool v1; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aB_BFu33_BFu0c { bool v1; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aB_BFu33_BFu0i { bool v1; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aB_BFu33_BFu0ll { bool v1; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu33_BFu0s { bool v1; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aB_BFu7c_BFu0c { bool v1; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aB_BFu7c_BFu0i { bool v1; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aB_BFu7c_BFu0ll { bool v1; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu7c_BFu0s { bool v1; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aB_BFu7i_BFu0c { bool v1; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aB_BFu7i_BFu0i { bool v1; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aB_BFu7i_BFu0ll { bool v1; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu7i_BFu0s { bool v1; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aB_BFu7ll_BFu0c { bool v1; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aB_BFu7ll_BFu0i { bool v1; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aB_BFu7ll_BFu0ll { bool v1; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu7ll_BFu0s { bool v1; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aB_BFu7s_BFu0c { bool v1; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aB_BFu7s_BFu0i { bool v1; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aB_BFu7s_BFu0ll { bool v1; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu7s_BFu0s { bool v1; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aB_BFu8c_BFu0c { bool v1; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aB_BFu8c_BFu0i { bool v1; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aB_BFu8c_BFu0ll { bool v1; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu8c_BFu0s { bool v1; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aB_BFu8i_BFu0c { bool v1; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aB_BFu8i_BFu0i { bool v1; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aB_BFu8i_BFu0ll { bool v1; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu8i_BFu0s { bool v1; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aB_BFu8ll_BFu0c { bool v1; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aB_BFu8ll_BFu0i { bool v1; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aB_BFu8ll_BFu0ll { bool v1; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu8ll_BFu0s { bool v1; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aB_BFu8s_BFu0c { bool v1; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aB_BFu8s_BFu0i { bool v1; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aB_BFu8s_BFu0ll { bool v1; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu8s_BFu0s { bool v1; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aB_BFu9i_BFu0c { bool v1; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aB_BFu9i_BFu0i { bool v1; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aB_BFu9i_BFu0ll { bool v1; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu9i_BFu0s { bool v1; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aB_BFu9ll_BFu0c { bool v1; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aB_BFu9ll_BFu0i { bool v1; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aB_BFu9ll_BFu0ll { bool v1; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu9ll_BFu0s { bool v1; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aB_BFu9s_BFu0c { bool v1; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aB_BFu9s_BFu0i { bool v1; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aB_BFu9s_BFu0ll { bool v1; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aB_BFu9s_BFu0s { bool v1; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aB_C_BFu0c { bool v1; char v2; unsigned char :0; };
struct __attribute__((packed)) aB_C_BFu0i { bool v1; char v2; unsigned int :0; };
struct __attribute__((packed)) aB_C_BFu0ll { bool v1; char v2; unsigned long long :0; };
struct __attribute__((packed)) aB_C_BFu0s { bool v1; char v2; unsigned short :0; };
struct __attribute__((packed)) aB_D_BFu0c { bool v1; double v2; unsigned char :0; };
struct __attribute__((packed)) aB_D_BFu0i { bool v1; double v2; unsigned int :0; };
struct __attribute__((packed)) aB_D_BFu0ll { bool v1; double v2; unsigned long long :0; };
struct __attribute__((packed)) aB_D_BFu0s { bool v1; double v2; unsigned short :0; };
struct __attribute__((packed)) aB_F_BFu0c { bool v1; float v2; unsigned char :0; };
struct __attribute__((packed)) aB_F_BFu0i { bool v1; float v2; unsigned int :0; };
struct __attribute__((packed)) aB_F_BFu0ll { bool v1; float v2; unsigned long long :0; };
struct __attribute__((packed)) aB_F_BFu0s { bool v1; float v2; unsigned short :0; };
struct __attribute__((packed)) aB_I_BFu0c { bool v1; int v2; unsigned char :0; };
struct __attribute__((packed)) aB_I_BFu0i { bool v1; int v2; unsigned int :0; };
struct __attribute__((packed)) aB_I_BFu0ll { bool v1; int v2; unsigned long long :0; };
struct __attribute__((packed)) aB_I_BFu0s { bool v1; int v2; unsigned short :0; };
struct __attribute__((packed)) aB_Ip_BFu0c { bool v1; int * v2; unsigned char :0; };
struct __attribute__((packed)) aB_Ip_BFu0i { bool v1; int * v2; unsigned int :0; };
struct __attribute__((packed)) aB_Ip_BFu0ll { bool v1; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aB_Ip_BFu0s { bool v1; int * v2; unsigned short :0; };
struct __attribute__((packed)) aB_L_BFu0c { bool v1; long long v2; unsigned char :0; };
struct __attribute__((packed)) aB_L_BFu0i { bool v1; long long v2; unsigned int :0; };
struct __attribute__((packed)) aB_L_BFu0ll { bool v1; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aB_L_BFu0s { bool v1; long long v2; unsigned short :0; };
struct __attribute__((packed)) aB_S_BFu0c { bool v1; short v2; unsigned char :0; };
struct __attribute__((packed)) aB_S_BFu0i { bool v1; short v2; unsigned int :0; };
struct __attribute__((packed)) aB_S_BFu0ll { bool v1; short v2; unsigned long long :0; };
struct __attribute__((packed)) aB_S_BFu0s { bool v1; short v2; unsigned short :0; };
struct __attribute__((packed)) aB_Uc_BFu0c { bool v1; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aB_Uc_BFu0i { bool v1; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aB_Uc_BFu0ll { bool v1; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aB_Uc_BFu0s { bool v1; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aB_Ui_BFu0c { bool v1; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aB_Ui_BFu0i { bool v1; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aB_Ui_BFu0ll { bool v1; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aB_Ui_BFu0s { bool v1; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aB_Ul_BFu0c { bool v1; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aB_Ul_BFu0i { bool v1; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aB_Ul_BFu0ll { bool v1; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aB_Ul_BFu0s { bool v1; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aB_Us_BFu0c { bool v1; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aB_Us_BFu0i { bool v1; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aB_Us_BFu0ll { bool v1; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aB_Us_BFu0s { bool v1; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aB_Vp_BFu0c { bool v1; void * v2; unsigned char :0; };
struct __attribute__((packed)) aB_Vp_BFu0i { bool v1; void * v2; unsigned int :0; };
struct __attribute__((packed)) aB_Vp_BFu0ll { bool v1; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aB_Vp_BFu0s { bool v1; void * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu0c_B { unsigned char :0; bool v1; };
struct __attribute__((packed)) aBFu0c_B_B { unsigned char :0; bool v1; bool v2; };
struct __attribute__((packed)) aBFu0c_B_BFu0c { unsigned char :0; bool v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0c_B_BFu0i { unsigned char :0; bool v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0c_B_BFu0ll { unsigned char :0; bool v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0c_B_BFu0s { unsigned char :0; bool v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0c_B_BFu15i { unsigned char :0; bool v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0c_B_BFu15ll { unsigned char :0; bool v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0c_B_BFu15s { unsigned char :0; bool v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0c_B_BFu16i { unsigned char :0; bool v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0c_B_BFu16ll { unsigned char :0; bool v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0c_B_BFu16s { unsigned char :0; bool v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0c_B_BFu17i { unsigned char :0; bool v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0c_B_BFu17ll { unsigned char :0; bool v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0c_B_BFu1c { unsigned char :0; bool v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0c_B_BFu1i { unsigned char :0; bool v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0c_B_BFu1ll { unsigned char :0; bool v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0c_B_BFu1s { unsigned char :0; bool v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0c_B_BFu31i { unsigned char :0; bool v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0c_B_BFu31ll { unsigned char :0; bool v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0c_B_BFu32i { unsigned char :0; bool v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0c_B_BFu32ll { unsigned char :0; bool v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0c_B_BFu33 { unsigned char :0; bool v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0c_B_BFu7c { unsigned char :0; bool v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0c_B_BFu7i { unsigned char :0; bool v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0c_B_BFu7ll { unsigned char :0; bool v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0c_B_BFu7s { unsigned char :0; bool v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0c_B_BFu8c { unsigned char :0; bool v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0c_B_BFu8i { unsigned char :0; bool v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0c_B_BFu8ll { unsigned char :0; bool v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0c_B_BFu8s { unsigned char :0; bool v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0c_B_BFu9i { unsigned char :0; bool v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0c_B_BFu9ll { unsigned char :0; bool v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0c_B_BFu9s { unsigned char :0; bool v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0c_B_C { unsigned char :0; bool v1; char v2; };
struct __attribute__((packed)) aBFu0c_B_D { unsigned char :0; bool v1; double v2; };
struct __attribute__((packed)) aBFu0c_B_F { unsigned char :0; bool v1; float v2; };
struct __attribute__((packed)) aBFu0c_B_I { unsigned char :0; bool v1; int v2; };
struct __attribute__((packed)) aBFu0c_B_Ip { unsigned char :0; bool v1; int * v2; };
struct __attribute__((packed)) aBFu0c_B_L { unsigned char :0; bool v1; long long v2; };
struct __attribute__((packed)) aBFu0c_B_S { unsigned char :0; bool v1; short v2; };
struct __attribute__((packed)) aBFu0c_B_Uc { unsigned char :0; bool v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0c_B_Ui { unsigned char :0; bool v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0c_B_Ul { unsigned char :0; bool v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0c_B_Us { unsigned char :0; bool v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0c_B_Vp { unsigned char :0; bool v1; void * v2; };
struct __attribute__((packed)) aBFu0c_BFu0c_B { unsigned char :0; unsigned char :0; bool v1; };
struct __attribute__((packed)) aBFu0c_BFu0i_B { unsigned char :0; unsigned int :0; bool v1; };
struct __attribute__((packed)) aBFu0c_BFu0ll_B { unsigned char :0; unsigned long long :0; bool v1; };
struct __attribute__((packed)) aBFu0c_BFu0s_B { unsigned char :0; unsigned short :0; bool v1; };
struct __attribute__((packed)) aBFu0c_BFu15i_B { unsigned char :0; unsigned int v1:15; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu15ll_B { unsigned char :0; unsigned long long v1:15; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu15s_B { unsigned char :0; unsigned short v1:15; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu16i_B { unsigned char :0; unsigned int v1:16; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu16ll_B { unsigned char :0; unsigned long long v1:16; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu16s_B { unsigned char :0; unsigned short v1:16; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu17i_B { unsigned char :0; unsigned int v1:17; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu17ll_B { unsigned char :0; unsigned long long v1:17; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu1c_B { unsigned char :0; unsigned char v1:1; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu1i_B { unsigned char :0; unsigned int v1:1; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu1ll_B { unsigned char :0; unsigned long long v1:1; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu1s_B { unsigned char :0; unsigned short v1:1; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu31i_B { unsigned char :0; unsigned int v1:31; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu31ll_B { unsigned char :0; unsigned long long v1:31; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu32i_B { unsigned char :0; unsigned int v1:32; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu32ll_B { unsigned char :0; unsigned long long v1:32; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu33_B { unsigned char :0; unsigned long long v1:33; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu7c_B { unsigned char :0; unsigned char v1:7; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu7i_B { unsigned char :0; unsigned int v1:7; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu7ll_B { unsigned char :0; unsigned long long v1:7; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu7s_B { unsigned char :0; unsigned short v1:7; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu8c_B { unsigned char :0; unsigned char v1:8; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu8i_B { unsigned char :0; unsigned int v1:8; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu8ll_B { unsigned char :0; unsigned long long v1:8; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu8s_B { unsigned char :0; unsigned short v1:8; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu9i_B { unsigned char :0; unsigned int v1:9; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu9ll_B { unsigned char :0; unsigned long long v1:9; bool v2; };
struct __attribute__((packed)) aBFu0c_BFu9s_B { unsigned char :0; unsigned short v1:9; bool v2; };
struct __attribute__((packed)) aBFu0c_C_B { unsigned char :0; char v1; bool v2; };
struct __attribute__((packed)) aBFu0c_D_B { unsigned char :0; double v1; bool v2; };
struct __attribute__((packed)) aBFu0c_F_B { unsigned char :0; float v1; bool v2; };
struct __attribute__((packed)) aBFu0c_I_B { unsigned char :0; int v1; bool v2; };
struct __attribute__((packed)) aBFu0c_Ip_B { unsigned char :0; int * v1; bool v2; };
struct __attribute__((packed)) aBFu0c_L_B { unsigned char :0; long long v1; bool v2; };
struct __attribute__((packed)) aBFu0c_S_B { unsigned char :0; short v1; bool v2; };
struct __attribute__((packed)) aBFu0c_Uc_B { unsigned char :0; unsigned char v1; bool v2; };
struct __attribute__((packed)) aBFu0c_Ui_B { unsigned char :0; unsigned int v1; bool v2; };
struct __attribute__((packed)) aBFu0c_Ul_B { unsigned char :0; unsigned long long v1; bool v2; };
struct __attribute__((packed)) aBFu0c_Us_B { unsigned char :0; unsigned short v1; bool v2; };
struct __attribute__((packed)) aBFu0c_Vp_B { unsigned char :0; void * v1; bool v2; };
struct __attribute__((packed)) aBFu0i_B { unsigned int :0; bool v1; };
struct __attribute__((packed)) aBFu0i_B_B { unsigned int :0; bool v1; bool v2; };
struct __attribute__((packed)) aBFu0i_B_BFu0c { unsigned int :0; bool v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0i_B_BFu0i { unsigned int :0; bool v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0i_B_BFu0ll { unsigned int :0; bool v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0i_B_BFu0s { unsigned int :0; bool v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0i_B_BFu15i { unsigned int :0; bool v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0i_B_BFu15ll { unsigned int :0; bool v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0i_B_BFu15s { unsigned int :0; bool v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0i_B_BFu16i { unsigned int :0; bool v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0i_B_BFu16ll { unsigned int :0; bool v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0i_B_BFu16s { unsigned int :0; bool v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0i_B_BFu17i { unsigned int :0; bool v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0i_B_BFu17ll { unsigned int :0; bool v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0i_B_BFu1c { unsigned int :0; bool v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0i_B_BFu1i { unsigned int :0; bool v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0i_B_BFu1ll { unsigned int :0; bool v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0i_B_BFu1s { unsigned int :0; bool v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0i_B_BFu31i { unsigned int :0; bool v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0i_B_BFu31ll { unsigned int :0; bool v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0i_B_BFu32i { unsigned int :0; bool v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0i_B_BFu32ll { unsigned int :0; bool v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0i_B_BFu33 { unsigned int :0; bool v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0i_B_BFu7c { unsigned int :0; bool v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0i_B_BFu7i { unsigned int :0; bool v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0i_B_BFu7ll { unsigned int :0; bool v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0i_B_BFu7s { unsigned int :0; bool v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0i_B_BFu8c { unsigned int :0; bool v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0i_B_BFu8i { unsigned int :0; bool v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0i_B_BFu8ll { unsigned int :0; bool v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0i_B_BFu8s { unsigned int :0; bool v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0i_B_BFu9i { unsigned int :0; bool v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0i_B_BFu9ll { unsigned int :0; bool v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0i_B_BFu9s { unsigned int :0; bool v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0i_B_C { unsigned int :0; bool v1; char v2; };
struct __attribute__((packed)) aBFu0i_B_D { unsigned int :0; bool v1; double v2; };
struct __attribute__((packed)) aBFu0i_B_F { unsigned int :0; bool v1; float v2; };
struct __attribute__((packed)) aBFu0i_B_I { unsigned int :0; bool v1; int v2; };
struct __attribute__((packed)) aBFu0i_B_Ip { unsigned int :0; bool v1; int * v2; };
struct __attribute__((packed)) aBFu0i_B_L { unsigned int :0; bool v1; long long v2; };
struct __attribute__((packed)) aBFu0i_B_S { unsigned int :0; bool v1; short v2; };
struct __attribute__((packed)) aBFu0i_B_Uc { unsigned int :0; bool v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0i_B_Ui { unsigned int :0; bool v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0i_B_Ul { unsigned int :0; bool v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0i_B_Us { unsigned int :0; bool v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0i_B_Vp { unsigned int :0; bool v1; void * v2; };
struct __attribute__((packed)) aBFu0i_BFu0c_B { unsigned int :0; unsigned char :0; bool v1; };
struct __attribute__((packed)) aBFu0i_BFu0i_B { unsigned int :0; unsigned int :0; bool v1; };
struct __attribute__((packed)) aBFu0i_BFu0ll_B { unsigned int :0; unsigned long long :0; bool v1; };
struct __attribute__((packed)) aBFu0i_BFu0s_B { unsigned int :0; unsigned short :0; bool v1; };
struct __attribute__((packed)) aBFu0i_BFu15i_B { unsigned int :0; unsigned int v1:15; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu15ll_B { unsigned int :0; unsigned long long v1:15; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu15s_B { unsigned int :0; unsigned short v1:15; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu16i_B { unsigned int :0; unsigned int v1:16; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu16ll_B { unsigned int :0; unsigned long long v1:16; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu16s_B { unsigned int :0; unsigned short v1:16; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu17i_B { unsigned int :0; unsigned int v1:17; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu17ll_B { unsigned int :0; unsigned long long v1:17; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu1c_B { unsigned int :0; unsigned char v1:1; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu1i_B { unsigned int :0; unsigned int v1:1; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu1ll_B { unsigned int :0; unsigned long long v1:1; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu1s_B { unsigned int :0; unsigned short v1:1; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu31i_B { unsigned int :0; unsigned int v1:31; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu31ll_B { unsigned int :0; unsigned long long v1:31; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu32i_B { unsigned int :0; unsigned int v1:32; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu32ll_B { unsigned int :0; unsigned long long v1:32; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu33_B { unsigned int :0; unsigned long long v1:33; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu7c_B { unsigned int :0; unsigned char v1:7; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu7i_B { unsigned int :0; unsigned int v1:7; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu7ll_B { unsigned int :0; unsigned long long v1:7; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu7s_B { unsigned int :0; unsigned short v1:7; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu8c_B { unsigned int :0; unsigned char v1:8; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu8i_B { unsigned int :0; unsigned int v1:8; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu8ll_B { unsigned int :0; unsigned long long v1:8; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu8s_B { unsigned int :0; unsigned short v1:8; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu9i_B { unsigned int :0; unsigned int v1:9; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu9ll_B { unsigned int :0; unsigned long long v1:9; bool v2; };
struct __attribute__((packed)) aBFu0i_BFu9s_B { unsigned int :0; unsigned short v1:9; bool v2; };
struct __attribute__((packed)) aBFu0i_C_B { unsigned int :0; char v1; bool v2; };
struct __attribute__((packed)) aBFu0i_D_B { unsigned int :0; double v1; bool v2; };
struct __attribute__((packed)) aBFu0i_F_B { unsigned int :0; float v1; bool v2; };
struct __attribute__((packed)) aBFu0i_I_B { unsigned int :0; int v1; bool v2; };
struct __attribute__((packed)) aBFu0i_Ip_B { unsigned int :0; int * v1; bool v2; };
struct __attribute__((packed)) aBFu0i_L_B { unsigned int :0; long long v1; bool v2; };
struct __attribute__((packed)) aBFu0i_S_B { unsigned int :0; short v1; bool v2; };
struct __attribute__((packed)) aBFu0i_Uc_B { unsigned int :0; unsigned char v1; bool v2; };
struct __attribute__((packed)) aBFu0i_Ui_B { unsigned int :0; unsigned int v1; bool v2; };
struct __attribute__((packed)) aBFu0i_Ul_B { unsigned int :0; unsigned long long v1; bool v2; };
struct __attribute__((packed)) aBFu0i_Us_B { unsigned int :0; unsigned short v1; bool v2; };
struct __attribute__((packed)) aBFu0i_Vp_B { unsigned int :0; void * v1; bool v2; };
struct __attribute__((packed)) aBFu0ll_B { unsigned long long :0; bool v1; };
struct __attribute__((packed)) aBFu0ll_B_B { unsigned long long :0; bool v1; bool v2; };
struct __attribute__((packed)) aBFu0ll_B_BFu0c { unsigned long long :0; bool v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0ll_B_BFu0i { unsigned long long :0; bool v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0ll_B_BFu0ll { unsigned long long :0; bool v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0ll_B_BFu0s { unsigned long long :0; bool v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0ll_B_BFu15i { unsigned long long :0; bool v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0ll_B_BFu15ll { unsigned long long :0; bool v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0ll_B_BFu15s { unsigned long long :0; bool v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0ll_B_BFu16i { unsigned long long :0; bool v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0ll_B_BFu16ll { unsigned long long :0; bool v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0ll_B_BFu16s { unsigned long long :0; bool v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0ll_B_BFu17i { unsigned long long :0; bool v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0ll_B_BFu17ll { unsigned long long :0; bool v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0ll_B_BFu1c { unsigned long long :0; bool v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0ll_B_BFu1i { unsigned long long :0; bool v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0ll_B_BFu1ll { unsigned long long :0; bool v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0ll_B_BFu1s { unsigned long long :0; bool v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0ll_B_BFu31i { unsigned long long :0; bool v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0ll_B_BFu31ll { unsigned long long :0; bool v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0ll_B_BFu32i { unsigned long long :0; bool v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0ll_B_BFu32ll { unsigned long long :0; bool v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0ll_B_BFu33 { unsigned long long :0; bool v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0ll_B_BFu7c { unsigned long long :0; bool v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0ll_B_BFu7i { unsigned long long :0; bool v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0ll_B_BFu7ll { unsigned long long :0; bool v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0ll_B_BFu7s { unsigned long long :0; bool v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0ll_B_BFu8c { unsigned long long :0; bool v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0ll_B_BFu8i { unsigned long long :0; bool v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0ll_B_BFu8ll { unsigned long long :0; bool v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0ll_B_BFu8s { unsigned long long :0; bool v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0ll_B_BFu9i { unsigned long long :0; bool v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0ll_B_BFu9ll { unsigned long long :0; bool v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0ll_B_BFu9s { unsigned long long :0; bool v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0ll_B_C { unsigned long long :0; bool v1; char v2; };
struct __attribute__((packed)) aBFu0ll_B_D { unsigned long long :0; bool v1; double v2; };
struct __attribute__((packed)) aBFu0ll_B_F { unsigned long long :0; bool v1; float v2; };
struct __attribute__((packed)) aBFu0ll_B_I { unsigned long long :0; bool v1; int v2; };
struct __attribute__((packed)) aBFu0ll_B_Ip { unsigned long long :0; bool v1; int * v2; };
struct __attribute__((packed)) aBFu0ll_B_L { unsigned long long :0; bool v1; long long v2; };
struct __attribute__((packed)) aBFu0ll_B_S { unsigned long long :0; bool v1; short v2; };
struct __attribute__((packed)) aBFu0ll_B_Uc { unsigned long long :0; bool v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0ll_B_Ui { unsigned long long :0; bool v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0ll_B_Ul { unsigned long long :0; bool v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0ll_B_Us { unsigned long long :0; bool v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0ll_B_Vp { unsigned long long :0; bool v1; void * v2; };
struct __attribute__((packed)) aBFu0ll_BFu0c_B { unsigned long long :0; unsigned char :0; bool v1; };
struct __attribute__((packed)) aBFu0ll_BFu0i_B { unsigned long long :0; unsigned int :0; bool v1; };
struct __attribute__((packed)) aBFu0ll_BFu0ll_B { unsigned long long :0; unsigned long long :0; bool v1; };
struct __attribute__((packed)) aBFu0ll_BFu0s_B { unsigned long long :0; unsigned short :0; bool v1; };
struct __attribute__((packed)) aBFu0ll_BFu15i_B { unsigned long long :0; unsigned int v1:15; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu15ll_B { unsigned long long :0; unsigned long long v1:15; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu15s_B { unsigned long long :0; unsigned short v1:15; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu16i_B { unsigned long long :0; unsigned int v1:16; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu16ll_B { unsigned long long :0; unsigned long long v1:16; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu16s_B { unsigned long long :0; unsigned short v1:16; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu17i_B { unsigned long long :0; unsigned int v1:17; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu17ll_B { unsigned long long :0; unsigned long long v1:17; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu1c_B { unsigned long long :0; unsigned char v1:1; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu1i_B { unsigned long long :0; unsigned int v1:1; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu1ll_B { unsigned long long :0; unsigned long long v1:1; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu1s_B { unsigned long long :0; unsigned short v1:1; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu31i_B { unsigned long long :0; unsigned int v1:31; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu31ll_B { unsigned long long :0; unsigned long long v1:31; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu32i_B { unsigned long long :0; unsigned int v1:32; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu32ll_B { unsigned long long :0; unsigned long long v1:32; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu33_B { unsigned long long :0; unsigned long long v1:33; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu7c_B { unsigned long long :0; unsigned char v1:7; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu7i_B { unsigned long long :0; unsigned int v1:7; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu7ll_B { unsigned long long :0; unsigned long long v1:7; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu7s_B { unsigned long long :0; unsigned short v1:7; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu8c_B { unsigned long long :0; unsigned char v1:8; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu8i_B { unsigned long long :0; unsigned int v1:8; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu8ll_B { unsigned long long :0; unsigned long long v1:8; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu8s_B { unsigned long long :0; unsigned short v1:8; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu9i_B { unsigned long long :0; unsigned int v1:9; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu9ll_B { unsigned long long :0; unsigned long long v1:9; bool v2; };
struct __attribute__((packed)) aBFu0ll_BFu9s_B { unsigned long long :0; unsigned short v1:9; bool v2; };
struct __attribute__((packed)) aBFu0ll_C_B { unsigned long long :0; char v1; bool v2; };
struct __attribute__((packed)) aBFu0ll_D_B { unsigned long long :0; double v1; bool v2; };
struct __attribute__((packed)) aBFu0ll_F_B { unsigned long long :0; float v1; bool v2; };
struct __attribute__((packed)) aBFu0ll_I_B { unsigned long long :0; int v1; bool v2; };
struct __attribute__((packed)) aBFu0ll_Ip_B { unsigned long long :0; int * v1; bool v2; };
struct __attribute__((packed)) aBFu0ll_L_B { unsigned long long :0; long long v1; bool v2; };
struct __attribute__((packed)) aBFu0ll_S_B { unsigned long long :0; short v1; bool v2; };
struct __attribute__((packed)) aBFu0ll_Uc_B { unsigned long long :0; unsigned char v1; bool v2; };
struct __attribute__((packed)) aBFu0ll_Ui_B { unsigned long long :0; unsigned int v1; bool v2; };
struct __attribute__((packed)) aBFu0ll_Ul_B { unsigned long long :0; unsigned long long v1; bool v2; };
struct __attribute__((packed)) aBFu0ll_Us_B { unsigned long long :0; unsigned short v1; bool v2; };
struct __attribute__((packed)) aBFu0ll_Vp_B { unsigned long long :0; void * v1; bool v2; };
struct __attribute__((packed)) aBFu0s_B { unsigned short :0; bool v1; };
struct __attribute__((packed)) aBFu0s_B_B { unsigned short :0; bool v1; bool v2; };
struct __attribute__((packed)) aBFu0s_B_BFu0c { unsigned short :0; bool v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0s_B_BFu0i { unsigned short :0; bool v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0s_B_BFu0ll { unsigned short :0; bool v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0s_B_BFu0s { unsigned short :0; bool v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0s_B_BFu15i { unsigned short :0; bool v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0s_B_BFu15ll { unsigned short :0; bool v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0s_B_BFu15s { unsigned short :0; bool v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0s_B_BFu16i { unsigned short :0; bool v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0s_B_BFu16ll { unsigned short :0; bool v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0s_B_BFu16s { unsigned short :0; bool v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0s_B_BFu17i { unsigned short :0; bool v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0s_B_BFu17ll { unsigned short :0; bool v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0s_B_BFu1c { unsigned short :0; bool v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0s_B_BFu1i { unsigned short :0; bool v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0s_B_BFu1ll { unsigned short :0; bool v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0s_B_BFu1s { unsigned short :0; bool v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0s_B_BFu31i { unsigned short :0; bool v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0s_B_BFu31ll { unsigned short :0; bool v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0s_B_BFu32i { unsigned short :0; bool v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0s_B_BFu32ll { unsigned short :0; bool v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0s_B_BFu33 { unsigned short :0; bool v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0s_B_BFu7c { unsigned short :0; bool v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0s_B_BFu7i { unsigned short :0; bool v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0s_B_BFu7ll { unsigned short :0; bool v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_B_BFu7s { unsigned short :0; bool v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_B_BFu8c { unsigned short :0; bool v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_B_BFu8i { unsigned short :0; bool v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_B_BFu8ll { unsigned short :0; bool v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_B_BFu8s { unsigned short :0; bool v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_B_BFu9i { unsigned short :0; bool v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_B_BFu9ll { unsigned short :0; bool v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_B_BFu9s { unsigned short :0; bool v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_B_C { unsigned short :0; bool v1; char v2; };
struct __attribute__((packed)) aBFu0s_B_D { unsigned short :0; bool v1; double v2; };
struct __attribute__((packed)) aBFu0s_B_F { unsigned short :0; bool v1; float v2; };
struct __attribute__((packed)) aBFu0s_B_I { unsigned short :0; bool v1; int v2; };
struct __attribute__((packed)) aBFu0s_B_Ip { unsigned short :0; bool v1; int * v2; };
struct __attribute__((packed)) aBFu0s_B_L { unsigned short :0; bool v1; long long v2; };
struct __attribute__((packed)) aBFu0s_B_S { unsigned short :0; bool v1; short v2; };
struct __attribute__((packed)) aBFu0s_B_Uc { unsigned short :0; bool v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_B_Ui { unsigned short :0; bool v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_B_Ul { unsigned short :0; bool v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_B_Us { unsigned short :0; bool v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_B_Vp { unsigned short :0; bool v1; void * v2; };
struct __attribute__((packed)) aBFu0s_BFu0c_B { unsigned short :0; unsigned char :0; bool v1; };
struct __attribute__((packed)) aBFu0s_BFu0i_B { unsigned short :0; unsigned int :0; bool v1; };
struct __attribute__((packed)) aBFu0s_BFu0ll_B { unsigned short :0; unsigned long long :0; bool v1; };
struct __attribute__((packed)) aBFu0s_BFu0s_B { unsigned short :0; unsigned short :0; bool v1; };
struct __attribute__((packed)) aBFu0s_BFu15i_B { unsigned short :0; unsigned int v1:15; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu15ll_B { unsigned short :0; unsigned long long v1:15; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu15s_B { unsigned short :0; unsigned short v1:15; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu16i_B { unsigned short :0; unsigned int v1:16; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu16ll_B { unsigned short :0; unsigned long long v1:16; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu16s_B { unsigned short :0; unsigned short v1:16; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu17i_B { unsigned short :0; unsigned int v1:17; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu17ll_B { unsigned short :0; unsigned long long v1:17; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu1c_B { unsigned short :0; unsigned char v1:1; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu1i_B { unsigned short :0; unsigned int v1:1; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu1ll_B { unsigned short :0; unsigned long long v1:1; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu1s_B { unsigned short :0; unsigned short v1:1; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu31i_B { unsigned short :0; unsigned int v1:31; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu31ll_B { unsigned short :0; unsigned long long v1:31; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu32i_B { unsigned short :0; unsigned int v1:32; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu32ll_B { unsigned short :0; unsigned long long v1:32; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu33_B { unsigned short :0; unsigned long long v1:33; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu7c_B { unsigned short :0; unsigned char v1:7; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu7i_B { unsigned short :0; unsigned int v1:7; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu7ll_B { unsigned short :0; unsigned long long v1:7; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu7s_B { unsigned short :0; unsigned short v1:7; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu8c_B { unsigned short :0; unsigned char v1:8; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu8i_B { unsigned short :0; unsigned int v1:8; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu8ll_B { unsigned short :0; unsigned long long v1:8; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu8s_B { unsigned short :0; unsigned short v1:8; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu9i_B { unsigned short :0; unsigned int v1:9; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu9ll_B { unsigned short :0; unsigned long long v1:9; bool v2; };
struct __attribute__((packed)) aBFu0s_BFu9s_B { unsigned short :0; unsigned short v1:9; bool v2; };
struct __attribute__((packed)) aBFu0s_C_B { unsigned short :0; char v1; bool v2; };
struct __attribute__((packed)) aBFu0s_D_B { unsigned short :0; double v1; bool v2; };
struct __attribute__((packed)) aBFu0s_F_B { unsigned short :0; float v1; bool v2; };
struct __attribute__((packed)) aBFu0s_I_B { unsigned short :0; int v1; bool v2; };
struct __attribute__((packed)) aBFu0s_Ip_B { unsigned short :0; int * v1; bool v2; };
struct __attribute__((packed)) aBFu0s_L_B { unsigned short :0; long long v1; bool v2; };
struct __attribute__((packed)) aBFu0s_S_B { unsigned short :0; short v1; bool v2; };
struct __attribute__((packed)) aBFu0s_Uc_B { unsigned short :0; unsigned char v1; bool v2; };
struct __attribute__((packed)) aBFu0s_Ui_B { unsigned short :0; unsigned int v1; bool v2; };
struct __attribute__((packed)) aBFu0s_Ul_B { unsigned short :0; unsigned long long v1; bool v2; };
struct __attribute__((packed)) aBFu0s_Us_B { unsigned short :0; unsigned short v1; bool v2; };
struct __attribute__((packed)) aBFu0s_Vp_B { unsigned short :0; void * v1; bool v2; };
struct __attribute__((packed)) aBFu15i_B_BFu0c { unsigned int v1:15; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_B_BFu0i { unsigned int v1:15; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_B_BFu0ll { unsigned int v1:15; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_B_BFu0s { unsigned int v1:15; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu0c_B { unsigned int v1:15; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu15i_BFu0i_B { unsigned int v1:15; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll_B { unsigned int v1:15; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu15i_BFu0s_B { unsigned int v1:15; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu15ll_B_BFu0c { unsigned long long v1:15; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_B_BFu0i { unsigned long long v1:15; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_B_BFu0ll { unsigned long long v1:15; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_B_BFu0s { unsigned long long v1:15; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu0c_B { unsigned long long v1:15; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i_B { unsigned long long v1:15; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_B { unsigned long long v1:15; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s_B { unsigned long long v1:15; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu15s_B_BFu0c { unsigned short v1:15; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_B_BFu0i { unsigned short v1:15; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_B_BFu0ll { unsigned short v1:15; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_B_BFu0s { unsigned short v1:15; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu0c_B { unsigned short v1:15; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu15s_BFu0i_B { unsigned short v1:15; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll_B { unsigned short v1:15; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu15s_BFu0s_B { unsigned short v1:15; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu16i_B_BFu0c { unsigned int v1:16; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_B_BFu0i { unsigned int v1:16; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_B_BFu0ll { unsigned int v1:16; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_B_BFu0s { unsigned int v1:16; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu0c_B { unsigned int v1:16; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu16i_BFu0i_B { unsigned int v1:16; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll_B { unsigned int v1:16; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu16i_BFu0s_B { unsigned int v1:16; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu16ll_B_BFu0c { unsigned long long v1:16; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_B_BFu0i { unsigned long long v1:16; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_B_BFu0ll { unsigned long long v1:16; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_B_BFu0s { unsigned long long v1:16; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu0c_B { unsigned long long v1:16; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i_B { unsigned long long v1:16; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_B { unsigned long long v1:16; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s_B { unsigned long long v1:16; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu16s_B_BFu0c { unsigned short v1:16; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_B_BFu0i { unsigned short v1:16; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_B_BFu0ll { unsigned short v1:16; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_B_BFu0s { unsigned short v1:16; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu0c_B { unsigned short v1:16; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu16s_BFu0i_B { unsigned short v1:16; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll_B { unsigned short v1:16; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu16s_BFu0s_B { unsigned short v1:16; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu17i_B_BFu0c { unsigned int v1:17; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_B_BFu0i { unsigned int v1:17; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_B_BFu0ll { unsigned int v1:17; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_B_BFu0s { unsigned int v1:17; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu0c_B { unsigned int v1:17; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu17i_BFu0i_B { unsigned int v1:17; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll_B { unsigned int v1:17; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu17i_BFu0s_B { unsigned int v1:17; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu17ll_B_BFu0c { unsigned long long v1:17; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17ll_B_BFu0i { unsigned long long v1:17; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17ll_B_BFu0ll { unsigned long long v1:17; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17ll_B_BFu0s { unsigned long long v1:17; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17ll_BFu0c_B { unsigned long long v1:17; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i_B { unsigned long long v1:17; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_B { unsigned long long v1:17; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu17ll_BFu0s_B { unsigned long long v1:17; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu1c_B_BFu0c { unsigned char v1:1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu1c_B_BFu0i { unsigned char v1:1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu1c_B_BFu0ll { unsigned char v1:1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu1c_B_BFu0s { unsigned char v1:1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu1c_BFu0c_B { unsigned char v1:1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu1c_BFu0i_B { unsigned char v1:1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu1c_BFu0ll_B { unsigned char v1:1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu1c_BFu0s_B { unsigned char v1:1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu1i_B_BFu0c { unsigned int v1:1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu1i_B_BFu0i { unsigned int v1:1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu1i_B_BFu0ll { unsigned int v1:1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu1i_B_BFu0s { unsigned int v1:1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu1i_BFu0c_B { unsigned int v1:1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu1i_BFu0i_B { unsigned int v1:1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu1i_BFu0ll_B { unsigned int v1:1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu1i_BFu0s_B { unsigned int v1:1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu1ll_B_BFu0c { unsigned long long v1:1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu1ll_B_BFu0i { unsigned long long v1:1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu1ll_B_BFu0ll { unsigned long long v1:1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu1ll_B_BFu0s { unsigned long long v1:1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu1ll_BFu0c_B { unsigned long long v1:1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu1ll_BFu0i_B { unsigned long long v1:1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu1ll_BFu0ll_B { unsigned long long v1:1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu1ll_BFu0s_B { unsigned long long v1:1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu1s_B_BFu0c { unsigned short v1:1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu1s_B_BFu0i { unsigned short v1:1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu1s_B_BFu0ll { unsigned short v1:1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu1s_B_BFu0s { unsigned short v1:1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu1s_BFu0c_B { unsigned short v1:1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu1s_BFu0i_B { unsigned short v1:1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu1s_BFu0ll_B { unsigned short v1:1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu1s_BFu0s_B { unsigned short v1:1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu31i_B_BFu0c { unsigned int v1:31; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu31i_B_BFu0i { unsigned int v1:31; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu31i_B_BFu0ll { unsigned int v1:31; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu31i_B_BFu0s { unsigned int v1:31; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu31i_BFu0c_B { unsigned int v1:31; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu31i_BFu0i_B { unsigned int v1:31; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu31i_BFu0ll_B { unsigned int v1:31; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu31i_BFu0s_B { unsigned int v1:31; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu31ll_B_BFu0c { unsigned long long v1:31; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu31ll_B_BFu0i { unsigned long long v1:31; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu31ll_B_BFu0ll { unsigned long long v1:31; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu31ll_B_BFu0s { unsigned long long v1:31; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu31ll_BFu0c_B { unsigned long long v1:31; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu31ll_BFu0i_B { unsigned long long v1:31; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu31ll_BFu0ll_B { unsigned long long v1:31; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu31ll_BFu0s_B { unsigned long long v1:31; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu32i_B_BFu0c { unsigned int v1:32; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu32i_B_BFu0i { unsigned int v1:32; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu32i_B_BFu0ll { unsigned int v1:32; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu32i_B_BFu0s { unsigned int v1:32; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu32i_BFu0c_B { unsigned int v1:32; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu32i_BFu0i_B { unsigned int v1:32; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu32i_BFu0ll_B { unsigned int v1:32; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu32i_BFu0s_B { unsigned int v1:32; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu32ll_B_BFu0c { unsigned long long v1:32; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu32ll_B_BFu0i { unsigned long long v1:32; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu32ll_B_BFu0ll { unsigned long long v1:32; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu32ll_B_BFu0s { unsigned long long v1:32; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu32ll_BFu0c_B { unsigned long long v1:32; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu32ll_BFu0i_B { unsigned long long v1:32; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu32ll_BFu0ll_B { unsigned long long v1:32; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu32ll_BFu0s_B { unsigned long long v1:32; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu33_B_BFu0c { unsigned long long v1:33; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu33_B_BFu0i { unsigned long long v1:33; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu33_B_BFu0ll { unsigned long long v1:33; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu33_B_BFu0s { unsigned long long v1:33; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu33_BFu0c_B { unsigned long long v1:33; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu33_BFu0i_B { unsigned long long v1:33; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu33_BFu0ll_B { unsigned long long v1:33; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu33_BFu0s_B { unsigned long long v1:33; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu7c_B_BFu0c { unsigned char v1:7; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu7c_B_BFu0i { unsigned char v1:7; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu7c_B_BFu0ll { unsigned char v1:7; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu7c_B_BFu0s { unsigned char v1:7; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu7c_BFu0c_B { unsigned char v1:7; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu7c_BFu0i_B { unsigned char v1:7; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu7c_BFu0ll_B { unsigned char v1:7; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu7c_BFu0s_B { unsigned char v1:7; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu7i_B_BFu0c { unsigned int v1:7; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu7i_B_BFu0i { unsigned int v1:7; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu7i_B_BFu0ll { unsigned int v1:7; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu7i_B_BFu0s { unsigned int v1:7; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu7i_BFu0c_B { unsigned int v1:7; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu7i_BFu0i_B { unsigned int v1:7; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu7i_BFu0ll_B { unsigned int v1:7; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu7i_BFu0s_B { unsigned int v1:7; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu7ll_B_BFu0c { unsigned long long v1:7; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu7ll_B_BFu0i { unsigned long long v1:7; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu7ll_B_BFu0ll { unsigned long long v1:7; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu7ll_B_BFu0s { unsigned long long v1:7; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu7ll_BFu0c_B { unsigned long long v1:7; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu7ll_BFu0i_B { unsigned long long v1:7; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu7ll_BFu0ll_B { unsigned long long v1:7; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu7ll_BFu0s_B { unsigned long long v1:7; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu7s_B_BFu0c { unsigned short v1:7; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu7s_B_BFu0i { unsigned short v1:7; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu7s_B_BFu0ll { unsigned short v1:7; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu7s_B_BFu0s { unsigned short v1:7; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu7s_BFu0c_B { unsigned short v1:7; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu7s_BFu0i_B { unsigned short v1:7; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu7s_BFu0ll_B { unsigned short v1:7; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu7s_BFu0s_B { unsigned short v1:7; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu8c_B_BFu0c { unsigned char v1:8; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu8c_B_BFu0i { unsigned char v1:8; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu8c_B_BFu0ll { unsigned char v1:8; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu8c_B_BFu0s { unsigned char v1:8; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu8c_BFu0c_B { unsigned char v1:8; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu8c_BFu0i_B { unsigned char v1:8; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu8c_BFu0ll_B { unsigned char v1:8; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu8c_BFu0s_B { unsigned char v1:8; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu8i_B_BFu0c { unsigned int v1:8; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu8i_B_BFu0i { unsigned int v1:8; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu8i_B_BFu0ll { unsigned int v1:8; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu8i_B_BFu0s { unsigned int v1:8; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu8i_BFu0c_B { unsigned int v1:8; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu8i_BFu0i_B { unsigned int v1:8; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu8i_BFu0ll_B { unsigned int v1:8; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu8i_BFu0s_B { unsigned int v1:8; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu8ll_B_BFu0c { unsigned long long v1:8; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu8ll_B_BFu0i { unsigned long long v1:8; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu8ll_B_BFu0ll { unsigned long long v1:8; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu8ll_B_BFu0s { unsigned long long v1:8; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu8ll_BFu0c_B { unsigned long long v1:8; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu8ll_BFu0i_B { unsigned long long v1:8; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu8ll_BFu0ll_B { unsigned long long v1:8; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu8ll_BFu0s_B { unsigned long long v1:8; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu8s_B_BFu0c { unsigned short v1:8; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu8s_B_BFu0i { unsigned short v1:8; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu8s_B_BFu0ll { unsigned short v1:8; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu8s_B_BFu0s { unsigned short v1:8; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu8s_BFu0c_B { unsigned short v1:8; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu8s_BFu0i_B { unsigned short v1:8; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu8s_BFu0ll_B { unsigned short v1:8; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu8s_BFu0s_B { unsigned short v1:8; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu9i_B_BFu0c { unsigned int v1:9; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu9i_B_BFu0i { unsigned int v1:9; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu9i_B_BFu0ll { unsigned int v1:9; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu9i_B_BFu0s { unsigned int v1:9; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu9i_BFu0c_B { unsigned int v1:9; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu9i_BFu0i_B { unsigned int v1:9; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu9i_BFu0ll_B { unsigned int v1:9; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu9i_BFu0s_B { unsigned int v1:9; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu9ll_B_BFu0c { unsigned long long v1:9; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu9ll_B_BFu0i { unsigned long long v1:9; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu9ll_B_BFu0ll { unsigned long long v1:9; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu9ll_B_BFu0s { unsigned long long v1:9; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu9ll_BFu0c_B { unsigned long long v1:9; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu9ll_BFu0i_B { unsigned long long v1:9; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu9ll_BFu0ll_B { unsigned long long v1:9; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu9ll_BFu0s_B { unsigned long long v1:9; unsigned short :0; bool v2; };
struct __attribute__((packed)) aBFu9s_B_BFu0c { unsigned short v1:9; bool v2; unsigned char :0; };
struct __attribute__((packed)) aBFu9s_B_BFu0i { unsigned short v1:9; bool v2; unsigned int :0; };
struct __attribute__((packed)) aBFu9s_B_BFu0ll { unsigned short v1:9; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu9s_B_BFu0s { unsigned short v1:9; bool v2; unsigned short :0; };
struct __attribute__((packed)) aBFu9s_BFu0c_B { unsigned short v1:9; unsigned char :0; bool v2; };
struct __attribute__((packed)) aBFu9s_BFu0i_B { unsigned short v1:9; unsigned int :0; bool v2; };
struct __attribute__((packed)) aBFu9s_BFu0ll_B { unsigned short v1:9; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aBFu9s_BFu0s_B { unsigned short v1:9; unsigned short :0; bool v2; };
struct __attribute__((packed)) aC_B_BFu0c { char v1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aC_B_BFu0i { char v1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aC_B_BFu0ll { char v1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aC_B_BFu0s { char v1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aC_BFu0c_B { char v1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aC_BFu0i_B { char v1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aC_BFu0ll_B { char v1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aC_BFu0s_B { char v1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aD_B_BFu0c { double v1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aD_B_BFu0i { double v1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aD_B_BFu0ll { double v1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aD_B_BFu0s { double v1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aD_BFu0c_B { double v1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aD_BFu0i_B { double v1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aD_BFu0ll_B { double v1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aD_BFu0s_B { double v1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aF_B_BFu0c { float v1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aF_B_BFu0i { float v1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aF_B_BFu0ll { float v1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aF_B_BFu0s { float v1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aF_BFu0c_B { float v1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aF_BFu0i_B { float v1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aF_BFu0ll_B { float v1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aF_BFu0s_B { float v1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aI_B_BFu0c { int v1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aI_B_BFu0i { int v1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aI_B_BFu0ll { int v1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aI_B_BFu0s { int v1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aI_BFu0c_B { int v1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aI_BFu0i_B { int v1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aI_BFu0ll_B { int v1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aI_BFu0s_B { int v1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aIp_B_BFu0c { int * v1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aIp_B_BFu0i { int * v1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aIp_B_BFu0ll { int * v1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aIp_B_BFu0s { int * v1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aIp_BFu0c_B { int * v1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aIp_BFu0i_B { int * v1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aIp_BFu0ll_B { int * v1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aIp_BFu0s_B { int * v1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aL_B_BFu0c { long long v1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aL_B_BFu0i { long long v1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aL_B_BFu0ll { long long v1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aL_B_BFu0s { long long v1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aL_BFu0c_B { long long v1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aL_BFu0i_B { long long v1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aL_BFu0ll_B { long long v1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aL_BFu0s_B { long long v1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aS_B_BFu0c { short v1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aS_B_BFu0i { short v1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aS_B_BFu0ll { short v1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aS_B_BFu0s { short v1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aS_BFu0c_B { short v1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aS_BFu0i_B { short v1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aS_BFu0ll_B { short v1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aS_BFu0s_B { short v1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aUc_B_BFu0c { unsigned char v1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aUc_B_BFu0i { unsigned char v1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aUc_B_BFu0ll { unsigned char v1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_B_BFu0s { unsigned char v1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu0c_B { unsigned char v1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aUc_BFu0i_B { unsigned char v1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aUc_BFu0ll_B { unsigned char v1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aUc_BFu0s_B { unsigned char v1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aUi_B_BFu0c { unsigned int v1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aUi_B_BFu0i { unsigned int v1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aUi_B_BFu0ll { unsigned int v1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_B_BFu0s { unsigned int v1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu0c_B { unsigned int v1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aUi_BFu0i_B { unsigned int v1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aUi_BFu0ll_B { unsigned int v1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aUi_BFu0s_B { unsigned int v1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aUl_B_BFu0c { unsigned long long v1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aUl_B_BFu0i { unsigned long long v1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aUl_B_BFu0ll { unsigned long long v1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_B_BFu0s { unsigned long long v1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu0c_B { unsigned long long v1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aUl_BFu0i_B { unsigned long long v1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aUl_BFu0ll_B { unsigned long long v1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aUl_BFu0s_B { unsigned long long v1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aUs_B_BFu0c { unsigned short v1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aUs_B_BFu0i { unsigned short v1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aUs_B_BFu0ll { unsigned short v1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_B_BFu0s { unsigned short v1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu0c_B { unsigned short v1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aUs_BFu0i_B { unsigned short v1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aUs_BFu0ll_B { unsigned short v1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aUs_BFu0s_B { unsigned short v1; unsigned short :0; bool v2; };
struct __attribute__((packed)) aVp_B_BFu0c { void * v1; bool v2; unsigned char :0; };
struct __attribute__((packed)) aVp_B_BFu0i { void * v1; bool v2; unsigned int :0; };
struct __attribute__((packed)) aVp_B_BFu0ll { void * v1; bool v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_B_BFu0s { void * v1; bool v2; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu0c_B { void * v1; unsigned char :0; bool v2; };
struct __attribute__((packed)) aVp_BFu0i_B { void * v1; unsigned int :0; bool v2; };
struct __attribute__((packed)) aVp_BFu0ll_B { void * v1; unsigned long long :0; bool v2; };
struct __attribute__((packed)) aVp_BFu0s_B { void * v1; unsigned short :0; bool v2; };
#pragma pack(1)
struct B_B_BFu0c { bool v1; bool v2; unsigned char :0; };
struct B_B_BFu0i { bool v1; bool v2; unsigned int :0; };
struct B_B_BFu0ll { bool v1; bool v2; unsigned long long :0; };
struct B_B_BFu0s { bool v1; bool v2; unsigned short :0; };
struct B_BFu0c { bool v1; unsigned char :0; };
struct B_BFu0c_B { bool v1; unsigned char :0; bool v2; };
struct B_BFu0c_BFu0c { bool v1; unsigned char :0; unsigned char :0; };
struct B_BFu0c_BFu0i { bool v1; unsigned char :0; unsigned int :0; };
struct B_BFu0c_BFu0ll { bool v1; unsigned char :0; unsigned long long :0; };
struct B_BFu0c_BFu0s { bool v1; unsigned char :0; unsigned short :0; };
struct B_BFu0c_BFu15i { bool v1; unsigned char :0; unsigned int v2:15; };
struct B_BFu0c_BFu15ll { bool v1; unsigned char :0; unsigned long long v2:15; };
struct B_BFu0c_BFu15s { bool v1; unsigned char :0; unsigned short v2:15; };
struct B_BFu0c_BFu16i { bool v1; unsigned char :0; unsigned int v2:16; };
struct B_BFu0c_BFu16ll { bool v1; unsigned char :0; unsigned long long v2:16; };
struct B_BFu0c_BFu16s { bool v1; unsigned char :0; unsigned short v2:16; };
struct B_BFu0c_BFu17i { bool v1; unsigned char :0; unsigned int v2:17; };
struct B_BFu0c_BFu17ll { bool v1; unsigned char :0; unsigned long long v2:17; };
struct B_BFu0c_BFu1c { bool v1; unsigned char :0; unsigned char v2:1; };
struct B_BFu0c_BFu1i { bool v1; unsigned char :0; unsigned int v2:1; };
struct B_BFu0c_BFu1ll { bool v1; unsigned char :0; unsigned long long v2:1; };
struct B_BFu0c_BFu1s { bool v1; unsigned char :0; unsigned short v2:1; };
struct B_BFu0c_BFu31i { bool v1; unsigned char :0; unsigned int v2:31; };
struct B_BFu0c_BFu31ll { bool v1; unsigned char :0; unsigned long long v2:31; };
struct B_BFu0c_BFu32i { bool v1; unsigned char :0; unsigned int v2:32; };
struct B_BFu0c_BFu32ll { bool v1; unsigned char :0; unsigned long long v2:32; };
struct B_BFu0c_BFu33 { bool v1; unsigned char :0; unsigned long long v2:33; };
struct B_BFu0c_BFu7c { bool v1; unsigned char :0; unsigned char v2:7; };
struct B_BFu0c_BFu7i { bool v1; unsigned char :0; unsigned int v2:7; };
struct B_BFu0c_BFu7ll { bool v1; unsigned char :0; unsigned long long v2:7; };
struct B_BFu0c_BFu7s { bool v1; unsigned char :0; unsigned short v2:7; };
struct B_BFu0c_BFu8c { bool v1; unsigned char :0; unsigned char v2:8; };
struct B_BFu0c_BFu8i { bool v1; unsigned char :0; unsigned int v2:8; };
struct B_BFu0c_BFu8ll { bool v1; unsigned char :0; unsigned long long v2:8; };
struct B_BFu0c_BFu8s { bool v1; unsigned char :0; unsigned short v2:8; };
struct B_BFu0c_BFu9i { bool v1; unsigned char :0; unsigned int v2:9; };
struct B_BFu0c_BFu9ll { bool v1; unsigned char :0; unsigned long long v2:9; };
struct B_BFu0c_BFu9s { bool v1; unsigned char :0; unsigned short v2:9; };
struct B_BFu0c_C { bool v1; unsigned char :0; char v2; };
struct B_BFu0c_D { bool v1; unsigned char :0; double v2; };
struct B_BFu0c_F { bool v1; unsigned char :0; float v2; };
struct B_BFu0c_I { bool v1; unsigned char :0; int v2; };
struct B_BFu0c_Ip { bool v1; unsigned char :0; int * v2; };
struct B_BFu0c_L { bool v1; unsigned char :0; long long v2; };
struct B_BFu0c_S { bool v1; unsigned char :0; short v2; };
struct B_BFu0c_Uc { bool v1; unsigned char :0; unsigned char v2; };
struct B_BFu0c_Ui { bool v1; unsigned char :0; unsigned int v2; };
struct B_BFu0c_Ul { bool v1; unsigned char :0; unsigned long long v2; };
struct B_BFu0c_Us { bool v1; unsigned char :0; unsigned short v2; };
struct B_BFu0c_Vp { bool v1; unsigned char :0; void * v2; };
struct B_BFu0i { bool v1; unsigned int :0; };
struct B_BFu0i_B { bool v1; unsigned int :0; bool v2; };
struct B_BFu0i_BFu0c { bool v1; unsigned int :0; unsigned char :0; };
struct B_BFu0i_BFu0i { bool v1; unsigned int :0; unsigned int :0; };
struct B_BFu0i_BFu0ll { bool v1; unsigned int :0; unsigned long long :0; };
struct B_BFu0i_BFu0s { bool v1; unsigned int :0; unsigned short :0; };
struct B_BFu0i_BFu15i { bool v1; unsigned int :0; unsigned int v2:15; };
struct B_BFu0i_BFu15ll { bool v1; unsigned int :0; unsigned long long v2:15; };
struct B_BFu0i_BFu15s { bool v1; unsigned int :0; unsigned short v2:15; };
struct B_BFu0i_BFu16i { bool v1; unsigned int :0; unsigned int v2:16; };
struct B_BFu0i_BFu16ll { bool v1; unsigned int :0; unsigned long long v2:16; };
struct B_BFu0i_BFu16s { bool v1; unsigned int :0; unsigned short v2:16; };
struct B_BFu0i_BFu17i { bool v1; unsigned int :0; unsigned int v2:17; };
struct B_BFu0i_BFu17ll { bool v1; unsigned int :0; unsigned long long v2:17; };
struct B_BFu0i_BFu1c { bool v1; unsigned int :0; unsigned char v2:1; };
struct B_BFu0i_BFu1i { bool v1; unsigned int :0; unsigned int v2:1; };
struct B_BFu0i_BFu1ll { bool v1; unsigned int :0; unsigned long long v2:1; };
struct B_BFu0i_BFu1s { bool v1; unsigned int :0; unsigned short v2:1; };
struct B_BFu0i_BFu31i { bool v1; unsigned int :0; unsigned int v2:31; };
struct B_BFu0i_BFu31ll { bool v1; unsigned int :0; unsigned long long v2:31; };
struct B_BFu0i_BFu32i { bool v1; unsigned int :0; unsigned int v2:32; };
struct B_BFu0i_BFu32ll { bool v1; unsigned int :0; unsigned long long v2:32; };
struct B_BFu0i_BFu33 { bool v1; unsigned int :0; unsigned long long v2:33; };
struct B_BFu0i_BFu7c { bool v1; unsigned int :0; unsigned char v2:7; };
struct B_BFu0i_BFu7i { bool v1; unsigned int :0; unsigned int v2:7; };
struct B_BFu0i_BFu7ll { bool v1; unsigned int :0; unsigned long long v2:7; };
struct B_BFu0i_BFu7s { bool v1; unsigned int :0; unsigned short v2:7; };
struct B_BFu0i_BFu8c { bool v1; unsigned int :0; unsigned char v2:8; };
struct B_BFu0i_BFu8i { bool v1; unsigned int :0; unsigned int v2:8; };
struct B_BFu0i_BFu8ll { bool v1; unsigned int :0; unsigned long long v2:8; };
struct B_BFu0i_BFu8s { bool v1; unsigned int :0; unsigned short v2:8; };
struct B_BFu0i_BFu9i { bool v1; unsigned int :0; unsigned int v2:9; };
struct B_BFu0i_BFu9ll { bool v1; unsigned int :0; unsigned long long v2:9; };
struct B_BFu0i_BFu9s { bool v1; unsigned int :0; unsigned short v2:9; };
struct B_BFu0i_C { bool v1; unsigned int :0; char v2; };
struct B_BFu0i_D { bool v1; unsigned int :0; double v2; };
struct B_BFu0i_F { bool v1; unsigned int :0; float v2; };
struct B_BFu0i_I { bool v1; unsigned int :0; int v2; };
struct B_BFu0i_Ip { bool v1; unsigned int :0; int * v2; };
struct B_BFu0i_L { bool v1; unsigned int :0; long long v2; };
struct B_BFu0i_S { bool v1; unsigned int :0; short v2; };
struct B_BFu0i_Uc { bool v1; unsigned int :0; unsigned char v2; };
struct B_BFu0i_Ui { bool v1; unsigned int :0; unsigned int v2; };
struct B_BFu0i_Ul { bool v1; unsigned int :0; unsigned long long v2; };
struct B_BFu0i_Us { bool v1; unsigned int :0; unsigned short v2; };
struct B_BFu0i_Vp { bool v1; unsigned int :0; void * v2; };
struct B_BFu0ll { bool v1; unsigned long long :0; };
struct B_BFu0ll_B { bool v1; unsigned long long :0; bool v2; };
struct B_BFu0ll_BFu0c { bool v1; unsigned long long :0; unsigned char :0; };
struct B_BFu0ll_BFu0i { bool v1; unsigned long long :0; unsigned int :0; };
struct B_BFu0ll_BFu0ll { bool v1; unsigned long long :0; unsigned long long :0; };
struct B_BFu0ll_BFu0s { bool v1; unsigned long long :0; unsigned short :0; };
struct B_BFu0ll_BFu15i { bool v1; unsigned long long :0; unsigned int v2:15; };
struct B_BFu0ll_BFu15ll { bool v1; unsigned long long :0; unsigned long long v2:15; };
struct B_BFu0ll_BFu15s { bool v1; unsigned long long :0; unsigned short v2:15; };
struct B_BFu0ll_BFu16i { bool v1; unsigned long long :0; unsigned int v2:16; };
struct B_BFu0ll_BFu16ll { bool v1; unsigned long long :0; unsigned long long v2:16; };
struct B_BFu0ll_BFu16s { bool v1; unsigned long long :0; unsigned short v2:16; };
struct B_BFu0ll_BFu17i { bool v1; unsigned long long :0; unsigned int v2:17; };
struct B_BFu0ll_BFu17ll { bool v1; unsigned long long :0; unsigned long long v2:17; };
struct B_BFu0ll_BFu1c { bool v1; unsigned long long :0; unsigned char v2:1; };
struct B_BFu0ll_BFu1i { bool v1; unsigned long long :0; unsigned int v2:1; };
struct B_BFu0ll_BFu1ll { bool v1; unsigned long long :0; unsigned long long v2:1; };
struct B_BFu0ll_BFu1s { bool v1; unsigned long long :0; unsigned short v2:1; };
struct B_BFu0ll_BFu31i { bool v1; unsigned long long :0; unsigned int v2:31; };
struct B_BFu0ll_BFu31ll { bool v1; unsigned long long :0; unsigned long long v2:31; };
struct B_BFu0ll_BFu32i { bool v1; unsigned long long :0; unsigned int v2:32; };
struct B_BFu0ll_BFu32ll { bool v1; unsigned long long :0; unsigned long long v2:32; };
struct B_BFu0ll_BFu33 { bool v1; unsigned long long :0; unsigned long long v2:33; };
struct B_BFu0ll_BFu7c { bool v1; unsigned long long :0; unsigned char v2:7; };
struct B_BFu0ll_BFu7i { bool v1; unsigned long long :0; unsigned int v2:7; };
struct B_BFu0ll_BFu7ll { bool v1; unsigned long long :0; unsigned long long v2:7; };
struct B_BFu0ll_BFu7s { bool v1; unsigned long long :0; unsigned short v2:7; };
struct B_BFu0ll_BFu8c { bool v1; unsigned long long :0; unsigned char v2:8; };
struct B_BFu0ll_BFu8i { bool v1; unsigned long long :0; unsigned int v2:8; };
struct B_BFu0ll_BFu8ll { bool v1; unsigned long long :0; unsigned long long v2:8; };
struct B_BFu0ll_BFu8s { bool v1; unsigned long long :0; unsigned short v2:8; };
struct B_BFu0ll_BFu9i { bool v1; unsigned long long :0; unsigned int v2:9; };
struct B_BFu0ll_BFu9ll { bool v1; unsigned long long :0; unsigned long long v2:9; };
struct B_BFu0ll_BFu9s { bool v1; unsigned long long :0; unsigned short v2:9; };
struct B_BFu0ll_C { bool v1; unsigned long long :0; char v2; };
struct B_BFu0ll_D { bool v1; unsigned long long :0; double v2; };
struct B_BFu0ll_F { bool v1; unsigned long long :0; float v2; };
struct B_BFu0ll_I { bool v1; unsigned long long :0; int v2; };
struct B_BFu0ll_Ip { bool v1; unsigned long long :0; int * v2; };
struct B_BFu0ll_L { bool v1; unsigned long long :0; long long v2; };
struct B_BFu0ll_S { bool v1; unsigned long long :0; short v2; };
struct B_BFu0ll_Uc { bool v1; unsigned long long :0; unsigned char v2; };
struct B_BFu0ll_Ui { bool v1; unsigned long long :0; unsigned int v2; };
struct B_BFu0ll_Ul { bool v1; unsigned long long :0; unsigned long long v2; };
struct B_BFu0ll_Us { bool v1; unsigned long long :0; unsigned short v2; };
struct B_BFu0ll_Vp { bool v1; unsigned long long :0; void * v2; };
struct B_BFu0s { bool v1; unsigned short :0; };
struct B_BFu0s_B { bool v1; unsigned short :0; bool v2; };
struct B_BFu0s_BFu0c { bool v1; unsigned short :0; unsigned char :0; };
struct B_BFu0s_BFu0i { bool v1; unsigned short :0; unsigned int :0; };
struct B_BFu0s_BFu0ll { bool v1; unsigned short :0; unsigned long long :0; };
struct B_BFu0s_BFu0s { bool v1; unsigned short :0; unsigned short :0; };
struct B_BFu0s_BFu15i { bool v1; unsigned short :0; unsigned int v2:15; };
struct B_BFu0s_BFu15ll { bool v1; unsigned short :0; unsigned long long v2:15; };
struct B_BFu0s_BFu15s { bool v1; unsigned short :0; unsigned short v2:15; };
struct B_BFu0s_BFu16i { bool v1; unsigned short :0; unsigned int v2:16; };
struct B_BFu0s_BFu16ll { bool v1; unsigned short :0; unsigned long long v2:16; };
struct B_BFu0s_BFu16s { bool v1; unsigned short :0; unsigned short v2:16; };
struct B_BFu0s_BFu17i { bool v1; unsigned short :0; unsigned int v2:17; };
struct B_BFu0s_BFu17ll { bool v1; unsigned short :0; unsigned long long v2:17; };
struct B_BFu0s_BFu1c { bool v1; unsigned short :0; unsigned char v2:1; };
struct B_BFu0s_BFu1i { bool v1; unsigned short :0; unsigned int v2:1; };
struct B_BFu0s_BFu1ll { bool v1; unsigned short :0; unsigned long long v2:1; };
struct B_BFu0s_BFu1s { bool v1; unsigned short :0; unsigned short v2:1; };
struct B_BFu0s_BFu31i { bool v1; unsigned short :0; unsigned int v2:31; };
struct B_BFu0s_BFu31ll { bool v1; unsigned short :0; unsigned long long v2:31; };
struct B_BFu0s_BFu32i { bool v1; unsigned short :0; unsigned int v2:32; };
struct B_BFu0s_BFu32ll { bool v1; unsigned short :0; unsigned long long v2:32; };
struct B_BFu0s_BFu33 { bool v1; unsigned short :0; unsigned long long v2:33; };
struct B_BFu0s_BFu7c { bool v1; unsigned short :0; unsigned char v2:7; };
struct B_BFu0s_BFu7i { bool v1; unsigned short :0; unsigned int v2:7; };
struct B_BFu0s_BFu7ll { bool v1; unsigned short :0; unsigned long long v2:7; };
struct B_BFu0s_BFu7s { bool v1; unsigned short :0; unsigned short v2:7; };
struct B_BFu0s_BFu8c { bool v1; unsigned short :0; unsigned char v2:8; };
struct B_BFu0s_BFu8i { bool v1; unsigned short :0; unsigned int v2:8; };
struct B_BFu0s_BFu8ll { bool v1; unsigned short :0; unsigned long long v2:8; };
struct B_BFu0s_BFu8s { bool v1; unsigned short :0; unsigned short v2:8; };
struct B_BFu0s_BFu9i { bool v1; unsigned short :0; unsigned int v2:9; };
struct B_BFu0s_BFu9ll { bool v1; unsigned short :0; unsigned long long v2:9; };
struct B_BFu0s_BFu9s { bool v1; unsigned short :0; unsigned short v2:9; };
struct B_BFu0s_C { bool v1; unsigned short :0; char v2; };
struct B_BFu0s_D { bool v1; unsigned short :0; double v2; };
struct B_BFu0s_F { bool v1; unsigned short :0; float v2; };
struct B_BFu0s_I { bool v1; unsigned short :0; int v2; };
struct B_BFu0s_Ip { bool v1; unsigned short :0; int * v2; };
struct B_BFu0s_L { bool v1; unsigned short :0; long long v2; };
struct B_BFu0s_S { bool v1; unsigned short :0; short v2; };
struct B_BFu0s_Uc { bool v1; unsigned short :0; unsigned char v2; };
struct B_BFu0s_Ui { bool v1; unsigned short :0; unsigned int v2; };
struct B_BFu0s_Ul { bool v1; unsigned short :0; unsigned long long v2; };
struct B_BFu0s_Us { bool v1; unsigned short :0; unsigned short v2; };
struct B_BFu0s_Vp { bool v1; unsigned short :0; void * v2; };
struct B_BFu15i_BFu0c { bool v1; unsigned int v2:15; unsigned char :0; };
struct B_BFu15i_BFu0i { bool v1; unsigned int v2:15; unsigned int :0; };
struct B_BFu15i_BFu0ll { bool v1; unsigned int v2:15; unsigned long long :0; };
struct B_BFu15i_BFu0s { bool v1; unsigned int v2:15; unsigned short :0; };
struct B_BFu15ll_BFu0c { bool v1; unsigned long long v2:15; unsigned char :0; };
struct B_BFu15ll_BFu0i { bool v1; unsigned long long v2:15; unsigned int :0; };
struct B_BFu15ll_BFu0ll { bool v1; unsigned long long v2:15; unsigned long long :0; };
struct B_BFu15ll_BFu0s { bool v1; unsigned long long v2:15; unsigned short :0; };
struct B_BFu15s_BFu0c { bool v1; unsigned short v2:15; unsigned char :0; };
struct B_BFu15s_BFu0i { bool v1; unsigned short v2:15; unsigned int :0; };
struct B_BFu15s_BFu0ll { bool v1; unsigned short v2:15; unsigned long long :0; };
struct B_BFu15s_BFu0s { bool v1; unsigned short v2:15; unsigned short :0; };
struct B_BFu16i_BFu0c { bool v1; unsigned int v2:16; unsigned char :0; };
struct B_BFu16i_BFu0i { bool v1; unsigned int v2:16; unsigned int :0; };
struct B_BFu16i_BFu0ll { bool v1; unsigned int v2:16; unsigned long long :0; };
struct B_BFu16i_BFu0s { bool v1; unsigned int v2:16; unsigned short :0; };
struct B_BFu16ll_BFu0c { bool v1; unsigned long long v2:16; unsigned char :0; };
struct B_BFu16ll_BFu0i { bool v1; unsigned long long v2:16; unsigned int :0; };
struct B_BFu16ll_BFu0ll { bool v1; unsigned long long v2:16; unsigned long long :0; };
struct B_BFu16ll_BFu0s { bool v1; unsigned long long v2:16; unsigned short :0; };
struct B_BFu16s_BFu0c { bool v1; unsigned short v2:16; unsigned char :0; };
struct B_BFu16s_BFu0i { bool v1; unsigned short v2:16; unsigned int :0; };
struct B_BFu16s_BFu0ll { bool v1; unsigned short v2:16; unsigned long long :0; };
struct B_BFu16s_BFu0s { bool v1; unsigned short v2:16; unsigned short :0; };
struct B_BFu17i_BFu0c { bool v1; unsigned int v2:17; unsigned char :0; };
struct B_BFu17i_BFu0i { bool v1; unsigned int v2:17; unsigned int :0; };
struct B_BFu17i_BFu0ll { bool v1; unsigned int v2:17; unsigned long long :0; };
struct B_BFu17i_BFu0s { bool v1; unsigned int v2:17; unsigned short :0; };
struct B_BFu17ll_BFu0c { bool v1; unsigned long long v2:17; unsigned char :0; };
struct B_BFu17ll_BFu0i { bool v1; unsigned long long v2:17; unsigned int :0; };
struct B_BFu17ll_BFu0ll { bool v1; unsigned long long v2:17; unsigned long long :0; };
struct B_BFu17ll_BFu0s { bool v1; unsigned long long v2:17; unsigned short :0; };
struct B_BFu1c_BFu0c { bool v1; unsigned char v2:1; unsigned char :0; };
struct B_BFu1c_BFu0i { bool v1; unsigned char v2:1; unsigned int :0; };
struct B_BFu1c_BFu0ll { bool v1; unsigned char v2:1; unsigned long long :0; };
struct B_BFu1c_BFu0s { bool v1; unsigned char v2:1; unsigned short :0; };
struct B_BFu1i_BFu0c { bool v1; unsigned int v2:1; unsigned char :0; };
struct B_BFu1i_BFu0i { bool v1; unsigned int v2:1; unsigned int :0; };
struct B_BFu1i_BFu0ll { bool v1; unsigned int v2:1; unsigned long long :0; };
struct B_BFu1i_BFu0s { bool v1; unsigned int v2:1; unsigned short :0; };
struct B_BFu1ll_BFu0c { bool v1; unsigned long long v2:1; unsigned char :0; };
struct B_BFu1ll_BFu0i { bool v1; unsigned long long v2:1; unsigned int :0; };
struct B_BFu1ll_BFu0ll { bool v1; unsigned long long v2:1; unsigned long long :0; };
struct B_BFu1ll_BFu0s { bool v1; unsigned long long v2:1; unsigned short :0; };
struct B_BFu1s_BFu0c { bool v1; unsigned short v2:1; unsigned char :0; };
struct B_BFu1s_BFu0i { bool v1; unsigned short v2:1; unsigned int :0; };
struct B_BFu1s_BFu0ll { bool v1; unsigned short v2:1; unsigned long long :0; };
struct B_BFu1s_BFu0s { bool v1; unsigned short v2:1; unsigned short :0; };
struct B_BFu31i_BFu0c { bool v1; unsigned int v2:31; unsigned char :0; };
struct B_BFu31i_BFu0i { bool v1; unsigned int v2:31; unsigned int :0; };
struct B_BFu31i_BFu0ll { bool v1; unsigned int v2:31; unsigned long long :0; };
struct B_BFu31i_BFu0s { bool v1; unsigned int v2:31; unsigned short :0; };
struct B_BFu31ll_BFu0c { bool v1; unsigned long long v2:31; unsigned char :0; };
struct B_BFu31ll_BFu0i { bool v1; unsigned long long v2:31; unsigned int :0; };
struct B_BFu31ll_BFu0ll { bool v1; unsigned long long v2:31; unsigned long long :0; };
struct B_BFu31ll_BFu0s { bool v1; unsigned long long v2:31; unsigned short :0; };
struct B_BFu32i_BFu0c { bool v1; unsigned int v2:32; unsigned char :0; };
struct B_BFu32i_BFu0i { bool v1; unsigned int v2:32; unsigned int :0; };
struct B_BFu32i_BFu0ll { bool v1; unsigned int v2:32; unsigned long long :0; };
struct B_BFu32i_BFu0s { bool v1; unsigned int v2:32; unsigned short :0; };
struct B_BFu32ll_BFu0c { bool v1; unsigned long long v2:32; unsigned char :0; };
struct B_BFu32ll_BFu0i { bool v1; unsigned long long v2:32; unsigned int :0; };
struct B_BFu32ll_BFu0ll { bool v1; unsigned long long v2:32; unsigned long long :0; };
struct B_BFu32ll_BFu0s { bool v1; unsigned long long v2:32; unsigned short :0; };
struct B_BFu33_BFu0c { bool v1; unsigned long long v2:33; unsigned char :0; };
struct B_BFu33_BFu0i { bool v1; unsigned long long v2:33; unsigned int :0; };
struct B_BFu33_BFu0ll { bool v1; unsigned long long v2:33; unsigned long long :0; };
struct B_BFu33_BFu0s { bool v1; unsigned long long v2:33; unsigned short :0; };
struct B_BFu7c_BFu0c { bool v1; unsigned char v2:7; unsigned char :0; };
struct B_BFu7c_BFu0i { bool v1; unsigned char v2:7; unsigned int :0; };
struct B_BFu7c_BFu0ll { bool v1; unsigned char v2:7; unsigned long long :0; };
struct B_BFu7c_BFu0s { bool v1; unsigned char v2:7; unsigned short :0; };
struct B_BFu7i_BFu0c { bool v1; unsigned int v2:7; unsigned char :0; };
struct B_BFu7i_BFu0i { bool v1; unsigned int v2:7; unsigned int :0; };
struct B_BFu7i_BFu0ll { bool v1; unsigned int v2:7; unsigned long long :0; };
struct B_BFu7i_BFu0s { bool v1; unsigned int v2:7; unsigned short :0; };
struct B_BFu7ll_BFu0c { bool v1; unsigned long long v2:7; unsigned char :0; };
struct B_BFu7ll_BFu0i { bool v1; unsigned long long v2:7; unsigned int :0; };
struct B_BFu7ll_BFu0ll { bool v1; unsigned long long v2:7; unsigned long long :0; };
struct B_BFu7ll_BFu0s { bool v1; unsigned long long v2:7; unsigned short :0; };
struct B_BFu7s_BFu0c { bool v1; unsigned short v2:7; unsigned char :0; };
struct B_BFu7s_BFu0i { bool v1; unsigned short v2:7; unsigned int :0; };
struct B_BFu7s_BFu0ll { bool v1; unsigned short v2:7; unsigned long long :0; };
struct B_BFu7s_BFu0s { bool v1; unsigned short v2:7; unsigned short :0; };
struct B_BFu8c_BFu0c { bool v1; unsigned char v2:8; unsigned char :0; };
struct B_BFu8c_BFu0i { bool v1; unsigned char v2:8; unsigned int :0; };
struct B_BFu8c_BFu0ll { bool v1; unsigned char v2:8; unsigned long long :0; };
struct B_BFu8c_BFu0s { bool v1; unsigned char v2:8; unsigned short :0; };
struct B_BFu8i_BFu0c { bool v1; unsigned int v2:8; unsigned char :0; };
struct B_BFu8i_BFu0i { bool v1; unsigned int v2:8; unsigned int :0; };
struct B_BFu8i_BFu0ll { bool v1; unsigned int v2:8; unsigned long long :0; };
struct B_BFu8i_BFu0s { bool v1; unsigned int v2:8; unsigned short :0; };
struct B_BFu8ll_BFu0c { bool v1; unsigned long long v2:8; unsigned char :0; };
struct B_BFu8ll_BFu0i { bool v1; unsigned long long v2:8; unsigned int :0; };
struct B_BFu8ll_BFu0ll { bool v1; unsigned long long v2:8; unsigned long long :0; };
struct B_BFu8ll_BFu0s { bool v1; unsigned long long v2:8; unsigned short :0; };
struct B_BFu8s_BFu0c { bool v1; unsigned short v2:8; unsigned char :0; };
struct B_BFu8s_BFu0i { bool v1; unsigned short v2:8; unsigned int :0; };
struct B_BFu8s_BFu0ll { bool v1; unsigned short v2:8; unsigned long long :0; };
struct B_BFu8s_BFu0s { bool v1; unsigned short v2:8; unsigned short :0; };
struct B_BFu9i_BFu0c { bool v1; unsigned int v2:9; unsigned char :0; };
struct B_BFu9i_BFu0i { bool v1; unsigned int v2:9; unsigned int :0; };
struct B_BFu9i_BFu0ll { bool v1; unsigned int v2:9; unsigned long long :0; };
struct B_BFu9i_BFu0s { bool v1; unsigned int v2:9; unsigned short :0; };
struct B_BFu9ll_BFu0c { bool v1; unsigned long long v2:9; unsigned char :0; };
struct B_BFu9ll_BFu0i { bool v1; unsigned long long v2:9; unsigned int :0; };
struct B_BFu9ll_BFu0ll { bool v1; unsigned long long v2:9; unsigned long long :0; };
struct B_BFu9ll_BFu0s { bool v1; unsigned long long v2:9; unsigned short :0; };
struct B_BFu9s_BFu0c { bool v1; unsigned short v2:9; unsigned char :0; };
struct B_BFu9s_BFu0i { bool v1; unsigned short v2:9; unsigned int :0; };
struct B_BFu9s_BFu0ll { bool v1; unsigned short v2:9; unsigned long long :0; };
struct B_BFu9s_BFu0s { bool v1; unsigned short v2:9; unsigned short :0; };
struct B_C_BFu0c { bool v1; char v2; unsigned char :0; };
struct B_C_BFu0i { bool v1; char v2; unsigned int :0; };
struct B_C_BFu0ll { bool v1; char v2; unsigned long long :0; };
struct B_C_BFu0s { bool v1; char v2; unsigned short :0; };
struct B_D_BFu0c { bool v1; double v2; unsigned char :0; };
struct B_D_BFu0i { bool v1; double v2; unsigned int :0; };
struct B_D_BFu0ll { bool v1; double v2; unsigned long long :0; };
struct B_D_BFu0s { bool v1; double v2; unsigned short :0; };
struct B_F_BFu0c { bool v1; float v2; unsigned char :0; };
struct B_F_BFu0i { bool v1; float v2; unsigned int :0; };
struct B_F_BFu0ll { bool v1; float v2; unsigned long long :0; };
struct B_F_BFu0s { bool v1; float v2; unsigned short :0; };
struct B_I_BFu0c { bool v1; int v2; unsigned char :0; };
struct B_I_BFu0i { bool v1; int v2; unsigned int :0; };
struct B_I_BFu0ll { bool v1; int v2; unsigned long long :0; };
struct B_I_BFu0s { bool v1; int v2; unsigned short :0; };
struct B_Ip_BFu0c { bool v1; int * v2; unsigned char :0; };
struct B_Ip_BFu0i { bool v1; int * v2; unsigned int :0; };
struct B_Ip_BFu0ll { bool v1; int * v2; unsigned long long :0; };
struct B_Ip_BFu0s { bool v1; int * v2; unsigned short :0; };
struct B_L_BFu0c { bool v1; long long v2; unsigned char :0; };
struct B_L_BFu0i { bool v1; long long v2; unsigned int :0; };
struct B_L_BFu0ll { bool v1; long long v2; unsigned long long :0; };
struct B_L_BFu0s { bool v1; long long v2; unsigned short :0; };
struct B_S_BFu0c { bool v1; short v2; unsigned char :0; };
struct B_S_BFu0i { bool v1; short v2; unsigned int :0; };
struct B_S_BFu0ll { bool v1; short v2; unsigned long long :0; };
struct B_S_BFu0s { bool v1; short v2; unsigned short :0; };
struct B_Uc_BFu0c { bool v1; unsigned char v2; unsigned char :0; };
struct B_Uc_BFu0i { bool v1; unsigned char v2; unsigned int :0; };
struct B_Uc_BFu0ll { bool v1; unsigned char v2; unsigned long long :0; };
struct B_Uc_BFu0s { bool v1; unsigned char v2; unsigned short :0; };
struct B_Ui_BFu0c { bool v1; unsigned int v2; unsigned char :0; };
struct B_Ui_BFu0i { bool v1; unsigned int v2; unsigned int :0; };
struct B_Ui_BFu0ll { bool v1; unsigned int v2; unsigned long long :0; };
struct B_Ui_BFu0s { bool v1; unsigned int v2; unsigned short :0; };
struct B_Ul_BFu0c { bool v1; unsigned long long v2; unsigned char :0; };
struct B_Ul_BFu0i { bool v1; unsigned long long v2; unsigned int :0; };
struct B_Ul_BFu0ll { bool v1; unsigned long long v2; unsigned long long :0; };
struct B_Ul_BFu0s { bool v1; unsigned long long v2; unsigned short :0; };
struct B_Us_BFu0c { bool v1; unsigned short v2; unsigned char :0; };
struct B_Us_BFu0i { bool v1; unsigned short v2; unsigned int :0; };
struct B_Us_BFu0ll { bool v1; unsigned short v2; unsigned long long :0; };
struct B_Us_BFu0s { bool v1; unsigned short v2; unsigned short :0; };
struct B_Vp_BFu0c { bool v1; void * v2; unsigned char :0; };
struct B_Vp_BFu0i { bool v1; void * v2; unsigned int :0; };
struct B_Vp_BFu0ll { bool v1; void * v2; unsigned long long :0; };
struct B_Vp_BFu0s { bool v1; void * v2; unsigned short :0; };
struct BFu0c_B { unsigned char :0; bool v1; };
struct BFu0c_B_B { unsigned char :0; bool v1; bool v2; };
struct BFu0c_B_BFu0c { unsigned char :0; bool v1; unsigned char :0; };
struct BFu0c_B_BFu0i { unsigned char :0; bool v1; unsigned int :0; };
struct BFu0c_B_BFu0ll { unsigned char :0; bool v1; unsigned long long :0; };
struct BFu0c_B_BFu0s { unsigned char :0; bool v1; unsigned short :0; };
struct BFu0c_B_BFu15i { unsigned char :0; bool v1; unsigned int v2:15; };
struct BFu0c_B_BFu15ll { unsigned char :0; bool v1; unsigned long long v2:15; };
struct BFu0c_B_BFu15s { unsigned char :0; bool v1; unsigned short v2:15; };
struct BFu0c_B_BFu16i { unsigned char :0; bool v1; unsigned int v2:16; };
struct BFu0c_B_BFu16ll { unsigned char :0; bool v1; unsigned long long v2:16; };
struct BFu0c_B_BFu16s { unsigned char :0; bool v1; unsigned short v2:16; };
struct BFu0c_B_BFu17i { unsigned char :0; bool v1; unsigned int v2:17; };
struct BFu0c_B_BFu17ll { unsigned char :0; bool v1; unsigned long long v2:17; };
struct BFu0c_B_BFu1c { unsigned char :0; bool v1; unsigned char v2:1; };
struct BFu0c_B_BFu1i { unsigned char :0; bool v1; unsigned int v2:1; };
struct BFu0c_B_BFu1ll { unsigned char :0; bool v1; unsigned long long v2:1; };
struct BFu0c_B_BFu1s { unsigned char :0; bool v1; unsigned short v2:1; };
struct BFu0c_B_BFu31i { unsigned char :0; bool v1; unsigned int v2:31; };
struct BFu0c_B_BFu31ll { unsigned char :0; bool v1; unsigned long long v2:31; };
struct BFu0c_B_BFu32i { unsigned char :0; bool v1; unsigned int v2:32; };
struct BFu0c_B_BFu32ll { unsigned char :0; bool v1; unsigned long long v2:32; };
struct BFu0c_B_BFu33 { unsigned char :0; bool v1; unsigned long long v2:33; };
struct BFu0c_B_BFu7c { unsigned char :0; bool v1; unsigned char v2:7; };
struct BFu0c_B_BFu7i { unsigned char :0; bool v1; unsigned int v2:7; };
struct BFu0c_B_BFu7ll { unsigned char :0; bool v1; unsigned long long v2:7; };
struct BFu0c_B_BFu7s { unsigned char :0; bool v1; unsigned short v2:7; };
struct BFu0c_B_BFu8c { unsigned char :0; bool v1; unsigned char v2:8; };
struct BFu0c_B_BFu8i { unsigned char :0; bool v1; unsigned int v2:8; };
struct BFu0c_B_BFu8ll { unsigned char :0; bool v1; unsigned long long v2:8; };
struct BFu0c_B_BFu8s { unsigned char :0; bool v1; unsigned short v2:8; };
struct BFu0c_B_BFu9i { unsigned char :0; bool v1; unsigned int v2:9; };
struct BFu0c_B_BFu9ll { unsigned char :0; bool v1; unsigned long long v2:9; };
struct BFu0c_B_BFu9s { unsigned char :0; bool v1; unsigned short v2:9; };
struct BFu0c_B_C { unsigned char :0; bool v1; char v2; };
struct BFu0c_B_D { unsigned char :0; bool v1; double v2; };
struct BFu0c_B_F { unsigned char :0; bool v1; float v2; };
struct BFu0c_B_I { unsigned char :0; bool v1; int v2; };
struct BFu0c_B_Ip { unsigned char :0; bool v1; int * v2; };
struct BFu0c_B_L { unsigned char :0; bool v1; long long v2; };
struct BFu0c_B_S { unsigned char :0; bool v1; short v2; };
struct BFu0c_B_Uc { unsigned char :0; bool v1; unsigned char v2; };
struct BFu0c_B_Ui { unsigned char :0; bool v1; unsigned int v2; };
struct BFu0c_B_Ul { unsigned char :0; bool v1; unsigned long long v2; };
struct BFu0c_B_Us { unsigned char :0; bool v1; unsigned short v2; };
struct BFu0c_B_Vp { unsigned char :0; bool v1; void * v2; };
struct BFu0c_BFu0c_B { unsigned char :0; unsigned char :0; bool v1; };
struct BFu0c_BFu0i_B { unsigned char :0; unsigned int :0; bool v1; };
struct BFu0c_BFu0ll_B { unsigned char :0; unsigned long long :0; bool v1; };
struct BFu0c_BFu0s_B { unsigned char :0; unsigned short :0; bool v1; };
struct BFu0c_BFu15i_B { unsigned char :0; unsigned int v1:15; bool v2; };
struct BFu0c_BFu15ll_B { unsigned char :0; unsigned long long v1:15; bool v2; };
struct BFu0c_BFu15s_B { unsigned char :0; unsigned short v1:15; bool v2; };
struct BFu0c_BFu16i_B { unsigned char :0; unsigned int v1:16; bool v2; };
struct BFu0c_BFu16ll_B { unsigned char :0; unsigned long long v1:16; bool v2; };
struct BFu0c_BFu16s_B { unsigned char :0; unsigned short v1:16; bool v2; };
struct BFu0c_BFu17i_B { unsigned char :0; unsigned int v1:17; bool v2; };
struct BFu0c_BFu17ll_B { unsigned char :0; unsigned long long v1:17; bool v2; };
struct BFu0c_BFu1c_B { unsigned char :0; unsigned char v1:1; bool v2; };
struct BFu0c_BFu1i_B { unsigned char :0; unsigned int v1:1; bool v2; };
struct BFu0c_BFu1ll_B { unsigned char :0; unsigned long long v1:1; bool v2; };
struct BFu0c_BFu1s_B { unsigned char :0; unsigned short v1:1; bool v2; };
struct BFu0c_BFu31i_B { unsigned char :0; unsigned int v1:31; bool v2; };
struct BFu0c_BFu31ll_B { unsigned char :0; unsigned long long v1:31; bool v2; };
struct BFu0c_BFu32i_B { unsigned char :0; unsigned int v1:32; bool v2; };
struct BFu0c_BFu32ll_B { unsigned char :0; unsigned long long v1:32; bool v2; };
struct BFu0c_BFu33_B { unsigned char :0; unsigned long long v1:33; bool v2; };
struct BFu0c_BFu7c_B { unsigned char :0; unsigned char v1:7; bool v2; };
struct BFu0c_BFu7i_B { unsigned char :0; unsigned int v1:7; bool v2; };
struct BFu0c_BFu7ll_B { unsigned char :0; unsigned long long v1:7; bool v2; };
struct BFu0c_BFu7s_B { unsigned char :0; unsigned short v1:7; bool v2; };
struct BFu0c_BFu8c_B { unsigned char :0; unsigned char v1:8; bool v2; };
struct BFu0c_BFu8i_B { unsigned char :0; unsigned int v1:8; bool v2; };
struct BFu0c_BFu8ll_B { unsigned char :0; unsigned long long v1:8; bool v2; };
struct BFu0c_BFu8s_B { unsigned char :0; unsigned short v1:8; bool v2; };
struct BFu0c_BFu9i_B { unsigned char :0; unsigned int v1:9; bool v2; };
struct BFu0c_BFu9ll_B { unsigned char :0; unsigned long long v1:9; bool v2; };
struct BFu0c_BFu9s_B { unsigned char :0; unsigned short v1:9; bool v2; };
struct BFu0c_C_B { unsigned char :0; char v1; bool v2; };
struct BFu0c_D_B { unsigned char :0; double v1; bool v2; };
struct BFu0c_F_B { unsigned char :0; float v1; bool v2; };
struct BFu0c_I_B { unsigned char :0; int v1; bool v2; };
struct BFu0c_Ip_B { unsigned char :0; int * v1; bool v2; };
struct BFu0c_L_B { unsigned char :0; long long v1; bool v2; };
struct BFu0c_S_B { unsigned char :0; short v1; bool v2; };
struct BFu0c_Uc_B { unsigned char :0; unsigned char v1; bool v2; };
struct BFu0c_Ui_B { unsigned char :0; unsigned int v1; bool v2; };
struct BFu0c_Ul_B { unsigned char :0; unsigned long long v1; bool v2; };
struct BFu0c_Us_B { unsigned char :0; unsigned short v1; bool v2; };
struct BFu0c_Vp_B { unsigned char :0; void * v1; bool v2; };
struct BFu0i_B { unsigned int :0; bool v1; };
struct BFu0i_B_B { unsigned int :0; bool v1; bool v2; };
struct BFu0i_B_BFu0c { unsigned int :0; bool v1; unsigned char :0; };
struct BFu0i_B_BFu0i { unsigned int :0; bool v1; unsigned int :0; };
struct BFu0i_B_BFu0ll { unsigned int :0; bool v1; unsigned long long :0; };
struct BFu0i_B_BFu0s { unsigned int :0; bool v1; unsigned short :0; };
struct BFu0i_B_BFu15i { unsigned int :0; bool v1; unsigned int v2:15; };
struct BFu0i_B_BFu15ll { unsigned int :0; bool v1; unsigned long long v2:15; };
struct BFu0i_B_BFu15s { unsigned int :0; bool v1; unsigned short v2:15; };
struct BFu0i_B_BFu16i { unsigned int :0; bool v1; unsigned int v2:16; };
struct BFu0i_B_BFu16ll { unsigned int :0; bool v1; unsigned long long v2:16; };
struct BFu0i_B_BFu16s { unsigned int :0; bool v1; unsigned short v2:16; };
struct BFu0i_B_BFu17i { unsigned int :0; bool v1; unsigned int v2:17; };
struct BFu0i_B_BFu17ll { unsigned int :0; bool v1; unsigned long long v2:17; };
struct BFu0i_B_BFu1c { unsigned int :0; bool v1; unsigned char v2:1; };
struct BFu0i_B_BFu1i { unsigned int :0; bool v1; unsigned int v2:1; };
struct BFu0i_B_BFu1ll { unsigned int :0; bool v1; unsigned long long v2:1; };
struct BFu0i_B_BFu1s { unsigned int :0; bool v1; unsigned short v2:1; };
struct BFu0i_B_BFu31i { unsigned int :0; bool v1; unsigned int v2:31; };
struct BFu0i_B_BFu31ll { unsigned int :0; bool v1; unsigned long long v2:31; };
struct BFu0i_B_BFu32i { unsigned int :0; bool v1; unsigned int v2:32; };
struct BFu0i_B_BFu32ll { unsigned int :0; bool v1; unsigned long long v2:32; };
struct BFu0i_B_BFu33 { unsigned int :0; bool v1; unsigned long long v2:33; };
struct BFu0i_B_BFu7c { unsigned int :0; bool v1; unsigned char v2:7; };
struct BFu0i_B_BFu7i { unsigned int :0; bool v1; unsigned int v2:7; };
struct BFu0i_B_BFu7ll { unsigned int :0; bool v1; unsigned long long v2:7; };
struct BFu0i_B_BFu7s { unsigned int :0; bool v1; unsigned short v2:7; };
struct BFu0i_B_BFu8c { unsigned int :0; bool v1; unsigned char v2:8; };
struct BFu0i_B_BFu8i { unsigned int :0; bool v1; unsigned int v2:8; };
struct BFu0i_B_BFu8ll { unsigned int :0; bool v1; unsigned long long v2:8; };
struct BFu0i_B_BFu8s { unsigned int :0; bool v1; unsigned short v2:8; };
struct BFu0i_B_BFu9i { unsigned int :0; bool v1; unsigned int v2:9; };
struct BFu0i_B_BFu9ll { unsigned int :0; bool v1; unsigned long long v2:9; };
struct BFu0i_B_BFu9s { unsigned int :0; bool v1; unsigned short v2:9; };
struct BFu0i_B_C { unsigned int :0; bool v1; char v2; };
struct BFu0i_B_D { unsigned int :0; bool v1; double v2; };
struct BFu0i_B_F { unsigned int :0; bool v1; float v2; };
struct BFu0i_B_I { unsigned int :0; bool v1; int v2; };
struct BFu0i_B_Ip { unsigned int :0; bool v1; int * v2; };
struct BFu0i_B_L { unsigned int :0; bool v1; long long v2; };
struct BFu0i_B_S { unsigned int :0; bool v1; short v2; };
struct BFu0i_B_Uc { unsigned int :0; bool v1; unsigned char v2; };
struct BFu0i_B_Ui { unsigned int :0; bool v1; unsigned int v2; };
struct BFu0i_B_Ul { unsigned int :0; bool v1; unsigned long long v2; };
struct BFu0i_B_Us { unsigned int :0; bool v1; unsigned short v2; };
struct BFu0i_B_Vp { unsigned int :0; bool v1; void * v2; };
struct BFu0i_BFu0c_B { unsigned int :0; unsigned char :0; bool v1; };
struct BFu0i_BFu0i_B { unsigned int :0; unsigned int :0; bool v1; };
struct BFu0i_BFu0ll_B { unsigned int :0; unsigned long long :0; bool v1; };
struct BFu0i_BFu0s_B { unsigned int :0; unsigned short :0; bool v1; };
struct BFu0i_BFu15i_B { unsigned int :0; unsigned int v1:15; bool v2; };
struct BFu0i_BFu15ll_B { unsigned int :0; unsigned long long v1:15; bool v2; };
struct BFu0i_BFu15s_B { unsigned int :0; unsigned short v1:15; bool v2; };
struct BFu0i_BFu16i_B { unsigned int :0; unsigned int v1:16; bool v2; };
struct BFu0i_BFu16ll_B { unsigned int :0; unsigned long long v1:16; bool v2; };
struct BFu0i_BFu16s_B { unsigned int :0; unsigned short v1:16; bool v2; };
struct BFu0i_BFu17i_B { unsigned int :0; unsigned int v1:17; bool v2; };
struct BFu0i_BFu17ll_B { unsigned int :0; unsigned long long v1:17; bool v2; };
struct BFu0i_BFu1c_B { unsigned int :0; unsigned char v1:1; bool v2; };
struct BFu0i_BFu1i_B { unsigned int :0; unsigned int v1:1; bool v2; };
struct BFu0i_BFu1ll_B { unsigned int :0; unsigned long long v1:1; bool v2; };
struct BFu0i_BFu1s_B { unsigned int :0; unsigned short v1:1; bool v2; };
struct BFu0i_BFu31i_B { unsigned int :0; unsigned int v1:31; bool v2; };
struct BFu0i_BFu31ll_B { unsigned int :0; unsigned long long v1:31; bool v2; };
struct BFu0i_BFu32i_B { unsigned int :0; unsigned int v1:32; bool v2; };
struct BFu0i_BFu32ll_B { unsigned int :0; unsigned long long v1:32; bool v2; };
struct BFu0i_BFu33_B { unsigned int :0; unsigned long long v1:33; bool v2; };
struct BFu0i_BFu7c_B { unsigned int :0; unsigned char v1:7; bool v2; };
struct BFu0i_BFu7i_B { unsigned int :0; unsigned int v1:7; bool v2; };
struct BFu0i_BFu7ll_B { unsigned int :0; unsigned long long v1:7; bool v2; };
struct BFu0i_BFu7s_B { unsigned int :0; unsigned short v1:7; bool v2; };
struct BFu0i_BFu8c_B { unsigned int :0; unsigned char v1:8; bool v2; };
struct BFu0i_BFu8i_B { unsigned int :0; unsigned int v1:8; bool v2; };
struct BFu0i_BFu8ll_B { unsigned int :0; unsigned long long v1:8; bool v2; };
struct BFu0i_BFu8s_B { unsigned int :0; unsigned short v1:8; bool v2; };
struct BFu0i_BFu9i_B { unsigned int :0; unsigned int v1:9; bool v2; };
struct BFu0i_BFu9ll_B { unsigned int :0; unsigned long long v1:9; bool v2; };
struct BFu0i_BFu9s_B { unsigned int :0; unsigned short v1:9; bool v2; };
struct BFu0i_C_B { unsigned int :0; char v1; bool v2; };
struct BFu0i_D_B { unsigned int :0; double v1; bool v2; };
struct BFu0i_F_B { unsigned int :0; float v1; bool v2; };
struct BFu0i_I_B { unsigned int :0; int v1; bool v2; };
struct BFu0i_Ip_B { unsigned int :0; int * v1; bool v2; };
struct BFu0i_L_B { unsigned int :0; long long v1; bool v2; };
struct BFu0i_S_B { unsigned int :0; short v1; bool v2; };
struct BFu0i_Uc_B { unsigned int :0; unsigned char v1; bool v2; };
struct BFu0i_Ui_B { unsigned int :0; unsigned int v1; bool v2; };
struct BFu0i_Ul_B { unsigned int :0; unsigned long long v1; bool v2; };
struct BFu0i_Us_B { unsigned int :0; unsigned short v1; bool v2; };
struct BFu0i_Vp_B { unsigned int :0; void * v1; bool v2; };
struct BFu0ll_B { unsigned long long :0; bool v1; };
struct BFu0ll_B_B { unsigned long long :0; bool v1; bool v2; };
struct BFu0ll_B_BFu0c { unsigned long long :0; bool v1; unsigned char :0; };
struct BFu0ll_B_BFu0i { unsigned long long :0; bool v1; unsigned int :0; };
struct BFu0ll_B_BFu0ll { unsigned long long :0; bool v1; unsigned long long :0; };
struct BFu0ll_B_BFu0s { unsigned long long :0; bool v1; unsigned short :0; };
struct BFu0ll_B_BFu15i { unsigned long long :0; bool v1; unsigned int v2:15; };
struct BFu0ll_B_BFu15ll { unsigned long long :0; bool v1; unsigned long long v2:15; };
struct BFu0ll_B_BFu15s { unsigned long long :0; bool v1; unsigned short v2:15; };
struct BFu0ll_B_BFu16i { unsigned long long :0; bool v1; unsigned int v2:16; };
struct BFu0ll_B_BFu16ll { unsigned long long :0; bool v1; unsigned long long v2:16; };
struct BFu0ll_B_BFu16s { unsigned long long :0; bool v1; unsigned short v2:16; };
struct BFu0ll_B_BFu17i { unsigned long long :0; bool v1; unsigned int v2:17; };
struct BFu0ll_B_BFu17ll { unsigned long long :0; bool v1; unsigned long long v2:17; };
struct BFu0ll_B_BFu1c { unsigned long long :0; bool v1; unsigned char v2:1; };
struct BFu0ll_B_BFu1i { unsigned long long :0; bool v1; unsigned int v2:1; };
struct BFu0ll_B_BFu1ll { unsigned long long :0; bool v1; unsigned long long v2:1; };
struct BFu0ll_B_BFu1s { unsigned long long :0; bool v1; unsigned short v2:1; };
struct BFu0ll_B_BFu31i { unsigned long long :0; bool v1; unsigned int v2:31; };
struct BFu0ll_B_BFu31ll { unsigned long long :0; bool v1; unsigned long long v2:31; };
struct BFu0ll_B_BFu32i { unsigned long long :0; bool v1; unsigned int v2:32; };
struct BFu0ll_B_BFu32ll { unsigned long long :0; bool v1; unsigned long long v2:32; };
struct BFu0ll_B_BFu33 { unsigned long long :0; bool v1; unsigned long long v2:33; };
struct BFu0ll_B_BFu7c { unsigned long long :0; bool v1; unsigned char v2:7; };
struct BFu0ll_B_BFu7i { unsigned long long :0; bool v1; unsigned int v2:7; };
struct BFu0ll_B_BFu7ll { unsigned long long :0; bool v1; unsigned long long v2:7; };
struct BFu0ll_B_BFu7s { unsigned long long :0; bool v1; unsigned short v2:7; };
struct BFu0ll_B_BFu8c { unsigned long long :0; bool v1; unsigned char v2:8; };
struct BFu0ll_B_BFu8i { unsigned long long :0; bool v1; unsigned int v2:8; };
struct BFu0ll_B_BFu8ll { unsigned long long :0; bool v1; unsigned long long v2:8; };
struct BFu0ll_B_BFu8s { unsigned long long :0; bool v1; unsigned short v2:8; };
struct BFu0ll_B_BFu9i { unsigned long long :0; bool v1; unsigned int v2:9; };
struct BFu0ll_B_BFu9ll { unsigned long long :0; bool v1; unsigned long long v2:9; };
struct BFu0ll_B_BFu9s { unsigned long long :0; bool v1; unsigned short v2:9; };
struct BFu0ll_B_C { unsigned long long :0; bool v1; char v2; };
struct BFu0ll_B_D { unsigned long long :0; bool v1; double v2; };
struct BFu0ll_B_F { unsigned long long :0; bool v1; float v2; };
struct BFu0ll_B_I { unsigned long long :0; bool v1; int v2; };
struct BFu0ll_B_Ip { unsigned long long :0; bool v1; int * v2; };
struct BFu0ll_B_L { unsigned long long :0; bool v1; long long v2; };
struct BFu0ll_B_S { unsigned long long :0; bool v1; short v2; };
struct BFu0ll_B_Uc { unsigned long long :0; bool v1; unsigned char v2; };
struct BFu0ll_B_Ui { unsigned long long :0; bool v1; unsigned int v2; };
struct BFu0ll_B_Ul { unsigned long long :0; bool v1; unsigned long long v2; };
struct BFu0ll_B_Us { unsigned long long :0; bool v1; unsigned short v2; };
struct BFu0ll_B_Vp { unsigned long long :0; bool v1; void * v2; };
struct BFu0ll_BFu0c_B { unsigned long long :0; unsigned char :0; bool v1; };
struct BFu0ll_BFu0i_B { unsigned long long :0; unsigned int :0; bool v1; };
struct BFu0ll_BFu0ll_B { unsigned long long :0; unsigned long long :0; bool v1; };
struct BFu0ll_BFu0s_B { unsigned long long :0; unsigned short :0; bool v1; };
struct BFu0ll_BFu15i_B { unsigned long long :0; unsigned int v1:15; bool v2; };
struct BFu0ll_BFu15ll_B { unsigned long long :0; unsigned long long v1:15; bool v2; };
struct BFu0ll_BFu15s_B { unsigned long long :0; unsigned short v1:15; bool v2; };
struct BFu0ll_BFu16i_B { unsigned long long :0; unsigned int v1:16; bool v2; };
struct BFu0ll_BFu16ll_B { unsigned long long :0; unsigned long long v1:16; bool v2; };
struct BFu0ll_BFu16s_B { unsigned long long :0; unsigned short v1:16; bool v2; };
struct BFu0ll_BFu17i_B { unsigned long long :0; unsigned int v1:17; bool v2; };
struct BFu0ll_BFu17ll_B { unsigned long long :0; unsigned long long v1:17; bool v2; };
struct BFu0ll_BFu1c_B { unsigned long long :0; unsigned char v1:1; bool v2; };
struct BFu0ll_BFu1i_B { unsigned long long :0; unsigned int v1:1; bool v2; };
struct BFu0ll_BFu1ll_B { unsigned long long :0; unsigned long long v1:1; bool v2; };
struct BFu0ll_BFu1s_B { unsigned long long :0; unsigned short v1:1; bool v2; };
struct BFu0ll_BFu31i_B { unsigned long long :0; unsigned int v1:31; bool v2; };
struct BFu0ll_BFu31ll_B { unsigned long long :0; unsigned long long v1:31; bool v2; };
struct BFu0ll_BFu32i_B { unsigned long long :0; unsigned int v1:32; bool v2; };
struct BFu0ll_BFu32ll_B { unsigned long long :0; unsigned long long v1:32; bool v2; };
struct BFu0ll_BFu33_B { unsigned long long :0; unsigned long long v1:33; bool v2; };
struct BFu0ll_BFu7c_B { unsigned long long :0; unsigned char v1:7; bool v2; };
struct BFu0ll_BFu7i_B { unsigned long long :0; unsigned int v1:7; bool v2; };
struct BFu0ll_BFu7ll_B { unsigned long long :0; unsigned long long v1:7; bool v2; };
struct BFu0ll_BFu7s_B { unsigned long long :0; unsigned short v1:7; bool v2; };
struct BFu0ll_BFu8c_B { unsigned long long :0; unsigned char v1:8; bool v2; };
struct BFu0ll_BFu8i_B { unsigned long long :0; unsigned int v1:8; bool v2; };
struct BFu0ll_BFu8ll_B { unsigned long long :0; unsigned long long v1:8; bool v2; };
struct BFu0ll_BFu8s_B { unsigned long long :0; unsigned short v1:8; bool v2; };
struct BFu0ll_BFu9i_B { unsigned long long :0; unsigned int v1:9; bool v2; };
struct BFu0ll_BFu9ll_B { unsigned long long :0; unsigned long long v1:9; bool v2; };
struct BFu0ll_BFu9s_B { unsigned long long :0; unsigned short v1:9; bool v2; };
struct BFu0ll_C_B { unsigned long long :0; char v1; bool v2; };
struct BFu0ll_D_B { unsigned long long :0; double v1; bool v2; };
struct BFu0ll_F_B { unsigned long long :0; float v1; bool v2; };
struct BFu0ll_I_B { unsigned long long :0; int v1; bool v2; };
struct BFu0ll_Ip_B { unsigned long long :0; int * v1; bool v2; };
struct BFu0ll_L_B { unsigned long long :0; long long v1; bool v2; };
struct BFu0ll_S_B { unsigned long long :0; short v1; bool v2; };
struct BFu0ll_Uc_B { unsigned long long :0; unsigned char v1; bool v2; };
struct BFu0ll_Ui_B { unsigned long long :0; unsigned int v1; bool v2; };
struct BFu0ll_Ul_B { unsigned long long :0; unsigned long long v1; bool v2; };
struct BFu0ll_Us_B { unsigned long long :0; unsigned short v1; bool v2; };
struct BFu0ll_Vp_B { unsigned long long :0; void * v1; bool v2; };
struct BFu0s_B { unsigned short :0; bool v1; };
struct BFu0s_B_B { unsigned short :0; bool v1; bool v2; };
struct BFu0s_B_BFu0c { unsigned short :0; bool v1; unsigned char :0; };
struct BFu0s_B_BFu0i { unsigned short :0; bool v1; unsigned int :0; };
struct BFu0s_B_BFu0ll { unsigned short :0; bool v1; unsigned long long :0; };
struct BFu0s_B_BFu0s { unsigned short :0; bool v1; unsigned short :0; };
struct BFu0s_B_BFu15i { unsigned short :0; bool v1; unsigned int v2:15; };
struct BFu0s_B_BFu15ll { unsigned short :0; bool v1; unsigned long long v2:15; };
struct BFu0s_B_BFu15s { unsigned short :0; bool v1; unsigned short v2:15; };
struct BFu0s_B_BFu16i { unsigned short :0; bool v1; unsigned int v2:16; };
struct BFu0s_B_BFu16ll { unsigned short :0; bool v1; unsigned long long v2:16; };
struct BFu0s_B_BFu16s { unsigned short :0; bool v1; unsigned short v2:16; };
struct BFu0s_B_BFu17i { unsigned short :0; bool v1; unsigned int v2:17; };
struct BFu0s_B_BFu17ll { unsigned short :0; bool v1; unsigned long long v2:17; };
struct BFu0s_B_BFu1c { unsigned short :0; bool v1; unsigned char v2:1; };
struct BFu0s_B_BFu1i { unsigned short :0; bool v1; unsigned int v2:1; };
struct BFu0s_B_BFu1ll { unsigned short :0; bool v1; unsigned long long v2:1; };
struct BFu0s_B_BFu1s { unsigned short :0; bool v1; unsigned short v2:1; };
struct BFu0s_B_BFu31i { unsigned short :0; bool v1; unsigned int v2:31; };
struct BFu0s_B_BFu31ll { unsigned short :0; bool v1; unsigned long long v2:31; };
struct BFu0s_B_BFu32i { unsigned short :0; bool v1; unsigned int v2:32; };
struct BFu0s_B_BFu32ll { unsigned short :0; bool v1; unsigned long long v2:32; };
struct BFu0s_B_BFu33 { unsigned short :0; bool v1; unsigned long long v2:33; };
struct BFu0s_B_BFu7c { unsigned short :0; bool v1; unsigned char v2:7; };
struct BFu0s_B_BFu7i { unsigned short :0; bool v1; unsigned int v2:7; };
struct BFu0s_B_BFu7ll { unsigned short :0; bool v1; unsigned long long v2:7; };
struct BFu0s_B_BFu7s { unsigned short :0; bool v1; unsigned short v2:7; };
struct BFu0s_B_BFu8c { unsigned short :0; bool v1; unsigned char v2:8; };
struct BFu0s_B_BFu8i { unsigned short :0; bool v1; unsigned int v2:8; };
struct BFu0s_B_BFu8ll { unsigned short :0; bool v1; unsigned long long v2:8; };
struct BFu0s_B_BFu8s { unsigned short :0; bool v1; unsigned short v2:8; };
struct BFu0s_B_BFu9i { unsigned short :0; bool v1; unsigned int v2:9; };
struct BFu0s_B_BFu9ll { unsigned short :0; bool v1; unsigned long long v2:9; };
struct BFu0s_B_BFu9s { unsigned short :0; bool v1; unsigned short v2:9; };
struct BFu0s_B_C { unsigned short :0; bool v1; char v2; };
struct BFu0s_B_D { unsigned short :0; bool v1; double v2; };
struct BFu0s_B_F { unsigned short :0; bool v1; float v2; };
struct BFu0s_B_I { unsigned short :0; bool v1; int v2; };
struct BFu0s_B_Ip { unsigned short :0; bool v1; int * v2; };
struct BFu0s_B_L { unsigned short :0; bool v1; long long v2; };
struct BFu0s_B_S { unsigned short :0; bool v1; short v2; };
struct BFu0s_B_Uc { unsigned short :0; bool v1; unsigned char v2; };
struct BFu0s_B_Ui { unsigned short :0; bool v1; unsigned int v2; };
struct BFu0s_B_Ul { unsigned short :0; bool v1; unsigned long long v2; };
struct BFu0s_B_Us { unsigned short :0; bool v1; unsigned short v2; };
struct BFu0s_B_Vp { unsigned short :0; bool v1; void * v2; };
struct BFu0s_BFu0c_B { unsigned short :0; unsigned char :0; bool v1; };
struct BFu0s_BFu0i_B { unsigned short :0; unsigned int :0; bool v1; };
struct BFu0s_BFu0ll_B { unsigned short :0; unsigned long long :0; bool v1; };
struct BFu0s_BFu0s_B { unsigned short :0; unsigned short :0; bool v1; };
struct BFu0s_BFu15i_B { unsigned short :0; unsigned int v1:15; bool v2; };
struct BFu0s_BFu15ll_B { unsigned short :0; unsigned long long v1:15; bool v2; };
struct BFu0s_BFu15s_B { unsigned short :0; unsigned short v1:15; bool v2; };
struct BFu0s_BFu16i_B { unsigned short :0; unsigned int v1:16; bool v2; };
struct BFu0s_BFu16ll_B { unsigned short :0; unsigned long long v1:16; bool v2; };
struct BFu0s_BFu16s_B { unsigned short :0; unsigned short v1:16; bool v2; };
struct BFu0s_BFu17i_B { unsigned short :0; unsigned int v1:17; bool v2; };
struct BFu0s_BFu17ll_B { unsigned short :0; unsigned long long v1:17; bool v2; };
struct BFu0s_BFu1c_B { unsigned short :0; unsigned char v1:1; bool v2; };
struct BFu0s_BFu1i_B { unsigned short :0; unsigned int v1:1; bool v2; };
struct BFu0s_BFu1ll_B { unsigned short :0; unsigned long long v1:1; bool v2; };
struct BFu0s_BFu1s_B { unsigned short :0; unsigned short v1:1; bool v2; };
struct BFu0s_BFu31i_B { unsigned short :0; unsigned int v1:31; bool v2; };
struct BFu0s_BFu31ll_B { unsigned short :0; unsigned long long v1:31; bool v2; };
struct BFu0s_BFu32i_B { unsigned short :0; unsigned int v1:32; bool v2; };
struct BFu0s_BFu32ll_B { unsigned short :0; unsigned long long v1:32; bool v2; };
struct BFu0s_BFu33_B { unsigned short :0; unsigned long long v1:33; bool v2; };
struct BFu0s_BFu7c_B { unsigned short :0; unsigned char v1:7; bool v2; };
struct BFu0s_BFu7i_B { unsigned short :0; unsigned int v1:7; bool v2; };
struct BFu0s_BFu7ll_B { unsigned short :0; unsigned long long v1:7; bool v2; };
struct BFu0s_BFu7s_B { unsigned short :0; unsigned short v1:7; bool v2; };
struct BFu0s_BFu8c_B { unsigned short :0; unsigned char v1:8; bool v2; };
struct BFu0s_BFu8i_B { unsigned short :0; unsigned int v1:8; bool v2; };
struct BFu0s_BFu8ll_B { unsigned short :0; unsigned long long v1:8; bool v2; };
struct BFu0s_BFu8s_B { unsigned short :0; unsigned short v1:8; bool v2; };
struct BFu0s_BFu9i_B { unsigned short :0; unsigned int v1:9; bool v2; };
struct BFu0s_BFu9ll_B { unsigned short :0; unsigned long long v1:9; bool v2; };
struct BFu0s_BFu9s_B { unsigned short :0; unsigned short v1:9; bool v2; };
struct BFu0s_C_B { unsigned short :0; char v1; bool v2; };
struct BFu0s_D_B { unsigned short :0; double v1; bool v2; };
struct BFu0s_F_B { unsigned short :0; float v1; bool v2; };
struct BFu0s_I_B { unsigned short :0; int v1; bool v2; };
struct BFu0s_Ip_B { unsigned short :0; int * v1; bool v2; };
struct BFu0s_L_B { unsigned short :0; long long v1; bool v2; };
struct BFu0s_S_B { unsigned short :0; short v1; bool v2; };
struct BFu0s_Uc_B { unsigned short :0; unsigned char v1; bool v2; };
struct BFu0s_Ui_B { unsigned short :0; unsigned int v1; bool v2; };
struct BFu0s_Ul_B { unsigned short :0; unsigned long long v1; bool v2; };
struct BFu0s_Us_B { unsigned short :0; unsigned short v1; bool v2; };
struct BFu0s_Vp_B { unsigned short :0; void * v1; bool v2; };
struct BFu15i_B_BFu0c { unsigned int v1:15; bool v2; unsigned char :0; };
struct BFu15i_B_BFu0i { unsigned int v1:15; bool v2; unsigned int :0; };
struct BFu15i_B_BFu0ll { unsigned int v1:15; bool v2; unsigned long long :0; };
struct BFu15i_B_BFu0s { unsigned int v1:15; bool v2; unsigned short :0; };
struct BFu15i_BFu0c_B { unsigned int v1:15; unsigned char :0; bool v2; };
struct BFu15i_BFu0i_B { unsigned int v1:15; unsigned int :0; bool v2; };
struct BFu15i_BFu0ll_B { unsigned int v1:15; unsigned long long :0; bool v2; };
struct BFu15i_BFu0s_B { unsigned int v1:15; unsigned short :0; bool v2; };
struct BFu15ll_B_BFu0c { unsigned long long v1:15; bool v2; unsigned char :0; };
struct BFu15ll_B_BFu0i { unsigned long long v1:15; bool v2; unsigned int :0; };
struct BFu15ll_B_BFu0ll { unsigned long long v1:15; bool v2; unsigned long long :0; };
struct BFu15ll_B_BFu0s { unsigned long long v1:15; bool v2; unsigned short :0; };
struct BFu15ll_BFu0c_B { unsigned long long v1:15; unsigned char :0; bool v2; };
struct BFu15ll_BFu0i_B { unsigned long long v1:15; unsigned int :0; bool v2; };
struct BFu15ll_BFu0ll_B { unsigned long long v1:15; unsigned long long :0; bool v2; };
struct BFu15ll_BFu0s_B { unsigned long long v1:15; unsigned short :0; bool v2; };
struct BFu15s_B_BFu0c { unsigned short v1:15; bool v2; unsigned char :0; };
struct BFu15s_B_BFu0i { unsigned short v1:15; bool v2; unsigned int :0; };
struct BFu15s_B_BFu0ll { unsigned short v1:15; bool v2; unsigned long long :0; };
struct BFu15s_B_BFu0s { unsigned short v1:15; bool v2; unsigned short :0; };
struct BFu15s_BFu0c_B { unsigned short v1:15; unsigned char :0; bool v2; };
struct BFu15s_BFu0i_B { unsigned short v1:15; unsigned int :0; bool v2; };
struct BFu15s_BFu0ll_B { unsigned short v1:15; unsigned long long :0; bool v2; };
struct BFu15s_BFu0s_B { unsigned short v1:15; unsigned short :0; bool v2; };
struct BFu16i_B_BFu0c { unsigned int v1:16; bool v2; unsigned char :0; };
struct BFu16i_B_BFu0i { unsigned int v1:16; bool v2; unsigned int :0; };
struct BFu16i_B_BFu0ll { unsigned int v1:16; bool v2; unsigned long long :0; };
struct BFu16i_B_BFu0s { unsigned int v1:16; bool v2; unsigned short :0; };
struct BFu16i_BFu0c_B { unsigned int v1:16; unsigned char :0; bool v2; };
struct BFu16i_BFu0i_B { unsigned int v1:16; unsigned int :0; bool v2; };
struct BFu16i_BFu0ll_B { unsigned int v1:16; unsigned long long :0; bool v2; };
struct BFu16i_BFu0s_B { unsigned int v1:16; unsigned short :0; bool v2; };
struct BFu16ll_B_BFu0c { unsigned long long v1:16; bool v2; unsigned char :0; };
struct BFu16ll_B_BFu0i { unsigned long long v1:16; bool v2; unsigned int :0; };
struct BFu16ll_B_BFu0ll { unsigned long long v1:16; bool v2; unsigned long long :0; };
struct BFu16ll_B_BFu0s { unsigned long long v1:16; bool v2; unsigned short :0; };
struct BFu16ll_BFu0c_B { unsigned long long v1:16; unsigned char :0; bool v2; };
struct BFu16ll_BFu0i_B { unsigned long long v1:16; unsigned int :0; bool v2; };
struct BFu16ll_BFu0ll_B { unsigned long long v1:16; unsigned long long :0; bool v2; };
struct BFu16ll_BFu0s_B { unsigned long long v1:16; unsigned short :0; bool v2; };
struct BFu16s_B_BFu0c { unsigned short v1:16; bool v2; unsigned char :0; };
struct BFu16s_B_BFu0i { unsigned short v1:16; bool v2; unsigned int :0; };
struct BFu16s_B_BFu0ll { unsigned short v1:16; bool v2; unsigned long long :0; };
struct BFu16s_B_BFu0s { unsigned short v1:16; bool v2; unsigned short :0; };
struct BFu16s_BFu0c_B { unsigned short v1:16; unsigned char :0; bool v2; };
struct BFu16s_BFu0i_B { unsigned short v1:16; unsigned int :0; bool v2; };
struct BFu16s_BFu0ll_B { unsigned short v1:16; unsigned long long :0; bool v2; };
struct BFu16s_BFu0s_B { unsigned short v1:16; unsigned short :0; bool v2; };
struct BFu17i_B_BFu0c { unsigned int v1:17; bool v2; unsigned char :0; };
struct BFu17i_B_BFu0i { unsigned int v1:17; bool v2; unsigned int :0; };
struct BFu17i_B_BFu0ll { unsigned int v1:17; bool v2; unsigned long long :0; };
struct BFu17i_B_BFu0s { unsigned int v1:17; bool v2; unsigned short :0; };
struct BFu17i_BFu0c_B { unsigned int v1:17; unsigned char :0; bool v2; };
struct BFu17i_BFu0i_B { unsigned int v1:17; unsigned int :0; bool v2; };
struct BFu17i_BFu0ll_B { unsigned int v1:17; unsigned long long :0; bool v2; };
struct BFu17i_BFu0s_B { unsigned int v1:17; unsigned short :0; bool v2; };
struct BFu17ll_B_BFu0c { unsigned long long v1:17; bool v2; unsigned char :0; };
struct BFu17ll_B_BFu0i { unsigned long long v1:17; bool v2; unsigned int :0; };
struct BFu17ll_B_BFu0ll { unsigned long long v1:17; bool v2; unsigned long long :0; };
struct BFu17ll_B_BFu0s { unsigned long long v1:17; bool v2; unsigned short :0; };
struct BFu17ll_BFu0c_B { unsigned long long v1:17; unsigned char :0; bool v2; };
struct BFu17ll_BFu0i_B { unsigned long long v1:17; unsigned int :0; bool v2; };
struct BFu17ll_BFu0ll_B { unsigned long long v1:17; unsigned long long :0; bool v2; };
struct BFu17ll_BFu0s_B { unsigned long long v1:17; unsigned short :0; bool v2; };
struct BFu1c_B_BFu0c { unsigned char v1:1; bool v2; unsigned char :0; };
struct BFu1c_B_BFu0i { unsigned char v1:1; bool v2; unsigned int :0; };
struct BFu1c_B_BFu0ll { unsigned char v1:1; bool v2; unsigned long long :0; };
struct BFu1c_B_BFu0s { unsigned char v1:1; bool v2; unsigned short :0; };
struct BFu1c_BFu0c_B { unsigned char v1:1; unsigned char :0; bool v2; };
struct BFu1c_BFu0i_B { unsigned char v1:1; unsigned int :0; bool v2; };
struct BFu1c_BFu0ll_B { unsigned char v1:1; unsigned long long :0; bool v2; };
struct BFu1c_BFu0s_B { unsigned char v1:1; unsigned short :0; bool v2; };
struct BFu1i_B_BFu0c { unsigned int v1:1; bool v2; unsigned char :0; };
struct BFu1i_B_BFu0i { unsigned int v1:1; bool v2; unsigned int :0; };
struct BFu1i_B_BFu0ll { unsigned int v1:1; bool v2; unsigned long long :0; };
struct BFu1i_B_BFu0s { unsigned int v1:1; bool v2; unsigned short :0; };
struct BFu1i_BFu0c_B { unsigned int v1:1; unsigned char :0; bool v2; };
struct BFu1i_BFu0i_B { unsigned int v1:1; unsigned int :0; bool v2; };
struct BFu1i_BFu0ll_B { unsigned int v1:1; unsigned long long :0; bool v2; };
struct BFu1i_BFu0s_B { unsigned int v1:1; unsigned short :0; bool v2; };
struct BFu1ll_B_BFu0c { unsigned long long v1:1; bool v2; unsigned char :0; };
struct BFu1ll_B_BFu0i { unsigned long long v1:1; bool v2; unsigned int :0; };
struct BFu1ll_B_BFu0ll { unsigned long long v1:1; bool v2; unsigned long long :0; };
struct BFu1ll_B_BFu0s { unsigned long long v1:1; bool v2; unsigned short :0; };
struct BFu1ll_BFu0c_B { unsigned long long v1:1; unsigned char :0; bool v2; };
struct BFu1ll_BFu0i_B { unsigned long long v1:1; unsigned int :0; bool v2; };
struct BFu1ll_BFu0ll_B { unsigned long long v1:1; unsigned long long :0; bool v2; };
struct BFu1ll_BFu0s_B { unsigned long long v1:1; unsigned short :0; bool v2; };
struct BFu1s_B_BFu0c { unsigned short v1:1; bool v2; unsigned char :0; };
struct BFu1s_B_BFu0i { unsigned short v1:1; bool v2; unsigned int :0; };
struct BFu1s_B_BFu0ll { unsigned short v1:1; bool v2; unsigned long long :0; };
struct BFu1s_B_BFu0s { unsigned short v1:1; bool v2; unsigned short :0; };
struct BFu1s_BFu0c_B { unsigned short v1:1; unsigned char :0; bool v2; };
struct BFu1s_BFu0i_B { unsigned short v1:1; unsigned int :0; bool v2; };
struct BFu1s_BFu0ll_B { unsigned short v1:1; unsigned long long :0; bool v2; };
struct BFu1s_BFu0s_B { unsigned short v1:1; unsigned short :0; bool v2; };
struct BFu31i_B_BFu0c { unsigned int v1:31; bool v2; unsigned char :0; };
struct BFu31i_B_BFu0i { unsigned int v1:31; bool v2; unsigned int :0; };
struct BFu31i_B_BFu0ll { unsigned int v1:31; bool v2; unsigned long long :0; };
struct BFu31i_B_BFu0s { unsigned int v1:31; bool v2; unsigned short :0; };
struct BFu31i_BFu0c_B { unsigned int v1:31; unsigned char :0; bool v2; };
struct BFu31i_BFu0i_B { unsigned int v1:31; unsigned int :0; bool v2; };
struct BFu31i_BFu0ll_B { unsigned int v1:31; unsigned long long :0; bool v2; };
struct BFu31i_BFu0s_B { unsigned int v1:31; unsigned short :0; bool v2; };
struct BFu31ll_B_BFu0c { unsigned long long v1:31; bool v2; unsigned char :0; };
struct BFu31ll_B_BFu0i { unsigned long long v1:31; bool v2; unsigned int :0; };
struct BFu31ll_B_BFu0ll { unsigned long long v1:31; bool v2; unsigned long long :0; };
struct BFu31ll_B_BFu0s { unsigned long long v1:31; bool v2; unsigned short :0; };
struct BFu31ll_BFu0c_B { unsigned long long v1:31; unsigned char :0; bool v2; };
struct BFu31ll_BFu0i_B { unsigned long long v1:31; unsigned int :0; bool v2; };
struct BFu31ll_BFu0ll_B { unsigned long long v1:31; unsigned long long :0; bool v2; };
struct BFu31ll_BFu0s_B { unsigned long long v1:31; unsigned short :0; bool v2; };
struct BFu32i_B_BFu0c { unsigned int v1:32; bool v2; unsigned char :0; };
struct BFu32i_B_BFu0i { unsigned int v1:32; bool v2; unsigned int :0; };
struct BFu32i_B_BFu0ll { unsigned int v1:32; bool v2; unsigned long long :0; };
struct BFu32i_B_BFu0s { unsigned int v1:32; bool v2; unsigned short :0; };
struct BFu32i_BFu0c_B { unsigned int v1:32; unsigned char :0; bool v2; };
struct BFu32i_BFu0i_B { unsigned int v1:32; unsigned int :0; bool v2; };
struct BFu32i_BFu0ll_B { unsigned int v1:32; unsigned long long :0; bool v2; };
struct BFu32i_BFu0s_B { unsigned int v1:32; unsigned short :0; bool v2; };
struct BFu32ll_B_BFu0c { unsigned long long v1:32; bool v2; unsigned char :0; };
struct BFu32ll_B_BFu0i { unsigned long long v1:32; bool v2; unsigned int :0; };
struct BFu32ll_B_BFu0ll { unsigned long long v1:32; bool v2; unsigned long long :0; };
struct BFu32ll_B_BFu0s { unsigned long long v1:32; bool v2; unsigned short :0; };
struct BFu32ll_BFu0c_B { unsigned long long v1:32; unsigned char :0; bool v2; };
struct BFu32ll_BFu0i_B { unsigned long long v1:32; unsigned int :0; bool v2; };
struct BFu32ll_BFu0ll_B { unsigned long long v1:32; unsigned long long :0; bool v2; };
struct BFu32ll_BFu0s_B { unsigned long long v1:32; unsigned short :0; bool v2; };
struct BFu33_B_BFu0c { unsigned long long v1:33; bool v2; unsigned char :0; };
struct BFu33_B_BFu0i { unsigned long long v1:33; bool v2; unsigned int :0; };
struct BFu33_B_BFu0ll { unsigned long long v1:33; bool v2; unsigned long long :0; };
struct BFu33_B_BFu0s { unsigned long long v1:33; bool v2; unsigned short :0; };
struct BFu33_BFu0c_B { unsigned long long v1:33; unsigned char :0; bool v2; };
struct BFu33_BFu0i_B { unsigned long long v1:33; unsigned int :0; bool v2; };
struct BFu33_BFu0ll_B { unsigned long long v1:33; unsigned long long :0; bool v2; };
struct BFu33_BFu0s_B { unsigned long long v1:33; unsigned short :0; bool v2; };
struct BFu7c_B_BFu0c { unsigned char v1:7; bool v2; unsigned char :0; };
struct BFu7c_B_BFu0i { unsigned char v1:7; bool v2; unsigned int :0; };
struct BFu7c_B_BFu0ll { unsigned char v1:7; bool v2; unsigned long long :0; };
struct BFu7c_B_BFu0s { unsigned char v1:7; bool v2; unsigned short :0; };
struct BFu7c_BFu0c_B { unsigned char v1:7; unsigned char :0; bool v2; };
struct BFu7c_BFu0i_B { unsigned char v1:7; unsigned int :0; bool v2; };
struct BFu7c_BFu0ll_B { unsigned char v1:7; unsigned long long :0; bool v2; };
struct BFu7c_BFu0s_B { unsigned char v1:7; unsigned short :0; bool v2; };
struct BFu7i_B_BFu0c { unsigned int v1:7; bool v2; unsigned char :0; };
struct BFu7i_B_BFu0i { unsigned int v1:7; bool v2; unsigned int :0; };
struct BFu7i_B_BFu0ll { unsigned int v1:7; bool v2; unsigned long long :0; };
struct BFu7i_B_BFu0s { unsigned int v1:7; bool v2; unsigned short :0; };
struct BFu7i_BFu0c_B { unsigned int v1:7; unsigned char :0; bool v2; };
struct BFu7i_BFu0i_B { unsigned int v1:7; unsigned int :0; bool v2; };
struct BFu7i_BFu0ll_B { unsigned int v1:7; unsigned long long :0; bool v2; };
struct BFu7i_BFu0s_B { unsigned int v1:7; unsigned short :0; bool v2; };
struct BFu7ll_B_BFu0c { unsigned long long v1:7; bool v2; unsigned char :0; };
struct BFu7ll_B_BFu0i { unsigned long long v1:7; bool v2; unsigned int :0; };
struct BFu7ll_B_BFu0ll { unsigned long long v1:7; bool v2; unsigned long long :0; };
struct BFu7ll_B_BFu0s { unsigned long long v1:7; bool v2; unsigned short :0; };
struct BFu7ll_BFu0c_B { unsigned long long v1:7; unsigned char :0; bool v2; };
struct BFu7ll_BFu0i_B { unsigned long long v1:7; unsigned int :0; bool v2; };
struct BFu7ll_BFu0ll_B { unsigned long long v1:7; unsigned long long :0; bool v2; };
struct BFu7ll_BFu0s_B { unsigned long long v1:7; unsigned short :0; bool v2; };
struct BFu7s_B_BFu0c { unsigned short v1:7; bool v2; unsigned char :0; };
struct BFu7s_B_BFu0i { unsigned short v1:7; bool v2; unsigned int :0; };
struct BFu7s_B_BFu0ll { unsigned short v1:7; bool v2; unsigned long long :0; };
struct BFu7s_B_BFu0s { unsigned short v1:7; bool v2; unsigned short :0; };
struct BFu7s_BFu0c_B { unsigned short v1:7; unsigned char :0; bool v2; };
struct BFu7s_BFu0i_B { unsigned short v1:7; unsigned int :0; bool v2; };
struct BFu7s_BFu0ll_B { unsigned short v1:7; unsigned long long :0; bool v2; };
struct BFu7s_BFu0s_B { unsigned short v1:7; unsigned short :0; bool v2; };
struct BFu8c_B_BFu0c { unsigned char v1:8; bool v2; unsigned char :0; };
struct BFu8c_B_BFu0i { unsigned char v1:8; bool v2; unsigned int :0; };
struct BFu8c_B_BFu0ll { unsigned char v1:8; bool v2; unsigned long long :0; };
struct BFu8c_B_BFu0s { unsigned char v1:8; bool v2; unsigned short :0; };
struct BFu8c_BFu0c_B { unsigned char v1:8; unsigned char :0; bool v2; };
struct BFu8c_BFu0i_B { unsigned char v1:8; unsigned int :0; bool v2; };
struct BFu8c_BFu0ll_B { unsigned char v1:8; unsigned long long :0; bool v2; };
struct BFu8c_BFu0s_B { unsigned char v1:8; unsigned short :0; bool v2; };
struct BFu8i_B_BFu0c { unsigned int v1:8; bool v2; unsigned char :0; };
struct BFu8i_B_BFu0i { unsigned int v1:8; bool v2; unsigned int :0; };
struct BFu8i_B_BFu0ll { unsigned int v1:8; bool v2; unsigned long long :0; };
struct BFu8i_B_BFu0s { unsigned int v1:8; bool v2; unsigned short :0; };
struct BFu8i_BFu0c_B { unsigned int v1:8; unsigned char :0; bool v2; };
struct BFu8i_BFu0i_B { unsigned int v1:8; unsigned int :0; bool v2; };
struct BFu8i_BFu0ll_B { unsigned int v1:8; unsigned long long :0; bool v2; };
struct BFu8i_BFu0s_B { unsigned int v1:8; unsigned short :0; bool v2; };
struct BFu8ll_B_BFu0c { unsigned long long v1:8; bool v2; unsigned char :0; };
struct BFu8ll_B_BFu0i { unsigned long long v1:8; bool v2; unsigned int :0; };
struct BFu8ll_B_BFu0ll { unsigned long long v1:8; bool v2; unsigned long long :0; };
struct BFu8ll_B_BFu0s { unsigned long long v1:8; bool v2; unsigned short :0; };
struct BFu8ll_BFu0c_B { unsigned long long v1:8; unsigned char :0; bool v2; };
struct BFu8ll_BFu0i_B { unsigned long long v1:8; unsigned int :0; bool v2; };
struct BFu8ll_BFu0ll_B { unsigned long long v1:8; unsigned long long :0; bool v2; };
struct BFu8ll_BFu0s_B { unsigned long long v1:8; unsigned short :0; bool v2; };
struct BFu8s_B_BFu0c { unsigned short v1:8; bool v2; unsigned char :0; };
struct BFu8s_B_BFu0i { unsigned short v1:8; bool v2; unsigned int :0; };
struct BFu8s_B_BFu0ll { unsigned short v1:8; bool v2; unsigned long long :0; };
struct BFu8s_B_BFu0s { unsigned short v1:8; bool v2; unsigned short :0; };
struct BFu8s_BFu0c_B { unsigned short v1:8; unsigned char :0; bool v2; };
struct BFu8s_BFu0i_B { unsigned short v1:8; unsigned int :0; bool v2; };
struct BFu8s_BFu0ll_B { unsigned short v1:8; unsigned long long :0; bool v2; };
struct BFu8s_BFu0s_B { unsigned short v1:8; unsigned short :0; bool v2; };
struct BFu9i_B_BFu0c { unsigned int v1:9; bool v2; unsigned char :0; };
struct BFu9i_B_BFu0i { unsigned int v1:9; bool v2; unsigned int :0; };
struct BFu9i_B_BFu0ll { unsigned int v1:9; bool v2; unsigned long long :0; };
struct BFu9i_B_BFu0s { unsigned int v1:9; bool v2; unsigned short :0; };
struct BFu9i_BFu0c_B { unsigned int v1:9; unsigned char :0; bool v2; };
struct BFu9i_BFu0i_B { unsigned int v1:9; unsigned int :0; bool v2; };
struct BFu9i_BFu0ll_B { unsigned int v1:9; unsigned long long :0; bool v2; };
struct BFu9i_BFu0s_B { unsigned int v1:9; unsigned short :0; bool v2; };
struct BFu9ll_B_BFu0c { unsigned long long v1:9; bool v2; unsigned char :0; };
struct BFu9ll_B_BFu0i { unsigned long long v1:9; bool v2; unsigned int :0; };
struct BFu9ll_B_BFu0ll { unsigned long long v1:9; bool v2; unsigned long long :0; };
struct BFu9ll_B_BFu0s { unsigned long long v1:9; bool v2; unsigned short :0; };
struct BFu9ll_BFu0c_B { unsigned long long v1:9; unsigned char :0; bool v2; };
struct BFu9ll_BFu0i_B { unsigned long long v1:9; unsigned int :0; bool v2; };
struct BFu9ll_BFu0ll_B { unsigned long long v1:9; unsigned long long :0; bool v2; };
struct BFu9ll_BFu0s_B { unsigned long long v1:9; unsigned short :0; bool v2; };
struct BFu9s_B_BFu0c { unsigned short v1:9; bool v2; unsigned char :0; };
struct BFu9s_B_BFu0i { unsigned short v1:9; bool v2; unsigned int :0; };
struct BFu9s_B_BFu0ll { unsigned short v1:9; bool v2; unsigned long long :0; };
struct BFu9s_B_BFu0s { unsigned short v1:9; bool v2; unsigned short :0; };
struct BFu9s_BFu0c_B { unsigned short v1:9; unsigned char :0; bool v2; };
struct BFu9s_BFu0i_B { unsigned short v1:9; unsigned int :0; bool v2; };
struct BFu9s_BFu0ll_B { unsigned short v1:9; unsigned long long :0; bool v2; };
struct BFu9s_BFu0s_B { unsigned short v1:9; unsigned short :0; bool v2; };
struct C_B_BFu0c { char v1; bool v2; unsigned char :0; };
struct C_B_BFu0i { char v1; bool v2; unsigned int :0; };
struct C_B_BFu0ll { char v1; bool v2; unsigned long long :0; };
struct C_B_BFu0s { char v1; bool v2; unsigned short :0; };
struct C_BFu0c_B { char v1; unsigned char :0; bool v2; };
struct C_BFu0i_B { char v1; unsigned int :0; bool v2; };
struct C_BFu0ll_B { char v1; unsigned long long :0; bool v2; };
struct C_BFu0s_B { char v1; unsigned short :0; bool v2; };
struct D_B_BFu0c { double v1; bool v2; unsigned char :0; };
struct D_B_BFu0i { double v1; bool v2; unsigned int :0; };
struct D_B_BFu0ll { double v1; bool v2; unsigned long long :0; };
struct D_B_BFu0s { double v1; bool v2; unsigned short :0; };
struct D_BFu0c_B { double v1; unsigned char :0; bool v2; };
struct D_BFu0i_B { double v1; unsigned int :0; bool v2; };
struct D_BFu0ll_B { double v1; unsigned long long :0; bool v2; };
struct D_BFu0s_B { double v1; unsigned short :0; bool v2; };
struct F_B_BFu0c { float v1; bool v2; unsigned char :0; };
struct F_B_BFu0i { float v1; bool v2; unsigned int :0; };
struct F_B_BFu0ll { float v1; bool v2; unsigned long long :0; };
struct F_B_BFu0s { float v1; bool v2; unsigned short :0; };
struct F_BFu0c_B { float v1; unsigned char :0; bool v2; };
struct F_BFu0i_B { float v1; unsigned int :0; bool v2; };
struct F_BFu0ll_B { float v1; unsigned long long :0; bool v2; };
struct F_BFu0s_B { float v1; unsigned short :0; bool v2; };
struct I_B_BFu0c { int v1; bool v2; unsigned char :0; };
struct I_B_BFu0i { int v1; bool v2; unsigned int :0; };
struct I_B_BFu0ll { int v1; bool v2; unsigned long long :0; };
struct I_B_BFu0s { int v1; bool v2; unsigned short :0; };
struct I_BFu0c_B { int v1; unsigned char :0; bool v2; };
struct I_BFu0i_B { int v1; unsigned int :0; bool v2; };
struct I_BFu0ll_B { int v1; unsigned long long :0; bool v2; };
struct I_BFu0s_B { int v1; unsigned short :0; bool v2; };
struct Ip_B_BFu0c { int * v1; bool v2; unsigned char :0; };
struct Ip_B_BFu0i { int * v1; bool v2; unsigned int :0; };
struct Ip_B_BFu0ll { int * v1; bool v2; unsigned long long :0; };
struct Ip_B_BFu0s { int * v1; bool v2; unsigned short :0; };
struct Ip_BFu0c_B { int * v1; unsigned char :0; bool v2; };
struct Ip_BFu0i_B { int * v1; unsigned int :0; bool v2; };
struct Ip_BFu0ll_B { int * v1; unsigned long long :0; bool v2; };
struct Ip_BFu0s_B { int * v1; unsigned short :0; bool v2; };
struct L_B_BFu0c { long long v1; bool v2; unsigned char :0; };
struct L_B_BFu0i { long long v1; bool v2; unsigned int :0; };
struct L_B_BFu0ll { long long v1; bool v2; unsigned long long :0; };
struct L_B_BFu0s { long long v1; bool v2; unsigned short :0; };
struct L_BFu0c_B { long long v1; unsigned char :0; bool v2; };
struct L_BFu0i_B { long long v1; unsigned int :0; bool v2; };
struct L_BFu0ll_B { long long v1; unsigned long long :0; bool v2; };
struct L_BFu0s_B { long long v1; unsigned short :0; bool v2; };
struct S_B_BFu0c { short v1; bool v2; unsigned char :0; };
struct S_B_BFu0i { short v1; bool v2; unsigned int :0; };
struct S_B_BFu0ll { short v1; bool v2; unsigned long long :0; };
struct S_B_BFu0s { short v1; bool v2; unsigned short :0; };
struct S_BFu0c_B { short v1; unsigned char :0; bool v2; };
struct S_BFu0i_B { short v1; unsigned int :0; bool v2; };
struct S_BFu0ll_B { short v1; unsigned long long :0; bool v2; };
struct S_BFu0s_B { short v1; unsigned short :0; bool v2; };
struct Uc_B_BFu0c { unsigned char v1; bool v2; unsigned char :0; };
struct Uc_B_BFu0i { unsigned char v1; bool v2; unsigned int :0; };
struct Uc_B_BFu0ll { unsigned char v1; bool v2; unsigned long long :0; };
struct Uc_B_BFu0s { unsigned char v1; bool v2; unsigned short :0; };
struct Uc_BFu0c_B { unsigned char v1; unsigned char :0; bool v2; };
struct Uc_BFu0i_B { unsigned char v1; unsigned int :0; bool v2; };
struct Uc_BFu0ll_B { unsigned char v1; unsigned long long :0; bool v2; };
struct Uc_BFu0s_B { unsigned char v1; unsigned short :0; bool v2; };
struct Ui_B_BFu0c { unsigned int v1; bool v2; unsigned char :0; };
struct Ui_B_BFu0i { unsigned int v1; bool v2; unsigned int :0; };
struct Ui_B_BFu0ll { unsigned int v1; bool v2; unsigned long long :0; };
struct Ui_B_BFu0s { unsigned int v1; bool v2; unsigned short :0; };
struct Ui_BFu0c_B { unsigned int v1; unsigned char :0; bool v2; };
struct Ui_BFu0i_B { unsigned int v1; unsigned int :0; bool v2; };
struct Ui_BFu0ll_B { unsigned int v1; unsigned long long :0; bool v2; };
struct Ui_BFu0s_B { unsigned int v1; unsigned short :0; bool v2; };
struct Ul_B_BFu0c { unsigned long long v1; bool v2; unsigned char :0; };
struct Ul_B_BFu0i { unsigned long long v1; bool v2; unsigned int :0; };
struct Ul_B_BFu0ll { unsigned long long v1; bool v2; unsigned long long :0; };
struct Ul_B_BFu0s { unsigned long long v1; bool v2; unsigned short :0; };
struct Ul_BFu0c_B { unsigned long long v1; unsigned char :0; bool v2; };
struct Ul_BFu0i_B { unsigned long long v1; unsigned int :0; bool v2; };
struct Ul_BFu0ll_B { unsigned long long v1; unsigned long long :0; bool v2; };
struct Ul_BFu0s_B { unsigned long long v1; unsigned short :0; bool v2; };
struct Us_B_BFu0c { unsigned short v1; bool v2; unsigned char :0; };
struct Us_B_BFu0i { unsigned short v1; bool v2; unsigned int :0; };
struct Us_B_BFu0ll { unsigned short v1; bool v2; unsigned long long :0; };
struct Us_B_BFu0s { unsigned short v1; bool v2; unsigned short :0; };
struct Us_BFu0c_B { unsigned short v1; unsigned char :0; bool v2; };
struct Us_BFu0i_B { unsigned short v1; unsigned int :0; bool v2; };
struct Us_BFu0ll_B { unsigned short v1; unsigned long long :0; bool v2; };
struct Us_BFu0s_B { unsigned short v1; unsigned short :0; bool v2; };
struct Vp_B_BFu0c { void * v1; bool v2; unsigned char :0; };
struct Vp_B_BFu0i { void * v1; bool v2; unsigned int :0; };
struct Vp_B_BFu0ll { void * v1; bool v2; unsigned long long :0; };
struct Vp_B_BFu0s { void * v1; bool v2; unsigned short :0; };
struct Vp_BFu0c_B { void * v1; unsigned char :0; bool v2; };
struct Vp_BFu0i_B { void * v1; unsigned int :0; bool v2; };
struct Vp_BFu0ll_B { void * v1; unsigned long long :0; bool v2; };
struct Vp_BFu0s_B { void * v1; unsigned short :0; bool v2; };
#endif // __cplusplus
#ifdef __cplusplus


static void Test_aB_B_BFu0c()
{
  {
    init_simple_test("aB_B_BFu0c");
    static aB_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_B_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaB_B_BFu0c(Test_aB_B_BFu0c, "aB_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu0i()
{
  {
    init_simple_test("aB_B_BFu0i");
    static aB_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_B_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaB_B_BFu0i(Test_aB_B_BFu0i, "aB_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu0ll()
{
  {
    init_simple_test("aB_B_BFu0ll");
    static aB_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_B_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaB_B_BFu0ll(Test_aB_B_BFu0ll, "aB_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu0s()
{
  {
    init_simple_test("aB_B_BFu0s");
    static aB_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_B_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaB_B_BFu0s(Test_aB_B_BFu0s, "aB_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c()
{
  {
    init_simple_test("aB_BFu0c");
    static aB_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aB_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0c(Test_aB_BFu0c, "aB_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_B()
{
  {
    init_simple_test("aB_BFu0c_B");
    static aB_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_B.v1");
    check_field_offset(lv, v2, 1, "aB_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_B(Test_aB_BFu0c_B, "aB_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu0c()
{
  {
    init_simple_test("aB_BFu0c_BFu0c");
    static aB_BFu0c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aB_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu0c(Test_aB_BFu0c_BFu0c, "aB_BFu0c_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu0i()
{
  {
    init_simple_test("aB_BFu0c_BFu0i");
    static aB_BFu0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu0i(Test_aB_BFu0c_BFu0i, "aB_BFu0c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu0ll()
{
  {
    init_simple_test("aB_BFu0c_BFu0ll");
    static aB_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu0c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu0ll(Test_aB_BFu0c_BFu0ll, "aB_BFu0c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu0s()
{
  {
    init_simple_test("aB_BFu0c_BFu0s");
    static aB_BFu0c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aB_BFu0c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu0s(Test_aB_BFu0c_BFu0s, "aB_BFu0c_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu15i()
{
  {
    init_simple_test("aB_BFu0c_BFu15i");
    static aB_BFu0c_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu0c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu0c_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu15i(Test_aB_BFu0c_BFu15i, "aB_BFu0c_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu15ll()
{
  {
    init_simple_test("aB_BFu0c_BFu15ll");
    static aB_BFu0c_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu0c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu0c_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu15ll(Test_aB_BFu0c_BFu15ll, "aB_BFu0c_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu15s()
{
  {
    init_simple_test("aB_BFu0c_BFu15s");
    static aB_BFu0c_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu0c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu0c_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu15s(Test_aB_BFu0c_BFu15s, "aB_BFu0c_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu16i()
{
  {
    init_simple_test("aB_BFu0c_BFu16i");
    static aB_BFu0c_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu0c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu0c_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu16i(Test_aB_BFu0c_BFu16i, "aB_BFu0c_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu16ll()
{
  {
    init_simple_test("aB_BFu0c_BFu16ll");
    static aB_BFu0c_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu0c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu0c_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu16ll(Test_aB_BFu0c_BFu16ll, "aB_BFu0c_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu16s()
{
  {
    init_simple_test("aB_BFu0c_BFu16s");
    static aB_BFu0c_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu0c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu0c_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu16s(Test_aB_BFu0c_BFu16s, "aB_BFu0c_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu17i()
{
  {
    init_simple_test("aB_BFu0c_BFu17i");
    static aB_BFu0c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu0c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu0c_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu17i(Test_aB_BFu0c_BFu17i, "aB_BFu0c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu17ll()
{
  {
    init_simple_test("aB_BFu0c_BFu17ll");
    static aB_BFu0c_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu0c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu0c_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu17ll(Test_aB_BFu0c_BFu17ll, "aB_BFu0c_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu1c()
{
  {
    init_simple_test("aB_BFu0c_BFu1c");
    static aB_BFu0c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu0c_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu1c(Test_aB_BFu0c_BFu1c, "aB_BFu0c_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu1i()
{
  {
    init_simple_test("aB_BFu0c_BFu1i");
    static aB_BFu0c_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu0c_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu1i(Test_aB_BFu0c_BFu1i, "aB_BFu0c_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu1ll()
{
  {
    init_simple_test("aB_BFu0c_BFu1ll");
    static aB_BFu0c_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu0c_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu1ll(Test_aB_BFu0c_BFu1ll, "aB_BFu0c_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu1s()
{
  {
    init_simple_test("aB_BFu0c_BFu1s");
    static aB_BFu0c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu0c_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu1s(Test_aB_BFu0c_BFu1s, "aB_BFu0c_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu31i()
{
  {
    init_simple_test("aB_BFu0c_BFu31i");
    static aB_BFu0c_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu0c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu0c_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu31i(Test_aB_BFu0c_BFu31i, "aB_BFu0c_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu31ll()
{
  {
    init_simple_test("aB_BFu0c_BFu31ll");
    static aB_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu0c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu0c_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu31ll(Test_aB_BFu0c_BFu31ll, "aB_BFu0c_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu32i()
{
  {
    init_simple_test("aB_BFu0c_BFu32i");
    static aB_BFu0c_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu0c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu0c_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu32i(Test_aB_BFu0c_BFu32i, "aB_BFu0c_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu32ll()
{
  {
    init_simple_test("aB_BFu0c_BFu32ll");
    static aB_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu0c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu0c_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu32ll(Test_aB_BFu0c_BFu32ll, "aB_BFu0c_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu33()
{
  {
    init_simple_test("aB_BFu0c_BFu33");
    static aB_BFu0c_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu0c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu0c_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu33(Test_aB_BFu0c_BFu33, "aB_BFu0c_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu7c()
{
  {
    init_simple_test("aB_BFu0c_BFu7c");
    static aB_BFu0c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu0c_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu7c(Test_aB_BFu0c_BFu7c, "aB_BFu0c_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu7i()
{
  {
    init_simple_test("aB_BFu0c_BFu7i");
    static aB_BFu0c_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu0c_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu7i(Test_aB_BFu0c_BFu7i, "aB_BFu0c_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu7ll()
{
  {
    init_simple_test("aB_BFu0c_BFu7ll");
    static aB_BFu0c_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu0c_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu7ll(Test_aB_BFu0c_BFu7ll, "aB_BFu0c_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu7s()
{
  {
    init_simple_test("aB_BFu0c_BFu7s");
    static aB_BFu0c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu0c_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu7s(Test_aB_BFu0c_BFu7s, "aB_BFu0c_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu8c()
{
  {
    init_simple_test("aB_BFu0c_BFu8c");
    static aB_BFu0c_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu0c_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu8c(Test_aB_BFu0c_BFu8c, "aB_BFu0c_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu8i()
{
  {
    init_simple_test("aB_BFu0c_BFu8i");
    static aB_BFu0c_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu0c_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu8i(Test_aB_BFu0c_BFu8i, "aB_BFu0c_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu8ll()
{
  {
    init_simple_test("aB_BFu0c_BFu8ll");
    static aB_BFu0c_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu0c_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu8ll(Test_aB_BFu0c_BFu8ll, "aB_BFu0c_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu8s()
{
  {
    init_simple_test("aB_BFu0c_BFu8s");
    static aB_BFu0c_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu0c_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu8s(Test_aB_BFu0c_BFu8s, "aB_BFu0c_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu9i()
{
  {
    init_simple_test("aB_BFu0c_BFu9i");
    static aB_BFu0c_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu0c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu0c_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu9i(Test_aB_BFu0c_BFu9i, "aB_BFu0c_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu9ll()
{
  {
    init_simple_test("aB_BFu0c_BFu9ll");
    static aB_BFu0c_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu0c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu0c_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu9ll(Test_aB_BFu0c_BFu9ll, "aB_BFu0c_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_BFu9s()
{
  {
    init_simple_test("aB_BFu0c_BFu9s");
    static aB_BFu0c_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu0c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu0c_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_BFu9s(Test_aB_BFu0c_BFu9s, "aB_BFu0c_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_C()
{
  {
    init_simple_test("aB_BFu0c_C");
    static aB_BFu0c_C lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_C)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_C.v1");
    check_field_offset(lv, v2, 1, "aB_BFu0c_C.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_C(Test_aB_BFu0c_C, "aB_BFu0c_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_D()
{
  {
    init_simple_test("aB_BFu0c_D");
    static aB_BFu0c_D lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu0c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_D)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_D.v1");
    check_field_offset(lv, v2, 1, "aB_BFu0c_D.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_D(Test_aB_BFu0c_D, "aB_BFu0c_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_F()
{
  {
    init_simple_test("aB_BFu0c_F");
    static aB_BFu0c_F lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu0c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_F)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_F.v1");
    check_field_offset(lv, v2, 1, "aB_BFu0c_F.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_F(Test_aB_BFu0c_F, "aB_BFu0c_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_I()
{
  {
    init_simple_test("aB_BFu0c_I");
    static aB_BFu0c_I lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu0c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_I)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_I.v1");
    check_field_offset(lv, v2, 1, "aB_BFu0c_I.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_I(Test_aB_BFu0c_I, "aB_BFu0c_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_Ip()
{
  {
    init_simple_test("aB_BFu0c_Ip");
    static aB_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_Ip.v1");
    check_field_offset(lv, v2, 1, "aB_BFu0c_Ip.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_Ip(Test_aB_BFu0c_Ip, "aB_BFu0c_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_L()
{
  {
    init_simple_test("aB_BFu0c_L");
    static aB_BFu0c_L lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu0c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_L)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_L.v1");
    check_field_offset(lv, v2, 1, "aB_BFu0c_L.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_L(Test_aB_BFu0c_L, "aB_BFu0c_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_S()
{
  {
    init_simple_test("aB_BFu0c_S");
    static aB_BFu0c_S lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu0c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_S)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_S.v1");
    check_field_offset(lv, v2, 1, "aB_BFu0c_S.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_S(Test_aB_BFu0c_S, "aB_BFu0c_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_Uc()
{
  {
    init_simple_test("aB_BFu0c_Uc");
    static aB_BFu0c_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu0c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_Uc.v1");
    check_field_offset(lv, v2, 1, "aB_BFu0c_Uc.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_Uc(Test_aB_BFu0c_Uc, "aB_BFu0c_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_Ui()
{
  {
    init_simple_test("aB_BFu0c_Ui");
    static aB_BFu0c_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu0c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_Ui.v1");
    check_field_offset(lv, v2, 1, "aB_BFu0c_Ui.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_Ui(Test_aB_BFu0c_Ui, "aB_BFu0c_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_Ul()
{
  {
    init_simple_test("aB_BFu0c_Ul");
    static aB_BFu0c_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu0c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_Ul.v1");
    check_field_offset(lv, v2, 1, "aB_BFu0c_Ul.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_Ul(Test_aB_BFu0c_Ul, "aB_BFu0c_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_Us()
{
  {
    init_simple_test("aB_BFu0c_Us");
    static aB_BFu0c_Us lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu0c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_Us.v1");
    check_field_offset(lv, v2, 1, "aB_BFu0c_Us.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_Us(Test_aB_BFu0c_Us, "aB_BFu0c_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0c_Vp()
{
  {
    init_simple_test("aB_BFu0c_Vp");
    static aB_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0c_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu0c_Vp.v1");
    check_field_offset(lv, v2, 1, "aB_BFu0c_Vp.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0c_Vp(Test_aB_BFu0c_Vp, "aB_BFu0c_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i()
{
  {
    init_simple_test("aB_BFu0i");
    static aB_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0i(Test_aB_BFu0i, "aB_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_B()
{
  {
    init_simple_test("aB_BFu0i_B");
    static aB_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_B.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aB_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_B(Test_aB_BFu0i_B, "aB_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu0c()
{
  {
    init_simple_test("aB_BFu0i_BFu0c");
    static aB_BFu0i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu0c(Test_aB_BFu0i_BFu0c, "aB_BFu0i_BFu0c", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu0i()
{
  {
    init_simple_test("aB_BFu0i_BFu0i");
    static aB_BFu0i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu0i(Test_aB_BFu0i_BFu0i, "aB_BFu0i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu0ll()
{
  {
    init_simple_test("aB_BFu0i_BFu0ll");
    static aB_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu0i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu0ll(Test_aB_BFu0i_BFu0ll, "aB_BFu0i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu0s()
{
  {
    init_simple_test("aB_BFu0i_BFu0s");
    static aB_BFu0i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu0s(Test_aB_BFu0i_BFu0s, "aB_BFu0i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu15i()
{
  {
    init_simple_test("aB_BFu0i_BFu15i");
    static aB_BFu0i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, 1, "aB_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, hide_ull(1LL<<14), "aB_BFu0i_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu15i(Test_aB_BFu0i_BFu15i, "aB_BFu0i_BFu15i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu15ll()
{
  {
    init_simple_test("aB_BFu0i_BFu15ll");
    static aB_BFu0i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, 1, "aB_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, hide_ull(1LL<<14), "aB_BFu0i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu15ll(Test_aB_BFu0i_BFu15ll, "aB_BFu0i_BFu15ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu15s()
{
  {
    init_simple_test("aB_BFu0i_BFu15s");
    static aB_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, 1, "aB_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, hide_ull(1LL<<14), "aB_BFu0i_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu15s(Test_aB_BFu0i_BFu15s, "aB_BFu0i_BFu15s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu16i()
{
  {
    init_simple_test("aB_BFu0i_BFu16i");
    static aB_BFu0i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, 1, "aB_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, hide_ull(1LL<<15), "aB_BFu0i_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu16i(Test_aB_BFu0i_BFu16i, "aB_BFu0i_BFu16i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu16ll()
{
  {
    init_simple_test("aB_BFu0i_BFu16ll");
    static aB_BFu0i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, 1, "aB_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, hide_ull(1LL<<15), "aB_BFu0i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu16ll(Test_aB_BFu0i_BFu16ll, "aB_BFu0i_BFu16ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu16s()
{
  {
    init_simple_test("aB_BFu0i_BFu16s");
    static aB_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, 1, "aB_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, hide_ull(1LL<<15), "aB_BFu0i_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu16s(Test_aB_BFu0i_BFu16s, "aB_BFu0i_BFu16s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu17i()
{
  {
    init_simple_test("aB_BFu0i_BFu17i");
    static aB_BFu0i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aB_BFu0i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, 1, "aB_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, hide_ull(1LL<<16), "aB_BFu0i_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu17i(Test_aB_BFu0i_BFu17i, "aB_BFu0i_BFu17i", ABISELECT(7,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu17ll()
{
  {
    init_simple_test("aB_BFu0i_BFu17ll");
    static aB_BFu0i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aB_BFu0i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, 1, "aB_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, hide_ull(1LL<<16), "aB_BFu0i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu17ll(Test_aB_BFu0i_BFu17ll, "aB_BFu0i_BFu17ll", ABISELECT(7,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu1c()
{
  {
    init_simple_test("aB_BFu0i_BFu1c");
    static aB_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "aB_BFu0i_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu1c(Test_aB_BFu0i_BFu1c, "aB_BFu0i_BFu1c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu1i()
{
  {
    init_simple_test("aB_BFu0i_BFu1i");
    static aB_BFu0i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "aB_BFu0i_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu1i(Test_aB_BFu0i_BFu1i, "aB_BFu0i_BFu1i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu1ll()
{
  {
    init_simple_test("aB_BFu0i_BFu1ll");
    static aB_BFu0i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "aB_BFu0i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu1ll(Test_aB_BFu0i_BFu1ll, "aB_BFu0i_BFu1ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu1s()
{
  {
    init_simple_test("aB_BFu0i_BFu1s");
    static aB_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "aB_BFu0i_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu1s(Test_aB_BFu0i_BFu1s, "aB_BFu0i_BFu1s", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu31i()
{
  {
    init_simple_test("aB_BFu0i_BFu31i");
    static aB_BFu0i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu0i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, 1, "aB_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, hide_ull(1LL<<30), "aB_BFu0i_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu31i(Test_aB_BFu0i_BFu31i, "aB_BFu0i_BFu31i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu31ll()
{
  {
    init_simple_test("aB_BFu0i_BFu31ll");
    static aB_BFu0i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu0i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, 1, "aB_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, hide_ull(1LL<<30), "aB_BFu0i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu31ll(Test_aB_BFu0i_BFu31ll, "aB_BFu0i_BFu31ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu32i()
{
  {
    init_simple_test("aB_BFu0i_BFu32i");
    static aB_BFu0i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu0i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, 1, "aB_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, hide_ull(1LL<<31), "aB_BFu0i_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu32i(Test_aB_BFu0i_BFu32i, "aB_BFu0i_BFu32i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu32ll()
{
  {
    init_simple_test("aB_BFu0i_BFu32ll");
    static aB_BFu0i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu0i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, 1, "aB_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, hide_ull(1LL<<31), "aB_BFu0i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu32ll(Test_aB_BFu0i_BFu32ll, "aB_BFu0i_BFu32ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu33()
{
  {
    init_simple_test("aB_BFu0i_BFu33");
    static aB_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(9,9), "sizeof(aB_BFu0i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 33, 1, "aB_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 33, hide_ull(1LL<<32), "aB_BFu0i_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu33(Test_aB_BFu0i_BFu33, "aB_BFu0i_BFu33", ABISELECT(9,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu7c()
{
  {
    init_simple_test("aB_BFu0i_BFu7c");
    static aB_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "aB_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "aB_BFu0i_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu7c(Test_aB_BFu0i_BFu7c, "aB_BFu0i_BFu7c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu7i()
{
  {
    init_simple_test("aB_BFu0i_BFu7i");
    static aB_BFu0i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "aB_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "aB_BFu0i_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu7i(Test_aB_BFu0i_BFu7i, "aB_BFu0i_BFu7i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu7ll()
{
  {
    init_simple_test("aB_BFu0i_BFu7ll");
    static aB_BFu0i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "aB_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "aB_BFu0i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu7ll(Test_aB_BFu0i_BFu7ll, "aB_BFu0i_BFu7ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu7s()
{
  {
    init_simple_test("aB_BFu0i_BFu7s");
    static aB_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "aB_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "aB_BFu0i_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu7s(Test_aB_BFu0i_BFu7s, "aB_BFu0i_BFu7s", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu8c()
{
  {
    init_simple_test("aB_BFu0i_BFu8c");
    static aB_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "aB_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "aB_BFu0i_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu8c(Test_aB_BFu0i_BFu8c, "aB_BFu0i_BFu8c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu8i()
{
  {
    init_simple_test("aB_BFu0i_BFu8i");
    static aB_BFu0i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "aB_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "aB_BFu0i_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu8i(Test_aB_BFu0i_BFu8i, "aB_BFu0i_BFu8i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu8ll()
{
  {
    init_simple_test("aB_BFu0i_BFu8ll");
    static aB_BFu0i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "aB_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "aB_BFu0i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu8ll(Test_aB_BFu0i_BFu8ll, "aB_BFu0i_BFu8ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu8s()
{
  {
    init_simple_test("aB_BFu0i_BFu8s");
    static aB_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "aB_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "aB_BFu0i_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu8s(Test_aB_BFu0i_BFu8s, "aB_BFu0i_BFu8s", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu9i()
{
  {
    init_simple_test("aB_BFu0i_BFu9i");
    static aB_BFu0i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, 1, "aB_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, hide_ull(1LL<<8), "aB_BFu0i_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu9i(Test_aB_BFu0i_BFu9i, "aB_BFu0i_BFu9i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu9ll()
{
  {
    init_simple_test("aB_BFu0i_BFu9ll");
    static aB_BFu0i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, 1, "aB_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, hide_ull(1LL<<8), "aB_BFu0i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu9ll(Test_aB_BFu0i_BFu9ll, "aB_BFu0i_BFu9ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_BFu9s()
{
  {
    init_simple_test("aB_BFu0i_BFu9s");
    static aB_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, 1, "aB_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, hide_ull(1LL<<8), "aB_BFu0i_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_BFu9s(Test_aB_BFu0i_BFu9s, "aB_BFu0i_BFu9s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_C()
{
  {
    init_simple_test("aB_BFu0i_C");
    static aB_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_C)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_C.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aB_BFu0i_C.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_C(Test_aB_BFu0i_C, "aB_BFu0i_C", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_D()
{
  {
    init_simple_test("aB_BFu0i_D");
    static aB_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aB_BFu0i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_D)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_D.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aB_BFu0i_D.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_D(Test_aB_BFu0i_D, "aB_BFu0i_D", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_F()
{
  {
    init_simple_test("aB_BFu0i_F");
    static aB_BFu0i_F lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu0i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_F)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_F.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aB_BFu0i_F.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_F(Test_aB_BFu0i_F, "aB_BFu0i_F", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_I()
{
  {
    init_simple_test("aB_BFu0i_I");
    static aB_BFu0i_I lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu0i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_I)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_I.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aB_BFu0i_I.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_I(Test_aB_BFu0i_I, "aB_BFu0i_I", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_Ip()
{
  {
    init_simple_test("aB_BFu0i_Ip");
    static aB_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_BFu0i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aB_BFu0i_Ip.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_Ip(Test_aB_BFu0i_Ip, "aB_BFu0i_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_L()
{
  {
    init_simple_test("aB_BFu0i_L");
    static aB_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aB_BFu0i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_L)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_L.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aB_BFu0i_L.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_L(Test_aB_BFu0i_L, "aB_BFu0i_L", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_S()
{
  {
    init_simple_test("aB_BFu0i_S");
    static aB_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_S)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_S.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aB_BFu0i_S.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_S(Test_aB_BFu0i_S, "aB_BFu0i_S", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_Uc()
{
  {
    init_simple_test("aB_BFu0i_Uc");
    static aB_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aB_BFu0i_Uc.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_Uc(Test_aB_BFu0i_Uc, "aB_BFu0i_Uc", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_Ui()
{
  {
    init_simple_test("aB_BFu0i_Ui");
    static aB_BFu0i_Ui lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu0i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aB_BFu0i_Ui.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_Ui(Test_aB_BFu0i_Ui, "aB_BFu0i_Ui", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_Ul()
{
  {
    init_simple_test("aB_BFu0i_Ul");
    static aB_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aB_BFu0i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aB_BFu0i_Ul.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_Ul(Test_aB_BFu0i_Ul, "aB_BFu0i_Ul", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_Us()
{
  {
    init_simple_test("aB_BFu0i_Us");
    static aB_BFu0i_Us lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_Us.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aB_BFu0i_Us.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_Us(Test_aB_BFu0i_Us, "aB_BFu0i_Us", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0i_Vp()
{
  {
    init_simple_test("aB_BFu0i_Vp");
    static aB_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_BFu0i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0i_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu0i_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aB_BFu0i_Vp.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0i_Vp(Test_aB_BFu0i_Vp, "aB_BFu0i_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll()
{
  {
    init_simple_test("aB_BFu0ll");
    static aB_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll(Test_aB_BFu0ll, "aB_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_B()
{
  {
    init_simple_test("aB_BFu0ll_B");
    static aB_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aB_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_B(Test_aB_BFu0ll_B, "aB_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu0c()
{
  {
    init_simple_test("aB_BFu0ll_BFu0c");
    static aB_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu0ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu0c(Test_aB_BFu0ll_BFu0c, "aB_BFu0ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu0i()
{
  {
    init_simple_test("aB_BFu0ll_BFu0i");
    static aB_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu0ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu0i(Test_aB_BFu0ll_BFu0i, "aB_BFu0ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu0ll()
{
  {
    init_simple_test("aB_BFu0ll_BFu0ll");
    static aB_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu0ll(Test_aB_BFu0ll_BFu0ll, "aB_BFu0ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu0s()
{
  {
    init_simple_test("aB_BFu0ll_BFu0s");
    static aB_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu0ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu0s(Test_aB_BFu0ll_BFu0s, "aB_BFu0ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu15i()
{
  {
    init_simple_test("aB_BFu0ll_BFu15i");
    static aB_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu0ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aB_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aB_BFu0ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu15i(Test_aB_BFu0ll_BFu15i, "aB_BFu0ll_BFu15i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu15ll()
{
  {
    init_simple_test("aB_BFu0ll_BFu15ll");
    static aB_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aB_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aB_BFu0ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu15ll(Test_aB_BFu0ll_BFu15ll, "aB_BFu0ll_BFu15ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu15s()
{
  {
    init_simple_test("aB_BFu0ll_BFu15s");
    static aB_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu0ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aB_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aB_BFu0ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu15s(Test_aB_BFu0ll_BFu15s, "aB_BFu0ll_BFu15s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu16i()
{
  {
    init_simple_test("aB_BFu0ll_BFu16i");
    static aB_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu0ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aB_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aB_BFu0ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu16i(Test_aB_BFu0ll_BFu16i, "aB_BFu0ll_BFu16i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu16ll()
{
  {
    init_simple_test("aB_BFu0ll_BFu16ll");
    static aB_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aB_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aB_BFu0ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu16ll(Test_aB_BFu0ll_BFu16ll, "aB_BFu0ll_BFu16ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu16s()
{
  {
    init_simple_test("aB_BFu0ll_BFu16s");
    static aB_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu0ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aB_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aB_BFu0ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu16s(Test_aB_BFu0ll_BFu16s, "aB_BFu0ll_BFu16s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu17i()
{
  {
    init_simple_test("aB_BFu0ll_BFu17i");
    static aB_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu0ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aB_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aB_BFu0ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu17i(Test_aB_BFu0ll_BFu17i, "aB_BFu0ll_BFu17i", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu17ll()
{
  {
    init_simple_test("aB_BFu0ll_BFu17ll");
    static aB_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aB_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aB_BFu0ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu17ll(Test_aB_BFu0ll_BFu17ll, "aB_BFu0ll_BFu17ll", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu1c()
{
  {
    init_simple_test("aB_BFu0ll_BFu1c");
    static aB_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aB_BFu0ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu1c(Test_aB_BFu0ll_BFu1c, "aB_BFu0ll_BFu1c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu1i()
{
  {
    init_simple_test("aB_BFu0ll_BFu1i");
    static aB_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aB_BFu0ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu1i(Test_aB_BFu0ll_BFu1i, "aB_BFu0ll_BFu1i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu1ll()
{
  {
    init_simple_test("aB_BFu0ll_BFu1ll");
    static aB_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aB_BFu0ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu1ll(Test_aB_BFu0ll_BFu1ll, "aB_BFu0ll_BFu1ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu1s()
{
  {
    init_simple_test("aB_BFu0ll_BFu1s");
    static aB_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aB_BFu0ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu1s(Test_aB_BFu0ll_BFu1s, "aB_BFu0ll_BFu1s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu31i()
{
  {
    init_simple_test("aB_BFu0ll_BFu31i");
    static aB_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_BFu0ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aB_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aB_BFu0ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu31i(Test_aB_BFu0ll_BFu31i, "aB_BFu0ll_BFu31i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu31ll()
{
  {
    init_simple_test("aB_BFu0ll_BFu31ll");
    static aB_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aB_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aB_BFu0ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu31ll(Test_aB_BFu0ll_BFu31ll, "aB_BFu0ll_BFu31ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu32i()
{
  {
    init_simple_test("aB_BFu0ll_BFu32i");
    static aB_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_BFu0ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aB_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aB_BFu0ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu32i(Test_aB_BFu0ll_BFu32i, "aB_BFu0ll_BFu32i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu32ll()
{
  {
    init_simple_test("aB_BFu0ll_BFu32ll");
    static aB_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aB_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aB_BFu0ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu32ll(Test_aB_BFu0ll_BFu32ll, "aB_BFu0ll_BFu32ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu33()
{
  {
    init_simple_test("aB_BFu0ll_BFu33");
    static aB_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aB_BFu0ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aB_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aB_BFu0ll_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu33(Test_aB_BFu0ll_BFu33, "aB_BFu0ll_BFu33", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu7c()
{
  {
    init_simple_test("aB_BFu0ll_BFu7c");
    static aB_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aB_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aB_BFu0ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu7c(Test_aB_BFu0ll_BFu7c, "aB_BFu0ll_BFu7c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu7i()
{
  {
    init_simple_test("aB_BFu0ll_BFu7i");
    static aB_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aB_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aB_BFu0ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu7i(Test_aB_BFu0ll_BFu7i, "aB_BFu0ll_BFu7i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu7ll()
{
  {
    init_simple_test("aB_BFu0ll_BFu7ll");
    static aB_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aB_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aB_BFu0ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu7ll(Test_aB_BFu0ll_BFu7ll, "aB_BFu0ll_BFu7ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu7s()
{
  {
    init_simple_test("aB_BFu0ll_BFu7s");
    static aB_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aB_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aB_BFu0ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu7s(Test_aB_BFu0ll_BFu7s, "aB_BFu0ll_BFu7s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu8c()
{
  {
    init_simple_test("aB_BFu0ll_BFu8c");
    static aB_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aB_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aB_BFu0ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu8c(Test_aB_BFu0ll_BFu8c, "aB_BFu0ll_BFu8c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu8i()
{
  {
    init_simple_test("aB_BFu0ll_BFu8i");
    static aB_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aB_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aB_BFu0ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu8i(Test_aB_BFu0ll_BFu8i, "aB_BFu0ll_BFu8i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu8ll()
{
  {
    init_simple_test("aB_BFu0ll_BFu8ll");
    static aB_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aB_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aB_BFu0ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu8ll(Test_aB_BFu0ll_BFu8ll, "aB_BFu0ll_BFu8ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu8s()
{
  {
    init_simple_test("aB_BFu0ll_BFu8s");
    static aB_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aB_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aB_BFu0ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu8s(Test_aB_BFu0ll_BFu8s, "aB_BFu0ll_BFu8s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu9i()
{
  {
    init_simple_test("aB_BFu0ll_BFu9i");
    static aB_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu0ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aB_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aB_BFu0ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu9i(Test_aB_BFu0ll_BFu9i, "aB_BFu0ll_BFu9i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu9ll()
{
  {
    init_simple_test("aB_BFu0ll_BFu9ll");
    static aB_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aB_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aB_BFu0ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu9ll(Test_aB_BFu0ll_BFu9ll, "aB_BFu0ll_BFu9ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_BFu9s()
{
  {
    init_simple_test("aB_BFu0ll_BFu9s");
    static aB_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu0ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aB_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aB_BFu0ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_BFu9s(Test_aB_BFu0ll_BFu9s, "aB_BFu0ll_BFu9s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_C()
{
  {
    init_simple_test("aB_BFu0ll_C");
    static aB_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_C)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aB_BFu0ll_C.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_C(Test_aB_BFu0ll_C, "aB_BFu0ll_C", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_D()
{
  {
    init_simple_test("aB_BFu0ll_D");
    static aB_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aB_BFu0ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_D)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aB_BFu0ll_D.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_D(Test_aB_BFu0ll_D, "aB_BFu0ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_F()
{
  {
    init_simple_test("aB_BFu0ll_F");
    static aB_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_BFu0ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_F)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aB_BFu0ll_F.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_F(Test_aB_BFu0ll_F, "aB_BFu0ll_F", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_I()
{
  {
    init_simple_test("aB_BFu0ll_I");
    static aB_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_BFu0ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_I)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aB_BFu0ll_I.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_I(Test_aB_BFu0ll_I, "aB_BFu0ll_I", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_Ip()
{
  {
    init_simple_test("aB_BFu0ll_Ip");
    static aB_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aB_BFu0ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aB_BFu0ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_Ip(Test_aB_BFu0ll_Ip, "aB_BFu0ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_L()
{
  {
    init_simple_test("aB_BFu0ll_L");
    static aB_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aB_BFu0ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_L)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aB_BFu0ll_L.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_L(Test_aB_BFu0ll_L, "aB_BFu0ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_S()
{
  {
    init_simple_test("aB_BFu0ll_S");
    static aB_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu0ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_S)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aB_BFu0ll_S.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_S(Test_aB_BFu0ll_S, "aB_BFu0ll_S", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_Uc()
{
  {
    init_simple_test("aB_BFu0ll_Uc");
    static aB_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_BFu0ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aB_BFu0ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_Uc(Test_aB_BFu0ll_Uc, "aB_BFu0ll_Uc", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_Ui()
{
  {
    init_simple_test("aB_BFu0ll_Ui");
    static aB_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_BFu0ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aB_BFu0ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_Ui(Test_aB_BFu0ll_Ui, "aB_BFu0ll_Ui", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_Ul()
{
  {
    init_simple_test("aB_BFu0ll_Ul");
    static aB_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aB_BFu0ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aB_BFu0ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_Ul(Test_aB_BFu0ll_Ul, "aB_BFu0ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_Us()
{
  {
    init_simple_test("aB_BFu0ll_Us");
    static aB_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu0ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aB_BFu0ll_Us.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_Us(Test_aB_BFu0ll_Us, "aB_BFu0ll_Us", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0ll_Vp()
{
  {
    init_simple_test("aB_BFu0ll_Vp");
    static aB_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aB_BFu0ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0ll_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu0ll_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aB_BFu0ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0ll_Vp(Test_aB_BFu0ll_Vp, "aB_BFu0ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s()
{
  {
    init_simple_test("aB_BFu0s");
    static aB_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aB_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0s(Test_aB_BFu0s, "aB_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_B()
{
  {
    init_simple_test("aB_BFu0s_B");
    static aB_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_B.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aB_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_B(Test_aB_BFu0s_B, "aB_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu0c()
{
  {
    init_simple_test("aB_BFu0s_BFu0c");
    static aB_BFu0s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aB_BFu0s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu0c(Test_aB_BFu0s_BFu0c, "aB_BFu0s_BFu0c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu0i()
{
  {
    init_simple_test("aB_BFu0s_BFu0i");
    static aB_BFu0s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu0i(Test_aB_BFu0s_BFu0i, "aB_BFu0s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu0ll()
{
  {
    init_simple_test("aB_BFu0s_BFu0ll");
    static aB_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu0s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu0ll(Test_aB_BFu0s_BFu0ll, "aB_BFu0s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu0s()
{
  {
    init_simple_test("aB_BFu0s_BFu0s");
    static aB_BFu0s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aB_BFu0s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu0s(Test_aB_BFu0s_BFu0s, "aB_BFu0s_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu15i()
{
  {
    init_simple_test("aB_BFu0s_BFu15i");
    static aB_BFu0s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, 1, "aB_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, hide_ull(1LL<<14), "aB_BFu0s_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu15i(Test_aB_BFu0s_BFu15i, "aB_BFu0s_BFu15i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu15ll()
{
  {
    init_simple_test("aB_BFu0s_BFu15ll");
    static aB_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, 1, "aB_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, hide_ull(1LL<<14), "aB_BFu0s_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu15ll(Test_aB_BFu0s_BFu15ll, "aB_BFu0s_BFu15ll", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu15s()
{
  {
    init_simple_test("aB_BFu0s_BFu15s");
    static aB_BFu0s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, 1, "aB_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, hide_ull(1LL<<14), "aB_BFu0s_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu15s(Test_aB_BFu0s_BFu15s, "aB_BFu0s_BFu15s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu16i()
{
  {
    init_simple_test("aB_BFu0s_BFu16i");
    static aB_BFu0s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, 1, "aB_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, hide_ull(1LL<<15), "aB_BFu0s_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu16i(Test_aB_BFu0s_BFu16i, "aB_BFu0s_BFu16i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu16ll()
{
  {
    init_simple_test("aB_BFu0s_BFu16ll");
    static aB_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, 1, "aB_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, hide_ull(1LL<<15), "aB_BFu0s_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu16ll(Test_aB_BFu0s_BFu16ll, "aB_BFu0s_BFu16ll", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu16s()
{
  {
    init_simple_test("aB_BFu0s_BFu16s");
    static aB_BFu0s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, 1, "aB_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, hide_ull(1LL<<15), "aB_BFu0s_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu16s(Test_aB_BFu0s_BFu16s, "aB_BFu0s_BFu16s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu17i()
{
  {
    init_simple_test("aB_BFu0s_BFu17i");
    static aB_BFu0s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 17, 1, "aB_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 17, hide_ull(1LL<<16), "aB_BFu0s_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu17i(Test_aB_BFu0s_BFu17i, "aB_BFu0s_BFu17i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu17ll()
{
  {
    init_simple_test("aB_BFu0s_BFu17ll");
    static aB_BFu0s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aB_BFu0s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 17, 1, "aB_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 17, hide_ull(1LL<<16), "aB_BFu0s_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu17ll(Test_aB_BFu0s_BFu17ll, "aB_BFu0s_BFu17ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu1c()
{
  {
    init_simple_test("aB_BFu0s_BFu1c");
    static aB_BFu0s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 1, 1, "aB_BFu0s_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu1c(Test_aB_BFu0s_BFu1c, "aB_BFu0s_BFu1c", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu1i()
{
  {
    init_simple_test("aB_BFu0s_BFu1i");
    static aB_BFu0s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 1, 1, "aB_BFu0s_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu1i(Test_aB_BFu0s_BFu1i, "aB_BFu0s_BFu1i", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu1ll()
{
  {
    init_simple_test("aB_BFu0s_BFu1ll");
    static aB_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 1, 1, "aB_BFu0s_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu1ll(Test_aB_BFu0s_BFu1ll, "aB_BFu0s_BFu1ll", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu1s()
{
  {
    init_simple_test("aB_BFu0s_BFu1s");
    static aB_BFu0s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 1, 1, "aB_BFu0s_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu1s(Test_aB_BFu0s_BFu1s, "aB_BFu0s_BFu1s", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu31i()
{
  {
    init_simple_test("aB_BFu0s_BFu31i");
    static aB_BFu0s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 31, 1, "aB_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 31, hide_ull(1LL<<30), "aB_BFu0s_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu31i(Test_aB_BFu0s_BFu31i, "aB_BFu0s_BFu31i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu31ll()
{
  {
    init_simple_test("aB_BFu0s_BFu31ll");
    static aB_BFu0s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 31, 1, "aB_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 31, hide_ull(1LL<<30), "aB_BFu0s_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu31ll(Test_aB_BFu0s_BFu31ll, "aB_BFu0s_BFu31ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu32i()
{
  {
    init_simple_test("aB_BFu0s_BFu32i");
    static aB_BFu0s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 32, 1, "aB_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 32, hide_ull(1LL<<31), "aB_BFu0s_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu32i(Test_aB_BFu0s_BFu32i, "aB_BFu0s_BFu32i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu32ll()
{
  {
    init_simple_test("aB_BFu0s_BFu32ll");
    static aB_BFu0s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 32, 1, "aB_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 32, hide_ull(1LL<<31), "aB_BFu0s_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu32ll(Test_aB_BFu0s_BFu32ll, "aB_BFu0s_BFu32ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu33()
{
  {
    init_simple_test("aB_BFu0s_BFu33");
    static aB_BFu0s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aB_BFu0s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 33, 1, "aB_BFu0s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 33, hide_ull(1LL<<32), "aB_BFu0s_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu33(Test_aB_BFu0s_BFu33, "aB_BFu0s_BFu33", ABISELECT(7,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu7c()
{
  {
    init_simple_test("aB_BFu0s_BFu7c");
    static aB_BFu0s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, 1, "aB_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, hide_ull(1LL<<6), "aB_BFu0s_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu7c(Test_aB_BFu0s_BFu7c, "aB_BFu0s_BFu7c", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu7i()
{
  {
    init_simple_test("aB_BFu0s_BFu7i");
    static aB_BFu0s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, 1, "aB_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, hide_ull(1LL<<6), "aB_BFu0s_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu7i(Test_aB_BFu0s_BFu7i, "aB_BFu0s_BFu7i", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu7ll()
{
  {
    init_simple_test("aB_BFu0s_BFu7ll");
    static aB_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, 1, "aB_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, hide_ull(1LL<<6), "aB_BFu0s_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu7ll(Test_aB_BFu0s_BFu7ll, "aB_BFu0s_BFu7ll", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu7s()
{
  {
    init_simple_test("aB_BFu0s_BFu7s");
    static aB_BFu0s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, 1, "aB_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, hide_ull(1LL<<6), "aB_BFu0s_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu7s(Test_aB_BFu0s_BFu7s, "aB_BFu0s_BFu7s", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu8c()
{
  {
    init_simple_test("aB_BFu0s_BFu8c");
    static aB_BFu0s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, 1, "aB_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, hide_ull(1LL<<7), "aB_BFu0s_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu8c(Test_aB_BFu0s_BFu8c, "aB_BFu0s_BFu8c", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu8i()
{
  {
    init_simple_test("aB_BFu0s_BFu8i");
    static aB_BFu0s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, 1, "aB_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, hide_ull(1LL<<7), "aB_BFu0s_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu8i(Test_aB_BFu0s_BFu8i, "aB_BFu0s_BFu8i", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu8ll()
{
  {
    init_simple_test("aB_BFu0s_BFu8ll");
    static aB_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, 1, "aB_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, hide_ull(1LL<<7), "aB_BFu0s_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu8ll(Test_aB_BFu0s_BFu8ll, "aB_BFu0s_BFu8ll", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu8s()
{
  {
    init_simple_test("aB_BFu0s_BFu8s");
    static aB_BFu0s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, 1, "aB_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, hide_ull(1LL<<7), "aB_BFu0s_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu8s(Test_aB_BFu0s_BFu8s, "aB_BFu0s_BFu8s", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu9i()
{
  {
    init_simple_test("aB_BFu0s_BFu9i");
    static aB_BFu0s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, 1, "aB_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, hide_ull(1LL<<8), "aB_BFu0s_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu9i(Test_aB_BFu0s_BFu9i, "aB_BFu0s_BFu9i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu9ll()
{
  {
    init_simple_test("aB_BFu0s_BFu9ll");
    static aB_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, 1, "aB_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, hide_ull(1LL<<8), "aB_BFu0s_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu9ll(Test_aB_BFu0s_BFu9ll, "aB_BFu0s_BFu9ll", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_BFu9s()
{
  {
    init_simple_test("aB_BFu0s_BFu9s");
    static aB_BFu0s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, 1, "aB_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, hide_ull(1LL<<8), "aB_BFu0s_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_BFu9s(Test_aB_BFu0s_BFu9s, "aB_BFu0s_BFu9s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_C()
{
  {
    init_simple_test("aB_BFu0s_C");
    static aB_BFu0s_C lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_C)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_C.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aB_BFu0s_C.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_C(Test_aB_BFu0s_C, "aB_BFu0s_C", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_D()
{
  {
    init_simple_test("aB_BFu0s_D");
    static aB_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aB_BFu0s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_D)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_D.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aB_BFu0s_D.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_D(Test_aB_BFu0s_D, "aB_BFu0s_D", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_F()
{
  {
    init_simple_test("aB_BFu0s_F");
    static aB_BFu0s_F lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_F)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_F.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aB_BFu0s_F.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_F(Test_aB_BFu0s_F, "aB_BFu0s_F", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_I()
{
  {
    init_simple_test("aB_BFu0s_I");
    static aB_BFu0s_I lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_I)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_I.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aB_BFu0s_I.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_I(Test_aB_BFu0s_I, "aB_BFu0s_I", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_Ip()
{
  {
    init_simple_test("aB_BFu0s_Ip");
    static aB_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu0s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aB_BFu0s_Ip.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_Ip(Test_aB_BFu0s_Ip, "aB_BFu0s_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_L()
{
  {
    init_simple_test("aB_BFu0s_L");
    static aB_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aB_BFu0s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_L)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_L.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aB_BFu0s_L.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_L(Test_aB_BFu0s_L, "aB_BFu0s_L", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_S()
{
  {
    init_simple_test("aB_BFu0s_S");
    static aB_BFu0s_S lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_S)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_S.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aB_BFu0s_S.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_S(Test_aB_BFu0s_S, "aB_BFu0s_S", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_Uc()
{
  {
    init_simple_test("aB_BFu0s_Uc");
    static aB_BFu0s_Uc lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aB_BFu0s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aB_BFu0s_Uc.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_Uc(Test_aB_BFu0s_Uc, "aB_BFu0s_Uc", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_Ui()
{
  {
    init_simple_test("aB_BFu0s_Ui");
    static aB_BFu0s_Ui lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu0s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aB_BFu0s_Ui.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_Ui(Test_aB_BFu0s_Ui, "aB_BFu0s_Ui", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_Ul()
{
  {
    init_simple_test("aB_BFu0s_Ul");
    static aB_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aB_BFu0s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aB_BFu0s_Ul.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_Ul(Test_aB_BFu0s_Ul, "aB_BFu0s_Ul", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_Us()
{
  {
    init_simple_test("aB_BFu0s_Us");
    static aB_BFu0s_Us lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu0s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_Us.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aB_BFu0s_Us.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_Us(Test_aB_BFu0s_Us, "aB_BFu0s_Us", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu0s_Vp()
{
  {
    init_simple_test("aB_BFu0s_Vp");
    static aB_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu0s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu0s_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu0s_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aB_BFu0s_Vp.v2");
  }
}
static Arrange_To_Call_Me vaB_BFu0s_Vp(Test_aB_BFu0s_Vp, "aB_BFu0s_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu0c()
{
  {
    init_simple_test("aB_BFu15i_BFu0c");
    static aB_BFu15i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu0c(Test_aB_BFu15i_BFu0c, "aB_BFu15i_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu0i()
{
  {
    init_simple_test("aB_BFu15i_BFu0i");
    static aB_BFu15i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu15i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu0i(Test_aB_BFu15i_BFu0i, "aB_BFu15i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu0ll()
{
  {
    init_simple_test("aB_BFu15i_BFu0ll");
    static aB_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu15i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu0ll(Test_aB_BFu15i_BFu0ll, "aB_BFu15i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu0s()
{
  {
    init_simple_test("aB_BFu15i_BFu0s");
    static aB_BFu15i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu15i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu0s(Test_aB_BFu15i_BFu0s, "aB_BFu15i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu0c()
{
  {
    init_simple_test("aB_BFu15ll_BFu0c");
    static aB_BFu15ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu0c(Test_aB_BFu15ll_BFu0c, "aB_BFu15ll_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu0i()
{
  {
    init_simple_test("aB_BFu15ll_BFu0i");
    static aB_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu15ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu0i(Test_aB_BFu15ll_BFu0i, "aB_BFu15ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu0ll()
{
  {
    init_simple_test("aB_BFu15ll_BFu0ll");
    static aB_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu0ll(Test_aB_BFu15ll_BFu0ll, "aB_BFu15ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu0s()
{
  {
    init_simple_test("aB_BFu15ll_BFu0s");
    static aB_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu15ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu0s(Test_aB_BFu15ll_BFu0s, "aB_BFu15ll_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu0c()
{
  {
    init_simple_test("aB_BFu15s_BFu0c");
    static aB_BFu15s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu0c(Test_aB_BFu15s_BFu0c, "aB_BFu15s_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu0i()
{
  {
    init_simple_test("aB_BFu15s_BFu0i");
    static aB_BFu15s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu15s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu0i(Test_aB_BFu15s_BFu0i, "aB_BFu15s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu0ll()
{
  {
    init_simple_test("aB_BFu15s_BFu0ll");
    static aB_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu15s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu0ll(Test_aB_BFu15s_BFu0ll, "aB_BFu15s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu0s()
{
  {
    init_simple_test("aB_BFu15s_BFu0s");
    static aB_BFu15s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu15s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu0s(Test_aB_BFu15s_BFu0s, "aB_BFu15s_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu0c()
{
  {
    init_simple_test("aB_BFu16i_BFu0c");
    static aB_BFu16i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu16i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu0c(Test_aB_BFu16i_BFu0c, "aB_BFu16i_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu0i()
{
  {
    init_simple_test("aB_BFu16i_BFu0i");
    static aB_BFu16i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu16i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu0i(Test_aB_BFu16i_BFu0i, "aB_BFu16i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu0ll()
{
  {
    init_simple_test("aB_BFu16i_BFu0ll");
    static aB_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu16i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu0ll(Test_aB_BFu16i_BFu0ll, "aB_BFu16i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu0s()
{
  {
    init_simple_test("aB_BFu16i_BFu0s");
    static aB_BFu16i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu16i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu0s(Test_aB_BFu16i_BFu0s, "aB_BFu16i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu0c()
{
  {
    init_simple_test("aB_BFu16ll_BFu0c");
    static aB_BFu16ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu16ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu0c(Test_aB_BFu16ll_BFu0c, "aB_BFu16ll_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu0i()
{
  {
    init_simple_test("aB_BFu16ll_BFu0i");
    static aB_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu16ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu0i(Test_aB_BFu16ll_BFu0i, "aB_BFu16ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu0ll()
{
  {
    init_simple_test("aB_BFu16ll_BFu0ll");
    static aB_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu0ll(Test_aB_BFu16ll_BFu0ll, "aB_BFu16ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu0s()
{
  {
    init_simple_test("aB_BFu16ll_BFu0s");
    static aB_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu16ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu0s(Test_aB_BFu16ll_BFu0s, "aB_BFu16ll_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu0c()
{
  {
    init_simple_test("aB_BFu16s_BFu0c");
    static aB_BFu16s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu16s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu0c(Test_aB_BFu16s_BFu0c, "aB_BFu16s_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu0i()
{
  {
    init_simple_test("aB_BFu16s_BFu0i");
    static aB_BFu16s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu16s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu0i(Test_aB_BFu16s_BFu0i, "aB_BFu16s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu0ll()
{
  {
    init_simple_test("aB_BFu16s_BFu0ll");
    static aB_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu16s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu0ll(Test_aB_BFu16s_BFu0ll, "aB_BFu16s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu0s()
{
  {
    init_simple_test("aB_BFu16s_BFu0s");
    static aB_BFu16s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu16s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu0s(Test_aB_BFu16s_BFu0s, "aB_BFu16s_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu0c()
{
  {
    init_simple_test("aB_BFu17i_BFu0c");
    static aB_BFu17i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu0c(Test_aB_BFu17i_BFu0c, "aB_BFu17i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu0i()
{
  {
    init_simple_test("aB_BFu17i_BFu0i");
    static aB_BFu17i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu0i(Test_aB_BFu17i_BFu0i, "aB_BFu17i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu0ll()
{
  {
    init_simple_test("aB_BFu17i_BFu0ll");
    static aB_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu17i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu0ll(Test_aB_BFu17i_BFu0ll, "aB_BFu17i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu0s()
{
  {
    init_simple_test("aB_BFu17i_BFu0s");
    static aB_BFu17i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu0s(Test_aB_BFu17i_BFu0s, "aB_BFu17i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu0c()
{
  {
    init_simple_test("aB_BFu17ll_BFu0c");
    static aB_BFu17ll_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu0c(Test_aB_BFu17ll_BFu0c, "aB_BFu17ll_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu0i()
{
  {
    init_simple_test("aB_BFu17ll_BFu0i");
    static aB_BFu17ll_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu0i(Test_aB_BFu17ll_BFu0i, "aB_BFu17ll_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu0ll()
{
  {
    init_simple_test("aB_BFu17ll_BFu0ll");
    static aB_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu0ll(Test_aB_BFu17ll_BFu0ll, "aB_BFu17ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu0s()
{
  {
    init_simple_test("aB_BFu17ll_BFu0s");
    static aB_BFu17ll_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu0s(Test_aB_BFu17ll_BFu0s, "aB_BFu17ll_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu0c()
{
  {
    init_simple_test("aB_BFu1c_BFu0c");
    static aB_BFu1c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu0c(Test_aB_BFu1c_BFu0c, "aB_BFu1c_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu0i()
{
  {
    init_simple_test("aB_BFu1c_BFu0i");
    static aB_BFu1c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu1c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu0i(Test_aB_BFu1c_BFu0i, "aB_BFu1c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu0ll()
{
  {
    init_simple_test("aB_BFu1c_BFu0ll");
    static aB_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu1c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu0ll(Test_aB_BFu1c_BFu0ll, "aB_BFu1c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu0s()
{
  {
    init_simple_test("aB_BFu1c_BFu0s");
    static aB_BFu1c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu0s(Test_aB_BFu1c_BFu0s, "aB_BFu1c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu0c()
{
  {
    init_simple_test("aB_BFu1i_BFu0c");
    static aB_BFu1i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu0c(Test_aB_BFu1i_BFu0c, "aB_BFu1i_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu0i()
{
  {
    init_simple_test("aB_BFu1i_BFu0i");
    static aB_BFu1i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu1i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu0i(Test_aB_BFu1i_BFu0i, "aB_BFu1i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu0ll()
{
  {
    init_simple_test("aB_BFu1i_BFu0ll");
    static aB_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu1i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu0ll(Test_aB_BFu1i_BFu0ll, "aB_BFu1i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu0s()
{
  {
    init_simple_test("aB_BFu1i_BFu0s");
    static aB_BFu1i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu0s(Test_aB_BFu1i_BFu0s, "aB_BFu1i_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu0c()
{
  {
    init_simple_test("aB_BFu1ll_BFu0c");
    static aB_BFu1ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu0c(Test_aB_BFu1ll_BFu0c, "aB_BFu1ll_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu0i()
{
  {
    init_simple_test("aB_BFu1ll_BFu0i");
    static aB_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu1ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu0i(Test_aB_BFu1ll_BFu0i, "aB_BFu1ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu0ll()
{
  {
    init_simple_test("aB_BFu1ll_BFu0ll");
    static aB_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu0ll(Test_aB_BFu1ll_BFu0ll, "aB_BFu1ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu0s()
{
  {
    init_simple_test("aB_BFu1ll_BFu0s");
    static aB_BFu1ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu0s(Test_aB_BFu1ll_BFu0s, "aB_BFu1ll_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu0c()
{
  {
    init_simple_test("aB_BFu1s_BFu0c");
    static aB_BFu1s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu0c(Test_aB_BFu1s_BFu0c, "aB_BFu1s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu0i()
{
  {
    init_simple_test("aB_BFu1s_BFu0i");
    static aB_BFu1s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu1s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu0i(Test_aB_BFu1s_BFu0i, "aB_BFu1s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu0ll()
{
  {
    init_simple_test("aB_BFu1s_BFu0ll");
    static aB_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu1s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu0ll(Test_aB_BFu1s_BFu0ll, "aB_BFu1s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu0s()
{
  {
    init_simple_test("aB_BFu1s_BFu0s");
    static aB_BFu1s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu0s(Test_aB_BFu1s_BFu0s, "aB_BFu1s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu0c()
{
  {
    init_simple_test("aB_BFu31i_BFu0c");
    static aB_BFu31i_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu31i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu0c(Test_aB_BFu31i_BFu0c, "aB_BFu31i_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu0i()
{
  {
    init_simple_test("aB_BFu31i_BFu0i");
    static aB_BFu31i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu31i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu0i(Test_aB_BFu31i_BFu0i, "aB_BFu31i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu0ll()
{
  {
    init_simple_test("aB_BFu31i_BFu0ll");
    static aB_BFu31i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu31i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu0ll(Test_aB_BFu31i_BFu0ll, "aB_BFu31i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu0s()
{
  {
    init_simple_test("aB_BFu31i_BFu0s");
    static aB_BFu31i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu31i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu0s(Test_aB_BFu31i_BFu0s, "aB_BFu31i_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu0c()
{
  {
    init_simple_test("aB_BFu31ll_BFu0c");
    static aB_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu31ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu0c(Test_aB_BFu31ll_BFu0c, "aB_BFu31ll_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu0i()
{
  {
    init_simple_test("aB_BFu31ll_BFu0i");
    static aB_BFu31ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu31ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu0i(Test_aB_BFu31ll_BFu0i, "aB_BFu31ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu0ll()
{
  {
    init_simple_test("aB_BFu31ll_BFu0ll");
    static aB_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu0ll(Test_aB_BFu31ll_BFu0ll, "aB_BFu31ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu0s()
{
  {
    init_simple_test("aB_BFu31ll_BFu0s");
    static aB_BFu31ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu31ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu0s(Test_aB_BFu31ll_BFu0s, "aB_BFu31ll_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu0c()
{
  {
    init_simple_test("aB_BFu32i_BFu0c");
    static aB_BFu32i_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu32i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu0c(Test_aB_BFu32i_BFu0c, "aB_BFu32i_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu0i()
{
  {
    init_simple_test("aB_BFu32i_BFu0i");
    static aB_BFu32i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu32i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu0i(Test_aB_BFu32i_BFu0i, "aB_BFu32i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu0ll()
{
  {
    init_simple_test("aB_BFu32i_BFu0ll");
    static aB_BFu32i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu32i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu0ll(Test_aB_BFu32i_BFu0ll, "aB_BFu32i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu0s()
{
  {
    init_simple_test("aB_BFu32i_BFu0s");
    static aB_BFu32i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu32i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu0s(Test_aB_BFu32i_BFu0s, "aB_BFu32i_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu0c()
{
  {
    init_simple_test("aB_BFu32ll_BFu0c");
    static aB_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu32ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu0c(Test_aB_BFu32ll_BFu0c, "aB_BFu32ll_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu0i()
{
  {
    init_simple_test("aB_BFu32ll_BFu0i");
    static aB_BFu32ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu32ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu0i(Test_aB_BFu32ll_BFu0i, "aB_BFu32ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu0ll()
{
  {
    init_simple_test("aB_BFu32ll_BFu0ll");
    static aB_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu0ll(Test_aB_BFu32ll_BFu0ll, "aB_BFu32ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu0s()
{
  {
    init_simple_test("aB_BFu32ll_BFu0s");
    static aB_BFu32ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_BFu32ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu0s(Test_aB_BFu32ll_BFu0s, "aB_BFu32ll_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu0c()
{
  {
    init_simple_test("aB_BFu33_BFu0c");
    static aB_BFu33_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu33_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu0c(Test_aB_BFu33_BFu0c, "aB_BFu33_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu0i()
{
  {
    init_simple_test("aB_BFu33_BFu0i");
    static aB_BFu33_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu33_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu0i(Test_aB_BFu33_BFu0i, "aB_BFu33_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu0ll()
{
  {
    init_simple_test("aB_BFu33_BFu0ll");
    static aB_BFu33_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_BFu33_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu0ll(Test_aB_BFu33_BFu0ll, "aB_BFu33_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu0s()
{
  {
    init_simple_test("aB_BFu33_BFu0s");
    static aB_BFu33_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu33_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu0s(Test_aB_BFu33_BFu0s, "aB_BFu33_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu0c()
{
  {
    init_simple_test("aB_BFu7c_BFu0c");
    static aB_BFu7c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu0c(Test_aB_BFu7c_BFu0c, "aB_BFu7c_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu0i()
{
  {
    init_simple_test("aB_BFu7c_BFu0i");
    static aB_BFu7c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu7c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu0i(Test_aB_BFu7c_BFu0i, "aB_BFu7c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu0ll()
{
  {
    init_simple_test("aB_BFu7c_BFu0ll");
    static aB_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu7c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu0ll(Test_aB_BFu7c_BFu0ll, "aB_BFu7c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu0s()
{
  {
    init_simple_test("aB_BFu7c_BFu0s");
    static aB_BFu7c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu0s(Test_aB_BFu7c_BFu0s, "aB_BFu7c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu0c()
{
  {
    init_simple_test("aB_BFu7i_BFu0c");
    static aB_BFu7i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu0c(Test_aB_BFu7i_BFu0c, "aB_BFu7i_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu0i()
{
  {
    init_simple_test("aB_BFu7i_BFu0i");
    static aB_BFu7i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu7i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu0i(Test_aB_BFu7i_BFu0i, "aB_BFu7i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu0ll()
{
  {
    init_simple_test("aB_BFu7i_BFu0ll");
    static aB_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu7i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu0ll(Test_aB_BFu7i_BFu0ll, "aB_BFu7i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu0s()
{
  {
    init_simple_test("aB_BFu7i_BFu0s");
    static aB_BFu7i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu0s(Test_aB_BFu7i_BFu0s, "aB_BFu7i_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu0c()
{
  {
    init_simple_test("aB_BFu7ll_BFu0c");
    static aB_BFu7ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu0c(Test_aB_BFu7ll_BFu0c, "aB_BFu7ll_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu0i()
{
  {
    init_simple_test("aB_BFu7ll_BFu0i");
    static aB_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu7ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu0i(Test_aB_BFu7ll_BFu0i, "aB_BFu7ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu0ll()
{
  {
    init_simple_test("aB_BFu7ll_BFu0ll");
    static aB_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu0ll(Test_aB_BFu7ll_BFu0ll, "aB_BFu7ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu0s()
{
  {
    init_simple_test("aB_BFu7ll_BFu0s");
    static aB_BFu7ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu0s(Test_aB_BFu7ll_BFu0s, "aB_BFu7ll_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu0c()
{
  {
    init_simple_test("aB_BFu7s_BFu0c");
    static aB_BFu7s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu0c(Test_aB_BFu7s_BFu0c, "aB_BFu7s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu0i()
{
  {
    init_simple_test("aB_BFu7s_BFu0i");
    static aB_BFu7s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu7s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu0i(Test_aB_BFu7s_BFu0i, "aB_BFu7s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu0ll()
{
  {
    init_simple_test("aB_BFu7s_BFu0ll");
    static aB_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu7s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu0ll(Test_aB_BFu7s_BFu0ll, "aB_BFu7s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu0s()
{
  {
    init_simple_test("aB_BFu7s_BFu0s");
    static aB_BFu7s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu0s(Test_aB_BFu7s_BFu0s, "aB_BFu7s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu0c()
{
  {
    init_simple_test("aB_BFu8c_BFu0c");
    static aB_BFu8c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu8c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu0c(Test_aB_BFu8c_BFu0c, "aB_BFu8c_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu0i()
{
  {
    init_simple_test("aB_BFu8c_BFu0i");
    static aB_BFu8c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu8c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu0i(Test_aB_BFu8c_BFu0i, "aB_BFu8c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu0ll()
{
  {
    init_simple_test("aB_BFu8c_BFu0ll");
    static aB_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu8c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu0ll(Test_aB_BFu8c_BFu0ll, "aB_BFu8c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu0s()
{
  {
    init_simple_test("aB_BFu8c_BFu0s");
    static aB_BFu8c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu8c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu0s(Test_aB_BFu8c_BFu0s, "aB_BFu8c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8i_BFu0c()
{
  {
    init_simple_test("aB_BFu8i_BFu0c");
    static aB_BFu8i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu8i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8i_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu8i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8i_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu8i_BFu0c(Test_aB_BFu8i_BFu0c, "aB_BFu8i_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8i_BFu0i()
{
  {
    init_simple_test("aB_BFu8i_BFu0i");
    static aB_BFu8i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu8i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8i_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu8i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8i_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu8i_BFu0i(Test_aB_BFu8i_BFu0i, "aB_BFu8i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8i_BFu0ll()
{
  {
    init_simple_test("aB_BFu8i_BFu0ll");
    static aB_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu8i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu8i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu8i_BFu0ll(Test_aB_BFu8i_BFu0ll, "aB_BFu8i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8i_BFu0s()
{
  {
    init_simple_test("aB_BFu8i_BFu0s");
    static aB_BFu8i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu8i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8i_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu8i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8i_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu8i_BFu0s(Test_aB_BFu8i_BFu0s, "aB_BFu8i_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8ll_BFu0c()
{
  {
    init_simple_test("aB_BFu8ll_BFu0c");
    static aB_BFu8ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu8ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu8ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu8ll_BFu0c(Test_aB_BFu8ll_BFu0c, "aB_BFu8ll_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8ll_BFu0i()
{
  {
    init_simple_test("aB_BFu8ll_BFu0i");
    static aB_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu8ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu8ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu8ll_BFu0i(Test_aB_BFu8ll_BFu0i, "aB_BFu8ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8ll_BFu0ll()
{
  {
    init_simple_test("aB_BFu8ll_BFu0ll");
    static aB_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu8ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu8ll_BFu0ll(Test_aB_BFu8ll_BFu0ll, "aB_BFu8ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8ll_BFu0s()
{
  {
    init_simple_test("aB_BFu8ll_BFu0s");
    static aB_BFu8ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu8ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu8ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu8ll_BFu0s(Test_aB_BFu8ll_BFu0s, "aB_BFu8ll_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8s_BFu0c()
{
  {
    init_simple_test("aB_BFu8s_BFu0c");
    static aB_BFu8s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu8s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8s_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu8s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8s_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu8s_BFu0c(Test_aB_BFu8s_BFu0c, "aB_BFu8s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8s_BFu0i()
{
  {
    init_simple_test("aB_BFu8s_BFu0i");
    static aB_BFu8s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu8s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8s_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu8s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8s_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu8s_BFu0i(Test_aB_BFu8s_BFu0i, "aB_BFu8s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8s_BFu0ll()
{
  {
    init_simple_test("aB_BFu8s_BFu0ll");
    static aB_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu8s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu8s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu8s_BFu0ll(Test_aB_BFu8s_BFu0ll, "aB_BFu8s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8s_BFu0s()
{
  {
    init_simple_test("aB_BFu8s_BFu0s");
    static aB_BFu8s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu8s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8s_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu8s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8s_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu8s_BFu0s(Test_aB_BFu8s_BFu0s, "aB_BFu8s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu9i_BFu0c()
{
  {
    init_simple_test("aB_BFu9i_BFu0c");
    static aB_BFu9i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu9i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu9i_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu9i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu9i_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu9i_BFu0c(Test_aB_BFu9i_BFu0c, "aB_BFu9i_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu9i_BFu0i()
{
  {
    init_simple_test("aB_BFu9i_BFu0i");
    static aB_BFu9i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu9i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu9i_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu9i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu9i_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu9i_BFu0i(Test_aB_BFu9i_BFu0i, "aB_BFu9i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu9i_BFu0ll()
{
  {
    init_simple_test("aB_BFu9i_BFu0ll");
    static aB_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu9i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu9i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu9i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu9i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu9i_BFu0ll(Test_aB_BFu9i_BFu0ll, "aB_BFu9i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu9i_BFu0s()
{
  {
    init_simple_test("aB_BFu9i_BFu0s");
    static aB_BFu9i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu9i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu9i_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu9i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu9i_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu9i_BFu0s(Test_aB_BFu9i_BFu0s, "aB_BFu9i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu9ll_BFu0c()
{
  {
    init_simple_test("aB_BFu9ll_BFu0c");
    static aB_BFu9ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu9ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu9ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu9ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu9ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu9ll_BFu0c(Test_aB_BFu9ll_BFu0c, "aB_BFu9ll_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu9ll_BFu0i()
{
  {
    init_simple_test("aB_BFu9ll_BFu0i");
    static aB_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu9ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu9ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu9ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu9ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu9ll_BFu0i(Test_aB_BFu9ll_BFu0i, "aB_BFu9ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu9ll_BFu0ll()
{
  {
    init_simple_test("aB_BFu9ll_BFu0ll");
    static aB_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu9ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu9ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu9ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu9ll_BFu0ll(Test_aB_BFu9ll_BFu0ll, "aB_BFu9ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu9ll_BFu0s()
{
  {
    init_simple_test("aB_BFu9ll_BFu0s");
    static aB_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu9ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu9ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu9ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu9ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu9ll_BFu0s(Test_aB_BFu9ll_BFu0s, "aB_BFu9ll_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu9s_BFu0c()
{
  {
    init_simple_test("aB_BFu9s_BFu0c");
    static aB_BFu9s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu9s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu9s_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_BFu9s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu9s_BFu0c");
  }
}
static Arrange_To_Call_Me vaB_BFu9s_BFu0c(Test_aB_BFu9s_BFu0c, "aB_BFu9s_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu9s_BFu0i()
{
  {
    init_simple_test("aB_BFu9s_BFu0i");
    static aB_BFu9s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu9s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu9s_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_BFu9s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu9s_BFu0i");
  }
}
static Arrange_To_Call_Me vaB_BFu9s_BFu0i(Test_aB_BFu9s_BFu0i, "aB_BFu9s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu9s_BFu0ll()
{
  {
    init_simple_test("aB_BFu9s_BFu0ll");
    static aB_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_BFu9s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu9s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_BFu9s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu9s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaB_BFu9s_BFu0ll(Test_aB_BFu9s_BFu0ll, "aB_BFu9s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu9s_BFu0s()
{
  {
    init_simple_test("aB_BFu9s_BFu0s");
    static aB_BFu9s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_BFu9s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu9s_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_BFu9s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aB_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aB_BFu9s_BFu0s");
  }
}
static Arrange_To_Call_Me vaB_BFu9s_BFu0s(Test_aB_BFu9s_BFu0s, "aB_BFu9s_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_C_BFu0c()
{
  {
    init_simple_test("aB_C_BFu0c");
    static aB_C_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_C_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_C_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_C_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aB_C_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaB_C_BFu0c(Test_aB_C_BFu0c, "aB_C_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_C_BFu0i()
{
  {
    init_simple_test("aB_C_BFu0i");
    static aB_C_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_C_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_C_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_C_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aB_C_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaB_C_BFu0i(Test_aB_C_BFu0i, "aB_C_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_C_BFu0ll()
{
  {
    init_simple_test("aB_C_BFu0ll");
    static aB_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_C_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_C_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_C_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aB_C_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaB_C_BFu0ll(Test_aB_C_BFu0ll, "aB_C_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_C_BFu0s()
{
  {
    init_simple_test("aB_C_BFu0s");
    static aB_C_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_C_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_C_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_C_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aB_C_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaB_C_BFu0s(Test_aB_C_BFu0s, "aB_C_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_D_BFu0c()
{
  {
    init_simple_test("aB_D_BFu0c");
    static aB_D_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aB_D_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_D_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_D_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aB_D_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaB_D_BFu0c(Test_aB_D_BFu0c, "aB_D_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_D_BFu0i()
{
  {
    init_simple_test("aB_D_BFu0i");
    static aB_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aB_D_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_D_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_D_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aB_D_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaB_D_BFu0i(Test_aB_D_BFu0i, "aB_D_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_D_BFu0ll()
{
  {
    init_simple_test("aB_D_BFu0ll");
    static aB_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aB_D_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_D_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aB_D_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaB_D_BFu0ll(Test_aB_D_BFu0ll, "aB_D_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_D_BFu0s()
{
  {
    init_simple_test("aB_D_BFu0s");
    static aB_D_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aB_D_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_D_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_D_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aB_D_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaB_D_BFu0s(Test_aB_D_BFu0s, "aB_D_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_F_BFu0c()
{
  {
    init_simple_test("aB_F_BFu0c");
    static aB_F_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aB_F_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_F_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_F_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aB_F_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaB_F_BFu0c(Test_aB_F_BFu0c, "aB_F_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_F_BFu0i()
{
  {
    init_simple_test("aB_F_BFu0i");
    static aB_F_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_F_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_F_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_F_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aB_F_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaB_F_BFu0i(Test_aB_F_BFu0i, "aB_F_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_F_BFu0ll()
{
  {
    init_simple_test("aB_F_BFu0ll");
    static aB_F_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_F_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_F_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aB_F_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaB_F_BFu0ll(Test_aB_F_BFu0ll, "aB_F_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_F_BFu0s()
{
  {
    init_simple_test("aB_F_BFu0s");
    static aB_F_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_F_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_F_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_F_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aB_F_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaB_F_BFu0s(Test_aB_F_BFu0s, "aB_F_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_I_BFu0c()
{
  {
    init_simple_test("aB_I_BFu0c");
    static aB_I_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aB_I_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_I_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_I_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aB_I_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaB_I_BFu0c(Test_aB_I_BFu0c, "aB_I_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_I_BFu0i()
{
  {
    init_simple_test("aB_I_BFu0i");
    static aB_I_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_I_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_I_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_I_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aB_I_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaB_I_BFu0i(Test_aB_I_BFu0i, "aB_I_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_I_BFu0ll()
{
  {
    init_simple_test("aB_I_BFu0ll");
    static aB_I_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_I_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_I_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aB_I_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaB_I_BFu0ll(Test_aB_I_BFu0ll, "aB_I_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_I_BFu0s()
{
  {
    init_simple_test("aB_I_BFu0s");
    static aB_I_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_I_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_I_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_I_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aB_I_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaB_I_BFu0s(Test_aB_I_BFu0s, "aB_I_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Ip_BFu0c()
{
  {
    init_simple_test("aB_Ip_BFu0c");
    static aB_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_Ip_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_Ip_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aB_Ip_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaB_Ip_BFu0c(Test_aB_Ip_BFu0c, "aB_Ip_BFu0c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Ip_BFu0i()
{
  {
    init_simple_test("aB_Ip_BFu0i");
    static aB_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_Ip_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_Ip_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aB_Ip_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaB_Ip_BFu0i(Test_aB_Ip_BFu0i, "aB_Ip_BFu0i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Ip_BFu0ll()
{
  {
    init_simple_test("aB_Ip_BFu0ll");
    static aB_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aB_Ip_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Ip_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_Ip_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aB_Ip_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaB_Ip_BFu0ll(Test_aB_Ip_BFu0ll, "aB_Ip_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Ip_BFu0s()
{
  {
    init_simple_test("aB_Ip_BFu0s");
    static aB_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_Ip_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Ip_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_Ip_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aB_Ip_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaB_Ip_BFu0s(Test_aB_Ip_BFu0s, "aB_Ip_BFu0s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_L_BFu0c()
{
  {
    init_simple_test("aB_L_BFu0c");
    static aB_L_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aB_L_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_L_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_L_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aB_L_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaB_L_BFu0c(Test_aB_L_BFu0c, "aB_L_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_L_BFu0i()
{
  {
    init_simple_test("aB_L_BFu0i");
    static aB_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aB_L_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_L_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_L_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aB_L_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaB_L_BFu0i(Test_aB_L_BFu0i, "aB_L_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_L_BFu0ll()
{
  {
    init_simple_test("aB_L_BFu0ll");
    static aB_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aB_L_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_L_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_L_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aB_L_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaB_L_BFu0ll(Test_aB_L_BFu0ll, "aB_L_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_L_BFu0s()
{
  {
    init_simple_test("aB_L_BFu0s");
    static aB_L_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aB_L_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_L_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_L_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aB_L_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaB_L_BFu0s(Test_aB_L_BFu0s, "aB_L_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_S_BFu0c()
{
  {
    init_simple_test("aB_S_BFu0c");
    static aB_S_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aB_S_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_S_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_S_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aB_S_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaB_S_BFu0c(Test_aB_S_BFu0c, "aB_S_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_S_BFu0i()
{
  {
    init_simple_test("aB_S_BFu0i");
    static aB_S_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_S_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_S_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_S_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aB_S_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaB_S_BFu0i(Test_aB_S_BFu0i, "aB_S_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_S_BFu0ll()
{
  {
    init_simple_test("aB_S_BFu0ll");
    static aB_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_S_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_S_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_S_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aB_S_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaB_S_BFu0ll(Test_aB_S_BFu0ll, "aB_S_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_S_BFu0s()
{
  {
    init_simple_test("aB_S_BFu0s");
    static aB_S_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_S_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_S_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_S_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aB_S_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaB_S_BFu0s(Test_aB_S_BFu0s, "aB_S_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Uc_BFu0c()
{
  {
    init_simple_test("aB_Uc_BFu0c");
    static aB_Uc_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aB_Uc_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Uc_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_Uc_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aB_Uc_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaB_Uc_BFu0c(Test_aB_Uc_BFu0c, "aB_Uc_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Uc_BFu0i()
{
  {
    init_simple_test("aB_Uc_BFu0i");
    static aB_Uc_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_Uc_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Uc_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_Uc_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aB_Uc_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaB_Uc_BFu0i(Test_aB_Uc_BFu0i, "aB_Uc_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Uc_BFu0ll()
{
  {
    init_simple_test("aB_Uc_BFu0ll");
    static aB_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_Uc_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Uc_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_Uc_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aB_Uc_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaB_Uc_BFu0ll(Test_aB_Uc_BFu0ll, "aB_Uc_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Uc_BFu0s()
{
  {
    init_simple_test("aB_Uc_BFu0s");
    static aB_Uc_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aB_Uc_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Uc_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_Uc_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aB_Uc_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaB_Uc_BFu0s(Test_aB_Uc_BFu0s, "aB_Uc_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Ui_BFu0c()
{
  {
    init_simple_test("aB_Ui_BFu0c");
    static aB_Ui_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aB_Ui_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Ui_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_Ui_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aB_Ui_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaB_Ui_BFu0c(Test_aB_Ui_BFu0c, "aB_Ui_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Ui_BFu0i()
{
  {
    init_simple_test("aB_Ui_BFu0i");
    static aB_Ui_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_Ui_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Ui_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_Ui_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aB_Ui_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaB_Ui_BFu0i(Test_aB_Ui_BFu0i, "aB_Ui_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Ui_BFu0ll()
{
  {
    init_simple_test("aB_Ui_BFu0ll");
    static aB_Ui_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aB_Ui_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Ui_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_Ui_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aB_Ui_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaB_Ui_BFu0ll(Test_aB_Ui_BFu0ll, "aB_Ui_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Ui_BFu0s()
{
  {
    init_simple_test("aB_Ui_BFu0s");
    static aB_Ui_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aB_Ui_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Ui_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_Ui_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aB_Ui_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaB_Ui_BFu0s(Test_aB_Ui_BFu0s, "aB_Ui_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Ul_BFu0c()
{
  {
    init_simple_test("aB_Ul_BFu0c");
    static aB_Ul_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aB_Ul_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Ul_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_Ul_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aB_Ul_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaB_Ul_BFu0c(Test_aB_Ul_BFu0c, "aB_Ul_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Ul_BFu0i()
{
  {
    init_simple_test("aB_Ul_BFu0i");
    static aB_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aB_Ul_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Ul_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_Ul_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aB_Ul_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaB_Ul_BFu0i(Test_aB_Ul_BFu0i, "aB_Ul_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Ul_BFu0ll()
{
  {
    init_simple_test("aB_Ul_BFu0ll");
    static aB_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aB_Ul_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Ul_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_Ul_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aB_Ul_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaB_Ul_BFu0ll(Test_aB_Ul_BFu0ll, "aB_Ul_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Ul_BFu0s()
{
  {
    init_simple_test("aB_Ul_BFu0s");
    static aB_Ul_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aB_Ul_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Ul_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_Ul_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aB_Ul_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaB_Ul_BFu0s(Test_aB_Ul_BFu0s, "aB_Ul_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Us_BFu0c()
{
  {
    init_simple_test("aB_Us_BFu0c");
    static aB_Us_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aB_Us_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Us_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_Us_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aB_Us_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaB_Us_BFu0c(Test_aB_Us_BFu0c, "aB_Us_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Us_BFu0i()
{
  {
    init_simple_test("aB_Us_BFu0i");
    static aB_Us_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_Us_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Us_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_Us_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aB_Us_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaB_Us_BFu0i(Test_aB_Us_BFu0i, "aB_Us_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Us_BFu0ll()
{
  {
    init_simple_test("aB_Us_BFu0ll");
    static aB_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aB_Us_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Us_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_Us_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aB_Us_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaB_Us_BFu0ll(Test_aB_Us_BFu0ll, "aB_Us_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Us_BFu0s()
{
  {
    init_simple_test("aB_Us_BFu0s");
    static aB_Us_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aB_Us_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Us_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_Us_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aB_Us_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaB_Us_BFu0s(Test_aB_Us_BFu0s, "aB_Us_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Vp_BFu0c()
{
  {
    init_simple_test("aB_Vp_BFu0c");
    static aB_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aB_Vp_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Vp_BFu0c)");
    check_field_offset(lv, v1, 0, "aB_Vp_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aB_Vp_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaB_Vp_BFu0c(Test_aB_Vp_BFu0c, "aB_Vp_BFu0c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Vp_BFu0i()
{
  {
    init_simple_test("aB_Vp_BFu0i");
    static aB_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_Vp_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Vp_BFu0i)");
    check_field_offset(lv, v1, 0, "aB_Vp_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aB_Vp_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaB_Vp_BFu0i(Test_aB_Vp_BFu0i, "aB_Vp_BFu0i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Vp_BFu0ll()
{
  {
    init_simple_test("aB_Vp_BFu0ll");
    static aB_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aB_Vp_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Vp_BFu0ll)");
    check_field_offset(lv, v1, 0, "aB_Vp_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aB_Vp_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaB_Vp_BFu0ll(Test_aB_Vp_BFu0ll, "aB_Vp_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_Vp_BFu0s()
{
  {
    init_simple_test("aB_Vp_BFu0s");
    static aB_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_Vp_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_Vp_BFu0s)");
    check_field_offset(lv, v1, 0, "aB_Vp_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aB_Vp_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaB_Vp_BFu0s(Test_aB_Vp_BFu0s, "aB_Vp_BFu0s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B()
{
  {
    init_simple_test("aBFu0c_B");
    static aBFu0c_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0c_B(Test_aBFu0c_B, "aBFu0c_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_B()
{
  {
    init_simple_test("aBFu0c_B_B");
    static aBFu0c_B_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_B.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_B_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_B(Test_aBFu0c_B_B, "aBFu0c_B_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu0c()
{
  {
    init_simple_test("aBFu0c_B_BFu0c");
    static aBFu0c_B_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu0c(Test_aBFu0c_B_BFu0c, "aBFu0c_B_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu0i()
{
  {
    init_simple_test("aBFu0c_B_BFu0i");
    static aBFu0c_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu0c_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu0i(Test_aBFu0c_B_BFu0i, "aBFu0c_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu0ll()
{
  {
    init_simple_test("aBFu0c_B_BFu0ll");
    static aBFu0c_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0c_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu0ll(Test_aBFu0c_B_BFu0ll, "aBFu0c_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu0s()
{
  {
    init_simple_test("aBFu0c_B_BFu0s");
    static aBFu0c_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu0c_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu0s(Test_aBFu0c_B_BFu0s, "aBFu0c_B_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu15i()
{
  {
    init_simple_test("aBFu0c_B_BFu15i");
    static aBFu0c_B_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0c_B_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0c_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu15i(Test_aBFu0c_B_BFu15i, "aBFu0c_B_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu15ll()
{
  {
    init_simple_test("aBFu0c_B_BFu15ll");
    static aBFu0c_B_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0c_B_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0c_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu15ll(Test_aBFu0c_B_BFu15ll, "aBFu0c_B_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu15s()
{
  {
    init_simple_test("aBFu0c_B_BFu15s");
    static aBFu0c_B_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0c_B_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0c_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu15s(Test_aBFu0c_B_BFu15s, "aBFu0c_B_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu16i()
{
  {
    init_simple_test("aBFu0c_B_BFu16i");
    static aBFu0c_B_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0c_B_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0c_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu16i(Test_aBFu0c_B_BFu16i, "aBFu0c_B_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu16ll()
{
  {
    init_simple_test("aBFu0c_B_BFu16ll");
    static aBFu0c_B_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0c_B_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0c_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu16ll(Test_aBFu0c_B_BFu16ll, "aBFu0c_B_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu16s()
{
  {
    init_simple_test("aBFu0c_B_BFu16s");
    static aBFu0c_B_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0c_B_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0c_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu16s(Test_aBFu0c_B_BFu16s, "aBFu0c_B_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu17i()
{
  {
    init_simple_test("aBFu0c_B_BFu17i");
    static aBFu0c_B_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu0c_B_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu0c_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu17i(Test_aBFu0c_B_BFu17i, "aBFu0c_B_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu17ll()
{
  {
    init_simple_test("aBFu0c_B_BFu17ll");
    static aBFu0c_B_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu0c_B_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu0c_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu17ll(Test_aBFu0c_B_BFu17ll, "aBFu0c_B_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu1c()
{
  {
    init_simple_test("aBFu0c_B_BFu1c");
    static aBFu0c_B_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0c_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu1c(Test_aBFu0c_B_BFu1c, "aBFu0c_B_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu1i()
{
  {
    init_simple_test("aBFu0c_B_BFu1i");
    static aBFu0c_B_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0c_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu1i(Test_aBFu0c_B_BFu1i, "aBFu0c_B_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu1ll()
{
  {
    init_simple_test("aBFu0c_B_BFu1ll");
    static aBFu0c_B_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0c_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu1ll(Test_aBFu0c_B_BFu1ll, "aBFu0c_B_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu1s()
{
  {
    init_simple_test("aBFu0c_B_BFu1s");
    static aBFu0c_B_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0c_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu1s(Test_aBFu0c_B_BFu1s, "aBFu0c_B_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu31i()
{
  {
    init_simple_test("aBFu0c_B_BFu31i");
    static aBFu0c_B_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu0c_B_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu0c_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu31i(Test_aBFu0c_B_BFu31i, "aBFu0c_B_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu31ll()
{
  {
    init_simple_test("aBFu0c_B_BFu31ll");
    static aBFu0c_B_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu0c_B_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu0c_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu31ll(Test_aBFu0c_B_BFu31ll, "aBFu0c_B_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu32i()
{
  {
    init_simple_test("aBFu0c_B_BFu32i");
    static aBFu0c_B_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu0c_B_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu0c_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu32i(Test_aBFu0c_B_BFu32i, "aBFu0c_B_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu32ll()
{
  {
    init_simple_test("aBFu0c_B_BFu32ll");
    static aBFu0c_B_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu0c_B_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu0c_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu32ll(Test_aBFu0c_B_BFu32ll, "aBFu0c_B_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu33()
{
  {
    init_simple_test("aBFu0c_B_BFu33");
    static aBFu0c_B_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0c_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aBFu0c_B_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aBFu0c_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu33(Test_aBFu0c_B_BFu33, "aBFu0c_B_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu7c()
{
  {
    init_simple_test("aBFu0c_B_BFu7c");
    static aBFu0c_B_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0c_B_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0c_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu7c(Test_aBFu0c_B_BFu7c, "aBFu0c_B_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu7i()
{
  {
    init_simple_test("aBFu0c_B_BFu7i");
    static aBFu0c_B_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0c_B_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0c_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu7i(Test_aBFu0c_B_BFu7i, "aBFu0c_B_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu7ll()
{
  {
    init_simple_test("aBFu0c_B_BFu7ll");
    static aBFu0c_B_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0c_B_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0c_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu7ll(Test_aBFu0c_B_BFu7ll, "aBFu0c_B_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu7s()
{
  {
    init_simple_test("aBFu0c_B_BFu7s");
    static aBFu0c_B_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0c_B_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0c_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu7s(Test_aBFu0c_B_BFu7s, "aBFu0c_B_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu8c()
{
  {
    init_simple_test("aBFu0c_B_BFu8c");
    static aBFu0c_B_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0c_B_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0c_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu8c(Test_aBFu0c_B_BFu8c, "aBFu0c_B_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu8i()
{
  {
    init_simple_test("aBFu0c_B_BFu8i");
    static aBFu0c_B_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0c_B_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0c_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu8i(Test_aBFu0c_B_BFu8i, "aBFu0c_B_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu8ll()
{
  {
    init_simple_test("aBFu0c_B_BFu8ll");
    static aBFu0c_B_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0c_B_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0c_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu8ll(Test_aBFu0c_B_BFu8ll, "aBFu0c_B_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu8s()
{
  {
    init_simple_test("aBFu0c_B_BFu8s");
    static aBFu0c_B_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0c_B_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0c_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu8s(Test_aBFu0c_B_BFu8s, "aBFu0c_B_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu9i()
{
  {
    init_simple_test("aBFu0c_B_BFu9i");
    static aBFu0c_B_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0c_B_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0c_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu9i(Test_aBFu0c_B_BFu9i, "aBFu0c_B_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu9ll()
{
  {
    init_simple_test("aBFu0c_B_BFu9ll");
    static aBFu0c_B_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0c_B_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0c_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu9ll(Test_aBFu0c_B_BFu9ll, "aBFu0c_B_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_BFu9s()
{
  {
    init_simple_test("aBFu0c_B_BFu9s");
    static aBFu0c_B_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0c_B_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0c_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_BFu9s(Test_aBFu0c_B_BFu9s, "aBFu0c_B_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_C()
{
  {
    init_simple_test("aBFu0c_B_C");
    static aBFu0c_B_C lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_C)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_C.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_B_C.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_C(Test_aBFu0c_B_C, "aBFu0c_B_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_D()
{
  {
    init_simple_test("aBFu0c_B_D");
    static aBFu0c_B_D lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0c_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_D)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_D.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_B_D.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_D(Test_aBFu0c_B_D, "aBFu0c_B_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_F()
{
  {
    init_simple_test("aBFu0c_B_F");
    static aBFu0c_B_F lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_F)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_F.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_B_F.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_F(Test_aBFu0c_B_F, "aBFu0c_B_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_I()
{
  {
    init_simple_test("aBFu0c_B_I");
    static aBFu0c_B_I lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_I)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_I.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_B_I.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_I(Test_aBFu0c_B_I, "aBFu0c_B_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_Ip()
{
  {
    init_simple_test("aBFu0c_B_Ip");
    static aBFu0c_B_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0c_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_Ip.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_B_Ip.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_Ip(Test_aBFu0c_B_Ip, "aBFu0c_B_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_L()
{
  {
    init_simple_test("aBFu0c_B_L");
    static aBFu0c_B_L lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0c_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_L)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_L.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_B_L.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_L(Test_aBFu0c_B_L, "aBFu0c_B_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_S()
{
  {
    init_simple_test("aBFu0c_B_S");
    static aBFu0c_B_S lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_S)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_S.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_B_S.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_S(Test_aBFu0c_B_S, "aBFu0c_B_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_Uc()
{
  {
    init_simple_test("aBFu0c_B_Uc");
    static aBFu0c_B_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_Uc.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_B_Uc.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_Uc(Test_aBFu0c_B_Uc, "aBFu0c_B_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_Ui()
{
  {
    init_simple_test("aBFu0c_B_Ui");
    static aBFu0c_B_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_Ui.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_B_Ui.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_Ui(Test_aBFu0c_B_Ui, "aBFu0c_B_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_Ul()
{
  {
    init_simple_test("aBFu0c_B_Ul");
    static aBFu0c_B_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0c_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_Ul.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_B_Ul.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_Ul(Test_aBFu0c_B_Ul, "aBFu0c_B_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_Us()
{
  {
    init_simple_test("aBFu0c_B_Us");
    static aBFu0c_B_Us lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_Us)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_Us.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_B_Us.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_Us(Test_aBFu0c_B_Us, "aBFu0c_B_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_B_Vp()
{
  {
    init_simple_test("aBFu0c_B_Vp");
    static aBFu0c_B_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0c_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_B_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0c_B_Vp.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_B_Vp.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_B_Vp(Test_aBFu0c_B_Vp, "aBFu0c_B_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu0c_B()
{
  {
    init_simple_test("aBFu0c_BFu0c_B");
    static aBFu0c_BFu0c_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_BFu0c_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu0c_B(Test_aBFu0c_BFu0c_B, "aBFu0c_BFu0c_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu0i_B()
{
  {
    init_simple_test("aBFu0c_BFu0i_B");
    static aBFu0c_BFu0i_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_BFu0i_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu0i_B(Test_aBFu0c_BFu0i_B, "aBFu0c_BFu0i_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu0ll_B()
{
  {
    init_simple_test("aBFu0c_BFu0ll_B");
    static aBFu0c_BFu0ll_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_BFu0ll_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu0ll_B(Test_aBFu0c_BFu0ll_B, "aBFu0c_BFu0ll_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu0s_B()
{
  {
    init_simple_test("aBFu0c_BFu0s_B");
    static aBFu0c_BFu0s_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_BFu0s_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu0s_B(Test_aBFu0c_BFu0s_B, "aBFu0c_BFu0s_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu15i_B()
{
  {
    init_simple_test("aBFu0c_BFu15i_B");
    static aBFu0c_BFu15i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0c_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0c_BFu15i_B");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu15i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu15i_B(Test_aBFu0c_BFu15i_B, "aBFu0c_BFu15i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu15ll_B()
{
  {
    init_simple_test("aBFu0c_BFu15ll_B");
    static aBFu0c_BFu15ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0c_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0c_BFu15ll_B");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu15ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu15ll_B(Test_aBFu0c_BFu15ll_B, "aBFu0c_BFu15ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu15s_B()
{
  {
    init_simple_test("aBFu0c_BFu15s_B");
    static aBFu0c_BFu15s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0c_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0c_BFu15s_B");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu15s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu15s_B(Test_aBFu0c_BFu15s_B, "aBFu0c_BFu15s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu16i_B()
{
  {
    init_simple_test("aBFu0c_BFu16i_B");
    static aBFu0c_BFu16i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0c_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0c_BFu16i_B");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu16i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu16i_B(Test_aBFu0c_BFu16i_B, "aBFu0c_BFu16i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu16ll_B()
{
  {
    init_simple_test("aBFu0c_BFu16ll_B");
    static aBFu0c_BFu16ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0c_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0c_BFu16ll_B");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu16ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu16ll_B(Test_aBFu0c_BFu16ll_B, "aBFu0c_BFu16ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu16s_B()
{
  {
    init_simple_test("aBFu0c_BFu16s_B");
    static aBFu0c_BFu16s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0c_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0c_BFu16s_B");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu16s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu16s_B(Test_aBFu0c_BFu16s_B, "aBFu0c_BFu16s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu17i_B()
{
  {
    init_simple_test("aBFu0c_BFu17i_B");
    static aBFu0c_BFu17i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0c_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0c_BFu17i_B");
    check_field_offset(lv, v2, 3, "aBFu0c_BFu17i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu17i_B(Test_aBFu0c_BFu17i_B, "aBFu0c_BFu17i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu17ll_B()
{
  {
    init_simple_test("aBFu0c_BFu17ll_B");
    static aBFu0c_BFu17ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0c_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0c_BFu17ll_B");
    check_field_offset(lv, v2, 3, "aBFu0c_BFu17ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu17ll_B(Test_aBFu0c_BFu17ll_B, "aBFu0c_BFu17ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu1c_B()
{
  {
    init_simple_test("aBFu0c_BFu1c_B");
    static aBFu0c_BFu1c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0c_BFu1c_B");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu1c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu1c_B(Test_aBFu0c_BFu1c_B, "aBFu0c_BFu1c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu1i_B()
{
  {
    init_simple_test("aBFu0c_BFu1i_B");
    static aBFu0c_BFu1i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0c_BFu1i_B");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu1i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu1i_B(Test_aBFu0c_BFu1i_B, "aBFu0c_BFu1i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu1ll_B()
{
  {
    init_simple_test("aBFu0c_BFu1ll_B");
    static aBFu0c_BFu1ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0c_BFu1ll_B");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu1ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu1ll_B(Test_aBFu0c_BFu1ll_B, "aBFu0c_BFu1ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu1s_B()
{
  {
    init_simple_test("aBFu0c_BFu1s_B");
    static aBFu0c_BFu1s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0c_BFu1s_B");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu1s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu1s_B(Test_aBFu0c_BFu1s_B, "aBFu0c_BFu1s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu31i_B()
{
  {
    init_simple_test("aBFu0c_BFu31i_B");
    static aBFu0c_BFu31i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0c_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0c_BFu31i_B");
    check_field_offset(lv, v2, 4, "aBFu0c_BFu31i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu31i_B(Test_aBFu0c_BFu31i_B, "aBFu0c_BFu31i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu31ll_B()
{
  {
    init_simple_test("aBFu0c_BFu31ll_B");
    static aBFu0c_BFu31ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0c_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0c_BFu31ll_B");
    check_field_offset(lv, v2, 4, "aBFu0c_BFu31ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu31ll_B(Test_aBFu0c_BFu31ll_B, "aBFu0c_BFu31ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu32i_B()
{
  {
    init_simple_test("aBFu0c_BFu32i_B");
    static aBFu0c_BFu32i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0c_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0c_BFu32i_B");
    check_field_offset(lv, v2, 4, "aBFu0c_BFu32i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu32i_B(Test_aBFu0c_BFu32i_B, "aBFu0c_BFu32i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu32ll_B()
{
  {
    init_simple_test("aBFu0c_BFu32ll_B");
    static aBFu0c_BFu32ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0c_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0c_BFu32ll_B");
    check_field_offset(lv, v2, 4, "aBFu0c_BFu32ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu32ll_B(Test_aBFu0c_BFu32ll_B, "aBFu0c_BFu32ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu33_B()
{
  {
    init_simple_test("aBFu0c_BFu33_B");
    static aBFu0c_BFu33_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0c_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu0c_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu0c_BFu33_B");
    check_field_offset(lv, v2, 5, "aBFu0c_BFu33_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu33_B(Test_aBFu0c_BFu33_B, "aBFu0c_BFu33_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu7c_B()
{
  {
    init_simple_test("aBFu0c_BFu7c_B");
    static aBFu0c_BFu7c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0c_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0c_BFu7c_B");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu7c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu7c_B(Test_aBFu0c_BFu7c_B, "aBFu0c_BFu7c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu7i_B()
{
  {
    init_simple_test("aBFu0c_BFu7i_B");
    static aBFu0c_BFu7i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0c_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0c_BFu7i_B");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu7i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu7i_B(Test_aBFu0c_BFu7i_B, "aBFu0c_BFu7i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu7ll_B()
{
  {
    init_simple_test("aBFu0c_BFu7ll_B");
    static aBFu0c_BFu7ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0c_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0c_BFu7ll_B");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu7ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu7ll_B(Test_aBFu0c_BFu7ll_B, "aBFu0c_BFu7ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu7s_B()
{
  {
    init_simple_test("aBFu0c_BFu7s_B");
    static aBFu0c_BFu7s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0c_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0c_BFu7s_B");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu7s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu7s_B(Test_aBFu0c_BFu7s_B, "aBFu0c_BFu7s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu8c_B()
{
  {
    init_simple_test("aBFu0c_BFu8c_B");
    static aBFu0c_BFu8c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0c_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0c_BFu8c_B");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu8c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu8c_B(Test_aBFu0c_BFu8c_B, "aBFu0c_BFu8c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu8i_B()
{
  {
    init_simple_test("aBFu0c_BFu8i_B");
    static aBFu0c_BFu8i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0c_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0c_BFu8i_B");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu8i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu8i_B(Test_aBFu0c_BFu8i_B, "aBFu0c_BFu8i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu8ll_B()
{
  {
    init_simple_test("aBFu0c_BFu8ll_B");
    static aBFu0c_BFu8ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0c_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0c_BFu8ll_B");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu8ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu8ll_B(Test_aBFu0c_BFu8ll_B, "aBFu0c_BFu8ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu8s_B()
{
  {
    init_simple_test("aBFu0c_BFu8s_B");
    static aBFu0c_BFu8s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0c_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0c_BFu8s_B");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu8s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu8s_B(Test_aBFu0c_BFu8s_B, "aBFu0c_BFu8s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu9i_B()
{
  {
    init_simple_test("aBFu0c_BFu9i_B");
    static aBFu0c_BFu9i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0c_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0c_BFu9i_B");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu9i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu9i_B(Test_aBFu0c_BFu9i_B, "aBFu0c_BFu9i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu9ll_B()
{
  {
    init_simple_test("aBFu0c_BFu9ll_B");
    static aBFu0c_BFu9ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0c_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0c_BFu9ll_B");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu9ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu9ll_B(Test_aBFu0c_BFu9ll_B, "aBFu0c_BFu9ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_BFu9s_B()
{
  {
    init_simple_test("aBFu0c_BFu9s_B");
    static aBFu0c_BFu9s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0c_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0c_BFu9s_B");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu9s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_BFu9s_B(Test_aBFu0c_BFu9s_B, "aBFu0c_BFu9s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_C_B()
{
  {
    init_simple_test("aBFu0c_C_B");
    static aBFu0c_C_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_C_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_C_B.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_C_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_C_B(Test_aBFu0c_C_B, "aBFu0c_C_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_D_B()
{
  {
    init_simple_test("aBFu0c_D_B");
    static aBFu0c_D_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0c_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_D_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_D_B.v1");
    check_field_offset(lv, v2, 8, "aBFu0c_D_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_D_B(Test_aBFu0c_D_B, "aBFu0c_D_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_F_B()
{
  {
    init_simple_test("aBFu0c_F_B");
    static aBFu0c_F_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_F_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_F_B.v1");
    check_field_offset(lv, v2, 4, "aBFu0c_F_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_F_B(Test_aBFu0c_F_B, "aBFu0c_F_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_I_B()
{
  {
    init_simple_test("aBFu0c_I_B");
    static aBFu0c_I_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_I_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_I_B.v1");
    check_field_offset(lv, v2, 4, "aBFu0c_I_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_I_B(Test_aBFu0c_I_B, "aBFu0c_I_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_Ip_B()
{
  {
    init_simple_test("aBFu0c_Ip_B");
    static aBFu0c_Ip_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0c_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Ip_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_Ip_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0c_Ip_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_Ip_B(Test_aBFu0c_Ip_B, "aBFu0c_Ip_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_L_B()
{
  {
    init_simple_test("aBFu0c_L_B");
    static aBFu0c_L_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0c_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_L_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_L_B.v1");
    check_field_offset(lv, v2, 8, "aBFu0c_L_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_L_B(Test_aBFu0c_L_B, "aBFu0c_L_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_S_B()
{
  {
    init_simple_test("aBFu0c_S_B");
    static aBFu0c_S_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_S_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_S_B.v1");
    check_field_offset(lv, v2, 2, "aBFu0c_S_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_S_B(Test_aBFu0c_S_B, "aBFu0c_S_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_Uc_B()
{
  {
    init_simple_test("aBFu0c_Uc_B");
    static aBFu0c_Uc_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Uc_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_Uc_B.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_Uc_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_Uc_B(Test_aBFu0c_Uc_B, "aBFu0c_Uc_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_Ui_B()
{
  {
    init_simple_test("aBFu0c_Ui_B");
    static aBFu0c_Ui_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Ui_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_Ui_B.v1");
    check_field_offset(lv, v2, 4, "aBFu0c_Ui_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_Ui_B(Test_aBFu0c_Ui_B, "aBFu0c_Ui_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_Ul_B()
{
  {
    init_simple_test("aBFu0c_Ul_B");
    static aBFu0c_Ul_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0c_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Ul_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_Ul_B.v1");
    check_field_offset(lv, v2, 8, "aBFu0c_Ul_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_Ul_B(Test_aBFu0c_Ul_B, "aBFu0c_Ul_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_Us_B()
{
  {
    init_simple_test("aBFu0c_Us_B");
    static aBFu0c_Us_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Us_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_Us_B.v1");
    check_field_offset(lv, v2, 2, "aBFu0c_Us_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_Us_B(Test_aBFu0c_Us_B, "aBFu0c_Us_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0c_Vp_B()
{
  {
    init_simple_test("aBFu0c_Vp_B");
    static aBFu0c_Vp_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0c_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Vp_B)");
    check_field_offset(lv, v1, 0, "aBFu0c_Vp_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0c_Vp_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0c_Vp_B(Test_aBFu0c_Vp_B, "aBFu0c_Vp_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B()
{
  {
    init_simple_test("aBFu0i_B");
    static aBFu0i_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0i_B(Test_aBFu0i_B, "aBFu0i_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_B()
{
  {
    init_simple_test("aBFu0i_B_B");
    static aBFu0i_B_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_B.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_B_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_B(Test_aBFu0i_B_B, "aBFu0i_B_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu0c()
{
  {
    init_simple_test("aBFu0i_B_BFu0c");
    static aBFu0i_B_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu0c(Test_aBFu0i_B_BFu0c, "aBFu0i_B_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu0i()
{
  {
    init_simple_test("aBFu0i_B_BFu0i");
    static aBFu0i_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu0i_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu0i(Test_aBFu0i_B_BFu0i, "aBFu0i_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu0ll()
{
  {
    init_simple_test("aBFu0i_B_BFu0ll");
    static aBFu0i_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0i_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu0ll(Test_aBFu0i_B_BFu0ll, "aBFu0i_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu0s()
{
  {
    init_simple_test("aBFu0i_B_BFu0s");
    static aBFu0i_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu0i_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu0s(Test_aBFu0i_B_BFu0s, "aBFu0i_B_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu15i()
{
  {
    init_simple_test("aBFu0i_B_BFu15i");
    static aBFu0i_B_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0i_B_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0i_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu15i(Test_aBFu0i_B_BFu15i, "aBFu0i_B_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu15ll()
{
  {
    init_simple_test("aBFu0i_B_BFu15ll");
    static aBFu0i_B_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0i_B_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0i_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu15ll(Test_aBFu0i_B_BFu15ll, "aBFu0i_B_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu15s()
{
  {
    init_simple_test("aBFu0i_B_BFu15s");
    static aBFu0i_B_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0i_B_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0i_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu15s(Test_aBFu0i_B_BFu15s, "aBFu0i_B_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu16i()
{
  {
    init_simple_test("aBFu0i_B_BFu16i");
    static aBFu0i_B_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0i_B_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0i_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu16i(Test_aBFu0i_B_BFu16i, "aBFu0i_B_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu16ll()
{
  {
    init_simple_test("aBFu0i_B_BFu16ll");
    static aBFu0i_B_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0i_B_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0i_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu16ll(Test_aBFu0i_B_BFu16ll, "aBFu0i_B_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu16s()
{
  {
    init_simple_test("aBFu0i_B_BFu16s");
    static aBFu0i_B_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0i_B_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0i_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu16s(Test_aBFu0i_B_BFu16s, "aBFu0i_B_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu17i()
{
  {
    init_simple_test("aBFu0i_B_BFu17i");
    static aBFu0i_B_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu0i_B_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu0i_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu17i(Test_aBFu0i_B_BFu17i, "aBFu0i_B_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu17ll()
{
  {
    init_simple_test("aBFu0i_B_BFu17ll");
    static aBFu0i_B_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu0i_B_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu0i_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu17ll(Test_aBFu0i_B_BFu17ll, "aBFu0i_B_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu1c()
{
  {
    init_simple_test("aBFu0i_B_BFu1c");
    static aBFu0i_B_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0i_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu1c(Test_aBFu0i_B_BFu1c, "aBFu0i_B_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu1i()
{
  {
    init_simple_test("aBFu0i_B_BFu1i");
    static aBFu0i_B_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0i_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu1i(Test_aBFu0i_B_BFu1i, "aBFu0i_B_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu1ll()
{
  {
    init_simple_test("aBFu0i_B_BFu1ll");
    static aBFu0i_B_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0i_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu1ll(Test_aBFu0i_B_BFu1ll, "aBFu0i_B_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu1s()
{
  {
    init_simple_test("aBFu0i_B_BFu1s");
    static aBFu0i_B_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0i_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu1s(Test_aBFu0i_B_BFu1s, "aBFu0i_B_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu31i()
{
  {
    init_simple_test("aBFu0i_B_BFu31i");
    static aBFu0i_B_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu0i_B_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu0i_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu31i(Test_aBFu0i_B_BFu31i, "aBFu0i_B_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu31ll()
{
  {
    init_simple_test("aBFu0i_B_BFu31ll");
    static aBFu0i_B_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu0i_B_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu0i_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu31ll(Test_aBFu0i_B_BFu31ll, "aBFu0i_B_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu32i()
{
  {
    init_simple_test("aBFu0i_B_BFu32i");
    static aBFu0i_B_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu0i_B_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu0i_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu32i(Test_aBFu0i_B_BFu32i, "aBFu0i_B_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu32ll()
{
  {
    init_simple_test("aBFu0i_B_BFu32ll");
    static aBFu0i_B_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu0i_B_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu0i_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu32ll(Test_aBFu0i_B_BFu32ll, "aBFu0i_B_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu33()
{
  {
    init_simple_test("aBFu0i_B_BFu33");
    static aBFu0i_B_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0i_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aBFu0i_B_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aBFu0i_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu33(Test_aBFu0i_B_BFu33, "aBFu0i_B_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu7c()
{
  {
    init_simple_test("aBFu0i_B_BFu7c");
    static aBFu0i_B_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0i_B_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0i_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu7c(Test_aBFu0i_B_BFu7c, "aBFu0i_B_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu7i()
{
  {
    init_simple_test("aBFu0i_B_BFu7i");
    static aBFu0i_B_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0i_B_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0i_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu7i(Test_aBFu0i_B_BFu7i, "aBFu0i_B_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu7ll()
{
  {
    init_simple_test("aBFu0i_B_BFu7ll");
    static aBFu0i_B_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0i_B_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0i_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu7ll(Test_aBFu0i_B_BFu7ll, "aBFu0i_B_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu7s()
{
  {
    init_simple_test("aBFu0i_B_BFu7s");
    static aBFu0i_B_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0i_B_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0i_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu7s(Test_aBFu0i_B_BFu7s, "aBFu0i_B_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu8c()
{
  {
    init_simple_test("aBFu0i_B_BFu8c");
    static aBFu0i_B_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0i_B_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0i_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu8c(Test_aBFu0i_B_BFu8c, "aBFu0i_B_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu8i()
{
  {
    init_simple_test("aBFu0i_B_BFu8i");
    static aBFu0i_B_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0i_B_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0i_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu8i(Test_aBFu0i_B_BFu8i, "aBFu0i_B_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu8ll()
{
  {
    init_simple_test("aBFu0i_B_BFu8ll");
    static aBFu0i_B_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0i_B_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0i_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu8ll(Test_aBFu0i_B_BFu8ll, "aBFu0i_B_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu8s()
{
  {
    init_simple_test("aBFu0i_B_BFu8s");
    static aBFu0i_B_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0i_B_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0i_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu8s(Test_aBFu0i_B_BFu8s, "aBFu0i_B_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu9i()
{
  {
    init_simple_test("aBFu0i_B_BFu9i");
    static aBFu0i_B_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0i_B_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0i_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu9i(Test_aBFu0i_B_BFu9i, "aBFu0i_B_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu9ll()
{
  {
    init_simple_test("aBFu0i_B_BFu9ll");
    static aBFu0i_B_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0i_B_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0i_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu9ll(Test_aBFu0i_B_BFu9ll, "aBFu0i_B_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_BFu9s()
{
  {
    init_simple_test("aBFu0i_B_BFu9s");
    static aBFu0i_B_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0i_B_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0i_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_BFu9s(Test_aBFu0i_B_BFu9s, "aBFu0i_B_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_C()
{
  {
    init_simple_test("aBFu0i_B_C");
    static aBFu0i_B_C lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_C)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_C.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_B_C.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_C(Test_aBFu0i_B_C, "aBFu0i_B_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_D()
{
  {
    init_simple_test("aBFu0i_B_D");
    static aBFu0i_B_D lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0i_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_D)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_D.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_B_D.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_D(Test_aBFu0i_B_D, "aBFu0i_B_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_F()
{
  {
    init_simple_test("aBFu0i_B_F");
    static aBFu0i_B_F lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_F)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_F.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_B_F.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_F(Test_aBFu0i_B_F, "aBFu0i_B_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_I()
{
  {
    init_simple_test("aBFu0i_B_I");
    static aBFu0i_B_I lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_I)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_I.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_B_I.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_I(Test_aBFu0i_B_I, "aBFu0i_B_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_Ip()
{
  {
    init_simple_test("aBFu0i_B_Ip");
    static aBFu0i_B_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0i_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_Ip.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_B_Ip.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_Ip(Test_aBFu0i_B_Ip, "aBFu0i_B_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_L()
{
  {
    init_simple_test("aBFu0i_B_L");
    static aBFu0i_B_L lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0i_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_L)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_L.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_B_L.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_L(Test_aBFu0i_B_L, "aBFu0i_B_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_S()
{
  {
    init_simple_test("aBFu0i_B_S");
    static aBFu0i_B_S lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_S)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_S.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_B_S.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_S(Test_aBFu0i_B_S, "aBFu0i_B_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_Uc()
{
  {
    init_simple_test("aBFu0i_B_Uc");
    static aBFu0i_B_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_Uc.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_B_Uc.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_Uc(Test_aBFu0i_B_Uc, "aBFu0i_B_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_Ui()
{
  {
    init_simple_test("aBFu0i_B_Ui");
    static aBFu0i_B_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_Ui.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_B_Ui.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_Ui(Test_aBFu0i_B_Ui, "aBFu0i_B_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_Ul()
{
  {
    init_simple_test("aBFu0i_B_Ul");
    static aBFu0i_B_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0i_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_Ul.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_B_Ul.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_Ul(Test_aBFu0i_B_Ul, "aBFu0i_B_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_Us()
{
  {
    init_simple_test("aBFu0i_B_Us");
    static aBFu0i_B_Us lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_Us)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_Us.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_B_Us.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_Us(Test_aBFu0i_B_Us, "aBFu0i_B_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_B_Vp()
{
  {
    init_simple_test("aBFu0i_B_Vp");
    static aBFu0i_B_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0i_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_B_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0i_B_Vp.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_B_Vp.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_B_Vp(Test_aBFu0i_B_Vp, "aBFu0i_B_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu0c_B()
{
  {
    init_simple_test("aBFu0i_BFu0c_B");
    static aBFu0i_BFu0c_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_BFu0c_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu0c_B(Test_aBFu0i_BFu0c_B, "aBFu0i_BFu0c_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu0i_B()
{
  {
    init_simple_test("aBFu0i_BFu0i_B");
    static aBFu0i_BFu0i_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_BFu0i_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu0i_B(Test_aBFu0i_BFu0i_B, "aBFu0i_BFu0i_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu0ll_B()
{
  {
    init_simple_test("aBFu0i_BFu0ll_B");
    static aBFu0i_BFu0ll_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_BFu0ll_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu0ll_B(Test_aBFu0i_BFu0ll_B, "aBFu0i_BFu0ll_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu0s_B()
{
  {
    init_simple_test("aBFu0i_BFu0s_B");
    static aBFu0i_BFu0s_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_BFu0s_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu0s_B(Test_aBFu0i_BFu0s_B, "aBFu0i_BFu0s_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu15i_B()
{
  {
    init_simple_test("aBFu0i_BFu15i_B");
    static aBFu0i_BFu15i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0i_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0i_BFu15i_B");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu15i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu15i_B(Test_aBFu0i_BFu15i_B, "aBFu0i_BFu15i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu15ll_B()
{
  {
    init_simple_test("aBFu0i_BFu15ll_B");
    static aBFu0i_BFu15ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0i_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0i_BFu15ll_B");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu15ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu15ll_B(Test_aBFu0i_BFu15ll_B, "aBFu0i_BFu15ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu15s_B()
{
  {
    init_simple_test("aBFu0i_BFu15s_B");
    static aBFu0i_BFu15s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0i_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0i_BFu15s_B");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu15s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu15s_B(Test_aBFu0i_BFu15s_B, "aBFu0i_BFu15s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu16i_B()
{
  {
    init_simple_test("aBFu0i_BFu16i_B");
    static aBFu0i_BFu16i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0i_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0i_BFu16i_B");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu16i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu16i_B(Test_aBFu0i_BFu16i_B, "aBFu0i_BFu16i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu16ll_B()
{
  {
    init_simple_test("aBFu0i_BFu16ll_B");
    static aBFu0i_BFu16ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0i_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0i_BFu16ll_B");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu16ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu16ll_B(Test_aBFu0i_BFu16ll_B, "aBFu0i_BFu16ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu16s_B()
{
  {
    init_simple_test("aBFu0i_BFu16s_B");
    static aBFu0i_BFu16s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0i_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0i_BFu16s_B");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu16s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu16s_B(Test_aBFu0i_BFu16s_B, "aBFu0i_BFu16s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu17i_B()
{
  {
    init_simple_test("aBFu0i_BFu17i_B");
    static aBFu0i_BFu17i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0i_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0i_BFu17i_B");
    check_field_offset(lv, v2, 3, "aBFu0i_BFu17i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu17i_B(Test_aBFu0i_BFu17i_B, "aBFu0i_BFu17i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu17ll_B()
{
  {
    init_simple_test("aBFu0i_BFu17ll_B");
    static aBFu0i_BFu17ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0i_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0i_BFu17ll_B");
    check_field_offset(lv, v2, 3, "aBFu0i_BFu17ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu17ll_B(Test_aBFu0i_BFu17ll_B, "aBFu0i_BFu17ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu1c_B()
{
  {
    init_simple_test("aBFu0i_BFu1c_B");
    static aBFu0i_BFu1c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0i_BFu1c_B");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu1c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu1c_B(Test_aBFu0i_BFu1c_B, "aBFu0i_BFu1c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu1i_B()
{
  {
    init_simple_test("aBFu0i_BFu1i_B");
    static aBFu0i_BFu1i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0i_BFu1i_B");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu1i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu1i_B(Test_aBFu0i_BFu1i_B, "aBFu0i_BFu1i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu1ll_B()
{
  {
    init_simple_test("aBFu0i_BFu1ll_B");
    static aBFu0i_BFu1ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0i_BFu1ll_B");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu1ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu1ll_B(Test_aBFu0i_BFu1ll_B, "aBFu0i_BFu1ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu1s_B()
{
  {
    init_simple_test("aBFu0i_BFu1s_B");
    static aBFu0i_BFu1s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0i_BFu1s_B");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu1s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu1s_B(Test_aBFu0i_BFu1s_B, "aBFu0i_BFu1s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu31i_B()
{
  {
    init_simple_test("aBFu0i_BFu31i_B");
    static aBFu0i_BFu31i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0i_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0i_BFu31i_B");
    check_field_offset(lv, v2, 4, "aBFu0i_BFu31i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu31i_B(Test_aBFu0i_BFu31i_B, "aBFu0i_BFu31i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu31ll_B()
{
  {
    init_simple_test("aBFu0i_BFu31ll_B");
    static aBFu0i_BFu31ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0i_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0i_BFu31ll_B");
    check_field_offset(lv, v2, 4, "aBFu0i_BFu31ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu31ll_B(Test_aBFu0i_BFu31ll_B, "aBFu0i_BFu31ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu32i_B()
{
  {
    init_simple_test("aBFu0i_BFu32i_B");
    static aBFu0i_BFu32i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0i_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0i_BFu32i_B");
    check_field_offset(lv, v2, 4, "aBFu0i_BFu32i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu32i_B(Test_aBFu0i_BFu32i_B, "aBFu0i_BFu32i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu32ll_B()
{
  {
    init_simple_test("aBFu0i_BFu32ll_B");
    static aBFu0i_BFu32ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0i_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0i_BFu32ll_B");
    check_field_offset(lv, v2, 4, "aBFu0i_BFu32ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu32ll_B(Test_aBFu0i_BFu32ll_B, "aBFu0i_BFu32ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu33_B()
{
  {
    init_simple_test("aBFu0i_BFu33_B");
    static aBFu0i_BFu33_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0i_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu0i_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu0i_BFu33_B");
    check_field_offset(lv, v2, 5, "aBFu0i_BFu33_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu33_B(Test_aBFu0i_BFu33_B, "aBFu0i_BFu33_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu7c_B()
{
  {
    init_simple_test("aBFu0i_BFu7c_B");
    static aBFu0i_BFu7c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0i_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0i_BFu7c_B");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu7c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu7c_B(Test_aBFu0i_BFu7c_B, "aBFu0i_BFu7c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu7i_B()
{
  {
    init_simple_test("aBFu0i_BFu7i_B");
    static aBFu0i_BFu7i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0i_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0i_BFu7i_B");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu7i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu7i_B(Test_aBFu0i_BFu7i_B, "aBFu0i_BFu7i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu7ll_B()
{
  {
    init_simple_test("aBFu0i_BFu7ll_B");
    static aBFu0i_BFu7ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0i_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0i_BFu7ll_B");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu7ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu7ll_B(Test_aBFu0i_BFu7ll_B, "aBFu0i_BFu7ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu7s_B()
{
  {
    init_simple_test("aBFu0i_BFu7s_B");
    static aBFu0i_BFu7s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0i_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0i_BFu7s_B");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu7s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu7s_B(Test_aBFu0i_BFu7s_B, "aBFu0i_BFu7s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu8c_B()
{
  {
    init_simple_test("aBFu0i_BFu8c_B");
    static aBFu0i_BFu8c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0i_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0i_BFu8c_B");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu8c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu8c_B(Test_aBFu0i_BFu8c_B, "aBFu0i_BFu8c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu8i_B()
{
  {
    init_simple_test("aBFu0i_BFu8i_B");
    static aBFu0i_BFu8i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0i_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0i_BFu8i_B");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu8i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu8i_B(Test_aBFu0i_BFu8i_B, "aBFu0i_BFu8i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu8ll_B()
{
  {
    init_simple_test("aBFu0i_BFu8ll_B");
    static aBFu0i_BFu8ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0i_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0i_BFu8ll_B");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu8ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu8ll_B(Test_aBFu0i_BFu8ll_B, "aBFu0i_BFu8ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu8s_B()
{
  {
    init_simple_test("aBFu0i_BFu8s_B");
    static aBFu0i_BFu8s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0i_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0i_BFu8s_B");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu8s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu8s_B(Test_aBFu0i_BFu8s_B, "aBFu0i_BFu8s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu9i_B()
{
  {
    init_simple_test("aBFu0i_BFu9i_B");
    static aBFu0i_BFu9i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0i_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0i_BFu9i_B");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu9i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu9i_B(Test_aBFu0i_BFu9i_B, "aBFu0i_BFu9i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu9ll_B()
{
  {
    init_simple_test("aBFu0i_BFu9ll_B");
    static aBFu0i_BFu9ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0i_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0i_BFu9ll_B");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu9ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu9ll_B(Test_aBFu0i_BFu9ll_B, "aBFu0i_BFu9ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_BFu9s_B()
{
  {
    init_simple_test("aBFu0i_BFu9s_B");
    static aBFu0i_BFu9s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0i_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0i_BFu9s_B");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu9s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_BFu9s_B(Test_aBFu0i_BFu9s_B, "aBFu0i_BFu9s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_C_B()
{
  {
    init_simple_test("aBFu0i_C_B");
    static aBFu0i_C_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_C_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_C_B.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_C_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_C_B(Test_aBFu0i_C_B, "aBFu0i_C_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_D_B()
{
  {
    init_simple_test("aBFu0i_D_B");
    static aBFu0i_D_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0i_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_D_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_D_B.v1");
    check_field_offset(lv, v2, 8, "aBFu0i_D_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_D_B(Test_aBFu0i_D_B, "aBFu0i_D_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_F_B()
{
  {
    init_simple_test("aBFu0i_F_B");
    static aBFu0i_F_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_F_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_F_B.v1");
    check_field_offset(lv, v2, 4, "aBFu0i_F_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_F_B(Test_aBFu0i_F_B, "aBFu0i_F_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_I_B()
{
  {
    init_simple_test("aBFu0i_I_B");
    static aBFu0i_I_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_I_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_I_B.v1");
    check_field_offset(lv, v2, 4, "aBFu0i_I_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_I_B(Test_aBFu0i_I_B, "aBFu0i_I_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_Ip_B()
{
  {
    init_simple_test("aBFu0i_Ip_B");
    static aBFu0i_Ip_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0i_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Ip_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_Ip_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0i_Ip_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_Ip_B(Test_aBFu0i_Ip_B, "aBFu0i_Ip_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_L_B()
{
  {
    init_simple_test("aBFu0i_L_B");
    static aBFu0i_L_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0i_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_L_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_L_B.v1");
    check_field_offset(lv, v2, 8, "aBFu0i_L_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_L_B(Test_aBFu0i_L_B, "aBFu0i_L_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_S_B()
{
  {
    init_simple_test("aBFu0i_S_B");
    static aBFu0i_S_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_S_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_S_B.v1");
    check_field_offset(lv, v2, 2, "aBFu0i_S_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_S_B(Test_aBFu0i_S_B, "aBFu0i_S_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_Uc_B()
{
  {
    init_simple_test("aBFu0i_Uc_B");
    static aBFu0i_Uc_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Uc_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_Uc_B.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_Uc_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_Uc_B(Test_aBFu0i_Uc_B, "aBFu0i_Uc_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_Ui_B()
{
  {
    init_simple_test("aBFu0i_Ui_B");
    static aBFu0i_Ui_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Ui_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_Ui_B.v1");
    check_field_offset(lv, v2, 4, "aBFu0i_Ui_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_Ui_B(Test_aBFu0i_Ui_B, "aBFu0i_Ui_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_Ul_B()
{
  {
    init_simple_test("aBFu0i_Ul_B");
    static aBFu0i_Ul_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0i_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Ul_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_Ul_B.v1");
    check_field_offset(lv, v2, 8, "aBFu0i_Ul_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_Ul_B(Test_aBFu0i_Ul_B, "aBFu0i_Ul_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_Us_B()
{
  {
    init_simple_test("aBFu0i_Us_B");
    static aBFu0i_Us_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Us_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_Us_B.v1");
    check_field_offset(lv, v2, 2, "aBFu0i_Us_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_Us_B(Test_aBFu0i_Us_B, "aBFu0i_Us_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0i_Vp_B()
{
  {
    init_simple_test("aBFu0i_Vp_B");
    static aBFu0i_Vp_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0i_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Vp_B)");
    check_field_offset(lv, v1, 0, "aBFu0i_Vp_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0i_Vp_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0i_Vp_B(Test_aBFu0i_Vp_B, "aBFu0i_Vp_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B()
{
  {
    init_simple_test("aBFu0ll_B");
    static aBFu0ll_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B(Test_aBFu0ll_B, "aBFu0ll_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_B()
{
  {
    init_simple_test("aBFu0ll_B_B");
    static aBFu0ll_B_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_B.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_B_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_B(Test_aBFu0ll_B_B, "aBFu0ll_B_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu0c()
{
  {
    init_simple_test("aBFu0ll_B_BFu0c");
    static aBFu0ll_B_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu0c(Test_aBFu0ll_B_BFu0c, "aBFu0ll_B_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu0i()
{
  {
    init_simple_test("aBFu0ll_B_BFu0i");
    static aBFu0ll_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu0ll_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu0i(Test_aBFu0ll_B_BFu0i, "aBFu0ll_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu0ll()
{
  {
    init_simple_test("aBFu0ll_B_BFu0ll");
    static aBFu0ll_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0ll_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu0ll(Test_aBFu0ll_B_BFu0ll, "aBFu0ll_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu0s()
{
  {
    init_simple_test("aBFu0ll_B_BFu0s");
    static aBFu0ll_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu0ll_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu0s(Test_aBFu0ll_B_BFu0s, "aBFu0ll_B_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu15i()
{
  {
    init_simple_test("aBFu0ll_B_BFu15i");
    static aBFu0ll_B_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0ll_B_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0ll_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu15i(Test_aBFu0ll_B_BFu15i, "aBFu0ll_B_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu15ll()
{
  {
    init_simple_test("aBFu0ll_B_BFu15ll");
    static aBFu0ll_B_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0ll_B_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0ll_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu15ll(Test_aBFu0ll_B_BFu15ll, "aBFu0ll_B_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu15s()
{
  {
    init_simple_test("aBFu0ll_B_BFu15s");
    static aBFu0ll_B_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0ll_B_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0ll_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu15s(Test_aBFu0ll_B_BFu15s, "aBFu0ll_B_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu16i()
{
  {
    init_simple_test("aBFu0ll_B_BFu16i");
    static aBFu0ll_B_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0ll_B_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0ll_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu16i(Test_aBFu0ll_B_BFu16i, "aBFu0ll_B_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu16ll()
{
  {
    init_simple_test("aBFu0ll_B_BFu16ll");
    static aBFu0ll_B_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0ll_B_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0ll_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu16ll(Test_aBFu0ll_B_BFu16ll, "aBFu0ll_B_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu16s()
{
  {
    init_simple_test("aBFu0ll_B_BFu16s");
    static aBFu0ll_B_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0ll_B_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0ll_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu16s(Test_aBFu0ll_B_BFu16s, "aBFu0ll_B_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu17i()
{
  {
    init_simple_test("aBFu0ll_B_BFu17i");
    static aBFu0ll_B_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu0ll_B_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu0ll_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu17i(Test_aBFu0ll_B_BFu17i, "aBFu0ll_B_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu17ll()
{
  {
    init_simple_test("aBFu0ll_B_BFu17ll");
    static aBFu0ll_B_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu0ll_B_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu0ll_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu17ll(Test_aBFu0ll_B_BFu17ll, "aBFu0ll_B_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu1c()
{
  {
    init_simple_test("aBFu0ll_B_BFu1c");
    static aBFu0ll_B_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0ll_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu1c(Test_aBFu0ll_B_BFu1c, "aBFu0ll_B_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu1i()
{
  {
    init_simple_test("aBFu0ll_B_BFu1i");
    static aBFu0ll_B_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0ll_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu1i(Test_aBFu0ll_B_BFu1i, "aBFu0ll_B_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu1ll()
{
  {
    init_simple_test("aBFu0ll_B_BFu1ll");
    static aBFu0ll_B_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0ll_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu1ll(Test_aBFu0ll_B_BFu1ll, "aBFu0ll_B_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu1s()
{
  {
    init_simple_test("aBFu0ll_B_BFu1s");
    static aBFu0ll_B_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0ll_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu1s(Test_aBFu0ll_B_BFu1s, "aBFu0ll_B_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu31i()
{
  {
    init_simple_test("aBFu0ll_B_BFu31i");
    static aBFu0ll_B_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu0ll_B_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu0ll_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu31i(Test_aBFu0ll_B_BFu31i, "aBFu0ll_B_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu31ll()
{
  {
    init_simple_test("aBFu0ll_B_BFu31ll");
    static aBFu0ll_B_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu0ll_B_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu0ll_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu31ll(Test_aBFu0ll_B_BFu31ll, "aBFu0ll_B_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu32i()
{
  {
    init_simple_test("aBFu0ll_B_BFu32i");
    static aBFu0ll_B_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu0ll_B_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu0ll_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu32i(Test_aBFu0ll_B_BFu32i, "aBFu0ll_B_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu32ll()
{
  {
    init_simple_test("aBFu0ll_B_BFu32ll");
    static aBFu0ll_B_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu0ll_B_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu0ll_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu32ll(Test_aBFu0ll_B_BFu32ll, "aBFu0ll_B_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu33()
{
  {
    init_simple_test("aBFu0ll_B_BFu33");
    static aBFu0ll_B_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0ll_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aBFu0ll_B_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aBFu0ll_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu33(Test_aBFu0ll_B_BFu33, "aBFu0ll_B_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu7c()
{
  {
    init_simple_test("aBFu0ll_B_BFu7c");
    static aBFu0ll_B_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0ll_B_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0ll_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu7c(Test_aBFu0ll_B_BFu7c, "aBFu0ll_B_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu7i()
{
  {
    init_simple_test("aBFu0ll_B_BFu7i");
    static aBFu0ll_B_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0ll_B_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0ll_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu7i(Test_aBFu0ll_B_BFu7i, "aBFu0ll_B_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu7ll()
{
  {
    init_simple_test("aBFu0ll_B_BFu7ll");
    static aBFu0ll_B_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0ll_B_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0ll_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu7ll(Test_aBFu0ll_B_BFu7ll, "aBFu0ll_B_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu7s()
{
  {
    init_simple_test("aBFu0ll_B_BFu7s");
    static aBFu0ll_B_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0ll_B_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0ll_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu7s(Test_aBFu0ll_B_BFu7s, "aBFu0ll_B_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu8c()
{
  {
    init_simple_test("aBFu0ll_B_BFu8c");
    static aBFu0ll_B_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0ll_B_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0ll_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu8c(Test_aBFu0ll_B_BFu8c, "aBFu0ll_B_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu8i()
{
  {
    init_simple_test("aBFu0ll_B_BFu8i");
    static aBFu0ll_B_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0ll_B_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0ll_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu8i(Test_aBFu0ll_B_BFu8i, "aBFu0ll_B_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu8ll()
{
  {
    init_simple_test("aBFu0ll_B_BFu8ll");
    static aBFu0ll_B_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0ll_B_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0ll_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu8ll(Test_aBFu0ll_B_BFu8ll, "aBFu0ll_B_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu8s()
{
  {
    init_simple_test("aBFu0ll_B_BFu8s");
    static aBFu0ll_B_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0ll_B_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0ll_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu8s(Test_aBFu0ll_B_BFu8s, "aBFu0ll_B_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu9i()
{
  {
    init_simple_test("aBFu0ll_B_BFu9i");
    static aBFu0ll_B_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0ll_B_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0ll_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu9i(Test_aBFu0ll_B_BFu9i, "aBFu0ll_B_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu9ll()
{
  {
    init_simple_test("aBFu0ll_B_BFu9ll");
    static aBFu0ll_B_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0ll_B_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0ll_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu9ll(Test_aBFu0ll_B_BFu9ll, "aBFu0ll_B_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_BFu9s()
{
  {
    init_simple_test("aBFu0ll_B_BFu9s");
    static aBFu0ll_B_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0ll_B_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0ll_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_BFu9s(Test_aBFu0ll_B_BFu9s, "aBFu0ll_B_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_C()
{
  {
    init_simple_test("aBFu0ll_B_C");
    static aBFu0ll_B_C lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_C)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_C.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_B_C.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_C(Test_aBFu0ll_B_C, "aBFu0ll_B_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_D()
{
  {
    init_simple_test("aBFu0ll_B_D");
    static aBFu0ll_B_D lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0ll_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_D)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_D.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_B_D.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_D(Test_aBFu0ll_B_D, "aBFu0ll_B_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_F()
{
  {
    init_simple_test("aBFu0ll_B_F");
    static aBFu0ll_B_F lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_F)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_F.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_B_F.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_F(Test_aBFu0ll_B_F, "aBFu0ll_B_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_I()
{
  {
    init_simple_test("aBFu0ll_B_I");
    static aBFu0ll_B_I lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_I)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_I.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_B_I.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_I(Test_aBFu0ll_B_I, "aBFu0ll_B_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_Ip()
{
  {
    init_simple_test("aBFu0ll_B_Ip");
    static aBFu0ll_B_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0ll_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_Ip.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_B_Ip.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_Ip(Test_aBFu0ll_B_Ip, "aBFu0ll_B_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_L()
{
  {
    init_simple_test("aBFu0ll_B_L");
    static aBFu0ll_B_L lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0ll_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_L)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_L.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_B_L.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_L(Test_aBFu0ll_B_L, "aBFu0ll_B_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_S()
{
  {
    init_simple_test("aBFu0ll_B_S");
    static aBFu0ll_B_S lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_S)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_S.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_B_S.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_S(Test_aBFu0ll_B_S, "aBFu0ll_B_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_Uc()
{
  {
    init_simple_test("aBFu0ll_B_Uc");
    static aBFu0ll_B_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_Uc.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_B_Uc.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_Uc(Test_aBFu0ll_B_Uc, "aBFu0ll_B_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_Ui()
{
  {
    init_simple_test("aBFu0ll_B_Ui");
    static aBFu0ll_B_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_Ui.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_B_Ui.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_Ui(Test_aBFu0ll_B_Ui, "aBFu0ll_B_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_Ul()
{
  {
    init_simple_test("aBFu0ll_B_Ul");
    static aBFu0ll_B_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0ll_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_Ul.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_B_Ul.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_Ul(Test_aBFu0ll_B_Ul, "aBFu0ll_B_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_Us()
{
  {
    init_simple_test("aBFu0ll_B_Us");
    static aBFu0ll_B_Us lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_Us)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_Us.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_B_Us.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_Us(Test_aBFu0ll_B_Us, "aBFu0ll_B_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_B_Vp()
{
  {
    init_simple_test("aBFu0ll_B_Vp");
    static aBFu0ll_B_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0ll_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_B_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0ll_B_Vp.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_B_Vp.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_B_Vp(Test_aBFu0ll_B_Vp, "aBFu0ll_B_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu0c_B()
{
  {
    init_simple_test("aBFu0ll_BFu0c_B");
    static aBFu0ll_BFu0c_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_BFu0c_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu0c_B(Test_aBFu0ll_BFu0c_B, "aBFu0ll_BFu0c_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu0i_B()
{
  {
    init_simple_test("aBFu0ll_BFu0i_B");
    static aBFu0ll_BFu0i_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_BFu0i_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu0i_B(Test_aBFu0ll_BFu0i_B, "aBFu0ll_BFu0i_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu0ll_B()
{
  {
    init_simple_test("aBFu0ll_BFu0ll_B");
    static aBFu0ll_BFu0ll_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_BFu0ll_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu0ll_B(Test_aBFu0ll_BFu0ll_B, "aBFu0ll_BFu0ll_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu0s_B()
{
  {
    init_simple_test("aBFu0ll_BFu0s_B");
    static aBFu0ll_BFu0s_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_BFu0s_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu0s_B(Test_aBFu0ll_BFu0s_B, "aBFu0ll_BFu0s_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu15i_B()
{
  {
    init_simple_test("aBFu0ll_BFu15i_B");
    static aBFu0ll_BFu15i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0ll_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0ll_BFu15i_B");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu15i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu15i_B(Test_aBFu0ll_BFu15i_B, "aBFu0ll_BFu15i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu15ll_B()
{
  {
    init_simple_test("aBFu0ll_BFu15ll_B");
    static aBFu0ll_BFu15ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0ll_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0ll_BFu15ll_B");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu15ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu15ll_B(Test_aBFu0ll_BFu15ll_B, "aBFu0ll_BFu15ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu15s_B()
{
  {
    init_simple_test("aBFu0ll_BFu15s_B");
    static aBFu0ll_BFu15s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0ll_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0ll_BFu15s_B");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu15s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu15s_B(Test_aBFu0ll_BFu15s_B, "aBFu0ll_BFu15s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu16i_B()
{
  {
    init_simple_test("aBFu0ll_BFu16i_B");
    static aBFu0ll_BFu16i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0ll_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0ll_BFu16i_B");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu16i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu16i_B(Test_aBFu0ll_BFu16i_B, "aBFu0ll_BFu16i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu16ll_B()
{
  {
    init_simple_test("aBFu0ll_BFu16ll_B");
    static aBFu0ll_BFu16ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0ll_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0ll_BFu16ll_B");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu16ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu16ll_B(Test_aBFu0ll_BFu16ll_B, "aBFu0ll_BFu16ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu16s_B()
{
  {
    init_simple_test("aBFu0ll_BFu16s_B");
    static aBFu0ll_BFu16s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0ll_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0ll_BFu16s_B");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu16s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu16s_B(Test_aBFu0ll_BFu16s_B, "aBFu0ll_BFu16s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu17i_B()
{
  {
    init_simple_test("aBFu0ll_BFu17i_B");
    static aBFu0ll_BFu17i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0ll_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0ll_BFu17i_B");
    check_field_offset(lv, v2, 3, "aBFu0ll_BFu17i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu17i_B(Test_aBFu0ll_BFu17i_B, "aBFu0ll_BFu17i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu17ll_B()
{
  {
    init_simple_test("aBFu0ll_BFu17ll_B");
    static aBFu0ll_BFu17ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0ll_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0ll_BFu17ll_B");
    check_field_offset(lv, v2, 3, "aBFu0ll_BFu17ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu17ll_B(Test_aBFu0ll_BFu17ll_B, "aBFu0ll_BFu17ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu1c_B()
{
  {
    init_simple_test("aBFu0ll_BFu1c_B");
    static aBFu0ll_BFu1c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0ll_BFu1c_B");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu1c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu1c_B(Test_aBFu0ll_BFu1c_B, "aBFu0ll_BFu1c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu1i_B()
{
  {
    init_simple_test("aBFu0ll_BFu1i_B");
    static aBFu0ll_BFu1i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0ll_BFu1i_B");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu1i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu1i_B(Test_aBFu0ll_BFu1i_B, "aBFu0ll_BFu1i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu1ll_B()
{
  {
    init_simple_test("aBFu0ll_BFu1ll_B");
    static aBFu0ll_BFu1ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0ll_BFu1ll_B");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu1ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu1ll_B(Test_aBFu0ll_BFu1ll_B, "aBFu0ll_BFu1ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu1s_B()
{
  {
    init_simple_test("aBFu0ll_BFu1s_B");
    static aBFu0ll_BFu1s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0ll_BFu1s_B");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu1s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu1s_B(Test_aBFu0ll_BFu1s_B, "aBFu0ll_BFu1s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu31i_B()
{
  {
    init_simple_test("aBFu0ll_BFu31i_B");
    static aBFu0ll_BFu31i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0ll_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0ll_BFu31i_B");
    check_field_offset(lv, v2, 4, "aBFu0ll_BFu31i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu31i_B(Test_aBFu0ll_BFu31i_B, "aBFu0ll_BFu31i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu31ll_B()
{
  {
    init_simple_test("aBFu0ll_BFu31ll_B");
    static aBFu0ll_BFu31ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0ll_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0ll_BFu31ll_B");
    check_field_offset(lv, v2, 4, "aBFu0ll_BFu31ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu31ll_B(Test_aBFu0ll_BFu31ll_B, "aBFu0ll_BFu31ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu32i_B()
{
  {
    init_simple_test("aBFu0ll_BFu32i_B");
    static aBFu0ll_BFu32i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0ll_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0ll_BFu32i_B");
    check_field_offset(lv, v2, 4, "aBFu0ll_BFu32i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu32i_B(Test_aBFu0ll_BFu32i_B, "aBFu0ll_BFu32i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu32ll_B()
{
  {
    init_simple_test("aBFu0ll_BFu32ll_B");
    static aBFu0ll_BFu32ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0ll_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0ll_BFu32ll_B");
    check_field_offset(lv, v2, 4, "aBFu0ll_BFu32ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu32ll_B(Test_aBFu0ll_BFu32ll_B, "aBFu0ll_BFu32ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu33_B()
{
  {
    init_simple_test("aBFu0ll_BFu33_B");
    static aBFu0ll_BFu33_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0ll_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu0ll_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu0ll_BFu33_B");
    check_field_offset(lv, v2, 5, "aBFu0ll_BFu33_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu33_B(Test_aBFu0ll_BFu33_B, "aBFu0ll_BFu33_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu7c_B()
{
  {
    init_simple_test("aBFu0ll_BFu7c_B");
    static aBFu0ll_BFu7c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0ll_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0ll_BFu7c_B");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu7c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu7c_B(Test_aBFu0ll_BFu7c_B, "aBFu0ll_BFu7c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu7i_B()
{
  {
    init_simple_test("aBFu0ll_BFu7i_B");
    static aBFu0ll_BFu7i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0ll_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0ll_BFu7i_B");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu7i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu7i_B(Test_aBFu0ll_BFu7i_B, "aBFu0ll_BFu7i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu7ll_B()
{
  {
    init_simple_test("aBFu0ll_BFu7ll_B");
    static aBFu0ll_BFu7ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0ll_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0ll_BFu7ll_B");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu7ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu7ll_B(Test_aBFu0ll_BFu7ll_B, "aBFu0ll_BFu7ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu7s_B()
{
  {
    init_simple_test("aBFu0ll_BFu7s_B");
    static aBFu0ll_BFu7s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0ll_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0ll_BFu7s_B");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu7s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu7s_B(Test_aBFu0ll_BFu7s_B, "aBFu0ll_BFu7s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu8c_B()
{
  {
    init_simple_test("aBFu0ll_BFu8c_B");
    static aBFu0ll_BFu8c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0ll_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0ll_BFu8c_B");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu8c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu8c_B(Test_aBFu0ll_BFu8c_B, "aBFu0ll_BFu8c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu8i_B()
{
  {
    init_simple_test("aBFu0ll_BFu8i_B");
    static aBFu0ll_BFu8i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0ll_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0ll_BFu8i_B");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu8i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu8i_B(Test_aBFu0ll_BFu8i_B, "aBFu0ll_BFu8i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu8ll_B()
{
  {
    init_simple_test("aBFu0ll_BFu8ll_B");
    static aBFu0ll_BFu8ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0ll_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0ll_BFu8ll_B");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu8ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu8ll_B(Test_aBFu0ll_BFu8ll_B, "aBFu0ll_BFu8ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu8s_B()
{
  {
    init_simple_test("aBFu0ll_BFu8s_B");
    static aBFu0ll_BFu8s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0ll_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0ll_BFu8s_B");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu8s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu8s_B(Test_aBFu0ll_BFu8s_B, "aBFu0ll_BFu8s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu9i_B()
{
  {
    init_simple_test("aBFu0ll_BFu9i_B");
    static aBFu0ll_BFu9i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0ll_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0ll_BFu9i_B");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu9i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu9i_B(Test_aBFu0ll_BFu9i_B, "aBFu0ll_BFu9i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu9ll_B()
{
  {
    init_simple_test("aBFu0ll_BFu9ll_B");
    static aBFu0ll_BFu9ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0ll_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0ll_BFu9ll_B");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu9ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu9ll_B(Test_aBFu0ll_BFu9ll_B, "aBFu0ll_BFu9ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_BFu9s_B()
{
  {
    init_simple_test("aBFu0ll_BFu9s_B");
    static aBFu0ll_BFu9s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0ll_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0ll_BFu9s_B");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu9s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_BFu9s_B(Test_aBFu0ll_BFu9s_B, "aBFu0ll_BFu9s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_C_B()
{
  {
    init_simple_test("aBFu0ll_C_B");
    static aBFu0ll_C_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_C_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_C_B.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_C_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_C_B(Test_aBFu0ll_C_B, "aBFu0ll_C_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_D_B()
{
  {
    init_simple_test("aBFu0ll_D_B");
    static aBFu0ll_D_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0ll_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_D_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_D_B.v1");
    check_field_offset(lv, v2, 8, "aBFu0ll_D_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_D_B(Test_aBFu0ll_D_B, "aBFu0ll_D_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_F_B()
{
  {
    init_simple_test("aBFu0ll_F_B");
    static aBFu0ll_F_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_F_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_F_B.v1");
    check_field_offset(lv, v2, 4, "aBFu0ll_F_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_F_B(Test_aBFu0ll_F_B, "aBFu0ll_F_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_I_B()
{
  {
    init_simple_test("aBFu0ll_I_B");
    static aBFu0ll_I_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_I_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_I_B.v1");
    check_field_offset(lv, v2, 4, "aBFu0ll_I_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_I_B(Test_aBFu0ll_I_B, "aBFu0ll_I_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_Ip_B()
{
  {
    init_simple_test("aBFu0ll_Ip_B");
    static aBFu0ll_Ip_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0ll_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Ip_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Ip_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0ll_Ip_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_Ip_B(Test_aBFu0ll_Ip_B, "aBFu0ll_Ip_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_L_B()
{
  {
    init_simple_test("aBFu0ll_L_B");
    static aBFu0ll_L_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0ll_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_L_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_L_B.v1");
    check_field_offset(lv, v2, 8, "aBFu0ll_L_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_L_B(Test_aBFu0ll_L_B, "aBFu0ll_L_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_S_B()
{
  {
    init_simple_test("aBFu0ll_S_B");
    static aBFu0ll_S_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_S_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_S_B.v1");
    check_field_offset(lv, v2, 2, "aBFu0ll_S_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_S_B(Test_aBFu0ll_S_B, "aBFu0ll_S_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_Uc_B()
{
  {
    init_simple_test("aBFu0ll_Uc_B");
    static aBFu0ll_Uc_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Uc_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Uc_B.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_Uc_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_Uc_B(Test_aBFu0ll_Uc_B, "aBFu0ll_Uc_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_Ui_B()
{
  {
    init_simple_test("aBFu0ll_Ui_B");
    static aBFu0ll_Ui_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Ui_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Ui_B.v1");
    check_field_offset(lv, v2, 4, "aBFu0ll_Ui_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_Ui_B(Test_aBFu0ll_Ui_B, "aBFu0ll_Ui_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_Ul_B()
{
  {
    init_simple_test("aBFu0ll_Ul_B");
    static aBFu0ll_Ul_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0ll_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Ul_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Ul_B.v1");
    check_field_offset(lv, v2, 8, "aBFu0ll_Ul_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_Ul_B(Test_aBFu0ll_Ul_B, "aBFu0ll_Ul_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_Us_B()
{
  {
    init_simple_test("aBFu0ll_Us_B");
    static aBFu0ll_Us_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Us_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Us_B.v1");
    check_field_offset(lv, v2, 2, "aBFu0ll_Us_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_Us_B(Test_aBFu0ll_Us_B, "aBFu0ll_Us_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0ll_Vp_B()
{
  {
    init_simple_test("aBFu0ll_Vp_B");
    static aBFu0ll_Vp_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0ll_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Vp_B)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Vp_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0ll_Vp_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0ll_Vp_B(Test_aBFu0ll_Vp_B, "aBFu0ll_Vp_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B()
{
  {
    init_simple_test("aBFu0s_B");
    static aBFu0s_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0s_B(Test_aBFu0s_B, "aBFu0s_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_B()
{
  {
    init_simple_test("aBFu0s_B_B");
    static aBFu0s_B_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_B.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_B_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_B(Test_aBFu0s_B_B, "aBFu0s_B_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu0c()
{
  {
    init_simple_test("aBFu0s_B_BFu0c");
    static aBFu0s_B_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu0c(Test_aBFu0s_B_BFu0c, "aBFu0s_B_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu0i()
{
  {
    init_simple_test("aBFu0s_B_BFu0i");
    static aBFu0s_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu0s_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu0i(Test_aBFu0s_B_BFu0i, "aBFu0s_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu0ll()
{
  {
    init_simple_test("aBFu0s_B_BFu0ll");
    static aBFu0s_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu0ll(Test_aBFu0s_B_BFu0ll, "aBFu0s_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu0s()
{
  {
    init_simple_test("aBFu0s_B_BFu0s");
    static aBFu0s_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu0s_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu0s(Test_aBFu0s_B_BFu0s, "aBFu0s_B_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu15i()
{
  {
    init_simple_test("aBFu0s_B_BFu15i");
    static aBFu0s_B_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0s_B_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0s_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu15i(Test_aBFu0s_B_BFu15i, "aBFu0s_B_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu15ll()
{
  {
    init_simple_test("aBFu0s_B_BFu15ll");
    static aBFu0s_B_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0s_B_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0s_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu15ll(Test_aBFu0s_B_BFu15ll, "aBFu0s_B_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu15s()
{
  {
    init_simple_test("aBFu0s_B_BFu15s");
    static aBFu0s_B_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0s_B_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0s_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu15s(Test_aBFu0s_B_BFu15s, "aBFu0s_B_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu16i()
{
  {
    init_simple_test("aBFu0s_B_BFu16i");
    static aBFu0s_B_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0s_B_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0s_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu16i(Test_aBFu0s_B_BFu16i, "aBFu0s_B_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu16ll()
{
  {
    init_simple_test("aBFu0s_B_BFu16ll");
    static aBFu0s_B_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0s_B_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0s_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu16ll(Test_aBFu0s_B_BFu16ll, "aBFu0s_B_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu16s()
{
  {
    init_simple_test("aBFu0s_B_BFu16s");
    static aBFu0s_B_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0s_B_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0s_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu16s(Test_aBFu0s_B_BFu16s, "aBFu0s_B_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu17i()
{
  {
    init_simple_test("aBFu0s_B_BFu17i");
    static aBFu0s_B_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu0s_B_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu0s_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu17i(Test_aBFu0s_B_BFu17i, "aBFu0s_B_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu17ll()
{
  {
    init_simple_test("aBFu0s_B_BFu17ll");
    static aBFu0s_B_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu0s_B_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu0s_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu17ll(Test_aBFu0s_B_BFu17ll, "aBFu0s_B_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu1c()
{
  {
    init_simple_test("aBFu0s_B_BFu1c");
    static aBFu0s_B_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0s_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu1c(Test_aBFu0s_B_BFu1c, "aBFu0s_B_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu1i()
{
  {
    init_simple_test("aBFu0s_B_BFu1i");
    static aBFu0s_B_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0s_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu1i(Test_aBFu0s_B_BFu1i, "aBFu0s_B_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu1ll()
{
  {
    init_simple_test("aBFu0s_B_BFu1ll");
    static aBFu0s_B_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0s_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu1ll(Test_aBFu0s_B_BFu1ll, "aBFu0s_B_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu1s()
{
  {
    init_simple_test("aBFu0s_B_BFu1s");
    static aBFu0s_B_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0s_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu1s(Test_aBFu0s_B_BFu1s, "aBFu0s_B_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu31i()
{
  {
    init_simple_test("aBFu0s_B_BFu31i");
    static aBFu0s_B_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu0s_B_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu0s_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu31i(Test_aBFu0s_B_BFu31i, "aBFu0s_B_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu31ll()
{
  {
    init_simple_test("aBFu0s_B_BFu31ll");
    static aBFu0s_B_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu0s_B_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu0s_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu31ll(Test_aBFu0s_B_BFu31ll, "aBFu0s_B_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu32i()
{
  {
    init_simple_test("aBFu0s_B_BFu32i");
    static aBFu0s_B_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu0s_B_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu0s_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu32i(Test_aBFu0s_B_BFu32i, "aBFu0s_B_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu32ll()
{
  {
    init_simple_test("aBFu0s_B_BFu32ll");
    static aBFu0s_B_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu0s_B_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu0s_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu32ll(Test_aBFu0s_B_BFu32ll, "aBFu0s_B_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu33()
{
  {
    init_simple_test("aBFu0s_B_BFu33");
    static aBFu0s_B_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aBFu0s_B_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aBFu0s_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu33(Test_aBFu0s_B_BFu33, "aBFu0s_B_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu7c()
{
  {
    init_simple_test("aBFu0s_B_BFu7c");
    static aBFu0s_B_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0s_B_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0s_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu7c(Test_aBFu0s_B_BFu7c, "aBFu0s_B_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu7i()
{
  {
    init_simple_test("aBFu0s_B_BFu7i");
    static aBFu0s_B_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0s_B_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0s_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu7i(Test_aBFu0s_B_BFu7i, "aBFu0s_B_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu7ll()
{
  {
    init_simple_test("aBFu0s_B_BFu7ll");
    static aBFu0s_B_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0s_B_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0s_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu7ll(Test_aBFu0s_B_BFu7ll, "aBFu0s_B_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu7s()
{
  {
    init_simple_test("aBFu0s_B_BFu7s");
    static aBFu0s_B_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0s_B_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0s_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu7s(Test_aBFu0s_B_BFu7s, "aBFu0s_B_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu8c()
{
  {
    init_simple_test("aBFu0s_B_BFu8c");
    static aBFu0s_B_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0s_B_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0s_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu8c(Test_aBFu0s_B_BFu8c, "aBFu0s_B_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu8i()
{
  {
    init_simple_test("aBFu0s_B_BFu8i");
    static aBFu0s_B_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0s_B_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0s_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu8i(Test_aBFu0s_B_BFu8i, "aBFu0s_B_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu8ll()
{
  {
    init_simple_test("aBFu0s_B_BFu8ll");
    static aBFu0s_B_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0s_B_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0s_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu8ll(Test_aBFu0s_B_BFu8ll, "aBFu0s_B_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu8s()
{
  {
    init_simple_test("aBFu0s_B_BFu8s");
    static aBFu0s_B_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0s_B_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0s_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu8s(Test_aBFu0s_B_BFu8s, "aBFu0s_B_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu9i()
{
  {
    init_simple_test("aBFu0s_B_BFu9i");
    static aBFu0s_B_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0s_B_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0s_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu9i(Test_aBFu0s_B_BFu9i, "aBFu0s_B_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu9ll()
{
  {
    init_simple_test("aBFu0s_B_BFu9ll");
    static aBFu0s_B_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0s_B_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0s_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu9ll(Test_aBFu0s_B_BFu9ll, "aBFu0s_B_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_BFu9s()
{
  {
    init_simple_test("aBFu0s_B_BFu9s");
    static aBFu0s_B_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0s_B_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0s_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_BFu9s(Test_aBFu0s_B_BFu9s, "aBFu0s_B_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_C()
{
  {
    init_simple_test("aBFu0s_B_C");
    static aBFu0s_B_C lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_C.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_B_C.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_C(Test_aBFu0s_B_C, "aBFu0s_B_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_D()
{
  {
    init_simple_test("aBFu0s_B_D");
    static aBFu0s_B_D lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_D.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_B_D.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_D(Test_aBFu0s_B_D, "aBFu0s_B_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_F()
{
  {
    init_simple_test("aBFu0s_B_F");
    static aBFu0s_B_F lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_F.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_B_F.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_F(Test_aBFu0s_B_F, "aBFu0s_B_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_I()
{
  {
    init_simple_test("aBFu0s_B_I");
    static aBFu0s_B_I lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_I.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_B_I.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_I(Test_aBFu0s_B_I, "aBFu0s_B_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_Ip()
{
  {
    init_simple_test("aBFu0s_B_Ip");
    static aBFu0s_B_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_Ip.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_B_Ip.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_Ip(Test_aBFu0s_B_Ip, "aBFu0s_B_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_L()
{
  {
    init_simple_test("aBFu0s_B_L");
    static aBFu0s_B_L lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_L.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_B_L.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_L(Test_aBFu0s_B_L, "aBFu0s_B_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_S()
{
  {
    init_simple_test("aBFu0s_B_S");
    static aBFu0s_B_S lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_S.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_B_S.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_S(Test_aBFu0s_B_S, "aBFu0s_B_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_Uc()
{
  {
    init_simple_test("aBFu0s_B_Uc");
    static aBFu0s_B_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_Uc.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_B_Uc.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_Uc(Test_aBFu0s_B_Uc, "aBFu0s_B_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_Ui()
{
  {
    init_simple_test("aBFu0s_B_Ui");
    static aBFu0s_B_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_Ui.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_B_Ui.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_Ui(Test_aBFu0s_B_Ui, "aBFu0s_B_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_Ul()
{
  {
    init_simple_test("aBFu0s_B_Ul");
    static aBFu0s_B_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_Ul.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_B_Ul.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_Ul(Test_aBFu0s_B_Ul, "aBFu0s_B_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_Us()
{
  {
    init_simple_test("aBFu0s_B_Us");
    static aBFu0s_B_Us lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_Us.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_B_Us.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_Us(Test_aBFu0s_B_Us, "aBFu0s_B_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_B_Vp()
{
  {
    init_simple_test("aBFu0s_B_Vp");
    static aBFu0s_B_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_B_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_B_Vp.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_B_Vp.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_B_Vp(Test_aBFu0s_B_Vp, "aBFu0s_B_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu0c_B()
{
  {
    init_simple_test("aBFu0s_BFu0c_B");
    static aBFu0s_BFu0c_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_BFu0c_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu0c_B(Test_aBFu0s_BFu0c_B, "aBFu0s_BFu0c_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu0i_B()
{
  {
    init_simple_test("aBFu0s_BFu0i_B");
    static aBFu0s_BFu0i_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_BFu0i_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu0i_B(Test_aBFu0s_BFu0i_B, "aBFu0s_BFu0i_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu0ll_B()
{
  {
    init_simple_test("aBFu0s_BFu0ll_B");
    static aBFu0s_BFu0ll_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_BFu0ll_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu0ll_B(Test_aBFu0s_BFu0ll_B, "aBFu0s_BFu0ll_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu0s_B()
{
  {
    init_simple_test("aBFu0s_BFu0s_B");
    static aBFu0s_BFu0s_B lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_BFu0s_B.v1");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu0s_B(Test_aBFu0s_BFu0s_B, "aBFu0s_BFu0s_B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu15i_B()
{
  {
    init_simple_test("aBFu0s_BFu15i_B");
    static aBFu0s_BFu15i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0s_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0s_BFu15i_B");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu15i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu15i_B(Test_aBFu0s_BFu15i_B, "aBFu0s_BFu15i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu15ll_B()
{
  {
    init_simple_test("aBFu0s_BFu15ll_B");
    static aBFu0s_BFu15ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0s_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0s_BFu15ll_B");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu15ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu15ll_B(Test_aBFu0s_BFu15ll_B, "aBFu0s_BFu15ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu15s_B()
{
  {
    init_simple_test("aBFu0s_BFu15s_B");
    static aBFu0s_BFu15s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0s_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0s_BFu15s_B");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu15s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu15s_B(Test_aBFu0s_BFu15s_B, "aBFu0s_BFu15s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu16i_B()
{
  {
    init_simple_test("aBFu0s_BFu16i_B");
    static aBFu0s_BFu16i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0s_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0s_BFu16i_B");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu16i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu16i_B(Test_aBFu0s_BFu16i_B, "aBFu0s_BFu16i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu16ll_B()
{
  {
    init_simple_test("aBFu0s_BFu16ll_B");
    static aBFu0s_BFu16ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0s_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0s_BFu16ll_B");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu16ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu16ll_B(Test_aBFu0s_BFu16ll_B, "aBFu0s_BFu16ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu16s_B()
{
  {
    init_simple_test("aBFu0s_BFu16s_B");
    static aBFu0s_BFu16s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0s_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0s_BFu16s_B");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu16s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu16s_B(Test_aBFu0s_BFu16s_B, "aBFu0s_BFu16s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu17i_B()
{
  {
    init_simple_test("aBFu0s_BFu17i_B");
    static aBFu0s_BFu17i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0s_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0s_BFu17i_B");
    check_field_offset(lv, v2, 3, "aBFu0s_BFu17i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu17i_B(Test_aBFu0s_BFu17i_B, "aBFu0s_BFu17i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu17ll_B()
{
  {
    init_simple_test("aBFu0s_BFu17ll_B");
    static aBFu0s_BFu17ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0s_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0s_BFu17ll_B");
    check_field_offset(lv, v2, 3, "aBFu0s_BFu17ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu17ll_B(Test_aBFu0s_BFu17ll_B, "aBFu0s_BFu17ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu1c_B()
{
  {
    init_simple_test("aBFu0s_BFu1c_B");
    static aBFu0s_BFu1c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0s_BFu1c_B");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu1c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu1c_B(Test_aBFu0s_BFu1c_B, "aBFu0s_BFu1c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu1i_B()
{
  {
    init_simple_test("aBFu0s_BFu1i_B");
    static aBFu0s_BFu1i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0s_BFu1i_B");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu1i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu1i_B(Test_aBFu0s_BFu1i_B, "aBFu0s_BFu1i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu1ll_B()
{
  {
    init_simple_test("aBFu0s_BFu1ll_B");
    static aBFu0s_BFu1ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0s_BFu1ll_B");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu1ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu1ll_B(Test_aBFu0s_BFu1ll_B, "aBFu0s_BFu1ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu1s_B()
{
  {
    init_simple_test("aBFu0s_BFu1s_B");
    static aBFu0s_BFu1s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0s_BFu1s_B");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu1s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu1s_B(Test_aBFu0s_BFu1s_B, "aBFu0s_BFu1s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu31i_B()
{
  {
    init_simple_test("aBFu0s_BFu31i_B");
    static aBFu0s_BFu31i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0s_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0s_BFu31i_B");
    check_field_offset(lv, v2, 4, "aBFu0s_BFu31i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu31i_B(Test_aBFu0s_BFu31i_B, "aBFu0s_BFu31i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu31ll_B()
{
  {
    init_simple_test("aBFu0s_BFu31ll_B");
    static aBFu0s_BFu31ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0s_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0s_BFu31ll_B");
    check_field_offset(lv, v2, 4, "aBFu0s_BFu31ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu31ll_B(Test_aBFu0s_BFu31ll_B, "aBFu0s_BFu31ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu32i_B()
{
  {
    init_simple_test("aBFu0s_BFu32i_B");
    static aBFu0s_BFu32i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0s_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0s_BFu32i_B");
    check_field_offset(lv, v2, 4, "aBFu0s_BFu32i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu32i_B(Test_aBFu0s_BFu32i_B, "aBFu0s_BFu32i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu32ll_B()
{
  {
    init_simple_test("aBFu0s_BFu32ll_B");
    static aBFu0s_BFu32ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0s_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0s_BFu32ll_B");
    check_field_offset(lv, v2, 4, "aBFu0s_BFu32ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu32ll_B(Test_aBFu0s_BFu32ll_B, "aBFu0s_BFu32ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu33_B()
{
  {
    init_simple_test("aBFu0s_BFu33_B");
    static aBFu0s_BFu33_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu0s_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu0s_BFu33_B");
    check_field_offset(lv, v2, 5, "aBFu0s_BFu33_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu33_B(Test_aBFu0s_BFu33_B, "aBFu0s_BFu33_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu7c_B()
{
  {
    init_simple_test("aBFu0s_BFu7c_B");
    static aBFu0s_BFu7c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0s_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0s_BFu7c_B");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu7c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu7c_B(Test_aBFu0s_BFu7c_B, "aBFu0s_BFu7c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu7i_B()
{
  {
    init_simple_test("aBFu0s_BFu7i_B");
    static aBFu0s_BFu7i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0s_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0s_BFu7i_B");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu7i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu7i_B(Test_aBFu0s_BFu7i_B, "aBFu0s_BFu7i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu7ll_B()
{
  {
    init_simple_test("aBFu0s_BFu7ll_B");
    static aBFu0s_BFu7ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0s_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0s_BFu7ll_B");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu7ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu7ll_B(Test_aBFu0s_BFu7ll_B, "aBFu0s_BFu7ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu7s_B()
{
  {
    init_simple_test("aBFu0s_BFu7s_B");
    static aBFu0s_BFu7s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0s_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0s_BFu7s_B");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu7s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu7s_B(Test_aBFu0s_BFu7s_B, "aBFu0s_BFu7s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu8c_B()
{
  {
    init_simple_test("aBFu0s_BFu8c_B");
    static aBFu0s_BFu8c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0s_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0s_BFu8c_B");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu8c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu8c_B(Test_aBFu0s_BFu8c_B, "aBFu0s_BFu8c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu8i_B()
{
  {
    init_simple_test("aBFu0s_BFu8i_B");
    static aBFu0s_BFu8i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0s_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0s_BFu8i_B");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu8i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu8i_B(Test_aBFu0s_BFu8i_B, "aBFu0s_BFu8i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu8ll_B()
{
  {
    init_simple_test("aBFu0s_BFu8ll_B");
    static aBFu0s_BFu8ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0s_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0s_BFu8ll_B");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu8ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu8ll_B(Test_aBFu0s_BFu8ll_B, "aBFu0s_BFu8ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu8s_B()
{
  {
    init_simple_test("aBFu0s_BFu8s_B");
    static aBFu0s_BFu8s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0s_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0s_BFu8s_B");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu8s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu8s_B(Test_aBFu0s_BFu8s_B, "aBFu0s_BFu8s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu9i_B()
{
  {
    init_simple_test("aBFu0s_BFu9i_B");
    static aBFu0s_BFu9i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0s_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0s_BFu9i_B");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu9i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu9i_B(Test_aBFu0s_BFu9i_B, "aBFu0s_BFu9i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu9ll_B()
{
  {
    init_simple_test("aBFu0s_BFu9ll_B");
    static aBFu0s_BFu9ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0s_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0s_BFu9ll_B");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu9ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu9ll_B(Test_aBFu0s_BFu9ll_B, "aBFu0s_BFu9ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_BFu9s_B()
{
  {
    init_simple_test("aBFu0s_BFu9s_B");
    static aBFu0s_BFu9s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0s_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0s_BFu9s_B");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu9s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_BFu9s_B(Test_aBFu0s_BFu9s_B, "aBFu0s_BFu9s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_C_B()
{
  {
    init_simple_test("aBFu0s_C_B");
    static aBFu0s_C_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_B.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_C_B(Test_aBFu0s_C_B, "aBFu0s_C_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_D_B()
{
  {
    init_simple_test("aBFu0s_D_B");
    static aBFu0s_D_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_B.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_D_B(Test_aBFu0s_D_B, "aBFu0s_D_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_F_B()
{
  {
    init_simple_test("aBFu0s_F_B");
    static aBFu0s_F_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_B.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_F_B(Test_aBFu0s_F_B, "aBFu0s_F_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_I_B()
{
  {
    init_simple_test("aBFu0s_I_B");
    static aBFu0s_I_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_B.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_I_B(Test_aBFu0s_I_B, "aBFu0s_I_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_Ip_B()
{
  {
    init_simple_test("aBFu0s_Ip_B");
    static aBFu0s_Ip_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_Ip_B(Test_aBFu0s_Ip_B, "aBFu0s_Ip_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_L_B()
{
  {
    init_simple_test("aBFu0s_L_B");
    static aBFu0s_L_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_B.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_L_B(Test_aBFu0s_L_B, "aBFu0s_L_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_S_B()
{
  {
    init_simple_test("aBFu0s_S_B");
    static aBFu0s_S_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_B.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_S_B(Test_aBFu0s_S_B, "aBFu0s_S_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_Uc_B()
{
  {
    init_simple_test("aBFu0s_Uc_B");
    static aBFu0s_Uc_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_B.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_Uc_B(Test_aBFu0s_Uc_B, "aBFu0s_Uc_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_Ui_B()
{
  {
    init_simple_test("aBFu0s_Ui_B");
    static aBFu0s_Ui_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_B.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_Ui_B(Test_aBFu0s_Ui_B, "aBFu0s_Ui_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_Ul_B()
{
  {
    init_simple_test("aBFu0s_Ul_B");
    static aBFu0s_Ul_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_B.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_Ul_B(Test_aBFu0s_Ul_B, "aBFu0s_Ul_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_Us_B()
{
  {
    init_simple_test("aBFu0s_Us_B");
    static aBFu0s_Us_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_B.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_Us_B(Test_aBFu0s_Us_B, "aBFu0s_Us_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu0s_Vp_B()
{
  {
    init_simple_test("aBFu0s_Vp_B");
    static aBFu0s_Vp_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_B)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu0s_Vp_B(Test_aBFu0s_Vp_B, "aBFu0s_Vp_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15i_B_BFu0c()
{
  {
    init_simple_test("aBFu15i_B_BFu0c");
    static aBFu15i_B_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_B_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu15i_B_BFu0c(Test_aBFu15i_B_BFu0c, "aBFu15i_B_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15i_B_BFu0i()
{
  {
    init_simple_test("aBFu15i_B_BFu0i");
    static aBFu15i_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_B_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu15i_B_BFu0i(Test_aBFu15i_B_BFu0i, "aBFu15i_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15i_B_BFu0ll()
{
  {
    init_simple_test("aBFu15i_B_BFu0ll");
    static aBFu15i_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_B_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu15i_B_BFu0ll(Test_aBFu15i_B_BFu0ll, "aBFu15i_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15i_B_BFu0s()
{
  {
    init_simple_test("aBFu15i_B_BFu0s");
    static aBFu15i_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_B_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu15i_B_BFu0s(Test_aBFu15i_B_BFu0s, "aBFu15i_B_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15i_BFu0c_B()
{
  {
    init_simple_test("aBFu15i_BFu0c_B");
    static aBFu15i_BFu0c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_B");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu15i_BFu0c_B(Test_aBFu15i_BFu0c_B, "aBFu15i_BFu0c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15i_BFu0i_B()
{
  {
    init_simple_test("aBFu15i_BFu0i_B");
    static aBFu15i_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu15i_BFu0i_B(Test_aBFu15i_BFu0i_B, "aBFu15i_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15i_BFu0ll_B()
{
  {
    init_simple_test("aBFu15i_BFu0ll_B");
    static aBFu15i_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu15i_BFu0ll_B(Test_aBFu15i_BFu0ll_B, "aBFu15i_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15i_BFu0s_B()
{
  {
    init_simple_test("aBFu15i_BFu0s_B");
    static aBFu15i_BFu0s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_B");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu15i_BFu0s_B(Test_aBFu15i_BFu0s_B, "aBFu15i_BFu0s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15ll_B_BFu0c()
{
  {
    init_simple_test("aBFu15ll_B_BFu0c");
    static aBFu15ll_B_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_B_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15ll_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu15ll_B_BFu0c(Test_aBFu15ll_B_BFu0c, "aBFu15ll_B_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15ll_B_BFu0i()
{
  {
    init_simple_test("aBFu15ll_B_BFu0i");
    static aBFu15ll_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_B_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15ll_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu15ll_B_BFu0i(Test_aBFu15ll_B_BFu0i, "aBFu15ll_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15ll_B_BFu0ll()
{
  {
    init_simple_test("aBFu15ll_B_BFu0ll");
    static aBFu15ll_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_B_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15ll_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu15ll_B_BFu0ll(Test_aBFu15ll_B_BFu0ll, "aBFu15ll_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15ll_B_BFu0s()
{
  {
    init_simple_test("aBFu15ll_B_BFu0s");
    static aBFu15ll_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_B_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15ll_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu15ll_B_BFu0s(Test_aBFu15ll_B_BFu0s, "aBFu15ll_B_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15ll_BFu0c_B()
{
  {
    init_simple_test("aBFu15ll_BFu0c_B");
    static aBFu15ll_BFu0c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_B");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu15ll_BFu0c_B(Test_aBFu15ll_BFu0c_B, "aBFu15ll_BFu0c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15ll_BFu0i_B()
{
  {
    init_simple_test("aBFu15ll_BFu0i_B");
    static aBFu15ll_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu15ll_BFu0i_B(Test_aBFu15ll_BFu0i_B, "aBFu15ll_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15ll_BFu0ll_B()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_B");
    static aBFu15ll_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu15ll_BFu0ll_B(Test_aBFu15ll_BFu0ll_B, "aBFu15ll_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15ll_BFu0s_B()
{
  {
    init_simple_test("aBFu15ll_BFu0s_B");
    static aBFu15ll_BFu0s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_B");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu15ll_BFu0s_B(Test_aBFu15ll_BFu0s_B, "aBFu15ll_BFu0s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15s_B_BFu0c()
{
  {
    init_simple_test("aBFu15s_B_BFu0c");
    static aBFu15s_B_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_B_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15s_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu15s_B_BFu0c(Test_aBFu15s_B_BFu0c, "aBFu15s_B_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15s_B_BFu0i()
{
  {
    init_simple_test("aBFu15s_B_BFu0i");
    static aBFu15s_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15s_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_B_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15s_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu15s_B_BFu0i(Test_aBFu15s_B_BFu0i, "aBFu15s_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15s_B_BFu0ll()
{
  {
    init_simple_test("aBFu15s_B_BFu0ll");
    static aBFu15s_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15s_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_B_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15s_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu15s_B_BFu0ll(Test_aBFu15s_B_BFu0ll, "aBFu15s_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15s_B_BFu0s()
{
  {
    init_simple_test("aBFu15s_B_BFu0s");
    static aBFu15s_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15s_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_B_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15s_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu15s_B_BFu0s(Test_aBFu15s_B_BFu0s, "aBFu15s_B_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15s_BFu0c_B()
{
  {
    init_simple_test("aBFu15s_BFu0c_B");
    static aBFu15s_BFu0c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu0c_B");
    check_field_offset(lv, v2, 2, "aBFu15s_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu15s_BFu0c_B(Test_aBFu15s_BFu0c_B, "aBFu15s_BFu0c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15s_BFu0i_B()
{
  {
    init_simple_test("aBFu15s_BFu0i_B");
    static aBFu15s_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15s_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15s_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu15s_BFu0i_B(Test_aBFu15s_BFu0i_B, "aBFu15s_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15s_BFu0ll_B()
{
  {
    init_simple_test("aBFu15s_BFu0ll_B");
    static aBFu15s_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15s_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15s_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu15s_BFu0ll_B(Test_aBFu15s_BFu0ll_B, "aBFu15s_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu15s_BFu0s_B()
{
  {
    init_simple_test("aBFu15s_BFu0s_B");
    static aBFu15s_BFu0s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu0s_B");
    check_field_offset(lv, v2, 2, "aBFu15s_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu15s_BFu0s_B(Test_aBFu15s_BFu0s_B, "aBFu15s_BFu0s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16i_B_BFu0c()
{
  {
    init_simple_test("aBFu16i_B_BFu0c");
    static aBFu16i_B_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_B_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu16i_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu16i_B_BFu0c(Test_aBFu16i_B_BFu0c, "aBFu16i_B_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16i_B_BFu0i()
{
  {
    init_simple_test("aBFu16i_B_BFu0i");
    static aBFu16i_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu16i_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_B_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu16i_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu16i_B_BFu0i(Test_aBFu16i_B_BFu0i, "aBFu16i_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16i_B_BFu0ll()
{
  {
    init_simple_test("aBFu16i_B_BFu0ll");
    static aBFu16i_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu16i_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_B_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu16i_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu16i_B_BFu0ll(Test_aBFu16i_B_BFu0ll, "aBFu16i_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16i_B_BFu0s()
{
  {
    init_simple_test("aBFu16i_B_BFu0s");
    static aBFu16i_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu16i_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_B_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu16i_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu16i_B_BFu0s(Test_aBFu16i_B_BFu0s, "aBFu16i_B_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16i_BFu0c_B()
{
  {
    init_simple_test("aBFu16i_BFu0c_B");
    static aBFu16i_BFu0c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu0c_B");
    check_field_offset(lv, v2, 2, "aBFu16i_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu16i_BFu0c_B(Test_aBFu16i_BFu0c_B, "aBFu16i_BFu0c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16i_BFu0i_B()
{
  {
    init_simple_test("aBFu16i_BFu0i_B");
    static aBFu16i_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu16i_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu16i_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu16i_BFu0i_B(Test_aBFu16i_BFu0i_B, "aBFu16i_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16i_BFu0ll_B()
{
  {
    init_simple_test("aBFu16i_BFu0ll_B");
    static aBFu16i_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu16i_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu16i_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu16i_BFu0ll_B(Test_aBFu16i_BFu0ll_B, "aBFu16i_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16i_BFu0s_B()
{
  {
    init_simple_test("aBFu16i_BFu0s_B");
    static aBFu16i_BFu0s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu0s_B");
    check_field_offset(lv, v2, 2, "aBFu16i_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu16i_BFu0s_B(Test_aBFu16i_BFu0s_B, "aBFu16i_BFu0s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16ll_B_BFu0c()
{
  {
    init_simple_test("aBFu16ll_B_BFu0c");
    static aBFu16ll_B_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_B_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu16ll_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu16ll_B_BFu0c(Test_aBFu16ll_B_BFu0c, "aBFu16ll_B_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16ll_B_BFu0i()
{
  {
    init_simple_test("aBFu16ll_B_BFu0i");
    static aBFu16ll_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu16ll_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_B_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu16ll_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu16ll_B_BFu0i(Test_aBFu16ll_B_BFu0i, "aBFu16ll_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16ll_B_BFu0ll()
{
  {
    init_simple_test("aBFu16ll_B_BFu0ll");
    static aBFu16ll_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu16ll_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_B_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu16ll_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu16ll_B_BFu0ll(Test_aBFu16ll_B_BFu0ll, "aBFu16ll_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16ll_B_BFu0s()
{
  {
    init_simple_test("aBFu16ll_B_BFu0s");
    static aBFu16ll_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu16ll_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_B_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu16ll_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu16ll_B_BFu0s(Test_aBFu16ll_B_BFu0s, "aBFu16ll_B_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16ll_BFu0c_B()
{
  {
    init_simple_test("aBFu16ll_BFu0c_B");
    static aBFu16ll_BFu0c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu0c_B");
    check_field_offset(lv, v2, 2, "aBFu16ll_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu16ll_BFu0c_B(Test_aBFu16ll_BFu0c_B, "aBFu16ll_BFu0c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16ll_BFu0i_B()
{
  {
    init_simple_test("aBFu16ll_BFu0i_B");
    static aBFu16ll_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu16ll_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu16ll_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu16ll_BFu0i_B(Test_aBFu16ll_BFu0i_B, "aBFu16ll_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16ll_BFu0ll_B()
{
  {
    init_simple_test("aBFu16ll_BFu0ll_B");
    static aBFu16ll_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu16ll_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu16ll_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu16ll_BFu0ll_B(Test_aBFu16ll_BFu0ll_B, "aBFu16ll_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16ll_BFu0s_B()
{
  {
    init_simple_test("aBFu16ll_BFu0s_B");
    static aBFu16ll_BFu0s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu0s_B");
    check_field_offset(lv, v2, 2, "aBFu16ll_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu16ll_BFu0s_B(Test_aBFu16ll_BFu0s_B, "aBFu16ll_BFu0s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16s_B_BFu0c()
{
  {
    init_simple_test("aBFu16s_B_BFu0c");
    static aBFu16s_B_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_B_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu16s_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu16s_B_BFu0c(Test_aBFu16s_B_BFu0c, "aBFu16s_B_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16s_B_BFu0i()
{
  {
    init_simple_test("aBFu16s_B_BFu0i");
    static aBFu16s_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu16s_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_B_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu16s_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu16s_B_BFu0i(Test_aBFu16s_B_BFu0i, "aBFu16s_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16s_B_BFu0ll()
{
  {
    init_simple_test("aBFu16s_B_BFu0ll");
    static aBFu16s_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu16s_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_B_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu16s_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu16s_B_BFu0ll(Test_aBFu16s_B_BFu0ll, "aBFu16s_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16s_B_BFu0s()
{
  {
    init_simple_test("aBFu16s_B_BFu0s");
    static aBFu16s_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu16s_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_B_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu16s_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu16s_B_BFu0s(Test_aBFu16s_B_BFu0s, "aBFu16s_B_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16s_BFu0c_B()
{
  {
    init_simple_test("aBFu16s_BFu0c_B");
    static aBFu16s_BFu0c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu0c_B");
    check_field_offset(lv, v2, 2, "aBFu16s_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu16s_BFu0c_B(Test_aBFu16s_BFu0c_B, "aBFu16s_BFu0c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16s_BFu0i_B()
{
  {
    init_simple_test("aBFu16s_BFu0i_B");
    static aBFu16s_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu16s_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu16s_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu16s_BFu0i_B(Test_aBFu16s_BFu0i_B, "aBFu16s_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16s_BFu0ll_B()
{
  {
    init_simple_test("aBFu16s_BFu0ll_B");
    static aBFu16s_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu16s_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu16s_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu16s_BFu0ll_B(Test_aBFu16s_BFu0ll_B, "aBFu16s_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu16s_BFu0s_B()
{
  {
    init_simple_test("aBFu16s_BFu0s_B");
    static aBFu16s_BFu0s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu0s_B");
    check_field_offset(lv, v2, 2, "aBFu16s_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu16s_BFu0s_B(Test_aBFu16s_BFu0s_B, "aBFu16s_BFu0s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17i_B_BFu0c()
{
  {
    init_simple_test("aBFu17i_B_BFu0c");
    static aBFu17i_B_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_B_BFu0c");
    check_field_offset(lv, v2, 3, "aBFu17i_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu17i_B_BFu0c(Test_aBFu17i_B_BFu0c, "aBFu17i_B_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17i_B_BFu0i()
{
  {
    init_simple_test("aBFu17i_B_BFu0i");
    static aBFu17i_B_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_B_BFu0i");
    check_field_offset(lv, v2, 3, "aBFu17i_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu17i_B_BFu0i(Test_aBFu17i_B_BFu0i, "aBFu17i_B_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17i_B_BFu0ll()
{
  {
    init_simple_test("aBFu17i_B_BFu0ll");
    static aBFu17i_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu17i_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_B_BFu0ll");
    check_field_offset(lv, v2, 3, "aBFu17i_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu17i_B_BFu0ll(Test_aBFu17i_B_BFu0ll, "aBFu17i_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17i_B_BFu0s()
{
  {
    init_simple_test("aBFu17i_B_BFu0s");
    static aBFu17i_B_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_B_BFu0s");
    check_field_offset(lv, v2, 3, "aBFu17i_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu17i_B_BFu0s(Test_aBFu17i_B_BFu0s, "aBFu17i_B_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17i_BFu0c_B()
{
  {
    init_simple_test("aBFu17i_BFu0c_B");
    static aBFu17i_BFu0c_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu0c_B");
    check_field_offset(lv, v2, 3, "aBFu17i_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu17i_BFu0c_B(Test_aBFu17i_BFu0c_B, "aBFu17i_BFu0c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17i_BFu0i_B()
{
  {
    init_simple_test("aBFu17i_BFu0i_B");
    static aBFu17i_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu17i_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu17i_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu17i_BFu0i_B(Test_aBFu17i_BFu0i_B, "aBFu17i_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17i_BFu0ll_B()
{
  {
    init_simple_test("aBFu17i_BFu0ll_B");
    static aBFu17i_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu17i_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu17i_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu17i_BFu0ll_B(Test_aBFu17i_BFu0ll_B, "aBFu17i_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17i_BFu0s_B()
{
  {
    init_simple_test("aBFu17i_BFu0s_B");
    static aBFu17i_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu17i_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu17i_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu17i_BFu0s_B(Test_aBFu17i_BFu0s_B, "aBFu17i_BFu0s_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17ll_B_BFu0c()
{
  {
    init_simple_test("aBFu17ll_B_BFu0c");
    static aBFu17ll_B_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_B_BFu0c");
    check_field_offset(lv, v2, 3, "aBFu17ll_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu17ll_B_BFu0c(Test_aBFu17ll_B_BFu0c, "aBFu17ll_B_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17ll_B_BFu0i()
{
  {
    init_simple_test("aBFu17ll_B_BFu0i");
    static aBFu17ll_B_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_B_BFu0i");
    check_field_offset(lv, v2, 3, "aBFu17ll_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu17ll_B_BFu0i(Test_aBFu17ll_B_BFu0i, "aBFu17ll_B_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17ll_B_BFu0ll()
{
  {
    init_simple_test("aBFu17ll_B_BFu0ll");
    static aBFu17ll_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu17ll_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_B_BFu0ll");
    check_field_offset(lv, v2, 3, "aBFu17ll_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu17ll_B_BFu0ll(Test_aBFu17ll_B_BFu0ll, "aBFu17ll_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17ll_B_BFu0s()
{
  {
    init_simple_test("aBFu17ll_B_BFu0s");
    static aBFu17ll_B_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_B_BFu0s");
    check_field_offset(lv, v2, 3, "aBFu17ll_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu17ll_B_BFu0s(Test_aBFu17ll_B_BFu0s, "aBFu17ll_B_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17ll_BFu0c_B()
{
  {
    init_simple_test("aBFu17ll_BFu0c_B");
    static aBFu17ll_BFu0c_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu0c_B");
    check_field_offset(lv, v2, 3, "aBFu17ll_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu17ll_BFu0c_B(Test_aBFu17ll_BFu0c_B, "aBFu17ll_BFu0c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17ll_BFu0i_B()
{
  {
    init_simple_test("aBFu17ll_BFu0i_B");
    static aBFu17ll_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu17ll_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu17ll_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu17ll_BFu0i_B(Test_aBFu17ll_BFu0i_B, "aBFu17ll_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17ll_BFu0ll_B()
{
  {
    init_simple_test("aBFu17ll_BFu0ll_B");
    static aBFu17ll_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu17ll_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu17ll_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu17ll_BFu0ll_B(Test_aBFu17ll_BFu0ll_B, "aBFu17ll_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu17ll_BFu0s_B()
{
  {
    init_simple_test("aBFu17ll_BFu0s_B");
    static aBFu17ll_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu17ll_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu17ll_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu17ll_BFu0s_B(Test_aBFu17ll_BFu0s_B, "aBFu17ll_BFu0s_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1c_B_BFu0c()
{
  {
    init_simple_test("aBFu1c_B_BFu0c");
    static aBFu1c_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_B_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu1c_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu1c_B_BFu0c(Test_aBFu1c_B_BFu0c, "aBFu1c_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1c_B_BFu0i()
{
  {
    init_simple_test("aBFu1c_B_BFu0i");
    static aBFu1c_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu1c_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_B_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu1c_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu1c_B_BFu0i(Test_aBFu1c_B_BFu0i, "aBFu1c_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1c_B_BFu0ll()
{
  {
    init_simple_test("aBFu1c_B_BFu0ll");
    static aBFu1c_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu1c_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_B_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu1c_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu1c_B_BFu0ll(Test_aBFu1c_B_BFu0ll, "aBFu1c_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1c_B_BFu0s()
{
  {
    init_simple_test("aBFu1c_B_BFu0s");
    static aBFu1c_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_B_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu1c_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu1c_B_BFu0s(Test_aBFu1c_B_BFu0s, "aBFu1c_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1c_BFu0c_B()
{
  {
    init_simple_test("aBFu1c_BFu0c_B");
    static aBFu1c_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu0c_B");
    check_field_offset(lv, v2, 1, "aBFu1c_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1c_BFu0c_B(Test_aBFu1c_BFu0c_B, "aBFu1c_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1c_BFu0i_B()
{
  {
    init_simple_test("aBFu1c_BFu0i_B");
    static aBFu1c_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu1c_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu1c_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1c_BFu0i_B(Test_aBFu1c_BFu0i_B, "aBFu1c_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1c_BFu0ll_B()
{
  {
    init_simple_test("aBFu1c_BFu0ll_B");
    static aBFu1c_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1c_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu1c_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1c_BFu0ll_B(Test_aBFu1c_BFu0ll_B, "aBFu1c_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1c_BFu0s_B()
{
  {
    init_simple_test("aBFu1c_BFu0s_B");
    static aBFu1c_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu1c_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu1c_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1c_BFu0s_B(Test_aBFu1c_BFu0s_B, "aBFu1c_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1i_B_BFu0c()
{
  {
    init_simple_test("aBFu1i_B_BFu0c");
    static aBFu1i_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_B_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu1i_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu1i_B_BFu0c(Test_aBFu1i_B_BFu0c, "aBFu1i_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1i_B_BFu0i()
{
  {
    init_simple_test("aBFu1i_B_BFu0i");
    static aBFu1i_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu1i_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_B_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu1i_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu1i_B_BFu0i(Test_aBFu1i_B_BFu0i, "aBFu1i_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1i_B_BFu0ll()
{
  {
    init_simple_test("aBFu1i_B_BFu0ll");
    static aBFu1i_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu1i_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_B_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu1i_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu1i_B_BFu0ll(Test_aBFu1i_B_BFu0ll, "aBFu1i_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1i_B_BFu0s()
{
  {
    init_simple_test("aBFu1i_B_BFu0s");
    static aBFu1i_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_B_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu1i_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu1i_B_BFu0s(Test_aBFu1i_B_BFu0s, "aBFu1i_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1i_BFu0c_B()
{
  {
    init_simple_test("aBFu1i_BFu0c_B");
    static aBFu1i_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu0c_B");
    check_field_offset(lv, v2, 1, "aBFu1i_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1i_BFu0c_B(Test_aBFu1i_BFu0c_B, "aBFu1i_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1i_BFu0i_B()
{
  {
    init_simple_test("aBFu1i_BFu0i_B");
    static aBFu1i_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu1i_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu1i_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1i_BFu0i_B(Test_aBFu1i_BFu0i_B, "aBFu1i_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1i_BFu0ll_B()
{
  {
    init_simple_test("aBFu1i_BFu0ll_B");
    static aBFu1i_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1i_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu1i_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1i_BFu0ll_B(Test_aBFu1i_BFu0ll_B, "aBFu1i_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1i_BFu0s_B()
{
  {
    init_simple_test("aBFu1i_BFu0s_B");
    static aBFu1i_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu1i_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu1i_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1i_BFu0s_B(Test_aBFu1i_BFu0s_B, "aBFu1i_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1ll_B_BFu0c()
{
  {
    init_simple_test("aBFu1ll_B_BFu0c");
    static aBFu1ll_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_B_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu1ll_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu1ll_B_BFu0c(Test_aBFu1ll_B_BFu0c, "aBFu1ll_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1ll_B_BFu0i()
{
  {
    init_simple_test("aBFu1ll_B_BFu0i");
    static aBFu1ll_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu1ll_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_B_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu1ll_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu1ll_B_BFu0i(Test_aBFu1ll_B_BFu0i, "aBFu1ll_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1ll_B_BFu0ll()
{
  {
    init_simple_test("aBFu1ll_B_BFu0ll");
    static aBFu1ll_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu1ll_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_B_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu1ll_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu1ll_B_BFu0ll(Test_aBFu1ll_B_BFu0ll, "aBFu1ll_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1ll_B_BFu0s()
{
  {
    init_simple_test("aBFu1ll_B_BFu0s");
    static aBFu1ll_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_B_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu1ll_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu1ll_B_BFu0s(Test_aBFu1ll_B_BFu0s, "aBFu1ll_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1ll_BFu0c_B()
{
  {
    init_simple_test("aBFu1ll_BFu0c_B");
    static aBFu1ll_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu0c_B");
    check_field_offset(lv, v2, 1, "aBFu1ll_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1ll_BFu0c_B(Test_aBFu1ll_BFu0c_B, "aBFu1ll_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1ll_BFu0i_B()
{
  {
    init_simple_test("aBFu1ll_BFu0i_B");
    static aBFu1ll_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu1ll_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu1ll_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1ll_BFu0i_B(Test_aBFu1ll_BFu0i_B, "aBFu1ll_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1ll_BFu0ll_B()
{
  {
    init_simple_test("aBFu1ll_BFu0ll_B");
    static aBFu1ll_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1ll_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu1ll_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1ll_BFu0ll_B(Test_aBFu1ll_BFu0ll_B, "aBFu1ll_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1ll_BFu0s_B()
{
  {
    init_simple_test("aBFu1ll_BFu0s_B");
    static aBFu1ll_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu1ll_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu1ll_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1ll_BFu0s_B(Test_aBFu1ll_BFu0s_B, "aBFu1ll_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1s_B_BFu0c()
{
  {
    init_simple_test("aBFu1s_B_BFu0c");
    static aBFu1s_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_B_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu1s_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu1s_B_BFu0c(Test_aBFu1s_B_BFu0c, "aBFu1s_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1s_B_BFu0i()
{
  {
    init_simple_test("aBFu1s_B_BFu0i");
    static aBFu1s_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu1s_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_B_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu1s_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu1s_B_BFu0i(Test_aBFu1s_B_BFu0i, "aBFu1s_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1s_B_BFu0ll()
{
  {
    init_simple_test("aBFu1s_B_BFu0ll");
    static aBFu1s_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu1s_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_B_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu1s_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu1s_B_BFu0ll(Test_aBFu1s_B_BFu0ll, "aBFu1s_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1s_B_BFu0s()
{
  {
    init_simple_test("aBFu1s_B_BFu0s");
    static aBFu1s_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_B_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu1s_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu1s_B_BFu0s(Test_aBFu1s_B_BFu0s, "aBFu1s_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1s_BFu0c_B()
{
  {
    init_simple_test("aBFu1s_BFu0c_B");
    static aBFu1s_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu0c_B");
    check_field_offset(lv, v2, 1, "aBFu1s_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1s_BFu0c_B(Test_aBFu1s_BFu0c_B, "aBFu1s_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1s_BFu0i_B()
{
  {
    init_simple_test("aBFu1s_BFu0i_B");
    static aBFu1s_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu1s_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu1s_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1s_BFu0i_B(Test_aBFu1s_BFu0i_B, "aBFu1s_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1s_BFu0ll_B()
{
  {
    init_simple_test("aBFu1s_BFu0ll_B");
    static aBFu1s_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1s_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu1s_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1s_BFu0ll_B(Test_aBFu1s_BFu0ll_B, "aBFu1s_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu1s_BFu0s_B()
{
  {
    init_simple_test("aBFu1s_BFu0s_B");
    static aBFu1s_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu1s_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu1s_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu1s_BFu0s_B(Test_aBFu1s_BFu0s_B, "aBFu1s_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31i_B_BFu0c()
{
  {
    init_simple_test("aBFu31i_B_BFu0c");
    static aBFu31i_B_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_B_BFu0c");
    check_field_offset(lv, v2, 4, "aBFu31i_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu31i_B_BFu0c(Test_aBFu31i_B_BFu0c, "aBFu31i_B_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31i_B_BFu0i()
{
  {
    init_simple_test("aBFu31i_B_BFu0i");
    static aBFu31i_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu31i_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_B_BFu0i");
    check_field_offset(lv, v2, 4, "aBFu31i_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu31i_B_BFu0i(Test_aBFu31i_B_BFu0i, "aBFu31i_B_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31i_B_BFu0ll()
{
  {
    init_simple_test("aBFu31i_B_BFu0ll");
    static aBFu31i_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu31i_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_B_BFu0ll");
    check_field_offset(lv, v2, 4, "aBFu31i_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu31i_B_BFu0ll(Test_aBFu31i_B_BFu0ll, "aBFu31i_B_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31i_B_BFu0s()
{
  {
    init_simple_test("aBFu31i_B_BFu0s");
    static aBFu31i_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu31i_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_B_BFu0s");
    check_field_offset(lv, v2, 4, "aBFu31i_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu31i_B_BFu0s(Test_aBFu31i_B_BFu0s, "aBFu31i_B_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31i_BFu0c_B()
{
  {
    init_simple_test("aBFu31i_BFu0c_B");
    static aBFu31i_BFu0c_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu0c_B");
    check_field_offset(lv, v2, 4, "aBFu31i_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu31i_BFu0c_B(Test_aBFu31i_BFu0c_B, "aBFu31i_BFu0c_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31i_BFu0i_B()
{
  {
    init_simple_test("aBFu31i_BFu0i_B");
    static aBFu31i_BFu0i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu0i_B");
    check_field_offset(lv, v2, 4, "aBFu31i_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu31i_BFu0i_B(Test_aBFu31i_BFu0i_B, "aBFu31i_BFu0i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31i_BFu0ll_B()
{
  {
    init_simple_test("aBFu31i_BFu0ll_B");
    static aBFu31i_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu31i_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu31i_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu31i_BFu0ll_B(Test_aBFu31i_BFu0ll_B, "aBFu31i_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31i_BFu0s_B()
{
  {
    init_simple_test("aBFu31i_BFu0s_B");
    static aBFu31i_BFu0s_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu0s_B");
    check_field_offset(lv, v2, 4, "aBFu31i_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu31i_BFu0s_B(Test_aBFu31i_BFu0s_B, "aBFu31i_BFu0s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31ll_B_BFu0c()
{
  {
    init_simple_test("aBFu31ll_B_BFu0c");
    static aBFu31ll_B_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31ll_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_B_BFu0c");
    check_field_offset(lv, v2, 4, "aBFu31ll_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu31ll_B_BFu0c(Test_aBFu31ll_B_BFu0c, "aBFu31ll_B_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31ll_B_BFu0i()
{
  {
    init_simple_test("aBFu31ll_B_BFu0i");
    static aBFu31ll_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu31ll_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_B_BFu0i");
    check_field_offset(lv, v2, 4, "aBFu31ll_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu31ll_B_BFu0i(Test_aBFu31ll_B_BFu0i, "aBFu31ll_B_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31ll_B_BFu0ll()
{
  {
    init_simple_test("aBFu31ll_B_BFu0ll");
    static aBFu31ll_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu31ll_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_B_BFu0ll");
    check_field_offset(lv, v2, 4, "aBFu31ll_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu31ll_B_BFu0ll(Test_aBFu31ll_B_BFu0ll, "aBFu31ll_B_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31ll_B_BFu0s()
{
  {
    init_simple_test("aBFu31ll_B_BFu0s");
    static aBFu31ll_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu31ll_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_B_BFu0s");
    check_field_offset(lv, v2, 4, "aBFu31ll_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu31ll_B_BFu0s(Test_aBFu31ll_B_BFu0s, "aBFu31ll_B_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31ll_BFu0c_B()
{
  {
    init_simple_test("aBFu31ll_BFu0c_B");
    static aBFu31ll_BFu0c_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31ll_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_BFu0c_B");
    check_field_offset(lv, v2, 4, "aBFu31ll_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu31ll_BFu0c_B(Test_aBFu31ll_BFu0c_B, "aBFu31ll_BFu0c_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31ll_BFu0i_B()
{
  {
    init_simple_test("aBFu31ll_BFu0i_B");
    static aBFu31ll_BFu0i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31ll_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_BFu0i_B");
    check_field_offset(lv, v2, 4, "aBFu31ll_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu31ll_BFu0i_B(Test_aBFu31ll_BFu0i_B, "aBFu31ll_BFu0i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31ll_BFu0ll_B()
{
  {
    init_simple_test("aBFu31ll_BFu0ll_B");
    static aBFu31ll_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu31ll_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu31ll_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu31ll_BFu0ll_B(Test_aBFu31ll_BFu0ll_B, "aBFu31ll_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu31ll_BFu0s_B()
{
  {
    init_simple_test("aBFu31ll_BFu0s_B");
    static aBFu31ll_BFu0s_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31ll_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_BFu0s_B");
    check_field_offset(lv, v2, 4, "aBFu31ll_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu31ll_BFu0s_B(Test_aBFu31ll_BFu0s_B, "aBFu31ll_BFu0s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32i_B_BFu0c()
{
  {
    init_simple_test("aBFu32i_B_BFu0c");
    static aBFu32i_B_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu32i_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_B_BFu0c");
    check_field_offset(lv, v2, 4, "aBFu32i_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu32i_B_BFu0c(Test_aBFu32i_B_BFu0c, "aBFu32i_B_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32i_B_BFu0i()
{
  {
    init_simple_test("aBFu32i_B_BFu0i");
    static aBFu32i_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu32i_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_B_BFu0i");
    check_field_offset(lv, v2, 4, "aBFu32i_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu32i_B_BFu0i(Test_aBFu32i_B_BFu0i, "aBFu32i_B_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32i_B_BFu0ll()
{
  {
    init_simple_test("aBFu32i_B_BFu0ll");
    static aBFu32i_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu32i_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_B_BFu0ll");
    check_field_offset(lv, v2, 4, "aBFu32i_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu32i_B_BFu0ll(Test_aBFu32i_B_BFu0ll, "aBFu32i_B_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32i_B_BFu0s()
{
  {
    init_simple_test("aBFu32i_B_BFu0s");
    static aBFu32i_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu32i_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_B_BFu0s");
    check_field_offset(lv, v2, 4, "aBFu32i_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu32i_B_BFu0s(Test_aBFu32i_B_BFu0s, "aBFu32i_B_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32i_BFu0c_B()
{
  {
    init_simple_test("aBFu32i_BFu0c_B");
    static aBFu32i_BFu0c_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu32i_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_BFu0c_B");
    check_field_offset(lv, v2, 4, "aBFu32i_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu32i_BFu0c_B(Test_aBFu32i_BFu0c_B, "aBFu32i_BFu0c_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32i_BFu0i_B()
{
  {
    init_simple_test("aBFu32i_BFu0i_B");
    static aBFu32i_BFu0i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu32i_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_BFu0i_B");
    check_field_offset(lv, v2, 4, "aBFu32i_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu32i_BFu0i_B(Test_aBFu32i_BFu0i_B, "aBFu32i_BFu0i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32i_BFu0ll_B()
{
  {
    init_simple_test("aBFu32i_BFu0ll_B");
    static aBFu32i_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu32i_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu32i_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu32i_BFu0ll_B(Test_aBFu32i_BFu0ll_B, "aBFu32i_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32i_BFu0s_B()
{
  {
    init_simple_test("aBFu32i_BFu0s_B");
    static aBFu32i_BFu0s_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu32i_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_BFu0s_B");
    check_field_offset(lv, v2, 4, "aBFu32i_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu32i_BFu0s_B(Test_aBFu32i_BFu0s_B, "aBFu32i_BFu0s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_B_BFu0c()
{
  {
    init_simple_test("aBFu32ll_B_BFu0c");
    static aBFu32ll_B_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu32ll_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_B_BFu0c");
    check_field_offset(lv, v2, 4, "aBFu32ll_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu32ll_B_BFu0c(Test_aBFu32ll_B_BFu0c, "aBFu32ll_B_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_B_BFu0i()
{
  {
    init_simple_test("aBFu32ll_B_BFu0i");
    static aBFu32ll_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu32ll_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_B_BFu0i");
    check_field_offset(lv, v2, 4, "aBFu32ll_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu32ll_B_BFu0i(Test_aBFu32ll_B_BFu0i, "aBFu32ll_B_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_B_BFu0ll()
{
  {
    init_simple_test("aBFu32ll_B_BFu0ll");
    static aBFu32ll_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu32ll_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_B_BFu0ll");
    check_field_offset(lv, v2, 4, "aBFu32ll_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu32ll_B_BFu0ll(Test_aBFu32ll_B_BFu0ll, "aBFu32ll_B_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_B_BFu0s()
{
  {
    init_simple_test("aBFu32ll_B_BFu0s");
    static aBFu32ll_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu32ll_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_B_BFu0s");
    check_field_offset(lv, v2, 4, "aBFu32ll_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu32ll_B_BFu0s(Test_aBFu32ll_B_BFu0s, "aBFu32ll_B_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu0c_B()
{
  {
    init_simple_test("aBFu32ll_BFu0c_B");
    static aBFu32ll_BFu0c_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu32ll_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu0c_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu0c_B(Test_aBFu32ll_BFu0c_B, "aBFu32ll_BFu0c_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu0i_B()
{
  {
    init_simple_test("aBFu32ll_BFu0i_B");
    static aBFu32ll_BFu0i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu32ll_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu0i_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu0i_B(Test_aBFu32ll_BFu0i_B, "aBFu32ll_BFu0i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu0ll_B()
{
  {
    init_simple_test("aBFu32ll_BFu0ll_B");
    static aBFu32ll_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu32ll_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu32ll_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu0ll_B(Test_aBFu32ll_BFu0ll_B, "aBFu32ll_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu0s_B()
{
  {
    init_simple_test("aBFu32ll_BFu0s_B");
    static aBFu32ll_BFu0s_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu32ll_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu0s_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu0s_B(Test_aBFu32ll_BFu0s_B, "aBFu32ll_BFu0s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu0c()
{
  {
    init_simple_test("aBFu33_B_BFu0c");
    static aBFu33_B_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu33_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu0c");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu0c(Test_aBFu33_B_BFu0c, "aBFu33_B_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu0i()
{
  {
    init_simple_test("aBFu33_B_BFu0i");
    static aBFu33_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu33_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu0i");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu0i(Test_aBFu33_B_BFu0i, "aBFu33_B_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu0ll()
{
  {
    init_simple_test("aBFu33_B_BFu0ll");
    static aBFu33_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu33_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu0ll");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu0ll(Test_aBFu33_B_BFu0ll, "aBFu33_B_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu0s()
{
  {
    init_simple_test("aBFu33_B_BFu0s");
    static aBFu33_B_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu33_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu0s");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu0s(Test_aBFu33_B_BFu0s, "aBFu33_B_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu0c_B()
{
  {
    init_simple_test("aBFu33_BFu0c_B");
    static aBFu33_BFu0c_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu33_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu0c_B");
    check_field_offset(lv, v2, 5, "aBFu33_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu0c_B(Test_aBFu33_BFu0c_B, "aBFu33_BFu0c_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu0i_B()
{
  {
    init_simple_test("aBFu33_BFu0i_B");
    static aBFu33_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(9,9), "sizeof(aBFu33_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(8,8), "aBFu33_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu0i_B(Test_aBFu33_BFu0i_B, "aBFu33_BFu0i_B", ABISELECT(9,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu0ll_B()
{
  {
    init_simple_test("aBFu33_BFu0ll_B");
    static aBFu33_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,9), "sizeof(aBFu33_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,8), "aBFu33_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu0ll_B(Test_aBFu33_BFu0ll_B, "aBFu33_BFu0ll_B", ABISELECT(9,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu0s_B()
{
  {
    init_simple_test("aBFu33_BFu0s_B");
    static aBFu33_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aBFu33_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(6,6), "aBFu33_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu0s_B(Test_aBFu33_BFu0s_B, "aBFu33_BFu0s_B", ABISELECT(7,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu0c()
{
  {
    init_simple_test("aBFu7c_B_BFu0c");
    static aBFu7c_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7c_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu0c(Test_aBFu7c_B_BFu0c, "aBFu7c_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu0i()
{
  {
    init_simple_test("aBFu7c_B_BFu0i");
    static aBFu7c_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu7c_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu0i(Test_aBFu7c_B_BFu0i, "aBFu7c_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu0ll()
{
  {
    init_simple_test("aBFu7c_B_BFu0ll");
    static aBFu7c_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu7c_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu0ll(Test_aBFu7c_B_BFu0ll, "aBFu7c_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu0s()
{
  {
    init_simple_test("aBFu7c_B_BFu0s");
    static aBFu7c_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7c_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu0s(Test_aBFu7c_B_BFu0s, "aBFu7c_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu0c_B()
{
  {
    init_simple_test("aBFu7c_BFu0c_B");
    static aBFu7c_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7c_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu0c_B");
    check_field_offset(lv, v2, 1, "aBFu7c_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu0c_B(Test_aBFu7c_BFu0c_B, "aBFu7c_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu0i_B()
{
  {
    init_simple_test("aBFu7c_BFu0i_B");
    static aBFu7c_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu7c_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu7c_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu0i_B(Test_aBFu7c_BFu0i_B, "aBFu7c_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu0ll_B()
{
  {
    init_simple_test("aBFu7c_BFu0ll_B");
    static aBFu7c_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu7c_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu7c_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu0ll_B(Test_aBFu7c_BFu0ll_B, "aBFu7c_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu0s_B()
{
  {
    init_simple_test("aBFu7c_BFu0s_B");
    static aBFu7c_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu7c_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu7c_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu0s_B(Test_aBFu7c_BFu0s_B, "aBFu7c_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu0c()
{
  {
    init_simple_test("aBFu7i_B_BFu0c");
    static aBFu7i_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7i_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu0c(Test_aBFu7i_B_BFu0c, "aBFu7i_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu0i()
{
  {
    init_simple_test("aBFu7i_B_BFu0i");
    static aBFu7i_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu7i_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu0i(Test_aBFu7i_B_BFu0i, "aBFu7i_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu0ll()
{
  {
    init_simple_test("aBFu7i_B_BFu0ll");
    static aBFu7i_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu7i_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu0ll(Test_aBFu7i_B_BFu0ll, "aBFu7i_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu0s()
{
  {
    init_simple_test("aBFu7i_B_BFu0s");
    static aBFu7i_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7i_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu0s(Test_aBFu7i_B_BFu0s, "aBFu7i_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu0c_B()
{
  {
    init_simple_test("aBFu7i_BFu0c_B");
    static aBFu7i_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7i_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu0c_B");
    check_field_offset(lv, v2, 1, "aBFu7i_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu0c_B(Test_aBFu7i_BFu0c_B, "aBFu7i_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu0i_B()
{
  {
    init_simple_test("aBFu7i_BFu0i_B");
    static aBFu7i_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu7i_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu7i_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu0i_B(Test_aBFu7i_BFu0i_B, "aBFu7i_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu0ll_B()
{
  {
    init_simple_test("aBFu7i_BFu0ll_B");
    static aBFu7i_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu7i_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu7i_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu0ll_B(Test_aBFu7i_BFu0ll_B, "aBFu7i_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu0s_B()
{
  {
    init_simple_test("aBFu7i_BFu0s_B");
    static aBFu7i_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu7i_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu7i_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu0s_B(Test_aBFu7i_BFu0s_B, "aBFu7i_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu0c()
{
  {
    init_simple_test("aBFu7ll_B_BFu0c");
    static aBFu7ll_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7ll_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu0c(Test_aBFu7ll_B_BFu0c, "aBFu7ll_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu0i()
{
  {
    init_simple_test("aBFu7ll_B_BFu0i");
    static aBFu7ll_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu7ll_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu0i(Test_aBFu7ll_B_BFu0i, "aBFu7ll_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu0ll()
{
  {
    init_simple_test("aBFu7ll_B_BFu0ll");
    static aBFu7ll_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu7ll_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu0ll(Test_aBFu7ll_B_BFu0ll, "aBFu7ll_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu0s()
{
  {
    init_simple_test("aBFu7ll_B_BFu0s");
    static aBFu7ll_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7ll_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu0s(Test_aBFu7ll_B_BFu0s, "aBFu7ll_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu0c_B()
{
  {
    init_simple_test("aBFu7ll_BFu0c_B");
    static aBFu7ll_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7ll_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu0c_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu0c_B(Test_aBFu7ll_BFu0c_B, "aBFu7ll_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu0i_B()
{
  {
    init_simple_test("aBFu7ll_BFu0i_B");
    static aBFu7ll_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu7ll_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu7ll_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu0i_B(Test_aBFu7ll_BFu0i_B, "aBFu7ll_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu0ll_B()
{
  {
    init_simple_test("aBFu7ll_BFu0ll_B");
    static aBFu7ll_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu7ll_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu7ll_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu0ll_B(Test_aBFu7ll_BFu0ll_B, "aBFu7ll_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu0s_B()
{
  {
    init_simple_test("aBFu7ll_BFu0s_B");
    static aBFu7ll_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu7ll_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu7ll_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu0s_B(Test_aBFu7ll_BFu0s_B, "aBFu7ll_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu0c()
{
  {
    init_simple_test("aBFu7s_B_BFu0c");
    static aBFu7s_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7s_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu0c(Test_aBFu7s_B_BFu0c, "aBFu7s_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu0i()
{
  {
    init_simple_test("aBFu7s_B_BFu0i");
    static aBFu7s_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu7s_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu0i(Test_aBFu7s_B_BFu0i, "aBFu7s_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu0ll()
{
  {
    init_simple_test("aBFu7s_B_BFu0ll");
    static aBFu7s_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu7s_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu0ll(Test_aBFu7s_B_BFu0ll, "aBFu7s_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu0s()
{
  {
    init_simple_test("aBFu7s_B_BFu0s");
    static aBFu7s_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7s_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu0s(Test_aBFu7s_B_BFu0s, "aBFu7s_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu0c_B()
{
  {
    init_simple_test("aBFu7s_BFu0c_B");
    static aBFu7s_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7s_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu0c_B");
    check_field_offset(lv, v2, 1, "aBFu7s_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu0c_B(Test_aBFu7s_BFu0c_B, "aBFu7s_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu0i_B()
{
  {
    init_simple_test("aBFu7s_BFu0i_B");
    static aBFu7s_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu7s_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu7s_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu0i_B(Test_aBFu7s_BFu0i_B, "aBFu7s_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu0ll_B()
{
  {
    init_simple_test("aBFu7s_BFu0ll_B");
    static aBFu7s_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu7s_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu7s_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu0ll_B(Test_aBFu7s_BFu0ll_B, "aBFu7s_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu0s_B()
{
  {
    init_simple_test("aBFu7s_BFu0s_B");
    static aBFu7s_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu7s_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu7s_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu0s_B(Test_aBFu7s_BFu0s_B, "aBFu7s_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu0c()
{
  {
    init_simple_test("aBFu8c_B_BFu0c");
    static aBFu8c_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8c_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu0c(Test_aBFu8c_B_BFu0c, "aBFu8c_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu0i()
{
  {
    init_simple_test("aBFu8c_B_BFu0i");
    static aBFu8c_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu8c_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu0i(Test_aBFu8c_B_BFu0i, "aBFu8c_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu0ll()
{
  {
    init_simple_test("aBFu8c_B_BFu0ll");
    static aBFu8c_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu8c_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu0ll(Test_aBFu8c_B_BFu0ll, "aBFu8c_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu0s()
{
  {
    init_simple_test("aBFu8c_B_BFu0s");
    static aBFu8c_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8c_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu0s(Test_aBFu8c_B_BFu0s, "aBFu8c_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu0c_B()
{
  {
    init_simple_test("aBFu8c_BFu0c_B");
    static aBFu8c_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8c_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu0c_B");
    check_field_offset(lv, v2, 1, "aBFu8c_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu0c_B(Test_aBFu8c_BFu0c_B, "aBFu8c_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu0i_B()
{
  {
    init_simple_test("aBFu8c_BFu0i_B");
    static aBFu8c_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu8c_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu8c_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu0i_B(Test_aBFu8c_BFu0i_B, "aBFu8c_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu0ll_B()
{
  {
    init_simple_test("aBFu8c_BFu0ll_B");
    static aBFu8c_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu8c_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu8c_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu0ll_B(Test_aBFu8c_BFu0ll_B, "aBFu8c_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu0s_B()
{
  {
    init_simple_test("aBFu8c_BFu0s_B");
    static aBFu8c_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu8c_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu8c_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu0s_B(Test_aBFu8c_BFu0s_B, "aBFu8c_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu0c()
{
  {
    init_simple_test("aBFu8i_B_BFu0c");
    static aBFu8i_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8i_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu0c(Test_aBFu8i_B_BFu0c, "aBFu8i_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu0i()
{
  {
    init_simple_test("aBFu8i_B_BFu0i");
    static aBFu8i_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu8i_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu0i(Test_aBFu8i_B_BFu0i, "aBFu8i_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu0ll()
{
  {
    init_simple_test("aBFu8i_B_BFu0ll");
    static aBFu8i_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu8i_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu0ll(Test_aBFu8i_B_BFu0ll, "aBFu8i_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu0s()
{
  {
    init_simple_test("aBFu8i_B_BFu0s");
    static aBFu8i_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8i_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu0s(Test_aBFu8i_B_BFu0s, "aBFu8i_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu0c_B()
{
  {
    init_simple_test("aBFu8i_BFu0c_B");
    static aBFu8i_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8i_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu0c_B");
    check_field_offset(lv, v2, 1, "aBFu8i_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu0c_B(Test_aBFu8i_BFu0c_B, "aBFu8i_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu0i_B()
{
  {
    init_simple_test("aBFu8i_BFu0i_B");
    static aBFu8i_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu8i_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu8i_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu0i_B(Test_aBFu8i_BFu0i_B, "aBFu8i_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu0ll_B()
{
  {
    init_simple_test("aBFu8i_BFu0ll_B");
    static aBFu8i_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu8i_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu8i_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu0ll_B(Test_aBFu8i_BFu0ll_B, "aBFu8i_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu0s_B()
{
  {
    init_simple_test("aBFu8i_BFu0s_B");
    static aBFu8i_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu8i_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu8i_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu0s_B(Test_aBFu8i_BFu0s_B, "aBFu8i_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu0c()
{
  {
    init_simple_test("aBFu8ll_B_BFu0c");
    static aBFu8ll_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8ll_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu0c(Test_aBFu8ll_B_BFu0c, "aBFu8ll_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu0i()
{
  {
    init_simple_test("aBFu8ll_B_BFu0i");
    static aBFu8ll_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu8ll_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu0i(Test_aBFu8ll_B_BFu0i, "aBFu8ll_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu0ll()
{
  {
    init_simple_test("aBFu8ll_B_BFu0ll");
    static aBFu8ll_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu8ll_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu0ll(Test_aBFu8ll_B_BFu0ll, "aBFu8ll_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu0s()
{
  {
    init_simple_test("aBFu8ll_B_BFu0s");
    static aBFu8ll_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8ll_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu0s(Test_aBFu8ll_B_BFu0s, "aBFu8ll_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu0c_B()
{
  {
    init_simple_test("aBFu8ll_BFu0c_B");
    static aBFu8ll_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8ll_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu0c_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu0c_B(Test_aBFu8ll_BFu0c_B, "aBFu8ll_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu0i_B()
{
  {
    init_simple_test("aBFu8ll_BFu0i_B");
    static aBFu8ll_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu8ll_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu8ll_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu0i_B(Test_aBFu8ll_BFu0i_B, "aBFu8ll_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu0ll_B()
{
  {
    init_simple_test("aBFu8ll_BFu0ll_B");
    static aBFu8ll_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu8ll_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu8ll_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu0ll_B(Test_aBFu8ll_BFu0ll_B, "aBFu8ll_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu0s_B()
{
  {
    init_simple_test("aBFu8ll_BFu0s_B");
    static aBFu8ll_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu8ll_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu8ll_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu0s_B(Test_aBFu8ll_BFu0s_B, "aBFu8ll_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu0c()
{
  {
    init_simple_test("aBFu8s_B_BFu0c");
    static aBFu8s_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8s_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu0c(Test_aBFu8s_B_BFu0c, "aBFu8s_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu0i()
{
  {
    init_simple_test("aBFu8s_B_BFu0i");
    static aBFu8s_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu8s_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu0i(Test_aBFu8s_B_BFu0i, "aBFu8s_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu0ll()
{
  {
    init_simple_test("aBFu8s_B_BFu0ll");
    static aBFu8s_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu8s_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu0ll(Test_aBFu8s_B_BFu0ll, "aBFu8s_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu0s()
{
  {
    init_simple_test("aBFu8s_B_BFu0s");
    static aBFu8s_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8s_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu0s(Test_aBFu8s_B_BFu0s, "aBFu8s_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu0c_B()
{
  {
    init_simple_test("aBFu8s_BFu0c_B");
    static aBFu8s_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8s_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu0c_B");
    check_field_offset(lv, v2, 1, "aBFu8s_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu0c_B(Test_aBFu8s_BFu0c_B, "aBFu8s_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu0i_B()
{
  {
    init_simple_test("aBFu8s_BFu0i_B");
    static aBFu8s_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu8s_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu8s_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu0i_B(Test_aBFu8s_BFu0i_B, "aBFu8s_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu0ll_B()
{
  {
    init_simple_test("aBFu8s_BFu0ll_B");
    static aBFu8s_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu8s_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu8s_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu0ll_B(Test_aBFu8s_BFu0ll_B, "aBFu8s_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu0s_B()
{
  {
    init_simple_test("aBFu8s_BFu0s_B");
    static aBFu8s_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu8s_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu0s_B");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu8s_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu0s_B(Test_aBFu8s_BFu0s_B, "aBFu8s_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu0c()
{
  {
    init_simple_test("aBFu9i_B_BFu0c");
    static aBFu9i_B_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9i_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu0c(Test_aBFu9i_B_BFu0c, "aBFu9i_B_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu0i()
{
  {
    init_simple_test("aBFu9i_B_BFu0i");
    static aBFu9i_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu9i_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu0i(Test_aBFu9i_B_BFu0i, "aBFu9i_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu0ll()
{
  {
    init_simple_test("aBFu9i_B_BFu0ll");
    static aBFu9i_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu9i_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu0ll(Test_aBFu9i_B_BFu0ll, "aBFu9i_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu0s()
{
  {
    init_simple_test("aBFu9i_B_BFu0s");
    static aBFu9i_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu9i_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu0s(Test_aBFu9i_B_BFu0s, "aBFu9i_B_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu0c_B()
{
  {
    init_simple_test("aBFu9i_BFu0c_B");
    static aBFu9i_BFu0c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9i_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu0c_B");
    check_field_offset(lv, v2, 2, "aBFu9i_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu0c_B(Test_aBFu9i_BFu0c_B, "aBFu9i_BFu0c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu0i_B()
{
  {
    init_simple_test("aBFu9i_BFu0i_B");
    static aBFu9i_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu9i_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu9i_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu0i_B(Test_aBFu9i_BFu0i_B, "aBFu9i_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu0ll_B()
{
  {
    init_simple_test("aBFu9i_BFu0ll_B");
    static aBFu9i_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu9i_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu9i_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu0ll_B(Test_aBFu9i_BFu0ll_B, "aBFu9i_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu0s_B()
{
  {
    init_simple_test("aBFu9i_BFu0s_B");
    static aBFu9i_BFu0s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9i_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu0s_B");
    check_field_offset(lv, v2, 2, "aBFu9i_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu0s_B(Test_aBFu9i_BFu0s_B, "aBFu9i_BFu0s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu0c()
{
  {
    init_simple_test("aBFu9ll_B_BFu0c");
    static aBFu9ll_B_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9ll_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu0c(Test_aBFu9ll_B_BFu0c, "aBFu9ll_B_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu0i()
{
  {
    init_simple_test("aBFu9ll_B_BFu0i");
    static aBFu9ll_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu9ll_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu0i(Test_aBFu9ll_B_BFu0i, "aBFu9ll_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu0ll()
{
  {
    init_simple_test("aBFu9ll_B_BFu0ll");
    static aBFu9ll_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu9ll_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu0ll(Test_aBFu9ll_B_BFu0ll, "aBFu9ll_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu0s()
{
  {
    init_simple_test("aBFu9ll_B_BFu0s");
    static aBFu9ll_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu9ll_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu0s(Test_aBFu9ll_B_BFu0s, "aBFu9ll_B_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu0c_B()
{
  {
    init_simple_test("aBFu9ll_BFu0c_B");
    static aBFu9ll_BFu0c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9ll_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu0c_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu0c_B(Test_aBFu9ll_BFu0c_B, "aBFu9ll_BFu0c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu0i_B()
{
  {
    init_simple_test("aBFu9ll_BFu0i_B");
    static aBFu9ll_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu9ll_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu9ll_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu0i_B(Test_aBFu9ll_BFu0i_B, "aBFu9ll_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu0ll_B()
{
  {
    init_simple_test("aBFu9ll_BFu0ll_B");
    static aBFu9ll_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu9ll_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu9ll_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu0ll_B(Test_aBFu9ll_BFu0ll_B, "aBFu9ll_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu0s_B()
{
  {
    init_simple_test("aBFu9ll_BFu0s_B");
    static aBFu9ll_BFu0s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9ll_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu0s_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu0s_B(Test_aBFu9ll_BFu0s_B, "aBFu9ll_BFu0s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu0c()
{
  {
    init_simple_test("aBFu9s_B_BFu0c");
    static aBFu9s_B_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9s_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu0c(Test_aBFu9s_B_BFu0c, "aBFu9s_B_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu0i()
{
  {
    init_simple_test("aBFu9s_B_BFu0i");
    static aBFu9s_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu9s_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu0i(Test_aBFu9s_B_BFu0i, "aBFu9s_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu0ll()
{
  {
    init_simple_test("aBFu9s_B_BFu0ll");
    static aBFu9s_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu9s_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu0ll(Test_aBFu9s_B_BFu0ll, "aBFu9s_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu0s()
{
  {
    init_simple_test("aBFu9s_B_BFu0s");
    static aBFu9s_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu9s_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu0s(Test_aBFu9s_B_BFu0s, "aBFu9s_B_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_BFu0c_B()
{
  {
    init_simple_test("aBFu9s_BFu0c_B");
    static aBFu9s_BFu0c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9s_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_BFu0c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_BFu0c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_BFu0c_B");
    check_field_offset(lv, v2, 2, "aBFu9s_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9s_BFu0c_B(Test_aBFu9s_BFu0c_B, "aBFu9s_BFu0c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_BFu0i_B()
{
  {
    init_simple_test("aBFu9s_BFu0i_B");
    static aBFu9s_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu9s_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_BFu0i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_BFu0i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_BFu0i_B");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu9s_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9s_BFu0i_B(Test_aBFu9s_BFu0i_B, "aBFu9s_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_BFu0ll_B()
{
  {
    init_simple_test("aBFu9s_BFu0ll_B");
    static aBFu9s_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu9s_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_BFu0ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_BFu0ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_BFu0ll_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu9s_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9s_BFu0ll_B(Test_aBFu9s_BFu0ll_B, "aBFu9s_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_BFu0s_B()
{
  {
    init_simple_test("aBFu9s_BFu0s_B");
    static aBFu9s_BFu0s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9s_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_BFu0s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_BFu0s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_BFu0s_B");
    check_field_offset(lv, v2, 2, "aBFu9s_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9s_BFu0s_B(Test_aBFu9s_BFu0s_B, "aBFu9s_BFu0s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aC_B_BFu0c()
{
  {
    init_simple_test("aC_B_BFu0c");
    static aC_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aC_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aC_B_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aC_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaC_B_BFu0c(Test_aC_B_BFu0c, "aC_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aC_B_BFu0i()
{
  {
    init_simple_test("aC_B_BFu0i");
    static aC_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aC_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aC_B_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aC_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaC_B_BFu0i(Test_aC_B_BFu0i, "aC_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aC_B_BFu0ll()
{
  {
    init_simple_test("aC_B_BFu0ll");
    static aC_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aC_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aC_B_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aC_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaC_B_BFu0ll(Test_aC_B_BFu0ll, "aC_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aC_B_BFu0s()
{
  {
    init_simple_test("aC_B_BFu0s");
    static aC_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aC_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aC_B_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aC_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaC_B_BFu0s(Test_aC_B_BFu0s, "aC_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aC_BFu0c_B()
{
  {
    init_simple_test("aC_BFu0c_B");
    static aC_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aC_BFu0c_B.v1");
    check_field_offset(lv, v2, 1, "aC_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaC_BFu0c_B(Test_aC_BFu0c_B, "aC_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aC_BFu0i_B()
{
  {
    init_simple_test("aC_BFu0i_B");
    static aC_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aC_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aC_BFu0i_B.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aC_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaC_BFu0i_B(Test_aC_BFu0i_B, "aC_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aC_BFu0ll_B()
{
  {
    init_simple_test("aC_BFu0ll_B");
    static aC_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aC_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aC_BFu0ll_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aC_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaC_BFu0ll_B(Test_aC_BFu0ll_B, "aC_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aC_BFu0s_B()
{
  {
    init_simple_test("aC_BFu0s_B");
    static aC_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aC_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aC_BFu0s_B.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aC_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaC_BFu0s_B(Test_aC_BFu0s_B, "aC_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aD_B_BFu0c()
{
  {
    init_simple_test("aD_B_BFu0c");
    static aD_B_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aD_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aD_B_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aD_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaD_B_BFu0c(Test_aD_B_BFu0c, "aD_B_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aD_B_BFu0i()
{
  {
    init_simple_test("aD_B_BFu0i");
    static aD_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aD_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aD_B_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aD_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaD_B_BFu0i(Test_aD_B_BFu0i, "aD_B_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aD_B_BFu0ll()
{
  {
    init_simple_test("aD_B_BFu0ll");
    static aD_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aD_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aD_B_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aD_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaD_B_BFu0ll(Test_aD_B_BFu0ll, "aD_B_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aD_B_BFu0s()
{
  {
    init_simple_test("aD_B_BFu0s");
    static aD_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aD_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aD_B_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aD_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaD_B_BFu0s(Test_aD_B_BFu0s, "aD_B_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aD_BFu0c_B()
{
  {
    init_simple_test("aD_BFu0c_B");
    static aD_BFu0c_B lv;
    check2(sizeof(lv), 9, "sizeof(aD_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aD_BFu0c_B.v1");
    check_field_offset(lv, v2, 8, "aD_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaD_BFu0c_B(Test_aD_BFu0c_B, "aD_BFu0c_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aD_BFu0i_B()
{
  {
    init_simple_test("aD_BFu0i_B");
    static aD_BFu0i_B lv;
    check2(sizeof(lv), 9, "sizeof(aD_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aD_BFu0i_B.v1");
    check_field_offset(lv, v2, 8, "aD_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaD_BFu0i_B(Test_aD_BFu0i_B, "aD_BFu0i_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aD_BFu0ll_B()
{
  {
    init_simple_test("aD_BFu0ll_B");
    static aD_BFu0ll_B lv;
    check2(sizeof(lv), 9, "sizeof(aD_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aD_BFu0ll_B.v1");
    check_field_offset(lv, v2, 8, "aD_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaD_BFu0ll_B(Test_aD_BFu0ll_B, "aD_BFu0ll_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aD_BFu0s_B()
{
  {
    init_simple_test("aD_BFu0s_B");
    static aD_BFu0s_B lv;
    check2(sizeof(lv), 9, "sizeof(aD_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aD_BFu0s_B.v1");
    check_field_offset(lv, v2, 8, "aD_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaD_BFu0s_B(Test_aD_BFu0s_B, "aD_BFu0s_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aF_B_BFu0c()
{
  {
    init_simple_test("aF_B_BFu0c");
    static aF_B_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aF_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aF_B_BFu0c.v1");
    check_field_offset(lv, v2, 4, "aF_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaF_B_BFu0c(Test_aF_B_BFu0c, "aF_B_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aF_B_BFu0i()
{
  {
    init_simple_test("aF_B_BFu0i");
    static aF_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aF_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aF_B_BFu0i.v1");
    check_field_offset(lv, v2, 4, "aF_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaF_B_BFu0i(Test_aF_B_BFu0i, "aF_B_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aF_B_BFu0ll()
{
  {
    init_simple_test("aF_B_BFu0ll");
    static aF_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aF_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aF_B_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "aF_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaF_B_BFu0ll(Test_aF_B_BFu0ll, "aF_B_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aF_B_BFu0s()
{
  {
    init_simple_test("aF_B_BFu0s");
    static aF_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aF_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aF_B_BFu0s.v1");
    check_field_offset(lv, v2, 4, "aF_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaF_B_BFu0s(Test_aF_B_BFu0s, "aF_B_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aF_BFu0c_B()
{
  {
    init_simple_test("aF_BFu0c_B");
    static aF_BFu0c_B lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aF_BFu0c_B.v1");
    check_field_offset(lv, v2, 4, "aF_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaF_BFu0c_B(Test_aF_BFu0c_B, "aF_BFu0c_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aF_BFu0i_B()
{
  {
    init_simple_test("aF_BFu0i_B");
    static aF_BFu0i_B lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aF_BFu0i_B.v1");
    check_field_offset(lv, v2, 4, "aF_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaF_BFu0i_B(Test_aF_BFu0i_B, "aF_BFu0i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aF_BFu0ll_B()
{
  {
    init_simple_test("aF_BFu0ll_B");
    static aF_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aF_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aF_BFu0ll_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aF_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaF_BFu0ll_B(Test_aF_BFu0ll_B, "aF_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aF_BFu0s_B()
{
  {
    init_simple_test("aF_BFu0s_B");
    static aF_BFu0s_B lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aF_BFu0s_B.v1");
    check_field_offset(lv, v2, 4, "aF_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaF_BFu0s_B(Test_aF_BFu0s_B, "aF_BFu0s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aI_B_BFu0c()
{
  {
    init_simple_test("aI_B_BFu0c");
    static aI_B_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aI_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aI_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aI_B_BFu0c.v1");
    check_field_offset(lv, v2, 4, "aI_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaI_B_BFu0c(Test_aI_B_BFu0c, "aI_B_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aI_B_BFu0i()
{
  {
    init_simple_test("aI_B_BFu0i");
    static aI_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aI_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aI_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aI_B_BFu0i.v1");
    check_field_offset(lv, v2, 4, "aI_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaI_B_BFu0i(Test_aI_B_BFu0i, "aI_B_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aI_B_BFu0ll()
{
  {
    init_simple_test("aI_B_BFu0ll");
    static aI_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aI_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aI_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aI_B_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "aI_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaI_B_BFu0ll(Test_aI_B_BFu0ll, "aI_B_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aI_B_BFu0s()
{
  {
    init_simple_test("aI_B_BFu0s");
    static aI_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aI_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aI_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aI_B_BFu0s.v1");
    check_field_offset(lv, v2, 4, "aI_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaI_B_BFu0s(Test_aI_B_BFu0s, "aI_B_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aI_BFu0c_B()
{
  {
    init_simple_test("aI_BFu0c_B");
    static aI_BFu0c_B lv;
    check2(sizeof(lv), 5, "sizeof(aI_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aI_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aI_BFu0c_B.v1");
    check_field_offset(lv, v2, 4, "aI_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaI_BFu0c_B(Test_aI_BFu0c_B, "aI_BFu0c_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aI_BFu0i_B()
{
  {
    init_simple_test("aI_BFu0i_B");
    static aI_BFu0i_B lv;
    check2(sizeof(lv), 5, "sizeof(aI_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aI_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aI_BFu0i_B.v1");
    check_field_offset(lv, v2, 4, "aI_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaI_BFu0i_B(Test_aI_BFu0i_B, "aI_BFu0i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aI_BFu0ll_B()
{
  {
    init_simple_test("aI_BFu0ll_B");
    static aI_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aI_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aI_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aI_BFu0ll_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aI_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaI_BFu0ll_B(Test_aI_BFu0ll_B, "aI_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aI_BFu0s_B()
{
  {
    init_simple_test("aI_BFu0s_B");
    static aI_BFu0s_B lv;
    check2(sizeof(lv), 5, "sizeof(aI_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aI_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aI_BFu0s_B.v1");
    check_field_offset(lv, v2, 4, "aI_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaI_BFu0s_B(Test_aI_BFu0s_B, "aI_BFu0s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aIp_B_BFu0c()
{
  {
    init_simple_test("aIp_B_BFu0c");
    static aIp_B_BFu0c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aIp_B_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaIp_B_BFu0c(Test_aIp_B_BFu0c, "aIp_B_BFu0c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aIp_B_BFu0i()
{
  {
    init_simple_test("aIp_B_BFu0i");
    static aIp_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aIp_B_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaIp_B_BFu0i(Test_aIp_B_BFu0i, "aIp_B_BFu0i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aIp_B_BFu0ll()
{
  {
    init_simple_test("aIp_B_BFu0ll");
    static aIp_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aIp_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aIp_B_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaIp_B_BFu0ll(Test_aIp_B_BFu0ll, "aIp_B_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aIp_B_BFu0s()
{
  {
    init_simple_test("aIp_B_BFu0s");
    static aIp_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aIp_B_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaIp_B_BFu0s(Test_aIp_B_BFu0s, "aIp_B_BFu0s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aIp_BFu0c_B()
{
  {
    init_simple_test("aIp_BFu0c_B");
    static aIp_BFu0c_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aIp_BFu0c_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaIp_BFu0c_B(Test_aIp_BFu0c_B, "aIp_BFu0c_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aIp_BFu0i_B()
{
  {
    init_simple_test("aIp_BFu0i_B");
    static aIp_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aIp_BFu0i_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaIp_BFu0i_B(Test_aIp_BFu0i_B, "aIp_BFu0i_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aIp_BFu0ll_B()
{
  {
    init_simple_test("aIp_BFu0ll_B");
    static aIp_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aIp_BFu0ll_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaIp_BFu0ll_B(Test_aIp_BFu0ll_B, "aIp_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aIp_BFu0s_B()
{
  {
    init_simple_test("aIp_BFu0s_B");
    static aIp_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aIp_BFu0s_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaIp_BFu0s_B(Test_aIp_BFu0s_B, "aIp_BFu0s_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_B_BFu0c()
{
  {
    init_simple_test("aL_B_BFu0c");
    static aL_B_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aL_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_B_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaL_B_BFu0c(Test_aL_B_BFu0c, "aL_B_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_B_BFu0i()
{
  {
    init_simple_test("aL_B_BFu0i");
    static aL_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aL_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_B_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaL_B_BFu0i(Test_aL_B_BFu0i, "aL_B_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_B_BFu0ll()
{
  {
    init_simple_test("aL_B_BFu0ll");
    static aL_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_B_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaL_B_BFu0ll(Test_aL_B_BFu0ll, "aL_B_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_B_BFu0s()
{
  {
    init_simple_test("aL_B_BFu0s");
    static aL_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aL_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_B_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaL_B_BFu0s(Test_aL_B_BFu0s, "aL_B_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu0c_B()
{
  {
    init_simple_test("aL_BFu0c_B");
    static aL_BFu0c_B lv;
    check2(sizeof(lv), 9, "sizeof(aL_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aL_BFu0c_B.v1");
    check_field_offset(lv, v2, 8, "aL_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaL_BFu0c_B(Test_aL_BFu0c_B, "aL_BFu0c_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu0i_B()
{
  {
    init_simple_test("aL_BFu0i_B");
    static aL_BFu0i_B lv;
    check2(sizeof(lv), 9, "sizeof(aL_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aL_BFu0i_B.v1");
    check_field_offset(lv, v2, 8, "aL_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaL_BFu0i_B(Test_aL_BFu0i_B, "aL_BFu0i_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu0ll_B()
{
  {
    init_simple_test("aL_BFu0ll_B");
    static aL_BFu0ll_B lv;
    check2(sizeof(lv), 9, "sizeof(aL_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aL_BFu0ll_B.v1");
    check_field_offset(lv, v2, 8, "aL_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaL_BFu0ll_B(Test_aL_BFu0ll_B, "aL_BFu0ll_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu0s_B()
{
  {
    init_simple_test("aL_BFu0s_B");
    static aL_BFu0s_B lv;
    check2(sizeof(lv), 9, "sizeof(aL_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aL_BFu0s_B.v1");
    check_field_offset(lv, v2, 8, "aL_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaL_BFu0s_B(Test_aL_BFu0s_B, "aL_BFu0s_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_B_BFu0c()
{
  {
    init_simple_test("aS_B_BFu0c");
    static aS_B_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_B_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaS_B_BFu0c(Test_aS_B_BFu0c, "aS_B_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_B_BFu0i()
{
  {
    init_simple_test("aS_B_BFu0i");
    static aS_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_B_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaS_B_BFu0i(Test_aS_B_BFu0i, "aS_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_B_BFu0ll()
{
  {
    init_simple_test("aS_B_BFu0ll");
    static aS_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_B_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaS_B_BFu0ll(Test_aS_B_BFu0ll, "aS_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_B_BFu0s()
{
  {
    init_simple_test("aS_B_BFu0s");
    static aS_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_B_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaS_B_BFu0s(Test_aS_B_BFu0s, "aS_B_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_B()
{
  {
    init_simple_test("aS_BFu0c_B");
    static aS_BFu0c_B lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_B.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_B(Test_aS_BFu0c_B, "aS_BFu0c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_B()
{
  {
    init_simple_test("aS_BFu0i_B");
    static aS_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_B.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_B(Test_aS_BFu0i_B, "aS_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_B()
{
  {
    init_simple_test("aS_BFu0ll_B");
    static aS_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_B(Test_aS_BFu0ll_B, "aS_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_B()
{
  {
    init_simple_test("aS_BFu0s_B");
    static aS_BFu0s_B lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_B.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_B(Test_aS_BFu0s_B, "aS_BFu0s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_B_BFu0c()
{
  {
    init_simple_test("aUc_B_BFu0c");
    static aUc_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_B_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUc_B_BFu0c(Test_aUc_B_BFu0c, "aUc_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_B_BFu0i()
{
  {
    init_simple_test("aUc_B_BFu0i");
    static aUc_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_B_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUc_B_BFu0i(Test_aUc_B_BFu0i, "aUc_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_B_BFu0ll()
{
  {
    init_simple_test("aUc_B_BFu0ll");
    static aUc_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_B_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUc_B_BFu0ll(Test_aUc_B_BFu0ll, "aUc_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_B_BFu0s()
{
  {
    init_simple_test("aUc_B_BFu0s");
    static aUc_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_B_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUc_B_BFu0s(Test_aUc_B_BFu0s, "aUc_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_B()
{
  {
    init_simple_test("aUc_BFu0c_B");
    static aUc_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_B.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_B(Test_aUc_BFu0c_B, "aUc_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_B()
{
  {
    init_simple_test("aUc_BFu0i_B");
    static aUc_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_B.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_B(Test_aUc_BFu0i_B, "aUc_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_B()
{
  {
    init_simple_test("aUc_BFu0ll_B");
    static aUc_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_B(Test_aUc_BFu0ll_B, "aUc_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_B()
{
  {
    init_simple_test("aUc_BFu0s_B");
    static aUc_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_B.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_B(Test_aUc_BFu0s_B, "aUc_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_B_BFu0c()
{
  {
    init_simple_test("aUi_B_BFu0c");
    static aUi_B_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_B_BFu0c.v1");
    check_field_offset(lv, v2, 4, "aUi_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUi_B_BFu0c(Test_aUi_B_BFu0c, "aUi_B_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_B_BFu0i()
{
  {
    init_simple_test("aUi_B_BFu0i");
    static aUi_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_B_BFu0i.v1");
    check_field_offset(lv, v2, 4, "aUi_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUi_B_BFu0i(Test_aUi_B_BFu0i, "aUi_B_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_B_BFu0ll()
{
  {
    init_simple_test("aUi_B_BFu0ll");
    static aUi_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_B_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "aUi_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUi_B_BFu0ll(Test_aUi_B_BFu0ll, "aUi_B_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_B_BFu0s()
{
  {
    init_simple_test("aUi_B_BFu0s");
    static aUi_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_B_BFu0s.v1");
    check_field_offset(lv, v2, 4, "aUi_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUi_B_BFu0s(Test_aUi_B_BFu0s, "aUi_B_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_B()
{
  {
    init_simple_test("aUi_BFu0c_B");
    static aUi_BFu0c_B lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_B.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_B(Test_aUi_BFu0c_B, "aUi_BFu0c_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_B()
{
  {
    init_simple_test("aUi_BFu0i_B");
    static aUi_BFu0i_B lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_B.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_B(Test_aUi_BFu0i_B, "aUi_BFu0i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_B()
{
  {
    init_simple_test("aUi_BFu0ll_B");
    static aUi_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_B(Test_aUi_BFu0ll_B, "aUi_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_B()
{
  {
    init_simple_test("aUi_BFu0s_B");
    static aUi_BFu0s_B lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_B.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_B(Test_aUi_BFu0s_B, "aUi_BFu0s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUl_B_BFu0c()
{
  {
    init_simple_test("aUl_B_BFu0c");
    static aUl_B_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aUl_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aUl_B_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aUl_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUl_B_BFu0c(Test_aUl_B_BFu0c, "aUl_B_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUl_B_BFu0i()
{
  {
    init_simple_test("aUl_B_BFu0i");
    static aUl_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aUl_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aUl_B_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aUl_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUl_B_BFu0i(Test_aUl_B_BFu0i, "aUl_B_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUl_B_BFu0ll()
{
  {
    init_simple_test("aUl_B_BFu0ll");
    static aUl_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUl_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUl_B_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aUl_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUl_B_BFu0ll(Test_aUl_B_BFu0ll, "aUl_B_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUl_B_BFu0s()
{
  {
    init_simple_test("aUl_B_BFu0s");
    static aUl_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aUl_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aUl_B_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aUl_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUl_B_BFu0s(Test_aUl_B_BFu0s, "aUl_B_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUl_BFu0c_B()
{
  {
    init_simple_test("aUl_BFu0c_B");
    static aUl_BFu0c_B lv;
    check2(sizeof(lv), 9, "sizeof(aUl_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aUl_BFu0c_B.v1");
    check_field_offset(lv, v2, 8, "aUl_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaUl_BFu0c_B(Test_aUl_BFu0c_B, "aUl_BFu0c_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUl_BFu0i_B()
{
  {
    init_simple_test("aUl_BFu0i_B");
    static aUl_BFu0i_B lv;
    check2(sizeof(lv), 9, "sizeof(aUl_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aUl_BFu0i_B.v1");
    check_field_offset(lv, v2, 8, "aUl_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaUl_BFu0i_B(Test_aUl_BFu0i_B, "aUl_BFu0i_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUl_BFu0ll_B()
{
  {
    init_simple_test("aUl_BFu0ll_B");
    static aUl_BFu0ll_B lv;
    check2(sizeof(lv), 9, "sizeof(aUl_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aUl_BFu0ll_B.v1");
    check_field_offset(lv, v2, 8, "aUl_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaUl_BFu0ll_B(Test_aUl_BFu0ll_B, "aUl_BFu0ll_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUl_BFu0s_B()
{
  {
    init_simple_test("aUl_BFu0s_B");
    static aUl_BFu0s_B lv;
    check2(sizeof(lv), 9, "sizeof(aUl_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aUl_BFu0s_B.v1");
    check_field_offset(lv, v2, 8, "aUl_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaUl_BFu0s_B(Test_aUl_BFu0s_B, "aUl_BFu0s_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUs_B_BFu0c()
{
  {
    init_simple_test("aUs_B_BFu0c");
    static aUs_B_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aUs_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aUs_B_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aUs_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUs_B_BFu0c(Test_aUs_B_BFu0c, "aUs_B_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUs_B_BFu0i()
{
  {
    init_simple_test("aUs_B_BFu0i");
    static aUs_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUs_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aUs_B_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aUs_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUs_B_BFu0i(Test_aUs_B_BFu0i, "aUs_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUs_B_BFu0ll()
{
  {
    init_simple_test("aUs_B_BFu0ll");
    static aUs_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUs_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUs_B_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aUs_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUs_B_BFu0ll(Test_aUs_B_BFu0ll, "aUs_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUs_B_BFu0s()
{
  {
    init_simple_test("aUs_B_BFu0s");
    static aUs_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUs_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aUs_B_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aUs_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUs_B_BFu0s(Test_aUs_B_BFu0s, "aUs_B_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUs_BFu0c_B()
{
  {
    init_simple_test("aUs_BFu0c_B");
    static aUs_BFu0c_B lv;
    check2(sizeof(lv), 3, "sizeof(aUs_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aUs_BFu0c_B.v1");
    check_field_offset(lv, v2, 2, "aUs_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaUs_BFu0c_B(Test_aUs_BFu0c_B, "aUs_BFu0c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUs_BFu0i_B()
{
  {
    init_simple_test("aUs_BFu0i_B");
    static aUs_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUs_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aUs_BFu0i_B.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUs_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaUs_BFu0i_B(Test_aUs_BFu0i_B, "aUs_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUs_BFu0ll_B()
{
  {
    init_simple_test("aUs_BFu0ll_B");
    static aUs_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUs_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aUs_BFu0ll_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUs_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaUs_BFu0ll_B(Test_aUs_BFu0ll_B, "aUs_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUs_BFu0s_B()
{
  {
    init_simple_test("aUs_BFu0s_B");
    static aUs_BFu0s_B lv;
    check2(sizeof(lv), 3, "sizeof(aUs_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aUs_BFu0s_B.v1");
    check_field_offset(lv, v2, 2, "aUs_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaUs_BFu0s_B(Test_aUs_BFu0s_B, "aUs_BFu0s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aVp_B_BFu0c()
{
  {
    init_simple_test("aVp_B_BFu0c");
    static aVp_B_BFu0c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_B_BFu0c)");
    check_field_offset(lv, v1, 0, "aVp_B_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaVp_B_BFu0c(Test_aVp_B_BFu0c, "aVp_B_BFu0c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aVp_B_BFu0i()
{
  {
    init_simple_test("aVp_B_BFu0i");
    static aVp_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_B_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_B_BFu0i)");
    check_field_offset(lv, v1, 0, "aVp_B_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaVp_B_BFu0i(Test_aVp_B_BFu0i, "aVp_B_BFu0i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aVp_B_BFu0ll()
{
  {
    init_simple_test("aVp_B_BFu0ll");
    static aVp_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aVp_B_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "aVp_B_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaVp_B_BFu0ll(Test_aVp_B_BFu0ll, "aVp_B_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aVp_B_BFu0s()
{
  {
    init_simple_test("aVp_B_BFu0s");
    static aVp_B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_B_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_B_BFu0s)");
    check_field_offset(lv, v1, 0, "aVp_B_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaVp_B_BFu0s(Test_aVp_B_BFu0s, "aVp_B_BFu0s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aVp_BFu0c_B()
{
  {
    init_simple_test("aVp_BFu0c_B");
    static aVp_BFu0c_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu0c_B)");
    check_field_offset(lv, v1, 0, "aVp_BFu0c_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vaVp_BFu0c_B(Test_aVp_BFu0c_B, "aVp_BFu0c_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aVp_BFu0i_B()
{
  {
    init_simple_test("aVp_BFu0i_B");
    static aVp_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu0i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu0i_B)");
    check_field_offset(lv, v1, 0, "aVp_BFu0i_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vaVp_BFu0i_B(Test_aVp_BFu0i_B, "aVp_BFu0i_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aVp_BFu0ll_B()
{
  {
    init_simple_test("aVp_BFu0ll_B");
    static aVp_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu0ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "aVp_BFu0ll_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vaVp_BFu0ll_B(Test_aVp_BFu0ll_B, "aVp_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aVp_BFu0s_B()
{
  {
    init_simple_test("aVp_BFu0s_B");
    static aVp_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu0s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu0s_B)");
    check_field_offset(lv, v1, 0, "aVp_BFu0s_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vaVp_BFu0s_B(Test_aVp_BFu0s_B, "aVp_BFu0s_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_B_BFu0c()
{
  {
    init_simple_test("B_B_BFu0c");
    static B_B_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(B_B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_B_BFu0c)");
    check_field_offset(lv, v1, 0, "B_B_BFu0c.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vB_B_BFu0c(Test_B_B_BFu0c, "B_B_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_B_BFu0i()
{
  {
    init_simple_test("B_B_BFu0i");
    static B_B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_B_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_B_BFu0i)");
    check_field_offset(lv, v1, 0, "B_B_BFu0i.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vB_B_BFu0i(Test_B_B_BFu0i, "B_B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_B_BFu0ll()
{
  {
    init_simple_test("B_B_BFu0ll");
    static B_B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_B_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_B_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_B_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vB_B_BFu0ll(Test_B_B_BFu0ll, "B_B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_B_BFu0s()
{
  {
    init_simple_test("B_B_BFu0s");
    static B_B_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(B_B_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_B_BFu0s)");
    check_field_offset(lv, v1, 0, "B_B_BFu0s.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vB_B_BFu0s(Test_B_B_BFu0s, "B_B_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c()
{
  {
    init_simple_test("B_BFu0c");
    static B_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(B_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0c(Test_B_BFu0c, "B_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_B()
{
  {
    init_simple_test("B_BFu0c_B");
    static B_BFu0c_B lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_B)");
    check_field_offset(lv, v1, 0, "B_BFu0c_B.v1");
    check_field_offset(lv, v2, 1, "B_BFu0c_B.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0c_B(Test_B_BFu0c_B, "B_BFu0c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu0c()
{
  {
    init_simple_test("B_BFu0c_BFu0c");
    static B_BFu0c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(B_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu0c(Test_B_BFu0c_BFu0c, "B_BFu0c_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu0i()
{
  {
    init_simple_test("B_BFu0c_BFu0i");
    static B_BFu0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0c_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu0i(Test_B_BFu0c_BFu0i, "B_BFu0c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu0ll()
{
  {
    init_simple_test("B_BFu0c_BFu0ll");
    static B_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0c_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu0ll(Test_B_BFu0c_BFu0ll, "B_BFu0c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu0s()
{
  {
    init_simple_test("B_BFu0c_BFu0s");
    static B_BFu0c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(B_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0c_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu0s(Test_B_BFu0c_BFu0s, "B_BFu0c_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu15i()
{
  {
    init_simple_test("B_BFu0c_BFu15i");
    static B_BFu0c_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu0c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu0c_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu15i(Test_B_BFu0c_BFu15i, "B_BFu0c_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu15ll()
{
  {
    init_simple_test("B_BFu0c_BFu15ll");
    static B_BFu0c_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu0c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu0c_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu15ll(Test_B_BFu0c_BFu15ll, "B_BFu0c_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu15s()
{
  {
    init_simple_test("B_BFu0c_BFu15s");
    static B_BFu0c_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu0c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu0c_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu15s(Test_B_BFu0c_BFu15s, "B_BFu0c_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu16i()
{
  {
    init_simple_test("B_BFu0c_BFu16i");
    static B_BFu0c_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu0c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu0c_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu16i(Test_B_BFu0c_BFu16i, "B_BFu0c_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu16ll()
{
  {
    init_simple_test("B_BFu0c_BFu16ll");
    static B_BFu0c_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu0c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu0c_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu16ll(Test_B_BFu0c_BFu16ll, "B_BFu0c_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu16s()
{
  {
    init_simple_test("B_BFu0c_BFu16s");
    static B_BFu0c_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu0c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu0c_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu16s(Test_B_BFu0c_BFu16s, "B_BFu0c_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu17i()
{
  {
    init_simple_test("B_BFu0c_BFu17i");
    static B_BFu0c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu0c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu0c_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu17i(Test_B_BFu0c_BFu17i, "B_BFu0c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu17ll()
{
  {
    init_simple_test("B_BFu0c_BFu17ll");
    static B_BFu0c_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu0c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu0c_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu17ll(Test_B_BFu0c_BFu17ll, "B_BFu0c_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu1c()
{
  {
    init_simple_test("B_BFu0c_BFu1c");
    static B_BFu0c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu0c_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu1c(Test_B_BFu0c_BFu1c, "B_BFu0c_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu1i()
{
  {
    init_simple_test("B_BFu0c_BFu1i");
    static B_BFu0c_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu0c_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu1i(Test_B_BFu0c_BFu1i, "B_BFu0c_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu1ll()
{
  {
    init_simple_test("B_BFu0c_BFu1ll");
    static B_BFu0c_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu0c_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu1ll(Test_B_BFu0c_BFu1ll, "B_BFu0c_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu1s()
{
  {
    init_simple_test("B_BFu0c_BFu1s");
    static B_BFu0c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu0c_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu1s(Test_B_BFu0c_BFu1s, "B_BFu0c_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu31i()
{
  {
    init_simple_test("B_BFu0c_BFu31i");
    static B_BFu0c_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu0c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu0c_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu31i(Test_B_BFu0c_BFu31i, "B_BFu0c_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu31ll()
{
  {
    init_simple_test("B_BFu0c_BFu31ll");
    static B_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu0c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu0c_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu31ll(Test_B_BFu0c_BFu31ll, "B_BFu0c_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu32i()
{
  {
    init_simple_test("B_BFu0c_BFu32i");
    static B_BFu0c_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu0c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu0c_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu32i(Test_B_BFu0c_BFu32i, "B_BFu0c_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu32ll()
{
  {
    init_simple_test("B_BFu0c_BFu32ll");
    static B_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu0c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu0c_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu32ll(Test_B_BFu0c_BFu32ll, "B_BFu0c_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu33()
{
  {
    init_simple_test("B_BFu0c_BFu33");
    static B_BFu0c_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu0c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu0c_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu33(Test_B_BFu0c_BFu33, "B_BFu0c_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu7c()
{
  {
    init_simple_test("B_BFu0c_BFu7c");
    static B_BFu0c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu0c_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu7c(Test_B_BFu0c_BFu7c, "B_BFu0c_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu7i()
{
  {
    init_simple_test("B_BFu0c_BFu7i");
    static B_BFu0c_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu0c_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu7i(Test_B_BFu0c_BFu7i, "B_BFu0c_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu7ll()
{
  {
    init_simple_test("B_BFu0c_BFu7ll");
    static B_BFu0c_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu0c_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu7ll(Test_B_BFu0c_BFu7ll, "B_BFu0c_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu7s()
{
  {
    init_simple_test("B_BFu0c_BFu7s");
    static B_BFu0c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu0c_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu7s(Test_B_BFu0c_BFu7s, "B_BFu0c_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu8c()
{
  {
    init_simple_test("B_BFu0c_BFu8c");
    static B_BFu0c_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu0c_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu8c(Test_B_BFu0c_BFu8c, "B_BFu0c_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu8i()
{
  {
    init_simple_test("B_BFu0c_BFu8i");
    static B_BFu0c_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu0c_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu8i(Test_B_BFu0c_BFu8i, "B_BFu0c_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu8ll()
{
  {
    init_simple_test("B_BFu0c_BFu8ll");
    static B_BFu0c_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu0c_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu8ll(Test_B_BFu0c_BFu8ll, "B_BFu0c_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu8s()
{
  {
    init_simple_test("B_BFu0c_BFu8s");
    static B_BFu0c_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu0c_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu8s(Test_B_BFu0c_BFu8s, "B_BFu0c_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu9i()
{
  {
    init_simple_test("B_BFu0c_BFu9i");
    static B_BFu0c_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu0c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu0c_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu9i(Test_B_BFu0c_BFu9i, "B_BFu0c_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu9ll()
{
  {
    init_simple_test("B_BFu0c_BFu9ll");
    static B_BFu0c_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu0c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu0c_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu9ll(Test_B_BFu0c_BFu9ll, "B_BFu0c_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_BFu9s()
{
  {
    init_simple_test("B_BFu0c_BFu9s");
    static B_BFu0c_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu0c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu0c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu0c_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu0c_BFu9s(Test_B_BFu0c_BFu9s, "B_BFu0c_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_C()
{
  {
    init_simple_test("B_BFu0c_C");
    static B_BFu0c_C lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_C)");
    check_field_offset(lv, v1, 0, "B_BFu0c_C.v1");
    check_field_offset(lv, v2, 1, "B_BFu0c_C.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0c_C(Test_B_BFu0c_C, "B_BFu0c_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_D()
{
  {
    init_simple_test("B_BFu0c_D");
    static B_BFu0c_D lv;
    check2(sizeof(lv), 9, "sizeof(B_BFu0c_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_D)");
    check_field_offset(lv, v1, 0, "B_BFu0c_D.v1");
    check_field_offset(lv, v2, 1, "B_BFu0c_D.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0c_D(Test_B_BFu0c_D, "B_BFu0c_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_F()
{
  {
    init_simple_test("B_BFu0c_F");
    static B_BFu0c_F lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu0c_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_F)");
    check_field_offset(lv, v1, 0, "B_BFu0c_F.v1");
    check_field_offset(lv, v2, 1, "B_BFu0c_F.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0c_F(Test_B_BFu0c_F, "B_BFu0c_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_I()
{
  {
    init_simple_test("B_BFu0c_I");
    static B_BFu0c_I lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu0c_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_I)");
    check_field_offset(lv, v1, 0, "B_BFu0c_I.v1");
    check_field_offset(lv, v2, 1, "B_BFu0c_I.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0c_I(Test_B_BFu0c_I, "B_BFu0c_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_Ip()
{
  {
    init_simple_test("B_BFu0c_Ip");
    static B_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu0c_Ip.v1");
    check_field_offset(lv, v2, 1, "B_BFu0c_Ip.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0c_Ip(Test_B_BFu0c_Ip, "B_BFu0c_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_L()
{
  {
    init_simple_test("B_BFu0c_L");
    static B_BFu0c_L lv;
    check2(sizeof(lv), 9, "sizeof(B_BFu0c_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_L)");
    check_field_offset(lv, v1, 0, "B_BFu0c_L.v1");
    check_field_offset(lv, v2, 1, "B_BFu0c_L.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0c_L(Test_B_BFu0c_L, "B_BFu0c_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_S()
{
  {
    init_simple_test("B_BFu0c_S");
    static B_BFu0c_S lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu0c_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_S)");
    check_field_offset(lv, v1, 0, "B_BFu0c_S.v1");
    check_field_offset(lv, v2, 1, "B_BFu0c_S.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0c_S(Test_B_BFu0c_S, "B_BFu0c_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_Uc()
{
  {
    init_simple_test("B_BFu0c_Uc");
    static B_BFu0c_Uc lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu0c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu0c_Uc.v1");
    check_field_offset(lv, v2, 1, "B_BFu0c_Uc.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0c_Uc(Test_B_BFu0c_Uc, "B_BFu0c_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_Ui()
{
  {
    init_simple_test("B_BFu0c_Ui");
    static B_BFu0c_Ui lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu0c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu0c_Ui.v1");
    check_field_offset(lv, v2, 1, "B_BFu0c_Ui.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0c_Ui(Test_B_BFu0c_Ui, "B_BFu0c_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_Ul()
{
  {
    init_simple_test("B_BFu0c_Ul");
    static B_BFu0c_Ul lv;
    check2(sizeof(lv), 9, "sizeof(B_BFu0c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu0c_Ul.v1");
    check_field_offset(lv, v2, 1, "B_BFu0c_Ul.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0c_Ul(Test_B_BFu0c_Ul, "B_BFu0c_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_Us()
{
  {
    init_simple_test("B_BFu0c_Us");
    static B_BFu0c_Us lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu0c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_Us)");
    check_field_offset(lv, v1, 0, "B_BFu0c_Us.v1");
    check_field_offset(lv, v2, 1, "B_BFu0c_Us.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0c_Us(Test_B_BFu0c_Us, "B_BFu0c_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0c_Vp()
{
  {
    init_simple_test("B_BFu0c_Vp");
    static B_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu0c_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu0c_Vp.v1");
    check_field_offset(lv, v2, 1, "B_BFu0c_Vp.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0c_Vp(Test_B_BFu0c_Vp, "B_BFu0c_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i()
{
  {
    init_simple_test("B_BFu0i");
    static B_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0i(Test_B_BFu0i, "B_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_B()
{
  {
    init_simple_test("B_BFu0i_B");
    static B_BFu0i_B lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_B)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_B)");
    check_field_offset(lv, v1, 0, "B_BFu0i_B.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "B_BFu0i_B.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0i_B(Test_B_BFu0i_B, "B_BFu0i_B", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu0c()
{
  {
    init_simple_test("B_BFu0i_BFu0c");
    static B_BFu0i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu0c(Test_B_BFu0i_BFu0c, "B_BFu0i_BFu0c", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu0i()
{
  {
    init_simple_test("B_BFu0i_BFu0i");
    static B_BFu0i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu0i(Test_B_BFu0i_BFu0i, "B_BFu0i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu0ll()
{
  {
    init_simple_test("B_BFu0i_BFu0ll");
    static B_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu0ll(Test_B_BFu0i_BFu0ll, "B_BFu0i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu0s()
{
  {
    init_simple_test("B_BFu0i_BFu0s");
    static B_BFu0i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu0s(Test_B_BFu0i_BFu0s, "B_BFu0i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu15i()
{
  {
    init_simple_test("B_BFu0i_BFu15i");
    static B_BFu0i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, 1, "B_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, hide_ull(1LL<<14), "B_BFu0i_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu15i(Test_B_BFu0i_BFu15i, "B_BFu0i_BFu15i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu15ll()
{
  {
    init_simple_test("B_BFu0i_BFu15ll");
    static B_BFu0i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, 1, "B_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, hide_ull(1LL<<14), "B_BFu0i_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu15ll(Test_B_BFu0i_BFu15ll, "B_BFu0i_BFu15ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu15s()
{
  {
    init_simple_test("B_BFu0i_BFu15s");
    static B_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, 1, "B_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, hide_ull(1LL<<14), "B_BFu0i_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu15s(Test_B_BFu0i_BFu15s, "B_BFu0i_BFu15s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu16i()
{
  {
    init_simple_test("B_BFu0i_BFu16i");
    static B_BFu0i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, 1, "B_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, hide_ull(1LL<<15), "B_BFu0i_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu16i(Test_B_BFu0i_BFu16i, "B_BFu0i_BFu16i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu16ll()
{
  {
    init_simple_test("B_BFu0i_BFu16ll");
    static B_BFu0i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, 1, "B_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, hide_ull(1LL<<15), "B_BFu0i_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu16ll(Test_B_BFu0i_BFu16ll, "B_BFu0i_BFu16ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu16s()
{
  {
    init_simple_test("B_BFu0i_BFu16s");
    static B_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, 1, "B_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, hide_ull(1LL<<15), "B_BFu0i_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu16s(Test_B_BFu0i_BFu16s, "B_BFu0i_BFu16s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu17i()
{
  {
    init_simple_test("B_BFu0i_BFu17i");
    static B_BFu0i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(B_BFu0i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, 1, "B_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, hide_ull(1LL<<16), "B_BFu0i_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu17i(Test_B_BFu0i_BFu17i, "B_BFu0i_BFu17i", ABISELECT(7,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu17ll()
{
  {
    init_simple_test("B_BFu0i_BFu17ll");
    static B_BFu0i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(B_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, 1, "B_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, hide_ull(1LL<<16), "B_BFu0i_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu17ll(Test_B_BFu0i_BFu17ll, "B_BFu0i_BFu17ll", ABISELECT(7,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu1c()
{
  {
    init_simple_test("B_BFu0i_BFu1c");
    static B_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "B_BFu0i_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu1c(Test_B_BFu0i_BFu1c, "B_BFu0i_BFu1c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu1i()
{
  {
    init_simple_test("B_BFu0i_BFu1i");
    static B_BFu0i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "B_BFu0i_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu1i(Test_B_BFu0i_BFu1i, "B_BFu0i_BFu1i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu1ll()
{
  {
    init_simple_test("B_BFu0i_BFu1ll");
    static B_BFu0i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "B_BFu0i_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu1ll(Test_B_BFu0i_BFu1ll, "B_BFu0i_BFu1ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu1s()
{
  {
    init_simple_test("B_BFu0i_BFu1s");
    static B_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "B_BFu0i_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu1s(Test_B_BFu0i_BFu1s, "B_BFu0i_BFu1s", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu31i()
{
  {
    init_simple_test("B_BFu0i_BFu31i");
    static B_BFu0i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu0i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, 1, "B_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, hide_ull(1LL<<30), "B_BFu0i_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu31i(Test_B_BFu0i_BFu31i, "B_BFu0i_BFu31i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu31ll()
{
  {
    init_simple_test("B_BFu0i_BFu31ll");
    static B_BFu0i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, 1, "B_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, hide_ull(1LL<<30), "B_BFu0i_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu31ll(Test_B_BFu0i_BFu31ll, "B_BFu0i_BFu31ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu32i()
{
  {
    init_simple_test("B_BFu0i_BFu32i");
    static B_BFu0i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu0i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, 1, "B_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, hide_ull(1LL<<31), "B_BFu0i_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu32i(Test_B_BFu0i_BFu32i, "B_BFu0i_BFu32i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu32ll()
{
  {
    init_simple_test("B_BFu0i_BFu32ll");
    static B_BFu0i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, 1, "B_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, hide_ull(1LL<<31), "B_BFu0i_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu32ll(Test_B_BFu0i_BFu32ll, "B_BFu0i_BFu32ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu33()
{
  {
    init_simple_test("B_BFu0i_BFu33");
    static B_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(9,9), "sizeof(B_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 33, 1, "B_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 33, hide_ull(1LL<<32), "B_BFu0i_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu33(Test_B_BFu0i_BFu33, "B_BFu0i_BFu33", ABISELECT(9,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu7c()
{
  {
    init_simple_test("B_BFu0i_BFu7c");
    static B_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "B_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "B_BFu0i_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu7c(Test_B_BFu0i_BFu7c, "B_BFu0i_BFu7c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu7i()
{
  {
    init_simple_test("B_BFu0i_BFu7i");
    static B_BFu0i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "B_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "B_BFu0i_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu7i(Test_B_BFu0i_BFu7i, "B_BFu0i_BFu7i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu7ll()
{
  {
    init_simple_test("B_BFu0i_BFu7ll");
    static B_BFu0i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "B_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "B_BFu0i_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu7ll(Test_B_BFu0i_BFu7ll, "B_BFu0i_BFu7ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu7s()
{
  {
    init_simple_test("B_BFu0i_BFu7s");
    static B_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "B_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "B_BFu0i_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu7s(Test_B_BFu0i_BFu7s, "B_BFu0i_BFu7s", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu8c()
{
  {
    init_simple_test("B_BFu0i_BFu8c");
    static B_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "B_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "B_BFu0i_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu8c(Test_B_BFu0i_BFu8c, "B_BFu0i_BFu8c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu8i()
{
  {
    init_simple_test("B_BFu0i_BFu8i");
    static B_BFu0i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "B_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "B_BFu0i_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu8i(Test_B_BFu0i_BFu8i, "B_BFu0i_BFu8i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu8ll()
{
  {
    init_simple_test("B_BFu0i_BFu8ll");
    static B_BFu0i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "B_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "B_BFu0i_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu8ll(Test_B_BFu0i_BFu8ll, "B_BFu0i_BFu8ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu8s()
{
  {
    init_simple_test("B_BFu0i_BFu8s");
    static B_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "B_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "B_BFu0i_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu8s(Test_B_BFu0i_BFu8s, "B_BFu0i_BFu8s", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu9i()
{
  {
    init_simple_test("B_BFu0i_BFu9i");
    static B_BFu0i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, 1, "B_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, hide_ull(1LL<<8), "B_BFu0i_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu9i(Test_B_BFu0i_BFu9i, "B_BFu0i_BFu9i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu9ll()
{
  {
    init_simple_test("B_BFu0i_BFu9ll");
    static B_BFu0i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, 1, "B_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, hide_ull(1LL<<8), "B_BFu0i_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu9ll(Test_B_BFu0i_BFu9ll, "B_BFu0i_BFu9ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_BFu9s()
{
  {
    init_simple_test("B_BFu0i_BFu9s");
    static B_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu0i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, 1, "B_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, hide_ull(1LL<<8), "B_BFu0i_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu0i_BFu9s(Test_B_BFu0i_BFu9s, "B_BFu0i_BFu9s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_C()
{
  {
    init_simple_test("B_BFu0i_C");
    static B_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_C)");
    check_field_offset(lv, v1, 0, "B_BFu0i_C.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "B_BFu0i_C.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0i_C(Test_B_BFu0i_C, "B_BFu0i_C", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_D()
{
  {
    init_simple_test("B_BFu0i_D");
    static B_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(B_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_D)");
    check_field_offset(lv, v1, 0, "B_BFu0i_D.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "B_BFu0i_D.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0i_D(Test_B_BFu0i_D, "B_BFu0i_D", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_F()
{
  {
    init_simple_test("B_BFu0i_F");
    static B_BFu0i_F lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu0i_F)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_F)");
    check_field_offset(lv, v1, 0, "B_BFu0i_F.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "B_BFu0i_F.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0i_F(Test_B_BFu0i_F, "B_BFu0i_F", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_I()
{
  {
    init_simple_test("B_BFu0i_I");
    static B_BFu0i_I lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu0i_I)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_I)");
    check_field_offset(lv, v1, 0, "B_BFu0i_I.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "B_BFu0i_I.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0i_I(Test_B_BFu0i_I, "B_BFu0i_I", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_Ip()
{
  {
    init_simple_test("B_BFu0i_Ip");
    static B_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(B_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu0i_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "B_BFu0i_Ip.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0i_Ip(Test_B_BFu0i_Ip, "B_BFu0i_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_L()
{
  {
    init_simple_test("B_BFu0i_L");
    static B_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(B_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_L)");
    check_field_offset(lv, v1, 0, "B_BFu0i_L.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "B_BFu0i_L.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0i_L(Test_B_BFu0i_L, "B_BFu0i_L", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_S()
{
  {
    init_simple_test("B_BFu0i_S");
    static B_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0i_S)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_S)");
    check_field_offset(lv, v1, 0, "B_BFu0i_S.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "B_BFu0i_S.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0i_S(Test_B_BFu0i_S, "B_BFu0i_S", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_Uc()
{
  {
    init_simple_test("B_BFu0i_Uc");
    static B_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0i_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu0i_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "B_BFu0i_Uc.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0i_Uc(Test_B_BFu0i_Uc, "B_BFu0i_Uc", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_Ui()
{
  {
    init_simple_test("B_BFu0i_Ui");
    static B_BFu0i_Ui lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu0i_Ui)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu0i_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "B_BFu0i_Ui.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0i_Ui(Test_B_BFu0i_Ui, "B_BFu0i_Ui", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_Ul()
{
  {
    init_simple_test("B_BFu0i_Ul");
    static B_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(B_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu0i_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "B_BFu0i_Ul.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0i_Ul(Test_B_BFu0i_Ul, "B_BFu0i_Ul", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_Us()
{
  {
    init_simple_test("B_BFu0i_Us");
    static B_BFu0i_Us lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0i_Us)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_Us)");
    check_field_offset(lv, v1, 0, "B_BFu0i_Us.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "B_BFu0i_Us.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0i_Us(Test_B_BFu0i_Us, "B_BFu0i_Us", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0i_Vp()
{
  {
    init_simple_test("B_BFu0i_Vp");
    static B_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(B_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0i_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu0i_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "B_BFu0i_Vp.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0i_Vp(Test_B_BFu0i_Vp, "B_BFu0i_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll()
{
  {
    init_simple_test("B_BFu0ll");
    static B_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0ll(Test_B_BFu0ll, "B_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_B()
{
  {
    init_simple_test("B_BFu0ll_B");
    static B_BFu0ll_B lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_B)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_B)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "B_BFu0ll_B.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_B(Test_B_BFu0ll_B, "B_BFu0ll_B", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu0c()
{
  {
    init_simple_test("B_BFu0ll_BFu0c");
    static B_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu0c(Test_B_BFu0ll_BFu0c, "B_BFu0ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu0i()
{
  {
    init_simple_test("B_BFu0ll_BFu0i");
    static B_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu0i(Test_B_BFu0ll_BFu0i, "B_BFu0ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu0ll()
{
  {
    init_simple_test("B_BFu0ll_BFu0ll");
    static B_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu0ll(Test_B_BFu0ll_BFu0ll, "B_BFu0ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu0s()
{
  {
    init_simple_test("B_BFu0ll_BFu0s");
    static B_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu0s(Test_B_BFu0ll_BFu0s, "B_BFu0ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu15i()
{
  {
    init_simple_test("B_BFu0ll_BFu15i");
    static B_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "B_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "B_BFu0ll_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu15i(Test_B_BFu0ll_BFu15i, "B_BFu0ll_BFu15i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu15ll()
{
  {
    init_simple_test("B_BFu0ll_BFu15ll");
    static B_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "B_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "B_BFu0ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu15ll(Test_B_BFu0ll_BFu15ll, "B_BFu0ll_BFu15ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu15s()
{
  {
    init_simple_test("B_BFu0ll_BFu15s");
    static B_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "B_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "B_BFu0ll_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu15s(Test_B_BFu0ll_BFu15s, "B_BFu0ll_BFu15s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu16i()
{
  {
    init_simple_test("B_BFu0ll_BFu16i");
    static B_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "B_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "B_BFu0ll_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu16i(Test_B_BFu0ll_BFu16i, "B_BFu0ll_BFu16i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu16ll()
{
  {
    init_simple_test("B_BFu0ll_BFu16ll");
    static B_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "B_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "B_BFu0ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu16ll(Test_B_BFu0ll_BFu16ll, "B_BFu0ll_BFu16ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu16s()
{
  {
    init_simple_test("B_BFu0ll_BFu16s");
    static B_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "B_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "B_BFu0ll_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu16s(Test_B_BFu0ll_BFu16s, "B_BFu0ll_BFu16s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu17i()
{
  {
    init_simple_test("B_BFu0ll_BFu17i");
    static B_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "B_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "B_BFu0ll_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu17i(Test_B_BFu0ll_BFu17i, "B_BFu0ll_BFu17i", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu17ll()
{
  {
    init_simple_test("B_BFu0ll_BFu17ll");
    static B_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "B_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "B_BFu0ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu17ll(Test_B_BFu0ll_BFu17ll, "B_BFu0ll_BFu17ll", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu1c()
{
  {
    init_simple_test("B_BFu0ll_BFu1c");
    static B_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "B_BFu0ll_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu1c(Test_B_BFu0ll_BFu1c, "B_BFu0ll_BFu1c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu1i()
{
  {
    init_simple_test("B_BFu0ll_BFu1i");
    static B_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "B_BFu0ll_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu1i(Test_B_BFu0ll_BFu1i, "B_BFu0ll_BFu1i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu1ll()
{
  {
    init_simple_test("B_BFu0ll_BFu1ll");
    static B_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "B_BFu0ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu1ll(Test_B_BFu0ll_BFu1ll, "B_BFu0ll_BFu1ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu1s()
{
  {
    init_simple_test("B_BFu0ll_BFu1s");
    static B_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "B_BFu0ll_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu1s(Test_B_BFu0ll_BFu1s, "B_BFu0ll_BFu1s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu31i()
{
  {
    init_simple_test("B_BFu0ll_BFu31i");
    static B_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(B_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "B_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "B_BFu0ll_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu31i(Test_B_BFu0ll_BFu31i, "B_BFu0ll_BFu31i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu31ll()
{
  {
    init_simple_test("B_BFu0ll_BFu31ll");
    static B_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(B_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "B_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "B_BFu0ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu31ll(Test_B_BFu0ll_BFu31ll, "B_BFu0ll_BFu31ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu32i()
{
  {
    init_simple_test("B_BFu0ll_BFu32i");
    static B_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(B_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "B_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "B_BFu0ll_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu32i(Test_B_BFu0ll_BFu32i, "B_BFu0ll_BFu32i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu32ll()
{
  {
    init_simple_test("B_BFu0ll_BFu32ll");
    static B_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(B_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "B_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "B_BFu0ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu32ll(Test_B_BFu0ll_BFu32ll, "B_BFu0ll_BFu32ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu33()
{
  {
    init_simple_test("B_BFu0ll_BFu33");
    static B_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "B_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "B_BFu0ll_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu33(Test_B_BFu0ll_BFu33, "B_BFu0ll_BFu33", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu7c()
{
  {
    init_simple_test("B_BFu0ll_BFu7c");
    static B_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "B_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "B_BFu0ll_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu7c(Test_B_BFu0ll_BFu7c, "B_BFu0ll_BFu7c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu7i()
{
  {
    init_simple_test("B_BFu0ll_BFu7i");
    static B_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "B_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "B_BFu0ll_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu7i(Test_B_BFu0ll_BFu7i, "B_BFu0ll_BFu7i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu7ll()
{
  {
    init_simple_test("B_BFu0ll_BFu7ll");
    static B_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "B_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "B_BFu0ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu7ll(Test_B_BFu0ll_BFu7ll, "B_BFu0ll_BFu7ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu7s()
{
  {
    init_simple_test("B_BFu0ll_BFu7s");
    static B_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "B_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "B_BFu0ll_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu7s(Test_B_BFu0ll_BFu7s, "B_BFu0ll_BFu7s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu8c()
{
  {
    init_simple_test("B_BFu0ll_BFu8c");
    static B_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "B_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "B_BFu0ll_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu8c(Test_B_BFu0ll_BFu8c, "B_BFu0ll_BFu8c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu8i()
{
  {
    init_simple_test("B_BFu0ll_BFu8i");
    static B_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "B_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "B_BFu0ll_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu8i(Test_B_BFu0ll_BFu8i, "B_BFu0ll_BFu8i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu8ll()
{
  {
    init_simple_test("B_BFu0ll_BFu8ll");
    static B_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "B_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "B_BFu0ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu8ll(Test_B_BFu0ll_BFu8ll, "B_BFu0ll_BFu8ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu8s()
{
  {
    init_simple_test("B_BFu0ll_BFu8s");
    static B_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "B_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "B_BFu0ll_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu8s(Test_B_BFu0ll_BFu8s, "B_BFu0ll_BFu8s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu9i()
{
  {
    init_simple_test("B_BFu0ll_BFu9i");
    static B_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "B_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "B_BFu0ll_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu9i(Test_B_BFu0ll_BFu9i, "B_BFu0ll_BFu9i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu9ll()
{
  {
    init_simple_test("B_BFu0ll_BFu9ll");
    static B_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "B_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "B_BFu0ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu9ll(Test_B_BFu0ll_BFu9ll, "B_BFu0ll_BFu9ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_BFu9s()
{
  {
    init_simple_test("B_BFu0ll_BFu9s");
    static B_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "B_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "B_BFu0ll_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_BFu9s(Test_B_BFu0ll_BFu9s, "B_BFu0ll_BFu9s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_C()
{
  {
    init_simple_test("B_BFu0ll_C");
    static B_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_C)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "B_BFu0ll_C.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_C(Test_B_BFu0ll_C, "B_BFu0ll_C", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_D()
{
  {
    init_simple_test("B_BFu0ll_D");
    static B_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_D)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "B_BFu0ll_D.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_D(Test_B_BFu0ll_D, "B_BFu0ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_F()
{
  {
    init_simple_test("B_BFu0ll_F");
    static B_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(B_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_F)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "B_BFu0ll_F.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_F(Test_B_BFu0ll_F, "B_BFu0ll_F", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_I()
{
  {
    init_simple_test("B_BFu0ll_I");
    static B_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(B_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_I)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "B_BFu0ll_I.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_I(Test_B_BFu0ll_I, "B_BFu0ll_I", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_Ip()
{
  {
    init_simple_test("B_BFu0ll_Ip");
    static B_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "B_BFu0ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_Ip(Test_B_BFu0ll_Ip, "B_BFu0ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_L()
{
  {
    init_simple_test("B_BFu0ll_L");
    static B_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_L)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "B_BFu0ll_L.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_L(Test_B_BFu0ll_L, "B_BFu0ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_S()
{
  {
    init_simple_test("B_BFu0ll_S");
    static B_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_S)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "B_BFu0ll_S.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_S(Test_B_BFu0ll_S, "B_BFu0ll_S", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_Uc()
{
  {
    init_simple_test("B_BFu0ll_Uc");
    static B_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "B_BFu0ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_Uc(Test_B_BFu0ll_Uc, "B_BFu0ll_Uc", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_Ui()
{
  {
    init_simple_test("B_BFu0ll_Ui");
    static B_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(B_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "B_BFu0ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_Ui(Test_B_BFu0ll_Ui, "B_BFu0ll_Ui", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_Ul()
{
  {
    init_simple_test("B_BFu0ll_Ul");
    static B_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "B_BFu0ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_Ul(Test_B_BFu0ll_Ul, "B_BFu0ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_Us()
{
  {
    init_simple_test("B_BFu0ll_Us");
    static B_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_Us)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "B_BFu0ll_Us.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_Us(Test_B_BFu0ll_Us, "B_BFu0ll_Us", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0ll_Vp()
{
  {
    init_simple_test("B_BFu0ll_Vp");
    static B_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0ll_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu0ll_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "B_BFu0ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0ll_Vp(Test_B_BFu0ll_Vp, "B_BFu0ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s()
{
  {
    init_simple_test("B_BFu0s");
    static B_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(B_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0s(Test_B_BFu0s, "B_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_B()
{
  {
    init_simple_test("B_BFu0s_B");
    static B_BFu0s_B lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_B)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_B)");
    check_field_offset(lv, v1, 0, "B_BFu0s_B.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "B_BFu0s_B.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0s_B(Test_B_BFu0s_B, "B_BFu0s_B", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu0c()
{
  {
    init_simple_test("B_BFu0s_BFu0c");
    static B_BFu0s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(B_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu0c(Test_B_BFu0s_BFu0c, "B_BFu0s_BFu0c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu0i()
{
  {
    init_simple_test("B_BFu0s_BFu0i");
    static B_BFu0s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu0i(Test_B_BFu0s_BFu0i, "B_BFu0s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu0ll()
{
  {
    init_simple_test("B_BFu0s_BFu0ll");
    static B_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu0ll(Test_B_BFu0s_BFu0ll, "B_BFu0s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu0s()
{
  {
    init_simple_test("B_BFu0s_BFu0s");
    static B_BFu0s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(B_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu0s(Test_B_BFu0s_BFu0s, "B_BFu0s_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu15i()
{
  {
    init_simple_test("B_BFu0s_BFu15i");
    static B_BFu0s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, 1, "B_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, hide_ull(1LL<<14), "B_BFu0s_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu15i(Test_B_BFu0s_BFu15i, "B_BFu0s_BFu15i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu15ll()
{
  {
    init_simple_test("B_BFu0s_BFu15ll");
    static B_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, 1, "B_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, hide_ull(1LL<<14), "B_BFu0s_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu15ll(Test_B_BFu0s_BFu15ll, "B_BFu0s_BFu15ll", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu15s()
{
  {
    init_simple_test("B_BFu0s_BFu15s");
    static B_BFu0s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, 1, "B_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, hide_ull(1LL<<14), "B_BFu0s_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu15s(Test_B_BFu0s_BFu15s, "B_BFu0s_BFu15s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu16i()
{
  {
    init_simple_test("B_BFu0s_BFu16i");
    static B_BFu0s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, 1, "B_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, hide_ull(1LL<<15), "B_BFu0s_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu16i(Test_B_BFu0s_BFu16i, "B_BFu0s_BFu16i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu16ll()
{
  {
    init_simple_test("B_BFu0s_BFu16ll");
    static B_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, 1, "B_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, hide_ull(1LL<<15), "B_BFu0s_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu16ll(Test_B_BFu0s_BFu16ll, "B_BFu0s_BFu16ll", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu16s()
{
  {
    init_simple_test("B_BFu0s_BFu16s");
    static B_BFu0s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, 1, "B_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, hide_ull(1LL<<15), "B_BFu0s_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu16s(Test_B_BFu0s_BFu16s, "B_BFu0s_BFu16s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu17i()
{
  {
    init_simple_test("B_BFu0s_BFu17i");
    static B_BFu0s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 17, 1, "B_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 17, hide_ull(1LL<<16), "B_BFu0s_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu17i(Test_B_BFu0s_BFu17i, "B_BFu0s_BFu17i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu17ll()
{
  {
    init_simple_test("B_BFu0s_BFu17ll");
    static B_BFu0s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(B_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 17, 1, "B_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 17, hide_ull(1LL<<16), "B_BFu0s_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu17ll(Test_B_BFu0s_BFu17ll, "B_BFu0s_BFu17ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu1c()
{
  {
    init_simple_test("B_BFu0s_BFu1c");
    static B_BFu0s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 1, 1, "B_BFu0s_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu1c(Test_B_BFu0s_BFu1c, "B_BFu0s_BFu1c", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu1i()
{
  {
    init_simple_test("B_BFu0s_BFu1i");
    static B_BFu0s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 1, 1, "B_BFu0s_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu1i(Test_B_BFu0s_BFu1i, "B_BFu0s_BFu1i", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu1ll()
{
  {
    init_simple_test("B_BFu0s_BFu1ll");
    static B_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 1, 1, "B_BFu0s_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu1ll(Test_B_BFu0s_BFu1ll, "B_BFu0s_BFu1ll", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu1s()
{
  {
    init_simple_test("B_BFu0s_BFu1s");
    static B_BFu0s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 1, 1, "B_BFu0s_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu1s(Test_B_BFu0s_BFu1s, "B_BFu0s_BFu1s", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu31i()
{
  {
    init_simple_test("B_BFu0s_BFu31i");
    static B_BFu0s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 31, 1, "B_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 31, hide_ull(1LL<<30), "B_BFu0s_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu31i(Test_B_BFu0s_BFu31i, "B_BFu0s_BFu31i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu31ll()
{
  {
    init_simple_test("B_BFu0s_BFu31ll");
    static B_BFu0s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 31, 1, "B_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 31, hide_ull(1LL<<30), "B_BFu0s_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu31ll(Test_B_BFu0s_BFu31ll, "B_BFu0s_BFu31ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu32i()
{
  {
    init_simple_test("B_BFu0s_BFu32i");
    static B_BFu0s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 32, 1, "B_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 32, hide_ull(1LL<<31), "B_BFu0s_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu32i(Test_B_BFu0s_BFu32i, "B_BFu0s_BFu32i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu32ll()
{
  {
    init_simple_test("B_BFu0s_BFu32ll");
    static B_BFu0s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 32, 1, "B_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 32, hide_ull(1LL<<31), "B_BFu0s_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu32ll(Test_B_BFu0s_BFu32ll, "B_BFu0s_BFu32ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu33()
{
  {
    init_simple_test("B_BFu0s_BFu33");
    static B_BFu0s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(B_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 33, 1, "B_BFu0s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 33, hide_ull(1LL<<32), "B_BFu0s_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu33(Test_B_BFu0s_BFu33, "B_BFu0s_BFu33", ABISELECT(7,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu7c()
{
  {
    init_simple_test("B_BFu0s_BFu7c");
    static B_BFu0s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, 1, "B_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, hide_ull(1LL<<6), "B_BFu0s_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu7c(Test_B_BFu0s_BFu7c, "B_BFu0s_BFu7c", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu7i()
{
  {
    init_simple_test("B_BFu0s_BFu7i");
    static B_BFu0s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, 1, "B_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, hide_ull(1LL<<6), "B_BFu0s_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu7i(Test_B_BFu0s_BFu7i, "B_BFu0s_BFu7i", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu7ll()
{
  {
    init_simple_test("B_BFu0s_BFu7ll");
    static B_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, 1, "B_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, hide_ull(1LL<<6), "B_BFu0s_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu7ll(Test_B_BFu0s_BFu7ll, "B_BFu0s_BFu7ll", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu7s()
{
  {
    init_simple_test("B_BFu0s_BFu7s");
    static B_BFu0s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, 1, "B_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, hide_ull(1LL<<6), "B_BFu0s_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu7s(Test_B_BFu0s_BFu7s, "B_BFu0s_BFu7s", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu8c()
{
  {
    init_simple_test("B_BFu0s_BFu8c");
    static B_BFu0s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, 1, "B_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, hide_ull(1LL<<7), "B_BFu0s_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu8c(Test_B_BFu0s_BFu8c, "B_BFu0s_BFu8c", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu8i()
{
  {
    init_simple_test("B_BFu0s_BFu8i");
    static B_BFu0s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, 1, "B_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, hide_ull(1LL<<7), "B_BFu0s_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu8i(Test_B_BFu0s_BFu8i, "B_BFu0s_BFu8i", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu8ll()
{
  {
    init_simple_test("B_BFu0s_BFu8ll");
    static B_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, 1, "B_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, hide_ull(1LL<<7), "B_BFu0s_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu8ll(Test_B_BFu0s_BFu8ll, "B_BFu0s_BFu8ll", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu8s()
{
  {
    init_simple_test("B_BFu0s_BFu8s");
    static B_BFu0s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, 1, "B_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, hide_ull(1LL<<7), "B_BFu0s_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu8s(Test_B_BFu0s_BFu8s, "B_BFu0s_BFu8s", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu9i()
{
  {
    init_simple_test("B_BFu0s_BFu9i");
    static B_BFu0s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, 1, "B_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, hide_ull(1LL<<8), "B_BFu0s_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu9i(Test_B_BFu0s_BFu9i, "B_BFu0s_BFu9i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu9ll()
{
  {
    init_simple_test("B_BFu0s_BFu9ll");
    static B_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, 1, "B_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, hide_ull(1LL<<8), "B_BFu0s_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu9ll(Test_B_BFu0s_BFu9ll, "B_BFu0s_BFu9ll", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_BFu9s()
{
  {
    init_simple_test("B_BFu0s_BFu9s");
    static B_BFu0s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu0s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, 1, "B_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, hide_ull(1LL<<8), "B_BFu0s_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu0s_BFu9s(Test_B_BFu0s_BFu9s, "B_BFu0s_BFu9s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_C()
{
  {
    init_simple_test("B_BFu0s_C");
    static B_BFu0s_C lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_C)");
    check_field_offset(lv, v1, 0, "B_BFu0s_C.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "B_BFu0s_C.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0s_C(Test_B_BFu0s_C, "B_BFu0s_C", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_D()
{
  {
    init_simple_test("B_BFu0s_D");
    static B_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(B_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_D)");
    check_field_offset(lv, v1, 0, "B_BFu0s_D.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "B_BFu0s_D.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0s_D(Test_B_BFu0s_D, "B_BFu0s_D", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_F()
{
  {
    init_simple_test("B_BFu0s_F");
    static B_BFu0s_F lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0s_F)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_F)");
    check_field_offset(lv, v1, 0, "B_BFu0s_F.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "B_BFu0s_F.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0s_F(Test_B_BFu0s_F, "B_BFu0s_F", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_I()
{
  {
    init_simple_test("B_BFu0s_I");
    static B_BFu0s_I lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0s_I)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_I)");
    check_field_offset(lv, v1, 0, "B_BFu0s_I.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "B_BFu0s_I.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0s_I(Test_B_BFu0s_I, "B_BFu0s_I", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_Ip()
{
  {
    init_simple_test("B_BFu0s_Ip");
    static B_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu0s_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "B_BFu0s_Ip.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0s_Ip(Test_B_BFu0s_Ip, "B_BFu0s_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_L()
{
  {
    init_simple_test("B_BFu0s_L");
    static B_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(B_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_L)");
    check_field_offset(lv, v1, 0, "B_BFu0s_L.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "B_BFu0s_L.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0s_L(Test_B_BFu0s_L, "B_BFu0s_L", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_S()
{
  {
    init_simple_test("B_BFu0s_S");
    static B_BFu0s_S lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0s_S)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_S)");
    check_field_offset(lv, v1, 0, "B_BFu0s_S.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "B_BFu0s_S.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0s_S(Test_B_BFu0s_S, "B_BFu0s_S", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_Uc()
{
  {
    init_simple_test("B_BFu0s_Uc");
    static B_BFu0s_Uc lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(B_BFu0s_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu0s_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "B_BFu0s_Uc.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0s_Uc(Test_B_BFu0s_Uc, "B_BFu0s_Uc", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_Ui()
{
  {
    init_simple_test("B_BFu0s_Ui");
    static B_BFu0s_Ui lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu0s_Ui)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu0s_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "B_BFu0s_Ui.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0s_Ui(Test_B_BFu0s_Ui, "B_BFu0s_Ui", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_Ul()
{
  {
    init_simple_test("B_BFu0s_Ul");
    static B_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(B_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu0s_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "B_BFu0s_Ul.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0s_Ul(Test_B_BFu0s_Ul, "B_BFu0s_Ul", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_Us()
{
  {
    init_simple_test("B_BFu0s_Us");
    static B_BFu0s_Us lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu0s_Us)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_Us)");
    check_field_offset(lv, v1, 0, "B_BFu0s_Us.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "B_BFu0s_Us.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0s_Us(Test_B_BFu0s_Us, "B_BFu0s_Us", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu0s_Vp()
{
  {
    init_simple_test("B_BFu0s_Vp");
    static B_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu0s_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu0s_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "B_BFu0s_Vp.v2");
  }
}
static Arrange_To_Call_Me vB_BFu0s_Vp(Test_B_BFu0s_Vp, "B_BFu0s_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu15i_BFu0c()
{
  {
    init_simple_test("B_BFu15i_BFu0c");
    static B_BFu15i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu15i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu15i_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu0c(Test_B_BFu15i_BFu0c, "B_BFu15i_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu15i_BFu0i()
{
  {
    init_simple_test("B_BFu15i_BFu0i");
    static B_BFu15i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu15i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu15i_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu0i(Test_B_BFu15i_BFu0i, "B_BFu15i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu15i_BFu0ll()
{
  {
    init_simple_test("B_BFu15i_BFu0ll");
    static B_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu15i_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu0ll(Test_B_BFu15i_BFu0ll, "B_BFu15i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu15i_BFu0s()
{
  {
    init_simple_test("B_BFu15i_BFu0s");
    static B_BFu15i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu15i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu15i_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu0s(Test_B_BFu15i_BFu0s, "B_BFu15i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu15ll_BFu0c()
{
  {
    init_simple_test("B_BFu15ll_BFu0c");
    static B_BFu15ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu15ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu15ll_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu0c(Test_B_BFu15ll_BFu0c, "B_BFu15ll_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu15ll_BFu0i()
{
  {
    init_simple_test("B_BFu15ll_BFu0i");
    static B_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu15ll_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu0i(Test_B_BFu15ll_BFu0i, "B_BFu15ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu15ll_BFu0ll()
{
  {
    init_simple_test("B_BFu15ll_BFu0ll");
    static B_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu15ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu0ll(Test_B_BFu15ll_BFu0ll, "B_BFu15ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu15ll_BFu0s()
{
  {
    init_simple_test("B_BFu15ll_BFu0s");
    static B_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu15ll_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu0s(Test_B_BFu15ll_BFu0s, "B_BFu15ll_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu15s_BFu0c()
{
  {
    init_simple_test("B_BFu15s_BFu0c");
    static B_BFu15s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu15s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu15s_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu0c(Test_B_BFu15s_BFu0c, "B_BFu15s_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu15s_BFu0i()
{
  {
    init_simple_test("B_BFu15s_BFu0i");
    static B_BFu15s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu15s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu15s_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu0i(Test_B_BFu15s_BFu0i, "B_BFu15s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu15s_BFu0ll()
{
  {
    init_simple_test("B_BFu15s_BFu0ll");
    static B_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu15s_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu0ll(Test_B_BFu15s_BFu0ll, "B_BFu15s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu15s_BFu0s()
{
  {
    init_simple_test("B_BFu15s_BFu0s");
    static B_BFu15s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu15s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu15s_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu0s(Test_B_BFu15s_BFu0s, "B_BFu15s_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu16i_BFu0c()
{
  {
    init_simple_test("B_BFu16i_BFu0c");
    static B_BFu16i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu16i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu16i_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu0c(Test_B_BFu16i_BFu0c, "B_BFu16i_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu16i_BFu0i()
{
  {
    init_simple_test("B_BFu16i_BFu0i");
    static B_BFu16i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu16i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu16i_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu0i(Test_B_BFu16i_BFu0i, "B_BFu16i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu16i_BFu0ll()
{
  {
    init_simple_test("B_BFu16i_BFu0ll");
    static B_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu16i_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu0ll(Test_B_BFu16i_BFu0ll, "B_BFu16i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu16i_BFu0s()
{
  {
    init_simple_test("B_BFu16i_BFu0s");
    static B_BFu16i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu16i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu16i_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu0s(Test_B_BFu16i_BFu0s, "B_BFu16i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu16ll_BFu0c()
{
  {
    init_simple_test("B_BFu16ll_BFu0c");
    static B_BFu16ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu16ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu16ll_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu0c(Test_B_BFu16ll_BFu0c, "B_BFu16ll_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu16ll_BFu0i()
{
  {
    init_simple_test("B_BFu16ll_BFu0i");
    static B_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu16ll_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu0i(Test_B_BFu16ll_BFu0i, "B_BFu16ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu16ll_BFu0ll()
{
  {
    init_simple_test("B_BFu16ll_BFu0ll");
    static B_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu16ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu0ll(Test_B_BFu16ll_BFu0ll, "B_BFu16ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu16ll_BFu0s()
{
  {
    init_simple_test("B_BFu16ll_BFu0s");
    static B_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu16ll_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu0s(Test_B_BFu16ll_BFu0s, "B_BFu16ll_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu16s_BFu0c()
{
  {
    init_simple_test("B_BFu16s_BFu0c");
    static B_BFu16s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu16s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu16s_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu0c(Test_B_BFu16s_BFu0c, "B_BFu16s_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu16s_BFu0i()
{
  {
    init_simple_test("B_BFu16s_BFu0i");
    static B_BFu16s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu16s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu16s_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu0i(Test_B_BFu16s_BFu0i, "B_BFu16s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu16s_BFu0ll()
{
  {
    init_simple_test("B_BFu16s_BFu0ll");
    static B_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu16s_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu0ll(Test_B_BFu16s_BFu0ll, "B_BFu16s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu16s_BFu0s()
{
  {
    init_simple_test("B_BFu16s_BFu0s");
    static B_BFu16s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu16s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu16s_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu0s(Test_B_BFu16s_BFu0s, "B_BFu16s_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu17i_BFu0c()
{
  {
    init_simple_test("B_BFu17i_BFu0c");
    static B_BFu17i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu17i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu17i_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu0c(Test_B_BFu17i_BFu0c, "B_BFu17i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu17i_BFu0i()
{
  {
    init_simple_test("B_BFu17i_BFu0i");
    static B_BFu17i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu17i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu17i_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu0i(Test_B_BFu17i_BFu0i, "B_BFu17i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu17i_BFu0ll()
{
  {
    init_simple_test("B_BFu17i_BFu0ll");
    static B_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu17i_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu0ll(Test_B_BFu17i_BFu0ll, "B_BFu17i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu17i_BFu0s()
{
  {
    init_simple_test("B_BFu17i_BFu0s");
    static B_BFu17i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu17i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu17i_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu0s(Test_B_BFu17i_BFu0s, "B_BFu17i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu17ll_BFu0c()
{
  {
    init_simple_test("B_BFu17ll_BFu0c");
    static B_BFu17ll_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu17ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu17ll_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu0c(Test_B_BFu17ll_BFu0c, "B_BFu17ll_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu17ll_BFu0i()
{
  {
    init_simple_test("B_BFu17ll_BFu0i");
    static B_BFu17ll_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu17ll_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu0i(Test_B_BFu17ll_BFu0i, "B_BFu17ll_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu17ll_BFu0ll()
{
  {
    init_simple_test("B_BFu17ll_BFu0ll");
    static B_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu17ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu0ll(Test_B_BFu17ll_BFu0ll, "B_BFu17ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu17ll_BFu0s()
{
  {
    init_simple_test("B_BFu17ll_BFu0s");
    static B_BFu17ll_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu17ll_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu0s(Test_B_BFu17ll_BFu0s, "B_BFu17ll_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1c_BFu0c()
{
  {
    init_simple_test("B_BFu1c_BFu0c");
    static B_BFu1c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu1c_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu0c(Test_B_BFu1c_BFu0c, "B_BFu1c_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1c_BFu0i()
{
  {
    init_simple_test("B_BFu1c_BFu0i");
    static B_BFu1c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu1c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu1c_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu0i(Test_B_BFu1c_BFu0i, "B_BFu1c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1c_BFu0ll()
{
  {
    init_simple_test("B_BFu1c_BFu0ll");
    static B_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu1c_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu0ll(Test_B_BFu1c_BFu0ll, "B_BFu1c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1c_BFu0s()
{
  {
    init_simple_test("B_BFu1c_BFu0s");
    static B_BFu1c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu1c_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu0s(Test_B_BFu1c_BFu0s, "B_BFu1c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1i_BFu0c()
{
  {
    init_simple_test("B_BFu1i_BFu0c");
    static B_BFu1i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu1i_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu0c(Test_B_BFu1i_BFu0c, "B_BFu1i_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1i_BFu0i()
{
  {
    init_simple_test("B_BFu1i_BFu0i");
    static B_BFu1i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu1i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu1i_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu0i(Test_B_BFu1i_BFu0i, "B_BFu1i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1i_BFu0ll()
{
  {
    init_simple_test("B_BFu1i_BFu0ll");
    static B_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu1i_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu0ll(Test_B_BFu1i_BFu0ll, "B_BFu1i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1i_BFu0s()
{
  {
    init_simple_test("B_BFu1i_BFu0s");
    static B_BFu1i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu1i_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu0s(Test_B_BFu1i_BFu0s, "B_BFu1i_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1ll_BFu0c()
{
  {
    init_simple_test("B_BFu1ll_BFu0c");
    static B_BFu1ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu1ll_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu0c(Test_B_BFu1ll_BFu0c, "B_BFu1ll_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1ll_BFu0i()
{
  {
    init_simple_test("B_BFu1ll_BFu0i");
    static B_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu1ll_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu0i(Test_B_BFu1ll_BFu0i, "B_BFu1ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1ll_BFu0ll()
{
  {
    init_simple_test("B_BFu1ll_BFu0ll");
    static B_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu1ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu0ll(Test_B_BFu1ll_BFu0ll, "B_BFu1ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1ll_BFu0s()
{
  {
    init_simple_test("B_BFu1ll_BFu0s");
    static B_BFu1ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu1ll_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu0s(Test_B_BFu1ll_BFu0s, "B_BFu1ll_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1s_BFu0c()
{
  {
    init_simple_test("B_BFu1s_BFu0c");
    static B_BFu1s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu1s_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu0c(Test_B_BFu1s_BFu0c, "B_BFu1s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1s_BFu0i()
{
  {
    init_simple_test("B_BFu1s_BFu0i");
    static B_BFu1s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu1s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu1s_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu0i(Test_B_BFu1s_BFu0i, "B_BFu1s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1s_BFu0ll()
{
  {
    init_simple_test("B_BFu1s_BFu0ll");
    static B_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu1s_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu0ll(Test_B_BFu1s_BFu0ll, "B_BFu1s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu1s_BFu0s()
{
  {
    init_simple_test("B_BFu1s_BFu0s");
    static B_BFu1s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu1s_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu0s(Test_B_BFu1s_BFu0s, "B_BFu1s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu31i_BFu0c()
{
  {
    init_simple_test("B_BFu31i_BFu0c");
    static B_BFu31i_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu31i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu31i_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu0c(Test_B_BFu31i_BFu0c, "B_BFu31i_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu31i_BFu0i()
{
  {
    init_simple_test("B_BFu31i_BFu0i");
    static B_BFu31i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu31i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu31i_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu0i(Test_B_BFu31i_BFu0i, "B_BFu31i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu31i_BFu0ll()
{
  {
    init_simple_test("B_BFu31i_BFu0ll");
    static B_BFu31i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu31i_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu0ll(Test_B_BFu31i_BFu0ll, "B_BFu31i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu31i_BFu0s()
{
  {
    init_simple_test("B_BFu31i_BFu0s");
    static B_BFu31i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu31i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu31i_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu0s(Test_B_BFu31i_BFu0s, "B_BFu31i_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu31ll_BFu0c()
{
  {
    init_simple_test("B_BFu31ll_BFu0c");
    static B_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu31ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu31ll_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu0c(Test_B_BFu31ll_BFu0c, "B_BFu31ll_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu31ll_BFu0i()
{
  {
    init_simple_test("B_BFu31ll_BFu0i");
    static B_BFu31ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu31ll_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu0i(Test_B_BFu31ll_BFu0i, "B_BFu31ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu31ll_BFu0ll()
{
  {
    init_simple_test("B_BFu31ll_BFu0ll");
    static B_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu31ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu0ll(Test_B_BFu31ll_BFu0ll, "B_BFu31ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu31ll_BFu0s()
{
  {
    init_simple_test("B_BFu31ll_BFu0s");
    static B_BFu31ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu31ll_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu0s(Test_B_BFu31ll_BFu0s, "B_BFu31ll_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu32i_BFu0c()
{
  {
    init_simple_test("B_BFu32i_BFu0c");
    static B_BFu32i_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu32i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu32i_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu0c(Test_B_BFu32i_BFu0c, "B_BFu32i_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu32i_BFu0i()
{
  {
    init_simple_test("B_BFu32i_BFu0i");
    static B_BFu32i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu32i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu32i_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu0i(Test_B_BFu32i_BFu0i, "B_BFu32i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu32i_BFu0ll()
{
  {
    init_simple_test("B_BFu32i_BFu0ll");
    static B_BFu32i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu32i_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu0ll(Test_B_BFu32i_BFu0ll, "B_BFu32i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu32i_BFu0s()
{
  {
    init_simple_test("B_BFu32i_BFu0s");
    static B_BFu32i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu32i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu32i_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu0s(Test_B_BFu32i_BFu0s, "B_BFu32i_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu32ll_BFu0c()
{
  {
    init_simple_test("B_BFu32ll_BFu0c");
    static B_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu32ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu32ll_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu0c(Test_B_BFu32ll_BFu0c, "B_BFu32ll_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu32ll_BFu0i()
{
  {
    init_simple_test("B_BFu32ll_BFu0i");
    static B_BFu32ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu32ll_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu0i(Test_B_BFu32ll_BFu0i, "B_BFu32ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu32ll_BFu0ll()
{
  {
    init_simple_test("B_BFu32ll_BFu0ll");
    static B_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu32ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu0ll(Test_B_BFu32ll_BFu0ll, "B_BFu32ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu32ll_BFu0s()
{
  {
    init_simple_test("B_BFu32ll_BFu0s");
    static B_BFu32ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(B_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu32ll_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu0s(Test_B_BFu32ll_BFu0s, "B_BFu32ll_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu33_BFu0c()
{
  {
    init_simple_test("B_BFu33_BFu0c");
    static B_BFu33_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu33_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu33_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu0c(Test_B_BFu33_BFu0c, "B_BFu33_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu33_BFu0i()
{
  {
    init_simple_test("B_BFu33_BFu0i");
    static B_BFu33_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu33_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu0i(Test_B_BFu33_BFu0i, "B_BFu33_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu33_BFu0ll()
{
  {
    init_simple_test("B_BFu33_BFu0ll");
    static B_BFu33_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(B_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu33_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu0ll(Test_B_BFu33_BFu0ll, "B_BFu33_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu33_BFu0s()
{
  {
    init_simple_test("B_BFu33_BFu0s");
    static B_BFu33_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu33_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu0s(Test_B_BFu33_BFu0s, "B_BFu33_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7c_BFu0c()
{
  {
    init_simple_test("B_BFu7c_BFu0c");
    static B_BFu7c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu7c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu7c_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu0c(Test_B_BFu7c_BFu0c, "B_BFu7c_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7c_BFu0i()
{
  {
    init_simple_test("B_BFu7c_BFu0i");
    static B_BFu7c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu7c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu7c_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu0i(Test_B_BFu7c_BFu0i, "B_BFu7c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7c_BFu0ll()
{
  {
    init_simple_test("B_BFu7c_BFu0ll");
    static B_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu7c_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu0ll(Test_B_BFu7c_BFu0ll, "B_BFu7c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7c_BFu0s()
{
  {
    init_simple_test("B_BFu7c_BFu0s");
    static B_BFu7c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu7c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu7c_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu0s(Test_B_BFu7c_BFu0s, "B_BFu7c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7i_BFu0c()
{
  {
    init_simple_test("B_BFu7i_BFu0c");
    static B_BFu7i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu7i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu7i_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu0c(Test_B_BFu7i_BFu0c, "B_BFu7i_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7i_BFu0i()
{
  {
    init_simple_test("B_BFu7i_BFu0i");
    static B_BFu7i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu7i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu7i_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu0i(Test_B_BFu7i_BFu0i, "B_BFu7i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7i_BFu0ll()
{
  {
    init_simple_test("B_BFu7i_BFu0ll");
    static B_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu7i_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu0ll(Test_B_BFu7i_BFu0ll, "B_BFu7i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7i_BFu0s()
{
  {
    init_simple_test("B_BFu7i_BFu0s");
    static B_BFu7i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu7i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu7i_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu0s(Test_B_BFu7i_BFu0s, "B_BFu7i_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7ll_BFu0c()
{
  {
    init_simple_test("B_BFu7ll_BFu0c");
    static B_BFu7ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu7ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu7ll_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu0c(Test_B_BFu7ll_BFu0c, "B_BFu7ll_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7ll_BFu0i()
{
  {
    init_simple_test("B_BFu7ll_BFu0i");
    static B_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu7ll_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu0i(Test_B_BFu7ll_BFu0i, "B_BFu7ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7ll_BFu0ll()
{
  {
    init_simple_test("B_BFu7ll_BFu0ll");
    static B_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu7ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu0ll(Test_B_BFu7ll_BFu0ll, "B_BFu7ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7ll_BFu0s()
{
  {
    init_simple_test("B_BFu7ll_BFu0s");
    static B_BFu7ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu7ll_BFu0s)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu0s");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu0s(Test_B_BFu7ll_BFu0s, "B_BFu7ll_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7s_BFu0c()
{
  {
    init_simple_test("B_BFu7s_BFu0c");
    static B_BFu7s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu7s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu7s_BFu0c)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu0c");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu0c(Test_B_BFu7s_BFu0c, "B_BFu7s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7s_BFu0i()
{
  {
    init_simple_test("B_BFu7s_BFu0i");
    static B_BFu7s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(B_BFu7s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B_BFu7s_BFu0i)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu0i");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu0i(Test_B_BFu7s_BFu0i, "B_BFu7s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu7s_BFu0ll()
{
  {
    init_simple_test("B_BFu7s_BFu0ll");
    static B_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(B