// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
#pragma pack(1)
struct B_BFu8i_C { bool v1; unsigned int v2:8; char v3; };
struct B_BFu8i_D { bool v1; unsigned int v2:8; double v3; };
struct B_BFu8i_F { bool v1; unsigned int v2:8; float v3; };
struct B_BFu8i_I { bool v1; unsigned int v2:8; int v3; };
struct B_BFu8i_Ip { bool v1; unsigned int v2:8; int * v3; };
struct B_BFu8i_L { bool v1; unsigned int v2:8; long long v3; };
struct B_BFu8i_S { bool v1; unsigned int v2:8; short v3; };
struct B_BFu8i_Uc { bool v1; unsigned int v2:8; unsigned char v3; };
struct B_BFu8i_Ui { bool v1; unsigned int v2:8; unsigned int v3; };
struct B_BFu8i_Ul { bool v1; unsigned int v2:8; unsigned long long v3; };
struct B_BFu8i_Us { bool v1; unsigned int v2:8; unsigned short v3; };
struct B_BFu8i_Vp { bool v1; unsigned int v2:8; void * v3; };
struct B_BFu8ll { bool v1; unsigned long long v2:8; };
struct B_BFu8ll_B { bool v1; unsigned long long v2:8; bool v3; };
struct B_BFu8ll_BFu15i { bool v1; unsigned long long v2:8; unsigned int v3:15; };
struct B_BFu8ll_BFu15ll { bool v1; unsigned long long v2:8; unsigned long long v3:15; };
struct B_BFu8ll_BFu15s { bool v1; unsigned long long v2:8; unsigned short v3:15; };
struct B_BFu8ll_BFu16i { bool v1; unsigned long long v2:8; unsigned int v3:16; };
struct B_BFu8ll_BFu16ll { bool v1; unsigned long long v2:8; unsigned long long v3:16; };
struct B_BFu8ll_BFu16s { bool v1; unsigned long long v2:8; unsigned short v3:16; };
struct B_BFu8ll_BFu17i { bool v1; unsigned long long v2:8; unsigned int v3:17; };
struct B_BFu8ll_BFu17ll { bool v1; unsigned long long v2:8; unsigned long long v3:17; };
struct B_BFu8ll_BFu1c { bool v1; unsigned long long v2:8; unsigned char v3:1; };
struct B_BFu8ll_BFu1i { bool v1; unsigned long long v2:8; unsigned int v3:1; };
struct B_BFu8ll_BFu1ll { bool v1; unsigned long long v2:8; unsigned long long v3:1; };
struct B_BFu8ll_BFu1s { bool v1; unsigned long long v2:8; unsigned short v3:1; };
struct B_BFu8ll_BFu31i { bool v1; unsigned long long v2:8; unsigned int v3:31; };
struct B_BFu8ll_BFu31ll { bool v1; unsigned long long v2:8; unsigned long long v3:31; };
struct B_BFu8ll_BFu32i { bool v1; unsigned long long v2:8; unsigned int v3:32; };
struct B_BFu8ll_BFu32ll { bool v1; unsigned long long v2:8; unsigned long long v3:32; };
struct B_BFu8ll_BFu33 { bool v1; unsigned long long v2:8; unsigned long long v3:33; };
struct B_BFu8ll_BFu7c { bool v1; unsigned long long v2:8; unsigned char v3:7; };
struct B_BFu8ll_BFu7i { bool v1; unsigned long long v2:8; unsigned int v3:7; };
struct B_BFu8ll_BFu7ll { bool v1; unsigned long long v2:8; unsigned long long v3:7; };
struct B_BFu8ll_BFu7s { bool v1; unsigned long long v2:8; unsigned short v3:7; };
struct B_BFu8ll_BFu8c { bool v1; unsigned long long v2:8; unsigned char v3:8; };
struct B_BFu8ll_BFu8i { bool v1; unsigned long long v2:8; unsigned int v3:8; };
struct B_BFu8ll_BFu8ll { bool v1; unsigned long long v2:8; unsigned long long v3:8; };
struct B_BFu8ll_BFu8s { bool v1; unsigned long long v2:8; unsigned short v3:8; };
struct B_BFu8ll_BFu9i { bool v1; unsigned long long v2:8; unsigned int v3:9; };
struct B_BFu8ll_BFu9ll { bool v1; unsigned long long v2:8; unsigned long long v3:9; };
struct B_BFu8ll_BFu9s { bool v1; unsigned long long v2:8; unsigned short v3:9; };
struct B_BFu8ll_C { bool v1; unsigned long long v2:8; char v3; };
struct B_BFu8ll_D { bool v1; unsigned long long v2:8; double v3; };
struct B_BFu8ll_F { bool v1; unsigned long long v2:8; float v3; };
struct B_BFu8ll_I { bool v1; unsigned long long v2:8; int v3; };
struct B_BFu8ll_Ip { bool v1; unsigned long long v2:8; int * v3; };
struct B_BFu8ll_L { bool v1; unsigned long long v2:8; long long v3; };
struct B_BFu8ll_S { bool v1; unsigned long long v2:8; short v3; };
struct B_BFu8ll_Uc { bool v1; unsigned long long v2:8; unsigned char v3; };
struct B_BFu8ll_Ui { bool v1; unsigned long long v2:8; unsigned int v3; };
struct B_BFu8ll_Ul { bool v1; unsigned long long v2:8; unsigned long long v3; };
struct B_BFu8ll_Us { bool v1; unsigned long long v2:8; unsigned short v3; };
struct B_BFu8ll_Vp { bool v1; unsigned long long v2:8; void * v3; };
struct B_BFu8s { bool v1; unsigned short v2:8; };
struct B_BFu8s_B { bool v1; unsigned short v2:8; bool v3; };
struct B_BFu8s_BFu15i { bool v1; unsigned short v2:8; unsigned int v3:15; };
struct B_BFu8s_BFu15ll { bool v1; unsigned short v2:8; unsigned long long v3:15; };
struct B_BFu8s_BFu15s { bool v1; unsigned short v2:8; unsigned short v3:15; };
struct B_BFu8s_BFu16i { bool v1; unsigned short v2:8; unsigned int v3:16; };
struct B_BFu8s_BFu16ll { bool v1; unsigned short v2:8; unsigned long long v3:16; };
struct B_BFu8s_BFu16s { bool v1; unsigned short v2:8; unsigned short v3:16; };
struct B_BFu8s_BFu17i { bool v1; unsigned short v2:8; unsigned int v3:17; };
struct B_BFu8s_BFu17ll { bool v1; unsigned short v2:8; unsigned long long v3:17; };
struct B_BFu8s_BFu1c { bool v1; unsigned short v2:8; unsigned char v3:1; };
struct B_BFu8s_BFu1i { bool v1; unsigned short v2:8; unsigned int v3:1; };
struct B_BFu8s_BFu1ll { bool v1; unsigned short v2:8; unsigned long long v3:1; };
struct B_BFu8s_BFu1s { bool v1; unsigned short v2:8; unsigned short v3:1; };
struct B_BFu8s_BFu31i { bool v1; unsigned short v2:8; unsigned int v3:31; };
struct B_BFu8s_BFu31ll { bool v1; unsigned short v2:8; unsigned long long v3:31; };
struct B_BFu8s_BFu32i { bool v1; unsigned short v2:8; unsigned int v3:32; };
struct B_BFu8s_BFu32ll { bool v1; unsigned short v2:8; unsigned long long v3:32; };
struct B_BFu8s_BFu33 { bool v1; unsigned short v2:8; unsigned long long v3:33; };
struct B_BFu8s_BFu7c { bool v1; unsigned short v2:8; unsigned char v3:7; };
struct B_BFu8s_BFu7i { bool v1; unsigned short v2:8; unsigned int v3:7; };
struct B_BFu8s_BFu7ll { bool v1; unsigned short v2:8; unsigned long long v3:7; };
struct B_BFu8s_BFu7s { bool v1; unsigned short v2:8; unsigned short v3:7; };
struct B_BFu8s_BFu8c { bool v1; unsigned short v2:8; unsigned char v3:8; };
struct B_BFu8s_BFu8i { bool v1; unsigned short v2:8; unsigned int v3:8; };
struct B_BFu8s_BFu8ll { bool v1; unsigned short v2:8; unsigned long long v3:8; };
struct B_BFu8s_BFu8s { bool v1; unsigned short v2:8; unsigned short v3:8; };
struct B_BFu8s_BFu9i { bool v1; unsigned short v2:8; unsigned int v3:9; };
struct B_BFu8s_BFu9ll { bool v1; unsigned short v2:8; unsigned long long v3:9; };
struct B_BFu8s_BFu9s { bool v1; unsigned short v2:8; unsigned short v3:9; };
struct B_BFu8s_C { bool v1; unsigned short v2:8; char v3; };
struct B_BFu8s_D { bool v1; unsigned short v2:8; double v3; };
struct B_BFu8s_F { bool v1; unsigned short v2:8; float v3; };
struct B_BFu8s_I { bool v1; unsigned short v2:8; int v3; };
struct B_BFu8s_Ip { bool v1; unsigned short v2:8; int * v3; };
struct B_BFu8s_L { bool v1; unsigned short v2:8; long long v3; };
struct B_BFu8s_S { bool v1; unsigned short v2:8; short v3; };
struct B_BFu8s_Uc { bool v1; unsigned short v2:8; unsigned char v3; };
struct B_BFu8s_Ui { bool v1; unsigned short v2:8; unsigned int v3; };
struct B_BFu8s_Ul { bool v1; unsigned short v2:8; unsigned long long v3; };
struct B_BFu8s_Us { bool v1; unsigned short v2:8; unsigned short v3; };
struct B_BFu8s_Vp { bool v1; unsigned short v2:8; void * v3; };
struct B_BFu9i { bool v1; unsigned int v2:9; };
struct B_BFu9i_B { bool v1; unsigned int v2:9; bool v3; };
struct B_BFu9i_BFu15i { bool v1; unsigned int v2:9; unsigned int v3:15; };
struct B_BFu9i_BFu15ll { bool v1; unsigned int v2:9; unsigned long long v3:15; };
struct B_BFu9i_BFu15s { bool v1; unsigned int v2:9; unsigned short v3:15; };
struct B_BFu9i_BFu16i { bool v1; unsigned int v2:9; unsigned int v3:16; };
struct B_BFu9i_BFu16ll { bool v1; unsigned int v2:9; unsigned long long v3:16; };
struct B_BFu9i_BFu16s { bool v1; unsigned int v2:9; unsigned short v3:16; };
struct B_BFu9i_BFu17i { bool v1; unsigned int v2:9; unsigned int v3:17; };
struct B_BFu9i_BFu17ll { bool v1; unsigned int v2:9; unsigned long long v3:17; };
struct B_BFu9i_BFu1c { bool v1; unsigned int v2:9; unsigned char v3:1; };
struct B_BFu9i_BFu1i { bool v1; unsigned int v2:9; unsigned int v3:1; };
struct B_BFu9i_BFu1ll { bool v1; unsigned int v2:9; unsigned long long v3:1; };
struct B_BFu9i_BFu1s { bool v1; unsigned int v2:9; unsigned short v3:1; };
struct B_BFu9i_BFu31i { bool v1; unsigned int v2:9; unsigned int v3:31; };
struct B_BFu9i_BFu31ll { bool v1; unsigned int v2:9; unsigned long long v3:31; };
struct B_BFu9i_BFu32i { bool v1; unsigned int v2:9; unsigned int v3:32; };
struct B_BFu9i_BFu32ll { bool v1; unsigned int v2:9; unsigned long long v3:32; };
struct B_BFu9i_BFu33 { bool v1; unsigned int v2:9; unsigned long long v3:33; };
struct B_BFu9i_BFu7c { bool v1; unsigned int v2:9; unsigned char v3:7; };
struct B_BFu9i_BFu7i { bool v1; unsigned int v2:9; unsigned int v3:7; };
struct B_BFu9i_BFu7ll { bool v1; unsigned int v2:9; unsigned long long v3:7; };
struct B_BFu9i_BFu7s { bool v1; unsigned int v2:9; unsigned short v3:7; };
struct B_BFu9i_BFu8c { bool v1; unsigned int v2:9; unsigned char v3:8; };
struct B_BFu9i_BFu8i { bool v1; unsigned int v2:9; unsigned int v3:8; };
struct B_BFu9i_BFu8ll { bool v1; unsigned int v2:9; unsigned long long v3:8; };
struct B_BFu9i_BFu8s { bool v1; unsigned int v2:9; unsigned short v3:8; };
struct B_BFu9i_BFu9i { bool v1; unsigned int v2:9; unsigned int v3:9; };
struct B_BFu9i_BFu9ll { bool v1; unsigned int v2:9; unsigned long long v3:9; };
struct B_BFu9i_BFu9s { bool v1; unsigned int v2:9; unsigned short v3:9; };
struct B_BFu9i_C { bool v1; unsigned int v2:9; char v3; };
struct B_BFu9i_D { bool v1; unsigned int v2:9; double v3; };
struct B_BFu9i_F { bool v1; unsigned int v2:9; float v3; };
struct B_BFu9i_I { bool v1; unsigned int v2:9; int v3; };
struct B_BFu9i_Ip { bool v1; unsigned int v2:9; int * v3; };
struct B_BFu9i_L { bool v1; unsigned int v2:9; long long v3; };
struct B_BFu9i_S { bool v1; unsigned int v2:9; short v3; };
struct B_BFu9i_Uc { bool v1; unsigned int v2:9; unsigned char v3; };
struct B_BFu9i_Ui { bool v1; unsigned int v2:9; unsigned int v3; };
struct B_BFu9i_Ul { bool v1; unsigned int v2:9; unsigned long long v3; };
struct B_BFu9i_Us { bool v1; unsigned int v2:9; unsigned short v3; };
struct B_BFu9i_Vp { bool v1; unsigned int v2:9; void * v3; };
struct B_BFu9ll { bool v1; unsigned long long v2:9; };
struct B_BFu9ll_B { bool v1; unsigned long long v2:9; bool v3; };
struct B_BFu9ll_BFu15i { bool v1; unsigned long long v2:9; unsigned int v3:15; };
struct B_BFu9ll_BFu15ll { bool v1; unsigned long long v2:9; unsigned long long v3:15; };
struct B_BFu9ll_BFu15s { bool v1; unsigned long long v2:9; unsigned short v3:15; };
struct B_BFu9ll_BFu16i { bool v1; unsigned long long v2:9; unsigned int v3:16; };
struct B_BFu9ll_BFu16ll { bool v1; unsigned long long v2:9; unsigned long long v3:16; };
struct B_BFu9ll_BFu16s { bool v1; unsigned long long v2:9; unsigned short v3:16; };
struct B_BFu9ll_BFu17i { bool v1; unsigned long long v2:9; unsigned int v3:17; };
struct B_BFu9ll_BFu17ll { bool v1; unsigned long long v2:9; unsigned long long v3:17; };
struct B_BFu9ll_BFu1c { bool v1; unsigned long long v2:9; unsigned char v3:1; };
struct B_BFu9ll_BFu1i { bool v1; unsigned long long v2:9; unsigned int v3:1; };
struct B_BFu9ll_BFu1ll { bool v1; unsigned long long v2:9; unsigned long long v3:1; };
struct B_BFu9ll_BFu1s { bool v1; unsigned long long v2:9; unsigned short v3:1; };
struct B_BFu9ll_BFu31i { bool v1; unsigned long long v2:9; unsigned int v3:31; };
struct B_BFu9ll_BFu31ll { bool v1; unsigned long long v2:9; unsigned long long v3:31; };
struct B_BFu9ll_BFu32i { bool v1; unsigned long long v2:9; unsigned int v3:32; };
struct B_BFu9ll_BFu32ll { bool v1; unsigned long long v2:9; unsigned long long v3:32; };
struct B_BFu9ll_BFu33 { bool v1; unsigned long long v2:9; unsigned long long v3:33; };
struct B_BFu9ll_BFu7c { bool v1; unsigned long long v2:9; unsigned char v3:7; };
struct B_BFu9ll_BFu7i { bool v1; unsigned long long v2:9; unsigned int v3:7; };
struct B_BFu9ll_BFu7ll { bool v1; unsigned long long v2:9; unsigned long long v3:7; };
struct B_BFu9ll_BFu7s { bool v1; unsigned long long v2:9; unsigned short v3:7; };
struct B_BFu9ll_BFu8c { bool v1; unsigned long long v2:9; unsigned char v3:8; };
struct B_BFu9ll_BFu8i { bool v1; unsigned long long v2:9; unsigned int v3:8; };
struct B_BFu9ll_BFu8ll { bool v1; unsigned long long v2:9; unsigned long long v3:8; };
struct B_BFu9ll_BFu8s { bool v1; unsigned long long v2:9; unsigned short v3:8; };
struct B_BFu9ll_BFu9i { bool v1; unsigned long long v2:9; unsigned int v3:9; };
struct B_BFu9ll_BFu9ll { bool v1; unsigned long long v2:9; unsigned long long v3:9; };
struct B_BFu9ll_BFu9s { bool v1; unsigned long long v2:9; unsigned short v3:9; };
struct B_BFu9ll_C { bool v1; unsigned long long v2:9; char v3; };
struct B_BFu9ll_D { bool v1; unsigned long long v2:9; double v3; };
struct B_BFu9ll_F { bool v1; unsigned long long v2:9; float v3; };
struct B_BFu9ll_I { bool v1; unsigned long long v2:9; int v3; };
struct B_BFu9ll_Ip { bool v1; unsigned long long v2:9; int * v3; };
struct B_BFu9ll_L { bool v1; unsigned long long v2:9; long long v3; };
struct B_BFu9ll_S { bool v1; unsigned long long v2:9; short v3; };
struct B_BFu9ll_Uc { bool v1; unsigned long long v2:9; unsigned char v3; };
struct B_BFu9ll_Ui { bool v1; unsigned long long v2:9; unsigned int v3; };
struct B_BFu9ll_Ul { bool v1; unsigned long long v2:9; unsigned long long v3; };
struct B_BFu9ll_Us { bool v1; unsigned long long v2:9; unsigned short v3; };
struct B_BFu9ll_Vp { bool v1; unsigned long long v2:9; void * v3; };
struct B_BFu9s { bool v1; unsigned short v2:9; };
struct B_BFu9s_B { bool v1; unsigned short v2:9; bool v3; };
struct B_BFu9s_BFu15i { bool v1; unsigned short v2:9; unsigned int v3:15; };
struct B_BFu9s_BFu15ll { bool v1; unsigned short v2:9; unsigned long long v3:15; };
struct B_BFu9s_BFu15s { bool v1; unsigned short v2:9; unsigned short v3:15; };
struct B_BFu9s_BFu16i { bool v1; unsigned short v2:9; unsigned int v3:16; };
struct B_BFu9s_BFu16ll { bool v1; unsigned short v2:9; unsigned long long v3:16; };
struct B_BFu9s_BFu16s { bool v1; unsigned short v2:9; unsigned short v3:16; };
struct B_BFu9s_BFu17i { bool v1; unsigned short v2:9; unsigned int v3:17; };
struct B_BFu9s_BFu17ll { bool v1; unsigned short v2:9; unsigned long long v3:17; };
struct B_BFu9s_BFu1c { bool v1; unsigned short v2:9; unsigned char v3:1; };
struct B_BFu9s_BFu1i { bool v1; unsigned short v2:9; unsigned int v3:1; };
struct B_BFu9s_BFu1ll { bool v1; unsigned short v2:9; unsigned long long v3:1; };
struct B_BFu9s_BFu1s { bool v1; unsigned short v2:9; unsigned short v3:1; };
struct B_BFu9s_BFu31i { bool v1; unsigned short v2:9; unsigned int v3:31; };
struct B_BFu9s_BFu31ll { bool v1; unsigned short v2:9; unsigned long long v3:31; };
struct B_BFu9s_BFu32i { bool v1; unsigned short v2:9; unsigned int v3:32; };
struct B_BFu9s_BFu32ll { bool v1; unsigned short v2:9; unsigned long long v3:32; };
struct B_BFu9s_BFu33 { bool v1; unsigned short v2:9; unsigned long long v3:33; };
struct B_BFu9s_BFu7c { bool v1; unsigned short v2:9; unsigned char v3:7; };
struct B_BFu9s_BFu7i { bool v1; unsigned short v2:9; unsigned int v3:7; };
struct B_BFu9s_BFu7ll { bool v1; unsigned short v2:9; unsigned long long v3:7; };
struct B_BFu9s_BFu7s { bool v1; unsigned short v2:9; unsigned short v3:7; };
struct B_BFu9s_BFu8c { bool v1; unsigned short v2:9; unsigned char v3:8; };
struct B_BFu9s_BFu8i { bool v1; unsigned short v2:9; unsigned int v3:8; };
struct B_BFu9s_BFu8ll { bool v1; unsigned short v2:9; unsigned long long v3:8; };
struct B_BFu9s_BFu8s { bool v1; unsigned short v2:9; unsigned short v3:8; };
struct B_BFu9s_BFu9i { bool v1; unsigned short v2:9; unsigned int v3:9; };
struct B_BFu9s_BFu9ll { bool v1; unsigned short v2:9; unsigned long long v3:9; };
struct B_BFu9s_BFu9s { bool v1; unsigned short v2:9; unsigned short v3:9; };
struct B_BFu9s_C { bool v1; unsigned short v2:9; char v3; };
struct B_BFu9s_D { bool v1; unsigned short v2:9; double v3; };
struct B_BFu9s_F { bool v1; unsigned short v2:9; float v3; };
struct B_BFu9s_I { bool v1; unsigned short v2:9; int v3; };
struct B_BFu9s_Ip { bool v1; unsigned short v2:9; int * v3; };
struct B_BFu9s_L { bool v1; unsigned short v2:9; long long v3; };
struct B_BFu9s_S { bool v1; unsigned short v2:9; short v3; };
struct B_BFu9s_Uc { bool v1; unsigned short v2:9; unsigned char v3; };
struct B_BFu9s_Ui { bool v1; unsigned short v2:9; unsigned int v3; };
struct B_BFu9s_Ul { bool v1; unsigned short v2:9; unsigned long long v3; };
struct B_BFu9s_Us { bool v1; unsigned short v2:9; unsigned short v3; };
struct B_BFu9s_Vp { bool v1; unsigned short v2:9; void * v3; };
struct B_C { bool v1; char v2; };
struct B_C_B { bool v1; char v2; bool v3; };
struct B_C_BFu15i { bool v1; char v2; unsigned int v3:15; };
struct B_C_BFu15ll { bool v1; char v2; unsigned long long v3:15; };
struct B_C_BFu15s { bool v1; char v2; unsigned short v3:15; };
struct B_C_BFu16i { bool v1; char v2; unsigned int v3:16; };
struct B_C_BFu16ll { bool v1; char v2; unsigned long long v3:16; };
struct B_C_BFu16s { bool v1; char v2; unsigned short v3:16; };
struct B_C_BFu17i { bool v1; char v2; unsigned int v3:17; };
struct B_C_BFu17ll { bool v1; char v2; unsigned long long v3:17; };
struct B_C_BFu1c { bool v1; char v2; unsigned char v3:1; };
struct B_C_BFu1i { bool v1; char v2; unsigned int v3:1; };
struct B_C_BFu1ll { bool v1; char v2; unsigned long long v3:1; };
struct B_C_BFu1s { bool v1; char v2; unsigned short v3:1; };
struct B_C_BFu31i { bool v1; char v2; unsigned int v3:31; };
struct B_C_BFu31ll { bool v1; char v2; unsigned long long v3:31; };
struct B_C_BFu32i { bool v1; char v2; unsigned int v3:32; };
struct B_C_BFu32ll { bool v1; char v2; unsigned long long v3:32; };
struct B_C_BFu33 { bool v1; char v2; unsigned long long v3:33; };
struct B_C_BFu7c { bool v1; char v2; unsigned char v3:7; };
struct B_C_BFu7i { bool v1; char v2; unsigned int v3:7; };
struct B_C_BFu7ll { bool v1; char v2; unsigned long long v3:7; };
struct B_C_BFu7s { bool v1; char v2; unsigned short v3:7; };
struct B_C_BFu8c { bool v1; char v2; unsigned char v3:8; };
struct B_C_BFu8i { bool v1; char v2; unsigned int v3:8; };
struct B_C_BFu8ll { bool v1; char v2; unsigned long long v3:8; };
struct B_C_BFu8s { bool v1; char v2; unsigned short v3:8; };
struct B_C_BFu9i { bool v1; char v2; unsigned int v3:9; };
struct B_C_BFu9ll { bool v1; char v2; unsigned long long v3:9; };
struct B_C_BFu9s { bool v1; char v2; unsigned short v3:9; };
struct B_C_C { bool v1; char v2; char v3; };
struct B_C_D { bool v1; char v2; double v3; };
struct B_C_F { bool v1; char v2; float v3; };
struct B_C_I { bool v1; char v2; int v3; };
struct B_C_Ip { bool v1; char v2; int * v3; };
struct B_C_L { bool v1; char v2; long long v3; };
struct B_C_S { bool v1; char v2; short v3; };
struct B_C_Uc { bool v1; char v2; unsigned char v3; };
struct B_C_Ui { bool v1; char v2; unsigned int v3; };
struct B_C_Ul { bool v1; char v2; unsigned long long v3; };
struct B_C_Us { bool v1; char v2; unsigned short v3; };
struct B_C_Vp { bool v1; char v2; void * v3; };
struct B_D { bool v1; double v2; };
struct B_D_B { bool v1; double v2; bool v3; };
struct B_D_BFu15i { bool v1; double v2; unsigned int v3:15; };
struct B_D_BFu15ll { bool v1; double v2; unsigned long long v3:15; };
struct B_D_BFu15s { bool v1; double v2; unsigned short v3:15; };
struct B_D_BFu16i { bool v1; double v2; unsigned int v3:16; };
struct B_D_BFu16ll { bool v1; double v2; unsigned long long v3:16; };
struct B_D_BFu16s { bool v1; double v2; unsigned short v3:16; };
struct B_D_BFu17i { bool v1; double v2; unsigned int v3:17; };
struct B_D_BFu17ll { bool v1; double v2; unsigned long long v3:17; };
struct B_D_BFu1c { bool v1; double v2; unsigned char v3:1; };
struct B_D_BFu1i { bool v1; double v2; unsigned int v3:1; };
struct B_D_BFu1ll { bool v1; double v2; unsigned long long v3:1; };
struct B_D_BFu1s { bool v1; double v2; unsigned short v3:1; };
struct B_D_BFu31i { bool v1; double v2; unsigned int v3:31; };
struct B_D_BFu31ll { bool v1; double v2; unsigned long long v3:31; };
struct B_D_BFu32i { bool v1; double v2; unsigned int v3:32; };
struct B_D_BFu32ll { bool v1; double v2; unsigned long long v3:32; };
struct B_D_BFu33 { bool v1; double v2; unsigned long long v3:33; };
struct B_D_BFu7c { bool v1; double v2; unsigned char v3:7; };
struct B_D_BFu7i { bool v1; double v2; unsigned int v3:7; };
struct B_D_BFu7ll { bool v1; double v2; unsigned long long v3:7; };
struct B_D_BFu7s { bool v1; double v2; unsigned short v3:7; };
struct B_D_BFu8c { bool v1; double v2; unsigned char v3:8; };
struct B_D_BFu8i { bool v1; double v2; unsigned int v3:8; };
struct B_D_BFu8ll { bool v1; double v2; unsigned long long v3:8; };
struct B_D_BFu8s { bool v1; double v2; unsigned short v3:8; };
struct B_D_BFu9i { bool v1; double v2; unsigned int v3:9; };
struct B_D_BFu9ll { bool v1; double v2; unsigned long long v3:9; };
struct B_D_BFu9s { bool v1; double v2; unsigned short v3:9; };
struct B_D_C { bool v1; double v2; char v3; };
struct B_D_D { bool v1; double v2; double v3; };
struct B_D_F { bool v1; double v2; float v3; };
struct B_D_I { bool v1; double v2; int v3; };
struct B_D_Ip { bool v1; double v2; int * v3; };
struct B_D_L { bool v1; double v2; long long v3; };
struct B_D_S { bool v1; double v2; short v3; };
struct B_D_Uc { bool v1; double v2; unsigned char v3; };
struct B_D_Ui { bool v1; double v2; unsigned int v3; };
struct B_D_Ul { bool v1; double v2; unsigned long long v3; };
struct B_D_Us { bool v1; double v2; unsigned short v3; };
struct B_D_Vp { bool v1; double v2; void * v3; };
struct B_F { bool v1; float v2; };
struct B_F_B { bool v1; float v2; bool v3; };
struct B_F_BFu15i { bool v1; float v2; unsigned int v3:15; };
struct B_F_BFu15ll { bool v1; float v2; unsigned long long v3:15; };
struct B_F_BFu15s { bool v1; float v2; unsigned short v3:15; };
struct B_F_BFu16i { bool v1; float v2; unsigned int v3:16; };
struct B_F_BFu16ll { bool v1; float v2; unsigned long long v3:16; };
struct B_F_BFu16s { bool v1; float v2; unsigned short v3:16; };
struct B_F_BFu17i { bool v1; float v2; unsigned int v3:17; };
struct B_F_BFu17ll { bool v1; float v2; unsigned long long v3:17; };
struct B_F_BFu1c { bool v1; float v2; unsigned char v3:1; };
struct B_F_BFu1i { bool v1; float v2; unsigned int v3:1; };
struct B_F_BFu1ll { bool v1; float v2; unsigned long long v3:1; };
struct B_F_BFu1s { bool v1; float v2; unsigned short v3:1; };
struct B_F_BFu31i { bool v1; float v2; unsigned int v3:31; };
struct B_F_BFu31ll { bool v1; float v2; unsigned long long v3:31; };
struct B_F_BFu32i { bool v1; float v2; unsigned int v3:32; };
struct B_F_BFu32ll { bool v1; float v2; unsigned long long v3:32; };
struct B_F_BFu33 { bool v1; float v2; unsigned long long v3:33; };
struct B_F_BFu7c { bool v1; float v2; unsigned char v3:7; };
struct B_F_BFu7i { bool v1; float v2; unsigned int v3:7; };
struct B_F_BFu7ll { bool v1; float v2; unsigned long long v3:7; };
struct B_F_BFu7s { bool v1; float v2; unsigned short v3:7; };
struct B_F_BFu8c { bool v1; float v2; unsigned char v3:8; };
struct B_F_BFu8i { bool v1; float v2; unsigned int v3:8; };
struct B_F_BFu8ll { bool v1; float v2; unsigned long long v3:8; };
struct B_F_BFu8s { bool v1; float v2; unsigned short v3:8; };
struct B_F_BFu9i { bool v1; float v2; unsigned int v3:9; };
struct B_F_BFu9ll { bool v1; float v2; unsigned long long v3:9; };
struct B_F_BFu9s { bool v1; float v2; unsigned short v3:9; };
struct B_F_C { bool v1; float v2; char v3; };
struct B_F_D { bool v1; float v2; double v3; };
struct B_F_F { bool v1; float v2; float v3; };
struct B_F_I { bool v1; float v2; int v3; };
struct B_F_Ip { bool v1; float v2; int * v3; };
struct B_F_L { bool v1; float v2; long long v3; };
struct B_F_S { bool v1; float v2; short v3; };
struct B_F_Uc { bool v1; float v2; unsigned char v3; };
struct B_F_Ui { bool v1; float v2; unsigned int v3; };
struct B_F_Ul { bool v1; float v2; unsigned long long v3; };
struct B_F_Us { bool v1; float v2; unsigned short v3; };
struct B_F_Vp { bool v1; float v2; void * v3; };
struct B_I { bool v1; int v2; };
struct B_I_B { bool v1; int v2; bool v3; };
struct B_I_BFu15i { bool v1; int v2; unsigned int v3:15; };
struct B_I_BFu15ll { bool v1; int v2; unsigned long long v3:15; };
struct B_I_BFu15s { bool v1; int v2; unsigned short v3:15; };
struct B_I_BFu16i { bool v1; int v2; unsigned int v3:16; };
struct B_I_BFu16ll { bool v1; int v2; unsigned long long v3:16; };
struct B_I_BFu16s { bool v1; int v2; unsigned short v3:16; };
struct B_I_BFu17i { bool v1; int v2; unsigned int v3:17; };
struct B_I_BFu17ll { bool v1; int v2; unsigned long long v3:17; };
struct B_I_BFu1c { bool v1; int v2; unsigned char v3:1; };
struct B_I_BFu1i { bool v1; int v2; unsigned int v3:1; };
struct B_I_BFu1ll { bool v1; int v2; unsigned long long v3:1; };
struct B_I_BFu1s { bool v1; int v2; unsigned short v3:1; };
struct B_I_BFu31i { bool v1; int v2; unsigned int v3:31; };
struct B_I_BFu31ll { bool v1; int v2; unsigned long long v3:31; };
struct B_I_BFu32i { bool v1; int v2; unsigned int v3:32; };
struct B_I_BFu32ll { bool v1; int v2; unsigned long long v3:32; };
struct B_I_BFu33 { bool v1; int v2; unsigned long long v3:33; };
struct B_I_BFu7c { bool v1; int v2; unsigned char v3:7; };
struct B_I_BFu7i { bool v1; int v2; unsigned int v3:7; };
struct B_I_BFu7ll { bool v1; int v2; unsigned long long v3:7; };
struct B_I_BFu7s { bool v1; int v2; unsigned short v3:7; };
struct B_I_BFu8c { bool v1; int v2; unsigned char v3:8; };
struct B_I_BFu8i { bool v1; int v2; unsigned int v3:8; };
struct B_I_BFu8ll { bool v1; int v2; unsigned long long v3:8; };
struct B_I_BFu8s { bool v1; int v2; unsigned short v3:8; };
struct B_I_BFu9i { bool v1; int v2; unsigned int v3:9; };
struct B_I_BFu9ll { bool v1; int v2; unsigned long long v3:9; };
struct B_I_BFu9s { bool v1; int v2; unsigned short v3:9; };
struct B_I_C { bool v1; int v2; char v3; };
struct B_I_D { bool v1; int v2; double v3; };
struct B_I_F { bool v1; int v2; float v3; };
struct B_I_I { bool v1; int v2; int v3; };
struct B_I_Ip { bool v1; int v2; int * v3; };
struct B_I_L { bool v1; int v2; long long v3; };
struct B_I_S { bool v1; int v2; short v3; };
struct B_I_Uc { bool v1; int v2; unsigned char v3; };
struct B_I_Ui { bool v1; int v2; unsigned int v3; };
struct B_I_Ul { bool v1; int v2; unsigned long long v3; };
struct B_I_Us { bool v1; int v2; unsigned short v3; };
struct B_I_Vp { bool v1; int v2; void * v3; };
struct B_Ip { bool v1; int * v2; };
struct B_Ip_B { bool v1; int * v2; bool v3; };
struct B_Ip_BFu15i { bool v1; int * v2; unsigned int v3:15; };
struct B_Ip_BFu15ll { bool v1; int * v2; unsigned long long v3:15; };
struct B_Ip_BFu15s { bool v1; int * v2; unsigned short v3:15; };
struct B_Ip_BFu16i { bool v1; int * v2; unsigned int v3:16; };
struct B_Ip_BFu16ll { bool v1; int * v2; unsigned long long v3:16; };
struct B_Ip_BFu16s { bool v1; int * v2; unsigned short v3:16; };
struct B_Ip_BFu17i { bool v1; int * v2; unsigned int v3:17; };
struct B_Ip_BFu17ll { bool v1; int * v2; unsigned long long v3:17; };
struct B_Ip_BFu1c { bool v1; int * v2; unsigned char v3:1; };
struct B_Ip_BFu1i { bool v1; int * v2; unsigned int v3:1; };
struct B_Ip_BFu1ll { bool v1; int * v2; unsigned long long v3:1; };
struct B_Ip_BFu1s { bool v1; int * v2; unsigned short v3:1; };
struct B_Ip_BFu31i { bool v1; int * v2; unsigned int v3:31; };
struct B_Ip_BFu31ll { bool v1; int * v2; unsigned long long v3:31; };
struct B_Ip_BFu32i { bool v1; int * v2; unsigned int v3:32; };
struct B_Ip_BFu32ll { bool v1; int * v2; unsigned long long v3:32; };
struct B_Ip_BFu33 { bool v1; int * v2; unsigned long long v3:33; };
struct B_Ip_BFu7c { bool v1; int * v2; unsigned char v3:7; };
struct B_Ip_BFu7i { bool v1; int * v2; unsigned int v3:7; };
struct B_Ip_BFu7ll { bool v1; int * v2; unsigned long long v3:7; };
struct B_Ip_BFu7s { bool v1; int * v2; unsigned short v3:7; };
struct B_Ip_BFu8c { bool v1; int * v2; unsigned char v3:8; };
struct B_Ip_BFu8i { bool v1; int * v2; unsigned int v3:8; };
struct B_Ip_BFu8ll { bool v1; int * v2; unsigned long long v3:8; };
struct B_Ip_BFu8s { bool v1; int * v2; unsigned short v3:8; };
struct B_Ip_BFu9i { bool v1; int * v2; unsigned int v3:9; };
struct B_Ip_BFu9ll { bool v1; int * v2; unsigned long long v3:9; };
struct B_Ip_BFu9s { bool v1; int * v2; unsigned short v3:9; };
struct B_Ip_C { bool v1; int * v2; char v3; };
struct B_Ip_D { bool v1; int * v2; double v3; };
struct B_Ip_F { bool v1; int * v2; float v3; };
struct B_Ip_I { bool v1; int * v2; int v3; };
struct B_Ip_Ip { bool v1; int * v2; int * v3; };
struct B_Ip_L { bool v1; int * v2; long long v3; };
struct B_Ip_S { bool v1; int * v2; short v3; };
struct B_Ip_Uc { bool v1; int * v2; unsigned char v3; };
struct B_Ip_Ui { bool v1; int * v2; unsigned int v3; };
struct B_Ip_Ul { bool v1; int * v2; unsigned long long v3; };
struct B_Ip_Us { bool v1; int * v2; unsigned short v3; };
struct B_Ip_Vp { bool v1; int * v2; void * v3; };
struct B_L { bool v1; long long v2; };
struct B_L_B { bool v1; long long v2; bool v3; };
struct B_L_BFu15i { bool v1; long long v2; unsigned int v3:15; };
struct B_L_BFu15ll { bool v1; long long v2; unsigned long long v3:15; };
struct B_L_BFu15s { bool v1; long long v2; unsigned short v3:15; };
struct B_L_BFu16i { bool v1; long long v2; unsigned int v3:16; };
struct B_L_BFu16ll { bool v1; long long v2; unsigned long long v3:16; };
struct B_L_BFu16s { bool v1; long long v2; unsigned short v3:16; };
struct B_L_BFu17i { bool v1; long long v2; unsigned int v3:17; };
struct B_L_BFu17ll { bool v1; long long v2; unsigned long long v3:17; };
struct B_L_BFu1c { bool v1; long long v2; unsigned char v3:1; };
struct B_L_BFu1i { bool v1; long long v2; unsigned int v3:1; };
struct B_L_BFu1ll { bool v1; long long v2; unsigned long long v3:1; };
struct B_L_BFu1s { bool v1; long long v2; unsigned short v3:1; };
struct B_L_BFu31i { bool v1; long long v2; unsigned int v3:31; };
struct B_L_BFu31ll { bool v1; long long v2; unsigned long long v3:31; };
struct B_L_BFu32i { bool v1; long long v2; unsigned int v3:32; };
struct B_L_BFu32ll { bool v1; long long v2; unsigned long long v3:32; };
struct B_L_BFu33 { bool v1; long long v2; unsigned long long v3:33; };
struct B_L_BFu7c { bool v1; long long v2; unsigned char v3:7; };
struct B_L_BFu7i { bool v1; long long v2; unsigned int v3:7; };
struct B_L_BFu7ll { bool v1; long long v2; unsigned long long v3:7; };
struct B_L_BFu7s { bool v1; long long v2; unsigned short v3:7; };
struct B_L_BFu8c { bool v1; long long v2; unsigned char v3:8; };
struct B_L_BFu8i { bool v1; long long v2; unsigned int v3:8; };
struct B_L_BFu8ll { bool v1; long long v2; unsigned long long v3:8; };
struct B_L_BFu8s { bool v1; long long v2; unsigned short v3:8; };
struct B_L_BFu9i { bool v1; long long v2; unsigned int v3:9; };
struct B_L_BFu9ll { bool v1; long long v2; unsigned long long v3:9; };
struct B_L_BFu9s { bool v1; long long v2; unsigned short v3:9; };
struct B_L_C { bool v1; long long v2; char v3; };
struct B_L_D { bool v1; long long v2; double v3; };
struct B_L_F { bool v1; long long v2; float v3; };
struct B_L_I { bool v1; long long v2; int v3; };
struct B_L_Ip { bool v1; long long v2; int * v3; };
struct B_L_L { bool v1; long long v2; long long v3; };
struct B_L_S { bool v1; long long v2; short v3; };
struct B_L_Uc { bool v1; long long v2; unsigned char v3; };
struct B_L_Ui { bool v1; long long v2; unsigned int v3; };
struct B_L_Ul { bool v1; long long v2; unsigned long long v3; };
struct B_L_Us { bool v1; long long v2; unsigned short v3; };
struct B_L_Vp { bool v1; long long v2; void * v3; };
struct B_S { bool v1; short v2; };
struct B_S_B { bool v1; short v2; bool v3; };
struct B_S_BFu15i { bool v1; short v2; unsigned int v3:15; };
struct B_S_BFu15ll { bool v1; short v2; unsigned long long v3:15; };
struct B_S_BFu15s { bool v1; short v2; unsigned short v3:15; };
struct B_S_BFu16i { bool v1; short v2; unsigned int v3:16; };
struct B_S_BFu16ll { bool v1; short v2; unsigned long long v3:16; };
struct B_S_BFu16s { bool v1; short v2; unsigned short v3:16; };
struct B_S_BFu17i { bool v1; short v2; unsigned int v3:17; };
struct B_S_BFu17ll { bool v1; short v2; unsigned long long v3:17; };
struct B_S_BFu1c { bool v1; short v2; unsigned char v3:1; };
struct B_S_BFu1i { bool v1; short v2; unsigned int v3:1; };
struct B_S_BFu1ll { bool v1; short v2; unsigned long long v3:1; };
struct B_S_BFu1s { bool v1; short v2; unsigned short v3:1; };
struct B_S_BFu31i { bool v1; short v2; unsigned int v3:31; };
struct B_S_BFu31ll { bool v1; short v2; unsigned long long v3:31; };
struct B_S_BFu32i { bool v1; short v2; unsigned int v3:32; };
struct B_S_BFu32ll { bool v1; short v2; unsigned long long v3:32; };
struct B_S_BFu33 { bool v1; short v2; unsigned long long v3:33; };
struct B_S_BFu7c { bool v1; short v2; unsigned char v3:7; };
struct B_S_BFu7i { bool v1; short v2; unsigned int v3:7; };
struct B_S_BFu7ll { bool v1; short v2; unsigned long long v3:7; };
struct B_S_BFu7s { bool v1; short v2; unsigned short v3:7; };
struct B_S_BFu8c { bool v1; short v2; unsigned char v3:8; };
struct B_S_BFu8i { bool v1; short v2; unsigned int v3:8; };
struct B_S_BFu8ll { bool v1; short v2; unsigned long long v3:8; };
struct B_S_BFu8s { bool v1; short v2; unsigned short v3:8; };
struct B_S_BFu9i { bool v1; short v2; unsigned int v3:9; };
struct B_S_BFu9ll { bool v1; short v2; unsigned long long v3:9; };
struct B_S_BFu9s { bool v1; short v2; unsigned short v3:9; };
struct B_S_C { bool v1; short v2; char v3; };
struct B_S_D { bool v1; short v2; double v3; };
struct B_S_F { bool v1; short v2; float v3; };
struct B_S_I { bool v1; short v2; int v3; };
struct B_S_Ip { bool v1; short v2; int * v3; };
struct B_S_L { bool v1; short v2; long long v3; };
struct B_S_S { bool v1; short v2; short v3; };
struct B_S_Uc { bool v1; short v2; unsigned char v3; };
struct B_S_Ui { bool v1; short v2; unsigned int v3; };
struct B_S_Ul { bool v1; short v2; unsigned long long v3; };
struct B_S_Us { bool v1; short v2; unsigned short v3; };
struct B_S_Vp { bool v1; short v2; void * v3; };
struct B_Uc { bool v1; unsigned char v2; };
struct B_Uc_B { bool v1; unsigned char v2; bool v3; };
struct B_Uc_BFu15i { bool v1; unsigned char v2; unsigned int v3:15; };
struct B_Uc_BFu15ll { bool v1; unsigned char v2; unsigned long long v3:15; };
struct B_Uc_BFu15s { bool v1; unsigned char v2; unsigned short v3:15; };
struct B_Uc_BFu16i { bool v1; unsigned char v2; unsigned int v3:16; };
struct B_Uc_BFu16ll { bool v1; unsigned char v2; unsigned long long v3:16; };
struct B_Uc_BFu16s { bool v1; unsigned char v2; unsigned short v3:16; };
struct B_Uc_BFu17i { bool v1; unsigned char v2; unsigned int v3:17; };
struct B_Uc_BFu17ll { bool v1; unsigned char v2; unsigned long long v3:17; };
struct B_Uc_BFu1c { bool v1; unsigned char v2; unsigned char v3:1; };
struct B_Uc_BFu1i { bool v1; unsigned char v2; unsigned int v3:1; };
struct B_Uc_BFu1ll { bool v1; unsigned char v2; unsigned long long v3:1; };
struct B_Uc_BFu1s { bool v1; unsigned char v2; unsigned short v3:1; };
struct B_Uc_BFu31i { bool v1; unsigned char v2; unsigned int v3:31; };
struct B_Uc_BFu31ll { bool v1; unsigned char v2; unsigned long long v3:31; };
struct B_Uc_BFu32i { bool v1; unsigned char v2; unsigned int v3:32; };
struct B_Uc_BFu32ll { bool v1; unsigned char v2; unsigned long long v3:32; };
struct B_Uc_BFu33 { bool v1; unsigned char v2; unsigned long long v3:33; };
struct B_Uc_BFu7c { bool v1; unsigned char v2; unsigned char v3:7; };
struct B_Uc_BFu7i { bool v1; unsigned char v2; unsigned int v3:7; };
struct B_Uc_BFu7ll { bool v1; unsigned char v2; unsigned long long v3:7; };
struct B_Uc_BFu7s { bool v1; unsigned char v2; unsigned short v3:7; };
struct B_Uc_BFu8c { bool v1; unsigned char v2; unsigned char v3:8; };
struct B_Uc_BFu8i { bool v1; unsigned char v2; unsigned int v3:8; };
struct B_Uc_BFu8ll { bool v1; unsigned char v2; unsigned long long v3:8; };
struct B_Uc_BFu8s { bool v1; unsigned char v2; unsigned short v3:8; };
struct B_Uc_BFu9i { bool v1; unsigned char v2; unsigned int v3:9; };
struct B_Uc_BFu9ll { bool v1; unsigned char v2; unsigned long long v3:9; };
struct B_Uc_BFu9s { bool v1; unsigned char v2; unsigned short v3:9; };
struct B_Uc_C { bool v1; unsigned char v2; char v3; };
struct B_Uc_D { bool v1; unsigned char v2; double v3; };
struct B_Uc_F { bool v1; unsigned char v2; float v3; };
struct B_Uc_I { bool v1; unsigned char v2; int v3; };
struct B_Uc_Ip { bool v1; unsigned char v2; int * v3; };
struct B_Uc_L { bool v1; unsigned char v2; long long v3; };
struct B_Uc_S { bool v1; unsigned char v2; short v3; };
struct B_Uc_Uc { bool v1; unsigned char v2; unsigned char v3; };
struct B_Uc_Ui { bool v1; unsigned char v2; unsigned int v3; };
struct B_Uc_Ul { bool v1; unsigned char v2; unsigned long long v3; };
struct B_Uc_Us { bool v1; unsigned char v2; unsigned short v3; };
struct B_Uc_Vp { bool v1; unsigned char v2; void * v3; };
struct B_Ui { bool v1; unsigned int v2; };
struct B_Ui_B { bool v1; unsigned int v2; bool v3; };
struct B_Ui_BFu15i { bool v1; unsigned int v2; unsigned int v3:15; };
struct B_Ui_BFu15ll { bool v1; unsigned int v2; unsigned long long v3:15; };
struct B_Ui_BFu15s { bool v1; unsigned int v2; unsigned short v3:15; };
struct B_Ui_BFu16i { bool v1; unsigned int v2; unsigned int v3:16; };
struct B_Ui_BFu16ll { bool v1; unsigned int v2; unsigned long long v3:16; };
struct B_Ui_BFu16s { bool v1; unsigned int v2; unsigned short v3:16; };
struct B_Ui_BFu17i { bool v1; unsigned int v2; unsigned int v3:17; };
struct B_Ui_BFu17ll { bool v1; unsigned int v2; unsigned long long v3:17; };
struct B_Ui_BFu1c { bool v1; unsigned int v2; unsigned char v3:1; };
struct B_Ui_BFu1i { bool v1; unsigned int v2; unsigned int v3:1; };
struct B_Ui_BFu1ll { bool v1; unsigned int v2; unsigned long long v3:1; };
struct B_Ui_BFu1s { bool v1; unsigned int v2; unsigned short v3:1; };
struct B_Ui_BFu31i { bool v1; unsigned int v2; unsigned int v3:31; };
struct B_Ui_BFu31ll { bool v1; unsigned int v2; unsigned long long v3:31; };
struct B_Ui_BFu32i { bool v1; unsigned int v2; unsigned int v3:32; };
struct B_Ui_BFu32ll { bool v1; unsigned int v2; unsigned long long v3:32; };
struct B_Ui_BFu33 { bool v1; unsigned int v2; unsigned long long v3:33; };
struct B_Ui_BFu7c { bool v1; unsigned int v2; unsigned char v3:7; };
struct B_Ui_BFu7i { bool v1; unsigned int v2; unsigned int v3:7; };
struct B_Ui_BFu7ll { bool v1; unsigned int v2; unsigned long long v3:7; };
struct B_Ui_BFu7s { bool v1; unsigned int v2; unsigned short v3:7; };
struct B_Ui_BFu8c { bool v1; unsigned int v2; unsigned char v3:8; };
struct B_Ui_BFu8i { bool v1; unsigned int v2; unsigned int v3:8; };
struct B_Ui_BFu8ll { bool v1; unsigned int v2; unsigned long long v3:8; };
struct B_Ui_BFu8s { bool v1; unsigned int v2; unsigned short v3:8; };
struct B_Ui_BFu9i { bool v1; unsigned int v2; unsigned int v3:9; };
struct B_Ui_BFu9ll { bool v1; unsigned int v2; unsigned long long v3:9; };
struct B_Ui_BFu9s { bool v1; unsigned int v2; unsigned short v3:9; };
struct B_Ui_C { bool v1; unsigned int v2; char v3; };
struct B_Ui_D { bool v1; unsigned int v2; double v3; };
struct B_Ui_F { bool v1; unsigned int v2; float v3; };
struct B_Ui_I { bool v1; unsigned int v2; int v3; };
struct B_Ui_Ip { bool v1; unsigned int v2; int * v3; };
struct B_Ui_L { bool v1; unsigned int v2; long long v3; };
struct B_Ui_S { bool v1; unsigned int v2; short v3; };
struct B_Ui_Uc { bool v1; unsigned int v2; unsigned char v3; };
struct B_Ui_Ui { bool v1; unsigned int v2; unsigned int v3; };
struct B_Ui_Ul { bool v1; unsigned int v2; unsigned long long v3; };
struct B_Ui_Us { bool v1; unsigned int v2; unsigned short v3; };
struct B_Ui_Vp { bool v1; unsigned int v2; void * v3; };
struct B_Ul { bool v1; unsigned long long v2; };
struct B_Ul_B { bool v1; unsigned long long v2; bool v3; };
struct B_Ul_BFu15i { bool v1; unsigned long long v2; unsigned int v3:15; };
struct B_Ul_BFu15ll { bool v1; unsigned long long v2; unsigned long long v3:15; };
struct B_Ul_BFu15s { bool v1; unsigned long long v2; unsigned short v3:15; };
struct B_Ul_BFu16i { bool v1; unsigned long long v2; unsigned int v3:16; };
struct B_Ul_BFu16ll { bool v1; unsigned long long v2; unsigned long long v3:16; };
struct B_Ul_BFu16s { bool v1; unsigned long long v2; unsigned short v3:16; };
struct B_Ul_BFu17i { bool v1; unsigned long long v2; unsigned int v3:17; };
struct B_Ul_BFu17ll { bool v1; unsigned long long v2; unsigned long long v3:17; };
struct B_Ul_BFu1c { bool v1; unsigned long long v2; unsigned char v3:1; };
struct B_Ul_BFu1i { bool v1; unsigned long long v2; unsigned int v3:1; };
struct B_Ul_BFu1ll { bool v1; unsigned long long v2; unsigned long long v3:1; };
struct B_Ul_BFu1s { bool v1; unsigned long long v2; unsigned short v3:1; };
struct B_Ul_BFu31i { bool v1; unsigned long long v2; unsigned int v3:31; };
struct B_Ul_BFu31ll { bool v1; unsigned long long v2; unsigned long long v3:31; };
struct B_Ul_BFu32i { bool v1; unsigned long long v2; unsigned int v3:32; };
struct B_Ul_BFu32ll { bool v1; unsigned long long v2; unsigned long long v3:32; };
struct B_Ul_BFu33 { bool v1; unsigned long long v2; unsigned long long v3:33; };
struct B_Ul_BFu7c { bool v1; unsigned long long v2; unsigned char v3:7; };
struct B_Ul_BFu7i { bool v1; unsigned long long v2; unsigned int v3:7; };
struct B_Ul_BFu7ll { bool v1; unsigned long long v2; unsigned long long v3:7; };
struct B_Ul_BFu7s { bool v1; unsigned long long v2; unsigned short v3:7; };
struct B_Ul_BFu8c { bool v1; unsigned long long v2; unsigned char v3:8; };
struct B_Ul_BFu8i { bool v1; unsigned long long v2; unsigned int v3:8; };
struct B_Ul_BFu8ll { bool v1; unsigned long long v2; unsigned long long v3:8; };
struct B_Ul_BFu8s { bool v1; unsigned long long v2; unsigned short v3:8; };
struct B_Ul_BFu9i { bool v1; unsigned long long v2; unsigned int v3:9; };
struct B_Ul_BFu9ll { bool v1; unsigned long long v2; unsigned long long v3:9; };
struct B_Ul_BFu9s { bool v1; unsigned long long v2; unsigned short v3:9; };
struct B_Ul_C { bool v1; unsigned long long v2; char v3; };
struct B_Ul_D { bool v1; unsigned long long v2; double v3; };
struct B_Ul_F { bool v1; unsigned long long v2; float v3; };
struct B_Ul_I { bool v1; unsigned long long v2; int v3; };
struct B_Ul_Ip { bool v1; unsigned long long v2; int * v3; };
struct B_Ul_L { bool v1; unsigned long long v2; long long v3; };
struct B_Ul_S { bool v1; unsigned long long v2; short v3; };
struct B_Ul_Uc { bool v1; unsigned long long v2; unsigned char v3; };
struct B_Ul_Ui { bool v1; unsigned long long v2; unsigned int v3; };
struct B_Ul_Ul { bool v1; unsigned long long v2; unsigned long long v3; };
struct B_Ul_Us { bool v1; unsigned long long v2; unsigned short v3; };
struct B_Ul_Vp { bool v1; unsigned long long v2; void * v3; };
struct B_Us { bool v1; unsigned short v2; };
struct B_Us_B { bool v1; unsigned short v2; bool v3; };
struct B_Us_BFu15i { bool v1; unsigned short v2; unsigned int v3:15; };
struct B_Us_BFu15ll { bool v1; unsigned short v2; unsigned long long v3:15; };
struct B_Us_BFu15s { bool v1; unsigned short v2; unsigned short v3:15; };
struct B_Us_BFu16i { bool v1; unsigned short v2; unsigned int v3:16; };
struct B_Us_BFu16ll { bool v1; unsigned short v2; unsigned long long v3:16; };
struct B_Us_BFu16s { bool v1; unsigned short v2; unsigned short v3:16; };
struct B_Us_BFu17i { bool v1; unsigned short v2; unsigned int v3:17; };
struct B_Us_BFu17ll { bool v1; unsigned short v2; unsigned long long v3:17; };
struct B_Us_BFu1c { bool v1; unsigned short v2; unsigned char v3:1; };
struct B_Us_BFu1i { bool v1; unsigned short v2; unsigned int v3:1; };
struct B_Us_BFu1ll { bool v1; unsigned short v2; unsigned long long v3:1; };
struct B_Us_BFu1s { bool v1; unsigned short v2; unsigned short v3:1; };
struct B_Us_BFu31i { bool v1; unsigned short v2; unsigned int v3:31; };
struct B_Us_BFu31ll { bool v1; unsigned short v2; unsigned long long v3:31; };
struct B_Us_BFu32i { bool v1; unsigned short v2; unsigned int v3:32; };
struct B_Us_BFu32ll { bool v1; unsigned short v2; unsigned long long v3:32; };
struct B_Us_BFu33 { bool v1; unsigned short v2; unsigned long long v3:33; };
struct B_Us_BFu7c { bool v1; unsigned short v2; unsigned char v3:7; };
struct B_Us_BFu7i { bool v1; unsigned short v2; unsigned int v3:7; };
struct B_Us_BFu7ll { bool v1; unsigned short v2; unsigned long long v3:7; };
struct B_Us_BFu7s { bool v1; unsigned short v2; unsigned short v3:7; };
struct B_Us_BFu8c { bool v1; unsigned short v2; unsigned char v3:8; };
struct B_Us_BFu8i { bool v1; unsigned short v2; unsigned int v3:8; };
struct B_Us_BFu8ll { bool v1; unsigned short v2; unsigned long long v3:8; };
struct B_Us_BFu8s { bool v1; unsigned short v2; unsigned short v3:8; };
struct B_Us_BFu9i { bool v1; unsigned short v2; unsigned int v3:9; };
struct B_Us_BFu9ll { bool v1; unsigned short v2; unsigned long long v3:9; };
struct B_Us_BFu9s { bool v1; unsigned short v2; unsigned short v3:9; };
struct B_Us_C { bool v1; unsigned short v2; char v3; };
struct B_Us_D { bool v1; unsigned short v2; double v3; };
struct B_Us_F { bool v1; unsigned short v2; float v3; };
struct B_Us_I { bool v1; unsigned short v2; int v3; };
struct B_Us_Ip { bool v1; unsigned short v2; int * v3; };
struct B_Us_L { bool v1; unsigned short v2; long long v3; };
struct B_Us_S { bool v1; unsigned short v2; short v3; };
struct B_Us_Uc { bool v1; unsigned short v2; unsigned char v3; };
struct B_Us_Ui { bool v1; unsigned short v2; unsigned int v3; };
struct B_Us_Ul { bool v1; unsigned short v2; unsigned long long v3; };
struct B_Us_Us { bool v1; unsigned short v2; unsigned short v3; };
struct B_Us_Vp { bool v1; unsigned short v2; void * v3; };
struct B_Vp { bool v1; void * v2; };
struct B_Vp_B { bool v1; void * v2; bool v3; };
struct B_Vp_BFu15i { bool v1; void * v2; unsigned int v3:15; };
struct B_Vp_BFu15ll { bool v1; void * v2; unsigned long long v3:15; };
struct B_Vp_BFu15s { bool v1; void * v2; unsigned short v3:15; };
struct B_Vp_BFu16i { bool v1; void * v2; unsigned int v3:16; };
struct B_Vp_BFu16ll { bool v1; void * v2; unsigned long long v3:16; };
struct B_Vp_BFu16s { bool v1; void * v2; unsigned short v3:16; };
struct B_Vp_BFu17i { bool v1; void * v2; unsigned int v3:17; };
struct B_Vp_BFu17ll { bool v1; void * v2; unsigned long long v3:17; };
struct B_Vp_BFu1c { bool v1; void * v2; unsigned char v3:1; };
struct B_Vp_BFu1i { bool v1; void * v2; unsigned int v3:1; };
struct B_Vp_BFu1ll { bool v1; void * v2; unsigned long long v3:1; };
struct B_Vp_BFu1s { bool v1; void * v2; unsigned short v3:1; };
struct B_Vp_BFu31i { bool v1; void * v2; unsigned int v3:31; };
struct B_Vp_BFu31ll { bool v1; void * v2; unsigned long long v3:31; };
struct B_Vp_BFu32i { bool v1; void * v2; unsigned int v3:32; };
struct B_Vp_BFu32ll { bool v1; void * v2; unsigned long long v3:32; };
struct B_Vp_BFu33 { bool v1; void * v2; unsigned long long v3:33; };
struct B_Vp_BFu7c { bool v1; void * v2; unsigned char v3:7; };
struct B_Vp_BFu7i { bool v1; void * v2; unsigned int v3:7; };
struct B_Vp_BFu7ll { bool v1; void * v2; unsigned long long v3:7; };
struct B_Vp_BFu7s { bool v1; void * v2; unsigned short v3:7; };
struct B_Vp_BFu8c { bool v1; void * v2; unsigned char v3:8; };
struct B_Vp_BFu8i { bool v1; void * v2; unsigned int v3:8; };
struct B_Vp_BFu8ll { bool v1; void * v2; unsigned long long v3:8; };
struct B_Vp_BFu8s { bool v1; void * v2; unsigned short v3:8; };
struct B_Vp_BFu9i { bool v1; void * v2; unsigned int v3:9; };
struct B_Vp_BFu9ll { bool v1; void * v2; unsigned long long v3:9; };
struct B_Vp_BFu9s { bool v1; void * v2; unsigned short v3:9; };
struct B_Vp_C { bool v1; void * v2; char v3; };
struct B_Vp_D { bool v1; void * v2; double v3; };
struct B_Vp_F { bool v1; void * v2; float v3; };
struct B_Vp_I { bool v1; void * v2; int v3; };
struct B_Vp_Ip { bool v1; void * v2; int * v3; };
struct B_Vp_L { bool v1; void * v2; long long v3; };
struct B_Vp_S { bool v1; void * v2; short v3; };
struct B_Vp_Uc { bool v1; void * v2; unsigned char v3; };
struct B_Vp_Ui { bool v1; void * v2; unsigned int v3; };
struct B_Vp_Ul { bool v1; void * v2; unsigned long long v3; };
struct B_Vp_Us { bool v1; void * v2; unsigned short v3; };
struct B_Vp_Vp { bool v1; void * v2; void * v3; };
struct BFu15i_B { unsigned int v1:15; bool v2; };
struct BFu15i_B_B { unsigned int v1:15; bool v2; bool v3; };
struct BFu15i_B_BFu15i { unsigned int v1:15; bool v2; unsigned int v3:15; };
struct BFu15i_B_BFu15ll { unsigned int v1:15; bool v2; unsigned long long v3:15; };
struct BFu15i_B_BFu15s { unsigned int v1:15; bool v2; unsigned short v3:15; };
struct BFu15i_B_BFu16i { unsigned int v1:15; bool v2; unsigned int v3:16; };
struct BFu15i_B_BFu16ll { unsigned int v1:15; bool v2; unsigned long long v3:16; };
struct BFu15i_B_BFu16s { unsigned int v1:15; bool v2; unsigned short v3:16; };
struct BFu15i_B_BFu17i { unsigned int v1:15; bool v2; unsigned int v3:17; };
struct BFu15i_B_BFu17ll { unsigned int v1:15; bool v2; unsigned long long v3:17; };
struct BFu15i_B_BFu1c { unsigned int v1:15; bool v2; unsigned char v3:1; };
struct BFu15i_B_BFu1i { unsigned int v1:15; bool v2; unsigned int v3:1; };
struct BFu15i_B_BFu1ll { unsigned int v1:15; bool v2; unsigned long long v3:1; };
struct BFu15i_B_BFu1s { unsigned int v1:15; bool v2; unsigned short v3:1; };
struct BFu15i_B_BFu31i { unsigned int v1:15; bool v2; unsigned int v3:31; };
struct BFu15i_B_BFu31ll { unsigned int v1:15; bool v2; unsigned long long v3:31; };
struct BFu15i_B_BFu32i { unsigned int v1:15; bool v2; unsigned int v3:32; };
struct BFu15i_B_BFu32ll { unsigned int v1:15; bool v2; unsigned long long v3:32; };
struct BFu15i_B_BFu33 { unsigned int v1:15; bool v2; unsigned long long v3:33; };
struct BFu15i_B_BFu7c { unsigned int v1:15; bool v2; unsigned char v3:7; };
struct BFu15i_B_BFu7i { unsigned int v1:15; bool v2; unsigned int v3:7; };
struct BFu15i_B_BFu7ll { unsigned int v1:15; bool v2; unsigned long long v3:7; };
struct BFu15i_B_BFu7s { unsigned int v1:15; bool v2; unsigned short v3:7; };
struct BFu15i_B_BFu8c { unsigned int v1:15; bool v2; unsigned char v3:8; };
struct BFu15i_B_BFu8i { unsigned int v1:15; bool v2; unsigned int v3:8; };
struct BFu15i_B_BFu8ll { unsigned int v1:15; bool v2; unsigned long long v3:8; };
struct BFu15i_B_BFu8s { unsigned int v1:15; bool v2; unsigned short v3:8; };
struct BFu15i_B_BFu9i { unsigned int v1:15; bool v2; unsigned int v3:9; };
struct BFu15i_B_BFu9ll { unsigned int v1:15; bool v2; unsigned long long v3:9; };
struct BFu15i_B_BFu9s { unsigned int v1:15; bool v2; unsigned short v3:9; };
struct BFu15i_B_C { unsigned int v1:15; bool v2; char v3; };
struct BFu15i_B_D { unsigned int v1:15; bool v2; double v3; };
struct BFu15i_B_F { unsigned int v1:15; bool v2; float v3; };
struct BFu15i_B_I { unsigned int v1:15; bool v2; int v3; };
struct BFu15i_B_Ip { unsigned int v1:15; bool v2; int * v3; };
struct BFu15i_B_L { unsigned int v1:15; bool v2; long long v3; };
struct BFu15i_B_S { unsigned int v1:15; bool v2; short v3; };
struct BFu15i_B_Uc { unsigned int v1:15; bool v2; unsigned char v3; };
struct BFu15i_B_Ui { unsigned int v1:15; bool v2; unsigned int v3; };
struct BFu15i_B_Ul { unsigned int v1:15; bool v2; unsigned long long v3; };
struct BFu15i_B_Us { unsigned int v1:15; bool v2; unsigned short v3; };
struct BFu15i_B_Vp { unsigned int v1:15; bool v2; void * v3; };
struct BFu15i_BFu15i_B { unsigned int v1:15; unsigned int v2:15; bool v3; };
struct BFu15i_BFu15ll_B { unsigned int v1:15; unsigned long long v2:15; bool v3; };
struct BFu15i_BFu15s_B { unsigned int v1:15; unsigned short v2:15; bool v3; };
struct BFu15i_BFu16i_B { unsigned int v1:15; unsigned int v2:16; bool v3; };
struct BFu15i_BFu16ll_B { unsigned int v1:15; unsigned long long v2:16; bool v3; };
struct BFu15i_BFu16s_B { unsigned int v1:15; unsigned short v2:16; bool v3; };
struct BFu15i_BFu17i_B { unsigned int v1:15; unsigned int v2:17; bool v3; };
struct BFu15i_BFu17ll_B { unsigned int v1:15; unsigned long long v2:17; bool v3; };
struct BFu15i_BFu1c_B { unsigned int v1:15; unsigned char v2:1; bool v3; };
struct BFu15i_BFu1i_B { unsigned int v1:15; unsigned int v2:1; bool v3; };
struct BFu15i_BFu1ll_B { unsigned int v1:15; unsigned long long v2:1; bool v3; };
struct BFu15i_BFu1s_B { unsigned int v1:15; unsigned short v2:1; bool v3; };
struct BFu15i_BFu31i_B { unsigned int v1:15; unsigned int v2:31; bool v3; };
struct BFu15i_BFu31ll_B { unsigned int v1:15; unsigned long long v2:31; bool v3; };
struct BFu15i_BFu32i_B { unsigned int v1:15; unsigned int v2:32; bool v3; };
struct BFu15i_BFu32ll_B { unsigned int v1:15; unsigned long long v2:32; bool v3; };
struct BFu15i_BFu33_B { unsigned int v1:15; unsigned long long v2:33; bool v3; };
struct BFu15i_BFu7c_B { unsigned int v1:15; unsigned char v2:7; bool v3; };
struct BFu15i_BFu7i_B { unsigned int v1:15; unsigned int v2:7; bool v3; };
struct BFu15i_BFu7ll_B { unsigned int v1:15; unsigned long long v2:7; bool v3; };
struct BFu15i_BFu7s_B { unsigned int v1:15; unsigned short v2:7; bool v3; };
struct BFu15i_BFu8c_B { unsigned int v1:15; unsigned char v2:8; bool v3; };
struct BFu15i_BFu8i_B { unsigned int v1:15; unsigned int v2:8; bool v3; };
struct BFu15i_BFu8ll_B { unsigned int v1:15; unsigned long long v2:8; bool v3; };
struct BFu15i_BFu8s_B { unsigned int v1:15; unsigned short v2:8; bool v3; };
struct BFu15i_BFu9i_B { unsigned int v1:15; unsigned int v2:9; bool v3; };
struct BFu15i_BFu9ll_B { unsigned int v1:15; unsigned long long v2:9; bool v3; };
struct BFu15i_BFu9s_B { unsigned int v1:15; unsigned short v2:9; bool v3; };
struct BFu15i_C_B { unsigned int v1:15; char v2; bool v3; };
struct BFu15i_D_B { unsigned int v1:15; double v2; bool v3; };
struct BFu15i_F_B { unsigned int v1:15; float v2; bool v3; };
struct BFu15i_I_B { unsigned int v1:15; int v2; bool v3; };
struct BFu15i_Ip_B { unsigned int v1:15; int * v2; bool v3; };
struct BFu15i_L_B { unsigned int v1:15; long long v2; bool v3; };
struct BFu15i_S_B { unsigned int v1:15; short v2; bool v3; };
struct BFu15i_Uc_B { unsigned int v1:15; unsigned char v2; bool v3; };
struct BFu15i_Ui_B { unsigned int v1:15; unsigned int v2; bool v3; };
struct BFu15i_Ul_B { unsigned int v1:15; unsigned long long v2; bool v3; };
struct BFu15i_Us_B { unsigned int v1:15; unsigned short v2; bool v3; };
struct BFu15i_Vp_B { unsigned int v1:15; void * v2; bool v3; };
struct BFu15ll_B { unsigned long long v1:15; bool v2; };
struct BFu15ll_B_B { unsigned long long v1:15; bool v2; bool v3; };
struct BFu15ll_B_BFu15i { unsigned long long v1:15; bool v2; unsigned int v3:15; };
struct BFu15ll_B_BFu15ll { unsigned long long v1:15; bool v2; unsigned long long v3:15; };
struct BFu15ll_B_BFu15s { unsigned long long v1:15; bool v2; unsigned short v3:15; };
struct BFu15ll_B_BFu16i { unsigned long long v1:15; bool v2; unsigned int v3:16; };
struct BFu15ll_B_BFu16ll { unsigned long long v1:15; bool v2; unsigned long long v3:16; };
struct BFu15ll_B_BFu16s { unsigned long long v1:15; bool v2; unsigned short v3:16; };
struct BFu15ll_B_BFu17i { unsigned long long v1:15; bool v2; unsigned int v3:17; };
struct BFu15ll_B_BFu17ll { unsigned long long v1:15; bool v2; unsigned long long v3:17; };
struct BFu15ll_B_BFu1c { unsigned long long v1:15; bool v2; unsigned char v3:1; };
struct BFu15ll_B_BFu1i { unsigned long long v1:15; bool v2; unsigned int v3:1; };
struct BFu15ll_B_BFu1ll { unsigned long long v1:15; bool v2; unsigned long long v3:1; };
struct BFu15ll_B_BFu1s { unsigned long long v1:15; bool v2; unsigned short v3:1; };
struct BFu15ll_B_BFu31i { unsigned long long v1:15; bool v2; unsigned int v3:31; };
struct BFu15ll_B_BFu31ll { unsigned long long v1:15; bool v2; unsigned long long v3:31; };
struct BFu15ll_B_BFu32i { unsigned long long v1:15; bool v2; unsigned int v3:32; };
struct BFu15ll_B_BFu32ll { unsigned long long v1:15; bool v2; unsigned long long v3:32; };
struct BFu15ll_B_BFu33 { unsigned long long v1:15; bool v2; unsigned long long v3:33; };
struct BFu15ll_B_BFu7c { unsigned long long v1:15; bool v2; unsigned char v3:7; };
struct BFu15ll_B_BFu7i { unsigned long long v1:15; bool v2; unsigned int v3:7; };
struct BFu15ll_B_BFu7ll { unsigned long long v1:15; bool v2; unsigned long long v3:7; };
struct BFu15ll_B_BFu7s { unsigned long long v1:15; bool v2; unsigned short v3:7; };
struct BFu15ll_B_BFu8c { unsigned long long v1:15; bool v2; unsigned char v3:8; };
struct BFu15ll_B_BFu8i { unsigned long long v1:15; bool v2; unsigned int v3:8; };
struct BFu15ll_B_BFu8ll { unsigned long long v1:15; bool v2; unsigned long long v3:8; };
struct BFu15ll_B_BFu8s { unsigned long long v1:15; bool v2; unsigned short v3:8; };
struct BFu15ll_B_BFu9i { unsigned long long v1:15; bool v2; unsigned int v3:9; };
struct BFu15ll_B_BFu9ll { unsigned long long v1:15; bool v2; unsigned long long v3:9; };
struct BFu15ll_B_BFu9s { unsigned long long v1:15; bool v2; unsigned short v3:9; };
struct BFu15ll_B_C { unsigned long long v1:15; bool v2; char v3; };
struct BFu15ll_B_D { unsigned long long v1:15; bool v2; double v3; };
struct BFu15ll_B_F { unsigned long long v1:15; bool v2; float v3; };
struct BFu15ll_B_I { unsigned long long v1:15; bool v2; int v3; };
struct BFu15ll_B_Ip { unsigned long long v1:15; bool v2; int * v3; };
struct BFu15ll_B_L { unsigned long long v1:15; bool v2; long long v3; };
struct BFu15ll_B_S { unsigned long long v1:15; bool v2; short v3; };
struct BFu15ll_B_Uc { unsigned long long v1:15; bool v2; unsigned char v3; };
struct BFu15ll_B_Ui { unsigned long long v1:15; bool v2; unsigned int v3; };
struct BFu15ll_B_Ul { unsigned long long v1:15; bool v2; unsigned long long v3; };
struct BFu15ll_B_Us { unsigned long long v1:15; bool v2; unsigned short v3; };
struct BFu15ll_B_Vp { unsigned long long v1:15; bool v2; void * v3; };
struct BFu15ll_BFu15i_B { unsigned long long v1:15; unsigned int v2:15; bool v3; };
struct BFu15ll_BFu15ll_B { unsigned long long v1:15; unsigned long long v2:15; bool v3; };
struct BFu15ll_BFu15s_B { unsigned long long v1:15; unsigned short v2:15; bool v3; };
struct BFu15ll_BFu16i_B { unsigned long long v1:15; unsigned int v2:16; bool v3; };
struct BFu15ll_BFu16ll_B { unsigned long long v1:15; unsigned long long v2:16; bool v3; };
struct BFu15ll_BFu16s_B { unsigned long long v1:15; unsigned short v2:16; bool v3; };
struct BFu15ll_BFu17i_B { unsigned long long v1:15; unsigned int v2:17; bool v3; };
struct BFu15ll_BFu17ll_B { unsigned long long v1:15; unsigned long long v2:17; bool v3; };
struct BFu15ll_BFu1c_B { unsigned long long v1:15; unsigned char v2:1; bool v3; };
struct BFu15ll_BFu1i_B { unsigned long long v1:15; unsigned int v2:1; bool v3; };
struct BFu15ll_BFu1ll_B { unsigned long long v1:15; unsigned long long v2:1; bool v3; };
struct BFu15ll_BFu1s_B { unsigned long long v1:15; unsigned short v2:1; bool v3; };
struct BFu15ll_BFu31i_B { unsigned long long v1:15; unsigned int v2:31; bool v3; };
struct BFu15ll_BFu31ll_B { unsigned long long v1:15; unsigned long long v2:31; bool v3; };
struct BFu15ll_BFu32i_B { unsigned long long v1:15; unsigned int v2:32; bool v3; };
struct BFu15ll_BFu32ll_B { unsigned long long v1:15; unsigned long long v2:32; bool v3; };
struct BFu15ll_BFu33_B { unsigned long long v1:15; unsigned long long v2:33; bool v3; };
struct BFu15ll_BFu7c_B { unsigned long long v1:15; unsigned char v2:7; bool v3; };
struct BFu15ll_BFu7i_B { unsigned long long v1:15; unsigned int v2:7; bool v3; };
struct BFu15ll_BFu7ll_B { unsigned long long v1:15; unsigned long long v2:7; bool v3; };
struct BFu15ll_BFu7s_B { unsigned long long v1:15; unsigned short v2:7; bool v3; };
struct BFu15ll_BFu8c_B { unsigned long long v1:15; unsigned char v2:8; bool v3; };
struct BFu15ll_BFu8i_B { unsigned long long v1:15; unsigned int v2:8; bool v3; };
struct BFu15ll_BFu8ll_B { unsigned long long v1:15; unsigned long long v2:8; bool v3; };
struct BFu15ll_BFu8s_B { unsigned long long v1:15; unsigned short v2:8; bool v3; };
struct BFu15ll_BFu9i_B { unsigned long long v1:15; unsigned int v2:9; bool v3; };
struct BFu15ll_BFu9ll_B { unsigned long long v1:15; unsigned long long v2:9; bool v3; };
struct BFu15ll_BFu9s_B { unsigned long long v1:15; unsigned short v2:9; bool v3; };
struct BFu15ll_C_B { unsigned long long v1:15; char v2; bool v3; };
struct BFu15ll_D_B { unsigned long long v1:15; double v2; bool v3; };
struct BFu15ll_F_B { unsigned long long v1:15; float v2; bool v3; };
struct BFu15ll_I_B { unsigned long long v1:15; int v2; bool v3; };
struct BFu15ll_Ip_B { unsigned long long v1:15; int * v2; bool v3; };
struct BFu15ll_L_B { unsigned long long v1:15; long long v2; bool v3; };
struct BFu15ll_S_B { unsigned long long v1:15; short v2; bool v3; };
struct BFu15ll_Uc_B { unsigned long long v1:15; unsigned char v2; bool v3; };
struct BFu15ll_Ui_B { unsigned long long v1:15; unsigned int v2; bool v3; };
struct BFu15ll_Ul_B { unsigned long long v1:15; unsigned long long v2; bool v3; };
struct BFu15ll_Us_B { unsigned long long v1:15; unsigned short v2; bool v3; };
struct BFu15ll_Vp_B { unsigned long long v1:15; void * v2; bool v3; };
struct BFu15s_B { unsigned short v1:15; bool v2; };
struct BFu15s_B_B { unsigned short v1:15; bool v2; bool v3; };
struct BFu15s_B_BFu15i { unsigned short v1:15; bool v2; unsigned int v3:15; };
struct BFu15s_B_BFu15ll { unsigned short v1:15; bool v2; unsigned long long v3:15; };
struct BFu15s_B_BFu15s { unsigned short v1:15; bool v2; unsigned short v3:15; };
struct BFu15s_B_BFu16i { unsigned short v1:15; bool v2; unsigned int v3:16; };
struct BFu15s_B_BFu16ll { unsigned short v1:15; bool v2; unsigned long long v3:16; };
struct BFu15s_B_BFu16s { unsigned short v1:15; bool v2; unsigned short v3:16; };
struct BFu15s_B_BFu17i { unsigned short v1:15; bool v2; unsigned int v3:17; };
struct BFu15s_B_BFu17ll { unsigned short v1:15; bool v2; unsigned long long v3:17; };
struct BFu15s_B_BFu1c { unsigned short v1:15; bool v2; unsigned char v3:1; };
struct BFu15s_B_BFu1i { unsigned short v1:15; bool v2; unsigned int v3:1; };
struct BFu15s_B_BFu1ll { unsigned short v1:15; bool v2; unsigned long long v3:1; };
struct BFu15s_B_BFu1s { unsigned short v1:15; bool v2; unsigned short v3:1; };
struct BFu15s_B_BFu31i { unsigned short v1:15; bool v2; unsigned int v3:31; };
struct BFu15s_B_BFu31ll { unsigned short v1:15; bool v2; unsigned long long v3:31; };
struct BFu15s_B_BFu32i { unsigned short v1:15; bool v2; unsigned int v3:32; };
struct BFu15s_B_BFu32ll { unsigned short v1:15; bool v2; unsigned long long v3:32; };
struct BFu15s_B_BFu33 { unsigned short v1:15; bool v2; unsigned long long v3:33; };
struct BFu15s_B_BFu7c { unsigned short v1:15; bool v2; unsigned char v3:7; };
struct BFu15s_B_BFu7i { unsigned short v1:15; bool v2; unsigned int v3:7; };
struct BFu15s_B_BFu7ll { unsigned short v1:15; bool v2; unsigned long long v3:7; };
struct BFu15s_B_BFu7s { unsigned short v1:15; bool v2; unsigned short v3:7; };
struct BFu15s_B_BFu8c { unsigned short v1:15; bool v2; unsigned char v3:8; };
struct BFu15s_B_BFu8i { unsigned short v1:15; bool v2; unsigned int v3:8; };
struct BFu15s_B_BFu8ll { unsigned short v1:15; bool v2; unsigned long long v3:8; };
struct BFu15s_B_BFu8s { unsigned short v1:15; bool v2; unsigned short v3:8; };
struct BFu15s_B_BFu9i { unsigned short v1:15; bool v2; unsigned int v3:9; };
struct BFu15s_B_BFu9ll { unsigned short v1:15; bool v2; unsigned long long v3:9; };
struct BFu15s_B_BFu9s { unsigned short v1:15; bool v2; unsigned short v3:9; };
struct BFu15s_B_C { unsigned short v1:15; bool v2; char v3; };
struct BFu15s_B_D { unsigned short v1:15; bool v2; double v3; };
struct BFu15s_B_F { unsigned short v1:15; bool v2; float v3; };
struct BFu15s_B_I { unsigned short v1:15; bool v2; int v3; };
struct BFu15s_B_Ip { unsigned short v1:15; bool v2; int * v3; };
struct BFu15s_B_L { unsigned short v1:15; bool v2; long long v3; };
struct BFu15s_B_S { unsigned short v1:15; bool v2; short v3; };
struct BFu15s_B_Uc { unsigned short v1:15; bool v2; unsigned char v3; };
struct BFu15s_B_Ui { unsigned short v1:15; bool v2; unsigned int v3; };
struct BFu15s_B_Ul { unsigned short v1:15; bool v2; unsigned long long v3; };
struct BFu15s_B_Us { unsigned short v1:15; bool v2; unsigned short v3; };
struct BFu15s_B_Vp { unsigned short v1:15; bool v2; void * v3; };
struct BFu15s_BFu15i_B { unsigned short v1:15; unsigned int v2:15; bool v3; };
struct BFu15s_BFu15ll_B { unsigned short v1:15; unsigned long long v2:15; bool v3; };
struct BFu15s_BFu15s_B { unsigned short v1:15; unsigned short v2:15; bool v3; };
struct BFu15s_BFu16i_B { unsigned short v1:15; unsigned int v2:16; bool v3; };
struct BFu15s_BFu16ll_B { unsigned short v1:15; unsigned long long v2:16; bool v3; };
struct BFu15s_BFu16s_B { unsigned short v1:15; unsigned short v2:16; bool v3; };
struct BFu15s_BFu17i_B { unsigned short v1:15; unsigned int v2:17; bool v3; };
struct BFu15s_BFu17ll_B { unsigned short v1:15; unsigned long long v2:17; bool v3; };
struct BFu15s_BFu1c_B { unsigned short v1:15; unsigned char v2:1; bool v3; };
struct BFu15s_BFu1i_B { unsigned short v1:15; unsigned int v2:1; bool v3; };
struct BFu15s_BFu1ll_B { unsigned short v1:15; unsigned long long v2:1; bool v3; };
struct BFu15s_BFu1s_B { unsigned short v1:15; unsigned short v2:1; bool v3; };
struct BFu15s_BFu31i_B { unsigned short v1:15; unsigned int v2:31; bool v3; };
struct BFu15s_BFu31ll_B { unsigned short v1:15; unsigned long long v2:31; bool v3; };
struct BFu15s_BFu32i_B { unsigned short v1:15; unsigned int v2:32; bool v3; };
struct BFu15s_BFu32ll_B { unsigned short v1:15; unsigned long long v2:32; bool v3; };
struct BFu15s_BFu33_B { unsigned short v1:15; unsigned long long v2:33; bool v3; };
struct BFu15s_BFu7c_B { unsigned short v1:15; unsigned char v2:7; bool v3; };
struct BFu15s_BFu7i_B { unsigned short v1:15; unsigned int v2:7; bool v3; };
struct BFu15s_BFu7ll_B { unsigned short v1:15; unsigned long long v2:7; bool v3; };
struct BFu15s_BFu7s_B { unsigned short v1:15; unsigned short v2:7; bool v3; };
struct BFu15s_BFu8c_B { unsigned short v1:15; unsigned char v2:8; bool v3; };
struct BFu15s_BFu8i_B { unsigned short v1:15; unsigned int v2:8; bool v3; };
struct BFu15s_BFu8ll_B { unsigned short v1:15; unsigned long long v2:8; bool v3; };
struct BFu15s_BFu8s_B { unsigned short v1:15; unsigned short v2:8; bool v3; };
struct BFu15s_BFu9i_B { unsigned short v1:15; unsigned int v2:9; bool v3; };
struct BFu15s_BFu9ll_B { unsigned short v1:15; unsigned long long v2:9; bool v3; };
struct BFu15s_BFu9s_B { unsigned short v1:15; unsigned short v2:9; bool v3; };
struct BFu15s_C_B { unsigned short v1:15; char v2; bool v3; };
struct BFu15s_D_B { unsigned short v1:15; double v2; bool v3; };
struct BFu15s_F_B { unsigned short v1:15; float v2; bool v3; };
struct BFu15s_I_B { unsigned short v1:15; int v2; bool v3; };
struct BFu15s_Ip_B { unsigned short v1:15; int * v2; bool v3; };
struct BFu15s_L_B { unsigned short v1:15; long long v2; bool v3; };
struct BFu15s_S_B { unsigned short v1:15; short v2; bool v3; };
struct BFu15s_Uc_B { unsigned short v1:15; unsigned char v2; bool v3; };
struct BFu15s_Ui_B { unsigned short v1:15; unsigned int v2; bool v3; };
struct BFu15s_Ul_B { unsigned short v1:15; unsigned long long v2; bool v3; };
struct BFu15s_Us_B { unsigned short v1:15; unsigned short v2; bool v3; };
struct BFu15s_Vp_B { unsigned short v1:15; void * v2; bool v3; };
struct BFu16i_B { unsigned int v1:16; bool v2; };
struct BFu16i_B_B { unsigned int v1:16; bool v2; bool v3; };
struct BFu16i_B_BFu15i { unsigned int v1:16; bool v2; unsigned int v3:15; };
struct BFu16i_B_BFu15ll { unsigned int v1:16; bool v2; unsigned long long v3:15; };
struct BFu16i_B_BFu15s { unsigned int v1:16; bool v2; unsigned short v3:15; };
struct BFu16i_B_BFu16i { unsigned int v1:16; bool v2; unsigned int v3:16; };
struct BFu16i_B_BFu16ll { unsigned int v1:16; bool v2; unsigned long long v3:16; };
struct BFu16i_B_BFu16s { unsigned int v1:16; bool v2; unsigned short v3:16; };
struct BFu16i_B_BFu17i { unsigned int v1:16; bool v2; unsigned int v3:17; };
struct BFu16i_B_BFu17ll { unsigned int v1:16; bool v2; unsigned long long v3:17; };
struct BFu16i_B_BFu1c { unsigned int v1:16; bool v2; unsigned char v3:1; };
struct BFu16i_B_BFu1i { unsigned int v1:16; bool v2; unsigned int v3:1; };
struct BFu16i_B_BFu1ll { unsigned int v1:16; bool v2; unsigned long long v3:1; };
struct BFu16i_B_BFu1s { unsigned int v1:16; bool v2; unsigned short v3:1; };
struct BFu16i_B_BFu31i { unsigned int v1:16; bool v2; unsigned int v3:31; };
struct BFu16i_B_BFu31ll { unsigned int v1:16; bool v2; unsigned long long v3:31; };
struct BFu16i_B_BFu32i { unsigned int v1:16; bool v2; unsigned int v3:32; };
struct BFu16i_B_BFu32ll { unsigned int v1:16; bool v2; unsigned long long v3:32; };
struct BFu16i_B_BFu33 { unsigned int v1:16; bool v2; unsigned long long v3:33; };
struct BFu16i_B_BFu7c { unsigned int v1:16; bool v2; unsigned char v3:7; };
struct BFu16i_B_BFu7i { unsigned int v1:16; bool v2; unsigned int v3:7; };
struct BFu16i_B_BFu7ll { unsigned int v1:16; bool v2; unsigned long long v3:7; };
struct BFu16i_B_BFu7s { unsigned int v1:16; bool v2; unsigned short v3:7; };
struct BFu16i_B_BFu8c { unsigned int v1:16; bool v2; unsigned char v3:8; };
struct BFu16i_B_BFu8i { unsigned int v1:16; bool v2; unsigned int v3:8; };
struct BFu16i_B_BFu8ll { unsigned int v1:16; bool v2; unsigned long long v3:8; };
struct BFu16i_B_BFu8s { unsigned int v1:16; bool v2; unsigned short v3:8; };
struct BFu16i_B_BFu9i { unsigned int v1:16; bool v2; unsigned int v3:9; };
struct BFu16i_B_BFu9ll { unsigned int v1:16; bool v2; unsigned long long v3:9; };
struct BFu16i_B_BFu9s { unsigned int v1:16; bool v2; unsigned short v3:9; };
struct BFu16i_B_C { unsigned int v1:16; bool v2; char v3; };
struct BFu16i_B_D { unsigned int v1:16; bool v2; double v3; };
struct BFu16i_B_F { unsigned int v1:16; bool v2; float v3; };
struct BFu16i_B_I { unsigned int v1:16; bool v2; int v3; };
struct BFu16i_B_Ip { unsigned int v1:16; bool v2; int * v3; };
struct BFu16i_B_L { unsigned int v1:16; bool v2; long long v3; };
struct BFu16i_B_S { unsigned int v1:16; bool v2; short v3; };
struct BFu16i_B_Uc { unsigned int v1:16; bool v2; unsigned char v3; };
struct BFu16i_B_Ui { unsigned int v1:16; bool v2; unsigned int v3; };
struct BFu16i_B_Ul { unsigned int v1:16; bool v2; unsigned long long v3; };
struct BFu16i_B_Us { unsigned int v1:16; bool v2; unsigned short v3; };
struct BFu16i_B_Vp { unsigned int v1:16; bool v2; void * v3; };
struct BFu16i_BFu15i_B { unsigned int v1:16; unsigned int v2:15; bool v3; };
struct BFu16i_BFu15ll_B { unsigned int v1:16; unsigned long long v2:15; bool v3; };
struct BFu16i_BFu15s_B { unsigned int v1:16; unsigned short v2:15; bool v3; };
struct BFu16i_BFu16i_B { unsigned int v1:16; unsigned int v2:16; bool v3; };
struct BFu16i_BFu16ll_B { unsigned int v1:16; unsigned long long v2:16; bool v3; };
struct BFu16i_BFu16s_B { unsigned int v1:16; unsigned short v2:16; bool v3; };
struct BFu16i_BFu17i_B { unsigned int v1:16; unsigned int v2:17; bool v3; };
struct BFu16i_BFu17ll_B { unsigned int v1:16; unsigned long long v2:17; bool v3; };
struct BFu16i_BFu1c_B { unsigned int v1:16; unsigned char v2:1; bool v3; };
struct BFu16i_BFu1i_B { unsigned int v1:16; unsigned int v2:1; bool v3; };
struct BFu16i_BFu1ll_B { unsigned int v1:16; unsigned long long v2:1; bool v3; };
struct BFu16i_BFu1s_B { unsigned int v1:16; unsigned short v2:1; bool v3; };
struct BFu16i_BFu31i_B { unsigned int v1:16; unsigned int v2:31; bool v3; };
struct BFu16i_BFu31ll_B { unsigned int v1:16; unsigned long long v2:31; bool v3; };
struct BFu16i_BFu32i_B { unsigned int v1:16; unsigned int v2:32; bool v3; };
struct BFu16i_BFu32ll_B { unsigned int v1:16; unsigned long long v2:32; bool v3; };
struct BFu16i_BFu33_B { unsigned int v1:16; unsigned long long v2:33; bool v3; };
struct BFu16i_BFu7c_B { unsigned int v1:16; unsigned char v2:7; bool v3; };
struct BFu16i_BFu7i_B { unsigned int v1:16; unsigned int v2:7; bool v3; };
struct BFu16i_BFu7ll_B { unsigned int v1:16; unsigned long long v2:7; bool v3; };
struct BFu16i_BFu7s_B { unsigned int v1:16; unsigned short v2:7; bool v3; };
struct BFu16i_BFu8c_B { unsigned int v1:16; unsigned char v2:8; bool v3; };
struct BFu16i_BFu8i_B { unsigned int v1:16; unsigned int v2:8; bool v3; };
struct BFu16i_BFu8ll_B { unsigned int v1:16; unsigned long long v2:8; bool v3; };
struct BFu16i_BFu8s_B { unsigned int v1:16; unsigned short v2:8; bool v3; };
struct BFu16i_BFu9i_B { unsigned int v1:16; unsigned int v2:9; bool v3; };
struct BFu16i_BFu9ll_B { unsigned int v1:16; unsigned long long v2:9; bool v3; };
struct BFu16i_BFu9s_B { unsigned int v1:16; unsigned short v2:9; bool v3; };
struct BFu16i_C_B { unsigned int v1:16; char v2; bool v3; };
struct BFu16i_D_B { unsigned int v1:16; double v2; bool v3; };
struct BFu16i_F_B { unsigned int v1:16; float v2; bool v3; };
struct BFu16i_I_B { unsigned int v1:16; int v2; bool v3; };
struct BFu16i_Ip_B { unsigned int v1:16; int * v2; bool v3; };
struct BFu16i_L_B { unsigned int v1:16; long long v2; bool v3; };
struct BFu16i_S_B { unsigned int v1:16; short v2; bool v3; };
struct BFu16i_Uc_B { unsigned int v1:16; unsigned char v2; bool v3; };
struct BFu16i_Ui_B { unsigned int v1:16; unsigned int v2; bool v3; };
struct BFu16i_Ul_B { unsigned int v1:16; unsigned long long v2; bool v3; };
struct BFu16i_Us_B { unsigned int v1:16; unsigned short v2; bool v3; };
struct BFu16i_Vp_B { unsigned int v1:16; void * v2; bool v3; };
struct BFu16ll_B { unsigned long long v1:16; bool v2; };
struct BFu16ll_B_B { unsigned long long v1:16; bool v2; bool v3; };
struct BFu16ll_B_BFu15i { unsigned long long v1:16; bool v2; unsigned int v3:15; };
struct BFu16ll_B_BFu15ll { unsigned long long v1:16; bool v2; unsigned long long v3:15; };
struct BFu16ll_B_BFu15s { unsigned long long v1:16; bool v2; unsigned short v3:15; };
struct BFu16ll_B_BFu16i { unsigned long long v1:16; bool v2; unsigned int v3:16; };
struct BFu16ll_B_BFu16ll { unsigned long long v1:16; bool v2; unsigned long long v3:16; };
struct BFu16ll_B_BFu16s { unsigned long long v1:16; bool v2; unsigned short v3:16; };
struct BFu16ll_B_BFu17i { unsigned long long v1:16; bool v2; unsigned int v3:17; };
struct BFu16ll_B_BFu17ll { unsigned long long v1:16; bool v2; unsigned long long v3:17; };
struct BFu16ll_B_BFu1c { unsigned long long v1:16; bool v2; unsigned char v3:1; };
struct BFu16ll_B_BFu1i { unsigned long long v1:16; bool v2; unsigned int v3:1; };
struct BFu16ll_B_BFu1ll { unsigned long long v1:16; bool v2; unsigned long long v3:1; };
struct BFu16ll_B_BFu1s { unsigned long long v1:16; bool v2; unsigned short v3:1; };
struct BFu16ll_B_BFu31i { unsigned long long v1:16; bool v2; unsigned int v3:31; };
struct BFu16ll_B_BFu31ll { unsigned long long v1:16; bool v2; unsigned long long v3:31; };
struct BFu16ll_B_BFu32i { unsigned long long v1:16; bool v2; unsigned int v3:32; };
struct BFu16ll_B_BFu32ll { unsigned long long v1:16; bool v2; unsigned long long v3:32; };
struct BFu16ll_B_BFu33 { unsigned long long v1:16; bool v2; unsigned long long v3:33; };
struct BFu16ll_B_BFu7c { unsigned long long v1:16; bool v2; unsigned char v3:7; };
struct BFu16ll_B_BFu7i { unsigned long long v1:16; bool v2; unsigned int v3:7; };
struct BFu16ll_B_BFu7ll { unsigned long long v1:16; bool v2; unsigned long long v3:7; };
struct BFu16ll_B_BFu7s { unsigned long long v1:16; bool v2; unsigned short v3:7; };
struct BFu16ll_B_BFu8c { unsigned long long v1:16; bool v2; unsigned char v3:8; };
struct BFu16ll_B_BFu8i { unsigned long long v1:16; bool v2; unsigned int v3:8; };
struct BFu16ll_B_BFu8ll { unsigned long long v1:16; bool v2; unsigned long long v3:8; };
struct BFu16ll_B_BFu8s { unsigned long long v1:16; bool v2; unsigned short v3:8; };
struct BFu16ll_B_BFu9i { unsigned long long v1:16; bool v2; unsigned int v3:9; };
struct BFu16ll_B_BFu9ll { unsigned long long v1:16; bool v2; unsigned long long v3:9; };
struct BFu16ll_B_BFu9s { unsigned long long v1:16; bool v2; unsigned short v3:9; };
struct BFu16ll_B_C { unsigned long long v1:16; bool v2; char v3; };
struct BFu16ll_B_D { unsigned long long v1:16; bool v2; double v3; };
struct BFu16ll_B_F { unsigned long long v1:16; bool v2; float v3; };
struct BFu16ll_B_I { unsigned long long v1:16; bool v2; int v3; };
struct BFu16ll_B_Ip { unsigned long long v1:16; bool v2; int * v3; };
struct BFu16ll_B_L { unsigned long long v1:16; bool v2; long long v3; };
struct BFu16ll_B_S { unsigned long long v1:16; bool v2; short v3; };
struct BFu16ll_B_Uc { unsigned long long v1:16; bool v2; unsigned char v3; };
struct BFu16ll_B_Ui { unsigned long long v1:16; bool v2; unsigned int v3; };
struct BFu16ll_B_Ul { unsigned long long v1:16; bool v2; unsigned long long v3; };
struct BFu16ll_B_Us { unsigned long long v1:16; bool v2; unsigned short v3; };
struct BFu16ll_B_Vp { unsigned long long v1:16; bool v2; void * v3; };
struct BFu16ll_BFu15i_B { unsigned long long v1:16; unsigned int v2:15; bool v3; };
struct BFu16ll_BFu15ll_B { unsigned long long v1:16; unsigned long long v2:15; bool v3; };
struct BFu16ll_BFu15s_B { unsigned long long v1:16; unsigned short v2:15; bool v3; };
struct BFu16ll_BFu16i_B { unsigned long long v1:16; unsigned int v2:16; bool v3; };
struct BFu16ll_BFu16ll_B { unsigned long long v1:16; unsigned long long v2:16; bool v3; };
struct BFu16ll_BFu16s_B { unsigned long long v1:16; unsigned short v2:16; bool v3; };
struct BFu16ll_BFu17i_B { unsigned long long v1:16; unsigned int v2:17; bool v3; };
struct BFu16ll_BFu17ll_B { unsigned long long v1:16; unsigned long long v2:17; bool v3; };
struct BFu16ll_BFu1c_B { unsigned long long v1:16; unsigned char v2:1; bool v3; };
struct BFu16ll_BFu1i_B { unsigned long long v1:16; unsigned int v2:1; bool v3; };
struct BFu16ll_BFu1ll_B { unsigned long long v1:16; unsigned long long v2:1; bool v3; };
struct BFu16ll_BFu1s_B { unsigned long long v1:16; unsigned short v2:1; bool v3; };
struct BFu16ll_BFu31i_B { unsigned long long v1:16; unsigned int v2:31; bool v3; };
struct BFu16ll_BFu31ll_B { unsigned long long v1:16; unsigned long long v2:31; bool v3; };
struct BFu16ll_BFu32i_B { unsigned long long v1:16; unsigned int v2:32; bool v3; };
struct BFu16ll_BFu32ll_B { unsigned long long v1:16; unsigned long long v2:32; bool v3; };
struct BFu16ll_BFu33_B { unsigned long long v1:16; unsigned long long v2:33; bool v3; };
struct BFu16ll_BFu7c_B { unsigned long long v1:16; unsigned char v2:7; bool v3; };
struct BFu16ll_BFu7i_B { unsigned long long v1:16; unsigned int v2:7; bool v3; };
struct BFu16ll_BFu7ll_B { unsigned long long v1:16; unsigned long long v2:7; bool v3; };
struct BFu16ll_BFu7s_B { unsigned long long v1:16; unsigned short v2:7; bool v3; };
struct BFu16ll_BFu8c_B { unsigned long long v1:16; unsigned char v2:8; bool v3; };
struct BFu16ll_BFu8i_B { unsigned long long v1:16; unsigned int v2:8; bool v3; };
struct BFu16ll_BFu8ll_B { unsigned long long v1:16; unsigned long long v2:8; bool v3; };
struct BFu16ll_BFu8s_B { unsigned long long v1:16; unsigned short v2:8; bool v3; };
struct BFu16ll_BFu9i_B { unsigned long long v1:16; unsigned int v2:9; bool v3; };
struct BFu16ll_BFu9ll_B { unsigned long long v1:16; unsigned long long v2:9; bool v3; };
struct BFu16ll_BFu9s_B { unsigned long long v1:16; unsigned short v2:9; bool v3; };
struct BFu16ll_C_B { unsigned long long v1:16; char v2; bool v3; };
struct BFu16ll_D_B { unsigned long long v1:16; double v2; bool v3; };
struct BFu16ll_F_B { unsigned long long v1:16; float v2; bool v3; };
struct BFu16ll_I_B { unsigned long long v1:16; int v2; bool v3; };
struct BFu16ll_Ip_B { unsigned long long v1:16; int * v2; bool v3; };
struct BFu16ll_L_B { unsigned long long v1:16; long long v2; bool v3; };
struct BFu16ll_S_B { unsigned long long v1:16; short v2; bool v3; };
struct BFu16ll_Uc_B { unsigned long long v1:16; unsigned char v2; bool v3; };
struct BFu16ll_Ui_B { unsigned long long v1:16; unsigned int v2; bool v3; };
struct BFu16ll_Ul_B { unsigned long long v1:16; unsigned long long v2; bool v3; };
struct BFu16ll_Us_B { unsigned long long v1:16; unsigned short v2; bool v3; };
struct BFu16ll_Vp_B { unsigned long long v1:16; void * v2; bool v3; };
struct BFu16s_B { unsigned short v1:16; bool v2; };
struct BFu16s_B_B { unsigned short v1:16; bool v2; bool v3; };
struct BFu16s_B_BFu15i { unsigned short v1:16; bool v2; unsigned int v3:15; };
struct BFu16s_B_BFu15ll { unsigned short v1:16; bool v2; unsigned long long v3:15; };
struct BFu16s_B_BFu15s { unsigned short v1:16; bool v2; unsigned short v3:15; };
struct BFu16s_B_BFu16i { unsigned short v1:16; bool v2; unsigned int v3:16; };
struct BFu16s_B_BFu16ll { unsigned short v1:16; bool v2; unsigned long long v3:16; };
struct BFu16s_B_BFu16s { unsigned short v1:16; bool v2; unsigned short v3:16; };
struct BFu16s_B_BFu17i { unsigned short v1:16; bool v2; unsigned int v3:17; };
struct BFu16s_B_BFu17ll { unsigned short v1:16; bool v2; unsigned long long v3:17; };
struct BFu16s_B_BFu1c { unsigned short v1:16; bool v2; unsigned char v3:1; };
struct BFu16s_B_BFu1i { unsigned short v1:16; bool v2; unsigned int v3:1; };
struct BFu16s_B_BFu1ll { unsigned short v1:16; bool v2; unsigned long long v3:1; };
struct BFu16s_B_BFu1s { unsigned short v1:16; bool v2; unsigned short v3:1; };
struct BFu16s_B_BFu31i { unsigned short v1:16; bool v2; unsigned int v3:31; };
struct BFu16s_B_BFu31ll { unsigned short v1:16; bool v2; unsigned long long v3:31; };
struct BFu16s_B_BFu32i { unsigned short v1:16; bool v2; unsigned int v3:32; };
struct BFu16s_B_BFu32ll { unsigned short v1:16; bool v2; unsigned long long v3:32; };
struct BFu16s_B_BFu33 { unsigned short v1:16; bool v2; unsigned long long v3:33; };
struct BFu16s_B_BFu7c { unsigned short v1:16; bool v2; unsigned char v3:7; };
struct BFu16s_B_BFu7i { unsigned short v1:16; bool v2; unsigned int v3:7; };
struct BFu16s_B_BFu7ll { unsigned short v1:16; bool v2; unsigned long long v3:7; };
struct BFu16s_B_BFu7s { unsigned short v1:16; bool v2; unsigned short v3:7; };
struct BFu16s_B_BFu8c { unsigned short v1:16; bool v2; unsigned char v3:8; };
struct BFu16s_B_BFu8i { unsigned short v1:16; bool v2; unsigned int v3:8; };
struct BFu16s_B_BFu8ll { unsigned short v1:16; bool v2; unsigned long long v3:8; };
struct BFu16s_B_BFu8s { unsigned short v1:16; bool v2; unsigned short v3:8; };
struct BFu16s_B_BFu9i { unsigned short v1:16; bool v2; unsigned int v3:9; };
struct BFu16s_B_BFu9ll { unsigned short v1:16; bool v2; unsigned long long v3:9; };
struct BFu16s_B_BFu9s { unsigned short v1:16; bool v2; unsigned short v3:9; };
struct BFu16s_B_C { unsigned short v1:16; bool v2; char v3; };
struct BFu16s_B_D { unsigned short v1:16; bool v2; double v3; };
struct BFu16s_B_F { unsigned short v1:16; bool v2; float v3; };
struct BFu16s_B_I { unsigned short v1:16; bool v2; int v3; };
struct BFu16s_B_Ip { unsigned short v1:16; bool v2; int * v3; };
struct BFu16s_B_L { unsigned short v1:16; bool v2; long long v3; };
struct BFu16s_B_S { unsigned short v1:16; bool v2; short v3; };
struct BFu16s_B_Uc { unsigned short v1:16; bool v2; unsigned char v3; };
struct BFu16s_B_Ui { unsigned short v1:16; bool v2; unsigned int v3; };
struct BFu16s_B_Ul { unsigned short v1:16; bool v2; unsigned long long v3; };
struct BFu16s_B_Us { unsigned short v1:16; bool v2; unsigned short v3; };
struct BFu16s_B_Vp { unsigned short v1:16; bool v2; void * v3; };
struct BFu16s_BFu15i_B { unsigned short v1:16; unsigned int v2:15; bool v3; };
struct BFu16s_BFu15ll_B { unsigned short v1:16; unsigned long long v2:15; bool v3; };
struct BFu16s_BFu15s_B { unsigned short v1:16; unsigned short v2:15; bool v3; };
struct BFu16s_BFu16i_B { unsigned short v1:16; unsigned int v2:16; bool v3; };
struct BFu16s_BFu16ll_B { unsigned short v1:16; unsigned long long v2:16; bool v3; };
struct BFu16s_BFu16s_B { unsigned short v1:16; unsigned short v2:16; bool v3; };
struct BFu16s_BFu17i_B { unsigned short v1:16; unsigned int v2:17; bool v3; };
struct BFu16s_BFu17ll_B { unsigned short v1:16; unsigned long long v2:17; bool v3; };
struct BFu16s_BFu1c_B { unsigned short v1:16; unsigned char v2:1; bool v3; };
struct BFu16s_BFu1i_B { unsigned short v1:16; unsigned int v2:1; bool v3; };
struct BFu16s_BFu1ll_B { unsigned short v1:16; unsigned long long v2:1; bool v3; };
struct BFu16s_BFu1s_B { unsigned short v1:16; unsigned short v2:1; bool v3; };
struct BFu16s_BFu31i_B { unsigned short v1:16; unsigned int v2:31; bool v3; };
struct BFu16s_BFu31ll_B { unsigned short v1:16; unsigned long long v2:31; bool v3; };
struct BFu16s_BFu32i_B { unsigned short v1:16; unsigned int v2:32; bool v3; };
struct BFu16s_BFu32ll_B { unsigned short v1:16; unsigned long long v2:32; bool v3; };
struct BFu16s_BFu33_B { unsigned short v1:16; unsigned long long v2:33; bool v3; };
struct BFu16s_BFu7c_B { unsigned short v1:16; unsigned char v2:7; bool v3; };
struct BFu16s_BFu7i_B { unsigned short v1:16; unsigned int v2:7; bool v3; };
struct BFu16s_BFu7ll_B { unsigned short v1:16; unsigned long long v2:7; bool v3; };
struct BFu16s_BFu7s_B { unsigned short v1:16; unsigned short v2:7; bool v3; };
struct BFu16s_BFu8c_B { unsigned short v1:16; unsigned char v2:8; bool v3; };
struct BFu16s_BFu8i_B { unsigned short v1:16; unsigned int v2:8; bool v3; };
struct BFu16s_BFu8ll_B { unsigned short v1:16; unsigned long long v2:8; bool v3; };
struct BFu16s_BFu8s_B { unsigned short v1:16; unsigned short v2:8; bool v3; };
struct BFu16s_BFu9i_B { unsigned short v1:16; unsigned int v2:9; bool v3; };
struct BFu16s_BFu9ll_B { unsigned short v1:16; unsigned long long v2:9; bool v3; };
struct BFu16s_BFu9s_B { unsigned short v1:16; unsigned short v2:9; bool v3; };
struct BFu16s_C_B { unsigned short v1:16; char v2; bool v3; };
struct BFu16s_D_B { unsigned short v1:16; double v2; bool v3; };
struct BFu16s_F_B { unsigned short v1:16; float v2; bool v3; };
struct BFu16s_I_B { unsigned short v1:16; int v2; bool v3; };
struct BFu16s_Ip_B { unsigned short v1:16; int * v2; bool v3; };
struct BFu16s_L_B { unsigned short v1:16; long long v2; bool v3; };
struct BFu16s_S_B { unsigned short v1:16; short v2; bool v3; };
struct BFu16s_Uc_B { unsigned short v1:16; unsigned char v2; bool v3; };
struct BFu16s_Ui_B { unsigned short v1:16; unsigned int v2; bool v3; };
struct BFu16s_Ul_B { unsigned short v1:16; unsigned long long v2; bool v3; };
struct BFu16s_Us_B { unsigned short v1:16; unsigned short v2; bool v3; };
struct BFu16s_Vp_B { unsigned short v1:16; void * v2; bool v3; };
struct BFu17i_B { unsigned int v1:17; bool v2; };
struct BFu17i_B_B { unsigned int v1:17; bool v2; bool v3; };
struct BFu17i_B_BFu15i { unsigned int v1:17; bool v2; unsigned int v3:15; };
struct BFu17i_B_BFu15ll { unsigned int v1:17; bool v2; unsigned long long v3:15; };
struct BFu17i_B_BFu15s { unsigned int v1:17; bool v2; unsigned short v3:15; };
struct BFu17i_B_BFu16i { unsigned int v1:17; bool v2; unsigned int v3:16; };
struct BFu17i_B_BFu16ll { unsigned int v1:17; bool v2; unsigned long long v3:16; };
struct BFu17i_B_BFu16s { unsigned int v1:17; bool v2; unsigned short v3:16; };
struct BFu17i_B_BFu17i { unsigned int v1:17; bool v2; unsigned int v3:17; };
struct BFu17i_B_BFu17ll { unsigned int v1:17; bool v2; unsigned long long v3:17; };
struct BFu17i_B_BFu1c { unsigned int v1:17; bool v2; unsigned char v3:1; };
struct BFu17i_B_BFu1i { unsigned int v1:17; bool v2; unsigned int v3:1; };
struct BFu17i_B_BFu1ll { unsigned int v1:17; bool v2; unsigned long long v3:1; };
struct BFu17i_B_BFu1s { unsigned int v1:17; bool v2; unsigned short v3:1; };
struct BFu17i_B_BFu31i { unsigned int v1:17; bool v2; unsigned int v3:31; };
struct BFu17i_B_BFu31ll { unsigned int v1:17; bool v2; unsigned long long v3:31; };
struct BFu17i_B_BFu32i { unsigned int v1:17; bool v2; unsigned int v3:32; };
struct BFu17i_B_BFu32ll { unsigned int v1:17; bool v2; unsigned long long v3:32; };
struct BFu17i_B_BFu33 { unsigned int v1:17; bool v2; unsigned long long v3:33; };
struct BFu17i_B_BFu7c { unsigned int v1:17; bool v2; unsigned char v3:7; };
struct BFu17i_B_BFu7i { unsigned int v1:17; bool v2; unsigned int v3:7; };
struct BFu17i_B_BFu7ll { unsigned int v1:17; bool v2; unsigned long long v3:7; };
struct BFu17i_B_BFu7s { unsigned int v1:17; bool v2; unsigned short v3:7; };
struct BFu17i_B_BFu8c { unsigned int v1:17; bool v2; unsigned char v3:8; };
struct BFu17i_B_BFu8i { unsigned int v1:17; bool v2; unsigned int v3:8; };
struct BFu17i_B_BFu8ll { unsigned int v1:17; bool v2; unsigned long long v3:8; };
struct BFu17i_B_BFu8s { unsigned int v1:17; bool v2; unsigned short v3:8; };
struct BFu17i_B_BFu9i { unsigned int v1:17; bool v2; unsigned int v3:9; };
struct BFu17i_B_BFu9ll { unsigned int v1:17; bool v2; unsigned long long v3:9; };
struct BFu17i_B_BFu9s { unsigned int v1:17; bool v2; unsigned short v3:9; };
struct BFu17i_B_C { unsigned int v1:17; bool v2; char v3; };
struct BFu17i_B_D { unsigned int v1:17; bool v2; double v3; };
struct BFu17i_B_F { unsigned int v1:17; bool v2; float v3; };
struct BFu17i_B_I { unsigned int v1:17; bool v2; int v3; };
struct BFu17i_B_Ip { unsigned int v1:17; bool v2; int * v3; };
struct BFu17i_B_L { unsigned int v1:17; bool v2; long long v3; };
struct BFu17i_B_S { unsigned int v1:17; bool v2; short v3; };
struct BFu17i_B_Uc { unsigned int v1:17; bool v2; unsigned char v3; };
struct BFu17i_B_Ui { unsigned int v1:17; bool v2; unsigned int v3; };
struct BFu17i_B_Ul { unsigned int v1:17; bool v2; unsigned long long v3; };
struct BFu17i_B_Us { unsigned int v1:17; bool v2; unsigned short v3; };
struct BFu17i_B_Vp { unsigned int v1:17; bool v2; void * v3; };
struct BFu17i_BFu15i_B { unsigned int v1:17; unsigned int v2:15; bool v3; };
struct BFu17i_BFu15ll_B { unsigned int v1:17; unsigned long long v2:15; bool v3; };
struct BFu17i_BFu15s_B { unsigned int v1:17; unsigned short v2:15; bool v3; };
struct BFu17i_BFu16i_B { unsigned int v1:17; unsigned int v2:16; bool v3; };
struct BFu17i_BFu16ll_B { unsigned int v1:17; unsigned long long v2:16; bool v3; };
struct BFu17i_BFu16s_B { unsigned int v1:17; unsigned short v2:16; bool v3; };
struct BFu17i_BFu17i_B { unsigned int v1:17; unsigned int v2:17; bool v3; };
struct BFu17i_BFu17ll_B { unsigned int v1:17; unsigned long long v2:17; bool v3; };
struct BFu17i_BFu1c_B { unsigned int v1:17; unsigned char v2:1; bool v3; };
struct BFu17i_BFu1i_B { unsigned int v1:17; unsigned int v2:1; bool v3; };
struct BFu17i_BFu1ll_B { unsigned int v1:17; unsigned long long v2:1; bool v3; };
struct BFu17i_BFu1s_B { unsigned int v1:17; unsigned short v2:1; bool v3; };
struct BFu17i_BFu31i_B { unsigned int v1:17; unsigned int v2:31; bool v3; };
struct BFu17i_BFu31ll_B { unsigned int v1:17; unsigned long long v2:31; bool v3; };
struct BFu17i_BFu32i_B { unsigned int v1:17; unsigned int v2:32; bool v3; };
struct BFu17i_BFu32ll_B { unsigned int v1:17; unsigned long long v2:32; bool v3; };
struct BFu17i_BFu33_B { unsigned int v1:17; unsigned long long v2:33; bool v3; };
struct BFu17i_BFu7c_B { unsigned int v1:17; unsigned char v2:7; bool v3; };
struct BFu17i_BFu7i_B { unsigned int v1:17; unsigned int v2:7; bool v3; };
struct BFu17i_BFu7ll_B { unsigned int v1:17; unsigned long long v2:7; bool v3; };
struct BFu17i_BFu7s_B { unsigned int v1:17; unsigned short v2:7; bool v3; };
struct BFu17i_BFu8c_B { unsigned int v1:17; unsigned char v2:8; bool v3; };
struct BFu17i_BFu8i_B { unsigned int v1:17; unsigned int v2:8; bool v3; };
struct BFu17i_BFu8ll_B { unsigned int v1:17; unsigned long long v2:8; bool v3; };
struct BFu17i_BFu8s_B { unsigned int v1:17; unsigned short v2:8; bool v3; };
struct BFu17i_BFu9i_B { unsigned int v1:17; unsigned int v2:9; bool v3; };
struct BFu17i_BFu9ll_B { unsigned int v1:17; unsigned long long v2:9; bool v3; };
struct BFu17i_BFu9s_B { unsigned int v1:17; unsigned short v2:9; bool v3; };
struct BFu17i_C_B { unsigned int v1:17; char v2; bool v3; };
struct BFu17i_D_B { unsigned int v1:17; double v2; bool v3; };
struct BFu17i_F_B { unsigned int v1:17; float v2; bool v3; };
struct BFu17i_I_B { unsigned int v1:17; int v2; bool v3; };
struct BFu17i_Ip_B { unsigned int v1:17; int * v2; bool v3; };
struct BFu17i_L_B { unsigned int v1:17; long long v2; bool v3; };
struct BFu17i_S_B { unsigned int v1:17; short v2; bool v3; };
struct BFu17i_Uc_B { unsigned int v1:17; unsigned char v2; bool v3; };
struct BFu17i_Ui_B { unsigned int v1:17; unsigned int v2; bool v3; };
struct BFu17i_Ul_B { unsigned int v1:17; unsigned long long v2; bool v3; };
struct BFu17i_Us_B { unsigned int v1:17; unsigned short v2; bool v3; };
struct BFu17i_Vp_B { unsigned int v1:17; void * v2; bool v3; };
struct BFu17ll_B { unsigned long long v1:17; bool v2; };
struct BFu17ll_B_B { unsigned long long v1:17; bool v2; bool v3; };
struct BFu17ll_B_BFu15i { unsigned long long v1:17; bool v2; unsigned int v3:15; };
struct BFu17ll_B_BFu15ll { unsigned long long v1:17; bool v2; unsigned long long v3:15; };
struct BFu17ll_B_BFu15s { unsigned long long v1:17; bool v2; unsigned short v3:15; };
struct BFu17ll_B_BFu16i { unsigned long long v1:17; bool v2; unsigned int v3:16; };
struct BFu17ll_B_BFu16ll { unsigned long long v1:17; bool v2; unsigned long long v3:16; };
struct BFu17ll_B_BFu16s { unsigned long long v1:17; bool v2; unsigned short v3:16; };
struct BFu17ll_B_BFu17i { unsigned long long v1:17; bool v2; unsigned int v3:17; };
struct BFu17ll_B_BFu17ll { unsigned long long v1:17; bool v2; unsigned long long v3:17; };
struct BFu17ll_B_BFu1c { unsigned long long v1:17; bool v2; unsigned char v3:1; };
struct BFu17ll_B_BFu1i { unsigned long long v1:17; bool v2; unsigned int v3:1; };
struct BFu17ll_B_BFu1ll { unsigned long long v1:17; bool v2; unsigned long long v3:1; };
struct BFu17ll_B_BFu1s { unsigned long long v1:17; bool v2; unsigned short v3:1; };
struct BFu17ll_B_BFu31i { unsigned long long v1:17; bool v2; unsigned int v3:31; };
struct BFu17ll_B_BFu31ll { unsigned long long v1:17; bool v2; unsigned long long v3:31; };
struct BFu17ll_B_BFu32i { unsigned long long v1:17; bool v2; unsigned int v3:32; };
struct BFu17ll_B_BFu32ll { unsigned long long v1:17; bool v2; unsigned long long v3:32; };
struct BFu17ll_B_BFu33 { unsigned long long v1:17; bool v2; unsigned long long v3:33; };
struct BFu17ll_B_BFu7c { unsigned long long v1:17; bool v2; unsigned char v3:7; };
struct BFu17ll_B_BFu7i { unsigned long long v1:17; bool v2; unsigned int v3:7; };
struct BFu17ll_B_BFu7ll { unsigned long long v1:17; bool v2; unsigned long long v3:7; };
struct BFu17ll_B_BFu7s { unsigned long long v1:17; bool v2; unsigned short v3:7; };
struct BFu17ll_B_BFu8c { unsigned long long v1:17; bool v2; unsigned char v3:8; };
struct BFu17ll_B_BFu8i { unsigned long long v1:17; bool v2; unsigned int v3:8; };
struct BFu17ll_B_BFu8ll { unsigned long long v1:17; bool v2; unsigned long long v3:8; };
struct BFu17ll_B_BFu8s { unsigned long long v1:17; bool v2; unsigned short v3:8; };
struct BFu17ll_B_BFu9i { unsigned long long v1:17; bool v2; unsigned int v3:9; };
struct BFu17ll_B_BFu9ll { unsigned long long v1:17; bool v2; unsigned long long v3:9; };
struct BFu17ll_B_BFu9s { unsigned long long v1:17; bool v2; unsigned short v3:9; };
struct BFu17ll_B_C { unsigned long long v1:17; bool v2; char v3; };
struct BFu17ll_B_D { unsigned long long v1:17; bool v2; double v3; };
struct BFu17ll_B_F { unsigned long long v1:17; bool v2; float v3; };
struct BFu17ll_B_I { unsigned long long v1:17; bool v2; int v3; };
struct BFu17ll_B_Ip { unsigned long long v1:17; bool v2; int * v3; };
struct BFu17ll_B_L { unsigned long long v1:17; bool v2; long long v3; };
struct BFu17ll_B_S { unsigned long long v1:17; bool v2; short v3; };
struct BFu17ll_B_Uc { unsigned long long v1:17; bool v2; unsigned char v3; };
struct BFu17ll_B_Ui { unsigned long long v1:17; bool v2; unsigned int v3; };
struct BFu17ll_B_Ul { unsigned long long v1:17; bool v2; unsigned long long v3; };
struct BFu17ll_B_Us { unsigned long long v1:17; bool v2; unsigned short v3; };
struct BFu17ll_B_Vp { unsigned long long v1:17; bool v2; void * v3; };
struct BFu17ll_BFu15i_B { unsigned long long v1:17; unsigned int v2:15; bool v3; };
struct BFu17ll_BFu15ll_B { unsigned long long v1:17; unsigned long long v2:15; bool v3; };
struct BFu17ll_BFu15s_B { unsigned long long v1:17; unsigned short v2:15; bool v3; };
struct BFu17ll_BFu16i_B { unsigned long long v1:17; unsigned int v2:16; bool v3; };
struct BFu17ll_BFu16ll_B { unsigned long long v1:17; unsigned long long v2:16; bool v3; };
struct BFu17ll_BFu16s_B { unsigned long long v1:17; unsigned short v2:16; bool v3; };
struct BFu17ll_BFu17i_B { unsigned long long v1:17; unsigned int v2:17; bool v3; };
struct BFu17ll_BFu17ll_B { unsigned long long v1:17; unsigned long long v2:17; bool v3; };
struct BFu17ll_BFu1c_B { unsigned long long v1:17; unsigned char v2:1; bool v3; };
struct BFu17ll_BFu1i_B { unsigned long long v1:17; unsigned int v2:1; bool v3; };
struct BFu17ll_BFu1ll_B { unsigned long long v1:17; unsigned long long v2:1; bool v3; };
struct BFu17ll_BFu1s_B { unsigned long long v1:17; unsigned short v2:1; bool v3; };
struct BFu17ll_BFu31i_B { unsigned long long v1:17; unsigned int v2:31; bool v3; };
struct BFu17ll_BFu31ll_B { unsigned long long v1:17; unsigned long long v2:31; bool v3; };
struct BFu17ll_BFu32i_B { unsigned long long v1:17; unsigned int v2:32; bool v3; };
struct BFu17ll_BFu32ll_B { unsigned long long v1:17; unsigned long long v2:32; bool v3; };
struct BFu17ll_BFu33_B { unsigned long long v1:17; unsigned long long v2:33; bool v3; };
struct BFu17ll_BFu7c_B { unsigned long long v1:17; unsigned char v2:7; bool v3; };
struct BFu17ll_BFu7i_B { unsigned long long v1:17; unsigned int v2:7; bool v3; };
struct BFu17ll_BFu7ll_B { unsigned long long v1:17; unsigned long long v2:7; bool v3; };
struct BFu17ll_BFu7s_B { unsigned long long v1:17; unsigned short v2:7; bool v3; };
struct BFu17ll_BFu8c_B { unsigned long long v1:17; unsigned char v2:8; bool v3; };
struct BFu17ll_BFu8i_B { unsigned long long v1:17; unsigned int v2:8; bool v3; };
struct BFu17ll_BFu8ll_B { unsigned long long v1:17; unsigned long long v2:8; bool v3; };
struct BFu17ll_BFu8s_B { unsigned long long v1:17; unsigned short v2:8; bool v3; };
struct BFu17ll_BFu9i_B { unsigned long long v1:17; unsigned int v2:9; bool v3; };
struct BFu17ll_BFu9ll_B { unsigned long long v1:17; unsigned long long v2:9; bool v3; };
struct BFu17ll_BFu9s_B { unsigned long long v1:17; unsigned short v2:9; bool v3; };
struct BFu17ll_C_B { unsigned long long v1:17; char v2; bool v3; };
struct BFu17ll_D_B { unsigned long long v1:17; double v2; bool v3; };
struct BFu17ll_F_B { unsigned long long v1:17; float v2; bool v3; };
struct BFu17ll_I_B { unsigned long long v1:17; int v2; bool v3; };
struct BFu17ll_Ip_B { unsigned long long v1:17; int * v2; bool v3; };
struct BFu17ll_L_B { unsigned long long v1:17; long long v2; bool v3; };
struct BFu17ll_S_B { unsigned long long v1:17; short v2; bool v3; };
struct BFu17ll_Uc_B { unsigned long long v1:17; unsigned char v2; bool v3; };
struct BFu17ll_Ui_B { unsigned long long v1:17; unsigned int v2; bool v3; };
struct BFu17ll_Ul_B { unsigned long long v1:17; unsigned long long v2; bool v3; };
struct BFu17ll_Us_B { unsigned long long v1:17; unsigned short v2; bool v3; };
struct BFu17ll_Vp_B { unsigned long long v1:17; void * v2; bool v3; };
struct BFu1c_B { unsigned char v1:1; bool v2; };
struct BFu1c_B_B { unsigned char v1:1; bool v2; bool v3; };
struct BFu1c_B_BFu15i { unsigned char v1:1; bool v2; unsigned int v3:15; };
struct BFu1c_B_BFu15ll { unsigned char v1:1; bool v2; unsigned long long v3:15; };
struct BFu1c_B_BFu15s { unsigned char v1:1; bool v2; unsigned short v3:15; };
struct BFu1c_B_BFu16i { unsigned char v1:1; bool v2; unsigned int v3:16; };
struct BFu1c_B_BFu16ll { unsigned char v1:1; bool v2; unsigned long long v3:16; };
struct BFu1c_B_BFu16s { unsigned char v1:1; bool v2; unsigned short v3:16; };
struct BFu1c_B_BFu17i { unsigned char v1:1; bool v2; unsigned int v3:17; };
struct BFu1c_B_BFu17ll { unsigned char v1:1; bool v2; unsigned long long v3:17; };
struct BFu1c_B_BFu1c { unsigned char v1:1; bool v2; unsigned char v3:1; };
struct BFu1c_B_BFu1i { unsigned char v1:1; bool v2; unsigned int v3:1; };
struct BFu1c_B_BFu1ll { unsigned char v1:1; bool v2; unsigned long long v3:1; };
struct BFu1c_B_BFu1s { unsigned char v1:1; bool v2; unsigned short v3:1; };
struct BFu1c_B_BFu31i { unsigned char v1:1; bool v2; unsigned int v3:31; };
struct BFu1c_B_BFu31ll { unsigned char v1:1; bool v2; unsigned long long v3:31; };
struct BFu1c_B_BFu32i { unsigned char v1:1; bool v2; unsigned int v3:32; };
struct BFu1c_B_BFu32ll { unsigned char v1:1; bool v2; unsigned long long v3:32; };
struct BFu1c_B_BFu33 { unsigned char v1:1; bool v2; unsigned long long v3:33; };
struct BFu1c_B_BFu7c { unsigned char v1:1; bool v2; unsigned char v3:7; };
struct BFu1c_B_BFu7i { unsigned char v1:1; bool v2; unsigned int v3:7; };
struct BFu1c_B_BFu7ll { unsigned char v1:1; bool v2; unsigned long long v3:7; };
struct BFu1c_B_BFu7s { unsigned char v1:1; bool v2; unsigned short v3:7; };
struct BFu1c_B_BFu8c { unsigned char v1:1; bool v2; unsigned char v3:8; };
struct BFu1c_B_BFu8i { unsigned char v1:1; bool v2; unsigned int v3:8; };
struct BFu1c_B_BFu8ll { unsigned char v1:1; bool v2; unsigned long long v3:8; };
struct BFu1c_B_BFu8s { unsigned char v1:1; bool v2; unsigned short v3:8; };
struct BFu1c_B_BFu9i { unsigned char v1:1; bool v2; unsigned int v3:9; };
struct BFu1c_B_BFu9ll { unsigned char v1:1; bool v2; unsigned long long v3:9; };
struct BFu1c_B_BFu9s { unsigned char v1:1; bool v2; unsigned short v3:9; };
struct BFu1c_B_C { unsigned char v1:1; bool v2; char v3; };
struct BFu1c_B_D { unsigned char v1:1; bool v2; double v3; };
struct BFu1c_B_F { unsigned char v1:1; bool v2; float v3; };
struct BFu1c_B_I { unsigned char v1:1; bool v2; int v3; };
struct BFu1c_B_Ip { unsigned char v1:1; bool v2; int * v3; };
struct BFu1c_B_L { unsigned char v1:1; bool v2; long long v3; };
struct BFu1c_B_S { unsigned char v1:1; bool v2; short v3; };
struct BFu1c_B_Uc { unsigned char v1:1; bool v2; unsigned char v3; };
struct BFu1c_B_Ui { unsigned char v1:1; bool v2; unsigned int v3; };
struct BFu1c_B_Ul { unsigned char v1:1; bool v2; unsigned long long v3; };
struct BFu1c_B_Us { unsigned char v1:1; bool v2; unsigned short v3; };
struct BFu1c_B_Vp { unsigned char v1:1; bool v2; void * v3; };
struct BFu1c_BFu15i_B { unsigned char v1:1; unsigned int v2:15; bool v3; };
struct BFu1c_BFu15ll_B { unsigned char v1:1; unsigned long long v2:15; bool v3; };
struct BFu1c_BFu15s_B { unsigned char v1:1; unsigned short v2:15; bool v3; };
struct BFu1c_BFu16i_B { unsigned char v1:1; unsigned int v2:16; bool v3; };
struct BFu1c_BFu16ll_B { unsigned char v1:1; unsigned long long v2:16; bool v3; };
struct BFu1c_BFu16s_B { unsigned char v1:1; unsigned short v2:16; bool v3; };
struct BFu1c_BFu17i_B { unsigned char v1:1; unsigned int v2:17; bool v3; };
struct BFu1c_BFu17ll_B { unsigned char v1:1; unsigned long long v2:17; bool v3; };
struct BFu1c_BFu1c_B { unsigned char v1:1; unsigned char v2:1; bool v3; };
struct BFu1c_BFu1i_B { unsigned char v1:1; unsigned int v2:1; bool v3; };
struct BFu1c_BFu1ll_B { unsigned char v1:1; unsigned long long v2:1; bool v3; };
struct BFu1c_BFu1s_B { unsigned char v1:1; unsigned short v2:1; bool v3; };
struct BFu1c_BFu31i_B { unsigned char v1:1; unsigned int v2:31; bool v3; };
struct BFu1c_BFu31ll_B { unsigned char v1:1; unsigned long long v2:31; bool v3; };
struct BFu1c_BFu32i_B { unsigned char v1:1; unsigned int v2:32; bool v3; };
struct BFu1c_BFu32ll_B { unsigned char v1:1; unsigned long long v2:32; bool v3; };
struct BFu1c_BFu33_B { unsigned char v1:1; unsigned long long v2:33; bool v3; };
struct BFu1c_BFu7c_B { unsigned char v1:1; unsigned char v2:7; bool v3; };
struct BFu1c_BFu7i_B { unsigned char v1:1; unsigned int v2:7; bool v3; };
struct BFu1c_BFu7ll_B { unsigned char v1:1; unsigned long long v2:7; bool v3; };
struct BFu1c_BFu7s_B { unsigned char v1:1; unsigned short v2:7; bool v3; };
struct BFu1c_BFu8c_B { unsigned char v1:1; unsigned char v2:8; bool v3; };
struct BFu1c_BFu8i_B { unsigned char v1:1; unsigned int v2:8; bool v3; };
struct BFu1c_BFu8ll_B { unsigned char v1:1; unsigned long long v2:8; bool v3; };
struct BFu1c_BFu8s_B { unsigned char v1:1; unsigned short v2:8; bool v3; };
struct BFu1c_BFu9i_B { unsigned char v1:1; unsigned int v2:9; bool v3; };
struct BFu1c_BFu9ll_B { unsigned char v1:1; unsigned long long v2:9; bool v3; };
struct BFu1c_BFu9s_B { unsigned char v1:1; unsigned short v2:9; bool v3; };
struct BFu1c_C_B { unsigned char v1:1; char v2; bool v3; };
struct BFu1c_D_B { unsigned char v1:1; double v2; bool v3; };
struct BFu1c_F_B { unsigned char v1:1; float v2; bool v3; };
struct BFu1c_I_B { unsigned char v1:1; int v2; bool v3; };
struct BFu1c_Ip_B { unsigned char v1:1; int * v2; bool v3; };
struct BFu1c_L_B { unsigned char v1:1; long long v2; bool v3; };
struct BFu1c_S_B { unsigned char v1:1; short v2; bool v3; };
struct BFu1c_Uc_B { unsigned char v1:1; unsigned char v2; bool v3; };
struct BFu1c_Ui_B { unsigned char v1:1; unsigned int v2; bool v3; };
struct BFu1c_Ul_B { unsigned char v1:1; unsigned long long v2; bool v3; };
struct BFu1c_Us_B { unsigned char v1:1; unsigned short v2; bool v3; };
struct BFu1c_Vp_B { unsigned char v1:1; void * v2; bool v3; };
struct BFu1i_B { unsigned int v1:1; bool v2; };
struct BFu1i_B_B { unsigned int v1:1; bool v2; bool v3; };
struct BFu1i_B_BFu15i { unsigned int v1:1; bool v2; unsigned int v3:15; };
struct BFu1i_B_BFu15ll { unsigned int v1:1; bool v2; unsigned long long v3:15; };
struct BFu1i_B_BFu15s { unsigned int v1:1; bool v2; unsigned short v3:15; };
struct BFu1i_B_BFu16i { unsigned int v1:1; bool v2; unsigned int v3:16; };
struct BFu1i_B_BFu16ll { unsigned int v1:1; bool v2; unsigned long long v3:16; };
struct BFu1i_B_BFu16s { unsigned int v1:1; bool v2; unsigned short v3:16; };
struct BFu1i_B_BFu17i { unsigned int v1:1; bool v2; unsigned int v3:17; };
struct BFu1i_B_BFu17ll { unsigned int v1:1; bool v2; unsigned long long v3:17; };
struct BFu1i_B_BFu1c { unsigned int v1:1; bool v2; unsigned char v3:1; };
struct BFu1i_B_BFu1i { unsigned int v1:1; bool v2; unsigned int v3:1; };
struct BFu1i_B_BFu1ll { unsigned int v1:1; bool v2; unsigned long long v3:1; };
struct BFu1i_B_BFu1s { unsigned int v1:1; bool v2; unsigned short v3:1; };
struct BFu1i_B_BFu31i { unsigned int v1:1; bool v2; unsigned int v3:31; };
struct BFu1i_B_BFu31ll { unsigned int v1:1; bool v2; unsigned long long v3:31; };
struct BFu1i_B_BFu32i { unsigned int v1:1; bool v2; unsigned int v3:32; };
struct BFu1i_B_BFu32ll { unsigned int v1:1; bool v2; unsigned long long v3:32; };
struct BFu1i_B_BFu33 { unsigned int v1:1; bool v2; unsigned long long v3:33; };
struct BFu1i_B_BFu7c { unsigned int v1:1; bool v2; unsigned char v3:7; };
struct BFu1i_B_BFu7i { unsigned int v1:1; bool v2; unsigned int v3:7; };
struct BFu1i_B_BFu7ll { unsigned int v1:1; bool v2; unsigned long long v3:7; };
struct BFu1i_B_BFu7s { unsigned int v1:1; bool v2; unsigned short v3:7; };
struct BFu1i_B_BFu8c { unsigned int v1:1; bool v2; unsigned char v3:8; };
struct BFu1i_B_BFu8i { unsigned int v1:1; bool v2; unsigned int v3:8; };
struct BFu1i_B_BFu8ll { unsigned int v1:1; bool v2; unsigned long long v3:8; };
struct BFu1i_B_BFu8s { unsigned int v1:1; bool v2; unsigned short v3:8; };
struct BFu1i_B_BFu9i { unsigned int v1:1; bool v2; unsigned int v3:9; };
struct BFu1i_B_BFu9ll { unsigned int v1:1; bool v2; unsigned long long v3:9; };
struct BFu1i_B_BFu9s { unsigned int v1:1; bool v2; unsigned short v3:9; };
struct BFu1i_B_C { unsigned int v1:1; bool v2; char v3; };
struct BFu1i_B_D { unsigned int v1:1; bool v2; double v3; };
struct BFu1i_B_F { unsigned int v1:1; bool v2; float v3; };
struct BFu1i_B_I { unsigned int v1:1; bool v2; int v3; };
struct BFu1i_B_Ip { unsigned int v1:1; bool v2; int * v3; };
struct BFu1i_B_L { unsigned int v1:1; bool v2; long long v3; };
struct BFu1i_B_S { unsigned int v1:1; bool v2; short v3; };
struct BFu1i_B_Uc { unsigned int v1:1; bool v2; unsigned char v3; };
struct BFu1i_B_Ui { unsigned int v1:1; bool v2; unsigned int v3; };
struct BFu1i_B_Ul { unsigned int v1:1; bool v2; unsigned long long v3; };
struct BFu1i_B_Us { unsigned int v1:1; bool v2; unsigned short v3; };
struct BFu1i_B_Vp { unsigned int v1:1; bool v2; void * v3; };
struct BFu1i_BFu15i_B { unsigned int v1:1; unsigned int v2:15; bool v3; };
struct BFu1i_BFu15ll_B { unsigned int v1:1; unsigned long long v2:15; bool v3; };
struct BFu1i_BFu15s_B { unsigned int v1:1; unsigned short v2:15; bool v3; };
struct BFu1i_BFu16i_B { unsigned int v1:1; unsigned int v2:16; bool v3; };
struct BFu1i_BFu16ll_B { unsigned int v1:1; unsigned long long v2:16; bool v3; };
struct BFu1i_BFu16s_B { unsigned int v1:1; unsigned short v2:16; bool v3; };
struct BFu1i_BFu17i_B { unsigned int v1:1; unsigned int v2:17; bool v3; };
struct BFu1i_BFu17ll_B { unsigned int v1:1; unsigned long long v2:17; bool v3; };
struct BFu1i_BFu1c_B { unsigned int v1:1; unsigned char v2:1; bool v3; };
struct BFu1i_BFu1i_B { unsigned int v1:1; unsigned int v2:1; bool v3; };
struct BFu1i_BFu1ll_B { unsigned int v1:1; unsigned long long v2:1; bool v3; };
struct BFu1i_BFu1s_B { unsigned int v1:1; unsigned short v2:1; bool v3; };
struct BFu1i_BFu31i_B { unsigned int v1:1; unsigned int v2:31; bool v3; };
struct BFu1i_BFu31ll_B { unsigned int v1:1; unsigned long long v2:31; bool v3; };
struct BFu1i_BFu32i_B { unsigned int v1:1; unsigned int v2:32; bool v3; };
struct BFu1i_BFu32ll_B { unsigned int v1:1; unsigned long long v2:32; bool v3; };
struct BFu1i_BFu33_B { unsigned int v1:1; unsigned long long v2:33; bool v3; };
struct BFu1i_BFu7c_B { unsigned int v1:1; unsigned char v2:7; bool v3; };
struct BFu1i_BFu7i_B { unsigned int v1:1; unsigned int v2:7; bool v3; };
struct BFu1i_BFu7ll_B { unsigned int v1:1; unsigned long long v2:7; bool v3; };
struct BFu1i_BFu7s_B { unsigned int v1:1; unsigned short v2:7; bool v3; };
struct BFu1i_BFu8c_B { unsigned int v1:1; unsigned char v2:8; bool v3; };
struct BFu1i_BFu8i_B { unsigned int v1:1; unsigned int v2:8; bool v3; };
struct BFu1i_BFu8ll_B { unsigned int v1:1; unsigned long long v2:8; bool v3; };
struct BFu1i_BFu8s_B { unsigned int v1:1; unsigned short v2:8; bool v3; };
struct BFu1i_BFu9i_B { unsigned int v1:1; unsigned int v2:9; bool v3; };
struct BFu1i_BFu9ll_B { unsigned int v1:1; unsigned long long v2:9; bool v3; };
struct BFu1i_BFu9s_B { unsigned int v1:1; unsigned short v2:9; bool v3; };
struct BFu1i_C_B { unsigned int v1:1; char v2; bool v3; };
struct BFu1i_D_B { unsigned int v1:1; double v2; bool v3; };
struct BFu1i_F_B { unsigned int v1:1; float v2; bool v3; };
struct BFu1i_I_B { unsigned int v1:1; int v2; bool v3; };
struct BFu1i_Ip_B { unsigned int v1:1; int * v2; bool v3; };
struct BFu1i_L_B { unsigned int v1:1; long long v2; bool v3; };
struct BFu1i_S_B { unsigned int v1:1; short v2; bool v3; };
struct BFu1i_Uc_B { unsigned int v1:1; unsigned char v2; bool v3; };
struct BFu1i_Ui_B { unsigned int v1:1; unsigned int v2; bool v3; };
struct BFu1i_Ul_B { unsigned int v1:1; unsigned long long v2; bool v3; };
struct BFu1i_Us_B { unsigned int v1:1; unsigned short v2; bool v3; };
struct BFu1i_Vp_B { unsigned int v1:1; void * v2; bool v3; };
struct BFu1ll_B { unsigned long long v1:1; bool v2; };
struct BFu1ll_B_B { unsigned long long v1:1; bool v2; bool v3; };
struct BFu1ll_B_BFu15i { unsigned long long v1:1; bool v2; unsigned int v3:15; };
struct BFu1ll_B_BFu15ll { unsigned long long v1:1; bool v2; unsigned long long v3:15; };
struct BFu1ll_B_BFu15s { unsigned long long v1:1; bool v2; unsigned short v3:15; };
struct BFu1ll_B_BFu16i { unsigned long long v1:1; bool v2; unsigned int v3:16; };
struct BFu1ll_B_BFu16ll { unsigned long long v1:1; bool v2; unsigned long long v3:16; };
struct BFu1ll_B_BFu16s { unsigned long long v1:1; bool v2; unsigned short v3:16; };
struct BFu1ll_B_BFu17i { unsigned long long v1:1; bool v2; unsigned int v3:17; };
struct BFu1ll_B_BFu17ll { unsigned long long v1:1; bool v2; unsigned long long v3:17; };
struct BFu1ll_B_BFu1c { unsigned long long v1:1; bool v2; unsigned char v3:1; };
struct BFu1ll_B_BFu1i { unsigned long long v1:1; bool v2; unsigned int v3:1; };
struct BFu1ll_B_BFu1ll { unsigned long long v1:1; bool v2; unsigned long long v3:1; };
struct BFu1ll_B_BFu1s { unsigned long long v1:1; bool v2; unsigned short v3:1; };
struct BFu1ll_B_BFu31i { unsigned long long v1:1; bool v2; unsigned int v3:31; };
struct BFu1ll_B_BFu31ll { unsigned long long v1:1; bool v2; unsigned long long v3:31; };
struct BFu1ll_B_BFu32i { unsigned long long v1:1; bool v2; unsigned int v3:32; };
struct BFu1ll_B_BFu32ll { unsigned long long v1:1; bool v2; unsigned long long v3:32; };
struct BFu1ll_B_BFu33 { unsigned long long v1:1; bool v2; unsigned long long v3:33; };
struct BFu1ll_B_BFu7c { unsigned long long v1:1; bool v2; unsigned char v3:7; };
struct BFu1ll_B_BFu7i { unsigned long long v1:1; bool v2; unsigned int v3:7; };
struct BFu1ll_B_BFu7ll { unsigned long long v1:1; bool v2; unsigned long long v3:7; };
struct BFu1ll_B_BFu7s { unsigned long long v1:1; bool v2; unsigned short v3:7; };
struct BFu1ll_B_BFu8c { unsigned long long v1:1; bool v2; unsigned char v3:8; };
struct BFu1ll_B_BFu8i { unsigned long long v1:1; bool v2; unsigned int v3:8; };
struct BFu1ll_B_BFu8ll { unsigned long long v1:1; bool v2; unsigned long long v3:8; };
struct BFu1ll_B_BFu8s { unsigned long long v1:1; bool v2; unsigned short v3:8; };
struct BFu1ll_B_BFu9i { unsigned long long v1:1; bool v2; unsigned int v3:9; };
struct BFu1ll_B_BFu9ll { unsigned long long v1:1; bool v2; unsigned long long v3:9; };
struct BFu1ll_B_BFu9s { unsigned long long v1:1; bool v2; unsigned short v3:9; };
struct BFu1ll_B_C { unsigned long long v1:1; bool v2; char v3; };
struct BFu1ll_B_D { unsigned long long v1:1; bool v2; double v3; };
struct BFu1ll_B_F { unsigned long long v1:1; bool v2; float v3; };
struct BFu1ll_B_I { unsigned long long v1:1; bool v2; int v3; };
struct BFu1ll_B_Ip { unsigned long long v1:1; bool v2; int * v3; };
struct BFu1ll_B_L { unsigned long long v1:1; bool v2; long long v3; };
struct BFu1ll_B_S { unsigned long long v1:1; bool v2; short v3; };
struct BFu1ll_B_Uc { unsigned long long v1:1; bool v2; unsigned char v3; };
struct BFu1ll_B_Ui { unsigned long long v1:1; bool v2; unsigned int v3; };
struct BFu1ll_B_Ul { unsigned long long v1:1; bool v2; unsigned long long v3; };
struct BFu1ll_B_Us { unsigned long long v1:1; bool v2; unsigned short v3; };
struct BFu1ll_B_Vp { unsigned long long v1:1; bool v2; void * v3; };
struct BFu1ll_BFu15i_B { unsigned long long v1:1; unsigned int v2:15; bool v3; };
struct BFu1ll_BFu15ll_B { unsigned long long v1:1; unsigned long long v2:15; bool v3; };
struct BFu1ll_BFu15s_B { unsigned long long v1:1; unsigned short v2:15; bool v3; };
struct BFu1ll_BFu16i_B { unsigned long long v1:1; unsigned int v2:16; bool v3; };
struct BFu1ll_BFu16ll_B { unsigned long long v1:1; unsigned long long v2:16; bool v3; };
struct BFu1ll_BFu16s_B { unsigned long long v1:1; unsigned short v2:16; bool v3; };
struct BFu1ll_BFu17i_B { unsigned long long v1:1; unsigned int v2:17; bool v3; };
struct BFu1ll_BFu17ll_B { unsigned long long v1:1; unsigned long long v2:17; bool v3; };
struct BFu1ll_BFu1c_B { unsigned long long v1:1; unsigned char v2:1; bool v3; };
struct BFu1ll_BFu1i_B { unsigned long long v1:1; unsigned int v2:1; bool v3; };
struct BFu1ll_BFu1ll_B { unsigned long long v1:1; unsigned long long v2:1; bool v3; };
struct BFu1ll_BFu1s_B { unsigned long long v1:1; unsigned short v2:1; bool v3; };
struct BFu1ll_BFu31i_B { unsigned long long v1:1; unsigned int v2:31; bool v3; };
struct BFu1ll_BFu31ll_B { unsigned long long v1:1; unsigned long long v2:31; bool v3; };
struct BFu1ll_BFu32i_B { unsigned long long v1:1; unsigned int v2:32; bool v3; };
struct BFu1ll_BFu32ll_B { unsigned long long v1:1; unsigned long long v2:32; bool v3; };
struct BFu1ll_BFu33_B { unsigned long long v1:1; unsigned long long v2:33; bool v3; };
struct BFu1ll_BFu7c_B { unsigned long long v1:1; unsigned char v2:7; bool v3; };
struct BFu1ll_BFu7i_B { unsigned long long v1:1; unsigned int v2:7; bool v3; };
struct BFu1ll_BFu7ll_B { unsigned long long v1:1; unsigned long long v2:7; bool v3; };
struct BFu1ll_BFu7s_B { unsigned long long v1:1; unsigned short v2:7; bool v3; };
struct BFu1ll_BFu8c_B { unsigned long long v1:1; unsigned char v2:8; bool v3; };
struct BFu1ll_BFu8i_B { unsigned long long v1:1; unsigned int v2:8; bool v3; };
struct BFu1ll_BFu8ll_B { unsigned long long v1:1; unsigned long long v2:8; bool v3; };
struct BFu1ll_BFu8s_B { unsigned long long v1:1; unsigned short v2:8; bool v3; };
struct BFu1ll_BFu9i_B { unsigned long long v1:1; unsigned int v2:9; bool v3; };
struct BFu1ll_BFu9ll_B { unsigned long long v1:1; unsigned long long v2:9; bool v3; };
struct BFu1ll_BFu9s_B { unsigned long long v1:1; unsigned short v2:9; bool v3; };
struct BFu1ll_C_B { unsigned long long v1:1; char v2; bool v3; };
struct BFu1ll_D_B { unsigned long long v1:1; double v2; bool v3; };
struct BFu1ll_F_B { unsigned long long v1:1; float v2; bool v3; };
struct BFu1ll_I_B { unsigned long long v1:1; int v2; bool v3; };
struct BFu1ll_Ip_B { unsigned long long v1:1; int * v2; bool v3; };
struct BFu1ll_L_B { unsigned long long v1:1; long long v2; bool v3; };
struct BFu1ll_S_B { unsigned long long v1:1; short v2; bool v3; };
struct BFu1ll_Uc_B { unsigned long long v1:1; unsigned char v2; bool v3; };
struct BFu1ll_Ui_B { unsigned long long v1:1; unsigned int v2; bool v3; };
struct BFu1ll_Ul_B { unsigned long long v1:1; unsigned long long v2; bool v3; };
struct BFu1ll_Us_B { unsigned long long v1:1; unsigned short v2; bool v3; };
struct BFu1ll_Vp_B { unsigned long long v1:1; void * v2; bool v3; };
struct BFu1s_B { unsigned short v1:1; bool v2; };
struct BFu1s_B_B { unsigned short v1:1; bool v2; bool v3; };
struct BFu1s_B_BFu15i { unsigned short v1:1; bool v2; unsigned int v3:15; };
struct BFu1s_B_BFu15ll { unsigned short v1:1; bool v2; unsigned long long v3:15; };
struct BFu1s_B_BFu15s { unsigned short v1:1; bool v2; unsigned short v3:15; };
struct BFu1s_B_BFu16i { unsigned short v1:1; bool v2; unsigned int v3:16; };
struct BFu1s_B_BFu16ll { unsigned short v1:1; bool v2; unsigned long long v3:16; };
struct BFu1s_B_BFu16s { unsigned short v1:1; bool v2; unsigned short v3:16; };
struct BFu1s_B_BFu17i { unsigned short v1:1; bool v2; unsigned int v3:17; };
struct BFu1s_B_BFu17ll { unsigned short v1:1; bool v2; unsigned long long v3:17; };
struct BFu1s_B_BFu1c { unsigned short v1:1; bool v2; unsigned char v3:1; };
struct BFu1s_B_BFu1i { unsigned short v1:1; bool v2; unsigned int v3:1; };
struct BFu1s_B_BFu1ll { unsigned short v1:1; bool v2; unsigned long long v3:1; };
struct BFu1s_B_BFu1s { unsigned short v1:1; bool v2; unsigned short v3:1; };
struct BFu1s_B_BFu31i { unsigned short v1:1; bool v2; unsigned int v3:31; };
struct BFu1s_B_BFu31ll { unsigned short v1:1; bool v2; unsigned long long v3:31; };
struct BFu1s_B_BFu32i { unsigned short v1:1; bool v2; unsigned int v3:32; };
struct BFu1s_B_BFu32ll { unsigned short v1:1; bool v2; unsigned long long v3:32; };
struct BFu1s_B_BFu33 { unsigned short v1:1; bool v2; unsigned long long v3:33; };
struct BFu1s_B_BFu7c { unsigned short v1:1; bool v2; unsigned char v3:7; };
struct BFu1s_B_BFu7i { unsigned short v1:1; bool v2; unsigned int v3:7; };
struct BFu1s_B_BFu7ll { unsigned short v1:1; bool v2; unsigned long long v3:7; };
struct BFu1s_B_BFu7s { unsigned short v1:1; bool v2; unsigned short v3:7; };
struct BFu1s_B_BFu8c { unsigned short v1:1; bool v2; unsigned char v3:8; };
struct BFu1s_B_BFu8i { unsigned short v1:1; bool v2; unsigned int v3:8; };
struct BFu1s_B_BFu8ll { unsigned short v1:1; bool v2; unsigned long long v3:8; };
struct BFu1s_B_BFu8s { unsigned short v1:1; bool v2; unsigned short v3:8; };
struct BFu1s_B_BFu9i { unsigned short v1:1; bool v2; unsigned int v3:9; };
struct BFu1s_B_BFu9ll { unsigned short v1:1; bool v2; unsigned long long v3:9; };
struct BFu1s_B_BFu9s { unsigned short v1:1; bool v2; unsigned short v3:9; };
struct BFu1s_B_C { unsigned short v1:1; bool v2; char v3; };
struct BFu1s_B_D { unsigned short v1:1; bool v2; double v3; };
struct BFu1s_B_F { unsigned short v1:1; bool v2; float v3; };
struct BFu1s_B_I { unsigned short v1:1; bool v2; int v3; };
struct BFu1s_B_Ip { unsigned short v1:1; bool v2; int * v3; };
struct BFu1s_B_L { unsigned short v1:1; bool v2; long long v3; };
struct BFu1s_B_S { unsigned short v1:1; bool v2; short v3; };
struct BFu1s_B_Uc { unsigned short v1:1; bool v2; unsigned char v3; };
struct BFu1s_B_Ui { unsigned short v1:1; bool v2; unsigned int v3; };
struct BFu1s_B_Ul { unsigned short v1:1; bool v2; unsigned long long v3; };
struct BFu1s_B_Us { unsigned short v1:1; bool v2; unsigned short v3; };
struct BFu1s_B_Vp { unsigned short v1:1; bool v2; void * v3; };
struct BFu1s_BFu15i_B { unsigned short v1:1; unsigned int v2:15; bool v3; };
struct BFu1s_BFu15ll_B { unsigned short v1:1; unsigned long long v2:15; bool v3; };
struct BFu1s_BFu15s_B { unsigned short v1:1; unsigned short v2:15; bool v3; };
struct BFu1s_BFu16i_B { unsigned short v1:1; unsigned int v2:16; bool v3; };
struct BFu1s_BFu16ll_B { unsigned short v1:1; unsigned long long v2:16; bool v3; };
struct BFu1s_BFu16s_B { unsigned short v1:1; unsigned short v2:16; bool v3; };
struct BFu1s_BFu17i_B { unsigned short v1:1; unsigned int v2:17; bool v3; };
struct BFu1s_BFu17ll_B { unsigned short v1:1; unsigned long long v2:17; bool v3; };
struct BFu1s_BFu1c_B { unsigned short v1:1; unsigned char v2:1; bool v3; };
struct BFu1s_BFu1i_B { unsigned short v1:1; unsigned int v2:1; bool v3; };
struct BFu1s_BFu1ll_B { unsigned short v1:1; unsigned long long v2:1; bool v3; };
struct BFu1s_BFu1s_B { unsigned short v1:1; unsigned short v2:1; bool v3; };
struct BFu1s_BFu31i_B { unsigned short v1:1; unsigned int v2:31; bool v3; };
struct BFu1s_BFu31ll_B { unsigned short v1:1; unsigned long long v2:31; bool v3; };
struct BFu1s_BFu32i_B { unsigned short v1:1; unsigned int v2:32; bool v3; };
struct BFu1s_BFu32ll_B { unsigned short v1:1; unsigned long long v2:32; bool v3; };
struct BFu1s_BFu33_B { unsigned short v1:1; unsigned long long v2:33; bool v3; };
struct BFu1s_BFu7c_B { unsigned short v1:1; unsigned char v2:7; bool v3; };
struct BFu1s_BFu7i_B { unsigned short v1:1; unsigned int v2:7; bool v3; };
struct BFu1s_BFu7ll_B { unsigned short v1:1; unsigned long long v2:7; bool v3; };
struct BFu1s_BFu7s_B { unsigned short v1:1; unsigned short v2:7; bool v3; };
struct BFu1s_BFu8c_B { unsigned short v1:1; unsigned char v2:8; bool v3; };
struct BFu1s_BFu8i_B { unsigned short v1:1; unsigned int v2:8; bool v3; };
struct BFu1s_BFu8ll_B { unsigned short v1:1; unsigned long long v2:8; bool v3; };
struct BFu1s_BFu8s_B { unsigned short v1:1; unsigned short v2:8; bool v3; };
struct BFu1s_BFu9i_B { unsigned short v1:1; unsigned int v2:9; bool v3; };
struct BFu1s_BFu9ll_B { unsigned short v1:1; unsigned long long v2:9; bool v3; };
struct BFu1s_BFu9s_B { unsigned short v1:1; unsigned short v2:9; bool v3; };
struct BFu1s_C_B { unsigned short v1:1; char v2; bool v3; };
struct BFu1s_D_B { unsigned short v1:1; double v2; bool v3; };
struct BFu1s_F_B { unsigned short v1:1; float v2; bool v3; };
struct BFu1s_I_B { unsigned short v1:1; int v2; bool v3; };
struct BFu1s_Ip_B { unsigned short v1:1; int * v2; bool v3; };
struct BFu1s_L_B { unsigned short v1:1; long long v2; bool v3; };
struct BFu1s_S_B { unsigned short v1:1; short v2; bool v3; };
struct BFu1s_Uc_B { unsigned short v1:1; unsigned char v2; bool v3; };
struct BFu1s_Ui_B { unsigned short v1:1; unsigned int v2; bool v3; };
struct BFu1s_Ul_B { unsigned short v1:1; unsigned long long v2; bool v3; };
struct BFu1s_Us_B { unsigned short v1:1; unsigned short v2; bool v3; };
struct BFu1s_Vp_B { unsigned short v1:1; void * v2; bool v3; };
struct BFu31i_B { unsigned int v1:31; bool v2; };
struct BFu31i_B_B { unsigned int v1:31; bool v2; bool v3; };
struct BFu31i_B_BFu15i { unsigned int v1:31; bool v2; unsigned int v3:15; };
struct BFu31i_B_BFu15ll { unsigned int v1:31; bool v2; unsigned long long v3:15; };
struct BFu31i_B_BFu15s { unsigned int v1:31; bool v2; unsigned short v3:15; };
struct BFu31i_B_BFu16i { unsigned int v1:31; bool v2; unsigned int v3:16; };
struct BFu31i_B_BFu16ll { unsigned int v1:31; bool v2; unsigned long long v3:16; };
struct BFu31i_B_BFu16s { unsigned int v1:31; bool v2; unsigned short v3:16; };
struct BFu31i_B_BFu17i { unsigned int v1:31; bool v2; unsigned int v3:17; };
struct BFu31i_B_BFu17ll { unsigned int v1:31; bool v2; unsigned long long v3:17; };
struct BFu31i_B_BFu1c { unsigned int v1:31; bool v2; unsigned char v3:1; };
struct BFu31i_B_BFu1i { unsigned int v1:31; bool v2; unsigned int v3:1; };
struct BFu31i_B_BFu1ll { unsigned int v1:31; bool v2; unsigned long long v3:1; };
struct BFu31i_B_BFu1s { unsigned int v1:31; bool v2; unsigned short v3:1; };
struct BFu31i_B_BFu31i { unsigned int v1:31; bool v2; unsigned int v3:31; };
struct BFu31i_B_BFu31ll { unsigned int v1:31; bool v2; unsigned long long v3:31; };
struct BFu31i_B_BFu32i { unsigned int v1:31; bool v2; unsigned int v3:32; };
struct BFu31i_B_BFu32ll { unsigned int v1:31; bool v2; unsigned long long v3:32; };
struct BFu31i_B_BFu33 { unsigned int v1:31; bool v2; unsigned long long v3:33; };
struct BFu31i_B_BFu7c { unsigned int v1:31; bool v2; unsigned char v3:7; };
struct BFu31i_B_BFu7i { unsigned int v1:31; bool v2; unsigned int v3:7; };
struct BFu31i_B_BFu7ll { unsigned int v1:31; bool v2; unsigned long long v3:7; };
struct BFu31i_B_BFu7s { unsigned int v1:31; bool v2; unsigned short v3:7; };
struct BFu31i_B_BFu8c { unsigned int v1:31; bool v2; unsigned char v3:8; };
struct BFu31i_B_BFu8i { unsigned int v1:31; bool v2; unsigned int v3:8; };
struct BFu31i_B_BFu8ll { unsigned int v1:31; bool v2; unsigned long long v3:8; };
struct BFu31i_B_BFu8s { unsigned int v1:31; bool v2; unsigned short v3:8; };
struct BFu31i_B_BFu9i { unsigned int v1:31; bool v2; unsigned int v3:9; };
struct BFu31i_B_BFu9ll { unsigned int v1:31; bool v2; unsigned long long v3:9; };
struct BFu31i_B_BFu9s { unsigned int v1:31; bool v2; unsigned short v3:9; };
struct BFu31i_B_C { unsigned int v1:31; bool v2; char v3; };
struct BFu31i_B_D { unsigned int v1:31; bool v2; double v3; };
struct BFu31i_B_F { unsigned int v1:31; bool v2; float v3; };
struct BFu31i_B_I { unsigned int v1:31; bool v2; int v3; };
struct BFu31i_B_Ip { unsigned int v1:31; bool v2; int * v3; };
struct BFu31i_B_L { unsigned int v1:31; bool v2; long long v3; };
struct BFu31i_B_S { unsigned int v1:31; bool v2; short v3; };
struct BFu31i_B_Uc { unsigned int v1:31; bool v2; unsigned char v3; };
struct BFu31i_B_Ui { unsigned int v1:31; bool v2; unsigned int v3; };
struct BFu31i_B_Ul { unsigned int v1:31; bool v2; unsigned long long v3; };
struct BFu31i_B_Us { unsigned int v1:31; bool v2; unsigned short v3; };
struct BFu31i_B_Vp { unsigned int v1:31; bool v2; void * v3; };
struct BFu31i_BFu15i_B { unsigned int v1:31; unsigned int v2:15; bool v3; };
struct BFu31i_BFu15ll_B { unsigned int v1:31; unsigned long long v2:15; bool v3; };
struct BFu31i_BFu15s_B { unsigned int v1:31; unsigned short v2:15; bool v3; };
struct BFu31i_BFu16i_B { unsigned int v1:31; unsigned int v2:16; bool v3; };
struct BFu31i_BFu16ll_B { unsigned int v1:31; unsigned long long v2:16; bool v3; };
struct BFu31i_BFu16s_B { unsigned int v1:31; unsigned short v2:16; bool v3; };
struct BFu31i_BFu17i_B { unsigned int v1:31; unsigned int v2:17; bool v3; };
struct BFu31i_BFu17ll_B { unsigned int v1:31; unsigned long long v2:17; bool v3; };
struct BFu31i_BFu1c_B { unsigned int v1:31; unsigned char v2:1; bool v3; };
struct BFu31i_BFu1i_B { unsigned int v1:31; unsigned int v2:1; bool v3; };
struct BFu31i_BFu1ll_B { unsigned int v1:31; unsigned long long v2:1; bool v3; };
struct BFu31i_BFu1s_B { unsigned int v1:31; unsigned short v2:1; bool v3; };
struct BFu31i_BFu31i_B { unsigned int v1:31; unsigned int v2:31; bool v3; };
struct BFu31i_BFu31ll_B { unsigned int v1:31; unsigned long long v2:31; bool v3; };
struct BFu31i_BFu32i_B { unsigned int v1:31; unsigned int v2:32; bool v3; };
struct BFu31i_BFu32ll_B { unsigned int v1:31; unsigned long long v2:32; bool v3; };
struct BFu31i_BFu33_B { unsigned int v1:31; unsigned long long v2:33; bool v3; };
struct BFu31i_BFu7c_B { unsigned int v1:31; unsigned char v2:7; bool v3; };
struct BFu31i_BFu7i_B { unsigned int v1:31; unsigned int v2:7; bool v3; };
struct BFu31i_BFu7ll_B { unsigned int v1:31; unsigned long long v2:7; bool v3; };
struct BFu31i_BFu7s_B { unsigned int v1:31; unsigned short v2:7; bool v3; };
struct BFu31i_BFu8c_B { unsigned int v1:31; unsigned char v2:8; bool v3; };
struct BFu31i_BFu8i_B { unsigned int v1:31; unsigned int v2:8; bool v3; };
struct BFu31i_BFu8ll_B { unsigned int v1:31; unsigned long long v2:8; bool v3; };
struct BFu31i_BFu8s_B { unsigned int v1:31; unsigned short v2:8; bool v3; };
struct BFu31i_BFu9i_B { unsigned int v1:31; unsigned int v2:9; bool v3; };
struct BFu31i_BFu9ll_B { unsigned int v1:31; unsigned long long v2:9; bool v3; };
struct BFu31i_BFu9s_B { unsigned int v1:31; unsigned short v2:9; bool v3; };
struct BFu31i_C_B { unsigned int v1:31; char v2; bool v3; };
struct BFu31i_D_B { unsigned int v1:31; double v2; bool v3; };
struct BFu31i_F_B { unsigned int v1:31; float v2; bool v3; };
struct BFu31i_I_B { unsigned int v1:31; int v2; bool v3; };
struct BFu31i_Ip_B { unsigned int v1:31; int * v2; bool v3; };
struct BFu31i_L_B { unsigned int v1:31; long long v2; bool v3; };
struct BFu31i_S_B { unsigned int v1:31; short v2; bool v3; };
struct BFu31i_Uc_B { unsigned int v1:31; unsigned char v2; bool v3; };
struct BFu31i_Ui_B { unsigned int v1:31; unsigned int v2; bool v3; };
struct BFu31i_Ul_B { unsigned int v1:31; unsigned long long v2; bool v3; };
struct BFu31i_Us_B { unsigned int v1:31; unsigned short v2; bool v3; };
struct BFu31i_Vp_B { unsigned int v1:31; void * v2; bool v3; };
struct BFu31ll_B { unsigned long long v1:31; bool v2; };
struct BFu31ll_B_B { unsigned long long v1:31; bool v2; bool v3; };
struct BFu31ll_B_BFu15i { unsigned long long v1:31; bool v2; unsigned int v3:15; };
struct BFu31ll_B_BFu15ll { unsigned long long v1:31; bool v2; unsigned long long v3:15; };
struct BFu31ll_B_BFu15s { unsigned long long v1:31; bool v2; unsigned short v3:15; };
struct BFu31ll_B_BFu16i { unsigned long long v1:31; bool v2; unsigned int v3:16; };
struct BFu31ll_B_BFu16ll { unsigned long long v1:31; bool v2; unsigned long long v3:16; };
struct BFu31ll_B_BFu16s { unsigned long long v1:31; bool v2; unsigned short v3:16; };
struct BFu31ll_B_BFu17i { unsigned long long v1:31; bool v2; unsigned int v3:17; };
struct BFu31ll_B_BFu17ll { unsigned long long v1:31; bool v2; unsigned long long v3:17; };
struct BFu31ll_B_BFu1c { unsigned long long v1:31; bool v2; unsigned char v3:1; };
struct BFu31ll_B_BFu1i { unsigned long long v1:31; bool v2; unsigned int v3:1; };
struct BFu31ll_B_BFu1ll { unsigned long long v1:31; bool v2; unsigned long long v3:1; };
struct BFu31ll_B_BFu1s { unsigned long long v1:31; bool v2; unsigned short v3:1; };
struct BFu31ll_B_BFu31i { unsigned long long v1:31; bool v2; unsigned int v3:31; };
struct BFu31ll_B_BFu31ll { unsigned long long v1:31; bool v2; unsigned long long v3:31; };
struct BFu31ll_B_BFu32i { unsigned long long v1:31; bool v2; unsigned int v3:32; };
struct BFu31ll_B_BFu32ll { unsigned long long v1:31; bool v2; unsigned long long v3:32; };
struct BFu31ll_B_BFu33 { unsigned long long v1:31; bool v2; unsigned long long v3:33; };
struct BFu31ll_B_BFu7c { unsigned long long v1:31; bool v2; unsigned char v3:7; };
struct BFu31ll_B_BFu7i { unsigned long long v1:31; bool v2; unsigned int v3:7; };
struct BFu31ll_B_BFu7ll { unsigned long long v1:31; bool v2; unsigned long long v3:7; };
struct BFu31ll_B_BFu7s { unsigned long long v1:31; bool v2; unsigned short v3:7; };
struct BFu31ll_B_BFu8c { unsigned long long v1:31; bool v2; unsigned char v3:8; };
struct BFu31ll_B_BFu8i { unsigned long long v1:31; bool v2; unsigned int v3:8; };
struct BFu31ll_B_BFu8ll { unsigned long long v1:31; bool v2; unsigned long long v3:8; };
struct BFu31ll_B_BFu8s { unsigned long long v1:31; bool v2; unsigned short v3:8; };
struct BFu31ll_B_BFu9i { unsigned long long v1:31; bool v2; unsigned int v3:9; };
struct BFu31ll_B_BFu9ll { unsigned long long v1:31; bool v2; unsigned long long v3:9; };
struct BFu31ll_B_BFu9s { unsigned long long v1:31; bool v2; unsigned short v3:9; };
struct BFu31ll_B_C { unsigned long long v1:31; bool v2; char v3; };
struct BFu31ll_B_D { unsigned long long v1:31; bool v2; double v3; };
struct BFu31ll_B_F { unsigned long long v1:31; bool v2; float v3; };
struct BFu31ll_B_I { unsigned long long v1:31; bool v2; int v3; };
struct BFu31ll_B_Ip { unsigned long long v1:31; bool v2; int * v3; };
struct BFu31ll_B_L { unsigned long long v1:31; bool v2; long long v3; };
struct BFu31ll_B_S { unsigned long long v1:31; bool v2; short v3; };
struct BFu31ll_B_Uc { unsigned long long v1:31; bool v2; unsigned char v3; };
struct BFu31ll_B_Ui { unsigned long long v1:31; bool v2; unsigned int v3; };
struct BFu31ll_B_Ul { unsigned long long v1:31; bool v2; unsigned long long v3; };
struct BFu31ll_B_Us { unsigned long long v1:31; bool v2; unsigned short v3; };
struct BFu31ll_B_Vp { unsigned long long v1:31; bool v2; void * v3; };
struct BFu31ll_BFu15i_B { unsigned long long v1:31; unsigned int v2:15; bool v3; };
struct BFu31ll_BFu15ll_B { unsigned long long v1:31; unsigned long long v2:15; bool v3; };
struct BFu31ll_BFu15s_B { unsigned long long v1:31; unsigned short v2:15; bool v3; };
struct BFu31ll_BFu16i_B { unsigned long long v1:31; unsigned int v2:16; bool v3; };
struct BFu31ll_BFu16ll_B { unsigned long long v1:31; unsigned long long v2:16; bool v3; };
struct BFu31ll_BFu16s_B { unsigned long long v1:31; unsigned short v2:16; bool v3; };
struct BFu31ll_BFu17i_B { unsigned long long v1:31; unsigned int v2:17; bool v3; };
struct BFu31ll_BFu17ll_B { unsigned long long v1:31; unsigned long long v2:17; bool v3; };
struct BFu31ll_BFu1c_B { unsigned long long v1:31; unsigned char v2:1; bool v3; };
struct BFu31ll_BFu1i_B { unsigned long long v1:31; unsigned int v2:1; bool v3; };
struct BFu31ll_BFu1ll_B { unsigned long long v1:31; unsigned long long v2:1; bool v3; };
struct BFu31ll_BFu1s_B { unsigned long long v1:31; unsigned short v2:1; bool v3; };
struct BFu31ll_BFu31i_B { unsigned long long v1:31; unsigned int v2:31; bool v3; };
struct BFu31ll_BFu31ll_B { unsigned long long v1:31; unsigned long long v2:31; bool v3; };
struct BFu31ll_BFu32i_B { unsigned long long v1:31; unsigned int v2:32; bool v3; };
struct BFu31ll_BFu32ll_B { unsigned long long v1:31; unsigned long long v2:32; bool v3; };
struct BFu31ll_BFu33_B { unsigned long long v1:31; unsigned long long v2:33; bool v3; };
struct BFu31ll_BFu7c_B { unsigned long long v1:31; unsigned char v2:7; bool v3; };
struct BFu31ll_BFu7i_B { unsigned long long v1:31; unsigned int v2:7; bool v3; };
struct BFu31ll_BFu7ll_B { unsigned long long v1:31; unsigned long long v2:7; bool v3; };
struct BFu31ll_BFu7s_B { unsigned long long v1:31; unsigned short v2:7; bool v3; };
struct BFu31ll_BFu8c_B { unsigned long long v1:31; unsigned char v2:8; bool v3; };
struct BFu31ll_BFu8i_B { unsigned long long v1:31; unsigned int v2:8; bool v3; };
struct BFu31ll_BFu8ll_B { unsigned long long v1:31; unsigned long long v2:8; bool v3; };
struct BFu31ll_BFu8s_B { unsigned long long v1:31; unsigned short v2:8; bool v3; };
struct BFu31ll_BFu9i_B { unsigned long long v1:31; unsigned int v2:9; bool v3; };
struct BFu31ll_BFu9ll_B { unsigned long long v1:31; unsigned long long v2:9; bool v3; };
struct BFu31ll_BFu9s_B { unsigned long long v1:31; unsigned short v2:9; bool v3; };
struct BFu31ll_C_B { unsigned long long v1:31; char v2; bool v3; };
struct BFu31ll_D_B { unsigned long long v1:31; double v2; bool v3; };
struct BFu31ll_F_B { unsigned long long v1:31; float v2; bool v3; };
struct BFu31ll_I_B { unsigned long long v1:31; int v2; bool v3; };
struct BFu31ll_Ip_B { unsigned long long v1:31; int * v2; bool v3; };
struct BFu31ll_L_B { unsigned long long v1:31; long long v2; bool v3; };
struct BFu31ll_S_B { unsigned long long v1:31; short v2; bool v3; };
struct BFu31ll_Uc_B { unsigned long long v1:31; unsigned char v2; bool v3; };
struct BFu31ll_Ui_B { unsigned long long v1:31; unsigned int v2; bool v3; };
struct BFu31ll_Ul_B { unsigned long long v1:31; unsigned long long v2; bool v3; };
struct BFu31ll_Us_B { unsigned long long v1:31; unsigned short v2; bool v3; };
struct BFu31ll_Vp_B { unsigned long long v1:31; void * v2; bool v3; };
struct BFu32i_B { unsigned int v1:32; bool v2; };
struct BFu32i_B_B { unsigned int v1:32; bool v2; bool v3; };
struct BFu32i_B_BFu15i { unsigned int v1:32; bool v2; unsigned int v3:15; };
struct BFu32i_B_BFu15ll { unsigned int v1:32; bool v2; unsigned long long v3:15; };
struct BFu32i_B_BFu15s { unsigned int v1:32; bool v2; unsigned short v3:15; };
struct BFu32i_B_BFu16i { unsigned int v1:32; bool v2; unsigned int v3:16; };
struct BFu32i_B_BFu16ll { unsigned int v1:32; bool v2; unsigned long long v3:16; };
struct BFu32i_B_BFu16s { unsigned int v1:32; bool v2; unsigned short v3:16; };
struct BFu32i_B_BFu17i { unsigned int v1:32; bool v2; unsigned int v3:17; };
struct BFu32i_B_BFu17ll { unsigned int v1:32; bool v2; unsigned long long v3:17; };
struct BFu32i_B_BFu1c { unsigned int v1:32; bool v2; unsigned char v3:1; };
struct BFu32i_B_BFu1i { unsigned int v1:32; bool v2; unsigned int v3:1; };
struct BFu32i_B_BFu1ll { unsigned int v1:32; bool v2; unsigned long long v3:1; };
struct BFu32i_B_BFu1s { unsigned int v1:32; bool v2; unsigned short v3:1; };
struct BFu32i_B_BFu31i { unsigned int v1:32; bool v2; unsigned int v3:31; };
struct BFu32i_B_BFu31ll { unsigned int v1:32; bool v2; unsigned long long v3:31; };
struct BFu32i_B_BFu32i { unsigned int v1:32; bool v2; unsigned int v3:32; };
struct BFu32i_B_BFu32ll { unsigned int v1:32; bool v2; unsigned long long v3:32; };
struct BFu32i_B_BFu33 { unsigned int v1:32; bool v2; unsigned long long v3:33; };
struct BFu32i_B_BFu7c { unsigned int v1:32; bool v2; unsigned char v3:7; };
struct BFu32i_B_BFu7i { unsigned int v1:32; bool v2; unsigned int v3:7; };
struct BFu32i_B_BFu7ll { unsigned int v1:32; bool v2; unsigned long long v3:7; };
struct BFu32i_B_BFu7s { unsigned int v1:32; bool v2; unsigned short v3:7; };
struct BFu32i_B_BFu8c { unsigned int v1:32; bool v2; unsigned char v3:8; };
struct BFu32i_B_BFu8i { unsigned int v1:32; bool v2; unsigned int v3:8; };
struct BFu32i_B_BFu8ll { unsigned int v1:32; bool v2; unsigned long long v3:8; };
struct BFu32i_B_BFu8s { unsigned int v1:32; bool v2; unsigned short v3:8; };
struct BFu32i_B_BFu9i { unsigned int v1:32; bool v2; unsigned int v3:9; };
struct BFu32i_B_BFu9ll { unsigned int v1:32; bool v2; unsigned long long v3:9; };
struct BFu32i_B_BFu9s { unsigned int v1:32; bool v2; unsigned short v3:9; };
struct BFu32i_B_C { unsigned int v1:32; bool v2; char v3; };
struct BFu32i_B_D { unsigned int v1:32; bool v2; double v3; };
struct BFu32i_B_F { unsigned int v1:32; bool v2; float v3; };
struct BFu32i_B_I { unsigned int v1:32; bool v2; int v3; };
struct BFu32i_B_Ip { unsigned int v1:32; bool v2; int * v3; };
struct BFu32i_B_L { unsigned int v1:32; bool v2; long long v3; };
struct BFu32i_B_S { unsigned int v1:32; bool v2; short v3; };
struct BFu32i_B_Uc { unsigned int v1:32; bool v2; unsigned char v3; };
struct BFu32i_B_Ui { unsigned int v1:32; bool v2; unsigned int v3; };
struct BFu32i_B_Ul { unsigned int v1:32; bool v2; unsigned long long v3; };
struct BFu32i_B_Us { unsigned int v1:32; bool v2; unsigned short v3; };
struct BFu32i_B_Vp { unsigned int v1:32; bool v2; void * v3; };
struct BFu32i_BFu15i_B { unsigned int v1:32; unsigned int v2:15; bool v3; };
struct BFu32i_BFu15ll_B { unsigned int v1:32; unsigned long long v2:15; bool v3; };
struct BFu32i_BFu15s_B { unsigned int v1:32; unsigned short v2:15; bool v3; };
struct BFu32i_BFu16i_B { unsigned int v1:32; unsigned int v2:16; bool v3; };
struct BFu32i_BFu16ll_B { unsigned int v1:32; unsigned long long v2:16; bool v3; };
struct BFu32i_BFu16s_B { unsigned int v1:32; unsigned short v2:16; bool v3; };
struct BFu32i_BFu17i_B { unsigned int v1:32; unsigned int v2:17; bool v3; };
struct BFu32i_BFu17ll_B { unsigned int v1:32; unsigned long long v2:17; bool v3; };
struct BFu32i_BFu1c_B { unsigned int v1:32; unsigned char v2:1; bool v3; };
struct BFu32i_BFu1i_B { unsigned int v1:32; unsigned int v2:1; bool v3; };
struct BFu32i_BFu1ll_B { unsigned int v1:32; unsigned long long v2:1; bool v3; };
struct BFu32i_BFu1s_B { unsigned int v1:32; unsigned short v2:1; bool v3; };
struct BFu32i_BFu31i_B { unsigned int v1:32; unsigned int v2:31; bool v3; };
struct BFu32i_BFu31ll_B { unsigned int v1:32; unsigned long long v2:31; bool v3; };
struct BFu32i_BFu32i_B { unsigned int v1:32; unsigned int v2:32; bool v3; };
struct BFu32i_BFu32ll_B { unsigned int v1:32; unsigned long long v2:32; bool v3; };
struct BFu32i_BFu33_B { unsigned int v1:32; unsigned long long v2:33; bool v3; };
struct BFu32i_BFu7c_B { unsigned int v1:32; unsigned char v2:7; bool v3; };
struct BFu32i_BFu7i_B { unsigned int v1:32; unsigned int v2:7; bool v3; };
struct BFu32i_BFu7ll_B { unsigned int v1:32; unsigned long long v2:7; bool v3; };
struct BFu32i_BFu7s_B { unsigned int v1:32; unsigned short v2:7; bool v3; };
struct BFu32i_BFu8c_B { unsigned int v1:32; unsigned char v2:8; bool v3; };
struct BFu32i_BFu8i_B { unsigned int v1:32; unsigned int v2:8; bool v3; };
struct BFu32i_BFu8ll_B { unsigned int v1:32; unsigned long long v2:8; bool v3; };
struct BFu32i_BFu8s_B { unsigned int v1:32; unsigned short v2:8; bool v3; };
struct BFu32i_BFu9i_B { unsigned int v1:32; unsigned int v2:9; bool v3; };
struct BFu32i_BFu9ll_B { unsigned int v1:32; unsigned long long v2:9; bool v3; };
struct BFu32i_BFu9s_B { unsigned int v1:32; unsigned short v2:9; bool v3; };
struct BFu32i_C_B { unsigned int v1:32; char v2; bool v3; };
struct BFu32i_D_B { unsigned int v1:32; double v2; bool v3; };
struct BFu32i_F_B { unsigned int v1:32; float v2; bool v3; };
struct BFu32i_I_B { unsigned int v1:32; int v2; bool v3; };
struct BFu32i_Ip_B { unsigned int v1:32; int * v2; bool v3; };
struct BFu32i_L_B { unsigned int v1:32; long long v2; bool v3; };
struct BFu32i_S_B { unsigned int v1:32; short v2; bool v3; };
struct BFu32i_Uc_B { unsigned int v1:32; unsigned char v2; bool v3; };
struct BFu32i_Ui_B { unsigned int v1:32; unsigned int v2; bool v3; };
struct BFu32i_Ul_B { unsigned int v1:32; unsigned long long v2; bool v3; };
struct BFu32i_Us_B { unsigned int v1:32; unsigned short v2; bool v3; };
struct BFu32i_Vp_B { unsigned int v1:32; void * v2; bool v3; };
struct BFu32ll_B { unsigned long long v1:32; bool v2; };
struct BFu32ll_B_B { unsigned long long v1:32; bool v2; bool v3; };
struct BFu32ll_B_BFu15i { unsigned long long v1:32; bool v2; unsigned int v3:15; };
struct BFu32ll_B_BFu15ll { unsigned long long v1:32; bool v2; unsigned long long v3:15; };
struct BFu32ll_B_BFu15s { unsigned long long v1:32; bool v2; unsigned short v3:15; };
struct BFu32ll_B_BFu16i { unsigned long long v1:32; bool v2; unsigned int v3:16; };
struct BFu32ll_B_BFu16ll { unsigned long long v1:32; bool v2; unsigned long long v3:16; };
struct BFu32ll_B_BFu16s { unsigned long long v1:32; bool v2; unsigned short v3:16; };
struct BFu32ll_B_BFu17i { unsigned long long v1:32; bool v2; unsigned int v3:17; };
struct BFu32ll_B_BFu17ll { unsigned long long v1:32; bool v2; unsigned long long v3:17; };
struct BFu32ll_B_BFu1c { unsigned long long v1:32; bool v2; unsigned char v3:1; };
struct BFu32ll_B_BFu1i { unsigned long long v1:32; bool v2; unsigned int v3:1; };
struct BFu32ll_B_BFu1ll { unsigned long long v1:32; bool v2; unsigned long long v3:1; };
struct BFu32ll_B_BFu1s { unsigned long long v1:32; bool v2; unsigned short v3:1; };
struct BFu32ll_B_BFu31i { unsigned long long v1:32; bool v2; unsigned int v3:31; };
struct BFu32ll_B_BFu31ll { unsigned long long v1:32; bool v2; unsigned long long v3:31; };
struct BFu32ll_B_BFu32i { unsigned long long v1:32; bool v2; unsigned int v3:32; };
struct BFu32ll_B_BFu32ll { unsigned long long v1:32; bool v2; unsigned long long v3:32; };
struct BFu32ll_B_BFu33 { unsigned long long v1:32; bool v2; unsigned long long v3:33; };
struct BFu32ll_B_BFu7c { unsigned long long v1:32; bool v2; unsigned char v3:7; };
struct BFu32ll_B_BFu7i { unsigned long long v1:32; bool v2; unsigned int v3:7; };
struct BFu32ll_B_BFu7ll { unsigned long long v1:32; bool v2; unsigned long long v3:7; };
struct BFu32ll_B_BFu7s { unsigned long long v1:32; bool v2; unsigned short v3:7; };
struct BFu32ll_B_BFu8c { unsigned long long v1:32; bool v2; unsigned char v3:8; };
struct BFu32ll_B_BFu8i { unsigned long long v1:32; bool v2; unsigned int v3:8; };
struct BFu32ll_B_BFu8ll { unsigned long long v1:32; bool v2; unsigned long long v3:8; };
struct BFu32ll_B_BFu8s { unsigned long long v1:32; bool v2; unsigned short v3:8; };
struct BFu32ll_B_BFu9i { unsigned long long v1:32; bool v2; unsigned int v3:9; };
struct BFu32ll_B_BFu9ll { unsigned long long v1:32; bool v2; unsigned long long v3:9; };
struct BFu32ll_B_BFu9s { unsigned long long v1:32; bool v2; unsigned short v3:9; };
struct BFu32ll_B_C { unsigned long long v1:32; bool v2; char v3; };
struct BFu32ll_B_D { unsigned long long v1:32; bool v2; double v3; };
struct BFu32ll_B_F { unsigned long long v1:32; bool v2; float v3; };
struct BFu32ll_B_I { unsigned long long v1:32; bool v2; int v3; };
struct BFu32ll_B_Ip { unsigned long long v1:32; bool v2; int * v3; };
struct BFu32ll_B_L { unsigned long long v1:32; bool v2; long long v3; };
struct BFu32ll_B_S { unsigned long long v1:32; bool v2; short v3; };
struct BFu32ll_B_Uc { unsigned long long v1:32; bool v2; unsigned char v3; };
struct BFu32ll_B_Ui { unsigned long long v1:32; bool v2; unsigned int v3; };
struct BFu32ll_B_Ul { unsigned long long v1:32; bool v2; unsigned long long v3; };
struct BFu32ll_B_Us { unsigned long long v1:32; bool v2; unsigned short v3; };
struct BFu32ll_B_Vp { unsigned long long v1:32; bool v2; void * v3; };
struct BFu32ll_BFu15i_B { unsigned long long v1:32; unsigned int v2:15; bool v3; };
struct BFu32ll_BFu15ll_B { unsigned long long v1:32; unsigned long long v2:15; bool v3; };
struct BFu32ll_BFu15s_B { unsigned long long v1:32; unsigned short v2:15; bool v3; };
struct BFu32ll_BFu16i_B { unsigned long long v1:32; unsigned int v2:16; bool v3; };
struct BFu32ll_BFu16ll_B { unsigned long long v1:32; unsigned long long v2:16; bool v3; };
struct BFu32ll_BFu16s_B { unsigned long long v1:32; unsigned short v2:16; bool v3; };
struct BFu32ll_BFu17i_B { unsigned long long v1:32; unsigned int v2:17; bool v3; };
struct BFu32ll_BFu17ll_B { unsigned long long v1:32; unsigned long long v2:17; bool v3; };
struct BFu32ll_BFu1c_B { unsigned long long v1:32; unsigned char v2:1; bool v3; };
struct BFu32ll_BFu1i_B { unsigned long long v1:32; unsigned int v2:1; bool v3; };
struct BFu32ll_BFu1ll_B { unsigned long long v1:32; unsigned long long v2:1; bool v3; };
struct BFu32ll_BFu1s_B { unsigned long long v1:32; unsigned short v2:1; bool v3; };
struct BFu32ll_BFu31i_B { unsigned long long v1:32; unsigned int v2:31; bool v3; };
struct BFu32ll_BFu31ll_B { unsigned long long v1:32; unsigned long long v2:31; bool v3; };
struct BFu32ll_BFu32i_B { unsigned long long v1:32; unsigned int v2:32; bool v3; };
struct BFu32ll_BFu32ll_B { unsigned long long v1:32; unsigned long long v2:32; bool v3; };
struct BFu32ll_BFu33_B { unsigned long long v1:32; unsigned long long v2:33; bool v3; };
struct BFu32ll_BFu7c_B { unsigned long long v1:32; unsigned char v2:7; bool v3; };
struct BFu32ll_BFu7i_B { unsigned long long v1:32; unsigned int v2:7; bool v3; };
struct BFu32ll_BFu7ll_B { unsigned long long v1:32; unsigned long long v2:7; bool v3; };
struct BFu32ll_BFu7s_B { unsigned long long v1:32; unsigned short v2:7; bool v3; };
struct BFu32ll_BFu8c_B { unsigned long long v1:32; unsigned char v2:8; bool v3; };
struct BFu32ll_BFu8i_B { unsigned long long v1:32; unsigned int v2:8; bool v3; };
struct BFu32ll_BFu8ll_B { unsigned long long v1:32; unsigned long long v2:8; bool v3; };
struct BFu32ll_BFu8s_B { unsigned long long v1:32; unsigned short v2:8; bool v3; };
struct BFu32ll_BFu9i_B { unsigned long long v1:32; unsigned int v2:9; bool v3; };
struct BFu32ll_BFu9ll_B { unsigned long long v1:32; unsigned long long v2:9; bool v3; };
struct BFu32ll_BFu9s_B { unsigned long long v1:32; unsigned short v2:9; bool v3; };
struct BFu32ll_C_B { unsigned long long v1:32; char v2; bool v3; };
struct BFu32ll_D_B { unsigned long long v1:32; double v2; bool v3; };
struct BFu32ll_F_B { unsigned long long v1:32; float v2; bool v3; };
struct BFu32ll_I_B { unsigned long long v1:32; int v2; bool v3; };
struct BFu32ll_Ip_B { unsigned long long v1:32; int * v2; bool v3; };
struct BFu32ll_L_B { unsigned long long v1:32; long long v2; bool v3; };
struct BFu32ll_S_B { unsigned long long v1:32; short v2; bool v3; };
struct BFu32ll_Uc_B { unsigned long long v1:32; unsigned char v2; bool v3; };
struct BFu32ll_Ui_B { unsigned long long v1:32; unsigned int v2; bool v3; };
struct BFu32ll_Ul_B { unsigned long long v1:32; unsigned long long v2; bool v3; };
struct BFu32ll_Us_B { unsigned long long v1:32; unsigned short v2; bool v3; };
struct BFu32ll_Vp_B { unsigned long long v1:32; void * v2; bool v3; };
struct BFu33_B { unsigned long long v1:33; bool v2; };
struct BFu33_B_B { unsigned long long v1:33; bool v2; bool v3; };
struct BFu33_B_BFu15i { unsigned long long v1:33; bool v2; unsigned int v3:15; };
struct BFu33_B_BFu15ll { unsigned long long v1:33; bool v2; unsigned long long v3:15; };
struct BFu33_B_BFu15s { unsigned long long v1:33; bool v2; unsigned short v3:15; };
struct BFu33_B_BFu16i { unsigned long long v1:33; bool v2; unsigned int v3:16; };
struct BFu33_B_BFu16ll { unsigned long long v1:33; bool v2; unsigned long long v3:16; };
struct BFu33_B_BFu16s { unsigned long long v1:33; bool v2; unsigned short v3:16; };
struct BFu33_B_BFu17i { unsigned long long v1:33; bool v2; unsigned int v3:17; };
struct BFu33_B_BFu17ll { unsigned long long v1:33; bool v2; unsigned long long v3:17; };
struct BFu33_B_BFu1c { unsigned long long v1:33; bool v2; unsigned char v3:1; };
struct BFu33_B_BFu1i { unsigned long long v1:33; bool v2; unsigned int v3:1; };
struct BFu33_B_BFu1ll { unsigned long long v1:33; bool v2; unsigned long long v3:1; };
struct BFu33_B_BFu1s { unsigned long long v1:33; bool v2; unsigned short v3:1; };
struct BFu33_B_BFu31i { unsigned long long v1:33; bool v2; unsigned int v3:31; };
struct BFu33_B_BFu31ll { unsigned long long v1:33; bool v2; unsigned long long v3:31; };
struct BFu33_B_BFu32i { unsigned long long v1:33; bool v2; unsigned int v3:32; };
struct BFu33_B_BFu32ll { unsigned long long v1:33; bool v2; unsigned long long v3:32; };
struct BFu33_B_BFu33 { unsigned long long v1:33; bool v2; unsigned long long v3:33; };
struct BFu33_B_BFu7c { unsigned long long v1:33; bool v2; unsigned char v3:7; };
struct BFu33_B_BFu7i { unsigned long long v1:33; bool v2; unsigned int v3:7; };
struct BFu33_B_BFu7ll { unsigned long long v1:33; bool v2; unsigned long long v3:7; };
struct BFu33_B_BFu7s { unsigned long long v1:33; bool v2; unsigned short v3:7; };
struct BFu33_B_BFu8c { unsigned long long v1:33; bool v2; unsigned char v3:8; };
struct BFu33_B_BFu8i { unsigned long long v1:33; bool v2; unsigned int v3:8; };
struct BFu33_B_BFu8ll { unsigned long long v1:33; bool v2; unsigned long long v3:8; };
struct BFu33_B_BFu8s { unsigned long long v1:33; bool v2; unsigned short v3:8; };
struct BFu33_B_BFu9i { unsigned long long v1:33; bool v2; unsigned int v3:9; };
struct BFu33_B_BFu9ll { unsigned long long v1:33; bool v2; unsigned long long v3:9; };
struct BFu33_B_BFu9s { unsigned long long v1:33; bool v2; unsigned short v3:9; };
struct BFu33_B_C { unsigned long long v1:33; bool v2; char v3; };
struct BFu33_B_D { unsigned long long v1:33; bool v2; double v3; };
struct BFu33_B_F { unsigned long long v1:33; bool v2; float v3; };
struct BFu33_B_I { unsigned long long v1:33; bool v2; int v3; };
struct BFu33_B_Ip { unsigned long long v1:33; bool v2; int * v3; };
struct BFu33_B_L { unsigned long long v1:33; bool v2; long long v3; };
struct BFu33_B_S { unsigned long long v1:33; bool v2; short v3; };
struct BFu33_B_Uc { unsigned long long v1:33; bool v2; unsigned char v3; };
struct BFu33_B_Ui { unsigned long long v1:33; bool v2; unsigned int v3; };
struct BFu33_B_Ul { unsigned long long v1:33; bool v2; unsigned long long v3; };
struct BFu33_B_Us { unsigned long long v1:33; bool v2; unsigned short v3; };
struct BFu33_B_Vp { unsigned long long v1:33; bool v2; void * v3; };
struct BFu33_BFu15i_B { unsigned long long v1:33; unsigned int v2:15; bool v3; };
struct BFu33_BFu15ll_B { unsigned long long v1:33; unsigned long long v2:15; bool v3; };
struct BFu33_BFu15s_B { unsigned long long v1:33; unsigned short v2:15; bool v3; };
struct BFu33_BFu16i_B { unsigned long long v1:33; unsigned int v2:16; bool v3; };
struct BFu33_BFu16ll_B { unsigned long long v1:33; unsigned long long v2:16; bool v3; };
struct BFu33_BFu16s_B { unsigned long long v1:33; unsigned short v2:16; bool v3; };
struct BFu33_BFu17i_B { unsigned long long v1:33; unsigned int v2:17; bool v3; };
struct BFu33_BFu17ll_B { unsigned long long v1:33; unsigned long long v2:17; bool v3; };
struct BFu33_BFu1c_B { unsigned long long v1:33; unsigned char v2:1; bool v3; };
struct BFu33_BFu1i_B { unsigned long long v1:33; unsigned int v2:1; bool v3; };
struct BFu33_BFu1ll_B { unsigned long long v1:33; unsigned long long v2:1; bool v3; };
struct BFu33_BFu1s_B { unsigned long long v1:33; unsigned short v2:1; bool v3; };
struct BFu33_BFu31i_B { unsigned long long v1:33; unsigned int v2:31; bool v3; };
struct BFu33_BFu31ll_B { unsigned long long v1:33; unsigned long long v2:31; bool v3; };
struct BFu33_BFu32i_B { unsigned long long v1:33; unsigned int v2:32; bool v3; };
struct BFu33_BFu32ll_B { unsigned long long v1:33; unsigned long long v2:32; bool v3; };
struct BFu33_BFu33_B { unsigned long long v1:33; unsigned long long v2:33; bool v3; };
struct BFu33_BFu7c_B { unsigned long long v1:33; unsigned char v2:7; bool v3; };
struct BFu33_BFu7i_B { unsigned long long v1:33; unsigned int v2:7; bool v3; };
struct BFu33_BFu7ll_B { unsigned long long v1:33; unsigned long long v2:7; bool v3; };
struct BFu33_BFu7s_B { unsigned long long v1:33; unsigned short v2:7; bool v3; };
struct BFu33_BFu8c_B { unsigned long long v1:33; unsigned char v2:8; bool v3; };
struct BFu33_BFu8i_B { unsigned long long v1:33; unsigned int v2:8; bool v3; };
struct BFu33_BFu8ll_B { unsigned long long v1:33; unsigned long long v2:8; bool v3; };
struct BFu33_BFu8s_B { unsigned long long v1:33; unsigned short v2:8; bool v3; };
struct BFu33_BFu9i_B { unsigned long long v1:33; unsigned int v2:9; bool v3; };
struct BFu33_BFu9ll_B { unsigned long long v1:33; unsigned long long v2:9; bool v3; };
struct BFu33_BFu9s_B { unsigned long long v1:33; unsigned short v2:9; bool v3; };
struct BFu33_C_B { unsigned long long v1:33; char v2; bool v3; };
struct BFu33_D_B { unsigned long long v1:33; double v2; bool v3; };
struct BFu33_F_B { unsigned long long v1:33; float v2; bool v3; };
struct BFu33_I_B { unsigned long long v1:33; int v2; bool v3; };
struct BFu33_Ip_B { unsigned long long v1:33; int * v2; bool v3; };
struct BFu33_L_B { unsigned long long v1:33; long long v2; bool v3; };
struct BFu33_S_B { unsigned long long v1:33; short v2; bool v3; };
struct BFu33_Uc_B { unsigned long long v1:33; unsigned char v2; bool v3; };
struct BFu33_Ui_B { unsigned long long v1:33; unsigned int v2; bool v3; };
struct BFu33_Ul_B { unsigned long long v1:33; unsigned long long v2; bool v3; };
struct BFu33_Us_B { unsigned long long v1:33; unsigned short v2; bool v3; };
struct BFu33_Vp_B { unsigned long long v1:33; void * v2; bool v3; };
struct BFu7c_B { unsigned char v1:7; bool v2; };
struct BFu7c_B_B { unsigned char v1:7; bool v2; bool v3; };
struct BFu7c_B_BFu15i { unsigned char v1:7; bool v2; unsigned int v3:15; };
struct BFu7c_B_BFu15ll { unsigned char v1:7; bool v2; unsigned long long v3:15; };
struct BFu7c_B_BFu15s { unsigned char v1:7; bool v2; unsigned short v3:15; };
struct BFu7c_B_BFu16i { unsigned char v1:7; bool v2; unsigned int v3:16; };
struct BFu7c_B_BFu16ll { unsigned char v1:7; bool v2; unsigned long long v3:16; };
struct BFu7c_B_BFu16s { unsigned char v1:7; bool v2; unsigned short v3:16; };
struct BFu7c_B_BFu17i { unsigned char v1:7; bool v2; unsigned int v3:17; };
struct BFu7c_B_BFu17ll { unsigned char v1:7; bool v2; unsigned long long v3:17; };
struct BFu7c_B_BFu1c { unsigned char v1:7; bool v2; unsigned char v3:1; };
struct BFu7c_B_BFu1i { unsigned char v1:7; bool v2; unsigned int v3:1; };
struct BFu7c_B_BFu1ll { unsigned char v1:7; bool v2; unsigned long long v3:1; };
struct BFu7c_B_BFu1s { unsigned char v1:7; bool v2; unsigned short v3:1; };
struct BFu7c_B_BFu31i { unsigned char v1:7; bool v2; unsigned int v3:31; };
struct BFu7c_B_BFu31ll { unsigned char v1:7; bool v2; unsigned long long v3:31; };
struct BFu7c_B_BFu32i { unsigned char v1:7; bool v2; unsigned int v3:32; };
struct BFu7c_B_BFu32ll { unsigned char v1:7; bool v2; unsigned long long v3:32; };
struct BFu7c_B_BFu33 { unsigned char v1:7; bool v2; unsigned long long v3:33; };
struct BFu7c_B_BFu7c { unsigned char v1:7; bool v2; unsigned char v3:7; };
struct BFu7c_B_BFu7i { unsigned char v1:7; bool v2; unsigned int v3:7; };
struct BFu7c_B_BFu7ll { unsigned char v1:7; bool v2; unsigned long long v3:7; };
struct BFu7c_B_BFu7s { unsigned char v1:7; bool v2; unsigned short v3:7; };
struct BFu7c_B_BFu8c { unsigned char v1:7; bool v2; unsigned char v3:8; };
struct BFu7c_B_BFu8i { unsigned char v1:7; bool v2; unsigned int v3:8; };
struct BFu7c_B_BFu8ll { unsigned char v1:7; bool v2; unsigned long long v3:8; };
struct BFu7c_B_BFu8s { unsigned char v1:7; bool v2; unsigned short v3:8; };
struct BFu7c_B_BFu9i { unsigned char v1:7; bool v2; unsigned int v3:9; };
struct BFu7c_B_BFu9ll { unsigned char v1:7; bool v2; unsigned long long v3:9; };
struct BFu7c_B_BFu9s { unsigned char v1:7; bool v2; unsigned short v3:9; };
struct BFu7c_B_C { unsigned char v1:7; bool v2; char v3; };
struct BFu7c_B_D { unsigned char v1:7; bool v2; double v3; };
struct BFu7c_B_F { unsigned char v1:7; bool v2; float v3; };
struct BFu7c_B_I { unsigned char v1:7; bool v2; int v3; };
struct BFu7c_B_Ip { unsigned char v1:7; bool v2; int * v3; };
struct BFu7c_B_L { unsigned char v1:7; bool v2; long long v3; };
struct BFu7c_B_S { unsigned char v1:7; bool v2; short v3; };
struct BFu7c_B_Uc { unsigned char v1:7; bool v2; unsigned char v3; };
struct BFu7c_B_Ui { unsigned char v1:7; bool v2; unsigned int v3; };
struct BFu7c_B_Ul { unsigned char v1:7; bool v2; unsigned long long v3; };
struct BFu7c_B_Us { unsigned char v1:7; bool v2; unsigned short v3; };
struct BFu7c_B_Vp { unsigned char v1:7; bool v2; void * v3; };
struct BFu7c_BFu15i_B { unsigned char v1:7; unsigned int v2:15; bool v3; };
struct BFu7c_BFu15ll_B { unsigned char v1:7; unsigned long long v2:15; bool v3; };
struct BFu7c_BFu15s_B { unsigned char v1:7; unsigned short v2:15; bool v3; };
struct BFu7c_BFu16i_B { unsigned char v1:7; unsigned int v2:16; bool v3; };
struct BFu7c_BFu16ll_B { unsigned char v1:7; unsigned long long v2:16; bool v3; };
struct BFu7c_BFu16s_B { unsigned char v1:7; unsigned short v2:16; bool v3; };
struct BFu7c_BFu17i_B { unsigned char v1:7; unsigned int v2:17; bool v3; };
struct BFu7c_BFu17ll_B { unsigned char v1:7; unsigned long long v2:17; bool v3; };
struct BFu7c_BFu1c_B { unsigned char v1:7; unsigned char v2:1; bool v3; };
struct BFu7c_BFu1i_B { unsigned char v1:7; unsigned int v2:1; bool v3; };
struct BFu7c_BFu1ll_B { unsigned char v1:7; unsigned long long v2:1; bool v3; };
struct BFu7c_BFu1s_B { unsigned char v1:7; unsigned short v2:1; bool v3; };
struct BFu7c_BFu31i_B { unsigned char v1:7; unsigned int v2:31; bool v3; };
struct BFu7c_BFu31ll_B { unsigned char v1:7; unsigned long long v2:31; bool v3; };
struct BFu7c_BFu32i_B { unsigned char v1:7; unsigned int v2:32; bool v3; };
struct BFu7c_BFu32ll_B { unsigned char v1:7; unsigned long long v2:32; bool v3; };
struct BFu7c_BFu33_B { unsigned char v1:7; unsigned long long v2:33; bool v3; };
struct BFu7c_BFu7c_B { unsigned char v1:7; unsigned char v2:7; bool v3; };
struct BFu7c_BFu7i_B { unsigned char v1:7; unsigned int v2:7; bool v3; };
struct BFu7c_BFu7ll_B { unsigned char v1:7; unsigned long long v2:7; bool v3; };
struct BFu7c_BFu7s_B { unsigned char v1:7; unsigned short v2:7; bool v3; };
struct BFu7c_BFu8c_B { unsigned char v1:7; unsigned char v2:8; bool v3; };
struct BFu7c_BFu8i_B { unsigned char v1:7; unsigned int v2:8; bool v3; };
struct BFu7c_BFu8ll_B { unsigned char v1:7; unsigned long long v2:8; bool v3; };
struct BFu7c_BFu8s_B { unsigned char v1:7; unsigned short v2:8; bool v3; };
struct BFu7c_BFu9i_B { unsigned char v1:7; unsigned int v2:9; bool v3; };
struct BFu7c_BFu9ll_B { unsigned char v1:7; unsigned long long v2:9; bool v3; };
struct BFu7c_BFu9s_B { unsigned char v1:7; unsigned short v2:9; bool v3; };
struct BFu7c_C_B { unsigned char v1:7; char v2; bool v3; };
struct BFu7c_D_B { unsigned char v1:7; double v2; bool v3; };
struct BFu7c_F_B { unsigned char v1:7; float v2; bool v3; };
struct BFu7c_I_B { unsigned char v1:7; int v2; bool v3; };
struct BFu7c_Ip_B { unsigned char v1:7; int * v2; bool v3; };
struct BFu7c_L_B { unsigned char v1:7; long long v2; bool v3; };
struct BFu7c_S_B { unsigned char v1:7; short v2; bool v3; };
struct BFu7c_Uc_B { unsigned char v1:7; unsigned char v2; bool v3; };
struct BFu7c_Ui_B { unsigned char v1:7; unsigned int v2; bool v3; };
struct BFu7c_Ul_B { unsigned char v1:7; unsigned long long v2; bool v3; };
struct BFu7c_Us_B { unsigned char v1:7; unsigned short v2; bool v3; };
struct BFu7c_Vp_B { unsigned char v1:7; void * v2; bool v3; };
struct BFu7i_B { unsigned int v1:7; bool v2; };
struct BFu7i_B_B { unsigned int v1:7; bool v2; bool v3; };
struct BFu7i_B_BFu15i { unsigned int v1:7; bool v2; unsigned int v3:15; };
struct BFu7i_B_BFu15ll { unsigned int v1:7; bool v2; unsigned long long v3:15; };
struct BFu7i_B_BFu15s { unsigned int v1:7; bool v2; unsigned short v3:15; };
struct BFu7i_B_BFu16i { unsigned int v1:7; bool v2; unsigned int v3:16; };
struct BFu7i_B_BFu16ll { unsigned int v1:7; bool v2; unsigned long long v3:16; };
struct BFu7i_B_BFu16s { unsigned int v1:7; bool v2; unsigned short v3:16; };
struct BFu7i_B_BFu17i { unsigned int v1:7; bool v2; unsigned int v3:17; };
struct BFu7i_B_BFu17ll { unsigned int v1:7; bool v2; unsigned long long v3:17; };
struct BFu7i_B_BFu1c { unsigned int v1:7; bool v2; unsigned char v3:1; };
struct BFu7i_B_BFu1i { unsigned int v1:7; bool v2; unsigned int v3:1; };
struct BFu7i_B_BFu1ll { unsigned int v1:7; bool v2; unsigned long long v3:1; };
struct BFu7i_B_BFu1s { unsigned int v1:7; bool v2; unsigned short v3:1; };
struct BFu7i_B_BFu31i { unsigned int v1:7; bool v2; unsigned int v3:31; };
struct BFu7i_B_BFu31ll { unsigned int v1:7; bool v2; unsigned long long v3:31; };
struct BFu7i_B_BFu32i { unsigned int v1:7; bool v2; unsigned int v3:32; };
struct BFu7i_B_BFu32ll { unsigned int v1:7; bool v2; unsigned long long v3:32; };
struct BFu7i_B_BFu33 { unsigned int v1:7; bool v2; unsigned long long v3:33; };
struct BFu7i_B_BFu7c { unsigned int v1:7; bool v2; unsigned char v3:7; };
struct BFu7i_B_BFu7i { unsigned int v1:7; bool v2; unsigned int v3:7; };
struct BFu7i_B_BFu7ll { unsigned int v1:7; bool v2; unsigned long long v3:7; };
struct BFu7i_B_BFu7s { unsigned int v1:7; bool v2; unsigned short v3:7; };
struct BFu7i_B_BFu8c { unsigned int v1:7; bool v2; unsigned char v3:8; };
struct BFu7i_B_BFu8i { unsigned int v1:7; bool v2; unsigned int v3:8; };
struct BFu7i_B_BFu8ll { unsigned int v1:7; bool v2; unsigned long long v3:8; };
struct BFu7i_B_BFu8s { unsigned int v1:7; bool v2; unsigned short v3:8; };
struct BFu7i_B_BFu9i { unsigned int v1:7; bool v2; unsigned int v3:9; };
struct BFu7i_B_BFu9ll { unsigned int v1:7; bool v2; unsigned long long v3:9; };
struct BFu7i_B_BFu9s { unsigned int v1:7; bool v2; unsigned short v3:9; };
struct BFu7i_B_C { unsigned int v1:7; bool v2; char v3; };
struct BFu7i_B_D { unsigned int v1:7; bool v2; double v3; };
struct BFu7i_B_F { unsigned int v1:7; bool v2; float v3; };
struct BFu7i_B_I { unsigned int v1:7; bool v2; int v3; };
struct BFu7i_B_Ip { unsigned int v1:7; bool v2; int * v3; };
struct BFu7i_B_L { unsigned int v1:7; bool v2; long long v3; };
struct BFu7i_B_S { unsigned int v1:7; bool v2; short v3; };
struct BFu7i_B_Uc { unsigned int v1:7; bool v2; unsigned char v3; };
struct BFu7i_B_Ui { unsigned int v1:7; bool v2; unsigned int v3; };
struct BFu7i_B_Ul { unsigned int v1:7; bool v2; unsigned long long v3; };
struct BFu7i_B_Us { unsigned int v1:7; bool v2; unsigned short v3; };
struct BFu7i_B_Vp { unsigned int v1:7; bool v2; void * v3; };
struct BFu7i_BFu15i_B { unsigned int v1:7; unsigned int v2:15; bool v3; };
struct BFu7i_BFu15ll_B { unsigned int v1:7; unsigned long long v2:15; bool v3; };
struct BFu7i_BFu15s_B { unsigned int v1:7; unsigned short v2:15; bool v3; };
struct BFu7i_BFu16i_B { unsigned int v1:7; unsigned int v2:16; bool v3; };
struct BFu7i_BFu16ll_B { unsigned int v1:7; unsigned long long v2:16; bool v3; };
struct BFu7i_BFu16s_B { unsigned int v1:7; unsigned short v2:16; bool v3; };
struct BFu7i_BFu17i_B { unsigned int v1:7; unsigned int v2:17; bool v3; };
struct BFu7i_BFu17ll_B { unsigned int v1:7; unsigned long long v2:17; bool v3; };
struct BFu7i_BFu1c_B { unsigned int v1:7; unsigned char v2:1; bool v3; };
struct BFu7i_BFu1i_B { unsigned int v1:7; unsigned int v2:1; bool v3; };
struct BFu7i_BFu1ll_B { unsigned int v1:7; unsigned long long v2:1; bool v3; };
struct BFu7i_BFu1s_B { unsigned int v1:7; unsigned short v2:1; bool v3; };
struct BFu7i_BFu31i_B { unsigned int v1:7; unsigned int v2:31; bool v3; };
struct BFu7i_BFu31ll_B { unsigned int v1:7; unsigned long long v2:31; bool v3; };
struct BFu7i_BFu32i_B { unsigned int v1:7; unsigned int v2:32; bool v3; };
struct BFu7i_BFu32ll_B { unsigned int v1:7; unsigned long long v2:32; bool v3; };
struct BFu7i_BFu33_B { unsigned int v1:7; unsigned long long v2:33; bool v3; };
struct BFu7i_BFu7c_B { unsigned int v1:7; unsigned char v2:7; bool v3; };
struct BFu7i_BFu7i_B { unsigned int v1:7; unsigned int v2:7; bool v3; };
struct BFu7i_BFu7ll_B { unsigned int v1:7; unsigned long long v2:7; bool v3; };
struct BFu7i_BFu7s_B { unsigned int v1:7; unsigned short v2:7; bool v3; };
struct BFu7i_BFu8c_B { unsigned int v1:7; unsigned char v2:8; bool v3; };
struct BFu7i_BFu8i_B { unsigned int v1:7; unsigned int v2:8; bool v3; };
struct BFu7i_BFu8ll_B { unsigned int v1:7; unsigned long long v2:8; bool v3; };
struct BFu7i_BFu8s_B { unsigned int v1:7; unsigned short v2:8; bool v3; };
struct BFu7i_BFu9i_B { unsigned int v1:7; unsigned int v2:9; bool v3; };
struct BFu7i_BFu9ll_B { unsigned int v1:7; unsigned long long v2:9; bool v3; };
struct BFu7i_BFu9s_B { unsigned int v1:7; unsigned short v2:9; bool v3; };
struct BFu7i_C_B { unsigned int v1:7; char v2; bool v3; };
struct BFu7i_D_B { unsigned int v1:7; double v2; bool v3; };
struct BFu7i_F_B { unsigned int v1:7; float v2; bool v3; };
struct BFu7i_I_B { unsigned int v1:7; int v2; bool v3; };
struct BFu7i_Ip_B { unsigned int v1:7; int * v2; bool v3; };
struct BFu7i_L_B { unsigned int v1:7; long long v2; bool v3; };
struct BFu7i_S_B { unsigned int v1:7; short v2; bool v3; };
struct BFu7i_Uc_B { unsigned int v1:7; unsigned char v2; bool v3; };
struct BFu7i_Ui_B { unsigned int v1:7; unsigned int v2; bool v3; };
struct BFu7i_Ul_B { unsigned int v1:7; unsigned long long v2; bool v3; };
struct BFu7i_Us_B { unsigned int v1:7; unsigned short v2; bool v3; };
struct BFu7i_Vp_B { unsigned int v1:7; void * v2; bool v3; };
struct BFu7ll_B { unsigned long long v1:7; bool v2; };
struct BFu7ll_B_B { unsigned long long v1:7; bool v2; bool v3; };
struct BFu7ll_B_BFu15i { unsigned long long v1:7; bool v2; unsigned int v3:15; };
struct BFu7ll_B_BFu15ll { unsigned long long v1:7; bool v2; unsigned long long v3:15; };
struct BFu7ll_B_BFu15s { unsigned long long v1:7; bool v2; unsigned short v3:15; };
struct BFu7ll_B_BFu16i { unsigned long long v1:7; bool v2; unsigned int v3:16; };
struct BFu7ll_B_BFu16ll { unsigned long long v1:7; bool v2; unsigned long long v3:16; };
struct BFu7ll_B_BFu16s { unsigned long long v1:7; bool v2; unsigned short v3:16; };
struct BFu7ll_B_BFu17i { unsigned long long v1:7; bool v2; unsigned int v3:17; };
struct BFu7ll_B_BFu17ll { unsigned long long v1:7; bool v2; unsigned long long v3:17; };
struct BFu7ll_B_BFu1c { unsigned long long v1:7; bool v2; unsigned char v3:1; };
struct BFu7ll_B_BFu1i { unsigned long long v1:7; bool v2; unsigned int v3:1; };
struct BFu7ll_B_BFu1ll { unsigned long long v1:7; bool v2; unsigned long long v3:1; };
struct BFu7ll_B_BFu1s { unsigned long long v1:7; bool v2; unsigned short v3:1; };
struct BFu7ll_B_BFu31i { unsigned long long v1:7; bool v2; unsigned int v3:31; };
struct BFu7ll_B_BFu31ll { unsigned long long v1:7; bool v2; unsigned long long v3:31; };
struct BFu7ll_B_BFu32i { unsigned long long v1:7; bool v2; unsigned int v3:32; };
struct BFu7ll_B_BFu32ll { unsigned long long v1:7; bool v2; unsigned long long v3:32; };
struct BFu7ll_B_BFu33 { unsigned long long v1:7; bool v2; unsigned long long v3:33; };
struct BFu7ll_B_BFu7c { unsigned long long v1:7; bool v2; unsigned char v3:7; };
struct BFu7ll_B_BFu7i { unsigned long long v1:7; bool v2; unsigned int v3:7; };
struct BFu7ll_B_BFu7ll { unsigned long long v1:7; bool v2; unsigned long long v3:7; };
struct BFu7ll_B_BFu7s { unsigned long long v1:7; bool v2; unsigned short v3:7; };
struct BFu7ll_B_BFu8c { unsigned long long v1:7; bool v2; unsigned char v3:8; };
struct BFu7ll_B_BFu8i { unsigned long long v1:7; bool v2; unsigned int v3:8; };
struct BFu7ll_B_BFu8ll { unsigned long long v1:7; bool v2; unsigned long long v3:8; };
struct BFu7ll_B_BFu8s { unsigned long long v1:7; bool v2; unsigned short v3:8; };
struct BFu7ll_B_BFu9i { unsigned long long v1:7; bool v2; unsigned int v3:9; };
struct BFu7ll_B_BFu9ll { unsigned long long v1:7; bool v2; unsigned long long v3:9; };
struct BFu7ll_B_BFu9s { unsigned long long v1:7; bool v2; unsigned short v3:9; };
struct BFu7ll_B_C { unsigned long long v1:7; bool v2; char v3; };
struct BFu7ll_B_D { unsigned long long v1:7; bool v2; double v3; };
struct BFu7ll_B_F { unsigned long long v1:7; bool v2; float v3; };
struct BFu7ll_B_I { unsigned long long v1:7; bool v2; int v3; };
struct BFu7ll_B_Ip { unsigned long long v1:7; bool v2; int * v3; };
struct BFu7ll_B_L { unsigned long long v1:7; bool v2; long long v3; };
struct BFu7ll_B_S { unsigned long long v1:7; bool v2; short v3; };
struct BFu7ll_B_Uc { unsigned long long v1:7; bool v2; unsigned char v3; };
struct BFu7ll_B_Ui { unsigned long long v1:7; bool v2; unsigned int v3; };
struct BFu7ll_B_Ul { unsigned long long v1:7; bool v2; unsigned long long v3; };
struct BFu7ll_B_Us { unsigned long long v1:7; bool v2; unsigned short v3; };
struct BFu7ll_B_Vp { unsigned long long v1:7; bool v2; void * v3; };
struct BFu7ll_BFu15i_B { unsigned long long v1:7; unsigned int v2:15; bool v3; };
struct BFu7ll_BFu15ll_B { unsigned long long v1:7; unsigned long long v2:15; bool v3; };
struct BFu7ll_BFu15s_B { unsigned long long v1:7; unsigned short v2:15; bool v3; };
struct BFu7ll_BFu16i_B { unsigned long long v1:7; unsigned int v2:16; bool v3; };
struct BFu7ll_BFu16ll_B { unsigned long long v1:7; unsigned long long v2:16; bool v3; };
struct BFu7ll_BFu16s_B { unsigned long long v1:7; unsigned short v2:16; bool v3; };
struct BFu7ll_BFu17i_B { unsigned long long v1:7; unsigned int v2:17; bool v3; };
struct BFu7ll_BFu17ll_B { unsigned long long v1:7; unsigned long long v2:17; bool v3; };
struct BFu7ll_BFu1c_B { unsigned long long v1:7; unsigned char v2:1; bool v3; };
struct BFu7ll_BFu1i_B { unsigned long long v1:7; unsigned int v2:1; bool v3; };
struct BFu7ll_BFu1ll_B { unsigned long long v1:7; unsigned long long v2:1; bool v3; };
struct BFu7ll_BFu1s_B { unsigned long long v1:7; unsigned short v2:1; bool v3; };
struct BFu7ll_BFu31i_B { unsigned long long v1:7; unsigned int v2:31; bool v3; };
struct BFu7ll_BFu31ll_B { unsigned long long v1:7; unsigned long long v2:31; bool v3; };
struct BFu7ll_BFu32i_B { unsigned long long v1:7; unsigned int v2:32; bool v3; };
struct BFu7ll_BFu32ll_B { unsigned long long v1:7; unsigned long long v2:32; bool v3; };
struct BFu7ll_BFu33_B { unsigned long long v1:7; unsigned long long v2:33; bool v3; };
struct BFu7ll_BFu7c_B { unsigned long long v1:7; unsigned char v2:7; bool v3; };
struct BFu7ll_BFu7i_B { unsigned long long v1:7; unsigned int v2:7; bool v3; };
struct BFu7ll_BFu7ll_B { unsigned long long v1:7; unsigned long long v2:7; bool v3; };
struct BFu7ll_BFu7s_B { unsigned long long v1:7; unsigned short v2:7; bool v3; };
struct BFu7ll_BFu8c_B { unsigned long long v1:7; unsigned char v2:8; bool v3; };
struct BFu7ll_BFu8i_B { unsigned long long v1:7; unsigned int v2:8; bool v3; };
struct BFu7ll_BFu8ll_B { unsigned long long v1:7; unsigned long long v2:8; bool v3; };
struct BFu7ll_BFu8s_B { unsigned long long v1:7; unsigned short v2:8; bool v3; };
struct BFu7ll_BFu9i_B { unsigned long long v1:7; unsigned int v2:9; bool v3; };
struct BFu7ll_BFu9ll_B { unsigned long long v1:7; unsigned long long v2:9; bool v3; };
struct BFu7ll_BFu9s_B { unsigned long long v1:7; unsigned short v2:9; bool v3; };
struct BFu7ll_C_B { unsigned long long v1:7; char v2; bool v3; };
struct BFu7ll_D_B { unsigned long long v1:7; double v2; bool v3; };
struct BFu7ll_F_B { unsigned long long v1:7; float v2; bool v3; };
struct BFu7ll_I_B { unsigned long long v1:7; int v2; bool v3; };
struct BFu7ll_Ip_B { unsigned long long v1:7; int * v2; bool v3; };
struct BFu7ll_L_B { unsigned long long v1:7; long long v2; bool v3; };
struct BFu7ll_S_B { unsigned long long v1:7; short v2; bool v3; };
struct BFu7ll_Uc_B { unsigned long long v1:7; unsigned char v2; bool v3; };
struct BFu7ll_Ui_B { unsigned long long v1:7; unsigned int v2; bool v3; };
struct BFu7ll_Ul_B { unsigned long long v1:7; unsigned long long v2; bool v3; };
struct BFu7ll_Us_B { unsigned long long v1:7; unsigned short v2; bool v3; };
struct BFu7ll_Vp_B { unsigned long long v1:7; void * v2; bool v3; };
struct BFu7s_B { unsigned short v1:7; bool v2; };
struct BFu7s_B_B { unsigned short v1:7; bool v2; bool v3; };
struct BFu7s_B_BFu15i { unsigned short v1:7; bool v2; unsigned int v3:15; };
struct BFu7s_B_BFu15ll { unsigned short v1:7; bool v2; unsigned long long v3:15; };
struct BFu7s_B_BFu15s { unsigned short v1:7; bool v2; unsigned short v3:15; };
struct BFu7s_B_BFu16i { unsigned short v1:7; bool v2; unsigned int v3:16; };
struct BFu7s_B_BFu16ll { unsigned short v1:7; bool v2; unsigned long long v3:16; };
struct BFu7s_B_BFu16s { unsigned short v1:7; bool v2; unsigned short v3:16; };
struct BFu7s_B_BFu17i { unsigned short v1:7; bool v2; unsigned int v3:17; };
struct BFu7s_B_BFu17ll { unsigned short v1:7; bool v2; unsigned long long v3:17; };
struct BFu7s_B_BFu1c { unsigned short v1:7; bool v2; unsigned char v3:1; };
struct BFu7s_B_BFu1i { unsigned short v1:7; bool v2; unsigned int v3:1; };
struct BFu7s_B_BFu1ll { unsigned short v1:7; bool v2; unsigned long long v3:1; };
struct BFu7s_B_BFu1s { unsigned short v1:7; bool v2; unsigned short v3:1; };
struct BFu7s_B_BFu31i { unsigned short v1:7; bool v2; unsigned int v3:31; };
struct BFu7s_B_BFu31ll { unsigned short v1:7; bool v2; unsigned long long v3:31; };
struct BFu7s_B_BFu32i { unsigned short v1:7; bool v2; unsigned int v3:32; };
struct BFu7s_B_BFu32ll { unsigned short v1:7; bool v2; unsigned long long v3:32; };
struct BFu7s_B_BFu33 { unsigned short v1:7; bool v2; unsigned long long v3:33; };
struct BFu7s_B_BFu7c { unsigned short v1:7; bool v2; unsigned char v3:7; };
struct BFu7s_B_BFu7i { unsigned short v1:7; bool v2; unsigned int v3:7; };
struct BFu7s_B_BFu7ll { unsigned short v1:7; bool v2; unsigned long long v3:7; };
struct BFu7s_B_BFu7s { unsigned short v1:7; bool v2; unsigned short v3:7; };
struct BFu7s_B_BFu8c { unsigned short v1:7; bool v2; unsigned char v3:8; };
struct BFu7s_B_BFu8i { unsigned short v1:7; bool v2; unsigned int v3:8; };
struct BFu7s_B_BFu8ll { unsigned short v1:7; bool v2; unsigned long long v3:8; };
struct BFu7s_B_BFu8s { unsigned short v1:7; bool v2; unsigned short v3:8; };
struct BFu7s_B_BFu9i { unsigned short v1:7; bool v2; unsigned int v3:9; };
struct BFu7s_B_BFu9ll { unsigned short v1:7; bool v2; unsigned long long v3:9; };
struct BFu7s_B_BFu9s { unsigned short v1:7; bool v2; unsigned short v3:9; };
struct BFu7s_B_C { unsigned short v1:7; bool v2; char v3; };
struct BFu7s_B_D { unsigned short v1:7; bool v2; double v3; };
struct BFu7s_B_F { unsigned short v1:7; bool v2; float v3; };
struct BFu7s_B_I { unsigned short v1:7; bool v2; int v3; };
struct BFu7s_B_Ip { unsigned short v1:7; bool v2; int * v3; };
struct BFu7s_B_L { unsigned short v1:7; bool v2; long long v3; };
struct BFu7s_B_S { unsigned short v1:7; bool v2; short v3; };
struct BFu7s_B_Uc { unsigned short v1:7; bool v2; unsigned char v3; };
struct BFu7s_B_Ui { unsigned short v1:7; bool v2; unsigned int v3; };
struct BFu7s_B_Ul { unsigned short v1:7; bool v2; unsigned long long v3; };
struct BFu7s_B_Us { unsigned short v1:7; bool v2; unsigned short v3; };
struct BFu7s_B_Vp { unsigned short v1:7; bool v2; void * v3; };
struct BFu7s_BFu15i_B { unsigned short v1:7; unsigned int v2:15; bool v3; };
struct BFu7s_BFu15ll_B { unsigned short v1:7; unsigned long long v2:15; bool v3; };
struct BFu7s_BFu15s_B { unsigned short v1:7; unsigned short v2:15; bool v3; };
struct BFu7s_BFu16i_B { unsigned short v1:7; unsigned int v2:16; bool v3; };
struct BFu7s_BFu16ll_B { unsigned short v1:7; unsigned long long v2:16; bool v3; };
struct BFu7s_BFu16s_B { unsigned short v1:7; unsigned short v2:16; bool v3; };
struct BFu7s_BFu17i_B { unsigned short v1:7; unsigned int v2:17; bool v3; };
struct BFu7s_BFu17ll_B { unsigned short v1:7; unsigned long long v2:17; bool v3; };
struct BFu7s_BFu1c_B { unsigned short v1:7; unsigned char v2:1; bool v3; };
struct BFu7s_BFu1i_B { unsigned short v1:7; unsigned int v2:1; bool v3; };
struct BFu7s_BFu1ll_B { unsigned short v1:7; unsigned long long v2:1; bool v3; };
struct BFu7s_BFu1s_B { unsigned short v1:7; unsigned short v2:1; bool v3; };
struct BFu7s_BFu31i_B { unsigned short v1:7; unsigned int v2:31; bool v3; };
struct BFu7s_BFu31ll_B { unsigned short v1:7; unsigned long long v2:31; bool v3; };
struct BFu7s_BFu32i_B { unsigned short v1:7; unsigned int v2:32; bool v3; };
struct BFu7s_BFu32ll_B { unsigned short v1:7; unsigned long long v2:32; bool v3; };
struct BFu7s_BFu33_B { unsigned short v1:7; unsigned long long v2:33; bool v3; };
struct BFu7s_BFu7c_B { unsigned short v1:7; unsigned char v2:7; bool v3; };
struct BFu7s_BFu7i_B { unsigned short v1:7; unsigned int v2:7; bool v3; };
struct BFu7s_BFu7ll_B { unsigned short v1:7; unsigned long long v2:7; bool v3; };
struct BFu7s_BFu7s_B { unsigned short v1:7; unsigned short v2:7; bool v3; };
struct BFu7s_BFu8c_B { unsigned short v1:7; unsigned char v2:8; bool v3; };
struct BFu7s_BFu8i_B { unsigned short v1:7; unsigned int v2:8; bool v3; };
struct BFu7s_BFu8ll_B { unsigned short v1:7; unsigned long long v2:8; bool v3; };
struct BFu7s_BFu8s_B { unsigned short v1:7; unsigned short v2:8; bool v3; };
struct BFu7s_BFu9i_B { unsigned short v1:7; unsigned int v2:9; bool v3; };
struct BFu7s_BFu9ll_B { unsigned short v1:7; unsigned long long v2:9; bool v3; };
struct BFu7s_BFu9s_B { unsigned short v1:7; unsigned short v2:9; bool v3; };
struct BFu7s_C_B { unsigned short v1:7; char v2; bool v3; };
struct BFu7s_D_B { unsigned short v1:7; double v2; bool v3; };
struct BFu7s_F_B { unsigned short v1:7; float v2; bool v3; };
struct BFu7s_I_B { unsigned short v1:7; int v2; bool v3; };
struct BFu7s_Ip_B { unsigned short v1:7; int * v2; bool v3; };
struct BFu7s_L_B { unsigned short v1:7; long long v2; bool v3; };
struct BFu7s_S_B { unsigned short v1:7; short v2; bool v3; };
struct BFu7s_Uc_B { unsigned short v1:7; unsigned char v2; bool v3; };
struct BFu7s_Ui_B { unsigned short v1:7; unsigned int v2; bool v3; };
struct BFu7s_Ul_B { unsigned short v1:7; unsigned long long v2; bool v3; };
struct BFu7s_Us_B { unsigned short v1:7; unsigned short v2; bool v3; };
struct BFu7s_Vp_B { unsigned short v1:7; void * v2; bool v3; };
struct BFu8c_B { unsigned char v1:8; bool v2; };
struct BFu8c_B_B { unsigned char v1:8; bool v2; bool v3; };
struct BFu8c_B_BFu15i { unsigned char v1:8; bool v2; unsigned int v3:15; };
struct BFu8c_B_BFu15ll { unsigned char v1:8; bool v2; unsigned long long v3:15; };
struct BFu8c_B_BFu15s { unsigned char v1:8; bool v2; unsigned short v3:15; };
struct BFu8c_B_BFu16i { unsigned char v1:8; bool v2; unsigned int v3:16; };
struct BFu8c_B_BFu16ll { unsigned char v1:8; bool v2; unsigned long long v3:16; };
struct BFu8c_B_BFu16s { unsigned char v1:8; bool v2; unsigned short v3:16; };
struct BFu8c_B_BFu17i { unsigned char v1:8; bool v2; unsigned int v3:17; };
struct BFu8c_B_BFu17ll { unsigned char v1:8; bool v2; unsigned long long v3:17; };
struct BFu8c_B_BFu1c { unsigned char v1:8; bool v2; unsigned char v3:1; };
struct BFu8c_B_BFu1i { unsigned char v1:8; bool v2; unsigned int v3:1; };
struct BFu8c_B_BFu1ll { unsigned char v1:8; bool v2; unsigned long long v3:1; };
struct BFu8c_B_BFu1s { unsigned char v1:8; bool v2; unsigned short v3:1; };
struct BFu8c_B_BFu31i { unsigned char v1:8; bool v2; unsigned int v3:31; };
struct BFu8c_B_BFu31ll { unsigned char v1:8; bool v2; unsigned long long v3:31; };
struct BFu8c_B_BFu32i { unsigned char v1:8; bool v2; unsigned int v3:32; };
struct BFu8c_B_BFu32ll { unsigned char v1:8; bool v2; unsigned long long v3:32; };
struct BFu8c_B_BFu33 { unsigned char v1:8; bool v2; unsigned long long v3:33; };
struct BFu8c_B_BFu7c { unsigned char v1:8; bool v2; unsigned char v3:7; };
struct BFu8c_B_BFu7i { unsigned char v1:8; bool v2; unsigned int v3:7; };
struct BFu8c_B_BFu7ll { unsigned char v1:8; bool v2; unsigned long long v3:7; };
struct BFu8c_B_BFu7s { unsigned char v1:8; bool v2; unsigned short v3:7; };
struct BFu8c_B_BFu8c { unsigned char v1:8; bool v2; unsigned char v3:8; };
struct BFu8c_B_BFu8i { unsigned char v1:8; bool v2; unsigned int v3:8; };
struct BFu8c_B_BFu8ll { unsigned char v1:8; bool v2; unsigned long long v3:8; };
struct BFu8c_B_BFu8s { unsigned char v1:8; bool v2; unsigned short v3:8; };
struct BFu8c_B_BFu9i { unsigned char v1:8; bool v2; unsigned int v3:9; };
struct BFu8c_B_BFu9ll { unsigned char v1:8; bool v2; unsigned long long v3:9; };
struct BFu8c_B_BFu9s { unsigned char v1:8; bool v2; unsigned short v3:9; };
struct BFu8c_B_C { unsigned char v1:8; bool v2; char v3; };
struct BFu8c_B_D { unsigned char v1:8; bool v2; double v3; };
struct BFu8c_B_F { unsigned char v1:8; bool v2; float v3; };
struct BFu8c_B_I { unsigned char v1:8; bool v2; int v3; };
struct BFu8c_B_Ip { unsigned char v1:8; bool v2; int * v3; };
struct BFu8c_B_L { unsigned char v1:8; bool v2; long long v3; };
struct BFu8c_B_S { unsigned char v1:8; bool v2; short v3; };
struct BFu8c_B_Uc { unsigned char v1:8; bool v2; unsigned char v3; };
struct BFu8c_B_Ui { unsigned char v1:8; bool v2; unsigned int v3; };
struct BFu8c_B_Ul { unsigned char v1:8; bool v2; unsigned long long v3; };
struct BFu8c_B_Us { unsigned char v1:8; bool v2; unsigned short v3; };
struct BFu8c_B_Vp { unsigned char v1:8; bool v2; void * v3; };
struct BFu8c_BFu15i_B { unsigned char v1:8; unsigned int v2:15; bool v3; };
struct BFu8c_BFu15ll_B { unsigned char v1:8; unsigned long long v2:15; bool v3; };
struct BFu8c_BFu15s_B { unsigned char v1:8; unsigned short v2:15; bool v3; };
struct BFu8c_BFu16i_B { unsigned char v1:8; unsigned int v2:16; bool v3; };
struct BFu8c_BFu16ll_B { unsigned char v1:8; unsigned long long v2:16; bool v3; };
struct BFu8c_BFu16s_B { unsigned char v1:8; unsigned short v2:16; bool v3; };
struct BFu8c_BFu17i_B { unsigned char v1:8; unsigned int v2:17; bool v3; };
struct BFu8c_BFu17ll_B { unsigned char v1:8; unsigned long long v2:17; bool v3; };
struct BFu8c_BFu1c_B { unsigned char v1:8; unsigned char v2:1; bool v3; };
struct BFu8c_BFu1i_B { unsigned char v1:8; unsigned int v2:1; bool v3; };
struct BFu8c_BFu1ll_B { unsigned char v1:8; unsigned long long v2:1; bool v3; };
struct BFu8c_BFu1s_B { unsigned char v1:8; unsigned short v2:1; bool v3; };
struct BFu8c_BFu31i_B { unsigned char v1:8; unsigned int v2:31; bool v3; };
struct BFu8c_BFu31ll_B { unsigned char v1:8; unsigned long long v2:31; bool v3; };
struct BFu8c_BFu32i_B { unsigned char v1:8; unsigned int v2:32; bool v3; };
struct BFu8c_BFu32ll_B { unsigned char v1:8; unsigned long long v2:32; bool v3; };
struct BFu8c_BFu33_B { unsigned char v1:8; unsigned long long v2:33; bool v3; };
struct BFu8c_BFu7c_B { unsigned char v1:8; unsigned char v2:7; bool v3; };
struct BFu8c_BFu7i_B { unsigned char v1:8; unsigned int v2:7; bool v3; };
struct BFu8c_BFu7ll_B { unsigned char v1:8; unsigned long long v2:7; bool v3; };
struct BFu8c_BFu7s_B { unsigned char v1:8; unsigned short v2:7; bool v3; };
struct BFu8c_BFu8c_B { unsigned char v1:8; unsigned char v2:8; bool v3; };
struct BFu8c_BFu8i_B { unsigned char v1:8; unsigned int v2:8; bool v3; };
struct BFu8c_BFu8ll_B { unsigned char v1:8; unsigned long long v2:8; bool v3; };
struct BFu8c_BFu8s_B { unsigned char v1:8; unsigned short v2:8; bool v3; };
struct BFu8c_BFu9i_B { unsigned char v1:8; unsigned int v2:9; bool v3; };
struct BFu8c_BFu9ll_B { unsigned char v1:8; unsigned long long v2:9; bool v3; };
struct BFu8c_BFu9s_B { unsigned char v1:8; unsigned short v2:9; bool v3; };
struct BFu8c_C_B { unsigned char v1:8; char v2; bool v3; };
struct BFu8c_D_B { unsigned char v1:8; double v2; bool v3; };
struct BFu8c_F_B { unsigned char v1:8; float v2; bool v3; };
struct BFu8c_I_B { unsigned char v1:8; int v2; bool v3; };
struct BFu8c_Ip_B { unsigned char v1:8; int * v2; bool v3; };
struct BFu8c_L_B { unsigned char v1:8; long long v2; bool v3; };
struct BFu8c_S_B { unsigned char v1:8; short v2; bool v3; };
struct BFu8c_Uc_B { unsigned char v1:8; unsigned char v2; bool v3; };
struct BFu8c_Ui_B { unsigned char v1:8; unsigned int v2; bool v3; };
struct BFu8c_Ul_B { unsigned char v1:8; unsigned long long v2; bool v3; };
struct BFu8c_Us_B { unsigned char v1:8; unsigned short v2; bool v3; };
struct BFu8c_Vp_B { unsigned char v1:8; void * v2; bool v3; };
struct BFu8i_B { unsigned int v1:8; bool v2; };
struct BFu8i_B_B { unsigned int v1:8; bool v2; bool v3; };
struct BFu8i_B_BFu15i { unsigned int v1:8; bool v2; unsigned int v3:15; };
struct BFu8i_B_BFu15ll { unsigned int v1:8; bool v2; unsigned long long v3:15; };
struct BFu8i_B_BFu15s { unsigned int v1:8; bool v2; unsigned short v3:15; };
struct BFu8i_B_BFu16i { unsigned int v1:8; bool v2; unsigned int v3:16; };
struct BFu8i_B_BFu16ll { unsigned int v1:8; bool v2; unsigned long long v3:16; };
struct BFu8i_B_BFu16s { unsigned int v1:8; bool v2; unsigned short v3:16; };
struct BFu8i_B_BFu17i { unsigned int v1:8; bool v2; unsigned int v3:17; };
struct BFu8i_B_BFu17ll { unsigned int v1:8; bool v2; unsigned long long v3:17; };
struct BFu8i_B_BFu1c { unsigned int v1:8; bool v2; unsigned char v3:1; };
struct BFu8i_B_BFu1i { unsigned int v1:8; bool v2; unsigned int v3:1; };
struct BFu8i_B_BFu1ll { unsigned int v1:8; bool v2; unsigned long long v3:1; };
struct BFu8i_B_BFu1s { unsigned int v1:8; bool v2; unsigned short v3:1; };
struct BFu8i_B_BFu31i { unsigned int v1:8; bool v2; unsigned int v3:31; };
struct BFu8i_B_BFu31ll { unsigned int v1:8; bool v2; unsigned long long v3:31; };
struct BFu8i_B_BFu32i { unsigned int v1:8; bool v2; unsigned int v3:32; };
struct BFu8i_B_BFu32ll { unsigned int v1:8; bool v2; unsigned long long v3:32; };
struct BFu8i_B_BFu33 { unsigned int v1:8; bool v2; unsigned long long v3:33; };
struct BFu8i_B_BFu7c { unsigned int v1:8; bool v2; unsigned char v3:7; };
struct BFu8i_B_BFu7i { unsigned int v1:8; bool v2; unsigned int v3:7; };
struct BFu8i_B_BFu7ll { unsigned int v1:8; bool v2; unsigned long long v3:7; };
struct BFu8i_B_BFu7s { unsigned int v1:8; bool v2; unsigned short v3:7; };
struct BFu8i_B_BFu8c { unsigned int v1:8; bool v2; unsigned char v3:8; };
struct BFu8i_B_BFu8i { unsigned int v1:8; bool v2; unsigned int v3:8; };
struct BFu8i_B_BFu8ll { unsigned int v1:8; bool v2; unsigned long long v3:8; };
struct BFu8i_B_BFu8s { unsigned int v1:8; bool v2; unsigned short v3:8; };
struct BFu8i_B_BFu9i { unsigned int v1:8; bool v2; unsigned int v3:9; };
struct BFu8i_B_BFu9ll { unsigned int v1:8; bool v2; unsigned long long v3:9; };
struct BFu8i_B_BFu9s { unsigned int v1:8; bool v2; unsigned short v3:9; };
struct BFu8i_B_C { unsigned int v1:8; bool v2; char v3; };
struct BFu8i_B_D { unsigned int v1:8; bool v2; double v3; };
struct BFu8i_B_F { unsigned int v1:8; bool v2; float v3; };
struct BFu8i_B_I { unsigned int v1:8; bool v2; int v3; };
struct BFu8i_B_Ip { unsigned int v1:8; bool v2; int * v3; };
struct BFu8i_B_L { unsigned int v1:8; bool v2; long long v3; };
struct BFu8i_B_S { unsigned int v1:8; bool v2; short v3; };
struct BFu8i_B_Uc { unsigned int v1:8; bool v2; unsigned char v3; };
struct BFu8i_B_Ui { unsigned int v1:8; bool v2; unsigned int v3; };
struct BFu8i_B_Ul { unsigned int v1:8; bool v2; unsigned long long v3; };
struct BFu8i_B_Us { unsigned int v1:8; bool v2; unsigned short v3; };
struct BFu8i_B_Vp { unsigned int v1:8; bool v2; void * v3; };
struct BFu8i_BFu15i_B { unsigned int v1:8; unsigned int v2:15; bool v3; };
struct BFu8i_BFu15ll_B { unsigned int v1:8; unsigned long long v2:15; bool v3; };
struct BFu8i_BFu15s_B { unsigned int v1:8; unsigned short v2:15; bool v3; };
struct BFu8i_BFu16i_B { unsigned int v1:8; unsigned int v2:16; bool v3; };
struct BFu8i_BFu16ll_B { unsigned int v1:8; unsigned long long v2:16; bool v3; };
struct BFu8i_BFu16s_B { unsigned int v1:8; unsigned short v2:16; bool v3; };
struct BFu8i_BFu17i_B { unsigned int v1:8; unsigned int v2:17; bool v3; };
struct BFu8i_BFu17ll_B { unsigned int v1:8; unsigned long long v2:17; bool v3; };
struct BFu8i_BFu1c_B { unsigned int v1:8; unsigned char v2:1; bool v3; };
struct BFu8i_BFu1i_B { unsigned int v1:8; unsigned int v2:1; bool v3; };
struct BFu8i_BFu1ll_B { unsigned int v1:8; unsigned long long v2:1; bool v3; };
struct BFu8i_BFu1s_B { unsigned int v1:8; unsigned short v2:1; bool v3; };
struct BFu8i_BFu31i_B { unsigned int v1:8; unsigned int v2:31; bool v3; };
struct BFu8i_BFu31ll_B { unsigned int v1:8; unsigned long long v2:31; bool v3; };
struct BFu8i_BFu32i_B { unsigned int v1:8; unsigned int v2:32; bool v3; };
struct BFu8i_BFu32ll_B { unsigned int v1:8; unsigned long long v2:32; bool v3; };
struct BFu8i_BFu33_B { unsigned int v1:8; unsigned long long v2:33; bool v3; };
struct BFu8i_BFu7c_B { unsigned int v1:8; unsigned char v2:7; bool v3; };
struct BFu8i_BFu7i_B { unsigned int v1:8; unsigned int v2:7; bool v3; };
struct BFu8i_BFu7ll_B { unsigned int v1:8; unsigned long long v2:7; bool v3; };
struct BFu8i_BFu7s_B { unsigned int v1:8; unsigned short v2:7; bool v3; };
struct BFu8i_BFu8c_B { unsigned int v1:8; unsigned char v2:8; bool v3; };
struct BFu8i_BFu8i_B { unsigned int v1:8; unsigned int v2:8; bool v3; };
struct BFu8i_BFu8ll_B { unsigned int v1:8; unsigned long long v2:8; bool v3; };
struct BFu8i_BFu8s_B { unsigned int v1:8; unsigned short v2:8; bool v3; };
struct BFu8i_BFu9i_B { unsigned int v1:8; unsigned int v2:9; bool v3; };
struct BFu8i_BFu9ll_B { unsigned int v1:8; unsigned long long v2:9; bool v3; };
struct BFu8i_BFu9s_B { unsigned int v1:8; unsigned short v2:9; bool v3; };
struct BFu8i_C_B { unsigned int v1:8; char v2; bool v3; };
struct BFu8i_D_B { unsigned int v1:8; double v2; bool v3; };
struct BFu8i_F_B { unsigned int v1:8; float v2; bool v3; };
struct BFu8i_I_B { unsigned int v1:8; int v2; bool v3; };
struct BFu8i_Ip_B { unsigned int v1:8; int * v2; bool v3; };
struct BFu8i_L_B { unsigned int v1:8; long long v2; bool v3; };
struct BFu8i_S_B { unsigned int v1:8; short v2; bool v3; };
struct BFu8i_Uc_B { unsigned int v1:8; unsigned char v2; bool v3; };
struct BFu8i_Ui_B { unsigned int v1:8; unsigned int v2; bool v3; };
struct BFu8i_Ul_B { unsigned int v1:8; unsigned long long v2; bool v3; };
struct BFu8i_Us_B { unsigned int v1:8; unsigned short v2; bool v3; };
struct BFu8i_Vp_B { unsigned int v1:8; void * v2; bool v3; };
struct BFu8ll_B { unsigned long long v1:8; bool v2; };
struct BFu8ll_B_B { unsigned long long v1:8; bool v2; bool v3; };
struct BFu8ll_B_BFu15i { unsigned long long v1:8; bool v2; unsigned int v3:15; };
struct BFu8ll_B_BFu15ll { unsigned long long v1:8; bool v2; unsigned long long v3:15; };
struct BFu8ll_B_BFu15s { unsigned long long v1:8; bool v2; unsigned short v3:15; };
struct BFu8ll_B_BFu16i { unsigned long long v1:8; bool v2; unsigned int v3:16; };
struct BFu8ll_B_BFu16ll { unsigned long long v1:8; bool v2; unsigned long long v3:16; };
struct BFu8ll_B_BFu16s { unsigned long long v1:8; bool v2; unsigned short v3:16; };
struct BFu8ll_B_BFu17i { unsigned long long v1:8; bool v2; unsigned int v3:17; };
struct BFu8ll_B_BFu17ll { unsigned long long v1:8; bool v2; unsigned long long v3:17; };
struct BFu8ll_B_BFu1c { unsigned long long v1:8; bool v2; unsigned char v3:1; };
struct BFu8ll_B_BFu1i { unsigned long long v1:8; bool v2; unsigned int v3:1; };
struct BFu8ll_B_BFu1ll { unsigned long long v1:8; bool v2; unsigned long long v3:1; };
struct BFu8ll_B_BFu1s { unsigned long long v1:8; bool v2; unsigned short v3:1; };
struct BFu8ll_B_BFu31i { unsigned long long v1:8; bool v2; unsigned int v3:31; };
struct BFu8ll_B_BFu31ll { unsigned long long v1:8; bool v2; unsigned long long v3:31; };
struct BFu8ll_B_BFu32i { unsigned long long v1:8; bool v2; unsigned int v3:32; };
struct BFu8ll_B_BFu32ll { unsigned long long v1:8; bool v2; unsigned long long v3:32; };
struct BFu8ll_B_BFu33 { unsigned long long v1:8; bool v2; unsigned long long v3:33; };
struct BFu8ll_B_BFu7c { unsigned long long v1:8; bool v2; unsigned char v3:7; };
struct BFu8ll_B_BFu7i { unsigned long long v1:8; bool v2; unsigned int v3:7; };
struct BFu8ll_B_BFu7ll { unsigned long long v1:8; bool v2; unsigned long long v3:7; };
struct BFu8ll_B_BFu7s { unsigned long long v1:8; bool v2; unsigned short v3:7; };
struct BFu8ll_B_BFu8c { unsigned long long v1:8; bool v2; unsigned char v3:8; };
struct BFu8ll_B_BFu8i { unsigned long long v1:8; bool v2; unsigned int v3:8; };
struct BFu8ll_B_BFu8ll { unsigned long long v1:8; bool v2; unsigned long long v3:8; };
struct BFu8ll_B_BFu8s { unsigned long long v1:8; bool v2; unsigned short v3:8; };
struct BFu8ll_B_BFu9i { unsigned long long v1:8; bool v2; unsigned int v3:9; };
struct BFu8ll_B_BFu9ll { unsigned long long v1:8; bool v2; unsigned long long v3:9; };
struct BFu8ll_B_BFu9s { unsigned long long v1:8; bool v2; unsigned short v3:9; };
struct BFu8ll_B_C { unsigned long long v1:8; bool v2; char v3; };
struct BFu8ll_B_D { unsigned long long v1:8; bool v2; double v3; };
struct BFu8ll_B_F { unsigned long long v1:8; bool v2; float v3; };
struct BFu8ll_B_I { unsigned long long v1:8; bool v2; int v3; };
struct BFu8ll_B_Ip { unsigned long long v1:8; bool v2; int * v3; };
struct BFu8ll_B_L { unsigned long long v1:8; bool v2; long long v3; };
struct BFu8ll_B_S { unsigned long long v1:8; bool v2; short v3; };
struct BFu8ll_B_Uc { unsigned long long v1:8; bool v2; unsigned char v3; };
struct BFu8ll_B_Ui { unsigned long long v1:8; bool v2; unsigned int v3; };
struct BFu8ll_B_Ul { unsigned long long v1:8; bool v2; unsigned long long v3; };
struct BFu8ll_B_Us { unsigned long long v1:8; bool v2; unsigned short v3; };
struct BFu8ll_B_Vp { unsigned long long v1:8; bool v2; void * v3; };
struct BFu8ll_BFu15i_B { unsigned long long v1:8; unsigned int v2:15; bool v3; };
struct BFu8ll_BFu15ll_B { unsigned long long v1:8; unsigned long long v2:15; bool v3; };
struct BFu8ll_BFu15s_B { unsigned long long v1:8; unsigned short v2:15; bool v3; };
struct BFu8ll_BFu16i_B { unsigned long long v1:8; unsigned int v2:16; bool v3; };
struct BFu8ll_BFu16ll_B { unsigned long long v1:8; unsigned long long v2:16; bool v3; };
struct BFu8ll_BFu16s_B { unsigned long long v1:8; unsigned short v2:16; bool v3; };
struct BFu8ll_BFu17i_B { unsigned long long v1:8; unsigned int v2:17; bool v3; };
struct BFu8ll_BFu17ll_B { unsigned long long v1:8; unsigned long long v2:17; bool v3; };
struct BFu8ll_BFu1c_B { unsigned long long v1:8; unsigned char v2:1; bool v3; };
struct BFu8ll_BFu1i_B { unsigned long long v1:8; unsigned int v2:1; bool v3; };
struct BFu8ll_BFu1ll_B { unsigned long long v1:8; unsigned long long v2:1; bool v3; };
struct BFu8ll_BFu1s_B { unsigned long long v1:8; unsigned short v2:1; bool v3; };
struct BFu8ll_BFu31i_B { unsigned long long v1:8; unsigned int v2:31; bool v3; };
struct BFu8ll_BFu31ll_B { unsigned long long v1:8; unsigned long long v2:31; bool v3; };
struct BFu8ll_BFu32i_B { unsigned long long v1:8; unsigned int v2:32; bool v3; };
struct BFu8ll_BFu32ll_B { unsigned long long v1:8; unsigned long long v2:32; bool v3; };
struct BFu8ll_BFu33_B { unsigned long long v1:8; unsigned long long v2:33; bool v3; };
struct BFu8ll_BFu7c_B { unsigned long long v1:8; unsigned char v2:7; bool v3; };
struct BFu8ll_BFu7i_B { unsigned long long v1:8; unsigned int v2:7; bool v3; };
struct BFu8ll_BFu7ll_B { unsigned long long v1:8; unsigned long long v2:7; bool v3; };
struct BFu8ll_BFu7s_B { unsigned long long v1:8; unsigned short v2:7; bool v3; };
struct BFu8ll_BFu8c_B { unsigned long long v1:8; unsigned char v2:8; bool v3; };
struct BFu8ll_BFu8i_B { unsigned long long v1:8; unsigned int v2:8; bool v3; };
struct BFu8ll_BFu8ll_B { unsigned long long v1:8; unsigned long long v2:8; bool v3; };
struct BFu8ll_BFu8s_B { unsigned long long v1:8; unsigned short v2:8; bool v3; };
struct BFu8ll_BFu9i_B { unsigned long long v1:8; unsigned int v2:9; bool v3; };
struct BFu8ll_BFu9ll_B { unsigned long long v1:8; unsigned long long v2:9; bool v3; };
struct BFu8ll_BFu9s_B { unsigned long long v1:8; unsigned short v2:9; bool v3; };
struct BFu8ll_C_B { unsigned long long v1:8; char v2; bool v3; };
struct BFu8ll_D_B { unsigned long long v1:8; double v2; bool v3; };
struct BFu8ll_F_B { unsigned long long v1:8; float v2; bool v3; };
struct BFu8ll_I_B { unsigned long long v1:8; int v2; bool v3; };
struct BFu8ll_Ip_B { unsigned long long v1:8; int * v2; bool v3; };
struct BFu8ll_L_B { unsigned long long v1:8; long long v2; bool v3; };
struct BFu8ll_S_B { unsigned long long v1:8; short v2; bool v3; };
struct BFu8ll_Uc_B { unsigned long long v1:8; unsigned char v2; bool v3; };
struct BFu8ll_Ui_B { unsigned long long v1:8; unsigned int v2; bool v3; };
struct BFu8ll_Ul_B { unsigned long long v1:8; unsigned long long v2; bool v3; };
struct BFu8ll_Us_B { unsigned long long v1:8; unsigned short v2; bool v3; };
struct BFu8ll_Vp_B { unsigned long long v1:8; void * v2; bool v3; };
struct BFu8s_B { unsigned short v1:8; bool v2; };
struct BFu8s_B_B { unsigned short v1:8; bool v2; bool v3; };
struct BFu8s_B_BFu15i { unsigned short v1:8; bool v2; unsigned int v3:15; };
struct BFu8s_B_BFu15ll { unsigned short v1:8; bool v2; unsigned long long v3:15; };
struct BFu8s_B_BFu15s { unsigned short v1:8; bool v2; unsigned short v3:15; };
struct BFu8s_B_BFu16i { unsigned short v1:8; bool v2; unsigned int v3:16; };
struct BFu8s_B_BFu16ll { unsigned short v1:8; bool v2; unsigned long long v3:16; };
struct BFu8s_B_BFu16s { unsigned short v1:8; bool v2; unsigned short v3:16; };
struct BFu8s_B_BFu17i { unsigned short v1:8; bool v2; unsigned int v3:17; };
struct BFu8s_B_BFu17ll { unsigned short v1:8; bool v2; unsigned long long v3:17; };
struct BFu8s_B_BFu1c { unsigned short v1:8; bool v2; unsigned char v3:1; };
struct BFu8s_B_BFu1i { unsigned short v1:8; bool v2; unsigned int v3:1; };
struct BFu8s_B_BFu1ll { unsigned short v1:8; bool v2; unsigned long long v3:1; };
struct BFu8s_B_BFu1s { unsigned short v1:8; bool v2; unsigned short v3:1; };
struct BFu8s_B_BFu31i { unsigned short v1:8; bool v2; unsigned int v3:31; };
struct BFu8s_B_BFu31ll { unsigned short v1:8; bool v2; unsigned long long v3:31; };
struct BFu8s_B_BFu32i { unsigned short v1:8; bool v2; unsigned int v3:32; };
struct BFu8s_B_BFu32ll { unsigned short v1:8; bool v2; unsigned long long v3:32; };
struct BFu8s_B_BFu33 { unsigned short v1:8; bool v2; unsigned long long v3:33; };
struct BFu8s_B_BFu7c { unsigned short v1:8; bool v2; unsigned char v3:7; };
struct BFu8s_B_BFu7i { unsigned short v1:8; bool v2; unsigned int v3:7; };
struct BFu8s_B_BFu7ll { unsigned short v1:8; bool v2; unsigned long long v3:7; };
struct BFu8s_B_BFu7s { unsigned short v1:8; bool v2; unsigned short v3:7; };
struct BFu8s_B_BFu8c { unsigned short v1:8; bool v2; unsigned char v3:8; };
struct BFu8s_B_BFu8i { unsigned short v1:8; bool v2; unsigned int v3:8; };
struct BFu8s_B_BFu8ll { unsigned short v1:8; bool v2; unsigned long long v3:8; };
struct BFu8s_B_BFu8s { unsigned short v1:8; bool v2; unsigned short v3:8; };
struct BFu8s_B_BFu9i { unsigned short v1:8; bool v2; unsigned int v3:9; };
struct BFu8s_B_BFu9ll { unsigned short v1:8; bool v2; unsigned long long v3:9; };
struct BFu8s_B_BFu9s { unsigned short v1:8; bool v2; unsigned short v3:9; };
struct BFu8s_B_C { unsigned short v1:8; bool v2; char v3; };
struct BFu8s_B_D { unsigned short v1:8; bool v2; double v3; };
struct BFu8s_B_F { unsigned short v1:8; bool v2; float v3; };
struct BFu8s_B_I { unsigned short v1:8; bool v2; int v3; };
struct BFu8s_B_Ip { unsigned short v1:8; bool v2; int * v3; };
struct BFu8s_B_L { unsigned short v1:8; bool v2; long long v3; };
struct BFu8s_B_S { unsigned short v1:8; bool v2; short v3; };
struct BFu8s_B_Uc { unsigned short v1:8; bool v2; unsigned char v3; };
struct BFu8s_B_Ui { unsigned short v1:8; bool v2; unsigned int v3; };
struct BFu8s_B_Ul { unsigned short v1:8; bool v2; unsigned long long v3; };
struct BFu8s_B_Us { unsigned short v1:8; bool v2; unsigned short v3; };
struct BFu8s_B_Vp { unsigned short v1:8; bool v2; void * v3; };
struct BFu8s_BFu15i_B { unsigned short v1:8; unsigned int v2:15; bool v3; };
struct BFu8s_BFu15ll_B { unsigned short v1:8; unsigned long long v2:15; bool v3; };
struct BFu8s_BFu15s_B { unsigned short v1:8; unsigned short v2:15; bool v3; };
struct BFu8s_BFu16i_B { unsigned short v1:8; unsigned int v2:16; bool v3; };
struct BFu8s_BFu16ll_B { unsigned short v1:8; unsigned long long v2:16; bool v3; };
struct BFu8s_BFu16s_B { unsigned short v1:8; unsigned short v2:16; bool v3; };
struct BFu8s_BFu17i_B { unsigned short v1:8; unsigned int v2:17; bool v3; };
struct BFu8s_BFu17ll_B { unsigned short v1:8; unsigned long long v2:17; bool v3; };
struct BFu8s_BFu1c_B { unsigned short v1:8; unsigned char v2:1; bool v3; };
struct BFu8s_BFu1i_B { unsigned short v1:8; unsigned int v2:1; bool v3; };
struct BFu8s_BFu1ll_B { unsigned short v1:8; unsigned long long v2:1; bool v3; };
struct BFu8s_BFu1s_B { unsigned short v1:8; unsigned short v2:1; bool v3; };
struct BFu8s_BFu31i_B { unsigned short v1:8; unsigned int v2:31; bool v3; };
struct BFu8s_BFu31ll_B { unsigned short v1:8; unsigned long long v2:31; bool v3; };
struct BFu8s_BFu32i_B { unsigned short v1:8; unsigned int v2:32; bool v3; };
struct BFu8s_BFu32ll_B { unsigned short v1:8; unsigned long long v2:32; bool v3; };
struct BFu8s_BFu33_B { unsigned short v1:8; unsigned long long v2:33; bool v3; };
struct BFu8s_BFu7c_B { unsigned short v1:8; unsigned char v2:7; bool v3; };
struct BFu8s_BFu7i_B { unsigned short v1:8; unsigned int v2:7; bool v3; };
struct BFu8s_BFu7ll_B { unsigned short v1:8; unsigned long long v2:7; bool v3; };
struct BFu8s_BFu7s_B { unsigned short v1:8; unsigned short v2:7; bool v3; };
struct BFu8s_BFu8c_B { unsigned short v1:8; unsigned char v2:8; bool v3; };
struct BFu8s_BFu8i_B { unsigned short v1:8; unsigned int v2:8; bool v3; };
struct BFu8s_BFu8ll_B { unsigned short v1:8; unsigned long long v2:8; bool v3; };
struct BFu8s_BFu8s_B { unsigned short v1:8; unsigned short v2:8; bool v3; };
struct BFu8s_BFu9i_B { unsigned short v1:8; unsigned int v2:9; bool v3; };
struct BFu8s_BFu9ll_B { unsigned short v1:8; unsigned long long v2:9; bool v3; };
struct BFu8s_BFu9s_B { unsigned short v1:8; unsigned short v2:9; bool v3; };
struct BFu8s_C_B { unsigned short v1:8; char v2; bool v3; };
struct BFu8s_D_B { unsigned short v1:8; double v2; bool v3; };
struct BFu8s_F_B { unsigned short v1:8; float v2; bool v3; };
struct BFu8s_I_B { unsigned short v1:8; int v2; bool v3; };
struct BFu8s_Ip_B { unsigned short v1:8; int * v2; bool v3; };
struct BFu8s_L_B { unsigned short v1:8; long long v2; bool v3; };
struct BFu8s_S_B { unsigned short v1:8; short v2; bool v3; };
struct BFu8s_Uc_B { unsigned short v1:8; unsigned char v2; bool v3; };
struct BFu8s_Ui_B { unsigned short v1:8; unsigned int v2; bool v3; };
struct BFu8s_Ul_B { unsigned short v1:8; unsigned long long v2; bool v3; };
struct BFu8s_Us_B { unsigned short v1:8; unsigned short v2; bool v3; };
struct BFu8s_Vp_B { unsigned short v1:8; void * v2; bool v3; };
struct BFu9i_B { unsigned int v1:9; bool v2; };
struct BFu9i_B_B { unsigned int v1:9; bool v2; bool v3; };
struct BFu9i_B_BFu15i { unsigned int v1:9; bool v2; unsigned int v3:15; };
struct BFu9i_B_BFu15ll { unsigned int v1:9; bool v2; unsigned long long v3:15; };
struct BFu9i_B_BFu15s { unsigned int v1:9; bool v2; unsigned short v3:15; };
struct BFu9i_B_BFu16i { unsigned int v1:9; bool v2; unsigned int v3:16; };
struct BFu9i_B_BFu16ll { unsigned int v1:9; bool v2; unsigned long long v3:16; };
struct BFu9i_B_BFu16s { unsigned int v1:9; bool v2; unsigned short v3:16; };
struct BFu9i_B_BFu17i { unsigned int v1:9; bool v2; unsigned int v3:17; };
struct BFu9i_B_BFu17ll { unsigned int v1:9; bool v2; unsigned long long v3:17; };
struct BFu9i_B_BFu1c { unsigned int v1:9; bool v2; unsigned char v3:1; };
struct BFu9i_B_BFu1i { unsigned int v1:9; bool v2; unsigned int v3:1; };
struct BFu9i_B_BFu1ll { unsigned int v1:9; bool v2; unsigned long long v3:1; };
struct BFu9i_B_BFu1s { unsigned int v1:9; bool v2; unsigned short v3:1; };
struct BFu9i_B_BFu31i { unsigned int v1:9; bool v2; unsigned int v3:31; };
struct BFu9i_B_BFu31ll { unsigned int v1:9; bool v2; unsigned long long v3:31; };
struct BFu9i_B_BFu32i { unsigned int v1:9; bool v2; unsigned int v3:32; };
struct BFu9i_B_BFu32ll { unsigned int v1:9; bool v2; unsigned long long v3:32; };
struct BFu9i_B_BFu33 { unsigned int v1:9; bool v2; unsigned long long v3:33; };
struct BFu9i_B_BFu7c { unsigned int v1:9; bool v2; unsigned char v3:7; };
struct BFu9i_B_BFu7i { unsigned int v1:9; bool v2; unsigned int v3:7; };
struct BFu9i_B_BFu7ll { unsigned int v1:9; bool v2; unsigned long long v3:7; };
struct BFu9i_B_BFu7s { unsigned int v1:9; bool v2; unsigned short v3:7; };
struct BFu9i_B_BFu8c { unsigned int v1:9; bool v2; unsigned char v3:8; };
struct BFu9i_B_BFu8i { unsigned int v1:9; bool v2; unsigned int v3:8; };
struct BFu9i_B_BFu8ll { unsigned int v1:9; bool v2; unsigned long long v3:8; };
struct BFu9i_B_BFu8s { unsigned int v1:9; bool v2; unsigned short v3:8; };
struct BFu9i_B_BFu9i { unsigned int v1:9; bool v2; unsigned int v3:9; };
struct BFu9i_B_BFu9ll { unsigned int v1:9; bool v2; unsigned long long v3:9; };
struct BFu9i_B_BFu9s { unsigned int v1:9; bool v2; unsigned short v3:9; };
struct BFu9i_B_C { unsigned int v1:9; bool v2; char v3; };
struct BFu9i_B_D { unsigned int v1:9; bool v2; double v3; };
struct BFu9i_B_F { unsigned int v1:9; bool v2; float v3; };
struct BFu9i_B_I { unsigned int v1:9; bool v2; int v3; };
struct BFu9i_B_Ip { unsigned int v1:9; bool v2; int * v3; };
struct BFu9i_B_L { unsigned int v1:9; bool v2; long long v3; };
struct BFu9i_B_S { unsigned int v1:9; bool v2; short v3; };
struct BFu9i_B_Uc { unsigned int v1:9; bool v2; unsigned char v3; };
struct BFu9i_B_Ui { unsigned int v1:9; bool v2; unsigned int v3; };
struct BFu9i_B_Ul { unsigned int v1:9; bool v2; unsigned long long v3; };
struct BFu9i_B_Us { unsigned int v1:9; bool v2; unsigned short v3; };
struct BFu9i_B_Vp { unsigned int v1:9; bool v2; void * v3; };
struct BFu9i_BFu15i_B { unsigned int v1:9; unsigned int v2:15; bool v3; };
struct BFu9i_BFu15ll_B { unsigned int v1:9; unsigned long long v2:15; bool v3; };
struct BFu9i_BFu15s_B { unsigned int v1:9; unsigned short v2:15; bool v3; };
struct BFu9i_BFu16i_B { unsigned int v1:9; unsigned int v2:16; bool v3; };
struct BFu9i_BFu16ll_B { unsigned int v1:9; unsigned long long v2:16; bool v3; };
struct BFu9i_BFu16s_B { unsigned int v1:9; unsigned short v2:16; bool v3; };
struct BFu9i_BFu17i_B { unsigned int v1:9; unsigned int v2:17; bool v3; };
struct BFu9i_BFu17ll_B { unsigned int v1:9; unsigned long long v2:17; bool v3; };
struct BFu9i_BFu1c_B { unsigned int v1:9; unsigned char v2:1; bool v3; };
struct BFu9i_BFu1i_B { unsigned int v1:9; unsigned int v2:1; bool v3; };
struct BFu9i_BFu1ll_B { unsigned int v1:9; unsigned long long v2:1; bool v3; };
struct BFu9i_BFu1s_B { unsigned int v1:9; unsigned short v2:1; bool v3; };
struct BFu9i_BFu31i_B { unsigned int v1:9; unsigned int v2:31; bool v3; };
struct BFu9i_BFu31ll_B { unsigned int v1:9; unsigned long long v2:31; bool v3; };
struct BFu9i_BFu32i_B { unsigned int v1:9; unsigned int v2:32; bool v3; };
struct BFu9i_BFu32ll_B { unsigned int v1:9; unsigned long long v2:32; bool v3; };
struct BFu9i_BFu33_B { unsigned int v1:9; unsigned long long v2:33; bool v3; };
struct BFu9i_BFu7c_B { unsigned int v1:9; unsigned char v2:7; bool v3; };
struct BFu9i_BFu7i_B { unsigned int v1:9; unsigned int v2:7; bool v3; };
struct BFu9i_BFu7ll_B { unsigned int v1:9; unsigned long long v2:7; bool v3; };
struct BFu9i_BFu7s_B { unsigned int v1:9; unsigned short v2:7; bool v3; };
struct BFu9i_BFu8c_B { unsigned int v1:9; unsigned char v2:8; bool v3; };
struct BFu9i_BFu8i_B { unsigned int v1:9; unsigned int v2:8; bool v3; };
struct BFu9i_BFu8ll_B { unsigned int v1:9; unsigned long long v2:8; bool v3; };
struct BFu9i_BFu8s_B { unsigned int v1:9; unsigned short v2:8; bool v3; };
struct BFu9i_BFu9i_B { unsigned int v1:9; unsigned int v2:9; bool v3; };
struct BFu9i_BFu9ll_B { unsigned int v1:9; unsigned long long v2:9; bool v3; };
struct BFu9i_BFu9s_B { unsigned int v1:9; unsigned short v2:9; bool v3; };
struct BFu9i_C_B { unsigned int v1:9; char v2; bool v3; };
struct BFu9i_D_B { unsigned int v1:9; double v2; bool v3; };
struct BFu9i_F_B { unsigned int v1:9; float v2; bool v3; };
struct BFu9i_I_B { unsigned int v1:9; int v2; bool v3; };
struct BFu9i_Ip_B { unsigned int v1:9; int * v2; bool v3; };
struct BFu9i_L_B { unsigned int v1:9; long long v2; bool v3; };
struct BFu9i_S_B { unsigned int v1:9; short v2; bool v3; };
struct BFu9i_Uc_B { unsigned int v1:9; unsigned char v2; bool v3; };
struct BFu9i_Ui_B { unsigned int v1:9; unsigned int v2; bool v3; };
struct BFu9i_Ul_B { unsigned int v1:9; unsigned long long v2; bool v3; };
struct BFu9i_Us_B { unsigned int v1:9; unsigned short v2; bool v3; };
struct BFu9i_Vp_B { unsigned int v1:9; void * v2; bool v3; };
struct BFu9ll_B { unsigned long long v1:9; bool v2; };
struct BFu9ll_B_B { unsigned long long v1:9; bool v2; bool v3; };
struct BFu9ll_B_BFu15i { unsigned long long v1:9; bool v2; unsigned int v3:15; };
struct BFu9ll_B_BFu15ll { unsigned long long v1:9; bool v2; unsigned long long v3:15; };
struct BFu9ll_B_BFu15s { unsigned long long v1:9; bool v2; unsigned short v3:15; };
struct BFu9ll_B_BFu16i { unsigned long long v1:9; bool v2; unsigned int v3:16; };
struct BFu9ll_B_BFu16ll { unsigned long long v1:9; bool v2; unsigned long long v3:16; };
struct BFu9ll_B_BFu16s { unsigned long long v1:9; bool v2; unsigned short v3:16; };
struct BFu9ll_B_BFu17i { unsigned long long v1:9; bool v2; unsigned int v3:17; };
struct BFu9ll_B_BFu17ll { unsigned long long v1:9; bool v2; unsigned long long v3:17; };
struct BFu9ll_B_BFu1c { unsigned long long v1:9; bool v2; unsigned char v3:1; };
struct BFu9ll_B_BFu1i { unsigned long long v1:9; bool v2; unsigned int v3:1; };
struct BFu9ll_B_BFu1ll { unsigned long long v1:9; bool v2; unsigned long long v3:1; };
struct BFu9ll_B_BFu1s { unsigned long long v1:9; bool v2; unsigned short v3:1; };
struct BFu9ll_B_BFu31i { unsigned long long v1:9; bool v2; unsigned int v3:31; };
struct BFu9ll_B_BFu31ll { unsigned long long v1:9; bool v2; unsigned long long v3:31; };
struct BFu9ll_B_BFu32i { unsigned long long v1:9; bool v2; unsigned int v3:32; };
struct BFu9ll_B_BFu32ll { unsigned long long v1:9; bool v2; unsigned long long v3:32; };
struct BFu9ll_B_BFu33 { unsigned long long v1:9; bool v2; unsigned long long v3:33; };
struct BFu9ll_B_BFu7c { unsigned long long v1:9; bool v2; unsigned char v3:7; };
struct BFu9ll_B_BFu7i { unsigned long long v1:9; bool v2; unsigned int v3:7; };
struct BFu9ll_B_BFu7ll { unsigned long long v1:9; bool v2; unsigned long long v3:7; };
struct BFu9ll_B_BFu7s { unsigned long long v1:9; bool v2; unsigned short v3:7; };
struct BFu9ll_B_BFu8c { unsigned long long v1:9; bool v2; unsigned char v3:8; };
struct BFu9ll_B_BFu8i { unsigned long long v1:9; bool v2; unsigned int v3:8; };
struct BFu9ll_B_BFu8ll { unsigned long long v1:9; bool v2; unsigned long long v3:8; };
struct BFu9ll_B_BFu8s { unsigned long long v1:9; bool v2; unsigned short v3:8; };
struct BFu9ll_B_BFu9i { unsigned long long v1:9; bool v2; unsigned int v3:9; };
struct BFu9ll_B_BFu9ll { unsigned long long v1:9; bool v2; unsigned long long v3:9; };
struct BFu9ll_B_BFu9s { unsigned long long v1:9; bool v2; unsigned short v3:9; };
struct BFu9ll_B_C { unsigned long long v1:9; bool v2; char v3; };
struct BFu9ll_B_D { unsigned long long v1:9; bool v2; double v3; };
struct BFu9ll_B_F { unsigned long long v1:9; bool v2; float v3; };
struct BFu9ll_B_I { unsigned long long v1:9; bool v2; int v3; };
struct BFu9ll_B_Ip { unsigned long long v1:9; bool v2; int * v3; };
struct BFu9ll_B_L { unsigned long long v1:9; bool v2; long long v3; };
struct BFu9ll_B_S { unsigned long long v1:9; bool v2; short v3; };
struct BFu9ll_B_Uc { unsigned long long v1:9; bool v2; unsigned char v3; };
struct BFu9ll_B_Ui { unsigned long long v1:9; bool v2; unsigned int v3; };
struct BFu9ll_B_Ul { unsigned long long v1:9; bool v2; unsigned long long v3; };
struct BFu9ll_B_Us { unsigned long long v1:9; bool v2; unsigned short v3; };
struct BFu9ll_B_Vp { unsigned long long v1:9; bool v2; void * v3; };
struct BFu9ll_BFu15i_B { unsigned long long v1:9; unsigned int v2:15; bool v3; };
struct BFu9ll_BFu15ll_B { unsigned long long v1:9; unsigned long long v2:15; bool v3; };
struct BFu9ll_BFu15s_B { unsigned long long v1:9; unsigned short v2:15; bool v3; };
struct BFu9ll_BFu16i_B { unsigned long long v1:9; unsigned int v2:16; bool v3; };
struct BFu9ll_BFu16ll_B { unsigned long long v1:9; unsigned long long v2:16; bool v3; };
struct BFu9ll_BFu16s_B { unsigned long long v1:9; unsigned short v2:16; bool v3; };
struct BFu9ll_BFu17i_B { unsigned long long v1:9; unsigned int v2:17; bool v3; };
struct BFu9ll_BFu17ll_B { unsigned long long v1:9; unsigned long long v2:17; bool v3; };
struct BFu9ll_BFu1c_B { unsigned long long v1:9; unsigned char v2:1; bool v3; };
struct BFu9ll_BFu1i_B { unsigned long long v1:9; unsigned int v2:1; bool v3; };
struct BFu9ll_BFu1ll_B { unsigned long long v1:9; unsigned long long v2:1; bool v3; };
struct BFu9ll_BFu1s_B { unsigned long long v1:9; unsigned short v2:1; bool v3; };
struct BFu9ll_BFu31i_B { unsigned long long v1:9; unsigned int v2:31; bool v3; };
struct BFu9ll_BFu31ll_B { unsigned long long v1:9; unsigned long long v2:31; bool v3; };
struct BFu9ll_BFu32i_B { unsigned long long v1:9; unsigned int v2:32; bool v3; };
struct BFu9ll_BFu32ll_B { unsigned long long v1:9; unsigned long long v2:32; bool v3; };
struct BFu9ll_BFu33_B { unsigned long long v1:9; unsigned long long v2:33; bool v3; };
struct BFu9ll_BFu7c_B { unsigned long long v1:9; unsigned char v2:7; bool v3; };
struct BFu9ll_BFu7i_B { unsigned long long v1:9; unsigned int v2:7; bool v3; };
struct BFu9ll_BFu7ll_B { unsigned long long v1:9; unsigned long long v2:7; bool v3; };
struct BFu9ll_BFu7s_B { unsigned long long v1:9; unsigned short v2:7; bool v3; };
struct BFu9ll_BFu8c_B { unsigned long long v1:9; unsigned char v2:8; bool v3; };
struct BFu9ll_BFu8i_B { unsigned long long v1:9; unsigned int v2:8; bool v3; };
struct BFu9ll_BFu8ll_B { unsigned long long v1:9; unsigned long long v2:8; bool v3; };
struct BFu9ll_BFu8s_B { unsigned long long v1:9; unsigned short v2:8; bool v3; };
struct BFu9ll_BFu9i_B { unsigned long long v1:9; unsigned int v2:9; bool v3; };
struct BFu9ll_BFu9ll_B { unsigned long long v1:9; unsigned long long v2:9; bool v3; };
struct BFu9ll_BFu9s_B { unsigned long long v1:9; unsigned short v2:9; bool v3; };
struct BFu9ll_C_B { unsigned long long v1:9; char v2; bool v3; };
struct BFu9ll_D_B { unsigned long long v1:9; double v2; bool v3; };
struct BFu9ll_F_B { unsigned long long v1:9; float v2; bool v3; };
struct BFu9ll_I_B { unsigned long long v1:9; int v2; bool v3; };
struct BFu9ll_Ip_B { unsigned long long v1:9; int * v2; bool v3; };
struct BFu9ll_L_B { unsigned long long v1:9; long long v2; bool v3; };
struct BFu9ll_S_B { unsigned long long v1:9; short v2; bool v3; };
struct BFu9ll_Uc_B { unsigned long long v1:9; unsigned char v2; bool v3; };
struct BFu9ll_Ui_B { unsigned long long v1:9; unsigned int v2; bool v3; };
struct BFu9ll_Ul_B { unsigned long long v1:9; unsigned long long v2; bool v3; };
struct BFu9ll_Us_B { unsigned long long v1:9; unsigned short v2; bool v3; };
struct BFu9ll_Vp_B { unsigned long long v1:9; void * v2; bool v3; };
struct BFu9s_B { unsigned short v1:9; bool v2; };
struct BFu9s_B_B { unsigned short v1:9; bool v2; bool v3; };
struct BFu9s_B_BFu15i { unsigned short v1:9; bool v2; unsigned int v3:15; };
struct BFu9s_B_BFu15ll { unsigned short v1:9; bool v2; unsigned long long v3:15; };
struct BFu9s_B_BFu15s { unsigned short v1:9; bool v2; unsigned short v3:15; };
struct BFu9s_B_BFu16i { unsigned short v1:9; bool v2; unsigned int v3:16; };
struct BFu9s_B_BFu16ll { unsigned short v1:9; bool v2; unsigned long long v3:16; };
struct BFu9s_B_BFu16s { unsigned short v1:9; bool v2; unsigned short v3:16; };
struct BFu9s_B_BFu17i { unsigned short v1:9; bool v2; unsigned int v3:17; };
struct BFu9s_B_BFu17ll { unsigned short v1:9; bool v2; unsigned long long v3:17; };
struct BFu9s_B_BFu1c { unsigned short v1:9; bool v2; unsigned char v3:1; };
struct BFu9s_B_BFu1i { unsigned short v1:9; bool v2; unsigned int v3:1; };
struct BFu9s_B_BFu1ll { unsigned short v1:9; bool v2; unsigned long long v3:1; };
struct BFu9s_B_BFu1s { unsigned short v1:9; bool v2; unsigned short v3:1; };
struct BFu9s_B_BFu31i { unsigned short v1:9; bool v2; unsigned int v3:31; };
struct BFu9s_B_BFu31ll { unsigned short v1:9; bool v2; unsigned long long v3:31; };
struct BFu9s_B_BFu32i { unsigned short v1:9; bool v2; unsigned int v3:32; };
struct BFu9s_B_BFu32ll { unsigned short v1:9; bool v2; unsigned long long v3:32; };
struct BFu9s_B_BFu33 { unsigned short v1:9; bool v2; unsigned long long v3:33; };
struct BFu9s_B_BFu7c { unsigned short v1:9; bool v2; unsigned char v3:7; };
struct BFu9s_B_BFu7i { unsigned short v1:9; bool v2; unsigned int v3:7; };
struct BFu9s_B_BFu7ll { unsigned short v1:9; bool v2; unsigned long long v3:7; };
struct BFu9s_B_BFu7s { unsigned short v1:9; bool v2; unsigned short v3:7; };
struct BFu9s_B_BFu8c { unsigned short v1:9; bool v2; unsigned char v3:8; };
struct BFu9s_B_BFu8i { unsigned short v1:9; bool v2; unsigned int v3:8; };
struct BFu9s_B_BFu8ll { unsigned short v1:9; bool v2; unsigned long long v3:8; };
struct BFu9s_B_BFu8s { unsigned short v1:9; bool v2; unsigned short v3:8; };
struct BFu9s_B_BFu9i { unsigned short v1:9; bool v2; unsigned int v3:9; };
struct BFu9s_B_BFu9ll { unsigned short v1:9; bool v2; unsigned long long v3:9; };
struct BFu9s_B_BFu9s { unsigned short v1:9; bool v2; unsigned short v3:9; };
struct BFu9s_B_C { unsigned short v1:9; bool v2; char v3; };
struct BFu9s_B_D { unsigned short v1:9; bool v2; double v3; };
struct BFu9s_B_F { unsigned short v1:9; bool v2; float v3; };
struct BFu9s_B_I { unsigned short v1:9; bool v2; int v3; };
struct BFu9s_B_Ip { unsigned short v1:9; bool v2; int * v3; };
struct BFu9s_B_L { unsigned short v1:9; bool v2; long long v3; };
struct BFu9s_B_S { unsigned short v1:9; bool v2; short v3; };
struct BFu9s_B_Uc { unsigned short v1:9; bool v2; unsigned char v3; };
struct BFu9s_B_Ui { unsigned short v1:9; bool v2; unsigned int v3; };
struct BFu9s_B_Ul { unsigned short v1:9; bool v2; unsigned long long v3; };
struct BFu9s_B_Us { unsigned short v1:9; bool v2; unsigned short v3; };
struct BFu9s_B_Vp { unsigned short v1:9; bool v2; void * v3; };
struct BFu9s_BFu15i_B { unsigned short v1:9; unsigned int v2:15; bool v3; };
struct BFu9s_BFu15ll_B { unsigned short v1:9; unsigned long long v2:15; bool v3; };
struct BFu9s_BFu15s_B { unsigned short v1:9; unsigned short v2:15; bool v3; };
struct BFu9s_BFu16i_B { unsigned short v1:9; unsigned int v2:16; bool v3; };
struct BFu9s_BFu16ll_B { unsigned short v1:9; unsigned long long v2:16; bool v3; };
struct BFu9s_BFu16s_B { unsigned short v1:9; unsigned short v2:16; bool v3; };
struct BFu9s_BFu17i_B { unsigned short v1:9; unsigned int v2:17; bool v3; };
struct BFu9s_BFu17ll_B { unsigned short v1:9; unsigned long long v2:17; bool v3; };
struct BFu9s_BFu1c_B { unsigned short v1:9; unsigned char v2:1; bool v3; };
struct BFu9s_BFu1i_B { unsigned short v1:9; unsigned int v2:1; bool v3; };
struct BFu9s_BFu1ll_B { unsigned short v1:9; unsigned long long v2:1; bool v3; };
struct BFu9s_BFu1s_B { unsigned short v1:9; unsigned short v2:1; bool v3; };
struct BFu9s_BFu31i_B { unsigned short v1:9; unsigned int v2:31; bool v3; };
struct BFu9s_BFu31ll_B { unsigned short v1:9; unsigned long long v2:31; bool v3; };
struct BFu9s_BFu32i_B { unsigned short v1:9; unsigned int v2:32; bool v3; };
struct BFu9s_BFu32ll_B { unsigned short v1:9; unsigned long long v2:32; bool v3; };
struct BFu9s_BFu33_B { unsigned short v1:9; unsigned long long v2:33; bool v3; };
struct BFu9s_BFu7c_B { unsigned short v1:9; unsigned char v2:7; bool v3; };
#endif // __cplusplus
#ifdef __cplusplus


static void Test_B_BFu8i_C()
{
  {
    init_simple_test("B_BFu8i_C");
    static B_BFu8i_C lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8i_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8i_C)");
    check_field_offset(lv, v1, 0, "B_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_C");
    check_field_offset(lv, v3, 2, "B_BFu8i_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_C(Test_B_BFu8i_C, "B_BFu8i_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8i_D()
{
  {
    init_simple_test("B_BFu8i_D");
    static B_BFu8i_D lv;
    check2(sizeof(lv), 10, "sizeof(B_BFu8i_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8i_D)");
    check_field_offset(lv, v1, 0, "B_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_D");
    check_field_offset(lv, v3, 2, "B_BFu8i_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_D(Test_B_BFu8i_D, "B_BFu8i_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8i_F()
{
  {
    init_simple_test("B_BFu8i_F");
    static B_BFu8i_F lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8i_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8i_F)");
    check_field_offset(lv, v1, 0, "B_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_F");
    check_field_offset(lv, v3, 2, "B_BFu8i_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_F(Test_B_BFu8i_F, "B_BFu8i_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8i_I()
{
  {
    init_simple_test("B_BFu8i_I");
    static B_BFu8i_I lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8i_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8i_I)");
    check_field_offset(lv, v1, 0, "B_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_I");
    check_field_offset(lv, v3, 2, "B_BFu8i_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_I(Test_B_BFu8i_I, "B_BFu8i_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8i_Ip()
{
  {
    init_simple_test("B_BFu8i_Ip");
    static B_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu8i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_Ip");
    check_field_offset(lv, v3, 2, "B_BFu8i_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_Ip(Test_B_BFu8i_Ip, "B_BFu8i_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8i_L()
{
  {
    init_simple_test("B_BFu8i_L");
    static B_BFu8i_L lv;
    check2(sizeof(lv), 10, "sizeof(B_BFu8i_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8i_L)");
    check_field_offset(lv, v1, 0, "B_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_L");
    check_field_offset(lv, v3, 2, "B_BFu8i_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_L(Test_B_BFu8i_L, "B_BFu8i_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8i_S()
{
  {
    init_simple_test("B_BFu8i_S");
    static B_BFu8i_S lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8i_S)");
    check_field_offset(lv, v1, 0, "B_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_S");
    check_field_offset(lv, v3, 2, "B_BFu8i_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_S(Test_B_BFu8i_S, "B_BFu8i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8i_Uc()
{
  {
    init_simple_test("B_BFu8i_Uc");
    static B_BFu8i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_Uc");
    check_field_offset(lv, v3, 2, "B_BFu8i_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_Uc(Test_B_BFu8i_Uc, "B_BFu8i_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8i_Ui()
{
  {
    init_simple_test("B_BFu8i_Ui");
    static B_BFu8i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_Ui");
    check_field_offset(lv, v3, 2, "B_BFu8i_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_Ui(Test_B_BFu8i_Ui, "B_BFu8i_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8i_Ul()
{
  {
    init_simple_test("B_BFu8i_Ul");
    static B_BFu8i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(B_BFu8i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_Ul");
    check_field_offset(lv, v3, 2, "B_BFu8i_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_Ul(Test_B_BFu8i_Ul, "B_BFu8i_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8i_Us()
{
  {
    init_simple_test("B_BFu8i_Us");
    static B_BFu8i_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "B_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_Us");
    check_field_offset(lv, v3, 2, "B_BFu8i_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_Us(Test_B_BFu8i_Us, "B_BFu8i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8i_Vp()
{
  {
    init_simple_test("B_BFu8i_Vp");
    static B_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu8i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_Vp");
    check_field_offset(lv, v3, 2, "B_BFu8i_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_Vp(Test_B_BFu8i_Vp, "B_BFu8i_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll()
{
  {
    init_simple_test("B_BFu8ll");
    static B_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll(Test_B_BFu8ll, "B_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_B()
{
  {
    init_simple_test("B_BFu8ll_B");
    static B_BFu8ll_B lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_B)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_B");
    check_field_offset(lv, v3, 2, "B_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_B(Test_B_BFu8ll_B, "B_BFu8ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu15i()
{
  {
    init_simple_test("B_BFu8ll_BFu15i");
    static B_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8ll_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu15i(Test_B_BFu8ll_BFu15i, "B_BFu8ll_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu15ll()
{
  {
    init_simple_test("B_BFu8ll_BFu15ll");
    static B_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu15ll(Test_B_BFu8ll_BFu15ll, "B_BFu8ll_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu15s()
{
  {
    init_simple_test("B_BFu8ll_BFu15s");
    static B_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8ll_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu15s(Test_B_BFu8ll_BFu15s, "B_BFu8ll_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu16i()
{
  {
    init_simple_test("B_BFu8ll_BFu16i");
    static B_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8ll_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu16i(Test_B_BFu8ll_BFu16i, "B_BFu8ll_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu16ll()
{
  {
    init_simple_test("B_BFu8ll_BFu16ll");
    static B_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu16ll(Test_B_BFu8ll_BFu16ll, "B_BFu8ll_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu16s()
{
  {
    init_simple_test("B_BFu8ll_BFu16s");
    static B_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8ll_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu16s(Test_B_BFu8ll_BFu16s, "B_BFu8ll_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu17i()
{
  {
    init_simple_test("B_BFu8ll_BFu17i");
    static B_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu8ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "B_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "B_BFu8ll_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu17i(Test_B_BFu8ll_BFu17i, "B_BFu8ll_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu17ll()
{
  {
    init_simple_test("B_BFu8ll_BFu17ll");
    static B_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "B_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "B_BFu8ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu17ll(Test_B_BFu8ll_BFu17ll, "B_BFu8ll_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu1c()
{
  {
    init_simple_test("B_BFu8ll_BFu1c");
    static B_BFu8ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8ll_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu1c(Test_B_BFu8ll_BFu1c, "B_BFu8ll_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu1i()
{
  {
    init_simple_test("B_BFu8ll_BFu1i");
    static B_BFu8ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8ll_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu1i(Test_B_BFu8ll_BFu1i, "B_BFu8ll_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu1ll()
{
  {
    init_simple_test("B_BFu8ll_BFu1ll");
    static B_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu1ll(Test_B_BFu8ll_BFu1ll, "B_BFu8ll_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu1s()
{
  {
    init_simple_test("B_BFu8ll_BFu1s");
    static B_BFu8ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8ll_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu1s(Test_B_BFu8ll_BFu1s, "B_BFu8ll_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu31i()
{
  {
    init_simple_test("B_BFu8ll_BFu31i");
    static B_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "B_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "B_BFu8ll_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu31i(Test_B_BFu8ll_BFu31i, "B_BFu8ll_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu31ll()
{
  {
    init_simple_test("B_BFu8ll_BFu31ll");
    static B_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "B_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "B_BFu8ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu31ll(Test_B_BFu8ll_BFu31ll, "B_BFu8ll_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu32i()
{
  {
    init_simple_test("B_BFu8ll_BFu32i");
    static B_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "B_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "B_BFu8ll_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu32i(Test_B_BFu8ll_BFu32i, "B_BFu8ll_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu32ll()
{
  {
    init_simple_test("B_BFu8ll_BFu32ll");
    static B_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "B_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "B_BFu8ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu32ll(Test_B_BFu8ll_BFu32ll, "B_BFu8ll_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu33()
{
  {
    init_simple_test("B_BFu8ll_BFu33");
    static B_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu8ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "B_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "B_BFu8ll_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu33(Test_B_BFu8ll_BFu33, "B_BFu8ll_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu7c()
{
  {
    init_simple_test("B_BFu8ll_BFu7c");
    static B_BFu8ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8ll_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu7c(Test_B_BFu8ll_BFu7c, "B_BFu8ll_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu7i()
{
  {
    init_simple_test("B_BFu8ll_BFu7i");
    static B_BFu8ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8ll_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu7i(Test_B_BFu8ll_BFu7i, "B_BFu8ll_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu7ll()
{
  {
    init_simple_test("B_BFu8ll_BFu7ll");
    static B_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu7ll(Test_B_BFu8ll_BFu7ll, "B_BFu8ll_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu7s()
{
  {
    init_simple_test("B_BFu8ll_BFu7s");
    static B_BFu8ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8ll_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu7s(Test_B_BFu8ll_BFu7s, "B_BFu8ll_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu8c()
{
  {
    init_simple_test("B_BFu8ll_BFu8c");
    static B_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu8c(Test_B_BFu8ll_BFu8c, "B_BFu8ll_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu8i()
{
  {
    init_simple_test("B_BFu8ll_BFu8i");
    static B_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu8i(Test_B_BFu8ll_BFu8i, "B_BFu8ll_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu8ll()
{
  {
    init_simple_test("B_BFu8ll_BFu8ll");
    static B_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu8ll(Test_B_BFu8ll_BFu8ll, "B_BFu8ll_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu8s()
{
  {
    init_simple_test("B_BFu8ll_BFu8s");
    static B_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu8s(Test_B_BFu8ll_BFu8s, "B_BFu8ll_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu9i()
{
  {
    init_simple_test("B_BFu8ll_BFu9i");
    static B_BFu8ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8ll_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu9i(Test_B_BFu8ll_BFu9i, "B_BFu8ll_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu9ll()
{
  {
    init_simple_test("B_BFu8ll_BFu9ll");
    static B_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu9ll(Test_B_BFu8ll_BFu9ll, "B_BFu8ll_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_BFu9s()
{
  {
    init_simple_test("B_BFu8ll_BFu9s");
    static B_BFu8ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8ll_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu9s(Test_B_BFu8ll_BFu9s, "B_BFu8ll_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_C()
{
  {
    init_simple_test("B_BFu8ll_C");
    static B_BFu8ll_C lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_C");
    check_field_offset(lv, v3, 2, "B_BFu8ll_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_C(Test_B_BFu8ll_C, "B_BFu8ll_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_D()
{
  {
    init_simple_test("B_BFu8ll_D");
    static B_BFu8ll_D lv;
    check2(sizeof(lv), 10, "sizeof(B_BFu8ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_D");
    check_field_offset(lv, v3, 2, "B_BFu8ll_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_D(Test_B_BFu8ll_D, "B_BFu8ll_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_F()
{
  {
    init_simple_test("B_BFu8ll_F");
    static B_BFu8ll_F lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_F");
    check_field_offset(lv, v3, 2, "B_BFu8ll_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_F(Test_B_BFu8ll_F, "B_BFu8ll_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_I()
{
  {
    init_simple_test("B_BFu8ll_I");
    static B_BFu8ll_I lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_I");
    check_field_offset(lv, v3, 2, "B_BFu8ll_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_I(Test_B_BFu8ll_I, "B_BFu8ll_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_Ip()
{
  {
    init_simple_test("B_BFu8ll_Ip");
    static B_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_Ip");
    check_field_offset(lv, v3, 2, "B_BFu8ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_Ip(Test_B_BFu8ll_Ip, "B_BFu8ll_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_L()
{
  {
    init_simple_test("B_BFu8ll_L");
    static B_BFu8ll_L lv;
    check2(sizeof(lv), 10, "sizeof(B_BFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_L");
    check_field_offset(lv, v3, 2, "B_BFu8ll_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_L(Test_B_BFu8ll_L, "B_BFu8ll_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_S()
{
  {
    init_simple_test("B_BFu8ll_S");
    static B_BFu8ll_S lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_S");
    check_field_offset(lv, v3, 2, "B_BFu8ll_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_S(Test_B_BFu8ll_S, "B_BFu8ll_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_Uc()
{
  {
    init_simple_test("B_BFu8ll_Uc");
    static B_BFu8ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_Uc");
    check_field_offset(lv, v3, 2, "B_BFu8ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_Uc(Test_B_BFu8ll_Uc, "B_BFu8ll_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_Ui()
{
  {
    init_simple_test("B_BFu8ll_Ui");
    static B_BFu8ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_Ui");
    check_field_offset(lv, v3, 2, "B_BFu8ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_Ui(Test_B_BFu8ll_Ui, "B_BFu8ll_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_Ul()
{
  {
    init_simple_test("B_BFu8ll_Ul");
    static B_BFu8ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(B_BFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_Ul");
    check_field_offset(lv, v3, 2, "B_BFu8ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_Ul(Test_B_BFu8ll_Ul, "B_BFu8ll_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_Us()
{
  {
    init_simple_test("B_BFu8ll_Us");
    static B_BFu8ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_Us");
    check_field_offset(lv, v3, 2, "B_BFu8ll_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_Us(Test_B_BFu8ll_Us, "B_BFu8ll_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8ll_Vp()
{
  {
    init_simple_test("B_BFu8ll_Vp");
    static B_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_Vp");
    check_field_offset(lv, v3, 2, "B_BFu8ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_Vp(Test_B_BFu8ll_Vp, "B_BFu8ll_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s()
{
  {
    init_simple_test("B_BFu8s");
    static B_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu8s(Test_B_BFu8s, "B_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_B()
{
  {
    init_simple_test("B_BFu8s_B");
    static B_BFu8s_B lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_B)");
    check_field_offset(lv, v1, 0, "B_BFu8s_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_B");
    check_field_offset(lv, v3, 2, "B_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_B(Test_B_BFu8s_B, "B_BFu8s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu15i()
{
  {
    init_simple_test("B_BFu8s_BFu15i");
    static B_BFu8s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8s_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu15i(Test_B_BFu8s_BFu15i, "B_BFu8s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu15ll()
{
  {
    init_simple_test("B_BFu8s_BFu15ll");
    static B_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8s_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu15ll(Test_B_BFu8s_BFu15ll, "B_BFu8s_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu15s()
{
  {
    init_simple_test("B_BFu8s_BFu15s");
    static B_BFu8s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8s_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu15s(Test_B_BFu8s_BFu15s, "B_BFu8s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu16i()
{
  {
    init_simple_test("B_BFu8s_BFu16i");
    static B_BFu8s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8s_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu16i(Test_B_BFu8s_BFu16i, "B_BFu8s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu16ll()
{
  {
    init_simple_test("B_BFu8s_BFu16ll");
    static B_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8s_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu16ll(Test_B_BFu8s_BFu16ll, "B_BFu8s_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu16s()
{
  {
    init_simple_test("B_BFu8s_BFu16s");
    static B_BFu8s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8s_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu16s(Test_B_BFu8s_BFu16s, "B_BFu8s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu17i()
{
  {
    init_simple_test("B_BFu8s_BFu17i");
    static B_BFu8s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu8s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "B_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "B_BFu8s_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu17i(Test_B_BFu8s_BFu17i, "B_BFu8s_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu17ll()
{
  {
    init_simple_test("B_BFu8s_BFu17ll");
    static B_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu8s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "B_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "B_BFu8s_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu17ll(Test_B_BFu8s_BFu17ll, "B_BFu8s_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu1c()
{
  {
    init_simple_test("B_BFu8s_BFu1c");
    static B_BFu8s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8s_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu1c(Test_B_BFu8s_BFu1c, "B_BFu8s_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu1i()
{
  {
    init_simple_test("B_BFu8s_BFu1i");
    static B_BFu8s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8s_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu1i(Test_B_BFu8s_BFu1i, "B_BFu8s_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu1ll()
{
  {
    init_simple_test("B_BFu8s_BFu1ll");
    static B_BFu8s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8s_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu1ll(Test_B_BFu8s_BFu1ll, "B_BFu8s_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu1s()
{
  {
    init_simple_test("B_BFu8s_BFu1s");
    static B_BFu8s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8s_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu1s(Test_B_BFu8s_BFu1s, "B_BFu8s_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu31i()
{
  {
    init_simple_test("B_BFu8s_BFu31i");
    static B_BFu8s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "B_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "B_BFu8s_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu31i(Test_B_BFu8s_BFu31i, "B_BFu8s_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu31ll()
{
  {
    init_simple_test("B_BFu8s_BFu31ll");
    static B_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "B_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "B_BFu8s_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu31ll(Test_B_BFu8s_BFu31ll, "B_BFu8s_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu32i()
{
  {
    init_simple_test("B_BFu8s_BFu32i");
    static B_BFu8s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "B_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "B_BFu8s_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu32i(Test_B_BFu8s_BFu32i, "B_BFu8s_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu32ll()
{
  {
    init_simple_test("B_BFu8s_BFu32ll");
    static B_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "B_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "B_BFu8s_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu32ll(Test_B_BFu8s_BFu32ll, "B_BFu8s_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu33()
{
  {
    init_simple_test("B_BFu8s_BFu33");
    static B_BFu8s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu8s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "B_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "B_BFu8s_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu33(Test_B_BFu8s_BFu33, "B_BFu8s_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu7c()
{
  {
    init_simple_test("B_BFu8s_BFu7c");
    static B_BFu8s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8s_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu7c(Test_B_BFu8s_BFu7c, "B_BFu8s_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu7i()
{
  {
    init_simple_test("B_BFu8s_BFu7i");
    static B_BFu8s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8s_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu7i(Test_B_BFu8s_BFu7i, "B_BFu8s_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu7ll()
{
  {
    init_simple_test("B_BFu8s_BFu7ll");
    static B_BFu8s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8s_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu7ll(Test_B_BFu8s_BFu7ll, "B_BFu8s_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu7s()
{
  {
    init_simple_test("B_BFu8s_BFu7s");
    static B_BFu8s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8s_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu7s(Test_B_BFu8s_BFu7s, "B_BFu8s_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu8c()
{
  {
    init_simple_test("B_BFu8s_BFu8c");
    static B_BFu8s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu8c(Test_B_BFu8s_BFu8c, "B_BFu8s_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu8i()
{
  {
    init_simple_test("B_BFu8s_BFu8i");
    static B_BFu8s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu8i(Test_B_BFu8s_BFu8i, "B_BFu8s_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu8ll()
{
  {
    init_simple_test("B_BFu8s_BFu8ll");
    static B_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu8ll(Test_B_BFu8s_BFu8ll, "B_BFu8s_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu8s()
{
  {
    init_simple_test("B_BFu8s_BFu8s");
    static B_BFu8s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu8s(Test_B_BFu8s_BFu8s, "B_BFu8s_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu9i()
{
  {
    init_simple_test("B_BFu8s_BFu9i");
    static B_BFu8s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8s_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu9i(Test_B_BFu8s_BFu9i, "B_BFu8s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu9ll()
{
  {
    init_simple_test("B_BFu8s_BFu9ll");
    static B_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8s_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu9ll(Test_B_BFu8s_BFu9ll, "B_BFu8s_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_BFu9s()
{
  {
    init_simple_test("B_BFu8s_BFu9s");
    static B_BFu8s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8s_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu9s(Test_B_BFu8s_BFu9s, "B_BFu8s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_C()
{
  {
    init_simple_test("B_BFu8s_C");
    static B_BFu8s_C lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_C)");
    check_field_offset(lv, v1, 0, "B_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_C");
    check_field_offset(lv, v3, 2, "B_BFu8s_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_C(Test_B_BFu8s_C, "B_BFu8s_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_D()
{
  {
    init_simple_test("B_BFu8s_D");
    static B_BFu8s_D lv;
    check2(sizeof(lv), 10, "sizeof(B_BFu8s_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_D)");
    check_field_offset(lv, v1, 0, "B_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_D");
    check_field_offset(lv, v3, 2, "B_BFu8s_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_D(Test_B_BFu8s_D, "B_BFu8s_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_F()
{
  {
    init_simple_test("B_BFu8s_F");
    static B_BFu8s_F lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8s_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_F)");
    check_field_offset(lv, v1, 0, "B_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_F");
    check_field_offset(lv, v3, 2, "B_BFu8s_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_F(Test_B_BFu8s_F, "B_BFu8s_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_I()
{
  {
    init_simple_test("B_BFu8s_I");
    static B_BFu8s_I lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8s_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_I)");
    check_field_offset(lv, v1, 0, "B_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_I");
    check_field_offset(lv, v3, 2, "B_BFu8s_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_I(Test_B_BFu8s_I, "B_BFu8s_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_Ip()
{
  {
    init_simple_test("B_BFu8s_Ip");
    static B_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu8s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_Ip");
    check_field_offset(lv, v3, 2, "B_BFu8s_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_Ip(Test_B_BFu8s_Ip, "B_BFu8s_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_L()
{
  {
    init_simple_test("B_BFu8s_L");
    static B_BFu8s_L lv;
    check2(sizeof(lv), 10, "sizeof(B_BFu8s_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_L)");
    check_field_offset(lv, v1, 0, "B_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_L");
    check_field_offset(lv, v3, 2, "B_BFu8s_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_L(Test_B_BFu8s_L, "B_BFu8s_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_S()
{
  {
    init_simple_test("B_BFu8s_S");
    static B_BFu8s_S lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_S)");
    check_field_offset(lv, v1, 0, "B_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_S");
    check_field_offset(lv, v3, 2, "B_BFu8s_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_S(Test_B_BFu8s_S, "B_BFu8s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_Uc()
{
  {
    init_simple_test("B_BFu8s_Uc");
    static B_BFu8s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_Uc");
    check_field_offset(lv, v3, 2, "B_BFu8s_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_Uc(Test_B_BFu8s_Uc, "B_BFu8s_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_Ui()
{
  {
    init_simple_test("B_BFu8s_Ui");
    static B_BFu8s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu8s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_Ui");
    check_field_offset(lv, v3, 2, "B_BFu8s_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_Ui(Test_B_BFu8s_Ui, "B_BFu8s_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_Ul()
{
  {
    init_simple_test("B_BFu8s_Ul");
    static B_BFu8s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(B_BFu8s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_Ul");
    check_field_offset(lv, v3, 2, "B_BFu8s_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_Ul(Test_B_BFu8s_Ul, "B_BFu8s_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_Us()
{
  {
    init_simple_test("B_BFu8s_Us");
    static B_BFu8s_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "B_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_Us");
    check_field_offset(lv, v3, 2, "B_BFu8s_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_Us(Test_B_BFu8s_Us, "B_BFu8s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu8s_Vp()
{
  {
    init_simple_test("B_BFu8s_Vp");
    static B_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_BFu8s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_Vp");
    check_field_offset(lv, v3, 2, "B_BFu8s_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_Vp(Test_B_BFu8s_Vp, "B_BFu8s_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i()
{
  {
    init_simple_test("B_BFu9i");
    static B_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu9i(Test_B_BFu9i, "B_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_B()
{
  {
    init_simple_test("B_BFu9i_B");
    static B_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_B)");
    check_field_offset(lv, v1, 0, "B_BFu9i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_B");
    check_field_offset(lv, v3, 3, "B_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_B(Test_B_BFu9i_B, "B_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu15i()
{
  {
    init_simple_test("B_BFu9i_BFu15i");
    static B_BFu9i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9i_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu15i(Test_B_BFu9i_BFu15i, "B_BFu9i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu15ll()
{
  {
    init_simple_test("B_BFu9i_BFu15ll");
    static B_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9i_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu15ll(Test_B_BFu9i_BFu15ll, "B_BFu9i_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu15s()
{
  {
    init_simple_test("B_BFu9i_BFu15s");
    static B_BFu9i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9i_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu15s(Test_B_BFu9i_BFu15s, "B_BFu9i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu16i()
{
  {
    init_simple_test("B_BFu9i_BFu16i");
    static B_BFu9i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "B_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "B_BFu9i_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu16i(Test_B_BFu9i_BFu16i, "B_BFu9i_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu16ll()
{
  {
    init_simple_test("B_BFu9i_BFu16ll");
    static B_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "B_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "B_BFu9i_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu16ll(Test_B_BFu9i_BFu16ll, "B_BFu9i_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu16s()
{
  {
    init_simple_test("B_BFu9i_BFu16s");
    static B_BFu9i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "B_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "B_BFu9i_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu16s(Test_B_BFu9i_BFu16s, "B_BFu9i_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu17i()
{
  {
    init_simple_test("B_BFu9i_BFu17i");
    static B_BFu9i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "B_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "B_BFu9i_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu17i(Test_B_BFu9i_BFu17i, "B_BFu9i_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu17ll()
{
  {
    init_simple_test("B_BFu9i_BFu17ll");
    static B_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "B_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "B_BFu9i_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu17ll(Test_B_BFu9i_BFu17ll, "B_BFu9i_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu1c()
{
  {
    init_simple_test("B_BFu9i_BFu1c");
    static B_BFu9i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9i_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu1c(Test_B_BFu9i_BFu1c, "B_BFu9i_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu1i()
{
  {
    init_simple_test("B_BFu9i_BFu1i");
    static B_BFu9i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9i_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu1i(Test_B_BFu9i_BFu1i, "B_BFu9i_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu1ll()
{
  {
    init_simple_test("B_BFu9i_BFu1ll");
    static B_BFu9i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9i_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu1ll(Test_B_BFu9i_BFu1ll, "B_BFu9i_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu1s()
{
  {
    init_simple_test("B_BFu9i_BFu1s");
    static B_BFu9i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9i_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu1s(Test_B_BFu9i_BFu1s, "B_BFu9i_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu31i()
{
  {
    init_simple_test("B_BFu9i_BFu31i");
    static B_BFu9i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu9i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "B_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "B_BFu9i_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu31i(Test_B_BFu9i_BFu31i, "B_BFu9i_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu31ll()
{
  {
    init_simple_test("B_BFu9i_BFu31ll");
    static B_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu9i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "B_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "B_BFu9i_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu31ll(Test_B_BFu9i_BFu31ll, "B_BFu9i_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu32i()
{
  {
    init_simple_test("B_BFu9i_BFu32i");
    static B_BFu9i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "B_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "B_BFu9i_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu32i(Test_B_BFu9i_BFu32i, "B_BFu9i_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu32ll()
{
  {
    init_simple_test("B_BFu9i_BFu32ll");
    static B_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "B_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "B_BFu9i_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu32ll(Test_B_BFu9i_BFu32ll, "B_BFu9i_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu33()
{
  {
    init_simple_test("B_BFu9i_BFu33");
    static B_BFu9i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "B_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "B_BFu9i_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu33(Test_B_BFu9i_BFu33, "B_BFu9i_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu7c()
{
  {
    init_simple_test("B_BFu9i_BFu7c");
    static B_BFu9i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9i_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu7c(Test_B_BFu9i_BFu7c, "B_BFu9i_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu7i()
{
  {
    init_simple_test("B_BFu9i_BFu7i");
    static B_BFu9i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9i_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu7i(Test_B_BFu9i_BFu7i, "B_BFu9i_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu7ll()
{
  {
    init_simple_test("B_BFu9i_BFu7ll");
    static B_BFu9i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9i_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu7ll(Test_B_BFu9i_BFu7ll, "B_BFu9i_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu7s()
{
  {
    init_simple_test("B_BFu9i_BFu7s");
    static B_BFu9i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9i_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu7s(Test_B_BFu9i_BFu7s, "B_BFu9i_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu8c()
{
  {
    init_simple_test("B_BFu9i_BFu8c");
    static B_BFu9i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9i_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu8c(Test_B_BFu9i_BFu8c, "B_BFu9i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu8i()
{
  {
    init_simple_test("B_BFu9i_BFu8i");
    static B_BFu9i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9i_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu8i(Test_B_BFu9i_BFu8i, "B_BFu9i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu8ll()
{
  {
    init_simple_test("B_BFu9i_BFu8ll");
    static B_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9i_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu8ll(Test_B_BFu9i_BFu8ll, "B_BFu9i_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu8s()
{
  {
    init_simple_test("B_BFu9i_BFu8s");
    static B_BFu9i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9i_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu8s(Test_B_BFu9i_BFu8s, "B_BFu9i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu9i()
{
  {
    init_simple_test("B_BFu9i_BFu9i");
    static B_BFu9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "B_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "B_BFu9i_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu9i(Test_B_BFu9i_BFu9i, "B_BFu9i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu9ll()
{
  {
    init_simple_test("B_BFu9i_BFu9ll");
    static B_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "B_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "B_BFu9i_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu9ll(Test_B_BFu9i_BFu9ll, "B_BFu9i_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_BFu9s()
{
  {
    init_simple_test("B_BFu9i_BFu9s");
    static B_BFu9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "B_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "B_BFu9i_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu9s(Test_B_BFu9i_BFu9s, "B_BFu9i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_C()
{
  {
    init_simple_test("B_BFu9i_C");
    static B_BFu9i_C lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_C)");
    check_field_offset(lv, v1, 0, "B_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_C");
    check_field_offset(lv, v3, 3, "B_BFu9i_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_C(Test_B_BFu9i_C, "B_BFu9i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_D()
{
  {
    init_simple_test("B_BFu9i_D");
    static B_BFu9i_D lv;
    check2(sizeof(lv), 11, "sizeof(B_BFu9i_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_D)");
    check_field_offset(lv, v1, 0, "B_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_D");
    check_field_offset(lv, v3, 3, "B_BFu9i_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_D(Test_B_BFu9i_D, "B_BFu9i_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_F()
{
  {
    init_simple_test("B_BFu9i_F");
    static B_BFu9i_F lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9i_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_F)");
    check_field_offset(lv, v1, 0, "B_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_F");
    check_field_offset(lv, v3, 3, "B_BFu9i_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_F(Test_B_BFu9i_F, "B_BFu9i_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_I()
{
  {
    init_simple_test("B_BFu9i_I");
    static B_BFu9i_I lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9i_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_I)");
    check_field_offset(lv, v1, 0, "B_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_I");
    check_field_offset(lv, v3, 3, "B_BFu9i_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_I(Test_B_BFu9i_I, "B_BFu9i_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_Ip()
{
  {
    init_simple_test("B_BFu9i_Ip");
    static B_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_BFu9i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_Ip");
    check_field_offset(lv, v3, 3, "B_BFu9i_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_Ip(Test_B_BFu9i_Ip, "B_BFu9i_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_L()
{
  {
    init_simple_test("B_BFu9i_L");
    static B_BFu9i_L lv;
    check2(sizeof(lv), 11, "sizeof(B_BFu9i_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_L)");
    check_field_offset(lv, v1, 0, "B_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_L");
    check_field_offset(lv, v3, 3, "B_BFu9i_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_L(Test_B_BFu9i_L, "B_BFu9i_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_S()
{
  {
    init_simple_test("B_BFu9i_S");
    static B_BFu9i_S lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9i_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_S)");
    check_field_offset(lv, v1, 0, "B_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_S");
    check_field_offset(lv, v3, 3, "B_BFu9i_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_S(Test_B_BFu9i_S, "B_BFu9i_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_Uc()
{
  {
    init_simple_test("B_BFu9i_Uc");
    static B_BFu9i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_Uc");
    check_field_offset(lv, v3, 3, "B_BFu9i_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_Uc(Test_B_BFu9i_Uc, "B_BFu9i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_Ui()
{
  {
    init_simple_test("B_BFu9i_Ui");
    static B_BFu9i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_Ui");
    check_field_offset(lv, v3, 3, "B_BFu9i_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_Ui(Test_B_BFu9i_Ui, "B_BFu9i_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_Ul()
{
  {
    init_simple_test("B_BFu9i_Ul");
    static B_BFu9i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(B_BFu9i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_Ul");
    check_field_offset(lv, v3, 3, "B_BFu9i_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_Ul(Test_B_BFu9i_Ul, "B_BFu9i_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_Us()
{
  {
    init_simple_test("B_BFu9i_Us");
    static B_BFu9i_Us lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "B_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_Us");
    check_field_offset(lv, v3, 3, "B_BFu9i_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_Us(Test_B_BFu9i_Us, "B_BFu9i_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9i_Vp()
{
  {
    init_simple_test("B_BFu9i_Vp");
    static B_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_BFu9i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_Vp");
    check_field_offset(lv, v3, 3, "B_BFu9i_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_Vp(Test_B_BFu9i_Vp, "B_BFu9i_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll()
{
  {
    init_simple_test("B_BFu9ll");
    static B_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll(Test_B_BFu9ll, "B_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_B()
{
  {
    init_simple_test("B_BFu9ll_B");
    static B_BFu9ll_B lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_B)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_B");
    check_field_offset(lv, v3, 3, "B_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_B(Test_B_BFu9ll_B, "B_BFu9ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu15i()
{
  {
    init_simple_test("B_BFu9ll_BFu15i");
    static B_BFu9ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9ll_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu15i(Test_B_BFu9ll_BFu15i, "B_BFu9ll_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu15ll()
{
  {
    init_simple_test("B_BFu9ll_BFu15ll");
    static B_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu15ll(Test_B_BFu9ll_BFu15ll, "B_BFu9ll_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu15s()
{
  {
    init_simple_test("B_BFu9ll_BFu15s");
    static B_BFu9ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9ll_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu15s(Test_B_BFu9ll_BFu15s, "B_BFu9ll_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu16i()
{
  {
    init_simple_test("B_BFu9ll_BFu16i");
    static B_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "B_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "B_BFu9ll_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu16i(Test_B_BFu9ll_BFu16i, "B_BFu9ll_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu16ll()
{
  {
    init_simple_test("B_BFu9ll_BFu16ll");
    static B_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "B_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "B_BFu9ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu16ll(Test_B_BFu9ll_BFu16ll, "B_BFu9ll_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu16s()
{
  {
    init_simple_test("B_BFu9ll_BFu16s");
    static B_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "B_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "B_BFu9ll_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu16s(Test_B_BFu9ll_BFu16s, "B_BFu9ll_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu17i()
{
  {
    init_simple_test("B_BFu9ll_BFu17i");
    static B_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "B_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "B_BFu9ll_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu17i(Test_B_BFu9ll_BFu17i, "B_BFu9ll_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu17ll()
{
  {
    init_simple_test("B_BFu9ll_BFu17ll");
    static B_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "B_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "B_BFu9ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu17ll(Test_B_BFu9ll_BFu17ll, "B_BFu9ll_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu1c()
{
  {
    init_simple_test("B_BFu9ll_BFu1c");
    static B_BFu9ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9ll_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu1c(Test_B_BFu9ll_BFu1c, "B_BFu9ll_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu1i()
{
  {
    init_simple_test("B_BFu9ll_BFu1i");
    static B_BFu9ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9ll_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu1i(Test_B_BFu9ll_BFu1i, "B_BFu9ll_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu1ll()
{
  {
    init_simple_test("B_BFu9ll_BFu1ll");
    static B_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu1ll(Test_B_BFu9ll_BFu1ll, "B_BFu9ll_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu1s()
{
  {
    init_simple_test("B_BFu9ll_BFu1s");
    static B_BFu9ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9ll_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu1s(Test_B_BFu9ll_BFu1s, "B_BFu9ll_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu31i()
{
  {
    init_simple_test("B_BFu9ll_BFu31i");
    static B_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu9ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "B_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "B_BFu9ll_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu31i(Test_B_BFu9ll_BFu31i, "B_BFu9ll_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu31ll()
{
  {
    init_simple_test("B_BFu9ll_BFu31ll");
    static B_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "B_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "B_BFu9ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu31ll(Test_B_BFu9ll_BFu31ll, "B_BFu9ll_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu32i()
{
  {
    init_simple_test("B_BFu9ll_BFu32i");
    static B_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "B_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "B_BFu9ll_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu32i(Test_B_BFu9ll_BFu32i, "B_BFu9ll_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu32ll()
{
  {
    init_simple_test("B_BFu9ll_BFu32ll");
    static B_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "B_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "B_BFu9ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu32ll(Test_B_BFu9ll_BFu32ll, "B_BFu9ll_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu33()
{
  {
    init_simple_test("B_BFu9ll_BFu33");
    static B_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "B_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "B_BFu9ll_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu33(Test_B_BFu9ll_BFu33, "B_BFu9ll_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu7c()
{
  {
    init_simple_test("B_BFu9ll_BFu7c");
    static B_BFu9ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9ll_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu7c(Test_B_BFu9ll_BFu7c, "B_BFu9ll_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu7i()
{
  {
    init_simple_test("B_BFu9ll_BFu7i");
    static B_BFu9ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9ll_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu7i(Test_B_BFu9ll_BFu7i, "B_BFu9ll_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu7ll()
{
  {
    init_simple_test("B_BFu9ll_BFu7ll");
    static B_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu7ll(Test_B_BFu9ll_BFu7ll, "B_BFu9ll_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu7s()
{
  {
    init_simple_test("B_BFu9ll_BFu7s");
    static B_BFu9ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9ll_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu7s(Test_B_BFu9ll_BFu7s, "B_BFu9ll_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu8c()
{
  {
    init_simple_test("B_BFu9ll_BFu8c");
    static B_BFu9ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9ll_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu8c(Test_B_BFu9ll_BFu8c, "B_BFu9ll_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu8i()
{
  {
    init_simple_test("B_BFu9ll_BFu8i");
    static B_BFu9ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9ll_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu8i(Test_B_BFu9ll_BFu8i, "B_BFu9ll_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu8ll()
{
  {
    init_simple_test("B_BFu9ll_BFu8ll");
    static B_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu8ll(Test_B_BFu9ll_BFu8ll, "B_BFu9ll_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu8s()
{
  {
    init_simple_test("B_BFu9ll_BFu8s");
    static B_BFu9ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9ll_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu8s(Test_B_BFu9ll_BFu8s, "B_BFu9ll_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu9i()
{
  {
    init_simple_test("B_BFu9ll_BFu9i");
    static B_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "B_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu9i(Test_B_BFu9ll_BFu9i, "B_BFu9ll_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu9ll()
{
  {
    init_simple_test("B_BFu9ll_BFu9ll");
    static B_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "B_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu9ll(Test_B_BFu9ll_BFu9ll, "B_BFu9ll_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_BFu9s()
{
  {
    init_simple_test("B_BFu9ll_BFu9s");
    static B_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "B_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu9s(Test_B_BFu9ll_BFu9s, "B_BFu9ll_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_C()
{
  {
    init_simple_test("B_BFu9ll_C");
    static B_BFu9ll_C lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_C");
    check_field_offset(lv, v3, 3, "B_BFu9ll_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_C(Test_B_BFu9ll_C, "B_BFu9ll_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_D()
{
  {
    init_simple_test("B_BFu9ll_D");
    static B_BFu9ll_D lv;
    check2(sizeof(lv), 11, "sizeof(B_BFu9ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_D");
    check_field_offset(lv, v3, 3, "B_BFu9ll_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_D(Test_B_BFu9ll_D, "B_BFu9ll_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_F()
{
  {
    init_simple_test("B_BFu9ll_F");
    static B_BFu9ll_F lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_F");
    check_field_offset(lv, v3, 3, "B_BFu9ll_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_F(Test_B_BFu9ll_F, "B_BFu9ll_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_I()
{
  {
    init_simple_test("B_BFu9ll_I");
    static B_BFu9ll_I lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_I");
    check_field_offset(lv, v3, 3, "B_BFu9ll_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_I(Test_B_BFu9ll_I, "B_BFu9ll_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_Ip()
{
  {
    init_simple_test("B_BFu9ll_Ip");
    static B_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_BFu9ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_Ip");
    check_field_offset(lv, v3, 3, "B_BFu9ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_Ip(Test_B_BFu9ll_Ip, "B_BFu9ll_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_L()
{
  {
    init_simple_test("B_BFu9ll_L");
    static B_BFu9ll_L lv;
    check2(sizeof(lv), 11, "sizeof(B_BFu9ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_L");
    check_field_offset(lv, v3, 3, "B_BFu9ll_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_L(Test_B_BFu9ll_L, "B_BFu9ll_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_S()
{
  {
    init_simple_test("B_BFu9ll_S");
    static B_BFu9ll_S lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_S");
    check_field_offset(lv, v3, 3, "B_BFu9ll_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_S(Test_B_BFu9ll_S, "B_BFu9ll_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_Uc()
{
  {
    init_simple_test("B_BFu9ll_Uc");
    static B_BFu9ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_Uc");
    check_field_offset(lv, v3, 3, "B_BFu9ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_Uc(Test_B_BFu9ll_Uc, "B_BFu9ll_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_Ui()
{
  {
    init_simple_test("B_BFu9ll_Ui");
    static B_BFu9ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_Ui");
    check_field_offset(lv, v3, 3, "B_BFu9ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_Ui(Test_B_BFu9ll_Ui, "B_BFu9ll_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_Ul()
{
  {
    init_simple_test("B_BFu9ll_Ul");
    static B_BFu9ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(B_BFu9ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_Ul");
    check_field_offset(lv, v3, 3, "B_BFu9ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_Ul(Test_B_BFu9ll_Ul, "B_BFu9ll_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_Us()
{
  {
    init_simple_test("B_BFu9ll_Us");
    static B_BFu9ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_Us");
    check_field_offset(lv, v3, 3, "B_BFu9ll_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_Us(Test_B_BFu9ll_Us, "B_BFu9ll_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9ll_Vp()
{
  {
    init_simple_test("B_BFu9ll_Vp");
    static B_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_BFu9ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_Vp");
    check_field_offset(lv, v3, 3, "B_BFu9ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_Vp(Test_B_BFu9ll_Vp, "B_BFu9ll_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s()
{
  {
    init_simple_test("B_BFu9s");
    static B_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu9s(Test_B_BFu9s, "B_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_B()
{
  {
    init_simple_test("B_BFu9s_B");
    static B_BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_B)");
    check_field_offset(lv, v1, 0, "B_BFu9s_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_B");
    check_field_offset(lv, v3, 3, "B_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9s_B(Test_B_BFu9s_B, "B_BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu15i()
{
  {
    init_simple_test("B_BFu9s_BFu15i");
    static B_BFu9s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9s_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu15i(Test_B_BFu9s_BFu15i, "B_BFu9s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu15ll()
{
  {
    init_simple_test("B_BFu9s_BFu15ll");
    static B_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9s_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu15ll(Test_B_BFu9s_BFu15ll, "B_BFu9s_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu15s()
{
  {
    init_simple_test("B_BFu9s_BFu15s");
    static B_BFu9s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9s_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu15s(Test_B_BFu9s_BFu15s, "B_BFu9s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu16i()
{
  {
    init_simple_test("B_BFu9s_BFu16i");
    static B_BFu9s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "B_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "B_BFu9s_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu16i(Test_B_BFu9s_BFu16i, "B_BFu9s_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu16ll()
{
  {
    init_simple_test("B_BFu9s_BFu16ll");
    static B_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "B_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "B_BFu9s_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu16ll(Test_B_BFu9s_BFu16ll, "B_BFu9s_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu16s()
{
  {
    init_simple_test("B_BFu9s_BFu16s");
    static B_BFu9s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "B_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "B_BFu9s_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu16s(Test_B_BFu9s_BFu16s, "B_BFu9s_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu17i()
{
  {
    init_simple_test("B_BFu9s_BFu17i");
    static B_BFu9s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "B_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "B_BFu9s_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu17i(Test_B_BFu9s_BFu17i, "B_BFu9s_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu17ll()
{
  {
    init_simple_test("B_BFu9s_BFu17ll");
    static B_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "B_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "B_BFu9s_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu17ll(Test_B_BFu9s_BFu17ll, "B_BFu9s_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu1c()
{
  {
    init_simple_test("B_BFu9s_BFu1c");
    static B_BFu9s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9s_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu1c(Test_B_BFu9s_BFu1c, "B_BFu9s_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu1i()
{
  {
    init_simple_test("B_BFu9s_BFu1i");
    static B_BFu9s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9s_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu1i(Test_B_BFu9s_BFu1i, "B_BFu9s_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu1ll()
{
  {
    init_simple_test("B_BFu9s_BFu1ll");
    static B_BFu9s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9s_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu1ll(Test_B_BFu9s_BFu1ll, "B_BFu9s_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu1s()
{
  {
    init_simple_test("B_BFu9s_BFu1s");
    static B_BFu9s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9s_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu1s(Test_B_BFu9s_BFu1s, "B_BFu9s_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu31i()
{
  {
    init_simple_test("B_BFu9s_BFu31i");
    static B_BFu9s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu9s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "B_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "B_BFu9s_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu31i(Test_B_BFu9s_BFu31i, "B_BFu9s_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu31ll()
{
  {
    init_simple_test("B_BFu9s_BFu31ll");
    static B_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu9s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "B_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "B_BFu9s_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu31ll(Test_B_BFu9s_BFu31ll, "B_BFu9s_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu32i()
{
  {
    init_simple_test("B_BFu9s_BFu32i");
    static B_BFu9s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "B_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "B_BFu9s_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu32i(Test_B_BFu9s_BFu32i, "B_BFu9s_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu32ll()
{
  {
    init_simple_test("B_BFu9s_BFu32ll");
    static B_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "B_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "B_BFu9s_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu32ll(Test_B_BFu9s_BFu32ll, "B_BFu9s_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu33()
{
  {
    init_simple_test("B_BFu9s_BFu33");
    static B_BFu9s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "B_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "B_BFu9s_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu33(Test_B_BFu9s_BFu33, "B_BFu9s_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu7c()
{
  {
    init_simple_test("B_BFu9s_BFu7c");
    static B_BFu9s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9s_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu7c(Test_B_BFu9s_BFu7c, "B_BFu9s_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu7i()
{
  {
    init_simple_test("B_BFu9s_BFu7i");
    static B_BFu9s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9s_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu7i(Test_B_BFu9s_BFu7i, "B_BFu9s_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu7ll()
{
  {
    init_simple_test("B_BFu9s_BFu7ll");
    static B_BFu9s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9s_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu7ll(Test_B_BFu9s_BFu7ll, "B_BFu9s_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu7s()
{
  {
    init_simple_test("B_BFu9s_BFu7s");
    static B_BFu9s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu9s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9s_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu7s(Test_B_BFu9s_BFu7s, "B_BFu9s_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu8c()
{
  {
    init_simple_test("B_BFu9s_BFu8c");
    static B_BFu9s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9s_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu8c(Test_B_BFu9s_BFu8c, "B_BFu9s_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu8i()
{
  {
    init_simple_test("B_BFu9s_BFu8i");
    static B_BFu9s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9s_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu8i(Test_B_BFu9s_BFu8i, "B_BFu9s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu8ll()
{
  {
    init_simple_test("B_BFu9s_BFu8ll");
    static B_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9s_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu8ll(Test_B_BFu9s_BFu8ll, "B_BFu9s_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu8s()
{
  {
    init_simple_test("B_BFu9s_BFu8s");
    static B_BFu9s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9s_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu8s(Test_B_BFu9s_BFu8s, "B_BFu9s_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu9i()
{
  {
    init_simple_test("B_BFu9s_BFu9i");
    static B_BFu9s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "B_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "B_BFu9s_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu9i(Test_B_BFu9s_BFu9i, "B_BFu9s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu9ll()
{
  {
    init_simple_test("B_BFu9s_BFu9ll");
    static B_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "B_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "B_BFu9s_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu9ll(Test_B_BFu9s_BFu9ll, "B_BFu9s_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_BFu9s()
{
  {
    init_simple_test("B_BFu9s_BFu9s");
    static B_BFu9s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu9s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "B_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "B_BFu9s_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu9s_BFu9s(Test_B_BFu9s_BFu9s, "B_BFu9s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_C()
{
  {
    init_simple_test("B_BFu9s_C");
    static B_BFu9s_C lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9s_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_C)");
    check_field_offset(lv, v1, 0, "B_BFu9s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_C");
    check_field_offset(lv, v3, 3, "B_BFu9s_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9s_C(Test_B_BFu9s_C, "B_BFu9s_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_D()
{
  {
    init_simple_test("B_BFu9s_D");
    static B_BFu9s_D lv;
    check2(sizeof(lv), 11, "sizeof(B_BFu9s_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_D)");
    check_field_offset(lv, v1, 0, "B_BFu9s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_D");
    check_field_offset(lv, v3, 3, "B_BFu9s_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9s_D(Test_B_BFu9s_D, "B_BFu9s_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_F()
{
  {
    init_simple_test("B_BFu9s_F");
    static B_BFu9s_F lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9s_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_F)");
    check_field_offset(lv, v1, 0, "B_BFu9s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_F");
    check_field_offset(lv, v3, 3, "B_BFu9s_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9s_F(Test_B_BFu9s_F, "B_BFu9s_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_I()
{
  {
    init_simple_test("B_BFu9s_I");
    static B_BFu9s_I lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9s_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_I)");
    check_field_offset(lv, v1, 0, "B_BFu9s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_I");
    check_field_offset(lv, v3, 3, "B_BFu9s_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9s_I(Test_B_BFu9s_I, "B_BFu9s_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_Ip()
{
  {
    init_simple_test("B_BFu9s_Ip");
    static B_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_BFu9s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu9s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_Ip");
    check_field_offset(lv, v3, 3, "B_BFu9s_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9s_Ip(Test_B_BFu9s_Ip, "B_BFu9s_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_L()
{
  {
    init_simple_test("B_BFu9s_L");
    static B_BFu9s_L lv;
    check2(sizeof(lv), 11, "sizeof(B_BFu9s_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_L)");
    check_field_offset(lv, v1, 0, "B_BFu9s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_L");
    check_field_offset(lv, v3, 3, "B_BFu9s_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9s_L(Test_B_BFu9s_L, "B_BFu9s_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_S()
{
  {
    init_simple_test("B_BFu9s_S");
    static B_BFu9s_S lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9s_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_S)");
    check_field_offset(lv, v1, 0, "B_BFu9s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_S");
    check_field_offset(lv, v3, 3, "B_BFu9s_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9s_S(Test_B_BFu9s_S, "B_BFu9s_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_Uc()
{
  {
    init_simple_test("B_BFu9s_Uc");
    static B_BFu9s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu9s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_Uc");
    check_field_offset(lv, v3, 3, "B_BFu9s_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9s_Uc(Test_B_BFu9s_Uc, "B_BFu9s_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_Ui()
{
  {
    init_simple_test("B_BFu9s_Ui");
    static B_BFu9s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(B_BFu9s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu9s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_Ui");
    check_field_offset(lv, v3, 3, "B_BFu9s_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9s_Ui(Test_B_BFu9s_Ui, "B_BFu9s_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_Ul()
{
  {
    init_simple_test("B_BFu9s_Ul");
    static B_BFu9s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(B_BFu9s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu9s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_Ul");
    check_field_offset(lv, v3, 3, "B_BFu9s_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9s_Ul(Test_B_BFu9s_Ul, "B_BFu9s_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_Us()
{
  {
    init_simple_test("B_BFu9s_Us");
    static B_BFu9s_Us lv;
    check2(sizeof(lv), 5, "sizeof(B_BFu9s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_Us)");
    check_field_offset(lv, v1, 0, "B_BFu9s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_Us");
    check_field_offset(lv, v3, 3, "B_BFu9s_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9s_Us(Test_B_BFu9s_Us, "B_BFu9s_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_BFu9s_Vp()
{
  {
    init_simple_test("B_BFu9s_Vp");
    static B_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_BFu9s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu9s_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu9s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9s_Vp");
    check_field_offset(lv, v3, 3, "B_BFu9s_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9s_Vp(Test_B_BFu9s_Vp, "B_BFu9s_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C()
{
  {
    init_simple_test("B_C");
    B_C lv;
    check2(sizeof(lv), 2, "sizeof(B_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_C)");
    check_field_offset(lv, v1, 0, "B_C.v1");
    check_field_offset(lv, v2, 1, "B_C.v2");
  }
}
static Arrange_To_Call_Me vB_C(Test_B_C, "B_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_B()
{
  {
    init_simple_test("B_C_B");
    B_C_B lv;
    check2(sizeof(lv), 3, "sizeof(B_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_B)");
    check_field_offset(lv, v1, 0, "B_C_B.v1");
    check_field_offset(lv, v2, 1, "B_C_B.v2");
    check_field_offset(lv, v3, 2, "B_C_B.v3");
  }
}
static Arrange_To_Call_Me vB_C_B(Test_B_C_B, "B_C_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu15i()
{
  {
    init_simple_test("B_C_BFu15i");
    static B_C_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_C_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu15i)");
    check_field_offset(lv, v1, 0, "B_C_BFu15i.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_C_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_C_BFu15i");
  }
}
static Arrange_To_Call_Me vB_C_BFu15i(Test_B_C_BFu15i, "B_C_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu15ll()
{
  {
    init_simple_test("B_C_BFu15ll");
    static B_C_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(B_C_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_C_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_C_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_C_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_C_BFu15ll(Test_B_C_BFu15ll, "B_C_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu15s()
{
  {
    init_simple_test("B_C_BFu15s");
    static B_C_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_C_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu15s)");
    check_field_offset(lv, v1, 0, "B_C_BFu15s.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_C_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_C_BFu15s");
  }
}
static Arrange_To_Call_Me vB_C_BFu15s(Test_B_C_BFu15s, "B_C_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu16i()
{
  {
    init_simple_test("B_C_BFu16i");
    static B_C_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_C_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu16i)");
    check_field_offset(lv, v1, 0, "B_C_BFu16i.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_C_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_C_BFu16i");
  }
}
static Arrange_To_Call_Me vB_C_BFu16i(Test_B_C_BFu16i, "B_C_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu16ll()
{
  {
    init_simple_test("B_C_BFu16ll");
    static B_C_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(B_C_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_C_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_C_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_C_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_C_BFu16ll(Test_B_C_BFu16ll, "B_C_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu16s()
{
  {
    init_simple_test("B_C_BFu16s");
    static B_C_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_C_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu16s)");
    check_field_offset(lv, v1, 0, "B_C_BFu16s.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_C_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_C_BFu16s");
  }
}
static Arrange_To_Call_Me vB_C_BFu16s(Test_B_C_BFu16s, "B_C_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu17i()
{
  {
    init_simple_test("B_C_BFu17i");
    static B_C_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(B_C_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu17i)");
    check_field_offset(lv, v1, 0, "B_C_BFu17i.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "B_C_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "B_C_BFu17i");
  }
}
static Arrange_To_Call_Me vB_C_BFu17i(Test_B_C_BFu17i, "B_C_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu17ll()
{
  {
    init_simple_test("B_C_BFu17ll");
    static B_C_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(B_C_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_C_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "B_C_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "B_C_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_C_BFu17ll(Test_B_C_BFu17ll, "B_C_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu1c()
{
  {
    init_simple_test("B_C_BFu1c");
    static B_C_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(B_C_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu1c)");
    check_field_offset(lv, v1, 0, "B_C_BFu1c.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_C_BFu1c");
  }
}
static Arrange_To_Call_Me vB_C_BFu1c(Test_B_C_BFu1c, "B_C_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu1i()
{
  {
    init_simple_test("B_C_BFu1i");
    static B_C_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(B_C_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu1i)");
    check_field_offset(lv, v1, 0, "B_C_BFu1i.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_C_BFu1i");
  }
}
static Arrange_To_Call_Me vB_C_BFu1i(Test_B_C_BFu1i, "B_C_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu1ll()
{
  {
    init_simple_test("B_C_BFu1ll");
    static B_C_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(B_C_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_C_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_C_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_C_BFu1ll(Test_B_C_BFu1ll, "B_C_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu1s()
{
  {
    init_simple_test("B_C_BFu1s");
    static B_C_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(B_C_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu1s)");
    check_field_offset(lv, v1, 0, "B_C_BFu1s.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_C_BFu1s");
  }
}
static Arrange_To_Call_Me vB_C_BFu1s(Test_B_C_BFu1s, "B_C_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu31i()
{
  {
    init_simple_test("B_C_BFu31i");
    static B_C_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(B_C_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu31i)");
    check_field_offset(lv, v1, 0, "B_C_BFu31i.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "B_C_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "B_C_BFu31i");
  }
}
static Arrange_To_Call_Me vB_C_BFu31i(Test_B_C_BFu31i, "B_C_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu31ll()
{
  {
    init_simple_test("B_C_BFu31ll");
    static B_C_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(B_C_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_C_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "B_C_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "B_C_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_C_BFu31ll(Test_B_C_BFu31ll, "B_C_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu32i()
{
  {
    init_simple_test("B_C_BFu32i");
    static B_C_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(B_C_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu32i)");
    check_field_offset(lv, v1, 0, "B_C_BFu32i.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "B_C_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "B_C_BFu32i");
  }
}
static Arrange_To_Call_Me vB_C_BFu32i(Test_B_C_BFu32i, "B_C_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu32ll()
{
  {
    init_simple_test("B_C_BFu32ll");
    static B_C_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(B_C_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_C_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "B_C_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "B_C_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_C_BFu32ll(Test_B_C_BFu32ll, "B_C_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu33()
{
  {
    init_simple_test("B_C_BFu33");
    static B_C_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(B_C_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu33)");
    check_field_offset(lv, v1, 0, "B_C_BFu33.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "B_C_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "B_C_BFu33");
  }
}
static Arrange_To_Call_Me vB_C_BFu33(Test_B_C_BFu33, "B_C_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu7c()
{
  {
    init_simple_test("B_C_BFu7c");
    static B_C_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(B_C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu7c)");
    check_field_offset(lv, v1, 0, "B_C_BFu7c.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_C_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_C_BFu7c");
  }
}
static Arrange_To_Call_Me vB_C_BFu7c(Test_B_C_BFu7c, "B_C_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu7i()
{
  {
    init_simple_test("B_C_BFu7i");
    static B_C_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(B_C_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu7i)");
    check_field_offset(lv, v1, 0, "B_C_BFu7i.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_C_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_C_BFu7i");
  }
}
static Arrange_To_Call_Me vB_C_BFu7i(Test_B_C_BFu7i, "B_C_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu7ll()
{
  {
    init_simple_test("B_C_BFu7ll");
    static B_C_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(B_C_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_C_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_C_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_C_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_C_BFu7ll(Test_B_C_BFu7ll, "B_C_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu7s()
{
  {
    init_simple_test("B_C_BFu7s");
    static B_C_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(B_C_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu7s)");
    check_field_offset(lv, v1, 0, "B_C_BFu7s.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_C_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_C_BFu7s");
  }
}
static Arrange_To_Call_Me vB_C_BFu7s(Test_B_C_BFu7s, "B_C_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu8c()
{
  {
    init_simple_test("B_C_BFu8c");
    static B_C_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(B_C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu8c)");
    check_field_offset(lv, v1, 0, "B_C_BFu8c.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_C_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_C_BFu8c");
  }
}
static Arrange_To_Call_Me vB_C_BFu8c(Test_B_C_BFu8c, "B_C_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu8i()
{
  {
    init_simple_test("B_C_BFu8i");
    static B_C_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(B_C_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu8i)");
    check_field_offset(lv, v1, 0, "B_C_BFu8i.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_C_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_C_BFu8i");
  }
}
static Arrange_To_Call_Me vB_C_BFu8i(Test_B_C_BFu8i, "B_C_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu8ll()
{
  {
    init_simple_test("B_C_BFu8ll");
    static B_C_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(B_C_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_C_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_C_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_C_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_C_BFu8ll(Test_B_C_BFu8ll, "B_C_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu8s()
{
  {
    init_simple_test("B_C_BFu8s");
    static B_C_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(B_C_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu8s)");
    check_field_offset(lv, v1, 0, "B_C_BFu8s.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_C_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_C_BFu8s");
  }
}
static Arrange_To_Call_Me vB_C_BFu8s(Test_B_C_BFu8s, "B_C_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu9i()
{
  {
    init_simple_test("B_C_BFu9i");
    static B_C_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_C_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu9i)");
    check_field_offset(lv, v1, 0, "B_C_BFu9i.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_C_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_C_BFu9i");
  }
}
static Arrange_To_Call_Me vB_C_BFu9i(Test_B_C_BFu9i, "B_C_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu9ll()
{
  {
    init_simple_test("B_C_BFu9ll");
    static B_C_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(B_C_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_C_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_C_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_C_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_C_BFu9ll(Test_B_C_BFu9ll, "B_C_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_BFu9s()
{
  {
    init_simple_test("B_C_BFu9s");
    static B_C_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_C_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_BFu9s)");
    check_field_offset(lv, v1, 0, "B_C_BFu9s.v1");
    check_field_offset(lv, v2, 1, "B_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_C_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_C_BFu9s");
  }
}
static Arrange_To_Call_Me vB_C_BFu9s(Test_B_C_BFu9s, "B_C_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_C()
{
  {
    init_simple_test("B_C_C");
    B_C_C lv;
    check2(sizeof(lv), 3, "sizeof(B_C_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_C)");
    check_field_offset(lv, v1, 0, "B_C_C.v1");
    check_field_offset(lv, v2, 1, "B_C_C.v2");
    check_field_offset(lv, v3, 2, "B_C_C.v3");
  }
}
static Arrange_To_Call_Me vB_C_C(Test_B_C_C, "B_C_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_D()
{
  {
    init_simple_test("B_C_D");
    B_C_D lv;
    check2(sizeof(lv), 10, "sizeof(B_C_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_D)");
    check_field_offset(lv, v1, 0, "B_C_D.v1");
    check_field_offset(lv, v2, 1, "B_C_D.v2");
    check_field_offset(lv, v3, 2, "B_C_D.v3");
  }
}
static Arrange_To_Call_Me vB_C_D(Test_B_C_D, "B_C_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_F()
{
  {
    init_simple_test("B_C_F");
    B_C_F lv;
    check2(sizeof(lv), 6, "sizeof(B_C_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_F)");
    check_field_offset(lv, v1, 0, "B_C_F.v1");
    check_field_offset(lv, v2, 1, "B_C_F.v2");
    check_field_offset(lv, v3, 2, "B_C_F.v3");
  }
}
static Arrange_To_Call_Me vB_C_F(Test_B_C_F, "B_C_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_I()
{
  {
    init_simple_test("B_C_I");
    B_C_I lv;
    check2(sizeof(lv), 6, "sizeof(B_C_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_I)");
    check_field_offset(lv, v1, 0, "B_C_I.v1");
    check_field_offset(lv, v2, 1, "B_C_I.v2");
    check_field_offset(lv, v3, 2, "B_C_I.v3");
  }
}
static Arrange_To_Call_Me vB_C_I(Test_B_C_I, "B_C_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_Ip()
{
  {
    init_simple_test("B_C_Ip");
    B_C_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_C_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_Ip)");
    check_field_offset(lv, v1, 0, "B_C_Ip.v1");
    check_field_offset(lv, v2, 1, "B_C_Ip.v2");
    check_field_offset(lv, v3, 2, "B_C_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_C_Ip(Test_B_C_Ip, "B_C_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_L()
{
  {
    init_simple_test("B_C_L");
    B_C_L lv;
    check2(sizeof(lv), 10, "sizeof(B_C_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_L)");
    check_field_offset(lv, v1, 0, "B_C_L.v1");
    check_field_offset(lv, v2, 1, "B_C_L.v2");
    check_field_offset(lv, v3, 2, "B_C_L.v3");
  }
}
static Arrange_To_Call_Me vB_C_L(Test_B_C_L, "B_C_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_S()
{
  {
    init_simple_test("B_C_S");
    B_C_S lv;
    check2(sizeof(lv), 4, "sizeof(B_C_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_S)");
    check_field_offset(lv, v1, 0, "B_C_S.v1");
    check_field_offset(lv, v2, 1, "B_C_S.v2");
    check_field_offset(lv, v3, 2, "B_C_S.v3");
  }
}
static Arrange_To_Call_Me vB_C_S(Test_B_C_S, "B_C_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_Uc()
{
  {
    init_simple_test("B_C_Uc");
    B_C_Uc lv;
    check2(sizeof(lv), 3, "sizeof(B_C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_Uc)");
    check_field_offset(lv, v1, 0, "B_C_Uc.v1");
    check_field_offset(lv, v2, 1, "B_C_Uc.v2");
    check_field_offset(lv, v3, 2, "B_C_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_C_Uc(Test_B_C_Uc, "B_C_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_Ui()
{
  {
    init_simple_test("B_C_Ui");
    B_C_Ui lv;
    check2(sizeof(lv), 6, "sizeof(B_C_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_Ui)");
    check_field_offset(lv, v1, 0, "B_C_Ui.v1");
    check_field_offset(lv, v2, 1, "B_C_Ui.v2");
    check_field_offset(lv, v3, 2, "B_C_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_C_Ui(Test_B_C_Ui, "B_C_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_Ul()
{
  {
    init_simple_test("B_C_Ul");
    B_C_Ul lv;
    check2(sizeof(lv), 10, "sizeof(B_C_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_Ul)");
    check_field_offset(lv, v1, 0, "B_C_Ul.v1");
    check_field_offset(lv, v2, 1, "B_C_Ul.v2");
    check_field_offset(lv, v3, 2, "B_C_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_C_Ul(Test_B_C_Ul, "B_C_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_Us()
{
  {
    init_simple_test("B_C_Us");
    B_C_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_C_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_Us)");
    check_field_offset(lv, v1, 0, "B_C_Us.v1");
    check_field_offset(lv, v2, 1, "B_C_Us.v2");
    check_field_offset(lv, v3, 2, "B_C_Us.v3");
  }
}
static Arrange_To_Call_Me vB_C_Us(Test_B_C_Us, "B_C_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_C_Vp()
{
  {
    init_simple_test("B_C_Vp");
    B_C_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_C_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_C_Vp)");
    check_field_offset(lv, v1, 0, "B_C_Vp.v1");
    check_field_offset(lv, v2, 1, "B_C_Vp.v2");
    check_field_offset(lv, v3, 2, "B_C_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_C_Vp(Test_B_C_Vp, "B_C_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D()
{
  {
    init_simple_test("B_D");
    B_D lv;
    check2(sizeof(lv), 9, "sizeof(B_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_D)");
    check_field_offset(lv, v1, 0, "B_D.v1");
    check_field_offset(lv, v2, 1, "B_D.v2");
  }
}
static Arrange_To_Call_Me vB_D(Test_B_D, "B_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_B()
{
  {
    init_simple_test("B_D_B");
    B_D_B lv;
    check2(sizeof(lv), 10, "sizeof(B_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_B)");
    check_field_offset(lv, v1, 0, "B_D_B.v1");
    check_field_offset(lv, v2, 1, "B_D_B.v2");
    check_field_offset(lv, v3, 9, "B_D_B.v3");
  }
}
static Arrange_To_Call_Me vB_D_B(Test_B_D_B, "B_D_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu15i()
{
  {
    init_simple_test("B_D_BFu15i");
    static B_D_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(B_D_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu15i)");
    check_field_offset(lv, v1, 0, "B_D_BFu15i.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "B_D_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "B_D_BFu15i");
  }
}
static Arrange_To_Call_Me vB_D_BFu15i(Test_B_D_BFu15i, "B_D_BFu15i", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu15ll()
{
  {
    init_simple_test("B_D_BFu15ll");
    static B_D_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(B_D_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_D_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "B_D_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "B_D_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_D_BFu15ll(Test_B_D_BFu15ll, "B_D_BFu15ll", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu15s()
{
  {
    init_simple_test("B_D_BFu15s");
    static B_D_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(B_D_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu15s)");
    check_field_offset(lv, v1, 0, "B_D_BFu15s.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "B_D_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "B_D_BFu15s");
  }
}
static Arrange_To_Call_Me vB_D_BFu15s(Test_B_D_BFu15s, "B_D_BFu15s", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu16i()
{
  {
    init_simple_test("B_D_BFu16i");
    static B_D_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(B_D_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu16i)");
    check_field_offset(lv, v1, 0, "B_D_BFu16i.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "B_D_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "B_D_BFu16i");
  }
}
static Arrange_To_Call_Me vB_D_BFu16i(Test_B_D_BFu16i, "B_D_BFu16i", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu16ll()
{
  {
    init_simple_test("B_D_BFu16ll");
    static B_D_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(B_D_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_D_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "B_D_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "B_D_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_D_BFu16ll(Test_B_D_BFu16ll, "B_D_BFu16ll", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu16s()
{
  {
    init_simple_test("B_D_BFu16s");
    static B_D_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(B_D_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu16s)");
    check_field_offset(lv, v1, 0, "B_D_BFu16s.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "B_D_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "B_D_BFu16s");
  }
}
static Arrange_To_Call_Me vB_D_BFu16s(Test_B_D_BFu16s, "B_D_BFu16s", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu17i()
{
  {
    init_simple_test("B_D_BFu17i");
    static B_D_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(B_D_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu17i)");
    check_field_offset(lv, v1, 0, "B_D_BFu17i.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "B_D_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "B_D_BFu17i");
  }
}
static Arrange_To_Call_Me vB_D_BFu17i(Test_B_D_BFu17i, "B_D_BFu17i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu17ll()
{
  {
    init_simple_test("B_D_BFu17ll");
    static B_D_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(B_D_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_D_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "B_D_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "B_D_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_D_BFu17ll(Test_B_D_BFu17ll, "B_D_BFu17ll", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu1c()
{
  {
    init_simple_test("B_D_BFu1c");
    static B_D_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(B_D_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu1c)");
    check_field_offset(lv, v1, 0, "B_D_BFu1c.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "B_D_BFu1c");
  }
}
static Arrange_To_Call_Me vB_D_BFu1c(Test_B_D_BFu1c, "B_D_BFu1c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu1i()
{
  {
    init_simple_test("B_D_BFu1i");
    static B_D_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(B_D_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu1i)");
    check_field_offset(lv, v1, 0, "B_D_BFu1i.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "B_D_BFu1i");
  }
}
static Arrange_To_Call_Me vB_D_BFu1i(Test_B_D_BFu1i, "B_D_BFu1i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu1ll()
{
  {
    init_simple_test("B_D_BFu1ll");
    static B_D_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(B_D_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_D_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "B_D_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_D_BFu1ll(Test_B_D_BFu1ll, "B_D_BFu1ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu1s()
{
  {
    init_simple_test("B_D_BFu1s");
    static B_D_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(B_D_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu1s)");
    check_field_offset(lv, v1, 0, "B_D_BFu1s.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "B_D_BFu1s");
  }
}
static Arrange_To_Call_Me vB_D_BFu1s(Test_B_D_BFu1s, "B_D_BFu1s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu31i()
{
  {
    init_simple_test("B_D_BFu31i");
    static B_D_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(B_D_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu31i)");
    check_field_offset(lv, v1, 0, "B_D_BFu31i.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "B_D_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "B_D_BFu31i");
  }
}
static Arrange_To_Call_Me vB_D_BFu31i(Test_B_D_BFu31i, "B_D_BFu31i", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu31ll()
{
  {
    init_simple_test("B_D_BFu31ll");
    static B_D_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(B_D_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_D_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "B_D_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "B_D_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_D_BFu31ll(Test_B_D_BFu31ll, "B_D_BFu31ll", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu32i()
{
  {
    init_simple_test("B_D_BFu32i");
    static B_D_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(B_D_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu32i)");
    check_field_offset(lv, v1, 0, "B_D_BFu32i.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "B_D_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "B_D_BFu32i");
  }
}
static Arrange_To_Call_Me vB_D_BFu32i(Test_B_D_BFu32i, "B_D_BFu32i", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu32ll()
{
  {
    init_simple_test("B_D_BFu32ll");
    static B_D_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(B_D_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_D_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "B_D_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "B_D_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_D_BFu32ll(Test_B_D_BFu32ll, "B_D_BFu32ll", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu33()
{
  {
    init_simple_test("B_D_BFu33");
    static B_D_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(B_D_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu33)");
    check_field_offset(lv, v1, 0, "B_D_BFu33.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "B_D_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "B_D_BFu33");
  }
}
static Arrange_To_Call_Me vB_D_BFu33(Test_B_D_BFu33, "B_D_BFu33", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu7c()
{
  {
    init_simple_test("B_D_BFu7c");
    static B_D_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(B_D_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu7c)");
    check_field_offset(lv, v1, 0, "B_D_BFu7c.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "B_D_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "B_D_BFu7c");
  }
}
static Arrange_To_Call_Me vB_D_BFu7c(Test_B_D_BFu7c, "B_D_BFu7c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu7i()
{
  {
    init_simple_test("B_D_BFu7i");
    static B_D_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(B_D_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu7i)");
    check_field_offset(lv, v1, 0, "B_D_BFu7i.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "B_D_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "B_D_BFu7i");
  }
}
static Arrange_To_Call_Me vB_D_BFu7i(Test_B_D_BFu7i, "B_D_BFu7i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu7ll()
{
  {
    init_simple_test("B_D_BFu7ll");
    static B_D_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(B_D_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_D_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "B_D_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "B_D_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_D_BFu7ll(Test_B_D_BFu7ll, "B_D_BFu7ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu7s()
{
  {
    init_simple_test("B_D_BFu7s");
    static B_D_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(B_D_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu7s)");
    check_field_offset(lv, v1, 0, "B_D_BFu7s.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "B_D_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "B_D_BFu7s");
  }
}
static Arrange_To_Call_Me vB_D_BFu7s(Test_B_D_BFu7s, "B_D_BFu7s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu8c()
{
  {
    init_simple_test("B_D_BFu8c");
    static B_D_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(B_D_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu8c)");
    check_field_offset(lv, v1, 0, "B_D_BFu8c.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "B_D_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "B_D_BFu8c");
  }
}
static Arrange_To_Call_Me vB_D_BFu8c(Test_B_D_BFu8c, "B_D_BFu8c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu8i()
{
  {
    init_simple_test("B_D_BFu8i");
    static B_D_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(B_D_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu8i)");
    check_field_offset(lv, v1, 0, "B_D_BFu8i.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "B_D_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "B_D_BFu8i");
  }
}
static Arrange_To_Call_Me vB_D_BFu8i(Test_B_D_BFu8i, "B_D_BFu8i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu8ll()
{
  {
    init_simple_test("B_D_BFu8ll");
    static B_D_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(B_D_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_D_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "B_D_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "B_D_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_D_BFu8ll(Test_B_D_BFu8ll, "B_D_BFu8ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu8s()
{
  {
    init_simple_test("B_D_BFu8s");
    static B_D_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(B_D_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu8s)");
    check_field_offset(lv, v1, 0, "B_D_BFu8s.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "B_D_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "B_D_BFu8s");
  }
}
static Arrange_To_Call_Me vB_D_BFu8s(Test_B_D_BFu8s, "B_D_BFu8s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu9i()
{
  {
    init_simple_test("B_D_BFu9i");
    static B_D_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(B_D_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu9i)");
    check_field_offset(lv, v1, 0, "B_D_BFu9i.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "B_D_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "B_D_BFu9i");
  }
}
static Arrange_To_Call_Me vB_D_BFu9i(Test_B_D_BFu9i, "B_D_BFu9i", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu9ll()
{
  {
    init_simple_test("B_D_BFu9ll");
    static B_D_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(B_D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_D_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "B_D_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "B_D_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_D_BFu9ll(Test_B_D_BFu9ll, "B_D_BFu9ll", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_BFu9s()
{
  {
    init_simple_test("B_D_BFu9s");
    static B_D_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(B_D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_BFu9s)");
    check_field_offset(lv, v1, 0, "B_D_BFu9s.v1");
    check_field_offset(lv, v2, 1, "B_D_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "B_D_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "B_D_BFu9s");
  }
}
static Arrange_To_Call_Me vB_D_BFu9s(Test_B_D_BFu9s, "B_D_BFu9s", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_C()
{
  {
    init_simple_test("B_D_C");
    B_D_C lv;
    check2(sizeof(lv), 10, "sizeof(B_D_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_C)");
    check_field_offset(lv, v1, 0, "B_D_C.v1");
    check_field_offset(lv, v2, 1, "B_D_C.v2");
    check_field_offset(lv, v3, 9, "B_D_C.v3");
  }
}
static Arrange_To_Call_Me vB_D_C(Test_B_D_C, "B_D_C", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_D()
{
  {
    init_simple_test("B_D_D");
    B_D_D lv;
    check2(sizeof(lv), 17, "sizeof(B_D_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_D)");
    check_field_offset(lv, v1, 0, "B_D_D.v1");
    check_field_offset(lv, v2, 1, "B_D_D.v2");
    check_field_offset(lv, v3, 9, "B_D_D.v3");
  }
}
static Arrange_To_Call_Me vB_D_D(Test_B_D_D, "B_D_D", 17);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_F()
{
  {
    init_simple_test("B_D_F");
    B_D_F lv;
    check2(sizeof(lv), 13, "sizeof(B_D_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_F)");
    check_field_offset(lv, v1, 0, "B_D_F.v1");
    check_field_offset(lv, v2, 1, "B_D_F.v2");
    check_field_offset(lv, v3, 9, "B_D_F.v3");
  }
}
static Arrange_To_Call_Me vB_D_F(Test_B_D_F, "B_D_F", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_I()
{
  {
    init_simple_test("B_D_I");
    B_D_I lv;
    check2(sizeof(lv), 13, "sizeof(B_D_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_I)");
    check_field_offset(lv, v1, 0, "B_D_I.v1");
    check_field_offset(lv, v2, 1, "B_D_I.v2");
    check_field_offset(lv, v3, 9, "B_D_I.v3");
  }
}
static Arrange_To_Call_Me vB_D_I(Test_B_D_I, "B_D_I", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_Ip()
{
  {
    init_simple_test("B_D_Ip");
    B_D_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(B_D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_Ip)");
    check_field_offset(lv, v1, 0, "B_D_Ip.v1");
    check_field_offset(lv, v2, 1, "B_D_Ip.v2");
    check_field_offset(lv, v3, 9, "B_D_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_D_Ip(Test_B_D_Ip, "B_D_Ip", ABISELECT(17,13));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_L()
{
  {
    init_simple_test("B_D_L");
    B_D_L lv;
    check2(sizeof(lv), 17, "sizeof(B_D_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_L)");
    check_field_offset(lv, v1, 0, "B_D_L.v1");
    check_field_offset(lv, v2, 1, "B_D_L.v2");
    check_field_offset(lv, v3, 9, "B_D_L.v3");
  }
}
static Arrange_To_Call_Me vB_D_L(Test_B_D_L, "B_D_L", 17);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_S()
{
  {
    init_simple_test("B_D_S");
    B_D_S lv;
    check2(sizeof(lv), 11, "sizeof(B_D_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_S)");
    check_field_offset(lv, v1, 0, "B_D_S.v1");
    check_field_offset(lv, v2, 1, "B_D_S.v2");
    check_field_offset(lv, v3, 9, "B_D_S.v3");
  }
}
static Arrange_To_Call_Me vB_D_S(Test_B_D_S, "B_D_S", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_Uc()
{
  {
    init_simple_test("B_D_Uc");
    B_D_Uc lv;
    check2(sizeof(lv), 10, "sizeof(B_D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_Uc)");
    check_field_offset(lv, v1, 0, "B_D_Uc.v1");
    check_field_offset(lv, v2, 1, "B_D_Uc.v2");
    check_field_offset(lv, v3, 9, "B_D_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_D_Uc(Test_B_D_Uc, "B_D_Uc", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_Ui()
{
  {
    init_simple_test("B_D_Ui");
    B_D_Ui lv;
    check2(sizeof(lv), 13, "sizeof(B_D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_Ui)");
    check_field_offset(lv, v1, 0, "B_D_Ui.v1");
    check_field_offset(lv, v2, 1, "B_D_Ui.v2");
    check_field_offset(lv, v3, 9, "B_D_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_D_Ui(Test_B_D_Ui, "B_D_Ui", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_Ul()
{
  {
    init_simple_test("B_D_Ul");
    B_D_Ul lv;
    check2(sizeof(lv), 17, "sizeof(B_D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_Ul)");
    check_field_offset(lv, v1, 0, "B_D_Ul.v1");
    check_field_offset(lv, v2, 1, "B_D_Ul.v2");
    check_field_offset(lv, v3, 9, "B_D_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_D_Ul(Test_B_D_Ul, "B_D_Ul", 17);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_Us()
{
  {
    init_simple_test("B_D_Us");
    B_D_Us lv;
    check2(sizeof(lv), 11, "sizeof(B_D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_Us)");
    check_field_offset(lv, v1, 0, "B_D_Us.v1");
    check_field_offset(lv, v2, 1, "B_D_Us.v2");
    check_field_offset(lv, v3, 9, "B_D_Us.v3");
  }
}
static Arrange_To_Call_Me vB_D_Us(Test_B_D_Us, "B_D_Us", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_D_Vp()
{
  {
    init_simple_test("B_D_Vp");
    B_D_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(B_D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_D_Vp)");
    check_field_offset(lv, v1, 0, "B_D_Vp.v1");
    check_field_offset(lv, v2, 1, "B_D_Vp.v2");
    check_field_offset(lv, v3, 9, "B_D_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_D_Vp(Test_B_D_Vp, "B_D_Vp", ABISELECT(17,13));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F()
{
  {
    init_simple_test("B_F");
    B_F lv;
    check2(sizeof(lv), 5, "sizeof(B_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_F)");
    check_field_offset(lv, v1, 0, "B_F.v1");
    check_field_offset(lv, v2, 1, "B_F.v2");
  }
}
static Arrange_To_Call_Me vB_F(Test_B_F, "B_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_B()
{
  {
    init_simple_test("B_F_B");
    B_F_B lv;
    check2(sizeof(lv), 6, "sizeof(B_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_B)");
    check_field_offset(lv, v1, 0, "B_F_B.v1");
    check_field_offset(lv, v2, 1, "B_F_B.v2");
    check_field_offset(lv, v3, 5, "B_F_B.v3");
  }
}
static Arrange_To_Call_Me vB_F_B(Test_B_F_B, "B_F_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu15i()
{
  {
    init_simple_test("B_F_BFu15i");
    static B_F_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(B_F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu15i)");
    check_field_offset(lv, v1, 0, "B_F_BFu15i.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "B_F_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "B_F_BFu15i");
  }
}
static Arrange_To_Call_Me vB_F_BFu15i(Test_B_F_BFu15i, "B_F_BFu15i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu15ll()
{
  {
    init_simple_test("B_F_BFu15ll");
    static B_F_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(B_F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_F_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "B_F_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "B_F_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_F_BFu15ll(Test_B_F_BFu15ll, "B_F_BFu15ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu15s()
{
  {
    init_simple_test("B_F_BFu15s");
    static B_F_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(B_F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu15s)");
    check_field_offset(lv, v1, 0, "B_F_BFu15s.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "B_F_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "B_F_BFu15s");
  }
}
static Arrange_To_Call_Me vB_F_BFu15s(Test_B_F_BFu15s, "B_F_BFu15s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu16i()
{
  {
    init_simple_test("B_F_BFu16i");
    static B_F_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(B_F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu16i)");
    check_field_offset(lv, v1, 0, "B_F_BFu16i.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "B_F_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "B_F_BFu16i");
  }
}
static Arrange_To_Call_Me vB_F_BFu16i(Test_B_F_BFu16i, "B_F_BFu16i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu16ll()
{
  {
    init_simple_test("B_F_BFu16ll");
    static B_F_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(B_F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_F_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "B_F_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "B_F_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_F_BFu16ll(Test_B_F_BFu16ll, "B_F_BFu16ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu16s()
{
  {
    init_simple_test("B_F_BFu16s");
    static B_F_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(B_F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu16s)");
    check_field_offset(lv, v1, 0, "B_F_BFu16s.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "B_F_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "B_F_BFu16s");
  }
}
static Arrange_To_Call_Me vB_F_BFu16s(Test_B_F_BFu16s, "B_F_BFu16s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu17i()
{
  {
    init_simple_test("B_F_BFu17i");
    static B_F_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu17i)");
    check_field_offset(lv, v1, 0, "B_F_BFu17i.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "B_F_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "B_F_BFu17i");
  }
}
static Arrange_To_Call_Me vB_F_BFu17i(Test_B_F_BFu17i, "B_F_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu17ll()
{
  {
    init_simple_test("B_F_BFu17ll");
    static B_F_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_F_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "B_F_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "B_F_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_F_BFu17ll(Test_B_F_BFu17ll, "B_F_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu1c()
{
  {
    init_simple_test("B_F_BFu1c");
    static B_F_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(B_F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu1c)");
    check_field_offset(lv, v1, 0, "B_F_BFu1c.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_F_BFu1c");
  }
}
static Arrange_To_Call_Me vB_F_BFu1c(Test_B_F_BFu1c, "B_F_BFu1c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu1i()
{
  {
    init_simple_test("B_F_BFu1i");
    static B_F_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(B_F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu1i)");
    check_field_offset(lv, v1, 0, "B_F_BFu1i.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_F_BFu1i");
  }
}
static Arrange_To_Call_Me vB_F_BFu1i(Test_B_F_BFu1i, "B_F_BFu1i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu1ll()
{
  {
    init_simple_test("B_F_BFu1ll");
    static B_F_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(B_F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_F_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_F_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_F_BFu1ll(Test_B_F_BFu1ll, "B_F_BFu1ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu1s()
{
  {
    init_simple_test("B_F_BFu1s");
    static B_F_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(B_F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu1s)");
    check_field_offset(lv, v1, 0, "B_F_BFu1s.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_F_BFu1s");
  }
}
static Arrange_To_Call_Me vB_F_BFu1s(Test_B_F_BFu1s, "B_F_BFu1s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu31i()
{
  {
    init_simple_test("B_F_BFu31i");
    static B_F_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(B_F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu31i)");
    check_field_offset(lv, v1, 0, "B_F_BFu31i.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "B_F_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "B_F_BFu31i");
  }
}
static Arrange_To_Call_Me vB_F_BFu31i(Test_B_F_BFu31i, "B_F_BFu31i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu31ll()
{
  {
    init_simple_test("B_F_BFu31ll");
    static B_F_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(B_F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_F_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "B_F_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "B_F_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_F_BFu31ll(Test_B_F_BFu31ll, "B_F_BFu31ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu32i()
{
  {
    init_simple_test("B_F_BFu32i");
    static B_F_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(B_F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu32i)");
    check_field_offset(lv, v1, 0, "B_F_BFu32i.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "B_F_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "B_F_BFu32i");
  }
}
static Arrange_To_Call_Me vB_F_BFu32i(Test_B_F_BFu32i, "B_F_BFu32i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu32ll()
{
  {
    init_simple_test("B_F_BFu32ll");
    static B_F_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(B_F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_F_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "B_F_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "B_F_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_F_BFu32ll(Test_B_F_BFu32ll, "B_F_BFu32ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu33()
{
  {
    init_simple_test("B_F_BFu33");
    static B_F_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(B_F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu33)");
    check_field_offset(lv, v1, 0, "B_F_BFu33.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "B_F_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "B_F_BFu33");
  }
}
static Arrange_To_Call_Me vB_F_BFu33(Test_B_F_BFu33, "B_F_BFu33", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu7c()
{
  {
    init_simple_test("B_F_BFu7c");
    static B_F_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(B_F_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu7c)");
    check_field_offset(lv, v1, 0, "B_F_BFu7c.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_F_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_F_BFu7c");
  }
}
static Arrange_To_Call_Me vB_F_BFu7c(Test_B_F_BFu7c, "B_F_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu7i()
{
  {
    init_simple_test("B_F_BFu7i");
    static B_F_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(B_F_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu7i)");
    check_field_offset(lv, v1, 0, "B_F_BFu7i.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_F_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_F_BFu7i");
  }
}
static Arrange_To_Call_Me vB_F_BFu7i(Test_B_F_BFu7i, "B_F_BFu7i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu7ll()
{
  {
    init_simple_test("B_F_BFu7ll");
    static B_F_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(B_F_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_F_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_F_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_F_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_F_BFu7ll(Test_B_F_BFu7ll, "B_F_BFu7ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu7s()
{
  {
    init_simple_test("B_F_BFu7s");
    static B_F_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(B_F_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu7s)");
    check_field_offset(lv, v1, 0, "B_F_BFu7s.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_F_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_F_BFu7s");
  }
}
static Arrange_To_Call_Me vB_F_BFu7s(Test_B_F_BFu7s, "B_F_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu8c()
{
  {
    init_simple_test("B_F_BFu8c");
    static B_F_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(B_F_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu8c)");
    check_field_offset(lv, v1, 0, "B_F_BFu8c.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_F_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_F_BFu8c");
  }
}
static Arrange_To_Call_Me vB_F_BFu8c(Test_B_F_BFu8c, "B_F_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu8i()
{
  {
    init_simple_test("B_F_BFu8i");
    static B_F_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(B_F_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu8i)");
    check_field_offset(lv, v1, 0, "B_F_BFu8i.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_F_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_F_BFu8i");
  }
}
static Arrange_To_Call_Me vB_F_BFu8i(Test_B_F_BFu8i, "B_F_BFu8i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu8ll()
{
  {
    init_simple_test("B_F_BFu8ll");
    static B_F_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(B_F_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_F_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_F_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_F_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_F_BFu8ll(Test_B_F_BFu8ll, "B_F_BFu8ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu8s()
{
  {
    init_simple_test("B_F_BFu8s");
    static B_F_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(B_F_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu8s)");
    check_field_offset(lv, v1, 0, "B_F_BFu8s.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_F_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_F_BFu8s");
  }
}
static Arrange_To_Call_Me vB_F_BFu8s(Test_B_F_BFu8s, "B_F_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu9i()
{
  {
    init_simple_test("B_F_BFu9i");
    static B_F_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(B_F_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu9i)");
    check_field_offset(lv, v1, 0, "B_F_BFu9i.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "B_F_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "B_F_BFu9i");
  }
}
static Arrange_To_Call_Me vB_F_BFu9i(Test_B_F_BFu9i, "B_F_BFu9i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu9ll()
{
  {
    init_simple_test("B_F_BFu9ll");
    static B_F_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(B_F_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_F_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "B_F_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "B_F_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_F_BFu9ll(Test_B_F_BFu9ll, "B_F_BFu9ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_BFu9s()
{
  {
    init_simple_test("B_F_BFu9s");
    static B_F_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(B_F_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_BFu9s)");
    check_field_offset(lv, v1, 0, "B_F_BFu9s.v1");
    check_field_offset(lv, v2, 1, "B_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "B_F_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "B_F_BFu9s");
  }
}
static Arrange_To_Call_Me vB_F_BFu9s(Test_B_F_BFu9s, "B_F_BFu9s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_C()
{
  {
    init_simple_test("B_F_C");
    B_F_C lv;
    check2(sizeof(lv), 6, "sizeof(B_F_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_C)");
    check_field_offset(lv, v1, 0, "B_F_C.v1");
    check_field_offset(lv, v2, 1, "B_F_C.v2");
    check_field_offset(lv, v3, 5, "B_F_C.v3");
  }
}
static Arrange_To_Call_Me vB_F_C(Test_B_F_C, "B_F_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_D()
{
  {
    init_simple_test("B_F_D");
    B_F_D lv;
    check2(sizeof(lv), 13, "sizeof(B_F_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_D)");
    check_field_offset(lv, v1, 0, "B_F_D.v1");
    check_field_offset(lv, v2, 1, "B_F_D.v2");
    check_field_offset(lv, v3, 5, "B_F_D.v3");
  }
}
static Arrange_To_Call_Me vB_F_D(Test_B_F_D, "B_F_D", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_F()
{
  {
    init_simple_test("B_F_F");
    B_F_F lv;
    check2(sizeof(lv), 9, "sizeof(B_F_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_F)");
    check_field_offset(lv, v1, 0, "B_F_F.v1");
    check_field_offset(lv, v2, 1, "B_F_F.v2");
    check_field_offset(lv, v3, 5, "B_F_F.v3");
  }
}
static Arrange_To_Call_Me vB_F_F(Test_B_F_F, "B_F_F", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_I()
{
  {
    init_simple_test("B_F_I");
    B_F_I lv;
    check2(sizeof(lv), 9, "sizeof(B_F_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_I)");
    check_field_offset(lv, v1, 0, "B_F_I.v1");
    check_field_offset(lv, v2, 1, "B_F_I.v2");
    check_field_offset(lv, v3, 5, "B_F_I.v3");
  }
}
static Arrange_To_Call_Me vB_F_I(Test_B_F_I, "B_F_I", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_Ip()
{
  {
    init_simple_test("B_F_Ip");
    B_F_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_F_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_Ip)");
    check_field_offset(lv, v1, 0, "B_F_Ip.v1");
    check_field_offset(lv, v2, 1, "B_F_Ip.v2");
    check_field_offset(lv, v3, 5, "B_F_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_F_Ip(Test_B_F_Ip, "B_F_Ip", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_L()
{
  {
    init_simple_test("B_F_L");
    B_F_L lv;
    check2(sizeof(lv), 13, "sizeof(B_F_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_L)");
    check_field_offset(lv, v1, 0, "B_F_L.v1");
    check_field_offset(lv, v2, 1, "B_F_L.v2");
    check_field_offset(lv, v3, 5, "B_F_L.v3");
  }
}
static Arrange_To_Call_Me vB_F_L(Test_B_F_L, "B_F_L", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_S()
{
  {
    init_simple_test("B_F_S");
    B_F_S lv;
    check2(sizeof(lv), 7, "sizeof(B_F_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_S)");
    check_field_offset(lv, v1, 0, "B_F_S.v1");
    check_field_offset(lv, v2, 1, "B_F_S.v2");
    check_field_offset(lv, v3, 5, "B_F_S.v3");
  }
}
static Arrange_To_Call_Me vB_F_S(Test_B_F_S, "B_F_S", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_Uc()
{
  {
    init_simple_test("B_F_Uc");
    B_F_Uc lv;
    check2(sizeof(lv), 6, "sizeof(B_F_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_Uc)");
    check_field_offset(lv, v1, 0, "B_F_Uc.v1");
    check_field_offset(lv, v2, 1, "B_F_Uc.v2");
    check_field_offset(lv, v3, 5, "B_F_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_F_Uc(Test_B_F_Uc, "B_F_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_Ui()
{
  {
    init_simple_test("B_F_Ui");
    B_F_Ui lv;
    check2(sizeof(lv), 9, "sizeof(B_F_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_Ui)");
    check_field_offset(lv, v1, 0, "B_F_Ui.v1");
    check_field_offset(lv, v2, 1, "B_F_Ui.v2");
    check_field_offset(lv, v3, 5, "B_F_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_F_Ui(Test_B_F_Ui, "B_F_Ui", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_Ul()
{
  {
    init_simple_test("B_F_Ul");
    B_F_Ul lv;
    check2(sizeof(lv), 13, "sizeof(B_F_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_Ul)");
    check_field_offset(lv, v1, 0, "B_F_Ul.v1");
    check_field_offset(lv, v2, 1, "B_F_Ul.v2");
    check_field_offset(lv, v3, 5, "B_F_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_F_Ul(Test_B_F_Ul, "B_F_Ul", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_Us()
{
  {
    init_simple_test("B_F_Us");
    B_F_Us lv;
    check2(sizeof(lv), 7, "sizeof(B_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_Us)");
    check_field_offset(lv, v1, 0, "B_F_Us.v1");
    check_field_offset(lv, v2, 1, "B_F_Us.v2");
    check_field_offset(lv, v3, 5, "B_F_Us.v3");
  }
}
static Arrange_To_Call_Me vB_F_Us(Test_B_F_Us, "B_F_Us", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_F_Vp()
{
  {
    init_simple_test("B_F_Vp");
    B_F_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_F_Vp)");
    check_field_offset(lv, v1, 0, "B_F_Vp.v1");
    check_field_offset(lv, v2, 1, "B_F_Vp.v2");
    check_field_offset(lv, v3, 5, "B_F_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_F_Vp(Test_B_F_Vp, "B_F_Vp", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I()
{
  {
    init_simple_test("B_I");
    B_I lv;
    check2(sizeof(lv), 5, "sizeof(B_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_I)");
    check_field_offset(lv, v1, 0, "B_I.v1");
    check_field_offset(lv, v2, 1, "B_I.v2");
  }
}
static Arrange_To_Call_Me vB_I(Test_B_I, "B_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_B()
{
  {
    init_simple_test("B_I_B");
    B_I_B lv;
    check2(sizeof(lv), 6, "sizeof(B_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_B)");
    check_field_offset(lv, v1, 0, "B_I_B.v1");
    check_field_offset(lv, v2, 1, "B_I_B.v2");
    check_field_offset(lv, v3, 5, "B_I_B.v3");
  }
}
static Arrange_To_Call_Me vB_I_B(Test_B_I_B, "B_I_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu15i()
{
  {
    init_simple_test("B_I_BFu15i");
    static B_I_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(B_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu15i)");
    check_field_offset(lv, v1, 0, "B_I_BFu15i.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "B_I_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "B_I_BFu15i");
  }
}
static Arrange_To_Call_Me vB_I_BFu15i(Test_B_I_BFu15i, "B_I_BFu15i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu15ll()
{
  {
    init_simple_test("B_I_BFu15ll");
    static B_I_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(B_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_I_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "B_I_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "B_I_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_I_BFu15ll(Test_B_I_BFu15ll, "B_I_BFu15ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu15s()
{
  {
    init_simple_test("B_I_BFu15s");
    static B_I_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(B_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu15s)");
    check_field_offset(lv, v1, 0, "B_I_BFu15s.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "B_I_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "B_I_BFu15s");
  }
}
static Arrange_To_Call_Me vB_I_BFu15s(Test_B_I_BFu15s, "B_I_BFu15s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu16i()
{
  {
    init_simple_test("B_I_BFu16i");
    static B_I_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(B_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu16i)");
    check_field_offset(lv, v1, 0, "B_I_BFu16i.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "B_I_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "B_I_BFu16i");
  }
}
static Arrange_To_Call_Me vB_I_BFu16i(Test_B_I_BFu16i, "B_I_BFu16i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu16ll()
{
  {
    init_simple_test("B_I_BFu16ll");
    static B_I_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(B_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_I_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "B_I_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "B_I_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_I_BFu16ll(Test_B_I_BFu16ll, "B_I_BFu16ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu16s()
{
  {
    init_simple_test("B_I_BFu16s");
    static B_I_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(B_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu16s)");
    check_field_offset(lv, v1, 0, "B_I_BFu16s.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "B_I_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "B_I_BFu16s");
  }
}
static Arrange_To_Call_Me vB_I_BFu16s(Test_B_I_BFu16s, "B_I_BFu16s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu17i()
{
  {
    init_simple_test("B_I_BFu17i");
    static B_I_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu17i)");
    check_field_offset(lv, v1, 0, "B_I_BFu17i.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "B_I_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "B_I_BFu17i");
  }
}
static Arrange_To_Call_Me vB_I_BFu17i(Test_B_I_BFu17i, "B_I_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu17ll()
{
  {
    init_simple_test("B_I_BFu17ll");
    static B_I_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_I_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "B_I_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "B_I_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_I_BFu17ll(Test_B_I_BFu17ll, "B_I_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu1c()
{
  {
    init_simple_test("B_I_BFu1c");
    static B_I_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(B_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu1c)");
    check_field_offset(lv, v1, 0, "B_I_BFu1c.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_I_BFu1c");
  }
}
static Arrange_To_Call_Me vB_I_BFu1c(Test_B_I_BFu1c, "B_I_BFu1c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu1i()
{
  {
    init_simple_test("B_I_BFu1i");
    static B_I_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(B_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu1i)");
    check_field_offset(lv, v1, 0, "B_I_BFu1i.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_I_BFu1i");
  }
}
static Arrange_To_Call_Me vB_I_BFu1i(Test_B_I_BFu1i, "B_I_BFu1i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu1ll()
{
  {
    init_simple_test("B_I_BFu1ll");
    static B_I_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(B_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_I_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_I_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_I_BFu1ll(Test_B_I_BFu1ll, "B_I_BFu1ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu1s()
{
  {
    init_simple_test("B_I_BFu1s");
    static B_I_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(B_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu1s)");
    check_field_offset(lv, v1, 0, "B_I_BFu1s.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_I_BFu1s");
  }
}
static Arrange_To_Call_Me vB_I_BFu1s(Test_B_I_BFu1s, "B_I_BFu1s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu31i()
{
  {
    init_simple_test("B_I_BFu31i");
    static B_I_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(B_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu31i)");
    check_field_offset(lv, v1, 0, "B_I_BFu31i.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "B_I_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "B_I_BFu31i");
  }
}
static Arrange_To_Call_Me vB_I_BFu31i(Test_B_I_BFu31i, "B_I_BFu31i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu31ll()
{
  {
    init_simple_test("B_I_BFu31ll");
    static B_I_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(B_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_I_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "B_I_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "B_I_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_I_BFu31ll(Test_B_I_BFu31ll, "B_I_BFu31ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu32i()
{
  {
    init_simple_test("B_I_BFu32i");
    static B_I_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(B_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu32i)");
    check_field_offset(lv, v1, 0, "B_I_BFu32i.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "B_I_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "B_I_BFu32i");
  }
}
static Arrange_To_Call_Me vB_I_BFu32i(Test_B_I_BFu32i, "B_I_BFu32i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu32ll()
{
  {
    init_simple_test("B_I_BFu32ll");
    static B_I_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(B_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_I_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "B_I_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "B_I_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_I_BFu32ll(Test_B_I_BFu32ll, "B_I_BFu32ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu33()
{
  {
    init_simple_test("B_I_BFu33");
    static B_I_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(B_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu33)");
    check_field_offset(lv, v1, 0, "B_I_BFu33.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "B_I_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "B_I_BFu33");
  }
}
static Arrange_To_Call_Me vB_I_BFu33(Test_B_I_BFu33, "B_I_BFu33", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu7c()
{
  {
    init_simple_test("B_I_BFu7c");
    static B_I_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(B_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu7c)");
    check_field_offset(lv, v1, 0, "B_I_BFu7c.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_I_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_I_BFu7c");
  }
}
static Arrange_To_Call_Me vB_I_BFu7c(Test_B_I_BFu7c, "B_I_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu7i()
{
  {
    init_simple_test("B_I_BFu7i");
    static B_I_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(B_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu7i)");
    check_field_offset(lv, v1, 0, "B_I_BFu7i.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_I_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_I_BFu7i");
  }
}
static Arrange_To_Call_Me vB_I_BFu7i(Test_B_I_BFu7i, "B_I_BFu7i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu7ll()
{
  {
    init_simple_test("B_I_BFu7ll");
    static B_I_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(B_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_I_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_I_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_I_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_I_BFu7ll(Test_B_I_BFu7ll, "B_I_BFu7ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu7s()
{
  {
    init_simple_test("B_I_BFu7s");
    static B_I_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(B_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu7s)");
    check_field_offset(lv, v1, 0, "B_I_BFu7s.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_I_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_I_BFu7s");
  }
}
static Arrange_To_Call_Me vB_I_BFu7s(Test_B_I_BFu7s, "B_I_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu8c()
{
  {
    init_simple_test("B_I_BFu8c");
    static B_I_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(B_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu8c)");
    check_field_offset(lv, v1, 0, "B_I_BFu8c.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_I_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_I_BFu8c");
  }
}
static Arrange_To_Call_Me vB_I_BFu8c(Test_B_I_BFu8c, "B_I_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu8i()
{
  {
    init_simple_test("B_I_BFu8i");
    static B_I_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(B_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu8i)");
    check_field_offset(lv, v1, 0, "B_I_BFu8i.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_I_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_I_BFu8i");
  }
}
static Arrange_To_Call_Me vB_I_BFu8i(Test_B_I_BFu8i, "B_I_BFu8i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu8ll()
{
  {
    init_simple_test("B_I_BFu8ll");
    static B_I_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(B_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_I_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_I_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_I_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_I_BFu8ll(Test_B_I_BFu8ll, "B_I_BFu8ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu8s()
{
  {
    init_simple_test("B_I_BFu8s");
    static B_I_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(B_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu8s)");
    check_field_offset(lv, v1, 0, "B_I_BFu8s.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_I_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_I_BFu8s");
  }
}
static Arrange_To_Call_Me vB_I_BFu8s(Test_B_I_BFu8s, "B_I_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu9i()
{
  {
    init_simple_test("B_I_BFu9i");
    static B_I_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(B_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu9i)");
    check_field_offset(lv, v1, 0, "B_I_BFu9i.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "B_I_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "B_I_BFu9i");
  }
}
static Arrange_To_Call_Me vB_I_BFu9i(Test_B_I_BFu9i, "B_I_BFu9i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu9ll()
{
  {
    init_simple_test("B_I_BFu9ll");
    static B_I_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(B_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_I_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "B_I_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "B_I_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_I_BFu9ll(Test_B_I_BFu9ll, "B_I_BFu9ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_BFu9s()
{
  {
    init_simple_test("B_I_BFu9s");
    static B_I_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(B_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_BFu9s)");
    check_field_offset(lv, v1, 0, "B_I_BFu9s.v1");
    check_field_offset(lv, v2, 1, "B_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "B_I_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "B_I_BFu9s");
  }
}
static Arrange_To_Call_Me vB_I_BFu9s(Test_B_I_BFu9s, "B_I_BFu9s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_C()
{
  {
    init_simple_test("B_I_C");
    B_I_C lv;
    check2(sizeof(lv), 6, "sizeof(B_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_C)");
    check_field_offset(lv, v1, 0, "B_I_C.v1");
    check_field_offset(lv, v2, 1, "B_I_C.v2");
    check_field_offset(lv, v3, 5, "B_I_C.v3");
  }
}
static Arrange_To_Call_Me vB_I_C(Test_B_I_C, "B_I_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_D()
{
  {
    init_simple_test("B_I_D");
    B_I_D lv;
    check2(sizeof(lv), 13, "sizeof(B_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_D)");
    check_field_offset(lv, v1, 0, "B_I_D.v1");
    check_field_offset(lv, v2, 1, "B_I_D.v2");
    check_field_offset(lv, v3, 5, "B_I_D.v3");
  }
}
static Arrange_To_Call_Me vB_I_D(Test_B_I_D, "B_I_D", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_F()
{
  {
    init_simple_test("B_I_F");
    B_I_F lv;
    check2(sizeof(lv), 9, "sizeof(B_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_F)");
    check_field_offset(lv, v1, 0, "B_I_F.v1");
    check_field_offset(lv, v2, 1, "B_I_F.v2");
    check_field_offset(lv, v3, 5, "B_I_F.v3");
  }
}
static Arrange_To_Call_Me vB_I_F(Test_B_I_F, "B_I_F", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_I()
{
  {
    init_simple_test("B_I_I");
    B_I_I lv;
    check2(sizeof(lv), 9, "sizeof(B_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_I)");
    check_field_offset(lv, v1, 0, "B_I_I.v1");
    check_field_offset(lv, v2, 1, "B_I_I.v2");
    check_field_offset(lv, v3, 5, "B_I_I.v3");
  }
}
static Arrange_To_Call_Me vB_I_I(Test_B_I_I, "B_I_I", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_Ip()
{
  {
    init_simple_test("B_I_Ip");
    B_I_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_Ip)");
    check_field_offset(lv, v1, 0, "B_I_Ip.v1");
    check_field_offset(lv, v2, 1, "B_I_Ip.v2");
    check_field_offset(lv, v3, 5, "B_I_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_I_Ip(Test_B_I_Ip, "B_I_Ip", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_L()
{
  {
    init_simple_test("B_I_L");
    B_I_L lv;
    check2(sizeof(lv), 13, "sizeof(B_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_L)");
    check_field_offset(lv, v1, 0, "B_I_L.v1");
    check_field_offset(lv, v2, 1, "B_I_L.v2");
    check_field_offset(lv, v3, 5, "B_I_L.v3");
  }
}
static Arrange_To_Call_Me vB_I_L(Test_B_I_L, "B_I_L", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_S()
{
  {
    init_simple_test("B_I_S");
    B_I_S lv;
    check2(sizeof(lv), 7, "sizeof(B_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_S)");
    check_field_offset(lv, v1, 0, "B_I_S.v1");
    check_field_offset(lv, v2, 1, "B_I_S.v2");
    check_field_offset(lv, v3, 5, "B_I_S.v3");
  }
}
static Arrange_To_Call_Me vB_I_S(Test_B_I_S, "B_I_S", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_Uc()
{
  {
    init_simple_test("B_I_Uc");
    B_I_Uc lv;
    check2(sizeof(lv), 6, "sizeof(B_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_Uc)");
    check_field_offset(lv, v1, 0, "B_I_Uc.v1");
    check_field_offset(lv, v2, 1, "B_I_Uc.v2");
    check_field_offset(lv, v3, 5, "B_I_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_I_Uc(Test_B_I_Uc, "B_I_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_Ui()
{
  {
    init_simple_test("B_I_Ui");
    B_I_Ui lv;
    check2(sizeof(lv), 9, "sizeof(B_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_Ui)");
    check_field_offset(lv, v1, 0, "B_I_Ui.v1");
    check_field_offset(lv, v2, 1, "B_I_Ui.v2");
    check_field_offset(lv, v3, 5, "B_I_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_I_Ui(Test_B_I_Ui, "B_I_Ui", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_Ul()
{
  {
    init_simple_test("B_I_Ul");
    B_I_Ul lv;
    check2(sizeof(lv), 13, "sizeof(B_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_Ul)");
    check_field_offset(lv, v1, 0, "B_I_Ul.v1");
    check_field_offset(lv, v2, 1, "B_I_Ul.v2");
    check_field_offset(lv, v3, 5, "B_I_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_I_Ul(Test_B_I_Ul, "B_I_Ul", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_Us()
{
  {
    init_simple_test("B_I_Us");
    B_I_Us lv;
    check2(sizeof(lv), 7, "sizeof(B_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_Us)");
    check_field_offset(lv, v1, 0, "B_I_Us.v1");
    check_field_offset(lv, v2, 1, "B_I_Us.v2");
    check_field_offset(lv, v3, 5, "B_I_Us.v3");
  }
}
static Arrange_To_Call_Me vB_I_Us(Test_B_I_Us, "B_I_Us", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_I_Vp()
{
  {
    init_simple_test("B_I_Vp");
    B_I_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_I_Vp)");
    check_field_offset(lv, v1, 0, "B_I_Vp.v1");
    check_field_offset(lv, v2, 1, "B_I_Vp.v2");
    check_field_offset(lv, v3, 5, "B_I_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_I_Vp(Test_B_I_Vp, "B_I_Vp", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip()
{
  {
    init_simple_test("B_Ip");
    B_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip)");
    check_field_offset(lv, v1, 0, "B_Ip.v1");
    check_field_offset(lv, v2, 1, "B_Ip.v2");
  }
}
static Arrange_To_Call_Me vB_Ip(Test_B_Ip, "B_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_B()
{
  {
    init_simple_test("B_Ip_B");
    B_Ip_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_B)");
    check_field_offset(lv, v1, 0, "B_Ip_B.v1");
    check_field_offset(lv, v2, 1, "B_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vB_Ip_B(Test_B_Ip_B, "B_Ip_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu15i()
{
  {
    init_simple_test("B_Ip_BFu15i");
    static B_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu15i.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "B_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "B_Ip_BFu15i");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu15i(Test_B_Ip_BFu15i, "B_Ip_BFu15i", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu15ll()
{
  {
    init_simple_test("B_Ip_BFu15ll");
    static B_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "B_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "B_Ip_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu15ll(Test_B_Ip_BFu15ll, "B_Ip_BFu15ll", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu15s()
{
  {
    init_simple_test("B_Ip_BFu15s");
    static B_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu15s.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "B_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "B_Ip_BFu15s");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu15s(Test_B_Ip_BFu15s, "B_Ip_BFu15s", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu16i()
{
  {
    init_simple_test("B_Ip_BFu16i");
    static B_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu16i.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "B_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "B_Ip_BFu16i");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu16i(Test_B_Ip_BFu16i, "B_Ip_BFu16i", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu16ll()
{
  {
    init_simple_test("B_Ip_BFu16ll");
    static B_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "B_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "B_Ip_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu16ll(Test_B_Ip_BFu16ll, "B_Ip_BFu16ll", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu16s()
{
  {
    init_simple_test("B_Ip_BFu16s");
    static B_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu16s.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "B_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "B_Ip_BFu16s");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu16s(Test_B_Ip_BFu16s, "B_Ip_BFu16s", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu17i()
{
  {
    init_simple_test("B_Ip_BFu17i");
    static B_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(B_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu17i.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "B_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "B_Ip_BFu17i");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu17i(Test_B_Ip_BFu17i, "B_Ip_BFu17i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu17ll()
{
  {
    init_simple_test("B_Ip_BFu17ll");
    static B_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(B_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "B_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "B_Ip_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu17ll(Test_B_Ip_BFu17ll, "B_Ip_BFu17ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu1c()
{
  {
    init_simple_test("B_Ip_BFu1c");
    static B_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu1c.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "B_Ip_BFu1c");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu1c(Test_B_Ip_BFu1c, "B_Ip_BFu1c", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu1i()
{
  {
    init_simple_test("B_Ip_BFu1i");
    static B_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu1i.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "B_Ip_BFu1i");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu1i(Test_B_Ip_BFu1i, "B_Ip_BFu1i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu1ll()
{
  {
    init_simple_test("B_Ip_BFu1ll");
    static B_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "B_Ip_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu1ll(Test_B_Ip_BFu1ll, "B_Ip_BFu1ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu1s()
{
  {
    init_simple_test("B_Ip_BFu1s");
    static B_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu1s.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "B_Ip_BFu1s");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu1s(Test_B_Ip_BFu1s, "B_Ip_BFu1s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu31i()
{
  {
    init_simple_test("B_Ip_BFu31i");
    static B_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu31i.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "B_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "B_Ip_BFu31i");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu31i(Test_B_Ip_BFu31i, "B_Ip_BFu31i", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu31ll()
{
  {
    init_simple_test("B_Ip_BFu31ll");
    static B_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "B_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "B_Ip_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu31ll(Test_B_Ip_BFu31ll, "B_Ip_BFu31ll", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu32i()
{
  {
    init_simple_test("B_Ip_BFu32i");
    static B_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu32i.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "B_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "B_Ip_BFu32i");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu32i(Test_B_Ip_BFu32i, "B_Ip_BFu32i", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu32ll()
{
  {
    init_simple_test("B_Ip_BFu32ll");
    static B_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "B_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "B_Ip_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu32ll(Test_B_Ip_BFu32ll, "B_Ip_BFu32ll", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu33()
{
  {
    init_simple_test("B_Ip_BFu33");
    static B_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(B_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu33.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "B_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "B_Ip_BFu33");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu33(Test_B_Ip_BFu33, "B_Ip_BFu33", ABISELECT(14,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu7c()
{
  {
    init_simple_test("B_Ip_BFu7c");
    static B_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu7c.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "B_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "B_Ip_BFu7c");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu7c(Test_B_Ip_BFu7c, "B_Ip_BFu7c", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu7i()
{
  {
    init_simple_test("B_Ip_BFu7i");
    static B_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu7i.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "B_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "B_Ip_BFu7i");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu7i(Test_B_Ip_BFu7i, "B_Ip_BFu7i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu7ll()
{
  {
    init_simple_test("B_Ip_BFu7ll");
    static B_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "B_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "B_Ip_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu7ll(Test_B_Ip_BFu7ll, "B_Ip_BFu7ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu7s()
{
  {
    init_simple_test("B_Ip_BFu7s");
    static B_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu7s.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "B_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "B_Ip_BFu7s");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu7s(Test_B_Ip_BFu7s, "B_Ip_BFu7s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu8c()
{
  {
    init_simple_test("B_Ip_BFu8c");
    static B_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu8c.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "B_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "B_Ip_BFu8c");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu8c(Test_B_Ip_BFu8c, "B_Ip_BFu8c", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu8i()
{
  {
    init_simple_test("B_Ip_BFu8i");
    static B_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu8i.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "B_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "B_Ip_BFu8i");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu8i(Test_B_Ip_BFu8i, "B_Ip_BFu8i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu8ll()
{
  {
    init_simple_test("B_Ip_BFu8ll");
    static B_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "B_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "B_Ip_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu8ll(Test_B_Ip_BFu8ll, "B_Ip_BFu8ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu8s()
{
  {
    init_simple_test("B_Ip_BFu8s");
    static B_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu8s.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "B_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "B_Ip_BFu8s");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu8s(Test_B_Ip_BFu8s, "B_Ip_BFu8s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu9i()
{
  {
    init_simple_test("B_Ip_BFu9i");
    static B_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu9i.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "B_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "B_Ip_BFu9i");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu9i(Test_B_Ip_BFu9i, "B_Ip_BFu9i", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu9ll()
{
  {
    init_simple_test("B_Ip_BFu9ll");
    static B_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "B_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "B_Ip_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu9ll(Test_B_Ip_BFu9ll, "B_Ip_BFu9ll", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_BFu9s()
{
  {
    init_simple_test("B_Ip_BFu9s");
    static B_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "B_Ip_BFu9s.v1");
    check_field_offset(lv, v2, 1, "B_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "B_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "B_Ip_BFu9s");
  }
}
static Arrange_To_Call_Me vB_Ip_BFu9s(Test_B_Ip_BFu9s, "B_Ip_BFu9s", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_C()
{
  {
    init_simple_test("B_Ip_C");
    B_Ip_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_C)");
    check_field_offset(lv, v1, 0, "B_Ip_C.v1");
    check_field_offset(lv, v2, 1, "B_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Ip_C.v3");
  }
}
static Arrange_To_Call_Me vB_Ip_C(Test_B_Ip_C, "B_Ip_C", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_D()
{
  {
    init_simple_test("B_Ip_D");
    B_Ip_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(B_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_D)");
    check_field_offset(lv, v1, 0, "B_Ip_D.v1");
    check_field_offset(lv, v2, 1, "B_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Ip_D.v3");
  }
}
static Arrange_To_Call_Me vB_Ip_D(Test_B_Ip_D, "B_Ip_D", ABISELECT(17,13));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_F()
{
  {
    init_simple_test("B_Ip_F");
    B_Ip_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_F)");
    check_field_offset(lv, v1, 0, "B_Ip_F.v1");
    check_field_offset(lv, v2, 1, "B_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Ip_F.v3");
  }
}
static Arrange_To_Call_Me vB_Ip_F(Test_B_Ip_F, "B_Ip_F", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_I()
{
  {
    init_simple_test("B_Ip_I");
    B_Ip_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_I)");
    check_field_offset(lv, v1, 0, "B_Ip_I.v1");
    check_field_offset(lv, v2, 1, "B_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Ip_I.v3");
  }
}
static Arrange_To_Call_Me vB_Ip_I(Test_B_Ip_I, "B_Ip_I", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_Ip()
{
  {
    init_simple_test("B_Ip_Ip");
    B_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(B_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_Ip)");
    check_field_offset(lv, v1, 0, "B_Ip_Ip.v1");
    check_field_offset(lv, v2, 1, "B_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Ip_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_Ip_Ip(Test_B_Ip_Ip, "B_Ip_Ip", ABISELECT(17,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_L()
{
  {
    init_simple_test("B_Ip_L");
    B_Ip_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(B_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_L)");
    check_field_offset(lv, v1, 0, "B_Ip_L.v1");
    check_field_offset(lv, v2, 1, "B_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Ip_L.v3");
  }
}
static Arrange_To_Call_Me vB_Ip_L(Test_B_Ip_L, "B_Ip_L", ABISELECT(17,13));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_S()
{
  {
    init_simple_test("B_Ip_S");
    B_Ip_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_S)");
    check_field_offset(lv, v1, 0, "B_Ip_S.v1");
    check_field_offset(lv, v2, 1, "B_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Ip_S.v3");
  }
}
static Arrange_To_Call_Me vB_Ip_S(Test_B_Ip_S, "B_Ip_S", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_Uc()
{
  {
    init_simple_test("B_Ip_Uc");
    B_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_Uc)");
    check_field_offset(lv, v1, 0, "B_Ip_Uc.v1");
    check_field_offset(lv, v2, 1, "B_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Ip_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_Ip_Uc(Test_B_Ip_Uc, "B_Ip_Uc", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_Ui()
{
  {
    init_simple_test("B_Ip_Ui");
    B_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_Ui)");
    check_field_offset(lv, v1, 0, "B_Ip_Ui.v1");
    check_field_offset(lv, v2, 1, "B_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Ip_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_Ip_Ui(Test_B_Ip_Ui, "B_Ip_Ui", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_Ul()
{
  {
    init_simple_test("B_Ip_Ul");
    B_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(B_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_Ul)");
    check_field_offset(lv, v1, 0, "B_Ip_Ul.v1");
    check_field_offset(lv, v2, 1, "B_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Ip_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_Ip_Ul(Test_B_Ip_Ul, "B_Ip_Ul", ABISELECT(17,13));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_Us()
{
  {
    init_simple_test("B_Ip_Us");
    B_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_Us)");
    check_field_offset(lv, v1, 0, "B_Ip_Us.v1");
    check_field_offset(lv, v2, 1, "B_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Ip_Us.v3");
  }
}
static Arrange_To_Call_Me vB_Ip_Us(Test_B_Ip_Us, "B_Ip_Us", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ip_Vp()
{
  {
    init_simple_test("B_Ip_Vp");
    B_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(B_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ip_Vp)");
    check_field_offset(lv, v1, 0, "B_Ip_Vp.v1");
    check_field_offset(lv, v2, 1, "B_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Ip_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_Ip_Vp(Test_B_Ip_Vp, "B_Ip_Vp", ABISELECT(17,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L()
{
  {
    init_simple_test("B_L");
    B_L lv;
    check2(sizeof(lv), 9, "sizeof(B_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_L)");
    check_field_offset(lv, v1, 0, "B_L.v1");
    check_field_offset(lv, v2, 1, "B_L.v2");
  }
}
static Arrange_To_Call_Me vB_L(Test_B_L, "B_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_B()
{
  {
    init_simple_test("B_L_B");
    B_L_B lv;
    check2(sizeof(lv), 10, "sizeof(B_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_B)");
    check_field_offset(lv, v1, 0, "B_L_B.v1");
    check_field_offset(lv, v2, 1, "B_L_B.v2");
    check_field_offset(lv, v3, 9, "B_L_B.v3");
  }
}
static Arrange_To_Call_Me vB_L_B(Test_B_L_B, "B_L_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu15i()
{
  {
    init_simple_test("B_L_BFu15i");
    static B_L_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(B_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu15i)");
    check_field_offset(lv, v1, 0, "B_L_BFu15i.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "B_L_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "B_L_BFu15i");
  }
}
static Arrange_To_Call_Me vB_L_BFu15i(Test_B_L_BFu15i, "B_L_BFu15i", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu15ll()
{
  {
    init_simple_test("B_L_BFu15ll");
    static B_L_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(B_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_L_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "B_L_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "B_L_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_L_BFu15ll(Test_B_L_BFu15ll, "B_L_BFu15ll", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu15s()
{
  {
    init_simple_test("B_L_BFu15s");
    static B_L_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(B_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu15s)");
    check_field_offset(lv, v1, 0, "B_L_BFu15s.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "B_L_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "B_L_BFu15s");
  }
}
static Arrange_To_Call_Me vB_L_BFu15s(Test_B_L_BFu15s, "B_L_BFu15s", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu16i()
{
  {
    init_simple_test("B_L_BFu16i");
    static B_L_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(B_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu16i)");
    check_field_offset(lv, v1, 0, "B_L_BFu16i.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "B_L_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "B_L_BFu16i");
  }
}
static Arrange_To_Call_Me vB_L_BFu16i(Test_B_L_BFu16i, "B_L_BFu16i", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu16ll()
{
  {
    init_simple_test("B_L_BFu16ll");
    static B_L_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(B_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_L_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "B_L_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "B_L_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_L_BFu16ll(Test_B_L_BFu16ll, "B_L_BFu16ll", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu16s()
{
  {
    init_simple_test("B_L_BFu16s");
    static B_L_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(B_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu16s)");
    check_field_offset(lv, v1, 0, "B_L_BFu16s.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "B_L_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "B_L_BFu16s");
  }
}
static Arrange_To_Call_Me vB_L_BFu16s(Test_B_L_BFu16s, "B_L_BFu16s", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu17i()
{
  {
    init_simple_test("B_L_BFu17i");
    static B_L_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(B_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu17i)");
    check_field_offset(lv, v1, 0, "B_L_BFu17i.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "B_L_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "B_L_BFu17i");
  }
}
static Arrange_To_Call_Me vB_L_BFu17i(Test_B_L_BFu17i, "B_L_BFu17i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu17ll()
{
  {
    init_simple_test("B_L_BFu17ll");
    static B_L_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(B_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_L_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "B_L_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "B_L_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_L_BFu17ll(Test_B_L_BFu17ll, "B_L_BFu17ll", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu1c()
{
  {
    init_simple_test("B_L_BFu1c");
    static B_L_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(B_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu1c)");
    check_field_offset(lv, v1, 0, "B_L_BFu1c.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "B_L_BFu1c");
  }
}
static Arrange_To_Call_Me vB_L_BFu1c(Test_B_L_BFu1c, "B_L_BFu1c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu1i()
{
  {
    init_simple_test("B_L_BFu1i");
    static B_L_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(B_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu1i)");
    check_field_offset(lv, v1, 0, "B_L_BFu1i.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "B_L_BFu1i");
  }
}
static Arrange_To_Call_Me vB_L_BFu1i(Test_B_L_BFu1i, "B_L_BFu1i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu1ll()
{
  {
    init_simple_test("B_L_BFu1ll");
    static B_L_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(B_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_L_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "B_L_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_L_BFu1ll(Test_B_L_BFu1ll, "B_L_BFu1ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu1s()
{
  {
    init_simple_test("B_L_BFu1s");
    static B_L_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(B_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu1s)");
    check_field_offset(lv, v1, 0, "B_L_BFu1s.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "B_L_BFu1s");
  }
}
static Arrange_To_Call_Me vB_L_BFu1s(Test_B_L_BFu1s, "B_L_BFu1s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu31i()
{
  {
    init_simple_test("B_L_BFu31i");
    static B_L_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(B_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu31i)");
    check_field_offset(lv, v1, 0, "B_L_BFu31i.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "B_L_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "B_L_BFu31i");
  }
}
static Arrange_To_Call_Me vB_L_BFu31i(Test_B_L_BFu31i, "B_L_BFu31i", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu31ll()
{
  {
    init_simple_test("B_L_BFu31ll");
    static B_L_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(B_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_L_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "B_L_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "B_L_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_L_BFu31ll(Test_B_L_BFu31ll, "B_L_BFu31ll", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu32i()
{
  {
    init_simple_test("B_L_BFu32i");
    static B_L_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(B_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu32i)");
    check_field_offset(lv, v1, 0, "B_L_BFu32i.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "B_L_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "B_L_BFu32i");
  }
}
static Arrange_To_Call_Me vB_L_BFu32i(Test_B_L_BFu32i, "B_L_BFu32i", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu32ll()
{
  {
    init_simple_test("B_L_BFu32ll");
    static B_L_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(B_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_L_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "B_L_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "B_L_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_L_BFu32ll(Test_B_L_BFu32ll, "B_L_BFu32ll", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu33()
{
  {
    init_simple_test("B_L_BFu33");
    static B_L_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(B_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu33)");
    check_field_offset(lv, v1, 0, "B_L_BFu33.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "B_L_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "B_L_BFu33");
  }
}
static Arrange_To_Call_Me vB_L_BFu33(Test_B_L_BFu33, "B_L_BFu33", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu7c()
{
  {
    init_simple_test("B_L_BFu7c");
    static B_L_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(B_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu7c)");
    check_field_offset(lv, v1, 0, "B_L_BFu7c.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "B_L_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "B_L_BFu7c");
  }
}
static Arrange_To_Call_Me vB_L_BFu7c(Test_B_L_BFu7c, "B_L_BFu7c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu7i()
{
  {
    init_simple_test("B_L_BFu7i");
    static B_L_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(B_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu7i)");
    check_field_offset(lv, v1, 0, "B_L_BFu7i.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "B_L_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "B_L_BFu7i");
  }
}
static Arrange_To_Call_Me vB_L_BFu7i(Test_B_L_BFu7i, "B_L_BFu7i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu7ll()
{
  {
    init_simple_test("B_L_BFu7ll");
    static B_L_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(B_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_L_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "B_L_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "B_L_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_L_BFu7ll(Test_B_L_BFu7ll, "B_L_BFu7ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu7s()
{
  {
    init_simple_test("B_L_BFu7s");
    static B_L_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(B_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu7s)");
    check_field_offset(lv, v1, 0, "B_L_BFu7s.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "B_L_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "B_L_BFu7s");
  }
}
static Arrange_To_Call_Me vB_L_BFu7s(Test_B_L_BFu7s, "B_L_BFu7s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu8c()
{
  {
    init_simple_test("B_L_BFu8c");
    static B_L_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(B_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu8c)");
    check_field_offset(lv, v1, 0, "B_L_BFu8c.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "B_L_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "B_L_BFu8c");
  }
}
static Arrange_To_Call_Me vB_L_BFu8c(Test_B_L_BFu8c, "B_L_BFu8c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu8i()
{
  {
    init_simple_test("B_L_BFu8i");
    static B_L_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(B_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu8i)");
    check_field_offset(lv, v1, 0, "B_L_BFu8i.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "B_L_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "B_L_BFu8i");
  }
}
static Arrange_To_Call_Me vB_L_BFu8i(Test_B_L_BFu8i, "B_L_BFu8i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu8ll()
{
  {
    init_simple_test("B_L_BFu8ll");
    static B_L_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(B_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_L_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "B_L_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "B_L_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_L_BFu8ll(Test_B_L_BFu8ll, "B_L_BFu8ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu8s()
{
  {
    init_simple_test("B_L_BFu8s");
    static B_L_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(B_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu8s)");
    check_field_offset(lv, v1, 0, "B_L_BFu8s.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "B_L_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "B_L_BFu8s");
  }
}
static Arrange_To_Call_Me vB_L_BFu8s(Test_B_L_BFu8s, "B_L_BFu8s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu9i()
{
  {
    init_simple_test("B_L_BFu9i");
    static B_L_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(B_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu9i)");
    check_field_offset(lv, v1, 0, "B_L_BFu9i.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "B_L_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "B_L_BFu9i");
  }
}
static Arrange_To_Call_Me vB_L_BFu9i(Test_B_L_BFu9i, "B_L_BFu9i", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu9ll()
{
  {
    init_simple_test("B_L_BFu9ll");
    static B_L_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(B_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_L_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "B_L_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "B_L_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_L_BFu9ll(Test_B_L_BFu9ll, "B_L_BFu9ll", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_BFu9s()
{
  {
    init_simple_test("B_L_BFu9s");
    static B_L_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(B_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_BFu9s)");
    check_field_offset(lv, v1, 0, "B_L_BFu9s.v1");
    check_field_offset(lv, v2, 1, "B_L_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "B_L_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "B_L_BFu9s");
  }
}
static Arrange_To_Call_Me vB_L_BFu9s(Test_B_L_BFu9s, "B_L_BFu9s", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_C()
{
  {
    init_simple_test("B_L_C");
    B_L_C lv;
    check2(sizeof(lv), 10, "sizeof(B_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_C)");
    check_field_offset(lv, v1, 0, "B_L_C.v1");
    check_field_offset(lv, v2, 1, "B_L_C.v2");
    check_field_offset(lv, v3, 9, "B_L_C.v3");
  }
}
static Arrange_To_Call_Me vB_L_C(Test_B_L_C, "B_L_C", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_D()
{
  {
    init_simple_test("B_L_D");
    B_L_D lv;
    check2(sizeof(lv), 17, "sizeof(B_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_D)");
    check_field_offset(lv, v1, 0, "B_L_D.v1");
    check_field_offset(lv, v2, 1, "B_L_D.v2");
    check_field_offset(lv, v3, 9, "B_L_D.v3");
  }
}
static Arrange_To_Call_Me vB_L_D(Test_B_L_D, "B_L_D", 17);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_F()
{
  {
    init_simple_test("B_L_F");
    B_L_F lv;
    check2(sizeof(lv), 13, "sizeof(B_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_F)");
    check_field_offset(lv, v1, 0, "B_L_F.v1");
    check_field_offset(lv, v2, 1, "B_L_F.v2");
    check_field_offset(lv, v3, 9, "B_L_F.v3");
  }
}
static Arrange_To_Call_Me vB_L_F(Test_B_L_F, "B_L_F", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_I()
{
  {
    init_simple_test("B_L_I");
    B_L_I lv;
    check2(sizeof(lv), 13, "sizeof(B_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_I)");
    check_field_offset(lv, v1, 0, "B_L_I.v1");
    check_field_offset(lv, v2, 1, "B_L_I.v2");
    check_field_offset(lv, v3, 9, "B_L_I.v3");
  }
}
static Arrange_To_Call_Me vB_L_I(Test_B_L_I, "B_L_I", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_Ip()
{
  {
    init_simple_test("B_L_Ip");
    B_L_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(B_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_Ip)");
    check_field_offset(lv, v1, 0, "B_L_Ip.v1");
    check_field_offset(lv, v2, 1, "B_L_Ip.v2");
    check_field_offset(lv, v3, 9, "B_L_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_L_Ip(Test_B_L_Ip, "B_L_Ip", ABISELECT(17,13));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_L()
{
  {
    init_simple_test("B_L_L");
    B_L_L lv;
    check2(sizeof(lv), 17, "sizeof(B_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_L)");
    check_field_offset(lv, v1, 0, "B_L_L.v1");
    check_field_offset(lv, v2, 1, "B_L_L.v2");
    check_field_offset(lv, v3, 9, "B_L_L.v3");
  }
}
static Arrange_To_Call_Me vB_L_L(Test_B_L_L, "B_L_L", 17);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_S()
{
  {
    init_simple_test("B_L_S");
    B_L_S lv;
    check2(sizeof(lv), 11, "sizeof(B_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_S)");
    check_field_offset(lv, v1, 0, "B_L_S.v1");
    check_field_offset(lv, v2, 1, "B_L_S.v2");
    check_field_offset(lv, v3, 9, "B_L_S.v3");
  }
}
static Arrange_To_Call_Me vB_L_S(Test_B_L_S, "B_L_S", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_Uc()
{
  {
    init_simple_test("B_L_Uc");
    B_L_Uc lv;
    check2(sizeof(lv), 10, "sizeof(B_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_Uc)");
    check_field_offset(lv, v1, 0, "B_L_Uc.v1");
    check_field_offset(lv, v2, 1, "B_L_Uc.v2");
    check_field_offset(lv, v3, 9, "B_L_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_L_Uc(Test_B_L_Uc, "B_L_Uc", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_Ui()
{
  {
    init_simple_test("B_L_Ui");
    B_L_Ui lv;
    check2(sizeof(lv), 13, "sizeof(B_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_Ui)");
    check_field_offset(lv, v1, 0, "B_L_Ui.v1");
    check_field_offset(lv, v2, 1, "B_L_Ui.v2");
    check_field_offset(lv, v3, 9, "B_L_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_L_Ui(Test_B_L_Ui, "B_L_Ui", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_Ul()
{
  {
    init_simple_test("B_L_Ul");
    B_L_Ul lv;
    check2(sizeof(lv), 17, "sizeof(B_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_Ul)");
    check_field_offset(lv, v1, 0, "B_L_Ul.v1");
    check_field_offset(lv, v2, 1, "B_L_Ul.v2");
    check_field_offset(lv, v3, 9, "B_L_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_L_Ul(Test_B_L_Ul, "B_L_Ul", 17);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_Us()
{
  {
    init_simple_test("B_L_Us");
    B_L_Us lv;
    check2(sizeof(lv), 11, "sizeof(B_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_Us)");
    check_field_offset(lv, v1, 0, "B_L_Us.v1");
    check_field_offset(lv, v2, 1, "B_L_Us.v2");
    check_field_offset(lv, v3, 9, "B_L_Us.v3");
  }
}
static Arrange_To_Call_Me vB_L_Us(Test_B_L_Us, "B_L_Us", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_L_Vp()
{
  {
    init_simple_test("B_L_Vp");
    B_L_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(B_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_L_Vp)");
    check_field_offset(lv, v1, 0, "B_L_Vp.v1");
    check_field_offset(lv, v2, 1, "B_L_Vp.v2");
    check_field_offset(lv, v3, 9, "B_L_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_L_Vp(Test_B_L_Vp, "B_L_Vp", ABISELECT(17,13));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S()
{
  {
    init_simple_test("B_S");
    B_S lv;
    check2(sizeof(lv), 3, "sizeof(B_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_S)");
    check_field_offset(lv, v1, 0, "B_S.v1");
    check_field_offset(lv, v2, 1, "B_S.v2");
  }
}
static Arrange_To_Call_Me vB_S(Test_B_S, "B_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_B()
{
  {
    init_simple_test("B_S_B");
    B_S_B lv;
    check2(sizeof(lv), 4, "sizeof(B_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_B)");
    check_field_offset(lv, v1, 0, "B_S_B.v1");
    check_field_offset(lv, v2, 1, "B_S_B.v2");
    check_field_offset(lv, v3, 3, "B_S_B.v3");
  }
}
static Arrange_To_Call_Me vB_S_B(Test_B_S_B, "B_S_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu15i()
{
  {
    init_simple_test("B_S_BFu15i");
    static B_S_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(B_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu15i)");
    check_field_offset(lv, v1, 0, "B_S_BFu15i.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "B_S_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "B_S_BFu15i");
  }
}
static Arrange_To_Call_Me vB_S_BFu15i(Test_B_S_BFu15i, "B_S_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu15ll()
{
  {
    init_simple_test("B_S_BFu15ll");
    static B_S_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(B_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_S_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "B_S_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "B_S_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_S_BFu15ll(Test_B_S_BFu15ll, "B_S_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu15s()
{
  {
    init_simple_test("B_S_BFu15s");
    static B_S_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(B_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu15s)");
    check_field_offset(lv, v1, 0, "B_S_BFu15s.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "B_S_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "B_S_BFu15s");
  }
}
static Arrange_To_Call_Me vB_S_BFu15s(Test_B_S_BFu15s, "B_S_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu16i()
{
  {
    init_simple_test("B_S_BFu16i");
    static B_S_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(B_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu16i)");
    check_field_offset(lv, v1, 0, "B_S_BFu16i.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "B_S_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "B_S_BFu16i");
  }
}
static Arrange_To_Call_Me vB_S_BFu16i(Test_B_S_BFu16i, "B_S_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu16ll()
{
  {
    init_simple_test("B_S_BFu16ll");
    static B_S_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(B_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_S_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "B_S_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "B_S_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_S_BFu16ll(Test_B_S_BFu16ll, "B_S_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu16s()
{
  {
    init_simple_test("B_S_BFu16s");
    static B_S_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(B_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu16s)");
    check_field_offset(lv, v1, 0, "B_S_BFu16s.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "B_S_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "B_S_BFu16s");
  }
}
static Arrange_To_Call_Me vB_S_BFu16s(Test_B_S_BFu16s, "B_S_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu17i()
{
  {
    init_simple_test("B_S_BFu17i");
    static B_S_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(B_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu17i)");
    check_field_offset(lv, v1, 0, "B_S_BFu17i.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "B_S_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "B_S_BFu17i");
  }
}
static Arrange_To_Call_Me vB_S_BFu17i(Test_B_S_BFu17i, "B_S_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu17ll()
{
  {
    init_simple_test("B_S_BFu17ll");
    static B_S_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(B_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_S_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "B_S_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "B_S_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_S_BFu17ll(Test_B_S_BFu17ll, "B_S_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu1c()
{
  {
    init_simple_test("B_S_BFu1c");
    static B_S_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(B_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu1c)");
    check_field_offset(lv, v1, 0, "B_S_BFu1c.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_S_BFu1c");
  }
}
static Arrange_To_Call_Me vB_S_BFu1c(Test_B_S_BFu1c, "B_S_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu1i()
{
  {
    init_simple_test("B_S_BFu1i");
    static B_S_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu1i)");
    check_field_offset(lv, v1, 0, "B_S_BFu1i.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_S_BFu1i");
  }
}
static Arrange_To_Call_Me vB_S_BFu1i(Test_B_S_BFu1i, "B_S_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu1ll()
{
  {
    init_simple_test("B_S_BFu1ll");
    static B_S_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(B_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_S_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_S_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_S_BFu1ll(Test_B_S_BFu1ll, "B_S_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu1s()
{
  {
    init_simple_test("B_S_BFu1s");
    static B_S_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(B_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu1s)");
    check_field_offset(lv, v1, 0, "B_S_BFu1s.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_S_BFu1s");
  }
}
static Arrange_To_Call_Me vB_S_BFu1s(Test_B_S_BFu1s, "B_S_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu31i()
{
  {
    init_simple_test("B_S_BFu31i");
    static B_S_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(B_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu31i)");
    check_field_offset(lv, v1, 0, "B_S_BFu31i.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "B_S_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "B_S_BFu31i");
  }
}
static Arrange_To_Call_Me vB_S_BFu31i(Test_B_S_BFu31i, "B_S_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu31ll()
{
  {
    init_simple_test("B_S_BFu31ll");
    static B_S_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(B_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_S_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "B_S_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "B_S_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_S_BFu31ll(Test_B_S_BFu31ll, "B_S_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu32i()
{
  {
    init_simple_test("B_S_BFu32i");
    static B_S_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(B_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu32i)");
    check_field_offset(lv, v1, 0, "B_S_BFu32i.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "B_S_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "B_S_BFu32i");
  }
}
static Arrange_To_Call_Me vB_S_BFu32i(Test_B_S_BFu32i, "B_S_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu32ll()
{
  {
    init_simple_test("B_S_BFu32ll");
    static B_S_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(B_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_S_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "B_S_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "B_S_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_S_BFu32ll(Test_B_S_BFu32ll, "B_S_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu33()
{
  {
    init_simple_test("B_S_BFu33");
    static B_S_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu33)");
    check_field_offset(lv, v1, 0, "B_S_BFu33.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "B_S_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "B_S_BFu33");
  }
}
static Arrange_To_Call_Me vB_S_BFu33(Test_B_S_BFu33, "B_S_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu7c()
{
  {
    init_simple_test("B_S_BFu7c");
    static B_S_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(B_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu7c)");
    check_field_offset(lv, v1, 0, "B_S_BFu7c.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_S_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_S_BFu7c");
  }
}
static Arrange_To_Call_Me vB_S_BFu7c(Test_B_S_BFu7c, "B_S_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu7i()
{
  {
    init_simple_test("B_S_BFu7i");
    static B_S_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu7i)");
    check_field_offset(lv, v1, 0, "B_S_BFu7i.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_S_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_S_BFu7i");
  }
}
static Arrange_To_Call_Me vB_S_BFu7i(Test_B_S_BFu7i, "B_S_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu7ll()
{
  {
    init_simple_test("B_S_BFu7ll");
    static B_S_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(B_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_S_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_S_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_S_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_S_BFu7ll(Test_B_S_BFu7ll, "B_S_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu7s()
{
  {
    init_simple_test("B_S_BFu7s");
    static B_S_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu7s)");
    check_field_offset(lv, v1, 0, "B_S_BFu7s.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_S_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_S_BFu7s");
  }
}
static Arrange_To_Call_Me vB_S_BFu7s(Test_B_S_BFu7s, "B_S_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu8c()
{
  {
    init_simple_test("B_S_BFu8c");
    static B_S_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu8c)");
    check_field_offset(lv, v1, 0, "B_S_BFu8c.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_S_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_S_BFu8c");
  }
}
static Arrange_To_Call_Me vB_S_BFu8c(Test_B_S_BFu8c, "B_S_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu8i()
{
  {
    init_simple_test("B_S_BFu8i");
    static B_S_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu8i)");
    check_field_offset(lv, v1, 0, "B_S_BFu8i.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_S_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_S_BFu8i");
  }
}
static Arrange_To_Call_Me vB_S_BFu8i(Test_B_S_BFu8i, "B_S_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu8ll()
{
  {
    init_simple_test("B_S_BFu8ll");
    static B_S_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(B_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_S_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_S_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_S_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_S_BFu8ll(Test_B_S_BFu8ll, "B_S_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu8s()
{
  {
    init_simple_test("B_S_BFu8s");
    static B_S_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu8s)");
    check_field_offset(lv, v1, 0, "B_S_BFu8s.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_S_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_S_BFu8s");
  }
}
static Arrange_To_Call_Me vB_S_BFu8s(Test_B_S_BFu8s, "B_S_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu9i()
{
  {
    init_simple_test("B_S_BFu9i");
    static B_S_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(B_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu9i)");
    check_field_offset(lv, v1, 0, "B_S_BFu9i.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "B_S_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "B_S_BFu9i");
  }
}
static Arrange_To_Call_Me vB_S_BFu9i(Test_B_S_BFu9i, "B_S_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu9ll()
{
  {
    init_simple_test("B_S_BFu9ll");
    static B_S_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(B_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_S_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "B_S_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "B_S_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_S_BFu9ll(Test_B_S_BFu9ll, "B_S_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_BFu9s()
{
  {
    init_simple_test("B_S_BFu9s");
    static B_S_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(B_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_BFu9s)");
    check_field_offset(lv, v1, 0, "B_S_BFu9s.v1");
    check_field_offset(lv, v2, 1, "B_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "B_S_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "B_S_BFu9s");
  }
}
static Arrange_To_Call_Me vB_S_BFu9s(Test_B_S_BFu9s, "B_S_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_C()
{
  {
    init_simple_test("B_S_C");
    B_S_C lv;
    check2(sizeof(lv), 4, "sizeof(B_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_C)");
    check_field_offset(lv, v1, 0, "B_S_C.v1");
    check_field_offset(lv, v2, 1, "B_S_C.v2");
    check_field_offset(lv, v3, 3, "B_S_C.v3");
  }
}
static Arrange_To_Call_Me vB_S_C(Test_B_S_C, "B_S_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_D()
{
  {
    init_simple_test("B_S_D");
    B_S_D lv;
    check2(sizeof(lv), 11, "sizeof(B_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_D)");
    check_field_offset(lv, v1, 0, "B_S_D.v1");
    check_field_offset(lv, v2, 1, "B_S_D.v2");
    check_field_offset(lv, v3, 3, "B_S_D.v3");
  }
}
static Arrange_To_Call_Me vB_S_D(Test_B_S_D, "B_S_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_F()
{
  {
    init_simple_test("B_S_F");
    B_S_F lv;
    check2(sizeof(lv), 7, "sizeof(B_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_F)");
    check_field_offset(lv, v1, 0, "B_S_F.v1");
    check_field_offset(lv, v2, 1, "B_S_F.v2");
    check_field_offset(lv, v3, 3, "B_S_F.v3");
  }
}
static Arrange_To_Call_Me vB_S_F(Test_B_S_F, "B_S_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_I()
{
  {
    init_simple_test("B_S_I");
    B_S_I lv;
    check2(sizeof(lv), 7, "sizeof(B_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_I)");
    check_field_offset(lv, v1, 0, "B_S_I.v1");
    check_field_offset(lv, v2, 1, "B_S_I.v2");
    check_field_offset(lv, v3, 3, "B_S_I.v3");
  }
}
static Arrange_To_Call_Me vB_S_I(Test_B_S_I, "B_S_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_Ip()
{
  {
    init_simple_test("B_S_Ip");
    B_S_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_Ip)");
    check_field_offset(lv, v1, 0, "B_S_Ip.v1");
    check_field_offset(lv, v2, 1, "B_S_Ip.v2");
    check_field_offset(lv, v3, 3, "B_S_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_S_Ip(Test_B_S_Ip, "B_S_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_L()
{
  {
    init_simple_test("B_S_L");
    B_S_L lv;
    check2(sizeof(lv), 11, "sizeof(B_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_L)");
    check_field_offset(lv, v1, 0, "B_S_L.v1");
    check_field_offset(lv, v2, 1, "B_S_L.v2");
    check_field_offset(lv, v3, 3, "B_S_L.v3");
  }
}
static Arrange_To_Call_Me vB_S_L(Test_B_S_L, "B_S_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_S()
{
  {
    init_simple_test("B_S_S");
    B_S_S lv;
    check2(sizeof(lv), 5, "sizeof(B_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_S)");
    check_field_offset(lv, v1, 0, "B_S_S.v1");
    check_field_offset(lv, v2, 1, "B_S_S.v2");
    check_field_offset(lv, v3, 3, "B_S_S.v3");
  }
}
static Arrange_To_Call_Me vB_S_S(Test_B_S_S, "B_S_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_Uc()
{
  {
    init_simple_test("B_S_Uc");
    B_S_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_Uc)");
    check_field_offset(lv, v1, 0, "B_S_Uc.v1");
    check_field_offset(lv, v2, 1, "B_S_Uc.v2");
    check_field_offset(lv, v3, 3, "B_S_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_S_Uc(Test_B_S_Uc, "B_S_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_Ui()
{
  {
    init_simple_test("B_S_Ui");
    B_S_Ui lv;
    check2(sizeof(lv), 7, "sizeof(B_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_Ui)");
    check_field_offset(lv, v1, 0, "B_S_Ui.v1");
    check_field_offset(lv, v2, 1, "B_S_Ui.v2");
    check_field_offset(lv, v3, 3, "B_S_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_S_Ui(Test_B_S_Ui, "B_S_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_Ul()
{
  {
    init_simple_test("B_S_Ul");
    B_S_Ul lv;
    check2(sizeof(lv), 11, "sizeof(B_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_Ul)");
    check_field_offset(lv, v1, 0, "B_S_Ul.v1");
    check_field_offset(lv, v2, 1, "B_S_Ul.v2");
    check_field_offset(lv, v3, 3, "B_S_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_S_Ul(Test_B_S_Ul, "B_S_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_Us()
{
  {
    init_simple_test("B_S_Us");
    B_S_Us lv;
    check2(sizeof(lv), 5, "sizeof(B_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_Us)");
    check_field_offset(lv, v1, 0, "B_S_Us.v1");
    check_field_offset(lv, v2, 1, "B_S_Us.v2");
    check_field_offset(lv, v3, 3, "B_S_Us.v3");
  }
}
static Arrange_To_Call_Me vB_S_Us(Test_B_S_Us, "B_S_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_S_Vp()
{
  {
    init_simple_test("B_S_Vp");
    B_S_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_S_Vp)");
    check_field_offset(lv, v1, 0, "B_S_Vp.v1");
    check_field_offset(lv, v2, 1, "B_S_Vp.v2");
    check_field_offset(lv, v3, 3, "B_S_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_S_Vp(Test_B_S_Vp, "B_S_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc()
{
  {
    init_simple_test("B_Uc");
    B_Uc lv;
    check2(sizeof(lv), 2, "sizeof(B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc)");
    check_field_offset(lv, v1, 0, "B_Uc.v1");
    check_field_offset(lv, v2, 1, "B_Uc.v2");
  }
}
static Arrange_To_Call_Me vB_Uc(Test_B_Uc, "B_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_B()
{
  {
    init_simple_test("B_Uc_B");
    B_Uc_B lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_B)");
    check_field_offset(lv, v1, 0, "B_Uc_B.v1");
    check_field_offset(lv, v2, 1, "B_Uc_B.v2");
    check_field_offset(lv, v3, 2, "B_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vB_Uc_B(Test_B_Uc_B, "B_Uc_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu15i()
{
  {
    init_simple_test("B_Uc_BFu15i");
    static B_Uc_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu15i.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_Uc_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_Uc_BFu15i");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu15i(Test_B_Uc_BFu15i, "B_Uc_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu15ll()
{
  {
    init_simple_test("B_Uc_BFu15ll");
    static B_Uc_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(B_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_Uc_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu15ll(Test_B_Uc_BFu15ll, "B_Uc_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu15s()
{
  {
    init_simple_test("B_Uc_BFu15s");
    static B_Uc_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu15s.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_Uc_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_Uc_BFu15s");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu15s(Test_B_Uc_BFu15s, "B_Uc_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu16i()
{
  {
    init_simple_test("B_Uc_BFu16i");
    static B_Uc_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu16i.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_Uc_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_Uc_BFu16i");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu16i(Test_B_Uc_BFu16i, "B_Uc_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu16ll()
{
  {
    init_simple_test("B_Uc_BFu16ll");
    static B_Uc_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(B_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_Uc_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu16ll(Test_B_Uc_BFu16ll, "B_Uc_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu16s()
{
  {
    init_simple_test("B_Uc_BFu16s");
    static B_Uc_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu16s.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_Uc_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_Uc_BFu16s");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu16s(Test_B_Uc_BFu16s, "B_Uc_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu17i()
{
  {
    init_simple_test("B_Uc_BFu17i");
    static B_Uc_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(B_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu17i.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "B_Uc_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "B_Uc_BFu17i");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu17i(Test_B_Uc_BFu17i, "B_Uc_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu17ll()
{
  {
    init_simple_test("B_Uc_BFu17ll");
    static B_Uc_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(B_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "B_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "B_Uc_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu17ll(Test_B_Uc_BFu17ll, "B_Uc_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu1c()
{
  {
    init_simple_test("B_Uc_BFu1c");
    static B_Uc_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu1c.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_Uc_BFu1c");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu1c(Test_B_Uc_BFu1c, "B_Uc_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu1i()
{
  {
    init_simple_test("B_Uc_BFu1i");
    static B_Uc_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu1i.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_Uc_BFu1i");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu1i(Test_B_Uc_BFu1i, "B_Uc_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu1ll()
{
  {
    init_simple_test("B_Uc_BFu1ll");
    static B_Uc_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_Uc_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu1ll(Test_B_Uc_BFu1ll, "B_Uc_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu1s()
{
  {
    init_simple_test("B_Uc_BFu1s");
    static B_Uc_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu1s.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_Uc_BFu1s");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu1s(Test_B_Uc_BFu1s, "B_Uc_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu31i()
{
  {
    init_simple_test("B_Uc_BFu31i");
    static B_Uc_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(B_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu31i.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "B_Uc_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "B_Uc_BFu31i");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu31i(Test_B_Uc_BFu31i, "B_Uc_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu31ll()
{
  {
    init_simple_test("B_Uc_BFu31ll");
    static B_Uc_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(B_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "B_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "B_Uc_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu31ll(Test_B_Uc_BFu31ll, "B_Uc_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu32i()
{
  {
    init_simple_test("B_Uc_BFu32i");
    static B_Uc_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(B_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu32i.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "B_Uc_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "B_Uc_BFu32i");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu32i(Test_B_Uc_BFu32i, "B_Uc_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu32ll()
{
  {
    init_simple_test("B_Uc_BFu32ll");
    static B_Uc_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(B_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "B_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "B_Uc_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu32ll(Test_B_Uc_BFu32ll, "B_Uc_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu33()
{
  {
    init_simple_test("B_Uc_BFu33");
    static B_Uc_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(B_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu33.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "B_Uc_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "B_Uc_BFu33");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu33(Test_B_Uc_BFu33, "B_Uc_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu7c()
{
  {
    init_simple_test("B_Uc_BFu7c");
    static B_Uc_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu7c.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_Uc_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_Uc_BFu7c");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu7c(Test_B_Uc_BFu7c, "B_Uc_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu7i()
{
  {
    init_simple_test("B_Uc_BFu7i");
    static B_Uc_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu7i.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_Uc_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_Uc_BFu7i");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu7i(Test_B_Uc_BFu7i, "B_Uc_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu7ll()
{
  {
    init_simple_test("B_Uc_BFu7ll");
    static B_Uc_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_Uc_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu7ll(Test_B_Uc_BFu7ll, "B_Uc_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu7s()
{
  {
    init_simple_test("B_Uc_BFu7s");
    static B_Uc_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu7s.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_Uc_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_Uc_BFu7s");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu7s(Test_B_Uc_BFu7s, "B_Uc_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu8c()
{
  {
    init_simple_test("B_Uc_BFu8c");
    static B_Uc_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu8c.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_Uc_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_Uc_BFu8c");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu8c(Test_B_Uc_BFu8c, "B_Uc_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu8i()
{
  {
    init_simple_test("B_Uc_BFu8i");
    static B_Uc_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu8i.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_Uc_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_Uc_BFu8i");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu8i(Test_B_Uc_BFu8i, "B_Uc_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu8ll()
{
  {
    init_simple_test("B_Uc_BFu8ll");
    static B_Uc_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_Uc_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu8ll(Test_B_Uc_BFu8ll, "B_Uc_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu8s()
{
  {
    init_simple_test("B_Uc_BFu8s");
    static B_Uc_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu8s.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_Uc_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_Uc_BFu8s");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu8s(Test_B_Uc_BFu8s, "B_Uc_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu9i()
{
  {
    init_simple_test("B_Uc_BFu9i");
    static B_Uc_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu9i.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_Uc_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_Uc_BFu9i");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu9i(Test_B_Uc_BFu9i, "B_Uc_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu9ll()
{
  {
    init_simple_test("B_Uc_BFu9ll");
    static B_Uc_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(B_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_Uc_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu9ll(Test_B_Uc_BFu9ll, "B_Uc_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_BFu9s()
{
  {
    init_simple_test("B_Uc_BFu9s");
    static B_Uc_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "B_Uc_BFu9s.v1");
    check_field_offset(lv, v2, 1, "B_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_Uc_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_Uc_BFu9s");
  }
}
static Arrange_To_Call_Me vB_Uc_BFu9s(Test_B_Uc_BFu9s, "B_Uc_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_C()
{
  {
    init_simple_test("B_Uc_C");
    B_Uc_C lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_C)");
    check_field_offset(lv, v1, 0, "B_Uc_C.v1");
    check_field_offset(lv, v2, 1, "B_Uc_C.v2");
    check_field_offset(lv, v3, 2, "B_Uc_C.v3");
  }
}
static Arrange_To_Call_Me vB_Uc_C(Test_B_Uc_C, "B_Uc_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_D()
{
  {
    init_simple_test("B_Uc_D");
    B_Uc_D lv;
    check2(sizeof(lv), 10, "sizeof(B_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_D)");
    check_field_offset(lv, v1, 0, "B_Uc_D.v1");
    check_field_offset(lv, v2, 1, "B_Uc_D.v2");
    check_field_offset(lv, v3, 2, "B_Uc_D.v3");
  }
}
static Arrange_To_Call_Me vB_Uc_D(Test_B_Uc_D, "B_Uc_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_F()
{
  {
    init_simple_test("B_Uc_F");
    B_Uc_F lv;
    check2(sizeof(lv), 6, "sizeof(B_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_F)");
    check_field_offset(lv, v1, 0, "B_Uc_F.v1");
    check_field_offset(lv, v2, 1, "B_Uc_F.v2");
    check_field_offset(lv, v3, 2, "B_Uc_F.v3");
  }
}
static Arrange_To_Call_Me vB_Uc_F(Test_B_Uc_F, "B_Uc_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_I()
{
  {
    init_simple_test("B_Uc_I");
    B_Uc_I lv;
    check2(sizeof(lv), 6, "sizeof(B_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_I)");
    check_field_offset(lv, v1, 0, "B_Uc_I.v1");
    check_field_offset(lv, v2, 1, "B_Uc_I.v2");
    check_field_offset(lv, v3, 2, "B_Uc_I.v3");
  }
}
static Arrange_To_Call_Me vB_Uc_I(Test_B_Uc_I, "B_Uc_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_Ip()
{
  {
    init_simple_test("B_Uc_Ip");
    B_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_Ip)");
    check_field_offset(lv, v1, 0, "B_Uc_Ip.v1");
    check_field_offset(lv, v2, 1, "B_Uc_Ip.v2");
    check_field_offset(lv, v3, 2, "B_Uc_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_Uc_Ip(Test_B_Uc_Ip, "B_Uc_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_L()
{
  {
    init_simple_test("B_Uc_L");
    B_Uc_L lv;
    check2(sizeof(lv), 10, "sizeof(B_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_L)");
    check_field_offset(lv, v1, 0, "B_Uc_L.v1");
    check_field_offset(lv, v2, 1, "B_Uc_L.v2");
    check_field_offset(lv, v3, 2, "B_Uc_L.v3");
  }
}
static Arrange_To_Call_Me vB_Uc_L(Test_B_Uc_L, "B_Uc_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_S()
{
  {
    init_simple_test("B_Uc_S");
    B_Uc_S lv;
    check2(sizeof(lv), 4, "sizeof(B_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_S)");
    check_field_offset(lv, v1, 0, "B_Uc_S.v1");
    check_field_offset(lv, v2, 1, "B_Uc_S.v2");
    check_field_offset(lv, v3, 2, "B_Uc_S.v3");
  }
}
static Arrange_To_Call_Me vB_Uc_S(Test_B_Uc_S, "B_Uc_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_Uc()
{
  {
    init_simple_test("B_Uc_Uc");
    B_Uc_Uc lv;
    check2(sizeof(lv), 3, "sizeof(B_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_Uc)");
    check_field_offset(lv, v1, 0, "B_Uc_Uc.v1");
    check_field_offset(lv, v2, 1, "B_Uc_Uc.v2");
    check_field_offset(lv, v3, 2, "B_Uc_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_Uc_Uc(Test_B_Uc_Uc, "B_Uc_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_Ui()
{
  {
    init_simple_test("B_Uc_Ui");
    B_Uc_Ui lv;
    check2(sizeof(lv), 6, "sizeof(B_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_Ui)");
    check_field_offset(lv, v1, 0, "B_Uc_Ui.v1");
    check_field_offset(lv, v2, 1, "B_Uc_Ui.v2");
    check_field_offset(lv, v3, 2, "B_Uc_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_Uc_Ui(Test_B_Uc_Ui, "B_Uc_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_Ul()
{
  {
    init_simple_test("B_Uc_Ul");
    B_Uc_Ul lv;
    check2(sizeof(lv), 10, "sizeof(B_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_Ul)");
    check_field_offset(lv, v1, 0, "B_Uc_Ul.v1");
    check_field_offset(lv, v2, 1, "B_Uc_Ul.v2");
    check_field_offset(lv, v3, 2, "B_Uc_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_Uc_Ul(Test_B_Uc_Ul, "B_Uc_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_Us()
{
  {
    init_simple_test("B_Uc_Us");
    B_Uc_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_Us)");
    check_field_offset(lv, v1, 0, "B_Uc_Us.v1");
    check_field_offset(lv, v2, 1, "B_Uc_Us.v2");
    check_field_offset(lv, v3, 2, "B_Uc_Us.v3");
  }
}
static Arrange_To_Call_Me vB_Uc_Us(Test_B_Uc_Us, "B_Uc_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Uc_Vp()
{
  {
    init_simple_test("B_Uc_Vp");
    B_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_Uc_Vp)");
    check_field_offset(lv, v1, 0, "B_Uc_Vp.v1");
    check_field_offset(lv, v2, 1, "B_Uc_Vp.v2");
    check_field_offset(lv, v3, 2, "B_Uc_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_Uc_Vp(Test_B_Uc_Vp, "B_Uc_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui()
{
  {
    init_simple_test("B_Ui");
    B_Ui lv;
    check2(sizeof(lv), 5, "sizeof(B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui)");
    check_field_offset(lv, v1, 0, "B_Ui.v1");
    check_field_offset(lv, v2, 1, "B_Ui.v2");
  }
}
static Arrange_To_Call_Me vB_Ui(Test_B_Ui, "B_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_B()
{
  {
    init_simple_test("B_Ui_B");
    B_Ui_B lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_B)");
    check_field_offset(lv, v1, 0, "B_Ui_B.v1");
    check_field_offset(lv, v2, 1, "B_Ui_B.v2");
    check_field_offset(lv, v3, 5, "B_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vB_Ui_B(Test_B_Ui_B, "B_Ui_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu15i()
{
  {
    init_simple_test("B_Ui_BFu15i");
    static B_Ui_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(B_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu15i.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "B_Ui_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "B_Ui_BFu15i");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu15i(Test_B_Ui_BFu15i, "B_Ui_BFu15i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu15ll()
{
  {
    init_simple_test("B_Ui_BFu15ll");
    static B_Ui_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(B_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "B_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "B_Ui_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu15ll(Test_B_Ui_BFu15ll, "B_Ui_BFu15ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu15s()
{
  {
    init_simple_test("B_Ui_BFu15s");
    static B_Ui_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(B_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu15s.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "B_Ui_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "B_Ui_BFu15s");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu15s(Test_B_Ui_BFu15s, "B_Ui_BFu15s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu16i()
{
  {
    init_simple_test("B_Ui_BFu16i");
    static B_Ui_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(B_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "B_Ui_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "B_Ui_BFu16i");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu16i(Test_B_Ui_BFu16i, "B_Ui_BFu16i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu16ll()
{
  {
    init_simple_test("B_Ui_BFu16ll");
    static B_Ui_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(B_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "B_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "B_Ui_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu16ll(Test_B_Ui_BFu16ll, "B_Ui_BFu16ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu16s()
{
  {
    init_simple_test("B_Ui_BFu16s");
    static B_Ui_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(B_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "B_Ui_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "B_Ui_BFu16s");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu16s(Test_B_Ui_BFu16s, "B_Ui_BFu16s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu17i()
{
  {
    init_simple_test("B_Ui_BFu17i");
    static B_Ui_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "B_Ui_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "B_Ui_BFu17i");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu17i(Test_B_Ui_BFu17i, "B_Ui_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu17ll()
{
  {
    init_simple_test("B_Ui_BFu17ll");
    static B_Ui_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "B_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "B_Ui_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu17ll(Test_B_Ui_BFu17ll, "B_Ui_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu1c()
{
  {
    init_simple_test("B_Ui_BFu1c");
    static B_Ui_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_Ui_BFu1c");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu1c(Test_B_Ui_BFu1c, "B_Ui_BFu1c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu1i()
{
  {
    init_simple_test("B_Ui_BFu1i");
    static B_Ui_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_Ui_BFu1i");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu1i(Test_B_Ui_BFu1i, "B_Ui_BFu1i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu1ll()
{
  {
    init_simple_test("B_Ui_BFu1ll");
    static B_Ui_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_Ui_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu1ll(Test_B_Ui_BFu1ll, "B_Ui_BFu1ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu1s()
{
  {
    init_simple_test("B_Ui_BFu1s");
    static B_Ui_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_Ui_BFu1s");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu1s(Test_B_Ui_BFu1s, "B_Ui_BFu1s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu31i()
{
  {
    init_simple_test("B_Ui_BFu31i");
    static B_Ui_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(B_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "B_Ui_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "B_Ui_BFu31i");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu31i(Test_B_Ui_BFu31i, "B_Ui_BFu31i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu31ll()
{
  {
    init_simple_test("B_Ui_BFu31ll");
    static B_Ui_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(B_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "B_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "B_Ui_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu31ll(Test_B_Ui_BFu31ll, "B_Ui_BFu31ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu32i()
{
  {
    init_simple_test("B_Ui_BFu32i");
    static B_Ui_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(B_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "B_Ui_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "B_Ui_BFu32i");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu32i(Test_B_Ui_BFu32i, "B_Ui_BFu32i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu32ll()
{
  {
    init_simple_test("B_Ui_BFu32ll");
    static B_Ui_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(B_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "B_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "B_Ui_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu32ll(Test_B_Ui_BFu32ll, "B_Ui_BFu32ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu33()
{
  {
    init_simple_test("B_Ui_BFu33");
    static B_Ui_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(B_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu33.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "B_Ui_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "B_Ui_BFu33");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu33(Test_B_Ui_BFu33, "B_Ui_BFu33", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu7c()
{
  {
    init_simple_test("B_Ui_BFu7c");
    static B_Ui_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_Ui_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_Ui_BFu7c");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu7c(Test_B_Ui_BFu7c, "B_Ui_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu7i()
{
  {
    init_simple_test("B_Ui_BFu7i");
    static B_Ui_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_Ui_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_Ui_BFu7i");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu7i(Test_B_Ui_BFu7i, "B_Ui_BFu7i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu7ll()
{
  {
    init_simple_test("B_Ui_BFu7ll");
    static B_Ui_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_Ui_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu7ll(Test_B_Ui_BFu7ll, "B_Ui_BFu7ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu7s()
{
  {
    init_simple_test("B_Ui_BFu7s");
    static B_Ui_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_Ui_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_Ui_BFu7s");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu7s(Test_B_Ui_BFu7s, "B_Ui_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu8c()
{
  {
    init_simple_test("B_Ui_BFu8c");
    static B_Ui_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_Ui_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_Ui_BFu8c");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu8c(Test_B_Ui_BFu8c, "B_Ui_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu8i()
{
  {
    init_simple_test("B_Ui_BFu8i");
    static B_Ui_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_Ui_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_Ui_BFu8i");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu8i(Test_B_Ui_BFu8i, "B_Ui_BFu8i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu8ll()
{
  {
    init_simple_test("B_Ui_BFu8ll");
    static B_Ui_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_Ui_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu8ll(Test_B_Ui_BFu8ll, "B_Ui_BFu8ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu8s()
{
  {
    init_simple_test("B_Ui_BFu8s");
    static B_Ui_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_Ui_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_Ui_BFu8s");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu8s(Test_B_Ui_BFu8s, "B_Ui_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu9i()
{
  {
    init_simple_test("B_Ui_BFu9i");
    static B_Ui_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(B_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "B_Ui_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "B_Ui_BFu9i");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu9i(Test_B_Ui_BFu9i, "B_Ui_BFu9i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu9ll()
{
  {
    init_simple_test("B_Ui_BFu9ll");
    static B_Ui_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(B_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "B_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "B_Ui_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu9ll(Test_B_Ui_BFu9ll, "B_Ui_BFu9ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_BFu9s()
{
  {
    init_simple_test("B_Ui_BFu9s");
    static B_Ui_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(B_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "B_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 1, "B_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "B_Ui_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "B_Ui_BFu9s");
  }
}
static Arrange_To_Call_Me vB_Ui_BFu9s(Test_B_Ui_BFu9s, "B_Ui_BFu9s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_C()
{
  {
    init_simple_test("B_Ui_C");
    B_Ui_C lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_C)");
    check_field_offset(lv, v1, 0, "B_Ui_C.v1");
    check_field_offset(lv, v2, 1, "B_Ui_C.v2");
    check_field_offset(lv, v3, 5, "B_Ui_C.v3");
  }
}
static Arrange_To_Call_Me vB_Ui_C(Test_B_Ui_C, "B_Ui_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_D()
{
  {
    init_simple_test("B_Ui_D");
    B_Ui_D lv;
    check2(sizeof(lv), 13, "sizeof(B_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_D)");
    check_field_offset(lv, v1, 0, "B_Ui_D.v1");
    check_field_offset(lv, v2, 1, "B_Ui_D.v2");
    check_field_offset(lv, v3, 5, "B_Ui_D.v3");
  }
}
static Arrange_To_Call_Me vB_Ui_D(Test_B_Ui_D, "B_Ui_D", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_F()
{
  {
    init_simple_test("B_Ui_F");
    B_Ui_F lv;
    check2(sizeof(lv), 9, "sizeof(B_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_F)");
    check_field_offset(lv, v1, 0, "B_Ui_F.v1");
    check_field_offset(lv, v2, 1, "B_Ui_F.v2");
    check_field_offset(lv, v3, 5, "B_Ui_F.v3");
  }
}
static Arrange_To_Call_Me vB_Ui_F(Test_B_Ui_F, "B_Ui_F", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_I()
{
  {
    init_simple_test("B_Ui_I");
    B_Ui_I lv;
    check2(sizeof(lv), 9, "sizeof(B_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_I)");
    check_field_offset(lv, v1, 0, "B_Ui_I.v1");
    check_field_offset(lv, v2, 1, "B_Ui_I.v2");
    check_field_offset(lv, v3, 5, "B_Ui_I.v3");
  }
}
static Arrange_To_Call_Me vB_Ui_I(Test_B_Ui_I, "B_Ui_I", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_Ip()
{
  {
    init_simple_test("B_Ui_Ip");
    B_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_Ip)");
    check_field_offset(lv, v1, 0, "B_Ui_Ip.v1");
    check_field_offset(lv, v2, 1, "B_Ui_Ip.v2");
    check_field_offset(lv, v3, 5, "B_Ui_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_Ui_Ip(Test_B_Ui_Ip, "B_Ui_Ip", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_L()
{
  {
    init_simple_test("B_Ui_L");
    B_Ui_L lv;
    check2(sizeof(lv), 13, "sizeof(B_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_L)");
    check_field_offset(lv, v1, 0, "B_Ui_L.v1");
    check_field_offset(lv, v2, 1, "B_Ui_L.v2");
    check_field_offset(lv, v3, 5, "B_Ui_L.v3");
  }
}
static Arrange_To_Call_Me vB_Ui_L(Test_B_Ui_L, "B_Ui_L", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_S()
{
  {
    init_simple_test("B_Ui_S");
    B_Ui_S lv;
    check2(sizeof(lv), 7, "sizeof(B_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_S)");
    check_field_offset(lv, v1, 0, "B_Ui_S.v1");
    check_field_offset(lv, v2, 1, "B_Ui_S.v2");
    check_field_offset(lv, v3, 5, "B_Ui_S.v3");
  }
}
static Arrange_To_Call_Me vB_Ui_S(Test_B_Ui_S, "B_Ui_S", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_Uc()
{
  {
    init_simple_test("B_Ui_Uc");
    B_Ui_Uc lv;
    check2(sizeof(lv), 6, "sizeof(B_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_Uc)");
    check_field_offset(lv, v1, 0, "B_Ui_Uc.v1");
    check_field_offset(lv, v2, 1, "B_Ui_Uc.v2");
    check_field_offset(lv, v3, 5, "B_Ui_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_Ui_Uc(Test_B_Ui_Uc, "B_Ui_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_Ui()
{
  {
    init_simple_test("B_Ui_Ui");
    B_Ui_Ui lv;
    check2(sizeof(lv), 9, "sizeof(B_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_Ui)");
    check_field_offset(lv, v1, 0, "B_Ui_Ui.v1");
    check_field_offset(lv, v2, 1, "B_Ui_Ui.v2");
    check_field_offset(lv, v3, 5, "B_Ui_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_Ui_Ui(Test_B_Ui_Ui, "B_Ui_Ui", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_Ul()
{
  {
    init_simple_test("B_Ui_Ul");
    B_Ui_Ul lv;
    check2(sizeof(lv), 13, "sizeof(B_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_Ul)");
    check_field_offset(lv, v1, 0, "B_Ui_Ul.v1");
    check_field_offset(lv, v2, 1, "B_Ui_Ul.v2");
    check_field_offset(lv, v3, 5, "B_Ui_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_Ui_Ul(Test_B_Ui_Ul, "B_Ui_Ul", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_Us()
{
  {
    init_simple_test("B_Ui_Us");
    B_Ui_Us lv;
    check2(sizeof(lv), 7, "sizeof(B_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_Us)");
    check_field_offset(lv, v1, 0, "B_Ui_Us.v1");
    check_field_offset(lv, v2, 1, "B_Ui_Us.v2");
    check_field_offset(lv, v3, 5, "B_Ui_Us.v3");
  }
}
static Arrange_To_Call_Me vB_Ui_Us(Test_B_Ui_Us, "B_Ui_Us", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ui_Vp()
{
  {
    init_simple_test("B_Ui_Vp");
    B_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ui_Vp)");
    check_field_offset(lv, v1, 0, "B_Ui_Vp.v1");
    check_field_offset(lv, v2, 1, "B_Ui_Vp.v2");
    check_field_offset(lv, v3, 5, "B_Ui_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_Ui_Vp(Test_B_Ui_Vp, "B_Ui_Vp", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul()
{
  {
    init_simple_test("B_Ul");
    B_Ul lv;
    check2(sizeof(lv), 9, "sizeof(B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul)");
    check_field_offset(lv, v1, 0, "B_Ul.v1");
    check_field_offset(lv, v2, 1, "B_Ul.v2");
  }
}
static Arrange_To_Call_Me vB_Ul(Test_B_Ul, "B_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_B()
{
  {
    init_simple_test("B_Ul_B");
    B_Ul_B lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_B)");
    check_field_offset(lv, v1, 0, "B_Ul_B.v1");
    check_field_offset(lv, v2, 1, "B_Ul_B.v2");
    check_field_offset(lv, v3, 9, "B_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vB_Ul_B(Test_B_Ul_B, "B_Ul_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu15i()
{
  {
    init_simple_test("B_Ul_BFu15i");
    static B_Ul_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(B_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu15i.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "B_Ul_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "B_Ul_BFu15i");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu15i(Test_B_Ul_BFu15i, "B_Ul_BFu15i", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu15ll()
{
  {
    init_simple_test("B_Ul_BFu15ll");
    static B_Ul_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(B_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "B_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "B_Ul_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu15ll(Test_B_Ul_BFu15ll, "B_Ul_BFu15ll", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu15s()
{
  {
    init_simple_test("B_Ul_BFu15s");
    static B_Ul_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(B_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu15s.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "B_Ul_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "B_Ul_BFu15s");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu15s(Test_B_Ul_BFu15s, "B_Ul_BFu15s", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu16i()
{
  {
    init_simple_test("B_Ul_BFu16i");
    static B_Ul_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(B_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu16i.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "B_Ul_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "B_Ul_BFu16i");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu16i(Test_B_Ul_BFu16i, "B_Ul_BFu16i", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu16ll()
{
  {
    init_simple_test("B_Ul_BFu16ll");
    static B_Ul_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(B_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "B_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "B_Ul_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu16ll(Test_B_Ul_BFu16ll, "B_Ul_BFu16ll", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu16s()
{
  {
    init_simple_test("B_Ul_BFu16s");
    static B_Ul_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(B_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu16s.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "B_Ul_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "B_Ul_BFu16s");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu16s(Test_B_Ul_BFu16s, "B_Ul_BFu16s", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu17i()
{
  {
    init_simple_test("B_Ul_BFu17i");
    static B_Ul_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(B_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu17i.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "B_Ul_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "B_Ul_BFu17i");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu17i(Test_B_Ul_BFu17i, "B_Ul_BFu17i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu17ll()
{
  {
    init_simple_test("B_Ul_BFu17ll");
    static B_Ul_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(B_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "B_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "B_Ul_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu17ll(Test_B_Ul_BFu17ll, "B_Ul_BFu17ll", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu1c()
{
  {
    init_simple_test("B_Ul_BFu1c");
    static B_Ul_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu1c.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "B_Ul_BFu1c");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu1c(Test_B_Ul_BFu1c, "B_Ul_BFu1c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu1i()
{
  {
    init_simple_test("B_Ul_BFu1i");
    static B_Ul_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu1i.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "B_Ul_BFu1i");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu1i(Test_B_Ul_BFu1i, "B_Ul_BFu1i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu1ll()
{
  {
    init_simple_test("B_Ul_BFu1ll");
    static B_Ul_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "B_Ul_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu1ll(Test_B_Ul_BFu1ll, "B_Ul_BFu1ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu1s()
{
  {
    init_simple_test("B_Ul_BFu1s");
    static B_Ul_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu1s.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "B_Ul_BFu1s");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu1s(Test_B_Ul_BFu1s, "B_Ul_BFu1s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu31i()
{
  {
    init_simple_test("B_Ul_BFu31i");
    static B_Ul_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(B_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu31i.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "B_Ul_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "B_Ul_BFu31i");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu31i(Test_B_Ul_BFu31i, "B_Ul_BFu31i", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu31ll()
{
  {
    init_simple_test("B_Ul_BFu31ll");
    static B_Ul_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(B_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "B_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "B_Ul_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu31ll(Test_B_Ul_BFu31ll, "B_Ul_BFu31ll", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu32i()
{
  {
    init_simple_test("B_Ul_BFu32i");
    static B_Ul_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(B_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu32i.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "B_Ul_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "B_Ul_BFu32i");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu32i(Test_B_Ul_BFu32i, "B_Ul_BFu32i", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu32ll()
{
  {
    init_simple_test("B_Ul_BFu32ll");
    static B_Ul_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(B_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "B_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "B_Ul_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu32ll(Test_B_Ul_BFu32ll, "B_Ul_BFu32ll", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu33()
{
  {
    init_simple_test("B_Ul_BFu33");
    static B_Ul_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(B_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu33.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "B_Ul_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "B_Ul_BFu33");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu33(Test_B_Ul_BFu33, "B_Ul_BFu33", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu7c()
{
  {
    init_simple_test("B_Ul_BFu7c");
    static B_Ul_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu7c.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "B_Ul_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "B_Ul_BFu7c");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu7c(Test_B_Ul_BFu7c, "B_Ul_BFu7c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu7i()
{
  {
    init_simple_test("B_Ul_BFu7i");
    static B_Ul_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu7i.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "B_Ul_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "B_Ul_BFu7i");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu7i(Test_B_Ul_BFu7i, "B_Ul_BFu7i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu7ll()
{
  {
    init_simple_test("B_Ul_BFu7ll");
    static B_Ul_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "B_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "B_Ul_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu7ll(Test_B_Ul_BFu7ll, "B_Ul_BFu7ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu7s()
{
  {
    init_simple_test("B_Ul_BFu7s");
    static B_Ul_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu7s.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "B_Ul_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "B_Ul_BFu7s");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu7s(Test_B_Ul_BFu7s, "B_Ul_BFu7s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu8c()
{
  {
    init_simple_test("B_Ul_BFu8c");
    static B_Ul_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu8c.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "B_Ul_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "B_Ul_BFu8c");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu8c(Test_B_Ul_BFu8c, "B_Ul_BFu8c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu8i()
{
  {
    init_simple_test("B_Ul_BFu8i");
    static B_Ul_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu8i.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "B_Ul_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "B_Ul_BFu8i");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu8i(Test_B_Ul_BFu8i, "B_Ul_BFu8i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu8ll()
{
  {
    init_simple_test("B_Ul_BFu8ll");
    static B_Ul_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "B_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "B_Ul_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu8ll(Test_B_Ul_BFu8ll, "B_Ul_BFu8ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu8s()
{
  {
    init_simple_test("B_Ul_BFu8s");
    static B_Ul_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu8s.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "B_Ul_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "B_Ul_BFu8s");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu8s(Test_B_Ul_BFu8s, "B_Ul_BFu8s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu9i()
{
  {
    init_simple_test("B_Ul_BFu9i");
    static B_Ul_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(B_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu9i.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "B_Ul_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "B_Ul_BFu9i");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu9i(Test_B_Ul_BFu9i, "B_Ul_BFu9i", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu9ll()
{
  {
    init_simple_test("B_Ul_BFu9ll");
    static B_Ul_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(B_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "B_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "B_Ul_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu9ll(Test_B_Ul_BFu9ll, "B_Ul_BFu9ll", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_BFu9s()
{
  {
    init_simple_test("B_Ul_BFu9s");
    static B_Ul_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(B_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "B_Ul_BFu9s.v1");
    check_field_offset(lv, v2, 1, "B_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "B_Ul_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "B_Ul_BFu9s");
  }
}
static Arrange_To_Call_Me vB_Ul_BFu9s(Test_B_Ul_BFu9s, "B_Ul_BFu9s", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_C()
{
  {
    init_simple_test("B_Ul_C");
    B_Ul_C lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_C)");
    check_field_offset(lv, v1, 0, "B_Ul_C.v1");
    check_field_offset(lv, v2, 1, "B_Ul_C.v2");
    check_field_offset(lv, v3, 9, "B_Ul_C.v3");
  }
}
static Arrange_To_Call_Me vB_Ul_C(Test_B_Ul_C, "B_Ul_C", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_D()
{
  {
    init_simple_test("B_Ul_D");
    B_Ul_D lv;
    check2(sizeof(lv), 17, "sizeof(B_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_D)");
    check_field_offset(lv, v1, 0, "B_Ul_D.v1");
    check_field_offset(lv, v2, 1, "B_Ul_D.v2");
    check_field_offset(lv, v3, 9, "B_Ul_D.v3");
  }
}
static Arrange_To_Call_Me vB_Ul_D(Test_B_Ul_D, "B_Ul_D", 17);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_F()
{
  {
    init_simple_test("B_Ul_F");
    B_Ul_F lv;
    check2(sizeof(lv), 13, "sizeof(B_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_F)");
    check_field_offset(lv, v1, 0, "B_Ul_F.v1");
    check_field_offset(lv, v2, 1, "B_Ul_F.v2");
    check_field_offset(lv, v3, 9, "B_Ul_F.v3");
  }
}
static Arrange_To_Call_Me vB_Ul_F(Test_B_Ul_F, "B_Ul_F", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_I()
{
  {
    init_simple_test("B_Ul_I");
    B_Ul_I lv;
    check2(sizeof(lv), 13, "sizeof(B_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_I)");
    check_field_offset(lv, v1, 0, "B_Ul_I.v1");
    check_field_offset(lv, v2, 1, "B_Ul_I.v2");
    check_field_offset(lv, v3, 9, "B_Ul_I.v3");
  }
}
static Arrange_To_Call_Me vB_Ul_I(Test_B_Ul_I, "B_Ul_I", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_Ip()
{
  {
    init_simple_test("B_Ul_Ip");
    B_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(B_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_Ip)");
    check_field_offset(lv, v1, 0, "B_Ul_Ip.v1");
    check_field_offset(lv, v2, 1, "B_Ul_Ip.v2");
    check_field_offset(lv, v3, 9, "B_Ul_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_Ul_Ip(Test_B_Ul_Ip, "B_Ul_Ip", ABISELECT(17,13));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_L()
{
  {
    init_simple_test("B_Ul_L");
    B_Ul_L lv;
    check2(sizeof(lv), 17, "sizeof(B_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_L)");
    check_field_offset(lv, v1, 0, "B_Ul_L.v1");
    check_field_offset(lv, v2, 1, "B_Ul_L.v2");
    check_field_offset(lv, v3, 9, "B_Ul_L.v3");
  }
}
static Arrange_To_Call_Me vB_Ul_L(Test_B_Ul_L, "B_Ul_L", 17);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_S()
{
  {
    init_simple_test("B_Ul_S");
    B_Ul_S lv;
    check2(sizeof(lv), 11, "sizeof(B_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_S)");
    check_field_offset(lv, v1, 0, "B_Ul_S.v1");
    check_field_offset(lv, v2, 1, "B_Ul_S.v2");
    check_field_offset(lv, v3, 9, "B_Ul_S.v3");
  }
}
static Arrange_To_Call_Me vB_Ul_S(Test_B_Ul_S, "B_Ul_S", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_Uc()
{
  {
    init_simple_test("B_Ul_Uc");
    B_Ul_Uc lv;
    check2(sizeof(lv), 10, "sizeof(B_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_Uc)");
    check_field_offset(lv, v1, 0, "B_Ul_Uc.v1");
    check_field_offset(lv, v2, 1, "B_Ul_Uc.v2");
    check_field_offset(lv, v3, 9, "B_Ul_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_Ul_Uc(Test_B_Ul_Uc, "B_Ul_Uc", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_Ui()
{
  {
    init_simple_test("B_Ul_Ui");
    B_Ul_Ui lv;
    check2(sizeof(lv), 13, "sizeof(B_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_Ui)");
    check_field_offset(lv, v1, 0, "B_Ul_Ui.v1");
    check_field_offset(lv, v2, 1, "B_Ul_Ui.v2");
    check_field_offset(lv, v3, 9, "B_Ul_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_Ul_Ui(Test_B_Ul_Ui, "B_Ul_Ui", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_Ul()
{
  {
    init_simple_test("B_Ul_Ul");
    B_Ul_Ul lv;
    check2(sizeof(lv), 17, "sizeof(B_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_Ul)");
    check_field_offset(lv, v1, 0, "B_Ul_Ul.v1");
    check_field_offset(lv, v2, 1, "B_Ul_Ul.v2");
    check_field_offset(lv, v3, 9, "B_Ul_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_Ul_Ul(Test_B_Ul_Ul, "B_Ul_Ul", 17);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_Us()
{
  {
    init_simple_test("B_Ul_Us");
    B_Ul_Us lv;
    check2(sizeof(lv), 11, "sizeof(B_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_Us)");
    check_field_offset(lv, v1, 0, "B_Ul_Us.v1");
    check_field_offset(lv, v2, 1, "B_Ul_Us.v2");
    check_field_offset(lv, v3, 9, "B_Ul_Us.v3");
  }
}
static Arrange_To_Call_Me vB_Ul_Us(Test_B_Ul_Us, "B_Ul_Us", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Ul_Vp()
{
  {
    init_simple_test("B_Ul_Vp");
    B_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(B_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_Ul_Vp)");
    check_field_offset(lv, v1, 0, "B_Ul_Vp.v1");
    check_field_offset(lv, v2, 1, "B_Ul_Vp.v2");
    check_field_offset(lv, v3, 9, "B_Ul_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_Ul_Vp(Test_B_Ul_Vp, "B_Ul_Vp", ABISELECT(17,13));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us()
{
  {
    init_simple_test("B_Us");
    B_Us lv;
    check2(sizeof(lv), 3, "sizeof(B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us)");
    check_field_offset(lv, v1, 0, "B_Us.v1");
    check_field_offset(lv, v2, 1, "B_Us.v2");
  }
}
static Arrange_To_Call_Me vB_Us(Test_B_Us, "B_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_B()
{
  {
    init_simple_test("B_Us_B");
    B_Us_B lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_B)");
    check_field_offset(lv, v1, 0, "B_Us_B.v1");
    check_field_offset(lv, v2, 1, "B_Us_B.v2");
    check_field_offset(lv, v3, 3, "B_Us_B.v3");
  }
}
static Arrange_To_Call_Me vB_Us_B(Test_B_Us_B, "B_Us_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu15i()
{
  {
    init_simple_test("B_Us_BFu15i");
    static B_Us_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(B_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "B_Us_BFu15i.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "B_Us_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "B_Us_BFu15i");
  }
}
static Arrange_To_Call_Me vB_Us_BFu15i(Test_B_Us_BFu15i, "B_Us_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu15ll()
{
  {
    init_simple_test("B_Us_BFu15ll");
    static B_Us_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(B_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "B_Us_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "B_Us_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_Us_BFu15ll(Test_B_Us_BFu15ll, "B_Us_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu15s()
{
  {
    init_simple_test("B_Us_BFu15s");
    static B_Us_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(B_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "B_Us_BFu15s.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "B_Us_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "B_Us_BFu15s");
  }
}
static Arrange_To_Call_Me vB_Us_BFu15s(Test_B_Us_BFu15s, "B_Us_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu16i()
{
  {
    init_simple_test("B_Us_BFu16i");
    static B_Us_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(B_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "B_Us_BFu16i.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "B_Us_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "B_Us_BFu16i");
  }
}
static Arrange_To_Call_Me vB_Us_BFu16i(Test_B_Us_BFu16i, "B_Us_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu16ll()
{
  {
    init_simple_test("B_Us_BFu16ll");
    static B_Us_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(B_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "B_Us_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "B_Us_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_Us_BFu16ll(Test_B_Us_BFu16ll, "B_Us_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu16s()
{
  {
    init_simple_test("B_Us_BFu16s");
    static B_Us_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(B_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "B_Us_BFu16s.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "B_Us_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "B_Us_BFu16s");
  }
}
static Arrange_To_Call_Me vB_Us_BFu16s(Test_B_Us_BFu16s, "B_Us_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu17i()
{
  {
    init_simple_test("B_Us_BFu17i");
    static B_Us_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(B_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "B_Us_BFu17i.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "B_Us_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "B_Us_BFu17i");
  }
}
static Arrange_To_Call_Me vB_Us_BFu17i(Test_B_Us_BFu17i, "B_Us_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu17ll()
{
  {
    init_simple_test("B_Us_BFu17ll");
    static B_Us_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(B_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "B_Us_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "B_Us_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_Us_BFu17ll(Test_B_Us_BFu17ll, "B_Us_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu1c()
{
  {
    init_simple_test("B_Us_BFu1c");
    static B_Us_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "B_Us_BFu1c.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_Us_BFu1c");
  }
}
static Arrange_To_Call_Me vB_Us_BFu1c(Test_B_Us_BFu1c, "B_Us_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu1i()
{
  {
    init_simple_test("B_Us_BFu1i");
    static B_Us_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "B_Us_BFu1i.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_Us_BFu1i");
  }
}
static Arrange_To_Call_Me vB_Us_BFu1i(Test_B_Us_BFu1i, "B_Us_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu1ll()
{
  {
    init_simple_test("B_Us_BFu1ll");
    static B_Us_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_Us_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_Us_BFu1ll(Test_B_Us_BFu1ll, "B_Us_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu1s()
{
  {
    init_simple_test("B_Us_BFu1s");
    static B_Us_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "B_Us_BFu1s.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_Us_BFu1s");
  }
}
static Arrange_To_Call_Me vB_Us_BFu1s(Test_B_Us_BFu1s, "B_Us_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu31i()
{
  {
    init_simple_test("B_Us_BFu31i");
    static B_Us_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(B_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "B_Us_BFu31i.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "B_Us_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "B_Us_BFu31i");
  }
}
static Arrange_To_Call_Me vB_Us_BFu31i(Test_B_Us_BFu31i, "B_Us_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu31ll()
{
  {
    init_simple_test("B_Us_BFu31ll");
    static B_Us_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(B_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "B_Us_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "B_Us_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_Us_BFu31ll(Test_B_Us_BFu31ll, "B_Us_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu32i()
{
  {
    init_simple_test("B_Us_BFu32i");
    static B_Us_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(B_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "B_Us_BFu32i.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "B_Us_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "B_Us_BFu32i");
  }
}
static Arrange_To_Call_Me vB_Us_BFu32i(Test_B_Us_BFu32i, "B_Us_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu32ll()
{
  {
    init_simple_test("B_Us_BFu32ll");
    static B_Us_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(B_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "B_Us_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "B_Us_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_Us_BFu32ll(Test_B_Us_BFu32ll, "B_Us_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu33()
{
  {
    init_simple_test("B_Us_BFu33");
    static B_Us_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu33)");
    check_field_offset(lv, v1, 0, "B_Us_BFu33.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "B_Us_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "B_Us_BFu33");
  }
}
static Arrange_To_Call_Me vB_Us_BFu33(Test_B_Us_BFu33, "B_Us_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu7c()
{
  {
    init_simple_test("B_Us_BFu7c");
    static B_Us_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "B_Us_BFu7c.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_Us_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_Us_BFu7c");
  }
}
static Arrange_To_Call_Me vB_Us_BFu7c(Test_B_Us_BFu7c, "B_Us_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu7i()
{
  {
    init_simple_test("B_Us_BFu7i");
    static B_Us_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "B_Us_BFu7i.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_Us_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_Us_BFu7i");
  }
}
static Arrange_To_Call_Me vB_Us_BFu7i(Test_B_Us_BFu7i, "B_Us_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu7ll()
{
  {
    init_simple_test("B_Us_BFu7ll");
    static B_Us_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_Us_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_Us_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_Us_BFu7ll(Test_B_Us_BFu7ll, "B_Us_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu7s()
{
  {
    init_simple_test("B_Us_BFu7s");
    static B_Us_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "B_Us_BFu7s.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_Us_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_Us_BFu7s");
  }
}
static Arrange_To_Call_Me vB_Us_BFu7s(Test_B_Us_BFu7s, "B_Us_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu8c()
{
  {
    init_simple_test("B_Us_BFu8c");
    static B_Us_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "B_Us_BFu8c.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_Us_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_Us_BFu8c");
  }
}
static Arrange_To_Call_Me vB_Us_BFu8c(Test_B_Us_BFu8c, "B_Us_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu8i()
{
  {
    init_simple_test("B_Us_BFu8i");
    static B_Us_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "B_Us_BFu8i.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_Us_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_Us_BFu8i");
  }
}
static Arrange_To_Call_Me vB_Us_BFu8i(Test_B_Us_BFu8i, "B_Us_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu8ll()
{
  {
    init_simple_test("B_Us_BFu8ll");
    static B_Us_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_Us_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_Us_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_Us_BFu8ll(Test_B_Us_BFu8ll, "B_Us_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu8s()
{
  {
    init_simple_test("B_Us_BFu8s");
    static B_Us_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "B_Us_BFu8s.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_Us_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_Us_BFu8s");
  }
}
static Arrange_To_Call_Me vB_Us_BFu8s(Test_B_Us_BFu8s, "B_Us_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu9i()
{
  {
    init_simple_test("B_Us_BFu9i");
    static B_Us_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(B_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "B_Us_BFu9i.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "B_Us_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "B_Us_BFu9i");
  }
}
static Arrange_To_Call_Me vB_Us_BFu9i(Test_B_Us_BFu9i, "B_Us_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu9ll()
{
  {
    init_simple_test("B_Us_BFu9ll");
    static B_Us_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(B_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "B_Us_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "B_Us_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_Us_BFu9ll(Test_B_Us_BFu9ll, "B_Us_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_BFu9s()
{
  {
    init_simple_test("B_Us_BFu9s");
    static B_Us_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(B_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "B_Us_BFu9s.v1");
    check_field_offset(lv, v2, 1, "B_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "B_Us_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "B_Us_BFu9s");
  }
}
static Arrange_To_Call_Me vB_Us_BFu9s(Test_B_Us_BFu9s, "B_Us_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_C()
{
  {
    init_simple_test("B_Us_C");
    B_Us_C lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_C)");
    check_field_offset(lv, v1, 0, "B_Us_C.v1");
    check_field_offset(lv, v2, 1, "B_Us_C.v2");
    check_field_offset(lv, v3, 3, "B_Us_C.v3");
  }
}
static Arrange_To_Call_Me vB_Us_C(Test_B_Us_C, "B_Us_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_D()
{
  {
    init_simple_test("B_Us_D");
    B_Us_D lv;
    check2(sizeof(lv), 11, "sizeof(B_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_D)");
    check_field_offset(lv, v1, 0, "B_Us_D.v1");
    check_field_offset(lv, v2, 1, "B_Us_D.v2");
    check_field_offset(lv, v3, 3, "B_Us_D.v3");
  }
}
static Arrange_To_Call_Me vB_Us_D(Test_B_Us_D, "B_Us_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_F()
{
  {
    init_simple_test("B_Us_F");
    B_Us_F lv;
    check2(sizeof(lv), 7, "sizeof(B_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_F)");
    check_field_offset(lv, v1, 0, "B_Us_F.v1");
    check_field_offset(lv, v2, 1, "B_Us_F.v2");
    check_field_offset(lv, v3, 3, "B_Us_F.v3");
  }
}
static Arrange_To_Call_Me vB_Us_F(Test_B_Us_F, "B_Us_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_I()
{
  {
    init_simple_test("B_Us_I");
    B_Us_I lv;
    check2(sizeof(lv), 7, "sizeof(B_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_I)");
    check_field_offset(lv, v1, 0, "B_Us_I.v1");
    check_field_offset(lv, v2, 1, "B_Us_I.v2");
    check_field_offset(lv, v3, 3, "B_Us_I.v3");
  }
}
static Arrange_To_Call_Me vB_Us_I(Test_B_Us_I, "B_Us_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_Ip()
{
  {
    init_simple_test("B_Us_Ip");
    B_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_Ip)");
    check_field_offset(lv, v1, 0, "B_Us_Ip.v1");
    check_field_offset(lv, v2, 1, "B_Us_Ip.v2");
    check_field_offset(lv, v3, 3, "B_Us_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_Us_Ip(Test_B_Us_Ip, "B_Us_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_L()
{
  {
    init_simple_test("B_Us_L");
    B_Us_L lv;
    check2(sizeof(lv), 11, "sizeof(B_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_L)");
    check_field_offset(lv, v1, 0, "B_Us_L.v1");
    check_field_offset(lv, v2, 1, "B_Us_L.v2");
    check_field_offset(lv, v3, 3, "B_Us_L.v3");
  }
}
static Arrange_To_Call_Me vB_Us_L(Test_B_Us_L, "B_Us_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_S()
{
  {
    init_simple_test("B_Us_S");
    B_Us_S lv;
    check2(sizeof(lv), 5, "sizeof(B_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_S)");
    check_field_offset(lv, v1, 0, "B_Us_S.v1");
    check_field_offset(lv, v2, 1, "B_Us_S.v2");
    check_field_offset(lv, v3, 3, "B_Us_S.v3");
  }
}
static Arrange_To_Call_Me vB_Us_S(Test_B_Us_S, "B_Us_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_Uc()
{
  {
    init_simple_test("B_Us_Uc");
    B_Us_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_Uc)");
    check_field_offset(lv, v1, 0, "B_Us_Uc.v1");
    check_field_offset(lv, v2, 1, "B_Us_Uc.v2");
    check_field_offset(lv, v3, 3, "B_Us_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_Us_Uc(Test_B_Us_Uc, "B_Us_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_Ui()
{
  {
    init_simple_test("B_Us_Ui");
    B_Us_Ui lv;
    check2(sizeof(lv), 7, "sizeof(B_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_Ui)");
    check_field_offset(lv, v1, 0, "B_Us_Ui.v1");
    check_field_offset(lv, v2, 1, "B_Us_Ui.v2");
    check_field_offset(lv, v3, 3, "B_Us_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_Us_Ui(Test_B_Us_Ui, "B_Us_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_Ul()
{
  {
    init_simple_test("B_Us_Ul");
    B_Us_Ul lv;
    check2(sizeof(lv), 11, "sizeof(B_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_Ul)");
    check_field_offset(lv, v1, 0, "B_Us_Ul.v1");
    check_field_offset(lv, v2, 1, "B_Us_Ul.v2");
    check_field_offset(lv, v3, 3, "B_Us_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_Us_Ul(Test_B_Us_Ul, "B_Us_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_Us()
{
  {
    init_simple_test("B_Us_Us");
    B_Us_Us lv;
    check2(sizeof(lv), 5, "sizeof(B_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_Us)");
    check_field_offset(lv, v1, 0, "B_Us_Us.v1");
    check_field_offset(lv, v2, 1, "B_Us_Us.v2");
    check_field_offset(lv, v3, 3, "B_Us_Us.v3");
  }
}
static Arrange_To_Call_Me vB_Us_Us(Test_B_Us_Us, "B_Us_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Us_Vp()
{
  {
    init_simple_test("B_Us_Vp");
    B_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_Us_Vp)");
    check_field_offset(lv, v1, 0, "B_Us_Vp.v1");
    check_field_offset(lv, v2, 1, "B_Us_Vp.v2");
    check_field_offset(lv, v3, 3, "B_Us_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_Us_Vp(Test_B_Us_Vp, "B_Us_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp()
{
  {
    init_simple_test("B_Vp");
    B_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp)");
    check_field_offset(lv, v1, 0, "B_Vp.v1");
    check_field_offset(lv, v2, 1, "B_Vp.v2");
  }
}
static Arrange_To_Call_Me vB_Vp(Test_B_Vp, "B_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_B()
{
  {
    init_simple_test("B_Vp_B");
    B_Vp_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_B)");
    check_field_offset(lv, v1, 0, "B_Vp_B.v1");
    check_field_offset(lv, v2, 1, "B_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vB_Vp_B(Test_B_Vp_B, "B_Vp_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu15i()
{
  {
    init_simple_test("B_Vp_BFu15i");
    static B_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu15i.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "B_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "B_Vp_BFu15i");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu15i(Test_B_Vp_BFu15i, "B_Vp_BFu15i", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu15ll()
{
  {
    init_simple_test("B_Vp_BFu15ll");
    static B_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "B_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "B_Vp_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu15ll(Test_B_Vp_BFu15ll, "B_Vp_BFu15ll", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu15s()
{
  {
    init_simple_test("B_Vp_BFu15s");
    static B_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu15s.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "B_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "B_Vp_BFu15s");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu15s(Test_B_Vp_BFu15s, "B_Vp_BFu15s", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu16i()
{
  {
    init_simple_test("B_Vp_BFu16i");
    static B_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu16i.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "B_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "B_Vp_BFu16i");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu16i(Test_B_Vp_BFu16i, "B_Vp_BFu16i", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu16ll()
{
  {
    init_simple_test("B_Vp_BFu16ll");
    static B_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "B_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "B_Vp_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu16ll(Test_B_Vp_BFu16ll, "B_Vp_BFu16ll", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu16s()
{
  {
    init_simple_test("B_Vp_BFu16s");
    static B_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu16s.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "B_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "B_Vp_BFu16s");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu16s(Test_B_Vp_BFu16s, "B_Vp_BFu16s", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu17i()
{
  {
    init_simple_test("B_Vp_BFu17i");
    static B_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(B_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu17i.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "B_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "B_Vp_BFu17i");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu17i(Test_B_Vp_BFu17i, "B_Vp_BFu17i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu17ll()
{
  {
    init_simple_test("B_Vp_BFu17ll");
    static B_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(B_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "B_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "B_Vp_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu17ll(Test_B_Vp_BFu17ll, "B_Vp_BFu17ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu1c()
{
  {
    init_simple_test("B_Vp_BFu1c");
    static B_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu1c.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "B_Vp_BFu1c");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu1c(Test_B_Vp_BFu1c, "B_Vp_BFu1c", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu1i()
{
  {
    init_simple_test("B_Vp_BFu1i");
    static B_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu1i.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "B_Vp_BFu1i");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu1i(Test_B_Vp_BFu1i, "B_Vp_BFu1i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu1ll()
{
  {
    init_simple_test("B_Vp_BFu1ll");
    static B_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "B_Vp_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu1ll(Test_B_Vp_BFu1ll, "B_Vp_BFu1ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu1s()
{
  {
    init_simple_test("B_Vp_BFu1s");
    static B_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu1s.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "B_Vp_BFu1s");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu1s(Test_B_Vp_BFu1s, "B_Vp_BFu1s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu31i()
{
  {
    init_simple_test("B_Vp_BFu31i");
    static B_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu31i.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "B_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "B_Vp_BFu31i");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu31i(Test_B_Vp_BFu31i, "B_Vp_BFu31i", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu31ll()
{
  {
    init_simple_test("B_Vp_BFu31ll");
    static B_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "B_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "B_Vp_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu31ll(Test_B_Vp_BFu31ll, "B_Vp_BFu31ll", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu32i()
{
  {
    init_simple_test("B_Vp_BFu32i");
    static B_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu32i.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "B_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "B_Vp_BFu32i");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu32i(Test_B_Vp_BFu32i, "B_Vp_BFu32i", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu32ll()
{
  {
    init_simple_test("B_Vp_BFu32ll");
    static B_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "B_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "B_Vp_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu32ll(Test_B_Vp_BFu32ll, "B_Vp_BFu32ll", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu33()
{
  {
    init_simple_test("B_Vp_BFu33");
    static B_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(B_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu33.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "B_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "B_Vp_BFu33");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu33(Test_B_Vp_BFu33, "B_Vp_BFu33", ABISELECT(14,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu7c()
{
  {
    init_simple_test("B_Vp_BFu7c");
    static B_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu7c.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "B_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "B_Vp_BFu7c");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu7c(Test_B_Vp_BFu7c, "B_Vp_BFu7c", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu7i()
{
  {
    init_simple_test("B_Vp_BFu7i");
    static B_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu7i.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "B_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "B_Vp_BFu7i");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu7i(Test_B_Vp_BFu7i, "B_Vp_BFu7i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu7ll()
{
  {
    init_simple_test("B_Vp_BFu7ll");
    static B_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "B_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "B_Vp_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu7ll(Test_B_Vp_BFu7ll, "B_Vp_BFu7ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu7s()
{
  {
    init_simple_test("B_Vp_BFu7s");
    static B_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu7s.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "B_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "B_Vp_BFu7s");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu7s(Test_B_Vp_BFu7s, "B_Vp_BFu7s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu8c()
{
  {
    init_simple_test("B_Vp_BFu8c");
    static B_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu8c.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "B_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "B_Vp_BFu8c");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu8c(Test_B_Vp_BFu8c, "B_Vp_BFu8c", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu8i()
{
  {
    init_simple_test("B_Vp_BFu8i");
    static B_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu8i.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "B_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "B_Vp_BFu8i");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu8i(Test_B_Vp_BFu8i, "B_Vp_BFu8i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu8ll()
{
  {
    init_simple_test("B_Vp_BFu8ll");
    static B_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "B_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "B_Vp_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu8ll(Test_B_Vp_BFu8ll, "B_Vp_BFu8ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu8s()
{
  {
    init_simple_test("B_Vp_BFu8s");
    static B_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu8s.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "B_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "B_Vp_BFu8s");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu8s(Test_B_Vp_BFu8s, "B_Vp_BFu8s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu9i()
{
  {
    init_simple_test("B_Vp_BFu9i");
    static B_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu9i.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "B_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "B_Vp_BFu9i");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu9i(Test_B_Vp_BFu9i, "B_Vp_BFu9i", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu9ll()
{
  {
    init_simple_test("B_Vp_BFu9ll");
    static B_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "B_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "B_Vp_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu9ll(Test_B_Vp_BFu9ll, "B_Vp_BFu9ll", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_BFu9s()
{
  {
    init_simple_test("B_Vp_BFu9s");
    static B_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "B_Vp_BFu9s.v1");
    check_field_offset(lv, v2, 1, "B_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "B_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "B_Vp_BFu9s");
  }
}
static Arrange_To_Call_Me vB_Vp_BFu9s(Test_B_Vp_BFu9s, "B_Vp_BFu9s", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_C()
{
  {
    init_simple_test("B_Vp_C");
    B_Vp_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_C)");
    check_field_offset(lv, v1, 0, "B_Vp_C.v1");
    check_field_offset(lv, v2, 1, "B_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Vp_C.v3");
  }
}
static Arrange_To_Call_Me vB_Vp_C(Test_B_Vp_C, "B_Vp_C", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_D()
{
  {
    init_simple_test("B_Vp_D");
    B_Vp_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(B_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_D)");
    check_field_offset(lv, v1, 0, "B_Vp_D.v1");
    check_field_offset(lv, v2, 1, "B_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Vp_D.v3");
  }
}
static Arrange_To_Call_Me vB_Vp_D(Test_B_Vp_D, "B_Vp_D", ABISELECT(17,13));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_F()
{
  {
    init_simple_test("B_Vp_F");
    B_Vp_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_F)");
    check_field_offset(lv, v1, 0, "B_Vp_F.v1");
    check_field_offset(lv, v2, 1, "B_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Vp_F.v3");
  }
}
static Arrange_To_Call_Me vB_Vp_F(Test_B_Vp_F, "B_Vp_F", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_I()
{
  {
    init_simple_test("B_Vp_I");
    B_Vp_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_I)");
    check_field_offset(lv, v1, 0, "B_Vp_I.v1");
    check_field_offset(lv, v2, 1, "B_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Vp_I.v3");
  }
}
static Arrange_To_Call_Me vB_Vp_I(Test_B_Vp_I, "B_Vp_I", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_Ip()
{
  {
    init_simple_test("B_Vp_Ip");
    B_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(B_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_Ip)");
    check_field_offset(lv, v1, 0, "B_Vp_Ip.v1");
    check_field_offset(lv, v2, 1, "B_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Vp_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_Vp_Ip(Test_B_Vp_Ip, "B_Vp_Ip", ABISELECT(17,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_L()
{
  {
    init_simple_test("B_Vp_L");
    B_Vp_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(B_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_L)");
    check_field_offset(lv, v1, 0, "B_Vp_L.v1");
    check_field_offset(lv, v2, 1, "B_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Vp_L.v3");
  }
}
static Arrange_To_Call_Me vB_Vp_L(Test_B_Vp_L, "B_Vp_L", ABISELECT(17,13));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_S()
{
  {
    init_simple_test("B_Vp_S");
    B_Vp_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_S)");
    check_field_offset(lv, v1, 0, "B_Vp_S.v1");
    check_field_offset(lv, v2, 1, "B_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Vp_S.v3");
  }
}
static Arrange_To_Call_Me vB_Vp_S(Test_B_Vp_S, "B_Vp_S", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_Uc()
{
  {
    init_simple_test("B_Vp_Uc");
    B_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(B_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_Uc)");
    check_field_offset(lv, v1, 0, "B_Vp_Uc.v1");
    check_field_offset(lv, v2, 1, "B_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Vp_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_Vp_Uc(Test_B_Vp_Uc, "B_Vp_Uc", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_Ui()
{
  {
    init_simple_test("B_Vp_Ui");
    B_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(B_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_Ui)");
    check_field_offset(lv, v1, 0, "B_Vp_Ui.v1");
    check_field_offset(lv, v2, 1, "B_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Vp_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_Vp_Ui(Test_B_Vp_Ui, "B_Vp_Ui", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_Ul()
{
  {
    init_simple_test("B_Vp_Ul");
    B_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(B_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_Ul)");
    check_field_offset(lv, v1, 0, "B_Vp_Ul.v1");
    check_field_offset(lv, v2, 1, "B_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Vp_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_Vp_Ul(Test_B_Vp_Ul, "B_Vp_Ul", ABISELECT(17,13));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_Us()
{
  {
    init_simple_test("B_Vp_Us");
    B_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(B_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_Us)");
    check_field_offset(lv, v1, 0, "B_Vp_Us.v1");
    check_field_offset(lv, v2, 1, "B_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Vp_Us.v3");
  }
}
static Arrange_To_Call_Me vB_Vp_Us(Test_B_Vp_Us, "B_Vp_Us", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_B_Vp_Vp()
{
  {
    init_simple_test("B_Vp_Vp");
    B_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(B_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(B_Vp_Vp)");
    check_field_offset(lv, v1, 0, "B_Vp_Vp.v1");
    check_field_offset(lv, v2, 1, "B_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "B_Vp_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_Vp_Vp(Test_B_Vp_Vp, "B_Vp_Vp", ABISELECT(17,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B()
{
  {
    init_simple_test("BFu15i_B");
    static BFu15i_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B");
    check_field_offset(lv, v2, 2, "BFu15i_B.v2");
  }
}
static Arrange_To_Call_Me vBFu15i_B(Test_BFu15i_B, "BFu15i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_B()
{
  {
    init_simple_test("BFu15i_B_B");
    static BFu15i_B_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_B");
    check_field_offset(lv, v2, 2, "BFu15i_B_B.v2");
    check_field_offset(lv, v3, 3, "BFu15i_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_B_B(Test_BFu15i_B_B, "BFu15i_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu15i()
{
  {
    init_simple_test("BFu15i_B_BFu15i");
    static BFu15i_B_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_B_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu15i(Test_BFu15i_B_BFu15i, "BFu15i_B_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu15ll()
{
  {
    init_simple_test("BFu15i_B_BFu15ll");
    static BFu15i_B_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_B_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu15ll(Test_BFu15i_B_BFu15ll, "BFu15i_B_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu15s()
{
  {
    init_simple_test("BFu15i_B_BFu15s");
    static BFu15i_B_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_B_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu15s(Test_BFu15i_B_BFu15s, "BFu15i_B_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu16i()
{
  {
    init_simple_test("BFu15i_B_BFu16i");
    static BFu15i_B_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_B_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu16i(Test_BFu15i_B_BFu16i, "BFu15i_B_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu16ll()
{
  {
    init_simple_test("BFu15i_B_BFu16ll");
    static BFu15i_B_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_B_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu16ll(Test_BFu15i_B_BFu16ll, "BFu15i_B_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu16s()
{
  {
    init_simple_test("BFu15i_B_BFu16s");
    static BFu15i_B_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_B_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu16s(Test_BFu15i_B_BFu16s, "BFu15i_B_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu17i()
{
  {
    init_simple_test("BFu15i_B_BFu17i");
    static BFu15i_B_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15i_B_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15i_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu17i(Test_BFu15i_B_BFu17i, "BFu15i_B_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu17ll()
{
  {
    init_simple_test("BFu15i_B_BFu17ll");
    static BFu15i_B_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15i_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15i_B_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15i_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu17ll(Test_BFu15i_B_BFu17ll, "BFu15i_B_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu1c()
{
  {
    init_simple_test("BFu15i_B_BFu1c");
    static BFu15i_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu1c(Test_BFu15i_B_BFu1c, "BFu15i_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu1i()
{
  {
    init_simple_test("BFu15i_B_BFu1i");
    static BFu15i_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu1i(Test_BFu15i_B_BFu1i, "BFu15i_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu1ll()
{
  {
    init_simple_test("BFu15i_B_BFu1ll");
    static BFu15i_B_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu1ll(Test_BFu15i_B_BFu1ll, "BFu15i_B_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu1s()
{
  {
    init_simple_test("BFu15i_B_BFu1s");
    static BFu15i_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu1s(Test_BFu15i_B_BFu1s, "BFu15i_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu31i()
{
  {
    init_simple_test("BFu15i_B_BFu31i");
    static BFu15i_B_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15i_B_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15i_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu31i(Test_BFu15i_B_BFu31i, "BFu15i_B_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu31ll()
{
  {
    init_simple_test("BFu15i_B_BFu31ll");
    static BFu15i_B_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15i_B_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15i_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu31ll(Test_BFu15i_B_BFu31ll, "BFu15i_B_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu32i()
{
  {
    init_simple_test("BFu15i_B_BFu32i");
    static BFu15i_B_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15i_B_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15i_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu32i(Test_BFu15i_B_BFu32i, "BFu15i_B_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu32ll()
{
  {
    init_simple_test("BFu15i_B_BFu32ll");
    static BFu15i_B_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15i_B_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15i_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu32ll(Test_BFu15i_B_BFu32ll, "BFu15i_B_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu33()
{
  {
    init_simple_test("BFu15i_B_BFu33");
    static BFu15i_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu15i_B_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu15i_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu33(Test_BFu15i_B_BFu33, "BFu15i_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu7c()
{
  {
    init_simple_test("BFu15i_B_BFu7c");
    static BFu15i_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_B_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu7c(Test_BFu15i_B_BFu7c, "BFu15i_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu7i()
{
  {
    init_simple_test("BFu15i_B_BFu7i");
    static BFu15i_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_B_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu7i(Test_BFu15i_B_BFu7i, "BFu15i_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu7ll()
{
  {
    init_simple_test("BFu15i_B_BFu7ll");
    static BFu15i_B_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_B_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu7ll(Test_BFu15i_B_BFu7ll, "BFu15i_B_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu7s()
{
  {
    init_simple_test("BFu15i_B_BFu7s");
    static BFu15i_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_B_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu7s(Test_BFu15i_B_BFu7s, "BFu15i_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu8c()
{
  {
    init_simple_test("BFu15i_B_BFu8c");
    static BFu15i_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_B_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu8c(Test_BFu15i_B_BFu8c, "BFu15i_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu8i()
{
  {
    init_simple_test("BFu15i_B_BFu8i");
    static BFu15i_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_B_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu8i(Test_BFu15i_B_BFu8i, "BFu15i_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu8ll()
{
  {
    init_simple_test("BFu15i_B_BFu8ll");
    static BFu15i_B_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_B_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu8ll(Test_BFu15i_B_BFu8ll, "BFu15i_B_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu8s()
{
  {
    init_simple_test("BFu15i_B_BFu8s");
    static BFu15i_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_B_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu8s(Test_BFu15i_B_BFu8s, "BFu15i_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu9i()
{
  {
    init_simple_test("BFu15i_B_BFu9i");
    static BFu15i_B_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_B_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu9i(Test_BFu15i_B_BFu9i, "BFu15i_B_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu9ll()
{
  {
    init_simple_test("BFu15i_B_BFu9ll");
    static BFu15i_B_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_B_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu9ll(Test_BFu15i_B_BFu9ll, "BFu15i_B_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_BFu9s()
{
  {
    init_simple_test("BFu15i_B_BFu9s");
    static BFu15i_B_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_B_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu15i_B_BFu9s(Test_BFu15i_B_BFu9s, "BFu15i_B_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_C()
{
  {
    init_simple_test("BFu15i_B_C");
    static BFu15i_B_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_C");
    check_field_offset(lv, v2, 2, "BFu15i_B_C.v2");
    check_field_offset(lv, v3, 3, "BFu15i_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_B_C(Test_BFu15i_B_C, "BFu15i_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_D()
{
  {
    init_simple_test("BFu15i_B_D");
    static BFu15i_B_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_D");
    check_field_offset(lv, v2, 2, "BFu15i_B_D.v2");
    check_field_offset(lv, v3, 3, "BFu15i_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_B_D(Test_BFu15i_B_D, "BFu15i_B_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_F()
{
  {
    init_simple_test("BFu15i_B_F");
    static BFu15i_B_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_F");
    check_field_offset(lv, v2, 2, "BFu15i_B_F.v2");
    check_field_offset(lv, v3, 3, "BFu15i_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_B_F(Test_BFu15i_B_F, "BFu15i_B_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_I()
{
  {
    init_simple_test("BFu15i_B_I");
    static BFu15i_B_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_I");
    check_field_offset(lv, v2, 2, "BFu15i_B_I.v2");
    check_field_offset(lv, v3, 3, "BFu15i_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_B_I(Test_BFu15i_B_I, "BFu15i_B_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_Ip()
{
  {
    init_simple_test("BFu15i_B_Ip");
    static BFu15i_B_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_B_Ip.v2");
    check_field_offset(lv, v3, 3, "BFu15i_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_B_Ip(Test_BFu15i_B_Ip, "BFu15i_B_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_L()
{
  {
    init_simple_test("BFu15i_B_L");
    static BFu15i_B_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_L");
    check_field_offset(lv, v2, 2, "BFu15i_B_L.v2");
    check_field_offset(lv, v3, 3, "BFu15i_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_B_L(Test_BFu15i_B_L, "BFu15i_B_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_S()
{
  {
    init_simple_test("BFu15i_B_S");
    static BFu15i_B_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_S");
    check_field_offset(lv, v2, 2, "BFu15i_B_S.v2");
    check_field_offset(lv, v3, 3, "BFu15i_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_B_S(Test_BFu15i_B_S, "BFu15i_B_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_Uc()
{
  {
    init_simple_test("BFu15i_B_Uc");
    static BFu15i_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_B_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu15i_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_B_Uc(Test_BFu15i_B_Uc, "BFu15i_B_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_Ui()
{
  {
    init_simple_test("BFu15i_B_Ui");
    static BFu15i_B_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_B_Ui.v2");
    check_field_offset(lv, v3, 3, "BFu15i_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_B_Ui(Test_BFu15i_B_Ui, "BFu15i_B_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_Ul()
{
  {
    init_simple_test("BFu15i_B_Ul");
    static BFu15i_B_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_B_Ul.v2");
    check_field_offset(lv, v3, 3, "BFu15i_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_B_Ul(Test_BFu15i_B_Ul, "BFu15i_B_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_Us()
{
  {
    init_simple_test("BFu15i_B_Us");
    static BFu15i_B_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_Us");
    check_field_offset(lv, v2, 2, "BFu15i_B_Us.v2");
    check_field_offset(lv, v3, 3, "BFu15i_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_B_Us(Test_BFu15i_B_Us, "BFu15i_B_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_B_Vp()
{
  {
    init_simple_test("BFu15i_B_Vp");
    static BFu15i_B_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_B_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_B_Vp.v2");
    check_field_offset(lv, v3, 3, "BFu15i_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_B_Vp(Test_BFu15i_B_Vp, "BFu15i_B_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu15i_B()
{
  {
    init_simple_test("BFu15i_BFu15i_B");
    static BFu15i_BFu15i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15i_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu15i_B");
    check_field_offset(lv, v3, 4, "BFu15i_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu15i_B(Test_BFu15i_BFu15i_B, "BFu15i_BFu15i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu15ll_B()
{
  {
    init_simple_test("BFu15i_BFu15ll_B");
    static BFu15i_BFu15ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15i_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu15ll_B");
    check_field_offset(lv, v3, 4, "BFu15i_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu15ll_B(Test_BFu15i_BFu15ll_B, "BFu15i_BFu15ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu15s_B()
{
  {
    init_simple_test("BFu15i_BFu15s_B");
    static BFu15i_BFu15s_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15i_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu15i_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu15s_B(Test_BFu15i_BFu15s_B, "BFu15i_BFu15s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu16i_B()
{
  {
    init_simple_test("BFu15i_BFu16i_B");
    static BFu15i_BFu16i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15i_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu16i_B");
    check_field_offset(lv, v3, 4, "BFu15i_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu16i_B(Test_BFu15i_BFu16i_B, "BFu15i_BFu16i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu16ll_B()
{
  {
    init_simple_test("BFu15i_BFu16ll_B");
    static BFu15i_BFu16ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15i_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu16ll_B");
    check_field_offset(lv, v3, 4, "BFu15i_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu16ll_B(Test_BFu15i_BFu16ll_B, "BFu15i_BFu16ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu16s_B()
{
  {
    init_simple_test("BFu15i_BFu16s_B");
    static BFu15i_BFu16s_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15i_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu15i_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu16s_B(Test_BFu15i_BFu16s_B, "BFu15i_BFu16s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu17i_B()
{
  {
    init_simple_test("BFu15i_BFu17i_B");
    static BFu15i_BFu17i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15i_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu17i_B");
    check_field_offset(lv, v3, 4, "BFu15i_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu17i_B(Test_BFu15i_BFu17i_B, "BFu15i_BFu17i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu17ll_B()
{
  {
    init_simple_test("BFu15i_BFu17ll_B");
    static BFu15i_BFu17ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15i_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu17ll_B");
    check_field_offset(lv, v3, 4, "BFu15i_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu17ll_B(Test_BFu15i_BFu17ll_B, "BFu15i_BFu17ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu1c_B()
{
  {
    init_simple_test("BFu15i_BFu1c_B");
    static BFu15i_BFu1c_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1c_B");
    check_field_offset(lv, v3, 2, "BFu15i_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu1c_B(Test_BFu15i_BFu1c_B, "BFu15i_BFu1c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu1i_B()
{
  {
    init_simple_test("BFu15i_BFu1i_B");
    static BFu15i_BFu1i_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1i_B");
    check_field_offset(lv, v3, 2, "BFu15i_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu1i_B(Test_BFu15i_BFu1i_B, "BFu15i_BFu1i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu1ll_B()
{
  {
    init_simple_test("BFu15i_BFu1ll_B");
    static BFu15i_BFu1ll_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1ll_B");
    check_field_offset(lv, v3, 2, "BFu15i_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu1ll_B(Test_BFu15i_BFu1ll_B, "BFu15i_BFu1ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu1s_B()
{
  {
    init_simple_test("BFu15i_BFu1s_B");
    static BFu15i_BFu1s_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15i_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1s_B");
    check_field_offset(lv, v3, 2, "BFu15i_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu1s_B(Test_BFu15i_BFu1s_B, "BFu15i_BFu1s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu31i_B()
{
  {
    init_simple_test("BFu15i_BFu31i_B");
    static BFu15i_BFu31i_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15i_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu31i_B");
    check_field_offset(lv, v3, 6, "BFu15i_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu31i_B(Test_BFu15i_BFu31i_B, "BFu15i_BFu31i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu31ll_B()
{
  {
    init_simple_test("BFu15i_BFu31ll_B");
    static BFu15i_BFu31ll_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15i_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu31ll_B");
    check_field_offset(lv, v3, 6, "BFu15i_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu31ll_B(Test_BFu15i_BFu31ll_B, "BFu15i_BFu31ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu32i_B()
{
  {
    init_simple_test("BFu15i_BFu32i_B");
    static BFu15i_BFu32i_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15i_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu32i_B");
    check_field_offset(lv, v3, 6, "BFu15i_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu32i_B(Test_BFu15i_BFu32i_B, "BFu15i_BFu32i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu32ll_B()
{
  {
    init_simple_test("BFu15i_BFu32ll_B");
    static BFu15i_BFu32ll_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15i_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu32ll_B");
    check_field_offset(lv, v3, 6, "BFu15i_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu32ll_B(Test_BFu15i_BFu32ll_B, "BFu15i_BFu32ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu33_B()
{
  {
    init_simple_test("BFu15i_BFu33_B");
    static BFu15i_BFu33_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu33_B");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15i_BFu33_B");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15i_BFu33_B");
    check_field_offset(lv, v3, 6, "BFu15i_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu33_B(Test_BFu15i_BFu33_B, "BFu15i_BFu33_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu7c_B()
{
  {
    init_simple_test("BFu15i_BFu7c_B");
    static BFu15i_BFu7c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7c_B");
    check_field_offset(lv, v3, 3, "BFu15i_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu7c_B(Test_BFu15i_BFu7c_B, "BFu15i_BFu7c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu7i_B()
{
  {
    init_simple_test("BFu15i_BFu7i_B");
    static BFu15i_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7i_B");
    check_field_offset(lv, v3, 3, "BFu15i_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu7i_B(Test_BFu15i_BFu7i_B, "BFu15i_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu7ll_B()
{
  {
    init_simple_test("BFu15i_BFu7ll_B");
    static BFu15i_BFu7ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7ll_B");
    check_field_offset(lv, v3, 3, "BFu15i_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu7ll_B(Test_BFu15i_BFu7ll_B, "BFu15i_BFu7ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu7s_B()
{
  {
    init_simple_test("BFu15i_BFu7s_B");
    static BFu15i_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7s_B");
    check_field_offset(lv, v3, 3, "BFu15i_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu7s_B(Test_BFu15i_BFu7s_B, "BFu15i_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu8c_B()
{
  {
    init_simple_test("BFu15i_BFu8c_B");
    static BFu15i_BFu8c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_B");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu8c_B(Test_BFu15i_BFu8c_B, "BFu15i_BFu8c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu8i_B()
{
  {
    init_simple_test("BFu15i_BFu8i_B");
    static BFu15i_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_B");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu8i_B(Test_BFu15i_BFu8i_B, "BFu15i_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu8ll_B()
{
  {
    init_simple_test("BFu15i_BFu8ll_B");
    static BFu15i_BFu8ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_B");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu8ll_B(Test_BFu15i_BFu8ll_B, "BFu15i_BFu8ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu8s_B()
{
  {
    init_simple_test("BFu15i_BFu8s_B");
    static BFu15i_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_B");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu8s_B(Test_BFu15i_BFu8s_B, "BFu15i_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu9i_B()
{
  {
    init_simple_test("BFu15i_BFu9i_B");
    static BFu15i_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_B");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu9i_B(Test_BFu15i_BFu9i_B, "BFu15i_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu9ll_B()
{
  {
    init_simple_test("BFu15i_BFu9ll_B");
    static BFu15i_BFu9ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_B");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu9ll_B(Test_BFu15i_BFu9ll_B, "BFu15i_BFu9ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_BFu9s_B()
{
  {
    init_simple_test("BFu15i_BFu9s_B");
    static BFu15i_BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_B");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu9s_B(Test_BFu15i_BFu9s_B, "BFu15i_BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_C_B()
{
  {
    init_simple_test("BFu15i_C_B");
    static BFu15i_C_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_B");
    check_field_offset(lv, v2, 2, "BFu15i_C_B.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_C_B(Test_BFu15i_C_B, "BFu15i_C_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_D_B()
{
  {
    init_simple_test("BFu15i_D_B");
    static BFu15i_D_B lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_B");
    check_field_offset(lv, v2, 2, "BFu15i_D_B.v2");
    check_field_offset(lv, v3, 10, "BFu15i_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_D_B(Test_BFu15i_D_B, "BFu15i_D_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_F_B()
{
  {
    init_simple_test("BFu15i_F_B");
    static BFu15i_F_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_B");
    check_field_offset(lv, v2, 2, "BFu15i_F_B.v2");
    check_field_offset(lv, v3, 6, "BFu15i_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_F_B(Test_BFu15i_F_B, "BFu15i_F_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_I_B()
{
  {
    init_simple_test("BFu15i_I_B");
    static BFu15i_I_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_B");
    check_field_offset(lv, v2, 2, "BFu15i_I_B.v2");
    check_field_offset(lv, v3, 6, "BFu15i_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_I_B(Test_BFu15i_I_B, "BFu15i_I_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_Ip_B()
{
  {
    init_simple_test("BFu15i_Ip_B");
    static BFu15i_Ip_B lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_B");
    check_field_offset(lv, v2, 2, "BFu15i_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Ip_B(Test_BFu15i_Ip_B, "BFu15i_Ip_B", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_L_B()
{
  {
    init_simple_test("BFu15i_L_B");
    static BFu15i_L_B lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_B");
    check_field_offset(lv, v2, 2, "BFu15i_L_B.v2");
    check_field_offset(lv, v3, 10, "BFu15i_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_L_B(Test_BFu15i_L_B, "BFu15i_L_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_S_B()
{
  {
    init_simple_test("BFu15i_S_B");
    static BFu15i_S_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_B");
    check_field_offset(lv, v2, 2, "BFu15i_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_S_B(Test_BFu15i_S_B, "BFu15i_S_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_Uc_B()
{
  {
    init_simple_test("BFu15i_Uc_B");
    static BFu15i_Uc_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_B");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_B.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Uc_B(Test_BFu15i_Uc_B, "BFu15i_Uc_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_Ui_B()
{
  {
    init_simple_test("BFu15i_Ui_B");
    static BFu15i_Ui_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15i_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_B");
    check_field_offset(lv, v2, 2, "BFu15i_Ui_B.v2");
    check_field_offset(lv, v3, 6, "BFu15i_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Ui_B(Test_BFu15i_Ui_B, "BFu15i_Ui_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_Ul_B()
{
  {
    init_simple_test("BFu15i_Ul_B");
    static BFu15i_Ul_B lv;
    check2(sizeof(lv), 11, "sizeof(BFu15i_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_B");
    check_field_offset(lv, v2, 2, "BFu15i_Ul_B.v2");
    check_field_offset(lv, v3, 10, "BFu15i_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Ul_B(Test_BFu15i_Ul_B, "BFu15i_Ul_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_Us_B()
{
  {
    init_simple_test("BFu15i_Us_B");
    static BFu15i_Us_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15i_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_B");
    check_field_offset(lv, v2, 2, "BFu15i_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Us_B(Test_BFu15i_Us_B, "BFu15i_Us_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15i_Vp_B()
{
  {
    init_simple_test("BFu15i_Vp_B");
    static BFu15i_Vp_B lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15i_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_B");
    check_field_offset(lv, v2, 2, "BFu15i_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15i_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Vp_B(Test_BFu15i_Vp_B, "BFu15i_Vp_B", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B()
{
  {
    init_simple_test("BFu15ll_B");
    static BFu15ll_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B");
    check_field_offset(lv, v2, 2, "BFu15ll_B.v2");
  }
}
static Arrange_To_Call_Me vBFu15ll_B(Test_BFu15ll_B, "BFu15ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_B()
{
  {
    init_simple_test("BFu15ll_B_B");
    static BFu15ll_B_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_B");
    check_field_offset(lv, v2, 2, "BFu15ll_B_B.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_B(Test_BFu15ll_B_B, "BFu15ll_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu15i()
{
  {
    init_simple_test("BFu15ll_B_BFu15i");
    static BFu15ll_B_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15ll_B_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu15i(Test_BFu15ll_B_BFu15i, "BFu15ll_B_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu15ll()
{
  {
    init_simple_test("BFu15ll_B_BFu15ll");
    static BFu15ll_B_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15ll_B_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu15ll(Test_BFu15ll_B_BFu15ll, "BFu15ll_B_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu15s()
{
  {
    init_simple_test("BFu15ll_B_BFu15s");
    static BFu15ll_B_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15ll_B_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu15s(Test_BFu15ll_B_BFu15s, "BFu15ll_B_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu16i()
{
  {
    init_simple_test("BFu15ll_B_BFu16i");
    static BFu15ll_B_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15ll_B_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15ll_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu16i(Test_BFu15ll_B_BFu16i, "BFu15ll_B_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu16ll()
{
  {
    init_simple_test("BFu15ll_B_BFu16ll");
    static BFu15ll_B_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15ll_B_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15ll_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu16ll(Test_BFu15ll_B_BFu16ll, "BFu15ll_B_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu16s()
{
  {
    init_simple_test("BFu15ll_B_BFu16s");
    static BFu15ll_B_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15ll_B_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15ll_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu16s(Test_BFu15ll_B_BFu16s, "BFu15ll_B_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu17i()
{
  {
    init_simple_test("BFu15ll_B_BFu17i");
    static BFu15ll_B_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15ll_B_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15ll_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu17i(Test_BFu15ll_B_BFu17i, "BFu15ll_B_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu17ll()
{
  {
    init_simple_test("BFu15ll_B_BFu17ll");
    static BFu15ll_B_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15ll_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15ll_B_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15ll_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu17ll(Test_BFu15ll_B_BFu17ll, "BFu15ll_B_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu1c()
{
  {
    init_simple_test("BFu15ll_B_BFu1c");
    static BFu15ll_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu1c(Test_BFu15ll_B_BFu1c, "BFu15ll_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu1i()
{
  {
    init_simple_test("BFu15ll_B_BFu1i");
    static BFu15ll_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu1i(Test_BFu15ll_B_BFu1i, "BFu15ll_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu1ll()
{
  {
    init_simple_test("BFu15ll_B_BFu1ll");
    static BFu15ll_B_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu1ll(Test_BFu15ll_B_BFu1ll, "BFu15ll_B_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu1s()
{
  {
    init_simple_test("BFu15ll_B_BFu1s");
    static BFu15ll_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu1s(Test_BFu15ll_B_BFu1s, "BFu15ll_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu31i()
{
  {
    init_simple_test("BFu15ll_B_BFu31i");
    static BFu15ll_B_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15ll_B_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15ll_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu31i(Test_BFu15ll_B_BFu31i, "BFu15ll_B_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu31ll()
{
  {
    init_simple_test("BFu15ll_B_BFu31ll");
    static BFu15ll_B_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15ll_B_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15ll_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu31ll(Test_BFu15ll_B_BFu31ll, "BFu15ll_B_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu32i()
{
  {
    init_simple_test("BFu15ll_B_BFu32i");
    static BFu15ll_B_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15ll_B_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15ll_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu32i(Test_BFu15ll_B_BFu32i, "BFu15ll_B_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu32ll()
{
  {
    init_simple_test("BFu15ll_B_BFu32ll");
    static BFu15ll_B_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15ll_B_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15ll_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu32ll(Test_BFu15ll_B_BFu32ll, "BFu15ll_B_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu33()
{
  {
    init_simple_test("BFu15ll_B_BFu33");
    static BFu15ll_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu33");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu15ll_B_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu15ll_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu33(Test_BFu15ll_B_BFu33, "BFu15ll_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu7c()
{
  {
    init_simple_test("BFu15ll_B_BFu7c");
    static BFu15ll_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_B_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu7c(Test_BFu15ll_B_BFu7c, "BFu15ll_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu7i()
{
  {
    init_simple_test("BFu15ll_B_BFu7i");
    static BFu15ll_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_B_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu7i(Test_BFu15ll_B_BFu7i, "BFu15ll_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu7ll()
{
  {
    init_simple_test("BFu15ll_B_BFu7ll");
    static BFu15ll_B_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_B_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu7ll(Test_BFu15ll_B_BFu7ll, "BFu15ll_B_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu7s()
{
  {
    init_simple_test("BFu15ll_B_BFu7s");
    static BFu15ll_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_B_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu7s(Test_BFu15ll_B_BFu7s, "BFu15ll_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu8c()
{
  {
    init_simple_test("BFu15ll_B_BFu8c");
    static BFu15ll_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_B_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu8c(Test_BFu15ll_B_BFu8c, "BFu15ll_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu8i()
{
  {
    init_simple_test("BFu15ll_B_BFu8i");
    static BFu15ll_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_B_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu8i(Test_BFu15ll_B_BFu8i, "BFu15ll_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu8ll()
{
  {
    init_simple_test("BFu15ll_B_BFu8ll");
    static BFu15ll_B_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_B_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu8ll(Test_BFu15ll_B_BFu8ll, "BFu15ll_B_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu8s()
{
  {
    init_simple_test("BFu15ll_B_BFu8s");
    static BFu15ll_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_B_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu8s(Test_BFu15ll_B_BFu8s, "BFu15ll_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu9i()
{
  {
    init_simple_test("BFu15ll_B_BFu9i");
    static BFu15ll_B_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15ll_B_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15ll_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu9i(Test_BFu15ll_B_BFu9i, "BFu15ll_B_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu9ll()
{
  {
    init_simple_test("BFu15ll_B_BFu9ll");
    static BFu15ll_B_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15ll_B_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15ll_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu9ll(Test_BFu15ll_B_BFu9ll, "BFu15ll_B_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_BFu9s()
{
  {
    init_simple_test("BFu15ll_B_BFu9s");
    static BFu15ll_B_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15ll_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15ll_B_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15ll_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_BFu9s(Test_BFu15ll_B_BFu9s, "BFu15ll_B_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_C()
{
  {
    init_simple_test("BFu15ll_B_C");
    static BFu15ll_B_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_C");
    check_field_offset(lv, v2, 2, "BFu15ll_B_C.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_C(Test_BFu15ll_B_C, "BFu15ll_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_D()
{
  {
    init_simple_test("BFu15ll_B_D");
    static BFu15ll_B_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu15ll_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_D");
    check_field_offset(lv, v2, 2, "BFu15ll_B_D.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_D(Test_BFu15ll_B_D, "BFu15ll_B_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_F()
{
  {
    init_simple_test("BFu15ll_B_F");
    static BFu15ll_B_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_F");
    check_field_offset(lv, v2, 2, "BFu15ll_B_F.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_F(Test_BFu15ll_B_F, "BFu15ll_B_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_I()
{
  {
    init_simple_test("BFu15ll_B_I");
    static BFu15ll_B_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_I");
    check_field_offset(lv, v2, 2, "BFu15ll_B_I.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_I(Test_BFu15ll_B_I, "BFu15ll_B_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_Ip()
{
  {
    init_simple_test("BFu15ll_B_Ip");
    static BFu15ll_B_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15ll_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_Ip");
    check_field_offset(lv, v2, 2, "BFu15ll_B_Ip.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_Ip(Test_BFu15ll_B_Ip, "BFu15ll_B_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_L()
{
  {
    init_simple_test("BFu15ll_B_L");
    static BFu15ll_B_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu15ll_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_L");
    check_field_offset(lv, v2, 2, "BFu15ll_B_L.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_L(Test_BFu15ll_B_L, "BFu15ll_B_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_S()
{
  {
    init_simple_test("BFu15ll_B_S");
    static BFu15ll_B_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_S");
    check_field_offset(lv, v2, 2, "BFu15ll_B_S.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_S(Test_BFu15ll_B_S, "BFu15ll_B_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_Uc()
{
  {
    init_simple_test("BFu15ll_B_Uc");
    static BFu15ll_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_Uc");
    check_field_offset(lv, v2, 2, "BFu15ll_B_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_Uc(Test_BFu15ll_B_Uc, "BFu15ll_B_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_Ui()
{
  {
    init_simple_test("BFu15ll_B_Ui");
    static BFu15ll_B_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_Ui");
    check_field_offset(lv, v2, 2, "BFu15ll_B_Ui.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_Ui(Test_BFu15ll_B_Ui, "BFu15ll_B_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_Ul()
{
  {
    init_simple_test("BFu15ll_B_Ul");
    static BFu15ll_B_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu15ll_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_Ul");
    check_field_offset(lv, v2, 2, "BFu15ll_B_Ul.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_Ul(Test_BFu15ll_B_Ul, "BFu15ll_B_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_Us()
{
  {
    init_simple_test("BFu15ll_B_Us");
    static BFu15ll_B_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_Us");
    check_field_offset(lv, v2, 2, "BFu15ll_B_Us.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_Us(Test_BFu15ll_B_Us, "BFu15ll_B_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_B_Vp()
{
  {
    init_simple_test("BFu15ll_B_Vp");
    static BFu15ll_B_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15ll_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_B_Vp");
    check_field_offset(lv, v2, 2, "BFu15ll_B_Vp.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_B_Vp(Test_BFu15ll_B_Vp, "BFu15ll_B_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu15i_B()
{
  {
    init_simple_test("BFu15ll_BFu15i_B");
    static BFu15ll_BFu15i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_B");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu15i_B(Test_BFu15ll_BFu15i_B, "BFu15ll_BFu15i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu15ll_B()
{
  {
    init_simple_test("BFu15ll_BFu15ll_B");
    static BFu15ll_BFu15ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_B");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu15ll_B(Test_BFu15ll_BFu15ll_B, "BFu15ll_BFu15ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu15s_B()
{
  {
    init_simple_test("BFu15ll_BFu15s_B");
    static BFu15ll_BFu15s_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu15s_B(Test_BFu15ll_BFu15s_B, "BFu15ll_BFu15s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu16i_B()
{
  {
    init_simple_test("BFu15ll_BFu16i_B");
    static BFu15ll_BFu16i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_B");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu16i_B(Test_BFu15ll_BFu16i_B, "BFu15ll_BFu16i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu16ll_B()
{
  {
    init_simple_test("BFu15ll_BFu16ll_B");
    static BFu15ll_BFu16ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_B");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu16ll_B(Test_BFu15ll_BFu16ll_B, "BFu15ll_BFu16ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu16s_B()
{
  {
    init_simple_test("BFu15ll_BFu16s_B");
    static BFu15ll_BFu16s_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu16s_B(Test_BFu15ll_BFu16s_B, "BFu15ll_BFu16s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu17i_B()
{
  {
    init_simple_test("BFu15ll_BFu17i_B");
    static BFu15ll_BFu17i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_B");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu17i_B(Test_BFu15ll_BFu17i_B, "BFu15ll_BFu17i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu17ll_B()
{
  {
    init_simple_test("BFu15ll_BFu17ll_B");
    static BFu15ll_BFu17ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_B");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu17ll_B(Test_BFu15ll_BFu17ll_B, "BFu15ll_BFu17ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu1c_B()
{
  {
    init_simple_test("BFu15ll_BFu1c_B");
    static BFu15ll_BFu1c_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15ll_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_B");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu1c_B(Test_BFu15ll_BFu1c_B, "BFu15ll_BFu1c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu1i_B()
{
  {
    init_simple_test("BFu15ll_BFu1i_B");
    static BFu15ll_BFu1i_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15ll_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_B");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu1i_B(Test_BFu15ll_BFu1i_B, "BFu15ll_BFu1i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu1ll_B()
{
  {
    init_simple_test("BFu15ll_BFu1ll_B");
    static BFu15ll_BFu1ll_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15ll_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_B");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu1ll_B(Test_BFu15ll_BFu1ll_B, "BFu15ll_BFu1ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu1s_B()
{
  {
    init_simple_test("BFu15ll_BFu1s_B");
    static BFu15ll_BFu1s_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15ll_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_B");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu1s_B(Test_BFu15ll_BFu1s_B, "BFu15ll_BFu1s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu31i_B()
{
  {
    init_simple_test("BFu15ll_BFu31i_B");
    static BFu15ll_BFu31i_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_B");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu31i_B(Test_BFu15ll_BFu31i_B, "BFu15ll_BFu31i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu31ll_B()
{
  {
    init_simple_test("BFu15ll_BFu31ll_B");
    static BFu15ll_BFu31ll_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_B");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu31ll_B(Test_BFu15ll_BFu31ll_B, "BFu15ll_BFu31ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu32i_B()
{
  {
    init_simple_test("BFu15ll_BFu32i_B");
    static BFu15ll_BFu32i_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_B");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu32i_B(Test_BFu15ll_BFu32i_B, "BFu15ll_BFu32i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu32ll_B()
{
  {
    init_simple_test("BFu15ll_BFu32ll_B");
    static BFu15ll_BFu32ll_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_B");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu32ll_B(Test_BFu15ll_BFu32ll_B, "BFu15ll_BFu32ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu33_B()
{
  {
    init_simple_test("BFu15ll_BFu33_B");
    static BFu15ll_BFu33_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_B");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_B");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_B");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu33_B(Test_BFu15ll_BFu33_B, "BFu15ll_BFu33_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu7c_B()
{
  {
    init_simple_test("BFu15ll_BFu7c_B");
    static BFu15ll_BFu7c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_B");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu7c_B(Test_BFu15ll_BFu7c_B, "BFu15ll_BFu7c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu7i_B()
{
  {
    init_simple_test("BFu15ll_BFu7i_B");
    static BFu15ll_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_B");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu7i_B(Test_BFu15ll_BFu7i_B, "BFu15ll_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu7ll_B()
{
  {
    init_simple_test("BFu15ll_BFu7ll_B");
    static BFu15ll_BFu7ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_B");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu7ll_B(Test_BFu15ll_BFu7ll_B, "BFu15ll_BFu7ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu7s_B()
{
  {
    init_simple_test("BFu15ll_BFu7s_B");
    static BFu15ll_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_B");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu7s_B(Test_BFu15ll_BFu7s_B, "BFu15ll_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu8c_B()
{
  {
    init_simple_test("BFu15ll_BFu8c_B");
    static BFu15ll_BFu8c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_B");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu8c_B(Test_BFu15ll_BFu8c_B, "BFu15ll_BFu8c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu8i_B()
{
  {
    init_simple_test("BFu15ll_BFu8i_B");
    static BFu15ll_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_B");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu8i_B(Test_BFu15ll_BFu8i_B, "BFu15ll_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu8ll_B()
{
  {
    init_simple_test("BFu15ll_BFu8ll_B");
    static BFu15ll_BFu8ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_B");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu8ll_B(Test_BFu15ll_BFu8ll_B, "BFu15ll_BFu8ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu8s_B()
{
  {
    init_simple_test("BFu15ll_BFu8s_B");
    static BFu15ll_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_B");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu8s_B(Test_BFu15ll_BFu8s_B, "BFu15ll_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu9i_B()
{
  {
    init_simple_test("BFu15ll_BFu9i_B");
    static BFu15ll_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15ll_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu9i_B");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu9i_B(Test_BFu15ll_BFu9i_B, "BFu15ll_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu9ll_B()
{
  {
    init_simple_test("BFu15ll_BFu9ll_B");
    static BFu15ll_BFu9ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu9ll_B");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu9ll_B(Test_BFu15ll_BFu9ll_B, "BFu15ll_BFu9ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_BFu9s_B()
{
  {
    init_simple_test("BFu15ll_BFu9s_B");
    static BFu15ll_BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15ll_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu9s_B");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu9s_B(Test_BFu15ll_BFu9s_B, "BFu15ll_BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_C_B()
{
  {
    init_simple_test("BFu15ll_C_B");
    static BFu15ll_C_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_C_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_C_B");
    check_field_offset(lv, v2, 2, "BFu15ll_C_B.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_C_B(Test_BFu15ll_C_B, "BFu15ll_C_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_D_B()
{
  {
    init_simple_test("BFu15ll_D_B");
    static BFu15ll_D_B lv;
    check2(sizeof(lv), 11, "sizeof(BFu15ll_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_D_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_D_B");
    check_field_offset(lv, v2, 2, "BFu15ll_D_B.v2");
    check_field_offset(lv, v3, 10, "BFu15ll_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_D_B(Test_BFu15ll_D_B, "BFu15ll_D_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_F_B()
{
  {
    init_simple_test("BFu15ll_F_B");
    static BFu15ll_F_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_F_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_F_B");
    check_field_offset(lv, v2, 2, "BFu15ll_F_B.v2");
    check_field_offset(lv, v3, 6, "BFu15ll_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_F_B(Test_BFu15ll_F_B, "BFu15ll_F_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_I_B()
{
  {
    init_simple_test("BFu15ll_I_B");
    static BFu15ll_I_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_I_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_I_B");
    check_field_offset(lv, v2, 2, "BFu15ll_I_B.v2");
    check_field_offset(lv, v3, 6, "BFu15ll_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_I_B(Test_BFu15ll_I_B, "BFu15ll_I_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_Ip_B()
{
  {
    init_simple_test("BFu15ll_Ip_B");
    static BFu15ll_Ip_B lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15ll_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ip_B");
    check_field_offset(lv, v2, 2, "BFu15ll_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15ll_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Ip_B(Test_BFu15ll_Ip_B, "BFu15ll_Ip_B", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_L_B()
{
  {
    init_simple_test("BFu15ll_L_B");
    static BFu15ll_L_B lv;
    check2(sizeof(lv), 11, "sizeof(BFu15ll_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_L_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_L_B");
    check_field_offset(lv, v2, 2, "BFu15ll_L_B.v2");
    check_field_offset(lv, v3, 10, "BFu15ll_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_L_B(Test_BFu15ll_L_B, "BFu15ll_L_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_S_B()
{
  {
    init_simple_test("BFu15ll_S_B");
    static BFu15ll_S_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_S_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_S_B");
    check_field_offset(lv, v2, 2, "BFu15ll_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu15ll_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_S_B(Test_BFu15ll_S_B, "BFu15ll_S_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_Uc_B()
{
  {
    init_simple_test("BFu15ll_Uc_B");
    static BFu15ll_Uc_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15ll_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Uc_B");
    check_field_offset(lv, v2, 2, "BFu15ll_Uc_B.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Uc_B(Test_BFu15ll_Uc_B, "BFu15ll_Uc_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_Ui_B()
{
  {
    init_simple_test("BFu15ll_Ui_B");
    static BFu15ll_Ui_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15ll_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ui_B");
    check_field_offset(lv, v2, 2, "BFu15ll_Ui_B.v2");
    check_field_offset(lv, v3, 6, "BFu15ll_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Ui_B(Test_BFu15ll_Ui_B, "BFu15ll_Ui_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_Ul_B()
{
  {
    init_simple_test("BFu15ll_Ul_B");
    static BFu15ll_Ul_B lv;
    check2(sizeof(lv), 11, "sizeof(BFu15ll_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ul_B");
    check_field_offset(lv, v2, 2, "BFu15ll_Ul_B.v2");
    check_field_offset(lv, v3, 10, "BFu15ll_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Ul_B(Test_BFu15ll_Ul_B, "BFu15ll_Ul_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_Us_B()
{
  {
    init_simple_test("BFu15ll_Us_B");
    static BFu15ll_Us_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15ll_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Us_B");
    check_field_offset(lv, v2, 2, "BFu15ll_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu15ll_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Us_B(Test_BFu15ll_Us_B, "BFu15ll_Us_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15ll_Vp_B()
{
  {
    init_simple_test("BFu15ll_Vp_B");
    static BFu15ll_Vp_B lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15ll_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Vp_B");
    check_field_offset(lv, v2, 2, "BFu15ll_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15ll_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Vp_B(Test_BFu15ll_Vp_B, "BFu15ll_Vp_B", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B()
{
  {
    init_simple_test("BFu15s_B");
    static BFu15s_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B");
    check_field_offset(lv, v2, 2, "BFu15s_B.v2");
  }
}
static Arrange_To_Call_Me vBFu15s_B(Test_BFu15s_B, "BFu15s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_B()
{
  {
    init_simple_test("BFu15s_B_B");
    static BFu15s_B_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_B");
    check_field_offset(lv, v2, 2, "BFu15s_B_B.v2");
    check_field_offset(lv, v3, 3, "BFu15s_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_B_B(Test_BFu15s_B_B, "BFu15s_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu15i()
{
  {
    init_simple_test("BFu15s_B_BFu15i");
    static BFu15s_B_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15s_B_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu15i(Test_BFu15s_B_BFu15i, "BFu15s_B_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu15ll()
{
  {
    init_simple_test("BFu15s_B_BFu15ll");
    static BFu15s_B_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15s_B_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu15ll(Test_BFu15s_B_BFu15ll, "BFu15s_B_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu15s()
{
  {
    init_simple_test("BFu15s_B_BFu15s");
    static BFu15s_B_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15s_B_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu15s(Test_BFu15s_B_BFu15s, "BFu15s_B_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu16i()
{
  {
    init_simple_test("BFu15s_B_BFu16i");
    static BFu15s_B_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15s_B_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15s_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu16i(Test_BFu15s_B_BFu16i, "BFu15s_B_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu16ll()
{
  {
    init_simple_test("BFu15s_B_BFu16ll");
    static BFu15s_B_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15s_B_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15s_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu16ll(Test_BFu15s_B_BFu16ll, "BFu15s_B_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu16s()
{
  {
    init_simple_test("BFu15s_B_BFu16s");
    static BFu15s_B_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15s_B_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15s_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu16s(Test_BFu15s_B_BFu16s, "BFu15s_B_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu17i()
{
  {
    init_simple_test("BFu15s_B_BFu17i");
    static BFu15s_B_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu15s_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15s_B_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15s_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu17i(Test_BFu15s_B_BFu17i, "BFu15s_B_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu17ll()
{
  {
    init_simple_test("BFu15s_B_BFu17ll");
    static BFu15s_B_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu15s_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15s_B_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15s_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu17ll(Test_BFu15s_B_BFu17ll, "BFu15s_B_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu1c()
{
  {
    init_simple_test("BFu15s_B_BFu1c");
    static BFu15s_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15s_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu1c(Test_BFu15s_B_BFu1c, "BFu15s_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu1i()
{
  {
    init_simple_test("BFu15s_B_BFu1i");
    static BFu15s_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15s_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu1i(Test_BFu15s_B_BFu1i, "BFu15s_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu1ll()
{
  {
    init_simple_test("BFu15s_B_BFu1ll");
    static BFu15s_B_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15s_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu1ll(Test_BFu15s_B_BFu1ll, "BFu15s_B_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu1s()
{
  {
    init_simple_test("BFu15s_B_BFu1s");
    static BFu15s_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15s_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu1s(Test_BFu15s_B_BFu1s, "BFu15s_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu31i()
{
  {
    init_simple_test("BFu15s_B_BFu31i");
    static BFu15s_B_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15s_B_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15s_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu31i(Test_BFu15s_B_BFu31i, "BFu15s_B_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu31ll()
{
  {
    init_simple_test("BFu15s_B_BFu31ll");
    static BFu15s_B_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15s_B_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15s_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu31ll(Test_BFu15s_B_BFu31ll, "BFu15s_B_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu32i()
{
  {
    init_simple_test("BFu15s_B_BFu32i");
    static BFu15s_B_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15s_B_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15s_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu32i(Test_BFu15s_B_BFu32i, "BFu15s_B_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu32ll()
{
  {
    init_simple_test("BFu15s_B_BFu32ll");
    static BFu15s_B_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15s_B_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15s_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu32ll(Test_BFu15s_B_BFu32ll, "BFu15s_B_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu33()
{
  {
    init_simple_test("BFu15s_B_BFu33");
    static BFu15s_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu33");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu15s_B_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu15s_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu33(Test_BFu15s_B_BFu33, "BFu15s_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu7c()
{
  {
    init_simple_test("BFu15s_B_BFu7c");
    static BFu15s_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15s_B_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15s_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu7c(Test_BFu15s_B_BFu7c, "BFu15s_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu7i()
{
  {
    init_simple_test("BFu15s_B_BFu7i");
    static BFu15s_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15s_B_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15s_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu7i(Test_BFu15s_B_BFu7i, "BFu15s_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu7ll()
{
  {
    init_simple_test("BFu15s_B_BFu7ll");
    static BFu15s_B_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15s_B_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15s_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu7ll(Test_BFu15s_B_BFu7ll, "BFu15s_B_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu7s()
{
  {
    init_simple_test("BFu15s_B_BFu7s");
    static BFu15s_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15s_B_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15s_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu7s(Test_BFu15s_B_BFu7s, "BFu15s_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu8c()
{
  {
    init_simple_test("BFu15s_B_BFu8c");
    static BFu15s_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15s_B_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15s_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu8c(Test_BFu15s_B_BFu8c, "BFu15s_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu8i()
{
  {
    init_simple_test("BFu15s_B_BFu8i");
    static BFu15s_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15s_B_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15s_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu8i(Test_BFu15s_B_BFu8i, "BFu15s_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu8ll()
{
  {
    init_simple_test("BFu15s_B_BFu8ll");
    static BFu15s_B_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15s_B_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15s_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu8ll(Test_BFu15s_B_BFu8ll, "BFu15s_B_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu8s()
{
  {
    init_simple_test("BFu15s_B_BFu8s");
    static BFu15s_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15s_B_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15s_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu8s(Test_BFu15s_B_BFu8s, "BFu15s_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu9i()
{
  {
    init_simple_test("BFu15s_B_BFu9i");
    static BFu15s_B_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15s_B_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15s_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu9i(Test_BFu15s_B_BFu9i, "BFu15s_B_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu9ll()
{
  {
    init_simple_test("BFu15s_B_BFu9ll");
    static BFu15s_B_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15s_B_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15s_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu9ll(Test_BFu15s_B_BFu9ll, "BFu15s_B_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_BFu9s()
{
  {
    init_simple_test("BFu15s_B_BFu9s");
    static BFu15s_B_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15s_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15s_B_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15s_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu15s_B_BFu9s(Test_BFu15s_B_BFu9s, "BFu15s_B_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_C()
{
  {
    init_simple_test("BFu15s_B_C");
    static BFu15s_B_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_C");
    check_field_offset(lv, v2, 2, "BFu15s_B_C.v2");
    check_field_offset(lv, v3, 3, "BFu15s_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_B_C(Test_BFu15s_B_C, "BFu15s_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_D()
{
  {
    init_simple_test("BFu15s_B_D");
    static BFu15s_B_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu15s_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_D");
    check_field_offset(lv, v2, 2, "BFu15s_B_D.v2");
    check_field_offset(lv, v3, 3, "BFu15s_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_B_D(Test_BFu15s_B_D, "BFu15s_B_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_F()
{
  {
    init_simple_test("BFu15s_B_F");
    static BFu15s_B_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_F");
    check_field_offset(lv, v2, 2, "BFu15s_B_F.v2");
    check_field_offset(lv, v3, 3, "BFu15s_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_B_F(Test_BFu15s_B_F, "BFu15s_B_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_I()
{
  {
    init_simple_test("BFu15s_B_I");
    static BFu15s_B_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_I");
    check_field_offset(lv, v2, 2, "BFu15s_B_I.v2");
    check_field_offset(lv, v3, 3, "BFu15s_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_B_I(Test_BFu15s_B_I, "BFu15s_B_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_Ip()
{
  {
    init_simple_test("BFu15s_B_Ip");
    static BFu15s_B_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15s_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_Ip");
    check_field_offset(lv, v2, 2, "BFu15s_B_Ip.v2");
    check_field_offset(lv, v3, 3, "BFu15s_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_B_Ip(Test_BFu15s_B_Ip, "BFu15s_B_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_L()
{
  {
    init_simple_test("BFu15s_B_L");
    static BFu15s_B_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu15s_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_L");
    check_field_offset(lv, v2, 2, "BFu15s_B_L.v2");
    check_field_offset(lv, v3, 3, "BFu15s_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_B_L(Test_BFu15s_B_L, "BFu15s_B_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_S()
{
  {
    init_simple_test("BFu15s_B_S");
    static BFu15s_B_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_S");
    check_field_offset(lv, v2, 2, "BFu15s_B_S.v2");
    check_field_offset(lv, v3, 3, "BFu15s_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_B_S(Test_BFu15s_B_S, "BFu15s_B_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_Uc()
{
  {
    init_simple_test("BFu15s_B_Uc");
    static BFu15s_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_Uc");
    check_field_offset(lv, v2, 2, "BFu15s_B_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu15s_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_B_Uc(Test_BFu15s_B_Uc, "BFu15s_B_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_Ui()
{
  {
    init_simple_test("BFu15s_B_Ui");
    static BFu15s_B_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_Ui");
    check_field_offset(lv, v2, 2, "BFu15s_B_Ui.v2");
    check_field_offset(lv, v3, 3, "BFu15s_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_B_Ui(Test_BFu15s_B_Ui, "BFu15s_B_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_Ul()
{
  {
    init_simple_test("BFu15s_B_Ul");
    static BFu15s_B_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu15s_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_Ul");
    check_field_offset(lv, v2, 2, "BFu15s_B_Ul.v2");
    check_field_offset(lv, v3, 3, "BFu15s_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_B_Ul(Test_BFu15s_B_Ul, "BFu15s_B_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_Us()
{
  {
    init_simple_test("BFu15s_B_Us");
    static BFu15s_B_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_Us");
    check_field_offset(lv, v2, 2, "BFu15s_B_Us.v2");
    check_field_offset(lv, v3, 3, "BFu15s_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_B_Us(Test_BFu15s_B_Us, "BFu15s_B_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_B_Vp()
{
  {
    init_simple_test("BFu15s_B_Vp");
    static BFu15s_B_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15s_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_B_Vp");
    check_field_offset(lv, v2, 2, "BFu15s_B_Vp.v2");
    check_field_offset(lv, v3, 3, "BFu15s_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_B_Vp(Test_BFu15s_B_Vp, "BFu15s_B_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu15i_B()
{
  {
    init_simple_test("BFu15s_BFu15i_B");
    static BFu15s_BFu15i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15s_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15s_BFu15i_B");
    check_field_offset(lv, v3, 4, "BFu15s_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu15i_B(Test_BFu15s_BFu15i_B, "BFu15s_BFu15i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu15ll_B()
{
  {
    init_simple_test("BFu15s_BFu15ll_B");
    static BFu15s_BFu15ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15s_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15s_BFu15ll_B");
    check_field_offset(lv, v3, 4, "BFu15s_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu15ll_B(Test_BFu15s_BFu15ll_B, "BFu15s_BFu15ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu15s_B()
{
  {
    init_simple_test("BFu15s_BFu15s_B");
    static BFu15s_BFu15s_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15s_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15s_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu15s_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu15s_B(Test_BFu15s_BFu15s_B, "BFu15s_BFu15s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu16i_B()
{
  {
    init_simple_test("BFu15s_BFu16i_B");
    static BFu15s_BFu16i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15s_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15s_BFu16i_B");
    check_field_offset(lv, v3, 4, "BFu15s_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu16i_B(Test_BFu15s_BFu16i_B, "BFu15s_BFu16i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu16ll_B()
{
  {
    init_simple_test("BFu15s_BFu16ll_B");
    static BFu15s_BFu16ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15s_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15s_BFu16ll_B");
    check_field_offset(lv, v3, 4, "BFu15s_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu16ll_B(Test_BFu15s_BFu16ll_B, "BFu15s_BFu16ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu16s_B()
{
  {
    init_simple_test("BFu15s_BFu16s_B");
    static BFu15s_BFu16s_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15s_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15s_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu15s_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu16s_B(Test_BFu15s_BFu16s_B, "BFu15s_BFu16s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu17i_B()
{
  {
    init_simple_test("BFu15s_BFu17i_B");
    static BFu15s_BFu17i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15s_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15s_BFu17i_B");
    check_field_offset(lv, v3, 4, "BFu15s_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu17i_B(Test_BFu15s_BFu17i_B, "BFu15s_BFu17i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu17ll_B()
{
  {
    init_simple_test("BFu15s_BFu17ll_B");
    static BFu15s_BFu17ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15s_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15s_BFu17ll_B");
    check_field_offset(lv, v3, 4, "BFu15s_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu17ll_B(Test_BFu15s_BFu17ll_B, "BFu15s_BFu17ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu1c_B()
{
  {
    init_simple_test("BFu15s_BFu1c_B");
    static BFu15s_BFu1c_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15s_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15s_BFu1c_B");
    check_field_offset(lv, v3, 2, "BFu15s_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu1c_B(Test_BFu15s_BFu1c_B, "BFu15s_BFu1c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu1i_B()
{
  {
    init_simple_test("BFu15s_BFu1i_B");
    static BFu15s_BFu1i_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15s_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15s_BFu1i_B");
    check_field_offset(lv, v3, 2, "BFu15s_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu1i_B(Test_BFu15s_BFu1i_B, "BFu15s_BFu1i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu1ll_B()
{
  {
    init_simple_test("BFu15s_BFu1ll_B");
    static BFu15s_BFu1ll_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15s_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15s_BFu1ll_B");
    check_field_offset(lv, v3, 2, "BFu15s_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu1ll_B(Test_BFu15s_BFu1ll_B, "BFu15s_BFu1ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu1s_B()
{
  {
    init_simple_test("BFu15s_BFu1s_B");
    static BFu15s_BFu1s_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu15s_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15s_BFu1s_B");
    check_field_offset(lv, v3, 2, "BFu15s_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu1s_B(Test_BFu15s_BFu1s_B, "BFu15s_BFu1s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu31i_B()
{
  {
    init_simple_test("BFu15s_BFu31i_B");
    static BFu15s_BFu31i_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15s_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15s_BFu31i_B");
    check_field_offset(lv, v3, 6, "BFu15s_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu31i_B(Test_BFu15s_BFu31i_B, "BFu15s_BFu31i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu31ll_B()
{
  {
    init_simple_test("BFu15s_BFu31ll_B");
    static BFu15s_BFu31ll_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15s_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15s_BFu31ll_B");
    check_field_offset(lv, v3, 6, "BFu15s_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu31ll_B(Test_BFu15s_BFu31ll_B, "BFu15s_BFu31ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu32i_B()
{
  {
    init_simple_test("BFu15s_BFu32i_B");
    static BFu15s_BFu32i_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15s_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15s_BFu32i_B");
    check_field_offset(lv, v3, 6, "BFu15s_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu32i_B(Test_BFu15s_BFu32i_B, "BFu15s_BFu32i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu32ll_B()
{
  {
    init_simple_test("BFu15s_BFu32ll_B");
    static BFu15s_BFu32ll_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15s_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15s_BFu32ll_B");
    check_field_offset(lv, v3, 6, "BFu15s_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu32ll_B(Test_BFu15s_BFu32ll_B, "BFu15s_BFu32ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu33_B()
{
  {
    init_simple_test("BFu15s_BFu33_B");
    static BFu15s_BFu33_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu33_B");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15s_BFu33_B");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15s_BFu33_B");
    check_field_offset(lv, v3, 6, "BFu15s_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu33_B(Test_BFu15s_BFu33_B, "BFu15s_BFu33_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu7c_B()
{
  {
    init_simple_test("BFu15s_BFu7c_B");
    static BFu15s_BFu7c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15s_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15s_BFu7c_B");
    check_field_offset(lv, v3, 3, "BFu15s_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu7c_B(Test_BFu15s_BFu7c_B, "BFu15s_BFu7c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu7i_B()
{
  {
    init_simple_test("BFu15s_BFu7i_B");
    static BFu15s_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15s_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15s_BFu7i_B");
    check_field_offset(lv, v3, 3, "BFu15s_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu7i_B(Test_BFu15s_BFu7i_B, "BFu15s_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu7ll_B()
{
  {
    init_simple_test("BFu15s_BFu7ll_B");
    static BFu15s_BFu7ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15s_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15s_BFu7ll_B");
    check_field_offset(lv, v3, 3, "BFu15s_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu7ll_B(Test_BFu15s_BFu7ll_B, "BFu15s_BFu7ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu7s_B()
{
  {
    init_simple_test("BFu15s_BFu7s_B");
    static BFu15s_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15s_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15s_BFu7s_B");
    check_field_offset(lv, v3, 3, "BFu15s_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu7s_B(Test_BFu15s_BFu7s_B, "BFu15s_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu8c_B()
{
  {
    init_simple_test("BFu15s_BFu8c_B");
    static BFu15s_BFu8c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15s_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15s_BFu8c_B");
    check_field_offset(lv, v3, 3, "BFu15s_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu8c_B(Test_BFu15s_BFu8c_B, "BFu15s_BFu8c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu8i_B()
{
  {
    init_simple_test("BFu15s_BFu8i_B");
    static BFu15s_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15s_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15s_BFu8i_B");
    check_field_offset(lv, v3, 3, "BFu15s_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu8i_B(Test_BFu15s_BFu8i_B, "BFu15s_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu8ll_B()
{
  {
    init_simple_test("BFu15s_BFu8ll_B");
    static BFu15s_BFu8ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15s_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15s_BFu8ll_B");
    check_field_offset(lv, v3, 3, "BFu15s_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu8ll_B(Test_BFu15s_BFu8ll_B, "BFu15s_BFu8ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu8s_B()
{
  {
    init_simple_test("BFu15s_BFu8s_B");
    static BFu15s_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15s_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15s_BFu8s_B");
    check_field_offset(lv, v3, 3, "BFu15s_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu8s_B(Test_BFu15s_BFu8s_B, "BFu15s_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu9i_B()
{
  {
    init_simple_test("BFu15s_BFu9i_B");
    static BFu15s_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15s_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15s_BFu9i_B");
    check_field_offset(lv, v3, 3, "BFu15s_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu9i_B(Test_BFu15s_BFu9i_B, "BFu15s_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu9ll_B()
{
  {
    init_simple_test("BFu15s_BFu9ll_B");
    static BFu15s_BFu9ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15s_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15s_BFu9ll_B");
    check_field_offset(lv, v3, 3, "BFu15s_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu9ll_B(Test_BFu15s_BFu9ll_B, "BFu15s_BFu9ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_BFu9s_B()
{
  {
    init_simple_test("BFu15s_BFu9s_B");
    static BFu15s_BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15s_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15s_BFu9s_B");
    check_field_offset(lv, v3, 3, "BFu15s_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu9s_B(Test_BFu15s_BFu9s_B, "BFu15s_BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_C_B()
{
  {
    init_simple_test("BFu15s_C_B");
    static BFu15s_C_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_C_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_C_B");
    check_field_offset(lv, v2, 2, "BFu15s_C_B.v2");
    check_field_offset(lv, v3, 3, "BFu15s_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_C_B(Test_BFu15s_C_B, "BFu15s_C_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_D_B()
{
  {
    init_simple_test("BFu15s_D_B");
    static BFu15s_D_B lv;
    check2(sizeof(lv), 11, "sizeof(BFu15s_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_D_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_D_B");
    check_field_offset(lv, v2, 2, "BFu15s_D_B.v2");
    check_field_offset(lv, v3, 10, "BFu15s_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_D_B(Test_BFu15s_D_B, "BFu15s_D_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_F_B()
{
  {
    init_simple_test("BFu15s_F_B");
    static BFu15s_F_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_F_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_F_B");
    check_field_offset(lv, v2, 2, "BFu15s_F_B.v2");
    check_field_offset(lv, v3, 6, "BFu15s_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_F_B(Test_BFu15s_F_B, "BFu15s_F_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_I_B()
{
  {
    init_simple_test("BFu15s_I_B");
    static BFu15s_I_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_I_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_I_B");
    check_field_offset(lv, v2, 2, "BFu15s_I_B.v2");
    check_field_offset(lv, v3, 6, "BFu15s_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_I_B(Test_BFu15s_I_B, "BFu15s_I_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_Ip_B()
{
  {
    init_simple_test("BFu15s_Ip_B");
    static BFu15s_Ip_B lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15s_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Ip_B");
    check_field_offset(lv, v2, 2, "BFu15s_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15s_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Ip_B(Test_BFu15s_Ip_B, "BFu15s_Ip_B", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_L_B()
{
  {
    init_simple_test("BFu15s_L_B");
    static BFu15s_L_B lv;
    check2(sizeof(lv), 11, "sizeof(BFu15s_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_L_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_L_B");
    check_field_offset(lv, v2, 2, "BFu15s_L_B.v2");
    check_field_offset(lv, v3, 10, "BFu15s_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_L_B(Test_BFu15s_L_B, "BFu15s_L_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_S_B()
{
  {
    init_simple_test("BFu15s_S_B");
    static BFu15s_S_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_S_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_S_B");
    check_field_offset(lv, v2, 2, "BFu15s_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu15s_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_S_B(Test_BFu15s_S_B, "BFu15s_S_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_Uc_B()
{
  {
    init_simple_test("BFu15s_Uc_B");
    static BFu15s_Uc_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Uc_B");
    check_field_offset(lv, v2, 2, "BFu15s_Uc_B.v2");
    check_field_offset(lv, v3, 3, "BFu15s_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Uc_B(Test_BFu15s_Uc_B, "BFu15s_Uc_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_Ui_B()
{
  {
    init_simple_test("BFu15s_Ui_B");
    static BFu15s_Ui_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu15s_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Ui_B");
    check_field_offset(lv, v2, 2, "BFu15s_Ui_B.v2");
    check_field_offset(lv, v3, 6, "BFu15s_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Ui_B(Test_BFu15s_Ui_B, "BFu15s_Ui_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_Ul_B()
{
  {
    init_simple_test("BFu15s_Ul_B");
    static BFu15s_Ul_B lv;
    check2(sizeof(lv), 11, "sizeof(BFu15s_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Ul_B");
    check_field_offset(lv, v2, 2, "BFu15s_Ul_B.v2");
    check_field_offset(lv, v3, 10, "BFu15s_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Ul_B(Test_BFu15s_Ul_B, "BFu15s_Ul_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_Us_B()
{
  {
    init_simple_test("BFu15s_Us_B");
    static BFu15s_Us_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu15s_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Us_B");
    check_field_offset(lv, v2, 2, "BFu15s_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu15s_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Us_B(Test_BFu15s_Us_B, "BFu15s_Us_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu15s_Vp_B()
{
  {
    init_simple_test("BFu15s_Vp_B");
    static BFu15s_Vp_B lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu15s_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Vp_B");
    check_field_offset(lv, v2, 2, "BFu15s_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu15s_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Vp_B(Test_BFu15s_Vp_B, "BFu15s_Vp_B", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B()
{
  {
    init_simple_test("BFu16i_B");
    static BFu16i_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B");
    check_field_offset(lv, v2, 2, "BFu16i_B.v2");
  }
}
static Arrange_To_Call_Me vBFu16i_B(Test_BFu16i_B, "BFu16i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_B()
{
  {
    init_simple_test("BFu16i_B_B");
    static BFu16i_B_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_B");
    check_field_offset(lv, v2, 2, "BFu16i_B_B.v2");
    check_field_offset(lv, v3, 3, "BFu16i_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_B_B(Test_BFu16i_B_B, "BFu16i_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu15i()
{
  {
    init_simple_test("BFu16i_B_BFu15i");
    static BFu16i_B_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu15i");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu16i_B_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu16i_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu15i(Test_BFu16i_B_BFu15i, "BFu16i_B_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu15ll()
{
  {
    init_simple_test("BFu16i_B_BFu15ll");
    static BFu16i_B_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu16i_B_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu16i_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu15ll(Test_BFu16i_B_BFu15ll, "BFu16i_B_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu15s()
{
  {
    init_simple_test("BFu16i_B_BFu15s");
    static BFu16i_B_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu15s");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu16i_B_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu16i_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu15s(Test_BFu16i_B_BFu15s, "BFu16i_B_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu16i()
{
  {
    init_simple_test("BFu16i_B_BFu16i");
    static BFu16i_B_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu16i");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu16i_B_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu16i(Test_BFu16i_B_BFu16i, "BFu16i_B_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu16ll()
{
  {
    init_simple_test("BFu16i_B_BFu16ll");
    static BFu16i_B_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu16i_B_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu16ll(Test_BFu16i_B_BFu16ll, "BFu16i_B_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu16s()
{
  {
    init_simple_test("BFu16i_B_BFu16s");
    static BFu16i_B_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu16s");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu16i_B_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu16s(Test_BFu16i_B_BFu16s, "BFu16i_B_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu17i()
{
  {
    init_simple_test("BFu16i_B_BFu17i");
    static BFu16i_B_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu16i_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu17i");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu16i_B_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu16i_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu17i(Test_BFu16i_B_BFu17i, "BFu16i_B_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu17ll()
{
  {
    init_simple_test("BFu16i_B_BFu17ll");
    static BFu16i_B_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu16i_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu16i_B_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu16i_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu17ll(Test_BFu16i_B_BFu17ll, "BFu16i_B_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu1c()
{
  {
    init_simple_test("BFu16i_B_BFu1c");
    static BFu16i_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu1c");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16i_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu1c(Test_BFu16i_B_BFu1c, "BFu16i_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu1i()
{
  {
    init_simple_test("BFu16i_B_BFu1i");
    static BFu16i_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu1i");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16i_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu1i(Test_BFu16i_B_BFu1i, "BFu16i_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu1ll()
{
  {
    init_simple_test("BFu16i_B_BFu1ll");
    static BFu16i_B_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16i_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu1ll(Test_BFu16i_B_BFu1ll, "BFu16i_B_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu1s()
{
  {
    init_simple_test("BFu16i_B_BFu1s");
    static BFu16i_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu1s");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16i_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu1s(Test_BFu16i_B_BFu1s, "BFu16i_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu31i()
{
  {
    init_simple_test("BFu16i_B_BFu31i");
    static BFu16i_B_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu31i");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu16i_B_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu16i_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu31i(Test_BFu16i_B_BFu31i, "BFu16i_B_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu31ll()
{
  {
    init_simple_test("BFu16i_B_BFu31ll");
    static BFu16i_B_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu16i_B_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu16i_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu31ll(Test_BFu16i_B_BFu31ll, "BFu16i_B_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu32i()
{
  {
    init_simple_test("BFu16i_B_BFu32i");
    static BFu16i_B_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu32i");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu16i_B_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu16i_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu32i(Test_BFu16i_B_BFu32i, "BFu16i_B_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu32ll()
{
  {
    init_simple_test("BFu16i_B_BFu32ll");
    static BFu16i_B_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu16i_B_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu16i_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu32ll(Test_BFu16i_B_BFu32ll, "BFu16i_B_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu33()
{
  {
    init_simple_test("BFu16i_B_BFu33");
    static BFu16i_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu33");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu16i_B_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu16i_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu33(Test_BFu16i_B_BFu33, "BFu16i_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu7c()
{
  {
    init_simple_test("BFu16i_B_BFu7c");
    static BFu16i_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu7c");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16i_B_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16i_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu7c(Test_BFu16i_B_BFu7c, "BFu16i_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu7i()
{
  {
    init_simple_test("BFu16i_B_BFu7i");
    static BFu16i_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu7i");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16i_B_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16i_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu7i(Test_BFu16i_B_BFu7i, "BFu16i_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu7ll()
{
  {
    init_simple_test("BFu16i_B_BFu7ll");
    static BFu16i_B_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16i_B_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16i_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu7ll(Test_BFu16i_B_BFu7ll, "BFu16i_B_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu7s()
{
  {
    init_simple_test("BFu16i_B_BFu7s");
    static BFu16i_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu7s");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16i_B_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16i_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu7s(Test_BFu16i_B_BFu7s, "BFu16i_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu8c()
{
  {
    init_simple_test("BFu16i_B_BFu8c");
    static BFu16i_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu8c");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16i_B_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16i_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu8c(Test_BFu16i_B_BFu8c, "BFu16i_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu8i()
{
  {
    init_simple_test("BFu16i_B_BFu8i");
    static BFu16i_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu8i");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16i_B_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16i_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu8i(Test_BFu16i_B_BFu8i, "BFu16i_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu8ll()
{
  {
    init_simple_test("BFu16i_B_BFu8ll");
    static BFu16i_B_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16i_B_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16i_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu8ll(Test_BFu16i_B_BFu8ll, "BFu16i_B_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu8s()
{
  {
    init_simple_test("BFu16i_B_BFu8s");
    static BFu16i_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu8s");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16i_B_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16i_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu8s(Test_BFu16i_B_BFu8s, "BFu16i_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu9i()
{
  {
    init_simple_test("BFu16i_B_BFu9i");
    static BFu16i_B_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu9i");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu16i_B_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu16i_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu9i(Test_BFu16i_B_BFu9i, "BFu16i_B_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu9ll()
{
  {
    init_simple_test("BFu16i_B_BFu9ll");
    static BFu16i_B_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu16i_B_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu16i_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu9ll(Test_BFu16i_B_BFu9ll, "BFu16i_B_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_BFu9s()
{
  {
    init_simple_test("BFu16i_B_BFu9s");
    static BFu16i_B_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_BFu9s");
    check_field_offset(lv, v2, 2, "BFu16i_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu16i_B_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu16i_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu16i_B_BFu9s(Test_BFu16i_B_BFu9s, "BFu16i_B_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_C()
{
  {
    init_simple_test("BFu16i_B_C");
    static BFu16i_B_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_C");
    check_field_offset(lv, v2, 2, "BFu16i_B_C.v2");
    check_field_offset(lv, v3, 3, "BFu16i_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_B_C(Test_BFu16i_B_C, "BFu16i_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_D()
{
  {
    init_simple_test("BFu16i_B_D");
    static BFu16i_B_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu16i_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_D");
    check_field_offset(lv, v2, 2, "BFu16i_B_D.v2");
    check_field_offset(lv, v3, 3, "BFu16i_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_B_D(Test_BFu16i_B_D, "BFu16i_B_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_F()
{
  {
    init_simple_test("BFu16i_B_F");
    static BFu16i_B_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_F");
    check_field_offset(lv, v2, 2, "BFu16i_B_F.v2");
    check_field_offset(lv, v3, 3, "BFu16i_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_B_F(Test_BFu16i_B_F, "BFu16i_B_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_I()
{
  {
    init_simple_test("BFu16i_B_I");
    static BFu16i_B_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_I");
    check_field_offset(lv, v2, 2, "BFu16i_B_I.v2");
    check_field_offset(lv, v3, 3, "BFu16i_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_B_I(Test_BFu16i_B_I, "BFu16i_B_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_Ip()
{
  {
    init_simple_test("BFu16i_B_Ip");
    static BFu16i_B_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu16i_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_Ip");
    check_field_offset(lv, v2, 2, "BFu16i_B_Ip.v2");
    check_field_offset(lv, v3, 3, "BFu16i_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_B_Ip(Test_BFu16i_B_Ip, "BFu16i_B_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_L()
{
  {
    init_simple_test("BFu16i_B_L");
    static BFu16i_B_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu16i_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_L");
    check_field_offset(lv, v2, 2, "BFu16i_B_L.v2");
    check_field_offset(lv, v3, 3, "BFu16i_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_B_L(Test_BFu16i_B_L, "BFu16i_B_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_S()
{
  {
    init_simple_test("BFu16i_B_S");
    static BFu16i_B_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_S");
    check_field_offset(lv, v2, 2, "BFu16i_B_S.v2");
    check_field_offset(lv, v3, 3, "BFu16i_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_B_S(Test_BFu16i_B_S, "BFu16i_B_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_Uc()
{
  {
    init_simple_test("BFu16i_B_Uc");
    static BFu16i_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_Uc");
    check_field_offset(lv, v2, 2, "BFu16i_B_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu16i_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_B_Uc(Test_BFu16i_B_Uc, "BFu16i_B_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_Ui()
{
  {
    init_simple_test("BFu16i_B_Ui");
    static BFu16i_B_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_Ui");
    check_field_offset(lv, v2, 2, "BFu16i_B_Ui.v2");
    check_field_offset(lv, v3, 3, "BFu16i_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_B_Ui(Test_BFu16i_B_Ui, "BFu16i_B_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_Ul()
{
  {
    init_simple_test("BFu16i_B_Ul");
    static BFu16i_B_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu16i_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_Ul");
    check_field_offset(lv, v2, 2, "BFu16i_B_Ul.v2");
    check_field_offset(lv, v3, 3, "BFu16i_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_B_Ul(Test_BFu16i_B_Ul, "BFu16i_B_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_Us()
{
  {
    init_simple_test("BFu16i_B_Us");
    static BFu16i_B_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_Us");
    check_field_offset(lv, v2, 2, "BFu16i_B_Us.v2");
    check_field_offset(lv, v3, 3, "BFu16i_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_B_Us(Test_BFu16i_B_Us, "BFu16i_B_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_B_Vp()
{
  {
    init_simple_test("BFu16i_B_Vp");
    static BFu16i_B_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu16i_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_B_Vp");
    check_field_offset(lv, v2, 2, "BFu16i_B_Vp.v2");
    check_field_offset(lv, v3, 3, "BFu16i_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_B_Vp(Test_BFu16i_B_Vp, "BFu16i_B_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu15i_B()
{
  {
    init_simple_test("BFu16i_BFu15i_B");
    static BFu16i_BFu15i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu15i_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16i_BFu15i_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16i_BFu15i_B");
    check_field_offset(lv, v3, 4, "BFu16i_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu15i_B(Test_BFu16i_BFu15i_B, "BFu16i_BFu15i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu15ll_B()
{
  {
    init_simple_test("BFu16i_BFu15ll_B");
    static BFu16i_BFu15ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu15ll_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16i_BFu15ll_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16i_BFu15ll_B");
    check_field_offset(lv, v3, 4, "BFu16i_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu15ll_B(Test_BFu16i_BFu15ll_B, "BFu16i_BFu15ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu15s_B()
{
  {
    init_simple_test("BFu16i_BFu15s_B");
    static BFu16i_BFu15s_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16i_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16i_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu16i_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu15s_B(Test_BFu16i_BFu15s_B, "BFu16i_BFu15s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu16i_B()
{
  {
    init_simple_test("BFu16i_BFu16i_B");
    static BFu16i_BFu16i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu16i_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16i_BFu16i_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu16i_B");
    check_field_offset(lv, v3, 4, "BFu16i_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu16i_B(Test_BFu16i_BFu16i_B, "BFu16i_BFu16i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu16ll_B()
{
  {
    init_simple_test("BFu16i_BFu16ll_B");
    static BFu16i_BFu16ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu16ll_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16i_BFu16ll_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu16ll_B");
    check_field_offset(lv, v3, 4, "BFu16i_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu16ll_B(Test_BFu16i_BFu16ll_B, "BFu16i_BFu16ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu16s_B()
{
  {
    init_simple_test("BFu16i_BFu16s_B");
    static BFu16i_BFu16s_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16i_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu16i_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu16s_B(Test_BFu16i_BFu16s_B, "BFu16i_BFu16s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu17i_B()
{
  {
    init_simple_test("BFu16i_BFu17i_B");
    static BFu16i_BFu17i_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu16i_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu17i_B");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu16i_BFu17i_B");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu16i_BFu17i_B");
    check_field_offset(lv, v3, 5, "BFu16i_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu17i_B(Test_BFu16i_BFu17i_B, "BFu16i_BFu17i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu17ll_B()
{
  {
    init_simple_test("BFu16i_BFu17ll_B");
    static BFu16i_BFu17ll_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu16i_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu17ll_B");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu16i_BFu17ll_B");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu16i_BFu17ll_B");
    check_field_offset(lv, v3, 5, "BFu16i_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu17ll_B(Test_BFu16i_BFu17ll_B, "BFu16i_BFu17ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu1c_B()
{
  {
    init_simple_test("BFu16i_BFu1c_B");
    static BFu16i_BFu1c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu1c_B");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16i_BFu1c_B");
    check_field_offset(lv, v3, 3, "BFu16i_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu1c_B(Test_BFu16i_BFu1c_B, "BFu16i_BFu1c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu1i_B()
{
  {
    init_simple_test("BFu16i_BFu1i_B");
    static BFu16i_BFu1i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu1i_B");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16i_BFu1i_B");
    check_field_offset(lv, v3, 3, "BFu16i_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu1i_B(Test_BFu16i_BFu1i_B, "BFu16i_BFu1i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu1ll_B()
{
  {
    init_simple_test("BFu16i_BFu1ll_B");
    static BFu16i_BFu1ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu1ll_B");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16i_BFu1ll_B");
    check_field_offset(lv, v3, 3, "BFu16i_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu1ll_B(Test_BFu16i_BFu1ll_B, "BFu16i_BFu1ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu1s_B()
{
  {
    init_simple_test("BFu16i_BFu1s_B");
    static BFu16i_BFu1s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu1s_B");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16i_BFu1s_B");
    check_field_offset(lv, v3, 3, "BFu16i_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu1s_B(Test_BFu16i_BFu1s_B, "BFu16i_BFu1s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu31i_B()
{
  {
    init_simple_test("BFu16i_BFu31i_B");
    static BFu16i_BFu31i_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu31i_B");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu16i_BFu31i_B");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu16i_BFu31i_B");
    check_field_offset(lv, v3, 6, "BFu16i_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu31i_B(Test_BFu16i_BFu31i_B, "BFu16i_BFu31i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu31ll_B()
{
  {
    init_simple_test("BFu16i_BFu31ll_B");
    static BFu16i_BFu31ll_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu31ll_B");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu16i_BFu31ll_B");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu16i_BFu31ll_B");
    check_field_offset(lv, v3, 6, "BFu16i_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu31ll_B(Test_BFu16i_BFu31ll_B, "BFu16i_BFu31ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu32i_B()
{
  {
    init_simple_test("BFu16i_BFu32i_B");
    static BFu16i_BFu32i_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu32i_B");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu16i_BFu32i_B");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu16i_BFu32i_B");
    check_field_offset(lv, v3, 6, "BFu16i_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu32i_B(Test_BFu16i_BFu32i_B, "BFu16i_BFu32i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu32ll_B()
{
  {
    init_simple_test("BFu16i_BFu32ll_B");
    static BFu16i_BFu32ll_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu32ll_B");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu16i_BFu32ll_B");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu16i_BFu32ll_B");
    check_field_offset(lv, v3, 6, "BFu16i_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu32ll_B(Test_BFu16i_BFu32ll_B, "BFu16i_BFu32ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu33_B()
{
  {
    init_simple_test("BFu16i_BFu33_B");
    static BFu16i_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu33_B");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu16i_BFu33_B");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu16i_BFu33_B");
    check_field_offset(lv, v3, 7, "BFu16i_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu33_B(Test_BFu16i_BFu33_B, "BFu16i_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu7c_B()
{
  {
    init_simple_test("BFu16i_BFu7c_B");
    static BFu16i_BFu7c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu7c_B");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16i_BFu7c_B");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16i_BFu7c_B");
    check_field_offset(lv, v3, 3, "BFu16i_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu7c_B(Test_BFu16i_BFu7c_B, "BFu16i_BFu7c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu7i_B()
{
  {
    init_simple_test("BFu16i_BFu7i_B");
    static BFu16i_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu7i_B");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16i_BFu7i_B");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16i_BFu7i_B");
    check_field_offset(lv, v3, 3, "BFu16i_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu7i_B(Test_BFu16i_BFu7i_B, "BFu16i_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu7ll_B()
{
  {
    init_simple_test("BFu16i_BFu7ll_B");
    static BFu16i_BFu7ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu7ll_B");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16i_BFu7ll_B");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16i_BFu7ll_B");
    check_field_offset(lv, v3, 3, "BFu16i_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu7ll_B(Test_BFu16i_BFu7ll_B, "BFu16i_BFu7ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu7s_B()
{
  {
    init_simple_test("BFu16i_BFu7s_B");
    static BFu16i_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu7s_B");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16i_BFu7s_B");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16i_BFu7s_B");
    check_field_offset(lv, v3, 3, "BFu16i_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu7s_B(Test_BFu16i_BFu7s_B, "BFu16i_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu8c_B()
{
  {
    init_simple_test("BFu16i_BFu8c_B");
    static BFu16i_BFu8c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu8c_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16i_BFu8c_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16i_BFu8c_B");
    check_field_offset(lv, v3, 3, "BFu16i_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu8c_B(Test_BFu16i_BFu8c_B, "BFu16i_BFu8c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu8i_B()
{
  {
    init_simple_test("BFu16i_BFu8i_B");
    static BFu16i_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu8i_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16i_BFu8i_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16i_BFu8i_B");
    check_field_offset(lv, v3, 3, "BFu16i_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu8i_B(Test_BFu16i_BFu8i_B, "BFu16i_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu8ll_B()
{
  {
    init_simple_test("BFu16i_BFu8ll_B");
    static BFu16i_BFu8ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu8ll_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16i_BFu8ll_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16i_BFu8ll_B");
    check_field_offset(lv, v3, 3, "BFu16i_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu8ll_B(Test_BFu16i_BFu8ll_B, "BFu16i_BFu8ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu8s_B()
{
  {
    init_simple_test("BFu16i_BFu8s_B");
    static BFu16i_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu8s_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16i_BFu8s_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16i_BFu8s_B");
    check_field_offset(lv, v3, 3, "BFu16i_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu8s_B(Test_BFu16i_BFu8s_B, "BFu16i_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu9i_B()
{
  {
    init_simple_test("BFu16i_BFu9i_B");
    static BFu16i_BFu9i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu9i_B");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu16i_BFu9i_B");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu16i_BFu9i_B");
    check_field_offset(lv, v3, 4, "BFu16i_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu9i_B(Test_BFu16i_BFu9i_B, "BFu16i_BFu9i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu9ll_B()
{
  {
    init_simple_test("BFu16i_BFu9ll_B");
    static BFu16i_BFu9ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu9ll_B");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu16i_BFu9ll_B");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu16i_BFu9ll_B");
    check_field_offset(lv, v3, 4, "BFu16i_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu9ll_B(Test_BFu16i_BFu9ll_B, "BFu16i_BFu9ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_BFu9s_B()
{
  {
    init_simple_test("BFu16i_BFu9s_B");
    static BFu16i_BFu9s_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu16i_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu16i_BFu9s_B");
    check_field_offset(lv, v3, 4, "BFu16i_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu9s_B(Test_BFu16i_BFu9s_B, "BFu16i_BFu9s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_C_B()
{
  {
    init_simple_test("BFu16i_C_B");
    static BFu16i_C_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_C_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_C_B");
    check_field_offset(lv, v2, 2, "BFu16i_C_B.v2");
    check_field_offset(lv, v3, 3, "BFu16i_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_C_B(Test_BFu16i_C_B, "BFu16i_C_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_D_B()
{
  {
    init_simple_test("BFu16i_D_B");
    static BFu16i_D_B lv;
    check2(sizeof(lv), 11, "sizeof(BFu16i_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_D_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_D_B");
    check_field_offset(lv, v2, 2, "BFu16i_D_B.v2");
    check_field_offset(lv, v3, 10, "BFu16i_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_D_B(Test_BFu16i_D_B, "BFu16i_D_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_F_B()
{
  {
    init_simple_test("BFu16i_F_B");
    static BFu16i_F_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_F_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_F_B");
    check_field_offset(lv, v2, 2, "BFu16i_F_B.v2");
    check_field_offset(lv, v3, 6, "BFu16i_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_F_B(Test_BFu16i_F_B, "BFu16i_F_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_I_B()
{
  {
    init_simple_test("BFu16i_I_B");
    static BFu16i_I_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_I_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_I_B");
    check_field_offset(lv, v2, 2, "BFu16i_I_B.v2");
    check_field_offset(lv, v3, 6, "BFu16i_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_I_B(Test_BFu16i_I_B, "BFu16i_I_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_Ip_B()
{
  {
    init_simple_test("BFu16i_Ip_B");
    static BFu16i_Ip_B lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu16i_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Ip_B");
    check_field_offset(lv, v2, 2, "BFu16i_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu16i_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Ip_B(Test_BFu16i_Ip_B, "BFu16i_Ip_B", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_L_B()
{
  {
    init_simple_test("BFu16i_L_B");
    static BFu16i_L_B lv;
    check2(sizeof(lv), 11, "sizeof(BFu16i_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_L_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_L_B");
    check_field_offset(lv, v2, 2, "BFu16i_L_B.v2");
    check_field_offset(lv, v3, 10, "BFu16i_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_L_B(Test_BFu16i_L_B, "BFu16i_L_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_S_B()
{
  {
    init_simple_test("BFu16i_S_B");
    static BFu16i_S_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_S_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_S_B");
    check_field_offset(lv, v2, 2, "BFu16i_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu16i_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_S_B(Test_BFu16i_S_B, "BFu16i_S_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_Uc_B()
{
  {
    init_simple_test("BFu16i_Uc_B");
    static BFu16i_Uc_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Uc_B");
    check_field_offset(lv, v2, 2, "BFu16i_Uc_B.v2");
    check_field_offset(lv, v3, 3, "BFu16i_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Uc_B(Test_BFu16i_Uc_B, "BFu16i_Uc_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_Ui_B()
{
  {
    init_simple_test("BFu16i_Ui_B");
    static BFu16i_Ui_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu16i_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Ui_B");
    check_field_offset(lv, v2, 2, "BFu16i_Ui_B.v2");
    check_field_offset(lv, v3, 6, "BFu16i_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Ui_B(Test_BFu16i_Ui_B, "BFu16i_Ui_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_Ul_B()
{
  {
    init_simple_test("BFu16i_Ul_B");
    static BFu16i_Ul_B lv;
    check2(sizeof(lv), 11, "sizeof(BFu16i_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Ul_B");
    check_field_offset(lv, v2, 2, "BFu16i_Ul_B.v2");
    check_field_offset(lv, v3, 10, "BFu16i_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Ul_B(Test_BFu16i_Ul_B, "BFu16i_Ul_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_Us_B()
{
  {
    init_simple_test("BFu16i_Us_B");
    static BFu16i_Us_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16i_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Us_B");
    check_field_offset(lv, v2, 2, "BFu16i_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu16i_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Us_B(Test_BFu16i_Us_B, "BFu16i_Us_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16i_Vp_B()
{
  {
    init_simple_test("BFu16i_Vp_B");
    static BFu16i_Vp_B lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu16i_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Vp_B");
    check_field_offset(lv, v2, 2, "BFu16i_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu16i_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Vp_B(Test_BFu16i_Vp_B, "BFu16i_Vp_B", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B()
{
  {
    init_simple_test("BFu16ll_B");
    static BFu16ll_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B");
    check_field_offset(lv, v2, 2, "BFu16ll_B.v2");
  }
}
static Arrange_To_Call_Me vBFu16ll_B(Test_BFu16ll_B, "BFu16ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_B()
{
  {
    init_simple_test("BFu16ll_B_B");
    static BFu16ll_B_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_B");
    check_field_offset(lv, v2, 2, "BFu16ll_B_B.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_B(Test_BFu16ll_B_B, "BFu16ll_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu15i()
{
  {
    init_simple_test("BFu16ll_B_BFu15i");
    static BFu16ll_B_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu15i");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu16ll_B_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu16ll_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu15i(Test_BFu16ll_B_BFu15i, "BFu16ll_B_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu15ll()
{
  {
    init_simple_test("BFu16ll_B_BFu15ll");
    static BFu16ll_B_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu16ll_B_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu16ll_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu15ll(Test_BFu16ll_B_BFu15ll, "BFu16ll_B_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu15s()
{
  {
    init_simple_test("BFu16ll_B_BFu15s");
    static BFu16ll_B_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu15s");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu16ll_B_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu16ll_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu15s(Test_BFu16ll_B_BFu15s, "BFu16ll_B_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu16i()
{
  {
    init_simple_test("BFu16ll_B_BFu16i");
    static BFu16ll_B_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu16i");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu16ll_B_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu16i(Test_BFu16ll_B_BFu16i, "BFu16ll_B_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu16ll()
{
  {
    init_simple_test("BFu16ll_B_BFu16ll");
    static BFu16ll_B_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu16ll_B_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu16ll(Test_BFu16ll_B_BFu16ll, "BFu16ll_B_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu16s()
{
  {
    init_simple_test("BFu16ll_B_BFu16s");
    static BFu16ll_B_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu16s");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu16ll_B_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu16s(Test_BFu16ll_B_BFu16s, "BFu16ll_B_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu17i()
{
  {
    init_simple_test("BFu16ll_B_BFu17i");
    static BFu16ll_B_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(BFu16ll_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu17i");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu16ll_B_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu16ll_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu17i(Test_BFu16ll_B_BFu17i, "BFu16ll_B_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu17ll()
{
  {
    init_simple_test("BFu16ll_B_BFu17ll");
    static BFu16ll_B_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu16ll_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu16ll_B_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu16ll_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu17ll(Test_BFu16ll_B_BFu17ll, "BFu16ll_B_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu1c()
{
  {
    init_simple_test("BFu16ll_B_BFu1c");
    static BFu16ll_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu1c");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16ll_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu1c(Test_BFu16ll_B_BFu1c, "BFu16ll_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu1i()
{
  {
    init_simple_test("BFu16ll_B_BFu1i");
    static BFu16ll_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu1i");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16ll_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu1i(Test_BFu16ll_B_BFu1i, "BFu16ll_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu1ll()
{
  {
    init_simple_test("BFu16ll_B_BFu1ll");
    static BFu16ll_B_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16ll_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu1ll(Test_BFu16ll_B_BFu1ll, "BFu16ll_B_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu1s()
{
  {
    init_simple_test("BFu16ll_B_BFu1s");
    static BFu16ll_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu1s");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16ll_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu1s(Test_BFu16ll_B_BFu1s, "BFu16ll_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu31i()
{
  {
    init_simple_test("BFu16ll_B_BFu31i");
    static BFu16ll_B_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(BFu16ll_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu31i");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu16ll_B_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu16ll_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu31i(Test_BFu16ll_B_BFu31i, "BFu16ll_B_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu31ll()
{
  {
    init_simple_test("BFu16ll_B_BFu31ll");
    static BFu16ll_B_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu16ll_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu16ll_B_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu16ll_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu31ll(Test_BFu16ll_B_BFu31ll, "BFu16ll_B_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu32i()
{
  {
    init_simple_test("BFu16ll_B_BFu32i");
    static BFu16ll_B_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(BFu16ll_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu32i");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu16ll_B_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu16ll_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu32i(Test_BFu16ll_B_BFu32i, "BFu16ll_B_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu32ll()
{
  {
    init_simple_test("BFu16ll_B_BFu32ll");
    static BFu16ll_B_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu16ll_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu16ll_B_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu16ll_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu32ll(Test_BFu16ll_B_BFu32ll, "BFu16ll_B_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu33()
{
  {
    init_simple_test("BFu16ll_B_BFu33");
    static BFu16ll_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu33");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu16ll_B_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu16ll_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu33(Test_BFu16ll_B_BFu33, "BFu16ll_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu7c()
{
  {
    init_simple_test("BFu16ll_B_BFu7c");
    static BFu16ll_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu7c");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16ll_B_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16ll_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu7c(Test_BFu16ll_B_BFu7c, "BFu16ll_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu7i()
{
  {
    init_simple_test("BFu16ll_B_BFu7i");
    static BFu16ll_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu7i");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16ll_B_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16ll_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu7i(Test_BFu16ll_B_BFu7i, "BFu16ll_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu7ll()
{
  {
    init_simple_test("BFu16ll_B_BFu7ll");
    static BFu16ll_B_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16ll_B_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16ll_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu7ll(Test_BFu16ll_B_BFu7ll, "BFu16ll_B_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu7s()
{
  {
    init_simple_test("BFu16ll_B_BFu7s");
    static BFu16ll_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu7s");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16ll_B_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16ll_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu7s(Test_BFu16ll_B_BFu7s, "BFu16ll_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu8c()
{
  {
    init_simple_test("BFu16ll_B_BFu8c");
    static BFu16ll_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu8c");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16ll_B_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16ll_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu8c(Test_BFu16ll_B_BFu8c, "BFu16ll_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu8i()
{
  {
    init_simple_test("BFu16ll_B_BFu8i");
    static BFu16ll_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu8i");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16ll_B_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16ll_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu8i(Test_BFu16ll_B_BFu8i, "BFu16ll_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu8ll()
{
  {
    init_simple_test("BFu16ll_B_BFu8ll");
    static BFu16ll_B_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16ll_B_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16ll_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu8ll(Test_BFu16ll_B_BFu8ll, "BFu16ll_B_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu8s()
{
  {
    init_simple_test("BFu16ll_B_BFu8s");
    static BFu16ll_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu8s");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16ll_B_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16ll_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu8s(Test_BFu16ll_B_BFu8s, "BFu16ll_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu9i()
{
  {
    init_simple_test("BFu16ll_B_BFu9i");
    static BFu16ll_B_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu9i");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu16ll_B_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu16ll_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu9i(Test_BFu16ll_B_BFu9i, "BFu16ll_B_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu9ll()
{
  {
    init_simple_test("BFu16ll_B_BFu9ll");
    static BFu16ll_B_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu16ll_B_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu16ll_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu9ll(Test_BFu16ll_B_BFu9ll, "BFu16ll_B_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_BFu9s()
{
  {
    init_simple_test("BFu16ll_B_BFu9s");
    static BFu16ll_B_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_BFu9s");
    check_field_offset(lv, v2, 2, "BFu16ll_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu16ll_B_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu16ll_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_BFu9s(Test_BFu16ll_B_BFu9s, "BFu16ll_B_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_C()
{
  {
    init_simple_test("BFu16ll_B_C");
    static BFu16ll_B_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_C");
    check_field_offset(lv, v2, 2, "BFu16ll_B_C.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_C(Test_BFu16ll_B_C, "BFu16ll_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_D()
{
  {
    init_simple_test("BFu16ll_B_D");
    static BFu16ll_B_D lv;
    check2(sizeof(lv), 11, "sizeof(BFu16ll_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_D");
    check_field_offset(lv, v2, 2, "BFu16ll_B_D.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_D(Test_BFu16ll_B_D, "BFu16ll_B_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_F()
{
  {
    init_simple_test("BFu16ll_B_F");
    static BFu16ll_B_F lv;
    check2(sizeof(lv), 7, "sizeof(BFu16ll_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_F");
    check_field_offset(lv, v2, 2, "BFu16ll_B_F.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_F(Test_BFu16ll_B_F, "BFu16ll_B_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_I()
{
  {
    init_simple_test("BFu16ll_B_I");
    static BFu16ll_B_I lv;
    check2(sizeof(lv), 7, "sizeof(BFu16ll_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_I");
    check_field_offset(lv, v2, 2, "BFu16ll_B_I.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_I(Test_BFu16ll_B_I, "BFu16ll_B_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_Ip()
{
  {
    init_simple_test("BFu16ll_B_Ip");
    static BFu16ll_B_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu16ll_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_Ip");
    check_field_offset(lv, v2, 2, "BFu16ll_B_Ip.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_Ip(Test_BFu16ll_B_Ip, "BFu16ll_B_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_L()
{
  {
    init_simple_test("BFu16ll_B_L");
    static BFu16ll_B_L lv;
    check2(sizeof(lv), 11, "sizeof(BFu16ll_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_L");
    check_field_offset(lv, v2, 2, "BFu16ll_B_L.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_L(Test_BFu16ll_B_L, "BFu16ll_B_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_S()
{
  {
    init_simple_test("BFu16ll_B_S");
    static BFu16ll_B_S lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_S");
    check_field_offset(lv, v2, 2, "BFu16ll_B_S.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_S(Test_BFu16ll_B_S, "BFu16ll_B_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_Uc()
{
  {
    init_simple_test("BFu16ll_B_Uc");
    static BFu16ll_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_Uc");
    check_field_offset(lv, v2, 2, "BFu16ll_B_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_Uc(Test_BFu16ll_B_Uc, "BFu16ll_B_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_Ui()
{
  {
    init_simple_test("BFu16ll_B_Ui");
    static BFu16ll_B_Ui lv;
    check2(sizeof(lv), 7, "sizeof(BFu16ll_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_Ui");
    check_field_offset(lv, v2, 2, "BFu16ll_B_Ui.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_Ui(Test_BFu16ll_B_Ui, "BFu16ll_B_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_Ul()
{
  {
    init_simple_test("BFu16ll_B_Ul");
    static BFu16ll_B_Ul lv;
    check2(sizeof(lv), 11, "sizeof(BFu16ll_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_Ul");
    check_field_offset(lv, v2, 2, "BFu16ll_B_Ul.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_Ul(Test_BFu16ll_B_Ul, "BFu16ll_B_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_Us()
{
  {
    init_simple_test("BFu16ll_B_Us");
    static BFu16ll_B_Us lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_Us");
    check_field_offset(lv, v2, 2, "BFu16ll_B_Us.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_Us(Test_BFu16ll_B_Us, "BFu16ll_B_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_B_Vp()
{
  {
    init_simple_test("BFu16ll_B_Vp");
    static BFu16ll_B_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu16ll_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_B_Vp");
    check_field_offset(lv, v2, 2, "BFu16ll_B_Vp.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_B_Vp(Test_BFu16ll_B_Vp, "BFu16ll_B_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu15i_B()
{
  {
    init_simple_test("BFu16ll_BFu15i_B");
    static BFu16ll_BFu15i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu15i_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16ll_BFu15i_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16ll_BFu15i_B");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu15i_B(Test_BFu16ll_BFu15i_B, "BFu16ll_BFu15i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu15ll_B()
{
  {
    init_simple_test("BFu16ll_BFu15ll_B");
    static BFu16ll_BFu15ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16ll_BFu15ll_B");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu15ll_B(Test_BFu16ll_BFu15ll_B, "BFu16ll_BFu15ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu15s_B()
{
  {
    init_simple_test("BFu16ll_BFu15s_B");
    static BFu16ll_BFu15s_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16ll_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16ll_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu15s_B(Test_BFu16ll_BFu15s_B, "BFu16ll_BFu15s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu16i_B()
{
  {
    init_simple_test("BFu16ll_BFu16i_B");
    static BFu16ll_BFu16i_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu16i_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16ll_BFu16i_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu16i_B");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu16i_B(Test_BFu16ll_BFu16i_B, "BFu16ll_BFu16i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu16ll_B()
{
  {
    init_simple_test("BFu16ll_BFu16ll_B");
    static BFu16ll_BFu16ll_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu16ll_B");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu16ll_B(Test_BFu16ll_BFu16ll_B, "BFu16ll_BFu16ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu16s_B()
{
  {
    init_simple_test("BFu16ll_BFu16s_B");
    static BFu16ll_BFu16s_B lv;
    check2(sizeof(lv), 5, "sizeof(BFu16ll_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16ll_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu16s_B(Test_BFu16ll_BFu16s_B, "BFu16ll_BFu16s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu17i_B()
{
  {
    init_simple_test("BFu16ll_BFu17i_B");
    static BFu16ll_BFu17i_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu16ll_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu17i_B");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu16ll_BFu17i_B");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu16ll_BFu17i_B");
    check_field_offset(lv, v3, 5, "BFu16ll_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu17i_B(Test_BFu16ll_BFu17i_B, "BFu16ll_BFu17i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu17ll_B()
{
  {
    init_simple_test("BFu16ll_BFu17ll_B");
    static BFu16ll_BFu17ll_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu16ll_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu16ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu16ll_BFu17ll_B");
    check_field_offset(lv, v3, 5, "BFu16ll_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu17ll_B(Test_BFu16ll_BFu17ll_B, "BFu16ll_BFu17ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu1c_B()
{
  {
    init_simple_test("BFu16ll_BFu1c_B");
    static BFu16ll_BFu1c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu1c_B");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16ll_BFu1c_B");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu1c_B(Test_BFu16ll_BFu1c_B, "BFu16ll_BFu1c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu1i_B()
{
  {
    init_simple_test("BFu16ll_BFu1i_B");
    static BFu16ll_BFu1i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu1i_B");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16ll_BFu1i_B");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu1i_B(Test_BFu16ll_BFu1i_B, "BFu16ll_BFu1i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu1ll_B()
{
  {
    init_simple_test("BFu16ll_BFu1ll_B");
    static BFu16ll_BFu1ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu1ll_B");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16ll_BFu1ll_B");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu1ll_B(Test_BFu16ll_BFu1ll_B, "BFu16ll_BFu1ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu1s_B()
{
  {
    init_simple_test("BFu16ll_BFu1s_B");
    static BFu16ll_BFu1s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu1s_B");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16ll_BFu1s_B");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu1s_B(Test_BFu16ll_BFu1s_B, "BFu16ll_BFu1s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu31i_B()
{
  {
    init_simple_test("BFu16ll_BFu31i_B");
    static BFu16ll_BFu31i_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu16ll_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu31i_B");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu16ll_BFu31i_B");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu16ll_BFu31i_B");
    check_field_offset(lv, v3, 6, "BFu16ll_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu31i_B(Test_BFu16ll_BFu31i_B, "BFu16ll_BFu31i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu31ll_B()
{
  {
    init_simple_test("BFu16ll_BFu31ll_B");
    static BFu16ll_BFu31ll_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu16ll_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu16ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu16ll_BFu31ll_B");
    check_field_offset(lv, v3, 6, "BFu16ll_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu31ll_B(Test_BFu16ll_BFu31ll_B, "BFu16ll_BFu31ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu32i_B()
{
  {
    init_simple_test("BFu16ll_BFu32i_B");
    static BFu16ll_BFu32i_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu16ll_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu32i_B");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu16ll_BFu32i_B");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu16ll_BFu32i_B");
    check_field_offset(lv, v3, 6, "BFu16ll_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu32i_B(Test_BFu16ll_BFu32i_B, "BFu16ll_BFu32i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu32ll_B()
{
  {
    init_simple_test("BFu16ll_BFu32ll_B");
    static BFu16ll_BFu32ll_B lv;
    check2(sizeof(lv), 7, "sizeof(BFu16ll_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu16ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu16ll_BFu32ll_B");
    check_field_offset(lv, v3, 6, "BFu16ll_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu32ll_B(Test_BFu16ll_BFu32ll_B, "BFu16ll_BFu32ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu33_B()
{
  {
    init_simple_test("BFu16ll_BFu33_B");
    static BFu16ll_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu33_B");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu16ll_BFu33_B");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu16ll_BFu33_B");
    check_field_offset(lv, v3, 7, "BFu16ll_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu33_B(Test_BFu16ll_BFu33_B, "BFu16ll_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu7c_B()
{
  {
    init_simple_test("BFu16ll_BFu7c_B");
    static BFu16ll_BFu7c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu7c_B");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16ll_BFu7c_B");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16ll_BFu7c_B");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu7c_B(Test_BFu16ll_BFu7c_B, "BFu16ll_BFu7c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu7i_B()
{
  {
    init_simple_test("BFu16ll_BFu7i_B");
    static BFu16ll_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu7i_B");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16ll_BFu7i_B");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16ll_BFu7i_B");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu7i_B(Test_BFu16ll_BFu7i_B, "BFu16ll_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu7ll_B()
{
  {
    init_simple_test("BFu16ll_BFu7ll_B");
    static BFu16ll_BFu7ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16ll_BFu7ll_B");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu7ll_B(Test_BFu16ll_BFu7ll_B, "BFu16ll_BFu7ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu7s_B()
{
  {
    init_simple_test("BFu16ll_BFu7s_B");
    static BFu16ll_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu7s_B");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16ll_BFu7s_B");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16ll_BFu7s_B");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu7s_B(Test_BFu16ll_BFu7s_B, "BFu16ll_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu8c_B()
{
  {
    init_simple_test("BFu16ll_BFu8c_B");
    static BFu16ll_BFu8c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu8c_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16ll_BFu8c_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16ll_BFu8c_B");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu8c_B(Test_BFu16ll_BFu8c_B, "BFu16ll_BFu8c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu8i_B()
{
  {
    init_simple_test("BFu16ll_BFu8i_B");
    static BFu16ll_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu8i_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16ll_BFu8i_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16ll_BFu8i_B");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu8i_B(Test_BFu16ll_BFu8i_B, "BFu16ll_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu8ll_B()
{
  {
    init_simple_test("BFu16ll_BFu8ll_B");
    static BFu16ll_BFu8ll_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16ll_BFu8ll_B");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu8ll_B(Test_BFu16ll_BFu8ll_B, "BFu16ll_BFu8ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu16ll_BFu8s_B()
{
  {
    init_simple_test("BFu16ll_BFu8s_B");
    static BFu16ll_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu16ll_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu8s_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16ll_BFu8s_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16ll_BFu8s_B");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu8s_B(Test_BFu16ll_BFu8s_B, "BFu16ll_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus