// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
struct __attribute__((packed)) aBFu32ll_BFu16s_B { unsigned long long v1:32; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu17i_B { unsigned long long v1:32; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu17ll_B { unsigned long long v1:32; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu1c_B { unsigned long long v1:32; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu1i_B { unsigned long long v1:32; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu1ll_B { unsigned long long v1:32; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu1s_B { unsigned long long v1:32; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu31i_B { unsigned long long v1:32; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu31ll_B { unsigned long long v1:32; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu32i_B { unsigned long long v1:32; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu32ll_B { unsigned long long v1:32; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu33_B { unsigned long long v1:32; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu7c_B { unsigned long long v1:32; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu7i_B { unsigned long long v1:32; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu7ll_B { unsigned long long v1:32; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu7s_B { unsigned long long v1:32; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu8c_B { unsigned long long v1:32; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu8i_B { unsigned long long v1:32; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu8ll_B { unsigned long long v1:32; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu8s_B { unsigned long long v1:32; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu9i_B { unsigned long long v1:32; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu9ll_B { unsigned long long v1:32; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu9s_B { unsigned long long v1:32; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu32ll_C_B { unsigned long long v1:32; char v2; bool v3; };
struct __attribute__((packed)) aBFu32ll_D_B { unsigned long long v1:32; double v2; bool v3; };
struct __attribute__((packed)) aBFu32ll_F_B { unsigned long long v1:32; float v2; bool v3; };
struct __attribute__((packed)) aBFu32ll_I_B { unsigned long long v1:32; int v2; bool v3; };
struct __attribute__((packed)) aBFu32ll_Ip_B { unsigned long long v1:32; int * v2; bool v3; };
struct __attribute__((packed)) aBFu32ll_L_B { unsigned long long v1:32; long long v2; bool v3; };
struct __attribute__((packed)) aBFu32ll_S_B { unsigned long long v1:32; short v2; bool v3; };
struct __attribute__((packed)) aBFu32ll_Uc_B { unsigned long long v1:32; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu32ll_Ui_B { unsigned long long v1:32; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu32ll_Ul_B { unsigned long long v1:32; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu32ll_Us_B { unsigned long long v1:32; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu32ll_Vp_B { unsigned long long v1:32; void * v2; bool v3; };
struct __attribute__((packed)) aBFu33_B { unsigned long long v1:33; bool v2; };
struct __attribute__((packed)) aBFu33_B_B { unsigned long long v1:33; bool v2; bool v3; };
struct __attribute__((packed)) aBFu33_B_BFu15i { unsigned long long v1:33; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu33_B_BFu15ll { unsigned long long v1:33; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu33_B_BFu15s { unsigned long long v1:33; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu33_B_BFu16i { unsigned long long v1:33; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu33_B_BFu16ll { unsigned long long v1:33; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu33_B_BFu16s { unsigned long long v1:33; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu33_B_BFu17i { unsigned long long v1:33; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu33_B_BFu17ll { unsigned long long v1:33; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu33_B_BFu1c { unsigned long long v1:33; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu33_B_BFu1i { unsigned long long v1:33; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu33_B_BFu1ll { unsigned long long v1:33; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu33_B_BFu1s { unsigned long long v1:33; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu33_B_BFu31i { unsigned long long v1:33; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu33_B_BFu31ll { unsigned long long v1:33; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu33_B_BFu32i { unsigned long long v1:33; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu33_B_BFu32ll { unsigned long long v1:33; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu33_B_BFu33 { unsigned long long v1:33; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu33_B_BFu7c { unsigned long long v1:33; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu33_B_BFu7i { unsigned long long v1:33; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu33_B_BFu7ll { unsigned long long v1:33; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu33_B_BFu7s { unsigned long long v1:33; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu33_B_BFu8c { unsigned long long v1:33; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu33_B_BFu8i { unsigned long long v1:33; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu33_B_BFu8ll { unsigned long long v1:33; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu33_B_BFu8s { unsigned long long v1:33; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu33_B_BFu9i { unsigned long long v1:33; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu33_B_BFu9ll { unsigned long long v1:33; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu33_B_BFu9s { unsigned long long v1:33; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu33_B_C { unsigned long long v1:33; bool v2; char v3; };
struct __attribute__((packed)) aBFu33_B_D { unsigned long long v1:33; bool v2; double v3; };
struct __attribute__((packed)) aBFu33_B_F { unsigned long long v1:33; bool v2; float v3; };
struct __attribute__((packed)) aBFu33_B_I { unsigned long long v1:33; bool v2; int v3; };
struct __attribute__((packed)) aBFu33_B_Ip { unsigned long long v1:33; bool v2; int * v3; };
struct __attribute__((packed)) aBFu33_B_L { unsigned long long v1:33; bool v2; long long v3; };
struct __attribute__((packed)) aBFu33_B_S { unsigned long long v1:33; bool v2; short v3; };
struct __attribute__((packed)) aBFu33_B_Uc { unsigned long long v1:33; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu33_B_Ui { unsigned long long v1:33; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu33_B_Ul { unsigned long long v1:33; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu33_B_Us { unsigned long long v1:33; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu33_B_Vp { unsigned long long v1:33; bool v2; void * v3; };
struct __attribute__((packed)) aBFu33_BFu15i_B { unsigned long long v1:33; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu33_BFu15ll_B { unsigned long long v1:33; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu33_BFu15s_B { unsigned long long v1:33; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu33_BFu16i_B { unsigned long long v1:33; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu33_BFu16ll_B { unsigned long long v1:33; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu33_BFu16s_B { unsigned long long v1:33; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu33_BFu17i_B { unsigned long long v1:33; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu33_BFu17ll_B { unsigned long long v1:33; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu33_BFu1c_B { unsigned long long v1:33; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu33_BFu1i_B { unsigned long long v1:33; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu33_BFu1ll_B { unsigned long long v1:33; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu33_BFu1s_B { unsigned long long v1:33; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu33_BFu31i_B { unsigned long long v1:33; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu33_BFu31ll_B { unsigned long long v1:33; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu33_BFu32i_B { unsigned long long v1:33; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu33_BFu32ll_B { unsigned long long v1:33; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu33_BFu33_B { unsigned long long v1:33; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu33_BFu7c_B { unsigned long long v1:33; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu33_BFu7i_B { unsigned long long v1:33; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu33_BFu7ll_B { unsigned long long v1:33; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu33_BFu7s_B { unsigned long long v1:33; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu33_BFu8c_B { unsigned long long v1:33; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu33_BFu8i_B { unsigned long long v1:33; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu33_BFu8ll_B { unsigned long long v1:33; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu33_BFu8s_B { unsigned long long v1:33; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu33_BFu9i_B { unsigned long long v1:33; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu33_BFu9ll_B { unsigned long long v1:33; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu33_BFu9s_B { unsigned long long v1:33; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu33_C_B { unsigned long long v1:33; char v2; bool v3; };
struct __attribute__((packed)) aBFu33_D_B { unsigned long long v1:33; double v2; bool v3; };
struct __attribute__((packed)) aBFu33_F_B { unsigned long long v1:33; float v2; bool v3; };
struct __attribute__((packed)) aBFu33_I_B { unsigned long long v1:33; int v2; bool v3; };
struct __attribute__((packed)) aBFu33_Ip_B { unsigned long long v1:33; int * v2; bool v3; };
struct __attribute__((packed)) aBFu33_L_B { unsigned long long v1:33; long long v2; bool v3; };
struct __attribute__((packed)) aBFu33_S_B { unsigned long long v1:33; short v2; bool v3; };
struct __attribute__((packed)) aBFu33_Uc_B { unsigned long long v1:33; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu33_Ui_B { unsigned long long v1:33; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu33_Ul_B { unsigned long long v1:33; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu33_Us_B { unsigned long long v1:33; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu33_Vp_B { unsigned long long v1:33; void * v2; bool v3; };
struct __attribute__((packed)) aBFu7c_B { unsigned char v1:7; bool v2; };
struct __attribute__((packed)) aBFu7c_B_B { unsigned char v1:7; bool v2; bool v3; };
struct __attribute__((packed)) aBFu7c_B_BFu15i { unsigned char v1:7; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu7c_B_BFu15ll { unsigned char v1:7; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu7c_B_BFu15s { unsigned char v1:7; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu7c_B_BFu16i { unsigned char v1:7; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu7c_B_BFu16ll { unsigned char v1:7; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu7c_B_BFu16s { unsigned char v1:7; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu7c_B_BFu17i { unsigned char v1:7; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu7c_B_BFu17ll { unsigned char v1:7; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu7c_B_BFu1c { unsigned char v1:7; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu7c_B_BFu1i { unsigned char v1:7; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu7c_B_BFu1ll { unsigned char v1:7; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu7c_B_BFu1s { unsigned char v1:7; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu7c_B_BFu31i { unsigned char v1:7; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu7c_B_BFu31ll { unsigned char v1:7; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu7c_B_BFu32i { unsigned char v1:7; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu7c_B_BFu32ll { unsigned char v1:7; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu7c_B_BFu33 { unsigned char v1:7; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu7c_B_BFu7c { unsigned char v1:7; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu7c_B_BFu7i { unsigned char v1:7; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu7c_B_BFu7ll { unsigned char v1:7; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu7c_B_BFu7s { unsigned char v1:7; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu7c_B_BFu8c { unsigned char v1:7; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu7c_B_BFu8i { unsigned char v1:7; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu7c_B_BFu8ll { unsigned char v1:7; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu7c_B_BFu8s { unsigned char v1:7; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu7c_B_BFu9i { unsigned char v1:7; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu7c_B_BFu9ll { unsigned char v1:7; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu7c_B_BFu9s { unsigned char v1:7; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu7c_B_C { unsigned char v1:7; bool v2; char v3; };
struct __attribute__((packed)) aBFu7c_B_D { unsigned char v1:7; bool v2; double v3; };
struct __attribute__((packed)) aBFu7c_B_F { unsigned char v1:7; bool v2; float v3; };
struct __attribute__((packed)) aBFu7c_B_I { unsigned char v1:7; bool v2; int v3; };
struct __attribute__((packed)) aBFu7c_B_Ip { unsigned char v1:7; bool v2; int * v3; };
struct __attribute__((packed)) aBFu7c_B_L { unsigned char v1:7; bool v2; long long v3; };
struct __attribute__((packed)) aBFu7c_B_S { unsigned char v1:7; bool v2; short v3; };
struct __attribute__((packed)) aBFu7c_B_Uc { unsigned char v1:7; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu7c_B_Ui { unsigned char v1:7; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu7c_B_Ul { unsigned char v1:7; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu7c_B_Us { unsigned char v1:7; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu7c_B_Vp { unsigned char v1:7; bool v2; void * v3; };
struct __attribute__((packed)) aBFu7c_BFu15i_B { unsigned char v1:7; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu15ll_B { unsigned char v1:7; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu15s_B { unsigned char v1:7; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu16i_B { unsigned char v1:7; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu16ll_B { unsigned char v1:7; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu16s_B { unsigned char v1:7; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu17i_B { unsigned char v1:7; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu17ll_B { unsigned char v1:7; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu1c_B { unsigned char v1:7; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu1i_B { unsigned char v1:7; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu1ll_B { unsigned char v1:7; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu1s_B { unsigned char v1:7; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu31i_B { unsigned char v1:7; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu31ll_B { unsigned char v1:7; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu32i_B { unsigned char v1:7; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu32ll_B { unsigned char v1:7; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu33_B { unsigned char v1:7; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu7c_B { unsigned char v1:7; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu7i_B { unsigned char v1:7; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu7ll_B { unsigned char v1:7; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu7s_B { unsigned char v1:7; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu8c_B { unsigned char v1:7; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu8i_B { unsigned char v1:7; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu8ll_B { unsigned char v1:7; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu8s_B { unsigned char v1:7; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu9i_B { unsigned char v1:7; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu9ll_B { unsigned char v1:7; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu7c_BFu9s_B { unsigned char v1:7; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu7c_C_B { unsigned char v1:7; char v2; bool v3; };
struct __attribute__((packed)) aBFu7c_D_B { unsigned char v1:7; double v2; bool v3; };
struct __attribute__((packed)) aBFu7c_F_B { unsigned char v1:7; float v2; bool v3; };
struct __attribute__((packed)) aBFu7c_I_B { unsigned char v1:7; int v2; bool v3; };
struct __attribute__((packed)) aBFu7c_Ip_B { unsigned char v1:7; int * v2; bool v3; };
struct __attribute__((packed)) aBFu7c_L_B { unsigned char v1:7; long long v2; bool v3; };
struct __attribute__((packed)) aBFu7c_S_B { unsigned char v1:7; short v2; bool v3; };
struct __attribute__((packed)) aBFu7c_Uc_B { unsigned char v1:7; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu7c_Ui_B { unsigned char v1:7; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu7c_Ul_B { unsigned char v1:7; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu7c_Us_B { unsigned char v1:7; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu7c_Vp_B { unsigned char v1:7; void * v2; bool v3; };
struct __attribute__((packed)) aBFu7i_B { unsigned int v1:7; bool v2; };
struct __attribute__((packed)) aBFu7i_B_B { unsigned int v1:7; bool v2; bool v3; };
struct __attribute__((packed)) aBFu7i_B_BFu15i { unsigned int v1:7; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu7i_B_BFu15ll { unsigned int v1:7; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu7i_B_BFu15s { unsigned int v1:7; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu7i_B_BFu16i { unsigned int v1:7; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu7i_B_BFu16ll { unsigned int v1:7; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu7i_B_BFu16s { unsigned int v1:7; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu7i_B_BFu17i { unsigned int v1:7; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu7i_B_BFu17ll { unsigned int v1:7; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu7i_B_BFu1c { unsigned int v1:7; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu7i_B_BFu1i { unsigned int v1:7; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu7i_B_BFu1ll { unsigned int v1:7; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu7i_B_BFu1s { unsigned int v1:7; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu7i_B_BFu31i { unsigned int v1:7; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu7i_B_BFu31ll { unsigned int v1:7; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu7i_B_BFu32i { unsigned int v1:7; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu7i_B_BFu32ll { unsigned int v1:7; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu7i_B_BFu33 { unsigned int v1:7; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu7i_B_BFu7c { unsigned int v1:7; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu7i_B_BFu7i { unsigned int v1:7; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu7i_B_BFu7ll { unsigned int v1:7; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu7i_B_BFu7s { unsigned int v1:7; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu7i_B_BFu8c { unsigned int v1:7; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu7i_B_BFu8i { unsigned int v1:7; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu7i_B_BFu8ll { unsigned int v1:7; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu7i_B_BFu8s { unsigned int v1:7; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu7i_B_BFu9i { unsigned int v1:7; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu7i_B_BFu9ll { unsigned int v1:7; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu7i_B_BFu9s { unsigned int v1:7; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu7i_B_C { unsigned int v1:7; bool v2; char v3; };
struct __attribute__((packed)) aBFu7i_B_D { unsigned int v1:7; bool v2; double v3; };
struct __attribute__((packed)) aBFu7i_B_F { unsigned int v1:7; bool v2; float v3; };
struct __attribute__((packed)) aBFu7i_B_I { unsigned int v1:7; bool v2; int v3; };
struct __attribute__((packed)) aBFu7i_B_Ip { unsigned int v1:7; bool v2; int * v3; };
struct __attribute__((packed)) aBFu7i_B_L { unsigned int v1:7; bool v2; long long v3; };
struct __attribute__((packed)) aBFu7i_B_S { unsigned int v1:7; bool v2; short v3; };
struct __attribute__((packed)) aBFu7i_B_Uc { unsigned int v1:7; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu7i_B_Ui { unsigned int v1:7; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu7i_B_Ul { unsigned int v1:7; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu7i_B_Us { unsigned int v1:7; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu7i_B_Vp { unsigned int v1:7; bool v2; void * v3; };
struct __attribute__((packed)) aBFu7i_BFu15i_B { unsigned int v1:7; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu15ll_B { unsigned int v1:7; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu15s_B { unsigned int v1:7; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu16i_B { unsigned int v1:7; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu16ll_B { unsigned int v1:7; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu16s_B { unsigned int v1:7; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu17i_B { unsigned int v1:7; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu17ll_B { unsigned int v1:7; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu1c_B { unsigned int v1:7; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu1i_B { unsigned int v1:7; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu1ll_B { unsigned int v1:7; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu1s_B { unsigned int v1:7; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu31i_B { unsigned int v1:7; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu31ll_B { unsigned int v1:7; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu32i_B { unsigned int v1:7; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu32ll_B { unsigned int v1:7; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu33_B { unsigned int v1:7; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu7c_B { unsigned int v1:7; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu7i_B { unsigned int v1:7; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu7ll_B { unsigned int v1:7; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu7s_B { unsigned int v1:7; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu8c_B { unsigned int v1:7; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu8i_B { unsigned int v1:7; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu8ll_B { unsigned int v1:7; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu8s_B { unsigned int v1:7; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu9i_B { unsigned int v1:7; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu9ll_B { unsigned int v1:7; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu7i_BFu9s_B { unsigned int v1:7; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu7i_C_B { unsigned int v1:7; char v2; bool v3; };
struct __attribute__((packed)) aBFu7i_D_B { unsigned int v1:7; double v2; bool v3; };
struct __attribute__((packed)) aBFu7i_F_B { unsigned int v1:7; float v2; bool v3; };
struct __attribute__((packed)) aBFu7i_I_B { unsigned int v1:7; int v2; bool v3; };
struct __attribute__((packed)) aBFu7i_Ip_B { unsigned int v1:7; int * v2; bool v3; };
struct __attribute__((packed)) aBFu7i_L_B { unsigned int v1:7; long long v2; bool v3; };
struct __attribute__((packed)) aBFu7i_S_B { unsigned int v1:7; short v2; bool v3; };
struct __attribute__((packed)) aBFu7i_Uc_B { unsigned int v1:7; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu7i_Ui_B { unsigned int v1:7; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu7i_Ul_B { unsigned int v1:7; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu7i_Us_B { unsigned int v1:7; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu7i_Vp_B { unsigned int v1:7; void * v2; bool v3; };
struct __attribute__((packed)) aBFu7ll_B { unsigned long long v1:7; bool v2; };
struct __attribute__((packed)) aBFu7ll_B_B { unsigned long long v1:7; bool v2; bool v3; };
struct __attribute__((packed)) aBFu7ll_B_BFu15i { unsigned long long v1:7; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu7ll_B_BFu15ll { unsigned long long v1:7; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu7ll_B_BFu15s { unsigned long long v1:7; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu7ll_B_BFu16i { unsigned long long v1:7; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu7ll_B_BFu16ll { unsigned long long v1:7; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu7ll_B_BFu16s { unsigned long long v1:7; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu7ll_B_BFu17i { unsigned long long v1:7; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu7ll_B_BFu17ll { unsigned long long v1:7; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu7ll_B_BFu1c { unsigned long long v1:7; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu7ll_B_BFu1i { unsigned long long v1:7; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu7ll_B_BFu1ll { unsigned long long v1:7; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu7ll_B_BFu1s { unsigned long long v1:7; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu7ll_B_BFu31i { unsigned long long v1:7; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu7ll_B_BFu31ll { unsigned long long v1:7; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu7ll_B_BFu32i { unsigned long long v1:7; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu7ll_B_BFu32ll { unsigned long long v1:7; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu7ll_B_BFu33 { unsigned long long v1:7; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu7ll_B_BFu7c { unsigned long long v1:7; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu7ll_B_BFu7i { unsigned long long v1:7; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu7ll_B_BFu7ll { unsigned long long v1:7; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu7ll_B_BFu7s { unsigned long long v1:7; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu7ll_B_BFu8c { unsigned long long v1:7; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu7ll_B_BFu8i { unsigned long long v1:7; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu7ll_B_BFu8ll { unsigned long long v1:7; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu7ll_B_BFu8s { unsigned long long v1:7; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu7ll_B_BFu9i { unsigned long long v1:7; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu7ll_B_BFu9ll { unsigned long long v1:7; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu7ll_B_BFu9s { unsigned long long v1:7; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu7ll_B_C { unsigned long long v1:7; bool v2; char v3; };
struct __attribute__((packed)) aBFu7ll_B_D { unsigned long long v1:7; bool v2; double v3; };
struct __attribute__((packed)) aBFu7ll_B_F { unsigned long long v1:7; bool v2; float v3; };
struct __attribute__((packed)) aBFu7ll_B_I { unsigned long long v1:7; bool v2; int v3; };
struct __attribute__((packed)) aBFu7ll_B_Ip { unsigned long long v1:7; bool v2; int * v3; };
struct __attribute__((packed)) aBFu7ll_B_L { unsigned long long v1:7; bool v2; long long v3; };
struct __attribute__((packed)) aBFu7ll_B_S { unsigned long long v1:7; bool v2; short v3; };
struct __attribute__((packed)) aBFu7ll_B_Uc { unsigned long long v1:7; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu7ll_B_Ui { unsigned long long v1:7; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu7ll_B_Ul { unsigned long long v1:7; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu7ll_B_Us { unsigned long long v1:7; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu7ll_B_Vp { unsigned long long v1:7; bool v2; void * v3; };
struct __attribute__((packed)) aBFu7ll_BFu15i_B { unsigned long long v1:7; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu15ll_B { unsigned long long v1:7; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu15s_B { unsigned long long v1:7; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu16i_B { unsigned long long v1:7; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu16ll_B { unsigned long long v1:7; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu16s_B { unsigned long long v1:7; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu17i_B { unsigned long long v1:7; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu17ll_B { unsigned long long v1:7; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu1c_B { unsigned long long v1:7; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu1i_B { unsigned long long v1:7; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu1ll_B { unsigned long long v1:7; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu1s_B { unsigned long long v1:7; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu31i_B { unsigned long long v1:7; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu31ll_B { unsigned long long v1:7; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu32i_B { unsigned long long v1:7; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu32ll_B { unsigned long long v1:7; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu33_B { unsigned long long v1:7; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu7c_B { unsigned long long v1:7; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu7i_B { unsigned long long v1:7; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu7ll_B { unsigned long long v1:7; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu7s_B { unsigned long long v1:7; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu8c_B { unsigned long long v1:7; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu8i_B { unsigned long long v1:7; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu8ll_B { unsigned long long v1:7; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu8s_B { unsigned long long v1:7; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu9i_B { unsigned long long v1:7; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu9ll_B { unsigned long long v1:7; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu7ll_BFu9s_B { unsigned long long v1:7; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu7ll_C_B { unsigned long long v1:7; char v2; bool v3; };
struct __attribute__((packed)) aBFu7ll_D_B { unsigned long long v1:7; double v2; bool v3; };
struct __attribute__((packed)) aBFu7ll_F_B { unsigned long long v1:7; float v2; bool v3; };
struct __attribute__((packed)) aBFu7ll_I_B { unsigned long long v1:7; int v2; bool v3; };
struct __attribute__((packed)) aBFu7ll_Ip_B { unsigned long long v1:7; int * v2; bool v3; };
struct __attribute__((packed)) aBFu7ll_L_B { unsigned long long v1:7; long long v2; bool v3; };
struct __attribute__((packed)) aBFu7ll_S_B { unsigned long long v1:7; short v2; bool v3; };
struct __attribute__((packed)) aBFu7ll_Uc_B { unsigned long long v1:7; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu7ll_Ui_B { unsigned long long v1:7; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu7ll_Ul_B { unsigned long long v1:7; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu7ll_Us_B { unsigned long long v1:7; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu7ll_Vp_B { unsigned long long v1:7; void * v2; bool v3; };
struct __attribute__((packed)) aBFu7s_B { unsigned short v1:7; bool v2; };
struct __attribute__((packed)) aBFu7s_B_B { unsigned short v1:7; bool v2; bool v3; };
struct __attribute__((packed)) aBFu7s_B_BFu15i { unsigned short v1:7; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu7s_B_BFu15ll { unsigned short v1:7; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu7s_B_BFu15s { unsigned short v1:7; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu7s_B_BFu16i { unsigned short v1:7; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu7s_B_BFu16ll { unsigned short v1:7; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu7s_B_BFu16s { unsigned short v1:7; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu7s_B_BFu17i { unsigned short v1:7; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu7s_B_BFu17ll { unsigned short v1:7; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu7s_B_BFu1c { unsigned short v1:7; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu7s_B_BFu1i { unsigned short v1:7; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu7s_B_BFu1ll { unsigned short v1:7; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu7s_B_BFu1s { unsigned short v1:7; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu7s_B_BFu31i { unsigned short v1:7; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu7s_B_BFu31ll { unsigned short v1:7; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu7s_B_BFu32i { unsigned short v1:7; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu7s_B_BFu32ll { unsigned short v1:7; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu7s_B_BFu33 { unsigned short v1:7; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu7s_B_BFu7c { unsigned short v1:7; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu7s_B_BFu7i { unsigned short v1:7; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu7s_B_BFu7ll { unsigned short v1:7; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu7s_B_BFu7s { unsigned short v1:7; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu7s_B_BFu8c { unsigned short v1:7; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu7s_B_BFu8i { unsigned short v1:7; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu7s_B_BFu8ll { unsigned short v1:7; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu7s_B_BFu8s { unsigned short v1:7; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu7s_B_BFu9i { unsigned short v1:7; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu7s_B_BFu9ll { unsigned short v1:7; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu7s_B_BFu9s { unsigned short v1:7; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu7s_B_C { unsigned short v1:7; bool v2; char v3; };
struct __attribute__((packed)) aBFu7s_B_D { unsigned short v1:7; bool v2; double v3; };
struct __attribute__((packed)) aBFu7s_B_F { unsigned short v1:7; bool v2; float v3; };
struct __attribute__((packed)) aBFu7s_B_I { unsigned short v1:7; bool v2; int v3; };
struct __attribute__((packed)) aBFu7s_B_Ip { unsigned short v1:7; bool v2; int * v3; };
struct __attribute__((packed)) aBFu7s_B_L { unsigned short v1:7; bool v2; long long v3; };
struct __attribute__((packed)) aBFu7s_B_S { unsigned short v1:7; bool v2; short v3; };
struct __attribute__((packed)) aBFu7s_B_Uc { unsigned short v1:7; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu7s_B_Ui { unsigned short v1:7; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu7s_B_Ul { unsigned short v1:7; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu7s_B_Us { unsigned short v1:7; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu7s_B_Vp { unsigned short v1:7; bool v2; void * v3; };
struct __attribute__((packed)) aBFu7s_BFu15i_B { unsigned short v1:7; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu15ll_B { unsigned short v1:7; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu15s_B { unsigned short v1:7; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu16i_B { unsigned short v1:7; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu16ll_B { unsigned short v1:7; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu16s_B { unsigned short v1:7; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu17i_B { unsigned short v1:7; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu17ll_B { unsigned short v1:7; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu1c_B { unsigned short v1:7; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu1i_B { unsigned short v1:7; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu1ll_B { unsigned short v1:7; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu1s_B { unsigned short v1:7; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu31i_B { unsigned short v1:7; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu31ll_B { unsigned short v1:7; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu32i_B { unsigned short v1:7; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu32ll_B { unsigned short v1:7; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu33_B { unsigned short v1:7; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu7c_B { unsigned short v1:7; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu7i_B { unsigned short v1:7; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu7ll_B { unsigned short v1:7; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu7s_B { unsigned short v1:7; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu8c_B { unsigned short v1:7; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu8i_B { unsigned short v1:7; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu8ll_B { unsigned short v1:7; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu8s_B { unsigned short v1:7; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu9i_B { unsigned short v1:7; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu9ll_B { unsigned short v1:7; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu7s_BFu9s_B { unsigned short v1:7; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu7s_C_B { unsigned short v1:7; char v2; bool v3; };
struct __attribute__((packed)) aBFu7s_D_B { unsigned short v1:7; double v2; bool v3; };
struct __attribute__((packed)) aBFu7s_F_B { unsigned short v1:7; float v2; bool v3; };
struct __attribute__((packed)) aBFu7s_I_B { unsigned short v1:7; int v2; bool v3; };
struct __attribute__((packed)) aBFu7s_Ip_B { unsigned short v1:7; int * v2; bool v3; };
struct __attribute__((packed)) aBFu7s_L_B { unsigned short v1:7; long long v2; bool v3; };
struct __attribute__((packed)) aBFu7s_S_B { unsigned short v1:7; short v2; bool v3; };
struct __attribute__((packed)) aBFu7s_Uc_B { unsigned short v1:7; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu7s_Ui_B { unsigned short v1:7; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu7s_Ul_B { unsigned short v1:7; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu7s_Us_B { unsigned short v1:7; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu7s_Vp_B { unsigned short v1:7; void * v2; bool v3; };
struct __attribute__((packed)) aBFu8c_B { unsigned char v1:8; bool v2; };
struct __attribute__((packed)) aBFu8c_B_B { unsigned char v1:8; bool v2; bool v3; };
struct __attribute__((packed)) aBFu8c_B_BFu15i { unsigned char v1:8; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8c_B_BFu15ll { unsigned char v1:8; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8c_B_BFu15s { unsigned char v1:8; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8c_B_BFu16i { unsigned char v1:8; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8c_B_BFu16ll { unsigned char v1:8; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8c_B_BFu16s { unsigned char v1:8; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8c_B_BFu17i { unsigned char v1:8; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8c_B_BFu17ll { unsigned char v1:8; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8c_B_BFu1c { unsigned char v1:8; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8c_B_BFu1i { unsigned char v1:8; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8c_B_BFu1ll { unsigned char v1:8; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8c_B_BFu1s { unsigned char v1:8; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8c_B_BFu31i { unsigned char v1:8; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8c_B_BFu31ll { unsigned char v1:8; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8c_B_BFu32i { unsigned char v1:8; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8c_B_BFu32ll { unsigned char v1:8; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8c_B_BFu33 { unsigned char v1:8; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8c_B_BFu7c { unsigned char v1:8; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8c_B_BFu7i { unsigned char v1:8; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8c_B_BFu7ll { unsigned char v1:8; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8c_B_BFu7s { unsigned char v1:8; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8c_B_BFu8c { unsigned char v1:8; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8c_B_BFu8i { unsigned char v1:8; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8c_B_BFu8ll { unsigned char v1:8; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8c_B_BFu8s { unsigned char v1:8; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8c_B_BFu9i { unsigned char v1:8; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8c_B_BFu9ll { unsigned char v1:8; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8c_B_BFu9s { unsigned char v1:8; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8c_B_C { unsigned char v1:8; bool v2; char v3; };
struct __attribute__((packed)) aBFu8c_B_D { unsigned char v1:8; bool v2; double v3; };
struct __attribute__((packed)) aBFu8c_B_F { unsigned char v1:8; bool v2; float v3; };
struct __attribute__((packed)) aBFu8c_B_I { unsigned char v1:8; bool v2; int v3; };
struct __attribute__((packed)) aBFu8c_B_Ip { unsigned char v1:8; bool v2; int * v3; };
struct __attribute__((packed)) aBFu8c_B_L { unsigned char v1:8; bool v2; long long v3; };
struct __attribute__((packed)) aBFu8c_B_S { unsigned char v1:8; bool v2; short v3; };
struct __attribute__((packed)) aBFu8c_B_Uc { unsigned char v1:8; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8c_B_Ui { unsigned char v1:8; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8c_B_Ul { unsigned char v1:8; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8c_B_Us { unsigned char v1:8; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8c_B_Vp { unsigned char v1:8; bool v2; void * v3; };
struct __attribute__((packed)) aBFu8c_BFu15i_B { unsigned char v1:8; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu15ll_B { unsigned char v1:8; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu15s_B { unsigned char v1:8; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu16i_B { unsigned char v1:8; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu16ll_B { unsigned char v1:8; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu16s_B { unsigned char v1:8; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu17i_B { unsigned char v1:8; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu17ll_B { unsigned char v1:8; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu1c_B { unsigned char v1:8; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu1i_B { unsigned char v1:8; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu1ll_B { unsigned char v1:8; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu1s_B { unsigned char v1:8; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu31i_B { unsigned char v1:8; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu31ll_B { unsigned char v1:8; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu32i_B { unsigned char v1:8; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu32ll_B { unsigned char v1:8; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu33_B { unsigned char v1:8; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu7c_B { unsigned char v1:8; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu7i_B { unsigned char v1:8; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu7ll_B { unsigned char v1:8; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu7s_B { unsigned char v1:8; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu8c_B { unsigned char v1:8; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu8i_B { unsigned char v1:8; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu8ll_B { unsigned char v1:8; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu8s_B { unsigned char v1:8; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu9i_B { unsigned char v1:8; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu9ll_B { unsigned char v1:8; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu8c_BFu9s_B { unsigned char v1:8; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu8c_C_B { unsigned char v1:8; char v2; bool v3; };
struct __attribute__((packed)) aBFu8c_D_B { unsigned char v1:8; double v2; bool v3; };
struct __attribute__((packed)) aBFu8c_F_B { unsigned char v1:8; float v2; bool v3; };
struct __attribute__((packed)) aBFu8c_I_B { unsigned char v1:8; int v2; bool v3; };
struct __attribute__((packed)) aBFu8c_Ip_B { unsigned char v1:8; int * v2; bool v3; };
struct __attribute__((packed)) aBFu8c_L_B { unsigned char v1:8; long long v2; bool v3; };
struct __attribute__((packed)) aBFu8c_S_B { unsigned char v1:8; short v2; bool v3; };
struct __attribute__((packed)) aBFu8c_Uc_B { unsigned char v1:8; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu8c_Ui_B { unsigned char v1:8; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu8c_Ul_B { unsigned char v1:8; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu8c_Us_B { unsigned char v1:8; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu8c_Vp_B { unsigned char v1:8; void * v2; bool v3; };
struct __attribute__((packed)) aBFu8i_B { unsigned int v1:8; bool v2; };
struct __attribute__((packed)) aBFu8i_B_B { unsigned int v1:8; bool v2; bool v3; };
struct __attribute__((packed)) aBFu8i_B_BFu15i { unsigned int v1:8; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8i_B_BFu15ll { unsigned int v1:8; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8i_B_BFu15s { unsigned int v1:8; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8i_B_BFu16i { unsigned int v1:8; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8i_B_BFu16ll { unsigned int v1:8; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8i_B_BFu16s { unsigned int v1:8; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8i_B_BFu17i { unsigned int v1:8; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8i_B_BFu17ll { unsigned int v1:8; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8i_B_BFu1c { unsigned int v1:8; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8i_B_BFu1i { unsigned int v1:8; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8i_B_BFu1ll { unsigned int v1:8; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8i_B_BFu1s { unsigned int v1:8; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8i_B_BFu31i { unsigned int v1:8; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8i_B_BFu31ll { unsigned int v1:8; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8i_B_BFu32i { unsigned int v1:8; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8i_B_BFu32ll { unsigned int v1:8; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8i_B_BFu33 { unsigned int v1:8; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8i_B_BFu7c { unsigned int v1:8; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8i_B_BFu7i { unsigned int v1:8; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8i_B_BFu7ll { unsigned int v1:8; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8i_B_BFu7s { unsigned int v1:8; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8i_B_BFu8c { unsigned int v1:8; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8i_B_BFu8i { unsigned int v1:8; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8i_B_BFu8ll { unsigned int v1:8; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8i_B_BFu8s { unsigned int v1:8; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8i_B_BFu9i { unsigned int v1:8; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8i_B_BFu9ll { unsigned int v1:8; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8i_B_BFu9s { unsigned int v1:8; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8i_B_C { unsigned int v1:8; bool v2; char v3; };
struct __attribute__((packed)) aBFu8i_B_D { unsigned int v1:8; bool v2; double v3; };
struct __attribute__((packed)) aBFu8i_B_F { unsigned int v1:8; bool v2; float v3; };
struct __attribute__((packed)) aBFu8i_B_I { unsigned int v1:8; bool v2; int v3; };
struct __attribute__((packed)) aBFu8i_B_Ip { unsigned int v1:8; bool v2; int * v3; };
struct __attribute__((packed)) aBFu8i_B_L { unsigned int v1:8; bool v2; long long v3; };
struct __attribute__((packed)) aBFu8i_B_S { unsigned int v1:8; bool v2; short v3; };
struct __attribute__((packed)) aBFu8i_B_Uc { unsigned int v1:8; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8i_B_Ui { unsigned int v1:8; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8i_B_Ul { unsigned int v1:8; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8i_B_Us { unsigned int v1:8; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8i_B_Vp { unsigned int v1:8; bool v2; void * v3; };
struct __attribute__((packed)) aBFu8i_BFu15i_B { unsigned int v1:8; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu15ll_B { unsigned int v1:8; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu15s_B { unsigned int v1:8; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu16i_B { unsigned int v1:8; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu16ll_B { unsigned int v1:8; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu16s_B { unsigned int v1:8; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu17i_B { unsigned int v1:8; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu17ll_B { unsigned int v1:8; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu1c_B { unsigned int v1:8; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu1i_B { unsigned int v1:8; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu1ll_B { unsigned int v1:8; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu1s_B { unsigned int v1:8; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu31i_B { unsigned int v1:8; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu31ll_B { unsigned int v1:8; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu32i_B { unsigned int v1:8; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu32ll_B { unsigned int v1:8; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu33_B { unsigned int v1:8; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu7c_B { unsigned int v1:8; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu7i_B { unsigned int v1:8; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu7ll_B { unsigned int v1:8; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu7s_B { unsigned int v1:8; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu8c_B { unsigned int v1:8; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu8i_B { unsigned int v1:8; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu8ll_B { unsigned int v1:8; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu8s_B { unsigned int v1:8; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu9i_B { unsigned int v1:8; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu9ll_B { unsigned int v1:8; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu8i_BFu9s_B { unsigned int v1:8; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu8i_C_B { unsigned int v1:8; char v2; bool v3; };
struct __attribute__((packed)) aBFu8i_D_B { unsigned int v1:8; double v2; bool v3; };
struct __attribute__((packed)) aBFu8i_F_B { unsigned int v1:8; float v2; bool v3; };
struct __attribute__((packed)) aBFu8i_I_B { unsigned int v1:8; int v2; bool v3; };
struct __attribute__((packed)) aBFu8i_Ip_B { unsigned int v1:8; int * v2; bool v3; };
struct __attribute__((packed)) aBFu8i_L_B { unsigned int v1:8; long long v2; bool v3; };
struct __attribute__((packed)) aBFu8i_S_B { unsigned int v1:8; short v2; bool v3; };
struct __attribute__((packed)) aBFu8i_Uc_B { unsigned int v1:8; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu8i_Ui_B { unsigned int v1:8; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu8i_Ul_B { unsigned int v1:8; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu8i_Us_B { unsigned int v1:8; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu8i_Vp_B { unsigned int v1:8; void * v2; bool v3; };
struct __attribute__((packed)) aBFu8ll_B { unsigned long long v1:8; bool v2; };
struct __attribute__((packed)) aBFu8ll_B_B { unsigned long long v1:8; bool v2; bool v3; };
struct __attribute__((packed)) aBFu8ll_B_BFu15i { unsigned long long v1:8; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8ll_B_BFu15ll { unsigned long long v1:8; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8ll_B_BFu15s { unsigned long long v1:8; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8ll_B_BFu16i { unsigned long long v1:8; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8ll_B_BFu16ll { unsigned long long v1:8; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8ll_B_BFu16s { unsigned long long v1:8; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8ll_B_BFu17i { unsigned long long v1:8; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8ll_B_BFu17ll { unsigned long long v1:8; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8ll_B_BFu1c { unsigned long long v1:8; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8ll_B_BFu1i { unsigned long long v1:8; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8ll_B_BFu1ll { unsigned long long v1:8; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8ll_B_BFu1s { unsigned long long v1:8; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8ll_B_BFu31i { unsigned long long v1:8; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8ll_B_BFu31ll { unsigned long long v1:8; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8ll_B_BFu32i { unsigned long long v1:8; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8ll_B_BFu32ll { unsigned long long v1:8; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8ll_B_BFu33 { unsigned long long v1:8; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8ll_B_BFu7c { unsigned long long v1:8; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8ll_B_BFu7i { unsigned long long v1:8; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8ll_B_BFu7ll { unsigned long long v1:8; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8ll_B_BFu7s { unsigned long long v1:8; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8ll_B_BFu8c { unsigned long long v1:8; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8ll_B_BFu8i { unsigned long long v1:8; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8ll_B_BFu8ll { unsigned long long v1:8; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8ll_B_BFu8s { unsigned long long v1:8; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8ll_B_BFu9i { unsigned long long v1:8; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8ll_B_BFu9ll { unsigned long long v1:8; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8ll_B_BFu9s { unsigned long long v1:8; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8ll_B_C { unsigned long long v1:8; bool v2; char v3; };
struct __attribute__((packed)) aBFu8ll_B_D { unsigned long long v1:8; bool v2; double v3; };
struct __attribute__((packed)) aBFu8ll_B_F { unsigned long long v1:8; bool v2; float v3; };
struct __attribute__((packed)) aBFu8ll_B_I { unsigned long long v1:8; bool v2; int v3; };
struct __attribute__((packed)) aBFu8ll_B_Ip { unsigned long long v1:8; bool v2; int * v3; };
struct __attribute__((packed)) aBFu8ll_B_L { unsigned long long v1:8; bool v2; long long v3; };
struct __attribute__((packed)) aBFu8ll_B_S { unsigned long long v1:8; bool v2; short v3; };
struct __attribute__((packed)) aBFu8ll_B_Uc { unsigned long long v1:8; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8ll_B_Ui { unsigned long long v1:8; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8ll_B_Ul { unsigned long long v1:8; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8ll_B_Us { unsigned long long v1:8; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8ll_B_Vp { unsigned long long v1:8; bool v2; void * v3; };
struct __attribute__((packed)) aBFu8ll_BFu15i_B { unsigned long long v1:8; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu15ll_B { unsigned long long v1:8; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu15s_B { unsigned long long v1:8; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu16i_B { unsigned long long v1:8; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu16ll_B { unsigned long long v1:8; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu16s_B { unsigned long long v1:8; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu17i_B { unsigned long long v1:8; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu17ll_B { unsigned long long v1:8; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu1c_B { unsigned long long v1:8; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu1i_B { unsigned long long v1:8; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu1ll_B { unsigned long long v1:8; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu1s_B { unsigned long long v1:8; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu31i_B { unsigned long long v1:8; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu31ll_B { unsigned long long v1:8; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu32i_B { unsigned long long v1:8; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu32ll_B { unsigned long long v1:8; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu33_B { unsigned long long v1:8; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu7c_B { unsigned long long v1:8; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu7i_B { unsigned long long v1:8; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu7ll_B { unsigned long long v1:8; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu7s_B { unsigned long long v1:8; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu8c_B { unsigned long long v1:8; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu8i_B { unsigned long long v1:8; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu8ll_B { unsigned long long v1:8; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu8s_B { unsigned long long v1:8; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu9i_B { unsigned long long v1:8; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu9ll_B { unsigned long long v1:8; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu8ll_BFu9s_B { unsigned long long v1:8; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu8ll_C_B { unsigned long long v1:8; char v2; bool v3; };
struct __attribute__((packed)) aBFu8ll_D_B { unsigned long long v1:8; double v2; bool v3; };
struct __attribute__((packed)) aBFu8ll_F_B { unsigned long long v1:8; float v2; bool v3; };
struct __attribute__((packed)) aBFu8ll_I_B { unsigned long long v1:8; int v2; bool v3; };
struct __attribute__((packed)) aBFu8ll_Ip_B { unsigned long long v1:8; int * v2; bool v3; };
struct __attribute__((packed)) aBFu8ll_L_B { unsigned long long v1:8; long long v2; bool v3; };
struct __attribute__((packed)) aBFu8ll_S_B { unsigned long long v1:8; short v2; bool v3; };
struct __attribute__((packed)) aBFu8ll_Uc_B { unsigned long long v1:8; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu8ll_Ui_B { unsigned long long v1:8; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu8ll_Ul_B { unsigned long long v1:8; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu8ll_Us_B { unsigned long long v1:8; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu8ll_Vp_B { unsigned long long v1:8; void * v2; bool v3; };
struct __attribute__((packed)) aBFu8s_B { unsigned short v1:8; bool v2; };
struct __attribute__((packed)) aBFu8s_B_B { unsigned short v1:8; bool v2; bool v3; };
struct __attribute__((packed)) aBFu8s_B_BFu15i { unsigned short v1:8; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_B_BFu15ll { unsigned short v1:8; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_B_BFu15s { unsigned short v1:8; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_B_BFu16i { unsigned short v1:8; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_B_BFu16ll { unsigned short v1:8; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_B_BFu16s { unsigned short v1:8; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_B_BFu17i { unsigned short v1:8; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_B_BFu17ll { unsigned short v1:8; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_B_BFu1c { unsigned short v1:8; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_B_BFu1i { unsigned short v1:8; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_B_BFu1ll { unsigned short v1:8; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_B_BFu1s { unsigned short v1:8; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_B_BFu31i { unsigned short v1:8; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_B_BFu31ll { unsigned short v1:8; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_B_BFu32i { unsigned short v1:8; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_B_BFu32ll { unsigned short v1:8; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_B_BFu33 { unsigned short v1:8; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_B_BFu7c { unsigned short v1:8; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_B_BFu7i { unsigned short v1:8; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_B_BFu7ll { unsigned short v1:8; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_B_BFu7s { unsigned short v1:8; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_B_BFu8c { unsigned short v1:8; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_B_BFu8i { unsigned short v1:8; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_B_BFu8ll { unsigned short v1:8; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_B_BFu8s { unsigned short v1:8; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_B_BFu9i { unsigned short v1:8; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_B_BFu9ll { unsigned short v1:8; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_B_BFu9s { unsigned short v1:8; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_B_C { unsigned short v1:8; bool v2; char v3; };
struct __attribute__((packed)) aBFu8s_B_D { unsigned short v1:8; bool v2; double v3; };
struct __attribute__((packed)) aBFu8s_B_F { unsigned short v1:8; bool v2; float v3; };
struct __attribute__((packed)) aBFu8s_B_I { unsigned short v1:8; bool v2; int v3; };
struct __attribute__((packed)) aBFu8s_B_Ip { unsigned short v1:8; bool v2; int * v3; };
struct __attribute__((packed)) aBFu8s_B_L { unsigned short v1:8; bool v2; long long v3; };
struct __attribute__((packed)) aBFu8s_B_S { unsigned short v1:8; bool v2; short v3; };
struct __attribute__((packed)) aBFu8s_B_Uc { unsigned short v1:8; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_B_Ui { unsigned short v1:8; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_B_Ul { unsigned short v1:8; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_B_Us { unsigned short v1:8; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_B_Vp { unsigned short v1:8; bool v2; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu15i_B { unsigned short v1:8; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll_B { unsigned short v1:8; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu15s_B { unsigned short v1:8; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu16i_B { unsigned short v1:8; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll_B { unsigned short v1:8; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu16s_B { unsigned short v1:8; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu17i_B { unsigned short v1:8; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll_B { unsigned short v1:8; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu1c_B { unsigned short v1:8; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu1i_B { unsigned short v1:8; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll_B { unsigned short v1:8; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu1s_B { unsigned short v1:8; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu31i_B { unsigned short v1:8; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll_B { unsigned short v1:8; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu32i_B { unsigned short v1:8; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll_B { unsigned short v1:8; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu33_B { unsigned short v1:8; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu7c_B { unsigned short v1:8; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu7i_B { unsigned short v1:8; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll_B { unsigned short v1:8; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu7s_B { unsigned short v1:8; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu8c_B { unsigned short v1:8; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu8i_B { unsigned short v1:8; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll_B { unsigned short v1:8; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu8s_B { unsigned short v1:8; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu9i_B { unsigned short v1:8; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll_B { unsigned short v1:8; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu8s_BFu9s_B { unsigned short v1:8; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu8s_C_B { unsigned short v1:8; char v2; bool v3; };
struct __attribute__((packed)) aBFu8s_D_B { unsigned short v1:8; double v2; bool v3; };
struct __attribute__((packed)) aBFu8s_F_B { unsigned short v1:8; float v2; bool v3; };
struct __attribute__((packed)) aBFu8s_I_B { unsigned short v1:8; int v2; bool v3; };
struct __attribute__((packed)) aBFu8s_Ip_B { unsigned short v1:8; int * v2; bool v3; };
struct __attribute__((packed)) aBFu8s_L_B { unsigned short v1:8; long long v2; bool v3; };
struct __attribute__((packed)) aBFu8s_S_B { unsigned short v1:8; short v2; bool v3; };
struct __attribute__((packed)) aBFu8s_Uc_B { unsigned short v1:8; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu8s_Ui_B { unsigned short v1:8; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu8s_Ul_B { unsigned short v1:8; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu8s_Us_B { unsigned short v1:8; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu8s_Vp_B { unsigned short v1:8; void * v2; bool v3; };
struct __attribute__((packed)) aBFu9i_B { unsigned int v1:9; bool v2; };
struct __attribute__((packed)) aBFu9i_B_B { unsigned int v1:9; bool v2; bool v3; };
struct __attribute__((packed)) aBFu9i_B_BFu15i { unsigned int v1:9; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu9i_B_BFu15ll { unsigned int v1:9; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu9i_B_BFu15s { unsigned int v1:9; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu9i_B_BFu16i { unsigned int v1:9; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu9i_B_BFu16ll { unsigned int v1:9; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu9i_B_BFu16s { unsigned int v1:9; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu9i_B_BFu17i { unsigned int v1:9; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu9i_B_BFu17ll { unsigned int v1:9; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu9i_B_BFu1c { unsigned int v1:9; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu9i_B_BFu1i { unsigned int v1:9; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu9i_B_BFu1ll { unsigned int v1:9; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu9i_B_BFu1s { unsigned int v1:9; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu9i_B_BFu31i { unsigned int v1:9; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu9i_B_BFu31ll { unsigned int v1:9; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu9i_B_BFu32i { unsigned int v1:9; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu9i_B_BFu32ll { unsigned int v1:9; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu9i_B_BFu33 { unsigned int v1:9; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu9i_B_BFu7c { unsigned int v1:9; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu9i_B_BFu7i { unsigned int v1:9; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu9i_B_BFu7ll { unsigned int v1:9; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu9i_B_BFu7s { unsigned int v1:9; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu9i_B_BFu8c { unsigned int v1:9; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu9i_B_BFu8i { unsigned int v1:9; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu9i_B_BFu8ll { unsigned int v1:9; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu9i_B_BFu8s { unsigned int v1:9; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu9i_B_BFu9i { unsigned int v1:9; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9i_B_BFu9ll { unsigned int v1:9; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9i_B_BFu9s { unsigned int v1:9; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9i_B_C { unsigned int v1:9; bool v2; char v3; };
struct __attribute__((packed)) aBFu9i_B_D { unsigned int v1:9; bool v2; double v3; };
struct __attribute__((packed)) aBFu9i_B_F { unsigned int v1:9; bool v2; float v3; };
struct __attribute__((packed)) aBFu9i_B_I { unsigned int v1:9; bool v2; int v3; };
struct __attribute__((packed)) aBFu9i_B_Ip { unsigned int v1:9; bool v2; int * v3; };
struct __attribute__((packed)) aBFu9i_B_L { unsigned int v1:9; bool v2; long long v3; };
struct __attribute__((packed)) aBFu9i_B_S { unsigned int v1:9; bool v2; short v3; };
struct __attribute__((packed)) aBFu9i_B_Uc { unsigned int v1:9; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu9i_B_Ui { unsigned int v1:9; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu9i_B_Ul { unsigned int v1:9; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu9i_B_Us { unsigned int v1:9; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu9i_B_Vp { unsigned int v1:9; bool v2; void * v3; };
struct __attribute__((packed)) aBFu9i_BFu15i_B { unsigned int v1:9; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll_B { unsigned int v1:9; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu15s_B { unsigned int v1:9; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu16i_B { unsigned int v1:9; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll_B { unsigned int v1:9; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu16s_B { unsigned int v1:9; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu17i_B { unsigned int v1:9; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu17ll_B { unsigned int v1:9; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu1c_B { unsigned int v1:9; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu1i_B { unsigned int v1:9; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu1ll_B { unsigned int v1:9; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu1s_B { unsigned int v1:9; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu31i_B { unsigned int v1:9; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu31ll_B { unsigned int v1:9; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu32i_B { unsigned int v1:9; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu32ll_B { unsigned int v1:9; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu33_B { unsigned int v1:9; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu7c_B { unsigned int v1:9; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu7i_B { unsigned int v1:9; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu7ll_B { unsigned int v1:9; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu7s_B { unsigned int v1:9; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu8c_B { unsigned int v1:9; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu8i_B { unsigned int v1:9; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu8ll_B { unsigned int v1:9; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu8s_B { unsigned int v1:9; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu9i_B { unsigned int v1:9; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu9ll_B { unsigned int v1:9; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu9i_BFu9s_B { unsigned int v1:9; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu9i_C_B { unsigned int v1:9; char v2; bool v3; };
struct __attribute__((packed)) aBFu9i_D_B { unsigned int v1:9; double v2; bool v3; };
struct __attribute__((packed)) aBFu9i_F_B { unsigned int v1:9; float v2; bool v3; };
struct __attribute__((packed)) aBFu9i_I_B { unsigned int v1:9; int v2; bool v3; };
struct __attribute__((packed)) aBFu9i_Ip_B { unsigned int v1:9; int * v2; bool v3; };
struct __attribute__((packed)) aBFu9i_L_B { unsigned int v1:9; long long v2; bool v3; };
struct __attribute__((packed)) aBFu9i_S_B { unsigned int v1:9; short v2; bool v3; };
struct __attribute__((packed)) aBFu9i_Uc_B { unsigned int v1:9; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu9i_Ui_B { unsigned int v1:9; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu9i_Ul_B { unsigned int v1:9; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu9i_Us_B { unsigned int v1:9; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu9i_Vp_B { unsigned int v1:9; void * v2; bool v3; };
struct __attribute__((packed)) aBFu9ll_B { unsigned long long v1:9; bool v2; };
struct __attribute__((packed)) aBFu9ll_B_B { unsigned long long v1:9; bool v2; bool v3; };
struct __attribute__((packed)) aBFu9ll_B_BFu15i { unsigned long long v1:9; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu9ll_B_BFu15ll { unsigned long long v1:9; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu9ll_B_BFu15s { unsigned long long v1:9; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu9ll_B_BFu16i { unsigned long long v1:9; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu9ll_B_BFu16ll { unsigned long long v1:9; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu9ll_B_BFu16s { unsigned long long v1:9; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu9ll_B_BFu17i { unsigned long long v1:9; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu9ll_B_BFu17ll { unsigned long long v1:9; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu9ll_B_BFu1c { unsigned long long v1:9; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu9ll_B_BFu1i { unsigned long long v1:9; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu9ll_B_BFu1ll { unsigned long long v1:9; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu9ll_B_BFu1s { unsigned long long v1:9; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu9ll_B_BFu31i { unsigned long long v1:9; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu9ll_B_BFu31ll { unsigned long long v1:9; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu9ll_B_BFu32i { unsigned long long v1:9; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu9ll_B_BFu32ll { unsigned long long v1:9; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu9ll_B_BFu33 { unsigned long long v1:9; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu9ll_B_BFu7c { unsigned long long v1:9; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu9ll_B_BFu7i { unsigned long long v1:9; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu9ll_B_BFu7ll { unsigned long long v1:9; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu9ll_B_BFu7s { unsigned long long v1:9; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu9ll_B_BFu8c { unsigned long long v1:9; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu9ll_B_BFu8i { unsigned long long v1:9; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu9ll_B_BFu8ll { unsigned long long v1:9; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu9ll_B_BFu8s { unsigned long long v1:9; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu9ll_B_BFu9i { unsigned long long v1:9; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9ll_B_BFu9ll { unsigned long long v1:9; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9ll_B_BFu9s { unsigned long long v1:9; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9ll_B_C { unsigned long long v1:9; bool v2; char v3; };
struct __attribute__((packed)) aBFu9ll_B_D { unsigned long long v1:9; bool v2; double v3; };
struct __attribute__((packed)) aBFu9ll_B_F { unsigned long long v1:9; bool v2; float v3; };
struct __attribute__((packed)) aBFu9ll_B_I { unsigned long long v1:9; bool v2; int v3; };
struct __attribute__((packed)) aBFu9ll_B_Ip { unsigned long long v1:9; bool v2; int * v3; };
struct __attribute__((packed)) aBFu9ll_B_L { unsigned long long v1:9; bool v2; long long v3; };
struct __attribute__((packed)) aBFu9ll_B_S { unsigned long long v1:9; bool v2; short v3; };
struct __attribute__((packed)) aBFu9ll_B_Uc { unsigned long long v1:9; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu9ll_B_Ui { unsigned long long v1:9; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu9ll_B_Ul { unsigned long long v1:9; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu9ll_B_Us { unsigned long long v1:9; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu9ll_B_Vp { unsigned long long v1:9; bool v2; void * v3; };
struct __attribute__((packed)) aBFu9ll_BFu15i_B { unsigned long long v1:9; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu15ll_B { unsigned long long v1:9; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu15s_B { unsigned long long v1:9; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu16i_B { unsigned long long v1:9; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu16ll_B { unsigned long long v1:9; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu16s_B { unsigned long long v1:9; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu17i_B { unsigned long long v1:9; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu17ll_B { unsigned long long v1:9; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu1c_B { unsigned long long v1:9; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu1i_B { unsigned long long v1:9; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu1ll_B { unsigned long long v1:9; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu1s_B { unsigned long long v1:9; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu31i_B { unsigned long long v1:9; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu31ll_B { unsigned long long v1:9; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu32i_B { unsigned long long v1:9; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu32ll_B { unsigned long long v1:9; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu33_B { unsigned long long v1:9; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu7c_B { unsigned long long v1:9; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu7i_B { unsigned long long v1:9; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu7ll_B { unsigned long long v1:9; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu7s_B { unsigned long long v1:9; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu8c_B { unsigned long long v1:9; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu8i_B { unsigned long long v1:9; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu8ll_B { unsigned long long v1:9; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu8s_B { unsigned long long v1:9; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu9i_B { unsigned long long v1:9; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu9ll_B { unsigned long long v1:9; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu9ll_BFu9s_B { unsigned long long v1:9; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu9ll_C_B { unsigned long long v1:9; char v2; bool v3; };
struct __attribute__((packed)) aBFu9ll_D_B { unsigned long long v1:9; double v2; bool v3; };
struct __attribute__((packed)) aBFu9ll_F_B { unsigned long long v1:9; float v2; bool v3; };
struct __attribute__((packed)) aBFu9ll_I_B { unsigned long long v1:9; int v2; bool v3; };
struct __attribute__((packed)) aBFu9ll_Ip_B { unsigned long long v1:9; int * v2; bool v3; };
struct __attribute__((packed)) aBFu9ll_L_B { unsigned long long v1:9; long long v2; bool v3; };
struct __attribute__((packed)) aBFu9ll_S_B { unsigned long long v1:9; short v2; bool v3; };
struct __attribute__((packed)) aBFu9ll_Uc_B { unsigned long long v1:9; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu9ll_Ui_B { unsigned long long v1:9; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu9ll_Ul_B { unsigned long long v1:9; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu9ll_Us_B { unsigned long long v1:9; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu9ll_Vp_B { unsigned long long v1:9; void * v2; bool v3; };
struct __attribute__((packed)) aBFu9s_B { unsigned short v1:9; bool v2; };
struct __attribute__((packed)) aBFu9s_B_B { unsigned short v1:9; bool v2; bool v3; };
struct __attribute__((packed)) aBFu9s_B_BFu15i { unsigned short v1:9; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu9s_B_BFu15ll { unsigned short v1:9; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu9s_B_BFu15s { unsigned short v1:9; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu9s_B_BFu16i { unsigned short v1:9; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu9s_B_BFu16ll { unsigned short v1:9; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu9s_B_BFu16s { unsigned short v1:9; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu9s_B_BFu17i { unsigned short v1:9; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu9s_B_BFu17ll { unsigned short v1:9; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu9s_B_BFu1c { unsigned short v1:9; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu9s_B_BFu1i { unsigned short v1:9; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu9s_B_BFu1ll { unsigned short v1:9; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu9s_B_BFu1s { unsigned short v1:9; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu9s_B_BFu31i { unsigned short v1:9; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu9s_B_BFu31ll { unsigned short v1:9; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu9s_B_BFu32i { unsigned short v1:9; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu9s_B_BFu32ll { unsigned short v1:9; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu9s_B_BFu33 { unsigned short v1:9; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu9s_B_BFu7c { unsigned short v1:9; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu9s_B_BFu7i { unsigned short v1:9; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu9s_B_BFu7ll { unsigned short v1:9; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu9s_B_BFu7s { unsigned short v1:9; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu9s_B_BFu8c { unsigned short v1:9; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu9s_B_BFu8i { unsigned short v1:9; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu9s_B_BFu8ll { unsigned short v1:9; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu9s_B_BFu8s { unsigned short v1:9; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu9s_B_BFu9i { unsigned short v1:9; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9s_B_BFu9ll { unsigned short v1:9; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9s_B_BFu9s { unsigned short v1:9; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9s_B_C { unsigned short v1:9; bool v2; char v3; };
struct __attribute__((packed)) aBFu9s_B_D { unsigned short v1:9; bool v2; double v3; };
struct __attribute__((packed)) aBFu9s_B_F { unsigned short v1:9; bool v2; float v3; };
struct __attribute__((packed)) aBFu9s_B_I { unsigned short v1:9; bool v2; int v3; };
struct __attribute__((packed)) aBFu9s_B_Ip { unsigned short v1:9; bool v2; int * v3; };
struct __attribute__((packed)) aBFu9s_B_L { unsigned short v1:9; bool v2; long long v3; };
struct __attribute__((packed)) aBFu9s_B_S { unsigned short v1:9; bool v2; short v3; };
struct __attribute__((packed)) aBFu9s_B_Uc { unsigned short v1:9; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu9s_B_Ui { unsigned short v1:9; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu9s_B_Ul { unsigned short v1:9; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu9s_B_Us { unsigned short v1:9; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu9s_B_Vp { unsigned short v1:9; bool v2; void * v3; };
struct __attribute__((packed)) aBFu9s_BFu15i_B { unsigned short v1:9; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu15ll_B { unsigned short v1:9; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu15s_B { unsigned short v1:9; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu16i_B { unsigned short v1:9; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu16ll_B { unsigned short v1:9; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu16s_B { unsigned short v1:9; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu17i_B { unsigned short v1:9; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu17ll_B { unsigned short v1:9; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu1c_B { unsigned short v1:9; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu1i_B { unsigned short v1:9; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu1ll_B { unsigned short v1:9; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu1s_B { unsigned short v1:9; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu31i_B { unsigned short v1:9; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu31ll_B { unsigned short v1:9; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu32i_B { unsigned short v1:9; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu32ll_B { unsigned short v1:9; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu33_B { unsigned short v1:9; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu7c_B { unsigned short v1:9; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu7i_B { unsigned short v1:9; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu7ll_B { unsigned short v1:9; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu7s_B { unsigned short v1:9; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu8c_B { unsigned short v1:9; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu8i_B { unsigned short v1:9; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu8ll_B { unsigned short v1:9; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu8s_B { unsigned short v1:9; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu9i_B { unsigned short v1:9; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu9ll_B { unsigned short v1:9; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu9s_BFu9s_B { unsigned short v1:9; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu9s_C_B { unsigned short v1:9; char v2; bool v3; };
struct __attribute__((packed)) aBFu9s_D_B { unsigned short v1:9; double v2; bool v3; };
struct __attribute__((packed)) aBFu9s_F_B { unsigned short v1:9; float v2; bool v3; };
struct __attribute__((packed)) aBFu9s_I_B { unsigned short v1:9; int v2; bool v3; };
struct __attribute__((packed)) aBFu9s_Ip_B { unsigned short v1:9; int * v2; bool v3; };
struct __attribute__((packed)) aBFu9s_L_B { unsigned short v1:9; long long v2; bool v3; };
struct __attribute__((packed)) aBFu9s_S_B { unsigned short v1:9; short v2; bool v3; };
struct __attribute__((packed)) aBFu9s_Uc_B { unsigned short v1:9; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu9s_Ui_B { unsigned short v1:9; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu9s_Ul_B { unsigned short v1:9; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu9s_Us_B { unsigned short v1:9; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu9s_Vp_B { unsigned short v1:9; void * v2; bool v3; };
struct __attribute__((packed)) aC_B { char v1; bool v2; };
struct __attribute__((packed)) aC_B_B { char v1; bool v2; bool v3; };
struct __attribute__((packed)) aC_B_BFu15i { char v1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_B_BFu15ll { char v1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_B_BFu15s { char v1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_B_BFu16i { char v1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_B_BFu16ll { char v1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_B_BFu16s { char v1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_B_BFu17i { char v1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_B_BFu17ll { char v1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_B_BFu1c { char v1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_B_BFu1i { char v1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_B_BFu1ll { char v1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_B_BFu1s { char v1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_B_BFu31i { char v1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_B_BFu31ll { char v1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_B_BFu32i { char v1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_B_BFu32ll { char v1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_B_BFu33 { char v1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_B_BFu7c { char v1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_B_BFu7i { char v1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_B_BFu7ll { char v1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_B_BFu7s { char v1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_B_BFu8c { char v1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_B_BFu8i { char v1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_B_BFu8ll { char v1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_B_BFu8s { char v1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_B_BFu9i { char v1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_B_BFu9ll { char v1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_B_BFu9s { char v1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_B_C { char v1; bool v2; char v3; };
struct __attribute__((packed)) aC_B_D { char v1; bool v2; double v3; };
struct __attribute__((packed)) aC_B_F { char v1; bool v2; float v3; };
struct __attribute__((packed)) aC_B_I { char v1; bool v2; int v3; };
struct __attribute__((packed)) aC_B_Ip { char v1; bool v2; int * v3; };
struct __attribute__((packed)) aC_B_L { char v1; bool v2; long long v3; };
struct __attribute__((packed)) aC_B_S { char v1; bool v2; short v3; };
struct __attribute__((packed)) aC_B_Uc { char v1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aC_B_Ui { char v1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aC_B_Ul { char v1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aC_B_Us { char v1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aC_B_Vp { char v1; bool v2; void * v3; };
struct __attribute__((packed)) aC_BFu15i_B { char v1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aC_BFu15ll_B { char v1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aC_BFu15s_B { char v1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aC_BFu16i_B { char v1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aC_BFu16ll_B { char v1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aC_BFu16s_B { char v1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aC_BFu17i_B { char v1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aC_BFu17ll_B { char v1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aC_BFu1c_B { char v1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aC_BFu1i_B { char v1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aC_BFu1ll_B { char v1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aC_BFu1s_B { char v1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aC_BFu31i_B { char v1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aC_BFu31ll_B { char v1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aC_BFu32i_B { char v1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aC_BFu32ll_B { char v1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aC_BFu33_B { char v1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aC_BFu7c_B { char v1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aC_BFu7i_B { char v1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aC_BFu7ll_B { char v1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aC_BFu7s_B { char v1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aC_BFu8c_B { char v1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aC_BFu8i_B { char v1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aC_BFu8ll_B { char v1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aC_BFu8s_B { char v1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aC_BFu9i_B { char v1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aC_BFu9ll_B { char v1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aC_BFu9s_B { char v1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aC_C_B { char v1; char v2; bool v3; };
struct __attribute__((packed)) aC_D_B { char v1; double v2; bool v3; };
struct __attribute__((packed)) aC_F_B { char v1; float v2; bool v3; };
struct __attribute__((packed)) aC_I_B { char v1; int v2; bool v3; };
struct __attribute__((packed)) aC_Ip_B { char v1; int * v2; bool v3; };
struct __attribute__((packed)) aC_L_B { char v1; long long v2; bool v3; };
struct __attribute__((packed)) aC_S_B { char v1; short v2; bool v3; };
struct __attribute__((packed)) aC_Uc_B { char v1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aC_Ui_B { char v1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aC_Ul_B { char v1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aC_Us_B { char v1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aC_Vp_B { char v1; void * v2; bool v3; };
struct __attribute__((packed)) aD_B { double v1; bool v2; };
struct __attribute__((packed)) aD_B_B { double v1; bool v2; bool v3; };
struct __attribute__((packed)) aD_B_BFu15i { double v1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_B_BFu15ll { double v1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_B_BFu15s { double v1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_B_BFu16i { double v1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_B_BFu16ll { double v1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_B_BFu16s { double v1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_B_BFu17i { double v1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_B_BFu17ll { double v1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_B_BFu1c { double v1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_B_BFu1i { double v1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_B_BFu1ll { double v1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_B_BFu1s { double v1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_B_BFu31i { double v1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_B_BFu31ll { double v1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_B_BFu32i { double v1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_B_BFu32ll { double v1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_B_BFu33 { double v1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_B_BFu7c { double v1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_B_BFu7i { double v1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_B_BFu7ll { double v1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_B_BFu7s { double v1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_B_BFu8c { double v1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_B_BFu8i { double v1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_B_BFu8ll { double v1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_B_BFu8s { double v1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_B_BFu9i { double v1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_B_BFu9ll { double v1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_B_BFu9s { double v1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_B_C { double v1; bool v2; char v3; };
struct __attribute__((packed)) aD_B_D { double v1; bool v2; double v3; };
struct __attribute__((packed)) aD_B_F { double v1; bool v2; float v3; };
struct __attribute__((packed)) aD_B_I { double v1; bool v2; int v3; };
struct __attribute__((packed)) aD_B_Ip { double v1; bool v2; int * v3; };
struct __attribute__((packed)) aD_B_L { double v1; bool v2; long long v3; };
struct __attribute__((packed)) aD_B_S { double v1; bool v2; short v3; };
struct __attribute__((packed)) aD_B_Uc { double v1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aD_B_Ui { double v1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aD_B_Ul { double v1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aD_B_Us { double v1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aD_B_Vp { double v1; bool v2; void * v3; };
struct __attribute__((packed)) aD_BFu15i_B { double v1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aD_BFu15ll_B { double v1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aD_BFu15s_B { double v1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aD_BFu16i_B { double v1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aD_BFu16ll_B { double v1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aD_BFu16s_B { double v1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aD_BFu17i_B { double v1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aD_BFu17ll_B { double v1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aD_BFu1c_B { double v1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aD_BFu1i_B { double v1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aD_BFu1ll_B { double v1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aD_BFu1s_B { double v1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aD_BFu31i_B { double v1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aD_BFu31ll_B { double v1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aD_BFu32i_B { double v1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aD_BFu32ll_B { double v1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aD_BFu33_B { double v1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aD_BFu7c_B { double v1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aD_BFu7i_B { double v1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aD_BFu7ll_B { double v1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aD_BFu7s_B { double v1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aD_BFu8c_B { double v1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aD_BFu8i_B { double v1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aD_BFu8ll_B { double v1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aD_BFu8s_B { double v1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aD_BFu9i_B { double v1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aD_BFu9ll_B { double v1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aD_BFu9s_B { double v1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aD_C_B { double v1; char v2; bool v3; };
struct __attribute__((packed)) aD_D_B { double v1; double v2; bool v3; };
struct __attribute__((packed)) aD_F_B { double v1; float v2; bool v3; };
struct __attribute__((packed)) aD_I_B { double v1; int v2; bool v3; };
struct __attribute__((packed)) aD_Ip_B { double v1; int * v2; bool v3; };
struct __attribute__((packed)) aD_L_B { double v1; long long v2; bool v3; };
struct __attribute__((packed)) aD_S_B { double v1; short v2; bool v3; };
struct __attribute__((packed)) aD_Uc_B { double v1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aD_Ui_B { double v1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aD_Ul_B { double v1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aD_Us_B { double v1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aD_Vp_B { double v1; void * v2; bool v3; };
struct __attribute__((packed)) aF_B { float v1; bool v2; };
struct __attribute__((packed)) aF_B_B { float v1; bool v2; bool v3; };
struct __attribute__((packed)) aF_B_BFu15i { float v1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_B_BFu15ll { float v1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_B_BFu15s { float v1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_B_BFu16i { float v1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_B_BFu16ll { float v1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_B_BFu16s { float v1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_B_BFu17i { float v1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_B_BFu17ll { float v1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_B_BFu1c { float v1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_B_BFu1i { float v1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_B_BFu1ll { float v1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_B_BFu1s { float v1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_B_BFu31i { float v1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_B_BFu31ll { float v1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_B_BFu32i { float v1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_B_BFu32ll { float v1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_B_BFu33 { float v1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_B_BFu7c { float v1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_B_BFu7i { float v1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_B_BFu7ll { float v1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_B_BFu7s { float v1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_B_BFu8c { float v1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_B_BFu8i { float v1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_B_BFu8ll { float v1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_B_BFu8s { float v1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_B_BFu9i { float v1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_B_BFu9ll { float v1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_B_BFu9s { float v1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_B_C { float v1; bool v2; char v3; };
struct __attribute__((packed)) aF_B_D { float v1; bool v2; double v3; };
struct __attribute__((packed)) aF_B_F { float v1; bool v2; float v3; };
struct __attribute__((packed)) aF_B_I { float v1; bool v2; int v3; };
struct __attribute__((packed)) aF_B_Ip { float v1; bool v2; int * v3; };
struct __attribute__((packed)) aF_B_L { float v1; bool v2; long long v3; };
struct __attribute__((packed)) aF_B_S { float v1; bool v2; short v3; };
struct __attribute__((packed)) aF_B_Uc { float v1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aF_B_Ui { float v1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aF_B_Ul { float v1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aF_B_Us { float v1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aF_B_Vp { float v1; bool v2; void * v3; };
struct __attribute__((packed)) aF_BFu15i_B { float v1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aF_BFu15ll_B { float v1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aF_BFu15s_B { float v1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aF_BFu16i_B { float v1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aF_BFu16ll_B { float v1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aF_BFu16s_B { float v1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aF_BFu17i_B { float v1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aF_BFu17ll_B { float v1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aF_BFu1c_B { float v1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aF_BFu1i_B { float v1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aF_BFu1ll_B { float v1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aF_BFu1s_B { float v1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aF_BFu31i_B { float v1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aF_BFu31ll_B { float v1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aF_BFu32i_B { float v1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aF_BFu32ll_B { float v1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aF_BFu33_B { float v1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aF_BFu7c_B { float v1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aF_BFu7i_B { float v1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aF_BFu7ll_B { float v1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aF_BFu7s_B { float v1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aF_BFu8c_B { float v1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aF_BFu8i_B { float v1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aF_BFu8ll_B { float v1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aF_BFu8s_B { float v1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aF_BFu9i_B { float v1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aF_BFu9ll_B { float v1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aF_BFu9s_B { float v1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aF_C_B { float v1; char v2; bool v3; };
struct __attribute__((packed)) aF_D_B { float v1; double v2; bool v3; };
struct __attribute__((packed)) aF_F_B { float v1; float v2; bool v3; };
struct __attribute__((packed)) aF_I_B { float v1; int v2; bool v3; };
struct __attribute__((packed)) aF_Ip_B { float v1; int * v2; bool v3; };
struct __attribute__((packed)) aF_L_B { float v1; long long v2; bool v3; };
struct __attribute__((packed)) aF_S_B { float v1; short v2; bool v3; };
struct __attribute__((packed)) aF_Uc_B { float v1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aF_Ui_B { float v1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aF_Ul_B { float v1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aF_Us_B { float v1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aF_Vp_B { float v1; void * v2; bool v3; };
struct __attribute__((packed)) aI_B { int v1; bool v2; };
struct __attribute__((packed)) aI_B_B { int v1; bool v2; bool v3; };
struct __attribute__((packed)) aI_B_BFu15i { int v1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_B_BFu15ll { int v1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_B_BFu15s { int v1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_B_BFu16i { int v1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_B_BFu16ll { int v1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_B_BFu16s { int v1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_B_BFu17i { int v1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_B_BFu17ll { int v1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_B_BFu1c { int v1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_B_BFu1i { int v1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_B_BFu1ll { int v1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_B_BFu1s { int v1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_B_BFu31i { int v1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_B_BFu31ll { int v1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_B_BFu32i { int v1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_B_BFu32ll { int v1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_B_BFu33 { int v1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_B_BFu7c { int v1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_B_BFu7i { int v1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_B_BFu7ll { int v1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_B_BFu7s { int v1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_B_BFu8c { int v1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_B_BFu8i { int v1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_B_BFu8ll { int v1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_B_BFu8s { int v1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_B_BFu9i { int v1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_B_BFu9ll { int v1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_B_BFu9s { int v1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_B_C { int v1; bool v2; char v3; };
struct __attribute__((packed)) aI_B_D { int v1; bool v2; double v3; };
struct __attribute__((packed)) aI_B_F { int v1; bool v2; float v3; };
struct __attribute__((packed)) aI_B_I { int v1; bool v2; int v3; };
struct __attribute__((packed)) aI_B_Ip { int v1; bool v2; int * v3; };
struct __attribute__((packed)) aI_B_L { int v1; bool v2; long long v3; };
struct __attribute__((packed)) aI_B_S { int v1; bool v2; short v3; };
struct __attribute__((packed)) aI_B_Uc { int v1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aI_B_Ui { int v1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aI_B_Ul { int v1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aI_B_Us { int v1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aI_B_Vp { int v1; bool v2; void * v3; };
struct __attribute__((packed)) aI_BFu15i_B { int v1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aI_BFu15ll_B { int v1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aI_BFu15s_B { int v1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aI_BFu16i_B { int v1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aI_BFu16ll_B { int v1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aI_BFu16s_B { int v1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aI_BFu17i_B { int v1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aI_BFu17ll_B { int v1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aI_BFu1c_B { int v1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aI_BFu1i_B { int v1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aI_BFu1ll_B { int v1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aI_BFu1s_B { int v1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aI_BFu31i_B { int v1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aI_BFu31ll_B { int v1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aI_BFu32i_B { int v1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aI_BFu32ll_B { int v1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aI_BFu33_B { int v1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aI_BFu7c_B { int v1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aI_BFu7i_B { int v1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aI_BFu7ll_B { int v1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aI_BFu7s_B { int v1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aI_BFu8c_B { int v1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aI_BFu8i_B { int v1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aI_BFu8ll_B { int v1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aI_BFu8s_B { int v1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aI_BFu9i_B { int v1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aI_BFu9ll_B { int v1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aI_BFu9s_B { int v1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aI_C_B { int v1; char v2; bool v3; };
struct __attribute__((packed)) aI_D_B { int v1; double v2; bool v3; };
struct __attribute__((packed)) aI_F_B { int v1; float v2; bool v3; };
struct __attribute__((packed)) aI_I_B { int v1; int v2; bool v3; };
struct __attribute__((packed)) aI_Ip_B { int v1; int * v2; bool v3; };
struct __attribute__((packed)) aI_L_B { int v1; long long v2; bool v3; };
struct __attribute__((packed)) aI_S_B { int v1; short v2; bool v3; };
struct __attribute__((packed)) aI_Uc_B { int v1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aI_Ui_B { int v1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aI_Ul_B { int v1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aI_Us_B { int v1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aI_Vp_B { int v1; void * v2; bool v3; };
struct __attribute__((packed)) aIp_B { int * v1; bool v2; };
struct __attribute__((packed)) aIp_B_B { int * v1; bool v2; bool v3; };
struct __attribute__((packed)) aIp_B_BFu15i { int * v1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_B_BFu15ll { int * v1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_B_BFu15s { int * v1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_B_BFu16i { int * v1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_B_BFu16ll { int * v1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_B_BFu16s { int * v1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_B_BFu17i { int * v1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_B_BFu17ll { int * v1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_B_BFu1c { int * v1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_B_BFu1i { int * v1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_B_BFu1ll { int * v1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_B_BFu1s { int * v1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_B_BFu31i { int * v1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_B_BFu31ll { int * v1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_B_BFu32i { int * v1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_B_BFu32ll { int * v1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_B_BFu33 { int * v1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_B_BFu7c { int * v1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_B_BFu7i { int * v1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_B_BFu7ll { int * v1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_B_BFu7s { int * v1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_B_BFu8c { int * v1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_B_BFu8i { int * v1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_B_BFu8ll { int * v1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_B_BFu8s { int * v1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_B_BFu9i { int * v1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_B_BFu9ll { int * v1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_B_BFu9s { int * v1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_B_C { int * v1; bool v2; char v3; };
struct __attribute__((packed)) aIp_B_D { int * v1; bool v2; double v3; };
struct __attribute__((packed)) aIp_B_F { int * v1; bool v2; float v3; };
struct __attribute__((packed)) aIp_B_I { int * v1; bool v2; int v3; };
struct __attribute__((packed)) aIp_B_Ip { int * v1; bool v2; int * v3; };
struct __attribute__((packed)) aIp_B_L { int * v1; bool v2; long long v3; };
struct __attribute__((packed)) aIp_B_S { int * v1; bool v2; short v3; };
struct __attribute__((packed)) aIp_B_Uc { int * v1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aIp_B_Ui { int * v1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aIp_B_Ul { int * v1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_B_Us { int * v1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aIp_B_Vp { int * v1; bool v2; void * v3; };
struct __attribute__((packed)) aIp_BFu15i_B { int * v1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aIp_BFu15ll_B { int * v1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aIp_BFu15s_B { int * v1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aIp_BFu16i_B { int * v1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aIp_BFu16ll_B { int * v1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aIp_BFu16s_B { int * v1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aIp_BFu17i_B { int * v1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aIp_BFu17ll_B { int * v1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aIp_BFu1c_B { int * v1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aIp_BFu1i_B { int * v1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aIp_BFu1ll_B { int * v1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aIp_BFu1s_B { int * v1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aIp_BFu31i_B { int * v1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aIp_BFu31ll_B { int * v1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aIp_BFu32i_B { int * v1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aIp_BFu32ll_B { int * v1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aIp_BFu33_B { int * v1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aIp_BFu7c_B { int * v1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aIp_BFu7i_B { int * v1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aIp_BFu7ll_B { int * v1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aIp_BFu7s_B { int * v1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aIp_BFu8c_B { int * v1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aIp_BFu8i_B { int * v1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aIp_BFu8ll_B { int * v1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aIp_BFu8s_B { int * v1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aIp_BFu9i_B { int * v1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aIp_BFu9ll_B { int * v1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aIp_BFu9s_B { int * v1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aIp_C_B { int * v1; char v2; bool v3; };
struct __attribute__((packed)) aIp_D_B { int * v1; double v2; bool v3; };
struct __attribute__((packed)) aIp_F_B { int * v1; float v2; bool v3; };
struct __attribute__((packed)) aIp_I_B { int * v1; int v2; bool v3; };
struct __attribute__((packed)) aIp_Ip_B { int * v1; int * v2; bool v3; };
struct __attribute__((packed)) aIp_L_B { int * v1; long long v2; bool v3; };
struct __attribute__((packed)) aIp_S_B { int * v1; short v2; bool v3; };
struct __attribute__((packed)) aIp_Uc_B { int * v1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aIp_Ui_B { int * v1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aIp_Ul_B { int * v1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aIp_Us_B { int * v1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aIp_Vp_B { int * v1; void * v2; bool v3; };
struct __attribute__((packed)) aL_B { long long v1; bool v2; };
struct __attribute__((packed)) aL_B_B { long long v1; bool v2; bool v3; };
struct __attribute__((packed)) aL_B_BFu15i { long long v1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_B_BFu15ll { long long v1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_B_BFu15s { long long v1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aL_B_BFu16i { long long v1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_B_BFu16ll { long long v1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_B_BFu16s { long long v1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_B_BFu17i { long long v1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_B_BFu17ll { long long v1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_B_BFu1c { long long v1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_B_BFu1i { long long v1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_B_BFu1ll { long long v1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_B_BFu1s { long long v1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_B_BFu31i { long long v1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_B_BFu31ll { long long v1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_B_BFu32i { long long v1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_B_BFu32ll { long long v1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_B_BFu33 { long long v1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_B_BFu7c { long long v1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_B_BFu7i { long long v1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_B_BFu7ll { long long v1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_B_BFu7s { long long v1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_B_BFu8c { long long v1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_B_BFu8i { long long v1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_B_BFu8ll { long long v1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_B_BFu8s { long long v1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_B_BFu9i { long long v1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_B_BFu9ll { long long v1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_B_BFu9s { long long v1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_B_C { long long v1; bool v2; char v3; };
struct __attribute__((packed)) aL_B_D { long long v1; bool v2; double v3; };
struct __attribute__((packed)) aL_B_F { long long v1; bool v2; float v3; };
struct __attribute__((packed)) aL_B_I { long long v1; bool v2; int v3; };
struct __attribute__((packed)) aL_B_Ip { long long v1; bool v2; int * v3; };
struct __attribute__((packed)) aL_B_L { long long v1; bool v2; long long v3; };
struct __attribute__((packed)) aL_B_S { long long v1; bool v2; short v3; };
struct __attribute__((packed)) aL_B_Uc { long long v1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aL_B_Ui { long long v1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aL_B_Ul { long long v1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aL_B_Us { long long v1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aL_B_Vp { long long v1; bool v2; void * v3; };
struct __attribute__((packed)) aL_BFu15i_B { long long v1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aL_BFu15ll_B { long long v1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aL_BFu15s_B { long long v1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aL_BFu16i_B { long long v1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aL_BFu16ll_B { long long v1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aL_BFu16s_B { long long v1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aL_BFu17i_B { long long v1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aL_BFu17ll_B { long long v1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aL_BFu1c_B { long long v1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aL_BFu1i_B { long long v1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aL_BFu1ll_B { long long v1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aL_BFu1s_B { long long v1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aL_BFu31i_B { long long v1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aL_BFu31ll_B { long long v1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aL_BFu32i_B { long long v1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aL_BFu32ll_B { long long v1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aL_BFu33_B { long long v1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aL_BFu7c_B { long long v1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aL_BFu7i_B { long long v1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aL_BFu7ll_B { long long v1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aL_BFu7s_B { long long v1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aL_BFu8c_B { long long v1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aL_BFu8i_B { long long v1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aL_BFu8ll_B { long long v1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aL_BFu8s_B { long long v1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aL_BFu9i_B { long long v1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aL_BFu9ll_B { long long v1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aL_BFu9s_B { long long v1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aL_C_B { long long v1; char v2; bool v3; };
struct __attribute__((packed)) aL_D_B { long long v1; double v2; bool v3; };
struct __attribute__((packed)) aL_F_B { long long v1; float v2; bool v3; };
struct __attribute__((packed)) aL_I_B { long long v1; int v2; bool v3; };
struct __attribute__((packed)) aL_Ip_B { long long v1; int * v2; bool v3; };
struct __attribute__((packed)) aL_L_B { long long v1; long long v2; bool v3; };
struct __attribute__((packed)) aL_S_B { long long v1; short v2; bool v3; };
struct __attribute__((packed)) aL_Uc_B { long long v1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aL_Ui_B { long long v1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aL_Ul_B { long long v1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aL_Us_B { long long v1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aL_Vp_B { long long v1; void * v2; bool v3; };
struct __attribute__((packed)) aS_B { short v1; bool v2; };
struct __attribute__((packed)) aS_B_B { short v1; bool v2; bool v3; };
struct __attribute__((packed)) aS_B_BFu15i { short v1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_B_BFu15ll { short v1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_B_BFu15s { short v1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_B_BFu16i { short v1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_B_BFu16ll { short v1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_B_BFu16s { short v1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_B_BFu17i { short v1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_B_BFu17ll { short v1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_B_BFu1c { short v1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_B_BFu1i { short v1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_B_BFu1ll { short v1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_B_BFu1s { short v1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_B_BFu31i { short v1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_B_BFu31ll { short v1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_B_BFu32i { short v1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_B_BFu32ll { short v1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_B_BFu33 { short v1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_B_BFu7c { short v1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_B_BFu7i { short v1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_B_BFu7ll { short v1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_B_BFu7s { short v1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_B_BFu8c { short v1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_B_BFu8i { short v1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_B_BFu8ll { short v1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_B_BFu8s { short v1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_B_BFu9i { short v1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_B_BFu9ll { short v1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_B_BFu9s { short v1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_B_C { short v1; bool v2; char v3; };
struct __attribute__((packed)) aS_B_D { short v1; bool v2; double v3; };
struct __attribute__((packed)) aS_B_F { short v1; bool v2; float v3; };
struct __attribute__((packed)) aS_B_I { short v1; bool v2; int v3; };
struct __attribute__((packed)) aS_B_Ip { short v1; bool v2; int * v3; };
struct __attribute__((packed)) aS_B_L { short v1; bool v2; long long v3; };
struct __attribute__((packed)) aS_B_S { short v1; bool v2; short v3; };
struct __attribute__((packed)) aS_B_Uc { short v1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aS_B_Ui { short v1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aS_B_Ul { short v1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aS_B_Us { short v1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aS_B_Vp { short v1; bool v2; void * v3; };
struct __attribute__((packed)) aS_BFu15i_B { short v1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aS_BFu15ll_B { short v1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aS_BFu15s_B { short v1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aS_BFu16i_B { short v1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aS_BFu16ll_B { short v1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aS_BFu16s_B { short v1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aS_BFu17i_B { short v1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aS_BFu17ll_B { short v1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aS_BFu1c_B { short v1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aS_BFu1i_B { short v1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aS_BFu1ll_B { short v1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aS_BFu1s_B { short v1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aS_BFu31i_B { short v1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aS_BFu31ll_B { short v1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aS_BFu32i_B { short v1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aS_BFu32ll_B { short v1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aS_BFu33_B { short v1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aS_BFu7c_B { short v1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aS_BFu7i_B { short v1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aS_BFu7ll_B { short v1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aS_BFu7s_B { short v1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aS_BFu8c_B { short v1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aS_BFu8i_B { short v1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aS_BFu8ll_B { short v1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aS_BFu8s_B { short v1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aS_BFu9i_B { short v1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aS_BFu9ll_B { short v1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aS_BFu9s_B { short v1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aS_C_B { short v1; char v2; bool v3; };
struct __attribute__((packed)) aS_D_B { short v1; double v2; bool v3; };
struct __attribute__((packed)) aS_F_B { short v1; float v2; bool v3; };
struct __attribute__((packed)) aS_I_B { short v1; int v2; bool v3; };
struct __attribute__((packed)) aS_Ip_B { short v1; int * v2; bool v3; };
struct __attribute__((packed)) aS_L_B { short v1; long long v2; bool v3; };
struct __attribute__((packed)) aS_S_B { short v1; short v2; bool v3; };
struct __attribute__((packed)) aS_Uc_B { short v1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aS_Ui_B { short v1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aS_Ul_B { short v1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aS_Us_B { short v1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aS_Vp_B { short v1; void * v2; bool v3; };
struct __attribute__((packed)) aUc_B { unsigned char v1; bool v2; };
struct __attribute__((packed)) aUc_B_B { unsigned char v1; bool v2; bool v3; };
struct __attribute__((packed)) aUc_B_BFu15i { unsigned char v1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_B_BFu15ll { unsigned char v1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_B_BFu15s { unsigned char v1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_B_BFu16i { unsigned char v1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_B_BFu16ll { unsigned char v1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_B_BFu16s { unsigned char v1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_B_BFu17i { unsigned char v1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_B_BFu17ll { unsigned char v1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_B_BFu1c { unsigned char v1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_B_BFu1i { unsigned char v1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_B_BFu1ll { unsigned char v1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_B_BFu1s { unsigned char v1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_B_BFu31i { unsigned char v1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_B_BFu31ll { unsigned char v1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_B_BFu32i { unsigned char v1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_B_BFu32ll { unsigned char v1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_B_BFu33 { unsigned char v1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_B_BFu7c { unsigned char v1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_B_BFu7i { unsigned char v1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_B_BFu7ll { unsigned char v1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_B_BFu7s { unsigned char v1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_B_BFu8c { unsigned char v1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_B_BFu8i { unsigned char v1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_B_BFu8ll { unsigned char v1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_B_BFu8s { unsigned char v1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_B_BFu9i { unsigned char v1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_B_BFu9ll { unsigned char v1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_B_BFu9s { unsigned char v1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_B_C { unsigned char v1; bool v2; char v3; };
struct __attribute__((packed)) aUc_B_D { unsigned char v1; bool v2; double v3; };
struct __attribute__((packed)) aUc_B_F { unsigned char v1; bool v2; float v3; };
struct __attribute__((packed)) aUc_B_I { unsigned char v1; bool v2; int v3; };
struct __attribute__((packed)) aUc_B_Ip { unsigned char v1; bool v2; int * v3; };
struct __attribute__((packed)) aUc_B_L { unsigned char v1; bool v2; long long v3; };
struct __attribute__((packed)) aUc_B_S { unsigned char v1; bool v2; short v3; };
struct __attribute__((packed)) aUc_B_Uc { unsigned char v1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aUc_B_Ui { unsigned char v1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aUc_B_Ul { unsigned char v1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_B_Us { unsigned char v1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aUc_B_Vp { unsigned char v1; bool v2; void * v3; };
struct __attribute__((packed)) aUc_BFu15i_B { unsigned char v1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aUc_BFu15ll_B { unsigned char v1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aUc_BFu15s_B { unsigned char v1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aUc_BFu16i_B { unsigned char v1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aUc_BFu16ll_B { unsigned char v1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aUc_BFu16s_B { unsigned char v1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aUc_BFu17i_B { unsigned char v1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aUc_BFu17ll_B { unsigned char v1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aUc_BFu1c_B { unsigned char v1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aUc_BFu1i_B { unsigned char v1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aUc_BFu1ll_B { unsigned char v1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aUc_BFu1s_B { unsigned char v1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aUc_BFu31i_B { unsigned char v1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aUc_BFu31ll_B { unsigned char v1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aUc_BFu32i_B { unsigned char v1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aUc_BFu32ll_B { unsigned char v1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aUc_BFu33_B { unsigned char v1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aUc_BFu7c_B { unsigned char v1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aUc_BFu7i_B { unsigned char v1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aUc_BFu7ll_B { unsigned char v1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aUc_BFu7s_B { unsigned char v1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aUc_BFu8c_B { unsigned char v1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aUc_BFu8i_B { unsigned char v1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aUc_BFu8ll_B { unsigned char v1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aUc_BFu8s_B { unsigned char v1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aUc_BFu9i_B { unsigned char v1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aUc_BFu9ll_B { unsigned char v1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aUc_BFu9s_B { unsigned char v1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aUc_C_B { unsigned char v1; char v2; bool v3; };
struct __attribute__((packed)) aUc_D_B { unsigned char v1; double v2; bool v3; };
struct __attribute__((packed)) aUc_F_B { unsigned char v1; float v2; bool v3; };
struct __attribute__((packed)) aUc_I_B { unsigned char v1; int v2; bool v3; };
struct __attribute__((packed)) aUc_Ip_B { unsigned char v1; int * v2; bool v3; };
struct __attribute__((packed)) aUc_L_B { unsigned char v1; long long v2; bool v3; };
struct __attribute__((packed)) aUc_S_B { unsigned char v1; short v2; bool v3; };
struct __attribute__((packed)) aUc_Uc_B { unsigned char v1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aUc_Ui_B { unsigned char v1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aUc_Ul_B { unsigned char v1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aUc_Us_B { unsigned char v1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aUc_Vp_B { unsigned char v1; void * v2; bool v3; };
struct __attribute__((packed)) aUi_B { unsigned int v1; bool v2; };
struct __attribute__((packed)) aUi_B_B { unsigned int v1; bool v2; bool v3; };
struct __attribute__((packed)) aUi_B_BFu15i { unsigned int v1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_B_BFu15ll { unsigned int v1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_B_BFu15s { unsigned int v1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_B_BFu16i { unsigned int v1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_B_BFu16ll { unsigned int v1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_B_BFu16s { unsigned int v1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_B_BFu17i { unsigned int v1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_B_BFu17ll { unsigned int v1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_B_BFu1c { unsigned int v1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_B_BFu1i { unsigned int v1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_B_BFu1ll { unsigned int v1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_B_BFu1s { unsigned int v1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_B_BFu31i { unsigned int v1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_B_BFu31ll { unsigned int v1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_B_BFu32i { unsigned int v1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_B_BFu32ll { unsigned int v1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_B_BFu33 { unsigned int v1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_B_BFu7c { unsigned int v1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_B_BFu7i { unsigned int v1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_B_BFu7ll { unsigned int v1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_B_BFu7s { unsigned int v1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_B_BFu8c { unsigned int v1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_B_BFu8i { unsigned int v1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_B_BFu8ll { unsigned int v1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_B_BFu8s { unsigned int v1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_B_BFu9i { unsigned int v1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_B_BFu9ll { unsigned int v1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_B_BFu9s { unsigned int v1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_B_C { unsigned int v1; bool v2; char v3; };
struct __attribute__((packed)) aUi_B_D { unsigned int v1; bool v2; double v3; };
struct __attribute__((packed)) aUi_B_F { unsigned int v1; bool v2; float v3; };
struct __attribute__((packed)) aUi_B_I { unsigned int v1; bool v2; int v3; };
struct __attribute__((packed)) aUi_B_Ip { unsigned int v1; bool v2; int * v3; };
struct __attribute__((packed)) aUi_B_L { unsigned int v1; bool v2; long long v3; };
struct __attribute__((packed)) aUi_B_S { unsigned int v1; bool v2; short v3; };
struct __attribute__((packed)) aUi_B_Uc { unsigned int v1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aUi_B_Ui { unsigned int v1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aUi_B_Ul { unsigned int v1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_B_Us { unsigned int v1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aUi_B_Vp { unsigned int v1; bool v2; void * v3; };
struct __attribute__((packed)) aUi_BFu15i_B { unsigned int v1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aUi_BFu15ll_B { unsigned int v1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aUi_BFu15s_B { unsigned int v1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aUi_BFu16i_B { unsigned int v1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aUi_BFu16ll_B { unsigned int v1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aUi_BFu16s_B { unsigned int v1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aUi_BFu17i_B { unsigned int v1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aUi_BFu17ll_B { unsigned int v1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aUi_BFu1c_B { unsigned int v1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aUi_BFu1i_B { unsigned int v1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aUi_BFu1ll_B { unsigned int v1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aUi_BFu1s_B { unsigned int v1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aUi_BFu31i_B { unsigned int v1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aUi_BFu31ll_B { unsigned int v1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aUi_BFu32i_B { unsigned int v1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aUi_BFu32ll_B { unsigned int v1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aUi_BFu33_B { unsigned int v1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aUi_BFu7c_B { unsigned int v1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aUi_BFu7i_B { unsigned int v1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aUi_BFu7ll_B { unsigned int v1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aUi_BFu7s_B { unsigned int v1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aUi_BFu8c_B { unsigned int v1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aUi_BFu8i_B { unsigned int v1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aUi_BFu8ll_B { unsigned int v1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aUi_BFu8s_B { unsigned int v1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aUi_BFu9i_B { unsigned int v1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aUi_BFu9ll_B { unsigned int v1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aUi_BFu9s_B { unsigned int v1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aUi_C_B { unsigned int v1; char v2; bool v3; };
struct __attribute__((packed)) aUi_D_B { unsigned int v1; double v2; bool v3; };
struct __attribute__((packed)) aUi_F_B { unsigned int v1; float v2; bool v3; };
struct __attribute__((packed)) aUi_I_B { unsigned int v1; int v2; bool v3; };
struct __attribute__((packed)) aUi_Ip_B { unsigned int v1; int * v2; bool v3; };
struct __attribute__((packed)) aUi_L_B { unsigned int v1; long long v2; bool v3; };
struct __attribute__((packed)) aUi_S_B { unsigned int v1; short v2; bool v3; };
struct __attribute__((packed)) aUi_Uc_B { unsigned int v1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aUi_Ui_B { unsigned int v1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aUi_Ul_B { unsigned int v1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aUi_Us_B { unsigned int v1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aUi_Vp_B { unsigned int v1; void * v2; bool v3; };
struct __attribute__((packed)) aUl_B { unsigned long long v1; bool v2; };
struct __attribute__((packed)) aUl_B_B { unsigned long long v1; bool v2; bool v3; };
struct __attribute__((packed)) aUl_B_BFu15i { unsigned long long v1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_B_BFu15ll { unsigned long long v1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_B_BFu15s { unsigned long long v1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_B_BFu16i { unsigned long long v1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_B_BFu16ll { unsigned long long v1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_B_BFu16s { unsigned long long v1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_B_BFu17i { unsigned long long v1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_B_BFu17ll { unsigned long long v1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_B_BFu1c { unsigned long long v1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_B_BFu1i { unsigned long long v1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_B_BFu1ll { unsigned long long v1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_B_BFu1s { unsigned long long v1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_B_BFu31i { unsigned long long v1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_B_BFu31ll { unsigned long long v1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_B_BFu32i { unsigned long long v1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_B_BFu32ll { unsigned long long v1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_B_BFu33 { unsigned long long v1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_B_BFu7c { unsigned long long v1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_B_BFu7i { unsigned long long v1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_B_BFu7ll { unsigned long long v1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_B_BFu7s { unsigned long long v1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_B_BFu8c { unsigned long long v1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_B_BFu8i { unsigned long long v1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_B_BFu8ll { unsigned long long v1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_B_BFu8s { unsigned long long v1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_B_BFu9i { unsigned long long v1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_B_BFu9ll { unsigned long long v1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_B_BFu9s { unsigned long long v1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_B_C { unsigned long long v1; bool v2; char v3; };
struct __attribute__((packed)) aUl_B_D { unsigned long long v1; bool v2; double v3; };
struct __attribute__((packed)) aUl_B_F { unsigned long long v1; bool v2; float v3; };
struct __attribute__((packed)) aUl_B_I { unsigned long long v1; bool v2; int v3; };
struct __attribute__((packed)) aUl_B_Ip { unsigned long long v1; bool v2; int * v3; };
struct __attribute__((packed)) aUl_B_L { unsigned long long v1; bool v2; long long v3; };
struct __attribute__((packed)) aUl_B_S { unsigned long long v1; bool v2; short v3; };
struct __attribute__((packed)) aUl_B_Uc { unsigned long long v1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aUl_B_Ui { unsigned long long v1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aUl_B_Ul { unsigned long long v1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_B_Us { unsigned long long v1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aUl_B_Vp { unsigned long long v1; bool v2; void * v3; };
struct __attribute__((packed)) aUl_BFu15i_B { unsigned long long v1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aUl_BFu15ll_B { unsigned long long v1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aUl_BFu15s_B { unsigned long long v1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aUl_BFu16i_B { unsigned long long v1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aUl_BFu16ll_B { unsigned long long v1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aUl_BFu16s_B { unsigned long long v1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aUl_BFu17i_B { unsigned long long v1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aUl_BFu17ll_B { unsigned long long v1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aUl_BFu1c_B { unsigned long long v1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aUl_BFu1i_B { unsigned long long v1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aUl_BFu1ll_B { unsigned long long v1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aUl_BFu1s_B { unsigned long long v1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aUl_BFu31i_B { unsigned long long v1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aUl_BFu31ll_B { unsigned long long v1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aUl_BFu32i_B { unsigned long long v1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aUl_BFu32ll_B { unsigned long long v1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aUl_BFu33_B { unsigned long long v1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aUl_BFu7c_B { unsigned long long v1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aUl_BFu7i_B { unsigned long long v1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aUl_BFu7ll_B { unsigned long long v1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aUl_BFu7s_B { unsigned long long v1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aUl_BFu8c_B { unsigned long long v1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aUl_BFu8i_B { unsigned long long v1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aUl_BFu8ll_B { unsigned long long v1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aUl_BFu8s_B { unsigned long long v1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aUl_BFu9i_B { unsigned long long v1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aUl_BFu9ll_B { unsigned long long v1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aUl_BFu9s_B { unsigned long long v1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aUl_C_B { unsigned long long v1; char v2; bool v3; };
struct __attribute__((packed)) aUl_D_B { unsigned long long v1; double v2; bool v3; };
struct __attribute__((packed)) aUl_F_B { unsigned long long v1; float v2; bool v3; };
struct __attribute__((packed)) aUl_I_B { unsigned long long v1; int v2; bool v3; };
struct __attribute__((packed)) aUl_Ip_B { unsigned long long v1; int * v2; bool v3; };
struct __attribute__((packed)) aUl_L_B { unsigned long long v1; long long v2; bool v3; };
struct __attribute__((packed)) aUl_S_B { unsigned long long v1; short v2; bool v3; };
struct __attribute__((packed)) aUl_Uc_B { unsigned long long v1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aUl_Ui_B { unsigned long long v1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aUl_Ul_B { unsigned long long v1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aUl_Us_B { unsigned long long v1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aUl_Vp_B { unsigned long long v1; void * v2; bool v3; };
struct __attribute__((packed)) aUs_B { unsigned short v1; bool v2; };
struct __attribute__((packed)) aUs_B_B { unsigned short v1; bool v2; bool v3; };
struct __attribute__((packed)) aUs_B_BFu15i { unsigned short v1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_B_BFu15ll { unsigned short v1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_B_BFu15s { unsigned short v1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_B_BFu16i { unsigned short v1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_B_BFu16ll { unsigned short v1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_B_BFu16s { unsigned short v1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_B_BFu17i { unsigned short v1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_B_BFu17ll { unsigned short v1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_B_BFu1c { unsigned short v1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_B_BFu1i { unsigned short v1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_B_BFu1ll { unsigned short v1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_B_BFu1s { unsigned short v1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_B_BFu31i { unsigned short v1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_B_BFu31ll { unsigned short v1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_B_BFu32i { unsigned short v1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_B_BFu32ll { unsigned short v1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_B_BFu33 { unsigned short v1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_B_BFu7c { unsigned short v1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_B_BFu7i { unsigned short v1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_B_BFu7ll { unsigned short v1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_B_BFu7s { unsigned short v1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_B_BFu8c { unsigned short v1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_B_BFu8i { unsigned short v1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_B_BFu8ll { unsigned short v1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_B_BFu8s { unsigned short v1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_B_BFu9i { unsigned short v1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_B_BFu9ll { unsigned short v1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_B_BFu9s { unsigned short v1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_B_C { unsigned short v1; bool v2; char v3; };
struct __attribute__((packed)) aUs_B_D { unsigned short v1; bool v2; double v3; };
struct __attribute__((packed)) aUs_B_F { unsigned short v1; bool v2; float v3; };
struct __attribute__((packed)) aUs_B_I { unsigned short v1; bool v2; int v3; };
struct __attribute__((packed)) aUs_B_Ip { unsigned short v1; bool v2; int * v3; };
struct __attribute__((packed)) aUs_B_L { unsigned short v1; bool v2; long long v3; };
struct __attribute__((packed)) aUs_B_S { unsigned short v1; bool v2; short v3; };
struct __attribute__((packed)) aUs_B_Uc { unsigned short v1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aUs_B_Ui { unsigned short v1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aUs_B_Ul { unsigned short v1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_B_Us { unsigned short v1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aUs_B_Vp { unsigned short v1; bool v2; void * v3; };
struct __attribute__((packed)) aUs_BFu15i_B { unsigned short v1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aUs_BFu15ll_B { unsigned short v1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aUs_BFu15s_B { unsigned short v1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aUs_BFu16i_B { unsigned short v1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aUs_BFu16ll_B { unsigned short v1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aUs_BFu16s_B { unsigned short v1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aUs_BFu17i_B { unsigned short v1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aUs_BFu17ll_B { unsigned short v1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aUs_BFu1c_B { unsigned short v1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aUs_BFu1i_B { unsigned short v1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aUs_BFu1ll_B { unsigned short v1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aUs_BFu1s_B { unsigned short v1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aUs_BFu31i_B { unsigned short v1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aUs_BFu31ll_B { unsigned short v1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aUs_BFu32i_B { unsigned short v1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aUs_BFu32ll_B { unsigned short v1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aUs_BFu33_B { unsigned short v1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aUs_BFu7c_B { unsigned short v1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aUs_BFu7i_B { unsigned short v1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aUs_BFu7ll_B { unsigned short v1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aUs_BFu7s_B { unsigned short v1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aUs_BFu8c_B { unsigned short v1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aUs_BFu8i_B { unsigned short v1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aUs_BFu8ll_B { unsigned short v1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aUs_BFu8s_B { unsigned short v1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aUs_BFu9i_B { unsigned short v1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aUs_BFu9ll_B { unsigned short v1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aUs_BFu9s_B { unsigned short v1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aUs_C_B { unsigned short v1; char v2; bool v3; };
struct __attribute__((packed)) aUs_D_B { unsigned short v1; double v2; bool v3; };
struct __attribute__((packed)) aUs_F_B { unsigned short v1; float v2; bool v3; };
struct __attribute__((packed)) aUs_I_B { unsigned short v1; int v2; bool v3; };
struct __attribute__((packed)) aUs_Ip_B { unsigned short v1; int * v2; bool v3; };
struct __attribute__((packed)) aUs_L_B { unsigned short v1; long long v2; bool v3; };
struct __attribute__((packed)) aUs_S_B { unsigned short v1; short v2; bool v3; };
struct __attribute__((packed)) aUs_Uc_B { unsigned short v1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aUs_Ui_B { unsigned short v1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aUs_Ul_B { unsigned short v1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aUs_Us_B { unsigned short v1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aUs_Vp_B { unsigned short v1; void * v2; bool v3; };
struct __attribute__((packed)) aVp_B { void * v1; bool v2; };
struct __attribute__((packed)) aVp_B_B { void * v1; bool v2; bool v3; };
struct __attribute__((packed)) aVp_B_BFu15i { void * v1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_B_BFu15ll { void * v1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_B_BFu15s { void * v1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_B_BFu16i { void * v1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_B_BFu16ll { void * v1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_B_BFu16s { void * v1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_B_BFu17i { void * v1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_B_BFu17ll { void * v1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_B_BFu1c { void * v1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_B_BFu1i { void * v1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_B_BFu1ll { void * v1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_B_BFu1s { void * v1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_B_BFu31i { void * v1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_B_BFu31ll { void * v1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_B_BFu32i { void * v1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_B_BFu32ll { void * v1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_B_BFu33 { void * v1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_B_BFu7c { void * v1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_B_BFu7i { void * v1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_B_BFu7ll { void * v1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_B_BFu7s { void * v1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_B_BFu8c { void * v1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_B_BFu8i { void * v1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_B_BFu8ll { void * v1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_B_BFu8s { void * v1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_B_BFu9i { void * v1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_B_BFu9ll { void * v1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_B_BFu9s { void * v1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_B_C { void * v1; bool v2; char v3; };
struct __attribute__((packed)) aVp_B_D { void * v1; bool v2; double v3; };
struct __attribute__((packed)) aVp_B_F { void * v1; bool v2; float v3; };
struct __attribute__((packed)) aVp_B_I { void * v1; bool v2; int v3; };
struct __attribute__((packed)) aVp_B_Ip { void * v1; bool v2; int * v3; };
struct __attribute__((packed)) aVp_B_L { void * v1; bool v2; long long v3; };
struct __attribute__((packed)) aVp_B_S { void * v1; bool v2; short v3; };
struct __attribute__((packed)) aVp_B_Uc { void * v1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aVp_B_Ui { void * v1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aVp_B_Ul { void * v1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_B_Us { void * v1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aVp_B_Vp { void * v1; bool v2; void * v3; };
struct __attribute__((packed)) aVp_BFu15i_B { void * v1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aVp_BFu15ll_B { void * v1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aVp_BFu15s_B { void * v1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aVp_BFu16i_B { void * v1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aVp_BFu16ll_B { void * v1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aVp_BFu16s_B { void * v1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aVp_BFu17i_B { void * v1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aVp_BFu17ll_B { void * v1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aVp_BFu1c_B { void * v1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aVp_BFu1i_B { void * v1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aVp_BFu1ll_B { void * v1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aVp_BFu1s_B { void * v1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aVp_BFu31i_B { void * v1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aVp_BFu31ll_B { void * v1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aVp_BFu32i_B { void * v1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aVp_BFu32ll_B { void * v1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aVp_BFu33_B { void * v1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aVp_BFu7c_B { void * v1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aVp_BFu7i_B { void * v1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aVp_BFu7ll_B { void * v1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aVp_BFu7s_B { void * v1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aVp_BFu8c_B { void * v1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aVp_BFu8i_B { void * v1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aVp_BFu8ll_B { void * v1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aVp_BFu8s_B { void * v1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aVp_BFu9i_B { void * v1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aVp_BFu9ll_B { void * v1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aVp_BFu9s_B { void * v1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aVp_C_B { void * v1; char v2; bool v3; };
struct __attribute__((packed)) aVp_D_B { void * v1; double v2; bool v3; };
struct __attribute__((packed)) aVp_F_B { void * v1; float v2; bool v3; };
struct __attribute__((packed)) aVp_I_B { void * v1; int v2; bool v3; };
struct __attribute__((packed)) aVp_Ip_B { void * v1; int * v2; bool v3; };
struct __attribute__((packed)) aVp_L_B { void * v1; long long v2; bool v3; };
struct __attribute__((packed)) aVp_S_B { void * v1; short v2; bool v3; };
struct __attribute__((packed)) aVp_Uc_B { void * v1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aVp_Ui_B { void * v1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aVp_Ul_B { void * v1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aVp_Us_B { void * v1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aVp_Vp_B { void * v1; void * v2; bool v3; };
#pragma pack(1)
struct B { bool v1; };
struct B_B { bool v1; bool v2; };
struct B_B_B { bool v1; bool v2; bool v3; };
struct B_B_BFu15i { bool v1; bool v2; unsigned int v3:15; };
struct B_B_BFu15ll { bool v1; bool v2; unsigned long long v3:15; };
struct B_B_BFu15s { bool v1; bool v2; unsigned short v3:15; };
struct B_B_BFu16i { bool v1; bool v2; unsigned int v3:16; };
struct B_B_BFu16ll { bool v1; bool v2; unsigned long long v3:16; };
struct B_B_BFu16s { bool v1; bool v2; unsigned short v3:16; };
struct B_B_BFu17i { bool v1; bool v2; unsigned int v3:17; };
struct B_B_BFu17ll { bool v1; bool v2; unsigned long long v3:17; };
struct B_B_BFu1c { bool v1; bool v2; unsigned char v3:1; };
struct B_B_BFu1i { bool v1; bool v2; unsigned int v3:1; };
struct B_B_BFu1ll { bool v1; bool v2; unsigned long long v3:1; };
struct B_B_BFu1s { bool v1; bool v2; unsigned short v3:1; };
struct B_B_BFu31i { bool v1; bool v2; unsigned int v3:31; };
struct B_B_BFu31ll { bool v1; bool v2; unsigned long long v3:31; };
struct B_B_BFu32i { bool v1; bool v2; unsigned int v3:32; };
struct B_B_BFu32ll { bool v1; bool v2; unsigned long long v3:32; };
struct B_B_BFu33 { bool v1; bool v2; unsigned long long v3:33; };
struct B_B_BFu7c { bool v1; bool v2; unsigned char v3:7; };
struct B_B_BFu7i { bool v1; bool v2; unsigned int v3:7; };
struct B_B_BFu7ll { bool v1; bool v2; unsigned long long v3:7; };
struct B_B_BFu7s { bool v1; bool v2; unsigned short v3:7; };
struct B_B_BFu8c { bool v1; bool v2; unsigned char v3:8; };
struct B_B_BFu8i { bool v1; bool v2; unsigned int v3:8; };
struct B_B_BFu8ll { bool v1; bool v2; unsigned long long v3:8; };
struct B_B_BFu8s { bool v1; bool v2; unsigned short v3:8; };
struct B_B_BFu9i { bool v1; bool v2; unsigned int v3:9; };
struct B_B_BFu9ll { bool v1; bool v2; unsigned long long v3:9; };
struct B_B_BFu9s { bool v1; bool v2; unsigned short v3:9; };
struct B_B_C { bool v1; bool v2; char v3; };
struct B_B_D { bool v1; bool v2; double v3; };
struct B_B_F { bool v1; bool v2; float v3; };
struct B_B_I { bool v1; bool v2; int v3; };
struct B_B_Ip { bool v1; bool v2; int * v3; };
struct B_B_L { bool v1; bool v2; long long v3; };
struct B_B_S { bool v1; bool v2; short v3; };
struct B_B_Uc { bool v1; bool v2; unsigned char v3; };
struct B_B_Ui { bool v1; bool v2; unsigned int v3; };
struct B_B_Ul { bool v1; bool v2; unsigned long long v3; };
struct B_B_Us { bool v1; bool v2; unsigned short v3; };
struct B_B_Vp { bool v1; bool v2; void * v3; };
struct B_BFu15i { bool v1; unsigned int v2:15; };
struct B_BFu15i_B { bool v1; unsigned int v2:15; bool v3; };
struct B_BFu15i_BFu15i { bool v1; unsigned int v2:15; unsigned int v3:15; };
struct B_BFu15i_BFu15ll { bool v1; unsigned int v2:15; unsigned long long v3:15; };
struct B_BFu15i_BFu15s { bool v1; unsigned int v2:15; unsigned short v3:15; };
struct B_BFu15i_BFu16i { bool v1; unsigned int v2:15; unsigned int v3:16; };
struct B_BFu15i_BFu16ll { bool v1; unsigned int v2:15; unsigned long long v3:16; };
struct B_BFu15i_BFu16s { bool v1; unsigned int v2:15; unsigned short v3:16; };
struct B_BFu15i_BFu17i { bool v1; unsigned int v2:15; unsigned int v3:17; };
struct B_BFu15i_BFu17ll { bool v1; unsigned int v2:15; unsigned long long v3:17; };
struct B_BFu15i_BFu1c { bool v1; unsigned int v2:15; unsigned char v3:1; };
struct B_BFu15i_BFu1i { bool v1; unsigned int v2:15; unsigned int v3:1; };
struct B_BFu15i_BFu1ll { bool v1; unsigned int v2:15; unsigned long long v3:1; };
struct B_BFu15i_BFu1s { bool v1; unsigned int v2:15; unsigned short v3:1; };
struct B_BFu15i_BFu31i { bool v1; unsigned int v2:15; unsigned int v3:31; };
struct B_BFu15i_BFu31ll { bool v1; unsigned int v2:15; unsigned long long v3:31; };
struct B_BFu15i_BFu32i { bool v1; unsigned int v2:15; unsigned int v3:32; };
struct B_BFu15i_BFu32ll { bool v1; unsigned int v2:15; unsigned long long v3:32; };
struct B_BFu15i_BFu33 { bool v1; unsigned int v2:15; unsigned long long v3:33; };
struct B_BFu15i_BFu7c { bool v1; unsigned int v2:15; unsigned char v3:7; };
struct B_BFu15i_BFu7i { bool v1; unsigned int v2:15; unsigned int v3:7; };
struct B_BFu15i_BFu7ll { bool v1; unsigned int v2:15; unsigned long long v3:7; };
struct B_BFu15i_BFu7s { bool v1; unsigned int v2:15; unsigned short v3:7; };
struct B_BFu15i_BFu8c { bool v1; unsigned int v2:15; unsigned char v3:8; };
struct B_BFu15i_BFu8i { bool v1; unsigned int v2:15; unsigned int v3:8; };
struct B_BFu15i_BFu8ll { bool v1; unsigned int v2:15; unsigned long long v3:8; };
struct B_BFu15i_BFu8s { bool v1; unsigned int v2:15; unsigned short v3:8; };
struct B_BFu15i_BFu9i { bool v1; unsigned int v2:15; unsigned int v3:9; };
struct B_BFu15i_BFu9ll { bool v1; unsigned int v2:15; unsigned long long v3:9; };
struct B_BFu15i_BFu9s { bool v1; unsigned int v2:15; unsigned short v3:9; };
struct B_BFu15i_C { bool v1; unsigned int v2:15; char v3; };
struct B_BFu15i_D { bool v1; unsigned int v2:15; double v3; };
struct B_BFu15i_F { bool v1; unsigned int v2:15; float v3; };
struct B_BFu15i_I { bool v1; unsigned int v2:15; int v3; };
struct B_BFu15i_Ip { bool v1; unsigned int v2:15; int * v3; };
struct B_BFu15i_L { bool v1; unsigned int v2:15; long long v3; };
struct B_BFu15i_S { bool v1; unsigned int v2:15; short v3; };
struct B_BFu15i_Uc { bool v1; unsigned int v2:15; unsigned char v3; };
struct B_BFu15i_Ui { bool v1; unsigned int v2:15; unsigned int v3; };
struct B_BFu15i_Ul { bool v1; unsigned int v2:15; unsigned long long v3; };
struct B_BFu15i_Us { bool v1; unsigned int v2:15; unsigned short v3; };
struct B_BFu15i_Vp { bool v1; unsigned int v2:15; void * v3; };
struct B_BFu15ll { bool v1; unsigned long long v2:15; };
struct B_BFu15ll_B { bool v1; unsigned long long v2:15; bool v3; };
struct B_BFu15ll_BFu15i { bool v1; unsigned long long v2:15; unsigned int v3:15; };
struct B_BFu15ll_BFu15ll { bool v1; unsigned long long v2:15; unsigned long long v3:15; };
struct B_BFu15ll_BFu15s { bool v1; unsigned long long v2:15; unsigned short v3:15; };
struct B_BFu15ll_BFu16i { bool v1; unsigned long long v2:15; unsigned int v3:16; };
struct B_BFu15ll_BFu16ll { bool v1; unsigned long long v2:15; unsigned long long v3:16; };
struct B_BFu15ll_BFu16s { bool v1; unsigned long long v2:15; unsigned short v3:16; };
struct B_BFu15ll_BFu17i { bool v1; unsigned long long v2:15; unsigned int v3:17; };
struct B_BFu15ll_BFu17ll { bool v1; unsigned long long v2:15; unsigned long long v3:17; };
struct B_BFu15ll_BFu1c { bool v1; unsigned long long v2:15; unsigned char v3:1; };
struct B_BFu15ll_BFu1i { bool v1; unsigned long long v2:15; unsigned int v3:1; };
struct B_BFu15ll_BFu1ll { bool v1; unsigned long long v2:15; unsigned long long v3:1; };
struct B_BFu15ll_BFu1s { bool v1; unsigned long long v2:15; unsigned short v3:1; };
struct B_BFu15ll_BFu31i { bool v1; unsigned long long v2:15; unsigned int v3:31; };
struct B_BFu15ll_BFu31ll { bool v1; unsigned long long v2:15; unsigned long long v3:31; };
struct B_BFu15ll_BFu32i { bool v1; unsigned long long v2:15; unsigned int v3:32; };
struct B_BFu15ll_BFu32ll { bool v1; unsigned long long v2:15; unsigned long long v3:32; };
struct B_BFu15ll_BFu33 { bool v1; unsigned long long v2:15; unsigned long long v3:33; };
struct B_BFu15ll_BFu7c { bool v1; unsigned long long v2:15; unsigned char v3:7; };
struct B_BFu15ll_BFu7i { bool v1; unsigned long long v2:15; unsigned int v3:7; };
struct B_BFu15ll_BFu7ll { bool v1; unsigned long long v2:15; unsigned long long v3:7; };
struct B_BFu15ll_BFu7s { bool v1; unsigned long long v2:15; unsigned short v3:7; };
struct B_BFu15ll_BFu8c { bool v1; unsigned long long v2:15; unsigned char v3:8; };
struct B_BFu15ll_BFu8i { bool v1; unsigned long long v2:15; unsigned int v3:8; };
struct B_BFu15ll_BFu8ll { bool v1; unsigned long long v2:15; unsigned long long v3:8; };
struct B_BFu15ll_BFu8s { bool v1; unsigned long long v2:15; unsigned short v3:8; };
struct B_BFu15ll_BFu9i { bool v1; unsigned long long v2:15; unsigned int v3:9; };
struct B_BFu15ll_BFu9ll { bool v1; unsigned long long v2:15; unsigned long long v3:9; };
struct B_BFu15ll_BFu9s { bool v1; unsigned long long v2:15; unsigned short v3:9; };
struct B_BFu15ll_C { bool v1; unsigned long long v2:15; char v3; };
struct B_BFu15ll_D { bool v1; unsigned long long v2:15; double v3; };
struct B_BFu15ll_F { bool v1; unsigned long long v2:15; float v3; };
struct B_BFu15ll_I { bool v1; unsigned long long v2:15; int v3; };
struct B_BFu15ll_Ip { bool v1; unsigned long long v2:15; int * v3; };
struct B_BFu15ll_L { bool v1; unsigned long long v2:15; long long v3; };
struct B_BFu15ll_S { bool v1; unsigned long long v2:15; short v3; };
struct B_BFu15ll_Uc { bool v1; unsigned long long v2:15; unsigned char v3; };
struct B_BFu15ll_Ui { bool v1; unsigned long long v2:15; unsigned int v3; };
struct B_BFu15ll_Ul { bool v1; unsigned long long v2:15; unsigned long long v3; };
struct B_BFu15ll_Us { bool v1; unsigned long long v2:15; unsigned short v3; };
struct B_BFu15ll_Vp { bool v1; unsigned long long v2:15; void * v3; };
struct B_BFu15s { bool v1; unsigned short v2:15; };
struct B_BFu15s_B { bool v1; unsigned short v2:15; bool v3; };
struct B_BFu15s_BFu15i { bool v1; unsigned short v2:15; unsigned int v3:15; };
struct B_BFu15s_BFu15ll { bool v1; unsigned short v2:15; unsigned long long v3:15; };
struct B_BFu15s_BFu15s { bool v1; unsigned short v2:15; unsigned short v3:15; };
struct B_BFu15s_BFu16i { bool v1; unsigned short v2:15; unsigned int v3:16; };
struct B_BFu15s_BFu16ll { bool v1; unsigned short v2:15; unsigned long long v3:16; };
struct B_BFu15s_BFu16s { bool v1; unsigned short v2:15; unsigned short v3:16; };
struct B_BFu15s_BFu17i { bool v1; unsigned short v2:15; unsigned int v3:17; };
struct B_BFu15s_BFu17ll { bool v1; unsigned short v2:15; unsigned long long v3:17; };
struct B_BFu15s_BFu1c { bool v1; unsigned short v2:15; unsigned char v3:1; };
struct B_BFu15s_BFu1i { bool v1; unsigned short v2:15; unsigned int v3:1; };
struct B_BFu15s_BFu1ll { bool v1; unsigned short v2:15; unsigned long long v3:1; };
struct B_BFu15s_BFu1s { bool v1; unsigned short v2:15; unsigned short v3:1; };
struct B_BFu15s_BFu31i { bool v1; unsigned short v2:15; unsigned int v3:31; };
struct B_BFu15s_BFu31ll { bool v1; unsigned short v2:15; unsigned long long v3:31; };
struct B_BFu15s_BFu32i { bool v1; unsigned short v2:15; unsigned int v3:32; };
struct B_BFu15s_BFu32ll { bool v1; unsigned short v2:15; unsigned long long v3:32; };
struct B_BFu15s_BFu33 { bool v1; unsigned short v2:15; unsigned long long v3:33; };
struct B_BFu15s_BFu7c { bool v1; unsigned short v2:15; unsigned char v3:7; };
struct B_BFu15s_BFu7i { bool v1; unsigned short v2:15; unsigned int v3:7; };
struct B_BFu15s_BFu7ll { bool v1; unsigned short v2:15; unsigned long long v3:7; };
struct B_BFu15s_BFu7s { bool v1; unsigned short v2:15; unsigned short v3:7; };
struct B_BFu15s_BFu8c { bool v1; unsigned short v2:15; unsigned char v3:8; };
struct B_BFu15s_BFu8i { bool v1; unsigned short v2:15; unsigned int v3:8; };
struct B_BFu15s_BFu8ll { bool v1; unsigned short v2:15; unsigned long long v3:8; };
struct B_BFu15s_BFu8s { bool v1; unsigned short v2:15; unsigned short v3:8; };
struct B_BFu15s_BFu9i { bool v1; unsigned short v2:15; unsigned int v3:9; };
struct B_BFu15s_BFu9ll { bool v1; unsigned short v2:15; unsigned long long v3:9; };
struct B_BFu15s_BFu9s { bool v1; unsigned short v2:15; unsigned short v3:9; };
struct B_BFu15s_C { bool v1; unsigned short v2:15; char v3; };
struct B_BFu15s_D { bool v1; unsigned short v2:15; double v3; };
struct B_BFu15s_F { bool v1; unsigned short v2:15; float v3; };
struct B_BFu15s_I { bool v1; unsigned short v2:15; int v3; };
struct B_BFu15s_Ip { bool v1; unsigned short v2:15; int * v3; };
struct B_BFu15s_L { bool v1; unsigned short v2:15; long long v3; };
struct B_BFu15s_S { bool v1; unsigned short v2:15; short v3; };
struct B_BFu15s_Uc { bool v1; unsigned short v2:15; unsigned char v3; };
struct B_BFu15s_Ui { bool v1; unsigned short v2:15; unsigned int v3; };
struct B_BFu15s_Ul { bool v1; unsigned short v2:15; unsigned long long v3; };
struct B_BFu15s_Us { bool v1; unsigned short v2:15; unsigned short v3; };
struct B_BFu15s_Vp { bool v1; unsigned short v2:15; void * v3; };
struct B_BFu16i { bool v1; unsigned int v2:16; };
struct B_BFu16i_B { bool v1; unsigned int v2:16; bool v3; };
struct B_BFu16i_BFu15i { bool v1; unsigned int v2:16; unsigned int v3:15; };
struct B_BFu16i_BFu15ll { bool v1; unsigned int v2:16; unsigned long long v3:15; };
struct B_BFu16i_BFu15s { bool v1; unsigned int v2:16; unsigned short v3:15; };
struct B_BFu16i_BFu16i { bool v1; unsigned int v2:16; unsigned int v3:16; };
struct B_BFu16i_BFu16ll { bool v1; unsigned int v2:16; unsigned long long v3:16; };
struct B_BFu16i_BFu16s { bool v1; unsigned int v2:16; unsigned short v3:16; };
struct B_BFu16i_BFu17i { bool v1; unsigned int v2:16; unsigned int v3:17; };
struct B_BFu16i_BFu17ll { bool v1; unsigned int v2:16; unsigned long long v3:17; };
struct B_BFu16i_BFu1c { bool v1; unsigned int v2:16; unsigned char v3:1; };
struct B_BFu16i_BFu1i { bool v1; unsigned int v2:16; unsigned int v3:1; };
struct B_BFu16i_BFu1ll { bool v1; unsigned int v2:16; unsigned long long v3:1; };
struct B_BFu16i_BFu1s { bool v1; unsigned int v2:16; unsigned short v3:1; };
struct B_BFu16i_BFu31i { bool v1; unsigned int v2:16; unsigned int v3:31; };
struct B_BFu16i_BFu31ll { bool v1; unsigned int v2:16; unsigned long long v3:31; };
struct B_BFu16i_BFu32i { bool v1; unsigned int v2:16; unsigned int v3:32; };
struct B_BFu16i_BFu32ll { bool v1; unsigned int v2:16; unsigned long long v3:32; };
struct B_BFu16i_BFu33 { bool v1; unsigned int v2:16; unsigned long long v3:33; };
struct B_BFu16i_BFu7c { bool v1; unsigned int v2:16; unsigned char v3:7; };
struct B_BFu16i_BFu7i { bool v1; unsigned int v2:16; unsigned int v3:7; };
struct B_BFu16i_BFu7ll { bool v1; unsigned int v2:16; unsigned long long v3:7; };
struct B_BFu16i_BFu7s { bool v1; unsigned int v2:16; unsigned short v3:7; };
struct B_BFu16i_BFu8c { bool v1; unsigned int v2:16; unsigned char v3:8; };
struct B_BFu16i_BFu8i { bool v1; unsigned int v2:16; unsigned int v3:8; };
struct B_BFu16i_BFu8ll { bool v1; unsigned int v2:16; unsigned long long v3:8; };
struct B_BFu16i_BFu8s { bool v1; unsigned int v2:16; unsigned short v3:8; };
struct B_BFu16i_BFu9i { bool v1; unsigned int v2:16; unsigned int v3:9; };
struct B_BFu16i_BFu9ll { bool v1; unsigned int v2:16; unsigned long long v3:9; };
struct B_BFu16i_BFu9s { bool v1; unsigned int v2:16; unsigned short v3:9; };
struct B_BFu16i_C { bool v1; unsigned int v2:16; char v3; };
struct B_BFu16i_D { bool v1; unsigned int v2:16; double v3; };
struct B_BFu16i_F { bool v1; unsigned int v2:16; float v3; };
struct B_BFu16i_I { bool v1; unsigned int v2:16; int v3; };
struct B_BFu16i_Ip { bool v1; unsigned int v2:16; int * v3; };
struct B_BFu16i_L { bool v1; unsigned int v2:16; long long v3; };
struct B_BFu16i_S { bool v1; unsigned int v2:16; short v3; };
struct B_BFu16i_Uc { bool v1; unsigned int v2:16; unsigned char v3; };
struct B_BFu16i_Ui { bool v1; unsigned int v2:16; unsigned int v3; };
struct B_BFu16i_Ul { bool v1; unsigned int v2:16; unsigned long long v3; };
struct B_BFu16i_Us { bool v1; unsigned int v2:16; unsigned short v3; };
struct B_BFu16i_Vp { bool v1; unsigned int v2:16; void * v3; };
struct B_BFu16ll { bool v1; unsigned long long v2:16; };
struct B_BFu16ll_B { bool v1; unsigned long long v2:16; bool v3; };
struct B_BFu16ll_BFu15i { bool v1; unsigned long long v2:16; unsigned int v3:15; };
struct B_BFu16ll_BFu15ll { bool v1; unsigned long long v2:16; unsigned long long v3:15; };
struct B_BFu16ll_BFu15s { bool v1; unsigned long long v2:16; unsigned short v3:15; };
struct B_BFu16ll_BFu16i { bool v1; unsigned long long v2:16; unsigned int v3:16; };
struct B_BFu16ll_BFu16ll { bool v1; unsigned long long v2:16; unsigned long long v3:16; };
struct B_BFu16ll_BFu16s { bool v1; unsigned long long v2:16; unsigned short v3:16; };
struct B_BFu16ll_BFu17i { bool v1; unsigned long long v2:16; unsigned int v3:17; };
struct B_BFu16ll_BFu17ll { bool v1; unsigned long long v2:16; unsigned long long v3:17; };
struct B_BFu16ll_BFu1c { bool v1; unsigned long long v2:16; unsigned char v3:1; };
struct B_BFu16ll_BFu1i { bool v1; unsigned long long v2:16; unsigned int v3:1; };
struct B_BFu16ll_BFu1ll { bool v1; unsigned long long v2:16; unsigned long long v3:1; };
struct B_BFu16ll_BFu1s { bool v1; unsigned long long v2:16; unsigned short v3:1; };
struct B_BFu16ll_BFu31i { bool v1; unsigned long long v2:16; unsigned int v3:31; };
struct B_BFu16ll_BFu31ll { bool v1; unsigned long long v2:16; unsigned long long v3:31; };
struct B_BFu16ll_BFu32i { bool v1; unsigned long long v2:16; unsigned int v3:32; };
struct B_BFu16ll_BFu32ll { bool v1; unsigned long long v2:16; unsigned long long v3:32; };
struct B_BFu16ll_BFu33 { bool v1; unsigned long long v2:16; unsigned long long v3:33; };
struct B_BFu16ll_BFu7c { bool v1; unsigned long long v2:16; unsigned char v3:7; };
struct B_BFu16ll_BFu7i { bool v1; unsigned long long v2:16; unsigned int v3:7; };
struct B_BFu16ll_BFu7ll { bool v1; unsigned long long v2:16; unsigned long long v3:7; };
struct B_BFu16ll_BFu7s { bool v1; unsigned long long v2:16; unsigned short v3:7; };
struct B_BFu16ll_BFu8c { bool v1; unsigned long long v2:16; unsigned char v3:8; };
struct B_BFu16ll_BFu8i { bool v1; unsigned long long v2:16; unsigned int v3:8; };
struct B_BFu16ll_BFu8ll { bool v1; unsigned long long v2:16; unsigned long long v3:8; };
struct B_BFu16ll_BFu8s { bool v1; unsigned long long v2:16; unsigned short v3:8; };
struct B_BFu16ll_BFu9i { bool v1; unsigned long long v2:16; unsigned int v3:9; };
struct B_BFu16ll_BFu9ll { bool v1; unsigned long long v2:16; unsigned long long v3:9; };
struct B_BFu16ll_BFu9s { bool v1; unsigned long long v2:16; unsigned short v3:9; };
struct B_BFu16ll_C { bool v1; unsigned long long v2:16; char v3; };
struct B_BFu16ll_D { bool v1; unsigned long long v2:16; double v3; };
struct B_BFu16ll_F { bool v1; unsigned long long v2:16; float v3; };
struct B_BFu16ll_I { bool v1; unsigned long long v2:16; int v3; };
struct B_BFu16ll_Ip { bool v1; unsigned long long v2:16; int * v3; };
struct B_BFu16ll_L { bool v1; unsigned long long v2:16; long long v3; };
struct B_BFu16ll_S { bool v1; unsigned long long v2:16; short v3; };
struct B_BFu16ll_Uc { bool v1; unsigned long long v2:16; unsigned char v3; };
struct B_BFu16ll_Ui { bool v1; unsigned long long v2:16; unsigned int v3; };
struct B_BFu16ll_Ul { bool v1; unsigned long long v2:16; unsigned long long v3; };
struct B_BFu16ll_Us { bool v1; unsigned long long v2:16; unsigned short v3; };
struct B_BFu16ll_Vp { bool v1; unsigned long long v2:16; void * v3; };
struct B_BFu16s { bool v1; unsigned short v2:16; };
struct B_BFu16s_B { bool v1; unsigned short v2:16; bool v3; };
struct B_BFu16s_BFu15i { bool v1; unsigned short v2:16; unsigned int v3:15; };
struct B_BFu16s_BFu15ll { bool v1; unsigned short v2:16; unsigned long long v3:15; };
struct B_BFu16s_BFu15s { bool v1; unsigned short v2:16; unsigned short v3:15; };
struct B_BFu16s_BFu16i { bool v1; unsigned short v2:16; unsigned int v3:16; };
struct B_BFu16s_BFu16ll { bool v1; unsigned short v2:16; unsigned long long v3:16; };
struct B_BFu16s_BFu16s { bool v1; unsigned short v2:16; unsigned short v3:16; };
struct B_BFu16s_BFu17i { bool v1; unsigned short v2:16; unsigned int v3:17; };
struct B_BFu16s_BFu17ll { bool v1; unsigned short v2:16; unsigned long long v3:17; };
struct B_BFu16s_BFu1c { bool v1; unsigned short v2:16; unsigned char v3:1; };
struct B_BFu16s_BFu1i { bool v1; unsigned short v2:16; unsigned int v3:1; };
struct B_BFu16s_BFu1ll { bool v1; unsigned short v2:16; unsigned long long v3:1; };
struct B_BFu16s_BFu1s { bool v1; unsigned short v2:16; unsigned short v3:1; };
struct B_BFu16s_BFu31i { bool v1; unsigned short v2:16; unsigned int v3:31; };
struct B_BFu16s_BFu31ll { bool v1; unsigned short v2:16; unsigned long long v3:31; };
struct B_BFu16s_BFu32i { bool v1; unsigned short v2:16; unsigned int v3:32; };
struct B_BFu16s_BFu32ll { bool v1; unsigned short v2:16; unsigned long long v3:32; };
struct B_BFu16s_BFu33 { bool v1; unsigned short v2:16; unsigned long long v3:33; };
struct B_BFu16s_BFu7c { bool v1; unsigned short v2:16; unsigned char v3:7; };
struct B_BFu16s_BFu7i { bool v1; unsigned short v2:16; unsigned int v3:7; };
struct B_BFu16s_BFu7ll { bool v1; unsigned short v2:16; unsigned long long v3:7; };
struct B_BFu16s_BFu7s { bool v1; unsigned short v2:16; unsigned short v3:7; };
struct B_BFu16s_BFu8c { bool v1; unsigned short v2:16; unsigned char v3:8; };
struct B_BFu16s_BFu8i { bool v1; unsigned short v2:16; unsigned int v3:8; };
struct B_BFu16s_BFu8ll { bool v1; unsigned short v2:16; unsigned long long v3:8; };
struct B_BFu16s_BFu8s { bool v1; unsigned short v2:16; unsigned short v3:8; };
struct B_BFu16s_BFu9i { bool v1; unsigned short v2:16; unsigned int v3:9; };
struct B_BFu16s_BFu9ll { bool v1; unsigned short v2:16; unsigned long long v3:9; };
struct B_BFu16s_BFu9s { bool v1; unsigned short v2:16; unsigned short v3:9; };
struct B_BFu16s_C { bool v1; unsigned short v2:16; char v3; };
struct B_BFu16s_D { bool v1; unsigned short v2:16; double v3; };
struct B_BFu16s_F { bool v1; unsigned short v2:16; float v3; };
struct B_BFu16s_I { bool v1; unsigned short v2:16; int v3; };
struct B_BFu16s_Ip { bool v1; unsigned short v2:16; int * v3; };
struct B_BFu16s_L { bool v1; unsigned short v2:16; long long v3; };
struct B_BFu16s_S { bool v1; unsigned short v2:16; short v3; };
struct B_BFu16s_Uc { bool v1; unsigned short v2:16; unsigned char v3; };
struct B_BFu16s_Ui { bool v1; unsigned short v2:16; unsigned int v3; };
struct B_BFu16s_Ul { bool v1; unsigned short v2:16; unsigned long long v3; };
struct B_BFu16s_Us { bool v1; unsigned short v2:16; unsigned short v3; };
struct B_BFu16s_Vp { bool v1; unsigned short v2:16; void * v3; };
struct B_BFu17i { bool v1; unsigned int v2:17; };
struct B_BFu17i_B { bool v1; unsigned int v2:17; bool v3; };
struct B_BFu17i_BFu15i { bool v1; unsigned int v2:17; unsigned int v3:15; };
struct B_BFu17i_BFu15ll { bool v1; unsigned int v2:17; unsigned long long v3:15; };
struct B_BFu17i_BFu15s { bool v1; unsigned int v2:17; unsigned short v3:15; };
struct B_BFu17i_BFu16i { bool v1; unsigned int v2:17; unsigned int v3:16; };
struct B_BFu17i_BFu16ll { bool v1; unsigned int v2:17; unsigned long long v3:16; };
struct B_BFu17i_BFu16s { bool v1; unsigned int v2:17; unsigned short v3:16; };
struct B_BFu17i_BFu17i { bool v1; unsigned int v2:17; unsigned int v3:17; };
struct B_BFu17i_BFu17ll { bool v1; unsigned int v2:17; unsigned long long v3:17; };
struct B_BFu17i_BFu1c { bool v1; unsigned int v2:17; unsigned char v3:1; };
struct B_BFu17i_BFu1i { bool v1; unsigned int v2:17; unsigned int v3:1; };
struct B_BFu17i_BFu1ll { bool v1; unsigned int v2:17; unsigned long long v3:1; };
struct B_BFu17i_BFu1s { bool v1; unsigned int v2:17; unsigned short v3:1; };
struct B_BFu17i_BFu31i { bool v1; unsigned int v2:17; unsigned int v3:31; };
struct B_BFu17i_BFu31ll { bool v1; unsigned int v2:17; unsigned long long v3:31; };
struct B_BFu17i_BFu32i { bool v1; unsigned int v2:17; unsigned int v3:32; };
struct B_BFu17i_BFu32ll { bool v1; unsigned int v2:17; unsigned long long v3:32; };
struct B_BFu17i_BFu33 { bool v1; unsigned int v2:17; unsigned long long v3:33; };
struct B_BFu17i_BFu7c { bool v1; unsigned int v2:17; unsigned char v3:7; };
struct B_BFu17i_BFu7i { bool v1; unsigned int v2:17; unsigned int v3:7; };
struct B_BFu17i_BFu7ll { bool v1; unsigned int v2:17; unsigned long long v3:7; };
struct B_BFu17i_BFu7s { bool v1; unsigned int v2:17; unsigned short v3:7; };
struct B_BFu17i_BFu8c { bool v1; unsigned int v2:17; unsigned char v3:8; };
struct B_BFu17i_BFu8i { bool v1; unsigned int v2:17; unsigned int v3:8; };
struct B_BFu17i_BFu8ll { bool v1; unsigned int v2:17; unsigned long long v3:8; };
struct B_BFu17i_BFu8s { bool v1; unsigned int v2:17; unsigned short v3:8; };
struct B_BFu17i_BFu9i { bool v1; unsigned int v2:17; unsigned int v3:9; };
struct B_BFu17i_BFu9ll { bool v1; unsigned int v2:17; unsigned long long v3:9; };
struct B_BFu17i_BFu9s { bool v1; unsigned int v2:17; unsigned short v3:9; };
struct B_BFu17i_C { bool v1; unsigned int v2:17; char v3; };
struct B_BFu17i_D { bool v1; unsigned int v2:17; double v3; };
struct B_BFu17i_F { bool v1; unsigned int v2:17; float v3; };
struct B_BFu17i_I { bool v1; unsigned int v2:17; int v3; };
struct B_BFu17i_Ip { bool v1; unsigned int v2:17; int * v3; };
struct B_BFu17i_L { bool v1; unsigned int v2:17; long long v3; };
struct B_BFu17i_S { bool v1; unsigned int v2:17; short v3; };
struct B_BFu17i_Uc { bool v1; unsigned int v2:17; unsigned char v3; };
struct B_BFu17i_Ui { bool v1; unsigned int v2:17; unsigned int v3; };
struct B_BFu17i_Ul { bool v1; unsigned int v2:17; unsigned long long v3; };
struct B_BFu17i_Us { bool v1; unsigned int v2:17; unsigned short v3; };
struct B_BFu17i_Vp { bool v1; unsigned int v2:17; void * v3; };
struct B_BFu17ll { bool v1; unsigned long long v2:17; };
struct B_BFu17ll_B { bool v1; unsigned long long v2:17; bool v3; };
struct B_BFu17ll_BFu15i { bool v1; unsigned long long v2:17; unsigned int v3:15; };
struct B_BFu17ll_BFu15ll { bool v1; unsigned long long v2:17; unsigned long long v3:15; };
struct B_BFu17ll_BFu15s { bool v1; unsigned long long v2:17; unsigned short v3:15; };
struct B_BFu17ll_BFu16i { bool v1; unsigned long long v2:17; unsigned int v3:16; };
struct B_BFu17ll_BFu16ll { bool v1; unsigned long long v2:17; unsigned long long v3:16; };
struct B_BFu17ll_BFu16s { bool v1; unsigned long long v2:17; unsigned short v3:16; };
struct B_BFu17ll_BFu17i { bool v1; unsigned long long v2:17; unsigned int v3:17; };
struct B_BFu17ll_BFu17ll { bool v1; unsigned long long v2:17; unsigned long long v3:17; };
struct B_BFu17ll_BFu1c { bool v1; unsigned long long v2:17; unsigned char v3:1; };
struct B_BFu17ll_BFu1i { bool v1; unsigned long long v2:17; unsigned int v3:1; };
struct B_BFu17ll_BFu1ll { bool v1; unsigned long long v2:17; unsigned long long v3:1; };
struct B_BFu17ll_BFu1s { bool v1; unsigned long long v2:17; unsigned short v3:1; };
struct B_BFu17ll_BFu31i { bool v1; unsigned long long v2:17; unsigned int v3:31; };
struct B_BFu17ll_BFu31ll { bool v1; unsigned long long v2:17; unsigned long long v3:31; };
struct B_BFu17ll_BFu32i { bool v1; unsigned long long v2:17; unsigned int v3:32; };
struct B_BFu17ll_BFu32ll { bool v1; unsigned long long v2:17; unsigned long long v3:32; };
struct B_BFu17ll_BFu33 { bool v1; unsigned long long v2:17; unsigned long long v3:33; };
struct B_BFu17ll_BFu7c { bool v1; unsigned long long v2:17; unsigned char v3:7; };
struct B_BFu17ll_BFu7i { bool v1; unsigned long long v2:17; unsigned int v3:7; };
struct B_BFu17ll_BFu7ll { bool v1; unsigned long long v2:17; unsigned long long v3:7; };
struct B_BFu17ll_BFu7s { bool v1; unsigned long long v2:17; unsigned short v3:7; };
struct B_BFu17ll_BFu8c { bool v1; unsigned long long v2:17; unsigned char v3:8; };
struct B_BFu17ll_BFu8i { bool v1; unsigned long long v2:17; unsigned int v3:8; };
struct B_BFu17ll_BFu8ll { bool v1; unsigned long long v2:17; unsigned long long v3:8; };
struct B_BFu17ll_BFu8s { bool v1; unsigned long long v2:17; unsigned short v3:8; };
struct B_BFu17ll_BFu9i { bool v1; unsigned long long v2:17; unsigned int v3:9; };
struct B_BFu17ll_BFu9ll { bool v1; unsigned long long v2:17; unsigned long long v3:9; };
struct B_BFu17ll_BFu9s { bool v1; unsigned long long v2:17; unsigned short v3:9; };
struct B_BFu17ll_C { bool v1; unsigned long long v2:17; char v3; };
struct B_BFu17ll_D { bool v1; unsigned long long v2:17; double v3; };
struct B_BFu17ll_F { bool v1; unsigned long long v2:17; float v3; };
struct B_BFu17ll_I { bool v1; unsigned long long v2:17; int v3; };
struct B_BFu17ll_Ip { bool v1; unsigned long long v2:17; int * v3; };
struct B_BFu17ll_L { bool v1; unsigned long long v2:17; long long v3; };
struct B_BFu17ll_S { bool v1; unsigned long long v2:17; short v3; };
struct B_BFu17ll_Uc { bool v1; unsigned long long v2:17; unsigned char v3; };
struct B_BFu17ll_Ui { bool v1; unsigned long long v2:17; unsigned int v3; };
struct B_BFu17ll_Ul { bool v1; unsigned long long v2:17; unsigned long long v3; };
struct B_BFu17ll_Us { bool v1; unsigned long long v2:17; unsigned short v3; };
struct B_BFu17ll_Vp { bool v1; unsigned long long v2:17; void * v3; };
struct B_BFu1c { bool v1; unsigned char v2:1; };
struct B_BFu1c_B { bool v1; unsigned char v2:1; bool v3; };
struct B_BFu1c_BFu15i { bool v1; unsigned char v2:1; unsigned int v3:15; };
struct B_BFu1c_BFu15ll { bool v1; unsigned char v2:1; unsigned long long v3:15; };
struct B_BFu1c_BFu15s { bool v1; unsigned char v2:1; unsigned short v3:15; };
struct B_BFu1c_BFu16i { bool v1; unsigned char v2:1; unsigned int v3:16; };
struct B_BFu1c_BFu16ll { bool v1; unsigned char v2:1; unsigned long long v3:16; };
struct B_BFu1c_BFu16s { bool v1; unsigned char v2:1; unsigned short v3:16; };
struct B_BFu1c_BFu17i { bool v1; unsigned char v2:1; unsigned int v3:17; };
struct B_BFu1c_BFu17ll { bool v1; unsigned char v2:1; unsigned long long v3:17; };
struct B_BFu1c_BFu1c { bool v1; unsigned char v2:1; unsigned char v3:1; };
struct B_BFu1c_BFu1i { bool v1; unsigned char v2:1; unsigned int v3:1; };
struct B_BFu1c_BFu1ll { bool v1; unsigned char v2:1; unsigned long long v3:1; };
struct B_BFu1c_BFu1s { bool v1; unsigned char v2:1; unsigned short v3:1; };
struct B_BFu1c_BFu31i { bool v1; unsigned char v2:1; unsigned int v3:31; };
struct B_BFu1c_BFu31ll { bool v1; unsigned char v2:1; unsigned long long v3:31; };
struct B_BFu1c_BFu32i { bool v1; unsigned char v2:1; unsigned int v3:32; };
struct B_BFu1c_BFu32ll { bool v1; unsigned char v2:1; unsigned long long v3:32; };
struct B_BFu1c_BFu33 { bool v1; unsigned char v2:1; unsigned long long v3:33; };
struct B_BFu1c_BFu7c { bool v1; unsigned char v2:1; unsigned char v3:7; };
struct B_BFu1c_BFu7i { bool v1; unsigned char v2:1; unsigned int v3:7; };
struct B_BFu1c_BFu7ll { bool v1; unsigned char v2:1; unsigned long long v3:7; };
struct B_BFu1c_BFu7s { bool v1; unsigned char v2:1; unsigned short v3:7; };
struct B_BFu1c_BFu8c { bool v1; unsigned char v2:1; unsigned char v3:8; };
struct B_BFu1c_BFu8i { bool v1; unsigned char v2:1; unsigned int v3:8; };
struct B_BFu1c_BFu8ll { bool v1; unsigned char v2:1; unsigned long long v3:8; };
struct B_BFu1c_BFu8s { bool v1; unsigned char v2:1; unsigned short v3:8; };
struct B_BFu1c_BFu9i { bool v1; unsigned char v2:1; unsigned int v3:9; };
struct B_BFu1c_BFu9ll { bool v1; unsigned char v2:1; unsigned long long v3:9; };
struct B_BFu1c_BFu9s { bool v1; unsigned char v2:1; unsigned short v3:9; };
struct B_BFu1c_C { bool v1; unsigned char v2:1; char v3; };
struct B_BFu1c_D { bool v1; unsigned char v2:1; double v3; };
struct B_BFu1c_F { bool v1; unsigned char v2:1; float v3; };
struct B_BFu1c_I { bool v1; unsigned char v2:1; int v3; };
struct B_BFu1c_Ip { bool v1; unsigned char v2:1; int * v3; };
struct B_BFu1c_L { bool v1; unsigned char v2:1; long long v3; };
struct B_BFu1c_S { bool v1; unsigned char v2:1; short v3; };
struct B_BFu1c_Uc { bool v1; unsigned char v2:1; unsigned char v3; };
struct B_BFu1c_Ui { bool v1; unsigned char v2:1; unsigned int v3; };
struct B_BFu1c_Ul { bool v1; unsigned char v2:1; unsigned long long v3; };
struct B_BFu1c_Us { bool v1; unsigned char v2:1; unsigned short v3; };
struct B_BFu1c_Vp { bool v1; unsigned char v2:1; void * v3; };
struct B_BFu1i { bool v1; unsigned int v2:1; };
struct B_BFu1i_B { bool v1; unsigned int v2:1; bool v3; };
struct B_BFu1i_BFu15i { bool v1; unsigned int v2:1; unsigned int v3:15; };
struct B_BFu1i_BFu15ll { bool v1; unsigned int v2:1; unsigned long long v3:15; };
struct B_BFu1i_BFu15s { bool v1; unsigned int v2:1; unsigned short v3:15; };
struct B_BFu1i_BFu16i { bool v1; unsigned int v2:1; unsigned int v3:16; };
struct B_BFu1i_BFu16ll { bool v1; unsigned int v2:1; unsigned long long v3:16; };
struct B_BFu1i_BFu16s { bool v1; unsigned int v2:1; unsigned short v3:16; };
struct B_BFu1i_BFu17i { bool v1; unsigned int v2:1; unsigned int v3:17; };
struct B_BFu1i_BFu17ll { bool v1; unsigned int v2:1; unsigned long long v3:17; };
struct B_BFu1i_BFu1c { bool v1; unsigned int v2:1; unsigned char v3:1; };
struct B_BFu1i_BFu1i { bool v1; unsigned int v2:1; unsigned int v3:1; };
struct B_BFu1i_BFu1ll { bool v1; unsigned int v2:1; unsigned long long v3:1; };
struct B_BFu1i_BFu1s { bool v1; unsigned int v2:1; unsigned short v3:1; };
struct B_BFu1i_BFu31i { bool v1; unsigned int v2:1; unsigned int v3:31; };
struct B_BFu1i_BFu31ll { bool v1; unsigned int v2:1; unsigned long long v3:31; };
struct B_BFu1i_BFu32i { bool v1; unsigned int v2:1; unsigned int v3:32; };
struct B_BFu1i_BFu32ll { bool v1; unsigned int v2:1; unsigned long long v3:32; };
struct B_BFu1i_BFu33 { bool v1; unsigned int v2:1; unsigned long long v3:33; };
struct B_BFu1i_BFu7c { bool v1; unsigned int v2:1; unsigned char v3:7; };
struct B_BFu1i_BFu7i { bool v1; unsigned int v2:1; unsigned int v3:7; };
struct B_BFu1i_BFu7ll { bool v1; unsigned int v2:1; unsigned long long v3:7; };
struct B_BFu1i_BFu7s { bool v1; unsigned int v2:1; unsigned short v3:7; };
struct B_BFu1i_BFu8c { bool v1; unsigned int v2:1; unsigned char v3:8; };
struct B_BFu1i_BFu8i { bool v1; unsigned int v2:1; unsigned int v3:8; };
struct B_BFu1i_BFu8ll { bool v1; unsigned int v2:1; unsigned long long v3:8; };
struct B_BFu1i_BFu8s { bool v1; unsigned int v2:1; unsigned short v3:8; };
struct B_BFu1i_BFu9i { bool v1; unsigned int v2:1; unsigned int v3:9; };
struct B_BFu1i_BFu9ll { bool v1; unsigned int v2:1; unsigned long long v3:9; };
struct B_BFu1i_BFu9s { bool v1; unsigned int v2:1; unsigned short v3:9; };
struct B_BFu1i_C { bool v1; unsigned int v2:1; char v3; };
struct B_BFu1i_D { bool v1; unsigned int v2:1; double v3; };
struct B_BFu1i_F { bool v1; unsigned int v2:1; float v3; };
struct B_BFu1i_I { bool v1; unsigned int v2:1; int v3; };
struct B_BFu1i_Ip { bool v1; unsigned int v2:1; int * v3; };
struct B_BFu1i_L { bool v1; unsigned int v2:1; long long v3; };
struct B_BFu1i_S { bool v1; unsigned int v2:1; short v3; };
struct B_BFu1i_Uc { bool v1; unsigned int v2:1; unsigned char v3; };
struct B_BFu1i_Ui { bool v1; unsigned int v2:1; unsigned int v3; };
struct B_BFu1i_Ul { bool v1; unsigned int v2:1; unsigned long long v3; };
struct B_BFu1i_Us { bool v1; unsigned int v2:1; unsigned short v3; };
struct B_BFu1i_Vp { bool v1; unsigned int v2:1; void * v3; };
struct B_BFu1ll { bool v1; unsigned long long v2:1; };
struct B_BFu1ll_B { bool v1; unsigned long long v2:1; bool v3; };
struct B_BFu1ll_BFu15i { bool v1; unsigned long long v2:1; unsigned int v3:15; };
struct B_BFu1ll_BFu15ll { bool v1; unsigned long long v2:1; unsigned long long v3:15; };
struct B_BFu1ll_BFu15s { bool v1; unsigned long long v2:1; unsigned short v3:15; };
struct B_BFu1ll_BFu16i { bool v1; unsigned long long v2:1; unsigned int v3:16; };
struct B_BFu1ll_BFu16ll { bool v1; unsigned long long v2:1; unsigned long long v3:16; };
struct B_BFu1ll_BFu16s { bool v1; unsigned long long v2:1; unsigned short v3:16; };
struct B_BFu1ll_BFu17i { bool v1; unsigned long long v2:1; unsigned int v3:17; };
struct B_BFu1ll_BFu17ll { bool v1; unsigned long long v2:1; unsigned long long v3:17; };
struct B_BFu1ll_BFu1c { bool v1; unsigned long long v2:1; unsigned char v3:1; };
struct B_BFu1ll_BFu1i { bool v1; unsigned long long v2:1; unsigned int v3:1; };
struct B_BFu1ll_BFu1ll { bool v1; unsigned long long v2:1; unsigned long long v3:1; };
struct B_BFu1ll_BFu1s { bool v1; unsigned long long v2:1; unsigned short v3:1; };
struct B_BFu1ll_BFu31i { bool v1; unsigned long long v2:1; unsigned int v3:31; };
struct B_BFu1ll_BFu31ll { bool v1; unsigned long long v2:1; unsigned long long v3:31; };
struct B_BFu1ll_BFu32i { bool v1; unsigned long long v2:1; unsigned int v3:32; };
struct B_BFu1ll_BFu32ll { bool v1; unsigned long long v2:1; unsigned long long v3:32; };
struct B_BFu1ll_BFu33 { bool v1; unsigned long long v2:1; unsigned long long v3:33; };
struct B_BFu1ll_BFu7c { bool v1; unsigned long long v2:1; unsigned char v3:7; };
struct B_BFu1ll_BFu7i { bool v1; unsigned long long v2:1; unsigned int v3:7; };
struct B_BFu1ll_BFu7ll { bool v1; unsigned long long v2:1; unsigned long long v3:7; };
struct B_BFu1ll_BFu7s { bool v1; unsigned long long v2:1; unsigned short v3:7; };
struct B_BFu1ll_BFu8c { bool v1; unsigned long long v2:1; unsigned char v3:8; };
struct B_BFu1ll_BFu8i { bool v1; unsigned long long v2:1; unsigned int v3:8; };
struct B_BFu1ll_BFu8ll { bool v1; unsigned long long v2:1; unsigned long long v3:8; };
struct B_BFu1ll_BFu8s { bool v1; unsigned long long v2:1; unsigned short v3:8; };
struct B_BFu1ll_BFu9i { bool v1; unsigned long long v2:1; unsigned int v3:9; };
struct B_BFu1ll_BFu9ll { bool v1; unsigned long long v2:1; unsigned long long v3:9; };
struct B_BFu1ll_BFu9s { bool v1; unsigned long long v2:1; unsigned short v3:9; };
struct B_BFu1ll_C { bool v1; unsigned long long v2:1; char v3; };
struct B_BFu1ll_D { bool v1; unsigned long long v2:1; double v3; };
struct B_BFu1ll_F { bool v1; unsigned long long v2:1; float v3; };
struct B_BFu1ll_I { bool v1; unsigned long long v2:1; int v3; };
struct B_BFu1ll_Ip { bool v1; unsigned long long v2:1; int * v3; };
struct B_BFu1ll_L { bool v1; unsigned long long v2:1; long long v3; };
struct B_BFu1ll_S { bool v1; unsigned long long v2:1; short v3; };
struct B_BFu1ll_Uc { bool v1; unsigned long long v2:1; unsigned char v3; };
struct B_BFu1ll_Ui { bool v1; unsigned long long v2:1; unsigned int v3; };
struct B_BFu1ll_Ul { bool v1; unsigned long long v2:1; unsigned long long v3; };
struct B_BFu1ll_Us { bool v1; unsigned long long v2:1; unsigned short v3; };
struct B_BFu1ll_Vp { bool v1; unsigned long long v2:1; void * v3; };
struct B_BFu1s { bool v1; unsigned short v2:1; };
struct B_BFu1s_B { bool v1; unsigned short v2:1; bool v3; };
struct B_BFu1s_BFu15i { bool v1; unsigned short v2:1; unsigned int v3:15; };
struct B_BFu1s_BFu15ll { bool v1; unsigned short v2:1; unsigned long long v3:15; };
struct B_BFu1s_BFu15s { bool v1; unsigned short v2:1; unsigned short v3:15; };
struct B_BFu1s_BFu16i { bool v1; unsigned short v2:1; unsigned int v3:16; };
struct B_BFu1s_BFu16ll { bool v1; unsigned short v2:1; unsigned long long v3:16; };
struct B_BFu1s_BFu16s { bool v1; unsigned short v2:1; unsigned short v3:16; };
struct B_BFu1s_BFu17i { bool v1; unsigned short v2:1; unsigned int v3:17; };
struct B_BFu1s_BFu17ll { bool v1; unsigned short v2:1; unsigned long long v3:17; };
struct B_BFu1s_BFu1c { bool v1; unsigned short v2:1; unsigned char v3:1; };
struct B_BFu1s_BFu1i { bool v1; unsigned short v2:1; unsigned int v3:1; };
struct B_BFu1s_BFu1ll { bool v1; unsigned short v2:1; unsigned long long v3:1; };
struct B_BFu1s_BFu1s { bool v1; unsigned short v2:1; unsigned short v3:1; };
struct B_BFu1s_BFu31i { bool v1; unsigned short v2:1; unsigned int v3:31; };
struct B_BFu1s_BFu31ll { bool v1; unsigned short v2:1; unsigned long long v3:31; };
struct B_BFu1s_BFu32i { bool v1; unsigned short v2:1; unsigned int v3:32; };
struct B_BFu1s_BFu32ll { bool v1; unsigned short v2:1; unsigned long long v3:32; };
struct B_BFu1s_BFu33 { bool v1; unsigned short v2:1; unsigned long long v3:33; };
struct B_BFu1s_BFu7c { bool v1; unsigned short v2:1; unsigned char v3:7; };
struct B_BFu1s_BFu7i { bool v1; unsigned short v2:1; unsigned int v3:7; };
struct B_BFu1s_BFu7ll { bool v1; unsigned short v2:1; unsigned long long v3:7; };
struct B_BFu1s_BFu7s { bool v1; unsigned short v2:1; unsigned short v3:7; };
struct B_BFu1s_BFu8c { bool v1; unsigned short v2:1; unsigned char v3:8; };
struct B_BFu1s_BFu8i { bool v1; unsigned short v2:1; unsigned int v3:8; };
struct B_BFu1s_BFu8ll { bool v1; unsigned short v2:1; unsigned long long v3:8; };
struct B_BFu1s_BFu8s { bool v1; unsigned short v2:1; unsigned short v3:8; };
struct B_BFu1s_BFu9i { bool v1; unsigned short v2:1; unsigned int v3:9; };
struct B_BFu1s_BFu9ll { bool v1; unsigned short v2:1; unsigned long long v3:9; };
struct B_BFu1s_BFu9s { bool v1; unsigned short v2:1; unsigned short v3:9; };
struct B_BFu1s_C { bool v1; unsigned short v2:1; char v3; };
struct B_BFu1s_D { bool v1; unsigned short v2:1; double v3; };
struct B_BFu1s_F { bool v1; unsigned short v2:1; float v3; };
struct B_BFu1s_I { bool v1; unsigned short v2:1; int v3; };
struct B_BFu1s_Ip { bool v1; unsigned short v2:1; int * v3; };
struct B_BFu1s_L { bool v1; unsigned short v2:1; long long v3; };
struct B_BFu1s_S { bool v1; unsigned short v2:1; short v3; };
struct B_BFu1s_Uc { bool v1; unsigned short v2:1; unsigned char v3; };
struct B_BFu1s_Ui { bool v1; unsigned short v2:1; unsigned int v3; };
struct B_BFu1s_Ul { bool v1; unsigned short v2:1; unsigned long long v3; };
struct B_BFu1s_Us { bool v1; unsigned short v2:1; unsigned short v3; };
struct B_BFu1s_Vp { bool v1; unsigned short v2:1; void * v3; };
struct B_BFu31i { bool v1; unsigned int v2:31; };
struct B_BFu31i_B { bool v1; unsigned int v2:31; bool v3; };
struct B_BFu31i_BFu15i { bool v1; unsigned int v2:31; unsigned int v3:15; };
struct B_BFu31i_BFu15ll { bool v1; unsigned int v2:31; unsigned long long v3:15; };
struct B_BFu31i_BFu15s { bool v1; unsigned int v2:31; unsigned short v3:15; };
struct B_BFu31i_BFu16i { bool v1; unsigned int v2:31; unsigned int v3:16; };
struct B_BFu31i_BFu16ll { bool v1; unsigned int v2:31; unsigned long long v3:16; };
struct B_BFu31i_BFu16s { bool v1; unsigned int v2:31; unsigned short v3:16; };
struct B_BFu31i_BFu17i { bool v1; unsigned int v2:31; unsigned int v3:17; };
struct B_BFu31i_BFu17ll { bool v1; unsigned int v2:31; unsigned long long v3:17; };
struct B_BFu31i_BFu1c { bool v1; unsigned int v2:31; unsigned char v3:1; };
struct B_BFu31i_BFu1i { bool v1; unsigned int v2:31; unsigned int v3:1; };
struct B_BFu31i_BFu1ll { bool v1; unsigned int v2:31; unsigned long long v3:1; };
struct B_BFu31i_BFu1s { bool v1; unsigned int v2:31; unsigned short v3:1; };
struct B_BFu31i_BFu31i { bool v1; unsigned int v2:31; unsigned int v3:31; };
struct B_BFu31i_BFu31ll { bool v1; unsigned int v2:31; unsigned long long v3:31; };
struct B_BFu31i_BFu32i { bool v1; unsigned int v2:31; unsigned int v3:32; };
struct B_BFu31i_BFu32ll { bool v1; unsigned int v2:31; unsigned long long v3:32; };
struct B_BFu31i_BFu33 { bool v1; unsigned int v2:31; unsigned long long v3:33; };
struct B_BFu31i_BFu7c { bool v1; unsigned int v2:31; unsigned char v3:7; };
struct B_BFu31i_BFu7i { bool v1; unsigned int v2:31; unsigned int v3:7; };
struct B_BFu31i_BFu7ll { bool v1; unsigned int v2:31; unsigned long long v3:7; };
struct B_BFu31i_BFu7s { bool v1; unsigned int v2:31; unsigned short v3:7; };
struct B_BFu31i_BFu8c { bool v1; unsigned int v2:31; unsigned char v3:8; };
struct B_BFu31i_BFu8i { bool v1; unsigned int v2:31; unsigned int v3:8; };
struct B_BFu31i_BFu8ll { bool v1; unsigned int v2:31; unsigned long long v3:8; };
struct B_BFu31i_BFu8s { bool v1; unsigned int v2:31; unsigned short v3:8; };
struct B_BFu31i_BFu9i { bool v1; unsigned int v2:31; unsigned int v3:9; };
struct B_BFu31i_BFu9ll { bool v1; unsigned int v2:31; unsigned long long v3:9; };
struct B_BFu31i_BFu9s { bool v1; unsigned int v2:31; unsigned short v3:9; };
struct B_BFu31i_C { bool v1; unsigned int v2:31; char v3; };
struct B_BFu31i_D { bool v1; unsigned int v2:31; double v3; };
struct B_BFu31i_F { bool v1; unsigned int v2:31; float v3; };
struct B_BFu31i_I { bool v1; unsigned int v2:31; int v3; };
struct B_BFu31i_Ip { bool v1; unsigned int v2:31; int * v3; };
struct B_BFu31i_L { bool v1; unsigned int v2:31; long long v3; };
struct B_BFu31i_S { bool v1; unsigned int v2:31; short v3; };
struct B_BFu31i_Uc { bool v1; unsigned int v2:31; unsigned char v3; };
struct B_BFu31i_Ui { bool v1; unsigned int v2:31; unsigned int v3; };
struct B_BFu31i_Ul { bool v1; unsigned int v2:31; unsigned long long v3; };
struct B_BFu31i_Us { bool v1; unsigned int v2:31; unsigned short v3; };
struct B_BFu31i_Vp { bool v1; unsigned int v2:31; void * v3; };
struct B_BFu31ll { bool v1; unsigned long long v2:31; };
struct B_BFu31ll_B { bool v1; unsigned long long v2:31; bool v3; };
struct B_BFu31ll_BFu15i { bool v1; unsigned long long v2:31; unsigned int v3:15; };
struct B_BFu31ll_BFu15ll { bool v1; unsigned long long v2:31; unsigned long long v3:15; };
struct B_BFu31ll_BFu15s { bool v1; unsigned long long v2:31; unsigned short v3:15; };
struct B_BFu31ll_BFu16i { bool v1; unsigned long long v2:31; unsigned int v3:16; };
struct B_BFu31ll_BFu16ll { bool v1; unsigned long long v2:31; unsigned long long v3:16; };
struct B_BFu31ll_BFu16s { bool v1; unsigned long long v2:31; unsigned short v3:16; };
struct B_BFu31ll_BFu17i { bool v1; unsigned long long v2:31; unsigned int v3:17; };
struct B_BFu31ll_BFu17ll { bool v1; unsigned long long v2:31; unsigned long long v3:17; };
struct B_BFu31ll_BFu1c { bool v1; unsigned long long v2:31; unsigned char v3:1; };
struct B_BFu31ll_BFu1i { bool v1; unsigned long long v2:31; unsigned int v3:1; };
struct B_BFu31ll_BFu1ll { bool v1; unsigned long long v2:31; unsigned long long v3:1; };
struct B_BFu31ll_BFu1s { bool v1; unsigned long long v2:31; unsigned short v3:1; };
struct B_BFu31ll_BFu31i { bool v1; unsigned long long v2:31; unsigned int v3:31; };
struct B_BFu31ll_BFu31ll { bool v1; unsigned long long v2:31; unsigned long long v3:31; };
struct B_BFu31ll_BFu32i { bool v1; unsigned long long v2:31; unsigned int v3:32; };
struct B_BFu31ll_BFu32ll { bool v1; unsigned long long v2:31; unsigned long long v3:32; };
struct B_BFu31ll_BFu33 { bool v1; unsigned long long v2:31; unsigned long long v3:33; };
struct B_BFu31ll_BFu7c { bool v1; unsigned long long v2:31; unsigned char v3:7; };
struct B_BFu31ll_BFu7i { bool v1; unsigned long long v2:31; unsigned int v3:7; };
struct B_BFu31ll_BFu7ll { bool v1; unsigned long long v2:31; unsigned long long v3:7; };
struct B_BFu31ll_BFu7s { bool v1; unsigned long long v2:31; unsigned short v3:7; };
struct B_BFu31ll_BFu8c { bool v1; unsigned long long v2:31; unsigned char v3:8; };
struct B_BFu31ll_BFu8i { bool v1; unsigned long long v2:31; unsigned int v3:8; };
struct B_BFu31ll_BFu8ll { bool v1; unsigned long long v2:31; unsigned long long v3:8; };
struct B_BFu31ll_BFu8s { bool v1; unsigned long long v2:31; unsigned short v3:8; };
struct B_BFu31ll_BFu9i { bool v1; unsigned long long v2:31; unsigned int v3:9; };
struct B_BFu31ll_BFu9ll { bool v1; unsigned long long v2:31; unsigned long long v3:9; };
struct B_BFu31ll_BFu9s { bool v1; unsigned long long v2:31; unsigned short v3:9; };
struct B_BFu31ll_C { bool v1; unsigned long long v2:31; char v3; };
struct B_BFu31ll_D { bool v1; unsigned long long v2:31; double v3; };
struct B_BFu31ll_F { bool v1; unsigned long long v2:31; float v3; };
struct B_BFu31ll_I { bool v1; unsigned long long v2:31; int v3; };
struct B_BFu31ll_Ip { bool v1; unsigned long long v2:31; int * v3; };
struct B_BFu31ll_L { bool v1; unsigned long long v2:31; long long v3; };
struct B_BFu31ll_S { bool v1; unsigned long long v2:31; short v3; };
struct B_BFu31ll_Uc { bool v1; unsigned long long v2:31; unsigned char v3; };
struct B_BFu31ll_Ui { bool v1; unsigned long long v2:31; unsigned int v3; };
struct B_BFu31ll_Ul { bool v1; unsigned long long v2:31; unsigned long long v3; };
struct B_BFu31ll_Us { bool v1; unsigned long long v2:31; unsigned short v3; };
struct B_BFu31ll_Vp { bool v1; unsigned long long v2:31; void * v3; };
struct B_BFu32i { bool v1; unsigned int v2:32; };
struct B_BFu32i_B { bool v1; unsigned int v2:32; bool v3; };
struct B_BFu32i_BFu15i { bool v1; unsigned int v2:32; unsigned int v3:15; };
struct B_BFu32i_BFu15ll { bool v1; unsigned int v2:32; unsigned long long v3:15; };
struct B_BFu32i_BFu15s { bool v1; unsigned int v2:32; unsigned short v3:15; };
struct B_BFu32i_BFu16i { bool v1; unsigned int v2:32; unsigned int v3:16; };
struct B_BFu32i_BFu16ll { bool v1; unsigned int v2:32; unsigned long long v3:16; };
struct B_BFu32i_BFu16s { bool v1; unsigned int v2:32; unsigned short v3:16; };
struct B_BFu32i_BFu17i { bool v1; unsigned int v2:32; unsigned int v3:17; };
struct B_BFu32i_BFu17ll { bool v1; unsigned int v2:32; unsigned long long v3:17; };
struct B_BFu32i_BFu1c { bool v1; unsigned int v2:32; unsigned char v3:1; };
struct B_BFu32i_BFu1i { bool v1; unsigned int v2:32; unsigned int v3:1; };
struct B_BFu32i_BFu1ll { bool v1; unsigned int v2:32; unsigned long long v3:1; };
struct B_BFu32i_BFu1s { bool v1; unsigned int v2:32; unsigned short v3:1; };
struct B_BFu32i_BFu31i { bool v1; unsigned int v2:32; unsigned int v3:31; };
struct B_BFu32i_BFu31ll { bool v1; unsigned int v2:32; unsigned long long v3:31; };
struct B_BFu32i_BFu32i { bool v1; unsigned int v2:32; unsigned int v3:32; };
struct B_BFu32i_BFu32ll { bool v1; unsigned int v2:32; unsigned long long v3:32; };
struct B_BFu32i_BFu33 { bool v1; unsigned int v2:32; unsigned long long v3:33; };
struct B_BFu32i_BFu7c { bool v1; unsigned int v2:32; unsigned char v3:7; };
struct B_BFu32i_BFu7i { bool v1; unsigned int v2:32; unsigned int v3:7; };
struct B_BFu32i_BFu7ll { bool v1; unsigned int v2:32; unsigned long long v3:7; };
struct B_BFu32i_BFu7s { bool v1; unsigned int v2:32; unsigned short v3:7; };
struct B_BFu32i_BFu8c { bool v1; unsigned int v2:32; unsigned char v3:8; };
struct B_BFu32i_BFu8i { bool v1; unsigned int v2:32; unsigned int v3:8; };
struct B_BFu32i_BFu8ll { bool v1; unsigned int v2:32; unsigned long long v3:8; };
struct B_BFu32i_BFu8s { bool v1; unsigned int v2:32; unsigned short v3:8; };
struct B_BFu32i_BFu9i { bool v1; unsigned int v2:32; unsigned int v3:9; };
struct B_BFu32i_BFu9ll { bool v1; unsigned int v2:32; unsigned long long v3:9; };
struct B_BFu32i_BFu9s { bool v1; unsigned int v2:32; unsigned short v3:9; };
struct B_BFu32i_C { bool v1; unsigned int v2:32; char v3; };
struct B_BFu32i_D { bool v1; unsigned int v2:32; double v3; };
struct B_BFu32i_F { bool v1; unsigned int v2:32; float v3; };
struct B_BFu32i_I { bool v1; unsigned int v2:32; int v3; };
struct B_BFu32i_Ip { bool v1; unsigned int v2:32; int * v3; };
struct B_BFu32i_L { bool v1; unsigned int v2:32; long long v3; };
struct B_BFu32i_S { bool v1; unsigned int v2:32; short v3; };
struct B_BFu32i_Uc { bool v1; unsigned int v2:32; unsigned char v3; };
struct B_BFu32i_Ui { bool v1; unsigned int v2:32; unsigned int v3; };
struct B_BFu32i_Ul { bool v1; unsigned int v2:32; unsigned long long v3; };
struct B_BFu32i_Us { bool v1; unsigned int v2:32; unsigned short v3; };
struct B_BFu32i_Vp { bool v1; unsigned int v2:32; void * v3; };
struct B_BFu32ll { bool v1; unsigned long long v2:32; };
struct B_BFu32ll_B { bool v1; unsigned long long v2:32; bool v3; };
struct B_BFu32ll_BFu15i { bool v1; unsigned long long v2:32; unsigned int v3:15; };
struct B_BFu32ll_BFu15ll { bool v1; unsigned long long v2:32; unsigned long long v3:15; };
struct B_BFu32ll_BFu15s { bool v1; unsigned long long v2:32; unsigned short v3:15; };
struct B_BFu32ll_BFu16i { bool v1; unsigned long long v2:32; unsigned int v3:16; };
struct B_BFu32ll_BFu16ll { bool v1; unsigned long long v2:32; unsigned long long v3:16; };
struct B_BFu32ll_BFu16s { bool v1; unsigned long long v2:32; unsigned short v3:16; };
struct B_BFu32ll_BFu17i { bool v1; unsigned long long v2:32; unsigned int v3:17; };
struct B_BFu32ll_BFu17ll { bool v1; unsigned long long v2:32; unsigned long long v3:17; };
struct B_BFu32ll_BFu1c { bool v1; unsigned long long v2:32; unsigned char v3:1; };
struct B_BFu32ll_BFu1i { bool v1; unsigned long long v2:32; unsigned int v3:1; };
struct B_BFu32ll_BFu1ll { bool v1; unsigned long long v2:32; unsigned long long v3:1; };
struct B_BFu32ll_BFu1s { bool v1; unsigned long long v2:32; unsigned short v3:1; };
struct B_BFu32ll_BFu31i { bool v1; unsigned long long v2:32; unsigned int v3:31; };
struct B_BFu32ll_BFu31ll { bool v1; unsigned long long v2:32; unsigned long long v3:31; };
struct B_BFu32ll_BFu32i { bool v1; unsigned long long v2:32; unsigned int v3:32; };
struct B_BFu32ll_BFu32ll { bool v1; unsigned long long v2:32; unsigned long long v3:32; };
struct B_BFu32ll_BFu33 { bool v1; unsigned long long v2:32; unsigned long long v3:33; };
struct B_BFu32ll_BFu7c { bool v1; unsigned long long v2:32; unsigned char v3:7; };
struct B_BFu32ll_BFu7i { bool v1; unsigned long long v2:32; unsigned int v3:7; };
struct B_BFu32ll_BFu7ll { bool v1; unsigned long long v2:32; unsigned long long v3:7; };
struct B_BFu32ll_BFu7s { bool v1; unsigned long long v2:32; unsigned short v3:7; };
struct B_BFu32ll_BFu8c { bool v1; unsigned long long v2:32; unsigned char v3:8; };
struct B_BFu32ll_BFu8i { bool v1; unsigned long long v2:32; unsigned int v3:8; };
struct B_BFu32ll_BFu8ll { bool v1; unsigned long long v2:32; unsigned long long v3:8; };
struct B_BFu32ll_BFu8s { bool v1; unsigned long long v2:32; unsigned short v3:8; };
struct B_BFu32ll_BFu9i { bool v1; unsigned long long v2:32; unsigned int v3:9; };
struct B_BFu32ll_BFu9ll { bool v1; unsigned long long v2:32; unsigned long long v3:9; };
struct B_BFu32ll_BFu9s { bool v1; unsigned long long v2:32; unsigned short v3:9; };
struct B_BFu32ll_C { bool v1; unsigned long long v2:32; char v3; };
struct B_BFu32ll_D { bool v1; unsigned long long v2:32; double v3; };
struct B_BFu32ll_F { bool v1; unsigned long long v2:32; float v3; };
struct B_BFu32ll_I { bool v1; unsigned long long v2:32; int v3; };
struct B_BFu32ll_Ip { bool v1; unsigned long long v2:32; int * v3; };
struct B_BFu32ll_L { bool v1; unsigned long long v2:32; long long v3; };
struct B_BFu32ll_S { bool v1; unsigned long long v2:32; short v3; };
struct B_BFu32ll_Uc { bool v1; unsigned long long v2:32; unsigned char v3; };
struct B_BFu32ll_Ui { bool v1; unsigned long long v2:32; unsigned int v3; };
struct B_BFu32ll_Ul { bool v1; unsigned long long v2:32; unsigned long long v3; };
struct B_BFu32ll_Us { bool v1; unsigned long long v2:32; unsigned short v3; };
struct B_BFu32ll_Vp { bool v1; unsigned long long v2:32; void * v3; };
struct B_BFu33 { bool v1; unsigned long long v2:33; };
struct B_BFu33_B { bool v1; unsigned long long v2:33; bool v3; };
struct B_BFu33_BFu15i { bool v1; unsigned long long v2:33; unsigned int v3:15; };
struct B_BFu33_BFu15ll { bool v1; unsigned long long v2:33; unsigned long long v3:15; };
struct B_BFu33_BFu15s { bool v1; unsigned long long v2:33; unsigned short v3:15; };
struct B_BFu33_BFu16i { bool v1; unsigned long long v2:33; unsigned int v3:16; };
struct B_BFu33_BFu16ll { bool v1; unsigned long long v2:33; unsigned long long v3:16; };
struct B_BFu33_BFu16s { bool v1; unsigned long long v2:33; unsigned short v3:16; };
struct B_BFu33_BFu17i { bool v1; unsigned long long v2:33; unsigned int v3:17; };
struct B_BFu33_BFu17ll { bool v1; unsigned long long v2:33; unsigned long long v3:17; };
struct B_BFu33_BFu1c { bool v1; unsigned long long v2:33; unsigned char v3:1; };
struct B_BFu33_BFu1i { bool v1; unsigned long long v2:33; unsigned int v3:1; };
struct B_BFu33_BFu1ll { bool v1; unsigned long long v2:33; unsigned long long v3:1; };
struct B_BFu33_BFu1s { bool v1; unsigned long long v2:33; unsigned short v3:1; };
struct B_BFu33_BFu31i { bool v1; unsigned long long v2:33; unsigned int v3:31; };
struct B_BFu33_BFu31ll { bool v1; unsigned long long v2:33; unsigned long long v3:31; };
struct B_BFu33_BFu32i { bool v1; unsigned long long v2:33; unsigned int v3:32; };
struct B_BFu33_BFu32ll { bool v1; unsigned long long v2:33; unsigned long long v3:32; };
struct B_BFu33_BFu33 { bool v1; unsigned long long v2:33; unsigned long long v3:33; };
struct B_BFu33_BFu7c { bool v1; unsigned long long v2:33; unsigned char v3:7; };
struct B_BFu33_BFu7i { bool v1; unsigned long long v2:33; unsigned int v3:7; };
struct B_BFu33_BFu7ll { bool v1; unsigned long long v2:33; unsigned long long v3:7; };
struct B_BFu33_BFu7s { bool v1; unsigned long long v2:33; unsigned short v3:7; };
struct B_BFu33_BFu8c { bool v1; unsigned long long v2:33; unsigned char v3:8; };
struct B_BFu33_BFu8i { bool v1; unsigned long long v2:33; unsigned int v3:8; };
struct B_BFu33_BFu8ll { bool v1; unsigned long long v2:33; unsigned long long v3:8; };
struct B_BFu33_BFu8s { bool v1; unsigned long long v2:33; unsigned short v3:8; };
struct B_BFu33_BFu9i { bool v1; unsigned long long v2:33; unsigned int v3:9; };
struct B_BFu33_BFu9ll { bool v1; unsigned long long v2:33; unsigned long long v3:9; };
struct B_BFu33_BFu9s { bool v1; unsigned long long v2:33; unsigned short v3:9; };
struct B_BFu33_C { bool v1; unsigned long long v2:33; char v3; };
struct B_BFu33_D { bool v1; unsigned long long v2:33; double v3; };
struct B_BFu33_F { bool v1; unsigned long long v2:33; float v3; };
struct B_BFu33_I { bool v1; unsigned long long v2:33; int v3; };
struct B_BFu33_Ip { bool v1; unsigned long long v2:33; int * v3; };
struct B_BFu33_L { bool v1; unsigned long long v2:33; long long v3; };
struct B_BFu33_S { bool v1; unsigned long long v2:33; short v3; };
struct B_BFu33_Uc { bool v1; unsigned long long v2:33; unsigned char v3; };
struct B_BFu33_Ui { bool v1; unsigned long long v2:33; unsigned int v3; };
struct B_BFu33_Ul { bool v1; unsigned long long v2:33; unsigned long long v3; };
struct B_BFu33_Us { bool v1; unsigned long long v2:33; unsigned short v3; };
struct B_BFu33_Vp { bool v1; unsigned long long v2:33; void * v3; };
struct B_BFu7c { bool v1; unsigned char v2:7; };
struct B_BFu7c_B { bool v1; unsigned char v2:7; bool v3; };
struct B_BFu7c_BFu15i { bool v1; unsigned char v2:7; unsigned int v3:15; };
struct B_BFu7c_BFu15ll { bool v1; unsigned char v2:7; unsigned long long v3:15; };
struct B_BFu7c_BFu15s { bool v1; unsigned char v2:7; unsigned short v3:15; };
struct B_BFu7c_BFu16i { bool v1; unsigned char v2:7; unsigned int v3:16; };
struct B_BFu7c_BFu16ll { bool v1; unsigned char v2:7; unsigned long long v3:16; };
struct B_BFu7c_BFu16s { bool v1; unsigned char v2:7; unsigned short v3:16; };
struct B_BFu7c_BFu17i { bool v1; unsigned char v2:7; unsigned int v3:17; };
struct B_BFu7c_BFu17ll { bool v1; unsigned char v2:7; unsigned long long v3:17; };
struct B_BFu7c_BFu1c { bool v1; unsigned char v2:7; unsigned char v3:1; };
struct B_BFu7c_BFu1i { bool v1; unsigned char v2:7; unsigned int v3:1; };
struct B_BFu7c_BFu1ll { bool v1; unsigned char v2:7; unsigned long long v3:1; };
struct B_BFu7c_BFu1s { bool v1; unsigned char v2:7; unsigned short v3:1; };
struct B_BFu7c_BFu31i { bool v1; unsigned char v2:7; unsigned int v3:31; };
struct B_BFu7c_BFu31ll { bool v1; unsigned char v2:7; unsigned long long v3:31; };
struct B_BFu7c_BFu32i { bool v1; unsigned char v2:7; unsigned int v3:32; };
struct B_BFu7c_BFu32ll { bool v1; unsigned char v2:7; unsigned long long v3:32; };
struct B_BFu7c_BFu33 { bool v1; unsigned char v2:7; unsigned long long v3:33; };
struct B_BFu7c_BFu7c { bool v1; unsigned char v2:7; unsigned char v3:7; };
struct B_BFu7c_BFu7i { bool v1; unsigned char v2:7; unsigned int v3:7; };
struct B_BFu7c_BFu7ll { bool v1; unsigned char v2:7; unsigned long long v3:7; };
struct B_BFu7c_BFu7s { bool v1; unsigned char v2:7; unsigned short v3:7; };
struct B_BFu7c_BFu8c { bool v1; unsigned char v2:7; unsigned char v3:8; };
struct B_BFu7c_BFu8i { bool v1; unsigned char v2:7; unsigned int v3:8; };
struct B_BFu7c_BFu8ll { bool v1; unsigned char v2:7; unsigned long long v3:8; };
struct B_BFu7c_BFu8s { bool v1; unsigned char v2:7; unsigned short v3:8; };
struct B_BFu7c_BFu9i { bool v1; unsigned char v2:7; unsigned int v3:9; };
struct B_BFu7c_BFu9ll { bool v1; unsigned char v2:7; unsigned long long v3:9; };
struct B_BFu7c_BFu9s { bool v1; unsigned char v2:7; unsigned short v3:9; };
struct B_BFu7c_C { bool v1; unsigned char v2:7; char v3; };
struct B_BFu7c_D { bool v1; unsigned char v2:7; double v3; };
struct B_BFu7c_F { bool v1; unsigned char v2:7; float v3; };
struct B_BFu7c_I { bool v1; unsigned char v2:7; int v3; };
struct B_BFu7c_Ip { bool v1; unsigned char v2:7; int * v3; };
struct B_BFu7c_L { bool v1; unsigned char v2:7; long long v3; };
struct B_BFu7c_S { bool v1; unsigned char v2:7; short v3; };
struct B_BFu7c_Uc { bool v1; unsigned char v2:7; unsigned char v3; };
struct B_BFu7c_Ui { bool v1; unsigned char v2:7; unsigned int v3; };
struct B_BFu7c_Ul { bool v1; unsigned char v2:7; unsigned long long v3; };
struct B_BFu7c_Us { bool v1; unsigned char v2:7; unsigned short v3; };
struct B_BFu7c_Vp { bool v1; unsigned char v2:7; void * v3; };
struct B_BFu7i { bool v1; unsigned int v2:7; };
struct B_BFu7i_B { bool v1; unsigned int v2:7; bool v3; };
struct B_BFu7i_BFu15i { bool v1; unsigned int v2:7; unsigned int v3:15; };
struct B_BFu7i_BFu15ll { bool v1; unsigned int v2:7; unsigned long long v3:15; };
struct B_BFu7i_BFu15s { bool v1; unsigned int v2:7; unsigned short v3:15; };
struct B_BFu7i_BFu16i { bool v1; unsigned int v2:7; unsigned int v3:16; };
struct B_BFu7i_BFu16ll { bool v1; unsigned int v2:7; unsigned long long v3:16; };
struct B_BFu7i_BFu16s { bool v1; unsigned int v2:7; unsigned short v3:16; };
struct B_BFu7i_BFu17i { bool v1; unsigned int v2:7; unsigned int v3:17; };
struct B_BFu7i_BFu17ll { bool v1; unsigned int v2:7; unsigned long long v3:17; };
struct B_BFu7i_BFu1c { bool v1; unsigned int v2:7; unsigned char v3:1; };
struct B_BFu7i_BFu1i { bool v1; unsigned int v2:7; unsigned int v3:1; };
struct B_BFu7i_BFu1ll { bool v1; unsigned int v2:7; unsigned long long v3:1; };
struct B_BFu7i_BFu1s { bool v1; unsigned int v2:7; unsigned short v3:1; };
struct B_BFu7i_BFu31i { bool v1; unsigned int v2:7; unsigned int v3:31; };
struct B_BFu7i_BFu31ll { bool v1; unsigned int v2:7; unsigned long long v3:31; };
struct B_BFu7i_BFu32i { bool v1; unsigned int v2:7; unsigned int v3:32; };
struct B_BFu7i_BFu32ll { bool v1; unsigned int v2:7; unsigned long long v3:32; };
struct B_BFu7i_BFu33 { bool v1; unsigned int v2:7; unsigned long long v3:33; };
struct B_BFu7i_BFu7c { bool v1; unsigned int v2:7; unsigned char v3:7; };
struct B_BFu7i_BFu7i { bool v1; unsigned int v2:7; unsigned int v3:7; };
struct B_BFu7i_BFu7ll { bool v1; unsigned int v2:7; unsigned long long v3:7; };
struct B_BFu7i_BFu7s { bool v1; unsigned int v2:7; unsigned short v3:7; };
struct B_BFu7i_BFu8c { bool v1; unsigned int v2:7; unsigned char v3:8; };
struct B_BFu7i_BFu8i { bool v1; unsigned int v2:7; unsigned int v3:8; };
struct B_BFu7i_BFu8ll { bool v1; unsigned int v2:7; unsigned long long v3:8; };
struct B_BFu7i_BFu8s { bool v1; unsigned int v2:7; unsigned short v3:8; };
struct B_BFu7i_BFu9i { bool v1; unsigned int v2:7; unsigned int v3:9; };
struct B_BFu7i_BFu9ll { bool v1; unsigned int v2:7; unsigned long long v3:9; };
struct B_BFu7i_BFu9s { bool v1; unsigned int v2:7; unsigned short v3:9; };
struct B_BFu7i_C { bool v1; unsigned int v2:7; char v3; };
struct B_BFu7i_D { bool v1; unsigned int v2:7; double v3; };
struct B_BFu7i_F { bool v1; unsigned int v2:7; float v3; };
struct B_BFu7i_I { bool v1; unsigned int v2:7; int v3; };
struct B_BFu7i_Ip { bool v1; unsigned int v2:7; int * v3; };
struct B_BFu7i_L { bool v1; unsigned int v2:7; long long v3; };
struct B_BFu7i_S { bool v1; unsigned int v2:7; short v3; };
struct B_BFu7i_Uc { bool v1; unsigned int v2:7; unsigned char v3; };
struct B_BFu7i_Ui { bool v1; unsigned int v2:7; unsigned int v3; };
struct B_BFu7i_Ul { bool v1; unsigned int v2:7; unsigned long long v3; };
struct B_BFu7i_Us { bool v1; unsigned int v2:7; unsigned short v3; };
struct B_BFu7i_Vp { bool v1; unsigned int v2:7; void * v3; };
struct B_BFu7ll { bool v1; unsigned long long v2:7; };
struct B_BFu7ll_B { bool v1; unsigned long long v2:7; bool v3; };
struct B_BFu7ll_BFu15i { bool v1; unsigned long long v2:7; unsigned int v3:15; };
struct B_BFu7ll_BFu15ll { bool v1; unsigned long long v2:7; unsigned long long v3:15; };
struct B_BFu7ll_BFu15s { bool v1; unsigned long long v2:7; unsigned short v3:15; };
struct B_BFu7ll_BFu16i { bool v1; unsigned long long v2:7; unsigned int v3:16; };
struct B_BFu7ll_BFu16ll { bool v1; unsigned long long v2:7; unsigned long long v3:16; };
struct B_BFu7ll_BFu16s { bool v1; unsigned long long v2:7; unsigned short v3:16; };
struct B_BFu7ll_BFu17i { bool v1; unsigned long long v2:7; unsigned int v3:17; };
struct B_BFu7ll_BFu17ll { bool v1; unsigned long long v2:7; unsigned long long v3:17; };
struct B_BFu7ll_BFu1c { bool v1; unsigned long long v2:7; unsigned char v3:1; };
struct B_BFu7ll_BFu1i { bool v1; unsigned long long v2:7; unsigned int v3:1; };
struct B_BFu7ll_BFu1ll { bool v1; unsigned long long v2:7; unsigned long long v3:1; };
struct B_BFu7ll_BFu1s { bool v1; unsigned long long v2:7; unsigned short v3:1; };
struct B_BFu7ll_BFu31i { bool v1; unsigned long long v2:7; unsigned int v3:31; };
struct B_BFu7ll_BFu31ll { bool v1; unsigned long long v2:7; unsigned long long v3:31; };
struct B_BFu7ll_BFu32i { bool v1; unsigned long long v2:7; unsigned int v3:32; };
struct B_BFu7ll_BFu32ll { bool v1; unsigned long long v2:7; unsigned long long v3:32; };
struct B_BFu7ll_BFu33 { bool v1; unsigned long long v2:7; unsigned long long v3:33; };
struct B_BFu7ll_BFu7c { bool v1; unsigned long long v2:7; unsigned char v3:7; };
struct B_BFu7ll_BFu7i { bool v1; unsigned long long v2:7; unsigned int v3:7; };
struct B_BFu7ll_BFu7ll { bool v1; unsigned long long v2:7; unsigned long long v3:7; };
struct B_BFu7ll_BFu7s { bool v1; unsigned long long v2:7; unsigned short v3:7; };
struct B_BFu7ll_BFu8c { bool v1; unsigned long long v2:7; unsigned char v3:8; };
struct B_BFu7ll_BFu8i { bool v1; unsigned long long v2:7; unsigned int v3:8; };
struct B_BFu7ll_BFu8ll { bool v1; unsigned long long v2:7; unsigned long long v3:8; };
struct B_BFu7ll_BFu8s { bool v1; unsigned long long v2:7; unsigned short v3:8; };
struct B_BFu7ll_BFu9i { bool v1; unsigned long long v2:7; unsigned int v3:9; };
struct B_BFu7ll_BFu9ll { bool v1; unsigned long long v2:7; unsigned long long v3:9; };
struct B_BFu7ll_BFu9s { bool v1; unsigned long long v2:7; unsigned short v3:9; };
struct B_BFu7ll_C { bool v1; unsigned long long v2:7; char v3; };
struct B_BFu7ll_D { bool v1; unsigned long long v2:7; double v3; };
struct B_BFu7ll_F { bool v1; unsigned long long v2:7; float v3; };
struct B_BFu7ll_I { bool v1; unsigned long long v2:7; int v3; };
struct B_BFu7ll_Ip { bool v1; unsigned long long v2:7; int * v3; };
struct B_BFu7ll_L { bool v1; unsigned long long v2:7; long long v3; };
struct B_BFu7ll_S { bool v1; unsigned long long v2:7; short v3; };
struct B_BFu7ll_Uc { bool v1; unsigned long long v2:7; unsigned char v3; };
struct B_BFu7ll_Ui { bool v1; unsigned long long v2:7; unsigned int v3; };
struct B_BFu7ll_Ul { bool v1; unsigned long long v2:7; unsigned long long v3; };
struct B_BFu7ll_Us { bool v1; unsigned long long v2:7; unsigned short v3; };
struct B_BFu7ll_Vp { bool v1; unsigned long long v2:7; void * v3; };
struct B_BFu7s { bool v1; unsigned short v2:7; };
struct B_BFu7s_B { bool v1; unsigned short v2:7; bool v3; };
struct B_BFu7s_BFu15i { bool v1; unsigned short v2:7; unsigned int v3:15; };
struct B_BFu7s_BFu15ll { bool v1; unsigned short v2:7; unsigned long long v3:15; };
struct B_BFu7s_BFu15s { bool v1; unsigned short v2:7; unsigned short v3:15; };
struct B_BFu7s_BFu16i { bool v1; unsigned short v2:7; unsigned int v3:16; };
struct B_BFu7s_BFu16ll { bool v1; unsigned short v2:7; unsigned long long v3:16; };
struct B_BFu7s_BFu16s { bool v1; unsigned short v2:7; unsigned short v3:16; };
struct B_BFu7s_BFu17i { bool v1; unsigned short v2:7; unsigned int v3:17; };
struct B_BFu7s_BFu17ll { bool v1; unsigned short v2:7; unsigned long long v3:17; };
struct B_BFu7s_BFu1c { bool v1; unsigned short v2:7; unsigned char v3:1; };
struct B_BFu7s_BFu1i { bool v1; unsigned short v2:7; unsigned int v3:1; };
struct B_BFu7s_BFu1ll { bool v1; unsigned short v2:7; unsigned long long v3:1; };
struct B_BFu7s_BFu1s { bool v1; unsigned short v2:7; unsigned short v3:1; };
struct B_BFu7s_BFu31i { bool v1; unsigned short v2:7; unsigned int v3:31; };
struct B_BFu7s_BFu31ll { bool v1; unsigned short v2:7; unsigned long long v3:31; };
struct B_BFu7s_BFu32i { bool v1; unsigned short v2:7; unsigned int v3:32; };
struct B_BFu7s_BFu32ll { bool v1; unsigned short v2:7; unsigned long long v3:32; };
struct B_BFu7s_BFu33 { bool v1; unsigned short v2:7; unsigned long long v3:33; };
struct B_BFu7s_BFu7c { bool v1; unsigned short v2:7; unsigned char v3:7; };
struct B_BFu7s_BFu7i { bool v1; unsigned short v2:7; unsigned int v3:7; };
struct B_BFu7s_BFu7ll { bool v1; unsigned short v2:7; unsigned long long v3:7; };
struct B_BFu7s_BFu7s { bool v1; unsigned short v2:7; unsigned short v3:7; };
struct B_BFu7s_BFu8c { bool v1; unsigned short v2:7; unsigned char v3:8; };
struct B_BFu7s_BFu8i { bool v1; unsigned short v2:7; unsigned int v3:8; };
struct B_BFu7s_BFu8ll { bool v1; unsigned short v2:7; unsigned long long v3:8; };
struct B_BFu7s_BFu8s { bool v1; unsigned short v2:7; unsigned short v3:8; };
struct B_BFu7s_BFu9i { bool v1; unsigned short v2:7; unsigned int v3:9; };
struct B_BFu7s_BFu9ll { bool v1; unsigned short v2:7; unsigned long long v3:9; };
struct B_BFu7s_BFu9s { bool v1; unsigned short v2:7; unsigned short v3:9; };
struct B_BFu7s_C { bool v1; unsigned short v2:7; char v3; };
struct B_BFu7s_D { bool v1; unsigned short v2:7; double v3; };
struct B_BFu7s_F { bool v1; unsigned short v2:7; float v3; };
struct B_BFu7s_I { bool v1; unsigned short v2:7; int v3; };
struct B_BFu7s_Ip { bool v1; unsigned short v2:7; int * v3; };
struct B_BFu7s_L { bool v1; unsigned short v2:7; long long v3; };
struct B_BFu7s_S { bool v1; unsigned short v2:7; short v3; };
struct B_BFu7s_Uc { bool v1; unsigned short v2:7; unsigned char v3; };
struct B_BFu7s_Ui { bool v1; unsigned short v2:7; unsigned int v3; };
struct B_BFu7s_Ul { bool v1; unsigned short v2:7; unsigned long long v3; };
struct B_BFu7s_Us { bool v1; unsigned short v2:7; unsigned short v3; };
struct B_BFu7s_Vp { bool v1; unsigned short v2:7; void * v3; };
struct B_BFu8c { bool v1; unsigned char v2:8; };
struct B_BFu8c_B { bool v1; unsigned char v2:8; bool v3; };
struct B_BFu8c_BFu15i { bool v1; unsigned char v2:8; unsigned int v3:15; };
struct B_BFu8c_BFu15ll { bool v1; unsigned char v2:8; unsigned long long v3:15; };
struct B_BFu8c_BFu15s { bool v1; unsigned char v2:8; unsigned short v3:15; };
struct B_BFu8c_BFu16i { bool v1; unsigned char v2:8; unsigned int v3:16; };
struct B_BFu8c_BFu16ll { bool v1; unsigned char v2:8; unsigned long long v3:16; };
struct B_BFu8c_BFu16s { bool v1; unsigned char v2:8; unsigned short v3:16; };
struct B_BFu8c_BFu17i { bool v1; unsigned char v2:8; unsigned int v3:17; };
struct B_BFu8c_BFu17ll { bool v1; unsigned char v2:8; unsigned long long v3:17; };
struct B_BFu8c_BFu1c { bool v1; unsigned char v2:8; unsigned char v3:1; };
struct B_BFu8c_BFu1i { bool v1; unsigned char v2:8; unsigned int v3:1; };
struct B_BFu8c_BFu1ll { bool v1; unsigned char v2:8; unsigned long long v3:1; };
struct B_BFu8c_BFu1s { bool v1; unsigned char v2:8; unsigned short v3:1; };
struct B_BFu8c_BFu31i { bool v1; unsigned char v2:8; unsigned int v3:31; };
struct B_BFu8c_BFu31ll { bool v1; unsigned char v2:8; unsigned long long v3:31; };
struct B_BFu8c_BFu32i { bool v1; unsigned char v2:8; unsigned int v3:32; };
struct B_BFu8c_BFu32ll { bool v1; unsigned char v2:8; unsigned long long v3:32; };
struct B_BFu8c_BFu33 { bool v1; unsigned char v2:8; unsigned long long v3:33; };
struct B_BFu8c_BFu7c { bool v1; unsigned char v2:8; unsigned char v3:7; };
struct B_BFu8c_BFu7i { bool v1; unsigned char v2:8; unsigned int v3:7; };
struct B_BFu8c_BFu7ll { bool v1; unsigned char v2:8; unsigned long long v3:7; };
struct B_BFu8c_BFu7s { bool v1; unsigned char v2:8; unsigned short v3:7; };
struct B_BFu8c_BFu8c { bool v1; unsigned char v2:8; unsigned char v3:8; };
struct B_BFu8c_BFu8i { bool v1; unsigned char v2:8; unsigned int v3:8; };
struct B_BFu8c_BFu8ll { bool v1; unsigned char v2:8; unsigned long long v3:8; };
struct B_BFu8c_BFu8s { bool v1; unsigned char v2:8; unsigned short v3:8; };
struct B_BFu8c_BFu9i { bool v1; unsigned char v2:8; unsigned int v3:9; };
struct B_BFu8c_BFu9ll { bool v1; unsigned char v2:8; unsigned long long v3:9; };
struct B_BFu8c_BFu9s { bool v1; unsigned char v2:8; unsigned short v3:9; };
struct B_BFu8c_C { bool v1; unsigned char v2:8; char v3; };
struct B_BFu8c_D { bool v1; unsigned char v2:8; double v3; };
struct B_BFu8c_F { bool v1; unsigned char v2:8; float v3; };
struct B_BFu8c_I { bool v1; unsigned char v2:8; int v3; };
struct B_BFu8c_Ip { bool v1; unsigned char v2:8; int * v3; };
struct B_BFu8c_L { bool v1; unsigned char v2:8; long long v3; };
struct B_BFu8c_S { bool v1; unsigned char v2:8; short v3; };
struct B_BFu8c_Uc { bool v1; unsigned char v2:8; unsigned char v3; };
struct B_BFu8c_Ui { bool v1; unsigned char v2:8; unsigned int v3; };
struct B_BFu8c_Ul { bool v1; unsigned char v2:8; unsigned long long v3; };
struct B_BFu8c_Us { bool v1; unsigned char v2:8; unsigned short v3; };
struct B_BFu8c_Vp { bool v1; unsigned char v2:8; void * v3; };
struct B_BFu8i { bool v1; unsigned int v2:8; };
struct B_BFu8i_B { bool v1; unsigned int v2:8; bool v3; };
struct B_BFu8i_BFu15i { bool v1; unsigned int v2:8; unsigned int v3:15; };
struct B_BFu8i_BFu15ll { bool v1; unsigned int v2:8; unsigned long long v3:15; };
struct B_BFu8i_BFu15s { bool v1; unsigned int v2:8; unsigned short v3:15; };
struct B_BFu8i_BFu16i { bool v1; unsigned int v2:8; unsigned int v3:16; };
struct B_BFu8i_BFu16ll { bool v1; unsigned int v2:8; unsigned long long v3:16; };
struct B_BFu8i_BFu16s { bool v1; unsigned int v2:8; unsigned short v3:16; };
struct B_BFu8i_BFu17i { bool v1; unsigned int v2:8; unsigned int v3:17; };
struct B_BFu8i_BFu17ll { bool v1; unsigned int v2:8; unsigned long long v3:17; };
struct B_BFu8i_BFu1c { bool v1; unsigned int v2:8; unsigned char v3:1; };
struct B_BFu8i_BFu1i { bool v1; unsigned int v2:8; unsigned int v3:1; };
struct B_BFu8i_BFu1ll { bool v1; unsigned int v2:8; unsigned long long v3:1; };
struct B_BFu8i_BFu1s { bool v1; unsigned int v2:8; unsigned short v3:1; };
struct B_BFu8i_BFu31i { bool v1; unsigned int v2:8; unsigned int v3:31; };
struct B_BFu8i_BFu31ll { bool v1; unsigned int v2:8; unsigned long long v3:31; };
struct B_BFu8i_BFu32i { bool v1; unsigned int v2:8; unsigned int v3:32; };
struct B_BFu8i_BFu32ll { bool v1; unsigned int v2:8; unsigned long long v3:32; };
struct B_BFu8i_BFu33 { bool v1; unsigned int v2:8; unsigned long long v3:33; };
struct B_BFu8i_BFu7c { bool v1; unsigned int v2:8; unsigned char v3:7; };
struct B_BFu8i_BFu7i { bool v1; unsigned int v2:8; unsigned int v3:7; };
struct B_BFu8i_BFu7ll { bool v1; unsigned int v2:8; unsigned long long v3:7; };
struct B_BFu8i_BFu7s { bool v1; unsigned int v2:8; unsigned short v3:7; };
struct B_BFu8i_BFu8c { bool v1; unsigned int v2:8; unsigned char v3:8; };
struct B_BFu8i_BFu8i { bool v1; unsigned int v2:8; unsigned int v3:8; };
struct B_BFu8i_BFu8ll { bool v1; unsigned int v2:8; unsigned long long v3:8; };
struct B_BFu8i_BFu8s { bool v1; unsigned int v2:8; unsigned short v3:8; };
struct B_BFu8i_BFu9i { bool v1; unsigned int v2:8; unsigned int v3:9; };
struct B_BFu8i_BFu9ll { bool v1; unsigned int v2:8; unsigned long long v3:9; };
struct B_BFu8i_BFu9s { bool v1; unsigned int v2:8; unsigned short v3:9; };
#endif // __cplusplus
#ifdef __cplusplus


static void Test_aBFu32ll_BFu16s_B()
{
  {
    init_simple_test("aBFu32ll_BFu16s_B");
    static aBFu32ll_BFu16s_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu32ll_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu16s_B");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aBFu32ll_BFu16s_B");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aBFu32ll_BFu16s_B");
    check_field_offset(lv, v3, 6, "aBFu32ll_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu16s_B(Test_aBFu32ll_BFu16s_B, "aBFu32ll_BFu16s_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu17i_B()
{
  {
    init_simple_test("aBFu32ll_BFu17i_B");
    static aBFu32ll_BFu17i_B lv;
    check2(sizeof(lv), 8, "sizeof(aBFu32ll_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu17i_B");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aBFu32ll_BFu17i_B");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aBFu32ll_BFu17i_B");
    check_field_offset(lv, v3, 7, "aBFu32ll_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu17i_B(Test_aBFu32ll_BFu17i_B, "aBFu32ll_BFu17i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu17ll_B()
{
  {
    init_simple_test("aBFu32ll_BFu17ll_B");
    static aBFu32ll_BFu17ll_B lv;
    check2(sizeof(lv), 8, "sizeof(aBFu32ll_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aBFu32ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aBFu32ll_BFu17ll_B");
    check_field_offset(lv, v3, 7, "aBFu32ll_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu17ll_B(Test_aBFu32ll_BFu17ll_B, "aBFu32ll_BFu17ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu1c_B()
{
  {
    init_simple_test("aBFu32ll_BFu1c_B");
    static aBFu32ll_BFu1c_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu1c_B");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu32ll_BFu1c_B");
    check_field_offset(lv, v3, 5, "aBFu32ll_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu1c_B(Test_aBFu32ll_BFu1c_B, "aBFu32ll_BFu1c_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu1i_B()
{
  {
    init_simple_test("aBFu32ll_BFu1i_B");
    static aBFu32ll_BFu1i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu1i_B");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu32ll_BFu1i_B");
    check_field_offset(lv, v3, 5, "aBFu32ll_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu1i_B(Test_aBFu32ll_BFu1i_B, "aBFu32ll_BFu1i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu1ll_B()
{
  {
    init_simple_test("aBFu32ll_BFu1ll_B");
    static aBFu32ll_BFu1ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu1ll_B");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu32ll_BFu1ll_B");
    check_field_offset(lv, v3, 5, "aBFu32ll_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu1ll_B(Test_aBFu32ll_BFu1ll_B, "aBFu32ll_BFu1ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu1s_B()
{
  {
    init_simple_test("aBFu32ll_BFu1s_B");
    static aBFu32ll_BFu1s_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu1s_B");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu32ll_BFu1s_B");
    check_field_offset(lv, v3, 5, "aBFu32ll_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu1s_B(Test_aBFu32ll_BFu1s_B, "aBFu32ll_BFu1s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu31i_B()
{
  {
    init_simple_test("aBFu32ll_BFu31i_B");
    static aBFu32ll_BFu31i_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu32ll_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aBFu32ll_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aBFu32ll_BFu31i_B");
    check_field_offset(lv, v3, 8, "aBFu32ll_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu31i_B(Test_aBFu32ll_BFu31i_B, "aBFu32ll_BFu31i_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu31ll_B()
{
  {
    init_simple_test("aBFu32ll_BFu31ll_B");
    static aBFu32ll_BFu31ll_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu32ll_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aBFu32ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aBFu32ll_BFu31ll_B");
    check_field_offset(lv, v3, 8, "aBFu32ll_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu31ll_B(Test_aBFu32ll_BFu31ll_B, "aBFu32ll_BFu31ll_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu32i_B()
{
  {
    init_simple_test("aBFu32ll_BFu32i_B");
    static aBFu32ll_BFu32i_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu32ll_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aBFu32ll_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu32i_B");
    check_field_offset(lv, v3, 8, "aBFu32ll_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu32i_B(Test_aBFu32ll_BFu32i_B, "aBFu32ll_BFu32i_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu32ll_B()
{
  {
    init_simple_test("aBFu32ll_BFu32ll_B");
    static aBFu32ll_BFu32ll_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu32ll_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aBFu32ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu32ll_B");
    check_field_offset(lv, v3, 8, "aBFu32ll_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu32ll_B(Test_aBFu32ll_BFu32ll_B, "aBFu32ll_BFu32ll_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu33_B()
{
  {
    init_simple_test("aBFu32ll_BFu33_B");
    static aBFu32ll_BFu33_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu32ll_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu33_B");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aBFu32ll_BFu33_B");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aBFu32ll_BFu33_B");
    check_field_offset(lv, v3, 9, "aBFu32ll_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu33_B(Test_aBFu32ll_BFu33_B, "aBFu32ll_BFu33_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu7c_B()
{
  {
    init_simple_test("aBFu32ll_BFu7c_B");
    static aBFu32ll_BFu7c_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu7c_B");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu32ll_BFu7c_B");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu32ll_BFu7c_B");
    check_field_offset(lv, v3, 5, "aBFu32ll_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu7c_B(Test_aBFu32ll_BFu7c_B, "aBFu32ll_BFu7c_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu7i_B()
{
  {
    init_simple_test("aBFu32ll_BFu7i_B");
    static aBFu32ll_BFu7i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu7i_B");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu32ll_BFu7i_B");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu32ll_BFu7i_B");
    check_field_offset(lv, v3, 5, "aBFu32ll_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu7i_B(Test_aBFu32ll_BFu7i_B, "aBFu32ll_BFu7i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu7ll_B()
{
  {
    init_simple_test("aBFu32ll_BFu7ll_B");
    static aBFu32ll_BFu7ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu32ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu32ll_BFu7ll_B");
    check_field_offset(lv, v3, 5, "aBFu32ll_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu7ll_B(Test_aBFu32ll_BFu7ll_B, "aBFu32ll_BFu7ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu7s_B()
{
  {
    init_simple_test("aBFu32ll_BFu7s_B");
    static aBFu32ll_BFu7s_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu7s_B");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu32ll_BFu7s_B");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu32ll_BFu7s_B");
    check_field_offset(lv, v3, 5, "aBFu32ll_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu7s_B(Test_aBFu32ll_BFu7s_B, "aBFu32ll_BFu7s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu8c_B()
{
  {
    init_simple_test("aBFu32ll_BFu8c_B");
    static aBFu32ll_BFu8c_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu8c_B");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu32ll_BFu8c_B");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu32ll_BFu8c_B");
    check_field_offset(lv, v3, 5, "aBFu32ll_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu8c_B(Test_aBFu32ll_BFu8c_B, "aBFu32ll_BFu8c_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu8i_B()
{
  {
    init_simple_test("aBFu32ll_BFu8i_B");
    static aBFu32ll_BFu8i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu8i_B");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu32ll_BFu8i_B");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu32ll_BFu8i_B");
    check_field_offset(lv, v3, 5, "aBFu32ll_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu8i_B(Test_aBFu32ll_BFu8i_B, "aBFu32ll_BFu8i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu8ll_B()
{
  {
    init_simple_test("aBFu32ll_BFu8ll_B");
    static aBFu32ll_BFu8ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu32ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu32ll_BFu8ll_B");
    check_field_offset(lv, v3, 5, "aBFu32ll_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu8ll_B(Test_aBFu32ll_BFu8ll_B, "aBFu32ll_BFu8ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu8s_B()
{
  {
    init_simple_test("aBFu32ll_BFu8s_B");
    static aBFu32ll_BFu8s_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu8s_B");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu32ll_BFu8s_B");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu32ll_BFu8s_B");
    check_field_offset(lv, v3, 5, "aBFu32ll_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu8s_B(Test_aBFu32ll_BFu8s_B, "aBFu32ll_BFu8s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu9i_B()
{
  {
    init_simple_test("aBFu32ll_BFu9i_B");
    static aBFu32ll_BFu9i_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu32ll_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu9i_B");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aBFu32ll_BFu9i_B");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aBFu32ll_BFu9i_B");
    check_field_offset(lv, v3, 6, "aBFu32ll_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu9i_B(Test_aBFu32ll_BFu9i_B, "aBFu32ll_BFu9i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu9ll_B()
{
  {
    init_simple_test("aBFu32ll_BFu9ll_B");
    static aBFu32ll_BFu9ll_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu32ll_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aBFu32ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aBFu32ll_BFu9ll_B");
    check_field_offset(lv, v3, 6, "aBFu32ll_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu9ll_B(Test_aBFu32ll_BFu9ll_B, "aBFu32ll_BFu9ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_BFu9s_B()
{
  {
    init_simple_test("aBFu32ll_BFu9s_B");
    static aBFu32ll_BFu9s_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu32ll_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu9s_B");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aBFu32ll_BFu9s_B");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aBFu32ll_BFu9s_B");
    check_field_offset(lv, v3, 6, "aBFu32ll_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_BFu9s_B(Test_aBFu32ll_BFu9s_B, "aBFu32ll_BFu9s_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_C_B()
{
  {
    init_simple_test("aBFu32ll_C_B");
    static aBFu32ll_C_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_C_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_C_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_C_B.v2");
    check_field_offset(lv, v3, 5, "aBFu32ll_C_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_C_B(Test_aBFu32ll_C_B, "aBFu32ll_C_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_D_B()
{
  {
    init_simple_test("aBFu32ll_D_B");
    static aBFu32ll_D_B lv;
    check2(sizeof(lv), 13, "sizeof(aBFu32ll_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_D_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_D_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_D_B.v2");
    check_field_offset(lv, v3, 12, "aBFu32ll_D_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_D_B(Test_aBFu32ll_D_B, "aBFu32ll_D_B", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_F_B()
{
  {
    init_simple_test("aBFu32ll_F_B");
    static aBFu32ll_F_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu32ll_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_F_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_F_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_F_B.v2");
    check_field_offset(lv, v3, 8, "aBFu32ll_F_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_F_B(Test_aBFu32ll_F_B, "aBFu32ll_F_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_I_B()
{
  {
    init_simple_test("aBFu32ll_I_B");
    static aBFu32ll_I_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu32ll_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_I_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_I_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_I_B.v2");
    check_field_offset(lv, v3, 8, "aBFu32ll_I_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_I_B(Test_aBFu32ll_I_B, "aBFu32ll_I_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_Ip_B()
{
  {
    init_simple_test("aBFu32ll_Ip_B");
    static aBFu32ll_Ip_B lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu32ll_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_Ip_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aBFu32ll_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_Ip_B(Test_aBFu32ll_Ip_B, "aBFu32ll_Ip_B", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_L_B()
{
  {
    init_simple_test("aBFu32ll_L_B");
    static aBFu32ll_L_B lv;
    check2(sizeof(lv), 13, "sizeof(aBFu32ll_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_L_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_L_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_L_B.v2");
    check_field_offset(lv, v3, 12, "aBFu32ll_L_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_L_B(Test_aBFu32ll_L_B, "aBFu32ll_L_B", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_S_B()
{
  {
    init_simple_test("aBFu32ll_S_B");
    static aBFu32ll_S_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu32ll_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_S_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_S_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_S_B.v2");
    check_field_offset(lv, v3, 6, "aBFu32ll_S_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_S_B(Test_aBFu32ll_S_B, "aBFu32ll_S_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_Uc_B()
{
  {
    init_simple_test("aBFu32ll_Uc_B");
    static aBFu32ll_Uc_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu32ll_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_Uc_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_Uc_B.v2");
    check_field_offset(lv, v3, 5, "aBFu32ll_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_Uc_B(Test_aBFu32ll_Uc_B, "aBFu32ll_Uc_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_Ui_B()
{
  {
    init_simple_test("aBFu32ll_Ui_B");
    static aBFu32ll_Ui_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu32ll_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_Ui_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_Ui_B.v2");
    check_field_offset(lv, v3, 8, "aBFu32ll_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_Ui_B(Test_aBFu32ll_Ui_B, "aBFu32ll_Ui_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_Ul_B()
{
  {
    init_simple_test("aBFu32ll_Ul_B");
    static aBFu32ll_Ul_B lv;
    check2(sizeof(lv), 13, "sizeof(aBFu32ll_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_Ul_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_Ul_B.v2");
    check_field_offset(lv, v3, 12, "aBFu32ll_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_Ul_B(Test_aBFu32ll_Ul_B, "aBFu32ll_Ul_B", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_Us_B()
{
  {
    init_simple_test("aBFu32ll_Us_B");
    static aBFu32ll_Us_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu32ll_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_Us_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_Us_B.v2");
    check_field_offset(lv, v3, 6, "aBFu32ll_Us_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_Us_B(Test_aBFu32ll_Us_B, "aBFu32ll_Us_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu32ll_Vp_B()
{
  {
    init_simple_test("aBFu32ll_Vp_B");
    static aBFu32ll_Vp_B lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu32ll_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_Vp_B");
    check_field_offset(lv, v2, 4, "aBFu32ll_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aBFu32ll_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu32ll_Vp_B(Test_aBFu32ll_Vp_B, "aBFu32ll_Vp_B", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B()
{
  {
    init_simple_test("aBFu33_B");
    static aBFu33_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B");
    check_field_offset(lv, v2, 5, "aBFu33_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu33_B(Test_aBFu33_B, "aBFu33_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_B()
{
  {
    init_simple_test("aBFu33_B_B");
    static aBFu33_B_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_B");
    check_field_offset(lv, v2, 5, "aBFu33_B_B.v2");
    check_field_offset(lv, v3, 6, "aBFu33_B_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_B_B(Test_aBFu33_B_B, "aBFu33_B_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu15i()
{
  {
    init_simple_test("aBFu33_B_BFu15i");
    static aBFu33_B_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu15i");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aBFu33_B_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aBFu33_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu15i(Test_aBFu33_B_BFu15i, "aBFu33_B_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu15ll()
{
  {
    init_simple_test("aBFu33_B_BFu15ll");
    static aBFu33_B_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu15ll");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aBFu33_B_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aBFu33_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu15ll(Test_aBFu33_B_BFu15ll, "aBFu33_B_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu15s()
{
  {
    init_simple_test("aBFu33_B_BFu15s");
    static aBFu33_B_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu15s");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aBFu33_B_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aBFu33_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu15s(Test_aBFu33_B_BFu15s, "aBFu33_B_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu16i()
{
  {
    init_simple_test("aBFu33_B_BFu16i");
    static aBFu33_B_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu16i");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aBFu33_B_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aBFu33_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu16i(Test_aBFu33_B_BFu16i, "aBFu33_B_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu16ll()
{
  {
    init_simple_test("aBFu33_B_BFu16ll");
    static aBFu33_B_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu16ll");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aBFu33_B_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aBFu33_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu16ll(Test_aBFu33_B_BFu16ll, "aBFu33_B_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu16s()
{
  {
    init_simple_test("aBFu33_B_BFu16s");
    static aBFu33_B_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu16s");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aBFu33_B_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aBFu33_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu16s(Test_aBFu33_B_BFu16s, "aBFu33_B_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu17i()
{
  {
    init_simple_test("aBFu33_B_BFu17i");
    static aBFu33_B_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu33_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu17i");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aBFu33_B_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aBFu33_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu17i(Test_aBFu33_B_BFu17i, "aBFu33_B_BFu17i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu17ll()
{
  {
    init_simple_test("aBFu33_B_BFu17ll");
    static aBFu33_B_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu33_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu17ll");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aBFu33_B_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aBFu33_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu17ll(Test_aBFu33_B_BFu17ll, "aBFu33_B_BFu17ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu1c()
{
  {
    init_simple_test("aBFu33_B_BFu1c");
    static aBFu33_B_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu1c");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aBFu33_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu1c(Test_aBFu33_B_BFu1c, "aBFu33_B_BFu1c", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu1i()
{
  {
    init_simple_test("aBFu33_B_BFu1i");
    static aBFu33_B_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu1i");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aBFu33_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu1i(Test_aBFu33_B_BFu1i, "aBFu33_B_BFu1i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu1ll()
{
  {
    init_simple_test("aBFu33_B_BFu1ll");
    static aBFu33_B_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu1ll");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aBFu33_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu1ll(Test_aBFu33_B_BFu1ll, "aBFu33_B_BFu1ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu1s()
{
  {
    init_simple_test("aBFu33_B_BFu1s");
    static aBFu33_B_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu1s");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aBFu33_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu1s(Test_aBFu33_B_BFu1s, "aBFu33_B_BFu1s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu31i()
{
  {
    init_simple_test("aBFu33_B_BFu31i");
    static aBFu33_B_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu33_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu31i");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aBFu33_B_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aBFu33_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu31i(Test_aBFu33_B_BFu31i, "aBFu33_B_BFu31i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu31ll()
{
  {
    init_simple_test("aBFu33_B_BFu31ll");
    static aBFu33_B_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu33_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu31ll");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aBFu33_B_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aBFu33_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu31ll(Test_aBFu33_B_BFu31ll, "aBFu33_B_BFu31ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu32i()
{
  {
    init_simple_test("aBFu33_B_BFu32i");
    static aBFu33_B_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu33_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu32i");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aBFu33_B_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aBFu33_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu32i(Test_aBFu33_B_BFu32i, "aBFu33_B_BFu32i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu32ll()
{
  {
    init_simple_test("aBFu33_B_BFu32ll");
    static aBFu33_B_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu33_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu32ll");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aBFu33_B_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aBFu33_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu32ll(Test_aBFu33_B_BFu32ll, "aBFu33_B_BFu32ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu33()
{
  {
    init_simple_test("aBFu33_B_BFu33");
    static aBFu33_B_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(aBFu33_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu33");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu33.v2");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "aBFu33_B_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu33(Test_aBFu33_B_BFu33, "aBFu33_B_BFu33", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu7c()
{
  {
    init_simple_test("aBFu33_B_BFu7c");
    static aBFu33_B_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu7c");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aBFu33_B_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aBFu33_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu7c(Test_aBFu33_B_BFu7c, "aBFu33_B_BFu7c", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu7i()
{
  {
    init_simple_test("aBFu33_B_BFu7i");
    static aBFu33_B_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu7i");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aBFu33_B_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aBFu33_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu7i(Test_aBFu33_B_BFu7i, "aBFu33_B_BFu7i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu7ll()
{
  {
    init_simple_test("aBFu33_B_BFu7ll");
    static aBFu33_B_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu7ll");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aBFu33_B_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aBFu33_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu7ll(Test_aBFu33_B_BFu7ll, "aBFu33_B_BFu7ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu7s()
{
  {
    init_simple_test("aBFu33_B_BFu7s");
    static aBFu33_B_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu7s");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aBFu33_B_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aBFu33_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu7s(Test_aBFu33_B_BFu7s, "aBFu33_B_BFu7s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu8c()
{
  {
    init_simple_test("aBFu33_B_BFu8c");
    static aBFu33_B_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu8c");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aBFu33_B_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aBFu33_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu8c(Test_aBFu33_B_BFu8c, "aBFu33_B_BFu8c", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu8i()
{
  {
    init_simple_test("aBFu33_B_BFu8i");
    static aBFu33_B_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu8i");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aBFu33_B_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aBFu33_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu8i(Test_aBFu33_B_BFu8i, "aBFu33_B_BFu8i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu8ll()
{
  {
    init_simple_test("aBFu33_B_BFu8ll");
    static aBFu33_B_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu8ll");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aBFu33_B_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aBFu33_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu8ll(Test_aBFu33_B_BFu8ll, "aBFu33_B_BFu8ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu8s()
{
  {
    init_simple_test("aBFu33_B_BFu8s");
    static aBFu33_B_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu8s");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aBFu33_B_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aBFu33_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu8s(Test_aBFu33_B_BFu8s, "aBFu33_B_BFu8s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu9i()
{
  {
    init_simple_test("aBFu33_B_BFu9i");
    static aBFu33_B_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu9i");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aBFu33_B_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aBFu33_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu9i(Test_aBFu33_B_BFu9i, "aBFu33_B_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu9ll()
{
  {
    init_simple_test("aBFu33_B_BFu9ll");
    static aBFu33_B_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu9ll");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aBFu33_B_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aBFu33_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu9ll(Test_aBFu33_B_BFu9ll, "aBFu33_B_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_BFu9s()
{
  {
    init_simple_test("aBFu33_B_BFu9s");
    static aBFu33_B_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_BFu9s");
    check_field_offset(lv, v2, 5, "aBFu33_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aBFu33_B_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aBFu33_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu33_B_BFu9s(Test_aBFu33_B_BFu9s, "aBFu33_B_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_C()
{
  {
    init_simple_test("aBFu33_B_C");
    static aBFu33_B_C lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_C");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_C");
    check_field_offset(lv, v2, 5, "aBFu33_B_C.v2");
    check_field_offset(lv, v3, 6, "aBFu33_B_C.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_B_C(Test_aBFu33_B_C, "aBFu33_B_C", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_D()
{
  {
    init_simple_test("aBFu33_B_D");
    static aBFu33_B_D lv;
    check2(sizeof(lv), 14, "sizeof(aBFu33_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_D");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_D");
    check_field_offset(lv, v2, 5, "aBFu33_B_D.v2");
    check_field_offset(lv, v3, 6, "aBFu33_B_D.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_B_D(Test_aBFu33_B_D, "aBFu33_B_D", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_F()
{
  {
    init_simple_test("aBFu33_B_F");
    static aBFu33_B_F lv;
    check2(sizeof(lv), 10, "sizeof(aBFu33_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_F");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_F");
    check_field_offset(lv, v2, 5, "aBFu33_B_F.v2");
    check_field_offset(lv, v3, 6, "aBFu33_B_F.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_B_F(Test_aBFu33_B_F, "aBFu33_B_F", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_I()
{
  {
    init_simple_test("aBFu33_B_I");
    static aBFu33_B_I lv;
    check2(sizeof(lv), 10, "sizeof(aBFu33_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_I");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_I");
    check_field_offset(lv, v2, 5, "aBFu33_B_I.v2");
    check_field_offset(lv, v3, 6, "aBFu33_B_I.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_B_I(Test_aBFu33_B_I, "aBFu33_B_I", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_Ip()
{
  {
    init_simple_test("aBFu33_B_Ip");
    static aBFu33_B_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu33_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_Ip");
    check_field_offset(lv, v2, 5, "aBFu33_B_Ip.v2");
    check_field_offset(lv, v3, 6, "aBFu33_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_B_Ip(Test_aBFu33_B_Ip, "aBFu33_B_Ip", ABISELECT(14,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_L()
{
  {
    init_simple_test("aBFu33_B_L");
    static aBFu33_B_L lv;
    check2(sizeof(lv), 14, "sizeof(aBFu33_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_L");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_L");
    check_field_offset(lv, v2, 5, "aBFu33_B_L.v2");
    check_field_offset(lv, v3, 6, "aBFu33_B_L.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_B_L(Test_aBFu33_B_L, "aBFu33_B_L", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_S()
{
  {
    init_simple_test("aBFu33_B_S");
    static aBFu33_B_S lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_S");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_S");
    check_field_offset(lv, v2, 5, "aBFu33_B_S.v2");
    check_field_offset(lv, v3, 6, "aBFu33_B_S.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_B_S(Test_aBFu33_B_S, "aBFu33_B_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_Uc()
{
  {
    init_simple_test("aBFu33_B_Uc");
    static aBFu33_B_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_Uc");
    check_field_offset(lv, v2, 5, "aBFu33_B_Uc.v2");
    check_field_offset(lv, v3, 6, "aBFu33_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_B_Uc(Test_aBFu33_B_Uc, "aBFu33_B_Uc", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_Ui()
{
  {
    init_simple_test("aBFu33_B_Ui");
    static aBFu33_B_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aBFu33_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_Ui");
    check_field_offset(lv, v2, 5, "aBFu33_B_Ui.v2");
    check_field_offset(lv, v3, 6, "aBFu33_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_B_Ui(Test_aBFu33_B_Ui, "aBFu33_B_Ui", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_Ul()
{
  {
    init_simple_test("aBFu33_B_Ul");
    static aBFu33_B_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aBFu33_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_Ul");
    check_field_offset(lv, v2, 5, "aBFu33_B_Ul.v2");
    check_field_offset(lv, v3, 6, "aBFu33_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_B_Ul(Test_aBFu33_B_Ul, "aBFu33_B_Ul", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_Us()
{
  {
    init_simple_test("aBFu33_B_Us");
    static aBFu33_B_Us lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_Us");
    check_field_offset(lv, v2, 5, "aBFu33_B_Us.v2");
    check_field_offset(lv, v3, 6, "aBFu33_B_Us.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_B_Us(Test_aBFu33_B_Us, "aBFu33_B_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_B_Vp()
{
  {
    init_simple_test("aBFu33_B_Vp");
    static aBFu33_B_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu33_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_B_Vp");
    check_field_offset(lv, v2, 5, "aBFu33_B_Vp.v2");
    check_field_offset(lv, v3, 6, "aBFu33_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_B_Vp(Test_aBFu33_B_Vp, "aBFu33_B_Vp", ABISELECT(14,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu15i_B()
{
  {
    init_simple_test("aBFu33_BFu15i_B");
    static aBFu33_BFu15i_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu15i_B");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "aBFu33_BFu15i_B");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "aBFu33_BFu15i_B");
    check_field_offset(lv, v3, 6, "aBFu33_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu15i_B(Test_aBFu33_BFu15i_B, "aBFu33_BFu15i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu15ll_B()
{
  {
    init_simple_test("aBFu33_BFu15ll_B");
    static aBFu33_BFu15ll_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu15ll_B");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "aBFu33_BFu15ll_B");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "aBFu33_BFu15ll_B");
    check_field_offset(lv, v3, 6, "aBFu33_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu15ll_B(Test_aBFu33_BFu15ll_B, "aBFu33_BFu15ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu15s_B()
{
  {
    init_simple_test("aBFu33_BFu15s_B");
    static aBFu33_BFu15s_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu15s_B");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "aBFu33_BFu15s_B");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "aBFu33_BFu15s_B");
    check_field_offset(lv, v3, 6, "aBFu33_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu15s_B(Test_aBFu33_BFu15s_B, "aBFu33_BFu15s_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu16i_B()
{
  {
    init_simple_test("aBFu33_BFu16i_B");
    static aBFu33_BFu16i_B lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu16i_B");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "aBFu33_BFu16i_B");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "aBFu33_BFu16i_B");
    check_field_offset(lv, v3, 7, "aBFu33_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu16i_B(Test_aBFu33_BFu16i_B, "aBFu33_BFu16i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu16ll_B()
{
  {
    init_simple_test("aBFu33_BFu16ll_B");
    static aBFu33_BFu16ll_B lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu16ll_B");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "aBFu33_BFu16ll_B");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "aBFu33_BFu16ll_B");
    check_field_offset(lv, v3, 7, "aBFu33_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu16ll_B(Test_aBFu33_BFu16ll_B, "aBFu33_BFu16ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu16s_B()
{
  {
    init_simple_test("aBFu33_BFu16s_B");
    static aBFu33_BFu16s_B lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu16s_B");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "aBFu33_BFu16s_B");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "aBFu33_BFu16s_B");
    check_field_offset(lv, v3, 7, "aBFu33_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu16s_B(Test_aBFu33_BFu16s_B, "aBFu33_BFu16s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu17i_B()
{
  {
    init_simple_test("aBFu33_BFu17i_B");
    static aBFu33_BFu17i_B lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu17i_B");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "aBFu33_BFu17i_B");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "aBFu33_BFu17i_B");
    check_field_offset(lv, v3, 7, "aBFu33_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu17i_B(Test_aBFu33_BFu17i_B, "aBFu33_BFu17i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu17ll_B()
{
  {
    init_simple_test("aBFu33_BFu17ll_B");
    static aBFu33_BFu17ll_B lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu17ll_B");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "aBFu33_BFu17ll_B");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "aBFu33_BFu17ll_B");
    check_field_offset(lv, v3, 7, "aBFu33_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu17ll_B(Test_aBFu33_BFu17ll_B, "aBFu33_BFu17ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu1c_B()
{
  {
    init_simple_test("aBFu33_BFu1c_B");
    static aBFu33_BFu1c_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu33_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu1c_B");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "aBFu33_BFu1c_B");
    check_field_offset(lv, v3, 5, "aBFu33_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu1c_B(Test_aBFu33_BFu1c_B, "aBFu33_BFu1c_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu1i_B()
{
  {
    init_simple_test("aBFu33_BFu1i_B");
    static aBFu33_BFu1i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu33_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu1i_B");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "aBFu33_BFu1i_B");
    check_field_offset(lv, v3, 5, "aBFu33_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu1i_B(Test_aBFu33_BFu1i_B, "aBFu33_BFu1i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu1ll_B()
{
  {
    init_simple_test("aBFu33_BFu1ll_B");
    static aBFu33_BFu1ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu33_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu1ll_B");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "aBFu33_BFu1ll_B");
    check_field_offset(lv, v3, 5, "aBFu33_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu1ll_B(Test_aBFu33_BFu1ll_B, "aBFu33_BFu1ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu1s_B()
{
  {
    init_simple_test("aBFu33_BFu1s_B");
    static aBFu33_BFu1s_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu33_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu1s_B");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "aBFu33_BFu1s_B");
    check_field_offset(lv, v3, 5, "aBFu33_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu1s_B(Test_aBFu33_BFu1s_B, "aBFu33_BFu1s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu31i_B()
{
  {
    init_simple_test("aBFu33_BFu31i_B");
    static aBFu33_BFu31i_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu33_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "aBFu33_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "aBFu33_BFu31i_B");
    check_field_offset(lv, v3, 8, "aBFu33_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu31i_B(Test_aBFu33_BFu31i_B, "aBFu33_BFu31i_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu31ll_B()
{
  {
    init_simple_test("aBFu33_BFu31ll_B");
    static aBFu33_BFu31ll_B lv;
    check2(sizeof(lv), 9, "sizeof(aBFu33_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu31ll_B");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "aBFu33_BFu31ll_B");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "aBFu33_BFu31ll_B");
    check_field_offset(lv, v3, 8, "aBFu33_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu31ll_B(Test_aBFu33_BFu31ll_B, "aBFu33_BFu31ll_B", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu32i_B()
{
  {
    init_simple_test("aBFu33_BFu32i_B");
    static aBFu33_BFu32i_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu33_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 1, 32, 1, "aBFu33_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 1, 32, hide_ull(1LL<<31), "aBFu33_BFu32i_B");
    check_field_offset(lv, v3, 9, "aBFu33_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu32i_B(Test_aBFu33_BFu32i_B, "aBFu33_BFu32i_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu32ll_B()
{
  {
    init_simple_test("aBFu33_BFu32ll_B");
    static aBFu33_BFu32ll_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu33_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu32ll_B");
    set_bf_and_test(lv, v2, 4, 1, 32, 1, "aBFu33_BFu32ll_B");
    set_bf_and_test(lv, v2, 4, 1, 32, hide_ull(1LL<<31), "aBFu33_BFu32ll_B");
    check_field_offset(lv, v3, 9, "aBFu33_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu32ll_B(Test_aBFu33_BFu32ll_B, "aBFu33_BFu32ll_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu33_B()
{
  {
    init_simple_test("aBFu33_BFu33_B");
    static aBFu33_BFu33_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu33_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu33_B");
    set_bf_and_test(lv, v2, 4, 1, 33, 1, "aBFu33_BFu33_B");
    set_bf_and_test(lv, v2, 4, 1, 33, hide_ull(1LL<<32), "aBFu33_BFu33_B");
    check_field_offset(lv, v3, 9, "aBFu33_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu33_B(Test_aBFu33_BFu33_B, "aBFu33_BFu33_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu7c_B()
{
  {
    init_simple_test("aBFu33_BFu7c_B");
    static aBFu33_BFu7c_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu33_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu7c_B");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "aBFu33_BFu7c_B");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "aBFu33_BFu7c_B");
    check_field_offset(lv, v3, 5, "aBFu33_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu7c_B(Test_aBFu33_BFu7c_B, "aBFu33_BFu7c_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu7i_B()
{
  {
    init_simple_test("aBFu33_BFu7i_B");
    static aBFu33_BFu7i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu33_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu7i_B");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "aBFu33_BFu7i_B");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "aBFu33_BFu7i_B");
    check_field_offset(lv, v3, 5, "aBFu33_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu7i_B(Test_aBFu33_BFu7i_B, "aBFu33_BFu7i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu7ll_B()
{
  {
    init_simple_test("aBFu33_BFu7ll_B");
    static aBFu33_BFu7ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu33_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu7ll_B");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "aBFu33_BFu7ll_B");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "aBFu33_BFu7ll_B");
    check_field_offset(lv, v3, 5, "aBFu33_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu7ll_B(Test_aBFu33_BFu7ll_B, "aBFu33_BFu7ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu7s_B()
{
  {
    init_simple_test("aBFu33_BFu7s_B");
    static aBFu33_BFu7s_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu33_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu7s_B");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "aBFu33_BFu7s_B");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "aBFu33_BFu7s_B");
    check_field_offset(lv, v3, 5, "aBFu33_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu7s_B(Test_aBFu33_BFu7s_B, "aBFu33_BFu7s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu8c_B()
{
  {
    init_simple_test("aBFu33_BFu8c_B");
    static aBFu33_BFu8c_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu8c_B");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "aBFu33_BFu8c_B");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "aBFu33_BFu8c_B");
    check_field_offset(lv, v3, 6, "aBFu33_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu8c_B(Test_aBFu33_BFu8c_B, "aBFu33_BFu8c_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu8i_B()
{
  {
    init_simple_test("aBFu33_BFu8i_B");
    static aBFu33_BFu8i_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu8i_B");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "aBFu33_BFu8i_B");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "aBFu33_BFu8i_B");
    check_field_offset(lv, v3, 6, "aBFu33_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu8i_B(Test_aBFu33_BFu8i_B, "aBFu33_BFu8i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu8ll_B()
{
  {
    init_simple_test("aBFu33_BFu8ll_B");
    static aBFu33_BFu8ll_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu8ll_B");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "aBFu33_BFu8ll_B");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "aBFu33_BFu8ll_B");
    check_field_offset(lv, v3, 6, "aBFu33_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu8ll_B(Test_aBFu33_BFu8ll_B, "aBFu33_BFu8ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu8s_B()
{
  {
    init_simple_test("aBFu33_BFu8s_B");
    static aBFu33_BFu8s_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu8s_B");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "aBFu33_BFu8s_B");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "aBFu33_BFu8s_B");
    check_field_offset(lv, v3, 6, "aBFu33_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu8s_B(Test_aBFu33_BFu8s_B, "aBFu33_BFu8s_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu9i_B()
{
  {
    init_simple_test("aBFu33_BFu9i_B");
    static aBFu33_BFu9i_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu9i_B");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "aBFu33_BFu9i_B");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "aBFu33_BFu9i_B");
    check_field_offset(lv, v3, 6, "aBFu33_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu9i_B(Test_aBFu33_BFu9i_B, "aBFu33_BFu9i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu9ll_B()
{
  {
    init_simple_test("aBFu33_BFu9ll_B");
    static aBFu33_BFu9ll_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu9ll_B");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "aBFu33_BFu9ll_B");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "aBFu33_BFu9ll_B");
    check_field_offset(lv, v3, 6, "aBFu33_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu9ll_B(Test_aBFu33_BFu9ll_B, "aBFu33_BFu9ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_BFu9s_B()
{
  {
    init_simple_test("aBFu33_BFu9s_B");
    static aBFu33_BFu9s_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu9s_B");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "aBFu33_BFu9s_B");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "aBFu33_BFu9s_B");
    check_field_offset(lv, v3, 6, "aBFu33_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_BFu9s_B(Test_aBFu33_BFu9s_B, "aBFu33_BFu9s_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_C_B()
{
  {
    init_simple_test("aBFu33_C_B");
    static aBFu33_C_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_C_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_C_B");
    check_field_offset(lv, v2, 5, "aBFu33_C_B.v2");
    check_field_offset(lv, v3, 6, "aBFu33_C_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_C_B(Test_aBFu33_C_B, "aBFu33_C_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_D_B()
{
  {
    init_simple_test("aBFu33_D_B");
    static aBFu33_D_B lv;
    check2(sizeof(lv), 14, "sizeof(aBFu33_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_D_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_D_B");
    check_field_offset(lv, v2, 5, "aBFu33_D_B.v2");
    check_field_offset(lv, v3, 13, "aBFu33_D_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_D_B(Test_aBFu33_D_B, "aBFu33_D_B", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_F_B()
{
  {
    init_simple_test("aBFu33_F_B");
    static aBFu33_F_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu33_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_F_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_F_B");
    check_field_offset(lv, v2, 5, "aBFu33_F_B.v2");
    check_field_offset(lv, v3, 9, "aBFu33_F_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_F_B(Test_aBFu33_F_B, "aBFu33_F_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_I_B()
{
  {
    init_simple_test("aBFu33_I_B");
    static aBFu33_I_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu33_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_I_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_I_B");
    check_field_offset(lv, v2, 5, "aBFu33_I_B.v2");
    check_field_offset(lv, v3, 9, "aBFu33_I_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_I_B(Test_aBFu33_I_B, "aBFu33_I_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_Ip_B()
{
  {
    init_simple_test("aBFu33_Ip_B");
    static aBFu33_Ip_B lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu33_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_Ip_B");
    check_field_offset(lv, v2, 5, "aBFu33_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(13,9), "aBFu33_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_Ip_B(Test_aBFu33_Ip_B, "aBFu33_Ip_B", ABISELECT(14,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_L_B()
{
  {
    init_simple_test("aBFu33_L_B");
    static aBFu33_L_B lv;
    check2(sizeof(lv), 14, "sizeof(aBFu33_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_L_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_L_B");
    check_field_offset(lv, v2, 5, "aBFu33_L_B.v2");
    check_field_offset(lv, v3, 13, "aBFu33_L_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_L_B(Test_aBFu33_L_B, "aBFu33_L_B", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_S_B()
{
  {
    init_simple_test("aBFu33_S_B");
    static aBFu33_S_B lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_S_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_S_B");
    check_field_offset(lv, v2, 5, "aBFu33_S_B.v2");
    check_field_offset(lv, v3, 7, "aBFu33_S_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_S_B(Test_aBFu33_S_B, "aBFu33_S_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_Uc_B()
{
  {
    init_simple_test("aBFu33_Uc_B");
    static aBFu33_Uc_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu33_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_Uc_B");
    check_field_offset(lv, v2, 5, "aBFu33_Uc_B.v2");
    check_field_offset(lv, v3, 6, "aBFu33_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_Uc_B(Test_aBFu33_Uc_B, "aBFu33_Uc_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_Ui_B()
{
  {
    init_simple_test("aBFu33_Ui_B");
    static aBFu33_Ui_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu33_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_Ui_B");
    check_field_offset(lv, v2, 5, "aBFu33_Ui_B.v2");
    check_field_offset(lv, v3, 9, "aBFu33_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_Ui_B(Test_aBFu33_Ui_B, "aBFu33_Ui_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_Ul_B()
{
  {
    init_simple_test("aBFu33_Ul_B");
    static aBFu33_Ul_B lv;
    check2(sizeof(lv), 14, "sizeof(aBFu33_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_Ul_B");
    check_field_offset(lv, v2, 5, "aBFu33_Ul_B.v2");
    check_field_offset(lv, v3, 13, "aBFu33_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_Ul_B(Test_aBFu33_Ul_B, "aBFu33_Ul_B", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_Us_B()
{
  {
    init_simple_test("aBFu33_Us_B");
    static aBFu33_Us_B lv;
    check2(sizeof(lv), 8, "sizeof(aBFu33_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_Us_B");
    check_field_offset(lv, v2, 5, "aBFu33_Us_B.v2");
    check_field_offset(lv, v3, 7, "aBFu33_Us_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_Us_B(Test_aBFu33_Us_B, "aBFu33_Us_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu33_Vp_B()
{
  {
    init_simple_test("aBFu33_Vp_B");
    static aBFu33_Vp_B lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu33_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_Vp_B");
    check_field_offset(lv, v2, 5, "aBFu33_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(13,9), "aBFu33_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu33_Vp_B(Test_aBFu33_Vp_B, "aBFu33_Vp_B", ABISELECT(14,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B()
{
  {
    init_simple_test("aBFu7c_B");
    static aBFu7c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B");
    check_field_offset(lv, v2, 1, "aBFu7c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7c_B(Test_aBFu7c_B, "aBFu7c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_B()
{
  {
    init_simple_test("aBFu7c_B_B");
    static aBFu7c_B_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_B");
    check_field_offset(lv, v2, 1, "aBFu7c_B_B.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_B_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_B(Test_aBFu7c_B_B, "aBFu7c_B_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu15i()
{
  {
    init_simple_test("aBFu7c_B_BFu15i");
    static aBFu7c_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu7c_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu7c_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu15i(Test_aBFu7c_B_BFu15i, "aBFu7c_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu15ll()
{
  {
    init_simple_test("aBFu7c_B_BFu15ll");
    static aBFu7c_B_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu7c_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu7c_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu15ll(Test_aBFu7c_B_BFu15ll, "aBFu7c_B_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu15s()
{
  {
    init_simple_test("aBFu7c_B_BFu15s");
    static aBFu7c_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu7c_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu7c_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu15s(Test_aBFu7c_B_BFu15s, "aBFu7c_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu16i()
{
  {
    init_simple_test("aBFu7c_B_BFu16i");
    static aBFu7c_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu7c_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu7c_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu16i(Test_aBFu7c_B_BFu16i, "aBFu7c_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu16ll()
{
  {
    init_simple_test("aBFu7c_B_BFu16ll");
    static aBFu7c_B_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu7c_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu7c_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu16ll(Test_aBFu7c_B_BFu16ll, "aBFu7c_B_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu16s()
{
  {
    init_simple_test("aBFu7c_B_BFu16s");
    static aBFu7c_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu7c_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu7c_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu16s(Test_aBFu7c_B_BFu16s, "aBFu7c_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu17i()
{
  {
    init_simple_test("aBFu7c_B_BFu17i");
    static aBFu7c_B_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu7c_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu7c_B_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu7c_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu17i(Test_aBFu7c_B_BFu17i, "aBFu7c_B_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu17ll()
{
  {
    init_simple_test("aBFu7c_B_BFu17ll");
    static aBFu7c_B_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu7c_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu7c_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu7c_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu17ll(Test_aBFu7c_B_BFu17ll, "aBFu7c_B_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu1c()
{
  {
    init_simple_test("aBFu7c_B_BFu1c");
    static aBFu7c_B_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7c_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu1c(Test_aBFu7c_B_BFu1c, "aBFu7c_B_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu1i()
{
  {
    init_simple_test("aBFu7c_B_BFu1i");
    static aBFu7c_B_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7c_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu1i(Test_aBFu7c_B_BFu1i, "aBFu7c_B_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu1ll()
{
  {
    init_simple_test("aBFu7c_B_BFu1ll");
    static aBFu7c_B_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7c_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu1ll(Test_aBFu7c_B_BFu1ll, "aBFu7c_B_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu1s()
{
  {
    init_simple_test("aBFu7c_B_BFu1s");
    static aBFu7c_B_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7c_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu1s(Test_aBFu7c_B_BFu1s, "aBFu7c_B_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu31i()
{
  {
    init_simple_test("aBFu7c_B_BFu31i");
    static aBFu7c_B_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu7c_B_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu7c_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu31i(Test_aBFu7c_B_BFu31i, "aBFu7c_B_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu31ll()
{
  {
    init_simple_test("aBFu7c_B_BFu31ll");
    static aBFu7c_B_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu7c_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu7c_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu31ll(Test_aBFu7c_B_BFu31ll, "aBFu7c_B_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu32i()
{
  {
    init_simple_test("aBFu7c_B_BFu32i");
    static aBFu7c_B_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu7c_B_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu7c_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu32i(Test_aBFu7c_B_BFu32i, "aBFu7c_B_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu32ll()
{
  {
    init_simple_test("aBFu7c_B_BFu32ll");
    static aBFu7c_B_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu7c_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu7c_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu32ll(Test_aBFu7c_B_BFu32ll, "aBFu7c_B_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu33()
{
  {
    init_simple_test("aBFu7c_B_BFu33");
    static aBFu7c_B_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu7c_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu33");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu7c_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu7c_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu33(Test_aBFu7c_B_BFu33, "aBFu7c_B_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu7c()
{
  {
    init_simple_test("aBFu7c_B_BFu7c");
    static aBFu7c_B_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7c_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu7c(Test_aBFu7c_B_BFu7c, "aBFu7c_B_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu7i()
{
  {
    init_simple_test("aBFu7c_B_BFu7i");
    static aBFu7c_B_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7c_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu7i(Test_aBFu7c_B_BFu7i, "aBFu7c_B_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu7ll()
{
  {
    init_simple_test("aBFu7c_B_BFu7ll");
    static aBFu7c_B_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7c_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu7ll(Test_aBFu7c_B_BFu7ll, "aBFu7c_B_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu7s()
{
  {
    init_simple_test("aBFu7c_B_BFu7s");
    static aBFu7c_B_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7c_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu7s(Test_aBFu7c_B_BFu7s, "aBFu7c_B_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu8c()
{
  {
    init_simple_test("aBFu7c_B_BFu8c");
    static aBFu7c_B_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7c_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7c_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu8c(Test_aBFu7c_B_BFu8c, "aBFu7c_B_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu8i()
{
  {
    init_simple_test("aBFu7c_B_BFu8i");
    static aBFu7c_B_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7c_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7c_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu8i(Test_aBFu7c_B_BFu8i, "aBFu7c_B_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu8ll()
{
  {
    init_simple_test("aBFu7c_B_BFu8ll");
    static aBFu7c_B_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7c_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7c_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu8ll(Test_aBFu7c_B_BFu8ll, "aBFu7c_B_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu8s()
{
  {
    init_simple_test("aBFu7c_B_BFu8s");
    static aBFu7c_B_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7c_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7c_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu8s(Test_aBFu7c_B_BFu8s, "aBFu7c_B_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu9i()
{
  {
    init_simple_test("aBFu7c_B_BFu9i");
    static aBFu7c_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu7c_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu7c_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu9i(Test_aBFu7c_B_BFu9i, "aBFu7c_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu9ll()
{
  {
    init_simple_test("aBFu7c_B_BFu9ll");
    static aBFu7c_B_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu7c_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu7c_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu9ll(Test_aBFu7c_B_BFu9ll, "aBFu7c_B_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_BFu9s()
{
  {
    init_simple_test("aBFu7c_B_BFu9s");
    static aBFu7c_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu7c_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu7c_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu7c_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_BFu9s(Test_aBFu7c_B_BFu9s, "aBFu7c_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_C()
{
  {
    init_simple_test("aBFu7c_B_C");
    static aBFu7c_B_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_C");
    check_field_offset(lv, v2, 1, "aBFu7c_B_C.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_B_C.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_C(Test_aBFu7c_B_C, "aBFu7c_B_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_D()
{
  {
    init_simple_test("aBFu7c_B_D");
    static aBFu7c_B_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7c_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_D");
    check_field_offset(lv, v2, 1, "aBFu7c_B_D.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_B_D.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_D(Test_aBFu7c_B_D, "aBFu7c_B_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_F()
{
  {
    init_simple_test("aBFu7c_B_F");
    static aBFu7c_B_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_F");
    check_field_offset(lv, v2, 1, "aBFu7c_B_F.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_B_F.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_F(Test_aBFu7c_B_F, "aBFu7c_B_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_I()
{
  {
    init_simple_test("aBFu7c_B_I");
    static aBFu7c_B_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_I");
    check_field_offset(lv, v2, 1, "aBFu7c_B_I.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_B_I.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_I(Test_aBFu7c_B_I, "aBFu7c_B_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_Ip()
{
  {
    init_simple_test("aBFu7c_B_Ip");
    static aBFu7c_B_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7c_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_Ip");
    check_field_offset(lv, v2, 1, "aBFu7c_B_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_Ip(Test_aBFu7c_B_Ip, "aBFu7c_B_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_L()
{
  {
    init_simple_test("aBFu7c_B_L");
    static aBFu7c_B_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7c_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_L");
    check_field_offset(lv, v2, 1, "aBFu7c_B_L.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_B_L.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_L(Test_aBFu7c_B_L, "aBFu7c_B_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_S()
{
  {
    init_simple_test("aBFu7c_B_S");
    static aBFu7c_B_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_S");
    check_field_offset(lv, v2, 1, "aBFu7c_B_S.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_B_S.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_S(Test_aBFu7c_B_S, "aBFu7c_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_Uc()
{
  {
    init_simple_test("aBFu7c_B_Uc");
    static aBFu7c_B_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_Uc");
    check_field_offset(lv, v2, 1, "aBFu7c_B_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_Uc(Test_aBFu7c_B_Uc, "aBFu7c_B_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_Ui()
{
  {
    init_simple_test("aBFu7c_B_Ui");
    static aBFu7c_B_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_Ui");
    check_field_offset(lv, v2, 1, "aBFu7c_B_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_Ui(Test_aBFu7c_B_Ui, "aBFu7c_B_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_Ul()
{
  {
    init_simple_test("aBFu7c_B_Ul");
    static aBFu7c_B_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7c_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_Ul");
    check_field_offset(lv, v2, 1, "aBFu7c_B_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_Ul(Test_aBFu7c_B_Ul, "aBFu7c_B_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_Us()
{
  {
    init_simple_test("aBFu7c_B_Us");
    static aBFu7c_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_Us");
    check_field_offset(lv, v2, 1, "aBFu7c_B_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_B_Us.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_Us(Test_aBFu7c_B_Us, "aBFu7c_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_B_Vp()
{
  {
    init_simple_test("aBFu7c_B_Vp");
    static aBFu7c_B_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7c_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_B_Vp");
    check_field_offset(lv, v2, 1, "aBFu7c_B_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_B_Vp(Test_aBFu7c_B_Vp, "aBFu7c_B_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu15i_B()
{
  {
    init_simple_test("aBFu7c_BFu15i_B");
    static aBFu7c_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "aBFu7c_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "aBFu7c_BFu15i_B");
    check_field_offset(lv, v3, 3, "aBFu7c_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu15i_B(Test_aBFu7c_BFu15i_B, "aBFu7c_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu15ll_B()
{
  {
    init_simple_test("aBFu7c_BFu15ll_B");
    static aBFu7c_BFu15ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "aBFu7c_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "aBFu7c_BFu15ll_B");
    check_field_offset(lv, v3, 3, "aBFu7c_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu15ll_B(Test_aBFu7c_BFu15ll_B, "aBFu7c_BFu15ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu15s_B()
{
  {
    init_simple_test("aBFu7c_BFu15s_B");
    static aBFu7c_BFu15s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu15s_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "aBFu7c_BFu15s_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "aBFu7c_BFu15s_B");
    check_field_offset(lv, v3, 3, "aBFu7c_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu15s_B(Test_aBFu7c_BFu15s_B, "aBFu7c_BFu15s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu16i_B()
{
  {
    init_simple_test("aBFu7c_BFu16i_B");
    static aBFu7c_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "aBFu7c_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "aBFu7c_BFu16i_B");
    check_field_offset(lv, v3, 3, "aBFu7c_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu16i_B(Test_aBFu7c_BFu16i_B, "aBFu7c_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu16ll_B()
{
  {
    init_simple_test("aBFu7c_BFu16ll_B");
    static aBFu7c_BFu16ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "aBFu7c_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "aBFu7c_BFu16ll_B");
    check_field_offset(lv, v3, 3, "aBFu7c_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu16ll_B(Test_aBFu7c_BFu16ll_B, "aBFu7c_BFu16ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu16s_B()
{
  {
    init_simple_test("aBFu7c_BFu16s_B");
    static aBFu7c_BFu16s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu16s_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "aBFu7c_BFu16s_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "aBFu7c_BFu16s_B");
    check_field_offset(lv, v3, 3, "aBFu7c_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu16s_B(Test_aBFu7c_BFu16s_B, "aBFu7c_BFu16s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu17i_B()
{
  {
    init_simple_test("aBFu7c_BFu17i_B");
    static aBFu7c_BFu17i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "aBFu7c_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "aBFu7c_BFu17i_B");
    check_field_offset(lv, v3, 3, "aBFu7c_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu17i_B(Test_aBFu7c_BFu17i_B, "aBFu7c_BFu17i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu17ll_B()
{
  {
    init_simple_test("aBFu7c_BFu17ll_B");
    static aBFu7c_BFu17ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "aBFu7c_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "aBFu7c_BFu17ll_B");
    check_field_offset(lv, v3, 3, "aBFu7c_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu17ll_B(Test_aBFu7c_BFu17ll_B, "aBFu7c_BFu17ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu1c_B()
{
  {
    init_simple_test("aBFu7c_BFu1c_B");
    static aBFu7c_BFu1c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7c_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu1c_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7c_BFu1c_B");
    check_field_offset(lv, v3, 1, "aBFu7c_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu1c_B(Test_aBFu7c_BFu1c_B, "aBFu7c_BFu1c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu1i_B()
{
  {
    init_simple_test("aBFu7c_BFu1i_B");
    static aBFu7c_BFu1i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7c_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu1i_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7c_BFu1i_B");
    check_field_offset(lv, v3, 1, "aBFu7c_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu1i_B(Test_aBFu7c_BFu1i_B, "aBFu7c_BFu1i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu1ll_B()
{
  {
    init_simple_test("aBFu7c_BFu1ll_B");
    static aBFu7c_BFu1ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7c_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu1ll_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7c_BFu1ll_B");
    check_field_offset(lv, v3, 1, "aBFu7c_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu1ll_B(Test_aBFu7c_BFu1ll_B, "aBFu7c_BFu1ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu1s_B()
{
  {
    init_simple_test("aBFu7c_BFu1s_B");
    static aBFu7c_BFu1s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7c_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu1s_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7c_BFu1s_B");
    check_field_offset(lv, v3, 1, "aBFu7c_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu1s_B(Test_aBFu7c_BFu1s_B, "aBFu7c_BFu1s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu31i_B()
{
  {
    init_simple_test("aBFu7c_BFu31i_B");
    static aBFu7c_BFu31i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu31i_B");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "aBFu7c_BFu31i_B");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "aBFu7c_BFu31i_B");
    check_field_offset(lv, v3, 5, "aBFu7c_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu31i_B(Test_aBFu7c_BFu31i_B, "aBFu7c_BFu31i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu31ll_B()
{
  {
    init_simple_test("aBFu7c_BFu31ll_B");
    static aBFu7c_BFu31ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "aBFu7c_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "aBFu7c_BFu31ll_B");
    check_field_offset(lv, v3, 5, "aBFu7c_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu31ll_B(Test_aBFu7c_BFu31ll_B, "aBFu7c_BFu31ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu32i_B()
{
  {
    init_simple_test("aBFu7c_BFu32i_B");
    static aBFu7c_BFu32i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu32i_B");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "aBFu7c_BFu32i_B");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "aBFu7c_BFu32i_B");
    check_field_offset(lv, v3, 5, "aBFu7c_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu32i_B(Test_aBFu7c_BFu32i_B, "aBFu7c_BFu32i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu32ll_B()
{
  {
    init_simple_test("aBFu7c_BFu32ll_B");
    static aBFu7c_BFu32ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "aBFu7c_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "aBFu7c_BFu32ll_B");
    check_field_offset(lv, v3, 5, "aBFu7c_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu32ll_B(Test_aBFu7c_BFu32ll_B, "aBFu7c_BFu32ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu33_B()
{
  {
    init_simple_test("aBFu7c_BFu33_B");
    static aBFu7c_BFu33_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "aBFu7c_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "aBFu7c_BFu33_B");
    check_field_offset(lv, v3, 5, "aBFu7c_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu33_B(Test_aBFu7c_BFu33_B, "aBFu7c_BFu33_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu7c_B()
{
  {
    init_simple_test("aBFu7c_BFu7c_B");
    static aBFu7c_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu7c_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7c_BFu7c_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7c_BFu7c_B");
    check_field_offset(lv, v3, 2, "aBFu7c_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu7c_B(Test_aBFu7c_BFu7c_B, "aBFu7c_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu7i_B()
{
  {
    init_simple_test("aBFu7c_BFu7i_B");
    static aBFu7c_BFu7i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7c_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7c_BFu7i_B");
    check_field_offset(lv, v3, 2, "aBFu7c_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu7i_B(Test_aBFu7c_BFu7i_B, "aBFu7c_BFu7i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu7ll_B()
{
  {
    init_simple_test("aBFu7c_BFu7ll_B");
    static aBFu7c_BFu7ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7c_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7c_BFu7ll_B");
    check_field_offset(lv, v3, 2, "aBFu7c_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu7ll_B(Test_aBFu7c_BFu7ll_B, "aBFu7c_BFu7ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu7s_B()
{
  {
    init_simple_test("aBFu7c_BFu7s_B");
    static aBFu7c_BFu7s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7c_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7c_BFu7s_B");
    check_field_offset(lv, v3, 2, "aBFu7c_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu7s_B(Test_aBFu7c_BFu7s_B, "aBFu7c_BFu7s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu8c_B()
{
  {
    init_simple_test("aBFu7c_BFu8c_B");
    static aBFu7c_BFu8c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu8c_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7c_BFu8c_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7c_BFu8c_B");
    check_field_offset(lv, v3, 2, "aBFu7c_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu8c_B(Test_aBFu7c_BFu8c_B, "aBFu7c_BFu8c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu8i_B()
{
  {
    init_simple_test("aBFu7c_BFu8i_B");
    static aBFu7c_BFu8i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7c_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7c_BFu8i_B");
    check_field_offset(lv, v3, 2, "aBFu7c_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu8i_B(Test_aBFu7c_BFu8i_B, "aBFu7c_BFu8i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu8ll_B()
{
  {
    init_simple_test("aBFu7c_BFu8ll_B");
    static aBFu7c_BFu8ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7c_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7c_BFu8ll_B");
    check_field_offset(lv, v3, 2, "aBFu7c_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu8ll_B(Test_aBFu7c_BFu8ll_B, "aBFu7c_BFu8ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu8s_B()
{
  {
    init_simple_test("aBFu7c_BFu8s_B");
    static aBFu7c_BFu8s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7c_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7c_BFu8s_B");
    check_field_offset(lv, v3, 2, "aBFu7c_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu8s_B(Test_aBFu7c_BFu8s_B, "aBFu7c_BFu8s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu9i_B()
{
  {
    init_simple_test("aBFu7c_BFu9i_B");
    static aBFu7c_BFu9i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "aBFu7c_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "aBFu7c_BFu9i_B");
    check_field_offset(lv, v3, 2, "aBFu7c_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu9i_B(Test_aBFu7c_BFu9i_B, "aBFu7c_BFu9i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu9ll_B()
{
  {
    init_simple_test("aBFu7c_BFu9ll_B");
    static aBFu7c_BFu9ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "aBFu7c_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "aBFu7c_BFu9ll_B");
    check_field_offset(lv, v3, 2, "aBFu7c_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu9ll_B(Test_aBFu7c_BFu9ll_B, "aBFu7c_BFu9ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_BFu9s_B()
{
  {
    init_simple_test("aBFu7c_BFu9s_B");
    static aBFu7c_BFu9s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "aBFu7c_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "aBFu7c_BFu9s_B");
    check_field_offset(lv, v3, 2, "aBFu7c_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_BFu9s_B(Test_aBFu7c_BFu9s_B, "aBFu7c_BFu9s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_C_B()
{
  {
    init_simple_test("aBFu7c_C_B");
    static aBFu7c_C_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_C_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_C_B");
    check_field_offset(lv, v2, 1, "aBFu7c_C_B.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_C_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_C_B(Test_aBFu7c_C_B, "aBFu7c_C_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_D_B()
{
  {
    init_simple_test("aBFu7c_D_B");
    static aBFu7c_D_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7c_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_D_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_D_B");
    check_field_offset(lv, v2, 1, "aBFu7c_D_B.v2");
    check_field_offset(lv, v3, 9, "aBFu7c_D_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_D_B(Test_aBFu7c_D_B, "aBFu7c_D_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_F_B()
{
  {
    init_simple_test("aBFu7c_F_B");
    static aBFu7c_F_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_F_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_F_B");
    check_field_offset(lv, v2, 1, "aBFu7c_F_B.v2");
    check_field_offset(lv, v3, 5, "aBFu7c_F_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_F_B(Test_aBFu7c_F_B, "aBFu7c_F_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_I_B()
{
  {
    init_simple_test("aBFu7c_I_B");
    static aBFu7c_I_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_I_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_I_B");
    check_field_offset(lv, v2, 1, "aBFu7c_I_B.v2");
    check_field_offset(lv, v3, 5, "aBFu7c_I_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_I_B(Test_aBFu7c_I_B, "aBFu7c_I_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_Ip_B()
{
  {
    init_simple_test("aBFu7c_Ip_B");
    static aBFu7c_Ip_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7c_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_Ip_B");
    check_field_offset(lv, v2, 1, "aBFu7c_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu7c_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_Ip_B(Test_aBFu7c_Ip_B, "aBFu7c_Ip_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_L_B()
{
  {
    init_simple_test("aBFu7c_L_B");
    static aBFu7c_L_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7c_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_L_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_L_B");
    check_field_offset(lv, v2, 1, "aBFu7c_L_B.v2");
    check_field_offset(lv, v3, 9, "aBFu7c_L_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_L_B(Test_aBFu7c_L_B, "aBFu7c_L_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_S_B()
{
  {
    init_simple_test("aBFu7c_S_B");
    static aBFu7c_S_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_S_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_S_B");
    check_field_offset(lv, v2, 1, "aBFu7c_S_B.v2");
    check_field_offset(lv, v3, 3, "aBFu7c_S_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_S_B(Test_aBFu7c_S_B, "aBFu7c_S_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_Uc_B()
{
  {
    init_simple_test("aBFu7c_Uc_B");
    static aBFu7c_Uc_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7c_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_Uc_B");
    check_field_offset(lv, v2, 1, "aBFu7c_Uc_B.v2");
    check_field_offset(lv, v3, 2, "aBFu7c_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_Uc_B(Test_aBFu7c_Uc_B, "aBFu7c_Uc_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_Ui_B()
{
  {
    init_simple_test("aBFu7c_Ui_B");
    static aBFu7c_Ui_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7c_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_Ui_B");
    check_field_offset(lv, v2, 1, "aBFu7c_Ui_B.v2");
    check_field_offset(lv, v3, 5, "aBFu7c_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_Ui_B(Test_aBFu7c_Ui_B, "aBFu7c_Ui_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_Ul_B()
{
  {
    init_simple_test("aBFu7c_Ul_B");
    static aBFu7c_Ul_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7c_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_Ul_B");
    check_field_offset(lv, v2, 1, "aBFu7c_Ul_B.v2");
    check_field_offset(lv, v3, 9, "aBFu7c_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_Ul_B(Test_aBFu7c_Ul_B, "aBFu7c_Ul_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_Us_B()
{
  {
    init_simple_test("aBFu7c_Us_B");
    static aBFu7c_Us_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7c_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_Us_B");
    check_field_offset(lv, v2, 1, "aBFu7c_Us_B.v2");
    check_field_offset(lv, v3, 3, "aBFu7c_Us_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_Us_B(Test_aBFu7c_Us_B, "aBFu7c_Us_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7c_Vp_B()
{
  {
    init_simple_test("aBFu7c_Vp_B");
    static aBFu7c_Vp_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7c_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_Vp_B");
    check_field_offset(lv, v2, 1, "aBFu7c_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu7c_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7c_Vp_B(Test_aBFu7c_Vp_B, "aBFu7c_Vp_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B()
{
  {
    init_simple_test("aBFu7i_B");
    static aBFu7i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B");
    check_field_offset(lv, v2, 1, "aBFu7i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7i_B(Test_aBFu7i_B, "aBFu7i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_B()
{
  {
    init_simple_test("aBFu7i_B_B");
    static aBFu7i_B_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_B");
    check_field_offset(lv, v2, 1, "aBFu7i_B_B.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_B_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_B(Test_aBFu7i_B_B, "aBFu7i_B_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu15i()
{
  {
    init_simple_test("aBFu7i_B_BFu15i");
    static aBFu7i_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu7i_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu7i_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu15i(Test_aBFu7i_B_BFu15i, "aBFu7i_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu15ll()
{
  {
    init_simple_test("aBFu7i_B_BFu15ll");
    static aBFu7i_B_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu7i_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu7i_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu15ll(Test_aBFu7i_B_BFu15ll, "aBFu7i_B_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu15s()
{
  {
    init_simple_test("aBFu7i_B_BFu15s");
    static aBFu7i_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu7i_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu7i_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu15s(Test_aBFu7i_B_BFu15s, "aBFu7i_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu16i()
{
  {
    init_simple_test("aBFu7i_B_BFu16i");
    static aBFu7i_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu7i_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu7i_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu16i(Test_aBFu7i_B_BFu16i, "aBFu7i_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu16ll()
{
  {
    init_simple_test("aBFu7i_B_BFu16ll");
    static aBFu7i_B_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu7i_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu7i_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu16ll(Test_aBFu7i_B_BFu16ll, "aBFu7i_B_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu16s()
{
  {
    init_simple_test("aBFu7i_B_BFu16s");
    static aBFu7i_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu7i_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu7i_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu16s(Test_aBFu7i_B_BFu16s, "aBFu7i_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu17i()
{
  {
    init_simple_test("aBFu7i_B_BFu17i");
    static aBFu7i_B_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu7i_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu7i_B_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu7i_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu17i(Test_aBFu7i_B_BFu17i, "aBFu7i_B_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu17ll()
{
  {
    init_simple_test("aBFu7i_B_BFu17ll");
    static aBFu7i_B_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu7i_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu7i_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu7i_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu17ll(Test_aBFu7i_B_BFu17ll, "aBFu7i_B_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu1c()
{
  {
    init_simple_test("aBFu7i_B_BFu1c");
    static aBFu7i_B_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7i_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu1c(Test_aBFu7i_B_BFu1c, "aBFu7i_B_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu1i()
{
  {
    init_simple_test("aBFu7i_B_BFu1i");
    static aBFu7i_B_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7i_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu1i(Test_aBFu7i_B_BFu1i, "aBFu7i_B_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu1ll()
{
  {
    init_simple_test("aBFu7i_B_BFu1ll");
    static aBFu7i_B_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7i_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu1ll(Test_aBFu7i_B_BFu1ll, "aBFu7i_B_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu1s()
{
  {
    init_simple_test("aBFu7i_B_BFu1s");
    static aBFu7i_B_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7i_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu1s(Test_aBFu7i_B_BFu1s, "aBFu7i_B_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu31i()
{
  {
    init_simple_test("aBFu7i_B_BFu31i");
    static aBFu7i_B_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu7i_B_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu7i_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu31i(Test_aBFu7i_B_BFu31i, "aBFu7i_B_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu31ll()
{
  {
    init_simple_test("aBFu7i_B_BFu31ll");
    static aBFu7i_B_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu7i_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu7i_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu31ll(Test_aBFu7i_B_BFu31ll, "aBFu7i_B_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu32i()
{
  {
    init_simple_test("aBFu7i_B_BFu32i");
    static aBFu7i_B_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu7i_B_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu7i_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu32i(Test_aBFu7i_B_BFu32i, "aBFu7i_B_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu32ll()
{
  {
    init_simple_test("aBFu7i_B_BFu32ll");
    static aBFu7i_B_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu7i_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu7i_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu32ll(Test_aBFu7i_B_BFu32ll, "aBFu7i_B_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu33()
{
  {
    init_simple_test("aBFu7i_B_BFu33");
    static aBFu7i_B_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu7i_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu33");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu7i_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu7i_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu33(Test_aBFu7i_B_BFu33, "aBFu7i_B_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu7c()
{
  {
    init_simple_test("aBFu7i_B_BFu7c");
    static aBFu7i_B_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7i_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu7c(Test_aBFu7i_B_BFu7c, "aBFu7i_B_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu7i()
{
  {
    init_simple_test("aBFu7i_B_BFu7i");
    static aBFu7i_B_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7i_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu7i(Test_aBFu7i_B_BFu7i, "aBFu7i_B_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu7ll()
{
  {
    init_simple_test("aBFu7i_B_BFu7ll");
    static aBFu7i_B_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7i_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu7ll(Test_aBFu7i_B_BFu7ll, "aBFu7i_B_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu7s()
{
  {
    init_simple_test("aBFu7i_B_BFu7s");
    static aBFu7i_B_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7i_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu7s(Test_aBFu7i_B_BFu7s, "aBFu7i_B_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu8c()
{
  {
    init_simple_test("aBFu7i_B_BFu8c");
    static aBFu7i_B_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7i_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7i_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu8c(Test_aBFu7i_B_BFu8c, "aBFu7i_B_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu8i()
{
  {
    init_simple_test("aBFu7i_B_BFu8i");
    static aBFu7i_B_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7i_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7i_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu8i(Test_aBFu7i_B_BFu8i, "aBFu7i_B_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu8ll()
{
  {
    init_simple_test("aBFu7i_B_BFu8ll");
    static aBFu7i_B_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7i_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7i_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu8ll(Test_aBFu7i_B_BFu8ll, "aBFu7i_B_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu8s()
{
  {
    init_simple_test("aBFu7i_B_BFu8s");
    static aBFu7i_B_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7i_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7i_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu8s(Test_aBFu7i_B_BFu8s, "aBFu7i_B_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu9i()
{
  {
    init_simple_test("aBFu7i_B_BFu9i");
    static aBFu7i_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu7i_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu7i_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu9i(Test_aBFu7i_B_BFu9i, "aBFu7i_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu9ll()
{
  {
    init_simple_test("aBFu7i_B_BFu9ll");
    static aBFu7i_B_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu7i_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu7i_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu9ll(Test_aBFu7i_B_BFu9ll, "aBFu7i_B_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_BFu9s()
{
  {
    init_simple_test("aBFu7i_B_BFu9s");
    static aBFu7i_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu7i_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu7i_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu7i_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_BFu9s(Test_aBFu7i_B_BFu9s, "aBFu7i_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_C()
{
  {
    init_simple_test("aBFu7i_B_C");
    static aBFu7i_B_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_C");
    check_field_offset(lv, v2, 1, "aBFu7i_B_C.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_B_C.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_C(Test_aBFu7i_B_C, "aBFu7i_B_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_D()
{
  {
    init_simple_test("aBFu7i_B_D");
    static aBFu7i_B_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7i_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_D");
    check_field_offset(lv, v2, 1, "aBFu7i_B_D.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_B_D.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_D(Test_aBFu7i_B_D, "aBFu7i_B_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_F()
{
  {
    init_simple_test("aBFu7i_B_F");
    static aBFu7i_B_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_F");
    check_field_offset(lv, v2, 1, "aBFu7i_B_F.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_B_F.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_F(Test_aBFu7i_B_F, "aBFu7i_B_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_I()
{
  {
    init_simple_test("aBFu7i_B_I");
    static aBFu7i_B_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_I");
    check_field_offset(lv, v2, 1, "aBFu7i_B_I.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_B_I.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_I(Test_aBFu7i_B_I, "aBFu7i_B_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_Ip()
{
  {
    init_simple_test("aBFu7i_B_Ip");
    static aBFu7i_B_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7i_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_Ip");
    check_field_offset(lv, v2, 1, "aBFu7i_B_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_Ip(Test_aBFu7i_B_Ip, "aBFu7i_B_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_L()
{
  {
    init_simple_test("aBFu7i_B_L");
    static aBFu7i_B_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7i_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_L");
    check_field_offset(lv, v2, 1, "aBFu7i_B_L.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_B_L.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_L(Test_aBFu7i_B_L, "aBFu7i_B_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_S()
{
  {
    init_simple_test("aBFu7i_B_S");
    static aBFu7i_B_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_S");
    check_field_offset(lv, v2, 1, "aBFu7i_B_S.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_B_S.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_S(Test_aBFu7i_B_S, "aBFu7i_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_Uc()
{
  {
    init_simple_test("aBFu7i_B_Uc");
    static aBFu7i_B_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_Uc");
    check_field_offset(lv, v2, 1, "aBFu7i_B_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_Uc(Test_aBFu7i_B_Uc, "aBFu7i_B_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_Ui()
{
  {
    init_simple_test("aBFu7i_B_Ui");
    static aBFu7i_B_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_Ui");
    check_field_offset(lv, v2, 1, "aBFu7i_B_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_Ui(Test_aBFu7i_B_Ui, "aBFu7i_B_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_Ul()
{
  {
    init_simple_test("aBFu7i_B_Ul");
    static aBFu7i_B_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7i_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_Ul");
    check_field_offset(lv, v2, 1, "aBFu7i_B_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_Ul(Test_aBFu7i_B_Ul, "aBFu7i_B_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_Us()
{
  {
    init_simple_test("aBFu7i_B_Us");
    static aBFu7i_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_Us");
    check_field_offset(lv, v2, 1, "aBFu7i_B_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_B_Us.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_Us(Test_aBFu7i_B_Us, "aBFu7i_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_B_Vp()
{
  {
    init_simple_test("aBFu7i_B_Vp");
    static aBFu7i_B_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7i_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_B_Vp");
    check_field_offset(lv, v2, 1, "aBFu7i_B_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_B_Vp(Test_aBFu7i_B_Vp, "aBFu7i_B_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu15i_B()
{
  {
    init_simple_test("aBFu7i_BFu15i_B");
    static aBFu7i_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "aBFu7i_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "aBFu7i_BFu15i_B");
    check_field_offset(lv, v3, 3, "aBFu7i_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu15i_B(Test_aBFu7i_BFu15i_B, "aBFu7i_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu15ll_B()
{
  {
    init_simple_test("aBFu7i_BFu15ll_B");
    static aBFu7i_BFu15ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "aBFu7i_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "aBFu7i_BFu15ll_B");
    check_field_offset(lv, v3, 3, "aBFu7i_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu15ll_B(Test_aBFu7i_BFu15ll_B, "aBFu7i_BFu15ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu15s_B()
{
  {
    init_simple_test("aBFu7i_BFu15s_B");
    static aBFu7i_BFu15s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu15s_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "aBFu7i_BFu15s_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "aBFu7i_BFu15s_B");
    check_field_offset(lv, v3, 3, "aBFu7i_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu15s_B(Test_aBFu7i_BFu15s_B, "aBFu7i_BFu15s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu16i_B()
{
  {
    init_simple_test("aBFu7i_BFu16i_B");
    static aBFu7i_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "aBFu7i_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "aBFu7i_BFu16i_B");
    check_field_offset(lv, v3, 3, "aBFu7i_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu16i_B(Test_aBFu7i_BFu16i_B, "aBFu7i_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu16ll_B()
{
  {
    init_simple_test("aBFu7i_BFu16ll_B");
    static aBFu7i_BFu16ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "aBFu7i_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "aBFu7i_BFu16ll_B");
    check_field_offset(lv, v3, 3, "aBFu7i_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu16ll_B(Test_aBFu7i_BFu16ll_B, "aBFu7i_BFu16ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu16s_B()
{
  {
    init_simple_test("aBFu7i_BFu16s_B");
    static aBFu7i_BFu16s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu16s_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "aBFu7i_BFu16s_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "aBFu7i_BFu16s_B");
    check_field_offset(lv, v3, 3, "aBFu7i_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu16s_B(Test_aBFu7i_BFu16s_B, "aBFu7i_BFu16s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu17i_B()
{
  {
    init_simple_test("aBFu7i_BFu17i_B");
    static aBFu7i_BFu17i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "aBFu7i_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "aBFu7i_BFu17i_B");
    check_field_offset(lv, v3, 3, "aBFu7i_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu17i_B(Test_aBFu7i_BFu17i_B, "aBFu7i_BFu17i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu17ll_B()
{
  {
    init_simple_test("aBFu7i_BFu17ll_B");
    static aBFu7i_BFu17ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "aBFu7i_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "aBFu7i_BFu17ll_B");
    check_field_offset(lv, v3, 3, "aBFu7i_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu17ll_B(Test_aBFu7i_BFu17ll_B, "aBFu7i_BFu17ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu1c_B()
{
  {
    init_simple_test("aBFu7i_BFu1c_B");
    static aBFu7i_BFu1c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7i_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu1c_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7i_BFu1c_B");
    check_field_offset(lv, v3, 1, "aBFu7i_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu1c_B(Test_aBFu7i_BFu1c_B, "aBFu7i_BFu1c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu1i_B()
{
  {
    init_simple_test("aBFu7i_BFu1i_B");
    static aBFu7i_BFu1i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7i_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu1i_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7i_BFu1i_B");
    check_field_offset(lv, v3, 1, "aBFu7i_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu1i_B(Test_aBFu7i_BFu1i_B, "aBFu7i_BFu1i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu1ll_B()
{
  {
    init_simple_test("aBFu7i_BFu1ll_B");
    static aBFu7i_BFu1ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7i_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu1ll_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7i_BFu1ll_B");
    check_field_offset(lv, v3, 1, "aBFu7i_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu1ll_B(Test_aBFu7i_BFu1ll_B, "aBFu7i_BFu1ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu1s_B()
{
  {
    init_simple_test("aBFu7i_BFu1s_B");
    static aBFu7i_BFu1s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7i_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu1s_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7i_BFu1s_B");
    check_field_offset(lv, v3, 1, "aBFu7i_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu1s_B(Test_aBFu7i_BFu1s_B, "aBFu7i_BFu1s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu31i_B()
{
  {
    init_simple_test("aBFu7i_BFu31i_B");
    static aBFu7i_BFu31i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu31i_B");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "aBFu7i_BFu31i_B");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "aBFu7i_BFu31i_B");
    check_field_offset(lv, v3, 5, "aBFu7i_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu31i_B(Test_aBFu7i_BFu31i_B, "aBFu7i_BFu31i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu31ll_B()
{
  {
    init_simple_test("aBFu7i_BFu31ll_B");
    static aBFu7i_BFu31ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "aBFu7i_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "aBFu7i_BFu31ll_B");
    check_field_offset(lv, v3, 5, "aBFu7i_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu31ll_B(Test_aBFu7i_BFu31ll_B, "aBFu7i_BFu31ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu32i_B()
{
  {
    init_simple_test("aBFu7i_BFu32i_B");
    static aBFu7i_BFu32i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu32i_B");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "aBFu7i_BFu32i_B");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "aBFu7i_BFu32i_B");
    check_field_offset(lv, v3, 5, "aBFu7i_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu32i_B(Test_aBFu7i_BFu32i_B, "aBFu7i_BFu32i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu32ll_B()
{
  {
    init_simple_test("aBFu7i_BFu32ll_B");
    static aBFu7i_BFu32ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "aBFu7i_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "aBFu7i_BFu32ll_B");
    check_field_offset(lv, v3, 5, "aBFu7i_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu32ll_B(Test_aBFu7i_BFu32ll_B, "aBFu7i_BFu32ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu33_B()
{
  {
    init_simple_test("aBFu7i_BFu33_B");
    static aBFu7i_BFu33_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "aBFu7i_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "aBFu7i_BFu33_B");
    check_field_offset(lv, v3, 5, "aBFu7i_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu33_B(Test_aBFu7i_BFu33_B, "aBFu7i_BFu33_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu7c_B()
{
  {
    init_simple_test("aBFu7i_BFu7c_B");
    static aBFu7i_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu7c_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7i_BFu7c_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7i_BFu7c_B");
    check_field_offset(lv, v3, 2, "aBFu7i_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu7c_B(Test_aBFu7i_BFu7c_B, "aBFu7i_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu7i_B()
{
  {
    init_simple_test("aBFu7i_BFu7i_B");
    static aBFu7i_BFu7i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7i_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7i_BFu7i_B");
    check_field_offset(lv, v3, 2, "aBFu7i_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu7i_B(Test_aBFu7i_BFu7i_B, "aBFu7i_BFu7i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu7ll_B()
{
  {
    init_simple_test("aBFu7i_BFu7ll_B");
    static aBFu7i_BFu7ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7i_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7i_BFu7ll_B");
    check_field_offset(lv, v3, 2, "aBFu7i_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu7ll_B(Test_aBFu7i_BFu7ll_B, "aBFu7i_BFu7ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu7s_B()
{
  {
    init_simple_test("aBFu7i_BFu7s_B");
    static aBFu7i_BFu7s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7i_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7i_BFu7s_B");
    check_field_offset(lv, v3, 2, "aBFu7i_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu7s_B(Test_aBFu7i_BFu7s_B, "aBFu7i_BFu7s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu8c_B()
{
  {
    init_simple_test("aBFu7i_BFu8c_B");
    static aBFu7i_BFu8c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu8c_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7i_BFu8c_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7i_BFu8c_B");
    check_field_offset(lv, v3, 2, "aBFu7i_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu8c_B(Test_aBFu7i_BFu8c_B, "aBFu7i_BFu8c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu8i_B()
{
  {
    init_simple_test("aBFu7i_BFu8i_B");
    static aBFu7i_BFu8i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7i_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7i_BFu8i_B");
    check_field_offset(lv, v3, 2, "aBFu7i_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu8i_B(Test_aBFu7i_BFu8i_B, "aBFu7i_BFu8i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu8ll_B()
{
  {
    init_simple_test("aBFu7i_BFu8ll_B");
    static aBFu7i_BFu8ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7i_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7i_BFu8ll_B");
    check_field_offset(lv, v3, 2, "aBFu7i_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu8ll_B(Test_aBFu7i_BFu8ll_B, "aBFu7i_BFu8ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu8s_B()
{
  {
    init_simple_test("aBFu7i_BFu8s_B");
    static aBFu7i_BFu8s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7i_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7i_BFu8s_B");
    check_field_offset(lv, v3, 2, "aBFu7i_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu8s_B(Test_aBFu7i_BFu8s_B, "aBFu7i_BFu8s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu9i_B()
{
  {
    init_simple_test("aBFu7i_BFu9i_B");
    static aBFu7i_BFu9i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "aBFu7i_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "aBFu7i_BFu9i_B");
    check_field_offset(lv, v3, 2, "aBFu7i_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu9i_B(Test_aBFu7i_BFu9i_B, "aBFu7i_BFu9i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu9ll_B()
{
  {
    init_simple_test("aBFu7i_BFu9ll_B");
    static aBFu7i_BFu9ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "aBFu7i_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "aBFu7i_BFu9ll_B");
    check_field_offset(lv, v3, 2, "aBFu7i_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu9ll_B(Test_aBFu7i_BFu9ll_B, "aBFu7i_BFu9ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_BFu9s_B()
{
  {
    init_simple_test("aBFu7i_BFu9s_B");
    static aBFu7i_BFu9s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "aBFu7i_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "aBFu7i_BFu9s_B");
    check_field_offset(lv, v3, 2, "aBFu7i_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_BFu9s_B(Test_aBFu7i_BFu9s_B, "aBFu7i_BFu9s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_C_B()
{
  {
    init_simple_test("aBFu7i_C_B");
    static aBFu7i_C_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_C_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_C_B");
    check_field_offset(lv, v2, 1, "aBFu7i_C_B.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_C_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_C_B(Test_aBFu7i_C_B, "aBFu7i_C_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_D_B()
{
  {
    init_simple_test("aBFu7i_D_B");
    static aBFu7i_D_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7i_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_D_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_D_B");
    check_field_offset(lv, v2, 1, "aBFu7i_D_B.v2");
    check_field_offset(lv, v3, 9, "aBFu7i_D_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_D_B(Test_aBFu7i_D_B, "aBFu7i_D_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_F_B()
{
  {
    init_simple_test("aBFu7i_F_B");
    static aBFu7i_F_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_F_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_F_B");
    check_field_offset(lv, v2, 1, "aBFu7i_F_B.v2");
    check_field_offset(lv, v3, 5, "aBFu7i_F_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_F_B(Test_aBFu7i_F_B, "aBFu7i_F_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_I_B()
{
  {
    init_simple_test("aBFu7i_I_B");
    static aBFu7i_I_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_I_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_I_B");
    check_field_offset(lv, v2, 1, "aBFu7i_I_B.v2");
    check_field_offset(lv, v3, 5, "aBFu7i_I_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_I_B(Test_aBFu7i_I_B, "aBFu7i_I_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_Ip_B()
{
  {
    init_simple_test("aBFu7i_Ip_B");
    static aBFu7i_Ip_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7i_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_Ip_B");
    check_field_offset(lv, v2, 1, "aBFu7i_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu7i_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_Ip_B(Test_aBFu7i_Ip_B, "aBFu7i_Ip_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_L_B()
{
  {
    init_simple_test("aBFu7i_L_B");
    static aBFu7i_L_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7i_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_L_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_L_B");
    check_field_offset(lv, v2, 1, "aBFu7i_L_B.v2");
    check_field_offset(lv, v3, 9, "aBFu7i_L_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_L_B(Test_aBFu7i_L_B, "aBFu7i_L_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_S_B()
{
  {
    init_simple_test("aBFu7i_S_B");
    static aBFu7i_S_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_S_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_S_B");
    check_field_offset(lv, v2, 1, "aBFu7i_S_B.v2");
    check_field_offset(lv, v3, 3, "aBFu7i_S_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_S_B(Test_aBFu7i_S_B, "aBFu7i_S_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_Uc_B()
{
  {
    init_simple_test("aBFu7i_Uc_B");
    static aBFu7i_Uc_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7i_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_Uc_B");
    check_field_offset(lv, v2, 1, "aBFu7i_Uc_B.v2");
    check_field_offset(lv, v3, 2, "aBFu7i_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_Uc_B(Test_aBFu7i_Uc_B, "aBFu7i_Uc_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_Ui_B()
{
  {
    init_simple_test("aBFu7i_Ui_B");
    static aBFu7i_Ui_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7i_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_Ui_B");
    check_field_offset(lv, v2, 1, "aBFu7i_Ui_B.v2");
    check_field_offset(lv, v3, 5, "aBFu7i_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_Ui_B(Test_aBFu7i_Ui_B, "aBFu7i_Ui_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_Ul_B()
{
  {
    init_simple_test("aBFu7i_Ul_B");
    static aBFu7i_Ul_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7i_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_Ul_B");
    check_field_offset(lv, v2, 1, "aBFu7i_Ul_B.v2");
    check_field_offset(lv, v3, 9, "aBFu7i_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_Ul_B(Test_aBFu7i_Ul_B, "aBFu7i_Ul_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_Us_B()
{
  {
    init_simple_test("aBFu7i_Us_B");
    static aBFu7i_Us_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7i_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_Us_B");
    check_field_offset(lv, v2, 1, "aBFu7i_Us_B.v2");
    check_field_offset(lv, v3, 3, "aBFu7i_Us_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_Us_B(Test_aBFu7i_Us_B, "aBFu7i_Us_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7i_Vp_B()
{
  {
    init_simple_test("aBFu7i_Vp_B");
    static aBFu7i_Vp_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7i_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_Vp_B");
    check_field_offset(lv, v2, 1, "aBFu7i_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu7i_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7i_Vp_B(Test_aBFu7i_Vp_B, "aBFu7i_Vp_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B()
{
  {
    init_simple_test("aBFu7ll_B");
    static aBFu7ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B(Test_aBFu7ll_B, "aBFu7ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_B()
{
  {
    init_simple_test("aBFu7ll_B_B");
    static aBFu7ll_B_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_B.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_B_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_B(Test_aBFu7ll_B_B, "aBFu7ll_B_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu15i()
{
  {
    init_simple_test("aBFu7ll_B_BFu15i");
    static aBFu7ll_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu7ll_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu7ll_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu15i(Test_aBFu7ll_B_BFu15i, "aBFu7ll_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu15ll()
{
  {
    init_simple_test("aBFu7ll_B_BFu15ll");
    static aBFu7ll_B_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu7ll_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu7ll_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu15ll(Test_aBFu7ll_B_BFu15ll, "aBFu7ll_B_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu15s()
{
  {
    init_simple_test("aBFu7ll_B_BFu15s");
    static aBFu7ll_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu7ll_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu7ll_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu15s(Test_aBFu7ll_B_BFu15s, "aBFu7ll_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu16i()
{
  {
    init_simple_test("aBFu7ll_B_BFu16i");
    static aBFu7ll_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu7ll_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu7ll_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu16i(Test_aBFu7ll_B_BFu16i, "aBFu7ll_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu16ll()
{
  {
    init_simple_test("aBFu7ll_B_BFu16ll");
    static aBFu7ll_B_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu7ll_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu7ll_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu16ll(Test_aBFu7ll_B_BFu16ll, "aBFu7ll_B_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu16s()
{
  {
    init_simple_test("aBFu7ll_B_BFu16s");
    static aBFu7ll_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu7ll_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu7ll_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu16s(Test_aBFu7ll_B_BFu16s, "aBFu7ll_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu17i()
{
  {
    init_simple_test("aBFu7ll_B_BFu17i");
    static aBFu7ll_B_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu7ll_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu7ll_B_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu7ll_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu17i(Test_aBFu7ll_B_BFu17i, "aBFu7ll_B_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu17ll()
{
  {
    init_simple_test("aBFu7ll_B_BFu17ll");
    static aBFu7ll_B_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu7ll_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu7ll_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu7ll_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu17ll(Test_aBFu7ll_B_BFu17ll, "aBFu7ll_B_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu1c()
{
  {
    init_simple_test("aBFu7ll_B_BFu1c");
    static aBFu7ll_B_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7ll_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu1c(Test_aBFu7ll_B_BFu1c, "aBFu7ll_B_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu1i()
{
  {
    init_simple_test("aBFu7ll_B_BFu1i");
    static aBFu7ll_B_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7ll_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu1i(Test_aBFu7ll_B_BFu1i, "aBFu7ll_B_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu1ll()
{
  {
    init_simple_test("aBFu7ll_B_BFu1ll");
    static aBFu7ll_B_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7ll_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu1ll(Test_aBFu7ll_B_BFu1ll, "aBFu7ll_B_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu1s()
{
  {
    init_simple_test("aBFu7ll_B_BFu1s");
    static aBFu7ll_B_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7ll_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu1s(Test_aBFu7ll_B_BFu1s, "aBFu7ll_B_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu31i()
{
  {
    init_simple_test("aBFu7ll_B_BFu31i");
    static aBFu7ll_B_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu7ll_B_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu7ll_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu31i(Test_aBFu7ll_B_BFu31i, "aBFu7ll_B_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu31ll()
{
  {
    init_simple_test("aBFu7ll_B_BFu31ll");
    static aBFu7ll_B_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu7ll_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu7ll_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu31ll(Test_aBFu7ll_B_BFu31ll, "aBFu7ll_B_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu32i()
{
  {
    init_simple_test("aBFu7ll_B_BFu32i");
    static aBFu7ll_B_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu7ll_B_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu7ll_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu32i(Test_aBFu7ll_B_BFu32i, "aBFu7ll_B_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu32ll()
{
  {
    init_simple_test("aBFu7ll_B_BFu32ll");
    static aBFu7ll_B_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu7ll_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu7ll_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu32ll(Test_aBFu7ll_B_BFu32ll, "aBFu7ll_B_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu33()
{
  {
    init_simple_test("aBFu7ll_B_BFu33");
    static aBFu7ll_B_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu7ll_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu33");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu7ll_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu7ll_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu33(Test_aBFu7ll_B_BFu33, "aBFu7ll_B_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu7c()
{
  {
    init_simple_test("aBFu7ll_B_BFu7c");
    static aBFu7ll_B_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7ll_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu7c(Test_aBFu7ll_B_BFu7c, "aBFu7ll_B_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu7i()
{
  {
    init_simple_test("aBFu7ll_B_BFu7i");
    static aBFu7ll_B_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7ll_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu7i(Test_aBFu7ll_B_BFu7i, "aBFu7ll_B_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu7ll()
{
  {
    init_simple_test("aBFu7ll_B_BFu7ll");
    static aBFu7ll_B_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7ll_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu7ll(Test_aBFu7ll_B_BFu7ll, "aBFu7ll_B_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu7s()
{
  {
    init_simple_test("aBFu7ll_B_BFu7s");
    static aBFu7ll_B_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7ll_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu7s(Test_aBFu7ll_B_BFu7s, "aBFu7ll_B_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu8c()
{
  {
    init_simple_test("aBFu7ll_B_BFu8c");
    static aBFu7ll_B_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7ll_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7ll_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu8c(Test_aBFu7ll_B_BFu8c, "aBFu7ll_B_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu8i()
{
  {
    init_simple_test("aBFu7ll_B_BFu8i");
    static aBFu7ll_B_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7ll_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7ll_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu8i(Test_aBFu7ll_B_BFu8i, "aBFu7ll_B_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu8ll()
{
  {
    init_simple_test("aBFu7ll_B_BFu8ll");
    static aBFu7ll_B_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7ll_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7ll_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu8ll(Test_aBFu7ll_B_BFu8ll, "aBFu7ll_B_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu8s()
{
  {
    init_simple_test("aBFu7ll_B_BFu8s");
    static aBFu7ll_B_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7ll_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7ll_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu8s(Test_aBFu7ll_B_BFu8s, "aBFu7ll_B_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu9i()
{
  {
    init_simple_test("aBFu7ll_B_BFu9i");
    static aBFu7ll_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu7ll_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu7ll_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu9i(Test_aBFu7ll_B_BFu9i, "aBFu7ll_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu9ll()
{
  {
    init_simple_test("aBFu7ll_B_BFu9ll");
    static aBFu7ll_B_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu7ll_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu7ll_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu9ll(Test_aBFu7ll_B_BFu9ll, "aBFu7ll_B_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_BFu9s()
{
  {
    init_simple_test("aBFu7ll_B_BFu9s");
    static aBFu7ll_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu7ll_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu7ll_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_BFu9s(Test_aBFu7ll_B_BFu9s, "aBFu7ll_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_C()
{
  {
    init_simple_test("aBFu7ll_B_C");
    static aBFu7ll_B_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_C");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_C.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_B_C.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_C(Test_aBFu7ll_B_C, "aBFu7ll_B_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_D()
{
  {
    init_simple_test("aBFu7ll_B_D");
    static aBFu7ll_B_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7ll_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_D");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_D.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_B_D.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_D(Test_aBFu7ll_B_D, "aBFu7ll_B_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_F()
{
  {
    init_simple_test("aBFu7ll_B_F");
    static aBFu7ll_B_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_F");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_F.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_B_F.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_F(Test_aBFu7ll_B_F, "aBFu7ll_B_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_I()
{
  {
    init_simple_test("aBFu7ll_B_I");
    static aBFu7ll_B_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_I");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_I.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_B_I.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_I(Test_aBFu7ll_B_I, "aBFu7ll_B_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_Ip()
{
  {
    init_simple_test("aBFu7ll_B_Ip");
    static aBFu7ll_B_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7ll_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_Ip");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_Ip(Test_aBFu7ll_B_Ip, "aBFu7ll_B_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_L()
{
  {
    init_simple_test("aBFu7ll_B_L");
    static aBFu7ll_B_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7ll_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_L");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_L.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_B_L.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_L(Test_aBFu7ll_B_L, "aBFu7ll_B_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_S()
{
  {
    init_simple_test("aBFu7ll_B_S");
    static aBFu7ll_B_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_S");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_S.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_B_S.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_S(Test_aBFu7ll_B_S, "aBFu7ll_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_Uc()
{
  {
    init_simple_test("aBFu7ll_B_Uc");
    static aBFu7ll_B_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_Uc");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_Uc(Test_aBFu7ll_B_Uc, "aBFu7ll_B_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_Ui()
{
  {
    init_simple_test("aBFu7ll_B_Ui");
    static aBFu7ll_B_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_Ui");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_Ui(Test_aBFu7ll_B_Ui, "aBFu7ll_B_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_Ul()
{
  {
    init_simple_test("aBFu7ll_B_Ul");
    static aBFu7ll_B_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7ll_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_Ul");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_Ul(Test_aBFu7ll_B_Ul, "aBFu7ll_B_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_Us()
{
  {
    init_simple_test("aBFu7ll_B_Us");
    static aBFu7ll_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_Us");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_B_Us.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_Us(Test_aBFu7ll_B_Us, "aBFu7ll_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_B_Vp()
{
  {
    init_simple_test("aBFu7ll_B_Vp");
    static aBFu7ll_B_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7ll_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_B_Vp");
    check_field_offset(lv, v2, 1, "aBFu7ll_B_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_B_Vp(Test_aBFu7ll_B_Vp, "aBFu7ll_B_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu15i_B()
{
  {
    init_simple_test("aBFu7ll_BFu15i_B");
    static aBFu7ll_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "aBFu7ll_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "aBFu7ll_BFu15i_B");
    check_field_offset(lv, v3, 3, "aBFu7ll_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu15i_B(Test_aBFu7ll_BFu15i_B, "aBFu7ll_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu15ll_B()
{
  {
    init_simple_test("aBFu7ll_BFu15ll_B");
    static aBFu7ll_BFu15ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "aBFu7ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "aBFu7ll_BFu15ll_B");
    check_field_offset(lv, v3, 3, "aBFu7ll_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu15ll_B(Test_aBFu7ll_BFu15ll_B, "aBFu7ll_BFu15ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu15s_B()
{
  {
    init_simple_test("aBFu7ll_BFu15s_B");
    static aBFu7ll_BFu15s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu15s_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "aBFu7ll_BFu15s_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "aBFu7ll_BFu15s_B");
    check_field_offset(lv, v3, 3, "aBFu7ll_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu15s_B(Test_aBFu7ll_BFu15s_B, "aBFu7ll_BFu15s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu16i_B()
{
  {
    init_simple_test("aBFu7ll_BFu16i_B");
    static aBFu7ll_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "aBFu7ll_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "aBFu7ll_BFu16i_B");
    check_field_offset(lv, v3, 3, "aBFu7ll_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu16i_B(Test_aBFu7ll_BFu16i_B, "aBFu7ll_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu16ll_B()
{
  {
    init_simple_test("aBFu7ll_BFu16ll_B");
    static aBFu7ll_BFu16ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "aBFu7ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "aBFu7ll_BFu16ll_B");
    check_field_offset(lv, v3, 3, "aBFu7ll_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu16ll_B(Test_aBFu7ll_BFu16ll_B, "aBFu7ll_BFu16ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu16s_B()
{
  {
    init_simple_test("aBFu7ll_BFu16s_B");
    static aBFu7ll_BFu16s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu16s_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "aBFu7ll_BFu16s_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "aBFu7ll_BFu16s_B");
    check_field_offset(lv, v3, 3, "aBFu7ll_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu16s_B(Test_aBFu7ll_BFu16s_B, "aBFu7ll_BFu16s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu17i_B()
{
  {
    init_simple_test("aBFu7ll_BFu17i_B");
    static aBFu7ll_BFu17i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "aBFu7ll_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "aBFu7ll_BFu17i_B");
    check_field_offset(lv, v3, 3, "aBFu7ll_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu17i_B(Test_aBFu7ll_BFu17i_B, "aBFu7ll_BFu17i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu17ll_B()
{
  {
    init_simple_test("aBFu7ll_BFu17ll_B");
    static aBFu7ll_BFu17ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "aBFu7ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "aBFu7ll_BFu17ll_B");
    check_field_offset(lv, v3, 3, "aBFu7ll_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu17ll_B(Test_aBFu7ll_BFu17ll_B, "aBFu7ll_BFu17ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu1c_B()
{
  {
    init_simple_test("aBFu7ll_BFu1c_B");
    static aBFu7ll_BFu1c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7ll_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu1c_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7ll_BFu1c_B");
    check_field_offset(lv, v3, 1, "aBFu7ll_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu1c_B(Test_aBFu7ll_BFu1c_B, "aBFu7ll_BFu1c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu1i_B()
{
  {
    init_simple_test("aBFu7ll_BFu1i_B");
    static aBFu7ll_BFu1i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7ll_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu1i_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7ll_BFu1i_B");
    check_field_offset(lv, v3, 1, "aBFu7ll_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu1i_B(Test_aBFu7ll_BFu1i_B, "aBFu7ll_BFu1i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu1ll_B()
{
  {
    init_simple_test("aBFu7ll_BFu1ll_B");
    static aBFu7ll_BFu1ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7ll_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu1ll_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7ll_BFu1ll_B");
    check_field_offset(lv, v3, 1, "aBFu7ll_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu1ll_B(Test_aBFu7ll_BFu1ll_B, "aBFu7ll_BFu1ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu1s_B()
{
  {
    init_simple_test("aBFu7ll_BFu1s_B");
    static aBFu7ll_BFu1s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7ll_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu1s_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7ll_BFu1s_B");
    check_field_offset(lv, v3, 1, "aBFu7ll_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu1s_B(Test_aBFu7ll_BFu1s_B, "aBFu7ll_BFu1s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu31i_B()
{
  {
    init_simple_test("aBFu7ll_BFu31i_B");
    static aBFu7ll_BFu31i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu31i_B");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "aBFu7ll_BFu31i_B");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "aBFu7ll_BFu31i_B");
    check_field_offset(lv, v3, 5, "aBFu7ll_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu31i_B(Test_aBFu7ll_BFu31i_B, "aBFu7ll_BFu31i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu31ll_B()
{
  {
    init_simple_test("aBFu7ll_BFu31ll_B");
    static aBFu7ll_BFu31ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "aBFu7ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "aBFu7ll_BFu31ll_B");
    check_field_offset(lv, v3, 5, "aBFu7ll_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu31ll_B(Test_aBFu7ll_BFu31ll_B, "aBFu7ll_BFu31ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu32i_B()
{
  {
    init_simple_test("aBFu7ll_BFu32i_B");
    static aBFu7ll_BFu32i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu32i_B");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "aBFu7ll_BFu32i_B");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "aBFu7ll_BFu32i_B");
    check_field_offset(lv, v3, 5, "aBFu7ll_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu32i_B(Test_aBFu7ll_BFu32i_B, "aBFu7ll_BFu32i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu32ll_B()
{
  {
    init_simple_test("aBFu7ll_BFu32ll_B");
    static aBFu7ll_BFu32ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "aBFu7ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "aBFu7ll_BFu32ll_B");
    check_field_offset(lv, v3, 5, "aBFu7ll_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu32ll_B(Test_aBFu7ll_BFu32ll_B, "aBFu7ll_BFu32ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu33_B()
{
  {
    init_simple_test("aBFu7ll_BFu33_B");
    static aBFu7ll_BFu33_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "aBFu7ll_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "aBFu7ll_BFu33_B");
    check_field_offset(lv, v3, 5, "aBFu7ll_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu33_B(Test_aBFu7ll_BFu33_B, "aBFu7ll_BFu33_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu7c_B()
{
  {
    init_simple_test("aBFu7ll_BFu7c_B");
    static aBFu7ll_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu7c_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7ll_BFu7c_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7ll_BFu7c_B");
    check_field_offset(lv, v3, 2, "aBFu7ll_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu7c_B(Test_aBFu7ll_BFu7c_B, "aBFu7ll_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu7i_B()
{
  {
    init_simple_test("aBFu7ll_BFu7i_B");
    static aBFu7ll_BFu7i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7ll_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7ll_BFu7i_B");
    check_field_offset(lv, v3, 2, "aBFu7ll_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu7i_B(Test_aBFu7ll_BFu7i_B, "aBFu7ll_BFu7i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu7ll_B()
{
  {
    init_simple_test("aBFu7ll_BFu7ll_B");
    static aBFu7ll_BFu7ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7ll_BFu7ll_B");
    check_field_offset(lv, v3, 2, "aBFu7ll_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu7ll_B(Test_aBFu7ll_BFu7ll_B, "aBFu7ll_BFu7ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu7s_B()
{
  {
    init_simple_test("aBFu7ll_BFu7s_B");
    static aBFu7ll_BFu7s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7ll_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7ll_BFu7s_B");
    check_field_offset(lv, v3, 2, "aBFu7ll_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu7s_B(Test_aBFu7ll_BFu7s_B, "aBFu7ll_BFu7s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu8c_B()
{
  {
    init_simple_test("aBFu7ll_BFu8c_B");
    static aBFu7ll_BFu8c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu8c_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7ll_BFu8c_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7ll_BFu8c_B");
    check_field_offset(lv, v3, 2, "aBFu7ll_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu8c_B(Test_aBFu7ll_BFu8c_B, "aBFu7ll_BFu8c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu8i_B()
{
  {
    init_simple_test("aBFu7ll_BFu8i_B");
    static aBFu7ll_BFu8i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7ll_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7ll_BFu8i_B");
    check_field_offset(lv, v3, 2, "aBFu7ll_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu8i_B(Test_aBFu7ll_BFu8i_B, "aBFu7ll_BFu8i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu8ll_B()
{
  {
    init_simple_test("aBFu7ll_BFu8ll_B");
    static aBFu7ll_BFu8ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7ll_BFu8ll_B");
    check_field_offset(lv, v3, 2, "aBFu7ll_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu8ll_B(Test_aBFu7ll_BFu8ll_B, "aBFu7ll_BFu8ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu8s_B()
{
  {
    init_simple_test("aBFu7ll_BFu8s_B");
    static aBFu7ll_BFu8s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7ll_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7ll_BFu8s_B");
    check_field_offset(lv, v3, 2, "aBFu7ll_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu8s_B(Test_aBFu7ll_BFu8s_B, "aBFu7ll_BFu8s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu9i_B()
{
  {
    init_simple_test("aBFu7ll_BFu9i_B");
    static aBFu7ll_BFu9i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "aBFu7ll_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "aBFu7ll_BFu9i_B");
    check_field_offset(lv, v3, 2, "aBFu7ll_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu9i_B(Test_aBFu7ll_BFu9i_B, "aBFu7ll_BFu9i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu9ll_B()
{
  {
    init_simple_test("aBFu7ll_BFu9ll_B");
    static aBFu7ll_BFu9ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "aBFu7ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "aBFu7ll_BFu9ll_B");
    check_field_offset(lv, v3, 2, "aBFu7ll_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu9ll_B(Test_aBFu7ll_BFu9ll_B, "aBFu7ll_BFu9ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_BFu9s_B()
{
  {
    init_simple_test("aBFu7ll_BFu9s_B");
    static aBFu7ll_BFu9s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "aBFu7ll_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "aBFu7ll_BFu9s_B");
    check_field_offset(lv, v3, 2, "aBFu7ll_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_BFu9s_B(Test_aBFu7ll_BFu9s_B, "aBFu7ll_BFu9s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_C_B()
{
  {
    init_simple_test("aBFu7ll_C_B");
    static aBFu7ll_C_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_C_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_C_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_C_B.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_C_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_C_B(Test_aBFu7ll_C_B, "aBFu7ll_C_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_D_B()
{
  {
    init_simple_test("aBFu7ll_D_B");
    static aBFu7ll_D_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7ll_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_D_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_D_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_D_B.v2");
    check_field_offset(lv, v3, 9, "aBFu7ll_D_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_D_B(Test_aBFu7ll_D_B, "aBFu7ll_D_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_F_B()
{
  {
    init_simple_test("aBFu7ll_F_B");
    static aBFu7ll_F_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_F_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_F_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_F_B.v2");
    check_field_offset(lv, v3, 5, "aBFu7ll_F_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_F_B(Test_aBFu7ll_F_B, "aBFu7ll_F_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_I_B()
{
  {
    init_simple_test("aBFu7ll_I_B");
    static aBFu7ll_I_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_I_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_I_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_I_B.v2");
    check_field_offset(lv, v3, 5, "aBFu7ll_I_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_I_B(Test_aBFu7ll_I_B, "aBFu7ll_I_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_Ip_B()
{
  {
    init_simple_test("aBFu7ll_Ip_B");
    static aBFu7ll_Ip_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7ll_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_Ip_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu7ll_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_Ip_B(Test_aBFu7ll_Ip_B, "aBFu7ll_Ip_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_L_B()
{
  {
    init_simple_test("aBFu7ll_L_B");
    static aBFu7ll_L_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7ll_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_L_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_L_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_L_B.v2");
    check_field_offset(lv, v3, 9, "aBFu7ll_L_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_L_B(Test_aBFu7ll_L_B, "aBFu7ll_L_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_S_B()
{
  {
    init_simple_test("aBFu7ll_S_B");
    static aBFu7ll_S_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_S_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_S_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_S_B.v2");
    check_field_offset(lv, v3, 3, "aBFu7ll_S_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_S_B(Test_aBFu7ll_S_B, "aBFu7ll_S_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_Uc_B()
{
  {
    init_simple_test("aBFu7ll_Uc_B");
    static aBFu7ll_Uc_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7ll_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_Uc_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_Uc_B.v2");
    check_field_offset(lv, v3, 2, "aBFu7ll_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_Uc_B(Test_aBFu7ll_Uc_B, "aBFu7ll_Uc_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_Ui_B()
{
  {
    init_simple_test("aBFu7ll_Ui_B");
    static aBFu7ll_Ui_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7ll_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_Ui_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_Ui_B.v2");
    check_field_offset(lv, v3, 5, "aBFu7ll_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_Ui_B(Test_aBFu7ll_Ui_B, "aBFu7ll_Ui_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_Ul_B()
{
  {
    init_simple_test("aBFu7ll_Ul_B");
    static aBFu7ll_Ul_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7ll_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_Ul_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_Ul_B.v2");
    check_field_offset(lv, v3, 9, "aBFu7ll_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_Ul_B(Test_aBFu7ll_Ul_B, "aBFu7ll_Ul_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_Us_B()
{
  {
    init_simple_test("aBFu7ll_Us_B");
    static aBFu7ll_Us_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7ll_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_Us_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_Us_B.v2");
    check_field_offset(lv, v3, 3, "aBFu7ll_Us_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_Us_B(Test_aBFu7ll_Us_B, "aBFu7ll_Us_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7ll_Vp_B()
{
  {
    init_simple_test("aBFu7ll_Vp_B");
    static aBFu7ll_Vp_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7ll_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_Vp_B");
    check_field_offset(lv, v2, 1, "aBFu7ll_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu7ll_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7ll_Vp_B(Test_aBFu7ll_Vp_B, "aBFu7ll_Vp_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B()
{
  {
    init_simple_test("aBFu7s_B");
    static aBFu7s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B");
    check_field_offset(lv, v2, 1, "aBFu7s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu7s_B(Test_aBFu7s_B, "aBFu7s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_B()
{
  {
    init_simple_test("aBFu7s_B_B");
    static aBFu7s_B_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_B");
    check_field_offset(lv, v2, 1, "aBFu7s_B_B.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_B_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_B(Test_aBFu7s_B_B, "aBFu7s_B_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu15i()
{
  {
    init_simple_test("aBFu7s_B_BFu15i");
    static aBFu7s_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu7s_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu7s_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu15i(Test_aBFu7s_B_BFu15i, "aBFu7s_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu15ll()
{
  {
    init_simple_test("aBFu7s_B_BFu15ll");
    static aBFu7s_B_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu7s_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu7s_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu15ll(Test_aBFu7s_B_BFu15ll, "aBFu7s_B_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu15s()
{
  {
    init_simple_test("aBFu7s_B_BFu15s");
    static aBFu7s_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu7s_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu7s_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu15s(Test_aBFu7s_B_BFu15s, "aBFu7s_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu16i()
{
  {
    init_simple_test("aBFu7s_B_BFu16i");
    static aBFu7s_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu7s_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu7s_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu16i(Test_aBFu7s_B_BFu16i, "aBFu7s_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu16ll()
{
  {
    init_simple_test("aBFu7s_B_BFu16ll");
    static aBFu7s_B_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu7s_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu7s_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu16ll(Test_aBFu7s_B_BFu16ll, "aBFu7s_B_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu16s()
{
  {
    init_simple_test("aBFu7s_B_BFu16s");
    static aBFu7s_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu7s_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu7s_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu16s(Test_aBFu7s_B_BFu16s, "aBFu7s_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu17i()
{
  {
    init_simple_test("aBFu7s_B_BFu17i");
    static aBFu7s_B_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu7s_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu7s_B_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu7s_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu17i(Test_aBFu7s_B_BFu17i, "aBFu7s_B_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu17ll()
{
  {
    init_simple_test("aBFu7s_B_BFu17ll");
    static aBFu7s_B_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu7s_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu7s_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu7s_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu17ll(Test_aBFu7s_B_BFu17ll, "aBFu7s_B_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu1c()
{
  {
    init_simple_test("aBFu7s_B_BFu1c");
    static aBFu7s_B_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7s_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu1c(Test_aBFu7s_B_BFu1c, "aBFu7s_B_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu1i()
{
  {
    init_simple_test("aBFu7s_B_BFu1i");
    static aBFu7s_B_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7s_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu1i(Test_aBFu7s_B_BFu1i, "aBFu7s_B_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu1ll()
{
  {
    init_simple_test("aBFu7s_B_BFu1ll");
    static aBFu7s_B_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7s_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu1ll(Test_aBFu7s_B_BFu1ll, "aBFu7s_B_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu1s()
{
  {
    init_simple_test("aBFu7s_B_BFu1s");
    static aBFu7s_B_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu7s_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu1s(Test_aBFu7s_B_BFu1s, "aBFu7s_B_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu31i()
{
  {
    init_simple_test("aBFu7s_B_BFu31i");
    static aBFu7s_B_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu7s_B_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu7s_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu31i(Test_aBFu7s_B_BFu31i, "aBFu7s_B_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu31ll()
{
  {
    init_simple_test("aBFu7s_B_BFu31ll");
    static aBFu7s_B_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu7s_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu7s_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu31ll(Test_aBFu7s_B_BFu31ll, "aBFu7s_B_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu32i()
{
  {
    init_simple_test("aBFu7s_B_BFu32i");
    static aBFu7s_B_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu7s_B_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu7s_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu32i(Test_aBFu7s_B_BFu32i, "aBFu7s_B_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu32ll()
{
  {
    init_simple_test("aBFu7s_B_BFu32ll");
    static aBFu7s_B_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu7s_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu7s_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu32ll(Test_aBFu7s_B_BFu32ll, "aBFu7s_B_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu33()
{
  {
    init_simple_test("aBFu7s_B_BFu33");
    static aBFu7s_B_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu7s_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu33");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu7s_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu7s_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu33(Test_aBFu7s_B_BFu33, "aBFu7s_B_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu7c()
{
  {
    init_simple_test("aBFu7s_B_BFu7c");
    static aBFu7s_B_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7s_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu7c(Test_aBFu7s_B_BFu7c, "aBFu7s_B_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu7i()
{
  {
    init_simple_test("aBFu7s_B_BFu7i");
    static aBFu7s_B_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7s_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu7i(Test_aBFu7s_B_BFu7i, "aBFu7s_B_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu7ll()
{
  {
    init_simple_test("aBFu7s_B_BFu7ll");
    static aBFu7s_B_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7s_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu7ll(Test_aBFu7s_B_BFu7ll, "aBFu7s_B_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu7s()
{
  {
    init_simple_test("aBFu7s_B_BFu7s");
    static aBFu7s_B_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu7s_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu7s(Test_aBFu7s_B_BFu7s, "aBFu7s_B_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu8c()
{
  {
    init_simple_test("aBFu7s_B_BFu8c");
    static aBFu7s_B_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7s_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7s_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu8c(Test_aBFu7s_B_BFu8c, "aBFu7s_B_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu8i()
{
  {
    init_simple_test("aBFu7s_B_BFu8i");
    static aBFu7s_B_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7s_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7s_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu8i(Test_aBFu7s_B_BFu8i, "aBFu7s_B_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu8ll()
{
  {
    init_simple_test("aBFu7s_B_BFu8ll");
    static aBFu7s_B_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7s_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7s_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu8ll(Test_aBFu7s_B_BFu8ll, "aBFu7s_B_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu8s()
{
  {
    init_simple_test("aBFu7s_B_BFu8s");
    static aBFu7s_B_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu7s_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu7s_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu8s(Test_aBFu7s_B_BFu8s, "aBFu7s_B_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu9i()
{
  {
    init_simple_test("aBFu7s_B_BFu9i");
    static aBFu7s_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu7s_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu7s_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu9i(Test_aBFu7s_B_BFu9i, "aBFu7s_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu9ll()
{
  {
    init_simple_test("aBFu7s_B_BFu9ll");
    static aBFu7s_B_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu7s_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu7s_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu9ll(Test_aBFu7s_B_BFu9ll, "aBFu7s_B_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_BFu9s()
{
  {
    init_simple_test("aBFu7s_B_BFu9s");
    static aBFu7s_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu7s_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu7s_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu7s_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_BFu9s(Test_aBFu7s_B_BFu9s, "aBFu7s_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_C()
{
  {
    init_simple_test("aBFu7s_B_C");
    static aBFu7s_B_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_C");
    check_field_offset(lv, v2, 1, "aBFu7s_B_C.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_B_C.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_C(Test_aBFu7s_B_C, "aBFu7s_B_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_D()
{
  {
    init_simple_test("aBFu7s_B_D");
    static aBFu7s_B_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7s_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_D");
    check_field_offset(lv, v2, 1, "aBFu7s_B_D.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_B_D.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_D(Test_aBFu7s_B_D, "aBFu7s_B_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_F()
{
  {
    init_simple_test("aBFu7s_B_F");
    static aBFu7s_B_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_F");
    check_field_offset(lv, v2, 1, "aBFu7s_B_F.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_B_F.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_F(Test_aBFu7s_B_F, "aBFu7s_B_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_I()
{
  {
    init_simple_test("aBFu7s_B_I");
    static aBFu7s_B_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_I");
    check_field_offset(lv, v2, 1, "aBFu7s_B_I.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_B_I.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_I(Test_aBFu7s_B_I, "aBFu7s_B_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_Ip()
{
  {
    init_simple_test("aBFu7s_B_Ip");
    static aBFu7s_B_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7s_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_Ip");
    check_field_offset(lv, v2, 1, "aBFu7s_B_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_Ip(Test_aBFu7s_B_Ip, "aBFu7s_B_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_L()
{
  {
    init_simple_test("aBFu7s_B_L");
    static aBFu7s_B_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7s_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_L");
    check_field_offset(lv, v2, 1, "aBFu7s_B_L.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_B_L.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_L(Test_aBFu7s_B_L, "aBFu7s_B_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_S()
{
  {
    init_simple_test("aBFu7s_B_S");
    static aBFu7s_B_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_S");
    check_field_offset(lv, v2, 1, "aBFu7s_B_S.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_B_S.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_S(Test_aBFu7s_B_S, "aBFu7s_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_Uc()
{
  {
    init_simple_test("aBFu7s_B_Uc");
    static aBFu7s_B_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_Uc");
    check_field_offset(lv, v2, 1, "aBFu7s_B_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_Uc(Test_aBFu7s_B_Uc, "aBFu7s_B_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_Ui()
{
  {
    init_simple_test("aBFu7s_B_Ui");
    static aBFu7s_B_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_Ui");
    check_field_offset(lv, v2, 1, "aBFu7s_B_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_Ui(Test_aBFu7s_B_Ui, "aBFu7s_B_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_Ul()
{
  {
    init_simple_test("aBFu7s_B_Ul");
    static aBFu7s_B_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7s_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_Ul");
    check_field_offset(lv, v2, 1, "aBFu7s_B_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_Ul(Test_aBFu7s_B_Ul, "aBFu7s_B_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_Us()
{
  {
    init_simple_test("aBFu7s_B_Us");
    static aBFu7s_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_Us");
    check_field_offset(lv, v2, 1, "aBFu7s_B_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_B_Us.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_Us(Test_aBFu7s_B_Us, "aBFu7s_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_B_Vp()
{
  {
    init_simple_test("aBFu7s_B_Vp");
    static aBFu7s_B_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7s_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_B_Vp");
    check_field_offset(lv, v2, 1, "aBFu7s_B_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_B_Vp(Test_aBFu7s_B_Vp, "aBFu7s_B_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu15i_B()
{
  {
    init_simple_test("aBFu7s_BFu15i_B");
    static aBFu7s_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "aBFu7s_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "aBFu7s_BFu15i_B");
    check_field_offset(lv, v3, 3, "aBFu7s_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu15i_B(Test_aBFu7s_BFu15i_B, "aBFu7s_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu15ll_B()
{
  {
    init_simple_test("aBFu7s_BFu15ll_B");
    static aBFu7s_BFu15ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "aBFu7s_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "aBFu7s_BFu15ll_B");
    check_field_offset(lv, v3, 3, "aBFu7s_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu15ll_B(Test_aBFu7s_BFu15ll_B, "aBFu7s_BFu15ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu15s_B()
{
  {
    init_simple_test("aBFu7s_BFu15s_B");
    static aBFu7s_BFu15s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu15s_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "aBFu7s_BFu15s_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "aBFu7s_BFu15s_B");
    check_field_offset(lv, v3, 3, "aBFu7s_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu15s_B(Test_aBFu7s_BFu15s_B, "aBFu7s_BFu15s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu16i_B()
{
  {
    init_simple_test("aBFu7s_BFu16i_B");
    static aBFu7s_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "aBFu7s_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "aBFu7s_BFu16i_B");
    check_field_offset(lv, v3, 3, "aBFu7s_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu16i_B(Test_aBFu7s_BFu16i_B, "aBFu7s_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu16ll_B()
{
  {
    init_simple_test("aBFu7s_BFu16ll_B");
    static aBFu7s_BFu16ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "aBFu7s_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "aBFu7s_BFu16ll_B");
    check_field_offset(lv, v3, 3, "aBFu7s_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu16ll_B(Test_aBFu7s_BFu16ll_B, "aBFu7s_BFu16ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu16s_B()
{
  {
    init_simple_test("aBFu7s_BFu16s_B");
    static aBFu7s_BFu16s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu16s_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "aBFu7s_BFu16s_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "aBFu7s_BFu16s_B");
    check_field_offset(lv, v3, 3, "aBFu7s_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu16s_B(Test_aBFu7s_BFu16s_B, "aBFu7s_BFu16s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu17i_B()
{
  {
    init_simple_test("aBFu7s_BFu17i_B");
    static aBFu7s_BFu17i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "aBFu7s_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "aBFu7s_BFu17i_B");
    check_field_offset(lv, v3, 3, "aBFu7s_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu17i_B(Test_aBFu7s_BFu17i_B, "aBFu7s_BFu17i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu17ll_B()
{
  {
    init_simple_test("aBFu7s_BFu17ll_B");
    static aBFu7s_BFu17ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "aBFu7s_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "aBFu7s_BFu17ll_B");
    check_field_offset(lv, v3, 3, "aBFu7s_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu17ll_B(Test_aBFu7s_BFu17ll_B, "aBFu7s_BFu17ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu1c_B()
{
  {
    init_simple_test("aBFu7s_BFu1c_B");
    static aBFu7s_BFu1c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7s_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu1c_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7s_BFu1c_B");
    check_field_offset(lv, v3, 1, "aBFu7s_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu1c_B(Test_aBFu7s_BFu1c_B, "aBFu7s_BFu1c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu1i_B()
{
  {
    init_simple_test("aBFu7s_BFu1i_B");
    static aBFu7s_BFu1i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7s_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu1i_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7s_BFu1i_B");
    check_field_offset(lv, v3, 1, "aBFu7s_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu1i_B(Test_aBFu7s_BFu1i_B, "aBFu7s_BFu1i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu1ll_B()
{
  {
    init_simple_test("aBFu7s_BFu1ll_B");
    static aBFu7s_BFu1ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7s_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu1ll_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7s_BFu1ll_B");
    check_field_offset(lv, v3, 1, "aBFu7s_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu1ll_B(Test_aBFu7s_BFu1ll_B, "aBFu7s_BFu1ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu1s_B()
{
  {
    init_simple_test("aBFu7s_BFu1s_B");
    static aBFu7s_BFu1s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu7s_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu1s_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "aBFu7s_BFu1s_B");
    check_field_offset(lv, v3, 1, "aBFu7s_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu1s_B(Test_aBFu7s_BFu1s_B, "aBFu7s_BFu1s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu31i_B()
{
  {
    init_simple_test("aBFu7s_BFu31i_B");
    static aBFu7s_BFu31i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu31i_B");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "aBFu7s_BFu31i_B");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "aBFu7s_BFu31i_B");
    check_field_offset(lv, v3, 5, "aBFu7s_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu31i_B(Test_aBFu7s_BFu31i_B, "aBFu7s_BFu31i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu31ll_B()
{
  {
    init_simple_test("aBFu7s_BFu31ll_B");
    static aBFu7s_BFu31ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "aBFu7s_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "aBFu7s_BFu31ll_B");
    check_field_offset(lv, v3, 5, "aBFu7s_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu31ll_B(Test_aBFu7s_BFu31ll_B, "aBFu7s_BFu31ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu32i_B()
{
  {
    init_simple_test("aBFu7s_BFu32i_B");
    static aBFu7s_BFu32i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu32i_B");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "aBFu7s_BFu32i_B");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "aBFu7s_BFu32i_B");
    check_field_offset(lv, v3, 5, "aBFu7s_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu32i_B(Test_aBFu7s_BFu32i_B, "aBFu7s_BFu32i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu32ll_B()
{
  {
    init_simple_test("aBFu7s_BFu32ll_B");
    static aBFu7s_BFu32ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "aBFu7s_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "aBFu7s_BFu32ll_B");
    check_field_offset(lv, v3, 5, "aBFu7s_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu32ll_B(Test_aBFu7s_BFu32ll_B, "aBFu7s_BFu32ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu33_B()
{
  {
    init_simple_test("aBFu7s_BFu33_B");
    static aBFu7s_BFu33_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "aBFu7s_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "aBFu7s_BFu33_B");
    check_field_offset(lv, v3, 5, "aBFu7s_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu33_B(Test_aBFu7s_BFu33_B, "aBFu7s_BFu33_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu7c_B()
{
  {
    init_simple_test("aBFu7s_BFu7c_B");
    static aBFu7s_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu7c_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7s_BFu7c_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7s_BFu7c_B");
    check_field_offset(lv, v3, 2, "aBFu7s_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu7c_B(Test_aBFu7s_BFu7c_B, "aBFu7s_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu7i_B()
{
  {
    init_simple_test("aBFu7s_BFu7i_B");
    static aBFu7s_BFu7i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7s_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7s_BFu7i_B");
    check_field_offset(lv, v3, 2, "aBFu7s_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu7i_B(Test_aBFu7s_BFu7i_B, "aBFu7s_BFu7i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu7ll_B()
{
  {
    init_simple_test("aBFu7s_BFu7ll_B");
    static aBFu7s_BFu7ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7s_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7s_BFu7ll_B");
    check_field_offset(lv, v3, 2, "aBFu7s_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu7ll_B(Test_aBFu7s_BFu7ll_B, "aBFu7s_BFu7ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu7s_B()
{
  {
    init_simple_test("aBFu7s_BFu7s_B");
    static aBFu7s_BFu7s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "aBFu7s_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "aBFu7s_BFu7s_B");
    check_field_offset(lv, v3, 2, "aBFu7s_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu7s_B(Test_aBFu7s_BFu7s_B, "aBFu7s_BFu7s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu8c_B()
{
  {
    init_simple_test("aBFu7s_BFu8c_B");
    static aBFu7s_BFu8c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu8c_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7s_BFu8c_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7s_BFu8c_B");
    check_field_offset(lv, v3, 2, "aBFu7s_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu8c_B(Test_aBFu7s_BFu8c_B, "aBFu7s_BFu8c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu8i_B()
{
  {
    init_simple_test("aBFu7s_BFu8i_B");
    static aBFu7s_BFu8i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7s_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7s_BFu8i_B");
    check_field_offset(lv, v3, 2, "aBFu7s_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu8i_B(Test_aBFu7s_BFu8i_B, "aBFu7s_BFu8i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu8ll_B()
{
  {
    init_simple_test("aBFu7s_BFu8ll_B");
    static aBFu7s_BFu8ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7s_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7s_BFu8ll_B");
    check_field_offset(lv, v3, 2, "aBFu7s_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu8ll_B(Test_aBFu7s_BFu8ll_B, "aBFu7s_BFu8ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu8s_B()
{
  {
    init_simple_test("aBFu7s_BFu8s_B");
    static aBFu7s_BFu8s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "aBFu7s_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "aBFu7s_BFu8s_B");
    check_field_offset(lv, v3, 2, "aBFu7s_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu8s_B(Test_aBFu7s_BFu8s_B, "aBFu7s_BFu8s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu9i_B()
{
  {
    init_simple_test("aBFu7s_BFu9i_B");
    static aBFu7s_BFu9i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "aBFu7s_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "aBFu7s_BFu9i_B");
    check_field_offset(lv, v3, 2, "aBFu7s_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu9i_B(Test_aBFu7s_BFu9i_B, "aBFu7s_BFu9i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu9ll_B()
{
  {
    init_simple_test("aBFu7s_BFu9ll_B");
    static aBFu7s_BFu9ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "aBFu7s_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "aBFu7s_BFu9ll_B");
    check_field_offset(lv, v3, 2, "aBFu7s_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu9ll_B(Test_aBFu7s_BFu9ll_B, "aBFu7s_BFu9ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_BFu9s_B()
{
  {
    init_simple_test("aBFu7s_BFu9s_B");
    static aBFu7s_BFu9s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "aBFu7s_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "aBFu7s_BFu9s_B");
    check_field_offset(lv, v3, 2, "aBFu7s_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_BFu9s_B(Test_aBFu7s_BFu9s_B, "aBFu7s_BFu9s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_C_B()
{
  {
    init_simple_test("aBFu7s_C_B");
    static aBFu7s_C_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_C_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_C_B");
    check_field_offset(lv, v2, 1, "aBFu7s_C_B.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_C_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_C_B(Test_aBFu7s_C_B, "aBFu7s_C_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_D_B()
{
  {
    init_simple_test("aBFu7s_D_B");
    static aBFu7s_D_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7s_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_D_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_D_B");
    check_field_offset(lv, v2, 1, "aBFu7s_D_B.v2");
    check_field_offset(lv, v3, 9, "aBFu7s_D_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_D_B(Test_aBFu7s_D_B, "aBFu7s_D_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_F_B()
{
  {
    init_simple_test("aBFu7s_F_B");
    static aBFu7s_F_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_F_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_F_B");
    check_field_offset(lv, v2, 1, "aBFu7s_F_B.v2");
    check_field_offset(lv, v3, 5, "aBFu7s_F_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_F_B(Test_aBFu7s_F_B, "aBFu7s_F_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_I_B()
{
  {
    init_simple_test("aBFu7s_I_B");
    static aBFu7s_I_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_I_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_I_B");
    check_field_offset(lv, v2, 1, "aBFu7s_I_B.v2");
    check_field_offset(lv, v3, 5, "aBFu7s_I_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_I_B(Test_aBFu7s_I_B, "aBFu7s_I_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_Ip_B()
{
  {
    init_simple_test("aBFu7s_Ip_B");
    static aBFu7s_Ip_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7s_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_Ip_B");
    check_field_offset(lv, v2, 1, "aBFu7s_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu7s_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_Ip_B(Test_aBFu7s_Ip_B, "aBFu7s_Ip_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_L_B()
{
  {
    init_simple_test("aBFu7s_L_B");
    static aBFu7s_L_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7s_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_L_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_L_B");
    check_field_offset(lv, v2, 1, "aBFu7s_L_B.v2");
    check_field_offset(lv, v3, 9, "aBFu7s_L_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_L_B(Test_aBFu7s_L_B, "aBFu7s_L_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_S_B()
{
  {
    init_simple_test("aBFu7s_S_B");
    static aBFu7s_S_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_S_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_S_B");
    check_field_offset(lv, v2, 1, "aBFu7s_S_B.v2");
    check_field_offset(lv, v3, 3, "aBFu7s_S_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_S_B(Test_aBFu7s_S_B, "aBFu7s_S_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_Uc_B()
{
  {
    init_simple_test("aBFu7s_Uc_B");
    static aBFu7s_Uc_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu7s_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_Uc_B");
    check_field_offset(lv, v2, 1, "aBFu7s_Uc_B.v2");
    check_field_offset(lv, v3, 2, "aBFu7s_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_Uc_B(Test_aBFu7s_Uc_B, "aBFu7s_Uc_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_Ui_B()
{
  {
    init_simple_test("aBFu7s_Ui_B");
    static aBFu7s_Ui_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu7s_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_Ui_B");
    check_field_offset(lv, v2, 1, "aBFu7s_Ui_B.v2");
    check_field_offset(lv, v3, 5, "aBFu7s_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_Ui_B(Test_aBFu7s_Ui_B, "aBFu7s_Ui_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_Ul_B()
{
  {
    init_simple_test("aBFu7s_Ul_B");
    static aBFu7s_Ul_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu7s_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_Ul_B");
    check_field_offset(lv, v2, 1, "aBFu7s_Ul_B.v2");
    check_field_offset(lv, v3, 9, "aBFu7s_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_Ul_B(Test_aBFu7s_Ul_B, "aBFu7s_Ul_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_Us_B()
{
  {
    init_simple_test("aBFu7s_Us_B");
    static aBFu7s_Us_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu7s_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_Us_B");
    check_field_offset(lv, v2, 1, "aBFu7s_Us_B.v2");
    check_field_offset(lv, v3, 3, "aBFu7s_Us_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_Us_B(Test_aBFu7s_Us_B, "aBFu7s_Us_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu7s_Vp_B()
{
  {
    init_simple_test("aBFu7s_Vp_B");
    static aBFu7s_Vp_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu7s_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_Vp_B");
    check_field_offset(lv, v2, 1, "aBFu7s_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu7s_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu7s_Vp_B(Test_aBFu7s_Vp_B, "aBFu7s_Vp_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B()
{
  {
    init_simple_test("aBFu8c_B");
    static aBFu8c_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B");
    check_field_offset(lv, v2, 1, "aBFu8c_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8c_B(Test_aBFu8c_B, "aBFu8c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_B()
{
  {
    init_simple_test("aBFu8c_B_B");
    static aBFu8c_B_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_B");
    check_field_offset(lv, v2, 1, "aBFu8c_B_B.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_B_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_B(Test_aBFu8c_B_B, "aBFu8c_B_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu15i()
{
  {
    init_simple_test("aBFu8c_B_BFu15i");
    static aBFu8c_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8c_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8c_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu15i(Test_aBFu8c_B_BFu15i, "aBFu8c_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu15ll()
{
  {
    init_simple_test("aBFu8c_B_BFu15ll");
    static aBFu8c_B_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8c_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8c_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu15ll(Test_aBFu8c_B_BFu15ll, "aBFu8c_B_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu15s()
{
  {
    init_simple_test("aBFu8c_B_BFu15s");
    static aBFu8c_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8c_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8c_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu15s(Test_aBFu8c_B_BFu15s, "aBFu8c_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu16i()
{
  {
    init_simple_test("aBFu8c_B_BFu16i");
    static aBFu8c_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8c_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8c_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu16i(Test_aBFu8c_B_BFu16i, "aBFu8c_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu16ll()
{
  {
    init_simple_test("aBFu8c_B_BFu16ll");
    static aBFu8c_B_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8c_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8c_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu16ll(Test_aBFu8c_B_BFu16ll, "aBFu8c_B_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu16s()
{
  {
    init_simple_test("aBFu8c_B_BFu16s");
    static aBFu8c_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8c_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8c_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu16s(Test_aBFu8c_B_BFu16s, "aBFu8c_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu17i()
{
  {
    init_simple_test("aBFu8c_B_BFu17i");
    static aBFu8c_B_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8c_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu8c_B_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu8c_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu17i(Test_aBFu8c_B_BFu17i, "aBFu8c_B_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu17ll()
{
  {
    init_simple_test("aBFu8c_B_BFu17ll");
    static aBFu8c_B_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8c_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu8c_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu8c_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu17ll(Test_aBFu8c_B_BFu17ll, "aBFu8c_B_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu1c()
{
  {
    init_simple_test("aBFu8c_B_BFu1c");
    static aBFu8c_B_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8c_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu1c(Test_aBFu8c_B_BFu1c, "aBFu8c_B_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu1i()
{
  {
    init_simple_test("aBFu8c_B_BFu1i");
    static aBFu8c_B_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8c_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu1i(Test_aBFu8c_B_BFu1i, "aBFu8c_B_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu1ll()
{
  {
    init_simple_test("aBFu8c_B_BFu1ll");
    static aBFu8c_B_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8c_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu1ll(Test_aBFu8c_B_BFu1ll, "aBFu8c_B_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu1s()
{
  {
    init_simple_test("aBFu8c_B_BFu1s");
    static aBFu8c_B_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8c_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu1s(Test_aBFu8c_B_BFu1s, "aBFu8c_B_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu31i()
{
  {
    init_simple_test("aBFu8c_B_BFu31i");
    static aBFu8c_B_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu8c_B_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu8c_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu31i(Test_aBFu8c_B_BFu31i, "aBFu8c_B_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu31ll()
{
  {
    init_simple_test("aBFu8c_B_BFu31ll");
    static aBFu8c_B_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu8c_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu8c_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu31ll(Test_aBFu8c_B_BFu31ll, "aBFu8c_B_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu32i()
{
  {
    init_simple_test("aBFu8c_B_BFu32i");
    static aBFu8c_B_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu8c_B_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu8c_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu32i(Test_aBFu8c_B_BFu32i, "aBFu8c_B_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu32ll()
{
  {
    init_simple_test("aBFu8c_B_BFu32ll");
    static aBFu8c_B_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu8c_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu8c_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu32ll(Test_aBFu8c_B_BFu32ll, "aBFu8c_B_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu33()
{
  {
    init_simple_test("aBFu8c_B_BFu33");
    static aBFu8c_B_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8c_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu8c_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu8c_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu33(Test_aBFu8c_B_BFu33, "aBFu8c_B_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu7c()
{
  {
    init_simple_test("aBFu8c_B_BFu7c");
    static aBFu8c_B_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8c_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8c_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu7c(Test_aBFu8c_B_BFu7c, "aBFu8c_B_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu7i()
{
  {
    init_simple_test("aBFu8c_B_BFu7i");
    static aBFu8c_B_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8c_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8c_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu7i(Test_aBFu8c_B_BFu7i, "aBFu8c_B_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu7ll()
{
  {
    init_simple_test("aBFu8c_B_BFu7ll");
    static aBFu8c_B_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8c_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8c_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu7ll(Test_aBFu8c_B_BFu7ll, "aBFu8c_B_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu7s()
{
  {
    init_simple_test("aBFu8c_B_BFu7s");
    static aBFu8c_B_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8c_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8c_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu7s(Test_aBFu8c_B_BFu7s, "aBFu8c_B_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu8c()
{
  {
    init_simple_test("aBFu8c_B_BFu8c");
    static aBFu8c_B_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8c_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu8c(Test_aBFu8c_B_BFu8c, "aBFu8c_B_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu8i()
{
  {
    init_simple_test("aBFu8c_B_BFu8i");
    static aBFu8c_B_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8c_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu8i(Test_aBFu8c_B_BFu8i, "aBFu8c_B_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu8ll()
{
  {
    init_simple_test("aBFu8c_B_BFu8ll");
    static aBFu8c_B_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8c_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu8ll(Test_aBFu8c_B_BFu8ll, "aBFu8c_B_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu8s()
{
  {
    init_simple_test("aBFu8c_B_BFu8s");
    static aBFu8c_B_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8c_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu8s(Test_aBFu8c_B_BFu8s, "aBFu8c_B_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu9i()
{
  {
    init_simple_test("aBFu8c_B_BFu9i");
    static aBFu8c_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8c_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8c_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu9i(Test_aBFu8c_B_BFu9i, "aBFu8c_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu9ll()
{
  {
    init_simple_test("aBFu8c_B_BFu9ll");
    static aBFu8c_B_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8c_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8c_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu9ll(Test_aBFu8c_B_BFu9ll, "aBFu8c_B_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_BFu9s()
{
  {
    init_simple_test("aBFu8c_B_BFu9s");
    static aBFu8c_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8c_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8c_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8c_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_BFu9s(Test_aBFu8c_B_BFu9s, "aBFu8c_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_C()
{
  {
    init_simple_test("aBFu8c_B_C");
    static aBFu8c_B_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_C");
    check_field_offset(lv, v2, 1, "aBFu8c_B_C.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_B_C.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_C(Test_aBFu8c_B_C, "aBFu8c_B_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_D()
{
  {
    init_simple_test("aBFu8c_B_D");
    static aBFu8c_B_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8c_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_D");
    check_field_offset(lv, v2, 1, "aBFu8c_B_D.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_B_D.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_D(Test_aBFu8c_B_D, "aBFu8c_B_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_F()
{
  {
    init_simple_test("aBFu8c_B_F");
    static aBFu8c_B_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_F");
    check_field_offset(lv, v2, 1, "aBFu8c_B_F.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_B_F.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_F(Test_aBFu8c_B_F, "aBFu8c_B_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_I()
{
  {
    init_simple_test("aBFu8c_B_I");
    static aBFu8c_B_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_I");
    check_field_offset(lv, v2, 1, "aBFu8c_B_I.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_B_I.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_I(Test_aBFu8c_B_I, "aBFu8c_B_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_Ip()
{
  {
    init_simple_test("aBFu8c_B_Ip");
    static aBFu8c_B_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8c_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_Ip");
    check_field_offset(lv, v2, 1, "aBFu8c_B_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_Ip(Test_aBFu8c_B_Ip, "aBFu8c_B_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_L()
{
  {
    init_simple_test("aBFu8c_B_L");
    static aBFu8c_B_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8c_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_L");
    check_field_offset(lv, v2, 1, "aBFu8c_B_L.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_B_L.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_L(Test_aBFu8c_B_L, "aBFu8c_B_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_S()
{
  {
    init_simple_test("aBFu8c_B_S");
    static aBFu8c_B_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_S");
    check_field_offset(lv, v2, 1, "aBFu8c_B_S.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_B_S.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_S(Test_aBFu8c_B_S, "aBFu8c_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_Uc()
{
  {
    init_simple_test("aBFu8c_B_Uc");
    static aBFu8c_B_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_Uc");
    check_field_offset(lv, v2, 1, "aBFu8c_B_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_Uc(Test_aBFu8c_B_Uc, "aBFu8c_B_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_Ui()
{
  {
    init_simple_test("aBFu8c_B_Ui");
    static aBFu8c_B_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_Ui");
    check_field_offset(lv, v2, 1, "aBFu8c_B_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_Ui(Test_aBFu8c_B_Ui, "aBFu8c_B_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_Ul()
{
  {
    init_simple_test("aBFu8c_B_Ul");
    static aBFu8c_B_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8c_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_Ul");
    check_field_offset(lv, v2, 1, "aBFu8c_B_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_Ul(Test_aBFu8c_B_Ul, "aBFu8c_B_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_Us()
{
  {
    init_simple_test("aBFu8c_B_Us");
    static aBFu8c_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_Us");
    check_field_offset(lv, v2, 1, "aBFu8c_B_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_B_Us.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_Us(Test_aBFu8c_B_Us, "aBFu8c_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_B_Vp()
{
  {
    init_simple_test("aBFu8c_B_Vp");
    static aBFu8c_B_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8c_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_B_Vp");
    check_field_offset(lv, v2, 1, "aBFu8c_B_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_B_Vp(Test_aBFu8c_B_Vp, "aBFu8c_B_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu15i_B()
{
  {
    init_simple_test("aBFu8c_BFu15i_B");
    static aBFu8c_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8c_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8c_BFu15i_B");
    check_field_offset(lv, v3, 3, "aBFu8c_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu15i_B(Test_aBFu8c_BFu15i_B, "aBFu8c_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu15ll_B()
{
  {
    init_simple_test("aBFu8c_BFu15ll_B");
    static aBFu8c_BFu15ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8c_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8c_BFu15ll_B");
    check_field_offset(lv, v3, 3, "aBFu8c_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu15ll_B(Test_aBFu8c_BFu15ll_B, "aBFu8c_BFu15ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu15s_B()
{
  {
    init_simple_test("aBFu8c_BFu15s_B");
    static aBFu8c_BFu15s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8c_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8c_BFu15s_B");
    check_field_offset(lv, v3, 3, "aBFu8c_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu15s_B(Test_aBFu8c_BFu15s_B, "aBFu8c_BFu15s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu16i_B()
{
  {
    init_simple_test("aBFu8c_BFu16i_B");
    static aBFu8c_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu8c_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu8c_BFu16i_B");
    check_field_offset(lv, v3, 3, "aBFu8c_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu16i_B(Test_aBFu8c_BFu16i_B, "aBFu8c_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu16ll_B()
{
  {
    init_simple_test("aBFu8c_BFu16ll_B");
    static aBFu8c_BFu16ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu8c_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu8c_BFu16ll_B");
    check_field_offset(lv, v3, 3, "aBFu8c_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu16ll_B(Test_aBFu8c_BFu16ll_B, "aBFu8c_BFu16ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu16s_B()
{
  {
    init_simple_test("aBFu8c_BFu16s_B");
    static aBFu8c_BFu16s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu8c_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu8c_BFu16s_B");
    check_field_offset(lv, v3, 3, "aBFu8c_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu16s_B(Test_aBFu8c_BFu16s_B, "aBFu8c_BFu16s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu17i_B()
{
  {
    init_simple_test("aBFu8c_BFu17i_B");
    static aBFu8c_BFu17i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8c_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu8c_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu8c_BFu17i_B");
    check_field_offset(lv, v3, 4, "aBFu8c_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu17i_B(Test_aBFu8c_BFu17i_B, "aBFu8c_BFu17i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu17ll_B()
{
  {
    init_simple_test("aBFu8c_BFu17ll_B");
    static aBFu8c_BFu17ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8c_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu8c_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu8c_BFu17ll_B");
    check_field_offset(lv, v3, 4, "aBFu8c_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu17ll_B(Test_aBFu8c_BFu17ll_B, "aBFu8c_BFu17ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu1c_B()
{
  {
    init_simple_test("aBFu8c_BFu1c_B");
    static aBFu8c_BFu1c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8c_BFu1c_B");
    check_field_offset(lv, v3, 2, "aBFu8c_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu1c_B(Test_aBFu8c_BFu1c_B, "aBFu8c_BFu1c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu1i_B()
{
  {
    init_simple_test("aBFu8c_BFu1i_B");
    static aBFu8c_BFu1i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8c_BFu1i_B");
    check_field_offset(lv, v3, 2, "aBFu8c_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu1i_B(Test_aBFu8c_BFu1i_B, "aBFu8c_BFu1i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu1ll_B()
{
  {
    init_simple_test("aBFu8c_BFu1ll_B");
    static aBFu8c_BFu1ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8c_BFu1ll_B");
    check_field_offset(lv, v3, 2, "aBFu8c_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu1ll_B(Test_aBFu8c_BFu1ll_B, "aBFu8c_BFu1ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu1s_B()
{
  {
    init_simple_test("aBFu8c_BFu1s_B");
    static aBFu8c_BFu1s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8c_BFu1s_B");
    check_field_offset(lv, v3, 2, "aBFu8c_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu1s_B(Test_aBFu8c_BFu1s_B, "aBFu8c_BFu1s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu31i_B()
{
  {
    init_simple_test("aBFu8c_BFu31i_B");
    static aBFu8c_BFu31i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu8c_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu8c_BFu31i_B");
    check_field_offset(lv, v3, 5, "aBFu8c_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu31i_B(Test_aBFu8c_BFu31i_B, "aBFu8c_BFu31i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu31ll_B()
{
  {
    init_simple_test("aBFu8c_BFu31ll_B");
    static aBFu8c_BFu31ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu8c_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu8c_BFu31ll_B");
    check_field_offset(lv, v3, 5, "aBFu8c_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu31ll_B(Test_aBFu8c_BFu31ll_B, "aBFu8c_BFu31ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu32i_B()
{
  {
    init_simple_test("aBFu8c_BFu32i_B");
    static aBFu8c_BFu32i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu8c_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu8c_BFu32i_B");
    check_field_offset(lv, v3, 5, "aBFu8c_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu32i_B(Test_aBFu8c_BFu32i_B, "aBFu8c_BFu32i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu32ll_B()
{
  {
    init_simple_test("aBFu8c_BFu32ll_B");
    static aBFu8c_BFu32ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu8c_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu8c_BFu32ll_B");
    check_field_offset(lv, v3, 5, "aBFu8c_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu32ll_B(Test_aBFu8c_BFu32ll_B, "aBFu8c_BFu32ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu33_B()
{
  {
    init_simple_test("aBFu8c_BFu33_B");
    static aBFu8c_BFu33_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8c_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aBFu8c_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aBFu8c_BFu33_B");
    check_field_offset(lv, v3, 6, "aBFu8c_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu33_B(Test_aBFu8c_BFu33_B, "aBFu8c_BFu33_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu7c_B()
{
  {
    init_simple_test("aBFu8c_BFu7c_B");
    static aBFu8c_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8c_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8c_BFu7c_B");
    check_field_offset(lv, v3, 2, "aBFu8c_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu7c_B(Test_aBFu8c_BFu7c_B, "aBFu8c_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu7i_B()
{
  {
    init_simple_test("aBFu8c_BFu7i_B");
    static aBFu8c_BFu7i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8c_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8c_BFu7i_B");
    check_field_offset(lv, v3, 2, "aBFu8c_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu7i_B(Test_aBFu8c_BFu7i_B, "aBFu8c_BFu7i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu7ll_B()
{
  {
    init_simple_test("aBFu8c_BFu7ll_B");
    static aBFu8c_BFu7ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8c_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8c_BFu7ll_B");
    check_field_offset(lv, v3, 2, "aBFu8c_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu7ll_B(Test_aBFu8c_BFu7ll_B, "aBFu8c_BFu7ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu7s_B()
{
  {
    init_simple_test("aBFu8c_BFu7s_B");
    static aBFu8c_BFu7s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8c_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8c_BFu7s_B");
    check_field_offset(lv, v3, 2, "aBFu8c_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu7s_B(Test_aBFu8c_BFu7s_B, "aBFu8c_BFu7s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu8c_B()
{
  {
    init_simple_test("aBFu8c_BFu8c_B");
    static aBFu8c_BFu8c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8c_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu8c_B");
    check_field_offset(lv, v3, 2, "aBFu8c_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu8c_B(Test_aBFu8c_BFu8c_B, "aBFu8c_BFu8c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu8i_B()
{
  {
    init_simple_test("aBFu8c_BFu8i_B");
    static aBFu8c_BFu8i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8c_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu8i_B");
    check_field_offset(lv, v3, 2, "aBFu8c_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu8i_B(Test_aBFu8c_BFu8i_B, "aBFu8c_BFu8i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu8ll_B()
{
  {
    init_simple_test("aBFu8c_BFu8ll_B");
    static aBFu8c_BFu8ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8c_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu8ll_B");
    check_field_offset(lv, v3, 2, "aBFu8c_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu8ll_B(Test_aBFu8c_BFu8ll_B, "aBFu8c_BFu8ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu8s_B()
{
  {
    init_simple_test("aBFu8c_BFu8s_B");
    static aBFu8c_BFu8s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8c_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu8s_B");
    check_field_offset(lv, v3, 2, "aBFu8c_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu8s_B(Test_aBFu8c_BFu8s_B, "aBFu8c_BFu8s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu9i_B()
{
  {
    init_simple_test("aBFu8c_BFu9i_B");
    static aBFu8c_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu8c_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu8c_BFu9i_B");
    check_field_offset(lv, v3, 3, "aBFu8c_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu9i_B(Test_aBFu8c_BFu9i_B, "aBFu8c_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu9ll_B()
{
  {
    init_simple_test("aBFu8c_BFu9ll_B");
    static aBFu8c_BFu9ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu8c_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu8c_BFu9ll_B");
    check_field_offset(lv, v3, 3, "aBFu8c_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu9ll_B(Test_aBFu8c_BFu9ll_B, "aBFu8c_BFu9ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_BFu9s_B()
{
  {
    init_simple_test("aBFu8c_BFu9s_B");
    static aBFu8c_BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu8c_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu8c_BFu9s_B");
    check_field_offset(lv, v3, 3, "aBFu8c_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_BFu9s_B(Test_aBFu8c_BFu9s_B, "aBFu8c_BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_C_B()
{
  {
    init_simple_test("aBFu8c_C_B");
    static aBFu8c_C_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_C_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_C_B");
    check_field_offset(lv, v2, 1, "aBFu8c_C_B.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_C_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_C_B(Test_aBFu8c_C_B, "aBFu8c_C_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_D_B()
{
  {
    init_simple_test("aBFu8c_D_B");
    static aBFu8c_D_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8c_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_D_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_D_B");
    check_field_offset(lv, v2, 1, "aBFu8c_D_B.v2");
    check_field_offset(lv, v3, 9, "aBFu8c_D_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_D_B(Test_aBFu8c_D_B, "aBFu8c_D_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_F_B()
{
  {
    init_simple_test("aBFu8c_F_B");
    static aBFu8c_F_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_F_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_F_B");
    check_field_offset(lv, v2, 1, "aBFu8c_F_B.v2");
    check_field_offset(lv, v3, 5, "aBFu8c_F_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_F_B(Test_aBFu8c_F_B, "aBFu8c_F_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_I_B()
{
  {
    init_simple_test("aBFu8c_I_B");
    static aBFu8c_I_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_I_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_I_B");
    check_field_offset(lv, v2, 1, "aBFu8c_I_B.v2");
    check_field_offset(lv, v3, 5, "aBFu8c_I_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_I_B(Test_aBFu8c_I_B, "aBFu8c_I_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_Ip_B()
{
  {
    init_simple_test("aBFu8c_Ip_B");
    static aBFu8c_Ip_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8c_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_Ip_B");
    check_field_offset(lv, v2, 1, "aBFu8c_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8c_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_Ip_B(Test_aBFu8c_Ip_B, "aBFu8c_Ip_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_L_B()
{
  {
    init_simple_test("aBFu8c_L_B");
    static aBFu8c_L_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8c_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_L_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_L_B");
    check_field_offset(lv, v2, 1, "aBFu8c_L_B.v2");
    check_field_offset(lv, v3, 9, "aBFu8c_L_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_L_B(Test_aBFu8c_L_B, "aBFu8c_L_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_S_B()
{
  {
    init_simple_test("aBFu8c_S_B");
    static aBFu8c_S_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_S_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_S_B");
    check_field_offset(lv, v2, 1, "aBFu8c_S_B.v2");
    check_field_offset(lv, v3, 3, "aBFu8c_S_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_S_B(Test_aBFu8c_S_B, "aBFu8c_S_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_Uc_B()
{
  {
    init_simple_test("aBFu8c_Uc_B");
    static aBFu8c_Uc_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8c_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_Uc_B");
    check_field_offset(lv, v2, 1, "aBFu8c_Uc_B.v2");
    check_field_offset(lv, v3, 2, "aBFu8c_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_Uc_B(Test_aBFu8c_Uc_B, "aBFu8c_Uc_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_Ui_B()
{
  {
    init_simple_test("aBFu8c_Ui_B");
    static aBFu8c_Ui_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8c_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_Ui_B");
    check_field_offset(lv, v2, 1, "aBFu8c_Ui_B.v2");
    check_field_offset(lv, v3, 5, "aBFu8c_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_Ui_B(Test_aBFu8c_Ui_B, "aBFu8c_Ui_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_Ul_B()
{
  {
    init_simple_test("aBFu8c_Ul_B");
    static aBFu8c_Ul_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8c_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_Ul_B");
    check_field_offset(lv, v2, 1, "aBFu8c_Ul_B.v2");
    check_field_offset(lv, v3, 9, "aBFu8c_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_Ul_B(Test_aBFu8c_Ul_B, "aBFu8c_Ul_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_Us_B()
{
  {
    init_simple_test("aBFu8c_Us_B");
    static aBFu8c_Us_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8c_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_Us_B");
    check_field_offset(lv, v2, 1, "aBFu8c_Us_B.v2");
    check_field_offset(lv, v3, 3, "aBFu8c_Us_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_Us_B(Test_aBFu8c_Us_B, "aBFu8c_Us_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8c_Vp_B()
{
  {
    init_simple_test("aBFu8c_Vp_B");
    static aBFu8c_Vp_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8c_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_Vp_B");
    check_field_offset(lv, v2, 1, "aBFu8c_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8c_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8c_Vp_B(Test_aBFu8c_Vp_B, "aBFu8c_Vp_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B()
{
  {
    init_simple_test("aBFu8i_B");
    static aBFu8i_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B");
    check_field_offset(lv, v2, 1, "aBFu8i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8i_B(Test_aBFu8i_B, "aBFu8i_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_B()
{
  {
    init_simple_test("aBFu8i_B_B");
    static aBFu8i_B_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_B");
    check_field_offset(lv, v2, 1, "aBFu8i_B_B.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_B_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_B(Test_aBFu8i_B_B, "aBFu8i_B_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu15i()
{
  {
    init_simple_test("aBFu8i_B_BFu15i");
    static aBFu8i_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8i_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8i_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu15i(Test_aBFu8i_B_BFu15i, "aBFu8i_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu15ll()
{
  {
    init_simple_test("aBFu8i_B_BFu15ll");
    static aBFu8i_B_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8i_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8i_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu15ll(Test_aBFu8i_B_BFu15ll, "aBFu8i_B_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu15s()
{
  {
    init_simple_test("aBFu8i_B_BFu15s");
    static aBFu8i_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8i_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8i_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu15s(Test_aBFu8i_B_BFu15s, "aBFu8i_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu16i()
{
  {
    init_simple_test("aBFu8i_B_BFu16i");
    static aBFu8i_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8i_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8i_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu16i(Test_aBFu8i_B_BFu16i, "aBFu8i_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu16ll()
{
  {
    init_simple_test("aBFu8i_B_BFu16ll");
    static aBFu8i_B_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8i_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8i_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu16ll(Test_aBFu8i_B_BFu16ll, "aBFu8i_B_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu16s()
{
  {
    init_simple_test("aBFu8i_B_BFu16s");
    static aBFu8i_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8i_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8i_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu16s(Test_aBFu8i_B_BFu16s, "aBFu8i_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu17i()
{
  {
    init_simple_test("aBFu8i_B_BFu17i");
    static aBFu8i_B_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8i_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu8i_B_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu8i_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu17i(Test_aBFu8i_B_BFu17i, "aBFu8i_B_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu17ll()
{
  {
    init_simple_test("aBFu8i_B_BFu17ll");
    static aBFu8i_B_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8i_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu8i_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu8i_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu17ll(Test_aBFu8i_B_BFu17ll, "aBFu8i_B_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu1c()
{
  {
    init_simple_test("aBFu8i_B_BFu1c");
    static aBFu8i_B_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8i_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu1c(Test_aBFu8i_B_BFu1c, "aBFu8i_B_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu1i()
{
  {
    init_simple_test("aBFu8i_B_BFu1i");
    static aBFu8i_B_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8i_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu1i(Test_aBFu8i_B_BFu1i, "aBFu8i_B_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu1ll()
{
  {
    init_simple_test("aBFu8i_B_BFu1ll");
    static aBFu8i_B_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8i_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu1ll(Test_aBFu8i_B_BFu1ll, "aBFu8i_B_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu1s()
{
  {
    init_simple_test("aBFu8i_B_BFu1s");
    static aBFu8i_B_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8i_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu1s(Test_aBFu8i_B_BFu1s, "aBFu8i_B_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu31i()
{
  {
    init_simple_test("aBFu8i_B_BFu31i");
    static aBFu8i_B_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu8i_B_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu8i_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu31i(Test_aBFu8i_B_BFu31i, "aBFu8i_B_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu31ll()
{
  {
    init_simple_test("aBFu8i_B_BFu31ll");
    static aBFu8i_B_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu8i_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu8i_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu31ll(Test_aBFu8i_B_BFu31ll, "aBFu8i_B_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu32i()
{
  {
    init_simple_test("aBFu8i_B_BFu32i");
    static aBFu8i_B_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu8i_B_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu8i_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu32i(Test_aBFu8i_B_BFu32i, "aBFu8i_B_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu32ll()
{
  {
    init_simple_test("aBFu8i_B_BFu32ll");
    static aBFu8i_B_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu8i_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu8i_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu32ll(Test_aBFu8i_B_BFu32ll, "aBFu8i_B_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu33()
{
  {
    init_simple_test("aBFu8i_B_BFu33");
    static aBFu8i_B_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8i_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu8i_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu8i_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu33(Test_aBFu8i_B_BFu33, "aBFu8i_B_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu7c()
{
  {
    init_simple_test("aBFu8i_B_BFu7c");
    static aBFu8i_B_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8i_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8i_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu7c(Test_aBFu8i_B_BFu7c, "aBFu8i_B_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu7i()
{
  {
    init_simple_test("aBFu8i_B_BFu7i");
    static aBFu8i_B_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8i_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8i_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu7i(Test_aBFu8i_B_BFu7i, "aBFu8i_B_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu7ll()
{
  {
    init_simple_test("aBFu8i_B_BFu7ll");
    static aBFu8i_B_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8i_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8i_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu7ll(Test_aBFu8i_B_BFu7ll, "aBFu8i_B_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu7s()
{
  {
    init_simple_test("aBFu8i_B_BFu7s");
    static aBFu8i_B_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8i_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8i_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu7s(Test_aBFu8i_B_BFu7s, "aBFu8i_B_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu8c()
{
  {
    init_simple_test("aBFu8i_B_BFu8c");
    static aBFu8i_B_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8i_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu8c(Test_aBFu8i_B_BFu8c, "aBFu8i_B_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu8i()
{
  {
    init_simple_test("aBFu8i_B_BFu8i");
    static aBFu8i_B_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8i_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu8i(Test_aBFu8i_B_BFu8i, "aBFu8i_B_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu8ll()
{
  {
    init_simple_test("aBFu8i_B_BFu8ll");
    static aBFu8i_B_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8i_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu8ll(Test_aBFu8i_B_BFu8ll, "aBFu8i_B_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu8s()
{
  {
    init_simple_test("aBFu8i_B_BFu8s");
    static aBFu8i_B_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8i_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu8s(Test_aBFu8i_B_BFu8s, "aBFu8i_B_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu9i()
{
  {
    init_simple_test("aBFu8i_B_BFu9i");
    static aBFu8i_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8i_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8i_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu9i(Test_aBFu8i_B_BFu9i, "aBFu8i_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu9ll()
{
  {
    init_simple_test("aBFu8i_B_BFu9ll");
    static aBFu8i_B_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8i_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8i_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu9ll(Test_aBFu8i_B_BFu9ll, "aBFu8i_B_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_BFu9s()
{
  {
    init_simple_test("aBFu8i_B_BFu9s");
    static aBFu8i_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8i_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8i_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8i_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_BFu9s(Test_aBFu8i_B_BFu9s, "aBFu8i_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_C()
{
  {
    init_simple_test("aBFu8i_B_C");
    static aBFu8i_B_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_C");
    check_field_offset(lv, v2, 1, "aBFu8i_B_C.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_B_C.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_C(Test_aBFu8i_B_C, "aBFu8i_B_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_D()
{
  {
    init_simple_test("aBFu8i_B_D");
    static aBFu8i_B_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8i_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_D");
    check_field_offset(lv, v2, 1, "aBFu8i_B_D.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_B_D.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_D(Test_aBFu8i_B_D, "aBFu8i_B_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_F()
{
  {
    init_simple_test("aBFu8i_B_F");
    static aBFu8i_B_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_F");
    check_field_offset(lv, v2, 1, "aBFu8i_B_F.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_B_F.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_F(Test_aBFu8i_B_F, "aBFu8i_B_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_I()
{
  {
    init_simple_test("aBFu8i_B_I");
    static aBFu8i_B_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_I");
    check_field_offset(lv, v2, 1, "aBFu8i_B_I.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_B_I.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_I(Test_aBFu8i_B_I, "aBFu8i_B_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_Ip()
{
  {
    init_simple_test("aBFu8i_B_Ip");
    static aBFu8i_B_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8i_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_Ip");
    check_field_offset(lv, v2, 1, "aBFu8i_B_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_Ip(Test_aBFu8i_B_Ip, "aBFu8i_B_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_L()
{
  {
    init_simple_test("aBFu8i_B_L");
    static aBFu8i_B_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8i_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_L");
    check_field_offset(lv, v2, 1, "aBFu8i_B_L.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_B_L.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_L(Test_aBFu8i_B_L, "aBFu8i_B_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_S()
{
  {
    init_simple_test("aBFu8i_B_S");
    static aBFu8i_B_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_S");
    check_field_offset(lv, v2, 1, "aBFu8i_B_S.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_B_S.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_S(Test_aBFu8i_B_S, "aBFu8i_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_Uc()
{
  {
    init_simple_test("aBFu8i_B_Uc");
    static aBFu8i_B_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_Uc");
    check_field_offset(lv, v2, 1, "aBFu8i_B_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_Uc(Test_aBFu8i_B_Uc, "aBFu8i_B_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_Ui()
{
  {
    init_simple_test("aBFu8i_B_Ui");
    static aBFu8i_B_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_Ui");
    check_field_offset(lv, v2, 1, "aBFu8i_B_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_Ui(Test_aBFu8i_B_Ui, "aBFu8i_B_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_Ul()
{
  {
    init_simple_test("aBFu8i_B_Ul");
    static aBFu8i_B_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8i_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_Ul");
    check_field_offset(lv, v2, 1, "aBFu8i_B_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_Ul(Test_aBFu8i_B_Ul, "aBFu8i_B_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_Us()
{
  {
    init_simple_test("aBFu8i_B_Us");
    static aBFu8i_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_Us");
    check_field_offset(lv, v2, 1, "aBFu8i_B_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_B_Us.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_Us(Test_aBFu8i_B_Us, "aBFu8i_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_B_Vp()
{
  {
    init_simple_test("aBFu8i_B_Vp");
    static aBFu8i_B_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8i_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_B_Vp");
    check_field_offset(lv, v2, 1, "aBFu8i_B_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_B_Vp(Test_aBFu8i_B_Vp, "aBFu8i_B_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu15i_B()
{
  {
    init_simple_test("aBFu8i_BFu15i_B");
    static aBFu8i_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8i_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8i_BFu15i_B");
    check_field_offset(lv, v3, 3, "aBFu8i_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu15i_B(Test_aBFu8i_BFu15i_B, "aBFu8i_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu15ll_B()
{
  {
    init_simple_test("aBFu8i_BFu15ll_B");
    static aBFu8i_BFu15ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8i_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8i_BFu15ll_B");
    check_field_offset(lv, v3, 3, "aBFu8i_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu15ll_B(Test_aBFu8i_BFu15ll_B, "aBFu8i_BFu15ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu15s_B()
{
  {
    init_simple_test("aBFu8i_BFu15s_B");
    static aBFu8i_BFu15s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8i_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8i_BFu15s_B");
    check_field_offset(lv, v3, 3, "aBFu8i_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu15s_B(Test_aBFu8i_BFu15s_B, "aBFu8i_BFu15s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu16i_B()
{
  {
    init_simple_test("aBFu8i_BFu16i_B");
    static aBFu8i_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu8i_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu8i_BFu16i_B");
    check_field_offset(lv, v3, 3, "aBFu8i_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu16i_B(Test_aBFu8i_BFu16i_B, "aBFu8i_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu16ll_B()
{
  {
    init_simple_test("aBFu8i_BFu16ll_B");
    static aBFu8i_BFu16ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu8i_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu8i_BFu16ll_B");
    check_field_offset(lv, v3, 3, "aBFu8i_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu16ll_B(Test_aBFu8i_BFu16ll_B, "aBFu8i_BFu16ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu16s_B()
{
  {
    init_simple_test("aBFu8i_BFu16s_B");
    static aBFu8i_BFu16s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu8i_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu8i_BFu16s_B");
    check_field_offset(lv, v3, 3, "aBFu8i_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu16s_B(Test_aBFu8i_BFu16s_B, "aBFu8i_BFu16s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu17i_B()
{
  {
    init_simple_test("aBFu8i_BFu17i_B");
    static aBFu8i_BFu17i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8i_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu8i_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu8i_BFu17i_B");
    check_field_offset(lv, v3, 4, "aBFu8i_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu17i_B(Test_aBFu8i_BFu17i_B, "aBFu8i_BFu17i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu17ll_B()
{
  {
    init_simple_test("aBFu8i_BFu17ll_B");
    static aBFu8i_BFu17ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8i_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu8i_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu8i_BFu17ll_B");
    check_field_offset(lv, v3, 4, "aBFu8i_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu17ll_B(Test_aBFu8i_BFu17ll_B, "aBFu8i_BFu17ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu1c_B()
{
  {
    init_simple_test("aBFu8i_BFu1c_B");
    static aBFu8i_BFu1c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8i_BFu1c_B");
    check_field_offset(lv, v3, 2, "aBFu8i_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu1c_B(Test_aBFu8i_BFu1c_B, "aBFu8i_BFu1c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu1i_B()
{
  {
    init_simple_test("aBFu8i_BFu1i_B");
    static aBFu8i_BFu1i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8i_BFu1i_B");
    check_field_offset(lv, v3, 2, "aBFu8i_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu1i_B(Test_aBFu8i_BFu1i_B, "aBFu8i_BFu1i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu1ll_B()
{
  {
    init_simple_test("aBFu8i_BFu1ll_B");
    static aBFu8i_BFu1ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8i_BFu1ll_B");
    check_field_offset(lv, v3, 2, "aBFu8i_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu1ll_B(Test_aBFu8i_BFu1ll_B, "aBFu8i_BFu1ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu1s_B()
{
  {
    init_simple_test("aBFu8i_BFu1s_B");
    static aBFu8i_BFu1s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8i_BFu1s_B");
    check_field_offset(lv, v3, 2, "aBFu8i_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu1s_B(Test_aBFu8i_BFu1s_B, "aBFu8i_BFu1s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu31i_B()
{
  {
    init_simple_test("aBFu8i_BFu31i_B");
    static aBFu8i_BFu31i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu8i_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu8i_BFu31i_B");
    check_field_offset(lv, v3, 5, "aBFu8i_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu31i_B(Test_aBFu8i_BFu31i_B, "aBFu8i_BFu31i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu31ll_B()
{
  {
    init_simple_test("aBFu8i_BFu31ll_B");
    static aBFu8i_BFu31ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu8i_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu8i_BFu31ll_B");
    check_field_offset(lv, v3, 5, "aBFu8i_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu31ll_B(Test_aBFu8i_BFu31ll_B, "aBFu8i_BFu31ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu32i_B()
{
  {
    init_simple_test("aBFu8i_BFu32i_B");
    static aBFu8i_BFu32i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu8i_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu8i_BFu32i_B");
    check_field_offset(lv, v3, 5, "aBFu8i_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu32i_B(Test_aBFu8i_BFu32i_B, "aBFu8i_BFu32i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu32ll_B()
{
  {
    init_simple_test("aBFu8i_BFu32ll_B");
    static aBFu8i_BFu32ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu8i_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu8i_BFu32ll_B");
    check_field_offset(lv, v3, 5, "aBFu8i_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu32ll_B(Test_aBFu8i_BFu32ll_B, "aBFu8i_BFu32ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu33_B()
{
  {
    init_simple_test("aBFu8i_BFu33_B");
    static aBFu8i_BFu33_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8i_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aBFu8i_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aBFu8i_BFu33_B");
    check_field_offset(lv, v3, 6, "aBFu8i_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu33_B(Test_aBFu8i_BFu33_B, "aBFu8i_BFu33_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu7c_B()
{
  {
    init_simple_test("aBFu8i_BFu7c_B");
    static aBFu8i_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8i_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8i_BFu7c_B");
    check_field_offset(lv, v3, 2, "aBFu8i_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu7c_B(Test_aBFu8i_BFu7c_B, "aBFu8i_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu7i_B()
{
  {
    init_simple_test("aBFu8i_BFu7i_B");
    static aBFu8i_BFu7i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8i_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8i_BFu7i_B");
    check_field_offset(lv, v3, 2, "aBFu8i_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu7i_B(Test_aBFu8i_BFu7i_B, "aBFu8i_BFu7i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu7ll_B()
{
  {
    init_simple_test("aBFu8i_BFu7ll_B");
    static aBFu8i_BFu7ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8i_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8i_BFu7ll_B");
    check_field_offset(lv, v3, 2, "aBFu8i_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu7ll_B(Test_aBFu8i_BFu7ll_B, "aBFu8i_BFu7ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu7s_B()
{
  {
    init_simple_test("aBFu8i_BFu7s_B");
    static aBFu8i_BFu7s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8i_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8i_BFu7s_B");
    check_field_offset(lv, v3, 2, "aBFu8i_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu7s_B(Test_aBFu8i_BFu7s_B, "aBFu8i_BFu7s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu8c_B()
{
  {
    init_simple_test("aBFu8i_BFu8c_B");
    static aBFu8i_BFu8c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8i_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu8c_B");
    check_field_offset(lv, v3, 2, "aBFu8i_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu8c_B(Test_aBFu8i_BFu8c_B, "aBFu8i_BFu8c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu8i_B()
{
  {
    init_simple_test("aBFu8i_BFu8i_B");
    static aBFu8i_BFu8i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8i_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu8i_B");
    check_field_offset(lv, v3, 2, "aBFu8i_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu8i_B(Test_aBFu8i_BFu8i_B, "aBFu8i_BFu8i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu8ll_B()
{
  {
    init_simple_test("aBFu8i_BFu8ll_B");
    static aBFu8i_BFu8ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8i_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu8ll_B");
    check_field_offset(lv, v3, 2, "aBFu8i_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu8ll_B(Test_aBFu8i_BFu8ll_B, "aBFu8i_BFu8ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu8s_B()
{
  {
    init_simple_test("aBFu8i_BFu8s_B");
    static aBFu8i_BFu8s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8i_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu8s_B");
    check_field_offset(lv, v3, 2, "aBFu8i_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu8s_B(Test_aBFu8i_BFu8s_B, "aBFu8i_BFu8s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu9i_B()
{
  {
    init_simple_test("aBFu8i_BFu9i_B");
    static aBFu8i_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu8i_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu8i_BFu9i_B");
    check_field_offset(lv, v3, 3, "aBFu8i_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu9i_B(Test_aBFu8i_BFu9i_B, "aBFu8i_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu9ll_B()
{
  {
    init_simple_test("aBFu8i_BFu9ll_B");
    static aBFu8i_BFu9ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu8i_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu8i_BFu9ll_B");
    check_field_offset(lv, v3, 3, "aBFu8i_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu9ll_B(Test_aBFu8i_BFu9ll_B, "aBFu8i_BFu9ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_BFu9s_B()
{
  {
    init_simple_test("aBFu8i_BFu9s_B");
    static aBFu8i_BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu8i_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu8i_BFu9s_B");
    check_field_offset(lv, v3, 3, "aBFu8i_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_BFu9s_B(Test_aBFu8i_BFu9s_B, "aBFu8i_BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_C_B()
{
  {
    init_simple_test("aBFu8i_C_B");
    static aBFu8i_C_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_C_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_C_B");
    check_field_offset(lv, v2, 1, "aBFu8i_C_B.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_C_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_C_B(Test_aBFu8i_C_B, "aBFu8i_C_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_D_B()
{
  {
    init_simple_test("aBFu8i_D_B");
    static aBFu8i_D_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8i_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_D_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_D_B");
    check_field_offset(lv, v2, 1, "aBFu8i_D_B.v2");
    check_field_offset(lv, v3, 9, "aBFu8i_D_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_D_B(Test_aBFu8i_D_B, "aBFu8i_D_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_F_B()
{
  {
    init_simple_test("aBFu8i_F_B");
    static aBFu8i_F_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_F_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_F_B");
    check_field_offset(lv, v2, 1, "aBFu8i_F_B.v2");
    check_field_offset(lv, v3, 5, "aBFu8i_F_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_F_B(Test_aBFu8i_F_B, "aBFu8i_F_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_I_B()
{
  {
    init_simple_test("aBFu8i_I_B");
    static aBFu8i_I_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_I_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_I_B");
    check_field_offset(lv, v2, 1, "aBFu8i_I_B.v2");
    check_field_offset(lv, v3, 5, "aBFu8i_I_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_I_B(Test_aBFu8i_I_B, "aBFu8i_I_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_Ip_B()
{
  {
    init_simple_test("aBFu8i_Ip_B");
    static aBFu8i_Ip_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8i_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_Ip_B");
    check_field_offset(lv, v2, 1, "aBFu8i_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8i_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_Ip_B(Test_aBFu8i_Ip_B, "aBFu8i_Ip_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_L_B()
{
  {
    init_simple_test("aBFu8i_L_B");
    static aBFu8i_L_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8i_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_L_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_L_B");
    check_field_offset(lv, v2, 1, "aBFu8i_L_B.v2");
    check_field_offset(lv, v3, 9, "aBFu8i_L_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_L_B(Test_aBFu8i_L_B, "aBFu8i_L_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_S_B()
{
  {
    init_simple_test("aBFu8i_S_B");
    static aBFu8i_S_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_S_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_S_B");
    check_field_offset(lv, v2, 1, "aBFu8i_S_B.v2");
    check_field_offset(lv, v3, 3, "aBFu8i_S_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_S_B(Test_aBFu8i_S_B, "aBFu8i_S_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_Uc_B()
{
  {
    init_simple_test("aBFu8i_Uc_B");
    static aBFu8i_Uc_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8i_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_Uc_B");
    check_field_offset(lv, v2, 1, "aBFu8i_Uc_B.v2");
    check_field_offset(lv, v3, 2, "aBFu8i_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_Uc_B(Test_aBFu8i_Uc_B, "aBFu8i_Uc_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_Ui_B()
{
  {
    init_simple_test("aBFu8i_Ui_B");
    static aBFu8i_Ui_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8i_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_Ui_B");
    check_field_offset(lv, v2, 1, "aBFu8i_Ui_B.v2");
    check_field_offset(lv, v3, 5, "aBFu8i_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_Ui_B(Test_aBFu8i_Ui_B, "aBFu8i_Ui_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_Ul_B()
{
  {
    init_simple_test("aBFu8i_Ul_B");
    static aBFu8i_Ul_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8i_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_Ul_B");
    check_field_offset(lv, v2, 1, "aBFu8i_Ul_B.v2");
    check_field_offset(lv, v3, 9, "aBFu8i_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_Ul_B(Test_aBFu8i_Ul_B, "aBFu8i_Ul_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_Us_B()
{
  {
    init_simple_test("aBFu8i_Us_B");
    static aBFu8i_Us_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8i_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_Us_B");
    check_field_offset(lv, v2, 1, "aBFu8i_Us_B.v2");
    check_field_offset(lv, v3, 3, "aBFu8i_Us_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_Us_B(Test_aBFu8i_Us_B, "aBFu8i_Us_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8i_Vp_B()
{
  {
    init_simple_test("aBFu8i_Vp_B");
    static aBFu8i_Vp_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8i_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_Vp_B");
    check_field_offset(lv, v2, 1, "aBFu8i_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8i_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8i_Vp_B(Test_aBFu8i_Vp_B, "aBFu8i_Vp_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B()
{
  {
    init_simple_test("aBFu8ll_B");
    static aBFu8ll_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B(Test_aBFu8ll_B, "aBFu8ll_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_B()
{
  {
    init_simple_test("aBFu8ll_B_B");
    static aBFu8ll_B_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_B.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_B_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_B(Test_aBFu8ll_B_B, "aBFu8ll_B_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu15i()
{
  {
    init_simple_test("aBFu8ll_B_BFu15i");
    static aBFu8ll_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8ll_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8ll_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu15i(Test_aBFu8ll_B_BFu15i, "aBFu8ll_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu15ll()
{
  {
    init_simple_test("aBFu8ll_B_BFu15ll");
    static aBFu8ll_B_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8ll_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8ll_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu15ll(Test_aBFu8ll_B_BFu15ll, "aBFu8ll_B_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu15s()
{
  {
    init_simple_test("aBFu8ll_B_BFu15s");
    static aBFu8ll_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8ll_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8ll_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu15s(Test_aBFu8ll_B_BFu15s, "aBFu8ll_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu16i()
{
  {
    init_simple_test("aBFu8ll_B_BFu16i");
    static aBFu8ll_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8ll_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8ll_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu16i(Test_aBFu8ll_B_BFu16i, "aBFu8ll_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu16ll()
{
  {
    init_simple_test("aBFu8ll_B_BFu16ll");
    static aBFu8ll_B_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8ll_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8ll_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu16ll(Test_aBFu8ll_B_BFu16ll, "aBFu8ll_B_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu16s()
{
  {
    init_simple_test("aBFu8ll_B_BFu16s");
    static aBFu8ll_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8ll_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8ll_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu16s(Test_aBFu8ll_B_BFu16s, "aBFu8ll_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu17i()
{
  {
    init_simple_test("aBFu8ll_B_BFu17i");
    static aBFu8ll_B_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu8ll_B_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu8ll_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu17i(Test_aBFu8ll_B_BFu17i, "aBFu8ll_B_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu17ll()
{
  {
    init_simple_test("aBFu8ll_B_BFu17ll");
    static aBFu8ll_B_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu8ll_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu8ll_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu17ll(Test_aBFu8ll_B_BFu17ll, "aBFu8ll_B_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu1c()
{
  {
    init_simple_test("aBFu8ll_B_BFu1c");
    static aBFu8ll_B_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8ll_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu1c(Test_aBFu8ll_B_BFu1c, "aBFu8ll_B_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu1i()
{
  {
    init_simple_test("aBFu8ll_B_BFu1i");
    static aBFu8ll_B_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8ll_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu1i(Test_aBFu8ll_B_BFu1i, "aBFu8ll_B_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu1ll()
{
  {
    init_simple_test("aBFu8ll_B_BFu1ll");
    static aBFu8ll_B_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8ll_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu1ll(Test_aBFu8ll_B_BFu1ll, "aBFu8ll_B_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu1s()
{
  {
    init_simple_test("aBFu8ll_B_BFu1s");
    static aBFu8ll_B_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8ll_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu1s(Test_aBFu8ll_B_BFu1s, "aBFu8ll_B_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu31i()
{
  {
    init_simple_test("aBFu8ll_B_BFu31i");
    static aBFu8ll_B_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu8ll_B_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu8ll_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu31i(Test_aBFu8ll_B_BFu31i, "aBFu8ll_B_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu31ll()
{
  {
    init_simple_test("aBFu8ll_B_BFu31ll");
    static aBFu8ll_B_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu8ll_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu8ll_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu31ll(Test_aBFu8ll_B_BFu31ll, "aBFu8ll_B_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu32i()
{
  {
    init_simple_test("aBFu8ll_B_BFu32i");
    static aBFu8ll_B_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu8ll_B_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu8ll_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu32i(Test_aBFu8ll_B_BFu32i, "aBFu8ll_B_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu32ll()
{
  {
    init_simple_test("aBFu8ll_B_BFu32ll");
    static aBFu8ll_B_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu8ll_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu8ll_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu32ll(Test_aBFu8ll_B_BFu32ll, "aBFu8ll_B_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu33()
{
  {
    init_simple_test("aBFu8ll_B_BFu33");
    static aBFu8ll_B_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu8ll_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu8ll_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu33(Test_aBFu8ll_B_BFu33, "aBFu8ll_B_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu7c()
{
  {
    init_simple_test("aBFu8ll_B_BFu7c");
    static aBFu8ll_B_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8ll_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8ll_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu7c(Test_aBFu8ll_B_BFu7c, "aBFu8ll_B_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu7i()
{
  {
    init_simple_test("aBFu8ll_B_BFu7i");
    static aBFu8ll_B_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8ll_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8ll_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu7i(Test_aBFu8ll_B_BFu7i, "aBFu8ll_B_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu7ll()
{
  {
    init_simple_test("aBFu8ll_B_BFu7ll");
    static aBFu8ll_B_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8ll_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8ll_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu7ll(Test_aBFu8ll_B_BFu7ll, "aBFu8ll_B_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu7s()
{
  {
    init_simple_test("aBFu8ll_B_BFu7s");
    static aBFu8ll_B_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8ll_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8ll_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu7s(Test_aBFu8ll_B_BFu7s, "aBFu8ll_B_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu8c()
{
  {
    init_simple_test("aBFu8ll_B_BFu8c");
    static aBFu8ll_B_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8ll_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu8c(Test_aBFu8ll_B_BFu8c, "aBFu8ll_B_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu8i()
{
  {
    init_simple_test("aBFu8ll_B_BFu8i");
    static aBFu8ll_B_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8ll_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu8i(Test_aBFu8ll_B_BFu8i, "aBFu8ll_B_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu8ll()
{
  {
    init_simple_test("aBFu8ll_B_BFu8ll");
    static aBFu8ll_B_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8ll_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu8ll(Test_aBFu8ll_B_BFu8ll, "aBFu8ll_B_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu8s()
{
  {
    init_simple_test("aBFu8ll_B_BFu8s");
    static aBFu8ll_B_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8ll_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu8s(Test_aBFu8ll_B_BFu8s, "aBFu8ll_B_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu9i()
{
  {
    init_simple_test("aBFu8ll_B_BFu9i");
    static aBFu8ll_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8ll_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8ll_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu9i(Test_aBFu8ll_B_BFu9i, "aBFu8ll_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu9ll()
{
  {
    init_simple_test("aBFu8ll_B_BFu9ll");
    static aBFu8ll_B_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8ll_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8ll_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu9ll(Test_aBFu8ll_B_BFu9ll, "aBFu8ll_B_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_BFu9s()
{
  {
    init_simple_test("aBFu8ll_B_BFu9s");
    static aBFu8ll_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8ll_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8ll_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_BFu9s(Test_aBFu8ll_B_BFu9s, "aBFu8ll_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_C()
{
  {
    init_simple_test("aBFu8ll_B_C");
    static aBFu8ll_B_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_C");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_C.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_B_C.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_C(Test_aBFu8ll_B_C, "aBFu8ll_B_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_D()
{
  {
    init_simple_test("aBFu8ll_B_D");
    static aBFu8ll_B_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_D");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_D.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_B_D.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_D(Test_aBFu8ll_B_D, "aBFu8ll_B_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_F()
{
  {
    init_simple_test("aBFu8ll_B_F");
    static aBFu8ll_B_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_F");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_F.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_B_F.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_F(Test_aBFu8ll_B_F, "aBFu8ll_B_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_I()
{
  {
    init_simple_test("aBFu8ll_B_I");
    static aBFu8ll_B_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_I");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_I.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_B_I.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_I(Test_aBFu8ll_B_I, "aBFu8ll_B_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_Ip()
{
  {
    init_simple_test("aBFu8ll_B_Ip");
    static aBFu8ll_B_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_Ip");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_Ip(Test_aBFu8ll_B_Ip, "aBFu8ll_B_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_L()
{
  {
    init_simple_test("aBFu8ll_B_L");
    static aBFu8ll_B_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_L");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_L.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_B_L.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_L(Test_aBFu8ll_B_L, "aBFu8ll_B_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_S()
{
  {
    init_simple_test("aBFu8ll_B_S");
    static aBFu8ll_B_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_S");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_S.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_B_S.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_S(Test_aBFu8ll_B_S, "aBFu8ll_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_Uc()
{
  {
    init_simple_test("aBFu8ll_B_Uc");
    static aBFu8ll_B_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_Uc");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_Uc(Test_aBFu8ll_B_Uc, "aBFu8ll_B_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_Ui()
{
  {
    init_simple_test("aBFu8ll_B_Ui");
    static aBFu8ll_B_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_Ui");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_Ui(Test_aBFu8ll_B_Ui, "aBFu8ll_B_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_Ul()
{
  {
    init_simple_test("aBFu8ll_B_Ul");
    static aBFu8ll_B_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_Ul");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_Ul(Test_aBFu8ll_B_Ul, "aBFu8ll_B_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_Us()
{
  {
    init_simple_test("aBFu8ll_B_Us");
    static aBFu8ll_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_Us");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_B_Us.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_Us(Test_aBFu8ll_B_Us, "aBFu8ll_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_B_Vp()
{
  {
    init_simple_test("aBFu8ll_B_Vp");
    static aBFu8ll_B_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_B_Vp");
    check_field_offset(lv, v2, 1, "aBFu8ll_B_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_B_Vp(Test_aBFu8ll_B_Vp, "aBFu8ll_B_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu15i_B()
{
  {
    init_simple_test("aBFu8ll_BFu15i_B");
    static aBFu8ll_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8ll_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8ll_BFu15i_B");
    check_field_offset(lv, v3, 3, "aBFu8ll_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu15i_B(Test_aBFu8ll_BFu15i_B, "aBFu8ll_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu15ll_B()
{
  {
    init_simple_test("aBFu8ll_BFu15ll_B");
    static aBFu8ll_BFu15ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8ll_BFu15ll_B");
    check_field_offset(lv, v3, 3, "aBFu8ll_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu15ll_B(Test_aBFu8ll_BFu15ll_B, "aBFu8ll_BFu15ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu15s_B()
{
  {
    init_simple_test("aBFu8ll_BFu15s_B");
    static aBFu8ll_BFu15s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8ll_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8ll_BFu15s_B");
    check_field_offset(lv, v3, 3, "aBFu8ll_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu15s_B(Test_aBFu8ll_BFu15s_B, "aBFu8ll_BFu15s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu16i_B()
{
  {
    init_simple_test("aBFu8ll_BFu16i_B");
    static aBFu8ll_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu8ll_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu8ll_BFu16i_B");
    check_field_offset(lv, v3, 3, "aBFu8ll_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu16i_B(Test_aBFu8ll_BFu16i_B, "aBFu8ll_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu16ll_B()
{
  {
    init_simple_test("aBFu8ll_BFu16ll_B");
    static aBFu8ll_BFu16ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu8ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu8ll_BFu16ll_B");
    check_field_offset(lv, v3, 3, "aBFu8ll_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu16ll_B(Test_aBFu8ll_BFu16ll_B, "aBFu8ll_BFu16ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu16s_B()
{
  {
    init_simple_test("aBFu8ll_BFu16s_B");
    static aBFu8ll_BFu16s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu8ll_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu8ll_BFu16s_B");
    check_field_offset(lv, v3, 3, "aBFu8ll_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu16s_B(Test_aBFu8ll_BFu16s_B, "aBFu8ll_BFu16s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu17i_B()
{
  {
    init_simple_test("aBFu8ll_BFu17i_B");
    static aBFu8ll_BFu17i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu8ll_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu8ll_BFu17i_B");
    check_field_offset(lv, v3, 4, "aBFu8ll_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu17i_B(Test_aBFu8ll_BFu17i_B, "aBFu8ll_BFu17i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu17ll_B()
{
  {
    init_simple_test("aBFu8ll_BFu17ll_B");
    static aBFu8ll_BFu17ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu8ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu8ll_BFu17ll_B");
    check_field_offset(lv, v3, 4, "aBFu8ll_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu17ll_B(Test_aBFu8ll_BFu17ll_B, "aBFu8ll_BFu17ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu1c_B()
{
  {
    init_simple_test("aBFu8ll_BFu1c_B");
    static aBFu8ll_BFu1c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8ll_BFu1c_B");
    check_field_offset(lv, v3, 2, "aBFu8ll_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu1c_B(Test_aBFu8ll_BFu1c_B, "aBFu8ll_BFu1c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu1i_B()
{
  {
    init_simple_test("aBFu8ll_BFu1i_B");
    static aBFu8ll_BFu1i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8ll_BFu1i_B");
    check_field_offset(lv, v3, 2, "aBFu8ll_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu1i_B(Test_aBFu8ll_BFu1i_B, "aBFu8ll_BFu1i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu1ll_B()
{
  {
    init_simple_test("aBFu8ll_BFu1ll_B");
    static aBFu8ll_BFu1ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8ll_BFu1ll_B");
    check_field_offset(lv, v3, 2, "aBFu8ll_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu1ll_B(Test_aBFu8ll_BFu1ll_B, "aBFu8ll_BFu1ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu1s_B()
{
  {
    init_simple_test("aBFu8ll_BFu1s_B");
    static aBFu8ll_BFu1s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8ll_BFu1s_B");
    check_field_offset(lv, v3, 2, "aBFu8ll_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu1s_B(Test_aBFu8ll_BFu1s_B, "aBFu8ll_BFu1s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu31i_B()
{
  {
    init_simple_test("aBFu8ll_BFu31i_B");
    static aBFu8ll_BFu31i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu8ll_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu8ll_BFu31i_B");
    check_field_offset(lv, v3, 5, "aBFu8ll_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu31i_B(Test_aBFu8ll_BFu31i_B, "aBFu8ll_BFu31i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu31ll_B()
{
  {
    init_simple_test("aBFu8ll_BFu31ll_B");
    static aBFu8ll_BFu31ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu8ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu8ll_BFu31ll_B");
    check_field_offset(lv, v3, 5, "aBFu8ll_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu31ll_B(Test_aBFu8ll_BFu31ll_B, "aBFu8ll_BFu31ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu32i_B()
{
  {
    init_simple_test("aBFu8ll_BFu32i_B");
    static aBFu8ll_BFu32i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu8ll_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu8ll_BFu32i_B");
    check_field_offset(lv, v3, 5, "aBFu8ll_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu32i_B(Test_aBFu8ll_BFu32i_B, "aBFu8ll_BFu32i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu32ll_B()
{
  {
    init_simple_test("aBFu8ll_BFu32ll_B");
    static aBFu8ll_BFu32ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu8ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu8ll_BFu32ll_B");
    check_field_offset(lv, v3, 5, "aBFu8ll_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu32ll_B(Test_aBFu8ll_BFu32ll_B, "aBFu8ll_BFu32ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu33_B()
{
  {
    init_simple_test("aBFu8ll_BFu33_B");
    static aBFu8ll_BFu33_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aBFu8ll_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aBFu8ll_BFu33_B");
    check_field_offset(lv, v3, 6, "aBFu8ll_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu33_B(Test_aBFu8ll_BFu33_B, "aBFu8ll_BFu33_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu7c_B()
{
  {
    init_simple_test("aBFu8ll_BFu7c_B");
    static aBFu8ll_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8ll_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8ll_BFu7c_B");
    check_field_offset(lv, v3, 2, "aBFu8ll_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu7c_B(Test_aBFu8ll_BFu7c_B, "aBFu8ll_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu7i_B()
{
  {
    init_simple_test("aBFu8ll_BFu7i_B");
    static aBFu8ll_BFu7i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8ll_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8ll_BFu7i_B");
    check_field_offset(lv, v3, 2, "aBFu8ll_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu7i_B(Test_aBFu8ll_BFu7i_B, "aBFu8ll_BFu7i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu7ll_B()
{
  {
    init_simple_test("aBFu8ll_BFu7ll_B");
    static aBFu8ll_BFu7ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8ll_BFu7ll_B");
    check_field_offset(lv, v3, 2, "aBFu8ll_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu7ll_B(Test_aBFu8ll_BFu7ll_B, "aBFu8ll_BFu7ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu7s_B()
{
  {
    init_simple_test("aBFu8ll_BFu7s_B");
    static aBFu8ll_BFu7s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8ll_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8ll_BFu7s_B");
    check_field_offset(lv, v3, 2, "aBFu8ll_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu7s_B(Test_aBFu8ll_BFu7s_B, "aBFu8ll_BFu7s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu8c_B()
{
  {
    init_simple_test("aBFu8ll_BFu8c_B");
    static aBFu8ll_BFu8c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8ll_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu8c_B");
    check_field_offset(lv, v3, 2, "aBFu8ll_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu8c_B(Test_aBFu8ll_BFu8c_B, "aBFu8ll_BFu8c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu8i_B()
{
  {
    init_simple_test("aBFu8ll_BFu8i_B");
    static aBFu8ll_BFu8i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8ll_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu8i_B");
    check_field_offset(lv, v3, 2, "aBFu8ll_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu8i_B(Test_aBFu8ll_BFu8i_B, "aBFu8ll_BFu8i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu8ll_B()
{
  {
    init_simple_test("aBFu8ll_BFu8ll_B");
    static aBFu8ll_BFu8ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu8ll_B");
    check_field_offset(lv, v3, 2, "aBFu8ll_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu8ll_B(Test_aBFu8ll_BFu8ll_B, "aBFu8ll_BFu8ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu8s_B()
{
  {
    init_simple_test("aBFu8ll_BFu8s_B");
    static aBFu8ll_BFu8s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8ll_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu8s_B");
    check_field_offset(lv, v3, 2, "aBFu8ll_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu8s_B(Test_aBFu8ll_BFu8s_B, "aBFu8ll_BFu8s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu9i_B()
{
  {
    init_simple_test("aBFu8ll_BFu9i_B");
    static aBFu8ll_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu8ll_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu8ll_BFu9i_B");
    check_field_offset(lv, v3, 3, "aBFu8ll_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu9i_B(Test_aBFu8ll_BFu9i_B, "aBFu8ll_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu9ll_B()
{
  {
    init_simple_test("aBFu8ll_BFu9ll_B");
    static aBFu8ll_BFu9ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu8ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu8ll_BFu9ll_B");
    check_field_offset(lv, v3, 3, "aBFu8ll_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu9ll_B(Test_aBFu8ll_BFu9ll_B, "aBFu8ll_BFu9ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_BFu9s_B()
{
  {
    init_simple_test("aBFu8ll_BFu9s_B");
    static aBFu8ll_BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu8ll_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu8ll_BFu9s_B");
    check_field_offset(lv, v3, 3, "aBFu8ll_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_BFu9s_B(Test_aBFu8ll_BFu9s_B, "aBFu8ll_BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_C_B()
{
  {
    init_simple_test("aBFu8ll_C_B");
    static aBFu8ll_C_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_C_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_C_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_C_B.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_C_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_C_B(Test_aBFu8ll_C_B, "aBFu8ll_C_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_D_B()
{
  {
    init_simple_test("aBFu8ll_D_B");
    static aBFu8ll_D_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_B.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_D_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_D_B(Test_aBFu8ll_D_B, "aBFu8ll_D_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_F_B()
{
  {
    init_simple_test("aBFu8ll_F_B");
    static aBFu8ll_F_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_B.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_F_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_F_B(Test_aBFu8ll_F_B, "aBFu8ll_F_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_I_B()
{
  {
    init_simple_test("aBFu8ll_I_B");
    static aBFu8ll_I_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_B.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_I_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_I_B(Test_aBFu8ll_I_B, "aBFu8ll_I_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_Ip_B()
{
  {
    init_simple_test("aBFu8ll_Ip_B");
    static aBFu8ll_Ip_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_Ip_B(Test_aBFu8ll_Ip_B, "aBFu8ll_Ip_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_L_B()
{
  {
    init_simple_test("aBFu8ll_L_B");
    static aBFu8ll_L_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_B.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_L_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_L_B(Test_aBFu8ll_L_B, "aBFu8ll_L_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_S_B()
{
  {
    init_simple_test("aBFu8ll_S_B");
    static aBFu8ll_S_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_B.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_S_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_S_B(Test_aBFu8ll_S_B, "aBFu8ll_S_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_Uc_B()
{
  {
    init_simple_test("aBFu8ll_Uc_B");
    static aBFu8ll_Uc_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_B.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_Uc_B(Test_aBFu8ll_Uc_B, "aBFu8ll_Uc_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_Ui_B()
{
  {
    init_simple_test("aBFu8ll_Ui_B");
    static aBFu8ll_Ui_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_B.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_Ui_B(Test_aBFu8ll_Ui_B, "aBFu8ll_Ui_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_Ul_B()
{
  {
    init_simple_test("aBFu8ll_Ul_B");
    static aBFu8ll_Ul_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_B.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_Ul_B(Test_aBFu8ll_Ul_B, "aBFu8ll_Ul_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_Us_B()
{
  {
    init_simple_test("aBFu8ll_Us_B");
    static aBFu8ll_Us_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_B.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_Us_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_Us_B(Test_aBFu8ll_Us_B, "aBFu8ll_Us_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8ll_Vp_B()
{
  {
    init_simple_test("aBFu8ll_Vp_B");
    static aBFu8ll_Vp_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_B");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8ll_Vp_B(Test_aBFu8ll_Vp_B, "aBFu8ll_Vp_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B()
{
  {
    init_simple_test("aBFu8s_B");
    static aBFu8s_B lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B");
    check_field_offset(lv, v2, 1, "aBFu8s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu8s_B(Test_aBFu8s_B, "aBFu8s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_B()
{
  {
    init_simple_test("aBFu8s_B_B");
    static aBFu8s_B_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_B");
    check_field_offset(lv, v2, 1, "aBFu8s_B_B.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_B_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_B(Test_aBFu8s_B_B, "aBFu8s_B_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu15i()
{
  {
    init_simple_test("aBFu8s_B_BFu15i");
    static aBFu8s_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8s_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8s_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu15i(Test_aBFu8s_B_BFu15i, "aBFu8s_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu15ll()
{
  {
    init_simple_test("aBFu8s_B_BFu15ll");
    static aBFu8s_B_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8s_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8s_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu15ll(Test_aBFu8s_B_BFu15ll, "aBFu8s_B_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu15s()
{
  {
    init_simple_test("aBFu8s_B_BFu15s");
    static aBFu8s_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8s_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8s_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu15s(Test_aBFu8s_B_BFu15s, "aBFu8s_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu16i()
{
  {
    init_simple_test("aBFu8s_B_BFu16i");
    static aBFu8s_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8s_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8s_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu16i(Test_aBFu8s_B_BFu16i, "aBFu8s_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu16ll()
{
  {
    init_simple_test("aBFu8s_B_BFu16ll");
    static aBFu8s_B_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8s_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8s_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu16ll(Test_aBFu8s_B_BFu16ll, "aBFu8s_B_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu16s()
{
  {
    init_simple_test("aBFu8s_B_BFu16s");
    static aBFu8s_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8s_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8s_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu16s(Test_aBFu8s_B_BFu16s, "aBFu8s_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu17i()
{
  {
    init_simple_test("aBFu8s_B_BFu17i");
    static aBFu8s_B_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8s_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu8s_B_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu8s_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu17i(Test_aBFu8s_B_BFu17i, "aBFu8s_B_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu17ll()
{
  {
    init_simple_test("aBFu8s_B_BFu17ll");
    static aBFu8s_B_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8s_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu8s_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu8s_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu17ll(Test_aBFu8s_B_BFu17ll, "aBFu8s_B_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu1c()
{
  {
    init_simple_test("aBFu8s_B_BFu1c");
    static aBFu8s_B_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8s_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu1c(Test_aBFu8s_B_BFu1c, "aBFu8s_B_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu1i()
{
  {
    init_simple_test("aBFu8s_B_BFu1i");
    static aBFu8s_B_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8s_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu1i(Test_aBFu8s_B_BFu1i, "aBFu8s_B_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu1ll()
{
  {
    init_simple_test("aBFu8s_B_BFu1ll");
    static aBFu8s_B_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8s_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu1ll(Test_aBFu8s_B_BFu1ll, "aBFu8s_B_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu1s()
{
  {
    init_simple_test("aBFu8s_B_BFu1s");
    static aBFu8s_B_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8s_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu1s(Test_aBFu8s_B_BFu1s, "aBFu8s_B_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu31i()
{
  {
    init_simple_test("aBFu8s_B_BFu31i");
    static aBFu8s_B_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu8s_B_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu8s_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu31i(Test_aBFu8s_B_BFu31i, "aBFu8s_B_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu31ll()
{
  {
    init_simple_test("aBFu8s_B_BFu31ll");
    static aBFu8s_B_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu8s_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu8s_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu31ll(Test_aBFu8s_B_BFu31ll, "aBFu8s_B_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu32i()
{
  {
    init_simple_test("aBFu8s_B_BFu32i");
    static aBFu8s_B_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu8s_B_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu8s_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu32i(Test_aBFu8s_B_BFu32i, "aBFu8s_B_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu32ll()
{
  {
    init_simple_test("aBFu8s_B_BFu32ll");
    static aBFu8s_B_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu8s_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu8s_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu32ll(Test_aBFu8s_B_BFu32ll, "aBFu8s_B_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu33()
{
  {
    init_simple_test("aBFu8s_B_BFu33");
    static aBFu8s_B_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8s_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu8s_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu8s_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu33(Test_aBFu8s_B_BFu33, "aBFu8s_B_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu7c()
{
  {
    init_simple_test("aBFu8s_B_BFu7c");
    static aBFu8s_B_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8s_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8s_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu7c(Test_aBFu8s_B_BFu7c, "aBFu8s_B_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu7i()
{
  {
    init_simple_test("aBFu8s_B_BFu7i");
    static aBFu8s_B_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8s_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8s_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu7i(Test_aBFu8s_B_BFu7i, "aBFu8s_B_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu7ll()
{
  {
    init_simple_test("aBFu8s_B_BFu7ll");
    static aBFu8s_B_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8s_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8s_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu7ll(Test_aBFu8s_B_BFu7ll, "aBFu8s_B_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu7s()
{
  {
    init_simple_test("aBFu8s_B_BFu7s");
    static aBFu8s_B_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8s_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8s_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu7s(Test_aBFu8s_B_BFu7s, "aBFu8s_B_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu8c()
{
  {
    init_simple_test("aBFu8s_B_BFu8c");
    static aBFu8s_B_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu8c(Test_aBFu8s_B_BFu8c, "aBFu8s_B_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu8i()
{
  {
    init_simple_test("aBFu8s_B_BFu8i");
    static aBFu8s_B_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu8i(Test_aBFu8s_B_BFu8i, "aBFu8s_B_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu8ll()
{
  {
    init_simple_test("aBFu8s_B_BFu8ll");
    static aBFu8s_B_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu8ll(Test_aBFu8s_B_BFu8ll, "aBFu8s_B_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu8s()
{
  {
    init_simple_test("aBFu8s_B_BFu8s");
    static aBFu8s_B_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu8s(Test_aBFu8s_B_BFu8s, "aBFu8s_B_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu9i()
{
  {
    init_simple_test("aBFu8s_B_BFu9i");
    static aBFu8s_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8s_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8s_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu9i(Test_aBFu8s_B_BFu9i, "aBFu8s_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu9ll()
{
  {
    init_simple_test("aBFu8s_B_BFu9ll");
    static aBFu8s_B_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8s_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8s_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu9ll(Test_aBFu8s_B_BFu9ll, "aBFu8s_B_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_BFu9s()
{
  {
    init_simple_test("aBFu8s_B_BFu9s");
    static aBFu8s_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8s_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8s_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8s_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_BFu9s(Test_aBFu8s_B_BFu9s, "aBFu8s_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_C()
{
  {
    init_simple_test("aBFu8s_B_C");
    static aBFu8s_B_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_C");
    check_field_offset(lv, v2, 1, "aBFu8s_B_C.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_B_C.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_C(Test_aBFu8s_B_C, "aBFu8s_B_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_D()
{
  {
    init_simple_test("aBFu8s_B_D");
    static aBFu8s_B_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8s_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_D");
    check_field_offset(lv, v2, 1, "aBFu8s_B_D.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_B_D.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_D(Test_aBFu8s_B_D, "aBFu8s_B_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_F()
{
  {
    init_simple_test("aBFu8s_B_F");
    static aBFu8s_B_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_F");
    check_field_offset(lv, v2, 1, "aBFu8s_B_F.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_B_F.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_F(Test_aBFu8s_B_F, "aBFu8s_B_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_I()
{
  {
    init_simple_test("aBFu8s_B_I");
    static aBFu8s_B_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_I");
    check_field_offset(lv, v2, 1, "aBFu8s_B_I.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_B_I.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_I(Test_aBFu8s_B_I, "aBFu8s_B_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_Ip()
{
  {
    init_simple_test("aBFu8s_B_Ip");
    static aBFu8s_B_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8s_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_Ip");
    check_field_offset(lv, v2, 1, "aBFu8s_B_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_Ip(Test_aBFu8s_B_Ip, "aBFu8s_B_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_L()
{
  {
    init_simple_test("aBFu8s_B_L");
    static aBFu8s_B_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8s_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_L");
    check_field_offset(lv, v2, 1, "aBFu8s_B_L.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_B_L.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_L(Test_aBFu8s_B_L, "aBFu8s_B_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_S()
{
  {
    init_simple_test("aBFu8s_B_S");
    static aBFu8s_B_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_S");
    check_field_offset(lv, v2, 1, "aBFu8s_B_S.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_B_S.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_S(Test_aBFu8s_B_S, "aBFu8s_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_Uc()
{
  {
    init_simple_test("aBFu8s_B_Uc");
    static aBFu8s_B_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_Uc");
    check_field_offset(lv, v2, 1, "aBFu8s_B_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_Uc(Test_aBFu8s_B_Uc, "aBFu8s_B_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_Ui()
{
  {
    init_simple_test("aBFu8s_B_Ui");
    static aBFu8s_B_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_Ui");
    check_field_offset(lv, v2, 1, "aBFu8s_B_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_Ui(Test_aBFu8s_B_Ui, "aBFu8s_B_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_Ul()
{
  {
    init_simple_test("aBFu8s_B_Ul");
    static aBFu8s_B_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8s_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_Ul");
    check_field_offset(lv, v2, 1, "aBFu8s_B_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_Ul(Test_aBFu8s_B_Ul, "aBFu8s_B_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_Us()
{
  {
    init_simple_test("aBFu8s_B_Us");
    static aBFu8s_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_Us");
    check_field_offset(lv, v2, 1, "aBFu8s_B_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_B_Us.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_Us(Test_aBFu8s_B_Us, "aBFu8s_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_B_Vp()
{
  {
    init_simple_test("aBFu8s_B_Vp");
    static aBFu8s_B_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8s_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_B_Vp");
    check_field_offset(lv, v2, 1, "aBFu8s_B_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_B_Vp(Test_aBFu8s_B_Vp, "aBFu8s_B_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu15i_B()
{
  {
    init_simple_test("aBFu8s_BFu15i_B");
    static aBFu8s_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_B");
    check_field_offset(lv, v3, 3, "aBFu8s_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu15i_B(Test_aBFu8s_BFu15i_B, "aBFu8s_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu15ll_B()
{
  {
    init_simple_test("aBFu8s_BFu15ll_B");
    static aBFu8s_BFu15ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15ll_B");
    check_field_offset(lv, v3, 3, "aBFu8s_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu15ll_B(Test_aBFu8s_BFu15ll_B, "aBFu8s_BFu15ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu15s_B()
{
  {
    init_simple_test("aBFu8s_BFu15s_B");
    static aBFu8s_BFu15s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15s_B");
    check_field_offset(lv, v3, 3, "aBFu8s_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu15s_B(Test_aBFu8s_BFu15s_B, "aBFu8s_BFu15s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu16i_B()
{
  {
    init_simple_test("aBFu8s_BFu16i_B");
    static aBFu8s_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu8s_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu8s_BFu16i_B");
    check_field_offset(lv, v3, 3, "aBFu8s_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu16i_B(Test_aBFu8s_BFu16i_B, "aBFu8s_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu16ll_B()
{
  {
    init_simple_test("aBFu8s_BFu16ll_B");
    static aBFu8s_BFu16ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu8s_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu8s_BFu16ll_B");
    check_field_offset(lv, v3, 3, "aBFu8s_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu16ll_B(Test_aBFu8s_BFu16ll_B, "aBFu8s_BFu16ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu16s_B()
{
  {
    init_simple_test("aBFu8s_BFu16s_B");
    static aBFu8s_BFu16s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu8s_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu8s_BFu16s_B");
    check_field_offset(lv, v3, 3, "aBFu8s_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu16s_B(Test_aBFu8s_BFu16s_B, "aBFu8s_BFu16s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu17i_B()
{
  {
    init_simple_test("aBFu8s_BFu17i_B");
    static aBFu8s_BFu17i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8s_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu8s_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu8s_BFu17i_B");
    check_field_offset(lv, v3, 4, "aBFu8s_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu17i_B(Test_aBFu8s_BFu17i_B, "aBFu8s_BFu17i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu17ll_B()
{
  {
    init_simple_test("aBFu8s_BFu17ll_B");
    static aBFu8s_BFu17ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8s_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu8s_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu8s_BFu17ll_B");
    check_field_offset(lv, v3, 4, "aBFu8s_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu17ll_B(Test_aBFu8s_BFu17ll_B, "aBFu8s_BFu17ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu1c_B()
{
  {
    init_simple_test("aBFu8s_BFu1c_B");
    static aBFu8s_BFu1c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8s_BFu1c_B");
    check_field_offset(lv, v3, 2, "aBFu8s_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu1c_B(Test_aBFu8s_BFu1c_B, "aBFu8s_BFu1c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu1i_B()
{
  {
    init_simple_test("aBFu8s_BFu1i_B");
    static aBFu8s_BFu1i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8s_BFu1i_B");
    check_field_offset(lv, v3, 2, "aBFu8s_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu1i_B(Test_aBFu8s_BFu1i_B, "aBFu8s_BFu1i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu1ll_B()
{
  {
    init_simple_test("aBFu8s_BFu1ll_B");
    static aBFu8s_BFu1ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8s_BFu1ll_B");
    check_field_offset(lv, v3, 2, "aBFu8s_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu1ll_B(Test_aBFu8s_BFu1ll_B, "aBFu8s_BFu1ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu1s_B()
{
  {
    init_simple_test("aBFu8s_BFu1s_B");
    static aBFu8s_BFu1s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu8s_BFu1s_B");
    check_field_offset(lv, v3, 2, "aBFu8s_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu1s_B(Test_aBFu8s_BFu1s_B, "aBFu8s_BFu1s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu31i_B()
{
  {
    init_simple_test("aBFu8s_BFu31i_B");
    static aBFu8s_BFu31i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu8s_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu8s_BFu31i_B");
    check_field_offset(lv, v3, 5, "aBFu8s_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu31i_B(Test_aBFu8s_BFu31i_B, "aBFu8s_BFu31i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu31ll_B()
{
  {
    init_simple_test("aBFu8s_BFu31ll_B");
    static aBFu8s_BFu31ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu8s_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu8s_BFu31ll_B");
    check_field_offset(lv, v3, 5, "aBFu8s_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu31ll_B(Test_aBFu8s_BFu31ll_B, "aBFu8s_BFu31ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu32i_B()
{
  {
    init_simple_test("aBFu8s_BFu32i_B");
    static aBFu8s_BFu32i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu8s_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu8s_BFu32i_B");
    check_field_offset(lv, v3, 5, "aBFu8s_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu32i_B(Test_aBFu8s_BFu32i_B, "aBFu8s_BFu32i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu32ll_B()
{
  {
    init_simple_test("aBFu8s_BFu32ll_B");
    static aBFu8s_BFu32ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu8s_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu8s_BFu32ll_B");
    check_field_offset(lv, v3, 5, "aBFu8s_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu32ll_B(Test_aBFu8s_BFu32ll_B, "aBFu8s_BFu32ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu33_B()
{
  {
    init_simple_test("aBFu8s_BFu33_B");
    static aBFu8s_BFu33_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8s_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aBFu8s_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aBFu8s_BFu33_B");
    check_field_offset(lv, v3, 6, "aBFu8s_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu33_B(Test_aBFu8s_BFu33_B, "aBFu8s_BFu33_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu7c_B()
{
  {
    init_simple_test("aBFu8s_BFu7c_B");
    static aBFu8s_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8s_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8s_BFu7c_B");
    check_field_offset(lv, v3, 2, "aBFu8s_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu7c_B(Test_aBFu8s_BFu7c_B, "aBFu8s_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu7i_B()
{
  {
    init_simple_test("aBFu8s_BFu7i_B");
    static aBFu8s_BFu7i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8s_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8s_BFu7i_B");
    check_field_offset(lv, v3, 2, "aBFu8s_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu7i_B(Test_aBFu8s_BFu7i_B, "aBFu8s_BFu7i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu7ll_B()
{
  {
    init_simple_test("aBFu8s_BFu7ll_B");
    static aBFu8s_BFu7ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8s_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8s_BFu7ll_B");
    check_field_offset(lv, v3, 2, "aBFu8s_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu7ll_B(Test_aBFu8s_BFu7ll_B, "aBFu8s_BFu7ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu7s_B()
{
  {
    init_simple_test("aBFu8s_BFu7s_B");
    static aBFu8s_BFu7s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu8s_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu8s_BFu7s_B");
    check_field_offset(lv, v3, 2, "aBFu8s_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu7s_B(Test_aBFu8s_BFu7s_B, "aBFu8s_BFu7s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu8c_B()
{
  {
    init_simple_test("aBFu8s_BFu8c_B");
    static aBFu8s_BFu8c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu8c_B");
    check_field_offset(lv, v3, 2, "aBFu8s_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu8c_B(Test_aBFu8s_BFu8c_B, "aBFu8s_BFu8c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu8i_B()
{
  {
    init_simple_test("aBFu8s_BFu8i_B");
    static aBFu8s_BFu8i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu8i_B");
    check_field_offset(lv, v3, 2, "aBFu8s_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu8i_B(Test_aBFu8s_BFu8i_B, "aBFu8s_BFu8i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu8ll_B()
{
  {
    init_simple_test("aBFu8s_BFu8ll_B");
    static aBFu8s_BFu8ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu8ll_B");
    check_field_offset(lv, v3, 2, "aBFu8s_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu8ll_B(Test_aBFu8s_BFu8ll_B, "aBFu8s_BFu8ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu8s_B()
{
  {
    init_simple_test("aBFu8s_BFu8s_B");
    static aBFu8s_BFu8s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu8s_B");
    check_field_offset(lv, v3, 2, "aBFu8s_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu8s_B(Test_aBFu8s_BFu8s_B, "aBFu8s_BFu8s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu9i_B()
{
  {
    init_simple_test("aBFu8s_BFu9i_B");
    static aBFu8s_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu8s_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu8s_BFu9i_B");
    check_field_offset(lv, v3, 3, "aBFu8s_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu9i_B(Test_aBFu8s_BFu9i_B, "aBFu8s_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu9ll_B()
{
  {
    init_simple_test("aBFu8s_BFu9ll_B");
    static aBFu8s_BFu9ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu8s_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu8s_BFu9ll_B");
    check_field_offset(lv, v3, 3, "aBFu8s_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu9ll_B(Test_aBFu8s_BFu9ll_B, "aBFu8s_BFu9ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_BFu9s_B()
{
  {
    init_simple_test("aBFu8s_BFu9s_B");
    static aBFu8s_BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu8s_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu8s_BFu9s_B");
    check_field_offset(lv, v3, 3, "aBFu8s_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_BFu9s_B(Test_aBFu8s_BFu9s_B, "aBFu8s_BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_C_B()
{
  {
    init_simple_test("aBFu8s_C_B");
    static aBFu8s_C_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_C_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_C_B");
    check_field_offset(lv, v2, 1, "aBFu8s_C_B.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_C_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_C_B(Test_aBFu8s_C_B, "aBFu8s_C_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_D_B()
{
  {
    init_simple_test("aBFu8s_D_B");
    static aBFu8s_D_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8s_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_D_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_D_B");
    check_field_offset(lv, v2, 1, "aBFu8s_D_B.v2");
    check_field_offset(lv, v3, 9, "aBFu8s_D_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_D_B(Test_aBFu8s_D_B, "aBFu8s_D_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_F_B()
{
  {
    init_simple_test("aBFu8s_F_B");
    static aBFu8s_F_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_F_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_F_B");
    check_field_offset(lv, v2, 1, "aBFu8s_F_B.v2");
    check_field_offset(lv, v3, 5, "aBFu8s_F_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_F_B(Test_aBFu8s_F_B, "aBFu8s_F_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_I_B()
{
  {
    init_simple_test("aBFu8s_I_B");
    static aBFu8s_I_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_I_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_I_B");
    check_field_offset(lv, v2, 1, "aBFu8s_I_B.v2");
    check_field_offset(lv, v3, 5, "aBFu8s_I_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_I_B(Test_aBFu8s_I_B, "aBFu8s_I_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_Ip_B()
{
  {
    init_simple_test("aBFu8s_Ip_B");
    static aBFu8s_Ip_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8s_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_Ip_B");
    check_field_offset(lv, v2, 1, "aBFu8s_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8s_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_Ip_B(Test_aBFu8s_Ip_B, "aBFu8s_Ip_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_L_B()
{
  {
    init_simple_test("aBFu8s_L_B");
    static aBFu8s_L_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8s_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_L_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_L_B");
    check_field_offset(lv, v2, 1, "aBFu8s_L_B.v2");
    check_field_offset(lv, v3, 9, "aBFu8s_L_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_L_B(Test_aBFu8s_L_B, "aBFu8s_L_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_S_B()
{
  {
    init_simple_test("aBFu8s_S_B");
    static aBFu8s_S_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_S_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_S_B");
    check_field_offset(lv, v2, 1, "aBFu8s_S_B.v2");
    check_field_offset(lv, v3, 3, "aBFu8s_S_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_S_B(Test_aBFu8s_S_B, "aBFu8s_S_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_Uc_B()
{
  {
    init_simple_test("aBFu8s_Uc_B");
    static aBFu8s_Uc_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_Uc_B");
    check_field_offset(lv, v2, 1, "aBFu8s_Uc_B.v2");
    check_field_offset(lv, v3, 2, "aBFu8s_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_Uc_B(Test_aBFu8s_Uc_B, "aBFu8s_Uc_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_Ui_B()
{
  {
    init_simple_test("aBFu8s_Ui_B");
    static aBFu8s_Ui_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8s_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_Ui_B");
    check_field_offset(lv, v2, 1, "aBFu8s_Ui_B.v2");
    check_field_offset(lv, v3, 5, "aBFu8s_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_Ui_B(Test_aBFu8s_Ui_B, "aBFu8s_Ui_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_Ul_B()
{
  {
    init_simple_test("aBFu8s_Ul_B");
    static aBFu8s_Ul_B lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8s_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_Ul_B");
    check_field_offset(lv, v2, 1, "aBFu8s_Ul_B.v2");
    check_field_offset(lv, v3, 9, "aBFu8s_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_Ul_B(Test_aBFu8s_Ul_B, "aBFu8s_Ul_B", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_Us_B()
{
  {
    init_simple_test("aBFu8s_Us_B");
    static aBFu8s_Us_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_Us_B");
    check_field_offset(lv, v2, 1, "aBFu8s_Us_B.v2");
    check_field_offset(lv, v3, 3, "aBFu8s_Us_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_Us_B(Test_aBFu8s_Us_B, "aBFu8s_Us_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu8s_Vp_B()
{
  {
    init_simple_test("aBFu8s_Vp_B");
    static aBFu8s_Vp_B lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8s_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_Vp_B");
    check_field_offset(lv, v2, 1, "aBFu8s_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8s_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu8s_Vp_B(Test_aBFu8s_Vp_B, "aBFu8s_Vp_B", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B()
{
  {
    init_simple_test("aBFu9i_B");
    static aBFu9i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B");
    check_field_offset(lv, v2, 2, "aBFu9i_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9i_B(Test_aBFu9i_B, "aBFu9i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_B()
{
  {
    init_simple_test("aBFu9i_B_B");
    static aBFu9i_B_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_B");
    check_field_offset(lv, v2, 2, "aBFu9i_B_B.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_B_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_B(Test_aBFu9i_B_B, "aBFu9i_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu15i()
{
  {
    init_simple_test("aBFu9i_B_BFu15i");
    static aBFu9i_B_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu15i");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu9i_B_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu9i_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu15i(Test_aBFu9i_B_BFu15i, "aBFu9i_B_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu15ll()
{
  {
    init_simple_test("aBFu9i_B_BFu15ll");
    static aBFu9i_B_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu15ll");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu9i_B_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu9i_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu15ll(Test_aBFu9i_B_BFu15ll, "aBFu9i_B_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu15s()
{
  {
    init_simple_test("aBFu9i_B_BFu15s");
    static aBFu9i_B_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu15s");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu9i_B_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu9i_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu15s(Test_aBFu9i_B_BFu15s, "aBFu9i_B_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu16i()
{
  {
    init_simple_test("aBFu9i_B_BFu16i");
    static aBFu9i_B_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu16i");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu9i_B_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu9i_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu16i(Test_aBFu9i_B_BFu16i, "aBFu9i_B_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu16ll()
{
  {
    init_simple_test("aBFu9i_B_BFu16ll");
    static aBFu9i_B_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu16ll");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu9i_B_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu9i_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu16ll(Test_aBFu9i_B_BFu16ll, "aBFu9i_B_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu16s()
{
  {
    init_simple_test("aBFu9i_B_BFu16s");
    static aBFu9i_B_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu16s");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu9i_B_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu9i_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu16s(Test_aBFu9i_B_BFu16s, "aBFu9i_B_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu17i()
{
  {
    init_simple_test("aBFu9i_B_BFu17i");
    static aBFu9i_B_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu9i_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu17i");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu9i_B_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu9i_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu17i(Test_aBFu9i_B_BFu17i, "aBFu9i_B_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu17ll()
{
  {
    init_simple_test("aBFu9i_B_BFu17ll");
    static aBFu9i_B_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu9i_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu17ll");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu9i_B_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu9i_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu17ll(Test_aBFu9i_B_BFu17ll, "aBFu9i_B_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu1c()
{
  {
    init_simple_test("aBFu9i_B_BFu1c");
    static aBFu9i_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu1c");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu9i_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu1c(Test_aBFu9i_B_BFu1c, "aBFu9i_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu1i()
{
  {
    init_simple_test("aBFu9i_B_BFu1i");
    static aBFu9i_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu1i");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu9i_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu1i(Test_aBFu9i_B_BFu1i, "aBFu9i_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu1ll()
{
  {
    init_simple_test("aBFu9i_B_BFu1ll");
    static aBFu9i_B_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu1ll");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu9i_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu1ll(Test_aBFu9i_B_BFu1ll, "aBFu9i_B_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu1s()
{
  {
    init_simple_test("aBFu9i_B_BFu1s");
    static aBFu9i_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu1s");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu9i_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu1s(Test_aBFu9i_B_BFu1s, "aBFu9i_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu31i()
{
  {
    init_simple_test("aBFu9i_B_BFu31i");
    static aBFu9i_B_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9i_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu31i");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu9i_B_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu9i_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu31i(Test_aBFu9i_B_BFu31i, "aBFu9i_B_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu31ll()
{
  {
    init_simple_test("aBFu9i_B_BFu31ll");
    static aBFu9i_B_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9i_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu31ll");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu9i_B_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu9i_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu31ll(Test_aBFu9i_B_BFu31ll, "aBFu9i_B_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu32i()
{
  {
    init_simple_test("aBFu9i_B_BFu32i");
    static aBFu9i_B_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9i_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu32i");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu9i_B_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu9i_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu32i(Test_aBFu9i_B_BFu32i, "aBFu9i_B_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu32ll()
{
  {
    init_simple_test("aBFu9i_B_BFu32ll");
    static aBFu9i_B_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9i_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu32ll");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu9i_B_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu9i_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu32ll(Test_aBFu9i_B_BFu32ll, "aBFu9i_B_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu33()
{
  {
    init_simple_test("aBFu9i_B_BFu33");
    static aBFu9i_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aBFu9i_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu33");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aBFu9i_B_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aBFu9i_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu33(Test_aBFu9i_B_BFu33, "aBFu9i_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu7c()
{
  {
    init_simple_test("aBFu9i_B_BFu7c");
    static aBFu9i_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu7c");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu9i_B_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu9i_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu7c(Test_aBFu9i_B_BFu7c, "aBFu9i_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu7i()
{
  {
    init_simple_test("aBFu9i_B_BFu7i");
    static aBFu9i_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu7i");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu9i_B_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu9i_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu7i(Test_aBFu9i_B_BFu7i, "aBFu9i_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu7ll()
{
  {
    init_simple_test("aBFu9i_B_BFu7ll");
    static aBFu9i_B_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu7ll");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu9i_B_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu9i_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu7ll(Test_aBFu9i_B_BFu7ll, "aBFu9i_B_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu7s()
{
  {
    init_simple_test("aBFu9i_B_BFu7s");
    static aBFu9i_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu7s");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu9i_B_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu9i_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu7s(Test_aBFu9i_B_BFu7s, "aBFu9i_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu8c()
{
  {
    init_simple_test("aBFu9i_B_BFu8c");
    static aBFu9i_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu8c");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu9i_B_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu9i_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu8c(Test_aBFu9i_B_BFu8c, "aBFu9i_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu8i()
{
  {
    init_simple_test("aBFu9i_B_BFu8i");
    static aBFu9i_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu8i");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu9i_B_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu9i_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu8i(Test_aBFu9i_B_BFu8i, "aBFu9i_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu8ll()
{
  {
    init_simple_test("aBFu9i_B_BFu8ll");
    static aBFu9i_B_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu8ll");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu9i_B_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu9i_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu8ll(Test_aBFu9i_B_BFu8ll, "aBFu9i_B_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu8s()
{
  {
    init_simple_test("aBFu9i_B_BFu8s");
    static aBFu9i_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu8s");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu9i_B_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu9i_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu8s(Test_aBFu9i_B_BFu8s, "aBFu9i_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu9i()
{
  {
    init_simple_test("aBFu9i_B_BFu9i");
    static aBFu9i_B_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu9i");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu9i_B_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu9i(Test_aBFu9i_B_BFu9i, "aBFu9i_B_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu9ll()
{
  {
    init_simple_test("aBFu9i_B_BFu9ll");
    static aBFu9i_B_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu9ll");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu9i_B_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu9ll(Test_aBFu9i_B_BFu9ll, "aBFu9i_B_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_BFu9s()
{
  {
    init_simple_test("aBFu9i_B_BFu9s");
    static aBFu9i_B_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu9s");
    check_field_offset(lv, v2, 2, "aBFu9i_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu9i_B_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_BFu9s(Test_aBFu9i_B_BFu9s, "aBFu9i_B_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_C()
{
  {
    init_simple_test("aBFu9i_B_C");
    static aBFu9i_B_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_C");
    check_field_offset(lv, v2, 2, "aBFu9i_B_C.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_B_C.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_C(Test_aBFu9i_B_C, "aBFu9i_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_D()
{
  {
    init_simple_test("aBFu9i_B_D");
    static aBFu9i_B_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9i_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_D");
    check_field_offset(lv, v2, 2, "aBFu9i_B_D.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_B_D.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_D(Test_aBFu9i_B_D, "aBFu9i_B_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_F()
{
  {
    init_simple_test("aBFu9i_B_F");
    static aBFu9i_B_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9i_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_F");
    check_field_offset(lv, v2, 2, "aBFu9i_B_F.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_B_F.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_F(Test_aBFu9i_B_F, "aBFu9i_B_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_I()
{
  {
    init_simple_test("aBFu9i_B_I");
    static aBFu9i_B_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9i_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_I");
    check_field_offset(lv, v2, 2, "aBFu9i_B_I.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_B_I.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_I(Test_aBFu9i_B_I, "aBFu9i_B_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_Ip()
{
  {
    init_simple_test("aBFu9i_B_Ip");
    static aBFu9i_B_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu9i_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_Ip");
    check_field_offset(lv, v2, 2, "aBFu9i_B_Ip.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_Ip(Test_aBFu9i_B_Ip, "aBFu9i_B_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_L()
{
  {
    init_simple_test("aBFu9i_B_L");
    static aBFu9i_B_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9i_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_L");
    check_field_offset(lv, v2, 2, "aBFu9i_B_L.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_B_L.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_L(Test_aBFu9i_B_L, "aBFu9i_B_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_S()
{
  {
    init_simple_test("aBFu9i_B_S");
    static aBFu9i_B_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_S");
    check_field_offset(lv, v2, 2, "aBFu9i_B_S.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_B_S.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_S(Test_aBFu9i_B_S, "aBFu9i_B_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_Uc()
{
  {
    init_simple_test("aBFu9i_B_Uc");
    static aBFu9i_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_Uc");
    check_field_offset(lv, v2, 2, "aBFu9i_B_Uc.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_Uc(Test_aBFu9i_B_Uc, "aBFu9i_B_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_Ui()
{
  {
    init_simple_test("aBFu9i_B_Ui");
    static aBFu9i_B_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9i_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_Ui");
    check_field_offset(lv, v2, 2, "aBFu9i_B_Ui.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_Ui(Test_aBFu9i_B_Ui, "aBFu9i_B_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_Ul()
{
  {
    init_simple_test("aBFu9i_B_Ul");
    static aBFu9i_B_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9i_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_Ul");
    check_field_offset(lv, v2, 2, "aBFu9i_B_Ul.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_Ul(Test_aBFu9i_B_Ul, "aBFu9i_B_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_Us()
{
  {
    init_simple_test("aBFu9i_B_Us");
    static aBFu9i_B_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_Us");
    check_field_offset(lv, v2, 2, "aBFu9i_B_Us.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_B_Us.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_Us(Test_aBFu9i_B_Us, "aBFu9i_B_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_B_Vp()
{
  {
    init_simple_test("aBFu9i_B_Vp");
    static aBFu9i_B_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu9i_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_B_Vp");
    check_field_offset(lv, v2, 2, "aBFu9i_B_Vp.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_B_Vp(Test_aBFu9i_B_Vp, "aBFu9i_B_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu15i_B()
{
  {
    init_simple_test("aBFu9i_BFu15i_B");
    static aBFu9i_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "aBFu9i_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "aBFu9i_BFu15i_B");
    check_field_offset(lv, v3, 3, "aBFu9i_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu15i_B(Test_aBFu9i_BFu15i_B, "aBFu9i_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu15ll_B()
{
  {
    init_simple_test("aBFu9i_BFu15ll_B");
    static aBFu9i_BFu15ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "aBFu9i_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "aBFu9i_BFu15ll_B");
    check_field_offset(lv, v3, 3, "aBFu9i_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu15ll_B(Test_aBFu9i_BFu15ll_B, "aBFu9i_BFu15ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu15s_B()
{
  {
    init_simple_test("aBFu9i_BFu15s_B");
    static aBFu9i_BFu15s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "aBFu9i_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "aBFu9i_BFu15s_B");
    check_field_offset(lv, v3, 3, "aBFu9i_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu15s_B(Test_aBFu9i_BFu15s_B, "aBFu9i_BFu15s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu16i_B()
{
  {
    init_simple_test("aBFu9i_BFu16i_B");
    static aBFu9i_BFu16i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "aBFu9i_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "aBFu9i_BFu16i_B");
    check_field_offset(lv, v3, 4, "aBFu9i_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu16i_B(Test_aBFu9i_BFu16i_B, "aBFu9i_BFu16i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu16ll_B()
{
  {
    init_simple_test("aBFu9i_BFu16ll_B");
    static aBFu9i_BFu16ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "aBFu9i_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "aBFu9i_BFu16ll_B");
    check_field_offset(lv, v3, 4, "aBFu9i_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu16ll_B(Test_aBFu9i_BFu16ll_B, "aBFu9i_BFu16ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu16s_B()
{
  {
    init_simple_test("aBFu9i_BFu16s_B");
    static aBFu9i_BFu16s_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "aBFu9i_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "aBFu9i_BFu16s_B");
    check_field_offset(lv, v3, 4, "aBFu9i_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu16s_B(Test_aBFu9i_BFu16s_B, "aBFu9i_BFu16s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu17i_B()
{
  {
    init_simple_test("aBFu9i_BFu17i_B");
    static aBFu9i_BFu17i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "aBFu9i_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "aBFu9i_BFu17i_B");
    check_field_offset(lv, v3, 4, "aBFu9i_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu17i_B(Test_aBFu9i_BFu17i_B, "aBFu9i_BFu17i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu17ll_B()
{
  {
    init_simple_test("aBFu9i_BFu17ll_B");
    static aBFu9i_BFu17ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "aBFu9i_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "aBFu9i_BFu17ll_B");
    check_field_offset(lv, v3, 4, "aBFu9i_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu17ll_B(Test_aBFu9i_BFu17ll_B, "aBFu9i_BFu17ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu1c_B()
{
  {
    init_simple_test("aBFu9i_BFu1c_B");
    static aBFu9i_BFu1c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9i_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "aBFu9i_BFu1c_B");
    check_field_offset(lv, v3, 2, "aBFu9i_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu1c_B(Test_aBFu9i_BFu1c_B, "aBFu9i_BFu1c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu1i_B()
{
  {
    init_simple_test("aBFu9i_BFu1i_B");
    static aBFu9i_BFu1i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9i_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "aBFu9i_BFu1i_B");
    check_field_offset(lv, v3, 2, "aBFu9i_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu1i_B(Test_aBFu9i_BFu1i_B, "aBFu9i_BFu1i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu1ll_B()
{
  {
    init_simple_test("aBFu9i_BFu1ll_B");
    static aBFu9i_BFu1ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9i_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "aBFu9i_BFu1ll_B");
    check_field_offset(lv, v3, 2, "aBFu9i_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu1ll_B(Test_aBFu9i_BFu1ll_B, "aBFu9i_BFu1ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu1s_B()
{
  {
    init_simple_test("aBFu9i_BFu1s_B");
    static aBFu9i_BFu1s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9i_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "aBFu9i_BFu1s_B");
    check_field_offset(lv, v3, 2, "aBFu9i_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu1s_B(Test_aBFu9i_BFu1s_B, "aBFu9i_BFu1s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu31i_B()
{
  {
    init_simple_test("aBFu9i_BFu31i_B");
    static aBFu9i_BFu31i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu9i_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "aBFu9i_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "aBFu9i_BFu31i_B");
    check_field_offset(lv, v3, 5, "aBFu9i_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu31i_B(Test_aBFu9i_BFu31i_B, "aBFu9i_BFu31i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu31ll_B()
{
  {
    init_simple_test("aBFu9i_BFu31ll_B");
    static aBFu9i_BFu31ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu9i_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "aBFu9i_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "aBFu9i_BFu31ll_B");
    check_field_offset(lv, v3, 5, "aBFu9i_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu31ll_B(Test_aBFu9i_BFu31ll_B, "aBFu9i_BFu31ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu32i_B()
{
  {
    init_simple_test("aBFu9i_BFu32i_B");
    static aBFu9i_BFu32i_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9i_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "aBFu9i_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "aBFu9i_BFu32i_B");
    check_field_offset(lv, v3, 6, "aBFu9i_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu32i_B(Test_aBFu9i_BFu32i_B, "aBFu9i_BFu32i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu32ll_B()
{
  {
    init_simple_test("aBFu9i_BFu32ll_B");
    static aBFu9i_BFu32ll_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9i_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "aBFu9i_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "aBFu9i_BFu32ll_B");
    check_field_offset(lv, v3, 6, "aBFu9i_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu32ll_B(Test_aBFu9i_BFu32ll_B, "aBFu9i_BFu32ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu33_B()
{
  {
    init_simple_test("aBFu9i_BFu33_B");
    static aBFu9i_BFu33_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9i_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu33_B");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "aBFu9i_BFu33_B");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "aBFu9i_BFu33_B");
    check_field_offset(lv, v3, 6, "aBFu9i_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu33_B(Test_aBFu9i_BFu33_B, "aBFu9i_BFu33_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu7c_B()
{
  {
    init_simple_test("aBFu9i_BFu7c_B");
    static aBFu9i_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9i_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "aBFu9i_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "aBFu9i_BFu7c_B");
    check_field_offset(lv, v3, 2, "aBFu9i_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu7c_B(Test_aBFu9i_BFu7c_B, "aBFu9i_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu7i_B()
{
  {
    init_simple_test("aBFu9i_BFu7i_B");
    static aBFu9i_BFu7i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9i_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "aBFu9i_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "aBFu9i_BFu7i_B");
    check_field_offset(lv, v3, 2, "aBFu9i_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu7i_B(Test_aBFu9i_BFu7i_B, "aBFu9i_BFu7i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu7ll_B()
{
  {
    init_simple_test("aBFu9i_BFu7ll_B");
    static aBFu9i_BFu7ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9i_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "aBFu9i_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "aBFu9i_BFu7ll_B");
    check_field_offset(lv, v3, 2, "aBFu9i_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu7ll_B(Test_aBFu9i_BFu7ll_B, "aBFu9i_BFu7ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu7s_B()
{
  {
    init_simple_test("aBFu9i_BFu7s_B");
    static aBFu9i_BFu7s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9i_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "aBFu9i_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "aBFu9i_BFu7s_B");
    check_field_offset(lv, v3, 2, "aBFu9i_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu7s_B(Test_aBFu9i_BFu7s_B, "aBFu9i_BFu7s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu8c_B()
{
  {
    init_simple_test("aBFu9i_BFu8c_B");
    static aBFu9i_BFu8c_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "aBFu9i_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "aBFu9i_BFu8c_B");
    check_field_offset(lv, v3, 3, "aBFu9i_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu8c_B(Test_aBFu9i_BFu8c_B, "aBFu9i_BFu8c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu8i_B()
{
  {
    init_simple_test("aBFu9i_BFu8i_B");
    static aBFu9i_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "aBFu9i_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "aBFu9i_BFu8i_B");
    check_field_offset(lv, v3, 3, "aBFu9i_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu8i_B(Test_aBFu9i_BFu8i_B, "aBFu9i_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu8ll_B()
{
  {
    init_simple_test("aBFu9i_BFu8ll_B");
    static aBFu9i_BFu8ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "aBFu9i_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "aBFu9i_BFu8ll_B");
    check_field_offset(lv, v3, 3, "aBFu9i_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu8ll_B(Test_aBFu9i_BFu8ll_B, "aBFu9i_BFu8ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu8s_B()
{
  {
    init_simple_test("aBFu9i_BFu8s_B");
    static aBFu9i_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "aBFu9i_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "aBFu9i_BFu8s_B");
    check_field_offset(lv, v3, 3, "aBFu9i_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu8s_B(Test_aBFu9i_BFu8s_B, "aBFu9i_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu9i_B()
{
  {
    init_simple_test("aBFu9i_BFu9i_B");
    static aBFu9i_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "aBFu9i_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "aBFu9i_BFu9i_B");
    check_field_offset(lv, v3, 3, "aBFu9i_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu9i_B(Test_aBFu9i_BFu9i_B, "aBFu9i_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu9ll_B()
{
  {
    init_simple_test("aBFu9i_BFu9ll_B");
    static aBFu9i_BFu9ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "aBFu9i_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "aBFu9i_BFu9ll_B");
    check_field_offset(lv, v3, 3, "aBFu9i_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu9ll_B(Test_aBFu9i_BFu9ll_B, "aBFu9i_BFu9ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_BFu9s_B()
{
  {
    init_simple_test("aBFu9i_BFu9s_B");
    static aBFu9i_BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "aBFu9i_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "aBFu9i_BFu9s_B");
    check_field_offset(lv, v3, 3, "aBFu9i_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_BFu9s_B(Test_aBFu9i_BFu9s_B, "aBFu9i_BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_C_B()
{
  {
    init_simple_test("aBFu9i_C_B");
    static aBFu9i_C_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_C_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_C_B");
    check_field_offset(lv, v2, 2, "aBFu9i_C_B.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_C_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_C_B(Test_aBFu9i_C_B, "aBFu9i_C_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_D_B()
{
  {
    init_simple_test("aBFu9i_D_B");
    static aBFu9i_D_B lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9i_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_D_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_D_B");
    check_field_offset(lv, v2, 2, "aBFu9i_D_B.v2");
    check_field_offset(lv, v3, 10, "aBFu9i_D_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_D_B(Test_aBFu9i_D_B, "aBFu9i_D_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_F_B()
{
  {
    init_simple_test("aBFu9i_F_B");
    static aBFu9i_F_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9i_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_F_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_F_B");
    check_field_offset(lv, v2, 2, "aBFu9i_F_B.v2");
    check_field_offset(lv, v3, 6, "aBFu9i_F_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_F_B(Test_aBFu9i_F_B, "aBFu9i_F_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_I_B()
{
  {
    init_simple_test("aBFu9i_I_B");
    static aBFu9i_I_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9i_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_I_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_I_B");
    check_field_offset(lv, v2, 2, "aBFu9i_I_B.v2");
    check_field_offset(lv, v3, 6, "aBFu9i_I_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_I_B(Test_aBFu9i_I_B, "aBFu9i_I_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_Ip_B()
{
  {
    init_simple_test("aBFu9i_Ip_B");
    static aBFu9i_Ip_B lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu9i_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_Ip_B");
    check_field_offset(lv, v2, 2, "aBFu9i_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu9i_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_Ip_B(Test_aBFu9i_Ip_B, "aBFu9i_Ip_B", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_L_B()
{
  {
    init_simple_test("aBFu9i_L_B");
    static aBFu9i_L_B lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9i_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_L_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_L_B");
    check_field_offset(lv, v2, 2, "aBFu9i_L_B.v2");
    check_field_offset(lv, v3, 10, "aBFu9i_L_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_L_B(Test_aBFu9i_L_B, "aBFu9i_L_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_S_B()
{
  {
    init_simple_test("aBFu9i_S_B");
    static aBFu9i_S_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_S_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_S_B");
    check_field_offset(lv, v2, 2, "aBFu9i_S_B.v2");
    check_field_offset(lv, v3, 4, "aBFu9i_S_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_S_B(Test_aBFu9i_S_B, "aBFu9i_S_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_Uc_B()
{
  {
    init_simple_test("aBFu9i_Uc_B");
    static aBFu9i_Uc_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9i_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_Uc_B");
    check_field_offset(lv, v2, 2, "aBFu9i_Uc_B.v2");
    check_field_offset(lv, v3, 3, "aBFu9i_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_Uc_B(Test_aBFu9i_Uc_B, "aBFu9i_Uc_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_Ui_B()
{
  {
    init_simple_test("aBFu9i_Ui_B");
    static aBFu9i_Ui_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9i_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_Ui_B");
    check_field_offset(lv, v2, 2, "aBFu9i_Ui_B.v2");
    check_field_offset(lv, v3, 6, "aBFu9i_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_Ui_B(Test_aBFu9i_Ui_B, "aBFu9i_Ui_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_Ul_B()
{
  {
    init_simple_test("aBFu9i_Ul_B");
    static aBFu9i_Ul_B lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9i_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_Ul_B");
    check_field_offset(lv, v2, 2, "aBFu9i_Ul_B.v2");
    check_field_offset(lv, v3, 10, "aBFu9i_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_Ul_B(Test_aBFu9i_Ul_B, "aBFu9i_Ul_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_Us_B()
{
  {
    init_simple_test("aBFu9i_Us_B");
    static aBFu9i_Us_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9i_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_Us_B");
    check_field_offset(lv, v2, 2, "aBFu9i_Us_B.v2");
    check_field_offset(lv, v3, 4, "aBFu9i_Us_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_Us_B(Test_aBFu9i_Us_B, "aBFu9i_Us_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9i_Vp_B()
{
  {
    init_simple_test("aBFu9i_Vp_B");
    static aBFu9i_Vp_B lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu9i_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_Vp_B");
    check_field_offset(lv, v2, 2, "aBFu9i_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu9i_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9i_Vp_B(Test_aBFu9i_Vp_B, "aBFu9i_Vp_B", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B()
{
  {
    init_simple_test("aBFu9ll_B");
    static aBFu9ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B(Test_aBFu9ll_B, "aBFu9ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_B()
{
  {
    init_simple_test("aBFu9ll_B_B");
    static aBFu9ll_B_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_B.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_B_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_B(Test_aBFu9ll_B_B, "aBFu9ll_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu15i()
{
  {
    init_simple_test("aBFu9ll_B_BFu15i");
    static aBFu9ll_B_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu15i");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu9ll_B_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu9ll_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu15i(Test_aBFu9ll_B_BFu15i, "aBFu9ll_B_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu15ll()
{
  {
    init_simple_test("aBFu9ll_B_BFu15ll");
    static aBFu9ll_B_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu15ll");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu9ll_B_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu9ll_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu15ll(Test_aBFu9ll_B_BFu15ll, "aBFu9ll_B_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu15s()
{
  {
    init_simple_test("aBFu9ll_B_BFu15s");
    static aBFu9ll_B_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu15s");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu9ll_B_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu9ll_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu15s(Test_aBFu9ll_B_BFu15s, "aBFu9ll_B_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu16i()
{
  {
    init_simple_test("aBFu9ll_B_BFu16i");
    static aBFu9ll_B_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu16i");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu9ll_B_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu9ll_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu16i(Test_aBFu9ll_B_BFu16i, "aBFu9ll_B_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu16ll()
{
  {
    init_simple_test("aBFu9ll_B_BFu16ll");
    static aBFu9ll_B_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu16ll");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu9ll_B_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu9ll_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu16ll(Test_aBFu9ll_B_BFu16ll, "aBFu9ll_B_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu16s()
{
  {
    init_simple_test("aBFu9ll_B_BFu16s");
    static aBFu9ll_B_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu16s");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu9ll_B_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu9ll_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu16s(Test_aBFu9ll_B_BFu16s, "aBFu9ll_B_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu17i()
{
  {
    init_simple_test("aBFu9ll_B_BFu17i");
    static aBFu9ll_B_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu9ll_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu17i");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu9ll_B_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu9ll_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu17i(Test_aBFu9ll_B_BFu17i, "aBFu9ll_B_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu17ll()
{
  {
    init_simple_test("aBFu9ll_B_BFu17ll");
    static aBFu9ll_B_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu9ll_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu17ll");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu9ll_B_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu9ll_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu17ll(Test_aBFu9ll_B_BFu17ll, "aBFu9ll_B_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu1c()
{
  {
    init_simple_test("aBFu9ll_B_BFu1c");
    static aBFu9ll_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu1c");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu9ll_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu1c(Test_aBFu9ll_B_BFu1c, "aBFu9ll_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu1i()
{
  {
    init_simple_test("aBFu9ll_B_BFu1i");
    static aBFu9ll_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu1i");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu9ll_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu1i(Test_aBFu9ll_B_BFu1i, "aBFu9ll_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu1ll()
{
  {
    init_simple_test("aBFu9ll_B_BFu1ll");
    static aBFu9ll_B_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu1ll");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu9ll_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu1ll(Test_aBFu9ll_B_BFu1ll, "aBFu9ll_B_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu1s()
{
  {
    init_simple_test("aBFu9ll_B_BFu1s");
    static aBFu9ll_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu1s");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu9ll_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu1s(Test_aBFu9ll_B_BFu1s, "aBFu9ll_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu31i()
{
  {
    init_simple_test("aBFu9ll_B_BFu31i");
    static aBFu9ll_B_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9ll_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu31i");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu9ll_B_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu9ll_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu31i(Test_aBFu9ll_B_BFu31i, "aBFu9ll_B_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu31ll()
{
  {
    init_simple_test("aBFu9ll_B_BFu31ll");
    static aBFu9ll_B_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9ll_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu31ll");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu9ll_B_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu9ll_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu31ll(Test_aBFu9ll_B_BFu31ll, "aBFu9ll_B_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu32i()
{
  {
    init_simple_test("aBFu9ll_B_BFu32i");
    static aBFu9ll_B_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9ll_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu32i");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu9ll_B_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu9ll_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu32i(Test_aBFu9ll_B_BFu32i, "aBFu9ll_B_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu32ll()
{
  {
    init_simple_test("aBFu9ll_B_BFu32ll");
    static aBFu9ll_B_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9ll_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu32ll");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu9ll_B_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu9ll_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu32ll(Test_aBFu9ll_B_BFu32ll, "aBFu9ll_B_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu33()
{
  {
    init_simple_test("aBFu9ll_B_BFu33");
    static aBFu9ll_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aBFu9ll_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu33");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aBFu9ll_B_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aBFu9ll_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu33(Test_aBFu9ll_B_BFu33, "aBFu9ll_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu7c()
{
  {
    init_simple_test("aBFu9ll_B_BFu7c");
    static aBFu9ll_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu7c");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu9ll_B_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu9ll_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu7c(Test_aBFu9ll_B_BFu7c, "aBFu9ll_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu7i()
{
  {
    init_simple_test("aBFu9ll_B_BFu7i");
    static aBFu9ll_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu7i");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu9ll_B_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu9ll_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu7i(Test_aBFu9ll_B_BFu7i, "aBFu9ll_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu7ll()
{
  {
    init_simple_test("aBFu9ll_B_BFu7ll");
    static aBFu9ll_B_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu7ll");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu9ll_B_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu9ll_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu7ll(Test_aBFu9ll_B_BFu7ll, "aBFu9ll_B_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu7s()
{
  {
    init_simple_test("aBFu9ll_B_BFu7s");
    static aBFu9ll_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu7s");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu9ll_B_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu9ll_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu7s(Test_aBFu9ll_B_BFu7s, "aBFu9ll_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu8c()
{
  {
    init_simple_test("aBFu9ll_B_BFu8c");
    static aBFu9ll_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu8c");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu9ll_B_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu9ll_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu8c(Test_aBFu9ll_B_BFu8c, "aBFu9ll_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu8i()
{
  {
    init_simple_test("aBFu9ll_B_BFu8i");
    static aBFu9ll_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu8i");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu9ll_B_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu9ll_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu8i(Test_aBFu9ll_B_BFu8i, "aBFu9ll_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu8ll()
{
  {
    init_simple_test("aBFu9ll_B_BFu8ll");
    static aBFu9ll_B_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu8ll");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu9ll_B_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu9ll_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu8ll(Test_aBFu9ll_B_BFu8ll, "aBFu9ll_B_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu8s()
{
  {
    init_simple_test("aBFu9ll_B_BFu8s");
    static aBFu9ll_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu8s");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu9ll_B_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu9ll_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu8s(Test_aBFu9ll_B_BFu8s, "aBFu9ll_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu9i()
{
  {
    init_simple_test("aBFu9ll_B_BFu9i");
    static aBFu9ll_B_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu9i");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu9ll_B_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu9i(Test_aBFu9ll_B_BFu9i, "aBFu9ll_B_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu9ll()
{
  {
    init_simple_test("aBFu9ll_B_BFu9ll");
    static aBFu9ll_B_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu9ll");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu9ll_B_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu9ll(Test_aBFu9ll_B_BFu9ll, "aBFu9ll_B_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_BFu9s()
{
  {
    init_simple_test("aBFu9ll_B_BFu9s");
    static aBFu9ll_B_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu9s");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu9ll_B_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_BFu9s(Test_aBFu9ll_B_BFu9s, "aBFu9ll_B_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_C()
{
  {
    init_simple_test("aBFu9ll_B_C");
    static aBFu9ll_B_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_C");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_C.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_B_C.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_C(Test_aBFu9ll_B_C, "aBFu9ll_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_D()
{
  {
    init_simple_test("aBFu9ll_B_D");
    static aBFu9ll_B_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9ll_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_D");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_D.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_B_D.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_D(Test_aBFu9ll_B_D, "aBFu9ll_B_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_F()
{
  {
    init_simple_test("aBFu9ll_B_F");
    static aBFu9ll_B_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9ll_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_F");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_F.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_B_F.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_F(Test_aBFu9ll_B_F, "aBFu9ll_B_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_I()
{
  {
    init_simple_test("aBFu9ll_B_I");
    static aBFu9ll_B_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9ll_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_I");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_I.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_B_I.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_I(Test_aBFu9ll_B_I, "aBFu9ll_B_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_Ip()
{
  {
    init_simple_test("aBFu9ll_B_Ip");
    static aBFu9ll_B_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu9ll_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_Ip");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_Ip.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_Ip(Test_aBFu9ll_B_Ip, "aBFu9ll_B_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_L()
{
  {
    init_simple_test("aBFu9ll_B_L");
    static aBFu9ll_B_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9ll_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_L");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_L.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_B_L.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_L(Test_aBFu9ll_B_L, "aBFu9ll_B_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_S()
{
  {
    init_simple_test("aBFu9ll_B_S");
    static aBFu9ll_B_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_S");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_S.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_B_S.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_S(Test_aBFu9ll_B_S, "aBFu9ll_B_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_Uc()
{
  {
    init_simple_test("aBFu9ll_B_Uc");
    static aBFu9ll_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_Uc");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_Uc.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_Uc(Test_aBFu9ll_B_Uc, "aBFu9ll_B_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_Ui()
{
  {
    init_simple_test("aBFu9ll_B_Ui");
    static aBFu9ll_B_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9ll_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_Ui");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_Ui.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_Ui(Test_aBFu9ll_B_Ui, "aBFu9ll_B_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_Ul()
{
  {
    init_simple_test("aBFu9ll_B_Ul");
    static aBFu9ll_B_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9ll_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_Ul");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_Ul.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_Ul(Test_aBFu9ll_B_Ul, "aBFu9ll_B_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_Us()
{
  {
    init_simple_test("aBFu9ll_B_Us");
    static aBFu9ll_B_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_Us");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_Us.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_B_Us.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_Us(Test_aBFu9ll_B_Us, "aBFu9ll_B_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_B_Vp()
{
  {
    init_simple_test("aBFu9ll_B_Vp");
    static aBFu9ll_B_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu9ll_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_B_Vp");
    check_field_offset(lv, v2, 2, "aBFu9ll_B_Vp.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_B_Vp(Test_aBFu9ll_B_Vp, "aBFu9ll_B_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu15i_B()
{
  {
    init_simple_test("aBFu9ll_BFu15i_B");
    static aBFu9ll_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "aBFu9ll_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "aBFu9ll_BFu15i_B");
    check_field_offset(lv, v3, 3, "aBFu9ll_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu15i_B(Test_aBFu9ll_BFu15i_B, "aBFu9ll_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu15ll_B()
{
  {
    init_simple_test("aBFu9ll_BFu15ll_B");
    static aBFu9ll_BFu15ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "aBFu9ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "aBFu9ll_BFu15ll_B");
    check_field_offset(lv, v3, 3, "aBFu9ll_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu15ll_B(Test_aBFu9ll_BFu15ll_B, "aBFu9ll_BFu15ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu15s_B()
{
  {
    init_simple_test("aBFu9ll_BFu15s_B");
    static aBFu9ll_BFu15s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "aBFu9ll_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "aBFu9ll_BFu15s_B");
    check_field_offset(lv, v3, 3, "aBFu9ll_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu15s_B(Test_aBFu9ll_BFu15s_B, "aBFu9ll_BFu15s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu16i_B()
{
  {
    init_simple_test("aBFu9ll_BFu16i_B");
    static aBFu9ll_BFu16i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "aBFu9ll_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "aBFu9ll_BFu16i_B");
    check_field_offset(lv, v3, 4, "aBFu9ll_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu16i_B(Test_aBFu9ll_BFu16i_B, "aBFu9ll_BFu16i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu16ll_B()
{
  {
    init_simple_test("aBFu9ll_BFu16ll_B");
    static aBFu9ll_BFu16ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "aBFu9ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "aBFu9ll_BFu16ll_B");
    check_field_offset(lv, v3, 4, "aBFu9ll_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu16ll_B(Test_aBFu9ll_BFu16ll_B, "aBFu9ll_BFu16ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu16s_B()
{
  {
    init_simple_test("aBFu9ll_BFu16s_B");
    static aBFu9ll_BFu16s_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "aBFu9ll_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "aBFu9ll_BFu16s_B");
    check_field_offset(lv, v3, 4, "aBFu9ll_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu16s_B(Test_aBFu9ll_BFu16s_B, "aBFu9ll_BFu16s_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu17i_B()
{
  {
    init_simple_test("aBFu9ll_BFu17i_B");
    static aBFu9ll_BFu17i_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "aBFu9ll_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "aBFu9ll_BFu17i_B");
    check_field_offset(lv, v3, 4, "aBFu9ll_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu17i_B(Test_aBFu9ll_BFu17i_B, "aBFu9ll_BFu17i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu17ll_B()
{
  {
    init_simple_test("aBFu9ll_BFu17ll_B");
    static aBFu9ll_BFu17ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "aBFu9ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "aBFu9ll_BFu17ll_B");
    check_field_offset(lv, v3, 4, "aBFu9ll_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu17ll_B(Test_aBFu9ll_BFu17ll_B, "aBFu9ll_BFu17ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu1c_B()
{
  {
    init_simple_test("aBFu9ll_BFu1c_B");
    static aBFu9ll_BFu1c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9ll_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "aBFu9ll_BFu1c_B");
    check_field_offset(lv, v3, 2, "aBFu9ll_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu1c_B(Test_aBFu9ll_BFu1c_B, "aBFu9ll_BFu1c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu1i_B()
{
  {
    init_simple_test("aBFu9ll_BFu1i_B");
    static aBFu9ll_BFu1i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9ll_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "aBFu9ll_BFu1i_B");
    check_field_offset(lv, v3, 2, "aBFu9ll_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu1i_B(Test_aBFu9ll_BFu1i_B, "aBFu9ll_BFu1i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu1ll_B()
{
  {
    init_simple_test("aBFu9ll_BFu1ll_B");
    static aBFu9ll_BFu1ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9ll_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "aBFu9ll_BFu1ll_B");
    check_field_offset(lv, v3, 2, "aBFu9ll_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu1ll_B(Test_aBFu9ll_BFu1ll_B, "aBFu9ll_BFu1ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu1s_B()
{
  {
    init_simple_test("aBFu9ll_BFu1s_B");
    static aBFu9ll_BFu1s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9ll_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "aBFu9ll_BFu1s_B");
    check_field_offset(lv, v3, 2, "aBFu9ll_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu1s_B(Test_aBFu9ll_BFu1s_B, "aBFu9ll_BFu1s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu31i_B()
{
  {
    init_simple_test("aBFu9ll_BFu31i_B");
    static aBFu9ll_BFu31i_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu9ll_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "aBFu9ll_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "aBFu9ll_BFu31i_B");
    check_field_offset(lv, v3, 5, "aBFu9ll_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu31i_B(Test_aBFu9ll_BFu31i_B, "aBFu9ll_BFu31i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu31ll_B()
{
  {
    init_simple_test("aBFu9ll_BFu31ll_B");
    static aBFu9ll_BFu31ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aBFu9ll_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "aBFu9ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "aBFu9ll_BFu31ll_B");
    check_field_offset(lv, v3, 5, "aBFu9ll_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu31ll_B(Test_aBFu9ll_BFu31ll_B, "aBFu9ll_BFu31ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu32i_B()
{
  {
    init_simple_test("aBFu9ll_BFu32i_B");
    static aBFu9ll_BFu32i_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9ll_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "aBFu9ll_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "aBFu9ll_BFu32i_B");
    check_field_offset(lv, v3, 6, "aBFu9ll_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu32i_B(Test_aBFu9ll_BFu32i_B, "aBFu9ll_BFu32i_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu32ll_B()
{
  {
    init_simple_test("aBFu9ll_BFu32ll_B");
    static aBFu9ll_BFu32ll_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9ll_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "aBFu9ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "aBFu9ll_BFu32ll_B");
    check_field_offset(lv, v3, 6, "aBFu9ll_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu32ll_B(Test_aBFu9ll_BFu32ll_B, "aBFu9ll_BFu32ll_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu33_B()
{
  {
    init_simple_test("aBFu9ll_BFu33_B");
    static aBFu9ll_BFu33_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9ll_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu33_B");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "aBFu9ll_BFu33_B");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "aBFu9ll_BFu33_B");
    check_field_offset(lv, v3, 6, "aBFu9ll_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu33_B(Test_aBFu9ll_BFu33_B, "aBFu9ll_BFu33_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu7c_B()
{
  {
    init_simple_test("aBFu9ll_BFu7c_B");
    static aBFu9ll_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9ll_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "aBFu9ll_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "aBFu9ll_BFu7c_B");
    check_field_offset(lv, v3, 2, "aBFu9ll_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu7c_B(Test_aBFu9ll_BFu7c_B, "aBFu9ll_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu7i_B()
{
  {
    init_simple_test("aBFu9ll_BFu7i_B");
    static aBFu9ll_BFu7i_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9ll_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "aBFu9ll_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "aBFu9ll_BFu7i_B");
    check_field_offset(lv, v3, 2, "aBFu9ll_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu7i_B(Test_aBFu9ll_BFu7i_B, "aBFu9ll_BFu7i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu7ll_B()
{
  {
    init_simple_test("aBFu9ll_BFu7ll_B");
    static aBFu9ll_BFu7ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9ll_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "aBFu9ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "aBFu9ll_BFu7ll_B");
    check_field_offset(lv, v3, 2, "aBFu9ll_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu7ll_B(Test_aBFu9ll_BFu7ll_B, "aBFu9ll_BFu7ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu7s_B()
{
  {
    init_simple_test("aBFu9ll_BFu7s_B");
    static aBFu9ll_BFu7s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9ll_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "aBFu9ll_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "aBFu9ll_BFu7s_B");
    check_field_offset(lv, v3, 2, "aBFu9ll_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu7s_B(Test_aBFu9ll_BFu7s_B, "aBFu9ll_BFu7s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu8c_B()
{
  {
    init_simple_test("aBFu9ll_BFu8c_B");
    static aBFu9ll_BFu8c_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "aBFu9ll_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "aBFu9ll_BFu8c_B");
    check_field_offset(lv, v3, 3, "aBFu9ll_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu8c_B(Test_aBFu9ll_BFu8c_B, "aBFu9ll_BFu8c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu8i_B()
{
  {
    init_simple_test("aBFu9ll_BFu8i_B");
    static aBFu9ll_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_BFu8i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "aBFu9ll_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "aBFu9ll_BFu8i_B");
    check_field_offset(lv, v3, 3, "aBFu9ll_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu8i_B(Test_aBFu9ll_BFu8i_B, "aBFu9ll_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu8ll_B()
{
  {
    init_simple_test("aBFu9ll_BFu8ll_B");
    static aBFu9ll_BFu8ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_BFu8ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "aBFu9ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "aBFu9ll_BFu8ll_B");
    check_field_offset(lv, v3, 3, "aBFu9ll_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu8ll_B(Test_aBFu9ll_BFu8ll_B, "aBFu9ll_BFu8ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu8s_B()
{
  {
    init_simple_test("aBFu9ll_BFu8s_B");
    static aBFu9ll_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_BFu8s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "aBFu9ll_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "aBFu9ll_BFu8s_B");
    check_field_offset(lv, v3, 3, "aBFu9ll_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu8s_B(Test_aBFu9ll_BFu8s_B, "aBFu9ll_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu9i_B()
{
  {
    init_simple_test("aBFu9ll_BFu9i_B");
    static aBFu9ll_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_BFu9i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "aBFu9ll_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "aBFu9ll_BFu9i_B");
    check_field_offset(lv, v3, 3, "aBFu9ll_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu9i_B(Test_aBFu9ll_BFu9i_B, "aBFu9ll_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu9ll_B()
{
  {
    init_simple_test("aBFu9ll_BFu9ll_B");
    static aBFu9ll_BFu9ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_BFu9ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "aBFu9ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "aBFu9ll_BFu9ll_B");
    check_field_offset(lv, v3, 3, "aBFu9ll_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu9ll_B(Test_aBFu9ll_BFu9ll_B, "aBFu9ll_BFu9ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_BFu9s_B()
{
  {
    init_simple_test("aBFu9ll_BFu9s_B");
    static aBFu9ll_BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_BFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "aBFu9ll_BFu9s_B");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "aBFu9ll_BFu9s_B");
    check_field_offset(lv, v3, 3, "aBFu9ll_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_BFu9s_B(Test_aBFu9ll_BFu9s_B, "aBFu9ll_BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_C_B()
{
  {
    init_simple_test("aBFu9ll_C_B");
    static aBFu9ll_C_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_C_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_C_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_C_B.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_C_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_C_B(Test_aBFu9ll_C_B, "aBFu9ll_C_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_D_B()
{
  {
    init_simple_test("aBFu9ll_D_B");
    static aBFu9ll_D_B lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9ll_D_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_D_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_D_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_D_B.v2");
    check_field_offset(lv, v3, 10, "aBFu9ll_D_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_D_B(Test_aBFu9ll_D_B, "aBFu9ll_D_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_F_B()
{
  {
    init_simple_test("aBFu9ll_F_B");
    static aBFu9ll_F_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9ll_F_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_F_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_F_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_F_B.v2");
    check_field_offset(lv, v3, 6, "aBFu9ll_F_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_F_B(Test_aBFu9ll_F_B, "aBFu9ll_F_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_I_B()
{
  {
    init_simple_test("aBFu9ll_I_B");
    static aBFu9ll_I_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9ll_I_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_I_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_I_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_I_B.v2");
    check_field_offset(lv, v3, 6, "aBFu9ll_I_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_I_B(Test_aBFu9ll_I_B, "aBFu9ll_I_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_Ip_B()
{
  {
    init_simple_test("aBFu9ll_Ip_B");
    static aBFu9ll_Ip_B lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu9ll_Ip_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_Ip_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu9ll_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_Ip_B(Test_aBFu9ll_Ip_B, "aBFu9ll_Ip_B", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_L_B()
{
  {
    init_simple_test("aBFu9ll_L_B");
    static aBFu9ll_L_B lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9ll_L_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_L_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_L_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_L_B.v2");
    check_field_offset(lv, v3, 10, "aBFu9ll_L_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_L_B(Test_aBFu9ll_L_B, "aBFu9ll_L_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_S_B()
{
  {
    init_simple_test("aBFu9ll_S_B");
    static aBFu9ll_S_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_S_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_S_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_S_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_S_B.v2");
    check_field_offset(lv, v3, 4, "aBFu9ll_S_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_S_B(Test_aBFu9ll_S_B, "aBFu9ll_S_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_Uc_B()
{
  {
    init_simple_test("aBFu9ll_Uc_B");
    static aBFu9ll_Uc_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9ll_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_Uc_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_Uc_B.v2");
    check_field_offset(lv, v3, 3, "aBFu9ll_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_Uc_B(Test_aBFu9ll_Uc_B, "aBFu9ll_Uc_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_Ui_B()
{
  {
    init_simple_test("aBFu9ll_Ui_B");
    static aBFu9ll_Ui_B lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9ll_Ui_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_Ui_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_Ui_B.v2");
    check_field_offset(lv, v3, 6, "aBFu9ll_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_Ui_B(Test_aBFu9ll_Ui_B, "aBFu9ll_Ui_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_Ul_B()
{
  {
    init_simple_test("aBFu9ll_Ul_B");
    static aBFu9ll_Ul_B lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9ll_Ul_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_Ul_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_Ul_B.v2");
    check_field_offset(lv, v3, 10, "aBFu9ll_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_Ul_B(Test_aBFu9ll_Ul_B, "aBFu9ll_Ul_B", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_Us_B()
{
  {
    init_simple_test("aBFu9ll_Us_B");
    static aBFu9ll_Us_B lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9ll_Us_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_Us_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_Us_B.v2");
    check_field_offset(lv, v3, 4, "aBFu9ll_Us_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_Us_B(Test_aBFu9ll_Us_B, "aBFu9ll_Us_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9ll_Vp_B()
{
  {
    init_simple_test("aBFu9ll_Vp_B");
    static aBFu9ll_Vp_B lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu9ll_Vp_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_Vp_B");
    check_field_offset(lv, v2, 2, "aBFu9ll_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu9ll_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9ll_Vp_B(Test_aBFu9ll_Vp_B, "aBFu9ll_Vp_B", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B()
{
  {
    init_simple_test("aBFu9s_B");
    static aBFu9s_B lv;
    check2(sizeof(lv), 3, "sizeof(aBFu9s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B");
    check_field_offset(lv, v2, 2, "aBFu9s_B.v2");
  }
}
static Arrange_To_Call_Me vaBFu9s_B(Test_aBFu9s_B, "aBFu9s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_B()
{
  {
    init_simple_test("aBFu9s_B_B");
    static aBFu9s_B_B lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_B");
    check_field_offset(lv, v2, 2, "aBFu9s_B_B.v2");
    check_field_offset(lv, v3, 3, "aBFu9s_B_B.v3");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_B(Test_aBFu9s_B_B, "aBFu9s_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu15i()
{
  {
    init_simple_test("aBFu9s_B_BFu15i");
    static aBFu9s_B_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9s_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu15i");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu9s_B_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu9s_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu15i(Test_aBFu9s_B_BFu15i, "aBFu9s_B_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu15ll()
{
  {
    init_simple_test("aBFu9s_B_BFu15ll");
    static aBFu9s_B_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9s_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu15ll");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu9s_B_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu9s_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu15ll(Test_aBFu9s_B_BFu15ll, "aBFu9s_B_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu15s()
{
  {
    init_simple_test("aBFu9s_B_BFu15s");
    static aBFu9s_B_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9s_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu15s");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu9s_B_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu9s_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu15s(Test_aBFu9s_B_BFu15s, "aBFu9s_B_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu16i()
{
  {
    init_simple_test("aBFu9s_B_BFu16i");
    static aBFu9s_B_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9s_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu16i");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu9s_B_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu9s_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu16i(Test_aBFu9s_B_BFu16i, "aBFu9s_B_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu16ll()
{
  {
    init_simple_test("aBFu9s_B_BFu16ll");
    static aBFu9s_B_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9s_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu16ll");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu9s_B_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu9s_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu16ll(Test_aBFu9s_B_BFu16ll, "aBFu9s_B_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu16s()
{
  {
    init_simple_test("aBFu9s_B_BFu16s");
    static aBFu9s_B_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9s_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu16s");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu9s_B_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu9s_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu16s(Test_aBFu9s_B_BFu16s, "aBFu9s_B_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu17i()
{
  {
    init_simple_test("aBFu9s_B_BFu17i");
    static aBFu9s_B_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu9s_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu17i");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu9s_B_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu9s_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu17i(Test_aBFu9s_B_BFu17i, "aBFu9s_B_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu17ll()
{
  {
    init_simple_test("aBFu9s_B_BFu17ll");
    static aBFu9s_B_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu9s_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu17ll");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu9s_B_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu9s_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu17ll(Test_aBFu9s_B_BFu17ll, "aBFu9s_B_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu1c()
{
  {
    init_simple_test("aBFu9s_B_BFu1c");
    static aBFu9s_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu1c");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu9s_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu1c(Test_aBFu9s_B_BFu1c, "aBFu9s_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu1i()
{
  {
    init_simple_test("aBFu9s_B_BFu1i");
    static aBFu9s_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu1i");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu9s_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu1i(Test_aBFu9s_B_BFu1i, "aBFu9s_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu1ll()
{
  {
    init_simple_test("aBFu9s_B_BFu1ll");
    static aBFu9s_B_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu1ll");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu9s_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu1ll(Test_aBFu9s_B_BFu1ll, "aBFu9s_B_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu1s()
{
  {
    init_simple_test("aBFu9s_B_BFu1s");
    static aBFu9s_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu1s");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu9s_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu1s(Test_aBFu9s_B_BFu1s, "aBFu9s_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu31i()
{
  {
    init_simple_test("aBFu9s_B_BFu31i");
    static aBFu9s_B_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9s_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu31i");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu9s_B_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu9s_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu31i(Test_aBFu9s_B_BFu31i, "aBFu9s_B_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu31ll()
{
  {
    init_simple_test("aBFu9s_B_BFu31ll");
    static aBFu9s_B_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9s_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu31ll");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu9s_B_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu9s_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu31ll(Test_aBFu9s_B_BFu31ll, "aBFu9s_B_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu32i()
{
  {
    init_simple_test("aBFu9s_B_BFu32i");
    static aBFu9s_B_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9s_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu32i");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu9s_B_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu9s_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu32i(Test_aBFu9s_B_BFu32i, "aBFu9s_B_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu32ll()
{
  {
    init_simple_test("aBFu9s_B_BFu32ll");
    static aBFu9s_B_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9s_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu32ll");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu9s_B_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu9s_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu32ll(Test_aBFu9s_B_BFu32ll, "aBFu9s_B_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu33()
{
  {
    init_simple_test("aBFu9s_B_BFu33");
    static aBFu9s_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aBFu9s_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu33");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aBFu9s_B_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aBFu9s_B_BFu33");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu33(Test_aBFu9s_B_BFu33, "aBFu9s_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu7c()
{
  {
    init_simple_test("aBFu9s_B_BFu7c");
    static aBFu9s_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu7c");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu9s_B_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu9s_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu7c(Test_aBFu9s_B_BFu7c, "aBFu9s_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu7i()
{
  {
    init_simple_test("aBFu9s_B_BFu7i");
    static aBFu9s_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu7i");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu9s_B_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu9s_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu7i(Test_aBFu9s_B_BFu7i, "aBFu9s_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu7ll()
{
  {
    init_simple_test("aBFu9s_B_BFu7ll");
    static aBFu9s_B_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu7ll");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu9s_B_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu9s_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu7ll(Test_aBFu9s_B_BFu7ll, "aBFu9s_B_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu7s()
{
  {
    init_simple_test("aBFu9s_B_BFu7s");
    static aBFu9s_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu7s");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu9s_B_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu9s_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu7s(Test_aBFu9s_B_BFu7s, "aBFu9s_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu8c()
{
  {
    init_simple_test("aBFu9s_B_BFu8c");
    static aBFu9s_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu8c");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu9s_B_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu9s_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu8c(Test_aBFu9s_B_BFu8c, "aBFu9s_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu8i()
{
  {
    init_simple_test("aBFu9s_B_BFu8i");
    static aBFu9s_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu8i");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu9s_B_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu9s_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu8i(Test_aBFu9s_B_BFu8i, "aBFu9s_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu8ll()
{
  {
    init_simple_test("aBFu9s_B_BFu8ll");
    static aBFu9s_B_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu8ll");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu9s_B_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu9s_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu8ll(Test_aBFu9s_B_BFu8ll, "aBFu9s_B_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu8s()
{
  {
    init_simple_test("aBFu9s_B_BFu8s");
    static aBFu9s_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu8s");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu9s_B_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu9s_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu8s(Test_aBFu9s_B_BFu8s, "aBFu9s_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu9i()
{
  {
    init_simple_test("aBFu9s_B_BFu9i");
    static aBFu9s_B_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9s_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu9i");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu9s_B_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu9i(Test_aBFu9s_B_BFu9i, "aBFu9s_B_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu9ll()
{
  {
    init_simple_test("aBFu9s_B_BFu9ll");
    static aBFu9s_B_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9s_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu9ll");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu9s_B_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu9ll(Test_aBFu9s_B_BFu9ll, "aBFu9s_B_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_BFu9s()
{
  {
    init_simple_test("aBFu9s_B_BFu9s");
    static aBFu9s_B_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9s_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu9s");
    check_field_offset(lv, v2, 2, "aBFu9s_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu9s_B_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_BFu9s(Test_aBFu9s_B_BFu9s, "aBFu9s_B_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_C()
{
  {
    init_simple_test("aBFu9s_B_C");
    static aBFu9s_B_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_C");
    check_field_offset(lv, v2, 2, "aBFu9s_B_C.v2");
    check_field_offset(lv, v3, 3, "aBFu9s_B_C.v3");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_C(Test_aBFu9s_B_C, "aBFu9s_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_D()
{
  {
    init_simple_test("aBFu9s_B_D");
    static aBFu9s_B_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9s_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_D");
    check_field_offset(lv, v2, 2, "aBFu9s_B_D.v2");
    check_field_offset(lv, v3, 3, "aBFu9s_B_D.v3");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_D(Test_aBFu9s_B_D, "aBFu9s_B_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_F()
{
  {
    init_simple_test("aBFu9s_B_F");
    static aBFu9s_B_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9s_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_F");
    check_field_offset(lv, v2, 2, "aBFu9s_B_F.v2");
    check_field_offset(lv, v3, 3, "aBFu9s_B_F.v3");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_F(Test_aBFu9s_B_F, "aBFu9s_B_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_I()
{
  {
    init_simple_test("aBFu9s_B_I");
    static aBFu9s_B_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu9s_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_I");
    check_field_offset(lv, v2, 2, "aBFu9s_B_I.v2");
    check_field_offset(lv, v3, 3, "aBFu9s_B_I.v3");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_I(Test_aBFu9s_B_I, "aBFu9s_B_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_Ip()
{
  {
    init_simple_test("aBFu9s_B_Ip");
    static aBFu9s_B_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu9s_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_Ip");
    check_field_offset(lv, v2, 2, "aBFu9s_B_Ip.v2");
    check_field_offset(lv, v3, 3, "aBFu9s_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_Ip(Test_aBFu9s_B_Ip, "aBFu9s_B_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_L()
{
  {
    init_simple_test("aBFu9s_B_L");
    static aBFu9s_B_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu9s_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_L");
    check_field_offset(lv, v2, 2, "aBFu9s_B_L.v2");
    check_field_offset(lv, v3, 3, "aBFu9s_B_L.v3");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_L(Test_aBFu9s_B_L, "aBFu9s_B_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_S()
{
  {
    init_simple_test("aBFu9s_B_S");
    static aBFu9s_B_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu9s_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_S");
    check_field_offset(lv, v2, 2, "aBFu9s_B_S.v2");
    check_field_offset(lv, v3, 3, "aBFu9s_B_S.v3");
  }
}
static Arrange_To_Call_Me vaBFu9s_B_S(Test_aBFu9s_B_S, "aBFu9s_B_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aBFu9s_B_Uc()
{
  {
    init_simple_test("aBFu9s_B_Uc");
    static aBFu9s_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu9s_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_B_Uc");
    check_field_offset(lv, v2, 2, "aBFu9s_B_Uc.v2");
    check_field_offset(lv, v3, 3, "aBFu9s_B_Uc.v3");
  }
}
static Arrange_T