// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
struct __attribute__((packed)) aB { bool v1; };
struct __attribute__((packed)) aB_B { bool v1; bool v2; };
struct __attribute__((packed)) aB_B_B { bool v1; bool v2; bool v3; };
struct __attribute__((packed)) aB_B_BFu15i { bool v1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aB_B_BFu15ll { bool v1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aB_B_BFu15s { bool v1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aB_B_BFu16i { bool v1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aB_B_BFu16ll { bool v1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aB_B_BFu16s { bool v1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aB_B_BFu17i { bool v1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aB_B_BFu17ll { bool v1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aB_B_BFu1c { bool v1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aB_B_BFu1i { bool v1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aB_B_BFu1ll { bool v1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aB_B_BFu1s { bool v1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aB_B_BFu31i { bool v1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aB_B_BFu31ll { bool v1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aB_B_BFu32i { bool v1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aB_B_BFu32ll { bool v1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aB_B_BFu33 { bool v1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aB_B_BFu7c { bool v1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aB_B_BFu7i { bool v1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aB_B_BFu7ll { bool v1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aB_B_BFu7s { bool v1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aB_B_BFu8c { bool v1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aB_B_BFu8i { bool v1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aB_B_BFu8ll { bool v1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aB_B_BFu8s { bool v1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aB_B_BFu9i { bool v1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aB_B_BFu9ll { bool v1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aB_B_BFu9s { bool v1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aB_B_C { bool v1; bool v2; char v3; };
struct __attribute__((packed)) aB_B_D { bool v1; bool v2; double v3; };
struct __attribute__((packed)) aB_B_F { bool v1; bool v2; float v3; };
struct __attribute__((packed)) aB_B_I { bool v1; bool v2; int v3; };
struct __attribute__((packed)) aB_B_Ip { bool v1; bool v2; int * v3; };
struct __attribute__((packed)) aB_B_L { bool v1; bool v2; long long v3; };
struct __attribute__((packed)) aB_B_S { bool v1; bool v2; short v3; };
struct __attribute__((packed)) aB_B_Uc { bool v1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aB_B_Ui { bool v1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aB_B_Ul { bool v1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aB_B_Us { bool v1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aB_B_Vp { bool v1; bool v2; void * v3; };
struct __attribute__((packed)) aB_BFu15i { bool v1; unsigned int v2:15; };
struct __attribute__((packed)) aB_BFu15i_B { bool v1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aB_BFu15i_BFu15i { bool v1; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu15i_BFu15ll { bool v1; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu15i_BFu15s { bool v1; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu15i_BFu16i { bool v1; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu15i_BFu16ll { bool v1; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu15i_BFu16s { bool v1; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu15i_BFu17i { bool v1; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu15i_BFu17ll { bool v1; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu15i_BFu1c { bool v1; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu15i_BFu1i { bool v1; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu15i_BFu1ll { bool v1; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu15i_BFu1s { bool v1; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu15i_BFu31i { bool v1; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu15i_BFu31ll { bool v1; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu15i_BFu32i { bool v1; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu15i_BFu32ll { bool v1; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu15i_BFu33 { bool v1; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu15i_BFu7c { bool v1; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu15i_BFu7i { bool v1; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu15i_BFu7ll { bool v1; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu15i_BFu7s { bool v1; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu15i_BFu8c { bool v1; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu15i_BFu8i { bool v1; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu15i_BFu8ll { bool v1; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu15i_BFu8s { bool v1; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu15i_BFu9i { bool v1; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu15i_BFu9ll { bool v1; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu15i_BFu9s { bool v1; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu15i_C { bool v1; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aB_BFu15i_D { bool v1; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aB_BFu15i_F { bool v1; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aB_BFu15i_I { bool v1; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aB_BFu15i_Ip { bool v1; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aB_BFu15i_L { bool v1; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aB_BFu15i_S { bool v1; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aB_BFu15i_Uc { bool v1; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aB_BFu15i_Ui { bool v1; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aB_BFu15i_Ul { bool v1; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu15i_Us { bool v1; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aB_BFu15i_Vp { bool v1; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aB_BFu15ll { bool v1; unsigned long long v2:15; };
struct __attribute__((packed)) aB_BFu15ll_B { bool v1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aB_BFu15ll_BFu15i { bool v1; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu15ll_BFu15ll { bool v1; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu15ll_BFu15s { bool v1; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu15ll_BFu16i { bool v1; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu15ll_BFu16ll { bool v1; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu15ll_BFu16s { bool v1; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu15ll_BFu17i { bool v1; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu15ll_BFu17ll { bool v1; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu15ll_BFu1c { bool v1; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu15ll_BFu1i { bool v1; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu15ll_BFu1ll { bool v1; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu15ll_BFu1s { bool v1; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu15ll_BFu31i { bool v1; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu15ll_BFu31ll { bool v1; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu15ll_BFu32i { bool v1; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu15ll_BFu32ll { bool v1; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu15ll_BFu33 { bool v1; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu15ll_BFu7c { bool v1; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu15ll_BFu7i { bool v1; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu15ll_BFu7ll { bool v1; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu15ll_BFu7s { bool v1; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu15ll_BFu8c { bool v1; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu15ll_BFu8i { bool v1; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu15ll_BFu8ll { bool v1; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu15ll_BFu8s { bool v1; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu15ll_BFu9i { bool v1; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu15ll_BFu9ll { bool v1; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu15ll_BFu9s { bool v1; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu15ll_C { bool v1; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aB_BFu15ll_D { bool v1; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aB_BFu15ll_F { bool v1; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aB_BFu15ll_I { bool v1; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aB_BFu15ll_Ip { bool v1; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aB_BFu15ll_L { bool v1; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aB_BFu15ll_S { bool v1; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aB_BFu15ll_Uc { bool v1; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aB_BFu15ll_Ui { bool v1; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aB_BFu15ll_Ul { bool v1; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu15ll_Us { bool v1; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aB_BFu15ll_Vp { bool v1; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aB_BFu15s { bool v1; unsigned short v2:15; };
struct __attribute__((packed)) aB_BFu15s_B { bool v1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aB_BFu15s_BFu15i { bool v1; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu15s_BFu15ll { bool v1; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu15s_BFu15s { bool v1; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu15s_BFu16i { bool v1; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu15s_BFu16ll { bool v1; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu15s_BFu16s { bool v1; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu15s_BFu17i { bool v1; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu15s_BFu17ll { bool v1; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu15s_BFu1c { bool v1; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu15s_BFu1i { bool v1; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu15s_BFu1ll { bool v1; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu15s_BFu1s { bool v1; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu15s_BFu31i { bool v1; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu15s_BFu31ll { bool v1; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu15s_BFu32i { bool v1; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu15s_BFu32ll { bool v1; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu15s_BFu33 { bool v1; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu15s_BFu7c { bool v1; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu15s_BFu7i { bool v1; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu15s_BFu7ll { bool v1; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu15s_BFu7s { bool v1; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu15s_BFu8c { bool v1; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu15s_BFu8i { bool v1; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu15s_BFu8ll { bool v1; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu15s_BFu8s { bool v1; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu15s_BFu9i { bool v1; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu15s_BFu9ll { bool v1; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu15s_BFu9s { bool v1; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu15s_C { bool v1; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aB_BFu15s_D { bool v1; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aB_BFu15s_F { bool v1; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aB_BFu15s_I { bool v1; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aB_BFu15s_Ip { bool v1; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aB_BFu15s_L { bool v1; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aB_BFu15s_S { bool v1; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aB_BFu15s_Uc { bool v1; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aB_BFu15s_Ui { bool v1; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aB_BFu15s_Ul { bool v1; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu15s_Us { bool v1; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aB_BFu15s_Vp { bool v1; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aB_BFu16i { bool v1; unsigned int v2:16; };
struct __attribute__((packed)) aB_BFu16i_B { bool v1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aB_BFu16i_BFu15i { bool v1; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu16i_BFu15ll { bool v1; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu16i_BFu15s { bool v1; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu16i_BFu16i { bool v1; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu16i_BFu16ll { bool v1; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu16i_BFu16s { bool v1; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu16i_BFu17i { bool v1; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu16i_BFu17ll { bool v1; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu16i_BFu1c { bool v1; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu16i_BFu1i { bool v1; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu16i_BFu1ll { bool v1; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu16i_BFu1s { bool v1; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu16i_BFu31i { bool v1; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu16i_BFu31ll { bool v1; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu16i_BFu32i { bool v1; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu16i_BFu32ll { bool v1; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu16i_BFu33 { bool v1; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu16i_BFu7c { bool v1; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu16i_BFu7i { bool v1; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu16i_BFu7ll { bool v1; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu16i_BFu7s { bool v1; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu16i_BFu8c { bool v1; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu16i_BFu8i { bool v1; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu16i_BFu8ll { bool v1; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu16i_BFu8s { bool v1; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu16i_BFu9i { bool v1; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu16i_BFu9ll { bool v1; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu16i_BFu9s { bool v1; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu16i_C { bool v1; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aB_BFu16i_D { bool v1; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aB_BFu16i_F { bool v1; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aB_BFu16i_I { bool v1; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aB_BFu16i_Ip { bool v1; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aB_BFu16i_L { bool v1; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aB_BFu16i_S { bool v1; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aB_BFu16i_Uc { bool v1; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aB_BFu16i_Ui { bool v1; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aB_BFu16i_Ul { bool v1; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu16i_Us { bool v1; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aB_BFu16i_Vp { bool v1; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aB_BFu16ll { bool v1; unsigned long long v2:16; };
struct __attribute__((packed)) aB_BFu16ll_B { bool v1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aB_BFu16ll_BFu15i { bool v1; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu16ll_BFu15ll { bool v1; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu16ll_BFu15s { bool v1; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu16ll_BFu16i { bool v1; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu16ll_BFu16ll { bool v1; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu16ll_BFu16s { bool v1; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu16ll_BFu17i { bool v1; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu16ll_BFu17ll { bool v1; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu16ll_BFu1c { bool v1; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu16ll_BFu1i { bool v1; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu16ll_BFu1ll { bool v1; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu16ll_BFu1s { bool v1; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu16ll_BFu31i { bool v1; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu16ll_BFu31ll { bool v1; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu16ll_BFu32i { bool v1; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu16ll_BFu32ll { bool v1; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu16ll_BFu33 { bool v1; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu16ll_BFu7c { bool v1; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu16ll_BFu7i { bool v1; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu16ll_BFu7ll { bool v1; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu16ll_BFu7s { bool v1; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu16ll_BFu8c { bool v1; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu16ll_BFu8i { bool v1; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu16ll_BFu8ll { bool v1; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu16ll_BFu8s { bool v1; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu16ll_BFu9i { bool v1; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu16ll_BFu9ll { bool v1; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu16ll_BFu9s { bool v1; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu16ll_C { bool v1; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aB_BFu16ll_D { bool v1; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aB_BFu16ll_F { bool v1; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aB_BFu16ll_I { bool v1; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aB_BFu16ll_Ip { bool v1; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aB_BFu16ll_L { bool v1; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aB_BFu16ll_S { bool v1; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aB_BFu16ll_Uc { bool v1; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aB_BFu16ll_Ui { bool v1; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aB_BFu16ll_Ul { bool v1; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu16ll_Us { bool v1; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aB_BFu16ll_Vp { bool v1; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aB_BFu16s { bool v1; unsigned short v2:16; };
struct __attribute__((packed)) aB_BFu16s_B { bool v1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aB_BFu16s_BFu15i { bool v1; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu16s_BFu15ll { bool v1; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu16s_BFu15s { bool v1; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu16s_BFu16i { bool v1; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu16s_BFu16ll { bool v1; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu16s_BFu16s { bool v1; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu16s_BFu17i { bool v1; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu16s_BFu17ll { bool v1; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu16s_BFu1c { bool v1; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu16s_BFu1i { bool v1; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu16s_BFu1ll { bool v1; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu16s_BFu1s { bool v1; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu16s_BFu31i { bool v1; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu16s_BFu31ll { bool v1; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu16s_BFu32i { bool v1; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu16s_BFu32ll { bool v1; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu16s_BFu33 { bool v1; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu16s_BFu7c { bool v1; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu16s_BFu7i { bool v1; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu16s_BFu7ll { bool v1; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu16s_BFu7s { bool v1; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu16s_BFu8c { bool v1; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu16s_BFu8i { bool v1; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu16s_BFu8ll { bool v1; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu16s_BFu8s { bool v1; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu16s_BFu9i { bool v1; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu16s_BFu9ll { bool v1; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu16s_BFu9s { bool v1; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu16s_C { bool v1; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aB_BFu16s_D { bool v1; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aB_BFu16s_F { bool v1; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aB_BFu16s_I { bool v1; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aB_BFu16s_Ip { bool v1; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aB_BFu16s_L { bool v1; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aB_BFu16s_S { bool v1; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aB_BFu16s_Uc { bool v1; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aB_BFu16s_Ui { bool v1; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aB_BFu16s_Ul { bool v1; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu16s_Us { bool v1; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aB_BFu16s_Vp { bool v1; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aB_BFu17i { bool v1; unsigned int v2:17; };
struct __attribute__((packed)) aB_BFu17i_B { bool v1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aB_BFu17i_BFu15i { bool v1; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu17i_BFu15ll { bool v1; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu17i_BFu15s { bool v1; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu17i_BFu16i { bool v1; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu17i_BFu16ll { bool v1; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu17i_BFu16s { bool v1; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu17i_BFu17i { bool v1; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu17i_BFu17ll { bool v1; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu17i_BFu1c { bool v1; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu17i_BFu1i { bool v1; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu17i_BFu1ll { bool v1; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu17i_BFu1s { bool v1; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu17i_BFu31i { bool v1; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu17i_BFu31ll { bool v1; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu17i_BFu32i { bool v1; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu17i_BFu32ll { bool v1; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu17i_BFu33 { bool v1; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu17i_BFu7c { bool v1; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu17i_BFu7i { bool v1; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu17i_BFu7ll { bool v1; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu17i_BFu7s { bool v1; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu17i_BFu8c { bool v1; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu17i_BFu8i { bool v1; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu17i_BFu8ll { bool v1; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu17i_BFu8s { bool v1; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu17i_BFu9i { bool v1; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu17i_BFu9ll { bool v1; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu17i_BFu9s { bool v1; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu17i_C { bool v1; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aB_BFu17i_D { bool v1; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aB_BFu17i_F { bool v1; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aB_BFu17i_I { bool v1; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aB_BFu17i_Ip { bool v1; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aB_BFu17i_L { bool v1; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aB_BFu17i_S { bool v1; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aB_BFu17i_Uc { bool v1; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aB_BFu17i_Ui { bool v1; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aB_BFu17i_Ul { bool v1; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu17i_Us { bool v1; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aB_BFu17i_Vp { bool v1; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aB_BFu17ll { bool v1; unsigned long long v2:17; };
struct __attribute__((packed)) aB_BFu17ll_B { bool v1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aB_BFu17ll_BFu15i { bool v1; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu17ll_BFu15ll { bool v1; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu17ll_BFu15s { bool v1; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu17ll_BFu16i { bool v1; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu17ll_BFu16ll { bool v1; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu17ll_BFu16s { bool v1; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu17ll_BFu17i { bool v1; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu17ll_BFu17ll { bool v1; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu17ll_BFu1c { bool v1; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu17ll_BFu1i { bool v1; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu17ll_BFu1ll { bool v1; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu17ll_BFu1s { bool v1; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu17ll_BFu31i { bool v1; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu17ll_BFu31ll { bool v1; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu17ll_BFu32i { bool v1; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu17ll_BFu32ll { bool v1; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu17ll_BFu33 { bool v1; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu17ll_BFu7c { bool v1; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu17ll_BFu7i { bool v1; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu17ll_BFu7ll { bool v1; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu17ll_BFu7s { bool v1; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu17ll_BFu8c { bool v1; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu17ll_BFu8i { bool v1; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu17ll_BFu8ll { bool v1; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu17ll_BFu8s { bool v1; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu17ll_BFu9i { bool v1; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu17ll_BFu9ll { bool v1; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu17ll_BFu9s { bool v1; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu17ll_C { bool v1; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aB_BFu17ll_D { bool v1; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aB_BFu17ll_F { bool v1; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aB_BFu17ll_I { bool v1; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aB_BFu17ll_Ip { bool v1; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aB_BFu17ll_L { bool v1; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aB_BFu17ll_S { bool v1; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aB_BFu17ll_Uc { bool v1; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aB_BFu17ll_Ui { bool v1; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aB_BFu17ll_Ul { bool v1; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu17ll_Us { bool v1; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aB_BFu17ll_Vp { bool v1; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aB_BFu1c { bool v1; unsigned char v2:1; };
struct __attribute__((packed)) aB_BFu1c_B { bool v1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aB_BFu1c_BFu15i { bool v1; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu1c_BFu15ll { bool v1; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu1c_BFu15s { bool v1; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu1c_BFu16i { bool v1; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu1c_BFu16ll { bool v1; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu1c_BFu16s { bool v1; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu1c_BFu17i { bool v1; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu1c_BFu17ll { bool v1; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu1c_BFu1c { bool v1; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu1c_BFu1i { bool v1; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu1c_BFu1ll { bool v1; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu1c_BFu1s { bool v1; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu1c_BFu31i { bool v1; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu1c_BFu31ll { bool v1; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu1c_BFu32i { bool v1; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu1c_BFu32ll { bool v1; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu1c_BFu33 { bool v1; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu1c_BFu7c { bool v1; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu1c_BFu7i { bool v1; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu1c_BFu7ll { bool v1; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu1c_BFu7s { bool v1; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu1c_BFu8c { bool v1; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu1c_BFu8i { bool v1; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu1c_BFu8ll { bool v1; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu1c_BFu8s { bool v1; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu1c_BFu9i { bool v1; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu1c_BFu9ll { bool v1; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu1c_BFu9s { bool v1; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu1c_C { bool v1; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aB_BFu1c_D { bool v1; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aB_BFu1c_F { bool v1; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aB_BFu1c_I { bool v1; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aB_BFu1c_Ip { bool v1; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aB_BFu1c_L { bool v1; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aB_BFu1c_S { bool v1; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aB_BFu1c_Uc { bool v1; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aB_BFu1c_Ui { bool v1; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aB_BFu1c_Ul { bool v1; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu1c_Us { bool v1; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aB_BFu1c_Vp { bool v1; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aB_BFu1i { bool v1; unsigned int v2:1; };
struct __attribute__((packed)) aB_BFu1i_B { bool v1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aB_BFu1i_BFu15i { bool v1; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu1i_BFu15ll { bool v1; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu1i_BFu15s { bool v1; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu1i_BFu16i { bool v1; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu1i_BFu16ll { bool v1; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu1i_BFu16s { bool v1; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu1i_BFu17i { bool v1; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu1i_BFu17ll { bool v1; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu1i_BFu1c { bool v1; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu1i_BFu1i { bool v1; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu1i_BFu1ll { bool v1; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu1i_BFu1s { bool v1; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu1i_BFu31i { bool v1; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu1i_BFu31ll { bool v1; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu1i_BFu32i { bool v1; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu1i_BFu32ll { bool v1; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu1i_BFu33 { bool v1; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu1i_BFu7c { bool v1; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu1i_BFu7i { bool v1; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu1i_BFu7ll { bool v1; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu1i_BFu7s { bool v1; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu1i_BFu8c { bool v1; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu1i_BFu8i { bool v1; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu1i_BFu8ll { bool v1; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu1i_BFu8s { bool v1; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu1i_BFu9i { bool v1; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu1i_BFu9ll { bool v1; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu1i_BFu9s { bool v1; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu1i_C { bool v1; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aB_BFu1i_D { bool v1; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aB_BFu1i_F { bool v1; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aB_BFu1i_I { bool v1; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aB_BFu1i_Ip { bool v1; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aB_BFu1i_L { bool v1; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aB_BFu1i_S { bool v1; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aB_BFu1i_Uc { bool v1; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aB_BFu1i_Ui { bool v1; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aB_BFu1i_Ul { bool v1; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu1i_Us { bool v1; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aB_BFu1i_Vp { bool v1; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aB_BFu1ll { bool v1; unsigned long long v2:1; };
struct __attribute__((packed)) aB_BFu1ll_B { bool v1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aB_BFu1ll_BFu15i { bool v1; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu1ll_BFu15ll { bool v1; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu1ll_BFu15s { bool v1; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu1ll_BFu16i { bool v1; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu1ll_BFu16ll { bool v1; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu1ll_BFu16s { bool v1; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu1ll_BFu17i { bool v1; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu1ll_BFu17ll { bool v1; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu1ll_BFu1c { bool v1; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu1ll_BFu1i { bool v1; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu1ll_BFu1ll { bool v1; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu1ll_BFu1s { bool v1; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu1ll_BFu31i { bool v1; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu1ll_BFu31ll { bool v1; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu1ll_BFu32i { bool v1; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu1ll_BFu32ll { bool v1; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu1ll_BFu33 { bool v1; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu1ll_BFu7c { bool v1; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu1ll_BFu7i { bool v1; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu1ll_BFu7ll { bool v1; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu1ll_BFu7s { bool v1; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu1ll_BFu8c { bool v1; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu1ll_BFu8i { bool v1; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu1ll_BFu8ll { bool v1; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu1ll_BFu8s { bool v1; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu1ll_BFu9i { bool v1; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu1ll_BFu9ll { bool v1; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu1ll_BFu9s { bool v1; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu1ll_C { bool v1; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aB_BFu1ll_D { bool v1; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aB_BFu1ll_F { bool v1; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aB_BFu1ll_I { bool v1; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aB_BFu1ll_Ip { bool v1; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aB_BFu1ll_L { bool v1; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aB_BFu1ll_S { bool v1; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aB_BFu1ll_Uc { bool v1; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aB_BFu1ll_Ui { bool v1; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aB_BFu1ll_Ul { bool v1; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu1ll_Us { bool v1; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aB_BFu1ll_Vp { bool v1; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aB_BFu1s { bool v1; unsigned short v2:1; };
struct __attribute__((packed)) aB_BFu1s_B { bool v1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aB_BFu1s_BFu15i { bool v1; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu1s_BFu15ll { bool v1; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu1s_BFu15s { bool v1; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu1s_BFu16i { bool v1; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu1s_BFu16ll { bool v1; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu1s_BFu16s { bool v1; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu1s_BFu17i { bool v1; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu1s_BFu17ll { bool v1; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu1s_BFu1c { bool v1; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu1s_BFu1i { bool v1; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu1s_BFu1ll { bool v1; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu1s_BFu1s { bool v1; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu1s_BFu31i { bool v1; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu1s_BFu31ll { bool v1; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu1s_BFu32i { bool v1; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu1s_BFu32ll { bool v1; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu1s_BFu33 { bool v1; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu1s_BFu7c { bool v1; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu1s_BFu7i { bool v1; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu1s_BFu7ll { bool v1; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu1s_BFu7s { bool v1; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu1s_BFu8c { bool v1; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu1s_BFu8i { bool v1; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu1s_BFu8ll { bool v1; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu1s_BFu8s { bool v1; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu1s_BFu9i { bool v1; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu1s_BFu9ll { bool v1; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu1s_BFu9s { bool v1; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu1s_C { bool v1; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aB_BFu1s_D { bool v1; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aB_BFu1s_F { bool v1; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aB_BFu1s_I { bool v1; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aB_BFu1s_Ip { bool v1; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aB_BFu1s_L { bool v1; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aB_BFu1s_S { bool v1; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aB_BFu1s_Uc { bool v1; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aB_BFu1s_Ui { bool v1; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aB_BFu1s_Ul { bool v1; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu1s_Us { bool v1; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aB_BFu1s_Vp { bool v1; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aB_BFu31i { bool v1; unsigned int v2:31; };
struct __attribute__((packed)) aB_BFu31i_B { bool v1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aB_BFu31i_BFu15i { bool v1; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu31i_BFu15ll { bool v1; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu31i_BFu15s { bool v1; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu31i_BFu16i { bool v1; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu31i_BFu16ll { bool v1; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu31i_BFu16s { bool v1; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu31i_BFu17i { bool v1; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu31i_BFu17ll { bool v1; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu31i_BFu1c { bool v1; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu31i_BFu1i { bool v1; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu31i_BFu1ll { bool v1; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu31i_BFu1s { bool v1; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu31i_BFu31i { bool v1; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu31i_BFu31ll { bool v1; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu31i_BFu32i { bool v1; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu31i_BFu32ll { bool v1; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu31i_BFu33 { bool v1; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu31i_BFu7c { bool v1; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu31i_BFu7i { bool v1; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu31i_BFu7ll { bool v1; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu31i_BFu7s { bool v1; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu31i_BFu8c { bool v1; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu31i_BFu8i { bool v1; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu31i_BFu8ll { bool v1; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu31i_BFu8s { bool v1; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu31i_BFu9i { bool v1; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu31i_BFu9ll { bool v1; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu31i_BFu9s { bool v1; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu31i_C { bool v1; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aB_BFu31i_D { bool v1; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aB_BFu31i_F { bool v1; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aB_BFu31i_I { bool v1; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aB_BFu31i_Ip { bool v1; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aB_BFu31i_L { bool v1; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aB_BFu31i_S { bool v1; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aB_BFu31i_Uc { bool v1; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aB_BFu31i_Ui { bool v1; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aB_BFu31i_Ul { bool v1; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu31i_Us { bool v1; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aB_BFu31i_Vp { bool v1; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aB_BFu31ll { bool v1; unsigned long long v2:31; };
struct __attribute__((packed)) aB_BFu31ll_B { bool v1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aB_BFu31ll_BFu15i { bool v1; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu31ll_BFu15ll { bool v1; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu31ll_BFu15s { bool v1; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu31ll_BFu16i { bool v1; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu31ll_BFu16ll { bool v1; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu31ll_BFu16s { bool v1; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu31ll_BFu17i { bool v1; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu31ll_BFu17ll { bool v1; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu31ll_BFu1c { bool v1; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu31ll_BFu1i { bool v1; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu31ll_BFu1ll { bool v1; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu31ll_BFu1s { bool v1; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu31ll_BFu31i { bool v1; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu31ll_BFu31ll { bool v1; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu31ll_BFu32i { bool v1; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu31ll_BFu32ll { bool v1; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu31ll_BFu33 { bool v1; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu31ll_BFu7c { bool v1; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu31ll_BFu7i { bool v1; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu31ll_BFu7ll { bool v1; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu31ll_BFu7s { bool v1; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu31ll_BFu8c { bool v1; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu31ll_BFu8i { bool v1; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu31ll_BFu8ll { bool v1; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu31ll_BFu8s { bool v1; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu31ll_BFu9i { bool v1; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu31ll_BFu9ll { bool v1; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu31ll_BFu9s { bool v1; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu31ll_C { bool v1; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aB_BFu31ll_D { bool v1; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aB_BFu31ll_F { bool v1; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aB_BFu31ll_I { bool v1; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aB_BFu31ll_Ip { bool v1; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aB_BFu31ll_L { bool v1; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aB_BFu31ll_S { bool v1; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aB_BFu31ll_Uc { bool v1; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aB_BFu31ll_Ui { bool v1; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aB_BFu31ll_Ul { bool v1; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu31ll_Us { bool v1; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aB_BFu31ll_Vp { bool v1; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aB_BFu32i { bool v1; unsigned int v2:32; };
struct __attribute__((packed)) aB_BFu32i_B { bool v1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aB_BFu32i_BFu15i { bool v1; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu32i_BFu15ll { bool v1; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu32i_BFu15s { bool v1; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu32i_BFu16i { bool v1; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu32i_BFu16ll { bool v1; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu32i_BFu16s { bool v1; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu32i_BFu17i { bool v1; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu32i_BFu17ll { bool v1; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu32i_BFu1c { bool v1; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu32i_BFu1i { bool v1; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu32i_BFu1ll { bool v1; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu32i_BFu1s { bool v1; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu32i_BFu31i { bool v1; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu32i_BFu31ll { bool v1; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu32i_BFu32i { bool v1; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu32i_BFu32ll { bool v1; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu32i_BFu33 { bool v1; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu32i_BFu7c { bool v1; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu32i_BFu7i { bool v1; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu32i_BFu7ll { bool v1; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu32i_BFu7s { bool v1; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu32i_BFu8c { bool v1; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu32i_BFu8i { bool v1; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu32i_BFu8ll { bool v1; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu32i_BFu8s { bool v1; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu32i_BFu9i { bool v1; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu32i_BFu9ll { bool v1; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu32i_BFu9s { bool v1; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu32i_C { bool v1; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aB_BFu32i_D { bool v1; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aB_BFu32i_F { bool v1; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aB_BFu32i_I { bool v1; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aB_BFu32i_Ip { bool v1; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aB_BFu32i_L { bool v1; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aB_BFu32i_S { bool v1; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aB_BFu32i_Uc { bool v1; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aB_BFu32i_Ui { bool v1; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aB_BFu32i_Ul { bool v1; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu32i_Us { bool v1; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aB_BFu32i_Vp { bool v1; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aB_BFu32ll { bool v1; unsigned long long v2:32; };
struct __attribute__((packed)) aB_BFu32ll_B { bool v1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aB_BFu32ll_BFu15i { bool v1; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu32ll_BFu15ll { bool v1; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu32ll_BFu15s { bool v1; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu32ll_BFu16i { bool v1; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu32ll_BFu16ll { bool v1; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu32ll_BFu16s { bool v1; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu32ll_BFu17i { bool v1; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu32ll_BFu17ll { bool v1; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu32ll_BFu1c { bool v1; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu32ll_BFu1i { bool v1; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu32ll_BFu1ll { bool v1; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu32ll_BFu1s { bool v1; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu32ll_BFu31i { bool v1; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu32ll_BFu31ll { bool v1; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu32ll_BFu32i { bool v1; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu32ll_BFu32ll { bool v1; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu32ll_BFu33 { bool v1; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu32ll_BFu7c { bool v1; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu32ll_BFu7i { bool v1; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu32ll_BFu7ll { bool v1; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu32ll_BFu7s { bool v1; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu32ll_BFu8c { bool v1; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu32ll_BFu8i { bool v1; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu32ll_BFu8ll { bool v1; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu32ll_BFu8s { bool v1; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu32ll_BFu9i { bool v1; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu32ll_BFu9ll { bool v1; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu32ll_BFu9s { bool v1; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu32ll_C { bool v1; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aB_BFu32ll_D { bool v1; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aB_BFu32ll_F { bool v1; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aB_BFu32ll_I { bool v1; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aB_BFu32ll_Ip { bool v1; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aB_BFu32ll_L { bool v1; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aB_BFu32ll_S { bool v1; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aB_BFu32ll_Uc { bool v1; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aB_BFu32ll_Ui { bool v1; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aB_BFu32ll_Ul { bool v1; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu32ll_Us { bool v1; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aB_BFu32ll_Vp { bool v1; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aB_BFu33 { bool v1; unsigned long long v2:33; };
struct __attribute__((packed)) aB_BFu33_B { bool v1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aB_BFu33_BFu15i { bool v1; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu33_BFu15ll { bool v1; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu33_BFu15s { bool v1; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu33_BFu16i { bool v1; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu33_BFu16ll { bool v1; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu33_BFu16s { bool v1; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu33_BFu17i { bool v1; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu33_BFu17ll { bool v1; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu33_BFu1c { bool v1; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu33_BFu1i { bool v1; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu33_BFu1ll { bool v1; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu33_BFu1s { bool v1; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu33_BFu31i { bool v1; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu33_BFu31ll { bool v1; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu33_BFu32i { bool v1; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu33_BFu32ll { bool v1; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu33_BFu33 { bool v1; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu33_BFu7c { bool v1; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu33_BFu7i { bool v1; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu33_BFu7ll { bool v1; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu33_BFu7s { bool v1; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu33_BFu8c { bool v1; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu33_BFu8i { bool v1; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu33_BFu8ll { bool v1; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu33_BFu8s { bool v1; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu33_BFu9i { bool v1; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu33_BFu9ll { bool v1; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu33_BFu9s { bool v1; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu33_C { bool v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aB_BFu33_D { bool v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aB_BFu33_F { bool v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aB_BFu33_I { bool v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aB_BFu33_Ip { bool v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aB_BFu33_L { bool v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aB_BFu33_S { bool v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aB_BFu33_Uc { bool v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aB_BFu33_Ui { bool v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aB_BFu33_Ul { bool v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu33_Us { bool v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aB_BFu33_Vp { bool v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aB_BFu7c { bool v1; unsigned char v2:7; };
struct __attribute__((packed)) aB_BFu7c_B { bool v1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aB_BFu7c_BFu15i { bool v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu7c_BFu15ll { bool v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu7c_BFu15s { bool v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu7c_BFu16i { bool v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu7c_BFu16ll { bool v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu7c_BFu16s { bool v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu7c_BFu17i { bool v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu7c_BFu17ll { bool v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu7c_BFu1c { bool v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu7c_BFu1i { bool v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu7c_BFu1ll { bool v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu7c_BFu1s { bool v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu7c_BFu31i { bool v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu7c_BFu31ll { bool v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu7c_BFu32i { bool v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu7c_BFu32ll { bool v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu7c_BFu33 { bool v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu7c_BFu7c { bool v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu7c_BFu7i { bool v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu7c_BFu7ll { bool v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu7c_BFu7s { bool v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu7c_BFu8c { bool v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu7c_BFu8i { bool v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu7c_BFu8ll { bool v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu7c_BFu8s { bool v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu7c_BFu9i { bool v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu7c_BFu9ll { bool v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu7c_BFu9s { bool v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu7c_C { bool v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aB_BFu7c_D { bool v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aB_BFu7c_F { bool v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aB_BFu7c_I { bool v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aB_BFu7c_Ip { bool v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aB_BFu7c_L { bool v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aB_BFu7c_S { bool v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aB_BFu7c_Uc { bool v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aB_BFu7c_Ui { bool v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aB_BFu7c_Ul { bool v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu7c_Us { bool v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aB_BFu7c_Vp { bool v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aB_BFu7i { bool v1; unsigned int v2:7; };
struct __attribute__((packed)) aB_BFu7i_B { bool v1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aB_BFu7i_BFu15i { bool v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu7i_BFu15ll { bool v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu7i_BFu15s { bool v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu7i_BFu16i { bool v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu7i_BFu16ll { bool v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu7i_BFu16s { bool v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu7i_BFu17i { bool v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu7i_BFu17ll { bool v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu7i_BFu1c { bool v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu7i_BFu1i { bool v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu7i_BFu1ll { bool v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu7i_BFu1s { bool v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu7i_BFu31i { bool v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu7i_BFu31ll { bool v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu7i_BFu32i { bool v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu7i_BFu32ll { bool v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu7i_BFu33 { bool v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu7i_BFu7c { bool v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu7i_BFu7i { bool v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu7i_BFu7ll { bool v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu7i_BFu7s { bool v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu7i_BFu8c { bool v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu7i_BFu8i { bool v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu7i_BFu8ll { bool v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu7i_BFu8s { bool v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu7i_BFu9i { bool v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu7i_BFu9ll { bool v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu7i_BFu9s { bool v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu7i_C { bool v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aB_BFu7i_D { bool v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aB_BFu7i_F { bool v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aB_BFu7i_I { bool v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aB_BFu7i_Ip { bool v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aB_BFu7i_L { bool v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aB_BFu7i_S { bool v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aB_BFu7i_Uc { bool v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aB_BFu7i_Ui { bool v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aB_BFu7i_Ul { bool v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu7i_Us { bool v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aB_BFu7i_Vp { bool v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aB_BFu7ll { bool v1; unsigned long long v2:7; };
struct __attribute__((packed)) aB_BFu7ll_B { bool v1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aB_BFu7ll_BFu15i { bool v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu7ll_BFu15ll { bool v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu7ll_BFu15s { bool v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu7ll_BFu16i { bool v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu7ll_BFu16ll { bool v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu7ll_BFu16s { bool v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu7ll_BFu17i { bool v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu7ll_BFu17ll { bool v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu7ll_BFu1c { bool v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu7ll_BFu1i { bool v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu7ll_BFu1ll { bool v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu7ll_BFu1s { bool v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu7ll_BFu31i { bool v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu7ll_BFu31ll { bool v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu7ll_BFu32i { bool v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu7ll_BFu32ll { bool v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu7ll_BFu33 { bool v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu7ll_BFu7c { bool v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu7ll_BFu7i { bool v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu7ll_BFu7ll { bool v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu7ll_BFu7s { bool v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu7ll_BFu8c { bool v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu7ll_BFu8i { bool v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu7ll_BFu8ll { bool v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu7ll_BFu8s { bool v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu7ll_BFu9i { bool v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu7ll_BFu9ll { bool v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu7ll_BFu9s { bool v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu7ll_C { bool v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aB_BFu7ll_D { bool v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aB_BFu7ll_F { bool v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aB_BFu7ll_I { bool v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aB_BFu7ll_Ip { bool v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aB_BFu7ll_L { bool v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aB_BFu7ll_S { bool v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aB_BFu7ll_Uc { bool v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aB_BFu7ll_Ui { bool v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aB_BFu7ll_Ul { bool v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu7ll_Us { bool v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aB_BFu7ll_Vp { bool v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aB_BFu7s { bool v1; unsigned short v2:7; };
struct __attribute__((packed)) aB_BFu7s_B { bool v1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aB_BFu7s_BFu15i { bool v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu7s_BFu15ll { bool v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu7s_BFu15s { bool v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu7s_BFu16i { bool v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu7s_BFu16ll { bool v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu7s_BFu16s { bool v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu7s_BFu17i { bool v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu7s_BFu17ll { bool v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu7s_BFu1c { bool v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu7s_BFu1i { bool v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu7s_BFu1ll { bool v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu7s_BFu1s { bool v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu7s_BFu31i { bool v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu7s_BFu31ll { bool v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu7s_BFu32i { bool v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu7s_BFu32ll { bool v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu7s_BFu33 { bool v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu7s_BFu7c { bool v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu7s_BFu7i { bool v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu7s_BFu7ll { bool v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu7s_BFu7s { bool v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu7s_BFu8c { bool v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu7s_BFu8i { bool v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu7s_BFu8ll { bool v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu7s_BFu8s { bool v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu7s_BFu9i { bool v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu7s_BFu9ll { bool v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu7s_BFu9s { bool v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu7s_C { bool v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aB_BFu7s_D { bool v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aB_BFu7s_F { bool v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aB_BFu7s_I { bool v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aB_BFu7s_Ip { bool v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aB_BFu7s_L { bool v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aB_BFu7s_S { bool v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aB_BFu7s_Uc { bool v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aB_BFu7s_Ui { bool v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aB_BFu7s_Ul { bool v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu7s_Us { bool v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aB_BFu7s_Vp { bool v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aB_BFu8c { bool v1; unsigned char v2:8; };
struct __attribute__((packed)) aB_BFu8c_B { bool v1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aB_BFu8c_BFu15i { bool v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu8c_BFu15ll { bool v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu8c_BFu15s { bool v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu8c_BFu16i { bool v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu8c_BFu16ll { bool v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu8c_BFu16s { bool v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu8c_BFu17i { bool v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu8c_BFu17ll { bool v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu8c_BFu1c { bool v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu8c_BFu1i { bool v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu8c_BFu1ll { bool v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu8c_BFu1s { bool v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu8c_BFu31i { bool v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu8c_BFu31ll { bool v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu8c_BFu32i { bool v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu8c_BFu32ll { bool v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu8c_BFu33 { bool v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu8c_BFu7c { bool v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu8c_BFu7i { bool v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu8c_BFu7ll { bool v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu8c_BFu7s { bool v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu8c_BFu8c { bool v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu8c_BFu8i { bool v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu8c_BFu8ll { bool v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu8c_BFu8s { bool v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu8c_BFu9i { bool v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu8c_BFu9ll { bool v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu8c_BFu9s { bool v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu8c_C { bool v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aB_BFu8c_D { bool v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aB_BFu8c_F { bool v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aB_BFu8c_I { bool v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aB_BFu8c_Ip { bool v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aB_BFu8c_L { bool v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aB_BFu8c_S { bool v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aB_BFu8c_Uc { bool v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aB_BFu8c_Ui { bool v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aB_BFu8c_Ul { bool v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu8c_Us { bool v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aB_BFu8c_Vp { bool v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aB_BFu8i { bool v1; unsigned int v2:8; };
struct __attribute__((packed)) aB_BFu8i_B { bool v1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aB_BFu8i_BFu15i { bool v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu8i_BFu15ll { bool v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu8i_BFu15s { bool v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu8i_BFu16i { bool v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu8i_BFu16ll { bool v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu8i_BFu16s { bool v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu8i_BFu17i { bool v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu8i_BFu17ll { bool v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu8i_BFu1c { bool v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu8i_BFu1i { bool v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu8i_BFu1ll { bool v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu8i_BFu1s { bool v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu8i_BFu31i { bool v1; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu8i_BFu31ll { bool v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu8i_BFu32i { bool v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu8i_BFu32ll { bool v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu8i_BFu33 { bool v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu8i_BFu7c { bool v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu8i_BFu7i { bool v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu8i_BFu7ll { bool v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu8i_BFu7s { bool v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu8i_BFu8c { bool v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu8i_BFu8i { bool v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu8i_BFu8ll { bool v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu8i_BFu8s { bool v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu8i_BFu9i { bool v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu8i_BFu9ll { bool v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu8i_BFu9s { bool v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu8i_C { bool v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aB_BFu8i_D { bool v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aB_BFu8i_F { bool v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aB_BFu8i_I { bool v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aB_BFu8i_Ip { bool v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aB_BFu8i_L { bool v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aB_BFu8i_S { bool v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aB_BFu8i_Uc { bool v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aB_BFu8i_Ui { bool v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aB_BFu8i_Ul { bool v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu8i_Us { bool v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aB_BFu8i_Vp { bool v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aB_BFu8ll { bool v1; unsigned long long v2:8; };
struct __attribute__((packed)) aB_BFu8ll_B { bool v1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aB_BFu8ll_BFu15i { bool v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu8ll_BFu15ll { bool v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu8ll_BFu15s { bool v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu8ll_BFu16i { bool v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu8ll_BFu16ll { bool v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu8ll_BFu16s { bool v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu8ll_BFu17i { bool v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu8ll_BFu17ll { bool v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu8ll_BFu1c { bool v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu8ll_BFu1i { bool v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu8ll_BFu1ll { bool v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu8ll_BFu1s { bool v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu8ll_BFu31i { bool v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu8ll_BFu31ll { bool v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu8ll_BFu32i { bool v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu8ll_BFu32ll { bool v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu8ll_BFu33 { bool v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu8ll_BFu7c { bool v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu8ll_BFu7i { bool v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu8ll_BFu7ll { bool v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu8ll_BFu7s { bool v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu8ll_BFu8c { bool v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu8ll_BFu8i { bool v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu8ll_BFu8ll { bool v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu8ll_BFu8s { bool v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu8ll_BFu9i { bool v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu8ll_BFu9ll { bool v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu8ll_BFu9s { bool v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu8ll_C { bool v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aB_BFu8ll_D { bool v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aB_BFu8ll_F { bool v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aB_BFu8ll_I { bool v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aB_BFu8ll_Ip { bool v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aB_BFu8ll_L { bool v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aB_BFu8ll_S { bool v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aB_BFu8ll_Uc { bool v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aB_BFu8ll_Ui { bool v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aB_BFu8ll_Ul { bool v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu8ll_Us { bool v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aB_BFu8ll_Vp { bool v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aB_BFu8s { bool v1; unsigned short v2:8; };
struct __attribute__((packed)) aB_BFu8s_B { bool v1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aB_BFu8s_BFu15i { bool v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu8s_BFu15ll { bool v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu8s_BFu15s { bool v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu8s_BFu16i { bool v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu8s_BFu16ll { bool v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu8s_BFu16s { bool v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu8s_BFu17i { bool v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu8s_BFu17ll { bool v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu8s_BFu1c { bool v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu8s_BFu1i { bool v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu8s_BFu1ll { bool v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu8s_BFu1s { bool v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu8s_BFu31i { bool v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu8s_BFu31ll { bool v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu8s_BFu32i { bool v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu8s_BFu32ll { bool v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu8s_BFu33 { bool v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu8s_BFu7c { bool v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu8s_BFu7i { bool v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu8s_BFu7ll { bool v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu8s_BFu7s { bool v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu8s_BFu8c { bool v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu8s_BFu8i { bool v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu8s_BFu8ll { bool v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu8s_BFu8s { bool v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu8s_BFu9i { bool v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu8s_BFu9ll { bool v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu8s_BFu9s { bool v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu8s_C { bool v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aB_BFu8s_D { bool v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aB_BFu8s_F { bool v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aB_BFu8s_I { bool v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aB_BFu8s_Ip { bool v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aB_BFu8s_L { bool v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aB_BFu8s_S { bool v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aB_BFu8s_Uc { bool v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aB_BFu8s_Ui { bool v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aB_BFu8s_Ul { bool v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu8s_Us { bool v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aB_BFu8s_Vp { bool v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aB_BFu9i { bool v1; unsigned int v2:9; };
struct __attribute__((packed)) aB_BFu9i_B { bool v1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aB_BFu9i_BFu15i { bool v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu9i_BFu15ll { bool v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu9i_BFu15s { bool v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu9i_BFu16i { bool v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu9i_BFu16ll { bool v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu9i_BFu16s { bool v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu9i_BFu17i { bool v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu9i_BFu17ll { bool v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu9i_BFu1c { bool v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu9i_BFu1i { bool v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu9i_BFu1ll { bool v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu9i_BFu1s { bool v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu9i_BFu31i { bool v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu9i_BFu31ll { bool v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu9i_BFu32i { bool v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu9i_BFu32ll { bool v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu9i_BFu33 { bool v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu9i_BFu7c { bool v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu9i_BFu7i { bool v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu9i_BFu7ll { bool v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu9i_BFu7s { bool v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu9i_BFu8c { bool v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu9i_BFu8i { bool v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu9i_BFu8ll { bool v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu9i_BFu8s { bool v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu9i_BFu9i { bool v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu9i_BFu9ll { bool v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu9i_BFu9s { bool v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu9i_C { bool v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aB_BFu9i_D { bool v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aB_BFu9i_F { bool v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aB_BFu9i_I { bool v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aB_BFu9i_Ip { bool v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aB_BFu9i_L { bool v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aB_BFu9i_S { bool v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aB_BFu9i_Uc { bool v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aB_BFu9i_Ui { bool v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aB_BFu9i_Ul { bool v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu9i_Us { bool v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aB_BFu9i_Vp { bool v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aB_BFu9ll { bool v1; unsigned long long v2:9; };
struct __attribute__((packed)) aB_BFu9ll_B { bool v1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aB_BFu9ll_BFu15i { bool v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu9ll_BFu15ll { bool v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu9ll_BFu15s { bool v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu9ll_BFu16i { bool v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu9ll_BFu16ll { bool v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu9ll_BFu16s { bool v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu9ll_BFu17i { bool v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu9ll_BFu17ll { bool v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu9ll_BFu1c { bool v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu9ll_BFu1i { bool v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu9ll_BFu1ll { bool v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu9ll_BFu1s { bool v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu9ll_BFu31i { bool v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu9ll_BFu31ll { bool v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu9ll_BFu32i { bool v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu9ll_BFu32ll { bool v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu9ll_BFu33 { bool v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu9ll_BFu7c { bool v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu9ll_BFu7i { bool v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu9ll_BFu7ll { bool v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu9ll_BFu7s { bool v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu9ll_BFu8c { bool v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu9ll_BFu8i { bool v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu9ll_BFu8ll { bool v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu9ll_BFu8s { bool v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu9ll_BFu9i { bool v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu9ll_BFu9ll { bool v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu9ll_BFu9s { bool v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu9ll_C { bool v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aB_BFu9ll_D { bool v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aB_BFu9ll_F { bool v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aB_BFu9ll_I { bool v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aB_BFu9ll_Ip { bool v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aB_BFu9ll_L { bool v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aB_BFu9ll_S { bool v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aB_BFu9ll_Uc { bool v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aB_BFu9ll_Ui { bool v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aB_BFu9ll_Ul { bool v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu9ll_Us { bool v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aB_BFu9ll_Vp { bool v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aB_BFu9s { bool v1; unsigned short v2:9; };
struct __attribute__((packed)) aB_BFu9s_B { bool v1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aB_BFu9s_BFu15i { bool v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aB_BFu9s_BFu15ll { bool v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aB_BFu9s_BFu15s { bool v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aB_BFu9s_BFu16i { bool v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aB_BFu9s_BFu16ll { bool v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aB_BFu9s_BFu16s { bool v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aB_BFu9s_BFu17i { bool v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aB_BFu9s_BFu17ll { bool v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aB_BFu9s_BFu1c { bool v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aB_BFu9s_BFu1i { bool v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aB_BFu9s_BFu1ll { bool v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aB_BFu9s_BFu1s { bool v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aB_BFu9s_BFu31i { bool v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aB_BFu9s_BFu31ll { bool v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aB_BFu9s_BFu32i { bool v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aB_BFu9s_BFu32ll { bool v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aB_BFu9s_BFu33 { bool v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aB_BFu9s_BFu7c { bool v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aB_BFu9s_BFu7i { bool v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aB_BFu9s_BFu7ll { bool v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aB_BFu9s_BFu7s { bool v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aB_BFu9s_BFu8c { bool v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aB_BFu9s_BFu8i { bool v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aB_BFu9s_BFu8ll { bool v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aB_BFu9s_BFu8s { bool v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aB_BFu9s_BFu9i { bool v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aB_BFu9s_BFu9ll { bool v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aB_BFu9s_BFu9s { bool v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aB_BFu9s_C { bool v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aB_BFu9s_D { bool v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aB_BFu9s_F { bool v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aB_BFu9s_I { bool v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aB_BFu9s_Ip { bool v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aB_BFu9s_L { bool v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aB_BFu9s_S { bool v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aB_BFu9s_Uc { bool v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aB_BFu9s_Ui { bool v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aB_BFu9s_Ul { bool v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aB_BFu9s_Us { bool v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aB_BFu9s_Vp { bool v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aB_C { bool v1; char v2; };
struct __attribute__((packed)) aB_C_B { bool v1; char v2; bool v3; };
struct __attribute__((packed)) aB_C_BFu15i { bool v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aB_C_BFu15ll { bool v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aB_C_BFu15s { bool v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aB_C_BFu16i { bool v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aB_C_BFu16ll { bool v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aB_C_BFu16s { bool v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aB_C_BFu17i { bool v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aB_C_BFu17ll { bool v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aB_C_BFu1c { bool v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aB_C_BFu1i { bool v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aB_C_BFu1ll { bool v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aB_C_BFu1s { bool v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aB_C_BFu31i { bool v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aB_C_BFu31ll { bool v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aB_C_BFu32i { bool v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aB_C_BFu32ll { bool v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aB_C_BFu33 { bool v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aB_C_BFu7c { bool v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aB_C_BFu7i { bool v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aB_C_BFu7ll { bool v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aB_C_BFu7s { bool v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aB_C_BFu8c { bool v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aB_C_BFu8i { bool v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aB_C_BFu8ll { bool v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aB_C_BFu8s { bool v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aB_C_BFu9i { bool v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aB_C_BFu9ll { bool v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aB_C_BFu9s { bool v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aB_C_C { bool v1; char v2; char v3; };
struct __attribute__((packed)) aB_C_D { bool v1; char v2; double v3; };
struct __attribute__((packed)) aB_C_F { bool v1; char v2; float v3; };
struct __attribute__((packed)) aB_C_I { bool v1; char v2; int v3; };
struct __attribute__((packed)) aB_C_Ip { bool v1; char v2; int * v3; };
struct __attribute__((packed)) aB_C_L { bool v1; char v2; long long v3; };
struct __attribute__((packed)) aB_C_S { bool v1; char v2; short v3; };
struct __attribute__((packed)) aB_C_Uc { bool v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aB_C_Ui { bool v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aB_C_Ul { bool v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aB_C_Us { bool v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aB_C_Vp { bool v1; char v2; void * v3; };
struct __attribute__((packed)) aB_D { bool v1; double v2; };
struct __attribute__((packed)) aB_D_B { bool v1; double v2; bool v3; };
struct __attribute__((packed)) aB_D_BFu15i { bool v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aB_D_BFu15ll { bool v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aB_D_BFu15s { bool v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aB_D_BFu16i { bool v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aB_D_BFu16ll { bool v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aB_D_BFu16s { bool v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aB_D_BFu17i { bool v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aB_D_BFu17ll { bool v1; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aB_D_BFu1c { bool v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aB_D_BFu1i { bool v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aB_D_BFu1ll { bool v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aB_D_BFu1s { bool v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aB_D_BFu31i { bool v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aB_D_BFu31ll { bool v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aB_D_BFu32i { bool v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aB_D_BFu32ll { bool v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aB_D_BFu33 { bool v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aB_D_BFu7c { bool v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aB_D_BFu7i { bool v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aB_D_BFu7ll { bool v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aB_D_BFu7s { bool v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aB_D_BFu8c { bool v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aB_D_BFu8i { bool v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aB_D_BFu8ll { bool v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aB_D_BFu8s { bool v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aB_D_BFu9i { bool v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aB_D_BFu9ll { bool v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aB_D_BFu9s { bool v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aB_D_C { bool v1; double v2; char v3; };
struct __attribute__((packed)) aB_D_D { bool v1; double v2; double v3; };
struct __attribute__((packed)) aB_D_F { bool v1; double v2; float v3; };
struct __attribute__((packed)) aB_D_I { bool v1; double v2; int v3; };
struct __attribute__((packed)) aB_D_Ip { bool v1; double v2; int * v3; };
struct __attribute__((packed)) aB_D_L { bool v1; double v2; long long v3; };
struct __attribute__((packed)) aB_D_S { bool v1; double v2; short v3; };
struct __attribute__((packed)) aB_D_Uc { bool v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aB_D_Ui { bool v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aB_D_Ul { bool v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aB_D_Us { bool v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aB_D_Vp { bool v1; double v2; void * v3; };
struct __attribute__((packed)) aB_F { bool v1; float v2; };
struct __attribute__((packed)) aB_F_B { bool v1; float v2; bool v3; };
struct __attribute__((packed)) aB_F_BFu15i { bool v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aB_F_BFu15ll { bool v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aB_F_BFu15s { bool v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aB_F_BFu16i { bool v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aB_F_BFu16ll { bool v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aB_F_BFu16s { bool v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aB_F_BFu17i { bool v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aB_F_BFu17ll { bool v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aB_F_BFu1c { bool v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aB_F_BFu1i { bool v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aB_F_BFu1ll { bool v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aB_F_BFu1s { bool v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aB_F_BFu31i { bool v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aB_F_BFu31ll { bool v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aB_F_BFu32i { bool v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aB_F_BFu32ll { bool v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aB_F_BFu33 { bool v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aB_F_BFu7c { bool v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aB_F_BFu7i { bool v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aB_F_BFu7ll { bool v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aB_F_BFu7s { bool v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aB_F_BFu8c { bool v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aB_F_BFu8i { bool v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aB_F_BFu8ll { bool v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aB_F_BFu8s { bool v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aB_F_BFu9i { bool v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aB_F_BFu9ll { bool v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aB_F_BFu9s { bool v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aB_F_C { bool v1; float v2; char v3; };
struct __attribute__((packed)) aB_F_D { bool v1; float v2; double v3; };
struct __attribute__((packed)) aB_F_F { bool v1; float v2; float v3; };
struct __attribute__((packed)) aB_F_I { bool v1; float v2; int v3; };
struct __attribute__((packed)) aB_F_Ip { bool v1; float v2; int * v3; };
struct __attribute__((packed)) aB_F_L { bool v1; float v2; long long v3; };
struct __attribute__((packed)) aB_F_S { bool v1; float v2; short v3; };
struct __attribute__((packed)) aB_F_Uc { bool v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aB_F_Ui { bool v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aB_F_Ul { bool v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aB_F_Us { bool v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aB_F_Vp { bool v1; float v2; void * v3; };
struct __attribute__((packed)) aB_I { bool v1; int v2; };
struct __attribute__((packed)) aB_I_B { bool v1; int v2; bool v3; };
struct __attribute__((packed)) aB_I_BFu15i { bool v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aB_I_BFu15ll { bool v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aB_I_BFu15s { bool v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aB_I_BFu16i { bool v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aB_I_BFu16ll { bool v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aB_I_BFu16s { bool v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aB_I_BFu17i { bool v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aB_I_BFu17ll { bool v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aB_I_BFu1c { bool v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aB_I_BFu1i { bool v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aB_I_BFu1ll { bool v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aB_I_BFu1s { bool v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aB_I_BFu31i { bool v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aB_I_BFu31ll { bool v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aB_I_BFu32i { bool v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aB_I_BFu32ll { bool v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aB_I_BFu33 { bool v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aB_I_BFu7c { bool v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aB_I_BFu7i { bool v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aB_I_BFu7ll { bool v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aB_I_BFu7s { bool v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aB_I_BFu8c { bool v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aB_I_BFu8i { bool v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aB_I_BFu8ll { bool v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aB_I_BFu8s { bool v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aB_I_BFu9i { bool v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aB_I_BFu9ll { bool v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aB_I_BFu9s { bool v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aB_I_C { bool v1; int v2; char v3; };
struct __attribute__((packed)) aB_I_D { bool v1; int v2; double v3; };
struct __attribute__((packed)) aB_I_F { bool v1; int v2; float v3; };
struct __attribute__((packed)) aB_I_I { bool v1; int v2; int v3; };
struct __attribute__((packed)) aB_I_Ip { bool v1; int v2; int * v3; };
struct __attribute__((packed)) aB_I_L { bool v1; int v2; long long v3; };
struct __attribute__((packed)) aB_I_S { bool v1; int v2; short v3; };
struct __attribute__((packed)) aB_I_Uc { bool v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aB_I_Ui { bool v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aB_I_Ul { bool v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aB_I_Us { bool v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aB_I_Vp { bool v1; int v2; void * v3; };
struct __attribute__((packed)) aB_Ip { bool v1; int * v2; };
struct __attribute__((packed)) aB_Ip_B { bool v1; int * v2; bool v3; };
struct __attribute__((packed)) aB_Ip_BFu15i { bool v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aB_Ip_BFu15ll { bool v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aB_Ip_BFu15s { bool v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aB_Ip_BFu16i { bool v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aB_Ip_BFu16ll { bool v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aB_Ip_BFu16s { bool v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aB_Ip_BFu17i { bool v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aB_Ip_BFu17ll { bool v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aB_Ip_BFu1c { bool v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aB_Ip_BFu1i { bool v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aB_Ip_BFu1ll { bool v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aB_Ip_BFu1s { bool v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aB_Ip_BFu31i { bool v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aB_Ip_BFu31ll { bool v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aB_Ip_BFu32i { bool v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aB_Ip_BFu32ll { bool v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aB_Ip_BFu33 { bool v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aB_Ip_BFu7c { bool v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aB_Ip_BFu7i { bool v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aB_Ip_BFu7ll { bool v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aB_Ip_BFu7s { bool v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aB_Ip_BFu8c { bool v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aB_Ip_BFu8i { bool v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aB_Ip_BFu8ll { bool v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aB_Ip_BFu8s { bool v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aB_Ip_BFu9i { bool v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aB_Ip_BFu9ll { bool v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aB_Ip_BFu9s { bool v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aB_Ip_C { bool v1; int * v2; char v3; };
struct __attribute__((packed)) aB_Ip_D { bool v1; int * v2; double v3; };
struct __attribute__((packed)) aB_Ip_F { bool v1; int * v2; float v3; };
struct __attribute__((packed)) aB_Ip_I { bool v1; int * v2; int v3; };
struct __attribute__((packed)) aB_Ip_Ip { bool v1; int * v2; int * v3; };
struct __attribute__((packed)) aB_Ip_L { bool v1; int * v2; long long v3; };
struct __attribute__((packed)) aB_Ip_S { bool v1; int * v2; short v3; };
struct __attribute__((packed)) aB_Ip_Uc { bool v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aB_Ip_Ui { bool v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aB_Ip_Ul { bool v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aB_Ip_Us { bool v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aB_Ip_Vp { bool v1; int * v2; void * v3; };
struct __attribute__((packed)) aB_L { bool v1; long long v2; };
struct __attribute__((packed)) aB_L_B { bool v1; long long v2; bool v3; };
struct __attribute__((packed)) aB_L_BFu15i { bool v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aB_L_BFu15ll { bool v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aB_L_BFu15s { bool v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aB_L_BFu16i { bool v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aB_L_BFu16ll { bool v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aB_L_BFu16s { bool v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aB_L_BFu17i { bool v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aB_L_BFu17ll { bool v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aB_L_BFu1c { bool v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aB_L_BFu1i { bool v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aB_L_BFu1ll { bool v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aB_L_BFu1s { bool v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aB_L_BFu31i { bool v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aB_L_BFu31ll { bool v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aB_L_BFu32i { bool v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aB_L_BFu32ll { bool v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aB_L_BFu33 { bool v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aB_L_BFu7c { bool v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aB_L_BFu7i { bool v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aB_L_BFu7ll { bool v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aB_L_BFu7s { bool v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aB_L_BFu8c { bool v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aB_L_BFu8i { bool v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aB_L_BFu8ll { bool v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aB_L_BFu8s { bool v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aB_L_BFu9i { bool v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aB_L_BFu9ll { bool v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aB_L_BFu9s { bool v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aB_L_C { bool v1; long long v2; char v3; };
struct __attribute__((packed)) aB_L_D { bool v1; long long v2; double v3; };
struct __attribute__((packed)) aB_L_F { bool v1; long long v2; float v3; };
struct __attribute__((packed)) aB_L_I { bool v1; long long v2; int v3; };
struct __attribute__((packed)) aB_L_Ip { bool v1; long long v2; int * v3; };
struct __attribute__((packed)) aB_L_L { bool v1; long long v2; long long v3; };
struct __attribute__((packed)) aB_L_S { bool v1; long long v2; short v3; };
struct __attribute__((packed)) aB_L_Uc { bool v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aB_L_Ui { bool v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aB_L_Ul { bool v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aB_L_Us { bool v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aB_L_Vp { bool v1; long long v2; void * v3; };
struct __attribute__((packed)) aB_S { bool v1; short v2; };
struct __attribute__((packed)) aB_S_B { bool v1; short v2; bool v3; };
struct __attribute__((packed)) aB_S_BFu15i { bool v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aB_S_BFu15ll { bool v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aB_S_BFu15s { bool v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aB_S_BFu16i { bool v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aB_S_BFu16ll { bool v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aB_S_BFu16s { bool v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aB_S_BFu17i { bool v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aB_S_BFu17ll { bool v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aB_S_BFu1c { bool v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aB_S_BFu1i { bool v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aB_S_BFu1ll { bool v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aB_S_BFu1s { bool v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aB_S_BFu31i { bool v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aB_S_BFu31ll { bool v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aB_S_BFu32i { bool v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aB_S_BFu32ll { bool v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aB_S_BFu33 { bool v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aB_S_BFu7c { bool v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aB_S_BFu7i { bool v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aB_S_BFu7ll { bool v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aB_S_BFu7s { bool v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aB_S_BFu8c { bool v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aB_S_BFu8i { bool v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aB_S_BFu8ll { bool v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aB_S_BFu8s { bool v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aB_S_BFu9i { bool v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aB_S_BFu9ll { bool v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aB_S_BFu9s { bool v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aB_S_C { bool v1; short v2; char v3; };
struct __attribute__((packed)) aB_S_D { bool v1; short v2; double v3; };
struct __attribute__((packed)) aB_S_F { bool v1; short v2; float v3; };
struct __attribute__((packed)) aB_S_I { bool v1; short v2; int v3; };
struct __attribute__((packed)) aB_S_Ip { bool v1; short v2; int * v3; };
struct __attribute__((packed)) aB_S_L { bool v1; short v2; long long v3; };
struct __attribute__((packed)) aB_S_S { bool v1; short v2; short v3; };
struct __attribute__((packed)) aB_S_Uc { bool v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aB_S_Ui { bool v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aB_S_Ul { bool v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aB_S_Us { bool v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aB_S_Vp { bool v1; short v2; void * v3; };
struct __attribute__((packed)) aB_Uc { bool v1; unsigned char v2; };
struct __attribute__((packed)) aB_Uc_B { bool v1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aB_Uc_BFu15i { bool v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aB_Uc_BFu15ll { bool v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aB_Uc_BFu15s { bool v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aB_Uc_BFu16i { bool v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aB_Uc_BFu16ll { bool v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aB_Uc_BFu16s { bool v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aB_Uc_BFu17i { bool v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aB_Uc_BFu17ll { bool v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aB_Uc_BFu1c { bool v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aB_Uc_BFu1i { bool v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aB_Uc_BFu1ll { bool v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aB_Uc_BFu1s { bool v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aB_Uc_BFu31i { bool v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aB_Uc_BFu31ll { bool v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aB_Uc_BFu32i { bool v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aB_Uc_BFu32ll { bool v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aB_Uc_BFu33 { bool v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aB_Uc_BFu7c { bool v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aB_Uc_BFu7i { bool v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aB_Uc_BFu7ll { bool v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aB_Uc_BFu7s { bool v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aB_Uc_BFu8c { bool v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aB_Uc_BFu8i { bool v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aB_Uc_BFu8ll { bool v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aB_Uc_BFu8s { bool v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aB_Uc_BFu9i { bool v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aB_Uc_BFu9ll { bool v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aB_Uc_BFu9s { bool v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aB_Uc_C { bool v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aB_Uc_D { bool v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aB_Uc_F { bool v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aB_Uc_I { bool v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aB_Uc_Ip { bool v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aB_Uc_L { bool v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aB_Uc_S { bool v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aB_Uc_Uc { bool v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aB_Uc_Ui { bool v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aB_Uc_Ul { bool v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aB_Uc_Us { bool v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aB_Uc_Vp { bool v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aB_Ui { bool v1; unsigned int v2; };
struct __attribute__((packed)) aB_Ui_B { bool v1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aB_Ui_BFu15i { bool v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aB_Ui_BFu15ll { bool v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aB_Ui_BFu15s { bool v1; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aB_Ui_BFu16i { bool v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aB_Ui_BFu16ll { bool v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aB_Ui_BFu16s { bool v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aB_Ui_BFu17i { bool v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aB_Ui_BFu17ll { bool v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aB_Ui_BFu1c { bool v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aB_Ui_BFu1i { bool v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aB_Ui_BFu1ll { bool v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aB_Ui_BFu1s { bool v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aB_Ui_BFu31i { bool v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aB_Ui_BFu31ll { bool v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aB_Ui_BFu32i { bool v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aB_Ui_BFu32ll { bool v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aB_Ui_BFu33 { bool v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aB_Ui_BFu7c { bool v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aB_Ui_BFu7i { bool v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aB_Ui_BFu7ll { bool v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aB_Ui_BFu7s { bool v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aB_Ui_BFu8c { bool v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aB_Ui_BFu8i { bool v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aB_Ui_BFu8ll { bool v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aB_Ui_BFu8s { bool v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aB_Ui_BFu9i { bool v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aB_Ui_BFu9ll { bool v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aB_Ui_BFu9s { bool v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aB_Ui_C { bool v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aB_Ui_D { bool v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aB_Ui_F { bool v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aB_Ui_I { bool v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aB_Ui_Ip { bool v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aB_Ui_L { bool v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aB_Ui_S { bool v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aB_Ui_Uc { bool v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aB_Ui_Ui { bool v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aB_Ui_Ul { bool v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aB_Ui_Us { bool v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aB_Ui_Vp { bool v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aB_Ul { bool v1; unsigned long long v2; };
struct __attribute__((packed)) aB_Ul_B { bool v1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aB_Ul_BFu15i { bool v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aB_Ul_BFu15ll { bool v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aB_Ul_BFu15s { bool v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aB_Ul_BFu16i { bool v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aB_Ul_BFu16ll { bool v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aB_Ul_BFu16s { bool v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aB_Ul_BFu17i { bool v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aB_Ul_BFu17ll { bool v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aB_Ul_BFu1c { bool v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aB_Ul_BFu1i { bool v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aB_Ul_BFu1ll { bool v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aB_Ul_BFu1s { bool v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aB_Ul_BFu31i { bool v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aB_Ul_BFu31ll { bool v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aB_Ul_BFu32i { bool v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aB_Ul_BFu32ll { bool v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aB_Ul_BFu33 { bool v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aB_Ul_BFu7c { bool v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aB_Ul_BFu7i { bool v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aB_Ul_BFu7ll { bool v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aB_Ul_BFu7s { bool v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aB_Ul_BFu8c { bool v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aB_Ul_BFu8i { bool v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aB_Ul_BFu8ll { bool v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aB_Ul_BFu8s { bool v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aB_Ul_BFu9i { bool v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aB_Ul_BFu9ll { bool v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aB_Ul_BFu9s { bool v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aB_Ul_C { bool v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aB_Ul_D { bool v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aB_Ul_F { bool v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aB_Ul_I { bool v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aB_Ul_Ip { bool v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aB_Ul_L { bool v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aB_Ul_S { bool v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aB_Ul_Uc { bool v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aB_Ul_Ui { bool v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aB_Ul_Ul { bool v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aB_Ul_Us { bool v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aB_Ul_Vp { bool v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aB_Us { bool v1; unsigned short v2; };
struct __attribute__((packed)) aB_Us_B { bool v1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aB_Us_BFu15i { bool v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aB_Us_BFu15ll { bool v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aB_Us_BFu15s { bool v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aB_Us_BFu16i { bool v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aB_Us_BFu16ll { bool v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aB_Us_BFu16s { bool v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aB_Us_BFu17i { bool v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aB_Us_BFu17ll { bool v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aB_Us_BFu1c { bool v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aB_Us_BFu1i { bool v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aB_Us_BFu1ll { bool v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aB_Us_BFu1s { bool v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aB_Us_BFu31i { bool v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aB_Us_BFu31ll { bool v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aB_Us_BFu32i { bool v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aB_Us_BFu32ll { bool v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aB_Us_BFu33 { bool v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aB_Us_BFu7c { bool v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aB_Us_BFu7i { bool v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aB_Us_BFu7ll { bool v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aB_Us_BFu7s { bool v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aB_Us_BFu8c { bool v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aB_Us_BFu8i { bool v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aB_Us_BFu8ll { bool v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aB_Us_BFu8s { bool v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aB_Us_BFu9i { bool v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aB_Us_BFu9ll { bool v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aB_Us_BFu9s { bool v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aB_Us_C { bool v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aB_Us_D { bool v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aB_Us_F { bool v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aB_Us_I { bool v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aB_Us_Ip { bool v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aB_Us_L { bool v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aB_Us_S { bool v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aB_Us_Uc { bool v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aB_Us_Ui { bool v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aB_Us_Ul { bool v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aB_Us_Us { bool v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aB_Us_Vp { bool v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aB_Vp { bool v1; void * v2; };
struct __attribute__((packed)) aB_Vp_B { bool v1; void * v2; bool v3; };
struct __attribute__((packed)) aB_Vp_BFu15i { bool v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aB_Vp_BFu15ll { bool v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aB_Vp_BFu15s { bool v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aB_Vp_BFu16i { bool v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aB_Vp_BFu16ll { bool v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aB_Vp_BFu16s { bool v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aB_Vp_BFu17i { bool v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aB_Vp_BFu17ll { bool v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aB_Vp_BFu1c { bool v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aB_Vp_BFu1i { bool v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aB_Vp_BFu1ll { bool v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aB_Vp_BFu1s { bool v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aB_Vp_BFu31i { bool v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aB_Vp_BFu31ll { bool v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aB_Vp_BFu32i { bool v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aB_Vp_BFu32ll { bool v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aB_Vp_BFu33 { bool v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aB_Vp_BFu7c { bool v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aB_Vp_BFu7i { bool v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aB_Vp_BFu7ll { bool v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aB_Vp_BFu7s { bool v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aB_Vp_BFu8c { bool v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aB_Vp_BFu8i { bool v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aB_Vp_BFu8ll { bool v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aB_Vp_BFu8s { bool v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aB_Vp_BFu9i { bool v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aB_Vp_BFu9ll { bool v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aB_Vp_BFu9s { bool v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aB_Vp_C { bool v1; void * v2; char v3; };
struct __attribute__((packed)) aB_Vp_D { bool v1; void * v2; double v3; };
struct __attribute__((packed)) aB_Vp_F { bool v1; void * v2; float v3; };
struct __attribute__((packed)) aB_Vp_I { bool v1; void * v2; int v3; };
struct __attribute__((packed)) aB_Vp_Ip { bool v1; void * v2; int * v3; };
struct __attribute__((packed)) aB_Vp_L { bool v1; void * v2; long long v3; };
struct __attribute__((packed)) aB_Vp_S { bool v1; void * v2; short v3; };
struct __attribute__((packed)) aB_Vp_Uc { bool v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aB_Vp_Ui { bool v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aB_Vp_Ul { bool v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aB_Vp_Us { bool v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aB_Vp_Vp { bool v1; void * v2; void * v3; };
struct __attribute__((packed)) aBFu15i_B { unsigned int v1:15; bool v2; };
struct __attribute__((packed)) aBFu15i_B_B { unsigned int v1:15; bool v2; bool v3; };
struct __attribute__((packed)) aBFu15i_B_BFu15i { unsigned int v1:15; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu15i_B_BFu15ll { unsigned int v1:15; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu15i_B_BFu15s { unsigned int v1:15; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu15i_B_BFu16i { unsigned int v1:15; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu15i_B_BFu16ll { unsigned int v1:15; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu15i_B_BFu16s { unsigned int v1:15; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu15i_B_BFu17i { unsigned int v1:15; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu15i_B_BFu17ll { unsigned int v1:15; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu15i_B_BFu1c { unsigned int v1:15; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu15i_B_BFu1i { unsigned int v1:15; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu15i_B_BFu1ll { unsigned int v1:15; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu15i_B_BFu1s { unsigned int v1:15; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu15i_B_BFu31i { unsigned int v1:15; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu15i_B_BFu31ll { unsigned int v1:15; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu15i_B_BFu32i { unsigned int v1:15; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu15i_B_BFu32ll { unsigned int v1:15; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu15i_B_BFu33 { unsigned int v1:15; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu15i_B_BFu7c { unsigned int v1:15; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu15i_B_BFu7i { unsigned int v1:15; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu15i_B_BFu7ll { unsigned int v1:15; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu15i_B_BFu7s { unsigned int v1:15; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu15i_B_BFu8c { unsigned int v1:15; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu15i_B_BFu8i { unsigned int v1:15; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu15i_B_BFu8ll { unsigned int v1:15; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu15i_B_BFu8s { unsigned int v1:15; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu15i_B_BFu9i { unsigned int v1:15; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu15i_B_BFu9ll { unsigned int v1:15; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu15i_B_BFu9s { unsigned int v1:15; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu15i_B_C { unsigned int v1:15; bool v2; char v3; };
struct __attribute__((packed)) aBFu15i_B_D { unsigned int v1:15; bool v2; double v3; };
struct __attribute__((packed)) aBFu15i_B_F { unsigned int v1:15; bool v2; float v3; };
struct __attribute__((packed)) aBFu15i_B_I { unsigned int v1:15; bool v2; int v3; };
struct __attribute__((packed)) aBFu15i_B_Ip { unsigned int v1:15; bool v2; int * v3; };
struct __attribute__((packed)) aBFu15i_B_L { unsigned int v1:15; bool v2; long long v3; };
struct __attribute__((packed)) aBFu15i_B_S { unsigned int v1:15; bool v2; short v3; };
struct __attribute__((packed)) aBFu15i_B_Uc { unsigned int v1:15; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu15i_B_Ui { unsigned int v1:15; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu15i_B_Ul { unsigned int v1:15; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu15i_B_Us { unsigned int v1:15; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu15i_B_Vp { unsigned int v1:15; bool v2; void * v3; };
struct __attribute__((packed)) aBFu15i_BFu15i_B { unsigned int v1:15; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu15ll_B { unsigned int v1:15; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu15s_B { unsigned int v1:15; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu16i_B { unsigned int v1:15; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu16ll_B { unsigned int v1:15; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu16s_B { unsigned int v1:15; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu17i_B { unsigned int v1:15; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu17ll_B { unsigned int v1:15; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu1c_B { unsigned int v1:15; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu1i_B { unsigned int v1:15; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu1ll_B { unsigned int v1:15; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu1s_B { unsigned int v1:15; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu31i_B { unsigned int v1:15; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu31ll_B { unsigned int v1:15; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu32i_B { unsigned int v1:15; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu32ll_B { unsigned int v1:15; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu33_B { unsigned int v1:15; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu7c_B { unsigned int v1:15; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu7i_B { unsigned int v1:15; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu7ll_B { unsigned int v1:15; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu7s_B { unsigned int v1:15; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu8c_B { unsigned int v1:15; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu8i_B { unsigned int v1:15; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu8ll_B { unsigned int v1:15; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu8s_B { unsigned int v1:15; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu9i_B { unsigned int v1:15; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu9ll_B { unsigned int v1:15; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu15i_BFu9s_B { unsigned int v1:15; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu15i_C_B { unsigned int v1:15; char v2; bool v3; };
struct __attribute__((packed)) aBFu15i_D_B { unsigned int v1:15; double v2; bool v3; };
struct __attribute__((packed)) aBFu15i_F_B { unsigned int v1:15; float v2; bool v3; };
struct __attribute__((packed)) aBFu15i_I_B { unsigned int v1:15; int v2; bool v3; };
struct __attribute__((packed)) aBFu15i_Ip_B { unsigned int v1:15; int * v2; bool v3; };
struct __attribute__((packed)) aBFu15i_L_B { unsigned int v1:15; long long v2; bool v3; };
struct __attribute__((packed)) aBFu15i_S_B { unsigned int v1:15; short v2; bool v3; };
struct __attribute__((packed)) aBFu15i_Uc_B { unsigned int v1:15; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu15i_Ui_B { unsigned int v1:15; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu15i_Ul_B { unsigned int v1:15; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu15i_Us_B { unsigned int v1:15; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu15i_Vp_B { unsigned int v1:15; void * v2; bool v3; };
struct __attribute__((packed)) aBFu15ll_B { unsigned long long v1:15; bool v2; };
struct __attribute__((packed)) aBFu15ll_B_B { unsigned long long v1:15; bool v2; bool v3; };
struct __attribute__((packed)) aBFu15ll_B_BFu15i { unsigned long long v1:15; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu15ll_B_BFu15ll { unsigned long long v1:15; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu15ll_B_BFu15s { unsigned long long v1:15; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu15ll_B_BFu16i { unsigned long long v1:15; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu15ll_B_BFu16ll { unsigned long long v1:15; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu15ll_B_BFu16s { unsigned long long v1:15; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu15ll_B_BFu17i { unsigned long long v1:15; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu15ll_B_BFu17ll { unsigned long long v1:15; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu15ll_B_BFu1c { unsigned long long v1:15; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu15ll_B_BFu1i { unsigned long long v1:15; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu15ll_B_BFu1ll { unsigned long long v1:15; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu15ll_B_BFu1s { unsigned long long v1:15; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu15ll_B_BFu31i { unsigned long long v1:15; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu15ll_B_BFu31ll { unsigned long long v1:15; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu15ll_B_BFu32i { unsigned long long v1:15; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu15ll_B_BFu32ll { unsigned long long v1:15; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu15ll_B_BFu33 { unsigned long long v1:15; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu15ll_B_BFu7c { unsigned long long v1:15; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu15ll_B_BFu7i { unsigned long long v1:15; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu15ll_B_BFu7ll { unsigned long long v1:15; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu15ll_B_BFu7s { unsigned long long v1:15; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu15ll_B_BFu8c { unsigned long long v1:15; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu15ll_B_BFu8i { unsigned long long v1:15; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu15ll_B_BFu8ll { unsigned long long v1:15; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu15ll_B_BFu8s { unsigned long long v1:15; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu15ll_B_BFu9i { unsigned long long v1:15; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu15ll_B_BFu9ll { unsigned long long v1:15; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu15ll_B_BFu9s { unsigned long long v1:15; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu15ll_B_C { unsigned long long v1:15; bool v2; char v3; };
struct __attribute__((packed)) aBFu15ll_B_D { unsigned long long v1:15; bool v2; double v3; };
struct __attribute__((packed)) aBFu15ll_B_F { unsigned long long v1:15; bool v2; float v3; };
struct __attribute__((packed)) aBFu15ll_B_I { unsigned long long v1:15; bool v2; int v3; };
struct __attribute__((packed)) aBFu15ll_B_Ip { unsigned long long v1:15; bool v2; int * v3; };
struct __attribute__((packed)) aBFu15ll_B_L { unsigned long long v1:15; bool v2; long long v3; };
struct __attribute__((packed)) aBFu15ll_B_S { unsigned long long v1:15; bool v2; short v3; };
struct __attribute__((packed)) aBFu15ll_B_Uc { unsigned long long v1:15; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu15ll_B_Ui { unsigned long long v1:15; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu15ll_B_Ul { unsigned long long v1:15; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu15ll_B_Us { unsigned long long v1:15; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu15ll_B_Vp { unsigned long long v1:15; bool v2; void * v3; };
struct __attribute__((packed)) aBFu15ll_BFu15i_B { unsigned long long v1:15; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu15ll_B { unsigned long long v1:15; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu15s_B { unsigned long long v1:15; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu16i_B { unsigned long long v1:15; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu16ll_B { unsigned long long v1:15; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu16s_B { unsigned long long v1:15; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu17i_B { unsigned long long v1:15; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu17ll_B { unsigned long long v1:15; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu1c_B { unsigned long long v1:15; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu1i_B { unsigned long long v1:15; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu1ll_B { unsigned long long v1:15; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu1s_B { unsigned long long v1:15; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu31i_B { unsigned long long v1:15; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu31ll_B { unsigned long long v1:15; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu32i_B { unsigned long long v1:15; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu32ll_B { unsigned long long v1:15; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu33_B { unsigned long long v1:15; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu7c_B { unsigned long long v1:15; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu7i_B { unsigned long long v1:15; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu7ll_B { unsigned long long v1:15; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu7s_B { unsigned long long v1:15; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu8c_B { unsigned long long v1:15; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu8i_B { unsigned long long v1:15; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu8ll_B { unsigned long long v1:15; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu8s_B { unsigned long long v1:15; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu9i_B { unsigned long long v1:15; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu9ll_B { unsigned long long v1:15; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu15ll_BFu9s_B { unsigned long long v1:15; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu15ll_C_B { unsigned long long v1:15; char v2; bool v3; };
struct __attribute__((packed)) aBFu15ll_D_B { unsigned long long v1:15; double v2; bool v3; };
struct __attribute__((packed)) aBFu15ll_F_B { unsigned long long v1:15; float v2; bool v3; };
struct __attribute__((packed)) aBFu15ll_I_B { unsigned long long v1:15; int v2; bool v3; };
struct __attribute__((packed)) aBFu15ll_Ip_B { unsigned long long v1:15; int * v2; bool v3; };
struct __attribute__((packed)) aBFu15ll_L_B { unsigned long long v1:15; long long v2; bool v3; };
struct __attribute__((packed)) aBFu15ll_S_B { unsigned long long v1:15; short v2; bool v3; };
struct __attribute__((packed)) aBFu15ll_Uc_B { unsigned long long v1:15; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu15ll_Ui_B { unsigned long long v1:15; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu15ll_Ul_B { unsigned long long v1:15; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu15ll_Us_B { unsigned long long v1:15; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu15ll_Vp_B { unsigned long long v1:15; void * v2; bool v3; };
struct __attribute__((packed)) aBFu15s_B { unsigned short v1:15; bool v2; };
struct __attribute__((packed)) aBFu15s_B_B { unsigned short v1:15; bool v2; bool v3; };
struct __attribute__((packed)) aBFu15s_B_BFu15i { unsigned short v1:15; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu15s_B_BFu15ll { unsigned short v1:15; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu15s_B_BFu15s { unsigned short v1:15; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu15s_B_BFu16i { unsigned short v1:15; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu15s_B_BFu16ll { unsigned short v1:15; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu15s_B_BFu16s { unsigned short v1:15; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu15s_B_BFu17i { unsigned short v1:15; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu15s_B_BFu17ll { unsigned short v1:15; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu15s_B_BFu1c { unsigned short v1:15; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu15s_B_BFu1i { unsigned short v1:15; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu15s_B_BFu1ll { unsigned short v1:15; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu15s_B_BFu1s { unsigned short v1:15; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu15s_B_BFu31i { unsigned short v1:15; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu15s_B_BFu31ll { unsigned short v1:15; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu15s_B_BFu32i { unsigned short v1:15; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu15s_B_BFu32ll { unsigned short v1:15; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu15s_B_BFu33 { unsigned short v1:15; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu15s_B_BFu7c { unsigned short v1:15; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu15s_B_BFu7i { unsigned short v1:15; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu15s_B_BFu7ll { unsigned short v1:15; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu15s_B_BFu7s { unsigned short v1:15; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu15s_B_BFu8c { unsigned short v1:15; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu15s_B_BFu8i { unsigned short v1:15; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu15s_B_BFu8ll { unsigned short v1:15; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu15s_B_BFu8s { unsigned short v1:15; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu15s_B_BFu9i { unsigned short v1:15; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu15s_B_BFu9ll { unsigned short v1:15; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu15s_B_BFu9s { unsigned short v1:15; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu15s_B_C { unsigned short v1:15; bool v2; char v3; };
struct __attribute__((packed)) aBFu15s_B_D { unsigned short v1:15; bool v2; double v3; };
struct __attribute__((packed)) aBFu15s_B_F { unsigned short v1:15; bool v2; float v3; };
struct __attribute__((packed)) aBFu15s_B_I { unsigned short v1:15; bool v2; int v3; };
struct __attribute__((packed)) aBFu15s_B_Ip { unsigned short v1:15; bool v2; int * v3; };
struct __attribute__((packed)) aBFu15s_B_L { unsigned short v1:15; bool v2; long long v3; };
struct __attribute__((packed)) aBFu15s_B_S { unsigned short v1:15; bool v2; short v3; };
struct __attribute__((packed)) aBFu15s_B_Uc { unsigned short v1:15; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu15s_B_Ui { unsigned short v1:15; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu15s_B_Ul { unsigned short v1:15; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu15s_B_Us { unsigned short v1:15; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu15s_B_Vp { unsigned short v1:15; bool v2; void * v3; };
struct __attribute__((packed)) aBFu15s_BFu15i_B { unsigned short v1:15; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu15ll_B { unsigned short v1:15; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu15s_B { unsigned short v1:15; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu16i_B { unsigned short v1:15; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu16ll_B { unsigned short v1:15; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu16s_B { unsigned short v1:15; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu17i_B { unsigned short v1:15; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu17ll_B { unsigned short v1:15; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu1c_B { unsigned short v1:15; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu1i_B { unsigned short v1:15; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu1ll_B { unsigned short v1:15; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu1s_B { unsigned short v1:15; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu31i_B { unsigned short v1:15; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu31ll_B { unsigned short v1:15; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu32i_B { unsigned short v1:15; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu32ll_B { unsigned short v1:15; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu33_B { unsigned short v1:15; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu7c_B { unsigned short v1:15; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu7i_B { unsigned short v1:15; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu7ll_B { unsigned short v1:15; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu7s_B { unsigned short v1:15; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu8c_B { unsigned short v1:15; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu8i_B { unsigned short v1:15; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu8ll_B { unsigned short v1:15; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu8s_B { unsigned short v1:15; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu9i_B { unsigned short v1:15; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu9ll_B { unsigned short v1:15; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu15s_BFu9s_B { unsigned short v1:15; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu15s_C_B { unsigned short v1:15; char v2; bool v3; };
struct __attribute__((packed)) aBFu15s_D_B { unsigned short v1:15; double v2; bool v3; };
struct __attribute__((packed)) aBFu15s_F_B { unsigned short v1:15; float v2; bool v3; };
struct __attribute__((packed)) aBFu15s_I_B { unsigned short v1:15; int v2; bool v3; };
struct __attribute__((packed)) aBFu15s_Ip_B { unsigned short v1:15; int * v2; bool v3; };
struct __attribute__((packed)) aBFu15s_L_B { unsigned short v1:15; long long v2; bool v3; };
struct __attribute__((packed)) aBFu15s_S_B { unsigned short v1:15; short v2; bool v3; };
struct __attribute__((packed)) aBFu15s_Uc_B { unsigned short v1:15; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu15s_Ui_B { unsigned short v1:15; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu15s_Ul_B { unsigned short v1:15; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu15s_Us_B { unsigned short v1:15; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu15s_Vp_B { unsigned short v1:15; void * v2; bool v3; };
struct __attribute__((packed)) aBFu16i_B { unsigned int v1:16; bool v2; };
struct __attribute__((packed)) aBFu16i_B_B { unsigned int v1:16; bool v2; bool v3; };
struct __attribute__((packed)) aBFu16i_B_BFu15i { unsigned int v1:16; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16i_B_BFu15ll { unsigned int v1:16; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16i_B_BFu15s { unsigned int v1:16; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16i_B_BFu16i { unsigned int v1:16; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16i_B_BFu16ll { unsigned int v1:16; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16i_B_BFu16s { unsigned int v1:16; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16i_B_BFu17i { unsigned int v1:16; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16i_B_BFu17ll { unsigned int v1:16; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16i_B_BFu1c { unsigned int v1:16; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16i_B_BFu1i { unsigned int v1:16; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16i_B_BFu1ll { unsigned int v1:16; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16i_B_BFu1s { unsigned int v1:16; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16i_B_BFu31i { unsigned int v1:16; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16i_B_BFu31ll { unsigned int v1:16; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16i_B_BFu32i { unsigned int v1:16; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16i_B_BFu32ll { unsigned int v1:16; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16i_B_BFu33 { unsigned int v1:16; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16i_B_BFu7c { unsigned int v1:16; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16i_B_BFu7i { unsigned int v1:16; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16i_B_BFu7ll { unsigned int v1:16; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16i_B_BFu7s { unsigned int v1:16; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16i_B_BFu8c { unsigned int v1:16; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16i_B_BFu8i { unsigned int v1:16; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16i_B_BFu8ll { unsigned int v1:16; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16i_B_BFu8s { unsigned int v1:16; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16i_B_BFu9i { unsigned int v1:16; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16i_B_BFu9ll { unsigned int v1:16; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16i_B_BFu9s { unsigned int v1:16; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16i_B_C { unsigned int v1:16; bool v2; char v3; };
struct __attribute__((packed)) aBFu16i_B_D { unsigned int v1:16; bool v2; double v3; };
struct __attribute__((packed)) aBFu16i_B_F { unsigned int v1:16; bool v2; float v3; };
struct __attribute__((packed)) aBFu16i_B_I { unsigned int v1:16; bool v2; int v3; };
struct __attribute__((packed)) aBFu16i_B_Ip { unsigned int v1:16; bool v2; int * v3; };
struct __attribute__((packed)) aBFu16i_B_L { unsigned int v1:16; bool v2; long long v3; };
struct __attribute__((packed)) aBFu16i_B_S { unsigned int v1:16; bool v2; short v3; };
struct __attribute__((packed)) aBFu16i_B_Uc { unsigned int v1:16; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16i_B_Ui { unsigned int v1:16; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16i_B_Ul { unsigned int v1:16; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16i_B_Us { unsigned int v1:16; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16i_B_Vp { unsigned int v1:16; bool v2; void * v3; };
struct __attribute__((packed)) aBFu16i_BFu15i_B { unsigned int v1:16; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu15ll_B { unsigned int v1:16; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu15s_B { unsigned int v1:16; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu16i_B { unsigned int v1:16; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu16ll_B { unsigned int v1:16; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu16s_B { unsigned int v1:16; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu17i_B { unsigned int v1:16; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu17ll_B { unsigned int v1:16; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu1c_B { unsigned int v1:16; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu1i_B { unsigned int v1:16; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu1ll_B { unsigned int v1:16; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu1s_B { unsigned int v1:16; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu31i_B { unsigned int v1:16; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu31ll_B { unsigned int v1:16; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu32i_B { unsigned int v1:16; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu32ll_B { unsigned int v1:16; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu33_B { unsigned int v1:16; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu7c_B { unsigned int v1:16; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu7i_B { unsigned int v1:16; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu7ll_B { unsigned int v1:16; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu7s_B { unsigned int v1:16; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu8c_B { unsigned int v1:16; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu8i_B { unsigned int v1:16; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu8ll_B { unsigned int v1:16; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu8s_B { unsigned int v1:16; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu9i_B { unsigned int v1:16; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu9ll_B { unsigned int v1:16; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu16i_BFu9s_B { unsigned int v1:16; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu16i_C_B { unsigned int v1:16; char v2; bool v3; };
struct __attribute__((packed)) aBFu16i_D_B { unsigned int v1:16; double v2; bool v3; };
struct __attribute__((packed)) aBFu16i_F_B { unsigned int v1:16; float v2; bool v3; };
struct __attribute__((packed)) aBFu16i_I_B { unsigned int v1:16; int v2; bool v3; };
struct __attribute__((packed)) aBFu16i_Ip_B { unsigned int v1:16; int * v2; bool v3; };
struct __attribute__((packed)) aBFu16i_L_B { unsigned int v1:16; long long v2; bool v3; };
struct __attribute__((packed)) aBFu16i_S_B { unsigned int v1:16; short v2; bool v3; };
struct __attribute__((packed)) aBFu16i_Uc_B { unsigned int v1:16; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu16i_Ui_B { unsigned int v1:16; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu16i_Ul_B { unsigned int v1:16; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu16i_Us_B { unsigned int v1:16; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu16i_Vp_B { unsigned int v1:16; void * v2; bool v3; };
struct __attribute__((packed)) aBFu16ll_B { unsigned long long v1:16; bool v2; };
struct __attribute__((packed)) aBFu16ll_B_B { unsigned long long v1:16; bool v2; bool v3; };
struct __attribute__((packed)) aBFu16ll_B_BFu15i { unsigned long long v1:16; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_B_BFu15ll { unsigned long long v1:16; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_B_BFu15s { unsigned long long v1:16; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_B_BFu16i { unsigned long long v1:16; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_B_BFu16ll { unsigned long long v1:16; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_B_BFu16s { unsigned long long v1:16; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_B_BFu17i { unsigned long long v1:16; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_B_BFu17ll { unsigned long long v1:16; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_B_BFu1c { unsigned long long v1:16; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_B_BFu1i { unsigned long long v1:16; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_B_BFu1ll { unsigned long long v1:16; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_B_BFu1s { unsigned long long v1:16; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_B_BFu31i { unsigned long long v1:16; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_B_BFu31ll { unsigned long long v1:16; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_B_BFu32i { unsigned long long v1:16; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_B_BFu32ll { unsigned long long v1:16; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_B_BFu33 { unsigned long long v1:16; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_B_BFu7c { unsigned long long v1:16; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_B_BFu7i { unsigned long long v1:16; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_B_BFu7ll { unsigned long long v1:16; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_B_BFu7s { unsigned long long v1:16; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_B_BFu8c { unsigned long long v1:16; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_B_BFu8i { unsigned long long v1:16; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_B_BFu8ll { unsigned long long v1:16; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_B_BFu8s { unsigned long long v1:16; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_B_BFu9i { unsigned long long v1:16; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_B_BFu9ll { unsigned long long v1:16; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_B_BFu9s { unsigned long long v1:16; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_B_C { unsigned long long v1:16; bool v2; char v3; };
struct __attribute__((packed)) aBFu16ll_B_D { unsigned long long v1:16; bool v2; double v3; };
struct __attribute__((packed)) aBFu16ll_B_F { unsigned long long v1:16; bool v2; float v3; };
struct __attribute__((packed)) aBFu16ll_B_I { unsigned long long v1:16; bool v2; int v3; };
struct __attribute__((packed)) aBFu16ll_B_Ip { unsigned long long v1:16; bool v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_B_L { unsigned long long v1:16; bool v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_B_S { unsigned long long v1:16; bool v2; short v3; };
struct __attribute__((packed)) aBFu16ll_B_Uc { unsigned long long v1:16; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_B_Ui { unsigned long long v1:16; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_B_Ul { unsigned long long v1:16; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_B_Us { unsigned long long v1:16; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_B_Vp { unsigned long long v1:16; bool v2; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu15i_B { unsigned long long v1:16; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu15ll_B { unsigned long long v1:16; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu15s_B { unsigned long long v1:16; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu16i_B { unsigned long long v1:16; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu16ll_B { unsigned long long v1:16; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu16s_B { unsigned long long v1:16; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu17i_B { unsigned long long v1:16; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu17ll_B { unsigned long long v1:16; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu1c_B { unsigned long long v1:16; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i_B { unsigned long long v1:16; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_B { unsigned long long v1:16; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s_B { unsigned long long v1:16; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i_B { unsigned long long v1:16; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_B { unsigned long long v1:16; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i_B { unsigned long long v1:16; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_B { unsigned long long v1:16; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu33_B { unsigned long long v1:16; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c_B { unsigned long long v1:16; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i_B { unsigned long long v1:16; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_B { unsigned long long v1:16; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s_B { unsigned long long v1:16; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c_B { unsigned long long v1:16; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i_B { unsigned long long v1:16; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_B { unsigned long long v1:16; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s_B { unsigned long long v1:16; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i_B { unsigned long long v1:16; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_B { unsigned long long v1:16; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s_B { unsigned long long v1:16; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu16ll_C_B { unsigned long long v1:16; char v2; bool v3; };
struct __attribute__((packed)) aBFu16ll_D_B { unsigned long long v1:16; double v2; bool v3; };
struct __attribute__((packed)) aBFu16ll_F_B { unsigned long long v1:16; float v2; bool v3; };
struct __attribute__((packed)) aBFu16ll_I_B { unsigned long long v1:16; int v2; bool v3; };
struct __attribute__((packed)) aBFu16ll_Ip_B { unsigned long long v1:16; int * v2; bool v3; };
struct __attribute__((packed)) aBFu16ll_L_B { unsigned long long v1:16; long long v2; bool v3; };
struct __attribute__((packed)) aBFu16ll_S_B { unsigned long long v1:16; short v2; bool v3; };
struct __attribute__((packed)) aBFu16ll_Uc_B { unsigned long long v1:16; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu16ll_Ui_B { unsigned long long v1:16; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu16ll_Ul_B { unsigned long long v1:16; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu16ll_Us_B { unsigned long long v1:16; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu16ll_Vp_B { unsigned long long v1:16; void * v2; bool v3; };
struct __attribute__((packed)) aBFu16s_B { unsigned short v1:16; bool v2; };
struct __attribute__((packed)) aBFu16s_B_B { unsigned short v1:16; bool v2; bool v3; };
struct __attribute__((packed)) aBFu16s_B_BFu15i { unsigned short v1:16; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_B_BFu15ll { unsigned short v1:16; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_B_BFu15s { unsigned short v1:16; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_B_BFu16i { unsigned short v1:16; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_B_BFu16ll { unsigned short v1:16; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_B_BFu16s { unsigned short v1:16; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_B_BFu17i { unsigned short v1:16; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_B_BFu17ll { unsigned short v1:16; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_B_BFu1c { unsigned short v1:16; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_B_BFu1i { unsigned short v1:16; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_B_BFu1ll { unsigned short v1:16; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_B_BFu1s { unsigned short v1:16; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_B_BFu31i { unsigned short v1:16; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_B_BFu31ll { unsigned short v1:16; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_B_BFu32i { unsigned short v1:16; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_B_BFu32ll { unsigned short v1:16; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_B_BFu33 { unsigned short v1:16; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_B_BFu7c { unsigned short v1:16; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_B_BFu7i { unsigned short v1:16; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_B_BFu7ll { unsigned short v1:16; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_B_BFu7s { unsigned short v1:16; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_B_BFu8c { unsigned short v1:16; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_B_BFu8i { unsigned short v1:16; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_B_BFu8ll { unsigned short v1:16; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_B_BFu8s { unsigned short v1:16; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_B_BFu9i { unsigned short v1:16; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_B_BFu9ll { unsigned short v1:16; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_B_BFu9s { unsigned short v1:16; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_B_C { unsigned short v1:16; bool v2; char v3; };
struct __attribute__((packed)) aBFu16s_B_D { unsigned short v1:16; bool v2; double v3; };
struct __attribute__((packed)) aBFu16s_B_F { unsigned short v1:16; bool v2; float v3; };
struct __attribute__((packed)) aBFu16s_B_I { unsigned short v1:16; bool v2; int v3; };
struct __attribute__((packed)) aBFu16s_B_Ip { unsigned short v1:16; bool v2; int * v3; };
struct __attribute__((packed)) aBFu16s_B_L { unsigned short v1:16; bool v2; long long v3; };
struct __attribute__((packed)) aBFu16s_B_S { unsigned short v1:16; bool v2; short v3; };
struct __attribute__((packed)) aBFu16s_B_Uc { unsigned short v1:16; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_B_Ui { unsigned short v1:16; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_B_Ul { unsigned short v1:16; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_B_Us { unsigned short v1:16; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_B_Vp { unsigned short v1:16; bool v2; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu15i_B { unsigned short v1:16; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll_B { unsigned short v1:16; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu15s_B { unsigned short v1:16; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu16i_B { unsigned short v1:16; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll_B { unsigned short v1:16; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu16s_B { unsigned short v1:16; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu17i_B { unsigned short v1:16; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll_B { unsigned short v1:16; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu1c_B { unsigned short v1:16; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu1i_B { unsigned short v1:16; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll_B { unsigned short v1:16; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu1s_B { unsigned short v1:16; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu31i_B { unsigned short v1:16; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll_B { unsigned short v1:16; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu32i_B { unsigned short v1:16; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll_B { unsigned short v1:16; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu33_B { unsigned short v1:16; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu7c_B { unsigned short v1:16; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu7i_B { unsigned short v1:16; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll_B { unsigned short v1:16; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu7s_B { unsigned short v1:16; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu8c_B { unsigned short v1:16; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu8i_B { unsigned short v1:16; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll_B { unsigned short v1:16; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu8s_B { unsigned short v1:16; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu9i_B { unsigned short v1:16; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll_B { unsigned short v1:16; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu16s_BFu9s_B { unsigned short v1:16; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu16s_C_B { unsigned short v1:16; char v2; bool v3; };
struct __attribute__((packed)) aBFu16s_D_B { unsigned short v1:16; double v2; bool v3; };
struct __attribute__((packed)) aBFu16s_F_B { unsigned short v1:16; float v2; bool v3; };
struct __attribute__((packed)) aBFu16s_I_B { unsigned short v1:16; int v2; bool v3; };
struct __attribute__((packed)) aBFu16s_Ip_B { unsigned short v1:16; int * v2; bool v3; };
struct __attribute__((packed)) aBFu16s_L_B { unsigned short v1:16; long long v2; bool v3; };
struct __attribute__((packed)) aBFu16s_S_B { unsigned short v1:16; short v2; bool v3; };
struct __attribute__((packed)) aBFu16s_Uc_B { unsigned short v1:16; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu16s_Ui_B { unsigned short v1:16; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu16s_Ul_B { unsigned short v1:16; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu16s_Us_B { unsigned short v1:16; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu16s_Vp_B { unsigned short v1:16; void * v2; bool v3; };
struct __attribute__((packed)) aBFu17i_B { unsigned int v1:17; bool v2; };
struct __attribute__((packed)) aBFu17i_B_B { unsigned int v1:17; bool v2; bool v3; };
struct __attribute__((packed)) aBFu17i_B_BFu15i { unsigned int v1:17; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu17i_B_BFu15ll { unsigned int v1:17; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu17i_B_BFu15s { unsigned int v1:17; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu17i_B_BFu16i { unsigned int v1:17; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu17i_B_BFu16ll { unsigned int v1:17; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu17i_B_BFu16s { unsigned int v1:17; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu17i_B_BFu17i { unsigned int v1:17; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu17i_B_BFu17ll { unsigned int v1:17; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu17i_B_BFu1c { unsigned int v1:17; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu17i_B_BFu1i { unsigned int v1:17; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu17i_B_BFu1ll { unsigned int v1:17; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu17i_B_BFu1s { unsigned int v1:17; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu17i_B_BFu31i { unsigned int v1:17; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu17i_B_BFu31ll { unsigned int v1:17; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu17i_B_BFu32i { unsigned int v1:17; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu17i_B_BFu32ll { unsigned int v1:17; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu17i_B_BFu33 { unsigned int v1:17; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu17i_B_BFu7c { unsigned int v1:17; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu17i_B_BFu7i { unsigned int v1:17; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu17i_B_BFu7ll { unsigned int v1:17; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu17i_B_BFu7s { unsigned int v1:17; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu17i_B_BFu8c { unsigned int v1:17; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu17i_B_BFu8i { unsigned int v1:17; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu17i_B_BFu8ll { unsigned int v1:17; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu17i_B_BFu8s { unsigned int v1:17; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu17i_B_BFu9i { unsigned int v1:17; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu17i_B_BFu9ll { unsigned int v1:17; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu17i_B_BFu9s { unsigned int v1:17; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu17i_B_C { unsigned int v1:17; bool v2; char v3; };
struct __attribute__((packed)) aBFu17i_B_D { unsigned int v1:17; bool v2; double v3; };
struct __attribute__((packed)) aBFu17i_B_F { unsigned int v1:17; bool v2; float v3; };
struct __attribute__((packed)) aBFu17i_B_I { unsigned int v1:17; bool v2; int v3; };
struct __attribute__((packed)) aBFu17i_B_Ip { unsigned int v1:17; bool v2; int * v3; };
struct __attribute__((packed)) aBFu17i_B_L { unsigned int v1:17; bool v2; long long v3; };
struct __attribute__((packed)) aBFu17i_B_S { unsigned int v1:17; bool v2; short v3; };
struct __attribute__((packed)) aBFu17i_B_Uc { unsigned int v1:17; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu17i_B_Ui { unsigned int v1:17; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu17i_B_Ul { unsigned int v1:17; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu17i_B_Us { unsigned int v1:17; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu17i_B_Vp { unsigned int v1:17; bool v2; void * v3; };
struct __attribute__((packed)) aBFu17i_BFu15i_B { unsigned int v1:17; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu15ll_B { unsigned int v1:17; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu15s_B { unsigned int v1:17; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu16i_B { unsigned int v1:17; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu16ll_B { unsigned int v1:17; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu16s_B { unsigned int v1:17; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu17i_B { unsigned int v1:17; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu17ll_B { unsigned int v1:17; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu1c_B { unsigned int v1:17; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu1i_B { unsigned int v1:17; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu1ll_B { unsigned int v1:17; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu1s_B { unsigned int v1:17; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu31i_B { unsigned int v1:17; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu31ll_B { unsigned int v1:17; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu32i_B { unsigned int v1:17; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu32ll_B { unsigned int v1:17; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu33_B { unsigned int v1:17; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu7c_B { unsigned int v1:17; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu7i_B { unsigned int v1:17; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu7ll_B { unsigned int v1:17; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu7s_B { unsigned int v1:17; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu8c_B { unsigned int v1:17; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu8i_B { unsigned int v1:17; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu8ll_B { unsigned int v1:17; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu8s_B { unsigned int v1:17; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu9i_B { unsigned int v1:17; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu9ll_B { unsigned int v1:17; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu17i_BFu9s_B { unsigned int v1:17; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu17i_C_B { unsigned int v1:17; char v2; bool v3; };
struct __attribute__((packed)) aBFu17i_D_B { unsigned int v1:17; double v2; bool v3; };
struct __attribute__((packed)) aBFu17i_F_B { unsigned int v1:17; float v2; bool v3; };
struct __attribute__((packed)) aBFu17i_I_B { unsigned int v1:17; int v2; bool v3; };
struct __attribute__((packed)) aBFu17i_Ip_B { unsigned int v1:17; int * v2; bool v3; };
struct __attribute__((packed)) aBFu17i_L_B { unsigned int v1:17; long long v2; bool v3; };
struct __attribute__((packed)) aBFu17i_S_B { unsigned int v1:17; short v2; bool v3; };
struct __attribute__((packed)) aBFu17i_Uc_B { unsigned int v1:17; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu17i_Ui_B { unsigned int v1:17; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu17i_Ul_B { unsigned int v1:17; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu17i_Us_B { unsigned int v1:17; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu17i_Vp_B { unsigned int v1:17; void * v2; bool v3; };
struct __attribute__((packed)) aBFu17ll_B { unsigned long long v1:17; bool v2; };
struct __attribute__((packed)) aBFu17ll_B_B { unsigned long long v1:17; bool v2; bool v3; };
struct __attribute__((packed)) aBFu17ll_B_BFu15i { unsigned long long v1:17; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu17ll_B_BFu15ll { unsigned long long v1:17; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu17ll_B_BFu15s { unsigned long long v1:17; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu17ll_B_BFu16i { unsigned long long v1:17; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu17ll_B_BFu16ll { unsigned long long v1:17; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu17ll_B_BFu16s { unsigned long long v1:17; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu17ll_B_BFu17i { unsigned long long v1:17; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu17ll_B_BFu17ll { unsigned long long v1:17; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu17ll_B_BFu1c { unsigned long long v1:17; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu17ll_B_BFu1i { unsigned long long v1:17; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu17ll_B_BFu1ll { unsigned long long v1:17; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu17ll_B_BFu1s { unsigned long long v1:17; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu17ll_B_BFu31i { unsigned long long v1:17; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu17ll_B_BFu31ll { unsigned long long v1:17; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu17ll_B_BFu32i { unsigned long long v1:17; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu17ll_B_BFu32ll { unsigned long long v1:17; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu17ll_B_BFu33 { unsigned long long v1:17; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu17ll_B_BFu7c { unsigned long long v1:17; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu17ll_B_BFu7i { unsigned long long v1:17; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu17ll_B_BFu7ll { unsigned long long v1:17; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu17ll_B_BFu7s { unsigned long long v1:17; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu17ll_B_BFu8c { unsigned long long v1:17; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu17ll_B_BFu8i { unsigned long long v1:17; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu17ll_B_BFu8ll { unsigned long long v1:17; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu17ll_B_BFu8s { unsigned long long v1:17; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu17ll_B_BFu9i { unsigned long long v1:17; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu17ll_B_BFu9ll { unsigned long long v1:17; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu17ll_B_BFu9s { unsigned long long v1:17; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu17ll_B_C { unsigned long long v1:17; bool v2; char v3; };
struct __attribute__((packed)) aBFu17ll_B_D { unsigned long long v1:17; bool v2; double v3; };
struct __attribute__((packed)) aBFu17ll_B_F { unsigned long long v1:17; bool v2; float v3; };
struct __attribute__((packed)) aBFu17ll_B_I { unsigned long long v1:17; bool v2; int v3; };
struct __attribute__((packed)) aBFu17ll_B_Ip { unsigned long long v1:17; bool v2; int * v3; };
struct __attribute__((packed)) aBFu17ll_B_L { unsigned long long v1:17; bool v2; long long v3; };
struct __attribute__((packed)) aBFu17ll_B_S { unsigned long long v1:17; bool v2; short v3; };
struct __attribute__((packed)) aBFu17ll_B_Uc { unsigned long long v1:17; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu17ll_B_Ui { unsigned long long v1:17; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu17ll_B_Ul { unsigned long long v1:17; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu17ll_B_Us { unsigned long long v1:17; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu17ll_B_Vp { unsigned long long v1:17; bool v2; void * v3; };
struct __attribute__((packed)) aBFu17ll_BFu15i_B { unsigned long long v1:17; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu15ll_B { unsigned long long v1:17; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu15s_B { unsigned long long v1:17; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu16i_B { unsigned long long v1:17; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu16ll_B { unsigned long long v1:17; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu16s_B { unsigned long long v1:17; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu17i_B { unsigned long long v1:17; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu17ll_B { unsigned long long v1:17; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu1c_B { unsigned long long v1:17; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu1i_B { unsigned long long v1:17; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu1ll_B { unsigned long long v1:17; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu1s_B { unsigned long long v1:17; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu31i_B { unsigned long long v1:17; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu31ll_B { unsigned long long v1:17; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu32i_B { unsigned long long v1:17; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu32ll_B { unsigned long long v1:17; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu33_B { unsigned long long v1:17; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu7c_B { unsigned long long v1:17; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu7i_B { unsigned long long v1:17; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu7ll_B { unsigned long long v1:17; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu7s_B { unsigned long long v1:17; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu8c_B { unsigned long long v1:17; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu8i_B { unsigned long long v1:17; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu8ll_B { unsigned long long v1:17; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu8s_B { unsigned long long v1:17; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu9i_B { unsigned long long v1:17; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu9ll_B { unsigned long long v1:17; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu17ll_BFu9s_B { unsigned long long v1:17; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu17ll_C_B { unsigned long long v1:17; char v2; bool v3; };
struct __attribute__((packed)) aBFu17ll_D_B { unsigned long long v1:17; double v2; bool v3; };
struct __attribute__((packed)) aBFu17ll_F_B { unsigned long long v1:17; float v2; bool v3; };
struct __attribute__((packed)) aBFu17ll_I_B { unsigned long long v1:17; int v2; bool v3; };
struct __attribute__((packed)) aBFu17ll_Ip_B { unsigned long long v1:17; int * v2; bool v3; };
struct __attribute__((packed)) aBFu17ll_L_B { unsigned long long v1:17; long long v2; bool v3; };
struct __attribute__((packed)) aBFu17ll_S_B { unsigned long long v1:17; short v2; bool v3; };
struct __attribute__((packed)) aBFu17ll_Uc_B { unsigned long long v1:17; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu17ll_Ui_B { unsigned long long v1:17; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu17ll_Ul_B { unsigned long long v1:17; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu17ll_Us_B { unsigned long long v1:17; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu17ll_Vp_B { unsigned long long v1:17; void * v2; bool v3; };
struct __attribute__((packed)) aBFu1c_B { unsigned char v1:1; bool v2; };
struct __attribute__((packed)) aBFu1c_B_B { unsigned char v1:1; bool v2; bool v3; };
struct __attribute__((packed)) aBFu1c_B_BFu15i { unsigned char v1:1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu1c_B_BFu15ll { unsigned char v1:1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu1c_B_BFu15s { unsigned char v1:1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu1c_B_BFu16i { unsigned char v1:1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu1c_B_BFu16ll { unsigned char v1:1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu1c_B_BFu16s { unsigned char v1:1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu1c_B_BFu17i { unsigned char v1:1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu1c_B_BFu17ll { unsigned char v1:1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu1c_B_BFu1c { unsigned char v1:1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu1c_B_BFu1i { unsigned char v1:1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu1c_B_BFu1ll { unsigned char v1:1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu1c_B_BFu1s { unsigned char v1:1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu1c_B_BFu31i { unsigned char v1:1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu1c_B_BFu31ll { unsigned char v1:1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu1c_B_BFu32i { unsigned char v1:1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu1c_B_BFu32ll { unsigned char v1:1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu1c_B_BFu33 { unsigned char v1:1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu1c_B_BFu7c { unsigned char v1:1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu1c_B_BFu7i { unsigned char v1:1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu1c_B_BFu7ll { unsigned char v1:1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu1c_B_BFu7s { unsigned char v1:1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu1c_B_BFu8c { unsigned char v1:1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu1c_B_BFu8i { unsigned char v1:1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu1c_B_BFu8ll { unsigned char v1:1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu1c_B_BFu8s { unsigned char v1:1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu1c_B_BFu9i { unsigned char v1:1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu1c_B_BFu9ll { unsigned char v1:1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu1c_B_BFu9s { unsigned char v1:1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu1c_B_C { unsigned char v1:1; bool v2; char v3; };
struct __attribute__((packed)) aBFu1c_B_D { unsigned char v1:1; bool v2; double v3; };
struct __attribute__((packed)) aBFu1c_B_F { unsigned char v1:1; bool v2; float v3; };
struct __attribute__((packed)) aBFu1c_B_I { unsigned char v1:1; bool v2; int v3; };
struct __attribute__((packed)) aBFu1c_B_Ip { unsigned char v1:1; bool v2; int * v3; };
struct __attribute__((packed)) aBFu1c_B_L { unsigned char v1:1; bool v2; long long v3; };
struct __attribute__((packed)) aBFu1c_B_S { unsigned char v1:1; bool v2; short v3; };
struct __attribute__((packed)) aBFu1c_B_Uc { unsigned char v1:1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu1c_B_Ui { unsigned char v1:1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu1c_B_Ul { unsigned char v1:1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu1c_B_Us { unsigned char v1:1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu1c_B_Vp { unsigned char v1:1; bool v2; void * v3; };
struct __attribute__((packed)) aBFu1c_BFu15i_B { unsigned char v1:1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu15ll_B { unsigned char v1:1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu15s_B { unsigned char v1:1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu16i_B { unsigned char v1:1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu16ll_B { unsigned char v1:1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu16s_B { unsigned char v1:1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu17i_B { unsigned char v1:1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu17ll_B { unsigned char v1:1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu1c_B { unsigned char v1:1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu1i_B { unsigned char v1:1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu1ll_B { unsigned char v1:1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu1s_B { unsigned char v1:1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu31i_B { unsigned char v1:1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu31ll_B { unsigned char v1:1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu32i_B { unsigned char v1:1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu32ll_B { unsigned char v1:1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu33_B { unsigned char v1:1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu7c_B { unsigned char v1:1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu7i_B { unsigned char v1:1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu7ll_B { unsigned char v1:1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu7s_B { unsigned char v1:1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu8c_B { unsigned char v1:1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu8i_B { unsigned char v1:1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu8ll_B { unsigned char v1:1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu8s_B { unsigned char v1:1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu9i_B { unsigned char v1:1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu9ll_B { unsigned char v1:1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu1c_BFu9s_B { unsigned char v1:1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu1c_C_B { unsigned char v1:1; char v2; bool v3; };
struct __attribute__((packed)) aBFu1c_D_B { unsigned char v1:1; double v2; bool v3; };
struct __attribute__((packed)) aBFu1c_F_B { unsigned char v1:1; float v2; bool v3; };
struct __attribute__((packed)) aBFu1c_I_B { unsigned char v1:1; int v2; bool v3; };
struct __attribute__((packed)) aBFu1c_Ip_B { unsigned char v1:1; int * v2; bool v3; };
struct __attribute__((packed)) aBFu1c_L_B { unsigned char v1:1; long long v2; bool v3; };
struct __attribute__((packed)) aBFu1c_S_B { unsigned char v1:1; short v2; bool v3; };
struct __attribute__((packed)) aBFu1c_Uc_B { unsigned char v1:1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu1c_Ui_B { unsigned char v1:1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu1c_Ul_B { unsigned char v1:1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu1c_Us_B { unsigned char v1:1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu1c_Vp_B { unsigned char v1:1; void * v2; bool v3; };
struct __attribute__((packed)) aBFu1i_B { unsigned int v1:1; bool v2; };
struct __attribute__((packed)) aBFu1i_B_B { unsigned int v1:1; bool v2; bool v3; };
struct __attribute__((packed)) aBFu1i_B_BFu15i { unsigned int v1:1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu1i_B_BFu15ll { unsigned int v1:1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu1i_B_BFu15s { unsigned int v1:1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu1i_B_BFu16i { unsigned int v1:1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu1i_B_BFu16ll { unsigned int v1:1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu1i_B_BFu16s { unsigned int v1:1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu1i_B_BFu17i { unsigned int v1:1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu1i_B_BFu17ll { unsigned int v1:1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu1i_B_BFu1c { unsigned int v1:1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu1i_B_BFu1i { unsigned int v1:1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu1i_B_BFu1ll { unsigned int v1:1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu1i_B_BFu1s { unsigned int v1:1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu1i_B_BFu31i { unsigned int v1:1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu1i_B_BFu31ll { unsigned int v1:1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu1i_B_BFu32i { unsigned int v1:1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu1i_B_BFu32ll { unsigned int v1:1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu1i_B_BFu33 { unsigned int v1:1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu1i_B_BFu7c { unsigned int v1:1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu1i_B_BFu7i { unsigned int v1:1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu1i_B_BFu7ll { unsigned int v1:1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu1i_B_BFu7s { unsigned int v1:1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu1i_B_BFu8c { unsigned int v1:1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu1i_B_BFu8i { unsigned int v1:1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu1i_B_BFu8ll { unsigned int v1:1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu1i_B_BFu8s { unsigned int v1:1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu1i_B_BFu9i { unsigned int v1:1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu1i_B_BFu9ll { unsigned int v1:1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu1i_B_BFu9s { unsigned int v1:1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu1i_B_C { unsigned int v1:1; bool v2; char v3; };
struct __attribute__((packed)) aBFu1i_B_D { unsigned int v1:1; bool v2; double v3; };
struct __attribute__((packed)) aBFu1i_B_F { unsigned int v1:1; bool v2; float v3; };
struct __attribute__((packed)) aBFu1i_B_I { unsigned int v1:1; bool v2; int v3; };
struct __attribute__((packed)) aBFu1i_B_Ip { unsigned int v1:1; bool v2; int * v3; };
struct __attribute__((packed)) aBFu1i_B_L { unsigned int v1:1; bool v2; long long v3; };
struct __attribute__((packed)) aBFu1i_B_S { unsigned int v1:1; bool v2; short v3; };
struct __attribute__((packed)) aBFu1i_B_Uc { unsigned int v1:1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu1i_B_Ui { unsigned int v1:1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu1i_B_Ul { unsigned int v1:1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu1i_B_Us { unsigned int v1:1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu1i_B_Vp { unsigned int v1:1; bool v2; void * v3; };
struct __attribute__((packed)) aBFu1i_BFu15i_B { unsigned int v1:1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu15ll_B { unsigned int v1:1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu15s_B { unsigned int v1:1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu16i_B { unsigned int v1:1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu16ll_B { unsigned int v1:1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu16s_B { unsigned int v1:1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu17i_B { unsigned int v1:1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu17ll_B { unsigned int v1:1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu1c_B { unsigned int v1:1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu1i_B { unsigned int v1:1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu1ll_B { unsigned int v1:1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu1s_B { unsigned int v1:1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu31i_B { unsigned int v1:1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu31ll_B { unsigned int v1:1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu32i_B { unsigned int v1:1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu32ll_B { unsigned int v1:1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu33_B { unsigned int v1:1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu7c_B { unsigned int v1:1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu7i_B { unsigned int v1:1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu7ll_B { unsigned int v1:1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu7s_B { unsigned int v1:1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu8c_B { unsigned int v1:1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu8i_B { unsigned int v1:1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu8ll_B { unsigned int v1:1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu8s_B { unsigned int v1:1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu9i_B { unsigned int v1:1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu9ll_B { unsigned int v1:1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu1i_BFu9s_B { unsigned int v1:1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu1i_C_B { unsigned int v1:1; char v2; bool v3; };
struct __attribute__((packed)) aBFu1i_D_B { unsigned int v1:1; double v2; bool v3; };
struct __attribute__((packed)) aBFu1i_F_B { unsigned int v1:1; float v2; bool v3; };
struct __attribute__((packed)) aBFu1i_I_B { unsigned int v1:1; int v2; bool v3; };
struct __attribute__((packed)) aBFu1i_Ip_B { unsigned int v1:1; int * v2; bool v3; };
struct __attribute__((packed)) aBFu1i_L_B { unsigned int v1:1; long long v2; bool v3; };
struct __attribute__((packed)) aBFu1i_S_B { unsigned int v1:1; short v2; bool v3; };
struct __attribute__((packed)) aBFu1i_Uc_B { unsigned int v1:1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu1i_Ui_B { unsigned int v1:1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu1i_Ul_B { unsigned int v1:1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu1i_Us_B { unsigned int v1:1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu1i_Vp_B { unsigned int v1:1; void * v2; bool v3; };
struct __attribute__((packed)) aBFu1ll_B { unsigned long long v1:1; bool v2; };
struct __attribute__((packed)) aBFu1ll_B_B { unsigned long long v1:1; bool v2; bool v3; };
struct __attribute__((packed)) aBFu1ll_B_BFu15i { unsigned long long v1:1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu1ll_B_BFu15ll { unsigned long long v1:1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu1ll_B_BFu15s { unsigned long long v1:1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu1ll_B_BFu16i { unsigned long long v1:1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu1ll_B_BFu16ll { unsigned long long v1:1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu1ll_B_BFu16s { unsigned long long v1:1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu1ll_B_BFu17i { unsigned long long v1:1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu1ll_B_BFu17ll { unsigned long long v1:1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu1ll_B_BFu1c { unsigned long long v1:1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu1ll_B_BFu1i { unsigned long long v1:1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu1ll_B_BFu1ll { unsigned long long v1:1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu1ll_B_BFu1s { unsigned long long v1:1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu1ll_B_BFu31i { unsigned long long v1:1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu1ll_B_BFu31ll { unsigned long long v1:1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu1ll_B_BFu32i { unsigned long long v1:1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu1ll_B_BFu32ll { unsigned long long v1:1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu1ll_B_BFu33 { unsigned long long v1:1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu1ll_B_BFu7c { unsigned long long v1:1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu1ll_B_BFu7i { unsigned long long v1:1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu1ll_B_BFu7ll { unsigned long long v1:1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu1ll_B_BFu7s { unsigned long long v1:1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu1ll_B_BFu8c { unsigned long long v1:1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu1ll_B_BFu8i { unsigned long long v1:1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu1ll_B_BFu8ll { unsigned long long v1:1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu1ll_B_BFu8s { unsigned long long v1:1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu1ll_B_BFu9i { unsigned long long v1:1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu1ll_B_BFu9ll { unsigned long long v1:1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu1ll_B_BFu9s { unsigned long long v1:1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu1ll_B_C { unsigned long long v1:1; bool v2; char v3; };
struct __attribute__((packed)) aBFu1ll_B_D { unsigned long long v1:1; bool v2; double v3; };
struct __attribute__((packed)) aBFu1ll_B_F { unsigned long long v1:1; bool v2; float v3; };
struct __attribute__((packed)) aBFu1ll_B_I { unsigned long long v1:1; bool v2; int v3; };
struct __attribute__((packed)) aBFu1ll_B_Ip { unsigned long long v1:1; bool v2; int * v3; };
struct __attribute__((packed)) aBFu1ll_B_L { unsigned long long v1:1; bool v2; long long v3; };
struct __attribute__((packed)) aBFu1ll_B_S { unsigned long long v1:1; bool v2; short v3; };
struct __attribute__((packed)) aBFu1ll_B_Uc { unsigned long long v1:1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu1ll_B_Ui { unsigned long long v1:1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu1ll_B_Ul { unsigned long long v1:1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu1ll_B_Us { unsigned long long v1:1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu1ll_B_Vp { unsigned long long v1:1; bool v2; void * v3; };
struct __attribute__((packed)) aBFu1ll_BFu15i_B { unsigned long long v1:1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu15ll_B { unsigned long long v1:1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu15s_B { unsigned long long v1:1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu16i_B { unsigned long long v1:1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu16ll_B { unsigned long long v1:1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu16s_B { unsigned long long v1:1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu17i_B { unsigned long long v1:1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu17ll_B { unsigned long long v1:1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu1c_B { unsigned long long v1:1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu1i_B { unsigned long long v1:1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu1ll_B { unsigned long long v1:1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu1s_B { unsigned long long v1:1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu31i_B { unsigned long long v1:1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu31ll_B { unsigned long long v1:1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu32i_B { unsigned long long v1:1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu32ll_B { unsigned long long v1:1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu33_B { unsigned long long v1:1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu7c_B { unsigned long long v1:1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu7i_B { unsigned long long v1:1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu7ll_B { unsigned long long v1:1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu7s_B { unsigned long long v1:1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu8c_B { unsigned long long v1:1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu8i_B { unsigned long long v1:1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu8ll_B { unsigned long long v1:1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu8s_B { unsigned long long v1:1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu9i_B { unsigned long long v1:1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu9ll_B { unsigned long long v1:1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu1ll_BFu9s_B { unsigned long long v1:1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu1ll_C_B { unsigned long long v1:1; char v2; bool v3; };
struct __attribute__((packed)) aBFu1ll_D_B { unsigned long long v1:1; double v2; bool v3; };
struct __attribute__((packed)) aBFu1ll_F_B { unsigned long long v1:1; float v2; bool v3; };
struct __attribute__((packed)) aBFu1ll_I_B { unsigned long long v1:1; int v2; bool v3; };
struct __attribute__((packed)) aBFu1ll_Ip_B { unsigned long long v1:1; int * v2; bool v3; };
struct __attribute__((packed)) aBFu1ll_L_B { unsigned long long v1:1; long long v2; bool v3; };
struct __attribute__((packed)) aBFu1ll_S_B { unsigned long long v1:1; short v2; bool v3; };
struct __attribute__((packed)) aBFu1ll_Uc_B { unsigned long long v1:1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu1ll_Ui_B { unsigned long long v1:1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu1ll_Ul_B { unsigned long long v1:1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu1ll_Us_B { unsigned long long v1:1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu1ll_Vp_B { unsigned long long v1:1; void * v2; bool v3; };
struct __attribute__((packed)) aBFu1s_B { unsigned short v1:1; bool v2; };
struct __attribute__((packed)) aBFu1s_B_B { unsigned short v1:1; bool v2; bool v3; };
struct __attribute__((packed)) aBFu1s_B_BFu15i { unsigned short v1:1; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu1s_B_BFu15ll { unsigned short v1:1; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu1s_B_BFu15s { unsigned short v1:1; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu1s_B_BFu16i { unsigned short v1:1; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu1s_B_BFu16ll { unsigned short v1:1; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu1s_B_BFu16s { unsigned short v1:1; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu1s_B_BFu17i { unsigned short v1:1; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu1s_B_BFu17ll { unsigned short v1:1; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu1s_B_BFu1c { unsigned short v1:1; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu1s_B_BFu1i { unsigned short v1:1; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu1s_B_BFu1ll { unsigned short v1:1; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu1s_B_BFu1s { unsigned short v1:1; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu1s_B_BFu31i { unsigned short v1:1; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu1s_B_BFu31ll { unsigned short v1:1; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu1s_B_BFu32i { unsigned short v1:1; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu1s_B_BFu32ll { unsigned short v1:1; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu1s_B_BFu33 { unsigned short v1:1; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu1s_B_BFu7c { unsigned short v1:1; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu1s_B_BFu7i { unsigned short v1:1; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu1s_B_BFu7ll { unsigned short v1:1; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu1s_B_BFu7s { unsigned short v1:1; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu1s_B_BFu8c { unsigned short v1:1; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu1s_B_BFu8i { unsigned short v1:1; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu1s_B_BFu8ll { unsigned short v1:1; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu1s_B_BFu8s { unsigned short v1:1; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu1s_B_BFu9i { unsigned short v1:1; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu1s_B_BFu9ll { unsigned short v1:1; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu1s_B_BFu9s { unsigned short v1:1; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu1s_B_C { unsigned short v1:1; bool v2; char v3; };
struct __attribute__((packed)) aBFu1s_B_D { unsigned short v1:1; bool v2; double v3; };
struct __attribute__((packed)) aBFu1s_B_F { unsigned short v1:1; bool v2; float v3; };
struct __attribute__((packed)) aBFu1s_B_I { unsigned short v1:1; bool v2; int v3; };
struct __attribute__((packed)) aBFu1s_B_Ip { unsigned short v1:1; bool v2; int * v3; };
struct __attribute__((packed)) aBFu1s_B_L { unsigned short v1:1; bool v2; long long v3; };
struct __attribute__((packed)) aBFu1s_B_S { unsigned short v1:1; bool v2; short v3; };
struct __attribute__((packed)) aBFu1s_B_Uc { unsigned short v1:1; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu1s_B_Ui { unsigned short v1:1; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu1s_B_Ul { unsigned short v1:1; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu1s_B_Us { unsigned short v1:1; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu1s_B_Vp { unsigned short v1:1; bool v2; void * v3; };
struct __attribute__((packed)) aBFu1s_BFu15i_B { unsigned short v1:1; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu15ll_B { unsigned short v1:1; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu15s_B { unsigned short v1:1; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu16i_B { unsigned short v1:1; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu16ll_B { unsigned short v1:1; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu16s_B { unsigned short v1:1; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu17i_B { unsigned short v1:1; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu17ll_B { unsigned short v1:1; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu1c_B { unsigned short v1:1; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu1i_B { unsigned short v1:1; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu1ll_B { unsigned short v1:1; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu1s_B { unsigned short v1:1; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu31i_B { unsigned short v1:1; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu31ll_B { unsigned short v1:1; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu32i_B { unsigned short v1:1; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu32ll_B { unsigned short v1:1; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu33_B { unsigned short v1:1; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu7c_B { unsigned short v1:1; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu7i_B { unsigned short v1:1; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu7ll_B { unsigned short v1:1; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu7s_B { unsigned short v1:1; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu8c_B { unsigned short v1:1; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu8i_B { unsigned short v1:1; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu8ll_B { unsigned short v1:1; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu8s_B { unsigned short v1:1; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu9i_B { unsigned short v1:1; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu9ll_B { unsigned short v1:1; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu1s_BFu9s_B { unsigned short v1:1; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu1s_C_B { unsigned short v1:1; char v2; bool v3; };
struct __attribute__((packed)) aBFu1s_D_B { unsigned short v1:1; double v2; bool v3; };
struct __attribute__((packed)) aBFu1s_F_B { unsigned short v1:1; float v2; bool v3; };
struct __attribute__((packed)) aBFu1s_I_B { unsigned short v1:1; int v2; bool v3; };
struct __attribute__((packed)) aBFu1s_Ip_B { unsigned short v1:1; int * v2; bool v3; };
struct __attribute__((packed)) aBFu1s_L_B { unsigned short v1:1; long long v2; bool v3; };
struct __attribute__((packed)) aBFu1s_S_B { unsigned short v1:1; short v2; bool v3; };
struct __attribute__((packed)) aBFu1s_Uc_B { unsigned short v1:1; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu1s_Ui_B { unsigned short v1:1; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu1s_Ul_B { unsigned short v1:1; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu1s_Us_B { unsigned short v1:1; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu1s_Vp_B { unsigned short v1:1; void * v2; bool v3; };
struct __attribute__((packed)) aBFu31i_B { unsigned int v1:31; bool v2; };
struct __attribute__((packed)) aBFu31i_B_B { unsigned int v1:31; bool v2; bool v3; };
struct __attribute__((packed)) aBFu31i_B_BFu15i { unsigned int v1:31; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu31i_B_BFu15ll { unsigned int v1:31; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu31i_B_BFu15s { unsigned int v1:31; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu31i_B_BFu16i { unsigned int v1:31; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu31i_B_BFu16ll { unsigned int v1:31; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu31i_B_BFu16s { unsigned int v1:31; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu31i_B_BFu17i { unsigned int v1:31; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu31i_B_BFu17ll { unsigned int v1:31; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu31i_B_BFu1c { unsigned int v1:31; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu31i_B_BFu1i { unsigned int v1:31; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu31i_B_BFu1ll { unsigned int v1:31; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu31i_B_BFu1s { unsigned int v1:31; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu31i_B_BFu31i { unsigned int v1:31; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu31i_B_BFu31ll { unsigned int v1:31; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu31i_B_BFu32i { unsigned int v1:31; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu31i_B_BFu32ll { unsigned int v1:31; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu31i_B_BFu33 { unsigned int v1:31; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu31i_B_BFu7c { unsigned int v1:31; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu31i_B_BFu7i { unsigned int v1:31; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu31i_B_BFu7ll { unsigned int v1:31; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu31i_B_BFu7s { unsigned int v1:31; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu31i_B_BFu8c { unsigned int v1:31; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu31i_B_BFu8i { unsigned int v1:31; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu31i_B_BFu8ll { unsigned int v1:31; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu31i_B_BFu8s { unsigned int v1:31; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu31i_B_BFu9i { unsigned int v1:31; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu31i_B_BFu9ll { unsigned int v1:31; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu31i_B_BFu9s { unsigned int v1:31; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu31i_B_C { unsigned int v1:31; bool v2; char v3; };
struct __attribute__((packed)) aBFu31i_B_D { unsigned int v1:31; bool v2; double v3; };
struct __attribute__((packed)) aBFu31i_B_F { unsigned int v1:31; bool v2; float v3; };
struct __attribute__((packed)) aBFu31i_B_I { unsigned int v1:31; bool v2; int v3; };
struct __attribute__((packed)) aBFu31i_B_Ip { unsigned int v1:31; bool v2; int * v3; };
struct __attribute__((packed)) aBFu31i_B_L { unsigned int v1:31; bool v2; long long v3; };
struct __attribute__((packed)) aBFu31i_B_S { unsigned int v1:31; bool v2; short v3; };
struct __attribute__((packed)) aBFu31i_B_Uc { unsigned int v1:31; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu31i_B_Ui { unsigned int v1:31; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu31i_B_Ul { unsigned int v1:31; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu31i_B_Us { unsigned int v1:31; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu31i_B_Vp { unsigned int v1:31; bool v2; void * v3; };
struct __attribute__((packed)) aBFu31i_BFu15i_B { unsigned int v1:31; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu15ll_B { unsigned int v1:31; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu15s_B { unsigned int v1:31; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu16i_B { unsigned int v1:31; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu16ll_B { unsigned int v1:31; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu16s_B { unsigned int v1:31; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu17i_B { unsigned int v1:31; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu17ll_B { unsigned int v1:31; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu1c_B { unsigned int v1:31; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu1i_B { unsigned int v1:31; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu1ll_B { unsigned int v1:31; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu1s_B { unsigned int v1:31; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu31i_B { unsigned int v1:31; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu31ll_B { unsigned int v1:31; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu32i_B { unsigned int v1:31; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu32ll_B { unsigned int v1:31; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu33_B { unsigned int v1:31; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu7c_B { unsigned int v1:31; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu7i_B { unsigned int v1:31; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu7ll_B { unsigned int v1:31; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu7s_B { unsigned int v1:31; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu8c_B { unsigned int v1:31; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu8i_B { unsigned int v1:31; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu8ll_B { unsigned int v1:31; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu8s_B { unsigned int v1:31; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu9i_B { unsigned int v1:31; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu9ll_B { unsigned int v1:31; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu31i_BFu9s_B { unsigned int v1:31; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu31i_C_B { unsigned int v1:31; char v2; bool v3; };
struct __attribute__((packed)) aBFu31i_D_B { unsigned int v1:31; double v2; bool v3; };
struct __attribute__((packed)) aBFu31i_F_B { unsigned int v1:31; float v2; bool v3; };
struct __attribute__((packed)) aBFu31i_I_B { unsigned int v1:31; int v2; bool v3; };
struct __attribute__((packed)) aBFu31i_Ip_B { unsigned int v1:31; int * v2; bool v3; };
struct __attribute__((packed)) aBFu31i_L_B { unsigned int v1:31; long long v2; bool v3; };
struct __attribute__((packed)) aBFu31i_S_B { unsigned int v1:31; short v2; bool v3; };
struct __attribute__((packed)) aBFu31i_Uc_B { unsigned int v1:31; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu31i_Ui_B { unsigned int v1:31; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu31i_Ul_B { unsigned int v1:31; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu31i_Us_B { unsigned int v1:31; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu31i_Vp_B { unsigned int v1:31; void * v2; bool v3; };
struct __attribute__((packed)) aBFu31ll_B { unsigned long long v1:31; bool v2; };
struct __attribute__((packed)) aBFu31ll_B_B { unsigned long long v1:31; bool v2; bool v3; };
struct __attribute__((packed)) aBFu31ll_B_BFu15i { unsigned long long v1:31; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu31ll_B_BFu15ll { unsigned long long v1:31; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu31ll_B_BFu15s { unsigned long long v1:31; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu31ll_B_BFu16i { unsigned long long v1:31; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu31ll_B_BFu16ll { unsigned long long v1:31; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu31ll_B_BFu16s { unsigned long long v1:31; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu31ll_B_BFu17i { unsigned long long v1:31; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu31ll_B_BFu17ll { unsigned long long v1:31; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu31ll_B_BFu1c { unsigned long long v1:31; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu31ll_B_BFu1i { unsigned long long v1:31; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu31ll_B_BFu1ll { unsigned long long v1:31; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu31ll_B_BFu1s { unsigned long long v1:31; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu31ll_B_BFu31i { unsigned long long v1:31; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu31ll_B_BFu31ll { unsigned long long v1:31; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu31ll_B_BFu32i { unsigned long long v1:31; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu31ll_B_BFu32ll { unsigned long long v1:31; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu31ll_B_BFu33 { unsigned long long v1:31; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu31ll_B_BFu7c { unsigned long long v1:31; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu31ll_B_BFu7i { unsigned long long v1:31; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu31ll_B_BFu7ll { unsigned long long v1:31; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu31ll_B_BFu7s { unsigned long long v1:31; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu31ll_B_BFu8c { unsigned long long v1:31; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu31ll_B_BFu8i { unsigned long long v1:31; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu31ll_B_BFu8ll { unsigned long long v1:31; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu31ll_B_BFu8s { unsigned long long v1:31; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu31ll_B_BFu9i { unsigned long long v1:31; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu31ll_B_BFu9ll { unsigned long long v1:31; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu31ll_B_BFu9s { unsigned long long v1:31; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu31ll_B_C { unsigned long long v1:31; bool v2; char v3; };
struct __attribute__((packed)) aBFu31ll_B_D { unsigned long long v1:31; bool v2; double v3; };
struct __attribute__((packed)) aBFu31ll_B_F { unsigned long long v1:31; bool v2; float v3; };
struct __attribute__((packed)) aBFu31ll_B_I { unsigned long long v1:31; bool v2; int v3; };
struct __attribute__((packed)) aBFu31ll_B_Ip { unsigned long long v1:31; bool v2; int * v3; };
struct __attribute__((packed)) aBFu31ll_B_L { unsigned long long v1:31; bool v2; long long v3; };
struct __attribute__((packed)) aBFu31ll_B_S { unsigned long long v1:31; bool v2; short v3; };
struct __attribute__((packed)) aBFu31ll_B_Uc { unsigned long long v1:31; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu31ll_B_Ui { unsigned long long v1:31; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu31ll_B_Ul { unsigned long long v1:31; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu31ll_B_Us { unsigned long long v1:31; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu31ll_B_Vp { unsigned long long v1:31; bool v2; void * v3; };
struct __attribute__((packed)) aBFu31ll_BFu15i_B { unsigned long long v1:31; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu15ll_B { unsigned long long v1:31; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu15s_B { unsigned long long v1:31; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu16i_B { unsigned long long v1:31; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu16ll_B { unsigned long long v1:31; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu16s_B { unsigned long long v1:31; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu17i_B { unsigned long long v1:31; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu17ll_B { unsigned long long v1:31; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu1c_B { unsigned long long v1:31; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu1i_B { unsigned long long v1:31; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu1ll_B { unsigned long long v1:31; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu1s_B { unsigned long long v1:31; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu31i_B { unsigned long long v1:31; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu31ll_B { unsigned long long v1:31; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu32i_B { unsigned long long v1:31; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu32ll_B { unsigned long long v1:31; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu33_B { unsigned long long v1:31; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu7c_B { unsigned long long v1:31; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu7i_B { unsigned long long v1:31; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu7ll_B { unsigned long long v1:31; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu7s_B { unsigned long long v1:31; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu8c_B { unsigned long long v1:31; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu8i_B { unsigned long long v1:31; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu8ll_B { unsigned long long v1:31; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu8s_B { unsigned long long v1:31; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu9i_B { unsigned long long v1:31; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu9ll_B { unsigned long long v1:31; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu31ll_BFu9s_B { unsigned long long v1:31; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu31ll_C_B { unsigned long long v1:31; char v2; bool v3; };
struct __attribute__((packed)) aBFu31ll_D_B { unsigned long long v1:31; double v2; bool v3; };
struct __attribute__((packed)) aBFu31ll_F_B { unsigned long long v1:31; float v2; bool v3; };
struct __attribute__((packed)) aBFu31ll_I_B { unsigned long long v1:31; int v2; bool v3; };
struct __attribute__((packed)) aBFu31ll_Ip_B { unsigned long long v1:31; int * v2; bool v3; };
struct __attribute__((packed)) aBFu31ll_L_B { unsigned long long v1:31; long long v2; bool v3; };
struct __attribute__((packed)) aBFu31ll_S_B { unsigned long long v1:31; short v2; bool v3; };
struct __attribute__((packed)) aBFu31ll_Uc_B { unsigned long long v1:31; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu31ll_Ui_B { unsigned long long v1:31; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu31ll_Ul_B { unsigned long long v1:31; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu31ll_Us_B { unsigned long long v1:31; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu31ll_Vp_B { unsigned long long v1:31; void * v2; bool v3; };
struct __attribute__((packed)) aBFu32i_B { unsigned int v1:32; bool v2; };
struct __attribute__((packed)) aBFu32i_B_B { unsigned int v1:32; bool v2; bool v3; };
struct __attribute__((packed)) aBFu32i_B_BFu15i { unsigned int v1:32; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu32i_B_BFu15ll { unsigned int v1:32; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu32i_B_BFu15s { unsigned int v1:32; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu32i_B_BFu16i { unsigned int v1:32; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu32i_B_BFu16ll { unsigned int v1:32; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu32i_B_BFu16s { unsigned int v1:32; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu32i_B_BFu17i { unsigned int v1:32; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu32i_B_BFu17ll { unsigned int v1:32; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu32i_B_BFu1c { unsigned int v1:32; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu32i_B_BFu1i { unsigned int v1:32; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu32i_B_BFu1ll { unsigned int v1:32; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu32i_B_BFu1s { unsigned int v1:32; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu32i_B_BFu31i { unsigned int v1:32; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu32i_B_BFu31ll { unsigned int v1:32; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu32i_B_BFu32i { unsigned int v1:32; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu32i_B_BFu32ll { unsigned int v1:32; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu32i_B_BFu33 { unsigned int v1:32; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu32i_B_BFu7c { unsigned int v1:32; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu32i_B_BFu7i { unsigned int v1:32; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu32i_B_BFu7ll { unsigned int v1:32; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu32i_B_BFu7s { unsigned int v1:32; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu32i_B_BFu8c { unsigned int v1:32; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu32i_B_BFu8i { unsigned int v1:32; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu32i_B_BFu8ll { unsigned int v1:32; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu32i_B_BFu8s { unsigned int v1:32; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu32i_B_BFu9i { unsigned int v1:32; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu32i_B_BFu9ll { unsigned int v1:32; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu32i_B_BFu9s { unsigned int v1:32; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu32i_B_C { unsigned int v1:32; bool v2; char v3; };
struct __attribute__((packed)) aBFu32i_B_D { unsigned int v1:32; bool v2; double v3; };
struct __attribute__((packed)) aBFu32i_B_F { unsigned int v1:32; bool v2; float v3; };
struct __attribute__((packed)) aBFu32i_B_I { unsigned int v1:32; bool v2; int v3; };
struct __attribute__((packed)) aBFu32i_B_Ip { unsigned int v1:32; bool v2; int * v3; };
struct __attribute__((packed)) aBFu32i_B_L { unsigned int v1:32; bool v2; long long v3; };
struct __attribute__((packed)) aBFu32i_B_S { unsigned int v1:32; bool v2; short v3; };
struct __attribute__((packed)) aBFu32i_B_Uc { unsigned int v1:32; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu32i_B_Ui { unsigned int v1:32; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu32i_B_Ul { unsigned int v1:32; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu32i_B_Us { unsigned int v1:32; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu32i_B_Vp { unsigned int v1:32; bool v2; void * v3; };
struct __attribute__((packed)) aBFu32i_BFu15i_B { unsigned int v1:32; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu15ll_B { unsigned int v1:32; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu15s_B { unsigned int v1:32; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu16i_B { unsigned int v1:32; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu16ll_B { unsigned int v1:32; unsigned long long v2:16; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu16s_B { unsigned int v1:32; unsigned short v2:16; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu17i_B { unsigned int v1:32; unsigned int v2:17; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu17ll_B { unsigned int v1:32; unsigned long long v2:17; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu1c_B { unsigned int v1:32; unsigned char v2:1; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu1i_B { unsigned int v1:32; unsigned int v2:1; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu1ll_B { unsigned int v1:32; unsigned long long v2:1; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu1s_B { unsigned int v1:32; unsigned short v2:1; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu31i_B { unsigned int v1:32; unsigned int v2:31; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu31ll_B { unsigned int v1:32; unsigned long long v2:31; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu32i_B { unsigned int v1:32; unsigned int v2:32; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu32ll_B { unsigned int v1:32; unsigned long long v2:32; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu33_B { unsigned int v1:32; unsigned long long v2:33; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu7c_B { unsigned int v1:32; unsigned char v2:7; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu7i_B { unsigned int v1:32; unsigned int v2:7; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu7ll_B { unsigned int v1:32; unsigned long long v2:7; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu7s_B { unsigned int v1:32; unsigned short v2:7; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu8c_B { unsigned int v1:32; unsigned char v2:8; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu8i_B { unsigned int v1:32; unsigned int v2:8; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu8ll_B { unsigned int v1:32; unsigned long long v2:8; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu8s_B { unsigned int v1:32; unsigned short v2:8; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu9i_B { unsigned int v1:32; unsigned int v2:9; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu9ll_B { unsigned int v1:32; unsigned long long v2:9; bool v3; };
struct __attribute__((packed)) aBFu32i_BFu9s_B { unsigned int v1:32; unsigned short v2:9; bool v3; };
struct __attribute__((packed)) aBFu32i_C_B { unsigned int v1:32; char v2; bool v3; };
struct __attribute__((packed)) aBFu32i_D_B { unsigned int v1:32; double v2; bool v3; };
struct __attribute__((packed)) aBFu32i_F_B { unsigned int v1:32; float v2; bool v3; };
struct __attribute__((packed)) aBFu32i_I_B { unsigned int v1:32; int v2; bool v3; };
struct __attribute__((packed)) aBFu32i_Ip_B { unsigned int v1:32; int * v2; bool v3; };
struct __attribute__((packed)) aBFu32i_L_B { unsigned int v1:32; long long v2; bool v3; };
struct __attribute__((packed)) aBFu32i_S_B { unsigned int v1:32; short v2; bool v3; };
struct __attribute__((packed)) aBFu32i_Uc_B { unsigned int v1:32; unsigned char v2; bool v3; };
struct __attribute__((packed)) aBFu32i_Ui_B { unsigned int v1:32; unsigned int v2; bool v3; };
struct __attribute__((packed)) aBFu32i_Ul_B { unsigned int v1:32; unsigned long long v2; bool v3; };
struct __attribute__((packed)) aBFu32i_Us_B { unsigned int v1:32; unsigned short v2; bool v3; };
struct __attribute__((packed)) aBFu32i_Vp_B { unsigned int v1:32; void * v2; bool v3; };
struct __attribute__((packed)) aBFu32ll_B { unsigned long long v1:32; bool v2; };
struct __attribute__((packed)) aBFu32ll_B_B { unsigned long long v1:32; bool v2; bool v3; };
struct __attribute__((packed)) aBFu32ll_B_BFu15i { unsigned long long v1:32; bool v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu32ll_B_BFu15ll { unsigned long long v1:32; bool v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu32ll_B_BFu15s { unsigned long long v1:32; bool v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu32ll_B_BFu16i { unsigned long long v1:32; bool v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu32ll_B_BFu16ll { unsigned long long v1:32; bool v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu32ll_B_BFu16s { unsigned long long v1:32; bool v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu32ll_B_BFu17i { unsigned long long v1:32; bool v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu32ll_B_BFu17ll { unsigned long long v1:32; bool v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu32ll_B_BFu1c { unsigned long long v1:32; bool v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu32ll_B_BFu1i { unsigned long long v1:32; bool v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu32ll_B_BFu1ll { unsigned long long v1:32; bool v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu32ll_B_BFu1s { unsigned long long v1:32; bool v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu32ll_B_BFu31i { unsigned long long v1:32; bool v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu32ll_B_BFu31ll { unsigned long long v1:32; bool v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu32ll_B_BFu32i { unsigned long long v1:32; bool v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu32ll_B_BFu32ll { unsigned long long v1:32; bool v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu32ll_B_BFu33 { unsigned long long v1:32; bool v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu32ll_B_BFu7c { unsigned long long v1:32; bool v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu32ll_B_BFu7i { unsigned long long v1:32; bool v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu32ll_B_BFu7ll { unsigned long long v1:32; bool v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu32ll_B_BFu7s { unsigned long long v1:32; bool v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu32ll_B_BFu8c { unsigned long long v1:32; bool v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu32ll_B_BFu8i { unsigned long long v1:32; bool v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu32ll_B_BFu8ll { unsigned long long v1:32; bool v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu32ll_B_BFu8s { unsigned long long v1:32; bool v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu32ll_B_BFu9i { unsigned long long v1:32; bool v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu32ll_B_BFu9ll { unsigned long long v1:32; bool v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu32ll_B_BFu9s { unsigned long long v1:32; bool v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu32ll_B_C { unsigned long long v1:32; bool v2; char v3; };
struct __attribute__((packed)) aBFu32ll_B_D { unsigned long long v1:32; bool v2; double v3; };
struct __attribute__((packed)) aBFu32ll_B_F { unsigned long long v1:32; bool v2; float v3; };
struct __attribute__((packed)) aBFu32ll_B_I { unsigned long long v1:32; bool v2; int v3; };
struct __attribute__((packed)) aBFu32ll_B_Ip { unsigned long long v1:32; bool v2; int * v3; };
struct __attribute__((packed)) aBFu32ll_B_L { unsigned long long v1:32; bool v2; long long v3; };
struct __attribute__((packed)) aBFu32ll_B_S { unsigned long long v1:32; bool v2; short v3; };
struct __attribute__((packed)) aBFu32ll_B_Uc { unsigned long long v1:32; bool v2; unsigned char v3; };
struct __attribute__((packed)) aBFu32ll_B_Ui { unsigned long long v1:32; bool v2; unsigned int v3; };
struct __attribute__((packed)) aBFu32ll_B_Ul { unsigned long long v1:32; bool v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu32ll_B_Us { unsigned long long v1:32; bool v2; unsigned short v3; };
struct __attribute__((packed)) aBFu32ll_B_Vp { unsigned long long v1:32; bool v2; void * v3; };
struct __attribute__((packed)) aBFu32ll_BFu15i_B { unsigned long long v1:32; unsigned int v2:15; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu15ll_B { unsigned long long v1:32; unsigned long long v2:15; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu15s_B { unsigned long long v1:32; unsigned short v2:15; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu16i_B { unsigned long long v1:32; unsigned int v2:16; bool v3; };
struct __attribute__((packed)) aBFu32ll_BFu16ll_B { unsigned long long v1:32; unsigned long long v2:16; bool v3; };
#endif // __cplusplus
#ifdef __cplusplus


static void Test_aB()
{
  {
    init_simple_test("aB");
    aB lv;
    check2(sizeof(lv), 1, "sizeof(aB)");
    check2(__alignof__(lv), 1, "__alignof__(aB)");
    check_field_offset(lv, v1, 0, "aB.v1");
  }
}
static Arrange_To_Call_Me vaB(Test_aB, "aB", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B()
{
  {
    init_simple_test("aB_B");
    aB_B lv;
    check2(sizeof(lv), 2, "sizeof(aB_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B)");
    check_field_offset(lv, v1, 0, "aB_B.v1");
    check_field_offset(lv, v2, 1, "aB_B.v2");
  }
}
static Arrange_To_Call_Me vaB_B(Test_aB_B, "aB_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_B()
{
  {
    init_simple_test("aB_B_B");
    aB_B_B lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_B)");
    check_field_offset(lv, v1, 0, "aB_B_B.v1");
    check_field_offset(lv, v2, 1, "aB_B_B.v2");
    check_field_offset(lv, v3, 2, "aB_B_B.v3");
  }
}
static Arrange_To_Call_Me vaB_B_B(Test_aB_B_B, "aB_B_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu15i()
{
  {
    init_simple_test("aB_B_BFu15i");
    static aB_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aB_B_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_B_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aB_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aB_B_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_B_BFu15i(Test_aB_B_BFu15i, "aB_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu15ll()
{
  {
    init_simple_test("aB_B_BFu15ll");
    static aB_B_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_B_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_B_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aB_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aB_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_B_BFu15ll(Test_aB_B_BFu15ll, "aB_B_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu15s()
{
  {
    init_simple_test("aB_B_BFu15s");
    static aB_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aB_B_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_B_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aB_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aB_B_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_B_BFu15s(Test_aB_B_BFu15s, "aB_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu16i()
{
  {
    init_simple_test("aB_B_BFu16i");
    static aB_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aB_B_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_B_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aB_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aB_B_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_B_BFu16i(Test_aB_B_BFu16i, "aB_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu16ll()
{
  {
    init_simple_test("aB_B_BFu16ll");
    static aB_B_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_B_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_B_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aB_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aB_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_B_BFu16ll(Test_aB_B_BFu16ll, "aB_B_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu16s()
{
  {
    init_simple_test("aB_B_BFu16s");
    static aB_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aB_B_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_B_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aB_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aB_B_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_B_BFu16s(Test_aB_B_BFu16s, "aB_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu17i()
{
  {
    init_simple_test("aB_B_BFu17i");
    static aB_B_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aB_B_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_B_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aB_B_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aB_B_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_B_BFu17i(Test_aB_B_BFu17i, "aB_B_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu17ll()
{
  {
    init_simple_test("aB_B_BFu17ll");
    static aB_B_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_B_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_B_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aB_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aB_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_B_BFu17ll(Test_aB_B_BFu17ll, "aB_B_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu1c()
{
  {
    init_simple_test("aB_B_BFu1c");
    static aB_B_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_B_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aB_B_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_B_BFu1c(Test_aB_B_BFu1c, "aB_B_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu1i()
{
  {
    init_simple_test("aB_B_BFu1i");
    static aB_B_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_B_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aB_B_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_B_BFu1i(Test_aB_B_BFu1i, "aB_B_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu1ll()
{
  {
    init_simple_test("aB_B_BFu1ll");
    static aB_B_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_B_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aB_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_B_BFu1ll(Test_aB_B_BFu1ll, "aB_B_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu1s()
{
  {
    init_simple_test("aB_B_BFu1s");
    static aB_B_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_B_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aB_B_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_B_BFu1s(Test_aB_B_BFu1s, "aB_B_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu31i()
{
  {
    init_simple_test("aB_B_BFu31i");
    static aB_B_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aB_B_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_B_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aB_B_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aB_B_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_B_BFu31i(Test_aB_B_BFu31i, "aB_B_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu31ll()
{
  {
    init_simple_test("aB_B_BFu31ll");
    static aB_B_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_B_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_B_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aB_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aB_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_B_BFu31ll(Test_aB_B_BFu31ll, "aB_B_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu32i()
{
  {
    init_simple_test("aB_B_BFu32i");
    static aB_B_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aB_B_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_B_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aB_B_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aB_B_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_B_BFu32i(Test_aB_B_BFu32i, "aB_B_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu32ll()
{
  {
    init_simple_test("aB_B_BFu32ll");
    static aB_B_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_B_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_B_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aB_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aB_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_B_BFu32ll(Test_aB_B_BFu32ll, "aB_B_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu33()
{
  {
    init_simple_test("aB_B_BFu33");
    static aB_B_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aB_B_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu33)");
    check_field_offset(lv, v1, 0, "aB_B_BFu33.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aB_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aB_B_BFu33");
  }
}
static Arrange_To_Call_Me vaB_B_BFu33(Test_aB_B_BFu33, "aB_B_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu7c()
{
  {
    init_simple_test("aB_B_BFu7c");
    static aB_B_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_B_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aB_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aB_B_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_B_BFu7c(Test_aB_B_BFu7c, "aB_B_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu7i()
{
  {
    init_simple_test("aB_B_BFu7i");
    static aB_B_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_B_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aB_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aB_B_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_B_BFu7i(Test_aB_B_BFu7i, "aB_B_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu7ll()
{
  {
    init_simple_test("aB_B_BFu7ll");
    static aB_B_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_B_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aB_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aB_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_B_BFu7ll(Test_aB_B_BFu7ll, "aB_B_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu7s()
{
  {
    init_simple_test("aB_B_BFu7s");
    static aB_B_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_B_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aB_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aB_B_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_B_BFu7s(Test_aB_B_BFu7s, "aB_B_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu8c()
{
  {
    init_simple_test("aB_B_BFu8c");
    static aB_B_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_B_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aB_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aB_B_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_B_BFu8c(Test_aB_B_BFu8c, "aB_B_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu8i()
{
  {
    init_simple_test("aB_B_BFu8i");
    static aB_B_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_B_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aB_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aB_B_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_B_BFu8i(Test_aB_B_BFu8i, "aB_B_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu8ll()
{
  {
    init_simple_test("aB_B_BFu8ll");
    static aB_B_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_B_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aB_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aB_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_B_BFu8ll(Test_aB_B_BFu8ll, "aB_B_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu8s()
{
  {
    init_simple_test("aB_B_BFu8s");
    static aB_B_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_B_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aB_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aB_B_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_B_BFu8s(Test_aB_B_BFu8s, "aB_B_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu9i()
{
  {
    init_simple_test("aB_B_BFu9i");
    static aB_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aB_B_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_B_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aB_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aB_B_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_B_BFu9i(Test_aB_B_BFu9i, "aB_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu9ll()
{
  {
    init_simple_test("aB_B_BFu9ll");
    static aB_B_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_B_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_B_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aB_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aB_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_B_BFu9ll(Test_aB_B_BFu9ll, "aB_B_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_BFu9s()
{
  {
    init_simple_test("aB_B_BFu9s");
    static aB_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aB_B_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_B_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aB_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aB_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aB_B_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_B_BFu9s(Test_aB_B_BFu9s, "aB_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_C()
{
  {
    init_simple_test("aB_B_C");
    aB_B_C lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_C)");
    check_field_offset(lv, v1, 0, "aB_B_C.v1");
    check_field_offset(lv, v2, 1, "aB_B_C.v2");
    check_field_offset(lv, v3, 2, "aB_B_C.v3");
  }
}
static Arrange_To_Call_Me vaB_B_C(Test_aB_B_C, "aB_B_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_D()
{
  {
    init_simple_test("aB_B_D");
    aB_B_D lv;
    check2(sizeof(lv), 10, "sizeof(aB_B_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_D)");
    check_field_offset(lv, v1, 0, "aB_B_D.v1");
    check_field_offset(lv, v2, 1, "aB_B_D.v2");
    check_field_offset(lv, v3, 2, "aB_B_D.v3");
  }
}
static Arrange_To_Call_Me vaB_B_D(Test_aB_B_D, "aB_B_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_F()
{
  {
    init_simple_test("aB_B_F");
    aB_B_F lv;
    check2(sizeof(lv), 6, "sizeof(aB_B_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_F)");
    check_field_offset(lv, v1, 0, "aB_B_F.v1");
    check_field_offset(lv, v2, 1, "aB_B_F.v2");
    check_field_offset(lv, v3, 2, "aB_B_F.v3");
  }
}
static Arrange_To_Call_Me vaB_B_F(Test_aB_B_F, "aB_B_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_I()
{
  {
    init_simple_test("aB_B_I");
    aB_B_I lv;
    check2(sizeof(lv), 6, "sizeof(aB_B_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_I)");
    check_field_offset(lv, v1, 0, "aB_B_I.v1");
    check_field_offset(lv, v2, 1, "aB_B_I.v2");
    check_field_offset(lv, v3, 2, "aB_B_I.v3");
  }
}
static Arrange_To_Call_Me vaB_B_I(Test_aB_B_I, "aB_B_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_Ip()
{
  {
    init_simple_test("aB_B_Ip");
    aB_B_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_B_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_Ip)");
    check_field_offset(lv, v1, 0, "aB_B_Ip.v1");
    check_field_offset(lv, v2, 1, "aB_B_Ip.v2");
    check_field_offset(lv, v3, 2, "aB_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_B_Ip(Test_aB_B_Ip, "aB_B_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_L()
{
  {
    init_simple_test("aB_B_L");
    aB_B_L lv;
    check2(sizeof(lv), 10, "sizeof(aB_B_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_L)");
    check_field_offset(lv, v1, 0, "aB_B_L.v1");
    check_field_offset(lv, v2, 1, "aB_B_L.v2");
    check_field_offset(lv, v3, 2, "aB_B_L.v3");
  }
}
static Arrange_To_Call_Me vaB_B_L(Test_aB_B_L, "aB_B_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_S()
{
  {
    init_simple_test("aB_B_S");
    aB_B_S lv;
    check2(sizeof(lv), 4, "sizeof(aB_B_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_S)");
    check_field_offset(lv, v1, 0, "aB_B_S.v1");
    check_field_offset(lv, v2, 1, "aB_B_S.v2");
    check_field_offset(lv, v3, 2, "aB_B_S.v3");
  }
}
static Arrange_To_Call_Me vaB_B_S(Test_aB_B_S, "aB_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_Uc()
{
  {
    init_simple_test("aB_B_Uc");
    aB_B_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aB_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_Uc)");
    check_field_offset(lv, v1, 0, "aB_B_Uc.v1");
    check_field_offset(lv, v2, 1, "aB_B_Uc.v2");
    check_field_offset(lv, v3, 2, "aB_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_B_Uc(Test_aB_B_Uc, "aB_B_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_Ui()
{
  {
    init_simple_test("aB_B_Ui");
    aB_B_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aB_B_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_Ui)");
    check_field_offset(lv, v1, 0, "aB_B_Ui.v1");
    check_field_offset(lv, v2, 1, "aB_B_Ui.v2");
    check_field_offset(lv, v3, 2, "aB_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_B_Ui(Test_aB_B_Ui, "aB_B_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_Ul()
{
  {
    init_simple_test("aB_B_Ul");
    aB_B_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aB_B_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_Ul)");
    check_field_offset(lv, v1, 0, "aB_B_Ul.v1");
    check_field_offset(lv, v2, 1, "aB_B_Ul.v2");
    check_field_offset(lv, v3, 2, "aB_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_B_Ul(Test_aB_B_Ul, "aB_B_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_Us()
{
  {
    init_simple_test("aB_B_Us");
    aB_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(aB_B_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_Us)");
    check_field_offset(lv, v1, 0, "aB_B_Us.v1");
    check_field_offset(lv, v2, 1, "aB_B_Us.v2");
    check_field_offset(lv, v3, 2, "aB_B_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_B_Us(Test_aB_B_Us, "aB_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_B_Vp()
{
  {
    init_simple_test("aB_B_Vp");
    aB_B_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_B_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_B_Vp)");
    check_field_offset(lv, v1, 0, "aB_B_Vp.v1");
    check_field_offset(lv, v2, 1, "aB_B_Vp.v2");
    check_field_offset(lv, v3, 2, "aB_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_B_Vp(Test_aB_B_Vp, "aB_B_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i()
{
  {
    init_simple_test("aB_BFu15i");
    static aB_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu15i(Test_aB_BFu15i, "aB_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_B()
{
  {
    init_simple_test("aB_BFu15i_B");
    static aB_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_B)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_B");
    check_field_offset(lv, v3, 3, "aB_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_B(Test_aB_BFu15i_B, "aB_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu15i()
{
  {
    init_simple_test("aB_BFu15i_BFu15i");
    static aB_BFu15i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aB_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu15i(Test_aB_BFu15i_BFu15i, "aB_BFu15i_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu15ll()
{
  {
    init_simple_test("aB_BFu15i_BFu15ll");
    static aB_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aB_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu15ll(Test_aB_BFu15i_BFu15ll, "aB_BFu15i_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu15s()
{
  {
    init_simple_test("aB_BFu15i_BFu15s");
    static aB_BFu15i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aB_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu15s(Test_aB_BFu15i_BFu15s, "aB_BFu15i_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu16i()
{
  {
    init_simple_test("aB_BFu15i_BFu16i");
    static aB_BFu15i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aB_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aB_BFu15i_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu16i(Test_aB_BFu15i_BFu16i, "aB_BFu15i_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu16ll()
{
  {
    init_simple_test("aB_BFu15i_BFu16ll");
    static aB_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aB_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aB_BFu15i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu16ll(Test_aB_BFu15i_BFu16ll, "aB_BFu15i_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu16s()
{
  {
    init_simple_test("aB_BFu15i_BFu16s");
    static aB_BFu15i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aB_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aB_BFu15i_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu16s(Test_aB_BFu15i_BFu16s, "aB_BFu15i_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu17i()
{
  {
    init_simple_test("aB_BFu15i_BFu17i");
    static aB_BFu15i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aB_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aB_BFu15i_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu17i(Test_aB_BFu15i_BFu17i, "aB_BFu15i_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu17ll()
{
  {
    init_simple_test("aB_BFu15i_BFu17ll");
    static aB_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aB_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aB_BFu15i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu17ll(Test_aB_BFu15i_BFu17ll, "aB_BFu15i_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu1c()
{
  {
    init_simple_test("aB_BFu15i_BFu1c");
    static aB_BFu15i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aB_BFu15i_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu1c(Test_aB_BFu15i_BFu1c, "aB_BFu15i_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu1i()
{
  {
    init_simple_test("aB_BFu15i_BFu1i");
    static aB_BFu15i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aB_BFu15i_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu1i(Test_aB_BFu15i_BFu1i, "aB_BFu15i_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu1ll()
{
  {
    init_simple_test("aB_BFu15i_BFu1ll");
    static aB_BFu15i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aB_BFu15i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu1ll(Test_aB_BFu15i_BFu1ll, "aB_BFu15i_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu1s()
{
  {
    init_simple_test("aB_BFu15i_BFu1s");
    static aB_BFu15i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aB_BFu15i_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu1s(Test_aB_BFu15i_BFu1s, "aB_BFu15i_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu31i()
{
  {
    init_simple_test("aB_BFu15i_BFu31i");
    static aB_BFu15i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aB_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aB_BFu15i_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu31i(Test_aB_BFu15i_BFu31i, "aB_BFu15i_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu31ll()
{
  {
    init_simple_test("aB_BFu15i_BFu31ll");
    static aB_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aB_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aB_BFu15i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu31ll(Test_aB_BFu15i_BFu31ll, "aB_BFu15i_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu32i()
{
  {
    init_simple_test("aB_BFu15i_BFu32i");
    static aB_BFu15i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aB_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aB_BFu15i_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu32i(Test_aB_BFu15i_BFu32i, "aB_BFu15i_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu32ll()
{
  {
    init_simple_test("aB_BFu15i_BFu32ll");
    static aB_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aB_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aB_BFu15i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu32ll(Test_aB_BFu15i_BFu32ll, "aB_BFu15i_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu33()
{
  {
    init_simple_test("aB_BFu15i_BFu33");
    static aB_BFu15i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "aB_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "aB_BFu15i_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu33(Test_aB_BFu15i_BFu33, "aB_BFu15i_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu7c()
{
  {
    init_simple_test("aB_BFu15i_BFu7c");
    static aB_BFu15i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aB_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aB_BFu15i_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu7c(Test_aB_BFu15i_BFu7c, "aB_BFu15i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu7i()
{
  {
    init_simple_test("aB_BFu15i_BFu7i");
    static aB_BFu15i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aB_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aB_BFu15i_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu7i(Test_aB_BFu15i_BFu7i, "aB_BFu15i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu7ll()
{
  {
    init_simple_test("aB_BFu15i_BFu7ll");
    static aB_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aB_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aB_BFu15i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu7ll(Test_aB_BFu15i_BFu7ll, "aB_BFu15i_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu7s()
{
  {
    init_simple_test("aB_BFu15i_BFu7s");
    static aB_BFu15i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aB_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aB_BFu15i_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu7s(Test_aB_BFu15i_BFu7s, "aB_BFu15i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu8c()
{
  {
    init_simple_test("aB_BFu15i_BFu8c");
    static aB_BFu15i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aB_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aB_BFu15i_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu8c(Test_aB_BFu15i_BFu8c, "aB_BFu15i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu8i()
{
  {
    init_simple_test("aB_BFu15i_BFu8i");
    static aB_BFu15i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aB_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aB_BFu15i_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu8i(Test_aB_BFu15i_BFu8i, "aB_BFu15i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu8ll()
{
  {
    init_simple_test("aB_BFu15i_BFu8ll");
    static aB_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aB_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aB_BFu15i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu8ll(Test_aB_BFu15i_BFu8ll, "aB_BFu15i_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu8s()
{
  {
    init_simple_test("aB_BFu15i_BFu8s");
    static aB_BFu15i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aB_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aB_BFu15i_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu8s(Test_aB_BFu15i_BFu8s, "aB_BFu15i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu9i()
{
  {
    init_simple_test("aB_BFu15i_BFu9i");
    static aB_BFu15i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aB_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aB_BFu15i_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu9i(Test_aB_BFu15i_BFu9i, "aB_BFu15i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu9ll()
{
  {
    init_simple_test("aB_BFu15i_BFu9ll");
    static aB_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aB_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aB_BFu15i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu9ll(Test_aB_BFu15i_BFu9ll, "aB_BFu15i_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_BFu9s()
{
  {
    init_simple_test("aB_BFu15i_BFu9s");
    static aB_BFu15i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aB_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aB_BFu15i_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_BFu9s(Test_aB_BFu15i_BFu9s, "aB_BFu15i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_C()
{
  {
    init_simple_test("aB_BFu15i_C");
    static aB_BFu15i_C lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_C)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_C");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_C");
    check_field_offset(lv, v3, 3, "aB_BFu15i_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_C(Test_aB_BFu15i_C, "aB_BFu15i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_D()
{
  {
    init_simple_test("aB_BFu15i_D");
    static aB_BFu15i_D lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu15i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_D)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_D");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_D");
    check_field_offset(lv, v3, 3, "aB_BFu15i_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_D(Test_aB_BFu15i_D, "aB_BFu15i_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_F()
{
  {
    init_simple_test("aB_BFu15i_F");
    static aB_BFu15i_F lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_F)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_F");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_F");
    check_field_offset(lv, v3, 3, "aB_BFu15i_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_F(Test_aB_BFu15i_F, "aB_BFu15i_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_I()
{
  {
    init_simple_test("aB_BFu15i_I");
    static aB_BFu15i_I lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_I)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_I");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_I");
    check_field_offset(lv, v3, 3, "aB_BFu15i_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_I(Test_aB_BFu15i_I, "aB_BFu15i_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_Ip()
{
  {
    init_simple_test("aB_BFu15i_Ip");
    static aB_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu15i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_Ip");
    check_field_offset(lv, v3, 3, "aB_BFu15i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_Ip(Test_aB_BFu15i_Ip, "aB_BFu15i_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_L()
{
  {
    init_simple_test("aB_BFu15i_L");
    static aB_BFu15i_L lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu15i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_L)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_L");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_L");
    check_field_offset(lv, v3, 3, "aB_BFu15i_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_L(Test_aB_BFu15i_L, "aB_BFu15i_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_S()
{
  {
    init_simple_test("aB_BFu15i_S");
    static aB_BFu15i_S lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_S)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_S");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_S");
    check_field_offset(lv, v3, 3, "aB_BFu15i_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_S(Test_aB_BFu15i_S, "aB_BFu15i_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_Uc()
{
  {
    init_simple_test("aB_BFu15i_Uc");
    static aB_BFu15i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_Uc");
    check_field_offset(lv, v3, 3, "aB_BFu15i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_Uc(Test_aB_BFu15i_Uc, "aB_BFu15i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_Ui()
{
  {
    init_simple_test("aB_BFu15i_Ui");
    static aB_BFu15i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_Ui");
    check_field_offset(lv, v3, 3, "aB_BFu15i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_Ui(Test_aB_BFu15i_Ui, "aB_BFu15i_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_Ul()
{
  {
    init_simple_test("aB_BFu15i_Ul");
    static aB_BFu15i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu15i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_Ul");
    check_field_offset(lv, v3, 3, "aB_BFu15i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_Ul(Test_aB_BFu15i_Ul, "aB_BFu15i_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_Us()
{
  {
    init_simple_test("aB_BFu15i_Us");
    static aB_BFu15i_Us lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_Us");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_Us");
    check_field_offset(lv, v3, 3, "aB_BFu15i_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_Us(Test_aB_BFu15i_Us, "aB_BFu15i_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15i_Vp()
{
  {
    init_simple_test("aB_BFu15i_Vp");
    static aB_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu15i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15i_Vp");
    check_field_offset(lv, v3, 3, "aB_BFu15i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15i_Vp(Test_aB_BFu15i_Vp, "aB_BFu15i_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll()
{
  {
    init_simple_test("aB_BFu15ll");
    static aB_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll(Test_aB_BFu15ll, "aB_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_B()
{
  {
    init_simple_test("aB_BFu15ll_B");
    static aB_BFu15ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_B)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_B");
    check_field_offset(lv, v3, 3, "aB_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_B(Test_aB_BFu15ll_B, "aB_BFu15ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu15i()
{
  {
    init_simple_test("aB_BFu15ll_BFu15i");
    static aB_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aB_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu15i(Test_aB_BFu15ll_BFu15i, "aB_BFu15ll_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu15ll()
{
  {
    init_simple_test("aB_BFu15ll_BFu15ll");
    static aB_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aB_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu15ll(Test_aB_BFu15ll_BFu15ll, "aB_BFu15ll_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu15s()
{
  {
    init_simple_test("aB_BFu15ll_BFu15s");
    static aB_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aB_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu15s(Test_aB_BFu15ll_BFu15s, "aB_BFu15ll_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu16i()
{
  {
    init_simple_test("aB_BFu15ll_BFu16i");
    static aB_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aB_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aB_BFu15ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu16i(Test_aB_BFu15ll_BFu16i, "aB_BFu15ll_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu16ll()
{
  {
    init_simple_test("aB_BFu15ll_BFu16ll");
    static aB_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aB_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aB_BFu15ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu16ll(Test_aB_BFu15ll_BFu16ll, "aB_BFu15ll_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu16s()
{
  {
    init_simple_test("aB_BFu15ll_BFu16s");
    static aB_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aB_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aB_BFu15ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu16s(Test_aB_BFu15ll_BFu16s, "aB_BFu15ll_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu17i()
{
  {
    init_simple_test("aB_BFu15ll_BFu17i");
    static aB_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aB_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aB_BFu15ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu17i(Test_aB_BFu15ll_BFu17i, "aB_BFu15ll_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu17ll()
{
  {
    init_simple_test("aB_BFu15ll_BFu17ll");
    static aB_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aB_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aB_BFu15ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu17ll(Test_aB_BFu15ll_BFu17ll, "aB_BFu15ll_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu1c()
{
  {
    init_simple_test("aB_BFu15ll_BFu1c");
    static aB_BFu15ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aB_BFu15ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu1c(Test_aB_BFu15ll_BFu1c, "aB_BFu15ll_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu1i()
{
  {
    init_simple_test("aB_BFu15ll_BFu1i");
    static aB_BFu15ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aB_BFu15ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu1i(Test_aB_BFu15ll_BFu1i, "aB_BFu15ll_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu1ll()
{
  {
    init_simple_test("aB_BFu15ll_BFu1ll");
    static aB_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aB_BFu15ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu1ll(Test_aB_BFu15ll_BFu1ll, "aB_BFu15ll_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu1s()
{
  {
    init_simple_test("aB_BFu15ll_BFu1s");
    static aB_BFu15ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aB_BFu15ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu1s(Test_aB_BFu15ll_BFu1s, "aB_BFu15ll_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu31i()
{
  {
    init_simple_test("aB_BFu15ll_BFu31i");
    static aB_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aB_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aB_BFu15ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu31i(Test_aB_BFu15ll_BFu31i, "aB_BFu15ll_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu31ll()
{
  {
    init_simple_test("aB_BFu15ll_BFu31ll");
    static aB_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aB_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aB_BFu15ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu31ll(Test_aB_BFu15ll_BFu31ll, "aB_BFu15ll_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu32i()
{
  {
    init_simple_test("aB_BFu15ll_BFu32i");
    static aB_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aB_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aB_BFu15ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu32i(Test_aB_BFu15ll_BFu32i, "aB_BFu15ll_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu32ll()
{
  {
    init_simple_test("aB_BFu15ll_BFu32ll");
    static aB_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aB_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aB_BFu15ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu32ll(Test_aB_BFu15ll_BFu32ll, "aB_BFu15ll_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu33()
{
  {
    init_simple_test("aB_BFu15ll_BFu33");
    static aB_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "aB_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "aB_BFu15ll_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu33(Test_aB_BFu15ll_BFu33, "aB_BFu15ll_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu7c()
{
  {
    init_simple_test("aB_BFu15ll_BFu7c");
    static aB_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aB_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aB_BFu15ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu7c(Test_aB_BFu15ll_BFu7c, "aB_BFu15ll_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu7i()
{
  {
    init_simple_test("aB_BFu15ll_BFu7i");
    static aB_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aB_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aB_BFu15ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu7i(Test_aB_BFu15ll_BFu7i, "aB_BFu15ll_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu7ll()
{
  {
    init_simple_test("aB_BFu15ll_BFu7ll");
    static aB_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aB_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aB_BFu15ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu7ll(Test_aB_BFu15ll_BFu7ll, "aB_BFu15ll_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu7s()
{
  {
    init_simple_test("aB_BFu15ll_BFu7s");
    static aB_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aB_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aB_BFu15ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu7s(Test_aB_BFu15ll_BFu7s, "aB_BFu15ll_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu8c()
{
  {
    init_simple_test("aB_BFu15ll_BFu8c");
    static aB_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aB_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aB_BFu15ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu8c(Test_aB_BFu15ll_BFu8c, "aB_BFu15ll_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu8i()
{
  {
    init_simple_test("aB_BFu15ll_BFu8i");
    static aB_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aB_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aB_BFu15ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu8i(Test_aB_BFu15ll_BFu8i, "aB_BFu15ll_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu8ll()
{
  {
    init_simple_test("aB_BFu15ll_BFu8ll");
    static aB_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aB_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aB_BFu15ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu8ll(Test_aB_BFu15ll_BFu8ll, "aB_BFu15ll_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu8s()
{
  {
    init_simple_test("aB_BFu15ll_BFu8s");
    static aB_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aB_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aB_BFu15ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu8s(Test_aB_BFu15ll_BFu8s, "aB_BFu15ll_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu9i()
{
  {
    init_simple_test("aB_BFu15ll_BFu9i");
    static aB_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aB_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aB_BFu15ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu9i(Test_aB_BFu15ll_BFu9i, "aB_BFu15ll_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu9ll()
{
  {
    init_simple_test("aB_BFu15ll_BFu9ll");
    static aB_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aB_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aB_BFu15ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu9ll(Test_aB_BFu15ll_BFu9ll, "aB_BFu15ll_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_BFu9s()
{
  {
    init_simple_test("aB_BFu15ll_BFu9s");
    static aB_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aB_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aB_BFu15ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_BFu9s(Test_aB_BFu15ll_BFu9s, "aB_BFu15ll_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_C()
{
  {
    init_simple_test("aB_BFu15ll_C");
    static aB_BFu15ll_C lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_C");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_C");
    check_field_offset(lv, v3, 3, "aB_BFu15ll_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_C(Test_aB_BFu15ll_C, "aB_BFu15ll_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_D()
{
  {
    init_simple_test("aB_BFu15ll_D");
    static aB_BFu15ll_D lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu15ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_D");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_D");
    check_field_offset(lv, v3, 3, "aB_BFu15ll_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_D(Test_aB_BFu15ll_D, "aB_BFu15ll_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_F()
{
  {
    init_simple_test("aB_BFu15ll_F");
    static aB_BFu15ll_F lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_F");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_F");
    check_field_offset(lv, v3, 3, "aB_BFu15ll_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_F(Test_aB_BFu15ll_F, "aB_BFu15ll_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_I()
{
  {
    init_simple_test("aB_BFu15ll_I");
    static aB_BFu15ll_I lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_I");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_I");
    check_field_offset(lv, v3, 3, "aB_BFu15ll_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_I(Test_aB_BFu15ll_I, "aB_BFu15ll_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_Ip()
{
  {
    init_simple_test("aB_BFu15ll_Ip");
    static aB_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu15ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_Ip");
    check_field_offset(lv, v3, 3, "aB_BFu15ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_Ip(Test_aB_BFu15ll_Ip, "aB_BFu15ll_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_L()
{
  {
    init_simple_test("aB_BFu15ll_L");
    static aB_BFu15ll_L lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu15ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_L");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_L");
    check_field_offset(lv, v3, 3, "aB_BFu15ll_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_L(Test_aB_BFu15ll_L, "aB_BFu15ll_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_S()
{
  {
    init_simple_test("aB_BFu15ll_S");
    static aB_BFu15ll_S lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_S");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_S");
    check_field_offset(lv, v3, 3, "aB_BFu15ll_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_S(Test_aB_BFu15ll_S, "aB_BFu15ll_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_Uc()
{
  {
    init_simple_test("aB_BFu15ll_Uc");
    static aB_BFu15ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_Uc");
    check_field_offset(lv, v3, 3, "aB_BFu15ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_Uc(Test_aB_BFu15ll_Uc, "aB_BFu15ll_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_Ui()
{
  {
    init_simple_test("aB_BFu15ll_Ui");
    static aB_BFu15ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_Ui");
    check_field_offset(lv, v3, 3, "aB_BFu15ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_Ui(Test_aB_BFu15ll_Ui, "aB_BFu15ll_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_Ul()
{
  {
    init_simple_test("aB_BFu15ll_Ul");
    static aB_BFu15ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu15ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_Ul");
    check_field_offset(lv, v3, 3, "aB_BFu15ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_Ul(Test_aB_BFu15ll_Ul, "aB_BFu15ll_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_Us()
{
  {
    init_simple_test("aB_BFu15ll_Us");
    static aB_BFu15ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_Us");
    check_field_offset(lv, v3, 3, "aB_BFu15ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_Us(Test_aB_BFu15ll_Us, "aB_BFu15ll_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15ll_Vp()
{
  {
    init_simple_test("aB_BFu15ll_Vp");
    static aB_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu15ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15ll_Vp");
    check_field_offset(lv, v3, 3, "aB_BFu15ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15ll_Vp(Test_aB_BFu15ll_Vp, "aB_BFu15ll_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s()
{
  {
    init_simple_test("aB_BFu15s");
    static aB_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu15s(Test_aB_BFu15s, "aB_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_B()
{
  {
    init_simple_test("aB_BFu15s_B");
    static aB_BFu15s_B lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_B)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_B");
    check_field_offset(lv, v3, 3, "aB_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_B(Test_aB_BFu15s_B, "aB_BFu15s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu15i()
{
  {
    init_simple_test("aB_BFu15s_BFu15i");
    static aB_BFu15s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aB_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu15i(Test_aB_BFu15s_BFu15i, "aB_BFu15s_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu15ll()
{
  {
    init_simple_test("aB_BFu15s_BFu15ll");
    static aB_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aB_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu15ll(Test_aB_BFu15s_BFu15ll, "aB_BFu15s_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu15s()
{
  {
    init_simple_test("aB_BFu15s_BFu15s");
    static aB_BFu15s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aB_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu15s(Test_aB_BFu15s_BFu15s, "aB_BFu15s_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu16i()
{
  {
    init_simple_test("aB_BFu15s_BFu16i");
    static aB_BFu15s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aB_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aB_BFu15s_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu16i(Test_aB_BFu15s_BFu16i, "aB_BFu15s_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu16ll()
{
  {
    init_simple_test("aB_BFu15s_BFu16ll");
    static aB_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aB_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aB_BFu15s_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu16ll(Test_aB_BFu15s_BFu16ll, "aB_BFu15s_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu16s()
{
  {
    init_simple_test("aB_BFu15s_BFu16s");
    static aB_BFu15s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aB_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aB_BFu15s_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu16s(Test_aB_BFu15s_BFu16s, "aB_BFu15s_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu17i()
{
  {
    init_simple_test("aB_BFu15s_BFu17i");
    static aB_BFu15s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aB_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aB_BFu15s_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu17i(Test_aB_BFu15s_BFu17i, "aB_BFu15s_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu17ll()
{
  {
    init_simple_test("aB_BFu15s_BFu17ll");
    static aB_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aB_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aB_BFu15s_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu17ll(Test_aB_BFu15s_BFu17ll, "aB_BFu15s_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu1c()
{
  {
    init_simple_test("aB_BFu15s_BFu1c");
    static aB_BFu15s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aB_BFu15s_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu1c(Test_aB_BFu15s_BFu1c, "aB_BFu15s_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu1i()
{
  {
    init_simple_test("aB_BFu15s_BFu1i");
    static aB_BFu15s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aB_BFu15s_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu1i(Test_aB_BFu15s_BFu1i, "aB_BFu15s_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu1ll()
{
  {
    init_simple_test("aB_BFu15s_BFu1ll");
    static aB_BFu15s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aB_BFu15s_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu1ll(Test_aB_BFu15s_BFu1ll, "aB_BFu15s_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu1s()
{
  {
    init_simple_test("aB_BFu15s_BFu1s");
    static aB_BFu15s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu15s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aB_BFu15s_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu1s(Test_aB_BFu15s_BFu1s, "aB_BFu15s_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu31i()
{
  {
    init_simple_test("aB_BFu15s_BFu31i");
    static aB_BFu15s_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aB_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aB_BFu15s_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu31i(Test_aB_BFu15s_BFu31i, "aB_BFu15s_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu31ll()
{
  {
    init_simple_test("aB_BFu15s_BFu31ll");
    static aB_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aB_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aB_BFu15s_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu31ll(Test_aB_BFu15s_BFu31ll, "aB_BFu15s_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu32i()
{
  {
    init_simple_test("aB_BFu15s_BFu32i");
    static aB_BFu15s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aB_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aB_BFu15s_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu32i(Test_aB_BFu15s_BFu32i, "aB_BFu15s_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu32ll()
{
  {
    init_simple_test("aB_BFu15s_BFu32ll");
    static aB_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aB_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aB_BFu15s_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu32ll(Test_aB_BFu15s_BFu32ll, "aB_BFu15s_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu33()
{
  {
    init_simple_test("aB_BFu15s_BFu33");
    static aB_BFu15s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "aB_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "aB_BFu15s_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu33(Test_aB_BFu15s_BFu33, "aB_BFu15s_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu7c()
{
  {
    init_simple_test("aB_BFu15s_BFu7c");
    static aB_BFu15s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aB_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aB_BFu15s_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu7c(Test_aB_BFu15s_BFu7c, "aB_BFu15s_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu7i()
{
  {
    init_simple_test("aB_BFu15s_BFu7i");
    static aB_BFu15s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aB_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aB_BFu15s_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu7i(Test_aB_BFu15s_BFu7i, "aB_BFu15s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu7ll()
{
  {
    init_simple_test("aB_BFu15s_BFu7ll");
    static aB_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aB_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aB_BFu15s_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu7ll(Test_aB_BFu15s_BFu7ll, "aB_BFu15s_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu7s()
{
  {
    init_simple_test("aB_BFu15s_BFu7s");
    static aB_BFu15s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aB_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aB_BFu15s_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu7s(Test_aB_BFu15s_BFu7s, "aB_BFu15s_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu8c()
{
  {
    init_simple_test("aB_BFu15s_BFu8c");
    static aB_BFu15s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aB_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aB_BFu15s_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu8c(Test_aB_BFu15s_BFu8c, "aB_BFu15s_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu8i()
{
  {
    init_simple_test("aB_BFu15s_BFu8i");
    static aB_BFu15s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aB_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aB_BFu15s_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu8i(Test_aB_BFu15s_BFu8i, "aB_BFu15s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu8ll()
{
  {
    init_simple_test("aB_BFu15s_BFu8ll");
    static aB_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aB_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aB_BFu15s_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu8ll(Test_aB_BFu15s_BFu8ll, "aB_BFu15s_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu8s()
{
  {
    init_simple_test("aB_BFu15s_BFu8s");
    static aB_BFu15s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aB_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aB_BFu15s_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu8s(Test_aB_BFu15s_BFu8s, "aB_BFu15s_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu9i()
{
  {
    init_simple_test("aB_BFu15s_BFu9i");
    static aB_BFu15s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aB_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aB_BFu15s_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu9i(Test_aB_BFu15s_BFu9i, "aB_BFu15s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu9ll()
{
  {
    init_simple_test("aB_BFu15s_BFu9ll");
    static aB_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aB_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aB_BFu15s_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu9ll(Test_aB_BFu15s_BFu9ll, "aB_BFu15s_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_BFu9s()
{
  {
    init_simple_test("aB_BFu15s_BFu9s");
    static aB_BFu15s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aB_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aB_BFu15s_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_BFu9s(Test_aB_BFu15s_BFu9s, "aB_BFu15s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_C()
{
  {
    init_simple_test("aB_BFu15s_C");
    static aB_BFu15s_C lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_C)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_C");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_C");
    check_field_offset(lv, v3, 3, "aB_BFu15s_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_C(Test_aB_BFu15s_C, "aB_BFu15s_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_D()
{
  {
    init_simple_test("aB_BFu15s_D");
    static aB_BFu15s_D lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu15s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_D)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_D");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_D");
    check_field_offset(lv, v3, 3, "aB_BFu15s_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_D(Test_aB_BFu15s_D, "aB_BFu15s_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_F()
{
  {
    init_simple_test("aB_BFu15s_F");
    static aB_BFu15s_F lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_F)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_F");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_F");
    check_field_offset(lv, v3, 3, "aB_BFu15s_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_F(Test_aB_BFu15s_F, "aB_BFu15s_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_I()
{
  {
    init_simple_test("aB_BFu15s_I");
    static aB_BFu15s_I lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_I)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_I");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_I");
    check_field_offset(lv, v3, 3, "aB_BFu15s_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_I(Test_aB_BFu15s_I, "aB_BFu15s_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_Ip()
{
  {
    init_simple_test("aB_BFu15s_Ip");
    static aB_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu15s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_Ip");
    check_field_offset(lv, v3, 3, "aB_BFu15s_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_Ip(Test_aB_BFu15s_Ip, "aB_BFu15s_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_L()
{
  {
    init_simple_test("aB_BFu15s_L");
    static aB_BFu15s_L lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu15s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_L)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_L");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_L");
    check_field_offset(lv, v3, 3, "aB_BFu15s_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_L(Test_aB_BFu15s_L, "aB_BFu15s_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_S()
{
  {
    init_simple_test("aB_BFu15s_S");
    static aB_BFu15s_S lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_S)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_S");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_S");
    check_field_offset(lv, v3, 3, "aB_BFu15s_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_S(Test_aB_BFu15s_S, "aB_BFu15s_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_Uc()
{
  {
    init_simple_test("aB_BFu15s_Uc");
    static aB_BFu15s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu15s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_Uc");
    check_field_offset(lv, v3, 3, "aB_BFu15s_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_Uc(Test_aB_BFu15s_Uc, "aB_BFu15s_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_Ui()
{
  {
    init_simple_test("aB_BFu15s_Ui");
    static aB_BFu15s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu15s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_Ui");
    check_field_offset(lv, v3, 3, "aB_BFu15s_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_Ui(Test_aB_BFu15s_Ui, "aB_BFu15s_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_Ul()
{
  {
    init_simple_test("aB_BFu15s_Ul");
    static aB_BFu15s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu15s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_Ul");
    check_field_offset(lv, v3, 3, "aB_BFu15s_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_Ul(Test_aB_BFu15s_Ul, "aB_BFu15s_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_Us()
{
  {
    init_simple_test("aB_BFu15s_Us");
    static aB_BFu15s_Us lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu15s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_Us");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_Us");
    check_field_offset(lv, v3, 3, "aB_BFu15s_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_Us(Test_aB_BFu15s_Us, "aB_BFu15s_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu15s_Vp()
{
  {
    init_simple_test("aB_BFu15s_Vp");
    static aB_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu15s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aB_BFu15s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aB_BFu15s_Vp");
    check_field_offset(lv, v3, 3, "aB_BFu15s_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu15s_Vp(Test_aB_BFu15s_Vp, "aB_BFu15s_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i()
{
  {
    init_simple_test("aB_BFu16i");
    static aB_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu16i(Test_aB_BFu16i, "aB_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_B()
{
  {
    init_simple_test("aB_BFu16i_B");
    static aB_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_B)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_B");
    check_field_offset(lv, v3, 3, "aB_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_B(Test_aB_BFu16i_B, "aB_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu15i()
{
  {
    init_simple_test("aB_BFu16i_BFu15i");
    static aB_BFu16i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aB_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aB_BFu16i_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu15i(Test_aB_BFu16i_BFu15i, "aB_BFu16i_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu15ll()
{
  {
    init_simple_test("aB_BFu16i_BFu15ll");
    static aB_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aB_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aB_BFu16i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu15ll(Test_aB_BFu16i_BFu15ll, "aB_BFu16i_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu15s()
{
  {
    init_simple_test("aB_BFu16i_BFu15s");
    static aB_BFu16i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aB_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aB_BFu16i_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu15s(Test_aB_BFu16i_BFu15s, "aB_BFu16i_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu16i()
{
  {
    init_simple_test("aB_BFu16i_BFu16i");
    static aB_BFu16i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aB_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu16i(Test_aB_BFu16i_BFu16i, "aB_BFu16i_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu16ll()
{
  {
    init_simple_test("aB_BFu16i_BFu16ll");
    static aB_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aB_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu16ll(Test_aB_BFu16i_BFu16ll, "aB_BFu16i_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu16s()
{
  {
    init_simple_test("aB_BFu16i_BFu16s");
    static aB_BFu16i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aB_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu16s(Test_aB_BFu16i_BFu16s, "aB_BFu16i_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu17i()
{
  {
    init_simple_test("aB_BFu16i_BFu17i");
    static aB_BFu16i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu16i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aB_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aB_BFu16i_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu17i(Test_aB_BFu16i_BFu17i, "aB_BFu16i_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu17ll()
{
  {
    init_simple_test("aB_BFu16i_BFu17ll");
    static aB_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu16i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aB_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aB_BFu16i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu17ll(Test_aB_BFu16i_BFu17ll, "aB_BFu16i_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu1c()
{
  {
    init_simple_test("aB_BFu16i_BFu1c");
    static aB_BFu16i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aB_BFu16i_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu1c(Test_aB_BFu16i_BFu1c, "aB_BFu16i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu1i()
{
  {
    init_simple_test("aB_BFu16i_BFu1i");
    static aB_BFu16i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aB_BFu16i_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu1i(Test_aB_BFu16i_BFu1i, "aB_BFu16i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu1ll()
{
  {
    init_simple_test("aB_BFu16i_BFu1ll");
    static aB_BFu16i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aB_BFu16i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu1ll(Test_aB_BFu16i_BFu1ll, "aB_BFu16i_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu1s()
{
  {
    init_simple_test("aB_BFu16i_BFu1s");
    static aB_BFu16i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aB_BFu16i_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu1s(Test_aB_BFu16i_BFu1s, "aB_BFu16i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu31i()
{
  {
    init_simple_test("aB_BFu16i_BFu31i");
    static aB_BFu16i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aB_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aB_BFu16i_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu31i(Test_aB_BFu16i_BFu31i, "aB_BFu16i_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu31ll()
{
  {
    init_simple_test("aB_BFu16i_BFu31ll");
    static aB_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aB_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aB_BFu16i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu31ll(Test_aB_BFu16i_BFu31ll, "aB_BFu16i_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu32i()
{
  {
    init_simple_test("aB_BFu16i_BFu32i");
    static aB_BFu16i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aB_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aB_BFu16i_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu32i(Test_aB_BFu16i_BFu32i, "aB_BFu16i_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu32ll()
{
  {
    init_simple_test("aB_BFu16i_BFu32ll");
    static aB_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aB_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aB_BFu16i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu32ll(Test_aB_BFu16i_BFu32ll, "aB_BFu16i_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu33()
{
  {
    init_simple_test("aB_BFu16i_BFu33");
    static aB_BFu16i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu16i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aB_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aB_BFu16i_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu33(Test_aB_BFu16i_BFu33, "aB_BFu16i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu7c()
{
  {
    init_simple_test("aB_BFu16i_BFu7c");
    static aB_BFu16i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aB_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aB_BFu16i_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu7c(Test_aB_BFu16i_BFu7c, "aB_BFu16i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu7i()
{
  {
    init_simple_test("aB_BFu16i_BFu7i");
    static aB_BFu16i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aB_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aB_BFu16i_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu7i(Test_aB_BFu16i_BFu7i, "aB_BFu16i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu7ll()
{
  {
    init_simple_test("aB_BFu16i_BFu7ll");
    static aB_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aB_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aB_BFu16i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu7ll(Test_aB_BFu16i_BFu7ll, "aB_BFu16i_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu7s()
{
  {
    init_simple_test("aB_BFu16i_BFu7s");
    static aB_BFu16i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aB_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aB_BFu16i_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu7s(Test_aB_BFu16i_BFu7s, "aB_BFu16i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu8c()
{
  {
    init_simple_test("aB_BFu16i_BFu8c");
    static aB_BFu16i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aB_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aB_BFu16i_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu8c(Test_aB_BFu16i_BFu8c, "aB_BFu16i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu8i()
{
  {
    init_simple_test("aB_BFu16i_BFu8i");
    static aB_BFu16i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aB_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aB_BFu16i_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu8i(Test_aB_BFu16i_BFu8i, "aB_BFu16i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu8ll()
{
  {
    init_simple_test("aB_BFu16i_BFu8ll");
    static aB_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aB_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aB_BFu16i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu8ll(Test_aB_BFu16i_BFu8ll, "aB_BFu16i_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu8s()
{
  {
    init_simple_test("aB_BFu16i_BFu8s");
    static aB_BFu16i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aB_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aB_BFu16i_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu8s(Test_aB_BFu16i_BFu8s, "aB_BFu16i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu9i()
{
  {
    init_simple_test("aB_BFu16i_BFu9i");
    static aB_BFu16i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aB_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aB_BFu16i_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu9i(Test_aB_BFu16i_BFu9i, "aB_BFu16i_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu9ll()
{
  {
    init_simple_test("aB_BFu16i_BFu9ll");
    static aB_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aB_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aB_BFu16i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu9ll(Test_aB_BFu16i_BFu9ll, "aB_BFu16i_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_BFu9s()
{
  {
    init_simple_test("aB_BFu16i_BFu9s");
    static aB_BFu16i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aB_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aB_BFu16i_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_BFu9s(Test_aB_BFu16i_BFu9s, "aB_BFu16i_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_C()
{
  {
    init_simple_test("aB_BFu16i_C");
    static aB_BFu16i_C lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_C)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_C");
    check_field_offset(lv, v3, 3, "aB_BFu16i_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_C(Test_aB_BFu16i_C, "aB_BFu16i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_D()
{
  {
    init_simple_test("aB_BFu16i_D");
    static aB_BFu16i_D lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu16i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_D)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_D");
    check_field_offset(lv, v3, 3, "aB_BFu16i_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_D(Test_aB_BFu16i_D, "aB_BFu16i_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_F()
{
  {
    init_simple_test("aB_BFu16i_F");
    static aB_BFu16i_F lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_F)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_F");
    check_field_offset(lv, v3, 3, "aB_BFu16i_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_F(Test_aB_BFu16i_F, "aB_BFu16i_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_I()
{
  {
    init_simple_test("aB_BFu16i_I");
    static aB_BFu16i_I lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_I)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_I");
    check_field_offset(lv, v3, 3, "aB_BFu16i_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_I(Test_aB_BFu16i_I, "aB_BFu16i_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_Ip()
{
  {
    init_simple_test("aB_BFu16i_Ip");
    static aB_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu16i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_Ip");
    check_field_offset(lv, v3, 3, "aB_BFu16i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_Ip(Test_aB_BFu16i_Ip, "aB_BFu16i_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_L()
{
  {
    init_simple_test("aB_BFu16i_L");
    static aB_BFu16i_L lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu16i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_L)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_L");
    check_field_offset(lv, v3, 3, "aB_BFu16i_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_L(Test_aB_BFu16i_L, "aB_BFu16i_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_S()
{
  {
    init_simple_test("aB_BFu16i_S");
    static aB_BFu16i_S lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_S)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_S");
    check_field_offset(lv, v3, 3, "aB_BFu16i_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_S(Test_aB_BFu16i_S, "aB_BFu16i_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_Uc()
{
  {
    init_simple_test("aB_BFu16i_Uc");
    static aB_BFu16i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_Uc");
    check_field_offset(lv, v3, 3, "aB_BFu16i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_Uc(Test_aB_BFu16i_Uc, "aB_BFu16i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_Ui()
{
  {
    init_simple_test("aB_BFu16i_Ui");
    static aB_BFu16i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_Ui");
    check_field_offset(lv, v3, 3, "aB_BFu16i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_Ui(Test_aB_BFu16i_Ui, "aB_BFu16i_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_Ul()
{
  {
    init_simple_test("aB_BFu16i_Ul");
    static aB_BFu16i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu16i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_Ul");
    check_field_offset(lv, v3, 3, "aB_BFu16i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_Ul(Test_aB_BFu16i_Ul, "aB_BFu16i_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_Us()
{
  {
    init_simple_test("aB_BFu16i_Us");
    static aB_BFu16i_Us lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_Us");
    check_field_offset(lv, v3, 3, "aB_BFu16i_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_Us(Test_aB_BFu16i_Us, "aB_BFu16i_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16i_Vp()
{
  {
    init_simple_test("aB_BFu16i_Vp");
    static aB_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu16i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16i_Vp");
    check_field_offset(lv, v3, 3, "aB_BFu16i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16i_Vp(Test_aB_BFu16i_Vp, "aB_BFu16i_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll()
{
  {
    init_simple_test("aB_BFu16ll");
    static aB_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll(Test_aB_BFu16ll, "aB_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_B()
{
  {
    init_simple_test("aB_BFu16ll_B");
    static aB_BFu16ll_B lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_B)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_B");
    check_field_offset(lv, v3, 3, "aB_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_B(Test_aB_BFu16ll_B, "aB_BFu16ll_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu15i()
{
  {
    init_simple_test("aB_BFu16ll_BFu15i");
    static aB_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aB_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aB_BFu16ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu15i(Test_aB_BFu16ll_BFu15i, "aB_BFu16ll_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu15ll()
{
  {
    init_simple_test("aB_BFu16ll_BFu15ll");
    static aB_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aB_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aB_BFu16ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu15ll(Test_aB_BFu16ll_BFu15ll, "aB_BFu16ll_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu15s()
{
  {
    init_simple_test("aB_BFu16ll_BFu15s");
    static aB_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aB_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aB_BFu16ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu15s(Test_aB_BFu16ll_BFu15s, "aB_BFu16ll_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu16i()
{
  {
    init_simple_test("aB_BFu16ll_BFu16i");
    static aB_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aB_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu16i(Test_aB_BFu16ll_BFu16i, "aB_BFu16ll_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu16ll()
{
  {
    init_simple_test("aB_BFu16ll_BFu16ll");
    static aB_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aB_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu16ll(Test_aB_BFu16ll_BFu16ll, "aB_BFu16ll_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu16s()
{
  {
    init_simple_test("aB_BFu16ll_BFu16s");
    static aB_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aB_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu16s(Test_aB_BFu16ll_BFu16s, "aB_BFu16ll_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu17i()
{
  {
    init_simple_test("aB_BFu16ll_BFu17i");
    static aB_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu16ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aB_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aB_BFu16ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu17i(Test_aB_BFu16ll_BFu17i, "aB_BFu16ll_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu17ll()
{
  {
    init_simple_test("aB_BFu16ll_BFu17ll");
    static aB_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aB_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aB_BFu16ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu17ll(Test_aB_BFu16ll_BFu17ll, "aB_BFu16ll_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu1c()
{
  {
    init_simple_test("aB_BFu16ll_BFu1c");
    static aB_BFu16ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aB_BFu16ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu1c(Test_aB_BFu16ll_BFu1c, "aB_BFu16ll_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu1i()
{
  {
    init_simple_test("aB_BFu16ll_BFu1i");
    static aB_BFu16ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aB_BFu16ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu1i(Test_aB_BFu16ll_BFu1i, "aB_BFu16ll_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu1ll()
{
  {
    init_simple_test("aB_BFu16ll_BFu1ll");
    static aB_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aB_BFu16ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu1ll(Test_aB_BFu16ll_BFu1ll, "aB_BFu16ll_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu1s()
{
  {
    init_simple_test("aB_BFu16ll_BFu1s");
    static aB_BFu16ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aB_BFu16ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu1s(Test_aB_BFu16ll_BFu1s, "aB_BFu16ll_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu31i()
{
  {
    init_simple_test("aB_BFu16ll_BFu31i");
    static aB_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aB_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aB_BFu16ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu31i(Test_aB_BFu16ll_BFu31i, "aB_BFu16ll_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu31ll()
{
  {
    init_simple_test("aB_BFu16ll_BFu31ll");
    static aB_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aB_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aB_BFu16ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu31ll(Test_aB_BFu16ll_BFu31ll, "aB_BFu16ll_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu32i()
{
  {
    init_simple_test("aB_BFu16ll_BFu32i");
    static aB_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aB_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aB_BFu16ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu32i(Test_aB_BFu16ll_BFu32i, "aB_BFu16ll_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu32ll()
{
  {
    init_simple_test("aB_BFu16ll_BFu32ll");
    static aB_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aB_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aB_BFu16ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu32ll(Test_aB_BFu16ll_BFu32ll, "aB_BFu16ll_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu33()
{
  {
    init_simple_test("aB_BFu16ll_BFu33");
    static aB_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu16ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aB_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aB_BFu16ll_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu33(Test_aB_BFu16ll_BFu33, "aB_BFu16ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu7c()
{
  {
    init_simple_test("aB_BFu16ll_BFu7c");
    static aB_BFu16ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aB_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aB_BFu16ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu7c(Test_aB_BFu16ll_BFu7c, "aB_BFu16ll_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu7i()
{
  {
    init_simple_test("aB_BFu16ll_BFu7i");
    static aB_BFu16ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aB_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aB_BFu16ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu7i(Test_aB_BFu16ll_BFu7i, "aB_BFu16ll_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu7ll()
{
  {
    init_simple_test("aB_BFu16ll_BFu7ll");
    static aB_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aB_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aB_BFu16ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu7ll(Test_aB_BFu16ll_BFu7ll, "aB_BFu16ll_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu7s()
{
  {
    init_simple_test("aB_BFu16ll_BFu7s");
    static aB_BFu16ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aB_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aB_BFu16ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu7s(Test_aB_BFu16ll_BFu7s, "aB_BFu16ll_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu8c()
{
  {
    init_simple_test("aB_BFu16ll_BFu8c");
    static aB_BFu16ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aB_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aB_BFu16ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu8c(Test_aB_BFu16ll_BFu8c, "aB_BFu16ll_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu8i()
{
  {
    init_simple_test("aB_BFu16ll_BFu8i");
    static aB_BFu16ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aB_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aB_BFu16ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu8i(Test_aB_BFu16ll_BFu8i, "aB_BFu16ll_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu8ll()
{
  {
    init_simple_test("aB_BFu16ll_BFu8ll");
    static aB_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aB_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aB_BFu16ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu8ll(Test_aB_BFu16ll_BFu8ll, "aB_BFu16ll_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu8s()
{
  {
    init_simple_test("aB_BFu16ll_BFu8s");
    static aB_BFu16ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aB_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aB_BFu16ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu8s(Test_aB_BFu16ll_BFu8s, "aB_BFu16ll_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu9i()
{
  {
    init_simple_test("aB_BFu16ll_BFu9i");
    static aB_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aB_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aB_BFu16ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu9i(Test_aB_BFu16ll_BFu9i, "aB_BFu16ll_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu9ll()
{
  {
    init_simple_test("aB_BFu16ll_BFu9ll");
    static aB_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aB_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aB_BFu16ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu9ll(Test_aB_BFu16ll_BFu9ll, "aB_BFu16ll_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_BFu9s()
{
  {
    init_simple_test("aB_BFu16ll_BFu9s");
    static aB_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aB_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aB_BFu16ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_BFu9s(Test_aB_BFu16ll_BFu9s, "aB_BFu16ll_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_C()
{
  {
    init_simple_test("aB_BFu16ll_C");
    static aB_BFu16ll_C lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_C");
    check_field_offset(lv, v3, 3, "aB_BFu16ll_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_C(Test_aB_BFu16ll_C, "aB_BFu16ll_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_D()
{
  {
    init_simple_test("aB_BFu16ll_D");
    static aB_BFu16ll_D lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu16ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_D");
    check_field_offset(lv, v3, 3, "aB_BFu16ll_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_D(Test_aB_BFu16ll_D, "aB_BFu16ll_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_F()
{
  {
    init_simple_test("aB_BFu16ll_F");
    static aB_BFu16ll_F lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_F");
    check_field_offset(lv, v3, 3, "aB_BFu16ll_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_F(Test_aB_BFu16ll_F, "aB_BFu16ll_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_I()
{
  {
    init_simple_test("aB_BFu16ll_I");
    static aB_BFu16ll_I lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_I");
    check_field_offset(lv, v3, 3, "aB_BFu16ll_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_I(Test_aB_BFu16ll_I, "aB_BFu16ll_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_Ip()
{
  {
    init_simple_test("aB_BFu16ll_Ip");
    static aB_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu16ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_Ip");
    check_field_offset(lv, v3, 3, "aB_BFu16ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_Ip(Test_aB_BFu16ll_Ip, "aB_BFu16ll_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_L()
{
  {
    init_simple_test("aB_BFu16ll_L");
    static aB_BFu16ll_L lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu16ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_L");
    check_field_offset(lv, v3, 3, "aB_BFu16ll_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_L(Test_aB_BFu16ll_L, "aB_BFu16ll_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_S()
{
  {
    init_simple_test("aB_BFu16ll_S");
    static aB_BFu16ll_S lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_S");
    check_field_offset(lv, v3, 3, "aB_BFu16ll_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_S(Test_aB_BFu16ll_S, "aB_BFu16ll_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_Uc()
{
  {
    init_simple_test("aB_BFu16ll_Uc");
    static aB_BFu16ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_Uc");
    check_field_offset(lv, v3, 3, "aB_BFu16ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_Uc(Test_aB_BFu16ll_Uc, "aB_BFu16ll_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_Ui()
{
  {
    init_simple_test("aB_BFu16ll_Ui");
    static aB_BFu16ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_Ui");
    check_field_offset(lv, v3, 3, "aB_BFu16ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_Ui(Test_aB_BFu16ll_Ui, "aB_BFu16ll_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_Ul()
{
  {
    init_simple_test("aB_BFu16ll_Ul");
    static aB_BFu16ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu16ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_Ul");
    check_field_offset(lv, v3, 3, "aB_BFu16ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_Ul(Test_aB_BFu16ll_Ul, "aB_BFu16ll_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_Us()
{
  {
    init_simple_test("aB_BFu16ll_Us");
    static aB_BFu16ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_Us");
    check_field_offset(lv, v3, 3, "aB_BFu16ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_Us(Test_aB_BFu16ll_Us, "aB_BFu16ll_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16ll_Vp()
{
  {
    init_simple_test("aB_BFu16ll_Vp");
    static aB_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu16ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16ll_Vp");
    check_field_offset(lv, v3, 3, "aB_BFu16ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16ll_Vp(Test_aB_BFu16ll_Vp, "aB_BFu16ll_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s()
{
  {
    init_simple_test("aB_BFu16s");
    static aB_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu16s(Test_aB_BFu16s, "aB_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_B()
{
  {
    init_simple_test("aB_BFu16s_B");
    static aB_BFu16s_B lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_B)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_B");
    check_field_offset(lv, v3, 3, "aB_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_B(Test_aB_BFu16s_B, "aB_BFu16s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu15i()
{
  {
    init_simple_test("aB_BFu16s_BFu15i");
    static aB_BFu16s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aB_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aB_BFu16s_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu15i(Test_aB_BFu16s_BFu15i, "aB_BFu16s_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu15ll()
{
  {
    init_simple_test("aB_BFu16s_BFu15ll");
    static aB_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aB_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aB_BFu16s_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu15ll(Test_aB_BFu16s_BFu15ll, "aB_BFu16s_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu15s()
{
  {
    init_simple_test("aB_BFu16s_BFu15s");
    static aB_BFu16s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aB_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aB_BFu16s_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu15s(Test_aB_BFu16s_BFu15s, "aB_BFu16s_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu16i()
{
  {
    init_simple_test("aB_BFu16s_BFu16i");
    static aB_BFu16s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aB_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu16i(Test_aB_BFu16s_BFu16i, "aB_BFu16s_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu16ll()
{
  {
    init_simple_test("aB_BFu16s_BFu16ll");
    static aB_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aB_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu16ll(Test_aB_BFu16s_BFu16ll, "aB_BFu16s_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu16s()
{
  {
    init_simple_test("aB_BFu16s_BFu16s");
    static aB_BFu16s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aB_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu16s(Test_aB_BFu16s_BFu16s, "aB_BFu16s_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu17i()
{
  {
    init_simple_test("aB_BFu16s_BFu17i");
    static aB_BFu16s_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu16s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aB_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aB_BFu16s_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu17i(Test_aB_BFu16s_BFu17i, "aB_BFu16s_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu17ll()
{
  {
    init_simple_test("aB_BFu16s_BFu17ll");
    static aB_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu16s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aB_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aB_BFu16s_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu17ll(Test_aB_BFu16s_BFu17ll, "aB_BFu16s_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu1c()
{
  {
    init_simple_test("aB_BFu16s_BFu1c");
    static aB_BFu16s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aB_BFu16s_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu1c(Test_aB_BFu16s_BFu1c, "aB_BFu16s_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu1i()
{
  {
    init_simple_test("aB_BFu16s_BFu1i");
    static aB_BFu16s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aB_BFu16s_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu1i(Test_aB_BFu16s_BFu1i, "aB_BFu16s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu1ll()
{
  {
    init_simple_test("aB_BFu16s_BFu1ll");
    static aB_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aB_BFu16s_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu1ll(Test_aB_BFu16s_BFu1ll, "aB_BFu16s_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu1s()
{
  {
    init_simple_test("aB_BFu16s_BFu1s");
    static aB_BFu16s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aB_BFu16s_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu1s(Test_aB_BFu16s_BFu1s, "aB_BFu16s_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu31i()
{
  {
    init_simple_test("aB_BFu16s_BFu31i");
    static aB_BFu16s_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aB_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aB_BFu16s_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu31i(Test_aB_BFu16s_BFu31i, "aB_BFu16s_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu31ll()
{
  {
    init_simple_test("aB_BFu16s_BFu31ll");
    static aB_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aB_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aB_BFu16s_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu31ll(Test_aB_BFu16s_BFu31ll, "aB_BFu16s_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu32i()
{
  {
    init_simple_test("aB_BFu16s_BFu32i");
    static aB_BFu16s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aB_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aB_BFu16s_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu32i(Test_aB_BFu16s_BFu32i, "aB_BFu16s_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu32ll()
{
  {
    init_simple_test("aB_BFu16s_BFu32ll");
    static aB_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aB_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aB_BFu16s_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu32ll(Test_aB_BFu16s_BFu32ll, "aB_BFu16s_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu33()
{
  {
    init_simple_test("aB_BFu16s_BFu33");
    static aB_BFu16s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu16s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aB_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aB_BFu16s_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu33(Test_aB_BFu16s_BFu33, "aB_BFu16s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu7c()
{
  {
    init_simple_test("aB_BFu16s_BFu7c");
    static aB_BFu16s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aB_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aB_BFu16s_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu7c(Test_aB_BFu16s_BFu7c, "aB_BFu16s_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu7i()
{
  {
    init_simple_test("aB_BFu16s_BFu7i");
    static aB_BFu16s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aB_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aB_BFu16s_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu7i(Test_aB_BFu16s_BFu7i, "aB_BFu16s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu7ll()
{
  {
    init_simple_test("aB_BFu16s_BFu7ll");
    static aB_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aB_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aB_BFu16s_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu7ll(Test_aB_BFu16s_BFu7ll, "aB_BFu16s_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu7s()
{
  {
    init_simple_test("aB_BFu16s_BFu7s");
    static aB_BFu16s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aB_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aB_BFu16s_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu7s(Test_aB_BFu16s_BFu7s, "aB_BFu16s_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu8c()
{
  {
    init_simple_test("aB_BFu16s_BFu8c");
    static aB_BFu16s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aB_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aB_BFu16s_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu8c(Test_aB_BFu16s_BFu8c, "aB_BFu16s_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu8i()
{
  {
    init_simple_test("aB_BFu16s_BFu8i");
    static aB_BFu16s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aB_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aB_BFu16s_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu8i(Test_aB_BFu16s_BFu8i, "aB_BFu16s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu8ll()
{
  {
    init_simple_test("aB_BFu16s_BFu8ll");
    static aB_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aB_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aB_BFu16s_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu8ll(Test_aB_BFu16s_BFu8ll, "aB_BFu16s_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu8s()
{
  {
    init_simple_test("aB_BFu16s_BFu8s");
    static aB_BFu16s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aB_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aB_BFu16s_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu8s(Test_aB_BFu16s_BFu8s, "aB_BFu16s_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu9i()
{
  {
    init_simple_test("aB_BFu16s_BFu9i");
    static aB_BFu16s_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aB_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aB_BFu16s_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu9i(Test_aB_BFu16s_BFu9i, "aB_BFu16s_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu9ll()
{
  {
    init_simple_test("aB_BFu16s_BFu9ll");
    static aB_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aB_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aB_BFu16s_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu9ll(Test_aB_BFu16s_BFu9ll, "aB_BFu16s_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_BFu9s()
{
  {
    init_simple_test("aB_BFu16s_BFu9s");
    static aB_BFu16s_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aB_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aB_BFu16s_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_BFu9s(Test_aB_BFu16s_BFu9s, "aB_BFu16s_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_C()
{
  {
    init_simple_test("aB_BFu16s_C");
    static aB_BFu16s_C lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_C)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_C");
    check_field_offset(lv, v3, 3, "aB_BFu16s_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_C(Test_aB_BFu16s_C, "aB_BFu16s_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_D()
{
  {
    init_simple_test("aB_BFu16s_D");
    static aB_BFu16s_D lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu16s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_D)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_D");
    check_field_offset(lv, v3, 3, "aB_BFu16s_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_D(Test_aB_BFu16s_D, "aB_BFu16s_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_F()
{
  {
    init_simple_test("aB_BFu16s_F");
    static aB_BFu16s_F lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_F)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_F");
    check_field_offset(lv, v3, 3, "aB_BFu16s_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_F(Test_aB_BFu16s_F, "aB_BFu16s_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_I()
{
  {
    init_simple_test("aB_BFu16s_I");
    static aB_BFu16s_I lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_I)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_I");
    check_field_offset(lv, v3, 3, "aB_BFu16s_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_I(Test_aB_BFu16s_I, "aB_BFu16s_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_Ip()
{
  {
    init_simple_test("aB_BFu16s_Ip");
    static aB_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu16s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_Ip");
    check_field_offset(lv, v3, 3, "aB_BFu16s_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_Ip(Test_aB_BFu16s_Ip, "aB_BFu16s_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_L()
{
  {
    init_simple_test("aB_BFu16s_L");
    static aB_BFu16s_L lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu16s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_L)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_L");
    check_field_offset(lv, v3, 3, "aB_BFu16s_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_L(Test_aB_BFu16s_L, "aB_BFu16s_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_S()
{
  {
    init_simple_test("aB_BFu16s_S");
    static aB_BFu16s_S lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_S)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_S");
    check_field_offset(lv, v3, 3, "aB_BFu16s_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_S(Test_aB_BFu16s_S, "aB_BFu16s_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_Uc()
{
  {
    init_simple_test("aB_BFu16s_Uc");
    static aB_BFu16s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu16s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_Uc");
    check_field_offset(lv, v3, 3, "aB_BFu16s_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_Uc(Test_aB_BFu16s_Uc, "aB_BFu16s_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_Ui()
{
  {
    init_simple_test("aB_BFu16s_Ui");
    static aB_BFu16s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu16s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_Ui");
    check_field_offset(lv, v3, 3, "aB_BFu16s_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_Ui(Test_aB_BFu16s_Ui, "aB_BFu16s_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_Ul()
{
  {
    init_simple_test("aB_BFu16s_Ul");
    static aB_BFu16s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aB_BFu16s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_Ul");
    check_field_offset(lv, v3, 3, "aB_BFu16s_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_Ul(Test_aB_BFu16s_Ul, "aB_BFu16s_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_Us()
{
  {
    init_simple_test("aB_BFu16s_Us");
    static aB_BFu16s_Us lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu16s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_Us");
    check_field_offset(lv, v3, 3, "aB_BFu16s_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_Us(Test_aB_BFu16s_Us, "aB_BFu16s_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu16s_Vp()
{
  {
    init_simple_test("aB_BFu16s_Vp");
    static aB_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aB_BFu16s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aB_BFu16s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aB_BFu16s_Vp");
    check_field_offset(lv, v3, 3, "aB_BFu16s_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu16s_Vp(Test_aB_BFu16s_Vp, "aB_BFu16s_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i()
{
  {
    init_simple_test("aB_BFu17i");
    static aB_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu17i(Test_aB_BFu17i, "aB_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_B()
{
  {
    init_simple_test("aB_BFu17i_B");
    static aB_BFu17i_B lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_B)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_B");
    check_field_offset(lv, v3, 4, "aB_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_B(Test_aB_BFu17i_B, "aB_BFu17i_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu15i()
{
  {
    init_simple_test("aB_BFu17i_BFu15i");
    static aB_BFu17i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aB_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aB_BFu17i_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu15i(Test_aB_BFu17i_BFu15i, "aB_BFu17i_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu15ll()
{
  {
    init_simple_test("aB_BFu17i_BFu15ll");
    static aB_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aB_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aB_BFu17i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu15ll(Test_aB_BFu17i_BFu15ll, "aB_BFu17i_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu15s()
{
  {
    init_simple_test("aB_BFu17i_BFu15s");
    static aB_BFu17i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aB_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aB_BFu17i_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu15s(Test_aB_BFu17i_BFu15s, "aB_BFu17i_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu16i()
{
  {
    init_simple_test("aB_BFu17i_BFu16i");
    static aB_BFu17i_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aB_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aB_BFu17i_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu16i(Test_aB_BFu17i_BFu16i, "aB_BFu17i_BFu16i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu16ll()
{
  {
    init_simple_test("aB_BFu17i_BFu16ll");
    static aB_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aB_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aB_BFu17i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu16ll(Test_aB_BFu17i_BFu16ll, "aB_BFu17i_BFu16ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu16s()
{
  {
    init_simple_test("aB_BFu17i_BFu16s");
    static aB_BFu17i_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aB_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aB_BFu17i_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu16s(Test_aB_BFu17i_BFu16s, "aB_BFu17i_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu17i()
{
  {
    init_simple_test("aB_BFu17i_BFu17i");
    static aB_BFu17i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aB_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu17i(Test_aB_BFu17i_BFu17i, "aB_BFu17i_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu17ll()
{
  {
    init_simple_test("aB_BFu17i_BFu17ll");
    static aB_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aB_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu17ll(Test_aB_BFu17i_BFu17ll, "aB_BFu17i_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu1c()
{
  {
    init_simple_test("aB_BFu17i_BFu1c");
    static aB_BFu17i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aB_BFu17i_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu1c(Test_aB_BFu17i_BFu1c, "aB_BFu17i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu1i()
{
  {
    init_simple_test("aB_BFu17i_BFu1i");
    static aB_BFu17i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aB_BFu17i_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu1i(Test_aB_BFu17i_BFu1i, "aB_BFu17i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu1ll()
{
  {
    init_simple_test("aB_BFu17i_BFu1ll");
    static aB_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aB_BFu17i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu1ll(Test_aB_BFu17i_BFu1ll, "aB_BFu17i_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu1s()
{
  {
    init_simple_test("aB_BFu17i_BFu1s");
    static aB_BFu17i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aB_BFu17i_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu1s(Test_aB_BFu17i_BFu1s, "aB_BFu17i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu31i()
{
  {
    init_simple_test("aB_BFu17i_BFu31i");
    static aB_BFu17i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu17i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "aB_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "aB_BFu17i_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu31i(Test_aB_BFu17i_BFu31i, "aB_BFu17i_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu31ll()
{
  {
    init_simple_test("aB_BFu17i_BFu31ll");
    static aB_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu17i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "aB_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "aB_BFu17i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu31ll(Test_aB_BFu17i_BFu31ll, "aB_BFu17i_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu32i()
{
  {
    init_simple_test("aB_BFu17i_BFu32i");
    static aB_BFu17i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu17i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "aB_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "aB_BFu17i_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu32i(Test_aB_BFu17i_BFu32i, "aB_BFu17i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu32ll()
{
  {
    init_simple_test("aB_BFu17i_BFu32ll");
    static aB_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu17i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "aB_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "aB_BFu17i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu32ll(Test_aB_BFu17i_BFu32ll, "aB_BFu17i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu33()
{
  {
    init_simple_test("aB_BFu17i_BFu33");
    static aB_BFu17i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu17i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "aB_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "aB_BFu17i_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu33(Test_aB_BFu17i_BFu33, "aB_BFu17i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu7c()
{
  {
    init_simple_test("aB_BFu17i_BFu7c");
    static aB_BFu17i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aB_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aB_BFu17i_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu7c(Test_aB_BFu17i_BFu7c, "aB_BFu17i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu7i()
{
  {
    init_simple_test("aB_BFu17i_BFu7i");
    static aB_BFu17i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aB_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aB_BFu17i_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu7i(Test_aB_BFu17i_BFu7i, "aB_BFu17i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu7ll()
{
  {
    init_simple_test("aB_BFu17i_BFu7ll");
    static aB_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aB_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aB_BFu17i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu7ll(Test_aB_BFu17i_BFu7ll, "aB_BFu17i_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu7s()
{
  {
    init_simple_test("aB_BFu17i_BFu7s");
    static aB_BFu17i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aB_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aB_BFu17i_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu7s(Test_aB_BFu17i_BFu7s, "aB_BFu17i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu8c()
{
  {
    init_simple_test("aB_BFu17i_BFu8c");
    static aB_BFu17i_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aB_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aB_BFu17i_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu8c(Test_aB_BFu17i_BFu8c, "aB_BFu17i_BFu8c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu8i()
{
  {
    init_simple_test("aB_BFu17i_BFu8i");
    static aB_BFu17i_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aB_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aB_BFu17i_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu8i(Test_aB_BFu17i_BFu8i, "aB_BFu17i_BFu8i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu8ll()
{
  {
    init_simple_test("aB_BFu17i_BFu8ll");
    static aB_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aB_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aB_BFu17i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu8ll(Test_aB_BFu17i_BFu8ll, "aB_BFu17i_BFu8ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu8s()
{
  {
    init_simple_test("aB_BFu17i_BFu8s");
    static aB_BFu17i_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aB_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aB_BFu17i_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu8s(Test_aB_BFu17i_BFu8s, "aB_BFu17i_BFu8s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu9i()
{
  {
    init_simple_test("aB_BFu17i_BFu9i");
    static aB_BFu17i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aB_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aB_BFu17i_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu9i(Test_aB_BFu17i_BFu9i, "aB_BFu17i_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu9ll()
{
  {
    init_simple_test("aB_BFu17i_BFu9ll");
    static aB_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aB_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aB_BFu17i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu9ll(Test_aB_BFu17i_BFu9ll, "aB_BFu17i_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_BFu9s()
{
  {
    init_simple_test("aB_BFu17i_BFu9s");
    static aB_BFu17i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aB_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aB_BFu17i_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_BFu9s(Test_aB_BFu17i_BFu9s, "aB_BFu17i_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_C()
{
  {
    init_simple_test("aB_BFu17i_C");
    static aB_BFu17i_C lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_C)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_C");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_C");
    check_field_offset(lv, v3, 4, "aB_BFu17i_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_C(Test_aB_BFu17i_C, "aB_BFu17i_C", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_D()
{
  {
    init_simple_test("aB_BFu17i_D");
    static aB_BFu17i_D lv;
    check2(sizeof(lv), 12, "sizeof(aB_BFu17i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_D)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_D");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_D");
    check_field_offset(lv, v3, 4, "aB_BFu17i_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_D(Test_aB_BFu17i_D, "aB_BFu17i_D", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_F()
{
  {
    init_simple_test("aB_BFu17i_F");
    static aB_BFu17i_F lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu17i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_F)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_F");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_F");
    check_field_offset(lv, v3, 4, "aB_BFu17i_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_F(Test_aB_BFu17i_F, "aB_BFu17i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_I()
{
  {
    init_simple_test("aB_BFu17i_I");
    static aB_BFu17i_I lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu17i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_I)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_I");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_I");
    check_field_offset(lv, v3, 4, "aB_BFu17i_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_I(Test_aB_BFu17i_I, "aB_BFu17i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_Ip()
{
  {
    init_simple_test("aB_BFu17i_Ip");
    static aB_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_BFu17i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_Ip");
    check_field_offset(lv, v3, 4, "aB_BFu17i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_Ip(Test_aB_BFu17i_Ip, "aB_BFu17i_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_L()
{
  {
    init_simple_test("aB_BFu17i_L");
    static aB_BFu17i_L lv;
    check2(sizeof(lv), 12, "sizeof(aB_BFu17i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_L)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_L");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_L");
    check_field_offset(lv, v3, 4, "aB_BFu17i_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_L(Test_aB_BFu17i_L, "aB_BFu17i_L", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_S()
{
  {
    init_simple_test("aB_BFu17i_S");
    static aB_BFu17i_S lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_S)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_S");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_S");
    check_field_offset(lv, v3, 4, "aB_BFu17i_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_S(Test_aB_BFu17i_S, "aB_BFu17i_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_Uc()
{
  {
    init_simple_test("aB_BFu17i_Uc");
    static aB_BFu17i_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_Uc");
    check_field_offset(lv, v3, 4, "aB_BFu17i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_Uc(Test_aB_BFu17i_Uc, "aB_BFu17i_Uc", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_Ui()
{
  {
    init_simple_test("aB_BFu17i_Ui");
    static aB_BFu17i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu17i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_Ui");
    check_field_offset(lv, v3, 4, "aB_BFu17i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_Ui(Test_aB_BFu17i_Ui, "aB_BFu17i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_Ul()
{
  {
    init_simple_test("aB_BFu17i_Ul");
    static aB_BFu17i_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aB_BFu17i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_Ul");
    check_field_offset(lv, v3, 4, "aB_BFu17i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_Ul(Test_aB_BFu17i_Ul, "aB_BFu17i_Ul", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_Us()
{
  {
    init_simple_test("aB_BFu17i_Us");
    static aB_BFu17i_Us lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_Us");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_Us");
    check_field_offset(lv, v3, 4, "aB_BFu17i_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_Us(Test_aB_BFu17i_Us, "aB_BFu17i_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17i_Vp()
{
  {
    init_simple_test("aB_BFu17i_Vp");
    static aB_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_BFu17i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17i_Vp");
    check_field_offset(lv, v3, 4, "aB_BFu17i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17i_Vp(Test_aB_BFu17i_Vp, "aB_BFu17i_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll()
{
  {
    init_simple_test("aB_BFu17ll");
    static aB_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll(Test_aB_BFu17ll, "aB_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_B()
{
  {
    init_simple_test("aB_BFu17ll_B");
    static aB_BFu17ll_B lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_B)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_B");
    check_field_offset(lv, v3, 4, "aB_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_B(Test_aB_BFu17ll_B, "aB_BFu17ll_B", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu15i()
{
  {
    init_simple_test("aB_BFu17ll_BFu15i");
    static aB_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aB_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aB_BFu17ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu15i(Test_aB_BFu17ll_BFu15i, "aB_BFu17ll_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu15ll()
{
  {
    init_simple_test("aB_BFu17ll_BFu15ll");
    static aB_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aB_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aB_BFu17ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu15ll(Test_aB_BFu17ll_BFu15ll, "aB_BFu17ll_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu15s()
{
  {
    init_simple_test("aB_BFu17ll_BFu15s");
    static aB_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aB_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aB_BFu17ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu15s(Test_aB_BFu17ll_BFu15s, "aB_BFu17ll_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu16i()
{
  {
    init_simple_test("aB_BFu17ll_BFu16i");
    static aB_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aB_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aB_BFu17ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu16i(Test_aB_BFu17ll_BFu16i, "aB_BFu17ll_BFu16i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu16ll()
{
  {
    init_simple_test("aB_BFu17ll_BFu16ll");
    static aB_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aB_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aB_BFu17ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu16ll(Test_aB_BFu17ll_BFu16ll, "aB_BFu17ll_BFu16ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu16s()
{
  {
    init_simple_test("aB_BFu17ll_BFu16s");
    static aB_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aB_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aB_BFu17ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu16s(Test_aB_BFu17ll_BFu16s, "aB_BFu17ll_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu17i()
{
  {
    init_simple_test("aB_BFu17ll_BFu17i");
    static aB_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aB_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu17i(Test_aB_BFu17ll_BFu17i, "aB_BFu17ll_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu17ll()
{
  {
    init_simple_test("aB_BFu17ll_BFu17ll");
    static aB_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aB_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu17ll(Test_aB_BFu17ll_BFu17ll, "aB_BFu17ll_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu1c()
{
  {
    init_simple_test("aB_BFu17ll_BFu1c");
    static aB_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aB_BFu17ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu1c(Test_aB_BFu17ll_BFu1c, "aB_BFu17ll_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu1i()
{
  {
    init_simple_test("aB_BFu17ll_BFu1i");
    static aB_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aB_BFu17ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu1i(Test_aB_BFu17ll_BFu1i, "aB_BFu17ll_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu1ll()
{
  {
    init_simple_test("aB_BFu17ll_BFu1ll");
    static aB_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aB_BFu17ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu1ll(Test_aB_BFu17ll_BFu1ll, "aB_BFu17ll_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu1s()
{
  {
    init_simple_test("aB_BFu17ll_BFu1s");
    static aB_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aB_BFu17ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu1s(Test_aB_BFu17ll_BFu1s, "aB_BFu17ll_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu31i()
{
  {
    init_simple_test("aB_BFu17ll_BFu31i");
    static aB_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu17ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "aB_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "aB_BFu17ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu31i(Test_aB_BFu17ll_BFu31i, "aB_BFu17ll_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu31ll()
{
  {
    init_simple_test("aB_BFu17ll_BFu31ll");
    static aB_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "aB_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "aB_BFu17ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu31ll(Test_aB_BFu17ll_BFu31ll, "aB_BFu17ll_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu32i()
{
  {
    init_simple_test("aB_BFu17ll_BFu32i");
    static aB_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu17ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "aB_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "aB_BFu17ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu32i(Test_aB_BFu17ll_BFu32i, "aB_BFu17ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu32ll()
{
  {
    init_simple_test("aB_BFu17ll_BFu32ll");
    static aB_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "aB_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "aB_BFu17ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu32ll(Test_aB_BFu17ll_BFu32ll, "aB_BFu17ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu33()
{
  {
    init_simple_test("aB_BFu17ll_BFu33");
    static aB_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu17ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "aB_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "aB_BFu17ll_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu33(Test_aB_BFu17ll_BFu33, "aB_BFu17ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu7c()
{
  {
    init_simple_test("aB_BFu17ll_BFu7c");
    static aB_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aB_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aB_BFu17ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu7c(Test_aB_BFu17ll_BFu7c, "aB_BFu17ll_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu7i()
{
  {
    init_simple_test("aB_BFu17ll_BFu7i");
    static aB_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aB_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aB_BFu17ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu7i(Test_aB_BFu17ll_BFu7i, "aB_BFu17ll_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu7ll()
{
  {
    init_simple_test("aB_BFu17ll_BFu7ll");
    static aB_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aB_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aB_BFu17ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu7ll(Test_aB_BFu17ll_BFu7ll, "aB_BFu17ll_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu7s()
{
  {
    init_simple_test("aB_BFu17ll_BFu7s");
    static aB_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu17ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aB_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aB_BFu17ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu7s(Test_aB_BFu17ll_BFu7s, "aB_BFu17ll_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu8c()
{
  {
    init_simple_test("aB_BFu17ll_BFu8c");
    static aB_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aB_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aB_BFu17ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu8c(Test_aB_BFu17ll_BFu8c, "aB_BFu17ll_BFu8c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu8i()
{
  {
    init_simple_test("aB_BFu17ll_BFu8i");
    static aB_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aB_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aB_BFu17ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu8i(Test_aB_BFu17ll_BFu8i, "aB_BFu17ll_BFu8i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu8ll()
{
  {
    init_simple_test("aB_BFu17ll_BFu8ll");
    static aB_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aB_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aB_BFu17ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu8ll(Test_aB_BFu17ll_BFu8ll, "aB_BFu17ll_BFu8ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu8s()
{
  {
    init_simple_test("aB_BFu17ll_BFu8s");
    static aB_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aB_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aB_BFu17ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu8s(Test_aB_BFu17ll_BFu8s, "aB_BFu17ll_BFu8s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu9i()
{
  {
    init_simple_test("aB_BFu17ll_BFu9i");
    static aB_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aB_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aB_BFu17ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu9i(Test_aB_BFu17ll_BFu9i, "aB_BFu17ll_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu9ll()
{
  {
    init_simple_test("aB_BFu17ll_BFu9ll");
    static aB_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aB_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aB_BFu17ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu9ll(Test_aB_BFu17ll_BFu9ll, "aB_BFu17ll_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_BFu9s()
{
  {
    init_simple_test("aB_BFu17ll_BFu9s");
    static aB_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aB_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aB_BFu17ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_BFu9s(Test_aB_BFu17ll_BFu9s, "aB_BFu17ll_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_C()
{
  {
    init_simple_test("aB_BFu17ll_C");
    static aB_BFu17ll_C lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_C");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_C");
    check_field_offset(lv, v3, 4, "aB_BFu17ll_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_C(Test_aB_BFu17ll_C, "aB_BFu17ll_C", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_D()
{
  {
    init_simple_test("aB_BFu17ll_D");
    static aB_BFu17ll_D lv;
    check2(sizeof(lv), 12, "sizeof(aB_BFu17ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_D");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_D");
    check_field_offset(lv, v3, 4, "aB_BFu17ll_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_D(Test_aB_BFu17ll_D, "aB_BFu17ll_D", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_F()
{
  {
    init_simple_test("aB_BFu17ll_F");
    static aB_BFu17ll_F lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu17ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_F");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_F");
    check_field_offset(lv, v3, 4, "aB_BFu17ll_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_F(Test_aB_BFu17ll_F, "aB_BFu17ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_I()
{
  {
    init_simple_test("aB_BFu17ll_I");
    static aB_BFu17ll_I lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu17ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_I");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_I");
    check_field_offset(lv, v3, 4, "aB_BFu17ll_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_I(Test_aB_BFu17ll_I, "aB_BFu17ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_Ip()
{
  {
    init_simple_test("aB_BFu17ll_Ip");
    static aB_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_BFu17ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_Ip");
    check_field_offset(lv, v3, 4, "aB_BFu17ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_Ip(Test_aB_BFu17ll_Ip, "aB_BFu17ll_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_L()
{
  {
    init_simple_test("aB_BFu17ll_L");
    static aB_BFu17ll_L lv;
    check2(sizeof(lv), 12, "sizeof(aB_BFu17ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_L");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_L");
    check_field_offset(lv, v3, 4, "aB_BFu17ll_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_L(Test_aB_BFu17ll_L, "aB_BFu17ll_L", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_S()
{
  {
    init_simple_test("aB_BFu17ll_S");
    static aB_BFu17ll_S lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_S");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_S");
    check_field_offset(lv, v3, 4, "aB_BFu17ll_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_S(Test_aB_BFu17ll_S, "aB_BFu17ll_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_Uc()
{
  {
    init_simple_test("aB_BFu17ll_Uc");
    static aB_BFu17ll_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu17ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_Uc");
    check_field_offset(lv, v3, 4, "aB_BFu17ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_Uc(Test_aB_BFu17ll_Uc, "aB_BFu17ll_Uc", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_Ui()
{
  {
    init_simple_test("aB_BFu17ll_Ui");
    static aB_BFu17ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu17ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_Ui");
    check_field_offset(lv, v3, 4, "aB_BFu17ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_Ui(Test_aB_BFu17ll_Ui, "aB_BFu17ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_Ul()
{
  {
    init_simple_test("aB_BFu17ll_Ul");
    static aB_BFu17ll_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aB_BFu17ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_Ul");
    check_field_offset(lv, v3, 4, "aB_BFu17ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_Ul(Test_aB_BFu17ll_Ul, "aB_BFu17ll_Ul", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_Us()
{
  {
    init_simple_test("aB_BFu17ll_Us");
    static aB_BFu17ll_Us lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu17ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_Us");
    check_field_offset(lv, v3, 4, "aB_BFu17ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_Us(Test_aB_BFu17ll_Us, "aB_BFu17ll_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu17ll_Vp()
{
  {
    init_simple_test("aB_BFu17ll_Vp");
    static aB_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aB_BFu17ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aB_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aB_BFu17ll_Vp");
    check_field_offset(lv, v3, 4, "aB_BFu17ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu17ll_Vp(Test_aB_BFu17ll_Vp, "aB_BFu17ll_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c()
{
  {
    init_simple_test("aB_BFu1c");
    static aB_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu1c(Test_aB_BFu1c, "aB_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_B()
{
  {
    init_simple_test("aB_BFu1c_B");
    static aB_BFu1c_B lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_B)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_B");
    check_field_offset(lv, v3, 2, "aB_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_B(Test_aB_BFu1c_B, "aB_BFu1c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu15i()
{
  {
    init_simple_test("aB_BFu1c_BFu15i");
    static aB_BFu1c_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aB_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aB_BFu1c_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu15i(Test_aB_BFu1c_BFu15i, "aB_BFu1c_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu15ll()
{
  {
    init_simple_test("aB_BFu1c_BFu15ll");
    static aB_BFu1c_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aB_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aB_BFu1c_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu15ll(Test_aB_BFu1c_BFu15ll, "aB_BFu1c_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu15s()
{
  {
    init_simple_test("aB_BFu1c_BFu15s");
    static aB_BFu1c_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aB_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aB_BFu1c_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu15s(Test_aB_BFu1c_BFu15s, "aB_BFu1c_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu16i()
{
  {
    init_simple_test("aB_BFu1c_BFu16i");
    static aB_BFu1c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aB_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aB_BFu1c_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu16i(Test_aB_BFu1c_BFu16i, "aB_BFu1c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu16ll()
{
  {
    init_simple_test("aB_BFu1c_BFu16ll");
    static aB_BFu1c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aB_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aB_BFu1c_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu16ll(Test_aB_BFu1c_BFu16ll, "aB_BFu1c_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu16s()
{
  {
    init_simple_test("aB_BFu1c_BFu16s");
    static aB_BFu1c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aB_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aB_BFu1c_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu16s(Test_aB_BFu1c_BFu16s, "aB_BFu1c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu17i()
{
  {
    init_simple_test("aB_BFu1c_BFu17i");
    static aB_BFu1c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aB_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aB_BFu1c_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu17i(Test_aB_BFu1c_BFu17i, "aB_BFu1c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu17ll()
{
  {
    init_simple_test("aB_BFu1c_BFu17ll");
    static aB_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aB_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aB_BFu1c_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu17ll(Test_aB_BFu1c_BFu17ll, "aB_BFu1c_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu1c()
{
  {
    init_simple_test("aB_BFu1c_BFu1c");
    static aB_BFu1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1c_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu1c(Test_aB_BFu1c_BFu1c, "aB_BFu1c_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu1i()
{
  {
    init_simple_test("aB_BFu1c_BFu1i");
    static aB_BFu1c_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1c_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu1i(Test_aB_BFu1c_BFu1i, "aB_BFu1c_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu1ll()
{
  {
    init_simple_test("aB_BFu1c_BFu1ll");
    static aB_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1c_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu1ll(Test_aB_BFu1c_BFu1ll, "aB_BFu1c_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu1s()
{
  {
    init_simple_test("aB_BFu1c_BFu1s");
    static aB_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1c_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu1s(Test_aB_BFu1c_BFu1s, "aB_BFu1c_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu31i()
{
  {
    init_simple_test("aB_BFu1c_BFu31i");
    static aB_BFu1c_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu1c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aB_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aB_BFu1c_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu31i(Test_aB_BFu1c_BFu31i, "aB_BFu1c_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu31ll()
{
  {
    init_simple_test("aB_BFu1c_BFu31ll");
    static aB_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu1c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aB_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aB_BFu1c_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu31ll(Test_aB_BFu1c_BFu31ll, "aB_BFu1c_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu32i()
{
  {
    init_simple_test("aB_BFu1c_BFu32i");
    static aB_BFu1c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aB_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aB_BFu1c_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu32i(Test_aB_BFu1c_BFu32i, "aB_BFu1c_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu32ll()
{
  {
    init_simple_test("aB_BFu1c_BFu32ll");
    static aB_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aB_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aB_BFu1c_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu32ll(Test_aB_BFu1c_BFu32ll, "aB_BFu1c_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu33()
{
  {
    init_simple_test("aB_BFu1c_BFu33");
    static aB_BFu1c_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "aB_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "aB_BFu1c_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu33(Test_aB_BFu1c_BFu33, "aB_BFu1c_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu7c()
{
  {
    init_simple_test("aB_BFu1c_BFu7c");
    static aB_BFu1c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1c_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu7c(Test_aB_BFu1c_BFu7c, "aB_BFu1c_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu7i()
{
  {
    init_simple_test("aB_BFu1c_BFu7i");
    static aB_BFu1c_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1c_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu7i(Test_aB_BFu1c_BFu7i, "aB_BFu1c_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu7ll()
{
  {
    init_simple_test("aB_BFu1c_BFu7ll");
    static aB_BFu1c_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1c_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu7ll(Test_aB_BFu1c_BFu7ll, "aB_BFu1c_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu7s()
{
  {
    init_simple_test("aB_BFu1c_BFu7s");
    static aB_BFu1c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1c_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu7s(Test_aB_BFu1c_BFu7s, "aB_BFu1c_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu8c()
{
  {
    init_simple_test("aB_BFu1c_BFu8c");
    static aB_BFu1c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1c_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu8c(Test_aB_BFu1c_BFu8c, "aB_BFu1c_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu8i()
{
  {
    init_simple_test("aB_BFu1c_BFu8i");
    static aB_BFu1c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1c_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu8i(Test_aB_BFu1c_BFu8i, "aB_BFu1c_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu8ll()
{
  {
    init_simple_test("aB_BFu1c_BFu8ll");
    static aB_BFu1c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1c_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu8ll(Test_aB_BFu1c_BFu8ll, "aB_BFu1c_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu8s()
{
  {
    init_simple_test("aB_BFu1c_BFu8s");
    static aB_BFu1c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1c_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu8s(Test_aB_BFu1c_BFu8s, "aB_BFu1c_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu9i()
{
  {
    init_simple_test("aB_BFu1c_BFu9i");
    static aB_BFu1c_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aB_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aB_BFu1c_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu9i(Test_aB_BFu1c_BFu9i, "aB_BFu1c_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu9ll()
{
  {
    init_simple_test("aB_BFu1c_BFu9ll");
    static aB_BFu1c_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aB_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aB_BFu1c_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu9ll(Test_aB_BFu1c_BFu9ll, "aB_BFu1c_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_BFu9s()
{
  {
    init_simple_test("aB_BFu1c_BFu9s");
    static aB_BFu1c_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aB_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aB_BFu1c_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_BFu9s(Test_aB_BFu1c_BFu9s, "aB_BFu1c_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_C()
{
  {
    init_simple_test("aB_BFu1c_C");
    static aB_BFu1c_C lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_C)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_C");
    check_field_offset(lv, v3, 2, "aB_BFu1c_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_C(Test_aB_BFu1c_C, "aB_BFu1c_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_D()
{
  {
    init_simple_test("aB_BFu1c_D");
    static aB_BFu1c_D lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu1c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_D)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_D");
    check_field_offset(lv, v3, 2, "aB_BFu1c_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_D(Test_aB_BFu1c_D, "aB_BFu1c_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_F()
{
  {
    init_simple_test("aB_BFu1c_F");
    static aB_BFu1c_F lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_F)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_F");
    check_field_offset(lv, v3, 2, "aB_BFu1c_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_F(Test_aB_BFu1c_F, "aB_BFu1c_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_I()
{
  {
    init_simple_test("aB_BFu1c_I");
    static aB_BFu1c_I lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_I)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_I");
    check_field_offset(lv, v3, 2, "aB_BFu1c_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_I(Test_aB_BFu1c_I, "aB_BFu1c_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_Ip()
{
  {
    init_simple_test("aB_BFu1c_Ip");
    static aB_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu1c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_Ip");
    check_field_offset(lv, v3, 2, "aB_BFu1c_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_Ip(Test_aB_BFu1c_Ip, "aB_BFu1c_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_L()
{
  {
    init_simple_test("aB_BFu1c_L");
    static aB_BFu1c_L lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu1c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_L)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_L");
    check_field_offset(lv, v3, 2, "aB_BFu1c_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_L(Test_aB_BFu1c_L, "aB_BFu1c_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_S()
{
  {
    init_simple_test("aB_BFu1c_S");
    static aB_BFu1c_S lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_S)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_S");
    check_field_offset(lv, v3, 2, "aB_BFu1c_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_S(Test_aB_BFu1c_S, "aB_BFu1c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_Uc()
{
  {
    init_simple_test("aB_BFu1c_Uc");
    static aB_BFu1c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_Uc");
    check_field_offset(lv, v3, 2, "aB_BFu1c_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_Uc(Test_aB_BFu1c_Uc, "aB_BFu1c_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_Ui()
{
  {
    init_simple_test("aB_BFu1c_Ui");
    static aB_BFu1c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_Ui");
    check_field_offset(lv, v3, 2, "aB_BFu1c_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_Ui(Test_aB_BFu1c_Ui, "aB_BFu1c_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_Ul()
{
  {
    init_simple_test("aB_BFu1c_Ul");
    static aB_BFu1c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu1c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_Ul");
    check_field_offset(lv, v3, 2, "aB_BFu1c_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_Ul(Test_aB_BFu1c_Ul, "aB_BFu1c_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_Us()
{
  {
    init_simple_test("aB_BFu1c_Us");
    static aB_BFu1c_Us lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_Us");
    check_field_offset(lv, v3, 2, "aB_BFu1c_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_Us(Test_aB_BFu1c_Us, "aB_BFu1c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1c_Vp()
{
  {
    init_simple_test("aB_BFu1c_Vp");
    static aB_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu1c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1c_Vp");
    check_field_offset(lv, v3, 2, "aB_BFu1c_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1c_Vp(Test_aB_BFu1c_Vp, "aB_BFu1c_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i()
{
  {
    init_simple_test("aB_BFu1i");
    static aB_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu1i(Test_aB_BFu1i, "aB_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_B()
{
  {
    init_simple_test("aB_BFu1i_B");
    static aB_BFu1i_B lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_B)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_B");
    check_field_offset(lv, v3, 2, "aB_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_B(Test_aB_BFu1i_B, "aB_BFu1i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu15i()
{
  {
    init_simple_test("aB_BFu1i_BFu15i");
    static aB_BFu1i_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aB_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aB_BFu1i_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu15i(Test_aB_BFu1i_BFu15i, "aB_BFu1i_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu15ll()
{
  {
    init_simple_test("aB_BFu1i_BFu15ll");
    static aB_BFu1i_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aB_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aB_BFu1i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu15ll(Test_aB_BFu1i_BFu15ll, "aB_BFu1i_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu15s()
{
  {
    init_simple_test("aB_BFu1i_BFu15s");
    static aB_BFu1i_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aB_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aB_BFu1i_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu15s(Test_aB_BFu1i_BFu15s, "aB_BFu1i_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu16i()
{
  {
    init_simple_test("aB_BFu1i_BFu16i");
    static aB_BFu1i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aB_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aB_BFu1i_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu16i(Test_aB_BFu1i_BFu16i, "aB_BFu1i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu16ll()
{
  {
    init_simple_test("aB_BFu1i_BFu16ll");
    static aB_BFu1i_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aB_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aB_BFu1i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu16ll(Test_aB_BFu1i_BFu16ll, "aB_BFu1i_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu16s()
{
  {
    init_simple_test("aB_BFu1i_BFu16s");
    static aB_BFu1i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aB_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aB_BFu1i_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu16s(Test_aB_BFu1i_BFu16s, "aB_BFu1i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu17i()
{
  {
    init_simple_test("aB_BFu1i_BFu17i");
    static aB_BFu1i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aB_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aB_BFu1i_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu17i(Test_aB_BFu1i_BFu17i, "aB_BFu1i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu17ll()
{
  {
    init_simple_test("aB_BFu1i_BFu17ll");
    static aB_BFu1i_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aB_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aB_BFu1i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu17ll(Test_aB_BFu1i_BFu17ll, "aB_BFu1i_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu1c()
{
  {
    init_simple_test("aB_BFu1i_BFu1c");
    static aB_BFu1i_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1i_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu1c(Test_aB_BFu1i_BFu1c, "aB_BFu1i_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu1i()
{
  {
    init_simple_test("aB_BFu1i_BFu1i");
    static aB_BFu1i_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1i_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu1i(Test_aB_BFu1i_BFu1i, "aB_BFu1i_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu1ll()
{
  {
    init_simple_test("aB_BFu1i_BFu1ll");
    static aB_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu1ll(Test_aB_BFu1i_BFu1ll, "aB_BFu1i_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu1s()
{
  {
    init_simple_test("aB_BFu1i_BFu1s");
    static aB_BFu1i_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1i_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu1s(Test_aB_BFu1i_BFu1s, "aB_BFu1i_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu31i()
{
  {
    init_simple_test("aB_BFu1i_BFu31i");
    static aB_BFu1i_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu1i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aB_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aB_BFu1i_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu31i(Test_aB_BFu1i_BFu31i, "aB_BFu1i_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu31ll()
{
  {
    init_simple_test("aB_BFu1i_BFu31ll");
    static aB_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu1i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aB_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aB_BFu1i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu31ll(Test_aB_BFu1i_BFu31ll, "aB_BFu1i_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu32i()
{
  {
    init_simple_test("aB_BFu1i_BFu32i");
    static aB_BFu1i_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aB_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aB_BFu1i_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu32i(Test_aB_BFu1i_BFu32i, "aB_BFu1i_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu32ll()
{
  {
    init_simple_test("aB_BFu1i_BFu32ll");
    static aB_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aB_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aB_BFu1i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu32ll(Test_aB_BFu1i_BFu32ll, "aB_BFu1i_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu33()
{
  {
    init_simple_test("aB_BFu1i_BFu33");
    static aB_BFu1i_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "aB_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "aB_BFu1i_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu33(Test_aB_BFu1i_BFu33, "aB_BFu1i_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu7c()
{
  {
    init_simple_test("aB_BFu1i_BFu7c");
    static aB_BFu1i_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1i_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu7c(Test_aB_BFu1i_BFu7c, "aB_BFu1i_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu7i()
{
  {
    init_simple_test("aB_BFu1i_BFu7i");
    static aB_BFu1i_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1i_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu7i(Test_aB_BFu1i_BFu7i, "aB_BFu1i_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu7ll()
{
  {
    init_simple_test("aB_BFu1i_BFu7ll");
    static aB_BFu1i_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu7ll(Test_aB_BFu1i_BFu7ll, "aB_BFu1i_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu7s()
{
  {
    init_simple_test("aB_BFu1i_BFu7s");
    static aB_BFu1i_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1i_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu7s(Test_aB_BFu1i_BFu7s, "aB_BFu1i_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu8c()
{
  {
    init_simple_test("aB_BFu1i_BFu8c");
    static aB_BFu1i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1i_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu8c(Test_aB_BFu1i_BFu8c, "aB_BFu1i_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu8i()
{
  {
    init_simple_test("aB_BFu1i_BFu8i");
    static aB_BFu1i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1i_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu8i(Test_aB_BFu1i_BFu8i, "aB_BFu1i_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu8ll()
{
  {
    init_simple_test("aB_BFu1i_BFu8ll");
    static aB_BFu1i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu8ll(Test_aB_BFu1i_BFu8ll, "aB_BFu1i_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu8s()
{
  {
    init_simple_test("aB_BFu1i_BFu8s");
    static aB_BFu1i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1i_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu8s(Test_aB_BFu1i_BFu8s, "aB_BFu1i_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu9i()
{
  {
    init_simple_test("aB_BFu1i_BFu9i");
    static aB_BFu1i_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aB_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aB_BFu1i_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu9i(Test_aB_BFu1i_BFu9i, "aB_BFu1i_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu9ll()
{
  {
    init_simple_test("aB_BFu1i_BFu9ll");
    static aB_BFu1i_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aB_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aB_BFu1i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu9ll(Test_aB_BFu1i_BFu9ll, "aB_BFu1i_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_BFu9s()
{
  {
    init_simple_test("aB_BFu1i_BFu9s");
    static aB_BFu1i_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aB_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aB_BFu1i_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_BFu9s(Test_aB_BFu1i_BFu9s, "aB_BFu1i_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_C()
{
  {
    init_simple_test("aB_BFu1i_C");
    static aB_BFu1i_C lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_C)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_C");
    check_field_offset(lv, v3, 2, "aB_BFu1i_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_C(Test_aB_BFu1i_C, "aB_BFu1i_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_D()
{
  {
    init_simple_test("aB_BFu1i_D");
    static aB_BFu1i_D lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu1i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_D)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_D");
    check_field_offset(lv, v3, 2, "aB_BFu1i_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_D(Test_aB_BFu1i_D, "aB_BFu1i_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_F()
{
  {
    init_simple_test("aB_BFu1i_F");
    static aB_BFu1i_F lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_F)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_F");
    check_field_offset(lv, v3, 2, "aB_BFu1i_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_F(Test_aB_BFu1i_F, "aB_BFu1i_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_I()
{
  {
    init_simple_test("aB_BFu1i_I");
    static aB_BFu1i_I lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_I)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_I");
    check_field_offset(lv, v3, 2, "aB_BFu1i_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_I(Test_aB_BFu1i_I, "aB_BFu1i_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_Ip()
{
  {
    init_simple_test("aB_BFu1i_Ip");
    static aB_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu1i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_Ip");
    check_field_offset(lv, v3, 2, "aB_BFu1i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_Ip(Test_aB_BFu1i_Ip, "aB_BFu1i_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_L()
{
  {
    init_simple_test("aB_BFu1i_L");
    static aB_BFu1i_L lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu1i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_L)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_L");
    check_field_offset(lv, v3, 2, "aB_BFu1i_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_L(Test_aB_BFu1i_L, "aB_BFu1i_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_S()
{
  {
    init_simple_test("aB_BFu1i_S");
    static aB_BFu1i_S lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_S)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_S");
    check_field_offset(lv, v3, 2, "aB_BFu1i_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_S(Test_aB_BFu1i_S, "aB_BFu1i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_Uc()
{
  {
    init_simple_test("aB_BFu1i_Uc");
    static aB_BFu1i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_Uc");
    check_field_offset(lv, v3, 2, "aB_BFu1i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_Uc(Test_aB_BFu1i_Uc, "aB_BFu1i_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_Ui()
{
  {
    init_simple_test("aB_BFu1i_Ui");
    static aB_BFu1i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_Ui");
    check_field_offset(lv, v3, 2, "aB_BFu1i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_Ui(Test_aB_BFu1i_Ui, "aB_BFu1i_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_Ul()
{
  {
    init_simple_test("aB_BFu1i_Ul");
    static aB_BFu1i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu1i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_Ul");
    check_field_offset(lv, v3, 2, "aB_BFu1i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_Ul(Test_aB_BFu1i_Ul, "aB_BFu1i_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_Us()
{
  {
    init_simple_test("aB_BFu1i_Us");
    static aB_BFu1i_Us lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_Us");
    check_field_offset(lv, v3, 2, "aB_BFu1i_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_Us(Test_aB_BFu1i_Us, "aB_BFu1i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1i_Vp()
{
  {
    init_simple_test("aB_BFu1i_Vp");
    static aB_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu1i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1i_Vp");
    check_field_offset(lv, v3, 2, "aB_BFu1i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1i_Vp(Test_aB_BFu1i_Vp, "aB_BFu1i_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll()
{
  {
    init_simple_test("aB_BFu1ll");
    static aB_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll(Test_aB_BFu1ll, "aB_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_B()
{
  {
    init_simple_test("aB_BFu1ll_B");
    static aB_BFu1ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_B)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_B");
    check_field_offset(lv, v3, 2, "aB_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_B(Test_aB_BFu1ll_B, "aB_BFu1ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu15i()
{
  {
    init_simple_test("aB_BFu1ll_BFu15i");
    static aB_BFu1ll_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aB_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aB_BFu1ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu15i(Test_aB_BFu1ll_BFu15i, "aB_BFu1ll_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu15ll()
{
  {
    init_simple_test("aB_BFu1ll_BFu15ll");
    static aB_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aB_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aB_BFu1ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu15ll(Test_aB_BFu1ll_BFu15ll, "aB_BFu1ll_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu15s()
{
  {
    init_simple_test("aB_BFu1ll_BFu15s");
    static aB_BFu1ll_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aB_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aB_BFu1ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu15s(Test_aB_BFu1ll_BFu15s, "aB_BFu1ll_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu16i()
{
  {
    init_simple_test("aB_BFu1ll_BFu16i");
    static aB_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aB_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aB_BFu1ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu16i(Test_aB_BFu1ll_BFu16i, "aB_BFu1ll_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu16ll()
{
  {
    init_simple_test("aB_BFu1ll_BFu16ll");
    static aB_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aB_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aB_BFu1ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu16ll(Test_aB_BFu1ll_BFu16ll, "aB_BFu1ll_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu16s()
{
  {
    init_simple_test("aB_BFu1ll_BFu16s");
    static aB_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aB_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aB_BFu1ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu16s(Test_aB_BFu1ll_BFu16s, "aB_BFu1ll_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu17i()
{
  {
    init_simple_test("aB_BFu1ll_BFu17i");
    static aB_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aB_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aB_BFu1ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu17i(Test_aB_BFu1ll_BFu17i, "aB_BFu1ll_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu17ll()
{
  {
    init_simple_test("aB_BFu1ll_BFu17ll");
    static aB_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aB_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aB_BFu1ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu17ll(Test_aB_BFu1ll_BFu17ll, "aB_BFu1ll_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu1c()
{
  {
    init_simple_test("aB_BFu1ll_BFu1c");
    static aB_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu1c(Test_aB_BFu1ll_BFu1c, "aB_BFu1ll_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu1i()
{
  {
    init_simple_test("aB_BFu1ll_BFu1i");
    static aB_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu1i(Test_aB_BFu1ll_BFu1i, "aB_BFu1ll_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu1ll()
{
  {
    init_simple_test("aB_BFu1ll_BFu1ll");
    static aB_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu1ll(Test_aB_BFu1ll_BFu1ll, "aB_BFu1ll_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu1s()
{
  {
    init_simple_test("aB_BFu1ll_BFu1s");
    static aB_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu1s(Test_aB_BFu1ll_BFu1s, "aB_BFu1ll_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu31i()
{
  {
    init_simple_test("aB_BFu1ll_BFu31i");
    static aB_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu1ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aB_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aB_BFu1ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu31i(Test_aB_BFu1ll_BFu31i, "aB_BFu1ll_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu31ll()
{
  {
    init_simple_test("aB_BFu1ll_BFu31ll");
    static aB_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aB_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aB_BFu1ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu31ll(Test_aB_BFu1ll_BFu31ll, "aB_BFu1ll_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu32i()
{
  {
    init_simple_test("aB_BFu1ll_BFu32i");
    static aB_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aB_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aB_BFu1ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu32i(Test_aB_BFu1ll_BFu32i, "aB_BFu1ll_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu32ll()
{
  {
    init_simple_test("aB_BFu1ll_BFu32ll");
    static aB_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aB_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aB_BFu1ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu32ll(Test_aB_BFu1ll_BFu32ll, "aB_BFu1ll_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu33()
{
  {
    init_simple_test("aB_BFu1ll_BFu33");
    static aB_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "aB_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "aB_BFu1ll_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu33(Test_aB_BFu1ll_BFu33, "aB_BFu1ll_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu7c()
{
  {
    init_simple_test("aB_BFu1ll_BFu7c");
    static aB_BFu1ll_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu7c(Test_aB_BFu1ll_BFu7c, "aB_BFu1ll_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu7i()
{
  {
    init_simple_test("aB_BFu1ll_BFu7i");
    static aB_BFu1ll_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu7i(Test_aB_BFu1ll_BFu7i, "aB_BFu1ll_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu7ll()
{
  {
    init_simple_test("aB_BFu1ll_BFu7ll");
    static aB_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu7ll(Test_aB_BFu1ll_BFu7ll, "aB_BFu1ll_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu7s()
{
  {
    init_simple_test("aB_BFu1ll_BFu7s");
    static aB_BFu1ll_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu7s(Test_aB_BFu1ll_BFu7s, "aB_BFu1ll_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu8c()
{
  {
    init_simple_test("aB_BFu1ll_BFu8c");
    static aB_BFu1ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu8c(Test_aB_BFu1ll_BFu8c, "aB_BFu1ll_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu8i()
{
  {
    init_simple_test("aB_BFu1ll_BFu8i");
    static aB_BFu1ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu8i(Test_aB_BFu1ll_BFu8i, "aB_BFu1ll_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu8ll()
{
  {
    init_simple_test("aB_BFu1ll_BFu8ll");
    static aB_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu8ll(Test_aB_BFu1ll_BFu8ll, "aB_BFu1ll_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu8s()
{
  {
    init_simple_test("aB_BFu1ll_BFu8s");
    static aB_BFu1ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu8s(Test_aB_BFu1ll_BFu8s, "aB_BFu1ll_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu9i()
{
  {
    init_simple_test("aB_BFu1ll_BFu9i");
    static aB_BFu1ll_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aB_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aB_BFu1ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu9i(Test_aB_BFu1ll_BFu9i, "aB_BFu1ll_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu9ll()
{
  {
    init_simple_test("aB_BFu1ll_BFu9ll");
    static aB_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aB_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aB_BFu1ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu9ll(Test_aB_BFu1ll_BFu9ll, "aB_BFu1ll_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_BFu9s()
{
  {
    init_simple_test("aB_BFu1ll_BFu9s");
    static aB_BFu1ll_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aB_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aB_BFu1ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_BFu9s(Test_aB_BFu1ll_BFu9s, "aB_BFu1ll_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_C()
{
  {
    init_simple_test("aB_BFu1ll_C");
    static aB_BFu1ll_C lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_C");
    check_field_offset(lv, v3, 2, "aB_BFu1ll_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_C(Test_aB_BFu1ll_C, "aB_BFu1ll_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_D()
{
  {
    init_simple_test("aB_BFu1ll_D");
    static aB_BFu1ll_D lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu1ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_D");
    check_field_offset(lv, v3, 2, "aB_BFu1ll_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_D(Test_aB_BFu1ll_D, "aB_BFu1ll_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_F()
{
  {
    init_simple_test("aB_BFu1ll_F");
    static aB_BFu1ll_F lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_F");
    check_field_offset(lv, v3, 2, "aB_BFu1ll_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_F(Test_aB_BFu1ll_F, "aB_BFu1ll_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_I()
{
  {
    init_simple_test("aB_BFu1ll_I");
    static aB_BFu1ll_I lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_I");
    check_field_offset(lv, v3, 2, "aB_BFu1ll_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_I(Test_aB_BFu1ll_I, "aB_BFu1ll_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_Ip()
{
  {
    init_simple_test("aB_BFu1ll_Ip");
    static aB_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu1ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_Ip");
    check_field_offset(lv, v3, 2, "aB_BFu1ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_Ip(Test_aB_BFu1ll_Ip, "aB_BFu1ll_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_L()
{
  {
    init_simple_test("aB_BFu1ll_L");
    static aB_BFu1ll_L lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu1ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_L");
    check_field_offset(lv, v3, 2, "aB_BFu1ll_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_L(Test_aB_BFu1ll_L, "aB_BFu1ll_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_S()
{
  {
    init_simple_test("aB_BFu1ll_S");
    static aB_BFu1ll_S lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_S");
    check_field_offset(lv, v3, 2, "aB_BFu1ll_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_S(Test_aB_BFu1ll_S, "aB_BFu1ll_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_Uc()
{
  {
    init_simple_test("aB_BFu1ll_Uc");
    static aB_BFu1ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_Uc");
    check_field_offset(lv, v3, 2, "aB_BFu1ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_Uc(Test_aB_BFu1ll_Uc, "aB_BFu1ll_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_Ui()
{
  {
    init_simple_test("aB_BFu1ll_Ui");
    static aB_BFu1ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_Ui");
    check_field_offset(lv, v3, 2, "aB_BFu1ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_Ui(Test_aB_BFu1ll_Ui, "aB_BFu1ll_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_Ul()
{
  {
    init_simple_test("aB_BFu1ll_Ul");
    static aB_BFu1ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu1ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_Ul");
    check_field_offset(lv, v3, 2, "aB_BFu1ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_Ul(Test_aB_BFu1ll_Ul, "aB_BFu1ll_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_Us()
{
  {
    init_simple_test("aB_BFu1ll_Us");
    static aB_BFu1ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_Us");
    check_field_offset(lv, v3, 2, "aB_BFu1ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_Us(Test_aB_BFu1ll_Us, "aB_BFu1ll_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1ll_Vp()
{
  {
    init_simple_test("aB_BFu1ll_Vp");
    static aB_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu1ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1ll_Vp");
    check_field_offset(lv, v3, 2, "aB_BFu1ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1ll_Vp(Test_aB_BFu1ll_Vp, "aB_BFu1ll_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s()
{
  {
    init_simple_test("aB_BFu1s");
    static aB_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu1s(Test_aB_BFu1s, "aB_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_B()
{
  {
    init_simple_test("aB_BFu1s_B");
    static aB_BFu1s_B lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_B)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_B");
    check_field_offset(lv, v3, 2, "aB_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_B(Test_aB_BFu1s_B, "aB_BFu1s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu15i()
{
  {
    init_simple_test("aB_BFu1s_BFu15i");
    static aB_BFu1s_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aB_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aB_BFu1s_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu15i(Test_aB_BFu1s_BFu15i, "aB_BFu1s_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu15ll()
{
  {
    init_simple_test("aB_BFu1s_BFu15ll");
    static aB_BFu1s_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aB_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aB_BFu1s_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu15ll(Test_aB_BFu1s_BFu15ll, "aB_BFu1s_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu15s()
{
  {
    init_simple_test("aB_BFu1s_BFu15s");
    static aB_BFu1s_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aB_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aB_BFu1s_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu15s(Test_aB_BFu1s_BFu15s, "aB_BFu1s_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu16i()
{
  {
    init_simple_test("aB_BFu1s_BFu16i");
    static aB_BFu1s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aB_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aB_BFu1s_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu16i(Test_aB_BFu1s_BFu16i, "aB_BFu1s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu16ll()
{
  {
    init_simple_test("aB_BFu1s_BFu16ll");
    static aB_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aB_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aB_BFu1s_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu16ll(Test_aB_BFu1s_BFu16ll, "aB_BFu1s_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu16s()
{
  {
    init_simple_test("aB_BFu1s_BFu16s");
    static aB_BFu1s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aB_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aB_BFu1s_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu16s(Test_aB_BFu1s_BFu16s, "aB_BFu1s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu17i()
{
  {
    init_simple_test("aB_BFu1s_BFu17i");
    static aB_BFu1s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aB_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aB_BFu1s_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu17i(Test_aB_BFu1s_BFu17i, "aB_BFu1s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu17ll()
{
  {
    init_simple_test("aB_BFu1s_BFu17ll");
    static aB_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aB_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aB_BFu1s_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu17ll(Test_aB_BFu1s_BFu17ll, "aB_BFu1s_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu1c()
{
  {
    init_simple_test("aB_BFu1s_BFu1c");
    static aB_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1s_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu1c(Test_aB_BFu1s_BFu1c, "aB_BFu1s_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu1i()
{
  {
    init_simple_test("aB_BFu1s_BFu1i");
    static aB_BFu1s_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1s_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu1i(Test_aB_BFu1s_BFu1i, "aB_BFu1s_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu1ll()
{
  {
    init_simple_test("aB_BFu1s_BFu1ll");
    static aB_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1s_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu1ll(Test_aB_BFu1s_BFu1ll, "aB_BFu1s_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu1s()
{
  {
    init_simple_test("aB_BFu1s_BFu1s");
    static aB_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aB_BFu1s_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu1s(Test_aB_BFu1s_BFu1s, "aB_BFu1s_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu31i()
{
  {
    init_simple_test("aB_BFu1s_BFu31i");
    static aB_BFu1s_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu1s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aB_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aB_BFu1s_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu31i(Test_aB_BFu1s_BFu31i, "aB_BFu1s_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu31ll()
{
  {
    init_simple_test("aB_BFu1s_BFu31ll");
    static aB_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu1s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aB_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aB_BFu1s_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu31ll(Test_aB_BFu1s_BFu31ll, "aB_BFu1s_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu32i()
{
  {
    init_simple_test("aB_BFu1s_BFu32i");
    static aB_BFu1s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aB_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aB_BFu1s_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu32i(Test_aB_BFu1s_BFu32i, "aB_BFu1s_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu32ll()
{
  {
    init_simple_test("aB_BFu1s_BFu32ll");
    static aB_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aB_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aB_BFu1s_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu32ll(Test_aB_BFu1s_BFu32ll, "aB_BFu1s_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu33()
{
  {
    init_simple_test("aB_BFu1s_BFu33");
    static aB_BFu1s_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "aB_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "aB_BFu1s_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu33(Test_aB_BFu1s_BFu33, "aB_BFu1s_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu7c()
{
  {
    init_simple_test("aB_BFu1s_BFu7c");
    static aB_BFu1s_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1s_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu7c(Test_aB_BFu1s_BFu7c, "aB_BFu1s_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu7i()
{
  {
    init_simple_test("aB_BFu1s_BFu7i");
    static aB_BFu1s_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1s_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu7i(Test_aB_BFu1s_BFu7i, "aB_BFu1s_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu7ll()
{
  {
    init_simple_test("aB_BFu1s_BFu7ll");
    static aB_BFu1s_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1s_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu7ll(Test_aB_BFu1s_BFu7ll, "aB_BFu1s_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu7s()
{
  {
    init_simple_test("aB_BFu1s_BFu7s");
    static aB_BFu1s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu1s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aB_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aB_BFu1s_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu7s(Test_aB_BFu1s_BFu7s, "aB_BFu1s_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu8c()
{
  {
    init_simple_test("aB_BFu1s_BFu8c");
    static aB_BFu1s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1s_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu8c(Test_aB_BFu1s_BFu8c, "aB_BFu1s_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu8i()
{
  {
    init_simple_test("aB_BFu1s_BFu8i");
    static aB_BFu1s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1s_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu8i(Test_aB_BFu1s_BFu8i, "aB_BFu1s_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu8ll()
{
  {
    init_simple_test("aB_BFu1s_BFu8ll");
    static aB_BFu1s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1s_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu8ll(Test_aB_BFu1s_BFu8ll, "aB_BFu1s_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu8s()
{
  {
    init_simple_test("aB_BFu1s_BFu8s");
    static aB_BFu1s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aB_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aB_BFu1s_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu8s(Test_aB_BFu1s_BFu8s, "aB_BFu1s_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu9i()
{
  {
    init_simple_test("aB_BFu1s_BFu9i");
    static aB_BFu1s_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aB_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aB_BFu1s_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu9i(Test_aB_BFu1s_BFu9i, "aB_BFu1s_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu9ll()
{
  {
    init_simple_test("aB_BFu1s_BFu9ll");
    static aB_BFu1s_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aB_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aB_BFu1s_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu9ll(Test_aB_BFu1s_BFu9ll, "aB_BFu1s_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_BFu9s()
{
  {
    init_simple_test("aB_BFu1s_BFu9s");
    static aB_BFu1s_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aB_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aB_BFu1s_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_BFu9s(Test_aB_BFu1s_BFu9s, "aB_BFu1s_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_C()
{
  {
    init_simple_test("aB_BFu1s_C");
    static aB_BFu1s_C lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_C)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_C");
    check_field_offset(lv, v3, 2, "aB_BFu1s_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_C(Test_aB_BFu1s_C, "aB_BFu1s_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_D()
{
  {
    init_simple_test("aB_BFu1s_D");
    static aB_BFu1s_D lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu1s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_D)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_D");
    check_field_offset(lv, v3, 2, "aB_BFu1s_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_D(Test_aB_BFu1s_D, "aB_BFu1s_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_F()
{
  {
    init_simple_test("aB_BFu1s_F");
    static aB_BFu1s_F lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_F)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_F");
    check_field_offset(lv, v3, 2, "aB_BFu1s_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_F(Test_aB_BFu1s_F, "aB_BFu1s_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_I()
{
  {
    init_simple_test("aB_BFu1s_I");
    static aB_BFu1s_I lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_I)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_I");
    check_field_offset(lv, v3, 2, "aB_BFu1s_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_I(Test_aB_BFu1s_I, "aB_BFu1s_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_Ip()
{
  {
    init_simple_test("aB_BFu1s_Ip");
    static aB_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu1s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_Ip");
    check_field_offset(lv, v3, 2, "aB_BFu1s_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_Ip(Test_aB_BFu1s_Ip, "aB_BFu1s_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_L()
{
  {
    init_simple_test("aB_BFu1s_L");
    static aB_BFu1s_L lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu1s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_L)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_L");
    check_field_offset(lv, v3, 2, "aB_BFu1s_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_L(Test_aB_BFu1s_L, "aB_BFu1s_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_S()
{
  {
    init_simple_test("aB_BFu1s_S");
    static aB_BFu1s_S lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_S)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_S");
    check_field_offset(lv, v3, 2, "aB_BFu1s_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_S(Test_aB_BFu1s_S, "aB_BFu1s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_Uc()
{
  {
    init_simple_test("aB_BFu1s_Uc");
    static aB_BFu1s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu1s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_Uc");
    check_field_offset(lv, v3, 2, "aB_BFu1s_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_Uc(Test_aB_BFu1s_Uc, "aB_BFu1s_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_Ui()
{
  {
    init_simple_test("aB_BFu1s_Ui");
    static aB_BFu1s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu1s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_Ui");
    check_field_offset(lv, v3, 2, "aB_BFu1s_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_Ui(Test_aB_BFu1s_Ui, "aB_BFu1s_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_Ul()
{
  {
    init_simple_test("aB_BFu1s_Ul");
    static aB_BFu1s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu1s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_Ul");
    check_field_offset(lv, v3, 2, "aB_BFu1s_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_Ul(Test_aB_BFu1s_Ul, "aB_BFu1s_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_Us()
{
  {
    init_simple_test("aB_BFu1s_Us");
    static aB_BFu1s_Us lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu1s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_Us");
    check_field_offset(lv, v3, 2, "aB_BFu1s_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_Us(Test_aB_BFu1s_Us, "aB_BFu1s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu1s_Vp()
{
  {
    init_simple_test("aB_BFu1s_Vp");
    static aB_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu1s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aB_BFu1s_Vp");
    check_field_offset(lv, v3, 2, "aB_BFu1s_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu1s_Vp(Test_aB_BFu1s_Vp, "aB_BFu1s_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i()
{
  {
    init_simple_test("aB_BFu31i");
    static aB_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu31i(Test_aB_BFu31i, "aB_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_B()
{
  {
    init_simple_test("aB_BFu31i_B");
    static aB_BFu31i_B lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_B)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_B");
    check_field_offset(lv, v3, 5, "aB_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_B(Test_aB_BFu31i_B, "aB_BFu31i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu15i()
{
  {
    init_simple_test("aB_BFu31i_BFu15i");
    static aB_BFu31i_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aB_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aB_BFu31i_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu15i(Test_aB_BFu31i_BFu15i, "aB_BFu31i_BFu15i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu15ll()
{
  {
    init_simple_test("aB_BFu31i_BFu15ll");
    static aB_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aB_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aB_BFu31i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu15ll(Test_aB_BFu31i_BFu15ll, "aB_BFu31i_BFu15ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu15s()
{
  {
    init_simple_test("aB_BFu31i_BFu15s");
    static aB_BFu31i_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aB_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aB_BFu31i_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu15s(Test_aB_BFu31i_BFu15s, "aB_BFu31i_BFu15s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu16i()
{
  {
    init_simple_test("aB_BFu31i_BFu16i");
    static aB_BFu31i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aB_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aB_BFu31i_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu16i(Test_aB_BFu31i_BFu16i, "aB_BFu31i_BFu16i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu16ll()
{
  {
    init_simple_test("aB_BFu31i_BFu16ll");
    static aB_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aB_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aB_BFu31i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu16ll(Test_aB_BFu31i_BFu16ll, "aB_BFu31i_BFu16ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu16s()
{
  {
    init_simple_test("aB_BFu31i_BFu16s");
    static aB_BFu31i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aB_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aB_BFu31i_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu16s(Test_aB_BFu31i_BFu16s, "aB_BFu31i_BFu16s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu17i()
{
  {
    init_simple_test("aB_BFu31i_BFu17i");
    static aB_BFu31i_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aB_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aB_BFu31i_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu17i(Test_aB_BFu31i_BFu17i, "aB_BFu31i_BFu17i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu17ll()
{
  {
    init_simple_test("aB_BFu31i_BFu17ll");
    static aB_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aB_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aB_BFu31i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu17ll(Test_aB_BFu31i_BFu17ll, "aB_BFu31i_BFu17ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu1c()
{
  {
    init_simple_test("aB_BFu31i_BFu1c");
    static aB_BFu31i_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu31i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aB_BFu31i_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu1c(Test_aB_BFu31i_BFu1c, "aB_BFu31i_BFu1c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu1i()
{
  {
    init_simple_test("aB_BFu31i_BFu1i");
    static aB_BFu31i_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu31i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aB_BFu31i_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu1i(Test_aB_BFu31i_BFu1i, "aB_BFu31i_BFu1i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu1ll()
{
  {
    init_simple_test("aB_BFu31i_BFu1ll");
    static aB_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu31i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aB_BFu31i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu1ll(Test_aB_BFu31i_BFu1ll, "aB_BFu31i_BFu1ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu1s()
{
  {
    init_simple_test("aB_BFu31i_BFu1s");
    static aB_BFu31i_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu31i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aB_BFu31i_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu1s(Test_aB_BFu31i_BFu1s, "aB_BFu31i_BFu1s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu31i()
{
  {
    init_simple_test("aB_BFu31i_BFu31i");
    static aB_BFu31i_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aB_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu31i(Test_aB_BFu31i_BFu31i, "aB_BFu31i_BFu31i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu31ll()
{
  {
    init_simple_test("aB_BFu31i_BFu31ll");
    static aB_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aB_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu31ll(Test_aB_BFu31i_BFu31ll, "aB_BFu31i_BFu31ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu32i()
{
  {
    init_simple_test("aB_BFu31i_BFu32i");
    static aB_BFu31i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aB_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aB_BFu31i_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu32i(Test_aB_BFu31i_BFu32i, "aB_BFu31i_BFu32i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu32ll()
{
  {
    init_simple_test("aB_BFu31i_BFu32ll");
    static aB_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aB_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aB_BFu31i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu32ll(Test_aB_BFu31i_BFu32ll, "aB_BFu31i_BFu32ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu33()
{
  {
    init_simple_test("aB_BFu31i_BFu33");
    static aB_BFu31i_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, 1, "aB_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, hide_ull(1LL<<32), "aB_BFu31i_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu33(Test_aB_BFu31i_BFu33, "aB_BFu31i_BFu33", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu7c()
{
  {
    init_simple_test("aB_BFu31i_BFu7c");
    static aB_BFu31i_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aB_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aB_BFu31i_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu7c(Test_aB_BFu31i_BFu7c, "aB_BFu31i_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu7i()
{
  {
    init_simple_test("aB_BFu31i_BFu7i");
    static aB_BFu31i_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aB_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aB_BFu31i_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu7i(Test_aB_BFu31i_BFu7i, "aB_BFu31i_BFu7i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu7ll()
{
  {
    init_simple_test("aB_BFu31i_BFu7ll");
    static aB_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aB_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aB_BFu31i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu7ll(Test_aB_BFu31i_BFu7ll, "aB_BFu31i_BFu7ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu7s()
{
  {
    init_simple_test("aB_BFu31i_BFu7s");
    static aB_BFu31i_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aB_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aB_BFu31i_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu7s(Test_aB_BFu31i_BFu7s, "aB_BFu31i_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu8c()
{
  {
    init_simple_test("aB_BFu31i_BFu8c");
    static aB_BFu31i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aB_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aB_BFu31i_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu8c(Test_aB_BFu31i_BFu8c, "aB_BFu31i_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu8i()
{
  {
    init_simple_test("aB_BFu31i_BFu8i");
    static aB_BFu31i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aB_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aB_BFu31i_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu8i(Test_aB_BFu31i_BFu8i, "aB_BFu31i_BFu8i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu8ll()
{
  {
    init_simple_test("aB_BFu31i_BFu8ll");
    static aB_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aB_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aB_BFu31i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu8ll(Test_aB_BFu31i_BFu8ll, "aB_BFu31i_BFu8ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu8s()
{
  {
    init_simple_test("aB_BFu31i_BFu8s");
    static aB_BFu31i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aB_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aB_BFu31i_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu8s(Test_aB_BFu31i_BFu8s, "aB_BFu31i_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu9i()
{
  {
    init_simple_test("aB_BFu31i_BFu9i");
    static aB_BFu31i_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aB_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aB_BFu31i_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu9i(Test_aB_BFu31i_BFu9i, "aB_BFu31i_BFu9i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu9ll()
{
  {
    init_simple_test("aB_BFu31i_BFu9ll");
    static aB_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aB_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aB_BFu31i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu9ll(Test_aB_BFu31i_BFu9ll, "aB_BFu31i_BFu9ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_BFu9s()
{
  {
    init_simple_test("aB_BFu31i_BFu9s");
    static aB_BFu31i_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aB_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aB_BFu31i_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_BFu9s(Test_aB_BFu31i_BFu9s, "aB_BFu31i_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_C()
{
  {
    init_simple_test("aB_BFu31i_C");
    static aB_BFu31i_C lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_C)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_C");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_C");
    check_field_offset(lv, v3, 5, "aB_BFu31i_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_C(Test_aB_BFu31i_C, "aB_BFu31i_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_D()
{
  {
    init_simple_test("aB_BFu31i_D");
    static aB_BFu31i_D lv;
    check2(sizeof(lv), 13, "sizeof(aB_BFu31i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_D)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_D");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_D");
    check_field_offset(lv, v3, 5, "aB_BFu31i_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_D(Test_aB_BFu31i_D, "aB_BFu31i_D", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_F()
{
  {
    init_simple_test("aB_BFu31i_F");
    static aB_BFu31i_F lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_F)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_F");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_F");
    check_field_offset(lv, v3, 5, "aB_BFu31i_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_F(Test_aB_BFu31i_F, "aB_BFu31i_F", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_I()
{
  {
    init_simple_test("aB_BFu31i_I");
    static aB_BFu31i_I lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_I)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_I");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_I");
    check_field_offset(lv, v3, 5, "aB_BFu31i_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_I(Test_aB_BFu31i_I, "aB_BFu31i_I", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_Ip()
{
  {
    init_simple_test("aB_BFu31i_Ip");
    static aB_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aB_BFu31i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_Ip");
    check_field_offset(lv, v3, 5, "aB_BFu31i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_Ip(Test_aB_BFu31i_Ip, "aB_BFu31i_Ip", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_L()
{
  {
    init_simple_test("aB_BFu31i_L");
    static aB_BFu31i_L lv;
    check2(sizeof(lv), 13, "sizeof(aB_BFu31i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_L)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_L");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_L");
    check_field_offset(lv, v3, 5, "aB_BFu31i_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_L(Test_aB_BFu31i_L, "aB_BFu31i_L", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_S()
{
  {
    init_simple_test("aB_BFu31i_S");
    static aB_BFu31i_S lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_S)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_S");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_S");
    check_field_offset(lv, v3, 5, "aB_BFu31i_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_S(Test_aB_BFu31i_S, "aB_BFu31i_S", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_Uc()
{
  {
    init_simple_test("aB_BFu31i_Uc");
    static aB_BFu31i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_Uc");
    check_field_offset(lv, v3, 5, "aB_BFu31i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_Uc(Test_aB_BFu31i_Uc, "aB_BFu31i_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_Ui()
{
  {
    init_simple_test("aB_BFu31i_Ui");
    static aB_BFu31i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_Ui");
    check_field_offset(lv, v3, 5, "aB_BFu31i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_Ui(Test_aB_BFu31i_Ui, "aB_BFu31i_Ui", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_Ul()
{
  {
    init_simple_test("aB_BFu31i_Ul");
    static aB_BFu31i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aB_BFu31i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_Ul");
    check_field_offset(lv, v3, 5, "aB_BFu31i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_Ul(Test_aB_BFu31i_Ul, "aB_BFu31i_Ul", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_Us()
{
  {
    init_simple_test("aB_BFu31i_Us");
    static aB_BFu31i_Us lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_Us");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_Us");
    check_field_offset(lv, v3, 5, "aB_BFu31i_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_Us(Test_aB_BFu31i_Us, "aB_BFu31i_Us", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31i_Vp()
{
  {
    init_simple_test("aB_BFu31i_Vp");
    static aB_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aB_BFu31i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31i_Vp");
    check_field_offset(lv, v3, 5, "aB_BFu31i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31i_Vp(Test_aB_BFu31i_Vp, "aB_BFu31i_Vp", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll()
{
  {
    init_simple_test("aB_BFu31ll");
    static aB_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll(Test_aB_BFu31ll, "aB_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_B()
{
  {
    init_simple_test("aB_BFu31ll_B");
    static aB_BFu31ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_B)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_B");
    check_field_offset(lv, v3, 5, "aB_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_B(Test_aB_BFu31ll_B, "aB_BFu31ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu15i()
{
  {
    init_simple_test("aB_BFu31ll_BFu15i");
    static aB_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aB_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aB_BFu31ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu15i(Test_aB_BFu31ll_BFu15i, "aB_BFu31ll_BFu15i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu15ll()
{
  {
    init_simple_test("aB_BFu31ll_BFu15ll");
    static aB_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aB_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aB_BFu31ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu15ll(Test_aB_BFu31ll_BFu15ll, "aB_BFu31ll_BFu15ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu15s()
{
  {
    init_simple_test("aB_BFu31ll_BFu15s");
    static aB_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aB_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aB_BFu31ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu15s(Test_aB_BFu31ll_BFu15s, "aB_BFu31ll_BFu15s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu16i()
{
  {
    init_simple_test("aB_BFu31ll_BFu16i");
    static aB_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aB_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aB_BFu31ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu16i(Test_aB_BFu31ll_BFu16i, "aB_BFu31ll_BFu16i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu16ll()
{
  {
    init_simple_test("aB_BFu31ll_BFu16ll");
    static aB_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aB_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aB_BFu31ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu16ll(Test_aB_BFu31ll_BFu16ll, "aB_BFu31ll_BFu16ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu16s()
{
  {
    init_simple_test("aB_BFu31ll_BFu16s");
    static aB_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aB_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aB_BFu31ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu16s(Test_aB_BFu31ll_BFu16s, "aB_BFu31ll_BFu16s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu17i()
{
  {
    init_simple_test("aB_BFu31ll_BFu17i");
    static aB_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aB_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aB_BFu31ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu17i(Test_aB_BFu31ll_BFu17i, "aB_BFu31ll_BFu17i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu17ll()
{
  {
    init_simple_test("aB_BFu31ll_BFu17ll");
    static aB_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aB_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aB_BFu31ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu17ll(Test_aB_BFu31ll_BFu17ll, "aB_BFu31ll_BFu17ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu1c()
{
  {
    init_simple_test("aB_BFu31ll_BFu1c");
    static aB_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu31ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aB_BFu31ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu1c(Test_aB_BFu31ll_BFu1c, "aB_BFu31ll_BFu1c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu1i()
{
  {
    init_simple_test("aB_BFu31ll_BFu1i");
    static aB_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu31ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aB_BFu31ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu1i(Test_aB_BFu31ll_BFu1i, "aB_BFu31ll_BFu1i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu1ll()
{
  {
    init_simple_test("aB_BFu31ll_BFu1ll");
    static aB_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aB_BFu31ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu1ll(Test_aB_BFu31ll_BFu1ll, "aB_BFu31ll_BFu1ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu1s()
{
  {
    init_simple_test("aB_BFu31ll_BFu1s");
    static aB_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu31ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aB_BFu31ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu1s(Test_aB_BFu31ll_BFu1s, "aB_BFu31ll_BFu1s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu31i()
{
  {
    init_simple_test("aB_BFu31ll_BFu31i");
    static aB_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aB_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu31i(Test_aB_BFu31ll_BFu31i, "aB_BFu31ll_BFu31i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu31ll()
{
  {
    init_simple_test("aB_BFu31ll_BFu31ll");
    static aB_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aB_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu31ll(Test_aB_BFu31ll_BFu31ll, "aB_BFu31ll_BFu31ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu32i()
{
  {
    init_simple_test("aB_BFu31ll_BFu32i");
    static aB_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aB_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aB_BFu31ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu32i(Test_aB_BFu31ll_BFu32i, "aB_BFu31ll_BFu32i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu32ll()
{
  {
    init_simple_test("aB_BFu31ll_BFu32ll");
    static aB_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aB_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aB_BFu31ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu32ll(Test_aB_BFu31ll_BFu32ll, "aB_BFu31ll_BFu32ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu33()
{
  {
    init_simple_test("aB_BFu31ll_BFu33");
    static aB_BFu31ll_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, 1, "aB_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, hide_ull(1LL<<32), "aB_BFu31ll_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu33(Test_aB_BFu31ll_BFu33, "aB_BFu31ll_BFu33", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu7c()
{
  {
    init_simple_test("aB_BFu31ll_BFu7c");
    static aB_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aB_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aB_BFu31ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu7c(Test_aB_BFu31ll_BFu7c, "aB_BFu31ll_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu7i()
{
  {
    init_simple_test("aB_BFu31ll_BFu7i");
    static aB_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aB_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aB_BFu31ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu7i(Test_aB_BFu31ll_BFu7i, "aB_BFu31ll_BFu7i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu7ll()
{
  {
    init_simple_test("aB_BFu31ll_BFu7ll");
    static aB_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aB_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aB_BFu31ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu7ll(Test_aB_BFu31ll_BFu7ll, "aB_BFu31ll_BFu7ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu7s()
{
  {
    init_simple_test("aB_BFu31ll_BFu7s");
    static aB_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aB_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aB_BFu31ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu7s(Test_aB_BFu31ll_BFu7s, "aB_BFu31ll_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu8c()
{
  {
    init_simple_test("aB_BFu31ll_BFu8c");
    static aB_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aB_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aB_BFu31ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu8c(Test_aB_BFu31ll_BFu8c, "aB_BFu31ll_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu8i()
{
  {
    init_simple_test("aB_BFu31ll_BFu8i");
    static aB_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aB_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aB_BFu31ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu8i(Test_aB_BFu31ll_BFu8i, "aB_BFu31ll_BFu8i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu8ll()
{
  {
    init_simple_test("aB_BFu31ll_BFu8ll");
    static aB_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aB_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aB_BFu31ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu8ll(Test_aB_BFu31ll_BFu8ll, "aB_BFu31ll_BFu8ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu8s()
{
  {
    init_simple_test("aB_BFu31ll_BFu8s");
    static aB_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aB_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aB_BFu31ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu8s(Test_aB_BFu31ll_BFu8s, "aB_BFu31ll_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu9i()
{
  {
    init_simple_test("aB_BFu31ll_BFu9i");
    static aB_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aB_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aB_BFu31ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu9i(Test_aB_BFu31ll_BFu9i, "aB_BFu31ll_BFu9i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu9ll()
{
  {
    init_simple_test("aB_BFu31ll_BFu9ll");
    static aB_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aB_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aB_BFu31ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu9ll(Test_aB_BFu31ll_BFu9ll, "aB_BFu31ll_BFu9ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_BFu9s()
{
  {
    init_simple_test("aB_BFu31ll_BFu9s");
    static aB_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aB_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aB_BFu31ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_BFu9s(Test_aB_BFu31ll_BFu9s, "aB_BFu31ll_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_C()
{
  {
    init_simple_test("aB_BFu31ll_C");
    static aB_BFu31ll_C lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_C");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_C");
    check_field_offset(lv, v3, 5, "aB_BFu31ll_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_C(Test_aB_BFu31ll_C, "aB_BFu31ll_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_D()
{
  {
    init_simple_test("aB_BFu31ll_D");
    static aB_BFu31ll_D lv;
    check2(sizeof(lv), 13, "sizeof(aB_BFu31ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_D");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_D");
    check_field_offset(lv, v3, 5, "aB_BFu31ll_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_D(Test_aB_BFu31ll_D, "aB_BFu31ll_D", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_F()
{
  {
    init_simple_test("aB_BFu31ll_F");
    static aB_BFu31ll_F lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_F");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_F");
    check_field_offset(lv, v3, 5, "aB_BFu31ll_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_F(Test_aB_BFu31ll_F, "aB_BFu31ll_F", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_I()
{
  {
    init_simple_test("aB_BFu31ll_I");
    static aB_BFu31ll_I lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_I");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_I");
    check_field_offset(lv, v3, 5, "aB_BFu31ll_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_I(Test_aB_BFu31ll_I, "aB_BFu31ll_I", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_Ip()
{
  {
    init_simple_test("aB_BFu31ll_Ip");
    static aB_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aB_BFu31ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_Ip");
    check_field_offset(lv, v3, 5, "aB_BFu31ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_Ip(Test_aB_BFu31ll_Ip, "aB_BFu31ll_Ip", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_L()
{
  {
    init_simple_test("aB_BFu31ll_L");
    static aB_BFu31ll_L lv;
    check2(sizeof(lv), 13, "sizeof(aB_BFu31ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_L");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_L");
    check_field_offset(lv, v3, 5, "aB_BFu31ll_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_L(Test_aB_BFu31ll_L, "aB_BFu31ll_L", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_S()
{
  {
    init_simple_test("aB_BFu31ll_S");
    static aB_BFu31ll_S lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_S");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_S");
    check_field_offset(lv, v3, 5, "aB_BFu31ll_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_S(Test_aB_BFu31ll_S, "aB_BFu31ll_S", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_Uc()
{
  {
    init_simple_test("aB_BFu31ll_Uc");
    static aB_BFu31ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu31ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_Uc");
    check_field_offset(lv, v3, 5, "aB_BFu31ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_Uc(Test_aB_BFu31ll_Uc, "aB_BFu31ll_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_Ui()
{
  {
    init_simple_test("aB_BFu31ll_Ui");
    static aB_BFu31ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu31ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_Ui");
    check_field_offset(lv, v3, 5, "aB_BFu31ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_Ui(Test_aB_BFu31ll_Ui, "aB_BFu31ll_Ui", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_Ul()
{
  {
    init_simple_test("aB_BFu31ll_Ul");
    static aB_BFu31ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aB_BFu31ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_Ul");
    check_field_offset(lv, v3, 5, "aB_BFu31ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_Ul(Test_aB_BFu31ll_Ul, "aB_BFu31ll_Ul", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_Us()
{
  {
    init_simple_test("aB_BFu31ll_Us");
    static aB_BFu31ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu31ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_Us");
    check_field_offset(lv, v3, 5, "aB_BFu31ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_Us(Test_aB_BFu31ll_Us, "aB_BFu31ll_Us", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu31ll_Vp()
{
  {
    init_simple_test("aB_BFu31ll_Vp");
    static aB_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aB_BFu31ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aB_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aB_BFu31ll_Vp");
    check_field_offset(lv, v3, 5, "aB_BFu31ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu31ll_Vp(Test_aB_BFu31ll_Vp, "aB_BFu31ll_Vp", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i()
{
  {
    init_simple_test("aB_BFu32i");
    static aB_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu32i(Test_aB_BFu32i, "aB_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_B()
{
  {
    init_simple_test("aB_BFu32i_B");
    static aB_BFu32i_B lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_B)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_B");
    check_field_offset(lv, v3, 5, "aB_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_B(Test_aB_BFu32i_B, "aB_BFu32i_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu15i()
{
  {
    init_simple_test("aB_BFu32i_BFu15i");
    static aB_BFu32i_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aB_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aB_BFu32i_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu15i(Test_aB_BFu32i_BFu15i, "aB_BFu32i_BFu15i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu15ll()
{
  {
    init_simple_test("aB_BFu32i_BFu15ll");
    static aB_BFu32i_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aB_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aB_BFu32i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu15ll(Test_aB_BFu32i_BFu15ll, "aB_BFu32i_BFu15ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu15s()
{
  {
    init_simple_test("aB_BFu32i_BFu15s");
    static aB_BFu32i_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aB_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aB_BFu32i_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu15s(Test_aB_BFu32i_BFu15s, "aB_BFu32i_BFu15s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu16i()
{
  {
    init_simple_test("aB_BFu32i_BFu16i");
    static aB_BFu32i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aB_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aB_BFu32i_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu16i(Test_aB_BFu32i_BFu16i, "aB_BFu32i_BFu16i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu16ll()
{
  {
    init_simple_test("aB_BFu32i_BFu16ll");
    static aB_BFu32i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aB_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aB_BFu32i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu16ll(Test_aB_BFu32i_BFu16ll, "aB_BFu32i_BFu16ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu16s()
{
  {
    init_simple_test("aB_BFu32i_BFu16s");
    static aB_BFu32i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aB_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aB_BFu32i_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu16s(Test_aB_BFu32i_BFu16s, "aB_BFu32i_BFu16s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu17i()
{
  {
    init_simple_test("aB_BFu32i_BFu17i");
    static aB_BFu32i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu32i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aB_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aB_BFu32i_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu17i(Test_aB_BFu32i_BFu17i, "aB_BFu32i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu17ll()
{
  {
    init_simple_test("aB_BFu32i_BFu17ll");
    static aB_BFu32i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu32i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aB_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aB_BFu32i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu17ll(Test_aB_BFu32i_BFu17ll, "aB_BFu32i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu1c()
{
  {
    init_simple_test("aB_BFu32i_BFu1c");
    static aB_BFu32i_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aB_BFu32i_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu1c(Test_aB_BFu32i_BFu1c, "aB_BFu32i_BFu1c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu1i()
{
  {
    init_simple_test("aB_BFu32i_BFu1i");
    static aB_BFu32i_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aB_BFu32i_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu1i(Test_aB_BFu32i_BFu1i, "aB_BFu32i_BFu1i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu1ll()
{
  {
    init_simple_test("aB_BFu32i_BFu1ll");
    static aB_BFu32i_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aB_BFu32i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu1ll(Test_aB_BFu32i_BFu1ll, "aB_BFu32i_BFu1ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu1s()
{
  {
    init_simple_test("aB_BFu32i_BFu1s");
    static aB_BFu32i_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aB_BFu32i_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu1s(Test_aB_BFu32i_BFu1s, "aB_BFu32i_BFu1s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu31i()
{
  {
    init_simple_test("aB_BFu32i_BFu31i");
    static aB_BFu32i_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aB_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aB_BFu32i_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu31i(Test_aB_BFu32i_BFu31i, "aB_BFu32i_BFu31i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu31ll()
{
  {
    init_simple_test("aB_BFu32i_BFu31ll");
    static aB_BFu32i_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aB_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aB_BFu32i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu31ll(Test_aB_BFu32i_BFu31ll, "aB_BFu32i_BFu31ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu32i()
{
  {
    init_simple_test("aB_BFu32i_BFu32i");
    static aB_BFu32i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aB_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu32i(Test_aB_BFu32i_BFu32i, "aB_BFu32i_BFu32i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu32ll()
{
  {
    init_simple_test("aB_BFu32i_BFu32ll");
    static aB_BFu32i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aB_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu32ll(Test_aB_BFu32i_BFu32ll, "aB_BFu32i_BFu32ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu33()
{
  {
    init_simple_test("aB_BFu32i_BFu33");
    static aB_BFu32i_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu32i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aB_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aB_BFu32i_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu33(Test_aB_BFu32i_BFu33, "aB_BFu32i_BFu33", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu7c()
{
  {
    init_simple_test("aB_BFu32i_BFu7c");
    static aB_BFu32i_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aB_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aB_BFu32i_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu7c(Test_aB_BFu32i_BFu7c, "aB_BFu32i_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu7i()
{
  {
    init_simple_test("aB_BFu32i_BFu7i");
    static aB_BFu32i_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aB_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aB_BFu32i_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu7i(Test_aB_BFu32i_BFu7i, "aB_BFu32i_BFu7i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu7ll()
{
  {
    init_simple_test("aB_BFu32i_BFu7ll");
    static aB_BFu32i_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aB_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aB_BFu32i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu7ll(Test_aB_BFu32i_BFu7ll, "aB_BFu32i_BFu7ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu7s()
{
  {
    init_simple_test("aB_BFu32i_BFu7s");
    static aB_BFu32i_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aB_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aB_BFu32i_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu7s(Test_aB_BFu32i_BFu7s, "aB_BFu32i_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu8c()
{
  {
    init_simple_test("aB_BFu32i_BFu8c");
    static aB_BFu32i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aB_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aB_BFu32i_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu8c(Test_aB_BFu32i_BFu8c, "aB_BFu32i_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu8i()
{
  {
    init_simple_test("aB_BFu32i_BFu8i");
    static aB_BFu32i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aB_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aB_BFu32i_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu8i(Test_aB_BFu32i_BFu8i, "aB_BFu32i_BFu8i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu8ll()
{
  {
    init_simple_test("aB_BFu32i_BFu8ll");
    static aB_BFu32i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aB_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aB_BFu32i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu8ll(Test_aB_BFu32i_BFu8ll, "aB_BFu32i_BFu8ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu8s()
{
  {
    init_simple_test("aB_BFu32i_BFu8s");
    static aB_BFu32i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aB_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aB_BFu32i_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu8s(Test_aB_BFu32i_BFu8s, "aB_BFu32i_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu9i()
{
  {
    init_simple_test("aB_BFu32i_BFu9i");
    static aB_BFu32i_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aB_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aB_BFu32i_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu9i(Test_aB_BFu32i_BFu9i, "aB_BFu32i_BFu9i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu9ll()
{
  {
    init_simple_test("aB_BFu32i_BFu9ll");
    static aB_BFu32i_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aB_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aB_BFu32i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu9ll(Test_aB_BFu32i_BFu9ll, "aB_BFu32i_BFu9ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_BFu9s()
{
  {
    init_simple_test("aB_BFu32i_BFu9s");
    static aB_BFu32i_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aB_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aB_BFu32i_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_BFu9s(Test_aB_BFu32i_BFu9s, "aB_BFu32i_BFu9s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_C()
{
  {
    init_simple_test("aB_BFu32i_C");
    static aB_BFu32i_C lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_C)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_C");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_C");
    check_field_offset(lv, v3, 5, "aB_BFu32i_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_C(Test_aB_BFu32i_C, "aB_BFu32i_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_D()
{
  {
    init_simple_test("aB_BFu32i_D");
    static aB_BFu32i_D lv;
    check2(sizeof(lv), 13, "sizeof(aB_BFu32i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_D)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_D");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_D");
    check_field_offset(lv, v3, 5, "aB_BFu32i_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_D(Test_aB_BFu32i_D, "aB_BFu32i_D", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_F()
{
  {
    init_simple_test("aB_BFu32i_F");
    static aB_BFu32i_F lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_F)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_F");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_F");
    check_field_offset(lv, v3, 5, "aB_BFu32i_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_F(Test_aB_BFu32i_F, "aB_BFu32i_F", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_I()
{
  {
    init_simple_test("aB_BFu32i_I");
    static aB_BFu32i_I lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_I)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_I");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_I");
    check_field_offset(lv, v3, 5, "aB_BFu32i_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_I(Test_aB_BFu32i_I, "aB_BFu32i_I", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_Ip()
{
  {
    init_simple_test("aB_BFu32i_Ip");
    static aB_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aB_BFu32i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_Ip");
    check_field_offset(lv, v3, 5, "aB_BFu32i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_Ip(Test_aB_BFu32i_Ip, "aB_BFu32i_Ip", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_L()
{
  {
    init_simple_test("aB_BFu32i_L");
    static aB_BFu32i_L lv;
    check2(sizeof(lv), 13, "sizeof(aB_BFu32i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_L)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_L");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_L");
    check_field_offset(lv, v3, 5, "aB_BFu32i_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_L(Test_aB_BFu32i_L, "aB_BFu32i_L", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_S()
{
  {
    init_simple_test("aB_BFu32i_S");
    static aB_BFu32i_S lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_S)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_S");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_S");
    check_field_offset(lv, v3, 5, "aB_BFu32i_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_S(Test_aB_BFu32i_S, "aB_BFu32i_S", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_Uc()
{
  {
    init_simple_test("aB_BFu32i_Uc");
    static aB_BFu32i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_Uc");
    check_field_offset(lv, v3, 5, "aB_BFu32i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_Uc(Test_aB_BFu32i_Uc, "aB_BFu32i_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_Ui()
{
  {
    init_simple_test("aB_BFu32i_Ui");
    static aB_BFu32i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_Ui");
    check_field_offset(lv, v3, 5, "aB_BFu32i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_Ui(Test_aB_BFu32i_Ui, "aB_BFu32i_Ui", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_Ul()
{
  {
    init_simple_test("aB_BFu32i_Ul");
    static aB_BFu32i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aB_BFu32i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_Ul");
    check_field_offset(lv, v3, 5, "aB_BFu32i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_Ul(Test_aB_BFu32i_Ul, "aB_BFu32i_Ul", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_Us()
{
  {
    init_simple_test("aB_BFu32i_Us");
    static aB_BFu32i_Us lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_Us");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_Us");
    check_field_offset(lv, v3, 5, "aB_BFu32i_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_Us(Test_aB_BFu32i_Us, "aB_BFu32i_Us", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32i_Vp()
{
  {
    init_simple_test("aB_BFu32i_Vp");
    static aB_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aB_BFu32i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32i_Vp");
    check_field_offset(lv, v3, 5, "aB_BFu32i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32i_Vp(Test_aB_BFu32i_Vp, "aB_BFu32i_Vp", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll()
{
  {
    init_simple_test("aB_BFu32ll");
    static aB_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll(Test_aB_BFu32ll, "aB_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_B()
{
  {
    init_simple_test("aB_BFu32ll_B");
    static aB_BFu32ll_B lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_B)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_B");
    check_field_offset(lv, v3, 5, "aB_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_B(Test_aB_BFu32ll_B, "aB_BFu32ll_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu15i()
{
  {
    init_simple_test("aB_BFu32ll_BFu15i");
    static aB_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aB_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aB_BFu32ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu15i(Test_aB_BFu32ll_BFu15i, "aB_BFu32ll_BFu15i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu15ll()
{
  {
    init_simple_test("aB_BFu32ll_BFu15ll");
    static aB_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aB_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aB_BFu32ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu15ll(Test_aB_BFu32ll_BFu15ll, "aB_BFu32ll_BFu15ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu15s()
{
  {
    init_simple_test("aB_BFu32ll_BFu15s");
    static aB_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aB_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aB_BFu32ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu15s(Test_aB_BFu32ll_BFu15s, "aB_BFu32ll_BFu15s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu16i()
{
  {
    init_simple_test("aB_BFu32ll_BFu16i");
    static aB_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aB_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aB_BFu32ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu16i(Test_aB_BFu32ll_BFu16i, "aB_BFu32ll_BFu16i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu16ll()
{
  {
    init_simple_test("aB_BFu32ll_BFu16ll");
    static aB_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aB_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aB_BFu32ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu16ll(Test_aB_BFu32ll_BFu16ll, "aB_BFu32ll_BFu16ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu16s()
{
  {
    init_simple_test("aB_BFu32ll_BFu16s");
    static aB_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aB_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aB_BFu32ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu16s(Test_aB_BFu32ll_BFu16s, "aB_BFu32ll_BFu16s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu17i()
{
  {
    init_simple_test("aB_BFu32ll_BFu17i");
    static aB_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu32ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aB_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aB_BFu32ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu17i(Test_aB_BFu32ll_BFu17i, "aB_BFu32ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu17ll()
{
  {
    init_simple_test("aB_BFu32ll_BFu17ll");
    static aB_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aB_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aB_BFu32ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu17ll(Test_aB_BFu32ll_BFu17ll, "aB_BFu32ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu1c()
{
  {
    init_simple_test("aB_BFu32ll_BFu1c");
    static aB_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aB_BFu32ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu1c(Test_aB_BFu32ll_BFu1c, "aB_BFu32ll_BFu1c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu1i()
{
  {
    init_simple_test("aB_BFu32ll_BFu1i");
    static aB_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aB_BFu32ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu1i(Test_aB_BFu32ll_BFu1i, "aB_BFu32ll_BFu1i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu1ll()
{
  {
    init_simple_test("aB_BFu32ll_BFu1ll");
    static aB_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aB_BFu32ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu1ll(Test_aB_BFu32ll_BFu1ll, "aB_BFu32ll_BFu1ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu1s()
{
  {
    init_simple_test("aB_BFu32ll_BFu1s");
    static aB_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aB_BFu32ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu1s(Test_aB_BFu32ll_BFu1s, "aB_BFu32ll_BFu1s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu31i()
{
  {
    init_simple_test("aB_BFu32ll_BFu31i");
    static aB_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aB_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aB_BFu32ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu31i(Test_aB_BFu32ll_BFu31i, "aB_BFu32ll_BFu31i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu31ll()
{
  {
    init_simple_test("aB_BFu32ll_BFu31ll");
    static aB_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aB_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aB_BFu32ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu31ll(Test_aB_BFu32ll_BFu31ll, "aB_BFu32ll_BFu31ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu32i()
{
  {
    init_simple_test("aB_BFu32ll_BFu32i");
    static aB_BFu32ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aB_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu32i(Test_aB_BFu32ll_BFu32i, "aB_BFu32ll_BFu32i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu32ll()
{
  {
    init_simple_test("aB_BFu32ll_BFu32ll");
    static aB_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aB_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu32ll(Test_aB_BFu32ll_BFu32ll, "aB_BFu32ll_BFu32ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu33()
{
  {
    init_simple_test("aB_BFu32ll_BFu33");
    static aB_BFu32ll_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu32ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aB_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aB_BFu32ll_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu33(Test_aB_BFu32ll_BFu33, "aB_BFu32ll_BFu33", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu7c()
{
  {
    init_simple_test("aB_BFu32ll_BFu7c");
    static aB_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aB_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aB_BFu32ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu7c(Test_aB_BFu32ll_BFu7c, "aB_BFu32ll_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu7i()
{
  {
    init_simple_test("aB_BFu32ll_BFu7i");
    static aB_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aB_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aB_BFu32ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu7i(Test_aB_BFu32ll_BFu7i, "aB_BFu32ll_BFu7i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu7ll()
{
  {
    init_simple_test("aB_BFu32ll_BFu7ll");
    static aB_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aB_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aB_BFu32ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu7ll(Test_aB_BFu32ll_BFu7ll, "aB_BFu32ll_BFu7ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu7s()
{
  {
    init_simple_test("aB_BFu32ll_BFu7s");
    static aB_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aB_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aB_BFu32ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu7s(Test_aB_BFu32ll_BFu7s, "aB_BFu32ll_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu8c()
{
  {
    init_simple_test("aB_BFu32ll_BFu8c");
    static aB_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aB_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aB_BFu32ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu8c(Test_aB_BFu32ll_BFu8c, "aB_BFu32ll_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu8i()
{
  {
    init_simple_test("aB_BFu32ll_BFu8i");
    static aB_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aB_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aB_BFu32ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu8i(Test_aB_BFu32ll_BFu8i, "aB_BFu32ll_BFu8i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu8ll()
{
  {
    init_simple_test("aB_BFu32ll_BFu8ll");
    static aB_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aB_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aB_BFu32ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu8ll(Test_aB_BFu32ll_BFu8ll, "aB_BFu32ll_BFu8ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu8s()
{
  {
    init_simple_test("aB_BFu32ll_BFu8s");
    static aB_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aB_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aB_BFu32ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu8s(Test_aB_BFu32ll_BFu8s, "aB_BFu32ll_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu9i()
{
  {
    init_simple_test("aB_BFu32ll_BFu9i");
    static aB_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aB_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aB_BFu32ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu9i(Test_aB_BFu32ll_BFu9i, "aB_BFu32ll_BFu9i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu9ll()
{
  {
    init_simple_test("aB_BFu32ll_BFu9ll");
    static aB_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aB_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aB_BFu32ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu9ll(Test_aB_BFu32ll_BFu9ll, "aB_BFu32ll_BFu9ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_BFu9s()
{
  {
    init_simple_test("aB_BFu32ll_BFu9s");
    static aB_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aB_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aB_BFu32ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_BFu9s(Test_aB_BFu32ll_BFu9s, "aB_BFu32ll_BFu9s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_C()
{
  {
    init_simple_test("aB_BFu32ll_C");
    static aB_BFu32ll_C lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_C");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_C");
    check_field_offset(lv, v3, 5, "aB_BFu32ll_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_C(Test_aB_BFu32ll_C, "aB_BFu32ll_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_D()
{
  {
    init_simple_test("aB_BFu32ll_D");
    static aB_BFu32ll_D lv;
    check2(sizeof(lv), 13, "sizeof(aB_BFu32ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_D");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_D");
    check_field_offset(lv, v3, 5, "aB_BFu32ll_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_D(Test_aB_BFu32ll_D, "aB_BFu32ll_D", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_F()
{
  {
    init_simple_test("aB_BFu32ll_F");
    static aB_BFu32ll_F lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_F");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_F");
    check_field_offset(lv, v3, 5, "aB_BFu32ll_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_F(Test_aB_BFu32ll_F, "aB_BFu32ll_F", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_I()
{
  {
    init_simple_test("aB_BFu32ll_I");
    static aB_BFu32ll_I lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_I");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_I");
    check_field_offset(lv, v3, 5, "aB_BFu32ll_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_I(Test_aB_BFu32ll_I, "aB_BFu32ll_I", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_Ip()
{
  {
    init_simple_test("aB_BFu32ll_Ip");
    static aB_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aB_BFu32ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_Ip");
    check_field_offset(lv, v3, 5, "aB_BFu32ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_Ip(Test_aB_BFu32ll_Ip, "aB_BFu32ll_Ip", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_L()
{
  {
    init_simple_test("aB_BFu32ll_L");
    static aB_BFu32ll_L lv;
    check2(sizeof(lv), 13, "sizeof(aB_BFu32ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_L");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_L");
    check_field_offset(lv, v3, 5, "aB_BFu32ll_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_L(Test_aB_BFu32ll_L, "aB_BFu32ll_L", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_S()
{
  {
    init_simple_test("aB_BFu32ll_S");
    static aB_BFu32ll_S lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_S");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_S");
    check_field_offset(lv, v3, 5, "aB_BFu32ll_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_S(Test_aB_BFu32ll_S, "aB_BFu32ll_S", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_Uc()
{
  {
    init_simple_test("aB_BFu32ll_Uc");
    static aB_BFu32ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu32ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_Uc");
    check_field_offset(lv, v3, 5, "aB_BFu32ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_Uc(Test_aB_BFu32ll_Uc, "aB_BFu32ll_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_Ui()
{
  {
    init_simple_test("aB_BFu32ll_Ui");
    static aB_BFu32ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu32ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_Ui");
    check_field_offset(lv, v3, 5, "aB_BFu32ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_Ui(Test_aB_BFu32ll_Ui, "aB_BFu32ll_Ui", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_Ul()
{
  {
    init_simple_test("aB_BFu32ll_Ul");
    static aB_BFu32ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aB_BFu32ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_Ul");
    check_field_offset(lv, v3, 5, "aB_BFu32ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_Ul(Test_aB_BFu32ll_Ul, "aB_BFu32ll_Ul", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_Us()
{
  {
    init_simple_test("aB_BFu32ll_Us");
    static aB_BFu32ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu32ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_Us");
    check_field_offset(lv, v3, 5, "aB_BFu32ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_Us(Test_aB_BFu32ll_Us, "aB_BFu32ll_Us", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu32ll_Vp()
{
  {
    init_simple_test("aB_BFu32ll_Vp");
    static aB_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aB_BFu32ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aB_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aB_BFu32ll_Vp");
    check_field_offset(lv, v3, 5, "aB_BFu32ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu32ll_Vp(Test_aB_BFu32ll_Vp, "aB_BFu32ll_Vp", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33()
{
  {
    init_simple_test("aB_BFu33");
    static aB_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu33(Test_aB_BFu33, "aB_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_B()
{
  {
    init_simple_test("aB_BFu33_B");
    static aB_BFu33_B lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu33_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_B)");
    check_field_offset(lv, v1, 0, "aB_BFu33_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_B");
    check_field_offset(lv, v3, 6, "aB_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu33_B(Test_aB_BFu33_B, "aB_BFu33_B", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu15i()
{
  {
    init_simple_test("aB_BFu33_BFu15i");
    static aB_BFu33_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu33_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aB_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aB_BFu33_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu15i(Test_aB_BFu33_BFu15i, "aB_BFu33_BFu15i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu15ll()
{
  {
    init_simple_test("aB_BFu33_BFu15ll");
    static aB_BFu33_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu33_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aB_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aB_BFu33_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu15ll(Test_aB_BFu33_BFu15ll, "aB_BFu33_BFu15ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu15s()
{
  {
    init_simple_test("aB_BFu33_BFu15s");
    static aB_BFu33_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu33_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aB_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aB_BFu33_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu15s(Test_aB_BFu33_BFu15s, "aB_BFu33_BFu15s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu16i()
{
  {
    init_simple_test("aB_BFu33_BFu16i");
    static aB_BFu33_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu33_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aB_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aB_BFu33_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu16i(Test_aB_BFu33_BFu16i, "aB_BFu33_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu16ll()
{
  {
    init_simple_test("aB_BFu33_BFu16ll");
    static aB_BFu33_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu33_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aB_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aB_BFu33_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu16ll(Test_aB_BFu33_BFu16ll, "aB_BFu33_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu16s()
{
  {
    init_simple_test("aB_BFu33_BFu16s");
    static aB_BFu33_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu33_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aB_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aB_BFu33_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu16s(Test_aB_BFu33_BFu16s, "aB_BFu33_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu17i()
{
  {
    init_simple_test("aB_BFu33_BFu17i");
    static aB_BFu33_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu33_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "aB_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "aB_BFu33_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu17i(Test_aB_BFu33_BFu17i, "aB_BFu33_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu17ll()
{
  {
    init_simple_test("aB_BFu33_BFu17ll");
    static aB_BFu33_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu33_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "aB_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "aB_BFu33_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu17ll(Test_aB_BFu33_BFu17ll, "aB_BFu33_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu1c()
{
  {
    init_simple_test("aB_BFu33_BFu1c");
    static aB_BFu33_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu33_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aB_BFu33_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu1c(Test_aB_BFu33_BFu1c, "aB_BFu33_BFu1c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu1i()
{
  {
    init_simple_test("aB_BFu33_BFu1i");
    static aB_BFu33_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu33_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aB_BFu33_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu1i(Test_aB_BFu33_BFu1i, "aB_BFu33_BFu1i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu1ll()
{
  {
    init_simple_test("aB_BFu33_BFu1ll");
    static aB_BFu33_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu33_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aB_BFu33_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu1ll(Test_aB_BFu33_BFu1ll, "aB_BFu33_BFu1ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu1s()
{
  {
    init_simple_test("aB_BFu33_BFu1s");
    static aB_BFu33_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu33_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aB_BFu33_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu1s(Test_aB_BFu33_BFu1s, "aB_BFu33_BFu1s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu31i()
{
  {
    init_simple_test("aB_BFu33_BFu31i");
    static aB_BFu33_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu33_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "aB_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "aB_BFu33_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu31i(Test_aB_BFu33_BFu31i, "aB_BFu33_BFu31i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu31ll()
{
  {
    init_simple_test("aB_BFu33_BFu31ll");
    static aB_BFu33_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aB_BFu33_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "aB_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "aB_BFu33_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu31ll(Test_aB_BFu33_BFu31ll, "aB_BFu33_BFu31ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu32i()
{
  {
    init_simple_test("aB_BFu33_BFu32i");
    static aB_BFu33_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu33_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "aB_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "aB_BFu33_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu32i(Test_aB_BFu33_BFu32i, "aB_BFu33_BFu32i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu32ll()
{
  {
    init_simple_test("aB_BFu33_BFu32ll");
    static aB_BFu33_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu33_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "aB_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "aB_BFu33_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu32ll(Test_aB_BFu33_BFu32ll, "aB_BFu33_BFu32ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu33()
{
  {
    init_simple_test("aB_BFu33_BFu33");
    static aB_BFu33_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu33_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, 1, "aB_BFu33_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, hide_ull(1LL<<32), "aB_BFu33_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu33(Test_aB_BFu33_BFu33, "aB_BFu33_BFu33", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu7c()
{
  {
    init_simple_test("aB_BFu33_BFu7c");
    static aB_BFu33_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu33_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aB_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aB_BFu33_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu7c(Test_aB_BFu33_BFu7c, "aB_BFu33_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu7i()
{
  {
    init_simple_test("aB_BFu33_BFu7i");
    static aB_BFu33_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu33_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aB_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aB_BFu33_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu7i(Test_aB_BFu33_BFu7i, "aB_BFu33_BFu7i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu7ll()
{
  {
    init_simple_test("aB_BFu33_BFu7ll");
    static aB_BFu33_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu33_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aB_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aB_BFu33_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu7ll(Test_aB_BFu33_BFu7ll, "aB_BFu33_BFu7ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu7s()
{
  {
    init_simple_test("aB_BFu33_BFu7s");
    static aB_BFu33_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu33_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aB_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aB_BFu33_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu7s(Test_aB_BFu33_BFu7s, "aB_BFu33_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu8c()
{
  {
    init_simple_test("aB_BFu33_BFu8c");
    static aB_BFu33_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu33_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aB_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aB_BFu33_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu8c(Test_aB_BFu33_BFu8c, "aB_BFu33_BFu8c", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu8i()
{
  {
    init_simple_test("aB_BFu33_BFu8i");
    static aB_BFu33_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu33_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aB_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aB_BFu33_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu8i(Test_aB_BFu33_BFu8i, "aB_BFu33_BFu8i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu8ll()
{
  {
    init_simple_test("aB_BFu33_BFu8ll");
    static aB_BFu33_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu33_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aB_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aB_BFu33_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu8ll(Test_aB_BFu33_BFu8ll, "aB_BFu33_BFu8ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu8s()
{
  {
    init_simple_test("aB_BFu33_BFu8s");
    static aB_BFu33_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu33_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aB_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aB_BFu33_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu8s(Test_aB_BFu33_BFu8s, "aB_BFu33_BFu8s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu9i()
{
  {
    init_simple_test("aB_BFu33_BFu9i");
    static aB_BFu33_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu33_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aB_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aB_BFu33_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu9i(Test_aB_BFu33_BFu9i, "aB_BFu33_BFu9i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu9ll()
{
  {
    init_simple_test("aB_BFu33_BFu9ll");
    static aB_BFu33_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu33_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aB_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aB_BFu33_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu9ll(Test_aB_BFu33_BFu9ll, "aB_BFu33_BFu9ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_BFu9s()
{
  {
    init_simple_test("aB_BFu33_BFu9s");
    static aB_BFu33_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu33_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aB_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aB_BFu33_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu33_BFu9s(Test_aB_BFu33_BFu9s, "aB_BFu33_BFu9s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_C()
{
  {
    init_simple_test("aB_BFu33_C");
    static aB_BFu33_C lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu33_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_C)");
    check_field_offset(lv, v1, 0, "aB_BFu33_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_C");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_C");
    check_field_offset(lv, v3, 6, "aB_BFu33_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu33_C(Test_aB_BFu33_C, "aB_BFu33_C", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_D()
{
  {
    init_simple_test("aB_BFu33_D");
    static aB_BFu33_D lv;
    check2(sizeof(lv), 14, "sizeof(aB_BFu33_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_D)");
    check_field_offset(lv, v1, 0, "aB_BFu33_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_D");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_D");
    check_field_offset(lv, v3, 6, "aB_BFu33_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu33_D(Test_aB_BFu33_D, "aB_BFu33_D", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_F()
{
  {
    init_simple_test("aB_BFu33_F");
    static aB_BFu33_F lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu33_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_F)");
    check_field_offset(lv, v1, 0, "aB_BFu33_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_F");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_F");
    check_field_offset(lv, v3, 6, "aB_BFu33_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu33_F(Test_aB_BFu33_F, "aB_BFu33_F", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_I()
{
  {
    init_simple_test("aB_BFu33_I");
    static aB_BFu33_I lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu33_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_I)");
    check_field_offset(lv, v1, 0, "aB_BFu33_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_I");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_I");
    check_field_offset(lv, v3, 6, "aB_BFu33_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu33_I(Test_aB_BFu33_I, "aB_BFu33_I", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_Ip()
{
  {
    init_simple_test("aB_BFu33_Ip");
    static aB_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aB_BFu33_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_Ip");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_Ip");
    check_field_offset(lv, v3, 6, "aB_BFu33_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu33_Ip(Test_aB_BFu33_Ip, "aB_BFu33_Ip", ABISELECT(14,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_L()
{
  {
    init_simple_test("aB_BFu33_L");
    static aB_BFu33_L lv;
    check2(sizeof(lv), 14, "sizeof(aB_BFu33_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_L)");
    check_field_offset(lv, v1, 0, "aB_BFu33_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_L");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_L");
    check_field_offset(lv, v3, 6, "aB_BFu33_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu33_L(Test_aB_BFu33_L, "aB_BFu33_L", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_S()
{
  {
    init_simple_test("aB_BFu33_S");
    static aB_BFu33_S lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu33_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_S)");
    check_field_offset(lv, v1, 0, "aB_BFu33_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_S");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_S");
    check_field_offset(lv, v3, 6, "aB_BFu33_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu33_S(Test_aB_BFu33_S, "aB_BFu33_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_Uc()
{
  {
    init_simple_test("aB_BFu33_Uc");
    static aB_BFu33_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu33_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_Uc");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_Uc");
    check_field_offset(lv, v3, 6, "aB_BFu33_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu33_Uc(Test_aB_BFu33_Uc, "aB_BFu33_Uc", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_Ui()
{
  {
    init_simple_test("aB_BFu33_Ui");
    static aB_BFu33_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu33_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_Ui");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_Ui");
    check_field_offset(lv, v3, 6, "aB_BFu33_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu33_Ui(Test_aB_BFu33_Ui, "aB_BFu33_Ui", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_Ul()
{
  {
    init_simple_test("aB_BFu33_Ul");
    static aB_BFu33_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aB_BFu33_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_Ul");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_Ul");
    check_field_offset(lv, v3, 6, "aB_BFu33_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu33_Ul(Test_aB_BFu33_Ul, "aB_BFu33_Ul", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_Us()
{
  {
    init_simple_test("aB_BFu33_Us");
    static aB_BFu33_Us lv;
    check2(sizeof(lv), 8, "sizeof(aB_BFu33_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu33_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_Us");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_Us");
    check_field_offset(lv, v3, 6, "aB_BFu33_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu33_Us(Test_aB_BFu33_Us, "aB_BFu33_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu33_Vp()
{
  {
    init_simple_test("aB_BFu33_Vp");
    static aB_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aB_BFu33_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aB_BFu33_Vp");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aB_BFu33_Vp");
    check_field_offset(lv, v3, 6, "aB_BFu33_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu33_Vp(Test_aB_BFu33_Vp, "aB_BFu33_Vp", ABISELECT(14,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c()
{
  {
    init_simple_test("aB_BFu7c");
    static aB_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu7c(Test_aB_BFu7c, "aB_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_B()
{
  {
    init_simple_test("aB_BFu7c_B");
    static aB_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_B)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_B");
    check_field_offset(lv, v3, 2, "aB_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_B(Test_aB_BFu7c_B, "aB_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu15i()
{
  {
    init_simple_test("aB_BFu7c_BFu15i");
    static aB_BFu7c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aB_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aB_BFu7c_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu15i(Test_aB_BFu7c_BFu15i, "aB_BFu7c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu15ll()
{
  {
    init_simple_test("aB_BFu7c_BFu15ll");
    static aB_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aB_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aB_BFu7c_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu15ll(Test_aB_BFu7c_BFu15ll, "aB_BFu7c_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu15s()
{
  {
    init_simple_test("aB_BFu7c_BFu15s");
    static aB_BFu7c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aB_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aB_BFu7c_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu15s(Test_aB_BFu7c_BFu15s, "aB_BFu7c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu16i()
{
  {
    init_simple_test("aB_BFu7c_BFu16i");
    static aB_BFu7c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aB_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aB_BFu7c_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu16i(Test_aB_BFu7c_BFu16i, "aB_BFu7c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu16ll()
{
  {
    init_simple_test("aB_BFu7c_BFu16ll");
    static aB_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aB_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aB_BFu7c_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu16ll(Test_aB_BFu7c_BFu16ll, "aB_BFu7c_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu16s()
{
  {
    init_simple_test("aB_BFu7c_BFu16s");
    static aB_BFu7c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aB_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aB_BFu7c_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu16s(Test_aB_BFu7c_BFu16s, "aB_BFu7c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu17i()
{
  {
    init_simple_test("aB_BFu7c_BFu17i");
    static aB_BFu7c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aB_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aB_BFu7c_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu17i(Test_aB_BFu7c_BFu17i, "aB_BFu7c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu17ll()
{
  {
    init_simple_test("aB_BFu7c_BFu17ll");
    static aB_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aB_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aB_BFu7c_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu17ll(Test_aB_BFu7c_BFu17ll, "aB_BFu7c_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu1c()
{
  {
    init_simple_test("aB_BFu7c_BFu1c");
    static aB_BFu7c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7c_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu1c(Test_aB_BFu7c_BFu1c, "aB_BFu7c_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu1i()
{
  {
    init_simple_test("aB_BFu7c_BFu1i");
    static aB_BFu7c_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7c_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu1i(Test_aB_BFu7c_BFu1i, "aB_BFu7c_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu1ll()
{
  {
    init_simple_test("aB_BFu7c_BFu1ll");
    static aB_BFu7c_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7c_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu1ll(Test_aB_BFu7c_BFu1ll, "aB_BFu7c_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu1s()
{
  {
    init_simple_test("aB_BFu7c_BFu1s");
    static aB_BFu7c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7c_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu1s(Test_aB_BFu7c_BFu1s, "aB_BFu7c_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu31i()
{
  {
    init_simple_test("aB_BFu7c_BFu31i");
    static aB_BFu7c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aB_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aB_BFu7c_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu31i(Test_aB_BFu7c_BFu31i, "aB_BFu7c_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu31ll()
{
  {
    init_simple_test("aB_BFu7c_BFu31ll");
    static aB_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aB_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aB_BFu7c_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu31ll(Test_aB_BFu7c_BFu31ll, "aB_BFu7c_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu32i()
{
  {
    init_simple_test("aB_BFu7c_BFu32i");
    static aB_BFu7c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aB_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aB_BFu7c_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu32i(Test_aB_BFu7c_BFu32i, "aB_BFu7c_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu32ll()
{
  {
    init_simple_test("aB_BFu7c_BFu32ll");
    static aB_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aB_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aB_BFu7c_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu32ll(Test_aB_BFu7c_BFu32ll, "aB_BFu7c_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu33()
{
  {
    init_simple_test("aB_BFu7c_BFu33");
    static aB_BFu7c_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "aB_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "aB_BFu7c_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu33(Test_aB_BFu7c_BFu33, "aB_BFu7c_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu7c()
{
  {
    init_simple_test("aB_BFu7c_BFu7c");
    static aB_BFu7c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu7c(Test_aB_BFu7c_BFu7c, "aB_BFu7c_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu7i()
{
  {
    init_simple_test("aB_BFu7c_BFu7i");
    static aB_BFu7c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu7i(Test_aB_BFu7c_BFu7i, "aB_BFu7c_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu7ll()
{
  {
    init_simple_test("aB_BFu7c_BFu7ll");
    static aB_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu7ll(Test_aB_BFu7c_BFu7ll, "aB_BFu7c_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu7s()
{
  {
    init_simple_test("aB_BFu7c_BFu7s");
    static aB_BFu7c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu7s(Test_aB_BFu7c_BFu7s, "aB_BFu7c_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu8c()
{
  {
    init_simple_test("aB_BFu7c_BFu8c");
    static aB_BFu7c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7c_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu8c(Test_aB_BFu7c_BFu8c, "aB_BFu7c_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu8i()
{
  {
    init_simple_test("aB_BFu7c_BFu8i");
    static aB_BFu7c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7c_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu8i(Test_aB_BFu7c_BFu8i, "aB_BFu7c_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu8ll()
{
  {
    init_simple_test("aB_BFu7c_BFu8ll");
    static aB_BFu7c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7c_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu8ll(Test_aB_BFu7c_BFu8ll, "aB_BFu7c_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu8s()
{
  {
    init_simple_test("aB_BFu7c_BFu8s");
    static aB_BFu7c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7c_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu8s(Test_aB_BFu7c_BFu8s, "aB_BFu7c_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu9i()
{
  {
    init_simple_test("aB_BFu7c_BFu9i");
    static aB_BFu7c_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aB_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aB_BFu7c_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu9i(Test_aB_BFu7c_BFu9i, "aB_BFu7c_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu9ll()
{
  {
    init_simple_test("aB_BFu7c_BFu9ll");
    static aB_BFu7c_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aB_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aB_BFu7c_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu9ll(Test_aB_BFu7c_BFu9ll, "aB_BFu7c_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_BFu9s()
{
  {
    init_simple_test("aB_BFu7c_BFu9s");
    static aB_BFu7c_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aB_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aB_BFu7c_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_BFu9s(Test_aB_BFu7c_BFu9s, "aB_BFu7c_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_C()
{
  {
    init_simple_test("aB_BFu7c_C");
    static aB_BFu7c_C lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_C)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_C");
    check_field_offset(lv, v3, 2, "aB_BFu7c_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_C(Test_aB_BFu7c_C, "aB_BFu7c_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_D()
{
  {
    init_simple_test("aB_BFu7c_D");
    static aB_BFu7c_D lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu7c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_D)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_D");
    check_field_offset(lv, v3, 2, "aB_BFu7c_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_D(Test_aB_BFu7c_D, "aB_BFu7c_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_F()
{
  {
    init_simple_test("aB_BFu7c_F");
    static aB_BFu7c_F lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_F)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_F");
    check_field_offset(lv, v3, 2, "aB_BFu7c_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_F(Test_aB_BFu7c_F, "aB_BFu7c_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_I()
{
  {
    init_simple_test("aB_BFu7c_I");
    static aB_BFu7c_I lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_I)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_I");
    check_field_offset(lv, v3, 2, "aB_BFu7c_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_I(Test_aB_BFu7c_I, "aB_BFu7c_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_Ip()
{
  {
    init_simple_test("aB_BFu7c_Ip");
    static aB_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu7c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_Ip");
    check_field_offset(lv, v3, 2, "aB_BFu7c_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_Ip(Test_aB_BFu7c_Ip, "aB_BFu7c_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_L()
{
  {
    init_simple_test("aB_BFu7c_L");
    static aB_BFu7c_L lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_L)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_L");
    check_field_offset(lv, v3, 2, "aB_BFu7c_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_L(Test_aB_BFu7c_L, "aB_BFu7c_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_S()
{
  {
    init_simple_test("aB_BFu7c_S");
    static aB_BFu7c_S lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_S)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_S");
    check_field_offset(lv, v3, 2, "aB_BFu7c_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_S(Test_aB_BFu7c_S, "aB_BFu7c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_Uc()
{
  {
    init_simple_test("aB_BFu7c_Uc");
    static aB_BFu7c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_Uc");
    check_field_offset(lv, v3, 2, "aB_BFu7c_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_Uc(Test_aB_BFu7c_Uc, "aB_BFu7c_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_Ui()
{
  {
    init_simple_test("aB_BFu7c_Ui");
    static aB_BFu7c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_Ui");
    check_field_offset(lv, v3, 2, "aB_BFu7c_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_Ui(Test_aB_BFu7c_Ui, "aB_BFu7c_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_Ul()
{
  {
    init_simple_test("aB_BFu7c_Ul");
    static aB_BFu7c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_Ul");
    check_field_offset(lv, v3, 2, "aB_BFu7c_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_Ul(Test_aB_BFu7c_Ul, "aB_BFu7c_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_Us()
{
  {
    init_simple_test("aB_BFu7c_Us");
    static aB_BFu7c_Us lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_Us");
    check_field_offset(lv, v3, 2, "aB_BFu7c_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_Us(Test_aB_BFu7c_Us, "aB_BFu7c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7c_Vp()
{
  {
    init_simple_test("aB_BFu7c_Vp");
    static aB_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7c_Vp");
    check_field_offset(lv, v3, 2, "aB_BFu7c_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7c_Vp(Test_aB_BFu7c_Vp, "aB_BFu7c_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i()
{
  {
    init_simple_test("aB_BFu7i");
    static aB_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu7i(Test_aB_BFu7i, "aB_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_B()
{
  {
    init_simple_test("aB_BFu7i_B");
    static aB_BFu7i_B lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_B)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_B");
    check_field_offset(lv, v3, 2, "aB_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_B(Test_aB_BFu7i_B, "aB_BFu7i_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu15i()
{
  {
    init_simple_test("aB_BFu7i_BFu15i");
    static aB_BFu7i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aB_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aB_BFu7i_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu15i(Test_aB_BFu7i_BFu15i, "aB_BFu7i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu15ll()
{
  {
    init_simple_test("aB_BFu7i_BFu15ll");
    static aB_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aB_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aB_BFu7i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu15ll(Test_aB_BFu7i_BFu15ll, "aB_BFu7i_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu15s()
{
  {
    init_simple_test("aB_BFu7i_BFu15s");
    static aB_BFu7i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aB_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aB_BFu7i_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu15s(Test_aB_BFu7i_BFu15s, "aB_BFu7i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu16i()
{
  {
    init_simple_test("aB_BFu7i_BFu16i");
    static aB_BFu7i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aB_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aB_BFu7i_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu16i(Test_aB_BFu7i_BFu16i, "aB_BFu7i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu16ll()
{
  {
    init_simple_test("aB_BFu7i_BFu16ll");
    static aB_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aB_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aB_BFu7i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu16ll(Test_aB_BFu7i_BFu16ll, "aB_BFu7i_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu16s()
{
  {
    init_simple_test("aB_BFu7i_BFu16s");
    static aB_BFu7i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aB_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aB_BFu7i_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu16s(Test_aB_BFu7i_BFu16s, "aB_BFu7i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu17i()
{
  {
    init_simple_test("aB_BFu7i_BFu17i");
    static aB_BFu7i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aB_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aB_BFu7i_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu17i(Test_aB_BFu7i_BFu17i, "aB_BFu7i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu17ll()
{
  {
    init_simple_test("aB_BFu7i_BFu17ll");
    static aB_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aB_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aB_BFu7i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu17ll(Test_aB_BFu7i_BFu17ll, "aB_BFu7i_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu1c()
{
  {
    init_simple_test("aB_BFu7i_BFu1c");
    static aB_BFu7i_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7i_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu1c(Test_aB_BFu7i_BFu1c, "aB_BFu7i_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu1i()
{
  {
    init_simple_test("aB_BFu7i_BFu1i");
    static aB_BFu7i_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7i_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu1i(Test_aB_BFu7i_BFu1i, "aB_BFu7i_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu1ll()
{
  {
    init_simple_test("aB_BFu7i_BFu1ll");
    static aB_BFu7i_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu1ll(Test_aB_BFu7i_BFu1ll, "aB_BFu7i_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu1s()
{
  {
    init_simple_test("aB_BFu7i_BFu1s");
    static aB_BFu7i_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7i_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu1s(Test_aB_BFu7i_BFu1s, "aB_BFu7i_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu31i()
{
  {
    init_simple_test("aB_BFu7i_BFu31i");
    static aB_BFu7i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aB_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aB_BFu7i_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu31i(Test_aB_BFu7i_BFu31i, "aB_BFu7i_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu31ll()
{
  {
    init_simple_test("aB_BFu7i_BFu31ll");
    static aB_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aB_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aB_BFu7i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu31ll(Test_aB_BFu7i_BFu31ll, "aB_BFu7i_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu32i()
{
  {
    init_simple_test("aB_BFu7i_BFu32i");
    static aB_BFu7i_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aB_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aB_BFu7i_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu32i(Test_aB_BFu7i_BFu32i, "aB_BFu7i_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu32ll()
{
  {
    init_simple_test("aB_BFu7i_BFu32ll");
    static aB_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aB_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aB_BFu7i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu32ll(Test_aB_BFu7i_BFu32ll, "aB_BFu7i_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu33()
{
  {
    init_simple_test("aB_BFu7i_BFu33");
    static aB_BFu7i_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "aB_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "aB_BFu7i_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu33(Test_aB_BFu7i_BFu33, "aB_BFu7i_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu7c()
{
  {
    init_simple_test("aB_BFu7i_BFu7c");
    static aB_BFu7i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu7c(Test_aB_BFu7i_BFu7c, "aB_BFu7i_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu7i()
{
  {
    init_simple_test("aB_BFu7i_BFu7i");
    static aB_BFu7i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu7i(Test_aB_BFu7i_BFu7i, "aB_BFu7i_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu7ll()
{
  {
    init_simple_test("aB_BFu7i_BFu7ll");
    static aB_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu7ll(Test_aB_BFu7i_BFu7ll, "aB_BFu7i_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu7s()
{
  {
    init_simple_test("aB_BFu7i_BFu7s");
    static aB_BFu7i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu7s(Test_aB_BFu7i_BFu7s, "aB_BFu7i_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu8c()
{
  {
    init_simple_test("aB_BFu7i_BFu8c");
    static aB_BFu7i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7i_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu8c(Test_aB_BFu7i_BFu8c, "aB_BFu7i_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu8i()
{
  {
    init_simple_test("aB_BFu7i_BFu8i");
    static aB_BFu7i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7i_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu8i(Test_aB_BFu7i_BFu8i, "aB_BFu7i_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu8ll()
{
  {
    init_simple_test("aB_BFu7i_BFu8ll");
    static aB_BFu7i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu8ll(Test_aB_BFu7i_BFu8ll, "aB_BFu7i_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu8s()
{
  {
    init_simple_test("aB_BFu7i_BFu8s");
    static aB_BFu7i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7i_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu8s(Test_aB_BFu7i_BFu8s, "aB_BFu7i_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu9i()
{
  {
    init_simple_test("aB_BFu7i_BFu9i");
    static aB_BFu7i_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aB_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aB_BFu7i_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu9i(Test_aB_BFu7i_BFu9i, "aB_BFu7i_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu9ll()
{
  {
    init_simple_test("aB_BFu7i_BFu9ll");
    static aB_BFu7i_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aB_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aB_BFu7i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu9ll(Test_aB_BFu7i_BFu9ll, "aB_BFu7i_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_BFu9s()
{
  {
    init_simple_test("aB_BFu7i_BFu9s");
    static aB_BFu7i_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aB_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aB_BFu7i_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_BFu9s(Test_aB_BFu7i_BFu9s, "aB_BFu7i_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_C()
{
  {
    init_simple_test("aB_BFu7i_C");
    static aB_BFu7i_C lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_C)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_C");
    check_field_offset(lv, v3, 2, "aB_BFu7i_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_C(Test_aB_BFu7i_C, "aB_BFu7i_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_D()
{
  {
    init_simple_test("aB_BFu7i_D");
    static aB_BFu7i_D lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_D)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_D");
    check_field_offset(lv, v3, 2, "aB_BFu7i_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_D(Test_aB_BFu7i_D, "aB_BFu7i_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_F()
{
  {
    init_simple_test("aB_BFu7i_F");
    static aB_BFu7i_F lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_F)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_F");
    check_field_offset(lv, v3, 2, "aB_BFu7i_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_F(Test_aB_BFu7i_F, "aB_BFu7i_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_I()
{
  {
    init_simple_test("aB_BFu7i_I");
    static aB_BFu7i_I lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_I)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_I");
    check_field_offset(lv, v3, 2, "aB_BFu7i_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_I(Test_aB_BFu7i_I, "aB_BFu7i_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_Ip()
{
  {
    init_simple_test("aB_BFu7i_Ip");
    static aB_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_Ip");
    check_field_offset(lv, v3, 2, "aB_BFu7i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_Ip(Test_aB_BFu7i_Ip, "aB_BFu7i_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_L()
{
  {
    init_simple_test("aB_BFu7i_L");
    static aB_BFu7i_L lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_L)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_L");
    check_field_offset(lv, v3, 2, "aB_BFu7i_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_L(Test_aB_BFu7i_L, "aB_BFu7i_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_S()
{
  {
    init_simple_test("aB_BFu7i_S");
    static aB_BFu7i_S lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_S)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_S");
    check_field_offset(lv, v3, 2, "aB_BFu7i_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_S(Test_aB_BFu7i_S, "aB_BFu7i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_Uc()
{
  {
    init_simple_test("aB_BFu7i_Uc");
    static aB_BFu7i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_Uc");
    check_field_offset(lv, v3, 2, "aB_BFu7i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_Uc(Test_aB_BFu7i_Uc, "aB_BFu7i_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_Ui()
{
  {
    init_simple_test("aB_BFu7i_Ui");
    static aB_BFu7i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_Ui");
    check_field_offset(lv, v3, 2, "aB_BFu7i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_Ui(Test_aB_BFu7i_Ui, "aB_BFu7i_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_Ul()
{
  {
    init_simple_test("aB_BFu7i_Ul");
    static aB_BFu7i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_Ul");
    check_field_offset(lv, v3, 2, "aB_BFu7i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_Ul(Test_aB_BFu7i_Ul, "aB_BFu7i_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_Us()
{
  {
    init_simple_test("aB_BFu7i_Us");
    static aB_BFu7i_Us lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_Us");
    check_field_offset(lv, v3, 2, "aB_BFu7i_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_Us(Test_aB_BFu7i_Us, "aB_BFu7i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7i_Vp()
{
  {
    init_simple_test("aB_BFu7i_Vp");
    static aB_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7i_Vp");
    check_field_offset(lv, v3, 2, "aB_BFu7i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7i_Vp(Test_aB_BFu7i_Vp, "aB_BFu7i_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll()
{
  {
    init_simple_test("aB_BFu7ll");
    static aB_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll(Test_aB_BFu7ll, "aB_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_B()
{
  {
    init_simple_test("aB_BFu7ll_B");
    static aB_BFu7ll_B lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_B)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_B");
    check_field_offset(lv, v3, 2, "aB_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_B(Test_aB_BFu7ll_B, "aB_BFu7ll_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu15i()
{
  {
    init_simple_test("aB_BFu7ll_BFu15i");
    static aB_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aB_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aB_BFu7ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu15i(Test_aB_BFu7ll_BFu15i, "aB_BFu7ll_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu15ll()
{
  {
    init_simple_test("aB_BFu7ll_BFu15ll");
    static aB_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aB_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aB_BFu7ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu15ll(Test_aB_BFu7ll_BFu15ll, "aB_BFu7ll_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu15s()
{
  {
    init_simple_test("aB_BFu7ll_BFu15s");
    static aB_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aB_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aB_BFu7ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu15s(Test_aB_BFu7ll_BFu15s, "aB_BFu7ll_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu16i()
{
  {
    init_simple_test("aB_BFu7ll_BFu16i");
    static aB_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aB_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aB_BFu7ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu16i(Test_aB_BFu7ll_BFu16i, "aB_BFu7ll_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu16ll()
{
  {
    init_simple_test("aB_BFu7ll_BFu16ll");
    static aB_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aB_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aB_BFu7ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu16ll(Test_aB_BFu7ll_BFu16ll, "aB_BFu7ll_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu16s()
{
  {
    init_simple_test("aB_BFu7ll_BFu16s");
    static aB_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aB_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aB_BFu7ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu16s(Test_aB_BFu7ll_BFu16s, "aB_BFu7ll_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu17i()
{
  {
    init_simple_test("aB_BFu7ll_BFu17i");
    static aB_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aB_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aB_BFu7ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu17i(Test_aB_BFu7ll_BFu17i, "aB_BFu7ll_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu17ll()
{
  {
    init_simple_test("aB_BFu7ll_BFu17ll");
    static aB_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aB_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aB_BFu7ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu17ll(Test_aB_BFu7ll_BFu17ll, "aB_BFu7ll_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu1c()
{
  {
    init_simple_test("aB_BFu7ll_BFu1c");
    static aB_BFu7ll_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu1c(Test_aB_BFu7ll_BFu1c, "aB_BFu7ll_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu1i()
{
  {
    init_simple_test("aB_BFu7ll_BFu1i");
    static aB_BFu7ll_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu1i(Test_aB_BFu7ll_BFu1i, "aB_BFu7ll_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu1ll()
{
  {
    init_simple_test("aB_BFu7ll_BFu1ll");
    static aB_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu1ll(Test_aB_BFu7ll_BFu1ll, "aB_BFu7ll_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu1s()
{
  {
    init_simple_test("aB_BFu7ll_BFu1s");
    static aB_BFu7ll_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu1s(Test_aB_BFu7ll_BFu1s, "aB_BFu7ll_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu31i()
{
  {
    init_simple_test("aB_BFu7ll_BFu31i");
    static aB_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aB_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aB_BFu7ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu31i(Test_aB_BFu7ll_BFu31i, "aB_BFu7ll_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu31ll()
{
  {
    init_simple_test("aB_BFu7ll_BFu31ll");
    static aB_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aB_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aB_BFu7ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu31ll(Test_aB_BFu7ll_BFu31ll, "aB_BFu7ll_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu32i()
{
  {
    init_simple_test("aB_BFu7ll_BFu32i");
    static aB_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aB_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aB_BFu7ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu32i(Test_aB_BFu7ll_BFu32i, "aB_BFu7ll_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu32ll()
{
  {
    init_simple_test("aB_BFu7ll_BFu32ll");
    static aB_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aB_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aB_BFu7ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu32ll(Test_aB_BFu7ll_BFu32ll, "aB_BFu7ll_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu33()
{
  {
    init_simple_test("aB_BFu7ll_BFu33");
    static aB_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "aB_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "aB_BFu7ll_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu33(Test_aB_BFu7ll_BFu33, "aB_BFu7ll_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu7c()
{
  {
    init_simple_test("aB_BFu7ll_BFu7c");
    static aB_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu7c(Test_aB_BFu7ll_BFu7c, "aB_BFu7ll_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu7i()
{
  {
    init_simple_test("aB_BFu7ll_BFu7i");
    static aB_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu7i(Test_aB_BFu7ll_BFu7i, "aB_BFu7ll_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu7ll()
{
  {
    init_simple_test("aB_BFu7ll_BFu7ll");
    static aB_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu7ll(Test_aB_BFu7ll_BFu7ll, "aB_BFu7ll_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu7s()
{
  {
    init_simple_test("aB_BFu7ll_BFu7s");
    static aB_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu7s(Test_aB_BFu7ll_BFu7s, "aB_BFu7ll_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu8c()
{
  {
    init_simple_test("aB_BFu7ll_BFu8c");
    static aB_BFu7ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu8c(Test_aB_BFu7ll_BFu8c, "aB_BFu7ll_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu8i()
{
  {
    init_simple_test("aB_BFu7ll_BFu8i");
    static aB_BFu7ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu8i(Test_aB_BFu7ll_BFu8i, "aB_BFu7ll_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu8ll()
{
  {
    init_simple_test("aB_BFu7ll_BFu8ll");
    static aB_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu8ll(Test_aB_BFu7ll_BFu8ll, "aB_BFu7ll_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu8s()
{
  {
    init_simple_test("aB_BFu7ll_BFu8s");
    static aB_BFu7ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu8s(Test_aB_BFu7ll_BFu8s, "aB_BFu7ll_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu9i()
{
  {
    init_simple_test("aB_BFu7ll_BFu9i");
    static aB_BFu7ll_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aB_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aB_BFu7ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu9i(Test_aB_BFu7ll_BFu9i, "aB_BFu7ll_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu9ll()
{
  {
    init_simple_test("aB_BFu7ll_BFu9ll");
    static aB_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aB_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aB_BFu7ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu9ll(Test_aB_BFu7ll_BFu9ll, "aB_BFu7ll_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_BFu9s()
{
  {
    init_simple_test("aB_BFu7ll_BFu9s");
    static aB_BFu7ll_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aB_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aB_BFu7ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_BFu9s(Test_aB_BFu7ll_BFu9s, "aB_BFu7ll_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_C()
{
  {
    init_simple_test("aB_BFu7ll_C");
    static aB_BFu7ll_C lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_C");
    check_field_offset(lv, v3, 2, "aB_BFu7ll_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_C(Test_aB_BFu7ll_C, "aB_BFu7ll_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_D()
{
  {
    init_simple_test("aB_BFu7ll_D");
    static aB_BFu7ll_D lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_D");
    check_field_offset(lv, v3, 2, "aB_BFu7ll_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_D(Test_aB_BFu7ll_D, "aB_BFu7ll_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_F()
{
  {
    init_simple_test("aB_BFu7ll_F");
    static aB_BFu7ll_F lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_F");
    check_field_offset(lv, v3, 2, "aB_BFu7ll_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_F(Test_aB_BFu7ll_F, "aB_BFu7ll_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_I()
{
  {
    init_simple_test("aB_BFu7ll_I");
    static aB_BFu7ll_I lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_I");
    check_field_offset(lv, v3, 2, "aB_BFu7ll_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_I(Test_aB_BFu7ll_I, "aB_BFu7ll_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_Ip()
{
  {
    init_simple_test("aB_BFu7ll_Ip");
    static aB_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_Ip");
    check_field_offset(lv, v3, 2, "aB_BFu7ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_Ip(Test_aB_BFu7ll_Ip, "aB_BFu7ll_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_L()
{
  {
    init_simple_test("aB_BFu7ll_L");
    static aB_BFu7ll_L lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_L");
    check_field_offset(lv, v3, 2, "aB_BFu7ll_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_L(Test_aB_BFu7ll_L, "aB_BFu7ll_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_S()
{
  {
    init_simple_test("aB_BFu7ll_S");
    static aB_BFu7ll_S lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_S");
    check_field_offset(lv, v3, 2, "aB_BFu7ll_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_S(Test_aB_BFu7ll_S, "aB_BFu7ll_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_Uc()
{
  {
    init_simple_test("aB_BFu7ll_Uc");
    static aB_BFu7ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_Uc");
    check_field_offset(lv, v3, 2, "aB_BFu7ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_Uc(Test_aB_BFu7ll_Uc, "aB_BFu7ll_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_Ui()
{
  {
    init_simple_test("aB_BFu7ll_Ui");
    static aB_BFu7ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_Ui");
    check_field_offset(lv, v3, 2, "aB_BFu7ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_Ui(Test_aB_BFu7ll_Ui, "aB_BFu7ll_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_Ul()
{
  {
    init_simple_test("aB_BFu7ll_Ul");
    static aB_BFu7ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_Ul");
    check_field_offset(lv, v3, 2, "aB_BFu7ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_Ul(Test_aB_BFu7ll_Ul, "aB_BFu7ll_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_Us()
{
  {
    init_simple_test("aB_BFu7ll_Us");
    static aB_BFu7ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_Us");
    check_field_offset(lv, v3, 2, "aB_BFu7ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_Us(Test_aB_BFu7ll_Us, "aB_BFu7ll_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7ll_Vp()
{
  {
    init_simple_test("aB_BFu7ll_Vp");
    static aB_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7ll_Vp");
    check_field_offset(lv, v3, 2, "aB_BFu7ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7ll_Vp(Test_aB_BFu7ll_Vp, "aB_BFu7ll_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s()
{
  {
    init_simple_test("aB_BFu7s");
    static aB_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu7s(Test_aB_BFu7s, "aB_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_B()
{
  {
    init_simple_test("aB_BFu7s_B");
    static aB_BFu7s_B lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_B)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_B");
    check_field_offset(lv, v3, 2, "aB_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_B(Test_aB_BFu7s_B, "aB_BFu7s_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu15i()
{
  {
    init_simple_test("aB_BFu7s_BFu15i");
    static aB_BFu7s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aB_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aB_BFu7s_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu15i(Test_aB_BFu7s_BFu15i, "aB_BFu7s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu15ll()
{
  {
    init_simple_test("aB_BFu7s_BFu15ll");
    static aB_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aB_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aB_BFu7s_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu15ll(Test_aB_BFu7s_BFu15ll, "aB_BFu7s_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu15s()
{
  {
    init_simple_test("aB_BFu7s_BFu15s");
    static aB_BFu7s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aB_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aB_BFu7s_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu15s(Test_aB_BFu7s_BFu15s, "aB_BFu7s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu16i()
{
  {
    init_simple_test("aB_BFu7s_BFu16i");
    static aB_BFu7s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aB_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aB_BFu7s_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu16i(Test_aB_BFu7s_BFu16i, "aB_BFu7s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu16ll()
{
  {
    init_simple_test("aB_BFu7s_BFu16ll");
    static aB_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aB_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aB_BFu7s_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu16ll(Test_aB_BFu7s_BFu16ll, "aB_BFu7s_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu16s()
{
  {
    init_simple_test("aB_BFu7s_BFu16s");
    static aB_BFu7s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aB_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aB_BFu7s_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu16s(Test_aB_BFu7s_BFu16s, "aB_BFu7s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu17i()
{
  {
    init_simple_test("aB_BFu7s_BFu17i");
    static aB_BFu7s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aB_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aB_BFu7s_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu17i(Test_aB_BFu7s_BFu17i, "aB_BFu7s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu17ll()
{
  {
    init_simple_test("aB_BFu7s_BFu17ll");
    static aB_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aB_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aB_BFu7s_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu17ll(Test_aB_BFu7s_BFu17ll, "aB_BFu7s_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu1c()
{
  {
    init_simple_test("aB_BFu7s_BFu1c");
    static aB_BFu7s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7s_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu1c(Test_aB_BFu7s_BFu1c, "aB_BFu7s_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu1i()
{
  {
    init_simple_test("aB_BFu7s_BFu1i");
    static aB_BFu7s_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7s_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu1i(Test_aB_BFu7s_BFu1i, "aB_BFu7s_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu1ll()
{
  {
    init_simple_test("aB_BFu7s_BFu1ll");
    static aB_BFu7s_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7s_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu1ll(Test_aB_BFu7s_BFu1ll, "aB_BFu7s_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu1s()
{
  {
    init_simple_test("aB_BFu7s_BFu1s");
    static aB_BFu7s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aB_BFu7s_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu1s(Test_aB_BFu7s_BFu1s, "aB_BFu7s_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu31i()
{
  {
    init_simple_test("aB_BFu7s_BFu31i");
    static aB_BFu7s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aB_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aB_BFu7s_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu31i(Test_aB_BFu7s_BFu31i, "aB_BFu7s_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu31ll()
{
  {
    init_simple_test("aB_BFu7s_BFu31ll");
    static aB_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aB_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aB_BFu7s_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu31ll(Test_aB_BFu7s_BFu31ll, "aB_BFu7s_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu32i()
{
  {
    init_simple_test("aB_BFu7s_BFu32i");
    static aB_BFu7s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aB_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aB_BFu7s_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu32i(Test_aB_BFu7s_BFu32i, "aB_BFu7s_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu32ll()
{
  {
    init_simple_test("aB_BFu7s_BFu32ll");
    static aB_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aB_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aB_BFu7s_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu32ll(Test_aB_BFu7s_BFu32ll, "aB_BFu7s_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu33()
{
  {
    init_simple_test("aB_BFu7s_BFu33");
    static aB_BFu7s_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "aB_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "aB_BFu7s_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu33(Test_aB_BFu7s_BFu33, "aB_BFu7s_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu7c()
{
  {
    init_simple_test("aB_BFu7s_BFu7c");
    static aB_BFu7s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu7c(Test_aB_BFu7s_BFu7c, "aB_BFu7s_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu7i()
{
  {
    init_simple_test("aB_BFu7s_BFu7i");
    static aB_BFu7s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu7i(Test_aB_BFu7s_BFu7i, "aB_BFu7s_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu7ll()
{
  {
    init_simple_test("aB_BFu7s_BFu7ll");
    static aB_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu7ll(Test_aB_BFu7s_BFu7ll, "aB_BFu7s_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu7s()
{
  {
    init_simple_test("aB_BFu7s_BFu7s");
    static aB_BFu7s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aB_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu7s(Test_aB_BFu7s_BFu7s, "aB_BFu7s_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu8c()
{
  {
    init_simple_test("aB_BFu7s_BFu8c");
    static aB_BFu7s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7s_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu8c(Test_aB_BFu7s_BFu8c, "aB_BFu7s_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu8i()
{
  {
    init_simple_test("aB_BFu7s_BFu8i");
    static aB_BFu7s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7s_BFu8i");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu8i(Test_aB_BFu7s_BFu8i, "aB_BFu7s_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu8ll()
{
  {
    init_simple_test("aB_BFu7s_BFu8ll");
    static aB_BFu7s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7s_BFu8ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu8ll(Test_aB_BFu7s_BFu8ll, "aB_BFu7s_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu8s()
{
  {
    init_simple_test("aB_BFu7s_BFu8s");
    static aB_BFu7s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aB_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aB_BFu7s_BFu8s");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu8s(Test_aB_BFu7s_BFu8s, "aB_BFu7s_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu9i()
{
  {
    init_simple_test("aB_BFu7s_BFu9i");
    static aB_BFu7s_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aB_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aB_BFu7s_BFu9i");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu9i(Test_aB_BFu7s_BFu9i, "aB_BFu7s_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu9ll()
{
  {
    init_simple_test("aB_BFu7s_BFu9ll");
    static aB_BFu7s_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aB_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aB_BFu7s_BFu9ll");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu9ll(Test_aB_BFu7s_BFu9ll, "aB_BFu7s_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_BFu9s()
{
  {
    init_simple_test("aB_BFu7s_BFu9s");
    static aB_BFu7s_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aB_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aB_BFu7s_BFu9s");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_BFu9s(Test_aB_BFu7s_BFu9s, "aB_BFu7s_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_C()
{
  {
    init_simple_test("aB_BFu7s_C");
    static aB_BFu7s_C lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_C)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_C");
    check_field_offset(lv, v3, 2, "aB_BFu7s_C.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_C(Test_aB_BFu7s_C, "aB_BFu7s_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_D()
{
  {
    init_simple_test("aB_BFu7s_D");
    static aB_BFu7s_D lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_D)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_D");
    check_field_offset(lv, v3, 2, "aB_BFu7s_D.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_D(Test_aB_BFu7s_D, "aB_BFu7s_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_F()
{
  {
    init_simple_test("aB_BFu7s_F");
    static aB_BFu7s_F lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_F)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_F");
    check_field_offset(lv, v3, 2, "aB_BFu7s_F.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_F(Test_aB_BFu7s_F, "aB_BFu7s_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_I()
{
  {
    init_simple_test("aB_BFu7s_I");
    static aB_BFu7s_I lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_I)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_I");
    check_field_offset(lv, v3, 2, "aB_BFu7s_I.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_I(Test_aB_BFu7s_I, "aB_BFu7s_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_Ip()
{
  {
    init_simple_test("aB_BFu7s_Ip");
    static aB_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_Ip");
    check_field_offset(lv, v3, 2, "aB_BFu7s_Ip.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_Ip(Test_aB_BFu7s_Ip, "aB_BFu7s_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_L()
{
  {
    init_simple_test("aB_BFu7s_L");
    static aB_BFu7s_L lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu7s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_L)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_L");
    check_field_offset(lv, v3, 2, "aB_BFu7s_L.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_L(Test_aB_BFu7s_L, "aB_BFu7s_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_S()
{
  {
    init_simple_test("aB_BFu7s_S");
    static aB_BFu7s_S lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_S)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_S");
    check_field_offset(lv, v3, 2, "aB_BFu7s_S.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_S(Test_aB_BFu7s_S, "aB_BFu7s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_Uc()
{
  {
    init_simple_test("aB_BFu7s_Uc");
    static aB_BFu7s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu7s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_Uc");
    check_field_offset(lv, v3, 2, "aB_BFu7s_Uc.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_Uc(Test_aB_BFu7s_Uc, "aB_BFu7s_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_Ui()
{
  {
    init_simple_test("aB_BFu7s_Ui");
    static aB_BFu7s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu7s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_Ui");
    check_field_offset(lv, v3, 2, "aB_BFu7s_Ui.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_Ui(Test_aB_BFu7s_Ui, "aB_BFu7s_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_Ul()
{
  {
    init_simple_test("aB_BFu7s_Ul");
    static aB_BFu7s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aB_BFu7s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_Ul");
    check_field_offset(lv, v3, 2, "aB_BFu7s_Ul.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_Ul(Test_aB_BFu7s_Ul, "aB_BFu7s_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_Us()
{
  {
    init_simple_test("aB_BFu7s_Us");
    static aB_BFu7s_Us lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu7s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_Us");
    check_field_offset(lv, v3, 2, "aB_BFu7s_Us.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_Us(Test_aB_BFu7s_Us, "aB_BFu7s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu7s_Vp()
{
  {
    init_simple_test("aB_BFu7s_Vp");
    static aB_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aB_BFu7s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "aB_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aB_BFu7s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aB_BFu7s_Vp");
    check_field_offset(lv, v3, 2, "aB_BFu7s_Vp.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu7s_Vp(Test_aB_BFu7s_Vp, "aB_BFu7s_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c()
{
  {
    init_simple_test("aB_BFu8c");
    static aB_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aB_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu8c(Test_aB_BFu8c, "aB_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_B()
{
  {
    init_simple_test("aB_BFu8c_B");
    static aB_BFu8c_B lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_B)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_B");
    check_field_offset(lv, v3, 2, "aB_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_B(Test_aB_BFu8c_B, "aB_BFu8c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu15i()
{
  {
    init_simple_test("aB_BFu8c_BFu15i");
    static aB_BFu8c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu8c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aB_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aB_BFu8c_BFu15i");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu15i(Test_aB_BFu8c_BFu15i, "aB_BFu8c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu15ll()
{
  {
    init_simple_test("aB_BFu8c_BFu15ll");
    static aB_BFu8c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu8c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aB_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aB_BFu8c_BFu15ll");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu15ll(Test_aB_BFu8c_BFu15ll, "aB_BFu8c_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu15s()
{
  {
    init_simple_test("aB_BFu8c_BFu15s");
    static aB_BFu8c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu8c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aB_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aB_BFu8c_BFu15s");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu15s(Test_aB_BFu8c_BFu15s, "aB_BFu8c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu16i()
{
  {
    init_simple_test("aB_BFu8c_BFu16i");
    static aB_BFu8c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu8c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aB_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aB_BFu8c_BFu16i");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu16i(Test_aB_BFu8c_BFu16i, "aB_BFu8c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu16ll()
{
  {
    init_simple_test("aB_BFu8c_BFu16ll");
    static aB_BFu8c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu8c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aB_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aB_BFu8c_BFu16ll");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu16ll(Test_aB_BFu8c_BFu16ll, "aB_BFu8c_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu16s()
{
  {
    init_simple_test("aB_BFu8c_BFu16s");
    static aB_BFu8c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aB_BFu8c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aB_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aB_BFu8c_BFu16s");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu16s(Test_aB_BFu8c_BFu16s, "aB_BFu8c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu17i()
{
  {
    init_simple_test("aB_BFu8c_BFu17i");
    static aB_BFu8c_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu8c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aB_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aB_BFu8c_BFu17i");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu17i(Test_aB_BFu8c_BFu17i, "aB_BFu8c_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu17ll()
{
  {
    init_simple_test("aB_BFu8c_BFu17ll");
    static aB_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aB_BFu8c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aB_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aB_BFu8c_BFu17ll");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu17ll(Test_aB_BFu8c_BFu17ll, "aB_BFu8c_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu1c()
{
  {
    init_simple_test("aB_BFu8c_BFu1c");
    static aB_BFu8c_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aB_BFu8c_BFu1c");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu1c(Test_aB_BFu8c_BFu1c, "aB_BFu8c_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu1i()
{
  {
    init_simple_test("aB_BFu8c_BFu1i");
    static aB_BFu8c_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aB_BFu8c_BFu1i");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu1i(Test_aB_BFu8c_BFu1i, "aB_BFu8c_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu1ll()
{
  {
    init_simple_test("aB_BFu8c_BFu1ll");
    static aB_BFu8c_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aB_BFu8c_BFu1ll");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu1ll(Test_aB_BFu8c_BFu1ll, "aB_BFu8c_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu1s()
{
  {
    init_simple_test("aB_BFu8c_BFu1s");
    static aB_BFu8c_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aB_BFu8c_BFu1s");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu1s(Test_aB_BFu8c_BFu1s, "aB_BFu8c_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu31i()
{
  {
    init_simple_test("aB_BFu8c_BFu31i");
    static aB_BFu8c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aB_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aB_BFu8c_BFu31i");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu31i(Test_aB_BFu8c_BFu31i, "aB_BFu8c_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu31ll()
{
  {
    init_simple_test("aB_BFu8c_BFu31ll");
    static aB_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aB_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aB_BFu8c_BFu31ll");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu31ll(Test_aB_BFu8c_BFu31ll, "aB_BFu8c_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu32i()
{
  {
    init_simple_test("aB_BFu8c_BFu32i");
    static aB_BFu8c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aB_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aB_BFu8c_BFu32i");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu32i(Test_aB_BFu8c_BFu32i, "aB_BFu8c_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu32ll()
{
  {
    init_simple_test("aB_BFu8c_BFu32ll");
    static aB_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aB_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aB_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aB_BFu8c_BFu32ll");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu32ll(Test_aB_BFu8c_BFu32ll, "aB_BFu8c_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu33()
{
  {
    init_simple_test("aB_BFu8c_BFu33");
    static aB_BFu8c_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aB_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aB_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aB_BFu8c_BFu33");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu33(Test_aB_BFu8c_BFu33, "aB_BFu8c_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu7c()
{
  {
    init_simple_test("aB_BFu8c_BFu7c");
    static aB_BFu8c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aB_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aB_BFu8c_BFu7c");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu7c(Test_aB_BFu8c_BFu7c, "aB_BFu8c_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu7i()
{
  {
    init_simple_test("aB_BFu8c_BFu7i");
    static aB_BFu8c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aB_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aB_BFu8c_BFu7i");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu7i(Test_aB_BFu8c_BFu7i, "aB_BFu8c_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu7ll()
{
  {
    init_simple_test("aB_BFu8c_BFu7ll");
    static aB_BFu8c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aB_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aB_BFu8c_BFu7ll");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu7ll(Test_aB_BFu8c_BFu7ll, "aB_BFu8c_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu7s()
{
  {
    init_simple_test("aB_BFu8c_BFu7s");
    static aB_BFu8c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aB_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aB_BFu8c_BFu7s");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu7s(Test_aB_BFu8c_BFu7s, "aB_BFu8c_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu8c()
{
  {
    init_simple_test("aB_BFu8c_BFu8c");
    static aB_BFu8c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aB_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aB_BFu8c_BFu8c");
  }
}
static Arrange_To_Call_Me vaB_BFu8c_BFu8c(Test_aB_BFu8c_BFu8c, "aB_BFu8c_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aB_BFu8c_BFu8i()
{
  {
    init_simple_test("aB_BFu8c_BFu8i");
    static aB_BFu8c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aB_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aB_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "aB_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aB_BFu8c_BFu8i");
    set_b