// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
#pragma pack(1)
struct BFu0c_BFu7c_L { unsigned char :0; unsigned char v1:7; long long v2; };
struct BFu0c_BFu7c_S { unsigned char :0; unsigned char v1:7; short v2; };
struct BFu0c_BFu7c_Uc { unsigned char :0; unsigned char v1:7; unsigned char v2; };
struct BFu0c_BFu7c_Ui { unsigned char :0; unsigned char v1:7; unsigned int v2; };
struct BFu0c_BFu7c_Ul { unsigned char :0; unsigned char v1:7; unsigned long long v2; };
struct BFu0c_BFu7c_Us { unsigned char :0; unsigned char v1:7; unsigned short v2; };
struct BFu0c_BFu7c_Vp { unsigned char :0; unsigned char v1:7; void * v2; };
struct BFu0c_BFu7i { unsigned char :0; unsigned int v1:7; };
struct BFu0c_BFu7i_BFu0c { unsigned char :0; unsigned int v1:7; unsigned char :0; };
struct BFu0c_BFu7i_BFu0i { unsigned char :0; unsigned int v1:7; unsigned int :0; };
struct BFu0c_BFu7i_BFu0ll { unsigned char :0; unsigned int v1:7; unsigned long long :0; };
struct BFu0c_BFu7i_BFu0s { unsigned char :0; unsigned int v1:7; unsigned short :0; };
struct BFu0c_BFu7i_BFu15i { unsigned char :0; unsigned int v1:7; unsigned int v2:15; };
struct BFu0c_BFu7i_BFu15ll { unsigned char :0; unsigned int v1:7; unsigned long long v2:15; };
struct BFu0c_BFu7i_BFu15s { unsigned char :0; unsigned int v1:7; unsigned short v2:15; };
struct BFu0c_BFu7i_BFu16i { unsigned char :0; unsigned int v1:7; unsigned int v2:16; };
struct BFu0c_BFu7i_BFu16ll { unsigned char :0; unsigned int v1:7; unsigned long long v2:16; };
struct BFu0c_BFu7i_BFu16s { unsigned char :0; unsigned int v1:7; unsigned short v2:16; };
struct BFu0c_BFu7i_BFu17i { unsigned char :0; unsigned int v1:7; unsigned int v2:17; };
struct BFu0c_BFu7i_BFu17ll { unsigned char :0; unsigned int v1:7; unsigned long long v2:17; };
struct BFu0c_BFu7i_BFu1c { unsigned char :0; unsigned int v1:7; unsigned char v2:1; };
struct BFu0c_BFu7i_BFu1i { unsigned char :0; unsigned int v1:7; unsigned int v2:1; };
struct BFu0c_BFu7i_BFu1ll { unsigned char :0; unsigned int v1:7; unsigned long long v2:1; };
struct BFu0c_BFu7i_BFu1s { unsigned char :0; unsigned int v1:7; unsigned short v2:1; };
struct BFu0c_BFu7i_BFu31i { unsigned char :0; unsigned int v1:7; unsigned int v2:31; };
struct BFu0c_BFu7i_BFu31ll { unsigned char :0; unsigned int v1:7; unsigned long long v2:31; };
struct BFu0c_BFu7i_BFu32i { unsigned char :0; unsigned int v1:7; unsigned int v2:32; };
struct BFu0c_BFu7i_BFu32ll { unsigned char :0; unsigned int v1:7; unsigned long long v2:32; };
struct BFu0c_BFu7i_BFu33 { unsigned char :0; unsigned int v1:7; unsigned long long v2:33; };
struct BFu0c_BFu7i_BFu7c { unsigned char :0; unsigned int v1:7; unsigned char v2:7; };
struct BFu0c_BFu7i_BFu7i { unsigned char :0; unsigned int v1:7; unsigned int v2:7; };
struct BFu0c_BFu7i_BFu7ll { unsigned char :0; unsigned int v1:7; unsigned long long v2:7; };
struct BFu0c_BFu7i_BFu7s { unsigned char :0; unsigned int v1:7; unsigned short v2:7; };
struct BFu0c_BFu7i_BFu8c { unsigned char :0; unsigned int v1:7; unsigned char v2:8; };
struct BFu0c_BFu7i_BFu8i { unsigned char :0; unsigned int v1:7; unsigned int v2:8; };
struct BFu0c_BFu7i_BFu8ll { unsigned char :0; unsigned int v1:7; unsigned long long v2:8; };
struct BFu0c_BFu7i_BFu8s { unsigned char :0; unsigned int v1:7; unsigned short v2:8; };
struct BFu0c_BFu7i_BFu9i { unsigned char :0; unsigned int v1:7; unsigned int v2:9; };
struct BFu0c_BFu7i_BFu9ll { unsigned char :0; unsigned int v1:7; unsigned long long v2:9; };
struct BFu0c_BFu7i_BFu9s { unsigned char :0; unsigned int v1:7; unsigned short v2:9; };
struct BFu0c_BFu7i_C { unsigned char :0; unsigned int v1:7; char v2; };
struct BFu0c_BFu7i_D { unsigned char :0; unsigned int v1:7; double v2; };
struct BFu0c_BFu7i_F { unsigned char :0; unsigned int v1:7; float v2; };
struct BFu0c_BFu7i_I { unsigned char :0; unsigned int v1:7; int v2; };
struct BFu0c_BFu7i_Ip { unsigned char :0; unsigned int v1:7; int * v2; };
struct BFu0c_BFu7i_L { unsigned char :0; unsigned int v1:7; long long v2; };
struct BFu0c_BFu7i_S { unsigned char :0; unsigned int v1:7; short v2; };
struct BFu0c_BFu7i_Uc { unsigned char :0; unsigned int v1:7; unsigned char v2; };
struct BFu0c_BFu7i_Ui { unsigned char :0; unsigned int v1:7; unsigned int v2; };
struct BFu0c_BFu7i_Ul { unsigned char :0; unsigned int v1:7; unsigned long long v2; };
struct BFu0c_BFu7i_Us { unsigned char :0; unsigned int v1:7; unsigned short v2; };
struct BFu0c_BFu7i_Vp { unsigned char :0; unsigned int v1:7; void * v2; };
struct BFu0c_BFu7ll { unsigned char :0; unsigned long long v1:7; };
struct BFu0c_BFu7ll_BFu0c { unsigned char :0; unsigned long long v1:7; unsigned char :0; };
struct BFu0c_BFu7ll_BFu0i { unsigned char :0; unsigned long long v1:7; unsigned int :0; };
struct BFu0c_BFu7ll_BFu0ll { unsigned char :0; unsigned long long v1:7; unsigned long long :0; };
struct BFu0c_BFu7ll_BFu0s { unsigned char :0; unsigned long long v1:7; unsigned short :0; };
struct BFu0c_BFu7ll_BFu15i { unsigned char :0; unsigned long long v1:7; unsigned int v2:15; };
struct BFu0c_BFu7ll_BFu15ll { unsigned char :0; unsigned long long v1:7; unsigned long long v2:15; };
struct BFu0c_BFu7ll_BFu15s { unsigned char :0; unsigned long long v1:7; unsigned short v2:15; };
struct BFu0c_BFu7ll_BFu16i { unsigned char :0; unsigned long long v1:7; unsigned int v2:16; };
struct BFu0c_BFu7ll_BFu16ll { unsigned char :0; unsigned long long v1:7; unsigned long long v2:16; };
struct BFu0c_BFu7ll_BFu16s { unsigned char :0; unsigned long long v1:7; unsigned short v2:16; };
struct BFu0c_BFu7ll_BFu17i { unsigned char :0; unsigned long long v1:7; unsigned int v2:17; };
struct BFu0c_BFu7ll_BFu17ll { unsigned char :0; unsigned long long v1:7; unsigned long long v2:17; };
struct BFu0c_BFu7ll_BFu1c { unsigned char :0; unsigned long long v1:7; unsigned char v2:1; };
struct BFu0c_BFu7ll_BFu1i { unsigned char :0; unsigned long long v1:7; unsigned int v2:1; };
struct BFu0c_BFu7ll_BFu1ll { unsigned char :0; unsigned long long v1:7; unsigned long long v2:1; };
struct BFu0c_BFu7ll_BFu1s { unsigned char :0; unsigned long long v1:7; unsigned short v2:1; };
struct BFu0c_BFu7ll_BFu31i { unsigned char :0; unsigned long long v1:7; unsigned int v2:31; };
struct BFu0c_BFu7ll_BFu31ll { unsigned char :0; unsigned long long v1:7; unsigned long long v2:31; };
struct BFu0c_BFu7ll_BFu32i { unsigned char :0; unsigned long long v1:7; unsigned int v2:32; };
struct BFu0c_BFu7ll_BFu32ll { unsigned char :0; unsigned long long v1:7; unsigned long long v2:32; };
struct BFu0c_BFu7ll_BFu33 { unsigned char :0; unsigned long long v1:7; unsigned long long v2:33; };
struct BFu0c_BFu7ll_BFu7c { unsigned char :0; unsigned long long v1:7; unsigned char v2:7; };
struct BFu0c_BFu7ll_BFu7i { unsigned char :0; unsigned long long v1:7; unsigned int v2:7; };
struct BFu0c_BFu7ll_BFu7ll { unsigned char :0; unsigned long long v1:7; unsigned long long v2:7; };
struct BFu0c_BFu7ll_BFu7s { unsigned char :0; unsigned long long v1:7; unsigned short v2:7; };
struct BFu0c_BFu7ll_BFu8c { unsigned char :0; unsigned long long v1:7; unsigned char v2:8; };
struct BFu0c_BFu7ll_BFu8i { unsigned char :0; unsigned long long v1:7; unsigned int v2:8; };
struct BFu0c_BFu7ll_BFu8ll { unsigned char :0; unsigned long long v1:7; unsigned long long v2:8; };
struct BFu0c_BFu7ll_BFu8s { unsigned char :0; unsigned long long v1:7; unsigned short v2:8; };
struct BFu0c_BFu7ll_BFu9i { unsigned char :0; unsigned long long v1:7; unsigned int v2:9; };
struct BFu0c_BFu7ll_BFu9ll { unsigned char :0; unsigned long long v1:7; unsigned long long v2:9; };
struct BFu0c_BFu7ll_BFu9s { unsigned char :0; unsigned long long v1:7; unsigned short v2:9; };
struct BFu0c_BFu7ll_C { unsigned char :0; unsigned long long v1:7; char v2; };
struct BFu0c_BFu7ll_D { unsigned char :0; unsigned long long v1:7; double v2; };
struct BFu0c_BFu7ll_F { unsigned char :0; unsigned long long v1:7; float v2; };
struct BFu0c_BFu7ll_I { unsigned char :0; unsigned long long v1:7; int v2; };
struct BFu0c_BFu7ll_Ip { unsigned char :0; unsigned long long v1:7; int * v2; };
struct BFu0c_BFu7ll_L { unsigned char :0; unsigned long long v1:7; long long v2; };
struct BFu0c_BFu7ll_S { unsigned char :0; unsigned long long v1:7; short v2; };
struct BFu0c_BFu7ll_Uc { unsigned char :0; unsigned long long v1:7; unsigned char v2; };
struct BFu0c_BFu7ll_Ui { unsigned char :0; unsigned long long v1:7; unsigned int v2; };
struct BFu0c_BFu7ll_Ul { unsigned char :0; unsigned long long v1:7; unsigned long long v2; };
struct BFu0c_BFu7ll_Us { unsigned char :0; unsigned long long v1:7; unsigned short v2; };
struct BFu0c_BFu7ll_Vp { unsigned char :0; unsigned long long v1:7; void * v2; };
struct BFu0c_BFu7s { unsigned char :0; unsigned short v1:7; };
struct BFu0c_BFu7s_BFu0c { unsigned char :0; unsigned short v1:7; unsigned char :0; };
struct BFu0c_BFu7s_BFu0i { unsigned char :0; unsigned short v1:7; unsigned int :0; };
struct BFu0c_BFu7s_BFu0ll { unsigned char :0; unsigned short v1:7; unsigned long long :0; };
struct BFu0c_BFu7s_BFu0s { unsigned char :0; unsigned short v1:7; unsigned short :0; };
struct BFu0c_BFu7s_BFu15i { unsigned char :0; unsigned short v1:7; unsigned int v2:15; };
struct BFu0c_BFu7s_BFu15ll { unsigned char :0; unsigned short v1:7; unsigned long long v2:15; };
struct BFu0c_BFu7s_BFu15s { unsigned char :0; unsigned short v1:7; unsigned short v2:15; };
struct BFu0c_BFu7s_BFu16i { unsigned char :0; unsigned short v1:7; unsigned int v2:16; };
struct BFu0c_BFu7s_BFu16ll { unsigned char :0; unsigned short v1:7; unsigned long long v2:16; };
struct BFu0c_BFu7s_BFu16s { unsigned char :0; unsigned short v1:7; unsigned short v2:16; };
struct BFu0c_BFu7s_BFu17i { unsigned char :0; unsigned short v1:7; unsigned int v2:17; };
struct BFu0c_BFu7s_BFu17ll { unsigned char :0; unsigned short v1:7; unsigned long long v2:17; };
struct BFu0c_BFu7s_BFu1c { unsigned char :0; unsigned short v1:7; unsigned char v2:1; };
struct BFu0c_BFu7s_BFu1i { unsigned char :0; unsigned short v1:7; unsigned int v2:1; };
struct BFu0c_BFu7s_BFu1ll { unsigned char :0; unsigned short v1:7; unsigned long long v2:1; };
struct BFu0c_BFu7s_BFu1s { unsigned char :0; unsigned short v1:7; unsigned short v2:1; };
struct BFu0c_BFu7s_BFu31i { unsigned char :0; unsigned short v1:7; unsigned int v2:31; };
struct BFu0c_BFu7s_BFu31ll { unsigned char :0; unsigned short v1:7; unsigned long long v2:31; };
struct BFu0c_BFu7s_BFu32i { unsigned char :0; unsigned short v1:7; unsigned int v2:32; };
struct BFu0c_BFu7s_BFu32ll { unsigned char :0; unsigned short v1:7; unsigned long long v2:32; };
struct BFu0c_BFu7s_BFu33 { unsigned char :0; unsigned short v1:7; unsigned long long v2:33; };
struct BFu0c_BFu7s_BFu7c { unsigned char :0; unsigned short v1:7; unsigned char v2:7; };
struct BFu0c_BFu7s_BFu7i { unsigned char :0; unsigned short v1:7; unsigned int v2:7; };
struct BFu0c_BFu7s_BFu7ll { unsigned char :0; unsigned short v1:7; unsigned long long v2:7; };
struct BFu0c_BFu7s_BFu7s { unsigned char :0; unsigned short v1:7; unsigned short v2:7; };
struct BFu0c_BFu7s_BFu8c { unsigned char :0; unsigned short v1:7; unsigned char v2:8; };
struct BFu0c_BFu7s_BFu8i { unsigned char :0; unsigned short v1:7; unsigned int v2:8; };
struct BFu0c_BFu7s_BFu8ll { unsigned char :0; unsigned short v1:7; unsigned long long v2:8; };
struct BFu0c_BFu7s_BFu8s { unsigned char :0; unsigned short v1:7; unsigned short v2:8; };
struct BFu0c_BFu7s_BFu9i { unsigned char :0; unsigned short v1:7; unsigned int v2:9; };
struct BFu0c_BFu7s_BFu9ll { unsigned char :0; unsigned short v1:7; unsigned long long v2:9; };
struct BFu0c_BFu7s_BFu9s { unsigned char :0; unsigned short v1:7; unsigned short v2:9; };
struct BFu0c_BFu7s_C { unsigned char :0; unsigned short v1:7; char v2; };
struct BFu0c_BFu7s_D { unsigned char :0; unsigned short v1:7; double v2; };
struct BFu0c_BFu7s_F { unsigned char :0; unsigned short v1:7; float v2; };
struct BFu0c_BFu7s_I { unsigned char :0; unsigned short v1:7; int v2; };
struct BFu0c_BFu7s_Ip { unsigned char :0; unsigned short v1:7; int * v2; };
struct BFu0c_BFu7s_L { unsigned char :0; unsigned short v1:7; long long v2; };
struct BFu0c_BFu7s_S { unsigned char :0; unsigned short v1:7; short v2; };
struct BFu0c_BFu7s_Uc { unsigned char :0; unsigned short v1:7; unsigned char v2; };
struct BFu0c_BFu7s_Ui { unsigned char :0; unsigned short v1:7; unsigned int v2; };
struct BFu0c_BFu7s_Ul { unsigned char :0; unsigned short v1:7; unsigned long long v2; };
struct BFu0c_BFu7s_Us { unsigned char :0; unsigned short v1:7; unsigned short v2; };
struct BFu0c_BFu7s_Vp { unsigned char :0; unsigned short v1:7; void * v2; };
struct BFu0c_BFu8c { unsigned char :0; unsigned char v1:8; };
struct BFu0c_BFu8c_BFu0c { unsigned char :0; unsigned char v1:8; unsigned char :0; };
struct BFu0c_BFu8c_BFu0i { unsigned char :0; unsigned char v1:8; unsigned int :0; };
struct BFu0c_BFu8c_BFu0ll { unsigned char :0; unsigned char v1:8; unsigned long long :0; };
struct BFu0c_BFu8c_BFu0s { unsigned char :0; unsigned char v1:8; unsigned short :0; };
struct BFu0c_BFu8c_BFu15i { unsigned char :0; unsigned char v1:8; unsigned int v2:15; };
struct BFu0c_BFu8c_BFu15ll { unsigned char :0; unsigned char v1:8; unsigned long long v2:15; };
struct BFu0c_BFu8c_BFu15s { unsigned char :0; unsigned char v1:8; unsigned short v2:15; };
struct BFu0c_BFu8c_BFu16i { unsigned char :0; unsigned char v1:8; unsigned int v2:16; };
struct BFu0c_BFu8c_BFu16ll { unsigned char :0; unsigned char v1:8; unsigned long long v2:16; };
struct BFu0c_BFu8c_BFu16s { unsigned char :0; unsigned char v1:8; unsigned short v2:16; };
struct BFu0c_BFu8c_BFu17i { unsigned char :0; unsigned char v1:8; unsigned int v2:17; };
struct BFu0c_BFu8c_BFu17ll { unsigned char :0; unsigned char v1:8; unsigned long long v2:17; };
struct BFu0c_BFu8c_BFu1c { unsigned char :0; unsigned char v1:8; unsigned char v2:1; };
struct BFu0c_BFu8c_BFu1i { unsigned char :0; unsigned char v1:8; unsigned int v2:1; };
struct BFu0c_BFu8c_BFu1ll { unsigned char :0; unsigned char v1:8; unsigned long long v2:1; };
struct BFu0c_BFu8c_BFu1s { unsigned char :0; unsigned char v1:8; unsigned short v2:1; };
struct BFu0c_BFu8c_BFu31i { unsigned char :0; unsigned char v1:8; unsigned int v2:31; };
struct BFu0c_BFu8c_BFu31ll { unsigned char :0; unsigned char v1:8; unsigned long long v2:31; };
struct BFu0c_BFu8c_BFu32i { unsigned char :0; unsigned char v1:8; unsigned int v2:32; };
struct BFu0c_BFu8c_BFu32ll { unsigned char :0; unsigned char v1:8; unsigned long long v2:32; };
struct BFu0c_BFu8c_BFu33 { unsigned char :0; unsigned char v1:8; unsigned long long v2:33; };
struct BFu0c_BFu8c_BFu7c { unsigned char :0; unsigned char v1:8; unsigned char v2:7; };
struct BFu0c_BFu8c_BFu7i { unsigned char :0; unsigned char v1:8; unsigned int v2:7; };
struct BFu0c_BFu8c_BFu7ll { unsigned char :0; unsigned char v1:8; unsigned long long v2:7; };
struct BFu0c_BFu8c_BFu7s { unsigned char :0; unsigned char v1:8; unsigned short v2:7; };
struct BFu0c_BFu8c_BFu8c { unsigned char :0; unsigned char v1:8; unsigned char v2:8; };
struct BFu0c_BFu8c_BFu8i { unsigned char :0; unsigned char v1:8; unsigned int v2:8; };
struct BFu0c_BFu8c_BFu8ll { unsigned char :0; unsigned char v1:8; unsigned long long v2:8; };
struct BFu0c_BFu8c_BFu8s { unsigned char :0; unsigned char v1:8; unsigned short v2:8; };
struct BFu0c_BFu8c_BFu9i { unsigned char :0; unsigned char v1:8; unsigned int v2:9; };
struct BFu0c_BFu8c_BFu9ll { unsigned char :0; unsigned char v1:8; unsigned long long v2:9; };
struct BFu0c_BFu8c_BFu9s { unsigned char :0; unsigned char v1:8; unsigned short v2:9; };
struct BFu0c_BFu8c_C { unsigned char :0; unsigned char v1:8; char v2; };
struct BFu0c_BFu8c_D { unsigned char :0; unsigned char v1:8; double v2; };
struct BFu0c_BFu8c_F { unsigned char :0; unsigned char v1:8; float v2; };
struct BFu0c_BFu8c_I { unsigned char :0; unsigned char v1:8; int v2; };
struct BFu0c_BFu8c_Ip { unsigned char :0; unsigned char v1:8; int * v2; };
struct BFu0c_BFu8c_L { unsigned char :0; unsigned char v1:8; long long v2; };
struct BFu0c_BFu8c_S { unsigned char :0; unsigned char v1:8; short v2; };
struct BFu0c_BFu8c_Uc { unsigned char :0; unsigned char v1:8; unsigned char v2; };
struct BFu0c_BFu8c_Ui { unsigned char :0; unsigned char v1:8; unsigned int v2; };
struct BFu0c_BFu8c_Ul { unsigned char :0; unsigned char v1:8; unsigned long long v2; };
struct BFu0c_BFu8c_Us { unsigned char :0; unsigned char v1:8; unsigned short v2; };
struct BFu0c_BFu8c_Vp { unsigned char :0; unsigned char v1:8; void * v2; };
struct BFu0c_BFu8i { unsigned char :0; unsigned int v1:8; };
struct BFu0c_BFu8i_BFu0c { unsigned char :0; unsigned int v1:8; unsigned char :0; };
struct BFu0c_BFu8i_BFu0i { unsigned char :0; unsigned int v1:8; unsigned int :0; };
struct BFu0c_BFu8i_BFu0ll { unsigned char :0; unsigned int v1:8; unsigned long long :0; };
struct BFu0c_BFu8i_BFu0s { unsigned char :0; unsigned int v1:8; unsigned short :0; };
struct BFu0c_BFu8i_BFu15i { unsigned char :0; unsigned int v1:8; unsigned int v2:15; };
struct BFu0c_BFu8i_BFu15ll { unsigned char :0; unsigned int v1:8; unsigned long long v2:15; };
struct BFu0c_BFu8i_BFu15s { unsigned char :0; unsigned int v1:8; unsigned short v2:15; };
struct BFu0c_BFu8i_BFu16i { unsigned char :0; unsigned int v1:8; unsigned int v2:16; };
struct BFu0c_BFu8i_BFu16ll { unsigned char :0; unsigned int v1:8; unsigned long long v2:16; };
struct BFu0c_BFu8i_BFu16s { unsigned char :0; unsigned int v1:8; unsigned short v2:16; };
struct BFu0c_BFu8i_BFu17i { unsigned char :0; unsigned int v1:8; unsigned int v2:17; };
struct BFu0c_BFu8i_BFu17ll { unsigned char :0; unsigned int v1:8; unsigned long long v2:17; };
struct BFu0c_BFu8i_BFu1c { unsigned char :0; unsigned int v1:8; unsigned char v2:1; };
struct BFu0c_BFu8i_BFu1i { unsigned char :0; unsigned int v1:8; unsigned int v2:1; };
struct BFu0c_BFu8i_BFu1ll { unsigned char :0; unsigned int v1:8; unsigned long long v2:1; };
struct BFu0c_BFu8i_BFu1s { unsigned char :0; unsigned int v1:8; unsigned short v2:1; };
struct BFu0c_BFu8i_BFu31i { unsigned char :0; unsigned int v1:8; unsigned int v2:31; };
struct BFu0c_BFu8i_BFu31ll { unsigned char :0; unsigned int v1:8; unsigned long long v2:31; };
struct BFu0c_BFu8i_BFu32i { unsigned char :0; unsigned int v1:8; unsigned int v2:32; };
struct BFu0c_BFu8i_BFu32ll { unsigned char :0; unsigned int v1:8; unsigned long long v2:32; };
struct BFu0c_BFu8i_BFu33 { unsigned char :0; unsigned int v1:8; unsigned long long v2:33; };
struct BFu0c_BFu8i_BFu7c { unsigned char :0; unsigned int v1:8; unsigned char v2:7; };
struct BFu0c_BFu8i_BFu7i { unsigned char :0; unsigned int v1:8; unsigned int v2:7; };
struct BFu0c_BFu8i_BFu7ll { unsigned char :0; unsigned int v1:8; unsigned long long v2:7; };
struct BFu0c_BFu8i_BFu7s { unsigned char :0; unsigned int v1:8; unsigned short v2:7; };
struct BFu0c_BFu8i_BFu8c { unsigned char :0; unsigned int v1:8; unsigned char v2:8; };
struct BFu0c_BFu8i_BFu8i { unsigned char :0; unsigned int v1:8; unsigned int v2:8; };
struct BFu0c_BFu8i_BFu8ll { unsigned char :0; unsigned int v1:8; unsigned long long v2:8; };
struct BFu0c_BFu8i_BFu8s { unsigned char :0; unsigned int v1:8; unsigned short v2:8; };
struct BFu0c_BFu8i_BFu9i { unsigned char :0; unsigned int v1:8; unsigned int v2:9; };
struct BFu0c_BFu8i_BFu9ll { unsigned char :0; unsigned int v1:8; unsigned long long v2:9; };
struct BFu0c_BFu8i_BFu9s { unsigned char :0; unsigned int v1:8; unsigned short v2:9; };
struct BFu0c_BFu8i_C { unsigned char :0; unsigned int v1:8; char v2; };
struct BFu0c_BFu8i_D { unsigned char :0; unsigned int v1:8; double v2; };
struct BFu0c_BFu8i_F { unsigned char :0; unsigned int v1:8; float v2; };
struct BFu0c_BFu8i_I { unsigned char :0; unsigned int v1:8; int v2; };
struct BFu0c_BFu8i_Ip { unsigned char :0; unsigned int v1:8; int * v2; };
struct BFu0c_BFu8i_L { unsigned char :0; unsigned int v1:8; long long v2; };
struct BFu0c_BFu8i_S { unsigned char :0; unsigned int v1:8; short v2; };
struct BFu0c_BFu8i_Uc { unsigned char :0; unsigned int v1:8; unsigned char v2; };
struct BFu0c_BFu8i_Ui { unsigned char :0; unsigned int v1:8; unsigned int v2; };
struct BFu0c_BFu8i_Ul { unsigned char :0; unsigned int v1:8; unsigned long long v2; };
struct BFu0c_BFu8i_Us { unsigned char :0; unsigned int v1:8; unsigned short v2; };
struct BFu0c_BFu8i_Vp { unsigned char :0; unsigned int v1:8; void * v2; };
struct BFu0c_BFu8ll { unsigned char :0; unsigned long long v1:8; };
struct BFu0c_BFu8ll_BFu0c { unsigned char :0; unsigned long long v1:8; unsigned char :0; };
struct BFu0c_BFu8ll_BFu0i { unsigned char :0; unsigned long long v1:8; unsigned int :0; };
struct BFu0c_BFu8ll_BFu0ll { unsigned char :0; unsigned long long v1:8; unsigned long long :0; };
struct BFu0c_BFu8ll_BFu0s { unsigned char :0; unsigned long long v1:8; unsigned short :0; };
struct BFu0c_BFu8ll_BFu15i { unsigned char :0; unsigned long long v1:8; unsigned int v2:15; };
struct BFu0c_BFu8ll_BFu15ll { unsigned char :0; unsigned long long v1:8; unsigned long long v2:15; };
struct BFu0c_BFu8ll_BFu15s { unsigned char :0; unsigned long long v1:8; unsigned short v2:15; };
struct BFu0c_BFu8ll_BFu16i { unsigned char :0; unsigned long long v1:8; unsigned int v2:16; };
struct BFu0c_BFu8ll_BFu16ll { unsigned char :0; unsigned long long v1:8; unsigned long long v2:16; };
struct BFu0c_BFu8ll_BFu16s { unsigned char :0; unsigned long long v1:8; unsigned short v2:16; };
struct BFu0c_BFu8ll_BFu17i { unsigned char :0; unsigned long long v1:8; unsigned int v2:17; };
struct BFu0c_BFu8ll_BFu17ll { unsigned char :0; unsigned long long v1:8; unsigned long long v2:17; };
struct BFu0c_BFu8ll_BFu1c { unsigned char :0; unsigned long long v1:8; unsigned char v2:1; };
struct BFu0c_BFu8ll_BFu1i { unsigned char :0; unsigned long long v1:8; unsigned int v2:1; };
struct BFu0c_BFu8ll_BFu1ll { unsigned char :0; unsigned long long v1:8; unsigned long long v2:1; };
struct BFu0c_BFu8ll_BFu1s { unsigned char :0; unsigned long long v1:8; unsigned short v2:1; };
struct BFu0c_BFu8ll_BFu31i { unsigned char :0; unsigned long long v1:8; unsigned int v2:31; };
struct BFu0c_BFu8ll_BFu31ll { unsigned char :0; unsigned long long v1:8; unsigned long long v2:31; };
struct BFu0c_BFu8ll_BFu32i { unsigned char :0; unsigned long long v1:8; unsigned int v2:32; };
struct BFu0c_BFu8ll_BFu32ll { unsigned char :0; unsigned long long v1:8; unsigned long long v2:32; };
struct BFu0c_BFu8ll_BFu33 { unsigned char :0; unsigned long long v1:8; unsigned long long v2:33; };
struct BFu0c_BFu8ll_BFu7c { unsigned char :0; unsigned long long v1:8; unsigned char v2:7; };
struct BFu0c_BFu8ll_BFu7i { unsigned char :0; unsigned long long v1:8; unsigned int v2:7; };
struct BFu0c_BFu8ll_BFu7ll { unsigned char :0; unsigned long long v1:8; unsigned long long v2:7; };
struct BFu0c_BFu8ll_BFu7s { unsigned char :0; unsigned long long v1:8; unsigned short v2:7; };
struct BFu0c_BFu8ll_BFu8c { unsigned char :0; unsigned long long v1:8; unsigned char v2:8; };
struct BFu0c_BFu8ll_BFu8i { unsigned char :0; unsigned long long v1:8; unsigned int v2:8; };
struct BFu0c_BFu8ll_BFu8ll { unsigned char :0; unsigned long long v1:8; unsigned long long v2:8; };
struct BFu0c_BFu8ll_BFu8s { unsigned char :0; unsigned long long v1:8; unsigned short v2:8; };
struct BFu0c_BFu8ll_BFu9i { unsigned char :0; unsigned long long v1:8; unsigned int v2:9; };
struct BFu0c_BFu8ll_BFu9ll { unsigned char :0; unsigned long long v1:8; unsigned long long v2:9; };
struct BFu0c_BFu8ll_BFu9s { unsigned char :0; unsigned long long v1:8; unsigned short v2:9; };
struct BFu0c_BFu8ll_C { unsigned char :0; unsigned long long v1:8; char v2; };
struct BFu0c_BFu8ll_D { unsigned char :0; unsigned long long v1:8; double v2; };
struct BFu0c_BFu8ll_F { unsigned char :0; unsigned long long v1:8; float v2; };
struct BFu0c_BFu8ll_I { unsigned char :0; unsigned long long v1:8; int v2; };
struct BFu0c_BFu8ll_Ip { unsigned char :0; unsigned long long v1:8; int * v2; };
struct BFu0c_BFu8ll_L { unsigned char :0; unsigned long long v1:8; long long v2; };
struct BFu0c_BFu8ll_S { unsigned char :0; unsigned long long v1:8; short v2; };
struct BFu0c_BFu8ll_Uc { unsigned char :0; unsigned long long v1:8; unsigned char v2; };
struct BFu0c_BFu8ll_Ui { unsigned char :0; unsigned long long v1:8; unsigned int v2; };
struct BFu0c_BFu8ll_Ul { unsigned char :0; unsigned long long v1:8; unsigned long long v2; };
struct BFu0c_BFu8ll_Us { unsigned char :0; unsigned long long v1:8; unsigned short v2; };
struct BFu0c_BFu8ll_Vp { unsigned char :0; unsigned long long v1:8; void * v2; };
struct BFu0c_BFu8s { unsigned char :0; unsigned short v1:8; };
struct BFu0c_BFu8s_BFu0c { unsigned char :0; unsigned short v1:8; unsigned char :0; };
struct BFu0c_BFu8s_BFu0i { unsigned char :0; unsigned short v1:8; unsigned int :0; };
struct BFu0c_BFu8s_BFu0ll { unsigned char :0; unsigned short v1:8; unsigned long long :0; };
struct BFu0c_BFu8s_BFu0s { unsigned char :0; unsigned short v1:8; unsigned short :0; };
struct BFu0c_BFu8s_BFu15i { unsigned char :0; unsigned short v1:8; unsigned int v2:15; };
struct BFu0c_BFu8s_BFu15ll { unsigned char :0; unsigned short v1:8; unsigned long long v2:15; };
struct BFu0c_BFu8s_BFu15s { unsigned char :0; unsigned short v1:8; unsigned short v2:15; };
struct BFu0c_BFu8s_BFu16i { unsigned char :0; unsigned short v1:8; unsigned int v2:16; };
struct BFu0c_BFu8s_BFu16ll { unsigned char :0; unsigned short v1:8; unsigned long long v2:16; };
struct BFu0c_BFu8s_BFu16s { unsigned char :0; unsigned short v1:8; unsigned short v2:16; };
struct BFu0c_BFu8s_BFu17i { unsigned char :0; unsigned short v1:8; unsigned int v2:17; };
struct BFu0c_BFu8s_BFu17ll { unsigned char :0; unsigned short v1:8; unsigned long long v2:17; };
struct BFu0c_BFu8s_BFu1c { unsigned char :0; unsigned short v1:8; unsigned char v2:1; };
struct BFu0c_BFu8s_BFu1i { unsigned char :0; unsigned short v1:8; unsigned int v2:1; };
struct BFu0c_BFu8s_BFu1ll { unsigned char :0; unsigned short v1:8; unsigned long long v2:1; };
struct BFu0c_BFu8s_BFu1s { unsigned char :0; unsigned short v1:8; unsigned short v2:1; };
struct BFu0c_BFu8s_BFu31i { unsigned char :0; unsigned short v1:8; unsigned int v2:31; };
struct BFu0c_BFu8s_BFu31ll { unsigned char :0; unsigned short v1:8; unsigned long long v2:31; };
struct BFu0c_BFu8s_BFu32i { unsigned char :0; unsigned short v1:8; unsigned int v2:32; };
struct BFu0c_BFu8s_BFu32ll { unsigned char :0; unsigned short v1:8; unsigned long long v2:32; };
struct BFu0c_BFu8s_BFu33 { unsigned char :0; unsigned short v1:8; unsigned long long v2:33; };
struct BFu0c_BFu8s_BFu7c { unsigned char :0; unsigned short v1:8; unsigned char v2:7; };
struct BFu0c_BFu8s_BFu7i { unsigned char :0; unsigned short v1:8; unsigned int v2:7; };
struct BFu0c_BFu8s_BFu7ll { unsigned char :0; unsigned short v1:8; unsigned long long v2:7; };
struct BFu0c_BFu8s_BFu7s { unsigned char :0; unsigned short v1:8; unsigned short v2:7; };
struct BFu0c_BFu8s_BFu8c { unsigned char :0; unsigned short v1:8; unsigned char v2:8; };
struct BFu0c_BFu8s_BFu8i { unsigned char :0; unsigned short v1:8; unsigned int v2:8; };
struct BFu0c_BFu8s_BFu8ll { unsigned char :0; unsigned short v1:8; unsigned long long v2:8; };
struct BFu0c_BFu8s_BFu8s { unsigned char :0; unsigned short v1:8; unsigned short v2:8; };
struct BFu0c_BFu8s_BFu9i { unsigned char :0; unsigned short v1:8; unsigned int v2:9; };
struct BFu0c_BFu8s_BFu9ll { unsigned char :0; unsigned short v1:8; unsigned long long v2:9; };
struct BFu0c_BFu8s_BFu9s { unsigned char :0; unsigned short v1:8; unsigned short v2:9; };
struct BFu0c_BFu8s_C { unsigned char :0; unsigned short v1:8; char v2; };
struct BFu0c_BFu8s_D { unsigned char :0; unsigned short v1:8; double v2; };
struct BFu0c_BFu8s_F { unsigned char :0; unsigned short v1:8; float v2; };
struct BFu0c_BFu8s_I { unsigned char :0; unsigned short v1:8; int v2; };
struct BFu0c_BFu8s_Ip { unsigned char :0; unsigned short v1:8; int * v2; };
struct BFu0c_BFu8s_L { unsigned char :0; unsigned short v1:8; long long v2; };
struct BFu0c_BFu8s_S { unsigned char :0; unsigned short v1:8; short v2; };
struct BFu0c_BFu8s_Uc { unsigned char :0; unsigned short v1:8; unsigned char v2; };
struct BFu0c_BFu8s_Ui { unsigned char :0; unsigned short v1:8; unsigned int v2; };
struct BFu0c_BFu8s_Ul { unsigned char :0; unsigned short v1:8; unsigned long long v2; };
struct BFu0c_BFu8s_Us { unsigned char :0; unsigned short v1:8; unsigned short v2; };
struct BFu0c_BFu8s_Vp { unsigned char :0; unsigned short v1:8; void * v2; };
struct BFu0c_BFu9i { unsigned char :0; unsigned int v1:9; };
struct BFu0c_BFu9i_BFu0c { unsigned char :0; unsigned int v1:9; unsigned char :0; };
struct BFu0c_BFu9i_BFu0i { unsigned char :0; unsigned int v1:9; unsigned int :0; };
struct BFu0c_BFu9i_BFu0ll { unsigned char :0; unsigned int v1:9; unsigned long long :0; };
struct BFu0c_BFu9i_BFu0s { unsigned char :0; unsigned int v1:9; unsigned short :0; };
struct BFu0c_BFu9i_BFu15i { unsigned char :0; unsigned int v1:9; unsigned int v2:15; };
struct BFu0c_BFu9i_BFu15ll { unsigned char :0; unsigned int v1:9; unsigned long long v2:15; };
struct BFu0c_BFu9i_BFu15s { unsigned char :0; unsigned int v1:9; unsigned short v2:15; };
struct BFu0c_BFu9i_BFu16i { unsigned char :0; unsigned int v1:9; unsigned int v2:16; };
struct BFu0c_BFu9i_BFu16ll { unsigned char :0; unsigned int v1:9; unsigned long long v2:16; };
struct BFu0c_BFu9i_BFu16s { unsigned char :0; unsigned int v1:9; unsigned short v2:16; };
struct BFu0c_BFu9i_BFu17i { unsigned char :0; unsigned int v1:9; unsigned int v2:17; };
struct BFu0c_BFu9i_BFu17ll { unsigned char :0; unsigned int v1:9; unsigned long long v2:17; };
struct BFu0c_BFu9i_BFu1c { unsigned char :0; unsigned int v1:9; unsigned char v2:1; };
struct BFu0c_BFu9i_BFu1i { unsigned char :0; unsigned int v1:9; unsigned int v2:1; };
struct BFu0c_BFu9i_BFu1ll { unsigned char :0; unsigned int v1:9; unsigned long long v2:1; };
struct BFu0c_BFu9i_BFu1s { unsigned char :0; unsigned int v1:9; unsigned short v2:1; };
struct BFu0c_BFu9i_BFu31i { unsigned char :0; unsigned int v1:9; unsigned int v2:31; };
struct BFu0c_BFu9i_BFu31ll { unsigned char :0; unsigned int v1:9; unsigned long long v2:31; };
struct BFu0c_BFu9i_BFu32i { unsigned char :0; unsigned int v1:9; unsigned int v2:32; };
struct BFu0c_BFu9i_BFu32ll { unsigned char :0; unsigned int v1:9; unsigned long long v2:32; };
struct BFu0c_BFu9i_BFu33 { unsigned char :0; unsigned int v1:9; unsigned long long v2:33; };
struct BFu0c_BFu9i_BFu7c { unsigned char :0; unsigned int v1:9; unsigned char v2:7; };
struct BFu0c_BFu9i_BFu7i { unsigned char :0; unsigned int v1:9; unsigned int v2:7; };
struct BFu0c_BFu9i_BFu7ll { unsigned char :0; unsigned int v1:9; unsigned long long v2:7; };
struct BFu0c_BFu9i_BFu7s { unsigned char :0; unsigned int v1:9; unsigned short v2:7; };
struct BFu0c_BFu9i_BFu8c { unsigned char :0; unsigned int v1:9; unsigned char v2:8; };
struct BFu0c_BFu9i_BFu8i { unsigned char :0; unsigned int v1:9; unsigned int v2:8; };
struct BFu0c_BFu9i_BFu8ll { unsigned char :0; unsigned int v1:9; unsigned long long v2:8; };
struct BFu0c_BFu9i_BFu8s { unsigned char :0; unsigned int v1:9; unsigned short v2:8; };
struct BFu0c_BFu9i_BFu9i { unsigned char :0; unsigned int v1:9; unsigned int v2:9; };
struct BFu0c_BFu9i_BFu9ll { unsigned char :0; unsigned int v1:9; unsigned long long v2:9; };
struct BFu0c_BFu9i_BFu9s { unsigned char :0; unsigned int v1:9; unsigned short v2:9; };
struct BFu0c_BFu9i_C { unsigned char :0; unsigned int v1:9; char v2; };
struct BFu0c_BFu9i_D { unsigned char :0; unsigned int v1:9; double v2; };
struct BFu0c_BFu9i_F { unsigned char :0; unsigned int v1:9; float v2; };
struct BFu0c_BFu9i_I { unsigned char :0; unsigned int v1:9; int v2; };
struct BFu0c_BFu9i_Ip { unsigned char :0; unsigned int v1:9; int * v2; };
struct BFu0c_BFu9i_L { unsigned char :0; unsigned int v1:9; long long v2; };
struct BFu0c_BFu9i_S { unsigned char :0; unsigned int v1:9; short v2; };
struct BFu0c_BFu9i_Uc { unsigned char :0; unsigned int v1:9; unsigned char v2; };
struct BFu0c_BFu9i_Ui { unsigned char :0; unsigned int v1:9; unsigned int v2; };
struct BFu0c_BFu9i_Ul { unsigned char :0; unsigned int v1:9; unsigned long long v2; };
struct BFu0c_BFu9i_Us { unsigned char :0; unsigned int v1:9; unsigned short v2; };
struct BFu0c_BFu9i_Vp { unsigned char :0; unsigned int v1:9; void * v2; };
struct BFu0c_BFu9ll { unsigned char :0; unsigned long long v1:9; };
struct BFu0c_BFu9ll_BFu0c { unsigned char :0; unsigned long long v1:9; unsigned char :0; };
struct BFu0c_BFu9ll_BFu0i { unsigned char :0; unsigned long long v1:9; unsigned int :0; };
struct BFu0c_BFu9ll_BFu0ll { unsigned char :0; unsigned long long v1:9; unsigned long long :0; };
struct BFu0c_BFu9ll_BFu0s { unsigned char :0; unsigned long long v1:9; unsigned short :0; };
struct BFu0c_BFu9ll_BFu15i { unsigned char :0; unsigned long long v1:9; unsigned int v2:15; };
struct BFu0c_BFu9ll_BFu15ll { unsigned char :0; unsigned long long v1:9; unsigned long long v2:15; };
struct BFu0c_BFu9ll_BFu15s { unsigned char :0; unsigned long long v1:9; unsigned short v2:15; };
struct BFu0c_BFu9ll_BFu16i { unsigned char :0; unsigned long long v1:9; unsigned int v2:16; };
struct BFu0c_BFu9ll_BFu16ll { unsigned char :0; unsigned long long v1:9; unsigned long long v2:16; };
struct BFu0c_BFu9ll_BFu16s { unsigned char :0; unsigned long long v1:9; unsigned short v2:16; };
struct BFu0c_BFu9ll_BFu17i { unsigned char :0; unsigned long long v1:9; unsigned int v2:17; };
struct BFu0c_BFu9ll_BFu17ll { unsigned char :0; unsigned long long v1:9; unsigned long long v2:17; };
struct BFu0c_BFu9ll_BFu1c { unsigned char :0; unsigned long long v1:9; unsigned char v2:1; };
struct BFu0c_BFu9ll_BFu1i { unsigned char :0; unsigned long long v1:9; unsigned int v2:1; };
struct BFu0c_BFu9ll_BFu1ll { unsigned char :0; unsigned long long v1:9; unsigned long long v2:1; };
struct BFu0c_BFu9ll_BFu1s { unsigned char :0; unsigned long long v1:9; unsigned short v2:1; };
struct BFu0c_BFu9ll_BFu31i { unsigned char :0; unsigned long long v1:9; unsigned int v2:31; };
struct BFu0c_BFu9ll_BFu31ll { unsigned char :0; unsigned long long v1:9; unsigned long long v2:31; };
struct BFu0c_BFu9ll_BFu32i { unsigned char :0; unsigned long long v1:9; unsigned int v2:32; };
struct BFu0c_BFu9ll_BFu32ll { unsigned char :0; unsigned long long v1:9; unsigned long long v2:32; };
struct BFu0c_BFu9ll_BFu33 { unsigned char :0; unsigned long long v1:9; unsigned long long v2:33; };
struct BFu0c_BFu9ll_BFu7c { unsigned char :0; unsigned long long v1:9; unsigned char v2:7; };
struct BFu0c_BFu9ll_BFu7i { unsigned char :0; unsigned long long v1:9; unsigned int v2:7; };
struct BFu0c_BFu9ll_BFu7ll { unsigned char :0; unsigned long long v1:9; unsigned long long v2:7; };
struct BFu0c_BFu9ll_BFu7s { unsigned char :0; unsigned long long v1:9; unsigned short v2:7; };
struct BFu0c_BFu9ll_BFu8c { unsigned char :0; unsigned long long v1:9; unsigned char v2:8; };
struct BFu0c_BFu9ll_BFu8i { unsigned char :0; unsigned long long v1:9; unsigned int v2:8; };
struct BFu0c_BFu9ll_BFu8ll { unsigned char :0; unsigned long long v1:9; unsigned long long v2:8; };
struct BFu0c_BFu9ll_BFu8s { unsigned char :0; unsigned long long v1:9; unsigned short v2:8; };
struct BFu0c_BFu9ll_BFu9i { unsigned char :0; unsigned long long v1:9; unsigned int v2:9; };
struct BFu0c_BFu9ll_BFu9ll { unsigned char :0; unsigned long long v1:9; unsigned long long v2:9; };
struct BFu0c_BFu9ll_BFu9s { unsigned char :0; unsigned long long v1:9; unsigned short v2:9; };
struct BFu0c_BFu9ll_C { unsigned char :0; unsigned long long v1:9; char v2; };
struct BFu0c_BFu9ll_D { unsigned char :0; unsigned long long v1:9; double v2; };
struct BFu0c_BFu9ll_F { unsigned char :0; unsigned long long v1:9; float v2; };
struct BFu0c_BFu9ll_I { unsigned char :0; unsigned long long v1:9; int v2; };
struct BFu0c_BFu9ll_Ip { unsigned char :0; unsigned long long v1:9; int * v2; };
struct BFu0c_BFu9ll_L { unsigned char :0; unsigned long long v1:9; long long v2; };
struct BFu0c_BFu9ll_S { unsigned char :0; unsigned long long v1:9; short v2; };
struct BFu0c_BFu9ll_Uc { unsigned char :0; unsigned long long v1:9; unsigned char v2; };
struct BFu0c_BFu9ll_Ui { unsigned char :0; unsigned long long v1:9; unsigned int v2; };
struct BFu0c_BFu9ll_Ul { unsigned char :0; unsigned long long v1:9; unsigned long long v2; };
struct BFu0c_BFu9ll_Us { unsigned char :0; unsigned long long v1:9; unsigned short v2; };
struct BFu0c_BFu9ll_Vp { unsigned char :0; unsigned long long v1:9; void * v2; };
struct BFu0c_BFu9s { unsigned char :0; unsigned short v1:9; };
struct BFu0c_BFu9s_BFu0c { unsigned char :0; unsigned short v1:9; unsigned char :0; };
struct BFu0c_BFu9s_BFu0i { unsigned char :0; unsigned short v1:9; unsigned int :0; };
struct BFu0c_BFu9s_BFu0ll { unsigned char :0; unsigned short v1:9; unsigned long long :0; };
struct BFu0c_BFu9s_BFu0s { unsigned char :0; unsigned short v1:9; unsigned short :0; };
struct BFu0c_BFu9s_BFu15i { unsigned char :0; unsigned short v1:9; unsigned int v2:15; };
struct BFu0c_BFu9s_BFu15ll { unsigned char :0; unsigned short v1:9; unsigned long long v2:15; };
struct BFu0c_BFu9s_BFu15s { unsigned char :0; unsigned short v1:9; unsigned short v2:15; };
struct BFu0c_BFu9s_BFu16i { unsigned char :0; unsigned short v1:9; unsigned int v2:16; };
struct BFu0c_BFu9s_BFu16ll { unsigned char :0; unsigned short v1:9; unsigned long long v2:16; };
struct BFu0c_BFu9s_BFu16s { unsigned char :0; unsigned short v1:9; unsigned short v2:16; };
struct BFu0c_BFu9s_BFu17i { unsigned char :0; unsigned short v1:9; unsigned int v2:17; };
struct BFu0c_BFu9s_BFu17ll { unsigned char :0; unsigned short v1:9; unsigned long long v2:17; };
struct BFu0c_BFu9s_BFu1c { unsigned char :0; unsigned short v1:9; unsigned char v2:1; };
struct BFu0c_BFu9s_BFu1i { unsigned char :0; unsigned short v1:9; unsigned int v2:1; };
struct BFu0c_BFu9s_BFu1ll { unsigned char :0; unsigned short v1:9; unsigned long long v2:1; };
struct BFu0c_BFu9s_BFu1s { unsigned char :0; unsigned short v1:9; unsigned short v2:1; };
struct BFu0c_BFu9s_BFu31i { unsigned char :0; unsigned short v1:9; unsigned int v2:31; };
struct BFu0c_BFu9s_BFu31ll { unsigned char :0; unsigned short v1:9; unsigned long long v2:31; };
struct BFu0c_BFu9s_BFu32i { unsigned char :0; unsigned short v1:9; unsigned int v2:32; };
struct BFu0c_BFu9s_BFu32ll { unsigned char :0; unsigned short v1:9; unsigned long long v2:32; };
struct BFu0c_BFu9s_BFu33 { unsigned char :0; unsigned short v1:9; unsigned long long v2:33; };
struct BFu0c_BFu9s_BFu7c { unsigned char :0; unsigned short v1:9; unsigned char v2:7; };
struct BFu0c_BFu9s_BFu7i { unsigned char :0; unsigned short v1:9; unsigned int v2:7; };
struct BFu0c_BFu9s_BFu7ll { unsigned char :0; unsigned short v1:9; unsigned long long v2:7; };
struct BFu0c_BFu9s_BFu7s { unsigned char :0; unsigned short v1:9; unsigned short v2:7; };
struct BFu0c_BFu9s_BFu8c { unsigned char :0; unsigned short v1:9; unsigned char v2:8; };
struct BFu0c_BFu9s_BFu8i { unsigned char :0; unsigned short v1:9; unsigned int v2:8; };
struct BFu0c_BFu9s_BFu8ll { unsigned char :0; unsigned short v1:9; unsigned long long v2:8; };
struct BFu0c_BFu9s_BFu8s { unsigned char :0; unsigned short v1:9; unsigned short v2:8; };
struct BFu0c_BFu9s_BFu9i { unsigned char :0; unsigned short v1:9; unsigned int v2:9; };
struct BFu0c_BFu9s_BFu9ll { unsigned char :0; unsigned short v1:9; unsigned long long v2:9; };
struct BFu0c_BFu9s_BFu9s { unsigned char :0; unsigned short v1:9; unsigned short v2:9; };
struct BFu0c_BFu9s_C { unsigned char :0; unsigned short v1:9; char v2; };
struct BFu0c_BFu9s_D { unsigned char :0; unsigned short v1:9; double v2; };
struct BFu0c_BFu9s_F { unsigned char :0; unsigned short v1:9; float v2; };
struct BFu0c_BFu9s_I { unsigned char :0; unsigned short v1:9; int v2; };
struct BFu0c_BFu9s_Ip { unsigned char :0; unsigned short v1:9; int * v2; };
struct BFu0c_BFu9s_L { unsigned char :0; unsigned short v1:9; long long v2; };
struct BFu0c_BFu9s_S { unsigned char :0; unsigned short v1:9; short v2; };
struct BFu0c_BFu9s_Uc { unsigned char :0; unsigned short v1:9; unsigned char v2; };
struct BFu0c_BFu9s_Ui { unsigned char :0; unsigned short v1:9; unsigned int v2; };
struct BFu0c_BFu9s_Ul { unsigned char :0; unsigned short v1:9; unsigned long long v2; };
struct BFu0c_BFu9s_Us { unsigned char :0; unsigned short v1:9; unsigned short v2; };
struct BFu0c_BFu9s_Vp { unsigned char :0; unsigned short v1:9; void * v2; };
struct BFu0c_C { unsigned char :0; char v1; };
struct BFu0c_C_BFu0c { unsigned char :0; char v1; unsigned char :0; };
struct BFu0c_C_BFu0i { unsigned char :0; char v1; unsigned int :0; };
struct BFu0c_C_BFu0ll { unsigned char :0; char v1; unsigned long long :0; };
struct BFu0c_C_BFu0s { unsigned char :0; char v1; unsigned short :0; };
struct BFu0c_C_BFu15i { unsigned char :0; char v1; unsigned int v2:15; };
struct BFu0c_C_BFu15ll { unsigned char :0; char v1; unsigned long long v2:15; };
struct BFu0c_C_BFu15s { unsigned char :0; char v1; unsigned short v2:15; };
struct BFu0c_C_BFu16i { unsigned char :0; char v1; unsigned int v2:16; };
struct BFu0c_C_BFu16ll { unsigned char :0; char v1; unsigned long long v2:16; };
struct BFu0c_C_BFu16s { unsigned char :0; char v1; unsigned short v2:16; };
struct BFu0c_C_BFu17i { unsigned char :0; char v1; unsigned int v2:17; };
struct BFu0c_C_BFu17ll { unsigned char :0; char v1; unsigned long long v2:17; };
struct BFu0c_C_BFu1c { unsigned char :0; char v1; unsigned char v2:1; };
struct BFu0c_C_BFu1i { unsigned char :0; char v1; unsigned int v2:1; };
struct BFu0c_C_BFu1ll { unsigned char :0; char v1; unsigned long long v2:1; };
struct BFu0c_C_BFu1s { unsigned char :0; char v1; unsigned short v2:1; };
struct BFu0c_C_BFu31i { unsigned char :0; char v1; unsigned int v2:31; };
struct BFu0c_C_BFu31ll { unsigned char :0; char v1; unsigned long long v2:31; };
struct BFu0c_C_BFu32i { unsigned char :0; char v1; unsigned int v2:32; };
struct BFu0c_C_BFu32ll { unsigned char :0; char v1; unsigned long long v2:32; };
struct BFu0c_C_BFu33 { unsigned char :0; char v1; unsigned long long v2:33; };
struct BFu0c_C_BFu7c { unsigned char :0; char v1; unsigned char v2:7; };
struct BFu0c_C_BFu7i { unsigned char :0; char v1; unsigned int v2:7; };
struct BFu0c_C_BFu7ll { unsigned char :0; char v1; unsigned long long v2:7; };
struct BFu0c_C_BFu7s { unsigned char :0; char v1; unsigned short v2:7; };
struct BFu0c_C_BFu8c { unsigned char :0; char v1; unsigned char v2:8; };
struct BFu0c_C_BFu8i { unsigned char :0; char v1; unsigned int v2:8; };
struct BFu0c_C_BFu8ll { unsigned char :0; char v1; unsigned long long v2:8; };
struct BFu0c_C_BFu8s { unsigned char :0; char v1; unsigned short v2:8; };
struct BFu0c_C_BFu9i { unsigned char :0; char v1; unsigned int v2:9; };
struct BFu0c_C_BFu9ll { unsigned char :0; char v1; unsigned long long v2:9; };
struct BFu0c_C_BFu9s { unsigned char :0; char v1; unsigned short v2:9; };
struct BFu0c_C_C { unsigned char :0; char v1; char v2; };
struct BFu0c_C_D { unsigned char :0; char v1; double v2; };
struct BFu0c_C_F { unsigned char :0; char v1; float v2; };
struct BFu0c_C_I { unsigned char :0; char v1; int v2; };
struct BFu0c_C_Ip { unsigned char :0; char v1; int * v2; };
struct BFu0c_C_L { unsigned char :0; char v1; long long v2; };
struct BFu0c_C_S { unsigned char :0; char v1; short v2; };
struct BFu0c_C_Uc { unsigned char :0; char v1; unsigned char v2; };
struct BFu0c_C_Ui { unsigned char :0; char v1; unsigned int v2; };
struct BFu0c_C_Ul { unsigned char :0; char v1; unsigned long long v2; };
struct BFu0c_C_Us { unsigned char :0; char v1; unsigned short v2; };
struct BFu0c_C_Vp { unsigned char :0; char v1; void * v2; };
struct BFu0c_D { unsigned char :0; double v1; };
struct BFu0c_D_BFu0c { unsigned char :0; double v1; unsigned char :0; };
struct BFu0c_D_BFu0i { unsigned char :0; double v1; unsigned int :0; };
struct BFu0c_D_BFu0ll { unsigned char :0; double v1; unsigned long long :0; };
struct BFu0c_D_BFu0s { unsigned char :0; double v1; unsigned short :0; };
struct BFu0c_D_BFu15i { unsigned char :0; double v1; unsigned int v2:15; };
struct BFu0c_D_BFu15ll { unsigned char :0; double v1; unsigned long long v2:15; };
struct BFu0c_D_BFu15s { unsigned char :0; double v1; unsigned short v2:15; };
struct BFu0c_D_BFu16i { unsigned char :0; double v1; unsigned int v2:16; };
struct BFu0c_D_BFu16ll { unsigned char :0; double v1; unsigned long long v2:16; };
struct BFu0c_D_BFu16s { unsigned char :0; double v1; unsigned short v2:16; };
struct BFu0c_D_BFu17i { unsigned char :0; double v1; unsigned int v2:17; };
struct BFu0c_D_BFu17ll { unsigned char :0; double v1; unsigned long long v2:17; };
struct BFu0c_D_BFu1c { unsigned char :0; double v1; unsigned char v2:1; };
struct BFu0c_D_BFu1i { unsigned char :0; double v1; unsigned int v2:1; };
struct BFu0c_D_BFu1ll { unsigned char :0; double v1; unsigned long long v2:1; };
struct BFu0c_D_BFu1s { unsigned char :0; double v1; unsigned short v2:1; };
struct BFu0c_D_BFu31i { unsigned char :0; double v1; unsigned int v2:31; };
struct BFu0c_D_BFu31ll { unsigned char :0; double v1; unsigned long long v2:31; };
struct BFu0c_D_BFu32i { unsigned char :0; double v1; unsigned int v2:32; };
struct BFu0c_D_BFu32ll { unsigned char :0; double v1; unsigned long long v2:32; };
struct BFu0c_D_BFu33 { unsigned char :0; double v1; unsigned long long v2:33; };
struct BFu0c_D_BFu7c { unsigned char :0; double v1; unsigned char v2:7; };
struct BFu0c_D_BFu7i { unsigned char :0; double v1; unsigned int v2:7; };
struct BFu0c_D_BFu7ll { unsigned char :0; double v1; unsigned long long v2:7; };
struct BFu0c_D_BFu7s { unsigned char :0; double v1; unsigned short v2:7; };
struct BFu0c_D_BFu8c { unsigned char :0; double v1; unsigned char v2:8; };
struct BFu0c_D_BFu8i { unsigned char :0; double v1; unsigned int v2:8; };
struct BFu0c_D_BFu8ll { unsigned char :0; double v1; unsigned long long v2:8; };
struct BFu0c_D_BFu8s { unsigned char :0; double v1; unsigned short v2:8; };
struct BFu0c_D_BFu9i { unsigned char :0; double v1; unsigned int v2:9; };
struct BFu0c_D_BFu9ll { unsigned char :0; double v1; unsigned long long v2:9; };
struct BFu0c_D_BFu9s { unsigned char :0; double v1; unsigned short v2:9; };
struct BFu0c_D_C { unsigned char :0; double v1; char v2; };
struct BFu0c_D_D { unsigned char :0; double v1; double v2; };
struct BFu0c_D_F { unsigned char :0; double v1; float v2; };
struct BFu0c_D_I { unsigned char :0; double v1; int v2; };
struct BFu0c_D_Ip { unsigned char :0; double v1; int * v2; };
struct BFu0c_D_L { unsigned char :0; double v1; long long v2; };
struct BFu0c_D_S { unsigned char :0; double v1; short v2; };
struct BFu0c_D_Uc { unsigned char :0; double v1; unsigned char v2; };
struct BFu0c_D_Ui { unsigned char :0; double v1; unsigned int v2; };
struct BFu0c_D_Ul { unsigned char :0; double v1; unsigned long long v2; };
struct BFu0c_D_Us { unsigned char :0; double v1; unsigned short v2; };
struct BFu0c_D_Vp { unsigned char :0; double v1; void * v2; };
struct BFu0c_F { unsigned char :0; float v1; };
struct BFu0c_F_BFu0c { unsigned char :0; float v1; unsigned char :0; };
struct BFu0c_F_BFu0i { unsigned char :0; float v1; unsigned int :0; };
struct BFu0c_F_BFu0ll { unsigned char :0; float v1; unsigned long long :0; };
struct BFu0c_F_BFu0s { unsigned char :0; float v1; unsigned short :0; };
struct BFu0c_F_BFu15i { unsigned char :0; float v1; unsigned int v2:15; };
struct BFu0c_F_BFu15ll { unsigned char :0; float v1; unsigned long long v2:15; };
struct BFu0c_F_BFu15s { unsigned char :0; float v1; unsigned short v2:15; };
struct BFu0c_F_BFu16i { unsigned char :0; float v1; unsigned int v2:16; };
struct BFu0c_F_BFu16ll { unsigned char :0; float v1; unsigned long long v2:16; };
struct BFu0c_F_BFu16s { unsigned char :0; float v1; unsigned short v2:16; };
struct BFu0c_F_BFu17i { unsigned char :0; float v1; unsigned int v2:17; };
struct BFu0c_F_BFu17ll { unsigned char :0; float v1; unsigned long long v2:17; };
struct BFu0c_F_BFu1c { unsigned char :0; float v1; unsigned char v2:1; };
struct BFu0c_F_BFu1i { unsigned char :0; float v1; unsigned int v2:1; };
struct BFu0c_F_BFu1ll { unsigned char :0; float v1; unsigned long long v2:1; };
struct BFu0c_F_BFu1s { unsigned char :0; float v1; unsigned short v2:1; };
struct BFu0c_F_BFu31i { unsigned char :0; float v1; unsigned int v2:31; };
struct BFu0c_F_BFu31ll { unsigned char :0; float v1; unsigned long long v2:31; };
struct BFu0c_F_BFu32i { unsigned char :0; float v1; unsigned int v2:32; };
struct BFu0c_F_BFu32ll { unsigned char :0; float v1; unsigned long long v2:32; };
struct BFu0c_F_BFu33 { unsigned char :0; float v1; unsigned long long v2:33; };
struct BFu0c_F_BFu7c { unsigned char :0; float v1; unsigned char v2:7; };
struct BFu0c_F_BFu7i { unsigned char :0; float v1; unsigned int v2:7; };
struct BFu0c_F_BFu7ll { unsigned char :0; float v1; unsigned long long v2:7; };
struct BFu0c_F_BFu7s { unsigned char :0; float v1; unsigned short v2:7; };
struct BFu0c_F_BFu8c { unsigned char :0; float v1; unsigned char v2:8; };
struct BFu0c_F_BFu8i { unsigned char :0; float v1; unsigned int v2:8; };
struct BFu0c_F_BFu8ll { unsigned char :0; float v1; unsigned long long v2:8; };
struct BFu0c_F_BFu8s { unsigned char :0; float v1; unsigned short v2:8; };
struct BFu0c_F_BFu9i { unsigned char :0; float v1; unsigned int v2:9; };
struct BFu0c_F_BFu9ll { unsigned char :0; float v1; unsigned long long v2:9; };
struct BFu0c_F_BFu9s { unsigned char :0; float v1; unsigned short v2:9; };
struct BFu0c_F_C { unsigned char :0; float v1; char v2; };
struct BFu0c_F_D { unsigned char :0; float v1; double v2; };
struct BFu0c_F_F { unsigned char :0; float v1; float v2; };
struct BFu0c_F_I { unsigned char :0; float v1; int v2; };
struct BFu0c_F_Ip { unsigned char :0; float v1; int * v2; };
struct BFu0c_F_L { unsigned char :0; float v1; long long v2; };
struct BFu0c_F_S { unsigned char :0; float v1; short v2; };
struct BFu0c_F_Uc { unsigned char :0; float v1; unsigned char v2; };
struct BFu0c_F_Ui { unsigned char :0; float v1; unsigned int v2; };
struct BFu0c_F_Ul { unsigned char :0; float v1; unsigned long long v2; };
struct BFu0c_F_Us { unsigned char :0; float v1; unsigned short v2; };
struct BFu0c_F_Vp { unsigned char :0; float v1; void * v2; };
struct BFu0c_I { unsigned char :0; int v1; };
struct BFu0c_I_BFu0c { unsigned char :0; int v1; unsigned char :0; };
struct BFu0c_I_BFu0i { unsigned char :0; int v1; unsigned int :0; };
struct BFu0c_I_BFu0ll { unsigned char :0; int v1; unsigned long long :0; };
struct BFu0c_I_BFu0s { unsigned char :0; int v1; unsigned short :0; };
struct BFu0c_I_BFu15i { unsigned char :0; int v1; unsigned int v2:15; };
struct BFu0c_I_BFu15ll { unsigned char :0; int v1; unsigned long long v2:15; };
struct BFu0c_I_BFu15s { unsigned char :0; int v1; unsigned short v2:15; };
struct BFu0c_I_BFu16i { unsigned char :0; int v1; unsigned int v2:16; };
struct BFu0c_I_BFu16ll { unsigned char :0; int v1; unsigned long long v2:16; };
struct BFu0c_I_BFu16s { unsigned char :0; int v1; unsigned short v2:16; };
struct BFu0c_I_BFu17i { unsigned char :0; int v1; unsigned int v2:17; };
struct BFu0c_I_BFu17ll { unsigned char :0; int v1; unsigned long long v2:17; };
struct BFu0c_I_BFu1c { unsigned char :0; int v1; unsigned char v2:1; };
struct BFu0c_I_BFu1i { unsigned char :0; int v1; unsigned int v2:1; };
struct BFu0c_I_BFu1ll { unsigned char :0; int v1; unsigned long long v2:1; };
struct BFu0c_I_BFu1s { unsigned char :0; int v1; unsigned short v2:1; };
struct BFu0c_I_BFu31i { unsigned char :0; int v1; unsigned int v2:31; };
struct BFu0c_I_BFu31ll { unsigned char :0; int v1; unsigned long long v2:31; };
struct BFu0c_I_BFu32i { unsigned char :0; int v1; unsigned int v2:32; };
struct BFu0c_I_BFu32ll { unsigned char :0; int v1; unsigned long long v2:32; };
struct BFu0c_I_BFu33 { unsigned char :0; int v1; unsigned long long v2:33; };
struct BFu0c_I_BFu7c { unsigned char :0; int v1; unsigned char v2:7; };
struct BFu0c_I_BFu7i { unsigned char :0; int v1; unsigned int v2:7; };
struct BFu0c_I_BFu7ll { unsigned char :0; int v1; unsigned long long v2:7; };
struct BFu0c_I_BFu7s { unsigned char :0; int v1; unsigned short v2:7; };
struct BFu0c_I_BFu8c { unsigned char :0; int v1; unsigned char v2:8; };
struct BFu0c_I_BFu8i { unsigned char :0; int v1; unsigned int v2:8; };
struct BFu0c_I_BFu8ll { unsigned char :0; int v1; unsigned long long v2:8; };
struct BFu0c_I_BFu8s { unsigned char :0; int v1; unsigned short v2:8; };
struct BFu0c_I_BFu9i { unsigned char :0; int v1; unsigned int v2:9; };
struct BFu0c_I_BFu9ll { unsigned char :0; int v1; unsigned long long v2:9; };
struct BFu0c_I_BFu9s { unsigned char :0; int v1; unsigned short v2:9; };
struct BFu0c_I_C { unsigned char :0; int v1; char v2; };
struct BFu0c_I_D { unsigned char :0; int v1; double v2; };
struct BFu0c_I_F { unsigned char :0; int v1; float v2; };
struct BFu0c_I_I { unsigned char :0; int v1; int v2; };
struct BFu0c_I_Ip { unsigned char :0; int v1; int * v2; };
struct BFu0c_I_L { unsigned char :0; int v1; long long v2; };
struct BFu0c_I_S { unsigned char :0; int v1; short v2; };
struct BFu0c_I_Uc { unsigned char :0; int v1; unsigned char v2; };
struct BFu0c_I_Ui { unsigned char :0; int v1; unsigned int v2; };
struct BFu0c_I_Ul { unsigned char :0; int v1; unsigned long long v2; };
struct BFu0c_I_Us { unsigned char :0; int v1; unsigned short v2; };
struct BFu0c_I_Vp { unsigned char :0; int v1; void * v2; };
struct BFu0c_Ip { unsigned char :0; int * v1; };
struct BFu0c_Ip_BFu0c { unsigned char :0; int * v1; unsigned char :0; };
struct BFu0c_Ip_BFu0i { unsigned char :0; int * v1; unsigned int :0; };
struct BFu0c_Ip_BFu0ll { unsigned char :0; int * v1; unsigned long long :0; };
struct BFu0c_Ip_BFu0s { unsigned char :0; int * v1; unsigned short :0; };
struct BFu0c_Ip_BFu15i { unsigned char :0; int * v1; unsigned int v2:15; };
struct BFu0c_Ip_BFu15ll { unsigned char :0; int * v1; unsigned long long v2:15; };
struct BFu0c_Ip_BFu15s { unsigned char :0; int * v1; unsigned short v2:15; };
struct BFu0c_Ip_BFu16i { unsigned char :0; int * v1; unsigned int v2:16; };
struct BFu0c_Ip_BFu16ll { unsigned char :0; int * v1; unsigned long long v2:16; };
struct BFu0c_Ip_BFu16s { unsigned char :0; int * v1; unsigned short v2:16; };
struct BFu0c_Ip_BFu17i { unsigned char :0; int * v1; unsigned int v2:17; };
struct BFu0c_Ip_BFu17ll { unsigned char :0; int * v1; unsigned long long v2:17; };
struct BFu0c_Ip_BFu1c { unsigned char :0; int * v1; unsigned char v2:1; };
struct BFu0c_Ip_BFu1i { unsigned char :0; int * v1; unsigned int v2:1; };
struct BFu0c_Ip_BFu1ll { unsigned char :0; int * v1; unsigned long long v2:1; };
struct BFu0c_Ip_BFu1s { unsigned char :0; int * v1; unsigned short v2:1; };
struct BFu0c_Ip_BFu31i { unsigned char :0; int * v1; unsigned int v2:31; };
struct BFu0c_Ip_BFu31ll { unsigned char :0; int * v1; unsigned long long v2:31; };
struct BFu0c_Ip_BFu32i { unsigned char :0; int * v1; unsigned int v2:32; };
struct BFu0c_Ip_BFu32ll { unsigned char :0; int * v1; unsigned long long v2:32; };
struct BFu0c_Ip_BFu33 { unsigned char :0; int * v1; unsigned long long v2:33; };
struct BFu0c_Ip_BFu7c { unsigned char :0; int * v1; unsigned char v2:7; };
struct BFu0c_Ip_BFu7i { unsigned char :0; int * v1; unsigned int v2:7; };
struct BFu0c_Ip_BFu7ll { unsigned char :0; int * v1; unsigned long long v2:7; };
struct BFu0c_Ip_BFu7s { unsigned char :0; int * v1; unsigned short v2:7; };
struct BFu0c_Ip_BFu8c { unsigned char :0; int * v1; unsigned char v2:8; };
struct BFu0c_Ip_BFu8i { unsigned char :0; int * v1; unsigned int v2:8; };
struct BFu0c_Ip_BFu8ll { unsigned char :0; int * v1; unsigned long long v2:8; };
struct BFu0c_Ip_BFu8s { unsigned char :0; int * v1; unsigned short v2:8; };
struct BFu0c_Ip_BFu9i { unsigned char :0; int * v1; unsigned int v2:9; };
struct BFu0c_Ip_BFu9ll { unsigned char :0; int * v1; unsigned long long v2:9; };
struct BFu0c_Ip_BFu9s { unsigned char :0; int * v1; unsigned short v2:9; };
struct BFu0c_Ip_C { unsigned char :0; int * v1; char v2; };
struct BFu0c_Ip_D { unsigned char :0; int * v1; double v2; };
struct BFu0c_Ip_F { unsigned char :0; int * v1; float v2; };
struct BFu0c_Ip_I { unsigned char :0; int * v1; int v2; };
struct BFu0c_Ip_Ip { unsigned char :0; int * v1; int * v2; };
struct BFu0c_Ip_L { unsigned char :0; int * v1; long long v2; };
struct BFu0c_Ip_S { unsigned char :0; int * v1; short v2; };
struct BFu0c_Ip_Uc { unsigned char :0; int * v1; unsigned char v2; };
struct BFu0c_Ip_Ui { unsigned char :0; int * v1; unsigned int v2; };
struct BFu0c_Ip_Ul { unsigned char :0; int * v1; unsigned long long v2; };
struct BFu0c_Ip_Us { unsigned char :0; int * v1; unsigned short v2; };
struct BFu0c_Ip_Vp { unsigned char :0; int * v1; void * v2; };
struct BFu0c_L { unsigned char :0; long long v1; };
struct BFu0c_L_BFu0c { unsigned char :0; long long v1; unsigned char :0; };
struct BFu0c_L_BFu0i { unsigned char :0; long long v1; unsigned int :0; };
struct BFu0c_L_BFu0ll { unsigned char :0; long long v1; unsigned long long :0; };
struct BFu0c_L_BFu0s { unsigned char :0; long long v1; unsigned short :0; };
struct BFu0c_L_BFu15i { unsigned char :0; long long v1; unsigned int v2:15; };
struct BFu0c_L_BFu15ll { unsigned char :0; long long v1; unsigned long long v2:15; };
struct BFu0c_L_BFu15s { unsigned char :0; long long v1; unsigned short v2:15; };
struct BFu0c_L_BFu16i { unsigned char :0; long long v1; unsigned int v2:16; };
struct BFu0c_L_BFu16ll { unsigned char :0; long long v1; unsigned long long v2:16; };
struct BFu0c_L_BFu16s { unsigned char :0; long long v1; unsigned short v2:16; };
struct BFu0c_L_BFu17i { unsigned char :0; long long v1; unsigned int v2:17; };
struct BFu0c_L_BFu17ll { unsigned char :0; long long v1; unsigned long long v2:17; };
struct BFu0c_L_BFu1c { unsigned char :0; long long v1; unsigned char v2:1; };
struct BFu0c_L_BFu1i { unsigned char :0; long long v1; unsigned int v2:1; };
struct BFu0c_L_BFu1ll { unsigned char :0; long long v1; unsigned long long v2:1; };
struct BFu0c_L_BFu1s { unsigned char :0; long long v1; unsigned short v2:1; };
struct BFu0c_L_BFu31i { unsigned char :0; long long v1; unsigned int v2:31; };
struct BFu0c_L_BFu31ll { unsigned char :0; long long v1; unsigned long long v2:31; };
struct BFu0c_L_BFu32i { unsigned char :0; long long v1; unsigned int v2:32; };
struct BFu0c_L_BFu32ll { unsigned char :0; long long v1; unsigned long long v2:32; };
struct BFu0c_L_BFu33 { unsigned char :0; long long v1; unsigned long long v2:33; };
struct BFu0c_L_BFu7c { unsigned char :0; long long v1; unsigned char v2:7; };
struct BFu0c_L_BFu7i { unsigned char :0; long long v1; unsigned int v2:7; };
struct BFu0c_L_BFu7ll { unsigned char :0; long long v1; unsigned long long v2:7; };
struct BFu0c_L_BFu7s { unsigned char :0; long long v1; unsigned short v2:7; };
struct BFu0c_L_BFu8c { unsigned char :0; long long v1; unsigned char v2:8; };
struct BFu0c_L_BFu8i { unsigned char :0; long long v1; unsigned int v2:8; };
struct BFu0c_L_BFu8ll { unsigned char :0; long long v1; unsigned long long v2:8; };
struct BFu0c_L_BFu8s { unsigned char :0; long long v1; unsigned short v2:8; };
struct BFu0c_L_BFu9i { unsigned char :0; long long v1; unsigned int v2:9; };
struct BFu0c_L_BFu9ll { unsigned char :0; long long v1; unsigned long long v2:9; };
struct BFu0c_L_BFu9s { unsigned char :0; long long v1; unsigned short v2:9; };
struct BFu0c_L_C { unsigned char :0; long long v1; char v2; };
struct BFu0c_L_D { unsigned char :0; long long v1; double v2; };
struct BFu0c_L_F { unsigned char :0; long long v1; float v2; };
struct BFu0c_L_I { unsigned char :0; long long v1; int v2; };
struct BFu0c_L_Ip { unsigned char :0; long long v1; int * v2; };
struct BFu0c_L_L { unsigned char :0; long long v1; long long v2; };
struct BFu0c_L_S { unsigned char :0; long long v1; short v2; };
struct BFu0c_L_Uc { unsigned char :0; long long v1; unsigned char v2; };
struct BFu0c_L_Ui { unsigned char :0; long long v1; unsigned int v2; };
struct BFu0c_L_Ul { unsigned char :0; long long v1; unsigned long long v2; };
struct BFu0c_L_Us { unsigned char :0; long long v1; unsigned short v2; };
struct BFu0c_L_Vp { unsigned char :0; long long v1; void * v2; };
struct BFu0c_S { unsigned char :0; short v1; };
struct BFu0c_S_BFu0c { unsigned char :0; short v1; unsigned char :0; };
struct BFu0c_S_BFu0i { unsigned char :0; short v1; unsigned int :0; };
struct BFu0c_S_BFu0ll { unsigned char :0; short v1; unsigned long long :0; };
struct BFu0c_S_BFu0s { unsigned char :0; short v1; unsigned short :0; };
struct BFu0c_S_BFu15i { unsigned char :0; short v1; unsigned int v2:15; };
struct BFu0c_S_BFu15ll { unsigned char :0; short v1; unsigned long long v2:15; };
struct BFu0c_S_BFu15s { unsigned char :0; short v1; unsigned short v2:15; };
struct BFu0c_S_BFu16i { unsigned char :0; short v1; unsigned int v2:16; };
struct BFu0c_S_BFu16ll { unsigned char :0; short v1; unsigned long long v2:16; };
struct BFu0c_S_BFu16s { unsigned char :0; short v1; unsigned short v2:16; };
struct BFu0c_S_BFu17i { unsigned char :0; short v1; unsigned int v2:17; };
struct BFu0c_S_BFu17ll { unsigned char :0; short v1; unsigned long long v2:17; };
struct BFu0c_S_BFu1c { unsigned char :0; short v1; unsigned char v2:1; };
struct BFu0c_S_BFu1i { unsigned char :0; short v1; unsigned int v2:1; };
struct BFu0c_S_BFu1ll { unsigned char :0; short v1; unsigned long long v2:1; };
struct BFu0c_S_BFu1s { unsigned char :0; short v1; unsigned short v2:1; };
struct BFu0c_S_BFu31i { unsigned char :0; short v1; unsigned int v2:31; };
struct BFu0c_S_BFu31ll { unsigned char :0; short v1; unsigned long long v2:31; };
struct BFu0c_S_BFu32i { unsigned char :0; short v1; unsigned int v2:32; };
struct BFu0c_S_BFu32ll { unsigned char :0; short v1; unsigned long long v2:32; };
struct BFu0c_S_BFu33 { unsigned char :0; short v1; unsigned long long v2:33; };
struct BFu0c_S_BFu7c { unsigned char :0; short v1; unsigned char v2:7; };
struct BFu0c_S_BFu7i { unsigned char :0; short v1; unsigned int v2:7; };
struct BFu0c_S_BFu7ll { unsigned char :0; short v1; unsigned long long v2:7; };
struct BFu0c_S_BFu7s { unsigned char :0; short v1; unsigned short v2:7; };
struct BFu0c_S_BFu8c { unsigned char :0; short v1; unsigned char v2:8; };
struct BFu0c_S_BFu8i { unsigned char :0; short v1; unsigned int v2:8; };
struct BFu0c_S_BFu8ll { unsigned char :0; short v1; unsigned long long v2:8; };
struct BFu0c_S_BFu8s { unsigned char :0; short v1; unsigned short v2:8; };
struct BFu0c_S_BFu9i { unsigned char :0; short v1; unsigned int v2:9; };
struct BFu0c_S_BFu9ll { unsigned char :0; short v1; unsigned long long v2:9; };
struct BFu0c_S_BFu9s { unsigned char :0; short v1; unsigned short v2:9; };
struct BFu0c_S_C { unsigned char :0; short v1; char v2; };
struct BFu0c_S_D { unsigned char :0; short v1; double v2; };
struct BFu0c_S_F { unsigned char :0; short v1; float v2; };
struct BFu0c_S_I { unsigned char :0; short v1; int v2; };
struct BFu0c_S_Ip { unsigned char :0; short v1; int * v2; };
struct BFu0c_S_L { unsigned char :0; short v1; long long v2; };
struct BFu0c_S_S { unsigned char :0; short v1; short v2; };
struct BFu0c_S_Uc { unsigned char :0; short v1; unsigned char v2; };
struct BFu0c_S_Ui { unsigned char :0; short v1; unsigned int v2; };
struct BFu0c_S_Ul { unsigned char :0; short v1; unsigned long long v2; };
struct BFu0c_S_Us { unsigned char :0; short v1; unsigned short v2; };
struct BFu0c_S_Vp { unsigned char :0; short v1; void * v2; };
struct BFu0c_Uc { unsigned char :0; unsigned char v1; };
struct BFu0c_Uc_BFu0c { unsigned char :0; unsigned char v1; unsigned char :0; };
struct BFu0c_Uc_BFu0i { unsigned char :0; unsigned char v1; unsigned int :0; };
struct BFu0c_Uc_BFu0ll { unsigned char :0; unsigned char v1; unsigned long long :0; };
struct BFu0c_Uc_BFu0s { unsigned char :0; unsigned char v1; unsigned short :0; };
struct BFu0c_Uc_BFu15i { unsigned char :0; unsigned char v1; unsigned int v2:15; };
struct BFu0c_Uc_BFu15ll { unsigned char :0; unsigned char v1; unsigned long long v2:15; };
struct BFu0c_Uc_BFu15s { unsigned char :0; unsigned char v1; unsigned short v2:15; };
struct BFu0c_Uc_BFu16i { unsigned char :0; unsigned char v1; unsigned int v2:16; };
struct BFu0c_Uc_BFu16ll { unsigned char :0; unsigned char v1; unsigned long long v2:16; };
struct BFu0c_Uc_BFu16s { unsigned char :0; unsigned char v1; unsigned short v2:16; };
struct BFu0c_Uc_BFu17i { unsigned char :0; unsigned char v1; unsigned int v2:17; };
struct BFu0c_Uc_BFu17ll { unsigned char :0; unsigned char v1; unsigned long long v2:17; };
struct BFu0c_Uc_BFu1c { unsigned char :0; unsigned char v1; unsigned char v2:1; };
struct BFu0c_Uc_BFu1i { unsigned char :0; unsigned char v1; unsigned int v2:1; };
struct BFu0c_Uc_BFu1ll { unsigned char :0; unsigned char v1; unsigned long long v2:1; };
struct BFu0c_Uc_BFu1s { unsigned char :0; unsigned char v1; unsigned short v2:1; };
struct BFu0c_Uc_BFu31i { unsigned char :0; unsigned char v1; unsigned int v2:31; };
struct BFu0c_Uc_BFu31ll { unsigned char :0; unsigned char v1; unsigned long long v2:31; };
struct BFu0c_Uc_BFu32i { unsigned char :0; unsigned char v1; unsigned int v2:32; };
struct BFu0c_Uc_BFu32ll { unsigned char :0; unsigned char v1; unsigned long long v2:32; };
struct BFu0c_Uc_BFu33 { unsigned char :0; unsigned char v1; unsigned long long v2:33; };
struct BFu0c_Uc_BFu7c { unsigned char :0; unsigned char v1; unsigned char v2:7; };
struct BFu0c_Uc_BFu7i { unsigned char :0; unsigned char v1; unsigned int v2:7; };
struct BFu0c_Uc_BFu7ll { unsigned char :0; unsigned char v1; unsigned long long v2:7; };
struct BFu0c_Uc_BFu7s { unsigned char :0; unsigned char v1; unsigned short v2:7; };
struct BFu0c_Uc_BFu8c { unsigned char :0; unsigned char v1; unsigned char v2:8; };
struct BFu0c_Uc_BFu8i { unsigned char :0; unsigned char v1; unsigned int v2:8; };
struct BFu0c_Uc_BFu8ll { unsigned char :0; unsigned char v1; unsigned long long v2:8; };
struct BFu0c_Uc_BFu8s { unsigned char :0; unsigned char v1; unsigned short v2:8; };
struct BFu0c_Uc_BFu9i { unsigned char :0; unsigned char v1; unsigned int v2:9; };
struct BFu0c_Uc_BFu9ll { unsigned char :0; unsigned char v1; unsigned long long v2:9; };
struct BFu0c_Uc_BFu9s { unsigned char :0; unsigned char v1; unsigned short v2:9; };
struct BFu0c_Uc_C { unsigned char :0; unsigned char v1; char v2; };
struct BFu0c_Uc_D { unsigned char :0; unsigned char v1; double v2; };
struct BFu0c_Uc_F { unsigned char :0; unsigned char v1; float v2; };
struct BFu0c_Uc_I { unsigned char :0; unsigned char v1; int v2; };
struct BFu0c_Uc_Ip { unsigned char :0; unsigned char v1; int * v2; };
struct BFu0c_Uc_L { unsigned char :0; unsigned char v1; long long v2; };
struct BFu0c_Uc_S { unsigned char :0; unsigned char v1; short v2; };
struct BFu0c_Uc_Uc { unsigned char :0; unsigned char v1; unsigned char v2; };
struct BFu0c_Uc_Ui { unsigned char :0; unsigned char v1; unsigned int v2; };
struct BFu0c_Uc_Ul { unsigned char :0; unsigned char v1; unsigned long long v2; };
struct BFu0c_Uc_Us { unsigned char :0; unsigned char v1; unsigned short v2; };
struct BFu0c_Uc_Vp { unsigned char :0; unsigned char v1; void * v2; };
struct BFu0c_Ui { unsigned char :0; unsigned int v1; };
struct BFu0c_Ui_BFu0c { unsigned char :0; unsigned int v1; unsigned char :0; };
struct BFu0c_Ui_BFu0i { unsigned char :0; unsigned int v1; unsigned int :0; };
struct BFu0c_Ui_BFu0ll { unsigned char :0; unsigned int v1; unsigned long long :0; };
struct BFu0c_Ui_BFu0s { unsigned char :0; unsigned int v1; unsigned short :0; };
struct BFu0c_Ui_BFu15i { unsigned char :0; unsigned int v1; unsigned int v2:15; };
struct BFu0c_Ui_BFu15ll { unsigned char :0; unsigned int v1; unsigned long long v2:15; };
struct BFu0c_Ui_BFu15s { unsigned char :0; unsigned int v1; unsigned short v2:15; };
struct BFu0c_Ui_BFu16i { unsigned char :0; unsigned int v1; unsigned int v2:16; };
struct BFu0c_Ui_BFu16ll { unsigned char :0; unsigned int v1; unsigned long long v2:16; };
struct BFu0c_Ui_BFu16s { unsigned char :0; unsigned int v1; unsigned short v2:16; };
struct BFu0c_Ui_BFu17i { unsigned char :0; unsigned int v1; unsigned int v2:17; };
struct BFu0c_Ui_BFu17ll { unsigned char :0; unsigned int v1; unsigned long long v2:17; };
struct BFu0c_Ui_BFu1c { unsigned char :0; unsigned int v1; unsigned char v2:1; };
struct BFu0c_Ui_BFu1i { unsigned char :0; unsigned int v1; unsigned int v2:1; };
struct BFu0c_Ui_BFu1ll { unsigned char :0; unsigned int v1; unsigned long long v2:1; };
struct BFu0c_Ui_BFu1s { unsigned char :0; unsigned int v1; unsigned short v2:1; };
struct BFu0c_Ui_BFu31i { unsigned char :0; unsigned int v1; unsigned int v2:31; };
struct BFu0c_Ui_BFu31ll { unsigned char :0; unsigned int v1; unsigned long long v2:31; };
struct BFu0c_Ui_BFu32i { unsigned char :0; unsigned int v1; unsigned int v2:32; };
struct BFu0c_Ui_BFu32ll { unsigned char :0; unsigned int v1; unsigned long long v2:32; };
struct BFu0c_Ui_BFu33 { unsigned char :0; unsigned int v1; unsigned long long v2:33; };
struct BFu0c_Ui_BFu7c { unsigned char :0; unsigned int v1; unsigned char v2:7; };
struct BFu0c_Ui_BFu7i { unsigned char :0; unsigned int v1; unsigned int v2:7; };
struct BFu0c_Ui_BFu7ll { unsigned char :0; unsigned int v1; unsigned long long v2:7; };
struct BFu0c_Ui_BFu7s { unsigned char :0; unsigned int v1; unsigned short v2:7; };
struct BFu0c_Ui_BFu8c { unsigned char :0; unsigned int v1; unsigned char v2:8; };
struct BFu0c_Ui_BFu8i { unsigned char :0; unsigned int v1; unsigned int v2:8; };
struct BFu0c_Ui_BFu8ll { unsigned char :0; unsigned int v1; unsigned long long v2:8; };
struct BFu0c_Ui_BFu8s { unsigned char :0; unsigned int v1; unsigned short v2:8; };
struct BFu0c_Ui_BFu9i { unsigned char :0; unsigned int v1; unsigned int v2:9; };
struct BFu0c_Ui_BFu9ll { unsigned char :0; unsigned int v1; unsigned long long v2:9; };
struct BFu0c_Ui_BFu9s { unsigned char :0; unsigned int v1; unsigned short v2:9; };
struct BFu0c_Ui_C { unsigned char :0; unsigned int v1; char v2; };
struct BFu0c_Ui_D { unsigned char :0; unsigned int v1; double v2; };
struct BFu0c_Ui_F { unsigned char :0; unsigned int v1; float v2; };
struct BFu0c_Ui_I { unsigned char :0; unsigned int v1; int v2; };
struct BFu0c_Ui_Ip { unsigned char :0; unsigned int v1; int * v2; };
struct BFu0c_Ui_L { unsigned char :0; unsigned int v1; long long v2; };
struct BFu0c_Ui_S { unsigned char :0; unsigned int v1; short v2; };
struct BFu0c_Ui_Uc { unsigned char :0; unsigned int v1; unsigned char v2; };
struct BFu0c_Ui_Ui { unsigned char :0; unsigned int v1; unsigned int v2; };
struct BFu0c_Ui_Ul { unsigned char :0; unsigned int v1; unsigned long long v2; };
struct BFu0c_Ui_Us { unsigned char :0; unsigned int v1; unsigned short v2; };
struct BFu0c_Ui_Vp { unsigned char :0; unsigned int v1; void * v2; };
struct BFu0c_Ul { unsigned char :0; unsigned long long v1; };
struct BFu0c_Ul_BFu0c { unsigned char :0; unsigned long long v1; unsigned char :0; };
struct BFu0c_Ul_BFu0i { unsigned char :0; unsigned long long v1; unsigned int :0; };
struct BFu0c_Ul_BFu0ll { unsigned char :0; unsigned long long v1; unsigned long long :0; };
struct BFu0c_Ul_BFu0s { unsigned char :0; unsigned long long v1; unsigned short :0; };
struct BFu0c_Ul_BFu15i { unsigned char :0; unsigned long long v1; unsigned int v2:15; };
struct BFu0c_Ul_BFu15ll { unsigned char :0; unsigned long long v1; unsigned long long v2:15; };
struct BFu0c_Ul_BFu15s { unsigned char :0; unsigned long long v1; unsigned short v2:15; };
struct BFu0c_Ul_BFu16i { unsigned char :0; unsigned long long v1; unsigned int v2:16; };
struct BFu0c_Ul_BFu16ll { unsigned char :0; unsigned long long v1; unsigned long long v2:16; };
struct BFu0c_Ul_BFu16s { unsigned char :0; unsigned long long v1; unsigned short v2:16; };
struct BFu0c_Ul_BFu17i { unsigned char :0; unsigned long long v1; unsigned int v2:17; };
struct BFu0c_Ul_BFu17ll { unsigned char :0; unsigned long long v1; unsigned long long v2:17; };
struct BFu0c_Ul_BFu1c { unsigned char :0; unsigned long long v1; unsigned char v2:1; };
struct BFu0c_Ul_BFu1i { unsigned char :0; unsigned long long v1; unsigned int v2:1; };
struct BFu0c_Ul_BFu1ll { unsigned char :0; unsigned long long v1; unsigned long long v2:1; };
struct BFu0c_Ul_BFu1s { unsigned char :0; unsigned long long v1; unsigned short v2:1; };
struct BFu0c_Ul_BFu31i { unsigned char :0; unsigned long long v1; unsigned int v2:31; };
struct BFu0c_Ul_BFu31ll { unsigned char :0; unsigned long long v1; unsigned long long v2:31; };
struct BFu0c_Ul_BFu32i { unsigned char :0; unsigned long long v1; unsigned int v2:32; };
struct BFu0c_Ul_BFu32ll { unsigned char :0; unsigned long long v1; unsigned long long v2:32; };
struct BFu0c_Ul_BFu33 { unsigned char :0; unsigned long long v1; unsigned long long v2:33; };
struct BFu0c_Ul_BFu7c { unsigned char :0; unsigned long long v1; unsigned char v2:7; };
struct BFu0c_Ul_BFu7i { unsigned char :0; unsigned long long v1; unsigned int v2:7; };
struct BFu0c_Ul_BFu7ll { unsigned char :0; unsigned long long v1; unsigned long long v2:7; };
struct BFu0c_Ul_BFu7s { unsigned char :0; unsigned long long v1; unsigned short v2:7; };
struct BFu0c_Ul_BFu8c { unsigned char :0; unsigned long long v1; unsigned char v2:8; };
struct BFu0c_Ul_BFu8i { unsigned char :0; unsigned long long v1; unsigned int v2:8; };
struct BFu0c_Ul_BFu8ll { unsigned char :0; unsigned long long v1; unsigned long long v2:8; };
struct BFu0c_Ul_BFu8s { unsigned char :0; unsigned long long v1; unsigned short v2:8; };
struct BFu0c_Ul_BFu9i { unsigned char :0; unsigned long long v1; unsigned int v2:9; };
struct BFu0c_Ul_BFu9ll { unsigned char :0; unsigned long long v1; unsigned long long v2:9; };
struct BFu0c_Ul_BFu9s { unsigned char :0; unsigned long long v1; unsigned short v2:9; };
struct BFu0c_Ul_C { unsigned char :0; unsigned long long v1; char v2; };
struct BFu0c_Ul_D { unsigned char :0; unsigned long long v1; double v2; };
struct BFu0c_Ul_F { unsigned char :0; unsigned long long v1; float v2; };
struct BFu0c_Ul_I { unsigned char :0; unsigned long long v1; int v2; };
struct BFu0c_Ul_Ip { unsigned char :0; unsigned long long v1; int * v2; };
struct BFu0c_Ul_L { unsigned char :0; unsigned long long v1; long long v2; };
struct BFu0c_Ul_S { unsigned char :0; unsigned long long v1; short v2; };
struct BFu0c_Ul_Uc { unsigned char :0; unsigned long long v1; unsigned char v2; };
struct BFu0c_Ul_Ui { unsigned char :0; unsigned long long v1; unsigned int v2; };
struct BFu0c_Ul_Ul { unsigned char :0; unsigned long long v1; unsigned long long v2; };
struct BFu0c_Ul_Us { unsigned char :0; unsigned long long v1; unsigned short v2; };
struct BFu0c_Ul_Vp { unsigned char :0; unsigned long long v1; void * v2; };
struct BFu0c_Us { unsigned char :0; unsigned short v1; };
struct BFu0c_Us_BFu0c { unsigned char :0; unsigned short v1; unsigned char :0; };
struct BFu0c_Us_BFu0i { unsigned char :0; unsigned short v1; unsigned int :0; };
struct BFu0c_Us_BFu0ll { unsigned char :0; unsigned short v1; unsigned long long :0; };
struct BFu0c_Us_BFu0s { unsigned char :0; unsigned short v1; unsigned short :0; };
struct BFu0c_Us_BFu15i { unsigned char :0; unsigned short v1; unsigned int v2:15; };
struct BFu0c_Us_BFu15ll { unsigned char :0; unsigned short v1; unsigned long long v2:15; };
struct BFu0c_Us_BFu15s { unsigned char :0; unsigned short v1; unsigned short v2:15; };
struct BFu0c_Us_BFu16i { unsigned char :0; unsigned short v1; unsigned int v2:16; };
struct BFu0c_Us_BFu16ll { unsigned char :0; unsigned short v1; unsigned long long v2:16; };
struct BFu0c_Us_BFu16s { unsigned char :0; unsigned short v1; unsigned short v2:16; };
struct BFu0c_Us_BFu17i { unsigned char :0; unsigned short v1; unsigned int v2:17; };
struct BFu0c_Us_BFu17ll { unsigned char :0; unsigned short v1; unsigned long long v2:17; };
struct BFu0c_Us_BFu1c { unsigned char :0; unsigned short v1; unsigned char v2:1; };
struct BFu0c_Us_BFu1i { unsigned char :0; unsigned short v1; unsigned int v2:1; };
struct BFu0c_Us_BFu1ll { unsigned char :0; unsigned short v1; unsigned long long v2:1; };
struct BFu0c_Us_BFu1s { unsigned char :0; unsigned short v1; unsigned short v2:1; };
struct BFu0c_Us_BFu31i { unsigned char :0; unsigned short v1; unsigned int v2:31; };
struct BFu0c_Us_BFu31ll { unsigned char :0; unsigned short v1; unsigned long long v2:31; };
struct BFu0c_Us_BFu32i { unsigned char :0; unsigned short v1; unsigned int v2:32; };
struct BFu0c_Us_BFu32ll { unsigned char :0; unsigned short v1; unsigned long long v2:32; };
struct BFu0c_Us_BFu33 { unsigned char :0; unsigned short v1; unsigned long long v2:33; };
struct BFu0c_Us_BFu7c { unsigned char :0; unsigned short v1; unsigned char v2:7; };
struct BFu0c_Us_BFu7i { unsigned char :0; unsigned short v1; unsigned int v2:7; };
struct BFu0c_Us_BFu7ll { unsigned char :0; unsigned short v1; unsigned long long v2:7; };
struct BFu0c_Us_BFu7s { unsigned char :0; unsigned short v1; unsigned short v2:7; };
struct BFu0c_Us_BFu8c { unsigned char :0; unsigned short v1; unsigned char v2:8; };
struct BFu0c_Us_BFu8i { unsigned char :0; unsigned short v1; unsigned int v2:8; };
struct BFu0c_Us_BFu8ll { unsigned char :0; unsigned short v1; unsigned long long v2:8; };
struct BFu0c_Us_BFu8s { unsigned char :0; unsigned short v1; unsigned short v2:8; };
struct BFu0c_Us_BFu9i { unsigned char :0; unsigned short v1; unsigned int v2:9; };
struct BFu0c_Us_BFu9ll { unsigned char :0; unsigned short v1; unsigned long long v2:9; };
struct BFu0c_Us_BFu9s { unsigned char :0; unsigned short v1; unsigned short v2:9; };
struct BFu0c_Us_C { unsigned char :0; unsigned short v1; char v2; };
struct BFu0c_Us_D { unsigned char :0; unsigned short v1; double v2; };
struct BFu0c_Us_F { unsigned char :0; unsigned short v1; float v2; };
struct BFu0c_Us_I { unsigned char :0; unsigned short v1; int v2; };
struct BFu0c_Us_Ip { unsigned char :0; unsigned short v1; int * v2; };
struct BFu0c_Us_L { unsigned char :0; unsigned short v1; long long v2; };
struct BFu0c_Us_S { unsigned char :0; unsigned short v1; short v2; };
struct BFu0c_Us_Uc { unsigned char :0; unsigned short v1; unsigned char v2; };
struct BFu0c_Us_Ui { unsigned char :0; unsigned short v1; unsigned int v2; };
struct BFu0c_Us_Ul { unsigned char :0; unsigned short v1; unsigned long long v2; };
struct BFu0c_Us_Us { unsigned char :0; unsigned short v1; unsigned short v2; };
struct BFu0c_Us_Vp { unsigned char :0; unsigned short v1; void * v2; };
struct BFu0c_Vp { unsigned char :0; void * v1; };
struct BFu0c_Vp_BFu0c { unsigned char :0; void * v1; unsigned char :0; };
struct BFu0c_Vp_BFu0i { unsigned char :0; void * v1; unsigned int :0; };
struct BFu0c_Vp_BFu0ll { unsigned char :0; void * v1; unsigned long long :0; };
struct BFu0c_Vp_BFu0s { unsigned char :0; void * v1; unsigned short :0; };
struct BFu0c_Vp_BFu15i { unsigned char :0; void * v1; unsigned int v2:15; };
struct BFu0c_Vp_BFu15ll { unsigned char :0; void * v1; unsigned long long v2:15; };
struct BFu0c_Vp_BFu15s { unsigned char :0; void * v1; unsigned short v2:15; };
struct BFu0c_Vp_BFu16i { unsigned char :0; void * v1; unsigned int v2:16; };
struct BFu0c_Vp_BFu16ll { unsigned char :0; void * v1; unsigned long long v2:16; };
struct BFu0c_Vp_BFu16s { unsigned char :0; void * v1; unsigned short v2:16; };
struct BFu0c_Vp_BFu17i { unsigned char :0; void * v1; unsigned int v2:17; };
struct BFu0c_Vp_BFu17ll { unsigned char :0; void * v1; unsigned long long v2:17; };
struct BFu0c_Vp_BFu1c { unsigned char :0; void * v1; unsigned char v2:1; };
struct BFu0c_Vp_BFu1i { unsigned char :0; void * v1; unsigned int v2:1; };
struct BFu0c_Vp_BFu1ll { unsigned char :0; void * v1; unsigned long long v2:1; };
struct BFu0c_Vp_BFu1s { unsigned char :0; void * v1; unsigned short v2:1; };
struct BFu0c_Vp_BFu31i { unsigned char :0; void * v1; unsigned int v2:31; };
struct BFu0c_Vp_BFu31ll { unsigned char :0; void * v1; unsigned long long v2:31; };
struct BFu0c_Vp_BFu32i { unsigned char :0; void * v1; unsigned int v2:32; };
struct BFu0c_Vp_BFu32ll { unsigned char :0; void * v1; unsigned long long v2:32; };
struct BFu0c_Vp_BFu33 { unsigned char :0; void * v1; unsigned long long v2:33; };
struct BFu0c_Vp_BFu7c { unsigned char :0; void * v1; unsigned char v2:7; };
struct BFu0c_Vp_BFu7i { unsigned char :0; void * v1; unsigned int v2:7; };
struct BFu0c_Vp_BFu7ll { unsigned char :0; void * v1; unsigned long long v2:7; };
struct BFu0c_Vp_BFu7s { unsigned char :0; void * v1; unsigned short v2:7; };
struct BFu0c_Vp_BFu8c { unsigned char :0; void * v1; unsigned char v2:8; };
struct BFu0c_Vp_BFu8i { unsigned char :0; void * v1; unsigned int v2:8; };
struct BFu0c_Vp_BFu8ll { unsigned char :0; void * v1; unsigned long long v2:8; };
struct BFu0c_Vp_BFu8s { unsigned char :0; void * v1; unsigned short v2:8; };
struct BFu0c_Vp_BFu9i { unsigned char :0; void * v1; unsigned int v2:9; };
struct BFu0c_Vp_BFu9ll { unsigned char :0; void * v1; unsigned long long v2:9; };
struct BFu0c_Vp_BFu9s { unsigned char :0; void * v1; unsigned short v2:9; };
struct BFu0c_Vp_C { unsigned char :0; void * v1; char v2; };
struct BFu0c_Vp_D { unsigned char :0; void * v1; double v2; };
struct BFu0c_Vp_F { unsigned char :0; void * v1; float v2; };
struct BFu0c_Vp_I { unsigned char :0; void * v1; int v2; };
struct BFu0c_Vp_Ip { unsigned char :0; void * v1; int * v2; };
struct BFu0c_Vp_L { unsigned char :0; void * v1; long long v2; };
struct BFu0c_Vp_S { unsigned char :0; void * v1; short v2; };
struct BFu0c_Vp_Uc { unsigned char :0; void * v1; unsigned char v2; };
struct BFu0c_Vp_Ui { unsigned char :0; void * v1; unsigned int v2; };
struct BFu0c_Vp_Ul { unsigned char :0; void * v1; unsigned long long v2; };
struct BFu0c_Vp_Us { unsigned char :0; void * v1; unsigned short v2; };
struct BFu0c_Vp_Vp { unsigned char :0; void * v1; void * v2; };
struct BFu0i { unsigned int :0; };
struct BFu0i_BFs0c { unsigned int :0; signed char :0; };
struct BFu0i_BFs0c_BFs0c { unsigned int :0; signed char :0; signed char :0; };
struct BFu0i_BFs0c_BFs0c_BFs0c { unsigned int :0; signed char :0; signed char :0; signed char :0; };
struct BFu0i_BFs0c_BFs0c_BFs0i { unsigned int :0; signed char :0; signed char :0; signed int :0; };
struct BFu0i_BFs0c_BFs0c_BFs0ll { unsigned int :0; signed char :0; signed char :0; signed long long :0; };
struct BFu0i_BFs0c_BFs0c_BFs0s { unsigned int :0; signed char :0; signed char :0; signed short :0; };
struct BFu0i_BFs0c_BFs0c_BFu0c { unsigned int :0; signed char :0; signed char :0; unsigned char :0; };
struct BFu0i_BFs0c_BFs0c_BFu0i { unsigned int :0; signed char :0; signed char :0; unsigned int :0; };
struct BFu0i_BFs0c_BFs0c_BFu0ll { unsigned int :0; signed char :0; signed char :0; unsigned long long :0; };
struct BFu0i_BFs0c_BFs0c_BFu0s { unsigned int :0; signed char :0; signed char :0; unsigned short :0; };
struct BFu0i_BFs0c_BFs0i { unsigned int :0; signed char :0; signed int :0; };
struct BFu0i_BFs0c_BFs0i_BFs0c { unsigned int :0; signed char :0; signed int :0; signed char :0; };
struct BFu0i_BFs0c_BFs0i_BFs0i { unsigned int :0; signed char :0; signed int :0; signed int :0; };
struct BFu0i_BFs0c_BFs0i_BFs0ll { unsigned int :0; signed char :0; signed int :0; signed long long :0; };
struct BFu0i_BFs0c_BFs0i_BFs0s { unsigned int :0; signed char :0; signed int :0; signed short :0; };
struct BFu0i_BFs0c_BFs0i_BFu0c { unsigned int :0; signed char :0; signed int :0; unsigned char :0; };
struct BFu0i_BFs0c_BFs0i_BFu0i { unsigned int :0; signed char :0; signed int :0; unsigned int :0; };
struct BFu0i_BFs0c_BFs0i_BFu0ll { unsigned int :0; signed char :0; signed int :0; unsigned long long :0; };
struct BFu0i_BFs0c_BFs0i_BFu0s { unsigned int :0; signed char :0; signed int :0; unsigned short :0; };
struct BFu0i_BFs0c_BFs0ll { unsigned int :0; signed char :0; signed long long :0; };
struct BFu0i_BFs0c_BFs0ll_BFs0c { unsigned int :0; signed char :0; signed long long :0; signed char :0; };
struct BFu0i_BFs0c_BFs0ll_BFs0i { unsigned int :0; signed char :0; signed long long :0; signed int :0; };
struct BFu0i_BFs0c_BFs0ll_BFs0ll { unsigned int :0; signed char :0; signed long long :0; signed long long :0; };
struct BFu0i_BFs0c_BFs0ll_BFs0s { unsigned int :0; signed char :0; signed long long :0; signed short :0; };
struct BFu0i_BFs0c_BFs0ll_BFu0c { unsigned int :0; signed char :0; signed long long :0; unsigned char :0; };
struct BFu0i_BFs0c_BFs0ll_BFu0i { unsigned int :0; signed char :0; signed long long :0; unsigned int :0; };
struct BFu0i_BFs0c_BFs0ll_BFu0ll { unsigned int :0; signed char :0; signed long long :0; unsigned long long :0; };
struct BFu0i_BFs0c_BFs0ll_BFu0s { unsigned int :0; signed char :0; signed long long :0; unsigned short :0; };
struct BFu0i_BFs0c_BFs0s { unsigned int :0; signed char :0; signed short :0; };
struct BFu0i_BFs0c_BFs0s_BFs0c { unsigned int :0; signed char :0; signed short :0; signed char :0; };
struct BFu0i_BFs0c_BFs0s_BFs0i { unsigned int :0; signed char :0; signed short :0; signed int :0; };
struct BFu0i_BFs0c_BFs0s_BFs0ll { unsigned int :0; signed char :0; signed short :0; signed long long :0; };
struct BFu0i_BFs0c_BFs0s_BFs0s { unsigned int :0; signed char :0; signed short :0; signed short :0; };
struct BFu0i_BFs0c_BFs0s_BFu0c { unsigned int :0; signed char :0; signed short :0; unsigned char :0; };
struct BFu0i_BFs0c_BFs0s_BFu0i { unsigned int :0; signed char :0; signed short :0; unsigned int :0; };
struct BFu0i_BFs0c_BFs0s_BFu0ll { unsigned int :0; signed char :0; signed short :0; unsigned long long :0; };
struct BFu0i_BFs0c_BFs0s_BFu0s { unsigned int :0; signed char :0; signed short :0; unsigned short :0; };
struct BFu0i_BFs0c_BFu0c { unsigned int :0; signed char :0; unsigned char :0; };
struct BFu0i_BFs0c_BFu0c_BFs0c { unsigned int :0; signed char :0; unsigned char :0; signed char :0; };
struct BFu0i_BFs0c_BFu0c_BFs0i { unsigned int :0; signed char :0; unsigned char :0; signed int :0; };
struct BFu0i_BFs0c_BFu0c_BFs0ll { unsigned int :0; signed char :0; unsigned char :0; signed long long :0; };
struct BFu0i_BFs0c_BFu0c_BFs0s { unsigned int :0; signed char :0; unsigned char :0; signed short :0; };
struct BFu0i_BFs0c_BFu0c_BFu0c { unsigned int :0; signed char :0; unsigned char :0; unsigned char :0; };
struct BFu0i_BFs0c_BFu0c_BFu0i { unsigned int :0; signed char :0; unsigned char :0; unsigned int :0; };
struct BFu0i_BFs0c_BFu0c_BFu0ll { unsigned int :0; signed char :0; unsigned char :0; unsigned long long :0; };
struct BFu0i_BFs0c_BFu0c_BFu0s { unsigned int :0; signed char :0; unsigned char :0; unsigned short :0; };
struct BFu0i_BFs0c_BFu0i { unsigned int :0; signed char :0; unsigned int :0; };
struct BFu0i_BFs0c_BFu0i_BFs0c { unsigned int :0; signed char :0; unsigned int :0; signed char :0; };
struct BFu0i_BFs0c_BFu0i_BFs0i { unsigned int :0; signed char :0; unsigned int :0; signed int :0; };
struct BFu0i_BFs0c_BFu0i_BFs0ll { unsigned int :0; signed char :0; unsigned int :0; signed long long :0; };
struct BFu0i_BFs0c_BFu0i_BFs0s { unsigned int :0; signed char :0; unsigned int :0; signed short :0; };
struct BFu0i_BFs0c_BFu0i_BFu0c { unsigned int :0; signed char :0; unsigned int :0; unsigned char :0; };
struct BFu0i_BFs0c_BFu0i_BFu0i { unsigned int :0; signed char :0; unsigned int :0; unsigned int :0; };
struct BFu0i_BFs0c_BFu0i_BFu0ll { unsigned int :0; signed char :0; unsigned int :0; unsigned long long :0; };
struct BFu0i_BFs0c_BFu0i_BFu0s { unsigned int :0; signed char :0; unsigned int :0; unsigned short :0; };
struct BFu0i_BFs0c_BFu0ll { unsigned int :0; signed char :0; unsigned long long :0; };
struct BFu0i_BFs0c_BFu0ll_BFs0c { unsigned int :0; signed char :0; unsigned long long :0; signed char :0; };
struct BFu0i_BFs0c_BFu0ll_BFs0i { unsigned int :0; signed char :0; unsigned long long :0; signed int :0; };
struct BFu0i_BFs0c_BFu0ll_BFs0ll { unsigned int :0; signed char :0; unsigned long long :0; signed long long :0; };
struct BFu0i_BFs0c_BFu0ll_BFs0s { unsigned int :0; signed char :0; unsigned long long :0; signed short :0; };
struct BFu0i_BFs0c_BFu0ll_BFu0c { unsigned int :0; signed char :0; unsigned long long :0; unsigned char :0; };
struct BFu0i_BFs0c_BFu0ll_BFu0i { unsigned int :0; signed char :0; unsigned long long :0; unsigned int :0; };
struct BFu0i_BFs0c_BFu0ll_BFu0ll { unsigned int :0; signed char :0; unsigned long long :0; unsigned long long :0; };
struct BFu0i_BFs0c_BFu0ll_BFu0s { unsigned int :0; signed char :0; unsigned long long :0; unsigned short :0; };
struct BFu0i_BFs0c_BFu0s { unsigned int :0; signed char :0; unsigned short :0; };
struct BFu0i_BFs0c_BFu0s_BFs0c { unsigned int :0; signed char :0; unsigned short :0; signed char :0; };
struct BFu0i_BFs0c_BFu0s_BFs0i { unsigned int :0; signed char :0; unsigned short :0; signed int :0; };
struct BFu0i_BFs0c_BFu0s_BFs0ll { unsigned int :0; signed char :0; unsigned short :0; signed long long :0; };
struct BFu0i_BFs0c_BFu0s_BFs0s { unsigned int :0; signed char :0; unsigned short :0; signed short :0; };
struct BFu0i_BFs0c_BFu0s_BFu0c { unsigned int :0; signed char :0; unsigned short :0; unsigned char :0; };
struct BFu0i_BFs0c_BFu0s_BFu0i { unsigned int :0; signed char :0; unsigned short :0; unsigned int :0; };
struct BFu0i_BFs0c_BFu0s_BFu0ll { unsigned int :0; signed char :0; unsigned short :0; unsigned long long :0; };
struct BFu0i_BFs0c_BFu0s_BFu0s { unsigned int :0; signed char :0; unsigned short :0; unsigned short :0; };
struct BFu0i_BFs0i { unsigned int :0; signed int :0; };
struct BFu0i_BFs0i_BFs0c { unsigned int :0; signed int :0; signed char :0; };
struct BFu0i_BFs0i_BFs0c_BFs0c { unsigned int :0; signed int :0; signed char :0; signed char :0; };
struct BFu0i_BFs0i_BFs0c_BFs0i { unsigned int :0; signed int :0; signed char :0; signed int :0; };
struct BFu0i_BFs0i_BFs0c_BFs0ll { unsigned int :0; signed int :0; signed char :0; signed long long :0; };
struct BFu0i_BFs0i_BFs0c_BFs0s { unsigned int :0; signed int :0; signed char :0; signed short :0; };
struct BFu0i_BFs0i_BFs0c_BFu0c { unsigned int :0; signed int :0; signed char :0; unsigned char :0; };
struct BFu0i_BFs0i_BFs0c_BFu0i { unsigned int :0; signed int :0; signed char :0; unsigned int :0; };
struct BFu0i_BFs0i_BFs0c_BFu0ll { unsigned int :0; signed int :0; signed char :0; unsigned long long :0; };
struct BFu0i_BFs0i_BFs0c_BFu0s { unsigned int :0; signed int :0; signed char :0; unsigned short :0; };
struct BFu0i_BFs0i_BFs0i { unsigned int :0; signed int :0; signed int :0; };
struct BFu0i_BFs0i_BFs0i_BFs0c { unsigned int :0; signed int :0; signed int :0; signed char :0; };
struct BFu0i_BFs0i_BFs0i_BFs0i { unsigned int :0; signed int :0; signed int :0; signed int :0; };
struct BFu0i_BFs0i_BFs0i_BFs0ll { unsigned int :0; signed int :0; signed int :0; signed long long :0; };
struct BFu0i_BFs0i_BFs0i_BFs0s { unsigned int :0; signed int :0; signed int :0; signed short :0; };
struct BFu0i_BFs0i_BFs0i_BFu0c { unsigned int :0; signed int :0; signed int :0; unsigned char :0; };
struct BFu0i_BFs0i_BFs0i_BFu0i { unsigned int :0; signed int :0; signed int :0; unsigned int :0; };
struct BFu0i_BFs0i_BFs0i_BFu0ll { unsigned int :0; signed int :0; signed int :0; unsigned long long :0; };
struct BFu0i_BFs0i_BFs0i_BFu0s { unsigned int :0; signed int :0; signed int :0; unsigned short :0; };
struct BFu0i_BFs0i_BFs0ll { unsigned int :0; signed int :0; signed long long :0; };
struct BFu0i_BFs0i_BFs0ll_BFs0c { unsigned int :0; signed int :0; signed long long :0; signed char :0; };
struct BFu0i_BFs0i_BFs0ll_BFs0i { unsigned int :0; signed int :0; signed long long :0; signed int :0; };
struct BFu0i_BFs0i_BFs0ll_BFs0ll { unsigned int :0; signed int :0; signed long long :0; signed long long :0; };
struct BFu0i_BFs0i_BFs0ll_BFs0s { unsigned int :0; signed int :0; signed long long :0; signed short :0; };
struct BFu0i_BFs0i_BFs0ll_BFu0c { unsigned int :0; signed int :0; signed long long :0; unsigned char :0; };
struct BFu0i_BFs0i_BFs0ll_BFu0i { unsigned int :0; signed int :0; signed long long :0; unsigned int :0; };
struct BFu0i_BFs0i_BFs0ll_BFu0ll { unsigned int :0; signed int :0; signed long long :0; unsigned long long :0; };
struct BFu0i_BFs0i_BFs0ll_BFu0s { unsigned int :0; signed int :0; signed long long :0; unsigned short :0; };
struct BFu0i_BFs0i_BFs0s { unsigned int :0; signed int :0; signed short :0; };
struct BFu0i_BFs0i_BFs0s_BFs0c { unsigned int :0; signed int :0; signed short :0; signed char :0; };
struct BFu0i_BFs0i_BFs0s_BFs0i { unsigned int :0; signed int :0; signed short :0; signed int :0; };
struct BFu0i_BFs0i_BFs0s_BFs0ll { unsigned int :0; signed int :0; signed short :0; signed long long :0; };
struct BFu0i_BFs0i_BFs0s_BFs0s { unsigned int :0; signed int :0; signed short :0; signed short :0; };
struct BFu0i_BFs0i_BFs0s_BFu0c { unsigned int :0; signed int :0; signed short :0; unsigned char :0; };
struct BFu0i_BFs0i_BFs0s_BFu0i { unsigned int :0; signed int :0; signed short :0; unsigned int :0; };
struct BFu0i_BFs0i_BFs0s_BFu0ll { unsigned int :0; signed int :0; signed short :0; unsigned long long :0; };
struct BFu0i_BFs0i_BFs0s_BFu0s { unsigned int :0; signed int :0; signed short :0; unsigned short :0; };
struct BFu0i_BFs0i_BFu0c { unsigned int :0; signed int :0; unsigned char :0; };
struct BFu0i_BFs0i_BFu0c_BFs0c { unsigned int :0; signed int :0; unsigned char :0; signed char :0; };
struct BFu0i_BFs0i_BFu0c_BFs0i { unsigned int :0; signed int :0; unsigned char :0; signed int :0; };
struct BFu0i_BFs0i_BFu0c_BFs0ll { unsigned int :0; signed int :0; unsigned char :0; signed long long :0; };
struct BFu0i_BFs0i_BFu0c_BFs0s { unsigned int :0; signed int :0; unsigned char :0; signed short :0; };
struct BFu0i_BFs0i_BFu0c_BFu0c { unsigned int :0; signed int :0; unsigned char :0; unsigned char :0; };
struct BFu0i_BFs0i_BFu0c_BFu0i { unsigned int :0; signed int :0; unsigned char :0; unsigned int :0; };
struct BFu0i_BFs0i_BFu0c_BFu0ll { unsigned int :0; signed int :0; unsigned char :0; unsigned long long :0; };
struct BFu0i_BFs0i_BFu0c_BFu0s { unsigned int :0; signed int :0; unsigned char :0; unsigned short :0; };
struct BFu0i_BFs0i_BFu0i { unsigned int :0; signed int :0; unsigned int :0; };
struct BFu0i_BFs0i_BFu0i_BFs0c { unsigned int :0; signed int :0; unsigned int :0; signed char :0; };
struct BFu0i_BFs0i_BFu0i_BFs0i { unsigned int :0; signed int :0; unsigned int :0; signed int :0; };
struct BFu0i_BFs0i_BFu0i_BFs0ll { unsigned int :0; signed int :0; unsigned int :0; signed long long :0; };
struct BFu0i_BFs0i_BFu0i_BFs0s { unsigned int :0; signed int :0; unsigned int :0; signed short :0; };
struct BFu0i_BFs0i_BFu0i_BFu0c { unsigned int :0; signed int :0; unsigned int :0; unsigned char :0; };
struct BFu0i_BFs0i_BFu0i_BFu0i { unsigned int :0; signed int :0; unsigned int :0; unsigned int :0; };
struct BFu0i_BFs0i_BFu0i_BFu0ll { unsigned int :0; signed int :0; unsigned int :0; unsigned long long :0; };
struct BFu0i_BFs0i_BFu0i_BFu0s { unsigned int :0; signed int :0; unsigned int :0; unsigned short :0; };
struct BFu0i_BFs0i_BFu0ll { unsigned int :0; signed int :0; unsigned long long :0; };
struct BFu0i_BFs0i_BFu0ll_BFs0c { unsigned int :0; signed int :0; unsigned long long :0; signed char :0; };
struct BFu0i_BFs0i_BFu0ll_BFs0i { unsigned int :0; signed int :0; unsigned long long :0; signed int :0; };
struct BFu0i_BFs0i_BFu0ll_BFs0ll { unsigned int :0; signed int :0; unsigned long long :0; signed long long :0; };
struct BFu0i_BFs0i_BFu0ll_BFs0s { unsigned int :0; signed int :0; unsigned long long :0; signed short :0; };
struct BFu0i_BFs0i_BFu0ll_BFu0c { unsigned int :0; signed int :0; unsigned long long :0; unsigned char :0; };
struct BFu0i_BFs0i_BFu0ll_BFu0i { unsigned int :0; signed int :0; unsigned long long :0; unsigned int :0; };
struct BFu0i_BFs0i_BFu0ll_BFu0ll { unsigned int :0; signed int :0; unsigned long long :0; unsigned long long :0; };
struct BFu0i_BFs0i_BFu0ll_BFu0s { unsigned int :0; signed int :0; unsigned long long :0; unsigned short :0; };
struct BFu0i_BFs0i_BFu0s { unsigned int :0; signed int :0; unsigned short :0; };
struct BFu0i_BFs0i_BFu0s_BFs0c { unsigned int :0; signed int :0; unsigned short :0; signed char :0; };
struct BFu0i_BFs0i_BFu0s_BFs0i { unsigned int :0; signed int :0; unsigned short :0; signed int :0; };
struct BFu0i_BFs0i_BFu0s_BFs0ll { unsigned int :0; signed int :0; unsigned short :0; signed long long :0; };
struct BFu0i_BFs0i_BFu0s_BFs0s { unsigned int :0; signed int :0; unsigned short :0; signed short :0; };
struct BFu0i_BFs0i_BFu0s_BFu0c { unsigned int :0; signed int :0; unsigned short :0; unsigned char :0; };
struct BFu0i_BFs0i_BFu0s_BFu0i { unsigned int :0; signed int :0; unsigned short :0; unsigned int :0; };
struct BFu0i_BFs0i_BFu0s_BFu0ll { unsigned int :0; signed int :0; unsigned short :0; unsigned long long :0; };
struct BFu0i_BFs0i_BFu0s_BFu0s { unsigned int :0; signed int :0; unsigned short :0; unsigned short :0; };
struct BFu0i_BFs0ll { unsigned int :0; signed long long :0; };
struct BFu0i_BFs0ll_BFs0c { unsigned int :0; signed long long :0; signed char :0; };
struct BFu0i_BFs0ll_BFs0c_BFs0c { unsigned int :0; signed long long :0; signed char :0; signed char :0; };
struct BFu0i_BFs0ll_BFs0c_BFs0i { unsigned int :0; signed long long :0; signed char :0; signed int :0; };
struct BFu0i_BFs0ll_BFs0c_BFs0ll { unsigned int :0; signed long long :0; signed char :0; signed long long :0; };
struct BFu0i_BFs0ll_BFs0c_BFs0s { unsigned int :0; signed long long :0; signed char :0; signed short :0; };
struct BFu0i_BFs0ll_BFs0c_BFu0c { unsigned int :0; signed long long :0; signed char :0; unsigned char :0; };
struct BFu0i_BFs0ll_BFs0c_BFu0i { unsigned int :0; signed long long :0; signed char :0; unsigned int :0; };
struct BFu0i_BFs0ll_BFs0c_BFu0ll { unsigned int :0; signed long long :0; signed char :0; unsigned long long :0; };
struct BFu0i_BFs0ll_BFs0c_BFu0s { unsigned int :0; signed long long :0; signed char :0; unsigned short :0; };
struct BFu0i_BFs0ll_BFs0i { unsigned int :0; signed long long :0; signed int :0; };
struct BFu0i_BFs0ll_BFs0i_BFs0c { unsigned int :0; signed long long :0; signed int :0; signed char :0; };
struct BFu0i_BFs0ll_BFs0i_BFs0i { unsigned int :0; signed long long :0; signed int :0; signed int :0; };
struct BFu0i_BFs0ll_BFs0i_BFs0ll { unsigned int :0; signed long long :0; signed int :0; signed long long :0; };
struct BFu0i_BFs0ll_BFs0i_BFs0s { unsigned int :0; signed long long :0; signed int :0; signed short :0; };
struct BFu0i_BFs0ll_BFs0i_BFu0c { unsigned int :0; signed long long :0; signed int :0; unsigned char :0; };
struct BFu0i_BFs0ll_BFs0i_BFu0i { unsigned int :0; signed long long :0; signed int :0; unsigned int :0; };
struct BFu0i_BFs0ll_BFs0i_BFu0ll { unsigned int :0; signed long long :0; signed int :0; unsigned long long :0; };
struct BFu0i_BFs0ll_BFs0i_BFu0s { unsigned int :0; signed long long :0; signed int :0; unsigned short :0; };
struct BFu0i_BFs0ll_BFs0ll { unsigned int :0; signed long long :0; signed long long :0; };
struct BFu0i_BFs0ll_BFs0ll_BFs0c { unsigned int :0; signed long long :0; signed long long :0; signed char :0; };
struct BFu0i_BFs0ll_BFs0ll_BFs0i { unsigned int :0; signed long long :0; signed long long :0; signed int :0; };
struct BFu0i_BFs0ll_BFs0ll_BFs0ll { unsigned int :0; signed long long :0; signed long long :0; signed long long :0; };
struct BFu0i_BFs0ll_BFs0ll_BFs0s { unsigned int :0; signed long long :0; signed long long :0; signed short :0; };
struct BFu0i_BFs0ll_BFs0ll_BFu0c { unsigned int :0; signed long long :0; signed long long :0; unsigned char :0; };
struct BFu0i_BFs0ll_BFs0ll_BFu0i { unsigned int :0; signed long long :0; signed long long :0; unsigned int :0; };
struct BFu0i_BFs0ll_BFs0ll_BFu0ll { unsigned int :0; signed long long :0; signed long long :0; unsigned long long :0; };
struct BFu0i_BFs0ll_BFs0ll_BFu0s { unsigned int :0; signed long long :0; signed long long :0; unsigned short :0; };
struct BFu0i_BFs0ll_BFs0s { unsigned int :0; signed long long :0; signed short :0; };
struct BFu0i_BFs0ll_BFs0s_BFs0c { unsigned int :0; signed long long :0; signed short :0; signed char :0; };
struct BFu0i_BFs0ll_BFs0s_BFs0i { unsigned int :0; signed long long :0; signed short :0; signed int :0; };
struct BFu0i_BFs0ll_BFs0s_BFs0ll { unsigned int :0; signed long long :0; signed short :0; signed long long :0; };
struct BFu0i_BFs0ll_BFs0s_BFs0s { unsigned int :0; signed long long :0; signed short :0; signed short :0; };
struct BFu0i_BFs0ll_BFs0s_BFu0c { unsigned int :0; signed long long :0; signed short :0; unsigned char :0; };
struct BFu0i_BFs0ll_BFs0s_BFu0i { unsigned int :0; signed long long :0; signed short :0; unsigned int :0; };
struct BFu0i_BFs0ll_BFs0s_BFu0ll { unsigned int :0; signed long long :0; signed short :0; unsigned long long :0; };
struct BFu0i_BFs0ll_BFs0s_BFu0s { unsigned int :0; signed long long :0; signed short :0; unsigned short :0; };
struct BFu0i_BFs0ll_BFu0c { unsigned int :0; signed long long :0; unsigned char :0; };
struct BFu0i_BFs0ll_BFu0c_BFs0c { unsigned int :0; signed long long :0; unsigned char :0; signed char :0; };
struct BFu0i_BFs0ll_BFu0c_BFs0i { unsigned int :0; signed long long :0; unsigned char :0; signed int :0; };
struct BFu0i_BFs0ll_BFu0c_BFs0ll { unsigned int :0; signed long long :0; unsigned char :0; signed long long :0; };
struct BFu0i_BFs0ll_BFu0c_BFs0s { unsigned int :0; signed long long :0; unsigned char :0; signed short :0; };
struct BFu0i_BFs0ll_BFu0c_BFu0c { unsigned int :0; signed long long :0; unsigned char :0; unsigned char :0; };
struct BFu0i_BFs0ll_BFu0c_BFu0i { unsigned int :0; signed long long :0; unsigned char :0; unsigned int :0; };
struct BFu0i_BFs0ll_BFu0c_BFu0ll { unsigned int :0; signed long long :0; unsigned char :0; unsigned long long :0; };
struct BFu0i_BFs0ll_BFu0c_BFu0s { unsigned int :0; signed long long :0; unsigned char :0; unsigned short :0; };
struct BFu0i_BFs0ll_BFu0i { unsigned int :0; signed long long :0; unsigned int :0; };
struct BFu0i_BFs0ll_BFu0i_BFs0c { unsigned int :0; signed long long :0; unsigned int :0; signed char :0; };
struct BFu0i_BFs0ll_BFu0i_BFs0i { unsigned int :0; signed long long :0; unsigned int :0; signed int :0; };
struct BFu0i_BFs0ll_BFu0i_BFs0ll { unsigned int :0; signed long long :0; unsigned int :0; signed long long :0; };
struct BFu0i_BFs0ll_BFu0i_BFs0s { unsigned int :0; signed long long :0; unsigned int :0; signed short :0; };
struct BFu0i_BFs0ll_BFu0i_BFu0c { unsigned int :0; signed long long :0; unsigned int :0; unsigned char :0; };
struct BFu0i_BFs0ll_BFu0i_BFu0i { unsigned int :0; signed long long :0; unsigned int :0; unsigned int :0; };
struct BFu0i_BFs0ll_BFu0i_BFu0ll { unsigned int :0; signed long long :0; unsigned int :0; unsigned long long :0; };
struct BFu0i_BFs0ll_BFu0i_BFu0s { unsigned int :0; signed long long :0; unsigned int :0; unsigned short :0; };
struct BFu0i_BFs0ll_BFu0ll { unsigned int :0; signed long long :0; unsigned long long :0; };
struct BFu0i_BFs0ll_BFu0ll_BFs0c { unsigned int :0; signed long long :0; unsigned long long :0; signed char :0; };
struct BFu0i_BFs0ll_BFu0ll_BFs0i { unsigned int :0; signed long long :0; unsigned long long :0; signed int :0; };
struct BFu0i_BFs0ll_BFu0ll_BFs0ll { unsigned int :0; signed long long :0; unsigned long long :0; signed long long :0; };
struct BFu0i_BFs0ll_BFu0ll_BFs0s { unsigned int :0; signed long long :0; unsigned long long :0; signed short :0; };
struct BFu0i_BFs0ll_BFu0ll_BFu0c { unsigned int :0; signed long long :0; unsigned long long :0; unsigned char :0; };
struct BFu0i_BFs0ll_BFu0ll_BFu0i { unsigned int :0; signed long long :0; unsigned long long :0; unsigned int :0; };
struct BFu0i_BFs0ll_BFu0ll_BFu0ll { unsigned int :0; signed long long :0; unsigned long long :0; unsigned long long :0; };
struct BFu0i_BFs0ll_BFu0ll_BFu0s { unsigned int :0; signed long long :0; unsigned long long :0; unsigned short :0; };
struct BFu0i_BFs0ll_BFu0s { unsigned int :0; signed long long :0; unsigned short :0; };
struct BFu0i_BFs0ll_BFu0s_BFs0c { unsigned int :0; signed long long :0; unsigned short :0; signed char :0; };
struct BFu0i_BFs0ll_BFu0s_BFs0i { unsigned int :0; signed long long :0; unsigned short :0; signed int :0; };
struct BFu0i_BFs0ll_BFu0s_BFs0ll { unsigned int :0; signed long long :0; unsigned short :0; signed long long :0; };
struct BFu0i_BFs0ll_BFu0s_BFs0s { unsigned int :0; signed long long :0; unsigned short :0; signed short :0; };
struct BFu0i_BFs0ll_BFu0s_BFu0c { unsigned int :0; signed long long :0; unsigned short :0; unsigned char :0; };
struct BFu0i_BFs0ll_BFu0s_BFu0i { unsigned int :0; signed long long :0; unsigned short :0; unsigned int :0; };
struct BFu0i_BFs0ll_BFu0s_BFu0ll { unsigned int :0; signed long long :0; unsigned short :0; unsigned long long :0; };
struct BFu0i_BFs0ll_BFu0s_BFu0s { unsigned int :0; signed long long :0; unsigned short :0; unsigned short :0; };
struct BFu0i_BFs0s { unsigned int :0; signed short :0; };
struct BFu0i_BFs0s_BFs0c { unsigned int :0; signed short :0; signed char :0; };
struct BFu0i_BFs0s_BFs0c_BFs0c { unsigned int :0; signed short :0; signed char :0; signed char :0; };
struct BFu0i_BFs0s_BFs0c_BFs0i { unsigned int :0; signed short :0; signed char :0; signed int :0; };
struct BFu0i_BFs0s_BFs0c_BFs0ll { unsigned int :0; signed short :0; signed char :0; signed long long :0; };
struct BFu0i_BFs0s_BFs0c_BFs0s { unsigned int :0; signed short :0; signed char :0; signed short :0; };
struct BFu0i_BFs0s_BFs0c_BFu0c { unsigned int :0; signed short :0; signed char :0; unsigned char :0; };
struct BFu0i_BFs0s_BFs0c_BFu0i { unsigned int :0; signed short :0; signed char :0; unsigned int :0; };
struct BFu0i_BFs0s_BFs0c_BFu0ll { unsigned int :0; signed short :0; signed char :0; unsigned long long :0; };
struct BFu0i_BFs0s_BFs0c_BFu0s { unsigned int :0; signed short :0; signed char :0; unsigned short :0; };
struct BFu0i_BFs0s_BFs0i { unsigned int :0; signed short :0; signed int :0; };
struct BFu0i_BFs0s_BFs0i_BFs0c { unsigned int :0; signed short :0; signed int :0; signed char :0; };
struct BFu0i_BFs0s_BFs0i_BFs0i { unsigned int :0; signed short :0; signed int :0; signed int :0; };
struct BFu0i_BFs0s_BFs0i_BFs0ll { unsigned int :0; signed short :0; signed int :0; signed long long :0; };
struct BFu0i_BFs0s_BFs0i_BFs0s { unsigned int :0; signed short :0; signed int :0; signed short :0; };
struct BFu0i_BFs0s_BFs0i_BFu0c { unsigned int :0; signed short :0; signed int :0; unsigned char :0; };
struct BFu0i_BFs0s_BFs0i_BFu0i { unsigned int :0; signed short :0; signed int :0; unsigned int :0; };
struct BFu0i_BFs0s_BFs0i_BFu0ll { unsigned int :0; signed short :0; signed int :0; unsigned long long :0; };
struct BFu0i_BFs0s_BFs0i_BFu0s { unsigned int :0; signed short :0; signed int :0; unsigned short :0; };
struct BFu0i_BFs0s_BFs0ll { unsigned int :0; signed short :0; signed long long :0; };
struct BFu0i_BFs0s_BFs0ll_BFs0c { unsigned int :0; signed short :0; signed long long :0; signed char :0; };
struct BFu0i_BFs0s_BFs0ll_BFs0i { unsigned int :0; signed short :0; signed long long :0; signed int :0; };
struct BFu0i_BFs0s_BFs0ll_BFs0ll { unsigned int :0; signed short :0; signed long long :0; signed long long :0; };
struct BFu0i_BFs0s_BFs0ll_BFs0s { unsigned int :0; signed short :0; signed long long :0; signed short :0; };
struct BFu0i_BFs0s_BFs0ll_BFu0c { unsigned int :0; signed short :0; signed long long :0; unsigned char :0; };
struct BFu0i_BFs0s_BFs0ll_BFu0i { unsigned int :0; signed short :0; signed long long :0; unsigned int :0; };
struct BFu0i_BFs0s_BFs0ll_BFu0ll { unsigned int :0; signed short :0; signed long long :0; unsigned long long :0; };
struct BFu0i_BFs0s_BFs0ll_BFu0s { unsigned int :0; signed short :0; signed long long :0; unsigned short :0; };
struct BFu0i_BFs0s_BFs0s { unsigned int :0; signed short :0; signed short :0; };
struct BFu0i_BFs0s_BFs0s_BFs0c { unsigned int :0; signed short :0; signed short :0; signed char :0; };
struct BFu0i_BFs0s_BFs0s_BFs0i { unsigned int :0; signed short :0; signed short :0; signed int :0; };
struct BFu0i_BFs0s_BFs0s_BFs0ll { unsigned int :0; signed short :0; signed short :0; signed long long :0; };
struct BFu0i_BFs0s_BFs0s_BFs0s { unsigned int :0; signed short :0; signed short :0; signed short :0; };
struct BFu0i_BFs0s_BFs0s_BFu0c { unsigned int :0; signed short :0; signed short :0; unsigned char :0; };
struct BFu0i_BFs0s_BFs0s_BFu0i { unsigned int :0; signed short :0; signed short :0; unsigned int :0; };
struct BFu0i_BFs0s_BFs0s_BFu0ll { unsigned int :0; signed short :0; signed short :0; unsigned long long :0; };
struct BFu0i_BFs0s_BFs0s_BFu0s { unsigned int :0; signed short :0; signed short :0; unsigned short :0; };
struct BFu0i_BFs0s_BFu0c { unsigned int :0; signed short :0; unsigned char :0; };
struct BFu0i_BFs0s_BFu0c_BFs0c { unsigned int :0; signed short :0; unsigned char :0; signed char :0; };
struct BFu0i_BFs0s_BFu0c_BFs0i { unsigned int :0; signed short :0; unsigned char :0; signed int :0; };
struct BFu0i_BFs0s_BFu0c_BFs0ll { unsigned int :0; signed short :0; unsigned char :0; signed long long :0; };
struct BFu0i_BFs0s_BFu0c_BFs0s { unsigned int :0; signed short :0; unsigned char :0; signed short :0; };
struct BFu0i_BFs0s_BFu0c_BFu0c { unsigned int :0; signed short :0; unsigned char :0; unsigned char :0; };
struct BFu0i_BFs0s_BFu0c_BFu0i { unsigned int :0; signed short :0; unsigned char :0; unsigned int :0; };
struct BFu0i_BFs0s_BFu0c_BFu0ll { unsigned int :0; signed short :0; unsigned char :0; unsigned long long :0; };
struct BFu0i_BFs0s_BFu0c_BFu0s { unsigned int :0; signed short :0; unsigned char :0; unsigned short :0; };
struct BFu0i_BFs0s_BFu0i { unsigned int :0; signed short :0; unsigned int :0; };
struct BFu0i_BFs0s_BFu0i_BFs0c { unsigned int :0; signed short :0; unsigned int :0; signed char :0; };
struct BFu0i_BFs0s_BFu0i_BFs0i { unsigned int :0; signed short :0; unsigned int :0; signed int :0; };
struct BFu0i_BFs0s_BFu0i_BFs0ll { unsigned int :0; signed short :0; unsigned int :0; signed long long :0; };
struct BFu0i_BFs0s_BFu0i_BFs0s { unsigned int :0; signed short :0; unsigned int :0; signed short :0; };
struct BFu0i_BFs0s_BFu0i_BFu0c { unsigned int :0; signed short :0; unsigned int :0; unsigned char :0; };
struct BFu0i_BFs0s_BFu0i_BFu0i { unsigned int :0; signed short :0; unsigned int :0; unsigned int :0; };
struct BFu0i_BFs0s_BFu0i_BFu0ll { unsigned int :0; signed short :0; unsigned int :0; unsigned long long :0; };
struct BFu0i_BFs0s_BFu0i_BFu0s { unsigned int :0; signed short :0; unsigned int :0; unsigned short :0; };
struct BFu0i_BFs0s_BFu0ll { unsigned int :0; signed short :0; unsigned long long :0; };
struct BFu0i_BFs0s_BFu0ll_BFs0c { unsigned int :0; signed short :0; unsigned long long :0; signed char :0; };
struct BFu0i_BFs0s_BFu0ll_BFs0i { unsigned int :0; signed short :0; unsigned long long :0; signed int :0; };
struct BFu0i_BFs0s_BFu0ll_BFs0ll { unsigned int :0; signed short :0; unsigned long long :0; signed long long :0; };
struct BFu0i_BFs0s_BFu0ll_BFs0s { unsigned int :0; signed short :0; unsigned long long :0; signed short :0; };
struct BFu0i_BFs0s_BFu0ll_BFu0c { unsigned int :0; signed short :0; unsigned long long :0; unsigned char :0; };
struct BFu0i_BFs0s_BFu0ll_BFu0i { unsigned int :0; signed short :0; unsigned long long :0; unsigned int :0; };
struct BFu0i_BFs0s_BFu0ll_BFu0ll { unsigned int :0; signed short :0; unsigned long long :0; unsigned long long :0; };
struct BFu0i_BFs0s_BFu0ll_BFu0s { unsigned int :0; signed short :0; unsigned long long :0; unsigned short :0; };
struct BFu0i_BFs0s_BFu0s { unsigned int :0; signed short :0; unsigned short :0; };
struct BFu0i_BFs0s_BFu0s_BFs0c { unsigned int :0; signed short :0; unsigned short :0; signed char :0; };
struct BFu0i_BFs0s_BFu0s_BFs0i { unsigned int :0; signed short :0; unsigned short :0; signed int :0; };
struct BFu0i_BFs0s_BFu0s_BFs0ll { unsigned int :0; signed short :0; unsigned short :0; signed long long :0; };
struct BFu0i_BFs0s_BFu0s_BFs0s { unsigned int :0; signed short :0; unsigned short :0; signed short :0; };
struct BFu0i_BFs0s_BFu0s_BFu0c { unsigned int :0; signed short :0; unsigned short :0; unsigned char :0; };
struct BFu0i_BFs0s_BFu0s_BFu0i { unsigned int :0; signed short :0; unsigned short :0; unsigned int :0; };
struct BFu0i_BFs0s_BFu0s_BFu0ll { unsigned int :0; signed short :0; unsigned short :0; unsigned long long :0; };
struct BFu0i_BFs0s_BFu0s_BFu0s { unsigned int :0; signed short :0; unsigned short :0; unsigned short :0; };
struct BFu0i_BFu0c { unsigned int :0; unsigned char :0; };
struct BFu0i_BFu0c_BFs0c { unsigned int :0; unsigned char :0; signed char :0; };
struct BFu0i_BFu0c_BFs0c_BFs0c { unsigned int :0; unsigned char :0; signed char :0; signed char :0; };
struct BFu0i_BFu0c_BFs0c_BFs0i { unsigned int :0; unsigned char :0; signed char :0; signed int :0; };
struct BFu0i_BFu0c_BFs0c_BFs0ll { unsigned int :0; unsigned char :0; signed char :0; signed long long :0; };
struct BFu0i_BFu0c_BFs0c_BFs0s { unsigned int :0; unsigned char :0; signed char :0; signed short :0; };
struct BFu0i_BFu0c_BFs0c_BFu0c { unsigned int :0; unsigned char :0; signed char :0; unsigned char :0; };
struct BFu0i_BFu0c_BFs0c_BFu0i { unsigned int :0; unsigned char :0; signed char :0; unsigned int :0; };
struct BFu0i_BFu0c_BFs0c_BFu0ll { unsigned int :0; unsigned char :0; signed char :0; unsigned long long :0; };
struct BFu0i_BFu0c_BFs0c_BFu0s { unsigned int :0; unsigned char :0; signed char :0; unsigned short :0; };
struct BFu0i_BFu0c_BFs0i { unsigned int :0; unsigned char :0; signed int :0; };
struct BFu0i_BFu0c_BFs0i_BFs0c { unsigned int :0; unsigned char :0; signed int :0; signed char :0; };
struct BFu0i_BFu0c_BFs0i_BFs0i { unsigned int :0; unsigned char :0; signed int :0; signed int :0; };
struct BFu0i_BFu0c_BFs0i_BFs0ll { unsigned int :0; unsigned char :0; signed int :0; signed long long :0; };
struct BFu0i_BFu0c_BFs0i_BFs0s { unsigned int :0; unsigned char :0; signed int :0; signed short :0; };
struct BFu0i_BFu0c_BFs0i_BFu0c { unsigned int :0; unsigned char :0; signed int :0; unsigned char :0; };
struct BFu0i_BFu0c_BFs0i_BFu0i { unsigned int :0; unsigned char :0; signed int :0; unsigned int :0; };
struct BFu0i_BFu0c_BFs0i_BFu0ll { unsigned int :0; unsigned char :0; signed int :0; unsigned long long :0; };
struct BFu0i_BFu0c_BFs0i_BFu0s { unsigned int :0; unsigned char :0; signed int :0; unsigned short :0; };
struct BFu0i_BFu0c_BFs0ll { unsigned int :0; unsigned char :0; signed long long :0; };
struct BFu0i_BFu0c_BFs0ll_BFs0c { unsigned int :0; unsigned char :0; signed long long :0; signed char :0; };
struct BFu0i_BFu0c_BFs0ll_BFs0i { unsigned int :0; unsigned char :0; signed long long :0; signed int :0; };
struct BFu0i_BFu0c_BFs0ll_BFs0ll { unsigned int :0; unsigned char :0; signed long long :0; signed long long :0; };
struct BFu0i_BFu0c_BFs0ll_BFs0s { unsigned int :0; unsigned char :0; signed long long :0; signed short :0; };
struct BFu0i_BFu0c_BFs0ll_BFu0c { unsigned int :0; unsigned char :0; signed long long :0; unsigned char :0; };
struct BFu0i_BFu0c_BFs0ll_BFu0i { unsigned int :0; unsigned char :0; signed long long :0; unsigned int :0; };
struct BFu0i_BFu0c_BFs0ll_BFu0ll { unsigned int :0; unsigned char :0; signed long long :0; unsigned long long :0; };
struct BFu0i_BFu0c_BFs0ll_BFu0s { unsigned int :0; unsigned char :0; signed long long :0; unsigned short :0; };
struct BFu0i_BFu0c_BFs0s { unsigned int :0; unsigned char :0; signed short :0; };
struct BFu0i_BFu0c_BFs0s_BFs0c { unsigned int :0; unsigned char :0; signed short :0; signed char :0; };
struct BFu0i_BFu0c_BFs0s_BFs0i { unsigned int :0; unsigned char :0; signed short :0; signed int :0; };
struct BFu0i_BFu0c_BFs0s_BFs0ll { unsigned int :0; unsigned char :0; signed short :0; signed long long :0; };
struct BFu0i_BFu0c_BFs0s_BFs0s { unsigned int :0; unsigned char :0; signed short :0; signed short :0; };
struct BFu0i_BFu0c_BFs0s_BFu0c { unsigned int :0; unsigned char :0; signed short :0; unsigned char :0; };
struct BFu0i_BFu0c_BFs0s_BFu0i { unsigned int :0; unsigned char :0; signed short :0; unsigned int :0; };
struct BFu0i_BFu0c_BFs0s_BFu0ll { unsigned int :0; unsigned char :0; signed short :0; unsigned long long :0; };
struct BFu0i_BFu0c_BFs0s_BFu0s { unsigned int :0; unsigned char :0; signed short :0; unsigned short :0; };
struct BFu0i_BFu0c_BFu0c { unsigned int :0; unsigned char :0; unsigned char :0; };
struct BFu0i_BFu0c_BFu0c_BFs0c { unsigned int :0; unsigned char :0; unsigned char :0; signed char :0; };
struct BFu0i_BFu0c_BFu0c_BFs0i { unsigned int :0; unsigned char :0; unsigned char :0; signed int :0; };
struct BFu0i_BFu0c_BFu0c_BFs0ll { unsigned int :0; unsigned char :0; unsigned char :0; signed long long :0; };
struct BFu0i_BFu0c_BFu0c_BFs0s { unsigned int :0; unsigned char :0; unsigned char :0; signed short :0; };
struct BFu0i_BFu0c_BFu0c_BFu0c { unsigned int :0; unsigned char :0; unsigned char :0; unsigned char :0; };
struct BFu0i_BFu0c_BFu0c_BFu0i { unsigned int :0; unsigned char :0; unsigned char :0; unsigned int :0; };
struct BFu0i_BFu0c_BFu0c_BFu0ll { unsigned int :0; unsigned char :0; unsigned char :0; unsigned long long :0; };
struct BFu0i_BFu0c_BFu0c_BFu0s { unsigned int :0; unsigned char :0; unsigned char :0; unsigned short :0; };
struct BFu0i_BFu0c_BFu0i { unsigned int :0; unsigned char :0; unsigned int :0; };
struct BFu0i_BFu0c_BFu0i_BFs0c { unsigned int :0; unsigned char :0; unsigned int :0; signed char :0; };
struct BFu0i_BFu0c_BFu0i_BFs0i { unsigned int :0; unsigned char :0; unsigned int :0; signed int :0; };
struct BFu0i_BFu0c_BFu0i_BFs0ll { unsigned int :0; unsigned char :0; unsigned int :0; signed long long :0; };
struct BFu0i_BFu0c_BFu0i_BFs0s { unsigned int :0; unsigned char :0; unsigned int :0; signed short :0; };
struct BFu0i_BFu0c_BFu0i_BFu0c { unsigned int :0; unsigned char :0; unsigned int :0; unsigned char :0; };
struct BFu0i_BFu0c_BFu0i_BFu0i { unsigned int :0; unsigned char :0; unsigned int :0; unsigned int :0; };
struct BFu0i_BFu0c_BFu0i_BFu0ll { unsigned int :0; unsigned char :0; unsigned int :0; unsigned long long :0; };
struct BFu0i_BFu0c_BFu0i_BFu0s { unsigned int :0; unsigned char :0; unsigned int :0; unsigned short :0; };
struct BFu0i_BFu0c_BFu0ll { unsigned int :0; unsigned char :0; unsigned long long :0; };
struct BFu0i_BFu0c_BFu0ll_BFs0c { unsigned int :0; unsigned char :0; unsigned long long :0; signed char :0; };
struct BFu0i_BFu0c_BFu0ll_BFs0i { unsigned int :0; unsigned char :0; unsigned long long :0; signed int :0; };
struct BFu0i_BFu0c_BFu0ll_BFs0ll { unsigned int :0; unsigned char :0; unsigned long long :0; signed long long :0; };
struct BFu0i_BFu0c_BFu0ll_BFs0s { unsigned int :0; unsigned char :0; unsigned long long :0; signed short :0; };
struct BFu0i_BFu0c_BFu0ll_BFu0c { unsigned int :0; unsigned char :0; unsigned long long :0; unsigned char :0; };
struct BFu0i_BFu0c_BFu0ll_BFu0i { unsigned int :0; unsigned char :0; unsigned long long :0; unsigned int :0; };
struct BFu0i_BFu0c_BFu0ll_BFu0ll { unsigned int :0; unsigned char :0; unsigned long long :0; unsigned long long :0; };
struct BFu0i_BFu0c_BFu0ll_BFu0s { unsigned int :0; unsigned char :0; unsigned long long :0; unsigned short :0; };
struct BFu0i_BFu0c_BFu0s { unsigned int :0; unsigned char :0; unsigned short :0; };
struct BFu0i_BFu0c_BFu0s_BFs0c { unsigned int :0; unsigned char :0; unsigned short :0; signed char :0; };
struct BFu0i_BFu0c_BFu0s_BFs0i { unsigned int :0; unsigned char :0; unsigned short :0; signed int :0; };
struct BFu0i_BFu0c_BFu0s_BFs0ll { unsigned int :0; unsigned char :0; unsigned short :0; signed long long :0; };
struct BFu0i_BFu0c_BFu0s_BFs0s { unsigned int :0; unsigned char :0; unsigned short :0; signed short :0; };
struct BFu0i_BFu0c_BFu0s_BFu0c { unsigned int :0; unsigned char :0; unsigned short :0; unsigned char :0; };
struct BFu0i_BFu0c_BFu0s_BFu0i { unsigned int :0; unsigned char :0; unsigned short :0; unsigned int :0; };
struct BFu0i_BFu0c_BFu0s_BFu0ll { unsigned int :0; unsigned char :0; unsigned short :0; unsigned long long :0; };
struct BFu0i_BFu0c_BFu0s_BFu0s { unsigned int :0; unsigned char :0; unsigned short :0; unsigned short :0; };
struct BFu0i_BFu0c_BFu15i { unsigned int :0; unsigned char :0; unsigned int v1:15; };
struct BFu0i_BFu0c_BFu15ll { unsigned int :0; unsigned char :0; unsigned long long v1:15; };
struct BFu0i_BFu0c_BFu15s { unsigned int :0; unsigned char :0; unsigned short v1:15; };
struct BFu0i_BFu0c_BFu16i { unsigned int :0; unsigned char :0; unsigned int v1:16; };
struct BFu0i_BFu0c_BFu16ll { unsigned int :0; unsigned char :0; unsigned long long v1:16; };
struct BFu0i_BFu0c_BFu16s { unsigned int :0; unsigned char :0; unsigned short v1:16; };
struct BFu0i_BFu0c_BFu17i { unsigned int :0; unsigned char :0; unsigned int v1:17; };
struct BFu0i_BFu0c_BFu17ll { unsigned int :0; unsigned char :0; unsigned long long v1:17; };
struct BFu0i_BFu0c_BFu1c { unsigned int :0; unsigned char :0; unsigned char v1:1; };
struct BFu0i_BFu0c_BFu1i { unsigned int :0; unsigned char :0; unsigned int v1:1; };
struct BFu0i_BFu0c_BFu1ll { unsigned int :0; unsigned char :0; unsigned long long v1:1; };
struct BFu0i_BFu0c_BFu1s { unsigned int :0; unsigned char :0; unsigned short v1:1; };
struct BFu0i_BFu0c_BFu31i { unsigned int :0; unsigned char :0; unsigned int v1:31; };
struct BFu0i_BFu0c_BFu31ll { unsigned int :0; unsigned char :0; unsigned long long v1:31; };
struct BFu0i_BFu0c_BFu32i { unsigned int :0; unsigned char :0; unsigned int v1:32; };
struct BFu0i_BFu0c_BFu32ll { unsigned int :0; unsigned char :0; unsigned long long v1:32; };
struct BFu0i_BFu0c_BFu33 { unsigned int :0; unsigned char :0; unsigned long long v1:33; };
struct BFu0i_BFu0c_BFu7c { unsigned int :0; unsigned char :0; unsigned char v1:7; };
struct BFu0i_BFu0c_BFu7i { unsigned int :0; unsigned char :0; unsigned int v1:7; };
struct BFu0i_BFu0c_BFu7ll { unsigned int :0; unsigned char :0; unsigned long long v1:7; };
struct BFu0i_BFu0c_BFu7s { unsigned int :0; unsigned char :0; unsigned short v1:7; };
struct BFu0i_BFu0c_BFu8c { unsigned int :0; unsigned char :0; unsigned char v1:8; };
struct BFu0i_BFu0c_BFu8i { unsigned int :0; unsigned char :0; unsigned int v1:8; };
struct BFu0i_BFu0c_BFu8ll { unsigned int :0; unsigned char :0; unsigned long long v1:8; };
struct BFu0i_BFu0c_BFu8s { unsigned int :0; unsigned char :0; unsigned short v1:8; };
struct BFu0i_BFu0c_BFu9i { unsigned int :0; unsigned char :0; unsigned int v1:9; };
struct BFu0i_BFu0c_BFu9ll { unsigned int :0; unsigned char :0; unsigned long long v1:9; };
struct BFu0i_BFu0c_BFu9s { unsigned int :0; unsigned char :0; unsigned short v1:9; };
struct BFu0i_BFu0c_C { unsigned int :0; unsigned char :0; char v1; };
struct BFu0i_BFu0c_D { unsigned int :0; unsigned char :0; double v1; };
struct BFu0i_BFu0c_F { unsigned int :0; unsigned char :0; float v1; };
struct BFu0i_BFu0c_I { unsigned int :0; unsigned char :0; int v1; };
struct BFu0i_BFu0c_Ip { unsigned int :0; unsigned char :0; int * v1; };
struct BFu0i_BFu0c_L { unsigned int :0; unsigned char :0; long long v1; };
struct BFu0i_BFu0c_S { unsigned int :0; unsigned char :0; short v1; };
struct BFu0i_BFu0c_Uc { unsigned int :0; unsigned char :0; unsigned char v1; };
struct BFu0i_BFu0c_Ui { unsigned int :0; unsigned char :0; unsigned int v1; };
struct BFu0i_BFu0c_Ul { unsigned int :0; unsigned char :0; unsigned long long v1; };
struct BFu0i_BFu0c_Us { unsigned int :0; unsigned char :0; unsigned short v1; };
struct BFu0i_BFu0c_Vp { unsigned int :0; unsigned char :0; void * v1; };
struct BFu0i_BFu0i { unsigned int :0; unsigned int :0; };
struct BFu0i_BFu0i_BFs0c { unsigned int :0; unsigned int :0; signed char :0; };
struct BFu0i_BFu0i_BFs0c_BFs0c { unsigned int :0; unsigned int :0; signed char :0; signed char :0; };
struct BFu0i_BFu0i_BFs0c_BFs0i { unsigned int :0; unsigned int :0; signed char :0; signed int :0; };
struct BFu0i_BFu0i_BFs0c_BFs0ll { unsigned int :0; unsigned int :0; signed char :0; signed long long :0; };
struct BFu0i_BFu0i_BFs0c_BFs0s { unsigned int :0; unsigned int :0; signed char :0; signed short :0; };
struct BFu0i_BFu0i_BFs0c_BFu0c { unsigned int :0; unsigned int :0; signed char :0; unsigned char :0; };
struct BFu0i_BFu0i_BFs0c_BFu0i { unsigned int :0; unsigned int :0; signed char :0; unsigned int :0; };
struct BFu0i_BFu0i_BFs0c_BFu0ll { unsigned int :0; unsigned int :0; signed char :0; unsigned long long :0; };
struct BFu0i_BFu0i_BFs0c_BFu0s { unsigned int :0; unsigned int :0; signed char :0; unsigned short :0; };
struct BFu0i_BFu0i_BFs0i { unsigned int :0; unsigned int :0; signed int :0; };
struct BFu0i_BFu0i_BFs0i_BFs0c { unsigned int :0; unsigned int :0; signed int :0; signed char :0; };
struct BFu0i_BFu0i_BFs0i_BFs0i { unsigned int :0; unsigned int :0; signed int :0; signed int :0; };
struct BFu0i_BFu0i_BFs0i_BFs0ll { unsigned int :0; unsigned int :0; signed int :0; signed long long :0; };
struct BFu0i_BFu0i_BFs0i_BFs0s { unsigned int :0; unsigned int :0; signed int :0; signed short :0; };
struct BFu0i_BFu0i_BFs0i_BFu0c { unsigned int :0; unsigned int :0; signed int :0; unsigned char :0; };
struct BFu0i_BFu0i_BFs0i_BFu0i { unsigned int :0; unsigned int :0; signed int :0; unsigned int :0; };
struct BFu0i_BFu0i_BFs0i_BFu0ll { unsigned int :0; unsigned int :0; signed int :0; unsigned long long :0; };
struct BFu0i_BFu0i_BFs0i_BFu0s { unsigned int :0; unsigned int :0; signed int :0; unsigned short :0; };
struct BFu0i_BFu0i_BFs0ll { unsigned int :0; unsigned int :0; signed long long :0; };
struct BFu0i_BFu0i_BFs0ll_BFs0c { unsigned int :0; unsigned int :0; signed long long :0; signed char :0; };
struct BFu0i_BFu0i_BFs0ll_BFs0i { unsigned int :0; unsigned int :0; signed long long :0; signed int :0; };
struct BFu0i_BFu0i_BFs0ll_BFs0ll { unsigned int :0; unsigned int :0; signed long long :0; signed long long :0; };
struct BFu0i_BFu0i_BFs0ll_BFs0s { unsigned int :0; unsigned int :0; signed long long :0; signed short :0; };
struct BFu0i_BFu0i_BFs0ll_BFu0c { unsigned int :0; unsigned int :0; signed long long :0; unsigned char :0; };
struct BFu0i_BFu0i_BFs0ll_BFu0i { unsigned int :0; unsigned int :0; signed long long :0; unsigned int :0; };
struct BFu0i_BFu0i_BFs0ll_BFu0ll { unsigned int :0; unsigned int :0; signed long long :0; unsigned long long :0; };
struct BFu0i_BFu0i_BFs0ll_BFu0s { unsigned int :0; unsigned int :0; signed long long :0; unsigned short :0; };
struct BFu0i_BFu0i_BFs0s { unsigned int :0; unsigned int :0; signed short :0; };
struct BFu0i_BFu0i_BFs0s_BFs0c { unsigned int :0; unsigned int :0; signed short :0; signed char :0; };
struct BFu0i_BFu0i_BFs0s_BFs0i { unsigned int :0; unsigned int :0; signed short :0; signed int :0; };
struct BFu0i_BFu0i_BFs0s_BFs0ll { unsigned int :0; unsigned int :0; signed short :0; signed long long :0; };
struct BFu0i_BFu0i_BFs0s_BFs0s { unsigned int :0; unsigned int :0; signed short :0; signed short :0; };
struct BFu0i_BFu0i_BFs0s_BFu0c { unsigned int :0; unsigned int :0; signed short :0; unsigned char :0; };
struct BFu0i_BFu0i_BFs0s_BFu0i { unsigned int :0; unsigned int :0; signed short :0; unsigned int :0; };
struct BFu0i_BFu0i_BFs0s_BFu0ll { unsigned int :0; unsigned int :0; signed short :0; unsigned long long :0; };
struct BFu0i_BFu0i_BFs0s_BFu0s { unsigned int :0; unsigned int :0; signed short :0; unsigned short :0; };
struct BFu0i_BFu0i_BFu0c { unsigned int :0; unsigned int :0; unsigned char :0; };
struct BFu0i_BFu0i_BFu0c_BFs0c { unsigned int :0; unsigned int :0; unsigned char :0; signed char :0; };
struct BFu0i_BFu0i_BFu0c_BFs0i { unsigned int :0; unsigned int :0; unsigned char :0; signed int :0; };
struct BFu0i_BFu0i_BFu0c_BFs0ll { unsigned int :0; unsigned int :0; unsigned char :0; signed long long :0; };
struct BFu0i_BFu0i_BFu0c_BFs0s { unsigned int :0; unsigned int :0; unsigned char :0; signed short :0; };
struct BFu0i_BFu0i_BFu0c_BFu0c { unsigned int :0; unsigned int :0; unsigned char :0; unsigned char :0; };
struct BFu0i_BFu0i_BFu0c_BFu0i { unsigned int :0; unsigned int :0; unsigned char :0; unsigned int :0; };
struct BFu0i_BFu0i_BFu0c_BFu0ll { unsigned int :0; unsigned int :0; unsigned char :0; unsigned long long :0; };
struct BFu0i_BFu0i_BFu0c_BFu0s { unsigned int :0; unsigned int :0; unsigned char :0; unsigned short :0; };
struct BFu0i_BFu0i_BFu0i { unsigned int :0; unsigned int :0; unsigned int :0; };
struct BFu0i_BFu0i_BFu0i_BFs0c { unsigned int :0; unsigned int :0; unsigned int :0; signed char :0; };
struct BFu0i_BFu0i_BFu0i_BFs0i { unsigned int :0; unsigned int :0; unsigned int :0; signed int :0; };
struct BFu0i_BFu0i_BFu0i_BFs0ll { unsigned int :0; unsigned int :0; unsigned int :0; signed long long :0; };
struct BFu0i_BFu0i_BFu0i_BFs0s { unsigned int :0; unsigned int :0; unsigned int :0; signed short :0; };
struct BFu0i_BFu0i_BFu0i_BFu0c { unsigned int :0; unsigned int :0; unsigned int :0; unsigned char :0; };
struct BFu0i_BFu0i_BFu0i_BFu0i { unsigned int :0; unsigned int :0; unsigned int :0; unsigned int :0; };
struct BFu0i_BFu0i_BFu0i_BFu0ll { unsigned int :0; unsigned int :0; unsigned int :0; unsigned long long :0; };
struct BFu0i_BFu0i_BFu0i_BFu0s { unsigned int :0; unsigned int :0; unsigned int :0; unsigned short :0; };
struct BFu0i_BFu0i_BFu0ll { unsigned int :0; unsigned int :0; unsigned long long :0; };
struct BFu0i_BFu0i_BFu0ll_BFs0c { unsigned int :0; unsigned int :0; unsigned long long :0; signed char :0; };
struct BFu0i_BFu0i_BFu0ll_BFs0i { unsigned int :0; unsigned int :0; unsigned long long :0; signed int :0; };
struct BFu0i_BFu0i_BFu0ll_BFs0ll { unsigned int :0; unsigned int :0; unsigned long long :0; signed long long :0; };
struct BFu0i_BFu0i_BFu0ll_BFs0s { unsigned int :0; unsigned int :0; unsigned long long :0; signed short :0; };
struct BFu0i_BFu0i_BFu0ll_BFu0c { unsigned int :0; unsigned int :0; unsigned long long :0; unsigned char :0; };
struct BFu0i_BFu0i_BFu0ll_BFu0i { unsigned int :0; unsigned int :0; unsigned long long :0; unsigned int :0; };
struct BFu0i_BFu0i_BFu0ll_BFu0ll { unsigned int :0; unsigned int :0; unsigned long long :0; unsigned long long :0; };
struct BFu0i_BFu0i_BFu0ll_BFu0s { unsigned int :0; unsigned int :0; unsigned long long :0; unsigned short :0; };
struct BFu0i_BFu0i_BFu0s { unsigned int :0; unsigned int :0; unsigned short :0; };
struct BFu0i_BFu0i_BFu0s_BFs0c { unsigned int :0; unsigned int :0; unsigned short :0; signed char :0; };
struct BFu0i_BFu0i_BFu0s_BFs0i { unsigned int :0; unsigned int :0; unsigned short :0; signed int :0; };
struct BFu0i_BFu0i_BFu0s_BFs0ll { unsigned int :0; unsigned int :0; unsigned short :0; signed long long :0; };
struct BFu0i_BFu0i_BFu0s_BFs0s { unsigned int :0; unsigned int :0; unsigned short :0; signed short :0; };
struct BFu0i_BFu0i_BFu0s_BFu0c { unsigned int :0; unsigned int :0; unsigned short :0; unsigned char :0; };
struct BFu0i_BFu0i_BFu0s_BFu0i { unsigned int :0; unsigned int :0; unsigned short :0; unsigned int :0; };
struct BFu0i_BFu0i_BFu0s_BFu0ll { unsigned int :0; unsigned int :0; unsigned short :0; unsigned long long :0; };
struct BFu0i_BFu0i_BFu0s_BFu0s { unsigned int :0; unsigned int :0; unsigned short :0; unsigned short :0; };
struct BFu0i_BFu0i_BFu15i { unsigned int :0; unsigned int :0; unsigned int v1:15; };
struct BFu0i_BFu0i_BFu15ll { unsigned int :0; unsigned int :0; unsigned long long v1:15; };
struct BFu0i_BFu0i_BFu15s { unsigned int :0; unsigned int :0; unsigned short v1:15; };
struct BFu0i_BFu0i_BFu16i { unsigned int :0; unsigned int :0; unsigned int v1:16; };
struct BFu0i_BFu0i_BFu16ll { unsigned int :0; unsigned int :0; unsigned long long v1:16; };
struct BFu0i_BFu0i_BFu16s { unsigned int :0; unsigned int :0; unsigned short v1:16; };
struct BFu0i_BFu0i_BFu17i { unsigned int :0; unsigned int :0; unsigned int v1:17; };
struct BFu0i_BFu0i_BFu17ll { unsigned int :0; unsigned int :0; unsigned long long v1:17; };
struct BFu0i_BFu0i_BFu1c { unsigned int :0; unsigned int :0; unsigned char v1:1; };
struct BFu0i_BFu0i_BFu1i { unsigned int :0; unsigned int :0; unsigned int v1:1; };
struct BFu0i_BFu0i_BFu1ll { unsigned int :0; unsigned int :0; unsigned long long v1:1; };
struct BFu0i_BFu0i_BFu1s { unsigned int :0; unsigned int :0; unsigned short v1:1; };
struct BFu0i_BFu0i_BFu31i { unsigned int :0; unsigned int :0; unsigned int v1:31; };
struct BFu0i_BFu0i_BFu31ll { unsigned int :0; unsigned int :0; unsigned long long v1:31; };
struct BFu0i_BFu0i_BFu32i { unsigned int :0; unsigned int :0; unsigned int v1:32; };
struct BFu0i_BFu0i_BFu32ll { unsigned int :0; unsigned int :0; unsigned long long v1:32; };
struct BFu0i_BFu0i_BFu33 { unsigned int :0; unsigned int :0; unsigned long long v1:33; };
struct BFu0i_BFu0i_BFu7c { unsigned int :0; unsigned int :0; unsigned char v1:7; };
struct BFu0i_BFu0i_BFu7i { unsigned int :0; unsigned int :0; unsigned int v1:7; };
struct BFu0i_BFu0i_BFu7ll { unsigned int :0; unsigned int :0; unsigned long long v1:7; };
struct BFu0i_BFu0i_BFu7s { unsigned int :0; unsigned int :0; unsigned short v1:7; };
struct BFu0i_BFu0i_BFu8c { unsigned int :0; unsigned int :0; unsigned char v1:8; };
struct BFu0i_BFu0i_BFu8i { unsigned int :0; unsigned int :0; unsigned int v1:8; };
struct BFu0i_BFu0i_BFu8ll { unsigned int :0; unsigned int :0; unsigned long long v1:8; };
struct BFu0i_BFu0i_BFu8s { unsigned int :0; unsigned int :0; unsigned short v1:8; };
struct BFu0i_BFu0i_BFu9i { unsigned int :0; unsigned int :0; unsigned int v1:9; };
struct BFu0i_BFu0i_BFu9ll { unsigned int :0; unsigned int :0; unsigned long long v1:9; };
struct BFu0i_BFu0i_BFu9s { unsigned int :0; unsigned int :0; unsigned short v1:9; };
struct BFu0i_BFu0i_C { unsigned int :0; unsigned int :0; char v1; };
struct BFu0i_BFu0i_D { unsigned int :0; unsigned int :0; double v1; };
struct BFu0i_BFu0i_F { unsigned int :0; unsigned int :0; float v1; };
struct BFu0i_BFu0i_I { unsigned int :0; unsigned int :0; int v1; };
struct BFu0i_BFu0i_Ip { unsigned int :0; unsigned int :0; int * v1; };
struct BFu0i_BFu0i_L { unsigned int :0; unsigned int :0; long long v1; };
struct BFu0i_BFu0i_S { unsigned int :0; unsigned int :0; short v1; };
struct BFu0i_BFu0i_Uc { unsigned int :0; unsigned int :0; unsigned char v1; };
struct BFu0i_BFu0i_Ui { unsigned int :0; unsigned int :0; unsigned int v1; };
struct BFu0i_BFu0i_Ul { unsigned int :0; unsigned int :0; unsigned long long v1; };
struct BFu0i_BFu0i_Us { unsigned int :0; unsigned int :0; unsigned short v1; };
struct BFu0i_BFu0i_Vp { unsigned int :0; unsigned int :0; void * v1; };
struct BFu0i_BFu0ll { unsigned int :0; unsigned long long :0; };
struct BFu0i_BFu0ll_BFs0c { unsigned int :0; unsigned long long :0; signed char :0; };
struct BFu0i_BFu0ll_BFs0c_BFs0c { unsigned int :0; unsigned long long :0; signed char :0; signed char :0; };
struct BFu0i_BFu0ll_BFs0c_BFs0i { unsigned int :0; unsigned long long :0; signed char :0; signed int :0; };
struct BFu0i_BFu0ll_BFs0c_BFs0ll { unsigned int :0; unsigned long long :0; signed char :0; signed long long :0; };
struct BFu0i_BFu0ll_BFs0c_BFs0s { unsigned int :0; unsigned long long :0; signed char :0; signed short :0; };
struct BFu0i_BFu0ll_BFs0c_BFu0c { unsigned int :0; unsigned long long :0; signed char :0; unsigned char :0; };
struct BFu0i_BFu0ll_BFs0c_BFu0i { unsigned int :0; unsigned long long :0; signed char :0; unsigned int :0; };
struct BFu0i_BFu0ll_BFs0c_BFu0ll { unsigned int :0; unsigned long long :0; signed char :0; unsigned long long :0; };
struct BFu0i_BFu0ll_BFs0c_BFu0s { unsigned int :0; unsigned long long :0; signed char :0; unsigned short :0; };
struct BFu0i_BFu0ll_BFs0i { unsigned int :0; unsigned long long :0; signed int :0; };
struct BFu0i_BFu0ll_BFs0i_BFs0c { unsigned int :0; unsigned long long :0; signed int :0; signed char :0; };
struct BFu0i_BFu0ll_BFs0i_BFs0i { unsigned int :0; unsigned long long :0; signed int :0; signed int :0; };
struct BFu0i_BFu0ll_BFs0i_BFs0ll { unsigned int :0; unsigned long long :0; signed int :0; signed long long :0; };
struct BFu0i_BFu0ll_BFs0i_BFs0s { unsigned int :0; unsigned long long :0; signed int :0; signed short :0; };
struct BFu0i_BFu0ll_BFs0i_BFu0c { unsigned int :0; unsigned long long :0; signed int :0; unsigned char :0; };
struct BFu0i_BFu0ll_BFs0i_BFu0i { unsigned int :0; unsigned long long :0; signed int :0; unsigned int :0; };
struct BFu0i_BFu0ll_BFs0i_BFu0ll { unsigned int :0; unsigned long long :0; signed int :0; unsigned long long :0; };
struct BFu0i_BFu0ll_BFs0i_BFu0s { unsigned int :0; unsigned long long :0; signed int :0; unsigned short :0; };
struct BFu0i_BFu0ll_BFs0ll { unsigned int :0; unsigned long long :0; signed long long :0; };
struct BFu0i_BFu0ll_BFs0ll_BFs0c { unsigned int :0; unsigned long long :0; signed long long :0; signed char :0; };
struct BFu0i_BFu0ll_BFs0ll_BFs0i { unsigned int :0; unsigned long long :0; signed long long :0; signed int :0; };
struct BFu0i_BFu0ll_BFs0ll_BFs0ll { unsigned int :0; unsigned long long :0; signed long long :0; signed long long :0; };
struct BFu0i_BFu0ll_BFs0ll_BFs0s { unsigned int :0; unsigned long long :0; signed long long :0; signed short :0; };
struct BFu0i_BFu0ll_BFs0ll_BFu0c { unsigned int :0; unsigned long long :0; signed long long :0; unsigned char :0; };
struct BFu0i_BFu0ll_BFs0ll_BFu0i { unsigned int :0; unsigned long long :0; signed long long :0; unsigned int :0; };
struct BFu0i_BFu0ll_BFs0ll_BFu0ll { unsigned int :0; unsigned long long :0; signed long long :0; unsigned long long :0; };
struct BFu0i_BFu0ll_BFs0ll_BFu0s { unsigned int :0; unsigned long long :0; signed long long :0; unsigned short :0; };
struct BFu0i_BFu0ll_BFs0s { unsigned int :0; unsigned long long :0; signed short :0; };
struct BFu0i_BFu0ll_BFs0s_BFs0c { unsigned int :0; unsigned long long :0; signed short :0; signed char :0; };
struct BFu0i_BFu0ll_BFs0s_BFs0i { unsigned int :0; unsigned long long :0; signed short :0; signed int :0; };
struct BFu0i_BFu0ll_BFs0s_BFs0ll { unsigned int :0; unsigned long long :0; signed short :0; signed long long :0; };
struct BFu0i_BFu0ll_BFs0s_BFs0s { unsigned int :0; unsigned long long :0; signed short :0; signed short :0; };
struct BFu0i_BFu0ll_BFs0s_BFu0c { unsigned int :0; unsigned long long :0; signed short :0; unsigned char :0; };
struct BFu0i_BFu0ll_BFs0s_BFu0i { unsigned int :0; unsigned long long :0; signed short :0; unsigned int :0; };
struct BFu0i_BFu0ll_BFs0s_BFu0ll { unsigned int :0; unsigned long long :0; signed short :0; unsigned long long :0; };
struct BFu0i_BFu0ll_BFs0s_BFu0s { unsigned int :0; unsigned long long :0; signed short :0; unsigned short :0; };
struct BFu0i_BFu0ll_BFu0c { unsigned int :0; unsigned long long :0; unsigned char :0; };
struct BFu0i_BFu0ll_BFu0c_BFs0c { unsigned int :0; unsigned long long :0; unsigned char :0; signed char :0; };
struct BFu0i_BFu0ll_BFu0c_BFs0i { unsigned int :0; unsigned long long :0; unsigned char :0; signed int :0; };
struct BFu0i_BFu0ll_BFu0c_BFs0ll { unsigned int :0; unsigned long long :0; unsigned char :0; signed long long :0; };
struct BFu0i_BFu0ll_BFu0c_BFs0s { unsigned int :0; unsigned long long :0; unsigned char :0; signed short :0; };
struct BFu0i_BFu0ll_BFu0c_BFu0c { unsigned int :0; unsigned long long :0; unsigned char :0; unsigned char :0; };
struct BFu0i_BFu0ll_BFu0c_BFu0i { unsigned int :0; unsigned long long :0; unsigned char :0; unsigned int :0; };
struct BFu0i_BFu0ll_BFu0c_BFu0ll { unsigned int :0; unsigned long long :0; unsigned char :0; unsigned long long :0; };
struct BFu0i_BFu0ll_BFu0c_BFu0s { unsigned int :0; unsigned long long :0; unsigned char :0; unsigned short :0; };
struct BFu0i_BFu0ll_BFu0i { unsigned int :0; unsigned long long :0; unsigned int :0; };
struct BFu0i_BFu0ll_BFu0i_BFs0c { unsigned int :0; unsigned long long :0; unsigned int :0; signed char :0; };
struct BFu0i_BFu0ll_BFu0i_BFs0i { unsigned int :0; unsigned long long :0; unsigned int :0; signed int :0; };
struct BFu0i_BFu0ll_BFu0i_BFs0ll { unsigned int :0; unsigned long long :0; unsigned int :0; signed long long :0; };
struct BFu0i_BFu0ll_BFu0i_BFs0s { unsigned int :0; unsigned long long :0; unsigned int :0; signed short :0; };
struct BFu0i_BFu0ll_BFu0i_BFu0c { unsigned int :0; unsigned long long :0; unsigned int :0; unsigned char :0; };
struct BFu0i_BFu0ll_BFu0i_BFu0i { unsigned int :0; unsigned long long :0; unsigned int :0; unsigned int :0; };
struct BFu0i_BFu0ll_BFu0i_BFu0ll { unsigned int :0; unsigned long long :0; unsigned int :0; unsigned long long :0; };
struct BFu0i_BFu0ll_BFu0i_BFu0s { unsigned int :0; unsigned long long :0; unsigned int :0; unsigned short :0; };
struct BFu0i_BFu0ll_BFu0ll { unsigned int :0; unsigned long long :0; unsigned long long :0; };
struct BFu0i_BFu0ll_BFu0ll_BFs0c { unsigned int :0; unsigned long long :0; unsigned long long :0; signed char :0; };
struct BFu0i_BFu0ll_BFu0ll_BFs0i { unsigned int :0; unsigned long long :0; unsigned long long :0; signed int :0; };
struct BFu0i_BFu0ll_BFu0ll_BFs0ll { unsigned int :0; unsigned long long :0; unsigned long long :0; signed long long :0; };
struct BFu0i_BFu0ll_BFu0ll_BFs0s { unsigned int :0; unsigned long long :0; unsigned long long :0; signed short :0; };
struct BFu0i_BFu0ll_BFu0ll_BFu0c { unsigned int :0; unsigned long long :0; unsigned long long :0; unsigned char :0; };
struct BFu0i_BFu0ll_BFu0ll_BFu0i { unsigned int :0; unsigned long long :0; unsigned long long :0; unsigned int :0; };
struct BFu0i_BFu0ll_BFu0ll_BFu0ll { unsigned int :0; unsigned long long :0; unsigned long long :0; unsigned long long :0; };
struct BFu0i_BFu0ll_BFu0ll_BFu0s { unsigned int :0; unsigned long long :0; unsigned long long :0; unsigned short :0; };
struct BFu0i_BFu0ll_BFu0s { unsigned int :0; unsigned long long :0; unsigned short :0; };
struct BFu0i_BFu0ll_BFu0s_BFs0c { unsigned int :0; unsigned long long :0; unsigned short :0; signed char :0; };
struct BFu0i_BFu0ll_BFu0s_BFs0i { unsigned int :0; unsigned long long :0; unsigned short :0; signed int :0; };
struct BFu0i_BFu0ll_BFu0s_BFs0ll { unsigned int :0; unsigned long long :0; unsigned short :0; signed long long :0; };
struct BFu0i_BFu0ll_BFu0s_BFs0s { unsigned int :0; unsigned long long :0; unsigned short :0; signed short :0; };
struct BFu0i_BFu0ll_BFu0s_BFu0c { unsigned int :0; unsigned long long :0; unsigned short :0; unsigned char :0; };
struct BFu0i_BFu0ll_BFu0s_BFu0i { unsigned int :0; unsigned long long :0; unsigned short :0; unsigned int :0; };
struct BFu0i_BFu0ll_BFu0s_BFu0ll { unsigned int :0; unsigned long long :0; unsigned short :0; unsigned long long :0; };
struct BFu0i_BFu0ll_BFu0s_BFu0s { unsigned int :0; unsigned long long :0; unsigned short :0; unsigned short :0; };
struct BFu0i_BFu0ll_BFu15i { unsigned int :0; unsigned long long :0; unsigned int v1:15; };
struct BFu0i_BFu0ll_BFu15ll { unsigned int :0; unsigned long long :0; unsigned long long v1:15; };
struct BFu0i_BFu0ll_BFu15s { unsigned int :0; unsigned long long :0; unsigned short v1:15; };
struct BFu0i_BFu0ll_BFu16i { unsigned int :0; unsigned long long :0; unsigned int v1:16; };
struct BFu0i_BFu0ll_BFu16ll { unsigned int :0; unsigned long long :0; unsigned long long v1:16; };
struct BFu0i_BFu0ll_BFu16s { unsigned int :0; unsigned long long :0; unsigned short v1:16; };
struct BFu0i_BFu0ll_BFu17i { unsigned int :0; unsigned long long :0; unsigned int v1:17; };
struct BFu0i_BFu0ll_BFu17ll { unsigned int :0; unsigned long long :0; unsigned long long v1:17; };
struct BFu0i_BFu0ll_BFu1c { unsigned int :0; unsigned long long :0; unsigned char v1:1; };
struct BFu0i_BFu0ll_BFu1i { unsigned int :0; unsigned long long :0; unsigned int v1:1; };
struct BFu0i_BFu0ll_BFu1ll { unsigned int :0; unsigned long long :0; unsigned long long v1:1; };
struct BFu0i_BFu0ll_BFu1s { unsigned int :0; unsigned long long :0; unsigned short v1:1; };
struct BFu0i_BFu0ll_BFu31i { unsigned int :0; unsigned long long :0; unsigned int v1:31; };
struct BFu0i_BFu0ll_BFu31ll { unsigned int :0; unsigned long long :0; unsigned long long v1:31; };
struct BFu0i_BFu0ll_BFu32i { unsigned int :0; unsigned long long :0; unsigned int v1:32; };
struct BFu0i_BFu0ll_BFu32ll { unsigned int :0; unsigned long long :0; unsigned long long v1:32; };
struct BFu0i_BFu0ll_BFu33 { unsigned int :0; unsigned long long :0; unsigned long long v1:33; };
struct BFu0i_BFu0ll_BFu7c { unsigned int :0; unsigned long long :0; unsigned char v1:7; };
struct BFu0i_BFu0ll_BFu7i { unsigned int :0; unsigned long long :0; unsigned int v1:7; };
struct BFu0i_BFu0ll_BFu7ll { unsigned int :0; unsigned long long :0; unsigned long long v1:7; };
struct BFu0i_BFu0ll_BFu7s { unsigned int :0; unsigned long long :0; unsigned short v1:7; };
struct BFu0i_BFu0ll_BFu8c { unsigned int :0; unsigned long long :0; unsigned char v1:8; };
struct BFu0i_BFu0ll_BFu8i { unsigned int :0; unsigned long long :0; unsigned int v1:8; };
struct BFu0i_BFu0ll_BFu8ll { unsigned int :0; unsigned long long :0; unsigned long long v1:8; };
struct BFu0i_BFu0ll_BFu8s { unsigned int :0; unsigned long long :0; unsigned short v1:8; };
struct BFu0i_BFu0ll_BFu9i { unsigned int :0; unsigned long long :0; unsigned int v1:9; };
struct BFu0i_BFu0ll_BFu9ll { unsigned int :0; unsigned long long :0; unsigned long long v1:9; };
struct BFu0i_BFu0ll_BFu9s { unsigned int :0; unsigned long long :0; unsigned short v1:9; };
struct BFu0i_BFu0ll_C { unsigned int :0; unsigned long long :0; char v1; };
struct BFu0i_BFu0ll_D { unsigned int :0; unsigned long long :0; double v1; };
struct BFu0i_BFu0ll_F { unsigned int :0; unsigned long long :0; float v1; };
struct BFu0i_BFu0ll_I { unsigned int :0; unsigned long long :0; int v1; };
struct BFu0i_BFu0ll_Ip { unsigned int :0; unsigned long long :0; int * v1; };
struct BFu0i_BFu0ll_L { unsigned int :0; unsigned long long :0; long long v1; };
struct BFu0i_BFu0ll_S { unsigned int :0; unsigned long long :0; short v1; };
struct BFu0i_BFu0ll_Uc { unsigned int :0; unsigned long long :0; unsigned char v1; };
struct BFu0i_BFu0ll_Ui { unsigned int :0; unsigned long long :0; unsigned int v1; };
struct BFu0i_BFu0ll_Ul { unsigned int :0; unsigned long long :0; unsigned long long v1; };
struct BFu0i_BFu0ll_Us { unsigned int :0; unsigned long long :0; unsigned short v1; };
struct BFu0i_BFu0ll_Vp { unsigned int :0; unsigned long long :0; void * v1; };
struct BFu0i_BFu0s { unsigned int :0; unsigned short :0; };
struct BFu0i_BFu0s_BFs0c { unsigned int :0; unsigned short :0; signed char :0; };
struct BFu0i_BFu0s_BFs0c_BFs0c { unsigned int :0; unsigned short :0; signed char :0; signed char :0; };
struct BFu0i_BFu0s_BFs0c_BFs0i { unsigned int :0; unsigned short :0; signed char :0; signed int :0; };
struct BFu0i_BFu0s_BFs0c_BFs0ll { unsigned int :0; unsigned short :0; signed char :0; signed long long :0; };
struct BFu0i_BFu0s_BFs0c_BFs0s { unsigned int :0; unsigned short :0; signed char :0; signed short :0; };
struct BFu0i_BFu0s_BFs0c_BFu0c { unsigned int :0; unsigned short :0; signed char :0; unsigned char :0; };
struct BFu0i_BFu0s_BFs0c_BFu0i { unsigned int :0; unsigned short :0; signed char :0; unsigned int :0; };
struct BFu0i_BFu0s_BFs0c_BFu0ll { unsigned int :0; unsigned short :0; signed char :0; unsigned long long :0; };
struct BFu0i_BFu0s_BFs0c_BFu0s { unsigned int :0; unsigned short :0; signed char :0; unsigned short :0; };
struct BFu0i_BFu0s_BFs0i { unsigned int :0; unsigned short :0; signed int :0; };
struct BFu0i_BFu0s_BFs0i_BFs0c { unsigned int :0; unsigned short :0; signed int :0; signed char :0; };
struct BFu0i_BFu0s_BFs0i_BFs0i { unsigned int :0; unsigned short :0; signed int :0; signed int :0; };
struct BFu0i_BFu0s_BFs0i_BFs0ll { unsigned int :0; unsigned short :0; signed int :0; signed long long :0; };
struct BFu0i_BFu0s_BFs0i_BFs0s { unsigned int :0; unsigned short :0; signed int :0; signed short :0; };
struct BFu0i_BFu0s_BFs0i_BFu0c { unsigned int :0; unsigned short :0; signed int :0; unsigned char :0; };
struct BFu0i_BFu0s_BFs0i_BFu0i { unsigned int :0; unsigned short :0; signed int :0; unsigned int :0; };
struct BFu0i_BFu0s_BFs0i_BFu0ll { unsigned int :0; unsigned short :0; signed int :0; unsigned long long :0; };
struct BFu0i_BFu0s_BFs0i_BFu0s { unsigned int :0; unsigned short :0; signed int :0; unsigned short :0; };
struct BFu0i_BFu0s_BFs0ll { unsigned int :0; unsigned short :0; signed long long :0; };
struct BFu0i_BFu0s_BFs0ll_BFs0c { unsigned int :0; unsigned short :0; signed long long :0; signed char :0; };
struct BFu0i_BFu0s_BFs0ll_BFs0i { unsigned int :0; unsigned short :0; signed long long :0; signed int :0; };
struct BFu0i_BFu0s_BFs0ll_BFs0ll { unsigned int :0; unsigned short :0; signed long long :0; signed long long :0; };
struct BFu0i_BFu0s_BFs0ll_BFs0s { unsigned int :0; unsigned short :0; signed long long :0; signed short :0; };
struct BFu0i_BFu0s_BFs0ll_BFu0c { unsigned int :0; unsigned short :0; signed long long :0; unsigned char :0; };
struct BFu0i_BFu0s_BFs0ll_BFu0i { unsigned int :0; unsigned short :0; signed long long :0; unsigned int :0; };
struct BFu0i_BFu0s_BFs0ll_BFu0ll { unsigned int :0; unsigned short :0; signed long long :0; unsigned long long :0; };
struct BFu0i_BFu0s_BFs0ll_BFu0s { unsigned int :0; unsigned short :0; signed long long :0; unsigned short :0; };
struct BFu0i_BFu0s_BFs0s { unsigned int :0; unsigned short :0; signed short :0; };
struct BFu0i_BFu0s_BFs0s_BFs0c { unsigned int :0; unsigned short :0; signed short :0; signed char :0; };
struct BFu0i_BFu0s_BFs0s_BFs0i { unsigned int :0; unsigned short :0; signed short :0; signed int :0; };
struct BFu0i_BFu0s_BFs0s_BFs0ll { unsigned int :0; unsigned short :0; signed short :0; signed long long :0; };
struct BFu0i_BFu0s_BFs0s_BFs0s { unsigned int :0; unsigned short :0; signed short :0; signed short :0; };
struct BFu0i_BFu0s_BFs0s_BFu0c { unsigned int :0; unsigned short :0; signed short :0; unsigned char :0; };
struct BFu0i_BFu0s_BFs0s_BFu0i { unsigned int :0; unsigned short :0; signed short :0; unsigned int :0; };
struct BFu0i_BFu0s_BFs0s_BFu0ll { unsigned int :0; unsigned short :0; signed short :0; unsigned long long :0; };
struct BFu0i_BFu0s_BFs0s_BFu0s { unsigned int :0; unsigned short :0; signed short :0; unsigned short :0; };
struct BFu0i_BFu0s_BFu0c { unsigned int :0; unsigned short :0; unsigned char :0; };
struct BFu0i_BFu0s_BFu0c_BFs0c { unsigned int :0; unsigned short :0; unsigned char :0; signed char :0; };
struct BFu0i_BFu0s_BFu0c_BFs0i { unsigned int :0; unsigned short :0; unsigned char :0; signed int :0; };
struct BFu0i_BFu0s_BFu0c_BFs0ll { unsigned int :0; unsigned short :0; unsigned char :0; signed long long :0; };
struct BFu0i_BFu0s_BFu0c_BFs0s { unsigned int :0; unsigned short :0; unsigned char :0; signed short :0; };
struct BFu0i_BFu0s_BFu0c_BFu0c { unsigned int :0; unsigned short :0; unsigned char :0; unsigned char :0; };
struct BFu0i_BFu0s_BFu0c_BFu0i { unsigned int :0; unsigned short :0; unsigned char :0; unsigned int :0; };
struct BFu0i_BFu0s_BFu0c_BFu0ll { unsigned int :0; unsigned short :0; unsigned char :0; unsigned long long :0; };
struct BFu0i_BFu0s_BFu0c_BFu0s { unsigned int :0; unsigned short :0; unsigned char :0; unsigned short :0; };
struct BFu0i_BFu0s_BFu0i { unsigned int :0; unsigned short :0; unsigned int :0; };
struct BFu0i_BFu0s_BFu0i_BFs0c { unsigned int :0; unsigned short :0; unsigned int :0; signed char :0; };
struct BFu0i_BFu0s_BFu0i_BFs0i { unsigned int :0; unsigned short :0; unsigned int :0; signed int :0; };
struct BFu0i_BFu0s_BFu0i_BFs0ll { unsigned int :0; unsigned short :0; unsigned int :0; signed long long :0; };
struct BFu0i_BFu0s_BFu0i_BFs0s { unsigned int :0; unsigned short :0; unsigned int :0; signed short :0; };
struct BFu0i_BFu0s_BFu0i_BFu0c { unsigned int :0; unsigned short :0; unsigned int :0; unsigned char :0; };
struct BFu0i_BFu0s_BFu0i_BFu0i { unsigned int :0; unsigned short :0; unsigned int :0; unsigned int :0; };
struct BFu0i_BFu0s_BFu0i_BFu0ll { unsigned int :0; unsigned short :0; unsigned int :0; unsigned long long :0; };
struct BFu0i_BFu0s_BFu0i_BFu0s { unsigned int :0; unsigned short :0; unsigned int :0; unsigned short :0; };
struct BFu0i_BFu0s_BFu0ll { unsigned int :0; unsigned short :0; unsigned long long :0; };
struct BFu0i_BFu0s_BFu0ll_BFs0c { unsigned int :0; unsigned short :0; unsigned long long :0; signed char :0; };
struct BFu0i_BFu0s_BFu0ll_BFs0i { unsigned int :0; unsigned short :0; unsigned long long :0; signed int :0; };
struct BFu0i_BFu0s_BFu0ll_BFs0ll { unsigned int :0; unsigned short :0; unsigned long long :0; signed long long :0; };
struct BFu0i_BFu0s_BFu0ll_BFs0s { unsigned int :0; unsigned short :0; unsigned long long :0; signed short :0; };
struct BFu0i_BFu0s_BFu0ll_BFu0c { unsigned int :0; unsigned short :0; unsigned long long :0; unsigned char :0; };
struct BFu0i_BFu0s_BFu0ll_BFu0i { unsigned int :0; unsigned short :0; unsigned long long :0; unsigned int :0; };
struct BFu0i_BFu0s_BFu0ll_BFu0ll { unsigned int :0; unsigned short :0; unsigned long long :0; unsigned long long :0; };
struct BFu0i_BFu0s_BFu0ll_BFu0s { unsigned int :0; unsigned short :0; unsigned long long :0; unsigned short :0; };
struct BFu0i_BFu0s_BFu0s { unsigned int :0; unsigned short :0; unsigned short :0; };
struct BFu0i_BFu0s_BFu0s_BFs0c { unsigned int :0; unsigned short :0; unsigned short :0; signed char :0; };
struct BFu0i_BFu0s_BFu0s_BFs0i { unsigned int :0; unsigned short :0; unsigned short :0; signed int :0; };
struct BFu0i_BFu0s_BFu0s_BFs0ll { unsigned int :0; unsigned short :0; unsigned short :0; signed long long :0; };
struct BFu0i_BFu0s_BFu0s_BFs0s { unsigned int :0; unsigned short :0; unsigned short :0; signed short :0; };
struct BFu0i_BFu0s_BFu0s_BFu0c { unsigned int :0; unsigned short :0; unsigned short :0; unsigned char :0; };
struct BFu0i_BFu0s_BFu0s_BFu0i { unsigned int :0; unsigned short :0; unsigned short :0; unsigned int :0; };
struct BFu0i_BFu0s_BFu0s_BFu0ll { unsigned int :0; unsigned short :0; unsigned short :0; unsigned long long :0; };
struct BFu0i_BFu0s_BFu0s_BFu0s { unsigned int :0; unsigned short :0; unsigned short :0; unsigned short :0; };
struct BFu0i_BFu0s_BFu15i { unsigned int :0; unsigned short :0; unsigned int v1:15; };
struct BFu0i_BFu0s_BFu15ll { unsigned int :0; unsigned short :0; unsigned long long v1:15; };
struct BFu0i_BFu0s_BFu15s { unsigned int :0; unsigned short :0; unsigned short v1:15; };
struct BFu0i_BFu0s_BFu16i { unsigned int :0; unsigned short :0; unsigned int v1:16; };
struct BFu0i_BFu0s_BFu16ll { unsigned int :0; unsigned short :0; unsigned long long v1:16; };
struct BFu0i_BFu0s_BFu16s { unsigned int :0; unsigned short :0; unsigned short v1:16; };
struct BFu0i_BFu0s_BFu17i { unsigned int :0; unsigned short :0; unsigned int v1:17; };
struct BFu0i_BFu0s_BFu17ll { unsigned int :0; unsigned short :0; unsigned long long v1:17; };
struct BFu0i_BFu0s_BFu1c { unsigned int :0; unsigned short :0; unsigned char v1:1; };
struct BFu0i_BFu0s_BFu1i { unsigned int :0; unsigned short :0; unsigned int v1:1; };
struct BFu0i_BFu0s_BFu1ll { unsigned int :0; unsigned short :0; unsigned long long v1:1; };
struct BFu0i_BFu0s_BFu1s { unsigned int :0; unsigned short :0; unsigned short v1:1; };
struct BFu0i_BFu0s_BFu31i { unsigned int :0; unsigned short :0; unsigned int v1:31; };
struct BFu0i_BFu0s_BFu31ll { unsigned int :0; unsigned short :0; unsigned long long v1:31; };
struct BFu0i_BFu0s_BFu32i { unsigned int :0; unsigned short :0; unsigned int v1:32; };
struct BFu0i_BFu0s_BFu32ll { unsigned int :0; unsigned short :0; unsigned long long v1:32; };
struct BFu0i_BFu0s_BFu33 { unsigned int :0; unsigned short :0; unsigned long long v1:33; };
struct BFu0i_BFu0s_BFu7c { unsigned int :0; unsigned short :0; unsigned char v1:7; };
struct BFu0i_BFu0s_BFu7i { unsigned int :0; unsigned short :0; unsigned int v1:7; };
struct BFu0i_BFu0s_BFu7ll { unsigned int :0; unsigned short :0; unsigned long long v1:7; };
struct BFu0i_BFu0s_BFu7s { unsigned int :0; unsigned short :0; unsigned short v1:7; };
struct BFu0i_BFu0s_BFu8c { unsigned int :0; unsigned short :0; unsigned char v1:8; };
struct BFu0i_BFu0s_BFu8i { unsigned int :0; unsigned short :0; unsigned int v1:8; };
struct BFu0i_BFu0s_BFu8ll { unsigned int :0; unsigned short :0; unsigned long long v1:8; };
struct BFu0i_BFu0s_BFu8s { unsigned int :0; unsigned short :0; unsigned short v1:8; };
struct BFu0i_BFu0s_BFu9i { unsigned int :0; unsigned short :0; unsigned int v1:9; };
struct BFu0i_BFu0s_BFu9ll { unsigned int :0; unsigned short :0; unsigned long long v1:9; };
struct BFu0i_BFu0s_BFu9s { unsigned int :0; unsigned short :0; unsigned short v1:9; };
struct BFu0i_BFu0s_C { unsigned int :0; unsigned short :0; char v1; };
struct BFu0i_BFu0s_D { unsigned int :0; unsigned short :0; double v1; };
struct BFu0i_BFu0s_F { unsigned int :0; unsigned short :0; float v1; };
struct BFu0i_BFu0s_I { unsigned int :0; unsigned short :0; int v1; };
struct BFu0i_BFu0s_Ip { unsigned int :0; unsigned short :0; int * v1; };
struct BFu0i_BFu0s_L { unsigned int :0; unsigned short :0; long long v1; };
struct BFu0i_BFu0s_S { unsigned int :0; unsigned short :0; short v1; };
struct BFu0i_BFu0s_Uc { unsigned int :0; unsigned short :0; unsigned char v1; };
struct BFu0i_BFu0s_Ui { unsigned int :0; unsigned short :0; unsigned int v1; };
struct BFu0i_BFu0s_Ul { unsigned int :0; unsigned short :0; unsigned long long v1; };
struct BFu0i_BFu0s_Us { unsigned int :0; unsigned short :0; unsigned short v1; };
struct BFu0i_BFu0s_Vp { unsigned int :0; unsigned short :0; void * v1; };
struct BFu0i_BFu15i { unsigned int :0; unsigned int v1:15; };
struct BFu0i_BFu15i_BFu0c { unsigned int :0; unsigned int v1:15; unsigned char :0; };
struct BFu0i_BFu15i_BFu0i { unsigned int :0; unsigned int v1:15; unsigned int :0; };
struct BFu0i_BFu15i_BFu0ll { unsigned int :0; unsigned int v1:15; unsigned long long :0; };
struct BFu0i_BFu15i_BFu0s { unsigned int :0; unsigned int v1:15; unsigned short :0; };
struct BFu0i_BFu15i_BFu15i { unsigned int :0; unsigned int v1:15; unsigned int v2:15; };
struct BFu0i_BFu15i_BFu15ll { unsigned int :0; unsigned int v1:15; unsigned long long v2:15; };
struct BFu0i_BFu15i_BFu15s { unsigned int :0; unsigned int v1:15; unsigned short v2:15; };
struct BFu0i_BFu15i_BFu16i { unsigned int :0; unsigned int v1:15; unsigned int v2:16; };
struct BFu0i_BFu15i_BFu16ll { unsigned int :0; unsigned int v1:15; unsigned long long v2:16; };
struct BFu0i_BFu15i_BFu16s { unsigned int :0; unsigned int v1:15; unsigned short v2:16; };
struct BFu0i_BFu15i_BFu17i { unsigned int :0; unsigned int v1:15; unsigned int v2:17; };
struct BFu0i_BFu15i_BFu17ll { unsigned int :0; unsigned int v1:15; unsigned long long v2:17; };
struct BFu0i_BFu15i_BFu1c { unsigned int :0; unsigned int v1:15; unsigned char v2:1; };
struct BFu0i_BFu15i_BFu1i { unsigned int :0; unsigned int v1:15; unsigned int v2:1; };
struct BFu0i_BFu15i_BFu1ll { unsigned int :0; unsigned int v1:15; unsigned long long v2:1; };
struct BFu0i_BFu15i_BFu1s { unsigned int :0; unsigned int v1:15; unsigned short v2:1; };
struct BFu0i_BFu15i_BFu31i { unsigned int :0; unsigned int v1:15; unsigned int v2:31; };
struct BFu0i_BFu15i_BFu31ll { unsigned int :0; unsigned int v1:15; unsigned long long v2:31; };
struct BFu0i_BFu15i_BFu32i { unsigned int :0; unsigned int v1:15; unsigned int v2:32; };
struct BFu0i_BFu15i_BFu32ll { unsigned int :0; unsigned int v1:15; unsigned long long v2:32; };
struct BFu0i_BFu15i_BFu33 { unsigned int :0; unsigned int v1:15; unsigned long long v2:33; };
struct BFu0i_BFu15i_BFu7c { unsigned int :0; unsigned int v1:15; unsigned char v2:7; };
struct BFu0i_BFu15i_BFu7i { unsigned int :0; unsigned int v1:15; unsigned int v2:7; };
struct BFu0i_BFu15i_BFu7ll { unsigned int :0; unsigned int v1:15; unsigned long long v2:7; };
struct BFu0i_BFu15i_BFu7s { unsigned int :0; unsigned int v1:15; unsigned short v2:7; };
struct BFu0i_BFu15i_BFu8c { unsigned int :0; unsigned int v1:15; unsigned char v2:8; };
struct BFu0i_BFu15i_BFu8i { unsigned int :0; unsigned int v1:15; unsigned int v2:8; };
struct BFu0i_BFu15i_BFu8ll { unsigned int :0; unsigned int v1:15; unsigned long long v2:8; };
struct BFu0i_BFu15i_BFu8s { unsigned int :0; unsigned int v1:15; unsigned short v2:8; };
struct BFu0i_BFu15i_BFu9i { unsigned int :0; unsigned int v1:15; unsigned int v2:9; };
struct BFu0i_BFu15i_BFu9ll { unsigned int :0; unsigned int v1:15; unsigned long long v2:9; };
struct BFu0i_BFu15i_BFu9s { unsigned int :0; unsigned int v1:15; unsigned short v2:9; };
struct BFu0i_BFu15i_C { unsigned int :0; unsigned int v1:15; char v2; };
struct BFu0i_BFu15i_D { unsigned int :0; unsigned int v1:15; double v2; };
struct BFu0i_BFu15i_F { unsigned int :0; unsigned int v1:15; float v2; };
struct BFu0i_BFu15i_I { unsigned int :0; unsigned int v1:15; int v2; };
struct BFu0i_BFu15i_Ip { unsigned int :0; unsigned int v1:15; int * v2; };
struct BFu0i_BFu15i_L { unsigned int :0; unsigned int v1:15; long long v2; };
struct BFu0i_BFu15i_S { unsigned int :0; unsigned int v1:15; short v2; };
struct BFu0i_BFu15i_Uc { unsigned int :0; unsigned int v1:15; unsigned char v2; };
struct BFu0i_BFu15i_Ui { unsigned int :0; unsigned int v1:15; unsigned int v2; };
struct BFu0i_BFu15i_Ul { unsigned int :0; unsigned int v1:15; unsigned long long v2; };
struct BFu0i_BFu15i_Us { unsigned int :0; unsigned int v1:15; unsigned short v2; };
struct BFu0i_BFu15i_Vp { unsigned int :0; unsigned int v1:15; void * v2; };
struct BFu0i_BFu15ll { unsigned int :0; unsigned long long v1:15; };
struct BFu0i_BFu15ll_BFu0c { unsigned int :0; unsigned long long v1:15; unsigned char :0; };
struct BFu0i_BFu15ll_BFu0i { unsigned int :0; unsigned long long v1:15; unsigned int :0; };
struct BFu0i_BFu15ll_BFu0ll { unsigned int :0; unsigned long long v1:15; unsigned long long :0; };
struct BFu0i_BFu15ll_BFu0s { unsigned int :0; unsigned long long v1:15; unsigned short :0; };
struct BFu0i_BFu15ll_BFu15i { unsigned int :0; unsigned long long v1:15; unsigned int v2:15; };
struct BFu0i_BFu15ll_BFu15ll { unsigned int :0; unsigned long long v1:15; unsigned long long v2:15; };
struct BFu0i_BFu15ll_BFu15s { unsigned int :0; unsigned long long v1:15; unsigned short v2:15; };
struct BFu0i_BFu15ll_BFu16i { unsigned int :0; unsigned long long v1:15; unsigned int v2:16; };
struct BFu0i_BFu15ll_BFu16ll { unsigned int :0; unsigned long long v1:15; unsigned long long v2:16; };
struct BFu0i_BFu15ll_BFu16s { unsigned int :0; unsigned long long v1:15; unsigned short v2:16; };
struct BFu0i_BFu15ll_BFu17i { unsigned int :0; unsigned long long v1:15; unsigned int v2:17; };
struct BFu0i_BFu15ll_BFu17ll { unsigned int :0; unsigned long long v1:15; unsigned long long v2:17; };
struct BFu0i_BFu15ll_BFu1c { unsigned int :0; unsigned long long v1:15; unsigned char v2:1; };
struct BFu0i_BFu15ll_BFu1i { unsigned int :0; unsigned long long v1:15; unsigned int v2:1; };
struct BFu0i_BFu15ll_BFu1ll { unsigned int :0; unsigned long long v1:15; unsigned long long v2:1; };
struct BFu0i_BFu15ll_BFu1s { unsigned int :0; unsigned long long v1:15; unsigned short v2:1; };
struct BFu0i_BFu15ll_BFu31i { unsigned int :0; unsigned long long v1:15; unsigned int v2:31; };
struct BFu0i_BFu15ll_BFu31ll { unsigned int :0; unsigned long long v1:15; unsigned long long v2:31; };
struct BFu0i_BFu15ll_BFu32i { unsigned int :0; unsigned long long v1:15; unsigned int v2:32; };
struct BFu0i_BFu15ll_BFu32ll { unsigned int :0; unsigned long long v1:15; unsigned long long v2:32; };
struct BFu0i_BFu15ll_BFu33 { unsigned int :0; unsigned long long v1:15; unsigned long long v2:33; };
struct BFu0i_BFu15ll_BFu7c { unsigned int :0; unsigned long long v1:15; unsigned char v2:7; };
struct BFu0i_BFu15ll_BFu7i { unsigned int :0; unsigned long long v1:15; unsigned int v2:7; };
struct BFu0i_BFu15ll_BFu7ll { unsigned int :0; unsigned long long v1:15; unsigned long long v2:7; };
struct BFu0i_BFu15ll_BFu7s { unsigned int :0; unsigned long long v1:15; unsigned short v2:7; };
struct BFu0i_BFu15ll_BFu8c { unsigned int :0; unsigned long long v1:15; unsigned char v2:8; };
struct BFu0i_BFu15ll_BFu8i { unsigned int :0; unsigned long long v1:15; unsigned int v2:8; };
struct BFu0i_BFu15ll_BFu8ll { unsigned int :0; unsigned long long v1:15; unsigned long long v2:8; };
struct BFu0i_BFu15ll_BFu8s { unsigned int :0; unsigned long long v1:15; unsigned short v2:8; };
struct BFu0i_BFu15ll_BFu9i { unsigned int :0; unsigned long long v1:15; unsigned int v2:9; };
struct BFu0i_BFu15ll_BFu9ll { unsigned int :0; unsigned long long v1:15; unsigned long long v2:9; };
struct BFu0i_BFu15ll_BFu9s { unsigned int :0; unsigned long long v1:15; unsigned short v2:9; };
struct BFu0i_BFu15ll_C { unsigned int :0; unsigned long long v1:15; char v2; };
struct BFu0i_BFu15ll_D { unsigned int :0; unsigned long long v1:15; double v2; };
struct BFu0i_BFu15ll_F { unsigned int :0; unsigned long long v1:15; float v2; };
struct BFu0i_BFu15ll_I { unsigned int :0; unsigned long long v1:15; int v2; };
struct BFu0i_BFu15ll_Ip { unsigned int :0; unsigned long long v1:15; int * v2; };
struct BFu0i_BFu15ll_L { unsigned int :0; unsigned long long v1:15; long long v2; };
struct BFu0i_BFu15ll_S { unsigned int :0; unsigned long long v1:15; short v2; };
struct BFu0i_BFu15ll_Uc { unsigned int :0; unsigned long long v1:15; unsigned char v2; };
struct BFu0i_BFu15ll_Ui { unsigned int :0; unsigned long long v1:15; unsigned int v2; };
struct BFu0i_BFu15ll_Ul { unsigned int :0; unsigned long long v1:15; unsigned long long v2; };
struct BFu0i_BFu15ll_Us { unsigned int :0; unsigned long long v1:15; unsigned short v2; };
struct BFu0i_BFu15ll_Vp { unsigned int :0; unsigned long long v1:15; void * v2; };
struct BFu0i_BFu15s { unsigned int :0; unsigned short v1:15; };
struct BFu0i_BFu15s_BFu0c { unsigned int :0; unsigned short v1:15; unsigned char :0; };
struct BFu0i_BFu15s_BFu0i { unsigned int :0; unsigned short v1:15; unsigned int :0; };
struct BFu0i_BFu15s_BFu0ll { unsigned int :0; unsigned short v1:15; unsigned long long :0; };
struct BFu0i_BFu15s_BFu0s { unsigned int :0; unsigned short v1:15; unsigned short :0; };
struct BFu0i_BFu15s_BFu15i { unsigned int :0; unsigned short v1:15; unsigned int v2:15; };
struct BFu0i_BFu15s_BFu15ll { unsigned int :0; unsigned short v1:15; unsigned long long v2:15; };
struct BFu0i_BFu15s_BFu15s { unsigned int :0; unsigned short v1:15; unsigned short v2:15; };
struct BFu0i_BFu15s_BFu16i { unsigned int :0; unsigned short v1:15; unsigned int v2:16; };
struct BFu0i_BFu15s_BFu16ll { unsigned int :0; unsigned short v1:15; unsigned long long v2:16; };
struct BFu0i_BFu15s_BFu16s { unsigned int :0; unsigned short v1:15; unsigned short v2:16; };
struct BFu0i_BFu15s_BFu17i { unsigned int :0; unsigned short v1:15; unsigned int v2:17; };
struct BFu0i_BFu15s_BFu17ll { unsigned int :0; unsigned short v1:15; unsigned long long v2:17; };
struct BFu0i_BFu15s_BFu1c { unsigned int :0; unsigned short v1:15; unsigned char v2:1; };
struct BFu0i_BFu15s_BFu1i { unsigned int :0; unsigned short v1:15; unsigned int v2:1; };
struct BFu0i_BFu15s_BFu1ll { unsigned int :0; unsigned short v1:15; unsigned long long v2:1; };
struct BFu0i_BFu15s_BFu1s { unsigned int :0; unsigned short v1:15; unsigned short v2:1; };
struct BFu0i_BFu15s_BFu31i { unsigned int :0; unsigned short v1:15; unsigned int v2:31; };
struct BFu0i_BFu15s_BFu31ll { unsigned int :0; unsigned short v1:15; unsigned long long v2:31; };
struct BFu0i_BFu15s_BFu32i { unsigned int :0; unsigned short v1:15; unsigned int v2:32; };
struct BFu0i_BFu15s_BFu32ll { unsigned int :0; unsigned short v1:15; unsigned long long v2:32; };
struct BFu0i_BFu15s_BFu33 { unsigned int :0; unsigned short v1:15; unsigned long long v2:33; };
struct BFu0i_BFu15s_BFu7c { unsigned int :0; unsigned short v1:15; unsigned char v2:7; };
struct BFu0i_BFu15s_BFu7i { unsigned int :0; unsigned short v1:15; unsigned int v2:7; };
struct BFu0i_BFu15s_BFu7ll { unsigned int :0; unsigned short v1:15; unsigned long long v2:7; };
struct BFu0i_BFu15s_BFu7s { unsigned int :0; unsigned short v1:15; unsigned short v2:7; };
struct BFu0i_BFu15s_BFu8c { unsigned int :0; unsigned short v1:15; unsigned char v2:8; };
struct BFu0i_BFu15s_BFu8i { unsigned int :0; unsigned short v1:15; unsigned int v2:8; };
struct BFu0i_BFu15s_BFu8ll { unsigned int :0; unsigned short v1:15; unsigned long long v2:8; };
struct BFu0i_BFu15s_BFu8s { unsigned int :0; unsigned short v1:15; unsigned short v2:8; };
struct BFu0i_BFu15s_BFu9i { unsigned int :0; unsigned short v1:15; unsigned int v2:9; };
struct BFu0i_BFu15s_BFu9ll { unsigned int :0; unsigned short v1:15; unsigned long long v2:9; };
struct BFu0i_BFu15s_BFu9s { unsigned int :0; unsigned short v1:15; unsigned short v2:9; };
struct BFu0i_BFu15s_C { unsigned int :0; unsigned short v1:15; char v2; };
struct BFu0i_BFu15s_D { unsigned int :0; unsigned short v1:15; double v2; };
struct BFu0i_BFu15s_F { unsigned int :0; unsigned short v1:15; float v2; };
struct BFu0i_BFu15s_I { unsigned int :0; unsigned short v1:15; int v2; };
struct BFu0i_BFu15s_Ip { unsigned int :0; unsigned short v1:15; int * v2; };
struct BFu0i_BFu15s_L { unsigned int :0; unsigned short v1:15; long long v2; };
struct BFu0i_BFu15s_S { unsigned int :0; unsigned short v1:15; short v2; };
struct BFu0i_BFu15s_Uc { unsigned int :0; unsigned short v1:15; unsigned char v2; };
struct BFu0i_BFu15s_Ui { unsigned int :0; unsigned short v1:15; unsigned int v2; };
struct BFu0i_BFu15s_Ul { unsigned int :0; unsigned short v1:15; unsigned long long v2; };
struct BFu0i_BFu15s_Us { unsigned int :0; unsigned short v1:15; unsigned short v2; };
struct BFu0i_BFu15s_Vp { unsigned int :0; unsigned short v1:15; void * v2; };
struct BFu0i_BFu16i { unsigned int :0; unsigned int v1:16; };
struct BFu0i_BFu16i_BFu0c { unsigned int :0; unsigned int v1:16; unsigned char :0; };
struct BFu0i_BFu16i_BFu0i { unsigned int :0; unsigned int v1:16; unsigned int :0; };
struct BFu0i_BFu16i_BFu0ll { unsigned int :0; unsigned int v1:16; unsigned long long :0; };
struct BFu0i_BFu16i_BFu0s { unsigned int :0; unsigned int v1:16; unsigned short :0; };
struct BFu0i_BFu16i_BFu15i { unsigned int :0; unsigned int v1:16; unsigned int v2:15; };
struct BFu0i_BFu16i_BFu15ll { unsigned int :0; unsigned int v1:16; unsigned long long v2:15; };
struct BFu0i_BFu16i_BFu15s { unsigned int :0; unsigned int v1:16; unsigned short v2:15; };
struct BFu0i_BFu16i_BFu16i { unsigned int :0; unsigned int v1:16; unsigned int v2:16; };
struct BFu0i_BFu16i_BFu16ll { unsigned int :0; unsigned int v1:16; unsigned long long v2:16; };
struct BFu0i_BFu16i_BFu16s { unsigned int :0; unsigned int v1:16; unsigned short v2:16; };
struct BFu0i_BFu16i_BFu17i { unsigned int :0; unsigned int v1:16; unsigned int v2:17; };
struct BFu0i_BFu16i_BFu17ll { unsigned int :0; unsigned int v1:16; unsigned long long v2:17; };
struct BFu0i_BFu16i_BFu1c { unsigned int :0; unsigned int v1:16; unsigned char v2:1; };
struct BFu0i_BFu16i_BFu1i { unsigned int :0; unsigned int v1:16; unsigned int v2:1; };
struct BFu0i_BFu16i_BFu1ll { unsigned int :0; unsigned int v1:16; unsigned long long v2:1; };
struct BFu0i_BFu16i_BFu1s { unsigned int :0; unsigned int v1:16; unsigned short v2:1; };
struct BFu0i_BFu16i_BFu31i { unsigned int :0; unsigned int v1:16; unsigned int v2:31; };
struct BFu0i_BFu16i_BFu31ll { unsigned int :0; unsigned int v1:16; unsigned long long v2:31; };
struct BFu0i_BFu16i_BFu32i { unsigned int :0; unsigned int v1:16; unsigned int v2:32; };
struct BFu0i_BFu16i_BFu32ll { unsigned int :0; unsigned int v1:16; unsigned long long v2:32; };
struct BFu0i_BFu16i_BFu33 { unsigned int :0; unsigned int v1:16; unsigned long long v2:33; };
struct BFu0i_BFu16i_BFu7c { unsigned int :0; unsigned int v1:16; unsigned char v2:7; };
struct BFu0i_BFu16i_BFu7i { unsigned int :0; unsigned int v1:16; unsigned int v2:7; };
struct BFu0i_BFu16i_BFu7ll { unsigned int :0; unsigned int v1:16; unsigned long long v2:7; };
struct BFu0i_BFu16i_BFu7s { unsigned int :0; unsigned int v1:16; unsigned short v2:7; };
struct BFu0i_BFu16i_BFu8c { unsigned int :0; unsigned int v1:16; unsigned char v2:8; };
struct BFu0i_BFu16i_BFu8i { unsigned int :0; unsigned int v1:16; unsigned int v2:8; };
struct BFu0i_BFu16i_BFu8ll { unsigned int :0; unsigned int v1:16; unsigned long long v2:8; };
struct BFu0i_BFu16i_BFu8s { unsigned int :0; unsigned int v1:16; unsigned short v2:8; };
struct BFu0i_BFu16i_BFu9i { unsigned int :0; unsigned int v1:16; unsigned int v2:9; };
struct BFu0i_BFu16i_BFu9ll { unsigned int :0; unsigned int v1:16; unsigned long long v2:9; };
struct BFu0i_BFu16i_BFu9s { unsigned int :0; unsigned int v1:16; unsigned short v2:9; };
struct BFu0i_BFu16i_C { unsigned int :0; unsigned int v1:16; char v2; };
struct BFu0i_BFu16i_D { unsigned int :0; unsigned int v1:16; double v2; };
struct BFu0i_BFu16i_F { unsigned int :0; unsigned int v1:16; float v2; };
struct BFu0i_BFu16i_I { unsigned int :0; unsigned int v1:16; int v2; };
struct BFu0i_BFu16i_Ip { unsigned int :0; unsigned int v1:16; int * v2; };
struct BFu0i_BFu16i_L { unsigned int :0; unsigned int v1:16; long long v2; };
struct BFu0i_BFu16i_S { unsigned int :0; unsigned int v1:16; short v2; };
struct BFu0i_BFu16i_Uc { unsigned int :0; unsigned int v1:16; unsigned char v2; };
struct BFu0i_BFu16i_Ui { unsigned int :0; unsigned int v1:16; unsigned int v2; };
struct BFu0i_BFu16i_Ul { unsigned int :0; unsigned int v1:16; unsigned long long v2; };
struct BFu0i_BFu16i_Us { unsigned int :0; unsigned int v1:16; unsigned short v2; };
struct BFu0i_BFu16i_Vp { unsigned int :0; unsigned int v1:16; void * v2; };
struct BFu0i_BFu16ll { unsigned int :0; unsigned long long v1:16; };
struct BFu0i_BFu16ll_BFu0c { unsigned int :0; unsigned long long v1:16; unsigned char :0; };
struct BFu0i_BFu16ll_BFu0i { unsigned int :0; unsigned long long v1:16; unsigned int :0; };
struct BFu0i_BFu16ll_BFu0ll { unsigned int :0; unsigned long long v1:16; unsigned long long :0; };
struct BFu0i_BFu16ll_BFu0s { unsigned int :0; unsigned long long v1:16; unsigned short :0; };
struct BFu0i_BFu16ll_BFu15i { unsigned int :0; unsigned long long v1:16; unsigned int v2:15; };
struct BFu0i_BFu16ll_BFu15ll { unsigned int :0; unsigned long long v1:16; unsigned long long v2:15; };
struct BFu0i_BFu16ll_BFu15s { unsigned int :0; unsigned long long v1:16; unsigned short v2:15; };
struct BFu0i_BFu16ll_BFu16i { unsigned int :0; unsigned long long v1:16; unsigned int v2:16; };
struct BFu0i_BFu16ll_BFu16ll { unsigned int :0; unsigned long long v1:16; unsigned long long v2:16; };
struct BFu0i_BFu16ll_BFu16s { unsigned int :0; unsigned long long v1:16; unsigned short v2:16; };
struct BFu0i_BFu16ll_BFu17i { unsigned int :0; unsigned long long v1:16; unsigned int v2:17; };
struct BFu0i_BFu16ll_BFu17ll { unsigned int :0; unsigned long long v1:16; unsigned long long v2:17; };
struct BFu0i_BFu16ll_BFu1c { unsigned int :0; unsigned long long v1:16; unsigned char v2:1; };
struct BFu0i_BFu16ll_BFu1i { unsigned int :0; unsigned long long v1:16; unsigned int v2:1; };
struct BFu0i_BFu16ll_BFu1ll { unsigned int :0; unsigned long long v1:16; unsigned long long v2:1; };
struct BFu0i_BFu16ll_BFu1s { unsigned int :0; unsigned long long v1:16; unsigned short v2:1; };
struct BFu0i_BFu16ll_BFu31i { unsigned int :0; unsigned long long v1:16; unsigned int v2:31; };
struct BFu0i_BFu16ll_BFu31ll { unsigned int :0; unsigned long long v1:16; unsigned long long v2:31; };
struct BFu0i_BFu16ll_BFu32i { unsigned int :0; unsigned long long v1:16; unsigned int v2:32; };
struct BFu0i_BFu16ll_BFu32ll { unsigned int :0; unsigned long long v1:16; unsigned long long v2:32; };
struct BFu0i_BFu16ll_BFu33 { unsigned int :0; unsigned long long v1:16; unsigned long long v2:33; };
struct BFu0i_BFu16ll_BFu7c { unsigned int :0; unsigned long long v1:16; unsigned char v2:7; };
struct BFu0i_BFu16ll_BFu7i { unsigned int :0; unsigned long long v1:16; unsigned int v2:7; };
struct BFu0i_BFu16ll_BFu7ll { unsigned int :0; unsigned long long v1:16; unsigned long long v2:7; };
struct BFu0i_BFu16ll_BFu7s { unsigned int :0; unsigned long long v1:16; unsigned short v2:7; };
struct BFu0i_BFu16ll_BFu8c { unsigned int :0; unsigned long long v1:16; unsigned char v2:8; };
struct BFu0i_BFu16ll_BFu8i { unsigned int :0; unsigned long long v1:16; unsigned int v2:8; };
struct BFu0i_BFu16ll_BFu8ll { unsigned int :0; unsigned long long v1:16; unsigned long long v2:8; };
struct BFu0i_BFu16ll_BFu8s { unsigned int :0; unsigned long long v1:16; unsigned short v2:8; };
struct BFu0i_BFu16ll_BFu9i { unsigned int :0; unsigned long long v1:16; unsigned int v2:9; };
struct BFu0i_BFu16ll_BFu9ll { unsigned int :0; unsigned long long v1:16; unsigned long long v2:9; };
struct BFu0i_BFu16ll_BFu9s { unsigned int :0; unsigned long long v1:16; unsigned short v2:9; };
struct BFu0i_BFu16ll_C { unsigned int :0; unsigned long long v1:16; char v2; };
struct BFu0i_BFu16ll_D { unsigned int :0; unsigned long long v1:16; double v2; };
struct BFu0i_BFu16ll_F { unsigned int :0; unsigned long long v1:16; float v2; };
struct BFu0i_BFu16ll_I { unsigned int :0; unsigned long long v1:16; int v2; };
struct BFu0i_BFu16ll_Ip { unsigned int :0; unsigned long long v1:16; int * v2; };
struct BFu0i_BFu16ll_L { unsigned int :0; unsigned long long v1:16; long long v2; };
struct BFu0i_BFu16ll_S { unsigned int :0; unsigned long long v1:16; short v2; };
struct BFu0i_BFu16ll_Uc { unsigned int :0; unsigned long long v1:16; unsigned char v2; };
struct BFu0i_BFu16ll_Ui { unsigned int :0; unsigned long long v1:16; unsigned int v2; };
struct BFu0i_BFu16ll_Ul { unsigned int :0; unsigned long long v1:16; unsigned long long v2; };
struct BFu0i_BFu16ll_Us { unsigned int :0; unsigned long long v1:16; unsigned short v2; };
struct BFu0i_BFu16ll_Vp { unsigned int :0; unsigned long long v1:16; void * v2; };
struct BFu0i_BFu16s { unsigned int :0; unsigned short v1:16; };
struct BFu0i_BFu16s_BFu0c { unsigned int :0; unsigned short v1:16; unsigned char :0; };
struct BFu0i_BFu16s_BFu0i { unsigned int :0; unsigned short v1:16; unsigned int :0; };
struct BFu0i_BFu16s_BFu0ll { unsigned int :0; unsigned short v1:16; unsigned long long :0; };
struct BFu0i_BFu16s_BFu0s { unsigned int :0; unsigned short v1:16; unsigned short :0; };
struct BFu0i_BFu16s_BFu15i { unsigned int :0; unsigned short v1:16; unsigned int v2:15; };
struct BFu0i_BFu16s_BFu15ll { unsigned int :0; unsigned short v1:16; unsigned long long v2:15; };
struct BFu0i_BFu16s_BFu15s { unsigned int :0; unsigned short v1:16; unsigned short v2:15; };
struct BFu0i_BFu16s_BFu16i { unsigned int :0; unsigned short v1:16; unsigned int v2:16; };
struct BFu0i_BFu16s_BFu16ll { unsigned int :0; unsigned short v1:16; unsigned long long v2:16; };
struct BFu0i_BFu16s_BFu16s { unsigned int :0; unsigned short v1:16; unsigned short v2:16; };
struct BFu0i_BFu16s_BFu17i { unsigned int :0; unsigned short v1:16; unsigned int v2:17; };
struct BFu0i_BFu16s_BFu17ll { unsigned int :0; unsigned short v1:16; unsigned long long v2:17; };
struct BFu0i_BFu16s_BFu1c { unsigned int :0; unsigned short v1:16; unsigned char v2:1; };
struct BFu0i_BFu16s_BFu1i { unsigned int :0; unsigned short v1:16; unsigned int v2:1; };
struct BFu0i_BFu16s_BFu1ll { unsigned int :0; unsigned short v1:16; unsigned long long v2:1; };
struct BFu0i_BFu16s_BFu1s { unsigned int :0; unsigned short v1:16; unsigned short v2:1; };
struct BFu0i_BFu16s_BFu31i { unsigned int :0; unsigned short v1:16; unsigned int v2:31; };
struct BFu0i_BFu16s_BFu31ll { unsigned int :0; unsigned short v1:16; unsigned long long v2:31; };
struct BFu0i_BFu16s_BFu32i { unsigned int :0; unsigned short v1:16; unsigned int v2:32; };
struct BFu0i_BFu16s_BFu32ll { unsigned int :0; unsigned short v1:16; unsigned long long v2:32; };
struct BFu0i_BFu16s_BFu33 { unsigned int :0; unsigned short v1:16; unsigned long long v2:33; };
struct BFu0i_BFu16s_BFu7c { unsigned int :0; unsigned short v1:16; unsigned char v2:7; };
struct BFu0i_BFu16s_BFu7i { unsigned int :0; unsigned short v1:16; unsigned int v2:7; };
struct BFu0i_BFu16s_BFu7ll { unsigned int :0; unsigned short v1:16; unsigned long long v2:7; };
struct BFu0i_BFu16s_BFu7s { unsigned int :0; unsigned short v1:16; unsigned short v2:7; };
struct BFu0i_BFu16s_BFu8c { unsigned int :0; unsigned short v1:16; unsigned char v2:8; };
struct BFu0i_BFu16s_BFu8i { unsigned int :0; unsigned short v1:16; unsigned int v2:8; };
struct BFu0i_BFu16s_BFu8ll { unsigned int :0; unsigned short v1:16; unsigned long long v2:8; };
struct BFu0i_BFu16s_BFu8s { unsigned int :0; unsigned short v1:16; unsigned short v2:8; };
struct BFu0i_BFu16s_BFu9i { unsigned int :0; unsigned short v1:16; unsigned int v2:9; };
struct BFu0i_BFu16s_BFu9ll { unsigned int :0; unsigned short v1:16; unsigned long long v2:9; };
struct BFu0i_BFu16s_BFu9s { unsigned int :0; unsigned short v1:16; unsigned short v2:9; };
struct BFu0i_BFu16s_C { unsigned int :0; unsigned short v1:16; char v2; };
struct BFu0i_BFu16s_D { unsigned int :0; unsigned short v1:16; double v2; };
struct BFu0i_BFu16s_F { unsigned int :0; unsigned short v1:16; float v2; };
struct BFu0i_BFu16s_I { unsigned int :0; unsigned short v1:16; int v2; };
struct BFu0i_BFu16s_Ip { unsigned int :0; unsigned short v1:16; int * v2; };
struct BFu0i_BFu16s_L { unsigned int :0; unsigned short v1:16; long long v2; };
struct BFu0i_BFu16s_S { unsigned int :0; unsigned short v1:16; short v2; };
struct BFu0i_BFu16s_Uc { unsigned int :0; unsigned short v1:16; unsigned char v2; };
struct BFu0i_BFu16s_Ui { unsigned int :0; unsigned short v1:16; unsigned int v2; };
struct BFu0i_BFu16s_Ul { unsigned int :0; unsigned short v1:16; unsigned long long v2; };
struct BFu0i_BFu16s_Us { unsigned int :0; unsigned short v1:16; unsigned short v2; };
struct BFu0i_BFu16s_Vp { unsigned int :0; unsigned short v1:16; void * v2; };
struct BFu0i_BFu17i { unsigned int :0; unsigned int v1:17; };
struct BFu0i_BFu17i_BFu0c { unsigned int :0; unsigned int v1:17; unsigned char :0; };
struct BFu0i_BFu17i_BFu0i { unsigned int :0; unsigned int v1:17; unsigned int :0; };
struct BFu0i_BFu17i_BFu0ll { unsigned int :0; unsigned int v1:17; unsigned long long :0; };
struct BFu0i_BFu17i_BFu0s { unsigned int :0; unsigned int v1:17; unsigned short :0; };
struct BFu0i_BFu17i_BFu15i { unsigned int :0; unsigned int v1:17; unsigned int v2:15; };
struct BFu0i_BFu17i_BFu15ll { unsigned int :0; unsigned int v1:17; unsigned long long v2:15; };
struct BFu0i_BFu17i_BFu15s { unsigned int :0; unsigned int v1:17; unsigned short v2:15; };
struct BFu0i_BFu17i_BFu16i { unsigned int :0; unsigned int v1:17; unsigned int v2:16; };
struct BFu0i_BFu17i_BFu16ll { unsigned int :0; unsigned int v1:17; unsigned long long v2:16; };
struct BFu0i_BFu17i_BFu16s { unsigned int :0; unsigned int v1:17; unsigned short v2:16; };
struct BFu0i_BFu17i_BFu17i { unsigned int :0; unsigned int v1:17; unsigned int v2:17; };
struct BFu0i_BFu17i_BFu17ll { unsigned int :0; unsigned int v1:17; unsigned long long v2:17; };
struct BFu0i_BFu17i_BFu1c { unsigned int :0; unsigned int v1:17; unsigned char v2:1; };
struct BFu0i_BFu17i_BFu1i { unsigned int :0; unsigned int v1:17; unsigned int v2:1; };
struct BFu0i_BFu17i_BFu1ll { unsigned int :0; unsigned int v1:17; unsigned long long v2:1; };
struct BFu0i_BFu17i_BFu1s { unsigned int :0; unsigned int v1:17; unsigned short v2:1; };
struct BFu0i_BFu17i_BFu31i { unsigned int :0; unsigned int v1:17; unsigned int v2:31; };
struct BFu0i_BFu17i_BFu31ll { unsigned int :0; unsigned int v1:17; unsigned long long v2:31; };
struct BFu0i_BFu17i_BFu32i { unsigned int :0; unsigned int v1:17; unsigned int v2:32; };
struct BFu0i_BFu17i_BFu32ll { unsigned int :0; unsigned int v1:17; unsigned long long v2:32; };
struct BFu0i_BFu17i_BFu33 { unsigned int :0; unsigned int v1:17; unsigned long long v2:33; };
struct BFu0i_BFu17i_BFu7c { unsigned int :0; unsigned int v1:17; unsigned char v2:7; };
struct BFu0i_BFu17i_BFu7i { unsigned int :0; unsigned int v1:17; unsigned int v2:7; };
struct BFu0i_BFu17i_BFu7ll { unsigned int :0; unsigned int v1:17; unsigned long long v2:7; };
struct BFu0i_BFu17i_BFu7s { unsigned int :0; unsigned int v1:17; unsigned short v2:7; };
struct BFu0i_BFu17i_BFu8c { unsigned int :0; unsigned int v1:17; unsigned char v2:8; };
struct BFu0i_BFu17i_BFu8i { unsigned int :0; unsigned int v1:17; unsigned int v2:8; };
struct BFu0i_BFu17i_BFu8ll { unsigned int :0; unsigned int v1:17; unsigned long long v2:8; };
struct BFu0i_BFu17i_BFu8s { unsigned int :0; unsigned int v1:17; unsigned short v2:8; };
struct BFu0i_BFu17i_BFu9i { unsigned int :0; unsigned int v1:17; unsigned int v2:9; };
struct BFu0i_BFu17i_BFu9ll { unsigned int :0; unsigned int v1:17; unsigned long long v2:9; };
struct BFu0i_BFu17i_BFu9s { unsigned int :0; unsigned int v1:17; unsigned short v2:9; };
struct BFu0i_BFu17i_C { unsigned int :0; unsigned int v1:17; char v2; };
struct BFu0i_BFu17i_D { unsigned int :0; unsigned int v1:17; double v2; };
struct BFu0i_BFu17i_F { unsigned int :0; unsigned int v1:17; float v2; };
struct BFu0i_BFu17i_I { unsigned int :0; unsigned int v1:17; int v2; };
struct BFu0i_BFu17i_Ip { unsigned int :0; unsigned int v1:17; int * v2; };
struct BFu0i_BFu17i_L { unsigned int :0; unsigned int v1:17; long long v2; };
struct BFu0i_BFu17i_S { unsigned int :0; unsigned int v1:17; short v2; };
struct BFu0i_BFu17i_Uc { unsigned int :0; unsigned int v1:17; unsigned char v2; };
struct BFu0i_BFu17i_Ui { unsigned int :0; unsigned int v1:17; unsigned int v2; };
struct BFu0i_BFu17i_Ul { unsigned int :0; unsigned int v1:17; unsigned long long v2; };
struct BFu0i_BFu17i_Us { unsigned int :0; unsigned int v1:17; unsigned short v2; };
struct BFu0i_BFu17i_Vp { unsigned int :0; unsigned int v1:17; void * v2; };
struct BFu0i_BFu17ll { unsigned int :0; unsigned long long v1:17; };
struct BFu0i_BFu17ll_BFu0c { unsigned int :0; unsigned long long v1:17; unsigned char :0; };
struct BFu0i_BFu17ll_BFu0i { unsigned int :0; unsigned long long v1:17; unsigned int :0; };
struct BFu0i_BFu17ll_BFu0ll { unsigned int :0; unsigned long long v1:17; unsigned long long :0; };
struct BFu0i_BFu17ll_BFu0s { unsigned int :0; unsigned long long v1:17; unsigned short :0; };
struct BFu0i_BFu17ll_BFu15i { unsigned int :0; unsigned long long v1:17; unsigned int v2:15; };
struct BFu0i_BFu17ll_BFu15ll { unsigned int :0; unsigned long long v1:17; unsigned long long v2:15; };
struct BFu0i_BFu17ll_BFu15s { unsigned int :0; unsigned long long v1:17; unsigned short v2:15; };
struct BFu0i_BFu17ll_BFu16i { unsigned int :0; unsigned long long v1:17; unsigned int v2:16; };
struct BFu0i_BFu17ll_BFu16ll { unsigned int :0; unsigned long long v1:17; unsigned long long v2:16; };
struct BFu0i_BFu17ll_BFu16s { unsigned int :0; unsigned long long v1:17; unsigned short v2:16; };
struct BFu0i_BFu17ll_BFu17i { unsigned int :0; unsigned long long v1:17; unsigned int v2:17; };
struct BFu0i_BFu17ll_BFu17ll { unsigned int :0; unsigned long long v1:17; unsigned long long v2:17; };
struct BFu0i_BFu17ll_BFu1c { unsigned int :0; unsigned long long v1:17; unsigned char v2:1; };
struct BFu0i_BFu17ll_BFu1i { unsigned int :0; unsigned long long v1:17; unsigned int v2:1; };
struct BFu0i_BFu17ll_BFu1ll { unsigned int :0; unsigned long long v1:17; unsigned long long v2:1; };
struct BFu0i_BFu17ll_BFu1s { unsigned int :0; unsigned long long v1:17; unsigned short v2:1; };
struct BFu0i_BFu17ll_BFu31i { unsigned int :0; unsigned long long v1:17; unsigned int v2:31; };
struct BFu0i_BFu17ll_BFu31ll { unsigned int :0; unsigned long long v1:17; unsigned long long v2:31; };
struct BFu0i_BFu17ll_BFu32i { unsigned int :0; unsigned long long v1:17; unsigned int v2:32; };
struct BFu0i_BFu17ll_BFu32ll { unsigned int :0; unsigned long long v1:17; unsigned long long v2:32; };
struct BFu0i_BFu17ll_BFu33 { unsigned int :0; unsigned long long v1:17; unsigned long long v2:33; };
struct BFu0i_BFu17ll_BFu7c { unsigned int :0; unsigned long long v1:17; unsigned char v2:7; };
struct BFu0i_BFu17ll_BFu7i { unsigned int :0; unsigned long long v1:17; unsigned int v2:7; };
struct BFu0i_BFu17ll_BFu7ll { unsigned int :0; unsigned long long v1:17; unsigned long long v2:7; };
struct BFu0i_BFu17ll_BFu7s { unsigned int :0; unsigned long long v1:17; unsigned short v2:7; };
struct BFu0i_BFu17ll_BFu8c { unsigned int :0; unsigned long long v1:17; unsigned char v2:8; };
struct BFu0i_BFu17ll_BFu8i { unsigned int :0; unsigned long long v1:17; unsigned int v2:8; };
struct BFu0i_BFu17ll_BFu8ll { unsigned int :0; unsigned long long v1:17; unsigned long long v2:8; };
struct BFu0i_BFu17ll_BFu8s { unsigned int :0; unsigned long long v1:17; unsigned short v2:8; };
struct BFu0i_BFu17ll_BFu9i { unsigned int :0; unsigned long long v1:17; unsigned int v2:9; };
struct BFu0i_BFu17ll_BFu9ll { unsigned int :0; unsigned long long v1:17; unsigned long long v2:9; };
struct BFu0i_BFu17ll_BFu9s { unsigned int :0; unsigned long long v1:17; unsigned short v2:9; };
struct BFu0i_BFu17ll_C { unsigned int :0; unsigned long long v1:17; char v2; };
struct BFu0i_BFu17ll_D { unsigned int :0; unsigned long long v1:17; double v2; };
struct BFu0i_BFu17ll_F { unsigned int :0; unsigned long long v1:17; float v2; };
struct BFu0i_BFu17ll_I { unsigned int :0; unsigned long long v1:17; int v2; };
struct BFu0i_BFu17ll_Ip { unsigned int :0; unsigned long long v1:17; int * v2; };
struct BFu0i_BFu17ll_L { unsigned int :0; unsigned long long v1:17; long long v2; };
struct BFu0i_BFu17ll_S { unsigned int :0; unsigned long long v1:17; short v2; };
struct BFu0i_BFu17ll_Uc { unsigned int :0; unsigned long long v1:17; unsigned char v2; };
struct BFu0i_BFu17ll_Ui { unsigned int :0; unsigned long long v1:17; unsigned int v2; };
struct BFu0i_BFu17ll_Ul { unsigned int :0; unsigned long long v1:17; unsigned long long v2; };
struct BFu0i_BFu17ll_Us { unsigned int :0; unsigned long long v1:17; unsigned short v2; };
struct BFu0i_BFu17ll_Vp { unsigned int :0; unsigned long long v1:17; void * v2; };
struct BFu0i_BFu1c { unsigned int :0; unsigned char v1:1; };
struct BFu0i_BFu1c_BFu0c { unsigned int :0; unsigned char v1:1; unsigned char :0; };
struct BFu0i_BFu1c_BFu0i { unsigned int :0; unsigned char v1:1; unsigned int :0; };
struct BFu0i_BFu1c_BFu0ll { unsigned int :0; unsigned char v1:1; unsigned long long :0; };
struct BFu0i_BFu1c_BFu0s { unsigned int :0; unsigned char v1:1; unsigned short :0; };
struct BFu0i_BFu1c_BFu15i { unsigned int :0; unsigned char v1:1; unsigned int v2:15; };
struct BFu0i_BFu1c_BFu15ll { unsigned int :0; unsigned char v1:1; unsigned long long v2:15; };
struct BFu0i_BFu1c_BFu15s { unsigned int :0; unsigned char v1:1; unsigned short v2:15; };
struct BFu0i_BFu1c_BFu16i { unsigned int :0; unsigned char v1:1; unsigned int v2:16; };
struct BFu0i_BFu1c_BFu16ll { unsigned int :0; unsigned char v1:1; unsigned long long v2:16; };
struct BFu0i_BFu1c_BFu16s { unsigned int :0; unsigned char v1:1; unsigned short v2:16; };
struct BFu0i_BFu1c_BFu17i { unsigned int :0; unsigned char v1:1; unsigned int v2:17; };
struct BFu0i_BFu1c_BFu17ll { unsigned int :0; unsigned char v1:1; unsigned long long v2:17; };
struct BFu0i_BFu1c_BFu1c { unsigned int :0; unsigned char v1:1; unsigned char v2:1; };
struct BFu0i_BFu1c_BFu1i { unsigned int :0; unsigned char v1:1; unsigned int v2:1; };
struct BFu0i_BFu1c_BFu1ll { unsigned int :0; unsigned char v1:1; unsigned long long v2:1; };
struct BFu0i_BFu1c_BFu1s { unsigned int :0; unsigned char v1:1; unsigned short v2:1; };
struct BFu0i_BFu1c_BFu31i { unsigned int :0; unsigned char v1:1; unsigned int v2:31; };
struct BFu0i_BFu1c_BFu31ll { unsigned int :0; unsigned char v1:1; unsigned long long v2:31; };
struct BFu0i_BFu1c_BFu32i { unsigned int :0; unsigned char v1:1; unsigned int v2:32; };
struct BFu0i_BFu1c_BFu32ll { unsigned int :0; unsigned char v1:1; unsigned long long v2:32; };
struct BFu0i_BFu1c_BFu33 { unsigned int :0; unsigned char v1:1; unsigned long long v2:33; };
struct BFu0i_BFu1c_BFu7c { unsigned int :0; unsigned char v1:1; unsigned char v2:7; };
struct BFu0i_BFu1c_BFu7i { unsigned int :0; unsigned char v1:1; unsigned int v2:7; };
struct BFu0i_BFu1c_BFu7ll { unsigned int :0; unsigned char v1:1; unsigned long long v2:7; };
struct BFu0i_BFu1c_BFu7s { unsigned int :0; unsigned char v1:1; unsigned short v2:7; };
struct BFu0i_BFu1c_BFu8c { unsigned int :0; unsigned char v1:1; unsigned char v2:8; };
struct BFu0i_BFu1c_BFu8i { unsigned int :0; unsigned char v1:1; unsigned int v2:8; };
struct BFu0i_BFu1c_BFu8ll { unsigned int :0; unsigned char v1:1; unsigned long long v2:8; };
struct BFu0i_BFu1c_BFu8s { unsigned int :0; unsigned char v1:1; unsigned short v2:8; };
struct BFu0i_BFu1c_BFu9i { unsigned int :0; unsigned char v1:1; unsigned int v2:9; };
struct BFu0i_BFu1c_BFu9ll { unsigned int :0; unsigned char v1:1; unsigned long long v2:9; };
struct BFu0i_BFu1c_BFu9s { unsigned int :0; unsigned char v1:1; unsigned short v2:9; };
struct BFu0i_BFu1c_C { unsigned int :0; unsigned char v1:1; char v2; };
struct BFu0i_BFu1c_D { unsigned int :0; unsigned char v1:1; double v2; };
struct BFu0i_BFu1c_F { unsigned int :0; unsigned char v1:1; float v2; };
struct BFu0i_BFu1c_I { unsigned int :0; unsigned char v1:1; int v2; };
struct BFu0i_BFu1c_Ip { unsigned int :0; unsigned char v1:1; int * v2; };
struct BFu0i_BFu1c_L { unsigned int :0; unsigned char v1:1; long long v2; };
struct BFu0i_BFu1c_S { unsigned int :0; unsigned char v1:1; short v2; };
struct BFu0i_BFu1c_Uc { unsigned int :0; unsigned char v1:1; unsigned char v2; };
struct BFu0i_BFu1c_Ui { unsigned int :0; unsigned char v1:1; unsigned int v2; };
struct BFu0i_BFu1c_Ul { unsigned int :0; unsigned char v1:1; unsigned long long v2; };
struct BFu0i_BFu1c_Us { unsigned int :0; unsigned char v1:1; unsigned short v2; };
struct BFu0i_BFu1c_Vp { unsigned int :0; unsigned char v1:1; void * v2; };
struct BFu0i_BFu1i { unsigned int :0; unsigned int v1:1; };
struct BFu0i_BFu1i_BFu0c { unsigned int :0; unsigned int v1:1; unsigned char :0; };
struct BFu0i_BFu1i_BFu0i { unsigned int :0; unsigned int v1:1; unsigned int :0; };
struct BFu0i_BFu1i_BFu0ll { unsigned int :0; unsigned int v1:1; unsigned long long :0; };
struct BFu0i_BFu1i_BFu0s { unsigned int :0; unsigned int v1:1; unsigned short :0; };
struct BFu0i_BFu1i_BFu15i { unsigned int :0; unsigned int v1:1; unsigned int v2:15; };
struct BFu0i_BFu1i_BFu15ll { unsigned int :0; unsigned int v1:1; unsigned long long v2:15; };
struct BFu0i_BFu1i_BFu15s { unsigned int :0; unsigned int v1:1; unsigned short v2:15; };
struct BFu0i_BFu1i_BFu16i { unsigned int :0; unsigned int v1:1; unsigned int v2:16; };
struct BFu0i_BFu1i_BFu16ll { unsigned int :0; unsigned int v1:1; unsigned long long v2:16; };
struct BFu0i_BFu1i_BFu16s { unsigned int :0; unsigned int v1:1; unsigned short v2:16; };
struct BFu0i_BFu1i_BFu17i { unsigned int :0; unsigned int v1:1; unsigned int v2:17; };
struct BFu0i_BFu1i_BFu17ll { unsigned int :0; unsigned int v1:1; unsigned long long v2:17; };
struct BFu0i_BFu1i_BFu1c { unsigned int :0; unsigned int v1:1; unsigned char v2:1; };
struct BFu0i_BFu1i_BFu1i { unsigned int :0; unsigned int v1:1; unsigned int v2:1; };
struct BFu0i_BFu1i_BFu1ll { unsigned int :0; unsigned int v1:1; unsigned long long v2:1; };
struct BFu0i_BFu1i_BFu1s { unsigned int :0; unsigned int v1:1; unsigned short v2:1; };
struct BFu0i_BFu1i_BFu31i { unsigned int :0; unsigned int v1:1; unsigned int v2:31; };
struct BFu0i_BFu1i_BFu31ll { unsigned int :0; unsigned int v1:1; unsigned long long v2:31; };
struct BFu0i_BFu1i_BFu32i { unsigned int :0; unsigned int v1:1; unsigned int v2:32; };
struct BFu0i_BFu1i_BFu32ll { unsigned int :0; unsigned int v1:1; unsigned long long v2:32; };
struct BFu0i_BFu1i_BFu33 { unsigned int :0; unsigned int v1:1; unsigned long long v2:33; };
struct BFu0i_BFu1i_BFu7c { unsigned int :0; unsigned int v1:1; unsigned char v2:7; };
struct BFu0i_BFu1i_BFu7i { unsigned int :0; unsigned int v1:1; unsigned int v2:7; };
struct BFu0i_BFu1i_BFu7ll { unsigned int :0; unsigned int v1:1; unsigned long long v2:7; };
struct BFu0i_BFu1i_BFu7s { unsigned int :0; unsigned int v1:1; unsigned short v2:7; };
struct BFu0i_BFu1i_BFu8c { unsigned int :0; unsigned int v1:1; unsigned char v2:8; };
struct BFu0i_BFu1i_BFu8i { unsigned int :0; unsigned int v1:1; unsigned int v2:8; };
struct BFu0i_BFu1i_BFu8ll { unsigned int :0; unsigned int v1:1; unsigned long long v2:8; };
struct BFu0i_BFu1i_BFu8s { unsigned int :0; unsigned int v1:1; unsigned short v2:8; };
struct BFu0i_BFu1i_BFu9i { unsigned int :0; unsigned int v1:1; unsigned int v2:9; };
struct BFu0i_BFu1i_BFu9ll { unsigned int :0; unsigned int v1:1; unsigned long long v2:9; };
struct BFu0i_BFu1i_BFu9s { unsigned int :0; unsigned int v1:1; unsigned short v2:9; };
struct BFu0i_BFu1i_C { unsigned int :0; unsigned int v1:1; char v2; };
struct BFu0i_BFu1i_D { unsigned int :0; unsigned int v1:1; double v2; };
struct BFu0i_BFu1i_F { unsigned int :0; unsigned int v1:1; float v2; };
struct BFu0i_BFu1i_I { unsigned int :0; unsigned int v1:1; int v2; };
struct BFu0i_BFu1i_Ip { unsigned int :0; unsigned int v1:1; int * v2; };
struct BFu0i_BFu1i_L { unsigned int :0; unsigned int v1:1; long long v2; };
struct BFu0i_BFu1i_S { unsigned int :0; unsigned int v1:1; short v2; };
struct BFu0i_BFu1i_Uc { unsigned int :0; unsigned int v1:1; unsigned char v2; };
struct BFu0i_BFu1i_Ui { unsigned int :0; unsigned int v1:1; unsigned int v2; };
struct BFu0i_BFu1i_Ul { unsigned int :0; unsigned int v1:1; unsigned long long v2; };
struct BFu0i_BFu1i_Us { unsigned int :0; unsigned int v1:1; unsigned short v2; };
struct BFu0i_BFu1i_Vp { unsigned int :0; unsigned int v1:1; void * v2; };
struct BFu0i_BFu1ll { unsigned int :0; unsigned long long v1:1; };
struct BFu0i_BFu1ll_BFu0c { unsigned int :0; unsigned long long v1:1; unsigned char :0; };
struct BFu0i_BFu1ll_BFu0i { unsigned int :0; unsigned long long v1:1; unsigned int :0; };
struct BFu0i_BFu1ll_BFu0ll { unsigned int :0; unsigned long long v1:1; unsigned long long :0; };
struct BFu0i_BFu1ll_BFu0s { unsigned int :0; unsigned long long v1:1; unsigned short :0; };
struct BFu0i_BFu1ll_BFu15i { unsigned int :0; unsigned long long v1:1; unsigned int v2:15; };
struct BFu0i_BFu1ll_BFu15ll { unsigned int :0; unsigned long long v1:1; unsigned long long v2:15; };
struct BFu0i_BFu1ll_BFu15s { unsigned int :0; unsigned long long v1:1; unsigned short v2:15; };
struct BFu0i_BFu1ll_BFu16i { unsigned int :0; unsigned long long v1:1; unsigned int v2:16; };
struct BFu0i_BFu1ll_BFu16ll { unsigned int :0; unsigned long long v1:1; unsigned long long v2:16; };
struct BFu0i_BFu1ll_BFu16s { unsigned int :0; unsigned long long v1:1; unsigned short v2:16; };
struct BFu0i_BFu1ll_BFu17i { unsigned int :0; unsigned long long v1:1; unsigned int v2:17; };
struct BFu0i_BFu1ll_BFu17ll { unsigned int :0; unsigned long long v1:1; unsigned long long v2:17; };
struct BFu0i_BFu1ll_BFu1c { unsigned int :0; unsigned long long v1:1; unsigned char v2:1; };
struct BFu0i_BFu1ll_BFu1i { unsigned int :0; unsigned long long v1:1; unsigned int v2:1; };
struct BFu0i_BFu1ll_BFu1ll { unsigned int :0; unsigned long long v1:1; unsigned long long v2:1; };
struct BFu0i_BFu1ll_BFu1s { unsigned int :0; unsigned long long v1:1; unsigned short v2:1; };
struct BFu0i_BFu1ll_BFu31i { unsigned int :0; unsigned long long v1:1; unsigned int v2:31; };
struct BFu0i_BFu1ll_BFu31ll { unsigned int :0; unsigned long long v1:1; unsigned long long v2:31; };
struct BFu0i_BFu1ll_BFu32i { unsigned int :0; unsigned long long v1:1; unsigned int v2:32; };
struct BFu0i_BFu1ll_BFu32ll { unsigned int :0; unsigned long long v1:1; unsigned long long v2:32; };
struct BFu0i_BFu1ll_BFu33 { unsigned int :0; unsigned long long v1:1; unsigned long long v2:33; };
struct BFu0i_BFu1ll_BFu7c { unsigned int :0; unsigned long long v1:1; unsigned char v2:7; };
struct BFu0i_BFu1ll_BFu7i { unsigned int :0; unsigned long long v1:1; unsigned int v2:7; };
struct BFu0i_BFu1ll_BFu7ll { unsigned int :0; unsigned long long v1:1; unsigned long long v2:7; };
struct BFu0i_BFu1ll_BFu7s { unsigned int :0; unsigned long long v1:1; unsigned short v2:7; };
struct BFu0i_BFu1ll_BFu8c { unsigned int :0; unsigned long long v1:1; unsigned char v2:8; };
struct BFu0i_BFu1ll_BFu8i { unsigned int :0; unsigned long long v1:1; unsigned int v2:8; };
struct BFu0i_BFu1ll_BFu8ll { unsigned int :0; unsigned long long v1:1; unsigned long long v2:8; };
struct BFu0i_BFu1ll_BFu8s { unsigned int :0; unsigned long long v1:1; unsigned short v2:8; };
struct BFu0i_BFu1ll_BFu9i { unsigned int :0; unsigned long long v1:1; unsigned int v2:9; };
struct BFu0i_BFu1ll_BFu9ll { unsigned int :0; unsigned long long v1:1; unsigned long long v2:9; };
struct BFu0i_BFu1ll_BFu9s { unsigned int :0; unsigned long long v1:1; unsigned short v2:9; };
struct BFu0i_BFu1ll_C { unsigned int :0; unsigned long long v1:1; char v2; };
struct BFu0i_BFu1ll_D { unsigned int :0; unsigned long long v1:1; double v2; };
struct BFu0i_BFu1ll_F { unsigned int :0; unsigned long long v1:1; float v2; };
struct BFu0i_BFu1ll_I { unsigned int :0; unsigned long long v1:1; int v2; };
struct BFu0i_BFu1ll_Ip { unsigned int :0; unsigned long long v1:1; int * v2; };
struct BFu0i_BFu1ll_L { unsigned int :0; unsigned long long v1:1; long long v2; };
struct BFu0i_BFu1ll_S { unsigned int :0; unsigned long long v1:1; short v2; };
struct BFu0i_BFu1ll_Uc { unsigned int :0; unsigned long long v1:1; unsigned char v2; };
struct BFu0i_BFu1ll_Ui { unsigned int :0; unsigned long long v1:1; unsigned int v2; };
struct BFu0i_BFu1ll_Ul { unsigned int :0; unsigned long long v1:1; unsigned long long v2; };
struct BFu0i_BFu1ll_Us { unsigned int :0; unsigned long long v1:1; unsigned short v2; };
struct BFu0i_BFu1ll_Vp { unsigned int :0; unsigned long long v1:1; void * v2; };
struct BFu0i_BFu1s { unsigned int :0; unsigned short v1:1; };
struct BFu0i_BFu1s_BFu0c { unsigned int :0; unsigned short v1:1; unsigned char :0; };
struct BFu0i_BFu1s_BFu0i { unsigned int :0; unsigned short v1:1; unsigned int :0; };
struct BFu0i_BFu1s_BFu0ll { unsigned int :0; unsigned short v1:1; unsigned long long :0; };
struct BFu0i_BFu1s_BFu0s { unsigned int :0; unsigned short v1:1; unsigned short :0; };
struct BFu0i_BFu1s_BFu15i { unsigned int :0; unsigned short v1:1; unsigned int v2:15; };
struct BFu0i_BFu1s_BFu15ll { unsigned int :0; unsigned short v1:1; unsigned long long v2:15; };
struct BFu0i_BFu1s_BFu15s { unsigned int :0; unsigned short v1:1; unsigned short v2:15; };
struct BFu0i_BFu1s_BFu16i { unsigned int :0; unsigned short v1:1; unsigned int v2:16; };
struct BFu0i_BFu1s_BFu16ll { unsigned int :0; unsigned short v1:1; unsigned long long v2:16; };
struct BFu0i_BFu1s_BFu16s { unsigned int :0; unsigned short v1:1; unsigned short v2:16; };
struct BFu0i_BFu1s_BFu17i { unsigned int :0; unsigned short v1:1; unsigned int v2:17; };
struct BFu0i_BFu1s_BFu17ll { unsigned int :0; unsigned short v1:1; unsigned long long v2:17; };
struct BFu0i_BFu1s_BFu1c { unsigned int :0; unsigned short v1:1; unsigned char v2:1; };
struct BFu0i_BFu1s_BFu1i { unsigned int :0; unsigned short v1:1; unsigned int v2:1; };
struct BFu0i_BFu1s_BFu1ll { unsigned int :0; unsigned short v1:1; unsigned long long v2:1; };
struct BFu0i_BFu1s_BFu1s { unsigned int :0; unsigned short v1:1; unsigned short v2:1; };
struct BFu0i_BFu1s_BFu31i { unsigned int :0; unsigned short v1:1; unsigned int v2:31; };
struct BFu0i_BFu1s_BFu31ll { unsigned int :0; unsigned short v1:1; unsigned long long v2:31; };
struct BFu0i_BFu1s_BFu32i { unsigned int :0; unsigned short v1:1; unsigned int v2:32; };
struct BFu0i_BFu1s_BFu32ll { unsigned int :0; unsigned short v1:1; unsigned long long v2:32; };
struct BFu0i_BFu1s_BFu33 { unsigned int :0; unsigned short v1:1; unsigned long long v2:33; };
struct BFu0i_BFu1s_BFu7c { unsigned int :0; unsigned short v1:1; unsigned char v2:7; };
struct BFu0i_BFu1s_BFu7i { unsigned int :0; unsigned short v1:1; unsigned int v2:7; };
struct BFu0i_BFu1s_BFu7ll { unsigned int :0; unsigned short v1:1; unsigned long long v2:7; };
struct BFu0i_BFu1s_BFu7s { unsigned int :0; unsigned short v1:1; unsigned short v2:7; };
struct BFu0i_BFu1s_BFu8c { unsigned int :0; unsigned short v1:1; unsigned char v2:8; };
struct BFu0i_BFu1s_BFu8i { unsigned int :0; unsigned short v1:1; unsigned int v2:8; };
struct BFu0i_BFu1s_BFu8ll { unsigned int :0; unsigned short v1:1; unsigned long long v2:8; };
struct BFu0i_BFu1s_BFu8s { unsigned int :0; unsigned short v1:1; unsigned short v2:8; };
struct BFu0i_BFu1s_BFu9i { unsigned int :0; unsigned short v1:1; unsigned int v2:9; };
struct BFu0i_BFu1s_BFu9ll { unsigned int :0; unsigned short v1:1; unsigned long long v2:9; };
struct BFu0i_BFu1s_BFu9s { unsigned int :0; unsigned short v1:1; unsigned short v2:9; };
struct BFu0i_BFu1s_C { unsigned int :0; unsigned short v1:1; char v2; };
struct BFu0i_BFu1s_D { unsigned int :0; unsigned short v1:1; double v2; };
struct BFu0i_BFu1s_F { unsigned int :0; unsigned short v1:1; float v2; };
struct BFu0i_BFu1s_I { unsigned int :0; unsigned short v1:1; int v2; };
struct BFu0i_BFu1s_Ip { unsigned int :0; unsigned short v1:1; int * v2; };
struct BFu0i_BFu1s_L { unsigned int :0; unsigned short v1:1; long long v2; };
struct BFu0i_BFu1s_S { unsigned int :0; unsigned short v1:1; short v2; };
struct BFu0i_BFu1s_Uc { unsigned int :0; unsigned short v1:1; unsigned char v2; };
struct BFu0i_BFu1s_Ui { unsigned int :0; unsigned short v1:1; unsigned int v2; };
struct BFu0i_BFu1s_Ul { unsigned int :0; unsigned short v1:1; unsigned long long v2; };
struct BFu0i_BFu1s_Us { unsigned int :0; unsigned short v1:1; unsigned short v2; };
struct BFu0i_BFu1s_Vp { unsigned int :0; unsigned short v1:1; void * v2; };
struct BFu0i_BFu31i { unsigned int :0; unsigned int v1:31; };
struct BFu0i_BFu31i_BFu0c { unsigned int :0; unsigned int v1:31; unsigned char :0; };
struct BFu0i_BFu31i_BFu0i { unsigned int :0; unsigned int v1:31; unsigned int :0; };
struct BFu0i_BFu31i_BFu0ll { unsigned int :0; unsigned int v1:31; unsigned long long :0; };
struct BFu0i_BFu31i_BFu0s { unsigned int :0; unsigned int v1:31; unsigned short :0; };
struct BFu0i_BFu31i_BFu15i { unsigned int :0; unsigned int v1:31; unsigned int v2:15; };
struct BFu0i_BFu31i_BFu15ll { unsigned int :0; unsigned int v1:31; unsigned long long v2:15; };
struct BFu0i_BFu31i_BFu15s { unsigned int :0; unsigned int v1:31; unsigned short v2:15; };
struct BFu0i_BFu31i_BFu16i { unsigned int :0; unsigned int v1:31; unsigned int v2:16; };
struct BFu0i_BFu31i_BFu16ll { unsigned int :0; unsigned int v1:31; unsigned long long v2:16; };
struct BFu0i_BFu31i_BFu16s { unsigned int :0; unsigned int v1:31; unsigned short v2:16; };
struct BFu0i_BFu31i_BFu17i { unsigned int :0; unsigned int v1:31; unsigned int v2:17; };
struct BFu0i_BFu31i_BFu17ll { unsigned int :0; unsigned int v1:31; unsigned long long v2:17; };
struct BFu0i_BFu31i_BFu1c { unsigned int :0; unsigned int v1:31; unsigned char v2:1; };
struct BFu0i_BFu31i_BFu1i { unsigned int :0; unsigned int v1:31; unsigned int v2:1; };
struct BFu0i_BFu31i_BFu1ll { unsigned int :0; unsigned int v1:31; unsigned long long v2:1; };
struct BFu0i_BFu31i_BFu1s { unsigned int :0; unsigned int v1:31; unsigned short v2:1; };
struct BFu0i_BFu31i_BFu31i { unsigned int :0; unsigned int v1:31; unsigned int v2:31; };
struct BFu0i_BFu31i_BFu31ll { unsigned int :0; unsigned int v1:31; unsigned long long v2:31; };
struct BFu0i_BFu31i_BFu32i { unsigned int :0; unsigned int v1:31; unsigned int v2:32; };
struct BFu0i_BFu31i_BFu32ll { unsigned int :0; unsigned int v1:31; unsigned long long v2:32; };
struct BFu0i_BFu31i_BFu33 { unsigned int :0; unsigned int v1:31; unsigned long long v2:33; };
struct BFu0i_BFu31i_BFu7c { unsigned int :0; unsigned int v1:31; unsigned char v2:7; };
struct BFu0i_BFu31i_BFu7i { unsigned int :0; unsigned int v1:31; unsigned int v2:7; };
struct BFu0i_BFu31i_BFu7ll { unsigned int :0; unsigned int v1:31; unsigned long long v2:7; };
struct BFu0i_BFu31i_BFu7s { unsigned int :0; unsigned int v1:31; unsigned short v2:7; };
struct BFu0i_BFu31i_BFu8c { unsigned int :0; unsigned int v1:31; unsigned char v2:8; };
struct BFu0i_BFu31i_BFu8i { unsigned int :0; unsigned int v1:31; unsigned int v2:8; };
struct BFu0i_BFu31i_BFu8ll { unsigned int :0; unsigned int v1:31; unsigned long long v2:8; };
struct BFu0i_BFu31i_BFu8s { unsigned int :0; unsigned int v1:31; unsigned short v2:8; };
struct BFu0i_BFu31i_BFu9i { unsigned int :0; unsigned int v1:31; unsigned int v2:9; };
struct BFu0i_BFu31i_BFu9ll { unsigned int :0; unsigned int v1:31; unsigned long long v2:9; };
struct BFu0i_BFu31i_BFu9s { unsigned int :0; unsigned int v1:31; unsigned short v2:9; };
struct BFu0i_BFu31i_C { unsigned int :0; unsigned int v1:31; char v2; };
struct BFu0i_BFu31i_D { unsigned int :0; unsigned int v1:31; double v2; };
struct BFu0i_BFu31i_F { unsigned int :0; unsigned int v1:31; float v2; };
struct BFu0i_BFu31i_I { unsigned int :0; unsigned int v1:31; int v2; };
struct BFu0i_BFu31i_Ip { unsigned int :0; unsigned int v1:31; int * v2; };
struct BFu0i_BFu31i_L { unsigned int :0; unsigned int v1:31; long long v2; };
struct BFu0i_BFu31i_S { unsigned int :0; unsigned int v1:31; short v2; };
struct BFu0i_BFu31i_Uc { unsigned int :0; unsigned int v1:31; unsigned char v2; };
struct BFu0i_BFu31i_Ui { unsigned int :0; unsigned int v1:31; unsigned int v2; };
struct BFu0i_BFu31i_Ul { unsigned int :0; unsigned int v1:31; unsigned long long v2; };
struct BFu0i_BFu31i_Us { unsigned int :0; unsigned int v1:31; unsigned short v2; };
struct BFu0i_BFu31i_Vp { unsigned int :0; unsigned int v1:31; void * v2; };
struct BFu0i_BFu31ll { unsigned int :0; unsigned long long v1:31; };
struct BFu0i_BFu31ll_BFu0c { unsigned int :0; unsigned long long v1:31; unsigned char :0; };
struct BFu0i_BFu31ll_BFu0i { unsigned int :0; unsigned long long v1:31; unsigned int :0; };
struct BFu0i_BFu31ll_BFu0ll { unsigned int :0; unsigned long long v1:31; unsigned long long :0; };
struct BFu0i_BFu31ll_BFu0s { unsigned int :0; unsigned long long v1:31; unsigned short :0; };
struct BFu0i_BFu31ll_BFu15i { unsigned int :0; unsigned long long v1:31; unsigned int v2:15; };
struct BFu0i_BFu31ll_BFu15ll { unsigned int :0; unsigned long long v1:31; unsigned long long v2:15; };
struct BFu0i_BFu31ll_BFu15s { unsigned int :0; unsigned long long v1:31; unsigned short v2:15; };
struct BFu0i_BFu31ll_BFu16i { unsigned int :0; unsigned long long v1:31; unsigned int v2:16; };
struct BFu0i_BFu31ll_BFu16ll { unsigned int :0; unsigned long long v1:31; unsigned long long v2:16; };
struct BFu0i_BFu31ll_BFu16s { unsigned int :0; unsigned long long v1:31; unsigned short v2:16; };
struct BFu0i_BFu31ll_BFu17i { unsigned int :0; unsigned long long v1:31; unsigned int v2:17; };
struct BFu0i_BFu31ll_BFu17ll { unsigned int :0; unsigned long long v1:31; unsigned long long v2:17; };
struct BFu0i_BFu31ll_BFu1c { unsigned int :0; unsigned long long v1:31; unsigned char v2:1; };
struct BFu0i_BFu31ll_BFu1i { unsigned int :0; unsigned long long v1:31; unsigned int v2:1; };
struct BFu0i_BFu31ll_BFu1ll { unsigned int :0; unsigned long long v1:31; unsigned long long v2:1; };
struct BFu0i_BFu31ll_BFu1s { unsigned int :0; unsigned long long v1:31; unsigned short v2:1; };
struct BFu0i_BFu31ll_BFu31i { unsigned int :0; unsigned long long v1:31; unsigned int v2:31; };
struct BFu0i_BFu31ll_BFu31ll { unsigned int :0; unsigned long long v1:31; unsigned long long v2:31; };
struct BFu0i_BFu31ll_BFu32i { unsigned int :0; unsigned long long v1:31; unsigned int v2:32; };
struct BFu0i_BFu31ll_BFu32ll { unsigned int :0; unsigned long long v1:31; unsigned long long v2:32; };
struct BFu0i_BFu31ll_BFu33 { unsigned int :0; unsigned long long v1:31; unsigned long long v2:33; };
struct BFu0i_BFu31ll_BFu7c { unsigned int :0; unsigned long long v1:31; unsigned char v2:7; };
struct BFu0i_BFu31ll_BFu7i { unsigned int :0; unsigned long long v1:31; unsigned int v2:7; };
struct BFu0i_BFu31ll_BFu7ll { unsigned int :0; unsigned long long v1:31; unsigned long long v2:7; };
struct BFu0i_BFu31ll_BFu7s { unsigned int :0; unsigned long long v1:31; unsigned short v2:7; };
struct BFu0i_BFu31ll_BFu8c { unsigned int :0; unsigned long long v1:31; unsigned char v2:8; };
struct BFu0i_BFu31ll_BFu8i { unsigned int :0; unsigned long long v1:31; unsigned int v2:8; };
struct BFu0i_BFu31ll_BFu8ll { unsigned int :0; unsigned long long v1:31; unsigned long long v2:8; };
struct BFu0i_BFu31ll_BFu8s { unsigned int :0; unsigned long long v1:31; unsigned short v2:8; };
struct BFu0i_BFu31ll_BFu9i { unsigned int :0; unsigned long long v1:31; unsigned int v2:9; };
struct BFu0i_BFu31ll_BFu9ll { unsigned int :0; unsigned long long v1:31; unsigned long long v2:9; };
struct BFu0i_BFu31ll_BFu9s { unsigned int :0; unsigned long long v1:31; unsigned short v2:9; };
struct BFu0i_BFu31ll_C { unsigned int :0; unsigned long long v1:31; char v2; };
struct BFu0i_BFu31ll_D { unsigned int :0; unsigned long long v1:31; double v2; };
struct BFu0i_BFu31ll_F { unsigned int :0; unsigned long long v1:31; float v2; };
struct BFu0i_BFu31ll_I { unsigned int :0; unsigned long long v1:31; int v2; };
struct BFu0i_BFu31ll_Ip { unsigned int :0; unsigned long long v1:31; int * v2; };
struct BFu0i_BFu31ll_L { unsigned int :0; unsigned long long v1:31; long long v2; };
struct BFu0i_BFu31ll_S { unsigned int :0; unsigned long long v1:31; short v2; };
struct BFu0i_BFu31ll_Uc { unsigned int :0; unsigned long long v1:31; unsigned char v2; };
struct BFu0i_BFu31ll_Ui { unsigned int :0; unsigned long long v1:31; unsigned int v2; };
struct BFu0i_BFu31ll_Ul { unsigned int :0; unsigned long long v1:31; unsigned long long v2; };
struct BFu0i_BFu31ll_Us { unsigned int :0; unsigned long long v1:31; unsigned short v2; };
struct BFu0i_BFu31ll_Vp { unsigned int :0; unsigned long long v1:31; void * v2; };
struct BFu0i_BFu32i { unsigned int :0; unsigned int v1:32; };
struct BFu0i_BFu32i_BFu0c { unsigned int :0; unsigned int v1:32; unsigned char :0; };
struct BFu0i_BFu32i_BFu0i { unsigned int :0; unsigned int v1:32; unsigned int :0; };
struct BFu0i_BFu32i_BFu0ll { unsigned int :0; unsigned int v1:32; unsigned long long :0; };
struct BFu0i_BFu32i_BFu0s { unsigned int :0; unsigned int v1:32; unsigned short :0; };
struct BFu0i_BFu32i_BFu15i { unsigned int :0; unsigned int v1:32; unsigned int v2:15; };
struct BFu0i_BFu32i_BFu15ll { unsigned int :0; unsigned int v1:32; unsigned long long v2:15; };
struct BFu0i_BFu32i_BFu15s { unsigned int :0; unsigned int v1:32; unsigned short v2:15; };
struct BFu0i_BFu32i_BFu16i { unsigned int :0; unsigned int v1:32; unsigned int v2:16; };
struct BFu0i_BFu32i_BFu16ll { unsigned int :0; unsigned int v1:32; unsigned long long v2:16; };
struct BFu0i_BFu32i_BFu16s { unsigned int :0; unsigned int v1:32; unsigned short v2:16; };
struct BFu0i_BFu32i_BFu17i { unsigned int :0; unsigned int v1:32; unsigned int v2:17; };
struct BFu0i_BFu32i_BFu17ll { unsigned int :0; unsigned int v1:32; unsigned long long v2:17; };
struct BFu0i_BFu32i_BFu1c { unsigned int :0; unsigned int v1:32; unsigned char v2:1; };
struct BFu0i_BFu32i_BFu1i { unsigned int :0; unsigned int v1:32; unsigned int v2:1; };
struct BFu0i_BFu32i_BFu1ll { unsigned int :0; unsigned int v1:32; unsigned long long v2:1; };
struct BFu0i_BFu32i_BFu1s { unsigned int :0; unsigned int v1:32; unsigned short v2:1; };
struct BFu0i_BFu32i_BFu31i { unsigned int :0; unsigned int v1:32; unsigned int v2:31; };
struct BFu0i_BFu32i_BFu31ll { unsigned int :0; unsigned int v1:32; unsigned long long v2:31; };
struct BFu0i_BFu32i_BFu32i { unsigned int :0; unsigned int v1:32; unsigned int v2:32; };
struct BFu0i_BFu32i_BFu32ll { unsigned int :0; unsigned int v1:32; unsigned long long v2:32; };
struct BFu0i_BFu32i_BFu33 { unsigned int :0; unsigned int v1:32; unsigned long long v2:33; };
struct BFu0i_BFu32i_BFu7c { unsigned int :0; unsigned int v1:32; unsigned char v2:7; };
struct BFu0i_BFu32i_BFu7i { unsigned int :0; unsigned int v1:32; unsigned int v2:7; };
struct BFu0i_BFu32i_BFu7ll { unsigned int :0; unsigned int v1:32; unsigned long long v2:7; };
struct BFu0i_BFu32i_BFu7s { unsigned int :0; unsigned int v1:32; unsigned short v2:7; };
struct BFu0i_BFu32i_BFu8c { unsigned int :0; unsigned int v1:32; unsigned char v2:8; };
struct BFu0i_BFu32i_BFu8i { unsigned int :0; unsigned int v1:32; unsigned int v2:8; };
struct BFu0i_BFu32i_BFu8ll { unsigned int :0; unsigned int v1:32; unsigned long long v2:8; };
struct BFu0i_BFu32i_BFu8s { unsigned int :0; unsigned int v1:32; unsigned short v2:8; };
struct BFu0i_BFu32i_BFu9i { unsigned int :0; unsigned int v1:32; unsigned int v2:9; };
struct BFu0i_BFu32i_BFu9ll { unsigned int :0; unsigned int v1:32; unsigned long long v2:9; };
struct BFu0i_BFu32i_BFu9s { unsigned int :0; unsigned int v1:32; unsigned short v2:9; };
struct BFu0i_BFu32i_C { unsigned int :0; unsigned int v1:32; char v2; };
struct BFu0i_BFu32i_D { unsigned int :0; unsigned int v1:32; double v2; };
struct BFu0i_BFu32i_F { unsigned int :0; unsigned int v1:32; float v2; };
struct BFu0i_BFu32i_I { unsigned int :0; unsigned int v1:32; int v2; };
struct BFu0i_BFu32i_Ip { unsigned int :0; unsigned int v1:32; int * v2; };
struct BFu0i_BFu32i_L { unsigned int :0; unsigned int v1:32; long long v2; };
struct BFu0i_BFu32i_S { unsigned int :0; unsigned int v1:32; short v2; };
struct BFu0i_BFu32i_Uc { unsigned int :0; unsigned int v1:32; unsigned char v2; };
struct BFu0i_BFu32i_Ui { unsigned int :0; unsigned int v1:32; unsigned int v2; };
struct BFu0i_BFu32i_Ul { unsigned int :0; unsigned int v1:32; unsigned long long v2; };
struct BFu0i_BFu32i_Us { unsigned int :0; unsigned int v1:32; unsigned short v2; };
struct BFu0i_BFu32i_Vp { unsigned int :0; unsigned int v1:32; void * v2; };
struct BFu0i_BFu32ll { unsigned int :0; unsigned long long v1:32; };
struct BFu0i_BFu32ll_BFu0c { unsigned int :0; unsigned long long v1:32; unsigned char :0; };
struct BFu0i_BFu32ll_BFu0i { unsigned int :0; unsigned long long v1:32; unsigned int :0; };
struct BFu0i_BFu32ll_BFu0ll { unsigned int :0; unsigned long long v1:32; unsigned long long :0; };
struct BFu0i_BFu32ll_BFu0s { unsigned int :0; unsigned long long v1:32; unsigned short :0; };
struct BFu0i_BFu32ll_BFu15i { unsigned int :0; unsigned long long v1:32; unsigned int v2:15; };
struct BFu0i_BFu32ll_BFu15ll { unsigned int :0; unsigned long long v1:32; unsigned long long v2:15; };
struct BFu0i_BFu32ll_BFu15s { unsigned int :0; unsigned long long v1:32; unsigned short v2:15; };
struct BFu0i_BFu32ll_BFu16i { unsigned int :0; unsigned long long v1:32; unsigned int v2:16; };
struct BFu0i_BFu32ll_BFu16ll { unsigned int :0; unsigned long long v1:32; unsigned long long v2:16; };
struct BFu0i_BFu32ll_BFu16s { unsigned int :0; unsigned long long v1:32; unsigned short v2:16; };
struct BFu0i_BFu32ll_BFu17i { unsigned int :0; unsigned long long v1:32; unsigned int v2:17; };
struct BFu0i_BFu32ll_BFu17ll { unsigned int :0; unsigned long long v1:32; unsigned long long v2:17; };
struct BFu0i_BFu32ll_BFu1c { unsigned int :0; unsigned long long v1:32; unsigned char v2:1; };
struct BFu0i_BFu32ll_BFu1i { unsigned int :0; unsigned long long v1:32; unsigned int v2:1; };
struct BFu0i_BFu32ll_BFu1ll { unsigned int :0; unsigned long long v1:32; unsigned long long v2:1; };
struct BFu0i_BFu32ll_BFu1s { unsigned int :0; unsigned long long v1:32; unsigned short v2:1; };
struct BFu0i_BFu32ll_BFu31i { unsigned int :0; unsigned long long v1:32; unsigned int v2:31; };
struct BFu0i_BFu32ll_BFu31ll { unsigned int :0; unsigned long long v1:32; unsigned long long v2:31; };
struct BFu0i_BFu32ll_BFu32i { unsigned int :0; unsigned long long v1:32; unsigned int v2:32; };
struct BFu0i_BFu32ll_BFu32ll { unsigned int :0; unsigned long long v1:32; unsigned long long v2:32; };
struct BFu0i_BFu32ll_BFu33 { unsigned int :0; unsigned long long v1:32; unsigned long long v2:33; };
struct BFu0i_BFu32ll_BFu7c { unsigned int :0; unsigned long long v1:32; unsigned char v2:7; };
struct BFu0i_BFu32ll_BFu7i { unsigned int :0; unsigned long long v1:32; unsigned int v2:7; };
struct BFu0i_BFu32ll_BFu7ll { unsigned int :0; unsigned long long v1:32; unsigned long long v2:7; };
struct BFu0i_BFu32ll_BFu7s { unsigned int :0; unsigned long long v1:32; unsigned short v2:7; };
struct BFu0i_BFu32ll_BFu8c { unsigned int :0; unsigned long long v1:32; unsigned char v2:8; };
struct BFu0i_BFu32ll_BFu8i { unsigned int :0; unsigned long long v1:32; unsigned int v2:8; };
struct BFu0i_BFu32ll_BFu8ll { unsigned int :0; unsigned long long v1:32; unsigned long long v2:8; };
struct BFu0i_BFu32ll_BFu8s { unsigned int :0; unsigned long long v1:32; unsigned short v2:8; };
struct BFu0i_BFu32ll_BFu9i { unsigned int :0; unsigned long long v1:32; unsigned int v2:9; };
struct BFu0i_BFu32ll_BFu9ll { unsigned int :0; unsigned long long v1:32; unsigned long long v2:9; };
struct BFu0i_BFu32ll_BFu9s { unsigned int :0; unsigned long long v1:32; unsigned short v2:9; };
struct BFu0i_BFu32ll_C { unsigned int :0; unsigned long long v1:32; char v2; };
struct BFu0i_BFu32ll_D { unsigned int :0; unsigned long long v1:32; double v2; };
struct BFu0i_BFu32ll_F { unsigned int :0; unsigned long long v1:32; float v2; };
struct BFu0i_BFu32ll_I { unsigned int :0; unsigned long long v1:32; int v2; };
struct BFu0i_BFu32ll_Ip { unsigned int :0; unsigned long long v1:32; int * v2; };
struct BFu0i_BFu32ll_L { unsigned int :0; unsigned long long v1:32; long long v2; };
struct BFu0i_BFu32ll_S { unsigned int :0; unsigned long long v1:32; short v2; };
struct BFu0i_BFu32ll_Uc { unsigned int :0; unsigned long long v1:32; unsigned char v2; };
struct BFu0i_BFu32ll_Ui { unsigned int :0; unsigned long long v1:32; unsigned int v2; };
struct BFu0i_BFu32ll_Ul { unsigned int :0; unsigned long long v1:32; unsigned long long v2; };
struct BFu0i_BFu32ll_Us { unsigned int :0; unsigned long long v1:32; unsigned short v2; };
struct BFu0i_BFu32ll_Vp { unsigned int :0; unsigned long long v1:32; void * v2; };
struct BFu0i_BFu33 { unsigned int :0; unsigned long long v1:33; };
struct BFu0i_BFu33_BFu0c { unsigned int :0; unsigned long long v1:33; unsigned char :0; };
struct BFu0i_BFu33_BFu0i { unsigned int :0; unsigned long long v1:33; unsigned int :0; };
struct BFu0i_BFu33_BFu0ll { unsigned int :0; unsigned long long v1:33; unsigned long long :0; };
struct BFu0i_BFu33_BFu0s { unsigned int :0; unsigned long long v1:33; unsigned short :0; };
struct BFu0i_BFu33_BFu15i { unsigned int :0; unsigned long long v1:33; unsigned int v2:15; };
struct BFu0i_BFu33_BFu15ll { unsigned int :0; unsigned long long v1:33; unsigned long long v2:15; };
struct BFu0i_BFu33_BFu15s { unsigned int :0; unsigned long long v1:33; unsigned short v2:15; };
struct BFu0i_BFu33_BFu16i { unsigned int :0; unsigned long long v1:33; unsigned int v2:16; };
struct BFu0i_BFu33_BFu16ll { unsigned int :0; unsigned long long v1:33; unsigned long long v2:16; };
struct BFu0i_BFu33_BFu16s { unsigned int :0; unsigned long long v1:33; unsigned short v2:16; };
struct BFu0i_BFu33_BFu17i { unsigned int :0; unsigned long long v1:33; unsigned int v2:17; };
struct BFu0i_BFu33_BFu17ll { unsigned int :0; unsigned long long v1:33; unsigned long long v2:17; };
struct BFu0i_BFu33_BFu1c { unsigned int :0; unsigned long long v1:33; unsigned char v2:1; };
struct BFu0i_BFu33_BFu1i { unsigned int :0; unsigned long long v1:33; unsigned int v2:1; };
struct BFu0i_BFu33_BFu1ll { unsigned int :0; unsigned long long v1:33; unsigned long long v2:1; };
struct BFu0i_BFu33_BFu1s { unsigned int :0; unsigned long long v1:33; unsigned short v2:1; };
struct BFu0i_BFu33_BFu31i { unsigned int :0; unsigned long long v1:33; unsigned int v2:31; };
struct BFu0i_BFu33_BFu31ll { unsigned int :0; unsigned long long v1:33; unsigned long long v2:31; };
struct BFu0i_BFu33_BFu32i { unsigned int :0; unsigned long long v1:33; unsigned int v2:32; };
struct BFu0i_BFu33_BFu32ll { unsigned int :0; unsigned long long v1:33; unsigned long long v2:32; };
struct BFu0i_BFu33_BFu33 { unsigned int :0; unsigned long long v1:33; unsigned long long v2:33; };
struct BFu0i_BFu33_BFu7c { unsigned int :0; unsigned long long v1:33; unsigned char v2:7; };
struct BFu0i_BFu33_BFu7i { unsigned int :0; unsigned long long v1:33; unsigned int v2:7; };
struct BFu0i_BFu33_BFu7ll { unsigned int :0; unsigned long long v1:33; unsigned long long v2:7; };
struct BFu0i_BFu33_BFu7s { unsigned int :0; unsigned long long v1:33; unsigned short v2:7; };
struct BFu0i_BFu33_BFu8c { unsigned int :0; unsigned long long v1:33; unsigned char v2:8; };
struct BFu0i_BFu33_BFu8i { unsigned int :0; unsigned long long v1:33; unsigned int v2:8; };
struct BFu0i_BFu33_BFu8ll { unsigned int :0; unsigned long long v1:33; unsigned long long v2:8; };
struct BFu0i_BFu33_BFu8s { unsigned int :0; unsigned long long v1:33; unsigned short v2:8; };
struct BFu0i_BFu33_BFu9i { unsigned int :0; unsigned long long v1:33; unsigned int v2:9; };
struct BFu0i_BFu33_BFu9ll { unsigned int :0; unsigned long long v1:33; unsigned long long v2:9; };
struct BFu0i_BFu33_BFu9s { unsigned int :0; unsigned long long v1:33; unsigned short v2:9; };
struct BFu0i_BFu33_C { unsigned int :0; unsigned long long v1:33; char v2; };
struct BFu0i_BFu33_D { unsigned int :0; unsigned long long v1:33; double v2; };
struct BFu0i_BFu33_F { unsigned int :0; unsigned long long v1:33; float v2; };
struct BFu0i_BFu33_I { unsigned int :0; unsigned long long v1:33; int v2; };
struct BFu0i_BFu33_Ip { unsigned int :0; unsigned long long v1:33; int * v2; };
struct BFu0i_BFu33_L { unsigned int :0; unsigned long long v1:33; long long v2; };
struct BFu0i_BFu33_S { unsigned int :0; unsigned long long v1:33; short v2; };
struct BFu0i_BFu33_Uc { unsigned int :0; unsigned long long v1:33; unsigned char v2; };
struct BFu0i_BFu33_Ui { unsigned int :0; unsigned long long v1:33; unsigned int v2; };
struct BFu0i_BFu33_Ul { unsigned int :0; unsigned long long v1:33; unsigned long long v2; };
struct BFu0i_BFu33_Us { unsigned int :0; unsigned long long v1:33; unsigned short v2; };
struct BFu0i_BFu33_Vp { unsigned int :0; unsigned long long v1:33; void * v2; };
struct BFu0i_BFu7c { unsigned int :0; unsigned char v1:7; };
struct BFu0i_BFu7c_BFu0c { unsigned int :0; unsigned char v1:7; unsigned char :0; };
struct BFu0i_BFu7c_BFu0i { unsigned int :0; unsigned char v1:7; unsigned int :0; };
struct BFu0i_BFu7c_BFu0ll { unsigned int :0; unsigned char v1:7; unsigned long long :0; };
struct BFu0i_BFu7c_BFu0s { unsigned int :0; unsigned char v1:7; unsigned short :0; };
struct BFu0i_BFu7c_BFu15i { unsigned int :0; unsigned char v1:7; unsigned int v2:15; };
struct BFu0i_BFu7c_BFu15ll { unsigned int :0; unsigned char v1:7; unsigned long long v2:15; };
struct BFu0i_BFu7c_BFu15s { unsigned int :0; unsigned char v1:7; unsigned short v2:15; };
struct BFu0i_BFu7c_BFu16i { unsigned int :0; unsigned char v1:7; unsigned int v2:16; };
struct BFu0i_BFu7c_BFu16ll { unsigned int :0; unsigned char v1:7; unsigned long long v2:16; };
struct BFu0i_BFu7c_BFu16s { unsigned int :0; unsigned char v1:7; unsigned short v2:16; };
struct BFu0i_BFu7c_BFu17i { unsigned int :0; unsigned char v1:7; unsigned int v2:17; };
struct BFu0i_BFu7c_BFu17ll { unsigned int :0; unsigned char v1:7; unsigned long long v2:17; };
struct BFu0i_BFu7c_BFu1c { unsigned int :0; unsigned char v1:7; unsigned char v2:1; };
struct BFu0i_BFu7c_BFu1i { unsigned int :0; unsigned char v1:7; unsigned int v2:1; };
struct BFu0i_BFu7c_BFu1ll { unsigned int :0; unsigned char v1:7; unsigned long long v2:1; };
struct BFu0i_BFu7c_BFu1s { unsigned int :0; unsigned char v1:7; unsigned short v2:1; };
struct BFu0i_BFu7c_BFu31i { unsigned int :0; unsigned char v1:7; unsigned int v2:31; };
struct BFu0i_BFu7c_BFu31ll { unsigned int :0; unsigned char v1:7; unsigned long long v2:31; };
struct BFu0i_BFu7c_BFu32i { unsigned int :0; unsigned char v1:7; unsigned int v2:32; };
struct BFu0i_BFu7c_BFu32ll { unsigned int :0; unsigned char v1:7; unsigned long long v2:32; };
struct BFu0i_BFu7c_BFu33 { unsigned int :0; unsigned char v1:7; unsigned long long v2:33; };
struct BFu0i_BFu7c_BFu7c { unsigned int :0; unsigned char v1:7; unsigned char v2:7; };
struct BFu0i_BFu7c_BFu7i { unsigned int :0; unsigned char v1:7; unsigned int v2:7; };
struct BFu0i_BFu7c_BFu7ll { unsigned int :0; unsigned char v1:7; unsigned long long v2:7; };
struct BFu0i_BFu7c_BFu7s { unsigned int :0; unsigned char v1:7; unsigned short v2:7; };
struct BFu0i_BFu7c_BFu8c { unsigned int :0; unsigned char v1:7; unsigned char v2:8; };
struct BFu0i_BFu7c_BFu8i { unsigned int :0; unsigned char v1:7; unsigned int v2:8; };
struct BFu0i_BFu7c_BFu8ll { unsigned int :0; unsigned char v1:7; unsigned long long v2:8; };
struct BFu0i_BFu7c_BFu8s { unsigned int :0; unsigned char v1:7; unsigned short v2:8; };
struct BFu0i_BFu7c_BFu9i { unsigned int :0; unsigned char v1:7; unsigned int v2:9; };
struct BFu0i_BFu7c_BFu9ll { unsigned int :0; unsigned char v1:7; unsigned long long v2:9; };
struct BFu0i_BFu7c_BFu9s { unsigned int :0; unsigned char v1:7; unsigned short v2:9; };
struct BFu0i_BFu7c_C { unsigned int :0; unsigned char v1:7; char v2; };
struct BFu0i_BFu7c_D { unsigned int :0; unsigned char v1:7; double v2; };
struct BFu0i_BFu7c_F { unsigned int :0; unsigned char v1:7; float v2; };
struct BFu0i_BFu7c_I { unsigned int :0; unsigned char v1:7; int v2; };
struct BFu0i_BFu7c_Ip { unsigned int :0; unsigned char v1:7; int * v2; };
struct BFu0i_BFu7c_L { unsigned int :0; unsigned char v1:7; long long v2; };
struct BFu0i_BFu7c_S { unsigned int :0; unsigned char v1:7; short v2; };
struct BFu0i_BFu7c_Uc { unsigned int :0; unsigned char v1:7; unsigned char v2; };
struct BFu0i_BFu7c_Ui { unsigned int :0; unsigned char v1:7; unsigned int v2; };
struct BFu0i_BFu7c_Ul { unsigned int :0; unsigned char v1:7; unsigned long long v2; };
struct BFu0i_BFu7c_Us { unsigned int :0; unsigned char v1:7; unsigned short v2; };
struct BFu0i_BFu7c_Vp { unsigned int :0; unsigned char v1:7; void * v2; };
struct BFu0i_BFu7i { unsigned int :0; unsigned int v1:7; };
struct BFu0i_BFu7i_BFu0c { unsigned int :0; unsigned int v1:7; unsigned char :0; };
struct BFu0i_BFu7i_BFu0i { unsigned int :0; unsigned int v1:7; unsigned int :0; };
struct BFu0i_BFu7i_BFu0ll { unsigned int :0; unsigned int v1:7; unsigned long long :0; };
struct BFu0i_BFu7i_BFu0s { unsigned int :0; unsigned int v1:7; unsigned short :0; };
struct BFu0i_BFu7i_BFu15i { unsigned int :0; unsigned int v1:7; unsigned int v2:15; };
struct BFu0i_BFu7i_BFu15ll { unsigned int :0; unsigned int v1:7; unsigned long long v2:15; };
struct BFu0i_BFu7i_BFu15s { unsigned int :0; unsigned int v1:7; unsigned short v2:15; };
struct BFu0i_BFu7i_BFu16i { unsigned int :0; unsigned int v1:7; unsigned int v2:16; };
struct BFu0i_BFu7i_BFu16ll { unsigned int :0; unsigned int v1:7; unsigned long long v2:16; };
struct BFu0i_BFu7i_BFu16s { unsigned int :0; unsigned int v1:7; unsigned short v2:16; };
struct BFu0i_BFu7i_BFu17i { unsigned int :0; unsigned int v1:7; unsigned int v2:17; };
struct BFu0i_BFu7i_BFu17ll { unsigned int :0; unsigned int v1:7; unsigned long long v2:17; };
struct BFu0i_BFu7i_BFu1c { unsigned int :0; unsigned int v1:7; unsigned char v2:1; };
struct BFu0i_BFu7i_BFu1i { unsigned int :0; unsigned int v1:7; unsigned int v2:1; };
struct BFu0i_BFu7i_BFu1ll { unsigned int :0; unsigned int v1:7; unsigned long long v2:1; };
struct BFu0i_BFu7i_BFu1s { unsigned int :0; unsigned int v1:7; unsigned short v2:1; };
struct BFu0i_BFu7i_BFu31i { unsigned int :0; unsigned int v1:7; unsigned int v2:31; };
struct BFu0i_BFu7i_BFu31ll { unsigned int :0; unsigned int v1:7; unsigned long long v2:31; };
struct BFu0i_BFu7i_BFu32i { unsigned int :0; unsigned int v1:7; unsigned int v2:32; };
struct BFu0i_BFu7i_BFu32ll { unsigned int :0; unsigned int v1:7; unsigned long long v2:32; };
struct BFu0i_BFu7i_BFu33 { unsigned int :0; unsigned int v1:7; unsigned long long v2:33; };
struct BFu0i_BFu7i_BFu7c { unsigned int :0; unsigned int v1:7; unsigned char v2:7; };
struct BFu0i_BFu7i_BFu7i { unsigned int :0; unsigned int v1:7; unsigned int v2:7; };
struct BFu0i_BFu7i_BFu7ll { unsigned int :0; unsigned int v1:7; unsigned long long v2:7; };
struct BFu0i_BFu7i_BFu7s { unsigned int :0; unsigned int v1:7; unsigned short v2:7; };
struct BFu0i_BFu7i_BFu8c { unsigned int :0; unsigned int v1:7; unsigned char v2:8; };
struct BFu0i_BFu7i_BFu8i { unsigned int :0; unsigned int v1:7; unsigned int v2:8; };
struct BFu0i_BFu7i_BFu8ll { unsigned int :0; unsigned int v1:7; unsigned long long v2:8; };
struct BFu0i_BFu7i_BFu8s { unsigned int :0; unsigned int v1:7; unsigned short v2:8; };
struct BFu0i_BFu7i_BFu9i { unsigned int :0; unsigned int v1:7; unsigned int v2:9; };
struct BFu0i_BFu7i_BFu9ll { unsigned int :0; unsigned int v1:7; unsigned long long v2:9; };
struct BFu0i_BFu7i_BFu9s { unsigned int :0; unsigned int v1:7; unsigned short v2:9; };
struct BFu0i_BFu7i_C { unsigned int :0; unsigned int v1:7; char v2; };
struct BFu0i_BFu7i_D { unsigned int :0; unsigned int v1:7; double v2; };
struct BFu0i_BFu7i_F { unsigned int :0; unsigned int v1:7; float v2; };
struct BFu0i_BFu7i_I { unsigned int :0; unsigned int v1:7; int v2; };
struct BFu0i_BFu7i_Ip { unsigned int :0; unsigned int v1:7; int * v2; };
struct BFu0i_BFu7i_L { unsigned int :0; unsigned int v1:7; long long v2; };
struct BFu0i_BFu7i_S { unsigned int :0; unsigned int v1:7; short v2; };
struct BFu0i_BFu7i_Uc { unsigned int :0; unsigned int v1:7; unsigned char v2; };
struct BFu0i_BFu7i_Ui { unsigned int :0; unsigned int v1:7; unsigned int v2; };
struct BFu0i_BFu7i_Ul { unsigned int :0; unsigned int v1:7; unsigned long long v2; };
struct BFu0i_BFu7i_Us { unsigned int :0; unsigned int v1:7; unsigned short v2; };
struct BFu0i_BFu7i_Vp { unsigned int :0; unsigned int v1:7; void * v2; };
struct BFu0i_BFu7ll { unsigned int :0; unsigned long long v1:7; };
struct BFu0i_BFu7ll_BFu0c { unsigned int :0; unsigned long long v1:7; unsigned char :0; };
struct BFu0i_BFu7ll_BFu0i { unsigned int :0; unsigned long long v1:7; unsigned int :0; };
struct BFu0i_BFu7ll_BFu0ll { unsigned int :0; unsigned long long v1:7; unsigned long long :0; };
struct BFu0i_BFu7ll_BFu0s { unsigned int :0; unsigned long long v1:7; unsigned short :0; };
struct BFu0i_BFu7ll_BFu15i { unsigned int :0; unsigned long long v1:7; unsigned int v2:15; };
struct BFu0i_BFu7ll_BFu15ll { unsigned int :0; unsigned long long v1:7; unsigned long long v2:15; };
struct BFu0i_BFu7ll_BFu15s { unsigned int :0; unsigned long long v1:7; unsigned short v2:15; };
struct BFu0i_BFu7ll_BFu16i { unsigned int :0; unsigned long long v1:7; unsigned int v2:16; };
struct BFu0i_BFu7ll_BFu16ll { unsigned int :0; unsigned long long v1:7; unsigned long long v2:16; };
struct BFu0i_BFu7ll_BFu16s { unsigned int :0; unsigned long long v1:7; unsigned short v2:16; };
struct BFu0i_BFu7ll_BFu17i { unsigned int :0; unsigned long long v1:7; unsigned int v2:17; };
struct BFu0i_BFu7ll_BFu17ll { unsigned int :0; unsigned long long v1:7; unsigned long long v2:17; };
struct BFu0i_BFu7ll_BFu1c { unsigned int :0; unsigned long long v1:7; unsigned char v2:1; };
struct BFu0i_BFu7ll_BFu1i { unsigned int :0; unsigned long long v1:7; unsigned int v2:1; };
struct BFu0i_BFu7ll_BFu1ll { unsigned int :0; unsigned long long v1:7; unsigned long long v2:1; };
struct BFu0i_BFu7ll_BFu1s { unsigned int :0; unsigned long long v1:7; unsigned short v2:1; };
struct BFu0i_BFu7ll_BFu31i { unsigned int :0; unsigned long long v1:7; unsigned int v2:31; };
struct BFu0i_BFu7ll_BFu31ll { unsigned int :0; unsigned long long v1:7; unsigned long long v2:31; };
struct BFu0i_BFu7ll_BFu32i { unsigned int :0; unsigned long long v1:7; unsigned int v2:32; };
struct BFu0i_BFu7ll_BFu32ll { unsigned int :0; unsigned long long v1:7; unsigned long long v2:32; };
struct BFu0i_BFu7ll_BFu33 { unsigned int :0; unsigned long long v1:7; unsigned long long v2:33; };
struct BFu0i_BFu7ll_BFu7c { unsigned int :0; unsigned long long v1:7; unsigned char v2:7; };
struct BFu0i_BFu7ll_BFu7i { unsigned int :0; unsigned long long v1:7; unsigned int v2:7; };
struct BFu0i_BFu7ll_BFu7ll { unsigned int :0; unsigned long long v1:7; unsigned long long v2:7; };
struct BFu0i_BFu7ll_BFu7s { unsigned int :0; unsigned long long v1:7; unsigned short v2:7; };
struct BFu0i_BFu7ll_BFu8c { unsigned int :0; unsigned long long v1:7; unsigned char v2:8; };
struct BFu0i_BFu7ll_BFu8i { unsigned int :0; unsigned long long v1:7; unsigned int v2:8; };
struct BFu0i_BFu7ll_BFu8ll { unsigned int :0; unsigned long long v1:7; unsigned long long v2:8; };
struct BFu0i_BFu7ll_BFu8s { unsigned int :0; unsigned long long v1:7; unsigned short v2:8; };
struct BFu0i_BFu7ll_BFu9i { unsigned int :0; unsigned long long v1:7; unsigned int v2:9; };
struct BFu0i_BFu7ll_BFu9ll { unsigned int :0; unsigned long long v1:7; unsigned long long v2:9; };
struct BFu0i_BFu7ll_BFu9s { unsigned int :0; unsigned long long v1:7; unsigned short v2:9; };
struct BFu0i_BFu7ll_C { unsigned int :0; unsigned long long v1:7; char v2; };
struct BFu0i_BFu7ll_D { unsigned int :0; unsigned long long v1:7; double v2; };
struct BFu0i_BFu7ll_F { unsigned int :0; unsigned long long v1:7; float v2; };
struct BFu0i_BFu7ll_I { unsigned int :0; unsigned long long v1:7; int v2; };
struct BFu0i_BFu7ll_Ip { unsigned int :0; unsigned long long v1:7; int * v2; };
struct BFu0i_BFu7ll_L { unsigned int :0; unsigned long long v1:7; long long v2; };
struct BFu0i_BFu7ll_S { unsigned int :0; unsigned long long v1:7; short v2; };
struct BFu0i_BFu7ll_Uc { unsigned int :0; unsigned long long v1:7; unsigned char v2; };
struct BFu0i_BFu7ll_Ui { unsigned int :0; unsigned long long v1:7; unsigned int v2; };
struct BFu0i_BFu7ll_Ul { unsigned int :0; unsigned long long v1:7; unsigned long long v2; };
struct BFu0i_BFu7ll_Us { unsigned int :0; unsigned long long v1:7; unsigned short v2; };
struct BFu0i_BFu7ll_Vp { unsigned int :0; unsigned long long v1:7; void * v2; };
struct BFu0i_BFu7s { unsigned int :0; unsigned short v1:7; };
struct BFu0i_BFu7s_BFu0c { unsigned int :0; unsigned short v1:7; unsigned char :0; };
struct BFu0i_BFu7s_BFu0i { unsigned int :0; unsigned short v1:7; unsigned int :0; };
struct BFu0i_BFu7s_BFu0ll { unsigned int :0; unsigned short v1:7; unsigned long long :0; };
struct BFu0i_BFu7s_BFu0s { unsigned int :0; unsigned short v1:7; unsigned short :0; };
struct BFu0i_BFu7s_BFu15i { unsigned int :0; unsigned short v1:7; unsigned int v2:15; };
struct BFu0i_BFu7s_BFu15ll { unsigned int :0; unsigned short v1:7; unsigned long long v2:15; };
struct BFu0i_BFu7s_BFu15s { unsigned int :0; unsigned short v1:7; unsigned short v2:15; };
struct BFu0i_BFu7s_BFu16i { unsigned int :0; unsigned short v1:7; unsigned int v2:16; };
struct BFu0i_BFu7s_BFu16ll { unsigned int :0; unsigned short v1:7; unsigned long long v2:16; };
struct BFu0i_BFu7s_BFu16s { unsigned int :0; unsigned short v1:7; unsigned short v2:16; };
struct BFu0i_BFu7s_BFu17i { unsigned int :0; unsigned short v1:7; unsigned int v2:17; };
struct BFu0i_BFu7s_BFu17ll { unsigned int :0; unsigned short v1:7; unsigned long long v2:17; };
struct BFu0i_BFu7s_BFu1c { unsigned int :0; unsigned short v1:7; unsigned char v2:1; };
struct BFu0i_BFu7s_BFu1i { unsigned int :0; unsigned short v1:7; unsigned int v2:1; };
struct BFu0i_BFu7s_BFu1ll { unsigned int :0; unsigned short v1:7; unsigned long long v2:1; };
struct BFu0i_BFu7s_BFu1s { unsigned int :0; unsigned short v1:7; unsigned short v2:1; };
struct BFu0i_BFu7s_BFu31i { unsigned int :0; unsigned short v1:7; unsigned int v2:31; };
struct BFu0i_BFu7s_BFu31ll { unsigned int :0; unsigned short v1:7; unsigned long long v2:31; };
struct BFu0i_BFu7s_BFu32i { unsigned int :0; unsigned short v1:7; unsigned int v2:32; };
struct BFu0i_BFu7s_BFu32ll { unsigned int :0; unsigned short v1:7; unsigned long long v2:32; };
struct BFu0i_BFu7s_BFu33 { unsigned int :0; unsigned short v1:7; unsigned long long v2:33; };
struct BFu0i_BFu7s_BFu7c { unsigned int :0; unsigned short v1:7; unsigned char v2:7; };
struct BFu0i_BFu7s_BFu7i { unsigned int :0; unsigned short v1:7; unsigned int v2:7; };
struct BFu0i_BFu7s_BFu7ll { unsigned int :0; unsigned short v1:7; unsigned long long v2:7; };
struct BFu0i_BFu7s_BFu7s { unsigned int :0; unsigned short v1:7; unsigned short v2:7; };
struct BFu0i_BFu7s_BFu8c { unsigned int :0; unsigned short v1:7; unsigned char v2:8; };
struct BFu0i_BFu7s_BFu8i { unsigned int :0; unsigned short v1:7; unsigned int v2:8; };
struct BFu0i_BFu7s_BFu8ll { unsigned int :0; unsigned short v1:7; unsigned long long v2:8; };
struct BFu0i_BFu7s_BFu8s { unsigned int :0; unsigned short v1:7; unsigned short v2:8; };
struct BFu0i_BFu7s_BFu9i { unsigned int :0; unsigned short v1:7; unsigned int v2:9; };
struct BFu0i_BFu7s_BFu9ll { unsigned int :0; unsigned short v1:7; unsigned long long v2:9; };
struct BFu0i_BFu7s_BFu9s { unsigned int :0; unsigned short v1:7; unsigned short v2:9; };
struct BFu0i_BFu7s_C { unsigned int :0; unsigned short v1:7; char v2; };
struct BFu0i_BFu7s_D { unsigned int :0; unsigned short v1:7; double v2; };
struct BFu0i_BFu7s_F { unsigned int :0; unsigned short v1:7; float v2; };
struct BFu0i_BFu7s_I { unsigned int :0; unsigned short v1:7; int v2; };
struct BFu0i_BFu7s_Ip { unsigned int :0; unsigned short v1:7; int * v2; };
struct BFu0i_BFu7s_L { unsigned int :0; unsigned short v1:7; long long v2; };
struct BFu0i_BFu7s_S { unsigned int :0; unsigned short v1:7; short v2; };
struct BFu0i_BFu7s_Uc { unsigned int :0; unsigned short v1:7; unsigned char v2; };
struct BFu0i_BFu7s_Ui { unsigned int :0; unsigned short v1:7; unsigned int v2; };
struct BFu0i_BFu7s_Ul { unsigned int :0; unsigned short v1:7; unsigned long long v2; };
struct BFu0i_BFu7s_Us { unsigned int :0; unsigned short v1:7; unsigned short v2; };
struct BFu0i_BFu7s_Vp { unsigned int :0; unsigned short v1:7; void * v2; };
struct BFu0i_BFu8c { unsigned int :0; unsigned char v1:8; };
struct BFu0i_BFu8c_BFu0c { unsigned int :0; unsigned char v1:8; unsigned char :0; };
struct BFu0i_BFu8c_BFu0i { unsigned int :0; unsigned char v1:8; unsigned int :0; };
struct BFu0i_BFu8c_BFu0ll { unsigned int :0; unsigned char v1:8; unsigned long long :0; };
struct BFu0i_BFu8c_BFu0s { unsigned int :0; unsigned char v1:8; unsigned short :0; };
struct BFu0i_BFu8c_BFu15i { unsigned int :0; unsigned char v1:8; unsigned int v2:15; };
struct BFu0i_BFu8c_BFu15ll { unsigned int :0; unsigned char v1:8; unsigned long long v2:15; };
struct BFu0i_BFu8c_BFu15s { unsigned int :0; unsigned char v1:8; unsigned short v2:15; };
struct BFu0i_BFu8c_BFu16i { unsigned int :0; unsigned char v1:8; unsigned int v2:16; };
struct BFu0i_BFu8c_BFu16ll { unsigned int :0; unsigned char v1:8; unsigned long long v2:16; };
struct BFu0i_BFu8c_BFu16s { unsigned int :0; unsigned char v1:8; unsigned short v2:16; };
struct BFu0i_BFu8c_BFu17i { unsigned int :0; unsigned char v1:8; unsigned int v2:17; };
struct BFu0i_BFu8c_BFu17ll { unsigned int :0; unsigned char v1:8; unsigned long long v2:17; };
struct BFu0i_BFu8c_BFu1c { unsigned int :0; unsigned char v1:8; unsigned char v2:1; };
struct BFu0i_BFu8c_BFu1i { unsigned int :0; unsigned char v1:8; unsigned int v2:1; };
struct BFu0i_BFu8c_BFu1ll { unsigned int :0; unsigned char v1:8; unsigned long long v2:1; };
struct BFu0i_BFu8c_BFu1s { unsigned int :0; unsigned char v1:8; unsigned short v2:1; };
struct BFu0i_BFu8c_BFu31i { unsigned int :0; unsigned char v1:8; unsigned int v2:31; };
struct BFu0i_BFu8c_BFu31ll { unsigned int :0; unsigned char v1:8; unsigned long long v2:31; };
struct BFu0i_BFu8c_BFu32i { unsigned int :0; unsigned char v1:8; unsigned int v2:32; };
struct BFu0i_BFu8c_BFu32ll { unsigned int :0; unsigned char v1:8; unsigned long long v2:32; };
struct BFu0i_BFu8c_BFu33 { unsigned int :0; unsigned char v1:8; unsigned long long v2:33; };
struct BFu0i_BFu8c_BFu7c { unsigned int :0; unsigned char v1:8; unsigned char v2:7; };
struct BFu0i_BFu8c_BFu7i { unsigned int :0; unsigned char v1:8; unsigned int v2:7; };
struct BFu0i_BFu8c_BFu7ll { unsigned int :0; unsigned char v1:8; unsigned long long v2:7; };
struct BFu0i_BFu8c_BFu7s { unsigned int :0; unsigned char v1:8; unsigned short v2:7; };
struct BFu0i_BFu8c_BFu8c { unsigned int :0; unsigned char v1:8; unsigned char v2:8; };
struct BFu0i_BFu8c_BFu8i { unsigned int :0; unsigned char v1:8; unsigned int v2:8; };
struct BFu0i_BFu8c_BFu8ll { unsigned int :0; unsigned char v1:8; unsigned long long v2:8; };
struct BFu0i_BFu8c_BFu8s { unsigned int :0; unsigned char v1:8; unsigned short v2:8; };
struct BFu0i_BFu8c_BFu9i { unsigned int :0; unsigned char v1:8; unsigned int v2:9; };
struct BFu0i_BFu8c_BFu9ll { unsigned int :0; unsigned char v1:8; unsigned long long v2:9; };
struct BFu0i_BFu8c_BFu9s { unsigned int :0; unsigned char v1:8; unsigned short v2:9; };
struct BFu0i_BFu8c_C { unsigned int :0; unsigned char v1:8; char v2; };
struct BFu0i_BFu8c_D { unsigned int :0; unsigned char v1:8; double v2; };
struct BFu0i_BFu8c_F { unsigned int :0; unsigned char v1:8; float v2; };
struct BFu0i_BFu8c_I { unsigned int :0; unsigned char v1:8; int v2; };
struct BFu0i_BFu8c_Ip { unsigned int :0; unsigned char v1:8; int * v2; };
struct BFu0i_BFu8c_L { unsigned int :0; unsigned char v1:8; long long v2; };
struct BFu0i_BFu8c_S { unsigned int :0; unsigned char v1:8; short v2; };
struct BFu0i_BFu8c_Uc { unsigned int :0; unsigned char v1:8; unsigned char v2; };
struct BFu0i_BFu8c_Ui { unsigned int :0; unsigned char v1:8; unsigned int v2; };
struct BFu0i_BFu8c_Ul { unsigned int :0; unsigned char v1:8; unsigned long long v2; };
struct BFu0i_BFu8c_Us { unsigned int :0; unsigned char v1:8; unsigned short v2; };
struct BFu0i_BFu8c_Vp { unsigned int :0; unsigned char v1:8; void * v2; };
struct BFu0i_BFu8i { unsigned int :0; unsigned int v1:8; };
struct BFu0i_BFu8i_BFu0c { unsigned int :0; unsigned int v1:8; unsigned char :0; };
struct BFu0i_BFu8i_BFu0i { unsigned int :0; unsigned int v1:8; unsigned int :0; };
struct BFu0i_BFu8i_BFu0ll { unsigned int :0; unsigned int v1:8; unsigned long long :0; };
struct BFu0i_BFu8i_BFu0s { unsigned int :0; unsigned int v1:8; unsigned short :0; };
struct BFu0i_BFu8i_BFu15i { unsigned int :0; unsigned int v1:8; unsigned int v2:15; };
struct BFu0i_BFu8i_BFu15ll { unsigned int :0; unsigned int v1:8; unsigned long long v2:15; };
struct BFu0i_BFu8i_BFu15s { unsigned int :0; unsigned int v1:8; unsigned short v2:15; };
struct BFu0i_BFu8i_BFu16i { unsigned int :0; unsigned int v1:8; unsigned int v2:16; };
struct BFu0i_BFu8i_BFu16ll { unsigned int :0; unsigned int v1:8; unsigned long long v2:16; };
struct BFu0i_BFu8i_BFu16s { unsigned int :0; unsigned int v1:8; unsigned short v2:16; };
struct BFu0i_BFu8i_BFu17i { unsigned int :0; unsigned int v1:8; unsigned int v2:17; };
struct BFu0i_BFu8i_BFu17ll { unsigned int :0; unsigned int v1:8; unsigned long long v2:17; };
struct BFu0i_BFu8i_BFu1c { unsigned int :0; unsigned int v1:8; unsigned char v2:1; };
struct BFu0i_BFu8i_BFu1i { unsigned int :0; unsigned int v1:8; unsigned int v2:1; };
struct BFu0i_BFu8i_BFu1ll { unsigned int :0; unsigned int v1:8; unsigned long long v2:1; };
struct BFu0i_BFu8i_BFu1s { unsigned int :0; unsigned int v1:8; unsigned short v2:1; };
struct BFu0i_BFu8i_BFu31i { unsigned int :0; unsigned int v1:8; unsigned int v2:31; };
struct BFu0i_BFu8i_BFu31ll { unsigned int :0; unsigned int v1:8; unsigned long long v2:31; };
struct BFu0i_BFu8i_BFu32i { unsigned int :0; unsigned int v1:8; unsigned int v2:32; };
struct BFu0i_BFu8i_BFu32ll { unsigned int :0; unsigned int v1:8; unsigned long long v2:32; };
struct BFu0i_BFu8i_BFu33 { unsigned int :0; unsigned int v1:8; unsigned long long v2:33; };
struct BFu0i_BFu8i_BFu7c { unsigned int :0; unsigned int v1:8; unsigned char v2:7; };
struct BFu0i_BFu8i_BFu7i { unsigned int :0; unsigned int v1:8; unsigned int v2:7; };
struct BFu0i_BFu8i_BFu7ll { unsigned int :0; unsigned int v1:8; unsigned long long v2:7; };
struct BFu0i_BFu8i_BFu7s { unsigned int :0; unsigned int v1:8; unsigned short v2:7; };
struct BFu0i_BFu8i_BFu8c { unsigned int :0; unsigned int v1:8; unsigned char v2:8; };
struct BFu0i_BFu8i_BFu8i { unsigned int :0; unsigned int v1:8; unsigned int v2:8; };
struct BFu0i_BFu8i_BFu8ll { unsigned int :0; unsigned int v1:8; unsigned long long v2:8; };
struct BFu0i_BFu8i_BFu8s { unsigned int :0; unsigned int v1:8; unsigned short v2:8; };
struct BFu0i_BFu8i_BFu9i { unsigned int :0; unsigned int v1:8; unsigned int v2:9; };
struct BFu0i_BFu8i_BFu9ll { unsigned int :0; unsigned int v1:8; unsigned long long v2:9; };
struct BFu0i_BFu8i_BFu9s { unsigned int :0; unsigned int v1:8; unsigned short v2:9; };
struct BFu0i_BFu8i_C { unsigned int :0; unsigned int v1:8; char v2; };
struct BFu0i_BFu8i_D { unsigned int :0; unsigned int v1:8; double v2; };
struct BFu0i_BFu8i_F { unsigned int :0; unsigned int v1:8; float v2; };
struct BFu0i_BFu8i_I { unsigned int :0; unsigned int v1:8; int v2; };
struct BFu0i_BFu8i_Ip { unsigned int :0; unsigned int v1:8; int * v2; };
struct BFu0i_BFu8i_L { unsigned int :0; unsigned int v1:8; long long v2; };
struct BFu0i_BFu8i_S { unsigned int :0; unsigned int v1:8; short v2; };
struct BFu0i_BFu8i_Uc { unsigned int :0; unsigned int v1:8; unsigned char v2; };
struct BFu0i_BFu8i_Ui { unsigned int :0; unsigned int v1:8; unsigned int v2; };
struct BFu0i_BFu8i_Ul { unsigned int :0; unsigned int v1:8; unsigned long long v2; };
struct BFu0i_BFu8i_Us { unsigned int :0; unsigned int v1:8; unsigned short v2; };
struct BFu0i_BFu8i_Vp { unsigned int :0; unsigned int v1:8; void * v2; };
struct BFu0i_BFu8ll { unsigned int :0; unsigned long long v1:8; };
struct BFu0i_BFu8ll_BFu0c { unsigned int :0; unsigned long long v1:8; unsigned char :0; };
struct BFu0i_BFu8ll_BFu0i { unsigned int :0; unsigned long long v1:8; unsigned int :0; };
struct BFu0i_BFu8ll_BFu0ll { unsigned int :0; unsigned long long v1:8; unsigned long long :0; };
struct BFu0i_BFu8ll_BFu0s { unsigned int :0; unsigned long long v1:8; unsigned short :0; };
struct BFu0i_BFu8ll_BFu15i { unsigned int :0; unsigned long long v1:8; unsigned int v2:15; };
struct BFu0i_BFu8ll_BFu15ll { unsigned int :0; unsigned long long v1:8; unsigned long long v2:15; };
struct BFu0i_BFu8ll_BFu15s { unsigned int :0; unsigned long long v1:8; unsigned short v2:15; };
struct BFu0i_BFu8ll_BFu16i { unsigned int :0; unsigned long long v1:8; unsigned int v2:16; };
struct BFu0i_BFu8ll_BFu16ll { unsigned int :0; unsigned long long v1:8; unsigned long long v2:16; };
struct BFu0i_BFu8ll_BFu16s { unsigned int :0; unsigned long long v1:8; unsigned short v2:16; };
struct BFu0i_BFu8ll_BFu17i { unsigned int :0; unsigned long long v1:8; unsigned int v2:17; };
struct BFu0i_BFu8ll_BFu17ll { unsigned int :0; unsigned long long v1:8; unsigned long long v2:17; };
struct BFu0i_BFu8ll_BFu1c { unsigned int :0; unsigned long long v1:8; unsigned char v2:1; };
struct BFu0i_BFu8ll_BFu1i { unsigned int :0; unsigned long long v1:8; unsigned int v2:1; };
struct BFu0i_BFu8ll_BFu1ll { unsigned int :0; unsigned long long v1:8; unsigned long long v2:1; };
struct BFu0i_BFu8ll_BFu1s { unsigned int :0; unsigned long long v1:8; unsigned short v2:1; };
struct BFu0i_BFu8ll_BFu31i { unsigned int :0; unsigned long long v1:8; unsigned int v2:31; };
struct BFu0i_BFu8ll_BFu31ll { unsigned int :0; unsigned long long v1:8; unsigned long long v2:31; };
struct BFu0i_BFu8ll_BFu32i { unsigned int :0; unsigned long long v1:8; unsigned int v2:32; };
struct BFu0i_BFu8ll_BFu32ll { unsigned int :0; unsigned long long v1:8; unsigned long long v2:32; };
struct BFu0i_BFu8ll_BFu33 { unsigned int :0; unsigned long long v1:8; unsigned long long v2:33; };
struct BFu0i_BFu8ll_BFu7c { unsigned int :0; unsigned long long v1:8; unsigned char v2:7; };
struct BFu0i_BFu8ll_BFu7i { unsigned int :0; unsigned long long v1:8; unsigned int v2:7; };
struct BFu0i_BFu8ll_BFu7ll { unsigned int :0; unsigned long long v1:8; unsigned long long v2:7; };
struct BFu0i_BFu8ll_BFu7s { unsigned int :0; unsigned long long v1:8; unsigned short v2:7; };
struct BFu0i_BFu8ll_BFu8c { unsigned int :0; unsigned long long v1:8; unsigned char v2:8; };
struct BFu0i_BFu8ll_BFu8i { unsigned int :0; unsigned long long v1:8; unsigned int v2:8; };
struct BFu0i_BFu8ll_BFu8ll { unsigned int :0; unsigned long long v1:8; unsigned long long v2:8; };
struct BFu0i_BFu8ll_BFu8s { unsigned int :0; unsigned long long v1:8; unsigned short v2:8; };
struct BFu0i_BFu8ll_BFu9i { unsigned int :0; unsigned long long v1:8; unsigned int v2:9; };
struct BFu0i_BFu8ll_BFu9ll { unsigned int :0; unsigned long long v1:8; unsigned long long v2:9; };
struct BFu0i_BFu8ll_BFu9s { unsigned int :0; unsigned long long v1:8; unsigned short v2:9; };
struct BFu0i_BFu8ll_C { unsigned int :0; unsigned long long v1:8; char v2; };
struct BFu0i_BFu8ll_D { unsigned int :0; unsigned long long v1:8; double v2; };
struct BFu0i_BFu8ll_F { unsigned int :0; unsigned long long v1:8; float v2; };
struct BFu0i_BFu8ll_I { unsigned int :0; unsigned long long v1:8; int v2; };
struct BFu0i_BFu8ll_Ip { unsigned int :0; unsigned long long v1:8; int * v2; };
struct BFu0i_BFu8ll_L { unsigned int :0; unsigned long long v1:8; long long v2; };
struct BFu0i_BFu8ll_S { unsigned int :0; unsigned long long v1:8; short v2; };
struct BFu0i_BFu8ll_Uc { unsigned int :0; unsigned long long v1:8; unsigned char v2; };
struct BFu0i_BFu8ll_Ui { unsigned int :0; unsigned long long v1:8; unsigned int v2; };
struct BFu0i_BFu8ll_Ul { unsigned int :0; unsigned long long v1:8; unsigned long long v2; };
struct BFu0i_BFu8ll_Us { unsigned int :0; unsigned long long v1:8; unsigned short v2; };
struct BFu0i_BFu8ll_Vp { unsigned int :0; unsigned long long v1:8; void * v2; };
struct BFu0i_BFu8s { unsigned int :0; unsigned short v1:8; };
struct BFu0i_BFu8s_BFu0c { unsigned int :0; unsigned short v1:8; unsigned char :0; };
struct BFu0i_BFu8s_BFu0i { unsigned int :0; unsigned short v1:8; unsigned int :0; };
struct BFu0i_BFu8s_BFu0ll { unsigned int :0; unsigned short v1:8; unsigned long long :0; };
struct BFu0i_BFu8s_BFu0s { unsigned int :0; unsigned short v1:8; unsigned short :0; };
struct BFu0i_BFu8s_BFu15i { unsigned int :0; unsigned short v1:8; unsigned int v2:15; };
struct BFu0i_BFu8s_BFu15ll { unsigned int :0; unsigned short v1:8; unsigned long long v2:15; };
struct BFu0i_BFu8s_BFu15s { unsigned int :0; unsigned short v1:8; unsigned short v2:15; };
struct BFu0i_BFu8s_BFu16i { unsigned int :0; unsigned short v1:8; unsigned int v2:16; };
struct BFu0i_BFu8s_BFu16ll { unsigned int :0; unsigned short v1:8; unsigned long long v2:16; };
struct BFu0i_BFu8s_BFu16s { unsigned int :0; unsigned short v1:8; unsigned short v2:16; };
struct BFu0i_BFu8s_BFu17i { unsigned int :0; unsigned short v1:8; unsigned int v2:17; };
struct BFu0i_BFu8s_BFu17ll { unsigned int :0; unsigned short v1:8; unsigned long long v2:17; };
struct BFu0i_BFu8s_BFu1c { unsigned int :0; unsigned short v1:8; unsigned char v2:1; };
struct BFu0i_BFu8s_BFu1i { unsigned int :0; unsigned short v1:8; unsigned int v2:1; };
struct BFu0i_BFu8s_BFu1ll { unsigned int :0; unsigned short v1:8; unsigned long long v2:1; };
struct BFu0i_BFu8s_BFu1s { unsigned int :0; unsigned short v1:8; unsigned short v2:1; };
struct BFu0i_BFu8s_BFu31i { unsigned int :0; unsigned short v1:8; unsigned int v2:31; };
struct BFu0i_BFu8s_BFu31ll { unsigned int :0; unsigned short v1:8; unsigned long long v2:31; };
struct BFu0i_BFu8s_BFu32i { unsigned int :0; unsigned short v1:8; unsigned int v2:32; };
struct BFu0i_BFu8s_BFu32ll { unsigned int :0; unsigned short v1:8; unsigned long long v2:32; };
struct BFu0i_BFu8s_BFu33 { unsigned int :0; unsigned short v1:8; unsigned long long v2:33; };
struct BFu0i_BFu8s_BFu7c { unsigned int :0; unsigned short v1:8; unsigned char v2:7; };
struct BFu0i_BFu8s_BFu7i { unsigned int :0; unsigned short v1:8; unsigned int v2:7; };
struct BFu0i_BFu8s_BFu7ll { unsigned int :0; unsigned short v1:8; unsigned long long v2:7; };
struct BFu0i_BFu8s_BFu7s { unsigned int :0; unsigned short v1:8; unsigned short v2:7; };
struct BFu0i_BFu8s_BFu8c { unsigned int :0; unsigned short v1:8; unsigned char v2:8; };
struct BFu0i_BFu8s_BFu8i { unsigned int :0; unsigned short v1:8; unsigned int v2:8; };
struct BFu0i_BFu8s_BFu8ll { unsigned int :0; unsigned short v1:8; unsigned long long v2:8; };
struct BFu0i_BFu8s_BFu8s { unsigned int :0; unsigned short v1:8; unsigned short v2:8; };
struct BFu0i_BFu8s_BFu9i { unsigned int :0; unsigned short v1:8; unsigned int v2:9; };
struct BFu0i_BFu8s_BFu9ll { unsigned int :0; unsigned short v1:8; unsigned long long v2:9; };
struct BFu0i_BFu8s_BFu9s { unsigned int :0; unsigned short v1:8; unsigned short v2:9; };
struct BFu0i_BFu8s_C { unsigned int :0; unsigned short v1:8; char v2; };
struct BFu0i_BFu8s_D { unsigned int :0; unsigned short v1:8; double v2; };
struct BFu0i_BFu8s_F { unsigned int :0; unsigned short v1:8; float v2; };
struct BFu0i_BFu8s_I { unsigned int :0; unsigned short v1:8; int v2; };
struct BFu0i_BFu8s_Ip { unsigned int :0; unsigned short v1:8; int * v2; };
struct BFu0i_BFu8s_L { unsigned int :0; unsigned short v1:8; long long v2; };
struct BFu0i_BFu8s_S { unsigned int :0; unsigned short v1:8; short v2; };
struct BFu0i_BFu8s_Uc { unsigned int :0; unsigned short v1:8; unsigned char v2; };
struct BFu0i_BFu8s_Ui { unsigned int :0; unsigned short v1:8; unsigned int v2; };
struct BFu0i_BFu8s_Ul { unsigned int :0; unsigned short v1:8; unsigned long long v2; };
struct BFu0i_BFu8s_Us { unsigned int :0; unsigned short v1:8; unsigned short v2; };
struct BFu0i_BFu8s_Vp { unsigned int :0; unsigned short v1:8; void * v2; };
struct BFu0i_BFu9i { unsigned int :0; unsigned int v1:9; };
struct BFu0i_BFu9i_BFu0c { unsigned int :0; unsigned int v1:9; unsigned char :0; };
struct BFu0i_BFu9i_BFu0i { unsigned int :0; unsigned int v1:9; unsigned int :0; };
struct BFu0i_BFu9i_BFu0ll { unsigned int :0; unsigned int v1:9; unsigned long long :0; };
struct BFu0i_BFu9i_BFu0s { unsigned int :0; unsigned int v1:9; unsigned short :0; };
struct BFu0i_BFu9i_BFu15i { unsigned int :0; unsigned int v1:9; unsigned int v2:15; };
struct BFu0i_BFu9i_BFu15ll { unsigned int :0; unsigned int v1:9; unsigned long long v2:15; };
struct BFu0i_BFu9i_BFu15s { unsigned int :0; unsigned int v1:9; unsigned short v2:15; };
struct BFu0i_BFu9i_BFu16i { unsigned int :0; unsigned int v1:9; unsigned int v2:16; };
struct BFu0i_BFu9i_BFu16ll { unsigned int :0; unsigned int v1:9; unsigned long long v2:16; };
struct BFu0i_BFu9i_BFu16s { unsigned int :0; unsigned int v1:9; unsigned short v2:16; };
struct BFu0i_BFu9i_BFu17i { unsigned int :0; unsigned int v1:9; unsigned int v2:17; };
struct BFu0i_BFu9i_BFu17ll { unsigned int :0; unsigned int v1:9; unsigned long long v2:17; };
struct BFu0i_BFu9i_BFu1c { unsigned int :0; unsigned int v1:9; unsigned char v2:1; };
struct BFu0i_BFu9i_BFu1i { unsigned int :0; unsigned int v1:9; unsigned int v2:1; };
struct BFu0i_BFu9i_BFu1ll { unsigned int :0; unsigned int v1:9; unsigned long long v2:1; };
struct BFu0i_BFu9i_BFu1s { unsigned int :0; unsigned int v1:9; unsigned short v2:1; };
struct BFu0i_BFu9i_BFu31i { unsigned int :0; unsigned int v1:9; unsigned int v2:31; };
struct BFu0i_BFu9i_BFu31ll { unsigned int :0; unsigned int v1:9; unsigned long long v2:31; };
struct BFu0i_BFu9i_BFu32i { unsigned int :0; unsigned int v1:9; unsigned int v2:32; };
struct BFu0i_BFu9i_BFu32ll { unsigned int :0; unsigned int v1:9; unsigned long long v2:32; };
struct BFu0i_BFu9i_BFu33 { unsigned int :0; unsigned int v1:9; unsigned long long v2:33; };
struct BFu0i_BFu9i_BFu7c { unsigned int :0; unsigned int v1:9; unsigned char v2:7; };
struct BFu0i_BFu9i_BFu7i { unsigned int :0; unsigned int v1:9; unsigned int v2:7; };
struct BFu0i_BFu9i_BFu7ll { unsigned int :0; unsigned int v1:9; unsigned long long v2:7; };
struct BFu0i_BFu9i_BFu7s { unsigned int :0; unsigned int v1:9; unsigned short v2:7; };
struct BFu0i_BFu9i_BFu8c { unsigned int :0; unsigned int v1:9; unsigned char v2:8; };
struct BFu0i_BFu9i_BFu8i { unsigned int :0; unsigned int v1:9; unsigned int v2:8; };
struct BFu0i_BFu9i_BFu8ll { unsigned int :0; unsigned int v1:9; unsigned long long v2:8; };
struct BFu0i_BFu9i_BFu8s { unsigned int :0; unsigned int v1:9; unsigned short v2:8; };
struct BFu0i_BFu9i_BFu9i { unsigned int :0; unsigned int v1:9; unsigned int v2:9; };
struct BFu0i_BFu9i_BFu9ll { unsigned int :0; unsigned int v1:9; unsigned long long v2:9; };
struct BFu0i_BFu9i_BFu9s { unsigned int :0; unsigned int v1:9; unsigned short v2:9; };
struct BFu0i_BFu9i_C { unsigned int :0; unsigned int v1:9; char v2; };
struct BFu0i_BFu9i_D { unsigned int :0; unsigned int v1:9; double v2; };
struct BFu0i_BFu9i_F { unsigned int :0; unsigned int v1:9; float v2; };
struct BFu0i_BFu9i_I { unsigned int :0; unsigned int v1:9; int v2; };
struct BFu0i_BFu9i_Ip { unsigned int :0; unsigned int v1:9; int * v2; };
struct BFu0i_BFu9i_L { unsigned int :0; unsigned int v1:9; long long v2; };
struct BFu0i_BFu9i_S { unsigned int :0; unsigned int v1:9; short v2; };
struct BFu0i_BFu9i_Uc { unsigned int :0; unsigned int v1:9; unsigned char v2; };
struct BFu0i_BFu9i_Ui { unsigned int :0; unsigned int v1:9; unsigned int v2; };
struct BFu0i_BFu9i_Ul { unsigned int :0; unsigned int v1:9; unsigned long long v2; };
struct BFu0i_BFu9i_Us { unsigned int :0; unsigned int v1:9; unsigned short v2; };
struct BFu0i_BFu9i_Vp { unsigned int :0; unsigned int v1:9; void * v2; };
struct BFu0i_BFu9ll { unsigned int :0; unsigned long long v1:9; };
struct BFu0i_BFu9ll_BFu0c { unsigned int :0; unsigned long long v1:9; unsigned char :0; };
struct BFu0i_BFu9ll_BFu0i { unsigned int :0; unsigned long long v1:9; unsigned int :0; };
struct BFu0i_BFu9ll_BFu0ll { unsigned int :0; unsigned long long v1:9; unsigned long long :0; };
struct BFu0i_BFu9ll_BFu0s { unsigned int :0; unsigned long long v1:9; unsigned short :0; };
struct BFu0i_BFu9ll_BFu15i { unsigned int :0; unsigned long long v1:9; unsigned int v2:15; };
struct BFu0i_BFu9ll_BFu15ll { unsigned int :0; unsigned long long v1:9; unsigned long long v2:15; };
struct BFu0i_BFu9ll_BFu15s { unsigned int :0; unsigned long long v1:9; unsigned short v2:15; };
struct BFu0i_BFu9ll_BFu16i { unsigned int :0; unsigned long long v1:9; unsigned int v2:16; };
struct BFu0i_BFu9ll_BFu16ll { unsigned int :0; unsigned long long v1:9; unsigned long long v2:16; };
struct BFu0i_BFu9ll_BFu16s { unsigned int :0; unsigned long long v1:9; unsigned short v2:16; };
struct BFu0i_BFu9ll_BFu17i { unsigned int :0; unsigned long long v1:9; unsigned int v2:17; };
struct BFu0i_BFu9ll_BFu17ll { unsigned int :0; unsigned long long v1:9; unsigned long long v2:17; };
struct BFu0i_BFu9ll_BFu1c { unsigned int :0; unsigned long long v1:9; unsigned char v2:1; };
struct BFu0i_BFu9ll_BFu1i { unsigned int :0; unsigned long long v1:9; unsigned int v2:1; };
struct BFu0i_BFu9ll_BFu1ll { unsigned int :0; unsigned long long v1:9; unsigned long long v2:1; };
struct BFu0i_BFu9ll_BFu1s { unsigned int :0; unsigned long long v1:9; unsigned short v2:1; };
struct BFu0i_BFu9ll_BFu31i { unsigned int :0; unsigned long long v1:9; unsigned int v2:31; };
struct BFu0i_BFu9ll_BFu31ll { unsigned int :0; unsigned long long v1:9; unsigned long long v2:31; };
struct BFu0i_BFu9ll_BFu32i { unsigned int :0; unsigned long long v1:9; unsigned int v2:32; };
struct BFu0i_BFu9ll_BFu32ll { unsigned int :0; unsigned long long v1:9; unsigned long long v2:32; };
struct BFu0i_BFu9ll_BFu33 { unsigned int :0; unsigned long long v1:9; unsigned long long v2:33; };
struct BFu0i_BFu9ll_BFu7c { unsigned int :0; unsigned long long v1:9; unsigned char v2:7; };
struct BFu0i_BFu9ll_BFu7i { unsigned int :0; unsigned long long v1:9; unsigned int v2:7; };
struct BFu0i_BFu9ll_BFu7ll { unsigned int :0; unsigned long long v1:9; unsigned long long v2:7; };
struct BFu0i_BFu9ll_BFu7s { unsigned int :0; unsigned long long v1:9; unsigned short v2:7; };
struct BFu0i_BFu9ll_BFu8c { unsigned int :0; unsigned long long v1:9; unsigned char v2:8; };
struct BFu0i_BFu9ll_BFu8i { unsigned int :0; unsigned long long v1:9; unsigned int v2:8; };
struct BFu0i_BFu9ll_BFu8ll { unsigned int :0; unsigned long long v1:9; unsigned long long v2:8; };
struct BFu0i_BFu9ll_BFu8s { unsigned int :0; unsigned long long v1:9; unsigned short v2:8; };
struct BFu0i_BFu9ll_BFu9i { unsigned int :0; unsigned long long v1:9; unsigned int v2:9; };
struct BFu0i_BFu9ll_BFu9ll { unsigned int :0; unsigned long long v1:9; unsigned long long v2:9; };
struct BFu0i_BFu9ll_BFu9s { unsigned int :0; unsigned long long v1:9; unsigned short v2:9; };
struct BFu0i_BFu9ll_C { unsigned int :0; unsigned long long v1:9; char v2; };
struct BFu0i_BFu9ll_D { unsigned int :0; unsigned long long v1:9; double v2; };
struct BFu0i_BFu9ll_F { unsigned int :0; unsigned long long v1:9; float v2; };
struct BFu0i_BFu9ll_I { unsigned int :0; unsigned long long v1:9; int v2; };
struct BFu0i_BFu9ll_Ip { unsigned int :0; unsigned long long v1:9; int * v2; };
struct BFu0i_BFu9ll_L { unsigned int :0; unsigned long long v1:9; long long v2; };
struct BFu0i_BFu9ll_S { unsigned int :0; unsigned long long v1:9; short v2; };
struct BFu0i_BFu9ll_Uc { unsigned int :0; unsigned long long v1:9; unsigned char v2; };
struct BFu0i_BFu9ll_Ui { unsigned int :0; unsigned long long v1:9; unsigned int v2; };
struct BFu0i_BFu9ll_Ul { unsigned int :0; unsigned long long v1:9; unsigned long long v2; };
struct BFu0i_BFu9ll_Us { unsigned int :0; unsigned long long v1:9; unsigned short v2; };
struct BFu0i_BFu9ll_Vp { unsigned int :0; unsigned long long v1:9; void * v2; };
struct BFu0i_BFu9s { unsigned int :0; unsigned short v1:9; };
struct BFu0i_BFu9s_BFu0c { unsigned int :0; unsigned short v1:9; unsigned char :0; };
struct BFu0i_BFu9s_BFu0i { unsigned int :0; unsigned short v1:9; unsigned int :0; };
struct BFu0i_BFu9s_BFu0ll { unsigned int :0; unsigned short v1:9; unsigned long long :0; };
struct BFu0i_BFu9s_BFu0s { unsigned int :0; unsigned short v1:9; unsigned short :0; };
struct BFu0i_BFu9s_BFu15i { unsigned int :0; unsigned short v1:9; unsigned int v2:15; };
struct BFu0i_BFu9s_BFu15ll { unsigned int :0; unsigned short v1:9; unsigned long long v2:15; };
struct BFu0i_BFu9s_BFu15s { unsigned int :0; unsigned short v1:9; unsigned short v2:15; };
struct BFu0i_BFu9s_BFu16i { unsigned int :0; unsigned short v1:9; unsigned int v2:16; };
struct BFu0i_BFu9s_BFu16ll { unsigned int :0; unsigned short v1:9; unsigned long long v2:16; };
struct BFu0i_BFu9s_BFu16s { unsigned int :0; unsigned short v1:9; unsigned short v2:16; };
struct BFu0i_BFu9s_BFu17i { unsigned int :0; unsigned short v1:9; unsigned int v2:17; };
struct BFu0i_BFu9s_BFu17ll { unsigned int :0; unsigned short v1:9; unsigned long long v2:17; };
struct BFu0i_BFu9s_BFu1c { unsigned int :0; unsigned short v1:9; unsigned char v2:1; };
struct BFu0i_BFu9s_BFu1i { unsigned int :0; unsigned short v1:9; unsigned int v2:1; };
struct BFu0i_BFu9s_BFu1ll { unsigned int :0; unsigned short v1:9; unsigned long long v2:1; };
struct BFu0i_BFu9s_BFu1s { unsigned int :0; unsigned short v1:9; unsigned short v2:1; };
struct BFu0i_BFu9s_BFu31i { unsigned int :0; unsigned short v1:9; unsigned int v2:31; };
struct BFu0i_BFu9s_BFu31ll { unsigned int :0; unsigned short v1:9; unsigned long long v2:31; };
struct BFu0i_BFu9s_BFu32i { unsigned int :0; unsigned short v1:9; unsigned int v2:32; };
struct BFu0i_BFu9s_BFu32ll { unsigned int :0; unsigned short v1:9; unsigned long long v2:32; };
struct BFu0i_BFu9s_BFu33 { unsigned int :0; unsigned short v1:9; unsigned long long v2:33; };
struct BFu0i_BFu9s_BFu7c { unsigned int :0; unsigned short v1:9; unsigned char v2:7; };
struct BFu0i_BFu9s_BFu7i { unsigned int :0; unsigned short v1:9; unsigned int v2:7; };
struct BFu0i_BFu9s_BFu7ll { unsigned int :0; unsigned short v1:9; unsigned long long v2:7; };
struct BFu0i_BFu9s_BFu7s { unsigned int :0; unsigned short v1:9; unsigned short v2:7; };
struct BFu0i_BFu9s_BFu8c { unsigned int :0; unsigned short v1:9; unsigned char v2:8; };
struct BFu0i_BFu9s_BFu8i { unsigned int :0; unsigned short v1:9; unsigned int v2:8; };
struct BFu0i_BFu9s_BFu8ll { unsigned int :0; unsigned short v1:9; unsigned long long v2:8; };
struct BFu0i_BFu9s_BFu8s { unsigned int :0; unsigned short v1:9; unsigned short v2:8; };
struct BFu0i_BFu9s_BFu9i { unsigned int :0; unsigned short v1:9; unsigned int v2:9; };
struct BFu0i_BFu9s_BFu9ll { unsigned int :0; unsigned short v1:9; unsigned long long v2:9; };
struct BFu0i_BFu9s_BFu9s { unsigned int :0; unsigned short v1:9; unsigned short v2:9; };
struct BFu0i_BFu9s_C { unsigned int :0; unsigned short v1:9; char v2; };
struct BFu0i_BFu9s_D { unsigned int :0; unsigned short v1:9; double v2; };
struct BFu0i_BFu9s_F { unsigned int :0; unsigned short v1:9; float v2; };
struct BFu0i_BFu9s_I { unsigned int :0; unsigned short v1:9; int v2; };
struct BFu0i_BFu9s_Ip { unsigned int :0; unsigned short v1:9; int * v2; };
struct BFu0i_BFu9s_L { unsigned int :0; unsigned short v1:9; long long v2; };
struct BFu0i_BFu9s_S { unsigned int :0; unsigned short v1:9; short v2; };
struct BFu0i_BFu9s_Uc { unsigned int :0; unsigned short v1:9; unsigned char v2; };
struct BFu0i_BFu9s_Ui { unsigned int :0; unsigned short v1:9; unsigned int v2; };
struct BFu0i_BFu9s_Ul { unsigned int :0; unsigned short v1:9; unsigned long long v2; };
#endif // __cplusplus
#ifdef __cplusplus


static void Test_BFu0c_BFu7c_L()
{
  {
    init_simple_test("BFu0c_BFu7c_L");
    static BFu0c_BFu7c_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_L");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7c_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7c_L(Test_BFu0c_BFu7c_L, "BFu0c_BFu7c_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7c_S()
{
  {
    init_simple_test("BFu0c_BFu7c_S");
    static BFu0c_BFu7c_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_S");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7c_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7c_S(Test_BFu0c_BFu7c_S, "BFu0c_BFu7c_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7c_Uc()
{
  {
    init_simple_test("BFu0c_BFu7c_Uc");
    static BFu0c_BFu7c_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7c_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7c_Uc(Test_BFu0c_BFu7c_Uc, "BFu0c_BFu7c_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7c_Ui()
{
  {
    init_simple_test("BFu0c_BFu7c_Ui");
    static BFu0c_BFu7c_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_Ui");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7c_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7c_Ui(Test_BFu0c_BFu7c_Ui, "BFu0c_BFu7c_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7c_Ul()
{
  {
    init_simple_test("BFu0c_BFu7c_Ul");
    static BFu0c_BFu7c_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_Ul");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7c_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7c_Ul(Test_BFu0c_BFu7c_Ul, "BFu0c_BFu7c_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7c_Us()
{
  {
    init_simple_test("BFu0c_BFu7c_Us");
    static BFu0c_BFu7c_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_Us");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7c_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7c_Us(Test_BFu0c_BFu7c_Us, "BFu0c_BFu7c_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7c_Vp()
{
  {
    init_simple_test("BFu0c_BFu7c_Vp");
    static BFu0c_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_Vp");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7c_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7c_Vp(Test_BFu0c_BFu7c_Vp, "BFu0c_BFu7c_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu7i");
    static BFu0c_BFu7i lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i(Test_BFu0c_BFu7i, "BFu0c_BFu7i", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu0c");
    static BFu0c_BFu7i_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu0c(Test_BFu0c_BFu7i_BFu0c, "BFu0c_BFu7i_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu0i");
    static BFu0c_BFu7i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_BFu7i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu0i(Test_BFu0c_BFu7i_BFu0i, "BFu0c_BFu7i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu0ll");
    static BFu0c_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu0ll(Test_BFu0c_BFu7i_BFu0ll, "BFu0c_BFu7i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu0s");
    static BFu0c_BFu7i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0c_BFu7i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu0s(Test_BFu0c_BFu7i_BFu0s, "BFu0c_BFu7i_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu15i");
    static BFu0c_BFu7i_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7i_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu15i(Test_BFu0c_BFu7i_BFu15i, "BFu0c_BFu7i_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu15ll");
    static BFu0c_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7i_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu15ll(Test_BFu0c_BFu7i_BFu15ll, "BFu0c_BFu7i_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu15s");
    static BFu0c_BFu7i_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7i_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu15s(Test_BFu0c_BFu7i_BFu15s, "BFu0c_BFu7i_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu16i");
    static BFu0c_BFu7i_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7i_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu16i(Test_BFu0c_BFu7i_BFu16i, "BFu0c_BFu7i_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu16ll");
    static BFu0c_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7i_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu16ll(Test_BFu0c_BFu7i_BFu16ll, "BFu0c_BFu7i_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu16s");
    static BFu0c_BFu7i_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7i_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu16s(Test_BFu0c_BFu7i_BFu16s, "BFu0c_BFu7i_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu17i");
    static BFu0c_BFu7i_BFu17i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7i_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu17i(Test_BFu0c_BFu7i_BFu17i, "BFu0c_BFu7i_BFu17i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu17ll");
    static BFu0c_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7i_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu17ll(Test_BFu0c_BFu7i_BFu17ll, "BFu0c_BFu7i_BFu17ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu1c");
    static BFu0c_BFu7i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7i_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu1c(Test_BFu0c_BFu7i_BFu1c, "BFu0c_BFu7i_BFu1c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu1i");
    static BFu0c_BFu7i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7i_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu1i(Test_BFu0c_BFu7i_BFu1i, "BFu0c_BFu7i_BFu1i", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu1ll");
    static BFu0c_BFu7i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7i_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu1ll(Test_BFu0c_BFu7i_BFu1ll, "BFu0c_BFu7i_BFu1ll", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu1s");
    static BFu0c_BFu7i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7i_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu1s(Test_BFu0c_BFu7i_BFu1s, "BFu0c_BFu7i_BFu1s", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu31i");
    static BFu0c_BFu7i_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0c_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu7i_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu31i(Test_BFu0c_BFu7i_BFu31i, "BFu0c_BFu7i_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu31ll");
    static BFu0c_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0c_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu7i_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu31ll(Test_BFu0c_BFu7i_BFu31ll, "BFu0c_BFu7i_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu32i");
    static BFu0c_BFu7i_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0c_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu7i_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu32i(Test_BFu0c_BFu7i_BFu32i, "BFu0c_BFu7i_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu32ll");
    static BFu0c_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0c_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu7i_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu32ll(Test_BFu0c_BFu7i_BFu32ll, "BFu0c_BFu7i_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu33()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu33");
    static BFu0c_BFu7i_BFu33 lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu0c_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu0c_BFu7i_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu33(Test_BFu0c_BFu7i_BFu33, "BFu0c_BFu7i_BFu33", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu7c");
    static BFu0c_BFu7i_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu7c(Test_BFu0c_BFu7i_BFu7c, "BFu0c_BFu7i_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu7i");
    static BFu0c_BFu7i_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu7i(Test_BFu0c_BFu7i_BFu7i, "BFu0c_BFu7i_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu7ll");
    static BFu0c_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu7ll(Test_BFu0c_BFu7i_BFu7ll, "BFu0c_BFu7i_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu7s");
    static BFu0c_BFu7i_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu7s(Test_BFu0c_BFu7i_BFu7s, "BFu0c_BFu7i_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu8c");
    static BFu0c_BFu7i_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7i_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu8c(Test_BFu0c_BFu7i_BFu8c, "BFu0c_BFu7i_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu8i");
    static BFu0c_BFu7i_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7i_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu8i(Test_BFu0c_BFu7i_BFu8i, "BFu0c_BFu7i_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu8ll");
    static BFu0c_BFu7i_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7i_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu8ll(Test_BFu0c_BFu7i_BFu8ll, "BFu0c_BFu7i_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu8s");
    static BFu0c_BFu7i_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7i_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu8s(Test_BFu0c_BFu7i_BFu8s, "BFu0c_BFu7i_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu9i");
    static BFu0c_BFu7i_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7i_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu9i(Test_BFu0c_BFu7i_BFu9i, "BFu0c_BFu7i_BFu9i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu9ll");
    static BFu0c_BFu7i_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7i_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu9ll(Test_BFu0c_BFu7i_BFu9ll, "BFu0c_BFu7i_BFu9ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu9s");
    static BFu0c_BFu7i_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7i_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_BFu9s(Test_BFu0c_BFu7i_BFu9s, "BFu0c_BFu7i_BFu9s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_C()
{
  {
    init_simple_test("BFu0c_BFu7i_C");
    static BFu0c_BFu7i_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_C(Test_BFu0c_BFu7i_C, "BFu0c_BFu7i_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_D()
{
  {
    init_simple_test("BFu0c_BFu7i_D");
    static BFu0c_BFu7i_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_D");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_D(Test_BFu0c_BFu7i_D, "BFu0c_BFu7i_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_F()
{
  {
    init_simple_test("BFu0c_BFu7i_F");
    static BFu0c_BFu7i_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_F");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_F(Test_BFu0c_BFu7i_F, "BFu0c_BFu7i_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_I()
{
  {
    init_simple_test("BFu0c_BFu7i_I");
    static BFu0c_BFu7i_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_I");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_I(Test_BFu0c_BFu7i_I, "BFu0c_BFu7i_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_Ip()
{
  {
    init_simple_test("BFu0c_BFu7i_Ip");
    static BFu0c_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_Ip");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_Ip(Test_BFu0c_BFu7i_Ip, "BFu0c_BFu7i_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_L()
{
  {
    init_simple_test("BFu0c_BFu7i_L");
    static BFu0c_BFu7i_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_L");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_L(Test_BFu0c_BFu7i_L, "BFu0c_BFu7i_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_S()
{
  {
    init_simple_test("BFu0c_BFu7i_S");
    static BFu0c_BFu7i_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_S");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_S(Test_BFu0c_BFu7i_S, "BFu0c_BFu7i_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_Uc()
{
  {
    init_simple_test("BFu0c_BFu7i_Uc");
    static BFu0c_BFu7i_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_Uc(Test_BFu0c_BFu7i_Uc, "BFu0c_BFu7i_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_Ui()
{
  {
    init_simple_test("BFu0c_BFu7i_Ui");
    static BFu0c_BFu7i_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_Ui");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_Ui(Test_BFu0c_BFu7i_Ui, "BFu0c_BFu7i_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_Ul()
{
  {
    init_simple_test("BFu0c_BFu7i_Ul");
    static BFu0c_BFu7i_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_Ul");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_Ul(Test_BFu0c_BFu7i_Ul, "BFu0c_BFu7i_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_Us()
{
  {
    init_simple_test("BFu0c_BFu7i_Us");
    static BFu0c_BFu7i_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_Us");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_Us(Test_BFu0c_BFu7i_Us, "BFu0c_BFu7i_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7i_Vp()
{
  {
    init_simple_test("BFu0c_BFu7i_Vp");
    static BFu0c_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_Vp");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7i_Vp(Test_BFu0c_BFu7i_Vp, "BFu0c_BFu7i_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu7ll");
    static BFu0c_BFu7ll lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll(Test_BFu0c_BFu7ll, "BFu0c_BFu7ll", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu0c");
    static BFu0c_BFu7ll_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu0c(Test_BFu0c_BFu7ll_BFu0c, "BFu0c_BFu7ll_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu0i");
    static BFu0c_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu0i(Test_BFu0c_BFu7ll_BFu0i, "BFu0c_BFu7ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu0ll");
    static BFu0c_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu0ll(Test_BFu0c_BFu7ll_BFu0ll, "BFu0c_BFu7ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu0s");
    static BFu0c_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0c_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu0s(Test_BFu0c_BFu7ll_BFu0s, "BFu0c_BFu7ll_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu15i");
    static BFu0c_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7ll_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu15i(Test_BFu0c_BFu7ll_BFu15i, "BFu0c_BFu7ll_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu15ll");
    static BFu0c_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu15ll(Test_BFu0c_BFu7ll_BFu15ll, "BFu0c_BFu7ll_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu15s");
    static BFu0c_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7ll_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu15s(Test_BFu0c_BFu7ll_BFu15s, "BFu0c_BFu7ll_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu16i");
    static BFu0c_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7ll_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu16i(Test_BFu0c_BFu7ll_BFu16i, "BFu0c_BFu7ll_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu16ll");
    static BFu0c_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu16ll(Test_BFu0c_BFu7ll_BFu16ll, "BFu0c_BFu7ll_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu16s");
    static BFu0c_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7ll_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu16s(Test_BFu0c_BFu7ll_BFu16s, "BFu0c_BFu7ll_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu17i");
    static BFu0c_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7ll_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu17i(Test_BFu0c_BFu7ll_BFu17i, "BFu0c_BFu7ll_BFu17i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu17ll");
    static BFu0c_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu17ll(Test_BFu0c_BFu7ll_BFu17ll, "BFu0c_BFu7ll_BFu17ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu1c");
    static BFu0c_BFu7ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7ll_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu1c(Test_BFu0c_BFu7ll_BFu1c, "BFu0c_BFu7ll_BFu1c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu1i");
    static BFu0c_BFu7ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7ll_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu1i(Test_BFu0c_BFu7ll_BFu1i, "BFu0c_BFu7ll_BFu1i", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu1ll");
    static BFu0c_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu1ll(Test_BFu0c_BFu7ll_BFu1ll, "BFu0c_BFu7ll_BFu1ll", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu1s");
    static BFu0c_BFu7ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7ll_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu1s(Test_BFu0c_BFu7ll_BFu1s, "BFu0c_BFu7ll_BFu1s", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu31i");
    static BFu0c_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0c_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu7ll_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu31i(Test_BFu0c_BFu7ll_BFu31i, "BFu0c_BFu7ll_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu31ll");
    static BFu0c_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0c_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu7ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu31ll(Test_BFu0c_BFu7ll_BFu31ll, "BFu0c_BFu7ll_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu32i");
    static BFu0c_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0c_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu7ll_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu32i(Test_BFu0c_BFu7ll_BFu32i, "BFu0c_BFu7ll_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu32ll");
    static BFu0c_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0c_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu7ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu32ll(Test_BFu0c_BFu7ll_BFu32ll, "BFu0c_BFu7ll_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu33()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu33");
    static BFu0c_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu0c_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu0c_BFu7ll_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu33(Test_BFu0c_BFu7ll_BFu33, "BFu0c_BFu7ll_BFu33", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu7c");
    static BFu0c_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu7c(Test_BFu0c_BFu7ll_BFu7c, "BFu0c_BFu7ll_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu7i");
    static BFu0c_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu7i(Test_BFu0c_BFu7ll_BFu7i, "BFu0c_BFu7ll_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu7ll");
    static BFu0c_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu7ll(Test_BFu0c_BFu7ll_BFu7ll, "BFu0c_BFu7ll_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu7s");
    static BFu0c_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu7s(Test_BFu0c_BFu7ll_BFu7s, "BFu0c_BFu7ll_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu8c");
    static BFu0c_BFu7ll_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7ll_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu8c(Test_BFu0c_BFu7ll_BFu8c, "BFu0c_BFu7ll_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu8i");
    static BFu0c_BFu7ll_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7ll_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu8i(Test_BFu0c_BFu7ll_BFu8i, "BFu0c_BFu7ll_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu8ll");
    static BFu0c_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu8ll(Test_BFu0c_BFu7ll_BFu8ll, "BFu0c_BFu7ll_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu8s");
    static BFu0c_BFu7ll_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7ll_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu8s(Test_BFu0c_BFu7ll_BFu8s, "BFu0c_BFu7ll_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu9i");
    static BFu0c_BFu7ll_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7ll_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu9i(Test_BFu0c_BFu7ll_BFu9i, "BFu0c_BFu7ll_BFu9i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu9ll");
    static BFu0c_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu9ll(Test_BFu0c_BFu7ll_BFu9ll, "BFu0c_BFu7ll_BFu9ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu9s");
    static BFu0c_BFu7ll_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7ll_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_BFu9s(Test_BFu0c_BFu7ll_BFu9s, "BFu0c_BFu7ll_BFu9s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_C()
{
  {
    init_simple_test("BFu0c_BFu7ll_C");
    static BFu0c_BFu7ll_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_C(Test_BFu0c_BFu7ll_C, "BFu0c_BFu7ll_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_D()
{
  {
    init_simple_test("BFu0c_BFu7ll_D");
    static BFu0c_BFu7ll_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_D");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_D(Test_BFu0c_BFu7ll_D, "BFu0c_BFu7ll_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_F()
{
  {
    init_simple_test("BFu0c_BFu7ll_F");
    static BFu0c_BFu7ll_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_F");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_F(Test_BFu0c_BFu7ll_F, "BFu0c_BFu7ll_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_I()
{
  {
    init_simple_test("BFu0c_BFu7ll_I");
    static BFu0c_BFu7ll_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_I");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_I(Test_BFu0c_BFu7ll_I, "BFu0c_BFu7ll_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_Ip()
{
  {
    init_simple_test("BFu0c_BFu7ll_Ip");
    static BFu0c_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_Ip");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_Ip(Test_BFu0c_BFu7ll_Ip, "BFu0c_BFu7ll_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_L()
{
  {
    init_simple_test("BFu0c_BFu7ll_L");
    static BFu0c_BFu7ll_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_L");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_L(Test_BFu0c_BFu7ll_L, "BFu0c_BFu7ll_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_S()
{
  {
    init_simple_test("BFu0c_BFu7ll_S");
    static BFu0c_BFu7ll_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_S");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_S(Test_BFu0c_BFu7ll_S, "BFu0c_BFu7ll_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_Uc()
{
  {
    init_simple_test("BFu0c_BFu7ll_Uc");
    static BFu0c_BFu7ll_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_Uc(Test_BFu0c_BFu7ll_Uc, "BFu0c_BFu7ll_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_Ui()
{
  {
    init_simple_test("BFu0c_BFu7ll_Ui");
    static BFu0c_BFu7ll_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_Ui");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_Ui(Test_BFu0c_BFu7ll_Ui, "BFu0c_BFu7ll_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_Ul()
{
  {
    init_simple_test("BFu0c_BFu7ll_Ul");
    static BFu0c_BFu7ll_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_Ul");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_Ul(Test_BFu0c_BFu7ll_Ul, "BFu0c_BFu7ll_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_Us()
{
  {
    init_simple_test("BFu0c_BFu7ll_Us");
    static BFu0c_BFu7ll_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_Us");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_Us(Test_BFu0c_BFu7ll_Us, "BFu0c_BFu7ll_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7ll_Vp()
{
  {
    init_simple_test("BFu0c_BFu7ll_Vp");
    static BFu0c_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_Vp");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7ll_Vp(Test_BFu0c_BFu7ll_Vp, "BFu0c_BFu7ll_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu7s");
    static BFu0c_BFu7s lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s(Test_BFu0c_BFu7s, "BFu0c_BFu7s", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu0c");
    static BFu0c_BFu7s_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu0c(Test_BFu0c_BFu7s_BFu0c, "BFu0c_BFu7s_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu0i");
    static BFu0c_BFu7s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_BFu7s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu0i(Test_BFu0c_BFu7s_BFu0i, "BFu0c_BFu7s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu0ll");
    static BFu0c_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu0ll(Test_BFu0c_BFu7s_BFu0ll, "BFu0c_BFu7s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu0s");
    static BFu0c_BFu7s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0c_BFu7s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu0s(Test_BFu0c_BFu7s_BFu0s, "BFu0c_BFu7s_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu15i");
    static BFu0c_BFu7s_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7s_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu15i(Test_BFu0c_BFu7s_BFu15i, "BFu0c_BFu7s_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu15ll");
    static BFu0c_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7s_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu15ll(Test_BFu0c_BFu7s_BFu15ll, "BFu0c_BFu7s_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu15s");
    static BFu0c_BFu7s_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7s_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu15s(Test_BFu0c_BFu7s_BFu15s, "BFu0c_BFu7s_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu16i");
    static BFu0c_BFu7s_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7s_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu16i(Test_BFu0c_BFu7s_BFu16i, "BFu0c_BFu7s_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu16ll");
    static BFu0c_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7s_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu16ll(Test_BFu0c_BFu7s_BFu16ll, "BFu0c_BFu7s_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu16s");
    static BFu0c_BFu7s_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7s_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu16s(Test_BFu0c_BFu7s_BFu16s, "BFu0c_BFu7s_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu17i");
    static BFu0c_BFu7s_BFu17i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7s_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu17i(Test_BFu0c_BFu7s_BFu17i, "BFu0c_BFu7s_BFu17i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu17ll");
    static BFu0c_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7s_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu17ll(Test_BFu0c_BFu7s_BFu17ll, "BFu0c_BFu7s_BFu17ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu1c");
    static BFu0c_BFu7s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7s_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu1c(Test_BFu0c_BFu7s_BFu1c, "BFu0c_BFu7s_BFu1c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu1i");
    static BFu0c_BFu7s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7s_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu1i(Test_BFu0c_BFu7s_BFu1i, "BFu0c_BFu7s_BFu1i", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu1ll");
    static BFu0c_BFu7s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7s_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu1ll(Test_BFu0c_BFu7s_BFu1ll, "BFu0c_BFu7s_BFu1ll", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu1s");
    static BFu0c_BFu7s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7s_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu1s(Test_BFu0c_BFu7s_BFu1s, "BFu0c_BFu7s_BFu1s", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu31i");
    static BFu0c_BFu7s_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0c_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu7s_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu31i(Test_BFu0c_BFu7s_BFu31i, "BFu0c_BFu7s_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu31ll");
    static BFu0c_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0c_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu7s_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu31ll(Test_BFu0c_BFu7s_BFu31ll, "BFu0c_BFu7s_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu32i");
    static BFu0c_BFu7s_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0c_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu7s_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu32i(Test_BFu0c_BFu7s_BFu32i, "BFu0c_BFu7s_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu32ll");
    static BFu0c_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0c_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu7s_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu32ll(Test_BFu0c_BFu7s_BFu32ll, "BFu0c_BFu7s_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu33()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu33");
    static BFu0c_BFu7s_BFu33 lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu0c_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu0c_BFu7s_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu33(Test_BFu0c_BFu7s_BFu33, "BFu0c_BFu7s_BFu33", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu7c");
    static BFu0c_BFu7s_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu7c(Test_BFu0c_BFu7s_BFu7c, "BFu0c_BFu7s_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu7i");
    static BFu0c_BFu7s_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu7i(Test_BFu0c_BFu7s_BFu7i, "BFu0c_BFu7s_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu7ll");
    static BFu0c_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu7ll(Test_BFu0c_BFu7s_BFu7ll, "BFu0c_BFu7s_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu7s");
    static BFu0c_BFu7s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu7s(Test_BFu0c_BFu7s_BFu7s, "BFu0c_BFu7s_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu8c");
    static BFu0c_BFu7s_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7s_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu8c(Test_BFu0c_BFu7s_BFu8c, "BFu0c_BFu7s_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu8i");
    static BFu0c_BFu7s_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7s_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu8i(Test_BFu0c_BFu7s_BFu8i, "BFu0c_BFu7s_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu8ll");
    static BFu0c_BFu7s_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7s_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu8ll(Test_BFu0c_BFu7s_BFu8ll, "BFu0c_BFu7s_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu8s");
    static BFu0c_BFu7s_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7s_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu8s(Test_BFu0c_BFu7s_BFu8s, "BFu0c_BFu7s_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu9i");
    static BFu0c_BFu7s_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7s_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu9i(Test_BFu0c_BFu7s_BFu9i, "BFu0c_BFu7s_BFu9i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu9ll");
    static BFu0c_BFu7s_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7s_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu9ll(Test_BFu0c_BFu7s_BFu9ll, "BFu0c_BFu7s_BFu9ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu9s");
    static BFu0c_BFu7s_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7s_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_BFu9s(Test_BFu0c_BFu7s_BFu9s, "BFu0c_BFu7s_BFu9s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_C()
{
  {
    init_simple_test("BFu0c_BFu7s_C");
    static BFu0c_BFu7s_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_C(Test_BFu0c_BFu7s_C, "BFu0c_BFu7s_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_D()
{
  {
    init_simple_test("BFu0c_BFu7s_D");
    static BFu0c_BFu7s_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_D");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_D(Test_BFu0c_BFu7s_D, "BFu0c_BFu7s_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_F()
{
  {
    init_simple_test("BFu0c_BFu7s_F");
    static BFu0c_BFu7s_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_F");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_F(Test_BFu0c_BFu7s_F, "BFu0c_BFu7s_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_I()
{
  {
    init_simple_test("BFu0c_BFu7s_I");
    static BFu0c_BFu7s_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_I");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_I(Test_BFu0c_BFu7s_I, "BFu0c_BFu7s_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_Ip()
{
  {
    init_simple_test("BFu0c_BFu7s_Ip");
    static BFu0c_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_Ip");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_Ip(Test_BFu0c_BFu7s_Ip, "BFu0c_BFu7s_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_L()
{
  {
    init_simple_test("BFu0c_BFu7s_L");
    static BFu0c_BFu7s_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu7s_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_L");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_L(Test_BFu0c_BFu7s_L, "BFu0c_BFu7s_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_S()
{
  {
    init_simple_test("BFu0c_BFu7s_S");
    static BFu0c_BFu7s_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7s_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_S");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_S(Test_BFu0c_BFu7s_S, "BFu0c_BFu7s_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_Uc()
{
  {
    init_simple_test("BFu0c_BFu7s_Uc");
    static BFu0c_BFu7s_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_Uc(Test_BFu0c_BFu7s_Uc, "BFu0c_BFu7s_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_Ui()
{
  {
    init_simple_test("BFu0c_BFu7s_Ui");
    static BFu0c_BFu7s_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu7s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_Ui");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_Ui(Test_BFu0c_BFu7s_Ui, "BFu0c_BFu7s_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_Ul()
{
  {
    init_simple_test("BFu0c_BFu7s_Ul");
    static BFu0c_BFu7s_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu7s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_Ul");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_Ul(Test_BFu0c_BFu7s_Ul, "BFu0c_BFu7s_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_Us()
{
  {
    init_simple_test("BFu0c_BFu7s_Us");
    static BFu0c_BFu7s_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu7s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_Us");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_Us(Test_BFu0c_BFu7s_Us, "BFu0c_BFu7s_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu7s_Vp()
{
  {
    init_simple_test("BFu0c_BFu7s_Vp");
    static BFu0c_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu7s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_Vp");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu7s_Vp(Test_BFu0c_BFu7s_Vp, "BFu0c_BFu7s_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu8c");
    static BFu0c_BFu8c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c(Test_BFu0c_BFu8c, "BFu0c_BFu8c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu0c");
    static BFu0c_BFu8c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu0c(Test_BFu0c_BFu8c_BFu0c, "BFu0c_BFu8c_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu0i");
    static BFu0c_BFu8c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_BFu8c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu0i(Test_BFu0c_BFu8c_BFu0i, "BFu0c_BFu8c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu0ll");
    static BFu0c_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu0ll(Test_BFu0c_BFu8c_BFu0ll, "BFu0c_BFu8c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu0s");
    static BFu0c_BFu8c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0c_BFu8c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu0s(Test_BFu0c_BFu8c_BFu0s, "BFu0c_BFu8c_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu15i");
    static BFu0c_BFu8c_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8c_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu15i(Test_BFu0c_BFu8c_BFu15i, "BFu0c_BFu8c_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu15ll");
    static BFu0c_BFu8c_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8c_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu15ll(Test_BFu0c_BFu8c_BFu15ll, "BFu0c_BFu8c_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu15s");
    static BFu0c_BFu8c_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8c_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu15s(Test_BFu0c_BFu8c_BFu15s, "BFu0c_BFu8c_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu16i");
    static BFu0c_BFu8c_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8c_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu16i(Test_BFu0c_BFu8c_BFu16i, "BFu0c_BFu8c_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu16ll");
    static BFu0c_BFu8c_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8c_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu16ll(Test_BFu0c_BFu8c_BFu16ll, "BFu0c_BFu8c_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu16s");
    static BFu0c_BFu8c_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8c_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu16s(Test_BFu0c_BFu8c_BFu16s, "BFu0c_BFu8c_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu17i");
    static BFu0c_BFu8c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8c_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu17i(Test_BFu0c_BFu8c_BFu17i, "BFu0c_BFu8c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu17ll");
    static BFu0c_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8c_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu17ll(Test_BFu0c_BFu8c_BFu17ll, "BFu0c_BFu8c_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu1c");
    static BFu0c_BFu8c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8c_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu1c(Test_BFu0c_BFu8c_BFu1c, "BFu0c_BFu8c_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu1i");
    static BFu0c_BFu8c_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8c_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu1i(Test_BFu0c_BFu8c_BFu1i, "BFu0c_BFu8c_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu1ll");
    static BFu0c_BFu8c_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8c_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu1ll(Test_BFu0c_BFu8c_BFu1ll, "BFu0c_BFu8c_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu1s");
    static BFu0c_BFu8c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8c_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu1s(Test_BFu0c_BFu8c_BFu1s, "BFu0c_BFu8c_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu31i");
    static BFu0c_BFu8c_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8c_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu31i(Test_BFu0c_BFu8c_BFu31i, "BFu0c_BFu8c_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu31ll");
    static BFu0c_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8c_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu31ll(Test_BFu0c_BFu8c_BFu31ll, "BFu0c_BFu8c_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu32i");
    static BFu0c_BFu8c_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8c_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu32i(Test_BFu0c_BFu8c_BFu32i, "BFu0c_BFu8c_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu32ll");
    static BFu0c_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8c_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu32ll(Test_BFu0c_BFu8c_BFu32ll, "BFu0c_BFu8c_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu33()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu33");
    static BFu0c_BFu8c_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0c_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu8c_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu33(Test_BFu0c_BFu8c_BFu33, "BFu0c_BFu8c_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu7c");
    static BFu0c_BFu8c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8c_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu7c(Test_BFu0c_BFu8c_BFu7c, "BFu0c_BFu8c_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu7i");
    static BFu0c_BFu8c_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8c_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu7i(Test_BFu0c_BFu8c_BFu7i, "BFu0c_BFu8c_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu7ll");
    static BFu0c_BFu8c_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8c_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu7ll(Test_BFu0c_BFu8c_BFu7ll, "BFu0c_BFu8c_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu7s");
    static BFu0c_BFu8c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8c_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu7s(Test_BFu0c_BFu8c_BFu7s, "BFu0c_BFu8c_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu8c");
    static BFu0c_BFu8c_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu8c(Test_BFu0c_BFu8c_BFu8c, "BFu0c_BFu8c_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu8i");
    static BFu0c_BFu8c_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu8i(Test_BFu0c_BFu8c_BFu8i, "BFu0c_BFu8c_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu8ll");
    static BFu0c_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu8ll(Test_BFu0c_BFu8c_BFu8ll, "BFu0c_BFu8c_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu8s");
    static BFu0c_BFu8c_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu8s(Test_BFu0c_BFu8c_BFu8s, "BFu0c_BFu8c_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu9i");
    static BFu0c_BFu8c_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8c_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu9i(Test_BFu0c_BFu8c_BFu9i, "BFu0c_BFu8c_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu9ll");
    static BFu0c_BFu8c_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8c_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu9ll(Test_BFu0c_BFu8c_BFu9ll, "BFu0c_BFu8c_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu9s");
    static BFu0c_BFu8c_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8c_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_BFu9s(Test_BFu0c_BFu8c_BFu9s, "BFu0c_BFu8c_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_C()
{
  {
    init_simple_test("BFu0c_BFu8c_C");
    static BFu0c_BFu8c_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_C(Test_BFu0c_BFu8c_C, "BFu0c_BFu8c_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_D()
{
  {
    init_simple_test("BFu0c_BFu8c_D");
    static BFu0c_BFu8c_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu8c_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_D");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_D(Test_BFu0c_BFu8c_D, "BFu0c_BFu8c_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_F()
{
  {
    init_simple_test("BFu0c_BFu8c_F");
    static BFu0c_BFu8c_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8c_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_F");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_F(Test_BFu0c_BFu8c_F, "BFu0c_BFu8c_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_I()
{
  {
    init_simple_test("BFu0c_BFu8c_I");
    static BFu0c_BFu8c_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8c_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_I");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_I(Test_BFu0c_BFu8c_I, "BFu0c_BFu8c_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_Ip()
{
  {
    init_simple_test("BFu0c_BFu8c_Ip");
    static BFu0c_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu8c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_Ip");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_Ip(Test_BFu0c_BFu8c_Ip, "BFu0c_BFu8c_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_L()
{
  {
    init_simple_test("BFu0c_BFu8c_L");
    static BFu0c_BFu8c_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu8c_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_L");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_L(Test_BFu0c_BFu8c_L, "BFu0c_BFu8c_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_S()
{
  {
    init_simple_test("BFu0c_BFu8c_S");
    static BFu0c_BFu8c_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8c_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_S");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_S(Test_BFu0c_BFu8c_S, "BFu0c_BFu8c_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_Uc()
{
  {
    init_simple_test("BFu0c_BFu8c_Uc");
    static BFu0c_BFu8c_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_Uc(Test_BFu0c_BFu8c_Uc, "BFu0c_BFu8c_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_Ui()
{
  {
    init_simple_test("BFu0c_BFu8c_Ui");
    static BFu0c_BFu8c_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_Ui");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_Ui(Test_BFu0c_BFu8c_Ui, "BFu0c_BFu8c_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_Ul()
{
  {
    init_simple_test("BFu0c_BFu8c_Ul");
    static BFu0c_BFu8c_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu8c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_Ul");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_Ul(Test_BFu0c_BFu8c_Ul, "BFu0c_BFu8c_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_Us()
{
  {
    init_simple_test("BFu0c_BFu8c_Us");
    static BFu0c_BFu8c_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_Us");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_Us(Test_BFu0c_BFu8c_Us, "BFu0c_BFu8c_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8c_Vp()
{
  {
    init_simple_test("BFu0c_BFu8c_Vp");
    static BFu0c_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu8c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_Vp");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8c_Vp(Test_BFu0c_BFu8c_Vp, "BFu0c_BFu8c_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu8i");
    static BFu0c_BFu8i lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i(Test_BFu0c_BFu8i, "BFu0c_BFu8i", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu0c");
    static BFu0c_BFu8i_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu0c(Test_BFu0c_BFu8i_BFu0c, "BFu0c_BFu8i_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu0i");
    static BFu0c_BFu8i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_BFu8i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu0i(Test_BFu0c_BFu8i_BFu0i, "BFu0c_BFu8i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu0ll");
    static BFu0c_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu0ll(Test_BFu0c_BFu8i_BFu0ll, "BFu0c_BFu8i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu0s");
    static BFu0c_BFu8i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0c_BFu8i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu0s(Test_BFu0c_BFu8i_BFu0s, "BFu0c_BFu8i_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu15i");
    static BFu0c_BFu8i_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8i_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu15i(Test_BFu0c_BFu8i_BFu15i, "BFu0c_BFu8i_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu15ll");
    static BFu0c_BFu8i_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8i_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu15ll(Test_BFu0c_BFu8i_BFu15ll, "BFu0c_BFu8i_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu15s");
    static BFu0c_BFu8i_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8i_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu15s(Test_BFu0c_BFu8i_BFu15s, "BFu0c_BFu8i_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu16i");
    static BFu0c_BFu8i_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8i_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu16i(Test_BFu0c_BFu8i_BFu16i, "BFu0c_BFu8i_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu16ll");
    static BFu0c_BFu8i_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8i_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu16ll(Test_BFu0c_BFu8i_BFu16ll, "BFu0c_BFu8i_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu16s");
    static BFu0c_BFu8i_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8i_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu16s(Test_BFu0c_BFu8i_BFu16s, "BFu0c_BFu8i_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu17i");
    static BFu0c_BFu8i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8i_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu17i(Test_BFu0c_BFu8i_BFu17i, "BFu0c_BFu8i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu17ll");
    static BFu0c_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8i_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu17ll(Test_BFu0c_BFu8i_BFu17ll, "BFu0c_BFu8i_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu1c");
    static BFu0c_BFu8i_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8i_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu1c(Test_BFu0c_BFu8i_BFu1c, "BFu0c_BFu8i_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu1i");
    static BFu0c_BFu8i_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8i_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu1i(Test_BFu0c_BFu8i_BFu1i, "BFu0c_BFu8i_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu1ll");
    static BFu0c_BFu8i_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8i_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu1ll(Test_BFu0c_BFu8i_BFu1ll, "BFu0c_BFu8i_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu1s");
    static BFu0c_BFu8i_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8i_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu1s(Test_BFu0c_BFu8i_BFu1s, "BFu0c_BFu8i_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu31i");
    static BFu0c_BFu8i_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8i_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu31i(Test_BFu0c_BFu8i_BFu31i, "BFu0c_BFu8i_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu31ll");
    static BFu0c_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8i_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu31ll(Test_BFu0c_BFu8i_BFu31ll, "BFu0c_BFu8i_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu32i");
    static BFu0c_BFu8i_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8i_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu32i(Test_BFu0c_BFu8i_BFu32i, "BFu0c_BFu8i_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu32ll");
    static BFu0c_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8i_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu32ll(Test_BFu0c_BFu8i_BFu32ll, "BFu0c_BFu8i_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu33()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu33");
    static BFu0c_BFu8i_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu8i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0c_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu8i_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu33(Test_BFu0c_BFu8i_BFu33, "BFu0c_BFu8i_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu7c");
    static BFu0c_BFu8i_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8i_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu7c(Test_BFu0c_BFu8i_BFu7c, "BFu0c_BFu8i_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu7i");
    static BFu0c_BFu8i_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8i_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu7i(Test_BFu0c_BFu8i_BFu7i, "BFu0c_BFu8i_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu7ll");
    static BFu0c_BFu8i_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8i_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu7ll(Test_BFu0c_BFu8i_BFu7ll, "BFu0c_BFu8i_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu7s");
    static BFu0c_BFu8i_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8i_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu7s(Test_BFu0c_BFu8i_BFu7s, "BFu0c_BFu8i_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu8c");
    static BFu0c_BFu8i_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu8c(Test_BFu0c_BFu8i_BFu8c, "BFu0c_BFu8i_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu8i");
    static BFu0c_BFu8i_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu8i(Test_BFu0c_BFu8i_BFu8i, "BFu0c_BFu8i_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu8ll");
    static BFu0c_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu8ll(Test_BFu0c_BFu8i_BFu8ll, "BFu0c_BFu8i_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu8s");
    static BFu0c_BFu8i_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu8s(Test_BFu0c_BFu8i_BFu8s, "BFu0c_BFu8i_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu9i");
    static BFu0c_BFu8i_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8i_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu9i(Test_BFu0c_BFu8i_BFu9i, "BFu0c_BFu8i_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu9ll");
    static BFu0c_BFu8i_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8i_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu9ll(Test_BFu0c_BFu8i_BFu9ll, "BFu0c_BFu8i_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu9s");
    static BFu0c_BFu8i_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8i_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_BFu9s(Test_BFu0c_BFu8i_BFu9s, "BFu0c_BFu8i_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_C()
{
  {
    init_simple_test("BFu0c_BFu8i_C");
    static BFu0c_BFu8i_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_C(Test_BFu0c_BFu8i_C, "BFu0c_BFu8i_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_D()
{
  {
    init_simple_test("BFu0c_BFu8i_D");
    static BFu0c_BFu8i_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu8i_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_D");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_D(Test_BFu0c_BFu8i_D, "BFu0c_BFu8i_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_F()
{
  {
    init_simple_test("BFu0c_BFu8i_F");
    static BFu0c_BFu8i_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8i_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_F");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_F(Test_BFu0c_BFu8i_F, "BFu0c_BFu8i_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_I()
{
  {
    init_simple_test("BFu0c_BFu8i_I");
    static BFu0c_BFu8i_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8i_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_I");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_I(Test_BFu0c_BFu8i_I, "BFu0c_BFu8i_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_Ip()
{
  {
    init_simple_test("BFu0c_BFu8i_Ip");
    static BFu0c_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu8i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_Ip");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_Ip(Test_BFu0c_BFu8i_Ip, "BFu0c_BFu8i_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_L()
{
  {
    init_simple_test("BFu0c_BFu8i_L");
    static BFu0c_BFu8i_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu8i_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_L");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_L(Test_BFu0c_BFu8i_L, "BFu0c_BFu8i_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_S()
{
  {
    init_simple_test("BFu0c_BFu8i_S");
    static BFu0c_BFu8i_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8i_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_S");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_S(Test_BFu0c_BFu8i_S, "BFu0c_BFu8i_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_Uc()
{
  {
    init_simple_test("BFu0c_BFu8i_Uc");
    static BFu0c_BFu8i_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_Uc(Test_BFu0c_BFu8i_Uc, "BFu0c_BFu8i_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_Ui()
{
  {
    init_simple_test("BFu0c_BFu8i_Ui");
    static BFu0c_BFu8i_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_Ui");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_Ui(Test_BFu0c_BFu8i_Ui, "BFu0c_BFu8i_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_Ul()
{
  {
    init_simple_test("BFu0c_BFu8i_Ul");
    static BFu0c_BFu8i_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu8i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_Ul");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_Ul(Test_BFu0c_BFu8i_Ul, "BFu0c_BFu8i_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_Us()
{
  {
    init_simple_test("BFu0c_BFu8i_Us");
    static BFu0c_BFu8i_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_Us");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_Us(Test_BFu0c_BFu8i_Us, "BFu0c_BFu8i_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8i_Vp()
{
  {
    init_simple_test("BFu0c_BFu8i_Vp");
    static BFu0c_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu8i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_Vp");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8i_Vp(Test_BFu0c_BFu8i_Vp, "BFu0c_BFu8i_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu8ll");
    static BFu0c_BFu8ll lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll(Test_BFu0c_BFu8ll, "BFu0c_BFu8ll", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu0c");
    static BFu0c_BFu8ll_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu0c(Test_BFu0c_BFu8ll_BFu0c, "BFu0c_BFu8ll_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu0i");
    static BFu0c_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu0i(Test_BFu0c_BFu8ll_BFu0i, "BFu0c_BFu8ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu0ll");
    static BFu0c_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu0ll(Test_BFu0c_BFu8ll_BFu0ll, "BFu0c_BFu8ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu0s");
    static BFu0c_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0c_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu0s(Test_BFu0c_BFu8ll_BFu0s, "BFu0c_BFu8ll_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu15i");
    static BFu0c_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8ll_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu15i(Test_BFu0c_BFu8ll_BFu15i, "BFu0c_BFu8ll_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu15ll");
    static BFu0c_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu15ll(Test_BFu0c_BFu8ll_BFu15ll, "BFu0c_BFu8ll_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu15s");
    static BFu0c_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8ll_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu15s(Test_BFu0c_BFu8ll_BFu15s, "BFu0c_BFu8ll_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu16i");
    static BFu0c_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8ll_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu16i(Test_BFu0c_BFu8ll_BFu16i, "BFu0c_BFu8ll_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu16ll");
    static BFu0c_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu16ll(Test_BFu0c_BFu8ll_BFu16ll, "BFu0c_BFu8ll_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu16s");
    static BFu0c_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8ll_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu16s(Test_BFu0c_BFu8ll_BFu16s, "BFu0c_BFu8ll_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu17i");
    static BFu0c_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8ll_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu17i(Test_BFu0c_BFu8ll_BFu17i, "BFu0c_BFu8ll_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu17ll");
    static BFu0c_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu17ll(Test_BFu0c_BFu8ll_BFu17ll, "BFu0c_BFu8ll_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu1c");
    static BFu0c_BFu8ll_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8ll_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu1c(Test_BFu0c_BFu8ll_BFu1c, "BFu0c_BFu8ll_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu1i");
    static BFu0c_BFu8ll_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8ll_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu1i(Test_BFu0c_BFu8ll_BFu1i, "BFu0c_BFu8ll_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu1ll");
    static BFu0c_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu1ll(Test_BFu0c_BFu8ll_BFu1ll, "BFu0c_BFu8ll_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu1s");
    static BFu0c_BFu8ll_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8ll_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu1s(Test_BFu0c_BFu8ll_BFu1s, "BFu0c_BFu8ll_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu31i");
    static BFu0c_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8ll_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu31i(Test_BFu0c_BFu8ll_BFu31i, "BFu0c_BFu8ll_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu31ll");
    static BFu0c_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu31ll(Test_BFu0c_BFu8ll_BFu31ll, "BFu0c_BFu8ll_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu32i");
    static BFu0c_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8ll_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu32i(Test_BFu0c_BFu8ll_BFu32i, "BFu0c_BFu8ll_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu32ll");
    static BFu0c_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu32ll(Test_BFu0c_BFu8ll_BFu32ll, "BFu0c_BFu8ll_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu33()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu33");
    static BFu0c_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu8ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0c_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu8ll_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu33(Test_BFu0c_BFu8ll_BFu33, "BFu0c_BFu8ll_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu7c");
    static BFu0c_BFu8ll_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8ll_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu7c(Test_BFu0c_BFu8ll_BFu7c, "BFu0c_BFu8ll_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu7i");
    static BFu0c_BFu8ll_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8ll_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu7i(Test_BFu0c_BFu8ll_BFu7i, "BFu0c_BFu8ll_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu7ll");
    static BFu0c_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu7ll(Test_BFu0c_BFu8ll_BFu7ll, "BFu0c_BFu8ll_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu7s");
    static BFu0c_BFu8ll_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8ll_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu7s(Test_BFu0c_BFu8ll_BFu7s, "BFu0c_BFu8ll_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu8c");
    static BFu0c_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu8c(Test_BFu0c_BFu8ll_BFu8c, "BFu0c_BFu8ll_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu8i");
    static BFu0c_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu8i(Test_BFu0c_BFu8ll_BFu8i, "BFu0c_BFu8ll_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu8ll");
    static BFu0c_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu8ll(Test_BFu0c_BFu8ll_BFu8ll, "BFu0c_BFu8ll_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu8s");
    static BFu0c_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu8s(Test_BFu0c_BFu8ll_BFu8s, "BFu0c_BFu8ll_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu9i");
    static BFu0c_BFu8ll_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8ll_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu9i(Test_BFu0c_BFu8ll_BFu9i, "BFu0c_BFu8ll_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu9ll");
    static BFu0c_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu9ll(Test_BFu0c_BFu8ll_BFu9ll, "BFu0c_BFu8ll_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu9s");
    static BFu0c_BFu8ll_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8ll_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_BFu9s(Test_BFu0c_BFu8ll_BFu9s, "BFu0c_BFu8ll_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_C()
{
  {
    init_simple_test("BFu0c_BFu8ll_C");
    static BFu0c_BFu8ll_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_C(Test_BFu0c_BFu8ll_C, "BFu0c_BFu8ll_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_D()
{
  {
    init_simple_test("BFu0c_BFu8ll_D");
    static BFu0c_BFu8ll_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu8ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_D");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_D(Test_BFu0c_BFu8ll_D, "BFu0c_BFu8ll_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_F()
{
  {
    init_simple_test("BFu0c_BFu8ll_F");
    static BFu0c_BFu8ll_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_F");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_F(Test_BFu0c_BFu8ll_F, "BFu0c_BFu8ll_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_I()
{
  {
    init_simple_test("BFu0c_BFu8ll_I");
    static BFu0c_BFu8ll_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_I");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_I(Test_BFu0c_BFu8ll_I, "BFu0c_BFu8ll_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_Ip()
{
  {
    init_simple_test("BFu0c_BFu8ll_Ip");
    static BFu0c_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_Ip");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_Ip(Test_BFu0c_BFu8ll_Ip, "BFu0c_BFu8ll_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_L()
{
  {
    init_simple_test("BFu0c_BFu8ll_L");
    static BFu0c_BFu8ll_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_L");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_L(Test_BFu0c_BFu8ll_L, "BFu0c_BFu8ll_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_S()
{
  {
    init_simple_test("BFu0c_BFu8ll_S");
    static BFu0c_BFu8ll_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_S");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_S(Test_BFu0c_BFu8ll_S, "BFu0c_BFu8ll_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_Uc()
{
  {
    init_simple_test("BFu0c_BFu8ll_Uc");
    static BFu0c_BFu8ll_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_Uc(Test_BFu0c_BFu8ll_Uc, "BFu0c_BFu8ll_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_Ui()
{
  {
    init_simple_test("BFu0c_BFu8ll_Ui");
    static BFu0c_BFu8ll_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_Ui");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_Ui(Test_BFu0c_BFu8ll_Ui, "BFu0c_BFu8ll_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_Ul()
{
  {
    init_simple_test("BFu0c_BFu8ll_Ul");
    static BFu0c_BFu8ll_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_Ul");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_Ul(Test_BFu0c_BFu8ll_Ul, "BFu0c_BFu8ll_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_Us()
{
  {
    init_simple_test("BFu0c_BFu8ll_Us");
    static BFu0c_BFu8ll_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_Us");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_Us(Test_BFu0c_BFu8ll_Us, "BFu0c_BFu8ll_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8ll_Vp()
{
  {
    init_simple_test("BFu0c_BFu8ll_Vp");
    static BFu0c_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_Vp");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8ll_Vp(Test_BFu0c_BFu8ll_Vp, "BFu0c_BFu8ll_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu8s");
    static BFu0c_BFu8s lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s(Test_BFu0c_BFu8s, "BFu0c_BFu8s", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu0c");
    static BFu0c_BFu8s_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu0c(Test_BFu0c_BFu8s_BFu0c, "BFu0c_BFu8s_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu0i");
    static BFu0c_BFu8s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_BFu8s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu0i(Test_BFu0c_BFu8s_BFu0i, "BFu0c_BFu8s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu0ll");
    static BFu0c_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu0ll(Test_BFu0c_BFu8s_BFu0ll, "BFu0c_BFu8s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu0s");
    static BFu0c_BFu8s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0c_BFu8s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu0s(Test_BFu0c_BFu8s_BFu0s, "BFu0c_BFu8s_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu15i");
    static BFu0c_BFu8s_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8s_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu15i(Test_BFu0c_BFu8s_BFu15i, "BFu0c_BFu8s_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu15ll");
    static BFu0c_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8s_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu15ll(Test_BFu0c_BFu8s_BFu15ll, "BFu0c_BFu8s_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu15s");
    static BFu0c_BFu8s_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8s_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu15s(Test_BFu0c_BFu8s_BFu15s, "BFu0c_BFu8s_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu16i");
    static BFu0c_BFu8s_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8s_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu16i(Test_BFu0c_BFu8s_BFu16i, "BFu0c_BFu8s_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu16ll");
    static BFu0c_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8s_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu16ll(Test_BFu0c_BFu8s_BFu16ll, "BFu0c_BFu8s_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu16s");
    static BFu0c_BFu8s_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8s_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu16s(Test_BFu0c_BFu8s_BFu16s, "BFu0c_BFu8s_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu17i");
    static BFu0c_BFu8s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8s_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu17i(Test_BFu0c_BFu8s_BFu17i, "BFu0c_BFu8s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu17ll");
    static BFu0c_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8s_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu17ll(Test_BFu0c_BFu8s_BFu17ll, "BFu0c_BFu8s_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu1c");
    static BFu0c_BFu8s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8s_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu1c(Test_BFu0c_BFu8s_BFu1c, "BFu0c_BFu8s_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu1i");
    static BFu0c_BFu8s_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8s_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu1i(Test_BFu0c_BFu8s_BFu1i, "BFu0c_BFu8s_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu1ll");
    static BFu0c_BFu8s_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8s_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu1ll(Test_BFu0c_BFu8s_BFu1ll, "BFu0c_BFu8s_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu1s");
    static BFu0c_BFu8s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8s_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu1s(Test_BFu0c_BFu8s_BFu1s, "BFu0c_BFu8s_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu31i");
    static BFu0c_BFu8s_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8s_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu31i(Test_BFu0c_BFu8s_BFu31i, "BFu0c_BFu8s_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu31ll");
    static BFu0c_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8s_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu31ll(Test_BFu0c_BFu8s_BFu31ll, "BFu0c_BFu8s_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu32i");
    static BFu0c_BFu8s_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8s_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu32i(Test_BFu0c_BFu8s_BFu32i, "BFu0c_BFu8s_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu32ll");
    static BFu0c_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8s_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu32ll(Test_BFu0c_BFu8s_BFu32ll, "BFu0c_BFu8s_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu33()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu33");
    static BFu0c_BFu8s_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu8s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0c_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu8s_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu33(Test_BFu0c_BFu8s_BFu33, "BFu0c_BFu8s_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu7c");
    static BFu0c_BFu8s_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8s_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu7c(Test_BFu0c_BFu8s_BFu7c, "BFu0c_BFu8s_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu7i");
    static BFu0c_BFu8s_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8s_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu7i(Test_BFu0c_BFu8s_BFu7i, "BFu0c_BFu8s_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu7ll");
    static BFu0c_BFu8s_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8s_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu7ll(Test_BFu0c_BFu8s_BFu7ll, "BFu0c_BFu8s_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu7s");
    static BFu0c_BFu8s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8s_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu7s(Test_BFu0c_BFu8s_BFu7s, "BFu0c_BFu8s_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu8c");
    static BFu0c_BFu8s_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu8c(Test_BFu0c_BFu8s_BFu8c, "BFu0c_BFu8s_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu8i");
    static BFu0c_BFu8s_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu8i(Test_BFu0c_BFu8s_BFu8i, "BFu0c_BFu8s_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu8ll");
    static BFu0c_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu8ll(Test_BFu0c_BFu8s_BFu8ll, "BFu0c_BFu8s_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu8s");
    static BFu0c_BFu8s_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu8s(Test_BFu0c_BFu8s_BFu8s, "BFu0c_BFu8s_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu9i");
    static BFu0c_BFu8s_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8s_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu9i(Test_BFu0c_BFu8s_BFu9i, "BFu0c_BFu8s_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu9ll");
    static BFu0c_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8s_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu9ll(Test_BFu0c_BFu8s_BFu9ll, "BFu0c_BFu8s_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu9s");
    static BFu0c_BFu8s_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8s_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_BFu9s(Test_BFu0c_BFu8s_BFu9s, "BFu0c_BFu8s_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_C()
{
  {
    init_simple_test("BFu0c_BFu8s_C");
    static BFu0c_BFu8s_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_C(Test_BFu0c_BFu8s_C, "BFu0c_BFu8s_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_D()
{
  {
    init_simple_test("BFu0c_BFu8s_D");
    static BFu0c_BFu8s_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu8s_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_D");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_D(Test_BFu0c_BFu8s_D, "BFu0c_BFu8s_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_F()
{
  {
    init_simple_test("BFu0c_BFu8s_F");
    static BFu0c_BFu8s_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8s_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_F");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_F(Test_BFu0c_BFu8s_F, "BFu0c_BFu8s_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_I()
{
  {
    init_simple_test("BFu0c_BFu8s_I");
    static BFu0c_BFu8s_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8s_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_I");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_I(Test_BFu0c_BFu8s_I, "BFu0c_BFu8s_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_Ip()
{
  {
    init_simple_test("BFu0c_BFu8s_Ip");
    static BFu0c_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu8s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_Ip");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_Ip(Test_BFu0c_BFu8s_Ip, "BFu0c_BFu8s_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_L()
{
  {
    init_simple_test("BFu0c_BFu8s_L");
    static BFu0c_BFu8s_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu8s_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_L");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_L(Test_BFu0c_BFu8s_L, "BFu0c_BFu8s_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_S()
{
  {
    init_simple_test("BFu0c_BFu8s_S");
    static BFu0c_BFu8s_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8s_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_S");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_S(Test_BFu0c_BFu8s_S, "BFu0c_BFu8s_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_Uc()
{
  {
    init_simple_test("BFu0c_BFu8s_Uc");
    static BFu0c_BFu8s_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_Uc(Test_BFu0c_BFu8s_Uc, "BFu0c_BFu8s_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_Ui()
{
  {
    init_simple_test("BFu0c_BFu8s_Ui");
    static BFu0c_BFu8s_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu8s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_Ui");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_Ui(Test_BFu0c_BFu8s_Ui, "BFu0c_BFu8s_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_Ul()
{
  {
    init_simple_test("BFu0c_BFu8s_Ul");
    static BFu0c_BFu8s_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_BFu8s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_Ul");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_Ul(Test_BFu0c_BFu8s_Ul, "BFu0c_BFu8s_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_Us()
{
  {
    init_simple_test("BFu0c_BFu8s_Us");
    static BFu0c_BFu8s_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu8s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_Us");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_Us(Test_BFu0c_BFu8s_Us, "BFu0c_BFu8s_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu8s_Vp()
{
  {
    init_simple_test("BFu0c_BFu8s_Vp");
    static BFu0c_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_BFu8s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_Vp");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu8s_Vp(Test_BFu0c_BFu8s_Vp, "BFu0c_BFu8s_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu9i");
    static BFu0c_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i(Test_BFu0c_BFu9i, "BFu0c_BFu9i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu0c");
    static BFu0c_BFu9i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu0c(Test_BFu0c_BFu9i_BFu0c, "BFu0c_BFu9i_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu0i");
    static BFu0c_BFu9i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_BFu9i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu9i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu0i(Test_BFu0c_BFu9i_BFu0i, "BFu0c_BFu9i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu0ll");
    static BFu0c_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu9i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu0ll(Test_BFu0c_BFu9i_BFu0ll, "BFu0c_BFu9i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu0s");
    static BFu0c_BFu9i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu9i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu0s(Test_BFu0c_BFu9i_BFu0s, "BFu0c_BFu9i_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu15i");
    static BFu0c_BFu9i_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0c_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu9i_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu15i(Test_BFu0c_BFu9i_BFu15i, "BFu0c_BFu9i_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu15ll");
    static BFu0c_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0c_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu9i_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu15ll(Test_BFu0c_BFu9i_BFu15ll, "BFu0c_BFu9i_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu15s");
    static BFu0c_BFu9i_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0c_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu9i_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu15s(Test_BFu0c_BFu9i_BFu15s, "BFu0c_BFu9i_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu16i");
    static BFu0c_BFu9i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0c_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu9i_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu16i(Test_BFu0c_BFu9i_BFu16i, "BFu0c_BFu9i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu16ll");
    static BFu0c_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0c_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu9i_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu16ll(Test_BFu0c_BFu9i_BFu16ll, "BFu0c_BFu9i_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu16s");
    static BFu0c_BFu9i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0c_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu9i_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu16s(Test_BFu0c_BFu9i_BFu16s, "BFu0c_BFu9i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu17i");
    static BFu0c_BFu9i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0c_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu9i_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu17i(Test_BFu0c_BFu9i_BFu17i, "BFu0c_BFu9i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu17ll");
    static BFu0c_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0c_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu9i_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu17ll(Test_BFu0c_BFu9i_BFu17ll, "BFu0c_BFu9i_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu1c");
    static BFu0c_BFu9i_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9i_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu1c(Test_BFu0c_BFu9i_BFu1c, "BFu0c_BFu9i_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu1i");
    static BFu0c_BFu9i_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9i_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu1i(Test_BFu0c_BFu9i_BFu1i, "BFu0c_BFu9i_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu1ll");
    static BFu0c_BFu9i_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9i_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu1ll(Test_BFu0c_BFu9i_BFu1ll, "BFu0c_BFu9i_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu1s");
    static BFu0c_BFu9i_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9i_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu1s(Test_BFu0c_BFu9i_BFu1s, "BFu0c_BFu9i_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu31i");
    static BFu0c_BFu9i_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu9i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu0c_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu9i_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu31i(Test_BFu0c_BFu9i_BFu31i, "BFu0c_BFu9i_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu31ll");
    static BFu0c_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu9i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu0c_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu9i_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu31ll(Test_BFu0c_BFu9i_BFu31ll, "BFu0c_BFu9i_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu32i");
    static BFu0c_BFu9i_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu0c_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu9i_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu32i(Test_BFu0c_BFu9i_BFu32i, "BFu0c_BFu9i_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu32ll");
    static BFu0c_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu0c_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu9i_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu32ll(Test_BFu0c_BFu9i_BFu32ll, "BFu0c_BFu9i_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu33()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu33");
    static BFu0c_BFu9i_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "BFu0c_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "BFu0c_BFu9i_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu33(Test_BFu0c_BFu9i_BFu33, "BFu0c_BFu9i_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu7c");
    static BFu0c_BFu9i_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9i_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu7c(Test_BFu0c_BFu9i_BFu7c, "BFu0c_BFu9i_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu7i");
    static BFu0c_BFu9i_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9i_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu7i(Test_BFu0c_BFu9i_BFu7i, "BFu0c_BFu9i_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu7ll");
    static BFu0c_BFu9i_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9i_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu7ll(Test_BFu0c_BFu9i_BFu7ll, "BFu0c_BFu9i_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu7s");
    static BFu0c_BFu9i_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9i_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu7s(Test_BFu0c_BFu9i_BFu7s, "BFu0c_BFu9i_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu8c");
    static BFu0c_BFu9i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9i_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu8c(Test_BFu0c_BFu9i_BFu8c, "BFu0c_BFu9i_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu8i");
    static BFu0c_BFu9i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9i_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu8i(Test_BFu0c_BFu9i_BFu8i, "BFu0c_BFu9i_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu8ll");
    static BFu0c_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9i_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu8ll(Test_BFu0c_BFu9i_BFu8ll, "BFu0c_BFu9i_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu8s");
    static BFu0c_BFu9i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9i_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu8s(Test_BFu0c_BFu9i_BFu8s, "BFu0c_BFu9i_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu9i");
    static BFu0c_BFu9i_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0c_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu9i(Test_BFu0c_BFu9i_BFu9i, "BFu0c_BFu9i_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu9ll");
    static BFu0c_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0c_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu9ll(Test_BFu0c_BFu9i_BFu9ll, "BFu0c_BFu9i_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu9s");
    static BFu0c_BFu9i_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0c_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_BFu9s(Test_BFu0c_BFu9i_BFu9s, "BFu0c_BFu9i_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_C()
{
  {
    init_simple_test("BFu0c_BFu9i_C");
    static BFu0c_BFu9i_C lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9i_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_C");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_C(Test_BFu0c_BFu9i_C, "BFu0c_BFu9i_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_D()
{
  {
    init_simple_test("BFu0c_BFu9i_D");
    static BFu0c_BFu9i_D lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_BFu9i_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_D");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_D(Test_BFu0c_BFu9i_D, "BFu0c_BFu9i_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_F()
{
  {
    init_simple_test("BFu0c_BFu9i_F");
    static BFu0c_BFu9i_F lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9i_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_F");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_F(Test_BFu0c_BFu9i_F, "BFu0c_BFu9i_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_I()
{
  {
    init_simple_test("BFu0c_BFu9i_I");
    static BFu0c_BFu9i_I lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9i_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_I");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_I(Test_BFu0c_BFu9i_I, "BFu0c_BFu9i_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_Ip()
{
  {
    init_simple_test("BFu0c_BFu9i_Ip");
    static BFu0c_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_BFu9i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_Ip");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_Ip(Test_BFu0c_BFu9i_Ip, "BFu0c_BFu9i_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_L()
{
  {
    init_simple_test("BFu0c_BFu9i_L");
    static BFu0c_BFu9i_L lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_BFu9i_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_L");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_L(Test_BFu0c_BFu9i_L, "BFu0c_BFu9i_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_S()
{
  {
    init_simple_test("BFu0c_BFu9i_S");
    static BFu0c_BFu9i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_S(Test_BFu0c_BFu9i_S, "BFu0c_BFu9i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_Uc()
{
  {
    init_simple_test("BFu0c_BFu9i_Uc");
    static BFu0c_BFu9i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_Uc");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_Uc(Test_BFu0c_BFu9i_Uc, "BFu0c_BFu9i_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_Ui()
{
  {
    init_simple_test("BFu0c_BFu9i_Ui");
    static BFu0c_BFu9i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_Ui");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_Ui(Test_BFu0c_BFu9i_Ui, "BFu0c_BFu9i_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_Ul()
{
  {
    init_simple_test("BFu0c_BFu9i_Ul");
    static BFu0c_BFu9i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_BFu9i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_Ul");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_Ul(Test_BFu0c_BFu9i_Ul, "BFu0c_BFu9i_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_Us()
{
  {
    init_simple_test("BFu0c_BFu9i_Us");
    static BFu0c_BFu9i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_Us(Test_BFu0c_BFu9i_Us, "BFu0c_BFu9i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9i_Vp()
{
  {
    init_simple_test("BFu0c_BFu9i_Vp");
    static BFu0c_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_BFu9i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_Vp");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9i_Vp(Test_BFu0c_BFu9i_Vp, "BFu0c_BFu9i_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu9ll");
    static BFu0c_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll(Test_BFu0c_BFu9ll, "BFu0c_BFu9ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu0c");
    static BFu0c_BFu9ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu0c(Test_BFu0c_BFu9ll_BFu0c, "BFu0c_BFu9ll_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu0i");
    static BFu0c_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu9ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu0i(Test_BFu0c_BFu9ll_BFu0i, "BFu0c_BFu9ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu0ll");
    static BFu0c_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu9ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu0ll(Test_BFu0c_BFu9ll_BFu0ll, "BFu0c_BFu9ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu0s");
    static BFu0c_BFu9ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu9ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu0s(Test_BFu0c_BFu9ll_BFu0s, "BFu0c_BFu9ll_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu15i");
    static BFu0c_BFu9ll_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0c_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu9ll_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu15i(Test_BFu0c_BFu9ll_BFu15i, "BFu0c_BFu9ll_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu15ll");
    static BFu0c_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0c_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu9ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu15ll(Test_BFu0c_BFu9ll_BFu15ll, "BFu0c_BFu9ll_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu15s");
    static BFu0c_BFu9ll_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0c_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu9ll_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu15s(Test_BFu0c_BFu9ll_BFu15s, "BFu0c_BFu9ll_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu16i");
    static BFu0c_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0c_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu9ll_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu16i(Test_BFu0c_BFu9ll_BFu16i, "BFu0c_BFu9ll_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu16ll");
    static BFu0c_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0c_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu9ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu16ll(Test_BFu0c_BFu9ll_BFu16ll, "BFu0c_BFu9ll_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu16s");
    static BFu0c_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0c_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu9ll_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu16s(Test_BFu0c_BFu9ll_BFu16s, "BFu0c_BFu9ll_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu17i");
    static BFu0c_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0c_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu9ll_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu17i(Test_BFu0c_BFu9ll_BFu17i, "BFu0c_BFu9ll_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu17ll");
    static BFu0c_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0c_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu9ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu17ll(Test_BFu0c_BFu9ll_BFu17ll, "BFu0c_BFu9ll_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu1c");
    static BFu0c_BFu9ll_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9ll_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu1c(Test_BFu0c_BFu9ll_BFu1c, "BFu0c_BFu9ll_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu1i");
    static BFu0c_BFu9ll_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9ll_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu1i(Test_BFu0c_BFu9ll_BFu1i, "BFu0c_BFu9ll_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu1ll");
    static BFu0c_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu1ll(Test_BFu0c_BFu9ll_BFu1ll, "BFu0c_BFu9ll_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu1s");
    static BFu0c_BFu9ll_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9ll_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu1s(Test_BFu0c_BFu9ll_BFu1s, "BFu0c_BFu9ll_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu31i");
    static BFu0c_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu9ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu0c_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu9ll_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu31i(Test_BFu0c_BFu9ll_BFu31i, "BFu0c_BFu9ll_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu31ll");
    static BFu0c_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu0c_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu9ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu31ll(Test_BFu0c_BFu9ll_BFu31ll, "BFu0c_BFu9ll_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu32i");
    static BFu0c_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu0c_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu9ll_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu32i(Test_BFu0c_BFu9ll_BFu32i, "BFu0c_BFu9ll_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu32ll");
    static BFu0c_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu0c_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu9ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu32ll(Test_BFu0c_BFu9ll_BFu32ll, "BFu0c_BFu9ll_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu33()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu33");
    static BFu0c_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "BFu0c_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "BFu0c_BFu9ll_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu33(Test_BFu0c_BFu9ll_BFu33, "BFu0c_BFu9ll_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu7c");
    static BFu0c_BFu9ll_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9ll_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu7c(Test_BFu0c_BFu9ll_BFu7c, "BFu0c_BFu9ll_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu7i");
    static BFu0c_BFu9ll_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9ll_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu7i(Test_BFu0c_BFu9ll_BFu7i, "BFu0c_BFu9ll_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu7ll");
    static BFu0c_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu7ll(Test_BFu0c_BFu9ll_BFu7ll, "BFu0c_BFu9ll_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu7s");
    static BFu0c_BFu9ll_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9ll_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu7s(Test_BFu0c_BFu9ll_BFu7s, "BFu0c_BFu9ll_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu8c");
    static BFu0c_BFu9ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9ll_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu8c(Test_BFu0c_BFu9ll_BFu8c, "BFu0c_BFu9ll_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu8i");
    static BFu0c_BFu9ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9ll_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu8i(Test_BFu0c_BFu9ll_BFu8i, "BFu0c_BFu9ll_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu8ll");
    static BFu0c_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu8ll(Test_BFu0c_BFu9ll_BFu8ll, "BFu0c_BFu9ll_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu8s");
    static BFu0c_BFu9ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9ll_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu8s(Test_BFu0c_BFu9ll_BFu8s, "BFu0c_BFu9ll_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu9i");
    static BFu0c_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0c_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu9i(Test_BFu0c_BFu9ll_BFu9i, "BFu0c_BFu9ll_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu9ll");
    static BFu0c_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0c_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu9ll(Test_BFu0c_BFu9ll_BFu9ll, "BFu0c_BFu9ll_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu9s");
    static BFu0c_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0c_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_BFu9s(Test_BFu0c_BFu9ll_BFu9s, "BFu0c_BFu9ll_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_C()
{
  {
    init_simple_test("BFu0c_BFu9ll_C");
    static BFu0c_BFu9ll_C lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_C");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9ll_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_C(Test_BFu0c_BFu9ll_C, "BFu0c_BFu9ll_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_D()
{
  {
    init_simple_test("BFu0c_BFu9ll_D");
    static BFu0c_BFu9ll_D lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_BFu9ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_D");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9ll_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_D(Test_BFu0c_BFu9ll_D, "BFu0c_BFu9ll_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_F()
{
  {
    init_simple_test("BFu0c_BFu9ll_F");
    static BFu0c_BFu9ll_F lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_F");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9ll_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_F(Test_BFu0c_BFu9ll_F, "BFu0c_BFu9ll_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_I()
{
  {
    init_simple_test("BFu0c_BFu9ll_I");
    static BFu0c_BFu9ll_I lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_I");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9ll_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_I(Test_BFu0c_BFu9ll_I, "BFu0c_BFu9ll_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_Ip()
{
  {
    init_simple_test("BFu0c_BFu9ll_Ip");
    static BFu0c_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_BFu9ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_Ip");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_Ip(Test_BFu0c_BFu9ll_Ip, "BFu0c_BFu9ll_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_L()
{
  {
    init_simple_test("BFu0c_BFu9ll_L");
    static BFu0c_BFu9ll_L lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_BFu9ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_L");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9ll_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_L(Test_BFu0c_BFu9ll_L, "BFu0c_BFu9ll_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_S()
{
  {
    init_simple_test("BFu0c_BFu9ll_S");
    static BFu0c_BFu9ll_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9ll_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_S(Test_BFu0c_BFu9ll_S, "BFu0c_BFu9ll_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_Uc()
{
  {
    init_simple_test("BFu0c_BFu9ll_Uc");
    static BFu0c_BFu9ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_Uc");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_Uc(Test_BFu0c_BFu9ll_Uc, "BFu0c_BFu9ll_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_Ui()
{
  {
    init_simple_test("BFu0c_BFu9ll_Ui");
    static BFu0c_BFu9ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_Ui");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_Ui(Test_BFu0c_BFu9ll_Ui, "BFu0c_BFu9ll_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_Ul()
{
  {
    init_simple_test("BFu0c_BFu9ll_Ul");
    static BFu0c_BFu9ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_BFu9ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_Ul");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_Ul(Test_BFu0c_BFu9ll_Ul, "BFu0c_BFu9ll_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_Us()
{
  {
    init_simple_test("BFu0c_BFu9ll_Us");
    static BFu0c_BFu9ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9ll_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_Us(Test_BFu0c_BFu9ll_Us, "BFu0c_BFu9ll_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9ll_Vp()
{
  {
    init_simple_test("BFu0c_BFu9ll_Vp");
    static BFu0c_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_BFu9ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_Vp");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9ll_Vp(Test_BFu0c_BFu9ll_Vp, "BFu0c_BFu9ll_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu9s");
    static BFu0c_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s(Test_BFu0c_BFu9s, "BFu0c_BFu9s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu0c");
    static BFu0c_BFu9s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu0c(Test_BFu0c_BFu9s_BFu0c, "BFu0c_BFu9s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu0i");
    static BFu0c_BFu9s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_BFu9s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu9s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu0i(Test_BFu0c_BFu9s_BFu0i, "BFu0c_BFu9s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu0ll");
    static BFu0c_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu9s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu0ll(Test_BFu0c_BFu9s_BFu0ll, "BFu0c_BFu9s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu0s");
    static BFu0c_BFu9s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu9s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu0s(Test_BFu0c_BFu9s_BFu0s, "BFu0c_BFu9s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu15i");
    static BFu0c_BFu9s_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0c_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu9s_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu15i(Test_BFu0c_BFu9s_BFu15i, "BFu0c_BFu9s_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu15ll");
    static BFu0c_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0c_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu9s_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu15ll(Test_BFu0c_BFu9s_BFu15ll, "BFu0c_BFu9s_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu15s");
    static BFu0c_BFu9s_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0c_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu9s_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu15s(Test_BFu0c_BFu9s_BFu15s, "BFu0c_BFu9s_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu16i");
    static BFu0c_BFu9s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0c_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu9s_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu16i(Test_BFu0c_BFu9s_BFu16i, "BFu0c_BFu9s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu16ll");
    static BFu0c_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0c_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu9s_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu16ll(Test_BFu0c_BFu9s_BFu16ll, "BFu0c_BFu9s_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu16s");
    static BFu0c_BFu9s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0c_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu9s_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu16s(Test_BFu0c_BFu9s_BFu16s, "BFu0c_BFu9s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu17i");
    static BFu0c_BFu9s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0c_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu9s_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu17i(Test_BFu0c_BFu9s_BFu17i, "BFu0c_BFu9s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu17ll");
    static BFu0c_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0c_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu9s_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu17ll(Test_BFu0c_BFu9s_BFu17ll, "BFu0c_BFu9s_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu1c");
    static BFu0c_BFu9s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9s_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu1c(Test_BFu0c_BFu9s_BFu1c, "BFu0c_BFu9s_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu1i");
    static BFu0c_BFu9s_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9s_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu1i(Test_BFu0c_BFu9s_BFu1i, "BFu0c_BFu9s_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu1ll");
    static BFu0c_BFu9s_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9s_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu1ll(Test_BFu0c_BFu9s_BFu1ll, "BFu0c_BFu9s_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu1s");
    static BFu0c_BFu9s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9s_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu1s(Test_BFu0c_BFu9s_BFu1s, "BFu0c_BFu9s_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu31i");
    static BFu0c_BFu9s_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu9s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu0c_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu9s_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu31i(Test_BFu0c_BFu9s_BFu31i, "BFu0c_BFu9s_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu31ll");
    static BFu0c_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu9s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu0c_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu9s_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu31ll(Test_BFu0c_BFu9s_BFu31ll, "BFu0c_BFu9s_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu32i");
    static BFu0c_BFu9s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu0c_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu9s_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu32i(Test_BFu0c_BFu9s_BFu32i, "BFu0c_BFu9s_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu32ll");
    static BFu0c_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu0c_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu9s_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu32ll(Test_BFu0c_BFu9s_BFu32ll, "BFu0c_BFu9s_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu33()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu33");
    static BFu0c_BFu9s_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "BFu0c_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "BFu0c_BFu9s_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu33(Test_BFu0c_BFu9s_BFu33, "BFu0c_BFu9s_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu7c");
    static BFu0c_BFu9s_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9s_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu7c(Test_BFu0c_BFu9s_BFu7c, "BFu0c_BFu9s_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu7i");
    static BFu0c_BFu9s_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9s_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu7i(Test_BFu0c_BFu9s_BFu7i, "BFu0c_BFu9s_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu7ll");
    static BFu0c_BFu9s_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9s_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu7ll(Test_BFu0c_BFu9s_BFu7ll, "BFu0c_BFu9s_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu7s");
    static BFu0c_BFu9s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9s_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu7s(Test_BFu0c_BFu9s_BFu7s, "BFu0c_BFu9s_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu8c");
    static BFu0c_BFu9s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9s_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu8c(Test_BFu0c_BFu9s_BFu8c, "BFu0c_BFu9s_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu8i");
    static BFu0c_BFu9s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9s_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu8i(Test_BFu0c_BFu9s_BFu8i, "BFu0c_BFu9s_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu8ll");
    static BFu0c_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9s_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu8ll(Test_BFu0c_BFu9s_BFu8ll, "BFu0c_BFu9s_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu8s");
    static BFu0c_BFu9s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9s_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu8s(Test_BFu0c_BFu9s_BFu8s, "BFu0c_BFu9s_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu9i");
    static BFu0c_BFu9s_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0c_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu9i(Test_BFu0c_BFu9s_BFu9i, "BFu0c_BFu9s_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu9ll");
    static BFu0c_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0c_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu9ll(Test_BFu0c_BFu9s_BFu9ll, "BFu0c_BFu9s_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu9s_BFu9s");
    static BFu0c_BFu9s_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0c_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_BFu9s(Test_BFu0c_BFu9s_BFu9s, "BFu0c_BFu9s_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_C()
{
  {
    init_simple_test("BFu0c_BFu9s_C");
    static BFu0c_BFu9s_C lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9s_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_C");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9s_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_C(Test_BFu0c_BFu9s_C, "BFu0c_BFu9s_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_D()
{
  {
    init_simple_test("BFu0c_BFu9s_D");
    static BFu0c_BFu9s_D lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_BFu9s_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_D");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9s_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_D(Test_BFu0c_BFu9s_D, "BFu0c_BFu9s_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_F()
{
  {
    init_simple_test("BFu0c_BFu9s_F");
    static BFu0c_BFu9s_F lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9s_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_F");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9s_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_F(Test_BFu0c_BFu9s_F, "BFu0c_BFu9s_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_I()
{
  {
    init_simple_test("BFu0c_BFu9s_I");
    static BFu0c_BFu9s_I lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9s_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_I");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9s_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_I(Test_BFu0c_BFu9s_I, "BFu0c_BFu9s_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_Ip()
{
  {
    init_simple_test("BFu0c_BFu9s_Ip");
    static BFu0c_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_BFu9s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_Ip");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9s_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_Ip(Test_BFu0c_BFu9s_Ip, "BFu0c_BFu9s_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_L()
{
  {
    init_simple_test("BFu0c_BFu9s_L");
    static BFu0c_BFu9s_L lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_BFu9s_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_L");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9s_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_L(Test_BFu0c_BFu9s_L, "BFu0c_BFu9s_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_S()
{
  {
    init_simple_test("BFu0c_BFu9s_S");
    static BFu0c_BFu9s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9s_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9s_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_S(Test_BFu0c_BFu9s_S, "BFu0c_BFu9s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_Uc()
{
  {
    init_simple_test("BFu0c_BFu9s_Uc");
    static BFu0c_BFu9s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu9s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_Uc");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9s_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_Uc(Test_BFu0c_BFu9s_Uc, "BFu0c_BFu9s_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_Ui()
{
  {
    init_simple_test("BFu0c_BFu9s_Ui");
    static BFu0c_BFu9s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_BFu9s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_Ui");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9s_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_Ui(Test_BFu0c_BFu9s_Ui, "BFu0c_BFu9s_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_Ul()
{
  {
    init_simple_test("BFu0c_BFu9s_Ul");
    static BFu0c_BFu9s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_BFu9s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_Ul");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9s_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_Ul(Test_BFu0c_BFu9s_Ul, "BFu0c_BFu9s_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_Us()
{
  {
    init_simple_test("BFu0c_BFu9s_Us");
    static BFu0c_BFu9s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9s_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_Us(Test_BFu0c_BFu9s_Us, "BFu0c_BFu9s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_BFu9s_Vp()
{
  {
    init_simple_test("BFu0c_BFu9s_Vp");
    static BFu0c_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_BFu9s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_Vp");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9s_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_BFu9s_Vp(Test_BFu0c_BFu9s_Vp, "BFu0c_BFu9s_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C()
{
  {
    init_simple_test("BFu0c_C");
    static BFu0c_C lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C)");
    check_field_offset(lv, v1, 0, "BFu0c_C.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_C(Test_BFu0c_C, "BFu0c_C", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu0c()
{
  {
    init_simple_test("BFu0c_C_BFu0c");
    static BFu0c_C_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_C_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu0c(Test_BFu0c_C_BFu0c, "BFu0c_C_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu0i()
{
  {
    init_simple_test("BFu0c_C_BFu0i");
    static BFu0c_C_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_C_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_C_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu0i(Test_BFu0c_C_BFu0i, "BFu0c_C_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu0ll()
{
  {
    init_simple_test("BFu0c_C_BFu0ll");
    static BFu0c_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_C_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu0ll(Test_BFu0c_C_BFu0ll, "BFu0c_C_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu0s()
{
  {
    init_simple_test("BFu0c_C_BFu0s");
    static BFu0c_C_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0c_C_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_C_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu0s(Test_BFu0c_C_BFu0s, "BFu0c_C_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu15i()
{
  {
    init_simple_test("BFu0c_C_BFu15i");
    static BFu0c_C_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_C_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_C_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_C_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu15i(Test_BFu0c_C_BFu15i, "BFu0c_C_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu15ll()
{
  {
    init_simple_test("BFu0c_C_BFu15ll");
    static BFu0c_C_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_C_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_C_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_C_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu15ll(Test_BFu0c_C_BFu15ll, "BFu0c_C_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu15s()
{
  {
    init_simple_test("BFu0c_C_BFu15s");
    static BFu0c_C_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_C_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_C_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_C_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu15s(Test_BFu0c_C_BFu15s, "BFu0c_C_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu16i()
{
  {
    init_simple_test("BFu0c_C_BFu16i");
    static BFu0c_C_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_C_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_C_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_C_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu16i(Test_BFu0c_C_BFu16i, "BFu0c_C_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu16ll()
{
  {
    init_simple_test("BFu0c_C_BFu16ll");
    static BFu0c_C_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_C_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_C_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_C_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu16ll(Test_BFu0c_C_BFu16ll, "BFu0c_C_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu16s()
{
  {
    init_simple_test("BFu0c_C_BFu16s");
    static BFu0c_C_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_C_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_C_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_C_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu16s(Test_BFu0c_C_BFu16s, "BFu0c_C_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu17i()
{
  {
    init_simple_test("BFu0c_C_BFu17i");
    static BFu0c_C_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_C_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_C_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_C_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu17i(Test_BFu0c_C_BFu17i, "BFu0c_C_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu17ll()
{
  {
    init_simple_test("BFu0c_C_BFu17ll");
    static BFu0c_C_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_C_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_C_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_C_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu17ll(Test_BFu0c_C_BFu17ll, "BFu0c_C_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu1c()
{
  {
    init_simple_test("BFu0c_C_BFu1c");
    static BFu0c_C_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_C_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu1c(Test_BFu0c_C_BFu1c, "BFu0c_C_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu1i()
{
  {
    init_simple_test("BFu0c_C_BFu1i");
    static BFu0c_C_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_C_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu1i(Test_BFu0c_C_BFu1i, "BFu0c_C_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu1ll()
{
  {
    init_simple_test("BFu0c_C_BFu1ll");
    static BFu0c_C_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_C_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu1ll(Test_BFu0c_C_BFu1ll, "BFu0c_C_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu1s()
{
  {
    init_simple_test("BFu0c_C_BFu1s");
    static BFu0c_C_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_C_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu1s(Test_BFu0c_C_BFu1s, "BFu0c_C_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu31i()
{
  {
    init_simple_test("BFu0c_C_BFu31i");
    static BFu0c_C_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_C_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_C_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_C_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu31i(Test_BFu0c_C_BFu31i, "BFu0c_C_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu31ll()
{
  {
    init_simple_test("BFu0c_C_BFu31ll");
    static BFu0c_C_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_C_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_C_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_C_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu31ll(Test_BFu0c_C_BFu31ll, "BFu0c_C_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu32i()
{
  {
    init_simple_test("BFu0c_C_BFu32i");
    static BFu0c_C_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_C_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_C_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_C_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu32i(Test_BFu0c_C_BFu32i, "BFu0c_C_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu32ll()
{
  {
    init_simple_test("BFu0c_C_BFu32ll");
    static BFu0c_C_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_C_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_C_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_C_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu32ll(Test_BFu0c_C_BFu32ll, "BFu0c_C_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu33()
{
  {
    init_simple_test("BFu0c_C_BFu33");
    static BFu0c_C_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_C_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0c_C_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0c_C_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu33(Test_BFu0c_C_BFu33, "BFu0c_C_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu7c()
{
  {
    init_simple_test("BFu0c_C_BFu7c");
    static BFu0c_C_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_C_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_C_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu7c(Test_BFu0c_C_BFu7c, "BFu0c_C_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu7i()
{
  {
    init_simple_test("BFu0c_C_BFu7i");
    static BFu0c_C_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_C_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_C_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu7i(Test_BFu0c_C_BFu7i, "BFu0c_C_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu7ll()
{
  {
    init_simple_test("BFu0c_C_BFu7ll");
    static BFu0c_C_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_C_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_C_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu7ll(Test_BFu0c_C_BFu7ll, "BFu0c_C_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu7s()
{
  {
    init_simple_test("BFu0c_C_BFu7s");
    static BFu0c_C_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_C_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_C_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu7s(Test_BFu0c_C_BFu7s, "BFu0c_C_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu8c()
{
  {
    init_simple_test("BFu0c_C_BFu8c");
    static BFu0c_C_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_C_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_C_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu8c(Test_BFu0c_C_BFu8c, "BFu0c_C_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu8i()
{
  {
    init_simple_test("BFu0c_C_BFu8i");
    static BFu0c_C_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_C_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_C_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu8i(Test_BFu0c_C_BFu8i, "BFu0c_C_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu8ll()
{
  {
    init_simple_test("BFu0c_C_BFu8ll");
    static BFu0c_C_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_C_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_C_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu8ll(Test_BFu0c_C_BFu8ll, "BFu0c_C_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu8s()
{
  {
    init_simple_test("BFu0c_C_BFu8s");
    static BFu0c_C_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_C_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_C_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu8s(Test_BFu0c_C_BFu8s, "BFu0c_C_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu9i()
{
  {
    init_simple_test("BFu0c_C_BFu9i");
    static BFu0c_C_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_C_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_C_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_C_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu9i(Test_BFu0c_C_BFu9i, "BFu0c_C_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu9ll()
{
  {
    init_simple_test("BFu0c_C_BFu9ll");
    static BFu0c_C_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_C_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_C_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_C_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu9ll(Test_BFu0c_C_BFu9ll, "BFu0c_C_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_BFu9s()
{
  {
    init_simple_test("BFu0c_C_BFu9s");
    static BFu0c_C_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_C_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0c_C_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_C_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_C_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_C_BFu9s(Test_BFu0c_C_BFu9s, "BFu0c_C_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_C()
{
  {
    init_simple_test("BFu0c_C_C");
    static BFu0c_C_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_C)");
    check_field_offset(lv, v1, 0, "BFu0c_C_C.v1");
    check_field_offset(lv, v2, 1, "BFu0c_C_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_C_C(Test_BFu0c_C_C, "BFu0c_C_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_D()
{
  {
    init_simple_test("BFu0c_C_D");
    static BFu0c_C_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_C_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_D)");
    check_field_offset(lv, v1, 0, "BFu0c_C_D.v1");
    check_field_offset(lv, v2, 1, "BFu0c_C_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_C_D(Test_BFu0c_C_D, "BFu0c_C_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_F()
{
  {
    init_simple_test("BFu0c_C_F");
    static BFu0c_C_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_C_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_F)");
    check_field_offset(lv, v1, 0, "BFu0c_C_F.v1");
    check_field_offset(lv, v2, 1, "BFu0c_C_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_C_F(Test_BFu0c_C_F, "BFu0c_C_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_I()
{
  {
    init_simple_test("BFu0c_C_I");
    static BFu0c_C_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_C_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_I)");
    check_field_offset(lv, v1, 0, "BFu0c_C_I.v1");
    check_field_offset(lv, v2, 1, "BFu0c_C_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_C_I(Test_BFu0c_C_I, "BFu0c_C_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_Ip()
{
  {
    init_simple_test("BFu0c_C_Ip");
    static BFu0c_C_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_C_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_C_Ip.v1");
    check_field_offset(lv, v2, 1, "BFu0c_C_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_C_Ip(Test_BFu0c_C_Ip, "BFu0c_C_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_L()
{
  {
    init_simple_test("BFu0c_C_L");
    static BFu0c_C_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_C_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_L)");
    check_field_offset(lv, v1, 0, "BFu0c_C_L.v1");
    check_field_offset(lv, v2, 1, "BFu0c_C_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_C_L(Test_BFu0c_C_L, "BFu0c_C_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_S()
{
  {
    init_simple_test("BFu0c_C_S");
    static BFu0c_C_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_C_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_S)");
    check_field_offset(lv, v1, 0, "BFu0c_C_S.v1");
    check_field_offset(lv, v2, 1, "BFu0c_C_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_C_S(Test_BFu0c_C_S, "BFu0c_C_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_Uc()
{
  {
    init_simple_test("BFu0c_C_Uc");
    static BFu0c_C_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_C_Uc.v1");
    check_field_offset(lv, v2, 1, "BFu0c_C_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_C_Uc(Test_BFu0c_C_Uc, "BFu0c_C_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_Ui()
{
  {
    init_simple_test("BFu0c_C_Ui");
    static BFu0c_C_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_C_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_C_Ui.v1");
    check_field_offset(lv, v2, 1, "BFu0c_C_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_C_Ui(Test_BFu0c_C_Ui, "BFu0c_C_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_Ul()
{
  {
    init_simple_test("BFu0c_C_Ul");
    static BFu0c_C_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_C_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_C_Ul.v1");
    check_field_offset(lv, v2, 1, "BFu0c_C_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_C_Ul(Test_BFu0c_C_Ul, "BFu0c_C_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_Us()
{
  {
    init_simple_test("BFu0c_C_Us");
    static BFu0c_C_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_C_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_C_Us.v1");
    check_field_offset(lv, v2, 1, "BFu0c_C_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_C_Us(Test_BFu0c_C_Us, "BFu0c_C_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_C_Vp()
{
  {
    init_simple_test("BFu0c_C_Vp");
    static BFu0c_C_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_C_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_C_Vp.v1");
    check_field_offset(lv, v2, 1, "BFu0c_C_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_C_Vp(Test_BFu0c_C_Vp, "BFu0c_C_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D()
{
  {
    init_simple_test("BFu0c_D");
    static BFu0c_D lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D)");
    check_field_offset(lv, v1, 0, "BFu0c_D.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_D(Test_BFu0c_D, "BFu0c_D", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu0c()
{
  {
    init_simple_test("BFu0c_D_BFu0c");
    static BFu0c_D_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_D_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu0c(Test_BFu0c_D_BFu0c, "BFu0c_D_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu0i()
{
  {
    init_simple_test("BFu0c_D_BFu0i");
    static BFu0c_D_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_D_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu0i(Test_BFu0c_D_BFu0i, "BFu0c_D_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu0ll()
{
  {
    init_simple_test("BFu0c_D_BFu0ll");
    static BFu0c_D_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu0ll(Test_BFu0c_D_BFu0ll, "BFu0c_D_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu0s()
{
  {
    init_simple_test("BFu0c_D_BFu0s");
    static BFu0c_D_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_D_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu0s(Test_BFu0c_D_BFu0s, "BFu0c_D_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu15i()
{
  {
    init_simple_test("BFu0c_D_BFu15i");
    static BFu0c_D_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_D_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0c_D_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0c_D_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu15i(Test_BFu0c_D_BFu15i, "BFu0c_D_BFu15i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu15ll()
{
  {
    init_simple_test("BFu0c_D_BFu15ll");
    static BFu0c_D_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_D_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0c_D_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0c_D_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu15ll(Test_BFu0c_D_BFu15ll, "BFu0c_D_BFu15ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu15s()
{
  {
    init_simple_test("BFu0c_D_BFu15s");
    static BFu0c_D_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_D_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0c_D_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0c_D_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu15s(Test_BFu0c_D_BFu15s, "BFu0c_D_BFu15s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu16i()
{
  {
    init_simple_test("BFu0c_D_BFu16i");
    static BFu0c_D_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_D_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0c_D_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0c_D_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu16i(Test_BFu0c_D_BFu16i, "BFu0c_D_BFu16i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu16ll()
{
  {
    init_simple_test("BFu0c_D_BFu16ll");
    static BFu0c_D_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_D_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0c_D_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0c_D_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu16ll(Test_BFu0c_D_BFu16ll, "BFu0c_D_BFu16ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu16s()
{
  {
    init_simple_test("BFu0c_D_BFu16s");
    static BFu0c_D_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_D_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0c_D_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0c_D_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu16s(Test_BFu0c_D_BFu16s, "BFu0c_D_BFu16s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu17i()
{
  {
    init_simple_test("BFu0c_D_BFu17i");
    static BFu0c_D_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(BFu0c_D_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0c_D_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0c_D_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu17i(Test_BFu0c_D_BFu17i, "BFu0c_D_BFu17i", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu17ll()
{
  {
    init_simple_test("BFu0c_D_BFu17ll");
    static BFu0c_D_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu0c_D_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0c_D_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0c_D_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu17ll(Test_BFu0c_D_BFu17ll, "BFu0c_D_BFu17ll", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu1c()
{
  {
    init_simple_test("BFu0c_D_BFu1c");
    static BFu0c_D_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0c_D_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu1c(Test_BFu0c_D_BFu1c, "BFu0c_D_BFu1c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu1i()
{
  {
    init_simple_test("BFu0c_D_BFu1i");
    static BFu0c_D_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0c_D_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu1i(Test_BFu0c_D_BFu1i, "BFu0c_D_BFu1i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu1ll()
{
  {
    init_simple_test("BFu0c_D_BFu1ll");
    static BFu0c_D_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0c_D_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu1ll(Test_BFu0c_D_BFu1ll, "BFu0c_D_BFu1ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu1s()
{
  {
    init_simple_test("BFu0c_D_BFu1s");
    static BFu0c_D_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0c_D_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu1s(Test_BFu0c_D_BFu1s, "BFu0c_D_BFu1s", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu31i()
{
  {
    init_simple_test("BFu0c_D_BFu31i");
    static BFu0c_D_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_D_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0c_D_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0c_D_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu31i(Test_BFu0c_D_BFu31i, "BFu0c_D_BFu31i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu31ll()
{
  {
    init_simple_test("BFu0c_D_BFu31ll");
    static BFu0c_D_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_D_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0c_D_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0c_D_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu31ll(Test_BFu0c_D_BFu31ll, "BFu0c_D_BFu31ll", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu32i()
{
  {
    init_simple_test("BFu0c_D_BFu32i");
    static BFu0c_D_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_D_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0c_D_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0c_D_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu32i(Test_BFu0c_D_BFu32i, "BFu0c_D_BFu32i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu32ll()
{
  {
    init_simple_test("BFu0c_D_BFu32ll");
    static BFu0c_D_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_D_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0c_D_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0c_D_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu32ll(Test_BFu0c_D_BFu32ll, "BFu0c_D_BFu32ll", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu33()
{
  {
    init_simple_test("BFu0c_D_BFu33");
    static BFu0c_D_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(BFu0c_D_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "BFu0c_D_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "BFu0c_D_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu33(Test_BFu0c_D_BFu33, "BFu0c_D_BFu33", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu7c()
{
  {
    init_simple_test("BFu0c_D_BFu7c");
    static BFu0c_D_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0c_D_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0c_D_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu7c(Test_BFu0c_D_BFu7c, "BFu0c_D_BFu7c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu7i()
{
  {
    init_simple_test("BFu0c_D_BFu7i");
    static BFu0c_D_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0c_D_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0c_D_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu7i(Test_BFu0c_D_BFu7i, "BFu0c_D_BFu7i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu7ll()
{
  {
    init_simple_test("BFu0c_D_BFu7ll");
    static BFu0c_D_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0c_D_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0c_D_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu7ll(Test_BFu0c_D_BFu7ll, "BFu0c_D_BFu7ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu7s()
{
  {
    init_simple_test("BFu0c_D_BFu7s");
    static BFu0c_D_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0c_D_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0c_D_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu7s(Test_BFu0c_D_BFu7s, "BFu0c_D_BFu7s", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu8c()
{
  {
    init_simple_test("BFu0c_D_BFu8c");
    static BFu0c_D_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0c_D_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0c_D_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu8c(Test_BFu0c_D_BFu8c, "BFu0c_D_BFu8c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu8i()
{
  {
    init_simple_test("BFu0c_D_BFu8i");
    static BFu0c_D_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0c_D_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0c_D_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu8i(Test_BFu0c_D_BFu8i, "BFu0c_D_BFu8i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu8ll()
{
  {
    init_simple_test("BFu0c_D_BFu8ll");
    static BFu0c_D_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0c_D_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0c_D_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu8ll(Test_BFu0c_D_BFu8ll, "BFu0c_D_BFu8ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu8s()
{
  {
    init_simple_test("BFu0c_D_BFu8s");
    static BFu0c_D_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0c_D_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0c_D_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu8s(Test_BFu0c_D_BFu8s, "BFu0c_D_BFu8s", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu9i()
{
  {
    init_simple_test("BFu0c_D_BFu9i");
    static BFu0c_D_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_D_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0c_D_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0c_D_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu9i(Test_BFu0c_D_BFu9i, "BFu0c_D_BFu9i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu9ll()
{
  {
    init_simple_test("BFu0c_D_BFu9ll");
    static BFu0c_D_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0c_D_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0c_D_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu9ll(Test_BFu0c_D_BFu9ll, "BFu0c_D_BFu9ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_BFu9s()
{
  {
    init_simple_test("BFu0c_D_BFu9s");
    static BFu0c_D_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0c_D_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0c_D_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0c_D_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_D_BFu9s(Test_BFu0c_D_BFu9s, "BFu0c_D_BFu9s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_C()
{
  {
    init_simple_test("BFu0c_D_C");
    static BFu0c_D_C lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_C)");
    check_field_offset(lv, v1, 0, "BFu0c_D_C.v1");
    check_field_offset(lv, v2, 8, "BFu0c_D_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_D_C(Test_BFu0c_D_C, "BFu0c_D_C", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_D()
{
  {
    init_simple_test("BFu0c_D_D");
    static BFu0c_D_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu0c_D_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_D)");
    check_field_offset(lv, v1, 0, "BFu0c_D_D.v1");
    check_field_offset(lv, v2, 8, "BFu0c_D_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_D_D(Test_BFu0c_D_D, "BFu0c_D_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_F()
{
  {
    init_simple_test("BFu0c_D_F");
    static BFu0c_D_F lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_D_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_F)");
    check_field_offset(lv, v1, 0, "BFu0c_D_F.v1");
    check_field_offset(lv, v2, 8, "BFu0c_D_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_D_F(Test_BFu0c_D_F, "BFu0c_D_F", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_I()
{
  {
    init_simple_test("BFu0c_D_I");
    static BFu0c_D_I lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_D_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_I)");
    check_field_offset(lv, v1, 0, "BFu0c_D_I.v1");
    check_field_offset(lv, v2, 8, "BFu0c_D_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_D_I(Test_BFu0c_D_I, "BFu0c_D_I", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_Ip()
{
  {
    init_simple_test("BFu0c_D_Ip");
    static BFu0c_D_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_D_Ip.v1");
    check_field_offset(lv, v2, 8, "BFu0c_D_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_D_Ip(Test_BFu0c_D_Ip, "BFu0c_D_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_L()
{
  {
    init_simple_test("BFu0c_D_L");
    static BFu0c_D_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu0c_D_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_L)");
    check_field_offset(lv, v1, 0, "BFu0c_D_L.v1");
    check_field_offset(lv, v2, 8, "BFu0c_D_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_D_L(Test_BFu0c_D_L, "BFu0c_D_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_S()
{
  {
    init_simple_test("BFu0c_D_S");
    static BFu0c_D_S lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_D_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_S)");
    check_field_offset(lv, v1, 0, "BFu0c_D_S.v1");
    check_field_offset(lv, v2, 8, "BFu0c_D_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_D_S(Test_BFu0c_D_S, "BFu0c_D_S", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_Uc()
{
  {
    init_simple_test("BFu0c_D_Uc");
    static BFu0c_D_Uc lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_D_Uc.v1");
    check_field_offset(lv, v2, 8, "BFu0c_D_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_D_Uc(Test_BFu0c_D_Uc, "BFu0c_D_Uc", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_Ui()
{
  {
    init_simple_test("BFu0c_D_Ui");
    static BFu0c_D_Ui lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_D_Ui.v1");
    check_field_offset(lv, v2, 8, "BFu0c_D_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_D_Ui(Test_BFu0c_D_Ui, "BFu0c_D_Ui", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_Ul()
{
  {
    init_simple_test("BFu0c_D_Ul");
    static BFu0c_D_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu0c_D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_D_Ul.v1");
    check_field_offset(lv, v2, 8, "BFu0c_D_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_D_Ul(Test_BFu0c_D_Ul, "BFu0c_D_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_Us()
{
  {
    init_simple_test("BFu0c_D_Us");
    static BFu0c_D_Us lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_D_Us.v1");
    check_field_offset(lv, v2, 8, "BFu0c_D_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_D_Us(Test_BFu0c_D_Us, "BFu0c_D_Us", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_D_Vp()
{
  {
    init_simple_test("BFu0c_D_Vp");
    static BFu0c_D_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_D_Vp.v1");
    check_field_offset(lv, v2, 8, "BFu0c_D_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_D_Vp(Test_BFu0c_D_Vp, "BFu0c_D_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F()
{
  {
    init_simple_test("BFu0c_F");
    static BFu0c_F lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F)");
    check_field_offset(lv, v1, 0, "BFu0c_F.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_F(Test_BFu0c_F, "BFu0c_F", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu0c()
{
  {
    init_simple_test("BFu0c_F_BFu0c");
    static BFu0c_F_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_F_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu0c(Test_BFu0c_F_BFu0c, "BFu0c_F_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu0i()
{
  {
    init_simple_test("BFu0c_F_BFu0i");
    static BFu0c_F_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_F_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_F_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu0i(Test_BFu0c_F_BFu0i, "BFu0c_F_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu0ll()
{
  {
    init_simple_test("BFu0c_F_BFu0ll");
    static BFu0c_F_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu0ll(Test_BFu0c_F_BFu0ll, "BFu0c_F_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu0s()
{
  {
    init_simple_test("BFu0c_F_BFu0s");
    static BFu0c_F_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_F_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_F_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu0s(Test_BFu0c_F_BFu0s, "BFu0c_F_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu15i()
{
  {
    init_simple_test("BFu0c_F_BFu15i");
    static BFu0c_F_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_F_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_F_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu15i(Test_BFu0c_F_BFu15i, "BFu0c_F_BFu15i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu15ll()
{
  {
    init_simple_test("BFu0c_F_BFu15ll");
    static BFu0c_F_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_F_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_F_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu15ll(Test_BFu0c_F_BFu15ll, "BFu0c_F_BFu15ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu15s()
{
  {
    init_simple_test("BFu0c_F_BFu15s");
    static BFu0c_F_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_F_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_F_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu15s(Test_BFu0c_F_BFu15s, "BFu0c_F_BFu15s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu16i()
{
  {
    init_simple_test("BFu0c_F_BFu16i");
    static BFu0c_F_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_F_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_F_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu16i(Test_BFu0c_F_BFu16i, "BFu0c_F_BFu16i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu16ll()
{
  {
    init_simple_test("BFu0c_F_BFu16ll");
    static BFu0c_F_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_F_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_F_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu16ll(Test_BFu0c_F_BFu16ll, "BFu0c_F_BFu16ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu16s()
{
  {
    init_simple_test("BFu0c_F_BFu16s");
    static BFu0c_F_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_F_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_F_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu16s(Test_BFu0c_F_BFu16s, "BFu0c_F_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu17i()
{
  {
    init_simple_test("BFu0c_F_BFu17i");
    static BFu0c_F_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(BFu0c_F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_F_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_F_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu17i(Test_BFu0c_F_BFu17i, "BFu0c_F_BFu17i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu17ll()
{
  {
    init_simple_test("BFu0c_F_BFu17ll");
    static BFu0c_F_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu0c_F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_F_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_F_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu17ll(Test_BFu0c_F_BFu17ll, "BFu0c_F_BFu17ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu1c()
{
  {
    init_simple_test("BFu0c_F_BFu1c");
    static BFu0c_F_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_F_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu1c(Test_BFu0c_F_BFu1c, "BFu0c_F_BFu1c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu1i()
{
  {
    init_simple_test("BFu0c_F_BFu1i");
    static BFu0c_F_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_F_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu1i(Test_BFu0c_F_BFu1i, "BFu0c_F_BFu1i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu1ll()
{
  {
    init_simple_test("BFu0c_F_BFu1ll");
    static BFu0c_F_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_F_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu1ll(Test_BFu0c_F_BFu1ll, "BFu0c_F_BFu1ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu1s()
{
  {
    init_simple_test("BFu0c_F_BFu1s");
    static BFu0c_F_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_F_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu1s(Test_BFu0c_F_BFu1s, "BFu0c_F_BFu1s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu31i()
{
  {
    init_simple_test("BFu0c_F_BFu31i");
    static BFu0c_F_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_F_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_F_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu31i(Test_BFu0c_F_BFu31i, "BFu0c_F_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu31ll()
{
  {
    init_simple_test("BFu0c_F_BFu31ll");
    static BFu0c_F_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_F_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_F_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu31ll(Test_BFu0c_F_BFu31ll, "BFu0c_F_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu32i()
{
  {
    init_simple_test("BFu0c_F_BFu32i");
    static BFu0c_F_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_F_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_F_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu32i(Test_BFu0c_F_BFu32i, "BFu0c_F_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu32ll()
{
  {
    init_simple_test("BFu0c_F_BFu32ll");
    static BFu0c_F_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_F_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_F_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu32ll(Test_BFu0c_F_BFu32ll, "BFu0c_F_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu33()
{
  {
    init_simple_test("BFu0c_F_BFu33");
    static BFu0c_F_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "BFu0c_F_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "BFu0c_F_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu33(Test_BFu0c_F_BFu33, "BFu0c_F_BFu33", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu7c()
{
  {
    init_simple_test("BFu0c_F_BFu7c");
    static BFu0c_F_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_F_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_F_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu7c(Test_BFu0c_F_BFu7c, "BFu0c_F_BFu7c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu7i()
{
  {
    init_simple_test("BFu0c_F_BFu7i");
    static BFu0c_F_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_F_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_F_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu7i(Test_BFu0c_F_BFu7i, "BFu0c_F_BFu7i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu7ll()
{
  {
    init_simple_test("BFu0c_F_BFu7ll");
    static BFu0c_F_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_F_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_F_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu7ll(Test_BFu0c_F_BFu7ll, "BFu0c_F_BFu7ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu7s()
{
  {
    init_simple_test("BFu0c_F_BFu7s");
    static BFu0c_F_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_F_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_F_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu7s(Test_BFu0c_F_BFu7s, "BFu0c_F_BFu7s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu8c()
{
  {
    init_simple_test("BFu0c_F_BFu8c");
    static BFu0c_F_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_F_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_F_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu8c(Test_BFu0c_F_BFu8c, "BFu0c_F_BFu8c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu8i()
{
  {
    init_simple_test("BFu0c_F_BFu8i");
    static BFu0c_F_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_F_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_F_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu8i(Test_BFu0c_F_BFu8i, "BFu0c_F_BFu8i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu8ll()
{
  {
    init_simple_test("BFu0c_F_BFu8ll");
    static BFu0c_F_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_F_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_F_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu8ll(Test_BFu0c_F_BFu8ll, "BFu0c_F_BFu8ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu8s()
{
  {
    init_simple_test("BFu0c_F_BFu8s");
    static BFu0c_F_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_F_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_F_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu8s(Test_BFu0c_F_BFu8s, "BFu0c_F_BFu8s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu9i()
{
  {
    init_simple_test("BFu0c_F_BFu9i");
    static BFu0c_F_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_F_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_F_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_F_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu9i(Test_BFu0c_F_BFu9i, "BFu0c_F_BFu9i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu9ll()
{
  {
    init_simple_test("BFu0c_F_BFu9ll");
    static BFu0c_F_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_F_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_F_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_F_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu9ll(Test_BFu0c_F_BFu9ll, "BFu0c_F_BFu9ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_BFu9s()
{
  {
    init_simple_test("BFu0c_F_BFu9s");
    static BFu0c_F_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_F_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0c_F_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_F_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_F_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_F_BFu9s(Test_BFu0c_F_BFu9s, "BFu0c_F_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_C()
{
  {
    init_simple_test("BFu0c_F_C");
    static BFu0c_F_C lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_C)");
    check_field_offset(lv, v1, 0, "BFu0c_F_C.v1");
    check_field_offset(lv, v2, 4, "BFu0c_F_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_F_C(Test_BFu0c_F_C, "BFu0c_F_C", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_D()
{
  {
    init_simple_test("BFu0c_F_D");
    static BFu0c_F_D lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_F_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_D)");
    check_field_offset(lv, v1, 0, "BFu0c_F_D.v1");
    check_field_offset(lv, v2, 4, "BFu0c_F_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_F_D(Test_BFu0c_F_D, "BFu0c_F_D", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_F()
{
  {
    init_simple_test("BFu0c_F_F");
    static BFu0c_F_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_F_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_F)");
    check_field_offset(lv, v1, 0, "BFu0c_F_F.v1");
    check_field_offset(lv, v2, 4, "BFu0c_F_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_F_F(Test_BFu0c_F_F, "BFu0c_F_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_I()
{
  {
    init_simple_test("BFu0c_F_I");
    static BFu0c_F_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_F_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_I)");
    check_field_offset(lv, v1, 0, "BFu0c_F_I.v1");
    check_field_offset(lv, v2, 4, "BFu0c_F_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_F_I(Test_BFu0c_F_I, "BFu0c_F_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_Ip()
{
  {
    init_simple_test("BFu0c_F_Ip");
    static BFu0c_F_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_F_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_F_Ip.v1");
    check_field_offset(lv, v2, 4, "BFu0c_F_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_F_Ip(Test_BFu0c_F_Ip, "BFu0c_F_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_L()
{
  {
    init_simple_test("BFu0c_F_L");
    static BFu0c_F_L lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_F_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_L)");
    check_field_offset(lv, v1, 0, "BFu0c_F_L.v1");
    check_field_offset(lv, v2, 4, "BFu0c_F_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_F_L(Test_BFu0c_F_L, "BFu0c_F_L", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_S()
{
  {
    init_simple_test("BFu0c_F_S");
    static BFu0c_F_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_F_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_S)");
    check_field_offset(lv, v1, 0, "BFu0c_F_S.v1");
    check_field_offset(lv, v2, 4, "BFu0c_F_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_F_S(Test_BFu0c_F_S, "BFu0c_F_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_Uc()
{
  {
    init_simple_test("BFu0c_F_Uc");
    static BFu0c_F_Uc lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_F_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_F_Uc.v1");
    check_field_offset(lv, v2, 4, "BFu0c_F_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_F_Uc(Test_BFu0c_F_Uc, "BFu0c_F_Uc", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_Ui()
{
  {
    init_simple_test("BFu0c_F_Ui");
    static BFu0c_F_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_F_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_F_Ui.v1");
    check_field_offset(lv, v2, 4, "BFu0c_F_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_F_Ui(Test_BFu0c_F_Ui, "BFu0c_F_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_Ul()
{
  {
    init_simple_test("BFu0c_F_Ul");
    static BFu0c_F_Ul lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_F_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_F_Ul.v1");
    check_field_offset(lv, v2, 4, "BFu0c_F_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_F_Ul(Test_BFu0c_F_Ul, "BFu0c_F_Ul", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_Us()
{
  {
    init_simple_test("BFu0c_F_Us");
    static BFu0c_F_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_F_Us.v1");
    check_field_offset(lv, v2, 4, "BFu0c_F_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_F_Us(Test_BFu0c_F_Us, "BFu0c_F_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_F_Vp()
{
  {
    init_simple_test("BFu0c_F_Vp");
    static BFu0c_F_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_F_Vp.v1");
    check_field_offset(lv, v2, 4, "BFu0c_F_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_F_Vp(Test_BFu0c_F_Vp, "BFu0c_F_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I()
{
  {
    init_simple_test("BFu0c_I");
    static BFu0c_I lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I)");
    check_field_offset(lv, v1, 0, "BFu0c_I.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_I(Test_BFu0c_I, "BFu0c_I", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu0c()
{
  {
    init_simple_test("BFu0c_I_BFu0c");
    static BFu0c_I_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_I_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu0c(Test_BFu0c_I_BFu0c, "BFu0c_I_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu0i()
{
  {
    init_simple_test("BFu0c_I_BFu0i");
    static BFu0c_I_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_I_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_I_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu0i(Test_BFu0c_I_BFu0i, "BFu0c_I_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu0ll()
{
  {
    init_simple_test("BFu0c_I_BFu0ll");
    static BFu0c_I_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu0ll(Test_BFu0c_I_BFu0ll, "BFu0c_I_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu0s()
{
  {
    init_simple_test("BFu0c_I_BFu0s");
    static BFu0c_I_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_I_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_I_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu0s(Test_BFu0c_I_BFu0s, "BFu0c_I_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu15i()
{
  {
    init_simple_test("BFu0c_I_BFu15i");
    static BFu0c_I_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_I_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_I_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu15i(Test_BFu0c_I_BFu15i, "BFu0c_I_BFu15i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu15ll()
{
  {
    init_simple_test("BFu0c_I_BFu15ll");
    static BFu0c_I_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_I_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_I_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu15ll(Test_BFu0c_I_BFu15ll, "BFu0c_I_BFu15ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu15s()
{
  {
    init_simple_test("BFu0c_I_BFu15s");
    static BFu0c_I_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_I_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_I_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu15s(Test_BFu0c_I_BFu15s, "BFu0c_I_BFu15s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu16i()
{
  {
    init_simple_test("BFu0c_I_BFu16i");
    static BFu0c_I_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_I_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_I_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu16i(Test_BFu0c_I_BFu16i, "BFu0c_I_BFu16i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu16ll()
{
  {
    init_simple_test("BFu0c_I_BFu16ll");
    static BFu0c_I_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_I_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_I_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu16ll(Test_BFu0c_I_BFu16ll, "BFu0c_I_BFu16ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu16s()
{
  {
    init_simple_test("BFu0c_I_BFu16s");
    static BFu0c_I_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_I_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_I_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu16s(Test_BFu0c_I_BFu16s, "BFu0c_I_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu17i()
{
  {
    init_simple_test("BFu0c_I_BFu17i");
    static BFu0c_I_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(BFu0c_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_I_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_I_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu17i(Test_BFu0c_I_BFu17i, "BFu0c_I_BFu17i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu17ll()
{
  {
    init_simple_test("BFu0c_I_BFu17ll");
    static BFu0c_I_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu0c_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_I_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_I_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu17ll(Test_BFu0c_I_BFu17ll, "BFu0c_I_BFu17ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu1c()
{
  {
    init_simple_test("BFu0c_I_BFu1c");
    static BFu0c_I_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_I_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu1c(Test_BFu0c_I_BFu1c, "BFu0c_I_BFu1c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu1i()
{
  {
    init_simple_test("BFu0c_I_BFu1i");
    static BFu0c_I_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_I_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu1i(Test_BFu0c_I_BFu1i, "BFu0c_I_BFu1i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu1ll()
{
  {
    init_simple_test("BFu0c_I_BFu1ll");
    static BFu0c_I_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_I_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu1ll(Test_BFu0c_I_BFu1ll, "BFu0c_I_BFu1ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu1s()
{
  {
    init_simple_test("BFu0c_I_BFu1s");
    static BFu0c_I_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_I_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu1s(Test_BFu0c_I_BFu1s, "BFu0c_I_BFu1s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu31i()
{
  {
    init_simple_test("BFu0c_I_BFu31i");
    static BFu0c_I_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_I_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_I_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu31i(Test_BFu0c_I_BFu31i, "BFu0c_I_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu31ll()
{
  {
    init_simple_test("BFu0c_I_BFu31ll");
    static BFu0c_I_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_I_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_I_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu31ll(Test_BFu0c_I_BFu31ll, "BFu0c_I_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu32i()
{
  {
    init_simple_test("BFu0c_I_BFu32i");
    static BFu0c_I_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_I_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_I_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu32i(Test_BFu0c_I_BFu32i, "BFu0c_I_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu32ll()
{
  {
    init_simple_test("BFu0c_I_BFu32ll");
    static BFu0c_I_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_I_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_I_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu32ll(Test_BFu0c_I_BFu32ll, "BFu0c_I_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu33()
{
  {
    init_simple_test("BFu0c_I_BFu33");
    static BFu0c_I_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "BFu0c_I_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "BFu0c_I_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu33(Test_BFu0c_I_BFu33, "BFu0c_I_BFu33", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu7c()
{
  {
    init_simple_test("BFu0c_I_BFu7c");
    static BFu0c_I_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_I_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_I_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu7c(Test_BFu0c_I_BFu7c, "BFu0c_I_BFu7c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu7i()
{
  {
    init_simple_test("BFu0c_I_BFu7i");
    static BFu0c_I_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_I_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_I_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu7i(Test_BFu0c_I_BFu7i, "BFu0c_I_BFu7i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu7ll()
{
  {
    init_simple_test("BFu0c_I_BFu7ll");
    static BFu0c_I_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_I_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_I_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu7ll(Test_BFu0c_I_BFu7ll, "BFu0c_I_BFu7ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu7s()
{
  {
    init_simple_test("BFu0c_I_BFu7s");
    static BFu0c_I_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_I_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_I_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu7s(Test_BFu0c_I_BFu7s, "BFu0c_I_BFu7s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu8c()
{
  {
    init_simple_test("BFu0c_I_BFu8c");
    static BFu0c_I_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_I_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_I_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu8c(Test_BFu0c_I_BFu8c, "BFu0c_I_BFu8c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu8i()
{
  {
    init_simple_test("BFu0c_I_BFu8i");
    static BFu0c_I_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_I_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_I_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu8i(Test_BFu0c_I_BFu8i, "BFu0c_I_BFu8i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu8ll()
{
  {
    init_simple_test("BFu0c_I_BFu8ll");
    static BFu0c_I_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_I_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_I_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu8ll(Test_BFu0c_I_BFu8ll, "BFu0c_I_BFu8ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu8s()
{
  {
    init_simple_test("BFu0c_I_BFu8s");
    static BFu0c_I_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_I_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_I_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu8s(Test_BFu0c_I_BFu8s, "BFu0c_I_BFu8s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu9i()
{
  {
    init_simple_test("BFu0c_I_BFu9i");
    static BFu0c_I_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_I_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_I_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu9i(Test_BFu0c_I_BFu9i, "BFu0c_I_BFu9i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu9ll()
{
  {
    init_simple_test("BFu0c_I_BFu9ll");
    static BFu0c_I_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_I_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_I_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu9ll(Test_BFu0c_I_BFu9ll, "BFu0c_I_BFu9ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_BFu9s()
{
  {
    init_simple_test("BFu0c_I_BFu9s");
    static BFu0c_I_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0c_I_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_I_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_I_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_I_BFu9s(Test_BFu0c_I_BFu9s, "BFu0c_I_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_C()
{
  {
    init_simple_test("BFu0c_I_C");
    static BFu0c_I_C lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_C)");
    check_field_offset(lv, v1, 0, "BFu0c_I_C.v1");
    check_field_offset(lv, v2, 4, "BFu0c_I_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_I_C(Test_BFu0c_I_C, "BFu0c_I_C", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_D()
{
  {
    init_simple_test("BFu0c_I_D");
    static BFu0c_I_D lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_D)");
    check_field_offset(lv, v1, 0, "BFu0c_I_D.v1");
    check_field_offset(lv, v2, 4, "BFu0c_I_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_I_D(Test_BFu0c_I_D, "BFu0c_I_D", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_F()
{
  {
    init_simple_test("BFu0c_I_F");
    static BFu0c_I_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_F)");
    check_field_offset(lv, v1, 0, "BFu0c_I_F.v1");
    check_field_offset(lv, v2, 4, "BFu0c_I_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_I_F(Test_BFu0c_I_F, "BFu0c_I_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_I()
{
  {
    init_simple_test("BFu0c_I_I");
    static BFu0c_I_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_I)");
    check_field_offset(lv, v1, 0, "BFu0c_I_I.v1");
    check_field_offset(lv, v2, 4, "BFu0c_I_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_I_I(Test_BFu0c_I_I, "BFu0c_I_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_Ip()
{
  {
    init_simple_test("BFu0c_I_Ip");
    static BFu0c_I_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_I_Ip.v1");
    check_field_offset(lv, v2, 4, "BFu0c_I_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_I_Ip(Test_BFu0c_I_Ip, "BFu0c_I_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_L()
{
  {
    init_simple_test("BFu0c_I_L");
    static BFu0c_I_L lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_L)");
    check_field_offset(lv, v1, 0, "BFu0c_I_L.v1");
    check_field_offset(lv, v2, 4, "BFu0c_I_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_I_L(Test_BFu0c_I_L, "BFu0c_I_L", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_S()
{
  {
    init_simple_test("BFu0c_I_S");
    static BFu0c_I_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_S)");
    check_field_offset(lv, v1, 0, "BFu0c_I_S.v1");
    check_field_offset(lv, v2, 4, "BFu0c_I_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_I_S(Test_BFu0c_I_S, "BFu0c_I_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_Uc()
{
  {
    init_simple_test("BFu0c_I_Uc");
    static BFu0c_I_Uc lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_I_Uc.v1");
    check_field_offset(lv, v2, 4, "BFu0c_I_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_I_Uc(Test_BFu0c_I_Uc, "BFu0c_I_Uc", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_Ui()
{
  {
    init_simple_test("BFu0c_I_Ui");
    static BFu0c_I_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_I_Ui.v1");
    check_field_offset(lv, v2, 4, "BFu0c_I_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_I_Ui(Test_BFu0c_I_Ui, "BFu0c_I_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_Ul()
{
  {
    init_simple_test("BFu0c_I_Ul");
    static BFu0c_I_Ul lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_I_Ul.v1");
    check_field_offset(lv, v2, 4, "BFu0c_I_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_I_Ul(Test_BFu0c_I_Ul, "BFu0c_I_Ul", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_Us()
{
  {
    init_simple_test("BFu0c_I_Us");
    static BFu0c_I_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_I_Us.v1");
    check_field_offset(lv, v2, 4, "BFu0c_I_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_I_Us(Test_BFu0c_I_Us, "BFu0c_I_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_I_Vp()
{
  {
    init_simple_test("BFu0c_I_Vp");
    static BFu0c_I_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_I_Vp.v1");
    check_field_offset(lv, v2, 4, "BFu0c_I_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_I_Vp(Test_BFu0c_I_Vp, "BFu0c_I_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip()
{
  {
    init_simple_test("BFu0c_Ip");
    static BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip(Test_BFu0c_Ip, "BFu0c_Ip", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu0c()
{
  {
    init_simple_test("BFu0c_Ip_BFu0c");
    static BFu0c_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Ip_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu0c(Test_BFu0c_Ip_BFu0c, "BFu0c_Ip_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu0i()
{
  {
    init_simple_test("BFu0c_Ip_BFu0i");
    static BFu0c_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu0i(Test_BFu0c_Ip_BFu0i, "BFu0c_Ip_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu0ll()
{
  {
    init_simple_test("BFu0c_Ip_BFu0ll");
    static BFu0c_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Ip_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu0ll(Test_BFu0c_Ip_BFu0ll, "BFu0c_Ip_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu0s()
{
  {
    init_simple_test("BFu0c_Ip_BFu0s");
    static BFu0c_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Ip_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu0s(Test_BFu0c_Ip_BFu0s, "BFu0c_Ip_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu15i()
{
  {
    init_simple_test("BFu0c_Ip_BFu15i");
    static BFu0c_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0c_Ip_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0c_Ip_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu15i(Test_BFu0c_Ip_BFu15i, "BFu0c_Ip_BFu15i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu15ll()
{
  {
    init_simple_test("BFu0c_Ip_BFu15ll");
    static BFu0c_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0c_Ip_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0c_Ip_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu15ll(Test_BFu0c_Ip_BFu15ll, "BFu0c_Ip_BFu15ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu15s()
{
  {
    init_simple_test("BFu0c_Ip_BFu15s");
    static BFu0c_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0c_Ip_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0c_Ip_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu15s(Test_BFu0c_Ip_BFu15s, "BFu0c_Ip_BFu15s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu16i()
{
  {
    init_simple_test("BFu0c_Ip_BFu16i");
    static BFu0c_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0c_Ip_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0c_Ip_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu16i(Test_BFu0c_Ip_BFu16i, "BFu0c_Ip_BFu16i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu16ll()
{
  {
    init_simple_test("BFu0c_Ip_BFu16ll");
    static BFu0c_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0c_Ip_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0c_Ip_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu16ll(Test_BFu0c_Ip_BFu16ll, "BFu0c_Ip_BFu16ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu16s()
{
  {
    init_simple_test("BFu0c_Ip_BFu16s");
    static BFu0c_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0c_Ip_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0c_Ip_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu16s(Test_BFu0c_Ip_BFu16s, "BFu0c_Ip_BFu16s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu17i()
{
  {
    init_simple_test("BFu0c_Ip_BFu17i");
    static BFu0c_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu0c_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu0c_Ip_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu0c_Ip_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu17i(Test_BFu0c_Ip_BFu17i, "BFu0c_Ip_BFu17i", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu17ll()
{
  {
    init_simple_test("BFu0c_Ip_BFu17ll");
    static BFu0c_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu0c_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu0c_Ip_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu0c_Ip_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu17ll(Test_BFu0c_Ip_BFu17ll, "BFu0c_Ip_BFu17ll", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu1c()
{
  {
    init_simple_test("BFu0c_Ip_BFu1c");
    static BFu0c_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0c_Ip_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu1c(Test_BFu0c_Ip_BFu1c, "BFu0c_Ip_BFu1c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu1i()
{
  {
    init_simple_test("BFu0c_Ip_BFu1i");
    static BFu0c_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0c_Ip_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu1i(Test_BFu0c_Ip_BFu1i, "BFu0c_Ip_BFu1i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu1ll()
{
  {
    init_simple_test("BFu0c_Ip_BFu1ll");
    static BFu0c_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0c_Ip_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu1ll(Test_BFu0c_Ip_BFu1ll, "BFu0c_Ip_BFu1ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu1s()
{
  {
    init_simple_test("BFu0c_Ip_BFu1s");
    static BFu0c_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0c_Ip_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu1s(Test_BFu0c_Ip_BFu1s, "BFu0c_Ip_BFu1s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu31i()
{
  {
    init_simple_test("BFu0c_Ip_BFu31i");
    static BFu0c_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu0c_Ip_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu0c_Ip_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu31i(Test_BFu0c_Ip_BFu31i, "BFu0c_Ip_BFu31i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu31ll()
{
  {
    init_simple_test("BFu0c_Ip_BFu31ll");
    static BFu0c_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu0c_Ip_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu0c_Ip_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu31ll(Test_BFu0c_Ip_BFu31ll, "BFu0c_Ip_BFu31ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu32i()
{
  {
    init_simple_test("BFu0c_Ip_BFu32i");
    static BFu0c_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu0c_Ip_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu0c_Ip_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu32i(Test_BFu0c_Ip_BFu32i, "BFu0c_Ip_BFu32i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu32ll()
{
  {
    init_simple_test("BFu0c_Ip_BFu32ll");
    static BFu0c_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu0c_Ip_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu0c_Ip_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu32ll(Test_BFu0c_Ip_BFu32ll, "BFu0c_Ip_BFu32ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu33()
{
  {
    init_simple_test("BFu0c_Ip_BFu33");
    static BFu0c_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu0c_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0c_Ip_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0c_Ip_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu33(Test_BFu0c_Ip_BFu33, "BFu0c_Ip_BFu33", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu7c()
{
  {
    init_simple_test("BFu0c_Ip_BFu7c");
    static BFu0c_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0c_Ip_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0c_Ip_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu7c(Test_BFu0c_Ip_BFu7c, "BFu0c_Ip_BFu7c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu7i()
{
  {
    init_simple_test("BFu0c_Ip_BFu7i");
    static BFu0c_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0c_Ip_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0c_Ip_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu7i(Test_BFu0c_Ip_BFu7i, "BFu0c_Ip_BFu7i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu7ll()
{
  {
    init_simple_test("BFu0c_Ip_BFu7ll");
    static BFu0c_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0c_Ip_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0c_Ip_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu7ll(Test_BFu0c_Ip_BFu7ll, "BFu0c_Ip_BFu7ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu7s()
{
  {
    init_simple_test("BFu0c_Ip_BFu7s");
    static BFu0c_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0c_Ip_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0c_Ip_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu7s(Test_BFu0c_Ip_BFu7s, "BFu0c_Ip_BFu7s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu8c()
{
  {
    init_simple_test("BFu0c_Ip_BFu8c");
    static BFu0c_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0c_Ip_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0c_Ip_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu8c(Test_BFu0c_Ip_BFu8c, "BFu0c_Ip_BFu8c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu8i()
{
  {
    init_simple_test("BFu0c_Ip_BFu8i");
    static BFu0c_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0c_Ip_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0c_Ip_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu8i(Test_BFu0c_Ip_BFu8i, "BFu0c_Ip_BFu8i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu8ll()
{
  {
    init_simple_test("BFu0c_Ip_BFu8ll");
    static BFu0c_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0c_Ip_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0c_Ip_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu8ll(Test_BFu0c_Ip_BFu8ll, "BFu0c_Ip_BFu8ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu8s()
{
  {
    init_simple_test("BFu0c_Ip_BFu8s");
    static BFu0c_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0c_Ip_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0c_Ip_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu8s(Test_BFu0c_Ip_BFu8s, "BFu0c_Ip_BFu8s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu9i()
{
  {
    init_simple_test("BFu0c_Ip_BFu9i");
    static BFu0c_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0c_Ip_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0c_Ip_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu9i(Test_BFu0c_Ip_BFu9i, "BFu0c_Ip_BFu9i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu9ll()
{
  {
    init_simple_test("BFu0c_Ip_BFu9ll");
    static BFu0c_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0c_Ip_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0c_Ip_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu9ll(Test_BFu0c_Ip_BFu9ll, "BFu0c_Ip_BFu9ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_BFu9s()
{
  {
    init_simple_test("BFu0c_Ip_BFu9s");
    static BFu0c_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0c_Ip_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0c_Ip_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_BFu9s(Test_BFu0c_Ip_BFu9s, "BFu0c_Ip_BFu9s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_C()
{
  {
    init_simple_test("BFu0c_Ip_C");
    static BFu0c_Ip_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_C)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Ip_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_C(Test_BFu0c_Ip_C, "BFu0c_Ip_C", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_D()
{
  {
    init_simple_test("BFu0c_Ip_D");
    static BFu0c_Ip_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_D)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Ip_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_D(Test_BFu0c_Ip_D, "BFu0c_Ip_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_F()
{
  {
    init_simple_test("BFu0c_Ip_F");
    static BFu0c_Ip_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_F)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Ip_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_F(Test_BFu0c_Ip_F, "BFu0c_Ip_F", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_I()
{
  {
    init_simple_test("BFu0c_Ip_I");
    static BFu0c_Ip_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_I)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Ip_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_I(Test_BFu0c_Ip_I, "BFu0c_Ip_I", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_Ip()
{
  {
    init_simple_test("BFu0c_Ip_Ip");
    static BFu0c_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Ip_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_Ip(Test_BFu0c_Ip_Ip, "BFu0c_Ip_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_L()
{
  {
    init_simple_test("BFu0c_Ip_L");
    static BFu0c_Ip_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_L)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Ip_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_L(Test_BFu0c_Ip_L, "BFu0c_Ip_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_S()
{
  {
    init_simple_test("BFu0c_Ip_S");
    static BFu0c_Ip_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_S)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Ip_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_S(Test_BFu0c_Ip_S, "BFu0c_Ip_S", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_Uc()
{
  {
    init_simple_test("BFu0c_Ip_Uc");
    static BFu0c_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Ip_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_Uc(Test_BFu0c_Ip_Uc, "BFu0c_Ip_Uc", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_Ui()
{
  {
    init_simple_test("BFu0c_Ip_Ui");
    static BFu0c_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Ip_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_Ui(Test_BFu0c_Ip_Ui, "BFu0c_Ip_Ui", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_Ul()
{
  {
    init_simple_test("BFu0c_Ip_Ul");
    static BFu0c_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Ip_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_Ul(Test_BFu0c_Ip_Ul, "BFu0c_Ip_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_Us()
{
  {
    init_simple_test("BFu0c_Ip_Us");
    static BFu0c_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Ip_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_Us(Test_BFu0c_Ip_Us, "BFu0c_Ip_Us", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ip_Vp()
{
  {
    init_simple_test("BFu0c_Ip_Vp");
    static BFu0c_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Ip_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ip_Vp(Test_BFu0c_Ip_Vp, "BFu0c_Ip_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L()
{
  {
    init_simple_test("BFu0c_L");
    static BFu0c_L lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L)");
    check_field_offset(lv, v1, 0, "BFu0c_L.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_L(Test_BFu0c_L, "BFu0c_L", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu0c()
{
  {
    init_simple_test("BFu0c_L_BFu0c");
    static BFu0c_L_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_L_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu0c(Test_BFu0c_L_BFu0c, "BFu0c_L_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu0i()
{
  {
    init_simple_test("BFu0c_L_BFu0i");
    static BFu0c_L_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_L_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu0i(Test_BFu0c_L_BFu0i, "BFu0c_L_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu0ll()
{
  {
    init_simple_test("BFu0c_L_BFu0ll");
    static BFu0c_L_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_L_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu0ll(Test_BFu0c_L_BFu0ll, "BFu0c_L_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu0s()
{
  {
    init_simple_test("BFu0c_L_BFu0s");
    static BFu0c_L_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_L_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu0s(Test_BFu0c_L_BFu0s, "BFu0c_L_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu15i()
{
  {
    init_simple_test("BFu0c_L_BFu15i");
    static BFu0c_L_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0c_L_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0c_L_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu15i(Test_BFu0c_L_BFu15i, "BFu0c_L_BFu15i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu15ll()
{
  {
    init_simple_test("BFu0c_L_BFu15ll");
    static BFu0c_L_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0c_L_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0c_L_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu15ll(Test_BFu0c_L_BFu15ll, "BFu0c_L_BFu15ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu15s()
{
  {
    init_simple_test("BFu0c_L_BFu15s");
    static BFu0c_L_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0c_L_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0c_L_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu15s(Test_BFu0c_L_BFu15s, "BFu0c_L_BFu15s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu16i()
{
  {
    init_simple_test("BFu0c_L_BFu16i");
    static BFu0c_L_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0c_L_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0c_L_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu16i(Test_BFu0c_L_BFu16i, "BFu0c_L_BFu16i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu16ll()
{
  {
    init_simple_test("BFu0c_L_BFu16ll");
    static BFu0c_L_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0c_L_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0c_L_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu16ll(Test_BFu0c_L_BFu16ll, "BFu0c_L_BFu16ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu16s()
{
  {
    init_simple_test("BFu0c_L_BFu16s");
    static BFu0c_L_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0c_L_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0c_L_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu16s(Test_BFu0c_L_BFu16s, "BFu0c_L_BFu16s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu17i()
{
  {
    init_simple_test("BFu0c_L_BFu17i");
    static BFu0c_L_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(BFu0c_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0c_L_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0c_L_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu17i(Test_BFu0c_L_BFu17i, "BFu0c_L_BFu17i", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu17ll()
{
  {
    init_simple_test("BFu0c_L_BFu17ll");
    static BFu0c_L_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu0c_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0c_L_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0c_L_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu17ll(Test_BFu0c_L_BFu17ll, "BFu0c_L_BFu17ll", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu1c()
{
  {
    init_simple_test("BFu0c_L_BFu1c");
    static BFu0c_L_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0c_L_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu1c(Test_BFu0c_L_BFu1c, "BFu0c_L_BFu1c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu1i()
{
  {
    init_simple_test("BFu0c_L_BFu1i");
    static BFu0c_L_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0c_L_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu1i(Test_BFu0c_L_BFu1i, "BFu0c_L_BFu1i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu1ll()
{
  {
    init_simple_test("BFu0c_L_BFu1ll");
    static BFu0c_L_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0c_L_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu1ll(Test_BFu0c_L_BFu1ll, "BFu0c_L_BFu1ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu1s()
{
  {
    init_simple_test("BFu0c_L_BFu1s");
    static BFu0c_L_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0c_L_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu1s(Test_BFu0c_L_BFu1s, "BFu0c_L_BFu1s", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu31i()
{
  {
    init_simple_test("BFu0c_L_BFu31i");
    static BFu0c_L_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0c_L_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0c_L_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu31i(Test_BFu0c_L_BFu31i, "BFu0c_L_BFu31i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu31ll()
{
  {
    init_simple_test("BFu0c_L_BFu31ll");
    static BFu0c_L_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0c_L_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0c_L_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu31ll(Test_BFu0c_L_BFu31ll, "BFu0c_L_BFu31ll", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu32i()
{
  {
    init_simple_test("BFu0c_L_BFu32i");
    static BFu0c_L_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0c_L_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0c_L_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu32i(Test_BFu0c_L_BFu32i, "BFu0c_L_BFu32i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu32ll()
{
  {
    init_simple_test("BFu0c_L_BFu32ll");
    static BFu0c_L_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0c_L_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0c_L_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu32ll(Test_BFu0c_L_BFu32ll, "BFu0c_L_BFu32ll", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu33()
{
  {
    init_simple_test("BFu0c_L_BFu33");
    static BFu0c_L_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(BFu0c_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "BFu0c_L_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "BFu0c_L_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu33(Test_BFu0c_L_BFu33, "BFu0c_L_BFu33", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu7c()
{
  {
    init_simple_test("BFu0c_L_BFu7c");
    static BFu0c_L_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0c_L_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0c_L_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu7c(Test_BFu0c_L_BFu7c, "BFu0c_L_BFu7c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu7i()
{
  {
    init_simple_test("BFu0c_L_BFu7i");
    static BFu0c_L_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0c_L_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0c_L_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu7i(Test_BFu0c_L_BFu7i, "BFu0c_L_BFu7i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu7ll()
{
  {
    init_simple_test("BFu0c_L_BFu7ll");
    static BFu0c_L_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0c_L_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0c_L_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu7ll(Test_BFu0c_L_BFu7ll, "BFu0c_L_BFu7ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu7s()
{
  {
    init_simple_test("BFu0c_L_BFu7s");
    static BFu0c_L_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0c_L_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0c_L_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu7s(Test_BFu0c_L_BFu7s, "BFu0c_L_BFu7s", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu8c()
{
  {
    init_simple_test("BFu0c_L_BFu8c");
    static BFu0c_L_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0c_L_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0c_L_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu8c(Test_BFu0c_L_BFu8c, "BFu0c_L_BFu8c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu8i()
{
  {
    init_simple_test("BFu0c_L_BFu8i");
    static BFu0c_L_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0c_L_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0c_L_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu8i(Test_BFu0c_L_BFu8i, "BFu0c_L_BFu8i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu8ll()
{
  {
    init_simple_test("BFu0c_L_BFu8ll");
    static BFu0c_L_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0c_L_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0c_L_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu8ll(Test_BFu0c_L_BFu8ll, "BFu0c_L_BFu8ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu8s()
{
  {
    init_simple_test("BFu0c_L_BFu8s");
    static BFu0c_L_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0c_L_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0c_L_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu8s(Test_BFu0c_L_BFu8s, "BFu0c_L_BFu8s", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu9i()
{
  {
    init_simple_test("BFu0c_L_BFu9i");
    static BFu0c_L_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0c_L_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0c_L_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu9i(Test_BFu0c_L_BFu9i, "BFu0c_L_BFu9i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu9ll()
{
  {
    init_simple_test("BFu0c_L_BFu9ll");
    static BFu0c_L_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0c_L_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0c_L_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu9ll(Test_BFu0c_L_BFu9ll, "BFu0c_L_BFu9ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_BFu9s()
{
  {
    init_simple_test("BFu0c_L_BFu9s");
    static BFu0c_L_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0c_L_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0c_L_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0c_L_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_L_BFu9s(Test_BFu0c_L_BFu9s, "BFu0c_L_BFu9s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_C()
{
  {
    init_simple_test("BFu0c_L_C");
    static BFu0c_L_C lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_C)");
    check_field_offset(lv, v1, 0, "BFu0c_L_C.v1");
    check_field_offset(lv, v2, 8, "BFu0c_L_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_L_C(Test_BFu0c_L_C, "BFu0c_L_C", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_D()
{
  {
    init_simple_test("BFu0c_L_D");
    static BFu0c_L_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu0c_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_D)");
    check_field_offset(lv, v1, 0, "BFu0c_L_D.v1");
    check_field_offset(lv, v2, 8, "BFu0c_L_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_L_D(Test_BFu0c_L_D, "BFu0c_L_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_F()
{
  {
    init_simple_test("BFu0c_L_F");
    static BFu0c_L_F lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_F)");
    check_field_offset(lv, v1, 0, "BFu0c_L_F.v1");
    check_field_offset(lv, v2, 8, "BFu0c_L_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_L_F(Test_BFu0c_L_F, "BFu0c_L_F", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_I()
{
  {
    init_simple_test("BFu0c_L_I");
    static BFu0c_L_I lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_I)");
    check_field_offset(lv, v1, 0, "BFu0c_L_I.v1");
    check_field_offset(lv, v2, 8, "BFu0c_L_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_L_I(Test_BFu0c_L_I, "BFu0c_L_I", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_Ip()
{
  {
    init_simple_test("BFu0c_L_Ip");
    static BFu0c_L_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_L_Ip.v1");
    check_field_offset(lv, v2, 8, "BFu0c_L_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_L_Ip(Test_BFu0c_L_Ip, "BFu0c_L_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_L()
{
  {
    init_simple_test("BFu0c_L_L");
    static BFu0c_L_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu0c_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_L)");
    check_field_offset(lv, v1, 0, "BFu0c_L_L.v1");
    check_field_offset(lv, v2, 8, "BFu0c_L_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_L_L(Test_BFu0c_L_L, "BFu0c_L_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_S()
{
  {
    init_simple_test("BFu0c_L_S");
    static BFu0c_L_S lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_S)");
    check_field_offset(lv, v1, 0, "BFu0c_L_S.v1");
    check_field_offset(lv, v2, 8, "BFu0c_L_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_L_S(Test_BFu0c_L_S, "BFu0c_L_S", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_Uc()
{
  {
    init_simple_test("BFu0c_L_Uc");
    static BFu0c_L_Uc lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_L_Uc.v1");
    check_field_offset(lv, v2, 8, "BFu0c_L_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_L_Uc(Test_BFu0c_L_Uc, "BFu0c_L_Uc", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_Ui()
{
  {
    init_simple_test("BFu0c_L_Ui");
    static BFu0c_L_Ui lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_L_Ui.v1");
    check_field_offset(lv, v2, 8, "BFu0c_L_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_L_Ui(Test_BFu0c_L_Ui, "BFu0c_L_Ui", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_Ul()
{
  {
    init_simple_test("BFu0c_L_Ul");
    static BFu0c_L_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu0c_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_L_Ul.v1");
    check_field_offset(lv, v2, 8, "BFu0c_L_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_L_Ul(Test_BFu0c_L_Ul, "BFu0c_L_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_Us()
{
  {
    init_simple_test("BFu0c_L_Us");
    static BFu0c_L_Us lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_L_Us.v1");
    check_field_offset(lv, v2, 8, "BFu0c_L_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_L_Us(Test_BFu0c_L_Us, "BFu0c_L_Us", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_L_Vp()
{
  {
    init_simple_test("BFu0c_L_Vp");
    static BFu0c_L_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_L_Vp.v1");
    check_field_offset(lv, v2, 8, "BFu0c_L_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_L_Vp(Test_BFu0c_L_Vp, "BFu0c_L_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S()
{
  {
    init_simple_test("BFu0c_S");
    static BFu0c_S lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S)");
    check_field_offset(lv, v1, 0, "BFu0c_S.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_S(Test_BFu0c_S, "BFu0c_S", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu0c()
{
  {
    init_simple_test("BFu0c_S_BFu0c");
    static BFu0c_S_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_S_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu0c(Test_BFu0c_S_BFu0c, "BFu0c_S_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu0i()
{
  {
    init_simple_test("BFu0c_S_BFu0i");
    static BFu0c_S_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_S_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_S_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu0i(Test_BFu0c_S_BFu0i, "BFu0c_S_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu0ll()
{
  {
    init_simple_test("BFu0c_S_BFu0ll");
    static BFu0c_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_S_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu0ll(Test_BFu0c_S_BFu0ll, "BFu0c_S_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu0s()
{
  {
    init_simple_test("BFu0c_S_BFu0s");
    static BFu0c_S_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_S_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_S_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu0s(Test_BFu0c_S_BFu0s, "BFu0c_S_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu15i()
{
  {
    init_simple_test("BFu0c_S_BFu15i");
    static BFu0c_S_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_S_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_S_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu15i(Test_BFu0c_S_BFu15i, "BFu0c_S_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu15ll()
{
  {
    init_simple_test("BFu0c_S_BFu15ll");
    static BFu0c_S_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_S_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_S_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu15ll(Test_BFu0c_S_BFu15ll, "BFu0c_S_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu15s()
{
  {
    init_simple_test("BFu0c_S_BFu15s");
    static BFu0c_S_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_S_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_S_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu15s(Test_BFu0c_S_BFu15s, "BFu0c_S_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu16i()
{
  {
    init_simple_test("BFu0c_S_BFu16i");
    static BFu0c_S_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_S_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_S_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu16i(Test_BFu0c_S_BFu16i, "BFu0c_S_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu16ll()
{
  {
    init_simple_test("BFu0c_S_BFu16ll");
    static BFu0c_S_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_S_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_S_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu16ll(Test_BFu0c_S_BFu16ll, "BFu0c_S_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu16s()
{
  {
    init_simple_test("BFu0c_S_BFu16s");
    static BFu0c_S_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_S_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_S_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu16s(Test_BFu0c_S_BFu16s, "BFu0c_S_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu17i()
{
  {
    init_simple_test("BFu0c_S_BFu17i");
    static BFu0c_S_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu0c_S_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu0c_S_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu17i(Test_BFu0c_S_BFu17i, "BFu0c_S_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu17ll()
{
  {
    init_simple_test("BFu0c_S_BFu17ll");
    static BFu0c_S_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu0c_S_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu0c_S_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu17ll(Test_BFu0c_S_BFu17ll, "BFu0c_S_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu1c()
{
  {
    init_simple_test("BFu0c_S_BFu1c");
    static BFu0c_S_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_S_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu1c(Test_BFu0c_S_BFu1c, "BFu0c_S_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu1i()
{
  {
    init_simple_test("BFu0c_S_BFu1i");
    static BFu0c_S_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_S_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu1i(Test_BFu0c_S_BFu1i, "BFu0c_S_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu1ll()
{
  {
    init_simple_test("BFu0c_S_BFu1ll");
    static BFu0c_S_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_S_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu1ll(Test_BFu0c_S_BFu1ll, "BFu0c_S_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu1s()
{
  {
    init_simple_test("BFu0c_S_BFu1s");
    static BFu0c_S_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_S_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu1s(Test_BFu0c_S_BFu1s, "BFu0c_S_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu31i()
{
  {
    init_simple_test("BFu0c_S_BFu31i");
    static BFu0c_S_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu0c_S_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu0c_S_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu31i(Test_BFu0c_S_BFu31i, "BFu0c_S_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu31ll()
{
  {
    init_simple_test("BFu0c_S_BFu31ll");
    static BFu0c_S_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu0c_S_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu0c_S_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu31ll(Test_BFu0c_S_BFu31ll, "BFu0c_S_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu32i()
{
  {
    init_simple_test("BFu0c_S_BFu32i");
    static BFu0c_S_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu0c_S_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu0c_S_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu32i(Test_BFu0c_S_BFu32i, "BFu0c_S_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu32ll()
{
  {
    init_simple_test("BFu0c_S_BFu32ll");
    static BFu0c_S_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu0c_S_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu0c_S_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu32ll(Test_BFu0c_S_BFu32ll, "BFu0c_S_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu33()
{
  {
    init_simple_test("BFu0c_S_BFu33");
    static BFu0c_S_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu0c_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu0c_S_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu0c_S_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu33(Test_BFu0c_S_BFu33, "BFu0c_S_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu7c()
{
  {
    init_simple_test("BFu0c_S_BFu7c");
    static BFu0c_S_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_S_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_S_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu7c(Test_BFu0c_S_BFu7c, "BFu0c_S_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu7i()
{
  {
    init_simple_test("BFu0c_S_BFu7i");
    static BFu0c_S_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_S_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_S_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu7i(Test_BFu0c_S_BFu7i, "BFu0c_S_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu7ll()
{
  {
    init_simple_test("BFu0c_S_BFu7ll");
    static BFu0c_S_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_S_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_S_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu7ll(Test_BFu0c_S_BFu7ll, "BFu0c_S_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu7s()
{
  {
    init_simple_test("BFu0c_S_BFu7s");
    static BFu0c_S_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_S_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_S_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu7s(Test_BFu0c_S_BFu7s, "BFu0c_S_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu8c()
{
  {
    init_simple_test("BFu0c_S_BFu8c");
    static BFu0c_S_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_S_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_S_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu8c(Test_BFu0c_S_BFu8c, "BFu0c_S_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu8i()
{
  {
    init_simple_test("BFu0c_S_BFu8i");
    static BFu0c_S_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_S_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_S_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu8i(Test_BFu0c_S_BFu8i, "BFu0c_S_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu8ll()
{
  {
    init_simple_test("BFu0c_S_BFu8ll");
    static BFu0c_S_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_S_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_S_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu8ll(Test_BFu0c_S_BFu8ll, "BFu0c_S_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu8s()
{
  {
    init_simple_test("BFu0c_S_BFu8s");
    static BFu0c_S_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_S_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_S_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu8s(Test_BFu0c_S_BFu8s, "BFu0c_S_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu9i()
{
  {
    init_simple_test("BFu0c_S_BFu9i");
    static BFu0c_S_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_S_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_S_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu9i(Test_BFu0c_S_BFu9i, "BFu0c_S_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu9ll()
{
  {
    init_simple_test("BFu0c_S_BFu9ll");
    static BFu0c_S_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_S_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_S_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu9ll(Test_BFu0c_S_BFu9ll, "BFu0c_S_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_BFu9s()
{
  {
    init_simple_test("BFu0c_S_BFu9s");
    static BFu0c_S_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0c_S_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_S_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_S_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_S_BFu9s(Test_BFu0c_S_BFu9s, "BFu0c_S_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_C()
{
  {
    init_simple_test("BFu0c_S_C");
    static BFu0c_S_C lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_C)");
    check_field_offset(lv, v1, 0, "BFu0c_S_C.v1");
    check_field_offset(lv, v2, 2, "BFu0c_S_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_S_C(Test_BFu0c_S_C, "BFu0c_S_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_D()
{
  {
    init_simple_test("BFu0c_S_D");
    static BFu0c_S_D lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_D)");
    check_field_offset(lv, v1, 0, "BFu0c_S_D.v1");
    check_field_offset(lv, v2, 2, "BFu0c_S_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_S_D(Test_BFu0c_S_D, "BFu0c_S_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_F()
{
  {
    init_simple_test("BFu0c_S_F");
    static BFu0c_S_F lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_F)");
    check_field_offset(lv, v1, 0, "BFu0c_S_F.v1");
    check_field_offset(lv, v2, 2, "BFu0c_S_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_S_F(Test_BFu0c_S_F, "BFu0c_S_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_I()
{
  {
    init_simple_test("BFu0c_S_I");
    static BFu0c_S_I lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_I)");
    check_field_offset(lv, v1, 0, "BFu0c_S_I.v1");
    check_field_offset(lv, v2, 2, "BFu0c_S_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_S_I(Test_BFu0c_S_I, "BFu0c_S_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_Ip()
{
  {
    init_simple_test("BFu0c_S_Ip");
    static BFu0c_S_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_S_Ip.v1");
    check_field_offset(lv, v2, 2, "BFu0c_S_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_S_Ip(Test_BFu0c_S_Ip, "BFu0c_S_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_L()
{
  {
    init_simple_test("BFu0c_S_L");
    static BFu0c_S_L lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_L)");
    check_field_offset(lv, v1, 0, "BFu0c_S_L.v1");
    check_field_offset(lv, v2, 2, "BFu0c_S_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_S_L(Test_BFu0c_S_L, "BFu0c_S_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_S()
{
  {
    init_simple_test("BFu0c_S_S");
    static BFu0c_S_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_S)");
    check_field_offset(lv, v1, 0, "BFu0c_S_S.v1");
    check_field_offset(lv, v2, 2, "BFu0c_S_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_S_S(Test_BFu0c_S_S, "BFu0c_S_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_Uc()
{
  {
    init_simple_test("BFu0c_S_Uc");
    static BFu0c_S_Uc lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_S_Uc.v1");
    check_field_offset(lv, v2, 2, "BFu0c_S_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_S_Uc(Test_BFu0c_S_Uc, "BFu0c_S_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_Ui()
{
  {
    init_simple_test("BFu0c_S_Ui");
    static BFu0c_S_Ui lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_S_Ui.v1");
    check_field_offset(lv, v2, 2, "BFu0c_S_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_S_Ui(Test_BFu0c_S_Ui, "BFu0c_S_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_Ul()
{
  {
    init_simple_test("BFu0c_S_Ul");
    static BFu0c_S_Ul lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_S_Ul.v1");
    check_field_offset(lv, v2, 2, "BFu0c_S_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_S_Ul(Test_BFu0c_S_Ul, "BFu0c_S_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_Us()
{
  {
    init_simple_test("BFu0c_S_Us");
    static BFu0c_S_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_S_Us.v1");
    check_field_offset(lv, v2, 2, "BFu0c_S_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_S_Us(Test_BFu0c_S_Us, "BFu0c_S_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_S_Vp()
{
  {
    init_simple_test("BFu0c_S_Vp");
    static BFu0c_S_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_S_Vp.v1");
    check_field_offset(lv, v2, 2, "BFu0c_S_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_S_Vp(Test_BFu0c_S_Vp, "BFu0c_S_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc()
{
  {
    init_simple_test("BFu0c_Uc");
    static BFu0c_Uc lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc(Test_BFu0c_Uc, "BFu0c_Uc", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu0c()
{
  {
    init_simple_test("BFu0c_Uc_BFu0c");
    static BFu0c_Uc_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Uc_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu0c(Test_BFu0c_Uc_BFu0c, "BFu0c_Uc_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu0i()
{
  {
    init_simple_test("BFu0c_Uc_BFu0i");
    static BFu0c_Uc_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_Uc_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Uc_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu0i(Test_BFu0c_Uc_BFu0i, "BFu0c_Uc_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu0ll()
{
  {
    init_simple_test("BFu0c_Uc_BFu0ll");
    static BFu0c_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Uc_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu0ll(Test_BFu0c_Uc_BFu0ll, "BFu0c_Uc_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu0s()
{
  {
    init_simple_test("BFu0c_Uc_BFu0s");
    static BFu0c_Uc_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0c_Uc_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Uc_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu0s(Test_BFu0c_Uc_BFu0s, "BFu0c_Uc_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu15i()
{
  {
    init_simple_test("BFu0c_Uc_BFu15i");
    static BFu0c_Uc_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_Uc_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_Uc_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu15i(Test_BFu0c_Uc_BFu15i, "BFu0c_Uc_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu15ll()
{
  {
    init_simple_test("BFu0c_Uc_BFu15ll");
    static BFu0c_Uc_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_Uc_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_Uc_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu15ll(Test_BFu0c_Uc_BFu15ll, "BFu0c_Uc_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu15s()
{
  {
    init_simple_test("BFu0c_Uc_BFu15s");
    static BFu0c_Uc_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_Uc_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_Uc_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu15s(Test_BFu0c_Uc_BFu15s, "BFu0c_Uc_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu16i()
{
  {
    init_simple_test("BFu0c_Uc_BFu16i");
    static BFu0c_Uc_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_Uc_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_Uc_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu16i(Test_BFu0c_Uc_BFu16i, "BFu0c_Uc_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu16ll()
{
  {
    init_simple_test("BFu0c_Uc_BFu16ll");
    static BFu0c_Uc_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_Uc_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_Uc_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu16ll(Test_BFu0c_Uc_BFu16ll, "BFu0c_Uc_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu16s()
{
  {
    init_simple_test("BFu0c_Uc_BFu16s");
    static BFu0c_Uc_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_Uc_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_Uc_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu16s(Test_BFu0c_Uc_BFu16s, "BFu0c_Uc_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu17i()
{
  {
    init_simple_test("BFu0c_Uc_BFu17i");
    static BFu0c_Uc_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_Uc_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_Uc_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu17i(Test_BFu0c_Uc_BFu17i, "BFu0c_Uc_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu17ll()
{
  {
    init_simple_test("BFu0c_Uc_BFu17ll");
    static BFu0c_Uc_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_Uc_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_Uc_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu17ll(Test_BFu0c_Uc_BFu17ll, "BFu0c_Uc_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu1c()
{
  {
    init_simple_test("BFu0c_Uc_BFu1c");
    static BFu0c_Uc_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_Uc_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu1c(Test_BFu0c_Uc_BFu1c, "BFu0c_Uc_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu1i()
{
  {
    init_simple_test("BFu0c_Uc_BFu1i");
    static BFu0c_Uc_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_Uc_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu1i(Test_BFu0c_Uc_BFu1i, "BFu0c_Uc_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu1ll()
{
  {
    init_simple_test("BFu0c_Uc_BFu1ll");
    static BFu0c_Uc_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_Uc_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu1ll(Test_BFu0c_Uc_BFu1ll, "BFu0c_Uc_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu1s()
{
  {
    init_simple_test("BFu0c_Uc_BFu1s");
    static BFu0c_Uc_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_Uc_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu1s(Test_BFu0c_Uc_BFu1s, "BFu0c_Uc_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu31i()
{
  {
    init_simple_test("BFu0c_Uc_BFu31i");
    static BFu0c_Uc_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_Uc_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_Uc_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu31i(Test_BFu0c_Uc_BFu31i, "BFu0c_Uc_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu31ll()
{
  {
    init_simple_test("BFu0c_Uc_BFu31ll");
    static BFu0c_Uc_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_Uc_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_Uc_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu31ll(Test_BFu0c_Uc_BFu31ll, "BFu0c_Uc_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu32i()
{
  {
    init_simple_test("BFu0c_Uc_BFu32i");
    static BFu0c_Uc_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_Uc_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_Uc_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu32i(Test_BFu0c_Uc_BFu32i, "BFu0c_Uc_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu32ll()
{
  {
    init_simple_test("BFu0c_Uc_BFu32ll");
    static BFu0c_Uc_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_Uc_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_Uc_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu32ll(Test_BFu0c_Uc_BFu32ll, "BFu0c_Uc_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu33()
{
  {
    init_simple_test("BFu0c_Uc_BFu33");
    static BFu0c_Uc_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0c_Uc_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0c_Uc_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu33(Test_BFu0c_Uc_BFu33, "BFu0c_Uc_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu7c()
{
  {
    init_simple_test("BFu0c_Uc_BFu7c");
    static BFu0c_Uc_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_Uc_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_Uc_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu7c(Test_BFu0c_Uc_BFu7c, "BFu0c_Uc_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu7i()
{
  {
    init_simple_test("BFu0c_Uc_BFu7i");
    static BFu0c_Uc_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_Uc_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_Uc_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu7i(Test_BFu0c_Uc_BFu7i, "BFu0c_Uc_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu7ll()
{
  {
    init_simple_test("BFu0c_Uc_BFu7ll");
    static BFu0c_Uc_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_Uc_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_Uc_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu7ll(Test_BFu0c_Uc_BFu7ll, "BFu0c_Uc_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu7s()
{
  {
    init_simple_test("BFu0c_Uc_BFu7s");
    static BFu0c_Uc_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_Uc_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_Uc_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu7s(Test_BFu0c_Uc_BFu7s, "BFu0c_Uc_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu8c()
{
  {
    init_simple_test("BFu0c_Uc_BFu8c");
    static BFu0c_Uc_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_Uc_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_Uc_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu8c(Test_BFu0c_Uc_BFu8c, "BFu0c_Uc_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu8i()
{
  {
    init_simple_test("BFu0c_Uc_BFu8i");
    static BFu0c_Uc_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_Uc_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_Uc_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu8i(Test_BFu0c_Uc_BFu8i, "BFu0c_Uc_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu8ll()
{
  {
    init_simple_test("BFu0c_Uc_BFu8ll");
    static BFu0c_Uc_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_Uc_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_Uc_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu8ll(Test_BFu0c_Uc_BFu8ll, "BFu0c_Uc_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu8s()
{
  {
    init_simple_test("BFu0c_Uc_BFu8s");
    static BFu0c_Uc_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_Uc_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_Uc_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu8s(Test_BFu0c_Uc_BFu8s, "BFu0c_Uc_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu9i()
{
  {
    init_simple_test("BFu0c_Uc_BFu9i");
    static BFu0c_Uc_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_Uc_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_Uc_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu9i(Test_BFu0c_Uc_BFu9i, "BFu0c_Uc_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu9ll()
{
  {
    init_simple_test("BFu0c_Uc_BFu9ll");
    static BFu0c_Uc_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_Uc_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_Uc_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu9ll(Test_BFu0c_Uc_BFu9ll, "BFu0c_Uc_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_BFu9s()
{
  {
    init_simple_test("BFu0c_Uc_BFu9s");
    static BFu0c_Uc_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_Uc_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_Uc_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_BFu9s(Test_BFu0c_Uc_BFu9s, "BFu0c_Uc_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_C()
{
  {
    init_simple_test("BFu0c_Uc_C");
    static BFu0c_Uc_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_C)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_C.v1");
    check_field_offset(lv, v2, 1, "BFu0c_Uc_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_C(Test_BFu0c_Uc_C, "BFu0c_Uc_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_D()
{
  {
    init_simple_test("BFu0c_Uc_D");
    static BFu0c_Uc_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_D)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_D.v1");
    check_field_offset(lv, v2, 1, "BFu0c_Uc_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_D(Test_BFu0c_Uc_D, "BFu0c_Uc_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_F()
{
  {
    init_simple_test("BFu0c_Uc_F");
    static BFu0c_Uc_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_F)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_F.v1");
    check_field_offset(lv, v2, 1, "BFu0c_Uc_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_F(Test_BFu0c_Uc_F, "BFu0c_Uc_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_I()
{
  {
    init_simple_test("BFu0c_Uc_I");
    static BFu0c_Uc_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_I)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_I.v1");
    check_field_offset(lv, v2, 1, "BFu0c_Uc_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_I(Test_BFu0c_Uc_I, "BFu0c_Uc_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_Ip()
{
  {
    init_simple_test("BFu0c_Uc_Ip");
    static BFu0c_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_Ip.v1");
    check_field_offset(lv, v2, 1, "BFu0c_Uc_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_Ip(Test_BFu0c_Uc_Ip, "BFu0c_Uc_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_L()
{
  {
    init_simple_test("BFu0c_Uc_L");
    static BFu0c_Uc_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_L)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_L.v1");
    check_field_offset(lv, v2, 1, "BFu0c_Uc_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_L(Test_BFu0c_Uc_L, "BFu0c_Uc_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_S()
{
  {
    init_simple_test("BFu0c_Uc_S");
    static BFu0c_Uc_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_S)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_S.v1");
    check_field_offset(lv, v2, 1, "BFu0c_Uc_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_S(Test_BFu0c_Uc_S, "BFu0c_Uc_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_Uc()
{
  {
    init_simple_test("BFu0c_Uc_Uc");
    static BFu0c_Uc_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_Uc.v1");
    check_field_offset(lv, v2, 1, "BFu0c_Uc_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_Uc(Test_BFu0c_Uc_Uc, "BFu0c_Uc_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_Ui()
{
  {
    init_simple_test("BFu0c_Uc_Ui");
    static BFu0c_Uc_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_Ui.v1");
    check_field_offset(lv, v2, 1, "BFu0c_Uc_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_Ui(Test_BFu0c_Uc_Ui, "BFu0c_Uc_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_Ul()
{
  {
    init_simple_test("BFu0c_Uc_Ul");
    static BFu0c_Uc_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_Ul.v1");
    check_field_offset(lv, v2, 1, "BFu0c_Uc_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_Ul(Test_BFu0c_Uc_Ul, "BFu0c_Uc_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_Us()
{
  {
    init_simple_test("BFu0c_Uc_Us");
    static BFu0c_Uc_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_Us.v1");
    check_field_offset(lv, v2, 1, "BFu0c_Uc_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_Us(Test_BFu0c_Uc_Us, "BFu0c_Uc_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Uc_Vp()
{
  {
    init_simple_test("BFu0c_Uc_Vp");
    static BFu0c_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_Vp.v1");
    check_field_offset(lv, v2, 1, "BFu0c_Uc_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Uc_Vp(Test_BFu0c_Uc_Vp, "BFu0c_Uc_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui()
{
  {
    init_simple_test("BFu0c_Ui");
    static BFu0c_Ui lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui(Test_BFu0c_Ui, "BFu0c_Ui", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu0c()
{
  {
    init_simple_test("BFu0c_Ui_BFu0c");
    static BFu0c_Ui_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Ui_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu0c(Test_BFu0c_Ui_BFu0c, "BFu0c_Ui_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu0i()
{
  {
    init_simple_test("BFu0c_Ui_BFu0i");
    static BFu0c_Ui_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Ui_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Ui_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu0i(Test_BFu0c_Ui_BFu0i, "BFu0c_Ui_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu0ll()
{
  {
    init_simple_test("BFu0c_Ui_BFu0ll");
    static BFu0c_Ui_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Ui_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu0ll(Test_BFu0c_Ui_BFu0ll, "BFu0c_Ui_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu0s()
{
  {
    init_simple_test("BFu0c_Ui_BFu0s");
    static BFu0c_Ui_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Ui_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Ui_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu0s(Test_BFu0c_Ui_BFu0s, "BFu0c_Ui_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu15i()
{
  {
    init_simple_test("BFu0c_Ui_BFu15i");
    static BFu0c_Ui_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_Ui_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_Ui_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu15i(Test_BFu0c_Ui_BFu15i, "BFu0c_Ui_BFu15i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu15ll()
{
  {
    init_simple_test("BFu0c_Ui_BFu15ll");
    static BFu0c_Ui_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_Ui_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_Ui_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu15ll(Test_BFu0c_Ui_BFu15ll, "BFu0c_Ui_BFu15ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu15s()
{
  {
    init_simple_test("BFu0c_Ui_BFu15s");
    static BFu0c_Ui_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_Ui_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_Ui_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu15s(Test_BFu0c_Ui_BFu15s, "BFu0c_Ui_BFu15s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu16i()
{
  {
    init_simple_test("BFu0c_Ui_BFu16i");
    static BFu0c_Ui_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_Ui_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_Ui_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu16i(Test_BFu0c_Ui_BFu16i, "BFu0c_Ui_BFu16i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu16ll()
{
  {
    init_simple_test("BFu0c_Ui_BFu16ll");
    static BFu0c_Ui_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_Ui_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_Ui_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu16ll(Test_BFu0c_Ui_BFu16ll, "BFu0c_Ui_BFu16ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu16s()
{
  {
    init_simple_test("BFu0c_Ui_BFu16s");
    static BFu0c_Ui_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_Ui_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_Ui_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu16s(Test_BFu0c_Ui_BFu16s, "BFu0c_Ui_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu17i()
{
  {
    init_simple_test("BFu0c_Ui_BFu17i");
    static BFu0c_Ui_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(BFu0c_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_Ui_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_Ui_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu17i(Test_BFu0c_Ui_BFu17i, "BFu0c_Ui_BFu17i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu17ll()
{
  {
    init_simple_test("BFu0c_Ui_BFu17ll");
    static BFu0c_Ui_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu0c_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_Ui_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_Ui_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu17ll(Test_BFu0c_Ui_BFu17ll, "BFu0c_Ui_BFu17ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu1c()
{
  {
    init_simple_test("BFu0c_Ui_BFu1c");
    static BFu0c_Ui_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_Ui_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu1c(Test_BFu0c_Ui_BFu1c, "BFu0c_Ui_BFu1c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu1i()
{
  {
    init_simple_test("BFu0c_Ui_BFu1i");
    static BFu0c_Ui_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_Ui_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu1i(Test_BFu0c_Ui_BFu1i, "BFu0c_Ui_BFu1i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu1ll()
{
  {
    init_simple_test("BFu0c_Ui_BFu1ll");
    static BFu0c_Ui_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_Ui_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu1ll(Test_BFu0c_Ui_BFu1ll, "BFu0c_Ui_BFu1ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu1s()
{
  {
    init_simple_test("BFu0c_Ui_BFu1s");
    static BFu0c_Ui_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_Ui_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu1s(Test_BFu0c_Ui_BFu1s, "BFu0c_Ui_BFu1s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu31i()
{
  {
    init_simple_test("BFu0c_Ui_BFu31i");
    static BFu0c_Ui_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_Ui_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_Ui_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu31i(Test_BFu0c_Ui_BFu31i, "BFu0c_Ui_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu31ll()
{
  {
    init_simple_test("BFu0c_Ui_BFu31ll");
    static BFu0c_Ui_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_Ui_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_Ui_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu31ll(Test_BFu0c_Ui_BFu31ll, "BFu0c_Ui_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu32i()
{
  {
    init_simple_test("BFu0c_Ui_BFu32i");
    static BFu0c_Ui_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_Ui_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_Ui_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu32i(Test_BFu0c_Ui_BFu32i, "BFu0c_Ui_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu32ll()
{
  {
    init_simple_test("BFu0c_Ui_BFu32ll");
    static BFu0c_Ui_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_Ui_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_Ui_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu32ll(Test_BFu0c_Ui_BFu32ll, "BFu0c_Ui_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu33()
{
  {
    init_simple_test("BFu0c_Ui_BFu33");
    static BFu0c_Ui_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "BFu0c_Ui_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "BFu0c_Ui_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu33(Test_BFu0c_Ui_BFu33, "BFu0c_Ui_BFu33", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu7c()
{
  {
    init_simple_test("BFu0c_Ui_BFu7c");
    static BFu0c_Ui_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_Ui_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_Ui_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu7c(Test_BFu0c_Ui_BFu7c, "BFu0c_Ui_BFu7c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu7i()
{
  {
    init_simple_test("BFu0c_Ui_BFu7i");
    static BFu0c_Ui_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_Ui_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_Ui_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu7i(Test_BFu0c_Ui_BFu7i, "BFu0c_Ui_BFu7i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu7ll()
{
  {
    init_simple_test("BFu0c_Ui_BFu7ll");
    static BFu0c_Ui_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_Ui_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_Ui_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu7ll(Test_BFu0c_Ui_BFu7ll, "BFu0c_Ui_BFu7ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu7s()
{
  {
    init_simple_test("BFu0c_Ui_BFu7s");
    static BFu0c_Ui_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_Ui_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_Ui_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu7s(Test_BFu0c_Ui_BFu7s, "BFu0c_Ui_BFu7s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu8c()
{
  {
    init_simple_test("BFu0c_Ui_BFu8c");
    static BFu0c_Ui_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_Ui_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_Ui_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu8c(Test_BFu0c_Ui_BFu8c, "BFu0c_Ui_BFu8c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu8i()
{
  {
    init_simple_test("BFu0c_Ui_BFu8i");
    static BFu0c_Ui_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_Ui_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_Ui_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu8i(Test_BFu0c_Ui_BFu8i, "BFu0c_Ui_BFu8i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu8ll()
{
  {
    init_simple_test("BFu0c_Ui_BFu8ll");
    static BFu0c_Ui_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_Ui_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_Ui_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu8ll(Test_BFu0c_Ui_BFu8ll, "BFu0c_Ui_BFu8ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu8s()
{
  {
    init_simple_test("BFu0c_Ui_BFu8s");
    static BFu0c_Ui_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_Ui_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_Ui_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu8s(Test_BFu0c_Ui_BFu8s, "BFu0c_Ui_BFu8s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu9i()
{
  {
    init_simple_test("BFu0c_Ui_BFu9i");
    static BFu0c_Ui_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_Ui_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_Ui_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu9i(Test_BFu0c_Ui_BFu9i, "BFu0c_Ui_BFu9i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu9ll()
{
  {
    init_simple_test("BFu0c_Ui_BFu9ll");
    static BFu0c_Ui_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_Ui_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_Ui_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu9ll(Test_BFu0c_Ui_BFu9ll, "BFu0c_Ui_BFu9ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_BFu9s()
{
  {
    init_simple_test("BFu0c_Ui_BFu9s");
    static BFu0c_Ui_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_Ui_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_Ui_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_BFu9s(Test_BFu0c_Ui_BFu9s, "BFu0c_Ui_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_C()
{
  {
    init_simple_test("BFu0c_Ui_C");
    static BFu0c_Ui_C lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_C)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_C.v1");
    check_field_offset(lv, v2, 4, "BFu0c_Ui_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_C(Test_BFu0c_Ui_C, "BFu0c_Ui_C", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_D()
{
  {
    init_simple_test("BFu0c_Ui_D");
    static BFu0c_Ui_D lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_D)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_D.v1");
    check_field_offset(lv, v2, 4, "BFu0c_Ui_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_D(Test_BFu0c_Ui_D, "BFu0c_Ui_D", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_F()
{
  {
    init_simple_test("BFu0c_Ui_F");
    static BFu0c_Ui_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_F)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_F.v1");
    check_field_offset(lv, v2, 4, "BFu0c_Ui_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_F(Test_BFu0c_Ui_F, "BFu0c_Ui_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_I()
{
  {
    init_simple_test("BFu0c_Ui_I");
    static BFu0c_Ui_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_I)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_I.v1");
    check_field_offset(lv, v2, 4, "BFu0c_Ui_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_I(Test_BFu0c_Ui_I, "BFu0c_Ui_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_Ip()
{
  {
    init_simple_test("BFu0c_Ui_Ip");
    static BFu0c_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_Ip.v1");
    check_field_offset(lv, v2, 4, "BFu0c_Ui_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_Ip(Test_BFu0c_Ui_Ip, "BFu0c_Ui_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_L()
{
  {
    init_simple_test("BFu0c_Ui_L");
    static BFu0c_Ui_L lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_L)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_L.v1");
    check_field_offset(lv, v2, 4, "BFu0c_Ui_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_L(Test_BFu0c_Ui_L, "BFu0c_Ui_L", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_S()
{
  {
    init_simple_test("BFu0c_Ui_S");
    static BFu0c_Ui_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_S)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_S.v1");
    check_field_offset(lv, v2, 4, "BFu0c_Ui_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_S(Test_BFu0c_Ui_S, "BFu0c_Ui_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_Uc()
{
  {
    init_simple_test("BFu0c_Ui_Uc");
    static BFu0c_Ui_Uc lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_Uc.v1");
    check_field_offset(lv, v2, 4, "BFu0c_Ui_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_Uc(Test_BFu0c_Ui_Uc, "BFu0c_Ui_Uc", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_Ui()
{
  {
    init_simple_test("BFu0c_Ui_Ui");
    static BFu0c_Ui_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_Ui.v1");
    check_field_offset(lv, v2, 4, "BFu0c_Ui_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_Ui(Test_BFu0c_Ui_Ui, "BFu0c_Ui_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_Ul()
{
  {
    init_simple_test("BFu0c_Ui_Ul");
    static BFu0c_Ui_Ul lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_Ul.v1");
    check_field_offset(lv, v2, 4, "BFu0c_Ui_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_Ul(Test_BFu0c_Ui_Ul, "BFu0c_Ui_Ul", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_Us()
{
  {
    init_simple_test("BFu0c_Ui_Us");
    static BFu0c_Ui_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_Us.v1");
    check_field_offset(lv, v2, 4, "BFu0c_Ui_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_Us(Test_BFu0c_Ui_Us, "BFu0c_Ui_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ui_Vp()
{
  {
    init_simple_test("BFu0c_Ui_Vp");
    static BFu0c_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_Vp.v1");
    check_field_offset(lv, v2, 4, "BFu0c_Ui_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ui_Vp(Test_BFu0c_Ui_Vp, "BFu0c_Ui_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul()
{
  {
    init_simple_test("BFu0c_Ul");
    static BFu0c_Ul lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul(Test_BFu0c_Ul, "BFu0c_Ul", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu0c()
{
  {
    init_simple_test("BFu0c_Ul_BFu0c");
    static BFu0c_Ul_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Ul_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu0c(Test_BFu0c_Ul_BFu0c, "BFu0c_Ul_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu0i()
{
  {
    init_simple_test("BFu0c_Ul_BFu0i");
    static BFu0c_Ul_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Ul_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu0i(Test_BFu0c_Ul_BFu0i, "BFu0c_Ul_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu0ll()
{
  {
    init_simple_test("BFu0c_Ul_BFu0ll");
    static BFu0c_Ul_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Ul_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu0ll(Test_BFu0c_Ul_BFu0ll, "BFu0c_Ul_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu0s()
{
  {
    init_simple_test("BFu0c_Ul_BFu0s");
    static BFu0c_Ul_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Ul_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu0s(Test_BFu0c_Ul_BFu0s, "BFu0c_Ul_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu15i()
{
  {
    init_simple_test("BFu0c_Ul_BFu15i");
    static BFu0c_Ul_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0c_Ul_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0c_Ul_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu15i(Test_BFu0c_Ul_BFu15i, "BFu0c_Ul_BFu15i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu15ll()
{
  {
    init_simple_test("BFu0c_Ul_BFu15ll");
    static BFu0c_Ul_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0c_Ul_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0c_Ul_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu15ll(Test_BFu0c_Ul_BFu15ll, "BFu0c_Ul_BFu15ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu15s()
{
  {
    init_simple_test("BFu0c_Ul_BFu15s");
    static BFu0c_Ul_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0c_Ul_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0c_Ul_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu15s(Test_BFu0c_Ul_BFu15s, "BFu0c_Ul_BFu15s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu16i()
{
  {
    init_simple_test("BFu0c_Ul_BFu16i");
    static BFu0c_Ul_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0c_Ul_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0c_Ul_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu16i(Test_BFu0c_Ul_BFu16i, "BFu0c_Ul_BFu16i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu16ll()
{
  {
    init_simple_test("BFu0c_Ul_BFu16ll");
    static BFu0c_Ul_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0c_Ul_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0c_Ul_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu16ll(Test_BFu0c_Ul_BFu16ll, "BFu0c_Ul_BFu16ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu16s()
{
  {
    init_simple_test("BFu0c_Ul_BFu16s");
    static BFu0c_Ul_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0c_Ul_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0c_Ul_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu16s(Test_BFu0c_Ul_BFu16s, "BFu0c_Ul_BFu16s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu17i()
{
  {
    init_simple_test("BFu0c_Ul_BFu17i");
    static BFu0c_Ul_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(BFu0c_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0c_Ul_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0c_Ul_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu17i(Test_BFu0c_Ul_BFu17i, "BFu0c_Ul_BFu17i", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu17ll()
{
  {
    init_simple_test("BFu0c_Ul_BFu17ll");
    static BFu0c_Ul_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(BFu0c_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0c_Ul_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0c_Ul_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu17ll(Test_BFu0c_Ul_BFu17ll, "BFu0c_Ul_BFu17ll", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu1c()
{
  {
    init_simple_test("BFu0c_Ul_BFu1c");
    static BFu0c_Ul_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0c_Ul_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu1c(Test_BFu0c_Ul_BFu1c, "BFu0c_Ul_BFu1c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu1i()
{
  {
    init_simple_test("BFu0c_Ul_BFu1i");
    static BFu0c_Ul_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0c_Ul_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu1i(Test_BFu0c_Ul_BFu1i, "BFu0c_Ul_BFu1i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu1ll()
{
  {
    init_simple_test("BFu0c_Ul_BFu1ll");
    static BFu0c_Ul_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0c_Ul_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu1ll(Test_BFu0c_Ul_BFu1ll, "BFu0c_Ul_BFu1ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu1s()
{
  {
    init_simple_test("BFu0c_Ul_BFu1s");
    static BFu0c_Ul_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0c_Ul_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu1s(Test_BFu0c_Ul_BFu1s, "BFu0c_Ul_BFu1s", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu31i()
{
  {
    init_simple_test("BFu0c_Ul_BFu31i");
    static BFu0c_Ul_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0c_Ul_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0c_Ul_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu31i(Test_BFu0c_Ul_BFu31i, "BFu0c_Ul_BFu31i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu31ll()
{
  {
    init_simple_test("BFu0c_Ul_BFu31ll");
    static BFu0c_Ul_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0c_Ul_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0c_Ul_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu31ll(Test_BFu0c_Ul_BFu31ll, "BFu0c_Ul_BFu31ll", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu32i()
{
  {
    init_simple_test("BFu0c_Ul_BFu32i");
    static BFu0c_Ul_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0c_Ul_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0c_Ul_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu32i(Test_BFu0c_Ul_BFu32i, "BFu0c_Ul_BFu32i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu32ll()
{
  {
    init_simple_test("BFu0c_Ul_BFu32ll");
    static BFu0c_Ul_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0c_Ul_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0c_Ul_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu32ll(Test_BFu0c_Ul_BFu32ll, "BFu0c_Ul_BFu32ll", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu33()
{
  {
    init_simple_test("BFu0c_Ul_BFu33");
    static BFu0c_Ul_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(BFu0c_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "BFu0c_Ul_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "BFu0c_Ul_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu33(Test_BFu0c_Ul_BFu33, "BFu0c_Ul_BFu33", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu7c()
{
  {
    init_simple_test("BFu0c_Ul_BFu7c");
    static BFu0c_Ul_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0c_Ul_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0c_Ul_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu7c(Test_BFu0c_Ul_BFu7c, "BFu0c_Ul_BFu7c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu7i()
{
  {
    init_simple_test("BFu0c_Ul_BFu7i");
    static BFu0c_Ul_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0c_Ul_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0c_Ul_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu7i(Test_BFu0c_Ul_BFu7i, "BFu0c_Ul_BFu7i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu7ll()
{
  {
    init_simple_test("BFu0c_Ul_BFu7ll");
    static BFu0c_Ul_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0c_Ul_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0c_Ul_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu7ll(Test_BFu0c_Ul_BFu7ll, "BFu0c_Ul_BFu7ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu7s()
{
  {
    init_simple_test("BFu0c_Ul_BFu7s");
    static BFu0c_Ul_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0c_Ul_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0c_Ul_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu7s(Test_BFu0c_Ul_BFu7s, "BFu0c_Ul_BFu7s", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu8c()
{
  {
    init_simple_test("BFu0c_Ul_BFu8c");
    static BFu0c_Ul_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0c_Ul_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0c_Ul_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu8c(Test_BFu0c_Ul_BFu8c, "BFu0c_Ul_BFu8c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu8i()
{
  {
    init_simple_test("BFu0c_Ul_BFu8i");
    static BFu0c_Ul_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0c_Ul_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0c_Ul_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu8i(Test_BFu0c_Ul_BFu8i, "BFu0c_Ul_BFu8i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu8ll()
{
  {
    init_simple_test("BFu0c_Ul_BFu8ll");
    static BFu0c_Ul_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0c_Ul_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0c_Ul_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu8ll(Test_BFu0c_Ul_BFu8ll, "BFu0c_Ul_BFu8ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu8s()
{
  {
    init_simple_test("BFu0c_Ul_BFu8s");
    static BFu0c_Ul_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0c_Ul_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0c_Ul_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu8s(Test_BFu0c_Ul_BFu8s, "BFu0c_Ul_BFu8s", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu9i()
{
  {
    init_simple_test("BFu0c_Ul_BFu9i");
    static BFu0c_Ul_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0c_Ul_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0c_Ul_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu9i(Test_BFu0c_Ul_BFu9i, "BFu0c_Ul_BFu9i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu9ll()
{
  {
    init_simple_test("BFu0c_Ul_BFu9ll");
    static BFu0c_Ul_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0c_Ul_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0c_Ul_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu9ll(Test_BFu0c_Ul_BFu9ll, "BFu0c_Ul_BFu9ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_BFu9s()
{
  {
    init_simple_test("BFu0c_Ul_BFu9s");
    static BFu0c_Ul_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0c_Ul_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0c_Ul_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_BFu9s(Test_BFu0c_Ul_BFu9s, "BFu0c_Ul_BFu9s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_C()
{
  {
    init_simple_test("BFu0c_Ul_C");
    static BFu0c_Ul_C lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_C)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_C.v1");
    check_field_offset(lv, v2, 8, "BFu0c_Ul_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_C(Test_BFu0c_Ul_C, "BFu0c_Ul_C", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_D()
{
  {
    init_simple_test("BFu0c_Ul_D");
    static BFu0c_Ul_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu0c_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_D)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_D.v1");
    check_field_offset(lv, v2, 8, "BFu0c_Ul_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_D(Test_BFu0c_Ul_D, "BFu0c_Ul_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_F()
{
  {
    init_simple_test("BFu0c_Ul_F");
    static BFu0c_Ul_F lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_F)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_F.v1");
    check_field_offset(lv, v2, 8, "BFu0c_Ul_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_F(Test_BFu0c_Ul_F, "BFu0c_Ul_F", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_I()
{
  {
    init_simple_test("BFu0c_Ul_I");
    static BFu0c_Ul_I lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_I)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_I.v1");
    check_field_offset(lv, v2, 8, "BFu0c_Ul_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_I(Test_BFu0c_Ul_I, "BFu0c_Ul_I", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_Ip()
{
  {
    init_simple_test("BFu0c_Ul_Ip");
    static BFu0c_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_Ip.v1");
    check_field_offset(lv, v2, 8, "BFu0c_Ul_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_Ip(Test_BFu0c_Ul_Ip, "BFu0c_Ul_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_L()
{
  {
    init_simple_test("BFu0c_Ul_L");
    static BFu0c_Ul_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu0c_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_L)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_L.v1");
    check_field_offset(lv, v2, 8, "BFu0c_Ul_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_L(Test_BFu0c_Ul_L, "BFu0c_Ul_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_S()
{
  {
    init_simple_test("BFu0c_Ul_S");
    static BFu0c_Ul_S lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_S)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_S.v1");
    check_field_offset(lv, v2, 8, "BFu0c_Ul_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_S(Test_BFu0c_Ul_S, "BFu0c_Ul_S", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_Uc()
{
  {
    init_simple_test("BFu0c_Ul_Uc");
    static BFu0c_Ul_Uc lv;
    check2(sizeof(lv), 9, "sizeof(BFu0c_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_Uc.v1");
    check_field_offset(lv, v2, 8, "BFu0c_Ul_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_Uc(Test_BFu0c_Ul_Uc, "BFu0c_Ul_Uc", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_Ui()
{
  {
    init_simple_test("BFu0c_Ul_Ui");
    static BFu0c_Ul_Ui lv;
    check2(sizeof(lv), 12, "sizeof(BFu0c_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_Ui.v1");
    check_field_offset(lv, v2, 8, "BFu0c_Ul_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_Ui(Test_BFu0c_Ul_Ui, "BFu0c_Ul_Ui", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_Ul()
{
  {
    init_simple_test("BFu0c_Ul_Ul");
    static BFu0c_Ul_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu0c_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_Ul.v1");
    check_field_offset(lv, v2, 8, "BFu0c_Ul_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_Ul(Test_BFu0c_Ul_Ul, "BFu0c_Ul_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_Us()
{
  {
    init_simple_test("BFu0c_Ul_Us");
    static BFu0c_Ul_Us lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_Us.v1");
    check_field_offset(lv, v2, 8, "BFu0c_Ul_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_Us(Test_BFu0c_Ul_Us, "BFu0c_Ul_Us", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Ul_Vp()
{
  {
    init_simple_test("BFu0c_Ul_Vp");
    static BFu0c_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_Vp.v1");
    check_field_offset(lv, v2, 8, "BFu0c_Ul_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Ul_Vp(Test_BFu0c_Ul_Vp, "BFu0c_Ul_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us()
{
  {
    init_simple_test("BFu0c_Us");
    static BFu0c_Us lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_Us.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Us(Test_BFu0c_Us, "BFu0c_Us", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu0c()
{
  {
    init_simple_test("BFu0c_Us_BFu0c");
    static BFu0c_Us_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Us_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu0c(Test_BFu0c_Us_BFu0c, "BFu0c_Us_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu0i()
{
  {
    init_simple_test("BFu0c_Us_BFu0i");
    static BFu0c_Us_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0c_Us_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Us_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu0i(Test_BFu0c_Us_BFu0i, "BFu0c_Us_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu0ll()
{
  {
    init_simple_test("BFu0c_Us_BFu0ll");
    static BFu0c_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Us_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu0ll(Test_BFu0c_Us_BFu0ll, "BFu0c_Us_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu0s()
{
  {
    init_simple_test("BFu0c_Us_BFu0s");
    static BFu0c_Us_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Us_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Us_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu0s(Test_BFu0c_Us_BFu0s, "BFu0c_Us_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu15i()
{
  {
    init_simple_test("BFu0c_Us_BFu15i");
    static BFu0c_Us_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_Us_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_Us_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu15i(Test_BFu0c_Us_BFu15i, "BFu0c_Us_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu15ll()
{
  {
    init_simple_test("BFu0c_Us_BFu15ll");
    static BFu0c_Us_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_Us_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_Us_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu15ll(Test_BFu0c_Us_BFu15ll, "BFu0c_Us_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu15s()
{
  {
    init_simple_test("BFu0c_Us_BFu15s");
    static BFu0c_Us_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_Us_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_Us_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu15s(Test_BFu0c_Us_BFu15s, "BFu0c_Us_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu16i()
{
  {
    init_simple_test("BFu0c_Us_BFu16i");
    static BFu0c_Us_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_Us_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_Us_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu16i(Test_BFu0c_Us_BFu16i, "BFu0c_Us_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu16ll()
{
  {
    init_simple_test("BFu0c_Us_BFu16ll");
    static BFu0c_Us_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_Us_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_Us_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu16ll(Test_BFu0c_Us_BFu16ll, "BFu0c_Us_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu16s()
{
  {
    init_simple_test("BFu0c_Us_BFu16s");
    static BFu0c_Us_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_Us_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_Us_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu16s(Test_BFu0c_Us_BFu16s, "BFu0c_Us_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu17i()
{
  {
    init_simple_test("BFu0c_Us_BFu17i");
    static BFu0c_Us_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu0c_Us_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu0c_Us_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu17i(Test_BFu0c_Us_BFu17i, "BFu0c_Us_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu17ll()
{
  {
    init_simple_test("BFu0c_Us_BFu17ll");
    static BFu0c_Us_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu0c_Us_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu0c_Us_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu17ll(Test_BFu0c_Us_BFu17ll, "BFu0c_Us_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu1c()
{
  {
    init_simple_test("BFu0c_Us_BFu1c");
    static BFu0c_Us_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_Us_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu1c(Test_BFu0c_Us_BFu1c, "BFu0c_Us_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu1i()
{
  {
    init_simple_test("BFu0c_Us_BFu1i");
    static BFu0c_Us_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_Us_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu1i(Test_BFu0c_Us_BFu1i, "BFu0c_Us_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu1ll()
{
  {
    init_simple_test("BFu0c_Us_BFu1ll");
    static BFu0c_Us_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_Us_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu1ll(Test_BFu0c_Us_BFu1ll, "BFu0c_Us_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu1s()
{
  {
    init_simple_test("BFu0c_Us_BFu1s");
    static BFu0c_Us_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_Us_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu1s(Test_BFu0c_Us_BFu1s, "BFu0c_Us_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu31i()
{
  {
    init_simple_test("BFu0c_Us_BFu31i");
    static BFu0c_Us_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu0c_Us_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu0c_Us_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu31i(Test_BFu0c_Us_BFu31i, "BFu0c_Us_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu31ll()
{
  {
    init_simple_test("BFu0c_Us_BFu31ll");
    static BFu0c_Us_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu0c_Us_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu0c_Us_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu31ll(Test_BFu0c_Us_BFu31ll, "BFu0c_Us_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu32i()
{
  {
    init_simple_test("BFu0c_Us_BFu32i");
    static BFu0c_Us_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu0c_Us_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu0c_Us_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu32i(Test_BFu0c_Us_BFu32i, "BFu0c_Us_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu32ll()
{
  {
    init_simple_test("BFu0c_Us_BFu32ll");
    static BFu0c_Us_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu0c_Us_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu0c_Us_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu32ll(Test_BFu0c_Us_BFu32ll, "BFu0c_Us_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu33()
{
  {
    init_simple_test("BFu0c_Us_BFu33");
    static BFu0c_Us_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu0c_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu0c_Us_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu0c_Us_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu33(Test_BFu0c_Us_BFu33, "BFu0c_Us_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu7c()
{
  {
    init_simple_test("BFu0c_Us_BFu7c");
    static BFu0c_Us_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_Us_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_Us_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu7c(Test_BFu0c_Us_BFu7c, "BFu0c_Us_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu7i()
{
  {
    init_simple_test("BFu0c_Us_BFu7i");
    static BFu0c_Us_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_Us_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_Us_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu7i(Test_BFu0c_Us_BFu7i, "BFu0c_Us_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu7ll()
{
  {
    init_simple_test("BFu0c_Us_BFu7ll");
    static BFu0c_Us_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_Us_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_Us_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu7ll(Test_BFu0c_Us_BFu7ll, "BFu0c_Us_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu7s()
{
  {
    init_simple_test("BFu0c_Us_BFu7s");
    static BFu0c_Us_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_Us_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_Us_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu7s(Test_BFu0c_Us_BFu7s, "BFu0c_Us_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu8c()
{
  {
    init_simple_test("BFu0c_Us_BFu8c");
    static BFu0c_Us_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_Us_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_Us_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu8c(Test_BFu0c_Us_BFu8c, "BFu0c_Us_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu8i()
{
  {
    init_simple_test("BFu0c_Us_BFu8i");
    static BFu0c_Us_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_Us_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_Us_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu8i(Test_BFu0c_Us_BFu8i, "BFu0c_Us_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu8ll()
{
  {
    init_simple_test("BFu0c_Us_BFu8ll");
    static BFu0c_Us_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_Us_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_Us_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu8ll(Test_BFu0c_Us_BFu8ll, "BFu0c_Us_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu8s()
{
  {
    init_simple_test("BFu0c_Us_BFu8s");
    static BFu0c_Us_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_Us_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_Us_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu8s(Test_BFu0c_Us_BFu8s, "BFu0c_Us_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu9i()
{
  {
    init_simple_test("BFu0c_Us_BFu9i");
    static BFu0c_Us_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_Us_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_Us_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu9i(Test_BFu0c_Us_BFu9i, "BFu0c_Us_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu9ll()
{
  {
    init_simple_test("BFu0c_Us_BFu9ll");
    static BFu0c_Us_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_Us_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_Us_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu9ll(Test_BFu0c_Us_BFu9ll, "BFu0c_Us_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_BFu9s()
{
  {
    init_simple_test("BFu0c_Us_BFu9s");
    static BFu0c_Us_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_Us_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_Us_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_BFu9s(Test_BFu0c_Us_BFu9s, "BFu0c_Us_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_C()
{
  {
    init_simple_test("BFu0c_Us_C");
    static BFu0c_Us_C lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_C)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_C.v1");
    check_field_offset(lv, v2, 2, "BFu0c_Us_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_C(Test_BFu0c_Us_C, "BFu0c_Us_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_D()
{
  {
    init_simple_test("BFu0c_Us_D");
    static BFu0c_Us_D lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_D)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_D.v1");
    check_field_offset(lv, v2, 2, "BFu0c_Us_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_D(Test_BFu0c_Us_D, "BFu0c_Us_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_F()
{
  {
    init_simple_test("BFu0c_Us_F");
    static BFu0c_Us_F lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_F)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_F.v1");
    check_field_offset(lv, v2, 2, "BFu0c_Us_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_F(Test_BFu0c_Us_F, "BFu0c_Us_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_I()
{
  {
    init_simple_test("BFu0c_Us_I");
    static BFu0c_Us_I lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_I)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_I.v1");
    check_field_offset(lv, v2, 2, "BFu0c_Us_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_I(Test_BFu0c_Us_I, "BFu0c_Us_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_Ip()
{
  {
    init_simple_test("BFu0c_Us_Ip");
    static BFu0c_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_Ip.v1");
    check_field_offset(lv, v2, 2, "BFu0c_Us_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_Ip(Test_BFu0c_Us_Ip, "BFu0c_Us_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_L()
{
  {
    init_simple_test("BFu0c_Us_L");
    static BFu0c_Us_L lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_L)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_L.v1");
    check_field_offset(lv, v2, 2, "BFu0c_Us_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_L(Test_BFu0c_Us_L, "BFu0c_Us_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_S()
{
  {
    init_simple_test("BFu0c_Us_S");
    static BFu0c_Us_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_S)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_S.v1");
    check_field_offset(lv, v2, 2, "BFu0c_Us_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_S(Test_BFu0c_Us_S, "BFu0c_Us_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_Uc()
{
  {
    init_simple_test("BFu0c_Us_Uc");
    static BFu0c_Us_Uc lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_Uc.v1");
    check_field_offset(lv, v2, 2, "BFu0c_Us_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_Uc(Test_BFu0c_Us_Uc, "BFu0c_Us_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_Ui()
{
  {
    init_simple_test("BFu0c_Us_Ui");
    static BFu0c_Us_Ui lv;
    check2(sizeof(lv), 6, "sizeof(BFu0c_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_Ui.v1");
    check_field_offset(lv, v2, 2, "BFu0c_Us_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_Ui(Test_BFu0c_Us_Ui, "BFu0c_Us_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_Ul()
{
  {
    init_simple_test("BFu0c_Us_Ul");
    static BFu0c_Us_Ul lv;
    check2(sizeof(lv), 10, "sizeof(BFu0c_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_Ul.v1");
    check_field_offset(lv, v2, 2, "BFu0c_Us_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_Ul(Test_BFu0c_Us_Ul, "BFu0c_Us_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_Us()
{
  {
    init_simple_test("BFu0c_Us_Us");
    static BFu0c_Us_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_Us.v1");
    check_field_offset(lv, v2, 2, "BFu0c_Us_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_Us(Test_BFu0c_Us_Us, "BFu0c_Us_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Us_Vp()
{
  {
    init_simple_test("BFu0c_Us_Vp");
    static BFu0c_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_Vp.v1");
    check_field_offset(lv, v2, 2, "BFu0c_Us_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Us_Vp(Test_BFu0c_Us_Vp, "BFu0c_Us_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp()
{
  {
    init_simple_test("BFu0c_Vp");
    static BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp(Test_BFu0c_Vp, "BFu0c_Vp", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu0c()
{
  {
    init_simple_test("BFu0c_Vp_BFu0c");
    static BFu0c_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Vp_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu0c(Test_BFu0c_Vp_BFu0c, "BFu0c_Vp_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu0i()
{
  {
    init_simple_test("BFu0c_Vp_BFu0i");
    static BFu0c_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Vp_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu0i(Test_BFu0c_Vp_BFu0i, "BFu0c_Vp_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu0ll()
{
  {
    init_simple_test("BFu0c_Vp_BFu0ll");
    static BFu0c_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Vp_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu0ll(Test_BFu0c_Vp_BFu0ll, "BFu0c_Vp_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu0s()
{
  {
    init_simple_test("BFu0c_Vp_BFu0s");
    static BFu0c_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Vp_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu0s(Test_BFu0c_Vp_BFu0s, "BFu0c_Vp_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu15i()
{
  {
    init_simple_test("BFu0c_Vp_BFu15i");
    static BFu0c_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0c_Vp_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0c_Vp_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu15i(Test_BFu0c_Vp_BFu15i, "BFu0c_Vp_BFu15i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu15ll()
{
  {
    init_simple_test("BFu0c_Vp_BFu15ll");
    static BFu0c_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0c_Vp_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0c_Vp_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu15ll(Test_BFu0c_Vp_BFu15ll, "BFu0c_Vp_BFu15ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu15s()
{
  {
    init_simple_test("BFu0c_Vp_BFu15s");
    static BFu0c_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0c_Vp_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0c_Vp_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu15s(Test_BFu0c_Vp_BFu15s, "BFu0c_Vp_BFu15s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu16i()
{
  {
    init_simple_test("BFu0c_Vp_BFu16i");
    static BFu0c_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0c_Vp_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0c_Vp_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu16i(Test_BFu0c_Vp_BFu16i, "BFu0c_Vp_BFu16i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu16ll()
{
  {
    init_simple_test("BFu0c_Vp_BFu16ll");
    static BFu0c_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0c_Vp_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0c_Vp_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu16ll(Test_BFu0c_Vp_BFu16ll, "BFu0c_Vp_BFu16ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu16s()
{
  {
    init_simple_test("BFu0c_Vp_BFu16s");
    static BFu0c_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0c_Vp_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0c_Vp_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu16s(Test_BFu0c_Vp_BFu16s, "BFu0c_Vp_BFu16s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu17i()
{
  {
    init_simple_test("BFu0c_Vp_BFu17i");
    static BFu0c_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu0c_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu0c_Vp_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu0c_Vp_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu17i(Test_BFu0c_Vp_BFu17i, "BFu0c_Vp_BFu17i", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu17ll()
{
  {
    init_simple_test("BFu0c_Vp_BFu17ll");
    static BFu0c_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(BFu0c_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu0c_Vp_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu0c_Vp_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu17ll(Test_BFu0c_Vp_BFu17ll, "BFu0c_Vp_BFu17ll", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu1c()
{
  {
    init_simple_test("BFu0c_Vp_BFu1c");
    static BFu0c_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0c_Vp_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu1c(Test_BFu0c_Vp_BFu1c, "BFu0c_Vp_BFu1c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu1i()
{
  {
    init_simple_test("BFu0c_Vp_BFu1i");
    static BFu0c_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0c_Vp_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu1i(Test_BFu0c_Vp_BFu1i, "BFu0c_Vp_BFu1i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu1ll()
{
  {
    init_simple_test("BFu0c_Vp_BFu1ll");
    static BFu0c_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0c_Vp_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu1ll(Test_BFu0c_Vp_BFu1ll, "BFu0c_Vp_BFu1ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu1s()
{
  {
    init_simple_test("BFu0c_Vp_BFu1s");
    static BFu0c_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0c_Vp_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu1s(Test_BFu0c_Vp_BFu1s, "BFu0c_Vp_BFu1s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu31i()
{
  {
    init_simple_test("BFu0c_Vp_BFu31i");
    static BFu0c_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu0c_Vp_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu0c_Vp_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu31i(Test_BFu0c_Vp_BFu31i, "BFu0c_Vp_BFu31i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu31ll()
{
  {
    init_simple_test("BFu0c_Vp_BFu31ll");
    static BFu0c_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu0c_Vp_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu0c_Vp_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu31ll(Test_BFu0c_Vp_BFu31ll, "BFu0c_Vp_BFu31ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu32i()
{
  {
    init_simple_test("BFu0c_Vp_BFu32i");
    static BFu0c_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu0c_Vp_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu0c_Vp_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu32i(Test_BFu0c_Vp_BFu32i, "BFu0c_Vp_BFu32i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu32ll()
{
  {
    init_simple_test("BFu0c_Vp_BFu32ll");
    static BFu0c_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu0c_Vp_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu0c_Vp_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu32ll(Test_BFu0c_Vp_BFu32ll, "BFu0c_Vp_BFu32ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu33()
{
  {
    init_simple_test("BFu0c_Vp_BFu33");
    static BFu0c_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu0c_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0c_Vp_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0c_Vp_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu33(Test_BFu0c_Vp_BFu33, "BFu0c_Vp_BFu33", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu7c()
{
  {
    init_simple_test("BFu0c_Vp_BFu7c");
    static BFu0c_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0c_Vp_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0c_Vp_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu7c(Test_BFu0c_Vp_BFu7c, "BFu0c_Vp_BFu7c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu7i()
{
  {
    init_simple_test("BFu0c_Vp_BFu7i");
    static BFu0c_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0c_Vp_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0c_Vp_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu7i(Test_BFu0c_Vp_BFu7i, "BFu0c_Vp_BFu7i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu7ll()
{
  {
    init_simple_test("BFu0c_Vp_BFu7ll");
    static BFu0c_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0c_Vp_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0c_Vp_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu7ll(Test_BFu0c_Vp_BFu7ll, "BFu0c_Vp_BFu7ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu7s()
{
  {
    init_simple_test("BFu0c_Vp_BFu7s");
    static BFu0c_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0c_Vp_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0c_Vp_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu7s(Test_BFu0c_Vp_BFu7s, "BFu0c_Vp_BFu7s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu8c()
{
  {
    init_simple_test("BFu0c_Vp_BFu8c");
    static BFu0c_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0c_Vp_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0c_Vp_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu8c(Test_BFu0c_Vp_BFu8c, "BFu0c_Vp_BFu8c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu8i()
{
  {
    init_simple_test("BFu0c_Vp_BFu8i");
    static BFu0c_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0c_Vp_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0c_Vp_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu8i(Test_BFu0c_Vp_BFu8i, "BFu0c_Vp_BFu8i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu8ll()
{
  {
    init_simple_test("BFu0c_Vp_BFu8ll");
    static BFu0c_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0c_Vp_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0c_Vp_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu8ll(Test_BFu0c_Vp_BFu8ll, "BFu0c_Vp_BFu8ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu8s()
{
  {
    init_simple_test("BFu0c_Vp_BFu8s");
    static BFu0c_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0c_Vp_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0c_Vp_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu8s(Test_BFu0c_Vp_BFu8s, "BFu0c_Vp_BFu8s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu9i()
{
  {
    init_simple_test("BFu0c_Vp_BFu9i");
    static BFu0c_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0c_Vp_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0c_Vp_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu9i(Test_BFu0c_Vp_BFu9i, "BFu0c_Vp_BFu9i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu9ll()
{
  {
    init_simple_test("BFu0c_Vp_BFu9ll");
    static BFu0c_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0c_Vp_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0c_Vp_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu9ll(Test_BFu0c_Vp_BFu9ll, "BFu0c_Vp_BFu9ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_BFu9s()
{
  {
    init_simple_test("BFu0c_Vp_BFu9s");
    static BFu0c_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0c_Vp_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0c_Vp_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_BFu9s(Test_BFu0c_Vp_BFu9s, "BFu0c_Vp_BFu9s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_C()
{
  {
    init_simple_test("BFu0c_Vp_C");
    static BFu0c_Vp_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_C)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Vp_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_C(Test_BFu0c_Vp_C, "BFu0c_Vp_C", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_D()
{
  {
    init_simple_test("BFu0c_Vp_D");
    static BFu0c_Vp_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_D)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Vp_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_D(Test_BFu0c_Vp_D, "BFu0c_Vp_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_F()
{
  {
    init_simple_test("BFu0c_Vp_F");
    static BFu0c_Vp_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_F)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Vp_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_F(Test_BFu0c_Vp_F, "BFu0c_Vp_F", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_I()
{
  {
    init_simple_test("BFu0c_Vp_I");
    static BFu0c_Vp_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_I)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Vp_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_I(Test_BFu0c_Vp_I, "BFu0c_Vp_I", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_Ip()
{
  {
    init_simple_test("BFu0c_Vp_Ip");
    static BFu0c_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Vp_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_Ip(Test_BFu0c_Vp_Ip, "BFu0c_Vp_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_L()
{
  {
    init_simple_test("BFu0c_Vp_L");
    static BFu0c_Vp_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_L)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Vp_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_L(Test_BFu0c_Vp_L, "BFu0c_Vp_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_S()
{
  {
    init_simple_test("BFu0c_Vp_S");
    static BFu0c_Vp_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_S)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Vp_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_S(Test_BFu0c_Vp_S, "BFu0c_Vp_S", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_Uc()
{
  {
    init_simple_test("BFu0c_Vp_Uc");
    static BFu0c_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu0c_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Vp_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_Uc(Test_BFu0c_Vp_Uc, "BFu0c_Vp_Uc", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_Ui()
{
  {
    init_simple_test("BFu0c_Vp_Ui");
    static BFu0c_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu0c_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Vp_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_Ui(Test_BFu0c_Vp_Ui, "BFu0c_Vp_Ui", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_Ul()
{
  {
    init_simple_test("BFu0c_Vp_Ul");
    static BFu0c_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Vp_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_Ul(Test_BFu0c_Vp_Ul, "BFu0c_Vp_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_Us()
{
  {
    init_simple_test("BFu0c_Vp_Us");
    static BFu0c_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu0c_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Vp_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_Us(Test_BFu0c_Vp_Us, "BFu0c_Vp_Us", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0c_Vp_Vp()
{
  {
    init_simple_test("BFu0c_Vp_Vp");
    static BFu0c_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Vp_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0c_Vp_Vp(Test_BFu0c_Vp_Vp, "BFu0c_Vp_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i()
{
  {
    init_simple_test("BFu0i");
    static BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i(Test_BFu0i, "BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0c");
    static BFu0i_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c(Test_BFu0i_BFs0c, "BFu0i_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0c");
    static BFu0i_BFs0c_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0c(Test_BFu0i_BFs0c_BFs0c, "BFu0i_BFs0c_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0c_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0c_BFs0c");
    static BFu0i_BFs0c_BFs0c_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0c_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0c_BFs0c(Test_BFu0i_BFs0c_BFs0c_BFs0c, "BFu0i_BFs0c_BFs0c_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0c_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0c_BFs0i");
    static BFu0i_BFs0c_BFs0c_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0c_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0c_BFs0i(Test_BFu0i_BFs0c_BFs0c_BFs0i, "BFu0i_BFs0c_BFs0c_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0c_BFs0ll");
    static BFu0i_BFs0c_BFs0c_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0c_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0c_BFs0ll(Test_BFu0i_BFs0c_BFs0c_BFs0ll, "BFu0i_BFs0c_BFs0c_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0c_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0c_BFs0s");
    static BFu0i_BFs0c_BFs0c_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0c_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0c_BFs0s(Test_BFu0i_BFs0c_BFs0c_BFs0s, "BFu0i_BFs0c_BFs0c_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0c_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0c_BFu0c");
    static BFu0i_BFs0c_BFs0c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0c_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0c_BFu0c(Test_BFu0i_BFs0c_BFs0c_BFu0c, "BFu0i_BFs0c_BFs0c_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0c_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0c_BFu0i");
    static BFu0i_BFs0c_BFs0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0c_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0c_BFu0i(Test_BFu0i_BFs0c_BFs0c_BFu0i, "BFu0i_BFs0c_BFs0c_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0c_BFu0ll");
    static BFu0i_BFs0c_BFs0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0c_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0c_BFu0ll(Test_BFu0i_BFs0c_BFs0c_BFu0ll, "BFu0i_BFs0c_BFs0c_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0c_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0c_BFu0s");
    static BFu0i_BFs0c_BFs0c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0c_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0c_BFu0s(Test_BFu0i_BFs0c_BFs0c_BFu0s, "BFu0i_BFs0c_BFs0c_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0i");
    static BFu0i_BFs0c_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0i(Test_BFu0i_BFs0c_BFs0i, "BFu0i_BFs0c_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0i_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0i_BFs0c");
    static BFu0i_BFs0c_BFs0i_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0i_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0i_BFs0c(Test_BFu0i_BFs0c_BFs0i_BFs0c, "BFu0i_BFs0c_BFs0i_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0i_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0i_BFs0i");
    static BFu0i_BFs0c_BFs0i_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0i_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0i_BFs0i(Test_BFu0i_BFs0c_BFs0i_BFs0i, "BFu0i_BFs0c_BFs0i_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0i_BFs0ll");
    static BFu0i_BFs0c_BFs0i_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0i_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0i_BFs0ll(Test_BFu0i_BFs0c_BFs0i_BFs0ll, "BFu0i_BFs0c_BFs0i_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0i_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0i_BFs0s");
    static BFu0i_BFs0c_BFs0i_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0i_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0i_BFs0s(Test_BFu0i_BFs0c_BFs0i_BFs0s, "BFu0i_BFs0c_BFs0i_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0i_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0i_BFu0c");
    static BFu0i_BFs0c_BFs0i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0i_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0i_BFu0c(Test_BFu0i_BFs0c_BFs0i_BFu0c, "BFu0i_BFs0c_BFs0i_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0i_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0i_BFu0i");
    static BFu0i_BFs0c_BFs0i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0i_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0i_BFu0i(Test_BFu0i_BFs0c_BFs0i_BFu0i, "BFu0i_BFs0c_BFs0i_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0i_BFu0ll");
    static BFu0i_BFs0c_BFs0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0i_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0i_BFu0ll(Test_BFu0i_BFs0c_BFs0i_BFu0ll, "BFu0i_BFs0c_BFs0i_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0i_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0i_BFu0s");
    static BFu0i_BFs0c_BFs0i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0i_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0i_BFu0s(Test_BFu0i_BFs0c_BFs0i_BFu0s, "BFu0i_BFs0c_BFs0i_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0ll");
    static BFu0i_BFs0c_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0ll(Test_BFu0i_BFs0c_BFs0ll, "BFu0i_BFs0c_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0ll_BFs0c");
    static BFu0i_BFs0c_BFs0ll_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0ll_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0ll_BFs0c(Test_BFu0i_BFs0c_BFs0ll_BFs0c, "BFu0i_BFs0c_BFs0ll_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0ll_BFs0i");
    static BFu0i_BFs0c_BFs0ll_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0ll_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0ll_BFs0i(Test_BFu0i_BFs0c_BFs0ll_BFs0i, "BFu0i_BFs0c_BFs0ll_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0ll_BFs0ll");
    static BFu0i_BFs0c_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0ll_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0ll_BFs0ll(Test_BFu0i_BFs0c_BFs0ll_BFs0ll, "BFu0i_BFs0c_BFs0ll_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0ll_BFs0s");
    static BFu0i_BFs0c_BFs0ll_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0ll_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0ll_BFs0s(Test_BFu0i_BFs0c_BFs0ll_BFs0s, "BFu0i_BFs0c_BFs0ll_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0ll_BFu0c");
    static BFu0i_BFs0c_BFs0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0ll_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0ll_BFu0c(Test_BFu0i_BFs0c_BFs0ll_BFu0c, "BFu0i_BFs0c_BFs0ll_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0ll_BFu0i");
    static BFu0i_BFs0c_BFs0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0ll_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0ll_BFu0i(Test_BFu0i_BFs0c_BFs0ll_BFu0i, "BFu0i_BFs0c_BFs0ll_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0ll_BFu0ll");
    static BFu0i_BFs0c_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0ll_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0ll_BFu0ll(Test_BFu0i_BFs0c_BFs0ll_BFu0ll, "BFu0i_BFs0c_BFs0ll_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0ll_BFu0s");
    static BFu0i_BFs0c_BFs0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0ll_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0ll_BFu0s(Test_BFu0i_BFs0c_BFs0ll_BFu0s, "BFu0i_BFs0c_BFs0ll_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0s");
    static BFu0i_BFs0c_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0s(Test_BFu0i_BFs0c_BFs0s, "BFu0i_BFs0c_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0s_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0s_BFs0c");
    static BFu0i_BFs0c_BFs0s_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0s_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0s_BFs0c(Test_BFu0i_BFs0c_BFs0s_BFs0c, "BFu0i_BFs0c_BFs0s_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0s_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0s_BFs0i");
    static BFu0i_BFs0c_BFs0s_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0s_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0s_BFs0i(Test_BFu0i_BFs0c_BFs0s_BFs0i, "BFu0i_BFs0c_BFs0s_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0s_BFs0ll");
    static BFu0i_BFs0c_BFs0s_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0s_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0s_BFs0ll(Test_BFu0i_BFs0c_BFs0s_BFs0ll, "BFu0i_BFs0c_BFs0s_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0s_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0s_BFs0s");
    static BFu0i_BFs0c_BFs0s_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0s_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0s_BFs0s(Test_BFu0i_BFs0c_BFs0s_BFs0s, "BFu0i_BFs0c_BFs0s_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0s_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0s_BFu0c");
    static BFu0i_BFs0c_BFs0s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0s_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0s_BFu0c(Test_BFu0i_BFs0c_BFs0s_BFu0c, "BFu0i_BFs0c_BFs0s_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0s_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0s_BFu0i");
    static BFu0i_BFs0c_BFs0s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0s_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0s_BFu0i(Test_BFu0i_BFs0c_BFs0s_BFu0i, "BFu0i_BFs0c_BFs0s_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0s_BFu0ll");
    static BFu0i_BFs0c_BFs0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0s_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0s_BFu0ll(Test_BFu0i_BFs0c_BFs0s_BFu0ll, "BFu0i_BFs0c_BFs0s_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFs0s_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFs0s_BFu0s");
    static BFu0i_BFs0c_BFs0s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFs0s_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFs0s_BFu0s(Test_BFu0i_BFs0c_BFs0s_BFu0s, "BFu0i_BFs0c_BFs0s_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0c");
    static BFu0i_BFs0c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0c(Test_BFu0i_BFs0c_BFu0c, "BFu0i_BFs0c_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0c_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0c_BFs0c");
    static BFu0i_BFs0c_BFu0c_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0c_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0c_BFs0c(Test_BFu0i_BFs0c_BFu0c_BFs0c, "BFu0i_BFs0c_BFu0c_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0c_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0c_BFs0i");
    static BFu0i_BFs0c_BFu0c_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0c_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0c_BFs0i(Test_BFu0i_BFs0c_BFu0c_BFs0i, "BFu0i_BFs0c_BFu0c_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0c_BFs0ll");
    static BFu0i_BFs0c_BFu0c_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0c_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0c_BFs0ll(Test_BFu0i_BFs0c_BFu0c_BFs0ll, "BFu0i_BFs0c_BFu0c_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0c_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0c_BFs0s");
    static BFu0i_BFs0c_BFu0c_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0c_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0c_BFs0s(Test_BFu0i_BFs0c_BFu0c_BFs0s, "BFu0i_BFs0c_BFu0c_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0c_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0c_BFu0c");
    static BFu0i_BFs0c_BFu0c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0c_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0c_BFu0c(Test_BFu0i_BFs0c_BFu0c_BFu0c, "BFu0i_BFs0c_BFu0c_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0c_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0c_BFu0i");
    static BFu0i_BFs0c_BFu0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0c_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0c_BFu0i(Test_BFu0i_BFs0c_BFu0c_BFu0i, "BFu0i_BFs0c_BFu0c_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0c_BFu0ll");
    static BFu0i_BFs0c_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0c_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0c_BFu0ll(Test_BFu0i_BFs0c_BFu0c_BFu0ll, "BFu0i_BFs0c_BFu0c_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0c_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0c_BFu0s");
    static BFu0i_BFs0c_BFu0c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0c_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0c_BFu0s(Test_BFu0i_BFs0c_BFu0c_BFu0s, "BFu0i_BFs0c_BFu0c_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0i");
    static BFu0i_BFs0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0i(Test_BFu0i_BFs0c_BFu0i, "BFu0i_BFs0c_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0i_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0i_BFs0c");
    static BFu0i_BFs0c_BFu0i_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0i_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0i_BFs0c(Test_BFu0i_BFs0c_BFu0i_BFs0c, "BFu0i_BFs0c_BFu0i_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0i_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0i_BFs0i");
    static BFu0i_BFs0c_BFu0i_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0i_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0i_BFs0i(Test_BFu0i_BFs0c_BFu0i_BFs0i, "BFu0i_BFs0c_BFu0i_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0i_BFs0ll");
    static BFu0i_BFs0c_BFu0i_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0i_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0i_BFs0ll(Test_BFu0i_BFs0c_BFu0i_BFs0ll, "BFu0i_BFs0c_BFu0i_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0i_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0i_BFs0s");
    static BFu0i_BFs0c_BFu0i_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0i_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0i_BFs0s(Test_BFu0i_BFs0c_BFu0i_BFs0s, "BFu0i_BFs0c_BFu0i_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0i_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0i_BFu0c");
    static BFu0i_BFs0c_BFu0i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0i_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0i_BFu0c(Test_BFu0i_BFs0c_BFu0i_BFu0c, "BFu0i_BFs0c_BFu0i_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0i_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0i_BFu0i");
    static BFu0i_BFs0c_BFu0i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0i_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0i_BFu0i(Test_BFu0i_BFs0c_BFu0i_BFu0i, "BFu0i_BFs0c_BFu0i_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0i_BFu0ll");
    static BFu0i_BFs0c_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0i_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0i_BFu0ll(Test_BFu0i_BFs0c_BFu0i_BFu0ll, "BFu0i_BFs0c_BFu0i_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0i_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0i_BFu0s");
    static BFu0i_BFs0c_BFu0i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0i_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0i_BFu0s(Test_BFu0i_BFs0c_BFu0i_BFu0s, "BFu0i_BFs0c_BFu0i_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0ll");
    static BFu0i_BFs0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0ll(Test_BFu0i_BFs0c_BFu0ll, "BFu0i_BFs0c_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0ll_BFs0c");
    static BFu0i_BFs0c_BFu0ll_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0ll_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0ll_BFs0c(Test_BFu0i_BFs0c_BFu0ll_BFs0c, "BFu0i_BFs0c_BFu0ll_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0ll_BFs0i");
    static BFu0i_BFs0c_BFu0ll_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0ll_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0ll_BFs0i(Test_BFu0i_BFs0c_BFu0ll_BFs0i, "BFu0i_BFs0c_BFu0ll_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0ll_BFs0ll");
    static BFu0i_BFs0c_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0ll_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0ll_BFs0ll(Test_BFu0i_BFs0c_BFu0ll_BFs0ll, "BFu0i_BFs0c_BFu0ll_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0ll_BFs0s");
    static BFu0i_BFs0c_BFu0ll_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0ll_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0ll_BFs0s(Test_BFu0i_BFs0c_BFu0ll_BFs0s, "BFu0i_BFs0c_BFu0ll_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0ll_BFu0c");
    static BFu0i_BFs0c_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0ll_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0ll_BFu0c(Test_BFu0i_BFs0c_BFu0ll_BFu0c, "BFu0i_BFs0c_BFu0ll_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0ll_BFu0i");
    static BFu0i_BFs0c_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0ll_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0ll_BFu0i(Test_BFu0i_BFs0c_BFu0ll_BFu0i, "BFu0i_BFs0c_BFu0ll_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0ll_BFu0ll");
    static BFu0i_BFs0c_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0ll_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0ll_BFu0ll(Test_BFu0i_BFs0c_BFu0ll_BFu0ll, "BFu0i_BFs0c_BFu0ll_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0ll_BFu0s");
    static BFu0i_BFs0c_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0ll_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0ll_BFu0s(Test_BFu0i_BFs0c_BFu0ll_BFu0s, "BFu0i_BFs0c_BFu0ll_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0s");
    static BFu0i_BFs0c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0s(Test_BFu0i_BFs0c_BFu0s, "BFu0i_BFs0c_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0s_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0s_BFs0c");
    static BFu0i_BFs0c_BFu0s_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0s_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0s_BFs0c(Test_BFu0i_BFs0c_BFu0s_BFs0c, "BFu0i_BFs0c_BFu0s_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0s_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0s_BFs0i");
    static BFu0i_BFs0c_BFu0s_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0s_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0s_BFs0i(Test_BFu0i_BFs0c_BFu0s_BFs0i, "BFu0i_BFs0c_BFu0s_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0s_BFs0ll");
    static BFu0i_BFs0c_BFu0s_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0s_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0s_BFs0ll(Test_BFu0i_BFs0c_BFu0s_BFs0ll, "BFu0i_BFs0c_BFu0s_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0s_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0s_BFs0s");
    static BFu0i_BFs0c_BFu0s_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0s_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0s_BFs0s(Test_BFu0i_BFs0c_BFu0s_BFs0s, "BFu0i_BFs0c_BFu0s_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0s_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0s_BFu0c");
    static BFu0i_BFs0c_BFu0s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0s_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0s_BFu0c(Test_BFu0i_BFs0c_BFu0s_BFu0c, "BFu0i_BFs0c_BFu0s_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0s_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0s_BFu0i");
    static BFu0i_BFs0c_BFu0s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0s_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0s_BFu0i(Test_BFu0i_BFs0c_BFu0s_BFu0i, "BFu0i_BFs0c_BFu0s_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0s_BFu0ll");
    static BFu0i_BFs0c_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0s_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0s_BFu0ll(Test_BFu0i_BFs0c_BFu0s_BFu0ll, "BFu0i_BFs0c_BFu0s_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0c_BFu0s_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0c_BFu0s_BFu0s");
    static BFu0i_BFs0c_BFu0s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0c_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0c_BFu0s_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0c_BFu0s_BFu0s(Test_BFu0i_BFs0c_BFu0s_BFu0s, "BFu0i_BFs0c_BFu0s_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0i");
    static BFu0i_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i(Test_BFu0i_BFs0i, "BFu0i_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0c");
    static BFu0i_BFs0i_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0c(Test_BFu0i_BFs0i_BFs0c, "BFu0i_BFs0i_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0c_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0c_BFs0c");
    static BFu0i_BFs0i_BFs0c_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0c_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0c_BFs0c(Test_BFu0i_BFs0i_BFs0c_BFs0c, "BFu0i_BFs0i_BFs0c_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0c_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0c_BFs0i");
    static BFu0i_BFs0i_BFs0c_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0c_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0c_BFs0i(Test_BFu0i_BFs0i_BFs0c_BFs0i, "BFu0i_BFs0i_BFs0c_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0c_BFs0ll");
    static BFu0i_BFs0i_BFs0c_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0c_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0c_BFs0ll(Test_BFu0i_BFs0i_BFs0c_BFs0ll, "BFu0i_BFs0i_BFs0c_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0c_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0c_BFs0s");
    static BFu0i_BFs0i_BFs0c_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0c_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0c_BFs0s(Test_BFu0i_BFs0i_BFs0c_BFs0s, "BFu0i_BFs0i_BFs0c_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0c_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0c_BFu0c");
    static BFu0i_BFs0i_BFs0c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0c_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0c_BFu0c(Test_BFu0i_BFs0i_BFs0c_BFu0c, "BFu0i_BFs0i_BFs0c_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0c_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0c_BFu0i");
    static BFu0i_BFs0i_BFs0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0c_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0c_BFu0i(Test_BFu0i_BFs0i_BFs0c_BFu0i, "BFu0i_BFs0i_BFs0c_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0c_BFu0ll");
    static BFu0i_BFs0i_BFs0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0c_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0c_BFu0ll(Test_BFu0i_BFs0i_BFs0c_BFu0ll, "BFu0i_BFs0i_BFs0c_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0c_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0c_BFu0s");
    static BFu0i_BFs0i_BFs0c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0c_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0c_BFu0s(Test_BFu0i_BFs0i_BFs0c_BFu0s, "BFu0i_BFs0i_BFs0c_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0i");
    static BFu0i_BFs0i_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0i(Test_BFu0i_BFs0i_BFs0i, "BFu0i_BFs0i_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0i_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0i_BFs0c");
    static BFu0i_BFs0i_BFs0i_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0i_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0i_BFs0c(Test_BFu0i_BFs0i_BFs0i_BFs0c, "BFu0i_BFs0i_BFs0i_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0i_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0i_BFs0i");
    static BFu0i_BFs0i_BFs0i_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0i_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0i_BFs0i(Test_BFu0i_BFs0i_BFs0i_BFs0i, "BFu0i_BFs0i_BFs0i_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0i_BFs0ll");
    static BFu0i_BFs0i_BFs0i_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0i_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0i_BFs0ll(Test_BFu0i_BFs0i_BFs0i_BFs0ll, "BFu0i_BFs0i_BFs0i_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0i_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0i_BFs0s");
    static BFu0i_BFs0i_BFs0i_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0i_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0i_BFs0s(Test_BFu0i_BFs0i_BFs0i_BFs0s, "BFu0i_BFs0i_BFs0i_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0i_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0i_BFu0c");
    static BFu0i_BFs0i_BFs0i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0i_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0i_BFu0c(Test_BFu0i_BFs0i_BFs0i_BFu0c, "BFu0i_BFs0i_BFs0i_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0i_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0i_BFu0i");
    static BFu0i_BFs0i_BFs0i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0i_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0i_BFu0i(Test_BFu0i_BFs0i_BFs0i_BFu0i, "BFu0i_BFs0i_BFs0i_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0i_BFu0ll");
    static BFu0i_BFs0i_BFs0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0i_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0i_BFu0ll(Test_BFu0i_BFs0i_BFs0i_BFu0ll, "BFu0i_BFs0i_BFs0i_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0i_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0i_BFu0s");
    static BFu0i_BFs0i_BFs0i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0i_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0i_BFu0s(Test_BFu0i_BFs0i_BFs0i_BFu0s, "BFu0i_BFs0i_BFs0i_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0ll");
    static BFu0i_BFs0i_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0ll(Test_BFu0i_BFs0i_BFs0ll, "BFu0i_BFs0i_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0ll_BFs0c");
    static BFu0i_BFs0i_BFs0ll_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0ll_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0ll_BFs0c(Test_BFu0i_BFs0i_BFs0ll_BFs0c, "BFu0i_BFs0i_BFs0ll_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0ll_BFs0i");
    static BFu0i_BFs0i_BFs0ll_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0ll_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0ll_BFs0i(Test_BFu0i_BFs0i_BFs0ll_BFs0i, "BFu0i_BFs0i_BFs0ll_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0ll_BFs0ll");
    static BFu0i_BFs0i_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0ll_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0ll_BFs0ll(Test_BFu0i_BFs0i_BFs0ll_BFs0ll, "BFu0i_BFs0i_BFs0ll_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0ll_BFs0s");
    static BFu0i_BFs0i_BFs0ll_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0ll_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0ll_BFs0s(Test_BFu0i_BFs0i_BFs0ll_BFs0s, "BFu0i_BFs0i_BFs0ll_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0ll_BFu0c");
    static BFu0i_BFs0i_BFs0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0ll_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0ll_BFu0c(Test_BFu0i_BFs0i_BFs0ll_BFu0c, "BFu0i_BFs0i_BFs0ll_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0ll_BFu0i");
    static BFu0i_BFs0i_BFs0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0ll_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0ll_BFu0i(Test_BFu0i_BFs0i_BFs0ll_BFu0i, "BFu0i_BFs0i_BFs0ll_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0ll_BFu0ll");
    static BFu0i_BFs0i_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0ll_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0ll_BFu0ll(Test_BFu0i_BFs0i_BFs0ll_BFu0ll, "BFu0i_BFs0i_BFs0ll_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0ll_BFu0s");
    static BFu0i_BFs0i_BFs0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0ll_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0ll_BFu0s(Test_BFu0i_BFs0i_BFs0ll_BFu0s, "BFu0i_BFs0i_BFs0ll_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0s");
    static BFu0i_BFs0i_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0s(Test_BFu0i_BFs0i_BFs0s, "BFu0i_BFs0i_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0s_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0s_BFs0c");
    static BFu0i_BFs0i_BFs0s_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0s_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0s_BFs0c(Test_BFu0i_BFs0i_BFs0s_BFs0c, "BFu0i_BFs0i_BFs0s_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0s_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0s_BFs0i");
    static BFu0i_BFs0i_BFs0s_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0s_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0s_BFs0i(Test_BFu0i_BFs0i_BFs0s_BFs0i, "BFu0i_BFs0i_BFs0s_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0s_BFs0ll");
    static BFu0i_BFs0i_BFs0s_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0s_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0s_BFs0ll(Test_BFu0i_BFs0i_BFs0s_BFs0ll, "BFu0i_BFs0i_BFs0s_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0s_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0s_BFs0s");
    static BFu0i_BFs0i_BFs0s_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0s_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0s_BFs0s(Test_BFu0i_BFs0i_BFs0s_BFs0s, "BFu0i_BFs0i_BFs0s_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0s_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0s_BFu0c");
    static BFu0i_BFs0i_BFs0s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0s_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0s_BFu0c(Test_BFu0i_BFs0i_BFs0s_BFu0c, "BFu0i_BFs0i_BFs0s_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0s_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0s_BFu0i");
    static BFu0i_BFs0i_BFs0s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0s_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0s_BFu0i(Test_BFu0i_BFs0i_BFs0s_BFu0i, "BFu0i_BFs0i_BFs0s_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0s_BFu0ll");
    static BFu0i_BFs0i_BFs0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0s_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0s_BFu0ll(Test_BFu0i_BFs0i_BFs0s_BFu0ll, "BFu0i_BFs0i_BFs0s_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFs0s_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0i_BFs0s_BFu0s");
    static BFu0i_BFs0i_BFs0s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFs0s_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFs0s_BFu0s(Test_BFu0i_BFs0i_BFs0s_BFu0s, "BFu0i_BFs0i_BFs0s_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0i_BFu0c");
    static BFu0i_BFs0i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFu0c(Test_BFu0i_BFs0i_BFu0c, "BFu0i_BFs0i_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFu0c_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0i_BFu0c_BFs0c");
    static BFu0i_BFs0i_BFu0c_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFu0c_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFu0c_BFs0c(Test_BFu0i_BFs0i_BFu0c_BFs0c, "BFu0i_BFs0i_BFu0c_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFu0c_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0i_BFu0c_BFs0i");
    static BFu0i_BFs0i_BFu0c_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFu0c_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFu0c_BFs0i(Test_BFu0i_BFs0i_BFu0c_BFs0i, "BFu0i_BFs0i_BFu0c_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0i_BFu0c_BFs0ll");
    static BFu0i_BFs0i_BFu0c_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFu0c_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFu0c_BFs0ll(Test_BFu0i_BFs0i_BFu0c_BFs0ll, "BFu0i_BFs0i_BFu0c_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFu0c_BFs0s()
{
  {
    init_simple_test("BFu0i_BFs0i_BFu0c_BFs0s");
    static BFu0i_BFs0i_BFu0c_BFs0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFu0c_BFs0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFu0c_BFs0s(Test_BFu0i_BFs0i_BFu0c_BFs0s, "BFu0i_BFs0i_BFu0c_BFs0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFu0c_BFu0c()
{
  {
    init_simple_test("BFu0i_BFs0i_BFu0c_BFu0c");
    static BFu0i_BFs0i_BFu0c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFu0c_BFu0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFu0c_BFu0c(Test_BFu0i_BFs0i_BFu0c_BFu0c, "BFu0i_BFs0i_BFu0c_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFu0c_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0i_BFu0c_BFu0i");
    static BFu0i_BFs0i_BFu0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFu0c_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFu0c_BFu0i(Test_BFu0i_BFs0i_BFu0c_BFu0i, "BFu0i_BFs0i_BFu0c_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFs0i_BFu0c_BFu0ll");
    static BFu0i_BFs0i_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFu0c_BFu0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFu0c_BFu0ll(Test_BFu0i_BFs0i_BFu0c_BFu0ll, "BFu0i_BFs0i_BFu0c_BFu0ll", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFu0c_BFu0s()
{
  {
    init_simple_test("BFu0i_BFs0i_BFu0c_BFu0s");
    static BFu0i_BFs0i_BFu0c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFu0c_BFu0s)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFu0c_BFu0s(Test_BFu0i_BFs0i_BFu0c_BFu0s, "BFu0i_BFs0i_BFu0c_BFu0s", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFu0i()
{
  {
    init_simple_test("BFu0i_BFs0i_BFu0i");
    static BFu0i_BFs0i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFu0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFu0i(Test_BFu0i_BFs0i_BFu0i, "BFu0i_BFs0i_BFu0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFu0i_BFs0c()
{
  {
    init_simple_test("BFu0i_BFs0i_BFu0i_BFs0c");
    static BFu0i_BFs0i_BFu0i_BFs0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFu0i_BFs0c)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFu0i_BFs0c(Test_BFu0i_BFs0i_BFu0i_BFs0c, "BFu0i_BFs0i_BFu0i_BFs0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFu0i_BFs0i()
{
  {
    init_simple_test("BFu0i_BFs0i_BFu0i_BFs0i");
    static BFu0i_BFs0i_BFu0i_BFs0i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFu0i_BFs0i)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFu0i_BFs0i(Test_BFu0i_BFs0i_BFu0i_BFs0i, "BFu0i_BFs0i_BFu0i_BFs0i", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_BFu0i_BFs0i_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFu0i_BFs0i_BFu0i_BFs0ll");
    static BFu0i_BFs0i_BFu0i_BFs0ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFs0i_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFs0i_BFu0i_BFs0ll)");
  }
}
static Arrange_To_Call_Me vBFu0i_BFs0i_BFu0i_BFs0ll(Test_BFu0i_BFs0i_BFu0i_BFs0ll, "BFu0i_BFs0i_BFu0i_BFs0ll", ABISELECT(1,1));

#else // __cplusplus

#e