// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
struct __attribute__((packed)) aL_BFu8c_BFu0c { long long v1; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aL_BFu8c_BFu0i { long long v1; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aL_BFu8c_BFu0ll { long long v1; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aL_BFu8c_BFu0s { long long v1; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aL_BFu8i_BFu0c { long long v1; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aL_BFu8i_BFu0i { long long v1; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aL_BFu8i_BFu0ll { long long v1; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aL_BFu8i_BFu0s { long long v1; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aL_BFu8ll_BFu0c { long long v1; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aL_BFu8ll_BFu0i { long long v1; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aL_BFu8ll_BFu0ll { long long v1; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aL_BFu8ll_BFu0s { long long v1; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aL_BFu8s_BFu0c { long long v1; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aL_BFu8s_BFu0i { long long v1; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aL_BFu8s_BFu0ll { long long v1; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aL_BFu8s_BFu0s { long long v1; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aL_BFu9i_BFu0c { long long v1; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aL_BFu9i_BFu0i { long long v1; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aL_BFu9i_BFu0ll { long long v1; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aL_BFu9i_BFu0s { long long v1; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aL_BFu9ll_BFu0c { long long v1; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aL_BFu9ll_BFu0i { long long v1; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aL_BFu9ll_BFu0ll { long long v1; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aL_BFu9ll_BFu0s { long long v1; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aL_BFu9s_BFu0c { long long v1; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aL_BFu9s_BFu0i { long long v1; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aL_BFu9s_BFu0ll { long long v1; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aL_BFu9s_BFu0s { long long v1; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aL_C_BFu0c { long long v1; char v2; unsigned char :0; };
struct __attribute__((packed)) aL_C_BFu0i { long long v1; char v2; unsigned int :0; };
struct __attribute__((packed)) aL_C_BFu0ll { long long v1; char v2; unsigned long long :0; };
struct __attribute__((packed)) aL_C_BFu0s { long long v1; char v2; unsigned short :0; };
struct __attribute__((packed)) aL_D_BFu0c { long long v1; double v2; unsigned char :0; };
struct __attribute__((packed)) aL_D_BFu0i { long long v1; double v2; unsigned int :0; };
struct __attribute__((packed)) aL_D_BFu0ll { long long v1; double v2; unsigned long long :0; };
struct __attribute__((packed)) aL_D_BFu0s { long long v1; double v2; unsigned short :0; };
struct __attribute__((packed)) aL_F_BFu0c { long long v1; float v2; unsigned char :0; };
struct __attribute__((packed)) aL_F_BFu0i { long long v1; float v2; unsigned int :0; };
struct __attribute__((packed)) aL_F_BFu0ll { long long v1; float v2; unsigned long long :0; };
struct __attribute__((packed)) aL_F_BFu0s { long long v1; float v2; unsigned short :0; };
struct __attribute__((packed)) aL_I_BFu0c { long long v1; int v2; unsigned char :0; };
struct __attribute__((packed)) aL_I_BFu0i { long long v1; int v2; unsigned int :0; };
struct __attribute__((packed)) aL_I_BFu0ll { long long v1; int v2; unsigned long long :0; };
struct __attribute__((packed)) aL_I_BFu0s { long long v1; int v2; unsigned short :0; };
struct __attribute__((packed)) aL_Ip_BFu0c { long long v1; int * v2; unsigned char :0; };
struct __attribute__((packed)) aL_Ip_BFu0i { long long v1; int * v2; unsigned int :0; };
struct __attribute__((packed)) aL_Ip_BFu0ll { long long v1; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aL_Ip_BFu0s { long long v1; int * v2; unsigned short :0; };
struct __attribute__((packed)) aL_L_BFu0c { long long v1; long long v2; unsigned char :0; };
struct __attribute__((packed)) aL_L_BFu0i { long long v1; long long v2; unsigned int :0; };
struct __attribute__((packed)) aL_L_BFu0ll { long long v1; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aL_L_BFu0s { long long v1; long long v2; unsigned short :0; };
struct __attribute__((packed)) aL_S_BFu0c { long long v1; short v2; unsigned char :0; };
struct __attribute__((packed)) aL_S_BFu0i { long long v1; short v2; unsigned int :0; };
struct __attribute__((packed)) aL_S_BFu0ll { long long v1; short v2; unsigned long long :0; };
struct __attribute__((packed)) aL_S_BFu0s { long long v1; short v2; unsigned short :0; };
struct __attribute__((packed)) aL_Uc_BFu0c { long long v1; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aL_Uc_BFu0i { long long v1; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aL_Uc_BFu0ll { long long v1; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aL_Uc_BFu0s { long long v1; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aL_Ui_BFu0c { long long v1; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aL_Ui_BFu0i { long long v1; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aL_Ui_BFu0ll { long long v1; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aL_Ui_BFu0s { long long v1; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aL_Ul_BFu0c { long long v1; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aL_Ul_BFu0i { long long v1; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aL_Ul_BFu0ll { long long v1; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aL_Ul_BFu0s { long long v1; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aL_Us_BFu0c { long long v1; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aL_Us_BFu0i { long long v1; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aL_Us_BFu0ll { long long v1; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aL_Us_BFu0s { long long v1; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aL_Vp_BFu0c { long long v1; void * v2; unsigned char :0; };
struct __attribute__((packed)) aL_Vp_BFu0i { long long v1; void * v2; unsigned int :0; };
struct __attribute__((packed)) aL_Vp_BFu0ll { long long v1; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aL_Vp_BFu0s { long long v1; void * v2; unsigned short :0; };
struct __attribute__((packed)) aS_BFu0c { short v1; unsigned char :0; };
struct __attribute__((packed)) aS_BFu0c_BFu0c { short v1; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aS_BFu0c_BFu0i { short v1; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aS_BFu0c_BFu0ll { short v1; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu0c_BFu0s { short v1; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aS_BFu0c_BFu15i { short v1; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aS_BFu0c_BFu15ll { short v1; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aS_BFu0c_BFu15s { short v1; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aS_BFu0c_BFu16i { short v1; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aS_BFu0c_BFu16ll { short v1; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aS_BFu0c_BFu16s { short v1; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aS_BFu0c_BFu17i { short v1; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aS_BFu0c_BFu17ll { short v1; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aS_BFu0c_BFu1c { short v1; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aS_BFu0c_BFu1i { short v1; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aS_BFu0c_BFu1ll { short v1; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aS_BFu0c_BFu1s { short v1; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aS_BFu0c_BFu31i { short v1; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aS_BFu0c_BFu31ll { short v1; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aS_BFu0c_BFu32i { short v1; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aS_BFu0c_BFu32ll { short v1; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aS_BFu0c_BFu33 { short v1; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aS_BFu0c_BFu7c { short v1; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aS_BFu0c_BFu7i { short v1; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aS_BFu0c_BFu7ll { short v1; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aS_BFu0c_BFu7s { short v1; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aS_BFu0c_BFu8c { short v1; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aS_BFu0c_BFu8i { short v1; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aS_BFu0c_BFu8ll { short v1; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aS_BFu0c_BFu8s { short v1; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aS_BFu0c_BFu9i { short v1; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aS_BFu0c_BFu9ll { short v1; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aS_BFu0c_BFu9s { short v1; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aS_BFu0c_C { short v1; unsigned char :0; char v2; };
struct __attribute__((packed)) aS_BFu0c_D { short v1; unsigned char :0; double v2; };
struct __attribute__((packed)) aS_BFu0c_F { short v1; unsigned char :0; float v2; };
struct __attribute__((packed)) aS_BFu0c_I { short v1; unsigned char :0; int v2; };
struct __attribute__((packed)) aS_BFu0c_Ip { short v1; unsigned char :0; int * v2; };
struct __attribute__((packed)) aS_BFu0c_L { short v1; unsigned char :0; long long v2; };
struct __attribute__((packed)) aS_BFu0c_S { short v1; unsigned char :0; short v2; };
struct __attribute__((packed)) aS_BFu0c_Uc { short v1; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aS_BFu0c_Ui { short v1; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aS_BFu0c_Ul { short v1; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aS_BFu0c_Us { short v1; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aS_BFu0c_Vp { short v1; unsigned char :0; void * v2; };
struct __attribute__((packed)) aS_BFu0i { short v1; unsigned int :0; };
struct __attribute__((packed)) aS_BFu0i_BFu0c { short v1; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aS_BFu0i_BFu0i { short v1; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aS_BFu0i_BFu0ll { short v1; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu0i_BFu0s { short v1; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aS_BFu0i_BFu15i { short v1; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aS_BFu0i_BFu15ll { short v1; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aS_BFu0i_BFu15s { short v1; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aS_BFu0i_BFu16i { short v1; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aS_BFu0i_BFu16ll { short v1; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aS_BFu0i_BFu16s { short v1; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aS_BFu0i_BFu17i { short v1; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aS_BFu0i_BFu17ll { short v1; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aS_BFu0i_BFu1c { short v1; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aS_BFu0i_BFu1i { short v1; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aS_BFu0i_BFu1ll { short v1; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aS_BFu0i_BFu1s { short v1; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aS_BFu0i_BFu31i { short v1; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aS_BFu0i_BFu31ll { short v1; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aS_BFu0i_BFu32i { short v1; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aS_BFu0i_BFu32ll { short v1; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aS_BFu0i_BFu33 { short v1; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aS_BFu0i_BFu7c { short v1; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aS_BFu0i_BFu7i { short v1; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aS_BFu0i_BFu7ll { short v1; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aS_BFu0i_BFu7s { short v1; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aS_BFu0i_BFu8c { short v1; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aS_BFu0i_BFu8i { short v1; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aS_BFu0i_BFu8ll { short v1; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aS_BFu0i_BFu8s { short v1; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aS_BFu0i_BFu9i { short v1; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aS_BFu0i_BFu9ll { short v1; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aS_BFu0i_BFu9s { short v1; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aS_BFu0i_C { short v1; unsigned int :0; char v2; };
struct __attribute__((packed)) aS_BFu0i_D { short v1; unsigned int :0; double v2; };
struct __attribute__((packed)) aS_BFu0i_F { short v1; unsigned int :0; float v2; };
struct __attribute__((packed)) aS_BFu0i_I { short v1; unsigned int :0; int v2; };
struct __attribute__((packed)) aS_BFu0i_Ip { short v1; unsigned int :0; int * v2; };
struct __attribute__((packed)) aS_BFu0i_L { short v1; unsigned int :0; long long v2; };
struct __attribute__((packed)) aS_BFu0i_S { short v1; unsigned int :0; short v2; };
struct __attribute__((packed)) aS_BFu0i_Uc { short v1; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aS_BFu0i_Ui { short v1; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aS_BFu0i_Ul { short v1; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aS_BFu0i_Us { short v1; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aS_BFu0i_Vp { short v1; unsigned int :0; void * v2; };
struct __attribute__((packed)) aS_BFu0ll { short v1; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu0ll_BFu0c { short v1; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aS_BFu0ll_BFu0i { short v1; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aS_BFu0ll_BFu0ll { short v1; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu0ll_BFu0s { short v1; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aS_BFu0ll_BFu15i { short v1; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aS_BFu0ll_BFu15ll { short v1; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aS_BFu0ll_BFu15s { short v1; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aS_BFu0ll_BFu16i { short v1; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aS_BFu0ll_BFu16ll { short v1; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aS_BFu0ll_BFu16s { short v1; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aS_BFu0ll_BFu17i { short v1; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aS_BFu0ll_BFu17ll { short v1; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aS_BFu0ll_BFu1c { short v1; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aS_BFu0ll_BFu1i { short v1; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aS_BFu0ll_BFu1ll { short v1; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aS_BFu0ll_BFu1s { short v1; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aS_BFu0ll_BFu31i { short v1; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aS_BFu0ll_BFu31ll { short v1; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aS_BFu0ll_BFu32i { short v1; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aS_BFu0ll_BFu32ll { short v1; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aS_BFu0ll_BFu33 { short v1; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aS_BFu0ll_BFu7c { short v1; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aS_BFu0ll_BFu7i { short v1; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aS_BFu0ll_BFu7ll { short v1; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aS_BFu0ll_BFu7s { short v1; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aS_BFu0ll_BFu8c { short v1; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aS_BFu0ll_BFu8i { short v1; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aS_BFu0ll_BFu8ll { short v1; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aS_BFu0ll_BFu8s { short v1; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aS_BFu0ll_BFu9i { short v1; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aS_BFu0ll_BFu9ll { short v1; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aS_BFu0ll_BFu9s { short v1; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aS_BFu0ll_C { short v1; unsigned long long :0; char v2; };
struct __attribute__((packed)) aS_BFu0ll_D { short v1; unsigned long long :0; double v2; };
struct __attribute__((packed)) aS_BFu0ll_F { short v1; unsigned long long :0; float v2; };
struct __attribute__((packed)) aS_BFu0ll_I { short v1; unsigned long long :0; int v2; };
struct __attribute__((packed)) aS_BFu0ll_Ip { short v1; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aS_BFu0ll_L { short v1; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aS_BFu0ll_S { short v1; unsigned long long :0; short v2; };
struct __attribute__((packed)) aS_BFu0ll_Uc { short v1; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aS_BFu0ll_Ui { short v1; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aS_BFu0ll_Ul { short v1; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aS_BFu0ll_Us { short v1; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aS_BFu0ll_Vp { short v1; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aS_BFu0s { short v1; unsigned short :0; };
struct __attribute__((packed)) aS_BFu0s_BFu0c { short v1; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aS_BFu0s_BFu0i { short v1; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aS_BFu0s_BFu0ll { short v1; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu0s_BFu0s { short v1; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aS_BFu0s_BFu15i { short v1; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aS_BFu0s_BFu15ll { short v1; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aS_BFu0s_BFu15s { short v1; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aS_BFu0s_BFu16i { short v1; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aS_BFu0s_BFu16ll { short v1; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aS_BFu0s_BFu16s { short v1; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aS_BFu0s_BFu17i { short v1; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aS_BFu0s_BFu17ll { short v1; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aS_BFu0s_BFu1c { short v1; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aS_BFu0s_BFu1i { short v1; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aS_BFu0s_BFu1ll { short v1; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aS_BFu0s_BFu1s { short v1; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aS_BFu0s_BFu31i { short v1; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aS_BFu0s_BFu31ll { short v1; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aS_BFu0s_BFu32i { short v1; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aS_BFu0s_BFu32ll { short v1; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aS_BFu0s_BFu33 { short v1; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aS_BFu0s_BFu7c { short v1; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aS_BFu0s_BFu7i { short v1; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aS_BFu0s_BFu7ll { short v1; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aS_BFu0s_BFu7s { short v1; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aS_BFu0s_BFu8c { short v1; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aS_BFu0s_BFu8i { short v1; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aS_BFu0s_BFu8ll { short v1; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aS_BFu0s_BFu8s { short v1; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aS_BFu0s_BFu9i { short v1; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aS_BFu0s_BFu9ll { short v1; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aS_BFu0s_BFu9s { short v1; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aS_BFu0s_C { short v1; unsigned short :0; char v2; };
struct __attribute__((packed)) aS_BFu0s_D { short v1; unsigned short :0; double v2; };
struct __attribute__((packed)) aS_BFu0s_F { short v1; unsigned short :0; float v2; };
struct __attribute__((packed)) aS_BFu0s_I { short v1; unsigned short :0; int v2; };
struct __attribute__((packed)) aS_BFu0s_Ip { short v1; unsigned short :0; int * v2; };
struct __attribute__((packed)) aS_BFu0s_L { short v1; unsigned short :0; long long v2; };
struct __attribute__((packed)) aS_BFu0s_S { short v1; unsigned short :0; short v2; };
struct __attribute__((packed)) aS_BFu0s_Uc { short v1; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aS_BFu0s_Ui { short v1; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aS_BFu0s_Ul { short v1; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aS_BFu0s_Us { short v1; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aS_BFu0s_Vp { short v1; unsigned short :0; void * v2; };
struct __attribute__((packed)) aS_BFu15i_BFu0c { short v1; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aS_BFu15i_BFu0i { short v1; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aS_BFu15i_BFu0ll { short v1; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu15i_BFu0s { short v1; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aS_BFu15ll_BFu0c { short v1; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aS_BFu15ll_BFu0i { short v1; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aS_BFu15ll_BFu0ll { short v1; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu15ll_BFu0s { short v1; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aS_BFu15s_BFu0c { short v1; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aS_BFu15s_BFu0i { short v1; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aS_BFu15s_BFu0ll { short v1; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu15s_BFu0s { short v1; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aS_BFu16i_BFu0c { short v1; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aS_BFu16i_BFu0i { short v1; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aS_BFu16i_BFu0ll { short v1; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu16i_BFu0s { short v1; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aS_BFu16ll_BFu0c { short v1; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aS_BFu16ll_BFu0i { short v1; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aS_BFu16ll_BFu0ll { short v1; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu16ll_BFu0s { short v1; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aS_BFu16s_BFu0c { short v1; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aS_BFu16s_BFu0i { short v1; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aS_BFu16s_BFu0ll { short v1; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu16s_BFu0s { short v1; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aS_BFu17i_BFu0c { short v1; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aS_BFu17i_BFu0i { short v1; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aS_BFu17i_BFu0ll { short v1; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu17i_BFu0s { short v1; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aS_BFu17ll_BFu0c { short v1; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aS_BFu17ll_BFu0i { short v1; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aS_BFu17ll_BFu0ll { short v1; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu17ll_BFu0s { short v1; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aS_BFu1c_BFu0c { short v1; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aS_BFu1c_BFu0i { short v1; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aS_BFu1c_BFu0ll { short v1; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu1c_BFu0s { short v1; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aS_BFu1i_BFu0c { short v1; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aS_BFu1i_BFu0i { short v1; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aS_BFu1i_BFu0ll { short v1; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu1i_BFu0s { short v1; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aS_BFu1ll_BFu0c { short v1; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aS_BFu1ll_BFu0i { short v1; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aS_BFu1ll_BFu0ll { short v1; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu1ll_BFu0s { short v1; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aS_BFu1s_BFu0c { short v1; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aS_BFu1s_BFu0i { short v1; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aS_BFu1s_BFu0ll { short v1; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu1s_BFu0s { short v1; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aS_BFu31i_BFu0c { short v1; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aS_BFu31i_BFu0i { short v1; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aS_BFu31i_BFu0ll { short v1; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu31i_BFu0s { short v1; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aS_BFu31ll_BFu0c { short v1; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aS_BFu31ll_BFu0i { short v1; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aS_BFu31ll_BFu0ll { short v1; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu31ll_BFu0s { short v1; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aS_BFu32i_BFu0c { short v1; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aS_BFu32i_BFu0i { short v1; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aS_BFu32i_BFu0ll { short v1; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu32i_BFu0s { short v1; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aS_BFu32ll_BFu0c { short v1; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aS_BFu32ll_BFu0i { short v1; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aS_BFu32ll_BFu0ll { short v1; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu32ll_BFu0s { short v1; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aS_BFu33_BFu0c { short v1; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aS_BFu33_BFu0i { short v1; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aS_BFu33_BFu0ll { short v1; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu33_BFu0s { short v1; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aS_BFu7c_BFu0c { short v1; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aS_BFu7c_BFu0i { short v1; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aS_BFu7c_BFu0ll { short v1; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu7c_BFu0s { short v1; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aS_BFu7i_BFu0c { short v1; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aS_BFu7i_BFu0i { short v1; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aS_BFu7i_BFu0ll { short v1; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu7i_BFu0s { short v1; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aS_BFu7ll_BFu0c { short v1; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aS_BFu7ll_BFu0i { short v1; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aS_BFu7ll_BFu0ll { short v1; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu7ll_BFu0s { short v1; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aS_BFu7s_BFu0c { short v1; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aS_BFu7s_BFu0i { short v1; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aS_BFu7s_BFu0ll { short v1; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu7s_BFu0s { short v1; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aS_BFu8c_BFu0c { short v1; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aS_BFu8c_BFu0i { short v1; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aS_BFu8c_BFu0ll { short v1; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu8c_BFu0s { short v1; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aS_BFu8i_BFu0c { short v1; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aS_BFu8i_BFu0i { short v1; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aS_BFu8i_BFu0ll { short v1; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu8i_BFu0s { short v1; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aS_BFu8ll_BFu0c { short v1; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aS_BFu8ll_BFu0i { short v1; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aS_BFu8ll_BFu0ll { short v1; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu8ll_BFu0s { short v1; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aS_BFu8s_BFu0c { short v1; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aS_BFu8s_BFu0i { short v1; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aS_BFu8s_BFu0ll { short v1; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu8s_BFu0s { short v1; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aS_BFu9i_BFu0c { short v1; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aS_BFu9i_BFu0i { short v1; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aS_BFu9i_BFu0ll { short v1; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu9i_BFu0s { short v1; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aS_BFu9ll_BFu0c { short v1; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aS_BFu9ll_BFu0i { short v1; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aS_BFu9ll_BFu0ll { short v1; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu9ll_BFu0s { short v1; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aS_BFu9s_BFu0c { short v1; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aS_BFu9s_BFu0i { short v1; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aS_BFu9s_BFu0ll { short v1; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aS_BFu9s_BFu0s { short v1; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aS_C_BFu0c { short v1; char v2; unsigned char :0; };
struct __attribute__((packed)) aS_C_BFu0i { short v1; char v2; unsigned int :0; };
struct __attribute__((packed)) aS_C_BFu0ll { short v1; char v2; unsigned long long :0; };
struct __attribute__((packed)) aS_C_BFu0s { short v1; char v2; unsigned short :0; };
struct __attribute__((packed)) aS_D_BFu0c { short v1; double v2; unsigned char :0; };
struct __attribute__((packed)) aS_D_BFu0i { short v1; double v2; unsigned int :0; };
struct __attribute__((packed)) aS_D_BFu0ll { short v1; double v2; unsigned long long :0; };
struct __attribute__((packed)) aS_D_BFu0s { short v1; double v2; unsigned short :0; };
struct __attribute__((packed)) aS_F_BFu0c { short v1; float v2; unsigned char :0; };
struct __attribute__((packed)) aS_F_BFu0i { short v1; float v2; unsigned int :0; };
struct __attribute__((packed)) aS_F_BFu0ll { short v1; float v2; unsigned long long :0; };
struct __attribute__((packed)) aS_F_BFu0s { short v1; float v2; unsigned short :0; };
struct __attribute__((packed)) aS_I_BFu0c { short v1; int v2; unsigned char :0; };
struct __attribute__((packed)) aS_I_BFu0i { short v1; int v2; unsigned int :0; };
struct __attribute__((packed)) aS_I_BFu0ll { short v1; int v2; unsigned long long :0; };
struct __attribute__((packed)) aS_I_BFu0s { short v1; int v2; unsigned short :0; };
struct __attribute__((packed)) aS_Ip_BFu0c { short v1; int * v2; unsigned char :0; };
struct __attribute__((packed)) aS_Ip_BFu0i { short v1; int * v2; unsigned int :0; };
struct __attribute__((packed)) aS_Ip_BFu0ll { short v1; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aS_Ip_BFu0s { short v1; int * v2; unsigned short :0; };
struct __attribute__((packed)) aS_L_BFu0c { short v1; long long v2; unsigned char :0; };
struct __attribute__((packed)) aS_L_BFu0i { short v1; long long v2; unsigned int :0; };
struct __attribute__((packed)) aS_L_BFu0ll { short v1; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aS_L_BFu0s { short v1; long long v2; unsigned short :0; };
struct __attribute__((packed)) aS_S_BFu0c { short v1; short v2; unsigned char :0; };
struct __attribute__((packed)) aS_S_BFu0i { short v1; short v2; unsigned int :0; };
struct __attribute__((packed)) aS_S_BFu0ll { short v1; short v2; unsigned long long :0; };
struct __attribute__((packed)) aS_S_BFu0s { short v1; short v2; unsigned short :0; };
struct __attribute__((packed)) aS_Uc_BFu0c { short v1; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aS_Uc_BFu0i { short v1; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aS_Uc_BFu0ll { short v1; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aS_Uc_BFu0s { short v1; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aS_Ui_BFu0c { short v1; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aS_Ui_BFu0i { short v1; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aS_Ui_BFu0ll { short v1; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aS_Ui_BFu0s { short v1; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aS_Ul_BFu0c { short v1; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aS_Ul_BFu0i { short v1; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aS_Ul_BFu0ll { short v1; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aS_Ul_BFu0s { short v1; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aS_Us_BFu0c { short v1; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aS_Us_BFu0i { short v1; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aS_Us_BFu0ll { short v1; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aS_Us_BFu0s { short v1; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aS_Vp_BFu0c { short v1; void * v2; unsigned char :0; };
struct __attribute__((packed)) aS_Vp_BFu0i { short v1; void * v2; unsigned int :0; };
struct __attribute__((packed)) aS_Vp_BFu0ll { short v1; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aS_Vp_BFu0s { short v1; void * v2; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu0c { unsigned char v1; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu0c_BFu0c { unsigned char v1; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu0c_BFu0i { unsigned char v1; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu0c_BFu0ll { unsigned char v1; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu0c_BFu0s { unsigned char v1; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu0c_BFu15i { unsigned char v1; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aUc_BFu0c_BFu15ll { unsigned char v1; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUc_BFu0c_BFu15s { unsigned char v1; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aUc_BFu0c_BFu16i { unsigned char v1; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aUc_BFu0c_BFu16ll { unsigned char v1; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUc_BFu0c_BFu16s { unsigned char v1; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aUc_BFu0c_BFu17i { unsigned char v1; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aUc_BFu0c_BFu17ll { unsigned char v1; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUc_BFu0c_BFu1c { unsigned char v1; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aUc_BFu0c_BFu1i { unsigned char v1; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aUc_BFu0c_BFu1ll { unsigned char v1; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUc_BFu0c_BFu1s { unsigned char v1; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aUc_BFu0c_BFu31i { unsigned char v1; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aUc_BFu0c_BFu31ll { unsigned char v1; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUc_BFu0c_BFu32i { unsigned char v1; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aUc_BFu0c_BFu32ll { unsigned char v1; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUc_BFu0c_BFu33 { unsigned char v1; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUc_BFu0c_BFu7c { unsigned char v1; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aUc_BFu0c_BFu7i { unsigned char v1; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aUc_BFu0c_BFu7ll { unsigned char v1; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUc_BFu0c_BFu7s { unsigned char v1; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aUc_BFu0c_BFu8c { unsigned char v1; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aUc_BFu0c_BFu8i { unsigned char v1; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aUc_BFu0c_BFu8ll { unsigned char v1; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUc_BFu0c_BFu8s { unsigned char v1; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aUc_BFu0c_BFu9i { unsigned char v1; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aUc_BFu0c_BFu9ll { unsigned char v1; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUc_BFu0c_BFu9s { unsigned char v1; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aUc_BFu0c_C { unsigned char v1; unsigned char :0; char v2; };
struct __attribute__((packed)) aUc_BFu0c_D { unsigned char v1; unsigned char :0; double v2; };
struct __attribute__((packed)) aUc_BFu0c_F { unsigned char v1; unsigned char :0; float v2; };
struct __attribute__((packed)) aUc_BFu0c_I { unsigned char v1; unsigned char :0; int v2; };
struct __attribute__((packed)) aUc_BFu0c_Ip { unsigned char v1; unsigned char :0; int * v2; };
struct __attribute__((packed)) aUc_BFu0c_L { unsigned char v1; unsigned char :0; long long v2; };
struct __attribute__((packed)) aUc_BFu0c_S { unsigned char v1; unsigned char :0; short v2; };
struct __attribute__((packed)) aUc_BFu0c_Uc { unsigned char v1; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aUc_BFu0c_Ui { unsigned char v1; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aUc_BFu0c_Ul { unsigned char v1; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aUc_BFu0c_Us { unsigned char v1; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aUc_BFu0c_Vp { unsigned char v1; unsigned char :0; void * v2; };
struct __attribute__((packed)) aUc_BFu0i { unsigned char v1; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu0i_BFu0c { unsigned char v1; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu0i_BFu0i { unsigned char v1; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu0i_BFu0ll { unsigned char v1; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu0i_BFu0s { unsigned char v1; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu0i_BFu15i { unsigned char v1; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aUc_BFu0i_BFu15ll { unsigned char v1; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUc_BFu0i_BFu15s { unsigned char v1; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aUc_BFu0i_BFu16i { unsigned char v1; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aUc_BFu0i_BFu16ll { unsigned char v1; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUc_BFu0i_BFu16s { unsigned char v1; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aUc_BFu0i_BFu17i { unsigned char v1; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aUc_BFu0i_BFu17ll { unsigned char v1; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUc_BFu0i_BFu1c { unsigned char v1; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aUc_BFu0i_BFu1i { unsigned char v1; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aUc_BFu0i_BFu1ll { unsigned char v1; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUc_BFu0i_BFu1s { unsigned char v1; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aUc_BFu0i_BFu31i { unsigned char v1; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aUc_BFu0i_BFu31ll { unsigned char v1; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUc_BFu0i_BFu32i { unsigned char v1; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aUc_BFu0i_BFu32ll { unsigned char v1; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUc_BFu0i_BFu33 { unsigned char v1; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUc_BFu0i_BFu7c { unsigned char v1; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aUc_BFu0i_BFu7i { unsigned char v1; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aUc_BFu0i_BFu7ll { unsigned char v1; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUc_BFu0i_BFu7s { unsigned char v1; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aUc_BFu0i_BFu8c { unsigned char v1; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aUc_BFu0i_BFu8i { unsigned char v1; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aUc_BFu0i_BFu8ll { unsigned char v1; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUc_BFu0i_BFu8s { unsigned char v1; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aUc_BFu0i_BFu9i { unsigned char v1; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aUc_BFu0i_BFu9ll { unsigned char v1; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUc_BFu0i_BFu9s { unsigned char v1; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aUc_BFu0i_C { unsigned char v1; unsigned int :0; char v2; };
struct __attribute__((packed)) aUc_BFu0i_D { unsigned char v1; unsigned int :0; double v2; };
struct __attribute__((packed)) aUc_BFu0i_F { unsigned char v1; unsigned int :0; float v2; };
struct __attribute__((packed)) aUc_BFu0i_I { unsigned char v1; unsigned int :0; int v2; };
struct __attribute__((packed)) aUc_BFu0i_Ip { unsigned char v1; unsigned int :0; int * v2; };
struct __attribute__((packed)) aUc_BFu0i_L { unsigned char v1; unsigned int :0; long long v2; };
struct __attribute__((packed)) aUc_BFu0i_S { unsigned char v1; unsigned int :0; short v2; };
struct __attribute__((packed)) aUc_BFu0i_Uc { unsigned char v1; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aUc_BFu0i_Ui { unsigned char v1; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aUc_BFu0i_Ul { unsigned char v1; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aUc_BFu0i_Us { unsigned char v1; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aUc_BFu0i_Vp { unsigned char v1; unsigned int :0; void * v2; };
struct __attribute__((packed)) aUc_BFu0ll { unsigned char v1; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu0ll_BFu0c { unsigned char v1; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu0ll_BFu0i { unsigned char v1; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu0ll_BFu0ll { unsigned char v1; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu0ll_BFu0s { unsigned char v1; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu0ll_BFu15i { unsigned char v1; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aUc_BFu0ll_BFu15ll { unsigned char v1; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUc_BFu0ll_BFu15s { unsigned char v1; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aUc_BFu0ll_BFu16i { unsigned char v1; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aUc_BFu0ll_BFu16ll { unsigned char v1; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUc_BFu0ll_BFu16s { unsigned char v1; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aUc_BFu0ll_BFu17i { unsigned char v1; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aUc_BFu0ll_BFu17ll { unsigned char v1; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUc_BFu0ll_BFu1c { unsigned char v1; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aUc_BFu0ll_BFu1i { unsigned char v1; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aUc_BFu0ll_BFu1ll { unsigned char v1; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUc_BFu0ll_BFu1s { unsigned char v1; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aUc_BFu0ll_BFu31i { unsigned char v1; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aUc_BFu0ll_BFu31ll { unsigned char v1; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUc_BFu0ll_BFu32i { unsigned char v1; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aUc_BFu0ll_BFu32ll { unsigned char v1; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUc_BFu0ll_BFu33 { unsigned char v1; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUc_BFu0ll_BFu7c { unsigned char v1; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aUc_BFu0ll_BFu7i { unsigned char v1; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aUc_BFu0ll_BFu7ll { unsigned char v1; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUc_BFu0ll_BFu7s { unsigned char v1; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aUc_BFu0ll_BFu8c { unsigned char v1; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aUc_BFu0ll_BFu8i { unsigned char v1; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aUc_BFu0ll_BFu8ll { unsigned char v1; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUc_BFu0ll_BFu8s { unsigned char v1; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aUc_BFu0ll_BFu9i { unsigned char v1; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aUc_BFu0ll_BFu9ll { unsigned char v1; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUc_BFu0ll_BFu9s { unsigned char v1; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aUc_BFu0ll_C { unsigned char v1; unsigned long long :0; char v2; };
struct __attribute__((packed)) aUc_BFu0ll_D { unsigned char v1; unsigned long long :0; double v2; };
struct __attribute__((packed)) aUc_BFu0ll_F { unsigned char v1; unsigned long long :0; float v2; };
struct __attribute__((packed)) aUc_BFu0ll_I { unsigned char v1; unsigned long long :0; int v2; };
struct __attribute__((packed)) aUc_BFu0ll_Ip { unsigned char v1; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aUc_BFu0ll_L { unsigned char v1; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aUc_BFu0ll_S { unsigned char v1; unsigned long long :0; short v2; };
struct __attribute__((packed)) aUc_BFu0ll_Uc { unsigned char v1; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aUc_BFu0ll_Ui { unsigned char v1; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aUc_BFu0ll_Ul { unsigned char v1; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aUc_BFu0ll_Us { unsigned char v1; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aUc_BFu0ll_Vp { unsigned char v1; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aUc_BFu0s { unsigned char v1; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu0s_BFu0c { unsigned char v1; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu0s_BFu0i { unsigned char v1; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu0s_BFu0ll { unsigned char v1; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu0s_BFu0s { unsigned char v1; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu0s_BFu15i { unsigned char v1; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aUc_BFu0s_BFu15ll { unsigned char v1; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUc_BFu0s_BFu15s { unsigned char v1; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aUc_BFu0s_BFu16i { unsigned char v1; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aUc_BFu0s_BFu16ll { unsigned char v1; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUc_BFu0s_BFu16s { unsigned char v1; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aUc_BFu0s_BFu17i { unsigned char v1; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aUc_BFu0s_BFu17ll { unsigned char v1; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUc_BFu0s_BFu1c { unsigned char v1; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aUc_BFu0s_BFu1i { unsigned char v1; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aUc_BFu0s_BFu1ll { unsigned char v1; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUc_BFu0s_BFu1s { unsigned char v1; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aUc_BFu0s_BFu31i { unsigned char v1; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aUc_BFu0s_BFu31ll { unsigned char v1; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUc_BFu0s_BFu32i { unsigned char v1; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aUc_BFu0s_BFu32ll { unsigned char v1; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUc_BFu0s_BFu33 { unsigned char v1; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUc_BFu0s_BFu7c { unsigned char v1; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aUc_BFu0s_BFu7i { unsigned char v1; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aUc_BFu0s_BFu7ll { unsigned char v1; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUc_BFu0s_BFu7s { unsigned char v1; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aUc_BFu0s_BFu8c { unsigned char v1; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aUc_BFu0s_BFu8i { unsigned char v1; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aUc_BFu0s_BFu8ll { unsigned char v1; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUc_BFu0s_BFu8s { unsigned char v1; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aUc_BFu0s_BFu9i { unsigned char v1; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aUc_BFu0s_BFu9ll { unsigned char v1; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUc_BFu0s_BFu9s { unsigned char v1; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aUc_BFu0s_C { unsigned char v1; unsigned short :0; char v2; };
struct __attribute__((packed)) aUc_BFu0s_D { unsigned char v1; unsigned short :0; double v2; };
struct __attribute__((packed)) aUc_BFu0s_F { unsigned char v1; unsigned short :0; float v2; };
struct __attribute__((packed)) aUc_BFu0s_I { unsigned char v1; unsigned short :0; int v2; };
struct __attribute__((packed)) aUc_BFu0s_Ip { unsigned char v1; unsigned short :0; int * v2; };
struct __attribute__((packed)) aUc_BFu0s_L { unsigned char v1; unsigned short :0; long long v2; };
struct __attribute__((packed)) aUc_BFu0s_S { unsigned char v1; unsigned short :0; short v2; };
struct __attribute__((packed)) aUc_BFu0s_Uc { unsigned char v1; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aUc_BFu0s_Ui { unsigned char v1; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aUc_BFu0s_Ul { unsigned char v1; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aUc_BFu0s_Us { unsigned char v1; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aUc_BFu0s_Vp { unsigned char v1; unsigned short :0; void * v2; };
struct __attribute__((packed)) aUc_BFu15i_BFu0c { unsigned char v1; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu15i_BFu0i { unsigned char v1; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu15i_BFu0ll { unsigned char v1; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu15i_BFu0s { unsigned char v1; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu15ll_BFu0c { unsigned char v1; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu15ll_BFu0i { unsigned char v1; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu15ll_BFu0ll { unsigned char v1; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu15ll_BFu0s { unsigned char v1; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu15s_BFu0c { unsigned char v1; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu15s_BFu0i { unsigned char v1; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu15s_BFu0ll { unsigned char v1; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu15s_BFu0s { unsigned char v1; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu16i_BFu0c { unsigned char v1; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu16i_BFu0i { unsigned char v1; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu16i_BFu0ll { unsigned char v1; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu16i_BFu0s { unsigned char v1; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu16ll_BFu0c { unsigned char v1; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu16ll_BFu0i { unsigned char v1; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu16ll_BFu0ll { unsigned char v1; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu16ll_BFu0s { unsigned char v1; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu16s_BFu0c { unsigned char v1; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu16s_BFu0i { unsigned char v1; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu16s_BFu0ll { unsigned char v1; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu16s_BFu0s { unsigned char v1; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu17i_BFu0c { unsigned char v1; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu17i_BFu0i { unsigned char v1; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu17i_BFu0ll { unsigned char v1; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu17i_BFu0s { unsigned char v1; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu17ll_BFu0c { unsigned char v1; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu17ll_BFu0i { unsigned char v1; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu17ll_BFu0ll { unsigned char v1; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu17ll_BFu0s { unsigned char v1; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu1c_BFu0c { unsigned char v1; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu1c_BFu0i { unsigned char v1; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu1c_BFu0ll { unsigned char v1; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu1c_BFu0s { unsigned char v1; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu1i_BFu0c { unsigned char v1; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu1i_BFu0i { unsigned char v1; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu1i_BFu0ll { unsigned char v1; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu1i_BFu0s { unsigned char v1; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu1ll_BFu0c { unsigned char v1; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu1ll_BFu0i { unsigned char v1; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu1ll_BFu0ll { unsigned char v1; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu1ll_BFu0s { unsigned char v1; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu1s_BFu0c { unsigned char v1; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu1s_BFu0i { unsigned char v1; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu1s_BFu0ll { unsigned char v1; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu1s_BFu0s { unsigned char v1; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu31i_BFu0c { unsigned char v1; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu31i_BFu0i { unsigned char v1; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu31i_BFu0ll { unsigned char v1; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu31i_BFu0s { unsigned char v1; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu31ll_BFu0c { unsigned char v1; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu31ll_BFu0i { unsigned char v1; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu31ll_BFu0ll { unsigned char v1; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu31ll_BFu0s { unsigned char v1; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu32i_BFu0c { unsigned char v1; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu32i_BFu0i { unsigned char v1; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu32i_BFu0ll { unsigned char v1; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu32i_BFu0s { unsigned char v1; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu32ll_BFu0c { unsigned char v1; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu32ll_BFu0i { unsigned char v1; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu32ll_BFu0ll { unsigned char v1; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu32ll_BFu0s { unsigned char v1; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu33_BFu0c { unsigned char v1; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu33_BFu0i { unsigned char v1; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu33_BFu0ll { unsigned char v1; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu33_BFu0s { unsigned char v1; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu7c_BFu0c { unsigned char v1; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu7c_BFu0i { unsigned char v1; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu7c_BFu0ll { unsigned char v1; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu7c_BFu0s { unsigned char v1; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu7i_BFu0c { unsigned char v1; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu7i_BFu0i { unsigned char v1; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu7i_BFu0ll { unsigned char v1; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu7i_BFu0s { unsigned char v1; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu7ll_BFu0c { unsigned char v1; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu7ll_BFu0i { unsigned char v1; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu7ll_BFu0ll { unsigned char v1; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu7ll_BFu0s { unsigned char v1; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu7s_BFu0c { unsigned char v1; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu7s_BFu0i { unsigned char v1; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu7s_BFu0ll { unsigned char v1; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu7s_BFu0s { unsigned char v1; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu8c_BFu0c { unsigned char v1; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu8c_BFu0i { unsigned char v1; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu8c_BFu0ll { unsigned char v1; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu8c_BFu0s { unsigned char v1; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu8i_BFu0c { unsigned char v1; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu8i_BFu0i { unsigned char v1; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu8i_BFu0ll { unsigned char v1; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu8i_BFu0s { unsigned char v1; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu8ll_BFu0c { unsigned char v1; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu8ll_BFu0i { unsigned char v1; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu8ll_BFu0ll { unsigned char v1; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu8ll_BFu0s { unsigned char v1; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu8s_BFu0c { unsigned char v1; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu8s_BFu0i { unsigned char v1; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu8s_BFu0ll { unsigned char v1; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu8s_BFu0s { unsigned char v1; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu9i_BFu0c { unsigned char v1; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu9i_BFu0i { unsigned char v1; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu9i_BFu0ll { unsigned char v1; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu9i_BFu0s { unsigned char v1; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu9ll_BFu0c { unsigned char v1; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu9ll_BFu0i { unsigned char v1; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu9ll_BFu0ll { unsigned char v1; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu9ll_BFu0s { unsigned char v1; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu9s_BFu0c { unsigned char v1; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aUc_BFu9s_BFu0i { unsigned char v1; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aUc_BFu9s_BFu0ll { unsigned char v1; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aUc_BFu9s_BFu0s { unsigned char v1; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aUc_C_BFu0c { unsigned char v1; char v2; unsigned char :0; };
struct __attribute__((packed)) aUc_C_BFu0i { unsigned char v1; char v2; unsigned int :0; };
struct __attribute__((packed)) aUc_C_BFu0ll { unsigned char v1; char v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_C_BFu0s { unsigned char v1; char v2; unsigned short :0; };
struct __attribute__((packed)) aUc_D_BFu0c { unsigned char v1; double v2; unsigned char :0; };
struct __attribute__((packed)) aUc_D_BFu0i { unsigned char v1; double v2; unsigned int :0; };
struct __attribute__((packed)) aUc_D_BFu0ll { unsigned char v1; double v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_D_BFu0s { unsigned char v1; double v2; unsigned short :0; };
struct __attribute__((packed)) aUc_F_BFu0c { unsigned char v1; float v2; unsigned char :0; };
struct __attribute__((packed)) aUc_F_BFu0i { unsigned char v1; float v2; unsigned int :0; };
struct __attribute__((packed)) aUc_F_BFu0ll { unsigned char v1; float v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_F_BFu0s { unsigned char v1; float v2; unsigned short :0; };
struct __attribute__((packed)) aUc_I_BFu0c { unsigned char v1; int v2; unsigned char :0; };
struct __attribute__((packed)) aUc_I_BFu0i { unsigned char v1; int v2; unsigned int :0; };
struct __attribute__((packed)) aUc_I_BFu0ll { unsigned char v1; int v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_I_BFu0s { unsigned char v1; int v2; unsigned short :0; };
struct __attribute__((packed)) aUc_Ip_BFu0c { unsigned char v1; int * v2; unsigned char :0; };
struct __attribute__((packed)) aUc_Ip_BFu0i { unsigned char v1; int * v2; unsigned int :0; };
struct __attribute__((packed)) aUc_Ip_BFu0ll { unsigned char v1; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_Ip_BFu0s { unsigned char v1; int * v2; unsigned short :0; };
struct __attribute__((packed)) aUc_L_BFu0c { unsigned char v1; long long v2; unsigned char :0; };
struct __attribute__((packed)) aUc_L_BFu0i { unsigned char v1; long long v2; unsigned int :0; };
struct __attribute__((packed)) aUc_L_BFu0ll { unsigned char v1; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_L_BFu0s { unsigned char v1; long long v2; unsigned short :0; };
struct __attribute__((packed)) aUc_S_BFu0c { unsigned char v1; short v2; unsigned char :0; };
struct __attribute__((packed)) aUc_S_BFu0i { unsigned char v1; short v2; unsigned int :0; };
struct __attribute__((packed)) aUc_S_BFu0ll { unsigned char v1; short v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_S_BFu0s { unsigned char v1; short v2; unsigned short :0; };
struct __attribute__((packed)) aUc_Uc_BFu0c { unsigned char v1; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aUc_Uc_BFu0i { unsigned char v1; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aUc_Uc_BFu0ll { unsigned char v1; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_Uc_BFu0s { unsigned char v1; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aUc_Ui_BFu0c { unsigned char v1; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aUc_Ui_BFu0i { unsigned char v1; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aUc_Ui_BFu0ll { unsigned char v1; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_Ui_BFu0s { unsigned char v1; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aUc_Ul_BFu0c { unsigned char v1; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aUc_Ul_BFu0i { unsigned char v1; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aUc_Ul_BFu0ll { unsigned char v1; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_Ul_BFu0s { unsigned char v1; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aUc_Us_BFu0c { unsigned char v1; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aUc_Us_BFu0i { unsigned char v1; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aUc_Us_BFu0ll { unsigned char v1; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_Us_BFu0s { unsigned char v1; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aUc_Vp_BFu0c { unsigned char v1; void * v2; unsigned char :0; };
struct __attribute__((packed)) aUc_Vp_BFu0i { unsigned char v1; void * v2; unsigned int :0; };
struct __attribute__((packed)) aUc_Vp_BFu0ll { unsigned char v1; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_Vp_BFu0s { unsigned char v1; void * v2; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu0c { unsigned int v1; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu0c_BFu0c { unsigned int v1; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu0c_BFu0i { unsigned int v1; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu0c_BFu0ll { unsigned int v1; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu0c_BFu0s { unsigned int v1; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu0c_BFu15i { unsigned int v1; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aUi_BFu0c_BFu15ll { unsigned int v1; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUi_BFu0c_BFu15s { unsigned int v1; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aUi_BFu0c_BFu16i { unsigned int v1; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aUi_BFu0c_BFu16ll { unsigned int v1; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUi_BFu0c_BFu16s { unsigned int v1; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aUi_BFu0c_BFu17i { unsigned int v1; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aUi_BFu0c_BFu17ll { unsigned int v1; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUi_BFu0c_BFu1c { unsigned int v1; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aUi_BFu0c_BFu1i { unsigned int v1; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aUi_BFu0c_BFu1ll { unsigned int v1; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUi_BFu0c_BFu1s { unsigned int v1; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aUi_BFu0c_BFu31i { unsigned int v1; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aUi_BFu0c_BFu31ll { unsigned int v1; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUi_BFu0c_BFu32i { unsigned int v1; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aUi_BFu0c_BFu32ll { unsigned int v1; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUi_BFu0c_BFu33 { unsigned int v1; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUi_BFu0c_BFu7c { unsigned int v1; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aUi_BFu0c_BFu7i { unsigned int v1; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aUi_BFu0c_BFu7ll { unsigned int v1; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUi_BFu0c_BFu7s { unsigned int v1; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aUi_BFu0c_BFu8c { unsigned int v1; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aUi_BFu0c_BFu8i { unsigned int v1; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aUi_BFu0c_BFu8ll { unsigned int v1; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUi_BFu0c_BFu8s { unsigned int v1; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aUi_BFu0c_BFu9i { unsigned int v1; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aUi_BFu0c_BFu9ll { unsigned int v1; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUi_BFu0c_BFu9s { unsigned int v1; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aUi_BFu0c_C { unsigned int v1; unsigned char :0; char v2; };
struct __attribute__((packed)) aUi_BFu0c_D { unsigned int v1; unsigned char :0; double v2; };
struct __attribute__((packed)) aUi_BFu0c_F { unsigned int v1; unsigned char :0; float v2; };
struct __attribute__((packed)) aUi_BFu0c_I { unsigned int v1; unsigned char :0; int v2; };
struct __attribute__((packed)) aUi_BFu0c_Ip { unsigned int v1; unsigned char :0; int * v2; };
struct __attribute__((packed)) aUi_BFu0c_L { unsigned int v1; unsigned char :0; long long v2; };
struct __attribute__((packed)) aUi_BFu0c_S { unsigned int v1; unsigned char :0; short v2; };
struct __attribute__((packed)) aUi_BFu0c_Uc { unsigned int v1; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aUi_BFu0c_Ui { unsigned int v1; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aUi_BFu0c_Ul { unsigned int v1; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aUi_BFu0c_Us { unsigned int v1; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aUi_BFu0c_Vp { unsigned int v1; unsigned char :0; void * v2; };
struct __attribute__((packed)) aUi_BFu0i { unsigned int v1; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu0i_BFu0c { unsigned int v1; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu0i_BFu0i { unsigned int v1; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu0i_BFu0ll { unsigned int v1; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu0i_BFu0s { unsigned int v1; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu0i_BFu15i { unsigned int v1; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aUi_BFu0i_BFu15ll { unsigned int v1; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUi_BFu0i_BFu15s { unsigned int v1; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aUi_BFu0i_BFu16i { unsigned int v1; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aUi_BFu0i_BFu16ll { unsigned int v1; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUi_BFu0i_BFu16s { unsigned int v1; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aUi_BFu0i_BFu17i { unsigned int v1; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aUi_BFu0i_BFu17ll { unsigned int v1; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUi_BFu0i_BFu1c { unsigned int v1; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aUi_BFu0i_BFu1i { unsigned int v1; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aUi_BFu0i_BFu1ll { unsigned int v1; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUi_BFu0i_BFu1s { unsigned int v1; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aUi_BFu0i_BFu31i { unsigned int v1; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aUi_BFu0i_BFu31ll { unsigned int v1; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUi_BFu0i_BFu32i { unsigned int v1; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aUi_BFu0i_BFu32ll { unsigned int v1; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUi_BFu0i_BFu33 { unsigned int v1; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUi_BFu0i_BFu7c { unsigned int v1; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aUi_BFu0i_BFu7i { unsigned int v1; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aUi_BFu0i_BFu7ll { unsigned int v1; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUi_BFu0i_BFu7s { unsigned int v1; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aUi_BFu0i_BFu8c { unsigned int v1; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aUi_BFu0i_BFu8i { unsigned int v1; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aUi_BFu0i_BFu8ll { unsigned int v1; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUi_BFu0i_BFu8s { unsigned int v1; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aUi_BFu0i_BFu9i { unsigned int v1; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aUi_BFu0i_BFu9ll { unsigned int v1; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUi_BFu0i_BFu9s { unsigned int v1; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aUi_BFu0i_C { unsigned int v1; unsigned int :0; char v2; };
struct __attribute__((packed)) aUi_BFu0i_D { unsigned int v1; unsigned int :0; double v2; };
struct __attribute__((packed)) aUi_BFu0i_F { unsigned int v1; unsigned int :0; float v2; };
struct __attribute__((packed)) aUi_BFu0i_I { unsigned int v1; unsigned int :0; int v2; };
struct __attribute__((packed)) aUi_BFu0i_Ip { unsigned int v1; unsigned int :0; int * v2; };
struct __attribute__((packed)) aUi_BFu0i_L { unsigned int v1; unsigned int :0; long long v2; };
struct __attribute__((packed)) aUi_BFu0i_S { unsigned int v1; unsigned int :0; short v2; };
struct __attribute__((packed)) aUi_BFu0i_Uc { unsigned int v1; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aUi_BFu0i_Ui { unsigned int v1; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aUi_BFu0i_Ul { unsigned int v1; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aUi_BFu0i_Us { unsigned int v1; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aUi_BFu0i_Vp { unsigned int v1; unsigned int :0; void * v2; };
struct __attribute__((packed)) aUi_BFu0ll { unsigned int v1; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu0ll_BFu0c { unsigned int v1; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu0ll_BFu0i { unsigned int v1; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu0ll_BFu0ll { unsigned int v1; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu0ll_BFu0s { unsigned int v1; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu0ll_BFu15i { unsigned int v1; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aUi_BFu0ll_BFu15ll { unsigned int v1; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUi_BFu0ll_BFu15s { unsigned int v1; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aUi_BFu0ll_BFu16i { unsigned int v1; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aUi_BFu0ll_BFu16ll { unsigned int v1; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUi_BFu0ll_BFu16s { unsigned int v1; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aUi_BFu0ll_BFu17i { unsigned int v1; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aUi_BFu0ll_BFu17ll { unsigned int v1; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUi_BFu0ll_BFu1c { unsigned int v1; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aUi_BFu0ll_BFu1i { unsigned int v1; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aUi_BFu0ll_BFu1ll { unsigned int v1; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUi_BFu0ll_BFu1s { unsigned int v1; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aUi_BFu0ll_BFu31i { unsigned int v1; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aUi_BFu0ll_BFu31ll { unsigned int v1; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUi_BFu0ll_BFu32i { unsigned int v1; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aUi_BFu0ll_BFu32ll { unsigned int v1; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUi_BFu0ll_BFu33 { unsigned int v1; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUi_BFu0ll_BFu7c { unsigned int v1; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aUi_BFu0ll_BFu7i { unsigned int v1; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aUi_BFu0ll_BFu7ll { unsigned int v1; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUi_BFu0ll_BFu7s { unsigned int v1; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aUi_BFu0ll_BFu8c { unsigned int v1; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aUi_BFu0ll_BFu8i { unsigned int v1; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aUi_BFu0ll_BFu8ll { unsigned int v1; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUi_BFu0ll_BFu8s { unsigned int v1; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aUi_BFu0ll_BFu9i { unsigned int v1; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aUi_BFu0ll_BFu9ll { unsigned int v1; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUi_BFu0ll_BFu9s { unsigned int v1; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aUi_BFu0ll_C { unsigned int v1; unsigned long long :0; char v2; };
struct __attribute__((packed)) aUi_BFu0ll_D { unsigned int v1; unsigned long long :0; double v2; };
struct __attribute__((packed)) aUi_BFu0ll_F { unsigned int v1; unsigned long long :0; float v2; };
struct __attribute__((packed)) aUi_BFu0ll_I { unsigned int v1; unsigned long long :0; int v2; };
struct __attribute__((packed)) aUi_BFu0ll_Ip { unsigned int v1; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aUi_BFu0ll_L { unsigned int v1; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aUi_BFu0ll_S { unsigned int v1; unsigned long long :0; short v2; };
struct __attribute__((packed)) aUi_BFu0ll_Uc { unsigned int v1; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aUi_BFu0ll_Ui { unsigned int v1; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aUi_BFu0ll_Ul { unsigned int v1; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aUi_BFu0ll_Us { unsigned int v1; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aUi_BFu0ll_Vp { unsigned int v1; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aUi_BFu0s { unsigned int v1; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu0s_BFu0c { unsigned int v1; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu0s_BFu0i { unsigned int v1; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu0s_BFu0ll { unsigned int v1; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu0s_BFu0s { unsigned int v1; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu0s_BFu15i { unsigned int v1; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aUi_BFu0s_BFu15ll { unsigned int v1; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUi_BFu0s_BFu15s { unsigned int v1; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aUi_BFu0s_BFu16i { unsigned int v1; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aUi_BFu0s_BFu16ll { unsigned int v1; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUi_BFu0s_BFu16s { unsigned int v1; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aUi_BFu0s_BFu17i { unsigned int v1; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aUi_BFu0s_BFu17ll { unsigned int v1; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUi_BFu0s_BFu1c { unsigned int v1; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aUi_BFu0s_BFu1i { unsigned int v1; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aUi_BFu0s_BFu1ll { unsigned int v1; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUi_BFu0s_BFu1s { unsigned int v1; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aUi_BFu0s_BFu31i { unsigned int v1; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aUi_BFu0s_BFu31ll { unsigned int v1; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUi_BFu0s_BFu32i { unsigned int v1; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aUi_BFu0s_BFu32ll { unsigned int v1; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUi_BFu0s_BFu33 { unsigned int v1; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUi_BFu0s_BFu7c { unsigned int v1; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aUi_BFu0s_BFu7i { unsigned int v1; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aUi_BFu0s_BFu7ll { unsigned int v1; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUi_BFu0s_BFu7s { unsigned int v1; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aUi_BFu0s_BFu8c { unsigned int v1; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aUi_BFu0s_BFu8i { unsigned int v1; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aUi_BFu0s_BFu8ll { unsigned int v1; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUi_BFu0s_BFu8s { unsigned int v1; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aUi_BFu0s_BFu9i { unsigned int v1; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aUi_BFu0s_BFu9ll { unsigned int v1; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUi_BFu0s_BFu9s { unsigned int v1; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aUi_BFu0s_C { unsigned int v1; unsigned short :0; char v2; };
struct __attribute__((packed)) aUi_BFu0s_D { unsigned int v1; unsigned short :0; double v2; };
struct __attribute__((packed)) aUi_BFu0s_F { unsigned int v1; unsigned short :0; float v2; };
struct __attribute__((packed)) aUi_BFu0s_I { unsigned int v1; unsigned short :0; int v2; };
struct __attribute__((packed)) aUi_BFu0s_Ip { unsigned int v1; unsigned short :0; int * v2; };
struct __attribute__((packed)) aUi_BFu0s_L { unsigned int v1; unsigned short :0; long long v2; };
struct __attribute__((packed)) aUi_BFu0s_S { unsigned int v1; unsigned short :0; short v2; };
struct __attribute__((packed)) aUi_BFu0s_Uc { unsigned int v1; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aUi_BFu0s_Ui { unsigned int v1; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aUi_BFu0s_Ul { unsigned int v1; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aUi_BFu0s_Us { unsigned int v1; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aUi_BFu0s_Vp { unsigned int v1; unsigned short :0; void * v2; };
struct __attribute__((packed)) aUi_BFu15i_BFu0c { unsigned int v1; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu15i_BFu0i { unsigned int v1; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu15i_BFu0ll { unsigned int v1; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu15i_BFu0s { unsigned int v1; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu15ll_BFu0c { unsigned int v1; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu15ll_BFu0i { unsigned int v1; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu15ll_BFu0ll { unsigned int v1; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu15ll_BFu0s { unsigned int v1; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu15s_BFu0c { unsigned int v1; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu15s_BFu0i { unsigned int v1; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu15s_BFu0ll { unsigned int v1; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu15s_BFu0s { unsigned int v1; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu16i_BFu0c { unsigned int v1; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu16i_BFu0i { unsigned int v1; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu16i_BFu0ll { unsigned int v1; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu16i_BFu0s { unsigned int v1; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu16ll_BFu0c { unsigned int v1; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu16ll_BFu0i { unsigned int v1; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu16ll_BFu0ll { unsigned int v1; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu16ll_BFu0s { unsigned int v1; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu16s_BFu0c { unsigned int v1; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu16s_BFu0i { unsigned int v1; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu16s_BFu0ll { unsigned int v1; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu16s_BFu0s { unsigned int v1; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu17i_BFu0c { unsigned int v1; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu17i_BFu0i { unsigned int v1; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu17i_BFu0ll { unsigned int v1; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu17i_BFu0s { unsigned int v1; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu17ll_BFu0c { unsigned int v1; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu17ll_BFu0i { unsigned int v1; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu17ll_BFu0ll { unsigned int v1; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu17ll_BFu0s { unsigned int v1; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu1c_BFu0c { unsigned int v1; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu1c_BFu0i { unsigned int v1; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu1c_BFu0ll { unsigned int v1; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu1c_BFu0s { unsigned int v1; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu1i_BFu0c { unsigned int v1; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu1i_BFu0i { unsigned int v1; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu1i_BFu0ll { unsigned int v1; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu1i_BFu0s { unsigned int v1; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu1ll_BFu0c { unsigned int v1; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu1ll_BFu0i { unsigned int v1; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu1ll_BFu0ll { unsigned int v1; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu1ll_BFu0s { unsigned int v1; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu1s_BFu0c { unsigned int v1; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu1s_BFu0i { unsigned int v1; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu1s_BFu0ll { unsigned int v1; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu1s_BFu0s { unsigned int v1; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu31i_BFu0c { unsigned int v1; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu31i_BFu0i { unsigned int v1; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu31i_BFu0ll { unsigned int v1; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu31i_BFu0s { unsigned int v1; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu31ll_BFu0c { unsigned int v1; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu31ll_BFu0i { unsigned int v1; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu31ll_BFu0ll { unsigned int v1; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu31ll_BFu0s { unsigned int v1; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu32i_BFu0c { unsigned int v1; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu32i_BFu0i { unsigned int v1; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu32i_BFu0ll { unsigned int v1; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu32i_BFu0s { unsigned int v1; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu32ll_BFu0c { unsigned int v1; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu32ll_BFu0i { unsigned int v1; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu32ll_BFu0ll { unsigned int v1; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu32ll_BFu0s { unsigned int v1; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu33_BFu0c { unsigned int v1; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu33_BFu0i { unsigned int v1; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu33_BFu0ll { unsigned int v1; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu33_BFu0s { unsigned int v1; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu7c_BFu0c { unsigned int v1; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu7c_BFu0i { unsigned int v1; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu7c_BFu0ll { unsigned int v1; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu7c_BFu0s { unsigned int v1; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu7i_BFu0c { unsigned int v1; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu7i_BFu0i { unsigned int v1; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu7i_BFu0ll { unsigned int v1; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu7i_BFu0s { unsigned int v1; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu7ll_BFu0c { unsigned int v1; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu7ll_BFu0i { unsigned int v1; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu7ll_BFu0ll { unsigned int v1; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu7ll_BFu0s { unsigned int v1; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu7s_BFu0c { unsigned int v1; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu7s_BFu0i { unsigned int v1; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu7s_BFu0ll { unsigned int v1; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu7s_BFu0s { unsigned int v1; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu8c_BFu0c { unsigned int v1; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu8c_BFu0i { unsigned int v1; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu8c_BFu0ll { unsigned int v1; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu8c_BFu0s { unsigned int v1; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu8i_BFu0c { unsigned int v1; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu8i_BFu0i { unsigned int v1; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu8i_BFu0ll { unsigned int v1; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu8i_BFu0s { unsigned int v1; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu8ll_BFu0c { unsigned int v1; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu8ll_BFu0i { unsigned int v1; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu8ll_BFu0ll { unsigned int v1; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu8ll_BFu0s { unsigned int v1; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu8s_BFu0c { unsigned int v1; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu8s_BFu0i { unsigned int v1; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu8s_BFu0ll { unsigned int v1; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu8s_BFu0s { unsigned int v1; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu9i_BFu0c { unsigned int v1; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu9i_BFu0i { unsigned int v1; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu9i_BFu0ll { unsigned int v1; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu9i_BFu0s { unsigned int v1; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu9ll_BFu0c { unsigned int v1; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu9ll_BFu0i { unsigned int v1; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu9ll_BFu0ll { unsigned int v1; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu9ll_BFu0s { unsigned int v1; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu9s_BFu0c { unsigned int v1; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aUi_BFu9s_BFu0i { unsigned int v1; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aUi_BFu9s_BFu0ll { unsigned int v1; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aUi_BFu9s_BFu0s { unsigned int v1; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aUi_C_BFu0c { unsigned int v1; char v2; unsigned char :0; };
struct __attribute__((packed)) aUi_C_BFu0i { unsigned int v1; char v2; unsigned int :0; };
struct __attribute__((packed)) aUi_C_BFu0ll { unsigned int v1; char v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_C_BFu0s { unsigned int v1; char v2; unsigned short :0; };
struct __attribute__((packed)) aUi_D_BFu0c { unsigned int v1; double v2; unsigned char :0; };
struct __attribute__((packed)) aUi_D_BFu0i { unsigned int v1; double v2; unsigned int :0; };
struct __attribute__((packed)) aUi_D_BFu0ll { unsigned int v1; double v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_D_BFu0s { unsigned int v1; double v2; unsigned short :0; };
struct __attribute__((packed)) aUi_F_BFu0c { unsigned int v1; float v2; unsigned char :0; };
struct __attribute__((packed)) aUi_F_BFu0i { unsigned int v1; float v2; unsigned int :0; };
struct __attribute__((packed)) aUi_F_BFu0ll { unsigned int v1; float v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_F_BFu0s { unsigned int v1; float v2; unsigned short :0; };
struct __attribute__((packed)) aUi_I_BFu0c { unsigned int v1; int v2; unsigned char :0; };
struct __attribute__((packed)) aUi_I_BFu0i { unsigned int v1; int v2; unsigned int :0; };
struct __attribute__((packed)) aUi_I_BFu0ll { unsigned int v1; int v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_I_BFu0s { unsigned int v1; int v2; unsigned short :0; };
struct __attribute__((packed)) aUi_Ip_BFu0c { unsigned int v1; int * v2; unsigned char :0; };
struct __attribute__((packed)) aUi_Ip_BFu0i { unsigned int v1; int * v2; unsigned int :0; };
struct __attribute__((packed)) aUi_Ip_BFu0ll { unsigned int v1; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_Ip_BFu0s { unsigned int v1; int * v2; unsigned short :0; };
struct __attribute__((packed)) aUi_L_BFu0c { unsigned int v1; long long v2; unsigned char :0; };
struct __attribute__((packed)) aUi_L_BFu0i { unsigned int v1; long long v2; unsigned int :0; };
struct __attribute__((packed)) aUi_L_BFu0ll { unsigned int v1; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_L_BFu0s { unsigned int v1; long long v2; unsigned short :0; };
struct __attribute__((packed)) aUi_S_BFu0c { unsigned int v1; short v2; unsigned char :0; };
struct __attribute__((packed)) aUi_S_BFu0i { unsigned int v1; short v2; unsigned int :0; };
struct __attribute__((packed)) aUi_S_BFu0ll { unsigned int v1; short v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_S_BFu0s { unsigned int v1; short v2; unsigned short :0; };
struct __attribute__((packed)) aUi_Uc_BFu0c { unsigned int v1; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aUi_Uc_BFu0i { unsigned int v1; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aUi_Uc_BFu0ll { unsigned int v1; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_Uc_BFu0s { unsigned int v1; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aUi_Ui_BFu0c { unsigned int v1; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aUi_Ui_BFu0i { unsigned int v1; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aUi_Ui_BFu0ll { unsigned int v1; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_Ui_BFu0s { unsigned int v1; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aUi_Ul_BFu0c { unsigned int v1; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aUi_Ul_BFu0i { unsigned int v1; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aUi_Ul_BFu0ll { unsigned int v1; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_Ul_BFu0s { unsigned int v1; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aUi_Us_BFu0c { unsigned int v1; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aUi_Us_BFu0i { unsigned int v1; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aUi_Us_BFu0ll { unsigned int v1; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_Us_BFu0s { unsigned int v1; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aUi_Vp_BFu0c { unsigned int v1; void * v2; unsigned char :0; };
struct __attribute__((packed)) aUi_Vp_BFu0i { unsigned int v1; void * v2; unsigned int :0; };
struct __attribute__((packed)) aUi_Vp_BFu0ll { unsigned int v1; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_Vp_BFu0s { unsigned int v1; void * v2; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu0c { unsigned long long v1; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu0c_BFu0c { unsigned long long v1; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu0c_BFu0i { unsigned long long v1; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu0c_BFu0ll { unsigned long long v1; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu0c_BFu0s { unsigned long long v1; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu0c_BFu15i { unsigned long long v1; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aUl_BFu0c_BFu15ll { unsigned long long v1; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUl_BFu0c_BFu15s { unsigned long long v1; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aUl_BFu0c_BFu16i { unsigned long long v1; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aUl_BFu0c_BFu16ll { unsigned long long v1; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUl_BFu0c_BFu16s { unsigned long long v1; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aUl_BFu0c_BFu17i { unsigned long long v1; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aUl_BFu0c_BFu17ll { unsigned long long v1; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUl_BFu0c_BFu1c { unsigned long long v1; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aUl_BFu0c_BFu1i { unsigned long long v1; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aUl_BFu0c_BFu1ll { unsigned long long v1; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUl_BFu0c_BFu1s { unsigned long long v1; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aUl_BFu0c_BFu31i { unsigned long long v1; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aUl_BFu0c_BFu31ll { unsigned long long v1; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUl_BFu0c_BFu32i { unsigned long long v1; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aUl_BFu0c_BFu32ll { unsigned long long v1; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUl_BFu0c_BFu33 { unsigned long long v1; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUl_BFu0c_BFu7c { unsigned long long v1; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aUl_BFu0c_BFu7i { unsigned long long v1; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aUl_BFu0c_BFu7ll { unsigned long long v1; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUl_BFu0c_BFu7s { unsigned long long v1; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aUl_BFu0c_BFu8c { unsigned long long v1; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aUl_BFu0c_BFu8i { unsigned long long v1; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aUl_BFu0c_BFu8ll { unsigned long long v1; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUl_BFu0c_BFu8s { unsigned long long v1; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aUl_BFu0c_BFu9i { unsigned long long v1; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aUl_BFu0c_BFu9ll { unsigned long long v1; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUl_BFu0c_BFu9s { unsigned long long v1; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aUl_BFu0c_C { unsigned long long v1; unsigned char :0; char v2; };
struct __attribute__((packed)) aUl_BFu0c_D { unsigned long long v1; unsigned char :0; double v2; };
struct __attribute__((packed)) aUl_BFu0c_F { unsigned long long v1; unsigned char :0; float v2; };
struct __attribute__((packed)) aUl_BFu0c_I { unsigned long long v1; unsigned char :0; int v2; };
struct __attribute__((packed)) aUl_BFu0c_Ip { unsigned long long v1; unsigned char :0; int * v2; };
struct __attribute__((packed)) aUl_BFu0c_L { unsigned long long v1; unsigned char :0; long long v2; };
struct __attribute__((packed)) aUl_BFu0c_S { unsigned long long v1; unsigned char :0; short v2; };
struct __attribute__((packed)) aUl_BFu0c_Uc { unsigned long long v1; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aUl_BFu0c_Ui { unsigned long long v1; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aUl_BFu0c_Ul { unsigned long long v1; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aUl_BFu0c_Us { unsigned long long v1; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aUl_BFu0c_Vp { unsigned long long v1; unsigned char :0; void * v2; };
struct __attribute__((packed)) aUl_BFu0i { unsigned long long v1; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu0i_BFu0c { unsigned long long v1; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu0i_BFu0i { unsigned long long v1; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu0i_BFu0ll { unsigned long long v1; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu0i_BFu0s { unsigned long long v1; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu0i_BFu15i { unsigned long long v1; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aUl_BFu0i_BFu15ll { unsigned long long v1; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUl_BFu0i_BFu15s { unsigned long long v1; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aUl_BFu0i_BFu16i { unsigned long long v1; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aUl_BFu0i_BFu16ll { unsigned long long v1; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUl_BFu0i_BFu16s { unsigned long long v1; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aUl_BFu0i_BFu17i { unsigned long long v1; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aUl_BFu0i_BFu17ll { unsigned long long v1; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUl_BFu0i_BFu1c { unsigned long long v1; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aUl_BFu0i_BFu1i { unsigned long long v1; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aUl_BFu0i_BFu1ll { unsigned long long v1; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUl_BFu0i_BFu1s { unsigned long long v1; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aUl_BFu0i_BFu31i { unsigned long long v1; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aUl_BFu0i_BFu31ll { unsigned long long v1; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUl_BFu0i_BFu32i { unsigned long long v1; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aUl_BFu0i_BFu32ll { unsigned long long v1; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUl_BFu0i_BFu33 { unsigned long long v1; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUl_BFu0i_BFu7c { unsigned long long v1; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aUl_BFu0i_BFu7i { unsigned long long v1; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aUl_BFu0i_BFu7ll { unsigned long long v1; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUl_BFu0i_BFu7s { unsigned long long v1; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aUl_BFu0i_BFu8c { unsigned long long v1; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aUl_BFu0i_BFu8i { unsigned long long v1; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aUl_BFu0i_BFu8ll { unsigned long long v1; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUl_BFu0i_BFu8s { unsigned long long v1; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aUl_BFu0i_BFu9i { unsigned long long v1; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aUl_BFu0i_BFu9ll { unsigned long long v1; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUl_BFu0i_BFu9s { unsigned long long v1; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aUl_BFu0i_C { unsigned long long v1; unsigned int :0; char v2; };
struct __attribute__((packed)) aUl_BFu0i_D { unsigned long long v1; unsigned int :0; double v2; };
struct __attribute__((packed)) aUl_BFu0i_F { unsigned long long v1; unsigned int :0; float v2; };
struct __attribute__((packed)) aUl_BFu0i_I { unsigned long long v1; unsigned int :0; int v2; };
struct __attribute__((packed)) aUl_BFu0i_Ip { unsigned long long v1; unsigned int :0; int * v2; };
struct __attribute__((packed)) aUl_BFu0i_L { unsigned long long v1; unsigned int :0; long long v2; };
struct __attribute__((packed)) aUl_BFu0i_S { unsigned long long v1; unsigned int :0; short v2; };
struct __attribute__((packed)) aUl_BFu0i_Uc { unsigned long long v1; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aUl_BFu0i_Ui { unsigned long long v1; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aUl_BFu0i_Ul { unsigned long long v1; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aUl_BFu0i_Us { unsigned long long v1; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aUl_BFu0i_Vp { unsigned long long v1; unsigned int :0; void * v2; };
struct __attribute__((packed)) aUl_BFu0ll { unsigned long long v1; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu0ll_BFu0c { unsigned long long v1; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu0ll_BFu0i { unsigned long long v1; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu0ll_BFu0ll { unsigned long long v1; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu0ll_BFu0s { unsigned long long v1; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu0ll_BFu15i { unsigned long long v1; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aUl_BFu0ll_BFu15ll { unsigned long long v1; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUl_BFu0ll_BFu15s { unsigned long long v1; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aUl_BFu0ll_BFu16i { unsigned long long v1; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aUl_BFu0ll_BFu16ll { unsigned long long v1; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUl_BFu0ll_BFu16s { unsigned long long v1; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aUl_BFu0ll_BFu17i { unsigned long long v1; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aUl_BFu0ll_BFu17ll { unsigned long long v1; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUl_BFu0ll_BFu1c { unsigned long long v1; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aUl_BFu0ll_BFu1i { unsigned long long v1; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aUl_BFu0ll_BFu1ll { unsigned long long v1; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUl_BFu0ll_BFu1s { unsigned long long v1; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aUl_BFu0ll_BFu31i { unsigned long long v1; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aUl_BFu0ll_BFu31ll { unsigned long long v1; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUl_BFu0ll_BFu32i { unsigned long long v1; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aUl_BFu0ll_BFu32ll { unsigned long long v1; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUl_BFu0ll_BFu33 { unsigned long long v1; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUl_BFu0ll_BFu7c { unsigned long long v1; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aUl_BFu0ll_BFu7i { unsigned long long v1; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aUl_BFu0ll_BFu7ll { unsigned long long v1; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUl_BFu0ll_BFu7s { unsigned long long v1; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aUl_BFu0ll_BFu8c { unsigned long long v1; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aUl_BFu0ll_BFu8i { unsigned long long v1; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aUl_BFu0ll_BFu8ll { unsigned long long v1; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUl_BFu0ll_BFu8s { unsigned long long v1; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aUl_BFu0ll_BFu9i { unsigned long long v1; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aUl_BFu0ll_BFu9ll { unsigned long long v1; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUl_BFu0ll_BFu9s { unsigned long long v1; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aUl_BFu0ll_C { unsigned long long v1; unsigned long long :0; char v2; };
struct __attribute__((packed)) aUl_BFu0ll_D { unsigned long long v1; unsigned long long :0; double v2; };
struct __attribute__((packed)) aUl_BFu0ll_F { unsigned long long v1; unsigned long long :0; float v2; };
struct __attribute__((packed)) aUl_BFu0ll_I { unsigned long long v1; unsigned long long :0; int v2; };
struct __attribute__((packed)) aUl_BFu0ll_Ip { unsigned long long v1; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aUl_BFu0ll_L { unsigned long long v1; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aUl_BFu0ll_S { unsigned long long v1; unsigned long long :0; short v2; };
struct __attribute__((packed)) aUl_BFu0ll_Uc { unsigned long long v1; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aUl_BFu0ll_Ui { unsigned long long v1; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aUl_BFu0ll_Ul { unsigned long long v1; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aUl_BFu0ll_Us { unsigned long long v1; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aUl_BFu0ll_Vp { unsigned long long v1; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aUl_BFu0s { unsigned long long v1; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu0s_BFu0c { unsigned long long v1; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu0s_BFu0i { unsigned long long v1; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu0s_BFu0ll { unsigned long long v1; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu0s_BFu0s { unsigned long long v1; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu0s_BFu15i { unsigned long long v1; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aUl_BFu0s_BFu15ll { unsigned long long v1; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUl_BFu0s_BFu15s { unsigned long long v1; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aUl_BFu0s_BFu16i { unsigned long long v1; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aUl_BFu0s_BFu16ll { unsigned long long v1; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUl_BFu0s_BFu16s { unsigned long long v1; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aUl_BFu0s_BFu17i { unsigned long long v1; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aUl_BFu0s_BFu17ll { unsigned long long v1; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUl_BFu0s_BFu1c { unsigned long long v1; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aUl_BFu0s_BFu1i { unsigned long long v1; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aUl_BFu0s_BFu1ll { unsigned long long v1; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUl_BFu0s_BFu1s { unsigned long long v1; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aUl_BFu0s_BFu31i { unsigned long long v1; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aUl_BFu0s_BFu31ll { unsigned long long v1; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUl_BFu0s_BFu32i { unsigned long long v1; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aUl_BFu0s_BFu32ll { unsigned long long v1; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUl_BFu0s_BFu33 { unsigned long long v1; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUl_BFu0s_BFu7c { unsigned long long v1; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aUl_BFu0s_BFu7i { unsigned long long v1; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aUl_BFu0s_BFu7ll { unsigned long long v1; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUl_BFu0s_BFu7s { unsigned long long v1; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aUl_BFu0s_BFu8c { unsigned long long v1; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aUl_BFu0s_BFu8i { unsigned long long v1; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aUl_BFu0s_BFu8ll { unsigned long long v1; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUl_BFu0s_BFu8s { unsigned long long v1; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aUl_BFu0s_BFu9i { unsigned long long v1; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aUl_BFu0s_BFu9ll { unsigned long long v1; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUl_BFu0s_BFu9s { unsigned long long v1; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aUl_BFu0s_C { unsigned long long v1; unsigned short :0; char v2; };
struct __attribute__((packed)) aUl_BFu0s_D { unsigned long long v1; unsigned short :0; double v2; };
struct __attribute__((packed)) aUl_BFu0s_F { unsigned long long v1; unsigned short :0; float v2; };
struct __attribute__((packed)) aUl_BFu0s_I { unsigned long long v1; unsigned short :0; int v2; };
struct __attribute__((packed)) aUl_BFu0s_Ip { unsigned long long v1; unsigned short :0; int * v2; };
struct __attribute__((packed)) aUl_BFu0s_L { unsigned long long v1; unsigned short :0; long long v2; };
struct __attribute__((packed)) aUl_BFu0s_S { unsigned long long v1; unsigned short :0; short v2; };
struct __attribute__((packed)) aUl_BFu0s_Uc { unsigned long long v1; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aUl_BFu0s_Ui { unsigned long long v1; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aUl_BFu0s_Ul { unsigned long long v1; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aUl_BFu0s_Us { unsigned long long v1; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aUl_BFu0s_Vp { unsigned long long v1; unsigned short :0; void * v2; };
struct __attribute__((packed)) aUl_BFu15i_BFu0c { unsigned long long v1; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu15i_BFu0i { unsigned long long v1; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu15i_BFu0ll { unsigned long long v1; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu15i_BFu0s { unsigned long long v1; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu15ll_BFu0c { unsigned long long v1; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu15ll_BFu0i { unsigned long long v1; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu15ll_BFu0ll { unsigned long long v1; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu15ll_BFu0s { unsigned long long v1; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu15s_BFu0c { unsigned long long v1; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu15s_BFu0i { unsigned long long v1; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu15s_BFu0ll { unsigned long long v1; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu15s_BFu0s { unsigned long long v1; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu16i_BFu0c { unsigned long long v1; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu16i_BFu0i { unsigned long long v1; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu16i_BFu0ll { unsigned long long v1; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu16i_BFu0s { unsigned long long v1; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu16ll_BFu0c { unsigned long long v1; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu16ll_BFu0i { unsigned long long v1; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu16ll_BFu0ll { unsigned long long v1; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu16ll_BFu0s { unsigned long long v1; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu16s_BFu0c { unsigned long long v1; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu16s_BFu0i { unsigned long long v1; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu16s_BFu0ll { unsigned long long v1; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu16s_BFu0s { unsigned long long v1; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu17i_BFu0c { unsigned long long v1; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu17i_BFu0i { unsigned long long v1; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu17i_BFu0ll { unsigned long long v1; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu17i_BFu0s { unsigned long long v1; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu17ll_BFu0c { unsigned long long v1; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu17ll_BFu0i { unsigned long long v1; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu17ll_BFu0ll { unsigned long long v1; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu17ll_BFu0s { unsigned long long v1; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu1c_BFu0c { unsigned long long v1; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu1c_BFu0i { unsigned long long v1; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu1c_BFu0ll { unsigned long long v1; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu1c_BFu0s { unsigned long long v1; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu1i_BFu0c { unsigned long long v1; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu1i_BFu0i { unsigned long long v1; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu1i_BFu0ll { unsigned long long v1; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu1i_BFu0s { unsigned long long v1; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu1ll_BFu0c { unsigned long long v1; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu1ll_BFu0i { unsigned long long v1; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu1ll_BFu0ll { unsigned long long v1; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu1ll_BFu0s { unsigned long long v1; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu1s_BFu0c { unsigned long long v1; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu1s_BFu0i { unsigned long long v1; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu1s_BFu0ll { unsigned long long v1; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu1s_BFu0s { unsigned long long v1; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu31i_BFu0c { unsigned long long v1; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu31i_BFu0i { unsigned long long v1; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu31i_BFu0ll { unsigned long long v1; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu31i_BFu0s { unsigned long long v1; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu31ll_BFu0c { unsigned long long v1; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu31ll_BFu0i { unsigned long long v1; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu31ll_BFu0ll { unsigned long long v1; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu31ll_BFu0s { unsigned long long v1; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu32i_BFu0c { unsigned long long v1; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu32i_BFu0i { unsigned long long v1; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu32i_BFu0ll { unsigned long long v1; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu32i_BFu0s { unsigned long long v1; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu32ll_BFu0c { unsigned long long v1; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu32ll_BFu0i { unsigned long long v1; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu32ll_BFu0ll { unsigned long long v1; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu32ll_BFu0s { unsigned long long v1; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu33_BFu0c { unsigned long long v1; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu33_BFu0i { unsigned long long v1; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu33_BFu0ll { unsigned long long v1; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu33_BFu0s { unsigned long long v1; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu7c_BFu0c { unsigned long long v1; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu7c_BFu0i { unsigned long long v1; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu7c_BFu0ll { unsigned long long v1; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu7c_BFu0s { unsigned long long v1; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu7i_BFu0c { unsigned long long v1; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu7i_BFu0i { unsigned long long v1; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu7i_BFu0ll { unsigned long long v1; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu7i_BFu0s { unsigned long long v1; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu7ll_BFu0c { unsigned long long v1; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu7ll_BFu0i { unsigned long long v1; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu7ll_BFu0ll { unsigned long long v1; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu7ll_BFu0s { unsigned long long v1; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu7s_BFu0c { unsigned long long v1; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu7s_BFu0i { unsigned long long v1; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu7s_BFu0ll { unsigned long long v1; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu7s_BFu0s { unsigned long long v1; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu8c_BFu0c { unsigned long long v1; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu8c_BFu0i { unsigned long long v1; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu8c_BFu0ll { unsigned long long v1; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu8c_BFu0s { unsigned long long v1; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu8i_BFu0c { unsigned long long v1; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu8i_BFu0i { unsigned long long v1; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu8i_BFu0ll { unsigned long long v1; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu8i_BFu0s { unsigned long long v1; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu8ll_BFu0c { unsigned long long v1; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu8ll_BFu0i { unsigned long long v1; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu8ll_BFu0ll { unsigned long long v1; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu8ll_BFu0s { unsigned long long v1; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu8s_BFu0c { unsigned long long v1; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu8s_BFu0i { unsigned long long v1; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu8s_BFu0ll { unsigned long long v1; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu8s_BFu0s { unsigned long long v1; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu9i_BFu0c { unsigned long long v1; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu9i_BFu0i { unsigned long long v1; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu9i_BFu0ll { unsigned long long v1; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu9i_BFu0s { unsigned long long v1; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu9ll_BFu0c { unsigned long long v1; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu9ll_BFu0i { unsigned long long v1; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu9ll_BFu0ll { unsigned long long v1; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu9ll_BFu0s { unsigned long long v1; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu9s_BFu0c { unsigned long long v1; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aUl_BFu9s_BFu0i { unsigned long long v1; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aUl_BFu9s_BFu0ll { unsigned long long v1; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aUl_BFu9s_BFu0s { unsigned long long v1; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aUl_C_BFu0c { unsigned long long v1; char v2; unsigned char :0; };
struct __attribute__((packed)) aUl_C_BFu0i { unsigned long long v1; char v2; unsigned int :0; };
struct __attribute__((packed)) aUl_C_BFu0ll { unsigned long long v1; char v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_C_BFu0s { unsigned long long v1; char v2; unsigned short :0; };
struct __attribute__((packed)) aUl_D_BFu0c { unsigned long long v1; double v2; unsigned char :0; };
struct __attribute__((packed)) aUl_D_BFu0i { unsigned long long v1; double v2; unsigned int :0; };
struct __attribute__((packed)) aUl_D_BFu0ll { unsigned long long v1; double v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_D_BFu0s { unsigned long long v1; double v2; unsigned short :0; };
struct __attribute__((packed)) aUl_F_BFu0c { unsigned long long v1; float v2; unsigned char :0; };
struct __attribute__((packed)) aUl_F_BFu0i { unsigned long long v1; float v2; unsigned int :0; };
struct __attribute__((packed)) aUl_F_BFu0ll { unsigned long long v1; float v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_F_BFu0s { unsigned long long v1; float v2; unsigned short :0; };
struct __attribute__((packed)) aUl_I_BFu0c { unsigned long long v1; int v2; unsigned char :0; };
struct __attribute__((packed)) aUl_I_BFu0i { unsigned long long v1; int v2; unsigned int :0; };
struct __attribute__((packed)) aUl_I_BFu0ll { unsigned long long v1; int v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_I_BFu0s { unsigned long long v1; int v2; unsigned short :0; };
struct __attribute__((packed)) aUl_Ip_BFu0c { unsigned long long v1; int * v2; unsigned char :0; };
struct __attribute__((packed)) aUl_Ip_BFu0i { unsigned long long v1; int * v2; unsigned int :0; };
struct __attribute__((packed)) aUl_Ip_BFu0ll { unsigned long long v1; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_Ip_BFu0s { unsigned long long v1; int * v2; unsigned short :0; };
struct __attribute__((packed)) aUl_L_BFu0c { unsigned long long v1; long long v2; unsigned char :0; };
struct __attribute__((packed)) aUl_L_BFu0i { unsigned long long v1; long long v2; unsigned int :0; };
struct __attribute__((packed)) aUl_L_BFu0ll { unsigned long long v1; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_L_BFu0s { unsigned long long v1; long long v2; unsigned short :0; };
struct __attribute__((packed)) aUl_S_BFu0c { unsigned long long v1; short v2; unsigned char :0; };
struct __attribute__((packed)) aUl_S_BFu0i { unsigned long long v1; short v2; unsigned int :0; };
struct __attribute__((packed)) aUl_S_BFu0ll { unsigned long long v1; short v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_S_BFu0s { unsigned long long v1; short v2; unsigned short :0; };
struct __attribute__((packed)) aUl_Uc_BFu0c { unsigned long long v1; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aUl_Uc_BFu0i { unsigned long long v1; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aUl_Uc_BFu0ll { unsigned long long v1; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_Uc_BFu0s { unsigned long long v1; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aUl_Ui_BFu0c { unsigned long long v1; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aUl_Ui_BFu0i { unsigned long long v1; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aUl_Ui_BFu0ll { unsigned long long v1; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_Ui_BFu0s { unsigned long long v1; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aUl_Ul_BFu0c { unsigned long long v1; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aUl_Ul_BFu0i { unsigned long long v1; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aUl_Ul_BFu0ll { unsigned long long v1; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_Ul_BFu0s { unsigned long long v1; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aUl_Us_BFu0c { unsigned long long v1; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aUl_Us_BFu0i { unsigned long long v1; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aUl_Us_BFu0ll { unsigned long long v1; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_Us_BFu0s { unsigned long long v1; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aUl_Vp_BFu0c { unsigned long long v1; void * v2; unsigned char :0; };
struct __attribute__((packed)) aUl_Vp_BFu0i { unsigned long long v1; void * v2; unsigned int :0; };
struct __attribute__((packed)) aUl_Vp_BFu0ll { unsigned long long v1; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_Vp_BFu0s { unsigned long long v1; void * v2; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu0c { unsigned short v1; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu0c_BFu0c { unsigned short v1; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu0c_BFu0i { unsigned short v1; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu0c_BFu0ll { unsigned short v1; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu0c_BFu0s { unsigned short v1; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu0c_BFu15i { unsigned short v1; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aUs_BFu0c_BFu15ll { unsigned short v1; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUs_BFu0c_BFu15s { unsigned short v1; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aUs_BFu0c_BFu16i { unsigned short v1; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aUs_BFu0c_BFu16ll { unsigned short v1; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUs_BFu0c_BFu16s { unsigned short v1; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aUs_BFu0c_BFu17i { unsigned short v1; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aUs_BFu0c_BFu17ll { unsigned short v1; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUs_BFu0c_BFu1c { unsigned short v1; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aUs_BFu0c_BFu1i { unsigned short v1; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aUs_BFu0c_BFu1ll { unsigned short v1; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUs_BFu0c_BFu1s { unsigned short v1; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aUs_BFu0c_BFu31i { unsigned short v1; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aUs_BFu0c_BFu31ll { unsigned short v1; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUs_BFu0c_BFu32i { unsigned short v1; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aUs_BFu0c_BFu32ll { unsigned short v1; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUs_BFu0c_BFu33 { unsigned short v1; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUs_BFu0c_BFu7c { unsigned short v1; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aUs_BFu0c_BFu7i { unsigned short v1; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aUs_BFu0c_BFu7ll { unsigned short v1; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUs_BFu0c_BFu7s { unsigned short v1; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aUs_BFu0c_BFu8c { unsigned short v1; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aUs_BFu0c_BFu8i { unsigned short v1; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aUs_BFu0c_BFu8ll { unsigned short v1; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUs_BFu0c_BFu8s { unsigned short v1; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aUs_BFu0c_BFu9i { unsigned short v1; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aUs_BFu0c_BFu9ll { unsigned short v1; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUs_BFu0c_BFu9s { unsigned short v1; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aUs_BFu0c_C { unsigned short v1; unsigned char :0; char v2; };
struct __attribute__((packed)) aUs_BFu0c_D { unsigned short v1; unsigned char :0; double v2; };
struct __attribute__((packed)) aUs_BFu0c_F { unsigned short v1; unsigned char :0; float v2; };
struct __attribute__((packed)) aUs_BFu0c_I { unsigned short v1; unsigned char :0; int v2; };
struct __attribute__((packed)) aUs_BFu0c_Ip { unsigned short v1; unsigned char :0; int * v2; };
struct __attribute__((packed)) aUs_BFu0c_L { unsigned short v1; unsigned char :0; long long v2; };
struct __attribute__((packed)) aUs_BFu0c_S { unsigned short v1; unsigned char :0; short v2; };
struct __attribute__((packed)) aUs_BFu0c_Uc { unsigned short v1; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aUs_BFu0c_Ui { unsigned short v1; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aUs_BFu0c_Ul { unsigned short v1; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aUs_BFu0c_Us { unsigned short v1; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aUs_BFu0c_Vp { unsigned short v1; unsigned char :0; void * v2; };
struct __attribute__((packed)) aUs_BFu0i { unsigned short v1; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu0i_BFu0c { unsigned short v1; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu0i_BFu0i { unsigned short v1; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu0i_BFu0ll { unsigned short v1; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu0i_BFu0s { unsigned short v1; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu0i_BFu15i { unsigned short v1; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aUs_BFu0i_BFu15ll { unsigned short v1; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUs_BFu0i_BFu15s { unsigned short v1; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aUs_BFu0i_BFu16i { unsigned short v1; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aUs_BFu0i_BFu16ll { unsigned short v1; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUs_BFu0i_BFu16s { unsigned short v1; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aUs_BFu0i_BFu17i { unsigned short v1; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aUs_BFu0i_BFu17ll { unsigned short v1; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUs_BFu0i_BFu1c { unsigned short v1; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aUs_BFu0i_BFu1i { unsigned short v1; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aUs_BFu0i_BFu1ll { unsigned short v1; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUs_BFu0i_BFu1s { unsigned short v1; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aUs_BFu0i_BFu31i { unsigned short v1; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aUs_BFu0i_BFu31ll { unsigned short v1; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUs_BFu0i_BFu32i { unsigned short v1; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aUs_BFu0i_BFu32ll { unsigned short v1; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUs_BFu0i_BFu33 { unsigned short v1; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUs_BFu0i_BFu7c { unsigned short v1; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aUs_BFu0i_BFu7i { unsigned short v1; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aUs_BFu0i_BFu7ll { unsigned short v1; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUs_BFu0i_BFu7s { unsigned short v1; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aUs_BFu0i_BFu8c { unsigned short v1; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aUs_BFu0i_BFu8i { unsigned short v1; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aUs_BFu0i_BFu8ll { unsigned short v1; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUs_BFu0i_BFu8s { unsigned short v1; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aUs_BFu0i_BFu9i { unsigned short v1; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aUs_BFu0i_BFu9ll { unsigned short v1; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUs_BFu0i_BFu9s { unsigned short v1; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aUs_BFu0i_C { unsigned short v1; unsigned int :0; char v2; };
struct __attribute__((packed)) aUs_BFu0i_D { unsigned short v1; unsigned int :0; double v2; };
struct __attribute__((packed)) aUs_BFu0i_F { unsigned short v1; unsigned int :0; float v2; };
struct __attribute__((packed)) aUs_BFu0i_I { unsigned short v1; unsigned int :0; int v2; };
struct __attribute__((packed)) aUs_BFu0i_Ip { unsigned short v1; unsigned int :0; int * v2; };
struct __attribute__((packed)) aUs_BFu0i_L { unsigned short v1; unsigned int :0; long long v2; };
struct __attribute__((packed)) aUs_BFu0i_S { unsigned short v1; unsigned int :0; short v2; };
struct __attribute__((packed)) aUs_BFu0i_Uc { unsigned short v1; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aUs_BFu0i_Ui { unsigned short v1; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aUs_BFu0i_Ul { unsigned short v1; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aUs_BFu0i_Us { unsigned short v1; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aUs_BFu0i_Vp { unsigned short v1; unsigned int :0; void * v2; };
struct __attribute__((packed)) aUs_BFu0ll { unsigned short v1; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu0ll_BFu0c { unsigned short v1; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu0ll_BFu0i { unsigned short v1; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu0ll_BFu0ll { unsigned short v1; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu0ll_BFu0s { unsigned short v1; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu0ll_BFu15i { unsigned short v1; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aUs_BFu0ll_BFu15ll { unsigned short v1; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUs_BFu0ll_BFu15s { unsigned short v1; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aUs_BFu0ll_BFu16i { unsigned short v1; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aUs_BFu0ll_BFu16ll { unsigned short v1; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUs_BFu0ll_BFu16s { unsigned short v1; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aUs_BFu0ll_BFu17i { unsigned short v1; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aUs_BFu0ll_BFu17ll { unsigned short v1; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUs_BFu0ll_BFu1c { unsigned short v1; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aUs_BFu0ll_BFu1i { unsigned short v1; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aUs_BFu0ll_BFu1ll { unsigned short v1; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUs_BFu0ll_BFu1s { unsigned short v1; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aUs_BFu0ll_BFu31i { unsigned short v1; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aUs_BFu0ll_BFu31ll { unsigned short v1; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUs_BFu0ll_BFu32i { unsigned short v1; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aUs_BFu0ll_BFu32ll { unsigned short v1; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUs_BFu0ll_BFu33 { unsigned short v1; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUs_BFu0ll_BFu7c { unsigned short v1; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aUs_BFu0ll_BFu7i { unsigned short v1; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aUs_BFu0ll_BFu7ll { unsigned short v1; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUs_BFu0ll_BFu7s { unsigned short v1; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aUs_BFu0ll_BFu8c { unsigned short v1; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aUs_BFu0ll_BFu8i { unsigned short v1; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aUs_BFu0ll_BFu8ll { unsigned short v1; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUs_BFu0ll_BFu8s { unsigned short v1; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aUs_BFu0ll_BFu9i { unsigned short v1; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aUs_BFu0ll_BFu9ll { unsigned short v1; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUs_BFu0ll_BFu9s { unsigned short v1; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aUs_BFu0ll_C { unsigned short v1; unsigned long long :0; char v2; };
struct __attribute__((packed)) aUs_BFu0ll_D { unsigned short v1; unsigned long long :0; double v2; };
struct __attribute__((packed)) aUs_BFu0ll_F { unsigned short v1; unsigned long long :0; float v2; };
struct __attribute__((packed)) aUs_BFu0ll_I { unsigned short v1; unsigned long long :0; int v2; };
struct __attribute__((packed)) aUs_BFu0ll_Ip { unsigned short v1; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aUs_BFu0ll_L { unsigned short v1; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aUs_BFu0ll_S { unsigned short v1; unsigned long long :0; short v2; };
struct __attribute__((packed)) aUs_BFu0ll_Uc { unsigned short v1; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aUs_BFu0ll_Ui { unsigned short v1; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aUs_BFu0ll_Ul { unsigned short v1; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aUs_BFu0ll_Us { unsigned short v1; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aUs_BFu0ll_Vp { unsigned short v1; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aUs_BFu0s { unsigned short v1; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu0s_BFu0c { unsigned short v1; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu0s_BFu0i { unsigned short v1; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu0s_BFu0ll { unsigned short v1; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu0s_BFu0s { unsigned short v1; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu0s_BFu15i { unsigned short v1; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aUs_BFu0s_BFu15ll { unsigned short v1; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aUs_BFu0s_BFu15s { unsigned short v1; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aUs_BFu0s_BFu16i { unsigned short v1; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aUs_BFu0s_BFu16ll { unsigned short v1; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aUs_BFu0s_BFu16s { unsigned short v1; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aUs_BFu0s_BFu17i { unsigned short v1; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aUs_BFu0s_BFu17ll { unsigned short v1; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aUs_BFu0s_BFu1c { unsigned short v1; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aUs_BFu0s_BFu1i { unsigned short v1; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aUs_BFu0s_BFu1ll { unsigned short v1; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aUs_BFu0s_BFu1s { unsigned short v1; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aUs_BFu0s_BFu31i { unsigned short v1; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aUs_BFu0s_BFu31ll { unsigned short v1; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aUs_BFu0s_BFu32i { unsigned short v1; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aUs_BFu0s_BFu32ll { unsigned short v1; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aUs_BFu0s_BFu33 { unsigned short v1; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aUs_BFu0s_BFu7c { unsigned short v1; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aUs_BFu0s_BFu7i { unsigned short v1; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aUs_BFu0s_BFu7ll { unsigned short v1; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aUs_BFu0s_BFu7s { unsigned short v1; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aUs_BFu0s_BFu8c { unsigned short v1; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aUs_BFu0s_BFu8i { unsigned short v1; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aUs_BFu0s_BFu8ll { unsigned short v1; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aUs_BFu0s_BFu8s { unsigned short v1; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aUs_BFu0s_BFu9i { unsigned short v1; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aUs_BFu0s_BFu9ll { unsigned short v1; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aUs_BFu0s_BFu9s { unsigned short v1; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aUs_BFu0s_C { unsigned short v1; unsigned short :0; char v2; };
struct __attribute__((packed)) aUs_BFu0s_D { unsigned short v1; unsigned short :0; double v2; };
struct __attribute__((packed)) aUs_BFu0s_F { unsigned short v1; unsigned short :0; float v2; };
struct __attribute__((packed)) aUs_BFu0s_I { unsigned short v1; unsigned short :0; int v2; };
struct __attribute__((packed)) aUs_BFu0s_Ip { unsigned short v1; unsigned short :0; int * v2; };
struct __attribute__((packed)) aUs_BFu0s_L { unsigned short v1; unsigned short :0; long long v2; };
struct __attribute__((packed)) aUs_BFu0s_S { unsigned short v1; unsigned short :0; short v2; };
struct __attribute__((packed)) aUs_BFu0s_Uc { unsigned short v1; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aUs_BFu0s_Ui { unsigned short v1; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aUs_BFu0s_Ul { unsigned short v1; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aUs_BFu0s_Us { unsigned short v1; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aUs_BFu0s_Vp { unsigned short v1; unsigned short :0; void * v2; };
struct __attribute__((packed)) aUs_BFu15i_BFu0c { unsigned short v1; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu15i_BFu0i { unsigned short v1; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu15i_BFu0ll { unsigned short v1; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu15i_BFu0s { unsigned short v1; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu15ll_BFu0c { unsigned short v1; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu15ll_BFu0i { unsigned short v1; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu15ll_BFu0ll { unsigned short v1; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu15ll_BFu0s { unsigned short v1; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu15s_BFu0c { unsigned short v1; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu15s_BFu0i { unsigned short v1; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu15s_BFu0ll { unsigned short v1; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu15s_BFu0s { unsigned short v1; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu16i_BFu0c { unsigned short v1; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu16i_BFu0i { unsigned short v1; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu16i_BFu0ll { unsigned short v1; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu16i_BFu0s { unsigned short v1; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu16ll_BFu0c { unsigned short v1; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu16ll_BFu0i { unsigned short v1; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu16ll_BFu0ll { unsigned short v1; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu16ll_BFu0s { unsigned short v1; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu16s_BFu0c { unsigned short v1; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu16s_BFu0i { unsigned short v1; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu16s_BFu0ll { unsigned short v1; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu16s_BFu0s { unsigned short v1; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu17i_BFu0c { unsigned short v1; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu17i_BFu0i { unsigned short v1; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu17i_BFu0ll { unsigned short v1; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu17i_BFu0s { unsigned short v1; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu17ll_BFu0c { unsigned short v1; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu17ll_BFu0i { unsigned short v1; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu17ll_BFu0ll { unsigned short v1; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu17ll_BFu0s { unsigned short v1; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu1c_BFu0c { unsigned short v1; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu1c_BFu0i { unsigned short v1; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu1c_BFu0ll { unsigned short v1; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu1c_BFu0s { unsigned short v1; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu1i_BFu0c { unsigned short v1; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu1i_BFu0i { unsigned short v1; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu1i_BFu0ll { unsigned short v1; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu1i_BFu0s { unsigned short v1; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu1ll_BFu0c { unsigned short v1; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu1ll_BFu0i { unsigned short v1; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu1ll_BFu0ll { unsigned short v1; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu1ll_BFu0s { unsigned short v1; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu1s_BFu0c { unsigned short v1; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu1s_BFu0i { unsigned short v1; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu1s_BFu0ll { unsigned short v1; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu1s_BFu0s { unsigned short v1; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu31i_BFu0c { unsigned short v1; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu31i_BFu0i { unsigned short v1; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu31i_BFu0ll { unsigned short v1; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu31i_BFu0s { unsigned short v1; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu31ll_BFu0c { unsigned short v1; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu31ll_BFu0i { unsigned short v1; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu31ll_BFu0ll { unsigned short v1; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu31ll_BFu0s { unsigned short v1; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu32i_BFu0c { unsigned short v1; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu32i_BFu0i { unsigned short v1; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu32i_BFu0ll { unsigned short v1; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu32i_BFu0s { unsigned short v1; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu32ll_BFu0c { unsigned short v1; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu32ll_BFu0i { unsigned short v1; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu32ll_BFu0ll { unsigned short v1; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu32ll_BFu0s { unsigned short v1; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu33_BFu0c { unsigned short v1; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu33_BFu0i { unsigned short v1; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu33_BFu0ll { unsigned short v1; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu33_BFu0s { unsigned short v1; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu7c_BFu0c { unsigned short v1; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu7c_BFu0i { unsigned short v1; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu7c_BFu0ll { unsigned short v1; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu7c_BFu0s { unsigned short v1; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu7i_BFu0c { unsigned short v1; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu7i_BFu0i { unsigned short v1; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu7i_BFu0ll { unsigned short v1; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu7i_BFu0s { unsigned short v1; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu7ll_BFu0c { unsigned short v1; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu7ll_BFu0i { unsigned short v1; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu7ll_BFu0ll { unsigned short v1; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu7ll_BFu0s { unsigned short v1; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu7s_BFu0c { unsigned short v1; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu7s_BFu0i { unsigned short v1; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu7s_BFu0ll { unsigned short v1; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu7s_BFu0s { unsigned short v1; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu8c_BFu0c { unsigned short v1; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu8c_BFu0i { unsigned short v1; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu8c_BFu0ll { unsigned short v1; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu8c_BFu0s { unsigned short v1; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu8i_BFu0c { unsigned short v1; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu8i_BFu0i { unsigned short v1; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu8i_BFu0ll { unsigned short v1; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu8i_BFu0s { unsigned short v1; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu8ll_BFu0c { unsigned short v1; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu8ll_BFu0i { unsigned short v1; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu8ll_BFu0ll { unsigned short v1; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu8ll_BFu0s { unsigned short v1; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu8s_BFu0c { unsigned short v1; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu8s_BFu0i { unsigned short v1; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu8s_BFu0ll { unsigned short v1; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu8s_BFu0s { unsigned short v1; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu9i_BFu0c { unsigned short v1; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu9i_BFu0i { unsigned short v1; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu9i_BFu0ll { unsigned short v1; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu9i_BFu0s { unsigned short v1; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu9ll_BFu0c { unsigned short v1; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu9ll_BFu0i { unsigned short v1; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu9ll_BFu0ll { unsigned short v1; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu9ll_BFu0s { unsigned short v1; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu9s_BFu0c { unsigned short v1; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aUs_BFu9s_BFu0i { unsigned short v1; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aUs_BFu9s_BFu0ll { unsigned short v1; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aUs_BFu9s_BFu0s { unsigned short v1; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aUs_C_BFu0c { unsigned short v1; char v2; unsigned char :0; };
struct __attribute__((packed)) aUs_C_BFu0i { unsigned short v1; char v2; unsigned int :0; };
struct __attribute__((packed)) aUs_C_BFu0ll { unsigned short v1; char v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_C_BFu0s { unsigned short v1; char v2; unsigned short :0; };
struct __attribute__((packed)) aUs_D_BFu0c { unsigned short v1; double v2; unsigned char :0; };
struct __attribute__((packed)) aUs_D_BFu0i { unsigned short v1; double v2; unsigned int :0; };
struct __attribute__((packed)) aUs_D_BFu0ll { unsigned short v1; double v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_D_BFu0s { unsigned short v1; double v2; unsigned short :0; };
struct __attribute__((packed)) aUs_F_BFu0c { unsigned short v1; float v2; unsigned char :0; };
struct __attribute__((packed)) aUs_F_BFu0i { unsigned short v1; float v2; unsigned int :0; };
struct __attribute__((packed)) aUs_F_BFu0ll { unsigned short v1; float v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_F_BFu0s { unsigned short v1; float v2; unsigned short :0; };
struct __attribute__((packed)) aUs_I_BFu0c { unsigned short v1; int v2; unsigned char :0; };
struct __attribute__((packed)) aUs_I_BFu0i { unsigned short v1; int v2; unsigned int :0; };
struct __attribute__((packed)) aUs_I_BFu0ll { unsigned short v1; int v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_I_BFu0s { unsigned short v1; int v2; unsigned short :0; };
struct __attribute__((packed)) aUs_Ip_BFu0c { unsigned short v1; int * v2; unsigned char :0; };
struct __attribute__((packed)) aUs_Ip_BFu0i { unsigned short v1; int * v2; unsigned int :0; };
struct __attribute__((packed)) aUs_Ip_BFu0ll { unsigned short v1; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_Ip_BFu0s { unsigned short v1; int * v2; unsigned short :0; };
struct __attribute__((packed)) aUs_L_BFu0c { unsigned short v1; long long v2; unsigned char :0; };
struct __attribute__((packed)) aUs_L_BFu0i { unsigned short v1; long long v2; unsigned int :0; };
struct __attribute__((packed)) aUs_L_BFu0ll { unsigned short v1; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_L_BFu0s { unsigned short v1; long long v2; unsigned short :0; };
struct __attribute__((packed)) aUs_S_BFu0c { unsigned short v1; short v2; unsigned char :0; };
struct __attribute__((packed)) aUs_S_BFu0i { unsigned short v1; short v2; unsigned int :0; };
struct __attribute__((packed)) aUs_S_BFu0ll { unsigned short v1; short v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_S_BFu0s { unsigned short v1; short v2; unsigned short :0; };
struct __attribute__((packed)) aUs_Uc_BFu0c { unsigned short v1; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aUs_Uc_BFu0i { unsigned short v1; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aUs_Uc_BFu0ll { unsigned short v1; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_Uc_BFu0s { unsigned short v1; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aUs_Ui_BFu0c { unsigned short v1; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aUs_Ui_BFu0i { unsigned short v1; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aUs_Ui_BFu0ll { unsigned short v1; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_Ui_BFu0s { unsigned short v1; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aUs_Ul_BFu0c { unsigned short v1; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aUs_Ul_BFu0i { unsigned short v1; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aUs_Ul_BFu0ll { unsigned short v1; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_Ul_BFu0s { unsigned short v1; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aUs_Us_BFu0c { unsigned short v1; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aUs_Us_BFu0i { unsigned short v1; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aUs_Us_BFu0ll { unsigned short v1; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_Us_BFu0s { unsigned short v1; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aUs_Vp_BFu0c { unsigned short v1; void * v2; unsigned char :0; };
struct __attribute__((packed)) aUs_Vp_BFu0i { unsigned short v1; void * v2; unsigned int :0; };
struct __attribute__((packed)) aUs_Vp_BFu0ll { unsigned short v1; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_Vp_BFu0s { unsigned short v1; void * v2; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu0c { void * v1; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu0c_BFu0c { void * v1; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu0c_BFu0i { void * v1; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu0c_BFu0ll { void * v1; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu0c_BFu0s { void * v1; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu0c_BFu15i { void * v1; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aVp_BFu0c_BFu15ll { void * v1; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aVp_BFu0c_BFu15s { void * v1; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aVp_BFu0c_BFu16i { void * v1; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aVp_BFu0c_BFu16ll { void * v1; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aVp_BFu0c_BFu16s { void * v1; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aVp_BFu0c_BFu17i { void * v1; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aVp_BFu0c_BFu17ll { void * v1; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aVp_BFu0c_BFu1c { void * v1; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aVp_BFu0c_BFu1i { void * v1; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aVp_BFu0c_BFu1ll { void * v1; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aVp_BFu0c_BFu1s { void * v1; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aVp_BFu0c_BFu31i { void * v1; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aVp_BFu0c_BFu31ll { void * v1; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aVp_BFu0c_BFu32i { void * v1; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aVp_BFu0c_BFu32ll { void * v1; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aVp_BFu0c_BFu33 { void * v1; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aVp_BFu0c_BFu7c { void * v1; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aVp_BFu0c_BFu7i { void * v1; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aVp_BFu0c_BFu7ll { void * v1; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aVp_BFu0c_BFu7s { void * v1; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aVp_BFu0c_BFu8c { void * v1; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aVp_BFu0c_BFu8i { void * v1; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aVp_BFu0c_BFu8ll { void * v1; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aVp_BFu0c_BFu8s { void * v1; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aVp_BFu0c_BFu9i { void * v1; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aVp_BFu0c_BFu9ll { void * v1; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aVp_BFu0c_BFu9s { void * v1; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aVp_BFu0c_C { void * v1; unsigned char :0; char v2; };
struct __attribute__((packed)) aVp_BFu0c_D { void * v1; unsigned char :0; double v2; };
struct __attribute__((packed)) aVp_BFu0c_F { void * v1; unsigned char :0; float v2; };
struct __attribute__((packed)) aVp_BFu0c_I { void * v1; unsigned char :0; int v2; };
struct __attribute__((packed)) aVp_BFu0c_Ip { void * v1; unsigned char :0; int * v2; };
struct __attribute__((packed)) aVp_BFu0c_L { void * v1; unsigned char :0; long long v2; };
struct __attribute__((packed)) aVp_BFu0c_S { void * v1; unsigned char :0; short v2; };
struct __attribute__((packed)) aVp_BFu0c_Uc { void * v1; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aVp_BFu0c_Ui { void * v1; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aVp_BFu0c_Ul { void * v1; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aVp_BFu0c_Us { void * v1; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aVp_BFu0c_Vp { void * v1; unsigned char :0; void * v2; };
struct __attribute__((packed)) aVp_BFu0i { void * v1; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu0i_BFu0c { void * v1; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu0i_BFu0i { void * v1; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu0i_BFu0ll { void * v1; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu0i_BFu0s { void * v1; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu0i_BFu15i { void * v1; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aVp_BFu0i_BFu15ll { void * v1; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aVp_BFu0i_BFu15s { void * v1; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aVp_BFu0i_BFu16i { void * v1; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aVp_BFu0i_BFu16ll { void * v1; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aVp_BFu0i_BFu16s { void * v1; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aVp_BFu0i_BFu17i { void * v1; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aVp_BFu0i_BFu17ll { void * v1; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aVp_BFu0i_BFu1c { void * v1; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aVp_BFu0i_BFu1i { void * v1; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aVp_BFu0i_BFu1ll { void * v1; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aVp_BFu0i_BFu1s { void * v1; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aVp_BFu0i_BFu31i { void * v1; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aVp_BFu0i_BFu31ll { void * v1; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aVp_BFu0i_BFu32i { void * v1; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aVp_BFu0i_BFu32ll { void * v1; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aVp_BFu0i_BFu33 { void * v1; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aVp_BFu0i_BFu7c { void * v1; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aVp_BFu0i_BFu7i { void * v1; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aVp_BFu0i_BFu7ll { void * v1; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aVp_BFu0i_BFu7s { void * v1; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aVp_BFu0i_BFu8c { void * v1; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aVp_BFu0i_BFu8i { void * v1; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aVp_BFu0i_BFu8ll { void * v1; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aVp_BFu0i_BFu8s { void * v1; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aVp_BFu0i_BFu9i { void * v1; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aVp_BFu0i_BFu9ll { void * v1; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aVp_BFu0i_BFu9s { void * v1; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aVp_BFu0i_C { void * v1; unsigned int :0; char v2; };
struct __attribute__((packed)) aVp_BFu0i_D { void * v1; unsigned int :0; double v2; };
struct __attribute__((packed)) aVp_BFu0i_F { void * v1; unsigned int :0; float v2; };
struct __attribute__((packed)) aVp_BFu0i_I { void * v1; unsigned int :0; int v2; };
struct __attribute__((packed)) aVp_BFu0i_Ip { void * v1; unsigned int :0; int * v2; };
struct __attribute__((packed)) aVp_BFu0i_L { void * v1; unsigned int :0; long long v2; };
struct __attribute__((packed)) aVp_BFu0i_S { void * v1; unsigned int :0; short v2; };
struct __attribute__((packed)) aVp_BFu0i_Uc { void * v1; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aVp_BFu0i_Ui { void * v1; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aVp_BFu0i_Ul { void * v1; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aVp_BFu0i_Us { void * v1; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aVp_BFu0i_Vp { void * v1; unsigned int :0; void * v2; };
struct __attribute__((packed)) aVp_BFu0ll { void * v1; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu0ll_BFu0c { void * v1; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu0ll_BFu0i { void * v1; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu0ll_BFu0ll { void * v1; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu0ll_BFu0s { void * v1; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu0ll_BFu15i { void * v1; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aVp_BFu0ll_BFu15ll { void * v1; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aVp_BFu0ll_BFu15s { void * v1; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aVp_BFu0ll_BFu16i { void * v1; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aVp_BFu0ll_BFu16ll { void * v1; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aVp_BFu0ll_BFu16s { void * v1; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aVp_BFu0ll_BFu17i { void * v1; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aVp_BFu0ll_BFu17ll { void * v1; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aVp_BFu0ll_BFu1c { void * v1; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aVp_BFu0ll_BFu1i { void * v1; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aVp_BFu0ll_BFu1ll { void * v1; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aVp_BFu0ll_BFu1s { void * v1; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aVp_BFu0ll_BFu31i { void * v1; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aVp_BFu0ll_BFu31ll { void * v1; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aVp_BFu0ll_BFu32i { void * v1; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aVp_BFu0ll_BFu32ll { void * v1; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aVp_BFu0ll_BFu33 { void * v1; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aVp_BFu0ll_BFu7c { void * v1; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aVp_BFu0ll_BFu7i { void * v1; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aVp_BFu0ll_BFu7ll { void * v1; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aVp_BFu0ll_BFu7s { void * v1; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aVp_BFu0ll_BFu8c { void * v1; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aVp_BFu0ll_BFu8i { void * v1; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aVp_BFu0ll_BFu8ll { void * v1; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aVp_BFu0ll_BFu8s { void * v1; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aVp_BFu0ll_BFu9i { void * v1; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aVp_BFu0ll_BFu9ll { void * v1; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aVp_BFu0ll_BFu9s { void * v1; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aVp_BFu0ll_C { void * v1; unsigned long long :0; char v2; };
struct __attribute__((packed)) aVp_BFu0ll_D { void * v1; unsigned long long :0; double v2; };
struct __attribute__((packed)) aVp_BFu0ll_F { void * v1; unsigned long long :0; float v2; };
struct __attribute__((packed)) aVp_BFu0ll_I { void * v1; unsigned long long :0; int v2; };
struct __attribute__((packed)) aVp_BFu0ll_Ip { void * v1; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aVp_BFu0ll_L { void * v1; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aVp_BFu0ll_S { void * v1; unsigned long long :0; short v2; };
struct __attribute__((packed)) aVp_BFu0ll_Uc { void * v1; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aVp_BFu0ll_Ui { void * v1; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aVp_BFu0ll_Ul { void * v1; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aVp_BFu0ll_Us { void * v1; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aVp_BFu0ll_Vp { void * v1; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aVp_BFu0s { void * v1; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu0s_BFu0c { void * v1; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu0s_BFu0i { void * v1; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu0s_BFu0ll { void * v1; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu0s_BFu0s { void * v1; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu0s_BFu15i { void * v1; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aVp_BFu0s_BFu15ll { void * v1; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aVp_BFu0s_BFu15s { void * v1; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aVp_BFu0s_BFu16i { void * v1; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aVp_BFu0s_BFu16ll { void * v1; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aVp_BFu0s_BFu16s { void * v1; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aVp_BFu0s_BFu17i { void * v1; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aVp_BFu0s_BFu17ll { void * v1; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aVp_BFu0s_BFu1c { void * v1; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aVp_BFu0s_BFu1i { void * v1; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aVp_BFu0s_BFu1ll { void * v1; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aVp_BFu0s_BFu1s { void * v1; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aVp_BFu0s_BFu31i { void * v1; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aVp_BFu0s_BFu31ll { void * v1; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aVp_BFu0s_BFu32i { void * v1; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aVp_BFu0s_BFu32ll { void * v1; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aVp_BFu0s_BFu33 { void * v1; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aVp_BFu0s_BFu7c { void * v1; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aVp_BFu0s_BFu7i { void * v1; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aVp_BFu0s_BFu7ll { void * v1; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aVp_BFu0s_BFu7s { void * v1; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aVp_BFu0s_BFu8c { void * v1; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aVp_BFu0s_BFu8i { void * v1; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aVp_BFu0s_BFu8ll { void * v1; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aVp_BFu0s_BFu8s { void * v1; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aVp_BFu0s_BFu9i { void * v1; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aVp_BFu0s_BFu9ll { void * v1; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aVp_BFu0s_BFu9s { void * v1; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aVp_BFu0s_C { void * v1; unsigned short :0; char v2; };
struct __attribute__((packed)) aVp_BFu0s_D { void * v1; unsigned short :0; double v2; };
struct __attribute__((packed)) aVp_BFu0s_F { void * v1; unsigned short :0; float v2; };
struct __attribute__((packed)) aVp_BFu0s_I { void * v1; unsigned short :0; int v2; };
struct __attribute__((packed)) aVp_BFu0s_Ip { void * v1; unsigned short :0; int * v2; };
struct __attribute__((packed)) aVp_BFu0s_L { void * v1; unsigned short :0; long long v2; };
struct __attribute__((packed)) aVp_BFu0s_S { void * v1; unsigned short :0; short v2; };
struct __attribute__((packed)) aVp_BFu0s_Uc { void * v1; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aVp_BFu0s_Ui { void * v1; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aVp_BFu0s_Ul { void * v1; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aVp_BFu0s_Us { void * v1; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aVp_BFu0s_Vp { void * v1; unsigned short :0; void * v2; };
struct __attribute__((packed)) aVp_BFu15i_BFu0c { void * v1; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu15i_BFu0i { void * v1; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu15i_BFu0ll { void * v1; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu15i_BFu0s { void * v1; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu15ll_BFu0c { void * v1; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu15ll_BFu0i { void * v1; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu15ll_BFu0ll { void * v1; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu15ll_BFu0s { void * v1; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu15s_BFu0c { void * v1; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu15s_BFu0i { void * v1; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu15s_BFu0ll { void * v1; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu15s_BFu0s { void * v1; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu16i_BFu0c { void * v1; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu16i_BFu0i { void * v1; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu16i_BFu0ll { void * v1; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu16i_BFu0s { void * v1; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu16ll_BFu0c { void * v1; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu16ll_BFu0i { void * v1; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu16ll_BFu0ll { void * v1; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu16ll_BFu0s { void * v1; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu16s_BFu0c { void * v1; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu16s_BFu0i { void * v1; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu16s_BFu0ll { void * v1; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu16s_BFu0s { void * v1; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu17i_BFu0c { void * v1; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu17i_BFu0i { void * v1; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu17i_BFu0ll { void * v1; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu17i_BFu0s { void * v1; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu17ll_BFu0c { void * v1; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu17ll_BFu0i { void * v1; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu17ll_BFu0ll { void * v1; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu17ll_BFu0s { void * v1; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu1c_BFu0c { void * v1; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu1c_BFu0i { void * v1; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu1c_BFu0ll { void * v1; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu1c_BFu0s { void * v1; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu1i_BFu0c { void * v1; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu1i_BFu0i { void * v1; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu1i_BFu0ll { void * v1; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu1i_BFu0s { void * v1; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu1ll_BFu0c { void * v1; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu1ll_BFu0i { void * v1; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu1ll_BFu0ll { void * v1; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu1ll_BFu0s { void * v1; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu1s_BFu0c { void * v1; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu1s_BFu0i { void * v1; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu1s_BFu0ll { void * v1; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu1s_BFu0s { void * v1; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu31i_BFu0c { void * v1; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu31i_BFu0i { void * v1; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu31i_BFu0ll { void * v1; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu31i_BFu0s { void * v1; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu31ll_BFu0c { void * v1; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu31ll_BFu0i { void * v1; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu31ll_BFu0ll { void * v1; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu31ll_BFu0s { void * v1; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu32i_BFu0c { void * v1; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu32i_BFu0i { void * v1; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu32i_BFu0ll { void * v1; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu32i_BFu0s { void * v1; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu32ll_BFu0c { void * v1; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu32ll_BFu0i { void * v1; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu32ll_BFu0ll { void * v1; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu32ll_BFu0s { void * v1; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu33_BFu0c { void * v1; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu33_BFu0i { void * v1; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu33_BFu0ll { void * v1; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu33_BFu0s { void * v1; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu7c_BFu0c { void * v1; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu7c_BFu0i { void * v1; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu7c_BFu0ll { void * v1; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu7c_BFu0s { void * v1; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu7i_BFu0c { void * v1; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu7i_BFu0i { void * v1; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu7i_BFu0ll { void * v1; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu7i_BFu0s { void * v1; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu7ll_BFu0c { void * v1; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu7ll_BFu0i { void * v1; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu7ll_BFu0ll { void * v1; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu7ll_BFu0s { void * v1; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu7s_BFu0c { void * v1; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu7s_BFu0i { void * v1; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu7s_BFu0ll { void * v1; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu7s_BFu0s { void * v1; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu8c_BFu0c { void * v1; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu8c_BFu0i { void * v1; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu8c_BFu0ll { void * v1; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu8c_BFu0s { void * v1; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu8i_BFu0c { void * v1; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu8i_BFu0i { void * v1; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu8i_BFu0ll { void * v1; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu8i_BFu0s { void * v1; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu8ll_BFu0c { void * v1; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu8ll_BFu0i { void * v1; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu8ll_BFu0ll { void * v1; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu8ll_BFu0s { void * v1; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu8s_BFu0c { void * v1; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu8s_BFu0i { void * v1; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu8s_BFu0ll { void * v1; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu8s_BFu0s { void * v1; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu9i_BFu0c { void * v1; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu9i_BFu0i { void * v1; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu9i_BFu0ll { void * v1; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu9i_BFu0s { void * v1; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu9ll_BFu0c { void * v1; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu9ll_BFu0i { void * v1; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu9ll_BFu0ll { void * v1; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu9ll_BFu0s { void * v1; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu9s_BFu0c { void * v1; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aVp_BFu9s_BFu0i { void * v1; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aVp_BFu9s_BFu0ll { void * v1; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aVp_BFu9s_BFu0s { void * v1; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aVp_C_BFu0c { void * v1; char v2; unsigned char :0; };
struct __attribute__((packed)) aVp_C_BFu0i { void * v1; char v2; unsigned int :0; };
struct __attribute__((packed)) aVp_C_BFu0ll { void * v1; char v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_C_BFu0s { void * v1; char v2; unsigned short :0; };
struct __attribute__((packed)) aVp_D_BFu0c { void * v1; double v2; unsigned char :0; };
struct __attribute__((packed)) aVp_D_BFu0i { void * v1; double v2; unsigned int :0; };
struct __attribute__((packed)) aVp_D_BFu0ll { void * v1; double v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_D_BFu0s { void * v1; double v2; unsigned short :0; };
struct __attribute__((packed)) aVp_F_BFu0c { void * v1; float v2; unsigned char :0; };
struct __attribute__((packed)) aVp_F_BFu0i { void * v1; float v2; unsigned int :0; };
struct __attribute__((packed)) aVp_F_BFu0ll { void * v1; float v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_F_BFu0s { void * v1; float v2; unsigned short :0; };
struct __attribute__((packed)) aVp_I_BFu0c { void * v1; int v2; unsigned char :0; };
struct __attribute__((packed)) aVp_I_BFu0i { void * v1; int v2; unsigned int :0; };
struct __attribute__((packed)) aVp_I_BFu0ll { void * v1; int v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_I_BFu0s { void * v1; int v2; unsigned short :0; };
struct __attribute__((packed)) aVp_Ip_BFu0c { void * v1; int * v2; unsigned char :0; };
struct __attribute__((packed)) aVp_Ip_BFu0i { void * v1; int * v2; unsigned int :0; };
struct __attribute__((packed)) aVp_Ip_BFu0ll { void * v1; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_Ip_BFu0s { void * v1; int * v2; unsigned short :0; };
struct __attribute__((packed)) aVp_L_BFu0c { void * v1; long long v2; unsigned char :0; };
struct __attribute__((packed)) aVp_L_BFu0i { void * v1; long long v2; unsigned int :0; };
struct __attribute__((packed)) aVp_L_BFu0ll { void * v1; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_L_BFu0s { void * v1; long long v2; unsigned short :0; };
struct __attribute__((packed)) aVp_S_BFu0c { void * v1; short v2; unsigned char :0; };
struct __attribute__((packed)) aVp_S_BFu0i { void * v1; short v2; unsigned int :0; };
struct __attribute__((packed)) aVp_S_BFu0ll { void * v1; short v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_S_BFu0s { void * v1; short v2; unsigned short :0; };
struct __attribute__((packed)) aVp_Uc_BFu0c { void * v1; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aVp_Uc_BFu0i { void * v1; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aVp_Uc_BFu0ll { void * v1; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_Uc_BFu0s { void * v1; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aVp_Ui_BFu0c { void * v1; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aVp_Ui_BFu0i { void * v1; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aVp_Ui_BFu0ll { void * v1; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_Ui_BFu0s { void * v1; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aVp_Ul_BFu0c { void * v1; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aVp_Ul_BFu0i { void * v1; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aVp_Ul_BFu0ll { void * v1; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_Ul_BFu0s { void * v1; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aVp_Us_BFu0c { void * v1; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aVp_Us_BFu0i { void * v1; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aVp_Us_BFu0ll { void * v1; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_Us_BFu0s { void * v1; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aVp_Vp_BFu0c { void * v1; void * v2; unsigned char :0; };
struct __attribute__((packed)) aVp_Vp_BFu0i { void * v1; void * v2; unsigned int :0; };
struct __attribute__((packed)) aVp_Vp_BFu0ll { void * v1; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_Vp_BFu0s { void * v1; void * v2; unsigned short :0; };
#pragma pack(1)
struct BFs0c_BFs0c { signed char :0; signed char :0; };
struct BFs0c_BFs0c_BFs0c { signed char :0; signed char :0; signed char :0; };
struct BFs0c_BFs0c_BFs0c_BFs0c { signed char :0; signed char :0; signed char :0; signed char :0; };
struct BFs0c_BFs0c_BFs0c_BFs0i { signed char :0; signed char :0; signed char :0; signed int :0; };
struct BFs0c_BFs0c_BFs0c_BFs0ll { signed char :0; signed char :0; signed char :0; signed long long :0; };
struct BFs0c_BFs0c_BFs0c_BFs0s { signed char :0; signed char :0; signed char :0; signed short :0; };
struct BFs0c_BFs0c_BFs0c_BFu0c { signed char :0; signed char :0; signed char :0; unsigned char :0; };
struct BFs0c_BFs0c_BFs0c_BFu0i { signed char :0; signed char :0; signed char :0; unsigned int :0; };
struct BFs0c_BFs0c_BFs0c_BFu0ll { signed char :0; signed char :0; signed char :0; unsigned long long :0; };
struct BFs0c_BFs0c_BFs0c_BFu0s { signed char :0; signed char :0; signed char :0; unsigned short :0; };
struct BFs0c_BFs0c_BFs0i { signed char :0; signed char :0; signed int :0; };
struct BFs0c_BFs0c_BFs0i_BFs0c { signed char :0; signed char :0; signed int :0; signed char :0; };
struct BFs0c_BFs0c_BFs0i_BFs0i { signed char :0; signed char :0; signed int :0; signed int :0; };
struct BFs0c_BFs0c_BFs0i_BFs0ll { signed char :0; signed char :0; signed int :0; signed long long :0; };
struct BFs0c_BFs0c_BFs0i_BFs0s { signed char :0; signed char :0; signed int :0; signed short :0; };
struct BFs0c_BFs0c_BFs0i_BFu0c { signed char :0; signed char :0; signed int :0; unsigned char :0; };
struct BFs0c_BFs0c_BFs0i_BFu0i { signed char :0; signed char :0; signed int :0; unsigned int :0; };
struct BFs0c_BFs0c_BFs0i_BFu0ll { signed char :0; signed char :0; signed int :0; unsigned long long :0; };
struct BFs0c_BFs0c_BFs0i_BFu0s { signed char :0; signed char :0; signed int :0; unsigned short :0; };
struct BFs0c_BFs0c_BFs0ll { signed char :0; signed char :0; signed long long :0; };
struct BFs0c_BFs0c_BFs0ll_BFs0c { signed char :0; signed char :0; signed long long :0; signed char :0; };
struct BFs0c_BFs0c_BFs0ll_BFs0i { signed char :0; signed char :0; signed long long :0; signed int :0; };
struct BFs0c_BFs0c_BFs0ll_BFs0ll { signed char :0; signed char :0; signed long long :0; signed long long :0; };
struct BFs0c_BFs0c_BFs0ll_BFs0s { signed char :0; signed char :0; signed long long :0; signed short :0; };
struct BFs0c_BFs0c_BFs0ll_BFu0c { signed char :0; signed char :0; signed long long :0; unsigned char :0; };
struct BFs0c_BFs0c_BFs0ll_BFu0i { signed char :0; signed char :0; signed long long :0; unsigned int :0; };
struct BFs0c_BFs0c_BFs0ll_BFu0ll { signed char :0; signed char :0; signed long long :0; unsigned long long :0; };
struct BFs0c_BFs0c_BFs0ll_BFu0s { signed char :0; signed char :0; signed long long :0; unsigned short :0; };
struct BFs0c_BFs0c_BFs0s { signed char :0; signed char :0; signed short :0; };
struct BFs0c_BFs0c_BFs0s_BFs0c { signed char :0; signed char :0; signed short :0; signed char :0; };
struct BFs0c_BFs0c_BFs0s_BFs0i { signed char :0; signed char :0; signed short :0; signed int :0; };
struct BFs0c_BFs0c_BFs0s_BFs0ll { signed char :0; signed char :0; signed short :0; signed long long :0; };
struct BFs0c_BFs0c_BFs0s_BFs0s { signed char :0; signed char :0; signed short :0; signed short :0; };
struct BFs0c_BFs0c_BFs0s_BFu0c { signed char :0; signed char :0; signed short :0; unsigned char :0; };
struct BFs0c_BFs0c_BFs0s_BFu0i { signed char :0; signed char :0; signed short :0; unsigned int :0; };
struct BFs0c_BFs0c_BFs0s_BFu0ll { signed char :0; signed char :0; signed short :0; unsigned long long :0; };
struct BFs0c_BFs0c_BFs0s_BFu0s { signed char :0; signed char :0; signed short :0; unsigned short :0; };
struct BFs0c_BFs0c_BFu0c { signed char :0; signed char :0; unsigned char :0; };
struct BFs0c_BFs0c_BFu0c_BFs0c { signed char :0; signed char :0; unsigned char :0; signed char :0; };
struct BFs0c_BFs0c_BFu0c_BFs0i { signed char :0; signed char :0; unsigned char :0; signed int :0; };
struct BFs0c_BFs0c_BFu0c_BFs0ll { signed char :0; signed char :0; unsigned char :0; signed long long :0; };
struct BFs0c_BFs0c_BFu0c_BFs0s { signed char :0; signed char :0; unsigned char :0; signed short :0; };
struct BFs0c_BFs0c_BFu0c_BFu0c { signed char :0; signed char :0; unsigned char :0; unsigned char :0; };
struct BFs0c_BFs0c_BFu0c_BFu0i { signed char :0; signed char :0; unsigned char :0; unsigned int :0; };
struct BFs0c_BFs0c_BFu0c_BFu0ll { signed char :0; signed char :0; unsigned char :0; unsigned long long :0; };
struct BFs0c_BFs0c_BFu0c_BFu0s { signed char :0; signed char :0; unsigned char :0; unsigned short :0; };
struct BFs0c_BFs0c_BFu0i { signed char :0; signed char :0; unsigned int :0; };
struct BFs0c_BFs0c_BFu0i_BFs0c { signed char :0; signed char :0; unsigned int :0; signed char :0; };
struct BFs0c_BFs0c_BFu0i_BFs0i { signed char :0; signed char :0; unsigned int :0; signed int :0; };
struct BFs0c_BFs0c_BFu0i_BFs0ll { signed char :0; signed char :0; unsigned int :0; signed long long :0; };
struct BFs0c_BFs0c_BFu0i_BFs0s { signed char :0; signed char :0; unsigned int :0; signed short :0; };
struct BFs0c_BFs0c_BFu0i_BFu0c { signed char :0; signed char :0; unsigned int :0; unsigned char :0; };
struct BFs0c_BFs0c_BFu0i_BFu0i { signed char :0; signed char :0; unsigned int :0; unsigned int :0; };
struct BFs0c_BFs0c_BFu0i_BFu0ll { signed char :0; signed char :0; unsigned int :0; unsigned long long :0; };
struct BFs0c_BFs0c_BFu0i_BFu0s { signed char :0; signed char :0; unsigned int :0; unsigned short :0; };
struct BFs0c_BFs0c_BFu0ll { signed char :0; signed char :0; unsigned long long :0; };
struct BFs0c_BFs0c_BFu0ll_BFs0c { signed char :0; signed char :0; unsigned long long :0; signed char :0; };
struct BFs0c_BFs0c_BFu0ll_BFs0i { signed char :0; signed char :0; unsigned long long :0; signed int :0; };
struct BFs0c_BFs0c_BFu0ll_BFs0ll { signed char :0; signed char :0; unsigned long long :0; signed long long :0; };
struct BFs0c_BFs0c_BFu0ll_BFs0s { signed char :0; signed char :0; unsigned long long :0; signed short :0; };
struct BFs0c_BFs0c_BFu0ll_BFu0c { signed char :0; signed char :0; unsigned long long :0; unsigned char :0; };
struct BFs0c_BFs0c_BFu0ll_BFu0i { signed char :0; signed char :0; unsigned long long :0; unsigned int :0; };
struct BFs0c_BFs0c_BFu0ll_BFu0ll { signed char :0; signed char :0; unsigned long long :0; unsigned long long :0; };
struct BFs0c_BFs0c_BFu0ll_BFu0s { signed char :0; signed char :0; unsigned long long :0; unsigned short :0; };
struct BFs0c_BFs0c_BFu0s { signed char :0; signed char :0; unsigned short :0; };
struct BFs0c_BFs0c_BFu0s_BFs0c { signed char :0; signed char :0; unsigned short :0; signed char :0; };
struct BFs0c_BFs0c_BFu0s_BFs0i { signed char :0; signed char :0; unsigned short :0; signed int :0; };
struct BFs0c_BFs0c_BFu0s_BFs0ll { signed char :0; signed char :0; unsigned short :0; signed long long :0; };
struct BFs0c_BFs0c_BFu0s_BFs0s { signed char :0; signed char :0; unsigned short :0; signed short :0; };
struct BFs0c_BFs0c_BFu0s_BFu0c { signed char :0; signed char :0; unsigned short :0; unsigned char :0; };
struct BFs0c_BFs0c_BFu0s_BFu0i { signed char :0; signed char :0; unsigned short :0; unsigned int :0; };
struct BFs0c_BFs0c_BFu0s_BFu0ll { signed char :0; signed char :0; unsigned short :0; unsigned long long :0; };
struct BFs0c_BFs0c_BFu0s_BFu0s { signed char :0; signed char :0; unsigned short :0; unsigned short :0; };
struct BFs0c_BFs0i { signed char :0; signed int :0; };
struct BFs0c_BFs0i_BFs0c { signed char :0; signed int :0; signed char :0; };
struct BFs0c_BFs0i_BFs0c_BFs0c { signed char :0; signed int :0; signed char :0; signed char :0; };
struct BFs0c_BFs0i_BFs0c_BFs0i { signed char :0; signed int :0; signed char :0; signed int :0; };
struct BFs0c_BFs0i_BFs0c_BFs0ll { signed char :0; signed int :0; signed char :0; signed long long :0; };
struct BFs0c_BFs0i_BFs0c_BFs0s { signed char :0; signed int :0; signed char :0; signed short :0; };
struct BFs0c_BFs0i_BFs0c_BFu0c { signed char :0; signed int :0; signed char :0; unsigned char :0; };
struct BFs0c_BFs0i_BFs0c_BFu0i { signed char :0; signed int :0; signed char :0; unsigned int :0; };
struct BFs0c_BFs0i_BFs0c_BFu0ll { signed char :0; signed int :0; signed char :0; unsigned long long :0; };
struct BFs0c_BFs0i_BFs0c_BFu0s { signed char :0; signed int :0; signed char :0; unsigned short :0; };
struct BFs0c_BFs0i_BFs0i { signed char :0; signed int :0; signed int :0; };
struct BFs0c_BFs0i_BFs0i_BFs0c { signed char :0; signed int :0; signed int :0; signed char :0; };
struct BFs0c_BFs0i_BFs0i_BFs0i { signed char :0; signed int :0; signed int :0; signed int :0; };
struct BFs0c_BFs0i_BFs0i_BFs0ll { signed char :0; signed int :0; signed int :0; signed long long :0; };
struct BFs0c_BFs0i_BFs0i_BFs0s { signed char :0; signed int :0; signed int :0; signed short :0; };
struct BFs0c_BFs0i_BFs0i_BFu0c { signed char :0; signed int :0; signed int :0; unsigned char :0; };
struct BFs0c_BFs0i_BFs0i_BFu0i { signed char :0; signed int :0; signed int :0; unsigned int :0; };
struct BFs0c_BFs0i_BFs0i_BFu0ll { signed char :0; signed int :0; signed int :0; unsigned long long :0; };
struct BFs0c_BFs0i_BFs0i_BFu0s { signed char :0; signed int :0; signed int :0; unsigned short :0; };
struct BFs0c_BFs0i_BFs0ll { signed char :0; signed int :0; signed long long :0; };
struct BFs0c_BFs0i_BFs0ll_BFs0c { signed char :0; signed int :0; signed long long :0; signed char :0; };
struct BFs0c_BFs0i_BFs0ll_BFs0i { signed char :0; signed int :0; signed long long :0; signed int :0; };
struct BFs0c_BFs0i_BFs0ll_BFs0ll { signed char :0; signed int :0; signed long long :0; signed long long :0; };
struct BFs0c_BFs0i_BFs0ll_BFs0s { signed char :0; signed int :0; signed long long :0; signed short :0; };
struct BFs0c_BFs0i_BFs0ll_BFu0c { signed char :0; signed int :0; signed long long :0; unsigned char :0; };
struct BFs0c_BFs0i_BFs0ll_BFu0i { signed char :0; signed int :0; signed long long :0; unsigned int :0; };
struct BFs0c_BFs0i_BFs0ll_BFu0ll { signed char :0; signed int :0; signed long long :0; unsigned long long :0; };
struct BFs0c_BFs0i_BFs0ll_BFu0s { signed char :0; signed int :0; signed long long :0; unsigned short :0; };
struct BFs0c_BFs0i_BFs0s { signed char :0; signed int :0; signed short :0; };
struct BFs0c_BFs0i_BFs0s_BFs0c { signed char :0; signed int :0; signed short :0; signed char :0; };
struct BFs0c_BFs0i_BFs0s_BFs0i { signed char :0; signed int :0; signed short :0; signed int :0; };
struct BFs0c_BFs0i_BFs0s_BFs0ll { signed char :0; signed int :0; signed short :0; signed long long :0; };
struct BFs0c_BFs0i_BFs0s_BFs0s { signed char :0; signed int :0; signed short :0; signed short :0; };
struct BFs0c_BFs0i_BFs0s_BFu0c { signed char :0; signed int :0; signed short :0; unsigned char :0; };
struct BFs0c_BFs0i_BFs0s_BFu0i { signed char :0; signed int :0; signed short :0; unsigned int :0; };
struct BFs0c_BFs0i_BFs0s_BFu0ll { signed char :0; signed int :0; signed short :0; unsigned long long :0; };
struct BFs0c_BFs0i_BFs0s_BFu0s { signed char :0; signed int :0; signed short :0; unsigned short :0; };
struct BFs0c_BFs0i_BFu0c { signed char :0; signed int :0; unsigned char :0; };
struct BFs0c_BFs0i_BFu0c_BFs0c { signed char :0; signed int :0; unsigned char :0; signed char :0; };
struct BFs0c_BFs0i_BFu0c_BFs0i { signed char :0; signed int :0; unsigned char :0; signed int :0; };
struct BFs0c_BFs0i_BFu0c_BFs0ll { signed char :0; signed int :0; unsigned char :0; signed long long :0; };
struct BFs0c_BFs0i_BFu0c_BFs0s { signed char :0; signed int :0; unsigned char :0; signed short :0; };
struct BFs0c_BFs0i_BFu0c_BFu0c { signed char :0; signed int :0; unsigned char :0; unsigned char :0; };
struct BFs0c_BFs0i_BFu0c_BFu0i { signed char :0; signed int :0; unsigned char :0; unsigned int :0; };
struct BFs0c_BFs0i_BFu0c_BFu0ll { signed char :0; signed int :0; unsigned char :0; unsigned long long :0; };
struct BFs0c_BFs0i_BFu0c_BFu0s { signed char :0; signed int :0; unsigned char :0; unsigned short :0; };
struct BFs0c_BFs0i_BFu0i { signed char :0; signed int :0; unsigned int :0; };
struct BFs0c_BFs0i_BFu0i_BFs0c { signed char :0; signed int :0; unsigned int :0; signed char :0; };
struct BFs0c_BFs0i_BFu0i_BFs0i { signed char :0; signed int :0; unsigned int :0; signed int :0; };
struct BFs0c_BFs0i_BFu0i_BFs0ll { signed char :0; signed int :0; unsigned int :0; signed long long :0; };
struct BFs0c_BFs0i_BFu0i_BFs0s { signed char :0; signed int :0; unsigned int :0; signed short :0; };
struct BFs0c_BFs0i_BFu0i_BFu0c { signed char :0; signed int :0; unsigned int :0; unsigned char :0; };
struct BFs0c_BFs0i_BFu0i_BFu0i { signed char :0; signed int :0; unsigned int :0; unsigned int :0; };
struct BFs0c_BFs0i_BFu0i_BFu0ll { signed char :0; signed int :0; unsigned int :0; unsigned long long :0; };
struct BFs0c_BFs0i_BFu0i_BFu0s { signed char :0; signed int :0; unsigned int :0; unsigned short :0; };
struct BFs0c_BFs0i_BFu0ll { signed char :0; signed int :0; unsigned long long :0; };
struct BFs0c_BFs0i_BFu0ll_BFs0c { signed char :0; signed int :0; unsigned long long :0; signed char :0; };
struct BFs0c_BFs0i_BFu0ll_BFs0i { signed char :0; signed int :0; unsigned long long :0; signed int :0; };
struct BFs0c_BFs0i_BFu0ll_BFs0ll { signed char :0; signed int :0; unsigned long long :0; signed long long :0; };
struct BFs0c_BFs0i_BFu0ll_BFs0s { signed char :0; signed int :0; unsigned long long :0; signed short :0; };
struct BFs0c_BFs0i_BFu0ll_BFu0c { signed char :0; signed int :0; unsigned long long :0; unsigned char :0; };
struct BFs0c_BFs0i_BFu0ll_BFu0i { signed char :0; signed int :0; unsigned long long :0; unsigned int :0; };
struct BFs0c_BFs0i_BFu0ll_BFu0ll { signed char :0; signed int :0; unsigned long long :0; unsigned long long :0; };
struct BFs0c_BFs0i_BFu0ll_BFu0s { signed char :0; signed int :0; unsigned long long :0; unsigned short :0; };
struct BFs0c_BFs0i_BFu0s { signed char :0; signed int :0; unsigned short :0; };
struct BFs0c_BFs0i_BFu0s_BFs0c { signed char :0; signed int :0; unsigned short :0; signed char :0; };
struct BFs0c_BFs0i_BFu0s_BFs0i { signed char :0; signed int :0; unsigned short :0; signed int :0; };
struct BFs0c_BFs0i_BFu0s_BFs0ll { signed char :0; signed int :0; unsigned short :0; signed long long :0; };
struct BFs0c_BFs0i_BFu0s_BFs0s { signed char :0; signed int :0; unsigned short :0; signed short :0; };
struct BFs0c_BFs0i_BFu0s_BFu0c { signed char :0; signed int :0; unsigned short :0; unsigned char :0; };
struct BFs0c_BFs0i_BFu0s_BFu0i { signed char :0; signed int :0; unsigned short :0; unsigned int :0; };
struct BFs0c_BFs0i_BFu0s_BFu0ll { signed char :0; signed int :0; unsigned short :0; unsigned long long :0; };
struct BFs0c_BFs0i_BFu0s_BFu0s { signed char :0; signed int :0; unsigned short :0; unsigned short :0; };
struct BFs0c_BFs0ll { signed char :0; signed long long :0; };
struct BFs0c_BFs0ll_BFs0c { signed char :0; signed long long :0; signed char :0; };
struct BFs0c_BFs0ll_BFs0c_BFs0c { signed char :0; signed long long :0; signed char :0; signed char :0; };
struct BFs0c_BFs0ll_BFs0c_BFs0i { signed char :0; signed long long :0; signed char :0; signed int :0; };
struct BFs0c_BFs0ll_BFs0c_BFs0ll { signed char :0; signed long long :0; signed char :0; signed long long :0; };
struct BFs0c_BFs0ll_BFs0c_BFs0s { signed char :0; signed long long :0; signed char :0; signed short :0; };
struct BFs0c_BFs0ll_BFs0c_BFu0c { signed char :0; signed long long :0; signed char :0; unsigned char :0; };
struct BFs0c_BFs0ll_BFs0c_BFu0i { signed char :0; signed long long :0; signed char :0; unsigned int :0; };
struct BFs0c_BFs0ll_BFs0c_BFu0ll { signed char :0; signed long long :0; signed char :0; unsigned long long :0; };
struct BFs0c_BFs0ll_BFs0c_BFu0s { signed char :0; signed long long :0; signed char :0; unsigned short :0; };
struct BFs0c_BFs0ll_BFs0i { signed char :0; signed long long :0; signed int :0; };
struct BFs0c_BFs0ll_BFs0i_BFs0c { signed char :0; signed long long :0; signed int :0; signed char :0; };
struct BFs0c_BFs0ll_BFs0i_BFs0i { signed char :0; signed long long :0; signed int :0; signed int :0; };
struct BFs0c_BFs0ll_BFs0i_BFs0ll { signed char :0; signed long long :0; signed int :0; signed long long :0; };
struct BFs0c_BFs0ll_BFs0i_BFs0s { signed char :0; signed long long :0; signed int :0; signed short :0; };
struct BFs0c_BFs0ll_BFs0i_BFu0c { signed char :0; signed long long :0; signed int :0; unsigned char :0; };
struct BFs0c_BFs0ll_BFs0i_BFu0i { signed char :0; signed long long :0; signed int :0; unsigned int :0; };
struct BFs0c_BFs0ll_BFs0i_BFu0ll { signed char :0; signed long long :0; signed int :0; unsigned long long :0; };
struct BFs0c_BFs0ll_BFs0i_BFu0s { signed char :0; signed long long :0; signed int :0; unsigned short :0; };
struct BFs0c_BFs0ll_BFs0ll { signed char :0; signed long long :0; signed long long :0; };
struct BFs0c_BFs0ll_BFs0ll_BFs0c { signed char :0; signed long long :0; signed long long :0; signed char :0; };
struct BFs0c_BFs0ll_BFs0ll_BFs0i { signed char :0; signed long long :0; signed long long :0; signed int :0; };
struct BFs0c_BFs0ll_BFs0ll_BFs0ll { signed char :0; signed long long :0; signed long long :0; signed long long :0; };
struct BFs0c_BFs0ll_BFs0ll_BFs0s { signed char :0; signed long long :0; signed long long :0; signed short :0; };
struct BFs0c_BFs0ll_BFs0ll_BFu0c { signed char :0; signed long long :0; signed long long :0; unsigned char :0; };
struct BFs0c_BFs0ll_BFs0ll_BFu0i { signed char :0; signed long long :0; signed long long :0; unsigned int :0; };
struct BFs0c_BFs0ll_BFs0ll_BFu0ll { signed char :0; signed long long :0; signed long long :0; unsigned long long :0; };
struct BFs0c_BFs0ll_BFs0ll_BFu0s { signed char :0; signed long long :0; signed long long :0; unsigned short :0; };
struct BFs0c_BFs0ll_BFs0s { signed char :0; signed long long :0; signed short :0; };
struct BFs0c_BFs0ll_BFs0s_BFs0c { signed char :0; signed long long :0; signed short :0; signed char :0; };
struct BFs0c_BFs0ll_BFs0s_BFs0i { signed char :0; signed long long :0; signed short :0; signed int :0; };
struct BFs0c_BFs0ll_BFs0s_BFs0ll { signed char :0; signed long long :0; signed short :0; signed long long :0; };
struct BFs0c_BFs0ll_BFs0s_BFs0s { signed char :0; signed long long :0; signed short :0; signed short :0; };
struct BFs0c_BFs0ll_BFs0s_BFu0c { signed char :0; signed long long :0; signed short :0; unsigned char :0; };
struct BFs0c_BFs0ll_BFs0s_BFu0i { signed char :0; signed long long :0; signed short :0; unsigned int :0; };
struct BFs0c_BFs0ll_BFs0s_BFu0ll { signed char :0; signed long long :0; signed short :0; unsigned long long :0; };
struct BFs0c_BFs0ll_BFs0s_BFu0s { signed char :0; signed long long :0; signed short :0; unsigned short :0; };
struct BFs0c_BFs0ll_BFu0c { signed char :0; signed long long :0; unsigned char :0; };
struct BFs0c_BFs0ll_BFu0c_BFs0c { signed char :0; signed long long :0; unsigned char :0; signed char :0; };
struct BFs0c_BFs0ll_BFu0c_BFs0i { signed char :0; signed long long :0; unsigned char :0; signed int :0; };
struct BFs0c_BFs0ll_BFu0c_BFs0ll { signed char :0; signed long long :0; unsigned char :0; signed long long :0; };
struct BFs0c_BFs0ll_BFu0c_BFs0s { signed char :0; signed long long :0; unsigned char :0; signed short :0; };
struct BFs0c_BFs0ll_BFu0c_BFu0c { signed char :0; signed long long :0; unsigned char :0; unsigned char :0; };
struct BFs0c_BFs0ll_BFu0c_BFu0i { signed char :0; signed long long :0; unsigned char :0; unsigned int :0; };
struct BFs0c_BFs0ll_BFu0c_BFu0ll { signed char :0; signed long long :0; unsigned char :0; unsigned long long :0; };
struct BFs0c_BFs0ll_BFu0c_BFu0s { signed char :0; signed long long :0; unsigned char :0; unsigned short :0; };
struct BFs0c_BFs0ll_BFu0i { signed char :0; signed long long :0; unsigned int :0; };
struct BFs0c_BFs0ll_BFu0i_BFs0c { signed char :0; signed long long :0; unsigned int :0; signed char :0; };
struct BFs0c_BFs0ll_BFu0i_BFs0i { signed char :0; signed long long :0; unsigned int :0; signed int :0; };
struct BFs0c_BFs0ll_BFu0i_BFs0ll { signed char :0; signed long long :0; unsigned int :0; signed long long :0; };
struct BFs0c_BFs0ll_BFu0i_BFs0s { signed char :0; signed long long :0; unsigned int :0; signed short :0; };
struct BFs0c_BFs0ll_BFu0i_BFu0c { signed char :0; signed long long :0; unsigned int :0; unsigned char :0; };
struct BFs0c_BFs0ll_BFu0i_BFu0i { signed char :0; signed long long :0; unsigned int :0; unsigned int :0; };
struct BFs0c_BFs0ll_BFu0i_BFu0ll { signed char :0; signed long long :0; unsigned int :0; unsigned long long :0; };
struct BFs0c_BFs0ll_BFu0i_BFu0s { signed char :0; signed long long :0; unsigned int :0; unsigned short :0; };
struct BFs0c_BFs0ll_BFu0ll { signed char :0; signed long long :0; unsigned long long :0; };
struct BFs0c_BFs0ll_BFu0ll_BFs0c { signed char :0; signed long long :0; unsigned long long :0; signed char :0; };
struct BFs0c_BFs0ll_BFu0ll_BFs0i { signed char :0; signed long long :0; unsigned long long :0; signed int :0; };
struct BFs0c_BFs0ll_BFu0ll_BFs0ll { signed char :0; signed long long :0; unsigned long long :0; signed long long :0; };
struct BFs0c_BFs0ll_BFu0ll_BFs0s { signed char :0; signed long long :0; unsigned long long :0; signed short :0; };
struct BFs0c_BFs0ll_BFu0ll_BFu0c { signed char :0; signed long long :0; unsigned long long :0; unsigned char :0; };
struct BFs0c_BFs0ll_BFu0ll_BFu0i { signed char :0; signed long long :0; unsigned long long :0; unsigned int :0; };
struct BFs0c_BFs0ll_BFu0ll_BFu0ll { signed char :0; signed long long :0; unsigned long long :0; unsigned long long :0; };
struct BFs0c_BFs0ll_BFu0ll_BFu0s { signed char :0; signed long long :0; unsigned long long :0; unsigned short :0; };
struct BFs0c_BFs0ll_BFu0s { signed char :0; signed long long :0; unsigned short :0; };
struct BFs0c_BFs0ll_BFu0s_BFs0c { signed char :0; signed long long :0; unsigned short :0; signed char :0; };
struct BFs0c_BFs0ll_BFu0s_BFs0i { signed char :0; signed long long :0; unsigned short :0; signed int :0; };
struct BFs0c_BFs0ll_BFu0s_BFs0ll { signed char :0; signed long long :0; unsigned short :0; signed long long :0; };
struct BFs0c_BFs0ll_BFu0s_BFs0s { signed char :0; signed long long :0; unsigned short :0; signed short :0; };
struct BFs0c_BFs0ll_BFu0s_BFu0c { signed char :0; signed long long :0; unsigned short :0; unsigned char :0; };
struct BFs0c_BFs0ll_BFu0s_BFu0i { signed char :0; signed long long :0; unsigned short :0; unsigned int :0; };
struct BFs0c_BFs0ll_BFu0s_BFu0ll { signed char :0; signed long long :0; unsigned short :0; unsigned long long :0; };
struct BFs0c_BFs0ll_BFu0s_BFu0s { signed char :0; signed long long :0; unsigned short :0; unsigned short :0; };
struct BFs0c_BFs0s { signed char :0; signed short :0; };
struct BFs0c_BFs0s_BFs0c { signed char :0; signed short :0; signed char :0; };
struct BFs0c_BFs0s_BFs0c_BFs0c { signed char :0; signed short :0; signed char :0; signed char :0; };
struct BFs0c_BFs0s_BFs0c_BFs0i { signed char :0; signed short :0; signed char :0; signed int :0; };
struct BFs0c_BFs0s_BFs0c_BFs0ll { signed char :0; signed short :0; signed char :0; signed long long :0; };
struct BFs0c_BFs0s_BFs0c_BFs0s { signed char :0; signed short :0; signed char :0; signed short :0; };
struct BFs0c_BFs0s_BFs0c_BFu0c { signed char :0; signed short :0; signed char :0; unsigned char :0; };
struct BFs0c_BFs0s_BFs0c_BFu0i { signed char :0; signed short :0; signed char :0; unsigned int :0; };
struct BFs0c_BFs0s_BFs0c_BFu0ll { signed char :0; signed short :0; signed char :0; unsigned long long :0; };
struct BFs0c_BFs0s_BFs0c_BFu0s { signed char :0; signed short :0; signed char :0; unsigned short :0; };
struct BFs0c_BFs0s_BFs0i { signed char :0; signed short :0; signed int :0; };
struct BFs0c_BFs0s_BFs0i_BFs0c { signed char :0; signed short :0; signed int :0; signed char :0; };
struct BFs0c_BFs0s_BFs0i_BFs0i { signed char :0; signed short :0; signed int :0; signed int :0; };
struct BFs0c_BFs0s_BFs0i_BFs0ll { signed char :0; signed short :0; signed int :0; signed long long :0; };
struct BFs0c_BFs0s_BFs0i_BFs0s { signed char :0; signed short :0; signed int :0; signed short :0; };
struct BFs0c_BFs0s_BFs0i_BFu0c { signed char :0; signed short :0; signed int :0; unsigned char :0; };
struct BFs0c_BFs0s_BFs0i_BFu0i { signed char :0; signed short :0; signed int :0; unsigned int :0; };
struct BFs0c_BFs0s_BFs0i_BFu0ll { signed char :0; signed short :0; signed int :0; unsigned long long :0; };
struct BFs0c_BFs0s_BFs0i_BFu0s { signed char :0; signed short :0; signed int :0; unsigned short :0; };
struct BFs0c_BFs0s_BFs0ll { signed char :0; signed short :0; signed long long :0; };
struct BFs0c_BFs0s_BFs0ll_BFs0c { signed char :0; signed short :0; signed long long :0; signed char :0; };
struct BFs0c_BFs0s_BFs0ll_BFs0i { signed char :0; signed short :0; signed long long :0; signed int :0; };
struct BFs0c_BFs0s_BFs0ll_BFs0ll { signed char :0; signed short :0; signed long long :0; signed long long :0; };
struct BFs0c_BFs0s_BFs0ll_BFs0s { signed char :0; signed short :0; signed long long :0; signed short :0; };
struct BFs0c_BFs0s_BFs0ll_BFu0c { signed char :0; signed short :0; signed long long :0; unsigned char :0; };
struct BFs0c_BFs0s_BFs0ll_BFu0i { signed char :0; signed short :0; signed long long :0; unsigned int :0; };
struct BFs0c_BFs0s_BFs0ll_BFu0ll { signed char :0; signed short :0; signed long long :0; unsigned long long :0; };
struct BFs0c_BFs0s_BFs0ll_BFu0s { signed char :0; signed short :0; signed long long :0; unsigned short :0; };
struct BFs0c_BFs0s_BFs0s { signed char :0; signed short :0; signed short :0; };
struct BFs0c_BFs0s_BFs0s_BFs0c { signed char :0; signed short :0; signed short :0; signed char :0; };
struct BFs0c_BFs0s_BFs0s_BFs0i { signed char :0; signed short :0; signed short :0; signed int :0; };
struct BFs0c_BFs0s_BFs0s_BFs0ll { signed char :0; signed short :0; signed short :0; signed long long :0; };
struct BFs0c_BFs0s_BFs0s_BFs0s { signed char :0; signed short :0; signed short :0; signed short :0; };
struct BFs0c_BFs0s_BFs0s_BFu0c { signed char :0; signed short :0; signed short :0; unsigned char :0; };
struct BFs0c_BFs0s_BFs0s_BFu0i { signed char :0; signed short :0; signed short :0; unsigned int :0; };
struct BFs0c_BFs0s_BFs0s_BFu0ll { signed char :0; signed short :0; signed short :0; unsigned long long :0; };
struct BFs0c_BFs0s_BFs0s_BFu0s { signed char :0; signed short :0; signed short :0; unsigned short :0; };
struct BFs0c_BFs0s_BFu0c { signed char :0; signed short :0; unsigned char :0; };
struct BFs0c_BFs0s_BFu0c_BFs0c { signed char :0; signed short :0; unsigned char :0; signed char :0; };
struct BFs0c_BFs0s_BFu0c_BFs0i { signed char :0; signed short :0; unsigned char :0; signed int :0; };
struct BFs0c_BFs0s_BFu0c_BFs0ll { signed char :0; signed short :0; unsigned char :0; signed long long :0; };
struct BFs0c_BFs0s_BFu0c_BFs0s { signed char :0; signed short :0; unsigned char :0; signed short :0; };
struct BFs0c_BFs0s_BFu0c_BFu0c { signed char :0; signed short :0; unsigned char :0; unsigned char :0; };
struct BFs0c_BFs0s_BFu0c_BFu0i { signed char :0; signed short :0; unsigned char :0; unsigned int :0; };
struct BFs0c_BFs0s_BFu0c_BFu0ll { signed char :0; signed short :0; unsigned char :0; unsigned long long :0; };
struct BFs0c_BFs0s_BFu0c_BFu0s { signed char :0; signed short :0; unsigned char :0; unsigned short :0; };
struct BFs0c_BFs0s_BFu0i { signed char :0; signed short :0; unsigned int :0; };
struct BFs0c_BFs0s_BFu0i_BFs0c { signed char :0; signed short :0; unsigned int :0; signed char :0; };
struct BFs0c_BFs0s_BFu0i_BFs0i { signed char :0; signed short :0; unsigned int :0; signed int :0; };
struct BFs0c_BFs0s_BFu0i_BFs0ll { signed char :0; signed short :0; unsigned int :0; signed long long :0; };
struct BFs0c_BFs0s_BFu0i_BFs0s { signed char :0; signed short :0; unsigned int :0; signed short :0; };
struct BFs0c_BFs0s_BFu0i_BFu0c { signed char :0; signed short :0; unsigned int :0; unsigned char :0; };
struct BFs0c_BFs0s_BFu0i_BFu0i { signed char :0; signed short :0; unsigned int :0; unsigned int :0; };
struct BFs0c_BFs0s_BFu0i_BFu0ll { signed char :0; signed short :0; unsigned int :0; unsigned long long :0; };
struct BFs0c_BFs0s_BFu0i_BFu0s { signed char :0; signed short :0; unsigned int :0; unsigned short :0; };
struct BFs0c_BFs0s_BFu0ll { signed char :0; signed short :0; unsigned long long :0; };
struct BFs0c_BFs0s_BFu0ll_BFs0c { signed char :0; signed short :0; unsigned long long :0; signed char :0; };
struct BFs0c_BFs0s_BFu0ll_BFs0i { signed char :0; signed short :0; unsigned long long :0; signed int :0; };
struct BFs0c_BFs0s_BFu0ll_BFs0ll { signed char :0; signed short :0; unsigned long long :0; signed long long :0; };
struct BFs0c_BFs0s_BFu0ll_BFs0s { signed char :0; signed short :0; unsigned long long :0; signed short :0; };
struct BFs0c_BFs0s_BFu0ll_BFu0c { signed char :0; signed short :0; unsigned long long :0; unsigned char :0; };
struct BFs0c_BFs0s_BFu0ll_BFu0i { signed char :0; signed short :0; unsigned long long :0; unsigned int :0; };
struct BFs0c_BFs0s_BFu0ll_BFu0ll { signed char :0; signed short :0; unsigned long long :0; unsigned long long :0; };
struct BFs0c_BFs0s_BFu0ll_BFu0s { signed char :0; signed short :0; unsigned long long :0; unsigned short :0; };
struct BFs0c_BFs0s_BFu0s { signed char :0; signed short :0; unsigned short :0; };
struct BFs0c_BFs0s_BFu0s_BFs0c { signed char :0; signed short :0; unsigned short :0; signed char :0; };
struct BFs0c_BFs0s_BFu0s_BFs0i { signed char :0; signed short :0; unsigned short :0; signed int :0; };
struct BFs0c_BFs0s_BFu0s_BFs0ll { signed char :0; signed short :0; unsigned short :0; signed long long :0; };
struct BFs0c_BFs0s_BFu0s_BFs0s { signed char :0; signed short :0; unsigned short :0; signed short :0; };
struct BFs0c_BFs0s_BFu0s_BFu0c { signed char :0; signed short :0; unsigned short :0; unsigned char :0; };
struct BFs0c_BFs0s_BFu0s_BFu0i { signed char :0; signed short :0; unsigned short :0; unsigned int :0; };
struct BFs0c_BFs0s_BFu0s_BFu0ll { signed char :0; signed short :0; unsigned short :0; unsigned long long :0; };
struct BFs0c_BFs0s_BFu0s_BFu0s { signed char :0; signed short :0; unsigned short :0; unsigned short :0; };
struct BFs0c_BFu0c { signed char :0; unsigned char :0; };
struct BFs0c_BFu0c_BFs0c { signed char :0; unsigned char :0; signed char :0; };
struct BFs0c_BFu0c_BFs0c_BFs0c { signed char :0; unsigned char :0; signed char :0; signed char :0; };
struct BFs0c_BFu0c_BFs0c_BFs0i { signed char :0; unsigned char :0; signed char :0; signed int :0; };
struct BFs0c_BFu0c_BFs0c_BFs0ll { signed char :0; unsigned char :0; signed char :0; signed long long :0; };
struct BFs0c_BFu0c_BFs0c_BFs0s { signed char :0; unsigned char :0; signed char :0; signed short :0; };
struct BFs0c_BFu0c_BFs0c_BFu0c { signed char :0; unsigned char :0; signed char :0; unsigned char :0; };
struct BFs0c_BFu0c_BFs0c_BFu0i { signed char :0; unsigned char :0; signed char :0; unsigned int :0; };
struct BFs0c_BFu0c_BFs0c_BFu0ll { signed char :0; unsigned char :0; signed char :0; unsigned long long :0; };
struct BFs0c_BFu0c_BFs0c_BFu0s { signed char :0; unsigned char :0; signed char :0; unsigned short :0; };
struct BFs0c_BFu0c_BFs0i { signed char :0; unsigned char :0; signed int :0; };
struct BFs0c_BFu0c_BFs0i_BFs0c { signed char :0; unsigned char :0; signed int :0; signed char :0; };
struct BFs0c_BFu0c_BFs0i_BFs0i { signed char :0; unsigned char :0; signed int :0; signed int :0; };
struct BFs0c_BFu0c_BFs0i_BFs0ll { signed char :0; unsigned char :0; signed int :0; signed long long :0; };
struct BFs0c_BFu0c_BFs0i_BFs0s { signed char :0; unsigned char :0; signed int :0; signed short :0; };
struct BFs0c_BFu0c_BFs0i_BFu0c { signed char :0; unsigned char :0; signed int :0; unsigned char :0; };
struct BFs0c_BFu0c_BFs0i_BFu0i { signed char :0; unsigned char :0; signed int :0; unsigned int :0; };
struct BFs0c_BFu0c_BFs0i_BFu0ll { signed char :0; unsigned char :0; signed int :0; unsigned long long :0; };
struct BFs0c_BFu0c_BFs0i_BFu0s { signed char :0; unsigned char :0; signed int :0; unsigned short :0; };
struct BFs0c_BFu0c_BFs0ll { signed char :0; unsigned char :0; signed long long :0; };
struct BFs0c_BFu0c_BFs0ll_BFs0c { signed char :0; unsigned char :0; signed long long :0; signed char :0; };
struct BFs0c_BFu0c_BFs0ll_BFs0i { signed char :0; unsigned char :0; signed long long :0; signed int :0; };
struct BFs0c_BFu0c_BFs0ll_BFs0ll { signed char :0; unsigned char :0; signed long long :0; signed long long :0; };
struct BFs0c_BFu0c_BFs0ll_BFs0s { signed char :0; unsigned char :0; signed long long :0; signed short :0; };
struct BFs0c_BFu0c_BFs0ll_BFu0c { signed char :0; unsigned char :0; signed long long :0; unsigned char :0; };
struct BFs0c_BFu0c_BFs0ll_BFu0i { signed char :0; unsigned char :0; signed long long :0; unsigned int :0; };
struct BFs0c_BFu0c_BFs0ll_BFu0ll { signed char :0; unsigned char :0; signed long long :0; unsigned long long :0; };
struct BFs0c_BFu0c_BFs0ll_BFu0s { signed char :0; unsigned char :0; signed long long :0; unsigned short :0; };
struct BFs0c_BFu0c_BFs0s { signed char :0; unsigned char :0; signed short :0; };
struct BFs0c_BFu0c_BFs0s_BFs0c { signed char :0; unsigned char :0; signed short :0; signed char :0; };
struct BFs0c_BFu0c_BFs0s_BFs0i { signed char :0; unsigned char :0; signed short :0; signed int :0; };
struct BFs0c_BFu0c_BFs0s_BFs0ll { signed char :0; unsigned char :0; signed short :0; signed long long :0; };
struct BFs0c_BFu0c_BFs0s_BFs0s { signed char :0; unsigned char :0; signed short :0; signed short :0; };
struct BFs0c_BFu0c_BFs0s_BFu0c { signed char :0; unsigned char :0; signed short :0; unsigned char :0; };
struct BFs0c_BFu0c_BFs0s_BFu0i { signed char :0; unsigned char :0; signed short :0; unsigned int :0; };
struct BFs0c_BFu0c_BFs0s_BFu0ll { signed char :0; unsigned char :0; signed short :0; unsigned long long :0; };
struct BFs0c_BFu0c_BFs0s_BFu0s { signed char :0; unsigned char :0; signed short :0; unsigned short :0; };
struct BFs0c_BFu0c_BFu0c { signed char :0; unsigned char :0; unsigned char :0; };
struct BFs0c_BFu0c_BFu0c_BFs0c { signed char :0; unsigned char :0; unsigned char :0; signed char :0; };
struct BFs0c_BFu0c_BFu0c_BFs0i { signed char :0; unsigned char :0; unsigned char :0; signed int :0; };
struct BFs0c_BFu0c_BFu0c_BFs0ll { signed char :0; unsigned char :0; unsigned char :0; signed long long :0; };
struct BFs0c_BFu0c_BFu0c_BFs0s { signed char :0; unsigned char :0; unsigned char :0; signed short :0; };
struct BFs0c_BFu0c_BFu0c_BFu0c { signed char :0; unsigned char :0; unsigned char :0; unsigned char :0; };
struct BFs0c_BFu0c_BFu0c_BFu0i { signed char :0; unsigned char :0; unsigned char :0; unsigned int :0; };
struct BFs0c_BFu0c_BFu0c_BFu0ll { signed char :0; unsigned char :0; unsigned char :0; unsigned long long :0; };
struct BFs0c_BFu0c_BFu0c_BFu0s { signed char :0; unsigned char :0; unsigned char :0; unsigned short :0; };
struct BFs0c_BFu0c_BFu0i { signed char :0; unsigned char :0; unsigned int :0; };
struct BFs0c_BFu0c_BFu0i_BFs0c { signed char :0; unsigned char :0; unsigned int :0; signed char :0; };
struct BFs0c_BFu0c_BFu0i_BFs0i { signed char :0; unsigned char :0; unsigned int :0; signed int :0; };
struct BFs0c_BFu0c_BFu0i_BFs0ll { signed char :0; unsigned char :0; unsigned int :0; signed long long :0; };
struct BFs0c_BFu0c_BFu0i_BFs0s { signed char :0; unsigned char :0; unsigned int :0; signed short :0; };
struct BFs0c_BFu0c_BFu0i_BFu0c { signed char :0; unsigned char :0; unsigned int :0; unsigned char :0; };
struct BFs0c_BFu0c_BFu0i_BFu0i { signed char :0; unsigned char :0; unsigned int :0; unsigned int :0; };
struct BFs0c_BFu0c_BFu0i_BFu0ll { signed char :0; unsigned char :0; unsigned int :0; unsigned long long :0; };
struct BFs0c_BFu0c_BFu0i_BFu0s { signed char :0; unsigned char :0; unsigned int :0; unsigned short :0; };
struct BFs0c_BFu0c_BFu0ll { signed char :0; unsigned char :0; unsigned long long :0; };
struct BFs0c_BFu0c_BFu0ll_BFs0c { signed char :0; unsigned char :0; unsigned long long :0; signed char :0; };
struct BFs0c_BFu0c_BFu0ll_BFs0i { signed char :0; unsigned char :0; unsigned long long :0; signed int :0; };
struct BFs0c_BFu0c_BFu0ll_BFs0ll { signed char :0; unsigned char :0; unsigned long long :0; signed long long :0; };
struct BFs0c_BFu0c_BFu0ll_BFs0s { signed char :0; unsigned char :0; unsigned long long :0; signed short :0; };
struct BFs0c_BFu0c_BFu0ll_BFu0c { signed char :0; unsigned char :0; unsigned long long :0; unsigned char :0; };
struct BFs0c_BFu0c_BFu0ll_BFu0i { signed char :0; unsigned char :0; unsigned long long :0; unsigned int :0; };
struct BFs0c_BFu0c_BFu0ll_BFu0ll { signed char :0; unsigned char :0; unsigned long long :0; unsigned long long :0; };
struct BFs0c_BFu0c_BFu0ll_BFu0s { signed char :0; unsigned char :0; unsigned long long :0; unsigned short :0; };
struct BFs0c_BFu0c_BFu0s { signed char :0; unsigned char :0; unsigned short :0; };
struct BFs0c_BFu0c_BFu0s_BFs0c { signed char :0; unsigned char :0; unsigned short :0; signed char :0; };
struct BFs0c_BFu0c_BFu0s_BFs0i { signed char :0; unsigned char :0; unsigned short :0; signed int :0; };
struct BFs0c_BFu0c_BFu0s_BFs0ll { signed char :0; unsigned char :0; unsigned short :0; signed long long :0; };
struct BFs0c_BFu0c_BFu0s_BFs0s { signed char :0; unsigned char :0; unsigned short :0; signed short :0; };
struct BFs0c_BFu0c_BFu0s_BFu0c { signed char :0; unsigned char :0; unsigned short :0; unsigned char :0; };
struct BFs0c_BFu0c_BFu0s_BFu0i { signed char :0; unsigned char :0; unsigned short :0; unsigned int :0; };
struct BFs0c_BFu0c_BFu0s_BFu0ll { signed char :0; unsigned char :0; unsigned short :0; unsigned long long :0; };
struct BFs0c_BFu0c_BFu0s_BFu0s { signed char :0; unsigned char :0; unsigned short :0; unsigned short :0; };
struct BFs0c_BFu0i { signed char :0; unsigned int :0; };
struct BFs0c_BFu0i_BFs0c { signed char :0; unsigned int :0; signed char :0; };
struct BFs0c_BFu0i_BFs0c_BFs0c { signed char :0; unsigned int :0; signed char :0; signed char :0; };
struct BFs0c_BFu0i_BFs0c_BFs0i { signed char :0; unsigned int :0; signed char :0; signed int :0; };
struct BFs0c_BFu0i_BFs0c_BFs0ll { signed char :0; unsigned int :0; signed char :0; signed long long :0; };
struct BFs0c_BFu0i_BFs0c_BFs0s { signed char :0; unsigned int :0; signed char :0; signed short :0; };
struct BFs0c_BFu0i_BFs0c_BFu0c { signed char :0; unsigned int :0; signed char :0; unsigned char :0; };
struct BFs0c_BFu0i_BFs0c_BFu0i { signed char :0; unsigned int :0; signed char :0; unsigned int :0; };
struct BFs0c_BFu0i_BFs0c_BFu0ll { signed char :0; unsigned int :0; signed char :0; unsigned long long :0; };
struct BFs0c_BFu0i_BFs0c_BFu0s { signed char :0; unsigned int :0; signed char :0; unsigned short :0; };
struct BFs0c_BFu0i_BFs0i { signed char :0; unsigned int :0; signed int :0; };
struct BFs0c_BFu0i_BFs0i_BFs0c { signed char :0; unsigned int :0; signed int :0; signed char :0; };
struct BFs0c_BFu0i_BFs0i_BFs0i { signed char :0; unsigned int :0; signed int :0; signed int :0; };
struct BFs0c_BFu0i_BFs0i_BFs0ll { signed char :0; unsigned int :0; signed int :0; signed long long :0; };
struct BFs0c_BFu0i_BFs0i_BFs0s { signed char :0; unsigned int :0; signed int :0; signed short :0; };
struct BFs0c_BFu0i_BFs0i_BFu0c { signed char :0; unsigned int :0; signed int :0; unsigned char :0; };
struct BFs0c_BFu0i_BFs0i_BFu0i { signed char :0; unsigned int :0; signed int :0; unsigned int :0; };
struct BFs0c_BFu0i_BFs0i_BFu0ll { signed char :0; unsigned int :0; signed int :0; unsigned long long :0; };
struct BFs0c_BFu0i_BFs0i_BFu0s { signed char :0; unsigned int :0; signed int :0; unsigned short :0; };
struct BFs0c_BFu0i_BFs0ll { signed char :0; unsigned int :0; signed long long :0; };
struct BFs0c_BFu0i_BFs0ll_BFs0c { signed char :0; unsigned int :0; signed long long :0; signed char :0; };
struct BFs0c_BFu0i_BFs0ll_BFs0i { signed char :0; unsigned int :0; signed long long :0; signed int :0; };
struct BFs0c_BFu0i_BFs0ll_BFs0ll { signed char :0; unsigned int :0; signed long long :0; signed long long :0; };
struct BFs0c_BFu0i_BFs0ll_BFs0s { signed char :0; unsigned int :0; signed long long :0; signed short :0; };
struct BFs0c_BFu0i_BFs0ll_BFu0c { signed char :0; unsigned int :0; signed long long :0; unsigned char :0; };
struct BFs0c_BFu0i_BFs0ll_BFu0i { signed char :0; unsigned int :0; signed long long :0; unsigned int :0; };
struct BFs0c_BFu0i_BFs0ll_BFu0ll { signed char :0; unsigned int :0; signed long long :0; unsigned long long :0; };
struct BFs0c_BFu0i_BFs0ll_BFu0s { signed char :0; unsigned int :0; signed long long :0; unsigned short :0; };
struct BFs0c_BFu0i_BFs0s { signed char :0; unsigned int :0; signed short :0; };
struct BFs0c_BFu0i_BFs0s_BFs0c { signed char :0; unsigned int :0; signed short :0; signed char :0; };
struct BFs0c_BFu0i_BFs0s_BFs0i { signed char :0; unsigned int :0; signed short :0; signed int :0; };
struct BFs0c_BFu0i_BFs0s_BFs0ll { signed char :0; unsigned int :0; signed short :0; signed long long :0; };
struct BFs0c_BFu0i_BFs0s_BFs0s { signed char :0; unsigned int :0; signed short :0; signed short :0; };
struct BFs0c_BFu0i_BFs0s_BFu0c { signed char :0; unsigned int :0; signed short :0; unsigned char :0; };
struct BFs0c_BFu0i_BFs0s_BFu0i { signed char :0; unsigned int :0; signed short :0; unsigned int :0; };
struct BFs0c_BFu0i_BFs0s_BFu0ll { signed char :0; unsigned int :0; signed short :0; unsigned long long :0; };
struct BFs0c_BFu0i_BFs0s_BFu0s { signed char :0; unsigned int :0; signed short :0; unsigned short :0; };
struct BFs0c_BFu0i_BFu0c { signed char :0; unsigned int :0; unsigned char :0; };
struct BFs0c_BFu0i_BFu0c_BFs0c { signed char :0; unsigned int :0; unsigned char :0; signed char :0; };
struct BFs0c_BFu0i_BFu0c_BFs0i { signed char :0; unsigned int :0; unsigned char :0; signed int :0; };
struct BFs0c_BFu0i_BFu0c_BFs0ll { signed char :0; unsigned int :0; unsigned char :0; signed long long :0; };
struct BFs0c_BFu0i_BFu0c_BFs0s { signed char :0; unsigned int :0; unsigned char :0; signed short :0; };
struct BFs0c_BFu0i_BFu0c_BFu0c { signed char :0; unsigned int :0; unsigned char :0; unsigned char :0; };
struct BFs0c_BFu0i_BFu0c_BFu0i { signed char :0; unsigned int :0; unsigned char :0; unsigned int :0; };
struct BFs0c_BFu0i_BFu0c_BFu0ll { signed char :0; unsigned int :0; unsigned char :0; unsigned long long :0; };
struct BFs0c_BFu0i_BFu0c_BFu0s { signed char :0; unsigned int :0; unsigned char :0; unsigned short :0; };
struct BFs0c_BFu0i_BFu0i { signed char :0; unsigned int :0; unsigned int :0; };
struct BFs0c_BFu0i_BFu0i_BFs0c { signed char :0; unsigned int :0; unsigned int :0; signed char :0; };
struct BFs0c_BFu0i_BFu0i_BFs0i { signed char :0; unsigned int :0; unsigned int :0; signed int :0; };
struct BFs0c_BFu0i_BFu0i_BFs0ll { signed char :0; unsigned int :0; unsigned int :0; signed long long :0; };
struct BFs0c_BFu0i_BFu0i_BFs0s { signed char :0; unsigned int :0; unsigned int :0; signed short :0; };
struct BFs0c_BFu0i_BFu0i_BFu0c { signed char :0; unsigned int :0; unsigned int :0; unsigned char :0; };
struct BFs0c_BFu0i_BFu0i_BFu0i { signed char :0; unsigned int :0; unsigned int :0; unsigned int :0; };
struct BFs0c_BFu0i_BFu0i_BFu0ll { signed char :0; unsigned int :0; unsigned int :0; unsigned long long :0; };
struct BFs0c_BFu0i_BFu0i_BFu0s { signed char :0; unsigned int :0; unsigned int :0; unsigned short :0; };
struct BFs0c_BFu0i_BFu0ll { signed char :0; unsigned int :0; unsigned long long :0; };
struct BFs0c_BFu0i_BFu0ll_BFs0c { signed char :0; unsigned int :0; unsigned long long :0; signed char :0; };
struct BFs0c_BFu0i_BFu0ll_BFs0i { signed char :0; unsigned int :0; unsigned long long :0; signed int :0; };
struct BFs0c_BFu0i_BFu0ll_BFs0ll { signed char :0; unsigned int :0; unsigned long long :0; signed long long :0; };
struct BFs0c_BFu0i_BFu0ll_BFs0s { signed char :0; unsigned int :0; unsigned long long :0; signed short :0; };
struct BFs0c_BFu0i_BFu0ll_BFu0c { signed char :0; unsigned int :0; unsigned long long :0; unsigned char :0; };
struct BFs0c_BFu0i_BFu0ll_BFu0i { signed char :0; unsigned int :0; unsigned long long :0; unsigned int :0; };
struct BFs0c_BFu0i_BFu0ll_BFu0ll { signed char :0; unsigned int :0; unsigned long long :0; unsigned long long :0; };
struct BFs0c_BFu0i_BFu0ll_BFu0s { signed char :0; unsigned int :0; unsigned long long :0; unsigned short :0; };
struct BFs0c_BFu0i_BFu0s { signed char :0; unsigned int :0; unsigned short :0; };
struct BFs0c_BFu0i_BFu0s_BFs0c { signed char :0; unsigned int :0; unsigned short :0; signed char :0; };
struct BFs0c_BFu0i_BFu0s_BFs0i { signed char :0; unsigned int :0; unsigned short :0; signed int :0; };
struct BFs0c_BFu0i_BFu0s_BFs0ll { signed char :0; unsigned int :0; unsigned short :0; signed long long :0; };
struct BFs0c_BFu0i_BFu0s_BFs0s { signed char :0; unsigned int :0; unsigned short :0; signed short :0; };
struct BFs0c_BFu0i_BFu0s_BFu0c { signed char :0; unsigned int :0; unsigned short :0; unsigned char :0; };
struct BFs0c_BFu0i_BFu0s_BFu0i { signed char :0; unsigned int :0; unsigned short :0; unsigned int :0; };
struct BFs0c_BFu0i_BFu0s_BFu0ll { signed char :0; unsigned int :0; unsigned short :0; unsigned long long :0; };
struct BFs0c_BFu0i_BFu0s_BFu0s { signed char :0; unsigned int :0; unsigned short :0; unsigned short :0; };
struct BFs0c_BFu0ll { signed char :0; unsigned long long :0; };
struct BFs0c_BFu0ll_BFs0c { signed char :0; unsigned long long :0; signed char :0; };
struct BFs0c_BFu0ll_BFs0c_BFs0c { signed char :0; unsigned long long :0; signed char :0; signed char :0; };
struct BFs0c_BFu0ll_BFs0c_BFs0i { signed char :0; unsigned long long :0; signed char :0; signed int :0; };
struct BFs0c_BFu0ll_BFs0c_BFs0ll { signed char :0; unsigned long long :0; signed char :0; signed long long :0; };
struct BFs0c_BFu0ll_BFs0c_BFs0s { signed char :0; unsigned long long :0; signed char :0; signed short :0; };
struct BFs0c_BFu0ll_BFs0c_BFu0c { signed char :0; unsigned long long :0; signed char :0; unsigned char :0; };
struct BFs0c_BFu0ll_BFs0c_BFu0i { signed char :0; unsigned long long :0; signed char :0; unsigned int :0; };
struct BFs0c_BFu0ll_BFs0c_BFu0ll { signed char :0; unsigned long long :0; signed char :0; unsigned long long :0; };
struct BFs0c_BFu0ll_BFs0c_BFu0s { signed char :0; unsigned long long :0; signed char :0; unsigned short :0; };
struct BFs0c_BFu0ll_BFs0i { signed char :0; unsigned long long :0; signed int :0; };
struct BFs0c_BFu0ll_BFs0i_BFs0c { signed char :0; unsigned long long :0; signed int :0; signed char :0; };
struct BFs0c_BFu0ll_BFs0i_BFs0i { signed char :0; unsigned long long :0; signed int :0; signed int :0; };
struct BFs0c_BFu0ll_BFs0i_BFs0ll { signed char :0; unsigned long long :0; signed int :0; signed long long :0; };
struct BFs0c_BFu0ll_BFs0i_BFs0s { signed char :0; unsigned long long :0; signed int :0; signed short :0; };
struct BFs0c_BFu0ll_BFs0i_BFu0c { signed char :0; unsigned long long :0; signed int :0; unsigned char :0; };
struct BFs0c_BFu0ll_BFs0i_BFu0i { signed char :0; unsigned long long :0; signed int :0; unsigned int :0; };
struct BFs0c_BFu0ll_BFs0i_BFu0ll { signed char :0; unsigned long long :0; signed int :0; unsigned long long :0; };
struct BFs0c_BFu0ll_BFs0i_BFu0s { signed char :0; unsigned long long :0; signed int :0; unsigned short :0; };
struct BFs0c_BFu0ll_BFs0ll { signed char :0; unsigned long long :0; signed long long :0; };
struct BFs0c_BFu0ll_BFs0ll_BFs0c { signed char :0; unsigned long long :0; signed long long :0; signed char :0; };
struct BFs0c_BFu0ll_BFs0ll_BFs0i { signed char :0; unsigned long long :0; signed long long :0; signed int :0; };
struct BFs0c_BFu0ll_BFs0ll_BFs0ll { signed char :0; unsigned long long :0; signed long long :0; signed long long :0; };
struct BFs0c_BFu0ll_BFs0ll_BFs0s { signed char :0; unsigned long long :0; signed long long :0; signed short :0; };
struct BFs0c_BFu0ll_BFs0ll_BFu0c { signed char :0; unsigned long long :0; signed long long :0; unsigned char :0; };
struct BFs0c_BFu0ll_BFs0ll_BFu0i { signed char :0; unsigned long long :0; signed long long :0; unsigned int :0; };
struct BFs0c_BFu0ll_BFs0ll_BFu0ll { signed char :0; unsigned long long :0; signed long long :0; unsigned long long :0; };
struct BFs0c_BFu0ll_BFs0ll_BFu0s { signed char :0; unsigned long long :0; signed long long :0; unsigned short :0; };
struct BFs0c_BFu0ll_BFs0s { signed char :0; unsigned long long :0; signed short :0; };
struct BFs0c_BFu0ll_BFs0s_BFs0c { signed char :0; unsigned long long :0; signed short :0; signed char :0; };
struct BFs0c_BFu0ll_BFs0s_BFs0i { signed char :0; unsigned long long :0; signed short :0; signed int :0; };
struct BFs0c_BFu0ll_BFs0s_BFs0ll { signed char :0; unsigned long long :0; signed short :0; signed long long :0; };
struct BFs0c_BFu0ll_BFs0s_BFs0s { signed char :0; unsigned long long :0; signed short :0; signed short :0; };
struct BFs0c_BFu0ll_BFs0s_BFu0c { signed char :0; unsigned long long :0; signed short :0; unsigned char :0; };
struct BFs0c_BFu0ll_BFs0s_BFu0i { signed char :0; unsigned long long :0; signed short :0; unsigned int :0; };
struct BFs0c_BFu0ll_BFs0s_BFu0ll { signed char :0; unsigned long long :0; signed short :0; unsigned long long :0; };
struct BFs0c_BFu0ll_BFs0s_BFu0s { signed char :0; unsigned long long :0; signed short :0; unsigned short :0; };
struct BFs0c_BFu0ll_BFu0c { signed char :0; unsigned long long :0; unsigned char :0; };
struct BFs0c_BFu0ll_BFu0c_BFs0c { signed char :0; unsigned long long :0; unsigned char :0; signed char :0; };
struct BFs0c_BFu0ll_BFu0c_BFs0i { signed char :0; unsigned long long :0; unsigned char :0; signed int :0; };
struct BFs0c_BFu0ll_BFu0c_BFs0ll { signed char :0; unsigned long long :0; unsigned char :0; signed long long :0; };
struct BFs0c_BFu0ll_BFu0c_BFs0s { signed char :0; unsigned long long :0; unsigned char :0; signed short :0; };
struct BFs0c_BFu0ll_BFu0c_BFu0c { signed char :0; unsigned long long :0; unsigned char :0; unsigned char :0; };
struct BFs0c_BFu0ll_BFu0c_BFu0i { signed char :0; unsigned long long :0; unsigned char :0; unsigned int :0; };
struct BFs0c_BFu0ll_BFu0c_BFu0ll { signed char :0; unsigned long long :0; unsigned char :0; unsigned long long :0; };
struct BFs0c_BFu0ll_BFu0c_BFu0s { signed char :0; unsigned long long :0; unsigned char :0; unsigned short :0; };
struct BFs0c_BFu0ll_BFu0i { signed char :0; unsigned long long :0; unsigned int :0; };
struct BFs0c_BFu0ll_BFu0i_BFs0c { signed char :0; unsigned long long :0; unsigned int :0; signed char :0; };
struct BFs0c_BFu0ll_BFu0i_BFs0i { signed char :0; unsigned long long :0; unsigned int :0; signed int :0; };
struct BFs0c_BFu0ll_BFu0i_BFs0ll { signed char :0; unsigned long long :0; unsigned int :0; signed long long :0; };
struct BFs0c_BFu0ll_BFu0i_BFs0s { signed char :0; unsigned long long :0; unsigned int :0; signed short :0; };
struct BFs0c_BFu0ll_BFu0i_BFu0c { signed char :0; unsigned long long :0; unsigned int :0; unsigned char :0; };
struct BFs0c_BFu0ll_BFu0i_BFu0i { signed char :0; unsigned long long :0; unsigned int :0; unsigned int :0; };
struct BFs0c_BFu0ll_BFu0i_BFu0ll { signed char :0; unsigned long long :0; unsigned int :0; unsigned long long :0; };
struct BFs0c_BFu0ll_BFu0i_BFu0s { signed char :0; unsigned long long :0; unsigned int :0; unsigned short :0; };
struct BFs0c_BFu0ll_BFu0ll { signed char :0; unsigned long long :0; unsigned long long :0; };
struct BFs0c_BFu0ll_BFu0ll_BFs0c { signed char :0; unsigned long long :0; unsigned long long :0; signed char :0; };
struct BFs0c_BFu0ll_BFu0ll_BFs0i { signed char :0; unsigned long long :0; unsigned long long :0; signed int :0; };
struct BFs0c_BFu0ll_BFu0ll_BFs0ll { signed char :0; unsigned long long :0; unsigned long long :0; signed long long :0; };
struct BFs0c_BFu0ll_BFu0ll_BFs0s { signed char :0; unsigned long long :0; unsigned long long :0; signed short :0; };
struct BFs0c_BFu0ll_BFu0ll_BFu0c { signed char :0; unsigned long long :0; unsigned long long :0; unsigned char :0; };
struct BFs0c_BFu0ll_BFu0ll_BFu0i { signed char :0; unsigned long long :0; unsigned long long :0; unsigned int :0; };
struct BFs0c_BFu0ll_BFu0ll_BFu0ll { signed char :0; unsigned long long :0; unsigned long long :0; unsigned long long :0; };
struct BFs0c_BFu0ll_BFu0ll_BFu0s { signed char :0; unsigned long long :0; unsigned long long :0; unsigned short :0; };
struct BFs0c_BFu0ll_BFu0s { signed char :0; unsigned long long :0; unsigned short :0; };
struct BFs0c_BFu0ll_BFu0s_BFs0c { signed char :0; unsigned long long :0; unsigned short :0; signed char :0; };
struct BFs0c_BFu0ll_BFu0s_BFs0i { signed char :0; unsigned long long :0; unsigned short :0; signed int :0; };
struct BFs0c_BFu0ll_BFu0s_BFs0ll { signed char :0; unsigned long long :0; unsigned short :0; signed long long :0; };
struct BFs0c_BFu0ll_BFu0s_BFs0s { signed char :0; unsigned long long :0; unsigned short :0; signed short :0; };
struct BFs0c_BFu0ll_BFu0s_BFu0c { signed char :0; unsigned long long :0; unsigned short :0; unsigned char :0; };
struct BFs0c_BFu0ll_BFu0s_BFu0i { signed char :0; unsigned long long :0; unsigned short :0; unsigned int :0; };
struct BFs0c_BFu0ll_BFu0s_BFu0ll { signed char :0; unsigned long long :0; unsigned short :0; unsigned long long :0; };
struct BFs0c_BFu0ll_BFu0s_BFu0s { signed char :0; unsigned long long :0; unsigned short :0; unsigned short :0; };
struct BFs0c_BFu0s { signed char :0; unsigned short :0; };
struct BFs0c_BFu0s_BFs0c { signed char :0; unsigned short :0; signed char :0; };
struct BFs0c_BFu0s_BFs0c_BFs0c { signed char :0; unsigned short :0; signed char :0; signed char :0; };
struct BFs0c_BFu0s_BFs0c_BFs0i { signed char :0; unsigned short :0; signed char :0; signed int :0; };
struct BFs0c_BFu0s_BFs0c_BFs0ll { signed char :0; unsigned short :0; signed char :0; signed long long :0; };
struct BFs0c_BFu0s_BFs0c_BFs0s { signed char :0; unsigned short :0; signed char :0; signed short :0; };
struct BFs0c_BFu0s_BFs0c_BFu0c { signed char :0; unsigned short :0; signed char :0; unsigned char :0; };
struct BFs0c_BFu0s_BFs0c_BFu0i { signed char :0; unsigned short :0; signed char :0; unsigned int :0; };
struct BFs0c_BFu0s_BFs0c_BFu0ll { signed char :0; unsigned short :0; signed char :0; unsigned long long :0; };
struct BFs0c_BFu0s_BFs0c_BFu0s { signed char :0; unsigned short :0; signed char :0; unsigned short :0; };
struct BFs0c_BFu0s_BFs0i { signed char :0; unsigned short :0; signed int :0; };
struct BFs0c_BFu0s_BFs0i_BFs0c { signed char :0; unsigned short :0; signed int :0; signed char :0; };
struct BFs0c_BFu0s_BFs0i_BFs0i { signed char :0; unsigned short :0; signed int :0; signed int :0; };
struct BFs0c_BFu0s_BFs0i_BFs0ll { signed char :0; unsigned short :0; signed int :0; signed long long :0; };
struct BFs0c_BFu0s_BFs0i_BFs0s { signed char :0; unsigned short :0; signed int :0; signed short :0; };
struct BFs0c_BFu0s_BFs0i_BFu0c { signed char :0; unsigned short :0; signed int :0; unsigned char :0; };
struct BFs0c_BFu0s_BFs0i_BFu0i { signed char :0; unsigned short :0; signed int :0; unsigned int :0; };
struct BFs0c_BFu0s_BFs0i_BFu0ll { signed char :0; unsigned short :0; signed int :0; unsigned long long :0; };
struct BFs0c_BFu0s_BFs0i_BFu0s { signed char :0; unsigned short :0; signed int :0; unsigned short :0; };
struct BFs0c_BFu0s_BFs0ll { signed char :0; unsigned short :0; signed long long :0; };
struct BFs0c_BFu0s_BFs0ll_BFs0c { signed char :0; unsigned short :0; signed long long :0; signed char :0; };
struct BFs0c_BFu0s_BFs0ll_BFs0i { signed char :0; unsigned short :0; signed long long :0; signed int :0; };
struct BFs0c_BFu0s_BFs0ll_BFs0ll { signed char :0; unsigned short :0; signed long long :0; signed long long :0; };
struct BFs0c_BFu0s_BFs0ll_BFs0s { signed char :0; unsigned short :0; signed long long :0; signed short :0; };
struct BFs0c_BFu0s_BFs0ll_BFu0c { signed char :0; unsigned short :0; signed long long :0; unsigned char :0; };
struct BFs0c_BFu0s_BFs0ll_BFu0i { signed char :0; unsigned short :0; signed long long :0; unsigned int :0; };
struct BFs0c_BFu0s_BFs0ll_BFu0ll { signed char :0; unsigned short :0; signed long long :0; unsigned long long :0; };
struct BFs0c_BFu0s_BFs0ll_BFu0s { signed char :0; unsigned short :0; signed long long :0; unsigned short :0; };
struct BFs0c_BFu0s_BFs0s { signed char :0; unsigned short :0; signed short :0; };
struct BFs0c_BFu0s_BFs0s_BFs0c { signed char :0; unsigned short :0; signed short :0; signed char :0; };
struct BFs0c_BFu0s_BFs0s_BFs0i { signed char :0; unsigned short :0; signed short :0; signed int :0; };
struct BFs0c_BFu0s_BFs0s_BFs0ll { signed char :0; unsigned short :0; signed short :0; signed long long :0; };
struct BFs0c_BFu0s_BFs0s_BFs0s { signed char :0; unsigned short :0; signed short :0; signed short :0; };
struct BFs0c_BFu0s_BFs0s_BFu0c { signed char :0; unsigned short :0; signed short :0; unsigned char :0; };
struct BFs0c_BFu0s_BFs0s_BFu0i { signed char :0; unsigned short :0; signed short :0; unsigned int :0; };
struct BFs0c_BFu0s_BFs0s_BFu0ll { signed char :0; unsigned short :0; signed short :0; unsigned long long :0; };
struct BFs0c_BFu0s_BFs0s_BFu0s { signed char :0; unsigned short :0; signed short :0; unsigned short :0; };
struct BFs0c_BFu0s_BFu0c { signed char :0; unsigned short :0; unsigned char :0; };
struct BFs0c_BFu0s_BFu0c_BFs0c { signed char :0; unsigned short :0; unsigned char :0; signed char :0; };
struct BFs0c_BFu0s_BFu0c_BFs0i { signed char :0; unsigned short :0; unsigned char :0; signed int :0; };
struct BFs0c_BFu0s_BFu0c_BFs0ll { signed char :0; unsigned short :0; unsigned char :0; signed long long :0; };
struct BFs0c_BFu0s_BFu0c_BFs0s { signed char :0; unsigned short :0; unsigned char :0; signed short :0; };
struct BFs0c_BFu0s_BFu0c_BFu0c { signed char :0; unsigned short :0; unsigned char :0; unsigned char :0; };
struct BFs0c_BFu0s_BFu0c_BFu0i { signed char :0; unsigned short :0; unsigned char :0; unsigned int :0; };
struct BFs0c_BFu0s_BFu0c_BFu0ll { signed char :0; unsigned short :0; unsigned char :0; unsigned long long :0; };
struct BFs0c_BFu0s_BFu0c_BFu0s { signed char :0; unsigned short :0; unsigned char :0; unsigned short :0; };
struct BFs0c_BFu0s_BFu0i { signed char :0; unsigned short :0; unsigned int :0; };
struct BFs0c_BFu0s_BFu0i_BFs0c { signed char :0; unsigned short :0; unsigned int :0; signed char :0; };
struct BFs0c_BFu0s_BFu0i_BFs0i { signed char :0; unsigned short :0; unsigned int :0; signed int :0; };
struct BFs0c_BFu0s_BFu0i_BFs0ll { signed char :0; unsigned short :0; unsigned int :0; signed long long :0; };
struct BFs0c_BFu0s_BFu0i_BFs0s { signed char :0; unsigned short :0; unsigned int :0; signed short :0; };
struct BFs0c_BFu0s_BFu0i_BFu0c { signed char :0; unsigned short :0; unsigned int :0; unsigned char :0; };
struct BFs0c_BFu0s_BFu0i_BFu0i { signed char :0; unsigned short :0; unsigned int :0; unsigned int :0; };
struct BFs0c_BFu0s_BFu0i_BFu0ll { signed char :0; unsigned short :0; unsigned int :0; unsigned long long :0; };
struct BFs0c_BFu0s_BFu0i_BFu0s { signed char :0; unsigned short :0; unsigned int :0; unsigned short :0; };
struct BFs0c_BFu0s_BFu0ll { signed char :0; unsigned short :0; unsigned long long :0; };
struct BFs0c_BFu0s_BFu0ll_BFs0c { signed char :0; unsigned short :0; unsigned long long :0; signed char :0; };
struct BFs0c_BFu0s_BFu0ll_BFs0i { signed char :0; unsigned short :0; unsigned long long :0; signed int :0; };
struct BFs0c_BFu0s_BFu0ll_BFs0ll { signed char :0; unsigned short :0; unsigned long long :0; signed long long :0; };
struct BFs0c_BFu0s_BFu0ll_BFs0s { signed char :0; unsigned short :0; unsigned long long :0; signed short :0; };
struct BFs0c_BFu0s_BFu0ll_BFu0c { signed char :0; unsigned short :0; unsigned long long :0; unsigned char :0; };
struct BFs0c_BFu0s_BFu0ll_BFu0i { signed char :0; unsigned short :0; unsigned long long :0; unsigned int :0; };
struct BFs0c_BFu0s_BFu0ll_BFu0ll { signed char :0; unsigned short :0; unsigned long long :0; unsigned long long :0; };
struct BFs0c_BFu0s_BFu0ll_BFu0s { signed char :0; unsigned short :0; unsigned long long :0; unsigned short :0; };
struct BFs0c_BFu0s_BFu0s { signed char :0; unsigned short :0; unsigned short :0; };
struct BFs0c_BFu0s_BFu0s_BFs0c { signed char :0; unsigned short :0; unsigned short :0; signed char :0; };
struct BFs0c_BFu0s_BFu0s_BFs0i { signed char :0; unsigned short :0; unsigned short :0; signed int :0; };
struct BFs0c_BFu0s_BFu0s_BFs0ll { signed char :0; unsigned short :0; unsigned short :0; signed long long :0; };
struct BFs0c_BFu0s_BFu0s_BFs0s { signed char :0; unsigned short :0; unsigned short :0; signed short :0; };
struct BFs0c_BFu0s_BFu0s_BFu0c { signed char :0; unsigned short :0; unsigned short :0; unsigned char :0; };
struct BFs0c_BFu0s_BFu0s_BFu0i { signed char :0; unsigned short :0; unsigned short :0; unsigned int :0; };
struct BFs0c_BFu0s_BFu0s_BFu0ll { signed char :0; unsigned short :0; unsigned short :0; unsigned long long :0; };
struct BFs0c_BFu0s_BFu0s_BFu0s { signed char :0; unsigned short :0; unsigned short :0; unsigned short :0; };
struct BFs0i_BFs0c { signed int :0; signed char :0; };
struct BFs0i_BFs0c_BFs0c { signed int :0; signed char :0; signed char :0; };
struct BFs0i_BFs0c_BFs0c_BFs0c { signed int :0; signed char :0; signed char :0; signed char :0; };
struct BFs0i_BFs0c_BFs0c_BFs0i { signed int :0; signed char :0; signed char :0; signed int :0; };
struct BFs0i_BFs0c_BFs0c_BFs0ll { signed int :0; signed char :0; signed char :0; signed long long :0; };
struct BFs0i_BFs0c_BFs0c_BFs0s { signed int :0; signed char :0; signed char :0; signed short :0; };
struct BFs0i_BFs0c_BFs0c_BFu0c { signed int :0; signed char :0; signed char :0; unsigned char :0; };
struct BFs0i_BFs0c_BFs0c_BFu0i { signed int :0; signed char :0; signed char :0; unsigned int :0; };
struct BFs0i_BFs0c_BFs0c_BFu0ll { signed int :0; signed char :0; signed char :0; unsigned long long :0; };
struct BFs0i_BFs0c_BFs0c_BFu0s { signed int :0; signed char :0; signed char :0; unsigned short :0; };
struct BFs0i_BFs0c_BFs0i { signed int :0; signed char :0; signed int :0; };
struct BFs0i_BFs0c_BFs0i_BFs0c { signed int :0; signed char :0; signed int :0; signed char :0; };
struct BFs0i_BFs0c_BFs0i_BFs0i { signed int :0; signed char :0; signed int :0; signed int :0; };
struct BFs0i_BFs0c_BFs0i_BFs0ll { signed int :0; signed char :0; signed int :0; signed long long :0; };
struct BFs0i_BFs0c_BFs0i_BFs0s { signed int :0; signed char :0; signed int :0; signed short :0; };
struct BFs0i_BFs0c_BFs0i_BFu0c { signed int :0; signed char :0; signed int :0; unsigned char :0; };
struct BFs0i_BFs0c_BFs0i_BFu0i { signed int :0; signed char :0; signed int :0; unsigned int :0; };
struct BFs0i_BFs0c_BFs0i_BFu0ll { signed int :0; signed char :0; signed int :0; unsigned long long :0; };
struct BFs0i_BFs0c_BFs0i_BFu0s { signed int :0; signed char :0; signed int :0; unsigned short :0; };
struct BFs0i_BFs0c_BFs0ll { signed int :0; signed char :0; signed long long :0; };
struct BFs0i_BFs0c_BFs0ll_BFs0c { signed int :0; signed char :0; signed long long :0; signed char :0; };
struct BFs0i_BFs0c_BFs0ll_BFs0i { signed int :0; signed char :0; signed long long :0; signed int :0; };
struct BFs0i_BFs0c_BFs0ll_BFs0ll { signed int :0; signed char :0; signed long long :0; signed long long :0; };
struct BFs0i_BFs0c_BFs0ll_BFs0s { signed int :0; signed char :0; signed long long :0; signed short :0; };
struct BFs0i_BFs0c_BFs0ll_BFu0c { signed int :0; signed char :0; signed long long :0; unsigned char :0; };
struct BFs0i_BFs0c_BFs0ll_BFu0i { signed int :0; signed char :0; signed long long :0; unsigned int :0; };
struct BFs0i_BFs0c_BFs0ll_BFu0ll { signed int :0; signed char :0; signed long long :0; unsigned long long :0; };
struct BFs0i_BFs0c_BFs0ll_BFu0s { signed int :0; signed char :0; signed long long :0; unsigned short :0; };
struct BFs0i_BFs0c_BFs0s { signed int :0; signed char :0; signed short :0; };
struct BFs0i_BFs0c_BFs0s_BFs0c { signed int :0; signed char :0; signed short :0; signed char :0; };
struct BFs0i_BFs0c_BFs0s_BFs0i { signed int :0; signed char :0; signed short :0; signed int :0; };
struct BFs0i_BFs0c_BFs0s_BFs0ll { signed int :0; signed char :0; signed short :0; signed long long :0; };
struct BFs0i_BFs0c_BFs0s_BFs0s { signed int :0; signed char :0; signed short :0; signed short :0; };
struct BFs0i_BFs0c_BFs0s_BFu0c { signed int :0; signed char :0; signed short :0; unsigned char :0; };
struct BFs0i_BFs0c_BFs0s_BFu0i { signed int :0; signed char :0; signed short :0; unsigned int :0; };
struct BFs0i_BFs0c_BFs0s_BFu0ll { signed int :0; signed char :0; signed short :0; unsigned long long :0; };
struct BFs0i_BFs0c_BFs0s_BFu0s { signed int :0; signed char :0; signed short :0; unsigned short :0; };
struct BFs0i_BFs0c_BFu0c { signed int :0; signed char :0; unsigned char :0; };
struct BFs0i_BFs0c_BFu0c_BFs0c { signed int :0; signed char :0; unsigned char :0; signed char :0; };
struct BFs0i_BFs0c_BFu0c_BFs0i { signed int :0; signed char :0; unsigned char :0; signed int :0; };
struct BFs0i_BFs0c_BFu0c_BFs0ll { signed int :0; signed char :0; unsigned char :0; signed long long :0; };
struct BFs0i_BFs0c_BFu0c_BFs0s { signed int :0; signed char :0; unsigned char :0; signed short :0; };
struct BFs0i_BFs0c_BFu0c_BFu0c { signed int :0; signed char :0; unsigned char :0; unsigned char :0; };
struct BFs0i_BFs0c_BFu0c_BFu0i { signed int :0; signed char :0; unsigned char :0; unsigned int :0; };
struct BFs0i_BFs0c_BFu0c_BFu0ll { signed int :0; signed char :0; unsigned char :0; unsigned long long :0; };
struct BFs0i_BFs0c_BFu0c_BFu0s { signed int :0; signed char :0; unsigned char :0; unsigned short :0; };
struct BFs0i_BFs0c_BFu0i { signed int :0; signed char :0; unsigned int :0; };
struct BFs0i_BFs0c_BFu0i_BFs0c { signed int :0; signed char :0; unsigned int :0; signed char :0; };
struct BFs0i_BFs0c_BFu0i_BFs0i { signed int :0; signed char :0; unsigned int :0; signed int :0; };
struct BFs0i_BFs0c_BFu0i_BFs0ll { signed int :0; signed char :0; unsigned int :0; signed long long :0; };
struct BFs0i_BFs0c_BFu0i_BFs0s { signed int :0; signed char :0; unsigned int :0; signed short :0; };
struct BFs0i_BFs0c_BFu0i_BFu0c { signed int :0; signed char :0; unsigned int :0; unsigned char :0; };
struct BFs0i_BFs0c_BFu0i_BFu0i { signed int :0; signed char :0; unsigned int :0; unsigned int :0; };
struct BFs0i_BFs0c_BFu0i_BFu0ll { signed int :0; signed char :0; unsigned int :0; unsigned long long :0; };
struct BFs0i_BFs0c_BFu0i_BFu0s { signed int :0; signed char :0; unsigned int :0; unsigned short :0; };
struct BFs0i_BFs0c_BFu0ll { signed int :0; signed char :0; unsigned long long :0; };
struct BFs0i_BFs0c_BFu0ll_BFs0c { signed int :0; signed char :0; unsigned long long :0; signed char :0; };
struct BFs0i_BFs0c_BFu0ll_BFs0i { signed int :0; signed char :0; unsigned long long :0; signed int :0; };
struct BFs0i_BFs0c_BFu0ll_BFs0ll { signed int :0; signed char :0; unsigned long long :0; signed long long :0; };
struct BFs0i_BFs0c_BFu0ll_BFs0s { signed int :0; signed char :0; unsigned long long :0; signed short :0; };
struct BFs0i_BFs0c_BFu0ll_BFu0c { signed int :0; signed char :0; unsigned long long :0; unsigned char :0; };
struct BFs0i_BFs0c_BFu0ll_BFu0i { signed int :0; signed char :0; unsigned long long :0; unsigned int :0; };
struct BFs0i_BFs0c_BFu0ll_BFu0ll { signed int :0; signed char :0; unsigned long long :0; unsigned long long :0; };
struct BFs0i_BFs0c_BFu0ll_BFu0s { signed int :0; signed char :0; unsigned long long :0; unsigned short :0; };
struct BFs0i_BFs0c_BFu0s { signed int :0; signed char :0; unsigned short :0; };
struct BFs0i_BFs0c_BFu0s_BFs0c { signed int :0; signed char :0; unsigned short :0; signed char :0; };
struct BFs0i_BFs0c_BFu0s_BFs0i { signed int :0; signed char :0; unsigned short :0; signed int :0; };
struct BFs0i_BFs0c_BFu0s_BFs0ll { signed int :0; signed char :0; unsigned short :0; signed long long :0; };
struct BFs0i_BFs0c_BFu0s_BFs0s { signed int :0; signed char :0; unsigned short :0; signed short :0; };
struct BFs0i_BFs0c_BFu0s_BFu0c { signed int :0; signed char :0; unsigned short :0; unsigned char :0; };
struct BFs0i_BFs0c_BFu0s_BFu0i { signed int :0; signed char :0; unsigned short :0; unsigned int :0; };
struct BFs0i_BFs0c_BFu0s_BFu0ll { signed int :0; signed char :0; unsigned short :0; unsigned long long :0; };
struct BFs0i_BFs0c_BFu0s_BFu0s { signed int :0; signed char :0; unsigned short :0; unsigned short :0; };
struct BFs0i_BFs0i { signed int :0; signed int :0; };
struct BFs0i_BFs0i_BFs0c { signed int :0; signed int :0; signed char :0; };
struct BFs0i_BFs0i_BFs0c_BFs0c { signed int :0; signed int :0; signed char :0; signed char :0; };
struct BFs0i_BFs0i_BFs0c_BFs0i { signed int :0; signed int :0; signed char :0; signed int :0; };
struct BFs0i_BFs0i_BFs0c_BFs0ll { signed int :0; signed int :0; signed char :0; signed long long :0; };
struct BFs0i_BFs0i_BFs0c_BFs0s { signed int :0; signed int :0; signed char :0; signed short :0; };
struct BFs0i_BFs0i_BFs0c_BFu0c { signed int :0; signed int :0; signed char :0; unsigned char :0; };
struct BFs0i_BFs0i_BFs0c_BFu0i { signed int :0; signed int :0; signed char :0; unsigned int :0; };
struct BFs0i_BFs0i_BFs0c_BFu0ll { signed int :0; signed int :0; signed char :0; unsigned long long :0; };
struct BFs0i_BFs0i_BFs0c_BFu0s { signed int :0; signed int :0; signed char :0; unsigned short :0; };
struct BFs0i_BFs0i_BFs0i { signed int :0; signed int :0; signed int :0; };
struct BFs0i_BFs0i_BFs0i_BFs0c { signed int :0; signed int :0; signed int :0; signed char :0; };
struct BFs0i_BFs0i_BFs0i_BFs0i { signed int :0; signed int :0; signed int :0; signed int :0; };
struct BFs0i_BFs0i_BFs0i_BFs0ll { signed int :0; signed int :0; signed int :0; signed long long :0; };
struct BFs0i_BFs0i_BFs0i_BFs0s { signed int :0; signed int :0; signed int :0; signed short :0; };
struct BFs0i_BFs0i_BFs0i_BFu0c { signed int :0; signed int :0; signed int :0; unsigned char :0; };
struct BFs0i_BFs0i_BFs0i_BFu0i { signed int :0; signed int :0; signed int :0; unsigned int :0; };
struct BFs0i_BFs0i_BFs0i_BFu0ll { signed int :0; signed int :0; signed int :0; unsigned long long :0; };
struct BFs0i_BFs0i_BFs0i_BFu0s { signed int :0; signed int :0; signed int :0; unsigned short :0; };
struct BFs0i_BFs0i_BFs0ll { signed int :0; signed int :0; signed long long :0; };
struct BFs0i_BFs0i_BFs0ll_BFs0c { signed int :0; signed int :0; signed long long :0; signed char :0; };
struct BFs0i_BFs0i_BFs0ll_BFs0i { signed int :0; signed int :0; signed long long :0; signed int :0; };
struct BFs0i_BFs0i_BFs0ll_BFs0ll { signed int :0; signed int :0; signed long long :0; signed long long :0; };
struct BFs0i_BFs0i_BFs0ll_BFs0s { signed int :0; signed int :0; signed long long :0; signed short :0; };
struct BFs0i_BFs0i_BFs0ll_BFu0c { signed int :0; signed int :0; signed long long :0; unsigned char :0; };
struct BFs0i_BFs0i_BFs0ll_BFu0i { signed int :0; signed int :0; signed long long :0; unsigned int :0; };
struct BFs0i_BFs0i_BFs0ll_BFu0ll { signed int :0; signed int :0; signed long long :0; unsigned long long :0; };
struct BFs0i_BFs0i_BFs0ll_BFu0s { signed int :0; signed int :0; signed long long :0; unsigned short :0; };
struct BFs0i_BFs0i_BFs0s { signed int :0; signed int :0; signed short :0; };
struct BFs0i_BFs0i_BFs0s_BFs0c { signed int :0; signed int :0; signed short :0; signed char :0; };
struct BFs0i_BFs0i_BFs0s_BFs0i { signed int :0; signed int :0; signed short :0; signed int :0; };
struct BFs0i_BFs0i_BFs0s_BFs0ll { signed int :0; signed int :0; signed short :0; signed long long :0; };
struct BFs0i_BFs0i_BFs0s_BFs0s { signed int :0; signed int :0; signed short :0; signed short :0; };
struct BFs0i_BFs0i_BFs0s_BFu0c { signed int :0; signed int :0; signed short :0; unsigned char :0; };
struct BFs0i_BFs0i_BFs0s_BFu0i { signed int :0; signed int :0; signed short :0; unsigned int :0; };
struct BFs0i_BFs0i_BFs0s_BFu0ll { signed int :0; signed int :0; signed short :0; unsigned long long :0; };
struct BFs0i_BFs0i_BFs0s_BFu0s { signed int :0; signed int :0; signed short :0; unsigned short :0; };
struct BFs0i_BFs0i_BFu0c { signed int :0; signed int :0; unsigned char :0; };
struct BFs0i_BFs0i_BFu0c_BFs0c { signed int :0; signed int :0; unsigned char :0; signed char :0; };
struct BFs0i_BFs0i_BFu0c_BFs0i { signed int :0; signed int :0; unsigned char :0; signed int :0; };
struct BFs0i_BFs0i_BFu0c_BFs0ll { signed int :0; signed int :0; unsigned char :0; signed long long :0; };
struct BFs0i_BFs0i_BFu0c_BFs0s { signed int :0; signed int :0; unsigned char :0; signed short :0; };
struct BFs0i_BFs0i_BFu0c_BFu0c { signed int :0; signed int :0; unsigned char :0; unsigned char :0; };
struct BFs0i_BFs0i_BFu0c_BFu0i { signed int :0; signed int :0; unsigned char :0; unsigned int :0; };
struct BFs0i_BFs0i_BFu0c_BFu0ll { signed int :0; signed int :0; unsigned char :0; unsigned long long :0; };
struct BFs0i_BFs0i_BFu0c_BFu0s { signed int :0; signed int :0; unsigned char :0; unsigned short :0; };
struct BFs0i_BFs0i_BFu0i { signed int :0; signed int :0; unsigned int :0; };
struct BFs0i_BFs0i_BFu0i_BFs0c { signed int :0; signed int :0; unsigned int :0; signed char :0; };
struct BFs0i_BFs0i_BFu0i_BFs0i { signed int :0; signed int :0; unsigned int :0; signed int :0; };
struct BFs0i_BFs0i_BFu0i_BFs0ll { signed int :0; signed int :0; unsigned int :0; signed long long :0; };
struct BFs0i_BFs0i_BFu0i_BFs0s { signed int :0; signed int :0; unsigned int :0; signed short :0; };
struct BFs0i_BFs0i_BFu0i_BFu0c { signed int :0; signed int :0; unsigned int :0; unsigned char :0; };
struct BFs0i_BFs0i_BFu0i_BFu0i { signed int :0; signed int :0; unsigned int :0; unsigned int :0; };
struct BFs0i_BFs0i_BFu0i_BFu0ll { signed int :0; signed int :0; unsigned int :0; unsigned long long :0; };
struct BFs0i_BFs0i_BFu0i_BFu0s { signed int :0; signed int :0; unsigned int :0; unsigned short :0; };
struct BFs0i_BFs0i_BFu0ll { signed int :0; signed int :0; unsigned long long :0; };
struct BFs0i_BFs0i_BFu0ll_BFs0c { signed int :0; signed int :0; unsigned long long :0; signed char :0; };
struct BFs0i_BFs0i_BFu0ll_BFs0i { signed int :0; signed int :0; unsigned long long :0; signed int :0; };
struct BFs0i_BFs0i_BFu0ll_BFs0ll { signed int :0; signed int :0; unsigned long long :0; signed long long :0; };
struct BFs0i_BFs0i_BFu0ll_BFs0s { signed int :0; signed int :0; unsigned long long :0; signed short :0; };
struct BFs0i_BFs0i_BFu0ll_BFu0c { signed int :0; signed int :0; unsigned long long :0; unsigned char :0; };
struct BFs0i_BFs0i_BFu0ll_BFu0i { signed int :0; signed int :0; unsigned long long :0; unsigned int :0; };
struct BFs0i_BFs0i_BFu0ll_BFu0ll { signed int :0; signed int :0; unsigned long long :0; unsigned long long :0; };
struct BFs0i_BFs0i_BFu0ll_BFu0s { signed int :0; signed int :0; unsigned long long :0; unsigned short :0; };
struct BFs0i_BFs0i_BFu0s { signed int :0; signed int :0; unsigned short :0; };
struct BFs0i_BFs0i_BFu0s_BFs0c { signed int :0; signed int :0; unsigned short :0; signed char :0; };
struct BFs0i_BFs0i_BFu0s_BFs0i { signed int :0; signed int :0; unsigned short :0; signed int :0; };
struct BFs0i_BFs0i_BFu0s_BFs0ll { signed int :0; signed int :0; unsigned short :0; signed long long :0; };
struct BFs0i_BFs0i_BFu0s_BFs0s { signed int :0; signed int :0; unsigned short :0; signed short :0; };
struct BFs0i_BFs0i_BFu0s_BFu0c { signed int :0; signed int :0; unsigned short :0; unsigned char :0; };
struct BFs0i_BFs0i_BFu0s_BFu0i { signed int :0; signed int :0; unsigned short :0; unsigned int :0; };
struct BFs0i_BFs0i_BFu0s_BFu0ll { signed int :0; signed int :0; unsigned short :0; unsigned long long :0; };
struct BFs0i_BFs0i_BFu0s_BFu0s { signed int :0; signed int :0; unsigned short :0; unsigned short :0; };
struct BFs0i_BFs0ll { signed int :0; signed long long :0; };
struct BFs0i_BFs0ll_BFs0c { signed int :0; signed long long :0; signed char :0; };
struct BFs0i_BFs0ll_BFs0c_BFs0c { signed int :0; signed long long :0; signed char :0; signed char :0; };
struct BFs0i_BFs0ll_BFs0c_BFs0i { signed int :0; signed long long :0; signed char :0; signed int :0; };
struct BFs0i_BFs0ll_BFs0c_BFs0ll { signed int :0; signed long long :0; signed char :0; signed long long :0; };
struct BFs0i_BFs0ll_BFs0c_BFs0s { signed int :0; signed long long :0; signed char :0; signed short :0; };
struct BFs0i_BFs0ll_BFs0c_BFu0c { signed int :0; signed long long :0; signed char :0; unsigned char :0; };
struct BFs0i_BFs0ll_BFs0c_BFu0i { signed int :0; signed long long :0; signed char :0; unsigned int :0; };
struct BFs0i_BFs0ll_BFs0c_BFu0ll { signed int :0; signed long long :0; signed char :0; unsigned long long :0; };
struct BFs0i_BFs0ll_BFs0c_BFu0s { signed int :0; signed long long :0; signed char :0; unsigned short :0; };
struct BFs0i_BFs0ll_BFs0i { signed int :0; signed long long :0; signed int :0; };
struct BFs0i_BFs0ll_BFs0i_BFs0c { signed int :0; signed long long :0; signed int :0; signed char :0; };
struct BFs0i_BFs0ll_BFs0i_BFs0i { signed int :0; signed long long :0; signed int :0; signed int :0; };
struct BFs0i_BFs0ll_BFs0i_BFs0ll { signed int :0; signed long long :0; signed int :0; signed long long :0; };
struct BFs0i_BFs0ll_BFs0i_BFs0s { signed int :0; signed long long :0; signed int :0; signed short :0; };
struct BFs0i_BFs0ll_BFs0i_BFu0c { signed int :0; signed long long :0; signed int :0; unsigned char :0; };
struct BFs0i_BFs0ll_BFs0i_BFu0i { signed int :0; signed long long :0; signed int :0; unsigned int :0; };
struct BFs0i_BFs0ll_BFs0i_BFu0ll { signed int :0; signed long long :0; signed int :0; unsigned long long :0; };
struct BFs0i_BFs0ll_BFs0i_BFu0s { signed int :0; signed long long :0; signed int :0; unsigned short :0; };
struct BFs0i_BFs0ll_BFs0ll { signed int :0; signed long long :0; signed long long :0; };
struct BFs0i_BFs0ll_BFs0ll_BFs0c { signed int :0; signed long long :0; signed long long :0; signed char :0; };
struct BFs0i_BFs0ll_BFs0ll_BFs0i { signed int :0; signed long long :0; signed long long :0; signed int :0; };
struct BFs0i_BFs0ll_BFs0ll_BFs0ll { signed int :0; signed long long :0; signed long long :0; signed long long :0; };
struct BFs0i_BFs0ll_BFs0ll_BFs0s { signed int :0; signed long long :0; signed long long :0; signed short :0; };
struct BFs0i_BFs0ll_BFs0ll_BFu0c { signed int :0; signed long long :0; signed long long :0; unsigned char :0; };
struct BFs0i_BFs0ll_BFs0ll_BFu0i { signed int :0; signed long long :0; signed long long :0; unsigned int :0; };
struct BFs0i_BFs0ll_BFs0ll_BFu0ll { signed int :0; signed long long :0; signed long long :0; unsigned long long :0; };
struct BFs0i_BFs0ll_BFs0ll_BFu0s { signed int :0; signed long long :0; signed long long :0; unsigned short :0; };
struct BFs0i_BFs0ll_BFs0s { signed int :0; signed long long :0; signed short :0; };
struct BFs0i_BFs0ll_BFs0s_BFs0c { signed int :0; signed long long :0; signed short :0; signed char :0; };
struct BFs0i_BFs0ll_BFs0s_BFs0i { signed int :0; signed long long :0; signed short :0; signed int :0; };
struct BFs0i_BFs0ll_BFs0s_BFs0ll { signed int :0; signed long long :0; signed short :0; signed long long :0; };
struct BFs0i_BFs0ll_BFs0s_BFs0s { signed int :0; signed long long :0; signed short :0; signed short :0; };
struct BFs0i_BFs0ll_BFs0s_BFu0c { signed int :0; signed long long :0; signed short :0; unsigned char :0; };
struct BFs0i_BFs0ll_BFs0s_BFu0i { signed int :0; signed long long :0; signed short :0; unsigned int :0; };
struct BFs0i_BFs0ll_BFs0s_BFu0ll { signed int :0; signed long long :0; signed short :0; unsigned long long :0; };
struct BFs0i_BFs0ll_BFs0s_BFu0s { signed int :0; signed long long :0; signed short :0; unsigned short :0; };
struct BFs0i_BFs0ll_BFu0c { signed int :0; signed long long :0; unsigned char :0; };
struct BFs0i_BFs0ll_BFu0c_BFs0c { signed int :0; signed long long :0; unsigned char :0; signed char :0; };
struct BFs0i_BFs0ll_BFu0c_BFs0i { signed int :0; signed long long :0; unsigned char :0; signed int :0; };
struct BFs0i_BFs0ll_BFu0c_BFs0ll { signed int :0; signed long long :0; unsigned char :0; signed long long :0; };
struct BFs0i_BFs0ll_BFu0c_BFs0s { signed int :0; signed long long :0; unsigned char :0; signed short :0; };
struct BFs0i_BFs0ll_BFu0c_BFu0c { signed int :0; signed long long :0; unsigned char :0; unsigned char :0; };
struct BFs0i_BFs0ll_BFu0c_BFu0i { signed int :0; signed long long :0; unsigned char :0; unsigned int :0; };
struct BFs0i_BFs0ll_BFu0c_BFu0ll { signed int :0; signed long long :0; unsigned char :0; unsigned long long :0; };
struct BFs0i_BFs0ll_BFu0c_BFu0s { signed int :0; signed long long :0; unsigned char :0; unsigned short :0; };
struct BFs0i_BFs0ll_BFu0i { signed int :0; signed long long :0; unsigned int :0; };
struct BFs0i_BFs0ll_BFu0i_BFs0c { signed int :0; signed long long :0; unsigned int :0; signed char :0; };
struct BFs0i_BFs0ll_BFu0i_BFs0i { signed int :0; signed long long :0; unsigned int :0; signed int :0; };
struct BFs0i_BFs0ll_BFu0i_BFs0ll { signed int :0; signed long long :0; unsigned int :0; signed long long :0; };
struct BFs0i_BFs0ll_BFu0i_BFs0s { signed int :0; signed long long :0; unsigned int :0; signed short :0; };
struct BFs0i_BFs0ll_BFu0i_BFu0c { signed int :0; signed long long :0; unsigned int :0; unsigned char :0; };
struct BFs0i_BFs0ll_BFu0i_BFu0i { signed int :0; signed long long :0; unsigned int :0; unsigned int :0; };
struct BFs0i_BFs0ll_BFu0i_BFu0ll { signed int :0; signed long long :0; unsigned int :0; unsigned long long :0; };
struct BFs0i_BFs0ll_BFu0i_BFu0s { signed int :0; signed long long :0; unsigned int :0; unsigned short :0; };
struct BFs0i_BFs0ll_BFu0ll { signed int :0; signed long long :0; unsigned long long :0; };
struct BFs0i_BFs0ll_BFu0ll_BFs0c { signed int :0; signed long long :0; unsigned long long :0; signed char :0; };
struct BFs0i_BFs0ll_BFu0ll_BFs0i { signed int :0; signed long long :0; unsigned long long :0; signed int :0; };
struct BFs0i_BFs0ll_BFu0ll_BFs0ll { signed int :0; signed long long :0; unsigned long long :0; signed long long :0; };
struct BFs0i_BFs0ll_BFu0ll_BFs0s { signed int :0; signed long long :0; unsigned long long :0; signed short :0; };
struct BFs0i_BFs0ll_BFu0ll_BFu0c { signed int :0; signed long long :0; unsigned long long :0; unsigned char :0; };
struct BFs0i_BFs0ll_BFu0ll_BFu0i { signed int :0; signed long long :0; unsigned long long :0; unsigned int :0; };
struct BFs0i_BFs0ll_BFu0ll_BFu0ll { signed int :0; signed long long :0; unsigned long long :0; unsigned long long :0; };
struct BFs0i_BFs0ll_BFu0ll_BFu0s { signed int :0; signed long long :0; unsigned long long :0; unsigned short :0; };
struct BFs0i_BFs0ll_BFu0s { signed int :0; signed long long :0; unsigned short :0; };
struct BFs0i_BFs0ll_BFu0s_BFs0c { signed int :0; signed long long :0; unsigned short :0; signed char :0; };
struct BFs0i_BFs0ll_BFu0s_BFs0i { signed int :0; signed long long :0; unsigned short :0; signed int :0; };
struct BFs0i_BFs0ll_BFu0s_BFs0ll { signed int :0; signed long long :0; unsigned short :0; signed long long :0; };
struct BFs0i_BFs0ll_BFu0s_BFs0s { signed int :0; signed long long :0; unsigned short :0; signed short :0; };
struct BFs0i_BFs0ll_BFu0s_BFu0c { signed int :0; signed long long :0; unsigned short :0; unsigned char :0; };
struct BFs0i_BFs0ll_BFu0s_BFu0i { signed int :0; signed long long :0; unsigned short :0; unsigned int :0; };
struct BFs0i_BFs0ll_BFu0s_BFu0ll { signed int :0; signed long long :0; unsigned short :0; unsigned long long :0; };
struct BFs0i_BFs0ll_BFu0s_BFu0s { signed int :0; signed long long :0; unsigned short :0; unsigned short :0; };
struct BFs0i_BFs0s { signed int :0; signed short :0; };
struct BFs0i_BFs0s_BFs0c { signed int :0; signed short :0; signed char :0; };
struct BFs0i_BFs0s_BFs0c_BFs0c { signed int :0; signed short :0; signed char :0; signed char :0; };
struct BFs0i_BFs0s_BFs0c_BFs0i { signed int :0; signed short :0; signed char :0; signed int :0; };
struct BFs0i_BFs0s_BFs0c_BFs0ll { signed int :0; signed short :0; signed char :0; signed long long :0; };
struct BFs0i_BFs0s_BFs0c_BFs0s { signed int :0; signed short :0; signed char :0; signed short :0; };
struct BFs0i_BFs0s_BFs0c_BFu0c { signed int :0; signed short :0; signed char :0; unsigned char :0; };
struct BFs0i_BFs0s_BFs0c_BFu0i { signed int :0; signed short :0; signed char :0; unsigned int :0; };
struct BFs0i_BFs0s_BFs0c_BFu0ll { signed int :0; signed short :0; signed char :0; unsigned long long :0; };
struct BFs0i_BFs0s_BFs0c_BFu0s { signed int :0; signed short :0; signed char :0; unsigned short :0; };
struct BFs0i_BFs0s_BFs0i { signed int :0; signed short :0; signed int :0; };
struct BFs0i_BFs0s_BFs0i_BFs0c { signed int :0; signed short :0; signed int :0; signed char :0; };
struct BFs0i_BFs0s_BFs0i_BFs0i { signed int :0; signed short :0; signed int :0; signed int :0; };
struct BFs0i_BFs0s_BFs0i_BFs0ll { signed int :0; signed short :0; signed int :0; signed long long :0; };
struct BFs0i_BFs0s_BFs0i_BFs0s { signed int :0; signed short :0; signed int :0; signed short :0; };
struct BFs0i_BFs0s_BFs0i_BFu0c { signed int :0; signed short :0; signed int :0; unsigned char :0; };
struct BFs0i_BFs0s_BFs0i_BFu0i { signed int :0; signed short :0; signed int :0; unsigned int :0; };
struct BFs0i_BFs0s_BFs0i_BFu0ll { signed int :0; signed short :0; signed int :0; unsigned long long :0; };
struct BFs0i_BFs0s_BFs0i_BFu0s { signed int :0; signed short :0; signed int :0; unsigned short :0; };
struct BFs0i_BFs0s_BFs0ll { signed int :0; signed short :0; signed long long :0; };
struct BFs0i_BFs0s_BFs0ll_BFs0c { signed int :0; signed short :0; signed long long :0; signed char :0; };
struct BFs0i_BFs0s_BFs0ll_BFs0i { signed int :0; signed short :0; signed long long :0; signed int :0; };
struct BFs0i_BFs0s_BFs0ll_BFs0ll { signed int :0; signed short :0; signed long long :0; signed long long :0; };
struct BFs0i_BFs0s_BFs0ll_BFs0s { signed int :0; signed short :0; signed long long :0; signed short :0; };
struct BFs0i_BFs0s_BFs0ll_BFu0c { signed int :0; signed short :0; signed long long :0; unsigned char :0; };
struct BFs0i_BFs0s_BFs0ll_BFu0i { signed int :0; signed short :0; signed long long :0; unsigned int :0; };
struct BFs0i_BFs0s_BFs0ll_BFu0ll { signed int :0; signed short :0; signed long long :0; unsigned long long :0; };
struct BFs0i_BFs0s_BFs0ll_BFu0s { signed int :0; signed short :0; signed long long :0; unsigned short :0; };
struct BFs0i_BFs0s_BFs0s { signed int :0; signed short :0; signed short :0; };
struct BFs0i_BFs0s_BFs0s_BFs0c { signed int :0; signed short :0; signed short :0; signed char :0; };
struct BFs0i_BFs0s_BFs0s_BFs0i { signed int :0; signed short :0; signed short :0; signed int :0; };
struct BFs0i_BFs0s_BFs0s_BFs0ll { signed int :0; signed short :0; signed short :0; signed long long :0; };
struct BFs0i_BFs0s_BFs0s_BFs0s { signed int :0; signed short :0; signed short :0; signed short :0; };
struct BFs0i_BFs0s_BFs0s_BFu0c { signed int :0; signed short :0; signed short :0; unsigned char :0; };
struct BFs0i_BFs0s_BFs0s_BFu0i { signed int :0; signed short :0; signed short :0; unsigned int :0; };
struct BFs0i_BFs0s_BFs0s_BFu0ll { signed int :0; signed short :0; signed short :0; unsigned long long :0; };
struct BFs0i_BFs0s_BFs0s_BFu0s { signed int :0; signed short :0; signed short :0; unsigned short :0; };
struct BFs0i_BFs0s_BFu0c { signed int :0; signed short :0; unsigned char :0; };
struct BFs0i_BFs0s_BFu0c_BFs0c { signed int :0; signed short :0; unsigned char :0; signed char :0; };
struct BFs0i_BFs0s_BFu0c_BFs0i { signed int :0; signed short :0; unsigned char :0; signed int :0; };
struct BFs0i_BFs0s_BFu0c_BFs0ll { signed int :0; signed short :0; unsigned char :0; signed long long :0; };
struct BFs0i_BFs0s_BFu0c_BFs0s { signed int :0; signed short :0; unsigned char :0; signed short :0; };
struct BFs0i_BFs0s_BFu0c_BFu0c { signed int :0; signed short :0; unsigned char :0; unsigned char :0; };
struct BFs0i_BFs0s_BFu0c_BFu0i { signed int :0; signed short :0; unsigned char :0; unsigned int :0; };
struct BFs0i_BFs0s_BFu0c_BFu0ll { signed int :0; signed short :0; unsigned char :0; unsigned long long :0; };
struct BFs0i_BFs0s_BFu0c_BFu0s { signed int :0; signed short :0; unsigned char :0; unsigned short :0; };
struct BFs0i_BFs0s_BFu0i { signed int :0; signed short :0; unsigned int :0; };
struct BFs0i_BFs0s_BFu0i_BFs0c { signed int :0; signed short :0; unsigned int :0; signed char :0; };
struct BFs0i_BFs0s_BFu0i_BFs0i { signed int :0; signed short :0; unsigned int :0; signed int :0; };
struct BFs0i_BFs0s_BFu0i_BFs0ll { signed int :0; signed short :0; unsigned int :0; signed long long :0; };
struct BFs0i_BFs0s_BFu0i_BFs0s { signed int :0; signed short :0; unsigned int :0; signed short :0; };
struct BFs0i_BFs0s_BFu0i_BFu0c { signed int :0; signed short :0; unsigned int :0; unsigned char :0; };
struct BFs0i_BFs0s_BFu0i_BFu0i { signed int :0; signed short :0; unsigned int :0; unsigned int :0; };
struct BFs0i_BFs0s_BFu0i_BFu0ll { signed int :0; signed short :0; unsigned int :0; unsigned long long :0; };
struct BFs0i_BFs0s_BFu0i_BFu0s { signed int :0; signed short :0; unsigned int :0; unsigned short :0; };
struct BFs0i_BFs0s_BFu0ll { signed int :0; signed short :0; unsigned long long :0; };
struct BFs0i_BFs0s_BFu0ll_BFs0c { signed int :0; signed short :0; unsigned long long :0; signed char :0; };
struct BFs0i_BFs0s_BFu0ll_BFs0i { signed int :0; signed short :0; unsigned long long :0; signed int :0; };
struct BFs0i_BFs0s_BFu0ll_BFs0ll { signed int :0; signed short :0; unsigned long long :0; signed long long :0; };
struct BFs0i_BFs0s_BFu0ll_BFs0s { signed int :0; signed short :0; unsigned long long :0; signed short :0; };
struct BFs0i_BFs0s_BFu0ll_BFu0c { signed int :0; signed short :0; unsigned long long :0; unsigned char :0; };
struct BFs0i_BFs0s_BFu0ll_BFu0i { signed int :0; signed short :0; unsigned long long :0; unsigned int :0; };
struct BFs0i_BFs0s_BFu0ll_BFu0ll { signed int :0; signed short :0; unsigned long long :0; unsigned long long :0; };
struct BFs0i_BFs0s_BFu0ll_BFu0s { signed int :0; signed short :0; unsigned long long :0; unsigned short :0; };
struct BFs0i_BFs0s_BFu0s { signed int :0; signed short :0; unsigned short :0; };
struct BFs0i_BFs0s_BFu0s_BFs0c { signed int :0; signed short :0; unsigned short :0; signed char :0; };
struct BFs0i_BFs0s_BFu0s_BFs0i { signed int :0; signed short :0; unsigned short :0; signed int :0; };
struct BFs0i_BFs0s_BFu0s_BFs0ll { signed int :0; signed short :0; unsigned short :0; signed long long :0; };
struct BFs0i_BFs0s_BFu0s_BFs0s { signed int :0; signed short :0; unsigned short :0; signed short :0; };
struct BFs0i_BFs0s_BFu0s_BFu0c { signed int :0; signed short :0; unsigned short :0; unsigned char :0; };
struct BFs0i_BFs0s_BFu0s_BFu0i { signed int :0; signed short :0; unsigned short :0; unsigned int :0; };
struct BFs0i_BFs0s_BFu0s_BFu0ll { signed int :0; signed short :0; unsigned short :0; unsigned long long :0; };
struct BFs0i_BFs0s_BFu0s_BFu0s { signed int :0; signed short :0; unsigned short :0; unsigned short :0; };
struct BFs0i_BFu0c { signed int :0; unsigned char :0; };
struct BFs0i_BFu0c_BFs0c { signed int :0; unsigned char :0; signed char :0; };
struct BFs0i_BFu0c_BFs0c_BFs0c { signed int :0; unsigned char :0; signed char :0; signed char :0; };
struct BFs0i_BFu0c_BFs0c_BFs0i { signed int :0; unsigned char :0; signed char :0; signed int :0; };
struct BFs0i_BFu0c_BFs0c_BFs0ll { signed int :0; unsigned char :0; signed char :0; signed long long :0; };
struct BFs0i_BFu0c_BFs0c_BFs0s { signed int :0; unsigned char :0; signed char :0; signed short :0; };
struct BFs0i_BFu0c_BFs0c_BFu0c { signed int :0; unsigned char :0; signed char :0; unsigned char :0; };
struct BFs0i_BFu0c_BFs0c_BFu0i { signed int :0; unsigned char :0; signed char :0; unsigned int :0; };
#endif // __cplusplus
#ifdef __cplusplus


static void Test_aL_BFu8c_BFu0c()
{
  {
    init_simple_test("aL_BFu8c_BFu0c");
    static aL_BFu8c_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aL_BFu8c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8c_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_BFu8c_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8c_BFu0c");
  }
}
static Arrange_To_Call_Me vaL_BFu8c_BFu0c(Test_aL_BFu8c_BFu0c, "aL_BFu8c_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8c_BFu0i()
{
  {
    init_simple_test("aL_BFu8c_BFu0i");
    static aL_BFu8c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aL_BFu8c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8c_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_BFu8c_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8c_BFu0i");
  }
}
static Arrange_To_Call_Me vaL_BFu8c_BFu0i(Test_aL_BFu8c_BFu0i, "aL_BFu8c_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8c_BFu0ll()
{
  {
    init_simple_test("aL_BFu8c_BFu0ll");
    static aL_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_BFu8c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_BFu8c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8c_BFu0ll");
  }
}
static Arrange_To_Call_Me vaL_BFu8c_BFu0ll(Test_aL_BFu8c_BFu0ll, "aL_BFu8c_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8c_BFu0s()
{
  {
    init_simple_test("aL_BFu8c_BFu0s");
    static aL_BFu8c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aL_BFu8c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8c_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_BFu8c_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8c_BFu0s");
  }
}
static Arrange_To_Call_Me vaL_BFu8c_BFu0s(Test_aL_BFu8c_BFu0s, "aL_BFu8c_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8i_BFu0c()
{
  {
    init_simple_test("aL_BFu8i_BFu0c");
    static aL_BFu8i_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aL_BFu8i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8i_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_BFu8i_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8i_BFu0c");
  }
}
static Arrange_To_Call_Me vaL_BFu8i_BFu0c(Test_aL_BFu8i_BFu0c, "aL_BFu8i_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8i_BFu0i()
{
  {
    init_simple_test("aL_BFu8i_BFu0i");
    static aL_BFu8i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aL_BFu8i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8i_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_BFu8i_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8i_BFu0i");
  }
}
static Arrange_To_Call_Me vaL_BFu8i_BFu0i(Test_aL_BFu8i_BFu0i, "aL_BFu8i_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8i_BFu0ll()
{
  {
    init_simple_test("aL_BFu8i_BFu0ll");
    static aL_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_BFu8i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_BFu8i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaL_BFu8i_BFu0ll(Test_aL_BFu8i_BFu0ll, "aL_BFu8i_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8i_BFu0s()
{
  {
    init_simple_test("aL_BFu8i_BFu0s");
    static aL_BFu8i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aL_BFu8i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8i_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_BFu8i_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8i_BFu0s");
  }
}
static Arrange_To_Call_Me vaL_BFu8i_BFu0s(Test_aL_BFu8i_BFu0s, "aL_BFu8i_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8ll_BFu0c()
{
  {
    init_simple_test("aL_BFu8ll_BFu0c");
    static aL_BFu8ll_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aL_BFu8ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_BFu8ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaL_BFu8ll_BFu0c(Test_aL_BFu8ll_BFu0c, "aL_BFu8ll_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8ll_BFu0i()
{
  {
    init_simple_test("aL_BFu8ll_BFu0i");
    static aL_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aL_BFu8ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_BFu8ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaL_BFu8ll_BFu0i(Test_aL_BFu8ll_BFu0i, "aL_BFu8ll_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8ll_BFu0ll()
{
  {
    init_simple_test("aL_BFu8ll_BFu0ll");
    static aL_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_BFu8ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaL_BFu8ll_BFu0ll(Test_aL_BFu8ll_BFu0ll, "aL_BFu8ll_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8ll_BFu0s()
{
  {
    init_simple_test("aL_BFu8ll_BFu0s");
    static aL_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aL_BFu8ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_BFu8ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaL_BFu8ll_BFu0s(Test_aL_BFu8ll_BFu0s, "aL_BFu8ll_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8s_BFu0c()
{
  {
    init_simple_test("aL_BFu8s_BFu0c");
    static aL_BFu8s_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aL_BFu8s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8s_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_BFu8s_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8s_BFu0c");
  }
}
static Arrange_To_Call_Me vaL_BFu8s_BFu0c(Test_aL_BFu8s_BFu0c, "aL_BFu8s_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8s_BFu0i()
{
  {
    init_simple_test("aL_BFu8s_BFu0i");
    static aL_BFu8s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aL_BFu8s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8s_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_BFu8s_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8s_BFu0i");
  }
}
static Arrange_To_Call_Me vaL_BFu8s_BFu0i(Test_aL_BFu8s_BFu0i, "aL_BFu8s_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8s_BFu0ll()
{
  {
    init_simple_test("aL_BFu8s_BFu0ll");
    static aL_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_BFu8s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_BFu8s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaL_BFu8s_BFu0ll(Test_aL_BFu8s_BFu0ll, "aL_BFu8s_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu8s_BFu0s()
{
  {
    init_simple_test("aL_BFu8s_BFu0s");
    static aL_BFu8s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aL_BFu8s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu8s_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_BFu8s_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aL_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aL_BFu8s_BFu0s");
  }
}
static Arrange_To_Call_Me vaL_BFu8s_BFu0s(Test_aL_BFu8s_BFu0s, "aL_BFu8s_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu9i_BFu0c()
{
  {
    init_simple_test("aL_BFu9i_BFu0c");
    static aL_BFu9i_BFu0c lv;
    check2(sizeof(lv), 10, "sizeof(aL_BFu9i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu9i_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_BFu9i_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aL_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aL_BFu9i_BFu0c");
  }
}
static Arrange_To_Call_Me vaL_BFu9i_BFu0c(Test_aL_BFu9i_BFu0c, "aL_BFu9i_BFu0c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu9i_BFu0i()
{
  {
    init_simple_test("aL_BFu9i_BFu0i");
    static aL_BFu9i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aL_BFu9i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu9i_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_BFu9i_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aL_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aL_BFu9i_BFu0i");
  }
}
static Arrange_To_Call_Me vaL_BFu9i_BFu0i(Test_aL_BFu9i_BFu0i, "aL_BFu9i_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu9i_BFu0ll()
{
  {
    init_simple_test("aL_BFu9i_BFu0ll");
    static aL_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_BFu9i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu9i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_BFu9i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aL_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aL_BFu9i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaL_BFu9i_BFu0ll(Test_aL_BFu9i_BFu0ll, "aL_BFu9i_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu9i_BFu0s()
{
  {
    init_simple_test("aL_BFu9i_BFu0s");
    static aL_BFu9i_BFu0s lv;
    check2(sizeof(lv), 10, "sizeof(aL_BFu9i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu9i_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_BFu9i_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aL_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aL_BFu9i_BFu0s");
  }
}
static Arrange_To_Call_Me vaL_BFu9i_BFu0s(Test_aL_BFu9i_BFu0s, "aL_BFu9i_BFu0s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu9ll_BFu0c()
{
  {
    init_simple_test("aL_BFu9ll_BFu0c");
    static aL_BFu9ll_BFu0c lv;
    check2(sizeof(lv), 10, "sizeof(aL_BFu9ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu9ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_BFu9ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aL_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aL_BFu9ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaL_BFu9ll_BFu0c(Test_aL_BFu9ll_BFu0c, "aL_BFu9ll_BFu0c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu9ll_BFu0i()
{
  {
    init_simple_test("aL_BFu9ll_BFu0i");
    static aL_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aL_BFu9ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu9ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_BFu9ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aL_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aL_BFu9ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaL_BFu9ll_BFu0i(Test_aL_BFu9ll_BFu0i, "aL_BFu9ll_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu9ll_BFu0ll()
{
  {
    init_simple_test("aL_BFu9ll_BFu0ll");
    static aL_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu9ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_BFu9ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aL_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aL_BFu9ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaL_BFu9ll_BFu0ll(Test_aL_BFu9ll_BFu0ll, "aL_BFu9ll_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu9ll_BFu0s()
{
  {
    init_simple_test("aL_BFu9ll_BFu0s");
    static aL_BFu9ll_BFu0s lv;
    check2(sizeof(lv), 10, "sizeof(aL_BFu9ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu9ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_BFu9ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aL_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aL_BFu9ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaL_BFu9ll_BFu0s(Test_aL_BFu9ll_BFu0s, "aL_BFu9ll_BFu0s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu9s_BFu0c()
{
  {
    init_simple_test("aL_BFu9s_BFu0c");
    static aL_BFu9s_BFu0c lv;
    check2(sizeof(lv), 10, "sizeof(aL_BFu9s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu9s_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_BFu9s_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aL_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aL_BFu9s_BFu0c");
  }
}
static Arrange_To_Call_Me vaL_BFu9s_BFu0c(Test_aL_BFu9s_BFu0c, "aL_BFu9s_BFu0c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu9s_BFu0i()
{
  {
    init_simple_test("aL_BFu9s_BFu0i");
    static aL_BFu9s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aL_BFu9s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu9s_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_BFu9s_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aL_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aL_BFu9s_BFu0i");
  }
}
static Arrange_To_Call_Me vaL_BFu9s_BFu0i(Test_aL_BFu9s_BFu0i, "aL_BFu9s_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu9s_BFu0ll()
{
  {
    init_simple_test("aL_BFu9s_BFu0ll");
    static aL_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_BFu9s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu9s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_BFu9s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aL_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aL_BFu9s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaL_BFu9s_BFu0ll(Test_aL_BFu9s_BFu0ll, "aL_BFu9s_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_BFu9s_BFu0s()
{
  {
    init_simple_test("aL_BFu9s_BFu0s");
    static aL_BFu9s_BFu0s lv;
    check2(sizeof(lv), 10, "sizeof(aL_BFu9s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu9s_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_BFu9s_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aL_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aL_BFu9s_BFu0s");
  }
}
static Arrange_To_Call_Me vaL_BFu9s_BFu0s(Test_aL_BFu9s_BFu0s, "aL_BFu9s_BFu0s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_C_BFu0c()
{
  {
    init_simple_test("aL_C_BFu0c");
    static aL_C_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aL_C_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_C_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_C_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_C_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaL_C_BFu0c(Test_aL_C_BFu0c, "aL_C_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_C_BFu0i()
{
  {
    init_simple_test("aL_C_BFu0i");
    static aL_C_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aL_C_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_C_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_C_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_C_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaL_C_BFu0i(Test_aL_C_BFu0i, "aL_C_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_C_BFu0ll()
{
  {
    init_simple_test("aL_C_BFu0ll");
    static aL_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_C_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_C_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_C_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_C_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaL_C_BFu0ll(Test_aL_C_BFu0ll, "aL_C_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_C_BFu0s()
{
  {
    init_simple_test("aL_C_BFu0s");
    static aL_C_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aL_C_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_C_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_C_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_C_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaL_C_BFu0s(Test_aL_C_BFu0s, "aL_C_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_D_BFu0c()
{
  {
    init_simple_test("aL_D_BFu0c");
    static aL_D_BFu0c lv;
    check2(sizeof(lv), 16, "sizeof(aL_D_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_D_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_D_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_D_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaL_D_BFu0c(Test_aL_D_BFu0c, "aL_D_BFu0c", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_D_BFu0i()
{
  {
    init_simple_test("aL_D_BFu0i");
    static aL_D_BFu0i lv;
    check2(sizeof(lv), 16, "sizeof(aL_D_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_D_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_D_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_D_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaL_D_BFu0i(Test_aL_D_BFu0i, "aL_D_BFu0i", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_D_BFu0ll()
{
  {
    init_simple_test("aL_D_BFu0ll");
    static aL_D_BFu0ll lv;
    check2(sizeof(lv), 16, "sizeof(aL_D_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_D_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_D_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaL_D_BFu0ll(Test_aL_D_BFu0ll, "aL_D_BFu0ll", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_D_BFu0s()
{
  {
    init_simple_test("aL_D_BFu0s");
    static aL_D_BFu0s lv;
    check2(sizeof(lv), 16, "sizeof(aL_D_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_D_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_D_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_D_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaL_D_BFu0s(Test_aL_D_BFu0s, "aL_D_BFu0s", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_F_BFu0c()
{
  {
    init_simple_test("aL_F_BFu0c");
    static aL_F_BFu0c lv;
    check2(sizeof(lv), 12, "sizeof(aL_F_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_F_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_F_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_F_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaL_F_BFu0c(Test_aL_F_BFu0c, "aL_F_BFu0c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_F_BFu0i()
{
  {
    init_simple_test("aL_F_BFu0i");
    static aL_F_BFu0i lv;
    check2(sizeof(lv), 12, "sizeof(aL_F_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_F_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_F_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_F_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaL_F_BFu0i(Test_aL_F_BFu0i, "aL_F_BFu0i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_F_BFu0ll()
{
  {
    init_simple_test("aL_F_BFu0ll");
    static aL_F_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_F_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_F_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_F_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaL_F_BFu0ll(Test_aL_F_BFu0ll, "aL_F_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_F_BFu0s()
{
  {
    init_simple_test("aL_F_BFu0s");
    static aL_F_BFu0s lv;
    check2(sizeof(lv), 12, "sizeof(aL_F_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_F_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_F_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_F_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaL_F_BFu0s(Test_aL_F_BFu0s, "aL_F_BFu0s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_I_BFu0c()
{
  {
    init_simple_test("aL_I_BFu0c");
    static aL_I_BFu0c lv;
    check2(sizeof(lv), 12, "sizeof(aL_I_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_I_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_I_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_I_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaL_I_BFu0c(Test_aL_I_BFu0c, "aL_I_BFu0c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_I_BFu0i()
{
  {
    init_simple_test("aL_I_BFu0i");
    static aL_I_BFu0i lv;
    check2(sizeof(lv), 12, "sizeof(aL_I_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_I_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_I_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_I_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaL_I_BFu0i(Test_aL_I_BFu0i, "aL_I_BFu0i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_I_BFu0ll()
{
  {
    init_simple_test("aL_I_BFu0ll");
    static aL_I_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_I_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_I_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_I_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaL_I_BFu0ll(Test_aL_I_BFu0ll, "aL_I_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_I_BFu0s()
{
  {
    init_simple_test("aL_I_BFu0s");
    static aL_I_BFu0s lv;
    check2(sizeof(lv), 12, "sizeof(aL_I_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_I_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_I_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_I_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaL_I_BFu0s(Test_aL_I_BFu0s, "aL_I_BFu0s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Ip_BFu0c()
{
  {
    init_simple_test("aL_Ip_BFu0c");
    static aL_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_Ip_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_Ip_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_Ip_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaL_Ip_BFu0c(Test_aL_Ip_BFu0c, "aL_Ip_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Ip_BFu0i()
{
  {
    init_simple_test("aL_Ip_BFu0i");
    static aL_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_Ip_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_Ip_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_Ip_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaL_Ip_BFu0i(Test_aL_Ip_BFu0i, "aL_Ip_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Ip_BFu0ll()
{
  {
    init_simple_test("aL_Ip_BFu0ll");
    static aL_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_Ip_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ip_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_Ip_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ip_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaL_Ip_BFu0ll(Test_aL_Ip_BFu0ll, "aL_Ip_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Ip_BFu0s()
{
  {
    init_simple_test("aL_Ip_BFu0s");
    static aL_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_Ip_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ip_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_Ip_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_Ip_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaL_Ip_BFu0s(Test_aL_Ip_BFu0s, "aL_Ip_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_L_BFu0c()
{
  {
    init_simple_test("aL_L_BFu0c");
    static aL_L_BFu0c lv;
    check2(sizeof(lv), 16, "sizeof(aL_L_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_L_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_L_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_L_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaL_L_BFu0c(Test_aL_L_BFu0c, "aL_L_BFu0c", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_L_BFu0i()
{
  {
    init_simple_test("aL_L_BFu0i");
    static aL_L_BFu0i lv;
    check2(sizeof(lv), 16, "sizeof(aL_L_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_L_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_L_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_L_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaL_L_BFu0i(Test_aL_L_BFu0i, "aL_L_BFu0i", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_L_BFu0ll()
{
  {
    init_simple_test("aL_L_BFu0ll");
    static aL_L_BFu0ll lv;
    check2(sizeof(lv), 16, "sizeof(aL_L_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_L_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_L_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_L_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaL_L_BFu0ll(Test_aL_L_BFu0ll, "aL_L_BFu0ll", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_L_BFu0s()
{
  {
    init_simple_test("aL_L_BFu0s");
    static aL_L_BFu0s lv;
    check2(sizeof(lv), 16, "sizeof(aL_L_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_L_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_L_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_L_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaL_L_BFu0s(Test_aL_L_BFu0s, "aL_L_BFu0s", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_S_BFu0c()
{
  {
    init_simple_test("aL_S_BFu0c");
    static aL_S_BFu0c lv;
    check2(sizeof(lv), 10, "sizeof(aL_S_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_S_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_S_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_S_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaL_S_BFu0c(Test_aL_S_BFu0c, "aL_S_BFu0c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_S_BFu0i()
{
  {
    init_simple_test("aL_S_BFu0i");
    static aL_S_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aL_S_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_S_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_S_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_S_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaL_S_BFu0i(Test_aL_S_BFu0i, "aL_S_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_S_BFu0ll()
{
  {
    init_simple_test("aL_S_BFu0ll");
    static aL_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_S_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_S_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_S_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_S_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaL_S_BFu0ll(Test_aL_S_BFu0ll, "aL_S_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_S_BFu0s()
{
  {
    init_simple_test("aL_S_BFu0s");
    static aL_S_BFu0s lv;
    check2(sizeof(lv), 10, "sizeof(aL_S_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_S_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_S_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_S_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaL_S_BFu0s(Test_aL_S_BFu0s, "aL_S_BFu0s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Uc_BFu0c()
{
  {
    init_simple_test("aL_Uc_BFu0c");
    static aL_Uc_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aL_Uc_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Uc_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_Uc_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_Uc_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaL_Uc_BFu0c(Test_aL_Uc_BFu0c, "aL_Uc_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Uc_BFu0i()
{
  {
    init_simple_test("aL_Uc_BFu0i");
    static aL_Uc_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aL_Uc_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Uc_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_Uc_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_Uc_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaL_Uc_BFu0i(Test_aL_Uc_BFu0i, "aL_Uc_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Uc_BFu0ll()
{
  {
    init_simple_test("aL_Uc_BFu0ll");
    static aL_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_Uc_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Uc_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_Uc_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_Uc_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaL_Uc_BFu0ll(Test_aL_Uc_BFu0ll, "aL_Uc_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Uc_BFu0s()
{
  {
    init_simple_test("aL_Uc_BFu0s");
    static aL_Uc_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aL_Uc_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Uc_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_Uc_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_Uc_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaL_Uc_BFu0s(Test_aL_Uc_BFu0s, "aL_Uc_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Ui_BFu0c()
{
  {
    init_simple_test("aL_Ui_BFu0c");
    static aL_Ui_BFu0c lv;
    check2(sizeof(lv), 12, "sizeof(aL_Ui_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaL_Ui_BFu0c(Test_aL_Ui_BFu0c, "aL_Ui_BFu0c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Ui_BFu0i()
{
  {
    init_simple_test("aL_Ui_BFu0i");
    static aL_Ui_BFu0i lv;
    check2(sizeof(lv), 12, "sizeof(aL_Ui_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaL_Ui_BFu0i(Test_aL_Ui_BFu0i, "aL_Ui_BFu0i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Ui_BFu0ll()
{
  {
    init_simple_test("aL_Ui_BFu0ll");
    static aL_Ui_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_Ui_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaL_Ui_BFu0ll(Test_aL_Ui_BFu0ll, "aL_Ui_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Ui_BFu0s()
{
  {
    init_simple_test("aL_Ui_BFu0s");
    static aL_Ui_BFu0s lv;
    check2(sizeof(lv), 12, "sizeof(aL_Ui_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaL_Ui_BFu0s(Test_aL_Ui_BFu0s, "aL_Ui_BFu0s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Ul_BFu0c()
{
  {
    init_simple_test("aL_Ul_BFu0c");
    static aL_Ul_BFu0c lv;
    check2(sizeof(lv), 16, "sizeof(aL_Ul_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaL_Ul_BFu0c(Test_aL_Ul_BFu0c, "aL_Ul_BFu0c", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Ul_BFu0i()
{
  {
    init_simple_test("aL_Ul_BFu0i");
    static aL_Ul_BFu0i lv;
    check2(sizeof(lv), 16, "sizeof(aL_Ul_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaL_Ul_BFu0i(Test_aL_Ul_BFu0i, "aL_Ul_BFu0i", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Ul_BFu0ll()
{
  {
    init_simple_test("aL_Ul_BFu0ll");
    static aL_Ul_BFu0ll lv;
    check2(sizeof(lv), 16, "sizeof(aL_Ul_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaL_Ul_BFu0ll(Test_aL_Ul_BFu0ll, "aL_Ul_BFu0ll", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Ul_BFu0s()
{
  {
    init_simple_test("aL_Ul_BFu0s");
    static aL_Ul_BFu0s lv;
    check2(sizeof(lv), 16, "sizeof(aL_Ul_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaL_Ul_BFu0s(Test_aL_Ul_BFu0s, "aL_Ul_BFu0s", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Us_BFu0c()
{
  {
    init_simple_test("aL_Us_BFu0c");
    static aL_Us_BFu0c lv;
    check2(sizeof(lv), 10, "sizeof(aL_Us_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaL_Us_BFu0c(Test_aL_Us_BFu0c, "aL_Us_BFu0c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Us_BFu0i()
{
  {
    init_simple_test("aL_Us_BFu0i");
    static aL_Us_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aL_Us_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaL_Us_BFu0i(Test_aL_Us_BFu0i, "aL_Us_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Us_BFu0ll()
{
  {
    init_simple_test("aL_Us_BFu0ll");
    static aL_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_Us_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaL_Us_BFu0ll(Test_aL_Us_BFu0ll, "aL_Us_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Us_BFu0s()
{
  {
    init_simple_test("aL_Us_BFu0s");
    static aL_Us_BFu0s lv;
    check2(sizeof(lv), 10, "sizeof(aL_Us_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaL_Us_BFu0s(Test_aL_Us_BFu0s, "aL_Us_BFu0s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Vp_BFu0c()
{
  {
    init_simple_test("aL_Vp_BFu0c");
    static aL_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_Vp_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaL_Vp_BFu0c(Test_aL_Vp_BFu0c, "aL_Vp_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Vp_BFu0i()
{
  {
    init_simple_test("aL_Vp_BFu0i");
    static aL_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_Vp_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaL_Vp_BFu0i(Test_aL_Vp_BFu0i, "aL_Vp_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Vp_BFu0ll()
{
  {
    init_simple_test("aL_Vp_BFu0ll");
    static aL_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_Vp_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaL_Vp_BFu0ll(Test_aL_Vp_BFu0ll, "aL_Vp_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aL_Vp_BFu0s()
{
  {
    init_simple_test("aL_Vp_BFu0s");
    static aL_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_Vp_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaL_Vp_BFu0s(Test_aL_Vp_BFu0s, "aL_Vp_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c()
{
  {
    init_simple_test("aS_BFu0c");
    static aS_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aS_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0c(Test_aS_BFu0c, "aS_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu0c()
{
  {
    init_simple_test("aS_BFu0c_BFu0c");
    static aS_BFu0c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aS_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu0c(Test_aS_BFu0c_BFu0c, "aS_BFu0c_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu0i()
{
  {
    init_simple_test("aS_BFu0c_BFu0i");
    static aS_BFu0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu0c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu0i(Test_aS_BFu0c_BFu0i, "aS_BFu0c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu0ll()
{
  {
    init_simple_test("aS_BFu0c_BFu0ll");
    static aS_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu0c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu0ll(Test_aS_BFu0c_BFu0ll, "aS_BFu0c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu0s()
{
  {
    init_simple_test("aS_BFu0c_BFu0s");
    static aS_BFu0c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aS_BFu0c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu0s(Test_aS_BFu0c_BFu0s, "aS_BFu0c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu15i()
{
  {
    init_simple_test("aS_BFu0c_BFu15i");
    static aS_BFu0c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu0c_BFu15i");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu15i(Test_aS_BFu0c_BFu15i, "aS_BFu0c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu15ll()
{
  {
    init_simple_test("aS_BFu0c_BFu15ll");
    static aS_BFu0c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu0c_BFu15ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu15ll(Test_aS_BFu0c_BFu15ll, "aS_BFu0c_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu15s()
{
  {
    init_simple_test("aS_BFu0c_BFu15s");
    static aS_BFu0c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu0c_BFu15s");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu15s(Test_aS_BFu0c_BFu15s, "aS_BFu0c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu16i()
{
  {
    init_simple_test("aS_BFu0c_BFu16i");
    static aS_BFu0c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu0c_BFu16i");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu16i(Test_aS_BFu0c_BFu16i, "aS_BFu0c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu16ll()
{
  {
    init_simple_test("aS_BFu0c_BFu16ll");
    static aS_BFu0c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu0c_BFu16ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu16ll(Test_aS_BFu0c_BFu16ll, "aS_BFu0c_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu16s()
{
  {
    init_simple_test("aS_BFu0c_BFu16s");
    static aS_BFu0c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu0c_BFu16s");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu16s(Test_aS_BFu0c_BFu16s, "aS_BFu0c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu17i()
{
  {
    init_simple_test("aS_BFu0c_BFu17i");
    static aS_BFu0c_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu0c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu0c_BFu17i");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu17i(Test_aS_BFu0c_BFu17i, "aS_BFu0c_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu17ll()
{
  {
    init_simple_test("aS_BFu0c_BFu17ll");
    static aS_BFu0c_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu0c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu0c_BFu17ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu17ll(Test_aS_BFu0c_BFu17ll, "aS_BFu0c_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu1c()
{
  {
    init_simple_test("aS_BFu0c_BFu1c");
    static aS_BFu0c_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu0c_BFu1c");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu1c(Test_aS_BFu0c_BFu1c, "aS_BFu0c_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu1i()
{
  {
    init_simple_test("aS_BFu0c_BFu1i");
    static aS_BFu0c_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu0c_BFu1i");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu1i(Test_aS_BFu0c_BFu1i, "aS_BFu0c_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu1ll()
{
  {
    init_simple_test("aS_BFu0c_BFu1ll");
    static aS_BFu0c_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu0c_BFu1ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu1ll(Test_aS_BFu0c_BFu1ll, "aS_BFu0c_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu1s()
{
  {
    init_simple_test("aS_BFu0c_BFu1s");
    static aS_BFu0c_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu0c_BFu1s");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu1s(Test_aS_BFu0c_BFu1s, "aS_BFu0c_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu31i()
{
  {
    init_simple_test("aS_BFu0c_BFu31i");
    static aS_BFu0c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu0c_BFu31i");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu31i(Test_aS_BFu0c_BFu31i, "aS_BFu0c_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu31ll()
{
  {
    init_simple_test("aS_BFu0c_BFu31ll");
    static aS_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu0c_BFu31ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu31ll(Test_aS_BFu0c_BFu31ll, "aS_BFu0c_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu32i()
{
  {
    init_simple_test("aS_BFu0c_BFu32i");
    static aS_BFu0c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu0c_BFu32i");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu32i(Test_aS_BFu0c_BFu32i, "aS_BFu0c_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu32ll()
{
  {
    init_simple_test("aS_BFu0c_BFu32ll");
    static aS_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu0c_BFu32ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu32ll(Test_aS_BFu0c_BFu32ll, "aS_BFu0c_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu33()
{
  {
    init_simple_test("aS_BFu0c_BFu33");
    static aS_BFu0c_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu0c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu0c_BFu33");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu33(Test_aS_BFu0c_BFu33, "aS_BFu0c_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu7c()
{
  {
    init_simple_test("aS_BFu0c_BFu7c");
    static aS_BFu0c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu0c_BFu7c");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu7c(Test_aS_BFu0c_BFu7c, "aS_BFu0c_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu7i()
{
  {
    init_simple_test("aS_BFu0c_BFu7i");
    static aS_BFu0c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu0c_BFu7i");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu7i(Test_aS_BFu0c_BFu7i, "aS_BFu0c_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu7ll()
{
  {
    init_simple_test("aS_BFu0c_BFu7ll");
    static aS_BFu0c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu0c_BFu7ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu7ll(Test_aS_BFu0c_BFu7ll, "aS_BFu0c_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu7s()
{
  {
    init_simple_test("aS_BFu0c_BFu7s");
    static aS_BFu0c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu0c_BFu7s");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu7s(Test_aS_BFu0c_BFu7s, "aS_BFu0c_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu8c()
{
  {
    init_simple_test("aS_BFu0c_BFu8c");
    static aS_BFu0c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu0c_BFu8c");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu8c(Test_aS_BFu0c_BFu8c, "aS_BFu0c_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu8i()
{
  {
    init_simple_test("aS_BFu0c_BFu8i");
    static aS_BFu0c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu0c_BFu8i");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu8i(Test_aS_BFu0c_BFu8i, "aS_BFu0c_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu8ll()
{
  {
    init_simple_test("aS_BFu0c_BFu8ll");
    static aS_BFu0c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu0c_BFu8ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu8ll(Test_aS_BFu0c_BFu8ll, "aS_BFu0c_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu8s()
{
  {
    init_simple_test("aS_BFu0c_BFu8s");
    static aS_BFu0c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu0c_BFu8s");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu8s(Test_aS_BFu0c_BFu8s, "aS_BFu0c_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu9i()
{
  {
    init_simple_test("aS_BFu0c_BFu9i");
    static aS_BFu0c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu0c_BFu9i");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu9i(Test_aS_BFu0c_BFu9i, "aS_BFu0c_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu9ll()
{
  {
    init_simple_test("aS_BFu0c_BFu9ll");
    static aS_BFu0c_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu0c_BFu9ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu9ll(Test_aS_BFu0c_BFu9ll, "aS_BFu0c_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_BFu9s()
{
  {
    init_simple_test("aS_BFu0c_BFu9s");
    static aS_BFu0c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu0c_BFu9s");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_BFu9s(Test_aS_BFu0c_BFu9s, "aS_BFu0c_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_C()
{
  {
    init_simple_test("aS_BFu0c_C");
    static aS_BFu0c_C lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_C)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_C.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_C.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_C(Test_aS_BFu0c_C, "aS_BFu0c_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_D()
{
  {
    init_simple_test("aS_BFu0c_D");
    static aS_BFu0c_D lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu0c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_D)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_D.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_D.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_D(Test_aS_BFu0c_D, "aS_BFu0c_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_F()
{
  {
    init_simple_test("aS_BFu0c_F");
    static aS_BFu0c_F lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_F)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_F.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_F.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_F(Test_aS_BFu0c_F, "aS_BFu0c_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_I()
{
  {
    init_simple_test("aS_BFu0c_I");
    static aS_BFu0c_I lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_I)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_I.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_I.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_I(Test_aS_BFu0c_I, "aS_BFu0c_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_Ip()
{
  {
    init_simple_test("aS_BFu0c_Ip");
    static aS_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_Ip.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_Ip.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_Ip(Test_aS_BFu0c_Ip, "aS_BFu0c_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_L()
{
  {
    init_simple_test("aS_BFu0c_L");
    static aS_BFu0c_L lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu0c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_L)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_L.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_L.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_L(Test_aS_BFu0c_L, "aS_BFu0c_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_S()
{
  {
    init_simple_test("aS_BFu0c_S");
    static aS_BFu0c_S lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_S)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_S.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_S.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_S(Test_aS_BFu0c_S, "aS_BFu0c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_Uc()
{
  {
    init_simple_test("aS_BFu0c_Uc");
    static aS_BFu0c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_Uc.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_Uc.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_Uc(Test_aS_BFu0c_Uc, "aS_BFu0c_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_Ui()
{
  {
    init_simple_test("aS_BFu0c_Ui");
    static aS_BFu0c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_Ui.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_Ui.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_Ui(Test_aS_BFu0c_Ui, "aS_BFu0c_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_Ul()
{
  {
    init_simple_test("aS_BFu0c_Ul");
    static aS_BFu0c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu0c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_Ul.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_Ul.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_Ul(Test_aS_BFu0c_Ul, "aS_BFu0c_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_Us()
{
  {
    init_simple_test("aS_BFu0c_Us");
    static aS_BFu0c_Us lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_Us.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_Us.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_Us(Test_aS_BFu0c_Us, "aS_BFu0c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0c_Vp()
{
  {
    init_simple_test("aS_BFu0c_Vp");
    static aS_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_Vp.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_Vp.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0c_Vp(Test_aS_BFu0c_Vp, "aS_BFu0c_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i()
{
  {
    init_simple_test("aS_BFu0i");
    static aS_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0i(Test_aS_BFu0i, "aS_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu0c()
{
  {
    init_simple_test("aS_BFu0i_BFu0c");
    static aS_BFu0i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu0i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu0c(Test_aS_BFu0i_BFu0c, "aS_BFu0i_BFu0c", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu0i()
{
  {
    init_simple_test("aS_BFu0i_BFu0i");
    static aS_BFu0i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu0i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu0i(Test_aS_BFu0i_BFu0i, "aS_BFu0i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu0ll()
{
  {
    init_simple_test("aS_BFu0i_BFu0ll");
    static aS_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu0i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu0ll(Test_aS_BFu0i_BFu0ll, "aS_BFu0i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu0s()
{
  {
    init_simple_test("aS_BFu0i_BFu0s");
    static aS_BFu0i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu0i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu0s(Test_aS_BFu0i_BFu0s, "aS_BFu0i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu15i()
{
  {
    init_simple_test("aS_BFu0i_BFu15i");
    static aS_BFu0i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aS_BFu0i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, 1, "aS_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, hide_ull(1LL<<14), "aS_BFu0i_BFu15i");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu15i(Test_aS_BFu0i_BFu15i, "aS_BFu0i_BFu15i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu15ll()
{
  {
    init_simple_test("aS_BFu0i_BFu15ll");
    static aS_BFu0i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aS_BFu0i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, 1, "aS_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, hide_ull(1LL<<14), "aS_BFu0i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu15ll(Test_aS_BFu0i_BFu15ll, "aS_BFu0i_BFu15ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu15s()
{
  {
    init_simple_test("aS_BFu0i_BFu15s");
    static aS_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aS_BFu0i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, 1, "aS_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, hide_ull(1LL<<14), "aS_BFu0i_BFu15s");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu15s(Test_aS_BFu0i_BFu15s, "aS_BFu0i_BFu15s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu16i()
{
  {
    init_simple_test("aS_BFu0i_BFu16i");
    static aS_BFu0i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aS_BFu0i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, 1, "aS_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, hide_ull(1LL<<15), "aS_BFu0i_BFu16i");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu16i(Test_aS_BFu0i_BFu16i, "aS_BFu0i_BFu16i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu16ll()
{
  {
    init_simple_test("aS_BFu0i_BFu16ll");
    static aS_BFu0i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aS_BFu0i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, 1, "aS_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, hide_ull(1LL<<15), "aS_BFu0i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu16ll(Test_aS_BFu0i_BFu16ll, "aS_BFu0i_BFu16ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu16s()
{
  {
    init_simple_test("aS_BFu0i_BFu16s");
    static aS_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aS_BFu0i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, 1, "aS_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, hide_ull(1LL<<15), "aS_BFu0i_BFu16s");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu16s(Test_aS_BFu0i_BFu16s, "aS_BFu0i_BFu16s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu17i()
{
  {
    init_simple_test("aS_BFu0i_BFu17i");
    static aS_BFu0i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aS_BFu0i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, 1, "aS_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, hide_ull(1LL<<16), "aS_BFu0i_BFu17i");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu17i(Test_aS_BFu0i_BFu17i, "aS_BFu0i_BFu17i", ABISELECT(7,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu17ll()
{
  {
    init_simple_test("aS_BFu0i_BFu17ll");
    static aS_BFu0i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aS_BFu0i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, 1, "aS_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, hide_ull(1LL<<16), "aS_BFu0i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu17ll(Test_aS_BFu0i_BFu17ll, "aS_BFu0i_BFu17ll", ABISELECT(7,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu1c()
{
  {
    init_simple_test("aS_BFu0i_BFu1c");
    static aS_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "aS_BFu0i_BFu1c");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu1c(Test_aS_BFu0i_BFu1c, "aS_BFu0i_BFu1c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu1i()
{
  {
    init_simple_test("aS_BFu0i_BFu1i");
    static aS_BFu0i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "aS_BFu0i_BFu1i");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu1i(Test_aS_BFu0i_BFu1i, "aS_BFu0i_BFu1i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu1ll()
{
  {
    init_simple_test("aS_BFu0i_BFu1ll");
    static aS_BFu0i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "aS_BFu0i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu1ll(Test_aS_BFu0i_BFu1ll, "aS_BFu0i_BFu1ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu1s()
{
  {
    init_simple_test("aS_BFu0i_BFu1s");
    static aS_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "aS_BFu0i_BFu1s");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu1s(Test_aS_BFu0i_BFu1s, "aS_BFu0i_BFu1s", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu31i()
{
  {
    init_simple_test("aS_BFu0i_BFu31i");
    static aS_BFu0i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu0i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, 1, "aS_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, hide_ull(1LL<<30), "aS_BFu0i_BFu31i");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu31i(Test_aS_BFu0i_BFu31i, "aS_BFu0i_BFu31i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu31ll()
{
  {
    init_simple_test("aS_BFu0i_BFu31ll");
    static aS_BFu0i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu0i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, 1, "aS_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, hide_ull(1LL<<30), "aS_BFu0i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu31ll(Test_aS_BFu0i_BFu31ll, "aS_BFu0i_BFu31ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu32i()
{
  {
    init_simple_test("aS_BFu0i_BFu32i");
    static aS_BFu0i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu0i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, 1, "aS_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, hide_ull(1LL<<31), "aS_BFu0i_BFu32i");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu32i(Test_aS_BFu0i_BFu32i, "aS_BFu0i_BFu32i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu32ll()
{
  {
    init_simple_test("aS_BFu0i_BFu32ll");
    static aS_BFu0i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu0i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, 1, "aS_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, hide_ull(1LL<<31), "aS_BFu0i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu32ll(Test_aS_BFu0i_BFu32ll, "aS_BFu0i_BFu32ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu33()
{
  {
    init_simple_test("aS_BFu0i_BFu33");
    static aS_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(9,9), "sizeof(aS_BFu0i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 33, 1, "aS_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 33, hide_ull(1LL<<32), "aS_BFu0i_BFu33");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu33(Test_aS_BFu0i_BFu33, "aS_BFu0i_BFu33", ABISELECT(9,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu7c()
{
  {
    init_simple_test("aS_BFu0i_BFu7c");
    static aS_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "aS_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "aS_BFu0i_BFu7c");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu7c(Test_aS_BFu0i_BFu7c, "aS_BFu0i_BFu7c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu7i()
{
  {
    init_simple_test("aS_BFu0i_BFu7i");
    static aS_BFu0i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "aS_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "aS_BFu0i_BFu7i");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu7i(Test_aS_BFu0i_BFu7i, "aS_BFu0i_BFu7i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu7ll()
{
  {
    init_simple_test("aS_BFu0i_BFu7ll");
    static aS_BFu0i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "aS_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "aS_BFu0i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu7ll(Test_aS_BFu0i_BFu7ll, "aS_BFu0i_BFu7ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu7s()
{
  {
    init_simple_test("aS_BFu0i_BFu7s");
    static aS_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "aS_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "aS_BFu0i_BFu7s");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu7s(Test_aS_BFu0i_BFu7s, "aS_BFu0i_BFu7s", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu8c()
{
  {
    init_simple_test("aS_BFu0i_BFu8c");
    static aS_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "aS_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "aS_BFu0i_BFu8c");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu8c(Test_aS_BFu0i_BFu8c, "aS_BFu0i_BFu8c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu8i()
{
  {
    init_simple_test("aS_BFu0i_BFu8i");
    static aS_BFu0i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "aS_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "aS_BFu0i_BFu8i");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu8i(Test_aS_BFu0i_BFu8i, "aS_BFu0i_BFu8i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu8ll()
{
  {
    init_simple_test("aS_BFu0i_BFu8ll");
    static aS_BFu0i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "aS_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "aS_BFu0i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu8ll(Test_aS_BFu0i_BFu8ll, "aS_BFu0i_BFu8ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu8s()
{
  {
    init_simple_test("aS_BFu0i_BFu8s");
    static aS_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "aS_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "aS_BFu0i_BFu8s");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu8s(Test_aS_BFu0i_BFu8s, "aS_BFu0i_BFu8s", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu9i()
{
  {
    init_simple_test("aS_BFu0i_BFu9i");
    static aS_BFu0i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aS_BFu0i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, 1, "aS_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, hide_ull(1LL<<8), "aS_BFu0i_BFu9i");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu9i(Test_aS_BFu0i_BFu9i, "aS_BFu0i_BFu9i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu9ll()
{
  {
    init_simple_test("aS_BFu0i_BFu9ll");
    static aS_BFu0i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aS_BFu0i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, 1, "aS_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, hide_ull(1LL<<8), "aS_BFu0i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu9ll(Test_aS_BFu0i_BFu9ll, "aS_BFu0i_BFu9ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_BFu9s()
{
  {
    init_simple_test("aS_BFu0i_BFu9s");
    static aS_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aS_BFu0i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, 1, "aS_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, hide_ull(1LL<<8), "aS_BFu0i_BFu9s");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_BFu9s(Test_aS_BFu0i_BFu9s, "aS_BFu0i_BFu9s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_C()
{
  {
    init_simple_test("aS_BFu0i_C");
    static aS_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_C)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_C.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_C.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_C(Test_aS_BFu0i_C, "aS_BFu0i_C", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_D()
{
  {
    init_simple_test("aS_BFu0i_D");
    static aS_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aS_BFu0i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_D)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_D.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_D.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_D(Test_aS_BFu0i_D, "aS_BFu0i_D", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_F()
{
  {
    init_simple_test("aS_BFu0i_F");
    static aS_BFu0i_F lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu0i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_F)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_F.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_F.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_F(Test_aS_BFu0i_F, "aS_BFu0i_F", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_I()
{
  {
    init_simple_test("aS_BFu0i_I");
    static aS_BFu0i_I lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu0i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_I)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_I.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_I.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_I(Test_aS_BFu0i_I, "aS_BFu0i_I", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_Ip()
{
  {
    init_simple_test("aS_BFu0i_Ip");
    static aS_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu0i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_Ip.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_Ip(Test_aS_BFu0i_Ip, "aS_BFu0i_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_L()
{
  {
    init_simple_test("aS_BFu0i_L");
    static aS_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aS_BFu0i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_L)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_L.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_L.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_L(Test_aS_BFu0i_L, "aS_BFu0i_L", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_S()
{
  {
    init_simple_test("aS_BFu0i_S");
    static aS_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aS_BFu0i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_S)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_S.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_S.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_S(Test_aS_BFu0i_S, "aS_BFu0i_S", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_Uc()
{
  {
    init_simple_test("aS_BFu0i_Uc");
    static aS_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aS_BFu0i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_Uc.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_Uc(Test_aS_BFu0i_Uc, "aS_BFu0i_Uc", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_Ui()
{
  {
    init_simple_test("aS_BFu0i_Ui");
    static aS_BFu0i_Ui lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu0i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_Ui.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_Ui(Test_aS_BFu0i_Ui, "aS_BFu0i_Ui", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_Ul()
{
  {
    init_simple_test("aS_BFu0i_Ul");
    static aS_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aS_BFu0i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_Ul.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_Ul(Test_aS_BFu0i_Ul, "aS_BFu0i_Ul", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_Us()
{
  {
    init_simple_test("aS_BFu0i_Us");
    static aS_BFu0i_Us lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aS_BFu0i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_Us.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_Us.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_Us(Test_aS_BFu0i_Us, "aS_BFu0i_Us", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0i_Vp()
{
  {
    init_simple_test("aS_BFu0i_Vp");
    static aS_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu0i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_Vp.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0i_Vp(Test_aS_BFu0i_Vp, "aS_BFu0i_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll()
{
  {
    init_simple_test("aS_BFu0ll");
    static aS_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll(Test_aS_BFu0ll, "aS_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu0c()
{
  {
    init_simple_test("aS_BFu0ll_BFu0c");
    static aS_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu0ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu0c(Test_aS_BFu0ll_BFu0c, "aS_BFu0ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu0i()
{
  {
    init_simple_test("aS_BFu0ll_BFu0i");
    static aS_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu0ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu0i(Test_aS_BFu0ll_BFu0i, "aS_BFu0ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu0ll()
{
  {
    init_simple_test("aS_BFu0ll_BFu0ll");
    static aS_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu0ll(Test_aS_BFu0ll_BFu0ll, "aS_BFu0ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu0s()
{
  {
    init_simple_test("aS_BFu0ll_BFu0s");
    static aS_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu0ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu0s(Test_aS_BFu0ll_BFu0s, "aS_BFu0ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu15i()
{
  {
    init_simple_test("aS_BFu0ll_BFu15i");
    static aS_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aS_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aS_BFu0ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu15i(Test_aS_BFu0ll_BFu15i, "aS_BFu0ll_BFu15i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu15ll()
{
  {
    init_simple_test("aS_BFu0ll_BFu15ll");
    static aS_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aS_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aS_BFu0ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu15ll(Test_aS_BFu0ll_BFu15ll, "aS_BFu0ll_BFu15ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu15s()
{
  {
    init_simple_test("aS_BFu0ll_BFu15s");
    static aS_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aS_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aS_BFu0ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu15s(Test_aS_BFu0ll_BFu15s, "aS_BFu0ll_BFu15s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu16i()
{
  {
    init_simple_test("aS_BFu0ll_BFu16i");
    static aS_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aS_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aS_BFu0ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu16i(Test_aS_BFu0ll_BFu16i, "aS_BFu0ll_BFu16i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu16ll()
{
  {
    init_simple_test("aS_BFu0ll_BFu16ll");
    static aS_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aS_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aS_BFu0ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu16ll(Test_aS_BFu0ll_BFu16ll, "aS_BFu0ll_BFu16ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu16s()
{
  {
    init_simple_test("aS_BFu0ll_BFu16s");
    static aS_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aS_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aS_BFu0ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu16s(Test_aS_BFu0ll_BFu16s, "aS_BFu0ll_BFu16s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu17i()
{
  {
    init_simple_test("aS_BFu0ll_BFu17i");
    static aS_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu0ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aS_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aS_BFu0ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu17i(Test_aS_BFu0ll_BFu17i, "aS_BFu0ll_BFu17i", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu17ll()
{
  {
    init_simple_test("aS_BFu0ll_BFu17ll");
    static aS_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aS_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aS_BFu0ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu17ll(Test_aS_BFu0ll_BFu17ll, "aS_BFu0ll_BFu17ll", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu1c()
{
  {
    init_simple_test("aS_BFu0ll_BFu1c");
    static aS_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aS_BFu0ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu1c(Test_aS_BFu0ll_BFu1c, "aS_BFu0ll_BFu1c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu1i()
{
  {
    init_simple_test("aS_BFu0ll_BFu1i");
    static aS_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aS_BFu0ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu1i(Test_aS_BFu0ll_BFu1i, "aS_BFu0ll_BFu1i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu1ll()
{
  {
    init_simple_test("aS_BFu0ll_BFu1ll");
    static aS_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aS_BFu0ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu1ll(Test_aS_BFu0ll_BFu1ll, "aS_BFu0ll_BFu1ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu1s()
{
  {
    init_simple_test("aS_BFu0ll_BFu1s");
    static aS_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aS_BFu0ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu1s(Test_aS_BFu0ll_BFu1s, "aS_BFu0ll_BFu1s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu31i()
{
  {
    init_simple_test("aS_BFu0ll_BFu31i");
    static aS_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu0ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aS_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aS_BFu0ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu31i(Test_aS_BFu0ll_BFu31i, "aS_BFu0ll_BFu31i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu31ll()
{
  {
    init_simple_test("aS_BFu0ll_BFu31ll");
    static aS_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aS_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aS_BFu0ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu31ll(Test_aS_BFu0ll_BFu31ll, "aS_BFu0ll_BFu31ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu32i()
{
  {
    init_simple_test("aS_BFu0ll_BFu32i");
    static aS_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu0ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aS_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aS_BFu0ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu32i(Test_aS_BFu0ll_BFu32i, "aS_BFu0ll_BFu32i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu32ll()
{
  {
    init_simple_test("aS_BFu0ll_BFu32ll");
    static aS_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aS_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aS_BFu0ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu32ll(Test_aS_BFu0ll_BFu32ll, "aS_BFu0ll_BFu32ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu33()
{
  {
    init_simple_test("aS_BFu0ll_BFu33");
    static aS_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aS_BFu0ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aS_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aS_BFu0ll_BFu33");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu33(Test_aS_BFu0ll_BFu33, "aS_BFu0ll_BFu33", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu7c()
{
  {
    init_simple_test("aS_BFu0ll_BFu7c");
    static aS_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aS_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aS_BFu0ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu7c(Test_aS_BFu0ll_BFu7c, "aS_BFu0ll_BFu7c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu7i()
{
  {
    init_simple_test("aS_BFu0ll_BFu7i");
    static aS_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aS_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aS_BFu0ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu7i(Test_aS_BFu0ll_BFu7i, "aS_BFu0ll_BFu7i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu7ll()
{
  {
    init_simple_test("aS_BFu0ll_BFu7ll");
    static aS_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aS_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aS_BFu0ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu7ll(Test_aS_BFu0ll_BFu7ll, "aS_BFu0ll_BFu7ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu7s()
{
  {
    init_simple_test("aS_BFu0ll_BFu7s");
    static aS_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aS_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aS_BFu0ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu7s(Test_aS_BFu0ll_BFu7s, "aS_BFu0ll_BFu7s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu8c()
{
  {
    init_simple_test("aS_BFu0ll_BFu8c");
    static aS_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aS_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aS_BFu0ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu8c(Test_aS_BFu0ll_BFu8c, "aS_BFu0ll_BFu8c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu8i()
{
  {
    init_simple_test("aS_BFu0ll_BFu8i");
    static aS_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aS_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aS_BFu0ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu8i(Test_aS_BFu0ll_BFu8i, "aS_BFu0ll_BFu8i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu8ll()
{
  {
    init_simple_test("aS_BFu0ll_BFu8ll");
    static aS_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aS_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aS_BFu0ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu8ll(Test_aS_BFu0ll_BFu8ll, "aS_BFu0ll_BFu8ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu8s()
{
  {
    init_simple_test("aS_BFu0ll_BFu8s");
    static aS_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aS_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aS_BFu0ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu8s(Test_aS_BFu0ll_BFu8s, "aS_BFu0ll_BFu8s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu9i()
{
  {
    init_simple_test("aS_BFu0ll_BFu9i");
    static aS_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aS_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aS_BFu0ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu9i(Test_aS_BFu0ll_BFu9i, "aS_BFu0ll_BFu9i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu9ll()
{
  {
    init_simple_test("aS_BFu0ll_BFu9ll");
    static aS_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aS_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aS_BFu0ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu9ll(Test_aS_BFu0ll_BFu9ll, "aS_BFu0ll_BFu9ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_BFu9s()
{
  {
    init_simple_test("aS_BFu0ll_BFu9s");
    static aS_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aS_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aS_BFu0ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_BFu9s(Test_aS_BFu0ll_BFu9s, "aS_BFu0ll_BFu9s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_C()
{
  {
    init_simple_test("aS_BFu0ll_C");
    static aS_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_C)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_C.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_C(Test_aS_BFu0ll_C, "aS_BFu0ll_C", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_D()
{
  {
    init_simple_test("aS_BFu0ll_D");
    static aS_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aS_BFu0ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_D)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_D.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_D(Test_aS_BFu0ll_D, "aS_BFu0ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_F()
{
  {
    init_simple_test("aS_BFu0ll_F");
    static aS_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu0ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_F)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_F.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_F(Test_aS_BFu0ll_F, "aS_BFu0ll_F", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_I()
{
  {
    init_simple_test("aS_BFu0ll_I");
    static aS_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu0ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_I)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_I.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_I(Test_aS_BFu0ll_I, "aS_BFu0ll_I", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_Ip()
{
  {
    init_simple_test("aS_BFu0ll_Ip");
    static aS_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aS_BFu0ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_Ip(Test_aS_BFu0ll_Ip, "aS_BFu0ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_L()
{
  {
    init_simple_test("aS_BFu0ll_L");
    static aS_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aS_BFu0ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_L)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_L.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_L(Test_aS_BFu0ll_L, "aS_BFu0ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_S()
{
  {
    init_simple_test("aS_BFu0ll_S");
    static aS_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_S)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_S.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_S(Test_aS_BFu0ll_S, "aS_BFu0ll_S", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_Uc()
{
  {
    init_simple_test("aS_BFu0ll_Uc");
    static aS_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aS_BFu0ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_Uc(Test_aS_BFu0ll_Uc, "aS_BFu0ll_Uc", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_Ui()
{
  {
    init_simple_test("aS_BFu0ll_Ui");
    static aS_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu0ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_Ui(Test_aS_BFu0ll_Ui, "aS_BFu0ll_Ui", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_Ul()
{
  {
    init_simple_test("aS_BFu0ll_Ul");
    static aS_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aS_BFu0ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_Ul(Test_aS_BFu0ll_Ul, "aS_BFu0ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_Us()
{
  {
    init_simple_test("aS_BFu0ll_Us");
    static aS_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_Us.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_Us(Test_aS_BFu0ll_Us, "aS_BFu0ll_Us", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0ll_Vp()
{
  {
    init_simple_test("aS_BFu0ll_Vp");
    static aS_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aS_BFu0ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0ll_Vp(Test_aS_BFu0ll_Vp, "aS_BFu0ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s()
{
  {
    init_simple_test("aS_BFu0s");
    static aS_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aS_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0s(Test_aS_BFu0s, "aS_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu0c()
{
  {
    init_simple_test("aS_BFu0s_BFu0c");
    static aS_BFu0s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aS_BFu0s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu0c(Test_aS_BFu0s_BFu0c, "aS_BFu0s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu0i()
{
  {
    init_simple_test("aS_BFu0s_BFu0i");
    static aS_BFu0s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu0s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu0i(Test_aS_BFu0s_BFu0i, "aS_BFu0s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu0ll()
{
  {
    init_simple_test("aS_BFu0s_BFu0ll");
    static aS_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu0s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu0ll(Test_aS_BFu0s_BFu0ll, "aS_BFu0s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu0s()
{
  {
    init_simple_test("aS_BFu0s_BFu0s");
    static aS_BFu0s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aS_BFu0s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu0s(Test_aS_BFu0s_BFu0s, "aS_BFu0s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu15i()
{
  {
    init_simple_test("aS_BFu0s_BFu15i");
    static aS_BFu0s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu0s_BFu15i");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu15i(Test_aS_BFu0s_BFu15i, "aS_BFu0s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu15ll()
{
  {
    init_simple_test("aS_BFu0s_BFu15ll");
    static aS_BFu0s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu0s_BFu15ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu15ll(Test_aS_BFu0s_BFu15ll, "aS_BFu0s_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu15s()
{
  {
    init_simple_test("aS_BFu0s_BFu15s");
    static aS_BFu0s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu0s_BFu15s");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu15s(Test_aS_BFu0s_BFu15s, "aS_BFu0s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu16i()
{
  {
    init_simple_test("aS_BFu0s_BFu16i");
    static aS_BFu0s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu0s_BFu16i");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu16i(Test_aS_BFu0s_BFu16i, "aS_BFu0s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu16ll()
{
  {
    init_simple_test("aS_BFu0s_BFu16ll");
    static aS_BFu0s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu0s_BFu16ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu16ll(Test_aS_BFu0s_BFu16ll, "aS_BFu0s_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu16s()
{
  {
    init_simple_test("aS_BFu0s_BFu16s");
    static aS_BFu0s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu0s_BFu16s");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu16s(Test_aS_BFu0s_BFu16s, "aS_BFu0s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu17i()
{
  {
    init_simple_test("aS_BFu0s_BFu17i");
    static aS_BFu0s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu0s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu0s_BFu17i");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu17i(Test_aS_BFu0s_BFu17i, "aS_BFu0s_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu17ll()
{
  {
    init_simple_test("aS_BFu0s_BFu17ll");
    static aS_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu0s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu0s_BFu17ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu17ll(Test_aS_BFu0s_BFu17ll, "aS_BFu0s_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu1c()
{
  {
    init_simple_test("aS_BFu0s_BFu1c");
    static aS_BFu0s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu0s_BFu1c");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu1c(Test_aS_BFu0s_BFu1c, "aS_BFu0s_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu1i()
{
  {
    init_simple_test("aS_BFu0s_BFu1i");
    static aS_BFu0s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu0s_BFu1i");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu1i(Test_aS_BFu0s_BFu1i, "aS_BFu0s_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu1ll()
{
  {
    init_simple_test("aS_BFu0s_BFu1ll");
    static aS_BFu0s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu0s_BFu1ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu1ll(Test_aS_BFu0s_BFu1ll, "aS_BFu0s_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu1s()
{
  {
    init_simple_test("aS_BFu0s_BFu1s");
    static aS_BFu0s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu0s_BFu1s");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu1s(Test_aS_BFu0s_BFu1s, "aS_BFu0s_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu31i()
{
  {
    init_simple_test("aS_BFu0s_BFu31i");
    static aS_BFu0s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu0s_BFu31i");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu31i(Test_aS_BFu0s_BFu31i, "aS_BFu0s_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu31ll()
{
  {
    init_simple_test("aS_BFu0s_BFu31ll");
    static aS_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu0s_BFu31ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu31ll(Test_aS_BFu0s_BFu31ll, "aS_BFu0s_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu32i()
{
  {
    init_simple_test("aS_BFu0s_BFu32i");
    static aS_BFu0s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu0s_BFu32i");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu32i(Test_aS_BFu0s_BFu32i, "aS_BFu0s_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu32ll()
{
  {
    init_simple_test("aS_BFu0s_BFu32ll");
    static aS_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu0s_BFu32ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu32ll(Test_aS_BFu0s_BFu32ll, "aS_BFu0s_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu33()
{
  {
    init_simple_test("aS_BFu0s_BFu33");
    static aS_BFu0s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu0s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu0s_BFu33");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu33(Test_aS_BFu0s_BFu33, "aS_BFu0s_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu7c()
{
  {
    init_simple_test("aS_BFu0s_BFu7c");
    static aS_BFu0s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu0s_BFu7c");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu7c(Test_aS_BFu0s_BFu7c, "aS_BFu0s_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu7i()
{
  {
    init_simple_test("aS_BFu0s_BFu7i");
    static aS_BFu0s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu0s_BFu7i");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu7i(Test_aS_BFu0s_BFu7i, "aS_BFu0s_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu7ll()
{
  {
    init_simple_test("aS_BFu0s_BFu7ll");
    static aS_BFu0s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu0s_BFu7ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu7ll(Test_aS_BFu0s_BFu7ll, "aS_BFu0s_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu7s()
{
  {
    init_simple_test("aS_BFu0s_BFu7s");
    static aS_BFu0s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu0s_BFu7s");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu7s(Test_aS_BFu0s_BFu7s, "aS_BFu0s_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu8c()
{
  {
    init_simple_test("aS_BFu0s_BFu8c");
    static aS_BFu0s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu0s_BFu8c");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu8c(Test_aS_BFu0s_BFu8c, "aS_BFu0s_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu8i()
{
  {
    init_simple_test("aS_BFu0s_BFu8i");
    static aS_BFu0s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu0s_BFu8i");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu8i(Test_aS_BFu0s_BFu8i, "aS_BFu0s_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu8ll()
{
  {
    init_simple_test("aS_BFu0s_BFu8ll");
    static aS_BFu0s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu0s_BFu8ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu8ll(Test_aS_BFu0s_BFu8ll, "aS_BFu0s_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu8s()
{
  {
    init_simple_test("aS_BFu0s_BFu8s");
    static aS_BFu0s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu0s_BFu8s");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu8s(Test_aS_BFu0s_BFu8s, "aS_BFu0s_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu9i()
{
  {
    init_simple_test("aS_BFu0s_BFu9i");
    static aS_BFu0s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu0s_BFu9i");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu9i(Test_aS_BFu0s_BFu9i, "aS_BFu0s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu9ll()
{
  {
    init_simple_test("aS_BFu0s_BFu9ll");
    static aS_BFu0s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu0s_BFu9ll");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu9ll(Test_aS_BFu0s_BFu9ll, "aS_BFu0s_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_BFu9s()
{
  {
    init_simple_test("aS_BFu0s_BFu9s");
    static aS_BFu0s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu0s_BFu9s");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_BFu9s(Test_aS_BFu0s_BFu9s, "aS_BFu0s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_C()
{
  {
    init_simple_test("aS_BFu0s_C");
    static aS_BFu0s_C lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_C)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_C.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_C.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_C(Test_aS_BFu0s_C, "aS_BFu0s_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_D()
{
  {
    init_simple_test("aS_BFu0s_D");
    static aS_BFu0s_D lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu0s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_D)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_D.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_D.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_D(Test_aS_BFu0s_D, "aS_BFu0s_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_F()
{
  {
    init_simple_test("aS_BFu0s_F");
    static aS_BFu0s_F lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_F)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_F.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_F.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_F(Test_aS_BFu0s_F, "aS_BFu0s_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_I()
{
  {
    init_simple_test("aS_BFu0s_I");
    static aS_BFu0s_I lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_I)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_I.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_I.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_I(Test_aS_BFu0s_I, "aS_BFu0s_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_Ip()
{
  {
    init_simple_test("aS_BFu0s_Ip");
    static aS_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_Ip.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_Ip.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_Ip(Test_aS_BFu0s_Ip, "aS_BFu0s_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_L()
{
  {
    init_simple_test("aS_BFu0s_L");
    static aS_BFu0s_L lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu0s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_L)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_L.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_L.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_L(Test_aS_BFu0s_L, "aS_BFu0s_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_S()
{
  {
    init_simple_test("aS_BFu0s_S");
    static aS_BFu0s_S lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_S)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_S.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_S.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_S(Test_aS_BFu0s_S, "aS_BFu0s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_Uc()
{
  {
    init_simple_test("aS_BFu0s_Uc");
    static aS_BFu0s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu0s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_Uc.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_Uc.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_Uc(Test_aS_BFu0s_Uc, "aS_BFu0s_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_Ui()
{
  {
    init_simple_test("aS_BFu0s_Ui");
    static aS_BFu0s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu0s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_Ui.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_Ui.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_Ui(Test_aS_BFu0s_Ui, "aS_BFu0s_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_Ul()
{
  {
    init_simple_test("aS_BFu0s_Ul");
    static aS_BFu0s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu0s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_Ul.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_Ul.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_Ul(Test_aS_BFu0s_Ul, "aS_BFu0s_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_Us()
{
  {
    init_simple_test("aS_BFu0s_Us");
    static aS_BFu0s_Us lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu0s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_Us.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_Us.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_Us(Test_aS_BFu0s_Us, "aS_BFu0s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu0s_Vp()
{
  {
    init_simple_test("aS_BFu0s_Vp");
    static aS_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_BFu0s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_Vp.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_Vp.v2");
  }
}
static Arrange_To_Call_Me vaS_BFu0s_Vp(Test_aS_BFu0s_Vp, "aS_BFu0s_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu15i_BFu0c()
{
  {
    init_simple_test("aS_BFu15i_BFu0c");
    static aS_BFu15i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu15i_BFu0c(Test_aS_BFu15i_BFu0c, "aS_BFu15i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu15i_BFu0i()
{
  {
    init_simple_test("aS_BFu15i_BFu0i");
    static aS_BFu15i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu15i_BFu0i(Test_aS_BFu15i_BFu0i, "aS_BFu15i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu15i_BFu0ll()
{
  {
    init_simple_test("aS_BFu15i_BFu0ll");
    static aS_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu15i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu15i_BFu0ll(Test_aS_BFu15i_BFu0ll, "aS_BFu15i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu15i_BFu0s()
{
  {
    init_simple_test("aS_BFu15i_BFu0s");
    static aS_BFu15i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu15i_BFu0s(Test_aS_BFu15i_BFu0s, "aS_BFu15i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu15ll_BFu0c()
{
  {
    init_simple_test("aS_BFu15ll_BFu0c");
    static aS_BFu15ll_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu15ll_BFu0c(Test_aS_BFu15ll_BFu0c, "aS_BFu15ll_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu15ll_BFu0i()
{
  {
    init_simple_test("aS_BFu15ll_BFu0i");
    static aS_BFu15ll_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu15ll_BFu0i(Test_aS_BFu15ll_BFu0i, "aS_BFu15ll_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu15ll_BFu0ll()
{
  {
    init_simple_test("aS_BFu15ll_BFu0ll");
    static aS_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu15ll_BFu0ll(Test_aS_BFu15ll_BFu0ll, "aS_BFu15ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu15ll_BFu0s()
{
  {
    init_simple_test("aS_BFu15ll_BFu0s");
    static aS_BFu15ll_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu15ll_BFu0s(Test_aS_BFu15ll_BFu0s, "aS_BFu15ll_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu15s_BFu0c()
{
  {
    init_simple_test("aS_BFu15s_BFu0c");
    static aS_BFu15s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu15s_BFu0c(Test_aS_BFu15s_BFu0c, "aS_BFu15s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu15s_BFu0i()
{
  {
    init_simple_test("aS_BFu15s_BFu0i");
    static aS_BFu15s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu15s_BFu0i(Test_aS_BFu15s_BFu0i, "aS_BFu15s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu15s_BFu0ll()
{
  {
    init_simple_test("aS_BFu15s_BFu0ll");
    static aS_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu15s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu15s_BFu0ll(Test_aS_BFu15s_BFu0ll, "aS_BFu15s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu15s_BFu0s()
{
  {
    init_simple_test("aS_BFu15s_BFu0s");
    static aS_BFu15s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu15s_BFu0s(Test_aS_BFu15s_BFu0s, "aS_BFu15s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu16i_BFu0c()
{
  {
    init_simple_test("aS_BFu16i_BFu0c");
    static aS_BFu16i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu16i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu16i_BFu0c(Test_aS_BFu16i_BFu0c, "aS_BFu16i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu16i_BFu0i()
{
  {
    init_simple_test("aS_BFu16i_BFu0i");
    static aS_BFu16i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu16i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu16i_BFu0i(Test_aS_BFu16i_BFu0i, "aS_BFu16i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu16i_BFu0ll()
{
  {
    init_simple_test("aS_BFu16i_BFu0ll");
    static aS_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu16i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu16i_BFu0ll(Test_aS_BFu16i_BFu0ll, "aS_BFu16i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu16i_BFu0s()
{
  {
    init_simple_test("aS_BFu16i_BFu0s");
    static aS_BFu16i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu16i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu16i_BFu0s(Test_aS_BFu16i_BFu0s, "aS_BFu16i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu16ll_BFu0c()
{
  {
    init_simple_test("aS_BFu16ll_BFu0c");
    static aS_BFu16ll_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu16ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu16ll_BFu0c(Test_aS_BFu16ll_BFu0c, "aS_BFu16ll_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu16ll_BFu0i()
{
  {
    init_simple_test("aS_BFu16ll_BFu0i");
    static aS_BFu16ll_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu16ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu16ll_BFu0i(Test_aS_BFu16ll_BFu0i, "aS_BFu16ll_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu16ll_BFu0ll()
{
  {
    init_simple_test("aS_BFu16ll_BFu0ll");
    static aS_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu16ll_BFu0ll(Test_aS_BFu16ll_BFu0ll, "aS_BFu16ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu16ll_BFu0s()
{
  {
    init_simple_test("aS_BFu16ll_BFu0s");
    static aS_BFu16ll_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu16ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu16ll_BFu0s(Test_aS_BFu16ll_BFu0s, "aS_BFu16ll_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu16s_BFu0c()
{
  {
    init_simple_test("aS_BFu16s_BFu0c");
    static aS_BFu16s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu16s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu16s_BFu0c(Test_aS_BFu16s_BFu0c, "aS_BFu16s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu16s_BFu0i()
{
  {
    init_simple_test("aS_BFu16s_BFu0i");
    static aS_BFu16s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu16s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu16s_BFu0i(Test_aS_BFu16s_BFu0i, "aS_BFu16s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu16s_BFu0ll()
{
  {
    init_simple_test("aS_BFu16s_BFu0ll");
    static aS_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu16s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu16s_BFu0ll(Test_aS_BFu16s_BFu0ll, "aS_BFu16s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu16s_BFu0s()
{
  {
    init_simple_test("aS_BFu16s_BFu0s");
    static aS_BFu16s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu16s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu16s_BFu0s(Test_aS_BFu16s_BFu0s, "aS_BFu16s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu17i_BFu0c()
{
  {
    init_simple_test("aS_BFu17i_BFu0c");
    static aS_BFu17i_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu17i_BFu0c(Test_aS_BFu17i_BFu0c, "aS_BFu17i_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu17i_BFu0i()
{
  {
    init_simple_test("aS_BFu17i_BFu0i");
    static aS_BFu17i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu17i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu17i_BFu0i(Test_aS_BFu17i_BFu0i, "aS_BFu17i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu17i_BFu0ll()
{
  {
    init_simple_test("aS_BFu17i_BFu0ll");
    static aS_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu17i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu17i_BFu0ll(Test_aS_BFu17i_BFu0ll, "aS_BFu17i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu17i_BFu0s()
{
  {
    init_simple_test("aS_BFu17i_BFu0s");
    static aS_BFu17i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aS_BFu17i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu17i_BFu0s(Test_aS_BFu17i_BFu0s, "aS_BFu17i_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu17ll_BFu0c()
{
  {
    init_simple_test("aS_BFu17ll_BFu0c");
    static aS_BFu17ll_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu17ll_BFu0c(Test_aS_BFu17ll_BFu0c, "aS_BFu17ll_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu17ll_BFu0i()
{
  {
    init_simple_test("aS_BFu17ll_BFu0i");
    static aS_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu17ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu17ll_BFu0i(Test_aS_BFu17ll_BFu0i, "aS_BFu17ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu17ll_BFu0ll()
{
  {
    init_simple_test("aS_BFu17ll_BFu0ll");
    static aS_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu17ll_BFu0ll(Test_aS_BFu17ll_BFu0ll, "aS_BFu17ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu17ll_BFu0s()
{
  {
    init_simple_test("aS_BFu17ll_BFu0s");
    static aS_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aS_BFu17ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu17ll_BFu0s(Test_aS_BFu17ll_BFu0s, "aS_BFu17ll_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1c_BFu0c()
{
  {
    init_simple_test("aS_BFu1c_BFu0c");
    static aS_BFu1c_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu1c_BFu0c(Test_aS_BFu1c_BFu0c, "aS_BFu1c_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1c_BFu0i()
{
  {
    init_simple_test("aS_BFu1c_BFu0i");
    static aS_BFu1c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu1c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu1c_BFu0i(Test_aS_BFu1c_BFu0i, "aS_BFu1c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1c_BFu0ll()
{
  {
    init_simple_test("aS_BFu1c_BFu0ll");
    static aS_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu1c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu1c_BFu0ll(Test_aS_BFu1c_BFu0ll, "aS_BFu1c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1c_BFu0s()
{
  {
    init_simple_test("aS_BFu1c_BFu0s");
    static aS_BFu1c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu1c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu1c_BFu0s(Test_aS_BFu1c_BFu0s, "aS_BFu1c_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1i_BFu0c()
{
  {
    init_simple_test("aS_BFu1i_BFu0c");
    static aS_BFu1i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu1i_BFu0c(Test_aS_BFu1i_BFu0c, "aS_BFu1i_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1i_BFu0i()
{
  {
    init_simple_test("aS_BFu1i_BFu0i");
    static aS_BFu1i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu1i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu1i_BFu0i(Test_aS_BFu1i_BFu0i, "aS_BFu1i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1i_BFu0ll()
{
  {
    init_simple_test("aS_BFu1i_BFu0ll");
    static aS_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu1i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu1i_BFu0ll(Test_aS_BFu1i_BFu0ll, "aS_BFu1i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1i_BFu0s()
{
  {
    init_simple_test("aS_BFu1i_BFu0s");
    static aS_BFu1i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu1i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu1i_BFu0s(Test_aS_BFu1i_BFu0s, "aS_BFu1i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1ll_BFu0c()
{
  {
    init_simple_test("aS_BFu1ll_BFu0c");
    static aS_BFu1ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu1ll_BFu0c(Test_aS_BFu1ll_BFu0c, "aS_BFu1ll_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1ll_BFu0i()
{
  {
    init_simple_test("aS_BFu1ll_BFu0i");
    static aS_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu1ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu1ll_BFu0i(Test_aS_BFu1ll_BFu0i, "aS_BFu1ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1ll_BFu0ll()
{
  {
    init_simple_test("aS_BFu1ll_BFu0ll");
    static aS_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu1ll_BFu0ll(Test_aS_BFu1ll_BFu0ll, "aS_BFu1ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1ll_BFu0s()
{
  {
    init_simple_test("aS_BFu1ll_BFu0s");
    static aS_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu1ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu1ll_BFu0s(Test_aS_BFu1ll_BFu0s, "aS_BFu1ll_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1s_BFu0c()
{
  {
    init_simple_test("aS_BFu1s_BFu0c");
    static aS_BFu1s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu1s_BFu0c(Test_aS_BFu1s_BFu0c, "aS_BFu1s_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1s_BFu0i()
{
  {
    init_simple_test("aS_BFu1s_BFu0i");
    static aS_BFu1s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu1s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu1s_BFu0i(Test_aS_BFu1s_BFu0i, "aS_BFu1s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1s_BFu0ll()
{
  {
    init_simple_test("aS_BFu1s_BFu0ll");
    static aS_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu1s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu1s_BFu0ll(Test_aS_BFu1s_BFu0ll, "aS_BFu1s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu1s_BFu0s()
{
  {
    init_simple_test("aS_BFu1s_BFu0s");
    static aS_BFu1s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu1s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu1s_BFu0s(Test_aS_BFu1s_BFu0s, "aS_BFu1s_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu31i_BFu0c()
{
  {
    init_simple_test("aS_BFu31i_BFu0c");
    static aS_BFu31i_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu31i_BFu0c(Test_aS_BFu31i_BFu0c, "aS_BFu31i_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu31i_BFu0i()
{
  {
    init_simple_test("aS_BFu31i_BFu0i");
    static aS_BFu31i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu31i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu31i_BFu0i(Test_aS_BFu31i_BFu0i, "aS_BFu31i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu31i_BFu0ll()
{
  {
    init_simple_test("aS_BFu31i_BFu0ll");
    static aS_BFu31i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu31i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu31i_BFu0ll(Test_aS_BFu31i_BFu0ll, "aS_BFu31i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu31i_BFu0s()
{
  {
    init_simple_test("aS_BFu31i_BFu0s");
    static aS_BFu31i_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu31i_BFu0s(Test_aS_BFu31i_BFu0s, "aS_BFu31i_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu31ll_BFu0c()
{
  {
    init_simple_test("aS_BFu31ll_BFu0c");
    static aS_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu31ll_BFu0c(Test_aS_BFu31ll_BFu0c, "aS_BFu31ll_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu31ll_BFu0i()
{
  {
    init_simple_test("aS_BFu31ll_BFu0i");
    static aS_BFu31ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu31ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu31ll_BFu0i(Test_aS_BFu31ll_BFu0i, "aS_BFu31ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu31ll_BFu0ll()
{
  {
    init_simple_test("aS_BFu31ll_BFu0ll");
    static aS_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu31ll_BFu0ll(Test_aS_BFu31ll_BFu0ll, "aS_BFu31ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu31ll_BFu0s()
{
  {
    init_simple_test("aS_BFu31ll_BFu0s");
    static aS_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu31ll_BFu0s(Test_aS_BFu31ll_BFu0s, "aS_BFu31ll_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu32i_BFu0c()
{
  {
    init_simple_test("aS_BFu32i_BFu0c");
    static aS_BFu32i_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu32i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu32i_BFu0c(Test_aS_BFu32i_BFu0c, "aS_BFu32i_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu32i_BFu0i()
{
  {
    init_simple_test("aS_BFu32i_BFu0i");
    static aS_BFu32i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu32i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu32i_BFu0i(Test_aS_BFu32i_BFu0i, "aS_BFu32i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu32i_BFu0ll()
{
  {
    init_simple_test("aS_BFu32i_BFu0ll");
    static aS_BFu32i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu32i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu32i_BFu0ll(Test_aS_BFu32i_BFu0ll, "aS_BFu32i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu32i_BFu0s()
{
  {
    init_simple_test("aS_BFu32i_BFu0s");
    static aS_BFu32i_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu32i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu32i_BFu0s(Test_aS_BFu32i_BFu0s, "aS_BFu32i_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu32ll_BFu0c()
{
  {
    init_simple_test("aS_BFu32ll_BFu0c");
    static aS_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu32ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu32ll_BFu0c(Test_aS_BFu32ll_BFu0c, "aS_BFu32ll_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu32ll_BFu0i()
{
  {
    init_simple_test("aS_BFu32ll_BFu0i");
    static aS_BFu32ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu32ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu32ll_BFu0i(Test_aS_BFu32ll_BFu0i, "aS_BFu32ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu32ll_BFu0ll()
{
  {
    init_simple_test("aS_BFu32ll_BFu0ll");
    static aS_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu32ll_BFu0ll(Test_aS_BFu32ll_BFu0ll, "aS_BFu32ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu32ll_BFu0s()
{
  {
    init_simple_test("aS_BFu32ll_BFu0s");
    static aS_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu32ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu32ll_BFu0s(Test_aS_BFu32ll_BFu0s, "aS_BFu32ll_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu33_BFu0c()
{
  {
    init_simple_test("aS_BFu33_BFu0c");
    static aS_BFu33_BFu0c lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu33_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu33_BFu0c(Test_aS_BFu33_BFu0c, "aS_BFu33_BFu0c", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu33_BFu0i()
{
  {
    init_simple_test("aS_BFu33_BFu0i");
    static aS_BFu33_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu33_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu33_BFu0i(Test_aS_BFu33_BFu0i, "aS_BFu33_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu33_BFu0ll()
{
  {
    init_simple_test("aS_BFu33_BFu0ll");
    static aS_BFu33_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu33_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu33_BFu0ll(Test_aS_BFu33_BFu0ll, "aS_BFu33_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu33_BFu0s()
{
  {
    init_simple_test("aS_BFu33_BFu0s");
    static aS_BFu33_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_BFu33_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu33_BFu0s(Test_aS_BFu33_BFu0s, "aS_BFu33_BFu0s", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7c_BFu0c()
{
  {
    init_simple_test("aS_BFu7c_BFu0c");
    static aS_BFu7c_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu7c_BFu0c(Test_aS_BFu7c_BFu0c, "aS_BFu7c_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7c_BFu0i()
{
  {
    init_simple_test("aS_BFu7c_BFu0i");
    static aS_BFu7c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu7c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu7c_BFu0i(Test_aS_BFu7c_BFu0i, "aS_BFu7c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7c_BFu0ll()
{
  {
    init_simple_test("aS_BFu7c_BFu0ll");
    static aS_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu7c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu7c_BFu0ll(Test_aS_BFu7c_BFu0ll, "aS_BFu7c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7c_BFu0s()
{
  {
    init_simple_test("aS_BFu7c_BFu0s");
    static aS_BFu7c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu7c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu7c_BFu0s(Test_aS_BFu7c_BFu0s, "aS_BFu7c_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7i_BFu0c()
{
  {
    init_simple_test("aS_BFu7i_BFu0c");
    static aS_BFu7i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu7i_BFu0c(Test_aS_BFu7i_BFu0c, "aS_BFu7i_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7i_BFu0i()
{
  {
    init_simple_test("aS_BFu7i_BFu0i");
    static aS_BFu7i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu7i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu7i_BFu0i(Test_aS_BFu7i_BFu0i, "aS_BFu7i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7i_BFu0ll()
{
  {
    init_simple_test("aS_BFu7i_BFu0ll");
    static aS_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu7i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu7i_BFu0ll(Test_aS_BFu7i_BFu0ll, "aS_BFu7i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7i_BFu0s()
{
  {
    init_simple_test("aS_BFu7i_BFu0s");
    static aS_BFu7i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu7i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu7i_BFu0s(Test_aS_BFu7i_BFu0s, "aS_BFu7i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7ll_BFu0c()
{
  {
    init_simple_test("aS_BFu7ll_BFu0c");
    static aS_BFu7ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu7ll_BFu0c(Test_aS_BFu7ll_BFu0c, "aS_BFu7ll_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7ll_BFu0i()
{
  {
    init_simple_test("aS_BFu7ll_BFu0i");
    static aS_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu7ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu7ll_BFu0i(Test_aS_BFu7ll_BFu0i, "aS_BFu7ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7ll_BFu0ll()
{
  {
    init_simple_test("aS_BFu7ll_BFu0ll");
    static aS_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu7ll_BFu0ll(Test_aS_BFu7ll_BFu0ll, "aS_BFu7ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7ll_BFu0s()
{
  {
    init_simple_test("aS_BFu7ll_BFu0s");
    static aS_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu7ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu7ll_BFu0s(Test_aS_BFu7ll_BFu0s, "aS_BFu7ll_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7s_BFu0c()
{
  {
    init_simple_test("aS_BFu7s_BFu0c");
    static aS_BFu7s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu7s_BFu0c(Test_aS_BFu7s_BFu0c, "aS_BFu7s_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7s_BFu0i()
{
  {
    init_simple_test("aS_BFu7s_BFu0i");
    static aS_BFu7s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu7s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu7s_BFu0i(Test_aS_BFu7s_BFu0i, "aS_BFu7s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7s_BFu0ll()
{
  {
    init_simple_test("aS_BFu7s_BFu0ll");
    static aS_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu7s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu7s_BFu0ll(Test_aS_BFu7s_BFu0ll, "aS_BFu7s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu7s_BFu0s()
{
  {
    init_simple_test("aS_BFu7s_BFu0s");
    static aS_BFu7s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu7s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu7s_BFu0s(Test_aS_BFu7s_BFu0s, "aS_BFu7s_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8c_BFu0c()
{
  {
    init_simple_test("aS_BFu8c_BFu0c");
    static aS_BFu8c_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu8c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu8c_BFu0c(Test_aS_BFu8c_BFu0c, "aS_BFu8c_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8c_BFu0i()
{
  {
    init_simple_test("aS_BFu8c_BFu0i");
    static aS_BFu8c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu8c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu8c_BFu0i(Test_aS_BFu8c_BFu0i, "aS_BFu8c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8c_BFu0ll()
{
  {
    init_simple_test("aS_BFu8c_BFu0ll");
    static aS_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu8c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu8c_BFu0ll(Test_aS_BFu8c_BFu0ll, "aS_BFu8c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8c_BFu0s()
{
  {
    init_simple_test("aS_BFu8c_BFu0s");
    static aS_BFu8c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu8c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu8c_BFu0s(Test_aS_BFu8c_BFu0s, "aS_BFu8c_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8i_BFu0c()
{
  {
    init_simple_test("aS_BFu8i_BFu0c");
    static aS_BFu8i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu8i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8i_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu8i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8i_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu8i_BFu0c(Test_aS_BFu8i_BFu0c, "aS_BFu8i_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8i_BFu0i()
{
  {
    init_simple_test("aS_BFu8i_BFu0i");
    static aS_BFu8i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu8i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8i_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu8i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8i_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu8i_BFu0i(Test_aS_BFu8i_BFu0i, "aS_BFu8i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8i_BFu0ll()
{
  {
    init_simple_test("aS_BFu8i_BFu0ll");
    static aS_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu8i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu8i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu8i_BFu0ll(Test_aS_BFu8i_BFu0ll, "aS_BFu8i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8i_BFu0s()
{
  {
    init_simple_test("aS_BFu8i_BFu0s");
    static aS_BFu8i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu8i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8i_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu8i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8i_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu8i_BFu0s(Test_aS_BFu8i_BFu0s, "aS_BFu8i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8ll_BFu0c()
{
  {
    init_simple_test("aS_BFu8ll_BFu0c");
    static aS_BFu8ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu8ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu8ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu8ll_BFu0c(Test_aS_BFu8ll_BFu0c, "aS_BFu8ll_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8ll_BFu0i()
{
  {
    init_simple_test("aS_BFu8ll_BFu0i");
    static aS_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu8ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu8ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu8ll_BFu0i(Test_aS_BFu8ll_BFu0i, "aS_BFu8ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8ll_BFu0ll()
{
  {
    init_simple_test("aS_BFu8ll_BFu0ll");
    static aS_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu8ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu8ll_BFu0ll(Test_aS_BFu8ll_BFu0ll, "aS_BFu8ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8ll_BFu0s()
{
  {
    init_simple_test("aS_BFu8ll_BFu0s");
    static aS_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu8ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu8ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu8ll_BFu0s(Test_aS_BFu8ll_BFu0s, "aS_BFu8ll_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8s_BFu0c()
{
  {
    init_simple_test("aS_BFu8s_BFu0c");
    static aS_BFu8s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu8s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8s_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu8s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8s_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu8s_BFu0c(Test_aS_BFu8s_BFu0c, "aS_BFu8s_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8s_BFu0i()
{
  {
    init_simple_test("aS_BFu8s_BFu0i");
    static aS_BFu8s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu8s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8s_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu8s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8s_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu8s_BFu0i(Test_aS_BFu8s_BFu0i, "aS_BFu8s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8s_BFu0ll()
{
  {
    init_simple_test("aS_BFu8s_BFu0ll");
    static aS_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu8s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu8s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu8s_BFu0ll(Test_aS_BFu8s_BFu0ll, "aS_BFu8s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu8s_BFu0s()
{
  {
    init_simple_test("aS_BFu8s_BFu0s");
    static aS_BFu8s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu8s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8s_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu8s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8s_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu8s_BFu0s(Test_aS_BFu8s_BFu0s, "aS_BFu8s_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu9i_BFu0c()
{
  {
    init_simple_test("aS_BFu9i_BFu0c");
    static aS_BFu9i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu9i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu9i_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu9i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu9i_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu9i_BFu0c(Test_aS_BFu9i_BFu0c, "aS_BFu9i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu9i_BFu0i()
{
  {
    init_simple_test("aS_BFu9i_BFu0i");
    static aS_BFu9i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu9i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu9i_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu9i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu9i_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu9i_BFu0i(Test_aS_BFu9i_BFu0i, "aS_BFu9i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu9i_BFu0ll()
{
  {
    init_simple_test("aS_BFu9i_BFu0ll");
    static aS_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu9i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu9i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu9i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu9i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu9i_BFu0ll(Test_aS_BFu9i_BFu0ll, "aS_BFu9i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu9i_BFu0s()
{
  {
    init_simple_test("aS_BFu9i_BFu0s");
    static aS_BFu9i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu9i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu9i_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu9i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu9i_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu9i_BFu0s(Test_aS_BFu9i_BFu0s, "aS_BFu9i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu9ll_BFu0c()
{
  {
    init_simple_test("aS_BFu9ll_BFu0c");
    static aS_BFu9ll_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu9ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu9ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu9ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu9ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu9ll_BFu0c(Test_aS_BFu9ll_BFu0c, "aS_BFu9ll_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu9ll_BFu0i()
{
  {
    init_simple_test("aS_BFu9ll_BFu0i");
    static aS_BFu9ll_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu9ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu9ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu9ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu9ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu9ll_BFu0i(Test_aS_BFu9ll_BFu0i, "aS_BFu9ll_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu9ll_BFu0ll()
{
  {
    init_simple_test("aS_BFu9ll_BFu0ll");
    static aS_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu9ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu9ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu9ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu9ll_BFu0ll(Test_aS_BFu9ll_BFu0ll, "aS_BFu9ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu9ll_BFu0s()
{
  {
    init_simple_test("aS_BFu9ll_BFu0s");
    static aS_BFu9ll_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu9ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu9ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu9ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu9ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu9ll_BFu0s(Test_aS_BFu9ll_BFu0s, "aS_BFu9ll_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu9s_BFu0c()
{
  {
    init_simple_test("aS_BFu9s_BFu0c");
    static aS_BFu9s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu9s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu9s_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_BFu9s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu9s_BFu0c");
  }
}
static Arrange_To_Call_Me vaS_BFu9s_BFu0c(Test_aS_BFu9s_BFu0c, "aS_BFu9s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu9s_BFu0i()
{
  {
    init_simple_test("aS_BFu9s_BFu0i");
    static aS_BFu9s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu9s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu9s_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_BFu9s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu9s_BFu0i");
  }
}
static Arrange_To_Call_Me vaS_BFu9s_BFu0i(Test_aS_BFu9s_BFu0i, "aS_BFu9s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu9s_BFu0ll()
{
  {
    init_simple_test("aS_BFu9s_BFu0ll");
    static aS_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu9s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu9s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_BFu9s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu9s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaS_BFu9s_BFu0ll(Test_aS_BFu9s_BFu0ll, "aS_BFu9s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_BFu9s_BFu0s()
{
  {
    init_simple_test("aS_BFu9s_BFu0s");
    static aS_BFu9s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu9s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu9s_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_BFu9s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aS_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aS_BFu9s_BFu0s");
  }
}
static Arrange_To_Call_Me vaS_BFu9s_BFu0s(Test_aS_BFu9s_BFu0s, "aS_BFu9s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_C_BFu0c()
{
  {
    init_simple_test("aS_C_BFu0c");
    static aS_C_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_C_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_C_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_C_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_C_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaS_C_BFu0c(Test_aS_C_BFu0c, "aS_C_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_C_BFu0i()
{
  {
    init_simple_test("aS_C_BFu0i");
    static aS_C_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_C_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_C_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_C_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_C_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaS_C_BFu0i(Test_aS_C_BFu0i, "aS_C_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_C_BFu0ll()
{
  {
    init_simple_test("aS_C_BFu0ll");
    static aS_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_C_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_C_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_C_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_C_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaS_C_BFu0ll(Test_aS_C_BFu0ll, "aS_C_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_C_BFu0s()
{
  {
    init_simple_test("aS_C_BFu0s");
    static aS_C_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_C_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_C_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_C_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_C_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaS_C_BFu0s(Test_aS_C_BFu0s, "aS_C_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_D_BFu0c()
{
  {
    init_simple_test("aS_D_BFu0c");
    static aS_D_BFu0c lv;
    check2(sizeof(lv), 10, "sizeof(aS_D_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_D_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_D_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_D_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaS_D_BFu0c(Test_aS_D_BFu0c, "aS_D_BFu0c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_D_BFu0i()
{
  {
    init_simple_test("aS_D_BFu0i");
    static aS_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aS_D_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_D_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_D_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_D_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaS_D_BFu0i(Test_aS_D_BFu0i, "aS_D_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_D_BFu0ll()
{
  {
    init_simple_test("aS_D_BFu0ll");
    static aS_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aS_D_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_D_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_D_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaS_D_BFu0ll(Test_aS_D_BFu0ll, "aS_D_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_D_BFu0s()
{
  {
    init_simple_test("aS_D_BFu0s");
    static aS_D_BFu0s lv;
    check2(sizeof(lv), 10, "sizeof(aS_D_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_D_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_D_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_D_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaS_D_BFu0s(Test_aS_D_BFu0s, "aS_D_BFu0s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_F_BFu0c()
{
  {
    init_simple_test("aS_F_BFu0c");
    static aS_F_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aS_F_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_F_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_F_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_F_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaS_F_BFu0c(Test_aS_F_BFu0c, "aS_F_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_F_BFu0i()
{
  {
    init_simple_test("aS_F_BFu0i");
    static aS_F_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_F_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_F_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_F_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_F_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaS_F_BFu0i(Test_aS_F_BFu0i, "aS_F_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_F_BFu0ll()
{
  {
    init_simple_test("aS_F_BFu0ll");
    static aS_F_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_F_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_F_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_F_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaS_F_BFu0ll(Test_aS_F_BFu0ll, "aS_F_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_F_BFu0s()
{
  {
    init_simple_test("aS_F_BFu0s");
    static aS_F_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aS_F_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_F_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_F_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_F_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaS_F_BFu0s(Test_aS_F_BFu0s, "aS_F_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_I_BFu0c()
{
  {
    init_simple_test("aS_I_BFu0c");
    static aS_I_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aS_I_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_I_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_I_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_I_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaS_I_BFu0c(Test_aS_I_BFu0c, "aS_I_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_I_BFu0i()
{
  {
    init_simple_test("aS_I_BFu0i");
    static aS_I_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_I_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_I_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_I_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_I_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaS_I_BFu0i(Test_aS_I_BFu0i, "aS_I_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_I_BFu0ll()
{
  {
    init_simple_test("aS_I_BFu0ll");
    static aS_I_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_I_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_I_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_I_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaS_I_BFu0ll(Test_aS_I_BFu0ll, "aS_I_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_I_BFu0s()
{
  {
    init_simple_test("aS_I_BFu0s");
    static aS_I_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aS_I_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_I_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_I_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_I_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaS_I_BFu0s(Test_aS_I_BFu0s, "aS_I_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Ip_BFu0c()
{
  {
    init_simple_test("aS_Ip_BFu0c");
    static aS_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_Ip_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_Ip_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_Ip_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaS_Ip_BFu0c(Test_aS_Ip_BFu0c, "aS_Ip_BFu0c", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Ip_BFu0i()
{
  {
    init_simple_test("aS_Ip_BFu0i");
    static aS_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_Ip_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_Ip_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_Ip_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaS_Ip_BFu0i(Test_aS_Ip_BFu0i, "aS_Ip_BFu0i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Ip_BFu0ll()
{
  {
    init_simple_test("aS_Ip_BFu0ll");
    static aS_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aS_Ip_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Ip_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_Ip_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_Ip_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaS_Ip_BFu0ll(Test_aS_Ip_BFu0ll, "aS_Ip_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Ip_BFu0s()
{
  {
    init_simple_test("aS_Ip_BFu0s");
    static aS_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_Ip_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Ip_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_Ip_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_Ip_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaS_Ip_BFu0s(Test_aS_Ip_BFu0s, "aS_Ip_BFu0s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_L_BFu0c()
{
  {
    init_simple_test("aS_L_BFu0c");
    static aS_L_BFu0c lv;
    check2(sizeof(lv), 10, "sizeof(aS_L_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_L_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_L_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_L_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaS_L_BFu0c(Test_aS_L_BFu0c, "aS_L_BFu0c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_L_BFu0i()
{
  {
    init_simple_test("aS_L_BFu0i");
    static aS_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aS_L_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_L_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_L_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_L_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaS_L_BFu0i(Test_aS_L_BFu0i, "aS_L_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_L_BFu0ll()
{
  {
    init_simple_test("aS_L_BFu0ll");
    static aS_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aS_L_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_L_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_L_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_L_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaS_L_BFu0ll(Test_aS_L_BFu0ll, "aS_L_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_L_BFu0s()
{
  {
    init_simple_test("aS_L_BFu0s");
    static aS_L_BFu0s lv;
    check2(sizeof(lv), 10, "sizeof(aS_L_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_L_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_L_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_L_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaS_L_BFu0s(Test_aS_L_BFu0s, "aS_L_BFu0s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_S_BFu0c()
{
  {
    init_simple_test("aS_S_BFu0c");
    static aS_S_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aS_S_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_S_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_S_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_S_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaS_S_BFu0c(Test_aS_S_BFu0c, "aS_S_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_S_BFu0i()
{
  {
    init_simple_test("aS_S_BFu0i");
    static aS_S_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aS_S_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_S_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_S_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_S_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaS_S_BFu0i(Test_aS_S_BFu0i, "aS_S_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_S_BFu0ll()
{
  {
    init_simple_test("aS_S_BFu0ll");
    static aS_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_S_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_S_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_S_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_S_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaS_S_BFu0ll(Test_aS_S_BFu0ll, "aS_S_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_S_BFu0s()
{
  {
    init_simple_test("aS_S_BFu0s");
    static aS_S_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aS_S_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_S_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_S_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_S_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaS_S_BFu0s(Test_aS_S_BFu0s, "aS_S_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Uc_BFu0c()
{
  {
    init_simple_test("aS_Uc_BFu0c");
    static aS_Uc_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aS_Uc_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Uc_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_Uc_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_Uc_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaS_Uc_BFu0c(Test_aS_Uc_BFu0c, "aS_Uc_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Uc_BFu0i()
{
  {
    init_simple_test("aS_Uc_BFu0i");
    static aS_Uc_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_Uc_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Uc_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_Uc_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_Uc_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaS_Uc_BFu0i(Test_aS_Uc_BFu0i, "aS_Uc_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Uc_BFu0ll()
{
  {
    init_simple_test("aS_Uc_BFu0ll");
    static aS_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_Uc_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Uc_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_Uc_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_Uc_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaS_Uc_BFu0ll(Test_aS_Uc_BFu0ll, "aS_Uc_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Uc_BFu0s()
{
  {
    init_simple_test("aS_Uc_BFu0s");
    static aS_Uc_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_Uc_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Uc_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_Uc_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_Uc_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaS_Uc_BFu0s(Test_aS_Uc_BFu0s, "aS_Uc_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Ui_BFu0c()
{
  {
    init_simple_test("aS_Ui_BFu0c");
    static aS_Ui_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aS_Ui_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Ui_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_Ui_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_Ui_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaS_Ui_BFu0c(Test_aS_Ui_BFu0c, "aS_Ui_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Ui_BFu0i()
{
  {
    init_simple_test("aS_Ui_BFu0i");
    static aS_Ui_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_Ui_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Ui_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_Ui_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_Ui_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaS_Ui_BFu0i(Test_aS_Ui_BFu0i, "aS_Ui_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Ui_BFu0ll()
{
  {
    init_simple_test("aS_Ui_BFu0ll");
    static aS_Ui_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aS_Ui_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Ui_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_Ui_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_Ui_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaS_Ui_BFu0ll(Test_aS_Ui_BFu0ll, "aS_Ui_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Ui_BFu0s()
{
  {
    init_simple_test("aS_Ui_BFu0s");
    static aS_Ui_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aS_Ui_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Ui_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_Ui_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_Ui_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaS_Ui_BFu0s(Test_aS_Ui_BFu0s, "aS_Ui_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Ul_BFu0c()
{
  {
    init_simple_test("aS_Ul_BFu0c");
    static aS_Ul_BFu0c lv;
    check2(sizeof(lv), 10, "sizeof(aS_Ul_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Ul_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_Ul_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_Ul_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaS_Ul_BFu0c(Test_aS_Ul_BFu0c, "aS_Ul_BFu0c", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Ul_BFu0i()
{
  {
    init_simple_test("aS_Ul_BFu0i");
    static aS_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aS_Ul_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Ul_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_Ul_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_Ul_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaS_Ul_BFu0i(Test_aS_Ul_BFu0i, "aS_Ul_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Ul_BFu0ll()
{
  {
    init_simple_test("aS_Ul_BFu0ll");
    static aS_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aS_Ul_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Ul_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_Ul_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_Ul_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaS_Ul_BFu0ll(Test_aS_Ul_BFu0ll, "aS_Ul_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Ul_BFu0s()
{
  {
    init_simple_test("aS_Ul_BFu0s");
    static aS_Ul_BFu0s lv;
    check2(sizeof(lv), 10, "sizeof(aS_Ul_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Ul_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_Ul_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_Ul_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaS_Ul_BFu0s(Test_aS_Ul_BFu0s, "aS_Ul_BFu0s", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Us_BFu0c()
{
  {
    init_simple_test("aS_Us_BFu0c");
    static aS_Us_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aS_Us_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Us_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_Us_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_Us_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaS_Us_BFu0c(Test_aS_Us_BFu0c, "aS_Us_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Us_BFu0i()
{
  {
    init_simple_test("aS_Us_BFu0i");
    static aS_Us_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aS_Us_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Us_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_Us_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_Us_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaS_Us_BFu0i(Test_aS_Us_BFu0i, "aS_Us_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Us_BFu0ll()
{
  {
    init_simple_test("aS_Us_BFu0ll");
    static aS_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_Us_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Us_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_Us_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_Us_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaS_Us_BFu0ll(Test_aS_Us_BFu0ll, "aS_Us_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Us_BFu0s()
{
  {
    init_simple_test("aS_Us_BFu0s");
    static aS_Us_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aS_Us_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Us_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_Us_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_Us_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaS_Us_BFu0s(Test_aS_Us_BFu0s, "aS_Us_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Vp_BFu0c()
{
  {
    init_simple_test("aS_Vp_BFu0c");
    static aS_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_Vp_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Vp_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_Vp_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_Vp_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaS_Vp_BFu0c(Test_aS_Vp_BFu0c, "aS_Vp_BFu0c", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Vp_BFu0i()
{
  {
    init_simple_test("aS_Vp_BFu0i");
    static aS_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_Vp_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Vp_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_Vp_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_Vp_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaS_Vp_BFu0i(Test_aS_Vp_BFu0i, "aS_Vp_BFu0i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Vp_BFu0ll()
{
  {
    init_simple_test("aS_Vp_BFu0ll");
    static aS_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aS_Vp_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Vp_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_Vp_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_Vp_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaS_Vp_BFu0ll(Test_aS_Vp_BFu0ll, "aS_Vp_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aS_Vp_BFu0s()
{
  {
    init_simple_test("aS_Vp_BFu0s");
    static aS_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aS_Vp_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Vp_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_Vp_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_Vp_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaS_Vp_BFu0s(Test_aS_Vp_BFu0s, "aS_Vp_BFu0s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c()
{
  {
    init_simple_test("aUc_BFu0c");
    static aUc_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aUc_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c(Test_aUc_BFu0c, "aUc_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu0c()
{
  {
    init_simple_test("aUc_BFu0c_BFu0c");
    static aUc_BFu0c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aUc_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu0c(Test_aUc_BFu0c_BFu0c, "aUc_BFu0c_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu0i()
{
  {
    init_simple_test("aUc_BFu0c_BFu0i");
    static aUc_BFu0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu0i(Test_aUc_BFu0c_BFu0i, "aUc_BFu0c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu0ll()
{
  {
    init_simple_test("aUc_BFu0c_BFu0ll");
    static aUc_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu0c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu0ll(Test_aUc_BFu0c_BFu0ll, "aUc_BFu0c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu0s()
{
  {
    init_simple_test("aUc_BFu0c_BFu0s");
    static aUc_BFu0c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aUc_BFu0c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu0s(Test_aUc_BFu0c_BFu0s, "aUc_BFu0c_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu15i()
{
  {
    init_simple_test("aUc_BFu0c_BFu15i");
    static aUc_BFu0c_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu0c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu0c_BFu15i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu15i(Test_aUc_BFu0c_BFu15i, "aUc_BFu0c_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu15ll()
{
  {
    init_simple_test("aUc_BFu0c_BFu15ll");
    static aUc_BFu0c_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu0c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu0c_BFu15ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu15ll(Test_aUc_BFu0c_BFu15ll, "aUc_BFu0c_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu15s()
{
  {
    init_simple_test("aUc_BFu0c_BFu15s");
    static aUc_BFu0c_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu0c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu0c_BFu15s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu15s(Test_aUc_BFu0c_BFu15s, "aUc_BFu0c_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu16i()
{
  {
    init_simple_test("aUc_BFu0c_BFu16i");
    static aUc_BFu0c_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu0c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu0c_BFu16i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu16i(Test_aUc_BFu0c_BFu16i, "aUc_BFu0c_BFu16i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu16ll()
{
  {
    init_simple_test("aUc_BFu0c_BFu16ll");
    static aUc_BFu0c_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu0c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu0c_BFu16ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu16ll(Test_aUc_BFu0c_BFu16ll, "aUc_BFu0c_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu16s()
{
  {
    init_simple_test("aUc_BFu0c_BFu16s");
    static aUc_BFu0c_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu0c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu0c_BFu16s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu16s(Test_aUc_BFu0c_BFu16s, "aUc_BFu0c_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu17i()
{
  {
    init_simple_test("aUc_BFu0c_BFu17i");
    static aUc_BFu0c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aUc_BFu0c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aUc_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aUc_BFu0c_BFu17i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu17i(Test_aUc_BFu0c_BFu17i, "aUc_BFu0c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu17ll()
{
  {
    init_simple_test("aUc_BFu0c_BFu17ll");
    static aUc_BFu0c_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aUc_BFu0c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aUc_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aUc_BFu0c_BFu17ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu17ll(Test_aUc_BFu0c_BFu17ll, "aUc_BFu0c_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu1c()
{
  {
    init_simple_test("aUc_BFu0c_BFu1c");
    static aUc_BFu0c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu0c_BFu1c");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu1c(Test_aUc_BFu0c_BFu1c, "aUc_BFu0c_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu1i()
{
  {
    init_simple_test("aUc_BFu0c_BFu1i");
    static aUc_BFu0c_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu0c_BFu1i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu1i(Test_aUc_BFu0c_BFu1i, "aUc_BFu0c_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu1ll()
{
  {
    init_simple_test("aUc_BFu0c_BFu1ll");
    static aUc_BFu0c_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu0c_BFu1ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu1ll(Test_aUc_BFu0c_BFu1ll, "aUc_BFu0c_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu1s()
{
  {
    init_simple_test("aUc_BFu0c_BFu1s");
    static aUc_BFu0c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu0c_BFu1s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu1s(Test_aUc_BFu0c_BFu1s, "aUc_BFu0c_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu31i()
{
  {
    init_simple_test("aUc_BFu0c_BFu31i");
    static aUc_BFu0c_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aUc_BFu0c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aUc_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aUc_BFu0c_BFu31i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu31i(Test_aUc_BFu0c_BFu31i, "aUc_BFu0c_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu31ll()
{
  {
    init_simple_test("aUc_BFu0c_BFu31ll");
    static aUc_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aUc_BFu0c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aUc_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aUc_BFu0c_BFu31ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu31ll(Test_aUc_BFu0c_BFu31ll, "aUc_BFu0c_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu32i()
{
  {
    init_simple_test("aUc_BFu0c_BFu32i");
    static aUc_BFu0c_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(aUc_BFu0c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aUc_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aUc_BFu0c_BFu32i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu32i(Test_aUc_BFu0c_BFu32i, "aUc_BFu0c_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu32ll()
{
  {
    init_simple_test("aUc_BFu0c_BFu32ll");
    static aUc_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(aUc_BFu0c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aUc_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aUc_BFu0c_BFu32ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu32ll(Test_aUc_BFu0c_BFu32ll, "aUc_BFu0c_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu33()
{
  {
    init_simple_test("aUc_BFu0c_BFu33");
    static aUc_BFu0c_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aUc_BFu0c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aUc_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aUc_BFu0c_BFu33");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu33(Test_aUc_BFu0c_BFu33, "aUc_BFu0c_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu7c()
{
  {
    init_simple_test("aUc_BFu0c_BFu7c");
    static aUc_BFu0c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu0c_BFu7c");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu7c(Test_aUc_BFu0c_BFu7c, "aUc_BFu0c_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu7i()
{
  {
    init_simple_test("aUc_BFu0c_BFu7i");
    static aUc_BFu0c_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu0c_BFu7i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu7i(Test_aUc_BFu0c_BFu7i, "aUc_BFu0c_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu7ll()
{
  {
    init_simple_test("aUc_BFu0c_BFu7ll");
    static aUc_BFu0c_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu0c_BFu7ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu7ll(Test_aUc_BFu0c_BFu7ll, "aUc_BFu0c_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu7s()
{
  {
    init_simple_test("aUc_BFu0c_BFu7s");
    static aUc_BFu0c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu0c_BFu7s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu7s(Test_aUc_BFu0c_BFu7s, "aUc_BFu0c_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu8c()
{
  {
    init_simple_test("aUc_BFu0c_BFu8c");
    static aUc_BFu0c_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu0c_BFu8c");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu8c(Test_aUc_BFu0c_BFu8c, "aUc_BFu0c_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu8i()
{
  {
    init_simple_test("aUc_BFu0c_BFu8i");
    static aUc_BFu0c_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu0c_BFu8i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu8i(Test_aUc_BFu0c_BFu8i, "aUc_BFu0c_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu8ll()
{
  {
    init_simple_test("aUc_BFu0c_BFu8ll");
    static aUc_BFu0c_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu0c_BFu8ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu8ll(Test_aUc_BFu0c_BFu8ll, "aUc_BFu0c_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu8s()
{
  {
    init_simple_test("aUc_BFu0c_BFu8s");
    static aUc_BFu0c_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu0c_BFu8s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu8s(Test_aUc_BFu0c_BFu8s, "aUc_BFu0c_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu9i()
{
  {
    init_simple_test("aUc_BFu0c_BFu9i");
    static aUc_BFu0c_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu0c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu0c_BFu9i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu9i(Test_aUc_BFu0c_BFu9i, "aUc_BFu0c_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu9ll()
{
  {
    init_simple_test("aUc_BFu0c_BFu9ll");
    static aUc_BFu0c_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu0c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu0c_BFu9ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu9ll(Test_aUc_BFu0c_BFu9ll, "aUc_BFu0c_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_BFu9s()
{
  {
    init_simple_test("aUc_BFu0c_BFu9s");
    static aUc_BFu0c_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu0c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu0c_BFu9s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_BFu9s(Test_aUc_BFu0c_BFu9s, "aUc_BFu0c_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_C()
{
  {
    init_simple_test("aUc_BFu0c_C");
    static aUc_BFu0c_C lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_C)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_C.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_C.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_C(Test_aUc_BFu0c_C, "aUc_BFu0c_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_D()
{
  {
    init_simple_test("aUc_BFu0c_D");
    static aUc_BFu0c_D lv;
    check2(sizeof(lv), 9, "sizeof(aUc_BFu0c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_D)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_D.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_D.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_D(Test_aUc_BFu0c_D, "aUc_BFu0c_D", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_F()
{
  {
    init_simple_test("aUc_BFu0c_F");
    static aUc_BFu0c_F lv;
    check2(sizeof(lv), 5, "sizeof(aUc_BFu0c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_F)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_F.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_F.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_F(Test_aUc_BFu0c_F, "aUc_BFu0c_F", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_I()
{
  {
    init_simple_test("aUc_BFu0c_I");
    static aUc_BFu0c_I lv;
    check2(sizeof(lv), 5, "sizeof(aUc_BFu0c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_I)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_I.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_I.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_I(Test_aUc_BFu0c_I, "aUc_BFu0c_I", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_Ip()
{
  {
    init_simple_test("aUc_BFu0c_Ip");
    static aUc_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_Ip)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_Ip.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_Ip.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_Ip(Test_aUc_BFu0c_Ip, "aUc_BFu0c_Ip", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_L()
{
  {
    init_simple_test("aUc_BFu0c_L");
    static aUc_BFu0c_L lv;
    check2(sizeof(lv), 9, "sizeof(aUc_BFu0c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_L)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_L.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_L.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_L(Test_aUc_BFu0c_L, "aUc_BFu0c_L", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_S()
{
  {
    init_simple_test("aUc_BFu0c_S");
    static aUc_BFu0c_S lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu0c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_S)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_S.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_S.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_S(Test_aUc_BFu0c_S, "aUc_BFu0c_S", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_Uc()
{
  {
    init_simple_test("aUc_BFu0c_Uc");
    static aUc_BFu0c_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu0c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_Uc)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_Uc.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_Uc.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_Uc(Test_aUc_BFu0c_Uc, "aUc_BFu0c_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_Ui()
{
  {
    init_simple_test("aUc_BFu0c_Ui");
    static aUc_BFu0c_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aUc_BFu0c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_Ui)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_Ui.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_Ui.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_Ui(Test_aUc_BFu0c_Ui, "aUc_BFu0c_Ui", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_Ul()
{
  {
    init_simple_test("aUc_BFu0c_Ul");
    static aUc_BFu0c_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aUc_BFu0c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_Ul)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_Ul.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_Ul.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_Ul(Test_aUc_BFu0c_Ul, "aUc_BFu0c_Ul", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_Us()
{
  {
    init_simple_test("aUc_BFu0c_Us");
    static aUc_BFu0c_Us lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu0c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_Us)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_Us.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_Us.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_Us(Test_aUc_BFu0c_Us, "aUc_BFu0c_Us", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0c_Vp()
{
  {
    init_simple_test("aUc_BFu0c_Vp");
    static aUc_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_Vp)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_Vp.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_Vp.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0c_Vp(Test_aUc_BFu0c_Vp, "aUc_BFu0c_Vp", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i()
{
  {
    init_simple_test("aUc_BFu0i");
    static aUc_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i(Test_aUc_BFu0i, "aUc_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu0c()
{
  {
    init_simple_test("aUc_BFu0i_BFu0c");
    static aUc_BFu0i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu0c(Test_aUc_BFu0i_BFu0c, "aUc_BFu0i_BFu0c", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu0i()
{
  {
    init_simple_test("aUc_BFu0i_BFu0i");
    static aUc_BFu0i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu0i(Test_aUc_BFu0i_BFu0i, "aUc_BFu0i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu0ll()
{
  {
    init_simple_test("aUc_BFu0i_BFu0ll");
    static aUc_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu0i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu0ll(Test_aUc_BFu0i_BFu0ll, "aUc_BFu0i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu0s()
{
  {
    init_simple_test("aUc_BFu0i_BFu0s");
    static aUc_BFu0i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu0s(Test_aUc_BFu0i_BFu0s, "aUc_BFu0i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu15i()
{
  {
    init_simple_test("aUc_BFu0i_BFu15i");
    static aUc_BFu0i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, 1, "aUc_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, hide_ull(1LL<<14), "aUc_BFu0i_BFu15i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu15i(Test_aUc_BFu0i_BFu15i, "aUc_BFu0i_BFu15i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu15ll()
{
  {
    init_simple_test("aUc_BFu0i_BFu15ll");
    static aUc_BFu0i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, 1, "aUc_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, hide_ull(1LL<<14), "aUc_BFu0i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu15ll(Test_aUc_BFu0i_BFu15ll, "aUc_BFu0i_BFu15ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu15s()
{
  {
    init_simple_test("aUc_BFu0i_BFu15s");
    static aUc_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, 1, "aUc_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 15, hide_ull(1LL<<14), "aUc_BFu0i_BFu15s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu15s(Test_aUc_BFu0i_BFu15s, "aUc_BFu0i_BFu15s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu16i()
{
  {
    init_simple_test("aUc_BFu0i_BFu16i");
    static aUc_BFu0i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, 1, "aUc_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, hide_ull(1LL<<15), "aUc_BFu0i_BFu16i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu16i(Test_aUc_BFu0i_BFu16i, "aUc_BFu0i_BFu16i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu16ll()
{
  {
    init_simple_test("aUc_BFu0i_BFu16ll");
    static aUc_BFu0i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, 1, "aUc_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, hide_ull(1LL<<15), "aUc_BFu0i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu16ll(Test_aUc_BFu0i_BFu16ll, "aUc_BFu0i_BFu16ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu16s()
{
  {
    init_simple_test("aUc_BFu0i_BFu16s");
    static aUc_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, 1, "aUc_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 16, hide_ull(1LL<<15), "aUc_BFu0i_BFu16s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu16s(Test_aUc_BFu0i_BFu16s, "aUc_BFu0i_BFu16s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu17i()
{
  {
    init_simple_test("aUc_BFu0i_BFu17i");
    static aUc_BFu0i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aUc_BFu0i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, 1, "aUc_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, hide_ull(1LL<<16), "aUc_BFu0i_BFu17i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu17i(Test_aUc_BFu0i_BFu17i, "aUc_BFu0i_BFu17i", ABISELECT(7,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu17ll()
{
  {
    init_simple_test("aUc_BFu0i_BFu17ll");
    static aUc_BFu0i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aUc_BFu0i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, 1, "aUc_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 17, hide_ull(1LL<<16), "aUc_BFu0i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu17ll(Test_aUc_BFu0i_BFu17ll, "aUc_BFu0i_BFu17ll", ABISELECT(7,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu1c()
{
  {
    init_simple_test("aUc_BFu0i_BFu1c");
    static aUc_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "aUc_BFu0i_BFu1c");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu1c(Test_aUc_BFu0i_BFu1c, "aUc_BFu0i_BFu1c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu1i()
{
  {
    init_simple_test("aUc_BFu0i_BFu1i");
    static aUc_BFu0i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "aUc_BFu0i_BFu1i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu1i(Test_aUc_BFu0i_BFu1i, "aUc_BFu0i_BFu1i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu1ll()
{
  {
    init_simple_test("aUc_BFu0i_BFu1ll");
    static aUc_BFu0i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "aUc_BFu0i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu1ll(Test_aUc_BFu0i_BFu1ll, "aUc_BFu0i_BFu1ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu1s()
{
  {
    init_simple_test("aUc_BFu0i_BFu1s");
    static aUc_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 1, 1, "aUc_BFu0i_BFu1s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu1s(Test_aUc_BFu0i_BFu1s, "aUc_BFu0i_BFu1s", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu31i()
{
  {
    init_simple_test("aUc_BFu0i_BFu31i");
    static aUc_BFu0i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu0i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, 1, "aUc_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, hide_ull(1LL<<30), "aUc_BFu0i_BFu31i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu31i(Test_aUc_BFu0i_BFu31i, "aUc_BFu0i_BFu31i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu31ll()
{
  {
    init_simple_test("aUc_BFu0i_BFu31ll");
    static aUc_BFu0i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu0i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, 1, "aUc_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 31, hide_ull(1LL<<30), "aUc_BFu0i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu31ll(Test_aUc_BFu0i_BFu31ll, "aUc_BFu0i_BFu31ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu32i()
{
  {
    init_simple_test("aUc_BFu0i_BFu32i");
    static aUc_BFu0i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu0i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, 1, "aUc_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, hide_ull(1LL<<31), "aUc_BFu0i_BFu32i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu32i(Test_aUc_BFu0i_BFu32i, "aUc_BFu0i_BFu32i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu32ll()
{
  {
    init_simple_test("aUc_BFu0i_BFu32ll");
    static aUc_BFu0i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu0i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, 1, "aUc_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 32, hide_ull(1LL<<31), "aUc_BFu0i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu32ll(Test_aUc_BFu0i_BFu32ll, "aUc_BFu0i_BFu32ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu33()
{
  {
    init_simple_test("aUc_BFu0i_BFu33");
    static aUc_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(9,9), "sizeof(aUc_BFu0i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 33, 1, "aUc_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 33, hide_ull(1LL<<32), "aUc_BFu0i_BFu33");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu33(Test_aUc_BFu0i_BFu33, "aUc_BFu0i_BFu33", ABISELECT(9,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu7c()
{
  {
    init_simple_test("aUc_BFu0i_BFu7c");
    static aUc_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "aUc_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "aUc_BFu0i_BFu7c");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu7c(Test_aUc_BFu0i_BFu7c, "aUc_BFu0i_BFu7c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu7i()
{
  {
    init_simple_test("aUc_BFu0i_BFu7i");
    static aUc_BFu0i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "aUc_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "aUc_BFu0i_BFu7i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu7i(Test_aUc_BFu0i_BFu7i, "aUc_BFu0i_BFu7i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu7ll()
{
  {
    init_simple_test("aUc_BFu0i_BFu7ll");
    static aUc_BFu0i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "aUc_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "aUc_BFu0i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu7ll(Test_aUc_BFu0i_BFu7ll, "aUc_BFu0i_BFu7ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu7s()
{
  {
    init_simple_test("aUc_BFu0i_BFu7s");
    static aUc_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, 1, "aUc_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 7, hide_ull(1LL<<6), "aUc_BFu0i_BFu7s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu7s(Test_aUc_BFu0i_BFu7s, "aUc_BFu0i_BFu7s", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu8c()
{
  {
    init_simple_test("aUc_BFu0i_BFu8c");
    static aUc_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "aUc_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "aUc_BFu0i_BFu8c");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu8c(Test_aUc_BFu0i_BFu8c, "aUc_BFu0i_BFu8c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu8i()
{
  {
    init_simple_test("aUc_BFu0i_BFu8i");
    static aUc_BFu0i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "aUc_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "aUc_BFu0i_BFu8i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu8i(Test_aUc_BFu0i_BFu8i, "aUc_BFu0i_BFu8i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu8ll()
{
  {
    init_simple_test("aUc_BFu0i_BFu8ll");
    static aUc_BFu0i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "aUc_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "aUc_BFu0i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu8ll(Test_aUc_BFu0i_BFu8ll, "aUc_BFu0i_BFu8ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu8s()
{
  {
    init_simple_test("aUc_BFu0i_BFu8s");
    static aUc_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, 1, "aUc_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 8, hide_ull(1LL<<7), "aUc_BFu0i_BFu8s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu8s(Test_aUc_BFu0i_BFu8s, "aUc_BFu0i_BFu8s", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu9i()
{
  {
    init_simple_test("aUc_BFu0i_BFu9i");
    static aUc_BFu0i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, 1, "aUc_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, hide_ull(1LL<<8), "aUc_BFu0i_BFu9i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu9i(Test_aUc_BFu0i_BFu9i, "aUc_BFu0i_BFu9i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu9ll()
{
  {
    init_simple_test("aUc_BFu0i_BFu9ll");
    static aUc_BFu0i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, 1, "aUc_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, hide_ull(1LL<<8), "aUc_BFu0i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu9ll(Test_aUc_BFu0i_BFu9ll, "aUc_BFu0i_BFu9ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_BFu9s()
{
  {
    init_simple_test("aUc_BFu0i_BFu9s");
    static aUc_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, 1, "aUc_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), 0, 9, hide_ull(1LL<<8), "aUc_BFu0i_BFu9s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_BFu9s(Test_aUc_BFu0i_BFu9s, "aUc_BFu0i_BFu9s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_C()
{
  {
    init_simple_test("aUc_BFu0i_C");
    static aUc_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_C)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_C.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_C.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_C(Test_aUc_BFu0i_C, "aUc_BFu0i_C", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_D()
{
  {
    init_simple_test("aUc_BFu0i_D");
    static aUc_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aUc_BFu0i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_D)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_D.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_D.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_D(Test_aUc_BFu0i_D, "aUc_BFu0i_D", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_F()
{
  {
    init_simple_test("aUc_BFu0i_F");
    static aUc_BFu0i_F lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu0i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_F)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_F.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_F.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_F(Test_aUc_BFu0i_F, "aUc_BFu0i_F", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_I()
{
  {
    init_simple_test("aUc_BFu0i_I");
    static aUc_BFu0i_I lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu0i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_I)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_I.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_I.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_I(Test_aUc_BFu0i_I, "aUc_BFu0i_I", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_Ip()
{
  {
    init_simple_test("aUc_BFu0i_Ip");
    static aUc_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_BFu0i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_Ip)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_Ip.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_Ip(Test_aUc_BFu0i_Ip, "aUc_BFu0i_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_L()
{
  {
    init_simple_test("aUc_BFu0i_L");
    static aUc_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aUc_BFu0i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_L)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_L.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_L.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_L(Test_aUc_BFu0i_L, "aUc_BFu0i_L", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_S()
{
  {
    init_simple_test("aUc_BFu0i_S");
    static aUc_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_S)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_S.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_S.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_S(Test_aUc_BFu0i_S, "aUc_BFu0i_S", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_Uc()
{
  {
    init_simple_test("aUc_BFu0i_Uc");
    static aUc_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_Uc)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_Uc.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_Uc(Test_aUc_BFu0i_Uc, "aUc_BFu0i_Uc", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_Ui()
{
  {
    init_simple_test("aUc_BFu0i_Ui");
    static aUc_BFu0i_Ui lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu0i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_Ui)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_Ui.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_Ui(Test_aUc_BFu0i_Ui, "aUc_BFu0i_Ui", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_Ul()
{
  {
    init_simple_test("aUc_BFu0i_Ul");
    static aUc_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aUc_BFu0i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_Ul)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_Ul.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_Ul(Test_aUc_BFu0i_Ul, "aUc_BFu0i_Ul", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_Us()
{
  {
    init_simple_test("aUc_BFu0i_Us");
    static aUc_BFu0i_Us lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_Us)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_Us.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_Us.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_Us(Test_aUc_BFu0i_Us, "aUc_BFu0i_Us", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0i_Vp()
{
  {
    init_simple_test("aUc_BFu0i_Vp");
    static aUc_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_BFu0i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_Vp)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_Vp.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0i_Vp(Test_aUc_BFu0i_Vp, "aUc_BFu0i_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll()
{
  {
    init_simple_test("aUc_BFu0ll");
    static aUc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll(Test_aUc_BFu0ll, "aUc_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu0c()
{
  {
    init_simple_test("aUc_BFu0ll_BFu0c");
    static aUc_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu0ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu0c(Test_aUc_BFu0ll_BFu0c, "aUc_BFu0ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu0i()
{
  {
    init_simple_test("aUc_BFu0ll_BFu0i");
    static aUc_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu0ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu0i(Test_aUc_BFu0ll_BFu0i, "aUc_BFu0ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu0ll()
{
  {
    init_simple_test("aUc_BFu0ll_BFu0ll");
    static aUc_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu0ll(Test_aUc_BFu0ll_BFu0ll, "aUc_BFu0ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu0s()
{
  {
    init_simple_test("aUc_BFu0ll_BFu0s");
    static aUc_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu0ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu0s(Test_aUc_BFu0ll_BFu0s, "aUc_BFu0ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu15i()
{
  {
    init_simple_test("aUc_BFu0ll_BFu15i");
    static aUc_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_BFu0ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aUc_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aUc_BFu0ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu15i(Test_aUc_BFu0ll_BFu15i, "aUc_BFu0ll_BFu15i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu15ll()
{
  {
    init_simple_test("aUc_BFu0ll_BFu15ll");
    static aUc_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aUc_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aUc_BFu0ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu15ll(Test_aUc_BFu0ll_BFu15ll, "aUc_BFu0ll_BFu15ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu15s()
{
  {
    init_simple_test("aUc_BFu0ll_BFu15s");
    static aUc_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_BFu0ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aUc_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aUc_BFu0ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu15s(Test_aUc_BFu0ll_BFu15s, "aUc_BFu0ll_BFu15s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu16i()
{
  {
    init_simple_test("aUc_BFu0ll_BFu16i");
    static aUc_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_BFu0ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aUc_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aUc_BFu0ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu16i(Test_aUc_BFu0ll_BFu16i, "aUc_BFu0ll_BFu16i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu16ll()
{
  {
    init_simple_test("aUc_BFu0ll_BFu16ll");
    static aUc_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aUc_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aUc_BFu0ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu16ll(Test_aUc_BFu0ll_BFu16ll, "aUc_BFu0ll_BFu16ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu16s()
{
  {
    init_simple_test("aUc_BFu0ll_BFu16s");
    static aUc_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_BFu0ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aUc_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aUc_BFu0ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu16s(Test_aUc_BFu0ll_BFu16s, "aUc_BFu0ll_BFu16s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu17i()
{
  {
    init_simple_test("aUc_BFu0ll_BFu17i");
    static aUc_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_BFu0ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aUc_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aUc_BFu0ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu17i(Test_aUc_BFu0ll_BFu17i, "aUc_BFu0ll_BFu17i", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu17ll()
{
  {
    init_simple_test("aUc_BFu0ll_BFu17ll");
    static aUc_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aUc_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aUc_BFu0ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu17ll(Test_aUc_BFu0ll_BFu17ll, "aUc_BFu0ll_BFu17ll", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu1c()
{
  {
    init_simple_test("aUc_BFu0ll_BFu1c");
    static aUc_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aUc_BFu0ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu1c(Test_aUc_BFu0ll_BFu1c, "aUc_BFu0ll_BFu1c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu1i()
{
  {
    init_simple_test("aUc_BFu0ll_BFu1i");
    static aUc_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aUc_BFu0ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu1i(Test_aUc_BFu0ll_BFu1i, "aUc_BFu0ll_BFu1i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu1ll()
{
  {
    init_simple_test("aUc_BFu0ll_BFu1ll");
    static aUc_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aUc_BFu0ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu1ll(Test_aUc_BFu0ll_BFu1ll, "aUc_BFu0ll_BFu1ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu1s()
{
  {
    init_simple_test("aUc_BFu0ll_BFu1s");
    static aUc_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aUc_BFu0ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu1s(Test_aUc_BFu0ll_BFu1s, "aUc_BFu0ll_BFu1s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu31i()
{
  {
    init_simple_test("aUc_BFu0ll_BFu31i");
    static aUc_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_BFu0ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aUc_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aUc_BFu0ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu31i(Test_aUc_BFu0ll_BFu31i, "aUc_BFu0ll_BFu31i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu31ll()
{
  {
    init_simple_test("aUc_BFu0ll_BFu31ll");
    static aUc_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aUc_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aUc_BFu0ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu31ll(Test_aUc_BFu0ll_BFu31ll, "aUc_BFu0ll_BFu31ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu32i()
{
  {
    init_simple_test("aUc_BFu0ll_BFu32i");
    static aUc_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_BFu0ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aUc_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aUc_BFu0ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu32i(Test_aUc_BFu0ll_BFu32i, "aUc_BFu0ll_BFu32i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu32ll()
{
  {
    init_simple_test("aUc_BFu0ll_BFu32ll");
    static aUc_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aUc_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aUc_BFu0ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu32ll(Test_aUc_BFu0ll_BFu32ll, "aUc_BFu0ll_BFu32ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu33()
{
  {
    init_simple_test("aUc_BFu0ll_BFu33");
    static aUc_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_BFu0ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aUc_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aUc_BFu0ll_BFu33");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu33(Test_aUc_BFu0ll_BFu33, "aUc_BFu0ll_BFu33", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu7c()
{
  {
    init_simple_test("aUc_BFu0ll_BFu7c");
    static aUc_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aUc_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aUc_BFu0ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu7c(Test_aUc_BFu0ll_BFu7c, "aUc_BFu0ll_BFu7c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu7i()
{
  {
    init_simple_test("aUc_BFu0ll_BFu7i");
    static aUc_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aUc_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aUc_BFu0ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu7i(Test_aUc_BFu0ll_BFu7i, "aUc_BFu0ll_BFu7i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu7ll()
{
  {
    init_simple_test("aUc_BFu0ll_BFu7ll");
    static aUc_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aUc_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aUc_BFu0ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu7ll(Test_aUc_BFu0ll_BFu7ll, "aUc_BFu0ll_BFu7ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu7s()
{
  {
    init_simple_test("aUc_BFu0ll_BFu7s");
    static aUc_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aUc_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aUc_BFu0ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu7s(Test_aUc_BFu0ll_BFu7s, "aUc_BFu0ll_BFu7s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu8c()
{
  {
    init_simple_test("aUc_BFu0ll_BFu8c");
    static aUc_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aUc_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aUc_BFu0ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu8c(Test_aUc_BFu0ll_BFu8c, "aUc_BFu0ll_BFu8c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu8i()
{
  {
    init_simple_test("aUc_BFu0ll_BFu8i");
    static aUc_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aUc_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aUc_BFu0ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu8i(Test_aUc_BFu0ll_BFu8i, "aUc_BFu0ll_BFu8i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu8ll()
{
  {
    init_simple_test("aUc_BFu0ll_BFu8ll");
    static aUc_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aUc_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aUc_BFu0ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu8ll(Test_aUc_BFu0ll_BFu8ll, "aUc_BFu0ll_BFu8ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu8s()
{
  {
    init_simple_test("aUc_BFu0ll_BFu8s");
    static aUc_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aUc_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aUc_BFu0ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu8s(Test_aUc_BFu0ll_BFu8s, "aUc_BFu0ll_BFu8s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu9i()
{
  {
    init_simple_test("aUc_BFu0ll_BFu9i");
    static aUc_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_BFu0ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aUc_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aUc_BFu0ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu9i(Test_aUc_BFu0ll_BFu9i, "aUc_BFu0ll_BFu9i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu9ll()
{
  {
    init_simple_test("aUc_BFu0ll_BFu9ll");
    static aUc_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aUc_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aUc_BFu0ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu9ll(Test_aUc_BFu0ll_BFu9ll, "aUc_BFu0ll_BFu9ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_BFu9s()
{
  {
    init_simple_test("aUc_BFu0ll_BFu9s");
    static aUc_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_BFu0ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aUc_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aUc_BFu0ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_BFu9s(Test_aUc_BFu0ll_BFu9s, "aUc_BFu0ll_BFu9s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_C()
{
  {
    init_simple_test("aUc_BFu0ll_C");
    static aUc_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_C)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_C.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_C(Test_aUc_BFu0ll_C, "aUc_BFu0ll_C", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_D()
{
  {
    init_simple_test("aUc_BFu0ll_D");
    static aUc_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUc_BFu0ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_D)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_D.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_D(Test_aUc_BFu0ll_D, "aUc_BFu0ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_F()
{
  {
    init_simple_test("aUc_BFu0ll_F");
    static aUc_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_BFu0ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_F)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_F.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_F(Test_aUc_BFu0ll_F, "aUc_BFu0ll_F", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_I()
{
  {
    init_simple_test("aUc_BFu0ll_I");
    static aUc_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_BFu0ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_I)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_I.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_I(Test_aUc_BFu0ll_I, "aUc_BFu0ll_I", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_Ip()
{
  {
    init_simple_test("aUc_BFu0ll_Ip");
    static aUc_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aUc_BFu0ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_Ip)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_Ip(Test_aUc_BFu0ll_Ip, "aUc_BFu0ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_L()
{
  {
    init_simple_test("aUc_BFu0ll_L");
    static aUc_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUc_BFu0ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_L)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_L.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_L(Test_aUc_BFu0ll_L, "aUc_BFu0ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_S()
{
  {
    init_simple_test("aUc_BFu0ll_S");
    static aUc_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_BFu0ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_S)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_S.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_S(Test_aUc_BFu0ll_S, "aUc_BFu0ll_S", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_Uc()
{
  {
    init_simple_test("aUc_BFu0ll_Uc");
    static aUc_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_BFu0ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_Uc)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_Uc(Test_aUc_BFu0ll_Uc, "aUc_BFu0ll_Uc", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_Ui()
{
  {
    init_simple_test("aUc_BFu0ll_Ui");
    static aUc_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_BFu0ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_Ui)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_Ui(Test_aUc_BFu0ll_Ui, "aUc_BFu0ll_Ui", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_Ul()
{
  {
    init_simple_test("aUc_BFu0ll_Ul");
    static aUc_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUc_BFu0ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_Ul)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_Ul(Test_aUc_BFu0ll_Ul, "aUc_BFu0ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_Us()
{
  {
    init_simple_test("aUc_BFu0ll_Us");
    static aUc_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_BFu0ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_Us)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_Us.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_Us(Test_aUc_BFu0ll_Us, "aUc_BFu0ll_Us", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0ll_Vp()
{
  {
    init_simple_test("aUc_BFu0ll_Vp");
    static aUc_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aUc_BFu0ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_Vp)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0ll_Vp(Test_aUc_BFu0ll_Vp, "aUc_BFu0ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s()
{
  {
    init_simple_test("aUc_BFu0s");
    static aUc_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aUc_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s(Test_aUc_BFu0s, "aUc_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu0c()
{
  {
    init_simple_test("aUc_BFu0s_BFu0c");
    static aUc_BFu0s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aUc_BFu0s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu0c(Test_aUc_BFu0s_BFu0c, "aUc_BFu0s_BFu0c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu0i()
{
  {
    init_simple_test("aUc_BFu0s_BFu0i");
    static aUc_BFu0s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu0i(Test_aUc_BFu0s_BFu0i, "aUc_BFu0s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu0ll()
{
  {
    init_simple_test("aUc_BFu0s_BFu0ll");
    static aUc_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu0s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu0ll(Test_aUc_BFu0s_BFu0ll, "aUc_BFu0s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu0s()
{
  {
    init_simple_test("aUc_BFu0s_BFu0s");
    static aUc_BFu0s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aUc_BFu0s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu0s(Test_aUc_BFu0s_BFu0s, "aUc_BFu0s_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu15i()
{
  {
    init_simple_test("aUc_BFu0s_BFu15i");
    static aUc_BFu0s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, 1, "aUc_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, hide_ull(1LL<<14), "aUc_BFu0s_BFu15i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu15i(Test_aUc_BFu0s_BFu15i, "aUc_BFu0s_BFu15i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu15ll()
{
  {
    init_simple_test("aUc_BFu0s_BFu15ll");
    static aUc_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, 1, "aUc_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, hide_ull(1LL<<14), "aUc_BFu0s_BFu15ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu15ll(Test_aUc_BFu0s_BFu15ll, "aUc_BFu0s_BFu15ll", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu15s()
{
  {
    init_simple_test("aUc_BFu0s_BFu15s");
    static aUc_BFu0s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, 1, "aUc_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 15, hide_ull(1LL<<14), "aUc_BFu0s_BFu15s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu15s(Test_aUc_BFu0s_BFu15s, "aUc_BFu0s_BFu15s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu16i()
{
  {
    init_simple_test("aUc_BFu0s_BFu16i");
    static aUc_BFu0s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, 1, "aUc_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, hide_ull(1LL<<15), "aUc_BFu0s_BFu16i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu16i(Test_aUc_BFu0s_BFu16i, "aUc_BFu0s_BFu16i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu16ll()
{
  {
    init_simple_test("aUc_BFu0s_BFu16ll");
    static aUc_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, 1, "aUc_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, hide_ull(1LL<<15), "aUc_BFu0s_BFu16ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu16ll(Test_aUc_BFu0s_BFu16ll, "aUc_BFu0s_BFu16ll", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu16s()
{
  {
    init_simple_test("aUc_BFu0s_BFu16s");
    static aUc_BFu0s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, 1, "aUc_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 16, hide_ull(1LL<<15), "aUc_BFu0s_BFu16s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu16s(Test_aUc_BFu0s_BFu16s, "aUc_BFu0s_BFu16s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu17i()
{
  {
    init_simple_test("aUc_BFu0s_BFu17i");
    static aUc_BFu0s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 17, 1, "aUc_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 17, hide_ull(1LL<<16), "aUc_BFu0s_BFu17i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu17i(Test_aUc_BFu0s_BFu17i, "aUc_BFu0s_BFu17i", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu17ll()
{
  {
    init_simple_test("aUc_BFu0s_BFu17ll");
    static aUc_BFu0s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aUc_BFu0s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 17, 1, "aUc_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 17, hide_ull(1LL<<16), "aUc_BFu0s_BFu17ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu17ll(Test_aUc_BFu0s_BFu17ll, "aUc_BFu0s_BFu17ll", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu1c()
{
  {
    init_simple_test("aUc_BFu0s_BFu1c");
    static aUc_BFu0s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 1, 1, "aUc_BFu0s_BFu1c");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu1c(Test_aUc_BFu0s_BFu1c, "aUc_BFu0s_BFu1c", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu1i()
{
  {
    init_simple_test("aUc_BFu0s_BFu1i");
    static aUc_BFu0s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 1, 1, "aUc_BFu0s_BFu1i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu1i(Test_aUc_BFu0s_BFu1i, "aUc_BFu0s_BFu1i", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu1ll()
{
  {
    init_simple_test("aUc_BFu0s_BFu1ll");
    static aUc_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 1, 1, "aUc_BFu0s_BFu1ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu1ll(Test_aUc_BFu0s_BFu1ll, "aUc_BFu0s_BFu1ll", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu1s()
{
  {
    init_simple_test("aUc_BFu0s_BFu1s");
    static aUc_BFu0s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 1, 1, "aUc_BFu0s_BFu1s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu1s(Test_aUc_BFu0s_BFu1s, "aUc_BFu0s_BFu1s", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu31i()
{
  {
    init_simple_test("aUc_BFu0s_BFu31i");
    static aUc_BFu0s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 31, 1, "aUc_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 31, hide_ull(1LL<<30), "aUc_BFu0s_BFu31i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu31i(Test_aUc_BFu0s_BFu31i, "aUc_BFu0s_BFu31i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu31ll()
{
  {
    init_simple_test("aUc_BFu0s_BFu31ll");
    static aUc_BFu0s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 31, 1, "aUc_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 31, hide_ull(1LL<<30), "aUc_BFu0s_BFu31ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu31ll(Test_aUc_BFu0s_BFu31ll, "aUc_BFu0s_BFu31ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu32i()
{
  {
    init_simple_test("aUc_BFu0s_BFu32i");
    static aUc_BFu0s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 32, 1, "aUc_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 32, hide_ull(1LL<<31), "aUc_BFu0s_BFu32i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu32i(Test_aUc_BFu0s_BFu32i, "aUc_BFu0s_BFu32i", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu32ll()
{
  {
    init_simple_test("aUc_BFu0s_BFu32ll");
    static aUc_BFu0s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 32, 1, "aUc_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 32, hide_ull(1LL<<31), "aUc_BFu0s_BFu32ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu32ll(Test_aUc_BFu0s_BFu32ll, "aUc_BFu0s_BFu32ll", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu33()
{
  {
    init_simple_test("aUc_BFu0s_BFu33");
    static aUc_BFu0s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aUc_BFu0s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 33, 1, "aUc_BFu0s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 33, hide_ull(1LL<<32), "aUc_BFu0s_BFu33");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu33(Test_aUc_BFu0s_BFu33, "aUc_BFu0s_BFu33", ABISELECT(7,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu7c()
{
  {
    init_simple_test("aUc_BFu0s_BFu7c");
    static aUc_BFu0s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, 1, "aUc_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, hide_ull(1LL<<6), "aUc_BFu0s_BFu7c");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu7c(Test_aUc_BFu0s_BFu7c, "aUc_BFu0s_BFu7c", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu7i()
{
  {
    init_simple_test("aUc_BFu0s_BFu7i");
    static aUc_BFu0s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, 1, "aUc_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, hide_ull(1LL<<6), "aUc_BFu0s_BFu7i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu7i(Test_aUc_BFu0s_BFu7i, "aUc_BFu0s_BFu7i", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu7ll()
{
  {
    init_simple_test("aUc_BFu0s_BFu7ll");
    static aUc_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, 1, "aUc_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, hide_ull(1LL<<6), "aUc_BFu0s_BFu7ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu7ll(Test_aUc_BFu0s_BFu7ll, "aUc_BFu0s_BFu7ll", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu7s()
{
  {
    init_simple_test("aUc_BFu0s_BFu7s");
    static aUc_BFu0s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, 1, "aUc_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 7, hide_ull(1LL<<6), "aUc_BFu0s_BFu7s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu7s(Test_aUc_BFu0s_BFu7s, "aUc_BFu0s_BFu7s", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu8c()
{
  {
    init_simple_test("aUc_BFu0s_BFu8c");
    static aUc_BFu0s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, 1, "aUc_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, hide_ull(1LL<<7), "aUc_BFu0s_BFu8c");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu8c(Test_aUc_BFu0s_BFu8c, "aUc_BFu0s_BFu8c", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu8i()
{
  {
    init_simple_test("aUc_BFu0s_BFu8i");
    static aUc_BFu0s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, 1, "aUc_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, hide_ull(1LL<<7), "aUc_BFu0s_BFu8i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu8i(Test_aUc_BFu0s_BFu8i, "aUc_BFu0s_BFu8i", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu8ll()
{
  {
    init_simple_test("aUc_BFu0s_BFu8ll");
    static aUc_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, 1, "aUc_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, hide_ull(1LL<<7), "aUc_BFu0s_BFu8ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu8ll(Test_aUc_BFu0s_BFu8ll, "aUc_BFu0s_BFu8ll", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu8s()
{
  {
    init_simple_test("aUc_BFu0s_BFu8s");
    static aUc_BFu0s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, 1, "aUc_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 8, hide_ull(1LL<<7), "aUc_BFu0s_BFu8s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu8s(Test_aUc_BFu0s_BFu8s, "aUc_BFu0s_BFu8s", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu9i()
{
  {
    init_simple_test("aUc_BFu0s_BFu9i");
    static aUc_BFu0s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, 1, "aUc_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, hide_ull(1LL<<8), "aUc_BFu0s_BFu9i");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu9i(Test_aUc_BFu0s_BFu9i, "aUc_BFu0s_BFu9i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu9ll()
{
  {
    init_simple_test("aUc_BFu0s_BFu9ll");
    static aUc_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, 1, "aUc_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, hide_ull(1LL<<8), "aUc_BFu0s_BFu9ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu9ll(Test_aUc_BFu0s_BFu9ll, "aUc_BFu0s_BFu9ll", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_BFu9s()
{
  {
    init_simple_test("aUc_BFu0s_BFu9s");
    static aUc_BFu0s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, 1, "aUc_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), 0, 9, hide_ull(1LL<<8), "aUc_BFu0s_BFu9s");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_BFu9s(Test_aUc_BFu0s_BFu9s, "aUc_BFu0s_BFu9s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_C()
{
  {
    init_simple_test("aUc_BFu0s_C");
    static aUc_BFu0s_C lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_C)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_C.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_C.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_C(Test_aUc_BFu0s_C, "aUc_BFu0s_C", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_D()
{
  {
    init_simple_test("aUc_BFu0s_D");
    static aUc_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aUc_BFu0s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_D)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_D.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_D.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_D(Test_aUc_BFu0s_D, "aUc_BFu0s_D", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_F()
{
  {
    init_simple_test("aUc_BFu0s_F");
    static aUc_BFu0s_F lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_F)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_F.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_F.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_F(Test_aUc_BFu0s_F, "aUc_BFu0s_F", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_I()
{
  {
    init_simple_test("aUc_BFu0s_I");
    static aUc_BFu0s_I lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_I)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_I.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_I.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_I(Test_aUc_BFu0s_I, "aUc_BFu0s_I", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_Ip()
{
  {
    init_simple_test("aUc_BFu0s_Ip");
    static aUc_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_BFu0s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_Ip)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_Ip.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_Ip(Test_aUc_BFu0s_Ip, "aUc_BFu0s_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_L()
{
  {
    init_simple_test("aUc_BFu0s_L");
    static aUc_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aUc_BFu0s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_L)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_L.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_L.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_L(Test_aUc_BFu0s_L, "aUc_BFu0s_L", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_S()
{
  {
    init_simple_test("aUc_BFu0s_S");
    static aUc_BFu0s_S lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_S)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_S.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_S.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_S(Test_aUc_BFu0s_S, "aUc_BFu0s_S", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_Uc()
{
  {
    init_simple_test("aUc_BFu0s_Uc");
    static aUc_BFu0s_Uc lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aUc_BFu0s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_Uc)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_Uc.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_Uc(Test_aUc_BFu0s_Uc, "aUc_BFu0s_Uc", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_Ui()
{
  {
    init_simple_test("aUc_BFu0s_Ui");
    static aUc_BFu0s_Ui lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu0s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_Ui)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_Ui.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_Ui(Test_aUc_BFu0s_Ui, "aUc_BFu0s_Ui", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_Ul()
{
  {
    init_simple_test("aUc_BFu0s_Ul");
    static aUc_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aUc_BFu0s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_Ul)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_Ul.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_Ul(Test_aUc_BFu0s_Ul, "aUc_BFu0s_Ul", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_Us()
{
  {
    init_simple_test("aUc_BFu0s_Us");
    static aUc_BFu0s_Us lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_Us)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_Us.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_Us.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_Us(Test_aUc_BFu0s_Us, "aUc_BFu0s_Us", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu0s_Vp()
{
  {
    init_simple_test("aUc_BFu0s_Vp");
    static aUc_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_BFu0s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_Vp)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_Vp.v2");
  }
}
static Arrange_To_Call_Me vaUc_BFu0s_Vp(Test_aUc_BFu0s_Vp, "aUc_BFu0s_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu15i_BFu0c()
{
  {
    init_simple_test("aUc_BFu15i_BFu0c");
    static aUc_BFu15i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu15i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu15i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu15i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu15i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu15i_BFu0c(Test_aUc_BFu15i_BFu0c, "aUc_BFu15i_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu15i_BFu0i()
{
  {
    init_simple_test("aUc_BFu15i_BFu0i");
    static aUc_BFu15i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu15i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu15i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu15i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu15i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu15i_BFu0i(Test_aUc_BFu15i_BFu0i, "aUc_BFu15i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu15i_BFu0ll()
{
  {
    init_simple_test("aUc_BFu15i_BFu0ll");
    static aUc_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu15i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu15i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu15i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu15i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu15i_BFu0ll(Test_aUc_BFu15i_BFu0ll, "aUc_BFu15i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu15i_BFu0s()
{
  {
    init_simple_test("aUc_BFu15i_BFu0s");
    static aUc_BFu15i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu15i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu15i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu15i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu15i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu15i_BFu0s(Test_aUc_BFu15i_BFu0s, "aUc_BFu15i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu15ll_BFu0c()
{
  {
    init_simple_test("aUc_BFu15ll_BFu0c");
    static aUc_BFu15ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu15ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu15ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu15ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu15ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu15ll_BFu0c(Test_aUc_BFu15ll_BFu0c, "aUc_BFu15ll_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu15ll_BFu0i()
{
  {
    init_simple_test("aUc_BFu15ll_BFu0i");
    static aUc_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu15ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu15ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu15ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu15ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu15ll_BFu0i(Test_aUc_BFu15ll_BFu0i, "aUc_BFu15ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu15ll_BFu0ll()
{
  {
    init_simple_test("aUc_BFu15ll_BFu0ll");
    static aUc_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu15ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu15ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu15ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu15ll_BFu0ll(Test_aUc_BFu15ll_BFu0ll, "aUc_BFu15ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu15ll_BFu0s()
{
  {
    init_simple_test("aUc_BFu15ll_BFu0s");
    static aUc_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu15ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu15ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu15ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu15ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu15ll_BFu0s(Test_aUc_BFu15ll_BFu0s, "aUc_BFu15ll_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu15s_BFu0c()
{
  {
    init_simple_test("aUc_BFu15s_BFu0c");
    static aUc_BFu15s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu15s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu15s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu15s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu15s_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu15s_BFu0c(Test_aUc_BFu15s_BFu0c, "aUc_BFu15s_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu15s_BFu0i()
{
  {
    init_simple_test("aUc_BFu15s_BFu0i");
    static aUc_BFu15s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu15s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu15s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu15s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu15s_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu15s_BFu0i(Test_aUc_BFu15s_BFu0i, "aUc_BFu15s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu15s_BFu0ll()
{
  {
    init_simple_test("aUc_BFu15s_BFu0ll");
    static aUc_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu15s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu15s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu15s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu15s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu15s_BFu0ll(Test_aUc_BFu15s_BFu0ll, "aUc_BFu15s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu15s_BFu0s()
{
  {
    init_simple_test("aUc_BFu15s_BFu0s");
    static aUc_BFu15s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu15s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu15s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu15s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aUc_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aUc_BFu15s_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu15s_BFu0s(Test_aUc_BFu15s_BFu0s, "aUc_BFu15s_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu16i_BFu0c()
{
  {
    init_simple_test("aUc_BFu16i_BFu0c");
    static aUc_BFu16i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu16i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu16i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu16i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu16i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu16i_BFu0c(Test_aUc_BFu16i_BFu0c, "aUc_BFu16i_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu16i_BFu0i()
{
  {
    init_simple_test("aUc_BFu16i_BFu0i");
    static aUc_BFu16i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu16i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu16i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu16i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu16i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu16i_BFu0i(Test_aUc_BFu16i_BFu0i, "aUc_BFu16i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu16i_BFu0ll()
{
  {
    init_simple_test("aUc_BFu16i_BFu0ll");
    static aUc_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu16i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu16i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu16i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu16i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu16i_BFu0ll(Test_aUc_BFu16i_BFu0ll, "aUc_BFu16i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu16i_BFu0s()
{
  {
    init_simple_test("aUc_BFu16i_BFu0s");
    static aUc_BFu16i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu16i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu16i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu16i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu16i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu16i_BFu0s(Test_aUc_BFu16i_BFu0s, "aUc_BFu16i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu16ll_BFu0c()
{
  {
    init_simple_test("aUc_BFu16ll_BFu0c");
    static aUc_BFu16ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu16ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu16ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu16ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu16ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu16ll_BFu0c(Test_aUc_BFu16ll_BFu0c, "aUc_BFu16ll_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu16ll_BFu0i()
{
  {
    init_simple_test("aUc_BFu16ll_BFu0i");
    static aUc_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu16ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu16ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu16ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu16ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu16ll_BFu0i(Test_aUc_BFu16ll_BFu0i, "aUc_BFu16ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu16ll_BFu0ll()
{
  {
    init_simple_test("aUc_BFu16ll_BFu0ll");
    static aUc_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu16ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu16ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu16ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu16ll_BFu0ll(Test_aUc_BFu16ll_BFu0ll, "aUc_BFu16ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu16ll_BFu0s()
{
  {
    init_simple_test("aUc_BFu16ll_BFu0s");
    static aUc_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu16ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu16ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu16ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu16ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu16ll_BFu0s(Test_aUc_BFu16ll_BFu0s, "aUc_BFu16ll_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu16s_BFu0c()
{
  {
    init_simple_test("aUc_BFu16s_BFu0c");
    static aUc_BFu16s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu16s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu16s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu16s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu16s_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu16s_BFu0c(Test_aUc_BFu16s_BFu0c, "aUc_BFu16s_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu16s_BFu0i()
{
  {
    init_simple_test("aUc_BFu16s_BFu0i");
    static aUc_BFu16s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu16s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu16s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu16s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu16s_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu16s_BFu0i(Test_aUc_BFu16s_BFu0i, "aUc_BFu16s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu16s_BFu0ll()
{
  {
    init_simple_test("aUc_BFu16s_BFu0ll");
    static aUc_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu16s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu16s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu16s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu16s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu16s_BFu0ll(Test_aUc_BFu16s_BFu0ll, "aUc_BFu16s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu16s_BFu0s()
{
  {
    init_simple_test("aUc_BFu16s_BFu0s");
    static aUc_BFu16s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu16s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu16s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu16s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aUc_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aUc_BFu16s_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu16s_BFu0s(Test_aUc_BFu16s_BFu0s, "aUc_BFu16s_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu17i_BFu0c()
{
  {
    init_simple_test("aUc_BFu17i_BFu0c");
    static aUc_BFu17i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aUc_BFu17i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu17i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu17i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aUc_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aUc_BFu17i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu17i_BFu0c(Test_aUc_BFu17i_BFu0c, "aUc_BFu17i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu17i_BFu0i()
{
  {
    init_simple_test("aUc_BFu17i_BFu0i");
    static aUc_BFu17i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aUc_BFu17i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu17i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu17i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aUc_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aUc_BFu17i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu17i_BFu0i(Test_aUc_BFu17i_BFu0i, "aUc_BFu17i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu17i_BFu0ll()
{
  {
    init_simple_test("aUc_BFu17i_BFu0ll");
    static aUc_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu17i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu17i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu17i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aUc_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aUc_BFu17i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu17i_BFu0ll(Test_aUc_BFu17i_BFu0ll, "aUc_BFu17i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu17i_BFu0s()
{
  {
    init_simple_test("aUc_BFu17i_BFu0s");
    static aUc_BFu17i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aUc_BFu17i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu17i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu17i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aUc_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aUc_BFu17i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu17i_BFu0s(Test_aUc_BFu17i_BFu0s, "aUc_BFu17i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu17ll_BFu0c()
{
  {
    init_simple_test("aUc_BFu17ll_BFu0c");
    static aUc_BFu17ll_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aUc_BFu17ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu17ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu17ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aUc_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aUc_BFu17ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu17ll_BFu0c(Test_aUc_BFu17ll_BFu0c, "aUc_BFu17ll_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu17ll_BFu0i()
{
  {
    init_simple_test("aUc_BFu17ll_BFu0i");
    static aUc_BFu17ll_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aUc_BFu17ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu17ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu17ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aUc_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aUc_BFu17ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu17ll_BFu0i(Test_aUc_BFu17ll_BFu0i, "aUc_BFu17ll_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu17ll_BFu0ll()
{
  {
    init_simple_test("aUc_BFu17ll_BFu0ll");
    static aUc_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu17ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu17ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aUc_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aUc_BFu17ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu17ll_BFu0ll(Test_aUc_BFu17ll_BFu0ll, "aUc_BFu17ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu17ll_BFu0s()
{
  {
    init_simple_test("aUc_BFu17ll_BFu0s");
    static aUc_BFu17ll_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aUc_BFu17ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu17ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu17ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aUc_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aUc_BFu17ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu17ll_BFu0s(Test_aUc_BFu17ll_BFu0s, "aUc_BFu17ll_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1c_BFu0c()
{
  {
    init_simple_test("aUc_BFu1c_BFu0c");
    static aUc_BFu1c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu1c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1c_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu1c_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1c_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu1c_BFu0c(Test_aUc_BFu1c_BFu0c, "aUc_BFu1c_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1c_BFu0i()
{
  {
    init_simple_test("aUc_BFu1c_BFu0i");
    static aUc_BFu1c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu1c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1c_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu1c_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1c_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu1c_BFu0i(Test_aUc_BFu1c_BFu0i, "aUc_BFu1c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1c_BFu0ll()
{
  {
    init_simple_test("aUc_BFu1c_BFu0ll");
    static aUc_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu1c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu1c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1c_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu1c_BFu0ll(Test_aUc_BFu1c_BFu0ll, "aUc_BFu1c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1c_BFu0s()
{
  {
    init_simple_test("aUc_BFu1c_BFu0s");
    static aUc_BFu1c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu1c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1c_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu1c_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1c_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu1c_BFu0s(Test_aUc_BFu1c_BFu0s, "aUc_BFu1c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1i_BFu0c()
{
  {
    init_simple_test("aUc_BFu1i_BFu0c");
    static aUc_BFu1i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu1i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu1i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu1i_BFu0c(Test_aUc_BFu1i_BFu0c, "aUc_BFu1i_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1i_BFu0i()
{
  {
    init_simple_test("aUc_BFu1i_BFu0i");
    static aUc_BFu1i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu1i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu1i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu1i_BFu0i(Test_aUc_BFu1i_BFu0i, "aUc_BFu1i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1i_BFu0ll()
{
  {
    init_simple_test("aUc_BFu1i_BFu0ll");
    static aUc_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu1i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu1i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu1i_BFu0ll(Test_aUc_BFu1i_BFu0ll, "aUc_BFu1i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1i_BFu0s()
{
  {
    init_simple_test("aUc_BFu1i_BFu0s");
    static aUc_BFu1i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu1i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu1i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu1i_BFu0s(Test_aUc_BFu1i_BFu0s, "aUc_BFu1i_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1ll_BFu0c()
{
  {
    init_simple_test("aUc_BFu1ll_BFu0c");
    static aUc_BFu1ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu1ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu1ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu1ll_BFu0c(Test_aUc_BFu1ll_BFu0c, "aUc_BFu1ll_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1ll_BFu0i()
{
  {
    init_simple_test("aUc_BFu1ll_BFu0i");
    static aUc_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu1ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu1ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu1ll_BFu0i(Test_aUc_BFu1ll_BFu0i, "aUc_BFu1ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1ll_BFu0ll()
{
  {
    init_simple_test("aUc_BFu1ll_BFu0ll");
    static aUc_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu1ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu1ll_BFu0ll(Test_aUc_BFu1ll_BFu0ll, "aUc_BFu1ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1ll_BFu0s()
{
  {
    init_simple_test("aUc_BFu1ll_BFu0s");
    static aUc_BFu1ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu1ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu1ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu1ll_BFu0s(Test_aUc_BFu1ll_BFu0s, "aUc_BFu1ll_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1s_BFu0c()
{
  {
    init_simple_test("aUc_BFu1s_BFu0c");
    static aUc_BFu1s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu1s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu1s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1s_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu1s_BFu0c(Test_aUc_BFu1s_BFu0c, "aUc_BFu1s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1s_BFu0i()
{
  {
    init_simple_test("aUc_BFu1s_BFu0i");
    static aUc_BFu1s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu1s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu1s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1s_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu1s_BFu0i(Test_aUc_BFu1s_BFu0i, "aUc_BFu1s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1s_BFu0ll()
{
  {
    init_simple_test("aUc_BFu1s_BFu0ll");
    static aUc_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu1s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu1s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu1s_BFu0ll(Test_aUc_BFu1s_BFu0ll, "aUc_BFu1s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu1s_BFu0s()
{
  {
    init_simple_test("aUc_BFu1s_BFu0s");
    static aUc_BFu1s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu1s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu1s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu1s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aUc_BFu1s_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu1s_BFu0s(Test_aUc_BFu1s_BFu0s, "aUc_BFu1s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu31i_BFu0c()
{
  {
    init_simple_test("aUc_BFu31i_BFu0c");
    static aUc_BFu31i_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUc_BFu31i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu31i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu31i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aUc_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aUc_BFu31i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu31i_BFu0c(Test_aUc_BFu31i_BFu0c, "aUc_BFu31i_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu31i_BFu0i()
{
  {
    init_simple_test("aUc_BFu31i_BFu0i");
    static aUc_BFu31i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu31i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu31i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu31i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aUc_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aUc_BFu31i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu31i_BFu0i(Test_aUc_BFu31i_BFu0i, "aUc_BFu31i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu31i_BFu0ll()
{
  {
    init_simple_test("aUc_BFu31i_BFu0ll");
    static aUc_BFu31i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu31i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu31i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu31i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aUc_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aUc_BFu31i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu31i_BFu0ll(Test_aUc_BFu31i_BFu0ll, "aUc_BFu31i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu31i_BFu0s()
{
  {
    init_simple_test("aUc_BFu31i_BFu0s");
    static aUc_BFu31i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu31i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu31i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu31i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aUc_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aUc_BFu31i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu31i_BFu0s(Test_aUc_BFu31i_BFu0s, "aUc_BFu31i_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu31ll_BFu0c()
{
  {
    init_simple_test("aUc_BFu31ll_BFu0c");
    static aUc_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUc_BFu31ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu31ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu31ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aUc_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aUc_BFu31ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu31ll_BFu0c(Test_aUc_BFu31ll_BFu0c, "aUc_BFu31ll_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu31ll_BFu0i()
{
  {
    init_simple_test("aUc_BFu31ll_BFu0i");
    static aUc_BFu31ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu31ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu31ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu31ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aUc_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aUc_BFu31ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu31ll_BFu0i(Test_aUc_BFu31ll_BFu0i, "aUc_BFu31ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu31ll_BFu0ll()
{
  {
    init_simple_test("aUc_BFu31ll_BFu0ll");
    static aUc_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu31ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu31ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aUc_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aUc_BFu31ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu31ll_BFu0ll(Test_aUc_BFu31ll_BFu0ll, "aUc_BFu31ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu31ll_BFu0s()
{
  {
    init_simple_test("aUc_BFu31ll_BFu0s");
    static aUc_BFu31ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu31ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu31ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu31ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aUc_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aUc_BFu31ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu31ll_BFu0s(Test_aUc_BFu31ll_BFu0s, "aUc_BFu31ll_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu32i_BFu0c()
{
  {
    init_simple_test("aUc_BFu32i_BFu0c");
    static aUc_BFu32i_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUc_BFu32i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu32i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu32i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aUc_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aUc_BFu32i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu32i_BFu0c(Test_aUc_BFu32i_BFu0c, "aUc_BFu32i_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu32i_BFu0i()
{
  {
    init_simple_test("aUc_BFu32i_BFu0i");
    static aUc_BFu32i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu32i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu32i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu32i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aUc_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aUc_BFu32i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu32i_BFu0i(Test_aUc_BFu32i_BFu0i, "aUc_BFu32i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu32i_BFu0ll()
{
  {
    init_simple_test("aUc_BFu32i_BFu0ll");
    static aUc_BFu32i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu32i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu32i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu32i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aUc_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aUc_BFu32i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu32i_BFu0ll(Test_aUc_BFu32i_BFu0ll, "aUc_BFu32i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu32i_BFu0s()
{
  {
    init_simple_test("aUc_BFu32i_BFu0s");
    static aUc_BFu32i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu32i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu32i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu32i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aUc_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aUc_BFu32i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu32i_BFu0s(Test_aUc_BFu32i_BFu0s, "aUc_BFu32i_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu32ll_BFu0c()
{
  {
    init_simple_test("aUc_BFu32ll_BFu0c");
    static aUc_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUc_BFu32ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu32ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu32ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aUc_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aUc_BFu32ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu32ll_BFu0c(Test_aUc_BFu32ll_BFu0c, "aUc_BFu32ll_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu32ll_BFu0i()
{
  {
    init_simple_test("aUc_BFu32ll_BFu0i");
    static aUc_BFu32ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu32ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu32ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu32ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aUc_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aUc_BFu32ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu32ll_BFu0i(Test_aUc_BFu32ll_BFu0i, "aUc_BFu32ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu32ll_BFu0ll()
{
  {
    init_simple_test("aUc_BFu32ll_BFu0ll");
    static aUc_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu32ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu32ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aUc_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aUc_BFu32ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu32ll_BFu0ll(Test_aUc_BFu32ll_BFu0ll, "aUc_BFu32ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu32ll_BFu0s()
{
  {
    init_simple_test("aUc_BFu32ll_BFu0s");
    static aUc_BFu32ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_BFu32ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu32ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu32ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aUc_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aUc_BFu32ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu32ll_BFu0s(Test_aUc_BFu32ll_BFu0s, "aUc_BFu32ll_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu33_BFu0c()
{
  {
    init_simple_test("aUc_BFu33_BFu0c");
    static aUc_BFu33_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aUc_BFu33_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu33_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu33_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aUc_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aUc_BFu33_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu33_BFu0c(Test_aUc_BFu33_BFu0c, "aUc_BFu33_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu33_BFu0i()
{
  {
    init_simple_test("aUc_BFu33_BFu0i");
    static aUc_BFu33_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu33_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu33_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu33_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aUc_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aUc_BFu33_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu33_BFu0i(Test_aUc_BFu33_BFu0i, "aUc_BFu33_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu33_BFu0ll()
{
  {
    init_simple_test("aUc_BFu33_BFu0ll");
    static aUc_BFu33_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_BFu33_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu33_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu33_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aUc_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aUc_BFu33_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu33_BFu0ll(Test_aUc_BFu33_BFu0ll, "aUc_BFu33_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu33_BFu0s()
{
  {
    init_simple_test("aUc_BFu33_BFu0s");
    static aUc_BFu33_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aUc_BFu33_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu33_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu33_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aUc_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aUc_BFu33_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu33_BFu0s(Test_aUc_BFu33_BFu0s, "aUc_BFu33_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7c_BFu0c()
{
  {
    init_simple_test("aUc_BFu7c_BFu0c");
    static aUc_BFu7c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu7c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7c_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu7c_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7c_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu7c_BFu0c(Test_aUc_BFu7c_BFu0c, "aUc_BFu7c_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7c_BFu0i()
{
  {
    init_simple_test("aUc_BFu7c_BFu0i");
    static aUc_BFu7c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu7c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7c_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu7c_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7c_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu7c_BFu0i(Test_aUc_BFu7c_BFu0i, "aUc_BFu7c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7c_BFu0ll()
{
  {
    init_simple_test("aUc_BFu7c_BFu0ll");
    static aUc_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu7c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu7c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7c_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu7c_BFu0ll(Test_aUc_BFu7c_BFu0ll, "aUc_BFu7c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7c_BFu0s()
{
  {
    init_simple_test("aUc_BFu7c_BFu0s");
    static aUc_BFu7c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu7c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7c_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu7c_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7c_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu7c_BFu0s(Test_aUc_BFu7c_BFu0s, "aUc_BFu7c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7i_BFu0c()
{
  {
    init_simple_test("aUc_BFu7i_BFu0c");
    static aUc_BFu7i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu7i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu7i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu7i_BFu0c(Test_aUc_BFu7i_BFu0c, "aUc_BFu7i_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7i_BFu0i()
{
  {
    init_simple_test("aUc_BFu7i_BFu0i");
    static aUc_BFu7i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu7i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu7i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu7i_BFu0i(Test_aUc_BFu7i_BFu0i, "aUc_BFu7i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7i_BFu0ll()
{
  {
    init_simple_test("aUc_BFu7i_BFu0ll");
    static aUc_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu7i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu7i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu7i_BFu0ll(Test_aUc_BFu7i_BFu0ll, "aUc_BFu7i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7i_BFu0s()
{
  {
    init_simple_test("aUc_BFu7i_BFu0s");
    static aUc_BFu7i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu7i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu7i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu7i_BFu0s(Test_aUc_BFu7i_BFu0s, "aUc_BFu7i_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7ll_BFu0c()
{
  {
    init_simple_test("aUc_BFu7ll_BFu0c");
    static aUc_BFu7ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu7ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu7ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu7ll_BFu0c(Test_aUc_BFu7ll_BFu0c, "aUc_BFu7ll_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7ll_BFu0i()
{
  {
    init_simple_test("aUc_BFu7ll_BFu0i");
    static aUc_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu7ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu7ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu7ll_BFu0i(Test_aUc_BFu7ll_BFu0i, "aUc_BFu7ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7ll_BFu0ll()
{
  {
    init_simple_test("aUc_BFu7ll_BFu0ll");
    static aUc_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu7ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu7ll_BFu0ll(Test_aUc_BFu7ll_BFu0ll, "aUc_BFu7ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7ll_BFu0s()
{
  {
    init_simple_test("aUc_BFu7ll_BFu0s");
    static aUc_BFu7ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu7ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu7ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu7ll_BFu0s(Test_aUc_BFu7ll_BFu0s, "aUc_BFu7ll_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7s_BFu0c()
{
  {
    init_simple_test("aUc_BFu7s_BFu0c");
    static aUc_BFu7s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu7s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu7s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7s_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu7s_BFu0c(Test_aUc_BFu7s_BFu0c, "aUc_BFu7s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7s_BFu0i()
{
  {
    init_simple_test("aUc_BFu7s_BFu0i");
    static aUc_BFu7s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu7s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu7s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7s_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu7s_BFu0i(Test_aUc_BFu7s_BFu0i, "aUc_BFu7s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7s_BFu0ll()
{
  {
    init_simple_test("aUc_BFu7s_BFu0ll");
    static aUc_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu7s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu7s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu7s_BFu0ll(Test_aUc_BFu7s_BFu0ll, "aUc_BFu7s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu7s_BFu0s()
{
  {
    init_simple_test("aUc_BFu7s_BFu0s");
    static aUc_BFu7s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu7s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu7s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu7s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aUc_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aUc_BFu7s_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu7s_BFu0s(Test_aUc_BFu7s_BFu0s, "aUc_BFu7s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8c_BFu0c()
{
  {
    init_simple_test("aUc_BFu8c_BFu0c");
    static aUc_BFu8c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu8c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8c_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu8c_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8c_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu8c_BFu0c(Test_aUc_BFu8c_BFu0c, "aUc_BFu8c_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8c_BFu0i()
{
  {
    init_simple_test("aUc_BFu8c_BFu0i");
    static aUc_BFu8c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu8c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8c_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu8c_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8c_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu8c_BFu0i(Test_aUc_BFu8c_BFu0i, "aUc_BFu8c_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8c_BFu0ll()
{
  {
    init_simple_test("aUc_BFu8c_BFu0ll");
    static aUc_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu8c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu8c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8c_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu8c_BFu0ll(Test_aUc_BFu8c_BFu0ll, "aUc_BFu8c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8c_BFu0s()
{
  {
    init_simple_test("aUc_BFu8c_BFu0s");
    static aUc_BFu8c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu8c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8c_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu8c_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8c_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu8c_BFu0s(Test_aUc_BFu8c_BFu0s, "aUc_BFu8c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8i_BFu0c()
{
  {
    init_simple_test("aUc_BFu8i_BFu0c");
    static aUc_BFu8i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu8i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu8i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu8i_BFu0c(Test_aUc_BFu8i_BFu0c, "aUc_BFu8i_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8i_BFu0i()
{
  {
    init_simple_test("aUc_BFu8i_BFu0i");
    static aUc_BFu8i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu8i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu8i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu8i_BFu0i(Test_aUc_BFu8i_BFu0i, "aUc_BFu8i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8i_BFu0ll()
{
  {
    init_simple_test("aUc_BFu8i_BFu0ll");
    static aUc_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu8i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu8i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu8i_BFu0ll(Test_aUc_BFu8i_BFu0ll, "aUc_BFu8i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8i_BFu0s()
{
  {
    init_simple_test("aUc_BFu8i_BFu0s");
    static aUc_BFu8i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu8i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu8i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu8i_BFu0s(Test_aUc_BFu8i_BFu0s, "aUc_BFu8i_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8ll_BFu0c()
{
  {
    init_simple_test("aUc_BFu8ll_BFu0c");
    static aUc_BFu8ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu8ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu8ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu8ll_BFu0c(Test_aUc_BFu8ll_BFu0c, "aUc_BFu8ll_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8ll_BFu0i()
{
  {
    init_simple_test("aUc_BFu8ll_BFu0i");
    static aUc_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu8ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu8ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu8ll_BFu0i(Test_aUc_BFu8ll_BFu0i, "aUc_BFu8ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8ll_BFu0ll()
{
  {
    init_simple_test("aUc_BFu8ll_BFu0ll");
    static aUc_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu8ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu8ll_BFu0ll(Test_aUc_BFu8ll_BFu0ll, "aUc_BFu8ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8ll_BFu0s()
{
  {
    init_simple_test("aUc_BFu8ll_BFu0s");
    static aUc_BFu8ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu8ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu8ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu8ll_BFu0s(Test_aUc_BFu8ll_BFu0s, "aUc_BFu8ll_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8s_BFu0c()
{
  {
    init_simple_test("aUc_BFu8s_BFu0c");
    static aUc_BFu8s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu8s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu8s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8s_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu8s_BFu0c(Test_aUc_BFu8s_BFu0c, "aUc_BFu8s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8s_BFu0i()
{
  {
    init_simple_test("aUc_BFu8s_BFu0i");
    static aUc_BFu8s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu8s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu8s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8s_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu8s_BFu0i(Test_aUc_BFu8s_BFu0i, "aUc_BFu8s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8s_BFu0ll()
{
  {
    init_simple_test("aUc_BFu8s_BFu0ll");
    static aUc_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu8s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu8s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu8s_BFu0ll(Test_aUc_BFu8s_BFu0ll, "aUc_BFu8s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu8s_BFu0s()
{
  {
    init_simple_test("aUc_BFu8s_BFu0s");
    static aUc_BFu8s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_BFu8s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu8s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu8s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aUc_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aUc_BFu8s_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu8s_BFu0s(Test_aUc_BFu8s_BFu0s, "aUc_BFu8s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu9i_BFu0c()
{
  {
    init_simple_test("aUc_BFu9i_BFu0c");
    static aUc_BFu9i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu9i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu9i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu9i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu9i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu9i_BFu0c(Test_aUc_BFu9i_BFu0c, "aUc_BFu9i_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu9i_BFu0i()
{
  {
    init_simple_test("aUc_BFu9i_BFu0i");
    static aUc_BFu9i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu9i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu9i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu9i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu9i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu9i_BFu0i(Test_aUc_BFu9i_BFu0i, "aUc_BFu9i_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu9i_BFu0ll()
{
  {
    init_simple_test("aUc_BFu9i_BFu0ll");
    static aUc_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu9i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu9i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu9i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu9i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu9i_BFu0ll(Test_aUc_BFu9i_BFu0ll, "aUc_BFu9i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu9i_BFu0s()
{
  {
    init_simple_test("aUc_BFu9i_BFu0s");
    static aUc_BFu9i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu9i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu9i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu9i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu9i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu9i_BFu0s(Test_aUc_BFu9i_BFu0s, "aUc_BFu9i_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu9ll_BFu0c()
{
  {
    init_simple_test("aUc_BFu9ll_BFu0c");
    static aUc_BFu9ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu9ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu9ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu9ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu9ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu9ll_BFu0c(Test_aUc_BFu9ll_BFu0c, "aUc_BFu9ll_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu9ll_BFu0i()
{
  {
    init_simple_test("aUc_BFu9ll_BFu0i");
    static aUc_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu9ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu9ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu9ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu9ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu9ll_BFu0i(Test_aUc_BFu9ll_BFu0i, "aUc_BFu9ll_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu9ll_BFu0ll()
{
  {
    init_simple_test("aUc_BFu9ll_BFu0ll");
    static aUc_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu9ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu9ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu9ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu9ll_BFu0ll(Test_aUc_BFu9ll_BFu0ll, "aUc_BFu9ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu9ll_BFu0s()
{
  {
    init_simple_test("aUc_BFu9ll_BFu0s");
    static aUc_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu9ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu9ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu9ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu9ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu9ll_BFu0s(Test_aUc_BFu9ll_BFu0s, "aUc_BFu9ll_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu9s_BFu0c()
{
  {
    init_simple_test("aUc_BFu9s_BFu0c");
    static aUc_BFu9s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_BFu9s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu9s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_BFu9s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu9s_BFu0c");
  }
}
static Arrange_To_Call_Me vaUc_BFu9s_BFu0c(Test_aUc_BFu9s_BFu0c, "aUc_BFu9s_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu9s_BFu0i()
{
  {
    init_simple_test("aUc_BFu9s_BFu0i");
    static aUc_BFu9s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu9s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu9s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_BFu9s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu9s_BFu0i");
  }
}
static Arrange_To_Call_Me vaUc_BFu9s_BFu0i(Test_aUc_BFu9s_BFu0i, "aUc_BFu9s_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu9s_BFu0ll()
{
  {
    init_simple_test("aUc_BFu9s_BFu0ll");
    static aUc_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu9s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu9s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_BFu9s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu9s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUc_BFu9s_BFu0ll(Test_aUc_BFu9s_BFu0ll, "aUc_BFu9s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_BFu9s_BFu0s()
{
  {
    init_simple_test("aUc_BFu9s_BFu0s");
    static aUc_BFu9s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu9s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu9s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_BFu9s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aUc_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aUc_BFu9s_BFu0s");
  }
}
static Arrange_To_Call_Me vaUc_BFu9s_BFu0s(Test_aUc_BFu9s_BFu0s, "aUc_BFu9s_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_C_BFu0c()
{
  {
    init_simple_test("aUc_C_BFu0c");
    static aUc_C_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_C_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_C_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_C_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_C_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUc_C_BFu0c(Test_aUc_C_BFu0c, "aUc_C_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_C_BFu0i()
{
  {
    init_simple_test("aUc_C_BFu0i");
    static aUc_C_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_C_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_C_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_C_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_C_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUc_C_BFu0i(Test_aUc_C_BFu0i, "aUc_C_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_C_BFu0ll()
{
  {
    init_simple_test("aUc_C_BFu0ll");
    static aUc_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_C_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_C_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_C_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_C_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUc_C_BFu0ll(Test_aUc_C_BFu0ll, "aUc_C_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_C_BFu0s()
{
  {
    init_simple_test("aUc_C_BFu0s");
    static aUc_C_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_C_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_C_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_C_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_C_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUc_C_BFu0s(Test_aUc_C_BFu0s, "aUc_C_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_D_BFu0c()
{
  {
    init_simple_test("aUc_D_BFu0c");
    static aUc_D_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aUc_D_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUc_D_BFu0c(Test_aUc_D_BFu0c, "aUc_D_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_D_BFu0i()
{
  {
    init_simple_test("aUc_D_BFu0i");
    static aUc_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aUc_D_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUc_D_BFu0i(Test_aUc_D_BFu0i, "aUc_D_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_D_BFu0ll()
{
  {
    init_simple_test("aUc_D_BFu0ll");
    static aUc_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUc_D_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUc_D_BFu0ll(Test_aUc_D_BFu0ll, "aUc_D_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_D_BFu0s()
{
  {
    init_simple_test("aUc_D_BFu0s");
    static aUc_D_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aUc_D_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUc_D_BFu0s(Test_aUc_D_BFu0s, "aUc_D_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_F_BFu0c()
{
  {
    init_simple_test("aUc_F_BFu0c");
    static aUc_F_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUc_F_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUc_F_BFu0c(Test_aUc_F_BFu0c, "aUc_F_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_F_BFu0i()
{
  {
    init_simple_test("aUc_F_BFu0i");
    static aUc_F_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_F_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUc_F_BFu0i(Test_aUc_F_BFu0i, "aUc_F_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_F_BFu0ll()
{
  {
    init_simple_test("aUc_F_BFu0ll");
    static aUc_F_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_F_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUc_F_BFu0ll(Test_aUc_F_BFu0ll, "aUc_F_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_F_BFu0s()
{
  {
    init_simple_test("aUc_F_BFu0s");
    static aUc_F_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_F_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUc_F_BFu0s(Test_aUc_F_BFu0s, "aUc_F_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_I_BFu0c()
{
  {
    init_simple_test("aUc_I_BFu0c");
    static aUc_I_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUc_I_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUc_I_BFu0c(Test_aUc_I_BFu0c, "aUc_I_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_I_BFu0i()
{
  {
    init_simple_test("aUc_I_BFu0i");
    static aUc_I_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_I_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUc_I_BFu0i(Test_aUc_I_BFu0i, "aUc_I_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_I_BFu0ll()
{
  {
    init_simple_test("aUc_I_BFu0ll");
    static aUc_I_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_I_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUc_I_BFu0ll(Test_aUc_I_BFu0ll, "aUc_I_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_I_BFu0s()
{
  {
    init_simple_test("aUc_I_BFu0s");
    static aUc_I_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_I_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUc_I_BFu0s(Test_aUc_I_BFu0s, "aUc_I_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Ip_BFu0c()
{
  {
    init_simple_test("aUc_Ip_BFu0c");
    static aUc_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_Ip_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUc_Ip_BFu0c(Test_aUc_Ip_BFu0c, "aUc_Ip_BFu0c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Ip_BFu0i()
{
  {
    init_simple_test("aUc_Ip_BFu0i");
    static aUc_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_Ip_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUc_Ip_BFu0i(Test_aUc_Ip_BFu0i, "aUc_Ip_BFu0i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Ip_BFu0ll()
{
  {
    init_simple_test("aUc_Ip_BFu0ll");
    static aUc_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aUc_Ip_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUc_Ip_BFu0ll(Test_aUc_Ip_BFu0ll, "aUc_Ip_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Ip_BFu0s()
{
  {
    init_simple_test("aUc_Ip_BFu0s");
    static aUc_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUc_Ip_BFu0s(Test_aUc_Ip_BFu0s, "aUc_Ip_BFu0s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_L_BFu0c()
{
  {
    init_simple_test("aUc_L_BFu0c");
    static aUc_L_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aUc_L_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUc_L_BFu0c(Test_aUc_L_BFu0c, "aUc_L_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_L_BFu0i()
{
  {
    init_simple_test("aUc_L_BFu0i");
    static aUc_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aUc_L_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUc_L_BFu0i(Test_aUc_L_BFu0i, "aUc_L_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_L_BFu0ll()
{
  {
    init_simple_test("aUc_L_BFu0ll");
    static aUc_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUc_L_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUc_L_BFu0ll(Test_aUc_L_BFu0ll, "aUc_L_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_L_BFu0s()
{
  {
    init_simple_test("aUc_L_BFu0s");
    static aUc_L_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aUc_L_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUc_L_BFu0s(Test_aUc_L_BFu0s, "aUc_L_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_S_BFu0c()
{
  {
    init_simple_test("aUc_S_BFu0c");
    static aUc_S_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_S_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUc_S_BFu0c(Test_aUc_S_BFu0c, "aUc_S_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_S_BFu0i()
{
  {
    init_simple_test("aUc_S_BFu0i");
    static aUc_S_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_S_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUc_S_BFu0i(Test_aUc_S_BFu0i, "aUc_S_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_S_BFu0ll()
{
  {
    init_simple_test("aUc_S_BFu0ll");
    static aUc_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_S_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUc_S_BFu0ll(Test_aUc_S_BFu0ll, "aUc_S_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_S_BFu0s()
{
  {
    init_simple_test("aUc_S_BFu0s");
    static aUc_S_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_S_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUc_S_BFu0s(Test_aUc_S_BFu0s, "aUc_S_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Uc_BFu0c()
{
  {
    init_simple_test("aUc_Uc_BFu0c");
    static aUc_Uc_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUc_Uc_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUc_Uc_BFu0c(Test_aUc_Uc_BFu0c, "aUc_Uc_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Uc_BFu0i()
{
  {
    init_simple_test("aUc_Uc_BFu0i");
    static aUc_Uc_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_Uc_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUc_Uc_BFu0i(Test_aUc_Uc_BFu0i, "aUc_Uc_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Uc_BFu0ll()
{
  {
    init_simple_test("aUc_Uc_BFu0ll");
    static aUc_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_Uc_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUc_Uc_BFu0ll(Test_aUc_Uc_BFu0ll, "aUc_Uc_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Uc_BFu0s()
{
  {
    init_simple_test("aUc_Uc_BFu0s");
    static aUc_Uc_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUc_Uc_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUc_Uc_BFu0s(Test_aUc_Uc_BFu0s, "aUc_Uc_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Ui_BFu0c()
{
  {
    init_simple_test("aUc_Ui_BFu0c");
    static aUc_Ui_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Ui_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUc_Ui_BFu0c(Test_aUc_Ui_BFu0c, "aUc_Ui_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Ui_BFu0i()
{
  {
    init_simple_test("aUc_Ui_BFu0i");
    static aUc_Ui_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_Ui_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUc_Ui_BFu0i(Test_aUc_Ui_BFu0i, "aUc_Ui_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Ui_BFu0ll()
{
  {
    init_simple_test("aUc_Ui_BFu0ll");
    static aUc_Ui_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUc_Ui_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUc_Ui_BFu0ll(Test_aUc_Ui_BFu0ll, "aUc_Ui_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Ui_BFu0s()
{
  {
    init_simple_test("aUc_Ui_BFu0s");
    static aUc_Ui_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUc_Ui_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUc_Ui_BFu0s(Test_aUc_Ui_BFu0s, "aUc_Ui_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Ul_BFu0c()
{
  {
    init_simple_test("aUc_Ul_BFu0c");
    static aUc_Ul_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aUc_Ul_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUc_Ul_BFu0c(Test_aUc_Ul_BFu0c, "aUc_Ul_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Ul_BFu0i()
{
  {
    init_simple_test("aUc_Ul_BFu0i");
    static aUc_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aUc_Ul_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUc_Ul_BFu0i(Test_aUc_Ul_BFu0i, "aUc_Ul_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Ul_BFu0ll()
{
  {
    init_simple_test("aUc_Ul_BFu0ll");
    static aUc_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUc_Ul_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUc_Ul_BFu0ll(Test_aUc_Ul_BFu0ll, "aUc_Ul_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Ul_BFu0s()
{
  {
    init_simple_test("aUc_Ul_BFu0s");
    static aUc_Ul_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aUc_Ul_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUc_Ul_BFu0s(Test_aUc_Ul_BFu0s, "aUc_Ul_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Us_BFu0c()
{
  {
    init_simple_test("aUc_Us_BFu0c");
    static aUc_Us_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Us_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUc_Us_BFu0c(Test_aUc_Us_BFu0c, "aUc_Us_BFu0c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Us_BFu0i()
{
  {
    init_simple_test("aUc_Us_BFu0i");
    static aUc_Us_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_Us_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUc_Us_BFu0i(Test_aUc_Us_BFu0i, "aUc_Us_BFu0i", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Us_BFu0ll()
{
  {
    init_simple_test("aUc_Us_BFu0ll");
    static aUc_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_Us_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUc_Us_BFu0ll(Test_aUc_Us_BFu0ll, "aUc_Us_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Us_BFu0s()
{
  {
    init_simple_test("aUc_Us_BFu0s");
    static aUc_Us_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_Us_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUc_Us_BFu0s(Test_aUc_Us_BFu0s, "aUc_Us_BFu0s", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Vp_BFu0c()
{
  {
    init_simple_test("aUc_Vp_BFu0c");
    static aUc_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_Vp_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUc_Vp_BFu0c(Test_aUc_Vp_BFu0c, "aUc_Vp_BFu0c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Vp_BFu0i()
{
  {
    init_simple_test("aUc_Vp_BFu0i");
    static aUc_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_Vp_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUc_Vp_BFu0i(Test_aUc_Vp_BFu0i, "aUc_Vp_BFu0i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Vp_BFu0ll()
{
  {
    init_simple_test("aUc_Vp_BFu0ll");
    static aUc_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aUc_Vp_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUc_Vp_BFu0ll(Test_aUc_Vp_BFu0ll, "aUc_Vp_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUc_Vp_BFu0s()
{
  {
    init_simple_test("aUc_Vp_BFu0s");
    static aUc_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUc_Vp_BFu0s(Test_aUc_Vp_BFu0s, "aUc_Vp_BFu0s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c()
{
  {
    init_simple_test("aUi_BFu0c");
    static aUi_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c(Test_aUi_BFu0c, "aUi_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu0c()
{
  {
    init_simple_test("aUi_BFu0c_BFu0c");
    static aUi_BFu0c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu0c(Test_aUi_BFu0c_BFu0c, "aUi_BFu0c_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu0i()
{
  {
    init_simple_test("aUi_BFu0c_BFu0i");
    static aUi_BFu0c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu0i(Test_aUi_BFu0c_BFu0i, "aUi_BFu0c_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu0ll()
{
  {
    init_simple_test("aUi_BFu0c_BFu0ll");
    static aUi_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUi_BFu0c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu0ll(Test_aUi_BFu0c_BFu0ll, "aUi_BFu0c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu0s()
{
  {
    init_simple_test("aUi_BFu0c_BFu0s");
    static aUi_BFu0c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu0s(Test_aUi_BFu0c_BFu0s, "aUi_BFu0c_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu15i()
{
  {
    init_simple_test("aUi_BFu0c_BFu15i");
    static aUi_BFu0c_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu0c_BFu15i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu15i(Test_aUi_BFu0c_BFu15i, "aUi_BFu0c_BFu15i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu15ll()
{
  {
    init_simple_test("aUi_BFu0c_BFu15ll");
    static aUi_BFu0c_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu0c_BFu15ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu15ll(Test_aUi_BFu0c_BFu15ll, "aUi_BFu0c_BFu15ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu15s()
{
  {
    init_simple_test("aUi_BFu0c_BFu15s");
    static aUi_BFu0c_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu0c_BFu15s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu15s(Test_aUi_BFu0c_BFu15s, "aUi_BFu0c_BFu15s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu16i()
{
  {
    init_simple_test("aUi_BFu0c_BFu16i");
    static aUi_BFu0c_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu0c_BFu16i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu16i(Test_aUi_BFu0c_BFu16i, "aUi_BFu0c_BFu16i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu16ll()
{
  {
    init_simple_test("aUi_BFu0c_BFu16ll");
    static aUi_BFu0c_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu0c_BFu16ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu16ll(Test_aUi_BFu0c_BFu16ll, "aUi_BFu0c_BFu16ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu16s()
{
  {
    init_simple_test("aUi_BFu0c_BFu16s");
    static aUi_BFu0c_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu0c_BFu16s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu16s(Test_aUi_BFu0c_BFu16s, "aUi_BFu0c_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu17i()
{
  {
    init_simple_test("aUi_BFu0c_BFu17i");
    static aUi_BFu0c_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu0c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu0c_BFu17i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu17i(Test_aUi_BFu0c_BFu17i, "aUi_BFu0c_BFu17i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu17ll()
{
  {
    init_simple_test("aUi_BFu0c_BFu17ll");
    static aUi_BFu0c_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu0c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu0c_BFu17ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu17ll(Test_aUi_BFu0c_BFu17ll, "aUi_BFu0c_BFu17ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu1c()
{
  {
    init_simple_test("aUi_BFu0c_BFu1c");
    static aUi_BFu0c_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu0c_BFu1c");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu1c(Test_aUi_BFu0c_BFu1c, "aUi_BFu0c_BFu1c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu1i()
{
  {
    init_simple_test("aUi_BFu0c_BFu1i");
    static aUi_BFu0c_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu0c_BFu1i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu1i(Test_aUi_BFu0c_BFu1i, "aUi_BFu0c_BFu1i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu1ll()
{
  {
    init_simple_test("aUi_BFu0c_BFu1ll");
    static aUi_BFu0c_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu0c_BFu1ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu1ll(Test_aUi_BFu0c_BFu1ll, "aUi_BFu0c_BFu1ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu1s()
{
  {
    init_simple_test("aUi_BFu0c_BFu1s");
    static aUi_BFu0c_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu0c_BFu1s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu1s(Test_aUi_BFu0c_BFu1s, "aUi_BFu0c_BFu1s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu31i()
{
  {
    init_simple_test("aUi_BFu0c_BFu31i");
    static aUi_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu0c_BFu31i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu31i(Test_aUi_BFu0c_BFu31i, "aUi_BFu0c_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu31ll()
{
  {
    init_simple_test("aUi_BFu0c_BFu31ll");
    static aUi_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu0c_BFu31ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu31ll(Test_aUi_BFu0c_BFu31ll, "aUi_BFu0c_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu32i()
{
  {
    init_simple_test("aUi_BFu0c_BFu32i");
    static aUi_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu0c_BFu32i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu32i(Test_aUi_BFu0c_BFu32i, "aUi_BFu0c_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu32ll()
{
  {
    init_simple_test("aUi_BFu0c_BFu32ll");
    static aUi_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu0c_BFu32ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu32ll(Test_aUi_BFu0c_BFu32ll, "aUi_BFu0c_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu33()
{
  {
    init_simple_test("aUi_BFu0c_BFu33");
    static aUi_BFu0c_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu0c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aUi_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aUi_BFu0c_BFu33");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu33(Test_aUi_BFu0c_BFu33, "aUi_BFu0c_BFu33", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu7c()
{
  {
    init_simple_test("aUi_BFu0c_BFu7c");
    static aUi_BFu0c_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu0c_BFu7c");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu7c(Test_aUi_BFu0c_BFu7c, "aUi_BFu0c_BFu7c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu7i()
{
  {
    init_simple_test("aUi_BFu0c_BFu7i");
    static aUi_BFu0c_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu0c_BFu7i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu7i(Test_aUi_BFu0c_BFu7i, "aUi_BFu0c_BFu7i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu7ll()
{
  {
    init_simple_test("aUi_BFu0c_BFu7ll");
    static aUi_BFu0c_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu0c_BFu7ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu7ll(Test_aUi_BFu0c_BFu7ll, "aUi_BFu0c_BFu7ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu7s()
{
  {
    init_simple_test("aUi_BFu0c_BFu7s");
    static aUi_BFu0c_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu0c_BFu7s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu7s(Test_aUi_BFu0c_BFu7s, "aUi_BFu0c_BFu7s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu8c()
{
  {
    init_simple_test("aUi_BFu0c_BFu8c");
    static aUi_BFu0c_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu0c_BFu8c");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu8c(Test_aUi_BFu0c_BFu8c, "aUi_BFu0c_BFu8c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu8i()
{
  {
    init_simple_test("aUi_BFu0c_BFu8i");
    static aUi_BFu0c_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu0c_BFu8i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu8i(Test_aUi_BFu0c_BFu8i, "aUi_BFu0c_BFu8i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu8ll()
{
  {
    init_simple_test("aUi_BFu0c_BFu8ll");
    static aUi_BFu0c_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu0c_BFu8ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu8ll(Test_aUi_BFu0c_BFu8ll, "aUi_BFu0c_BFu8ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu8s()
{
  {
    init_simple_test("aUi_BFu0c_BFu8s");
    static aUi_BFu0c_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu0c_BFu8s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu8s(Test_aUi_BFu0c_BFu8s, "aUi_BFu0c_BFu8s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu9i()
{
  {
    init_simple_test("aUi_BFu0c_BFu9i");
    static aUi_BFu0c_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu0c_BFu9i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu9i(Test_aUi_BFu0c_BFu9i, "aUi_BFu0c_BFu9i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu9ll()
{
  {
    init_simple_test("aUi_BFu0c_BFu9ll");
    static aUi_BFu0c_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu0c_BFu9ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu9ll(Test_aUi_BFu0c_BFu9ll, "aUi_BFu0c_BFu9ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_BFu9s()
{
  {
    init_simple_test("aUi_BFu0c_BFu9s");
    static aUi_BFu0c_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu0c_BFu9s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_BFu9s(Test_aUi_BFu0c_BFu9s, "aUi_BFu0c_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_C()
{
  {
    init_simple_test("aUi_BFu0c_C");
    static aUi_BFu0c_C lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_C.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_C.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_C(Test_aUi_BFu0c_C, "aUi_BFu0c_C", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_D()
{
  {
    init_simple_test("aUi_BFu0c_D");
    static aUi_BFu0c_D lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu0c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_D.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_D.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_D(Test_aUi_BFu0c_D, "aUi_BFu0c_D", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_F()
{
  {
    init_simple_test("aUi_BFu0c_F");
    static aUi_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_F.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_F.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_F(Test_aUi_BFu0c_F, "aUi_BFu0c_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_I()
{
  {
    init_simple_test("aUi_BFu0c_I");
    static aUi_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_I.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_I.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_I(Test_aUi_BFu0c_I, "aUi_BFu0c_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_Ip()
{
  {
    init_simple_test("aUi_BFu0c_Ip");
    static aUi_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_BFu0c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_Ip.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_Ip.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_Ip(Test_aUi_BFu0c_Ip, "aUi_BFu0c_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_L()
{
  {
    init_simple_test("aUi_BFu0c_L");
    static aUi_BFu0c_L lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu0c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_L.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_L.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_L(Test_aUi_BFu0c_L, "aUi_BFu0c_L", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_S()
{
  {
    init_simple_test("aUi_BFu0c_S");
    static aUi_BFu0c_S lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_S.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_S.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_S(Test_aUi_BFu0c_S, "aUi_BFu0c_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_Uc()
{
  {
    init_simple_test("aUi_BFu0c_Uc");
    static aUi_BFu0c_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_Uc.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_Uc.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_Uc(Test_aUi_BFu0c_Uc, "aUi_BFu0c_Uc", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_Ui()
{
  {
    init_simple_test("aUi_BFu0c_Ui");
    static aUi_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_Ui.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_Ui.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_Ui(Test_aUi_BFu0c_Ui, "aUi_BFu0c_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_Ul()
{
  {
    init_simple_test("aUi_BFu0c_Ul");
    static aUi_BFu0c_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu0c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_Ul.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_Ul.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_Ul(Test_aUi_BFu0c_Ul, "aUi_BFu0c_Ul", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_Us()
{
  {
    init_simple_test("aUi_BFu0c_Us");
    static aUi_BFu0c_Us lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_Us.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_Us.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_Us(Test_aUi_BFu0c_Us, "aUi_BFu0c_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0c_Vp()
{
  {
    init_simple_test("aUi_BFu0c_Vp");
    static aUi_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_BFu0c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_Vp.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_Vp.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0c_Vp(Test_aUi_BFu0c_Vp, "aUi_BFu0c_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i()
{
  {
    init_simple_test("aUi_BFu0i");
    static aUi_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i(Test_aUi_BFu0i, "aUi_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu0c()
{
  {
    init_simple_test("aUi_BFu0i_BFu0c");
    static aUi_BFu0i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu0c(Test_aUi_BFu0i_BFu0c, "aUi_BFu0i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu0i()
{
  {
    init_simple_test("aUi_BFu0i_BFu0i");
    static aUi_BFu0i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu0i(Test_aUi_BFu0i_BFu0i, "aUi_BFu0i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu0ll()
{
  {
    init_simple_test("aUi_BFu0i_BFu0ll");
    static aUi_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUi_BFu0i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu0ll(Test_aUi_BFu0i_BFu0ll, "aUi_BFu0i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu0s()
{
  {
    init_simple_test("aUi_BFu0i_BFu0s");
    static aUi_BFu0i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu0s(Test_aUi_BFu0i_BFu0s, "aUi_BFu0i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu15i()
{
  {
    init_simple_test("aUi_BFu0i_BFu15i");
    static aUi_BFu0i_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu0i_BFu15i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu15i(Test_aUi_BFu0i_BFu15i, "aUi_BFu0i_BFu15i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu15ll()
{
  {
    init_simple_test("aUi_BFu0i_BFu15ll");
    static aUi_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu0i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu15ll(Test_aUi_BFu0i_BFu15ll, "aUi_BFu0i_BFu15ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu15s()
{
  {
    init_simple_test("aUi_BFu0i_BFu15s");
    static aUi_BFu0i_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu0i_BFu15s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu15s(Test_aUi_BFu0i_BFu15s, "aUi_BFu0i_BFu15s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu16i()
{
  {
    init_simple_test("aUi_BFu0i_BFu16i");
    static aUi_BFu0i_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu0i_BFu16i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu16i(Test_aUi_BFu0i_BFu16i, "aUi_BFu0i_BFu16i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu16ll()
{
  {
    init_simple_test("aUi_BFu0i_BFu16ll");
    static aUi_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu0i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu16ll(Test_aUi_BFu0i_BFu16ll, "aUi_BFu0i_BFu16ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu16s()
{
  {
    init_simple_test("aUi_BFu0i_BFu16s");
    static aUi_BFu0i_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu0i_BFu16s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu16s(Test_aUi_BFu0i_BFu16s, "aUi_BFu0i_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu17i()
{
  {
    init_simple_test("aUi_BFu0i_BFu17i");
    static aUi_BFu0i_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu0i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu0i_BFu17i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu17i(Test_aUi_BFu0i_BFu17i, "aUi_BFu0i_BFu17i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu17ll()
{
  {
    init_simple_test("aUi_BFu0i_BFu17ll");
    static aUi_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu0i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu0i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu17ll(Test_aUi_BFu0i_BFu17ll, "aUi_BFu0i_BFu17ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu1c()
{
  {
    init_simple_test("aUi_BFu0i_BFu1c");
    static aUi_BFu0i_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu0i_BFu1c");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu1c(Test_aUi_BFu0i_BFu1c, "aUi_BFu0i_BFu1c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu1i()
{
  {
    init_simple_test("aUi_BFu0i_BFu1i");
    static aUi_BFu0i_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu0i_BFu1i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu1i(Test_aUi_BFu0i_BFu1i, "aUi_BFu0i_BFu1i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu1ll()
{
  {
    init_simple_test("aUi_BFu0i_BFu1ll");
    static aUi_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu0i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu1ll(Test_aUi_BFu0i_BFu1ll, "aUi_BFu0i_BFu1ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu1s()
{
  {
    init_simple_test("aUi_BFu0i_BFu1s");
    static aUi_BFu0i_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu0i_BFu1s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu1s(Test_aUi_BFu0i_BFu1s, "aUi_BFu0i_BFu1s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu31i()
{
  {
    init_simple_test("aUi_BFu0i_BFu31i");
    static aUi_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu0i_BFu31i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu31i(Test_aUi_BFu0i_BFu31i, "aUi_BFu0i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu31ll()
{
  {
    init_simple_test("aUi_BFu0i_BFu31ll");
    static aUi_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu0i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu31ll(Test_aUi_BFu0i_BFu31ll, "aUi_BFu0i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu32i()
{
  {
    init_simple_test("aUi_BFu0i_BFu32i");
    static aUi_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu0i_BFu32i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu32i(Test_aUi_BFu0i_BFu32i, "aUi_BFu0i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu32ll()
{
  {
    init_simple_test("aUi_BFu0i_BFu32ll");
    static aUi_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu0i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu32ll(Test_aUi_BFu0i_BFu32ll, "aUi_BFu0i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu33()
{
  {
    init_simple_test("aUi_BFu0i_BFu33");
    static aUi_BFu0i_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu0i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aUi_BFu0i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aUi_BFu0i_BFu33");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu33(Test_aUi_BFu0i_BFu33, "aUi_BFu0i_BFu33", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu7c()
{
  {
    init_simple_test("aUi_BFu0i_BFu7c");
    static aUi_BFu0i_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu0i_BFu7c");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu7c(Test_aUi_BFu0i_BFu7c, "aUi_BFu0i_BFu7c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu7i()
{
  {
    init_simple_test("aUi_BFu0i_BFu7i");
    static aUi_BFu0i_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu0i_BFu7i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu7i(Test_aUi_BFu0i_BFu7i, "aUi_BFu0i_BFu7i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu7ll()
{
  {
    init_simple_test("aUi_BFu0i_BFu7ll");
    static aUi_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu0i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu7ll(Test_aUi_BFu0i_BFu7ll, "aUi_BFu0i_BFu7ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu7s()
{
  {
    init_simple_test("aUi_BFu0i_BFu7s");
    static aUi_BFu0i_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu0i_BFu7s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu7s(Test_aUi_BFu0i_BFu7s, "aUi_BFu0i_BFu7s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu8c()
{
  {
    init_simple_test("aUi_BFu0i_BFu8c");
    static aUi_BFu0i_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu0i_BFu8c");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu8c(Test_aUi_BFu0i_BFu8c, "aUi_BFu0i_BFu8c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu8i()
{
  {
    init_simple_test("aUi_BFu0i_BFu8i");
    static aUi_BFu0i_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu0i_BFu8i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu8i(Test_aUi_BFu0i_BFu8i, "aUi_BFu0i_BFu8i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu8ll()
{
  {
    init_simple_test("aUi_BFu0i_BFu8ll");
    static aUi_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu0i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu8ll(Test_aUi_BFu0i_BFu8ll, "aUi_BFu0i_BFu8ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu8s()
{
  {
    init_simple_test("aUi_BFu0i_BFu8s");
    static aUi_BFu0i_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu0i_BFu8s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu8s(Test_aUi_BFu0i_BFu8s, "aUi_BFu0i_BFu8s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu9i()
{
  {
    init_simple_test("aUi_BFu0i_BFu9i");
    static aUi_BFu0i_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu0i_BFu9i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu9i(Test_aUi_BFu0i_BFu9i, "aUi_BFu0i_BFu9i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu9ll()
{
  {
    init_simple_test("aUi_BFu0i_BFu9ll");
    static aUi_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu0i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu9ll(Test_aUi_BFu0i_BFu9ll, "aUi_BFu0i_BFu9ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_BFu9s()
{
  {
    init_simple_test("aUi_BFu0i_BFu9s");
    static aUi_BFu0i_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu0i_BFu9s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_BFu9s(Test_aUi_BFu0i_BFu9s, "aUi_BFu0i_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_C()
{
  {
    init_simple_test("aUi_BFu0i_C");
    static aUi_BFu0i_C lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_C.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_C.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_C(Test_aUi_BFu0i_C, "aUi_BFu0i_C", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_D()
{
  {
    init_simple_test("aUi_BFu0i_D");
    static aUi_BFu0i_D lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu0i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_D.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_D.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_D(Test_aUi_BFu0i_D, "aUi_BFu0i_D", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_F()
{
  {
    init_simple_test("aUi_BFu0i_F");
    static aUi_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_F.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_F.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_F(Test_aUi_BFu0i_F, "aUi_BFu0i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_I()
{
  {
    init_simple_test("aUi_BFu0i_I");
    static aUi_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_I.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_I.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_I(Test_aUi_BFu0i_I, "aUi_BFu0i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_Ip()
{
  {
    init_simple_test("aUi_BFu0i_Ip");
    static aUi_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_BFu0i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_Ip.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_Ip.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_Ip(Test_aUi_BFu0i_Ip, "aUi_BFu0i_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_L()
{
  {
    init_simple_test("aUi_BFu0i_L");
    static aUi_BFu0i_L lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu0i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_L.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_L.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_L(Test_aUi_BFu0i_L, "aUi_BFu0i_L", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_S()
{
  {
    init_simple_test("aUi_BFu0i_S");
    static aUi_BFu0i_S lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_S.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_S.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_S(Test_aUi_BFu0i_S, "aUi_BFu0i_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_Uc()
{
  {
    init_simple_test("aUi_BFu0i_Uc");
    static aUi_BFu0i_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_Uc.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_Uc.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_Uc(Test_aUi_BFu0i_Uc, "aUi_BFu0i_Uc", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_Ui()
{
  {
    init_simple_test("aUi_BFu0i_Ui");
    static aUi_BFu0i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_Ui.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_Ui.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_Ui(Test_aUi_BFu0i_Ui, "aUi_BFu0i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_Ul()
{
  {
    init_simple_test("aUi_BFu0i_Ul");
    static aUi_BFu0i_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu0i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_Ul.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_Ul.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_Ul(Test_aUi_BFu0i_Ul, "aUi_BFu0i_Ul", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_Us()
{
  {
    init_simple_test("aUi_BFu0i_Us");
    static aUi_BFu0i_Us lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_Us.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_Us.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_Us(Test_aUi_BFu0i_Us, "aUi_BFu0i_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0i_Vp()
{
  {
    init_simple_test("aUi_BFu0i_Vp");
    static aUi_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_BFu0i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_Vp.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_Vp.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0i_Vp(Test_aUi_BFu0i_Vp, "aUi_BFu0i_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll()
{
  {
    init_simple_test("aUi_BFu0ll");
    static aUi_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUi_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll(Test_aUi_BFu0ll, "aUi_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu0c()
{
  {
    init_simple_test("aUi_BFu0ll_BFu0c");
    static aUi_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUi_BFu0ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu0c(Test_aUi_BFu0ll_BFu0c, "aUi_BFu0ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu0i()
{
  {
    init_simple_test("aUi_BFu0ll_BFu0i");
    static aUi_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUi_BFu0ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu0i(Test_aUi_BFu0ll_BFu0i, "aUi_BFu0ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu0ll()
{
  {
    init_simple_test("aUi_BFu0ll_BFu0ll");
    static aUi_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUi_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu0ll(Test_aUi_BFu0ll_BFu0ll, "aUi_BFu0ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu0s()
{
  {
    init_simple_test("aUi_BFu0ll_BFu0s");
    static aUi_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUi_BFu0ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu0s(Test_aUi_BFu0ll_BFu0s, "aUi_BFu0ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu15i()
{
  {
    init_simple_test("aUi_BFu0ll_BFu15i");
    static aUi_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUi_BFu0ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aUi_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aUi_BFu0ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu15i(Test_aUi_BFu0ll_BFu15i, "aUi_BFu0ll_BFu15i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu15ll()
{
  {
    init_simple_test("aUi_BFu0ll_BFu15ll");
    static aUi_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUi_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aUi_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aUi_BFu0ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu15ll(Test_aUi_BFu0ll_BFu15ll, "aUi_BFu0ll_BFu15ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu15s()
{
  {
    init_simple_test("aUi_BFu0ll_BFu15s");
    static aUi_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUi_BFu0ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aUi_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aUi_BFu0ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu15s(Test_aUi_BFu0ll_BFu15s, "aUi_BFu0ll_BFu15s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu16i()
{
  {
    init_simple_test("aUi_BFu0ll_BFu16i");
    static aUi_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUi_BFu0ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aUi_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aUi_BFu0ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu16i(Test_aUi_BFu0ll_BFu16i, "aUi_BFu0ll_BFu16i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu16ll()
{
  {
    init_simple_test("aUi_BFu0ll_BFu16ll");
    static aUi_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUi_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aUi_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aUi_BFu0ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu16ll(Test_aUi_BFu0ll_BFu16ll, "aUi_BFu0ll_BFu16ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu16s()
{
  {
    init_simple_test("aUi_BFu0ll_BFu16s");
    static aUi_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUi_BFu0ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aUi_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aUi_BFu0ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu16s(Test_aUi_BFu0ll_BFu16s, "aUi_BFu0ll_BFu16s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu17i()
{
  {
    init_simple_test("aUi_BFu0ll_BFu17i");
    static aUi_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUi_BFu0ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aUi_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aUi_BFu0ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu17i(Test_aUi_BFu0ll_BFu17i, "aUi_BFu0ll_BFu17i", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu17ll()
{
  {
    init_simple_test("aUi_BFu0ll_BFu17ll");
    static aUi_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUi_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aUi_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aUi_BFu0ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu17ll(Test_aUi_BFu0ll_BFu17ll, "aUi_BFu0ll_BFu17ll", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu1c()
{
  {
    init_simple_test("aUi_BFu0ll_BFu1c");
    static aUi_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aUi_BFu0ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu1c(Test_aUi_BFu0ll_BFu1c, "aUi_BFu0ll_BFu1c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu1i()
{
  {
    init_simple_test("aUi_BFu0ll_BFu1i");
    static aUi_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aUi_BFu0ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu1i(Test_aUi_BFu0ll_BFu1i, "aUi_BFu0ll_BFu1i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu1ll()
{
  {
    init_simple_test("aUi_BFu0ll_BFu1ll");
    static aUi_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aUi_BFu0ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu1ll(Test_aUi_BFu0ll_BFu1ll, "aUi_BFu0ll_BFu1ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu1s()
{
  {
    init_simple_test("aUi_BFu0ll_BFu1s");
    static aUi_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aUi_BFu0ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu1s(Test_aUi_BFu0ll_BFu1s, "aUi_BFu0ll_BFu1s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu31i()
{
  {
    init_simple_test("aUi_BFu0ll_BFu31i");
    static aUi_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_BFu0ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aUi_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aUi_BFu0ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu31i(Test_aUi_BFu0ll_BFu31i, "aUi_BFu0ll_BFu31i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu31ll()
{
  {
    init_simple_test("aUi_BFu0ll_BFu31ll");
    static aUi_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aUi_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aUi_BFu0ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu31ll(Test_aUi_BFu0ll_BFu31ll, "aUi_BFu0ll_BFu31ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu32i()
{
  {
    init_simple_test("aUi_BFu0ll_BFu32i");
    static aUi_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_BFu0ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aUi_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aUi_BFu0ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu32i(Test_aUi_BFu0ll_BFu32i, "aUi_BFu0ll_BFu32i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu32ll()
{
  {
    init_simple_test("aUi_BFu0ll_BFu32ll");
    static aUi_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aUi_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aUi_BFu0ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu32ll(Test_aUi_BFu0ll_BFu32ll, "aUi_BFu0ll_BFu32ll", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu33()
{
  {
    init_simple_test("aUi_BFu0ll_BFu33");
    static aUi_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUi_BFu0ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aUi_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aUi_BFu0ll_BFu33");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu33(Test_aUi_BFu0ll_BFu33, "aUi_BFu0ll_BFu33", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu7c()
{
  {
    init_simple_test("aUi_BFu0ll_BFu7c");
    static aUi_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aUi_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aUi_BFu0ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu7c(Test_aUi_BFu0ll_BFu7c, "aUi_BFu0ll_BFu7c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu7i()
{
  {
    init_simple_test("aUi_BFu0ll_BFu7i");
    static aUi_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aUi_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aUi_BFu0ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu7i(Test_aUi_BFu0ll_BFu7i, "aUi_BFu0ll_BFu7i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu7ll()
{
  {
    init_simple_test("aUi_BFu0ll_BFu7ll");
    static aUi_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aUi_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aUi_BFu0ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu7ll(Test_aUi_BFu0ll_BFu7ll, "aUi_BFu0ll_BFu7ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu7s()
{
  {
    init_simple_test("aUi_BFu0ll_BFu7s");
    static aUi_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aUi_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aUi_BFu0ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu7s(Test_aUi_BFu0ll_BFu7s, "aUi_BFu0ll_BFu7s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu8c()
{
  {
    init_simple_test("aUi_BFu0ll_BFu8c");
    static aUi_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aUi_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aUi_BFu0ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu8c(Test_aUi_BFu0ll_BFu8c, "aUi_BFu0ll_BFu8c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu8i()
{
  {
    init_simple_test("aUi_BFu0ll_BFu8i");
    static aUi_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aUi_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aUi_BFu0ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu8i(Test_aUi_BFu0ll_BFu8i, "aUi_BFu0ll_BFu8i", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu8ll()
{
  {
    init_simple_test("aUi_BFu0ll_BFu8ll");
    static aUi_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aUi_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aUi_BFu0ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu8ll(Test_aUi_BFu0ll_BFu8ll, "aUi_BFu0ll_BFu8ll", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu8s()
{
  {
    init_simple_test("aUi_BFu0ll_BFu8s");
    static aUi_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aUi_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aUi_BFu0ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu8s(Test_aUi_BFu0ll_BFu8s, "aUi_BFu0ll_BFu8s", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu9i()
{
  {
    init_simple_test("aUi_BFu0ll_BFu9i");
    static aUi_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUi_BFu0ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aUi_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aUi_BFu0ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu9i(Test_aUi_BFu0ll_BFu9i, "aUi_BFu0ll_BFu9i", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu9ll()
{
  {
    init_simple_test("aUi_BFu0ll_BFu9ll");
    static aUi_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUi_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aUi_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aUi_BFu0ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu9ll(Test_aUi_BFu0ll_BFu9ll, "aUi_BFu0ll_BFu9ll", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_BFu9s()
{
  {
    init_simple_test("aUi_BFu0ll_BFu9s");
    static aUi_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUi_BFu0ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aUi_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aUi_BFu0ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_BFu9s(Test_aUi_BFu0ll_BFu9s, "aUi_BFu0ll_BFu9s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_C()
{
  {
    init_simple_test("aUi_BFu0ll_C");
    static aUi_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_C.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_C(Test_aUi_BFu0ll_C, "aUi_BFu0ll_C", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_D()
{
  {
    init_simple_test("aUi_BFu0ll_D");
    static aUi_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUi_BFu0ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_D.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_D(Test_aUi_BFu0ll_D, "aUi_BFu0ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_F()
{
  {
    init_simple_test("aUi_BFu0ll_F");
    static aUi_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_BFu0ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_F.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_F(Test_aUi_BFu0ll_F, "aUi_BFu0ll_F", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_I()
{
  {
    init_simple_test("aUi_BFu0ll_I");
    static aUi_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_BFu0ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_I.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_I(Test_aUi_BFu0ll_I, "aUi_BFu0ll_I", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_Ip()
{
  {
    init_simple_test("aUi_BFu0ll_Ip");
    static aUi_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aUi_BFu0ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_Ip(Test_aUi_BFu0ll_Ip, "aUi_BFu0ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_L()
{
  {
    init_simple_test("aUi_BFu0ll_L");
    static aUi_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUi_BFu0ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_L.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_L(Test_aUi_BFu0ll_L, "aUi_BFu0ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_S()
{
  {
    init_simple_test("aUi_BFu0ll_S");
    static aUi_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUi_BFu0ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_S.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_S(Test_aUi_BFu0ll_S, "aUi_BFu0ll_S", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_Uc()
{
  {
    init_simple_test("aUi_BFu0ll_Uc");
    static aUi_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUi_BFu0ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_Uc(Test_aUi_BFu0ll_Uc, "aUi_BFu0ll_Uc", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_Ui()
{
  {
    init_simple_test("aUi_BFu0ll_Ui");
    static aUi_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_BFu0ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_Ui(Test_aUi_BFu0ll_Ui, "aUi_BFu0ll_Ui", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_Ul()
{
  {
    init_simple_test("aUi_BFu0ll_Ul");
    static aUi_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUi_BFu0ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_Ul(Test_aUi_BFu0ll_Ul, "aUi_BFu0ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_Us()
{
  {
    init_simple_test("aUi_BFu0ll_Us");
    static aUi_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUi_BFu0ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_Us.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_Us(Test_aUi_BFu0ll_Us, "aUi_BFu0ll_Us", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0ll_Vp()
{
  {
    init_simple_test("aUi_BFu0ll_Vp");
    static aUi_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aUi_BFu0ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0ll_Vp(Test_aUi_BFu0ll_Vp, "aUi_BFu0ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s()
{
  {
    init_simple_test("aUi_BFu0s");
    static aUi_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s(Test_aUi_BFu0s, "aUi_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu0c()
{
  {
    init_simple_test("aUi_BFu0s_BFu0c");
    static aUi_BFu0s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu0c(Test_aUi_BFu0s_BFu0c, "aUi_BFu0s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu0i()
{
  {
    init_simple_test("aUi_BFu0s_BFu0i");
    static aUi_BFu0s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu0i(Test_aUi_BFu0s_BFu0i, "aUi_BFu0s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu0ll()
{
  {
    init_simple_test("aUi_BFu0s_BFu0ll");
    static aUi_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUi_BFu0s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu0ll(Test_aUi_BFu0s_BFu0ll, "aUi_BFu0s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu0s()
{
  {
    init_simple_test("aUi_BFu0s_BFu0s");
    static aUi_BFu0s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu0s(Test_aUi_BFu0s_BFu0s, "aUi_BFu0s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu15i()
{
  {
    init_simple_test("aUi_BFu0s_BFu15i");
    static aUi_BFu0s_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu0s_BFu15i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu15i(Test_aUi_BFu0s_BFu15i, "aUi_BFu0s_BFu15i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu15ll()
{
  {
    init_simple_test("aUi_BFu0s_BFu15ll");
    static aUi_BFu0s_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu0s_BFu15ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu15ll(Test_aUi_BFu0s_BFu15ll, "aUi_BFu0s_BFu15ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu15s()
{
  {
    init_simple_test("aUi_BFu0s_BFu15s");
    static aUi_BFu0s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu0s_BFu15s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu15s(Test_aUi_BFu0s_BFu15s, "aUi_BFu0s_BFu15s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu16i()
{
  {
    init_simple_test("aUi_BFu0s_BFu16i");
    static aUi_BFu0s_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu0s_BFu16i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu16i(Test_aUi_BFu0s_BFu16i, "aUi_BFu0s_BFu16i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu16ll()
{
  {
    init_simple_test("aUi_BFu0s_BFu16ll");
    static aUi_BFu0s_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu0s_BFu16ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu16ll(Test_aUi_BFu0s_BFu16ll, "aUi_BFu0s_BFu16ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu16s()
{
  {
    init_simple_test("aUi_BFu0s_BFu16s");
    static aUi_BFu0s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu0s_BFu16s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu16s(Test_aUi_BFu0s_BFu16s, "aUi_BFu0s_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu17i()
{
  {
    init_simple_test("aUi_BFu0s_BFu17i");
    static aUi_BFu0s_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu0s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu0s_BFu17i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu17i(Test_aUi_BFu0s_BFu17i, "aUi_BFu0s_BFu17i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu17ll()
{
  {
    init_simple_test("aUi_BFu0s_BFu17ll");
    static aUi_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu0s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu0s_BFu17ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu17ll(Test_aUi_BFu0s_BFu17ll, "aUi_BFu0s_BFu17ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu1c()
{
  {
    init_simple_test("aUi_BFu0s_BFu1c");
    static aUi_BFu0s_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu0s_BFu1c");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu1c(Test_aUi_BFu0s_BFu1c, "aUi_BFu0s_BFu1c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu1i()
{
  {
    init_simple_test("aUi_BFu0s_BFu1i");
    static aUi_BFu0s_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu0s_BFu1i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu1i(Test_aUi_BFu0s_BFu1i, "aUi_BFu0s_BFu1i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu1ll()
{
  {
    init_simple_test("aUi_BFu0s_BFu1ll");
    static aUi_BFu0s_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu0s_BFu1ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu1ll(Test_aUi_BFu0s_BFu1ll, "aUi_BFu0s_BFu1ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu1s()
{
  {
    init_simple_test("aUi_BFu0s_BFu1s");
    static aUi_BFu0s_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu0s_BFu1s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu1s(Test_aUi_BFu0s_BFu1s, "aUi_BFu0s_BFu1s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu31i()
{
  {
    init_simple_test("aUi_BFu0s_BFu31i");
    static aUi_BFu0s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu0s_BFu31i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu31i(Test_aUi_BFu0s_BFu31i, "aUi_BFu0s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu31ll()
{
  {
    init_simple_test("aUi_BFu0s_BFu31ll");
    static aUi_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu0s_BFu31ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu31ll(Test_aUi_BFu0s_BFu31ll, "aUi_BFu0s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu32i()
{
  {
    init_simple_test("aUi_BFu0s_BFu32i");
    static aUi_BFu0s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu0s_BFu32i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu32i(Test_aUi_BFu0s_BFu32i, "aUi_BFu0s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu32ll()
{
  {
    init_simple_test("aUi_BFu0s_BFu32ll");
    static aUi_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu0s_BFu32ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu32ll(Test_aUi_BFu0s_BFu32ll, "aUi_BFu0s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu33()
{
  {
    init_simple_test("aUi_BFu0s_BFu33");
    static aUi_BFu0s_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu0s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aUi_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aUi_BFu0s_BFu33");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu33(Test_aUi_BFu0s_BFu33, "aUi_BFu0s_BFu33", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu7c()
{
  {
    init_simple_test("aUi_BFu0s_BFu7c");
    static aUi_BFu0s_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu0s_BFu7c");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu7c(Test_aUi_BFu0s_BFu7c, "aUi_BFu0s_BFu7c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu7i()
{
  {
    init_simple_test("aUi_BFu0s_BFu7i");
    static aUi_BFu0s_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu0s_BFu7i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu7i(Test_aUi_BFu0s_BFu7i, "aUi_BFu0s_BFu7i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu7ll()
{
  {
    init_simple_test("aUi_BFu0s_BFu7ll");
    static aUi_BFu0s_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu0s_BFu7ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu7ll(Test_aUi_BFu0s_BFu7ll, "aUi_BFu0s_BFu7ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu7s()
{
  {
    init_simple_test("aUi_BFu0s_BFu7s");
    static aUi_BFu0s_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu0s_BFu7s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu7s(Test_aUi_BFu0s_BFu7s, "aUi_BFu0s_BFu7s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu8c()
{
  {
    init_simple_test("aUi_BFu0s_BFu8c");
    static aUi_BFu0s_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu0s_BFu8c");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu8c(Test_aUi_BFu0s_BFu8c, "aUi_BFu0s_BFu8c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu8i()
{
  {
    init_simple_test("aUi_BFu0s_BFu8i");
    static aUi_BFu0s_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu0s_BFu8i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu8i(Test_aUi_BFu0s_BFu8i, "aUi_BFu0s_BFu8i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu8ll()
{
  {
    init_simple_test("aUi_BFu0s_BFu8ll");
    static aUi_BFu0s_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu0s_BFu8ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu8ll(Test_aUi_BFu0s_BFu8ll, "aUi_BFu0s_BFu8ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu8s()
{
  {
    init_simple_test("aUi_BFu0s_BFu8s");
    static aUi_BFu0s_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu0s_BFu8s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu8s(Test_aUi_BFu0s_BFu8s, "aUi_BFu0s_BFu8s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu9i()
{
  {
    init_simple_test("aUi_BFu0s_BFu9i");
    static aUi_BFu0s_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu0s_BFu9i");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu9i(Test_aUi_BFu0s_BFu9i, "aUi_BFu0s_BFu9i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu9ll()
{
  {
    init_simple_test("aUi_BFu0s_BFu9ll");
    static aUi_BFu0s_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu0s_BFu9ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu9ll(Test_aUi_BFu0s_BFu9ll, "aUi_BFu0s_BFu9ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_BFu9s()
{
  {
    init_simple_test("aUi_BFu0s_BFu9s");
    static aUi_BFu0s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu0s_BFu9s");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_BFu9s(Test_aUi_BFu0s_BFu9s, "aUi_BFu0s_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_C()
{
  {
    init_simple_test("aUi_BFu0s_C");
    static aUi_BFu0s_C lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_C.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_C.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_C(Test_aUi_BFu0s_C, "aUi_BFu0s_C", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_D()
{
  {
    init_simple_test("aUi_BFu0s_D");
    static aUi_BFu0s_D lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu0s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_D.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_D.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_D(Test_aUi_BFu0s_D, "aUi_BFu0s_D", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_F()
{
  {
    init_simple_test("aUi_BFu0s_F");
    static aUi_BFu0s_F lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_F.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_F.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_F(Test_aUi_BFu0s_F, "aUi_BFu0s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_I()
{
  {
    init_simple_test("aUi_BFu0s_I");
    static aUi_BFu0s_I lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_I.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_I.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_I(Test_aUi_BFu0s_I, "aUi_BFu0s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_Ip()
{
  {
    init_simple_test("aUi_BFu0s_Ip");
    static aUi_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_BFu0s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_Ip.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_Ip.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_Ip(Test_aUi_BFu0s_Ip, "aUi_BFu0s_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_L()
{
  {
    init_simple_test("aUi_BFu0s_L");
    static aUi_BFu0s_L lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu0s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_L.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_L.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_L(Test_aUi_BFu0s_L, "aUi_BFu0s_L", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_S()
{
  {
    init_simple_test("aUi_BFu0s_S");
    static aUi_BFu0s_S lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_S.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_S.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_S(Test_aUi_BFu0s_S, "aUi_BFu0s_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_Uc()
{
  {
    init_simple_test("aUi_BFu0s_Uc");
    static aUi_BFu0s_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu0s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_Uc.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_Uc.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_Uc(Test_aUi_BFu0s_Uc, "aUi_BFu0s_Uc", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_Ui()
{
  {
    init_simple_test("aUi_BFu0s_Ui");
    static aUi_BFu0s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu0s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_Ui.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_Ui.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_Ui(Test_aUi_BFu0s_Ui, "aUi_BFu0s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_Ul()
{
  {
    init_simple_test("aUi_BFu0s_Ul");
    static aUi_BFu0s_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu0s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_Ul.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_Ul.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_Ul(Test_aUi_BFu0s_Ul, "aUi_BFu0s_Ul", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_Us()
{
  {
    init_simple_test("aUi_BFu0s_Us");
    static aUi_BFu0s_Us lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu0s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_Us.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_Us.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_Us(Test_aUi_BFu0s_Us, "aUi_BFu0s_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu0s_Vp()
{
  {
    init_simple_test("aUi_BFu0s_Vp");
    static aUi_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_BFu0s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_Vp.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_Vp.v2");
  }
}
static Arrange_To_Call_Me vaUi_BFu0s_Vp(Test_aUi_BFu0s_Vp, "aUi_BFu0s_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu15i_BFu0c()
{
  {
    init_simple_test("aUi_BFu15i_BFu0c");
    static aUi_BFu15i_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu15i_BFu0c(Test_aUi_BFu15i_BFu0c, "aUi_BFu15i_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu15i_BFu0i()
{
  {
    init_simple_test("aUi_BFu15i_BFu0i");
    static aUi_BFu15i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu15i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu15i_BFu0i(Test_aUi_BFu15i_BFu0i, "aUi_BFu15i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu15i_BFu0ll()
{
  {
    init_simple_test("aUi_BFu15i_BFu0ll");
    static aUi_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu15i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu15i_BFu0ll(Test_aUi_BFu15i_BFu0ll, "aUi_BFu15i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu15i_BFu0s()
{
  {
    init_simple_test("aUi_BFu15i_BFu0s");
    static aUi_BFu15i_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu15i_BFu0s(Test_aUi_BFu15i_BFu0s, "aUi_BFu15i_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu15ll_BFu0c()
{
  {
    init_simple_test("aUi_BFu15ll_BFu0c");
    static aUi_BFu15ll_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu15ll_BFu0c(Test_aUi_BFu15ll_BFu0c, "aUi_BFu15ll_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu15ll_BFu0i()
{
  {
    init_simple_test("aUi_BFu15ll_BFu0i");
    static aUi_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu15ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu15ll_BFu0i(Test_aUi_BFu15ll_BFu0i, "aUi_BFu15ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu15ll_BFu0ll()
{
  {
    init_simple_test("aUi_BFu15ll_BFu0ll");
    static aUi_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu15ll_BFu0ll(Test_aUi_BFu15ll_BFu0ll, "aUi_BFu15ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu15ll_BFu0s()
{
  {
    init_simple_test("aUi_BFu15ll_BFu0s");
    static aUi_BFu15ll_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu15ll_BFu0s(Test_aUi_BFu15ll_BFu0s, "aUi_BFu15ll_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu15s_BFu0c()
{
  {
    init_simple_test("aUi_BFu15s_BFu0c");
    static aUi_BFu15s_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu15s_BFu0c(Test_aUi_BFu15s_BFu0c, "aUi_BFu15s_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu15s_BFu0i()
{
  {
    init_simple_test("aUi_BFu15s_BFu0i");
    static aUi_BFu15s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu15s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu15s_BFu0i(Test_aUi_BFu15s_BFu0i, "aUi_BFu15s_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu15s_BFu0ll()
{
  {
    init_simple_test("aUi_BFu15s_BFu0ll");
    static aUi_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu15s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu15s_BFu0ll(Test_aUi_BFu15s_BFu0ll, "aUi_BFu15s_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu15s_BFu0s()
{
  {
    init_simple_test("aUi_BFu15s_BFu0s");
    static aUi_BFu15s_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu15s_BFu0s(Test_aUi_BFu15s_BFu0s, "aUi_BFu15s_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu16i_BFu0c()
{
  {
    init_simple_test("aUi_BFu16i_BFu0c");
    static aUi_BFu16i_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu16i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu16i_BFu0c(Test_aUi_BFu16i_BFu0c, "aUi_BFu16i_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu16i_BFu0i()
{
  {
    init_simple_test("aUi_BFu16i_BFu0i");
    static aUi_BFu16i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu16i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu16i_BFu0i(Test_aUi_BFu16i_BFu0i, "aUi_BFu16i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu16i_BFu0ll()
{
  {
    init_simple_test("aUi_BFu16i_BFu0ll");
    static aUi_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu16i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu16i_BFu0ll(Test_aUi_BFu16i_BFu0ll, "aUi_BFu16i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu16i_BFu0s()
{
  {
    init_simple_test("aUi_BFu16i_BFu0s");
    static aUi_BFu16i_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu16i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu16i_BFu0s(Test_aUi_BFu16i_BFu0s, "aUi_BFu16i_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu16ll_BFu0c()
{
  {
    init_simple_test("aUi_BFu16ll_BFu0c");
    static aUi_BFu16ll_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu16ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu16ll_BFu0c(Test_aUi_BFu16ll_BFu0c, "aUi_BFu16ll_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu16ll_BFu0i()
{
  {
    init_simple_test("aUi_BFu16ll_BFu0i");
    static aUi_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu16ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu16ll_BFu0i(Test_aUi_BFu16ll_BFu0i, "aUi_BFu16ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu16ll_BFu0ll()
{
  {
    init_simple_test("aUi_BFu16ll_BFu0ll");
    static aUi_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu16ll_BFu0ll(Test_aUi_BFu16ll_BFu0ll, "aUi_BFu16ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu16ll_BFu0s()
{
  {
    init_simple_test("aUi_BFu16ll_BFu0s");
    static aUi_BFu16ll_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu16ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu16ll_BFu0s(Test_aUi_BFu16ll_BFu0s, "aUi_BFu16ll_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu16s_BFu0c()
{
  {
    init_simple_test("aUi_BFu16s_BFu0c");
    static aUi_BFu16s_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu16s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu16s_BFu0c(Test_aUi_BFu16s_BFu0c, "aUi_BFu16s_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu16s_BFu0i()
{
  {
    init_simple_test("aUi_BFu16s_BFu0i");
    static aUi_BFu16s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu16s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu16s_BFu0i(Test_aUi_BFu16s_BFu0i, "aUi_BFu16s_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu16s_BFu0ll()
{
  {
    init_simple_test("aUi_BFu16s_BFu0ll");
    static aUi_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu16s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu16s_BFu0ll(Test_aUi_BFu16s_BFu0ll, "aUi_BFu16s_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu16s_BFu0s()
{
  {
    init_simple_test("aUi_BFu16s_BFu0s");
    static aUi_BFu16s_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu16s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu16s_BFu0s(Test_aUi_BFu16s_BFu0s, "aUi_BFu16s_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu17i_BFu0c()
{
  {
    init_simple_test("aUi_BFu17i_BFu0c");
    static aUi_BFu17i_BFu0c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu17i_BFu0c(Test_aUi_BFu17i_BFu0c, "aUi_BFu17i_BFu0c", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu17i_BFu0i()
{
  {
    init_simple_test("aUi_BFu17i_BFu0i");
    static aUi_BFu17i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu17i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu17i_BFu0i(Test_aUi_BFu17i_BFu0i, "aUi_BFu17i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu17i_BFu0ll()
{
  {
    init_simple_test("aUi_BFu17i_BFu0ll");
    static aUi_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu17i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu17i_BFu0ll(Test_aUi_BFu17i_BFu0ll, "aUi_BFu17i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu17i_BFu0s()
{
  {
    init_simple_test("aUi_BFu17i_BFu0s");
    static aUi_BFu17i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu17i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu17i_BFu0s(Test_aUi_BFu17i_BFu0s, "aUi_BFu17i_BFu0s", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu17ll_BFu0c()
{
  {
    init_simple_test("aUi_BFu17ll_BFu0c");
    static aUi_BFu17ll_BFu0c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu17ll_BFu0c(Test_aUi_BFu17ll_BFu0c, "aUi_BFu17ll_BFu0c", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu17ll_BFu0i()
{
  {
    init_simple_test("aUi_BFu17ll_BFu0i");
    static aUi_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu17ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu17ll_BFu0i(Test_aUi_BFu17ll_BFu0i, "aUi_BFu17ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu17ll_BFu0ll()
{
  {
    init_simple_test("aUi_BFu17ll_BFu0ll");
    static aUi_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu17ll_BFu0ll(Test_aUi_BFu17ll_BFu0ll, "aUi_BFu17ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu17ll_BFu0s()
{
  {
    init_simple_test("aUi_BFu17ll_BFu0s");
    static aUi_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu17ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu17ll_BFu0s(Test_aUi_BFu17ll_BFu0s, "aUi_BFu17ll_BFu0s", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1c_BFu0c()
{
  {
    init_simple_test("aUi_BFu1c_BFu0c");
    static aUi_BFu1c_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu1c_BFu0c(Test_aUi_BFu1c_BFu0c, "aUi_BFu1c_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1c_BFu0i()
{
  {
    init_simple_test("aUi_BFu1c_BFu0i");
    static aUi_BFu1c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu1c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu1c_BFu0i(Test_aUi_BFu1c_BFu0i, "aUi_BFu1c_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1c_BFu0ll()
{
  {
    init_simple_test("aUi_BFu1c_BFu0ll");
    static aUi_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu1c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu1c_BFu0ll(Test_aUi_BFu1c_BFu0ll, "aUi_BFu1c_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1c_BFu0s()
{
  {
    init_simple_test("aUi_BFu1c_BFu0s");
    static aUi_BFu1c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_BFu1c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu1c_BFu0s(Test_aUi_BFu1c_BFu0s, "aUi_BFu1c_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1i_BFu0c()
{
  {
    init_simple_test("aUi_BFu1i_BFu0c");
    static aUi_BFu1i_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu1i_BFu0c(Test_aUi_BFu1i_BFu0c, "aUi_BFu1i_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1i_BFu0i()
{
  {
    init_simple_test("aUi_BFu1i_BFu0i");
    static aUi_BFu1i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu1i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu1i_BFu0i(Test_aUi_BFu1i_BFu0i, "aUi_BFu1i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1i_BFu0ll()
{
  {
    init_simple_test("aUi_BFu1i_BFu0ll");
    static aUi_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu1i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu1i_BFu0ll(Test_aUi_BFu1i_BFu0ll, "aUi_BFu1i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1i_BFu0s()
{
  {
    init_simple_test("aUi_BFu1i_BFu0s");
    static aUi_BFu1i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_BFu1i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu1i_BFu0s(Test_aUi_BFu1i_BFu0s, "aUi_BFu1i_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1ll_BFu0c()
{
  {
    init_simple_test("aUi_BFu1ll_BFu0c");
    static aUi_BFu1ll_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu1ll_BFu0c(Test_aUi_BFu1ll_BFu0c, "aUi_BFu1ll_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1ll_BFu0i()
{
  {
    init_simple_test("aUi_BFu1ll_BFu0i");
    static aUi_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu1ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu1ll_BFu0i(Test_aUi_BFu1ll_BFu0i, "aUi_BFu1ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1ll_BFu0ll()
{
  {
    init_simple_test("aUi_BFu1ll_BFu0ll");
    static aUi_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu1ll_BFu0ll(Test_aUi_BFu1ll_BFu0ll, "aUi_BFu1ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1ll_BFu0s()
{
  {
    init_simple_test("aUi_BFu1ll_BFu0s");
    static aUi_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_BFu1ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu1ll_BFu0s(Test_aUi_BFu1ll_BFu0s, "aUi_BFu1ll_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1s_BFu0c()
{
  {
    init_simple_test("aUi_BFu1s_BFu0c");
    static aUi_BFu1s_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu1s_BFu0c(Test_aUi_BFu1s_BFu0c, "aUi_BFu1s_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1s_BFu0i()
{
  {
    init_simple_test("aUi_BFu1s_BFu0i");
    static aUi_BFu1s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu1s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu1s_BFu0i(Test_aUi_BFu1s_BFu0i, "aUi_BFu1s_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1s_BFu0ll()
{
  {
    init_simple_test("aUi_BFu1s_BFu0ll");
    static aUi_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu1s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu1s_BFu0ll(Test_aUi_BFu1s_BFu0ll, "aUi_BFu1s_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu1s_BFu0s()
{
  {
    init_simple_test("aUi_BFu1s_BFu0s");
    static aUi_BFu1s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_BFu1s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu1s_BFu0s(Test_aUi_BFu1s_BFu0s, "aUi_BFu1s_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu31i_BFu0c()
{
  {
    init_simple_test("aUi_BFu31i_BFu0c");
    static aUi_BFu31i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu31i_BFu0c(Test_aUi_BFu31i_BFu0c, "aUi_BFu31i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu31i_BFu0i()
{
  {
    init_simple_test("aUi_BFu31i_BFu0i");
    static aUi_BFu31i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu31i_BFu0i(Test_aUi_BFu31i_BFu0i, "aUi_BFu31i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu31i_BFu0ll()
{
  {
    init_simple_test("aUi_BFu31i_BFu0ll");
    static aUi_BFu31i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu31i_BFu0ll(Test_aUi_BFu31i_BFu0ll, "aUi_BFu31i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu31i_BFu0s()
{
  {
    init_simple_test("aUi_BFu31i_BFu0s");
    static aUi_BFu31i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu31i_BFu0s(Test_aUi_BFu31i_BFu0s, "aUi_BFu31i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu31ll_BFu0c()
{
  {
    init_simple_test("aUi_BFu31ll_BFu0c");
    static aUi_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu31ll_BFu0c(Test_aUi_BFu31ll_BFu0c, "aUi_BFu31ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu31ll_BFu0i()
{
  {
    init_simple_test("aUi_BFu31ll_BFu0i");
    static aUi_BFu31ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu31ll_BFu0i(Test_aUi_BFu31ll_BFu0i, "aUi_BFu31ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu31ll_BFu0ll()
{
  {
    init_simple_test("aUi_BFu31ll_BFu0ll");
    static aUi_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu31ll_BFu0ll(Test_aUi_BFu31ll_BFu0ll, "aUi_BFu31ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu31ll_BFu0s()
{
  {
    init_simple_test("aUi_BFu31ll_BFu0s");
    static aUi_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu31ll_BFu0s(Test_aUi_BFu31ll_BFu0s, "aUi_BFu31ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu32i_BFu0c()
{
  {
    init_simple_test("aUi_BFu32i_BFu0c");
    static aUi_BFu32i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu32i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu32i_BFu0c(Test_aUi_BFu32i_BFu0c, "aUi_BFu32i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu32i_BFu0i()
{
  {
    init_simple_test("aUi_BFu32i_BFu0i");
    static aUi_BFu32i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu32i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu32i_BFu0i(Test_aUi_BFu32i_BFu0i, "aUi_BFu32i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu32i_BFu0ll()
{
  {
    init_simple_test("aUi_BFu32i_BFu0ll");
    static aUi_BFu32i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu32i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu32i_BFu0ll(Test_aUi_BFu32i_BFu0ll, "aUi_BFu32i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu32i_BFu0s()
{
  {
    init_simple_test("aUi_BFu32i_BFu0s");
    static aUi_BFu32i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu32i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu32i_BFu0s(Test_aUi_BFu32i_BFu0s, "aUi_BFu32i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu32ll_BFu0c()
{
  {
    init_simple_test("aUi_BFu32ll_BFu0c");
    static aUi_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu32ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu32ll_BFu0c(Test_aUi_BFu32ll_BFu0c, "aUi_BFu32ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu32ll_BFu0i()
{
  {
    init_simple_test("aUi_BFu32ll_BFu0i");
    static aUi_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu32ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu32ll_BFu0i(Test_aUi_BFu32ll_BFu0i, "aUi_BFu32ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu32ll_BFu0ll()
{
  {
    init_simple_test("aUi_BFu32ll_BFu0ll");
    static aUi_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu32ll_BFu0ll(Test_aUi_BFu32ll_BFu0ll, "aUi_BFu32ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu32ll_BFu0s()
{
  {
    init_simple_test("aUi_BFu32ll_BFu0s");
    static aUi_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu32ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu32ll_BFu0s(Test_aUi_BFu32ll_BFu0s, "aUi_BFu32ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu33_BFu0c()
{
  {
    init_simple_test("aUi_BFu33_BFu0c");
    static aUi_BFu33_BFu0c lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu33_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu33_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu33_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aUi_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aUi_BFu33_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu33_BFu0c(Test_aUi_BFu33_BFu0c, "aUi_BFu33_BFu0c", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu33_BFu0i()
{
  {
    init_simple_test("aUi_BFu33_BFu0i");
    static aUi_BFu33_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aUi_BFu33_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu33_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu33_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aUi_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aUi_BFu33_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu33_BFu0i(Test_aUi_BFu33_BFu0i, "aUi_BFu33_BFu0i", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu33_BFu0ll()
{
  {
    init_simple_test("aUi_BFu33_BFu0ll");
    static aUi_BFu33_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUi_BFu33_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu33_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu33_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aUi_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aUi_BFu33_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu33_BFu0ll(Test_aUi_BFu33_BFu0ll, "aUi_BFu33_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu33_BFu0s()
{
  {
    init_simple_test("aUi_BFu33_BFu0s");
    static aUi_BFu33_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(aUi_BFu33_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu33_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu33_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aUi_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aUi_BFu33_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu33_BFu0s(Test_aUi_BFu33_BFu0s, "aUi_BFu33_BFu0s", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7c_BFu0c()
{
  {
    init_simple_test("aUi_BFu7c_BFu0c");
    static aUi_BFu7c_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu7c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7c_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu7c_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7c_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu7c_BFu0c(Test_aUi_BFu7c_BFu0c, "aUi_BFu7c_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7c_BFu0i()
{
  {
    init_simple_test("aUi_BFu7c_BFu0i");
    static aUi_BFu7c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu7c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7c_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu7c_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7c_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu7c_BFu0i(Test_aUi_BFu7c_BFu0i, "aUi_BFu7c_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7c_BFu0ll()
{
  {
    init_simple_test("aUi_BFu7c_BFu0ll");
    static aUi_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu7c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu7c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7c_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu7c_BFu0ll(Test_aUi_BFu7c_BFu0ll, "aUi_BFu7c_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7c_BFu0s()
{
  {
    init_simple_test("aUi_BFu7c_BFu0s");
    static aUi_BFu7c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_BFu7c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7c_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu7c_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7c_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu7c_BFu0s(Test_aUi_BFu7c_BFu0s, "aUi_BFu7c_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7i_BFu0c()
{
  {
    init_simple_test("aUi_BFu7i_BFu0c");
    static aUi_BFu7i_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu7i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu7i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu7i_BFu0c(Test_aUi_BFu7i_BFu0c, "aUi_BFu7i_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7i_BFu0i()
{
  {
    init_simple_test("aUi_BFu7i_BFu0i");
    static aUi_BFu7i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu7i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu7i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu7i_BFu0i(Test_aUi_BFu7i_BFu0i, "aUi_BFu7i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7i_BFu0ll()
{
  {
    init_simple_test("aUi_BFu7i_BFu0ll");
    static aUi_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu7i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu7i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu7i_BFu0ll(Test_aUi_BFu7i_BFu0ll, "aUi_BFu7i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7i_BFu0s()
{
  {
    init_simple_test("aUi_BFu7i_BFu0s");
    static aUi_BFu7i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_BFu7i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu7i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu7i_BFu0s(Test_aUi_BFu7i_BFu0s, "aUi_BFu7i_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7ll_BFu0c()
{
  {
    init_simple_test("aUi_BFu7ll_BFu0c");
    static aUi_BFu7ll_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu7ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu7ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu7ll_BFu0c(Test_aUi_BFu7ll_BFu0c, "aUi_BFu7ll_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7ll_BFu0i()
{
  {
    init_simple_test("aUi_BFu7ll_BFu0i");
    static aUi_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu7ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu7ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu7ll_BFu0i(Test_aUi_BFu7ll_BFu0i, "aUi_BFu7ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7ll_BFu0ll()
{
  {
    init_simple_test("aUi_BFu7ll_BFu0ll");
    static aUi_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu7ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu7ll_BFu0ll(Test_aUi_BFu7ll_BFu0ll, "aUi_BFu7ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7ll_BFu0s()
{
  {
    init_simple_test("aUi_BFu7ll_BFu0s");
    static aUi_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_BFu7ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu7ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu7ll_BFu0s(Test_aUi_BFu7ll_BFu0s, "aUi_BFu7ll_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7s_BFu0c()
{
  {
    init_simple_test("aUi_BFu7s_BFu0c");
    static aUi_BFu7s_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu7s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu7s_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7s_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu7s_BFu0c(Test_aUi_BFu7s_BFu0c, "aUi_BFu7s_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7s_BFu0i()
{
  {
    init_simple_test("aUi_BFu7s_BFu0i");
    static aUi_BFu7s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu7s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu7s_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7s_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu7s_BFu0i(Test_aUi_BFu7s_BFu0i, "aUi_BFu7s_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7s_BFu0ll()
{
  {
    init_simple_test("aUi_BFu7s_BFu0ll");
    static aUi_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu7s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu7s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu7s_BFu0ll(Test_aUi_BFu7s_BFu0ll, "aUi_BFu7s_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu7s_BFu0s()
{
  {
    init_simple_test("aUi_BFu7s_BFu0s");
    static aUi_BFu7s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_BFu7s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu7s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu7s_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aUi_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aUi_BFu7s_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu7s_BFu0s(Test_aUi_BFu7s_BFu0s, "aUi_BFu7s_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8c_BFu0c()
{
  {
    init_simple_test("aUi_BFu8c_BFu0c");
    static aUi_BFu8c_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu8c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8c_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu8c_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8c_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu8c_BFu0c(Test_aUi_BFu8c_BFu0c, "aUi_BFu8c_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8c_BFu0i()
{
  {
    init_simple_test("aUi_BFu8c_BFu0i");
    static aUi_BFu8c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu8c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8c_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu8c_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8c_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu8c_BFu0i(Test_aUi_BFu8c_BFu0i, "aUi_BFu8c_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8c_BFu0ll()
{
  {
    init_simple_test("aUi_BFu8c_BFu0ll");
    static aUi_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu8c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu8c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8c_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu8c_BFu0ll(Test_aUi_BFu8c_BFu0ll, "aUi_BFu8c_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8c_BFu0s()
{
  {
    init_simple_test("aUi_BFu8c_BFu0s");
    static aUi_BFu8c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_BFu8c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8c_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu8c_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8c_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu8c_BFu0s(Test_aUi_BFu8c_BFu0s, "aUi_BFu8c_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8i_BFu0c()
{
  {
    init_simple_test("aUi_BFu8i_BFu0c");
    static aUi_BFu8i_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu8i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu8i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu8i_BFu0c(Test_aUi_BFu8i_BFu0c, "aUi_BFu8i_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8i_BFu0i()
{
  {
    init_simple_test("aUi_BFu8i_BFu0i");
    static aUi_BFu8i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu8i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu8i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu8i_BFu0i(Test_aUi_BFu8i_BFu0i, "aUi_BFu8i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8i_BFu0ll()
{
  {
    init_simple_test("aUi_BFu8i_BFu0ll");
    static aUi_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu8i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu8i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu8i_BFu0ll(Test_aUi_BFu8i_BFu0ll, "aUi_BFu8i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8i_BFu0s()
{
  {
    init_simple_test("aUi_BFu8i_BFu0s");
    static aUi_BFu8i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_BFu8i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu8i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu8i_BFu0s(Test_aUi_BFu8i_BFu0s, "aUi_BFu8i_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8ll_BFu0c()
{
  {
    init_simple_test("aUi_BFu8ll_BFu0c");
    static aUi_BFu8ll_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu8ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu8ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu8ll_BFu0c(Test_aUi_BFu8ll_BFu0c, "aUi_BFu8ll_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8ll_BFu0i()
{
  {
    init_simple_test("aUi_BFu8ll_BFu0i");
    static aUi_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu8ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu8ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu8ll_BFu0i(Test_aUi_BFu8ll_BFu0i, "aUi_BFu8ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8ll_BFu0ll()
{
  {
    init_simple_test("aUi_BFu8ll_BFu0ll");
    static aUi_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu8ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu8ll_BFu0ll(Test_aUi_BFu8ll_BFu0ll, "aUi_BFu8ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8ll_BFu0s()
{
  {
    init_simple_test("aUi_BFu8ll_BFu0s");
    static aUi_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_BFu8ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu8ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu8ll_BFu0s(Test_aUi_BFu8ll_BFu0s, "aUi_BFu8ll_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8s_BFu0c()
{
  {
    init_simple_test("aUi_BFu8s_BFu0c");
    static aUi_BFu8s_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu8s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu8s_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8s_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu8s_BFu0c(Test_aUi_BFu8s_BFu0c, "aUi_BFu8s_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8s_BFu0i()
{
  {
    init_simple_test("aUi_BFu8s_BFu0i");
    static aUi_BFu8s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu8s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu8s_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8s_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu8s_BFu0i(Test_aUi_BFu8s_BFu0i, "aUi_BFu8s_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8s_BFu0ll()
{
  {
    init_simple_test("aUi_BFu8s_BFu0ll");
    static aUi_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu8s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu8s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu8s_BFu0ll(Test_aUi_BFu8s_BFu0ll, "aUi_BFu8s_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu8s_BFu0s()
{
  {
    init_simple_test("aUi_BFu8s_BFu0s");
    static aUi_BFu8s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_BFu8s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu8s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu8s_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aUi_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aUi_BFu8s_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu8s_BFu0s(Test_aUi_BFu8s_BFu0s, "aUi_BFu8s_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu9i_BFu0c()
{
  {
    init_simple_test("aUi_BFu9i_BFu0c");
    static aUi_BFu9i_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu9i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu9i_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu9i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu9i_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu9i_BFu0c(Test_aUi_BFu9i_BFu0c, "aUi_BFu9i_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu9i_BFu0i()
{
  {
    init_simple_test("aUi_BFu9i_BFu0i");
    static aUi_BFu9i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu9i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu9i_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu9i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu9i_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu9i_BFu0i(Test_aUi_BFu9i_BFu0i, "aUi_BFu9i_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu9i_BFu0ll()
{
  {
    init_simple_test("aUi_BFu9i_BFu0ll");
    static aUi_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu9i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu9i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu9i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu9i_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu9i_BFu0ll(Test_aUi_BFu9i_BFu0ll, "aUi_BFu9i_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu9i_BFu0s()
{
  {
    init_simple_test("aUi_BFu9i_BFu0s");
    static aUi_BFu9i_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu9i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu9i_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu9i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu9i_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu9i_BFu0s(Test_aUi_BFu9i_BFu0s, "aUi_BFu9i_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu9ll_BFu0c()
{
  {
    init_simple_test("aUi_BFu9ll_BFu0c");
    static aUi_BFu9ll_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu9ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu9ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu9ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu9ll_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu9ll_BFu0c(Test_aUi_BFu9ll_BFu0c, "aUi_BFu9ll_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu9ll_BFu0i()
{
  {
    init_simple_test("aUi_BFu9ll_BFu0i");
    static aUi_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu9ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu9ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu9ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu9ll_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu9ll_BFu0i(Test_aUi_BFu9ll_BFu0i, "aUi_BFu9ll_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu9ll_BFu0ll()
{
  {
    init_simple_test("aUi_BFu9ll_BFu0ll");
    static aUi_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu9ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu9ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu9ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu9ll_BFu0ll(Test_aUi_BFu9ll_BFu0ll, "aUi_BFu9ll_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu9ll_BFu0s()
{
  {
    init_simple_test("aUi_BFu9ll_BFu0s");
    static aUi_BFu9ll_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu9ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu9ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu9ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu9ll_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu9ll_BFu0s(Test_aUi_BFu9ll_BFu0s, "aUi_BFu9ll_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu9s_BFu0c()
{
  {
    init_simple_test("aUi_BFu9s_BFu0c");
    static aUi_BFu9s_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu9s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu9s_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_BFu9s_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu9s_BFu0c");
  }
}
static Arrange_To_Call_Me vaUi_BFu9s_BFu0c(Test_aUi_BFu9s_BFu0c, "aUi_BFu9s_BFu0c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu9s_BFu0i()
{
  {
    init_simple_test("aUi_BFu9s_BFu0i");
    static aUi_BFu9s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu9s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu9s_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_BFu9s_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu9s_BFu0i");
  }
}
static Arrange_To_Call_Me vaUi_BFu9s_BFu0i(Test_aUi_BFu9s_BFu0i, "aUi_BFu9s_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu9s_BFu0ll()
{
  {
    init_simple_test("aUi_BFu9s_BFu0ll");
    static aUi_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_BFu9s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu9s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu9s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu9s_BFu0ll");
  }
}
static Arrange_To_Call_Me vaUi_BFu9s_BFu0ll(Test_aUi_BFu9s_BFu0ll, "aUi_BFu9s_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_BFu9s_BFu0s()
{
  {
    init_simple_test("aUi_BFu9s_BFu0s");
    static aUi_BFu9s_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu9s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu9s_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_BFu9s_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aUi_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aUi_BFu9s_BFu0s");
  }
}
static Arrange_To_Call_Me vaUi_BFu9s_BFu0s(Test_aUi_BFu9s_BFu0s, "aUi_BFu9s_BFu0s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_C_BFu0c()
{
  {
    init_simple_test("aUi_C_BFu0c");
    static aUi_C_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_C_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_C_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_C_BFu0c.v1");
    check_field_offset(lv, v2, 4, "aUi_C_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUi_C_BFu0c(Test_aUi_C_BFu0c, "aUi_C_BFu0c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_C_BFu0i()
{
  {
    init_simple_test("aUi_C_BFu0i");
    static aUi_C_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_C_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_C_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_C_BFu0i.v1");
    check_field_offset(lv, v2, 4, "aUi_C_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUi_C_BFu0i(Test_aUi_C_BFu0i, "aUi_C_BFu0i", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_C_BFu0ll()
{
  {
    init_simple_test("aUi_C_BFu0ll");
    static aUi_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aUi_C_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_C_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_C_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "aUi_C_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUi_C_BFu0ll(Test_aUi_C_BFu0ll, "aUi_C_BFu0ll", ABISELECT(8,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_C_BFu0s()
{
  {
    init_simple_test("aUi_C_BFu0s");
    static aUi_C_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aUi_C_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_C_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_C_BFu0s.v1");
    check_field_offset(lv, v2, 4, "aUi_C_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUi_C_BFu0s(Test_aUi_C_BFu0s, "aUi_C_BFu0s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_D_BFu0c()
{
  {
    init_simple_test("aUi_D_BFu0c");
    static aUi_D_BFu0c lv;
    check2(sizeof(lv), 12, "sizeof(aUi_D_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_D_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_D_BFu0c.v1");
    check_field_offset(lv, v2, 4, "aUi_D_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUi_D_BFu0c(Test_aUi_D_BFu0c, "aUi_D_BFu0c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_D_BFu0i()
{
  {
    init_simple_test("aUi_D_BFu0i");
    static aUi_D_BFu0i lv;
    check2(sizeof(lv), 12, "sizeof(aUi_D_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_D_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_D_BFu0i.v1");
    check_field_offset(lv, v2, 4, "aUi_D_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUi_D_BFu0i(Test_aUi_D_BFu0i, "aUi_D_BFu0i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_D_BFu0ll()
{
  {
    init_simple_test("aUi_D_BFu0ll");
    static aUi_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUi_D_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_D_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "aUi_D_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUi_D_BFu0ll(Test_aUi_D_BFu0ll, "aUi_D_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_D_BFu0s()
{
  {
    init_simple_test("aUi_D_BFu0s");
    static aUi_D_BFu0s lv;
    check2(sizeof(lv), 12, "sizeof(aUi_D_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_D_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_D_BFu0s.v1");
    check_field_offset(lv, v2, 4, "aUi_D_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUi_D_BFu0s(Test_aUi_D_BFu0s, "aUi_D_BFu0s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_F_BFu0c()
{
  {
    init_simple_test("aUi_F_BFu0c");
    static aUi_F_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aUi_F_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_F_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_F_BFu0c.v1");
    check_field_offset(lv, v2, 4, "aUi_F_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUi_F_BFu0c(Test_aUi_F_BFu0c, "aUi_F_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_F_BFu0i()
{
  {
    init_simple_test("aUi_F_BFu0i");
    static aUi_F_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_F_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_F_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_F_BFu0i.v1");
    check_field_offset(lv, v2, 4, "aUi_F_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUi_F_BFu0i(Test_aUi_F_BFu0i, "aUi_F_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_F_BFu0ll()
{
  {
    init_simple_test("aUi_F_BFu0ll");
    static aUi_F_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_F_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_F_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "aUi_F_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUi_F_BFu0ll(Test_aUi_F_BFu0ll, "aUi_F_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_F_BFu0s()
{
  {
    init_simple_test("aUi_F_BFu0s");
    static aUi_F_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_F_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_F_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_F_BFu0s.v1");
    check_field_offset(lv, v2, 4, "aUi_F_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUi_F_BFu0s(Test_aUi_F_BFu0s, "aUi_F_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_I_BFu0c()
{
  {
    init_simple_test("aUi_I_BFu0c");
    static aUi_I_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aUi_I_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_I_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_I_BFu0c.v1");
    check_field_offset(lv, v2, 4, "aUi_I_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUi_I_BFu0c(Test_aUi_I_BFu0c, "aUi_I_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_I_BFu0i()
{
  {
    init_simple_test("aUi_I_BFu0i");
    static aUi_I_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_I_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_I_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_I_BFu0i.v1");
    check_field_offset(lv, v2, 4, "aUi_I_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUi_I_BFu0i(Test_aUi_I_BFu0i, "aUi_I_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_I_BFu0ll()
{
  {
    init_simple_test("aUi_I_BFu0ll");
    static aUi_I_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_I_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_I_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "aUi_I_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vaUi_I_BFu0ll(Test_aUi_I_BFu0ll, "aUi_I_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_I_BFu0s()
{
  {
    init_simple_test("aUi_I_BFu0s");
    static aUi_I_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_I_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_I_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_I_BFu0s.v1");
    check_field_offset(lv, v2, 4, "aUi_I_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vaUi_I_BFu0s(Test_aUi_I_BFu0s, "aUi_I_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_Ip_BFu0c()
{
  {
    init_simple_test("aUi_Ip_BFu0c");
    static aUi_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_Ip_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_Ip_BFu0c.v1");
    check_field_offset(lv, v2, 4, "aUi_Ip_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vaUi_Ip_BFu0c(Test_aUi_Ip_BFu0c, "aUi_Ip_BFu0c", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_Ip_BFu0i()
{
  {
    init_simple_test("aUi_Ip_BFu0i");
    static aUi_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUi_Ip_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_Ip_BFu0i.v1");
    check_field_offset(lv, v2, 4, "aUi_Ip_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vaUi_Ip_BFu0i(Test_aUi_Ip_BFu0i, "aUi_Ip_BFu0i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aUi_Ip_BFu0ll()
{
  {
    init_simple_test("aUi_Ip_BFu0ll");
    static aUi_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aUi_Ip_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_Ip_BFu0ll)");
    chec