// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
typedef struct empty {} empty;
struct __attribute__((packed)) aSf_BFu16i_BFu15s { empty v1; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu16i_BFu16i { empty v1; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu16i_BFu16ll { empty v1; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu16i_BFu16s { empty v1; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu16i_BFu17i { empty v1; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu16i_BFu17ll { empty v1; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu16i_BFu1c { empty v1; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu16i_BFu1i { empty v1; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu16i_BFu1ll { empty v1; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu16i_BFu1s { empty v1; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu16i_BFu31i { empty v1; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu16i_BFu31ll { empty v1; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu16i_BFu32i { empty v1; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu16i_BFu32ll { empty v1; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu16i_BFu33 { empty v1; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu16i_BFu7c { empty v1; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu16i_BFu7i { empty v1; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu16i_BFu7ll { empty v1; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu16i_BFu7s { empty v1; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu16i_BFu8c { empty v1; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu16i_BFu8i { empty v1; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu16i_BFu8ll { empty v1; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu16i_BFu8s { empty v1; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu16i_BFu9i { empty v1; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu16i_BFu9ll { empty v1; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu16i_BFu9s { empty v1; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu16i_C { empty v1; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aSf_BFu16i_D { empty v1; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aSf_BFu16i_F { empty v1; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aSf_BFu16i_I { empty v1; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aSf_BFu16i_Ip { empty v1; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aSf_BFu16i_L { empty v1; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aSf_BFu16i_S { empty v1; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aSf_BFu16i_Sf { empty v1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aSf_BFu16i_Uc { empty v1; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu16i_Ui { empty v1; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu16i_Ul { empty v1; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu16i_Us { empty v1; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu16i_Vp { empty v1; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aSf_BFu16ll { empty v1; unsigned long long v2:16; };
struct __attribute__((packed)) aSf_BFu16ll_BFu15i { empty v1; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu16ll_BFu15ll { empty v1; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu16ll_BFu15s { empty v1; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu16ll_BFu16i { empty v1; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu16ll_BFu16ll { empty v1; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu16ll_BFu16s { empty v1; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu16ll_BFu17i { empty v1; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu16ll_BFu17ll { empty v1; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu16ll_BFu1c { empty v1; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu16ll_BFu1i { empty v1; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu16ll_BFu1ll { empty v1; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu16ll_BFu1s { empty v1; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu16ll_BFu31i { empty v1; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu16ll_BFu31ll { empty v1; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu16ll_BFu32i { empty v1; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu16ll_BFu32ll { empty v1; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu16ll_BFu33 { empty v1; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu16ll_BFu7c { empty v1; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu16ll_BFu7i { empty v1; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu16ll_BFu7ll { empty v1; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu16ll_BFu7s { empty v1; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu16ll_BFu8c { empty v1; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu16ll_BFu8i { empty v1; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu16ll_BFu8ll { empty v1; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu16ll_BFu8s { empty v1; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu16ll_BFu9i { empty v1; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu16ll_BFu9ll { empty v1; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu16ll_BFu9s { empty v1; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu16ll_C { empty v1; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aSf_BFu16ll_D { empty v1; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aSf_BFu16ll_F { empty v1; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aSf_BFu16ll_I { empty v1; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aSf_BFu16ll_Ip { empty v1; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aSf_BFu16ll_L { empty v1; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aSf_BFu16ll_S { empty v1; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aSf_BFu16ll_Sf { empty v1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aSf_BFu16ll_Uc { empty v1; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu16ll_Ui { empty v1; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu16ll_Ul { empty v1; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu16ll_Us { empty v1; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu16ll_Vp { empty v1; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aSf_BFu16s { empty v1; unsigned short v2:16; };
struct __attribute__((packed)) aSf_BFu16s_BFu15i { empty v1; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu16s_BFu15ll { empty v1; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu16s_BFu15s { empty v1; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu16s_BFu16i { empty v1; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu16s_BFu16ll { empty v1; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu16s_BFu16s { empty v1; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu16s_BFu17i { empty v1; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu16s_BFu17ll { empty v1; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu16s_BFu1c { empty v1; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu16s_BFu1i { empty v1; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu16s_BFu1ll { empty v1; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu16s_BFu1s { empty v1; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu16s_BFu31i { empty v1; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu16s_BFu31ll { empty v1; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu16s_BFu32i { empty v1; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu16s_BFu32ll { empty v1; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu16s_BFu33 { empty v1; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu16s_BFu7c { empty v1; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu16s_BFu7i { empty v1; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu16s_BFu7ll { empty v1; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu16s_BFu7s { empty v1; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu16s_BFu8c { empty v1; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu16s_BFu8i { empty v1; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu16s_BFu8ll { empty v1; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu16s_BFu8s { empty v1; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu16s_BFu9i { empty v1; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu16s_BFu9ll { empty v1; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu16s_BFu9s { empty v1; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu16s_C { empty v1; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aSf_BFu16s_D { empty v1; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aSf_BFu16s_F { empty v1; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aSf_BFu16s_I { empty v1; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aSf_BFu16s_Ip { empty v1; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aSf_BFu16s_L { empty v1; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aSf_BFu16s_S { empty v1; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aSf_BFu16s_Sf { empty v1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aSf_BFu16s_Uc { empty v1; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu16s_Ui { empty v1; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu16s_Ul { empty v1; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu16s_Us { empty v1; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu16s_Vp { empty v1; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aSf_BFu17i { empty v1; unsigned int v2:17; };
struct __attribute__((packed)) aSf_BFu17i_BFu15i { empty v1; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu17i_BFu15ll { empty v1; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu17i_BFu15s { empty v1; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu17i_BFu16i { empty v1; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu17i_BFu16ll { empty v1; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu17i_BFu16s { empty v1; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu17i_BFu17i { empty v1; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu17i_BFu17ll { empty v1; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu17i_BFu1c { empty v1; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu17i_BFu1i { empty v1; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu17i_BFu1ll { empty v1; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu17i_BFu1s { empty v1; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu17i_BFu31i { empty v1; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu17i_BFu31ll { empty v1; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu17i_BFu32i { empty v1; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu17i_BFu32ll { empty v1; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu17i_BFu33 { empty v1; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu17i_BFu7c { empty v1; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu17i_BFu7i { empty v1; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu17i_BFu7ll { empty v1; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu17i_BFu7s { empty v1; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu17i_BFu8c { empty v1; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu17i_BFu8i { empty v1; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu17i_BFu8ll { empty v1; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu17i_BFu8s { empty v1; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu17i_BFu9i { empty v1; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu17i_BFu9ll { empty v1; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu17i_BFu9s { empty v1; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu17i_C { empty v1; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aSf_BFu17i_D { empty v1; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aSf_BFu17i_F { empty v1; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aSf_BFu17i_I { empty v1; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aSf_BFu17i_Ip { empty v1; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aSf_BFu17i_L { empty v1; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aSf_BFu17i_S { empty v1; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aSf_BFu17i_Sf { empty v1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aSf_BFu17i_Uc { empty v1; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu17i_Ui { empty v1; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu17i_Ul { empty v1; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu17i_Us { empty v1; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu17i_Vp { empty v1; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aSf_BFu17ll { empty v1; unsigned long long v2:17; };
struct __attribute__((packed)) aSf_BFu17ll_BFu15i { empty v1; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu17ll_BFu15ll { empty v1; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu17ll_BFu15s { empty v1; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu17ll_BFu16i { empty v1; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu17ll_BFu16ll { empty v1; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu17ll_BFu16s { empty v1; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu17ll_BFu17i { empty v1; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu17ll_BFu17ll { empty v1; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu17ll_BFu1c { empty v1; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu17ll_BFu1i { empty v1; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu17ll_BFu1ll { empty v1; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu17ll_BFu1s { empty v1; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu17ll_BFu31i { empty v1; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu17ll_BFu31ll { empty v1; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu17ll_BFu32i { empty v1; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu17ll_BFu32ll { empty v1; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu17ll_BFu33 { empty v1; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu17ll_BFu7c { empty v1; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu17ll_BFu7i { empty v1; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu17ll_BFu7ll { empty v1; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu17ll_BFu7s { empty v1; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu17ll_BFu8c { empty v1; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu17ll_BFu8i { empty v1; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu17ll_BFu8ll { empty v1; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu17ll_BFu8s { empty v1; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu17ll_BFu9i { empty v1; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu17ll_BFu9ll { empty v1; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu17ll_BFu9s { empty v1; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu17ll_C { empty v1; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aSf_BFu17ll_D { empty v1; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aSf_BFu17ll_F { empty v1; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aSf_BFu17ll_I { empty v1; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aSf_BFu17ll_Ip { empty v1; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aSf_BFu17ll_L { empty v1; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aSf_BFu17ll_S { empty v1; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aSf_BFu17ll_Sf { empty v1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aSf_BFu17ll_Uc { empty v1; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu17ll_Ui { empty v1; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu17ll_Ul { empty v1; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu17ll_Us { empty v1; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu17ll_Vp { empty v1; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aSf_BFu1c { empty v1; unsigned char v2:1; };
struct __attribute__((packed)) aSf_BFu1c_BFu15i { empty v1; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu1c_BFu15ll { empty v1; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu1c_BFu15s { empty v1; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu1c_BFu16i { empty v1; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu1c_BFu16ll { empty v1; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu1c_BFu16s { empty v1; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu1c_BFu17i { empty v1; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu1c_BFu17ll { empty v1; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu1c_BFu1c { empty v1; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu1c_BFu1i { empty v1; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu1c_BFu1ll { empty v1; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu1c_BFu1s { empty v1; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu1c_BFu31i { empty v1; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu1c_BFu31ll { empty v1; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu1c_BFu32i { empty v1; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu1c_BFu32ll { empty v1; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu1c_BFu33 { empty v1; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu1c_BFu7c { empty v1; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu1c_BFu7i { empty v1; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu1c_BFu7ll { empty v1; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu1c_BFu7s { empty v1; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu1c_BFu8c { empty v1; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu1c_BFu8i { empty v1; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu1c_BFu8ll { empty v1; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu1c_BFu8s { empty v1; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu1c_BFu9i { empty v1; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu1c_BFu9ll { empty v1; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu1c_BFu9s { empty v1; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu1c_C { empty v1; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aSf_BFu1c_D { empty v1; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aSf_BFu1c_F { empty v1; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aSf_BFu1c_I { empty v1; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aSf_BFu1c_Ip { empty v1; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aSf_BFu1c_L { empty v1; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aSf_BFu1c_S { empty v1; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aSf_BFu1c_Sf { empty v1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aSf_BFu1c_Uc { empty v1; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu1c_Ui { empty v1; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu1c_Ul { empty v1; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu1c_Us { empty v1; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu1c_Vp { empty v1; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aSf_BFu1i { empty v1; unsigned int v2:1; };
struct __attribute__((packed)) aSf_BFu1i_BFu15i { empty v1; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu1i_BFu15ll { empty v1; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu1i_BFu15s { empty v1; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu1i_BFu16i { empty v1; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu1i_BFu16ll { empty v1; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu1i_BFu16s { empty v1; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu1i_BFu17i { empty v1; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu1i_BFu17ll { empty v1; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu1i_BFu1c { empty v1; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu1i_BFu1i { empty v1; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu1i_BFu1ll { empty v1; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu1i_BFu1s { empty v1; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu1i_BFu31i { empty v1; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu1i_BFu31ll { empty v1; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu1i_BFu32i { empty v1; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu1i_BFu32ll { empty v1; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu1i_BFu33 { empty v1; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu1i_BFu7c { empty v1; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu1i_BFu7i { empty v1; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu1i_BFu7ll { empty v1; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu1i_BFu7s { empty v1; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu1i_BFu8c { empty v1; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu1i_BFu8i { empty v1; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu1i_BFu8ll { empty v1; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu1i_BFu8s { empty v1; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu1i_BFu9i { empty v1; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu1i_BFu9ll { empty v1; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu1i_BFu9s { empty v1; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu1i_C { empty v1; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aSf_BFu1i_D { empty v1; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aSf_BFu1i_F { empty v1; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aSf_BFu1i_I { empty v1; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aSf_BFu1i_Ip { empty v1; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aSf_BFu1i_L { empty v1; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aSf_BFu1i_S { empty v1; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aSf_BFu1i_Sf { empty v1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aSf_BFu1i_Uc { empty v1; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu1i_Ui { empty v1; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu1i_Ul { empty v1; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu1i_Us { empty v1; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu1i_Vp { empty v1; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aSf_BFu1ll { empty v1; unsigned long long v2:1; };
struct __attribute__((packed)) aSf_BFu1ll_BFu15i { empty v1; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu1ll_BFu15ll { empty v1; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu1ll_BFu15s { empty v1; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu1ll_BFu16i { empty v1; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu1ll_BFu16ll { empty v1; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu1ll_BFu16s { empty v1; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu1ll_BFu17i { empty v1; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu1ll_BFu17ll { empty v1; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu1ll_BFu1c { empty v1; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu1ll_BFu1i { empty v1; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu1ll_BFu1ll { empty v1; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu1ll_BFu1s { empty v1; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu1ll_BFu31i { empty v1; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu1ll_BFu31ll { empty v1; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu1ll_BFu32i { empty v1; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu1ll_BFu32ll { empty v1; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu1ll_BFu33 { empty v1; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu1ll_BFu7c { empty v1; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu1ll_BFu7i { empty v1; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu1ll_BFu7ll { empty v1; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu1ll_BFu7s { empty v1; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu1ll_BFu8c { empty v1; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu1ll_BFu8i { empty v1; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu1ll_BFu8ll { empty v1; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu1ll_BFu8s { empty v1; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu1ll_BFu9i { empty v1; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu1ll_BFu9ll { empty v1; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu1ll_BFu9s { empty v1; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu1ll_C { empty v1; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aSf_BFu1ll_D { empty v1; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aSf_BFu1ll_F { empty v1; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aSf_BFu1ll_I { empty v1; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aSf_BFu1ll_Ip { empty v1; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aSf_BFu1ll_L { empty v1; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aSf_BFu1ll_S { empty v1; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aSf_BFu1ll_Sf { empty v1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aSf_BFu1ll_Uc { empty v1; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu1ll_Ui { empty v1; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu1ll_Ul { empty v1; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu1ll_Us { empty v1; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu1ll_Vp { empty v1; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aSf_BFu1s { empty v1; unsigned short v2:1; };
struct __attribute__((packed)) aSf_BFu1s_BFu15i { empty v1; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu1s_BFu15ll { empty v1; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu1s_BFu15s { empty v1; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu1s_BFu16i { empty v1; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu1s_BFu16ll { empty v1; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu1s_BFu16s { empty v1; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu1s_BFu17i { empty v1; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu1s_BFu17ll { empty v1; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu1s_BFu1c { empty v1; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu1s_BFu1i { empty v1; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu1s_BFu1ll { empty v1; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu1s_BFu1s { empty v1; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu1s_BFu31i { empty v1; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu1s_BFu31ll { empty v1; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu1s_BFu32i { empty v1; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu1s_BFu32ll { empty v1; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu1s_BFu33 { empty v1; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu1s_BFu7c { empty v1; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu1s_BFu7i { empty v1; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu1s_BFu7ll { empty v1; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu1s_BFu7s { empty v1; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu1s_BFu8c { empty v1; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu1s_BFu8i { empty v1; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu1s_BFu8ll { empty v1; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu1s_BFu8s { empty v1; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu1s_BFu9i { empty v1; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu1s_BFu9ll { empty v1; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu1s_BFu9s { empty v1; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu1s_C { empty v1; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aSf_BFu1s_D { empty v1; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aSf_BFu1s_F { empty v1; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aSf_BFu1s_I { empty v1; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aSf_BFu1s_Ip { empty v1; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aSf_BFu1s_L { empty v1; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aSf_BFu1s_S { empty v1; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aSf_BFu1s_Sf { empty v1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aSf_BFu1s_Uc { empty v1; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu1s_Ui { empty v1; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu1s_Ul { empty v1; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu1s_Us { empty v1; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu1s_Vp { empty v1; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aSf_BFu31i { empty v1; unsigned int v2:31; };
struct __attribute__((packed)) aSf_BFu31i_BFu15i { empty v1; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu31i_BFu15ll { empty v1; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu31i_BFu15s { empty v1; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu31i_BFu16i { empty v1; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu31i_BFu16ll { empty v1; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu31i_BFu16s { empty v1; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu31i_BFu17i { empty v1; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu31i_BFu17ll { empty v1; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu31i_BFu1c { empty v1; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu31i_BFu1i { empty v1; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu31i_BFu1ll { empty v1; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu31i_BFu1s { empty v1; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu31i_BFu31i { empty v1; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu31i_BFu31ll { empty v1; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu31i_BFu32i { empty v1; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu31i_BFu32ll { empty v1; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu31i_BFu33 { empty v1; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu31i_BFu7c { empty v1; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu31i_BFu7i { empty v1; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu31i_BFu7ll { empty v1; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu31i_BFu7s { empty v1; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu31i_BFu8c { empty v1; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu31i_BFu8i { empty v1; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu31i_BFu8ll { empty v1; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu31i_BFu8s { empty v1; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu31i_BFu9i { empty v1; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu31i_BFu9ll { empty v1; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu31i_BFu9s { empty v1; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu31i_C { empty v1; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aSf_BFu31i_D { empty v1; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aSf_BFu31i_F { empty v1; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aSf_BFu31i_I { empty v1; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aSf_BFu31i_Ip { empty v1; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aSf_BFu31i_L { empty v1; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aSf_BFu31i_S { empty v1; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aSf_BFu31i_Sf { empty v1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aSf_BFu31i_Uc { empty v1; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu31i_Ui { empty v1; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu31i_Ul { empty v1; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu31i_Us { empty v1; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu31i_Vp { empty v1; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aSf_BFu31ll { empty v1; unsigned long long v2:31; };
struct __attribute__((packed)) aSf_BFu31ll_BFu15i { empty v1; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu31ll_BFu15ll { empty v1; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu31ll_BFu15s { empty v1; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu31ll_BFu16i { empty v1; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu31ll_BFu16ll { empty v1; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu31ll_BFu16s { empty v1; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu31ll_BFu17i { empty v1; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu31ll_BFu17ll { empty v1; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu31ll_BFu1c { empty v1; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu31ll_BFu1i { empty v1; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu31ll_BFu1ll { empty v1; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu31ll_BFu1s { empty v1; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu31ll_BFu31i { empty v1; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu31ll_BFu31ll { empty v1; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu31ll_BFu32i { empty v1; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu31ll_BFu32ll { empty v1; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu31ll_BFu33 { empty v1; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu31ll_BFu7c { empty v1; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu31ll_BFu7i { empty v1; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu31ll_BFu7ll { empty v1; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu31ll_BFu7s { empty v1; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu31ll_BFu8c { empty v1; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu31ll_BFu8i { empty v1; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu31ll_BFu8ll { empty v1; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu31ll_BFu8s { empty v1; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu31ll_BFu9i { empty v1; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu31ll_BFu9ll { empty v1; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu31ll_BFu9s { empty v1; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu31ll_C { empty v1; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aSf_BFu31ll_D { empty v1; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aSf_BFu31ll_F { empty v1; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aSf_BFu31ll_I { empty v1; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aSf_BFu31ll_Ip { empty v1; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aSf_BFu31ll_L { empty v1; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aSf_BFu31ll_S { empty v1; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aSf_BFu31ll_Sf { empty v1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aSf_BFu31ll_Uc { empty v1; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu31ll_Ui { empty v1; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu31ll_Ul { empty v1; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu31ll_Us { empty v1; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu31ll_Vp { empty v1; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aSf_BFu32i { empty v1; unsigned int v2:32; };
struct __attribute__((packed)) aSf_BFu32i_BFu15i { empty v1; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu32i_BFu15ll { empty v1; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu32i_BFu15s { empty v1; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu32i_BFu16i { empty v1; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu32i_BFu16ll { empty v1; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu32i_BFu16s { empty v1; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu32i_BFu17i { empty v1; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu32i_BFu17ll { empty v1; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu32i_BFu1c { empty v1; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu32i_BFu1i { empty v1; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu32i_BFu1ll { empty v1; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu32i_BFu1s { empty v1; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu32i_BFu31i { empty v1; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu32i_BFu31ll { empty v1; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu32i_BFu32i { empty v1; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu32i_BFu32ll { empty v1; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu32i_BFu33 { empty v1; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu32i_BFu7c { empty v1; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu32i_BFu7i { empty v1; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu32i_BFu7ll { empty v1; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu32i_BFu7s { empty v1; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu32i_BFu8c { empty v1; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu32i_BFu8i { empty v1; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu32i_BFu8ll { empty v1; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu32i_BFu8s { empty v1; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu32i_BFu9i { empty v1; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu32i_BFu9ll { empty v1; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu32i_BFu9s { empty v1; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu32i_C { empty v1; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aSf_BFu32i_D { empty v1; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aSf_BFu32i_F { empty v1; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aSf_BFu32i_I { empty v1; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aSf_BFu32i_Ip { empty v1; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aSf_BFu32i_L { empty v1; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aSf_BFu32i_S { empty v1; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aSf_BFu32i_Sf { empty v1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aSf_BFu32i_Uc { empty v1; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu32i_Ui { empty v1; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu32i_Ul { empty v1; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu32i_Us { empty v1; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu32i_Vp { empty v1; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aSf_BFu32ll { empty v1; unsigned long long v2:32; };
struct __attribute__((packed)) aSf_BFu32ll_BFu15i { empty v1; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu32ll_BFu15ll { empty v1; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu32ll_BFu15s { empty v1; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu32ll_BFu16i { empty v1; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu32ll_BFu16ll { empty v1; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu32ll_BFu16s { empty v1; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu32ll_BFu17i { empty v1; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu32ll_BFu17ll { empty v1; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu32ll_BFu1c { empty v1; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu32ll_BFu1i { empty v1; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu32ll_BFu1ll { empty v1; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu32ll_BFu1s { empty v1; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu32ll_BFu31i { empty v1; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu32ll_BFu31ll { empty v1; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu32ll_BFu32i { empty v1; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu32ll_BFu32ll { empty v1; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu32ll_BFu33 { empty v1; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu32ll_BFu7c { empty v1; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu32ll_BFu7i { empty v1; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu32ll_BFu7ll { empty v1; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu32ll_BFu7s { empty v1; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu32ll_BFu8c { empty v1; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu32ll_BFu8i { empty v1; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu32ll_BFu8ll { empty v1; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu32ll_BFu8s { empty v1; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu32ll_BFu9i { empty v1; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu32ll_BFu9ll { empty v1; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu32ll_BFu9s { empty v1; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu32ll_C { empty v1; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aSf_BFu32ll_D { empty v1; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aSf_BFu32ll_F { empty v1; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aSf_BFu32ll_I { empty v1; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aSf_BFu32ll_Ip { empty v1; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aSf_BFu32ll_L { empty v1; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aSf_BFu32ll_S { empty v1; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aSf_BFu32ll_Sf { empty v1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aSf_BFu32ll_Uc { empty v1; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu32ll_Ui { empty v1; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu32ll_Ul { empty v1; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu32ll_Us { empty v1; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu32ll_Vp { empty v1; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aSf_BFu33 { empty v1; unsigned long long v2:33; };
struct __attribute__((packed)) aSf_BFu33_BFu15i { empty v1; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu33_BFu15ll { empty v1; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu33_BFu15s { empty v1; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu33_BFu16i { empty v1; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu33_BFu16ll { empty v1; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu33_BFu16s { empty v1; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu33_BFu17i { empty v1; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu33_BFu17ll { empty v1; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu33_BFu1c { empty v1; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu33_BFu1i { empty v1; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu33_BFu1ll { empty v1; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu33_BFu1s { empty v1; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu33_BFu31i { empty v1; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu33_BFu31ll { empty v1; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu33_BFu32i { empty v1; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu33_BFu32ll { empty v1; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu33_BFu33 { empty v1; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu33_BFu7c { empty v1; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu33_BFu7i { empty v1; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu33_BFu7ll { empty v1; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu33_BFu7s { empty v1; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu33_BFu8c { empty v1; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu33_BFu8i { empty v1; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu33_BFu8ll { empty v1; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu33_BFu8s { empty v1; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu33_BFu9i { empty v1; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu33_BFu9ll { empty v1; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu33_BFu9s { empty v1; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu33_C { empty v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aSf_BFu33_D { empty v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aSf_BFu33_F { empty v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aSf_BFu33_I { empty v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aSf_BFu33_Ip { empty v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aSf_BFu33_L { empty v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aSf_BFu33_S { empty v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aSf_BFu33_Sf { empty v1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aSf_BFu33_Uc { empty v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu33_Ui { empty v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu33_Ul { empty v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu33_Us { empty v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu33_Vp { empty v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aSf_BFu7c { empty v1; unsigned char v2:7; };
struct __attribute__((packed)) aSf_BFu7c_BFu15i { empty v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu7c_BFu15ll { empty v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu7c_BFu15s { empty v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu7c_BFu16i { empty v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu7c_BFu16ll { empty v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu7c_BFu16s { empty v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu7c_BFu17i { empty v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu7c_BFu17ll { empty v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu7c_BFu1c { empty v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu7c_BFu1i { empty v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu7c_BFu1ll { empty v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu7c_BFu1s { empty v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu7c_BFu31i { empty v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu7c_BFu31ll { empty v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu7c_BFu32i { empty v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu7c_BFu32ll { empty v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu7c_BFu33 { empty v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu7c_BFu7c { empty v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu7c_BFu7i { empty v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu7c_BFu7ll { empty v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu7c_BFu7s { empty v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu7c_BFu8c { empty v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu7c_BFu8i { empty v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu7c_BFu8ll { empty v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu7c_BFu8s { empty v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu7c_BFu9i { empty v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu7c_BFu9ll { empty v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu7c_BFu9s { empty v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu7c_C { empty v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aSf_BFu7c_D { empty v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aSf_BFu7c_F { empty v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aSf_BFu7c_I { empty v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aSf_BFu7c_Ip { empty v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aSf_BFu7c_L { empty v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aSf_BFu7c_S { empty v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aSf_BFu7c_Sf { empty v1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aSf_BFu7c_Uc { empty v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu7c_Ui { empty v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu7c_Ul { empty v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu7c_Us { empty v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu7c_Vp { empty v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aSf_BFu7i { empty v1; unsigned int v2:7; };
struct __attribute__((packed)) aSf_BFu7i_BFu15i { empty v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu7i_BFu15ll { empty v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu7i_BFu15s { empty v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu7i_BFu16i { empty v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu7i_BFu16ll { empty v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu7i_BFu16s { empty v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu7i_BFu17i { empty v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu7i_BFu17ll { empty v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu7i_BFu1c { empty v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu7i_BFu1i { empty v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu7i_BFu1ll { empty v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu7i_BFu1s { empty v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu7i_BFu31i { empty v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu7i_BFu31ll { empty v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu7i_BFu32i { empty v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu7i_BFu32ll { empty v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu7i_BFu33 { empty v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu7i_BFu7c { empty v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu7i_BFu7i { empty v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu7i_BFu7ll { empty v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu7i_BFu7s { empty v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu7i_BFu8c { empty v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu7i_BFu8i { empty v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu7i_BFu8ll { empty v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu7i_BFu8s { empty v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu7i_BFu9i { empty v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu7i_BFu9ll { empty v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu7i_BFu9s { empty v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu7i_C { empty v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aSf_BFu7i_D { empty v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aSf_BFu7i_F { empty v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aSf_BFu7i_I { empty v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aSf_BFu7i_Ip { empty v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aSf_BFu7i_L { empty v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aSf_BFu7i_S { empty v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aSf_BFu7i_Sf { empty v1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aSf_BFu7i_Uc { empty v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu7i_Ui { empty v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu7i_Ul { empty v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu7i_Us { empty v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu7i_Vp { empty v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aSf_BFu7ll { empty v1; unsigned long long v2:7; };
struct __attribute__((packed)) aSf_BFu7ll_BFu15i { empty v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu7ll_BFu15ll { empty v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu7ll_BFu15s { empty v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu7ll_BFu16i { empty v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu7ll_BFu16ll { empty v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu7ll_BFu16s { empty v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu7ll_BFu17i { empty v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu7ll_BFu17ll { empty v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu7ll_BFu1c { empty v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu7ll_BFu1i { empty v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu7ll_BFu1ll { empty v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu7ll_BFu1s { empty v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu7ll_BFu31i { empty v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu7ll_BFu31ll { empty v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu7ll_BFu32i { empty v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu7ll_BFu32ll { empty v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu7ll_BFu33 { empty v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu7ll_BFu7c { empty v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu7ll_BFu7i { empty v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu7ll_BFu7ll { empty v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu7ll_BFu7s { empty v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu7ll_BFu8c { empty v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu7ll_BFu8i { empty v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu7ll_BFu8ll { empty v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu7ll_BFu8s { empty v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu7ll_BFu9i { empty v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu7ll_BFu9ll { empty v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu7ll_BFu9s { empty v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu7ll_C { empty v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aSf_BFu7ll_D { empty v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aSf_BFu7ll_F { empty v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aSf_BFu7ll_I { empty v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aSf_BFu7ll_Ip { empty v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aSf_BFu7ll_L { empty v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aSf_BFu7ll_S { empty v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aSf_BFu7ll_Sf { empty v1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aSf_BFu7ll_Uc { empty v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu7ll_Ui { empty v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu7ll_Ul { empty v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu7ll_Us { empty v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu7ll_Vp { empty v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aSf_BFu7s { empty v1; unsigned short v2:7; };
struct __attribute__((packed)) aSf_BFu7s_BFu15i { empty v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu7s_BFu15ll { empty v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu7s_BFu15s { empty v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu7s_BFu16i { empty v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu7s_BFu16ll { empty v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu7s_BFu16s { empty v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu7s_BFu17i { empty v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu7s_BFu17ll { empty v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu7s_BFu1c { empty v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu7s_BFu1i { empty v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu7s_BFu1ll { empty v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu7s_BFu1s { empty v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu7s_BFu31i { empty v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu7s_BFu31ll { empty v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu7s_BFu32i { empty v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu7s_BFu32ll { empty v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu7s_BFu33 { empty v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu7s_BFu7c { empty v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu7s_BFu7i { empty v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu7s_BFu7ll { empty v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu7s_BFu7s { empty v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu7s_BFu8c { empty v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu7s_BFu8i { empty v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu7s_BFu8ll { empty v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu7s_BFu8s { empty v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu7s_BFu9i { empty v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu7s_BFu9ll { empty v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu7s_BFu9s { empty v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu7s_C { empty v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aSf_BFu7s_D { empty v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aSf_BFu7s_F { empty v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aSf_BFu7s_I { empty v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aSf_BFu7s_Ip { empty v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aSf_BFu7s_L { empty v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aSf_BFu7s_S { empty v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aSf_BFu7s_Sf { empty v1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aSf_BFu7s_Uc { empty v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu7s_Ui { empty v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu7s_Ul { empty v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu7s_Us { empty v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu7s_Vp { empty v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aSf_BFu8c { empty v1; unsigned char v2:8; };
struct __attribute__((packed)) aSf_BFu8c_BFu15i { empty v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu8c_BFu15ll { empty v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu8c_BFu15s { empty v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu8c_BFu16i { empty v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu8c_BFu16ll { empty v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu8c_BFu16s { empty v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu8c_BFu17i { empty v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu8c_BFu17ll { empty v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu8c_BFu1c { empty v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu8c_BFu1i { empty v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu8c_BFu1ll { empty v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu8c_BFu1s { empty v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu8c_BFu31i { empty v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu8c_BFu31ll { empty v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu8c_BFu32i { empty v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu8c_BFu32ll { empty v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu8c_BFu33 { empty v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu8c_BFu7c { empty v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu8c_BFu7i { empty v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu8c_BFu7ll { empty v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu8c_BFu7s { empty v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu8c_BFu8c { empty v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu8c_BFu8i { empty v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu8c_BFu8ll { empty v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu8c_BFu8s { empty v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu8c_BFu9i { empty v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu8c_BFu9ll { empty v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu8c_BFu9s { empty v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu8c_C { empty v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aSf_BFu8c_D { empty v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aSf_BFu8c_F { empty v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aSf_BFu8c_I { empty v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aSf_BFu8c_Ip { empty v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aSf_BFu8c_L { empty v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aSf_BFu8c_S { empty v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aSf_BFu8c_Sf { empty v1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aSf_BFu8c_Uc { empty v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu8c_Ui { empty v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu8c_Ul { empty v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu8c_Us { empty v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu8c_Vp { empty v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aSf_BFu8i { empty v1; unsigned int v2:8; };
struct __attribute__((packed)) aSf_BFu8i_BFu15i { empty v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu8i_BFu15ll { empty v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu8i_BFu15s { empty v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu8i_BFu16i { empty v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu8i_BFu16ll { empty v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu8i_BFu16s { empty v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu8i_BFu17i { empty v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu8i_BFu17ll { empty v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu8i_BFu1c { empty v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu8i_BFu1i { empty v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu8i_BFu1ll { empty v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu8i_BFu1s { empty v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu8i_BFu31i { empty v1; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu8i_BFu31ll { empty v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu8i_BFu32i { empty v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu8i_BFu32ll { empty v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu8i_BFu33 { empty v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu8i_BFu7c { empty v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu8i_BFu7i { empty v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu8i_BFu7ll { empty v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu8i_BFu7s { empty v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu8i_BFu8c { empty v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu8i_BFu8i { empty v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu8i_BFu8ll { empty v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu8i_BFu8s { empty v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu8i_BFu9i { empty v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu8i_BFu9ll { empty v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu8i_BFu9s { empty v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu8i_C { empty v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aSf_BFu8i_D { empty v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aSf_BFu8i_F { empty v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aSf_BFu8i_I { empty v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aSf_BFu8i_Ip { empty v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aSf_BFu8i_L { empty v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aSf_BFu8i_S { empty v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aSf_BFu8i_Sf { empty v1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aSf_BFu8i_Uc { empty v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu8i_Ui { empty v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu8i_Ul { empty v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu8i_Us { empty v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu8i_Vp { empty v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aSf_BFu8ll { empty v1; unsigned long long v2:8; };
struct __attribute__((packed)) aSf_BFu8ll_BFu15i { empty v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu8ll_BFu15ll { empty v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu8ll_BFu15s { empty v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu8ll_BFu16i { empty v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu8ll_BFu16ll { empty v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu8ll_BFu16s { empty v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu8ll_BFu17i { empty v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu8ll_BFu17ll { empty v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu8ll_BFu1c { empty v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu8ll_BFu1i { empty v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu8ll_BFu1ll { empty v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu8ll_BFu1s { empty v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu8ll_BFu31i { empty v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu8ll_BFu31ll { empty v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu8ll_BFu32i { empty v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu8ll_BFu32ll { empty v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu8ll_BFu33 { empty v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu8ll_BFu7c { empty v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu8ll_BFu7i { empty v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu8ll_BFu7ll { empty v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu8ll_BFu7s { empty v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu8ll_BFu8c { empty v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu8ll_BFu8i { empty v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu8ll_BFu8ll { empty v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu8ll_BFu8s { empty v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu8ll_BFu9i { empty v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu8ll_BFu9ll { empty v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu8ll_BFu9s { empty v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu8ll_C { empty v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aSf_BFu8ll_D { empty v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aSf_BFu8ll_F { empty v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aSf_BFu8ll_I { empty v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aSf_BFu8ll_Ip { empty v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aSf_BFu8ll_L { empty v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aSf_BFu8ll_S { empty v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aSf_BFu8ll_Sf { empty v1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aSf_BFu8ll_Uc { empty v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu8ll_Ui { empty v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu8ll_Ul { empty v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu8ll_Us { empty v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu8ll_Vp { empty v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aSf_BFu8s { empty v1; unsigned short v2:8; };
struct __attribute__((packed)) aSf_BFu8s_BFu15i { empty v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu8s_BFu15ll { empty v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu8s_BFu15s { empty v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu8s_BFu16i { empty v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu8s_BFu16ll { empty v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu8s_BFu16s { empty v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu8s_BFu17i { empty v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu8s_BFu17ll { empty v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu8s_BFu1c { empty v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu8s_BFu1i { empty v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu8s_BFu1ll { empty v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu8s_BFu1s { empty v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu8s_BFu31i { empty v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu8s_BFu31ll { empty v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu8s_BFu32i { empty v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu8s_BFu32ll { empty v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu8s_BFu33 { empty v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu8s_BFu7c { empty v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu8s_BFu7i { empty v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu8s_BFu7ll { empty v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu8s_BFu7s { empty v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu8s_BFu8c { empty v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu8s_BFu8i { empty v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu8s_BFu8ll { empty v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu8s_BFu8s { empty v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu8s_BFu9i { empty v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu8s_BFu9ll { empty v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu8s_BFu9s { empty v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu8s_C { empty v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aSf_BFu8s_D { empty v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aSf_BFu8s_F { empty v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aSf_BFu8s_I { empty v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aSf_BFu8s_Ip { empty v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aSf_BFu8s_L { empty v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aSf_BFu8s_S { empty v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aSf_BFu8s_Sf { empty v1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aSf_BFu8s_Uc { empty v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu8s_Ui { empty v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu8s_Ul { empty v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu8s_Us { empty v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu8s_Vp { empty v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aSf_BFu9i { empty v1; unsigned int v2:9; };
struct __attribute__((packed)) aSf_BFu9i_BFu15i { empty v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu9i_BFu15ll { empty v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu9i_BFu15s { empty v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu9i_BFu16i { empty v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu9i_BFu16ll { empty v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu9i_BFu16s { empty v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu9i_BFu17i { empty v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu9i_BFu17ll { empty v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu9i_BFu1c { empty v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu9i_BFu1i { empty v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu9i_BFu1ll { empty v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu9i_BFu1s { empty v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu9i_BFu31i { empty v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu9i_BFu31ll { empty v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu9i_BFu32i { empty v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu9i_BFu32ll { empty v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu9i_BFu33 { empty v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu9i_BFu7c { empty v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu9i_BFu7i { empty v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu9i_BFu7ll { empty v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu9i_BFu7s { empty v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu9i_BFu8c { empty v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu9i_BFu8i { empty v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu9i_BFu8ll { empty v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu9i_BFu8s { empty v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu9i_BFu9i { empty v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu9i_BFu9ll { empty v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu9i_BFu9s { empty v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu9i_C { empty v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aSf_BFu9i_D { empty v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aSf_BFu9i_F { empty v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aSf_BFu9i_I { empty v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aSf_BFu9i_Ip { empty v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aSf_BFu9i_L { empty v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aSf_BFu9i_S { empty v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aSf_BFu9i_Sf { empty v1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aSf_BFu9i_Uc { empty v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu9i_Ui { empty v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu9i_Ul { empty v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu9i_Us { empty v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu9i_Vp { empty v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aSf_BFu9ll { empty v1; unsigned long long v2:9; };
struct __attribute__((packed)) aSf_BFu9ll_BFu15i { empty v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu9ll_BFu15ll { empty v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu9ll_BFu15s { empty v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu9ll_BFu16i { empty v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu9ll_BFu16ll { empty v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu9ll_BFu16s { empty v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu9ll_BFu17i { empty v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu9ll_BFu17ll { empty v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu9ll_BFu1c { empty v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu9ll_BFu1i { empty v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu9ll_BFu1ll { empty v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu9ll_BFu1s { empty v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu9ll_BFu31i { empty v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu9ll_BFu31ll { empty v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu9ll_BFu32i { empty v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu9ll_BFu32ll { empty v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu9ll_BFu33 { empty v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu9ll_BFu7c { empty v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu9ll_BFu7i { empty v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu9ll_BFu7ll { empty v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu9ll_BFu7s { empty v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu9ll_BFu8c { empty v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu9ll_BFu8i { empty v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu9ll_BFu8ll { empty v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu9ll_BFu8s { empty v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu9ll_BFu9i { empty v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu9ll_BFu9ll { empty v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu9ll_BFu9s { empty v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu9ll_C { empty v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aSf_BFu9ll_D { empty v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aSf_BFu9ll_F { empty v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aSf_BFu9ll_I { empty v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aSf_BFu9ll_Ip { empty v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aSf_BFu9ll_L { empty v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aSf_BFu9ll_S { empty v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aSf_BFu9ll_Sf { empty v1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aSf_BFu9ll_Uc { empty v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu9ll_Ui { empty v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu9ll_Ul { empty v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu9ll_Us { empty v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu9ll_Vp { empty v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aSf_BFu9s { empty v1; unsigned short v2:9; };
struct __attribute__((packed)) aSf_BFu9s_BFu15i { empty v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu9s_BFu15ll { empty v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu9s_BFu15s { empty v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu9s_BFu16i { empty v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu9s_BFu16ll { empty v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu9s_BFu16s { empty v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu9s_BFu17i { empty v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu9s_BFu17ll { empty v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu9s_BFu1c { empty v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu9s_BFu1i { empty v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu9s_BFu1ll { empty v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu9s_BFu1s { empty v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu9s_BFu31i { empty v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu9s_BFu31ll { empty v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu9s_BFu32i { empty v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu9s_BFu32ll { empty v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu9s_BFu33 { empty v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu9s_BFu7c { empty v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu9s_BFu7i { empty v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu9s_BFu7ll { empty v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu9s_BFu7s { empty v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu9s_BFu8c { empty v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu9s_BFu8i { empty v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu9s_BFu8ll { empty v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu9s_BFu8s { empty v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu9s_BFu9i { empty v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu9s_BFu9ll { empty v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu9s_BFu9s { empty v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu9s_C { empty v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aSf_BFu9s_D { empty v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aSf_BFu9s_F { empty v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aSf_BFu9s_I { empty v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aSf_BFu9s_Ip { empty v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aSf_BFu9s_L { empty v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aSf_BFu9s_S { empty v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aSf_BFu9s_Sf { empty v1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aSf_BFu9s_Uc { empty v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu9s_Ui { empty v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu9s_Ul { empty v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu9s_Us { empty v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu9s_Vp { empty v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aSf_C { empty v1; char v2; };
struct __attribute__((packed)) aSf_C_BFu15i { empty v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aSf_C_BFu15ll { empty v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_C_BFu15s { empty v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aSf_C_BFu16i { empty v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aSf_C_BFu16ll { empty v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_C_BFu16s { empty v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aSf_C_BFu17i { empty v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aSf_C_BFu17ll { empty v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_C_BFu1c { empty v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aSf_C_BFu1i { empty v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aSf_C_BFu1ll { empty v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_C_BFu1s { empty v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aSf_C_BFu31i { empty v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aSf_C_BFu31ll { empty v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_C_BFu32i { empty v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aSf_C_BFu32ll { empty v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_C_BFu33 { empty v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_C_BFu7c { empty v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aSf_C_BFu7i { empty v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aSf_C_BFu7ll { empty v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_C_BFu7s { empty v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aSf_C_BFu8c { empty v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aSf_C_BFu8i { empty v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aSf_C_BFu8ll { empty v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_C_BFu8s { empty v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aSf_C_BFu9i { empty v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aSf_C_BFu9ll { empty v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_C_BFu9s { empty v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aSf_C_C { empty v1; char v2; char v3; };
struct __attribute__((packed)) aSf_C_D { empty v1; char v2; double v3; };
struct __attribute__((packed)) aSf_C_F { empty v1; char v2; float v3; };
struct __attribute__((packed)) aSf_C_I { empty v1; char v2; int v3; };
struct __attribute__((packed)) aSf_C_Ip { empty v1; char v2; int * v3; };
struct __attribute__((packed)) aSf_C_L { empty v1; char v2; long long v3; };
struct __attribute__((packed)) aSf_C_S { empty v1; char v2; short v3; };
struct __attribute__((packed)) aSf_C_Sf { empty v1; char v2; empty v3; };
struct __attribute__((packed)) aSf_C_Uc { empty v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aSf_C_Ui { empty v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aSf_C_Ul { empty v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aSf_C_Us { empty v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aSf_C_Vp { empty v1; char v2; void * v3; };
struct __attribute__((packed)) aSf_D { empty v1; double v2; };
struct __attribute__((packed)) aSf_D_BFu15i { empty v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aSf_D_BFu15ll { empty v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_D_BFu15s { empty v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aSf_D_BFu16i { empty v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aSf_D_BFu16ll { empty v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_D_BFu16s { empty v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aSf_D_BFu17i { empty v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aSf_D_BFu17ll { empty v1; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_D_BFu1c { empty v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aSf_D_BFu1i { empty v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aSf_D_BFu1ll { empty v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_D_BFu1s { empty v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aSf_D_BFu31i { empty v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aSf_D_BFu31ll { empty v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_D_BFu32i { empty v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aSf_D_BFu32ll { empty v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_D_BFu33 { empty v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_D_BFu7c { empty v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aSf_D_BFu7i { empty v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aSf_D_BFu7ll { empty v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_D_BFu7s { empty v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aSf_D_BFu8c { empty v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aSf_D_BFu8i { empty v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aSf_D_BFu8ll { empty v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_D_BFu8s { empty v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aSf_D_BFu9i { empty v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aSf_D_BFu9ll { empty v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_D_BFu9s { empty v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aSf_D_C { empty v1; double v2; char v3; };
struct __attribute__((packed)) aSf_D_D { empty v1; double v2; double v3; };
struct __attribute__((packed)) aSf_D_F { empty v1; double v2; float v3; };
struct __attribute__((packed)) aSf_D_I { empty v1; double v2; int v3; };
struct __attribute__((packed)) aSf_D_Ip { empty v1; double v2; int * v3; };
struct __attribute__((packed)) aSf_D_L { empty v1; double v2; long long v3; };
struct __attribute__((packed)) aSf_D_S { empty v1; double v2; short v3; };
struct __attribute__((packed)) aSf_D_Sf { empty v1; double v2; empty v3; };
struct __attribute__((packed)) aSf_D_Uc { empty v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aSf_D_Ui { empty v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aSf_D_Ul { empty v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aSf_D_Us { empty v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aSf_D_Vp { empty v1; double v2; void * v3; };
struct __attribute__((packed)) aSf_F { empty v1; float v2; };
struct __attribute__((packed)) aSf_F_BFu15i { empty v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aSf_F_BFu15ll { empty v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_F_BFu15s { empty v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aSf_F_BFu16i { empty v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aSf_F_BFu16ll { empty v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_F_BFu16s { empty v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aSf_F_BFu17i { empty v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aSf_F_BFu17ll { empty v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_F_BFu1c { empty v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aSf_F_BFu1i { empty v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aSf_F_BFu1ll { empty v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_F_BFu1s { empty v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aSf_F_BFu31i { empty v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aSf_F_BFu31ll { empty v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_F_BFu32i { empty v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aSf_F_BFu32ll { empty v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_F_BFu33 { empty v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_F_BFu7c { empty v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aSf_F_BFu7i { empty v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aSf_F_BFu7ll { empty v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_F_BFu7s { empty v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aSf_F_BFu8c { empty v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aSf_F_BFu8i { empty v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aSf_F_BFu8ll { empty v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_F_BFu8s { empty v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aSf_F_BFu9i { empty v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aSf_F_BFu9ll { empty v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_F_BFu9s { empty v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aSf_F_C { empty v1; float v2; char v3; };
struct __attribute__((packed)) aSf_F_D { empty v1; float v2; double v3; };
struct __attribute__((packed)) aSf_F_F { empty v1; float v2; float v3; };
struct __attribute__((packed)) aSf_F_I { empty v1; float v2; int v3; };
struct __attribute__((packed)) aSf_F_Ip { empty v1; float v2; int * v3; };
struct __attribute__((packed)) aSf_F_L { empty v1; float v2; long long v3; };
struct __attribute__((packed)) aSf_F_S { empty v1; float v2; short v3; };
struct __attribute__((packed)) aSf_F_Sf { empty v1; float v2; empty v3; };
struct __attribute__((packed)) aSf_F_Uc { empty v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aSf_F_Ui { empty v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aSf_F_Ul { empty v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aSf_F_Us { empty v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aSf_F_Vp { empty v1; float v2; void * v3; };
struct __attribute__((packed)) aSf_I { empty v1; int v2; };
struct __attribute__((packed)) aSf_I_BFu15i { empty v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aSf_I_BFu15ll { empty v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_I_BFu15s { empty v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aSf_I_BFu16i { empty v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aSf_I_BFu16ll { empty v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_I_BFu16s { empty v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aSf_I_BFu17i { empty v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aSf_I_BFu17ll { empty v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_I_BFu1c { empty v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aSf_I_BFu1i { empty v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aSf_I_BFu1ll { empty v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_I_BFu1s { empty v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aSf_I_BFu31i { empty v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aSf_I_BFu31ll { empty v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_I_BFu32i { empty v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aSf_I_BFu32ll { empty v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_I_BFu33 { empty v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_I_BFu7c { empty v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aSf_I_BFu7i { empty v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aSf_I_BFu7ll { empty v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_I_BFu7s { empty v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aSf_I_BFu8c { empty v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aSf_I_BFu8i { empty v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aSf_I_BFu8ll { empty v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_I_BFu8s { empty v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aSf_I_BFu9i { empty v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aSf_I_BFu9ll { empty v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_I_BFu9s { empty v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aSf_I_C { empty v1; int v2; char v3; };
struct __attribute__((packed)) aSf_I_D { empty v1; int v2; double v3; };
struct __attribute__((packed)) aSf_I_F { empty v1; int v2; float v3; };
struct __attribute__((packed)) aSf_I_I { empty v1; int v2; int v3; };
struct __attribute__((packed)) aSf_I_Ip { empty v1; int v2; int * v3; };
struct __attribute__((packed)) aSf_I_L { empty v1; int v2; long long v3; };
struct __attribute__((packed)) aSf_I_S { empty v1; int v2; short v3; };
struct __attribute__((packed)) aSf_I_Sf { empty v1; int v2; empty v3; };
struct __attribute__((packed)) aSf_I_Uc { empty v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aSf_I_Ui { empty v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aSf_I_Ul { empty v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aSf_I_Us { empty v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aSf_I_Vp { empty v1; int v2; void * v3; };
struct __attribute__((packed)) aSf_Ip { empty v1; int * v2; };
struct __attribute__((packed)) aSf_Ip_BFu15i { empty v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aSf_Ip_BFu15ll { empty v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_Ip_BFu15s { empty v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aSf_Ip_BFu16i { empty v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aSf_Ip_BFu16ll { empty v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_Ip_BFu16s { empty v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aSf_Ip_BFu17i { empty v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aSf_Ip_BFu17ll { empty v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_Ip_BFu1c { empty v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aSf_Ip_BFu1i { empty v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aSf_Ip_BFu1ll { empty v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_Ip_BFu1s { empty v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aSf_Ip_BFu31i { empty v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aSf_Ip_BFu31ll { empty v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_Ip_BFu32i { empty v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aSf_Ip_BFu32ll { empty v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_Ip_BFu33 { empty v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_Ip_BFu7c { empty v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aSf_Ip_BFu7i { empty v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aSf_Ip_BFu7ll { empty v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_Ip_BFu7s { empty v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aSf_Ip_BFu8c { empty v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aSf_Ip_BFu8i { empty v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aSf_Ip_BFu8ll { empty v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_Ip_BFu8s { empty v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aSf_Ip_BFu9i { empty v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aSf_Ip_BFu9ll { empty v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_Ip_BFu9s { empty v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aSf_Ip_C { empty v1; int * v2; char v3; };
struct __attribute__((packed)) aSf_Ip_D { empty v1; int * v2; double v3; };
struct __attribute__((packed)) aSf_Ip_F { empty v1; int * v2; float v3; };
struct __attribute__((packed)) aSf_Ip_I { empty v1; int * v2; int v3; };
struct __attribute__((packed)) aSf_Ip_Ip { empty v1; int * v2; int * v3; };
struct __attribute__((packed)) aSf_Ip_L { empty v1; int * v2; long long v3; };
struct __attribute__((packed)) aSf_Ip_S { empty v1; int * v2; short v3; };
struct __attribute__((packed)) aSf_Ip_Sf { empty v1; int * v2; empty v3; };
struct __attribute__((packed)) aSf_Ip_Uc { empty v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aSf_Ip_Ui { empty v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aSf_Ip_Ul { empty v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aSf_Ip_Us { empty v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aSf_Ip_Vp { empty v1; int * v2; void * v3; };
struct __attribute__((packed)) aSf_L { empty v1; long long v2; };
struct __attribute__((packed)) aSf_L_BFu15i { empty v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aSf_L_BFu15ll { empty v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_L_BFu15s { empty v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aSf_L_BFu16i { empty v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aSf_L_BFu16ll { empty v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_L_BFu16s { empty v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aSf_L_BFu17i { empty v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aSf_L_BFu17ll { empty v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_L_BFu1c { empty v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aSf_L_BFu1i { empty v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aSf_L_BFu1ll { empty v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_L_BFu1s { empty v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aSf_L_BFu31i { empty v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aSf_L_BFu31ll { empty v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_L_BFu32i { empty v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aSf_L_BFu32ll { empty v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_L_BFu33 { empty v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_L_BFu7c { empty v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aSf_L_BFu7i { empty v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aSf_L_BFu7ll { empty v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_L_BFu7s { empty v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aSf_L_BFu8c { empty v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aSf_L_BFu8i { empty v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aSf_L_BFu8ll { empty v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_L_BFu8s { empty v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aSf_L_BFu9i { empty v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aSf_L_BFu9ll { empty v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_L_BFu9s { empty v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aSf_L_C { empty v1; long long v2; char v3; };
struct __attribute__((packed)) aSf_L_D { empty v1; long long v2; double v3; };
struct __attribute__((packed)) aSf_L_F { empty v1; long long v2; float v3; };
struct __attribute__((packed)) aSf_L_I { empty v1; long long v2; int v3; };
struct __attribute__((packed)) aSf_L_Ip { empty v1; long long v2; int * v3; };
struct __attribute__((packed)) aSf_L_L { empty v1; long long v2; long long v3; };
struct __attribute__((packed)) aSf_L_S { empty v1; long long v2; short v3; };
struct __attribute__((packed)) aSf_L_Sf { empty v1; long long v2; empty v3; };
struct __attribute__((packed)) aSf_L_Uc { empty v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aSf_L_Ui { empty v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aSf_L_Ul { empty v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aSf_L_Us { empty v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aSf_L_Vp { empty v1; long long v2; void * v3; };
struct __attribute__((packed)) aSf_S { empty v1; short v2; };
struct __attribute__((packed)) aSf_S_BFu15i { empty v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aSf_S_BFu15ll { empty v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_S_BFu15s { empty v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aSf_S_BFu16i { empty v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aSf_S_BFu16ll { empty v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_S_BFu16s { empty v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aSf_S_BFu17i { empty v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aSf_S_BFu17ll { empty v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_S_BFu1c { empty v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aSf_S_BFu1i { empty v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aSf_S_BFu1ll { empty v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_S_BFu1s { empty v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aSf_S_BFu31i { empty v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aSf_S_BFu31ll { empty v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_S_BFu32i { empty v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aSf_S_BFu32ll { empty v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_S_BFu33 { empty v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_S_BFu7c { empty v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aSf_S_BFu7i { empty v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aSf_S_BFu7ll { empty v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_S_BFu7s { empty v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aSf_S_BFu8c { empty v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aSf_S_BFu8i { empty v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aSf_S_BFu8ll { empty v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_S_BFu8s { empty v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aSf_S_BFu9i { empty v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aSf_S_BFu9ll { empty v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_S_BFu9s { empty v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aSf_S_C { empty v1; short v2; char v3; };
struct __attribute__((packed)) aSf_S_D { empty v1; short v2; double v3; };
struct __attribute__((packed)) aSf_S_F { empty v1; short v2; float v3; };
struct __attribute__((packed)) aSf_S_I { empty v1; short v2; int v3; };
struct __attribute__((packed)) aSf_S_Ip { empty v1; short v2; int * v3; };
struct __attribute__((packed)) aSf_S_L { empty v1; short v2; long long v3; };
struct __attribute__((packed)) aSf_S_S { empty v1; short v2; short v3; };
struct __attribute__((packed)) aSf_S_Sf { empty v1; short v2; empty v3; };
struct __attribute__((packed)) aSf_S_Uc { empty v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aSf_S_Ui { empty v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aSf_S_Ul { empty v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aSf_S_Us { empty v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aSf_S_Vp { empty v1; short v2; void * v3; };
struct __attribute__((packed)) aSf_Sf { empty v1; empty v2; };
struct __attribute__((packed)) aSf_Sf_BFu15i { empty v1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aSf_Sf_BFu15ll { empty v1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_Sf_BFu15s { empty v1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aSf_Sf_BFu16i { empty v1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aSf_Sf_BFu16ll { empty v1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_Sf_BFu16s { empty v1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aSf_Sf_BFu17i { empty v1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aSf_Sf_BFu17ll { empty v1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_Sf_BFu1c { empty v1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aSf_Sf_BFu1i { empty v1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aSf_Sf_BFu1ll { empty v1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_Sf_BFu1s { empty v1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aSf_Sf_BFu31i { empty v1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aSf_Sf_BFu31ll { empty v1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_Sf_BFu32i { empty v1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aSf_Sf_BFu32ll { empty v1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_Sf_BFu33 { empty v1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_Sf_BFu7c { empty v1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aSf_Sf_BFu7i { empty v1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aSf_Sf_BFu7ll { empty v1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_Sf_BFu7s { empty v1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aSf_Sf_BFu8c { empty v1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aSf_Sf_BFu8i { empty v1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aSf_Sf_BFu8ll { empty v1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_Sf_BFu8s { empty v1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aSf_Sf_BFu9i { empty v1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aSf_Sf_BFu9ll { empty v1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_Sf_BFu9s { empty v1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aSf_Sf_C { empty v1; empty v2; char v3; };
struct __attribute__((packed)) aSf_Sf_D { empty v1; empty v2; double v3; };
struct __attribute__((packed)) aSf_Sf_F { empty v1; empty v2; float v3; };
struct __attribute__((packed)) aSf_Sf_I { empty v1; empty v2; int v3; };
struct __attribute__((packed)) aSf_Sf_Ip { empty v1; empty v2; int * v3; };
struct __attribute__((packed)) aSf_Sf_L { empty v1; empty v2; long long v3; };
struct __attribute__((packed)) aSf_Sf_S { empty v1; empty v2; short v3; };
struct __attribute__((packed)) aSf_Sf_Sf { empty v1; empty v2; empty v3; };
struct __attribute__((packed)) aSf_Sf_Uc { empty v1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aSf_Sf_Ui { empty v1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aSf_Sf_Ul { empty v1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aSf_Sf_Us { empty v1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aSf_Sf_Vp { empty v1; empty v2; void * v3; };
struct __attribute__((packed)) aSf_Uc { empty v1; unsigned char v2; };
struct __attribute__((packed)) aSf_Uc_BFu15i { empty v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aSf_Uc_BFu15ll { empty v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_Uc_BFu15s { empty v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aSf_Uc_BFu16i { empty v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aSf_Uc_BFu16ll { empty v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_Uc_BFu16s { empty v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aSf_Uc_BFu17i { empty v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aSf_Uc_BFu17ll { empty v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_Uc_BFu1c { empty v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aSf_Uc_BFu1i { empty v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aSf_Uc_BFu1ll { empty v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_Uc_BFu1s { empty v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aSf_Uc_BFu31i { empty v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aSf_Uc_BFu31ll { empty v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_Uc_BFu32i { empty v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aSf_Uc_BFu32ll { empty v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_Uc_BFu33 { empty v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_Uc_BFu7c { empty v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aSf_Uc_BFu7i { empty v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aSf_Uc_BFu7ll { empty v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_Uc_BFu7s { empty v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aSf_Uc_BFu8c { empty v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aSf_Uc_BFu8i { empty v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aSf_Uc_BFu8ll { empty v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_Uc_BFu8s { empty v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aSf_Uc_BFu9i { empty v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aSf_Uc_BFu9ll { empty v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_Uc_BFu9s { empty v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aSf_Uc_C { empty v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aSf_Uc_D { empty v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aSf_Uc_F { empty v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aSf_Uc_I { empty v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aSf_Uc_Ip { empty v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aSf_Uc_L { empty v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aSf_Uc_S { empty v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aSf_Uc_Sf { empty v1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aSf_Uc_Uc { empty v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aSf_Uc_Ui { empty v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aSf_Uc_Ul { empty v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aSf_Uc_Us { empty v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aSf_Uc_Vp { empty v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aSf_Ui { empty v1; unsigned int v2; };
struct __attribute__((packed)) aSf_Ui_BFu15i { empty v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aSf_Ui_BFu15ll { empty v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_Ui_BFu15s { empty v1; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aSf_Ui_BFu16i { empty v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aSf_Ui_BFu16ll { empty v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_Ui_BFu16s { empty v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aSf_Ui_BFu17i { empty v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aSf_Ui_BFu17ll { empty v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_Ui_BFu1c { empty v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aSf_Ui_BFu1i { empty v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aSf_Ui_BFu1ll { empty v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_Ui_BFu1s { empty v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aSf_Ui_BFu31i { empty v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aSf_Ui_BFu31ll { empty v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_Ui_BFu32i { empty v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aSf_Ui_BFu32ll { empty v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_Ui_BFu33 { empty v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_Ui_BFu7c { empty v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aSf_Ui_BFu7i { empty v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aSf_Ui_BFu7ll { empty v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_Ui_BFu7s { empty v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aSf_Ui_BFu8c { empty v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aSf_Ui_BFu8i { empty v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aSf_Ui_BFu8ll { empty v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_Ui_BFu8s { empty v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aSf_Ui_BFu9i { empty v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aSf_Ui_BFu9ll { empty v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_Ui_BFu9s { empty v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aSf_Ui_C { empty v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aSf_Ui_D { empty v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aSf_Ui_F { empty v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aSf_Ui_I { empty v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aSf_Ui_Ip { empty v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aSf_Ui_L { empty v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aSf_Ui_S { empty v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aSf_Ui_Sf { empty v1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aSf_Ui_Uc { empty v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aSf_Ui_Ui { empty v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aSf_Ui_Ul { empty v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aSf_Ui_Us { empty v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aSf_Ui_Vp { empty v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aSf_Ul { empty v1; unsigned long long v2; };
struct __attribute__((packed)) aSf_Ul_BFu15i { empty v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aSf_Ul_BFu15ll { empty v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_Ul_BFu15s { empty v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aSf_Ul_BFu16i { empty v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aSf_Ul_BFu16ll { empty v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_Ul_BFu16s { empty v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aSf_Ul_BFu17i { empty v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aSf_Ul_BFu17ll { empty v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_Ul_BFu1c { empty v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aSf_Ul_BFu1i { empty v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aSf_Ul_BFu1ll { empty v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_Ul_BFu1s { empty v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aSf_Ul_BFu31i { empty v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aSf_Ul_BFu31ll { empty v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_Ul_BFu32i { empty v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aSf_Ul_BFu32ll { empty v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_Ul_BFu33 { empty v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_Ul_BFu7c { empty v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aSf_Ul_BFu7i { empty v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aSf_Ul_BFu7ll { empty v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_Ul_BFu7s { empty v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aSf_Ul_BFu8c { empty v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aSf_Ul_BFu8i { empty v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aSf_Ul_BFu8ll { empty v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_Ul_BFu8s { empty v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aSf_Ul_BFu9i { empty v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aSf_Ul_BFu9ll { empty v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_Ul_BFu9s { empty v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aSf_Ul_C { empty v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aSf_Ul_D { empty v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aSf_Ul_F { empty v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aSf_Ul_I { empty v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aSf_Ul_Ip { empty v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aSf_Ul_L { empty v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aSf_Ul_S { empty v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aSf_Ul_Sf { empty v1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aSf_Ul_Uc { empty v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aSf_Ul_Ui { empty v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aSf_Ul_Ul { empty v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aSf_Ul_Us { empty v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aSf_Ul_Vp { empty v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aSf_Us { empty v1; unsigned short v2; };
struct __attribute__((packed)) aSf_Us_BFu15i { empty v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aSf_Us_BFu15ll { empty v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_Us_BFu15s { empty v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aSf_Us_BFu16i { empty v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aSf_Us_BFu16ll { empty v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_Us_BFu16s { empty v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aSf_Us_BFu17i { empty v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aSf_Us_BFu17ll { empty v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_Us_BFu1c { empty v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aSf_Us_BFu1i { empty v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aSf_Us_BFu1ll { empty v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_Us_BFu1s { empty v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aSf_Us_BFu31i { empty v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aSf_Us_BFu31ll { empty v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_Us_BFu32i { empty v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aSf_Us_BFu32ll { empty v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_Us_BFu33 { empty v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_Us_BFu7c { empty v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aSf_Us_BFu7i { empty v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aSf_Us_BFu7ll { empty v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_Us_BFu7s { empty v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aSf_Us_BFu8c { empty v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aSf_Us_BFu8i { empty v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aSf_Us_BFu8ll { empty v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_Us_BFu8s { empty v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aSf_Us_BFu9i { empty v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aSf_Us_BFu9ll { empty v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_Us_BFu9s { empty v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aSf_Us_C { empty v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aSf_Us_D { empty v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aSf_Us_F { empty v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aSf_Us_I { empty v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aSf_Us_Ip { empty v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aSf_Us_L { empty v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aSf_Us_S { empty v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aSf_Us_Sf { empty v1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aSf_Us_Uc { empty v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aSf_Us_Ui { empty v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aSf_Us_Ul { empty v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aSf_Us_Us { empty v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aSf_Us_Vp { empty v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aSf_Vp { empty v1; void * v2; };
struct __attribute__((packed)) aSf_Vp_BFu15i { empty v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aSf_Vp_BFu15ll { empty v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_Vp_BFu15s { empty v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aSf_Vp_BFu16i { empty v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aSf_Vp_BFu16ll { empty v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_Vp_BFu16s { empty v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aSf_Vp_BFu17i { empty v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aSf_Vp_BFu17ll { empty v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_Vp_BFu1c { empty v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aSf_Vp_BFu1i { empty v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aSf_Vp_BFu1ll { empty v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_Vp_BFu1s { empty v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aSf_Vp_BFu31i { empty v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aSf_Vp_BFu31ll { empty v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_Vp_BFu32i { empty v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aSf_Vp_BFu32ll { empty v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_Vp_BFu33 { empty v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_Vp_BFu7c { empty v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aSf_Vp_BFu7i { empty v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aSf_Vp_BFu7ll { empty v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_Vp_BFu7s { empty v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aSf_Vp_BFu8c { empty v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aSf_Vp_BFu8i { empty v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aSf_Vp_BFu8ll { empty v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_Vp_BFu8s { empty v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aSf_Vp_BFu9i { empty v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aSf_Vp_BFu9ll { empty v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_Vp_BFu9s { empty v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aSf_Vp_C { empty v1; void * v2; char v3; };
struct __attribute__((packed)) aSf_Vp_D { empty v1; void * v2; double v3; };
struct __attribute__((packed)) aSf_Vp_F { empty v1; void * v2; float v3; };
struct __attribute__((packed)) aSf_Vp_I { empty v1; void * v2; int v3; };
struct __attribute__((packed)) aSf_Vp_Ip { empty v1; void * v2; int * v3; };
struct __attribute__((packed)) aSf_Vp_L { empty v1; void * v2; long long v3; };
struct __attribute__((packed)) aSf_Vp_S { empty v1; void * v2; short v3; };
struct __attribute__((packed)) aSf_Vp_Sf { empty v1; void * v2; empty v3; };
struct __attribute__((packed)) aSf_Vp_Uc { empty v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aSf_Vp_Ui { empty v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aSf_Vp_Ul { empty v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aSf_Vp_Us { empty v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aSf_Vp_Vp { empty v1; void * v2; void * v3; };
struct __attribute__((packed)) aUc_BFu15i_Sf { unsigned char v1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aUc_BFu15ll_Sf { unsigned char v1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aUc_BFu15s_Sf { unsigned char v1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aUc_BFu16i_Sf { unsigned char v1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aUc_BFu16ll_Sf { unsigned char v1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aUc_BFu16s_Sf { unsigned char v1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aUc_BFu17i_Sf { unsigned char v1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aUc_BFu17ll_Sf { unsigned char v1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aUc_BFu1c_Sf { unsigned char v1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aUc_BFu1i_Sf { unsigned char v1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aUc_BFu1ll_Sf { unsigned char v1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aUc_BFu1s_Sf { unsigned char v1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aUc_BFu31i_Sf { unsigned char v1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aUc_BFu31ll_Sf { unsigned char v1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aUc_BFu32i_Sf { unsigned char v1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aUc_BFu32ll_Sf { unsigned char v1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aUc_BFu33_Sf { unsigned char v1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aUc_BFu7c_Sf { unsigned char v1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aUc_BFu7i_Sf { unsigned char v1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aUc_BFu7ll_Sf { unsigned char v1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aUc_BFu7s_Sf { unsigned char v1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aUc_BFu8c_Sf { unsigned char v1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aUc_BFu8i_Sf { unsigned char v1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aUc_BFu8ll_Sf { unsigned char v1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aUc_BFu8s_Sf { unsigned char v1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aUc_BFu9i_Sf { unsigned char v1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aUc_BFu9ll_Sf { unsigned char v1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aUc_BFu9s_Sf { unsigned char v1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aUc_C_Sf { unsigned char v1; char v2; empty v3; };
struct __attribute__((packed)) aUc_D_Sf { unsigned char v1; double v2; empty v3; };
struct __attribute__((packed)) aUc_F_Sf { unsigned char v1; float v2; empty v3; };
struct __attribute__((packed)) aUc_I_Sf { unsigned char v1; int v2; empty v3; };
struct __attribute__((packed)) aUc_Ip_Sf { unsigned char v1; int * v2; empty v3; };
struct __attribute__((packed)) aUc_L_Sf { unsigned char v1; long long v2; empty v3; };
struct __attribute__((packed)) aUc_S_Sf { unsigned char v1; short v2; empty v3; };
struct __attribute__((packed)) aUc_Sf { unsigned char v1; empty v2; };
struct __attribute__((packed)) aUc_Sf_BFu15i { unsigned char v1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_Sf_BFu15ll { unsigned char v1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_Sf_BFu15s { unsigned char v1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_Sf_BFu16i { unsigned char v1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_Sf_BFu16ll { unsigned char v1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_Sf_BFu16s { unsigned char v1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_Sf_BFu17i { unsigned char v1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_Sf_BFu17ll { unsigned char v1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_Sf_BFu1c { unsigned char v1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_Sf_BFu1i { unsigned char v1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_Sf_BFu1ll { unsigned char v1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_Sf_BFu1s { unsigned char v1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_Sf_BFu31i { unsigned char v1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_Sf_BFu31ll { unsigned char v1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_Sf_BFu32i { unsigned char v1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_Sf_BFu32ll { unsigned char v1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_Sf_BFu33 { unsigned char v1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_Sf_BFu7c { unsigned char v1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_Sf_BFu7i { unsigned char v1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_Sf_BFu7ll { unsigned char v1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_Sf_BFu7s { unsigned char v1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_Sf_BFu8c { unsigned char v1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_Sf_BFu8i { unsigned char v1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_Sf_BFu8ll { unsigned char v1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_Sf_BFu8s { unsigned char v1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_Sf_BFu9i { unsigned char v1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_Sf_BFu9ll { unsigned char v1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_Sf_BFu9s { unsigned char v1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_Sf_C { unsigned char v1; empty v2; char v3; };
struct __attribute__((packed)) aUc_Sf_D { unsigned char v1; empty v2; double v3; };
struct __attribute__((packed)) aUc_Sf_F { unsigned char v1; empty v2; float v3; };
struct __attribute__((packed)) aUc_Sf_I { unsigned char v1; empty v2; int v3; };
struct __attribute__((packed)) aUc_Sf_Ip { unsigned char v1; empty v2; int * v3; };
struct __attribute__((packed)) aUc_Sf_L { unsigned char v1; empty v2; long long v3; };
struct __attribute__((packed)) aUc_Sf_S { unsigned char v1; empty v2; short v3; };
struct __attribute__((packed)) aUc_Sf_Sf { unsigned char v1; empty v2; empty v3; };
struct __attribute__((packed)) aUc_Sf_Uc { unsigned char v1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aUc_Sf_Ui { unsigned char v1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aUc_Sf_Ul { unsigned char v1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_Sf_Us { unsigned char v1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aUc_Sf_Vp { unsigned char v1; empty v2; void * v3; };
struct __attribute__((packed)) aUc_Uc_Sf { unsigned char v1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aUc_Ui_Sf { unsigned char v1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aUc_Ul_Sf { unsigned char v1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aUc_Us_Sf { unsigned char v1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aUc_Vp_Sf { unsigned char v1; void * v2; empty v3; };
struct __attribute__((packed)) aUi_BFu15i_Sf { unsigned int v1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aUi_BFu15ll_Sf { unsigned int v1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aUi_BFu15s_Sf { unsigned int v1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aUi_BFu16i_Sf { unsigned int v1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aUi_BFu16ll_Sf { unsigned int v1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aUi_BFu16s_Sf { unsigned int v1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aUi_BFu17i_Sf { unsigned int v1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aUi_BFu17ll_Sf { unsigned int v1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aUi_BFu1c_Sf { unsigned int v1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aUi_BFu1i_Sf { unsigned int v1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aUi_BFu1ll_Sf { unsigned int v1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aUi_BFu1s_Sf { unsigned int v1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aUi_BFu31i_Sf { unsigned int v1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aUi_BFu31ll_Sf { unsigned int v1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aUi_BFu32i_Sf { unsigned int v1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aUi_BFu32ll_Sf { unsigned int v1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aUi_BFu33_Sf { unsigned int v1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aUi_BFu7c_Sf { unsigned int v1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aUi_BFu7i_Sf { unsigned int v1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aUi_BFu7ll_Sf { unsigned int v1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aUi_BFu7s_Sf { unsigned int v1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aUi_BFu8c_Sf { unsigned int v1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aUi_BFu8i_Sf { unsigned int v1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aUi_BFu8ll_Sf { unsigned int v1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aUi_BFu8s_Sf { unsigned int v1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aUi_BFu9i_Sf { unsigned int v1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aUi_BFu9ll_Sf { unsigned int v1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aUi_BFu9s_Sf { unsigned int v1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aUi_C_Sf { unsigned int v1; char v2; empty v3; };
struct __attribute__((packed)) aUi_D_Sf { unsigned int v1; double v2; empty v3; };
struct __attribute__((packed)) aUi_F_Sf { unsigned int v1; float v2; empty v3; };
struct __attribute__((packed)) aUi_I_Sf { unsigned int v1; int v2; empty v3; };
struct __attribute__((packed)) aUi_Ip_Sf { unsigned int v1; int * v2; empty v3; };
struct __attribute__((packed)) aUi_L_Sf { unsigned int v1; long long v2; empty v3; };
struct __attribute__((packed)) aUi_S_Sf { unsigned int v1; short v2; empty v3; };
struct __attribute__((packed)) aUi_Sf { unsigned int v1; empty v2; };
struct __attribute__((packed)) aUi_Sf_BFu15i { unsigned int v1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_Sf_BFu15ll { unsigned int v1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_Sf_BFu15s { unsigned int v1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_Sf_BFu16i { unsigned int v1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_Sf_BFu16ll { unsigned int v1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_Sf_BFu16s { unsigned int v1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_Sf_BFu17i { unsigned int v1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_Sf_BFu17ll { unsigned int v1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_Sf_BFu1c { unsigned int v1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_Sf_BFu1i { unsigned int v1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_Sf_BFu1ll { unsigned int v1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_Sf_BFu1s { unsigned int v1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_Sf_BFu31i { unsigned int v1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_Sf_BFu31ll { unsigned int v1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_Sf_BFu32i { unsigned int v1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_Sf_BFu32ll { unsigned int v1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_Sf_BFu33 { unsigned int v1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_Sf_BFu7c { unsigned int v1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_Sf_BFu7i { unsigned int v1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_Sf_BFu7ll { unsigned int v1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_Sf_BFu7s { unsigned int v1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_Sf_BFu8c { unsigned int v1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_Sf_BFu8i { unsigned int v1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_Sf_BFu8ll { unsigned int v1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_Sf_BFu8s { unsigned int v1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_Sf_BFu9i { unsigned int v1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_Sf_BFu9ll { unsigned int v1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_Sf_BFu9s { unsigned int v1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_Sf_C { unsigned int v1; empty v2; char v3; };
struct __attribute__((packed)) aUi_Sf_D { unsigned int v1; empty v2; double v3; };
struct __attribute__((packed)) aUi_Sf_F { unsigned int v1; empty v2; float v3; };
struct __attribute__((packed)) aUi_Sf_I { unsigned int v1; empty v2; int v3; };
struct __attribute__((packed)) aUi_Sf_Ip { unsigned int v1; empty v2; int * v3; };
struct __attribute__((packed)) aUi_Sf_L { unsigned int v1; empty v2; long long v3; };
struct __attribute__((packed)) aUi_Sf_S { unsigned int v1; empty v2; short v3; };
struct __attribute__((packed)) aUi_Sf_Sf { unsigned int v1; empty v2; empty v3; };
struct __attribute__((packed)) aUi_Sf_Uc { unsigned int v1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aUi_Sf_Ui { unsigned int v1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aUi_Sf_Ul { unsigned int v1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_Sf_Us { unsigned int v1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aUi_Sf_Vp { unsigned int v1; empty v2; void * v3; };
struct __attribute__((packed)) aUi_Uc_Sf { unsigned int v1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aUi_Ui_Sf { unsigned int v1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aUi_Ul_Sf { unsigned int v1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aUi_Us_Sf { unsigned int v1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aUi_Vp_Sf { unsigned int v1; void * v2; empty v3; };
struct __attribute__((packed)) aUl_BFu15i_Sf { unsigned long long v1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aUl_BFu15ll_Sf { unsigned long long v1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aUl_BFu15s_Sf { unsigned long long v1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aUl_BFu16i_Sf { unsigned long long v1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aUl_BFu16ll_Sf { unsigned long long v1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aUl_BFu16s_Sf { unsigned long long v1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aUl_BFu17i_Sf { unsigned long long v1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aUl_BFu17ll_Sf { unsigned long long v1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aUl_BFu1c_Sf { unsigned long long v1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aUl_BFu1i_Sf { unsigned long long v1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aUl_BFu1ll_Sf { unsigned long long v1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aUl_BFu1s_Sf { unsigned long long v1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aUl_BFu31i_Sf { unsigned long long v1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aUl_BFu31ll_Sf { unsigned long long v1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aUl_BFu32i_Sf { unsigned long long v1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aUl_BFu32ll_Sf { unsigned long long v1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aUl_BFu33_Sf { unsigned long long v1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aUl_BFu7c_Sf { unsigned long long v1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aUl_BFu7i_Sf { unsigned long long v1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aUl_BFu7ll_Sf { unsigned long long v1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aUl_BFu7s_Sf { unsigned long long v1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aUl_BFu8c_Sf { unsigned long long v1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aUl_BFu8i_Sf { unsigned long long v1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aUl_BFu8ll_Sf { unsigned long long v1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aUl_BFu8s_Sf { unsigned long long v1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aUl_BFu9i_Sf { unsigned long long v1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aUl_BFu9ll_Sf { unsigned long long v1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aUl_BFu9s_Sf { unsigned long long v1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aUl_C_Sf { unsigned long long v1; char v2; empty v3; };
struct __attribute__((packed)) aUl_D_Sf { unsigned long long v1; double v2; empty v3; };
struct __attribute__((packed)) aUl_F_Sf { unsigned long long v1; float v2; empty v3; };
struct __attribute__((packed)) aUl_I_Sf { unsigned long long v1; int v2; empty v3; };
struct __attribute__((packed)) aUl_Ip_Sf { unsigned long long v1; int * v2; empty v3; };
struct __attribute__((packed)) aUl_L_Sf { unsigned long long v1; long long v2; empty v3; };
struct __attribute__((packed)) aUl_S_Sf { unsigned long long v1; short v2; empty v3; };
struct __attribute__((packed)) aUl_Sf { unsigned long long v1; empty v2; };
struct __attribute__((packed)) aUl_Sf_BFu15i { unsigned long long v1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_Sf_BFu15ll { unsigned long long v1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_Sf_BFu15s { unsigned long long v1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_Sf_BFu16i { unsigned long long v1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_Sf_BFu16ll { unsigned long long v1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_Sf_BFu16s { unsigned long long v1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_Sf_BFu17i { unsigned long long v1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_Sf_BFu17ll { unsigned long long v1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_Sf_BFu1c { unsigned long long v1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_Sf_BFu1i { unsigned long long v1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_Sf_BFu1ll { unsigned long long v1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_Sf_BFu1s { unsigned long long v1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_Sf_BFu31i { unsigned long long v1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_Sf_BFu31ll { unsigned long long v1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_Sf_BFu32i { unsigned long long v1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_Sf_BFu32ll { unsigned long long v1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_Sf_BFu33 { unsigned long long v1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_Sf_BFu7c { unsigned long long v1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_Sf_BFu7i { unsigned long long v1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_Sf_BFu7ll { unsigned long long v1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_Sf_BFu7s { unsigned long long v1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_Sf_BFu8c { unsigned long long v1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_Sf_BFu8i { unsigned long long v1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_Sf_BFu8ll { unsigned long long v1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_Sf_BFu8s { unsigned long long v1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_Sf_BFu9i { unsigned long long v1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_Sf_BFu9ll { unsigned long long v1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_Sf_BFu9s { unsigned long long v1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_Sf_C { unsigned long long v1; empty v2; char v3; };
struct __attribute__((packed)) aUl_Sf_D { unsigned long long v1; empty v2; double v3; };
struct __attribute__((packed)) aUl_Sf_F { unsigned long long v1; empty v2; float v3; };
struct __attribute__((packed)) aUl_Sf_I { unsigned long long v1; empty v2; int v3; };
struct __attribute__((packed)) aUl_Sf_Ip { unsigned long long v1; empty v2; int * v3; };
struct __attribute__((packed)) aUl_Sf_L { unsigned long long v1; empty v2; long long v3; };
struct __attribute__((packed)) aUl_Sf_S { unsigned long long v1; empty v2; short v3; };
struct __attribute__((packed)) aUl_Sf_Sf { unsigned long long v1; empty v2; empty v3; };
struct __attribute__((packed)) aUl_Sf_Uc { unsigned long long v1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aUl_Sf_Ui { unsigned long long v1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aUl_Sf_Ul { unsigned long long v1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_Sf_Us { unsigned long long v1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aUl_Sf_Vp { unsigned long long v1; empty v2; void * v3; };
struct __attribute__((packed)) aUl_Uc_Sf { unsigned long long v1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aUl_Ui_Sf { unsigned long long v1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aUl_Ul_Sf { unsigned long long v1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aUl_Us_Sf { unsigned long long v1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aUl_Vp_Sf { unsigned long long v1; void * v2; empty v3; };
struct __attribute__((packed)) aUs_BFu15i_Sf { unsigned short v1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aUs_BFu15ll_Sf { unsigned short v1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aUs_BFu15s_Sf { unsigned short v1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aUs_BFu16i_Sf { unsigned short v1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aUs_BFu16ll_Sf { unsigned short v1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aUs_BFu16s_Sf { unsigned short v1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aUs_BFu17i_Sf { unsigned short v1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aUs_BFu17ll_Sf { unsigned short v1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aUs_BFu1c_Sf { unsigned short v1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aUs_BFu1i_Sf { unsigned short v1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aUs_BFu1ll_Sf { unsigned short v1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aUs_BFu1s_Sf { unsigned short v1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aUs_BFu31i_Sf { unsigned short v1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aUs_BFu31ll_Sf { unsigned short v1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aUs_BFu32i_Sf { unsigned short v1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aUs_BFu32ll_Sf { unsigned short v1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aUs_BFu33_Sf { unsigned short v1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aUs_BFu7c_Sf { unsigned short v1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aUs_BFu7i_Sf { unsigned short v1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aUs_BFu7ll_Sf { unsigned short v1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aUs_BFu7s_Sf { unsigned short v1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aUs_BFu8c_Sf { unsigned short v1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aUs_BFu8i_Sf { unsigned short v1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aUs_BFu8ll_Sf { unsigned short v1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aUs_BFu8s_Sf { unsigned short v1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aUs_BFu9i_Sf { unsigned short v1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aUs_BFu9ll_Sf { unsigned short v1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aUs_BFu9s_Sf { unsigned short v1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aUs_C_Sf { unsigned short v1; char v2; empty v3; };
struct __attribute__((packed)) aUs_D_Sf { unsigned short v1; double v2; empty v3; };
struct __attribute__((packed)) aUs_F_Sf { unsigned short v1; float v2; empty v3; };
struct __attribute__((packed)) aUs_I_Sf { unsigned short v1; int v2; empty v3; };
struct __attribute__((packed)) aUs_Ip_Sf { unsigned short v1; int * v2; empty v3; };
struct __attribute__((packed)) aUs_L_Sf { unsigned short v1; long long v2; empty v3; };
struct __attribute__((packed)) aUs_S_Sf { unsigned short v1; short v2; empty v3; };
struct __attribute__((packed)) aUs_Sf { unsigned short v1; empty v2; };
struct __attribute__((packed)) aUs_Sf_BFu15i { unsigned short v1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_Sf_BFu15ll { unsigned short v1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_Sf_BFu15s { unsigned short v1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_Sf_BFu16i { unsigned short v1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_Sf_BFu16ll { unsigned short v1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_Sf_BFu16s { unsigned short v1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_Sf_BFu17i { unsigned short v1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_Sf_BFu17ll { unsigned short v1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_Sf_BFu1c { unsigned short v1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_Sf_BFu1i { unsigned short v1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_Sf_BFu1ll { unsigned short v1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_Sf_BFu1s { unsigned short v1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_Sf_BFu31i { unsigned short v1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_Sf_BFu31ll { unsigned short v1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_Sf_BFu32i { unsigned short v1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_Sf_BFu32ll { unsigned short v1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_Sf_BFu33 { unsigned short v1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_Sf_BFu7c { unsigned short v1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_Sf_BFu7i { unsigned short v1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_Sf_BFu7ll { unsigned short v1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_Sf_BFu7s { unsigned short v1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_Sf_BFu8c { unsigned short v1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_Sf_BFu8i { unsigned short v1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_Sf_BFu8ll { unsigned short v1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_Sf_BFu8s { unsigned short v1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_Sf_BFu9i { unsigned short v1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_Sf_BFu9ll { unsigned short v1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_Sf_BFu9s { unsigned short v1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_Sf_C { unsigned short v1; empty v2; char v3; };
struct __attribute__((packed)) aUs_Sf_D { unsigned short v1; empty v2; double v3; };
struct __attribute__((packed)) aUs_Sf_F { unsigned short v1; empty v2; float v3; };
struct __attribute__((packed)) aUs_Sf_I { unsigned short v1; empty v2; int v3; };
struct __attribute__((packed)) aUs_Sf_Ip { unsigned short v1; empty v2; int * v3; };
struct __attribute__((packed)) aUs_Sf_L { unsigned short v1; empty v2; long long v3; };
struct __attribute__((packed)) aUs_Sf_S { unsigned short v1; empty v2; short v3; };
struct __attribute__((packed)) aUs_Sf_Sf { unsigned short v1; empty v2; empty v3; };
struct __attribute__((packed)) aUs_Sf_Uc { unsigned short v1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aUs_Sf_Ui { unsigned short v1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aUs_Sf_Ul { unsigned short v1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_Sf_Us { unsigned short v1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aUs_Sf_Vp { unsigned short v1; empty v2; void * v3; };
struct __attribute__((packed)) aUs_Uc_Sf { unsigned short v1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aUs_Ui_Sf { unsigned short v1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aUs_Ul_Sf { unsigned short v1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aUs_Us_Sf { unsigned short v1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aUs_Vp_Sf { unsigned short v1; void * v2; empty v3; };
struct __attribute__((packed)) aVp_BFu15i_Sf { void * v1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aVp_BFu15ll_Sf { void * v1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aVp_BFu15s_Sf { void * v1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aVp_BFu16i_Sf { void * v1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aVp_BFu16ll_Sf { void * v1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aVp_BFu16s_Sf { void * v1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aVp_BFu17i_Sf { void * v1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aVp_BFu17ll_Sf { void * v1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aVp_BFu1c_Sf { void * v1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aVp_BFu1i_Sf { void * v1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aVp_BFu1ll_Sf { void * v1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aVp_BFu1s_Sf { void * v1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aVp_BFu31i_Sf { void * v1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aVp_BFu31ll_Sf { void * v1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aVp_BFu32i_Sf { void * v1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aVp_BFu32ll_Sf { void * v1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aVp_BFu33_Sf { void * v1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aVp_BFu7c_Sf { void * v1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aVp_BFu7i_Sf { void * v1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aVp_BFu7ll_Sf { void * v1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aVp_BFu7s_Sf { void * v1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aVp_BFu8c_Sf { void * v1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aVp_BFu8i_Sf { void * v1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aVp_BFu8ll_Sf { void * v1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aVp_BFu8s_Sf { void * v1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aVp_BFu9i_Sf { void * v1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aVp_BFu9ll_Sf { void * v1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aVp_BFu9s_Sf { void * v1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aVp_C_Sf { void * v1; char v2; empty v3; };
struct __attribute__((packed)) aVp_D_Sf { void * v1; double v2; empty v3; };
struct __attribute__((packed)) aVp_F_Sf { void * v1; float v2; empty v3; };
struct __attribute__((packed)) aVp_I_Sf { void * v1; int v2; empty v3; };
struct __attribute__((packed)) aVp_Ip_Sf { void * v1; int * v2; empty v3; };
struct __attribute__((packed)) aVp_L_Sf { void * v1; long long v2; empty v3; };
struct __attribute__((packed)) aVp_S_Sf { void * v1; short v2; empty v3; };
struct __attribute__((packed)) aVp_Sf { void * v1; empty v2; };
struct __attribute__((packed)) aVp_Sf_BFu15i { void * v1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_Sf_BFu15ll { void * v1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_Sf_BFu15s { void * v1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_Sf_BFu16i { void * v1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_Sf_BFu16ll { void * v1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_Sf_BFu16s { void * v1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_Sf_BFu17i { void * v1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_Sf_BFu17ll { void * v1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_Sf_BFu1c { void * v1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_Sf_BFu1i { void * v1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_Sf_BFu1ll { void * v1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_Sf_BFu1s { void * v1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_Sf_BFu31i { void * v1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_Sf_BFu31ll { void * v1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_Sf_BFu32i { void * v1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_Sf_BFu32ll { void * v1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_Sf_BFu33 { void * v1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_Sf_BFu7c { void * v1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_Sf_BFu7i { void * v1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_Sf_BFu7ll { void * v1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_Sf_BFu7s { void * v1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_Sf_BFu8c { void * v1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_Sf_BFu8i { void * v1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_Sf_BFu8ll { void * v1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_Sf_BFu8s { void * v1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_Sf_BFu9i { void * v1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_Sf_BFu9ll { void * v1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_Sf_BFu9s { void * v1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_Sf_C { void * v1; empty v2; char v3; };
struct __attribute__((packed)) aVp_Sf_D { void * v1; empty v2; double v3; };
struct __attribute__((packed)) aVp_Sf_F { void * v1; empty v2; float v3; };
struct __attribute__((packed)) aVp_Sf_I { void * v1; empty v2; int v3; };
struct __attribute__((packed)) aVp_Sf_Ip { void * v1; empty v2; int * v3; };
struct __attribute__((packed)) aVp_Sf_L { void * v1; empty v2; long long v3; };
struct __attribute__((packed)) aVp_Sf_S { void * v1; empty v2; short v3; };
struct __attribute__((packed)) aVp_Sf_Sf { void * v1; empty v2; empty v3; };
struct __attribute__((packed)) aVp_Sf_Uc { void * v1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aVp_Sf_Ui { void * v1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aVp_Sf_Ul { void * v1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_Sf_Us { void * v1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aVp_Sf_Vp { void * v1; empty v2; void * v3; };
struct __attribute__((packed)) aVp_Uc_Sf { void * v1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aVp_Ui_Sf { void * v1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aVp_Ul_Sf { void * v1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aVp_Us_Sf { void * v1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aVp_Vp_Sf { void * v1; void * v2; empty v3; };
#pragma pack(1)
struct BFu15i_BFu15i_Sf { unsigned int v1:15; unsigned int v2:15; empty v3; };
struct BFu15i_BFu15ll_Sf { unsigned int v1:15; unsigned long long v2:15; empty v3; };
struct BFu15i_BFu15s_Sf { unsigned int v1:15; unsigned short v2:15; empty v3; };
struct BFu15i_BFu16i_Sf { unsigned int v1:15; unsigned int v2:16; empty v3; };
struct BFu15i_BFu16ll_Sf { unsigned int v1:15; unsigned long long v2:16; empty v3; };
struct BFu15i_BFu16s_Sf { unsigned int v1:15; unsigned short v2:16; empty v3; };
struct BFu15i_BFu17i_Sf { unsigned int v1:15; unsigned int v2:17; empty v3; };
struct BFu15i_BFu17ll_Sf { unsigned int v1:15; unsigned long long v2:17; empty v3; };
struct BFu15i_BFu1c_Sf { unsigned int v1:15; unsigned char v2:1; empty v3; };
struct BFu15i_BFu1i_Sf { unsigned int v1:15; unsigned int v2:1; empty v3; };
struct BFu15i_BFu1ll_Sf { unsigned int v1:15; unsigned long long v2:1; empty v3; };
struct BFu15i_BFu1s_Sf { unsigned int v1:15; unsigned short v2:1; empty v3; };
struct BFu15i_BFu31i_Sf { unsigned int v1:15; unsigned int v2:31; empty v3; };
struct BFu15i_BFu31ll_Sf { unsigned int v1:15; unsigned long long v2:31; empty v3; };
struct BFu15i_BFu32i_Sf { unsigned int v1:15; unsigned int v2:32; empty v3; };
struct BFu15i_BFu32ll_Sf { unsigned int v1:15; unsigned long long v2:32; empty v3; };
struct BFu15i_BFu33_Sf { unsigned int v1:15; unsigned long long v2:33; empty v3; };
struct BFu15i_BFu7c_Sf { unsigned int v1:15; unsigned char v2:7; empty v3; };
struct BFu15i_BFu7i_Sf { unsigned int v1:15; unsigned int v2:7; empty v3; };
struct BFu15i_BFu7ll_Sf { unsigned int v1:15; unsigned long long v2:7; empty v3; };
struct BFu15i_BFu7s_Sf { unsigned int v1:15; unsigned short v2:7; empty v3; };
struct BFu15i_BFu8c_Sf { unsigned int v1:15; unsigned char v2:8; empty v3; };
struct BFu15i_BFu8i_Sf { unsigned int v1:15; unsigned int v2:8; empty v3; };
struct BFu15i_BFu8ll_Sf { unsigned int v1:15; unsigned long long v2:8; empty v3; };
struct BFu15i_BFu8s_Sf { unsigned int v1:15; unsigned short v2:8; empty v3; };
struct BFu15i_BFu9i_Sf { unsigned int v1:15; unsigned int v2:9; empty v3; };
struct BFu15i_BFu9ll_Sf { unsigned int v1:15; unsigned long long v2:9; empty v3; };
struct BFu15i_BFu9s_Sf { unsigned int v1:15; unsigned short v2:9; empty v3; };
struct BFu15i_C_Sf { unsigned int v1:15; char v2; empty v3; };
struct BFu15i_D_Sf { unsigned int v1:15; double v2; empty v3; };
struct BFu15i_F_Sf { unsigned int v1:15; float v2; empty v3; };
struct BFu15i_I_Sf { unsigned int v1:15; int v2; empty v3; };
struct BFu15i_Ip_Sf { unsigned int v1:15; int * v2; empty v3; };
struct BFu15i_L_Sf { unsigned int v1:15; long long v2; empty v3; };
struct BFu15i_S_Sf { unsigned int v1:15; short v2; empty v3; };
struct BFu15i_Sf { unsigned int v1:15; empty v2; };
struct BFu15i_Sf_BFu15i { unsigned int v1:15; empty v2; unsigned int v3:15; };
struct BFu15i_Sf_BFu15ll { unsigned int v1:15; empty v2; unsigned long long v3:15; };
struct BFu15i_Sf_BFu15s { unsigned int v1:15; empty v2; unsigned short v3:15; };
struct BFu15i_Sf_BFu16i { unsigned int v1:15; empty v2; unsigned int v3:16; };
struct BFu15i_Sf_BFu16ll { unsigned int v1:15; empty v2; unsigned long long v3:16; };
struct BFu15i_Sf_BFu16s { unsigned int v1:15; empty v2; unsigned short v3:16; };
struct BFu15i_Sf_BFu17i { unsigned int v1:15; empty v2; unsigned int v3:17; };
struct BFu15i_Sf_BFu17ll { unsigned int v1:15; empty v2; unsigned long long v3:17; };
struct BFu15i_Sf_BFu1c { unsigned int v1:15; empty v2; unsigned char v3:1; };
struct BFu15i_Sf_BFu1i { unsigned int v1:15; empty v2; unsigned int v3:1; };
struct BFu15i_Sf_BFu1ll { unsigned int v1:15; empty v2; unsigned long long v3:1; };
struct BFu15i_Sf_BFu1s { unsigned int v1:15; empty v2; unsigned short v3:1; };
struct BFu15i_Sf_BFu31i { unsigned int v1:15; empty v2; unsigned int v3:31; };
struct BFu15i_Sf_BFu31ll { unsigned int v1:15; empty v2; unsigned long long v3:31; };
struct BFu15i_Sf_BFu32i { unsigned int v1:15; empty v2; unsigned int v3:32; };
struct BFu15i_Sf_BFu32ll { unsigned int v1:15; empty v2; unsigned long long v3:32; };
struct BFu15i_Sf_BFu33 { unsigned int v1:15; empty v2; unsigned long long v3:33; };
struct BFu15i_Sf_BFu7c { unsigned int v1:15; empty v2; unsigned char v3:7; };
struct BFu15i_Sf_BFu7i { unsigned int v1:15; empty v2; unsigned int v3:7; };
struct BFu15i_Sf_BFu7ll { unsigned int v1:15; empty v2; unsigned long long v3:7; };
struct BFu15i_Sf_BFu7s { unsigned int v1:15; empty v2; unsigned short v3:7; };
struct BFu15i_Sf_BFu8c { unsigned int v1:15; empty v2; unsigned char v3:8; };
struct BFu15i_Sf_BFu8i { unsigned int v1:15; empty v2; unsigned int v3:8; };
struct BFu15i_Sf_BFu8ll { unsigned int v1:15; empty v2; unsigned long long v3:8; };
struct BFu15i_Sf_BFu8s { unsigned int v1:15; empty v2; unsigned short v3:8; };
struct BFu15i_Sf_BFu9i { unsigned int v1:15; empty v2; unsigned int v3:9; };
struct BFu15i_Sf_BFu9ll { unsigned int v1:15; empty v2; unsigned long long v3:9; };
struct BFu15i_Sf_BFu9s { unsigned int v1:15; empty v2; unsigned short v3:9; };
struct BFu15i_Sf_C { unsigned int v1:15; empty v2; char v3; };
struct BFu15i_Sf_D { unsigned int v1:15; empty v2; double v3; };
struct BFu15i_Sf_F { unsigned int v1:15; empty v2; float v3; };
struct BFu15i_Sf_I { unsigned int v1:15; empty v2; int v3; };
struct BFu15i_Sf_Ip { unsigned int v1:15; empty v2; int * v3; };
struct BFu15i_Sf_L { unsigned int v1:15; empty v2; long long v3; };
struct BFu15i_Sf_S { unsigned int v1:15; empty v2; short v3; };
struct BFu15i_Sf_Sf { unsigned int v1:15; empty v2; empty v3; };
struct BFu15i_Sf_Uc { unsigned int v1:15; empty v2; unsigned char v3; };
struct BFu15i_Sf_Ui { unsigned int v1:15; empty v2; unsigned int v3; };
struct BFu15i_Sf_Ul { unsigned int v1:15; empty v2; unsigned long long v3; };
struct BFu15i_Sf_Us { unsigned int v1:15; empty v2; unsigned short v3; };
struct BFu15i_Sf_Vp { unsigned int v1:15; empty v2; void * v3; };
struct BFu15i_Uc_Sf { unsigned int v1:15; unsigned char v2; empty v3; };
struct BFu15i_Ui_Sf { unsigned int v1:15; unsigned int v2; empty v3; };
struct BFu15i_Ul_Sf { unsigned int v1:15; unsigned long long v2; empty v3; };
struct BFu15i_Us_Sf { unsigned int v1:15; unsigned short v2; empty v3; };
struct BFu15i_Vp_Sf { unsigned int v1:15; void * v2; empty v3; };
struct BFu15ll_BFu15i_Sf { unsigned long long v1:15; unsigned int v2:15; empty v3; };
struct BFu15ll_BFu15ll_Sf { unsigned long long v1:15; unsigned long long v2:15; empty v3; };
struct BFu15ll_BFu15s_Sf { unsigned long long v1:15; unsigned short v2:15; empty v3; };
struct BFu15ll_BFu16i_Sf { unsigned long long v1:15; unsigned int v2:16; empty v3; };
struct BFu15ll_BFu16ll_Sf { unsigned long long v1:15; unsigned long long v2:16; empty v3; };
struct BFu15ll_BFu16s_Sf { unsigned long long v1:15; unsigned short v2:16; empty v3; };
struct BFu15ll_BFu17i_Sf { unsigned long long v1:15; unsigned int v2:17; empty v3; };
struct BFu15ll_BFu17ll_Sf { unsigned long long v1:15; unsigned long long v2:17; empty v3; };
struct BFu15ll_BFu1c_Sf { unsigned long long v1:15; unsigned char v2:1; empty v3; };
struct BFu15ll_BFu1i_Sf { unsigned long long v1:15; unsigned int v2:1; empty v3; };
struct BFu15ll_BFu1ll_Sf { unsigned long long v1:15; unsigned long long v2:1; empty v3; };
struct BFu15ll_BFu1s_Sf { unsigned long long v1:15; unsigned short v2:1; empty v3; };
struct BFu15ll_BFu31i_Sf { unsigned long long v1:15; unsigned int v2:31; empty v3; };
struct BFu15ll_BFu31ll_Sf { unsigned long long v1:15; unsigned long long v2:31; empty v3; };
struct BFu15ll_BFu32i_Sf { unsigned long long v1:15; unsigned int v2:32; empty v3; };
struct BFu15ll_BFu32ll_Sf { unsigned long long v1:15; unsigned long long v2:32; empty v3; };
struct BFu15ll_BFu33_Sf { unsigned long long v1:15; unsigned long long v2:33; empty v3; };
struct BFu15ll_BFu7c_Sf { unsigned long long v1:15; unsigned char v2:7; empty v3; };
struct BFu15ll_BFu7i_Sf { unsigned long long v1:15; unsigned int v2:7; empty v3; };
struct BFu15ll_BFu7ll_Sf { unsigned long long v1:15; unsigned long long v2:7; empty v3; };
struct BFu15ll_BFu7s_Sf { unsigned long long v1:15; unsigned short v2:7; empty v3; };
struct BFu15ll_BFu8c_Sf { unsigned long long v1:15; unsigned char v2:8; empty v3; };
struct BFu15ll_BFu8i_Sf { unsigned long long v1:15; unsigned int v2:8; empty v3; };
struct BFu15ll_BFu8ll_Sf { unsigned long long v1:15; unsigned long long v2:8; empty v3; };
struct BFu15ll_BFu8s_Sf { unsigned long long v1:15; unsigned short v2:8; empty v3; };
struct BFu15ll_BFu9i_Sf { unsigned long long v1:15; unsigned int v2:9; empty v3; };
struct BFu15ll_BFu9ll_Sf { unsigned long long v1:15; unsigned long long v2:9; empty v3; };
struct BFu15ll_BFu9s_Sf { unsigned long long v1:15; unsigned short v2:9; empty v3; };
struct BFu15ll_C_Sf { unsigned long long v1:15; char v2; empty v3; };
struct BFu15ll_D_Sf { unsigned long long v1:15; double v2; empty v3; };
struct BFu15ll_F_Sf { unsigned long long v1:15; float v2; empty v3; };
struct BFu15ll_I_Sf { unsigned long long v1:15; int v2; empty v3; };
struct BFu15ll_Ip_Sf { unsigned long long v1:15; int * v2; empty v3; };
struct BFu15ll_L_Sf { unsigned long long v1:15; long long v2; empty v3; };
struct BFu15ll_S_Sf { unsigned long long v1:15; short v2; empty v3; };
struct BFu15ll_Sf { unsigned long long v1:15; empty v2; };
struct BFu15ll_Sf_BFu15i { unsigned long long v1:15; empty v2; unsigned int v3:15; };
struct BFu15ll_Sf_BFu15ll { unsigned long long v1:15; empty v2; unsigned long long v3:15; };
struct BFu15ll_Sf_BFu15s { unsigned long long v1:15; empty v2; unsigned short v3:15; };
struct BFu15ll_Sf_BFu16i { unsigned long long v1:15; empty v2; unsigned int v3:16; };
struct BFu15ll_Sf_BFu16ll { unsigned long long v1:15; empty v2; unsigned long long v3:16; };
struct BFu15ll_Sf_BFu16s { unsigned long long v1:15; empty v2; unsigned short v3:16; };
struct BFu15ll_Sf_BFu17i { unsigned long long v1:15; empty v2; unsigned int v3:17; };
struct BFu15ll_Sf_BFu17ll { unsigned long long v1:15; empty v2; unsigned long long v3:17; };
struct BFu15ll_Sf_BFu1c { unsigned long long v1:15; empty v2; unsigned char v3:1; };
struct BFu15ll_Sf_BFu1i { unsigned long long v1:15; empty v2; unsigned int v3:1; };
struct BFu15ll_Sf_BFu1ll { unsigned long long v1:15; empty v2; unsigned long long v3:1; };
struct BFu15ll_Sf_BFu1s { unsigned long long v1:15; empty v2; unsigned short v3:1; };
struct BFu15ll_Sf_BFu31i { unsigned long long v1:15; empty v2; unsigned int v3:31; };
struct BFu15ll_Sf_BFu31ll { unsigned long long v1:15; empty v2; unsigned long long v3:31; };
struct BFu15ll_Sf_BFu32i { unsigned long long v1:15; empty v2; unsigned int v3:32; };
struct BFu15ll_Sf_BFu32ll { unsigned long long v1:15; empty v2; unsigned long long v3:32; };
struct BFu15ll_Sf_BFu33 { unsigned long long v1:15; empty v2; unsigned long long v3:33; };
struct BFu15ll_Sf_BFu7c { unsigned long long v1:15; empty v2; unsigned char v3:7; };
struct BFu15ll_Sf_BFu7i { unsigned long long v1:15; empty v2; unsigned int v3:7; };
struct BFu15ll_Sf_BFu7ll { unsigned long long v1:15; empty v2; unsigned long long v3:7; };
struct BFu15ll_Sf_BFu7s { unsigned long long v1:15; empty v2; unsigned short v3:7; };
struct BFu15ll_Sf_BFu8c { unsigned long long v1:15; empty v2; unsigned char v3:8; };
struct BFu15ll_Sf_BFu8i { unsigned long long v1:15; empty v2; unsigned int v3:8; };
struct BFu15ll_Sf_BFu8ll { unsigned long long v1:15; empty v2; unsigned long long v3:8; };
struct BFu15ll_Sf_BFu8s { unsigned long long v1:15; empty v2; unsigned short v3:8; };
struct BFu15ll_Sf_BFu9i { unsigned long long v1:15; empty v2; unsigned int v3:9; };
struct BFu15ll_Sf_BFu9ll { unsigned long long v1:15; empty v2; unsigned long long v3:9; };
struct BFu15ll_Sf_BFu9s { unsigned long long v1:15; empty v2; unsigned short v3:9; };
struct BFu15ll_Sf_C { unsigned long long v1:15; empty v2; char v3; };
struct BFu15ll_Sf_D { unsigned long long v1:15; empty v2; double v3; };
struct BFu15ll_Sf_F { unsigned long long v1:15; empty v2; float v3; };
struct BFu15ll_Sf_I { unsigned long long v1:15; empty v2; int v3; };
struct BFu15ll_Sf_Ip { unsigned long long v1:15; empty v2; int * v3; };
struct BFu15ll_Sf_L { unsigned long long v1:15; empty v2; long long v3; };
struct BFu15ll_Sf_S { unsigned long long v1:15; empty v2; short v3; };
struct BFu15ll_Sf_Sf { unsigned long long v1:15; empty v2; empty v3; };
struct BFu15ll_Sf_Uc { unsigned long long v1:15; empty v2; unsigned char v3; };
struct BFu15ll_Sf_Ui { unsigned long long v1:15; empty v2; unsigned int v3; };
struct BFu15ll_Sf_Ul { unsigned long long v1:15; empty v2; unsigned long long v3; };
struct BFu15ll_Sf_Us { unsigned long long v1:15; empty v2; unsigned short v3; };
struct BFu15ll_Sf_Vp { unsigned long long v1:15; empty v2; void * v3; };
struct BFu15ll_Uc_Sf { unsigned long long v1:15; unsigned char v2; empty v3; };
struct BFu15ll_Ui_Sf { unsigned long long v1:15; unsigned int v2; empty v3; };
struct BFu15ll_Ul_Sf { unsigned long long v1:15; unsigned long long v2; empty v3; };
struct BFu15ll_Us_Sf { unsigned long long v1:15; unsigned short v2; empty v3; };
struct BFu15ll_Vp_Sf { unsigned long long v1:15; void * v2; empty v3; };
struct BFu15s_BFu15i_Sf { unsigned short v1:15; unsigned int v2:15; empty v3; };
struct BFu15s_BFu15ll_Sf { unsigned short v1:15; unsigned long long v2:15; empty v3; };
struct BFu15s_BFu15s_Sf { unsigned short v1:15; unsigned short v2:15; empty v3; };
struct BFu15s_BFu16i_Sf { unsigned short v1:15; unsigned int v2:16; empty v3; };
struct BFu15s_BFu16ll_Sf { unsigned short v1:15; unsigned long long v2:16; empty v3; };
struct BFu15s_BFu16s_Sf { unsigned short v1:15; unsigned short v2:16; empty v3; };
struct BFu15s_BFu17i_Sf { unsigned short v1:15; unsigned int v2:17; empty v3; };
struct BFu15s_BFu17ll_Sf { unsigned short v1:15; unsigned long long v2:17; empty v3; };
struct BFu15s_BFu1c_Sf { unsigned short v1:15; unsigned char v2:1; empty v3; };
struct BFu15s_BFu1i_Sf { unsigned short v1:15; unsigned int v2:1; empty v3; };
struct BFu15s_BFu1ll_Sf { unsigned short v1:15; unsigned long long v2:1; empty v3; };
struct BFu15s_BFu1s_Sf { unsigned short v1:15; unsigned short v2:1; empty v3; };
struct BFu15s_BFu31i_Sf { unsigned short v1:15; unsigned int v2:31; empty v3; };
struct BFu15s_BFu31ll_Sf { unsigned short v1:15; unsigned long long v2:31; empty v3; };
struct BFu15s_BFu32i_Sf { unsigned short v1:15; unsigned int v2:32; empty v3; };
struct BFu15s_BFu32ll_Sf { unsigned short v1:15; unsigned long long v2:32; empty v3; };
struct BFu15s_BFu33_Sf { unsigned short v1:15; unsigned long long v2:33; empty v3; };
struct BFu15s_BFu7c_Sf { unsigned short v1:15; unsigned char v2:7; empty v3; };
struct BFu15s_BFu7i_Sf { unsigned short v1:15; unsigned int v2:7; empty v3; };
struct BFu15s_BFu7ll_Sf { unsigned short v1:15; unsigned long long v2:7; empty v3; };
struct BFu15s_BFu7s_Sf { unsigned short v1:15; unsigned short v2:7; empty v3; };
struct BFu15s_BFu8c_Sf { unsigned short v1:15; unsigned char v2:8; empty v3; };
struct BFu15s_BFu8i_Sf { unsigned short v1:15; unsigned int v2:8; empty v3; };
struct BFu15s_BFu8ll_Sf { unsigned short v1:15; unsigned long long v2:8; empty v3; };
struct BFu15s_BFu8s_Sf { unsigned short v1:15; unsigned short v2:8; empty v3; };
struct BFu15s_BFu9i_Sf { unsigned short v1:15; unsigned int v2:9; empty v3; };
struct BFu15s_BFu9ll_Sf { unsigned short v1:15; unsigned long long v2:9; empty v3; };
struct BFu15s_BFu9s_Sf { unsigned short v1:15; unsigned short v2:9; empty v3; };
struct BFu15s_C_Sf { unsigned short v1:15; char v2; empty v3; };
struct BFu15s_D_Sf { unsigned short v1:15; double v2; empty v3; };
struct BFu15s_F_Sf { unsigned short v1:15; float v2; empty v3; };
struct BFu15s_I_Sf { unsigned short v1:15; int v2; empty v3; };
struct BFu15s_Ip_Sf { unsigned short v1:15; int * v2; empty v3; };
struct BFu15s_L_Sf { unsigned short v1:15; long long v2; empty v3; };
struct BFu15s_S_Sf { unsigned short v1:15; short v2; empty v3; };
struct BFu15s_Sf { unsigned short v1:15; empty v2; };
struct BFu15s_Sf_BFu15i { unsigned short v1:15; empty v2; unsigned int v3:15; };
struct BFu15s_Sf_BFu15ll { unsigned short v1:15; empty v2; unsigned long long v3:15; };
struct BFu15s_Sf_BFu15s { unsigned short v1:15; empty v2; unsigned short v3:15; };
struct BFu15s_Sf_BFu16i { unsigned short v1:15; empty v2; unsigned int v3:16; };
struct BFu15s_Sf_BFu16ll { unsigned short v1:15; empty v2; unsigned long long v3:16; };
struct BFu15s_Sf_BFu16s { unsigned short v1:15; empty v2; unsigned short v3:16; };
struct BFu15s_Sf_BFu17i { unsigned short v1:15; empty v2; unsigned int v3:17; };
struct BFu15s_Sf_BFu17ll { unsigned short v1:15; empty v2; unsigned long long v3:17; };
struct BFu15s_Sf_BFu1c { unsigned short v1:15; empty v2; unsigned char v3:1; };
struct BFu15s_Sf_BFu1i { unsigned short v1:15; empty v2; unsigned int v3:1; };
struct BFu15s_Sf_BFu1ll { unsigned short v1:15; empty v2; unsigned long long v3:1; };
struct BFu15s_Sf_BFu1s { unsigned short v1:15; empty v2; unsigned short v3:1; };
struct BFu15s_Sf_BFu31i { unsigned short v1:15; empty v2; unsigned int v3:31; };
struct BFu15s_Sf_BFu31ll { unsigned short v1:15; empty v2; unsigned long long v3:31; };
struct BFu15s_Sf_BFu32i { unsigned short v1:15; empty v2; unsigned int v3:32; };
struct BFu15s_Sf_BFu32ll { unsigned short v1:15; empty v2; unsigned long long v3:32; };
struct BFu15s_Sf_BFu33 { unsigned short v1:15; empty v2; unsigned long long v3:33; };
struct BFu15s_Sf_BFu7c { unsigned short v1:15; empty v2; unsigned char v3:7; };
struct BFu15s_Sf_BFu7i { unsigned short v1:15; empty v2; unsigned int v3:7; };
struct BFu15s_Sf_BFu7ll { unsigned short v1:15; empty v2; unsigned long long v3:7; };
struct BFu15s_Sf_BFu7s { unsigned short v1:15; empty v2; unsigned short v3:7; };
struct BFu15s_Sf_BFu8c { unsigned short v1:15; empty v2; unsigned char v3:8; };
struct BFu15s_Sf_BFu8i { unsigned short v1:15; empty v2; unsigned int v3:8; };
struct BFu15s_Sf_BFu8ll { unsigned short v1:15; empty v2; unsigned long long v3:8; };
struct BFu15s_Sf_BFu8s { unsigned short v1:15; empty v2; unsigned short v3:8; };
struct BFu15s_Sf_BFu9i { unsigned short v1:15; empty v2; unsigned int v3:9; };
struct BFu15s_Sf_BFu9ll { unsigned short v1:15; empty v2; unsigned long long v3:9; };
struct BFu15s_Sf_BFu9s { unsigned short v1:15; empty v2; unsigned short v3:9; };
struct BFu15s_Sf_C { unsigned short v1:15; empty v2; char v3; };
struct BFu15s_Sf_D { unsigned short v1:15; empty v2; double v3; };
struct BFu15s_Sf_F { unsigned short v1:15; empty v2; float v3; };
struct BFu15s_Sf_I { unsigned short v1:15; empty v2; int v3; };
struct BFu15s_Sf_Ip { unsigned short v1:15; empty v2; int * v3; };
struct BFu15s_Sf_L { unsigned short v1:15; empty v2; long long v3; };
struct BFu15s_Sf_S { unsigned short v1:15; empty v2; short v3; };
struct BFu15s_Sf_Sf { unsigned short v1:15; empty v2; empty v3; };
struct BFu15s_Sf_Uc { unsigned short v1:15; empty v2; unsigned char v3; };
struct BFu15s_Sf_Ui { unsigned short v1:15; empty v2; unsigned int v3; };
struct BFu15s_Sf_Ul { unsigned short v1:15; empty v2; unsigned long long v3; };
struct BFu15s_Sf_Us { unsigned short v1:15; empty v2; unsigned short v3; };
struct BFu15s_Sf_Vp { unsigned short v1:15; empty v2; void * v3; };
struct BFu15s_Uc_Sf { unsigned short v1:15; unsigned char v2; empty v3; };
struct BFu15s_Ui_Sf { unsigned short v1:15; unsigned int v2; empty v3; };
struct BFu15s_Ul_Sf { unsigned short v1:15; unsigned long long v2; empty v3; };
struct BFu15s_Us_Sf { unsigned short v1:15; unsigned short v2; empty v3; };
struct BFu15s_Vp_Sf { unsigned short v1:15; void * v2; empty v3; };
struct BFu16i_BFu15i_Sf { unsigned int v1:16; unsigned int v2:15; empty v3; };
struct BFu16i_BFu15ll_Sf { unsigned int v1:16; unsigned long long v2:15; empty v3; };
struct BFu16i_BFu15s_Sf { unsigned int v1:16; unsigned short v2:15; empty v3; };
struct BFu16i_BFu16i_Sf { unsigned int v1:16; unsigned int v2:16; empty v3; };
struct BFu16i_BFu16ll_Sf { unsigned int v1:16; unsigned long long v2:16; empty v3; };
struct BFu16i_BFu16s_Sf { unsigned int v1:16; unsigned short v2:16; empty v3; };
struct BFu16i_BFu17i_Sf { unsigned int v1:16; unsigned int v2:17; empty v3; };
struct BFu16i_BFu17ll_Sf { unsigned int v1:16; unsigned long long v2:17; empty v3; };
struct BFu16i_BFu1c_Sf { unsigned int v1:16; unsigned char v2:1; empty v3; };
struct BFu16i_BFu1i_Sf { unsigned int v1:16; unsigned int v2:1; empty v3; };
struct BFu16i_BFu1ll_Sf { unsigned int v1:16; unsigned long long v2:1; empty v3; };
struct BFu16i_BFu1s_Sf { unsigned int v1:16; unsigned short v2:1; empty v3; };
struct BFu16i_BFu31i_Sf { unsigned int v1:16; unsigned int v2:31; empty v3; };
struct BFu16i_BFu31ll_Sf { unsigned int v1:16; unsigned long long v2:31; empty v3; };
struct BFu16i_BFu32i_Sf { unsigned int v1:16; unsigned int v2:32; empty v3; };
struct BFu16i_BFu32ll_Sf { unsigned int v1:16; unsigned long long v2:32; empty v3; };
struct BFu16i_BFu33_Sf { unsigned int v1:16; unsigned long long v2:33; empty v3; };
struct BFu16i_BFu7c_Sf { unsigned int v1:16; unsigned char v2:7; empty v3; };
struct BFu16i_BFu7i_Sf { unsigned int v1:16; unsigned int v2:7; empty v3; };
struct BFu16i_BFu7ll_Sf { unsigned int v1:16; unsigned long long v2:7; empty v3; };
struct BFu16i_BFu7s_Sf { unsigned int v1:16; unsigned short v2:7; empty v3; };
struct BFu16i_BFu8c_Sf { unsigned int v1:16; unsigned char v2:8; empty v3; };
struct BFu16i_BFu8i_Sf { unsigned int v1:16; unsigned int v2:8; empty v3; };
struct BFu16i_BFu8ll_Sf { unsigned int v1:16; unsigned long long v2:8; empty v3; };
struct BFu16i_BFu8s_Sf { unsigned int v1:16; unsigned short v2:8; empty v3; };
struct BFu16i_BFu9i_Sf { unsigned int v1:16; unsigned int v2:9; empty v3; };
struct BFu16i_BFu9ll_Sf { unsigned int v1:16; unsigned long long v2:9; empty v3; };
struct BFu16i_BFu9s_Sf { unsigned int v1:16; unsigned short v2:9; empty v3; };
struct BFu16i_C_Sf { unsigned int v1:16; char v2; empty v3; };
struct BFu16i_D_Sf { unsigned int v1:16; double v2; empty v3; };
struct BFu16i_F_Sf { unsigned int v1:16; float v2; empty v3; };
struct BFu16i_I_Sf { unsigned int v1:16; int v2; empty v3; };
struct BFu16i_Ip_Sf { unsigned int v1:16; int * v2; empty v3; };
struct BFu16i_L_Sf { unsigned int v1:16; long long v2; empty v3; };
struct BFu16i_S_Sf { unsigned int v1:16; short v2; empty v3; };
struct BFu16i_Sf { unsigned int v1:16; empty v2; };
struct BFu16i_Sf_BFu15i { unsigned int v1:16; empty v2; unsigned int v3:15; };
struct BFu16i_Sf_BFu15ll { unsigned int v1:16; empty v2; unsigned long long v3:15; };
struct BFu16i_Sf_BFu15s { unsigned int v1:16; empty v2; unsigned short v3:15; };
struct BFu16i_Sf_BFu16i { unsigned int v1:16; empty v2; unsigned int v3:16; };
struct BFu16i_Sf_BFu16ll { unsigned int v1:16; empty v2; unsigned long long v3:16; };
struct BFu16i_Sf_BFu16s { unsigned int v1:16; empty v2; unsigned short v3:16; };
struct BFu16i_Sf_BFu17i { unsigned int v1:16; empty v2; unsigned int v3:17; };
struct BFu16i_Sf_BFu17ll { unsigned int v1:16; empty v2; unsigned long long v3:17; };
struct BFu16i_Sf_BFu1c { unsigned int v1:16; empty v2; unsigned char v3:1; };
struct BFu16i_Sf_BFu1i { unsigned int v1:16; empty v2; unsigned int v3:1; };
struct BFu16i_Sf_BFu1ll { unsigned int v1:16; empty v2; unsigned long long v3:1; };
struct BFu16i_Sf_BFu1s { unsigned int v1:16; empty v2; unsigned short v3:1; };
struct BFu16i_Sf_BFu31i { unsigned int v1:16; empty v2; unsigned int v3:31; };
struct BFu16i_Sf_BFu31ll { unsigned int v1:16; empty v2; unsigned long long v3:31; };
struct BFu16i_Sf_BFu32i { unsigned int v1:16; empty v2; unsigned int v3:32; };
struct BFu16i_Sf_BFu32ll { unsigned int v1:16; empty v2; unsigned long long v3:32; };
struct BFu16i_Sf_BFu33 { unsigned int v1:16; empty v2; unsigned long long v3:33; };
struct BFu16i_Sf_BFu7c { unsigned int v1:16; empty v2; unsigned char v3:7; };
struct BFu16i_Sf_BFu7i { unsigned int v1:16; empty v2; unsigned int v3:7; };
struct BFu16i_Sf_BFu7ll { unsigned int v1:16; empty v2; unsigned long long v3:7; };
struct BFu16i_Sf_BFu7s { unsigned int v1:16; empty v2; unsigned short v3:7; };
struct BFu16i_Sf_BFu8c { unsigned int v1:16; empty v2; unsigned char v3:8; };
struct BFu16i_Sf_BFu8i { unsigned int v1:16; empty v2; unsigned int v3:8; };
struct BFu16i_Sf_BFu8ll { unsigned int v1:16; empty v2; unsigned long long v3:8; };
struct BFu16i_Sf_BFu8s { unsigned int v1:16; empty v2; unsigned short v3:8; };
struct BFu16i_Sf_BFu9i { unsigned int v1:16; empty v2; unsigned int v3:9; };
struct BFu16i_Sf_BFu9ll { unsigned int v1:16; empty v2; unsigned long long v3:9; };
struct BFu16i_Sf_BFu9s { unsigned int v1:16; empty v2; unsigned short v3:9; };
struct BFu16i_Sf_C { unsigned int v1:16; empty v2; char v3; };
struct BFu16i_Sf_D { unsigned int v1:16; empty v2; double v3; };
struct BFu16i_Sf_F { unsigned int v1:16; empty v2; float v3; };
struct BFu16i_Sf_I { unsigned int v1:16; empty v2; int v3; };
struct BFu16i_Sf_Ip { unsigned int v1:16; empty v2; int * v3; };
struct BFu16i_Sf_L { unsigned int v1:16; empty v2; long long v3; };
struct BFu16i_Sf_S { unsigned int v1:16; empty v2; short v3; };
struct BFu16i_Sf_Sf { unsigned int v1:16; empty v2; empty v3; };
struct BFu16i_Sf_Uc { unsigned int v1:16; empty v2; unsigned char v3; };
struct BFu16i_Sf_Ui { unsigned int v1:16; empty v2; unsigned int v3; };
struct BFu16i_Sf_Ul { unsigned int v1:16; empty v2; unsigned long long v3; };
struct BFu16i_Sf_Us { unsigned int v1:16; empty v2; unsigned short v3; };
struct BFu16i_Sf_Vp { unsigned int v1:16; empty v2; void * v3; };
struct BFu16i_Uc_Sf { unsigned int v1:16; unsigned char v2; empty v3; };
struct BFu16i_Ui_Sf { unsigned int v1:16; unsigned int v2; empty v3; };
struct BFu16i_Ul_Sf { unsigned int v1:16; unsigned long long v2; empty v3; };
struct BFu16i_Us_Sf { unsigned int v1:16; unsigned short v2; empty v3; };
struct BFu16i_Vp_Sf { unsigned int v1:16; void * v2; empty v3; };
struct BFu16ll_BFu15i_Sf { unsigned long long v1:16; unsigned int v2:15; empty v3; };
struct BFu16ll_BFu15ll_Sf { unsigned long long v1:16; unsigned long long v2:15; empty v3; };
struct BFu16ll_BFu15s_Sf { unsigned long long v1:16; unsigned short v2:15; empty v3; };
struct BFu16ll_BFu16i_Sf { unsigned long long v1:16; unsigned int v2:16; empty v3; };
struct BFu16ll_BFu16ll_Sf { unsigned long long v1:16; unsigned long long v2:16; empty v3; };
struct BFu16ll_BFu16s_Sf { unsigned long long v1:16; unsigned short v2:16; empty v3; };
struct BFu16ll_BFu17i_Sf { unsigned long long v1:16; unsigned int v2:17; empty v3; };
struct BFu16ll_BFu17ll_Sf { unsigned long long v1:16; unsigned long long v2:17; empty v3; };
struct BFu16ll_BFu1c_Sf { unsigned long long v1:16; unsigned char v2:1; empty v3; };
struct BFu16ll_BFu1i_Sf { unsigned long long v1:16; unsigned int v2:1; empty v3; };
struct BFu16ll_BFu1ll_Sf { unsigned long long v1:16; unsigned long long v2:1; empty v3; };
struct BFu16ll_BFu1s_Sf { unsigned long long v1:16; unsigned short v2:1; empty v3; };
struct BFu16ll_BFu31i_Sf { unsigned long long v1:16; unsigned int v2:31; empty v3; };
struct BFu16ll_BFu31ll_Sf { unsigned long long v1:16; unsigned long long v2:31; empty v3; };
struct BFu16ll_BFu32i_Sf { unsigned long long v1:16; unsigned int v2:32; empty v3; };
struct BFu16ll_BFu32ll_Sf { unsigned long long v1:16; unsigned long long v2:32; empty v3; };
struct BFu16ll_BFu33_Sf { unsigned long long v1:16; unsigned long long v2:33; empty v3; };
struct BFu16ll_BFu7c_Sf { unsigned long long v1:16; unsigned char v2:7; empty v3; };
struct BFu16ll_BFu7i_Sf { unsigned long long v1:16; unsigned int v2:7; empty v3; };
struct BFu16ll_BFu7ll_Sf { unsigned long long v1:16; unsigned long long v2:7; empty v3; };
struct BFu16ll_BFu7s_Sf { unsigned long long v1:16; unsigned short v2:7; empty v3; };
struct BFu16ll_BFu8c_Sf { unsigned long long v1:16; unsigned char v2:8; empty v3; };
struct BFu16ll_BFu8i_Sf { unsigned long long v1:16; unsigned int v2:8; empty v3; };
struct BFu16ll_BFu8ll_Sf { unsigned long long v1:16; unsigned long long v2:8; empty v3; };
struct BFu16ll_BFu8s_Sf { unsigned long long v1:16; unsigned short v2:8; empty v3; };
struct BFu16ll_BFu9i_Sf { unsigned long long v1:16; unsigned int v2:9; empty v3; };
struct BFu16ll_BFu9ll_Sf { unsigned long long v1:16; unsigned long long v2:9; empty v3; };
struct BFu16ll_BFu9s_Sf { unsigned long long v1:16; unsigned short v2:9; empty v3; };
struct BFu16ll_C_Sf { unsigned long long v1:16; char v2; empty v3; };
struct BFu16ll_D_Sf { unsigned long long v1:16; double v2; empty v3; };
struct BFu16ll_F_Sf { unsigned long long v1:16; float v2; empty v3; };
struct BFu16ll_I_Sf { unsigned long long v1:16; int v2; empty v3; };
struct BFu16ll_Ip_Sf { unsigned long long v1:16; int * v2; empty v3; };
struct BFu16ll_L_Sf { unsigned long long v1:16; long long v2; empty v3; };
struct BFu16ll_S_Sf { unsigned long long v1:16; short v2; empty v3; };
struct BFu16ll_Sf { unsigned long long v1:16; empty v2; };
struct BFu16ll_Sf_BFu15i { unsigned long long v1:16; empty v2; unsigned int v3:15; };
struct BFu16ll_Sf_BFu15ll { unsigned long long v1:16; empty v2; unsigned long long v3:15; };
struct BFu16ll_Sf_BFu15s { unsigned long long v1:16; empty v2; unsigned short v3:15; };
struct BFu16ll_Sf_BFu16i { unsigned long long v1:16; empty v2; unsigned int v3:16; };
struct BFu16ll_Sf_BFu16ll { unsigned long long v1:16; empty v2; unsigned long long v3:16; };
struct BFu16ll_Sf_BFu16s { unsigned long long v1:16; empty v2; unsigned short v3:16; };
struct BFu16ll_Sf_BFu17i { unsigned long long v1:16; empty v2; unsigned int v3:17; };
struct BFu16ll_Sf_BFu17ll { unsigned long long v1:16; empty v2; unsigned long long v3:17; };
struct BFu16ll_Sf_BFu1c { unsigned long long v1:16; empty v2; unsigned char v3:1; };
struct BFu16ll_Sf_BFu1i { unsigned long long v1:16; empty v2; unsigned int v3:1; };
struct BFu16ll_Sf_BFu1ll { unsigned long long v1:16; empty v2; unsigned long long v3:1; };
struct BFu16ll_Sf_BFu1s { unsigned long long v1:16; empty v2; unsigned short v3:1; };
struct BFu16ll_Sf_BFu31i { unsigned long long v1:16; empty v2; unsigned int v3:31; };
struct BFu16ll_Sf_BFu31ll { unsigned long long v1:16; empty v2; unsigned long long v3:31; };
struct BFu16ll_Sf_BFu32i { unsigned long long v1:16; empty v2; unsigned int v3:32; };
struct BFu16ll_Sf_BFu32ll { unsigned long long v1:16; empty v2; unsigned long long v3:32; };
struct BFu16ll_Sf_BFu33 { unsigned long long v1:16; empty v2; unsigned long long v3:33; };
struct BFu16ll_Sf_BFu7c { unsigned long long v1:16; empty v2; unsigned char v3:7; };
struct BFu16ll_Sf_BFu7i { unsigned long long v1:16; empty v2; unsigned int v3:7; };
struct BFu16ll_Sf_BFu7ll { unsigned long long v1:16; empty v2; unsigned long long v3:7; };
struct BFu16ll_Sf_BFu7s { unsigned long long v1:16; empty v2; unsigned short v3:7; };
struct BFu16ll_Sf_BFu8c { unsigned long long v1:16; empty v2; unsigned char v3:8; };
struct BFu16ll_Sf_BFu8i { unsigned long long v1:16; empty v2; unsigned int v3:8; };
struct BFu16ll_Sf_BFu8ll { unsigned long long v1:16; empty v2; unsigned long long v3:8; };
struct BFu16ll_Sf_BFu8s { unsigned long long v1:16; empty v2; unsigned short v3:8; };
struct BFu16ll_Sf_BFu9i { unsigned long long v1:16; empty v2; unsigned int v3:9; };
struct BFu16ll_Sf_BFu9ll { unsigned long long v1:16; empty v2; unsigned long long v3:9; };
struct BFu16ll_Sf_BFu9s { unsigned long long v1:16; empty v2; unsigned short v3:9; };
struct BFu16ll_Sf_C { unsigned long long v1:16; empty v2; char v3; };
struct BFu16ll_Sf_D { unsigned long long v1:16; empty v2; double v3; };
struct BFu16ll_Sf_F { unsigned long long v1:16; empty v2; float v3; };
struct BFu16ll_Sf_I { unsigned long long v1:16; empty v2; int v3; };
struct BFu16ll_Sf_Ip { unsigned long long v1:16; empty v2; int * v3; };
struct BFu16ll_Sf_L { unsigned long long v1:16; empty v2; long long v3; };
struct BFu16ll_Sf_S { unsigned long long v1:16; empty v2; short v3; };
struct BFu16ll_Sf_Sf { unsigned long long v1:16; empty v2; empty v3; };
struct BFu16ll_Sf_Uc { unsigned long long v1:16; empty v2; unsigned char v3; };
struct BFu16ll_Sf_Ui { unsigned long long v1:16; empty v2; unsigned int v3; };
struct BFu16ll_Sf_Ul { unsigned long long v1:16; empty v2; unsigned long long v3; };
struct BFu16ll_Sf_Us { unsigned long long v1:16; empty v2; unsigned short v3; };
struct BFu16ll_Sf_Vp { unsigned long long v1:16; empty v2; void * v3; };
struct BFu16ll_Uc_Sf { unsigned long long v1:16; unsigned char v2; empty v3; };
struct BFu16ll_Ui_Sf { unsigned long long v1:16; unsigned int v2; empty v3; };
struct BFu16ll_Ul_Sf { unsigned long long v1:16; unsigned long long v2; empty v3; };
struct BFu16ll_Us_Sf { unsigned long long v1:16; unsigned short v2; empty v3; };
struct BFu16ll_Vp_Sf { unsigned long long v1:16; void * v2; empty v3; };
struct BFu16s_BFu15i_Sf { unsigned short v1:16; unsigned int v2:15; empty v3; };
struct BFu16s_BFu15ll_Sf { unsigned short v1:16; unsigned long long v2:15; empty v3; };
struct BFu16s_BFu15s_Sf { unsigned short v1:16; unsigned short v2:15; empty v3; };
struct BFu16s_BFu16i_Sf { unsigned short v1:16; unsigned int v2:16; empty v3; };
struct BFu16s_BFu16ll_Sf { unsigned short v1:16; unsigned long long v2:16; empty v3; };
struct BFu16s_BFu16s_Sf { unsigned short v1:16; unsigned short v2:16; empty v3; };
struct BFu16s_BFu17i_Sf { unsigned short v1:16; unsigned int v2:17; empty v3; };
struct BFu16s_BFu17ll_Sf { unsigned short v1:16; unsigned long long v2:17; empty v3; };
struct BFu16s_BFu1c_Sf { unsigned short v1:16; unsigned char v2:1; empty v3; };
struct BFu16s_BFu1i_Sf { unsigned short v1:16; unsigned int v2:1; empty v3; };
struct BFu16s_BFu1ll_Sf { unsigned short v1:16; unsigned long long v2:1; empty v3; };
struct BFu16s_BFu1s_Sf { unsigned short v1:16; unsigned short v2:1; empty v3; };
struct BFu16s_BFu31i_Sf { unsigned short v1:16; unsigned int v2:31; empty v3; };
struct BFu16s_BFu31ll_Sf { unsigned short v1:16; unsigned long long v2:31; empty v3; };
struct BFu16s_BFu32i_Sf { unsigned short v1:16; unsigned int v2:32; empty v3; };
struct BFu16s_BFu32ll_Sf { unsigned short v1:16; unsigned long long v2:32; empty v3; };
struct BFu16s_BFu33_Sf { unsigned short v1:16; unsigned long long v2:33; empty v3; };
struct BFu16s_BFu7c_Sf { unsigned short v1:16; unsigned char v2:7; empty v3; };
struct BFu16s_BFu7i_Sf { unsigned short v1:16; unsigned int v2:7; empty v3; };
struct BFu16s_BFu7ll_Sf { unsigned short v1:16; unsigned long long v2:7; empty v3; };
struct BFu16s_BFu7s_Sf { unsigned short v1:16; unsigned short v2:7; empty v3; };
struct BFu16s_BFu8c_Sf { unsigned short v1:16; unsigned char v2:8; empty v3; };
struct BFu16s_BFu8i_Sf { unsigned short v1:16; unsigned int v2:8; empty v3; };
struct BFu16s_BFu8ll_Sf { unsigned short v1:16; unsigned long long v2:8; empty v3; };
struct BFu16s_BFu8s_Sf { unsigned short v1:16; unsigned short v2:8; empty v3; };
struct BFu16s_BFu9i_Sf { unsigned short v1:16; unsigned int v2:9; empty v3; };
struct BFu16s_BFu9ll_Sf { unsigned short v1:16; unsigned long long v2:9; empty v3; };
struct BFu16s_BFu9s_Sf { unsigned short v1:16; unsigned short v2:9; empty v3; };
struct BFu16s_C_Sf { unsigned short v1:16; char v2; empty v3; };
struct BFu16s_D_Sf { unsigned short v1:16; double v2; empty v3; };
struct BFu16s_F_Sf { unsigned short v1:16; float v2; empty v3; };
struct BFu16s_I_Sf { unsigned short v1:16; int v2; empty v3; };
struct BFu16s_Ip_Sf { unsigned short v1:16; int * v2; empty v3; };
struct BFu16s_L_Sf { unsigned short v1:16; long long v2; empty v3; };
struct BFu16s_S_Sf { unsigned short v1:16; short v2; empty v3; };
struct BFu16s_Sf { unsigned short v1:16; empty v2; };
struct BFu16s_Sf_BFu15i { unsigned short v1:16; empty v2; unsigned int v3:15; };
struct BFu16s_Sf_BFu15ll { unsigned short v1:16; empty v2; unsigned long long v3:15; };
struct BFu16s_Sf_BFu15s { unsigned short v1:16; empty v2; unsigned short v3:15; };
struct BFu16s_Sf_BFu16i { unsigned short v1:16; empty v2; unsigned int v3:16; };
struct BFu16s_Sf_BFu16ll { unsigned short v1:16; empty v2; unsigned long long v3:16; };
struct BFu16s_Sf_BFu16s { unsigned short v1:16; empty v2; unsigned short v3:16; };
struct BFu16s_Sf_BFu17i { unsigned short v1:16; empty v2; unsigned int v3:17; };
struct BFu16s_Sf_BFu17ll { unsigned short v1:16; empty v2; unsigned long long v3:17; };
struct BFu16s_Sf_BFu1c { unsigned short v1:16; empty v2; unsigned char v3:1; };
struct BFu16s_Sf_BFu1i { unsigned short v1:16; empty v2; unsigned int v3:1; };
struct BFu16s_Sf_BFu1ll { unsigned short v1:16; empty v2; unsigned long long v3:1; };
struct BFu16s_Sf_BFu1s { unsigned short v1:16; empty v2; unsigned short v3:1; };
struct BFu16s_Sf_BFu31i { unsigned short v1:16; empty v2; unsigned int v3:31; };
struct BFu16s_Sf_BFu31ll { unsigned short v1:16; empty v2; unsigned long long v3:31; };
struct BFu16s_Sf_BFu32i { unsigned short v1:16; empty v2; unsigned int v3:32; };
struct BFu16s_Sf_BFu32ll { unsigned short v1:16; empty v2; unsigned long long v3:32; };
struct BFu16s_Sf_BFu33 { unsigned short v1:16; empty v2; unsigned long long v3:33; };
struct BFu16s_Sf_BFu7c { unsigned short v1:16; empty v2; unsigned char v3:7; };
struct BFu16s_Sf_BFu7i { unsigned short v1:16; empty v2; unsigned int v3:7; };
struct BFu16s_Sf_BFu7ll { unsigned short v1:16; empty v2; unsigned long long v3:7; };
struct BFu16s_Sf_BFu7s { unsigned short v1:16; empty v2; unsigned short v3:7; };
struct BFu16s_Sf_BFu8c { unsigned short v1:16; empty v2; unsigned char v3:8; };
struct BFu16s_Sf_BFu8i { unsigned short v1:16; empty v2; unsigned int v3:8; };
struct BFu16s_Sf_BFu8ll { unsigned short v1:16; empty v2; unsigned long long v3:8; };
struct BFu16s_Sf_BFu8s { unsigned short v1:16; empty v2; unsigned short v3:8; };
struct BFu16s_Sf_BFu9i { unsigned short v1:16; empty v2; unsigned int v3:9; };
struct BFu16s_Sf_BFu9ll { unsigned short v1:16; empty v2; unsigned long long v3:9; };
struct BFu16s_Sf_BFu9s { unsigned short v1:16; empty v2; unsigned short v3:9; };
struct BFu16s_Sf_C { unsigned short v1:16; empty v2; char v3; };
struct BFu16s_Sf_D { unsigned short v1:16; empty v2; double v3; };
struct BFu16s_Sf_F { unsigned short v1:16; empty v2; float v3; };
struct BFu16s_Sf_I { unsigned short v1:16; empty v2; int v3; };
struct BFu16s_Sf_Ip { unsigned short v1:16; empty v2; int * v3; };
struct BFu16s_Sf_L { unsigned short v1:16; empty v2; long long v3; };
struct BFu16s_Sf_S { unsigned short v1:16; empty v2; short v3; };
struct BFu16s_Sf_Sf { unsigned short v1:16; empty v2; empty v3; };
struct BFu16s_Sf_Uc { unsigned short v1:16; empty v2; unsigned char v3; };
struct BFu16s_Sf_Ui { unsigned short v1:16; empty v2; unsigned int v3; };
struct BFu16s_Sf_Ul { unsigned short v1:16; empty v2; unsigned long long v3; };
struct BFu16s_Sf_Us { unsigned short v1:16; empty v2; unsigned short v3; };
struct BFu16s_Sf_Vp { unsigned short v1:16; empty v2; void * v3; };
struct BFu16s_Uc_Sf { unsigned short v1:16; unsigned char v2; empty v3; };
struct BFu16s_Ui_Sf { unsigned short v1:16; unsigned int v2; empty v3; };
struct BFu16s_Ul_Sf { unsigned short v1:16; unsigned long long v2; empty v3; };
struct BFu16s_Us_Sf { unsigned short v1:16; unsigned short v2; empty v3; };
struct BFu16s_Vp_Sf { unsigned short v1:16; void * v2; empty v3; };
struct BFu17i_BFu15i_Sf { unsigned int v1:17; unsigned int v2:15; empty v3; };
struct BFu17i_BFu15ll_Sf { unsigned int v1:17; unsigned long long v2:15; empty v3; };
struct BFu17i_BFu15s_Sf { unsigned int v1:17; unsigned short v2:15; empty v3; };
struct BFu17i_BFu16i_Sf { unsigned int v1:17; unsigned int v2:16; empty v3; };
struct BFu17i_BFu16ll_Sf { unsigned int v1:17; unsigned long long v2:16; empty v3; };
struct BFu17i_BFu16s_Sf { unsigned int v1:17; unsigned short v2:16; empty v3; };
struct BFu17i_BFu17i_Sf { unsigned int v1:17; unsigned int v2:17; empty v3; };
struct BFu17i_BFu17ll_Sf { unsigned int v1:17; unsigned long long v2:17; empty v3; };
struct BFu17i_BFu1c_Sf { unsigned int v1:17; unsigned char v2:1; empty v3; };
struct BFu17i_BFu1i_Sf { unsigned int v1:17; unsigned int v2:1; empty v3; };
struct BFu17i_BFu1ll_Sf { unsigned int v1:17; unsigned long long v2:1; empty v3; };
struct BFu17i_BFu1s_Sf { unsigned int v1:17; unsigned short v2:1; empty v3; };
struct BFu17i_BFu31i_Sf { unsigned int v1:17; unsigned int v2:31; empty v3; };
struct BFu17i_BFu31ll_Sf { unsigned int v1:17; unsigned long long v2:31; empty v3; };
struct BFu17i_BFu32i_Sf { unsigned int v1:17; unsigned int v2:32; empty v3; };
struct BFu17i_BFu32ll_Sf { unsigned int v1:17; unsigned long long v2:32; empty v3; };
struct BFu17i_BFu33_Sf { unsigned int v1:17; unsigned long long v2:33; empty v3; };
struct BFu17i_BFu7c_Sf { unsigned int v1:17; unsigned char v2:7; empty v3; };
struct BFu17i_BFu7i_Sf { unsigned int v1:17; unsigned int v2:7; empty v3; };
struct BFu17i_BFu7ll_Sf { unsigned int v1:17; unsigned long long v2:7; empty v3; };
struct BFu17i_BFu7s_Sf { unsigned int v1:17; unsigned short v2:7; empty v3; };
struct BFu17i_BFu8c_Sf { unsigned int v1:17; unsigned char v2:8; empty v3; };
struct BFu17i_BFu8i_Sf { unsigned int v1:17; unsigned int v2:8; empty v3; };
struct BFu17i_BFu8ll_Sf { unsigned int v1:17; unsigned long long v2:8; empty v3; };
struct BFu17i_BFu8s_Sf { unsigned int v1:17; unsigned short v2:8; empty v3; };
struct BFu17i_BFu9i_Sf { unsigned int v1:17; unsigned int v2:9; empty v3; };
struct BFu17i_BFu9ll_Sf { unsigned int v1:17; unsigned long long v2:9; empty v3; };
struct BFu17i_BFu9s_Sf { unsigned int v1:17; unsigned short v2:9; empty v3; };
struct BFu17i_C_Sf { unsigned int v1:17; char v2; empty v3; };
struct BFu17i_D_Sf { unsigned int v1:17; double v2; empty v3; };
struct BFu17i_F_Sf { unsigned int v1:17; float v2; empty v3; };
struct BFu17i_I_Sf { unsigned int v1:17; int v2; empty v3; };
struct BFu17i_Ip_Sf { unsigned int v1:17; int * v2; empty v3; };
struct BFu17i_L_Sf { unsigned int v1:17; long long v2; empty v3; };
struct BFu17i_S_Sf { unsigned int v1:17; short v2; empty v3; };
struct BFu17i_Sf { unsigned int v1:17; empty v2; };
struct BFu17i_Sf_BFu15i { unsigned int v1:17; empty v2; unsigned int v3:15; };
struct BFu17i_Sf_BFu15ll { unsigned int v1:17; empty v2; unsigned long long v3:15; };
struct BFu17i_Sf_BFu15s { unsigned int v1:17; empty v2; unsigned short v3:15; };
struct BFu17i_Sf_BFu16i { unsigned int v1:17; empty v2; unsigned int v3:16; };
struct BFu17i_Sf_BFu16ll { unsigned int v1:17; empty v2; unsigned long long v3:16; };
struct BFu17i_Sf_BFu16s { unsigned int v1:17; empty v2; unsigned short v3:16; };
struct BFu17i_Sf_BFu17i { unsigned int v1:17; empty v2; unsigned int v3:17; };
struct BFu17i_Sf_BFu17ll { unsigned int v1:17; empty v2; unsigned long long v3:17; };
struct BFu17i_Sf_BFu1c { unsigned int v1:17; empty v2; unsigned char v3:1; };
struct BFu17i_Sf_BFu1i { unsigned int v1:17; empty v2; unsigned int v3:1; };
struct BFu17i_Sf_BFu1ll { unsigned int v1:17; empty v2; unsigned long long v3:1; };
struct BFu17i_Sf_BFu1s { unsigned int v1:17; empty v2; unsigned short v3:1; };
struct BFu17i_Sf_BFu31i { unsigned int v1:17; empty v2; unsigned int v3:31; };
struct BFu17i_Sf_BFu31ll { unsigned int v1:17; empty v2; unsigned long long v3:31; };
struct BFu17i_Sf_BFu32i { unsigned int v1:17; empty v2; unsigned int v3:32; };
struct BFu17i_Sf_BFu32ll { unsigned int v1:17; empty v2; unsigned long long v3:32; };
struct BFu17i_Sf_BFu33 { unsigned int v1:17; empty v2; unsigned long long v3:33; };
struct BFu17i_Sf_BFu7c { unsigned int v1:17; empty v2; unsigned char v3:7; };
struct BFu17i_Sf_BFu7i { unsigned int v1:17; empty v2; unsigned int v3:7; };
struct BFu17i_Sf_BFu7ll { unsigned int v1:17; empty v2; unsigned long long v3:7; };
struct BFu17i_Sf_BFu7s { unsigned int v1:17; empty v2; unsigned short v3:7; };
struct BFu17i_Sf_BFu8c { unsigned int v1:17; empty v2; unsigned char v3:8; };
struct BFu17i_Sf_BFu8i { unsigned int v1:17; empty v2; unsigned int v3:8; };
struct BFu17i_Sf_BFu8ll { unsigned int v1:17; empty v2; unsigned long long v3:8; };
struct BFu17i_Sf_BFu8s { unsigned int v1:17; empty v2; unsigned short v3:8; };
struct BFu17i_Sf_BFu9i { unsigned int v1:17; empty v2; unsigned int v3:9; };
struct BFu17i_Sf_BFu9ll { unsigned int v1:17; empty v2; unsigned long long v3:9; };
struct BFu17i_Sf_BFu9s { unsigned int v1:17; empty v2; unsigned short v3:9; };
struct BFu17i_Sf_C { unsigned int v1:17; empty v2; char v3; };
struct BFu17i_Sf_D { unsigned int v1:17; empty v2; double v3; };
struct BFu17i_Sf_F { unsigned int v1:17; empty v2; float v3; };
struct BFu17i_Sf_I { unsigned int v1:17; empty v2; int v3; };
struct BFu17i_Sf_Ip { unsigned int v1:17; empty v2; int * v3; };
struct BFu17i_Sf_L { unsigned int v1:17; empty v2; long long v3; };
struct BFu17i_Sf_S { unsigned int v1:17; empty v2; short v3; };
struct BFu17i_Sf_Sf { unsigned int v1:17; empty v2; empty v3; };
struct BFu17i_Sf_Uc { unsigned int v1:17; empty v2; unsigned char v3; };
struct BFu17i_Sf_Ui { unsigned int v1:17; empty v2; unsigned int v3; };
struct BFu17i_Sf_Ul { unsigned int v1:17; empty v2; unsigned long long v3; };
struct BFu17i_Sf_Us { unsigned int v1:17; empty v2; unsigned short v3; };
struct BFu17i_Sf_Vp { unsigned int v1:17; empty v2; void * v3; };
struct BFu17i_Uc_Sf { unsigned int v1:17; unsigned char v2; empty v3; };
struct BFu17i_Ui_Sf { unsigned int v1:17; unsigned int v2; empty v3; };
struct BFu17i_Ul_Sf { unsigned int v1:17; unsigned long long v2; empty v3; };
struct BFu17i_Us_Sf { unsigned int v1:17; unsigned short v2; empty v3; };
struct BFu17i_Vp_Sf { unsigned int v1:17; void * v2; empty v3; };
struct BFu17ll_BFu15i_Sf { unsigned long long v1:17; unsigned int v2:15; empty v3; };
struct BFu17ll_BFu15ll_Sf { unsigned long long v1:17; unsigned long long v2:15; empty v3; };
struct BFu17ll_BFu15s_Sf { unsigned long long v1:17; unsigned short v2:15; empty v3; };
struct BFu17ll_BFu16i_Sf { unsigned long long v1:17; unsigned int v2:16; empty v3; };
struct BFu17ll_BFu16ll_Sf { unsigned long long v1:17; unsigned long long v2:16; empty v3; };
struct BFu17ll_BFu16s_Sf { unsigned long long v1:17; unsigned short v2:16; empty v3; };
struct BFu17ll_BFu17i_Sf { unsigned long long v1:17; unsigned int v2:17; empty v3; };
struct BFu17ll_BFu17ll_Sf { unsigned long long v1:17; unsigned long long v2:17; empty v3; };
struct BFu17ll_BFu1c_Sf { unsigned long long v1:17; unsigned char v2:1; empty v3; };
struct BFu17ll_BFu1i_Sf { unsigned long long v1:17; unsigned int v2:1; empty v3; };
struct BFu17ll_BFu1ll_Sf { unsigned long long v1:17; unsigned long long v2:1; empty v3; };
struct BFu17ll_BFu1s_Sf { unsigned long long v1:17; unsigned short v2:1; empty v3; };
struct BFu17ll_BFu31i_Sf { unsigned long long v1:17; unsigned int v2:31; empty v3; };
struct BFu17ll_BFu31ll_Sf { unsigned long long v1:17; unsigned long long v2:31; empty v3; };
struct BFu17ll_BFu32i_Sf { unsigned long long v1:17; unsigned int v2:32; empty v3; };
struct BFu17ll_BFu32ll_Sf { unsigned long long v1:17; unsigned long long v2:32; empty v3; };
struct BFu17ll_BFu33_Sf { unsigned long long v1:17; unsigned long long v2:33; empty v3; };
struct BFu17ll_BFu7c_Sf { unsigned long long v1:17; unsigned char v2:7; empty v3; };
struct BFu17ll_BFu7i_Sf { unsigned long long v1:17; unsigned int v2:7; empty v3; };
struct BFu17ll_BFu7ll_Sf { unsigned long long v1:17; unsigned long long v2:7; empty v3; };
struct BFu17ll_BFu7s_Sf { unsigned long long v1:17; unsigned short v2:7; empty v3; };
struct BFu17ll_BFu8c_Sf { unsigned long long v1:17; unsigned char v2:8; empty v3; };
struct BFu17ll_BFu8i_Sf { unsigned long long v1:17; unsigned int v2:8; empty v3; };
struct BFu17ll_BFu8ll_Sf { unsigned long long v1:17; unsigned long long v2:8; empty v3; };
struct BFu17ll_BFu8s_Sf { unsigned long long v1:17; unsigned short v2:8; empty v3; };
struct BFu17ll_BFu9i_Sf { unsigned long long v1:17; unsigned int v2:9; empty v3; };
struct BFu17ll_BFu9ll_Sf { unsigned long long v1:17; unsigned long long v2:9; empty v3; };
struct BFu17ll_BFu9s_Sf { unsigned long long v1:17; unsigned short v2:9; empty v3; };
struct BFu17ll_C_Sf { unsigned long long v1:17; char v2; empty v3; };
struct BFu17ll_D_Sf { unsigned long long v1:17; double v2; empty v3; };
struct BFu17ll_F_Sf { unsigned long long v1:17; float v2; empty v3; };
struct BFu17ll_I_Sf { unsigned long long v1:17; int v2; empty v3; };
struct BFu17ll_Ip_Sf { unsigned long long v1:17; int * v2; empty v3; };
struct BFu17ll_L_Sf { unsigned long long v1:17; long long v2; empty v3; };
struct BFu17ll_S_Sf { unsigned long long v1:17; short v2; empty v3; };
struct BFu17ll_Sf { unsigned long long v1:17; empty v2; };
struct BFu17ll_Sf_BFu15i { unsigned long long v1:17; empty v2; unsigned int v3:15; };
struct BFu17ll_Sf_BFu15ll { unsigned long long v1:17; empty v2; unsigned long long v3:15; };
struct BFu17ll_Sf_BFu15s { unsigned long long v1:17; empty v2; unsigned short v3:15; };
struct BFu17ll_Sf_BFu16i { unsigned long long v1:17; empty v2; unsigned int v3:16; };
struct BFu17ll_Sf_BFu16ll { unsigned long long v1:17; empty v2; unsigned long long v3:16; };
struct BFu17ll_Sf_BFu16s { unsigned long long v1:17; empty v2; unsigned short v3:16; };
struct BFu17ll_Sf_BFu17i { unsigned long long v1:17; empty v2; unsigned int v3:17; };
struct BFu17ll_Sf_BFu17ll { unsigned long long v1:17; empty v2; unsigned long long v3:17; };
struct BFu17ll_Sf_BFu1c { unsigned long long v1:17; empty v2; unsigned char v3:1; };
struct BFu17ll_Sf_BFu1i { unsigned long long v1:17; empty v2; unsigned int v3:1; };
struct BFu17ll_Sf_BFu1ll { unsigned long long v1:17; empty v2; unsigned long long v3:1; };
struct BFu17ll_Sf_BFu1s { unsigned long long v1:17; empty v2; unsigned short v3:1; };
struct BFu17ll_Sf_BFu31i { unsigned long long v1:17; empty v2; unsigned int v3:31; };
struct BFu17ll_Sf_BFu31ll { unsigned long long v1:17; empty v2; unsigned long long v3:31; };
struct BFu17ll_Sf_BFu32i { unsigned long long v1:17; empty v2; unsigned int v3:32; };
struct BFu17ll_Sf_BFu32ll { unsigned long long v1:17; empty v2; unsigned long long v3:32; };
struct BFu17ll_Sf_BFu33 { unsigned long long v1:17; empty v2; unsigned long long v3:33; };
struct BFu17ll_Sf_BFu7c { unsigned long long v1:17; empty v2; unsigned char v3:7; };
struct BFu17ll_Sf_BFu7i { unsigned long long v1:17; empty v2; unsigned int v3:7; };
struct BFu17ll_Sf_BFu7ll { unsigned long long v1:17; empty v2; unsigned long long v3:7; };
struct BFu17ll_Sf_BFu7s { unsigned long long v1:17; empty v2; unsigned short v3:7; };
struct BFu17ll_Sf_BFu8c { unsigned long long v1:17; empty v2; unsigned char v3:8; };
struct BFu17ll_Sf_BFu8i { unsigned long long v1:17; empty v2; unsigned int v3:8; };
struct BFu17ll_Sf_BFu8ll { unsigned long long v1:17; empty v2; unsigned long long v3:8; };
struct BFu17ll_Sf_BFu8s { unsigned long long v1:17; empty v2; unsigned short v3:8; };
struct BFu17ll_Sf_BFu9i { unsigned long long v1:17; empty v2; unsigned int v3:9; };
struct BFu17ll_Sf_BFu9ll { unsigned long long v1:17; empty v2; unsigned long long v3:9; };
struct BFu17ll_Sf_BFu9s { unsigned long long v1:17; empty v2; unsigned short v3:9; };
struct BFu17ll_Sf_C { unsigned long long v1:17; empty v2; char v3; };
struct BFu17ll_Sf_D { unsigned long long v1:17; empty v2; double v3; };
struct BFu17ll_Sf_F { unsigned long long v1:17; empty v2; float v3; };
struct BFu17ll_Sf_I { unsigned long long v1:17; empty v2; int v3; };
struct BFu17ll_Sf_Ip { unsigned long long v1:17; empty v2; int * v3; };
struct BFu17ll_Sf_L { unsigned long long v1:17; empty v2; long long v3; };
struct BFu17ll_Sf_S { unsigned long long v1:17; empty v2; short v3; };
struct BFu17ll_Sf_Sf { unsigned long long v1:17; empty v2; empty v3; };
struct BFu17ll_Sf_Uc { unsigned long long v1:17; empty v2; unsigned char v3; };
struct BFu17ll_Sf_Ui { unsigned long long v1:17; empty v2; unsigned int v3; };
struct BFu17ll_Sf_Ul { unsigned long long v1:17; empty v2; unsigned long long v3; };
struct BFu17ll_Sf_Us { unsigned long long v1:17; empty v2; unsigned short v3; };
struct BFu17ll_Sf_Vp { unsigned long long v1:17; empty v2; void * v3; };
struct BFu17ll_Uc_Sf { unsigned long long v1:17; unsigned char v2; empty v3; };
struct BFu17ll_Ui_Sf { unsigned long long v1:17; unsigned int v2; empty v3; };
struct BFu17ll_Ul_Sf { unsigned long long v1:17; unsigned long long v2; empty v3; };
struct BFu17ll_Us_Sf { unsigned long long v1:17; unsigned short v2; empty v3; };
struct BFu17ll_Vp_Sf { unsigned long long v1:17; void * v2; empty v3; };
struct BFu1c_BFu15i_Sf { unsigned char v1:1; unsigned int v2:15; empty v3; };
struct BFu1c_BFu15ll_Sf { unsigned char v1:1; unsigned long long v2:15; empty v3; };
struct BFu1c_BFu15s_Sf { unsigned char v1:1; unsigned short v2:15; empty v3; };
struct BFu1c_BFu16i_Sf { unsigned char v1:1; unsigned int v2:16; empty v3; };
struct BFu1c_BFu16ll_Sf { unsigned char v1:1; unsigned long long v2:16; empty v3; };
struct BFu1c_BFu16s_Sf { unsigned char v1:1; unsigned short v2:16; empty v3; };
struct BFu1c_BFu17i_Sf { unsigned char v1:1; unsigned int v2:17; empty v3; };
struct BFu1c_BFu17ll_Sf { unsigned char v1:1; unsigned long long v2:17; empty v3; };
struct BFu1c_BFu1c_Sf { unsigned char v1:1; unsigned char v2:1; empty v3; };
struct BFu1c_BFu1i_Sf { unsigned char v1:1; unsigned int v2:1; empty v3; };
struct BFu1c_BFu1ll_Sf { unsigned char v1:1; unsigned long long v2:1; empty v3; };
struct BFu1c_BFu1s_Sf { unsigned char v1:1; unsigned short v2:1; empty v3; };
struct BFu1c_BFu31i_Sf { unsigned char v1:1; unsigned int v2:31; empty v3; };
struct BFu1c_BFu31ll_Sf { unsigned char v1:1; unsigned long long v2:31; empty v3; };
struct BFu1c_BFu32i_Sf { unsigned char v1:1; unsigned int v2:32; empty v3; };
struct BFu1c_BFu32ll_Sf { unsigned char v1:1; unsigned long long v2:32; empty v3; };
struct BFu1c_BFu33_Sf { unsigned char v1:1; unsigned long long v2:33; empty v3; };
struct BFu1c_BFu7c_Sf { unsigned char v1:1; unsigned char v2:7; empty v3; };
struct BFu1c_BFu7i_Sf { unsigned char v1:1; unsigned int v2:7; empty v3; };
struct BFu1c_BFu7ll_Sf { unsigned char v1:1; unsigned long long v2:7; empty v3; };
struct BFu1c_BFu7s_Sf { unsigned char v1:1; unsigned short v2:7; empty v3; };
struct BFu1c_BFu8c_Sf { unsigned char v1:1; unsigned char v2:8; empty v3; };
struct BFu1c_BFu8i_Sf { unsigned char v1:1; unsigned int v2:8; empty v3; };
struct BFu1c_BFu8ll_Sf { unsigned char v1:1; unsigned long long v2:8; empty v3; };
struct BFu1c_BFu8s_Sf { unsigned char v1:1; unsigned short v2:8; empty v3; };
struct BFu1c_BFu9i_Sf { unsigned char v1:1; unsigned int v2:9; empty v3; };
struct BFu1c_BFu9ll_Sf { unsigned char v1:1; unsigned long long v2:9; empty v3; };
struct BFu1c_BFu9s_Sf { unsigned char v1:1; unsigned short v2:9; empty v3; };
struct BFu1c_C_Sf { unsigned char v1:1; char v2; empty v3; };
struct BFu1c_D_Sf { unsigned char v1:1; double v2; empty v3; };
struct BFu1c_F_Sf { unsigned char v1:1; float v2; empty v3; };
struct BFu1c_I_Sf { unsigned char v1:1; int v2; empty v3; };
struct BFu1c_Ip_Sf { unsigned char v1:1; int * v2; empty v3; };
struct BFu1c_L_Sf { unsigned char v1:1; long long v2; empty v3; };
struct BFu1c_S_Sf { unsigned char v1:1; short v2; empty v3; };
struct BFu1c_Sf { unsigned char v1:1; empty v2; };
struct BFu1c_Sf_BFu15i { unsigned char v1:1; empty v2; unsigned int v3:15; };
struct BFu1c_Sf_BFu15ll { unsigned char v1:1; empty v2; unsigned long long v3:15; };
struct BFu1c_Sf_BFu15s { unsigned char v1:1; empty v2; unsigned short v3:15; };
struct BFu1c_Sf_BFu16i { unsigned char v1:1; empty v2; unsigned int v3:16; };
struct BFu1c_Sf_BFu16ll { unsigned char v1:1; empty v2; unsigned long long v3:16; };
struct BFu1c_Sf_BFu16s { unsigned char v1:1; empty v2; unsigned short v3:16; };
struct BFu1c_Sf_BFu17i { unsigned char v1:1; empty v2; unsigned int v3:17; };
struct BFu1c_Sf_BFu17ll { unsigned char v1:1; empty v2; unsigned long long v3:17; };
struct BFu1c_Sf_BFu1c { unsigned char v1:1; empty v2; unsigned char v3:1; };
struct BFu1c_Sf_BFu1i { unsigned char v1:1; empty v2; unsigned int v3:1; };
struct BFu1c_Sf_BFu1ll { unsigned char v1:1; empty v2; unsigned long long v3:1; };
struct BFu1c_Sf_BFu1s { unsigned char v1:1; empty v2; unsigned short v3:1; };
struct BFu1c_Sf_BFu31i { unsigned char v1:1; empty v2; unsigned int v3:31; };
struct BFu1c_Sf_BFu31ll { unsigned char v1:1; empty v2; unsigned long long v3:31; };
struct BFu1c_Sf_BFu32i { unsigned char v1:1; empty v2; unsigned int v3:32; };
struct BFu1c_Sf_BFu32ll { unsigned char v1:1; empty v2; unsigned long long v3:32; };
struct BFu1c_Sf_BFu33 { unsigned char v1:1; empty v2; unsigned long long v3:33; };
struct BFu1c_Sf_BFu7c { unsigned char v1:1; empty v2; unsigned char v3:7; };
struct BFu1c_Sf_BFu7i { unsigned char v1:1; empty v2; unsigned int v3:7; };
struct BFu1c_Sf_BFu7ll { unsigned char v1:1; empty v2; unsigned long long v3:7; };
struct BFu1c_Sf_BFu7s { unsigned char v1:1; empty v2; unsigned short v3:7; };
struct BFu1c_Sf_BFu8c { unsigned char v1:1; empty v2; unsigned char v3:8; };
struct BFu1c_Sf_BFu8i { unsigned char v1:1; empty v2; unsigned int v3:8; };
struct BFu1c_Sf_BFu8ll { unsigned char v1:1; empty v2; unsigned long long v3:8; };
struct BFu1c_Sf_BFu8s { unsigned char v1:1; empty v2; unsigned short v3:8; };
struct BFu1c_Sf_BFu9i { unsigned char v1:1; empty v2; unsigned int v3:9; };
struct BFu1c_Sf_BFu9ll { unsigned char v1:1; empty v2; unsigned long long v3:9; };
struct BFu1c_Sf_BFu9s { unsigned char v1:1; empty v2; unsigned short v3:9; };
struct BFu1c_Sf_C { unsigned char v1:1; empty v2; char v3; };
struct BFu1c_Sf_D { unsigned char v1:1; empty v2; double v3; };
struct BFu1c_Sf_F { unsigned char v1:1; empty v2; float v3; };
struct BFu1c_Sf_I { unsigned char v1:1; empty v2; int v3; };
struct BFu1c_Sf_Ip { unsigned char v1:1; empty v2; int * v3; };
struct BFu1c_Sf_L { unsigned char v1:1; empty v2; long long v3; };
struct BFu1c_Sf_S { unsigned char v1:1; empty v2; short v3; };
struct BFu1c_Sf_Sf { unsigned char v1:1; empty v2; empty v3; };
struct BFu1c_Sf_Uc { unsigned char v1:1; empty v2; unsigned char v3; };
struct BFu1c_Sf_Ui { unsigned char v1:1; empty v2; unsigned int v3; };
struct BFu1c_Sf_Ul { unsigned char v1:1; empty v2; unsigned long long v3; };
struct BFu1c_Sf_Us { unsigned char v1:1; empty v2; unsigned short v3; };
struct BFu1c_Sf_Vp { unsigned char v1:1; empty v2; void * v3; };
struct BFu1c_Uc_Sf { unsigned char v1:1; unsigned char v2; empty v3; };
struct BFu1c_Ui_Sf { unsigned char v1:1; unsigned int v2; empty v3; };
struct BFu1c_Ul_Sf { unsigned char v1:1; unsigned long long v2; empty v3; };
struct BFu1c_Us_Sf { unsigned char v1:1; unsigned short v2; empty v3; };
struct BFu1c_Vp_Sf { unsigned char v1:1; void * v2; empty v3; };
struct BFu1i_BFu15i_Sf { unsigned int v1:1; unsigned int v2:15; empty v3; };
struct BFu1i_BFu15ll_Sf { unsigned int v1:1; unsigned long long v2:15; empty v3; };
struct BFu1i_BFu15s_Sf { unsigned int v1:1; unsigned short v2:15; empty v3; };
struct BFu1i_BFu16i_Sf { unsigned int v1:1; unsigned int v2:16; empty v3; };
struct BFu1i_BFu16ll_Sf { unsigned int v1:1; unsigned long long v2:16; empty v3; };
struct BFu1i_BFu16s_Sf { unsigned int v1:1; unsigned short v2:16; empty v3; };
struct BFu1i_BFu17i_Sf { unsigned int v1:1; unsigned int v2:17; empty v3; };
struct BFu1i_BFu17ll_Sf { unsigned int v1:1; unsigned long long v2:17; empty v3; };
struct BFu1i_BFu1c_Sf { unsigned int v1:1; unsigned char v2:1; empty v3; };
struct BFu1i_BFu1i_Sf { unsigned int v1:1; unsigned int v2:1; empty v3; };
struct BFu1i_BFu1ll_Sf { unsigned int v1:1; unsigned long long v2:1; empty v3; };
struct BFu1i_BFu1s_Sf { unsigned int v1:1; unsigned short v2:1; empty v3; };
struct BFu1i_BFu31i_Sf { unsigned int v1:1; unsigned int v2:31; empty v3; };
struct BFu1i_BFu31ll_Sf { unsigned int v1:1; unsigned long long v2:31; empty v3; };
struct BFu1i_BFu32i_Sf { unsigned int v1:1; unsigned int v2:32; empty v3; };
struct BFu1i_BFu32ll_Sf { unsigned int v1:1; unsigned long long v2:32; empty v3; };
struct BFu1i_BFu33_Sf { unsigned int v1:1; unsigned long long v2:33; empty v3; };
struct BFu1i_BFu7c_Sf { unsigned int v1:1; unsigned char v2:7; empty v3; };
struct BFu1i_BFu7i_Sf { unsigned int v1:1; unsigned int v2:7; empty v3; };
struct BFu1i_BFu7ll_Sf { unsigned int v1:1; unsigned long long v2:7; empty v3; };
struct BFu1i_BFu7s_Sf { unsigned int v1:1; unsigned short v2:7; empty v3; };
struct BFu1i_BFu8c_Sf { unsigned int v1:1; unsigned char v2:8; empty v3; };
struct BFu1i_BFu8i_Sf { unsigned int v1:1; unsigned int v2:8; empty v3; };
struct BFu1i_BFu8ll_Sf { unsigned int v1:1; unsigned long long v2:8; empty v3; };
struct BFu1i_BFu8s_Sf { unsigned int v1:1; unsigned short v2:8; empty v3; };
struct BFu1i_BFu9i_Sf { unsigned int v1:1; unsigned int v2:9; empty v3; };
struct BFu1i_BFu9ll_Sf { unsigned int v1:1; unsigned long long v2:9; empty v3; };
struct BFu1i_BFu9s_Sf { unsigned int v1:1; unsigned short v2:9; empty v3; };
struct BFu1i_C_Sf { unsigned int v1:1; char v2; empty v3; };
struct BFu1i_D_Sf { unsigned int v1:1; double v2; empty v3; };
struct BFu1i_F_Sf { unsigned int v1:1; float v2; empty v3; };
struct BFu1i_I_Sf { unsigned int v1:1; int v2; empty v3; };
struct BFu1i_Ip_Sf { unsigned int v1:1; int * v2; empty v3; };
struct BFu1i_L_Sf { unsigned int v1:1; long long v2; empty v3; };
struct BFu1i_S_Sf { unsigned int v1:1; short v2; empty v3; };
struct BFu1i_Sf { unsigned int v1:1; empty v2; };
struct BFu1i_Sf_BFu15i { unsigned int v1:1; empty v2; unsigned int v3:15; };
struct BFu1i_Sf_BFu15ll { unsigned int v1:1; empty v2; unsigned long long v3:15; };
struct BFu1i_Sf_BFu15s { unsigned int v1:1; empty v2; unsigned short v3:15; };
struct BFu1i_Sf_BFu16i { unsigned int v1:1; empty v2; unsigned int v3:16; };
struct BFu1i_Sf_BFu16ll { unsigned int v1:1; empty v2; unsigned long long v3:16; };
struct BFu1i_Sf_BFu16s { unsigned int v1:1; empty v2; unsigned short v3:16; };
struct BFu1i_Sf_BFu17i { unsigned int v1:1; empty v2; unsigned int v3:17; };
struct BFu1i_Sf_BFu17ll { unsigned int v1:1; empty v2; unsigned long long v3:17; };
struct BFu1i_Sf_BFu1c { unsigned int v1:1; empty v2; unsigned char v3:1; };
struct BFu1i_Sf_BFu1i { unsigned int v1:1; empty v2; unsigned int v3:1; };
struct BFu1i_Sf_BFu1ll { unsigned int v1:1; empty v2; unsigned long long v3:1; };
struct BFu1i_Sf_BFu1s { unsigned int v1:1; empty v2; unsigned short v3:1; };
struct BFu1i_Sf_BFu31i { unsigned int v1:1; empty v2; unsigned int v3:31; };
struct BFu1i_Sf_BFu31ll { unsigned int v1:1; empty v2; unsigned long long v3:31; };
struct BFu1i_Sf_BFu32i { unsigned int v1:1; empty v2; unsigned int v3:32; };
struct BFu1i_Sf_BFu32ll { unsigned int v1:1; empty v2; unsigned long long v3:32; };
struct BFu1i_Sf_BFu33 { unsigned int v1:1; empty v2; unsigned long long v3:33; };
struct BFu1i_Sf_BFu7c { unsigned int v1:1; empty v2; unsigned char v3:7; };
struct BFu1i_Sf_BFu7i { unsigned int v1:1; empty v2; unsigned int v3:7; };
struct BFu1i_Sf_BFu7ll { unsigned int v1:1; empty v2; unsigned long long v3:7; };
struct BFu1i_Sf_BFu7s { unsigned int v1:1; empty v2; unsigned short v3:7; };
struct BFu1i_Sf_BFu8c { unsigned int v1:1; empty v2; unsigned char v3:8; };
struct BFu1i_Sf_BFu8i { unsigned int v1:1; empty v2; unsigned int v3:8; };
struct BFu1i_Sf_BFu8ll { unsigned int v1:1; empty v2; unsigned long long v3:8; };
struct BFu1i_Sf_BFu8s { unsigned int v1:1; empty v2; unsigned short v3:8; };
struct BFu1i_Sf_BFu9i { unsigned int v1:1; empty v2; unsigned int v3:9; };
struct BFu1i_Sf_BFu9ll { unsigned int v1:1; empty v2; unsigned long long v3:9; };
struct BFu1i_Sf_BFu9s { unsigned int v1:1; empty v2; unsigned short v3:9; };
struct BFu1i_Sf_C { unsigned int v1:1; empty v2; char v3; };
struct BFu1i_Sf_D { unsigned int v1:1; empty v2; double v3; };
struct BFu1i_Sf_F { unsigned int v1:1; empty v2; float v3; };
struct BFu1i_Sf_I { unsigned int v1:1; empty v2; int v3; };
struct BFu1i_Sf_Ip { unsigned int v1:1; empty v2; int * v3; };
struct BFu1i_Sf_L { unsigned int v1:1; empty v2; long long v3; };
struct BFu1i_Sf_S { unsigned int v1:1; empty v2; short v3; };
struct BFu1i_Sf_Sf { unsigned int v1:1; empty v2; empty v3; };
struct BFu1i_Sf_Uc { unsigned int v1:1; empty v2; unsigned char v3; };
struct BFu1i_Sf_Ui { unsigned int v1:1; empty v2; unsigned int v3; };
struct BFu1i_Sf_Ul { unsigned int v1:1; empty v2; unsigned long long v3; };
struct BFu1i_Sf_Us { unsigned int v1:1; empty v2; unsigned short v3; };
struct BFu1i_Sf_Vp { unsigned int v1:1; empty v2; void * v3; };
struct BFu1i_Uc_Sf { unsigned int v1:1; unsigned char v2; empty v3; };
struct BFu1i_Ui_Sf { unsigned int v1:1; unsigned int v2; empty v3; };
struct BFu1i_Ul_Sf { unsigned int v1:1; unsigned long long v2; empty v3; };
struct BFu1i_Us_Sf { unsigned int v1:1; unsigned short v2; empty v3; };
struct BFu1i_Vp_Sf { unsigned int v1:1; void * v2; empty v3; };
struct BFu1ll_BFu15i_Sf { unsigned long long v1:1; unsigned int v2:15; empty v3; };
struct BFu1ll_BFu15ll_Sf { unsigned long long v1:1; unsigned long long v2:15; empty v3; };
struct BFu1ll_BFu15s_Sf { unsigned long long v1:1; unsigned short v2:15; empty v3; };
struct BFu1ll_BFu16i_Sf { unsigned long long v1:1; unsigned int v2:16; empty v3; };
struct BFu1ll_BFu16ll_Sf { unsigned long long v1:1; unsigned long long v2:16; empty v3; };
struct BFu1ll_BFu16s_Sf { unsigned long long v1:1; unsigned short v2:16; empty v3; };
struct BFu1ll_BFu17i_Sf { unsigned long long v1:1; unsigned int v2:17; empty v3; };
struct BFu1ll_BFu17ll_Sf { unsigned long long v1:1; unsigned long long v2:17; empty v3; };
struct BFu1ll_BFu1c_Sf { unsigned long long v1:1; unsigned char v2:1; empty v3; };
struct BFu1ll_BFu1i_Sf { unsigned long long v1:1; unsigned int v2:1; empty v3; };
struct BFu1ll_BFu1ll_Sf { unsigned long long v1:1; unsigned long long v2:1; empty v3; };
struct BFu1ll_BFu1s_Sf { unsigned long long v1:1; unsigned short v2:1; empty v3; };
struct BFu1ll_BFu31i_Sf { unsigned long long v1:1; unsigned int v2:31; empty v3; };
struct BFu1ll_BFu31ll_Sf { unsigned long long v1:1; unsigned long long v2:31; empty v3; };
struct BFu1ll_BFu32i_Sf { unsigned long long v1:1; unsigned int v2:32; empty v3; };
struct BFu1ll_BFu32ll_Sf { unsigned long long v1:1; unsigned long long v2:32; empty v3; };
struct BFu1ll_BFu33_Sf { unsigned long long v1:1; unsigned long long v2:33; empty v3; };
struct BFu1ll_BFu7c_Sf { unsigned long long v1:1; unsigned char v2:7; empty v3; };
struct BFu1ll_BFu7i_Sf { unsigned long long v1:1; unsigned int v2:7; empty v3; };
struct BFu1ll_BFu7ll_Sf { unsigned long long v1:1; unsigned long long v2:7; empty v3; };
struct BFu1ll_BFu7s_Sf { unsigned long long v1:1; unsigned short v2:7; empty v3; };
struct BFu1ll_BFu8c_Sf { unsigned long long v1:1; unsigned char v2:8; empty v3; };
struct BFu1ll_BFu8i_Sf { unsigned long long v1:1; unsigned int v2:8; empty v3; };
struct BFu1ll_BFu8ll_Sf { unsigned long long v1:1; unsigned long long v2:8; empty v3; };
struct BFu1ll_BFu8s_Sf { unsigned long long v1:1; unsigned short v2:8; empty v3; };
struct BFu1ll_BFu9i_Sf { unsigned long long v1:1; unsigned int v2:9; empty v3; };
struct BFu1ll_BFu9ll_Sf { unsigned long long v1:1; unsigned long long v2:9; empty v3; };
struct BFu1ll_BFu9s_Sf { unsigned long long v1:1; unsigned short v2:9; empty v3; };
struct BFu1ll_C_Sf { unsigned long long v1:1; char v2; empty v3; };
struct BFu1ll_D_Sf { unsigned long long v1:1; double v2; empty v3; };
struct BFu1ll_F_Sf { unsigned long long v1:1; float v2; empty v3; };
struct BFu1ll_I_Sf { unsigned long long v1:1; int v2; empty v3; };
struct BFu1ll_Ip_Sf { unsigned long long v1:1; int * v2; empty v3; };
struct BFu1ll_L_Sf { unsigned long long v1:1; long long v2; empty v3; };
struct BFu1ll_S_Sf { unsigned long long v1:1; short v2; empty v3; };
struct BFu1ll_Sf { unsigned long long v1:1; empty v2; };
struct BFu1ll_Sf_BFu15i { unsigned long long v1:1; empty v2; unsigned int v3:15; };
struct BFu1ll_Sf_BFu15ll { unsigned long long v1:1; empty v2; unsigned long long v3:15; };
struct BFu1ll_Sf_BFu15s { unsigned long long v1:1; empty v2; unsigned short v3:15; };
struct BFu1ll_Sf_BFu16i { unsigned long long v1:1; empty v2; unsigned int v3:16; };
struct BFu1ll_Sf_BFu16ll { unsigned long long v1:1; empty v2; unsigned long long v3:16; };
struct BFu1ll_Sf_BFu16s { unsigned long long v1:1; empty v2; unsigned short v3:16; };
struct BFu1ll_Sf_BFu17i { unsigned long long v1:1; empty v2; unsigned int v3:17; };
struct BFu1ll_Sf_BFu17ll { unsigned long long v1:1; empty v2; unsigned long long v3:17; };
struct BFu1ll_Sf_BFu1c { unsigned long long v1:1; empty v2; unsigned char v3:1; };
struct BFu1ll_Sf_BFu1i { unsigned long long v1:1; empty v2; unsigned int v3:1; };
struct BFu1ll_Sf_BFu1ll { unsigned long long v1:1; empty v2; unsigned long long v3:1; };
struct BFu1ll_Sf_BFu1s { unsigned long long v1:1; empty v2; unsigned short v3:1; };
struct BFu1ll_Sf_BFu31i { unsigned long long v1:1; empty v2; unsigned int v3:31; };
struct BFu1ll_Sf_BFu31ll { unsigned long long v1:1; empty v2; unsigned long long v3:31; };
struct BFu1ll_Sf_BFu32i { unsigned long long v1:1; empty v2; unsigned int v3:32; };
struct BFu1ll_Sf_BFu32ll { unsigned long long v1:1; empty v2; unsigned long long v3:32; };
struct BFu1ll_Sf_BFu33 { unsigned long long v1:1; empty v2; unsigned long long v3:33; };
struct BFu1ll_Sf_BFu7c { unsigned long long v1:1; empty v2; unsigned char v3:7; };
struct BFu1ll_Sf_BFu7i { unsigned long long v1:1; empty v2; unsigned int v3:7; };
struct BFu1ll_Sf_BFu7ll { unsigned long long v1:1; empty v2; unsigned long long v3:7; };
struct BFu1ll_Sf_BFu7s { unsigned long long v1:1; empty v2; unsigned short v3:7; };
struct BFu1ll_Sf_BFu8c { unsigned long long v1:1; empty v2; unsigned char v3:8; };
struct BFu1ll_Sf_BFu8i { unsigned long long v1:1; empty v2; unsigned int v3:8; };
struct BFu1ll_Sf_BFu8ll { unsigned long long v1:1; empty v2; unsigned long long v3:8; };
struct BFu1ll_Sf_BFu8s { unsigned long long v1:1; empty v2; unsigned short v3:8; };
struct BFu1ll_Sf_BFu9i { unsigned long long v1:1; empty v2; unsigned int v3:9; };
struct BFu1ll_Sf_BFu9ll { unsigned long long v1:1; empty v2; unsigned long long v3:9; };
struct BFu1ll_Sf_BFu9s { unsigned long long v1:1; empty v2; unsigned short v3:9; };
struct BFu1ll_Sf_C { unsigned long long v1:1; empty v2; char v3; };
struct BFu1ll_Sf_D { unsigned long long v1:1; empty v2; double v3; };
struct BFu1ll_Sf_F { unsigned long long v1:1; empty v2; float v3; };
struct BFu1ll_Sf_I { unsigned long long v1:1; empty v2; int v3; };
struct BFu1ll_Sf_Ip { unsigned long long v1:1; empty v2; int * v3; };
struct BFu1ll_Sf_L { unsigned long long v1:1; empty v2; long long v3; };
struct BFu1ll_Sf_S { unsigned long long v1:1; empty v2; short v3; };
struct BFu1ll_Sf_Sf { unsigned long long v1:1; empty v2; empty v3; };
struct BFu1ll_Sf_Uc { unsigned long long v1:1; empty v2; unsigned char v3; };
struct BFu1ll_Sf_Ui { unsigned long long v1:1; empty v2; unsigned int v3; };
struct BFu1ll_Sf_Ul { unsigned long long v1:1; empty v2; unsigned long long v3; };
struct BFu1ll_Sf_Us { unsigned long long v1:1; empty v2; unsigned short v3; };
struct BFu1ll_Sf_Vp { unsigned long long v1:1; empty v2; void * v3; };
struct BFu1ll_Uc_Sf { unsigned long long v1:1; unsigned char v2; empty v3; };
struct BFu1ll_Ui_Sf { unsigned long long v1:1; unsigned int v2; empty v3; };
struct BFu1ll_Ul_Sf { unsigned long long v1:1; unsigned long long v2; empty v3; };
struct BFu1ll_Us_Sf { unsigned long long v1:1; unsigned short v2; empty v3; };
struct BFu1ll_Vp_Sf { unsigned long long v1:1; void * v2; empty v3; };
struct BFu1s_BFu15i_Sf { unsigned short v1:1; unsigned int v2:15; empty v3; };
struct BFu1s_BFu15ll_Sf { unsigned short v1:1; unsigned long long v2:15; empty v3; };
struct BFu1s_BFu15s_Sf { unsigned short v1:1; unsigned short v2:15; empty v3; };
struct BFu1s_BFu16i_Sf { unsigned short v1:1; unsigned int v2:16; empty v3; };
struct BFu1s_BFu16ll_Sf { unsigned short v1:1; unsigned long long v2:16; empty v3; };
struct BFu1s_BFu16s_Sf { unsigned short v1:1; unsigned short v2:16; empty v3; };
struct BFu1s_BFu17i_Sf { unsigned short v1:1; unsigned int v2:17; empty v3; };
struct BFu1s_BFu17ll_Sf { unsigned short v1:1; unsigned long long v2:17; empty v3; };
struct BFu1s_BFu1c_Sf { unsigned short v1:1; unsigned char v2:1; empty v3; };
struct BFu1s_BFu1i_Sf { unsigned short v1:1; unsigned int v2:1; empty v3; };
struct BFu1s_BFu1ll_Sf { unsigned short v1:1; unsigned long long v2:1; empty v3; };
struct BFu1s_BFu1s_Sf { unsigned short v1:1; unsigned short v2:1; empty v3; };
struct BFu1s_BFu31i_Sf { unsigned short v1:1; unsigned int v2:31; empty v3; };
struct BFu1s_BFu31ll_Sf { unsigned short v1:1; unsigned long long v2:31; empty v3; };
struct BFu1s_BFu32i_Sf { unsigned short v1:1; unsigned int v2:32; empty v3; };
struct BFu1s_BFu32ll_Sf { unsigned short v1:1; unsigned long long v2:32; empty v3; };
struct BFu1s_BFu33_Sf { unsigned short v1:1; unsigned long long v2:33; empty v3; };
struct BFu1s_BFu7c_Sf { unsigned short v1:1; unsigned char v2:7; empty v3; };
struct BFu1s_BFu7i_Sf { unsigned short v1:1; unsigned int v2:7; empty v3; };
struct BFu1s_BFu7ll_Sf { unsigned short v1:1; unsigned long long v2:7; empty v3; };
struct BFu1s_BFu7s_Sf { unsigned short v1:1; unsigned short v2:7; empty v3; };
struct BFu1s_BFu8c_Sf { unsigned short v1:1; unsigned char v2:8; empty v3; };
struct BFu1s_BFu8i_Sf { unsigned short v1:1; unsigned int v2:8; empty v3; };
struct BFu1s_BFu8ll_Sf { unsigned short v1:1; unsigned long long v2:8; empty v3; };
struct BFu1s_BFu8s_Sf { unsigned short v1:1; unsigned short v2:8; empty v3; };
struct BFu1s_BFu9i_Sf { unsigned short v1:1; unsigned int v2:9; empty v3; };
struct BFu1s_BFu9ll_Sf { unsigned short v1:1; unsigned long long v2:9; empty v3; };
struct BFu1s_BFu9s_Sf { unsigned short v1:1; unsigned short v2:9; empty v3; };
struct BFu1s_C_Sf { unsigned short v1:1; char v2; empty v3; };
struct BFu1s_D_Sf { unsigned short v1:1; double v2; empty v3; };
struct BFu1s_F_Sf { unsigned short v1:1; float v2; empty v3; };
struct BFu1s_I_Sf { unsigned short v1:1; int v2; empty v3; };
struct BFu1s_Ip_Sf { unsigned short v1:1; int * v2; empty v3; };
struct BFu1s_L_Sf { unsigned short v1:1; long long v2; empty v3; };
struct BFu1s_S_Sf { unsigned short v1:1; short v2; empty v3; };
struct BFu1s_Sf { unsigned short v1:1; empty v2; };
struct BFu1s_Sf_BFu15i { unsigned short v1:1; empty v2; unsigned int v3:15; };
struct BFu1s_Sf_BFu15ll { unsigned short v1:1; empty v2; unsigned long long v3:15; };
struct BFu1s_Sf_BFu15s { unsigned short v1:1; empty v2; unsigned short v3:15; };
struct BFu1s_Sf_BFu16i { unsigned short v1:1; empty v2; unsigned int v3:16; };
struct BFu1s_Sf_BFu16ll { unsigned short v1:1; empty v2; unsigned long long v3:16; };
struct BFu1s_Sf_BFu16s { unsigned short v1:1; empty v2; unsigned short v3:16; };
struct BFu1s_Sf_BFu17i { unsigned short v1:1; empty v2; unsigned int v3:17; };
struct BFu1s_Sf_BFu17ll { unsigned short v1:1; empty v2; unsigned long long v3:17; };
struct BFu1s_Sf_BFu1c { unsigned short v1:1; empty v2; unsigned char v3:1; };
struct BFu1s_Sf_BFu1i { unsigned short v1:1; empty v2; unsigned int v3:1; };
struct BFu1s_Sf_BFu1ll { unsigned short v1:1; empty v2; unsigned long long v3:1; };
struct BFu1s_Sf_BFu1s { unsigned short v1:1; empty v2; unsigned short v3:1; };
struct BFu1s_Sf_BFu31i { unsigned short v1:1; empty v2; unsigned int v3:31; };
struct BFu1s_Sf_BFu31ll { unsigned short v1:1; empty v2; unsigned long long v3:31; };
struct BFu1s_Sf_BFu32i { unsigned short v1:1; empty v2; unsigned int v3:32; };
struct BFu1s_Sf_BFu32ll { unsigned short v1:1; empty v2; unsigned long long v3:32; };
struct BFu1s_Sf_BFu33 { unsigned short v1:1; empty v2; unsigned long long v3:33; };
struct BFu1s_Sf_BFu7c { unsigned short v1:1; empty v2; unsigned char v3:7; };
struct BFu1s_Sf_BFu7i { unsigned short v1:1; empty v2; unsigned int v3:7; };
struct BFu1s_Sf_BFu7ll { unsigned short v1:1; empty v2; unsigned long long v3:7; };
struct BFu1s_Sf_BFu7s { unsigned short v1:1; empty v2; unsigned short v3:7; };
struct BFu1s_Sf_BFu8c { unsigned short v1:1; empty v2; unsigned char v3:8; };
struct BFu1s_Sf_BFu8i { unsigned short v1:1; empty v2; unsigned int v3:8; };
struct BFu1s_Sf_BFu8ll { unsigned short v1:1; empty v2; unsigned long long v3:8; };
struct BFu1s_Sf_BFu8s { unsigned short v1:1; empty v2; unsigned short v3:8; };
struct BFu1s_Sf_BFu9i { unsigned short v1:1; empty v2; unsigned int v3:9; };
struct BFu1s_Sf_BFu9ll { unsigned short v1:1; empty v2; unsigned long long v3:9; };
struct BFu1s_Sf_BFu9s { unsigned short v1:1; empty v2; unsigned short v3:9; };
struct BFu1s_Sf_C { unsigned short v1:1; empty v2; char v3; };
struct BFu1s_Sf_D { unsigned short v1:1; empty v2; double v3; };
struct BFu1s_Sf_F { unsigned short v1:1; empty v2; float v3; };
struct BFu1s_Sf_I { unsigned short v1:1; empty v2; int v3; };
struct BFu1s_Sf_Ip { unsigned short v1:1; empty v2; int * v3; };
struct BFu1s_Sf_L { unsigned short v1:1; empty v2; long long v3; };
struct BFu1s_Sf_S { unsigned short v1:1; empty v2; short v3; };
struct BFu1s_Sf_Sf { unsigned short v1:1; empty v2; empty v3; };
struct BFu1s_Sf_Uc { unsigned short v1:1; empty v2; unsigned char v3; };
struct BFu1s_Sf_Ui { unsigned short v1:1; empty v2; unsigned int v3; };
struct BFu1s_Sf_Ul { unsigned short v1:1; empty v2; unsigned long long v3; };
struct BFu1s_Sf_Us { unsigned short v1:1; empty v2; unsigned short v3; };
struct BFu1s_Sf_Vp { unsigned short v1:1; empty v2; void * v3; };
struct BFu1s_Uc_Sf { unsigned short v1:1; unsigned char v2; empty v3; };
struct BFu1s_Ui_Sf { unsigned short v1:1; unsigned int v2; empty v3; };
struct BFu1s_Ul_Sf { unsigned short v1:1; unsigned long long v2; empty v3; };
struct BFu1s_Us_Sf { unsigned short v1:1; unsigned short v2; empty v3; };
struct BFu1s_Vp_Sf { unsigned short v1:1; void * v2; empty v3; };
struct BFu31i_BFu15i_Sf { unsigned int v1:31; unsigned int v2:15; empty v3; };
struct BFu31i_BFu15ll_Sf { unsigned int v1:31; unsigned long long v2:15; empty v3; };
struct BFu31i_BFu15s_Sf { unsigned int v1:31; unsigned short v2:15; empty v3; };
struct BFu31i_BFu16i_Sf { unsigned int v1:31; unsigned int v2:16; empty v3; };
struct BFu31i_BFu16ll_Sf { unsigned int v1:31; unsigned long long v2:16; empty v3; };
struct BFu31i_BFu16s_Sf { unsigned int v1:31; unsigned short v2:16; empty v3; };
struct BFu31i_BFu17i_Sf { unsigned int v1:31; unsigned int v2:17; empty v3; };
struct BFu31i_BFu17ll_Sf { unsigned int v1:31; unsigned long long v2:17; empty v3; };
struct BFu31i_BFu1c_Sf { unsigned int v1:31; unsigned char v2:1; empty v3; };
struct BFu31i_BFu1i_Sf { unsigned int v1:31; unsigned int v2:1; empty v3; };
struct BFu31i_BFu1ll_Sf { unsigned int v1:31; unsigned long long v2:1; empty v3; };
struct BFu31i_BFu1s_Sf { unsigned int v1:31; unsigned short v2:1; empty v3; };
struct BFu31i_BFu31i_Sf { unsigned int v1:31; unsigned int v2:31; empty v3; };
#endif // __cplusplus
#ifdef __cplusplus


static void Test_empty()
{
  {
    init_simple_test("empty");
    empty lv;
    check2(sizeof(lv), 1, "sizeof(empty)");
    check2(__alignof__(lv), 1, "__alignof__(empty)");
  }
}
static Arrange_To_Call_Me vempty(Test_empty, "empty", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu15s()
{
  {
    init_simple_test("aSf_BFu16i_BFu15s");
    static aSf_BFu16i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aSf_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aSf_BFu16i_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu15s(Test_aSf_BFu16i_BFu15s, "aSf_BFu16i_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu16i()
{
  {
    init_simple_test("aSf_BFu16i_BFu16i");
    static aSf_BFu16i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aSf_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu16i(Test_aSf_BFu16i_BFu16i, "aSf_BFu16i_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu16ll()
{
  {
    init_simple_test("aSf_BFu16i_BFu16ll");
    static aSf_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aSf_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu16ll(Test_aSf_BFu16i_BFu16ll, "aSf_BFu16i_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu16s()
{
  {
    init_simple_test("aSf_BFu16i_BFu16s");
    static aSf_BFu16i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aSf_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu16s(Test_aSf_BFu16i_BFu16s, "aSf_BFu16i_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu17i()
{
  {
    init_simple_test("aSf_BFu16i_BFu17i");
    static aSf_BFu16i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu16i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aSf_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aSf_BFu16i_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu17i(Test_aSf_BFu16i_BFu17i, "aSf_BFu16i_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu17ll()
{
  {
    init_simple_test("aSf_BFu16i_BFu17ll");
    static aSf_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu16i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aSf_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aSf_BFu16i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu17ll(Test_aSf_BFu16i_BFu17ll, "aSf_BFu16i_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu1c()
{
  {
    init_simple_test("aSf_BFu16i_BFu1c");
    static aSf_BFu16i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aSf_BFu16i_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu1c(Test_aSf_BFu16i_BFu1c, "aSf_BFu16i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu1i()
{
  {
    init_simple_test("aSf_BFu16i_BFu1i");
    static aSf_BFu16i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aSf_BFu16i_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu1i(Test_aSf_BFu16i_BFu1i, "aSf_BFu16i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu1ll()
{
  {
    init_simple_test("aSf_BFu16i_BFu1ll");
    static aSf_BFu16i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aSf_BFu16i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu1ll(Test_aSf_BFu16i_BFu1ll, "aSf_BFu16i_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu1s()
{
  {
    init_simple_test("aSf_BFu16i_BFu1s");
    static aSf_BFu16i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aSf_BFu16i_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu1s(Test_aSf_BFu16i_BFu1s, "aSf_BFu16i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu31i()
{
  {
    init_simple_test("aSf_BFu16i_BFu31i");
    static aSf_BFu16i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aSf_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aSf_BFu16i_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu31i(Test_aSf_BFu16i_BFu31i, "aSf_BFu16i_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu31ll()
{
  {
    init_simple_test("aSf_BFu16i_BFu31ll");
    static aSf_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aSf_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aSf_BFu16i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu31ll(Test_aSf_BFu16i_BFu31ll, "aSf_BFu16i_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu32i()
{
  {
    init_simple_test("aSf_BFu16i_BFu32i");
    static aSf_BFu16i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aSf_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aSf_BFu16i_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu32i(Test_aSf_BFu16i_BFu32i, "aSf_BFu16i_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu32ll()
{
  {
    init_simple_test("aSf_BFu16i_BFu32ll");
    static aSf_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aSf_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aSf_BFu16i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu32ll(Test_aSf_BFu16i_BFu32ll, "aSf_BFu16i_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu33()
{
  {
    init_simple_test("aSf_BFu16i_BFu33");
    static aSf_BFu16i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu16i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aSf_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aSf_BFu16i_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu33(Test_aSf_BFu16i_BFu33, "aSf_BFu16i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu7c()
{
  {
    init_simple_test("aSf_BFu16i_BFu7c");
    static aSf_BFu16i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aSf_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aSf_BFu16i_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu7c(Test_aSf_BFu16i_BFu7c, "aSf_BFu16i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu7i()
{
  {
    init_simple_test("aSf_BFu16i_BFu7i");
    static aSf_BFu16i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aSf_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aSf_BFu16i_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu7i(Test_aSf_BFu16i_BFu7i, "aSf_BFu16i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu7ll()
{
  {
    init_simple_test("aSf_BFu16i_BFu7ll");
    static aSf_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aSf_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aSf_BFu16i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu7ll(Test_aSf_BFu16i_BFu7ll, "aSf_BFu16i_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu7s()
{
  {
    init_simple_test("aSf_BFu16i_BFu7s");
    static aSf_BFu16i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aSf_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aSf_BFu16i_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu7s(Test_aSf_BFu16i_BFu7s, "aSf_BFu16i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu8c()
{
  {
    init_simple_test("aSf_BFu16i_BFu8c");
    static aSf_BFu16i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aSf_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aSf_BFu16i_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu8c(Test_aSf_BFu16i_BFu8c, "aSf_BFu16i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu8i()
{
  {
    init_simple_test("aSf_BFu16i_BFu8i");
    static aSf_BFu16i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aSf_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aSf_BFu16i_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu8i(Test_aSf_BFu16i_BFu8i, "aSf_BFu16i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu8ll()
{
  {
    init_simple_test("aSf_BFu16i_BFu8ll");
    static aSf_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aSf_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aSf_BFu16i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu8ll(Test_aSf_BFu16i_BFu8ll, "aSf_BFu16i_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu8s()
{
  {
    init_simple_test("aSf_BFu16i_BFu8s");
    static aSf_BFu16i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aSf_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aSf_BFu16i_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu8s(Test_aSf_BFu16i_BFu8s, "aSf_BFu16i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu9i()
{
  {
    init_simple_test("aSf_BFu16i_BFu9i");
    static aSf_BFu16i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aSf_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aSf_BFu16i_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu9i(Test_aSf_BFu16i_BFu9i, "aSf_BFu16i_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu9ll()
{
  {
    init_simple_test("aSf_BFu16i_BFu9ll");
    static aSf_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aSf_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aSf_BFu16i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu9ll(Test_aSf_BFu16i_BFu9ll, "aSf_BFu16i_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_BFu9s()
{
  {
    init_simple_test("aSf_BFu16i_BFu9s");
    static aSf_BFu16i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aSf_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aSf_BFu16i_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_BFu9s(Test_aSf_BFu16i_BFu9s, "aSf_BFu16i_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_C()
{
  {
    init_simple_test("aSf_BFu16i_C");
    static aSf_BFu16i_C lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_C");
    check_field_offset(lv, v3, 3, "aSf_BFu16i_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_C(Test_aSf_BFu16i_C, "aSf_BFu16i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_D()
{
  {
    init_simple_test("aSf_BFu16i_D");
    static aSf_BFu16i_D lv;
    check2(sizeof(lv), 11, "sizeof(aSf_BFu16i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_D");
    check_field_offset(lv, v3, 3, "aSf_BFu16i_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_D(Test_aSf_BFu16i_D, "aSf_BFu16i_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_F()
{
  {
    init_simple_test("aSf_BFu16i_F");
    static aSf_BFu16i_F lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_F");
    check_field_offset(lv, v3, 3, "aSf_BFu16i_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_F(Test_aSf_BFu16i_F, "aSf_BFu16i_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_I()
{
  {
    init_simple_test("aSf_BFu16i_I");
    static aSf_BFu16i_I lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_I");
    check_field_offset(lv, v3, 3, "aSf_BFu16i_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_I(Test_aSf_BFu16i_I, "aSf_BFu16i_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_Ip()
{
  {
    init_simple_test("aSf_BFu16i_Ip");
    static aSf_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aSf_BFu16i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_Ip");
    check_field_offset(lv, v3, 3, "aSf_BFu16i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_Ip(Test_aSf_BFu16i_Ip, "aSf_BFu16i_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_L()
{
  {
    init_simple_test("aSf_BFu16i_L");
    static aSf_BFu16i_L lv;
    check2(sizeof(lv), 11, "sizeof(aSf_BFu16i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_L");
    check_field_offset(lv, v3, 3, "aSf_BFu16i_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_L(Test_aSf_BFu16i_L, "aSf_BFu16i_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_S()
{
  {
    init_simple_test("aSf_BFu16i_S");
    static aSf_BFu16i_S lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_S");
    check_field_offset(lv, v3, 3, "aSf_BFu16i_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_S(Test_aSf_BFu16i_S, "aSf_BFu16i_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_Sf()
{
  {
    init_simple_test("aSf_BFu16i_Sf");
    static aSf_BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "aSf_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_Sf(Test_aSf_BFu16i_Sf, "aSf_BFu16i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_Uc()
{
  {
    init_simple_test("aSf_BFu16i_Uc");
    static aSf_BFu16i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_Uc");
    check_field_offset(lv, v3, 3, "aSf_BFu16i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_Uc(Test_aSf_BFu16i_Uc, "aSf_BFu16i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_Ui()
{
  {
    init_simple_test("aSf_BFu16i_Ui");
    static aSf_BFu16i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_Ui");
    check_field_offset(lv, v3, 3, "aSf_BFu16i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_Ui(Test_aSf_BFu16i_Ui, "aSf_BFu16i_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_Ul()
{
  {
    init_simple_test("aSf_BFu16i_Ul");
    static aSf_BFu16i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aSf_BFu16i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_Ul");
    check_field_offset(lv, v3, 3, "aSf_BFu16i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_Ul(Test_aSf_BFu16i_Ul, "aSf_BFu16i_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_Us()
{
  {
    init_simple_test("aSf_BFu16i_Us");
    static aSf_BFu16i_Us lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_Us");
    check_field_offset(lv, v3, 3, "aSf_BFu16i_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_Us(Test_aSf_BFu16i_Us, "aSf_BFu16i_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16i_Vp()
{
  {
    init_simple_test("aSf_BFu16i_Vp");
    static aSf_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aSf_BFu16i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_Vp");
    check_field_offset(lv, v3, 3, "aSf_BFu16i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16i_Vp(Test_aSf_BFu16i_Vp, "aSf_BFu16i_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll()
{
  {
    init_simple_test("aSf_BFu16ll");
    static aSf_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll(Test_aSf_BFu16ll, "aSf_BFu16ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu15i()
{
  {
    init_simple_test("aSf_BFu16ll_BFu15i");
    static aSf_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aSf_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aSf_BFu16ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu15i(Test_aSf_BFu16ll_BFu15i, "aSf_BFu16ll_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu15ll()
{
  {
    init_simple_test("aSf_BFu16ll_BFu15ll");
    static aSf_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aSf_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aSf_BFu16ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu15ll(Test_aSf_BFu16ll_BFu15ll, "aSf_BFu16ll_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu15s()
{
  {
    init_simple_test("aSf_BFu16ll_BFu15s");
    static aSf_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aSf_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aSf_BFu16ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu15s(Test_aSf_BFu16ll_BFu15s, "aSf_BFu16ll_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu16i()
{
  {
    init_simple_test("aSf_BFu16ll_BFu16i");
    static aSf_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aSf_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu16i(Test_aSf_BFu16ll_BFu16i, "aSf_BFu16ll_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu16ll()
{
  {
    init_simple_test("aSf_BFu16ll_BFu16ll");
    static aSf_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aSf_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu16ll(Test_aSf_BFu16ll_BFu16ll, "aSf_BFu16ll_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu16s()
{
  {
    init_simple_test("aSf_BFu16ll_BFu16s");
    static aSf_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aSf_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu16s(Test_aSf_BFu16ll_BFu16s, "aSf_BFu16ll_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu17i()
{
  {
    init_simple_test("aSf_BFu16ll_BFu17i");
    static aSf_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu16ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aSf_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aSf_BFu16ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu17i(Test_aSf_BFu16ll_BFu17i, "aSf_BFu16ll_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu17ll()
{
  {
    init_simple_test("aSf_BFu16ll_BFu17ll");
    static aSf_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aSf_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aSf_BFu16ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu17ll(Test_aSf_BFu16ll_BFu17ll, "aSf_BFu16ll_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu1c()
{
  {
    init_simple_test("aSf_BFu16ll_BFu1c");
    static aSf_BFu16ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aSf_BFu16ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu1c(Test_aSf_BFu16ll_BFu1c, "aSf_BFu16ll_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu1i()
{
  {
    init_simple_test("aSf_BFu16ll_BFu1i");
    static aSf_BFu16ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aSf_BFu16ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu1i(Test_aSf_BFu16ll_BFu1i, "aSf_BFu16ll_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu1ll()
{
  {
    init_simple_test("aSf_BFu16ll_BFu1ll");
    static aSf_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aSf_BFu16ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu1ll(Test_aSf_BFu16ll_BFu1ll, "aSf_BFu16ll_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu1s()
{
  {
    init_simple_test("aSf_BFu16ll_BFu1s");
    static aSf_BFu16ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aSf_BFu16ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu1s(Test_aSf_BFu16ll_BFu1s, "aSf_BFu16ll_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu31i()
{
  {
    init_simple_test("aSf_BFu16ll_BFu31i");
    static aSf_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aSf_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aSf_BFu16ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu31i(Test_aSf_BFu16ll_BFu31i, "aSf_BFu16ll_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu31ll()
{
  {
    init_simple_test("aSf_BFu16ll_BFu31ll");
    static aSf_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aSf_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aSf_BFu16ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu31ll(Test_aSf_BFu16ll_BFu31ll, "aSf_BFu16ll_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu32i()
{
  {
    init_simple_test("aSf_BFu16ll_BFu32i");
    static aSf_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aSf_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aSf_BFu16ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu32i(Test_aSf_BFu16ll_BFu32i, "aSf_BFu16ll_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu32ll()
{
  {
    init_simple_test("aSf_BFu16ll_BFu32ll");
    static aSf_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aSf_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aSf_BFu16ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu32ll(Test_aSf_BFu16ll_BFu32ll, "aSf_BFu16ll_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu33()
{
  {
    init_simple_test("aSf_BFu16ll_BFu33");
    static aSf_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu16ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aSf_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aSf_BFu16ll_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu33(Test_aSf_BFu16ll_BFu33, "aSf_BFu16ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu7c()
{
  {
    init_simple_test("aSf_BFu16ll_BFu7c");
    static aSf_BFu16ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aSf_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aSf_BFu16ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu7c(Test_aSf_BFu16ll_BFu7c, "aSf_BFu16ll_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu7i()
{
  {
    init_simple_test("aSf_BFu16ll_BFu7i");
    static aSf_BFu16ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aSf_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aSf_BFu16ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu7i(Test_aSf_BFu16ll_BFu7i, "aSf_BFu16ll_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu7ll()
{
  {
    init_simple_test("aSf_BFu16ll_BFu7ll");
    static aSf_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aSf_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aSf_BFu16ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu7ll(Test_aSf_BFu16ll_BFu7ll, "aSf_BFu16ll_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu7s()
{
  {
    init_simple_test("aSf_BFu16ll_BFu7s");
    static aSf_BFu16ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aSf_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aSf_BFu16ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu7s(Test_aSf_BFu16ll_BFu7s, "aSf_BFu16ll_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu8c()
{
  {
    init_simple_test("aSf_BFu16ll_BFu8c");
    static aSf_BFu16ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aSf_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aSf_BFu16ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu8c(Test_aSf_BFu16ll_BFu8c, "aSf_BFu16ll_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu8i()
{
  {
    init_simple_test("aSf_BFu16ll_BFu8i");
    static aSf_BFu16ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aSf_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aSf_BFu16ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu8i(Test_aSf_BFu16ll_BFu8i, "aSf_BFu16ll_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu8ll()
{
  {
    init_simple_test("aSf_BFu16ll_BFu8ll");
    static aSf_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aSf_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aSf_BFu16ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu8ll(Test_aSf_BFu16ll_BFu8ll, "aSf_BFu16ll_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu8s()
{
  {
    init_simple_test("aSf_BFu16ll_BFu8s");
    static aSf_BFu16ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aSf_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aSf_BFu16ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu8s(Test_aSf_BFu16ll_BFu8s, "aSf_BFu16ll_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu9i()
{
  {
    init_simple_test("aSf_BFu16ll_BFu9i");
    static aSf_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aSf_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aSf_BFu16ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu9i(Test_aSf_BFu16ll_BFu9i, "aSf_BFu16ll_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu9ll()
{
  {
    init_simple_test("aSf_BFu16ll_BFu9ll");
    static aSf_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aSf_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aSf_BFu16ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu9ll(Test_aSf_BFu16ll_BFu9ll, "aSf_BFu16ll_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_BFu9s()
{
  {
    init_simple_test("aSf_BFu16ll_BFu9s");
    static aSf_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aSf_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aSf_BFu16ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_BFu9s(Test_aSf_BFu16ll_BFu9s, "aSf_BFu16ll_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_C()
{
  {
    init_simple_test("aSf_BFu16ll_C");
    static aSf_BFu16ll_C lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_C");
    check_field_offset(lv, v3, 3, "aSf_BFu16ll_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_C(Test_aSf_BFu16ll_C, "aSf_BFu16ll_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_D()
{
  {
    init_simple_test("aSf_BFu16ll_D");
    static aSf_BFu16ll_D lv;
    check2(sizeof(lv), 11, "sizeof(aSf_BFu16ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_D");
    check_field_offset(lv, v3, 3, "aSf_BFu16ll_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_D(Test_aSf_BFu16ll_D, "aSf_BFu16ll_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_F()
{
  {
    init_simple_test("aSf_BFu16ll_F");
    static aSf_BFu16ll_F lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_F");
    check_field_offset(lv, v3, 3, "aSf_BFu16ll_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_F(Test_aSf_BFu16ll_F, "aSf_BFu16ll_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_I()
{
  {
    init_simple_test("aSf_BFu16ll_I");
    static aSf_BFu16ll_I lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_I");
    check_field_offset(lv, v3, 3, "aSf_BFu16ll_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_I(Test_aSf_BFu16ll_I, "aSf_BFu16ll_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_Ip()
{
  {
    init_simple_test("aSf_BFu16ll_Ip");
    static aSf_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aSf_BFu16ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_Ip");
    check_field_offset(lv, v3, 3, "aSf_BFu16ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_Ip(Test_aSf_BFu16ll_Ip, "aSf_BFu16ll_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_L()
{
  {
    init_simple_test("aSf_BFu16ll_L");
    static aSf_BFu16ll_L lv;
    check2(sizeof(lv), 11, "sizeof(aSf_BFu16ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_L");
    check_field_offset(lv, v3, 3, "aSf_BFu16ll_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_L(Test_aSf_BFu16ll_L, "aSf_BFu16ll_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_S()
{
  {
    init_simple_test("aSf_BFu16ll_S");
    static aSf_BFu16ll_S lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_S");
    check_field_offset(lv, v3, 3, "aSf_BFu16ll_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_S(Test_aSf_BFu16ll_S, "aSf_BFu16ll_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_Sf()
{
  {
    init_simple_test("aSf_BFu16ll_Sf");
    static aSf_BFu16ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "aSf_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_Sf(Test_aSf_BFu16ll_Sf, "aSf_BFu16ll_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_Uc()
{
  {
    init_simple_test("aSf_BFu16ll_Uc");
    static aSf_BFu16ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_Uc");
    check_field_offset(lv, v3, 3, "aSf_BFu16ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_Uc(Test_aSf_BFu16ll_Uc, "aSf_BFu16ll_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_Ui()
{
  {
    init_simple_test("aSf_BFu16ll_Ui");
    static aSf_BFu16ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_Ui");
    check_field_offset(lv, v3, 3, "aSf_BFu16ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_Ui(Test_aSf_BFu16ll_Ui, "aSf_BFu16ll_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_Ul()
{
  {
    init_simple_test("aSf_BFu16ll_Ul");
    static aSf_BFu16ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aSf_BFu16ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_Ul");
    check_field_offset(lv, v3, 3, "aSf_BFu16ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_Ul(Test_aSf_BFu16ll_Ul, "aSf_BFu16ll_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_Us()
{
  {
    init_simple_test("aSf_BFu16ll_Us");
    static aSf_BFu16ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_Us");
    check_field_offset(lv, v3, 3, "aSf_BFu16ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_Us(Test_aSf_BFu16ll_Us, "aSf_BFu16ll_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16ll_Vp()
{
  {
    init_simple_test("aSf_BFu16ll_Vp");
    static aSf_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aSf_BFu16ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_Vp");
    check_field_offset(lv, v3, 3, "aSf_BFu16ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16ll_Vp(Test_aSf_BFu16ll_Vp, "aSf_BFu16ll_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s()
{
  {
    init_simple_test("aSf_BFu16s");
    static aSf_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s(Test_aSf_BFu16s, "aSf_BFu16s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu15i()
{
  {
    init_simple_test("aSf_BFu16s_BFu15i");
    static aSf_BFu16s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aSf_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aSf_BFu16s_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu15i(Test_aSf_BFu16s_BFu15i, "aSf_BFu16s_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu15ll()
{
  {
    init_simple_test("aSf_BFu16s_BFu15ll");
    static aSf_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aSf_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aSf_BFu16s_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu15ll(Test_aSf_BFu16s_BFu15ll, "aSf_BFu16s_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu15s()
{
  {
    init_simple_test("aSf_BFu16s_BFu15s");
    static aSf_BFu16s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aSf_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aSf_BFu16s_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu15s(Test_aSf_BFu16s_BFu15s, "aSf_BFu16s_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu16i()
{
  {
    init_simple_test("aSf_BFu16s_BFu16i");
    static aSf_BFu16s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aSf_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu16i(Test_aSf_BFu16s_BFu16i, "aSf_BFu16s_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu16ll()
{
  {
    init_simple_test("aSf_BFu16s_BFu16ll");
    static aSf_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aSf_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu16ll(Test_aSf_BFu16s_BFu16ll, "aSf_BFu16s_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu16s()
{
  {
    init_simple_test("aSf_BFu16s_BFu16s");
    static aSf_BFu16s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aSf_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu16s(Test_aSf_BFu16s_BFu16s, "aSf_BFu16s_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu17i()
{
  {
    init_simple_test("aSf_BFu16s_BFu17i");
    static aSf_BFu16s_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu16s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aSf_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aSf_BFu16s_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu17i(Test_aSf_BFu16s_BFu17i, "aSf_BFu16s_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu17ll()
{
  {
    init_simple_test("aSf_BFu16s_BFu17ll");
    static aSf_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu16s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aSf_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aSf_BFu16s_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu17ll(Test_aSf_BFu16s_BFu17ll, "aSf_BFu16s_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu1c()
{
  {
    init_simple_test("aSf_BFu16s_BFu1c");
    static aSf_BFu16s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aSf_BFu16s_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu1c(Test_aSf_BFu16s_BFu1c, "aSf_BFu16s_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu1i()
{
  {
    init_simple_test("aSf_BFu16s_BFu1i");
    static aSf_BFu16s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aSf_BFu16s_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu1i(Test_aSf_BFu16s_BFu1i, "aSf_BFu16s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu1ll()
{
  {
    init_simple_test("aSf_BFu16s_BFu1ll");
    static aSf_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aSf_BFu16s_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu1ll(Test_aSf_BFu16s_BFu1ll, "aSf_BFu16s_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu1s()
{
  {
    init_simple_test("aSf_BFu16s_BFu1s");
    static aSf_BFu16s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aSf_BFu16s_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu1s(Test_aSf_BFu16s_BFu1s, "aSf_BFu16s_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu31i()
{
  {
    init_simple_test("aSf_BFu16s_BFu31i");
    static aSf_BFu16s_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aSf_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aSf_BFu16s_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu31i(Test_aSf_BFu16s_BFu31i, "aSf_BFu16s_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu31ll()
{
  {
    init_simple_test("aSf_BFu16s_BFu31ll");
    static aSf_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aSf_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aSf_BFu16s_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu31ll(Test_aSf_BFu16s_BFu31ll, "aSf_BFu16s_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu32i()
{
  {
    init_simple_test("aSf_BFu16s_BFu32i");
    static aSf_BFu16s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aSf_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aSf_BFu16s_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu32i(Test_aSf_BFu16s_BFu32i, "aSf_BFu16s_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu32ll()
{
  {
    init_simple_test("aSf_BFu16s_BFu32ll");
    static aSf_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aSf_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aSf_BFu16s_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu32ll(Test_aSf_BFu16s_BFu32ll, "aSf_BFu16s_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu33()
{
  {
    init_simple_test("aSf_BFu16s_BFu33");
    static aSf_BFu16s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu16s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aSf_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aSf_BFu16s_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu33(Test_aSf_BFu16s_BFu33, "aSf_BFu16s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu7c()
{
  {
    init_simple_test("aSf_BFu16s_BFu7c");
    static aSf_BFu16s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aSf_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aSf_BFu16s_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu7c(Test_aSf_BFu16s_BFu7c, "aSf_BFu16s_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu7i()
{
  {
    init_simple_test("aSf_BFu16s_BFu7i");
    static aSf_BFu16s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aSf_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aSf_BFu16s_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu7i(Test_aSf_BFu16s_BFu7i, "aSf_BFu16s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu7ll()
{
  {
    init_simple_test("aSf_BFu16s_BFu7ll");
    static aSf_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aSf_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aSf_BFu16s_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu7ll(Test_aSf_BFu16s_BFu7ll, "aSf_BFu16s_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu7s()
{
  {
    init_simple_test("aSf_BFu16s_BFu7s");
    static aSf_BFu16s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aSf_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aSf_BFu16s_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu7s(Test_aSf_BFu16s_BFu7s, "aSf_BFu16s_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu8c()
{
  {
    init_simple_test("aSf_BFu16s_BFu8c");
    static aSf_BFu16s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aSf_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aSf_BFu16s_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu8c(Test_aSf_BFu16s_BFu8c, "aSf_BFu16s_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu8i()
{
  {
    init_simple_test("aSf_BFu16s_BFu8i");
    static aSf_BFu16s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aSf_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aSf_BFu16s_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu8i(Test_aSf_BFu16s_BFu8i, "aSf_BFu16s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu8ll()
{
  {
    init_simple_test("aSf_BFu16s_BFu8ll");
    static aSf_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aSf_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aSf_BFu16s_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu8ll(Test_aSf_BFu16s_BFu8ll, "aSf_BFu16s_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu8s()
{
  {
    init_simple_test("aSf_BFu16s_BFu8s");
    static aSf_BFu16s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aSf_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aSf_BFu16s_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu8s(Test_aSf_BFu16s_BFu8s, "aSf_BFu16s_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu9i()
{
  {
    init_simple_test("aSf_BFu16s_BFu9i");
    static aSf_BFu16s_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aSf_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aSf_BFu16s_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu9i(Test_aSf_BFu16s_BFu9i, "aSf_BFu16s_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu9ll()
{
  {
    init_simple_test("aSf_BFu16s_BFu9ll");
    static aSf_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aSf_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aSf_BFu16s_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu9ll(Test_aSf_BFu16s_BFu9ll, "aSf_BFu16s_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_BFu9s()
{
  {
    init_simple_test("aSf_BFu16s_BFu9s");
    static aSf_BFu16s_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aSf_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aSf_BFu16s_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_BFu9s(Test_aSf_BFu16s_BFu9s, "aSf_BFu16s_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_C()
{
  {
    init_simple_test("aSf_BFu16s_C");
    static aSf_BFu16s_C lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_C");
    check_field_offset(lv, v3, 3, "aSf_BFu16s_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_C(Test_aSf_BFu16s_C, "aSf_BFu16s_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_D()
{
  {
    init_simple_test("aSf_BFu16s_D");
    static aSf_BFu16s_D lv;
    check2(sizeof(lv), 11, "sizeof(aSf_BFu16s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_D");
    check_field_offset(lv, v3, 3, "aSf_BFu16s_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_D(Test_aSf_BFu16s_D, "aSf_BFu16s_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_F()
{
  {
    init_simple_test("aSf_BFu16s_F");
    static aSf_BFu16s_F lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_F");
    check_field_offset(lv, v3, 3, "aSf_BFu16s_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_F(Test_aSf_BFu16s_F, "aSf_BFu16s_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_I()
{
  {
    init_simple_test("aSf_BFu16s_I");
    static aSf_BFu16s_I lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_I");
    check_field_offset(lv, v3, 3, "aSf_BFu16s_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_I(Test_aSf_BFu16s_I, "aSf_BFu16s_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_Ip()
{
  {
    init_simple_test("aSf_BFu16s_Ip");
    static aSf_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aSf_BFu16s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_Ip");
    check_field_offset(lv, v3, 3, "aSf_BFu16s_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_Ip(Test_aSf_BFu16s_Ip, "aSf_BFu16s_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_L()
{
  {
    init_simple_test("aSf_BFu16s_L");
    static aSf_BFu16s_L lv;
    check2(sizeof(lv), 11, "sizeof(aSf_BFu16s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_L");
    check_field_offset(lv, v3, 3, "aSf_BFu16s_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_L(Test_aSf_BFu16s_L, "aSf_BFu16s_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_S()
{
  {
    init_simple_test("aSf_BFu16s_S");
    static aSf_BFu16s_S lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_S");
    check_field_offset(lv, v3, 3, "aSf_BFu16s_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_S(Test_aSf_BFu16s_S, "aSf_BFu16s_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_Sf()
{
  {
    init_simple_test("aSf_BFu16s_Sf");
    static aSf_BFu16s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_Sf");
    check_field_offset(lv, v3, 3, "aSf_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_Sf(Test_aSf_BFu16s_Sf, "aSf_BFu16s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_Uc()
{
  {
    init_simple_test("aSf_BFu16s_Uc");
    static aSf_BFu16s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu16s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_Uc");
    check_field_offset(lv, v3, 3, "aSf_BFu16s_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_Uc(Test_aSf_BFu16s_Uc, "aSf_BFu16s_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_Ui()
{
  {
    init_simple_test("aSf_BFu16s_Ui");
    static aSf_BFu16s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu16s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_Ui");
    check_field_offset(lv, v3, 3, "aSf_BFu16s_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_Ui(Test_aSf_BFu16s_Ui, "aSf_BFu16s_Ui", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_Ul()
{
  {
    init_simple_test("aSf_BFu16s_Ul");
    static aSf_BFu16s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aSf_BFu16s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_Ul");
    check_field_offset(lv, v3, 3, "aSf_BFu16s_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_Ul(Test_aSf_BFu16s_Ul, "aSf_BFu16s_Ul", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_Us()
{
  {
    init_simple_test("aSf_BFu16s_Us");
    static aSf_BFu16s_Us lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu16s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_Us");
    check_field_offset(lv, v3, 3, "aSf_BFu16s_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_Us(Test_aSf_BFu16s_Us, "aSf_BFu16s_Us", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu16s_Vp()
{
  {
    init_simple_test("aSf_BFu16s_Vp");
    static aSf_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aSf_BFu16s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aSf_BFu16s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_Vp");
    check_field_offset(lv, v3, 3, "aSf_BFu16s_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu16s_Vp(Test_aSf_BFu16s_Vp, "aSf_BFu16s_Vp", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i()
{
  {
    init_simple_test("aSf_BFu17i");
    static aSf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i(Test_aSf_BFu17i, "aSf_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu15i()
{
  {
    init_simple_test("aSf_BFu17i_BFu15i");
    static aSf_BFu17i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aSf_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aSf_BFu17i_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu15i(Test_aSf_BFu17i_BFu15i, "aSf_BFu17i_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu15ll()
{
  {
    init_simple_test("aSf_BFu17i_BFu15ll");
    static aSf_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aSf_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aSf_BFu17i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu15ll(Test_aSf_BFu17i_BFu15ll, "aSf_BFu17i_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu15s()
{
  {
    init_simple_test("aSf_BFu17i_BFu15s");
    static aSf_BFu17i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aSf_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aSf_BFu17i_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu15s(Test_aSf_BFu17i_BFu15s, "aSf_BFu17i_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu16i()
{
  {
    init_simple_test("aSf_BFu17i_BFu16i");
    static aSf_BFu17i_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aSf_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aSf_BFu17i_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu16i(Test_aSf_BFu17i_BFu16i, "aSf_BFu17i_BFu16i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu16ll()
{
  {
    init_simple_test("aSf_BFu17i_BFu16ll");
    static aSf_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aSf_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aSf_BFu17i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu16ll(Test_aSf_BFu17i_BFu16ll, "aSf_BFu17i_BFu16ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu16s()
{
  {
    init_simple_test("aSf_BFu17i_BFu16s");
    static aSf_BFu17i_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aSf_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aSf_BFu17i_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu16s(Test_aSf_BFu17i_BFu16s, "aSf_BFu17i_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu17i()
{
  {
    init_simple_test("aSf_BFu17i_BFu17i");
    static aSf_BFu17i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aSf_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu17i(Test_aSf_BFu17i_BFu17i, "aSf_BFu17i_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu17ll()
{
  {
    init_simple_test("aSf_BFu17i_BFu17ll");
    static aSf_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aSf_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu17ll(Test_aSf_BFu17i_BFu17ll, "aSf_BFu17i_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu1c()
{
  {
    init_simple_test("aSf_BFu17i_BFu1c");
    static aSf_BFu17i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aSf_BFu17i_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu1c(Test_aSf_BFu17i_BFu1c, "aSf_BFu17i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu1i()
{
  {
    init_simple_test("aSf_BFu17i_BFu1i");
    static aSf_BFu17i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aSf_BFu17i_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu1i(Test_aSf_BFu17i_BFu1i, "aSf_BFu17i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu1ll()
{
  {
    init_simple_test("aSf_BFu17i_BFu1ll");
    static aSf_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aSf_BFu17i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu1ll(Test_aSf_BFu17i_BFu1ll, "aSf_BFu17i_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu1s()
{
  {
    init_simple_test("aSf_BFu17i_BFu1s");
    static aSf_BFu17i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aSf_BFu17i_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu1s(Test_aSf_BFu17i_BFu1s, "aSf_BFu17i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu31i()
{
  {
    init_simple_test("aSf_BFu17i_BFu31i");
    static aSf_BFu17i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu17i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "aSf_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "aSf_BFu17i_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu31i(Test_aSf_BFu17i_BFu31i, "aSf_BFu17i_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu31ll()
{
  {
    init_simple_test("aSf_BFu17i_BFu31ll");
    static aSf_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu17i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "aSf_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "aSf_BFu17i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu31ll(Test_aSf_BFu17i_BFu31ll, "aSf_BFu17i_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu32i()
{
  {
    init_simple_test("aSf_BFu17i_BFu32i");
    static aSf_BFu17i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu17i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "aSf_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "aSf_BFu17i_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu32i(Test_aSf_BFu17i_BFu32i, "aSf_BFu17i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu32ll()
{
  {
    init_simple_test("aSf_BFu17i_BFu32ll");
    static aSf_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu17i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "aSf_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "aSf_BFu17i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu32ll(Test_aSf_BFu17i_BFu32ll, "aSf_BFu17i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu33()
{
  {
    init_simple_test("aSf_BFu17i_BFu33");
    static aSf_BFu17i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu17i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "aSf_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "aSf_BFu17i_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu33(Test_aSf_BFu17i_BFu33, "aSf_BFu17i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu7c()
{
  {
    init_simple_test("aSf_BFu17i_BFu7c");
    static aSf_BFu17i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aSf_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aSf_BFu17i_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu7c(Test_aSf_BFu17i_BFu7c, "aSf_BFu17i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu7i()
{
  {
    init_simple_test("aSf_BFu17i_BFu7i");
    static aSf_BFu17i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aSf_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aSf_BFu17i_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu7i(Test_aSf_BFu17i_BFu7i, "aSf_BFu17i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu7ll()
{
  {
    init_simple_test("aSf_BFu17i_BFu7ll");
    static aSf_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aSf_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aSf_BFu17i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu7ll(Test_aSf_BFu17i_BFu7ll, "aSf_BFu17i_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu7s()
{
  {
    init_simple_test("aSf_BFu17i_BFu7s");
    static aSf_BFu17i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aSf_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aSf_BFu17i_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu7s(Test_aSf_BFu17i_BFu7s, "aSf_BFu17i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu8c()
{
  {
    init_simple_test("aSf_BFu17i_BFu8c");
    static aSf_BFu17i_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aSf_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aSf_BFu17i_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu8c(Test_aSf_BFu17i_BFu8c, "aSf_BFu17i_BFu8c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu8i()
{
  {
    init_simple_test("aSf_BFu17i_BFu8i");
    static aSf_BFu17i_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aSf_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aSf_BFu17i_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu8i(Test_aSf_BFu17i_BFu8i, "aSf_BFu17i_BFu8i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu8ll()
{
  {
    init_simple_test("aSf_BFu17i_BFu8ll");
    static aSf_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aSf_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aSf_BFu17i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu8ll(Test_aSf_BFu17i_BFu8ll, "aSf_BFu17i_BFu8ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu8s()
{
  {
    init_simple_test("aSf_BFu17i_BFu8s");
    static aSf_BFu17i_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aSf_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aSf_BFu17i_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu8s(Test_aSf_BFu17i_BFu8s, "aSf_BFu17i_BFu8s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu9i()
{
  {
    init_simple_test("aSf_BFu17i_BFu9i");
    static aSf_BFu17i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aSf_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aSf_BFu17i_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu9i(Test_aSf_BFu17i_BFu9i, "aSf_BFu17i_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu9ll()
{
  {
    init_simple_test("aSf_BFu17i_BFu9ll");
    static aSf_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aSf_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aSf_BFu17i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu9ll(Test_aSf_BFu17i_BFu9ll, "aSf_BFu17i_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_BFu9s()
{
  {
    init_simple_test("aSf_BFu17i_BFu9s");
    static aSf_BFu17i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aSf_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aSf_BFu17i_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_BFu9s(Test_aSf_BFu17i_BFu9s, "aSf_BFu17i_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_C()
{
  {
    init_simple_test("aSf_BFu17i_C");
    static aSf_BFu17i_C lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_C");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_C");
    check_field_offset(lv, v3, 4, "aSf_BFu17i_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_C(Test_aSf_BFu17i_C, "aSf_BFu17i_C", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_D()
{
  {
    init_simple_test("aSf_BFu17i_D");
    static aSf_BFu17i_D lv;
    check2(sizeof(lv), 12, "sizeof(aSf_BFu17i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_D");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_D");
    check_field_offset(lv, v3, 4, "aSf_BFu17i_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_D(Test_aSf_BFu17i_D, "aSf_BFu17i_D", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_F()
{
  {
    init_simple_test("aSf_BFu17i_F");
    static aSf_BFu17i_F lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu17i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_F");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_F");
    check_field_offset(lv, v3, 4, "aSf_BFu17i_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_F(Test_aSf_BFu17i_F, "aSf_BFu17i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_I()
{
  {
    init_simple_test("aSf_BFu17i_I");
    static aSf_BFu17i_I lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu17i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_I");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_I");
    check_field_offset(lv, v3, 4, "aSf_BFu17i_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_I(Test_aSf_BFu17i_I, "aSf_BFu17i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_Ip()
{
  {
    init_simple_test("aSf_BFu17i_Ip");
    static aSf_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aSf_BFu17i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_Ip");
    check_field_offset(lv, v3, 4, "aSf_BFu17i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_Ip(Test_aSf_BFu17i_Ip, "aSf_BFu17i_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_L()
{
  {
    init_simple_test("aSf_BFu17i_L");
    static aSf_BFu17i_L lv;
    check2(sizeof(lv), 12, "sizeof(aSf_BFu17i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_L");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_L");
    check_field_offset(lv, v3, 4, "aSf_BFu17i_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_L(Test_aSf_BFu17i_L, "aSf_BFu17i_L", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_S()
{
  {
    init_simple_test("aSf_BFu17i_S");
    static aSf_BFu17i_S lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_S");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_S");
    check_field_offset(lv, v3, 4, "aSf_BFu17i_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_S(Test_aSf_BFu17i_S, "aSf_BFu17i_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_Sf()
{
  {
    init_simple_test("aSf_BFu17i_Sf");
    static aSf_BFu17i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "aSf_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_Sf(Test_aSf_BFu17i_Sf, "aSf_BFu17i_Sf", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_Uc()
{
  {
    init_simple_test("aSf_BFu17i_Uc");
    static aSf_BFu17i_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_Uc");
    check_field_offset(lv, v3, 4, "aSf_BFu17i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_Uc(Test_aSf_BFu17i_Uc, "aSf_BFu17i_Uc", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_Ui()
{
  {
    init_simple_test("aSf_BFu17i_Ui");
    static aSf_BFu17i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu17i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_Ui");
    check_field_offset(lv, v3, 4, "aSf_BFu17i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_Ui(Test_aSf_BFu17i_Ui, "aSf_BFu17i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_Ul()
{
  {
    init_simple_test("aSf_BFu17i_Ul");
    static aSf_BFu17i_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aSf_BFu17i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_Ul");
    check_field_offset(lv, v3, 4, "aSf_BFu17i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_Ul(Test_aSf_BFu17i_Ul, "aSf_BFu17i_Ul", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_Us()
{
  {
    init_simple_test("aSf_BFu17i_Us");
    static aSf_BFu17i_Us lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_Us");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_Us");
    check_field_offset(lv, v3, 4, "aSf_BFu17i_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_Us(Test_aSf_BFu17i_Us, "aSf_BFu17i_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17i_Vp()
{
  {
    init_simple_test("aSf_BFu17i_Vp");
    static aSf_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aSf_BFu17i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_Vp");
    check_field_offset(lv, v3, 4, "aSf_BFu17i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17i_Vp(Test_aSf_BFu17i_Vp, "aSf_BFu17i_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll()
{
  {
    init_simple_test("aSf_BFu17ll");
    static aSf_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll(Test_aSf_BFu17ll, "aSf_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu15i()
{
  {
    init_simple_test("aSf_BFu17ll_BFu15i");
    static aSf_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aSf_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aSf_BFu17ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu15i(Test_aSf_BFu17ll_BFu15i, "aSf_BFu17ll_BFu15i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu15ll()
{
  {
    init_simple_test("aSf_BFu17ll_BFu15ll");
    static aSf_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aSf_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aSf_BFu17ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu15ll(Test_aSf_BFu17ll_BFu15ll, "aSf_BFu17ll_BFu15ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu15s()
{
  {
    init_simple_test("aSf_BFu17ll_BFu15s");
    static aSf_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aSf_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aSf_BFu17ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu15s(Test_aSf_BFu17ll_BFu15s, "aSf_BFu17ll_BFu15s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu16i()
{
  {
    init_simple_test("aSf_BFu17ll_BFu16i");
    static aSf_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aSf_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aSf_BFu17ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu16i(Test_aSf_BFu17ll_BFu16i, "aSf_BFu17ll_BFu16i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu16ll()
{
  {
    init_simple_test("aSf_BFu17ll_BFu16ll");
    static aSf_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aSf_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aSf_BFu17ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu16ll(Test_aSf_BFu17ll_BFu16ll, "aSf_BFu17ll_BFu16ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu16s()
{
  {
    init_simple_test("aSf_BFu17ll_BFu16s");
    static aSf_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aSf_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aSf_BFu17ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu16s(Test_aSf_BFu17ll_BFu16s, "aSf_BFu17ll_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu17i()
{
  {
    init_simple_test("aSf_BFu17ll_BFu17i");
    static aSf_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aSf_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu17i(Test_aSf_BFu17ll_BFu17i, "aSf_BFu17ll_BFu17i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu17ll()
{
  {
    init_simple_test("aSf_BFu17ll_BFu17ll");
    static aSf_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aSf_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu17ll(Test_aSf_BFu17ll_BFu17ll, "aSf_BFu17ll_BFu17ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu1c()
{
  {
    init_simple_test("aSf_BFu17ll_BFu1c");
    static aSf_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aSf_BFu17ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu1c(Test_aSf_BFu17ll_BFu1c, "aSf_BFu17ll_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu1i()
{
  {
    init_simple_test("aSf_BFu17ll_BFu1i");
    static aSf_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aSf_BFu17ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu1i(Test_aSf_BFu17ll_BFu1i, "aSf_BFu17ll_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu1ll()
{
  {
    init_simple_test("aSf_BFu17ll_BFu1ll");
    static aSf_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aSf_BFu17ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu1ll(Test_aSf_BFu17ll_BFu1ll, "aSf_BFu17ll_BFu1ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu1s()
{
  {
    init_simple_test("aSf_BFu17ll_BFu1s");
    static aSf_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aSf_BFu17ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu1s(Test_aSf_BFu17ll_BFu1s, "aSf_BFu17ll_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu31i()
{
  {
    init_simple_test("aSf_BFu17ll_BFu31i");
    static aSf_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu17ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "aSf_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "aSf_BFu17ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu31i(Test_aSf_BFu17ll_BFu31i, "aSf_BFu17ll_BFu31i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu31ll()
{
  {
    init_simple_test("aSf_BFu17ll_BFu31ll");
    static aSf_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "aSf_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "aSf_BFu17ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu31ll(Test_aSf_BFu17ll_BFu31ll, "aSf_BFu17ll_BFu31ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu32i()
{
  {
    init_simple_test("aSf_BFu17ll_BFu32i");
    static aSf_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu17ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "aSf_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "aSf_BFu17ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu32i(Test_aSf_BFu17ll_BFu32i, "aSf_BFu17ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu32ll()
{
  {
    init_simple_test("aSf_BFu17ll_BFu32ll");
    static aSf_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "aSf_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "aSf_BFu17ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu32ll(Test_aSf_BFu17ll_BFu32ll, "aSf_BFu17ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu33()
{
  {
    init_simple_test("aSf_BFu17ll_BFu33");
    static aSf_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu17ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "aSf_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "aSf_BFu17ll_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu33(Test_aSf_BFu17ll_BFu33, "aSf_BFu17ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu7c()
{
  {
    init_simple_test("aSf_BFu17ll_BFu7c");
    static aSf_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aSf_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aSf_BFu17ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu7c(Test_aSf_BFu17ll_BFu7c, "aSf_BFu17ll_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu7i()
{
  {
    init_simple_test("aSf_BFu17ll_BFu7i");
    static aSf_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aSf_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aSf_BFu17ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu7i(Test_aSf_BFu17ll_BFu7i, "aSf_BFu17ll_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu7ll()
{
  {
    init_simple_test("aSf_BFu17ll_BFu7ll");
    static aSf_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aSf_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aSf_BFu17ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu7ll(Test_aSf_BFu17ll_BFu7ll, "aSf_BFu17ll_BFu7ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu7s()
{
  {
    init_simple_test("aSf_BFu17ll_BFu7s");
    static aSf_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu17ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aSf_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aSf_BFu17ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu7s(Test_aSf_BFu17ll_BFu7s, "aSf_BFu17ll_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu8c()
{
  {
    init_simple_test("aSf_BFu17ll_BFu8c");
    static aSf_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aSf_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aSf_BFu17ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu8c(Test_aSf_BFu17ll_BFu8c, "aSf_BFu17ll_BFu8c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu8i()
{
  {
    init_simple_test("aSf_BFu17ll_BFu8i");
    static aSf_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aSf_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aSf_BFu17ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu8i(Test_aSf_BFu17ll_BFu8i, "aSf_BFu17ll_BFu8i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu8ll()
{
  {
    init_simple_test("aSf_BFu17ll_BFu8ll");
    static aSf_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aSf_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aSf_BFu17ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu8ll(Test_aSf_BFu17ll_BFu8ll, "aSf_BFu17ll_BFu8ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu8s()
{
  {
    init_simple_test("aSf_BFu17ll_BFu8s");
    static aSf_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aSf_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aSf_BFu17ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu8s(Test_aSf_BFu17ll_BFu8s, "aSf_BFu17ll_BFu8s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu9i()
{
  {
    init_simple_test("aSf_BFu17ll_BFu9i");
    static aSf_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aSf_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aSf_BFu17ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu9i(Test_aSf_BFu17ll_BFu9i, "aSf_BFu17ll_BFu9i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu9ll()
{
  {
    init_simple_test("aSf_BFu17ll_BFu9ll");
    static aSf_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aSf_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aSf_BFu17ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu9ll(Test_aSf_BFu17ll_BFu9ll, "aSf_BFu17ll_BFu9ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_BFu9s()
{
  {
    init_simple_test("aSf_BFu17ll_BFu9s");
    static aSf_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aSf_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aSf_BFu17ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_BFu9s(Test_aSf_BFu17ll_BFu9s, "aSf_BFu17ll_BFu9s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_C()
{
  {
    init_simple_test("aSf_BFu17ll_C");
    static aSf_BFu17ll_C lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_C");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_C");
    check_field_offset(lv, v3, 4, "aSf_BFu17ll_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_C(Test_aSf_BFu17ll_C, "aSf_BFu17ll_C", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_D()
{
  {
    init_simple_test("aSf_BFu17ll_D");
    static aSf_BFu17ll_D lv;
    check2(sizeof(lv), 12, "sizeof(aSf_BFu17ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_D");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_D");
    check_field_offset(lv, v3, 4, "aSf_BFu17ll_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_D(Test_aSf_BFu17ll_D, "aSf_BFu17ll_D", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_F()
{
  {
    init_simple_test("aSf_BFu17ll_F");
    static aSf_BFu17ll_F lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu17ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_F");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_F");
    check_field_offset(lv, v3, 4, "aSf_BFu17ll_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_F(Test_aSf_BFu17ll_F, "aSf_BFu17ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_I()
{
  {
    init_simple_test("aSf_BFu17ll_I");
    static aSf_BFu17ll_I lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu17ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_I");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_I");
    check_field_offset(lv, v3, 4, "aSf_BFu17ll_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_I(Test_aSf_BFu17ll_I, "aSf_BFu17ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_Ip()
{
  {
    init_simple_test("aSf_BFu17ll_Ip");
    static aSf_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aSf_BFu17ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_Ip");
    check_field_offset(lv, v3, 4, "aSf_BFu17ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_Ip(Test_aSf_BFu17ll_Ip, "aSf_BFu17ll_Ip", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_L()
{
  {
    init_simple_test("aSf_BFu17ll_L");
    static aSf_BFu17ll_L lv;
    check2(sizeof(lv), 12, "sizeof(aSf_BFu17ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_L");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_L");
    check_field_offset(lv, v3, 4, "aSf_BFu17ll_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_L(Test_aSf_BFu17ll_L, "aSf_BFu17ll_L", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_S()
{
  {
    init_simple_test("aSf_BFu17ll_S");
    static aSf_BFu17ll_S lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_S");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_S");
    check_field_offset(lv, v3, 4, "aSf_BFu17ll_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_S(Test_aSf_BFu17ll_S, "aSf_BFu17ll_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_Sf()
{
  {
    init_simple_test("aSf_BFu17ll_Sf");
    static aSf_BFu17ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "aSf_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_Sf(Test_aSf_BFu17ll_Sf, "aSf_BFu17ll_Sf", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_Uc()
{
  {
    init_simple_test("aSf_BFu17ll_Uc");
    static aSf_BFu17ll_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu17ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_Uc");
    check_field_offset(lv, v3, 4, "aSf_BFu17ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_Uc(Test_aSf_BFu17ll_Uc, "aSf_BFu17ll_Uc", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_Ui()
{
  {
    init_simple_test("aSf_BFu17ll_Ui");
    static aSf_BFu17ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu17ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_Ui");
    check_field_offset(lv, v3, 4, "aSf_BFu17ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_Ui(Test_aSf_BFu17ll_Ui, "aSf_BFu17ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_Ul()
{
  {
    init_simple_test("aSf_BFu17ll_Ul");
    static aSf_BFu17ll_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aSf_BFu17ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_Ul");
    check_field_offset(lv, v3, 4, "aSf_BFu17ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_Ul(Test_aSf_BFu17ll_Ul, "aSf_BFu17ll_Ul", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_Us()
{
  {
    init_simple_test("aSf_BFu17ll_Us");
    static aSf_BFu17ll_Us lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu17ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_Us");
    check_field_offset(lv, v3, 4, "aSf_BFu17ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_Us(Test_aSf_BFu17ll_Us, "aSf_BFu17ll_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu17ll_Vp()
{
  {
    init_simple_test("aSf_BFu17ll_Vp");
    static aSf_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aSf_BFu17ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aSf_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_Vp");
    check_field_offset(lv, v3, 4, "aSf_BFu17ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu17ll_Vp(Test_aSf_BFu17ll_Vp, "aSf_BFu17ll_Vp", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c()
{
  {
    init_simple_test("aSf_BFu1c");
    static aSf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c(Test_aSf_BFu1c, "aSf_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu15i()
{
  {
    init_simple_test("aSf_BFu1c_BFu15i");
    static aSf_BFu1c_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aSf_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aSf_BFu1c_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu15i(Test_aSf_BFu1c_BFu15i, "aSf_BFu1c_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu15ll()
{
  {
    init_simple_test("aSf_BFu1c_BFu15ll");
    static aSf_BFu1c_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aSf_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aSf_BFu1c_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu15ll(Test_aSf_BFu1c_BFu15ll, "aSf_BFu1c_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu15s()
{
  {
    init_simple_test("aSf_BFu1c_BFu15s");
    static aSf_BFu1c_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aSf_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aSf_BFu1c_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu15s(Test_aSf_BFu1c_BFu15s, "aSf_BFu1c_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu16i()
{
  {
    init_simple_test("aSf_BFu1c_BFu16i");
    static aSf_BFu1c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aSf_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aSf_BFu1c_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu16i(Test_aSf_BFu1c_BFu16i, "aSf_BFu1c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu16ll()
{
  {
    init_simple_test("aSf_BFu1c_BFu16ll");
    static aSf_BFu1c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aSf_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aSf_BFu1c_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu16ll(Test_aSf_BFu1c_BFu16ll, "aSf_BFu1c_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu16s()
{
  {
    init_simple_test("aSf_BFu1c_BFu16s");
    static aSf_BFu1c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aSf_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aSf_BFu1c_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu16s(Test_aSf_BFu1c_BFu16s, "aSf_BFu1c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu17i()
{
  {
    init_simple_test("aSf_BFu1c_BFu17i");
    static aSf_BFu1c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aSf_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aSf_BFu1c_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu17i(Test_aSf_BFu1c_BFu17i, "aSf_BFu1c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu17ll()
{
  {
    init_simple_test("aSf_BFu1c_BFu17ll");
    static aSf_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aSf_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aSf_BFu1c_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu17ll(Test_aSf_BFu1c_BFu17ll, "aSf_BFu1c_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu1c()
{
  {
    init_simple_test("aSf_BFu1c_BFu1c");
    static aSf_BFu1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1c_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu1c(Test_aSf_BFu1c_BFu1c, "aSf_BFu1c_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu1i()
{
  {
    init_simple_test("aSf_BFu1c_BFu1i");
    static aSf_BFu1c_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1c_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu1i(Test_aSf_BFu1c_BFu1i, "aSf_BFu1c_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu1ll()
{
  {
    init_simple_test("aSf_BFu1c_BFu1ll");
    static aSf_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1c_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu1ll(Test_aSf_BFu1c_BFu1ll, "aSf_BFu1c_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu1s()
{
  {
    init_simple_test("aSf_BFu1c_BFu1s");
    static aSf_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1c_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu1s(Test_aSf_BFu1c_BFu1s, "aSf_BFu1c_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu31i()
{
  {
    init_simple_test("aSf_BFu1c_BFu31i");
    static aSf_BFu1c_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu1c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aSf_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aSf_BFu1c_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu31i(Test_aSf_BFu1c_BFu31i, "aSf_BFu1c_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu31ll()
{
  {
    init_simple_test("aSf_BFu1c_BFu31ll");
    static aSf_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu1c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aSf_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aSf_BFu1c_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu31ll(Test_aSf_BFu1c_BFu31ll, "aSf_BFu1c_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu32i()
{
  {
    init_simple_test("aSf_BFu1c_BFu32i");
    static aSf_BFu1c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aSf_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aSf_BFu1c_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu32i(Test_aSf_BFu1c_BFu32i, "aSf_BFu1c_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu32ll()
{
  {
    init_simple_test("aSf_BFu1c_BFu32ll");
    static aSf_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aSf_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aSf_BFu1c_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu32ll(Test_aSf_BFu1c_BFu32ll, "aSf_BFu1c_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu33()
{
  {
    init_simple_test("aSf_BFu1c_BFu33");
    static aSf_BFu1c_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "aSf_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "aSf_BFu1c_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu33(Test_aSf_BFu1c_BFu33, "aSf_BFu1c_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu7c()
{
  {
    init_simple_test("aSf_BFu1c_BFu7c");
    static aSf_BFu1c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1c_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu7c(Test_aSf_BFu1c_BFu7c, "aSf_BFu1c_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu7i()
{
  {
    init_simple_test("aSf_BFu1c_BFu7i");
    static aSf_BFu1c_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1c_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu7i(Test_aSf_BFu1c_BFu7i, "aSf_BFu1c_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu7ll()
{
  {
    init_simple_test("aSf_BFu1c_BFu7ll");
    static aSf_BFu1c_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1c_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu7ll(Test_aSf_BFu1c_BFu7ll, "aSf_BFu1c_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu7s()
{
  {
    init_simple_test("aSf_BFu1c_BFu7s");
    static aSf_BFu1c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1c_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu7s(Test_aSf_BFu1c_BFu7s, "aSf_BFu1c_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu8c()
{
  {
    init_simple_test("aSf_BFu1c_BFu8c");
    static aSf_BFu1c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1c_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu8c(Test_aSf_BFu1c_BFu8c, "aSf_BFu1c_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu8i()
{
  {
    init_simple_test("aSf_BFu1c_BFu8i");
    static aSf_BFu1c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1c_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu8i(Test_aSf_BFu1c_BFu8i, "aSf_BFu1c_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu8ll()
{
  {
    init_simple_test("aSf_BFu1c_BFu8ll");
    static aSf_BFu1c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1c_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu8ll(Test_aSf_BFu1c_BFu8ll, "aSf_BFu1c_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu8s()
{
  {
    init_simple_test("aSf_BFu1c_BFu8s");
    static aSf_BFu1c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1c_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu8s(Test_aSf_BFu1c_BFu8s, "aSf_BFu1c_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu9i()
{
  {
    init_simple_test("aSf_BFu1c_BFu9i");
    static aSf_BFu1c_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aSf_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aSf_BFu1c_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu9i(Test_aSf_BFu1c_BFu9i, "aSf_BFu1c_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu9ll()
{
  {
    init_simple_test("aSf_BFu1c_BFu9ll");
    static aSf_BFu1c_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aSf_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aSf_BFu1c_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu9ll(Test_aSf_BFu1c_BFu9ll, "aSf_BFu1c_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_BFu9s()
{
  {
    init_simple_test("aSf_BFu1c_BFu9s");
    static aSf_BFu1c_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aSf_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aSf_BFu1c_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_BFu9s(Test_aSf_BFu1c_BFu9s, "aSf_BFu1c_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_C()
{
  {
    init_simple_test("aSf_BFu1c_C");
    static aSf_BFu1c_C lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_C");
    check_field_offset(lv, v3, 2, "aSf_BFu1c_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_C(Test_aSf_BFu1c_C, "aSf_BFu1c_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_D()
{
  {
    init_simple_test("aSf_BFu1c_D");
    static aSf_BFu1c_D lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu1c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_D");
    check_field_offset(lv, v3, 2, "aSf_BFu1c_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_D(Test_aSf_BFu1c_D, "aSf_BFu1c_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_F()
{
  {
    init_simple_test("aSf_BFu1c_F");
    static aSf_BFu1c_F lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_F");
    check_field_offset(lv, v3, 2, "aSf_BFu1c_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_F(Test_aSf_BFu1c_F, "aSf_BFu1c_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_I()
{
  {
    init_simple_test("aSf_BFu1c_I");
    static aSf_BFu1c_I lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_I");
    check_field_offset(lv, v3, 2, "aSf_BFu1c_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_I(Test_aSf_BFu1c_I, "aSf_BFu1c_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_Ip()
{
  {
    init_simple_test("aSf_BFu1c_Ip");
    static aSf_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu1c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_Ip");
    check_field_offset(lv, v3, 2, "aSf_BFu1c_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_Ip(Test_aSf_BFu1c_Ip, "aSf_BFu1c_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_L()
{
  {
    init_simple_test("aSf_BFu1c_L");
    static aSf_BFu1c_L lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu1c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_L");
    check_field_offset(lv, v3, 2, "aSf_BFu1c_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_L(Test_aSf_BFu1c_L, "aSf_BFu1c_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_S()
{
  {
    init_simple_test("aSf_BFu1c_S");
    static aSf_BFu1c_S lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_S");
    check_field_offset(lv, v3, 2, "aSf_BFu1c_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_S(Test_aSf_BFu1c_S, "aSf_BFu1c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_Sf()
{
  {
    init_simple_test("aSf_BFu1c_Sf");
    static aSf_BFu1c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "aSf_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_Sf(Test_aSf_BFu1c_Sf, "aSf_BFu1c_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_Uc()
{
  {
    init_simple_test("aSf_BFu1c_Uc");
    static aSf_BFu1c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_Uc");
    check_field_offset(lv, v3, 2, "aSf_BFu1c_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_Uc(Test_aSf_BFu1c_Uc, "aSf_BFu1c_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_Ui()
{
  {
    init_simple_test("aSf_BFu1c_Ui");
    static aSf_BFu1c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_Ui");
    check_field_offset(lv, v3, 2, "aSf_BFu1c_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_Ui(Test_aSf_BFu1c_Ui, "aSf_BFu1c_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_Ul()
{
  {
    init_simple_test("aSf_BFu1c_Ul");
    static aSf_BFu1c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu1c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_Ul");
    check_field_offset(lv, v3, 2, "aSf_BFu1c_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_Ul(Test_aSf_BFu1c_Ul, "aSf_BFu1c_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_Us()
{
  {
    init_simple_test("aSf_BFu1c_Us");
    static aSf_BFu1c_Us lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_Us");
    check_field_offset(lv, v3, 2, "aSf_BFu1c_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_Us(Test_aSf_BFu1c_Us, "aSf_BFu1c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1c_Vp()
{
  {
    init_simple_test("aSf_BFu1c_Vp");
    static aSf_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu1c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1c_Vp");
    check_field_offset(lv, v3, 2, "aSf_BFu1c_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1c_Vp(Test_aSf_BFu1c_Vp, "aSf_BFu1c_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i()
{
  {
    init_simple_test("aSf_BFu1i");
    static aSf_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i(Test_aSf_BFu1i, "aSf_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu15i()
{
  {
    init_simple_test("aSf_BFu1i_BFu15i");
    static aSf_BFu1i_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aSf_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aSf_BFu1i_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu15i(Test_aSf_BFu1i_BFu15i, "aSf_BFu1i_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu15ll()
{
  {
    init_simple_test("aSf_BFu1i_BFu15ll");
    static aSf_BFu1i_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aSf_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aSf_BFu1i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu15ll(Test_aSf_BFu1i_BFu15ll, "aSf_BFu1i_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu15s()
{
  {
    init_simple_test("aSf_BFu1i_BFu15s");
    static aSf_BFu1i_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aSf_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aSf_BFu1i_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu15s(Test_aSf_BFu1i_BFu15s, "aSf_BFu1i_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu16i()
{
  {
    init_simple_test("aSf_BFu1i_BFu16i");
    static aSf_BFu1i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aSf_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aSf_BFu1i_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu16i(Test_aSf_BFu1i_BFu16i, "aSf_BFu1i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu16ll()
{
  {
    init_simple_test("aSf_BFu1i_BFu16ll");
    static aSf_BFu1i_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aSf_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aSf_BFu1i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu16ll(Test_aSf_BFu1i_BFu16ll, "aSf_BFu1i_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu16s()
{
  {
    init_simple_test("aSf_BFu1i_BFu16s");
    static aSf_BFu1i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aSf_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aSf_BFu1i_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu16s(Test_aSf_BFu1i_BFu16s, "aSf_BFu1i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu17i()
{
  {
    init_simple_test("aSf_BFu1i_BFu17i");
    static aSf_BFu1i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aSf_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aSf_BFu1i_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu17i(Test_aSf_BFu1i_BFu17i, "aSf_BFu1i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu17ll()
{
  {
    init_simple_test("aSf_BFu1i_BFu17ll");
    static aSf_BFu1i_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aSf_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aSf_BFu1i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu17ll(Test_aSf_BFu1i_BFu17ll, "aSf_BFu1i_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu1c()
{
  {
    init_simple_test("aSf_BFu1i_BFu1c");
    static aSf_BFu1i_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1i_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu1c(Test_aSf_BFu1i_BFu1c, "aSf_BFu1i_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu1i()
{
  {
    init_simple_test("aSf_BFu1i_BFu1i");
    static aSf_BFu1i_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1i_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu1i(Test_aSf_BFu1i_BFu1i, "aSf_BFu1i_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu1ll()
{
  {
    init_simple_test("aSf_BFu1i_BFu1ll");
    static aSf_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu1ll(Test_aSf_BFu1i_BFu1ll, "aSf_BFu1i_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu1s()
{
  {
    init_simple_test("aSf_BFu1i_BFu1s");
    static aSf_BFu1i_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1i_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu1s(Test_aSf_BFu1i_BFu1s, "aSf_BFu1i_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu31i()
{
  {
    init_simple_test("aSf_BFu1i_BFu31i");
    static aSf_BFu1i_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu1i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aSf_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aSf_BFu1i_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu31i(Test_aSf_BFu1i_BFu31i, "aSf_BFu1i_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu31ll()
{
  {
    init_simple_test("aSf_BFu1i_BFu31ll");
    static aSf_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu1i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aSf_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aSf_BFu1i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu31ll(Test_aSf_BFu1i_BFu31ll, "aSf_BFu1i_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu32i()
{
  {
    init_simple_test("aSf_BFu1i_BFu32i");
    static aSf_BFu1i_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aSf_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aSf_BFu1i_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu32i(Test_aSf_BFu1i_BFu32i, "aSf_BFu1i_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu32ll()
{
  {
    init_simple_test("aSf_BFu1i_BFu32ll");
    static aSf_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aSf_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aSf_BFu1i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu32ll(Test_aSf_BFu1i_BFu32ll, "aSf_BFu1i_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu33()
{
  {
    init_simple_test("aSf_BFu1i_BFu33");
    static aSf_BFu1i_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "aSf_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "aSf_BFu1i_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu33(Test_aSf_BFu1i_BFu33, "aSf_BFu1i_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu7c()
{
  {
    init_simple_test("aSf_BFu1i_BFu7c");
    static aSf_BFu1i_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1i_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu7c(Test_aSf_BFu1i_BFu7c, "aSf_BFu1i_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu7i()
{
  {
    init_simple_test("aSf_BFu1i_BFu7i");
    static aSf_BFu1i_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1i_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu7i(Test_aSf_BFu1i_BFu7i, "aSf_BFu1i_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu7ll()
{
  {
    init_simple_test("aSf_BFu1i_BFu7ll");
    static aSf_BFu1i_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu7ll(Test_aSf_BFu1i_BFu7ll, "aSf_BFu1i_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu7s()
{
  {
    init_simple_test("aSf_BFu1i_BFu7s");
    static aSf_BFu1i_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1i_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu7s(Test_aSf_BFu1i_BFu7s, "aSf_BFu1i_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu8c()
{
  {
    init_simple_test("aSf_BFu1i_BFu8c");
    static aSf_BFu1i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1i_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu8c(Test_aSf_BFu1i_BFu8c, "aSf_BFu1i_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu8i()
{
  {
    init_simple_test("aSf_BFu1i_BFu8i");
    static aSf_BFu1i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1i_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu8i(Test_aSf_BFu1i_BFu8i, "aSf_BFu1i_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu8ll()
{
  {
    init_simple_test("aSf_BFu1i_BFu8ll");
    static aSf_BFu1i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu8ll(Test_aSf_BFu1i_BFu8ll, "aSf_BFu1i_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu8s()
{
  {
    init_simple_test("aSf_BFu1i_BFu8s");
    static aSf_BFu1i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1i_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu8s(Test_aSf_BFu1i_BFu8s, "aSf_BFu1i_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu9i()
{
  {
    init_simple_test("aSf_BFu1i_BFu9i");
    static aSf_BFu1i_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aSf_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aSf_BFu1i_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu9i(Test_aSf_BFu1i_BFu9i, "aSf_BFu1i_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu9ll()
{
  {
    init_simple_test("aSf_BFu1i_BFu9ll");
    static aSf_BFu1i_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aSf_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aSf_BFu1i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu9ll(Test_aSf_BFu1i_BFu9ll, "aSf_BFu1i_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_BFu9s()
{
  {
    init_simple_test("aSf_BFu1i_BFu9s");
    static aSf_BFu1i_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aSf_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aSf_BFu1i_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_BFu9s(Test_aSf_BFu1i_BFu9s, "aSf_BFu1i_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_C()
{
  {
    init_simple_test("aSf_BFu1i_C");
    static aSf_BFu1i_C lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_C");
    check_field_offset(lv, v3, 2, "aSf_BFu1i_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_C(Test_aSf_BFu1i_C, "aSf_BFu1i_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_D()
{
  {
    init_simple_test("aSf_BFu1i_D");
    static aSf_BFu1i_D lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu1i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_D");
    check_field_offset(lv, v3, 2, "aSf_BFu1i_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_D(Test_aSf_BFu1i_D, "aSf_BFu1i_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_F()
{
  {
    init_simple_test("aSf_BFu1i_F");
    static aSf_BFu1i_F lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_F");
    check_field_offset(lv, v3, 2, "aSf_BFu1i_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_F(Test_aSf_BFu1i_F, "aSf_BFu1i_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_I()
{
  {
    init_simple_test("aSf_BFu1i_I");
    static aSf_BFu1i_I lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_I");
    check_field_offset(lv, v3, 2, "aSf_BFu1i_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_I(Test_aSf_BFu1i_I, "aSf_BFu1i_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_Ip()
{
  {
    init_simple_test("aSf_BFu1i_Ip");
    static aSf_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu1i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_Ip");
    check_field_offset(lv, v3, 2, "aSf_BFu1i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_Ip(Test_aSf_BFu1i_Ip, "aSf_BFu1i_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_L()
{
  {
    init_simple_test("aSf_BFu1i_L");
    static aSf_BFu1i_L lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu1i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_L");
    check_field_offset(lv, v3, 2, "aSf_BFu1i_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_L(Test_aSf_BFu1i_L, "aSf_BFu1i_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_S()
{
  {
    init_simple_test("aSf_BFu1i_S");
    static aSf_BFu1i_S lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_S");
    check_field_offset(lv, v3, 2, "aSf_BFu1i_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_S(Test_aSf_BFu1i_S, "aSf_BFu1i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_Sf()
{
  {
    init_simple_test("aSf_BFu1i_Sf");
    static aSf_BFu1i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "aSf_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_Sf(Test_aSf_BFu1i_Sf, "aSf_BFu1i_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_Uc()
{
  {
    init_simple_test("aSf_BFu1i_Uc");
    static aSf_BFu1i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_Uc");
    check_field_offset(lv, v3, 2, "aSf_BFu1i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_Uc(Test_aSf_BFu1i_Uc, "aSf_BFu1i_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_Ui()
{
  {
    init_simple_test("aSf_BFu1i_Ui");
    static aSf_BFu1i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_Ui");
    check_field_offset(lv, v3, 2, "aSf_BFu1i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_Ui(Test_aSf_BFu1i_Ui, "aSf_BFu1i_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_Ul()
{
  {
    init_simple_test("aSf_BFu1i_Ul");
    static aSf_BFu1i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu1i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_Ul");
    check_field_offset(lv, v3, 2, "aSf_BFu1i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_Ul(Test_aSf_BFu1i_Ul, "aSf_BFu1i_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_Us()
{
  {
    init_simple_test("aSf_BFu1i_Us");
    static aSf_BFu1i_Us lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_Us");
    check_field_offset(lv, v3, 2, "aSf_BFu1i_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_Us(Test_aSf_BFu1i_Us, "aSf_BFu1i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1i_Vp()
{
  {
    init_simple_test("aSf_BFu1i_Vp");
    static aSf_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu1i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1i_Vp");
    check_field_offset(lv, v3, 2, "aSf_BFu1i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1i_Vp(Test_aSf_BFu1i_Vp, "aSf_BFu1i_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll()
{
  {
    init_simple_test("aSf_BFu1ll");
    static aSf_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll(Test_aSf_BFu1ll, "aSf_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu15i()
{
  {
    init_simple_test("aSf_BFu1ll_BFu15i");
    static aSf_BFu1ll_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aSf_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aSf_BFu1ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu15i(Test_aSf_BFu1ll_BFu15i, "aSf_BFu1ll_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu15ll()
{
  {
    init_simple_test("aSf_BFu1ll_BFu15ll");
    static aSf_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aSf_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aSf_BFu1ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu15ll(Test_aSf_BFu1ll_BFu15ll, "aSf_BFu1ll_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu15s()
{
  {
    init_simple_test("aSf_BFu1ll_BFu15s");
    static aSf_BFu1ll_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aSf_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aSf_BFu1ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu15s(Test_aSf_BFu1ll_BFu15s, "aSf_BFu1ll_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu16i()
{
  {
    init_simple_test("aSf_BFu1ll_BFu16i");
    static aSf_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aSf_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aSf_BFu1ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu16i(Test_aSf_BFu1ll_BFu16i, "aSf_BFu1ll_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu16ll()
{
  {
    init_simple_test("aSf_BFu1ll_BFu16ll");
    static aSf_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aSf_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aSf_BFu1ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu16ll(Test_aSf_BFu1ll_BFu16ll, "aSf_BFu1ll_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu16s()
{
  {
    init_simple_test("aSf_BFu1ll_BFu16s");
    static aSf_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aSf_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aSf_BFu1ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu16s(Test_aSf_BFu1ll_BFu16s, "aSf_BFu1ll_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu17i()
{
  {
    init_simple_test("aSf_BFu1ll_BFu17i");
    static aSf_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aSf_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aSf_BFu1ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu17i(Test_aSf_BFu1ll_BFu17i, "aSf_BFu1ll_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu17ll()
{
  {
    init_simple_test("aSf_BFu1ll_BFu17ll");
    static aSf_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aSf_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aSf_BFu1ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu17ll(Test_aSf_BFu1ll_BFu17ll, "aSf_BFu1ll_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu1c()
{
  {
    init_simple_test("aSf_BFu1ll_BFu1c");
    static aSf_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu1c(Test_aSf_BFu1ll_BFu1c, "aSf_BFu1ll_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu1i()
{
  {
    init_simple_test("aSf_BFu1ll_BFu1i");
    static aSf_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu1i(Test_aSf_BFu1ll_BFu1i, "aSf_BFu1ll_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu1ll()
{
  {
    init_simple_test("aSf_BFu1ll_BFu1ll");
    static aSf_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu1ll(Test_aSf_BFu1ll_BFu1ll, "aSf_BFu1ll_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu1s()
{
  {
    init_simple_test("aSf_BFu1ll_BFu1s");
    static aSf_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu1s(Test_aSf_BFu1ll_BFu1s, "aSf_BFu1ll_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu31i()
{
  {
    init_simple_test("aSf_BFu1ll_BFu31i");
    static aSf_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu1ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aSf_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aSf_BFu1ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu31i(Test_aSf_BFu1ll_BFu31i, "aSf_BFu1ll_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu31ll()
{
  {
    init_simple_test("aSf_BFu1ll_BFu31ll");
    static aSf_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aSf_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aSf_BFu1ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu31ll(Test_aSf_BFu1ll_BFu31ll, "aSf_BFu1ll_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu32i()
{
  {
    init_simple_test("aSf_BFu1ll_BFu32i");
    static aSf_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aSf_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aSf_BFu1ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu32i(Test_aSf_BFu1ll_BFu32i, "aSf_BFu1ll_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu32ll()
{
  {
    init_simple_test("aSf_BFu1ll_BFu32ll");
    static aSf_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aSf_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aSf_BFu1ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu32ll(Test_aSf_BFu1ll_BFu32ll, "aSf_BFu1ll_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu33()
{
  {
    init_simple_test("aSf_BFu1ll_BFu33");
    static aSf_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "aSf_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "aSf_BFu1ll_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu33(Test_aSf_BFu1ll_BFu33, "aSf_BFu1ll_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu7c()
{
  {
    init_simple_test("aSf_BFu1ll_BFu7c");
    static aSf_BFu1ll_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu7c(Test_aSf_BFu1ll_BFu7c, "aSf_BFu1ll_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu7i()
{
  {
    init_simple_test("aSf_BFu1ll_BFu7i");
    static aSf_BFu1ll_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu7i(Test_aSf_BFu1ll_BFu7i, "aSf_BFu1ll_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu7ll()
{
  {
    init_simple_test("aSf_BFu1ll_BFu7ll");
    static aSf_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu7ll(Test_aSf_BFu1ll_BFu7ll, "aSf_BFu1ll_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu7s()
{
  {
    init_simple_test("aSf_BFu1ll_BFu7s");
    static aSf_BFu1ll_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu7s(Test_aSf_BFu1ll_BFu7s, "aSf_BFu1ll_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu8c()
{
  {
    init_simple_test("aSf_BFu1ll_BFu8c");
    static aSf_BFu1ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu8c(Test_aSf_BFu1ll_BFu8c, "aSf_BFu1ll_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu8i()
{
  {
    init_simple_test("aSf_BFu1ll_BFu8i");
    static aSf_BFu1ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu8i(Test_aSf_BFu1ll_BFu8i, "aSf_BFu1ll_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu8ll()
{
  {
    init_simple_test("aSf_BFu1ll_BFu8ll");
    static aSf_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu8ll(Test_aSf_BFu1ll_BFu8ll, "aSf_BFu1ll_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu8s()
{
  {
    init_simple_test("aSf_BFu1ll_BFu8s");
    static aSf_BFu1ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu8s(Test_aSf_BFu1ll_BFu8s, "aSf_BFu1ll_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu9i()
{
  {
    init_simple_test("aSf_BFu1ll_BFu9i");
    static aSf_BFu1ll_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aSf_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aSf_BFu1ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu9i(Test_aSf_BFu1ll_BFu9i, "aSf_BFu1ll_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu9ll()
{
  {
    init_simple_test("aSf_BFu1ll_BFu9ll");
    static aSf_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aSf_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aSf_BFu1ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu9ll(Test_aSf_BFu1ll_BFu9ll, "aSf_BFu1ll_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_BFu9s()
{
  {
    init_simple_test("aSf_BFu1ll_BFu9s");
    static aSf_BFu1ll_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aSf_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aSf_BFu1ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_BFu9s(Test_aSf_BFu1ll_BFu9s, "aSf_BFu1ll_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_C()
{
  {
    init_simple_test("aSf_BFu1ll_C");
    static aSf_BFu1ll_C lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_C");
    check_field_offset(lv, v3, 2, "aSf_BFu1ll_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_C(Test_aSf_BFu1ll_C, "aSf_BFu1ll_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_D()
{
  {
    init_simple_test("aSf_BFu1ll_D");
    static aSf_BFu1ll_D lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu1ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_D");
    check_field_offset(lv, v3, 2, "aSf_BFu1ll_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_D(Test_aSf_BFu1ll_D, "aSf_BFu1ll_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_F()
{
  {
    init_simple_test("aSf_BFu1ll_F");
    static aSf_BFu1ll_F lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_F");
    check_field_offset(lv, v3, 2, "aSf_BFu1ll_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_F(Test_aSf_BFu1ll_F, "aSf_BFu1ll_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_I()
{
  {
    init_simple_test("aSf_BFu1ll_I");
    static aSf_BFu1ll_I lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_I");
    check_field_offset(lv, v3, 2, "aSf_BFu1ll_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_I(Test_aSf_BFu1ll_I, "aSf_BFu1ll_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_Ip()
{
  {
    init_simple_test("aSf_BFu1ll_Ip");
    static aSf_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu1ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_Ip");
    check_field_offset(lv, v3, 2, "aSf_BFu1ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_Ip(Test_aSf_BFu1ll_Ip, "aSf_BFu1ll_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_L()
{
  {
    init_simple_test("aSf_BFu1ll_L");
    static aSf_BFu1ll_L lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu1ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_L");
    check_field_offset(lv, v3, 2, "aSf_BFu1ll_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_L(Test_aSf_BFu1ll_L, "aSf_BFu1ll_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_S()
{
  {
    init_simple_test("aSf_BFu1ll_S");
    static aSf_BFu1ll_S lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_S");
    check_field_offset(lv, v3, 2, "aSf_BFu1ll_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_S(Test_aSf_BFu1ll_S, "aSf_BFu1ll_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_Sf()
{
  {
    init_simple_test("aSf_BFu1ll_Sf");
    static aSf_BFu1ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "aSf_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_Sf(Test_aSf_BFu1ll_Sf, "aSf_BFu1ll_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_Uc()
{
  {
    init_simple_test("aSf_BFu1ll_Uc");
    static aSf_BFu1ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_Uc");
    check_field_offset(lv, v3, 2, "aSf_BFu1ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_Uc(Test_aSf_BFu1ll_Uc, "aSf_BFu1ll_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_Ui()
{
  {
    init_simple_test("aSf_BFu1ll_Ui");
    static aSf_BFu1ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_Ui");
    check_field_offset(lv, v3, 2, "aSf_BFu1ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_Ui(Test_aSf_BFu1ll_Ui, "aSf_BFu1ll_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_Ul()
{
  {
    init_simple_test("aSf_BFu1ll_Ul");
    static aSf_BFu1ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu1ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_Ul");
    check_field_offset(lv, v3, 2, "aSf_BFu1ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_Ul(Test_aSf_BFu1ll_Ul, "aSf_BFu1ll_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_Us()
{
  {
    init_simple_test("aSf_BFu1ll_Us");
    static aSf_BFu1ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_Us");
    check_field_offset(lv, v3, 2, "aSf_BFu1ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_Us(Test_aSf_BFu1ll_Us, "aSf_BFu1ll_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1ll_Vp()
{
  {
    init_simple_test("aSf_BFu1ll_Vp");
    static aSf_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu1ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1ll_Vp");
    check_field_offset(lv, v3, 2, "aSf_BFu1ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1ll_Vp(Test_aSf_BFu1ll_Vp, "aSf_BFu1ll_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s()
{
  {
    init_simple_test("aSf_BFu1s");
    static aSf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s(Test_aSf_BFu1s, "aSf_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu15i()
{
  {
    init_simple_test("aSf_BFu1s_BFu15i");
    static aSf_BFu1s_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aSf_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aSf_BFu1s_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu15i(Test_aSf_BFu1s_BFu15i, "aSf_BFu1s_BFu15i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu15ll()
{
  {
    init_simple_test("aSf_BFu1s_BFu15ll");
    static aSf_BFu1s_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aSf_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aSf_BFu1s_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu15ll(Test_aSf_BFu1s_BFu15ll, "aSf_BFu1s_BFu15ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu15s()
{
  {
    init_simple_test("aSf_BFu1s_BFu15s");
    static aSf_BFu1s_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "aSf_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "aSf_BFu1s_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu15s(Test_aSf_BFu1s_BFu15s, "aSf_BFu1s_BFu15s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu16i()
{
  {
    init_simple_test("aSf_BFu1s_BFu16i");
    static aSf_BFu1s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aSf_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aSf_BFu1s_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu16i(Test_aSf_BFu1s_BFu16i, "aSf_BFu1s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu16ll()
{
  {
    init_simple_test("aSf_BFu1s_BFu16ll");
    static aSf_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aSf_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aSf_BFu1s_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu16ll(Test_aSf_BFu1s_BFu16ll, "aSf_BFu1s_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu16s()
{
  {
    init_simple_test("aSf_BFu1s_BFu16s");
    static aSf_BFu1s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "aSf_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "aSf_BFu1s_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu16s(Test_aSf_BFu1s_BFu16s, "aSf_BFu1s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu17i()
{
  {
    init_simple_test("aSf_BFu1s_BFu17i");
    static aSf_BFu1s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aSf_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aSf_BFu1s_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu17i(Test_aSf_BFu1s_BFu17i, "aSf_BFu1s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu17ll()
{
  {
    init_simple_test("aSf_BFu1s_BFu17ll");
    static aSf_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "aSf_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "aSf_BFu1s_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu17ll(Test_aSf_BFu1s_BFu17ll, "aSf_BFu1s_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu1c()
{
  {
    init_simple_test("aSf_BFu1s_BFu1c");
    static aSf_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1s_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu1c(Test_aSf_BFu1s_BFu1c, "aSf_BFu1s_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu1i()
{
  {
    init_simple_test("aSf_BFu1s_BFu1i");
    static aSf_BFu1s_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1s_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu1i(Test_aSf_BFu1s_BFu1i, "aSf_BFu1s_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu1ll()
{
  {
    init_simple_test("aSf_BFu1s_BFu1ll");
    static aSf_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1s_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu1ll(Test_aSf_BFu1s_BFu1ll, "aSf_BFu1s_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu1s()
{
  {
    init_simple_test("aSf_BFu1s_BFu1s");
    static aSf_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "aSf_BFu1s_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu1s(Test_aSf_BFu1s_BFu1s, "aSf_BFu1s_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu31i()
{
  {
    init_simple_test("aSf_BFu1s_BFu31i");
    static aSf_BFu1s_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu1s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aSf_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aSf_BFu1s_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu31i(Test_aSf_BFu1s_BFu31i, "aSf_BFu1s_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu31ll()
{
  {
    init_simple_test("aSf_BFu1s_BFu31ll");
    static aSf_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu1s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "aSf_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "aSf_BFu1s_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu31ll(Test_aSf_BFu1s_BFu31ll, "aSf_BFu1s_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu32i()
{
  {
    init_simple_test("aSf_BFu1s_BFu32i");
    static aSf_BFu1s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aSf_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aSf_BFu1s_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu32i(Test_aSf_BFu1s_BFu32i, "aSf_BFu1s_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu32ll()
{
  {
    init_simple_test("aSf_BFu1s_BFu32ll");
    static aSf_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "aSf_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "aSf_BFu1s_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu32ll(Test_aSf_BFu1s_BFu32ll, "aSf_BFu1s_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu33()
{
  {
    init_simple_test("aSf_BFu1s_BFu33");
    static aSf_BFu1s_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "aSf_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "aSf_BFu1s_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu33(Test_aSf_BFu1s_BFu33, "aSf_BFu1s_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu7c()
{
  {
    init_simple_test("aSf_BFu1s_BFu7c");
    static aSf_BFu1s_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1s_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu7c(Test_aSf_BFu1s_BFu7c, "aSf_BFu1s_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu7i()
{
  {
    init_simple_test("aSf_BFu1s_BFu7i");
    static aSf_BFu1s_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1s_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu7i(Test_aSf_BFu1s_BFu7i, "aSf_BFu1s_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu7ll()
{
  {
    init_simple_test("aSf_BFu1s_BFu7ll");
    static aSf_BFu1s_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1s_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu7ll(Test_aSf_BFu1s_BFu7ll, "aSf_BFu1s_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu7s()
{
  {
    init_simple_test("aSf_BFu1s_BFu7s");
    static aSf_BFu1s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu1s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "aSf_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "aSf_BFu1s_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu7s(Test_aSf_BFu1s_BFu7s, "aSf_BFu1s_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu8c()
{
  {
    init_simple_test("aSf_BFu1s_BFu8c");
    static aSf_BFu1s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1s_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu8c(Test_aSf_BFu1s_BFu8c, "aSf_BFu1s_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu8i()
{
  {
    init_simple_test("aSf_BFu1s_BFu8i");
    static aSf_BFu1s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1s_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu8i(Test_aSf_BFu1s_BFu8i, "aSf_BFu1s_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu8ll()
{
  {
    init_simple_test("aSf_BFu1s_BFu8ll");
    static aSf_BFu1s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1s_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu8ll(Test_aSf_BFu1s_BFu8ll, "aSf_BFu1s_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu8s()
{
  {
    init_simple_test("aSf_BFu1s_BFu8s");
    static aSf_BFu1s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "aSf_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "aSf_BFu1s_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu8s(Test_aSf_BFu1s_BFu8s, "aSf_BFu1s_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu9i()
{
  {
    init_simple_test("aSf_BFu1s_BFu9i");
    static aSf_BFu1s_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aSf_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aSf_BFu1s_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu9i(Test_aSf_BFu1s_BFu9i, "aSf_BFu1s_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu9ll()
{
  {
    init_simple_test("aSf_BFu1s_BFu9ll");
    static aSf_BFu1s_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aSf_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aSf_BFu1s_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu9ll(Test_aSf_BFu1s_BFu9ll, "aSf_BFu1s_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_BFu9s()
{
  {
    init_simple_test("aSf_BFu1s_BFu9s");
    static aSf_BFu1s_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "aSf_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "aSf_BFu1s_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_BFu9s(Test_aSf_BFu1s_BFu9s, "aSf_BFu1s_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_C()
{
  {
    init_simple_test("aSf_BFu1s_C");
    static aSf_BFu1s_C lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_C");
    check_field_offset(lv, v3, 2, "aSf_BFu1s_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_C(Test_aSf_BFu1s_C, "aSf_BFu1s_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_D()
{
  {
    init_simple_test("aSf_BFu1s_D");
    static aSf_BFu1s_D lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu1s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_D");
    check_field_offset(lv, v3, 2, "aSf_BFu1s_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_D(Test_aSf_BFu1s_D, "aSf_BFu1s_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_F()
{
  {
    init_simple_test("aSf_BFu1s_F");
    static aSf_BFu1s_F lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_F");
    check_field_offset(lv, v3, 2, "aSf_BFu1s_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_F(Test_aSf_BFu1s_F, "aSf_BFu1s_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_I()
{
  {
    init_simple_test("aSf_BFu1s_I");
    static aSf_BFu1s_I lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_I");
    check_field_offset(lv, v3, 2, "aSf_BFu1s_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_I(Test_aSf_BFu1s_I, "aSf_BFu1s_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_Ip()
{
  {
    init_simple_test("aSf_BFu1s_Ip");
    static aSf_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu1s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_Ip");
    check_field_offset(lv, v3, 2, "aSf_BFu1s_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_Ip(Test_aSf_BFu1s_Ip, "aSf_BFu1s_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_L()
{
  {
    init_simple_test("aSf_BFu1s_L");
    static aSf_BFu1s_L lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu1s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_L");
    check_field_offset(lv, v3, 2, "aSf_BFu1s_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_L(Test_aSf_BFu1s_L, "aSf_BFu1s_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_S()
{
  {
    init_simple_test("aSf_BFu1s_S");
    static aSf_BFu1s_S lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_S");
    check_field_offset(lv, v3, 2, "aSf_BFu1s_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_S(Test_aSf_BFu1s_S, "aSf_BFu1s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_Sf()
{
  {
    init_simple_test("aSf_BFu1s_Sf");
    static aSf_BFu1s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "aSf_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_Sf(Test_aSf_BFu1s_Sf, "aSf_BFu1s_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_Uc()
{
  {
    init_simple_test("aSf_BFu1s_Uc");
    static aSf_BFu1s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu1s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_Uc");
    check_field_offset(lv, v3, 2, "aSf_BFu1s_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_Uc(Test_aSf_BFu1s_Uc, "aSf_BFu1s_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_Ui()
{
  {
    init_simple_test("aSf_BFu1s_Ui");
    static aSf_BFu1s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu1s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_Ui");
    check_field_offset(lv, v3, 2, "aSf_BFu1s_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_Ui(Test_aSf_BFu1s_Ui, "aSf_BFu1s_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_Ul()
{
  {
    init_simple_test("aSf_BFu1s_Ul");
    static aSf_BFu1s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu1s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_Ul");
    check_field_offset(lv, v3, 2, "aSf_BFu1s_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_Ul(Test_aSf_BFu1s_Ul, "aSf_BFu1s_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_Us()
{
  {
    init_simple_test("aSf_BFu1s_Us");
    static aSf_BFu1s_Us lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu1s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_Us");
    check_field_offset(lv, v3, 2, "aSf_BFu1s_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_Us(Test_aSf_BFu1s_Us, "aSf_BFu1s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu1s_Vp()
{
  {
    init_simple_test("aSf_BFu1s_Vp");
    static aSf_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu1s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aSf_BFu1s_Vp");
    check_field_offset(lv, v3, 2, "aSf_BFu1s_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu1s_Vp(Test_aSf_BFu1s_Vp, "aSf_BFu1s_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i()
{
  {
    init_simple_test("aSf_BFu31i");
    static aSf_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i(Test_aSf_BFu31i, "aSf_BFu31i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu15i()
{
  {
    init_simple_test("aSf_BFu31i_BFu15i");
    static aSf_BFu31i_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aSf_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aSf_BFu31i_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu15i(Test_aSf_BFu31i_BFu15i, "aSf_BFu31i_BFu15i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu15ll()
{
  {
    init_simple_test("aSf_BFu31i_BFu15ll");
    static aSf_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aSf_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aSf_BFu31i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu15ll(Test_aSf_BFu31i_BFu15ll, "aSf_BFu31i_BFu15ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu15s()
{
  {
    init_simple_test("aSf_BFu31i_BFu15s");
    static aSf_BFu31i_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aSf_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aSf_BFu31i_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu15s(Test_aSf_BFu31i_BFu15s, "aSf_BFu31i_BFu15s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu16i()
{
  {
    init_simple_test("aSf_BFu31i_BFu16i");
    static aSf_BFu31i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aSf_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aSf_BFu31i_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu16i(Test_aSf_BFu31i_BFu16i, "aSf_BFu31i_BFu16i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu16ll()
{
  {
    init_simple_test("aSf_BFu31i_BFu16ll");
    static aSf_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aSf_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aSf_BFu31i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu16ll(Test_aSf_BFu31i_BFu16ll, "aSf_BFu31i_BFu16ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu16s()
{
  {
    init_simple_test("aSf_BFu31i_BFu16s");
    static aSf_BFu31i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aSf_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aSf_BFu31i_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu16s(Test_aSf_BFu31i_BFu16s, "aSf_BFu31i_BFu16s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu17i()
{
  {
    init_simple_test("aSf_BFu31i_BFu17i");
    static aSf_BFu31i_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aSf_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aSf_BFu31i_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu17i(Test_aSf_BFu31i_BFu17i, "aSf_BFu31i_BFu17i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu17ll()
{
  {
    init_simple_test("aSf_BFu31i_BFu17ll");
    static aSf_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aSf_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aSf_BFu31i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu17ll(Test_aSf_BFu31i_BFu17ll, "aSf_BFu31i_BFu17ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu1c()
{
  {
    init_simple_test("aSf_BFu31i_BFu1c");
    static aSf_BFu31i_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu31i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aSf_BFu31i_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu1c(Test_aSf_BFu31i_BFu1c, "aSf_BFu31i_BFu1c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu1i()
{
  {
    init_simple_test("aSf_BFu31i_BFu1i");
    static aSf_BFu31i_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu31i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aSf_BFu31i_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu1i(Test_aSf_BFu31i_BFu1i, "aSf_BFu31i_BFu1i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu1ll()
{
  {
    init_simple_test("aSf_BFu31i_BFu1ll");
    static aSf_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu31i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aSf_BFu31i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu1ll(Test_aSf_BFu31i_BFu1ll, "aSf_BFu31i_BFu1ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu1s()
{
  {
    init_simple_test("aSf_BFu31i_BFu1s");
    static aSf_BFu31i_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu31i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aSf_BFu31i_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu1s(Test_aSf_BFu31i_BFu1s, "aSf_BFu31i_BFu1s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu31i()
{
  {
    init_simple_test("aSf_BFu31i_BFu31i");
    static aSf_BFu31i_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aSf_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu31i(Test_aSf_BFu31i_BFu31i, "aSf_BFu31i_BFu31i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu31ll()
{
  {
    init_simple_test("aSf_BFu31i_BFu31ll");
    static aSf_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aSf_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu31ll(Test_aSf_BFu31i_BFu31ll, "aSf_BFu31i_BFu31ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu32i()
{
  {
    init_simple_test("aSf_BFu31i_BFu32i");
    static aSf_BFu31i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aSf_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aSf_BFu31i_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu32i(Test_aSf_BFu31i_BFu32i, "aSf_BFu31i_BFu32i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu32ll()
{
  {
    init_simple_test("aSf_BFu31i_BFu32ll");
    static aSf_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aSf_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aSf_BFu31i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu32ll(Test_aSf_BFu31i_BFu32ll, "aSf_BFu31i_BFu32ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu33()
{
  {
    init_simple_test("aSf_BFu31i_BFu33");
    static aSf_BFu31i_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, 1, "aSf_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, hide_ull(1LL<<32), "aSf_BFu31i_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu33(Test_aSf_BFu31i_BFu33, "aSf_BFu31i_BFu33", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu7c()
{
  {
    init_simple_test("aSf_BFu31i_BFu7c");
    static aSf_BFu31i_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aSf_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aSf_BFu31i_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu7c(Test_aSf_BFu31i_BFu7c, "aSf_BFu31i_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu7i()
{
  {
    init_simple_test("aSf_BFu31i_BFu7i");
    static aSf_BFu31i_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aSf_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aSf_BFu31i_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu7i(Test_aSf_BFu31i_BFu7i, "aSf_BFu31i_BFu7i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu7ll()
{
  {
    init_simple_test("aSf_BFu31i_BFu7ll");
    static aSf_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aSf_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aSf_BFu31i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu7ll(Test_aSf_BFu31i_BFu7ll, "aSf_BFu31i_BFu7ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu7s()
{
  {
    init_simple_test("aSf_BFu31i_BFu7s");
    static aSf_BFu31i_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aSf_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aSf_BFu31i_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu7s(Test_aSf_BFu31i_BFu7s, "aSf_BFu31i_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu8c()
{
  {
    init_simple_test("aSf_BFu31i_BFu8c");
    static aSf_BFu31i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aSf_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aSf_BFu31i_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu8c(Test_aSf_BFu31i_BFu8c, "aSf_BFu31i_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu8i()
{
  {
    init_simple_test("aSf_BFu31i_BFu8i");
    static aSf_BFu31i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aSf_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aSf_BFu31i_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu8i(Test_aSf_BFu31i_BFu8i, "aSf_BFu31i_BFu8i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu8ll()
{
  {
    init_simple_test("aSf_BFu31i_BFu8ll");
    static aSf_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aSf_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aSf_BFu31i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu8ll(Test_aSf_BFu31i_BFu8ll, "aSf_BFu31i_BFu8ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu8s()
{
  {
    init_simple_test("aSf_BFu31i_BFu8s");
    static aSf_BFu31i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aSf_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aSf_BFu31i_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu8s(Test_aSf_BFu31i_BFu8s, "aSf_BFu31i_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu9i()
{
  {
    init_simple_test("aSf_BFu31i_BFu9i");
    static aSf_BFu31i_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aSf_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aSf_BFu31i_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu9i(Test_aSf_BFu31i_BFu9i, "aSf_BFu31i_BFu9i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu9ll()
{
  {
    init_simple_test("aSf_BFu31i_BFu9ll");
    static aSf_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aSf_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aSf_BFu31i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu9ll(Test_aSf_BFu31i_BFu9ll, "aSf_BFu31i_BFu9ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_BFu9s()
{
  {
    init_simple_test("aSf_BFu31i_BFu9s");
    static aSf_BFu31i_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aSf_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aSf_BFu31i_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_BFu9s(Test_aSf_BFu31i_BFu9s, "aSf_BFu31i_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_C()
{
  {
    init_simple_test("aSf_BFu31i_C");
    static aSf_BFu31i_C lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_C");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_C");
    check_field_offset(lv, v3, 5, "aSf_BFu31i_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_C(Test_aSf_BFu31i_C, "aSf_BFu31i_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_D()
{
  {
    init_simple_test("aSf_BFu31i_D");
    static aSf_BFu31i_D lv;
    check2(sizeof(lv), 13, "sizeof(aSf_BFu31i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_D");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_D");
    check_field_offset(lv, v3, 5, "aSf_BFu31i_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_D(Test_aSf_BFu31i_D, "aSf_BFu31i_D", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_F()
{
  {
    init_simple_test("aSf_BFu31i_F");
    static aSf_BFu31i_F lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_F");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_F");
    check_field_offset(lv, v3, 5, "aSf_BFu31i_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_F(Test_aSf_BFu31i_F, "aSf_BFu31i_F", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_I()
{
  {
    init_simple_test("aSf_BFu31i_I");
    static aSf_BFu31i_I lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_I");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_I");
    check_field_offset(lv, v3, 5, "aSf_BFu31i_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_I(Test_aSf_BFu31i_I, "aSf_BFu31i_I", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_Ip()
{
  {
    init_simple_test("aSf_BFu31i_Ip");
    static aSf_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aSf_BFu31i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_Ip");
    check_field_offset(lv, v3, 5, "aSf_BFu31i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_Ip(Test_aSf_BFu31i_Ip, "aSf_BFu31i_Ip", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_L()
{
  {
    init_simple_test("aSf_BFu31i_L");
    static aSf_BFu31i_L lv;
    check2(sizeof(lv), 13, "sizeof(aSf_BFu31i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_L");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_L");
    check_field_offset(lv, v3, 5, "aSf_BFu31i_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_L(Test_aSf_BFu31i_L, "aSf_BFu31i_L", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_S()
{
  {
    init_simple_test("aSf_BFu31i_S");
    static aSf_BFu31i_S lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_S");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_S");
    check_field_offset(lv, v3, 5, "aSf_BFu31i_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_S(Test_aSf_BFu31i_S, "aSf_BFu31i_S", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_Sf()
{
  {
    init_simple_test("aSf_BFu31i_Sf");
    static aSf_BFu31i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_Sf");
    check_field_offset(lv, v3, 5, "aSf_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_Sf(Test_aSf_BFu31i_Sf, "aSf_BFu31i_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_Uc()
{
  {
    init_simple_test("aSf_BFu31i_Uc");
    static aSf_BFu31i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_Uc");
    check_field_offset(lv, v3, 5, "aSf_BFu31i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_Uc(Test_aSf_BFu31i_Uc, "aSf_BFu31i_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_Ui()
{
  {
    init_simple_test("aSf_BFu31i_Ui");
    static aSf_BFu31i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_Ui");
    check_field_offset(lv, v3, 5, "aSf_BFu31i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_Ui(Test_aSf_BFu31i_Ui, "aSf_BFu31i_Ui", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_Ul()
{
  {
    init_simple_test("aSf_BFu31i_Ul");
    static aSf_BFu31i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aSf_BFu31i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_Ul");
    check_field_offset(lv, v3, 5, "aSf_BFu31i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_Ul(Test_aSf_BFu31i_Ul, "aSf_BFu31i_Ul", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_Us()
{
  {
    init_simple_test("aSf_BFu31i_Us");
    static aSf_BFu31i_Us lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_Us");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_Us");
    check_field_offset(lv, v3, 5, "aSf_BFu31i_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_Us(Test_aSf_BFu31i_Us, "aSf_BFu31i_Us", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31i_Vp()
{
  {
    init_simple_test("aSf_BFu31i_Vp");
    static aSf_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aSf_BFu31i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_Vp");
    check_field_offset(lv, v3, 5, "aSf_BFu31i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31i_Vp(Test_aSf_BFu31i_Vp, "aSf_BFu31i_Vp", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll()
{
  {
    init_simple_test("aSf_BFu31ll");
    static aSf_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll(Test_aSf_BFu31ll, "aSf_BFu31ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu15i()
{
  {
    init_simple_test("aSf_BFu31ll_BFu15i");
    static aSf_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aSf_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aSf_BFu31ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu15i(Test_aSf_BFu31ll_BFu15i, "aSf_BFu31ll_BFu15i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu15ll()
{
  {
    init_simple_test("aSf_BFu31ll_BFu15ll");
    static aSf_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aSf_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aSf_BFu31ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu15ll(Test_aSf_BFu31ll_BFu15ll, "aSf_BFu31ll_BFu15ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu15s()
{
  {
    init_simple_test("aSf_BFu31ll_BFu15s");
    static aSf_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aSf_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aSf_BFu31ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu15s(Test_aSf_BFu31ll_BFu15s, "aSf_BFu31ll_BFu15s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu16i()
{
  {
    init_simple_test("aSf_BFu31ll_BFu16i");
    static aSf_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aSf_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aSf_BFu31ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu16i(Test_aSf_BFu31ll_BFu16i, "aSf_BFu31ll_BFu16i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu16ll()
{
  {
    init_simple_test("aSf_BFu31ll_BFu16ll");
    static aSf_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aSf_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aSf_BFu31ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu16ll(Test_aSf_BFu31ll_BFu16ll, "aSf_BFu31ll_BFu16ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu16s()
{
  {
    init_simple_test("aSf_BFu31ll_BFu16s");
    static aSf_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aSf_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aSf_BFu31ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu16s(Test_aSf_BFu31ll_BFu16s, "aSf_BFu31ll_BFu16s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu17i()
{
  {
    init_simple_test("aSf_BFu31ll_BFu17i");
    static aSf_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aSf_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aSf_BFu31ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu17i(Test_aSf_BFu31ll_BFu17i, "aSf_BFu31ll_BFu17i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu17ll()
{
  {
    init_simple_test("aSf_BFu31ll_BFu17ll");
    static aSf_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aSf_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aSf_BFu31ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu17ll(Test_aSf_BFu31ll_BFu17ll, "aSf_BFu31ll_BFu17ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu1c()
{
  {
    init_simple_test("aSf_BFu31ll_BFu1c");
    static aSf_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu31ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aSf_BFu31ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu1c(Test_aSf_BFu31ll_BFu1c, "aSf_BFu31ll_BFu1c", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu1i()
{
  {
    init_simple_test("aSf_BFu31ll_BFu1i");
    static aSf_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu31ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aSf_BFu31ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu1i(Test_aSf_BFu31ll_BFu1i, "aSf_BFu31ll_BFu1i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu1ll()
{
  {
    init_simple_test("aSf_BFu31ll_BFu1ll");
    static aSf_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aSf_BFu31ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu1ll(Test_aSf_BFu31ll_BFu1ll, "aSf_BFu31ll_BFu1ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu1s()
{
  {
    init_simple_test("aSf_BFu31ll_BFu1s");
    static aSf_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu31ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aSf_BFu31ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu1s(Test_aSf_BFu31ll_BFu1s, "aSf_BFu31ll_BFu1s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu31i()
{
  {
    init_simple_test("aSf_BFu31ll_BFu31i");
    static aSf_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aSf_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu31i(Test_aSf_BFu31ll_BFu31i, "aSf_BFu31ll_BFu31i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu31ll()
{
  {
    init_simple_test("aSf_BFu31ll_BFu31ll");
    static aSf_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aSf_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu31ll(Test_aSf_BFu31ll_BFu31ll, "aSf_BFu31ll_BFu31ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu32i()
{
  {
    init_simple_test("aSf_BFu31ll_BFu32i");
    static aSf_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aSf_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aSf_BFu31ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu32i(Test_aSf_BFu31ll_BFu32i, "aSf_BFu31ll_BFu32i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu32ll()
{
  {
    init_simple_test("aSf_BFu31ll_BFu32ll");
    static aSf_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aSf_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aSf_BFu31ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu32ll(Test_aSf_BFu31ll_BFu32ll, "aSf_BFu31ll_BFu32ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu33()
{
  {
    init_simple_test("aSf_BFu31ll_BFu33");
    static aSf_BFu31ll_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, 1, "aSf_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, hide_ull(1LL<<32), "aSf_BFu31ll_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu33(Test_aSf_BFu31ll_BFu33, "aSf_BFu31ll_BFu33", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu7c()
{
  {
    init_simple_test("aSf_BFu31ll_BFu7c");
    static aSf_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aSf_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aSf_BFu31ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu7c(Test_aSf_BFu31ll_BFu7c, "aSf_BFu31ll_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu7i()
{
  {
    init_simple_test("aSf_BFu31ll_BFu7i");
    static aSf_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aSf_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aSf_BFu31ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu7i(Test_aSf_BFu31ll_BFu7i, "aSf_BFu31ll_BFu7i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu7ll()
{
  {
    init_simple_test("aSf_BFu31ll_BFu7ll");
    static aSf_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aSf_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aSf_BFu31ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu7ll(Test_aSf_BFu31ll_BFu7ll, "aSf_BFu31ll_BFu7ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu7s()
{
  {
    init_simple_test("aSf_BFu31ll_BFu7s");
    static aSf_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aSf_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aSf_BFu31ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu7s(Test_aSf_BFu31ll_BFu7s, "aSf_BFu31ll_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu8c()
{
  {
    init_simple_test("aSf_BFu31ll_BFu8c");
    static aSf_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aSf_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aSf_BFu31ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu8c(Test_aSf_BFu31ll_BFu8c, "aSf_BFu31ll_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu8i()
{
  {
    init_simple_test("aSf_BFu31ll_BFu8i");
    static aSf_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aSf_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aSf_BFu31ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu8i(Test_aSf_BFu31ll_BFu8i, "aSf_BFu31ll_BFu8i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu8ll()
{
  {
    init_simple_test("aSf_BFu31ll_BFu8ll");
    static aSf_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aSf_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aSf_BFu31ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu8ll(Test_aSf_BFu31ll_BFu8ll, "aSf_BFu31ll_BFu8ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu8s()
{
  {
    init_simple_test("aSf_BFu31ll_BFu8s");
    static aSf_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aSf_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aSf_BFu31ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu8s(Test_aSf_BFu31ll_BFu8s, "aSf_BFu31ll_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu9i()
{
  {
    init_simple_test("aSf_BFu31ll_BFu9i");
    static aSf_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aSf_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aSf_BFu31ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu9i(Test_aSf_BFu31ll_BFu9i, "aSf_BFu31ll_BFu9i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu9ll()
{
  {
    init_simple_test("aSf_BFu31ll_BFu9ll");
    static aSf_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aSf_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aSf_BFu31ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu9ll(Test_aSf_BFu31ll_BFu9ll, "aSf_BFu31ll_BFu9ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_BFu9s()
{
  {
    init_simple_test("aSf_BFu31ll_BFu9s");
    static aSf_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aSf_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aSf_BFu31ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_BFu9s(Test_aSf_BFu31ll_BFu9s, "aSf_BFu31ll_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_C()
{
  {
    init_simple_test("aSf_BFu31ll_C");
    static aSf_BFu31ll_C lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_C");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_C");
    check_field_offset(lv, v3, 5, "aSf_BFu31ll_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_C(Test_aSf_BFu31ll_C, "aSf_BFu31ll_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_D()
{
  {
    init_simple_test("aSf_BFu31ll_D");
    static aSf_BFu31ll_D lv;
    check2(sizeof(lv), 13, "sizeof(aSf_BFu31ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_D");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_D");
    check_field_offset(lv, v3, 5, "aSf_BFu31ll_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_D(Test_aSf_BFu31ll_D, "aSf_BFu31ll_D", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_F()
{
  {
    init_simple_test("aSf_BFu31ll_F");
    static aSf_BFu31ll_F lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_F");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_F");
    check_field_offset(lv, v3, 5, "aSf_BFu31ll_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_F(Test_aSf_BFu31ll_F, "aSf_BFu31ll_F", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_I()
{
  {
    init_simple_test("aSf_BFu31ll_I");
    static aSf_BFu31ll_I lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_I");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_I");
    check_field_offset(lv, v3, 5, "aSf_BFu31ll_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_I(Test_aSf_BFu31ll_I, "aSf_BFu31ll_I", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_Ip()
{
  {
    init_simple_test("aSf_BFu31ll_Ip");
    static aSf_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aSf_BFu31ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_Ip");
    check_field_offset(lv, v3, 5, "aSf_BFu31ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_Ip(Test_aSf_BFu31ll_Ip, "aSf_BFu31ll_Ip", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_L()
{
  {
    init_simple_test("aSf_BFu31ll_L");
    static aSf_BFu31ll_L lv;
    check2(sizeof(lv), 13, "sizeof(aSf_BFu31ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_L");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_L");
    check_field_offset(lv, v3, 5, "aSf_BFu31ll_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_L(Test_aSf_BFu31ll_L, "aSf_BFu31ll_L", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_S()
{
  {
    init_simple_test("aSf_BFu31ll_S");
    static aSf_BFu31ll_S lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_S");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_S");
    check_field_offset(lv, v3, 5, "aSf_BFu31ll_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_S(Test_aSf_BFu31ll_S, "aSf_BFu31ll_S", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_Sf()
{
  {
    init_simple_test("aSf_BFu31ll_Sf");
    static aSf_BFu31ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_Sf");
    check_field_offset(lv, v3, 5, "aSf_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_Sf(Test_aSf_BFu31ll_Sf, "aSf_BFu31ll_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_Uc()
{
  {
    init_simple_test("aSf_BFu31ll_Uc");
    static aSf_BFu31ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu31ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_Uc");
    check_field_offset(lv, v3, 5, "aSf_BFu31ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_Uc(Test_aSf_BFu31ll_Uc, "aSf_BFu31ll_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_Ui()
{
  {
    init_simple_test("aSf_BFu31ll_Ui");
    static aSf_BFu31ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu31ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_Ui");
    check_field_offset(lv, v3, 5, "aSf_BFu31ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_Ui(Test_aSf_BFu31ll_Ui, "aSf_BFu31ll_Ui", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_Ul()
{
  {
    init_simple_test("aSf_BFu31ll_Ul");
    static aSf_BFu31ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aSf_BFu31ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_Ul");
    check_field_offset(lv, v3, 5, "aSf_BFu31ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_Ul(Test_aSf_BFu31ll_Ul, "aSf_BFu31ll_Ul", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_Us()
{
  {
    init_simple_test("aSf_BFu31ll_Us");
    static aSf_BFu31ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu31ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_Us");
    check_field_offset(lv, v3, 5, "aSf_BFu31ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_Us(Test_aSf_BFu31ll_Us, "aSf_BFu31ll_Us", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu31ll_Vp()
{
  {
    init_simple_test("aSf_BFu31ll_Vp");
    static aSf_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aSf_BFu31ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aSf_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_Vp");
    check_field_offset(lv, v3, 5, "aSf_BFu31ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu31ll_Vp(Test_aSf_BFu31ll_Vp, "aSf_BFu31ll_Vp", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i()
{
  {
    init_simple_test("aSf_BFu32i");
    static aSf_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i(Test_aSf_BFu32i, "aSf_BFu32i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu15i()
{
  {
    init_simple_test("aSf_BFu32i_BFu15i");
    static aSf_BFu32i_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aSf_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aSf_BFu32i_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu15i(Test_aSf_BFu32i_BFu15i, "aSf_BFu32i_BFu15i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu15ll()
{
  {
    init_simple_test("aSf_BFu32i_BFu15ll");
    static aSf_BFu32i_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aSf_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aSf_BFu32i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu15ll(Test_aSf_BFu32i_BFu15ll, "aSf_BFu32i_BFu15ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu15s()
{
  {
    init_simple_test("aSf_BFu32i_BFu15s");
    static aSf_BFu32i_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aSf_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aSf_BFu32i_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu15s(Test_aSf_BFu32i_BFu15s, "aSf_BFu32i_BFu15s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu16i()
{
  {
    init_simple_test("aSf_BFu32i_BFu16i");
    static aSf_BFu32i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aSf_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aSf_BFu32i_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu16i(Test_aSf_BFu32i_BFu16i, "aSf_BFu32i_BFu16i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu16ll()
{
  {
    init_simple_test("aSf_BFu32i_BFu16ll");
    static aSf_BFu32i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aSf_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aSf_BFu32i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu16ll(Test_aSf_BFu32i_BFu16ll, "aSf_BFu32i_BFu16ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu16s()
{
  {
    init_simple_test("aSf_BFu32i_BFu16s");
    static aSf_BFu32i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aSf_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aSf_BFu32i_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu16s(Test_aSf_BFu32i_BFu16s, "aSf_BFu32i_BFu16s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu17i()
{
  {
    init_simple_test("aSf_BFu32i_BFu17i");
    static aSf_BFu32i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu32i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aSf_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aSf_BFu32i_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu17i(Test_aSf_BFu32i_BFu17i, "aSf_BFu32i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu17ll()
{
  {
    init_simple_test("aSf_BFu32i_BFu17ll");
    static aSf_BFu32i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu32i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aSf_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aSf_BFu32i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu17ll(Test_aSf_BFu32i_BFu17ll, "aSf_BFu32i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu1c()
{
  {
    init_simple_test("aSf_BFu32i_BFu1c");
    static aSf_BFu32i_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aSf_BFu32i_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu1c(Test_aSf_BFu32i_BFu1c, "aSf_BFu32i_BFu1c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu1i()
{
  {
    init_simple_test("aSf_BFu32i_BFu1i");
    static aSf_BFu32i_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aSf_BFu32i_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu1i(Test_aSf_BFu32i_BFu1i, "aSf_BFu32i_BFu1i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu1ll()
{
  {
    init_simple_test("aSf_BFu32i_BFu1ll");
    static aSf_BFu32i_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aSf_BFu32i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu1ll(Test_aSf_BFu32i_BFu1ll, "aSf_BFu32i_BFu1ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu1s()
{
  {
    init_simple_test("aSf_BFu32i_BFu1s");
    static aSf_BFu32i_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aSf_BFu32i_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu1s(Test_aSf_BFu32i_BFu1s, "aSf_BFu32i_BFu1s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu31i()
{
  {
    init_simple_test("aSf_BFu32i_BFu31i");
    static aSf_BFu32i_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aSf_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aSf_BFu32i_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu31i(Test_aSf_BFu32i_BFu31i, "aSf_BFu32i_BFu31i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu31ll()
{
  {
    init_simple_test("aSf_BFu32i_BFu31ll");
    static aSf_BFu32i_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aSf_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aSf_BFu32i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu31ll(Test_aSf_BFu32i_BFu31ll, "aSf_BFu32i_BFu31ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu32i()
{
  {
    init_simple_test("aSf_BFu32i_BFu32i");
    static aSf_BFu32i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aSf_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu32i(Test_aSf_BFu32i_BFu32i, "aSf_BFu32i_BFu32i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu32ll()
{
  {
    init_simple_test("aSf_BFu32i_BFu32ll");
    static aSf_BFu32i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aSf_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu32ll(Test_aSf_BFu32i_BFu32ll, "aSf_BFu32i_BFu32ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu33()
{
  {
    init_simple_test("aSf_BFu32i_BFu33");
    static aSf_BFu32i_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu32i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aSf_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aSf_BFu32i_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu33(Test_aSf_BFu32i_BFu33, "aSf_BFu32i_BFu33", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu7c()
{
  {
    init_simple_test("aSf_BFu32i_BFu7c");
    static aSf_BFu32i_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aSf_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aSf_BFu32i_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu7c(Test_aSf_BFu32i_BFu7c, "aSf_BFu32i_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu7i()
{
  {
    init_simple_test("aSf_BFu32i_BFu7i");
    static aSf_BFu32i_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aSf_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aSf_BFu32i_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu7i(Test_aSf_BFu32i_BFu7i, "aSf_BFu32i_BFu7i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu7ll()
{
  {
    init_simple_test("aSf_BFu32i_BFu7ll");
    static aSf_BFu32i_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aSf_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aSf_BFu32i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu7ll(Test_aSf_BFu32i_BFu7ll, "aSf_BFu32i_BFu7ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu7s()
{
  {
    init_simple_test("aSf_BFu32i_BFu7s");
    static aSf_BFu32i_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aSf_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aSf_BFu32i_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu7s(Test_aSf_BFu32i_BFu7s, "aSf_BFu32i_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu8c()
{
  {
    init_simple_test("aSf_BFu32i_BFu8c");
    static aSf_BFu32i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aSf_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aSf_BFu32i_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu8c(Test_aSf_BFu32i_BFu8c, "aSf_BFu32i_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu8i()
{
  {
    init_simple_test("aSf_BFu32i_BFu8i");
    static aSf_BFu32i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aSf_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aSf_BFu32i_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu8i(Test_aSf_BFu32i_BFu8i, "aSf_BFu32i_BFu8i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu8ll()
{
  {
    init_simple_test("aSf_BFu32i_BFu8ll");
    static aSf_BFu32i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aSf_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aSf_BFu32i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu8ll(Test_aSf_BFu32i_BFu8ll, "aSf_BFu32i_BFu8ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu8s()
{
  {
    init_simple_test("aSf_BFu32i_BFu8s");
    static aSf_BFu32i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aSf_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aSf_BFu32i_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu8s(Test_aSf_BFu32i_BFu8s, "aSf_BFu32i_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu9i()
{
  {
    init_simple_test("aSf_BFu32i_BFu9i");
    static aSf_BFu32i_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aSf_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aSf_BFu32i_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu9i(Test_aSf_BFu32i_BFu9i, "aSf_BFu32i_BFu9i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu9ll()
{
  {
    init_simple_test("aSf_BFu32i_BFu9ll");
    static aSf_BFu32i_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aSf_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aSf_BFu32i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu9ll(Test_aSf_BFu32i_BFu9ll, "aSf_BFu32i_BFu9ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_BFu9s()
{
  {
    init_simple_test("aSf_BFu32i_BFu9s");
    static aSf_BFu32i_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aSf_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aSf_BFu32i_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_BFu9s(Test_aSf_BFu32i_BFu9s, "aSf_BFu32i_BFu9s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_C()
{
  {
    init_simple_test("aSf_BFu32i_C");
    static aSf_BFu32i_C lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_C");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_C");
    check_field_offset(lv, v3, 5, "aSf_BFu32i_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_C(Test_aSf_BFu32i_C, "aSf_BFu32i_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_D()
{
  {
    init_simple_test("aSf_BFu32i_D");
    static aSf_BFu32i_D lv;
    check2(sizeof(lv), 13, "sizeof(aSf_BFu32i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_D");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_D");
    check_field_offset(lv, v3, 5, "aSf_BFu32i_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_D(Test_aSf_BFu32i_D, "aSf_BFu32i_D", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_F()
{
  {
    init_simple_test("aSf_BFu32i_F");
    static aSf_BFu32i_F lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_F");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_F");
    check_field_offset(lv, v3, 5, "aSf_BFu32i_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_F(Test_aSf_BFu32i_F, "aSf_BFu32i_F", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_I()
{
  {
    init_simple_test("aSf_BFu32i_I");
    static aSf_BFu32i_I lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_I");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_I");
    check_field_offset(lv, v3, 5, "aSf_BFu32i_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_I(Test_aSf_BFu32i_I, "aSf_BFu32i_I", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_Ip()
{
  {
    init_simple_test("aSf_BFu32i_Ip");
    static aSf_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aSf_BFu32i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_Ip");
    check_field_offset(lv, v3, 5, "aSf_BFu32i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_Ip(Test_aSf_BFu32i_Ip, "aSf_BFu32i_Ip", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_L()
{
  {
    init_simple_test("aSf_BFu32i_L");
    static aSf_BFu32i_L lv;
    check2(sizeof(lv), 13, "sizeof(aSf_BFu32i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_L");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_L");
    check_field_offset(lv, v3, 5, "aSf_BFu32i_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_L(Test_aSf_BFu32i_L, "aSf_BFu32i_L", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_S()
{
  {
    init_simple_test("aSf_BFu32i_S");
    static aSf_BFu32i_S lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_S");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_S");
    check_field_offset(lv, v3, 5, "aSf_BFu32i_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_S(Test_aSf_BFu32i_S, "aSf_BFu32i_S", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_Sf()
{
  {
    init_simple_test("aSf_BFu32i_Sf");
    static aSf_BFu32i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_Sf");
    check_field_offset(lv, v3, 5, "aSf_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_Sf(Test_aSf_BFu32i_Sf, "aSf_BFu32i_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_Uc()
{
  {
    init_simple_test("aSf_BFu32i_Uc");
    static aSf_BFu32i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_Uc");
    check_field_offset(lv, v3, 5, "aSf_BFu32i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_Uc(Test_aSf_BFu32i_Uc, "aSf_BFu32i_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_Ui()
{
  {
    init_simple_test("aSf_BFu32i_Ui");
    static aSf_BFu32i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_Ui");
    check_field_offset(lv, v3, 5, "aSf_BFu32i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_Ui(Test_aSf_BFu32i_Ui, "aSf_BFu32i_Ui", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_Ul()
{
  {
    init_simple_test("aSf_BFu32i_Ul");
    static aSf_BFu32i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aSf_BFu32i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_Ul");
    check_field_offset(lv, v3, 5, "aSf_BFu32i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_Ul(Test_aSf_BFu32i_Ul, "aSf_BFu32i_Ul", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_Us()
{
  {
    init_simple_test("aSf_BFu32i_Us");
    static aSf_BFu32i_Us lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_Us");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_Us");
    check_field_offset(lv, v3, 5, "aSf_BFu32i_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_Us(Test_aSf_BFu32i_Us, "aSf_BFu32i_Us", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32i_Vp()
{
  {
    init_simple_test("aSf_BFu32i_Vp");
    static aSf_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aSf_BFu32i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_Vp");
    check_field_offset(lv, v3, 5, "aSf_BFu32i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32i_Vp(Test_aSf_BFu32i_Vp, "aSf_BFu32i_Vp", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll()
{
  {
    init_simple_test("aSf_BFu32ll");
    static aSf_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll(Test_aSf_BFu32ll, "aSf_BFu32ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu15i()
{
  {
    init_simple_test("aSf_BFu32ll_BFu15i");
    static aSf_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aSf_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aSf_BFu32ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu15i(Test_aSf_BFu32ll_BFu15i, "aSf_BFu32ll_BFu15i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu15ll()
{
  {
    init_simple_test("aSf_BFu32ll_BFu15ll");
    static aSf_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aSf_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aSf_BFu32ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu15ll(Test_aSf_BFu32ll_BFu15ll, "aSf_BFu32ll_BFu15ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu15s()
{
  {
    init_simple_test("aSf_BFu32ll_BFu15s");
    static aSf_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aSf_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aSf_BFu32ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu15s(Test_aSf_BFu32ll_BFu15s, "aSf_BFu32ll_BFu15s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu16i()
{
  {
    init_simple_test("aSf_BFu32ll_BFu16i");
    static aSf_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aSf_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aSf_BFu32ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu16i(Test_aSf_BFu32ll_BFu16i, "aSf_BFu32ll_BFu16i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu16ll()
{
  {
    init_simple_test("aSf_BFu32ll_BFu16ll");
    static aSf_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aSf_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aSf_BFu32ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu16ll(Test_aSf_BFu32ll_BFu16ll, "aSf_BFu32ll_BFu16ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu16s()
{
  {
    init_simple_test("aSf_BFu32ll_BFu16s");
    static aSf_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aSf_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aSf_BFu32ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu16s(Test_aSf_BFu32ll_BFu16s, "aSf_BFu32ll_BFu16s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu17i()
{
  {
    init_simple_test("aSf_BFu32ll_BFu17i");
    static aSf_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu32ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aSf_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aSf_BFu32ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu17i(Test_aSf_BFu32ll_BFu17i, "aSf_BFu32ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu17ll()
{
  {
    init_simple_test("aSf_BFu32ll_BFu17ll");
    static aSf_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aSf_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aSf_BFu32ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu17ll(Test_aSf_BFu32ll_BFu17ll, "aSf_BFu32ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu1c()
{
  {
    init_simple_test("aSf_BFu32ll_BFu1c");
    static aSf_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aSf_BFu32ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu1c(Test_aSf_BFu32ll_BFu1c, "aSf_BFu32ll_BFu1c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu1i()
{
  {
    init_simple_test("aSf_BFu32ll_BFu1i");
    static aSf_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aSf_BFu32ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu1i(Test_aSf_BFu32ll_BFu1i, "aSf_BFu32ll_BFu1i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu1ll()
{
  {
    init_simple_test("aSf_BFu32ll_BFu1ll");
    static aSf_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aSf_BFu32ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu1ll(Test_aSf_BFu32ll_BFu1ll, "aSf_BFu32ll_BFu1ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu1s()
{
  {
    init_simple_test("aSf_BFu32ll_BFu1s");
    static aSf_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aSf_BFu32ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu1s(Test_aSf_BFu32ll_BFu1s, "aSf_BFu32ll_BFu1s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu31i()
{
  {
    init_simple_test("aSf_BFu32ll_BFu31i");
    static aSf_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aSf_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aSf_BFu32ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu31i(Test_aSf_BFu32ll_BFu31i, "aSf_BFu32ll_BFu31i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu31ll()
{
  {
    init_simple_test("aSf_BFu32ll_BFu31ll");
    static aSf_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aSf_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aSf_BFu32ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu31ll(Test_aSf_BFu32ll_BFu31ll, "aSf_BFu32ll_BFu31ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu32i()
{
  {
    init_simple_test("aSf_BFu32ll_BFu32i");
    static aSf_BFu32ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aSf_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu32i(Test_aSf_BFu32ll_BFu32i, "aSf_BFu32ll_BFu32i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu32ll()
{
  {
    init_simple_test("aSf_BFu32ll_BFu32ll");
    static aSf_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aSf_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu32ll(Test_aSf_BFu32ll_BFu32ll, "aSf_BFu32ll_BFu32ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu33()
{
  {
    init_simple_test("aSf_BFu32ll_BFu33");
    static aSf_BFu32ll_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu32ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aSf_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aSf_BFu32ll_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu33(Test_aSf_BFu32ll_BFu33, "aSf_BFu32ll_BFu33", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu7c()
{
  {
    init_simple_test("aSf_BFu32ll_BFu7c");
    static aSf_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aSf_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aSf_BFu32ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu7c(Test_aSf_BFu32ll_BFu7c, "aSf_BFu32ll_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu7i()
{
  {
    init_simple_test("aSf_BFu32ll_BFu7i");
    static aSf_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aSf_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aSf_BFu32ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu7i(Test_aSf_BFu32ll_BFu7i, "aSf_BFu32ll_BFu7i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu7ll()
{
  {
    init_simple_test("aSf_BFu32ll_BFu7ll");
    static aSf_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aSf_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aSf_BFu32ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu7ll(Test_aSf_BFu32ll_BFu7ll, "aSf_BFu32ll_BFu7ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu7s()
{
  {
    init_simple_test("aSf_BFu32ll_BFu7s");
    static aSf_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aSf_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aSf_BFu32ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu7s(Test_aSf_BFu32ll_BFu7s, "aSf_BFu32ll_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu8c()
{
  {
    init_simple_test("aSf_BFu32ll_BFu8c");
    static aSf_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aSf_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aSf_BFu32ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu8c(Test_aSf_BFu32ll_BFu8c, "aSf_BFu32ll_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu8i()
{
  {
    init_simple_test("aSf_BFu32ll_BFu8i");
    static aSf_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aSf_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aSf_BFu32ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu8i(Test_aSf_BFu32ll_BFu8i, "aSf_BFu32ll_BFu8i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu8ll()
{
  {
    init_simple_test("aSf_BFu32ll_BFu8ll");
    static aSf_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aSf_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aSf_BFu32ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu8ll(Test_aSf_BFu32ll_BFu8ll, "aSf_BFu32ll_BFu8ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu8s()
{
  {
    init_simple_test("aSf_BFu32ll_BFu8s");
    static aSf_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aSf_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aSf_BFu32ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu8s(Test_aSf_BFu32ll_BFu8s, "aSf_BFu32ll_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu9i()
{
  {
    init_simple_test("aSf_BFu32ll_BFu9i");
    static aSf_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aSf_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aSf_BFu32ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu9i(Test_aSf_BFu32ll_BFu9i, "aSf_BFu32ll_BFu9i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu9ll()
{
  {
    init_simple_test("aSf_BFu32ll_BFu9ll");
    static aSf_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aSf_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aSf_BFu32ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu9ll(Test_aSf_BFu32ll_BFu9ll, "aSf_BFu32ll_BFu9ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_BFu9s()
{
  {
    init_simple_test("aSf_BFu32ll_BFu9s");
    static aSf_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aSf_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aSf_BFu32ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_BFu9s(Test_aSf_BFu32ll_BFu9s, "aSf_BFu32ll_BFu9s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_C()
{
  {
    init_simple_test("aSf_BFu32ll_C");
    static aSf_BFu32ll_C lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_C");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_C");
    check_field_offset(lv, v3, 5, "aSf_BFu32ll_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_C(Test_aSf_BFu32ll_C, "aSf_BFu32ll_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_D()
{
  {
    init_simple_test("aSf_BFu32ll_D");
    static aSf_BFu32ll_D lv;
    check2(sizeof(lv), 13, "sizeof(aSf_BFu32ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_D");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_D");
    check_field_offset(lv, v3, 5, "aSf_BFu32ll_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_D(Test_aSf_BFu32ll_D, "aSf_BFu32ll_D", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_F()
{
  {
    init_simple_test("aSf_BFu32ll_F");
    static aSf_BFu32ll_F lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_F");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_F");
    check_field_offset(lv, v3, 5, "aSf_BFu32ll_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_F(Test_aSf_BFu32ll_F, "aSf_BFu32ll_F", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_I()
{
  {
    init_simple_test("aSf_BFu32ll_I");
    static aSf_BFu32ll_I lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_I");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_I");
    check_field_offset(lv, v3, 5, "aSf_BFu32ll_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_I(Test_aSf_BFu32ll_I, "aSf_BFu32ll_I", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_Ip()
{
  {
    init_simple_test("aSf_BFu32ll_Ip");
    static aSf_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aSf_BFu32ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_Ip");
    check_field_offset(lv, v3, 5, "aSf_BFu32ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_Ip(Test_aSf_BFu32ll_Ip, "aSf_BFu32ll_Ip", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_L()
{
  {
    init_simple_test("aSf_BFu32ll_L");
    static aSf_BFu32ll_L lv;
    check2(sizeof(lv), 13, "sizeof(aSf_BFu32ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_L");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_L");
    check_field_offset(lv, v3, 5, "aSf_BFu32ll_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_L(Test_aSf_BFu32ll_L, "aSf_BFu32ll_L", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_S()
{
  {
    init_simple_test("aSf_BFu32ll_S");
    static aSf_BFu32ll_S lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_S");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_S");
    check_field_offset(lv, v3, 5, "aSf_BFu32ll_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_S(Test_aSf_BFu32ll_S, "aSf_BFu32ll_S", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_Sf()
{
  {
    init_simple_test("aSf_BFu32ll_Sf");
    static aSf_BFu32ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "aSf_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_Sf(Test_aSf_BFu32ll_Sf, "aSf_BFu32ll_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_Uc()
{
  {
    init_simple_test("aSf_BFu32ll_Uc");
    static aSf_BFu32ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu32ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_Uc");
    check_field_offset(lv, v3, 5, "aSf_BFu32ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_Uc(Test_aSf_BFu32ll_Uc, "aSf_BFu32ll_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_Ui()
{
  {
    init_simple_test("aSf_BFu32ll_Ui");
    static aSf_BFu32ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu32ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_Ui");
    check_field_offset(lv, v3, 5, "aSf_BFu32ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_Ui(Test_aSf_BFu32ll_Ui, "aSf_BFu32ll_Ui", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_Ul()
{
  {
    init_simple_test("aSf_BFu32ll_Ul");
    static aSf_BFu32ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aSf_BFu32ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_Ul");
    check_field_offset(lv, v3, 5, "aSf_BFu32ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_Ul(Test_aSf_BFu32ll_Ul, "aSf_BFu32ll_Ul", 13);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_Us()
{
  {
    init_simple_test("aSf_BFu32ll_Us");
    static aSf_BFu32ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu32ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_Us");
    check_field_offset(lv, v3, 5, "aSf_BFu32ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_Us(Test_aSf_BFu32ll_Us, "aSf_BFu32ll_Us", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu32ll_Vp()
{
  {
    init_simple_test("aSf_BFu32ll_Vp");
    static aSf_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aSf_BFu32ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aSf_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_Vp");
    check_field_offset(lv, v3, 5, "aSf_BFu32ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu32ll_Vp(Test_aSf_BFu32ll_Vp, "aSf_BFu32ll_Vp", ABISELECT(13,9));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33()
{
  {
    init_simple_test("aSf_BFu33");
    static aSf_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu33(Test_aSf_BFu33, "aSf_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu15i()
{
  {
    init_simple_test("aSf_BFu33_BFu15i");
    static aSf_BFu33_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu33_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aSf_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aSf_BFu33_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu15i(Test_aSf_BFu33_BFu15i, "aSf_BFu33_BFu15i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu15ll()
{
  {
    init_simple_test("aSf_BFu33_BFu15ll");
    static aSf_BFu33_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu33_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aSf_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aSf_BFu33_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu15ll(Test_aSf_BFu33_BFu15ll, "aSf_BFu33_BFu15ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu15s()
{
  {
    init_simple_test("aSf_BFu33_BFu15s");
    static aSf_BFu33_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu33_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aSf_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aSf_BFu33_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu15s(Test_aSf_BFu33_BFu15s, "aSf_BFu33_BFu15s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu16i()
{
  {
    init_simple_test("aSf_BFu33_BFu16i");
    static aSf_BFu33_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu33_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aSf_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aSf_BFu33_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu16i(Test_aSf_BFu33_BFu16i, "aSf_BFu33_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu16ll()
{
  {
    init_simple_test("aSf_BFu33_BFu16ll");
    static aSf_BFu33_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu33_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aSf_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aSf_BFu33_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu16ll(Test_aSf_BFu33_BFu16ll, "aSf_BFu33_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu16s()
{
  {
    init_simple_test("aSf_BFu33_BFu16s");
    static aSf_BFu33_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu33_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aSf_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aSf_BFu33_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu16s(Test_aSf_BFu33_BFu16s, "aSf_BFu33_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu17i()
{
  {
    init_simple_test("aSf_BFu33_BFu17i");
    static aSf_BFu33_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu33_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "aSf_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "aSf_BFu33_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu17i(Test_aSf_BFu33_BFu17i, "aSf_BFu33_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu17ll()
{
  {
    init_simple_test("aSf_BFu33_BFu17ll");
    static aSf_BFu33_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu33_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "aSf_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "aSf_BFu33_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu17ll(Test_aSf_BFu33_BFu17ll, "aSf_BFu33_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu1c()
{
  {
    init_simple_test("aSf_BFu33_BFu1c");
    static aSf_BFu33_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu33_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aSf_BFu33_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu1c(Test_aSf_BFu33_BFu1c, "aSf_BFu33_BFu1c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu1i()
{
  {
    init_simple_test("aSf_BFu33_BFu1i");
    static aSf_BFu33_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu33_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aSf_BFu33_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu1i(Test_aSf_BFu33_BFu1i, "aSf_BFu33_BFu1i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu1ll()
{
  {
    init_simple_test("aSf_BFu33_BFu1ll");
    static aSf_BFu33_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu33_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aSf_BFu33_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu1ll(Test_aSf_BFu33_BFu1ll, "aSf_BFu33_BFu1ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu1s()
{
  {
    init_simple_test("aSf_BFu33_BFu1s");
    static aSf_BFu33_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu33_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aSf_BFu33_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu1s(Test_aSf_BFu33_BFu1s, "aSf_BFu33_BFu1s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu31i()
{
  {
    init_simple_test("aSf_BFu33_BFu31i");
    static aSf_BFu33_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu33_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "aSf_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "aSf_BFu33_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu31i(Test_aSf_BFu33_BFu31i, "aSf_BFu33_BFu31i", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu31ll()
{
  {
    init_simple_test("aSf_BFu33_BFu31ll");
    static aSf_BFu33_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aSf_BFu33_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "aSf_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "aSf_BFu33_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu31ll(Test_aSf_BFu33_BFu31ll, "aSf_BFu33_BFu31ll", 9);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu32i()
{
  {
    init_simple_test("aSf_BFu33_BFu32i");
    static aSf_BFu33_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu33_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "aSf_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "aSf_BFu33_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu32i(Test_aSf_BFu33_BFu32i, "aSf_BFu33_BFu32i", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu32ll()
{
  {
    init_simple_test("aSf_BFu33_BFu32ll");
    static aSf_BFu33_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu33_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "aSf_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "aSf_BFu33_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu32ll(Test_aSf_BFu33_BFu32ll, "aSf_BFu33_BFu32ll", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu33()
{
  {
    init_simple_test("aSf_BFu33_BFu33");
    static aSf_BFu33_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu33_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, 1, "aSf_BFu33_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu33(Test_aSf_BFu33_BFu33, "aSf_BFu33_BFu33", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu7c()
{
  {
    init_simple_test("aSf_BFu33_BFu7c");
    static aSf_BFu33_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu33_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aSf_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aSf_BFu33_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu7c(Test_aSf_BFu33_BFu7c, "aSf_BFu33_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu7i()
{
  {
    init_simple_test("aSf_BFu33_BFu7i");
    static aSf_BFu33_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu33_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aSf_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aSf_BFu33_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu7i(Test_aSf_BFu33_BFu7i, "aSf_BFu33_BFu7i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu7ll()
{
  {
    init_simple_test("aSf_BFu33_BFu7ll");
    static aSf_BFu33_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu33_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aSf_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aSf_BFu33_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu7ll(Test_aSf_BFu33_BFu7ll, "aSf_BFu33_BFu7ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu7s()
{
  {
    init_simple_test("aSf_BFu33_BFu7s");
    static aSf_BFu33_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu33_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aSf_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aSf_BFu33_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu7s(Test_aSf_BFu33_BFu7s, "aSf_BFu33_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu8c()
{
  {
    init_simple_test("aSf_BFu33_BFu8c");
    static aSf_BFu33_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu33_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aSf_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aSf_BFu33_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu8c(Test_aSf_BFu33_BFu8c, "aSf_BFu33_BFu8c", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu8i()
{
  {
    init_simple_test("aSf_BFu33_BFu8i");
    static aSf_BFu33_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu33_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aSf_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aSf_BFu33_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu8i(Test_aSf_BFu33_BFu8i, "aSf_BFu33_BFu8i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu8ll()
{
  {
    init_simple_test("aSf_BFu33_BFu8ll");
    static aSf_BFu33_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu33_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aSf_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aSf_BFu33_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu8ll(Test_aSf_BFu33_BFu8ll, "aSf_BFu33_BFu8ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu8s()
{
  {
    init_simple_test("aSf_BFu33_BFu8s");
    static aSf_BFu33_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu33_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aSf_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aSf_BFu33_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu8s(Test_aSf_BFu33_BFu8s, "aSf_BFu33_BFu8s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu9i()
{
  {
    init_simple_test("aSf_BFu33_BFu9i");
    static aSf_BFu33_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu33_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aSf_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aSf_BFu33_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu9i(Test_aSf_BFu33_BFu9i, "aSf_BFu33_BFu9i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu9ll()
{
  {
    init_simple_test("aSf_BFu33_BFu9ll");
    static aSf_BFu33_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu33_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aSf_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aSf_BFu33_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu9ll(Test_aSf_BFu33_BFu9ll, "aSf_BFu33_BFu9ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_BFu9s()
{
  {
    init_simple_test("aSf_BFu33_BFu9s");
    static aSf_BFu33_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu33_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aSf_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aSf_BFu33_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_BFu9s(Test_aSf_BFu33_BFu9s, "aSf_BFu33_BFu9s", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_C()
{
  {
    init_simple_test("aSf_BFu33_C");
    static aSf_BFu33_C lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu33_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_C");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_C");
    check_field_offset(lv, v3, 6, "aSf_BFu33_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_C(Test_aSf_BFu33_C, "aSf_BFu33_C", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_D()
{
  {
    init_simple_test("aSf_BFu33_D");
    static aSf_BFu33_D lv;
    check2(sizeof(lv), 14, "sizeof(aSf_BFu33_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_D");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_D");
    check_field_offset(lv, v3, 6, "aSf_BFu33_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_D(Test_aSf_BFu33_D, "aSf_BFu33_D", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_F()
{
  {
    init_simple_test("aSf_BFu33_F");
    static aSf_BFu33_F lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu33_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_F");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_F");
    check_field_offset(lv, v3, 6, "aSf_BFu33_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_F(Test_aSf_BFu33_F, "aSf_BFu33_F", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_I()
{
  {
    init_simple_test("aSf_BFu33_I");
    static aSf_BFu33_I lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu33_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_I");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_I");
    check_field_offset(lv, v3, 6, "aSf_BFu33_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_I(Test_aSf_BFu33_I, "aSf_BFu33_I", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_Ip()
{
  {
    init_simple_test("aSf_BFu33_Ip");
    static aSf_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aSf_BFu33_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_Ip");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_Ip");
    check_field_offset(lv, v3, 6, "aSf_BFu33_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_Ip(Test_aSf_BFu33_Ip, "aSf_BFu33_Ip", ABISELECT(14,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_L()
{
  {
    init_simple_test("aSf_BFu33_L");
    static aSf_BFu33_L lv;
    check2(sizeof(lv), 14, "sizeof(aSf_BFu33_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_L");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_L");
    check_field_offset(lv, v3, 6, "aSf_BFu33_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_L(Test_aSf_BFu33_L, "aSf_BFu33_L", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_S()
{
  {
    init_simple_test("aSf_BFu33_S");
    static aSf_BFu33_S lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu33_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_S");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_S");
    check_field_offset(lv, v3, 6, "aSf_BFu33_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_S(Test_aSf_BFu33_S, "aSf_BFu33_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_Sf()
{
  {
    init_simple_test("aSf_BFu33_Sf");
    static aSf_BFu33_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_Sf");
    check_field_offset(lv, v3, 6, "aSf_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_Sf(Test_aSf_BFu33_Sf, "aSf_BFu33_Sf", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_Uc()
{
  {
    init_simple_test("aSf_BFu33_Uc");
    static aSf_BFu33_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu33_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_Uc");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_Uc");
    check_field_offset(lv, v3, 6, "aSf_BFu33_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_Uc(Test_aSf_BFu33_Uc, "aSf_BFu33_Uc", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_Ui()
{
  {
    init_simple_test("aSf_BFu33_Ui");
    static aSf_BFu33_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu33_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_Ui");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_Ui");
    check_field_offset(lv, v3, 6, "aSf_BFu33_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_Ui(Test_aSf_BFu33_Ui, "aSf_BFu33_Ui", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_Ul()
{
  {
    init_simple_test("aSf_BFu33_Ul");
    static aSf_BFu33_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aSf_BFu33_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_Ul");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_Ul");
    check_field_offset(lv, v3, 6, "aSf_BFu33_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_Ul(Test_aSf_BFu33_Ul, "aSf_BFu33_Ul", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_Us()
{
  {
    init_simple_test("aSf_BFu33_Us");
    static aSf_BFu33_Us lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu33_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_Us");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_Us");
    check_field_offset(lv, v3, 6, "aSf_BFu33_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_Us(Test_aSf_BFu33_Us, "aSf_BFu33_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu33_Vp()
{
  {
    init_simple_test("aSf_BFu33_Vp");
    static aSf_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aSf_BFu33_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aSf_BFu33_Vp");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_Vp");
    check_field_offset(lv, v3, 6, "aSf_BFu33_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu33_Vp(Test_aSf_BFu33_Vp, "aSf_BFu33_Vp", ABISELECT(14,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c()
{
  {
    init_simple_test("aSf_BFu7c");
    static aSf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c(Test_aSf_BFu7c, "aSf_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu15i()
{
  {
    init_simple_test("aSf_BFu7c_BFu15i");
    static aSf_BFu7c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aSf_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aSf_BFu7c_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu15i(Test_aSf_BFu7c_BFu15i, "aSf_BFu7c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu15ll()
{
  {
    init_simple_test("aSf_BFu7c_BFu15ll");
    static aSf_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aSf_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aSf_BFu7c_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu15ll(Test_aSf_BFu7c_BFu15ll, "aSf_BFu7c_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu15s()
{
  {
    init_simple_test("aSf_BFu7c_BFu15s");
    static aSf_BFu7c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aSf_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aSf_BFu7c_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu15s(Test_aSf_BFu7c_BFu15s, "aSf_BFu7c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu16i()
{
  {
    init_simple_test("aSf_BFu7c_BFu16i");
    static aSf_BFu7c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aSf_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aSf_BFu7c_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu16i(Test_aSf_BFu7c_BFu16i, "aSf_BFu7c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu16ll()
{
  {
    init_simple_test("aSf_BFu7c_BFu16ll");
    static aSf_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aSf_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aSf_BFu7c_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu16ll(Test_aSf_BFu7c_BFu16ll, "aSf_BFu7c_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu16s()
{
  {
    init_simple_test("aSf_BFu7c_BFu16s");
    static aSf_BFu7c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aSf_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aSf_BFu7c_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu16s(Test_aSf_BFu7c_BFu16s, "aSf_BFu7c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu17i()
{
  {
    init_simple_test("aSf_BFu7c_BFu17i");
    static aSf_BFu7c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aSf_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aSf_BFu7c_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu17i(Test_aSf_BFu7c_BFu17i, "aSf_BFu7c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu17ll()
{
  {
    init_simple_test("aSf_BFu7c_BFu17ll");
    static aSf_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aSf_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aSf_BFu7c_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu17ll(Test_aSf_BFu7c_BFu17ll, "aSf_BFu7c_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu1c()
{
  {
    init_simple_test("aSf_BFu7c_BFu1c");
    static aSf_BFu7c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7c_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu1c(Test_aSf_BFu7c_BFu1c, "aSf_BFu7c_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu1i()
{
  {
    init_simple_test("aSf_BFu7c_BFu1i");
    static aSf_BFu7c_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7c_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu1i(Test_aSf_BFu7c_BFu1i, "aSf_BFu7c_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu1ll()
{
  {
    init_simple_test("aSf_BFu7c_BFu1ll");
    static aSf_BFu7c_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7c_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu1ll(Test_aSf_BFu7c_BFu1ll, "aSf_BFu7c_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu1s()
{
  {
    init_simple_test("aSf_BFu7c_BFu1s");
    static aSf_BFu7c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7c_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu1s(Test_aSf_BFu7c_BFu1s, "aSf_BFu7c_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu31i()
{
  {
    init_simple_test("aSf_BFu7c_BFu31i");
    static aSf_BFu7c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aSf_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aSf_BFu7c_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu31i(Test_aSf_BFu7c_BFu31i, "aSf_BFu7c_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu31ll()
{
  {
    init_simple_test("aSf_BFu7c_BFu31ll");
    static aSf_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aSf_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aSf_BFu7c_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu31ll(Test_aSf_BFu7c_BFu31ll, "aSf_BFu7c_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu32i()
{
  {
    init_simple_test("aSf_BFu7c_BFu32i");
    static aSf_BFu7c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aSf_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aSf_BFu7c_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu32i(Test_aSf_BFu7c_BFu32i, "aSf_BFu7c_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu32ll()
{
  {
    init_simple_test("aSf_BFu7c_BFu32ll");
    static aSf_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aSf_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aSf_BFu7c_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu32ll(Test_aSf_BFu7c_BFu32ll, "aSf_BFu7c_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu33()
{
  {
    init_simple_test("aSf_BFu7c_BFu33");
    static aSf_BFu7c_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "aSf_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "aSf_BFu7c_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu33(Test_aSf_BFu7c_BFu33, "aSf_BFu7c_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu7c()
{
  {
    init_simple_test("aSf_BFu7c_BFu7c");
    static aSf_BFu7c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu7c(Test_aSf_BFu7c_BFu7c, "aSf_BFu7c_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu7i()
{
  {
    init_simple_test("aSf_BFu7c_BFu7i");
    static aSf_BFu7c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu7i(Test_aSf_BFu7c_BFu7i, "aSf_BFu7c_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu7ll()
{
  {
    init_simple_test("aSf_BFu7c_BFu7ll");
    static aSf_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu7ll(Test_aSf_BFu7c_BFu7ll, "aSf_BFu7c_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu7s()
{
  {
    init_simple_test("aSf_BFu7c_BFu7s");
    static aSf_BFu7c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu7s(Test_aSf_BFu7c_BFu7s, "aSf_BFu7c_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu8c()
{
  {
    init_simple_test("aSf_BFu7c_BFu8c");
    static aSf_BFu7c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7c_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu8c(Test_aSf_BFu7c_BFu8c, "aSf_BFu7c_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu8i()
{
  {
    init_simple_test("aSf_BFu7c_BFu8i");
    static aSf_BFu7c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7c_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu8i(Test_aSf_BFu7c_BFu8i, "aSf_BFu7c_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu8ll()
{
  {
    init_simple_test("aSf_BFu7c_BFu8ll");
    static aSf_BFu7c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7c_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu8ll(Test_aSf_BFu7c_BFu8ll, "aSf_BFu7c_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu8s()
{
  {
    init_simple_test("aSf_BFu7c_BFu8s");
    static aSf_BFu7c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7c_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu8s(Test_aSf_BFu7c_BFu8s, "aSf_BFu7c_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu9i()
{
  {
    init_simple_test("aSf_BFu7c_BFu9i");
    static aSf_BFu7c_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aSf_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aSf_BFu7c_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu9i(Test_aSf_BFu7c_BFu9i, "aSf_BFu7c_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu9ll()
{
  {
    init_simple_test("aSf_BFu7c_BFu9ll");
    static aSf_BFu7c_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aSf_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aSf_BFu7c_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu9ll(Test_aSf_BFu7c_BFu9ll, "aSf_BFu7c_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_BFu9s()
{
  {
    init_simple_test("aSf_BFu7c_BFu9s");
    static aSf_BFu7c_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aSf_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aSf_BFu7c_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_BFu9s(Test_aSf_BFu7c_BFu9s, "aSf_BFu7c_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_C()
{
  {
    init_simple_test("aSf_BFu7c_C");
    static aSf_BFu7c_C lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_C");
    check_field_offset(lv, v3, 2, "aSf_BFu7c_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_C(Test_aSf_BFu7c_C, "aSf_BFu7c_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_D()
{
  {
    init_simple_test("aSf_BFu7c_D");
    static aSf_BFu7c_D lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu7c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_D");
    check_field_offset(lv, v3, 2, "aSf_BFu7c_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_D(Test_aSf_BFu7c_D, "aSf_BFu7c_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_F()
{
  {
    init_simple_test("aSf_BFu7c_F");
    static aSf_BFu7c_F lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_F");
    check_field_offset(lv, v3, 2, "aSf_BFu7c_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_F(Test_aSf_BFu7c_F, "aSf_BFu7c_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_I()
{
  {
    init_simple_test("aSf_BFu7c_I");
    static aSf_BFu7c_I lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_I");
    check_field_offset(lv, v3, 2, "aSf_BFu7c_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_I(Test_aSf_BFu7c_I, "aSf_BFu7c_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_Ip()
{
  {
    init_simple_test("aSf_BFu7c_Ip");
    static aSf_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu7c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_Ip");
    check_field_offset(lv, v3, 2, "aSf_BFu7c_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_Ip(Test_aSf_BFu7c_Ip, "aSf_BFu7c_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_L()
{
  {
    init_simple_test("aSf_BFu7c_L");
    static aSf_BFu7c_L lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_L");
    check_field_offset(lv, v3, 2, "aSf_BFu7c_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_L(Test_aSf_BFu7c_L, "aSf_BFu7c_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_S()
{
  {
    init_simple_test("aSf_BFu7c_S");
    static aSf_BFu7c_S lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_S");
    check_field_offset(lv, v3, 2, "aSf_BFu7c_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_S(Test_aSf_BFu7c_S, "aSf_BFu7c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_Sf()
{
  {
    init_simple_test("aSf_BFu7c_Sf");
    static aSf_BFu7c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_Sf");
    check_field_offset(lv, v3, 2, "aSf_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_Sf(Test_aSf_BFu7c_Sf, "aSf_BFu7c_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_Uc()
{
  {
    init_simple_test("aSf_BFu7c_Uc");
    static aSf_BFu7c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_Uc");
    check_field_offset(lv, v3, 2, "aSf_BFu7c_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_Uc(Test_aSf_BFu7c_Uc, "aSf_BFu7c_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_Ui()
{
  {
    init_simple_test("aSf_BFu7c_Ui");
    static aSf_BFu7c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_Ui");
    check_field_offset(lv, v3, 2, "aSf_BFu7c_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_Ui(Test_aSf_BFu7c_Ui, "aSf_BFu7c_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_Ul()
{
  {
    init_simple_test("aSf_BFu7c_Ul");
    static aSf_BFu7c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_Ul");
    check_field_offset(lv, v3, 2, "aSf_BFu7c_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_Ul(Test_aSf_BFu7c_Ul, "aSf_BFu7c_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_Us()
{
  {
    init_simple_test("aSf_BFu7c_Us");
    static aSf_BFu7c_Us lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_Us");
    check_field_offset(lv, v3, 2, "aSf_BFu7c_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_Us(Test_aSf_BFu7c_Us, "aSf_BFu7c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7c_Vp()
{
  {
    init_simple_test("aSf_BFu7c_Vp");
    static aSf_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_Vp");
    check_field_offset(lv, v3, 2, "aSf_BFu7c_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7c_Vp(Test_aSf_BFu7c_Vp, "aSf_BFu7c_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i()
{
  {
    init_simple_test("aSf_BFu7i");
    static aSf_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i(Test_aSf_BFu7i, "aSf_BFu7i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu15i()
{
  {
    init_simple_test("aSf_BFu7i_BFu15i");
    static aSf_BFu7i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aSf_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aSf_BFu7i_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu15i(Test_aSf_BFu7i_BFu15i, "aSf_BFu7i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu15ll()
{
  {
    init_simple_test("aSf_BFu7i_BFu15ll");
    static aSf_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aSf_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aSf_BFu7i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu15ll(Test_aSf_BFu7i_BFu15ll, "aSf_BFu7i_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu15s()
{
  {
    init_simple_test("aSf_BFu7i_BFu15s");
    static aSf_BFu7i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aSf_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aSf_BFu7i_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu15s(Test_aSf_BFu7i_BFu15s, "aSf_BFu7i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu16i()
{
  {
    init_simple_test("aSf_BFu7i_BFu16i");
    static aSf_BFu7i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aSf_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aSf_BFu7i_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu16i(Test_aSf_BFu7i_BFu16i, "aSf_BFu7i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu16ll()
{
  {
    init_simple_test("aSf_BFu7i_BFu16ll");
    static aSf_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aSf_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aSf_BFu7i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu16ll(Test_aSf_BFu7i_BFu16ll, "aSf_BFu7i_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu16s()
{
  {
    init_simple_test("aSf_BFu7i_BFu16s");
    static aSf_BFu7i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aSf_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aSf_BFu7i_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu16s(Test_aSf_BFu7i_BFu16s, "aSf_BFu7i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu17i()
{
  {
    init_simple_test("aSf_BFu7i_BFu17i");
    static aSf_BFu7i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aSf_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aSf_BFu7i_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu17i(Test_aSf_BFu7i_BFu17i, "aSf_BFu7i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu17ll()
{
  {
    init_simple_test("aSf_BFu7i_BFu17ll");
    static aSf_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aSf_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aSf_BFu7i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu17ll(Test_aSf_BFu7i_BFu17ll, "aSf_BFu7i_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu1c()
{
  {
    init_simple_test("aSf_BFu7i_BFu1c");
    static aSf_BFu7i_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7i_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu1c(Test_aSf_BFu7i_BFu1c, "aSf_BFu7i_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu1i()
{
  {
    init_simple_test("aSf_BFu7i_BFu1i");
    static aSf_BFu7i_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7i_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu1i(Test_aSf_BFu7i_BFu1i, "aSf_BFu7i_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu1ll()
{
  {
    init_simple_test("aSf_BFu7i_BFu1ll");
    static aSf_BFu7i_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu1ll(Test_aSf_BFu7i_BFu1ll, "aSf_BFu7i_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu1s()
{
  {
    init_simple_test("aSf_BFu7i_BFu1s");
    static aSf_BFu7i_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7i_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu1s(Test_aSf_BFu7i_BFu1s, "aSf_BFu7i_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu31i()
{
  {
    init_simple_test("aSf_BFu7i_BFu31i");
    static aSf_BFu7i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aSf_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aSf_BFu7i_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu31i(Test_aSf_BFu7i_BFu31i, "aSf_BFu7i_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu31ll()
{
  {
    init_simple_test("aSf_BFu7i_BFu31ll");
    static aSf_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aSf_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aSf_BFu7i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu31ll(Test_aSf_BFu7i_BFu31ll, "aSf_BFu7i_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu32i()
{
  {
    init_simple_test("aSf_BFu7i_BFu32i");
    static aSf_BFu7i_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aSf_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aSf_BFu7i_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu32i(Test_aSf_BFu7i_BFu32i, "aSf_BFu7i_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu32ll()
{
  {
    init_simple_test("aSf_BFu7i_BFu32ll");
    static aSf_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aSf_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aSf_BFu7i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu32ll(Test_aSf_BFu7i_BFu32ll, "aSf_BFu7i_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu33()
{
  {
    init_simple_test("aSf_BFu7i_BFu33");
    static aSf_BFu7i_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "aSf_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "aSf_BFu7i_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu33(Test_aSf_BFu7i_BFu33, "aSf_BFu7i_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu7c()
{
  {
    init_simple_test("aSf_BFu7i_BFu7c");
    static aSf_BFu7i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu7c(Test_aSf_BFu7i_BFu7c, "aSf_BFu7i_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu7i()
{
  {
    init_simple_test("aSf_BFu7i_BFu7i");
    static aSf_BFu7i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu7i(Test_aSf_BFu7i_BFu7i, "aSf_BFu7i_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu7ll()
{
  {
    init_simple_test("aSf_BFu7i_BFu7ll");
    static aSf_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu7ll(Test_aSf_BFu7i_BFu7ll, "aSf_BFu7i_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu7s()
{
  {
    init_simple_test("aSf_BFu7i_BFu7s");
    static aSf_BFu7i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu7s(Test_aSf_BFu7i_BFu7s, "aSf_BFu7i_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu8c()
{
  {
    init_simple_test("aSf_BFu7i_BFu8c");
    static aSf_BFu7i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7i_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu8c(Test_aSf_BFu7i_BFu8c, "aSf_BFu7i_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu8i()
{
  {
    init_simple_test("aSf_BFu7i_BFu8i");
    static aSf_BFu7i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7i_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu8i(Test_aSf_BFu7i_BFu8i, "aSf_BFu7i_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu8ll()
{
  {
    init_simple_test("aSf_BFu7i_BFu8ll");
    static aSf_BFu7i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu8ll(Test_aSf_BFu7i_BFu8ll, "aSf_BFu7i_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu8s()
{
  {
    init_simple_test("aSf_BFu7i_BFu8s");
    static aSf_BFu7i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7i_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu8s(Test_aSf_BFu7i_BFu8s, "aSf_BFu7i_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu9i()
{
  {
    init_simple_test("aSf_BFu7i_BFu9i");
    static aSf_BFu7i_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aSf_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aSf_BFu7i_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu9i(Test_aSf_BFu7i_BFu9i, "aSf_BFu7i_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu9ll()
{
  {
    init_simple_test("aSf_BFu7i_BFu9ll");
    static aSf_BFu7i_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aSf_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aSf_BFu7i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu9ll(Test_aSf_BFu7i_BFu9ll, "aSf_BFu7i_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_BFu9s()
{
  {
    init_simple_test("aSf_BFu7i_BFu9s");
    static aSf_BFu7i_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aSf_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aSf_BFu7i_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_BFu9s(Test_aSf_BFu7i_BFu9s, "aSf_BFu7i_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_C()
{
  {
    init_simple_test("aSf_BFu7i_C");
    static aSf_BFu7i_C lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_C");
    check_field_offset(lv, v3, 2, "aSf_BFu7i_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_C(Test_aSf_BFu7i_C, "aSf_BFu7i_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_D()
{
  {
    init_simple_test("aSf_BFu7i_D");
    static aSf_BFu7i_D lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_D");
    check_field_offset(lv, v3, 2, "aSf_BFu7i_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_D(Test_aSf_BFu7i_D, "aSf_BFu7i_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_F()
{
  {
    init_simple_test("aSf_BFu7i_F");
    static aSf_BFu7i_F lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_F");
    check_field_offset(lv, v3, 2, "aSf_BFu7i_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_F(Test_aSf_BFu7i_F, "aSf_BFu7i_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_I()
{
  {
    init_simple_test("aSf_BFu7i_I");
    static aSf_BFu7i_I lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_I");
    check_field_offset(lv, v3, 2, "aSf_BFu7i_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_I(Test_aSf_BFu7i_I, "aSf_BFu7i_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_Ip()
{
  {
    init_simple_test("aSf_BFu7i_Ip");
    static aSf_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_Ip");
    check_field_offset(lv, v3, 2, "aSf_BFu7i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_Ip(Test_aSf_BFu7i_Ip, "aSf_BFu7i_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_L()
{
  {
    init_simple_test("aSf_BFu7i_L");
    static aSf_BFu7i_L lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_L");
    check_field_offset(lv, v3, 2, "aSf_BFu7i_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_L(Test_aSf_BFu7i_L, "aSf_BFu7i_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_S()
{
  {
    init_simple_test("aSf_BFu7i_S");
    static aSf_BFu7i_S lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_S");
    check_field_offset(lv, v3, 2, "aSf_BFu7i_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_S(Test_aSf_BFu7i_S, "aSf_BFu7i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_Sf()
{
  {
    init_simple_test("aSf_BFu7i_Sf");
    static aSf_BFu7i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_Sf");
    check_field_offset(lv, v3, 2, "aSf_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_Sf(Test_aSf_BFu7i_Sf, "aSf_BFu7i_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_Uc()
{
  {
    init_simple_test("aSf_BFu7i_Uc");
    static aSf_BFu7i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_Uc");
    check_field_offset(lv, v3, 2, "aSf_BFu7i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_Uc(Test_aSf_BFu7i_Uc, "aSf_BFu7i_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_Ui()
{
  {
    init_simple_test("aSf_BFu7i_Ui");
    static aSf_BFu7i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_Ui");
    check_field_offset(lv, v3, 2, "aSf_BFu7i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_Ui(Test_aSf_BFu7i_Ui, "aSf_BFu7i_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_Ul()
{
  {
    init_simple_test("aSf_BFu7i_Ul");
    static aSf_BFu7i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_Ul");
    check_field_offset(lv, v3, 2, "aSf_BFu7i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_Ul(Test_aSf_BFu7i_Ul, "aSf_BFu7i_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_Us()
{
  {
    init_simple_test("aSf_BFu7i_Us");
    static aSf_BFu7i_Us lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_Us");
    check_field_offset(lv, v3, 2, "aSf_BFu7i_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_Us(Test_aSf_BFu7i_Us, "aSf_BFu7i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7i_Vp()
{
  {
    init_simple_test("aSf_BFu7i_Vp");
    static aSf_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_Vp");
    check_field_offset(lv, v3, 2, "aSf_BFu7i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7i_Vp(Test_aSf_BFu7i_Vp, "aSf_BFu7i_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll()
{
  {
    init_simple_test("aSf_BFu7ll");
    static aSf_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll(Test_aSf_BFu7ll, "aSf_BFu7ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu15i()
{
  {
    init_simple_test("aSf_BFu7ll_BFu15i");
    static aSf_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aSf_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aSf_BFu7ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu15i(Test_aSf_BFu7ll_BFu15i, "aSf_BFu7ll_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu15ll()
{
  {
    init_simple_test("aSf_BFu7ll_BFu15ll");
    static aSf_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aSf_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aSf_BFu7ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu15ll(Test_aSf_BFu7ll_BFu15ll, "aSf_BFu7ll_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu15s()
{
  {
    init_simple_test("aSf_BFu7ll_BFu15s");
    static aSf_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aSf_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aSf_BFu7ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu15s(Test_aSf_BFu7ll_BFu15s, "aSf_BFu7ll_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu16i()
{
  {
    init_simple_test("aSf_BFu7ll_BFu16i");
    static aSf_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aSf_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aSf_BFu7ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu16i(Test_aSf_BFu7ll_BFu16i, "aSf_BFu7ll_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu16ll()
{
  {
    init_simple_test("aSf_BFu7ll_BFu16ll");
    static aSf_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aSf_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aSf_BFu7ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu16ll(Test_aSf_BFu7ll_BFu16ll, "aSf_BFu7ll_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu16s()
{
  {
    init_simple_test("aSf_BFu7ll_BFu16s");
    static aSf_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aSf_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aSf_BFu7ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu16s(Test_aSf_BFu7ll_BFu16s, "aSf_BFu7ll_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu17i()
{
  {
    init_simple_test("aSf_BFu7ll_BFu17i");
    static aSf_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aSf_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aSf_BFu7ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu17i(Test_aSf_BFu7ll_BFu17i, "aSf_BFu7ll_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu17ll()
{
  {
    init_simple_test("aSf_BFu7ll_BFu17ll");
    static aSf_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aSf_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aSf_BFu7ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu17ll(Test_aSf_BFu7ll_BFu17ll, "aSf_BFu7ll_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu1c()
{
  {
    init_simple_test("aSf_BFu7ll_BFu1c");
    static aSf_BFu7ll_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu1c(Test_aSf_BFu7ll_BFu1c, "aSf_BFu7ll_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu1i()
{
  {
    init_simple_test("aSf_BFu7ll_BFu1i");
    static aSf_BFu7ll_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu1i(Test_aSf_BFu7ll_BFu1i, "aSf_BFu7ll_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu1ll()
{
  {
    init_simple_test("aSf_BFu7ll_BFu1ll");
    static aSf_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu1ll(Test_aSf_BFu7ll_BFu1ll, "aSf_BFu7ll_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu1s()
{
  {
    init_simple_test("aSf_BFu7ll_BFu1s");
    static aSf_BFu7ll_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu1s(Test_aSf_BFu7ll_BFu1s, "aSf_BFu7ll_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu31i()
{
  {
    init_simple_test("aSf_BFu7ll_BFu31i");
    static aSf_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aSf_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aSf_BFu7ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu31i(Test_aSf_BFu7ll_BFu31i, "aSf_BFu7ll_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu31ll()
{
  {
    init_simple_test("aSf_BFu7ll_BFu31ll");
    static aSf_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aSf_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aSf_BFu7ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu31ll(Test_aSf_BFu7ll_BFu31ll, "aSf_BFu7ll_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu32i()
{
  {
    init_simple_test("aSf_BFu7ll_BFu32i");
    static aSf_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aSf_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aSf_BFu7ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu32i(Test_aSf_BFu7ll_BFu32i, "aSf_BFu7ll_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu32ll()
{
  {
    init_simple_test("aSf_BFu7ll_BFu32ll");
    static aSf_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aSf_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aSf_BFu7ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu32ll(Test_aSf_BFu7ll_BFu32ll, "aSf_BFu7ll_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu33()
{
  {
    init_simple_test("aSf_BFu7ll_BFu33");
    static aSf_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "aSf_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "aSf_BFu7ll_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu33(Test_aSf_BFu7ll_BFu33, "aSf_BFu7ll_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu7c()
{
  {
    init_simple_test("aSf_BFu7ll_BFu7c");
    static aSf_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu7c(Test_aSf_BFu7ll_BFu7c, "aSf_BFu7ll_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu7i()
{
  {
    init_simple_test("aSf_BFu7ll_BFu7i");
    static aSf_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu7i(Test_aSf_BFu7ll_BFu7i, "aSf_BFu7ll_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu7ll()
{
  {
    init_simple_test("aSf_BFu7ll_BFu7ll");
    static aSf_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu7ll(Test_aSf_BFu7ll_BFu7ll, "aSf_BFu7ll_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu7s()
{
  {
    init_simple_test("aSf_BFu7ll_BFu7s");
    static aSf_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu7s(Test_aSf_BFu7ll_BFu7s, "aSf_BFu7ll_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu8c()
{
  {
    init_simple_test("aSf_BFu7ll_BFu8c");
    static aSf_BFu7ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu8c(Test_aSf_BFu7ll_BFu8c, "aSf_BFu7ll_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu8i()
{
  {
    init_simple_test("aSf_BFu7ll_BFu8i");
    static aSf_BFu7ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu8i(Test_aSf_BFu7ll_BFu8i, "aSf_BFu7ll_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu8ll()
{
  {
    init_simple_test("aSf_BFu7ll_BFu8ll");
    static aSf_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu8ll(Test_aSf_BFu7ll_BFu8ll, "aSf_BFu7ll_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu8s()
{
  {
    init_simple_test("aSf_BFu7ll_BFu8s");
    static aSf_BFu7ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu8s(Test_aSf_BFu7ll_BFu8s, "aSf_BFu7ll_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu9i()
{
  {
    init_simple_test("aSf_BFu7ll_BFu9i");
    static aSf_BFu7ll_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aSf_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aSf_BFu7ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu9i(Test_aSf_BFu7ll_BFu9i, "aSf_BFu7ll_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu9ll()
{
  {
    init_simple_test("aSf_BFu7ll_BFu9ll");
    static aSf_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aSf_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aSf_BFu7ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu9ll(Test_aSf_BFu7ll_BFu9ll, "aSf_BFu7ll_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_BFu9s()
{
  {
    init_simple_test("aSf_BFu7ll_BFu9s");
    static aSf_BFu7ll_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aSf_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aSf_BFu7ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_BFu9s(Test_aSf_BFu7ll_BFu9s, "aSf_BFu7ll_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_C()
{
  {
    init_simple_test("aSf_BFu7ll_C");
    static aSf_BFu7ll_C lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_C");
    check_field_offset(lv, v3, 2, "aSf_BFu7ll_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_C(Test_aSf_BFu7ll_C, "aSf_BFu7ll_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_D()
{
  {
    init_simple_test("aSf_BFu7ll_D");
    static aSf_BFu7ll_D lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_D");
    check_field_offset(lv, v3, 2, "aSf_BFu7ll_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_D(Test_aSf_BFu7ll_D, "aSf_BFu7ll_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_F()
{
  {
    init_simple_test("aSf_BFu7ll_F");
    static aSf_BFu7ll_F lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_F");
    check_field_offset(lv, v3, 2, "aSf_BFu7ll_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_F(Test_aSf_BFu7ll_F, "aSf_BFu7ll_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_I()
{
  {
    init_simple_test("aSf_BFu7ll_I");
    static aSf_BFu7ll_I lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_I");
    check_field_offset(lv, v3, 2, "aSf_BFu7ll_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_I(Test_aSf_BFu7ll_I, "aSf_BFu7ll_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_Ip()
{
  {
    init_simple_test("aSf_BFu7ll_Ip");
    static aSf_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_Ip");
    check_field_offset(lv, v3, 2, "aSf_BFu7ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_Ip(Test_aSf_BFu7ll_Ip, "aSf_BFu7ll_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_L()
{
  {
    init_simple_test("aSf_BFu7ll_L");
    static aSf_BFu7ll_L lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_L");
    check_field_offset(lv, v3, 2, "aSf_BFu7ll_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_L(Test_aSf_BFu7ll_L, "aSf_BFu7ll_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_S()
{
  {
    init_simple_test("aSf_BFu7ll_S");
    static aSf_BFu7ll_S lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_S");
    check_field_offset(lv, v3, 2, "aSf_BFu7ll_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_S(Test_aSf_BFu7ll_S, "aSf_BFu7ll_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_Sf()
{
  {
    init_simple_test("aSf_BFu7ll_Sf");
    static aSf_BFu7ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_Sf");
    check_field_offset(lv, v3, 2, "aSf_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_Sf(Test_aSf_BFu7ll_Sf, "aSf_BFu7ll_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_Uc()
{
  {
    init_simple_test("aSf_BFu7ll_Uc");
    static aSf_BFu7ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_Uc");
    check_field_offset(lv, v3, 2, "aSf_BFu7ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_Uc(Test_aSf_BFu7ll_Uc, "aSf_BFu7ll_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_Ui()
{
  {
    init_simple_test("aSf_BFu7ll_Ui");
    static aSf_BFu7ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_Ui");
    check_field_offset(lv, v3, 2, "aSf_BFu7ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_Ui(Test_aSf_BFu7ll_Ui, "aSf_BFu7ll_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_Ul()
{
  {
    init_simple_test("aSf_BFu7ll_Ul");
    static aSf_BFu7ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_Ul");
    check_field_offset(lv, v3, 2, "aSf_BFu7ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_Ul(Test_aSf_BFu7ll_Ul, "aSf_BFu7ll_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_Us()
{
  {
    init_simple_test("aSf_BFu7ll_Us");
    static aSf_BFu7ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_Us");
    check_field_offset(lv, v3, 2, "aSf_BFu7ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_Us(Test_aSf_BFu7ll_Us, "aSf_BFu7ll_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7ll_Vp()
{
  {
    init_simple_test("aSf_BFu7ll_Vp");
    static aSf_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_Vp");
    check_field_offset(lv, v3, 2, "aSf_BFu7ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7ll_Vp(Test_aSf_BFu7ll_Vp, "aSf_BFu7ll_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s()
{
  {
    init_simple_test("aSf_BFu7s");
    static aSf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s(Test_aSf_BFu7s, "aSf_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu15i()
{
  {
    init_simple_test("aSf_BFu7s_BFu15i");
    static aSf_BFu7s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aSf_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aSf_BFu7s_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu15i(Test_aSf_BFu7s_BFu15i, "aSf_BFu7s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu15ll()
{
  {
    init_simple_test("aSf_BFu7s_BFu15ll");
    static aSf_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aSf_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aSf_BFu7s_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu15ll(Test_aSf_BFu7s_BFu15ll, "aSf_BFu7s_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu15s()
{
  {
    init_simple_test("aSf_BFu7s_BFu15s");
    static aSf_BFu7s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aSf_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aSf_BFu7s_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu15s(Test_aSf_BFu7s_BFu15s, "aSf_BFu7s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu16i()
{
  {
    init_simple_test("aSf_BFu7s_BFu16i");
    static aSf_BFu7s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aSf_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aSf_BFu7s_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu16i(Test_aSf_BFu7s_BFu16i, "aSf_BFu7s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu16ll()
{
  {
    init_simple_test("aSf_BFu7s_BFu16ll");
    static aSf_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aSf_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aSf_BFu7s_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu16ll(Test_aSf_BFu7s_BFu16ll, "aSf_BFu7s_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu16s()
{
  {
    init_simple_test("aSf_BFu7s_BFu16s");
    static aSf_BFu7s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aSf_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aSf_BFu7s_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu16s(Test_aSf_BFu7s_BFu16s, "aSf_BFu7s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu17i()
{
  {
    init_simple_test("aSf_BFu7s_BFu17i");
    static aSf_BFu7s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aSf_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aSf_BFu7s_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu17i(Test_aSf_BFu7s_BFu17i, "aSf_BFu7s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu17ll()
{
  {
    init_simple_test("aSf_BFu7s_BFu17ll");
    static aSf_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aSf_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aSf_BFu7s_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu17ll(Test_aSf_BFu7s_BFu17ll, "aSf_BFu7s_BFu17ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu1c()
{
  {
    init_simple_test("aSf_BFu7s_BFu1c");
    static aSf_BFu7s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7s_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu1c(Test_aSf_BFu7s_BFu1c, "aSf_BFu7s_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu1i()
{
  {
    init_simple_test("aSf_BFu7s_BFu1i");
    static aSf_BFu7s_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7s_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu1i(Test_aSf_BFu7s_BFu1i, "aSf_BFu7s_BFu1i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu1ll()
{
  {
    init_simple_test("aSf_BFu7s_BFu1ll");
    static aSf_BFu7s_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7s_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu1ll(Test_aSf_BFu7s_BFu1ll, "aSf_BFu7s_BFu1ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu1s()
{
  {
    init_simple_test("aSf_BFu7s_BFu1s");
    static aSf_BFu7s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aSf_BFu7s_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu1s(Test_aSf_BFu7s_BFu1s, "aSf_BFu7s_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu31i()
{
  {
    init_simple_test("aSf_BFu7s_BFu31i");
    static aSf_BFu7s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aSf_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aSf_BFu7s_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu31i(Test_aSf_BFu7s_BFu31i, "aSf_BFu7s_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu31ll()
{
  {
    init_simple_test("aSf_BFu7s_BFu31ll");
    static aSf_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aSf_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aSf_BFu7s_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu31ll(Test_aSf_BFu7s_BFu31ll, "aSf_BFu7s_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu32i()
{
  {
    init_simple_test("aSf_BFu7s_BFu32i");
    static aSf_BFu7s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aSf_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aSf_BFu7s_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu32i(Test_aSf_BFu7s_BFu32i, "aSf_BFu7s_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu32ll()
{
  {
    init_simple_test("aSf_BFu7s_BFu32ll");
    static aSf_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aSf_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aSf_BFu7s_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu32ll(Test_aSf_BFu7s_BFu32ll, "aSf_BFu7s_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu33()
{
  {
    init_simple_test("aSf_BFu7s_BFu33");
    static aSf_BFu7s_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "aSf_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "aSf_BFu7s_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu33(Test_aSf_BFu7s_BFu33, "aSf_BFu7s_BFu33", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu7c()
{
  {
    init_simple_test("aSf_BFu7s_BFu7c");
    static aSf_BFu7s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu7c(Test_aSf_BFu7s_BFu7c, "aSf_BFu7s_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu7i()
{
  {
    init_simple_test("aSf_BFu7s_BFu7i");
    static aSf_BFu7s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu7i(Test_aSf_BFu7s_BFu7i, "aSf_BFu7s_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu7ll()
{
  {
    init_simple_test("aSf_BFu7s_BFu7ll");
    static aSf_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu7ll(Test_aSf_BFu7s_BFu7ll, "aSf_BFu7s_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu7s()
{
  {
    init_simple_test("aSf_BFu7s_BFu7s");
    static aSf_BFu7s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aSf_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu7s(Test_aSf_BFu7s_BFu7s, "aSf_BFu7s_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu8c()
{
  {
    init_simple_test("aSf_BFu7s_BFu8c");
    static aSf_BFu7s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7s_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu8c(Test_aSf_BFu7s_BFu8c, "aSf_BFu7s_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu8i()
{
  {
    init_simple_test("aSf_BFu7s_BFu8i");
    static aSf_BFu7s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7s_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu8i(Test_aSf_BFu7s_BFu8i, "aSf_BFu7s_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu8ll()
{
  {
    init_simple_test("aSf_BFu7s_BFu8ll");
    static aSf_BFu7s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7s_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu8ll(Test_aSf_BFu7s_BFu8ll, "aSf_BFu7s_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu8s()
{
  {
    init_simple_test("aSf_BFu7s_BFu8s");
    static aSf_BFu7s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aSf_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aSf_BFu7s_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu8s(Test_aSf_BFu7s_BFu8s, "aSf_BFu7s_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu9i()
{
  {
    init_simple_test("aSf_BFu7s_BFu9i");
    static aSf_BFu7s_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aSf_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aSf_BFu7s_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu9i(Test_aSf_BFu7s_BFu9i, "aSf_BFu7s_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu9ll()
{
  {
    init_simple_test("aSf_BFu7s_BFu9ll");
    static aSf_BFu7s_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aSf_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aSf_BFu7s_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu9ll(Test_aSf_BFu7s_BFu9ll, "aSf_BFu7s_BFu9ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_BFu9s()
{
  {
    init_simple_test("aSf_BFu7s_BFu9s");
    static aSf_BFu7s_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aSf_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aSf_BFu7s_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_BFu9s(Test_aSf_BFu7s_BFu9s, "aSf_BFu7s_BFu9s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_C()
{
  {
    init_simple_test("aSf_BFu7s_C");
    static aSf_BFu7s_C lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_C");
    check_field_offset(lv, v3, 2, "aSf_BFu7s_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_C(Test_aSf_BFu7s_C, "aSf_BFu7s_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_D()
{
  {
    init_simple_test("aSf_BFu7s_D");
    static aSf_BFu7s_D lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_D");
    check_field_offset(lv, v3, 2, "aSf_BFu7s_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_D(Test_aSf_BFu7s_D, "aSf_BFu7s_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_F()
{
  {
    init_simple_test("aSf_BFu7s_F");
    static aSf_BFu7s_F lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_F");
    check_field_offset(lv, v3, 2, "aSf_BFu7s_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_F(Test_aSf_BFu7s_F, "aSf_BFu7s_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_I()
{
  {
    init_simple_test("aSf_BFu7s_I");
    static aSf_BFu7s_I lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_I");
    check_field_offset(lv, v3, 2, "aSf_BFu7s_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_I(Test_aSf_BFu7s_I, "aSf_BFu7s_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_Ip()
{
  {
    init_simple_test("aSf_BFu7s_Ip");
    static aSf_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_Ip");
    check_field_offset(lv, v3, 2, "aSf_BFu7s_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_Ip(Test_aSf_BFu7s_Ip, "aSf_BFu7s_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_L()
{
  {
    init_simple_test("aSf_BFu7s_L");
    static aSf_BFu7s_L lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu7s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_L");
    check_field_offset(lv, v3, 2, "aSf_BFu7s_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_L(Test_aSf_BFu7s_L, "aSf_BFu7s_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_S()
{
  {
    init_simple_test("aSf_BFu7s_S");
    static aSf_BFu7s_S lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_S");
    check_field_offset(lv, v3, 2, "aSf_BFu7s_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_S(Test_aSf_BFu7s_S, "aSf_BFu7s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_Sf()
{
  {
    init_simple_test("aSf_BFu7s_Sf");
    static aSf_BFu7s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_Sf");
    check_field_offset(lv, v3, 2, "aSf_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_Sf(Test_aSf_BFu7s_Sf, "aSf_BFu7s_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_Uc()
{
  {
    init_simple_test("aSf_BFu7s_Uc");
    static aSf_BFu7s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu7s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_Uc");
    check_field_offset(lv, v3, 2, "aSf_BFu7s_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_Uc(Test_aSf_BFu7s_Uc, "aSf_BFu7s_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_Ui()
{
  {
    init_simple_test("aSf_BFu7s_Ui");
    static aSf_BFu7s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu7s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_Ui");
    check_field_offset(lv, v3, 2, "aSf_BFu7s_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_Ui(Test_aSf_BFu7s_Ui, "aSf_BFu7s_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_Ul()
{
  {
    init_simple_test("aSf_BFu7s_Ul");
    static aSf_BFu7s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu7s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_Ul");
    check_field_offset(lv, v3, 2, "aSf_BFu7s_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_Ul(Test_aSf_BFu7s_Ul, "aSf_BFu7s_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_Us()
{
  {
    init_simple_test("aSf_BFu7s_Us");
    static aSf_BFu7s_Us lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu7s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_Us");
    check_field_offset(lv, v3, 2, "aSf_BFu7s_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_Us(Test_aSf_BFu7s_Us, "aSf_BFu7s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu7s_Vp()
{
  {
    init_simple_test("aSf_BFu7s_Vp");
    static aSf_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu7s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aSf_BFu7s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_Vp");
    check_field_offset(lv, v3, 2, "aSf_BFu7s_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu7s_Vp(Test_aSf_BFu7s_Vp, "aSf_BFu7s_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c()
{
  {
    init_simple_test("aSf_BFu8c");
    static aSf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c(Test_aSf_BFu8c, "aSf_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu15i()
{
  {
    init_simple_test("aSf_BFu8c_BFu15i");
    static aSf_BFu8c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aSf_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aSf_BFu8c_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu15i(Test_aSf_BFu8c_BFu15i, "aSf_BFu8c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu15ll()
{
  {
    init_simple_test("aSf_BFu8c_BFu15ll");
    static aSf_BFu8c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aSf_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aSf_BFu8c_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu15ll(Test_aSf_BFu8c_BFu15ll, "aSf_BFu8c_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu15s()
{
  {
    init_simple_test("aSf_BFu8c_BFu15s");
    static aSf_BFu8c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aSf_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aSf_BFu8c_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu15s(Test_aSf_BFu8c_BFu15s, "aSf_BFu8c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu16i()
{
  {
    init_simple_test("aSf_BFu8c_BFu16i");
    static aSf_BFu8c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aSf_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aSf_BFu8c_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu16i(Test_aSf_BFu8c_BFu16i, "aSf_BFu8c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu16ll()
{
  {
    init_simple_test("aSf_BFu8c_BFu16ll");
    static aSf_BFu8c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aSf_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aSf_BFu8c_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu16ll(Test_aSf_BFu8c_BFu16ll, "aSf_BFu8c_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu16s()
{
  {
    init_simple_test("aSf_BFu8c_BFu16s");
    static aSf_BFu8c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aSf_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aSf_BFu8c_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu16s(Test_aSf_BFu8c_BFu16s, "aSf_BFu8c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu17i()
{
  {
    init_simple_test("aSf_BFu8c_BFu17i");
    static aSf_BFu8c_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu8c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aSf_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aSf_BFu8c_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu17i(Test_aSf_BFu8c_BFu17i, "aSf_BFu8c_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu17ll()
{
  {
    init_simple_test("aSf_BFu8c_BFu17ll");
    static aSf_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu8c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aSf_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aSf_BFu8c_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu17ll(Test_aSf_BFu8c_BFu17ll, "aSf_BFu8c_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu1c()
{
  {
    init_simple_test("aSf_BFu8c_BFu1c");
    static aSf_BFu8c_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8c_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu1c(Test_aSf_BFu8c_BFu1c, "aSf_BFu8c_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu1i()
{
  {
    init_simple_test("aSf_BFu8c_BFu1i");
    static aSf_BFu8c_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8c_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu1i(Test_aSf_BFu8c_BFu1i, "aSf_BFu8c_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu1ll()
{
  {
    init_simple_test("aSf_BFu8c_BFu1ll");
    static aSf_BFu8c_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8c_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu1ll(Test_aSf_BFu8c_BFu1ll, "aSf_BFu8c_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu1s()
{
  {
    init_simple_test("aSf_BFu8c_BFu1s");
    static aSf_BFu8c_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8c_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu1s(Test_aSf_BFu8c_BFu1s, "aSf_BFu8c_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu31i()
{
  {
    init_simple_test("aSf_BFu8c_BFu31i");
    static aSf_BFu8c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aSf_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aSf_BFu8c_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu31i(Test_aSf_BFu8c_BFu31i, "aSf_BFu8c_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu31ll()
{
  {
    init_simple_test("aSf_BFu8c_BFu31ll");
    static aSf_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aSf_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aSf_BFu8c_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu31ll(Test_aSf_BFu8c_BFu31ll, "aSf_BFu8c_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu32i()
{
  {
    init_simple_test("aSf_BFu8c_BFu32i");
    static aSf_BFu8c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aSf_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aSf_BFu8c_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu32i(Test_aSf_BFu8c_BFu32i, "aSf_BFu8c_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu32ll()
{
  {
    init_simple_test("aSf_BFu8c_BFu32ll");
    static aSf_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aSf_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aSf_BFu8c_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu32ll(Test_aSf_BFu8c_BFu32ll, "aSf_BFu8c_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu33()
{
  {
    init_simple_test("aSf_BFu8c_BFu33");
    static aSf_BFu8c_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aSf_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aSf_BFu8c_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu33(Test_aSf_BFu8c_BFu33, "aSf_BFu8c_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu7c()
{
  {
    init_simple_test("aSf_BFu8c_BFu7c");
    static aSf_BFu8c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8c_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu7c(Test_aSf_BFu8c_BFu7c, "aSf_BFu8c_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu7i()
{
  {
    init_simple_test("aSf_BFu8c_BFu7i");
    static aSf_BFu8c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8c_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu7i(Test_aSf_BFu8c_BFu7i, "aSf_BFu8c_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu7ll()
{
  {
    init_simple_test("aSf_BFu8c_BFu7ll");
    static aSf_BFu8c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8c_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu7ll(Test_aSf_BFu8c_BFu7ll, "aSf_BFu8c_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu7s()
{
  {
    init_simple_test("aSf_BFu8c_BFu7s");
    static aSf_BFu8c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8c_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu7s(Test_aSf_BFu8c_BFu7s, "aSf_BFu8c_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu8c()
{
  {
    init_simple_test("aSf_BFu8c_BFu8c");
    static aSf_BFu8c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu8c(Test_aSf_BFu8c_BFu8c, "aSf_BFu8c_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu8i()
{
  {
    init_simple_test("aSf_BFu8c_BFu8i");
    static aSf_BFu8c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu8i(Test_aSf_BFu8c_BFu8i, "aSf_BFu8c_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu8ll()
{
  {
    init_simple_test("aSf_BFu8c_BFu8ll");
    static aSf_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu8ll(Test_aSf_BFu8c_BFu8ll, "aSf_BFu8c_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu8s()
{
  {
    init_simple_test("aSf_BFu8c_BFu8s");
    static aSf_BFu8c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu8s(Test_aSf_BFu8c_BFu8s, "aSf_BFu8c_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu9i()
{
  {
    init_simple_test("aSf_BFu8c_BFu9i");
    static aSf_BFu8c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aSf_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aSf_BFu8c_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu9i(Test_aSf_BFu8c_BFu9i, "aSf_BFu8c_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu9ll()
{
  {
    init_simple_test("aSf_BFu8c_BFu9ll");
    static aSf_BFu8c_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aSf_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aSf_BFu8c_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu9ll(Test_aSf_BFu8c_BFu9ll, "aSf_BFu8c_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_BFu9s()
{
  {
    init_simple_test("aSf_BFu8c_BFu9s");
    static aSf_BFu8c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aSf_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aSf_BFu8c_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_BFu9s(Test_aSf_BFu8c_BFu9s, "aSf_BFu8c_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_C()
{
  {
    init_simple_test("aSf_BFu8c_C");
    static aSf_BFu8c_C lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_C");
    check_field_offset(lv, v3, 2, "aSf_BFu8c_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_C(Test_aSf_BFu8c_C, "aSf_BFu8c_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_D()
{
  {
    init_simple_test("aSf_BFu8c_D");
    static aSf_BFu8c_D lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu8c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_D");
    check_field_offset(lv, v3, 2, "aSf_BFu8c_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_D(Test_aSf_BFu8c_D, "aSf_BFu8c_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_F()
{
  {
    init_simple_test("aSf_BFu8c_F");
    static aSf_BFu8c_F lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_F");
    check_field_offset(lv, v3, 2, "aSf_BFu8c_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_F(Test_aSf_BFu8c_F, "aSf_BFu8c_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_I()
{
  {
    init_simple_test("aSf_BFu8c_I");
    static aSf_BFu8c_I lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_I");
    check_field_offset(lv, v3, 2, "aSf_BFu8c_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_I(Test_aSf_BFu8c_I, "aSf_BFu8c_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_Ip()
{
  {
    init_simple_test("aSf_BFu8c_Ip");
    static aSf_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu8c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_Ip");
    check_field_offset(lv, v3, 2, "aSf_BFu8c_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_Ip(Test_aSf_BFu8c_Ip, "aSf_BFu8c_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_L()
{
  {
    init_simple_test("aSf_BFu8c_L");
    static aSf_BFu8c_L lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu8c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_L");
    check_field_offset(lv, v3, 2, "aSf_BFu8c_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_L(Test_aSf_BFu8c_L, "aSf_BFu8c_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_S()
{
  {
    init_simple_test("aSf_BFu8c_S");
    static aSf_BFu8c_S lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_S");
    check_field_offset(lv, v3, 2, "aSf_BFu8c_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_S(Test_aSf_BFu8c_S, "aSf_BFu8c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_Sf()
{
  {
    init_simple_test("aSf_BFu8c_Sf");
    static aSf_BFu8c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "aSf_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_Sf(Test_aSf_BFu8c_Sf, "aSf_BFu8c_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_Uc()
{
  {
    init_simple_test("aSf_BFu8c_Uc");
    static aSf_BFu8c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_Uc");
    check_field_offset(lv, v3, 2, "aSf_BFu8c_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_Uc(Test_aSf_BFu8c_Uc, "aSf_BFu8c_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_Ui()
{
  {
    init_simple_test("aSf_BFu8c_Ui");
    static aSf_BFu8c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_Ui");
    check_field_offset(lv, v3, 2, "aSf_BFu8c_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_Ui(Test_aSf_BFu8c_Ui, "aSf_BFu8c_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_Ul()
{
  {
    init_simple_test("aSf_BFu8c_Ul");
    static aSf_BFu8c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu8c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_Ul");
    check_field_offset(lv, v3, 2, "aSf_BFu8c_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_Ul(Test_aSf_BFu8c_Ul, "aSf_BFu8c_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_Us()
{
  {
    init_simple_test("aSf_BFu8c_Us");
    static aSf_BFu8c_Us lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_Us");
    check_field_offset(lv, v3, 2, "aSf_BFu8c_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_Us(Test_aSf_BFu8c_Us, "aSf_BFu8c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8c_Vp()
{
  {
    init_simple_test("aSf_BFu8c_Vp");
    static aSf_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu8c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_Vp");
    check_field_offset(lv, v3, 2, "aSf_BFu8c_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8c_Vp(Test_aSf_BFu8c_Vp, "aSf_BFu8c_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i()
{
  {
    init_simple_test("aSf_BFu8i");
    static aSf_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i(Test_aSf_BFu8i, "aSf_BFu8i", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu15i()
{
  {
    init_simple_test("aSf_BFu8i_BFu15i");
    static aSf_BFu8i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aSf_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aSf_BFu8i_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu15i(Test_aSf_BFu8i_BFu15i, "aSf_BFu8i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu15ll()
{
  {
    init_simple_test("aSf_BFu8i_BFu15ll");
    static aSf_BFu8i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aSf_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aSf_BFu8i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu15ll(Test_aSf_BFu8i_BFu15ll, "aSf_BFu8i_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu15s()
{
  {
    init_simple_test("aSf_BFu8i_BFu15s");
    static aSf_BFu8i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aSf_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aSf_BFu8i_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu15s(Test_aSf_BFu8i_BFu15s, "aSf_BFu8i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu16i()
{
  {
    init_simple_test("aSf_BFu8i_BFu16i");
    static aSf_BFu8i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aSf_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aSf_BFu8i_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu16i(Test_aSf_BFu8i_BFu16i, "aSf_BFu8i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu16ll()
{
  {
    init_simple_test("aSf_BFu8i_BFu16ll");
    static aSf_BFu8i_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aSf_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aSf_BFu8i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu16ll(Test_aSf_BFu8i_BFu16ll, "aSf_BFu8i_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu16s()
{
  {
    init_simple_test("aSf_BFu8i_BFu16s");
    static aSf_BFu8i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aSf_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aSf_BFu8i_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu16s(Test_aSf_BFu8i_BFu16s, "aSf_BFu8i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu17i()
{
  {
    init_simple_test("aSf_BFu8i_BFu17i");
    static aSf_BFu8i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu8i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aSf_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aSf_BFu8i_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu17i(Test_aSf_BFu8i_BFu17i, "aSf_BFu8i_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu17ll()
{
  {
    init_simple_test("aSf_BFu8i_BFu17ll");
    static aSf_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu8i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aSf_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aSf_BFu8i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu17ll(Test_aSf_BFu8i_BFu17ll, "aSf_BFu8i_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu1c()
{
  {
    init_simple_test("aSf_BFu8i_BFu1c");
    static aSf_BFu8i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8i_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu1c(Test_aSf_BFu8i_BFu1c, "aSf_BFu8i_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu1i()
{
  {
    init_simple_test("aSf_BFu8i_BFu1i");
    static aSf_BFu8i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8i_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu1i(Test_aSf_BFu8i_BFu1i, "aSf_BFu8i_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu1ll()
{
  {
    init_simple_test("aSf_BFu8i_BFu1ll");
    static aSf_BFu8i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu1ll(Test_aSf_BFu8i_BFu1ll, "aSf_BFu8i_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu1s()
{
  {
    init_simple_test("aSf_BFu8i_BFu1s");
    static aSf_BFu8i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8i_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu1s(Test_aSf_BFu8i_BFu1s, "aSf_BFu8i_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu31i()
{
  {
    init_simple_test("aSf_BFu8i_BFu31i");
    static aSf_BFu8i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aSf_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aSf_BFu8i_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu31i(Test_aSf_BFu8i_BFu31i, "aSf_BFu8i_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu31ll()
{
  {
    init_simple_test("aSf_BFu8i_BFu31ll");
    static aSf_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aSf_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aSf_BFu8i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu31ll(Test_aSf_BFu8i_BFu31ll, "aSf_BFu8i_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu32i()
{
  {
    init_simple_test("aSf_BFu8i_BFu32i");
    static aSf_BFu8i_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aSf_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aSf_BFu8i_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu32i(Test_aSf_BFu8i_BFu32i, "aSf_BFu8i_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu32ll()
{
  {
    init_simple_test("aSf_BFu8i_BFu32ll");
    static aSf_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aSf_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aSf_BFu8i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu32ll(Test_aSf_BFu8i_BFu32ll, "aSf_BFu8i_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu33()
{
  {
    init_simple_test("aSf_BFu8i_BFu33");
    static aSf_BFu8i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu8i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aSf_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aSf_BFu8i_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu33(Test_aSf_BFu8i_BFu33, "aSf_BFu8i_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu7c()
{
  {
    init_simple_test("aSf_BFu8i_BFu7c");
    static aSf_BFu8i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8i_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu7c(Test_aSf_BFu8i_BFu7c, "aSf_BFu8i_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu7i()
{
  {
    init_simple_test("aSf_BFu8i_BFu7i");
    static aSf_BFu8i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8i_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu7i(Test_aSf_BFu8i_BFu7i, "aSf_BFu8i_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu7ll()
{
  {
    init_simple_test("aSf_BFu8i_BFu7ll");
    static aSf_BFu8i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu7ll(Test_aSf_BFu8i_BFu7ll, "aSf_BFu8i_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu7s()
{
  {
    init_simple_test("aSf_BFu8i_BFu7s");
    static aSf_BFu8i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8i_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu7s(Test_aSf_BFu8i_BFu7s, "aSf_BFu8i_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu8c()
{
  {
    init_simple_test("aSf_BFu8i_BFu8c");
    static aSf_BFu8i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu8c(Test_aSf_BFu8i_BFu8c, "aSf_BFu8i_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu8i()
{
  {
    init_simple_test("aSf_BFu8i_BFu8i");
    static aSf_BFu8i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu8i(Test_aSf_BFu8i_BFu8i, "aSf_BFu8i_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu8ll()
{
  {
    init_simple_test("aSf_BFu8i_BFu8ll");
    static aSf_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu8ll(Test_aSf_BFu8i_BFu8ll, "aSf_BFu8i_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu8s()
{
  {
    init_simple_test("aSf_BFu8i_BFu8s");
    static aSf_BFu8i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu8s(Test_aSf_BFu8i_BFu8s, "aSf_BFu8i_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu9i()
{
  {
    init_simple_test("aSf_BFu8i_BFu9i");
    static aSf_BFu8i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aSf_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aSf_BFu8i_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu9i(Test_aSf_BFu8i_BFu9i, "aSf_BFu8i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu9ll()
{
  {
    init_simple_test("aSf_BFu8i_BFu9ll");
    static aSf_BFu8i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aSf_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aSf_BFu8i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu9ll(Test_aSf_BFu8i_BFu9ll, "aSf_BFu8i_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_BFu9s()
{
  {
    init_simple_test("aSf_BFu8i_BFu9s");
    static aSf_BFu8i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aSf_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aSf_BFu8i_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_BFu9s(Test_aSf_BFu8i_BFu9s, "aSf_BFu8i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_C()
{
  {
    init_simple_test("aSf_BFu8i_C");
    static aSf_BFu8i_C lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_C");
    check_field_offset(lv, v3, 2, "aSf_BFu8i_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_C(Test_aSf_BFu8i_C, "aSf_BFu8i_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_D()
{
  {
    init_simple_test("aSf_BFu8i_D");
    static aSf_BFu8i_D lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu8i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_D");
    check_field_offset(lv, v3, 2, "aSf_BFu8i_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_D(Test_aSf_BFu8i_D, "aSf_BFu8i_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_F()
{
  {
    init_simple_test("aSf_BFu8i_F");
    static aSf_BFu8i_F lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_F");
    check_field_offset(lv, v3, 2, "aSf_BFu8i_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_F(Test_aSf_BFu8i_F, "aSf_BFu8i_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_I()
{
  {
    init_simple_test("aSf_BFu8i_I");
    static aSf_BFu8i_I lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_I");
    check_field_offset(lv, v3, 2, "aSf_BFu8i_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_I(Test_aSf_BFu8i_I, "aSf_BFu8i_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_Ip()
{
  {
    init_simple_test("aSf_BFu8i_Ip");
    static aSf_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu8i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_Ip");
    check_field_offset(lv, v3, 2, "aSf_BFu8i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_Ip(Test_aSf_BFu8i_Ip, "aSf_BFu8i_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_L()
{
  {
    init_simple_test("aSf_BFu8i_L");
    static aSf_BFu8i_L lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu8i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_L");
    check_field_offset(lv, v3, 2, "aSf_BFu8i_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_L(Test_aSf_BFu8i_L, "aSf_BFu8i_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_S()
{
  {
    init_simple_test("aSf_BFu8i_S");
    static aSf_BFu8i_S lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_S");
    check_field_offset(lv, v3, 2, "aSf_BFu8i_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_S(Test_aSf_BFu8i_S, "aSf_BFu8i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_Sf()
{
  {
    init_simple_test("aSf_BFu8i_Sf");
    static aSf_BFu8i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "aSf_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_Sf(Test_aSf_BFu8i_Sf, "aSf_BFu8i_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_Uc()
{
  {
    init_simple_test("aSf_BFu8i_Uc");
    static aSf_BFu8i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_Uc");
    check_field_offset(lv, v3, 2, "aSf_BFu8i_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_Uc(Test_aSf_BFu8i_Uc, "aSf_BFu8i_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_Ui()
{
  {
    init_simple_test("aSf_BFu8i_Ui");
    static aSf_BFu8i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_Ui");
    check_field_offset(lv, v3, 2, "aSf_BFu8i_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_Ui(Test_aSf_BFu8i_Ui, "aSf_BFu8i_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_Ul()
{
  {
    init_simple_test("aSf_BFu8i_Ul");
    static aSf_BFu8i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu8i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_Ul");
    check_field_offset(lv, v3, 2, "aSf_BFu8i_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_Ul(Test_aSf_BFu8i_Ul, "aSf_BFu8i_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_Us()
{
  {
    init_simple_test("aSf_BFu8i_Us");
    static aSf_BFu8i_Us lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_Us");
    check_field_offset(lv, v3, 2, "aSf_BFu8i_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_Us(Test_aSf_BFu8i_Us, "aSf_BFu8i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8i_Vp()
{
  {
    init_simple_test("aSf_BFu8i_Vp");
    static aSf_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu8i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_Vp");
    check_field_offset(lv, v3, 2, "aSf_BFu8i_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8i_Vp(Test_aSf_BFu8i_Vp, "aSf_BFu8i_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll()
{
  {
    init_simple_test("aSf_BFu8ll");
    static aSf_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll(Test_aSf_BFu8ll, "aSf_BFu8ll", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu15i()
{
  {
    init_simple_test("aSf_BFu8ll_BFu15i");
    static aSf_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aSf_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aSf_BFu8ll_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu15i(Test_aSf_BFu8ll_BFu15i, "aSf_BFu8ll_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu15ll()
{
  {
    init_simple_test("aSf_BFu8ll_BFu15ll");
    static aSf_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aSf_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aSf_BFu8ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu15ll(Test_aSf_BFu8ll_BFu15ll, "aSf_BFu8ll_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu15s()
{
  {
    init_simple_test("aSf_BFu8ll_BFu15s");
    static aSf_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aSf_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aSf_BFu8ll_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu15s(Test_aSf_BFu8ll_BFu15s, "aSf_BFu8ll_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu16i()
{
  {
    init_simple_test("aSf_BFu8ll_BFu16i");
    static aSf_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aSf_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aSf_BFu8ll_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu16i(Test_aSf_BFu8ll_BFu16i, "aSf_BFu8ll_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu16ll()
{
  {
    init_simple_test("aSf_BFu8ll_BFu16ll");
    static aSf_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aSf_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aSf_BFu8ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu16ll(Test_aSf_BFu8ll_BFu16ll, "aSf_BFu8ll_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu16s()
{
  {
    init_simple_test("aSf_BFu8ll_BFu16s");
    static aSf_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aSf_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aSf_BFu8ll_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu16s(Test_aSf_BFu8ll_BFu16s, "aSf_BFu8ll_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu17i()
{
  {
    init_simple_test("aSf_BFu8ll_BFu17i");
    static aSf_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu8ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aSf_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aSf_BFu8ll_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu17i(Test_aSf_BFu8ll_BFu17i, "aSf_BFu8ll_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu17ll()
{
  {
    init_simple_test("aSf_BFu8ll_BFu17ll");
    static aSf_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aSf_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aSf_BFu8ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu17ll(Test_aSf_BFu8ll_BFu17ll, "aSf_BFu8ll_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu1c()
{
  {
    init_simple_test("aSf_BFu8ll_BFu1c");
    static aSf_BFu8ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8ll_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu1c(Test_aSf_BFu8ll_BFu1c, "aSf_BFu8ll_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu1i()
{
  {
    init_simple_test("aSf_BFu8ll_BFu1i");
    static aSf_BFu8ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8ll_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu1i(Test_aSf_BFu8ll_BFu1i, "aSf_BFu8ll_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu1ll()
{
  {
    init_simple_test("aSf_BFu8ll_BFu1ll");
    static aSf_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu1ll(Test_aSf_BFu8ll_BFu1ll, "aSf_BFu8ll_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu1s()
{
  {
    init_simple_test("aSf_BFu8ll_BFu1s");
    static aSf_BFu8ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8ll_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu1s(Test_aSf_BFu8ll_BFu1s, "aSf_BFu8ll_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu31i()
{
  {
    init_simple_test("aSf_BFu8ll_BFu31i");
    static aSf_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aSf_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aSf_BFu8ll_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu31i(Test_aSf_BFu8ll_BFu31i, "aSf_BFu8ll_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu31ll()
{
  {
    init_simple_test("aSf_BFu8ll_BFu31ll");
    static aSf_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aSf_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aSf_BFu8ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu31ll(Test_aSf_BFu8ll_BFu31ll, "aSf_BFu8ll_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu32i()
{
  {
    init_simple_test("aSf_BFu8ll_BFu32i");
    static aSf_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aSf_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aSf_BFu8ll_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu32i(Test_aSf_BFu8ll_BFu32i, "aSf_BFu8ll_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu32ll()
{
  {
    init_simple_test("aSf_BFu8ll_BFu32ll");
    static aSf_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aSf_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aSf_BFu8ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu32ll(Test_aSf_BFu8ll_BFu32ll, "aSf_BFu8ll_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu33()
{
  {
    init_simple_test("aSf_BFu8ll_BFu33");
    static aSf_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu8ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aSf_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aSf_BFu8ll_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu33(Test_aSf_BFu8ll_BFu33, "aSf_BFu8ll_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu7c()
{
  {
    init_simple_test("aSf_BFu8ll_BFu7c");
    static aSf_BFu8ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8ll_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu7c(Test_aSf_BFu8ll_BFu7c, "aSf_BFu8ll_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu7i()
{
  {
    init_simple_test("aSf_BFu8ll_BFu7i");
    static aSf_BFu8ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8ll_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu7i(Test_aSf_BFu8ll_BFu7i, "aSf_BFu8ll_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu7ll()
{
  {
    init_simple_test("aSf_BFu8ll_BFu7ll");
    static aSf_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu7ll(Test_aSf_BFu8ll_BFu7ll, "aSf_BFu8ll_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu7s()
{
  {
    init_simple_test("aSf_BFu8ll_BFu7s");
    static aSf_BFu8ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8ll_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu7s(Test_aSf_BFu8ll_BFu7s, "aSf_BFu8ll_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu8c()
{
  {
    init_simple_test("aSf_BFu8ll_BFu8c");
    static aSf_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu8c(Test_aSf_BFu8ll_BFu8c, "aSf_BFu8ll_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu8i()
{
  {
    init_simple_test("aSf_BFu8ll_BFu8i");
    static aSf_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu8i(Test_aSf_BFu8ll_BFu8i, "aSf_BFu8ll_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu8ll()
{
  {
    init_simple_test("aSf_BFu8ll_BFu8ll");
    static aSf_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu8ll(Test_aSf_BFu8ll_BFu8ll, "aSf_BFu8ll_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu8s()
{
  {
    init_simple_test("aSf_BFu8ll_BFu8s");
    static aSf_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu8s(Test_aSf_BFu8ll_BFu8s, "aSf_BFu8ll_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu9i()
{
  {
    init_simple_test("aSf_BFu8ll_BFu9i");
    static aSf_BFu8ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aSf_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aSf_BFu8ll_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu9i(Test_aSf_BFu8ll_BFu9i, "aSf_BFu8ll_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu9ll()
{
  {
    init_simple_test("aSf_BFu8ll_BFu9ll");
    static aSf_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aSf_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aSf_BFu8ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu9ll(Test_aSf_BFu8ll_BFu9ll, "aSf_BFu8ll_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_BFu9s()
{
  {
    init_simple_test("aSf_BFu8ll_BFu9s");
    static aSf_BFu8ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aSf_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aSf_BFu8ll_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_BFu9s(Test_aSf_BFu8ll_BFu9s, "aSf_BFu8ll_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_C()
{
  {
    init_simple_test("aSf_BFu8ll_C");
    static aSf_BFu8ll_C lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_C");
    check_field_offset(lv, v3, 2, "aSf_BFu8ll_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_C(Test_aSf_BFu8ll_C, "aSf_BFu8ll_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_D()
{
  {
    init_simple_test("aSf_BFu8ll_D");
    static aSf_BFu8ll_D lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu8ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_D");
    check_field_offset(lv, v3, 2, "aSf_BFu8ll_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_D(Test_aSf_BFu8ll_D, "aSf_BFu8ll_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_F()
{
  {
    init_simple_test("aSf_BFu8ll_F");
    static aSf_BFu8ll_F lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_F");
    check_field_offset(lv, v3, 2, "aSf_BFu8ll_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_F(Test_aSf_BFu8ll_F, "aSf_BFu8ll_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_I()
{
  {
    init_simple_test("aSf_BFu8ll_I");
    static aSf_BFu8ll_I lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_I");
    check_field_offset(lv, v3, 2, "aSf_BFu8ll_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_I(Test_aSf_BFu8ll_I, "aSf_BFu8ll_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_Ip()
{
  {
    init_simple_test("aSf_BFu8ll_Ip");
    static aSf_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_Ip");
    check_field_offset(lv, v3, 2, "aSf_BFu8ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_Ip(Test_aSf_BFu8ll_Ip, "aSf_BFu8ll_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_L()
{
  {
    init_simple_test("aSf_BFu8ll_L");
    static aSf_BFu8ll_L lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_L");
    check_field_offset(lv, v3, 2, "aSf_BFu8ll_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_L(Test_aSf_BFu8ll_L, "aSf_BFu8ll_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_S()
{
  {
    init_simple_test("aSf_BFu8ll_S");
    static aSf_BFu8ll_S lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_S");
    check_field_offset(lv, v3, 2, "aSf_BFu8ll_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_S(Test_aSf_BFu8ll_S, "aSf_BFu8ll_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_Sf()
{
  {
    init_simple_test("aSf_BFu8ll_Sf");
    static aSf_BFu8ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "aSf_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_Sf(Test_aSf_BFu8ll_Sf, "aSf_BFu8ll_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_Uc()
{
  {
    init_simple_test("aSf_BFu8ll_Uc");
    static aSf_BFu8ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_Uc");
    check_field_offset(lv, v3, 2, "aSf_BFu8ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_Uc(Test_aSf_BFu8ll_Uc, "aSf_BFu8ll_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_Ui()
{
  {
    init_simple_test("aSf_BFu8ll_Ui");
    static aSf_BFu8ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_Ui");
    check_field_offset(lv, v3, 2, "aSf_BFu8ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_Ui(Test_aSf_BFu8ll_Ui, "aSf_BFu8ll_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_Ul()
{
  {
    init_simple_test("aSf_BFu8ll_Ul");
    static aSf_BFu8ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_Ul");
    check_field_offset(lv, v3, 2, "aSf_BFu8ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_Ul(Test_aSf_BFu8ll_Ul, "aSf_BFu8ll_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_Us()
{
  {
    init_simple_test("aSf_BFu8ll_Us");
    static aSf_BFu8ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_Us");
    check_field_offset(lv, v3, 2, "aSf_BFu8ll_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_Us(Test_aSf_BFu8ll_Us, "aSf_BFu8ll_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8ll_Vp()
{
  {
    init_simple_test("aSf_BFu8ll_Vp");
    static aSf_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_Vp");
    check_field_offset(lv, v3, 2, "aSf_BFu8ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8ll_Vp(Test_aSf_BFu8ll_Vp, "aSf_BFu8ll_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s()
{
  {
    init_simple_test("aSf_BFu8s");
    static aSf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s(Test_aSf_BFu8s, "aSf_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu15i()
{
  {
    init_simple_test("aSf_BFu8s_BFu15i");
    static aSf_BFu8s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aSf_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aSf_BFu8s_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu15i(Test_aSf_BFu8s_BFu15i, "aSf_BFu8s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu15ll()
{
  {
    init_simple_test("aSf_BFu8s_BFu15ll");
    static aSf_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aSf_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aSf_BFu8s_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu15ll(Test_aSf_BFu8s_BFu15ll, "aSf_BFu8s_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu15s()
{
  {
    init_simple_test("aSf_BFu8s_BFu15s");
    static aSf_BFu8s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aSf_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aSf_BFu8s_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu15s(Test_aSf_BFu8s_BFu15s, "aSf_BFu8s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu16i()
{
  {
    init_simple_test("aSf_BFu8s_BFu16i");
    static aSf_BFu8s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aSf_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aSf_BFu8s_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu16i(Test_aSf_BFu8s_BFu16i, "aSf_BFu8s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu16ll()
{
  {
    init_simple_test("aSf_BFu8s_BFu16ll");
    static aSf_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aSf_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aSf_BFu8s_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu16ll(Test_aSf_BFu8s_BFu16ll, "aSf_BFu8s_BFu16ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu16s()
{
  {
    init_simple_test("aSf_BFu8s_BFu16s");
    static aSf_BFu8s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aSf_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aSf_BFu8s_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu16s(Test_aSf_BFu8s_BFu16s, "aSf_BFu8s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu17i()
{
  {
    init_simple_test("aSf_BFu8s_BFu17i");
    static aSf_BFu8s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu8s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aSf_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aSf_BFu8s_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu17i(Test_aSf_BFu8s_BFu17i, "aSf_BFu8s_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu17ll()
{
  {
    init_simple_test("aSf_BFu8s_BFu17ll");
    static aSf_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu8s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aSf_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aSf_BFu8s_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu17ll(Test_aSf_BFu8s_BFu17ll, "aSf_BFu8s_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu1c()
{
  {
    init_simple_test("aSf_BFu8s_BFu1c");
    static aSf_BFu8s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8s_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu1c(Test_aSf_BFu8s_BFu1c, "aSf_BFu8s_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu1i()
{
  {
    init_simple_test("aSf_BFu8s_BFu1i");
    static aSf_BFu8s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8s_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu1i(Test_aSf_BFu8s_BFu1i, "aSf_BFu8s_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu1ll()
{
  {
    init_simple_test("aSf_BFu8s_BFu1ll");
    static aSf_BFu8s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8s_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu1ll(Test_aSf_BFu8s_BFu1ll, "aSf_BFu8s_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu1s()
{
  {
    init_simple_test("aSf_BFu8s_BFu1s");
    static aSf_BFu8s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aSf_BFu8s_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu1s(Test_aSf_BFu8s_BFu1s, "aSf_BFu8s_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu31i()
{
  {
    init_simple_test("aSf_BFu8s_BFu31i");
    static aSf_BFu8s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aSf_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aSf_BFu8s_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu31i(Test_aSf_BFu8s_BFu31i, "aSf_BFu8s_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu31ll()
{
  {
    init_simple_test("aSf_BFu8s_BFu31ll");
    static aSf_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aSf_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aSf_BFu8s_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu31ll(Test_aSf_BFu8s_BFu31ll, "aSf_BFu8s_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu32i()
{
  {
    init_simple_test("aSf_BFu8s_BFu32i");
    static aSf_BFu8s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aSf_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aSf_BFu8s_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu32i(Test_aSf_BFu8s_BFu32i, "aSf_BFu8s_BFu32i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu32ll()
{
  {
    init_simple_test("aSf_BFu8s_BFu32ll");
    static aSf_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aSf_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aSf_BFu8s_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu32ll(Test_aSf_BFu8s_BFu32ll, "aSf_BFu8s_BFu32ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu33()
{
  {
    init_simple_test("aSf_BFu8s_BFu33");
    static aSf_BFu8s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu8s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aSf_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aSf_BFu8s_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu33(Test_aSf_BFu8s_BFu33, "aSf_BFu8s_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu7c()
{
  {
    init_simple_test("aSf_BFu8s_BFu7c");
    static aSf_BFu8s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8s_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu7c(Test_aSf_BFu8s_BFu7c, "aSf_BFu8s_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu7i()
{
  {
    init_simple_test("aSf_BFu8s_BFu7i");
    static aSf_BFu8s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8s_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu7i(Test_aSf_BFu8s_BFu7i, "aSf_BFu8s_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu7ll()
{
  {
    init_simple_test("aSf_BFu8s_BFu7ll");
    static aSf_BFu8s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8s_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu7ll(Test_aSf_BFu8s_BFu7ll, "aSf_BFu8s_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu7s()
{
  {
    init_simple_test("aSf_BFu8s_BFu7s");
    static aSf_BFu8s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aSf_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aSf_BFu8s_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu7s(Test_aSf_BFu8s_BFu7s, "aSf_BFu8s_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu8c()
{
  {
    init_simple_test("aSf_BFu8s_BFu8c");
    static aSf_BFu8s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu8c(Test_aSf_BFu8s_BFu8c, "aSf_BFu8s_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu8i()
{
  {
    init_simple_test("aSf_BFu8s_BFu8i");
    static aSf_BFu8s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu8i(Test_aSf_BFu8s_BFu8i, "aSf_BFu8s_BFu8i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu8ll()
{
  {
    init_simple_test("aSf_BFu8s_BFu8ll");
    static aSf_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu8ll(Test_aSf_BFu8s_BFu8ll, "aSf_BFu8s_BFu8ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu8s()
{
  {
    init_simple_test("aSf_BFu8s_BFu8s");
    static aSf_BFu8s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aSf_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu8s(Test_aSf_BFu8s_BFu8s, "aSf_BFu8s_BFu8s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu9i()
{
  {
    init_simple_test("aSf_BFu8s_BFu9i");
    static aSf_BFu8s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aSf_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aSf_BFu8s_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu9i(Test_aSf_BFu8s_BFu9i, "aSf_BFu8s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu9ll()
{
  {
    init_simple_test("aSf_BFu8s_BFu9ll");
    static aSf_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aSf_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aSf_BFu8s_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu9ll(Test_aSf_BFu8s_BFu9ll, "aSf_BFu8s_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_BFu9s()
{
  {
    init_simple_test("aSf_BFu8s_BFu9s");
    static aSf_BFu8s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aSf_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aSf_BFu8s_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_BFu9s(Test_aSf_BFu8s_BFu9s, "aSf_BFu8s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_C()
{
  {
    init_simple_test("aSf_BFu8s_C");
    static aSf_BFu8s_C lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_C");
    check_field_offset(lv, v3, 2, "aSf_BFu8s_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_C(Test_aSf_BFu8s_C, "aSf_BFu8s_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_D()
{
  {
    init_simple_test("aSf_BFu8s_D");
    static aSf_BFu8s_D lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu8s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_D");
    check_field_offset(lv, v3, 2, "aSf_BFu8s_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_D(Test_aSf_BFu8s_D, "aSf_BFu8s_D", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_F()
{
  {
    init_simple_test("aSf_BFu8s_F");
    static aSf_BFu8s_F lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_F");
    check_field_offset(lv, v3, 2, "aSf_BFu8s_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_F(Test_aSf_BFu8s_F, "aSf_BFu8s_F", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_I()
{
  {
    init_simple_test("aSf_BFu8s_I");
    static aSf_BFu8s_I lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_I");
    check_field_offset(lv, v3, 2, "aSf_BFu8s_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_I(Test_aSf_BFu8s_I, "aSf_BFu8s_I", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_Ip()
{
  {
    init_simple_test("aSf_BFu8s_Ip");
    static aSf_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu8s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_Ip");
    check_field_offset(lv, v3, 2, "aSf_BFu8s_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_Ip(Test_aSf_BFu8s_Ip, "aSf_BFu8s_Ip", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_L()
{
  {
    init_simple_test("aSf_BFu8s_L");
    static aSf_BFu8s_L lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu8s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_L");
    check_field_offset(lv, v3, 2, "aSf_BFu8s_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_L(Test_aSf_BFu8s_L, "aSf_BFu8s_L", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_S()
{
  {
    init_simple_test("aSf_BFu8s_S");
    static aSf_BFu8s_S lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_S");
    check_field_offset(lv, v3, 2, "aSf_BFu8s_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_S(Test_aSf_BFu8s_S, "aSf_BFu8s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_Sf()
{
  {
    init_simple_test("aSf_BFu8s_Sf");
    static aSf_BFu8s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "aSf_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_Sf(Test_aSf_BFu8s_Sf, "aSf_BFu8s_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_Uc()
{
  {
    init_simple_test("aSf_BFu8s_Uc");
    static aSf_BFu8s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu8s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_Uc");
    check_field_offset(lv, v3, 2, "aSf_BFu8s_Uc.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_Uc(Test_aSf_BFu8s_Uc, "aSf_BFu8s_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_Ui()
{
  {
    init_simple_test("aSf_BFu8s_Ui");
    static aSf_BFu8s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu8s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_Ui");
    check_field_offset(lv, v3, 2, "aSf_BFu8s_Ui.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_Ui(Test_aSf_BFu8s_Ui, "aSf_BFu8s_Ui", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_Ul()
{
  {
    init_simple_test("aSf_BFu8s_Ul");
    static aSf_BFu8s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aSf_BFu8s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_Ul");
    check_field_offset(lv, v3, 2, "aSf_BFu8s_Ul.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_Ul(Test_aSf_BFu8s_Ul, "aSf_BFu8s_Ul", 10);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_Us()
{
  {
    init_simple_test("aSf_BFu8s_Us");
    static aSf_BFu8s_Us lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu8s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_Us");
    check_field_offset(lv, v3, 2, "aSf_BFu8s_Us.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_Us(Test_aSf_BFu8s_Us, "aSf_BFu8s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu8s_Vp()
{
  {
    init_simple_test("aSf_BFu8s_Vp");
    static aSf_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aSf_BFu8s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aSf_BFu8s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_Vp");
    check_field_offset(lv, v3, 2, "aSf_BFu8s_Vp.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu8s_Vp(Test_aSf_BFu8s_Vp, "aSf_BFu8s_Vp", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i()
{
  {
    init_simple_test("aSf_BFu9i");
    static aSf_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i(Test_aSf_BFu9i, "aSf_BFu9i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu15i()
{
  {
    init_simple_test("aSf_BFu9i_BFu15i");
    static aSf_BFu9i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu9i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aSf_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aSf_BFu9i_BFu15i");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu15i(Test_aSf_BFu9i_BFu15i, "aSf_BFu9i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu15ll()
{
  {
    init_simple_test("aSf_BFu9i_BFu15ll");
    static aSf_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu9i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aSf_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aSf_BFu9i_BFu15ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu15ll(Test_aSf_BFu9i_BFu15ll, "aSf_BFu9i_BFu15ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu15s()
{
  {
    init_simple_test("aSf_BFu9i_BFu15s");
    static aSf_BFu9i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu9i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aSf_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aSf_BFu9i_BFu15s");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu15s(Test_aSf_BFu9i_BFu15s, "aSf_BFu9i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu16i()
{
  {
    init_simple_test("aSf_BFu9i_BFu16i");
    static aSf_BFu9i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu9i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aSf_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aSf_BFu9i_BFu16i");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu16i(Test_aSf_BFu9i_BFu16i, "aSf_BFu9i_BFu16i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu16ll()
{
  {
    init_simple_test("aSf_BFu9i_BFu16ll");
    static aSf_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu9i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aSf_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aSf_BFu9i_BFu16ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu16ll(Test_aSf_BFu9i_BFu16ll, "aSf_BFu9i_BFu16ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu16s()
{
  {
    init_simple_test("aSf_BFu9i_BFu16s");
    static aSf_BFu9i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu9i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aSf_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aSf_BFu9i_BFu16s");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu16s(Test_aSf_BFu9i_BFu16s, "aSf_BFu9i_BFu16s", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu17i()
{
  {
    init_simple_test("aSf_BFu9i_BFu17i");
    static aSf_BFu9i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu9i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aSf_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aSf_BFu9i_BFu17i");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu17i(Test_aSf_BFu9i_BFu17i, "aSf_BFu9i_BFu17i", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu17ll()
{
  {
    init_simple_test("aSf_BFu9i_BFu17ll");
    static aSf_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu9i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aSf_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aSf_BFu9i_BFu17ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu17ll(Test_aSf_BFu9i_BFu17ll, "aSf_BFu9i_BFu17ll", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu1c()
{
  {
    init_simple_test("aSf_BFu9i_BFu1c");
    static aSf_BFu9i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu9i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aSf_BFu9i_BFu1c");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu1c(Test_aSf_BFu9i_BFu1c, "aSf_BFu9i_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu1i()
{
  {
    init_simple_test("aSf_BFu9i_BFu1i");
    static aSf_BFu9i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu9i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aSf_BFu9i_BFu1i");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu1i(Test_aSf_BFu9i_BFu1i, "aSf_BFu9i_BFu1i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu1ll()
{
  {
    init_simple_test("aSf_BFu9i_BFu1ll");
    static aSf_BFu9i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu9i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aSf_BFu9i_BFu1ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu1ll(Test_aSf_BFu9i_BFu1ll, "aSf_BFu9i_BFu1ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu1s()
{
  {
    init_simple_test("aSf_BFu9i_BFu1s");
    static aSf_BFu9i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu9i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aSf_BFu9i_BFu1s");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu1s(Test_aSf_BFu9i_BFu1s, "aSf_BFu9i_BFu1s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu31i()
{
  {
    init_simple_test("aSf_BFu9i_BFu31i");
    static aSf_BFu9i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu9i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aSf_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aSf_BFu9i_BFu31i");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu31i(Test_aSf_BFu9i_BFu31i, "aSf_BFu9i_BFu31i", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu31ll()
{
  {
    init_simple_test("aSf_BFu9i_BFu31ll");
    static aSf_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aSf_BFu9i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aSf_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aSf_BFu9i_BFu31ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu31ll(Test_aSf_BFu9i_BFu31ll, "aSf_BFu9i_BFu31ll", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu32i()
{
  {
    init_simple_test("aSf_BFu9i_BFu32i");
    static aSf_BFu9i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu9i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aSf_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aSf_BFu9i_BFu32i");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu32i(Test_aSf_BFu9i_BFu32i, "aSf_BFu9i_BFu32i", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu32ll()
{
  {
    init_simple_test("aSf_BFu9i_BFu32ll");
    static aSf_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu9i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aSf_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aSf_BFu9i_BFu32ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu32ll(Test_aSf_BFu9i_BFu32ll, "aSf_BFu9i_BFu32ll", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu33()
{
  {
    init_simple_test("aSf_BFu9i_BFu33");
    static aSf_BFu9i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu9i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "aSf_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "aSf_BFu9i_BFu33");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu33(Test_aSf_BFu9i_BFu33, "aSf_BFu9i_BFu33", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu7c()
{
  {
    init_simple_test("aSf_BFu9i_BFu7c");
    static aSf_BFu9i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu9i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aSf_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aSf_BFu9i_BFu7c");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu7c(Test_aSf_BFu9i_BFu7c, "aSf_BFu9i_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu7i()
{
  {
    init_simple_test("aSf_BFu9i_BFu7i");
    static aSf_BFu9i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu9i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aSf_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aSf_BFu9i_BFu7i");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu7i(Test_aSf_BFu9i_BFu7i, "aSf_BFu9i_BFu7i", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu7ll()
{
  {
    init_simple_test("aSf_BFu9i_BFu7ll");
    static aSf_BFu9i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu9i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aSf_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aSf_BFu9i_BFu7ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu7ll(Test_aSf_BFu9i_BFu7ll, "aSf_BFu9i_BFu7ll", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu7s()
{
  {
    init_simple_test("aSf_BFu9i_BFu7s");
    static aSf_BFu9i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu9i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aSf_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aSf_BFu9i_BFu7s");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu7s(Test_aSf_BFu9i_BFu7s, "aSf_BFu9i_BFu7s", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu8c()
{
  {
    init_simple_test("aSf_BFu9i_BFu8c");
    static aSf_BFu9i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu9i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aSf_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aSf_BFu9i_BFu8c");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu8c(Test_aSf_BFu9i_BFu8c, "aSf_BFu9i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu8i()
{
  {
    init_simple_test("aSf_BFu9i_BFu8i");
    static aSf_BFu9i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu9i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aSf_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aSf_BFu9i_BFu8i");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu8i(Test_aSf_BFu9i_BFu8i, "aSf_BFu9i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu8ll()
{
  {
    init_simple_test("aSf_BFu9i_BFu8ll");
    static aSf_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu9i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aSf_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aSf_BFu9i_BFu8ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu8ll(Test_aSf_BFu9i_BFu8ll, "aSf_BFu9i_BFu8ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu8s()
{
  {
    init_simple_test("aSf_BFu9i_BFu8s");
    static aSf_BFu9i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu9i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aSf_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aSf_BFu9i_BFu8s");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu8s(Test_aSf_BFu9i_BFu8s, "aSf_BFu9i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu9i()
{
  {
    init_simple_test("aSf_BFu9i_BFu9i");
    static aSf_BFu9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu9i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aSf_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu9i");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu9i(Test_aSf_BFu9i_BFu9i, "aSf_BFu9i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu9ll()
{
  {
    init_simple_test("aSf_BFu9i_BFu9ll");
    static aSf_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu9i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aSf_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu9ll");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu9ll(Test_aSf_BFu9i_BFu9ll, "aSf_BFu9i_BFu9ll", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_BFu9s()
{
  {
    init_simple_test("aSf_BFu9i_BFu9s");
    static aSf_BFu9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu9i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aSf_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu9s");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_BFu9s(Test_aSf_BFu9i_BFu9s, "aSf_BFu9i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_C()
{
  {
    init_simple_test("aSf_BFu9i_C");
    static aSf_BFu9i_C lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu9i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_C");
    check_field_offset(lv, v3, 3, "aSf_BFu9i_C.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_C(Test_aSf_BFu9i_C, "aSf_BFu9i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_D()
{
  {
    init_simple_test("aSf_BFu9i_D");
    static aSf_BFu9i_D lv;
    check2(sizeof(lv), 11, "sizeof(aSf_BFu9i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_D");
    check_field_offset(lv, v3, 3, "aSf_BFu9i_D.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_D(Test_aSf_BFu9i_D, "aSf_BFu9i_D", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_F()
{
  {
    init_simple_test("aSf_BFu9i_F");
    static aSf_BFu9i_F lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu9i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_F");
    check_field_offset(lv, v3, 3, "aSf_BFu9i_F.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_F(Test_aSf_BFu9i_F, "aSf_BFu9i_F", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_I()
{
  {
    init_simple_test("aSf_BFu9i_I");
    static aSf_BFu9i_I lv;
    check2(sizeof(lv), 7, "sizeof(aSf_BFu9i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_I");
    check_field_offset(lv, v3, 3, "aSf_BFu9i_I.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_I(Test_aSf_BFu9i_I, "aSf_BFu9i_I", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_Ip()
{
  {
    init_simple_test("aSf_BFu9i_Ip");
    static aSf_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aSf_BFu9i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_Ip");
    check_field_offset(lv, v3, 3, "aSf_BFu9i_Ip.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_Ip(Test_aSf_BFu9i_Ip, "aSf_BFu9i_Ip", ABISELECT(11,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_L()
{
  {
    init_simple_test("aSf_BFu9i_L");
    static aSf_BFu9i_L lv;
    check2(sizeof(lv), 11, "sizeof(aSf_BFu9i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_L");
    check_field_offset(lv, v3, 3, "aSf_BFu9i_L.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_L(Test_aSf_BFu9i_L, "aSf_BFu9i_L", 11);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_S()
{
  {
    init_simple_test("aSf_BFu9i_S");
    static aSf_BFu9i_S lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu9i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_S");
    check_field_offset(lv, v3, 3, "aSf_BFu9i_S.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_S(Test_aSf_BFu9i_S, "aSf_BFu9i_S", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_Sf()
{
  {
    init_simple_test("aSf_BFu9i_Sf");
    static aSf_BFu9i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aSf_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_Sf");
    check_field_offset(lv, v3, 3, "aSf_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vaSf_BFu9i_Sf(Test_aSf_BFu9i_Sf, "aSf_BFu9i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus


static void Test_aSf_BFu9i_Uc()
{
  {
    init_simple_test("aSf_BFu9i_Uc");
    static aSf_BFu9i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu9i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_Uc)");