// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
#include "testsuite.h"
struct __attribute__((packed)) aBFu0s_C_BFu7ll { unsigned short :0; char v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_C_BFu7s { unsigned short :0; char v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_C_BFu8c { unsigned short :0; char v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_C_BFu8i { unsigned short :0; char v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_C_BFu8ll { unsigned short :0; char v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_C_BFu8s { unsigned short :0; char v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_C_BFu9i { unsigned short :0; char v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_C_BFu9ll { unsigned short :0; char v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_C_BFu9s { unsigned short :0; char v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_C_C { unsigned short :0; char v1; char v2; };
struct __attribute__((packed)) aBFu0s_C_D { unsigned short :0; char v1; double v2; };
struct __attribute__((packed)) aBFu0s_C_F { unsigned short :0; char v1; float v2; };
struct __attribute__((packed)) aBFu0s_C_I { unsigned short :0; char v1; int v2; };
struct __attribute__((packed)) aBFu0s_C_Ip { unsigned short :0; char v1; int * v2; };
struct __attribute__((packed)) aBFu0s_C_L { unsigned short :0; char v1; long long v2; };
struct __attribute__((packed)) aBFu0s_C_S { unsigned short :0; char v1; short v2; };
struct __attribute__((packed)) aBFu0s_C_Uc { unsigned short :0; char v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_C_Ui { unsigned short :0; char v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_C_Ul { unsigned short :0; char v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_C_Us { unsigned short :0; char v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_C_Vp { unsigned short :0; char v1; void * v2; };
struct __attribute__((packed)) aBFu0s_D { unsigned short :0; double v1; };
struct __attribute__((packed)) aBFu0s_D_BFu0c { unsigned short :0; double v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0s_D_BFu0i { unsigned short :0; double v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0s_D_BFu0ll { unsigned short :0; double v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0s_D_BFu0s { unsigned short :0; double v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0s_D_BFu15i { unsigned short :0; double v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0s_D_BFu15ll { unsigned short :0; double v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0s_D_BFu15s { unsigned short :0; double v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0s_D_BFu16i { unsigned short :0; double v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0s_D_BFu16ll { unsigned short :0; double v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0s_D_BFu16s { unsigned short :0; double v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0s_D_BFu17i { unsigned short :0; double v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0s_D_BFu17ll { unsigned short :0; double v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0s_D_BFu1c { unsigned short :0; double v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0s_D_BFu1i { unsigned short :0; double v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0s_D_BFu1ll { unsigned short :0; double v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0s_D_BFu1s { unsigned short :0; double v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0s_D_BFu31i { unsigned short :0; double v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0s_D_BFu31ll { unsigned short :0; double v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0s_D_BFu32i { unsigned short :0; double v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0s_D_BFu32ll { unsigned short :0; double v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0s_D_BFu33 { unsigned short :0; double v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0s_D_BFu7c { unsigned short :0; double v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0s_D_BFu7i { unsigned short :0; double v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0s_D_BFu7ll { unsigned short :0; double v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_D_BFu7s { unsigned short :0; double v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_D_BFu8c { unsigned short :0; double v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_D_BFu8i { unsigned short :0; double v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_D_BFu8ll { unsigned short :0; double v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_D_BFu8s { unsigned short :0; double v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_D_BFu9i { unsigned short :0; double v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_D_BFu9ll { unsigned short :0; double v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_D_BFu9s { unsigned short :0; double v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_D_C { unsigned short :0; double v1; char v2; };
struct __attribute__((packed)) aBFu0s_D_D { unsigned short :0; double v1; double v2; };
struct __attribute__((packed)) aBFu0s_D_F { unsigned short :0; double v1; float v2; };
struct __attribute__((packed)) aBFu0s_D_I { unsigned short :0; double v1; int v2; };
struct __attribute__((packed)) aBFu0s_D_Ip { unsigned short :0; double v1; int * v2; };
struct __attribute__((packed)) aBFu0s_D_L { unsigned short :0; double v1; long long v2; };
struct __attribute__((packed)) aBFu0s_D_S { unsigned short :0; double v1; short v2; };
struct __attribute__((packed)) aBFu0s_D_Uc { unsigned short :0; double v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_D_Ui { unsigned short :0; double v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_D_Ul { unsigned short :0; double v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_D_Us { unsigned short :0; double v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_D_Vp { unsigned short :0; double v1; void * v2; };
struct __attribute__((packed)) aBFu0s_F { unsigned short :0; float v1; };
struct __attribute__((packed)) aBFu0s_F_BFu0c { unsigned short :0; float v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0s_F_BFu0i { unsigned short :0; float v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0s_F_BFu0ll { unsigned short :0; float v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0s_F_BFu0s { unsigned short :0; float v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0s_F_BFu15i { unsigned short :0; float v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0s_F_BFu15ll { unsigned short :0; float v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0s_F_BFu15s { unsigned short :0; float v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0s_F_BFu16i { unsigned short :0; float v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0s_F_BFu16ll { unsigned short :0; float v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0s_F_BFu16s { unsigned short :0; float v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0s_F_BFu17i { unsigned short :0; float v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0s_F_BFu17ll { unsigned short :0; float v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0s_F_BFu1c { unsigned short :0; float v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0s_F_BFu1i { unsigned short :0; float v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0s_F_BFu1ll { unsigned short :0; float v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0s_F_BFu1s { unsigned short :0; float v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0s_F_BFu31i { unsigned short :0; float v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0s_F_BFu31ll { unsigned short :0; float v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0s_F_BFu32i { unsigned short :0; float v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0s_F_BFu32ll { unsigned short :0; float v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0s_F_BFu33 { unsigned short :0; float v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0s_F_BFu7c { unsigned short :0; float v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0s_F_BFu7i { unsigned short :0; float v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0s_F_BFu7ll { unsigned short :0; float v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_F_BFu7s { unsigned short :0; float v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_F_BFu8c { unsigned short :0; float v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_F_BFu8i { unsigned short :0; float v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_F_BFu8ll { unsigned short :0; float v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_F_BFu8s { unsigned short :0; float v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_F_BFu9i { unsigned short :0; float v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_F_BFu9ll { unsigned short :0; float v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_F_BFu9s { unsigned short :0; float v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_F_C { unsigned short :0; float v1; char v2; };
struct __attribute__((packed)) aBFu0s_F_D { unsigned short :0; float v1; double v2; };
struct __attribute__((packed)) aBFu0s_F_F { unsigned short :0; float v1; float v2; };
struct __attribute__((packed)) aBFu0s_F_I { unsigned short :0; float v1; int v2; };
struct __attribute__((packed)) aBFu0s_F_Ip { unsigned short :0; float v1; int * v2; };
struct __attribute__((packed)) aBFu0s_F_L { unsigned short :0; float v1; long long v2; };
struct __attribute__((packed)) aBFu0s_F_S { unsigned short :0; float v1; short v2; };
struct __attribute__((packed)) aBFu0s_F_Uc { unsigned short :0; float v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_F_Ui { unsigned short :0; float v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_F_Ul { unsigned short :0; float v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_F_Us { unsigned short :0; float v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_F_Vp { unsigned short :0; float v1; void * v2; };
struct __attribute__((packed)) aBFu0s_I { unsigned short :0; int v1; };
struct __attribute__((packed)) aBFu0s_I_BFu0c { unsigned short :0; int v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0s_I_BFu0i { unsigned short :0; int v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0s_I_BFu0ll { unsigned short :0; int v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0s_I_BFu0s { unsigned short :0; int v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0s_I_BFu15i { unsigned short :0; int v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0s_I_BFu15ll { unsigned short :0; int v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0s_I_BFu15s { unsigned short :0; int v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0s_I_BFu16i { unsigned short :0; int v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0s_I_BFu16ll { unsigned short :0; int v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0s_I_BFu16s { unsigned short :0; int v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0s_I_BFu17i { unsigned short :0; int v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0s_I_BFu17ll { unsigned short :0; int v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0s_I_BFu1c { unsigned short :0; int v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0s_I_BFu1i { unsigned short :0; int v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0s_I_BFu1ll { unsigned short :0; int v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0s_I_BFu1s { unsigned short :0; int v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0s_I_BFu31i { unsigned short :0; int v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0s_I_BFu31ll { unsigned short :0; int v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0s_I_BFu32i { unsigned short :0; int v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0s_I_BFu32ll { unsigned short :0; int v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0s_I_BFu33 { unsigned short :0; int v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0s_I_BFu7c { unsigned short :0; int v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0s_I_BFu7i { unsigned short :0; int v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0s_I_BFu7ll { unsigned short :0; int v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_I_BFu7s { unsigned short :0; int v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_I_BFu8c { unsigned short :0; int v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_I_BFu8i { unsigned short :0; int v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_I_BFu8ll { unsigned short :0; int v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_I_BFu8s { unsigned short :0; int v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_I_BFu9i { unsigned short :0; int v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_I_BFu9ll { unsigned short :0; int v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_I_BFu9s { unsigned short :0; int v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_I_C { unsigned short :0; int v1; char v2; };
struct __attribute__((packed)) aBFu0s_I_D { unsigned short :0; int v1; double v2; };
struct __attribute__((packed)) aBFu0s_I_F { unsigned short :0; int v1; float v2; };
struct __attribute__((packed)) aBFu0s_I_I { unsigned short :0; int v1; int v2; };
struct __attribute__((packed)) aBFu0s_I_Ip { unsigned short :0; int v1; int * v2; };
struct __attribute__((packed)) aBFu0s_I_L { unsigned short :0; int v1; long long v2; };
struct __attribute__((packed)) aBFu0s_I_S { unsigned short :0; int v1; short v2; };
struct __attribute__((packed)) aBFu0s_I_Uc { unsigned short :0; int v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_I_Ui { unsigned short :0; int v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_I_Ul { unsigned short :0; int v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_I_Us { unsigned short :0; int v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_I_Vp { unsigned short :0; int v1; void * v2; };
struct __attribute__((packed)) aBFu0s_Ip { unsigned short :0; int * v1; };
struct __attribute__((packed)) aBFu0s_Ip_BFu0c { unsigned short :0; int * v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0s_Ip_BFu0i { unsigned short :0; int * v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0s_Ip_BFu0ll { unsigned short :0; int * v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0s_Ip_BFu0s { unsigned short :0; int * v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0s_Ip_BFu15i { unsigned short :0; int * v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0s_Ip_BFu15ll { unsigned short :0; int * v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0s_Ip_BFu15s { unsigned short :0; int * v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0s_Ip_BFu16i { unsigned short :0; int * v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0s_Ip_BFu16ll { unsigned short :0; int * v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0s_Ip_BFu16s { unsigned short :0; int * v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0s_Ip_BFu17i { unsigned short :0; int * v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0s_Ip_BFu17ll { unsigned short :0; int * v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0s_Ip_BFu1c { unsigned short :0; int * v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0s_Ip_BFu1i { unsigned short :0; int * v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0s_Ip_BFu1ll { unsigned short :0; int * v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0s_Ip_BFu1s { unsigned short :0; int * v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0s_Ip_BFu31i { unsigned short :0; int * v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0s_Ip_BFu31ll { unsigned short :0; int * v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0s_Ip_BFu32i { unsigned short :0; int * v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0s_Ip_BFu32ll { unsigned short :0; int * v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0s_Ip_BFu33 { unsigned short :0; int * v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0s_Ip_BFu7c { unsigned short :0; int * v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0s_Ip_BFu7i { unsigned short :0; int * v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0s_Ip_BFu7ll { unsigned short :0; int * v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_Ip_BFu7s { unsigned short :0; int * v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_Ip_BFu8c { unsigned short :0; int * v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_Ip_BFu8i { unsigned short :0; int * v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_Ip_BFu8ll { unsigned short :0; int * v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_Ip_BFu8s { unsigned short :0; int * v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_Ip_BFu9i { unsigned short :0; int * v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_Ip_BFu9ll { unsigned short :0; int * v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_Ip_BFu9s { unsigned short :0; int * v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_Ip_C { unsigned short :0; int * v1; char v2; };
struct __attribute__((packed)) aBFu0s_Ip_D { unsigned short :0; int * v1; double v2; };
struct __attribute__((packed)) aBFu0s_Ip_F { unsigned short :0; int * v1; float v2; };
struct __attribute__((packed)) aBFu0s_Ip_I { unsigned short :0; int * v1; int v2; };
struct __attribute__((packed)) aBFu0s_Ip_Ip { unsigned short :0; int * v1; int * v2; };
struct __attribute__((packed)) aBFu0s_Ip_L { unsigned short :0; int * v1; long long v2; };
struct __attribute__((packed)) aBFu0s_Ip_S { unsigned short :0; int * v1; short v2; };
struct __attribute__((packed)) aBFu0s_Ip_Uc { unsigned short :0; int * v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_Ip_Ui { unsigned short :0; int * v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_Ip_Ul { unsigned short :0; int * v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_Ip_Us { unsigned short :0; int * v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_Ip_Vp { unsigned short :0; int * v1; void * v2; };
struct __attribute__((packed)) aBFu0s_L { unsigned short :0; long long v1; };
struct __attribute__((packed)) aBFu0s_L_BFu0c { unsigned short :0; long long v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0s_L_BFu0i { unsigned short :0; long long v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0s_L_BFu0ll { unsigned short :0; long long v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0s_L_BFu0s { unsigned short :0; long long v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0s_L_BFu15i { unsigned short :0; long long v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0s_L_BFu15ll { unsigned short :0; long long v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0s_L_BFu15s { unsigned short :0; long long v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0s_L_BFu16i { unsigned short :0; long long v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0s_L_BFu16ll { unsigned short :0; long long v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0s_L_BFu16s { unsigned short :0; long long v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0s_L_BFu17i { unsigned short :0; long long v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0s_L_BFu17ll { unsigned short :0; long long v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0s_L_BFu1c { unsigned short :0; long long v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0s_L_BFu1i { unsigned short :0; long long v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0s_L_BFu1ll { unsigned short :0; long long v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0s_L_BFu1s { unsigned short :0; long long v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0s_L_BFu31i { unsigned short :0; long long v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0s_L_BFu31ll { unsigned short :0; long long v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0s_L_BFu32i { unsigned short :0; long long v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0s_L_BFu32ll { unsigned short :0; long long v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0s_L_BFu33 { unsigned short :0; long long v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0s_L_BFu7c { unsigned short :0; long long v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0s_L_BFu7i { unsigned short :0; long long v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0s_L_BFu7ll { unsigned short :0; long long v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_L_BFu7s { unsigned short :0; long long v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_L_BFu8c { unsigned short :0; long long v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_L_BFu8i { unsigned short :0; long long v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_L_BFu8ll { unsigned short :0; long long v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_L_BFu8s { unsigned short :0; long long v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_L_BFu9i { unsigned short :0; long long v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_L_BFu9ll { unsigned short :0; long long v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_L_BFu9s { unsigned short :0; long long v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_L_C { unsigned short :0; long long v1; char v2; };
struct __attribute__((packed)) aBFu0s_L_D { unsigned short :0; long long v1; double v2; };
struct __attribute__((packed)) aBFu0s_L_F { unsigned short :0; long long v1; float v2; };
struct __attribute__((packed)) aBFu0s_L_I { unsigned short :0; long long v1; int v2; };
struct __attribute__((packed)) aBFu0s_L_Ip { unsigned short :0; long long v1; int * v2; };
struct __attribute__((packed)) aBFu0s_L_L { unsigned short :0; long long v1; long long v2; };
struct __attribute__((packed)) aBFu0s_L_S { unsigned short :0; long long v1; short v2; };
struct __attribute__((packed)) aBFu0s_L_Uc { unsigned short :0; long long v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_L_Ui { unsigned short :0; long long v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_L_Ul { unsigned short :0; long long v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_L_Us { unsigned short :0; long long v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_L_Vp { unsigned short :0; long long v1; void * v2; };
struct __attribute__((packed)) aBFu0s_S { unsigned short :0; short v1; };
struct __attribute__((packed)) aBFu0s_S_BFu0c { unsigned short :0; short v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0s_S_BFu0i { unsigned short :0; short v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0s_S_BFu0ll { unsigned short :0; short v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0s_S_BFu0s { unsigned short :0; short v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0s_S_BFu15i { unsigned short :0; short v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0s_S_BFu15ll { unsigned short :0; short v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0s_S_BFu15s { unsigned short :0; short v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0s_S_BFu16i { unsigned short :0; short v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0s_S_BFu16ll { unsigned short :0; short v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0s_S_BFu16s { unsigned short :0; short v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0s_S_BFu17i { unsigned short :0; short v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0s_S_BFu17ll { unsigned short :0; short v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0s_S_BFu1c { unsigned short :0; short v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0s_S_BFu1i { unsigned short :0; short v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0s_S_BFu1ll { unsigned short :0; short v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0s_S_BFu1s { unsigned short :0; short v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0s_S_BFu31i { unsigned short :0; short v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0s_S_BFu31ll { unsigned short :0; short v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0s_S_BFu32i { unsigned short :0; short v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0s_S_BFu32ll { unsigned short :0; short v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0s_S_BFu33 { unsigned short :0; short v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0s_S_BFu7c { unsigned short :0; short v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0s_S_BFu7i { unsigned short :0; short v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0s_S_BFu7ll { unsigned short :0; short v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_S_BFu7s { unsigned short :0; short v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_S_BFu8c { unsigned short :0; short v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_S_BFu8i { unsigned short :0; short v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_S_BFu8ll { unsigned short :0; short v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_S_BFu8s { unsigned short :0; short v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_S_BFu9i { unsigned short :0; short v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_S_BFu9ll { unsigned short :0; short v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_S_BFu9s { unsigned short :0; short v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_S_C { unsigned short :0; short v1; char v2; };
struct __attribute__((packed)) aBFu0s_S_D { unsigned short :0; short v1; double v2; };
struct __attribute__((packed)) aBFu0s_S_F { unsigned short :0; short v1; float v2; };
struct __attribute__((packed)) aBFu0s_S_I { unsigned short :0; short v1; int v2; };
struct __attribute__((packed)) aBFu0s_S_Ip { unsigned short :0; short v1; int * v2; };
struct __attribute__((packed)) aBFu0s_S_L { unsigned short :0; short v1; long long v2; };
struct __attribute__((packed)) aBFu0s_S_S { unsigned short :0; short v1; short v2; };
struct __attribute__((packed)) aBFu0s_S_Uc { unsigned short :0; short v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_S_Ui { unsigned short :0; short v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_S_Ul { unsigned short :0; short v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_S_Us { unsigned short :0; short v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_S_Vp { unsigned short :0; short v1; void * v2; };
struct __attribute__((packed)) aBFu0s_Uc { unsigned short :0; unsigned char v1; };
struct __attribute__((packed)) aBFu0s_Uc_BFu0c { unsigned short :0; unsigned char v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0s_Uc_BFu0i { unsigned short :0; unsigned char v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0s_Uc_BFu0ll { unsigned short :0; unsigned char v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0s_Uc_BFu0s { unsigned short :0; unsigned char v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0s_Uc_BFu15i { unsigned short :0; unsigned char v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0s_Uc_BFu15ll { unsigned short :0; unsigned char v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0s_Uc_BFu15s { unsigned short :0; unsigned char v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0s_Uc_BFu16i { unsigned short :0; unsigned char v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0s_Uc_BFu16ll { unsigned short :0; unsigned char v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0s_Uc_BFu16s { unsigned short :0; unsigned char v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0s_Uc_BFu17i { unsigned short :0; unsigned char v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0s_Uc_BFu17ll { unsigned short :0; unsigned char v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0s_Uc_BFu1c { unsigned short :0; unsigned char v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0s_Uc_BFu1i { unsigned short :0; unsigned char v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0s_Uc_BFu1ll { unsigned short :0; unsigned char v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0s_Uc_BFu1s { unsigned short :0; unsigned char v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0s_Uc_BFu31i { unsigned short :0; unsigned char v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0s_Uc_BFu31ll { unsigned short :0; unsigned char v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0s_Uc_BFu32i { unsigned short :0; unsigned char v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0s_Uc_BFu32ll { unsigned short :0; unsigned char v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0s_Uc_BFu33 { unsigned short :0; unsigned char v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0s_Uc_BFu7c { unsigned short :0; unsigned char v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0s_Uc_BFu7i { unsigned short :0; unsigned char v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0s_Uc_BFu7ll { unsigned short :0; unsigned char v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_Uc_BFu7s { unsigned short :0; unsigned char v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_Uc_BFu8c { unsigned short :0; unsigned char v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_Uc_BFu8i { unsigned short :0; unsigned char v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_Uc_BFu8ll { unsigned short :0; unsigned char v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_Uc_BFu8s { unsigned short :0; unsigned char v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_Uc_BFu9i { unsigned short :0; unsigned char v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_Uc_BFu9ll { unsigned short :0; unsigned char v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_Uc_BFu9s { unsigned short :0; unsigned char v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_Uc_C { unsigned short :0; unsigned char v1; char v2; };
struct __attribute__((packed)) aBFu0s_Uc_D { unsigned short :0; unsigned char v1; double v2; };
struct __attribute__((packed)) aBFu0s_Uc_F { unsigned short :0; unsigned char v1; float v2; };
struct __attribute__((packed)) aBFu0s_Uc_I { unsigned short :0; unsigned char v1; int v2; };
struct __attribute__((packed)) aBFu0s_Uc_Ip { unsigned short :0; unsigned char v1; int * v2; };
struct __attribute__((packed)) aBFu0s_Uc_L { unsigned short :0; unsigned char v1; long long v2; };
struct __attribute__((packed)) aBFu0s_Uc_S { unsigned short :0; unsigned char v1; short v2; };
struct __attribute__((packed)) aBFu0s_Uc_Uc { unsigned short :0; unsigned char v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_Uc_Ui { unsigned short :0; unsigned char v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_Uc_Ul { unsigned short :0; unsigned char v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_Uc_Us { unsigned short :0; unsigned char v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_Uc_Vp { unsigned short :0; unsigned char v1; void * v2; };
struct __attribute__((packed)) aBFu0s_Ui { unsigned short :0; unsigned int v1; };
struct __attribute__((packed)) aBFu0s_Ui_BFu0c { unsigned short :0; unsigned int v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0s_Ui_BFu0i { unsigned short :0; unsigned int v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0s_Ui_BFu0ll { unsigned short :0; unsigned int v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0s_Ui_BFu0s { unsigned short :0; unsigned int v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0s_Ui_BFu15i { unsigned short :0; unsigned int v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0s_Ui_BFu15ll { unsigned short :0; unsigned int v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0s_Ui_BFu15s { unsigned short :0; unsigned int v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0s_Ui_BFu16i { unsigned short :0; unsigned int v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0s_Ui_BFu16ll { unsigned short :0; unsigned int v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0s_Ui_BFu16s { unsigned short :0; unsigned int v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0s_Ui_BFu17i { unsigned short :0; unsigned int v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0s_Ui_BFu17ll { unsigned short :0; unsigned int v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0s_Ui_BFu1c { unsigned short :0; unsigned int v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0s_Ui_BFu1i { unsigned short :0; unsigned int v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0s_Ui_BFu1ll { unsigned short :0; unsigned int v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0s_Ui_BFu1s { unsigned short :0; unsigned int v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0s_Ui_BFu31i { unsigned short :0; unsigned int v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0s_Ui_BFu31ll { unsigned short :0; unsigned int v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0s_Ui_BFu32i { unsigned short :0; unsigned int v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0s_Ui_BFu32ll { unsigned short :0; unsigned int v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0s_Ui_BFu33 { unsigned short :0; unsigned int v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0s_Ui_BFu7c { unsigned short :0; unsigned int v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0s_Ui_BFu7i { unsigned short :0; unsigned int v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0s_Ui_BFu7ll { unsigned short :0; unsigned int v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_Ui_BFu7s { unsigned short :0; unsigned int v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_Ui_BFu8c { unsigned short :0; unsigned int v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_Ui_BFu8i { unsigned short :0; unsigned int v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_Ui_BFu8ll { unsigned short :0; unsigned int v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_Ui_BFu8s { unsigned short :0; unsigned int v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_Ui_BFu9i { unsigned short :0; unsigned int v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_Ui_BFu9ll { unsigned short :0; unsigned int v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_Ui_BFu9s { unsigned short :0; unsigned int v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_Ui_C { unsigned short :0; unsigned int v1; char v2; };
struct __attribute__((packed)) aBFu0s_Ui_D { unsigned short :0; unsigned int v1; double v2; };
struct __attribute__((packed)) aBFu0s_Ui_F { unsigned short :0; unsigned int v1; float v2; };
struct __attribute__((packed)) aBFu0s_Ui_I { unsigned short :0; unsigned int v1; int v2; };
struct __attribute__((packed)) aBFu0s_Ui_Ip { unsigned short :0; unsigned int v1; int * v2; };
struct __attribute__((packed)) aBFu0s_Ui_L { unsigned short :0; unsigned int v1; long long v2; };
struct __attribute__((packed)) aBFu0s_Ui_S { unsigned short :0; unsigned int v1; short v2; };
struct __attribute__((packed)) aBFu0s_Ui_Uc { unsigned short :0; unsigned int v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_Ui_Ui { unsigned short :0; unsigned int v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_Ui_Ul { unsigned short :0; unsigned int v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_Ui_Us { unsigned short :0; unsigned int v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_Ui_Vp { unsigned short :0; unsigned int v1; void * v2; };
struct __attribute__((packed)) aBFu0s_Ul { unsigned short :0; unsigned long long v1; };
struct __attribute__((packed)) aBFu0s_Ul_BFu0c { unsigned short :0; unsigned long long v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0s_Ul_BFu0i { unsigned short :0; unsigned long long v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0s_Ul_BFu0ll { unsigned short :0; unsigned long long v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0s_Ul_BFu0s { unsigned short :0; unsigned long long v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0s_Ul_BFu15i { unsigned short :0; unsigned long long v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0s_Ul_BFu15ll { unsigned short :0; unsigned long long v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0s_Ul_BFu15s { unsigned short :0; unsigned long long v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0s_Ul_BFu16i { unsigned short :0; unsigned long long v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0s_Ul_BFu16ll { unsigned short :0; unsigned long long v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0s_Ul_BFu16s { unsigned short :0; unsigned long long v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0s_Ul_BFu17i { unsigned short :0; unsigned long long v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0s_Ul_BFu17ll { unsigned short :0; unsigned long long v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0s_Ul_BFu1c { unsigned short :0; unsigned long long v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0s_Ul_BFu1i { unsigned short :0; unsigned long long v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0s_Ul_BFu1ll { unsigned short :0; unsigned long long v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0s_Ul_BFu1s { unsigned short :0; unsigned long long v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0s_Ul_BFu31i { unsigned short :0; unsigned long long v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0s_Ul_BFu31ll { unsigned short :0; unsigned long long v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0s_Ul_BFu32i { unsigned short :0; unsigned long long v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0s_Ul_BFu32ll { unsigned short :0; unsigned long long v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0s_Ul_BFu33 { unsigned short :0; unsigned long long v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0s_Ul_BFu7c { unsigned short :0; unsigned long long v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0s_Ul_BFu7i { unsigned short :0; unsigned long long v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0s_Ul_BFu7ll { unsigned short :0; unsigned long long v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_Ul_BFu7s { unsigned short :0; unsigned long long v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_Ul_BFu8c { unsigned short :0; unsigned long long v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_Ul_BFu8i { unsigned short :0; unsigned long long v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_Ul_BFu8ll { unsigned short :0; unsigned long long v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_Ul_BFu8s { unsigned short :0; unsigned long long v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_Ul_BFu9i { unsigned short :0; unsigned long long v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_Ul_BFu9ll { unsigned short :0; unsigned long long v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_Ul_BFu9s { unsigned short :0; unsigned long long v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_Ul_C { unsigned short :0; unsigned long long v1; char v2; };
struct __attribute__((packed)) aBFu0s_Ul_D { unsigned short :0; unsigned long long v1; double v2; };
struct __attribute__((packed)) aBFu0s_Ul_F { unsigned short :0; unsigned long long v1; float v2; };
struct __attribute__((packed)) aBFu0s_Ul_I { unsigned short :0; unsigned long long v1; int v2; };
struct __attribute__((packed)) aBFu0s_Ul_Ip { unsigned short :0; unsigned long long v1; int * v2; };
struct __attribute__((packed)) aBFu0s_Ul_L { unsigned short :0; unsigned long long v1; long long v2; };
struct __attribute__((packed)) aBFu0s_Ul_S { unsigned short :0; unsigned long long v1; short v2; };
struct __attribute__((packed)) aBFu0s_Ul_Uc { unsigned short :0; unsigned long long v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_Ul_Ui { unsigned short :0; unsigned long long v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_Ul_Ul { unsigned short :0; unsigned long long v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_Ul_Us { unsigned short :0; unsigned long long v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_Ul_Vp { unsigned short :0; unsigned long long v1; void * v2; };
struct __attribute__((packed)) aBFu0s_Us { unsigned short :0; unsigned short v1; };
struct __attribute__((packed)) aBFu0s_Us_BFu0c { unsigned short :0; unsigned short v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0s_Us_BFu0i { unsigned short :0; unsigned short v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0s_Us_BFu0ll { unsigned short :0; unsigned short v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0s_Us_BFu0s { unsigned short :0; unsigned short v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0s_Us_BFu15i { unsigned short :0; unsigned short v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0s_Us_BFu15ll { unsigned short :0; unsigned short v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0s_Us_BFu15s { unsigned short :0; unsigned short v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0s_Us_BFu16i { unsigned short :0; unsigned short v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0s_Us_BFu16ll { unsigned short :0; unsigned short v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0s_Us_BFu16s { unsigned short :0; unsigned short v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0s_Us_BFu17i { unsigned short :0; unsigned short v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0s_Us_BFu17ll { unsigned short :0; unsigned short v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0s_Us_BFu1c { unsigned short :0; unsigned short v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0s_Us_BFu1i { unsigned short :0; unsigned short v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0s_Us_BFu1ll { unsigned short :0; unsigned short v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0s_Us_BFu1s { unsigned short :0; unsigned short v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0s_Us_BFu31i { unsigned short :0; unsigned short v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0s_Us_BFu31ll { unsigned short :0; unsigned short v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0s_Us_BFu32i { unsigned short :0; unsigned short v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0s_Us_BFu32ll { unsigned short :0; unsigned short v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0s_Us_BFu33 { unsigned short :0; unsigned short v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0s_Us_BFu7c { unsigned short :0; unsigned short v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0s_Us_BFu7i { unsigned short :0; unsigned short v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0s_Us_BFu7ll { unsigned short :0; unsigned short v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_Us_BFu7s { unsigned short :0; unsigned short v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_Us_BFu8c { unsigned short :0; unsigned short v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_Us_BFu8i { unsigned short :0; unsigned short v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_Us_BFu8ll { unsigned short :0; unsigned short v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_Us_BFu8s { unsigned short :0; unsigned short v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_Us_BFu9i { unsigned short :0; unsigned short v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_Us_BFu9ll { unsigned short :0; unsigned short v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_Us_BFu9s { unsigned short :0; unsigned short v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_Us_C { unsigned short :0; unsigned short v1; char v2; };
struct __attribute__((packed)) aBFu0s_Us_D { unsigned short :0; unsigned short v1; double v2; };
struct __attribute__((packed)) aBFu0s_Us_F { unsigned short :0; unsigned short v1; float v2; };
struct __attribute__((packed)) aBFu0s_Us_I { unsigned short :0; unsigned short v1; int v2; };
struct __attribute__((packed)) aBFu0s_Us_Ip { unsigned short :0; unsigned short v1; int * v2; };
struct __attribute__((packed)) aBFu0s_Us_L { unsigned short :0; unsigned short v1; long long v2; };
struct __attribute__((packed)) aBFu0s_Us_S { unsigned short :0; unsigned short v1; short v2; };
struct __attribute__((packed)) aBFu0s_Us_Uc { unsigned short :0; unsigned short v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_Us_Ui { unsigned short :0; unsigned short v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_Us_Ul { unsigned short :0; unsigned short v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_Us_Us { unsigned short :0; unsigned short v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_Us_Vp { unsigned short :0; unsigned short v1; void * v2; };
struct __attribute__((packed)) aBFu0s_Vp { unsigned short :0; void * v1; };
struct __attribute__((packed)) aBFu0s_Vp_BFu0c { unsigned short :0; void * v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0s_Vp_BFu0i { unsigned short :0; void * v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0s_Vp_BFu0ll { unsigned short :0; void * v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0s_Vp_BFu0s { unsigned short :0; void * v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0s_Vp_BFu15i { unsigned short :0; void * v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0s_Vp_BFu15ll { unsigned short :0; void * v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0s_Vp_BFu15s { unsigned short :0; void * v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0s_Vp_BFu16i { unsigned short :0; void * v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0s_Vp_BFu16ll { unsigned short :0; void * v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0s_Vp_BFu16s { unsigned short :0; void * v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0s_Vp_BFu17i { unsigned short :0; void * v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0s_Vp_BFu17ll { unsigned short :0; void * v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0s_Vp_BFu1c { unsigned short :0; void * v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0s_Vp_BFu1i { unsigned short :0; void * v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0s_Vp_BFu1ll { unsigned short :0; void * v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0s_Vp_BFu1s { unsigned short :0; void * v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0s_Vp_BFu31i { unsigned short :0; void * v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0s_Vp_BFu31ll { unsigned short :0; void * v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0s_Vp_BFu32i { unsigned short :0; void * v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0s_Vp_BFu32ll { unsigned short :0; void * v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0s_Vp_BFu33 { unsigned short :0; void * v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0s_Vp_BFu7c { unsigned short :0; void * v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0s_Vp_BFu7i { unsigned short :0; void * v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0s_Vp_BFu7ll { unsigned short :0; void * v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_Vp_BFu7s { unsigned short :0; void * v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_Vp_BFu8c { unsigned short :0; void * v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_Vp_BFu8i { unsigned short :0; void * v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_Vp_BFu8ll { unsigned short :0; void * v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_Vp_BFu8s { unsigned short :0; void * v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_Vp_BFu9i { unsigned short :0; void * v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_Vp_BFu9ll { unsigned short :0; void * v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_Vp_BFu9s { unsigned short :0; void * v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_Vp_C { unsigned short :0; void * v1; char v2; };
struct __attribute__((packed)) aBFu0s_Vp_D { unsigned short :0; void * v1; double v2; };
struct __attribute__((packed)) aBFu0s_Vp_F { unsigned short :0; void * v1; float v2; };
struct __attribute__((packed)) aBFu0s_Vp_I { unsigned short :0; void * v1; int v2; };
struct __attribute__((packed)) aBFu0s_Vp_Ip { unsigned short :0; void * v1; int * v2; };
struct __attribute__((packed)) aBFu0s_Vp_L { unsigned short :0; void * v1; long long v2; };
struct __attribute__((packed)) aBFu0s_Vp_S { unsigned short :0; void * v1; short v2; };
struct __attribute__((packed)) aBFu0s_Vp_Uc { unsigned short :0; void * v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_Vp_Ui { unsigned short :0; void * v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_Vp_Ul { unsigned short :0; void * v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_Vp_Us { unsigned short :0; void * v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_Vp_Vp { unsigned short :0; void * v1; void * v2; };
struct __attribute__((packed)) aBFu15i_BFu0c { unsigned int v1:15; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu0c { unsigned int v1:15; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu0i { unsigned int v1:15; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu0ll { unsigned int v1:15; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu0s { unsigned int v1:15; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu15i { unsigned int v1:15; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu15ll { unsigned int v1:15; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu15s { unsigned int v1:15; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu16i { unsigned int v1:15; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu16ll { unsigned int v1:15; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu16s { unsigned int v1:15; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu17i { unsigned int v1:15; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu17ll { unsigned int v1:15; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu1c { unsigned int v1:15; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu1i { unsigned int v1:15; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu1ll { unsigned int v1:15; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu1s { unsigned int v1:15; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu31i { unsigned int v1:15; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu31ll { unsigned int v1:15; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu32i { unsigned int v1:15; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu32ll { unsigned int v1:15; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu33 { unsigned int v1:15; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu7c { unsigned int v1:15; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu7i { unsigned int v1:15; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu7ll { unsigned int v1:15; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu7s { unsigned int v1:15; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu8c { unsigned int v1:15; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu8i { unsigned int v1:15; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu8ll { unsigned int v1:15; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu8s { unsigned int v1:15; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu9i { unsigned int v1:15; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu9ll { unsigned int v1:15; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu15i_BFu0c_BFu9s { unsigned int v1:15; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu15i_BFu0c_C { unsigned int v1:15; unsigned char :0; char v2; };
struct __attribute__((packed)) aBFu15i_BFu0c_D { unsigned int v1:15; unsigned char :0; double v2; };
struct __attribute__((packed)) aBFu15i_BFu0c_F { unsigned int v1:15; unsigned char :0; float v2; };
struct __attribute__((packed)) aBFu15i_BFu0c_I { unsigned int v1:15; unsigned char :0; int v2; };
struct __attribute__((packed)) aBFu15i_BFu0c_Ip { unsigned int v1:15; unsigned char :0; int * v2; };
struct __attribute__((packed)) aBFu15i_BFu0c_L { unsigned int v1:15; unsigned char :0; long long v2; };
struct __attribute__((packed)) aBFu15i_BFu0c_S { unsigned int v1:15; unsigned char :0; short v2; };
struct __attribute__((packed)) aBFu15i_BFu0c_Uc { unsigned int v1:15; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aBFu15i_BFu0c_Ui { unsigned int v1:15; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aBFu15i_BFu0c_Ul { unsigned int v1:15; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu15i_BFu0c_Us { unsigned int v1:15; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aBFu15i_BFu0c_Vp { unsigned int v1:15; unsigned char :0; void * v2; };
struct __attribute__((packed)) aBFu15i_BFu0i { unsigned int v1:15; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu0c { unsigned int v1:15; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu0i { unsigned int v1:15; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu0ll { unsigned int v1:15; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu0s { unsigned int v1:15; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu15i { unsigned int v1:15; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu15ll { unsigned int v1:15; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu15s { unsigned int v1:15; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu16i { unsigned int v1:15; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu16ll { unsigned int v1:15; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu16s { unsigned int v1:15; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu17i { unsigned int v1:15; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu17ll { unsigned int v1:15; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu1c { unsigned int v1:15; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu1i { unsigned int v1:15; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu1ll { unsigned int v1:15; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu1s { unsigned int v1:15; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu31i { unsigned int v1:15; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu31ll { unsigned int v1:15; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu32i { unsigned int v1:15; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu32ll { unsigned int v1:15; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu33 { unsigned int v1:15; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu7c { unsigned int v1:15; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu7i { unsigned int v1:15; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu7ll { unsigned int v1:15; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu7s { unsigned int v1:15; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu8c { unsigned int v1:15; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu8i { unsigned int v1:15; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu8ll { unsigned int v1:15; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu8s { unsigned int v1:15; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu9i { unsigned int v1:15; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu9ll { unsigned int v1:15; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu15i_BFu0i_BFu9s { unsigned int v1:15; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu15i_BFu0i_C { unsigned int v1:15; unsigned int :0; char v2; };
struct __attribute__((packed)) aBFu15i_BFu0i_D { unsigned int v1:15; unsigned int :0; double v2; };
struct __attribute__((packed)) aBFu15i_BFu0i_F { unsigned int v1:15; unsigned int :0; float v2; };
struct __attribute__((packed)) aBFu15i_BFu0i_I { unsigned int v1:15; unsigned int :0; int v2; };
struct __attribute__((packed)) aBFu15i_BFu0i_Ip { unsigned int v1:15; unsigned int :0; int * v2; };
struct __attribute__((packed)) aBFu15i_BFu0i_L { unsigned int v1:15; unsigned int :0; long long v2; };
struct __attribute__((packed)) aBFu15i_BFu0i_S { unsigned int v1:15; unsigned int :0; short v2; };
struct __attribute__((packed)) aBFu15i_BFu0i_Uc { unsigned int v1:15; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aBFu15i_BFu0i_Ui { unsigned int v1:15; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aBFu15i_BFu0i_Ul { unsigned int v1:15; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu15i_BFu0i_Us { unsigned int v1:15; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aBFu15i_BFu0i_Vp { unsigned int v1:15; unsigned int :0; void * v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll { unsigned int v1:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu0c { unsigned int v1:15; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu0i { unsigned int v1:15; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu0ll { unsigned int v1:15; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu0s { unsigned int v1:15; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu15i { unsigned int v1:15; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu15ll { unsigned int v1:15; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu15s { unsigned int v1:15; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu16i { unsigned int v1:15; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu16ll { unsigned int v1:15; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu16s { unsigned int v1:15; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu17i { unsigned int v1:15; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu17ll { unsigned int v1:15; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu1c { unsigned int v1:15; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu1i { unsigned int v1:15; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu1ll { unsigned int v1:15; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu1s { unsigned int v1:15; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu31i { unsigned int v1:15; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu31ll { unsigned int v1:15; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu32i { unsigned int v1:15; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu32ll { unsigned int v1:15; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu33 { unsigned int v1:15; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu7c { unsigned int v1:15; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu7i { unsigned int v1:15; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu7ll { unsigned int v1:15; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu7s { unsigned int v1:15; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu8c { unsigned int v1:15; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu8i { unsigned int v1:15; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu8ll { unsigned int v1:15; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu8s { unsigned int v1:15; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu9i { unsigned int v1:15; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu9ll { unsigned int v1:15; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu15i_BFu0ll_BFu9s { unsigned int v1:15; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu15i_BFu0ll_C { unsigned int v1:15; unsigned long long :0; char v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll_D { unsigned int v1:15; unsigned long long :0; double v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll_F { unsigned int v1:15; unsigned long long :0; float v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll_I { unsigned int v1:15; unsigned long long :0; int v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll_Ip { unsigned int v1:15; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll_L { unsigned int v1:15; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll_S { unsigned int v1:15; unsigned long long :0; short v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll_Uc { unsigned int v1:15; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll_Ui { unsigned int v1:15; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll_Ul { unsigned int v1:15; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll_Us { unsigned int v1:15; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll_Vp { unsigned int v1:15; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aBFu15i_BFu0s { unsigned int v1:15; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu0c { unsigned int v1:15; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu0i { unsigned int v1:15; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu0ll { unsigned int v1:15; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu0s { unsigned int v1:15; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu15i { unsigned int v1:15; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu15ll { unsigned int v1:15; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu15s { unsigned int v1:15; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu16i { unsigned int v1:15; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu16ll { unsigned int v1:15; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu16s { unsigned int v1:15; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu17i { unsigned int v1:15; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu17ll { unsigned int v1:15; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu1c { unsigned int v1:15; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu1i { unsigned int v1:15; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu1ll { unsigned int v1:15; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu1s { unsigned int v1:15; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu31i { unsigned int v1:15; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu31ll { unsigned int v1:15; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu32i { unsigned int v1:15; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu32ll { unsigned int v1:15; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu33 { unsigned int v1:15; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu7c { unsigned int v1:15; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu7i { unsigned int v1:15; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu7ll { unsigned int v1:15; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu7s { unsigned int v1:15; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu8c { unsigned int v1:15; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu8i { unsigned int v1:15; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu8ll { unsigned int v1:15; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu8s { unsigned int v1:15; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu9i { unsigned int v1:15; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu9ll { unsigned int v1:15; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu15i_BFu0s_BFu9s { unsigned int v1:15; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu15i_BFu0s_C { unsigned int v1:15; unsigned short :0; char v2; };
struct __attribute__((packed)) aBFu15i_BFu0s_D { unsigned int v1:15; unsigned short :0; double v2; };
struct __attribute__((packed)) aBFu15i_BFu0s_F { unsigned int v1:15; unsigned short :0; float v2; };
struct __attribute__((packed)) aBFu15i_BFu0s_I { unsigned int v1:15; unsigned short :0; int v2; };
struct __attribute__((packed)) aBFu15i_BFu0s_Ip { unsigned int v1:15; unsigned short :0; int * v2; };
struct __attribute__((packed)) aBFu15i_BFu0s_L { unsigned int v1:15; unsigned short :0; long long v2; };
struct __attribute__((packed)) aBFu15i_BFu0s_S { unsigned int v1:15; unsigned short :0; short v2; };
struct __attribute__((packed)) aBFu15i_BFu0s_Uc { unsigned int v1:15; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aBFu15i_BFu0s_Ui { unsigned int v1:15; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aBFu15i_BFu0s_Ul { unsigned int v1:15; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu15i_BFu0s_Us { unsigned int v1:15; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aBFu15i_BFu0s_Vp { unsigned int v1:15; unsigned short :0; void * v2; };
struct __attribute__((packed)) aBFu15i_BFu15i_BFu0c { unsigned int v1:15; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu15i_BFu0i { unsigned int v1:15; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu15i_BFu0ll { unsigned int v1:15; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu15i_BFu0s { unsigned int v1:15; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu15ll_BFu0c { unsigned int v1:15; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu15ll_BFu0i { unsigned int v1:15; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu15ll_BFu0ll { unsigned int v1:15; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu15ll_BFu0s { unsigned int v1:15; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu15s_BFu0c { unsigned int v1:15; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu15s_BFu0i { unsigned int v1:15; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu15s_BFu0ll { unsigned int v1:15; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu15s_BFu0s { unsigned int v1:15; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu16i_BFu0c { unsigned int v1:15; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu16i_BFu0i { unsigned int v1:15; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu16i_BFu0ll { unsigned int v1:15; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu16i_BFu0s { unsigned int v1:15; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu16ll_BFu0c { unsigned int v1:15; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu16ll_BFu0i { unsigned int v1:15; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu16ll_BFu0ll { unsigned int v1:15; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu16ll_BFu0s { unsigned int v1:15; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu16s_BFu0c { unsigned int v1:15; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu16s_BFu0i { unsigned int v1:15; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu16s_BFu0ll { unsigned int v1:15; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu16s_BFu0s { unsigned int v1:15; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu17i_BFu0c { unsigned int v1:15; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu17i_BFu0i { unsigned int v1:15; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu17i_BFu0ll { unsigned int v1:15; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu17i_BFu0s { unsigned int v1:15; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu17ll_BFu0c { unsigned int v1:15; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu17ll_BFu0i { unsigned int v1:15; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu17ll_BFu0ll { unsigned int v1:15; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu17ll_BFu0s { unsigned int v1:15; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu1c_BFu0c { unsigned int v1:15; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu1c_BFu0i { unsigned int v1:15; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu1c_BFu0ll { unsigned int v1:15; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu1c_BFu0s { unsigned int v1:15; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu1i_BFu0c { unsigned int v1:15; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu1i_BFu0i { unsigned int v1:15; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu1i_BFu0ll { unsigned int v1:15; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu1i_BFu0s { unsigned int v1:15; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu1ll_BFu0c { unsigned int v1:15; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu1ll_BFu0i { unsigned int v1:15; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu1ll_BFu0ll { unsigned int v1:15; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu1ll_BFu0s { unsigned int v1:15; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu1s_BFu0c { unsigned int v1:15; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu1s_BFu0i { unsigned int v1:15; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu1s_BFu0ll { unsigned int v1:15; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu1s_BFu0s { unsigned int v1:15; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu31i_BFu0c { unsigned int v1:15; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu31i_BFu0i { unsigned int v1:15; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu31i_BFu0ll { unsigned int v1:15; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu31i_BFu0s { unsigned int v1:15; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu31ll_BFu0c { unsigned int v1:15; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu31ll_BFu0i { unsigned int v1:15; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu31ll_BFu0ll { unsigned int v1:15; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu31ll_BFu0s { unsigned int v1:15; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu32i_BFu0c { unsigned int v1:15; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu32i_BFu0i { unsigned int v1:15; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu32i_BFu0ll { unsigned int v1:15; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu32i_BFu0s { unsigned int v1:15; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu32ll_BFu0c { unsigned int v1:15; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu32ll_BFu0i { unsigned int v1:15; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu32ll_BFu0ll { unsigned int v1:15; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu32ll_BFu0s { unsigned int v1:15; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu33_BFu0c { unsigned int v1:15; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu33_BFu0i { unsigned int v1:15; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu33_BFu0ll { unsigned int v1:15; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu33_BFu0s { unsigned int v1:15; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu7c_BFu0c { unsigned int v1:15; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu7c_BFu0i { unsigned int v1:15; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu7c_BFu0ll { unsigned int v1:15; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu7c_BFu0s { unsigned int v1:15; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu7i_BFu0c { unsigned int v1:15; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu7i_BFu0i { unsigned int v1:15; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu7i_BFu0ll { unsigned int v1:15; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu7i_BFu0s { unsigned int v1:15; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu7ll_BFu0c { unsigned int v1:15; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu7ll_BFu0i { unsigned int v1:15; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu7ll_BFu0ll { unsigned int v1:15; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu7ll_BFu0s { unsigned int v1:15; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu7s_BFu0c { unsigned int v1:15; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu7s_BFu0i { unsigned int v1:15; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu7s_BFu0ll { unsigned int v1:15; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu7s_BFu0s { unsigned int v1:15; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu8c_BFu0c { unsigned int v1:15; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu8c_BFu0i { unsigned int v1:15; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu8c_BFu0ll { unsigned int v1:15; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu8c_BFu0s { unsigned int v1:15; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu8i_BFu0c { unsigned int v1:15; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu8i_BFu0i { unsigned int v1:15; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu8i_BFu0ll { unsigned int v1:15; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu8i_BFu0s { unsigned int v1:15; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu8ll_BFu0c { unsigned int v1:15; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu8ll_BFu0i { unsigned int v1:15; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu8ll_BFu0ll { unsigned int v1:15; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu8ll_BFu0s { unsigned int v1:15; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu8s_BFu0c { unsigned int v1:15; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu8s_BFu0i { unsigned int v1:15; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu8s_BFu0ll { unsigned int v1:15; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu8s_BFu0s { unsigned int v1:15; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu9i_BFu0c { unsigned int v1:15; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu9i_BFu0i { unsigned int v1:15; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu9i_BFu0ll { unsigned int v1:15; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu9i_BFu0s { unsigned int v1:15; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu9ll_BFu0c { unsigned int v1:15; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu9ll_BFu0i { unsigned int v1:15; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu9ll_BFu0ll { unsigned int v1:15; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu9ll_BFu0s { unsigned int v1:15; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_BFu9s_BFu0c { unsigned int v1:15; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_BFu9s_BFu0i { unsigned int v1:15; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_BFu9s_BFu0ll { unsigned int v1:15; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_BFu9s_BFu0s { unsigned int v1:15; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_C_BFu0c { unsigned int v1:15; char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_C_BFu0i { unsigned int v1:15; char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_C_BFu0ll { unsigned int v1:15; char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_C_BFu0s { unsigned int v1:15; char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_D_BFu0c { unsigned int v1:15; double v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_D_BFu0i { unsigned int v1:15; double v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_D_BFu0ll { unsigned int v1:15; double v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_D_BFu0s { unsigned int v1:15; double v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_F_BFu0c { unsigned int v1:15; float v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_F_BFu0i { unsigned int v1:15; float v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_F_BFu0ll { unsigned int v1:15; float v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_F_BFu0s { unsigned int v1:15; float v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_I_BFu0c { unsigned int v1:15; int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_I_BFu0i { unsigned int v1:15; int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_I_BFu0ll { unsigned int v1:15; int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_I_BFu0s { unsigned int v1:15; int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_Ip_BFu0c { unsigned int v1:15; int * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_Ip_BFu0i { unsigned int v1:15; int * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_Ip_BFu0ll { unsigned int v1:15; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_Ip_BFu0s { unsigned int v1:15; int * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_L_BFu0c { unsigned int v1:15; long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_L_BFu0i { unsigned int v1:15; long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_L_BFu0ll { unsigned int v1:15; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_L_BFu0s { unsigned int v1:15; long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_S_BFu0c { unsigned int v1:15; short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_S_BFu0i { unsigned int v1:15; short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_S_BFu0ll { unsigned int v1:15; short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_S_BFu0s { unsigned int v1:15; short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_Uc_BFu0c { unsigned int v1:15; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_Uc_BFu0i { unsigned int v1:15; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_Uc_BFu0ll { unsigned int v1:15; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_Uc_BFu0s { unsigned int v1:15; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_Ui_BFu0c { unsigned int v1:15; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_Ui_BFu0i { unsigned int v1:15; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_Ui_BFu0ll { unsigned int v1:15; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_Ui_BFu0s { unsigned int v1:15; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_Ul_BFu0c { unsigned int v1:15; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_Ul_BFu0i { unsigned int v1:15; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_Ul_BFu0ll { unsigned int v1:15; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_Ul_BFu0s { unsigned int v1:15; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_Us_BFu0c { unsigned int v1:15; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_Us_BFu0i { unsigned int v1:15; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_Us_BFu0ll { unsigned int v1:15; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_Us_BFu0s { unsigned int v1:15; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15i_Vp_BFu0c { unsigned int v1:15; void * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_Vp_BFu0i { unsigned int v1:15; void * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_Vp_BFu0ll { unsigned int v1:15; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_Vp_BFu0s { unsigned int v1:15; void * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu0c { unsigned long long v1:15; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu0c { unsigned long long v1:15; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu0i { unsigned long long v1:15; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu0ll { unsigned long long v1:15; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu0s { unsigned long long v1:15; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu15i { unsigned long long v1:15; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu15ll { unsigned long long v1:15; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu15s { unsigned long long v1:15; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu16i { unsigned long long v1:15; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu16ll { unsigned long long v1:15; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu16s { unsigned long long v1:15; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu17i { unsigned long long v1:15; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu17ll { unsigned long long v1:15; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu1c { unsigned long long v1:15; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu1i { unsigned long long v1:15; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu1ll { unsigned long long v1:15; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu1s { unsigned long long v1:15; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu31i { unsigned long long v1:15; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu31ll { unsigned long long v1:15; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu32i { unsigned long long v1:15; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu32ll { unsigned long long v1:15; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu33 { unsigned long long v1:15; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu7c { unsigned long long v1:15; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu7i { unsigned long long v1:15; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu7ll { unsigned long long v1:15; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu7s { unsigned long long v1:15; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu8c { unsigned long long v1:15; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu8i { unsigned long long v1:15; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu8ll { unsigned long long v1:15; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu8s { unsigned long long v1:15; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu9i { unsigned long long v1:15; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu9ll { unsigned long long v1:15; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu15ll_BFu0c_BFu9s { unsigned long long v1:15; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu15ll_BFu0c_C { unsigned long long v1:15; unsigned char :0; char v2; };
struct __attribute__((packed)) aBFu15ll_BFu0c_D { unsigned long long v1:15; unsigned char :0; double v2; };
struct __attribute__((packed)) aBFu15ll_BFu0c_F { unsigned long long v1:15; unsigned char :0; float v2; };
struct __attribute__((packed)) aBFu15ll_BFu0c_I { unsigned long long v1:15; unsigned char :0; int v2; };
struct __attribute__((packed)) aBFu15ll_BFu0c_Ip { unsigned long long v1:15; unsigned char :0; int * v2; };
struct __attribute__((packed)) aBFu15ll_BFu0c_L { unsigned long long v1:15; unsigned char :0; long long v2; };
struct __attribute__((packed)) aBFu15ll_BFu0c_S { unsigned long long v1:15; unsigned char :0; short v2; };
struct __attribute__((packed)) aBFu15ll_BFu0c_Uc { unsigned long long v1:15; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aBFu15ll_BFu0c_Ui { unsigned long long v1:15; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aBFu15ll_BFu0c_Ul { unsigned long long v1:15; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu15ll_BFu0c_Us { unsigned long long v1:15; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aBFu15ll_BFu0c_Vp { unsigned long long v1:15; unsigned char :0; void * v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i { unsigned long long v1:15; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu0c { unsigned long long v1:15; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu0i { unsigned long long v1:15; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu0ll { unsigned long long v1:15; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu0s { unsigned long long v1:15; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu15i { unsigned long long v1:15; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu15ll { unsigned long long v1:15; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu15s { unsigned long long v1:15; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu16i { unsigned long long v1:15; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu16ll { unsigned long long v1:15; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu16s { unsigned long long v1:15; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu17i { unsigned long long v1:15; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu17ll { unsigned long long v1:15; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu1c { unsigned long long v1:15; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu1i { unsigned long long v1:15; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu1ll { unsigned long long v1:15; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu1s { unsigned long long v1:15; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu31i { unsigned long long v1:15; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu31ll { unsigned long long v1:15; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu32i { unsigned long long v1:15; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu32ll { unsigned long long v1:15; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu33 { unsigned long long v1:15; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu7c { unsigned long long v1:15; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu7i { unsigned long long v1:15; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu7ll { unsigned long long v1:15; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu7s { unsigned long long v1:15; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu8c { unsigned long long v1:15; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu8i { unsigned long long v1:15; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu8ll { unsigned long long v1:15; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu8s { unsigned long long v1:15; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu9i { unsigned long long v1:15; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu9ll { unsigned long long v1:15; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu15ll_BFu0i_BFu9s { unsigned long long v1:15; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu15ll_BFu0i_C { unsigned long long v1:15; unsigned int :0; char v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i_D { unsigned long long v1:15; unsigned int :0; double v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i_F { unsigned long long v1:15; unsigned int :0; float v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i_I { unsigned long long v1:15; unsigned int :0; int v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i_Ip { unsigned long long v1:15; unsigned int :0; int * v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i_L { unsigned long long v1:15; unsigned int :0; long long v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i_S { unsigned long long v1:15; unsigned int :0; short v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i_Uc { unsigned long long v1:15; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i_Ui { unsigned long long v1:15; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i_Ul { unsigned long long v1:15; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i_Us { unsigned long long v1:15; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i_Vp { unsigned long long v1:15; unsigned int :0; void * v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll { unsigned long long v1:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu0c { unsigned long long v1:15; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu0i { unsigned long long v1:15; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu0ll { unsigned long long v1:15; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu0s { unsigned long long v1:15; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu15i { unsigned long long v1:15; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu15ll { unsigned long long v1:15; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu15s { unsigned long long v1:15; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu16i { unsigned long long v1:15; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu16ll { unsigned long long v1:15; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu16s { unsigned long long v1:15; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu17i { unsigned long long v1:15; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu17ll { unsigned long long v1:15; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu1c { unsigned long long v1:15; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu1i { unsigned long long v1:15; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu1ll { unsigned long long v1:15; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu1s { unsigned long long v1:15; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu31i { unsigned long long v1:15; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu31ll { unsigned long long v1:15; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu32i { unsigned long long v1:15; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu32ll { unsigned long long v1:15; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu33 { unsigned long long v1:15; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu7c { unsigned long long v1:15; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu7i { unsigned long long v1:15; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu7ll { unsigned long long v1:15; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu7s { unsigned long long v1:15; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu8c { unsigned long long v1:15; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu8i { unsigned long long v1:15; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu8ll { unsigned long long v1:15; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu8s { unsigned long long v1:15; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu9i { unsigned long long v1:15; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu9ll { unsigned long long v1:15; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_BFu9s { unsigned long long v1:15; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_C { unsigned long long v1:15; unsigned long long :0; char v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_D { unsigned long long v1:15; unsigned long long :0; double v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_F { unsigned long long v1:15; unsigned long long :0; float v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_I { unsigned long long v1:15; unsigned long long :0; int v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_Ip { unsigned long long v1:15; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_L { unsigned long long v1:15; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_S { unsigned long long v1:15; unsigned long long :0; short v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_Uc { unsigned long long v1:15; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_Ui { unsigned long long v1:15; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_Ul { unsigned long long v1:15; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_Us { unsigned long long v1:15; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_Vp { unsigned long long v1:15; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s { unsigned long long v1:15; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu0c { unsigned long long v1:15; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu0i { unsigned long long v1:15; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu0ll { unsigned long long v1:15; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu0s { unsigned long long v1:15; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu15i { unsigned long long v1:15; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu15ll { unsigned long long v1:15; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu15s { unsigned long long v1:15; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu16i { unsigned long long v1:15; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu16ll { unsigned long long v1:15; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu16s { unsigned long long v1:15; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu17i { unsigned long long v1:15; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu17ll { unsigned long long v1:15; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu1c { unsigned long long v1:15; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu1i { unsigned long long v1:15; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu1ll { unsigned long long v1:15; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu1s { unsigned long long v1:15; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu31i { unsigned long long v1:15; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu31ll { unsigned long long v1:15; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu32i { unsigned long long v1:15; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu32ll { unsigned long long v1:15; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu33 { unsigned long long v1:15; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu7c { unsigned long long v1:15; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu7i { unsigned long long v1:15; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu7ll { unsigned long long v1:15; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu7s { unsigned long long v1:15; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu8c { unsigned long long v1:15; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu8i { unsigned long long v1:15; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu8ll { unsigned long long v1:15; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu8s { unsigned long long v1:15; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu9i { unsigned long long v1:15; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu9ll { unsigned long long v1:15; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu15ll_BFu0s_BFu9s { unsigned long long v1:15; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu15ll_BFu0s_C { unsigned long long v1:15; unsigned short :0; char v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s_D { unsigned long long v1:15; unsigned short :0; double v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s_F { unsigned long long v1:15; unsigned short :0; float v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s_I { unsigned long long v1:15; unsigned short :0; int v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s_Ip { unsigned long long v1:15; unsigned short :0; int * v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s_L { unsigned long long v1:15; unsigned short :0; long long v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s_S { unsigned long long v1:15; unsigned short :0; short v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s_Uc { unsigned long long v1:15; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s_Ui { unsigned long long v1:15; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s_Ul { unsigned long long v1:15; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s_Us { unsigned long long v1:15; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s_Vp { unsigned long long v1:15; unsigned short :0; void * v2; };
struct __attribute__((packed)) aBFu15ll_BFu15i_BFu0c { unsigned long long v1:15; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu15i_BFu0i { unsigned long long v1:15; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu15i_BFu0ll { unsigned long long v1:15; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu15i_BFu0s { unsigned long long v1:15; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu15ll_BFu0c { unsigned long long v1:15; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu15ll_BFu0i { unsigned long long v1:15; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu15ll_BFu0ll { unsigned long long v1:15; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu15ll_BFu0s { unsigned long long v1:15; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu15s_BFu0c { unsigned long long v1:15; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu15s_BFu0i { unsigned long long v1:15; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu15s_BFu0ll { unsigned long long v1:15; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu15s_BFu0s { unsigned long long v1:15; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu16i_BFu0c { unsigned long long v1:15; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu16i_BFu0i { unsigned long long v1:15; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu16i_BFu0ll { unsigned long long v1:15; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu16i_BFu0s { unsigned long long v1:15; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu16ll_BFu0c { unsigned long long v1:15; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu16ll_BFu0i { unsigned long long v1:15; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu16ll_BFu0ll { unsigned long long v1:15; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu16ll_BFu0s { unsigned long long v1:15; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu16s_BFu0c { unsigned long long v1:15; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu16s_BFu0i { unsigned long long v1:15; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu16s_BFu0ll { unsigned long long v1:15; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu16s_BFu0s { unsigned long long v1:15; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu17i_BFu0c { unsigned long long v1:15; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu17i_BFu0i { unsigned long long v1:15; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu17i_BFu0ll { unsigned long long v1:15; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu17i_BFu0s { unsigned long long v1:15; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu17ll_BFu0c { unsigned long long v1:15; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu17ll_BFu0i { unsigned long long v1:15; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu17ll_BFu0ll { unsigned long long v1:15; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu17ll_BFu0s { unsigned long long v1:15; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu1c_BFu0c { unsigned long long v1:15; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu1c_BFu0i { unsigned long long v1:15; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu1c_BFu0ll { unsigned long long v1:15; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu1c_BFu0s { unsigned long long v1:15; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu1i_BFu0c { unsigned long long v1:15; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu1i_BFu0i { unsigned long long v1:15; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu1i_BFu0ll { unsigned long long v1:15; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu1i_BFu0s { unsigned long long v1:15; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu1ll_BFu0c { unsigned long long v1:15; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu1ll_BFu0i { unsigned long long v1:15; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu1ll_BFu0ll { unsigned long long v1:15; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu1ll_BFu0s { unsigned long long v1:15; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu1s_BFu0c { unsigned long long v1:15; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu1s_BFu0i { unsigned long long v1:15; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu1s_BFu0ll { unsigned long long v1:15; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu1s_BFu0s { unsigned long long v1:15; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu31i_BFu0c { unsigned long long v1:15; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu31i_BFu0i { unsigned long long v1:15; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu31i_BFu0ll { unsigned long long v1:15; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu31i_BFu0s { unsigned long long v1:15; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu31ll_BFu0c { unsigned long long v1:15; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu31ll_BFu0i { unsigned long long v1:15; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu31ll_BFu0ll { unsigned long long v1:15; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu31ll_BFu0s { unsigned long long v1:15; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu32i_BFu0c { unsigned long long v1:15; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu32i_BFu0i { unsigned long long v1:15; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu32i_BFu0ll { unsigned long long v1:15; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu32i_BFu0s { unsigned long long v1:15; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu32ll_BFu0c { unsigned long long v1:15; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu32ll_BFu0i { unsigned long long v1:15; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu32ll_BFu0ll { unsigned long long v1:15; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu32ll_BFu0s { unsigned long long v1:15; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu33_BFu0c { unsigned long long v1:15; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu33_BFu0i { unsigned long long v1:15; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu33_BFu0ll { unsigned long long v1:15; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu33_BFu0s { unsigned long long v1:15; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu7c_BFu0c { unsigned long long v1:15; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu7c_BFu0i { unsigned long long v1:15; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu7c_BFu0ll { unsigned long long v1:15; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu7c_BFu0s { unsigned long long v1:15; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu7i_BFu0c { unsigned long long v1:15; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu7i_BFu0i { unsigned long long v1:15; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu7i_BFu0ll { unsigned long long v1:15; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu7i_BFu0s { unsigned long long v1:15; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu7ll_BFu0c { unsigned long long v1:15; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu7ll_BFu0i { unsigned long long v1:15; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu7ll_BFu0ll { unsigned long long v1:15; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu7ll_BFu0s { unsigned long long v1:15; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu7s_BFu0c { unsigned long long v1:15; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu7s_BFu0i { unsigned long long v1:15; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu7s_BFu0ll { unsigned long long v1:15; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu7s_BFu0s { unsigned long long v1:15; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu8c_BFu0c { unsigned long long v1:15; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu8c_BFu0i { unsigned long long v1:15; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu8c_BFu0ll { unsigned long long v1:15; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu8c_BFu0s { unsigned long long v1:15; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu8i_BFu0c { unsigned long long v1:15; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu8i_BFu0i { unsigned long long v1:15; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu8i_BFu0ll { unsigned long long v1:15; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu8i_BFu0s { unsigned long long v1:15; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu8ll_BFu0c { unsigned long long v1:15; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu8ll_BFu0i { unsigned long long v1:15; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu8ll_BFu0ll { unsigned long long v1:15; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu8ll_BFu0s { unsigned long long v1:15; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu8s_BFu0c { unsigned long long v1:15; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu8s_BFu0i { unsigned long long v1:15; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu8s_BFu0ll { unsigned long long v1:15; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu8s_BFu0s { unsigned long long v1:15; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu9i_BFu0c { unsigned long long v1:15; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu9i_BFu0i { unsigned long long v1:15; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu9i_BFu0ll { unsigned long long v1:15; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu9i_BFu0s { unsigned long long v1:15; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu9ll_BFu0c { unsigned long long v1:15; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu9ll_BFu0i { unsigned long long v1:15; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu9ll_BFu0ll { unsigned long long v1:15; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu9ll_BFu0s { unsigned long long v1:15; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu9s_BFu0c { unsigned long long v1:15; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_BFu9s_BFu0i { unsigned long long v1:15; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_BFu9s_BFu0ll { unsigned long long v1:15; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_BFu9s_BFu0s { unsigned long long v1:15; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_C_BFu0c { unsigned long long v1:15; char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_C_BFu0i { unsigned long long v1:15; char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_C_BFu0ll { unsigned long long v1:15; char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_C_BFu0s { unsigned long long v1:15; char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_D_BFu0c { unsigned long long v1:15; double v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_D_BFu0i { unsigned long long v1:15; double v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_D_BFu0ll { unsigned long long v1:15; double v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_D_BFu0s { unsigned long long v1:15; double v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_F_BFu0c { unsigned long long v1:15; float v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_F_BFu0i { unsigned long long v1:15; float v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_F_BFu0ll { unsigned long long v1:15; float v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_F_BFu0s { unsigned long long v1:15; float v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_I_BFu0c { unsigned long long v1:15; int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_I_BFu0i { unsigned long long v1:15; int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_I_BFu0ll { unsigned long long v1:15; int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_I_BFu0s { unsigned long long v1:15; int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_Ip_BFu0c { unsigned long long v1:15; int * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_Ip_BFu0i { unsigned long long v1:15; int * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_Ip_BFu0ll { unsigned long long v1:15; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_Ip_BFu0s { unsigned long long v1:15; int * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_L_BFu0c { unsigned long long v1:15; long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_L_BFu0i { unsigned long long v1:15; long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_L_BFu0ll { unsigned long long v1:15; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_L_BFu0s { unsigned long long v1:15; long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_S_BFu0c { unsigned long long v1:15; short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_S_BFu0i { unsigned long long v1:15; short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_S_BFu0ll { unsigned long long v1:15; short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_S_BFu0s { unsigned long long v1:15; short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_Uc_BFu0c { unsigned long long v1:15; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_Uc_BFu0i { unsigned long long v1:15; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_Uc_BFu0ll { unsigned long long v1:15; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_Uc_BFu0s { unsigned long long v1:15; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_Ui_BFu0c { unsigned long long v1:15; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_Ui_BFu0i { unsigned long long v1:15; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_Ui_BFu0ll { unsigned long long v1:15; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_Ui_BFu0s { unsigned long long v1:15; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_Ul_BFu0c { unsigned long long v1:15; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_Ul_BFu0i { unsigned long long v1:15; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_Ul_BFu0ll { unsigned long long v1:15; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_Ul_BFu0s { unsigned long long v1:15; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_Us_BFu0c { unsigned long long v1:15; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_Us_BFu0i { unsigned long long v1:15; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_Us_BFu0ll { unsigned long long v1:15; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_Us_BFu0s { unsigned long long v1:15; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_Vp_BFu0c { unsigned long long v1:15; void * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_Vp_BFu0i { unsigned long long v1:15; void * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_Vp_BFu0ll { unsigned long long v1:15; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_Vp_BFu0s { unsigned long long v1:15; void * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu0c { unsigned short v1:15; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu0c { unsigned short v1:15; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu0i { unsigned short v1:15; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu0ll { unsigned short v1:15; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu0s { unsigned short v1:15; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu15i { unsigned short v1:15; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu15ll { unsigned short v1:15; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu15s { unsigned short v1:15; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu16i { unsigned short v1:15; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu16ll { unsigned short v1:15; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu16s { unsigned short v1:15; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu17i { unsigned short v1:15; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu17ll { unsigned short v1:15; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu1c { unsigned short v1:15; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu1i { unsigned short v1:15; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu1ll { unsigned short v1:15; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu1s { unsigned short v1:15; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu31i { unsigned short v1:15; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu31ll { unsigned short v1:15; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu32i { unsigned short v1:15; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu32ll { unsigned short v1:15; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu33 { unsigned short v1:15; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu7c { unsigned short v1:15; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu7i { unsigned short v1:15; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu7ll { unsigned short v1:15; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu7s { unsigned short v1:15; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu8c { unsigned short v1:15; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu8i { unsigned short v1:15; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu8ll { unsigned short v1:15; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu8s { unsigned short v1:15; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu9i { unsigned short v1:15; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu9ll { unsigned short v1:15; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu15s_BFu0c_BFu9s { unsigned short v1:15; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu15s_BFu0c_C { unsigned short v1:15; unsigned char :0; char v2; };
struct __attribute__((packed)) aBFu15s_BFu0c_D { unsigned short v1:15; unsigned char :0; double v2; };
struct __attribute__((packed)) aBFu15s_BFu0c_F { unsigned short v1:15; unsigned char :0; float v2; };
struct __attribute__((packed)) aBFu15s_BFu0c_I { unsigned short v1:15; unsigned char :0; int v2; };
struct __attribute__((packed)) aBFu15s_BFu0c_Ip { unsigned short v1:15; unsigned char :0; int * v2; };
struct __attribute__((packed)) aBFu15s_BFu0c_L { unsigned short v1:15; unsigned char :0; long long v2; };
struct __attribute__((packed)) aBFu15s_BFu0c_S { unsigned short v1:15; unsigned char :0; short v2; };
struct __attribute__((packed)) aBFu15s_BFu0c_Uc { unsigned short v1:15; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aBFu15s_BFu0c_Ui { unsigned short v1:15; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aBFu15s_BFu0c_Ul { unsigned short v1:15; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu15s_BFu0c_Us { unsigned short v1:15; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aBFu15s_BFu0c_Vp { unsigned short v1:15; unsigned char :0; void * v2; };
struct __attribute__((packed)) aBFu15s_BFu0i { unsigned short v1:15; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu0c { unsigned short v1:15; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu0i { unsigned short v1:15; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu0ll { unsigned short v1:15; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu0s { unsigned short v1:15; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu15i { unsigned short v1:15; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu15ll { unsigned short v1:15; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu15s { unsigned short v1:15; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu16i { unsigned short v1:15; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu16ll { unsigned short v1:15; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu16s { unsigned short v1:15; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu17i { unsigned short v1:15; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu17ll { unsigned short v1:15; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu1c { unsigned short v1:15; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu1i { unsigned short v1:15; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu1ll { unsigned short v1:15; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu1s { unsigned short v1:15; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu31i { unsigned short v1:15; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu31ll { unsigned short v1:15; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu32i { unsigned short v1:15; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu32ll { unsigned short v1:15; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu33 { unsigned short v1:15; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu7c { unsigned short v1:15; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu7i { unsigned short v1:15; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu7ll { unsigned short v1:15; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu7s { unsigned short v1:15; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu8c { unsigned short v1:15; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu8i { unsigned short v1:15; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu8ll { unsigned short v1:15; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu8s { unsigned short v1:15; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu9i { unsigned short v1:15; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu9ll { unsigned short v1:15; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu15s_BFu0i_BFu9s { unsigned short v1:15; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu15s_BFu0i_C { unsigned short v1:15; unsigned int :0; char v2; };
struct __attribute__((packed)) aBFu15s_BFu0i_D { unsigned short v1:15; unsigned int :0; double v2; };
struct __attribute__((packed)) aBFu15s_BFu0i_F { unsigned short v1:15; unsigned int :0; float v2; };
struct __attribute__((packed)) aBFu15s_BFu0i_I { unsigned short v1:15; unsigned int :0; int v2; };
struct __attribute__((packed)) aBFu15s_BFu0i_Ip { unsigned short v1:15; unsigned int :0; int * v2; };
struct __attribute__((packed)) aBFu15s_BFu0i_L { unsigned short v1:15; unsigned int :0; long long v2; };
struct __attribute__((packed)) aBFu15s_BFu0i_S { unsigned short v1:15; unsigned int :0; short v2; };
struct __attribute__((packed)) aBFu15s_BFu0i_Uc { unsigned short v1:15; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aBFu15s_BFu0i_Ui { unsigned short v1:15; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aBFu15s_BFu0i_Ul { unsigned short v1:15; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu15s_BFu0i_Us { unsigned short v1:15; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aBFu15s_BFu0i_Vp { unsigned short v1:15; unsigned int :0; void * v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll { unsigned short v1:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu0c { unsigned short v1:15; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu0i { unsigned short v1:15; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu0ll { unsigned short v1:15; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu0s { unsigned short v1:15; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu15i { unsigned short v1:15; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu15ll { unsigned short v1:15; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu15s { unsigned short v1:15; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu16i { unsigned short v1:15; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu16ll { unsigned short v1:15; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu16s { unsigned short v1:15; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu17i { unsigned short v1:15; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu17ll { unsigned short v1:15; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu1c { unsigned short v1:15; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu1i { unsigned short v1:15; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu1ll { unsigned short v1:15; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu1s { unsigned short v1:15; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu31i { unsigned short v1:15; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu31ll { unsigned short v1:15; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu32i { unsigned short v1:15; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu32ll { unsigned short v1:15; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu33 { unsigned short v1:15; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu7c { unsigned short v1:15; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu7i { unsigned short v1:15; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu7ll { unsigned short v1:15; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu7s { unsigned short v1:15; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu8c { unsigned short v1:15; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu8i { unsigned short v1:15; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu8ll { unsigned short v1:15; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu8s { unsigned short v1:15; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu9i { unsigned short v1:15; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu9ll { unsigned short v1:15; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu15s_BFu0ll_BFu9s { unsigned short v1:15; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu15s_BFu0ll_C { unsigned short v1:15; unsigned long long :0; char v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll_D { unsigned short v1:15; unsigned long long :0; double v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll_F { unsigned short v1:15; unsigned long long :0; float v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll_I { unsigned short v1:15; unsigned long long :0; int v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll_Ip { unsigned short v1:15; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll_L { unsigned short v1:15; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll_S { unsigned short v1:15; unsigned long long :0; short v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll_Uc { unsigned short v1:15; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll_Ui { unsigned short v1:15; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll_Ul { unsigned short v1:15; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll_Us { unsigned short v1:15; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll_Vp { unsigned short v1:15; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aBFu15s_BFu0s { unsigned short v1:15; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu0c { unsigned short v1:15; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu0i { unsigned short v1:15; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu0ll { unsigned short v1:15; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu0s { unsigned short v1:15; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu15i { unsigned short v1:15; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu15ll { unsigned short v1:15; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu15s { unsigned short v1:15; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu16i { unsigned short v1:15; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu16ll { unsigned short v1:15; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu16s { unsigned short v1:15; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu17i { unsigned short v1:15; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu17ll { unsigned short v1:15; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu1c { unsigned short v1:15; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu1i { unsigned short v1:15; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu1ll { unsigned short v1:15; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu1s { unsigned short v1:15; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu31i { unsigned short v1:15; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu31ll { unsigned short v1:15; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu32i { unsigned short v1:15; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu32ll { unsigned short v1:15; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu33 { unsigned short v1:15; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu7c { unsigned short v1:15; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu7i { unsigned short v1:15; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu7ll { unsigned short v1:15; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu7s { unsigned short v1:15; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu8c { unsigned short v1:15; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu8i { unsigned short v1:15; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu8ll { unsigned short v1:15; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu8s { unsigned short v1:15; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu9i { unsigned short v1:15; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu9ll { unsigned short v1:15; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu15s_BFu0s_BFu9s { unsigned short v1:15; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu15s_BFu0s_C { unsigned short v1:15; unsigned short :0; char v2; };
struct __attribute__((packed)) aBFu15s_BFu0s_D { unsigned short v1:15; unsigned short :0; double v2; };
struct __attribute__((packed)) aBFu15s_BFu0s_F { unsigned short v1:15; unsigned short :0; float v2; };
struct __attribute__((packed)) aBFu15s_BFu0s_I { unsigned short v1:15; unsigned short :0; int v2; };
struct __attribute__((packed)) aBFu15s_BFu0s_Ip { unsigned short v1:15; unsigned short :0; int * v2; };
struct __attribute__((packed)) aBFu15s_BFu0s_L { unsigned short v1:15; unsigned short :0; long long v2; };
struct __attribute__((packed)) aBFu15s_BFu0s_S { unsigned short v1:15; unsigned short :0; short v2; };
struct __attribute__((packed)) aBFu15s_BFu0s_Uc { unsigned short v1:15; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aBFu15s_BFu0s_Ui { unsigned short v1:15; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aBFu15s_BFu0s_Ul { unsigned short v1:15; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu15s_BFu0s_Us { unsigned short v1:15; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aBFu15s_BFu0s_Vp { unsigned short v1:15; unsigned short :0; void * v2; };
struct __attribute__((packed)) aBFu15s_BFu15i_BFu0c { unsigned short v1:15; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu15i_BFu0i { unsigned short v1:15; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu15i_BFu0ll { unsigned short v1:15; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu15i_BFu0s { unsigned short v1:15; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu15ll_BFu0c { unsigned short v1:15; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu15ll_BFu0i { unsigned short v1:15; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu15ll_BFu0ll { unsigned short v1:15; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu15ll_BFu0s { unsigned short v1:15; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu15s_BFu0c { unsigned short v1:15; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu15s_BFu0i { unsigned short v1:15; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu15s_BFu0ll { unsigned short v1:15; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu15s_BFu0s { unsigned short v1:15; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu16i_BFu0c { unsigned short v1:15; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu16i_BFu0i { unsigned short v1:15; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu16i_BFu0ll { unsigned short v1:15; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu16i_BFu0s { unsigned short v1:15; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu16ll_BFu0c { unsigned short v1:15; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu16ll_BFu0i { unsigned short v1:15; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu16ll_BFu0ll { unsigned short v1:15; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu16ll_BFu0s { unsigned short v1:15; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu16s_BFu0c { unsigned short v1:15; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu16s_BFu0i { unsigned short v1:15; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu16s_BFu0ll { unsigned short v1:15; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu16s_BFu0s { unsigned short v1:15; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu17i_BFu0c { unsigned short v1:15; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu17i_BFu0i { unsigned short v1:15; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu17i_BFu0ll { unsigned short v1:15; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu17i_BFu0s { unsigned short v1:15; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu17ll_BFu0c { unsigned short v1:15; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu17ll_BFu0i { unsigned short v1:15; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu17ll_BFu0ll { unsigned short v1:15; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu17ll_BFu0s { unsigned short v1:15; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu1c_BFu0c { unsigned short v1:15; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu1c_BFu0i { unsigned short v1:15; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu1c_BFu0ll { unsigned short v1:15; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu1c_BFu0s { unsigned short v1:15; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu1i_BFu0c { unsigned short v1:15; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu1i_BFu0i { unsigned short v1:15; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu1i_BFu0ll { unsigned short v1:15; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu1i_BFu0s { unsigned short v1:15; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu1ll_BFu0c { unsigned short v1:15; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu1ll_BFu0i { unsigned short v1:15; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu1ll_BFu0ll { unsigned short v1:15; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu1ll_BFu0s { unsigned short v1:15; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu1s_BFu0c { unsigned short v1:15; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu1s_BFu0i { unsigned short v1:15; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu1s_BFu0ll { unsigned short v1:15; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu1s_BFu0s { unsigned short v1:15; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu31i_BFu0c { unsigned short v1:15; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu31i_BFu0i { unsigned short v1:15; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu31i_BFu0ll { unsigned short v1:15; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu31i_BFu0s { unsigned short v1:15; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu31ll_BFu0c { unsigned short v1:15; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu31ll_BFu0i { unsigned short v1:15; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu31ll_BFu0ll { unsigned short v1:15; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu31ll_BFu0s { unsigned short v1:15; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu32i_BFu0c { unsigned short v1:15; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu32i_BFu0i { unsigned short v1:15; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu32i_BFu0ll { unsigned short v1:15; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu32i_BFu0s { unsigned short v1:15; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu32ll_BFu0c { unsigned short v1:15; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu32ll_BFu0i { unsigned short v1:15; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu32ll_BFu0ll { unsigned short v1:15; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu32ll_BFu0s { unsigned short v1:15; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu33_BFu0c { unsigned short v1:15; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu33_BFu0i { unsigned short v1:15; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu33_BFu0ll { unsigned short v1:15; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu33_BFu0s { unsigned short v1:15; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu7c_BFu0c { unsigned short v1:15; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu7c_BFu0i { unsigned short v1:15; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu7c_BFu0ll { unsigned short v1:15; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu7c_BFu0s { unsigned short v1:15; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu7i_BFu0c { unsigned short v1:15; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu7i_BFu0i { unsigned short v1:15; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu7i_BFu0ll { unsigned short v1:15; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu7i_BFu0s { unsigned short v1:15; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu7ll_BFu0c { unsigned short v1:15; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu7ll_BFu0i { unsigned short v1:15; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu7ll_BFu0ll { unsigned short v1:15; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu7ll_BFu0s { unsigned short v1:15; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu7s_BFu0c { unsigned short v1:15; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu7s_BFu0i { unsigned short v1:15; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu7s_BFu0ll { unsigned short v1:15; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu7s_BFu0s { unsigned short v1:15; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu8c_BFu0c { unsigned short v1:15; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu8c_BFu0i { unsigned short v1:15; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu8c_BFu0ll { unsigned short v1:15; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu8c_BFu0s { unsigned short v1:15; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu8i_BFu0c { unsigned short v1:15; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu8i_BFu0i { unsigned short v1:15; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu8i_BFu0ll { unsigned short v1:15; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu8i_BFu0s { unsigned short v1:15; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu8ll_BFu0c { unsigned short v1:15; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu8ll_BFu0i { unsigned short v1:15; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu8ll_BFu0ll { unsigned short v1:15; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu8ll_BFu0s { unsigned short v1:15; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu8s_BFu0c { unsigned short v1:15; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu8s_BFu0i { unsigned short v1:15; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu8s_BFu0ll { unsigned short v1:15; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu8s_BFu0s { unsigned short v1:15; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu9i_BFu0c { unsigned short v1:15; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu9i_BFu0i { unsigned short v1:15; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu9i_BFu0ll { unsigned short v1:15; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu9i_BFu0s { unsigned short v1:15; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu9ll_BFu0c { unsigned short v1:15; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu9ll_BFu0i { unsigned short v1:15; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu9ll_BFu0ll { unsigned short v1:15; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu9ll_BFu0s { unsigned short v1:15; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu9s_BFu0c { unsigned short v1:15; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_BFu9s_BFu0i { unsigned short v1:15; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_BFu9s_BFu0ll { unsigned short v1:15; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_BFu9s_BFu0s { unsigned short v1:15; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_C_BFu0c { unsigned short v1:15; char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_C_BFu0i { unsigned short v1:15; char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_C_BFu0ll { unsigned short v1:15; char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_C_BFu0s { unsigned short v1:15; char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_D_BFu0c { unsigned short v1:15; double v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_D_BFu0i { unsigned short v1:15; double v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_D_BFu0ll { unsigned short v1:15; double v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_D_BFu0s { unsigned short v1:15; double v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_F_BFu0c { unsigned short v1:15; float v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_F_BFu0i { unsigned short v1:15; float v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_F_BFu0ll { unsigned short v1:15; float v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_F_BFu0s { unsigned short v1:15; float v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_I_BFu0c { unsigned short v1:15; int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_I_BFu0i { unsigned short v1:15; int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_I_BFu0ll { unsigned short v1:15; int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_I_BFu0s { unsigned short v1:15; int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_Ip_BFu0c { unsigned short v1:15; int * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_Ip_BFu0i { unsigned short v1:15; int * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_Ip_BFu0ll { unsigned short v1:15; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_Ip_BFu0s { unsigned short v1:15; int * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_L_BFu0c { unsigned short v1:15; long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_L_BFu0i { unsigned short v1:15; long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_L_BFu0ll { unsigned short v1:15; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_L_BFu0s { unsigned short v1:15; long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_S_BFu0c { unsigned short v1:15; short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_S_BFu0i { unsigned short v1:15; short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_S_BFu0ll { unsigned short v1:15; short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_S_BFu0s { unsigned short v1:15; short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_Uc_BFu0c { unsigned short v1:15; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_Uc_BFu0i { unsigned short v1:15; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_Uc_BFu0ll { unsigned short v1:15; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_Uc_BFu0s { unsigned short v1:15; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_Ui_BFu0c { unsigned short v1:15; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_Ui_BFu0i { unsigned short v1:15; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_Ui_BFu0ll { unsigned short v1:15; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_Ui_BFu0s { unsigned short v1:15; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_Ul_BFu0c { unsigned short v1:15; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_Ul_BFu0i { unsigned short v1:15; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_Ul_BFu0ll { unsigned short v1:15; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_Ul_BFu0s { unsigned short v1:15; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_Us_BFu0c { unsigned short v1:15; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_Us_BFu0i { unsigned short v1:15; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_Us_BFu0ll { unsigned short v1:15; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_Us_BFu0s { unsigned short v1:15; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_Vp_BFu0c { unsigned short v1:15; void * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_Vp_BFu0i { unsigned short v1:15; void * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_Vp_BFu0ll { unsigned short v1:15; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_Vp_BFu0s { unsigned short v1:15; void * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu0c { unsigned int v1:16; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu0c { unsigned int v1:16; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu0i { unsigned int v1:16; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu0ll { unsigned int v1:16; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu0s { unsigned int v1:16; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu15i { unsigned int v1:16; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu15ll { unsigned int v1:16; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu15s { unsigned int v1:16; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu16i { unsigned int v1:16; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu16ll { unsigned int v1:16; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu16s { unsigned int v1:16; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu17i { unsigned int v1:16; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu17ll { unsigned int v1:16; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu1c { unsigned int v1:16; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu1i { unsigned int v1:16; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu1ll { unsigned int v1:16; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu1s { unsigned int v1:16; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu31i { unsigned int v1:16; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu31ll { unsigned int v1:16; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu32i { unsigned int v1:16; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu32ll { unsigned int v1:16; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu33 { unsigned int v1:16; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu7c { unsigned int v1:16; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu7i { unsigned int v1:16; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu7ll { unsigned int v1:16; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu7s { unsigned int v1:16; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu8c { unsigned int v1:16; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu8i { unsigned int v1:16; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu8ll { unsigned int v1:16; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu8s { unsigned int v1:16; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu9i { unsigned int v1:16; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu9ll { unsigned int v1:16; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16i_BFu0c_BFu9s { unsigned int v1:16; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16i_BFu0c_C { unsigned int v1:16; unsigned char :0; char v2; };
struct __attribute__((packed)) aBFu16i_BFu0c_D { unsigned int v1:16; unsigned char :0; double v2; };
struct __attribute__((packed)) aBFu16i_BFu0c_F { unsigned int v1:16; unsigned char :0; float v2; };
struct __attribute__((packed)) aBFu16i_BFu0c_I { unsigned int v1:16; unsigned char :0; int v2; };
struct __attribute__((packed)) aBFu16i_BFu0c_Ip { unsigned int v1:16; unsigned char :0; int * v2; };
struct __attribute__((packed)) aBFu16i_BFu0c_L { unsigned int v1:16; unsigned char :0; long long v2; };
struct __attribute__((packed)) aBFu16i_BFu0c_S { unsigned int v1:16; unsigned char :0; short v2; };
struct __attribute__((packed)) aBFu16i_BFu0c_Uc { unsigned int v1:16; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aBFu16i_BFu0c_Ui { unsigned int v1:16; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aBFu16i_BFu0c_Ul { unsigned int v1:16; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu16i_BFu0c_Us { unsigned int v1:16; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aBFu16i_BFu0c_Vp { unsigned int v1:16; unsigned char :0; void * v2; };
struct __attribute__((packed)) aBFu16i_BFu0i { unsigned int v1:16; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu0c { unsigned int v1:16; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu0i { unsigned int v1:16; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu0ll { unsigned int v1:16; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu0s { unsigned int v1:16; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu15i { unsigned int v1:16; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu15ll { unsigned int v1:16; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu15s { unsigned int v1:16; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu16i { unsigned int v1:16; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu16ll { unsigned int v1:16; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu16s { unsigned int v1:16; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu17i { unsigned int v1:16; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu17ll { unsigned int v1:16; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu1c { unsigned int v1:16; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu1i { unsigned int v1:16; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu1ll { unsigned int v1:16; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu1s { unsigned int v1:16; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu31i { unsigned int v1:16; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu31ll { unsigned int v1:16; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu32i { unsigned int v1:16; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu32ll { unsigned int v1:16; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu33 { unsigned int v1:16; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu7c { unsigned int v1:16; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu7i { unsigned int v1:16; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu7ll { unsigned int v1:16; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu7s { unsigned int v1:16; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu8c { unsigned int v1:16; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu8i { unsigned int v1:16; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu8ll { unsigned int v1:16; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu8s { unsigned int v1:16; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu9i { unsigned int v1:16; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu9ll { unsigned int v1:16; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16i_BFu0i_BFu9s { unsigned int v1:16; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16i_BFu0i_C { unsigned int v1:16; unsigned int :0; char v2; };
struct __attribute__((packed)) aBFu16i_BFu0i_D { unsigned int v1:16; unsigned int :0; double v2; };
struct __attribute__((packed)) aBFu16i_BFu0i_F { unsigned int v1:16; unsigned int :0; float v2; };
struct __attribute__((packed)) aBFu16i_BFu0i_I { unsigned int v1:16; unsigned int :0; int v2; };
struct __attribute__((packed)) aBFu16i_BFu0i_Ip { unsigned int v1:16; unsigned int :0; int * v2; };
struct __attribute__((packed)) aBFu16i_BFu0i_L { unsigned int v1:16; unsigned int :0; long long v2; };
struct __attribute__((packed)) aBFu16i_BFu0i_S { unsigned int v1:16; unsigned int :0; short v2; };
struct __attribute__((packed)) aBFu16i_BFu0i_Uc { unsigned int v1:16; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aBFu16i_BFu0i_Ui { unsigned int v1:16; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aBFu16i_BFu0i_Ul { unsigned int v1:16; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu16i_BFu0i_Us { unsigned int v1:16; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aBFu16i_BFu0i_Vp { unsigned int v1:16; unsigned int :0; void * v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll { unsigned int v1:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu0c { unsigned int v1:16; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu0i { unsigned int v1:16; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu0ll { unsigned int v1:16; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu0s { unsigned int v1:16; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu15i { unsigned int v1:16; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu15ll { unsigned int v1:16; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu15s { unsigned int v1:16; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu16i { unsigned int v1:16; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu16ll { unsigned int v1:16; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu16s { unsigned int v1:16; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu17i { unsigned int v1:16; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu17ll { unsigned int v1:16; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu1c { unsigned int v1:16; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu1i { unsigned int v1:16; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu1ll { unsigned int v1:16; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu1s { unsigned int v1:16; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu31i { unsigned int v1:16; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu31ll { unsigned int v1:16; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu32i { unsigned int v1:16; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu32ll { unsigned int v1:16; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu33 { unsigned int v1:16; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu7c { unsigned int v1:16; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu7i { unsigned int v1:16; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu7ll { unsigned int v1:16; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu7s { unsigned int v1:16; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu8c { unsigned int v1:16; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu8i { unsigned int v1:16; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu8ll { unsigned int v1:16; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu8s { unsigned int v1:16; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu9i { unsigned int v1:16; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu9ll { unsigned int v1:16; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16i_BFu0ll_BFu9s { unsigned int v1:16; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16i_BFu0ll_C { unsigned int v1:16; unsigned long long :0; char v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll_D { unsigned int v1:16; unsigned long long :0; double v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll_F { unsigned int v1:16; unsigned long long :0; float v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll_I { unsigned int v1:16; unsigned long long :0; int v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll_Ip { unsigned int v1:16; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll_L { unsigned int v1:16; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll_S { unsigned int v1:16; unsigned long long :0; short v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll_Uc { unsigned int v1:16; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll_Ui { unsigned int v1:16; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll_Ul { unsigned int v1:16; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll_Us { unsigned int v1:16; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll_Vp { unsigned int v1:16; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aBFu16i_BFu0s { unsigned int v1:16; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu0c { unsigned int v1:16; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu0i { unsigned int v1:16; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu0ll { unsigned int v1:16; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu0s { unsigned int v1:16; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu15i { unsigned int v1:16; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu15ll { unsigned int v1:16; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu15s { unsigned int v1:16; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu16i { unsigned int v1:16; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu16ll { unsigned int v1:16; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu16s { unsigned int v1:16; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu17i { unsigned int v1:16; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu17ll { unsigned int v1:16; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu1c { unsigned int v1:16; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu1i { unsigned int v1:16; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu1ll { unsigned int v1:16; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu1s { unsigned int v1:16; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu31i { unsigned int v1:16; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu31ll { unsigned int v1:16; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu32i { unsigned int v1:16; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu32ll { unsigned int v1:16; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu33 { unsigned int v1:16; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu7c { unsigned int v1:16; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu7i { unsigned int v1:16; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu7ll { unsigned int v1:16; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu7s { unsigned int v1:16; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu8c { unsigned int v1:16; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu8i { unsigned int v1:16; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu8ll { unsigned int v1:16; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu8s { unsigned int v1:16; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu9i { unsigned int v1:16; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu9ll { unsigned int v1:16; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16i_BFu0s_BFu9s { unsigned int v1:16; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16i_BFu0s_C { unsigned int v1:16; unsigned short :0; char v2; };
struct __attribute__((packed)) aBFu16i_BFu0s_D { unsigned int v1:16; unsigned short :0; double v2; };
struct __attribute__((packed)) aBFu16i_BFu0s_F { unsigned int v1:16; unsigned short :0; float v2; };
struct __attribute__((packed)) aBFu16i_BFu0s_I { unsigned int v1:16; unsigned short :0; int v2; };
struct __attribute__((packed)) aBFu16i_BFu0s_Ip { unsigned int v1:16; unsigned short :0; int * v2; };
struct __attribute__((packed)) aBFu16i_BFu0s_L { unsigned int v1:16; unsigned short :0; long long v2; };
struct __attribute__((packed)) aBFu16i_BFu0s_S { unsigned int v1:16; unsigned short :0; short v2; };
struct __attribute__((packed)) aBFu16i_BFu0s_Uc { unsigned int v1:16; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aBFu16i_BFu0s_Ui { unsigned int v1:16; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aBFu16i_BFu0s_Ul { unsigned int v1:16; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu16i_BFu0s_Us { unsigned int v1:16; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aBFu16i_BFu0s_Vp { unsigned int v1:16; unsigned short :0; void * v2; };
struct __attribute__((packed)) aBFu16i_BFu15i_BFu0c { unsigned int v1:16; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu15i_BFu0i { unsigned int v1:16; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu15i_BFu0ll { unsigned int v1:16; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu15i_BFu0s { unsigned int v1:16; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu15ll_BFu0c { unsigned int v1:16; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu15ll_BFu0i { unsigned int v1:16; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu15ll_BFu0ll { unsigned int v1:16; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu15ll_BFu0s { unsigned int v1:16; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu15s_BFu0c { unsigned int v1:16; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu15s_BFu0i { unsigned int v1:16; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu15s_BFu0ll { unsigned int v1:16; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu15s_BFu0s { unsigned int v1:16; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu16i_BFu0c { unsigned int v1:16; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu16i_BFu0i { unsigned int v1:16; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu16i_BFu0ll { unsigned int v1:16; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu16i_BFu0s { unsigned int v1:16; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu16ll_BFu0c { unsigned int v1:16; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu16ll_BFu0i { unsigned int v1:16; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu16ll_BFu0ll { unsigned int v1:16; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu16ll_BFu0s { unsigned int v1:16; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu16s_BFu0c { unsigned int v1:16; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu16s_BFu0i { unsigned int v1:16; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu16s_BFu0ll { unsigned int v1:16; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu16s_BFu0s { unsigned int v1:16; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu17i_BFu0c { unsigned int v1:16; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu17i_BFu0i { unsigned int v1:16; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu17i_BFu0ll { unsigned int v1:16; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu17i_BFu0s { unsigned int v1:16; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu17ll_BFu0c { unsigned int v1:16; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu17ll_BFu0i { unsigned int v1:16; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu17ll_BFu0ll { unsigned int v1:16; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu17ll_BFu0s { unsigned int v1:16; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu1c_BFu0c { unsigned int v1:16; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu1c_BFu0i { unsigned int v1:16; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu1c_BFu0ll { unsigned int v1:16; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu1c_BFu0s { unsigned int v1:16; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu1i_BFu0c { unsigned int v1:16; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu1i_BFu0i { unsigned int v1:16; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu1i_BFu0ll { unsigned int v1:16; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu1i_BFu0s { unsigned int v1:16; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu1ll_BFu0c { unsigned int v1:16; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu1ll_BFu0i { unsigned int v1:16; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu1ll_BFu0ll { unsigned int v1:16; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu1ll_BFu0s { unsigned int v1:16; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu1s_BFu0c { unsigned int v1:16; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu1s_BFu0i { unsigned int v1:16; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu1s_BFu0ll { unsigned int v1:16; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu1s_BFu0s { unsigned int v1:16; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu31i_BFu0c { unsigned int v1:16; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu31i_BFu0i { unsigned int v1:16; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu31i_BFu0ll { unsigned int v1:16; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu31i_BFu0s { unsigned int v1:16; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu31ll_BFu0c { unsigned int v1:16; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu31ll_BFu0i { unsigned int v1:16; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu31ll_BFu0ll { unsigned int v1:16; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu31ll_BFu0s { unsigned int v1:16; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu32i_BFu0c { unsigned int v1:16; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu32i_BFu0i { unsigned int v1:16; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu32i_BFu0ll { unsigned int v1:16; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu32i_BFu0s { unsigned int v1:16; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu32ll_BFu0c { unsigned int v1:16; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu32ll_BFu0i { unsigned int v1:16; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu32ll_BFu0ll { unsigned int v1:16; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu32ll_BFu0s { unsigned int v1:16; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu33_BFu0c { unsigned int v1:16; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu33_BFu0i { unsigned int v1:16; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu33_BFu0ll { unsigned int v1:16; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu33_BFu0s { unsigned int v1:16; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu7c_BFu0c { unsigned int v1:16; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu7c_BFu0i { unsigned int v1:16; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu7c_BFu0ll { unsigned int v1:16; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu7c_BFu0s { unsigned int v1:16; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu7i_BFu0c { unsigned int v1:16; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu7i_BFu0i { unsigned int v1:16; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu7i_BFu0ll { unsigned int v1:16; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu7i_BFu0s { unsigned int v1:16; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu7ll_BFu0c { unsigned int v1:16; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu7ll_BFu0i { unsigned int v1:16; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu7ll_BFu0ll { unsigned int v1:16; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu7ll_BFu0s { unsigned int v1:16; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu7s_BFu0c { unsigned int v1:16; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu7s_BFu0i { unsigned int v1:16; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu7s_BFu0ll { unsigned int v1:16; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu7s_BFu0s { unsigned int v1:16; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu8c_BFu0c { unsigned int v1:16; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu8c_BFu0i { unsigned int v1:16; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu8c_BFu0ll { unsigned int v1:16; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu8c_BFu0s { unsigned int v1:16; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu8i_BFu0c { unsigned int v1:16; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu8i_BFu0i { unsigned int v1:16; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu8i_BFu0ll { unsigned int v1:16; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu8i_BFu0s { unsigned int v1:16; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu8ll_BFu0c { unsigned int v1:16; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu8ll_BFu0i { unsigned int v1:16; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu8ll_BFu0ll { unsigned int v1:16; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu8ll_BFu0s { unsigned int v1:16; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu8s_BFu0c { unsigned int v1:16; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu8s_BFu0i { unsigned int v1:16; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu8s_BFu0ll { unsigned int v1:16; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu8s_BFu0s { unsigned int v1:16; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu9i_BFu0c { unsigned int v1:16; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu9i_BFu0i { unsigned int v1:16; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu9i_BFu0ll { unsigned int v1:16; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu9i_BFu0s { unsigned int v1:16; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu9ll_BFu0c { unsigned int v1:16; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu9ll_BFu0i { unsigned int v1:16; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu9ll_BFu0ll { unsigned int v1:16; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu9ll_BFu0s { unsigned int v1:16; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu9s_BFu0c { unsigned int v1:16; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_BFu9s_BFu0i { unsigned int v1:16; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_BFu9s_BFu0ll { unsigned int v1:16; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_BFu9s_BFu0s { unsigned int v1:16; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_C_BFu0c { unsigned int v1:16; char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_C_BFu0i { unsigned int v1:16; char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_C_BFu0ll { unsigned int v1:16; char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_C_BFu0s { unsigned int v1:16; char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_D_BFu0c { unsigned int v1:16; double v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_D_BFu0i { unsigned int v1:16; double v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_D_BFu0ll { unsigned int v1:16; double v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_D_BFu0s { unsigned int v1:16; double v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_F_BFu0c { unsigned int v1:16; float v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_F_BFu0i { unsigned int v1:16; float v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_F_BFu0ll { unsigned int v1:16; float v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_F_BFu0s { unsigned int v1:16; float v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_I_BFu0c { unsigned int v1:16; int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_I_BFu0i { unsigned int v1:16; int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_I_BFu0ll { unsigned int v1:16; int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_I_BFu0s { unsigned int v1:16; int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_Ip_BFu0c { unsigned int v1:16; int * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_Ip_BFu0i { unsigned int v1:16; int * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_Ip_BFu0ll { unsigned int v1:16; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_Ip_BFu0s { unsigned int v1:16; int * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_L_BFu0c { unsigned int v1:16; long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_L_BFu0i { unsigned int v1:16; long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_L_BFu0ll { unsigned int v1:16; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_L_BFu0s { unsigned int v1:16; long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_S_BFu0c { unsigned int v1:16; short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_S_BFu0i { unsigned int v1:16; short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_S_BFu0ll { unsigned int v1:16; short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_S_BFu0s { unsigned int v1:16; short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_Uc_BFu0c { unsigned int v1:16; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_Uc_BFu0i { unsigned int v1:16; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_Uc_BFu0ll { unsigned int v1:16; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_Uc_BFu0s { unsigned int v1:16; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_Ui_BFu0c { unsigned int v1:16; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_Ui_BFu0i { unsigned int v1:16; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_Ui_BFu0ll { unsigned int v1:16; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_Ui_BFu0s { unsigned int v1:16; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_Ul_BFu0c { unsigned int v1:16; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_Ul_BFu0i { unsigned int v1:16; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_Ul_BFu0ll { unsigned int v1:16; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_Ul_BFu0s { unsigned int v1:16; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_Us_BFu0c { unsigned int v1:16; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_Us_BFu0i { unsigned int v1:16; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_Us_BFu0ll { unsigned int v1:16; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_Us_BFu0s { unsigned int v1:16; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_Vp_BFu0c { unsigned int v1:16; void * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_Vp_BFu0i { unsigned int v1:16; void * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_Vp_BFu0ll { unsigned int v1:16; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_Vp_BFu0s { unsigned int v1:16; void * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu0c { unsigned long long v1:16; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu0c { unsigned long long v1:16; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu0i { unsigned long long v1:16; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu0ll { unsigned long long v1:16; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu0s { unsigned long long v1:16; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu15i { unsigned long long v1:16; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu15ll { unsigned long long v1:16; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu15s { unsigned long long v1:16; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu16i { unsigned long long v1:16; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu16ll { unsigned long long v1:16; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu16s { unsigned long long v1:16; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu17i { unsigned long long v1:16; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu17ll { unsigned long long v1:16; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu1c { unsigned long long v1:16; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu1i { unsigned long long v1:16; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu1ll { unsigned long long v1:16; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu1s { unsigned long long v1:16; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu31i { unsigned long long v1:16; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu31ll { unsigned long long v1:16; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu32i { unsigned long long v1:16; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu32ll { unsigned long long v1:16; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu33 { unsigned long long v1:16; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu7c { unsigned long long v1:16; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu7i { unsigned long long v1:16; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu7ll { unsigned long long v1:16; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu7s { unsigned long long v1:16; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu8c { unsigned long long v1:16; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu8i { unsigned long long v1:16; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu8ll { unsigned long long v1:16; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu8s { unsigned long long v1:16; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu9i { unsigned long long v1:16; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu9ll { unsigned long long v1:16; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu0c_BFu9s { unsigned long long v1:16; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu0c_C { unsigned long long v1:16; unsigned char :0; char v2; };
struct __attribute__((packed)) aBFu16ll_BFu0c_D { unsigned long long v1:16; unsigned char :0; double v2; };
struct __attribute__((packed)) aBFu16ll_BFu0c_F { unsigned long long v1:16; unsigned char :0; float v2; };
struct __attribute__((packed)) aBFu16ll_BFu0c_I { unsigned long long v1:16; unsigned char :0; int v2; };
struct __attribute__((packed)) aBFu16ll_BFu0c_Ip { unsigned long long v1:16; unsigned char :0; int * v2; };
struct __attribute__((packed)) aBFu16ll_BFu0c_L { unsigned long long v1:16; unsigned char :0; long long v2; };
struct __attribute__((packed)) aBFu16ll_BFu0c_S { unsigned long long v1:16; unsigned char :0; short v2; };
struct __attribute__((packed)) aBFu16ll_BFu0c_Uc { unsigned long long v1:16; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aBFu16ll_BFu0c_Ui { unsigned long long v1:16; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aBFu16ll_BFu0c_Ul { unsigned long long v1:16; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu16ll_BFu0c_Us { unsigned long long v1:16; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aBFu16ll_BFu0c_Vp { unsigned long long v1:16; unsigned char :0; void * v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i { unsigned long long v1:16; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu0c { unsigned long long v1:16; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu0i { unsigned long long v1:16; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu0ll { unsigned long long v1:16; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu0s { unsigned long long v1:16; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu15i { unsigned long long v1:16; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu15ll { unsigned long long v1:16; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu15s { unsigned long long v1:16; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu16i { unsigned long long v1:16; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu16ll { unsigned long long v1:16; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu16s { unsigned long long v1:16; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu17i { unsigned long long v1:16; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu17ll { unsigned long long v1:16; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu1c { unsigned long long v1:16; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu1i { unsigned long long v1:16; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu1ll { unsigned long long v1:16; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu1s { unsigned long long v1:16; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu31i { unsigned long long v1:16; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu31ll { unsigned long long v1:16; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu32i { unsigned long long v1:16; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu32ll { unsigned long long v1:16; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu33 { unsigned long long v1:16; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu7c { unsigned long long v1:16; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu7i { unsigned long long v1:16; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu7ll { unsigned long long v1:16; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu7s { unsigned long long v1:16; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu8c { unsigned long long v1:16; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu8i { unsigned long long v1:16; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu8ll { unsigned long long v1:16; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu8s { unsigned long long v1:16; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu9i { unsigned long long v1:16; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu9ll { unsigned long long v1:16; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu0i_BFu9s { unsigned long long v1:16; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu0i_C { unsigned long long v1:16; unsigned int :0; char v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i_D { unsigned long long v1:16; unsigned int :0; double v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i_F { unsigned long long v1:16; unsigned int :0; float v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i_I { unsigned long long v1:16; unsigned int :0; int v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i_Ip { unsigned long long v1:16; unsigned int :0; int * v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i_L { unsigned long long v1:16; unsigned int :0; long long v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i_S { unsigned long long v1:16; unsigned int :0; short v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i_Uc { unsigned long long v1:16; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i_Ui { unsigned long long v1:16; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i_Ul { unsigned long long v1:16; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i_Us { unsigned long long v1:16; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i_Vp { unsigned long long v1:16; unsigned int :0; void * v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll { unsigned long long v1:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu0c { unsigned long long v1:16; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu0i { unsigned long long v1:16; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu0ll { unsigned long long v1:16; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu0s { unsigned long long v1:16; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu15i { unsigned long long v1:16; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu15ll { unsigned long long v1:16; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu15s { unsigned long long v1:16; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu16i { unsigned long long v1:16; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu16ll { unsigned long long v1:16; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu16s { unsigned long long v1:16; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu17i { unsigned long long v1:16; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu17ll { unsigned long long v1:16; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu1c { unsigned long long v1:16; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu1i { unsigned long long v1:16; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu1ll { unsigned long long v1:16; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu1s { unsigned long long v1:16; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu31i { unsigned long long v1:16; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu31ll { unsigned long long v1:16; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu32i { unsigned long long v1:16; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu32ll { unsigned long long v1:16; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu33 { unsigned long long v1:16; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu7c { unsigned long long v1:16; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu7i { unsigned long long v1:16; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu7ll { unsigned long long v1:16; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu7s { unsigned long long v1:16; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu8c { unsigned long long v1:16; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu8i { unsigned long long v1:16; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu8ll { unsigned long long v1:16; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu8s { unsigned long long v1:16; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu9i { unsigned long long v1:16; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu9ll { unsigned long long v1:16; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_BFu9s { unsigned long long v1:16; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_C { unsigned long long v1:16; unsigned long long :0; char v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_D { unsigned long long v1:16; unsigned long long :0; double v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_F { unsigned long long v1:16; unsigned long long :0; float v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_I { unsigned long long v1:16; unsigned long long :0; int v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_Ip { unsigned long long v1:16; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_L { unsigned long long v1:16; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_S { unsigned long long v1:16; unsigned long long :0; short v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_Uc { unsigned long long v1:16; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_Ui { unsigned long long v1:16; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_Ul { unsigned long long v1:16; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_Us { unsigned long long v1:16; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_Vp { unsigned long long v1:16; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s { unsigned long long v1:16; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu0c { unsigned long long v1:16; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu0i { unsigned long long v1:16; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu0ll { unsigned long long v1:16; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu0s { unsigned long long v1:16; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu15i { unsigned long long v1:16; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu15ll { unsigned long long v1:16; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu15s { unsigned long long v1:16; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu16i { unsigned long long v1:16; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu16ll { unsigned long long v1:16; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu16s { unsigned long long v1:16; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu17i { unsigned long long v1:16; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu17ll { unsigned long long v1:16; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu1c { unsigned long long v1:16; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu1i { unsigned long long v1:16; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu1ll { unsigned long long v1:16; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu1s { unsigned long long v1:16; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu31i { unsigned long long v1:16; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu31ll { unsigned long long v1:16; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu32i { unsigned long long v1:16; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu32ll { unsigned long long v1:16; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu33 { unsigned long long v1:16; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu7c { unsigned long long v1:16; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu7i { unsigned long long v1:16; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu7ll { unsigned long long v1:16; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu7s { unsigned long long v1:16; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu8c { unsigned long long v1:16; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu8i { unsigned long long v1:16; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu8ll { unsigned long long v1:16; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu8s { unsigned long long v1:16; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu9i { unsigned long long v1:16; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu9ll { unsigned long long v1:16; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu0s_BFu9s { unsigned long long v1:16; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu0s_C { unsigned long long v1:16; unsigned short :0; char v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s_D { unsigned long long v1:16; unsigned short :0; double v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s_F { unsigned long long v1:16; unsigned short :0; float v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s_I { unsigned long long v1:16; unsigned short :0; int v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s_Ip { unsigned long long v1:16; unsigned short :0; int * v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s_L { unsigned long long v1:16; unsigned short :0; long long v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s_S { unsigned long long v1:16; unsigned short :0; short v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s_Uc { unsigned long long v1:16; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s_Ui { unsigned long long v1:16; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s_Ul { unsigned long long v1:16; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s_Us { unsigned long long v1:16; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s_Vp { unsigned long long v1:16; unsigned short :0; void * v2; };
struct __attribute__((packed)) aBFu16ll_BFu15i_BFu0c { unsigned long long v1:16; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu15i_BFu0i { unsigned long long v1:16; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu15i_BFu0ll { unsigned long long v1:16; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu15i_BFu0s { unsigned long long v1:16; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu15ll_BFu0c { unsigned long long v1:16; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu15ll_BFu0i { unsigned long long v1:16; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu15ll_BFu0ll { unsigned long long v1:16; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu15ll_BFu0s { unsigned long long v1:16; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu15s_BFu0c { unsigned long long v1:16; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu15s_BFu0i { unsigned long long v1:16; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu15s_BFu0ll { unsigned long long v1:16; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu15s_BFu0s { unsigned long long v1:16; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu16i_BFu0c { unsigned long long v1:16; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu16i_BFu0i { unsigned long long v1:16; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu16i_BFu0ll { unsigned long long v1:16; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu16i_BFu0s { unsigned long long v1:16; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu16ll_BFu0c { unsigned long long v1:16; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu16ll_BFu0i { unsigned long long v1:16; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu16ll_BFu0ll { unsigned long long v1:16; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu16ll_BFu0s { unsigned long long v1:16; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu16s_BFu0c { unsigned long long v1:16; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu16s_BFu0i { unsigned long long v1:16; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu16s_BFu0ll { unsigned long long v1:16; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu16s_BFu0s { unsigned long long v1:16; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu17i_BFu0c { unsigned long long v1:16; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu17i_BFu0i { unsigned long long v1:16; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu17i_BFu0ll { unsigned long long v1:16; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu17i_BFu0s { unsigned long long v1:16; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu17ll_BFu0c { unsigned long long v1:16; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu17ll_BFu0i { unsigned long long v1:16; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu17ll_BFu0ll { unsigned long long v1:16; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu17ll_BFu0s { unsigned long long v1:16; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu0c { unsigned long long v1:16; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu0i { unsigned long long v1:16; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu0ll { unsigned long long v1:16; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu0s { unsigned long long v1:16; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu0c { unsigned long long v1:16; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu0i { unsigned long long v1:16; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu0ll { unsigned long long v1:16; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu0s { unsigned long long v1:16; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu0c { unsigned long long v1:16; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu0i { unsigned long long v1:16; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu0ll { unsigned long long v1:16; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu0s { unsigned long long v1:16; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu0c { unsigned long long v1:16; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu0i { unsigned long long v1:16; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu0ll { unsigned long long v1:16; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu0s { unsigned long long v1:16; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu0c { unsigned long long v1:16; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu0i { unsigned long long v1:16; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu0ll { unsigned long long v1:16; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu0s { unsigned long long v1:16; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu0c { unsigned long long v1:16; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu0i { unsigned long long v1:16; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu0ll { unsigned long long v1:16; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu0s { unsigned long long v1:16; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu0c { unsigned long long v1:16; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu0i { unsigned long long v1:16; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu0ll { unsigned long long v1:16; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu0s { unsigned long long v1:16; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu0c { unsigned long long v1:16; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu0i { unsigned long long v1:16; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu0ll { unsigned long long v1:16; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu0s { unsigned long long v1:16; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu0c { unsigned long long v1:16; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu0i { unsigned long long v1:16; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu0ll { unsigned long long v1:16; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu0s { unsigned long long v1:16; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu0c { unsigned long long v1:16; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu0i { unsigned long long v1:16; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu0ll { unsigned long long v1:16; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu0s { unsigned long long v1:16; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu0c { unsigned long long v1:16; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu0i { unsigned long long v1:16; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu0ll { unsigned long long v1:16; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu0s { unsigned long long v1:16; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu0c { unsigned long long v1:16; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu0i { unsigned long long v1:16; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu0ll { unsigned long long v1:16; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu0s { unsigned long long v1:16; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu0c { unsigned long long v1:16; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu0i { unsigned long long v1:16; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu0ll { unsigned long long v1:16; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu0s { unsigned long long v1:16; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu0c { unsigned long long v1:16; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu0i { unsigned long long v1:16; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu0ll { unsigned long long v1:16; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu0s { unsigned long long v1:16; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu0c { unsigned long long v1:16; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu0i { unsigned long long v1:16; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu0ll { unsigned long long v1:16; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu0s { unsigned long long v1:16; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu0c { unsigned long long v1:16; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu0i { unsigned long long v1:16; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu0ll { unsigned long long v1:16; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu0s { unsigned long long v1:16; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu0c { unsigned long long v1:16; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu0i { unsigned long long v1:16; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu0ll { unsigned long long v1:16; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu0s { unsigned long long v1:16; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu0c { unsigned long long v1:16; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu0i { unsigned long long v1:16; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu0ll { unsigned long long v1:16; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu0s { unsigned long long v1:16; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu0c { unsigned long long v1:16; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu0i { unsigned long long v1:16; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu0ll { unsigned long long v1:16; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu0s { unsigned long long v1:16; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu0c { unsigned long long v1:16; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu0i { unsigned long long v1:16; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu0ll { unsigned long long v1:16; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu0s { unsigned long long v1:16; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_C_BFu0c { unsigned long long v1:16; char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_C_BFu0i { unsigned long long v1:16; char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_C_BFu0ll { unsigned long long v1:16; char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_C_BFu0s { unsigned long long v1:16; char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_D_BFu0c { unsigned long long v1:16; double v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_D_BFu0i { unsigned long long v1:16; double v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_D_BFu0ll { unsigned long long v1:16; double v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_D_BFu0s { unsigned long long v1:16; double v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_F_BFu0c { unsigned long long v1:16; float v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_F_BFu0i { unsigned long long v1:16; float v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_F_BFu0ll { unsigned long long v1:16; float v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_F_BFu0s { unsigned long long v1:16; float v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_I_BFu0c { unsigned long long v1:16; int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_I_BFu0i { unsigned long long v1:16; int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_I_BFu0ll { unsigned long long v1:16; int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_I_BFu0s { unsigned long long v1:16; int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu0c { unsigned long long v1:16; int * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu0i { unsigned long long v1:16; int * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu0ll { unsigned long long v1:16; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu0s { unsigned long long v1:16; int * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_L_BFu0c { unsigned long long v1:16; long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_L_BFu0i { unsigned long long v1:16; long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_L_BFu0ll { unsigned long long v1:16; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_L_BFu0s { unsigned long long v1:16; long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_S_BFu0c { unsigned long long v1:16; short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_S_BFu0i { unsigned long long v1:16; short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_S_BFu0ll { unsigned long long v1:16; short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_S_BFu0s { unsigned long long v1:16; short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu0c { unsigned long long v1:16; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu0i { unsigned long long v1:16; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu0ll { unsigned long long v1:16; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu0s { unsigned long long v1:16; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu0c { unsigned long long v1:16; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu0i { unsigned long long v1:16; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu0ll { unsigned long long v1:16; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu0s { unsigned long long v1:16; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu0c { unsigned long long v1:16; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu0i { unsigned long long v1:16; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu0ll { unsigned long long v1:16; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu0s { unsigned long long v1:16; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_Us_BFu0c { unsigned long long v1:16; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_Us_BFu0i { unsigned long long v1:16; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_Us_BFu0ll { unsigned long long v1:16; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_Us_BFu0s { unsigned long long v1:16; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu0c { unsigned long long v1:16; void * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu0i { unsigned long long v1:16; void * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu0ll { unsigned long long v1:16; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu0s { unsigned long long v1:16; void * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu0c { unsigned short v1:16; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu0c { unsigned short v1:16; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu0i { unsigned short v1:16; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu0ll { unsigned short v1:16; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu0s { unsigned short v1:16; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu15i { unsigned short v1:16; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu15ll { unsigned short v1:16; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu15s { unsigned short v1:16; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu16i { unsigned short v1:16; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu16ll { unsigned short v1:16; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu16s { unsigned short v1:16; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu17i { unsigned short v1:16; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu17ll { unsigned short v1:16; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu1c { unsigned short v1:16; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu1i { unsigned short v1:16; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu1ll { unsigned short v1:16; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu1s { unsigned short v1:16; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu31i { unsigned short v1:16; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu31ll { unsigned short v1:16; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu32i { unsigned short v1:16; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu32ll { unsigned short v1:16; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu33 { unsigned short v1:16; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu7c { unsigned short v1:16; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu7i { unsigned short v1:16; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu7ll { unsigned short v1:16; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu7s { unsigned short v1:16; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu8c { unsigned short v1:16; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu8i { unsigned short v1:16; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu8ll { unsigned short v1:16; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu8s { unsigned short v1:16; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu9i { unsigned short v1:16; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu9ll { unsigned short v1:16; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16s_BFu0c_BFu9s { unsigned short v1:16; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16s_BFu0c_C { unsigned short v1:16; unsigned char :0; char v2; };
struct __attribute__((packed)) aBFu16s_BFu0c_D { unsigned short v1:16; unsigned char :0; double v2; };
struct __attribute__((packed)) aBFu16s_BFu0c_F { unsigned short v1:16; unsigned char :0; float v2; };
struct __attribute__((packed)) aBFu16s_BFu0c_I { unsigned short v1:16; unsigned char :0; int v2; };
struct __attribute__((packed)) aBFu16s_BFu0c_Ip { unsigned short v1:16; unsigned char :0; int * v2; };
struct __attribute__((packed)) aBFu16s_BFu0c_L { unsigned short v1:16; unsigned char :0; long long v2; };
struct __attribute__((packed)) aBFu16s_BFu0c_S { unsigned short v1:16; unsigned char :0; short v2; };
struct __attribute__((packed)) aBFu16s_BFu0c_Uc { unsigned short v1:16; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aBFu16s_BFu0c_Ui { unsigned short v1:16; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aBFu16s_BFu0c_Ul { unsigned short v1:16; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu16s_BFu0c_Us { unsigned short v1:16; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aBFu16s_BFu0c_Vp { unsigned short v1:16; unsigned char :0; void * v2; };
struct __attribute__((packed)) aBFu16s_BFu0i { unsigned short v1:16; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu0c { unsigned short v1:16; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu0i { unsigned short v1:16; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu0ll { unsigned short v1:16; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu0s { unsigned short v1:16; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu15i { unsigned short v1:16; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu15ll { unsigned short v1:16; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu15s { unsigned short v1:16; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu16i { unsigned short v1:16; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu16ll { unsigned short v1:16; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu16s { unsigned short v1:16; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu17i { unsigned short v1:16; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu17ll { unsigned short v1:16; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu1c { unsigned short v1:16; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu1i { unsigned short v1:16; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu1ll { unsigned short v1:16; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu1s { unsigned short v1:16; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu31i { unsigned short v1:16; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu31ll { unsigned short v1:16; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu32i { unsigned short v1:16; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu32ll { unsigned short v1:16; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu33 { unsigned short v1:16; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu7c { unsigned short v1:16; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu7i { unsigned short v1:16; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu7ll { unsigned short v1:16; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu7s { unsigned short v1:16; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu8c { unsigned short v1:16; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu8i { unsigned short v1:16; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu8ll { unsigned short v1:16; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu8s { unsigned short v1:16; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu9i { unsigned short v1:16; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu9ll { unsigned short v1:16; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16s_BFu0i_BFu9s { unsigned short v1:16; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16s_BFu0i_C { unsigned short v1:16; unsigned int :0; char v2; };
struct __attribute__((packed)) aBFu16s_BFu0i_D { unsigned short v1:16; unsigned int :0; double v2; };
struct __attribute__((packed)) aBFu16s_BFu0i_F { unsigned short v1:16; unsigned int :0; float v2; };
struct __attribute__((packed)) aBFu16s_BFu0i_I { unsigned short v1:16; unsigned int :0; int v2; };
struct __attribute__((packed)) aBFu16s_BFu0i_Ip { unsigned short v1:16; unsigned int :0; int * v2; };
struct __attribute__((packed)) aBFu16s_BFu0i_L { unsigned short v1:16; unsigned int :0; long long v2; };
struct __attribute__((packed)) aBFu16s_BFu0i_S { unsigned short v1:16; unsigned int :0; short v2; };
struct __attribute__((packed)) aBFu16s_BFu0i_Uc { unsigned short v1:16; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aBFu16s_BFu0i_Ui { unsigned short v1:16; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aBFu16s_BFu0i_Ul { unsigned short v1:16; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu16s_BFu0i_Us { unsigned short v1:16; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aBFu16s_BFu0i_Vp { unsigned short v1:16; unsigned int :0; void * v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll { unsigned short v1:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu0c { unsigned short v1:16; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu0i { unsigned short v1:16; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu0ll { unsigned short v1:16; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu0s { unsigned short v1:16; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu15i { unsigned short v1:16; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu15ll { unsigned short v1:16; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu15s { unsigned short v1:16; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu16i { unsigned short v1:16; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu16ll { unsigned short v1:16; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu16s { unsigned short v1:16; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu17i { unsigned short v1:16; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu17ll { unsigned short v1:16; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu1c { unsigned short v1:16; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu1i { unsigned short v1:16; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu1ll { unsigned short v1:16; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu1s { unsigned short v1:16; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu31i { unsigned short v1:16; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu31ll { unsigned short v1:16; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu32i { unsigned short v1:16; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu32ll { unsigned short v1:16; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu33 { unsigned short v1:16; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu7c { unsigned short v1:16; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu7i { unsigned short v1:16; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu7ll { unsigned short v1:16; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu7s { unsigned short v1:16; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu8c { unsigned short v1:16; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu8i { unsigned short v1:16; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu8ll { unsigned short v1:16; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu8s { unsigned short v1:16; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu9i { unsigned short v1:16; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu9ll { unsigned short v1:16; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16s_BFu0ll_BFu9s { unsigned short v1:16; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16s_BFu0ll_C { unsigned short v1:16; unsigned long long :0; char v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll_D { unsigned short v1:16; unsigned long long :0; double v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll_F { unsigned short v1:16; unsigned long long :0; float v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll_I { unsigned short v1:16; unsigned long long :0; int v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll_Ip { unsigned short v1:16; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll_L { unsigned short v1:16; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll_S { unsigned short v1:16; unsigned long long :0; short v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll_Uc { unsigned short v1:16; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll_Ui { unsigned short v1:16; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll_Ul { unsigned short v1:16; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll_Us { unsigned short v1:16; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll_Vp { unsigned short v1:16; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aBFu16s_BFu0s { unsigned short v1:16; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu0c { unsigned short v1:16; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu0i { unsigned short v1:16; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu0ll { unsigned short v1:16; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu0s { unsigned short v1:16; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu15i { unsigned short v1:16; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu15ll { unsigned short v1:16; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu15s { unsigned short v1:16; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu16i { unsigned short v1:16; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu16ll { unsigned short v1:16; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu16s { unsigned short v1:16; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu17i { unsigned short v1:16; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu17ll { unsigned short v1:16; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu1c { unsigned short v1:16; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu1i { unsigned short v1:16; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu1ll { unsigned short v1:16; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu1s { unsigned short v1:16; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu31i { unsigned short v1:16; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu31ll { unsigned short v1:16; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu32i { unsigned short v1:16; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu32ll { unsigned short v1:16; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu33 { unsigned short v1:16; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu7c { unsigned short v1:16; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu7i { unsigned short v1:16; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu7ll { unsigned short v1:16; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu7s { unsigned short v1:16; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu8c { unsigned short v1:16; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu8i { unsigned short v1:16; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu8ll { unsigned short v1:16; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu8s { unsigned short v1:16; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu9i { unsigned short v1:16; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu9ll { unsigned short v1:16; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16s_BFu0s_BFu9s { unsigned short v1:16; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16s_BFu0s_C { unsigned short v1:16; unsigned short :0; char v2; };
struct __attribute__((packed)) aBFu16s_BFu0s_D { unsigned short v1:16; unsigned short :0; double v2; };
struct __attribute__((packed)) aBFu16s_BFu0s_F { unsigned short v1:16; unsigned short :0; float v2; };
struct __attribute__((packed)) aBFu16s_BFu0s_I { unsigned short v1:16; unsigned short :0; int v2; };
struct __attribute__((packed)) aBFu16s_BFu0s_Ip { unsigned short v1:16; unsigned short :0; int * v2; };
struct __attribute__((packed)) aBFu16s_BFu0s_L { unsigned short v1:16; unsigned short :0; long long v2; };
struct __attribute__((packed)) aBFu16s_BFu0s_S { unsigned short v1:16; unsigned short :0; short v2; };
struct __attribute__((packed)) aBFu16s_BFu0s_Uc { unsigned short v1:16; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aBFu16s_BFu0s_Ui { unsigned short v1:16; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aBFu16s_BFu0s_Ul { unsigned short v1:16; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu16s_BFu0s_Us { unsigned short v1:16; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aBFu16s_BFu0s_Vp { unsigned short v1:16; unsigned short :0; void * v2; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu0c { unsigned short v1:16; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu0i { unsigned short v1:16; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu0ll { unsigned short v1:16; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu0s { unsigned short v1:16; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu0c { unsigned short v1:16; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu0i { unsigned short v1:16; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu0ll { unsigned short v1:16; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu0s { unsigned short v1:16; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu0c { unsigned short v1:16; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu0i { unsigned short v1:16; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu0ll { unsigned short v1:16; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu0s { unsigned short v1:16; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu0c { unsigned short v1:16; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu0i { unsigned short v1:16; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu0ll { unsigned short v1:16; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu0s { unsigned short v1:16; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu0c { unsigned short v1:16; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu0i { unsigned short v1:16; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu0ll { unsigned short v1:16; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu0s { unsigned short v1:16; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu0c { unsigned short v1:16; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu0i { unsigned short v1:16; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu0ll { unsigned short v1:16; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu0s { unsigned short v1:16; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu0c { unsigned short v1:16; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu0i { unsigned short v1:16; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu0ll { unsigned short v1:16; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu0s { unsigned short v1:16; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu0c { unsigned short v1:16; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu0i { unsigned short v1:16; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu0ll { unsigned short v1:16; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu0s { unsigned short v1:16; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu0c { unsigned short v1:16; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu0i { unsigned short v1:16; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu0ll { unsigned short v1:16; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu0s { unsigned short v1:16; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu0c { unsigned short v1:16; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu0i { unsigned short v1:16; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu0ll { unsigned short v1:16; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu0s { unsigned short v1:16; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu0c { unsigned short v1:16; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu0i { unsigned short v1:16; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu0ll { unsigned short v1:16; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu0s { unsigned short v1:16; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu0c { unsigned short v1:16; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu0i { unsigned short v1:16; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu0ll { unsigned short v1:16; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu0s { unsigned short v1:16; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu0c { unsigned short v1:16; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu0i { unsigned short v1:16; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu0ll { unsigned short v1:16; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu0s { unsigned short v1:16; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu0c { unsigned short v1:16; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu0i { unsigned short v1:16; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu0ll { unsigned short v1:16; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu0s { unsigned short v1:16; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu0c { unsigned short v1:16; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu0i { unsigned short v1:16; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu0ll { unsigned short v1:16; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu0s { unsigned short v1:16; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu0c { unsigned short v1:16; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu0i { unsigned short v1:16; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu0ll { unsigned short v1:16; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu0s { unsigned short v1:16; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu0c { unsigned short v1:16; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu0i { unsigned short v1:16; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu0ll { unsigned short v1:16; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu0s { unsigned short v1:16; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu0c { unsigned short v1:16; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu0i { unsigned short v1:16; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu0ll { unsigned short v1:16; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu0s { unsigned short v1:16; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu0c { unsigned short v1:16; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu0i { unsigned short v1:16; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu0ll { unsigned short v1:16; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu0s { unsigned short v1:16; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu0c { unsigned short v1:16; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu0i { unsigned short v1:16; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu0ll { unsigned short v1:16; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu0s { unsigned short v1:16; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu0c { unsigned short v1:16; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu0i { unsigned short v1:16; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu0ll { unsigned short v1:16; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu0s { unsigned short v1:16; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu0c { unsigned short v1:16; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu0i { unsigned short v1:16; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu0ll { unsigned short v1:16; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu0s { unsigned short v1:16; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu0c { unsigned short v1:16; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu0i { unsigned short v1:16; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu0ll { unsigned short v1:16; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu0s { unsigned short v1:16; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu0c { unsigned short v1:16; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu0i { unsigned short v1:16; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu0ll { unsigned short v1:16; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu0s { unsigned short v1:16; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu0c { unsigned short v1:16; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu0i { unsigned short v1:16; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu0ll { unsigned short v1:16; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu0s { unsigned short v1:16; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu0c { unsigned short v1:16; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu0i { unsigned short v1:16; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu0ll { unsigned short v1:16; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu0s { unsigned short v1:16; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu0c { unsigned short v1:16; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu0i { unsigned short v1:16; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu0ll { unsigned short v1:16; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu0s { unsigned short v1:16; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu0c { unsigned short v1:16; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu0i { unsigned short v1:16; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu0ll { unsigned short v1:16; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu0s { unsigned short v1:16; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_C_BFu0c { unsigned short v1:16; char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_C_BFu0i { unsigned short v1:16; char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_C_BFu0ll { unsigned short v1:16; char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_C_BFu0s { unsigned short v1:16; char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_D_BFu0c { unsigned short v1:16; double v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_D_BFu0i { unsigned short v1:16; double v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_D_BFu0ll { unsigned short v1:16; double v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_D_BFu0s { unsigned short v1:16; double v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_F_BFu0c { unsigned short v1:16; float v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_F_BFu0i { unsigned short v1:16; float v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_F_BFu0ll { unsigned short v1:16; float v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_F_BFu0s { unsigned short v1:16; float v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_I_BFu0c { unsigned short v1:16; int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_I_BFu0i { unsigned short v1:16; int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_I_BFu0ll { unsigned short v1:16; int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_I_BFu0s { unsigned short v1:16; int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_Ip_BFu0c { unsigned short v1:16; int * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_Ip_BFu0i { unsigned short v1:16; int * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_Ip_BFu0ll { unsigned short v1:16; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_Ip_BFu0s { unsigned short v1:16; int * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_L_BFu0c { unsigned short v1:16; long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_L_BFu0i { unsigned short v1:16; long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_L_BFu0ll { unsigned short v1:16; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_L_BFu0s { unsigned short v1:16; long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_S_BFu0c { unsigned short v1:16; short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_S_BFu0i { unsigned short v1:16; short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_S_BFu0ll { unsigned short v1:16; short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_S_BFu0s { unsigned short v1:16; short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_Uc_BFu0c { unsigned short v1:16; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_Uc_BFu0i { unsigned short v1:16; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_Uc_BFu0ll { unsigned short v1:16; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_Uc_BFu0s { unsigned short v1:16; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_Ui_BFu0c { unsigned short v1:16; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_Ui_BFu0i { unsigned short v1:16; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_Ui_BFu0ll { unsigned short v1:16; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_Ui_BFu0s { unsigned short v1:16; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_Ul_BFu0c { unsigned short v1:16; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_Ul_BFu0i { unsigned short v1:16; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_Ul_BFu0ll { unsigned short v1:16; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_Ul_BFu0s { unsigned short v1:16; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_Us_BFu0c { unsigned short v1:16; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_Us_BFu0i { unsigned short v1:16; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_Us_BFu0ll { unsigned short v1:16; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_Us_BFu0s { unsigned short v1:16; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_Vp_BFu0c { unsigned short v1:16; void * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_Vp_BFu0i { unsigned short v1:16; void * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_Vp_BFu0ll { unsigned short v1:16; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_Vp_BFu0s { unsigned short v1:16; void * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu0c { unsigned int v1:17; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu0c { unsigned int v1:17; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu0i { unsigned int v1:17; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu0ll { unsigned int v1:17; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu0s { unsigned int v1:17; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu15i { unsigned int v1:17; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu15ll { unsigned int v1:17; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu15s { unsigned int v1:17; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu16i { unsigned int v1:17; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu16ll { unsigned int v1:17; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu16s { unsigned int v1:17; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu17i { unsigned int v1:17; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu17ll { unsigned int v1:17; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu1c { unsigned int v1:17; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu1i { unsigned int v1:17; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu1ll { unsigned int v1:17; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu1s { unsigned int v1:17; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu31i { unsigned int v1:17; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu31ll { unsigned int v1:17; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu32i { unsigned int v1:17; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu32ll { unsigned int v1:17; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu33 { unsigned int v1:17; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu7c { unsigned int v1:17; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu7i { unsigned int v1:17; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu7ll { unsigned int v1:17; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu7s { unsigned int v1:17; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu8c { unsigned int v1:17; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu8i { unsigned int v1:17; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu8ll { unsigned int v1:17; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu8s { unsigned int v1:17; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu9i { unsigned int v1:17; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu9ll { unsigned int v1:17; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu17i_BFu0c_BFu9s { unsigned int v1:17; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu17i_BFu0c_C { unsigned int v1:17; unsigned char :0; char v2; };
struct __attribute__((packed)) aBFu17i_BFu0c_D { unsigned int v1:17; unsigned char :0; double v2; };
struct __attribute__((packed)) aBFu17i_BFu0c_F { unsigned int v1:17; unsigned char :0; float v2; };
struct __attribute__((packed)) aBFu17i_BFu0c_I { unsigned int v1:17; unsigned char :0; int v2; };
struct __attribute__((packed)) aBFu17i_BFu0c_Ip { unsigned int v1:17; unsigned char :0; int * v2; };
struct __attribute__((packed)) aBFu17i_BFu0c_L { unsigned int v1:17; unsigned char :0; long long v2; };
struct __attribute__((packed)) aBFu17i_BFu0c_S { unsigned int v1:17; unsigned char :0; short v2; };
struct __attribute__((packed)) aBFu17i_BFu0c_Uc { unsigned int v1:17; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aBFu17i_BFu0c_Ui { unsigned int v1:17; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aBFu17i_BFu0c_Ul { unsigned int v1:17; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu17i_BFu0c_Us { unsigned int v1:17; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aBFu17i_BFu0c_Vp { unsigned int v1:17; unsigned char :0; void * v2; };
struct __attribute__((packed)) aBFu17i_BFu0i { unsigned int v1:17; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu0c { unsigned int v1:17; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu0i { unsigned int v1:17; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu0ll { unsigned int v1:17; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu0s { unsigned int v1:17; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu15i { unsigned int v1:17; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu15ll { unsigned int v1:17; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu15s { unsigned int v1:17; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu16i { unsigned int v1:17; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu16ll { unsigned int v1:17; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu16s { unsigned int v1:17; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu17i { unsigned int v1:17; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu17ll { unsigned int v1:17; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu1c { unsigned int v1:17; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu1i { unsigned int v1:17; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu1ll { unsigned int v1:17; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu1s { unsigned int v1:17; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu31i { unsigned int v1:17; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu31ll { unsigned int v1:17; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu32i { unsigned int v1:17; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu32ll { unsigned int v1:17; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu33 { unsigned int v1:17; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu7c { unsigned int v1:17; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu7i { unsigned int v1:17; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu7ll { unsigned int v1:17; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu7s { unsigned int v1:17; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu8c { unsigned int v1:17; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu8i { unsigned int v1:17; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu8ll { unsigned int v1:17; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu8s { unsigned int v1:17; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu9i { unsigned int v1:17; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu9ll { unsigned int v1:17; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu17i_BFu0i_BFu9s { unsigned int v1:17; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu17i_BFu0i_C { unsigned int v1:17; unsigned int :0; char v2; };
struct __attribute__((packed)) aBFu17i_BFu0i_D { unsigned int v1:17; unsigned int :0; double v2; };
struct __attribute__((packed)) aBFu17i_BFu0i_F { unsigned int v1:17; unsigned int :0; float v2; };
struct __attribute__((packed)) aBFu17i_BFu0i_I { unsigned int v1:17; unsigned int :0; int v2; };
struct __attribute__((packed)) aBFu17i_BFu0i_Ip { unsigned int v1:17; unsigned int :0; int * v2; };
struct __attribute__((packed)) aBFu17i_BFu0i_L { unsigned int v1:17; unsigned int :0; long long v2; };
struct __attribute__((packed)) aBFu17i_BFu0i_S { unsigned int v1:17; unsigned int :0; short v2; };
struct __attribute__((packed)) aBFu17i_BFu0i_Uc { unsigned int v1:17; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aBFu17i_BFu0i_Ui { unsigned int v1:17; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aBFu17i_BFu0i_Ul { unsigned int v1:17; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu17i_BFu0i_Us { unsigned int v1:17; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aBFu17i_BFu0i_Vp { unsigned int v1:17; unsigned int :0; void * v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll { unsigned int v1:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu0c { unsigned int v1:17; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu0i { unsigned int v1:17; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu0ll { unsigned int v1:17; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu0s { unsigned int v1:17; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu15i { unsigned int v1:17; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu15ll { unsigned int v1:17; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu15s { unsigned int v1:17; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu16i { unsigned int v1:17; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu16ll { unsigned int v1:17; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu16s { unsigned int v1:17; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu17i { unsigned int v1:17; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu17ll { unsigned int v1:17; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu1c { unsigned int v1:17; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu1i { unsigned int v1:17; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu1ll { unsigned int v1:17; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu1s { unsigned int v1:17; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu31i { unsigned int v1:17; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu31ll { unsigned int v1:17; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu32i { unsigned int v1:17; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu32ll { unsigned int v1:17; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu33 { unsigned int v1:17; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu7c { unsigned int v1:17; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu7i { unsigned int v1:17; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu7ll { unsigned int v1:17; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu7s { unsigned int v1:17; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu8c { unsigned int v1:17; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu8i { unsigned int v1:17; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu8ll { unsigned int v1:17; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu8s { unsigned int v1:17; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu9i { unsigned int v1:17; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu9ll { unsigned int v1:17; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu17i_BFu0ll_BFu9s { unsigned int v1:17; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu17i_BFu0ll_C { unsigned int v1:17; unsigned long long :0; char v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll_D { unsigned int v1:17; unsigned long long :0; double v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll_F { unsigned int v1:17; unsigned long long :0; float v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll_I { unsigned int v1:17; unsigned long long :0; int v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll_Ip { unsigned int v1:17; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll_L { unsigned int v1:17; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll_S { unsigned int v1:17; unsigned long long :0; short v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll_Uc { unsigned int v1:17; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll_Ui { unsigned int v1:17; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll_Ul { unsigned int v1:17; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll_Us { unsigned int v1:17; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll_Vp { unsigned int v1:17; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aBFu17i_BFu0s { unsigned int v1:17; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu0c { unsigned int v1:17; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu0i { unsigned int v1:17; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu0ll { unsigned int v1:17; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu0s { unsigned int v1:17; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu15i { unsigned int v1:17; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu15ll { unsigned int v1:17; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu15s { unsigned int v1:17; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu16i { unsigned int v1:17; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu16ll { unsigned int v1:17; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu16s { unsigned int v1:17; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu17i { unsigned int v1:17; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu17ll { unsigned int v1:17; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu1c { unsigned int v1:17; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu1i { unsigned int v1:17; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu1ll { unsigned int v1:17; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu1s { unsigned int v1:17; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu31i { unsigned int v1:17; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu31ll { unsigned int v1:17; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu32i { unsigned int v1:17; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu32ll { unsigned int v1:17; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu33 { unsigned int v1:17; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu7c { unsigned int v1:17; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu7i { unsigned int v1:17; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu7ll { unsigned int v1:17; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu7s { unsigned int v1:17; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu8c { unsigned int v1:17; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu8i { unsigned int v1:17; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu8ll { unsigned int v1:17; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu8s { unsigned int v1:17; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu9i { unsigned int v1:17; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu9ll { unsigned int v1:17; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu17i_BFu0s_BFu9s { unsigned int v1:17; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu17i_BFu0s_C { unsigned int v1:17; unsigned short :0; char v2; };
struct __attribute__((packed)) aBFu17i_BFu0s_D { unsigned int v1:17; unsigned short :0; double v2; };
struct __attribute__((packed)) aBFu17i_BFu0s_F { unsigned int v1:17; unsigned short :0; float v2; };
struct __attribute__((packed)) aBFu17i_BFu0s_I { unsigned int v1:17; unsigned short :0; int v2; };
struct __attribute__((packed)) aBFu17i_BFu0s_Ip { unsigned int v1:17; unsigned short :0; int * v2; };
struct __attribute__((packed)) aBFu17i_BFu0s_L { unsigned int v1:17; unsigned short :0; long long v2; };
struct __attribute__((packed)) aBFu17i_BFu0s_S { unsigned int v1:17; unsigned short :0; short v2; };
struct __attribute__((packed)) aBFu17i_BFu0s_Uc { unsigned int v1:17; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aBFu17i_BFu0s_Ui { unsigned int v1:17; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aBFu17i_BFu0s_Ul { unsigned int v1:17; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu17i_BFu0s_Us { unsigned int v1:17; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aBFu17i_BFu0s_Vp { unsigned int v1:17; unsigned short :0; void * v2; };
struct __attribute__((packed)) aBFu17i_BFu15i_BFu0c { unsigned int v1:17; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu15i_BFu0i { unsigned int v1:17; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu15i_BFu0ll { unsigned int v1:17; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu15i_BFu0s { unsigned int v1:17; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu15ll_BFu0c { unsigned int v1:17; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu15ll_BFu0i { unsigned int v1:17; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu15ll_BFu0ll { unsigned int v1:17; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu15ll_BFu0s { unsigned int v1:17; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu15s_BFu0c { unsigned int v1:17; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu15s_BFu0i { unsigned int v1:17; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu15s_BFu0ll { unsigned int v1:17; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu15s_BFu0s { unsigned int v1:17; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu16i_BFu0c { unsigned int v1:17; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu16i_BFu0i { unsigned int v1:17; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu16i_BFu0ll { unsigned int v1:17; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu16i_BFu0s { unsigned int v1:17; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu16ll_BFu0c { unsigned int v1:17; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu16ll_BFu0i { unsigned int v1:17; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu16ll_BFu0ll { unsigned int v1:17; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu16ll_BFu0s { unsigned int v1:17; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu16s_BFu0c { unsigned int v1:17; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu16s_BFu0i { unsigned int v1:17; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu16s_BFu0ll { unsigned int v1:17; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu16s_BFu0s { unsigned int v1:17; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu17i_BFu0c { unsigned int v1:17; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu17i_BFu0i { unsigned int v1:17; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu17i_BFu0ll { unsigned int v1:17; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu17i_BFu0s { unsigned int v1:17; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu17ll_BFu0c { unsigned int v1:17; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu17ll_BFu0i { unsigned int v1:17; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu17ll_BFu0ll { unsigned int v1:17; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu17ll_BFu0s { unsigned int v1:17; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu1c_BFu0c { unsigned int v1:17; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu1c_BFu0i { unsigned int v1:17; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu1c_BFu0ll { unsigned int v1:17; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu1c_BFu0s { unsigned int v1:17; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu1i_BFu0c { unsigned int v1:17; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu1i_BFu0i { unsigned int v1:17; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu1i_BFu0ll { unsigned int v1:17; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu1i_BFu0s { unsigned int v1:17; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu1ll_BFu0c { unsigned int v1:17; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu1ll_BFu0i { unsigned int v1:17; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu1ll_BFu0ll { unsigned int v1:17; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu1ll_BFu0s { unsigned int v1:17; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu1s_BFu0c { unsigned int v1:17; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu1s_BFu0i { unsigned int v1:17; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu1s_BFu0ll { unsigned int v1:17; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu1s_BFu0s { unsigned int v1:17; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu31i_BFu0c { unsigned int v1:17; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu31i_BFu0i { unsigned int v1:17; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu31i_BFu0ll { unsigned int v1:17; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu31i_BFu0s { unsigned int v1:17; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu31ll_BFu0c { unsigned int v1:17; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu31ll_BFu0i { unsigned int v1:17; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu31ll_BFu0ll { unsigned int v1:17; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu31ll_BFu0s { unsigned int v1:17; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu32i_BFu0c { unsigned int v1:17; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu32i_BFu0i { unsigned int v1:17; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu32i_BFu0ll { unsigned int v1:17; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu32i_BFu0s { unsigned int v1:17; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu32ll_BFu0c { unsigned int v1:17; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu32ll_BFu0i { unsigned int v1:17; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu32ll_BFu0ll { unsigned int v1:17; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu32ll_BFu0s { unsigned int v1:17; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu33_BFu0c { unsigned int v1:17; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu33_BFu0i { unsigned int v1:17; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu33_BFu0ll { unsigned int v1:17; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu33_BFu0s { unsigned int v1:17; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu7c_BFu0c { unsigned int v1:17; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu7c_BFu0i { unsigned int v1:17; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu7c_BFu0ll { unsigned int v1:17; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu7c_BFu0s { unsigned int v1:17; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu7i_BFu0c { unsigned int v1:17; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu7i_BFu0i { unsigned int v1:17; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu7i_BFu0ll { unsigned int v1:17; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu7i_BFu0s { unsigned int v1:17; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu7ll_BFu0c { unsigned int v1:17; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu7ll_BFu0i { unsigned int v1:17; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu7ll_BFu0ll { unsigned int v1:17; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu7ll_BFu0s { unsigned int v1:17; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu7s_BFu0c { unsigned int v1:17; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu7s_BFu0i { unsigned int v1:17; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu7s_BFu0ll { unsigned int v1:17; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu7s_BFu0s { unsigned int v1:17; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu8c_BFu0c { unsigned int v1:17; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu8c_BFu0i { unsigned int v1:17; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu8c_BFu0ll { unsigned int v1:17; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu8c_BFu0s { unsigned int v1:17; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu8i_BFu0c { unsigned int v1:17; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu8i_BFu0i { unsigned int v1:17; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu8i_BFu0ll { unsigned int v1:17; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu8i_BFu0s { unsigned int v1:17; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu8ll_BFu0c { unsigned int v1:17; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu8ll_BFu0i { unsigned int v1:17; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu8ll_BFu0ll { unsigned int v1:17; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu8ll_BFu0s { unsigned int v1:17; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu8s_BFu0c { unsigned int v1:17; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu8s_BFu0i { unsigned int v1:17; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu8s_BFu0ll { unsigned int v1:17; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu8s_BFu0s { unsigned int v1:17; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu9i_BFu0c { unsigned int v1:17; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu9i_BFu0i { unsigned int v1:17; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu9i_BFu0ll { unsigned int v1:17; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu9i_BFu0s { unsigned int v1:17; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu9ll_BFu0c { unsigned int v1:17; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu9ll_BFu0i { unsigned int v1:17; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu9ll_BFu0ll { unsigned int v1:17; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu9ll_BFu0s { unsigned int v1:17; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu9s_BFu0c { unsigned int v1:17; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_BFu9s_BFu0i { unsigned int v1:17; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_BFu9s_BFu0ll { unsigned int v1:17; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_BFu9s_BFu0s { unsigned int v1:17; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_C_BFu0c { unsigned int v1:17; char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_C_BFu0i { unsigned int v1:17; char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_C_BFu0ll { unsigned int v1:17; char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_C_BFu0s { unsigned int v1:17; char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_D_BFu0c { unsigned int v1:17; double v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_D_BFu0i { unsigned int v1:17; double v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_D_BFu0ll { unsigned int v1:17; double v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_D_BFu0s { unsigned int v1:17; double v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_F_BFu0c { unsigned int v1:17; float v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_F_BFu0i { unsigned int v1:17; float v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_F_BFu0ll { unsigned int v1:17; float v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_F_BFu0s { unsigned int v1:17; float v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_I_BFu0c { unsigned int v1:17; int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_I_BFu0i { unsigned int v1:17; int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_I_BFu0ll { unsigned int v1:17; int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_I_BFu0s { unsigned int v1:17; int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_Ip_BFu0c { unsigned int v1:17; int * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_Ip_BFu0i { unsigned int v1:17; int * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_Ip_BFu0ll { unsigned int v1:17; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_Ip_BFu0s { unsigned int v1:17; int * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_L_BFu0c { unsigned int v1:17; long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_L_BFu0i { unsigned int v1:17; long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_L_BFu0ll { unsigned int v1:17; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_L_BFu0s { unsigned int v1:17; long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_S_BFu0c { unsigned int v1:17; short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_S_BFu0i { unsigned int v1:17; short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_S_BFu0ll { unsigned int v1:17; short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_S_BFu0s { unsigned int v1:17; short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_Uc_BFu0c { unsigned int v1:17; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_Uc_BFu0i { unsigned int v1:17; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_Uc_BFu0ll { unsigned int v1:17; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_Uc_BFu0s { unsigned int v1:17; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_Ui_BFu0c { unsigned int v1:17; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_Ui_BFu0i { unsigned int v1:17; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_Ui_BFu0ll { unsigned int v1:17; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_Ui_BFu0s { unsigned int v1:17; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_Ul_BFu0c { unsigned int v1:17; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_Ul_BFu0i { unsigned int v1:17; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_Ul_BFu0ll { unsigned int v1:17; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_Ul_BFu0s { unsigned int v1:17; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_Us_BFu0c { unsigned int v1:17; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_Us_BFu0i { unsigned int v1:17; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_Us_BFu0ll { unsigned int v1:17; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_Us_BFu0s { unsigned int v1:17; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_Vp_BFu0c { unsigned int v1:17; void * v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_Vp_BFu0i { unsigned int v1:17; void * v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_Vp_BFu0ll { unsigned int v1:17; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_Vp_BFu0s { unsigned int v1:17; void * v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17ll_BFu0c { unsigned long long v1:17; unsigned char :0; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu0c { unsigned long long v1:17; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu0i { unsigned long long v1:17; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu0ll { unsigned long long v1:17; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu0s { unsigned long long v1:17; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu15i { unsigned long long v1:17; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu15ll { unsigned long long v1:17; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu15s { unsigned long long v1:17; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu16i { unsigned long long v1:17; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu16ll { unsigned long long v1:17; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu16s { unsigned long long v1:17; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu17i { unsigned long long v1:17; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu17ll { unsigned long long v1:17; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu1c { unsigned long long v1:17; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu1i { unsigned long long v1:17; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu1ll { unsigned long long v1:17; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu1s { unsigned long long v1:17; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu31i { unsigned long long v1:17; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu31ll { unsigned long long v1:17; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu32i { unsigned long long v1:17; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu32ll { unsigned long long v1:17; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu33 { unsigned long long v1:17; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu7c { unsigned long long v1:17; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu7i { unsigned long long v1:17; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu7ll { unsigned long long v1:17; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu7s { unsigned long long v1:17; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu8c { unsigned long long v1:17; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu8i { unsigned long long v1:17; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu8ll { unsigned long long v1:17; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu8s { unsigned long long v1:17; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu9i { unsigned long long v1:17; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu9ll { unsigned long long v1:17; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu17ll_BFu0c_BFu9s { unsigned long long v1:17; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu17ll_BFu0c_C { unsigned long long v1:17; unsigned char :0; char v2; };
struct __attribute__((packed)) aBFu17ll_BFu0c_D { unsigned long long v1:17; unsigned char :0; double v2; };
struct __attribute__((packed)) aBFu17ll_BFu0c_F { unsigned long long v1:17; unsigned char :0; float v2; };
struct __attribute__((packed)) aBFu17ll_BFu0c_I { unsigned long long v1:17; unsigned char :0; int v2; };
struct __attribute__((packed)) aBFu17ll_BFu0c_Ip { unsigned long long v1:17; unsigned char :0; int * v2; };
struct __attribute__((packed)) aBFu17ll_BFu0c_L { unsigned long long v1:17; unsigned char :0; long long v2; };
struct __attribute__((packed)) aBFu17ll_BFu0c_S { unsigned long long v1:17; unsigned char :0; short v2; };
struct __attribute__((packed)) aBFu17ll_BFu0c_Uc { unsigned long long v1:17; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aBFu17ll_BFu0c_Ui { unsigned long long v1:17; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aBFu17ll_BFu0c_Ul { unsigned long long v1:17; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu17ll_BFu0c_Us { unsigned long long v1:17; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aBFu17ll_BFu0c_Vp { unsigned long long v1:17; unsigned char :0; void * v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i { unsigned long long v1:17; unsigned int :0; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu0c { unsigned long long v1:17; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu0i { unsigned long long v1:17; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu0ll { unsigned long long v1:17; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu0s { unsigned long long v1:17; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu15i { unsigned long long v1:17; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu15ll { unsigned long long v1:17; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu15s { unsigned long long v1:17; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu16i { unsigned long long v1:17; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu16ll { unsigned long long v1:17; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu16s { unsigned long long v1:17; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu17i { unsigned long long v1:17; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu17ll { unsigned long long v1:17; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu1c { unsigned long long v1:17; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu1i { unsigned long long v1:17; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu1ll { unsigned long long v1:17; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu1s { unsigned long long v1:17; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu31i { unsigned long long v1:17; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu31ll { unsigned long long v1:17; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu32i { unsigned long long v1:17; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu32ll { unsigned long long v1:17; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu33 { unsigned long long v1:17; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu7c { unsigned long long v1:17; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu7i { unsigned long long v1:17; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu7ll { unsigned long long v1:17; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu7s { unsigned long long v1:17; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu8c { unsigned long long v1:17; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu8i { unsigned long long v1:17; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu8ll { unsigned long long v1:17; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu8s { unsigned long long v1:17; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu9i { unsigned long long v1:17; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu9ll { unsigned long long v1:17; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu17ll_BFu0i_BFu9s { unsigned long long v1:17; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aBFu17ll_BFu0i_C { unsigned long long v1:17; unsigned int :0; char v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i_D { unsigned long long v1:17; unsigned int :0; double v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i_F { unsigned long long v1:17; unsigned int :0; float v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i_I { unsigned long long v1:17; unsigned int :0; int v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i_Ip { unsigned long long v1:17; unsigned int :0; int * v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i_L { unsigned long long v1:17; unsigned int :0; long long v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i_S { unsigned long long v1:17; unsigned int :0; short v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i_Uc { unsigned long long v1:17; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i_Ui { unsigned long long v1:17; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i_Ul { unsigned long long v1:17; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i_Us { unsigned long long v1:17; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i_Vp { unsigned long long v1:17; unsigned int :0; void * v2; };
struct __attribute__((packed)) aBFu17ll_BFu0ll { unsigned long long v1:17; unsigned long long :0; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_BFu0c { unsigned long long v1:17; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_BFu0i { unsigned long long v1:17; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_BFu0ll { unsigned long long v1:17; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_BFu0s { unsigned long long v1:17; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_BFu15i { unsigned long long v1:17; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_BFu15ll { unsigned long long v1:17; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_BFu15s { unsigned long long v1:17; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_BFu16i { unsigned long long v1:17; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_BFu16ll { unsigned long long v1:17; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_BFu16s { unsigned long long v1:17; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_BFu17i { unsigned long long v1:17; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_BFu17ll { unsigned long long v1:17; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_BFu1c { unsigned long long v1:17; unsigned long long :0; unsigned char v2:1; };


static void Test_aBFu0s_C_BFu7ll()
{
  {
    init_simple_test("aBFu0s_C_BFu7ll");
    static STRUCT_IF_C aBFu0s_C_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_C_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0s_C_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0s_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_BFu7ll, aBFu0s_C_BFu7ll)
//============================================================================



static void Test_aBFu0s_C_BFu7s()
{
  {
    init_simple_test("aBFu0s_C_BFu7s");
    static STRUCT_IF_C aBFu0s_C_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_C_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0s_C_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0s_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_BFu7s, aBFu0s_C_BFu7s)
//============================================================================



static void Test_aBFu0s_C_BFu8c()
{
  {
    init_simple_test("aBFu0s_C_BFu8c");
    static STRUCT_IF_C aBFu0s_C_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0s_C_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0s_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_BFu8c, aBFu0s_C_BFu8c)
//============================================================================



static void Test_aBFu0s_C_BFu8i()
{
  {
    init_simple_test("aBFu0s_C_BFu8i");
    static STRUCT_IF_C aBFu0s_C_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_C_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0s_C_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0s_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_BFu8i, aBFu0s_C_BFu8i)
//============================================================================



static void Test_aBFu0s_C_BFu8ll()
{
  {
    init_simple_test("aBFu0s_C_BFu8ll");
    static STRUCT_IF_C aBFu0s_C_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_C_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0s_C_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0s_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_BFu8ll, aBFu0s_C_BFu8ll)
//============================================================================



static void Test_aBFu0s_C_BFu8s()
{
  {
    init_simple_test("aBFu0s_C_BFu8s");
    static STRUCT_IF_C aBFu0s_C_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_C_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0s_C_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0s_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_BFu8s, aBFu0s_C_BFu8s)
//============================================================================



static void Test_aBFu0s_C_BFu9i()
{
  {
    init_simple_test("aBFu0s_C_BFu9i");
    static STRUCT_IF_C aBFu0s_C_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_C_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0s_C_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0s_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_BFu9i, aBFu0s_C_BFu9i)
//============================================================================



static void Test_aBFu0s_C_BFu9ll()
{
  {
    init_simple_test("aBFu0s_C_BFu9ll");
    static STRUCT_IF_C aBFu0s_C_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_C_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0s_C_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0s_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_BFu9ll, aBFu0s_C_BFu9ll)
//============================================================================



static void Test_aBFu0s_C_BFu9s()
{
  {
    init_simple_test("aBFu0s_C_BFu9s");
    static STRUCT_IF_C aBFu0s_C_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_C_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0s_C_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0s_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_BFu9s, aBFu0s_C_BFu9s)
//============================================================================



static void Test_aBFu0s_C_C()
{
  {
    init_simple_test("aBFu0s_C_C");
    static STRUCT_IF_C aBFu0s_C_C lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_C_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_C.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_C, aBFu0s_C_C)
//============================================================================



static void Test_aBFu0s_C_D()
{
  {
    init_simple_test("aBFu0s_C_D");
    static STRUCT_IF_C aBFu0s_C_D lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_C_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_D.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_D, aBFu0s_C_D)
//============================================================================



static void Test_aBFu0s_C_F()
{
  {
    init_simple_test("aBFu0s_C_F");
    static STRUCT_IF_C aBFu0s_C_F lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_C_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_F.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_F, aBFu0s_C_F)
//============================================================================



static void Test_aBFu0s_C_I()
{
  {
    init_simple_test("aBFu0s_C_I");
    static STRUCT_IF_C aBFu0s_C_I lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_C_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_I.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_I, aBFu0s_C_I)
//============================================================================



static void Test_aBFu0s_C_Ip()
{
  {
    init_simple_test("aBFu0s_C_Ip");
    static STRUCT_IF_C aBFu0s_C_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_C_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_Ip.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_Ip, aBFu0s_C_Ip)
//============================================================================



static void Test_aBFu0s_C_L()
{
  {
    init_simple_test("aBFu0s_C_L");
    static STRUCT_IF_C aBFu0s_C_L lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_C_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_L.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_L, aBFu0s_C_L)
//============================================================================



static void Test_aBFu0s_C_S()
{
  {
    init_simple_test("aBFu0s_C_S");
    static STRUCT_IF_C aBFu0s_C_S lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_C_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_S.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_S, aBFu0s_C_S)
//============================================================================



static void Test_aBFu0s_C_Uc()
{
  {
    init_simple_test("aBFu0s_C_Uc");
    static STRUCT_IF_C aBFu0s_C_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_Uc.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_Uc, aBFu0s_C_Uc)
//============================================================================



static void Test_aBFu0s_C_Ui()
{
  {
    init_simple_test("aBFu0s_C_Ui");
    static STRUCT_IF_C aBFu0s_C_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_C_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_Ui.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_Ui, aBFu0s_C_Ui)
//============================================================================



static void Test_aBFu0s_C_Ul()
{
  {
    init_simple_test("aBFu0s_C_Ul");
    static STRUCT_IF_C aBFu0s_C_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_C_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_Ul.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_Ul, aBFu0s_C_Ul)
//============================================================================



static void Test_aBFu0s_C_Us()
{
  {
    init_simple_test("aBFu0s_C_Us");
    static STRUCT_IF_C aBFu0s_C_Us lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_C_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_Us.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_Us, aBFu0s_C_Us)
//============================================================================



static void Test_aBFu0s_C_Vp()
{
  {
    init_simple_test("aBFu0s_C_Vp");
    static STRUCT_IF_C aBFu0s_C_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_C_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_Vp.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_Vp, aBFu0s_C_Vp)
//============================================================================



static void Test_aBFu0s_D()
{
  {
    init_simple_test("aBFu0s_D");
    static STRUCT_IF_C aBFu0s_D lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_D.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D, aBFu0s_D)
//============================================================================



static void Test_aBFu0s_D_BFu0c()
{
  {
    init_simple_test("aBFu0s_D_BFu0c");
    static STRUCT_IF_C aBFu0s_D_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_D_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu0c, aBFu0s_D_BFu0c)
//============================================================================



static void Test_aBFu0s_D_BFu0i()
{
  {
    init_simple_test("aBFu0s_D_BFu0i");
    static STRUCT_IF_C aBFu0s_D_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_D_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu0i, aBFu0s_D_BFu0i)
//============================================================================



static void Test_aBFu0s_D_BFu0ll()
{
  {
    init_simple_test("aBFu0s_D_BFu0ll");
    static STRUCT_IF_C aBFu0s_D_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_D_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu0ll, aBFu0s_D_BFu0ll)
//============================================================================



static void Test_aBFu0s_D_BFu0s()
{
  {
    init_simple_test("aBFu0s_D_BFu0s");
    static STRUCT_IF_C aBFu0s_D_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_D_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu0s, aBFu0s_D_BFu0s)
//============================================================================



static void Test_aBFu0s_D_BFu15i()
{
  {
    init_simple_test("aBFu0s_D_BFu15i");
    static STRUCT_IF_C aBFu0s_D_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_D_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aBFu0s_D_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aBFu0s_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu15i, aBFu0s_D_BFu15i)
//============================================================================



static void Test_aBFu0s_D_BFu15ll()
{
  {
    init_simple_test("aBFu0s_D_BFu15ll");
    static STRUCT_IF_C aBFu0s_D_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_D_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aBFu0s_D_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aBFu0s_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu15ll, aBFu0s_D_BFu15ll)
//============================================================================



static void Test_aBFu0s_D_BFu15s()
{
  {
    init_simple_test("aBFu0s_D_BFu15s");
    static STRUCT_IF_C aBFu0s_D_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_D_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aBFu0s_D_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aBFu0s_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu15s, aBFu0s_D_BFu15s)
//============================================================================



static void Test_aBFu0s_D_BFu16i()
{
  {
    init_simple_test("aBFu0s_D_BFu16i");
    static STRUCT_IF_C aBFu0s_D_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_D_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aBFu0s_D_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aBFu0s_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu16i, aBFu0s_D_BFu16i)
//============================================================================



static void Test_aBFu0s_D_BFu16ll()
{
  {
    init_simple_test("aBFu0s_D_BFu16ll");
    static STRUCT_IF_C aBFu0s_D_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_D_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aBFu0s_D_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aBFu0s_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu16ll, aBFu0s_D_BFu16ll)
//============================================================================



static void Test_aBFu0s_D_BFu16s()
{
  {
    init_simple_test("aBFu0s_D_BFu16s");
    static STRUCT_IF_C aBFu0s_D_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_D_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aBFu0s_D_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aBFu0s_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu16s, aBFu0s_D_BFu16s)
//============================================================================



static void Test_aBFu0s_D_BFu17i()
{
  {
    init_simple_test("aBFu0s_D_BFu17i");
    static STRUCT_IF_C aBFu0s_D_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(aBFu0s_D_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "aBFu0s_D_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "aBFu0s_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu17i, aBFu0s_D_BFu17i)
//============================================================================



static void Test_aBFu0s_D_BFu17ll()
{
  {
    init_simple_test("aBFu0s_D_BFu17ll");
    static STRUCT_IF_C aBFu0s_D_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(aBFu0s_D_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "aBFu0s_D_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "aBFu0s_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu17ll, aBFu0s_D_BFu17ll)
//============================================================================



static void Test_aBFu0s_D_BFu1c()
{
  {
    init_simple_test("aBFu0s_D_BFu1c");
    static STRUCT_IF_C aBFu0s_D_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "aBFu0s_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu1c, aBFu0s_D_BFu1c)
//============================================================================



static void Test_aBFu0s_D_BFu1i()
{
  {
    init_simple_test("aBFu0s_D_BFu1i");
    static STRUCT_IF_C aBFu0s_D_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "aBFu0s_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu1i, aBFu0s_D_BFu1i)
//============================================================================



static void Test_aBFu0s_D_BFu1ll()
{
  {
    init_simple_test("aBFu0s_D_BFu1ll");
    static STRUCT_IF_C aBFu0s_D_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "aBFu0s_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu1ll, aBFu0s_D_BFu1ll)
//============================================================================



static void Test_aBFu0s_D_BFu1s()
{
  {
    init_simple_test("aBFu0s_D_BFu1s");
    static STRUCT_IF_C aBFu0s_D_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "aBFu0s_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu1s, aBFu0s_D_BFu1s)
//============================================================================



static void Test_aBFu0s_D_BFu31i()
{
  {
    init_simple_test("aBFu0s_D_BFu31i");
    static STRUCT_IF_C aBFu0s_D_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_D_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "aBFu0s_D_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "aBFu0s_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu31i, aBFu0s_D_BFu31i)
//============================================================================



static void Test_aBFu0s_D_BFu31ll()
{
  {
    init_simple_test("aBFu0s_D_BFu31ll");
    static STRUCT_IF_C aBFu0s_D_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_D_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "aBFu0s_D_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "aBFu0s_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu31ll, aBFu0s_D_BFu31ll)
//============================================================================



static void Test_aBFu0s_D_BFu32i()
{
  {
    init_simple_test("aBFu0s_D_BFu32i");
    static STRUCT_IF_C aBFu0s_D_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_D_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "aBFu0s_D_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "aBFu0s_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu32i, aBFu0s_D_BFu32i)
//============================================================================



static void Test_aBFu0s_D_BFu32ll()
{
  {
    init_simple_test("aBFu0s_D_BFu32ll");
    static STRUCT_IF_C aBFu0s_D_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_D_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "aBFu0s_D_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "aBFu0s_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu32ll, aBFu0s_D_BFu32ll)
//============================================================================



static void Test_aBFu0s_D_BFu33()
{
  {
    init_simple_test("aBFu0s_D_BFu33");
    static STRUCT_IF_C aBFu0s_D_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(aBFu0s_D_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "aBFu0s_D_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "aBFu0s_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu33, aBFu0s_D_BFu33)
//============================================================================



static void Test_aBFu0s_D_BFu7c()
{
  {
    init_simple_test("aBFu0s_D_BFu7c");
    static STRUCT_IF_C aBFu0s_D_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "aBFu0s_D_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "aBFu0s_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu7c, aBFu0s_D_BFu7c)
//============================================================================



static void Test_aBFu0s_D_BFu7i()
{
  {
    init_simple_test("aBFu0s_D_BFu7i");
    static STRUCT_IF_C aBFu0s_D_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "aBFu0s_D_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "aBFu0s_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu7i, aBFu0s_D_BFu7i)
//============================================================================



static void Test_aBFu0s_D_BFu7ll()
{
  {
    init_simple_test("aBFu0s_D_BFu7ll");
    static STRUCT_IF_C aBFu0s_D_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "aBFu0s_D_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "aBFu0s_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu7ll, aBFu0s_D_BFu7ll)
//============================================================================



static void Test_aBFu0s_D_BFu7s()
{
  {
    init_simple_test("aBFu0s_D_BFu7s");
    static STRUCT_IF_C aBFu0s_D_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "aBFu0s_D_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "aBFu0s_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu7s, aBFu0s_D_BFu7s)
//============================================================================



static void Test_aBFu0s_D_BFu8c()
{
  {
    init_simple_test("aBFu0s_D_BFu8c");
    static STRUCT_IF_C aBFu0s_D_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aBFu0s_D_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aBFu0s_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu8c, aBFu0s_D_BFu8c)
//============================================================================



static void Test_aBFu0s_D_BFu8i()
{
  {
    init_simple_test("aBFu0s_D_BFu8i");
    static STRUCT_IF_C aBFu0s_D_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aBFu0s_D_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aBFu0s_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu8i, aBFu0s_D_BFu8i)
//============================================================================



static void Test_aBFu0s_D_BFu8ll()
{
  {
    init_simple_test("aBFu0s_D_BFu8ll");
    static STRUCT_IF_C aBFu0s_D_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aBFu0s_D_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aBFu0s_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu8ll, aBFu0s_D_BFu8ll)
//============================================================================



static void Test_aBFu0s_D_BFu8s()
{
  {
    init_simple_test("aBFu0s_D_BFu8s");
    static STRUCT_IF_C aBFu0s_D_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aBFu0s_D_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aBFu0s_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu8s, aBFu0s_D_BFu8s)
//============================================================================



static void Test_aBFu0s_D_BFu9i()
{
  {
    init_simple_test("aBFu0s_D_BFu9i");
    static STRUCT_IF_C aBFu0s_D_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_D_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aBFu0s_D_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aBFu0s_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu9i, aBFu0s_D_BFu9i)
//============================================================================



static void Test_aBFu0s_D_BFu9ll()
{
  {
    init_simple_test("aBFu0s_D_BFu9ll");
    static STRUCT_IF_C aBFu0s_D_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aBFu0s_D_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aBFu0s_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu9ll, aBFu0s_D_BFu9ll)
//============================================================================



static void Test_aBFu0s_D_BFu9s()
{
  {
    init_simple_test("aBFu0s_D_BFu9s");
    static STRUCT_IF_C aBFu0s_D_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aBFu0s_D_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aBFu0s_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_BFu9s, aBFu0s_D_BFu9s)
//============================================================================



static void Test_aBFu0s_D_C()
{
  {
    init_simple_test("aBFu0s_D_C");
    static STRUCT_IF_C aBFu0s_D_C lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_C.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_C, aBFu0s_D_C)
//============================================================================



static void Test_aBFu0s_D_D()
{
  {
    init_simple_test("aBFu0s_D_D");
    static STRUCT_IF_C aBFu0s_D_D lv;
    check2(sizeof(lv), 16, "sizeof(aBFu0s_D_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_D.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_D, aBFu0s_D_D)
//============================================================================



static void Test_aBFu0s_D_F()
{
  {
    init_simple_test("aBFu0s_D_F");
    static STRUCT_IF_C aBFu0s_D_F lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_D_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_F.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_F, aBFu0s_D_F)
//============================================================================



static void Test_aBFu0s_D_I()
{
  {
    init_simple_test("aBFu0s_D_I");
    static STRUCT_IF_C aBFu0s_D_I lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_D_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_I.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_I, aBFu0s_D_I)
//============================================================================



static void Test_aBFu0s_D_Ip()
{
  {
    init_simple_test("aBFu0s_D_Ip");
    static STRUCT_IF_C aBFu0s_D_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu0s_D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_Ip.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_Ip, aBFu0s_D_Ip)
//============================================================================



static void Test_aBFu0s_D_L()
{
  {
    init_simple_test("aBFu0s_D_L");
    static STRUCT_IF_C aBFu0s_D_L lv;
    check2(sizeof(lv), 16, "sizeof(aBFu0s_D_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_L.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_L, aBFu0s_D_L)
//============================================================================



static void Test_aBFu0s_D_S()
{
  {
    init_simple_test("aBFu0s_D_S");
    static STRUCT_IF_C aBFu0s_D_S lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_D_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_S.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_S, aBFu0s_D_S)
//============================================================================



static void Test_aBFu0s_D_Uc()
{
  {
    init_simple_test("aBFu0s_D_Uc");
    static STRUCT_IF_C aBFu0s_D_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_Uc.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_Uc, aBFu0s_D_Uc)
//============================================================================



static void Test_aBFu0s_D_Ui()
{
  {
    init_simple_test("aBFu0s_D_Ui");
    static STRUCT_IF_C aBFu0s_D_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_Ui.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_Ui, aBFu0s_D_Ui)
//============================================================================



static void Test_aBFu0s_D_Ul()
{
  {
    init_simple_test("aBFu0s_D_Ul");
    static STRUCT_IF_C aBFu0s_D_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aBFu0s_D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_Ul.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_Ul, aBFu0s_D_Ul)
//============================================================================



static void Test_aBFu0s_D_Us()
{
  {
    init_simple_test("aBFu0s_D_Us");
    static STRUCT_IF_C aBFu0s_D_Us lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_Us.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_Us, aBFu0s_D_Us)
//============================================================================



static void Test_aBFu0s_D_Vp()
{
  {
    init_simple_test("aBFu0s_D_Vp");
    static STRUCT_IF_C aBFu0s_D_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu0s_D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_Vp.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_Vp, aBFu0s_D_Vp)
//============================================================================



static void Test_aBFu0s_F()
{
  {
    init_simple_test("aBFu0s_F");
    static STRUCT_IF_C aBFu0s_F lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_F.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F, aBFu0s_F)
//============================================================================



static void Test_aBFu0s_F_BFu0c()
{
  {
    init_simple_test("aBFu0s_F_BFu0c");
    static STRUCT_IF_C aBFu0s_F_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_F_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu0c, aBFu0s_F_BFu0c)
//============================================================================



static void Test_aBFu0s_F_BFu0i()
{
  {
    init_simple_test("aBFu0s_F_BFu0i");
    static STRUCT_IF_C aBFu0s_F_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_F_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu0i, aBFu0s_F_BFu0i)
//============================================================================



static void Test_aBFu0s_F_BFu0ll()
{
  {
    init_simple_test("aBFu0s_F_BFu0ll");
    static STRUCT_IF_C aBFu0s_F_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_F_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu0ll, aBFu0s_F_BFu0ll)
//============================================================================



static void Test_aBFu0s_F_BFu0s()
{
  {
    init_simple_test("aBFu0s_F_BFu0s");
    static STRUCT_IF_C aBFu0s_F_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_F_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu0s, aBFu0s_F_BFu0s)
//============================================================================



static void Test_aBFu0s_F_BFu15i()
{
  {
    init_simple_test("aBFu0s_F_BFu15i");
    static STRUCT_IF_C aBFu0s_F_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aBFu0s_F_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aBFu0s_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu15i, aBFu0s_F_BFu15i)
//============================================================================



static void Test_aBFu0s_F_BFu15ll()
{
  {
    init_simple_test("aBFu0s_F_BFu15ll");
    static STRUCT_IF_C aBFu0s_F_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aBFu0s_F_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aBFu0s_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu15ll, aBFu0s_F_BFu15ll)
//============================================================================



static void Test_aBFu0s_F_BFu15s()
{
  {
    init_simple_test("aBFu0s_F_BFu15s");
    static STRUCT_IF_C aBFu0s_F_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aBFu0s_F_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aBFu0s_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu15s, aBFu0s_F_BFu15s)
//============================================================================



static void Test_aBFu0s_F_BFu16i()
{
  {
    init_simple_test("aBFu0s_F_BFu16i");
    static STRUCT_IF_C aBFu0s_F_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aBFu0s_F_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aBFu0s_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu16i, aBFu0s_F_BFu16i)
//============================================================================



static void Test_aBFu0s_F_BFu16ll()
{
  {
    init_simple_test("aBFu0s_F_BFu16ll");
    static STRUCT_IF_C aBFu0s_F_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aBFu0s_F_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aBFu0s_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu16ll, aBFu0s_F_BFu16ll)
//============================================================================



static void Test_aBFu0s_F_BFu16s()
{
  {
    init_simple_test("aBFu0s_F_BFu16s");
    static STRUCT_IF_C aBFu0s_F_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aBFu0s_F_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aBFu0s_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu16s, aBFu0s_F_BFu16s)
//============================================================================



static void Test_aBFu0s_F_BFu17i()
{
  {
    init_simple_test("aBFu0s_F_BFu17i");
    static STRUCT_IF_C aBFu0s_F_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu0s_F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aBFu0s_F_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aBFu0s_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu17i, aBFu0s_F_BFu17i)
//============================================================================



static void Test_aBFu0s_F_BFu17ll()
{
  {
    init_simple_test("aBFu0s_F_BFu17ll");
    static STRUCT_IF_C aBFu0s_F_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu0s_F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aBFu0s_F_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aBFu0s_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu17ll, aBFu0s_F_BFu17ll)
//============================================================================



static void Test_aBFu0s_F_BFu1c()
{
  {
    init_simple_test("aBFu0s_F_BFu1c");
    static STRUCT_IF_C aBFu0s_F_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu0s_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu1c, aBFu0s_F_BFu1c)
//============================================================================



static void Test_aBFu0s_F_BFu1i()
{
  {
    init_simple_test("aBFu0s_F_BFu1i");
    static STRUCT_IF_C aBFu0s_F_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu0s_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu1i, aBFu0s_F_BFu1i)
//============================================================================



static void Test_aBFu0s_F_BFu1ll()
{
  {
    init_simple_test("aBFu0s_F_BFu1ll");
    static STRUCT_IF_C aBFu0s_F_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu0s_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu1ll, aBFu0s_F_BFu1ll)
//============================================================================



static void Test_aBFu0s_F_BFu1s()
{
  {
    init_simple_test("aBFu0s_F_BFu1s");
    static STRUCT_IF_C aBFu0s_F_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu0s_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu1s, aBFu0s_F_BFu1s)
//============================================================================



static void Test_aBFu0s_F_BFu31i()
{
  {
    init_simple_test("aBFu0s_F_BFu31i");
    static STRUCT_IF_C aBFu0s_F_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aBFu0s_F_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aBFu0s_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu31i, aBFu0s_F_BFu31i)
//============================================================================



static void Test_aBFu0s_F_BFu31ll()
{
  {
    init_simple_test("aBFu0s_F_BFu31ll");
    static STRUCT_IF_C aBFu0s_F_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aBFu0s_F_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aBFu0s_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu31ll, aBFu0s_F_BFu31ll)
//============================================================================



static void Test_aBFu0s_F_BFu32i()
{
  {
    init_simple_test("aBFu0s_F_BFu32i");
    static STRUCT_IF_C aBFu0s_F_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aBFu0s_F_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aBFu0s_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu32i, aBFu0s_F_BFu32i)
//============================================================================



static void Test_aBFu0s_F_BFu32ll()
{
  {
    init_simple_test("aBFu0s_F_BFu32ll");
    static STRUCT_IF_C aBFu0s_F_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aBFu0s_F_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aBFu0s_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu32ll, aBFu0s_F_BFu32ll)
//============================================================================



static void Test_aBFu0s_F_BFu33()
{
  {
    init_simple_test("aBFu0s_F_BFu33");
    static STRUCT_IF_C aBFu0s_F_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aBFu0s_F_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aBFu0s_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu33, aBFu0s_F_BFu33)
//============================================================================



static void Test_aBFu0s_F_BFu7c()
{
  {
    init_simple_test("aBFu0s_F_BFu7c");
    static STRUCT_IF_C aBFu0s_F_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu0s_F_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu0s_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu7c, aBFu0s_F_BFu7c)
//============================================================================



static void Test_aBFu0s_F_BFu7i()
{
  {
    init_simple_test("aBFu0s_F_BFu7i");
    static STRUCT_IF_C aBFu0s_F_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu0s_F_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu0s_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu7i, aBFu0s_F_BFu7i)
//============================================================================



static void Test_aBFu0s_F_BFu7ll()
{
  {
    init_simple_test("aBFu0s_F_BFu7ll");
    static STRUCT_IF_C aBFu0s_F_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu0s_F_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu0s_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu7ll, aBFu0s_F_BFu7ll)
//============================================================================



static void Test_aBFu0s_F_BFu7s()
{
  {
    init_simple_test("aBFu0s_F_BFu7s");
    static STRUCT_IF_C aBFu0s_F_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu0s_F_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu0s_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu7s, aBFu0s_F_BFu7s)
//============================================================================



static void Test_aBFu0s_F_BFu8c()
{
  {
    init_simple_test("aBFu0s_F_BFu8c");
    static STRUCT_IF_C aBFu0s_F_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu0s_F_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu0s_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu8c, aBFu0s_F_BFu8c)
//============================================================================



static void Test_aBFu0s_F_BFu8i()
{
  {
    init_simple_test("aBFu0s_F_BFu8i");
    static STRUCT_IF_C aBFu0s_F_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu0s_F_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu0s_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu8i, aBFu0s_F_BFu8i)
//============================================================================



static void Test_aBFu0s_F_BFu8ll()
{
  {
    init_simple_test("aBFu0s_F_BFu8ll");
    static STRUCT_IF_C aBFu0s_F_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu0s_F_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu0s_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu8ll, aBFu0s_F_BFu8ll)
//============================================================================



static void Test_aBFu0s_F_BFu8s()
{
  {
    init_simple_test("aBFu0s_F_BFu8s");
    static STRUCT_IF_C aBFu0s_F_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu0s_F_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu0s_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu8s, aBFu0s_F_BFu8s)
//============================================================================



static void Test_aBFu0s_F_BFu9i()
{
  {
    init_simple_test("aBFu0s_F_BFu9i");
    static STRUCT_IF_C aBFu0s_F_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_F_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aBFu0s_F_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aBFu0s_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu9i, aBFu0s_F_BFu9i)
//============================================================================



static void Test_aBFu0s_F_BFu9ll()
{
  {
    init_simple_test("aBFu0s_F_BFu9ll");
    static STRUCT_IF_C aBFu0s_F_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_F_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aBFu0s_F_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aBFu0s_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu9ll, aBFu0s_F_BFu9ll)
//============================================================================



static void Test_aBFu0s_F_BFu9s()
{
  {
    init_simple_test("aBFu0s_F_BFu9s");
    static STRUCT_IF_C aBFu0s_F_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_F_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aBFu0s_F_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aBFu0s_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_BFu9s, aBFu0s_F_BFu9s)
//============================================================================



static void Test_aBFu0s_F_C()
{
  {
    init_simple_test("aBFu0s_F_C");
    static STRUCT_IF_C aBFu0s_F_C lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_C.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_C, aBFu0s_F_C)
//============================================================================



static void Test_aBFu0s_F_D()
{
  {
    init_simple_test("aBFu0s_F_D");
    static STRUCT_IF_C aBFu0s_F_D lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_F_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_D.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_D, aBFu0s_F_D)
//============================================================================



static void Test_aBFu0s_F_F()
{
  {
    init_simple_test("aBFu0s_F_F");
    static STRUCT_IF_C aBFu0s_F_F lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_F_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_F.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_F, aBFu0s_F_F)
//============================================================================



static void Test_aBFu0s_F_I()
{
  {
    init_simple_test("aBFu0s_F_I");
    static STRUCT_IF_C aBFu0s_F_I lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_F_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_I.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_I, aBFu0s_F_I)
//============================================================================



static void Test_aBFu0s_F_Ip()
{
  {
    init_simple_test("aBFu0s_F_Ip");
    static STRUCT_IF_C aBFu0s_F_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_F_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_Ip.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_Ip, aBFu0s_F_Ip)
//============================================================================



static void Test_aBFu0s_F_L()
{
  {
    init_simple_test("aBFu0s_F_L");
    static STRUCT_IF_C aBFu0s_F_L lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_F_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_L.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_L, aBFu0s_F_L)
//============================================================================



static void Test_aBFu0s_F_S()
{
  {
    init_simple_test("aBFu0s_F_S");
    static STRUCT_IF_C aBFu0s_F_S lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_F_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_S.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_S, aBFu0s_F_S)
//============================================================================



static void Test_aBFu0s_F_Uc()
{
  {
    init_simple_test("aBFu0s_F_Uc");
    static STRUCT_IF_C aBFu0s_F_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_F_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_Uc.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_Uc, aBFu0s_F_Uc)
//============================================================================



static void Test_aBFu0s_F_Ui()
{
  {
    init_simple_test("aBFu0s_F_Ui");
    static STRUCT_IF_C aBFu0s_F_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_F_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_Ui.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_Ui, aBFu0s_F_Ui)
//============================================================================



static void Test_aBFu0s_F_Ul()
{
  {
    init_simple_test("aBFu0s_F_Ul");
    static STRUCT_IF_C aBFu0s_F_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_F_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_Ul.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_Ul, aBFu0s_F_Ul)
//============================================================================



static void Test_aBFu0s_F_Us()
{
  {
    init_simple_test("aBFu0s_F_Us");
    static STRUCT_IF_C aBFu0s_F_Us lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_Us.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_Us, aBFu0s_F_Us)
//============================================================================



static void Test_aBFu0s_F_Vp()
{
  {
    init_simple_test("aBFu0s_F_Vp");
    static STRUCT_IF_C aBFu0s_F_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_Vp.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_Vp, aBFu0s_F_Vp)
//============================================================================



static void Test_aBFu0s_I()
{
  {
    init_simple_test("aBFu0s_I");
    static STRUCT_IF_C aBFu0s_I lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_I.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I, aBFu0s_I)
//============================================================================



static void Test_aBFu0s_I_BFu0c()
{
  {
    init_simple_test("aBFu0s_I_BFu0c");
    static STRUCT_IF_C aBFu0s_I_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_I_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu0c, aBFu0s_I_BFu0c)
//============================================================================



static void Test_aBFu0s_I_BFu0i()
{
  {
    init_simple_test("aBFu0s_I_BFu0i");
    static STRUCT_IF_C aBFu0s_I_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_I_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu0i, aBFu0s_I_BFu0i)
//============================================================================



static void Test_aBFu0s_I_BFu0ll()
{
  {
    init_simple_test("aBFu0s_I_BFu0ll");
    static STRUCT_IF_C aBFu0s_I_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_I_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu0ll, aBFu0s_I_BFu0ll)
//============================================================================



static void Test_aBFu0s_I_BFu0s()
{
  {
    init_simple_test("aBFu0s_I_BFu0s");
    static STRUCT_IF_C aBFu0s_I_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_I_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu0s, aBFu0s_I_BFu0s)
//============================================================================



static void Test_aBFu0s_I_BFu15i()
{
  {
    init_simple_test("aBFu0s_I_BFu15i");
    static STRUCT_IF_C aBFu0s_I_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aBFu0s_I_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aBFu0s_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu15i, aBFu0s_I_BFu15i)
//============================================================================



static void Test_aBFu0s_I_BFu15ll()
{
  {
    init_simple_test("aBFu0s_I_BFu15ll");
    static STRUCT_IF_C aBFu0s_I_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aBFu0s_I_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aBFu0s_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu15ll, aBFu0s_I_BFu15ll)
//============================================================================



static void Test_aBFu0s_I_BFu15s()
{
  {
    init_simple_test("aBFu0s_I_BFu15s");
    static STRUCT_IF_C aBFu0s_I_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aBFu0s_I_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aBFu0s_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu15s, aBFu0s_I_BFu15s)
//============================================================================



static void Test_aBFu0s_I_BFu16i()
{
  {
    init_simple_test("aBFu0s_I_BFu16i");
    static STRUCT_IF_C aBFu0s_I_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aBFu0s_I_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aBFu0s_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu16i, aBFu0s_I_BFu16i)
//============================================================================



static void Test_aBFu0s_I_BFu16ll()
{
  {
    init_simple_test("aBFu0s_I_BFu16ll");
    static STRUCT_IF_C aBFu0s_I_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aBFu0s_I_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aBFu0s_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu16ll, aBFu0s_I_BFu16ll)
//============================================================================



static void Test_aBFu0s_I_BFu16s()
{
  {
    init_simple_test("aBFu0s_I_BFu16s");
    static STRUCT_IF_C aBFu0s_I_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aBFu0s_I_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aBFu0s_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu16s, aBFu0s_I_BFu16s)
//============================================================================



static void Test_aBFu0s_I_BFu17i()
{
  {
    init_simple_test("aBFu0s_I_BFu17i");
    static STRUCT_IF_C aBFu0s_I_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu0s_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aBFu0s_I_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aBFu0s_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu17i, aBFu0s_I_BFu17i)
//============================================================================



static void Test_aBFu0s_I_BFu17ll()
{
  {
    init_simple_test("aBFu0s_I_BFu17ll");
    static STRUCT_IF_C aBFu0s_I_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu0s_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aBFu0s_I_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aBFu0s_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu17ll, aBFu0s_I_BFu17ll)
//============================================================================



static void Test_aBFu0s_I_BFu1c()
{
  {
    init_simple_test("aBFu0s_I_BFu1c");
    static STRUCT_IF_C aBFu0s_I_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu0s_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu1c, aBFu0s_I_BFu1c)
//============================================================================



static void Test_aBFu0s_I_BFu1i()
{
  {
    init_simple_test("aBFu0s_I_BFu1i");
    static STRUCT_IF_C aBFu0s_I_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu0s_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu1i, aBFu0s_I_BFu1i)
//============================================================================



static void Test_aBFu0s_I_BFu1ll()
{
  {
    init_simple_test("aBFu0s_I_BFu1ll");
    static STRUCT_IF_C aBFu0s_I_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu0s_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu1ll, aBFu0s_I_BFu1ll)
//============================================================================



static void Test_aBFu0s_I_BFu1s()
{
  {
    init_simple_test("aBFu0s_I_BFu1s");
    static STRUCT_IF_C aBFu0s_I_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu0s_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu1s, aBFu0s_I_BFu1s)
//============================================================================



static void Test_aBFu0s_I_BFu31i()
{
  {
    init_simple_test("aBFu0s_I_BFu31i");
    static STRUCT_IF_C aBFu0s_I_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aBFu0s_I_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aBFu0s_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu31i, aBFu0s_I_BFu31i)
//============================================================================



static void Test_aBFu0s_I_BFu31ll()
{
  {
    init_simple_test("aBFu0s_I_BFu31ll");
    static STRUCT_IF_C aBFu0s_I_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aBFu0s_I_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aBFu0s_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu31ll, aBFu0s_I_BFu31ll)
//============================================================================



static void Test_aBFu0s_I_BFu32i()
{
  {
    init_simple_test("aBFu0s_I_BFu32i");
    static STRUCT_IF_C aBFu0s_I_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aBFu0s_I_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aBFu0s_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu32i, aBFu0s_I_BFu32i)
//============================================================================



static void Test_aBFu0s_I_BFu32ll()
{
  {
    init_simple_test("aBFu0s_I_BFu32ll");
    static STRUCT_IF_C aBFu0s_I_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aBFu0s_I_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aBFu0s_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu32ll, aBFu0s_I_BFu32ll)
//============================================================================



static void Test_aBFu0s_I_BFu33()
{
  {
    init_simple_test("aBFu0s_I_BFu33");
    static STRUCT_IF_C aBFu0s_I_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aBFu0s_I_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aBFu0s_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu33, aBFu0s_I_BFu33)
//============================================================================



static void Test_aBFu0s_I_BFu7c()
{
  {
    init_simple_test("aBFu0s_I_BFu7c");
    static STRUCT_IF_C aBFu0s_I_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu0s_I_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu0s_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu7c, aBFu0s_I_BFu7c)
//============================================================================



static void Test_aBFu0s_I_BFu7i()
{
  {
    init_simple_test("aBFu0s_I_BFu7i");
    static STRUCT_IF_C aBFu0s_I_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu0s_I_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu0s_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu7i, aBFu0s_I_BFu7i)
//============================================================================



static void Test_aBFu0s_I_BFu7ll()
{
  {
    init_simple_test("aBFu0s_I_BFu7ll");
    static STRUCT_IF_C aBFu0s_I_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu0s_I_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu0s_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu7ll, aBFu0s_I_BFu7ll)
//============================================================================



static void Test_aBFu0s_I_BFu7s()
{
  {
    init_simple_test("aBFu0s_I_BFu7s");
    static STRUCT_IF_C aBFu0s_I_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu0s_I_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu0s_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu7s, aBFu0s_I_BFu7s)
//============================================================================



static void Test_aBFu0s_I_BFu8c()
{
  {
    init_simple_test("aBFu0s_I_BFu8c");
    static STRUCT_IF_C aBFu0s_I_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu0s_I_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu0s_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu8c, aBFu0s_I_BFu8c)
//============================================================================



static void Test_aBFu0s_I_BFu8i()
{
  {
    init_simple_test("aBFu0s_I_BFu8i");
    static STRUCT_IF_C aBFu0s_I_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu0s_I_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu0s_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu8i, aBFu0s_I_BFu8i)
//============================================================================



static void Test_aBFu0s_I_BFu8ll()
{
  {
    init_simple_test("aBFu0s_I_BFu8ll");
    static STRUCT_IF_C aBFu0s_I_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu0s_I_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu0s_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu8ll, aBFu0s_I_BFu8ll)
//============================================================================



static void Test_aBFu0s_I_BFu8s()
{
  {
    init_simple_test("aBFu0s_I_BFu8s");
    static STRUCT_IF_C aBFu0s_I_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu0s_I_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu0s_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu8s, aBFu0s_I_BFu8s)
//============================================================================



static void Test_aBFu0s_I_BFu9i()
{
  {
    init_simple_test("aBFu0s_I_BFu9i");
    static STRUCT_IF_C aBFu0s_I_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aBFu0s_I_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aBFu0s_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu9i, aBFu0s_I_BFu9i)
//============================================================================



static void Test_aBFu0s_I_BFu9ll()
{
  {
    init_simple_test("aBFu0s_I_BFu9ll");
    static STRUCT_IF_C aBFu0s_I_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aBFu0s_I_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aBFu0s_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu9ll, aBFu0s_I_BFu9ll)
//============================================================================



static void Test_aBFu0s_I_BFu9s()
{
  {
    init_simple_test("aBFu0s_I_BFu9s");
    static STRUCT_IF_C aBFu0s_I_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aBFu0s_I_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aBFu0s_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_BFu9s, aBFu0s_I_BFu9s)
//============================================================================



static void Test_aBFu0s_I_C()
{
  {
    init_simple_test("aBFu0s_I_C");
    static STRUCT_IF_C aBFu0s_I_C lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_C.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_C, aBFu0s_I_C)
//============================================================================



static void Test_aBFu0s_I_D()
{
  {
    init_simple_test("aBFu0s_I_D");
    static STRUCT_IF_C aBFu0s_I_D lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_D.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_D, aBFu0s_I_D)
//============================================================================



static void Test_aBFu0s_I_F()
{
  {
    init_simple_test("aBFu0s_I_F");
    static STRUCT_IF_C aBFu0s_I_F lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_F.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_F, aBFu0s_I_F)
//============================================================================



static void Test_aBFu0s_I_I()
{
  {
    init_simple_test("aBFu0s_I_I");
    static STRUCT_IF_C aBFu0s_I_I lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_I.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_I, aBFu0s_I_I)
//============================================================================



static void Test_aBFu0s_I_Ip()
{
  {
    init_simple_test("aBFu0s_I_Ip");
    static STRUCT_IF_C aBFu0s_I_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_Ip.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_Ip, aBFu0s_I_Ip)
//============================================================================



static void Test_aBFu0s_I_L()
{
  {
    init_simple_test("aBFu0s_I_L");
    static STRUCT_IF_C aBFu0s_I_L lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_L.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_L, aBFu0s_I_L)
//============================================================================



static void Test_aBFu0s_I_S()
{
  {
    init_simple_test("aBFu0s_I_S");
    static STRUCT_IF_C aBFu0s_I_S lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_S.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_S, aBFu0s_I_S)
//============================================================================



static void Test_aBFu0s_I_Uc()
{
  {
    init_simple_test("aBFu0s_I_Uc");
    static STRUCT_IF_C aBFu0s_I_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_Uc.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_Uc, aBFu0s_I_Uc)
//============================================================================



static void Test_aBFu0s_I_Ui()
{
  {
    init_simple_test("aBFu0s_I_Ui");
    static STRUCT_IF_C aBFu0s_I_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_Ui.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_Ui, aBFu0s_I_Ui)
//============================================================================



static void Test_aBFu0s_I_Ul()
{
  {
    init_simple_test("aBFu0s_I_Ul");
    static STRUCT_IF_C aBFu0s_I_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_Ul.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_Ul, aBFu0s_I_Ul)
//============================================================================



static void Test_aBFu0s_I_Us()
{
  {
    init_simple_test("aBFu0s_I_Us");
    static STRUCT_IF_C aBFu0s_I_Us lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_Us.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_Us, aBFu0s_I_Us)
//============================================================================



static void Test_aBFu0s_I_Vp()
{
  {
    init_simple_test("aBFu0s_I_Vp");
    static STRUCT_IF_C aBFu0s_I_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_Vp.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_Vp, aBFu0s_I_Vp)
//============================================================================



static void Test_aBFu0s_Ip()
{
  {
    init_simple_test("aBFu0s_Ip");
    static STRUCT_IF_C aBFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip, aBFu0s_Ip)
//============================================================================



static void Test_aBFu0s_Ip_BFu0c()
{
  {
    init_simple_test("aBFu0s_Ip_BFu0c");
    static STRUCT_IF_C aBFu0s_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Ip_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu0c, aBFu0s_Ip_BFu0c)
//============================================================================



static void Test_aBFu0s_Ip_BFu0i()
{
  {
    init_simple_test("aBFu0s_Ip_BFu0i");
    static STRUCT_IF_C aBFu0s_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Ip_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu0i, aBFu0s_Ip_BFu0i)
//============================================================================



static void Test_aBFu0s_Ip_BFu0ll()
{
  {
    init_simple_test("aBFu0s_Ip_BFu0ll");
    static STRUCT_IF_C aBFu0s_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Ip_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu0ll, aBFu0s_Ip_BFu0ll)
//============================================================================



static void Test_aBFu0s_Ip_BFu0s()
{
  {
    init_simple_test("aBFu0s_Ip_BFu0s");
    static STRUCT_IF_C aBFu0s_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Ip_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu0s, aBFu0s_Ip_BFu0s)
//============================================================================



static void Test_aBFu0s_Ip_BFu15i()
{
  {
    init_simple_test("aBFu0s_Ip_BFu15i");
    static STRUCT_IF_C aBFu0s_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aBFu0s_Ip_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aBFu0s_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu15i, aBFu0s_Ip_BFu15i)
//============================================================================



static void Test_aBFu0s_Ip_BFu15ll()
{
  {
    init_simple_test("aBFu0s_Ip_BFu15ll");
    static STRUCT_IF_C aBFu0s_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aBFu0s_Ip_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aBFu0s_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu15ll, aBFu0s_Ip_BFu15ll)
//============================================================================



static void Test_aBFu0s_Ip_BFu15s()
{
  {
    init_simple_test("aBFu0s_Ip_BFu15s");
    static STRUCT_IF_C aBFu0s_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aBFu0s_Ip_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aBFu0s_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu15s, aBFu0s_Ip_BFu15s)
//============================================================================



static void Test_aBFu0s_Ip_BFu16i()
{
  {
    init_simple_test("aBFu0s_Ip_BFu16i");
    static STRUCT_IF_C aBFu0s_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aBFu0s_Ip_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aBFu0s_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu16i, aBFu0s_Ip_BFu16i)
//============================================================================



static void Test_aBFu0s_Ip_BFu16ll()
{
  {
    init_simple_test("aBFu0s_Ip_BFu16ll");
    static STRUCT_IF_C aBFu0s_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aBFu0s_Ip_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aBFu0s_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu16ll, aBFu0s_Ip_BFu16ll)
//============================================================================



static void Test_aBFu0s_Ip_BFu16s()
{
  {
    init_simple_test("aBFu0s_Ip_BFu16s");
    static STRUCT_IF_C aBFu0s_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aBFu0s_Ip_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aBFu0s_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu16s, aBFu0s_Ip_BFu16s)
//============================================================================



static void Test_aBFu0s_Ip_BFu17i()
{
  {
    init_simple_test("aBFu0s_Ip_BFu17i");
    static STRUCT_IF_C aBFu0s_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu0s_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aBFu0s_Ip_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aBFu0s_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu17i, aBFu0s_Ip_BFu17i)
//============================================================================



static void Test_aBFu0s_Ip_BFu17ll()
{
  {
    init_simple_test("aBFu0s_Ip_BFu17ll");
    static STRUCT_IF_C aBFu0s_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu0s_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aBFu0s_Ip_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aBFu0s_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu17ll, aBFu0s_Ip_BFu17ll)
//============================================================================



static void Test_aBFu0s_Ip_BFu1c()
{
  {
    init_simple_test("aBFu0s_Ip_BFu1c");
    static STRUCT_IF_C aBFu0s_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aBFu0s_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu1c, aBFu0s_Ip_BFu1c)
//============================================================================



static void Test_aBFu0s_Ip_BFu1i()
{
  {
    init_simple_test("aBFu0s_Ip_BFu1i");
    static STRUCT_IF_C aBFu0s_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aBFu0s_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu1i, aBFu0s_Ip_BFu1i)
//============================================================================



static void Test_aBFu0s_Ip_BFu1ll()
{
  {
    init_simple_test("aBFu0s_Ip_BFu1ll");
    static STRUCT_IF_C aBFu0s_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aBFu0s_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu1ll, aBFu0s_Ip_BFu1ll)
//============================================================================



static void Test_aBFu0s_Ip_BFu1s()
{
  {
    init_simple_test("aBFu0s_Ip_BFu1s");
    static STRUCT_IF_C aBFu0s_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aBFu0s_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu1s, aBFu0s_Ip_BFu1s)
//============================================================================



static void Test_aBFu0s_Ip_BFu31i()
{
  {
    init_simple_test("aBFu0s_Ip_BFu31i");
    static STRUCT_IF_C aBFu0s_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aBFu0s_Ip_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aBFu0s_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu31i, aBFu0s_Ip_BFu31i)
//============================================================================



static void Test_aBFu0s_Ip_BFu31ll()
{
  {
    init_simple_test("aBFu0s_Ip_BFu31ll");
    static STRUCT_IF_C aBFu0s_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aBFu0s_Ip_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aBFu0s_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu31ll, aBFu0s_Ip_BFu31ll)
//============================================================================



static void Test_aBFu0s_Ip_BFu32i()
{
  {
    init_simple_test("aBFu0s_Ip_BFu32i");
    static STRUCT_IF_C aBFu0s_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aBFu0s_Ip_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aBFu0s_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu32i, aBFu0s_Ip_BFu32i)
//============================================================================



static void Test_aBFu0s_Ip_BFu32ll()
{
  {
    init_simple_test("aBFu0s_Ip_BFu32ll");
    static STRUCT_IF_C aBFu0s_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aBFu0s_Ip_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aBFu0s_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu32ll, aBFu0s_Ip_BFu32ll)
//============================================================================



static void Test_aBFu0s_Ip_BFu33()
{
  {
    init_simple_test("aBFu0s_Ip_BFu33");
    static STRUCT_IF_C aBFu0s_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu0s_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aBFu0s_Ip_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aBFu0s_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu33, aBFu0s_Ip_BFu33)
//============================================================================



static void Test_aBFu0s_Ip_BFu7c()
{
  {
    init_simple_test("aBFu0s_Ip_BFu7c");
    static STRUCT_IF_C aBFu0s_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aBFu0s_Ip_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aBFu0s_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu7c, aBFu0s_Ip_BFu7c)
//============================================================================



static void Test_aBFu0s_Ip_BFu7i()
{
  {
    init_simple_test("aBFu0s_Ip_BFu7i");
    static STRUCT_IF_C aBFu0s_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aBFu0s_Ip_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aBFu0s_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu7i, aBFu0s_Ip_BFu7i)
//============================================================================



static void Test_aBFu0s_Ip_BFu7ll()
{
  {
    init_simple_test("aBFu0s_Ip_BFu7ll");
    static STRUCT_IF_C aBFu0s_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aBFu0s_Ip_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aBFu0s_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu7ll, aBFu0s_Ip_BFu7ll)
//============================================================================



static void Test_aBFu0s_Ip_BFu7s()
{
  {
    init_simple_test("aBFu0s_Ip_BFu7s");
    static STRUCT_IF_C aBFu0s_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aBFu0s_Ip_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aBFu0s_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu7s, aBFu0s_Ip_BFu7s)
//============================================================================



static void Test_aBFu0s_Ip_BFu8c()
{
  {
    init_simple_test("aBFu0s_Ip_BFu8c");
    static STRUCT_IF_C aBFu0s_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aBFu0s_Ip_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aBFu0s_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu8c, aBFu0s_Ip_BFu8c)
//============================================================================



static void Test_aBFu0s_Ip_BFu8i()
{
  {
    init_simple_test("aBFu0s_Ip_BFu8i");
    static STRUCT_IF_C aBFu0s_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aBFu0s_Ip_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aBFu0s_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu8i, aBFu0s_Ip_BFu8i)
//============================================================================



static void Test_aBFu0s_Ip_BFu8ll()
{
  {
    init_simple_test("aBFu0s_Ip_BFu8ll");
    static STRUCT_IF_C aBFu0s_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aBFu0s_Ip_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aBFu0s_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu8ll, aBFu0s_Ip_BFu8ll)
//============================================================================



static void Test_aBFu0s_Ip_BFu8s()
{
  {
    init_simple_test("aBFu0s_Ip_BFu8s");
    static STRUCT_IF_C aBFu0s_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aBFu0s_Ip_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aBFu0s_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu8s, aBFu0s_Ip_BFu8s)
//============================================================================



static void Test_aBFu0s_Ip_BFu9i()
{
  {
    init_simple_test("aBFu0s_Ip_BFu9i");
    static STRUCT_IF_C aBFu0s_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aBFu0s_Ip_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aBFu0s_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu9i, aBFu0s_Ip_BFu9i)
//============================================================================



static void Test_aBFu0s_Ip_BFu9ll()
{
  {
    init_simple_test("aBFu0s_Ip_BFu9ll");
    static STRUCT_IF_C aBFu0s_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aBFu0s_Ip_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aBFu0s_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu9ll, aBFu0s_Ip_BFu9ll)
//============================================================================



static void Test_aBFu0s_Ip_BFu9s()
{
  {
    init_simple_test("aBFu0s_Ip_BFu9s");
    static STRUCT_IF_C aBFu0s_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aBFu0s_Ip_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aBFu0s_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_BFu9s, aBFu0s_Ip_BFu9s)
//============================================================================



static void Test_aBFu0s_Ip_C()
{
  {
    init_simple_test("aBFu0s_Ip_C");
    static STRUCT_IF_C aBFu0s_Ip_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_C, aBFu0s_Ip_C)
//============================================================================



static void Test_aBFu0s_Ip_D()
{
  {
    init_simple_test("aBFu0s_Ip_D");
    static STRUCT_IF_C aBFu0s_Ip_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu0s_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_D, aBFu0s_Ip_D)
//============================================================================



static void Test_aBFu0s_Ip_F()
{
  {
    init_simple_test("aBFu0s_Ip_F");
    static STRUCT_IF_C aBFu0s_Ip_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_F, aBFu0s_Ip_F)
//============================================================================



static void Test_aBFu0s_Ip_I()
{
  {
    init_simple_test("aBFu0s_Ip_I");
    static STRUCT_IF_C aBFu0s_Ip_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_I, aBFu0s_Ip_I)
//============================================================================



static void Test_aBFu0s_Ip_Ip()
{
  {
    init_simple_test("aBFu0s_Ip_Ip");
    static STRUCT_IF_C aBFu0s_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aBFu0s_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_Ip, aBFu0s_Ip_Ip)
//============================================================================



static void Test_aBFu0s_Ip_L()
{
  {
    init_simple_test("aBFu0s_Ip_L");
    static STRUCT_IF_C aBFu0s_Ip_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu0s_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_L, aBFu0s_Ip_L)
//============================================================================



static void Test_aBFu0s_Ip_S()
{
  {
    init_simple_test("aBFu0s_Ip_S");
    static STRUCT_IF_C aBFu0s_Ip_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_S, aBFu0s_Ip_S)
//============================================================================



static void Test_aBFu0s_Ip_Uc()
{
  {
    init_simple_test("aBFu0s_Ip_Uc");
    static STRUCT_IF_C aBFu0s_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_Uc, aBFu0s_Ip_Uc)
//============================================================================



static void Test_aBFu0s_Ip_Ui()
{
  {
    init_simple_test("aBFu0s_Ip_Ui");
    static STRUCT_IF_C aBFu0s_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_Ui, aBFu0s_Ip_Ui)
//============================================================================



static void Test_aBFu0s_Ip_Ul()
{
  {
    init_simple_test("aBFu0s_Ip_Ul");
    static STRUCT_IF_C aBFu0s_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu0s_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_Ul, aBFu0s_Ip_Ul)
//============================================================================



static void Test_aBFu0s_Ip_Us()
{
  {
    init_simple_test("aBFu0s_Ip_Us");
    static STRUCT_IF_C aBFu0s_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_Us, aBFu0s_Ip_Us)
//============================================================================



static void Test_aBFu0s_Ip_Vp()
{
  {
    init_simple_test("aBFu0s_Ip_Vp");
    static STRUCT_IF_C aBFu0s_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aBFu0s_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_Vp, aBFu0s_Ip_Vp)
//============================================================================



static void Test_aBFu0s_L()
{
  {
    init_simple_test("aBFu0s_L");
    static STRUCT_IF_C aBFu0s_L lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_L.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L, aBFu0s_L)
//============================================================================



static void Test_aBFu0s_L_BFu0c()
{
  {
    init_simple_test("aBFu0s_L_BFu0c");
    static STRUCT_IF_C aBFu0s_L_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_L_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu0c, aBFu0s_L_BFu0c)
//============================================================================



static void Test_aBFu0s_L_BFu0i()
{
  {
    init_simple_test("aBFu0s_L_BFu0i");
    static STRUCT_IF_C aBFu0s_L_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_L_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu0i, aBFu0s_L_BFu0i)
//============================================================================



static void Test_aBFu0s_L_BFu0ll()
{
  {
    init_simple_test("aBFu0s_L_BFu0ll");
    static STRUCT_IF_C aBFu0s_L_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_L_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu0ll, aBFu0s_L_BFu0ll)
//============================================================================



static void Test_aBFu0s_L_BFu0s()
{
  {
    init_simple_test("aBFu0s_L_BFu0s");
    static STRUCT_IF_C aBFu0s_L_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_L_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu0s, aBFu0s_L_BFu0s)
//============================================================================



static void Test_aBFu0s_L_BFu15i()
{
  {
    init_simple_test("aBFu0s_L_BFu15i");
    static STRUCT_IF_C aBFu0s_L_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aBFu0s_L_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aBFu0s_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu15i, aBFu0s_L_BFu15i)
//============================================================================



static void Test_aBFu0s_L_BFu15ll()
{
  {
    init_simple_test("aBFu0s_L_BFu15ll");
    static STRUCT_IF_C aBFu0s_L_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aBFu0s_L_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aBFu0s_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu15ll, aBFu0s_L_BFu15ll)
//============================================================================



static void Test_aBFu0s_L_BFu15s()
{
  {
    init_simple_test("aBFu0s_L_BFu15s");
    static STRUCT_IF_C aBFu0s_L_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aBFu0s_L_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aBFu0s_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu15s, aBFu0s_L_BFu15s)
//============================================================================



static void Test_aBFu0s_L_BFu16i()
{
  {
    init_simple_test("aBFu0s_L_BFu16i");
    static STRUCT_IF_C aBFu0s_L_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aBFu0s_L_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aBFu0s_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu16i, aBFu0s_L_BFu16i)
//============================================================================



static void Test_aBFu0s_L_BFu16ll()
{
  {
    init_simple_test("aBFu0s_L_BFu16ll");
    static STRUCT_IF_C aBFu0s_L_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aBFu0s_L_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aBFu0s_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu16ll, aBFu0s_L_BFu16ll)
//============================================================================



static void Test_aBFu0s_L_BFu16s()
{
  {
    init_simple_test("aBFu0s_L_BFu16s");
    static STRUCT_IF_C aBFu0s_L_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aBFu0s_L_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aBFu0s_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu16s, aBFu0s_L_BFu16s)
//============================================================================



static void Test_aBFu0s_L_BFu17i()
{
  {
    init_simple_test("aBFu0s_L_BFu17i");
    static STRUCT_IF_C aBFu0s_L_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(aBFu0s_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "aBFu0s_L_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "aBFu0s_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu17i, aBFu0s_L_BFu17i)
//============================================================================



static void Test_aBFu0s_L_BFu17ll()
{
  {
    init_simple_test("aBFu0s_L_BFu17ll");
    static STRUCT_IF_C aBFu0s_L_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(aBFu0s_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "aBFu0s_L_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "aBFu0s_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu17ll, aBFu0s_L_BFu17ll)
//============================================================================



static void Test_aBFu0s_L_BFu1c()
{
  {
    init_simple_test("aBFu0s_L_BFu1c");
    static STRUCT_IF_C aBFu0s_L_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "aBFu0s_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu1c, aBFu0s_L_BFu1c)
//============================================================================



static void Test_aBFu0s_L_BFu1i()
{
  {
    init_simple_test("aBFu0s_L_BFu1i");
    static STRUCT_IF_C aBFu0s_L_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "aBFu0s_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu1i, aBFu0s_L_BFu1i)
//============================================================================



static void Test_aBFu0s_L_BFu1ll()
{
  {
    init_simple_test("aBFu0s_L_BFu1ll");
    static STRUCT_IF_C aBFu0s_L_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "aBFu0s_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu1ll, aBFu0s_L_BFu1ll)
//============================================================================



static void Test_aBFu0s_L_BFu1s()
{
  {
    init_simple_test("aBFu0s_L_BFu1s");
    static STRUCT_IF_C aBFu0s_L_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "aBFu0s_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu1s, aBFu0s_L_BFu1s)
//============================================================================



static void Test_aBFu0s_L_BFu31i()
{
  {
    init_simple_test("aBFu0s_L_BFu31i");
    static STRUCT_IF_C aBFu0s_L_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "aBFu0s_L_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "aBFu0s_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu31i, aBFu0s_L_BFu31i)
//============================================================================



static void Test_aBFu0s_L_BFu31ll()
{
  {
    init_simple_test("aBFu0s_L_BFu31ll");
    static STRUCT_IF_C aBFu0s_L_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "aBFu0s_L_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "aBFu0s_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu31ll, aBFu0s_L_BFu31ll)
//============================================================================



static void Test_aBFu0s_L_BFu32i()
{
  {
    init_simple_test("aBFu0s_L_BFu32i");
    static STRUCT_IF_C aBFu0s_L_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "aBFu0s_L_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "aBFu0s_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu32i, aBFu0s_L_BFu32i)
//============================================================================



static void Test_aBFu0s_L_BFu32ll()
{
  {
    init_simple_test("aBFu0s_L_BFu32ll");
    static STRUCT_IF_C aBFu0s_L_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "aBFu0s_L_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "aBFu0s_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu32ll, aBFu0s_L_BFu32ll)
//============================================================================



static void Test_aBFu0s_L_BFu33()
{
  {
    init_simple_test("aBFu0s_L_BFu33");
    static STRUCT_IF_C aBFu0s_L_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(aBFu0s_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "aBFu0s_L_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "aBFu0s_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu33, aBFu0s_L_BFu33)
//============================================================================



static void Test_aBFu0s_L_BFu7c()
{
  {
    init_simple_test("aBFu0s_L_BFu7c");
    static STRUCT_IF_C aBFu0s_L_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "aBFu0s_L_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "aBFu0s_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu7c, aBFu0s_L_BFu7c)
//============================================================================



static void Test_aBFu0s_L_BFu7i()
{
  {
    init_simple_test("aBFu0s_L_BFu7i");
    static STRUCT_IF_C aBFu0s_L_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "aBFu0s_L_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "aBFu0s_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu7i, aBFu0s_L_BFu7i)
//============================================================================



static void Test_aBFu0s_L_BFu7ll()
{
  {
    init_simple_test("aBFu0s_L_BFu7ll");
    static STRUCT_IF_C aBFu0s_L_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "aBFu0s_L_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "aBFu0s_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu7ll, aBFu0s_L_BFu7ll)
//============================================================================



static void Test_aBFu0s_L_BFu7s()
{
  {
    init_simple_test("aBFu0s_L_BFu7s");
    static STRUCT_IF_C aBFu0s_L_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "aBFu0s_L_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "aBFu0s_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu7s, aBFu0s_L_BFu7s)
//============================================================================



static void Test_aBFu0s_L_BFu8c()
{
  {
    init_simple_test("aBFu0s_L_BFu8c");
    static STRUCT_IF_C aBFu0s_L_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aBFu0s_L_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aBFu0s_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu8c, aBFu0s_L_BFu8c)
//============================================================================



static void Test_aBFu0s_L_BFu8i()
{
  {
    init_simple_test("aBFu0s_L_BFu8i");
    static STRUCT_IF_C aBFu0s_L_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aBFu0s_L_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aBFu0s_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu8i, aBFu0s_L_BFu8i)
//============================================================================



static void Test_aBFu0s_L_BFu8ll()
{
  {
    init_simple_test("aBFu0s_L_BFu8ll");
    static STRUCT_IF_C aBFu0s_L_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aBFu0s_L_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aBFu0s_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu8ll, aBFu0s_L_BFu8ll)
//============================================================================



static void Test_aBFu0s_L_BFu8s()
{
  {
    init_simple_test("aBFu0s_L_BFu8s");
    static STRUCT_IF_C aBFu0s_L_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aBFu0s_L_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aBFu0s_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu8s, aBFu0s_L_BFu8s)
//============================================================================



static void Test_aBFu0s_L_BFu9i()
{
  {
    init_simple_test("aBFu0s_L_BFu9i");
    static STRUCT_IF_C aBFu0s_L_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aBFu0s_L_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aBFu0s_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu9i, aBFu0s_L_BFu9i)
//============================================================================



static void Test_aBFu0s_L_BFu9ll()
{
  {
    init_simple_test("aBFu0s_L_BFu9ll");
    static STRUCT_IF_C aBFu0s_L_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aBFu0s_L_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aBFu0s_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu9ll, aBFu0s_L_BFu9ll)
//============================================================================



static void Test_aBFu0s_L_BFu9s()
{
  {
    init_simple_test("aBFu0s_L_BFu9s");
    static STRUCT_IF_C aBFu0s_L_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aBFu0s_L_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aBFu0s_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_BFu9s, aBFu0s_L_BFu9s)
//============================================================================



static void Test_aBFu0s_L_C()
{
  {
    init_simple_test("aBFu0s_L_C");
    static STRUCT_IF_C aBFu0s_L_C lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_C.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_C, aBFu0s_L_C)
//============================================================================



static void Test_aBFu0s_L_D()
{
  {
    init_simple_test("aBFu0s_L_D");
    static STRUCT_IF_C aBFu0s_L_D lv;
    check2(sizeof(lv), 16, "sizeof(aBFu0s_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_D.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_D, aBFu0s_L_D)
//============================================================================



static void Test_aBFu0s_L_F()
{
  {
    init_simple_test("aBFu0s_L_F");
    static STRUCT_IF_C aBFu0s_L_F lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_F.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_F, aBFu0s_L_F)
//============================================================================



static void Test_aBFu0s_L_I()
{
  {
    init_simple_test("aBFu0s_L_I");
    static STRUCT_IF_C aBFu0s_L_I lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_I.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_I, aBFu0s_L_I)
//============================================================================



static void Test_aBFu0s_L_Ip()
{
  {
    init_simple_test("aBFu0s_L_Ip");
    static STRUCT_IF_C aBFu0s_L_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu0s_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_Ip.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_Ip, aBFu0s_L_Ip)
//============================================================================



static void Test_aBFu0s_L_L()
{
  {
    init_simple_test("aBFu0s_L_L");
    static STRUCT_IF_C aBFu0s_L_L lv;
    check2(sizeof(lv), 16, "sizeof(aBFu0s_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_L.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_L, aBFu0s_L_L)
//============================================================================



static void Test_aBFu0s_L_S()
{
  {
    init_simple_test("aBFu0s_L_S");
    static STRUCT_IF_C aBFu0s_L_S lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_S.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_S, aBFu0s_L_S)
//============================================================================



static void Test_aBFu0s_L_Uc()
{
  {
    init_simple_test("aBFu0s_L_Uc");
    static STRUCT_IF_C aBFu0s_L_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_Uc.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_Uc, aBFu0s_L_Uc)
//============================================================================



static void Test_aBFu0s_L_Ui()
{
  {
    init_simple_test("aBFu0s_L_Ui");
    static STRUCT_IF_C aBFu0s_L_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_Ui.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_Ui, aBFu0s_L_Ui)
//============================================================================



static void Test_aBFu0s_L_Ul()
{
  {
    init_simple_test("aBFu0s_L_Ul");
    static STRUCT_IF_C aBFu0s_L_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aBFu0s_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_Ul.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_Ul, aBFu0s_L_Ul)
//============================================================================



static void Test_aBFu0s_L_Us()
{
  {
    init_simple_test("aBFu0s_L_Us");
    static STRUCT_IF_C aBFu0s_L_Us lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_Us.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_Us, aBFu0s_L_Us)
//============================================================================



static void Test_aBFu0s_L_Vp()
{
  {
    init_simple_test("aBFu0s_L_Vp");
    static STRUCT_IF_C aBFu0s_L_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu0s_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_Vp.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_Vp, aBFu0s_L_Vp)
//============================================================================



static void Test_aBFu0s_S()
{
  {
    init_simple_test("aBFu0s_S");
    static STRUCT_IF_C aBFu0s_S lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_S.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S, aBFu0s_S)
//============================================================================



static void Test_aBFu0s_S_BFu0c()
{
  {
    init_simple_test("aBFu0s_S_BFu0c");
    static STRUCT_IF_C aBFu0s_S_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_S_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu0c, aBFu0s_S_BFu0c)
//============================================================================



static void Test_aBFu0s_S_BFu0i()
{
  {
    init_simple_test("aBFu0s_S_BFu0i");
    static STRUCT_IF_C aBFu0s_S_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu0s_S_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu0i, aBFu0s_S_BFu0i)
//============================================================================



static void Test_aBFu0s_S_BFu0ll()
{
  {
    init_simple_test("aBFu0s_S_BFu0ll");
    static STRUCT_IF_C aBFu0s_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_S_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu0ll, aBFu0s_S_BFu0ll)
//============================================================================



static void Test_aBFu0s_S_BFu0s()
{
  {
    init_simple_test("aBFu0s_S_BFu0s");
    static STRUCT_IF_C aBFu0s_S_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_S_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu0s, aBFu0s_S_BFu0s)
//============================================================================



static void Test_aBFu0s_S_BFu15i()
{
  {
    init_simple_test("aBFu0s_S_BFu15i");
    static STRUCT_IF_C aBFu0s_S_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu0s_S_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu0s_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu15i, aBFu0s_S_BFu15i)
//============================================================================



static void Test_aBFu0s_S_BFu15ll()
{
  {
    init_simple_test("aBFu0s_S_BFu15ll");
    static STRUCT_IF_C aBFu0s_S_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu0s_S_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu0s_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu15ll, aBFu0s_S_BFu15ll)
//============================================================================



static void Test_aBFu0s_S_BFu15s()
{
  {
    init_simple_test("aBFu0s_S_BFu15s");
    static STRUCT_IF_C aBFu0s_S_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu0s_S_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu0s_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu15s, aBFu0s_S_BFu15s)
//============================================================================



static void Test_aBFu0s_S_BFu16i()
{
  {
    init_simple_test("aBFu0s_S_BFu16i");
    static STRUCT_IF_C aBFu0s_S_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu0s_S_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu0s_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu16i, aBFu0s_S_BFu16i)
//============================================================================



static void Test_aBFu0s_S_BFu16ll()
{
  {
    init_simple_test("aBFu0s_S_BFu16ll");
    static STRUCT_IF_C aBFu0s_S_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu0s_S_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu0s_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu16ll, aBFu0s_S_BFu16ll)
//============================================================================



static void Test_aBFu0s_S_BFu16s()
{
  {
    init_simple_test("aBFu0s_S_BFu16s");
    static STRUCT_IF_C aBFu0s_S_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu0s_S_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu0s_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu16s, aBFu0s_S_BFu16s)
//============================================================================



static void Test_aBFu0s_S_BFu17i()
{
  {
    init_simple_test("aBFu0s_S_BFu17i");
    static STRUCT_IF_C aBFu0s_S_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aBFu0s_S_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aBFu0s_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu17i, aBFu0s_S_BFu17i)
//============================================================================



static void Test_aBFu0s_S_BFu17ll()
{
  {
    init_simple_test("aBFu0s_S_BFu17ll");
    static STRUCT_IF_C aBFu0s_S_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aBFu0s_S_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aBFu0s_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu17ll, aBFu0s_S_BFu17ll)
//============================================================================



static void Test_aBFu0s_S_BFu1c()
{
  {
    init_simple_test("aBFu0s_S_BFu1c");
    static STRUCT_IF_C aBFu0s_S_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu0s_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu1c, aBFu0s_S_BFu1c)
//============================================================================



static void Test_aBFu0s_S_BFu1i()
{
  {
    init_simple_test("aBFu0s_S_BFu1i");
    static STRUCT_IF_C aBFu0s_S_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu0s_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu1i, aBFu0s_S_BFu1i)
//============================================================================



static void Test_aBFu0s_S_BFu1ll()
{
  {
    init_simple_test("aBFu0s_S_BFu1ll");
    static STRUCT_IF_C aBFu0s_S_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu0s_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu1ll, aBFu0s_S_BFu1ll)
//============================================================================



static void Test_aBFu0s_S_BFu1s()
{
  {
    init_simple_test("aBFu0s_S_BFu1s");
    static STRUCT_IF_C aBFu0s_S_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu0s_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu1s, aBFu0s_S_BFu1s)
//============================================================================



static void Test_aBFu0s_S_BFu31i()
{
  {
    init_simple_test("aBFu0s_S_BFu31i");
    static STRUCT_IF_C aBFu0s_S_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu0s_S_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu0s_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu31i, aBFu0s_S_BFu31i)
//============================================================================



static void Test_aBFu0s_S_BFu31ll()
{
  {
    init_simple_test("aBFu0s_S_BFu31ll");
    static STRUCT_IF_C aBFu0s_S_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu0s_S_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu0s_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu31ll, aBFu0s_S_BFu31ll)
//============================================================================



static void Test_aBFu0s_S_BFu32i()
{
  {
    init_simple_test("aBFu0s_S_BFu32i");
    static STRUCT_IF_C aBFu0s_S_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu0s_S_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu0s_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu32i, aBFu0s_S_BFu32i)
//============================================================================



static void Test_aBFu0s_S_BFu32ll()
{
  {
    init_simple_test("aBFu0s_S_BFu32ll");
    static STRUCT_IF_C aBFu0s_S_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu0s_S_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu0s_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu32ll, aBFu0s_S_BFu32ll)
//============================================================================



static void Test_aBFu0s_S_BFu33()
{
  {
    init_simple_test("aBFu0s_S_BFu33");
    static STRUCT_IF_C aBFu0s_S_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu0s_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu0s_S_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu0s_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu33, aBFu0s_S_BFu33)
//============================================================================



static void Test_aBFu0s_S_BFu7c()
{
  {
    init_simple_test("aBFu0s_S_BFu7c");
    static STRUCT_IF_C aBFu0s_S_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu0s_S_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu0s_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu7c, aBFu0s_S_BFu7c)
//============================================================================



static void Test_aBFu0s_S_BFu7i()
{
  {
    init_simple_test("aBFu0s_S_BFu7i");
    static STRUCT_IF_C aBFu0s_S_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu0s_S_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu0s_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu7i, aBFu0s_S_BFu7i)
//============================================================================



static void Test_aBFu0s_S_BFu7ll()
{
  {
    init_simple_test("aBFu0s_S_BFu7ll");
    static STRUCT_IF_C aBFu0s_S_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu0s_S_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu0s_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu7ll, aBFu0s_S_BFu7ll)
//============================================================================



static void Test_aBFu0s_S_BFu7s()
{
  {
    init_simple_test("aBFu0s_S_BFu7s");
    static STRUCT_IF_C aBFu0s_S_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu0s_S_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu0s_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu7s, aBFu0s_S_BFu7s)
//============================================================================



static void Test_aBFu0s_S_BFu8c()
{
  {
    init_simple_test("aBFu0s_S_BFu8c");
    static STRUCT_IF_C aBFu0s_S_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu0s_S_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu0s_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu8c, aBFu0s_S_BFu8c)
//============================================================================



static void Test_aBFu0s_S_BFu8i()
{
  {
    init_simple_test("aBFu0s_S_BFu8i");
    static STRUCT_IF_C aBFu0s_S_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu0s_S_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu0s_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu8i, aBFu0s_S_BFu8i)
//============================================================================



static void Test_aBFu0s_S_BFu8ll()
{
  {
    init_simple_test("aBFu0s_S_BFu8ll");
    static STRUCT_IF_C aBFu0s_S_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu0s_S_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu0s_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu8ll, aBFu0s_S_BFu8ll)
//============================================================================



static void Test_aBFu0s_S_BFu8s()
{
  {
    init_simple_test("aBFu0s_S_BFu8s");
    static STRUCT_IF_C aBFu0s_S_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu0s_S_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu0s_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu8s, aBFu0s_S_BFu8s)
//============================================================================



static void Test_aBFu0s_S_BFu9i()
{
  {
    init_simple_test("aBFu0s_S_BFu9i");
    static STRUCT_IF_C aBFu0s_S_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu0s_S_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu0s_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu9i, aBFu0s_S_BFu9i)
//============================================================================



static void Test_aBFu0s_S_BFu9ll()
{
  {
    init_simple_test("aBFu0s_S_BFu9ll");
    static STRUCT_IF_C aBFu0s_S_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu0s_S_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu0s_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu9ll, aBFu0s_S_BFu9ll)
//============================================================================



static void Test_aBFu0s_S_BFu9s()
{
  {
    init_simple_test("aBFu0s_S_BFu9s");
    static STRUCT_IF_C aBFu0s_S_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu0s_S_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu0s_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_BFu9s, aBFu0s_S_BFu9s)
//============================================================================



static void Test_aBFu0s_S_C()
{
  {
    init_simple_test("aBFu0s_S_C");
    static STRUCT_IF_C aBFu0s_S_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_C.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_C, aBFu0s_S_C)
//============================================================================



static void Test_aBFu0s_S_D()
{
  {
    init_simple_test("aBFu0s_S_D");
    static STRUCT_IF_C aBFu0s_S_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_D.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_D, aBFu0s_S_D)
//============================================================================



static void Test_aBFu0s_S_F()
{
  {
    init_simple_test("aBFu0s_S_F");
    static STRUCT_IF_C aBFu0s_S_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_F.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_F, aBFu0s_S_F)
//============================================================================



static void Test_aBFu0s_S_I()
{
  {
    init_simple_test("aBFu0s_S_I");
    static STRUCT_IF_C aBFu0s_S_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_I.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_I, aBFu0s_S_I)
//============================================================================



static void Test_aBFu0s_S_Ip()
{
  {
    init_simple_test("aBFu0s_S_Ip");
    static STRUCT_IF_C aBFu0s_S_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_Ip.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_Ip, aBFu0s_S_Ip)
//============================================================================



static void Test_aBFu0s_S_L()
{
  {
    init_simple_test("aBFu0s_S_L");
    static STRUCT_IF_C aBFu0s_S_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_L.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_L, aBFu0s_S_L)
//============================================================================



static void Test_aBFu0s_S_S()
{
  {
    init_simple_test("aBFu0s_S_S");
    static STRUCT_IF_C aBFu0s_S_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_S.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_S, aBFu0s_S_S)
//============================================================================



static void Test_aBFu0s_S_Uc()
{
  {
    init_simple_test("aBFu0s_S_Uc");
    static STRUCT_IF_C aBFu0s_S_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_Uc.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_Uc, aBFu0s_S_Uc)
//============================================================================



static void Test_aBFu0s_S_Ui()
{
  {
    init_simple_test("aBFu0s_S_Ui");
    static STRUCT_IF_C aBFu0s_S_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_Ui.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_Ui, aBFu0s_S_Ui)
//============================================================================



static void Test_aBFu0s_S_Ul()
{
  {
    init_simple_test("aBFu0s_S_Ul");
    static STRUCT_IF_C aBFu0s_S_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_Ul.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_Ul, aBFu0s_S_Ul)
//============================================================================



static void Test_aBFu0s_S_Us()
{
  {
    init_simple_test("aBFu0s_S_Us");
    static STRUCT_IF_C aBFu0s_S_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_Us.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_Us, aBFu0s_S_Us)
//============================================================================



static void Test_aBFu0s_S_Vp()
{
  {
    init_simple_test("aBFu0s_S_Vp");
    static STRUCT_IF_C aBFu0s_S_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_Vp.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_Vp, aBFu0s_S_Vp)
//============================================================================



static void Test_aBFu0s_Uc()
{
  {
    init_simple_test("aBFu0s_Uc");
    static STRUCT_IF_C aBFu0s_Uc lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc, aBFu0s_Uc)
//============================================================================



static void Test_aBFu0s_Uc_BFu0c()
{
  {
    init_simple_test("aBFu0s_Uc_BFu0c");
    static STRUCT_IF_C aBFu0s_Uc_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Uc_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu0c, aBFu0s_Uc_BFu0c)
//============================================================================



static void Test_aBFu0s_Uc_BFu0i()
{
  {
    init_simple_test("aBFu0s_Uc_BFu0i");
    static STRUCT_IF_C aBFu0s_Uc_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu0s_Uc_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu0i, aBFu0s_Uc_BFu0i)
//============================================================================



static void Test_aBFu0s_Uc_BFu0ll()
{
  {
    init_simple_test("aBFu0s_Uc_BFu0ll");
    static STRUCT_IF_C aBFu0s_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Uc_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu0ll, aBFu0s_Uc_BFu0ll)
//============================================================================



static void Test_aBFu0s_Uc_BFu0s()
{
  {
    init_simple_test("aBFu0s_Uc_BFu0s");
    static STRUCT_IF_C aBFu0s_Uc_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu0s_Uc_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu0s, aBFu0s_Uc_BFu0s)
//============================================================================



static void Test_aBFu0s_Uc_BFu15i()
{
  {
    init_simple_test("aBFu0s_Uc_BFu15i");
    static STRUCT_IF_C aBFu0s_Uc_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0s_Uc_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0s_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu15i, aBFu0s_Uc_BFu15i)
//============================================================================



static void Test_aBFu0s_Uc_BFu15ll()
{
  {
    init_simple_test("aBFu0s_Uc_BFu15ll");
    static STRUCT_IF_C aBFu0s_Uc_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0s_Uc_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0s_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu15ll, aBFu0s_Uc_BFu15ll)
//============================================================================



static void Test_aBFu0s_Uc_BFu15s()
{
  {
    init_simple_test("aBFu0s_Uc_BFu15s");
    static STRUCT_IF_C aBFu0s_Uc_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu0s_Uc_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu0s_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu15s, aBFu0s_Uc_BFu15s)
//============================================================================



static void Test_aBFu0s_Uc_BFu16i()
{
  {
    init_simple_test("aBFu0s_Uc_BFu16i");
    static STRUCT_IF_C aBFu0s_Uc_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0s_Uc_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0s_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu16i, aBFu0s_Uc_BFu16i)
//============================================================================



static void Test_aBFu0s_Uc_BFu16ll()
{
  {
    init_simple_test("aBFu0s_Uc_BFu16ll");
    static STRUCT_IF_C aBFu0s_Uc_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0s_Uc_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0s_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu16ll, aBFu0s_Uc_BFu16ll)
//============================================================================



static void Test_aBFu0s_Uc_BFu16s()
{
  {
    init_simple_test("aBFu0s_Uc_BFu16s");
    static STRUCT_IF_C aBFu0s_Uc_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "aBFu0s_Uc_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "aBFu0s_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu16s, aBFu0s_Uc_BFu16s)
//============================================================================



static void Test_aBFu0s_Uc_BFu17i()
{
  {
    init_simple_test("aBFu0s_Uc_BFu17i");
    static STRUCT_IF_C aBFu0s_Uc_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu0s_Uc_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu0s_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu17i, aBFu0s_Uc_BFu17i)
//============================================================================



static void Test_aBFu0s_Uc_BFu17ll()
{
  {
    init_simple_test("aBFu0s_Uc_BFu17ll");
    static STRUCT_IF_C aBFu0s_Uc_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "aBFu0s_Uc_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "aBFu0s_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu17ll, aBFu0s_Uc_BFu17ll)
//============================================================================



static void Test_aBFu0s_Uc_BFu1c()
{
  {
    init_simple_test("aBFu0s_Uc_BFu1c");
    static STRUCT_IF_C aBFu0s_Uc_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0s_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu1c, aBFu0s_Uc_BFu1c)
//============================================================================



static void Test_aBFu0s_Uc_BFu1i()
{
  {
    init_simple_test("aBFu0s_Uc_BFu1i");
    static STRUCT_IF_C aBFu0s_Uc_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0s_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu1i, aBFu0s_Uc_BFu1i)
//============================================================================



static void Test_aBFu0s_Uc_BFu1ll()
{
  {
    init_simple_test("aBFu0s_Uc_BFu1ll");
    static STRUCT_IF_C aBFu0s_Uc_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0s_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu1ll, aBFu0s_Uc_BFu1ll)
//============================================================================



static void Test_aBFu0s_Uc_BFu1s()
{
  {
    init_simple_test("aBFu0s_Uc_BFu1s");
    static STRUCT_IF_C aBFu0s_Uc_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "aBFu0s_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu1s, aBFu0s_Uc_BFu1s)
//============================================================================



static void Test_aBFu0s_Uc_BFu31i()
{
  {
    init_simple_test("aBFu0s_Uc_BFu31i");
    static STRUCT_IF_C aBFu0s_Uc_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu0s_Uc_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu0s_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu31i, aBFu0s_Uc_BFu31i)
//============================================================================



static void Test_aBFu0s_Uc_BFu31ll()
{
  {
    init_simple_test("aBFu0s_Uc_BFu31ll");
    static STRUCT_IF_C aBFu0s_Uc_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "aBFu0s_Uc_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "aBFu0s_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu31ll, aBFu0s_Uc_BFu31ll)
//============================================================================



static void Test_aBFu0s_Uc_BFu32i()
{
  {
    init_simple_test("aBFu0s_Uc_BFu32i");
    static STRUCT_IF_C aBFu0s_Uc_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu0s_Uc_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu0s_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu32i, aBFu0s_Uc_BFu32i)
//============================================================================



static void Test_aBFu0s_Uc_BFu32ll()
{
  {
    init_simple_test("aBFu0s_Uc_BFu32ll");
    static STRUCT_IF_C aBFu0s_Uc_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "aBFu0s_Uc_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "aBFu0s_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu32ll, aBFu0s_Uc_BFu32ll)
//============================================================================



static void Test_aBFu0s_Uc_BFu33()
{
  {
    init_simple_test("aBFu0s_Uc_BFu33");
    static STRUCT_IF_C aBFu0s_Uc_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aBFu0s_Uc_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aBFu0s_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu33, aBFu0s_Uc_BFu33)
//============================================================================



static void Test_aBFu0s_Uc_BFu7c()
{
  {
    init_simple_test("aBFu0s_Uc_BFu7c");
    static STRUCT_IF_C aBFu0s_Uc_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0s_Uc_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0s_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu7c, aBFu0s_Uc_BFu7c)
//============================================================================



static void Test_aBFu0s_Uc_BFu7i()
{
  {
    init_simple_test("aBFu0s_Uc_BFu7i");
    static STRUCT_IF_C aBFu0s_Uc_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0s_Uc_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0s_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu7i, aBFu0s_Uc_BFu7i)
//============================================================================



static void Test_aBFu0s_Uc_BFu7ll()
{
  {
    init_simple_test("aBFu0s_Uc_BFu7ll");
    static STRUCT_IF_C aBFu0s_Uc_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0s_Uc_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0s_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu7ll, aBFu0s_Uc_BFu7ll)
//============================================================================



static void Test_aBFu0s_Uc_BFu7s()
{
  {
    init_simple_test("aBFu0s_Uc_BFu7s");
    static STRUCT_IF_C aBFu0s_Uc_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aBFu0s_Uc_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aBFu0s_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu7s, aBFu0s_Uc_BFu7s)
//============================================================================



static void Test_aBFu0s_Uc_BFu8c()
{
  {
    init_simple_test("aBFu0s_Uc_BFu8c");
    static STRUCT_IF_C aBFu0s_Uc_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0s_Uc_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0s_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu8c, aBFu0s_Uc_BFu8c)
//============================================================================



static void Test_aBFu0s_Uc_BFu8i()
{
  {
    init_simple_test("aBFu0s_Uc_BFu8i");
    static STRUCT_IF_C aBFu0s_Uc_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0s_Uc_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0s_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu8i, aBFu0s_Uc_BFu8i)
//============================================================================



static void Test_aBFu0s_Uc_BFu8ll()
{
  {
    init_simple_test("aBFu0s_Uc_BFu8ll");
    static STRUCT_IF_C aBFu0s_Uc_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0s_Uc_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0s_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu8ll, aBFu0s_Uc_BFu8ll)
//============================================================================



static void Test_aBFu0s_Uc_BFu8s()
{
  {
    init_simple_test("aBFu0s_Uc_BFu8s");
    static STRUCT_IF_C aBFu0s_Uc_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu0s_Uc_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aBFu0s_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu8s, aBFu0s_Uc_BFu8s)
//============================================================================



static void Test_aBFu0s_Uc_BFu9i()
{
  {
    init_simple_test("aBFu0s_Uc_BFu9i");
    static STRUCT_IF_C aBFu0s_Uc_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0s_Uc_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0s_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu9i, aBFu0s_Uc_BFu9i)
//============================================================================



static void Test_aBFu0s_Uc_BFu9ll()
{
  {
    init_simple_test("aBFu0s_Uc_BFu9ll");
    static STRUCT_IF_C aBFu0s_Uc_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0s_Uc_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0s_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu9ll, aBFu0s_Uc_BFu9ll)
//============================================================================



static void Test_aBFu0s_Uc_BFu9s()
{
  {
    init_simple_test("aBFu0s_Uc_BFu9s");
    static STRUCT_IF_C aBFu0s_Uc_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aBFu0s_Uc_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aBFu0s_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_BFu9s, aBFu0s_Uc_BFu9s)
//============================================================================



static void Test_aBFu0s_Uc_C()
{
  {
    init_simple_test("aBFu0s_Uc_C");
    static STRUCT_IF_C aBFu0s_Uc_C lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_C.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_C, aBFu0s_Uc_C)
//============================================================================



static void Test_aBFu0s_Uc_D()
{
  {
    init_simple_test("aBFu0s_Uc_D");
    static STRUCT_IF_C aBFu0s_Uc_D lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_D.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_D, aBFu0s_Uc_D)
//============================================================================



static void Test_aBFu0s_Uc_F()
{
  {
    init_simple_test("aBFu0s_Uc_F");
    static STRUCT_IF_C aBFu0s_Uc_F lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_F.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_F, aBFu0s_Uc_F)
//============================================================================



static void Test_aBFu0s_Uc_I()
{
  {
    init_simple_test("aBFu0s_Uc_I");
    static STRUCT_IF_C aBFu0s_Uc_I lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_I.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_I, aBFu0s_Uc_I)
//============================================================================



static void Test_aBFu0s_Uc_Ip()
{
  {
    init_simple_test("aBFu0s_Uc_Ip");
    static STRUCT_IF_C aBFu0s_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_Ip.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_Ip, aBFu0s_Uc_Ip)
//============================================================================



static void Test_aBFu0s_Uc_L()
{
  {
    init_simple_test("aBFu0s_Uc_L");
    static STRUCT_IF_C aBFu0s_Uc_L lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_L.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_L, aBFu0s_Uc_L)
//============================================================================



static void Test_aBFu0s_Uc_S()
{
  {
    init_simple_test("aBFu0s_Uc_S");
    static STRUCT_IF_C aBFu0s_Uc_S lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_S.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_S, aBFu0s_Uc_S)
//============================================================================



static void Test_aBFu0s_Uc_Uc()
{
  {
    init_simple_test("aBFu0s_Uc_Uc");
    static STRUCT_IF_C aBFu0s_Uc_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_Uc.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_Uc, aBFu0s_Uc_Uc)
//============================================================================



static void Test_aBFu0s_Uc_Ui()
{
  {
    init_simple_test("aBFu0s_Uc_Ui");
    static STRUCT_IF_C aBFu0s_Uc_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_Ui.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_Ui, aBFu0s_Uc_Ui)
//============================================================================



static void Test_aBFu0s_Uc_Ul()
{
  {
    init_simple_test("aBFu0s_Uc_Ul");
    static STRUCT_IF_C aBFu0s_Uc_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_Ul.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_Ul, aBFu0s_Uc_Ul)
//============================================================================



static void Test_aBFu0s_Uc_Us()
{
  {
    init_simple_test("aBFu0s_Uc_Us");
    static STRUCT_IF_C aBFu0s_Uc_Us lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_Us.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_Us, aBFu0s_Uc_Us)
//============================================================================



static void Test_aBFu0s_Uc_Vp()
{
  {
    init_simple_test("aBFu0s_Uc_Vp");
    static STRUCT_IF_C aBFu0s_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_Vp.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_Vp, aBFu0s_Uc_Vp)
//============================================================================



static void Test_aBFu0s_Ui()
{
  {
    init_simple_test("aBFu0s_Ui");
    static STRUCT_IF_C aBFu0s_Ui lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui, aBFu0s_Ui)
//============================================================================



static void Test_aBFu0s_Ui_BFu0c()
{
  {
    init_simple_test("aBFu0s_Ui_BFu0c");
    static STRUCT_IF_C aBFu0s_Ui_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Ui_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu0c, aBFu0s_Ui_BFu0c)
//============================================================================



static void Test_aBFu0s_Ui_BFu0i()
{
  {
    init_simple_test("aBFu0s_Ui_BFu0i");
    static STRUCT_IF_C aBFu0s_Ui_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Ui_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu0i, aBFu0s_Ui_BFu0i)
//============================================================================



static void Test_aBFu0s_Ui_BFu0ll()
{
  {
    init_simple_test("aBFu0s_Ui_BFu0ll");
    static STRUCT_IF_C aBFu0s_Ui_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Ui_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu0ll, aBFu0s_Ui_BFu0ll)
//============================================================================



static void Test_aBFu0s_Ui_BFu0s()
{
  {
    init_simple_test("aBFu0s_Ui_BFu0s");
    static STRUCT_IF_C aBFu0s_Ui_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Ui_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu0s, aBFu0s_Ui_BFu0s)
//============================================================================



static void Test_aBFu0s_Ui_BFu15i()
{
  {
    init_simple_test("aBFu0s_Ui_BFu15i");
    static STRUCT_IF_C aBFu0s_Ui_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aBFu0s_Ui_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aBFu0s_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu15i, aBFu0s_Ui_BFu15i)
//============================================================================



static void Test_aBFu0s_Ui_BFu15ll()
{
  {
    init_simple_test("aBFu0s_Ui_BFu15ll");
    static STRUCT_IF_C aBFu0s_Ui_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aBFu0s_Ui_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aBFu0s_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu15ll, aBFu0s_Ui_BFu15ll)
//============================================================================



static void Test_aBFu0s_Ui_BFu15s()
{
  {
    init_simple_test("aBFu0s_Ui_BFu15s");
    static STRUCT_IF_C aBFu0s_Ui_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aBFu0s_Ui_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aBFu0s_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu15s, aBFu0s_Ui_BFu15s)
//============================================================================



static void Test_aBFu0s_Ui_BFu16i()
{
  {
    init_simple_test("aBFu0s_Ui_BFu16i");
    static STRUCT_IF_C aBFu0s_Ui_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aBFu0s_Ui_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aBFu0s_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu16i, aBFu0s_Ui_BFu16i)
//============================================================================



static void Test_aBFu0s_Ui_BFu16ll()
{
  {
    init_simple_test("aBFu0s_Ui_BFu16ll");
    static STRUCT_IF_C aBFu0s_Ui_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aBFu0s_Ui_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aBFu0s_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu16ll, aBFu0s_Ui_BFu16ll)
//============================================================================



static void Test_aBFu0s_Ui_BFu16s()
{
  {
    init_simple_test("aBFu0s_Ui_BFu16s");
    static STRUCT_IF_C aBFu0s_Ui_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aBFu0s_Ui_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aBFu0s_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu16s, aBFu0s_Ui_BFu16s)
//============================================================================



static void Test_aBFu0s_Ui_BFu17i()
{
  {
    init_simple_test("aBFu0s_Ui_BFu17i");
    static STRUCT_IF_C aBFu0s_Ui_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu0s_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aBFu0s_Ui_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aBFu0s_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu17i, aBFu0s_Ui_BFu17i)
//============================================================================



static void Test_aBFu0s_Ui_BFu17ll()
{
  {
    init_simple_test("aBFu0s_Ui_BFu17ll");
    static STRUCT_IF_C aBFu0s_Ui_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu0s_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aBFu0s_Ui_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aBFu0s_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu17ll, aBFu0s_Ui_BFu17ll)
//============================================================================



static void Test_aBFu0s_Ui_BFu1c()
{
  {
    init_simple_test("aBFu0s_Ui_BFu1c");
    static STRUCT_IF_C aBFu0s_Ui_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu0s_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu1c, aBFu0s_Ui_BFu1c)
//============================================================================



static void Test_aBFu0s_Ui_BFu1i()
{
  {
    init_simple_test("aBFu0s_Ui_BFu1i");
    static STRUCT_IF_C aBFu0s_Ui_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu0s_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu1i, aBFu0s_Ui_BFu1i)
//============================================================================



static void Test_aBFu0s_Ui_BFu1ll()
{
  {
    init_simple_test("aBFu0s_Ui_BFu1ll");
    static STRUCT_IF_C aBFu0s_Ui_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu0s_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu1ll, aBFu0s_Ui_BFu1ll)
//============================================================================



static void Test_aBFu0s_Ui_BFu1s()
{
  {
    init_simple_test("aBFu0s_Ui_BFu1s");
    static STRUCT_IF_C aBFu0s_Ui_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aBFu0s_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu1s, aBFu0s_Ui_BFu1s)
//============================================================================



static void Test_aBFu0s_Ui_BFu31i()
{
  {
    init_simple_test("aBFu0s_Ui_BFu31i");
    static STRUCT_IF_C aBFu0s_Ui_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aBFu0s_Ui_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aBFu0s_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu31i, aBFu0s_Ui_BFu31i)
//============================================================================



static void Test_aBFu0s_Ui_BFu31ll()
{
  {
    init_simple_test("aBFu0s_Ui_BFu31ll");
    static STRUCT_IF_C aBFu0s_Ui_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aBFu0s_Ui_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aBFu0s_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu31ll, aBFu0s_Ui_BFu31ll)
//============================================================================



static void Test_aBFu0s_Ui_BFu32i()
{
  {
    init_simple_test("aBFu0s_Ui_BFu32i");
    static STRUCT_IF_C aBFu0s_Ui_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aBFu0s_Ui_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aBFu0s_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu32i, aBFu0s_Ui_BFu32i)
//============================================================================



static void Test_aBFu0s_Ui_BFu32ll()
{
  {
    init_simple_test("aBFu0s_Ui_BFu32ll");
    static STRUCT_IF_C aBFu0s_Ui_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aBFu0s_Ui_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aBFu0s_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu32ll, aBFu0s_Ui_BFu32ll)
//============================================================================



static void Test_aBFu0s_Ui_BFu33()
{
  {
    init_simple_test("aBFu0s_Ui_BFu33");
    static STRUCT_IF_C aBFu0s_Ui_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aBFu0s_Ui_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aBFu0s_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu33, aBFu0s_Ui_BFu33)
//============================================================================



static void Test_aBFu0s_Ui_BFu7c()
{
  {
    init_simple_test("aBFu0s_Ui_BFu7c");
    static STRUCT_IF_C aBFu0s_Ui_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu0s_Ui_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu0s_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu7c, aBFu0s_Ui_BFu7c)
//============================================================================



static void Test_aBFu0s_Ui_BFu7i()
{
  {
    init_simple_test("aBFu0s_Ui_BFu7i");
    static STRUCT_IF_C aBFu0s_Ui_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu0s_Ui_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu0s_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu7i, aBFu0s_Ui_BFu7i)
//============================================================================



static void Test_aBFu0s_Ui_BFu7ll()
{
  {
    init_simple_test("aBFu0s_Ui_BFu7ll");
    static STRUCT_IF_C aBFu0s_Ui_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu0s_Ui_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu0s_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu7ll, aBFu0s_Ui_BFu7ll)
//============================================================================



static void Test_aBFu0s_Ui_BFu7s()
{
  {
    init_simple_test("aBFu0s_Ui_BFu7s");
    static STRUCT_IF_C aBFu0s_Ui_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aBFu0s_Ui_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aBFu0s_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu7s, aBFu0s_Ui_BFu7s)
//============================================================================



static void Test_aBFu0s_Ui_BFu8c()
{
  {
    init_simple_test("aBFu0s_Ui_BFu8c");
    static STRUCT_IF_C aBFu0s_Ui_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu0s_Ui_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu0s_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu8c, aBFu0s_Ui_BFu8c)
//============================================================================



static void Test_aBFu0s_Ui_BFu8i()
{
  {
    init_simple_test("aBFu0s_Ui_BFu8i");
    static STRUCT_IF_C aBFu0s_Ui_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu0s_Ui_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu0s_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu8i, aBFu0s_Ui_BFu8i)
//============================================================================



static void Test_aBFu0s_Ui_BFu8ll()
{
  {
    init_simple_test("aBFu0s_Ui_BFu8ll");
    static STRUCT_IF_C aBFu0s_Ui_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu0s_Ui_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu0s_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu8ll, aBFu0s_Ui_BFu8ll)
//============================================================================



static void Test_aBFu0s_Ui_BFu8s()
{
  {
    init_simple_test("aBFu0s_Ui_BFu8s");
    static STRUCT_IF_C aBFu0s_Ui_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aBFu0s_Ui_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aBFu0s_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu8s, aBFu0s_Ui_BFu8s)
//============================================================================



static void Test_aBFu0s_Ui_BFu9i()
{
  {
    init_simple_test("aBFu0s_Ui_BFu9i");
    static STRUCT_IF_C aBFu0s_Ui_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aBFu0s_Ui_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aBFu0s_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu9i, aBFu0s_Ui_BFu9i)
//============================================================================



static void Test_aBFu0s_Ui_BFu9ll()
{
  {
    init_simple_test("aBFu0s_Ui_BFu9ll");
    static STRUCT_IF_C aBFu0s_Ui_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aBFu0s_Ui_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aBFu0s_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu9ll, aBFu0s_Ui_BFu9ll)
//============================================================================



static void Test_aBFu0s_Ui_BFu9s()
{
  {
    init_simple_test("aBFu0s_Ui_BFu9s");
    static STRUCT_IF_C aBFu0s_Ui_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aBFu0s_Ui_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aBFu0s_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_BFu9s, aBFu0s_Ui_BFu9s)
//============================================================================



static void Test_aBFu0s_Ui_C()
{
  {
    init_simple_test("aBFu0s_Ui_C");
    static STRUCT_IF_C aBFu0s_Ui_C lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_C.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_C, aBFu0s_Ui_C)
//============================================================================



static void Test_aBFu0s_Ui_D()
{
  {
    init_simple_test("aBFu0s_Ui_D");
    static STRUCT_IF_C aBFu0s_Ui_D lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_D.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_D, aBFu0s_Ui_D)
//============================================================================



static void Test_aBFu0s_Ui_F()
{
  {
    init_simple_test("aBFu0s_Ui_F");
    static STRUCT_IF_C aBFu0s_Ui_F lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_F.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_F, aBFu0s_Ui_F)
//============================================================================



static void Test_aBFu0s_Ui_I()
{
  {
    init_simple_test("aBFu0s_Ui_I");
    static STRUCT_IF_C aBFu0s_Ui_I lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_I.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_I, aBFu0s_Ui_I)
//============================================================================



static void Test_aBFu0s_Ui_Ip()
{
  {
    init_simple_test("aBFu0s_Ui_Ip");
    static STRUCT_IF_C aBFu0s_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_Ip.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_Ip, aBFu0s_Ui_Ip)
//============================================================================



static void Test_aBFu0s_Ui_L()
{
  {
    init_simple_test("aBFu0s_Ui_L");
    static STRUCT_IF_C aBFu0s_Ui_L lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_L.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_L, aBFu0s_Ui_L)
//============================================================================



static void Test_aBFu0s_Ui_S()
{
  {
    init_simple_test("aBFu0s_Ui_S");
    static STRUCT_IF_C aBFu0s_Ui_S lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_S.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_S, aBFu0s_Ui_S)
//============================================================================



static void Test_aBFu0s_Ui_Uc()
{
  {
    init_simple_test("aBFu0s_Ui_Uc");
    static STRUCT_IF_C aBFu0s_Ui_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_Uc.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_Uc, aBFu0s_Ui_Uc)
//============================================================================



static void Test_aBFu0s_Ui_Ui()
{
  {
    init_simple_test("aBFu0s_Ui_Ui");
    static STRUCT_IF_C aBFu0s_Ui_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_Ui.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_Ui, aBFu0s_Ui_Ui)
//============================================================================



static void Test_aBFu0s_Ui_Ul()
{
  {
    init_simple_test("aBFu0s_Ui_Ul");
    static STRUCT_IF_C aBFu0s_Ui_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_Ul.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_Ul, aBFu0s_Ui_Ul)
//============================================================================



static void Test_aBFu0s_Ui_Us()
{
  {
    init_simple_test("aBFu0s_Ui_Us");
    static STRUCT_IF_C aBFu0s_Ui_Us lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_Us.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_Us, aBFu0s_Ui_Us)
//============================================================================



static void Test_aBFu0s_Ui_Vp()
{
  {
    init_simple_test("aBFu0s_Ui_Vp");
    static STRUCT_IF_C aBFu0s_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_Vp.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_Vp, aBFu0s_Ui_Vp)
//============================================================================



static void Test_aBFu0s_Ul()
{
  {
    init_simple_test("aBFu0s_Ul");
    static STRUCT_IF_C aBFu0s_Ul lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul, aBFu0s_Ul)
//============================================================================



static void Test_aBFu0s_Ul_BFu0c()
{
  {
    init_simple_test("aBFu0s_Ul_BFu0c");
    static STRUCT_IF_C aBFu0s_Ul_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Ul_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu0c, aBFu0s_Ul_BFu0c)
//============================================================================



static void Test_aBFu0s_Ul_BFu0i()
{
  {
    init_simple_test("aBFu0s_Ul_BFu0i");
    static STRUCT_IF_C aBFu0s_Ul_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Ul_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu0i, aBFu0s_Ul_BFu0i)
//============================================================================



static void Test_aBFu0s_Ul_BFu0ll()
{
  {
    init_simple_test("aBFu0s_Ul_BFu0ll");
    static STRUCT_IF_C aBFu0s_Ul_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Ul_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu0ll, aBFu0s_Ul_BFu0ll)
//============================================================================



static void Test_aBFu0s_Ul_BFu0s()
{
  {
    init_simple_test("aBFu0s_Ul_BFu0s");
    static STRUCT_IF_C aBFu0s_Ul_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Ul_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu0s, aBFu0s_Ul_BFu0s)
//============================================================================



static void Test_aBFu0s_Ul_BFu15i()
{
  {
    init_simple_test("aBFu0s_Ul_BFu15i");
    static STRUCT_IF_C aBFu0s_Ul_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aBFu0s_Ul_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aBFu0s_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu15i, aBFu0s_Ul_BFu15i)
//============================================================================



static void Test_aBFu0s_Ul_BFu15ll()
{
  {
    init_simple_test("aBFu0s_Ul_BFu15ll");
    static STRUCT_IF_C aBFu0s_Ul_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aBFu0s_Ul_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aBFu0s_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu15ll, aBFu0s_Ul_BFu15ll)
//============================================================================



static void Test_aBFu0s_Ul_BFu15s()
{
  {
    init_simple_test("aBFu0s_Ul_BFu15s");
    static STRUCT_IF_C aBFu0s_Ul_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aBFu0s_Ul_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aBFu0s_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu15s, aBFu0s_Ul_BFu15s)
//============================================================================



static void Test_aBFu0s_Ul_BFu16i()
{
  {
    init_simple_test("aBFu0s_Ul_BFu16i");
    static STRUCT_IF_C aBFu0s_Ul_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aBFu0s_Ul_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aBFu0s_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu16i, aBFu0s_Ul_BFu16i)
//============================================================================



static void Test_aBFu0s_Ul_BFu16ll()
{
  {
    init_simple_test("aBFu0s_Ul_BFu16ll");
    static STRUCT_IF_C aBFu0s_Ul_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aBFu0s_Ul_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aBFu0s_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu16ll, aBFu0s_Ul_BFu16ll)
//============================================================================



static void Test_aBFu0s_Ul_BFu16s()
{
  {
    init_simple_test("aBFu0s_Ul_BFu16s");
    static STRUCT_IF_C aBFu0s_Ul_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aBFu0s_Ul_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aBFu0s_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu16s, aBFu0s_Ul_BFu16s)
//============================================================================



static void Test_aBFu0s_Ul_BFu17i()
{
  {
    init_simple_test("aBFu0s_Ul_BFu17i");
    static STRUCT_IF_C aBFu0s_Ul_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(aBFu0s_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "aBFu0s_Ul_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "aBFu0s_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu17i, aBFu0s_Ul_BFu17i)
//============================================================================



static void Test_aBFu0s_Ul_BFu17ll()
{
  {
    init_simple_test("aBFu0s_Ul_BFu17ll");
    static STRUCT_IF_C aBFu0s_Ul_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(aBFu0s_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "aBFu0s_Ul_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "aBFu0s_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu17ll, aBFu0s_Ul_BFu17ll)
//============================================================================



static void Test_aBFu0s_Ul_BFu1c()
{
  {
    init_simple_test("aBFu0s_Ul_BFu1c");
    static STRUCT_IF_C aBFu0s_Ul_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "aBFu0s_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu1c, aBFu0s_Ul_BFu1c)
//============================================================================



static void Test_aBFu0s_Ul_BFu1i()
{
  {
    init_simple_test("aBFu0s_Ul_BFu1i");
    static STRUCT_IF_C aBFu0s_Ul_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "aBFu0s_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu1i, aBFu0s_Ul_BFu1i)
//============================================================================



static void Test_aBFu0s_Ul_BFu1ll()
{
  {
    init_simple_test("aBFu0s_Ul_BFu1ll");
    static STRUCT_IF_C aBFu0s_Ul_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "aBFu0s_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu1ll, aBFu0s_Ul_BFu1ll)
//============================================================================



static void Test_aBFu0s_Ul_BFu1s()
{
  {
    init_simple_test("aBFu0s_Ul_BFu1s");
    static STRUCT_IF_C aBFu0s_Ul_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "aBFu0s_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu1s, aBFu0s_Ul_BFu1s)
//============================================================================



static void Test_aBFu0s_Ul_BFu31i()
{
  {
    init_simple_test("aBFu0s_Ul_BFu31i");
    static STRUCT_IF_C aBFu0s_Ul_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "aBFu0s_Ul_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "aBFu0s_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu31i, aBFu0s_Ul_BFu31i)
//============================================================================



static void Test_aBFu0s_Ul_BFu31ll()
{
  {
    init_simple_test("aBFu0s_Ul_BFu31ll");
    static STRUCT_IF_C aBFu0s_Ul_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "aBFu0s_Ul_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "aBFu0s_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu31ll, aBFu0s_Ul_BFu31ll)
//============================================================================



static void Test_aBFu0s_Ul_BFu32i()
{
  {
    init_simple_test("aBFu0s_Ul_BFu32i");
    static STRUCT_IF_C aBFu0s_Ul_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "aBFu0s_Ul_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "aBFu0s_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu32i, aBFu0s_Ul_BFu32i)
//============================================================================



static void Test_aBFu0s_Ul_BFu32ll()
{
  {
    init_simple_test("aBFu0s_Ul_BFu32ll");
    static STRUCT_IF_C aBFu0s_Ul_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "aBFu0s_Ul_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "aBFu0s_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu32ll, aBFu0s_Ul_BFu32ll)
//============================================================================



static void Test_aBFu0s_Ul_BFu33()
{
  {
    init_simple_test("aBFu0s_Ul_BFu33");
    static STRUCT_IF_C aBFu0s_Ul_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(aBFu0s_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "aBFu0s_Ul_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "aBFu0s_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu33, aBFu0s_Ul_BFu33)
//============================================================================



static void Test_aBFu0s_Ul_BFu7c()
{
  {
    init_simple_test("aBFu0s_Ul_BFu7c");
    static STRUCT_IF_C aBFu0s_Ul_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "aBFu0s_Ul_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "aBFu0s_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu7c, aBFu0s_Ul_BFu7c)
//============================================================================



static void Test_aBFu0s_Ul_BFu7i()
{
  {
    init_simple_test("aBFu0s_Ul_BFu7i");
    static STRUCT_IF_C aBFu0s_Ul_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "aBFu0s_Ul_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "aBFu0s_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu7i, aBFu0s_Ul_BFu7i)
//============================================================================



static void Test_aBFu0s_Ul_BFu7ll()
{
  {
    init_simple_test("aBFu0s_Ul_BFu7ll");
    static STRUCT_IF_C aBFu0s_Ul_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "aBFu0s_Ul_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "aBFu0s_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu7ll, aBFu0s_Ul_BFu7ll)
//============================================================================



static void Test_aBFu0s_Ul_BFu7s()
{
  {
    init_simple_test("aBFu0s_Ul_BFu7s");
    static STRUCT_IF_C aBFu0s_Ul_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "aBFu0s_Ul_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "aBFu0s_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu7s, aBFu0s_Ul_BFu7s)
//============================================================================



static void Test_aBFu0s_Ul_BFu8c()
{
  {
    init_simple_test("aBFu0s_Ul_BFu8c");
    static STRUCT_IF_C aBFu0s_Ul_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aBFu0s_Ul_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aBFu0s_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu8c, aBFu0s_Ul_BFu8c)
//============================================================================



static void Test_aBFu0s_Ul_BFu8i()
{
  {
    init_simple_test("aBFu0s_Ul_BFu8i");
    static STRUCT_IF_C aBFu0s_Ul_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aBFu0s_Ul_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aBFu0s_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu8i, aBFu0s_Ul_BFu8i)
//============================================================================



static void Test_aBFu0s_Ul_BFu8ll()
{
  {
    init_simple_test("aBFu0s_Ul_BFu8ll");
    static STRUCT_IF_C aBFu0s_Ul_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aBFu0s_Ul_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aBFu0s_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu8ll, aBFu0s_Ul_BFu8ll)
//============================================================================



static void Test_aBFu0s_Ul_BFu8s()
{
  {
    init_simple_test("aBFu0s_Ul_BFu8s");
    static STRUCT_IF_C aBFu0s_Ul_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aBFu0s_Ul_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aBFu0s_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu8s, aBFu0s_Ul_BFu8s)
//============================================================================



static void Test_aBFu0s_Ul_BFu9i()
{
  {
    init_simple_test("aBFu0s_Ul_BFu9i");
    static STRUCT_IF_C aBFu0s_Ul_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aBFu0s_Ul_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aBFu0s_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu9i, aBFu0s_Ul_BFu9i)
//============================================================================



static void Test_aBFu0s_Ul_BFu9ll()
{
  {
    init_simple_test("aBFu0s_Ul_BFu9ll");
    static STRUCT_IF_C aBFu0s_Ul_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aBFu0s_Ul_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aBFu0s_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu9ll, aBFu0s_Ul_BFu9ll)
//============================================================================



static void Test_aBFu0s_Ul_BFu9s()
{
  {
    init_simple_test("aBFu0s_Ul_BFu9s");
    static STRUCT_IF_C aBFu0s_Ul_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aBFu0s_Ul_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aBFu0s_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_BFu9s, aBFu0s_Ul_BFu9s)
//============================================================================



static void Test_aBFu0s_Ul_C()
{
  {
    init_simple_test("aBFu0s_Ul_C");
    static STRUCT_IF_C aBFu0s_Ul_C lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_C.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_C, aBFu0s_Ul_C)
//============================================================================



static void Test_aBFu0s_Ul_D()
{
  {
    init_simple_test("aBFu0s_Ul_D");
    static STRUCT_IF_C aBFu0s_Ul_D lv;
    check2(sizeof(lv), 16, "sizeof(aBFu0s_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_D.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_D, aBFu0s_Ul_D)
//============================================================================



static void Test_aBFu0s_Ul_F()
{
  {
    init_simple_test("aBFu0s_Ul_F");
    static STRUCT_IF_C aBFu0s_Ul_F lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_F.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_F, aBFu0s_Ul_F)
//============================================================================



static void Test_aBFu0s_Ul_I()
{
  {
    init_simple_test("aBFu0s_Ul_I");
    static STRUCT_IF_C aBFu0s_Ul_I lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_I.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_I, aBFu0s_Ul_I)
//============================================================================



static void Test_aBFu0s_Ul_Ip()
{
  {
    init_simple_test("aBFu0s_Ul_Ip");
    static STRUCT_IF_C aBFu0s_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu0s_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_Ip.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_Ip, aBFu0s_Ul_Ip)
//============================================================================



static void Test_aBFu0s_Ul_L()
{
  {
    init_simple_test("aBFu0s_Ul_L");
    static STRUCT_IF_C aBFu0s_Ul_L lv;
    check2(sizeof(lv), 16, "sizeof(aBFu0s_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_L.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_L, aBFu0s_Ul_L)
//============================================================================



static void Test_aBFu0s_Ul_S()
{
  {
    init_simple_test("aBFu0s_Ul_S");
    static STRUCT_IF_C aBFu0s_Ul_S lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_S.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_S, aBFu0s_Ul_S)
//============================================================================



static void Test_aBFu0s_Ul_Uc()
{
  {
    init_simple_test("aBFu0s_Ul_Uc");
    static STRUCT_IF_C aBFu0s_Ul_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aBFu0s_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_Uc.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_Uc, aBFu0s_Ul_Uc)
//============================================================================



static void Test_aBFu0s_Ul_Ui()
{
  {
    init_simple_test("aBFu0s_Ul_Ui");
    static STRUCT_IF_C aBFu0s_Ul_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aBFu0s_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_Ui.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_Ui, aBFu0s_Ul_Ui)
//============================================================================



static void Test_aBFu0s_Ul_Ul()
{
  {
    init_simple_test("aBFu0s_Ul_Ul");
    static STRUCT_IF_C aBFu0s_Ul_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aBFu0s_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_Ul.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_Ul, aBFu0s_Ul_Ul)
//============================================================================



static void Test_aBFu0s_Ul_Us()
{
  {
    init_simple_test("aBFu0s_Ul_Us");
    static STRUCT_IF_C aBFu0s_Ul_Us lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_Us.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_Us, aBFu0s_Ul_Us)
//============================================================================



static void Test_aBFu0s_Ul_Vp()
{
  {
    init_simple_test("aBFu0s_Ul_Vp");
    static STRUCT_IF_C aBFu0s_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu0s_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_Vp.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_Vp, aBFu0s_Ul_Vp)
//============================================================================



static void Test_aBFu0s_Us()
{
  {
    init_simple_test("aBFu0s_Us");
    static STRUCT_IF_C aBFu0s_Us lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us, aBFu0s_Us)
//============================================================================



static void Test_aBFu0s_Us_BFu0c()
{
  {
    init_simple_test("aBFu0s_Us_BFu0c");
    static STRUCT_IF_C aBFu0s_Us_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Us_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu0c, aBFu0s_Us_BFu0c)
//============================================================================



static void Test_aBFu0s_Us_BFu0i()
{
  {
    init_simple_test("aBFu0s_Us_BFu0i");
    static STRUCT_IF_C aBFu0s_Us_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu0s_Us_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu0i, aBFu0s_Us_BFu0i)
//============================================================================



static void Test_aBFu0s_Us_BFu0ll()
{
  {
    init_simple_test("aBFu0s_Us_BFu0ll");
    static STRUCT_IF_C aBFu0s_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Us_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu0ll, aBFu0s_Us_BFu0ll)
//============================================================================



static void Test_aBFu0s_Us_BFu0s()
{
  {
    init_simple_test("aBFu0s_Us_BFu0s");
    static STRUCT_IF_C aBFu0s_Us_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Us_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu0s, aBFu0s_Us_BFu0s)
//============================================================================



static void Test_aBFu0s_Us_BFu15i()
{
  {
    init_simple_test("aBFu0s_Us_BFu15i");
    static STRUCT_IF_C aBFu0s_Us_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu0s_Us_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu0s_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu15i, aBFu0s_Us_BFu15i)
//============================================================================



static void Test_aBFu0s_Us_BFu15ll()
{
  {
    init_simple_test("aBFu0s_Us_BFu15ll");
    static STRUCT_IF_C aBFu0s_Us_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu0s_Us_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu0s_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu15ll, aBFu0s_Us_BFu15ll)
//============================================================================



static void Test_aBFu0s_Us_BFu15s()
{
  {
    init_simple_test("aBFu0s_Us_BFu15s");
    static STRUCT_IF_C aBFu0s_Us_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu0s_Us_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu0s_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu15s, aBFu0s_Us_BFu15s)
//============================================================================



static void Test_aBFu0s_Us_BFu16i()
{
  {
    init_simple_test("aBFu0s_Us_BFu16i");
    static STRUCT_IF_C aBFu0s_Us_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu0s_Us_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu0s_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu16i, aBFu0s_Us_BFu16i)
//============================================================================



static void Test_aBFu0s_Us_BFu16ll()
{
  {
    init_simple_test("aBFu0s_Us_BFu16ll");
    static STRUCT_IF_C aBFu0s_Us_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu0s_Us_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu0s_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu16ll, aBFu0s_Us_BFu16ll)
//============================================================================



static void Test_aBFu0s_Us_BFu16s()
{
  {
    init_simple_test("aBFu0s_Us_BFu16s");
    static STRUCT_IF_C aBFu0s_Us_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu0s_Us_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu0s_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu16s, aBFu0s_Us_BFu16s)
//============================================================================



static void Test_aBFu0s_Us_BFu17i()
{
  {
    init_simple_test("aBFu0s_Us_BFu17i");
    static STRUCT_IF_C aBFu0s_Us_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aBFu0s_Us_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aBFu0s_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu17i, aBFu0s_Us_BFu17i)
//============================================================================



static void Test_aBFu0s_Us_BFu17ll()
{
  {
    init_simple_test("aBFu0s_Us_BFu17ll");
    static STRUCT_IF_C aBFu0s_Us_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aBFu0s_Us_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aBFu0s_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu17ll, aBFu0s_Us_BFu17ll)
//============================================================================



static void Test_aBFu0s_Us_BFu1c()
{
  {
    init_simple_test("aBFu0s_Us_BFu1c");
    static STRUCT_IF_C aBFu0s_Us_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu0s_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu1c, aBFu0s_Us_BFu1c)
//============================================================================



static void Test_aBFu0s_Us_BFu1i()
{
  {
    init_simple_test("aBFu0s_Us_BFu1i");
    static STRUCT_IF_C aBFu0s_Us_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu0s_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu1i, aBFu0s_Us_BFu1i)
//============================================================================



static void Test_aBFu0s_Us_BFu1ll()
{
  {
    init_simple_test("aBFu0s_Us_BFu1ll");
    static STRUCT_IF_C aBFu0s_Us_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu0s_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu1ll, aBFu0s_Us_BFu1ll)
//============================================================================



static void Test_aBFu0s_Us_BFu1s()
{
  {
    init_simple_test("aBFu0s_Us_BFu1s");
    static STRUCT_IF_C aBFu0s_Us_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu0s_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu1s, aBFu0s_Us_BFu1s)
//============================================================================



static void Test_aBFu0s_Us_BFu31i()
{
  {
    init_simple_test("aBFu0s_Us_BFu31i");
    static STRUCT_IF_C aBFu0s_Us_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu0s_Us_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu0s_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu31i, aBFu0s_Us_BFu31i)
//============================================================================



static void Test_aBFu0s_Us_BFu31ll()
{
  {
    init_simple_test("aBFu0s_Us_BFu31ll");
    static STRUCT_IF_C aBFu0s_Us_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu0s_Us_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu0s_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu31ll, aBFu0s_Us_BFu31ll)
//============================================================================



static void Test_aBFu0s_Us_BFu32i()
{
  {
    init_simple_test("aBFu0s_Us_BFu32i");
    static STRUCT_IF_C aBFu0s_Us_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu0s_Us_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu0s_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu32i, aBFu0s_Us_BFu32i)
//============================================================================



static void Test_aBFu0s_Us_BFu32ll()
{
  {
    init_simple_test("aBFu0s_Us_BFu32ll");
    static STRUCT_IF_C aBFu0s_Us_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu0s_Us_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu0s_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu32ll, aBFu0s_Us_BFu32ll)
//============================================================================



static void Test_aBFu0s_Us_BFu33()
{
  {
    init_simple_test("aBFu0s_Us_BFu33");
    static STRUCT_IF_C aBFu0s_Us_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu0s_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu0s_Us_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu0s_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu33, aBFu0s_Us_BFu33)
//============================================================================



static void Test_aBFu0s_Us_BFu7c()
{
  {
    init_simple_test("aBFu0s_Us_BFu7c");
    static STRUCT_IF_C aBFu0s_Us_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu0s_Us_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu0s_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu7c, aBFu0s_Us_BFu7c)
//============================================================================



static void Test_aBFu0s_Us_BFu7i()
{
  {
    init_simple_test("aBFu0s_Us_BFu7i");
    static STRUCT_IF_C aBFu0s_Us_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu0s_Us_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu0s_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu7i, aBFu0s_Us_BFu7i)
//============================================================================



static void Test_aBFu0s_Us_BFu7ll()
{
  {
    init_simple_test("aBFu0s_Us_BFu7ll");
    static STRUCT_IF_C aBFu0s_Us_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu0s_Us_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu0s_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu7ll, aBFu0s_Us_BFu7ll)
//============================================================================



static void Test_aBFu0s_Us_BFu7s()
{
  {
    init_simple_test("aBFu0s_Us_BFu7s");
    static STRUCT_IF_C aBFu0s_Us_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu0s_Us_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu0s_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu7s, aBFu0s_Us_BFu7s)
//============================================================================



static void Test_aBFu0s_Us_BFu8c()
{
  {
    init_simple_test("aBFu0s_Us_BFu8c");
    static STRUCT_IF_C aBFu0s_Us_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu0s_Us_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu0s_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu8c, aBFu0s_Us_BFu8c)
//============================================================================



static void Test_aBFu0s_Us_BFu8i()
{
  {
    init_simple_test("aBFu0s_Us_BFu8i");
    static STRUCT_IF_C aBFu0s_Us_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu0s_Us_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu0s_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu8i, aBFu0s_Us_BFu8i)
//============================================================================



static void Test_aBFu0s_Us_BFu8ll()
{
  {
    init_simple_test("aBFu0s_Us_BFu8ll");
    static STRUCT_IF_C aBFu0s_Us_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu0s_Us_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu0s_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu8ll, aBFu0s_Us_BFu8ll)
//============================================================================



static void Test_aBFu0s_Us_BFu8s()
{
  {
    init_simple_test("aBFu0s_Us_BFu8s");
    static STRUCT_IF_C aBFu0s_Us_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu0s_Us_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu0s_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu8s, aBFu0s_Us_BFu8s)
//============================================================================



static void Test_aBFu0s_Us_BFu9i()
{
  {
    init_simple_test("aBFu0s_Us_BFu9i");
    static STRUCT_IF_C aBFu0s_Us_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu0s_Us_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu0s_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu9i, aBFu0s_Us_BFu9i)
//============================================================================



static void Test_aBFu0s_Us_BFu9ll()
{
  {
    init_simple_test("aBFu0s_Us_BFu9ll");
    static STRUCT_IF_C aBFu0s_Us_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu0s_Us_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu0s_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu9ll, aBFu0s_Us_BFu9ll)
//============================================================================



static void Test_aBFu0s_Us_BFu9s()
{
  {
    init_simple_test("aBFu0s_Us_BFu9s");
    static STRUCT_IF_C aBFu0s_Us_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu0s_Us_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu0s_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_BFu9s, aBFu0s_Us_BFu9s)
//============================================================================



static void Test_aBFu0s_Us_C()
{
  {
    init_simple_test("aBFu0s_Us_C");
    static STRUCT_IF_C aBFu0s_Us_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_C.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_C, aBFu0s_Us_C)
//============================================================================



static void Test_aBFu0s_Us_D()
{
  {
    init_simple_test("aBFu0s_Us_D");
    static STRUCT_IF_C aBFu0s_Us_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_D.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_D, aBFu0s_Us_D)
//============================================================================



static void Test_aBFu0s_Us_F()
{
  {
    init_simple_test("aBFu0s_Us_F");
    static STRUCT_IF_C aBFu0s_Us_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_F.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_F, aBFu0s_Us_F)
//============================================================================



static void Test_aBFu0s_Us_I()
{
  {
    init_simple_test("aBFu0s_Us_I");
    static STRUCT_IF_C aBFu0s_Us_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_I.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_I, aBFu0s_Us_I)
//============================================================================



static void Test_aBFu0s_Us_Ip()
{
  {
    init_simple_test("aBFu0s_Us_Ip");
    static STRUCT_IF_C aBFu0s_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_Ip.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_Ip, aBFu0s_Us_Ip)
//============================================================================



static void Test_aBFu0s_Us_L()
{
  {
    init_simple_test("aBFu0s_Us_L");
    static STRUCT_IF_C aBFu0s_Us_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_L.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_L, aBFu0s_Us_L)
//============================================================================



static void Test_aBFu0s_Us_S()
{
  {
    init_simple_test("aBFu0s_Us_S");
    static STRUCT_IF_C aBFu0s_Us_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_S.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_S, aBFu0s_Us_S)
//============================================================================



static void Test_aBFu0s_Us_Uc()
{
  {
    init_simple_test("aBFu0s_Us_Uc");
    static STRUCT_IF_C aBFu0s_Us_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_Uc.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_Uc, aBFu0s_Us_Uc)
//============================================================================



static void Test_aBFu0s_Us_Ui()
{
  {
    init_simple_test("aBFu0s_Us_Ui");
    static STRUCT_IF_C aBFu0s_Us_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu0s_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_Ui.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_Ui, aBFu0s_Us_Ui)
//============================================================================



static void Test_aBFu0s_Us_Ul()
{
  {
    init_simple_test("aBFu0s_Us_Ul");
    static STRUCT_IF_C aBFu0s_Us_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu0s_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_Ul.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_Ul, aBFu0s_Us_Ul)
//============================================================================



static void Test_aBFu0s_Us_Us()
{
  {
    init_simple_test("aBFu0s_Us_Us");
    static STRUCT_IF_C aBFu0s_Us_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_Us.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_Us, aBFu0s_Us_Us)
//============================================================================



static void Test_aBFu0s_Us_Vp()
{
  {
    init_simple_test("aBFu0s_Us_Vp");
    static STRUCT_IF_C aBFu0s_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_Vp.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_Vp, aBFu0s_Us_Vp)
//============================================================================



static void Test_aBFu0s_Vp()
{
  {
    init_simple_test("aBFu0s_Vp");
    static STRUCT_IF_C aBFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp, aBFu0s_Vp)
//============================================================================



static void Test_aBFu0s_Vp_BFu0c()
{
  {
    init_simple_test("aBFu0s_Vp_BFu0c");
    static STRUCT_IF_C aBFu0s_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Vp_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu0c, aBFu0s_Vp_BFu0c)
//============================================================================



static void Test_aBFu0s_Vp_BFu0i()
{
  {
    init_simple_test("aBFu0s_Vp_BFu0i");
    static STRUCT_IF_C aBFu0s_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Vp_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu0i, aBFu0s_Vp_BFu0i)
//============================================================================



static void Test_aBFu0s_Vp_BFu0ll()
{
  {
    init_simple_test("aBFu0s_Vp_BFu0ll");
    static STRUCT_IF_C aBFu0s_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Vp_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu0ll, aBFu0s_Vp_BFu0ll)
//============================================================================



static void Test_aBFu0s_Vp_BFu0s()
{
  {
    init_simple_test("aBFu0s_Vp_BFu0s");
    static STRUCT_IF_C aBFu0s_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Vp_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu0s, aBFu0s_Vp_BFu0s)
//============================================================================



static void Test_aBFu0s_Vp_BFu15i()
{
  {
    init_simple_test("aBFu0s_Vp_BFu15i");
    static STRUCT_IF_C aBFu0s_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aBFu0s_Vp_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aBFu0s_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu15i, aBFu0s_Vp_BFu15i)
//============================================================================



static void Test_aBFu0s_Vp_BFu15ll()
{
  {
    init_simple_test("aBFu0s_Vp_BFu15ll");
    static STRUCT_IF_C aBFu0s_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aBFu0s_Vp_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aBFu0s_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu15ll, aBFu0s_Vp_BFu15ll)
//============================================================================



static void Test_aBFu0s_Vp_BFu15s()
{
  {
    init_simple_test("aBFu0s_Vp_BFu15s");
    static STRUCT_IF_C aBFu0s_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aBFu0s_Vp_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aBFu0s_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu15s, aBFu0s_Vp_BFu15s)
//============================================================================



static void Test_aBFu0s_Vp_BFu16i()
{
  {
    init_simple_test("aBFu0s_Vp_BFu16i");
    static STRUCT_IF_C aBFu0s_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aBFu0s_Vp_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aBFu0s_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu16i, aBFu0s_Vp_BFu16i)
//============================================================================



static void Test_aBFu0s_Vp_BFu16ll()
{
  {
    init_simple_test("aBFu0s_Vp_BFu16ll");
    static STRUCT_IF_C aBFu0s_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aBFu0s_Vp_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aBFu0s_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu16ll, aBFu0s_Vp_BFu16ll)
//============================================================================



static void Test_aBFu0s_Vp_BFu16s()
{
  {
    init_simple_test("aBFu0s_Vp_BFu16s");
    static STRUCT_IF_C aBFu0s_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aBFu0s_Vp_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aBFu0s_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu16s, aBFu0s_Vp_BFu16s)
//============================================================================



static void Test_aBFu0s_Vp_BFu17i()
{
  {
    init_simple_test("aBFu0s_Vp_BFu17i");
    static STRUCT_IF_C aBFu0s_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu0s_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aBFu0s_Vp_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aBFu0s_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu17i, aBFu0s_Vp_BFu17i)
//============================================================================



static void Test_aBFu0s_Vp_BFu17ll()
{
  {
    init_simple_test("aBFu0s_Vp_BFu17ll");
    static STRUCT_IF_C aBFu0s_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu0s_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aBFu0s_Vp_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aBFu0s_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu17ll, aBFu0s_Vp_BFu17ll)
//============================================================================



static void Test_aBFu0s_Vp_BFu1c()
{
  {
    init_simple_test("aBFu0s_Vp_BFu1c");
    static STRUCT_IF_C aBFu0s_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aBFu0s_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu1c, aBFu0s_Vp_BFu1c)
//============================================================================



static void Test_aBFu0s_Vp_BFu1i()
{
  {
    init_simple_test("aBFu0s_Vp_BFu1i");
    static STRUCT_IF_C aBFu0s_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aBFu0s_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu1i, aBFu0s_Vp_BFu1i)
//============================================================================



static void Test_aBFu0s_Vp_BFu1ll()
{
  {
    init_simple_test("aBFu0s_Vp_BFu1ll");
    static STRUCT_IF_C aBFu0s_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aBFu0s_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu1ll, aBFu0s_Vp_BFu1ll)
//============================================================================



static void Test_aBFu0s_Vp_BFu1s()
{
  {
    init_simple_test("aBFu0s_Vp_BFu1s");
    static STRUCT_IF_C aBFu0s_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aBFu0s_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu1s, aBFu0s_Vp_BFu1s)
//============================================================================



static void Test_aBFu0s_Vp_BFu31i()
{
  {
    init_simple_test("aBFu0s_Vp_BFu31i");
    static STRUCT_IF_C aBFu0s_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aBFu0s_Vp_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aBFu0s_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu31i, aBFu0s_Vp_BFu31i)
//============================================================================



static void Test_aBFu0s_Vp_BFu31ll()
{
  {
    init_simple_test("aBFu0s_Vp_BFu31ll");
    static STRUCT_IF_C aBFu0s_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aBFu0s_Vp_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aBFu0s_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu31ll, aBFu0s_Vp_BFu31ll)
//============================================================================



static void Test_aBFu0s_Vp_BFu32i()
{
  {
    init_simple_test("aBFu0s_Vp_BFu32i");
    static STRUCT_IF_C aBFu0s_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aBFu0s_Vp_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aBFu0s_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu32i, aBFu0s_Vp_BFu32i)
//============================================================================



static void Test_aBFu0s_Vp_BFu32ll()
{
  {
    init_simple_test("aBFu0s_Vp_BFu32ll");
    static STRUCT_IF_C aBFu0s_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aBFu0s_Vp_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aBFu0s_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu32ll, aBFu0s_Vp_BFu32ll)
//============================================================================



static void Test_aBFu0s_Vp_BFu33()
{
  {
    init_simple_test("aBFu0s_Vp_BFu33");
    static STRUCT_IF_C aBFu0s_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu0s_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aBFu0s_Vp_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aBFu0s_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu33, aBFu0s_Vp_BFu33)
//============================================================================



static void Test_aBFu0s_Vp_BFu7c()
{
  {
    init_simple_test("aBFu0s_Vp_BFu7c");
    static STRUCT_IF_C aBFu0s_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aBFu0s_Vp_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aBFu0s_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu7c, aBFu0s_Vp_BFu7c)
//============================================================================



static void Test_aBFu0s_Vp_BFu7i()
{
  {
    init_simple_test("aBFu0s_Vp_BFu7i");
    static STRUCT_IF_C aBFu0s_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aBFu0s_Vp_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aBFu0s_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu7i, aBFu0s_Vp_BFu7i)
//============================================================================



static void Test_aBFu0s_Vp_BFu7ll()
{
  {
    init_simple_test("aBFu0s_Vp_BFu7ll");
    static STRUCT_IF_C aBFu0s_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aBFu0s_Vp_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aBFu0s_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu7ll, aBFu0s_Vp_BFu7ll)
//============================================================================



static void Test_aBFu0s_Vp_BFu7s()
{
  {
    init_simple_test("aBFu0s_Vp_BFu7s");
    static STRUCT_IF_C aBFu0s_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aBFu0s_Vp_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aBFu0s_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu7s, aBFu0s_Vp_BFu7s)
//============================================================================



static void Test_aBFu0s_Vp_BFu8c()
{
  {
    init_simple_test("aBFu0s_Vp_BFu8c");
    static STRUCT_IF_C aBFu0s_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aBFu0s_Vp_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aBFu0s_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu8c, aBFu0s_Vp_BFu8c)
//============================================================================



static void Test_aBFu0s_Vp_BFu8i()
{
  {
    init_simple_test("aBFu0s_Vp_BFu8i");
    static STRUCT_IF_C aBFu0s_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aBFu0s_Vp_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aBFu0s_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu8i, aBFu0s_Vp_BFu8i)
//============================================================================



static void Test_aBFu0s_Vp_BFu8ll()
{
  {
    init_simple_test("aBFu0s_Vp_BFu8ll");
    static STRUCT_IF_C aBFu0s_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aBFu0s_Vp_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aBFu0s_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu8ll, aBFu0s_Vp_BFu8ll)
//============================================================================



static void Test_aBFu0s_Vp_BFu8s()
{
  {
    init_simple_test("aBFu0s_Vp_BFu8s");
    static STRUCT_IF_C aBFu0s_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aBFu0s_Vp_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aBFu0s_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu8s, aBFu0s_Vp_BFu8s)
//============================================================================



static void Test_aBFu0s_Vp_BFu9i()
{
  {
    init_simple_test("aBFu0s_Vp_BFu9i");
    static STRUCT_IF_C aBFu0s_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aBFu0s_Vp_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aBFu0s_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu9i, aBFu0s_Vp_BFu9i)
//============================================================================



static void Test_aBFu0s_Vp_BFu9ll()
{
  {
    init_simple_test("aBFu0s_Vp_BFu9ll");
    static STRUCT_IF_C aBFu0s_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aBFu0s_Vp_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aBFu0s_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu9ll, aBFu0s_Vp_BFu9ll)
//============================================================================



static void Test_aBFu0s_Vp_BFu9s()
{
  {
    init_simple_test("aBFu0s_Vp_BFu9s");
    static STRUCT_IF_C aBFu0s_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aBFu0s_Vp_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aBFu0s_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_BFu9s, aBFu0s_Vp_BFu9s)
//============================================================================



static void Test_aBFu0s_Vp_C()
{
  {
    init_simple_test("aBFu0s_Vp_C");
    static STRUCT_IF_C aBFu0s_Vp_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_C, aBFu0s_Vp_C)
//============================================================================



static void Test_aBFu0s_Vp_D()
{
  {
    init_simple_test("aBFu0s_Vp_D");
    static STRUCT_IF_C aBFu0s_Vp_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu0s_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_D, aBFu0s_Vp_D)
//============================================================================



static void Test_aBFu0s_Vp_F()
{
  {
    init_simple_test("aBFu0s_Vp_F");
    static STRUCT_IF_C aBFu0s_Vp_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_F, aBFu0s_Vp_F)
//============================================================================



static void Test_aBFu0s_Vp_I()
{
  {
    init_simple_test("aBFu0s_Vp_I");
    static STRUCT_IF_C aBFu0s_Vp_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_I, aBFu0s_Vp_I)
//============================================================================



static void Test_aBFu0s_Vp_Ip()
{
  {
    init_simple_test("aBFu0s_Vp_Ip");
    static STRUCT_IF_C aBFu0s_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aBFu0s_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_Ip, aBFu0s_Vp_Ip)
//============================================================================



static void Test_aBFu0s_Vp_L()
{
  {
    init_simple_test("aBFu0s_Vp_L");
    static STRUCT_IF_C aBFu0s_Vp_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu0s_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_L, aBFu0s_Vp_L)
//============================================================================



static void Test_aBFu0s_Vp_S()
{
  {
    init_simple_test("aBFu0s_Vp_S");
    static STRUCT_IF_C aBFu0s_Vp_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_S, aBFu0s_Vp_S)
//============================================================================



static void Test_aBFu0s_Vp_Uc()
{
  {
    init_simple_test("aBFu0s_Vp_Uc");
    static STRUCT_IF_C aBFu0s_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu0s_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_Uc, aBFu0s_Vp_Uc)
//============================================================================



static void Test_aBFu0s_Vp_Ui()
{
  {
    init_simple_test("aBFu0s_Vp_Ui");
    static STRUCT_IF_C aBFu0s_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu0s_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_Ui, aBFu0s_Vp_Ui)
//============================================================================



static void Test_aBFu0s_Vp_Ul()
{
  {
    init_simple_test("aBFu0s_Vp_Ul");
    static STRUCT_IF_C aBFu0s_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu0s_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_Ul, aBFu0s_Vp_Ul)
//============================================================================



static void Test_aBFu0s_Vp_Us()
{
  {
    init_simple_test("aBFu0s_Vp_Us");
    static STRUCT_IF_C aBFu0s_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu0s_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_Us, aBFu0s_Vp_Us)
//============================================================================



static void Test_aBFu0s_Vp_Vp()
{
  {
    init_simple_test("aBFu0s_Vp_Vp");
    static STRUCT_IF_C aBFu0s_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aBFu0s_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_Vp, aBFu0s_Vp_Vp)
//============================================================================



static void Test_aBFu15i_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c, aBFu15i_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu0c, aBFu15i_BFu0c_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu0c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu0i, aBFu15i_BFu0c_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu0c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu0ll, aBFu15i_BFu0c_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu0c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu0s, aBFu15i_BFu0c_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu15i()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu15i");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, 1, "aBFu15i_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu15i, aBFu15i_BFu0c_BFu15i)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu15ll()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu15ll");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, 1, "aBFu15i_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu15ll, aBFu15i_BFu0c_BFu15ll)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu15s()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu15s");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, 1, "aBFu15i_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu15s, aBFu15i_BFu0c_BFu15s)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu16i()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu16i");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, 1, "aBFu15i_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15i_BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu16i, aBFu15i_BFu0c_BFu16i)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu16ll()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu16ll");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, 1, "aBFu15i_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15i_BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu16ll, aBFu15i_BFu0c_BFu16ll)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu16s()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu16s");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, 1, "aBFu15i_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15i_BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu16s, aBFu15i_BFu0c_BFu16s)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu17i()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu17i");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, 1, "aBFu15i_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15i_BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu17i, aBFu15i_BFu0c_BFu17i)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu17ll()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu17ll");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, 1, "aBFu15i_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15i_BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu17ll, aBFu15i_BFu0c_BFu17ll)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu1c()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu1c");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15i_BFu0c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu1c, aBFu15i_BFu0c_BFu1c)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu1i()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu1i");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15i_BFu0c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu1i, aBFu15i_BFu0c_BFu1i)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu1ll()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu1ll");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15i_BFu0c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu1ll, aBFu15i_BFu0c_BFu1ll)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu1s()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu1s");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15i_BFu0c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu1s, aBFu15i_BFu0c_BFu1s)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu31i()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu31i");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, 1, "aBFu15i_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15i_BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu31i, aBFu15i_BFu0c_BFu31i)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu31ll()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu31ll");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, 1, "aBFu15i_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15i_BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu31ll, aBFu15i_BFu0c_BFu31ll)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu32i()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu32i");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, 1, "aBFu15i_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15i_BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu32i, aBFu15i_BFu0c_BFu32i)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu32ll()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu32ll");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, 1, "aBFu15i_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15i_BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu32ll, aBFu15i_BFu0c_BFu32ll)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu33()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu33");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aBFu15i_BFu0c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 33, 1, "aBFu15i_BFu0c_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 33, hide_ull(1LL<<32), "aBFu15i_BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu33, aBFu15i_BFu0c_BFu33)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu7c()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu7c");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu7c, aBFu15i_BFu0c_BFu7c)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu7i()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu7i");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu7i, aBFu15i_BFu0c_BFu7i)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu7ll()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu7ll");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu7ll, aBFu15i_BFu0c_BFu7ll)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu7s()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu7s");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu7s, aBFu15i_BFu0c_BFu7s)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu8c()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu8c");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu8c, aBFu15i_BFu0c_BFu8c)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu8i()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu8i");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu8i, aBFu15i_BFu0c_BFu8i)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu8ll()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu8ll");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu8ll, aBFu15i_BFu0c_BFu8ll)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu8s()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu8s");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu8s, aBFu15i_BFu0c_BFu8s)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu9i()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu9i");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu0c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, 1, "aBFu15i_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15i_BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu9i, aBFu15i_BFu0c_BFu9i)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu9ll()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu9ll");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu0c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, 1, "aBFu15i_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15i_BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu9ll, aBFu15i_BFu0c_BFu9ll)
//============================================================================



static void Test_aBFu15i_BFu0c_BFu9s()
{
  {
    init_simple_test("aBFu15i_BFu0c_BFu9s");
    static STRUCT_IF_C aBFu15i_BFu0c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu0c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, 1, "aBFu15i_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15i_BFu0c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_BFu9s, aBFu15i_BFu0c_BFu9s)
//============================================================================



static void Test_aBFu15i_BFu0c_C()
{
  {
    init_simple_test("aBFu15i_BFu0c_C");
    static STRUCT_IF_C aBFu15i_BFu0c_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_C");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_C, aBFu15i_BFu0c_C)
//============================================================================



static void Test_aBFu15i_BFu0c_D()
{
  {
    init_simple_test("aBFu15i_BFu0c_D");
    static STRUCT_IF_C aBFu15i_BFu0c_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_BFu0c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_D");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_D, aBFu15i_BFu0c_D)
//============================================================================



static void Test_aBFu15i_BFu0c_F()
{
  {
    init_simple_test("aBFu15i_BFu0c_F");
    static STRUCT_IF_C aBFu15i_BFu0c_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_F");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_F, aBFu15i_BFu0c_F)
//============================================================================



static void Test_aBFu15i_BFu0c_I()
{
  {
    init_simple_test("aBFu15i_BFu0c_I");
    static STRUCT_IF_C aBFu15i_BFu0c_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_I");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_I, aBFu15i_BFu0c_I)
//============================================================================



static void Test_aBFu15i_BFu0c_Ip()
{
  {
    init_simple_test("aBFu15i_BFu0c_Ip");
    static STRUCT_IF_C aBFu15i_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_Ip");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_Ip, aBFu15i_BFu0c_Ip)
//============================================================================



static void Test_aBFu15i_BFu0c_L()
{
  {
    init_simple_test("aBFu15i_BFu0c_L");
    static STRUCT_IF_C aBFu15i_BFu0c_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_BFu0c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_L");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_L, aBFu15i_BFu0c_L)
//============================================================================



static void Test_aBFu15i_BFu0c_S()
{
  {
    init_simple_test("aBFu15i_BFu0c_S");
    static STRUCT_IF_C aBFu15i_BFu0c_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_S");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_S, aBFu15i_BFu0c_S)
//============================================================================



static void Test_aBFu15i_BFu0c_Uc()
{
  {
    init_simple_test("aBFu15i_BFu0c_Uc");
    static STRUCT_IF_C aBFu15i_BFu0c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_Uc");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_Uc, aBFu15i_BFu0c_Uc)
//============================================================================



static void Test_aBFu15i_BFu0c_Ui()
{
  {
    init_simple_test("aBFu15i_BFu0c_Ui");
    static STRUCT_IF_C aBFu15i_BFu0c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_Ui");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_Ui, aBFu15i_BFu0c_Ui)
//============================================================================



static void Test_aBFu15i_BFu0c_Ul()
{
  {
    init_simple_test("aBFu15i_BFu0c_Ul");
    static STRUCT_IF_C aBFu15i_BFu0c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_BFu0c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_Ul");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_Ul, aBFu15i_BFu0c_Ul)
//============================================================================



static void Test_aBFu15i_BFu0c_Us()
{
  {
    init_simple_test("aBFu15i_BFu0c_Us");
    static STRUCT_IF_C aBFu15i_BFu0c_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_Us");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_Us, aBFu15i_BFu0c_Us)
//============================================================================



static void Test_aBFu15i_BFu0c_Vp()
{
  {
    init_simple_test("aBFu15i_BFu0c_Vp");
    static STRUCT_IF_C aBFu15i_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_Vp");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_Vp, aBFu15i_BFu0c_Vp)
//============================================================================



static void Test_aBFu15i_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i, aBFu15i_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu0i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu0c, aBFu15i_BFu0i_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu0i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu0i, aBFu15i_BFu0i_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu0i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu0ll, aBFu15i_BFu0i_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu0i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu0s, aBFu15i_BFu0i_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu15i()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu15i");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15i_BFu0i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 15, 1, "aBFu15i_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu15i, aBFu15i_BFu0i_BFu15i)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu15ll()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu15ll");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15i_BFu0i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 15, 1, "aBFu15i_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu15ll, aBFu15i_BFu0i_BFu15ll)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu15s()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu15s");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15i_BFu0i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 15, 1, "aBFu15i_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu15s, aBFu15i_BFu0i_BFu15s)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu16i()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu16i");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15i_BFu0i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 16, 1, "aBFu15i_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15i_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu16i, aBFu15i_BFu0i_BFu16i)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu16ll()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu16ll");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15i_BFu0i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 16, 1, "aBFu15i_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15i_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu16ll, aBFu15i_BFu0i_BFu16ll)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu16s()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu16s");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15i_BFu0i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 16, 1, "aBFu15i_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15i_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu16s, aBFu15i_BFu0i_BFu16s)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu17i()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu17i");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aBFu15i_BFu0i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 17, 1, "aBFu15i_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15i_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu17i, aBFu15i_BFu0i_BFu17i)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu17ll()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu17ll");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aBFu15i_BFu0i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 17, 1, "aBFu15i_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15i_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu17ll, aBFu15i_BFu0i_BFu17ll)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu1c()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu1c");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu1c, aBFu15i_BFu0i_BFu1c)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu1i()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu1i");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu1i, aBFu15i_BFu0i_BFu1i)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu1ll()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu1ll");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu1ll, aBFu15i_BFu0i_BFu1ll)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu1s()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu1s");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu1s, aBFu15i_BFu0i_BFu1s)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu31i()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu31i");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu0i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 31, 1, "aBFu15i_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15i_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu31i, aBFu15i_BFu0i_BFu31i)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu31ll()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu31ll");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu0i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 31, 1, "aBFu15i_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15i_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu31ll, aBFu15i_BFu0i_BFu31ll)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu32i()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu32i");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu0i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 32, 1, "aBFu15i_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15i_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu32i, aBFu15i_BFu0i_BFu32i)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu32ll()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu32ll");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu0i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 32, 1, "aBFu15i_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15i_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu32ll, aBFu15i_BFu0i_BFu32ll)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu33()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu33");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(9,9), "sizeof(aBFu15i_BFu0i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 33, 1, "aBFu15i_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 33, hide_ull(1LL<<32), "aBFu15i_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu33, aBFu15i_BFu0i_BFu33)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu7c()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu7c");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu7c, aBFu15i_BFu0i_BFu7c)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu7i()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu7i");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu7i, aBFu15i_BFu0i_BFu7i)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu7ll()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu7ll");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu7ll, aBFu15i_BFu0i_BFu7ll)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu7s()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu7s");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu7s, aBFu15i_BFu0i_BFu7s)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu8c()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu8c");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu8c, aBFu15i_BFu0i_BFu8c)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu8i()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu8i");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu8i, aBFu15i_BFu0i_BFu8i)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu8ll()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu8ll");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu8ll, aBFu15i_BFu0i_BFu8ll)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu8s()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu8s");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu8s, aBFu15i_BFu0i_BFu8s)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu9i()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu9i");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15i_BFu0i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 9, 1, "aBFu15i_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15i_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu9i, aBFu15i_BFu0i_BFu9i)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu9ll()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu9ll");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15i_BFu0i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 9, 1, "aBFu15i_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15i_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu9ll, aBFu15i_BFu0i_BFu9ll)
//============================================================================



static void Test_aBFu15i_BFu0i_BFu9s()
{
  {
    init_simple_test("aBFu15i_BFu0i_BFu9s");
    static STRUCT_IF_C aBFu15i_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15i_BFu0i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 9, 1, "aBFu15i_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15i_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_BFu9s, aBFu15i_BFu0i_BFu9s)
//============================================================================



static void Test_aBFu15i_BFu0i_C()
{
  {
    init_simple_test("aBFu15i_BFu0i_C");
    static STRUCT_IF_C aBFu15i_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_C");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_C, aBFu15i_BFu0i_C)
//============================================================================



static void Test_aBFu15i_BFu0i_D()
{
  {
    init_simple_test("aBFu15i_BFu0i_D");
    static STRUCT_IF_C aBFu15i_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aBFu15i_BFu0i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_D");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_D, aBFu15i_BFu0i_D)
//============================================================================



static void Test_aBFu15i_BFu0i_F()
{
  {
    init_simple_test("aBFu15i_BFu0i_F");
    static STRUCT_IF_C aBFu15i_BFu0i_F lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu0i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_F");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_F, aBFu15i_BFu0i_F)
//============================================================================



static void Test_aBFu15i_BFu0i_I()
{
  {
    init_simple_test("aBFu15i_BFu0i_I");
    static STRUCT_IF_C aBFu15i_BFu0i_I lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu0i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_I");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_I, aBFu15i_BFu0i_I)
//============================================================================



static void Test_aBFu15i_BFu0i_Ip()
{
  {
    init_simple_test("aBFu15i_BFu0i_Ip");
    static STRUCT_IF_C aBFu15i_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15i_BFu0i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_Ip");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_Ip, aBFu15i_BFu0i_Ip)
//============================================================================



static void Test_aBFu15i_BFu0i_L()
{
  {
    init_simple_test("aBFu15i_BFu0i_L");
    static STRUCT_IF_C aBFu15i_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aBFu15i_BFu0i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_L");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_L, aBFu15i_BFu0i_L)
//============================================================================



static void Test_aBFu15i_BFu0i_S()
{
  {
    init_simple_test("aBFu15i_BFu0i_S");
    static STRUCT_IF_C aBFu15i_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15i_BFu0i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_S");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_S, aBFu15i_BFu0i_S)
//============================================================================



static void Test_aBFu15i_BFu0i_Uc()
{
  {
    init_simple_test("aBFu15i_BFu0i_Uc");
    static STRUCT_IF_C aBFu15i_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_Uc");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_Uc, aBFu15i_BFu0i_Uc)
//============================================================================



static void Test_aBFu15i_BFu0i_Ui()
{
  {
    init_simple_test("aBFu15i_BFu0i_Ui");
    static STRUCT_IF_C aBFu15i_BFu0i_Ui lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu0i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_Ui");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_Ui, aBFu15i_BFu0i_Ui)
//============================================================================



static void Test_aBFu15i_BFu0i_Ul()
{
  {
    init_simple_test("aBFu15i_BFu0i_Ul");
    static STRUCT_IF_C aBFu15i_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aBFu15i_BFu0i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_Ul");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_Ul, aBFu15i_BFu0i_Ul)
//============================================================================



static void Test_aBFu15i_BFu0i_Us()
{
  {
    init_simple_test("aBFu15i_BFu0i_Us");
    static STRUCT_IF_C aBFu15i_BFu0i_Us lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15i_BFu0i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_Us");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_Us, aBFu15i_BFu0i_Us)
//============================================================================



static void Test_aBFu15i_BFu0i_Vp()
{
  {
    init_simple_test("aBFu15i_BFu0i_Vp");
    static STRUCT_IF_C aBFu15i_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15i_BFu0i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_Vp");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_Vp, aBFu15i_BFu0i_Vp)
//============================================================================



static void Test_aBFu15i_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll, aBFu15i_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu0ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu0c, aBFu15i_BFu0ll_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu0ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu0i, aBFu15i_BFu0ll_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu0ll, aBFu15i_BFu0ll_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu0ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu0s, aBFu15i_BFu0ll_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu15i()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu15i");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 15, 1, "aBFu15i_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu15i, aBFu15i_BFu0ll_BFu15i)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu15ll()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu15ll");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 15, 1, "aBFu15i_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu15ll, aBFu15i_BFu0ll_BFu15ll)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu15s()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu15s");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 15, 1, "aBFu15i_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu15s, aBFu15i_BFu0ll_BFu15s)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu16i()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu16i");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 16, 1, "aBFu15i_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15i_BFu0ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu16i, aBFu15i_BFu0ll_BFu16i)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu16ll()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu16ll");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 16, 1, "aBFu15i_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15i_BFu0ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu16ll, aBFu15i_BFu0ll_BFu16ll)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu16s()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu16s");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 16, 1, "aBFu15i_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15i_BFu0ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu16s, aBFu15i_BFu0ll_BFu16s)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu17i()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu17i");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu15i_BFu0ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 17, 1, "aBFu15i_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15i_BFu0ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu17i, aBFu15i_BFu0ll_BFu17i)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu17ll()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu17ll");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu15i_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 17, 1, "aBFu15i_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15i_BFu0ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu17ll, aBFu15i_BFu0ll_BFu17ll)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu1c()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu1c");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu1c, aBFu15i_BFu0ll_BFu1c)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu1i()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu1i");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu1i, aBFu15i_BFu0ll_BFu1i)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu1ll()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu1ll");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu1ll, aBFu15i_BFu0ll_BFu1ll)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu1s()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu1s");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu1s, aBFu15i_BFu0ll_BFu1s)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu31i()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu31i");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15i_BFu0ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 31, 1, "aBFu15i_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15i_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu31i, aBFu15i_BFu0ll_BFu31i)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu31ll()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu31ll");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15i_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 31, 1, "aBFu15i_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15i_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu31ll, aBFu15i_BFu0ll_BFu31ll)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu32i()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu32i");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15i_BFu0ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 32, 1, "aBFu15i_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15i_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu32i, aBFu15i_BFu0ll_BFu32i)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu32ll()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu32ll");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15i_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 32, 1, "aBFu15i_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15i_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu32ll, aBFu15i_BFu0ll_BFu32ll)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu33()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu33");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu15i_BFu0ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 33, 1, "aBFu15i_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 33, hide_ull(1LL<<32), "aBFu15i_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu33, aBFu15i_BFu0ll_BFu33)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu7c()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu7c");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu7c, aBFu15i_BFu0ll_BFu7c)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu7i()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu7i");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu7i, aBFu15i_BFu0ll_BFu7i)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu7ll()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu7ll");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu7ll, aBFu15i_BFu0ll_BFu7ll)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu7s()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu7s");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu7s, aBFu15i_BFu0ll_BFu7s)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu8c()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu8c");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu8c, aBFu15i_BFu0ll_BFu8c)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu8i()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu8i");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu8i, aBFu15i_BFu0ll_BFu8i)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu8ll()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu8ll");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu8ll, aBFu15i_BFu0ll_BFu8ll)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu8s()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu8s");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu8s, aBFu15i_BFu0ll_BFu8s)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu9i()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu9i");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 9, 1, "aBFu15i_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15i_BFu0ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu9i, aBFu15i_BFu0ll_BFu9i)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu9ll()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu9ll");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 9, 1, "aBFu15i_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15i_BFu0ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu9ll, aBFu15i_BFu0ll_BFu9ll)
//============================================================================



static void Test_aBFu15i_BFu0ll_BFu9s()
{
  {
    init_simple_test("aBFu15i_BFu0ll_BFu9s");
    static STRUCT_IF_C aBFu15i_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 9, 1, "aBFu15i_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15i_BFu0ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_BFu9s, aBFu15i_BFu0ll_BFu9s)
//============================================================================



static void Test_aBFu15i_BFu0ll_C()
{
  {
    init_simple_test("aBFu15i_BFu0ll_C");
    static STRUCT_IF_C aBFu15i_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_C, aBFu15i_BFu0ll_C)
//============================================================================



static void Test_aBFu15i_BFu0ll_D()
{
  {
    init_simple_test("aBFu15i_BFu0ll_D");
    static STRUCT_IF_C aBFu15i_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu15i_BFu0ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_D, aBFu15i_BFu0ll_D)
//============================================================================



static void Test_aBFu15i_BFu0ll_F()
{
  {
    init_simple_test("aBFu15i_BFu0ll_F");
    static STRUCT_IF_C aBFu15i_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15i_BFu0ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_F, aBFu15i_BFu0ll_F)
//============================================================================



static void Test_aBFu15i_BFu0ll_I()
{
  {
    init_simple_test("aBFu15i_BFu0ll_I");
    static STRUCT_IF_C aBFu15i_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15i_BFu0ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_I, aBFu15i_BFu0ll_I)
//============================================================================



static void Test_aBFu15i_BFu0ll_Ip()
{
  {
    init_simple_test("aBFu15i_BFu0ll_Ip");
    static STRUCT_IF_C aBFu15i_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aBFu15i_BFu0ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_Ip, aBFu15i_BFu0ll_Ip)
//============================================================================



static void Test_aBFu15i_BFu0ll_L()
{
  {
    init_simple_test("aBFu15i_BFu0ll_L");
    static STRUCT_IF_C aBFu15i_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu15i_BFu0ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_L, aBFu15i_BFu0ll_L)
//============================================================================



static void Test_aBFu15i_BFu0ll_S()
{
  {
    init_simple_test("aBFu15i_BFu0ll_S");
    static STRUCT_IF_C aBFu15i_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_S, aBFu15i_BFu0ll_S)
//============================================================================



static void Test_aBFu15i_BFu0ll_Uc()
{
  {
    init_simple_test("aBFu15i_BFu0ll_Uc");
    static STRUCT_IF_C aBFu15i_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15i_BFu0ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_Uc, aBFu15i_BFu0ll_Uc)
//============================================================================



static void Test_aBFu15i_BFu0ll_Ui()
{
  {
    init_simple_test("aBFu15i_BFu0ll_Ui");
    static STRUCT_IF_C aBFu15i_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15i_BFu0ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_Ui, aBFu15i_BFu0ll_Ui)
//============================================================================



static void Test_aBFu15i_BFu0ll_Ul()
{
  {
    init_simple_test("aBFu15i_BFu0ll_Ul");
    static STRUCT_IF_C aBFu15i_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu15i_BFu0ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_Ul, aBFu15i_BFu0ll_Ul)
//============================================================================



static void Test_aBFu15i_BFu0ll_Us()
{
  {
    init_simple_test("aBFu15i_BFu0ll_Us");
    static STRUCT_IF_C aBFu15i_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_Us, aBFu15i_BFu0ll_Us)
//============================================================================



static void Test_aBFu15i_BFu0ll_Vp()
{
  {
    init_simple_test("aBFu15i_BFu0ll_Vp");
    static STRUCT_IF_C aBFu15i_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aBFu15i_BFu0ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_Vp, aBFu15i_BFu0ll_Vp)
//============================================================================



static void Test_aBFu15i_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s, aBFu15i_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu0s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu0c, aBFu15i_BFu0s_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu0s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu0i, aBFu15i_BFu0s_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu0s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu0ll, aBFu15i_BFu0s_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu0s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu0s, aBFu15i_BFu0s_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu15i()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu15i");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, 1, "aBFu15i_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu15i, aBFu15i_BFu0s_BFu15i)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu15ll()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu15ll");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, 1, "aBFu15i_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu15ll, aBFu15i_BFu0s_BFu15ll)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu15s()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu15s");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, 1, "aBFu15i_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu15s, aBFu15i_BFu0s_BFu15s)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu16i()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu16i");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, 1, "aBFu15i_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15i_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu16i, aBFu15i_BFu0s_BFu16i)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu16ll()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu16ll");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, 1, "aBFu15i_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15i_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu16ll, aBFu15i_BFu0s_BFu16ll)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu16s()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu16s");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, 1, "aBFu15i_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15i_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu16s, aBFu15i_BFu0s_BFu16s)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu17i()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu17i");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, 1, "aBFu15i_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15i_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu17i, aBFu15i_BFu0s_BFu17i)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu17ll()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu17ll");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15i_BFu0s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, 1, "aBFu15i_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15i_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu17ll, aBFu15i_BFu0s_BFu17ll)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu1c()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu1c");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15i_BFu0s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu1c, aBFu15i_BFu0s_BFu1c)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu1i()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu1i");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15i_BFu0s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu1i, aBFu15i_BFu0s_BFu1i)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu1ll()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu1ll");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15i_BFu0s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu1ll, aBFu15i_BFu0s_BFu1ll)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu1s()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu1s");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15i_BFu0s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15i_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu1s, aBFu15i_BFu0s_BFu1s)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu31i()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu31i");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, 1, "aBFu15i_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15i_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu31i, aBFu15i_BFu0s_BFu31i)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu31ll()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu31ll");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, 1, "aBFu15i_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15i_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu31ll, aBFu15i_BFu0s_BFu31ll)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu32i()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu32i");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, 1, "aBFu15i_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15i_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu32i, aBFu15i_BFu0s_BFu32i)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu32ll()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu32ll");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, 1, "aBFu15i_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15i_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu32ll, aBFu15i_BFu0s_BFu32ll)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu33()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu33");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aBFu15i_BFu0s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 33, 1, "aBFu15i_BFu0s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 33, hide_ull(1LL<<32), "aBFu15i_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu33, aBFu15i_BFu0s_BFu33)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu7c()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu7c");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu7c, aBFu15i_BFu0s_BFu7c)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu7i()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu7i");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu7i, aBFu15i_BFu0s_BFu7i)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu7ll()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu7ll");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu7ll, aBFu15i_BFu0s_BFu7ll)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu7s()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu7s");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15i_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15i_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu7s, aBFu15i_BFu0s_BFu7s)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu8c()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu8c");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu8c, aBFu15i_BFu0s_BFu8c)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu8i()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu8i");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu8i, aBFu15i_BFu0s_BFu8i)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu8ll()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu8ll");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu8ll, aBFu15i_BFu0s_BFu8ll)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu8s()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu8s");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15i_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15i_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu8s, aBFu15i_BFu0s_BFu8s)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu9i()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu9i");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu0s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, 1, "aBFu15i_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15i_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu9i, aBFu15i_BFu0s_BFu9i)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu9ll()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu9ll");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu0s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, 1, "aBFu15i_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15i_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu9ll, aBFu15i_BFu0s_BFu9ll)
//============================================================================



static void Test_aBFu15i_BFu0s_BFu9s()
{
  {
    init_simple_test("aBFu15i_BFu0s_BFu9s");
    static STRUCT_IF_C aBFu15i_BFu0s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu0s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, 1, "aBFu15i_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15i_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_BFu9s, aBFu15i_BFu0s_BFu9s)
//============================================================================



static void Test_aBFu15i_BFu0s_C()
{
  {
    init_simple_test("aBFu15i_BFu0s_C");
    static STRUCT_IF_C aBFu15i_BFu0s_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_C");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_C, aBFu15i_BFu0s_C)
//============================================================================



static void Test_aBFu15i_BFu0s_D()
{
  {
    init_simple_test("aBFu15i_BFu0s_D");
    static STRUCT_IF_C aBFu15i_BFu0s_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_BFu0s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_D");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_D, aBFu15i_BFu0s_D)
//============================================================================



static void Test_aBFu15i_BFu0s_F()
{
  {
    init_simple_test("aBFu15i_BFu0s_F");
    static STRUCT_IF_C aBFu15i_BFu0s_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_F");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_F, aBFu15i_BFu0s_F)
//============================================================================



static void Test_aBFu15i_BFu0s_I()
{
  {
    init_simple_test("aBFu15i_BFu0s_I");
    static STRUCT_IF_C aBFu15i_BFu0s_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_I");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_I, aBFu15i_BFu0s_I)
//============================================================================



static void Test_aBFu15i_BFu0s_Ip()
{
  {
    init_simple_test("aBFu15i_BFu0s_Ip");
    static STRUCT_IF_C aBFu15i_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_Ip");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_Ip, aBFu15i_BFu0s_Ip)
//============================================================================



static void Test_aBFu15i_BFu0s_L()
{
  {
    init_simple_test("aBFu15i_BFu0s_L");
    static STRUCT_IF_C aBFu15i_BFu0s_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_BFu0s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_L");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_L, aBFu15i_BFu0s_L)
//============================================================================



static void Test_aBFu15i_BFu0s_S()
{
  {
    init_simple_test("aBFu15i_BFu0s_S");
    static STRUCT_IF_C aBFu15i_BFu0s_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_S");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_S, aBFu15i_BFu0s_S)
//============================================================================



static void Test_aBFu15i_BFu0s_Uc()
{
  {
    init_simple_test("aBFu15i_BFu0s_Uc");
    static STRUCT_IF_C aBFu15i_BFu0s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu0s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_Uc");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_Uc, aBFu15i_BFu0s_Uc)
//============================================================================



static void Test_aBFu15i_BFu0s_Ui()
{
  {
    init_simple_test("aBFu15i_BFu0s_Ui");
    static STRUCT_IF_C aBFu15i_BFu0s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu0s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_Ui");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_Ui, aBFu15i_BFu0s_Ui)
//============================================================================



static void Test_aBFu15i_BFu0s_Ul()
{
  {
    init_simple_test("aBFu15i_BFu0s_Ul");
    static STRUCT_IF_C aBFu15i_BFu0s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_BFu0s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_Ul");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_Ul, aBFu15i_BFu0s_Ul)
//============================================================================



static void Test_aBFu15i_BFu0s_Us()
{
  {
    init_simple_test("aBFu15i_BFu0s_Us");
    static STRUCT_IF_C aBFu15i_BFu0s_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu0s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_Us");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_Us, aBFu15i_BFu0s_Us)
//============================================================================



static void Test_aBFu15i_BFu0s_Vp()
{
  {
    init_simple_test("aBFu15i_BFu0s_Vp");
    static STRUCT_IF_C aBFu15i_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_BFu0s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_Vp");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_Vp, aBFu15i_BFu0s_Vp)
//============================================================================



static void Test_aBFu15i_BFu15i_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu15i_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu15i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu15i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15i_BFu0c, aBFu15i_BFu15i_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu15i_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu15i_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu15i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu15i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15i_BFu0i, aBFu15i_BFu15i_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu15i_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu15i_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu15i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15i_BFu0ll, aBFu15i_BFu15i_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu15i_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu15i_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu15i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu15i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15i_BFu0s, aBFu15i_BFu15i_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu15ll_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu15ll_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu15ll_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu15ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15ll_BFu0c, aBFu15i_BFu15ll_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu15ll_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu15ll_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu15ll_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu15ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15ll_BFu0i, aBFu15i_BFu15ll_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu15ll_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu15ll_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15ll_BFu0ll, aBFu15i_BFu15ll_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu15ll_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu15ll_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu15ll_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu15ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15ll_BFu0s, aBFu15i_BFu15ll_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu15s_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu15s_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu15s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu15s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15s_BFu0c, aBFu15i_BFu15s_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu15s_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu15s_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu15s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu15s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15s_BFu0i, aBFu15i_BFu15s_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu15s_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu15s_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu15s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15s_BFu0ll, aBFu15i_BFu15s_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu15s_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu15s_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu15s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu15s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15s_BFu0s, aBFu15i_BFu15s_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu16i_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu16i_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu16i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu16i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16i_BFu0c, aBFu15i_BFu16i_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu16i_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu16i_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu16i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu16i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16i_BFu0i, aBFu15i_BFu16i_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu16i_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu16i_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu16i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16i_BFu0ll, aBFu15i_BFu16i_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu16i_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu16i_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu16i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu16i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16i_BFu0s, aBFu15i_BFu16i_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu16ll_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu16ll_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu16ll_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu16ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16ll_BFu0c, aBFu15i_BFu16ll_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu16ll_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu16ll_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu16ll_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu16ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16ll_BFu0i, aBFu15i_BFu16ll_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu16ll_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu16ll_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16ll_BFu0ll, aBFu15i_BFu16ll_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu16ll_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu16ll_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu16ll_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu16ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16ll_BFu0s, aBFu15i_BFu16ll_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu16s_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu16s_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu16s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu16s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16s_BFu0c, aBFu15i_BFu16s_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu16s_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu16s_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu16s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu16s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16s_BFu0i, aBFu15i_BFu16s_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu16s_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu16s_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu16s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16s_BFu0ll, aBFu15i_BFu16s_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu16s_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu16s_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu16s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu16s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16s_BFu0s, aBFu15i_BFu16s_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu17i_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu17i_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu17i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu17i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu17i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu17i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15i_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15i_BFu17i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu17i_BFu0c, aBFu15i_BFu17i_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu17i_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu17i_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu17i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu17i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu17i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu17i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15i_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15i_BFu17i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu17i_BFu0i, aBFu15i_BFu17i_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu17i_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu17i_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu17i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu17i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu17i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15i_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15i_BFu17i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu17i_BFu0ll, aBFu15i_BFu17i_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu17i_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu17i_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu17i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu17i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu17i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu17i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15i_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15i_BFu17i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu17i_BFu0s, aBFu15i_BFu17i_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu17ll_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu17ll_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu17ll_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu17ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu17ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu17ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15i_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15i_BFu17ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu17ll_BFu0c, aBFu15i_BFu17ll_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu17ll_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu17ll_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu17ll_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu17ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu17ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu17ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15i_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15i_BFu17ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu17ll_BFu0i, aBFu15i_BFu17ll_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu17ll_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu17ll_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu17ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15i_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15i_BFu17ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu17ll_BFu0ll, aBFu15i_BFu17ll_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu17ll_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu17ll_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu17ll_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu17ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu17ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu17ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15i_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15i_BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu17ll_BFu0s, aBFu15i_BFu17ll_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu1c_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu1c_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu1c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu1c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1c_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1c_BFu0c, aBFu15i_BFu1c_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu1c_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu1c_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu1c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu1c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1c_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1c_BFu0i, aBFu15i_BFu1c_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu1c_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu1c_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu1c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1c_BFu0ll, aBFu15i_BFu1c_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu1c_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu1c_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu1c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu1c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1c_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1c_BFu0s, aBFu15i_BFu1c_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu1i_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu1i_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu1i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu1i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1i_BFu0c, aBFu15i_BFu1i_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu1i_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu1i_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu1i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu1i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1i_BFu0i, aBFu15i_BFu1i_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu1i_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu1i_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu1i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1i_BFu0ll, aBFu15i_BFu1i_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu1i_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu1i_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu1i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu1i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1i_BFu0s, aBFu15i_BFu1i_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu1ll_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu1ll_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu1ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu1ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1ll_BFu0c, aBFu15i_BFu1ll_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu1ll_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu1ll_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu1ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1ll_BFu0i, aBFu15i_BFu1ll_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu1ll_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu1ll_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1ll_BFu0ll, aBFu15i_BFu1ll_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu1ll_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu1ll_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu1ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu1ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1ll_BFu0s, aBFu15i_BFu1ll_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu1s_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu1s_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu1s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu1s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1s_BFu0c, aBFu15i_BFu1s_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu1s_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu1s_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu1s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu1s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1s_BFu0i, aBFu15i_BFu1s_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu1s_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu1s_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu1s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1s_BFu0ll, aBFu15i_BFu1s_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu1s_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu1s_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu1s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu1s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1s_BFu0s, aBFu15i_BFu1s_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu31i_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu31i_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu31i_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu31i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu31i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu31i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15i_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15i_BFu31i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu31i_BFu0c, aBFu15i_BFu31i_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu31i_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu31i_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu31i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu31i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu31i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu31i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15i_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15i_BFu31i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu31i_BFu0i, aBFu15i_BFu31i_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu31i_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu31i_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu31i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu31i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu31i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu31i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15i_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15i_BFu31i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu31i_BFu0ll, aBFu15i_BFu31i_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu31i_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu31i_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu31i_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu31i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu31i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu31i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15i_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15i_BFu31i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu31i_BFu0s, aBFu15i_BFu31i_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu31ll_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu31ll_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu31ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu31ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu31ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15i_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15i_BFu31ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu31ll_BFu0c, aBFu15i_BFu31ll_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu31ll_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu31ll_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu31ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu31ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu31ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu31ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15i_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15i_BFu31ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu31ll_BFu0i, aBFu15i_BFu31ll_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu31ll_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu31ll_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu31ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15i_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15i_BFu31ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu31ll_BFu0ll, aBFu15i_BFu31ll_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu31ll_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu31ll_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu31ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu31ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu31ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15i_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15i_BFu31ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu31ll_BFu0s, aBFu15i_BFu31ll_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu32i_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu32i_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu32i_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu32i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu32i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu32i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15i_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15i_BFu32i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu32i_BFu0c, aBFu15i_BFu32i_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu32i_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu32i_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu32i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu32i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu32i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu32i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15i_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15i_BFu32i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu32i_BFu0i, aBFu15i_BFu32i_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu32i_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu32i_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu32i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu32i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu32i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu32i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15i_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15i_BFu32i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu32i_BFu0ll, aBFu15i_BFu32i_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu32i_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu32i_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu32i_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu32i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu32i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu32i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15i_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15i_BFu32i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu32i_BFu0s, aBFu15i_BFu32i_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu32ll_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu32ll_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu32ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu32ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu32ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15i_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15i_BFu32ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu32ll_BFu0c, aBFu15i_BFu32ll_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu32ll_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu32ll_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu32ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu32ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu32ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu32ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15i_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15i_BFu32ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu32ll_BFu0i, aBFu15i_BFu32ll_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu32ll_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu32ll_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu32ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15i_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15i_BFu32ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu32ll_BFu0ll, aBFu15i_BFu32ll_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu32ll_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu32ll_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu32ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu32ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu32ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15i_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15i_BFu32ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu32ll_BFu0s, aBFu15i_BFu32ll_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu33_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu33_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu33_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu33_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu33_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu33_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "aBFu15i_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "aBFu15i_BFu33_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu33_BFu0c, aBFu15i_BFu33_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu33_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu33_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu33_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu33_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu33_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "aBFu15i_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "aBFu15i_BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu33_BFu0i, aBFu15i_BFu33_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu33_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu33_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu33_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_BFu33_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu33_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "aBFu15i_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "aBFu15i_BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu33_BFu0ll, aBFu15i_BFu33_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu33_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu33_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu33_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu33_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu33_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "aBFu15i_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "aBFu15i_BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu33_BFu0s, aBFu15i_BFu33_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu7c_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu7c_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu7c_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu7c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7c_BFu0c, aBFu15i_BFu7c_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu7c_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu7c_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu7c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu7c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7c_BFu0i, aBFu15i_BFu7c_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu7c_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu7c_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu7c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7c_BFu0ll, aBFu15i_BFu7c_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu7c_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu7c_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu7c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu7c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7c_BFu0s, aBFu15i_BFu7c_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu7i_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu7i_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu7i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu7i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7i_BFu0c, aBFu15i_BFu7i_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu7i_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu7i_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu7i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu7i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7i_BFu0i, aBFu15i_BFu7i_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu7i_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu7i_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu7i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7i_BFu0ll, aBFu15i_BFu7i_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu7i_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu7i_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu7i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu7i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7i_BFu0s, aBFu15i_BFu7i_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu7ll_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu7ll_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu7ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu7ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7ll_BFu0c, aBFu15i_BFu7ll_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu7ll_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu7ll_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu7ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7ll_BFu0i, aBFu15i_BFu7ll_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu7ll_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu7ll_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7ll_BFu0ll, aBFu15i_BFu7ll_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu7ll_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu7ll_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu7ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7ll_BFu0s, aBFu15i_BFu7ll_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu7s_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu7s_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu7s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu7s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7s_BFu0c, aBFu15i_BFu7s_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu7s_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu7s_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu7s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu7s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7s_BFu0i, aBFu15i_BFu7s_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu7s_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu7s_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu7s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7s_BFu0ll, aBFu15i_BFu7s_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu7s_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu7s_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu7s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu7s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7s_BFu0s, aBFu15i_BFu7s_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu8c_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu8c_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu8c_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu8c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8c_BFu0c, aBFu15i_BFu8c_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu8c_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu8c_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu8c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu8c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8c_BFu0i, aBFu15i_BFu8c_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu8c_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu8c_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu8c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8c_BFu0ll, aBFu15i_BFu8c_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu8c_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu8c_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu8c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu8c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8c_BFu0s, aBFu15i_BFu8c_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu8i_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu8i_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu8i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu8i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8i_BFu0c, aBFu15i_BFu8i_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu8i_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu8i_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu8i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu8i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8i_BFu0i, aBFu15i_BFu8i_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu8i_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu8i_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu8i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8i_BFu0ll, aBFu15i_BFu8i_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu8i_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu8i_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu8i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu8i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8i_BFu0s, aBFu15i_BFu8i_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu8ll_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu8ll_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu8ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu8ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8ll_BFu0c, aBFu15i_BFu8ll_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu8ll_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu8ll_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu8ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8ll_BFu0i, aBFu15i_BFu8ll_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu8ll_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu8ll_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8ll_BFu0ll, aBFu15i_BFu8ll_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu8ll_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu8ll_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu8ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8ll_BFu0s, aBFu15i_BFu8ll_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu8s_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu8s_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu8s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu8s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8s_BFu0c, aBFu15i_BFu8s_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu8s_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu8s_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu8s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu8s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8s_BFu0i, aBFu15i_BFu8s_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu8s_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu8s_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu8s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8s_BFu0ll, aBFu15i_BFu8s_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu8s_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu8s_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu8s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu8s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8s_BFu0s, aBFu15i_BFu8s_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu9i_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu9i_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu9i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu9i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9i_BFu0c, aBFu15i_BFu9i_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu9i_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu9i_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu9i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu9i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9i_BFu0i, aBFu15i_BFu9i_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu9i_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu9i_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu9i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9i_BFu0ll, aBFu15i_BFu9i_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu9i_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu9i_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu9i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu9i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9i_BFu0s, aBFu15i_BFu9i_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu9ll_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu9ll_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu9ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu9ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9ll_BFu0c, aBFu15i_BFu9ll_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu9ll_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu9ll_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu9ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9ll_BFu0i, aBFu15i_BFu9ll_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu9ll_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu9ll_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9ll_BFu0ll, aBFu15i_BFu9ll_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu9ll_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu9ll_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu9ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9ll_BFu0s, aBFu15i_BFu9ll_BFu0s)
//============================================================================



static void Test_aBFu15i_BFu9s_BFu0c()
{
  {
    init_simple_test("aBFu15i_BFu9s_BFu0c");
    static STRUCT_IF_C aBFu15i_BFu9s_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu9s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9s_BFu0c, aBFu15i_BFu9s_BFu0c)
//============================================================================



static void Test_aBFu15i_BFu9s_BFu0i()
{
  {
    init_simple_test("aBFu15i_BFu9s_BFu0i");
    static STRUCT_IF_C aBFu15i_BFu9s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu9s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9s_BFu0i, aBFu15i_BFu9s_BFu0i)
//============================================================================



static void Test_aBFu15i_BFu9s_BFu0ll()
{
  {
    init_simple_test("aBFu15i_BFu9s_BFu0ll");
    static STRUCT_IF_C aBFu15i_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu9s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9s_BFu0ll, aBFu15i_BFu9s_BFu0ll)
//============================================================================



static void Test_aBFu15i_BFu9s_BFu0s()
{
  {
    init_simple_test("aBFu15i_BFu9s_BFu0s");
    static STRUCT_IF_C aBFu15i_BFu9s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu9s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9s_BFu0s, aBFu15i_BFu9s_BFu0s)
//============================================================================



static void Test_aBFu15i_C_BFu0c()
{
  {
    init_simple_test("aBFu15i_C_BFu0c");
    static STRUCT_IF_C aBFu15i_C_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_C_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_C_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_C_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_C_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_C_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_C_BFu0c, aBFu15i_C_BFu0c)
//============================================================================



static void Test_aBFu15i_C_BFu0i()
{
  {
    init_simple_test("aBFu15i_C_BFu0i");
    static STRUCT_IF_C aBFu15i_C_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_C_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_C_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_C_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_C_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_C_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_C_BFu0i, aBFu15i_C_BFu0i)
//============================================================================



static void Test_aBFu15i_C_BFu0ll()
{
  {
    init_simple_test("aBFu15i_C_BFu0ll");
    static STRUCT_IF_C aBFu15i_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_C_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_C_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_C_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_C_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_C_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_C_BFu0ll, aBFu15i_C_BFu0ll)
//============================================================================



static void Test_aBFu15i_C_BFu0s()
{
  {
    init_simple_test("aBFu15i_C_BFu0s");
    static STRUCT_IF_C aBFu15i_C_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_C_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_C_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_C_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_C_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_C_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_C_BFu0s, aBFu15i_C_BFu0s)
//============================================================================



static void Test_aBFu15i_D_BFu0c()
{
  {
    init_simple_test("aBFu15i_D_BFu0c");
    static STRUCT_IF_C aBFu15i_D_BFu0c lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_D_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_D_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_D_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_D_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_D_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_D_BFu0c, aBFu15i_D_BFu0c)
//============================================================================



static void Test_aBFu15i_D_BFu0i()
{
  {
    init_simple_test("aBFu15i_D_BFu0i");
    static STRUCT_IF_C aBFu15i_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aBFu15i_D_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_D_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_D_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_D_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_D_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_D_BFu0i, aBFu15i_D_BFu0i)
//============================================================================



static void Test_aBFu15i_D_BFu0ll()
{
  {
    init_simple_test("aBFu15i_D_BFu0ll");
    static STRUCT_IF_C aBFu15i_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu15i_D_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_D_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_D_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_D_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_D_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_D_BFu0ll, aBFu15i_D_BFu0ll)
//============================================================================



static void Test_aBFu15i_D_BFu0s()
{
  {
    init_simple_test("aBFu15i_D_BFu0s");
    static STRUCT_IF_C aBFu15i_D_BFu0s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_D_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_D_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_D_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_D_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_D_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_D_BFu0s, aBFu15i_D_BFu0s)
//============================================================================



static void Test_aBFu15i_F_BFu0c()
{
  {
    init_simple_test("aBFu15i_F_BFu0c");
    static STRUCT_IF_C aBFu15i_F_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_F_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_F_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_F_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_F_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_F_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_F_BFu0c, aBFu15i_F_BFu0c)
//============================================================================



static void Test_aBFu15i_F_BFu0i()
{
  {
    init_simple_test("aBFu15i_F_BFu0i");
    static STRUCT_IF_C aBFu15i_F_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_F_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_F_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_F_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_F_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_F_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_F_BFu0i, aBFu15i_F_BFu0i)
//============================================================================



static void Test_aBFu15i_F_BFu0ll()
{
  {
    init_simple_test("aBFu15i_F_BFu0ll");
    static STRUCT_IF_C aBFu15i_F_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_F_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_F_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_F_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_F_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_F_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_F_BFu0ll, aBFu15i_F_BFu0ll)
//============================================================================



static void Test_aBFu15i_F_BFu0s()
{
  {
    init_simple_test("aBFu15i_F_BFu0s");
    static STRUCT_IF_C aBFu15i_F_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_F_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_F_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_F_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_F_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_F_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_F_BFu0s, aBFu15i_F_BFu0s)
//============================================================================



static void Test_aBFu15i_I_BFu0c()
{
  {
    init_simple_test("aBFu15i_I_BFu0c");
    static STRUCT_IF_C aBFu15i_I_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_I_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_I_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_I_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_I_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_I_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_I_BFu0c, aBFu15i_I_BFu0c)
//============================================================================



static void Test_aBFu15i_I_BFu0i()
{
  {
    init_simple_test("aBFu15i_I_BFu0i");
    static STRUCT_IF_C aBFu15i_I_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_I_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_I_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_I_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_I_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_I_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_I_BFu0i, aBFu15i_I_BFu0i)
//============================================================================



static void Test_aBFu15i_I_BFu0ll()
{
  {
    init_simple_test("aBFu15i_I_BFu0ll");
    static STRUCT_IF_C aBFu15i_I_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_I_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_I_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_I_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_I_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_I_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_I_BFu0ll, aBFu15i_I_BFu0ll)
//============================================================================



static void Test_aBFu15i_I_BFu0s()
{
  {
    init_simple_test("aBFu15i_I_BFu0s");
    static STRUCT_IF_C aBFu15i_I_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_I_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_I_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_I_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_I_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_I_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_I_BFu0s, aBFu15i_I_BFu0s)
//============================================================================



static void Test_aBFu15i_Ip_BFu0c()
{
  {
    init_simple_test("aBFu15i_Ip_BFu0c");
    static STRUCT_IF_C aBFu15i_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_Ip_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ip_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ip_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ip_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_Ip_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ip_BFu0c, aBFu15i_Ip_BFu0c)
//============================================================================



static void Test_aBFu15i_Ip_BFu0i()
{
  {
    init_simple_test("aBFu15i_Ip_BFu0i");
    static STRUCT_IF_C aBFu15i_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15i_Ip_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ip_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ip_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ip_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_Ip_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ip_BFu0i, aBFu15i_Ip_BFu0i)
//============================================================================



static void Test_aBFu15i_Ip_BFu0ll()
{
  {
    init_simple_test("aBFu15i_Ip_BFu0ll");
    static STRUCT_IF_C aBFu15i_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aBFu15i_Ip_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ip_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ip_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ip_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Ip_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ip_BFu0ll, aBFu15i_Ip_BFu0ll)
//============================================================================



static void Test_aBFu15i_Ip_BFu0s()
{
  {
    init_simple_test("aBFu15i_Ip_BFu0s");
    static STRUCT_IF_C aBFu15i_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_Ip_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ip_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ip_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ip_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_Ip_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ip_BFu0s, aBFu15i_Ip_BFu0s)
//============================================================================



static void Test_aBFu15i_L_BFu0c()
{
  {
    init_simple_test("aBFu15i_L_BFu0c");
    static STRUCT_IF_C aBFu15i_L_BFu0c lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_L_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_L_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_L_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_L_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_L_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_L_BFu0c, aBFu15i_L_BFu0c)
//============================================================================



static void Test_aBFu15i_L_BFu0i()
{
  {
    init_simple_test("aBFu15i_L_BFu0i");
    static STRUCT_IF_C aBFu15i_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aBFu15i_L_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_L_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_L_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_L_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_L_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_L_BFu0i, aBFu15i_L_BFu0i)
//============================================================================



static void Test_aBFu15i_L_BFu0ll()
{
  {
    init_simple_test("aBFu15i_L_BFu0ll");
    static STRUCT_IF_C aBFu15i_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu15i_L_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_L_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_L_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_L_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_L_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_L_BFu0ll, aBFu15i_L_BFu0ll)
//============================================================================



static void Test_aBFu15i_L_BFu0s()
{
  {
    init_simple_test("aBFu15i_L_BFu0s");
    static STRUCT_IF_C aBFu15i_L_BFu0s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_L_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_L_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_L_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_L_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_L_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_L_BFu0s, aBFu15i_L_BFu0s)
//============================================================================



static void Test_aBFu15i_S_BFu0c()
{
  {
    init_simple_test("aBFu15i_S_BFu0c");
    static STRUCT_IF_C aBFu15i_S_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_S_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_S_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_S_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_S_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_S_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_S_BFu0c, aBFu15i_S_BFu0c)
//============================================================================



static void Test_aBFu15i_S_BFu0i()
{
  {
    init_simple_test("aBFu15i_S_BFu0i");
    static STRUCT_IF_C aBFu15i_S_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_S_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_S_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_S_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_S_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_S_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_S_BFu0i, aBFu15i_S_BFu0i)
//============================================================================



static void Test_aBFu15i_S_BFu0ll()
{
  {
    init_simple_test("aBFu15i_S_BFu0ll");
    static STRUCT_IF_C aBFu15i_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_S_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_S_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_S_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_S_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_S_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_S_BFu0ll, aBFu15i_S_BFu0ll)
//============================================================================



static void Test_aBFu15i_S_BFu0s()
{
  {
    init_simple_test("aBFu15i_S_BFu0s");
    static STRUCT_IF_C aBFu15i_S_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_S_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_S_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_S_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_S_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_S_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_S_BFu0s, aBFu15i_S_BFu0s)
//============================================================================



static void Test_aBFu15i_Uc_BFu0c()
{
  {
    init_simple_test("aBFu15i_Uc_BFu0c");
    static STRUCT_IF_C aBFu15i_Uc_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Uc_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Uc_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Uc_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Uc_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_Uc_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Uc_BFu0c, aBFu15i_Uc_BFu0c)
//============================================================================



static void Test_aBFu15i_Uc_BFu0i()
{
  {
    init_simple_test("aBFu15i_Uc_BFu0i");
    static STRUCT_IF_C aBFu15i_Uc_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_Uc_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Uc_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Uc_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Uc_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_Uc_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Uc_BFu0i, aBFu15i_Uc_BFu0i)
//============================================================================



static void Test_aBFu15i_Uc_BFu0ll()
{
  {
    init_simple_test("aBFu15i_Uc_BFu0ll");
    static STRUCT_IF_C aBFu15i_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_Uc_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Uc_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Uc_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Uc_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Uc_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Uc_BFu0ll, aBFu15i_Uc_BFu0ll)
//============================================================================



static void Test_aBFu15i_Uc_BFu0s()
{
  {
    init_simple_test("aBFu15i_Uc_BFu0s");
    static STRUCT_IF_C aBFu15i_Uc_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_Uc_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Uc_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Uc_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Uc_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_Uc_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Uc_BFu0s, aBFu15i_Uc_BFu0s)
//============================================================================



static void Test_aBFu15i_Ui_BFu0c()
{
  {
    init_simple_test("aBFu15i_Ui_BFu0c");
    static STRUCT_IF_C aBFu15i_Ui_BFu0c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_Ui_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ui_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ui_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ui_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_Ui_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ui_BFu0c, aBFu15i_Ui_BFu0c)
//============================================================================



static void Test_aBFu15i_Ui_BFu0i()
{
  {
    init_simple_test("aBFu15i_Ui_BFu0i");
    static STRUCT_IF_C aBFu15i_Ui_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_Ui_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ui_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ui_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ui_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_Ui_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ui_BFu0i, aBFu15i_Ui_BFu0i)
//============================================================================



static void Test_aBFu15i_Ui_BFu0ll()
{
  {
    init_simple_test("aBFu15i_Ui_BFu0ll");
    static STRUCT_IF_C aBFu15i_Ui_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15i_Ui_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ui_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ui_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ui_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Ui_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ui_BFu0ll, aBFu15i_Ui_BFu0ll)
//============================================================================



static void Test_aBFu15i_Ui_BFu0s()
{
  {
    init_simple_test("aBFu15i_Ui_BFu0s");
    static STRUCT_IF_C aBFu15i_Ui_BFu0s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_Ui_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ui_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ui_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ui_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_Ui_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ui_BFu0s, aBFu15i_Ui_BFu0s)
//============================================================================



static void Test_aBFu15i_Ul_BFu0c()
{
  {
    init_simple_test("aBFu15i_Ul_BFu0c");
    static STRUCT_IF_C aBFu15i_Ul_BFu0c lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_Ul_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ul_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ul_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ul_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_Ul_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ul_BFu0c, aBFu15i_Ul_BFu0c)
//============================================================================



static void Test_aBFu15i_Ul_BFu0i()
{
  {
    init_simple_test("aBFu15i_Ul_BFu0i");
    static STRUCT_IF_C aBFu15i_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aBFu15i_Ul_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ul_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ul_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ul_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_Ul_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ul_BFu0i, aBFu15i_Ul_BFu0i)
//============================================================================



static void Test_aBFu15i_Ul_BFu0ll()
{
  {
    init_simple_test("aBFu15i_Ul_BFu0ll");
    static STRUCT_IF_C aBFu15i_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu15i_Ul_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ul_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ul_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ul_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Ul_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ul_BFu0ll, aBFu15i_Ul_BFu0ll)
//============================================================================



static void Test_aBFu15i_Ul_BFu0s()
{
  {
    init_simple_test("aBFu15i_Ul_BFu0s");
    static STRUCT_IF_C aBFu15i_Ul_BFu0s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_Ul_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ul_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ul_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ul_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_Ul_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ul_BFu0s, aBFu15i_Ul_BFu0s)
//============================================================================



static void Test_aBFu15i_Us_BFu0c()
{
  {
    init_simple_test("aBFu15i_Us_BFu0c");
    static STRUCT_IF_C aBFu15i_Us_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Us_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Us_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Us_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Us_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_Us_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Us_BFu0c, aBFu15i_Us_BFu0c)
//============================================================================



static void Test_aBFu15i_Us_BFu0i()
{
  {
    init_simple_test("aBFu15i_Us_BFu0i");
    static STRUCT_IF_C aBFu15i_Us_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Us_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Us_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Us_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Us_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_Us_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Us_BFu0i, aBFu15i_Us_BFu0i)
//============================================================================



static void Test_aBFu15i_Us_BFu0ll()
{
  {
    init_simple_test("aBFu15i_Us_BFu0ll");
    static STRUCT_IF_C aBFu15i_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_Us_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Us_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Us_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Us_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Us_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Us_BFu0ll, aBFu15i_Us_BFu0ll)
//============================================================================



static void Test_aBFu15i_Us_BFu0s()
{
  {
    init_simple_test("aBFu15i_Us_BFu0s");
    static STRUCT_IF_C aBFu15i_Us_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Us_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Us_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Us_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Us_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_Us_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Us_BFu0s, aBFu15i_Us_BFu0s)
//============================================================================



static void Test_aBFu15i_Vp_BFu0c()
{
  {
    init_simple_test("aBFu15i_Vp_BFu0c");
    static STRUCT_IF_C aBFu15i_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_Vp_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Vp_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Vp_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Vp_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_Vp_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Vp_BFu0c, aBFu15i_Vp_BFu0c)
//============================================================================



static void Test_aBFu15i_Vp_BFu0i()
{
  {
    init_simple_test("aBFu15i_Vp_BFu0i");
    static STRUCT_IF_C aBFu15i_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15i_Vp_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Vp_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Vp_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Vp_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_Vp_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Vp_BFu0i, aBFu15i_Vp_BFu0i)
//============================================================================



static void Test_aBFu15i_Vp_BFu0ll()
{
  {
    init_simple_test("aBFu15i_Vp_BFu0ll");
    static STRUCT_IF_C aBFu15i_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aBFu15i_Vp_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Vp_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Vp_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Vp_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Vp_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Vp_BFu0ll, aBFu15i_Vp_BFu0ll)
//============================================================================



static void Test_aBFu15i_Vp_BFu0s()
{
  {
    init_simple_test("aBFu15i_Vp_BFu0s");
    static STRUCT_IF_C aBFu15i_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_Vp_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Vp_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Vp_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Vp_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_Vp_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Vp_BFu0s, aBFu15i_Vp_BFu0s)
//============================================================================



static void Test_aBFu15ll_BFu0c()
{
  {
    init_simple_test("aBFu15ll_BFu0c");
    static STRUCT_IF_C aBFu15ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c, aBFu15ll_BFu0c)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu0c()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu0c");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu0c, aBFu15ll_BFu0c_BFu0c)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu0i()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu0i");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_BFu0c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu0i, aBFu15ll_BFu0c_BFu0i)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu0ll()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu0ll");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu0c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu0ll, aBFu15ll_BFu0c_BFu0ll)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu0s()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu0s");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_BFu0c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu0s, aBFu15ll_BFu0c_BFu0s)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu15i()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu15i");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, 1, "aBFu15ll_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu15i, aBFu15ll_BFu0c_BFu15i)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu15ll()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu15ll");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, 1, "aBFu15ll_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu15ll, aBFu15ll_BFu0c_BFu15ll)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu15s()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu15s");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, 1, "aBFu15ll_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu15s, aBFu15ll_BFu0c_BFu15s)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu16i()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu16i");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, 1, "aBFu15ll_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15ll_BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu16i, aBFu15ll_BFu0c_BFu16i)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu16ll()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu16ll");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, 1, "aBFu15ll_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15ll_BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu16ll, aBFu15ll_BFu0c_BFu16ll)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu16s()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu16s");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, 1, "aBFu15ll_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15ll_BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu16s, aBFu15ll_BFu0c_BFu16s)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu17i()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu17i");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, 1, "aBFu15ll_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15ll_BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu17i, aBFu15ll_BFu0c_BFu17i)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu17ll()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu17ll");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, 1, "aBFu15ll_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15ll_BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu17ll, aBFu15ll_BFu0c_BFu17ll)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu1c()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu1c");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15ll_BFu0c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu1c, aBFu15ll_BFu0c_BFu1c)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu1i()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu1i");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15ll_BFu0c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu1i, aBFu15ll_BFu0c_BFu1i)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu1ll()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu1ll");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15ll_BFu0c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu1ll, aBFu15ll_BFu0c_BFu1ll)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu1s()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu1s");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15ll_BFu0c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu1s, aBFu15ll_BFu0c_BFu1s)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu31i()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu31i");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, 1, "aBFu15ll_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15ll_BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu31i, aBFu15ll_BFu0c_BFu31i)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu31ll()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu31ll");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, 1, "aBFu15ll_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15ll_BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu31ll, aBFu15ll_BFu0c_BFu31ll)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu32i()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu32i");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, 1, "aBFu15ll_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15ll_BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu32i, aBFu15ll_BFu0c_BFu32i)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu32ll()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu32ll");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, 1, "aBFu15ll_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15ll_BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu32ll, aBFu15ll_BFu0c_BFu32ll)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu33()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu33");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aBFu15ll_BFu0c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 33, 1, "aBFu15ll_BFu0c_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 33, hide_ull(1LL<<32), "aBFu15ll_BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu33, aBFu15ll_BFu0c_BFu33)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu7c()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu7c");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu7c, aBFu15ll_BFu0c_BFu7c)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu7i()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu7i");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu7i, aBFu15ll_BFu0c_BFu7i)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu7ll()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu7ll");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu7ll, aBFu15ll_BFu0c_BFu7ll)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu7s()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu7s");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu7s, aBFu15ll_BFu0c_BFu7s)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu8c()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu8c");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu8c, aBFu15ll_BFu0c_BFu8c)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu8i()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu8i");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu8i, aBFu15ll_BFu0c_BFu8i)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu8ll()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu8ll");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu8ll, aBFu15ll_BFu0c_BFu8ll)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu8s()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu8s");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu8s, aBFu15ll_BFu0c_BFu8s)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu9i()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu9i");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_BFu0c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, 1, "aBFu15ll_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15ll_BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu9i, aBFu15ll_BFu0c_BFu9i)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu9ll()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu9ll");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_BFu0c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, 1, "aBFu15ll_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15ll_BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu9ll, aBFu15ll_BFu0c_BFu9ll)
//============================================================================



static void Test_aBFu15ll_BFu0c_BFu9s()
{
  {
    init_simple_test("aBFu15ll_BFu0c_BFu9s");
    static STRUCT_IF_C aBFu15ll_BFu0c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_BFu0c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, 1, "aBFu15ll_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15ll_BFu0c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_BFu9s, aBFu15ll_BFu0c_BFu9s)
//============================================================================



static void Test_aBFu15ll_BFu0c_C()
{
  {
    init_simple_test("aBFu15ll_BFu0c_C");
    static STRUCT_IF_C aBFu15ll_BFu0c_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_C");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_C, aBFu15ll_BFu0c_C)
//============================================================================



static void Test_aBFu15ll_BFu0c_D()
{
  {
    init_simple_test("aBFu15ll_BFu0c_D");
    static STRUCT_IF_C aBFu15ll_BFu0c_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15ll_BFu0c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_D");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_D, aBFu15ll_BFu0c_D)
//============================================================================



static void Test_aBFu15ll_BFu0c_F()
{
  {
    init_simple_test("aBFu15ll_BFu0c_F");
    static STRUCT_IF_C aBFu15ll_BFu0c_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_F");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_F, aBFu15ll_BFu0c_F)
//============================================================================



static void Test_aBFu15ll_BFu0c_I()
{
  {
    init_simple_test("aBFu15ll_BFu0c_I");
    static STRUCT_IF_C aBFu15ll_BFu0c_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_I");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_I, aBFu15ll_BFu0c_I)
//============================================================================



static void Test_aBFu15ll_BFu0c_Ip()
{
  {
    init_simple_test("aBFu15ll_BFu0c_Ip");
    static STRUCT_IF_C aBFu15ll_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_Ip");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_Ip, aBFu15ll_BFu0c_Ip)
//============================================================================



static void Test_aBFu15ll_BFu0c_L()
{
  {
    init_simple_test("aBFu15ll_BFu0c_L");
    static STRUCT_IF_C aBFu15ll_BFu0c_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15ll_BFu0c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_L");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_L, aBFu15ll_BFu0c_L)
//============================================================================



static void Test_aBFu15ll_BFu0c_S()
{
  {
    init_simple_test("aBFu15ll_BFu0c_S");
    static STRUCT_IF_C aBFu15ll_BFu0c_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_S");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_S, aBFu15ll_BFu0c_S)
//============================================================================



static void Test_aBFu15ll_BFu0c_Uc()
{
  {
    init_simple_test("aBFu15ll_BFu0c_Uc");
    static STRUCT_IF_C aBFu15ll_BFu0c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_Uc");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_Uc, aBFu15ll_BFu0c_Uc)
//============================================================================



static void Test_aBFu15ll_BFu0c_Ui()
{
  {
    init_simple_test("aBFu15ll_BFu0c_Ui");
    static STRUCT_IF_C aBFu15ll_BFu0c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_Ui");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_Ui, aBFu15ll_BFu0c_Ui)
//============================================================================



static void Test_aBFu15ll_BFu0c_Ul()
{
  {
    init_simple_test("aBFu15ll_BFu0c_Ul");
    static STRUCT_IF_C aBFu15ll_BFu0c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15ll_BFu0c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_Ul");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_Ul, aBFu15ll_BFu0c_Ul)
//============================================================================



static void Test_aBFu15ll_BFu0c_Us()
{
  {
    init_simple_test("aBFu15ll_BFu0c_Us");
    static STRUCT_IF_C aBFu15ll_BFu0c_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_Us");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_Us, aBFu15ll_BFu0c_Us)
//============================================================================



static void Test_aBFu15ll_BFu0c_Vp()
{
  {
    init_simple_test("aBFu15ll_BFu0c_Vp");
    static STRUCT_IF_C aBFu15ll_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_Vp");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_Vp, aBFu15ll_BFu0c_Vp)
//============================================================================



static void Test_aBFu15ll_BFu0i()
{
  {
    init_simple_test("aBFu15ll_BFu0i");
    static STRUCT_IF_C aBFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i, aBFu15ll_BFu0i)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu0c()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu0c");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_BFu0i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu0c, aBFu15ll_BFu0i_BFu0c)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu0i()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu0i");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_BFu0i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu0i, aBFu15ll_BFu0i_BFu0i)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu0ll()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu0ll");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu0i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu0ll, aBFu15ll_BFu0i_BFu0ll)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu0s()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu0s");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_BFu0i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu0s, aBFu15ll_BFu0i_BFu0s)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu15i()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu15i");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15ll_BFu0i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 15, 1, "aBFu15ll_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu15i, aBFu15ll_BFu0i_BFu15i)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu15ll()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu15ll");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15ll_BFu0i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 15, 1, "aBFu15ll_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu15ll, aBFu15ll_BFu0i_BFu15ll)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu15s()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu15s");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15ll_BFu0i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 15, 1, "aBFu15ll_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu15s, aBFu15ll_BFu0i_BFu15s)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu16i()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu16i");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15ll_BFu0i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 16, 1, "aBFu15ll_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15ll_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu16i, aBFu15ll_BFu0i_BFu16i)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu16ll()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu16ll");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15ll_BFu0i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 16, 1, "aBFu15ll_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15ll_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu16ll, aBFu15ll_BFu0i_BFu16ll)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu16s()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu16s");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15ll_BFu0i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 16, 1, "aBFu15ll_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15ll_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu16s, aBFu15ll_BFu0i_BFu16s)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu17i()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu17i");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aBFu15ll_BFu0i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 17, 1, "aBFu15ll_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15ll_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu17i, aBFu15ll_BFu0i_BFu17i)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu17ll()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu17ll");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aBFu15ll_BFu0i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 17, 1, "aBFu15ll_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15ll_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu17ll, aBFu15ll_BFu0i_BFu17ll)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu1c()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu1c");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu1c, aBFu15ll_BFu0i_BFu1c)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu1i()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu1i");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu1i, aBFu15ll_BFu0i_BFu1i)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu1ll()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu1ll");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu1ll, aBFu15ll_BFu0i_BFu1ll)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu1s()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu1s");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu1s, aBFu15ll_BFu0i_BFu1s)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu31i()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu31i");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15ll_BFu0i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 31, 1, "aBFu15ll_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15ll_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu31i, aBFu15ll_BFu0i_BFu31i)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu31ll()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu31ll");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15ll_BFu0i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 31, 1, "aBFu15ll_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15ll_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu31ll, aBFu15ll_BFu0i_BFu31ll)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu32i()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu32i");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15ll_BFu0i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 32, 1, "aBFu15ll_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15ll_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu32i, aBFu15ll_BFu0i_BFu32i)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu32ll()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu32ll");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15ll_BFu0i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 32, 1, "aBFu15ll_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15ll_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu32ll, aBFu15ll_BFu0i_BFu32ll)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu33()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu33");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(9,9), "sizeof(aBFu15ll_BFu0i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 33, 1, "aBFu15ll_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 33, hide_ull(1LL<<32), "aBFu15ll_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu33, aBFu15ll_BFu0i_BFu33)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu7c()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu7c");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu7c, aBFu15ll_BFu0i_BFu7c)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu7i()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu7i");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu7i, aBFu15ll_BFu0i_BFu7i)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu7ll()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu7ll");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu7ll, aBFu15ll_BFu0i_BFu7ll)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu7s()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu7s");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu7s, aBFu15ll_BFu0i_BFu7s)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu8c()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu8c");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu8c, aBFu15ll_BFu0i_BFu8c)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu8i()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu8i");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu8i, aBFu15ll_BFu0i_BFu8i)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu8ll()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu8ll");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu8ll, aBFu15ll_BFu0i_BFu8ll)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu8s()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu8s");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu8s, aBFu15ll_BFu0i_BFu8s)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu9i()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu9i");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15ll_BFu0i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 9, 1, "aBFu15ll_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15ll_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu9i, aBFu15ll_BFu0i_BFu9i)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu9ll()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu9ll");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15ll_BFu0i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 9, 1, "aBFu15ll_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15ll_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu9ll, aBFu15ll_BFu0i_BFu9ll)
//============================================================================



static void Test_aBFu15ll_BFu0i_BFu9s()
{
  {
    init_simple_test("aBFu15ll_BFu0i_BFu9s");
    static STRUCT_IF_C aBFu15ll_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15ll_BFu0i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 9, 1, "aBFu15ll_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(4,4), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15ll_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_BFu9s, aBFu15ll_BFu0i_BFu9s)
//============================================================================



static void Test_aBFu15ll_BFu0i_C()
{
  {
    init_simple_test("aBFu15ll_BFu0i_C");
    static STRUCT_IF_C aBFu15ll_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_C");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_C, aBFu15ll_BFu0i_C)
//============================================================================



static void Test_aBFu15ll_BFu0i_D()
{
  {
    init_simple_test("aBFu15ll_BFu0i_D");
    static STRUCT_IF_C aBFu15ll_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aBFu15ll_BFu0i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_D");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_D, aBFu15ll_BFu0i_D)
//============================================================================



static void Test_aBFu15ll_BFu0i_F()
{
  {
    init_simple_test("aBFu15ll_BFu0i_F");
    static STRUCT_IF_C aBFu15ll_BFu0i_F lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15ll_BFu0i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_F");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_F, aBFu15ll_BFu0i_F)
//============================================================================



static void Test_aBFu15ll_BFu0i_I()
{
  {
    init_simple_test("aBFu15ll_BFu0i_I");
    static STRUCT_IF_C aBFu15ll_BFu0i_I lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15ll_BFu0i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_I");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_I, aBFu15ll_BFu0i_I)
//============================================================================



static void Test_aBFu15ll_BFu0i_Ip()
{
  {
    init_simple_test("aBFu15ll_BFu0i_Ip");
    static STRUCT_IF_C aBFu15ll_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15ll_BFu0i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_Ip");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_Ip, aBFu15ll_BFu0i_Ip)
//============================================================================



static void Test_aBFu15ll_BFu0i_L()
{
  {
    init_simple_test("aBFu15ll_BFu0i_L");
    static STRUCT_IF_C aBFu15ll_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aBFu15ll_BFu0i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_L");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_L, aBFu15ll_BFu0i_L)
//============================================================================



static void Test_aBFu15ll_BFu0i_S()
{
  {
    init_simple_test("aBFu15ll_BFu0i_S");
    static STRUCT_IF_C aBFu15ll_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15ll_BFu0i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_S");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_S, aBFu15ll_BFu0i_S)
//============================================================================



static void Test_aBFu15ll_BFu0i_Uc()
{
  {
    init_simple_test("aBFu15ll_BFu0i_Uc");
    static STRUCT_IF_C aBFu15ll_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_Uc");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_Uc, aBFu15ll_BFu0i_Uc)
//============================================================================



static void Test_aBFu15ll_BFu0i_Ui()
{
  {
    init_simple_test("aBFu15ll_BFu0i_Ui");
    static STRUCT_IF_C aBFu15ll_BFu0i_Ui lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu15ll_BFu0i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_Ui");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_Ui, aBFu15ll_BFu0i_Ui)
//============================================================================



static void Test_aBFu15ll_BFu0i_Ul()
{
  {
    init_simple_test("aBFu15ll_BFu0i_Ul");
    static STRUCT_IF_C aBFu15ll_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(aBFu15ll_BFu0i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_Ul");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_Ul, aBFu15ll_BFu0i_Ul)
//============================================================================



static void Test_aBFu15ll_BFu0i_Us()
{
  {
    init_simple_test("aBFu15ll_BFu0i_Us");
    static STRUCT_IF_C aBFu15ll_BFu0i_Us lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu15ll_BFu0i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_Us");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_Us, aBFu15ll_BFu0i_Us)
//============================================================================



static void Test_aBFu15ll_BFu0i_Vp()
{
  {
    init_simple_test("aBFu15ll_BFu0i_Vp");
    static STRUCT_IF_C aBFu15ll_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15ll_BFu0i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_Vp");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_Vp, aBFu15ll_BFu0i_Vp)
//============================================================================



static void Test_aBFu15ll_BFu0ll()
{
  {
    init_simple_test("aBFu15ll_BFu0ll");
    static STRUCT_IF_C aBFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll, aBFu15ll_BFu0ll)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu0c()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu0c");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu0ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu0c, aBFu15ll_BFu0ll_BFu0c)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu0i()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu0i");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu0ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu0i, aBFu15ll_BFu0ll_BFu0i)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu0ll()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu0ll");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu0ll, aBFu15ll_BFu0ll_BFu0ll)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu0s()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu0s");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu0ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu0s, aBFu15ll_BFu0ll_BFu0s)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu15i()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu15i");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 15, 1, "aBFu15ll_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu15i, aBFu15ll_BFu0ll_BFu15i)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu15ll()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu15ll");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 15, 1, "aBFu15ll_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu15ll, aBFu15ll_BFu0ll_BFu15ll)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu15s()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu15s");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 15, 1, "aBFu15ll_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu15s, aBFu15ll_BFu0ll_BFu15s)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu16i()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu16i");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 16, 1, "aBFu15ll_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15ll_BFu0ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu16i, aBFu15ll_BFu0ll_BFu16i)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu16ll()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu16ll");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 16, 1, "aBFu15ll_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15ll_BFu0ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu16ll, aBFu15ll_BFu0ll_BFu16ll)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu16s()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu16s");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 16, 1, "aBFu15ll_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15ll_BFu0ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu16s, aBFu15ll_BFu0ll_BFu16s)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu17i()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu17i");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu15ll_BFu0ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 17, 1, "aBFu15ll_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15ll_BFu0ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu17i, aBFu15ll_BFu0ll_BFu17i)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu17ll()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu17ll");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu15ll_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 17, 1, "aBFu15ll_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15ll_BFu0ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu17ll, aBFu15ll_BFu0ll_BFu17ll)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu1c()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu1c");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu1c, aBFu15ll_BFu0ll_BFu1c)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu1i()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu1i");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu1i, aBFu15ll_BFu0ll_BFu1i)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu1ll()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu1ll");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu1ll, aBFu15ll_BFu0ll_BFu1ll)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu1s()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu1s");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu1s, aBFu15ll_BFu0ll_BFu1s)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu31i()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu31i");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15ll_BFu0ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 31, 1, "aBFu15ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15ll_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu31i, aBFu15ll_BFu0ll_BFu31i)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu31ll()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu31ll");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15ll_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 31, 1, "aBFu15ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15ll_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu31ll, aBFu15ll_BFu0ll_BFu31ll)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu32i()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu32i");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15ll_BFu0ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 32, 1, "aBFu15ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15ll_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu32i, aBFu15ll_BFu0ll_BFu32i)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu32ll()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu32ll");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15ll_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 32, 1, "aBFu15ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15ll_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu32ll, aBFu15ll_BFu0ll_BFu32ll)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu33()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu33");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu15ll_BFu0ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 33, 1, "aBFu15ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 33, hide_ull(1LL<<32), "aBFu15ll_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu33, aBFu15ll_BFu0ll_BFu33)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu7c()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu7c");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu7c, aBFu15ll_BFu0ll_BFu7c)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu7i()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu7i");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu7i, aBFu15ll_BFu0ll_BFu7i)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu7ll()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu7ll");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu7ll, aBFu15ll_BFu0ll_BFu7ll)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu7s()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu7s");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu7s, aBFu15ll_BFu0ll_BFu7s)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu8c()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu8c");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu8c, aBFu15ll_BFu0ll_BFu8c)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu8i()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu8i");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu8i, aBFu15ll_BFu0ll_BFu8i)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu8ll()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu8ll");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu8ll, aBFu15ll_BFu0ll_BFu8ll)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu8s()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu8s");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu8s, aBFu15ll_BFu0ll_BFu8s)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu9i()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu9i");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 9, 1, "aBFu15ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15ll_BFu0ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu9i, aBFu15ll_BFu0ll_BFu9i)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu9ll()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu9ll");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 9, 1, "aBFu15ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15ll_BFu0ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu9ll, aBFu15ll_BFu0ll_BFu9ll)
//============================================================================



static void Test_aBFu15ll_BFu0ll_BFu9s()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_BFu9s");
    static STRUCT_IF_C aBFu15ll_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 9, 1, "aBFu15ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15ll_BFu0ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_BFu9s, aBFu15ll_BFu0ll_BFu9s)
//============================================================================



static void Test_aBFu15ll_BFu0ll_C()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_C");
    static STRUCT_IF_C aBFu15ll_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_C, aBFu15ll_BFu0ll_C)
//============================================================================



static void Test_aBFu15ll_BFu0ll_D()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_D");
    static STRUCT_IF_C aBFu15ll_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu15ll_BFu0ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_D, aBFu15ll_BFu0ll_D)
//============================================================================



static void Test_aBFu15ll_BFu0ll_F()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_F");
    static STRUCT_IF_C aBFu15ll_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15ll_BFu0ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_F, aBFu15ll_BFu0ll_F)
//============================================================================



static void Test_aBFu15ll_BFu0ll_I()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_I");
    static STRUCT_IF_C aBFu15ll_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15ll_BFu0ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_I, aBFu15ll_BFu0ll_I)
//============================================================================



static void Test_aBFu15ll_BFu0ll_Ip()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_Ip");
    static STRUCT_IF_C aBFu15ll_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aBFu15ll_BFu0ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_Ip, aBFu15ll_BFu0ll_Ip)
//============================================================================



static void Test_aBFu15ll_BFu0ll_L()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_L");
    static STRUCT_IF_C aBFu15ll_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu15ll_BFu0ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_L, aBFu15ll_BFu0ll_L)
//============================================================================



static void Test_aBFu15ll_BFu0ll_S()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_S");
    static STRUCT_IF_C aBFu15ll_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_S, aBFu15ll_BFu0ll_S)
//============================================================================



static void Test_aBFu15ll_BFu0ll_Uc()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_Uc");
    static STRUCT_IF_C aBFu15ll_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu15ll_BFu0ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_Uc, aBFu15ll_BFu0ll_Uc)
//============================================================================



static void Test_aBFu15ll_BFu0ll_Ui()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_Ui");
    static STRUCT_IF_C aBFu15ll_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu15ll_BFu0ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_Ui, aBFu15ll_BFu0ll_Ui)
//============================================================================



static void Test_aBFu15ll_BFu0ll_Ul()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_Ul");
    static STRUCT_IF_C aBFu15ll_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aBFu15ll_BFu0ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_Ul, aBFu15ll_BFu0ll_Ul)
//============================================================================



static void Test_aBFu15ll_BFu0ll_Us()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_Us");
    static STRUCT_IF_C aBFu15ll_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_Us, aBFu15ll_BFu0ll_Us)
//============================================================================



static void Test_aBFu15ll_BFu0ll_Vp()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_Vp");
    static STRUCT_IF_C aBFu15ll_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aBFu15ll_BFu0ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_Vp, aBFu15ll_BFu0ll_Vp)
//============================================================================



static void Test_aBFu15ll_BFu0s()
{
  {
    init_simple_test("aBFu15ll_BFu0s");
    static STRUCT_IF_C aBFu15ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s, aBFu15ll_BFu0s)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu0c()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu0c");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_BFu0s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu0c, aBFu15ll_BFu0s_BFu0c)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu0i()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu0i");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_BFu0s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu0i, aBFu15ll_BFu0s_BFu0i)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu0ll()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu0ll");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu0s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu0ll, aBFu15ll_BFu0s_BFu0ll)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu0s()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu0s");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_BFu0s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu0s, aBFu15ll_BFu0s_BFu0s)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu15i()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu15i");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, 1, "aBFu15ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu15i, aBFu15ll_BFu0s_BFu15i)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu15ll()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu15ll");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, 1, "aBFu15ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu15ll, aBFu15ll_BFu0s_BFu15ll)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu15s()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu15s");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, 1, "aBFu15ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu15s, aBFu15ll_BFu0s_BFu15s)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu16i()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu16i");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, 1, "aBFu15ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15ll_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu16i, aBFu15ll_BFu0s_BFu16i)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu16ll()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu16ll");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, 1, "aBFu15ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15ll_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu16ll, aBFu15ll_BFu0s_BFu16ll)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu16s()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu16s");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, 1, "aBFu15ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 16, hide_ull(1LL<<15), "aBFu15ll_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu16s, aBFu15ll_BFu0s_BFu16s)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu17i()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu17i");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, 1, "aBFu15ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15ll_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu17i, aBFu15ll_BFu0s_BFu17i)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu17ll()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu17ll");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(aBFu15ll_BFu0s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, 1, "aBFu15ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 17, hide_ull(1LL<<16), "aBFu15ll_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu17ll, aBFu15ll_BFu0s_BFu17ll)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu1c()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu1c");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15ll_BFu0s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu1c, aBFu15ll_BFu0s_BFu1c)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu1i()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu1i");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15ll_BFu0s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu1i, aBFu15ll_BFu0s_BFu1i)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu1ll()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu1ll");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15ll_BFu0s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu1ll, aBFu15ll_BFu0s_BFu1ll)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu1s()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu1s");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(aBFu15ll_BFu0s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 1, 1, "aBFu15ll_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu1s, aBFu15ll_BFu0s_BFu1s)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu31i()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu31i");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, 1, "aBFu15ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15ll_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu31i, aBFu15ll_BFu0s_BFu31i)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu31ll()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu31ll");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, 1, "aBFu15ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 31, hide_ull(1LL<<30), "aBFu15ll_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu31ll, aBFu15ll_BFu0s_BFu31ll)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu32i()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu32i");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, 1, "aBFu15ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15ll_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu32i, aBFu15ll_BFu0s_BFu32i)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu32ll()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu32ll");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, 1, "aBFu15ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 32, hide_ull(1LL<<31), "aBFu15ll_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu32ll, aBFu15ll_BFu0s_BFu32ll)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu33()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu33");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(aBFu15ll_BFu0s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 33, 1, "aBFu15ll_BFu0s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 33, hide_ull(1LL<<32), "aBFu15ll_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu33, aBFu15ll_BFu0s_BFu33)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu7c()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu7c");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu7c, aBFu15ll_BFu0s_BFu7c)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu7i()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu7i");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu7i, aBFu15ll_BFu0s_BFu7i)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu7ll()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu7ll");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu7ll, aBFu15ll_BFu0s_BFu7ll)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu7s()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu7s");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, 1, "aBFu15ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 7, hide_ull(1LL<<6), "aBFu15ll_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu7s, aBFu15ll_BFu0s_BFu7s)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu8c()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu8c");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu8c, aBFu15ll_BFu0s_BFu8c)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu8i()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu8i");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu8i, aBFu15ll_BFu0s_BFu8i)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu8ll()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu8ll");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu8ll, aBFu15ll_BFu0s_BFu8ll)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu8s()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu8s");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, 1, "aBFu15ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 8, hide_ull(1LL<<7), "aBFu15ll_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu8s, aBFu15ll_BFu0s_BFu8s)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu9i()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu9i");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_BFu0s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, 1, "aBFu15ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15ll_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu9i, aBFu15ll_BFu0s_BFu9i)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu9ll()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu9ll");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_BFu0s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, 1, "aBFu15ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15ll_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu9ll, aBFu15ll_BFu0s_BFu9ll)
//============================================================================



static void Test_aBFu15ll_BFu0s_BFu9s()
{
  {
    init_simple_test("aBFu15ll_BFu0s_BFu9s");
    static STRUCT_IF_C aBFu15ll_BFu0s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_BFu0s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, 1, "aBFu15ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(2,2), ABISELECT(0,0), 9, hide_ull(1LL<<8), "aBFu15ll_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_BFu9s, aBFu15ll_BFu0s_BFu9s)
//============================================================================



static void Test_aBFu15ll_BFu0s_C()
{
  {
    init_simple_test("aBFu15ll_BFu0s_C");
    static STRUCT_IF_C aBFu15ll_BFu0s_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_C");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_C, aBFu15ll_BFu0s_C)
//============================================================================



static void Test_aBFu15ll_BFu0s_D()
{
  {
    init_simple_test("aBFu15ll_BFu0s_D");
    static STRUCT_IF_C aBFu15ll_BFu0s_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15ll_BFu0s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_D");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_D, aBFu15ll_BFu0s_D)
//============================================================================



static void Test_aBFu15ll_BFu0s_F()
{
  {
    init_simple_test("aBFu15ll_BFu0s_F");
    static STRUCT_IF_C aBFu15ll_BFu0s_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_F");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_F, aBFu15ll_BFu0s_F)
//============================================================================



static void Test_aBFu15ll_BFu0s_I()
{
  {
    init_simple_test("aBFu15ll_BFu0s_I");
    static STRUCT_IF_C aBFu15ll_BFu0s_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_I");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_I, aBFu15ll_BFu0s_I)
//============================================================================



static void Test_aBFu15ll_BFu0s_Ip()
{
  {
    init_simple_test("aBFu15ll_BFu0s_Ip");
    static STRUCT_IF_C aBFu15ll_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_Ip");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_Ip, aBFu15ll_BFu0s_Ip)
//============================================================================



static void Test_aBFu15ll_BFu0s_L()
{
  {
    init_simple_test("aBFu15ll_BFu0s_L");
    static STRUCT_IF_C aBFu15ll_BFu0s_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15ll_BFu0s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_L");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_L, aBFu15ll_BFu0s_L)
//============================================================================



static void Test_aBFu15ll_BFu0s_S()
{
  {
    init_simple_test("aBFu15ll_BFu0s_S");
    static STRUCT_IF_C aBFu15ll_BFu0s_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_S");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_S, aBFu15ll_BFu0s_S)
//============================================================================



static void Test_aBFu15ll_BFu0s_Uc()
{
  {
    init_simple_test("aBFu15ll_BFu0s_Uc");
    static STRUCT_IF_C aBFu15ll_BFu0s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu0s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_Uc");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_Uc, aBFu15ll_BFu0s_Uc)
//============================================================================



static void Test_aBFu15ll_BFu0s_Ui()
{
  {
    init_simple_test("aBFu15ll_BFu0s_Ui");
    static STRUCT_IF_C aBFu15ll_BFu0s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu0s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_Ui");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_Ui, aBFu15ll_BFu0s_Ui)
//============================================================================



static void Test_aBFu15ll_BFu0s_Ul()
{
  {
    init_simple_test("aBFu15ll_BFu0s_Ul");
    static STRUCT_IF_C aBFu15ll_BFu0s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15ll_BFu0s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_Ul");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_Ul, aBFu15ll_BFu0s_Ul)
//============================================================================



static void Test_aBFu15ll_BFu0s_Us()
{
  {
    init_simple_test("aBFu15ll_BFu0s_Us");
    static STRUCT_IF_C aBFu15ll_BFu0s_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu0s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_Us");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_Us, aBFu15ll_BFu0s_Us)
//============================================================================



static void Test_aBFu15ll_BFu0s_Vp()
{
  {
    init_simple_test("aBFu15ll_BFu0s_Vp");
    static STRUCT_IF_C aBFu15ll_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_BFu0s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_Vp");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_Vp, aBFu15ll_BFu0s_Vp)
//============================================================================



static void Test_aBFu15ll_BFu15i_BFu0c()
{
  {
    init_simple_test("aBFu15ll_BFu15i_BFu0c");
    static STRUCT_IF_C aBFu15ll_BFu15i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu15i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15i_BFu0c, aBFu15ll_BFu15i_BFu0c)
//============================================================================



static void Test_aBFu15ll_BFu15i_BFu0i()
{
  {
    init_simple_test("aBFu15ll_BFu15i_BFu0i");
    static STRUCT_IF_C aBFu15ll_BFu15i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu15i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15i_BFu0i, aBFu15ll_BFu15i_BFu0i)
//============================================================================



static void Test_aBFu15ll_BFu15i_BFu0ll()
{
  {
    init_simple_test("aBFu15ll_BFu15i_BFu0ll");
    static STRUCT_IF_C aBFu15ll_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu15i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15i_BFu0ll, aBFu15ll_BFu15i_BFu0ll)
//============================================================================



static void Test_aBFu15ll_BFu15i_BFu0s()
{
  {
    init_simple_test("aBFu15ll_BFu15i_BFu0s");
    static STRUCT_IF_C aBFu15ll_BFu15i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu15i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15i_BFu0s, aBFu15ll_BFu15i_BFu0s)
//============================================================================



static void Test_aBFu15ll_BFu15ll_BFu0c()
{
  {
    init_simple_test("aBFu15ll_BFu15ll_BFu0c");
    static STRUCT_IF_C aBFu15ll_BFu15ll_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu15ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15ll_BFu0c, aBFu15ll_BFu15ll_BFu0c)
//============================================================================



static void Test_aBFu15ll_BFu15ll_BFu0i()
{
  {
    init_simple_test("aBFu15ll_BFu15ll_BFu0i");
    static STRUCT_IF_C aBFu15ll_BFu15ll_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu15ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15ll_BFu0i, aBFu15ll_BFu15ll_BFu0i)
//============================================================================



static void Test_aBFu15ll_BFu15ll_BFu0ll()
{
  {
    init_simple_test("aBFu15ll_BFu15ll_BFu0ll");
    static STRUCT_IF_C aBFu15ll_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15ll_BFu0ll, aBFu15ll_BFu15ll_BFu0ll)
//============================================================================



static void Test_aBFu15ll_BFu15ll_BFu0s()
{
  {
    init_simple_test("aBFu15ll_BFu15ll_BFu0s");
    static STRUCT_IF_C aBFu15ll_BFu15ll_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu15ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15ll_BFu0s, aBFu15ll_BFu15ll_BFu0s)
//============================================================================



static void Test_aBFu15ll_BFu15s_BFu0c()
{
  {
    init_simple_test("aBFu15ll_BFu15s_BFu0c");
    static STRUCT_IF_C aBFu15ll_BFu15s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu15s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15s_BFu0c, aBFu15ll_BFu15s_BFu0c)
//============================================================================



static void Test_aBFu15ll_BFu15s_BFu0i()
{
  {
    init_simple_test("aBFu15ll_BFu15s_BFu0i");
    static STRUCT_IF_C aBFu15ll_BFu15s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu15s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15s_BFu0i, aBFu15ll_BFu15s_BFu0i)
//============================================================================



static void Test_aBFu15ll_BFu15s_BFu0ll()
{
  {
    init_simple_test("aBFu15ll_BFu15s_BFu0ll");
    static STRUCT_IF_C aBFu15ll_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu15s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15s_BFu0ll, aBFu15ll_BFu15s_BFu0ll)
//============================================================================



static void Test_aBFu15ll_BFu15s_BFu0s()
{
  {
    init_simple_test("aBFu15ll_BFu15s_BFu0s");
    static STRUCT_IF_C aBFu15ll_BFu15s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu15s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15s_BFu0s, aBFu15ll_BFu15s_BFu0s)
//============================================================================



static void Test_aBFu15ll_BFu16i_BFu0c()
{
  {
    init_simple_test("aBFu15ll_BFu16i_BFu0c");
    static STRUCT_IF_C aBFu15ll_BFu16i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu16i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16i_BFu0c, aBFu15ll_BFu16i_BFu0c)
//============================================================================



static void Test_aBFu15ll_BFu16i_BFu0i()
{
  {
    init_simple_test("aBFu15ll_BFu16i_BFu0i");
    static STRUCT_IF_C aBFu15ll_BFu16i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu16i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16i_BFu0i, aBFu15ll_BFu16i_BFu0i)
//============================================================================



static void Test_aBFu15ll_BFu16i_BFu0ll()
{
  {
    init_simple_test("aBFu15ll_BFu16i_BFu0ll");
    static STRUCT_IF_C aBFu15ll_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu16i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16i_BFu0ll, aBFu15ll_BFu16i_BFu0ll)
//============================================================================



static void Test_aBFu15ll_BFu16i_BFu0s()
{
  {
    init_simple_test("aBFu15ll_BFu16i_BFu0s");
    static STRUCT_IF_C aBFu15ll_BFu16i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu16i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16i_BFu0s, aBFu15ll_BFu16i_BFu0s)
//============================================================================



static void Test_aBFu15ll_BFu16ll_BFu0c()
{
  {
    init_simple_test("aBFu15ll_BFu16ll_BFu0c");
    static STRUCT_IF_C aBFu15ll_BFu16ll_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu16ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16ll_BFu0c, aBFu15ll_BFu16ll_BFu0c)
//============================================================================



static void Test_aBFu15ll_BFu16ll_BFu0i()
{
  {
    init_simple_test("aBFu15ll_BFu16ll_BFu0i");
    static STRUCT_IF_C aBFu15ll_BFu16ll_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu16ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16ll_BFu0i, aBFu15ll_BFu16ll_BFu0i)
//============================================================================



static void Test_aBFu15ll_BFu16ll_BFu0ll()
{
  {
    init_simple_test("aBFu15ll_BFu16ll_BFu0ll");
    static STRUCT_IF_C aBFu15ll_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16ll_BFu0ll, aBFu15ll_BFu16ll_BFu0ll)
//============================================================================



static void Test_aBFu15ll_BFu16ll_BFu0s()
{
  {
    init_simple_test("aBFu15ll_BFu16ll_BFu0s");
    static STRUCT_IF_C aBFu15ll_BFu16ll_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu16ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16ll_BFu0s, aBFu15ll_BFu16ll_BFu0s)
//============================================================================



static void Test_aBFu15ll_BFu16s_BFu0c()
{
  {
    init_simple_test("aBFu15ll_BFu16s_BFu0c");
    static STRUCT_IF_C aBFu15ll_BFu16s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu16s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16s_BFu0c, aBFu15ll_BFu16s_BFu0c)
//============================================================================



static void Test_aBFu15ll_BFu16s_BFu0i()
{
  {
    init_simple_test("aBFu15ll_BFu16s_BFu0i");
    static STRUCT_IF_C aBFu15ll_BFu16s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu16s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16s_BFu0i, aBFu15ll_BFu16s_BFu0i)
//============================================================================



static void Test_aBFu15ll_BFu16s_BFu0ll()
{
  {
    init_simple_test("aBFu15ll_BFu16s_BFu0ll");
    static STRUCT_IF_C aBFu15ll_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu16s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16s_BFu0ll, aBFu15ll_BFu16s_BFu0ll)
//===================================