// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
#include "testsuite.h"
typedef struct empty {} empty;
struct __attribute__((packed)) aBFu0c_BFu0c_Sf { unsigned char :0; unsigned char :0; empty v1; };
struct __attribute__((packed)) aBFu0c_BFu0i_Sf { unsigned char :0; unsigned int :0; empty v1; };
struct __attribute__((packed)) aBFu0c_BFu0ll_Sf { unsigned char :0; unsigned long long :0; empty v1; };
struct __attribute__((packed)) aBFu0c_BFu0s_Sf { unsigned char :0; unsigned short :0; empty v1; };
struct __attribute__((packed)) aBFu0c_BFu15i_Sf { unsigned char :0; unsigned int v1:15; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu15ll_Sf { unsigned char :0; unsigned long long v1:15; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu15s_Sf { unsigned char :0; unsigned short v1:15; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu16i_Sf { unsigned char :0; unsigned int v1:16; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu16ll_Sf { unsigned char :0; unsigned long long v1:16; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu16s_Sf { unsigned char :0; unsigned short v1:16; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu17i_Sf { unsigned char :0; unsigned int v1:17; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu17ll_Sf { unsigned char :0; unsigned long long v1:17; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu1c_Sf { unsigned char :0; unsigned char v1:1; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu1i_Sf { unsigned char :0; unsigned int v1:1; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu1ll_Sf { unsigned char :0; unsigned long long v1:1; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu1s_Sf { unsigned char :0; unsigned short v1:1; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu31i_Sf { unsigned char :0; unsigned int v1:31; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu31ll_Sf { unsigned char :0; unsigned long long v1:31; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu32i_Sf { unsigned char :0; unsigned int v1:32; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu32ll_Sf { unsigned char :0; unsigned long long v1:32; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu33_Sf { unsigned char :0; unsigned long long v1:33; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu7c_Sf { unsigned char :0; unsigned char v1:7; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu7i_Sf { unsigned char :0; unsigned int v1:7; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu7ll_Sf { unsigned char :0; unsigned long long v1:7; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu7s_Sf { unsigned char :0; unsigned short v1:7; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu8c_Sf { unsigned char :0; unsigned char v1:8; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu8i_Sf { unsigned char :0; unsigned int v1:8; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu8ll_Sf { unsigned char :0; unsigned long long v1:8; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu8s_Sf { unsigned char :0; unsigned short v1:8; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu9i_Sf { unsigned char :0; unsigned int v1:9; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu9ll_Sf { unsigned char :0; unsigned long long v1:9; empty v2; };
struct __attribute__((packed)) aBFu0c_BFu9s_Sf { unsigned char :0; unsigned short v1:9; empty v2; };
struct __attribute__((packed)) aBFu0c_C_Sf { unsigned char :0; char v1; empty v2; };
struct __attribute__((packed)) aBFu0c_D_Sf { unsigned char :0; double v1; empty v2; };
struct __attribute__((packed)) aBFu0c_F_Sf { unsigned char :0; float v1; empty v2; };
struct __attribute__((packed)) aBFu0c_I_Sf { unsigned char :0; int v1; empty v2; };
struct __attribute__((packed)) aBFu0c_Ip_Sf { unsigned char :0; int * v1; empty v2; };
struct __attribute__((packed)) aBFu0c_L_Sf { unsigned char :0; long long v1; empty v2; };
struct __attribute__((packed)) aBFu0c_S_Sf { unsigned char :0; short v1; empty v2; };
struct __attribute__((packed)) aBFu0c_Sf { unsigned char :0; empty v1; };
struct __attribute__((packed)) aBFu0c_Sf_BFu0c { unsigned char :0; empty v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0c_Sf_BFu0i { unsigned char :0; empty v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0c_Sf_BFu0ll { unsigned char :0; empty v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0c_Sf_BFu0s { unsigned char :0; empty v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0c_Sf_BFu15i { unsigned char :0; empty v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0c_Sf_BFu15ll { unsigned char :0; empty v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0c_Sf_BFu15s { unsigned char :0; empty v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0c_Sf_BFu16i { unsigned char :0; empty v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0c_Sf_BFu16ll { unsigned char :0; empty v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0c_Sf_BFu16s { unsigned char :0; empty v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0c_Sf_BFu17i { unsigned char :0; empty v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0c_Sf_BFu17ll { unsigned char :0; empty v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0c_Sf_BFu1c { unsigned char :0; empty v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0c_Sf_BFu1i { unsigned char :0; empty v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0c_Sf_BFu1ll { unsigned char :0; empty v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0c_Sf_BFu1s { unsigned char :0; empty v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0c_Sf_BFu31i { unsigned char :0; empty v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0c_Sf_BFu31ll { unsigned char :0; empty v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0c_Sf_BFu32i { unsigned char :0; empty v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0c_Sf_BFu32ll { unsigned char :0; empty v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0c_Sf_BFu33 { unsigned char :0; empty v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0c_Sf_BFu7c { unsigned char :0; empty v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0c_Sf_BFu7i { unsigned char :0; empty v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0c_Sf_BFu7ll { unsigned char :0; empty v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0c_Sf_BFu7s { unsigned char :0; empty v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0c_Sf_BFu8c { unsigned char :0; empty v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0c_Sf_BFu8i { unsigned char :0; empty v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0c_Sf_BFu8ll { unsigned char :0; empty v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0c_Sf_BFu8s { unsigned char :0; empty v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0c_Sf_BFu9i { unsigned char :0; empty v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0c_Sf_BFu9ll { unsigned char :0; empty v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0c_Sf_BFu9s { unsigned char :0; empty v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0c_Sf_C { unsigned char :0; empty v1; char v2; };
struct __attribute__((packed)) aBFu0c_Sf_D { unsigned char :0; empty v1; double v2; };
struct __attribute__((packed)) aBFu0c_Sf_F { unsigned char :0; empty v1; float v2; };
struct __attribute__((packed)) aBFu0c_Sf_I { unsigned char :0; empty v1; int v2; };
struct __attribute__((packed)) aBFu0c_Sf_Ip { unsigned char :0; empty v1; int * v2; };
struct __attribute__((packed)) aBFu0c_Sf_L { unsigned char :0; empty v1; long long v2; };
struct __attribute__((packed)) aBFu0c_Sf_S { unsigned char :0; empty v1; short v2; };
struct __attribute__((packed)) aBFu0c_Sf_Sf { unsigned char :0; empty v1; empty v2; };
struct __attribute__((packed)) aBFu0c_Sf_Uc { unsigned char :0; empty v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0c_Sf_Ui { unsigned char :0; empty v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0c_Sf_Ul { unsigned char :0; empty v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0c_Sf_Us { unsigned char :0; empty v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0c_Sf_Vp { unsigned char :0; empty v1; void * v2; };
struct __attribute__((packed)) aBFu0c_Uc_Sf { unsigned char :0; unsigned char v1; empty v2; };
struct __attribute__((packed)) aBFu0c_Ui_Sf { unsigned char :0; unsigned int v1; empty v2; };
struct __attribute__((packed)) aBFu0c_Ul_Sf { unsigned char :0; unsigned long long v1; empty v2; };
struct __attribute__((packed)) aBFu0c_Us_Sf { unsigned char :0; unsigned short v1; empty v2; };
struct __attribute__((packed)) aBFu0c_Vp_Sf { unsigned char :0; void * v1; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu0c_Sf { unsigned int :0; unsigned char :0; empty v1; };
struct __attribute__((packed)) aBFu0i_BFu0i_Sf { unsigned int :0; unsigned int :0; empty v1; };
struct __attribute__((packed)) aBFu0i_BFu0ll_Sf { unsigned int :0; unsigned long long :0; empty v1; };
struct __attribute__((packed)) aBFu0i_BFu0s_Sf { unsigned int :0; unsigned short :0; empty v1; };
struct __attribute__((packed)) aBFu0i_BFu15i_Sf { unsigned int :0; unsigned int v1:15; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu15ll_Sf { unsigned int :0; unsigned long long v1:15; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu15s_Sf { unsigned int :0; unsigned short v1:15; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu16i_Sf { unsigned int :0; unsigned int v1:16; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu16ll_Sf { unsigned int :0; unsigned long long v1:16; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu16s_Sf { unsigned int :0; unsigned short v1:16; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu17i_Sf { unsigned int :0; unsigned int v1:17; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu17ll_Sf { unsigned int :0; unsigned long long v1:17; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu1c_Sf { unsigned int :0; unsigned char v1:1; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu1i_Sf { unsigned int :0; unsigned int v1:1; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu1ll_Sf { unsigned int :0; unsigned long long v1:1; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu1s_Sf { unsigned int :0; unsigned short v1:1; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu31i_Sf { unsigned int :0; unsigned int v1:31; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu31ll_Sf { unsigned int :0; unsigned long long v1:31; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu32i_Sf { unsigned int :0; unsigned int v1:32; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu32ll_Sf { unsigned int :0; unsigned long long v1:32; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu33_Sf { unsigned int :0; unsigned long long v1:33; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu7c_Sf { unsigned int :0; unsigned char v1:7; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu7i_Sf { unsigned int :0; unsigned int v1:7; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu7ll_Sf { unsigned int :0; unsigned long long v1:7; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu7s_Sf { unsigned int :0; unsigned short v1:7; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu8c_Sf { unsigned int :0; unsigned char v1:8; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu8i_Sf { unsigned int :0; unsigned int v1:8; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu8ll_Sf { unsigned int :0; unsigned long long v1:8; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu8s_Sf { unsigned int :0; unsigned short v1:8; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu9i_Sf { unsigned int :0; unsigned int v1:9; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu9ll_Sf { unsigned int :0; unsigned long long v1:9; empty v2; };
struct __attribute__((packed)) aBFu0i_BFu9s_Sf { unsigned int :0; unsigned short v1:9; empty v2; };
struct __attribute__((packed)) aBFu0i_C_Sf { unsigned int :0; char v1; empty v2; };
struct __attribute__((packed)) aBFu0i_D_Sf { unsigned int :0; double v1; empty v2; };
struct __attribute__((packed)) aBFu0i_F_Sf { unsigned int :0; float v1; empty v2; };
struct __attribute__((packed)) aBFu0i_I_Sf { unsigned int :0; int v1; empty v2; };
struct __attribute__((packed)) aBFu0i_Ip_Sf { unsigned int :0; int * v1; empty v2; };
struct __attribute__((packed)) aBFu0i_L_Sf { unsigned int :0; long long v1; empty v2; };
struct __attribute__((packed)) aBFu0i_S_Sf { unsigned int :0; short v1; empty v2; };
struct __attribute__((packed)) aBFu0i_Sf { unsigned int :0; empty v1; };
struct __attribute__((packed)) aBFu0i_Sf_BFu0c { unsigned int :0; empty v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0i_Sf_BFu0i { unsigned int :0; empty v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0i_Sf_BFu0ll { unsigned int :0; empty v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0i_Sf_BFu0s { unsigned int :0; empty v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0i_Sf_BFu15i { unsigned int :0; empty v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0i_Sf_BFu15ll { unsigned int :0; empty v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0i_Sf_BFu15s { unsigned int :0; empty v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0i_Sf_BFu16i { unsigned int :0; empty v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0i_Sf_BFu16ll { unsigned int :0; empty v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0i_Sf_BFu16s { unsigned int :0; empty v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0i_Sf_BFu17i { unsigned int :0; empty v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0i_Sf_BFu17ll { unsigned int :0; empty v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0i_Sf_BFu1c { unsigned int :0; empty v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0i_Sf_BFu1i { unsigned int :0; empty v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0i_Sf_BFu1ll { unsigned int :0; empty v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0i_Sf_BFu1s { unsigned int :0; empty v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0i_Sf_BFu31i { unsigned int :0; empty v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0i_Sf_BFu31ll { unsigned int :0; empty v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0i_Sf_BFu32i { unsigned int :0; empty v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0i_Sf_BFu32ll { unsigned int :0; empty v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0i_Sf_BFu33 { unsigned int :0; empty v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0i_Sf_BFu7c { unsigned int :0; empty v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0i_Sf_BFu7i { unsigned int :0; empty v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0i_Sf_BFu7ll { unsigned int :0; empty v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0i_Sf_BFu7s { unsigned int :0; empty v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0i_Sf_BFu8c { unsigned int :0; empty v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0i_Sf_BFu8i { unsigned int :0; empty v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0i_Sf_BFu8ll { unsigned int :0; empty v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0i_Sf_BFu8s { unsigned int :0; empty v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0i_Sf_BFu9i { unsigned int :0; empty v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0i_Sf_BFu9ll { unsigned int :0; empty v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0i_Sf_BFu9s { unsigned int :0; empty v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0i_Sf_C { unsigned int :0; empty v1; char v2; };
struct __attribute__((packed)) aBFu0i_Sf_D { unsigned int :0; empty v1; double v2; };
struct __attribute__((packed)) aBFu0i_Sf_F { unsigned int :0; empty v1; float v2; };
struct __attribute__((packed)) aBFu0i_Sf_I { unsigned int :0; empty v1; int v2; };
struct __attribute__((packed)) aBFu0i_Sf_Ip { unsigned int :0; empty v1; int * v2; };
struct __attribute__((packed)) aBFu0i_Sf_L { unsigned int :0; empty v1; long long v2; };
struct __attribute__((packed)) aBFu0i_Sf_S { unsigned int :0; empty v1; short v2; };
struct __attribute__((packed)) aBFu0i_Sf_Sf { unsigned int :0; empty v1; empty v2; };
struct __attribute__((packed)) aBFu0i_Sf_Uc { unsigned int :0; empty v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0i_Sf_Ui { unsigned int :0; empty v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0i_Sf_Ul { unsigned int :0; empty v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0i_Sf_Us { unsigned int :0; empty v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0i_Sf_Vp { unsigned int :0; empty v1; void * v2; };
struct __attribute__((packed)) aBFu0i_Uc_Sf { unsigned int :0; unsigned char v1; empty v2; };
struct __attribute__((packed)) aBFu0i_Ui_Sf { unsigned int :0; unsigned int v1; empty v2; };
struct __attribute__((packed)) aBFu0i_Ul_Sf { unsigned int :0; unsigned long long v1; empty v2; };
struct __attribute__((packed)) aBFu0i_Us_Sf { unsigned int :0; unsigned short v1; empty v2; };
struct __attribute__((packed)) aBFu0i_Vp_Sf { unsigned int :0; void * v1; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu0c_Sf { unsigned long long :0; unsigned char :0; empty v1; };
struct __attribute__((packed)) aBFu0ll_BFu0i_Sf { unsigned long long :0; unsigned int :0; empty v1; };
struct __attribute__((packed)) aBFu0ll_BFu0ll_Sf { unsigned long long :0; unsigned long long :0; empty v1; };
struct __attribute__((packed)) aBFu0ll_BFu0s_Sf { unsigned long long :0; unsigned short :0; empty v1; };
struct __attribute__((packed)) aBFu0ll_BFu15i_Sf { unsigned long long :0; unsigned int v1:15; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu15ll_Sf { unsigned long long :0; unsigned long long v1:15; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu15s_Sf { unsigned long long :0; unsigned short v1:15; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu16i_Sf { unsigned long long :0; unsigned int v1:16; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu16ll_Sf { unsigned long long :0; unsigned long long v1:16; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu16s_Sf { unsigned long long :0; unsigned short v1:16; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu17i_Sf { unsigned long long :0; unsigned int v1:17; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu17ll_Sf { unsigned long long :0; unsigned long long v1:17; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu1c_Sf { unsigned long long :0; unsigned char v1:1; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu1i_Sf { unsigned long long :0; unsigned int v1:1; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu1ll_Sf { unsigned long long :0; unsigned long long v1:1; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu1s_Sf { unsigned long long :0; unsigned short v1:1; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu31i_Sf { unsigned long long :0; unsigned int v1:31; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu31ll_Sf { unsigned long long :0; unsigned long long v1:31; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu32i_Sf { unsigned long long :0; unsigned int v1:32; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu32ll_Sf { unsigned long long :0; unsigned long long v1:32; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu33_Sf { unsigned long long :0; unsigned long long v1:33; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu7c_Sf { unsigned long long :0; unsigned char v1:7; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu7i_Sf { unsigned long long :0; unsigned int v1:7; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu7ll_Sf { unsigned long long :0; unsigned long long v1:7; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu7s_Sf { unsigned long long :0; unsigned short v1:7; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu8c_Sf { unsigned long long :0; unsigned char v1:8; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu8i_Sf { unsigned long long :0; unsigned int v1:8; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu8ll_Sf { unsigned long long :0; unsigned long long v1:8; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu8s_Sf { unsigned long long :0; unsigned short v1:8; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu9i_Sf { unsigned long long :0; unsigned int v1:9; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu9ll_Sf { unsigned long long :0; unsigned long long v1:9; empty v2; };
struct __attribute__((packed)) aBFu0ll_BFu9s_Sf { unsigned long long :0; unsigned short v1:9; empty v2; };
struct __attribute__((packed)) aBFu0ll_C_Sf { unsigned long long :0; char v1; empty v2; };
struct __attribute__((packed)) aBFu0ll_D_Sf { unsigned long long :0; double v1; empty v2; };
struct __attribute__((packed)) aBFu0ll_F_Sf { unsigned long long :0; float v1; empty v2; };
struct __attribute__((packed)) aBFu0ll_I_Sf { unsigned long long :0; int v1; empty v2; };
struct __attribute__((packed)) aBFu0ll_Ip_Sf { unsigned long long :0; int * v1; empty v2; };
struct __attribute__((packed)) aBFu0ll_L_Sf { unsigned long long :0; long long v1; empty v2; };
struct __attribute__((packed)) aBFu0ll_S_Sf { unsigned long long :0; short v1; empty v2; };
struct __attribute__((packed)) aBFu0ll_Sf { unsigned long long :0; empty v1; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu0c { unsigned long long :0; empty v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu0i { unsigned long long :0; empty v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu0ll { unsigned long long :0; empty v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu0s { unsigned long long :0; empty v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu15i { unsigned long long :0; empty v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu15ll { unsigned long long :0; empty v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu15s { unsigned long long :0; empty v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu16i { unsigned long long :0; empty v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu16ll { unsigned long long :0; empty v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu16s { unsigned long long :0; empty v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu17i { unsigned long long :0; empty v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu17ll { unsigned long long :0; empty v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu1c { unsigned long long :0; empty v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu1i { unsigned long long :0; empty v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu1ll { unsigned long long :0; empty v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu1s { unsigned long long :0; empty v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu31i { unsigned long long :0; empty v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu31ll { unsigned long long :0; empty v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu32i { unsigned long long :0; empty v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu32ll { unsigned long long :0; empty v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu33 { unsigned long long :0; empty v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu7c { unsigned long long :0; empty v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu7i { unsigned long long :0; empty v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu7ll { unsigned long long :0; empty v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu7s { unsigned long long :0; empty v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu8c { unsigned long long :0; empty v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu8i { unsigned long long :0; empty v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu8ll { unsigned long long :0; empty v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu8s { unsigned long long :0; empty v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu9i { unsigned long long :0; empty v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu9ll { unsigned long long :0; empty v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0ll_Sf_BFu9s { unsigned long long :0; empty v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0ll_Sf_C { unsigned long long :0; empty v1; char v2; };
struct __attribute__((packed)) aBFu0ll_Sf_D { unsigned long long :0; empty v1; double v2; };
struct __attribute__((packed)) aBFu0ll_Sf_F { unsigned long long :0; empty v1; float v2; };
struct __attribute__((packed)) aBFu0ll_Sf_I { unsigned long long :0; empty v1; int v2; };
struct __attribute__((packed)) aBFu0ll_Sf_Ip { unsigned long long :0; empty v1; int * v2; };
struct __attribute__((packed)) aBFu0ll_Sf_L { unsigned long long :0; empty v1; long long v2; };
struct __attribute__((packed)) aBFu0ll_Sf_S { unsigned long long :0; empty v1; short v2; };
struct __attribute__((packed)) aBFu0ll_Sf_Sf { unsigned long long :0; empty v1; empty v2; };
struct __attribute__((packed)) aBFu0ll_Sf_Uc { unsigned long long :0; empty v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0ll_Sf_Ui { unsigned long long :0; empty v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0ll_Sf_Ul { unsigned long long :0; empty v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0ll_Sf_Us { unsigned long long :0; empty v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0ll_Sf_Vp { unsigned long long :0; empty v1; void * v2; };
struct __attribute__((packed)) aBFu0ll_Uc_Sf { unsigned long long :0; unsigned char v1; empty v2; };
struct __attribute__((packed)) aBFu0ll_Ui_Sf { unsigned long long :0; unsigned int v1; empty v2; };
struct __attribute__((packed)) aBFu0ll_Ul_Sf { unsigned long long :0; unsigned long long v1; empty v2; };
struct __attribute__((packed)) aBFu0ll_Us_Sf { unsigned long long :0; unsigned short v1; empty v2; };
struct __attribute__((packed)) aBFu0ll_Vp_Sf { unsigned long long :0; void * v1; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu0c_Sf { unsigned short :0; unsigned char :0; empty v1; };
struct __attribute__((packed)) aBFu0s_BFu0i_Sf { unsigned short :0; unsigned int :0; empty v1; };
struct __attribute__((packed)) aBFu0s_BFu0ll_Sf { unsigned short :0; unsigned long long :0; empty v1; };
struct __attribute__((packed)) aBFu0s_BFu0s_Sf { unsigned short :0; unsigned short :0; empty v1; };
struct __attribute__((packed)) aBFu0s_BFu15i_Sf { unsigned short :0; unsigned int v1:15; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu15ll_Sf { unsigned short :0; unsigned long long v1:15; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu15s_Sf { unsigned short :0; unsigned short v1:15; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu16i_Sf { unsigned short :0; unsigned int v1:16; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu16ll_Sf { unsigned short :0; unsigned long long v1:16; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu16s_Sf { unsigned short :0; unsigned short v1:16; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu17i_Sf { unsigned short :0; unsigned int v1:17; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu17ll_Sf { unsigned short :0; unsigned long long v1:17; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu1c_Sf { unsigned short :0; unsigned char v1:1; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu1i_Sf { unsigned short :0; unsigned int v1:1; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu1ll_Sf { unsigned short :0; unsigned long long v1:1; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu1s_Sf { unsigned short :0; unsigned short v1:1; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu31i_Sf { unsigned short :0; unsigned int v1:31; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu31ll_Sf { unsigned short :0; unsigned long long v1:31; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu32i_Sf { unsigned short :0; unsigned int v1:32; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu32ll_Sf { unsigned short :0; unsigned long long v1:32; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu33_Sf { unsigned short :0; unsigned long long v1:33; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu7c_Sf { unsigned short :0; unsigned char v1:7; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu7i_Sf { unsigned short :0; unsigned int v1:7; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu7ll_Sf { unsigned short :0; unsigned long long v1:7; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu7s_Sf { unsigned short :0; unsigned short v1:7; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu8c_Sf { unsigned short :0; unsigned char v1:8; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu8i_Sf { unsigned short :0; unsigned int v1:8; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu8ll_Sf { unsigned short :0; unsigned long long v1:8; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu8s_Sf { unsigned short :0; unsigned short v1:8; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu9i_Sf { unsigned short :0; unsigned int v1:9; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu9ll_Sf { unsigned short :0; unsigned long long v1:9; empty v2; };
struct __attribute__((packed)) aBFu0s_BFu9s_Sf { unsigned short :0; unsigned short v1:9; empty v2; };
struct __attribute__((packed)) aBFu0s_C_Sf { unsigned short :0; char v1; empty v2; };
struct __attribute__((packed)) aBFu0s_D_Sf { unsigned short :0; double v1; empty v2; };
struct __attribute__((packed)) aBFu0s_F_Sf { unsigned short :0; float v1; empty v2; };
struct __attribute__((packed)) aBFu0s_I_Sf { unsigned short :0; int v1; empty v2; };
struct __attribute__((packed)) aBFu0s_Ip_Sf { unsigned short :0; int * v1; empty v2; };
struct __attribute__((packed)) aBFu0s_L_Sf { unsigned short :0; long long v1; empty v2; };
struct __attribute__((packed)) aBFu0s_S_Sf { unsigned short :0; short v1; empty v2; };
struct __attribute__((packed)) aBFu0s_Sf { unsigned short :0; empty v1; };
struct __attribute__((packed)) aBFu0s_Sf_BFu0c { unsigned short :0; empty v1; unsigned char :0; };
struct __attribute__((packed)) aBFu0s_Sf_BFu0i { unsigned short :0; empty v1; unsigned int :0; };
struct __attribute__((packed)) aBFu0s_Sf_BFu0ll { unsigned short :0; empty v1; unsigned long long :0; };
struct __attribute__((packed)) aBFu0s_Sf_BFu0s { unsigned short :0; empty v1; unsigned short :0; };
struct __attribute__((packed)) aBFu0s_Sf_BFu15i { unsigned short :0; empty v1; unsigned int v2:15; };
struct __attribute__((packed)) aBFu0s_Sf_BFu15ll { unsigned short :0; empty v1; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu0s_Sf_BFu15s { unsigned short :0; empty v1; unsigned short v2:15; };
struct __attribute__((packed)) aBFu0s_Sf_BFu16i { unsigned short :0; empty v1; unsigned int v2:16; };
struct __attribute__((packed)) aBFu0s_Sf_BFu16ll { unsigned short :0; empty v1; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu0s_Sf_BFu16s { unsigned short :0; empty v1; unsigned short v2:16; };
struct __attribute__((packed)) aBFu0s_Sf_BFu17i { unsigned short :0; empty v1; unsigned int v2:17; };
struct __attribute__((packed)) aBFu0s_Sf_BFu17ll { unsigned short :0; empty v1; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu0s_Sf_BFu1c { unsigned short :0; empty v1; unsigned char v2:1; };
struct __attribute__((packed)) aBFu0s_Sf_BFu1i { unsigned short :0; empty v1; unsigned int v2:1; };
struct __attribute__((packed)) aBFu0s_Sf_BFu1ll { unsigned short :0; empty v1; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu0s_Sf_BFu1s { unsigned short :0; empty v1; unsigned short v2:1; };
struct __attribute__((packed)) aBFu0s_Sf_BFu31i { unsigned short :0; empty v1; unsigned int v2:31; };
struct __attribute__((packed)) aBFu0s_Sf_BFu31ll { unsigned short :0; empty v1; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu0s_Sf_BFu32i { unsigned short :0; empty v1; unsigned int v2:32; };
struct __attribute__((packed)) aBFu0s_Sf_BFu32ll { unsigned short :0; empty v1; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu0s_Sf_BFu33 { unsigned short :0; empty v1; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu0s_Sf_BFu7c { unsigned short :0; empty v1; unsigned char v2:7; };
struct __attribute__((packed)) aBFu0s_Sf_BFu7i { unsigned short :0; empty v1; unsigned int v2:7; };
struct __attribute__((packed)) aBFu0s_Sf_BFu7ll { unsigned short :0; empty v1; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu0s_Sf_BFu7s { unsigned short :0; empty v1; unsigned short v2:7; };
struct __attribute__((packed)) aBFu0s_Sf_BFu8c { unsigned short :0; empty v1; unsigned char v2:8; };
struct __attribute__((packed)) aBFu0s_Sf_BFu8i { unsigned short :0; empty v1; unsigned int v2:8; };
struct __attribute__((packed)) aBFu0s_Sf_BFu8ll { unsigned short :0; empty v1; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu0s_Sf_BFu8s { unsigned short :0; empty v1; unsigned short v2:8; };
struct __attribute__((packed)) aBFu0s_Sf_BFu9i { unsigned short :0; empty v1; unsigned int v2:9; };
struct __attribute__((packed)) aBFu0s_Sf_BFu9ll { unsigned short :0; empty v1; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu0s_Sf_BFu9s { unsigned short :0; empty v1; unsigned short v2:9; };
struct __attribute__((packed)) aBFu0s_Sf_C { unsigned short :0; empty v1; char v2; };
struct __attribute__((packed)) aBFu0s_Sf_D { unsigned short :0; empty v1; double v2; };
struct __attribute__((packed)) aBFu0s_Sf_F { unsigned short :0; empty v1; float v2; };
struct __attribute__((packed)) aBFu0s_Sf_I { unsigned short :0; empty v1; int v2; };
struct __attribute__((packed)) aBFu0s_Sf_Ip { unsigned short :0; empty v1; int * v2; };
struct __attribute__((packed)) aBFu0s_Sf_L { unsigned short :0; empty v1; long long v2; };
struct __attribute__((packed)) aBFu0s_Sf_S { unsigned short :0; empty v1; short v2; };
struct __attribute__((packed)) aBFu0s_Sf_Sf { unsigned short :0; empty v1; empty v2; };
struct __attribute__((packed)) aBFu0s_Sf_Uc { unsigned short :0; empty v1; unsigned char v2; };
struct __attribute__((packed)) aBFu0s_Sf_Ui { unsigned short :0; empty v1; unsigned int v2; };
struct __attribute__((packed)) aBFu0s_Sf_Ul { unsigned short :0; empty v1; unsigned long long v2; };
struct __attribute__((packed)) aBFu0s_Sf_Us { unsigned short :0; empty v1; unsigned short v2; };
struct __attribute__((packed)) aBFu0s_Sf_Vp { unsigned short :0; empty v1; void * v2; };
struct __attribute__((packed)) aBFu0s_Uc_Sf { unsigned short :0; unsigned char v1; empty v2; };
struct __attribute__((packed)) aBFu0s_Ui_Sf { unsigned short :0; unsigned int v1; empty v2; };
struct __attribute__((packed)) aBFu0s_Ul_Sf { unsigned short :0; unsigned long long v1; empty v2; };
struct __attribute__((packed)) aBFu0s_Us_Sf { unsigned short :0; unsigned short v1; empty v2; };
struct __attribute__((packed)) aBFu0s_Vp_Sf { unsigned short :0; void * v1; empty v2; };
struct __attribute__((packed)) aBFu15i_BFu0c_Sf { unsigned int v1:15; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu15i_BFu0i_Sf { unsigned int v1:15; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu15i_BFu0ll_Sf { unsigned int v1:15; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu15i_BFu0s_Sf { unsigned int v1:15; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu15i_Sf_BFu0c { unsigned int v1:15; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15i_Sf_BFu0i { unsigned int v1:15; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15i_Sf_BFu0ll { unsigned int v1:15; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15i_Sf_BFu0s { unsigned int v1:15; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15ll_BFu0c_Sf { unsigned long long v1:15; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu15ll_BFu0i_Sf { unsigned long long v1:15; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu15ll_BFu0ll_Sf { unsigned long long v1:15; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu15ll_BFu0s_Sf { unsigned long long v1:15; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu0c { unsigned long long v1:15; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu0i { unsigned long long v1:15; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu0ll { unsigned long long v1:15; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu0s { unsigned long long v1:15; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu15s_BFu0c_Sf { unsigned short v1:15; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu15s_BFu0i_Sf { unsigned short v1:15; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu15s_BFu0ll_Sf { unsigned short v1:15; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu15s_BFu0s_Sf { unsigned short v1:15; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu15s_Sf_BFu0c { unsigned short v1:15; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu15s_Sf_BFu0i { unsigned short v1:15; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu15s_Sf_BFu0ll { unsigned short v1:15; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu15s_Sf_BFu0s { unsigned short v1:15; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16i_BFu0c_Sf { unsigned int v1:16; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu16i_BFu0i_Sf { unsigned int v1:16; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu16i_BFu0ll_Sf { unsigned int v1:16; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu16i_BFu0s_Sf { unsigned int v1:16; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu16i_Sf_BFu0c { unsigned int v1:16; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16i_Sf_BFu0i { unsigned int v1:16; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16i_Sf_BFu0ll { unsigned int v1:16; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16i_Sf_BFu0s { unsigned int v1:16; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16ll_BFu0c_Sf { unsigned long long v1:16; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu16ll_BFu0i_Sf { unsigned long long v1:16; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu16ll_BFu0ll_Sf { unsigned long long v1:16; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu16ll_BFu0s_Sf { unsigned long long v1:16; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu0c { unsigned long long v1:16; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu0i { unsigned long long v1:16; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu0ll { unsigned long long v1:16; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu0s { unsigned long long v1:16; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu16s_BFu0c_Sf { unsigned short v1:16; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu16s_BFu0i_Sf { unsigned short v1:16; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu16s_BFu0ll_Sf { unsigned short v1:16; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu16s_BFu0s_Sf { unsigned short v1:16; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu16s_Sf_BFu0c { unsigned short v1:16; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu16s_Sf_BFu0i { unsigned short v1:16; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu16s_Sf_BFu0ll { unsigned short v1:16; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu16s_Sf_BFu0s { unsigned short v1:16; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17i_BFu0c_Sf { unsigned int v1:17; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu17i_BFu0i_Sf { unsigned int v1:17; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu17i_BFu0ll_Sf { unsigned int v1:17; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu17i_BFu0s_Sf { unsigned int v1:17; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu17i_Sf_BFu0c { unsigned int v1:17; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17i_Sf_BFu0i { unsigned int v1:17; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17i_Sf_BFu0ll { unsigned int v1:17; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17i_Sf_BFu0s { unsigned int v1:17; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu17ll_BFu0c_Sf { unsigned long long v1:17; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu17ll_BFu0i_Sf { unsigned long long v1:17; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu17ll_BFu0ll_Sf { unsigned long long v1:17; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu17ll_BFu0s_Sf { unsigned long long v1:17; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu0c { unsigned long long v1:17; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu0i { unsigned long long v1:17; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu0ll { unsigned long long v1:17; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu0s { unsigned long long v1:17; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu1c_BFu0c_Sf { unsigned char v1:1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu1c_BFu0i_Sf { unsigned char v1:1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu1c_BFu0ll_Sf { unsigned char v1:1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu1c_BFu0s_Sf { unsigned char v1:1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu1c_Sf_BFu0c { unsigned char v1:1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu1c_Sf_BFu0i { unsigned char v1:1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu1c_Sf_BFu0ll { unsigned char v1:1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu1c_Sf_BFu0s { unsigned char v1:1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu1i_BFu0c_Sf { unsigned int v1:1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu1i_BFu0i_Sf { unsigned int v1:1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu1i_BFu0ll_Sf { unsigned int v1:1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu1i_BFu0s_Sf { unsigned int v1:1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu1i_Sf_BFu0c { unsigned int v1:1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu1i_Sf_BFu0i { unsigned int v1:1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu1i_Sf_BFu0ll { unsigned int v1:1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu1i_Sf_BFu0s { unsigned int v1:1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu1ll_BFu0c_Sf { unsigned long long v1:1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu1ll_BFu0i_Sf { unsigned long long v1:1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu1ll_BFu0ll_Sf { unsigned long long v1:1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu1ll_BFu0s_Sf { unsigned long long v1:1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu0c { unsigned long long v1:1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu0i { unsigned long long v1:1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu0ll { unsigned long long v1:1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu0s { unsigned long long v1:1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu1s_BFu0c_Sf { unsigned short v1:1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu1s_BFu0i_Sf { unsigned short v1:1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu1s_BFu0ll_Sf { unsigned short v1:1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu1s_BFu0s_Sf { unsigned short v1:1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu1s_Sf_BFu0c { unsigned short v1:1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu1s_Sf_BFu0i { unsigned short v1:1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu1s_Sf_BFu0ll { unsigned short v1:1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu1s_Sf_BFu0s { unsigned short v1:1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu31i_BFu0c_Sf { unsigned int v1:31; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu31i_BFu0i_Sf { unsigned int v1:31; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu31i_BFu0ll_Sf { unsigned int v1:31; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu31i_BFu0s_Sf { unsigned int v1:31; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu31i_Sf_BFu0c { unsigned int v1:31; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu31i_Sf_BFu0i { unsigned int v1:31; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu31i_Sf_BFu0ll { unsigned int v1:31; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu31i_Sf_BFu0s { unsigned int v1:31; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu31ll_BFu0c_Sf { unsigned long long v1:31; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu31ll_BFu0i_Sf { unsigned long long v1:31; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu31ll_BFu0ll_Sf { unsigned long long v1:31; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu31ll_BFu0s_Sf { unsigned long long v1:31; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu0c { unsigned long long v1:31; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu0i { unsigned long long v1:31; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu0ll { unsigned long long v1:31; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu0s { unsigned long long v1:31; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu32i_BFu0c_Sf { unsigned int v1:32; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu32i_BFu0i_Sf { unsigned int v1:32; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu32i_BFu0ll_Sf { unsigned int v1:32; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu32i_BFu0s_Sf { unsigned int v1:32; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu32i_Sf_BFu0c { unsigned int v1:32; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu32i_Sf_BFu0i { unsigned int v1:32; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu32i_Sf_BFu0ll { unsigned int v1:32; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu32i_Sf_BFu0s { unsigned int v1:32; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu32ll_BFu0c_Sf { unsigned long long v1:32; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu32ll_BFu0i_Sf { unsigned long long v1:32; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu32ll_BFu0ll_Sf { unsigned long long v1:32; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu32ll_BFu0s_Sf { unsigned long long v1:32; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu0c { unsigned long long v1:32; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu0i { unsigned long long v1:32; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu0ll { unsigned long long v1:32; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu0s { unsigned long long v1:32; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu33_BFu0c_Sf { unsigned long long v1:33; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu33_BFu0i_Sf { unsigned long long v1:33; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu33_BFu0ll_Sf { unsigned long long v1:33; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu33_BFu0s_Sf { unsigned long long v1:33; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu33_Sf_BFu0c { unsigned long long v1:33; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu33_Sf_BFu0i { unsigned long long v1:33; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu33_Sf_BFu0ll { unsigned long long v1:33; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu33_Sf_BFu0s { unsigned long long v1:33; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu7c_BFu0c_Sf { unsigned char v1:7; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu7c_BFu0i_Sf { unsigned char v1:7; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu7c_BFu0ll_Sf { unsigned char v1:7; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu7c_BFu0s_Sf { unsigned char v1:7; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu7c_Sf_BFu0c { unsigned char v1:7; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu7c_Sf_BFu0i { unsigned char v1:7; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu7c_Sf_BFu0ll { unsigned char v1:7; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu7c_Sf_BFu0s { unsigned char v1:7; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu7i_BFu0c_Sf { unsigned int v1:7; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu7i_BFu0i_Sf { unsigned int v1:7; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu7i_BFu0ll_Sf { unsigned int v1:7; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu7i_BFu0s_Sf { unsigned int v1:7; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu7i_Sf_BFu0c { unsigned int v1:7; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu7i_Sf_BFu0i { unsigned int v1:7; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu7i_Sf_BFu0ll { unsigned int v1:7; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu7i_Sf_BFu0s { unsigned int v1:7; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu7ll_BFu0c_Sf { unsigned long long v1:7; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu7ll_BFu0i_Sf { unsigned long long v1:7; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu7ll_BFu0ll_Sf { unsigned long long v1:7; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu7ll_BFu0s_Sf { unsigned long long v1:7; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu0c { unsigned long long v1:7; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu0i { unsigned long long v1:7; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu0ll { unsigned long long v1:7; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu0s { unsigned long long v1:7; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu7s_BFu0c_Sf { unsigned short v1:7; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu7s_BFu0i_Sf { unsigned short v1:7; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu7s_BFu0ll_Sf { unsigned short v1:7; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu7s_BFu0s_Sf { unsigned short v1:7; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu7s_Sf_BFu0c { unsigned short v1:7; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu7s_Sf_BFu0i { unsigned short v1:7; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu7s_Sf_BFu0ll { unsigned short v1:7; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu7s_Sf_BFu0s { unsigned short v1:7; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu8c_BFu0c_Sf { unsigned char v1:8; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu8c_BFu0i_Sf { unsigned char v1:8; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu8c_BFu0ll_Sf { unsigned char v1:8; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu8c_BFu0s_Sf { unsigned char v1:8; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu8c_Sf_BFu0c { unsigned char v1:8; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu8c_Sf_BFu0i { unsigned char v1:8; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu8c_Sf_BFu0ll { unsigned char v1:8; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu8c_Sf_BFu0s { unsigned char v1:8; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu8i_BFu0c_Sf { unsigned int v1:8; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu8i_BFu0i_Sf { unsigned int v1:8; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu8i_BFu0ll_Sf { unsigned int v1:8; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu8i_BFu0s_Sf { unsigned int v1:8; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu8i_Sf_BFu0c { unsigned int v1:8; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu8i_Sf_BFu0i { unsigned int v1:8; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu8i_Sf_BFu0ll { unsigned int v1:8; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu8i_Sf_BFu0s { unsigned int v1:8; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu8ll_BFu0c_Sf { unsigned long long v1:8; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu8ll_BFu0i_Sf { unsigned long long v1:8; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu8ll_BFu0ll_Sf { unsigned long long v1:8; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu8ll_BFu0s_Sf { unsigned long long v1:8; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu0c { unsigned long long v1:8; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu0i { unsigned long long v1:8; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu0ll { unsigned long long v1:8; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu0s { unsigned long long v1:8; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu8s_BFu0c_Sf { unsigned short v1:8; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu8s_BFu0i_Sf { unsigned short v1:8; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu8s_BFu0ll_Sf { unsigned short v1:8; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu8s_BFu0s_Sf { unsigned short v1:8; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu8s_Sf_BFu0c { unsigned short v1:8; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu8s_Sf_BFu0i { unsigned short v1:8; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu8s_Sf_BFu0ll { unsigned short v1:8; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu8s_Sf_BFu0s { unsigned short v1:8; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu9i_BFu0c_Sf { unsigned int v1:9; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu9i_BFu0i_Sf { unsigned int v1:9; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu9i_BFu0ll_Sf { unsigned int v1:9; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu9i_BFu0s_Sf { unsigned int v1:9; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu9i_Sf_BFu0c { unsigned int v1:9; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu9i_Sf_BFu0i { unsigned int v1:9; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu9i_Sf_BFu0ll { unsigned int v1:9; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu9i_Sf_BFu0s { unsigned int v1:9; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu9ll_BFu0c_Sf { unsigned long long v1:9; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu9ll_BFu0i_Sf { unsigned long long v1:9; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu9ll_BFu0ll_Sf { unsigned long long v1:9; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu9ll_BFu0s_Sf { unsigned long long v1:9; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu0c { unsigned long long v1:9; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu0i { unsigned long long v1:9; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu0ll { unsigned long long v1:9; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu0s { unsigned long long v1:9; empty v2; unsigned short :0; };
struct __attribute__((packed)) aBFu9s_BFu0c_Sf { unsigned short v1:9; unsigned char :0; empty v2; };
struct __attribute__((packed)) aBFu9s_BFu0i_Sf { unsigned short v1:9; unsigned int :0; empty v2; };
struct __attribute__((packed)) aBFu9s_BFu0ll_Sf { unsigned short v1:9; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aBFu9s_BFu0s_Sf { unsigned short v1:9; unsigned short :0; empty v2; };
struct __attribute__((packed)) aBFu9s_Sf_BFu0c { unsigned short v1:9; empty v2; unsigned char :0; };
struct __attribute__((packed)) aBFu9s_Sf_BFu0i { unsigned short v1:9; empty v2; unsigned int :0; };
struct __attribute__((packed)) aBFu9s_Sf_BFu0ll { unsigned short v1:9; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aBFu9s_Sf_BFu0s { unsigned short v1:9; empty v2; unsigned short :0; };
struct __attribute__((packed)) aC_BFu0c_Sf { char v1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aC_BFu0i_Sf { char v1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aC_BFu0ll_Sf { char v1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aC_BFu0s_Sf { char v1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aC_Sf_BFu0c { char v1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aC_Sf_BFu0i { char v1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aC_Sf_BFu0ll { char v1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aC_Sf_BFu0s { char v1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aD_BFu0c_Sf { double v1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aD_BFu0i_Sf { double v1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aD_BFu0ll_Sf { double v1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aD_BFu0s_Sf { double v1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aD_Sf_BFu0c { double v1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aD_Sf_BFu0i { double v1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aD_Sf_BFu0ll { double v1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aD_Sf_BFu0s { double v1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aF_BFu0c_Sf { float v1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aF_BFu0i_Sf { float v1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aF_BFu0ll_Sf { float v1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aF_BFu0s_Sf { float v1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aF_Sf_BFu0c { float v1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aF_Sf_BFu0i { float v1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aF_Sf_BFu0ll { float v1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aF_Sf_BFu0s { float v1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aI_BFu0c_Sf { int v1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aI_BFu0i_Sf { int v1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aI_BFu0ll_Sf { int v1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aI_BFu0s_Sf { int v1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aI_Sf_BFu0c { int v1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aI_Sf_BFu0i { int v1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aI_Sf_BFu0ll { int v1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aI_Sf_BFu0s { int v1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aIp_BFu0c_Sf { int * v1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aIp_BFu0i_Sf { int * v1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aIp_BFu0ll_Sf { int * v1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aIp_BFu0s_Sf { int * v1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aIp_Sf_BFu0c { int * v1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aIp_Sf_BFu0i { int * v1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aIp_Sf_BFu0ll { int * v1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aIp_Sf_BFu0s { int * v1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aL_BFu0c_Sf { long long v1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aL_BFu0i_Sf { long long v1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aL_BFu0ll_Sf { long long v1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aL_BFu0s_Sf { long long v1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aL_Sf_BFu0c { long long v1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aL_Sf_BFu0i { long long v1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aL_Sf_BFu0ll { long long v1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aL_Sf_BFu0s { long long v1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aS_BFu0c_Sf { short v1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aS_BFu0i_Sf { short v1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aS_BFu0ll_Sf { short v1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aS_BFu0s_Sf { short v1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aS_Sf_BFu0c { short v1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aS_Sf_BFu0i { short v1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aS_Sf_BFu0ll { short v1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aS_Sf_BFu0s { short v1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu0c { empty v1; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu0c_BFu0c { empty v1; unsigned char :0; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu0c_BFu0i { empty v1; unsigned char :0; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu0c_BFu0ll { empty v1; unsigned char :0; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu0c_BFu0s { empty v1; unsigned char :0; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu0c_BFu15i { empty v1; unsigned char :0; unsigned int v2:15; };
struct __attribute__((packed)) aSf_BFu0c_BFu15ll { empty v1; unsigned char :0; unsigned long long v2:15; };
struct __attribute__((packed)) aSf_BFu0c_BFu15s { empty v1; unsigned char :0; unsigned short v2:15; };
struct __attribute__((packed)) aSf_BFu0c_BFu16i { empty v1; unsigned char :0; unsigned int v2:16; };
struct __attribute__((packed)) aSf_BFu0c_BFu16ll { empty v1; unsigned char :0; unsigned long long v2:16; };
struct __attribute__((packed)) aSf_BFu0c_BFu16s { empty v1; unsigned char :0; unsigned short v2:16; };
struct __attribute__((packed)) aSf_BFu0c_BFu17i { empty v1; unsigned char :0; unsigned int v2:17; };
struct __attribute__((packed)) aSf_BFu0c_BFu17ll { empty v1; unsigned char :0; unsigned long long v2:17; };
struct __attribute__((packed)) aSf_BFu0c_BFu1c { empty v1; unsigned char :0; unsigned char v2:1; };
struct __attribute__((packed)) aSf_BFu0c_BFu1i { empty v1; unsigned char :0; unsigned int v2:1; };
struct __attribute__((packed)) aSf_BFu0c_BFu1ll { empty v1; unsigned char :0; unsigned long long v2:1; };
struct __attribute__((packed)) aSf_BFu0c_BFu1s { empty v1; unsigned char :0; unsigned short v2:1; };
struct __attribute__((packed)) aSf_BFu0c_BFu31i { empty v1; unsigned char :0; unsigned int v2:31; };
struct __attribute__((packed)) aSf_BFu0c_BFu31ll { empty v1; unsigned char :0; unsigned long long v2:31; };
struct __attribute__((packed)) aSf_BFu0c_BFu32i { empty v1; unsigned char :0; unsigned int v2:32; };
struct __attribute__((packed)) aSf_BFu0c_BFu32ll { empty v1; unsigned char :0; unsigned long long v2:32; };
struct __attribute__((packed)) aSf_BFu0c_BFu33 { empty v1; unsigned char :0; unsigned long long v2:33; };
struct __attribute__((packed)) aSf_BFu0c_BFu7c { empty v1; unsigned char :0; unsigned char v2:7; };
struct __attribute__((packed)) aSf_BFu0c_BFu7i { empty v1; unsigned char :0; unsigned int v2:7; };
struct __attribute__((packed)) aSf_BFu0c_BFu7ll { empty v1; unsigned char :0; unsigned long long v2:7; };
struct __attribute__((packed)) aSf_BFu0c_BFu7s { empty v1; unsigned char :0; unsigned short v2:7; };
struct __attribute__((packed)) aSf_BFu0c_BFu8c { empty v1; unsigned char :0; unsigned char v2:8; };
struct __attribute__((packed)) aSf_BFu0c_BFu8i { empty v1; unsigned char :0; unsigned int v2:8; };
struct __attribute__((packed)) aSf_BFu0c_BFu8ll { empty v1; unsigned char :0; unsigned long long v2:8; };
struct __attribute__((packed)) aSf_BFu0c_BFu8s { empty v1; unsigned char :0; unsigned short v2:8; };
struct __attribute__((packed)) aSf_BFu0c_BFu9i { empty v1; unsigned char :0; unsigned int v2:9; };
struct __attribute__((packed)) aSf_BFu0c_BFu9ll { empty v1; unsigned char :0; unsigned long long v2:9; };
struct __attribute__((packed)) aSf_BFu0c_BFu9s { empty v1; unsigned char :0; unsigned short v2:9; };
struct __attribute__((packed)) aSf_BFu0c_C { empty v1; unsigned char :0; char v2; };
struct __attribute__((packed)) aSf_BFu0c_D { empty v1; unsigned char :0; double v2; };
struct __attribute__((packed)) aSf_BFu0c_F { empty v1; unsigned char :0; float v2; };
struct __attribute__((packed)) aSf_BFu0c_I { empty v1; unsigned char :0; int v2; };
struct __attribute__((packed)) aSf_BFu0c_Ip { empty v1; unsigned char :0; int * v2; };
struct __attribute__((packed)) aSf_BFu0c_L { empty v1; unsigned char :0; long long v2; };
struct __attribute__((packed)) aSf_BFu0c_S { empty v1; unsigned char :0; short v2; };
struct __attribute__((packed)) aSf_BFu0c_Sf { empty v1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aSf_BFu0c_Uc { empty v1; unsigned char :0; unsigned char v2; };
struct __attribute__((packed)) aSf_BFu0c_Ui { empty v1; unsigned char :0; unsigned int v2; };
struct __attribute__((packed)) aSf_BFu0c_Ul { empty v1; unsigned char :0; unsigned long long v2; };
struct __attribute__((packed)) aSf_BFu0c_Us { empty v1; unsigned char :0; unsigned short v2; };
struct __attribute__((packed)) aSf_BFu0c_Vp { empty v1; unsigned char :0; void * v2; };
struct __attribute__((packed)) aSf_BFu0i { empty v1; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu0i_BFu0c { empty v1; unsigned int :0; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu0i_BFu0i { empty v1; unsigned int :0; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu0i_BFu0ll { empty v1; unsigned int :0; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu0i_BFu0s { empty v1; unsigned int :0; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu0i_BFu15i { empty v1; unsigned int :0; unsigned int v2:15; };
struct __attribute__((packed)) aSf_BFu0i_BFu15ll { empty v1; unsigned int :0; unsigned long long v2:15; };
struct __attribute__((packed)) aSf_BFu0i_BFu15s { empty v1; unsigned int :0; unsigned short v2:15; };
struct __attribute__((packed)) aSf_BFu0i_BFu16i { empty v1; unsigned int :0; unsigned int v2:16; };
struct __attribute__((packed)) aSf_BFu0i_BFu16ll { empty v1; unsigned int :0; unsigned long long v2:16; };
struct __attribute__((packed)) aSf_BFu0i_BFu16s { empty v1; unsigned int :0; unsigned short v2:16; };
struct __attribute__((packed)) aSf_BFu0i_BFu17i { empty v1; unsigned int :0; unsigned int v2:17; };
struct __attribute__((packed)) aSf_BFu0i_BFu17ll { empty v1; unsigned int :0; unsigned long long v2:17; };
struct __attribute__((packed)) aSf_BFu0i_BFu1c { empty v1; unsigned int :0; unsigned char v2:1; };
struct __attribute__((packed)) aSf_BFu0i_BFu1i { empty v1; unsigned int :0; unsigned int v2:1; };
struct __attribute__((packed)) aSf_BFu0i_BFu1ll { empty v1; unsigned int :0; unsigned long long v2:1; };
struct __attribute__((packed)) aSf_BFu0i_BFu1s { empty v1; unsigned int :0; unsigned short v2:1; };
struct __attribute__((packed)) aSf_BFu0i_BFu31i { empty v1; unsigned int :0; unsigned int v2:31; };
struct __attribute__((packed)) aSf_BFu0i_BFu31ll { empty v1; unsigned int :0; unsigned long long v2:31; };
struct __attribute__((packed)) aSf_BFu0i_BFu32i { empty v1; unsigned int :0; unsigned int v2:32; };
struct __attribute__((packed)) aSf_BFu0i_BFu32ll { empty v1; unsigned int :0; unsigned long long v2:32; };
struct __attribute__((packed)) aSf_BFu0i_BFu33 { empty v1; unsigned int :0; unsigned long long v2:33; };
struct __attribute__((packed)) aSf_BFu0i_BFu7c { empty v1; unsigned int :0; unsigned char v2:7; };
struct __attribute__((packed)) aSf_BFu0i_BFu7i { empty v1; unsigned int :0; unsigned int v2:7; };
struct __attribute__((packed)) aSf_BFu0i_BFu7ll { empty v1; unsigned int :0; unsigned long long v2:7; };
struct __attribute__((packed)) aSf_BFu0i_BFu7s { empty v1; unsigned int :0; unsigned short v2:7; };
struct __attribute__((packed)) aSf_BFu0i_BFu8c { empty v1; unsigned int :0; unsigned char v2:8; };
struct __attribute__((packed)) aSf_BFu0i_BFu8i { empty v1; unsigned int :0; unsigned int v2:8; };
struct __attribute__((packed)) aSf_BFu0i_BFu8ll { empty v1; unsigned int :0; unsigned long long v2:8; };
struct __attribute__((packed)) aSf_BFu0i_BFu8s { empty v1; unsigned int :0; unsigned short v2:8; };
struct __attribute__((packed)) aSf_BFu0i_BFu9i { empty v1; unsigned int :0; unsigned int v2:9; };
struct __attribute__((packed)) aSf_BFu0i_BFu9ll { empty v1; unsigned int :0; unsigned long long v2:9; };
struct __attribute__((packed)) aSf_BFu0i_BFu9s { empty v1; unsigned int :0; unsigned short v2:9; };
struct __attribute__((packed)) aSf_BFu0i_C { empty v1; unsigned int :0; char v2; };
struct __attribute__((packed)) aSf_BFu0i_D { empty v1; unsigned int :0; double v2; };
struct __attribute__((packed)) aSf_BFu0i_F { empty v1; unsigned int :0; float v2; };
struct __attribute__((packed)) aSf_BFu0i_I { empty v1; unsigned int :0; int v2; };
struct __attribute__((packed)) aSf_BFu0i_Ip { empty v1; unsigned int :0; int * v2; };
struct __attribute__((packed)) aSf_BFu0i_L { empty v1; unsigned int :0; long long v2; };
struct __attribute__((packed)) aSf_BFu0i_S { empty v1; unsigned int :0; short v2; };
struct __attribute__((packed)) aSf_BFu0i_Sf { empty v1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aSf_BFu0i_Uc { empty v1; unsigned int :0; unsigned char v2; };
struct __attribute__((packed)) aSf_BFu0i_Ui { empty v1; unsigned int :0; unsigned int v2; };
struct __attribute__((packed)) aSf_BFu0i_Ul { empty v1; unsigned int :0; unsigned long long v2; };
struct __attribute__((packed)) aSf_BFu0i_Us { empty v1; unsigned int :0; unsigned short v2; };
struct __attribute__((packed)) aSf_BFu0i_Vp { empty v1; unsigned int :0; void * v2; };
struct __attribute__((packed)) aSf_BFu0ll { empty v1; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu0ll_BFu0c { empty v1; unsigned long long :0; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu0ll_BFu0i { empty v1; unsigned long long :0; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu0ll_BFu0ll { empty v1; unsigned long long :0; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu0ll_BFu0s { empty v1; unsigned long long :0; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu0ll_BFu15i { empty v1; unsigned long long :0; unsigned int v2:15; };
struct __attribute__((packed)) aSf_BFu0ll_BFu15ll { empty v1; unsigned long long :0; unsigned long long v2:15; };
struct __attribute__((packed)) aSf_BFu0ll_BFu15s { empty v1; unsigned long long :0; unsigned short v2:15; };
struct __attribute__((packed)) aSf_BFu0ll_BFu16i { empty v1; unsigned long long :0; unsigned int v2:16; };
struct __attribute__((packed)) aSf_BFu0ll_BFu16ll { empty v1; unsigned long long :0; unsigned long long v2:16; };
struct __attribute__((packed)) aSf_BFu0ll_BFu16s { empty v1; unsigned long long :0; unsigned short v2:16; };
struct __attribute__((packed)) aSf_BFu0ll_BFu17i { empty v1; unsigned long long :0; unsigned int v2:17; };
struct __attribute__((packed)) aSf_BFu0ll_BFu17ll { empty v1; unsigned long long :0; unsigned long long v2:17; };
struct __attribute__((packed)) aSf_BFu0ll_BFu1c { empty v1; unsigned long long :0; unsigned char v2:1; };
struct __attribute__((packed)) aSf_BFu0ll_BFu1i { empty v1; unsigned long long :0; unsigned int v2:1; };
struct __attribute__((packed)) aSf_BFu0ll_BFu1ll { empty v1; unsigned long long :0; unsigned long long v2:1; };
struct __attribute__((packed)) aSf_BFu0ll_BFu1s { empty v1; unsigned long long :0; unsigned short v2:1; };
struct __attribute__((packed)) aSf_BFu0ll_BFu31i { empty v1; unsigned long long :0; unsigned int v2:31; };
struct __attribute__((packed)) aSf_BFu0ll_BFu31ll { empty v1; unsigned long long :0; unsigned long long v2:31; };
struct __attribute__((packed)) aSf_BFu0ll_BFu32i { empty v1; unsigned long long :0; unsigned int v2:32; };
struct __attribute__((packed)) aSf_BFu0ll_BFu32ll { empty v1; unsigned long long :0; unsigned long long v2:32; };
struct __attribute__((packed)) aSf_BFu0ll_BFu33 { empty v1; unsigned long long :0; unsigned long long v2:33; };
struct __attribute__((packed)) aSf_BFu0ll_BFu7c { empty v1; unsigned long long :0; unsigned char v2:7; };
struct __attribute__((packed)) aSf_BFu0ll_BFu7i { empty v1; unsigned long long :0; unsigned int v2:7; };
struct __attribute__((packed)) aSf_BFu0ll_BFu7ll { empty v1; unsigned long long :0; unsigned long long v2:7; };
struct __attribute__((packed)) aSf_BFu0ll_BFu7s { empty v1; unsigned long long :0; unsigned short v2:7; };
struct __attribute__((packed)) aSf_BFu0ll_BFu8c { empty v1; unsigned long long :0; unsigned char v2:8; };
struct __attribute__((packed)) aSf_BFu0ll_BFu8i { empty v1; unsigned long long :0; unsigned int v2:8; };
struct __attribute__((packed)) aSf_BFu0ll_BFu8ll { empty v1; unsigned long long :0; unsigned long long v2:8; };
struct __attribute__((packed)) aSf_BFu0ll_BFu8s { empty v1; unsigned long long :0; unsigned short v2:8; };
struct __attribute__((packed)) aSf_BFu0ll_BFu9i { empty v1; unsigned long long :0; unsigned int v2:9; };
struct __attribute__((packed)) aSf_BFu0ll_BFu9ll { empty v1; unsigned long long :0; unsigned long long v2:9; };
struct __attribute__((packed)) aSf_BFu0ll_BFu9s { empty v1; unsigned long long :0; unsigned short v2:9; };
struct __attribute__((packed)) aSf_BFu0ll_C { empty v1; unsigned long long :0; char v2; };
struct __attribute__((packed)) aSf_BFu0ll_D { empty v1; unsigned long long :0; double v2; };
struct __attribute__((packed)) aSf_BFu0ll_F { empty v1; unsigned long long :0; float v2; };
struct __attribute__((packed)) aSf_BFu0ll_I { empty v1; unsigned long long :0; int v2; };
struct __attribute__((packed)) aSf_BFu0ll_Ip { empty v1; unsigned long long :0; int * v2; };
struct __attribute__((packed)) aSf_BFu0ll_L { empty v1; unsigned long long :0; long long v2; };
struct __attribute__((packed)) aSf_BFu0ll_S { empty v1; unsigned long long :0; short v2; };
struct __attribute__((packed)) aSf_BFu0ll_Sf { empty v1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aSf_BFu0ll_Uc { empty v1; unsigned long long :0; unsigned char v2; };
struct __attribute__((packed)) aSf_BFu0ll_Ui { empty v1; unsigned long long :0; unsigned int v2; };
struct __attribute__((packed)) aSf_BFu0ll_Ul { empty v1; unsigned long long :0; unsigned long long v2; };
struct __attribute__((packed)) aSf_BFu0ll_Us { empty v1; unsigned long long :0; unsigned short v2; };
struct __attribute__((packed)) aSf_BFu0ll_Vp { empty v1; unsigned long long :0; void * v2; };
struct __attribute__((packed)) aSf_BFu0s { empty v1; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu0s_BFu0c { empty v1; unsigned short :0; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu0s_BFu0i { empty v1; unsigned short :0; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu0s_BFu0ll { empty v1; unsigned short :0; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu0s_BFu0s { empty v1; unsigned short :0; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu0s_BFu15i { empty v1; unsigned short :0; unsigned int v2:15; };
struct __attribute__((packed)) aSf_BFu0s_BFu15ll { empty v1; unsigned short :0; unsigned long long v2:15; };
struct __attribute__((packed)) aSf_BFu0s_BFu15s { empty v1; unsigned short :0; unsigned short v2:15; };
struct __attribute__((packed)) aSf_BFu0s_BFu16i { empty v1; unsigned short :0; unsigned int v2:16; };
struct __attribute__((packed)) aSf_BFu0s_BFu16ll { empty v1; unsigned short :0; unsigned long long v2:16; };
struct __attribute__((packed)) aSf_BFu0s_BFu16s { empty v1; unsigned short :0; unsigned short v2:16; };
struct __attribute__((packed)) aSf_BFu0s_BFu17i { empty v1; unsigned short :0; unsigned int v2:17; };
struct __attribute__((packed)) aSf_BFu0s_BFu17ll { empty v1; unsigned short :0; unsigned long long v2:17; };
struct __attribute__((packed)) aSf_BFu0s_BFu1c { empty v1; unsigned short :0; unsigned char v2:1; };
struct __attribute__((packed)) aSf_BFu0s_BFu1i { empty v1; unsigned short :0; unsigned int v2:1; };
struct __attribute__((packed)) aSf_BFu0s_BFu1ll { empty v1; unsigned short :0; unsigned long long v2:1; };
struct __attribute__((packed)) aSf_BFu0s_BFu1s { empty v1; unsigned short :0; unsigned short v2:1; };
struct __attribute__((packed)) aSf_BFu0s_BFu31i { empty v1; unsigned short :0; unsigned int v2:31; };
struct __attribute__((packed)) aSf_BFu0s_BFu31ll { empty v1; unsigned short :0; unsigned long long v2:31; };
struct __attribute__((packed)) aSf_BFu0s_BFu32i { empty v1; unsigned short :0; unsigned int v2:32; };
struct __attribute__((packed)) aSf_BFu0s_BFu32ll { empty v1; unsigned short :0; unsigned long long v2:32; };
struct __attribute__((packed)) aSf_BFu0s_BFu33 { empty v1; unsigned short :0; unsigned long long v2:33; };
struct __attribute__((packed)) aSf_BFu0s_BFu7c { empty v1; unsigned short :0; unsigned char v2:7; };
struct __attribute__((packed)) aSf_BFu0s_BFu7i { empty v1; unsigned short :0; unsigned int v2:7; };
struct __attribute__((packed)) aSf_BFu0s_BFu7ll { empty v1; unsigned short :0; unsigned long long v2:7; };
struct __attribute__((packed)) aSf_BFu0s_BFu7s { empty v1; unsigned short :0; unsigned short v2:7; };
struct __attribute__((packed)) aSf_BFu0s_BFu8c { empty v1; unsigned short :0; unsigned char v2:8; };
struct __attribute__((packed)) aSf_BFu0s_BFu8i { empty v1; unsigned short :0; unsigned int v2:8; };
struct __attribute__((packed)) aSf_BFu0s_BFu8ll { empty v1; unsigned short :0; unsigned long long v2:8; };
struct __attribute__((packed)) aSf_BFu0s_BFu8s { empty v1; unsigned short :0; unsigned short v2:8; };
struct __attribute__((packed)) aSf_BFu0s_BFu9i { empty v1; unsigned short :0; unsigned int v2:9; };
struct __attribute__((packed)) aSf_BFu0s_BFu9ll { empty v1; unsigned short :0; unsigned long long v2:9; };
struct __attribute__((packed)) aSf_BFu0s_BFu9s { empty v1; unsigned short :0; unsigned short v2:9; };
struct __attribute__((packed)) aSf_BFu0s_C { empty v1; unsigned short :0; char v2; };
struct __attribute__((packed)) aSf_BFu0s_D { empty v1; unsigned short :0; double v2; };
struct __attribute__((packed)) aSf_BFu0s_F { empty v1; unsigned short :0; float v2; };
struct __attribute__((packed)) aSf_BFu0s_I { empty v1; unsigned short :0; int v2; };
struct __attribute__((packed)) aSf_BFu0s_Ip { empty v1; unsigned short :0; int * v2; };
struct __attribute__((packed)) aSf_BFu0s_L { empty v1; unsigned short :0; long long v2; };
struct __attribute__((packed)) aSf_BFu0s_S { empty v1; unsigned short :0; short v2; };
struct __attribute__((packed)) aSf_BFu0s_Sf { empty v1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aSf_BFu0s_Uc { empty v1; unsigned short :0; unsigned char v2; };
struct __attribute__((packed)) aSf_BFu0s_Ui { empty v1; unsigned short :0; unsigned int v2; };
struct __attribute__((packed)) aSf_BFu0s_Ul { empty v1; unsigned short :0; unsigned long long v2; };
struct __attribute__((packed)) aSf_BFu0s_Us { empty v1; unsigned short :0; unsigned short v2; };
struct __attribute__((packed)) aSf_BFu0s_Vp { empty v1; unsigned short :0; void * v2; };
struct __attribute__((packed)) aSf_BFu15i_BFu0c { empty v1; unsigned int v2:15; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu15i_BFu0i { empty v1; unsigned int v2:15; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu15i_BFu0ll { empty v1; unsigned int v2:15; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu15i_BFu0s { empty v1; unsigned int v2:15; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu15ll_BFu0c { empty v1; unsigned long long v2:15; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu15ll_BFu0i { empty v1; unsigned long long v2:15; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu15ll_BFu0ll { empty v1; unsigned long long v2:15; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu15ll_BFu0s { empty v1; unsigned long long v2:15; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu15s_BFu0c { empty v1; unsigned short v2:15; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu15s_BFu0i { empty v1; unsigned short v2:15; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu15s_BFu0ll { empty v1; unsigned short v2:15; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu15s_BFu0s { empty v1; unsigned short v2:15; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu16i_BFu0c { empty v1; unsigned int v2:16; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu16i_BFu0i { empty v1; unsigned int v2:16; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu16i_BFu0ll { empty v1; unsigned int v2:16; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu16i_BFu0s { empty v1; unsigned int v2:16; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu16ll_BFu0c { empty v1; unsigned long long v2:16; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu16ll_BFu0i { empty v1; unsigned long long v2:16; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu16ll_BFu0ll { empty v1; unsigned long long v2:16; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu16ll_BFu0s { empty v1; unsigned long long v2:16; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu16s_BFu0c { empty v1; unsigned short v2:16; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu16s_BFu0i { empty v1; unsigned short v2:16; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu16s_BFu0ll { empty v1; unsigned short v2:16; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu16s_BFu0s { empty v1; unsigned short v2:16; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu17i_BFu0c { empty v1; unsigned int v2:17; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu17i_BFu0i { empty v1; unsigned int v2:17; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu17i_BFu0ll { empty v1; unsigned int v2:17; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu17i_BFu0s { empty v1; unsigned int v2:17; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu17ll_BFu0c { empty v1; unsigned long long v2:17; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu17ll_BFu0i { empty v1; unsigned long long v2:17; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu17ll_BFu0ll { empty v1; unsigned long long v2:17; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu17ll_BFu0s { empty v1; unsigned long long v2:17; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu1c_BFu0c { empty v1; unsigned char v2:1; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu1c_BFu0i { empty v1; unsigned char v2:1; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu1c_BFu0ll { empty v1; unsigned char v2:1; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu1c_BFu0s { empty v1; unsigned char v2:1; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu1i_BFu0c { empty v1; unsigned int v2:1; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu1i_BFu0i { empty v1; unsigned int v2:1; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu1i_BFu0ll { empty v1; unsigned int v2:1; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu1i_BFu0s { empty v1; unsigned int v2:1; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu1ll_BFu0c { empty v1; unsigned long long v2:1; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu1ll_BFu0i { empty v1; unsigned long long v2:1; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu1ll_BFu0ll { empty v1; unsigned long long v2:1; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu1ll_BFu0s { empty v1; unsigned long long v2:1; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu1s_BFu0c { empty v1; unsigned short v2:1; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu1s_BFu0i { empty v1; unsigned short v2:1; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu1s_BFu0ll { empty v1; unsigned short v2:1; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu1s_BFu0s { empty v1; unsigned short v2:1; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu31i_BFu0c { empty v1; unsigned int v2:31; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu31i_BFu0i { empty v1; unsigned int v2:31; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu31i_BFu0ll { empty v1; unsigned int v2:31; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu31i_BFu0s { empty v1; unsigned int v2:31; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu31ll_BFu0c { empty v1; unsigned long long v2:31; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu31ll_BFu0i { empty v1; unsigned long long v2:31; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu31ll_BFu0ll { empty v1; unsigned long long v2:31; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu31ll_BFu0s { empty v1; unsigned long long v2:31; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu32i_BFu0c { empty v1; unsigned int v2:32; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu32i_BFu0i { empty v1; unsigned int v2:32; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu32i_BFu0ll { empty v1; unsigned int v2:32; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu32i_BFu0s { empty v1; unsigned int v2:32; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu32ll_BFu0c { empty v1; unsigned long long v2:32; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu32ll_BFu0i { empty v1; unsigned long long v2:32; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu32ll_BFu0ll { empty v1; unsigned long long v2:32; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu32ll_BFu0s { empty v1; unsigned long long v2:32; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu33_BFu0c { empty v1; unsigned long long v2:33; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu33_BFu0i { empty v1; unsigned long long v2:33; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu33_BFu0ll { empty v1; unsigned long long v2:33; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu33_BFu0s { empty v1; unsigned long long v2:33; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu7c_BFu0c { empty v1; unsigned char v2:7; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu7c_BFu0i { empty v1; unsigned char v2:7; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu7c_BFu0ll { empty v1; unsigned char v2:7; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu7c_BFu0s { empty v1; unsigned char v2:7; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu7i_BFu0c { empty v1; unsigned int v2:7; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu7i_BFu0i { empty v1; unsigned int v2:7; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu7i_BFu0ll { empty v1; unsigned int v2:7; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu7i_BFu0s { empty v1; unsigned int v2:7; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu7ll_BFu0c { empty v1; unsigned long long v2:7; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu7ll_BFu0i { empty v1; unsigned long long v2:7; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu7ll_BFu0ll { empty v1; unsigned long long v2:7; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu7ll_BFu0s { empty v1; unsigned long long v2:7; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu7s_BFu0c { empty v1; unsigned short v2:7; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu7s_BFu0i { empty v1; unsigned short v2:7; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu7s_BFu0ll { empty v1; unsigned short v2:7; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu7s_BFu0s { empty v1; unsigned short v2:7; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu8c_BFu0c { empty v1; unsigned char v2:8; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu8c_BFu0i { empty v1; unsigned char v2:8; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu8c_BFu0ll { empty v1; unsigned char v2:8; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu8c_BFu0s { empty v1; unsigned char v2:8; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu8i_BFu0c { empty v1; unsigned int v2:8; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu8i_BFu0i { empty v1; unsigned int v2:8; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu8i_BFu0ll { empty v1; unsigned int v2:8; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu8i_BFu0s { empty v1; unsigned int v2:8; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu8ll_BFu0c { empty v1; unsigned long long v2:8; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu8ll_BFu0i { empty v1; unsigned long long v2:8; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu8ll_BFu0ll { empty v1; unsigned long long v2:8; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu8ll_BFu0s { empty v1; unsigned long long v2:8; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu8s_BFu0c { empty v1; unsigned short v2:8; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu8s_BFu0i { empty v1; unsigned short v2:8; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu8s_BFu0ll { empty v1; unsigned short v2:8; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu8s_BFu0s { empty v1; unsigned short v2:8; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu9i_BFu0c { empty v1; unsigned int v2:9; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu9i_BFu0i { empty v1; unsigned int v2:9; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu9i_BFu0ll { empty v1; unsigned int v2:9; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu9i_BFu0s { empty v1; unsigned int v2:9; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu9ll_BFu0c { empty v1; unsigned long long v2:9; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu9ll_BFu0i { empty v1; unsigned long long v2:9; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu9ll_BFu0ll { empty v1; unsigned long long v2:9; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu9ll_BFu0s { empty v1; unsigned long long v2:9; unsigned short :0; };
struct __attribute__((packed)) aSf_BFu9s_BFu0c { empty v1; unsigned short v2:9; unsigned char :0; };
struct __attribute__((packed)) aSf_BFu9s_BFu0i { empty v1; unsigned short v2:9; unsigned int :0; };
struct __attribute__((packed)) aSf_BFu9s_BFu0ll { empty v1; unsigned short v2:9; unsigned long long :0; };
struct __attribute__((packed)) aSf_BFu9s_BFu0s { empty v1; unsigned short v2:9; unsigned short :0; };
struct __attribute__((packed)) aSf_C_BFu0c { empty v1; char v2; unsigned char :0; };
struct __attribute__((packed)) aSf_C_BFu0i { empty v1; char v2; unsigned int :0; };
struct __attribute__((packed)) aSf_C_BFu0ll { empty v1; char v2; unsigned long long :0; };
struct __attribute__((packed)) aSf_C_BFu0s { empty v1; char v2; unsigned short :0; };
struct __attribute__((packed)) aSf_D_BFu0c { empty v1; double v2; unsigned char :0; };
struct __attribute__((packed)) aSf_D_BFu0i { empty v1; double v2; unsigned int :0; };
struct __attribute__((packed)) aSf_D_BFu0ll { empty v1; double v2; unsigned long long :0; };
struct __attribute__((packed)) aSf_D_BFu0s { empty v1; double v2; unsigned short :0; };
struct __attribute__((packed)) aSf_F_BFu0c { empty v1; float v2; unsigned char :0; };
struct __attribute__((packed)) aSf_F_BFu0i { empty v1; float v2; unsigned int :0; };
struct __attribute__((packed)) aSf_F_BFu0ll { empty v1; float v2; unsigned long long :0; };
struct __attribute__((packed)) aSf_F_BFu0s { empty v1; float v2; unsigned short :0; };
struct __attribute__((packed)) aSf_I_BFu0c { empty v1; int v2; unsigned char :0; };
struct __attribute__((packed)) aSf_I_BFu0i { empty v1; int v2; unsigned int :0; };
struct __attribute__((packed)) aSf_I_BFu0ll { empty v1; int v2; unsigned long long :0; };
struct __attribute__((packed)) aSf_I_BFu0s { empty v1; int v2; unsigned short :0; };
struct __attribute__((packed)) aSf_Ip_BFu0c { empty v1; int * v2; unsigned char :0; };
struct __attribute__((packed)) aSf_Ip_BFu0i { empty v1; int * v2; unsigned int :0; };
struct __attribute__((packed)) aSf_Ip_BFu0ll { empty v1; int * v2; unsigned long long :0; };
struct __attribute__((packed)) aSf_Ip_BFu0s { empty v1; int * v2; unsigned short :0; };
struct __attribute__((packed)) aSf_L_BFu0c { empty v1; long long v2; unsigned char :0; };
struct __attribute__((packed)) aSf_L_BFu0i { empty v1; long long v2; unsigned int :0; };
struct __attribute__((packed)) aSf_L_BFu0ll { empty v1; long long v2; unsigned long long :0; };
struct __attribute__((packed)) aSf_L_BFu0s { empty v1; long long v2; unsigned short :0; };
struct __attribute__((packed)) aSf_S_BFu0c { empty v1; short v2; unsigned char :0; };
struct __attribute__((packed)) aSf_S_BFu0i { empty v1; short v2; unsigned int :0; };
struct __attribute__((packed)) aSf_S_BFu0ll { empty v1; short v2; unsigned long long :0; };
struct __attribute__((packed)) aSf_S_BFu0s { empty v1; short v2; unsigned short :0; };
struct __attribute__((packed)) aSf_Sf_BFu0c { empty v1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aSf_Sf_BFu0i { empty v1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aSf_Sf_BFu0ll { empty v1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aSf_Sf_BFu0s { empty v1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aSf_Uc_BFu0c { empty v1; unsigned char v2; unsigned char :0; };
struct __attribute__((packed)) aSf_Uc_BFu0i { empty v1; unsigned char v2; unsigned int :0; };
struct __attribute__((packed)) aSf_Uc_BFu0ll { empty v1; unsigned char v2; unsigned long long :0; };
struct __attribute__((packed)) aSf_Uc_BFu0s { empty v1; unsigned char v2; unsigned short :0; };
struct __attribute__((packed)) aSf_Ui_BFu0c { empty v1; unsigned int v2; unsigned char :0; };
struct __attribute__((packed)) aSf_Ui_BFu0i { empty v1; unsigned int v2; unsigned int :0; };
struct __attribute__((packed)) aSf_Ui_BFu0ll { empty v1; unsigned int v2; unsigned long long :0; };
struct __attribute__((packed)) aSf_Ui_BFu0s { empty v1; unsigned int v2; unsigned short :0; };
struct __attribute__((packed)) aSf_Ul_BFu0c { empty v1; unsigned long long v2; unsigned char :0; };
struct __attribute__((packed)) aSf_Ul_BFu0i { empty v1; unsigned long long v2; unsigned int :0; };
struct __attribute__((packed)) aSf_Ul_BFu0ll { empty v1; unsigned long long v2; unsigned long long :0; };
struct __attribute__((packed)) aSf_Ul_BFu0s { empty v1; unsigned long long v2; unsigned short :0; };
struct __attribute__((packed)) aSf_Us_BFu0c { empty v1; unsigned short v2; unsigned char :0; };
struct __attribute__((packed)) aSf_Us_BFu0i { empty v1; unsigned short v2; unsigned int :0; };
struct __attribute__((packed)) aSf_Us_BFu0ll { empty v1; unsigned short v2; unsigned long long :0; };
struct __attribute__((packed)) aSf_Us_BFu0s { empty v1; unsigned short v2; unsigned short :0; };
struct __attribute__((packed)) aSf_Vp_BFu0c { empty v1; void * v2; unsigned char :0; };
struct __attribute__((packed)) aSf_Vp_BFu0i { empty v1; void * v2; unsigned int :0; };
struct __attribute__((packed)) aSf_Vp_BFu0ll { empty v1; void * v2; unsigned long long :0; };
struct __attribute__((packed)) aSf_Vp_BFu0s { empty v1; void * v2; unsigned short :0; };
struct __attribute__((packed)) aUc_BFu0c_Sf { unsigned char v1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aUc_BFu0i_Sf { unsigned char v1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aUc_BFu0ll_Sf { unsigned char v1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aUc_BFu0s_Sf { unsigned char v1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aUc_Sf_BFu0c { unsigned char v1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aUc_Sf_BFu0i { unsigned char v1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aUc_Sf_BFu0ll { unsigned char v1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aUc_Sf_BFu0s { unsigned char v1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aUi_BFu0c_Sf { unsigned int v1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aUi_BFu0i_Sf { unsigned int v1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aUi_BFu0ll_Sf { unsigned int v1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aUi_BFu0s_Sf { unsigned int v1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aUi_Sf_BFu0c { unsigned int v1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aUi_Sf_BFu0i { unsigned int v1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aUi_Sf_BFu0ll { unsigned int v1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aUi_Sf_BFu0s { unsigned int v1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aUl_BFu0c_Sf { unsigned long long v1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aUl_BFu0i_Sf { unsigned long long v1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aUl_BFu0ll_Sf { unsigned long long v1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aUl_BFu0s_Sf { unsigned long long v1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aUl_Sf_BFu0c { unsigned long long v1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aUl_Sf_BFu0i { unsigned long long v1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aUl_Sf_BFu0ll { unsigned long long v1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aUl_Sf_BFu0s { unsigned long long v1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aUs_BFu0c_Sf { unsigned short v1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aUs_BFu0i_Sf { unsigned short v1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aUs_BFu0ll_Sf { unsigned short v1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aUs_BFu0s_Sf { unsigned short v1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aUs_Sf_BFu0c { unsigned short v1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aUs_Sf_BFu0i { unsigned short v1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aUs_Sf_BFu0ll { unsigned short v1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aUs_Sf_BFu0s { unsigned short v1; empty v2; unsigned short :0; };
struct __attribute__((packed)) aVp_BFu0c_Sf { void * v1; unsigned char :0; empty v2; };
struct __attribute__((packed)) aVp_BFu0i_Sf { void * v1; unsigned int :0; empty v2; };
struct __attribute__((packed)) aVp_BFu0ll_Sf { void * v1; unsigned long long :0; empty v2; };
struct __attribute__((packed)) aVp_BFu0s_Sf { void * v1; unsigned short :0; empty v2; };
struct __attribute__((packed)) aVp_Sf_BFu0c { void * v1; empty v2; unsigned char :0; };
struct __attribute__((packed)) aVp_Sf_BFu0i { void * v1; empty v2; unsigned int :0; };
struct __attribute__((packed)) aVp_Sf_BFu0ll { void * v1; empty v2; unsigned long long :0; };
struct __attribute__((packed)) aVp_Sf_BFu0s { void * v1; empty v2; unsigned short :0; };
#pragma pack(1)
struct BFu0c_BFu0c_Sf { unsigned char :0; unsigned char :0; empty v1; };
struct BFu0c_BFu0i_Sf { unsigned char :0; unsigned int :0; empty v1; };
struct BFu0c_BFu0ll_Sf { unsigned char :0; unsigned long long :0; empty v1; };
struct BFu0c_BFu0s_Sf { unsigned char :0; unsigned short :0; empty v1; };
struct BFu0c_BFu15i_Sf { unsigned char :0; unsigned int v1:15; empty v2; };
struct BFu0c_BFu15ll_Sf { unsigned char :0; unsigned long long v1:15; empty v2; };
struct BFu0c_BFu15s_Sf { unsigned char :0; unsigned short v1:15; empty v2; };
struct BFu0c_BFu16i_Sf { unsigned char :0; unsigned int v1:16; empty v2; };
struct BFu0c_BFu16ll_Sf { unsigned char :0; unsigned long long v1:16; empty v2; };
struct BFu0c_BFu16s_Sf { unsigned char :0; unsigned short v1:16; empty v2; };
struct BFu0c_BFu17i_Sf { unsigned char :0; unsigned int v1:17; empty v2; };
struct BFu0c_BFu17ll_Sf { unsigned char :0; unsigned long long v1:17; empty v2; };
struct BFu0c_BFu1c_Sf { unsigned char :0; unsigned char v1:1; empty v2; };
struct BFu0c_BFu1i_Sf { unsigned char :0; unsigned int v1:1; empty v2; };
struct BFu0c_BFu1ll_Sf { unsigned char :0; unsigned long long v1:1; empty v2; };
struct BFu0c_BFu1s_Sf { unsigned char :0; unsigned short v1:1; empty v2; };
struct BFu0c_BFu31i_Sf { unsigned char :0; unsigned int v1:31; empty v2; };
struct BFu0c_BFu31ll_Sf { unsigned char :0; unsigned long long v1:31; empty v2; };
struct BFu0c_BFu32i_Sf { unsigned char :0; unsigned int v1:32; empty v2; };
struct BFu0c_BFu32ll_Sf { unsigned char :0; unsigned long long v1:32; empty v2; };
struct BFu0c_BFu33_Sf { unsigned char :0; unsigned long long v1:33; empty v2; };
struct BFu0c_BFu7c_Sf { unsigned char :0; unsigned char v1:7; empty v2; };
struct BFu0c_BFu7i_Sf { unsigned char :0; unsigned int v1:7; empty v2; };
struct BFu0c_BFu7ll_Sf { unsigned char :0; unsigned long long v1:7; empty v2; };
struct BFu0c_BFu7s_Sf { unsigned char :0; unsigned short v1:7; empty v2; };
struct BFu0c_BFu8c_Sf { unsigned char :0; unsigned char v1:8; empty v2; };
struct BFu0c_BFu8i_Sf { unsigned char :0; unsigned int v1:8; empty v2; };
struct BFu0c_BFu8ll_Sf { unsigned char :0; unsigned long long v1:8; empty v2; };
struct BFu0c_BFu8s_Sf { unsigned char :0; unsigned short v1:8; empty v2; };
struct BFu0c_BFu9i_Sf { unsigned char :0; unsigned int v1:9; empty v2; };
struct BFu0c_BFu9ll_Sf { unsigned char :0; unsigned long long v1:9; empty v2; };
struct BFu0c_BFu9s_Sf { unsigned char :0; unsigned short v1:9; empty v2; };
struct BFu0c_C_Sf { unsigned char :0; char v1; empty v2; };
struct BFu0c_D_Sf { unsigned char :0; double v1; empty v2; };
struct BFu0c_F_Sf { unsigned char :0; float v1; empty v2; };
struct BFu0c_I_Sf { unsigned char :0; int v1; empty v2; };
struct BFu0c_Ip_Sf { unsigned char :0; int * v1; empty v2; };
struct BFu0c_L_Sf { unsigned char :0; long long v1; empty v2; };
struct BFu0c_S_Sf { unsigned char :0; short v1; empty v2; };
struct BFu0c_Sf { unsigned char :0; empty v1; };
struct BFu0c_Sf_BFu0c { unsigned char :0; empty v1; unsigned char :0; };
struct BFu0c_Sf_BFu0i { unsigned char :0; empty v1; unsigned int :0; };
struct BFu0c_Sf_BFu0ll { unsigned char :0; empty v1; unsigned long long :0; };
struct BFu0c_Sf_BFu0s { unsigned char :0; empty v1; unsigned short :0; };
struct BFu0c_Sf_BFu15i { unsigned char :0; empty v1; unsigned int v2:15; };
struct BFu0c_Sf_BFu15ll { unsigned char :0; empty v1; unsigned long long v2:15; };
struct BFu0c_Sf_BFu15s { unsigned char :0; empty v1; unsigned short v2:15; };
struct BFu0c_Sf_BFu16i { unsigned char :0; empty v1; unsigned int v2:16; };
struct BFu0c_Sf_BFu16ll { unsigned char :0; empty v1; unsigned long long v2:16; };
struct BFu0c_Sf_BFu16s { unsigned char :0; empty v1; unsigned short v2:16; };
struct BFu0c_Sf_BFu17i { unsigned char :0; empty v1; unsigned int v2:17; };
struct BFu0c_Sf_BFu17ll { unsigned char :0; empty v1; unsigned long long v2:17; };
struct BFu0c_Sf_BFu1c { unsigned char :0; empty v1; unsigned char v2:1; };
struct BFu0c_Sf_BFu1i { unsigned char :0; empty v1; unsigned int v2:1; };
struct BFu0c_Sf_BFu1ll { unsigned char :0; empty v1; unsigned long long v2:1; };
struct BFu0c_Sf_BFu1s { unsigned char :0; empty v1; unsigned short v2:1; };
struct BFu0c_Sf_BFu31i { unsigned char :0; empty v1; unsigned int v2:31; };
struct BFu0c_Sf_BFu31ll { unsigned char :0; empty v1; unsigned long long v2:31; };
struct BFu0c_Sf_BFu32i { unsigned char :0; empty v1; unsigned int v2:32; };
struct BFu0c_Sf_BFu32ll { unsigned char :0; empty v1; unsigned long long v2:32; };
struct BFu0c_Sf_BFu33 { unsigned char :0; empty v1; unsigned long long v2:33; };
struct BFu0c_Sf_BFu7c { unsigned char :0; empty v1; unsigned char v2:7; };
struct BFu0c_Sf_BFu7i { unsigned char :0; empty v1; unsigned int v2:7; };
struct BFu0c_Sf_BFu7ll { unsigned char :0; empty v1; unsigned long long v2:7; };
struct BFu0c_Sf_BFu7s { unsigned char :0; empty v1; unsigned short v2:7; };
struct BFu0c_Sf_BFu8c { unsigned char :0; empty v1; unsigned char v2:8; };
struct BFu0c_Sf_BFu8i { unsigned char :0; empty v1; unsigned int v2:8; };
struct BFu0c_Sf_BFu8ll { unsigned char :0; empty v1; unsigned long long v2:8; };
struct BFu0c_Sf_BFu8s { unsigned char :0; empty v1; unsigned short v2:8; };
struct BFu0c_Sf_BFu9i { unsigned char :0; empty v1; unsigned int v2:9; };
struct BFu0c_Sf_BFu9ll { unsigned char :0; empty v1; unsigned long long v2:9; };
struct BFu0c_Sf_BFu9s { unsigned char :0; empty v1; unsigned short v2:9; };
struct BFu0c_Sf_C { unsigned char :0; empty v1; char v2; };
struct BFu0c_Sf_D { unsigned char :0; empty v1; double v2; };
struct BFu0c_Sf_F { unsigned char :0; empty v1; float v2; };
struct BFu0c_Sf_I { unsigned char :0; empty v1; int v2; };
struct BFu0c_Sf_Ip { unsigned char :0; empty v1; int * v2; };
struct BFu0c_Sf_L { unsigned char :0; empty v1; long long v2; };
struct BFu0c_Sf_S { unsigned char :0; empty v1; short v2; };
struct BFu0c_Sf_Sf { unsigned char :0; empty v1; empty v2; };
struct BFu0c_Sf_Uc { unsigned char :0; empty v1; unsigned char v2; };
struct BFu0c_Sf_Ui { unsigned char :0; empty v1; unsigned int v2; };
struct BFu0c_Sf_Ul { unsigned char :0; empty v1; unsigned long long v2; };
struct BFu0c_Sf_Us { unsigned char :0; empty v1; unsigned short v2; };
struct BFu0c_Sf_Vp { unsigned char :0; empty v1; void * v2; };
struct BFu0c_Uc_Sf { unsigned char :0; unsigned char v1; empty v2; };
struct BFu0c_Ui_Sf { unsigned char :0; unsigned int v1; empty v2; };
struct BFu0c_Ul_Sf { unsigned char :0; unsigned long long v1; empty v2; };
struct BFu0c_Us_Sf { unsigned char :0; unsigned short v1; empty v2; };
struct BFu0c_Vp_Sf { unsigned char :0; void * v1; empty v2; };
struct BFu0i_BFu0c_Sf { unsigned int :0; unsigned char :0; empty v1; };
struct BFu0i_BFu0i_Sf { unsigned int :0; unsigned int :0; empty v1; };
struct BFu0i_BFu0ll_Sf { unsigned int :0; unsigned long long :0; empty v1; };
struct BFu0i_BFu0s_Sf { unsigned int :0; unsigned short :0; empty v1; };
struct BFu0i_BFu15i_Sf { unsigned int :0; unsigned int v1:15; empty v2; };
struct BFu0i_BFu15ll_Sf { unsigned int :0; unsigned long long v1:15; empty v2; };
struct BFu0i_BFu15s_Sf { unsigned int :0; unsigned short v1:15; empty v2; };
struct BFu0i_BFu16i_Sf { unsigned int :0; unsigned int v1:16; empty v2; };
struct BFu0i_BFu16ll_Sf { unsigned int :0; unsigned long long v1:16; empty v2; };
struct BFu0i_BFu16s_Sf { unsigned int :0; unsigned short v1:16; empty v2; };
struct BFu0i_BFu17i_Sf { unsigned int :0; unsigned int v1:17; empty v2; };
struct BFu0i_BFu17ll_Sf { unsigned int :0; unsigned long long v1:17; empty v2; };
struct BFu0i_BFu1c_Sf { unsigned int :0; unsigned char v1:1; empty v2; };
struct BFu0i_BFu1i_Sf { unsigned int :0; unsigned int v1:1; empty v2; };
struct BFu0i_BFu1ll_Sf { unsigned int :0; unsigned long long v1:1; empty v2; };
struct BFu0i_BFu1s_Sf { unsigned int :0; unsigned short v1:1; empty v2; };
struct BFu0i_BFu31i_Sf { unsigned int :0; unsigned int v1:31; empty v2; };
struct BFu0i_BFu31ll_Sf { unsigned int :0; unsigned long long v1:31; empty v2; };
struct BFu0i_BFu32i_Sf { unsigned int :0; unsigned int v1:32; empty v2; };
struct BFu0i_BFu32ll_Sf { unsigned int :0; unsigned long long v1:32; empty v2; };
struct BFu0i_BFu33_Sf { unsigned int :0; unsigned long long v1:33; empty v2; };
struct BFu0i_BFu7c_Sf { unsigned int :0; unsigned char v1:7; empty v2; };
struct BFu0i_BFu7i_Sf { unsigned int :0; unsigned int v1:7; empty v2; };
struct BFu0i_BFu7ll_Sf { unsigned int :0; unsigned long long v1:7; empty v2; };
struct BFu0i_BFu7s_Sf { unsigned int :0; unsigned short v1:7; empty v2; };
struct BFu0i_BFu8c_Sf { unsigned int :0; unsigned char v1:8; empty v2; };
struct BFu0i_BFu8i_Sf { unsigned int :0; unsigned int v1:8; empty v2; };
struct BFu0i_BFu8ll_Sf { unsigned int :0; unsigned long long v1:8; empty v2; };
struct BFu0i_BFu8s_Sf { unsigned int :0; unsigned short v1:8; empty v2; };
struct BFu0i_BFu9i_Sf { unsigned int :0; unsigned int v1:9; empty v2; };
struct BFu0i_BFu9ll_Sf { unsigned int :0; unsigned long long v1:9; empty v2; };
struct BFu0i_BFu9s_Sf { unsigned int :0; unsigned short v1:9; empty v2; };
struct BFu0i_C_Sf { unsigned int :0; char v1; empty v2; };
struct BFu0i_D_Sf { unsigned int :0; double v1; empty v2; };
struct BFu0i_F_Sf { unsigned int :0; float v1; empty v2; };
struct BFu0i_I_Sf { unsigned int :0; int v1; empty v2; };
struct BFu0i_Ip_Sf { unsigned int :0; int * v1; empty v2; };
struct BFu0i_L_Sf { unsigned int :0; long long v1; empty v2; };
struct BFu0i_S_Sf { unsigned int :0; short v1; empty v2; };
struct BFu0i_Sf { unsigned int :0; empty v1; };
struct BFu0i_Sf_BFu0c { unsigned int :0; empty v1; unsigned char :0; };
struct BFu0i_Sf_BFu0i { unsigned int :0; empty v1; unsigned int :0; };
struct BFu0i_Sf_BFu0ll { unsigned int :0; empty v1; unsigned long long :0; };
struct BFu0i_Sf_BFu0s { unsigned int :0; empty v1; unsigned short :0; };
struct BFu0i_Sf_BFu15i { unsigned int :0; empty v1; unsigned int v2:15; };
struct BFu0i_Sf_BFu15ll { unsigned int :0; empty v1; unsigned long long v2:15; };
struct BFu0i_Sf_BFu15s { unsigned int :0; empty v1; unsigned short v2:15; };
struct BFu0i_Sf_BFu16i { unsigned int :0; empty v1; unsigned int v2:16; };
struct BFu0i_Sf_BFu16ll { unsigned int :0; empty v1; unsigned long long v2:16; };
struct BFu0i_Sf_BFu16s { unsigned int :0; empty v1; unsigned short v2:16; };
struct BFu0i_Sf_BFu17i { unsigned int :0; empty v1; unsigned int v2:17; };
struct BFu0i_Sf_BFu17ll { unsigned int :0; empty v1; unsigned long long v2:17; };
struct BFu0i_Sf_BFu1c { unsigned int :0; empty v1; unsigned char v2:1; };
struct BFu0i_Sf_BFu1i { unsigned int :0; empty v1; unsigned int v2:1; };
struct BFu0i_Sf_BFu1ll { unsigned int :0; empty v1; unsigned long long v2:1; };
struct BFu0i_Sf_BFu1s { unsigned int :0; empty v1; unsigned short v2:1; };
struct BFu0i_Sf_BFu31i { unsigned int :0; empty v1; unsigned int v2:31; };
struct BFu0i_Sf_BFu31ll { unsigned int :0; empty v1; unsigned long long v2:31; };
struct BFu0i_Sf_BFu32i { unsigned int :0; empty v1; unsigned int v2:32; };
struct BFu0i_Sf_BFu32ll { unsigned int :0; empty v1; unsigned long long v2:32; };
struct BFu0i_Sf_BFu33 { unsigned int :0; empty v1; unsigned long long v2:33; };
struct BFu0i_Sf_BFu7c { unsigned int :0; empty v1; unsigned char v2:7; };
struct BFu0i_Sf_BFu7i { unsigned int :0; empty v1; unsigned int v2:7; };
struct BFu0i_Sf_BFu7ll { unsigned int :0; empty v1; unsigned long long v2:7; };
struct BFu0i_Sf_BFu7s { unsigned int :0; empty v1; unsigned short v2:7; };
struct BFu0i_Sf_BFu8c { unsigned int :0; empty v1; unsigned char v2:8; };
struct BFu0i_Sf_BFu8i { unsigned int :0; empty v1; unsigned int v2:8; };
struct BFu0i_Sf_BFu8ll { unsigned int :0; empty v1; unsigned long long v2:8; };
struct BFu0i_Sf_BFu8s { unsigned int :0; empty v1; unsigned short v2:8; };
struct BFu0i_Sf_BFu9i { unsigned int :0; empty v1; unsigned int v2:9; };
struct BFu0i_Sf_BFu9ll { unsigned int :0; empty v1; unsigned long long v2:9; };
struct BFu0i_Sf_BFu9s { unsigned int :0; empty v1; unsigned short v2:9; };
struct BFu0i_Sf_C { unsigned int :0; empty v1; char v2; };
struct BFu0i_Sf_D { unsigned int :0; empty v1; double v2; };
struct BFu0i_Sf_F { unsigned int :0; empty v1; float v2; };
struct BFu0i_Sf_I { unsigned int :0; empty v1; int v2; };
struct BFu0i_Sf_Ip { unsigned int :0; empty v1; int * v2; };
struct BFu0i_Sf_L { unsigned int :0; empty v1; long long v2; };
struct BFu0i_Sf_S { unsigned int :0; empty v1; short v2; };
struct BFu0i_Sf_Sf { unsigned int :0; empty v1; empty v2; };
struct BFu0i_Sf_Uc { unsigned int :0; empty v1; unsigned char v2; };
struct BFu0i_Sf_Ui { unsigned int :0; empty v1; unsigned int v2; };
struct BFu0i_Sf_Ul { unsigned int :0; empty v1; unsigned long long v2; };
struct BFu0i_Sf_Us { unsigned int :0; empty v1; unsigned short v2; };
struct BFu0i_Sf_Vp { unsigned int :0; empty v1; void * v2; };
struct BFu0i_Uc_Sf { unsigned int :0; unsigned char v1; empty v2; };
struct BFu0i_Ui_Sf { unsigned int :0; unsigned int v1; empty v2; };
struct BFu0i_Ul_Sf { unsigned int :0; unsigned long long v1; empty v2; };
struct BFu0i_Us_Sf { unsigned int :0; unsigned short v1; empty v2; };
struct BFu0i_Vp_Sf { unsigned int :0; void * v1; empty v2; };
struct BFu0ll_BFu0c_Sf { unsigned long long :0; unsigned char :0; empty v1; };
struct BFu0ll_BFu0i_Sf { unsigned long long :0; unsigned int :0; empty v1; };
struct BFu0ll_BFu0ll_Sf { unsigned long long :0; unsigned long long :0; empty v1; };
struct BFu0ll_BFu0s_Sf { unsigned long long :0; unsigned short :0; empty v1; };
struct BFu0ll_BFu15i_Sf { unsigned long long :0; unsigned int v1:15; empty v2; };
struct BFu0ll_BFu15ll_Sf { unsigned long long :0; unsigned long long v1:15; empty v2; };
struct BFu0ll_BFu15s_Sf { unsigned long long :0; unsigned short v1:15; empty v2; };
struct BFu0ll_BFu16i_Sf { unsigned long long :0; unsigned int v1:16; empty v2; };
struct BFu0ll_BFu16ll_Sf { unsigned long long :0; unsigned long long v1:16; empty v2; };
struct BFu0ll_BFu16s_Sf { unsigned long long :0; unsigned short v1:16; empty v2; };
struct BFu0ll_BFu17i_Sf { unsigned long long :0; unsigned int v1:17; empty v2; };
struct BFu0ll_BFu17ll_Sf { unsigned long long :0; unsigned long long v1:17; empty v2; };
struct BFu0ll_BFu1c_Sf { unsigned long long :0; unsigned char v1:1; empty v2; };
struct BFu0ll_BFu1i_Sf { unsigned long long :0; unsigned int v1:1; empty v2; };
struct BFu0ll_BFu1ll_Sf { unsigned long long :0; unsigned long long v1:1; empty v2; };
struct BFu0ll_BFu1s_Sf { unsigned long long :0; unsigned short v1:1; empty v2; };
struct BFu0ll_BFu31i_Sf { unsigned long long :0; unsigned int v1:31; empty v2; };
struct BFu0ll_BFu31ll_Sf { unsigned long long :0; unsigned long long v1:31; empty v2; };
struct BFu0ll_BFu32i_Sf { unsigned long long :0; unsigned int v1:32; empty v2; };
struct BFu0ll_BFu32ll_Sf { unsigned long long :0; unsigned long long v1:32; empty v2; };
struct BFu0ll_BFu33_Sf { unsigned long long :0; unsigned long long v1:33; empty v2; };
struct BFu0ll_BFu7c_Sf { unsigned long long :0; unsigned char v1:7; empty v2; };
struct BFu0ll_BFu7i_Sf { unsigned long long :0; unsigned int v1:7; empty v2; };
struct BFu0ll_BFu7ll_Sf { unsigned long long :0; unsigned long long v1:7; empty v2; };
struct BFu0ll_BFu7s_Sf { unsigned long long :0; unsigned short v1:7; empty v2; };
struct BFu0ll_BFu8c_Sf { unsigned long long :0; unsigned char v1:8; empty v2; };
struct BFu0ll_BFu8i_Sf { unsigned long long :0; unsigned int v1:8; empty v2; };
struct BFu0ll_BFu8ll_Sf { unsigned long long :0; unsigned long long v1:8; empty v2; };
struct BFu0ll_BFu8s_Sf { unsigned long long :0; unsigned short v1:8; empty v2; };
struct BFu0ll_BFu9i_Sf { unsigned long long :0; unsigned int v1:9; empty v2; };
struct BFu0ll_BFu9ll_Sf { unsigned long long :0; unsigned long long v1:9; empty v2; };
struct BFu0ll_BFu9s_Sf { unsigned long long :0; unsigned short v1:9; empty v2; };
struct BFu0ll_C_Sf { unsigned long long :0; char v1; empty v2; };
struct BFu0ll_D_Sf { unsigned long long :0; double v1; empty v2; };
struct BFu0ll_F_Sf { unsigned long long :0; float v1; empty v2; };
struct BFu0ll_I_Sf { unsigned long long :0; int v1; empty v2; };
struct BFu0ll_Ip_Sf { unsigned long long :0; int * v1; empty v2; };
struct BFu0ll_L_Sf { unsigned long long :0; long long v1; empty v2; };
struct BFu0ll_S_Sf { unsigned long long :0; short v1; empty v2; };
struct BFu0ll_Sf { unsigned long long :0; empty v1; };
struct BFu0ll_Sf_BFu0c { unsigned long long :0; empty v1; unsigned char :0; };
struct BFu0ll_Sf_BFu0i { unsigned long long :0; empty v1; unsigned int :0; };
struct BFu0ll_Sf_BFu0ll { unsigned long long :0; empty v1; unsigned long long :0; };
struct BFu0ll_Sf_BFu0s { unsigned long long :0; empty v1; unsigned short :0; };
struct BFu0ll_Sf_BFu15i { unsigned long long :0; empty v1; unsigned int v2:15; };
struct BFu0ll_Sf_BFu15ll { unsigned long long :0; empty v1; unsigned long long v2:15; };
struct BFu0ll_Sf_BFu15s { unsigned long long :0; empty v1; unsigned short v2:15; };
struct BFu0ll_Sf_BFu16i { unsigned long long :0; empty v1; unsigned int v2:16; };
struct BFu0ll_Sf_BFu16ll { unsigned long long :0; empty v1; unsigned long long v2:16; };
struct BFu0ll_Sf_BFu16s { unsigned long long :0; empty v1; unsigned short v2:16; };
struct BFu0ll_Sf_BFu17i { unsigned long long :0; empty v1; unsigned int v2:17; };
struct BFu0ll_Sf_BFu17ll { unsigned long long :0; empty v1; unsigned long long v2:17; };
struct BFu0ll_Sf_BFu1c { unsigned long long :0; empty v1; unsigned char v2:1; };
struct BFu0ll_Sf_BFu1i { unsigned long long :0; empty v1; unsigned int v2:1; };
struct BFu0ll_Sf_BFu1ll { unsigned long long :0; empty v1; unsigned long long v2:1; };
struct BFu0ll_Sf_BFu1s { unsigned long long :0; empty v1; unsigned short v2:1; };
struct BFu0ll_Sf_BFu31i { unsigned long long :0; empty v1; unsigned int v2:31; };
struct BFu0ll_Sf_BFu31ll { unsigned long long :0; empty v1; unsigned long long v2:31; };
struct BFu0ll_Sf_BFu32i { unsigned long long :0; empty v1; unsigned int v2:32; };
struct BFu0ll_Sf_BFu32ll { unsigned long long :0; empty v1; unsigned long long v2:32; };
struct BFu0ll_Sf_BFu33 { unsigned long long :0; empty v1; unsigned long long v2:33; };
struct BFu0ll_Sf_BFu7c { unsigned long long :0; empty v1; unsigned char v2:7; };
struct BFu0ll_Sf_BFu7i { unsigned long long :0; empty v1; unsigned int v2:7; };
struct BFu0ll_Sf_BFu7ll { unsigned long long :0; empty v1; unsigned long long v2:7; };
struct BFu0ll_Sf_BFu7s { unsigned long long :0; empty v1; unsigned short v2:7; };
struct BFu0ll_Sf_BFu8c { unsigned long long :0; empty v1; unsigned char v2:8; };
struct BFu0ll_Sf_BFu8i { unsigned long long :0; empty v1; unsigned int v2:8; };
struct BFu0ll_Sf_BFu8ll { unsigned long long :0; empty v1; unsigned long long v2:8; };
struct BFu0ll_Sf_BFu8s { unsigned long long :0; empty v1; unsigned short v2:8; };
struct BFu0ll_Sf_BFu9i { unsigned long long :0; empty v1; unsigned int v2:9; };
struct BFu0ll_Sf_BFu9ll { unsigned long long :0; empty v1; unsigned long long v2:9; };
struct BFu0ll_Sf_BFu9s { unsigned long long :0; empty v1; unsigned short v2:9; };
struct BFu0ll_Sf_C { unsigned long long :0; empty v1; char v2; };
struct BFu0ll_Sf_D { unsigned long long :0; empty v1; double v2; };
struct BFu0ll_Sf_F { unsigned long long :0; empty v1; float v2; };
struct BFu0ll_Sf_I { unsigned long long :0; empty v1; int v2; };
struct BFu0ll_Sf_Ip { unsigned long long :0; empty v1; int * v2; };
struct BFu0ll_Sf_L { unsigned long long :0; empty v1; long long v2; };
struct BFu0ll_Sf_S { unsigned long long :0; empty v1; short v2; };
struct BFu0ll_Sf_Sf { unsigned long long :0; empty v1; empty v2; };
struct BFu0ll_Sf_Uc { unsigned long long :0; empty v1; unsigned char v2; };
struct BFu0ll_Sf_Ui { unsigned long long :0; empty v1; unsigned int v2; };
struct BFu0ll_Sf_Ul { unsigned long long :0; empty v1; unsigned long long v2; };
struct BFu0ll_Sf_Us { unsigned long long :0; empty v1; unsigned short v2; };
struct BFu0ll_Sf_Vp { unsigned long long :0; empty v1; void * v2; };
struct BFu0ll_Uc_Sf { unsigned long long :0; unsigned char v1; empty v2; };
struct BFu0ll_Ui_Sf { unsigned long long :0; unsigned int v1; empty v2; };
struct BFu0ll_Ul_Sf { unsigned long long :0; unsigned long long v1; empty v2; };
struct BFu0ll_Us_Sf { unsigned long long :0; unsigned short v1; empty v2; };
struct BFu0ll_Vp_Sf { unsigned long long :0; void * v1; empty v2; };
struct BFu0s_BFu0c_Sf { unsigned short :0; unsigned char :0; empty v1; };
struct BFu0s_BFu0i_Sf { unsigned short :0; unsigned int :0; empty v1; };
struct BFu0s_BFu0ll_Sf { unsigned short :0; unsigned long long :0; empty v1; };
struct BFu0s_BFu0s_Sf { unsigned short :0; unsigned short :0; empty v1; };
struct BFu0s_BFu15i_Sf { unsigned short :0; unsigned int v1:15; empty v2; };
struct BFu0s_BFu15ll_Sf { unsigned short :0; unsigned long long v1:15; empty v2; };
struct BFu0s_BFu15s_Sf { unsigned short :0; unsigned short v1:15; empty v2; };
struct BFu0s_BFu16i_Sf { unsigned short :0; unsigned int v1:16; empty v2; };
struct BFu0s_BFu16ll_Sf { unsigned short :0; unsigned long long v1:16; empty v2; };
struct BFu0s_BFu16s_Sf { unsigned short :0; unsigned short v1:16; empty v2; };
struct BFu0s_BFu17i_Sf { unsigned short :0; unsigned int v1:17; empty v2; };
struct BFu0s_BFu17ll_Sf { unsigned short :0; unsigned long long v1:17; empty v2; };
struct BFu0s_BFu1c_Sf { unsigned short :0; unsigned char v1:1; empty v2; };
struct BFu0s_BFu1i_Sf { unsigned short :0; unsigned int v1:1; empty v2; };
struct BFu0s_BFu1ll_Sf { unsigned short :0; unsigned long long v1:1; empty v2; };
struct BFu0s_BFu1s_Sf { unsigned short :0; unsigned short v1:1; empty v2; };
struct BFu0s_BFu31i_Sf { unsigned short :0; unsigned int v1:31; empty v2; };
struct BFu0s_BFu31ll_Sf { unsigned short :0; unsigned long long v1:31; empty v2; };
struct BFu0s_BFu32i_Sf { unsigned short :0; unsigned int v1:32; empty v2; };
struct BFu0s_BFu32ll_Sf { unsigned short :0; unsigned long long v1:32; empty v2; };
struct BFu0s_BFu33_Sf { unsigned short :0; unsigned long long v1:33; empty v2; };
struct BFu0s_BFu7c_Sf { unsigned short :0; unsigned char v1:7; empty v2; };
struct BFu0s_BFu7i_Sf { unsigned short :0; unsigned int v1:7; empty v2; };
struct BFu0s_BFu7ll_Sf { unsigned short :0; unsigned long long v1:7; empty v2; };
struct BFu0s_BFu7s_Sf { unsigned short :0; unsigned short v1:7; empty v2; };
struct BFu0s_BFu8c_Sf { unsigned short :0; unsigned char v1:8; empty v2; };
struct BFu0s_BFu8i_Sf { unsigned short :0; unsigned int v1:8; empty v2; };
struct BFu0s_BFu8ll_Sf { unsigned short :0; unsigned long long v1:8; empty v2; };
struct BFu0s_BFu8s_Sf { unsigned short :0; unsigned short v1:8; empty v2; };
struct BFu0s_BFu9i_Sf { unsigned short :0; unsigned int v1:9; empty v2; };
struct BFu0s_BFu9ll_Sf { unsigned short :0; unsigned long long v1:9; empty v2; };
struct BFu0s_BFu9s_Sf { unsigned short :0; unsigned short v1:9; empty v2; };
struct BFu0s_C_Sf { unsigned short :0; char v1; empty v2; };
struct BFu0s_D_Sf { unsigned short :0; double v1; empty v2; };
struct BFu0s_F_Sf { unsigned short :0; float v1; empty v2; };
struct BFu0s_I_Sf { unsigned short :0; int v1; empty v2; };
struct BFu0s_Ip_Sf { unsigned short :0; int * v1; empty v2; };
struct BFu0s_L_Sf { unsigned short :0; long long v1; empty v2; };
struct BFu0s_S_Sf { unsigned short :0; short v1; empty v2; };
struct BFu0s_Sf { unsigned short :0; empty v1; };
struct BFu0s_Sf_BFu0c { unsigned short :0; empty v1; unsigned char :0; };
struct BFu0s_Sf_BFu0i { unsigned short :0; empty v1; unsigned int :0; };
struct BFu0s_Sf_BFu0ll { unsigned short :0; empty v1; unsigned long long :0; };
struct BFu0s_Sf_BFu0s { unsigned short :0; empty v1; unsigned short :0; };
struct BFu0s_Sf_BFu15i { unsigned short :0; empty v1; unsigned int v2:15; };
struct BFu0s_Sf_BFu15ll { unsigned short :0; empty v1; unsigned long long v2:15; };
struct BFu0s_Sf_BFu15s { unsigned short :0; empty v1; unsigned short v2:15; };
struct BFu0s_Sf_BFu16i { unsigned short :0; empty v1; unsigned int v2:16; };
struct BFu0s_Sf_BFu16ll { unsigned short :0; empty v1; unsigned long long v2:16; };
struct BFu0s_Sf_BFu16s { unsigned short :0; empty v1; unsigned short v2:16; };
struct BFu0s_Sf_BFu17i { unsigned short :0; empty v1; unsigned int v2:17; };
struct BFu0s_Sf_BFu17ll { unsigned short :0; empty v1; unsigned long long v2:17; };
struct BFu0s_Sf_BFu1c { unsigned short :0; empty v1; unsigned char v2:1; };
struct BFu0s_Sf_BFu1i { unsigned short :0; empty v1; unsigned int v2:1; };
struct BFu0s_Sf_BFu1ll { unsigned short :0; empty v1; unsigned long long v2:1; };
struct BFu0s_Sf_BFu1s { unsigned short :0; empty v1; unsigned short v2:1; };
struct BFu0s_Sf_BFu31i { unsigned short :0; empty v1; unsigned int v2:31; };
struct BFu0s_Sf_BFu31ll { unsigned short :0; empty v1; unsigned long long v2:31; };
struct BFu0s_Sf_BFu32i { unsigned short :0; empty v1; unsigned int v2:32; };
struct BFu0s_Sf_BFu32ll { unsigned short :0; empty v1; unsigned long long v2:32; };
struct BFu0s_Sf_BFu33 { unsigned short :0; empty v1; unsigned long long v2:33; };
struct BFu0s_Sf_BFu7c { unsigned short :0; empty v1; unsigned char v2:7; };
struct BFu0s_Sf_BFu7i { unsigned short :0; empty v1; unsigned int v2:7; };
struct BFu0s_Sf_BFu7ll { unsigned short :0; empty v1; unsigned long long v2:7; };
struct BFu0s_Sf_BFu7s { unsigned short :0; empty v1; unsigned short v2:7; };
struct BFu0s_Sf_BFu8c { unsigned short :0; empty v1; unsigned char v2:8; };
struct BFu0s_Sf_BFu8i { unsigned short :0; empty v1; unsigned int v2:8; };
struct BFu0s_Sf_BFu8ll { unsigned short :0; empty v1; unsigned long long v2:8; };
struct BFu0s_Sf_BFu8s { unsigned short :0; empty v1; unsigned short v2:8; };
struct BFu0s_Sf_BFu9i { unsigned short :0; empty v1; unsigned int v2:9; };
struct BFu0s_Sf_BFu9ll { unsigned short :0; empty v1; unsigned long long v2:9; };
struct BFu0s_Sf_BFu9s { unsigned short :0; empty v1; unsigned short v2:9; };
struct BFu0s_Sf_C { unsigned short :0; empty v1; char v2; };
struct BFu0s_Sf_D { unsigned short :0; empty v1; double v2; };
struct BFu0s_Sf_F { unsigned short :0; empty v1; float v2; };
struct BFu0s_Sf_I { unsigned short :0; empty v1; int v2; };
struct BFu0s_Sf_Ip { unsigned short :0; empty v1; int * v2; };
struct BFu0s_Sf_L { unsigned short :0; empty v1; long long v2; };
struct BFu0s_Sf_S { unsigned short :0; empty v1; short v2; };
struct BFu0s_Sf_Sf { unsigned short :0; empty v1; empty v2; };
struct BFu0s_Sf_Uc { unsigned short :0; empty v1; unsigned char v2; };
struct BFu0s_Sf_Ui { unsigned short :0; empty v1; unsigned int v2; };
struct BFu0s_Sf_Ul { unsigned short :0; empty v1; unsigned long long v2; };
struct BFu0s_Sf_Us { unsigned short :0; empty v1; unsigned short v2; };
struct BFu0s_Sf_Vp { unsigned short :0; empty v1; void * v2; };
struct BFu0s_Uc_Sf { unsigned short :0; unsigned char v1; empty v2; };
struct BFu0s_Ui_Sf { unsigned short :0; unsigned int v1; empty v2; };
struct BFu0s_Ul_Sf { unsigned short :0; unsigned long long v1; empty v2; };
struct BFu0s_Us_Sf { unsigned short :0; unsigned short v1; empty v2; };
struct BFu0s_Vp_Sf { unsigned short :0; void * v1; empty v2; };
struct BFu15i_BFu0c_Sf { unsigned int v1:15; unsigned char :0; empty v2; };
struct BFu15i_BFu0i_Sf { unsigned int v1:15; unsigned int :0; empty v2; };
struct BFu15i_BFu0ll_Sf { unsigned int v1:15; unsigned long long :0; empty v2; };
struct BFu15i_BFu0s_Sf { unsigned int v1:15; unsigned short :0; empty v2; };
struct BFu15i_Sf_BFu0c { unsigned int v1:15; empty v2; unsigned char :0; };
struct BFu15i_Sf_BFu0i { unsigned int v1:15; empty v2; unsigned int :0; };
struct BFu15i_Sf_BFu0ll { unsigned int v1:15; empty v2; unsigned long long :0; };
struct BFu15i_Sf_BFu0s { unsigned int v1:15; empty v2; unsigned short :0; };
struct BFu15ll_BFu0c_Sf { unsigned long long v1:15; unsigned char :0; empty v2; };
struct BFu15ll_BFu0i_Sf { unsigned long long v1:15; unsigned int :0; empty v2; };
struct BFu15ll_BFu0ll_Sf { unsigned long long v1:15; unsigned long long :0; empty v2; };
struct BFu15ll_BFu0s_Sf { unsigned long long v1:15; unsigned short :0; empty v2; };
struct BFu15ll_Sf_BFu0c { unsigned long long v1:15; empty v2; unsigned char :0; };
struct BFu15ll_Sf_BFu0i { unsigned long long v1:15; empty v2; unsigned int :0; };
struct BFu15ll_Sf_BFu0ll { unsigned long long v1:15; empty v2; unsigned long long :0; };
struct BFu15ll_Sf_BFu0s { unsigned long long v1:15; empty v2; unsigned short :0; };
struct BFu15s_BFu0c_Sf { unsigned short v1:15; unsigned char :0; empty v2; };
struct BFu15s_BFu0i_Sf { unsigned short v1:15; unsigned int :0; empty v2; };
struct BFu15s_BFu0ll_Sf { unsigned short v1:15; unsigned long long :0; empty v2; };
struct BFu15s_BFu0s_Sf { unsigned short v1:15; unsigned short :0; empty v2; };
struct BFu15s_Sf_BFu0c { unsigned short v1:15; empty v2; unsigned char :0; };
struct BFu15s_Sf_BFu0i { unsigned short v1:15; empty v2; unsigned int :0; };
struct BFu15s_Sf_BFu0ll { unsigned short v1:15; empty v2; unsigned long long :0; };
struct BFu15s_Sf_BFu0s { unsigned short v1:15; empty v2; unsigned short :0; };
struct BFu16i_BFu0c_Sf { unsigned int v1:16; unsigned char :0; empty v2; };
struct BFu16i_BFu0i_Sf { unsigned int v1:16; unsigned int :0; empty v2; };
struct BFu16i_BFu0ll_Sf { unsigned int v1:16; unsigned long long :0; empty v2; };
struct BFu16i_BFu0s_Sf { unsigned int v1:16; unsigned short :0; empty v2; };
struct BFu16i_Sf_BFu0c { unsigned int v1:16; empty v2; unsigned char :0; };
struct BFu16i_Sf_BFu0i { unsigned int v1:16; empty v2; unsigned int :0; };
struct BFu16i_Sf_BFu0ll { unsigned int v1:16; empty v2; unsigned long long :0; };
struct BFu16i_Sf_BFu0s { unsigned int v1:16; empty v2; unsigned short :0; };
struct BFu16ll_BFu0c_Sf { unsigned long long v1:16; unsigned char :0; empty v2; };
struct BFu16ll_BFu0i_Sf { unsigned long long v1:16; unsigned int :0; empty v2; };
struct BFu16ll_BFu0ll_Sf { unsigned long long v1:16; unsigned long long :0; empty v2; };
struct BFu16ll_BFu0s_Sf { unsigned long long v1:16; unsigned short :0; empty v2; };
struct BFu16ll_Sf_BFu0c { unsigned long long v1:16; empty v2; unsigned char :0; };
struct BFu16ll_Sf_BFu0i { unsigned long long v1:16; empty v2; unsigned int :0; };
struct BFu16ll_Sf_BFu0ll { unsigned long long v1:16; empty v2; unsigned long long :0; };
struct BFu16ll_Sf_BFu0s { unsigned long long v1:16; empty v2; unsigned short :0; };
struct BFu16s_BFu0c_Sf { unsigned short v1:16; unsigned char :0; empty v2; };
struct BFu16s_BFu0i_Sf { unsigned short v1:16; unsigned int :0; empty v2; };
struct BFu16s_BFu0ll_Sf { unsigned short v1:16; unsigned long long :0; empty v2; };
struct BFu16s_BFu0s_Sf { unsigned short v1:16; unsigned short :0; empty v2; };
struct BFu16s_Sf_BFu0c { unsigned short v1:16; empty v2; unsigned char :0; };
struct BFu16s_Sf_BFu0i { unsigned short v1:16; empty v2; unsigned int :0; };
struct BFu16s_Sf_BFu0ll { unsigned short v1:16; empty v2; unsigned long long :0; };
struct BFu16s_Sf_BFu0s { unsigned short v1:16; empty v2; unsigned short :0; };
struct BFu17i_BFu0c_Sf { unsigned int v1:17; unsigned char :0; empty v2; };
struct BFu17i_BFu0i_Sf { unsigned int v1:17; unsigned int :0; empty v2; };
struct BFu17i_BFu0ll_Sf { unsigned int v1:17; unsigned long long :0; empty v2; };
struct BFu17i_BFu0s_Sf { unsigned int v1:17; unsigned short :0; empty v2; };
struct BFu17i_Sf_BFu0c { unsigned int v1:17; empty v2; unsigned char :0; };
struct BFu17i_Sf_BFu0i { unsigned int v1:17; empty v2; unsigned int :0; };
struct BFu17i_Sf_BFu0ll { unsigned int v1:17; empty v2; unsigned long long :0; };
struct BFu17i_Sf_BFu0s { unsigned int v1:17; empty v2; unsigned short :0; };
struct BFu17ll_BFu0c_Sf { unsigned long long v1:17; unsigned char :0; empty v2; };
struct BFu17ll_BFu0i_Sf { unsigned long long v1:17; unsigned int :0; empty v2; };
struct BFu17ll_BFu0ll_Sf { unsigned long long v1:17; unsigned long long :0; empty v2; };
struct BFu17ll_BFu0s_Sf { unsigned long long v1:17; unsigned short :0; empty v2; };
struct BFu17ll_Sf_BFu0c { unsigned long long v1:17; empty v2; unsigned char :0; };
struct BFu17ll_Sf_BFu0i { unsigned long long v1:17; empty v2; unsigned int :0; };
struct BFu17ll_Sf_BFu0ll { unsigned long long v1:17; empty v2; unsigned long long :0; };
struct BFu17ll_Sf_BFu0s { unsigned long long v1:17; empty v2; unsigned short :0; };
struct BFu1c_BFu0c_Sf { unsigned char v1:1; unsigned char :0; empty v2; };
struct BFu1c_BFu0i_Sf { unsigned char v1:1; unsigned int :0; empty v2; };
struct BFu1c_BFu0ll_Sf { unsigned char v1:1; unsigned long long :0; empty v2; };
struct BFu1c_BFu0s_Sf { unsigned char v1:1; unsigned short :0; empty v2; };
struct BFu1c_Sf_BFu0c { unsigned char v1:1; empty v2; unsigned char :0; };
struct BFu1c_Sf_BFu0i { unsigned char v1:1; empty v2; unsigned int :0; };
struct BFu1c_Sf_BFu0ll { unsigned char v1:1; empty v2; unsigned long long :0; };
struct BFu1c_Sf_BFu0s { unsigned char v1:1; empty v2; unsigned short :0; };
struct BFu1i_BFu0c_Sf { unsigned int v1:1; unsigned char :0; empty v2; };
struct BFu1i_BFu0i_Sf { unsigned int v1:1; unsigned int :0; empty v2; };
struct BFu1i_BFu0ll_Sf { unsigned int v1:1; unsigned long long :0; empty v2; };
struct BFu1i_BFu0s_Sf { unsigned int v1:1; unsigned short :0; empty v2; };
struct BFu1i_Sf_BFu0c { unsigned int v1:1; empty v2; unsigned char :0; };
struct BFu1i_Sf_BFu0i { unsigned int v1:1; empty v2; unsigned int :0; };
struct BFu1i_Sf_BFu0ll { unsigned int v1:1; empty v2; unsigned long long :0; };
struct BFu1i_Sf_BFu0s { unsigned int v1:1; empty v2; unsigned short :0; };
struct BFu1ll_BFu0c_Sf { unsigned long long v1:1; unsigned char :0; empty v2; };
struct BFu1ll_BFu0i_Sf { unsigned long long v1:1; unsigned int :0; empty v2; };
struct BFu1ll_BFu0ll_Sf { unsigned long long v1:1; unsigned long long :0; empty v2; };
struct BFu1ll_BFu0s_Sf { unsigned long long v1:1; unsigned short :0; empty v2; };
struct BFu1ll_Sf_BFu0c { unsigned long long v1:1; empty v2; unsigned char :0; };
struct BFu1ll_Sf_BFu0i { unsigned long long v1:1; empty v2; unsigned int :0; };
struct BFu1ll_Sf_BFu0ll { unsigned long long v1:1; empty v2; unsigned long long :0; };
struct BFu1ll_Sf_BFu0s { unsigned long long v1:1; empty v2; unsigned short :0; };
struct BFu1s_BFu0c_Sf { unsigned short v1:1; unsigned char :0; empty v2; };
struct BFu1s_BFu0i_Sf { unsigned short v1:1; unsigned int :0; empty v2; };
struct BFu1s_BFu0ll_Sf { unsigned short v1:1; unsigned long long :0; empty v2; };
struct BFu1s_BFu0s_Sf { unsigned short v1:1; unsigned short :0; empty v2; };
struct BFu1s_Sf_BFu0c { unsigned short v1:1; empty v2; unsigned char :0; };
struct BFu1s_Sf_BFu0i { unsigned short v1:1; empty v2; unsigned int :0; };
struct BFu1s_Sf_BFu0ll { unsigned short v1:1; empty v2; unsigned long long :0; };
struct BFu1s_Sf_BFu0s { unsigned short v1:1; empty v2; unsigned short :0; };
struct BFu31i_BFu0c_Sf { unsigned int v1:31; unsigned char :0; empty v2; };
struct BFu31i_BFu0i_Sf { unsigned int v1:31; unsigned int :0; empty v2; };
struct BFu31i_BFu0ll_Sf { unsigned int v1:31; unsigned long long :0; empty v2; };
struct BFu31i_BFu0s_Sf { unsigned int v1:31; unsigned short :0; empty v2; };
struct BFu31i_Sf_BFu0c { unsigned int v1:31; empty v2; unsigned char :0; };
struct BFu31i_Sf_BFu0i { unsigned int v1:31; empty v2; unsigned int :0; };
struct BFu31i_Sf_BFu0ll { unsigned int v1:31; empty v2; unsigned long long :0; };
struct BFu31i_Sf_BFu0s { unsigned int v1:31; empty v2; unsigned short :0; };
struct BFu31ll_BFu0c_Sf { unsigned long long v1:31; unsigned char :0; empty v2; };
struct BFu31ll_BFu0i_Sf { unsigned long long v1:31; unsigned int :0; empty v2; };
struct BFu31ll_BFu0ll_Sf { unsigned long long v1:31; unsigned long long :0; empty v2; };
struct BFu31ll_BFu0s_Sf { unsigned long long v1:31; unsigned short :0; empty v2; };
struct BFu31ll_Sf_BFu0c { unsigned long long v1:31; empty v2; unsigned char :0; };
struct BFu31ll_Sf_BFu0i { unsigned long long v1:31; empty v2; unsigned int :0; };
struct BFu31ll_Sf_BFu0ll { unsigned long long v1:31; empty v2; unsigned long long :0; };
struct BFu31ll_Sf_BFu0s { unsigned long long v1:31; empty v2; unsigned short :0; };
struct BFu32i_BFu0c_Sf { unsigned int v1:32; unsigned char :0; empty v2; };
struct BFu32i_BFu0i_Sf { unsigned int v1:32; unsigned int :0; empty v2; };
struct BFu32i_BFu0ll_Sf { unsigned int v1:32; unsigned long long :0; empty v2; };
struct BFu32i_BFu0s_Sf { unsigned int v1:32; unsigned short :0; empty v2; };
struct BFu32i_Sf_BFu0c { unsigned int v1:32; empty v2; unsigned char :0; };
struct BFu32i_Sf_BFu0i { unsigned int v1:32; empty v2; unsigned int :0; };
struct BFu32i_Sf_BFu0ll { unsigned int v1:32; empty v2; unsigned long long :0; };
struct BFu32i_Sf_BFu0s { unsigned int v1:32; empty v2; unsigned short :0; };
struct BFu32ll_BFu0c_Sf { unsigned long long v1:32; unsigned char :0; empty v2; };
struct BFu32ll_BFu0i_Sf { unsigned long long v1:32; unsigned int :0; empty v2; };
struct BFu32ll_BFu0ll_Sf { unsigned long long v1:32; unsigned long long :0; empty v2; };
struct BFu32ll_BFu0s_Sf { unsigned long long v1:32; unsigned short :0; empty v2; };
struct BFu32ll_Sf_BFu0c { unsigned long long v1:32; empty v2; unsigned char :0; };
struct BFu32ll_Sf_BFu0i { unsigned long long v1:32; empty v2; unsigned int :0; };
struct BFu32ll_Sf_BFu0ll { unsigned long long v1:32; empty v2; unsigned long long :0; };
struct BFu32ll_Sf_BFu0s { unsigned long long v1:32; empty v2; unsigned short :0; };
struct BFu33_BFu0c_Sf { unsigned long long v1:33; unsigned char :0; empty v2; };
struct BFu33_BFu0i_Sf { unsigned long long v1:33; unsigned int :0; empty v2; };
struct BFu33_BFu0ll_Sf { unsigned long long v1:33; unsigned long long :0; empty v2; };
struct BFu33_BFu0s_Sf { unsigned long long v1:33; unsigned short :0; empty v2; };
struct BFu33_Sf_BFu0c { unsigned long long v1:33; empty v2; unsigned char :0; };
struct BFu33_Sf_BFu0i { unsigned long long v1:33; empty v2; unsigned int :0; };
struct BFu33_Sf_BFu0ll { unsigned long long v1:33; empty v2; unsigned long long :0; };
struct BFu33_Sf_BFu0s { unsigned long long v1:33; empty v2; unsigned short :0; };
struct BFu7c_BFu0c_Sf { unsigned char v1:7; unsigned char :0; empty v2; };
struct BFu7c_BFu0i_Sf { unsigned char v1:7; unsigned int :0; empty v2; };
struct BFu7c_BFu0ll_Sf { unsigned char v1:7; unsigned long long :0; empty v2; };
struct BFu7c_BFu0s_Sf { unsigned char v1:7; unsigned short :0; empty v2; };
struct BFu7c_Sf_BFu0c { unsigned char v1:7; empty v2; unsigned char :0; };
struct BFu7c_Sf_BFu0i { unsigned char v1:7; empty v2; unsigned int :0; };
struct BFu7c_Sf_BFu0ll { unsigned char v1:7; empty v2; unsigned long long :0; };
struct BFu7c_Sf_BFu0s { unsigned char v1:7; empty v2; unsigned short :0; };
struct BFu7i_BFu0c_Sf { unsigned int v1:7; unsigned char :0; empty v2; };
struct BFu7i_BFu0i_Sf { unsigned int v1:7; unsigned int :0; empty v2; };
struct BFu7i_BFu0ll_Sf { unsigned int v1:7; unsigned long long :0; empty v2; };
struct BFu7i_BFu0s_Sf { unsigned int v1:7; unsigned short :0; empty v2; };
struct BFu7i_Sf_BFu0c { unsigned int v1:7; empty v2; unsigned char :0; };
struct BFu7i_Sf_BFu0i { unsigned int v1:7; empty v2; unsigned int :0; };
struct BFu7i_Sf_BFu0ll { unsigned int v1:7; empty v2; unsigned long long :0; };
struct BFu7i_Sf_BFu0s { unsigned int v1:7; empty v2; unsigned short :0; };
struct BFu7ll_BFu0c_Sf { unsigned long long v1:7; unsigned char :0; empty v2; };
struct BFu7ll_BFu0i_Sf { unsigned long long v1:7; unsigned int :0; empty v2; };
struct BFu7ll_BFu0ll_Sf { unsigned long long v1:7; unsigned long long :0; empty v2; };
struct BFu7ll_BFu0s_Sf { unsigned long long v1:7; unsigned short :0; empty v2; };
struct BFu7ll_Sf_BFu0c { unsigned long long v1:7; empty v2; unsigned char :0; };
struct BFu7ll_Sf_BFu0i { unsigned long long v1:7; empty v2; unsigned int :0; };
struct BFu7ll_Sf_BFu0ll { unsigned long long v1:7; empty v2; unsigned long long :0; };
struct BFu7ll_Sf_BFu0s { unsigned long long v1:7; empty v2; unsigned short :0; };
struct BFu7s_BFu0c_Sf { unsigned short v1:7; unsigned char :0; empty v2; };
struct BFu7s_BFu0i_Sf { unsigned short v1:7; unsigned int :0; empty v2; };
struct BFu7s_BFu0ll_Sf { unsigned short v1:7; unsigned long long :0; empty v2; };
struct BFu7s_BFu0s_Sf { unsigned short v1:7; unsigned short :0; empty v2; };
struct BFu7s_Sf_BFu0c { unsigned short v1:7; empty v2; unsigned char :0; };
struct BFu7s_Sf_BFu0i { unsigned short v1:7; empty v2; unsigned int :0; };
struct BFu7s_Sf_BFu0ll { unsigned short v1:7; empty v2; unsigned long long :0; };
struct BFu7s_Sf_BFu0s { unsigned short v1:7; empty v2; unsigned short :0; };
struct BFu8c_BFu0c_Sf { unsigned char v1:8; unsigned char :0; empty v2; };
struct BFu8c_BFu0i_Sf { unsigned char v1:8; unsigned int :0; empty v2; };
struct BFu8c_BFu0ll_Sf { unsigned char v1:8; unsigned long long :0; empty v2; };
struct BFu8c_BFu0s_Sf { unsigned char v1:8; unsigned short :0; empty v2; };
struct BFu8c_Sf_BFu0c { unsigned char v1:8; empty v2; unsigned char :0; };
struct BFu8c_Sf_BFu0i { unsigned char v1:8; empty v2; unsigned int :0; };
struct BFu8c_Sf_BFu0ll { unsigned char v1:8; empty v2; unsigned long long :0; };
struct BFu8c_Sf_BFu0s { unsigned char v1:8; empty v2; unsigned short :0; };
struct BFu8i_BFu0c_Sf { unsigned int v1:8; unsigned char :0; empty v2; };
struct BFu8i_BFu0i_Sf { unsigned int v1:8; unsigned int :0; empty v2; };
struct BFu8i_BFu0ll_Sf { unsigned int v1:8; unsigned long long :0; empty v2; };
struct BFu8i_BFu0s_Sf { unsigned int v1:8; unsigned short :0; empty v2; };
struct BFu8i_Sf_BFu0c { unsigned int v1:8; empty v2; unsigned char :0; };
struct BFu8i_Sf_BFu0i { unsigned int v1:8; empty v2; unsigned int :0; };
struct BFu8i_Sf_BFu0ll { unsigned int v1:8; empty v2; unsigned long long :0; };
struct BFu8i_Sf_BFu0s { unsigned int v1:8; empty v2; unsigned short :0; };
struct BFu8ll_BFu0c_Sf { unsigned long long v1:8; unsigned char :0; empty v2; };
struct BFu8ll_BFu0i_Sf { unsigned long long v1:8; unsigned int :0; empty v2; };
struct BFu8ll_BFu0ll_Sf { unsigned long long v1:8; unsigned long long :0; empty v2; };
struct BFu8ll_BFu0s_Sf { unsigned long long v1:8; unsigned short :0; empty v2; };
struct BFu8ll_Sf_BFu0c { unsigned long long v1:8; empty v2; unsigned char :0; };
struct BFu8ll_Sf_BFu0i { unsigned long long v1:8; empty v2; unsigned int :0; };
struct BFu8ll_Sf_BFu0ll { unsigned long long v1:8; empty v2; unsigned long long :0; };
struct BFu8ll_Sf_BFu0s { unsigned long long v1:8; empty v2; unsigned short :0; };
struct BFu8s_BFu0c_Sf { unsigned short v1:8; unsigned char :0; empty v2; };
struct BFu8s_BFu0i_Sf { unsigned short v1:8; unsigned int :0; empty v2; };
struct BFu8s_BFu0ll_Sf { unsigned short v1:8; unsigned long long :0; empty v2; };
struct BFu8s_BFu0s_Sf { unsigned short v1:8; unsigned short :0; empty v2; };
struct BFu8s_Sf_BFu0c { unsigned short v1:8; empty v2; unsigned char :0; };
struct BFu8s_Sf_BFu0i { unsigned short v1:8; empty v2; unsigned int :0; };
struct BFu8s_Sf_BFu0ll { unsigned short v1:8; empty v2; unsigned long long :0; };
struct BFu8s_Sf_BFu0s { unsigned short v1:8; empty v2; unsigned short :0; };
struct BFu9i_BFu0c_Sf { unsigned int v1:9; unsigned char :0; empty v2; };
struct BFu9i_BFu0i_Sf { unsigned int v1:9; unsigned int :0; empty v2; };
struct BFu9i_BFu0ll_Sf { unsigned int v1:9; unsigned long long :0; empty v2; };
struct BFu9i_BFu0s_Sf { unsigned int v1:9; unsigned short :0; empty v2; };
struct BFu9i_Sf_BFu0c { unsigned int v1:9; empty v2; unsigned char :0; };
struct BFu9i_Sf_BFu0i { unsigned int v1:9; empty v2; unsigned int :0; };
struct BFu9i_Sf_BFu0ll { unsigned int v1:9; empty v2; unsigned long long :0; };
struct BFu9i_Sf_BFu0s { unsigned int v1:9; empty v2; unsigned short :0; };
struct BFu9ll_BFu0c_Sf { unsigned long long v1:9; unsigned char :0; empty v2; };
struct BFu9ll_BFu0i_Sf { unsigned long long v1:9; unsigned int :0; empty v2; };
struct BFu9ll_BFu0ll_Sf { unsigned long long v1:9; unsigned long long :0; empty v2; };
struct BFu9ll_BFu0s_Sf { unsigned long long v1:9; unsigned short :0; empty v2; };
struct BFu9ll_Sf_BFu0c { unsigned long long v1:9; empty v2; unsigned char :0; };
struct BFu9ll_Sf_BFu0i { unsigned long long v1:9; empty v2; unsigned int :0; };
struct BFu9ll_Sf_BFu0ll { unsigned long long v1:9; empty v2; unsigned long long :0; };
struct BFu9ll_Sf_BFu0s { unsigned long long v1:9; empty v2; unsigned short :0; };
struct BFu9s_BFu0c_Sf { unsigned short v1:9; unsigned char :0; empty v2; };
struct BFu9s_BFu0i_Sf { unsigned short v1:9; unsigned int :0; empty v2; };
struct BFu9s_BFu0ll_Sf { unsigned short v1:9; unsigned long long :0; empty v2; };
struct BFu9s_BFu0s_Sf { unsigned short v1:9; unsigned short :0; empty v2; };
struct BFu9s_Sf_BFu0c { unsigned short v1:9; empty v2; unsigned char :0; };
struct BFu9s_Sf_BFu0i { unsigned short v1:9; empty v2; unsigned int :0; };
struct BFu9s_Sf_BFu0ll { unsigned short v1:9; empty v2; unsigned long long :0; };
struct BFu9s_Sf_BFu0s { unsigned short v1:9; empty v2; unsigned short :0; };
struct C_BFu0c_Sf { char v1; unsigned char :0; empty v2; };
struct C_BFu0i_Sf { char v1; unsigned int :0; empty v2; };
struct C_BFu0ll_Sf { char v1; unsigned long long :0; empty v2; };
struct C_BFu0s_Sf { char v1; unsigned short :0; empty v2; };
struct C_Sf_BFu0c { char v1; empty v2; unsigned char :0; };
struct C_Sf_BFu0i { char v1; empty v2; unsigned int :0; };
struct C_Sf_BFu0ll { char v1; empty v2; unsigned long long :0; };
struct C_Sf_BFu0s { char v1; empty v2; unsigned short :0; };
struct D_BFu0c_Sf { double v1; unsigned char :0; empty v2; };
struct D_BFu0i_Sf { double v1; unsigned int :0; empty v2; };
struct D_BFu0ll_Sf { double v1; unsigned long long :0; empty v2; };
struct D_BFu0s_Sf { double v1; unsigned short :0; empty v2; };
struct D_Sf_BFu0c { double v1; empty v2; unsigned char :0; };
struct D_Sf_BFu0i { double v1; empty v2; unsigned int :0; };
struct D_Sf_BFu0ll { double v1; empty v2; unsigned long long :0; };
struct D_Sf_BFu0s { double v1; empty v2; unsigned short :0; };
struct F_BFu0c_Sf { float v1; unsigned char :0; empty v2; };
struct F_BFu0i_Sf { float v1; unsigned int :0; empty v2; };
struct F_BFu0ll_Sf { float v1; unsigned long long :0; empty v2; };
struct F_BFu0s_Sf { float v1; unsigned short :0; empty v2; };
struct F_Sf_BFu0c { float v1; empty v2; unsigned char :0; };
struct F_Sf_BFu0i { float v1; empty v2; unsigned int :0; };
struct F_Sf_BFu0ll { float v1; empty v2; unsigned long long :0; };
struct F_Sf_BFu0s { float v1; empty v2; unsigned short :0; };
struct I_BFu0c_Sf { int v1; unsigned char :0; empty v2; };
struct I_BFu0i_Sf { int v1; unsigned int :0; empty v2; };
struct I_BFu0ll_Sf { int v1; unsigned long long :0; empty v2; };
struct I_BFu0s_Sf { int v1; unsigned short :0; empty v2; };
struct I_Sf_BFu0c { int v1; empty v2; unsigned char :0; };
struct I_Sf_BFu0i { int v1; empty v2; unsigned int :0; };
struct I_Sf_BFu0ll { int v1; empty v2; unsigned long long :0; };
struct I_Sf_BFu0s { int v1; empty v2; unsigned short :0; };
struct Ip_BFu0c_Sf { int * v1; unsigned char :0; empty v2; };
struct Ip_BFu0i_Sf { int * v1; unsigned int :0; empty v2; };
struct Ip_BFu0ll_Sf { int * v1; unsigned long long :0; empty v2; };
struct Ip_BFu0s_Sf { int * v1; unsigned short :0; empty v2; };
struct Ip_Sf_BFu0c { int * v1; empty v2; unsigned char :0; };
struct Ip_Sf_BFu0i { int * v1; empty v2; unsigned int :0; };
struct Ip_Sf_BFu0ll { int * v1; empty v2; unsigned long long :0; };
struct Ip_Sf_BFu0s { int * v1; empty v2; unsigned short :0; };
struct L_BFu0c_Sf { long long v1; unsigned char :0; empty v2; };
struct L_BFu0i_Sf { long long v1; unsigned int :0; empty v2; };
struct L_BFu0ll_Sf { long long v1; unsigned long long :0; empty v2; };
struct L_BFu0s_Sf { long long v1; unsigned short :0; empty v2; };
struct L_Sf_BFu0c { long long v1; empty v2; unsigned char :0; };
struct L_Sf_BFu0i { long long v1; empty v2; unsigned int :0; };
struct L_Sf_BFu0ll { long long v1; empty v2; unsigned long long :0; };
struct L_Sf_BFu0s { long long v1; empty v2; unsigned short :0; };
struct S_BFu0c_Sf { short v1; unsigned char :0; empty v2; };
struct S_BFu0i_Sf { short v1; unsigned int :0; empty v2; };
struct S_BFu0ll_Sf { short v1; unsigned long long :0; empty v2; };
struct S_BFu0s_Sf { short v1; unsigned short :0; empty v2; };
struct S_Sf_BFu0c { short v1; empty v2; unsigned char :0; };
struct S_Sf_BFu0i { short v1; empty v2; unsigned int :0; };
struct S_Sf_BFu0ll { short v1; empty v2; unsigned long long :0; };
struct S_Sf_BFu0s { short v1; empty v2; unsigned short :0; };
struct Sf_BFu0c { empty v1; unsigned char :0; };
struct Sf_BFu0c_BFu0c { empty v1; unsigned char :0; unsigned char :0; };
struct Sf_BFu0c_BFu0i { empty v1; unsigned char :0; unsigned int :0; };
struct Sf_BFu0c_BFu0ll { empty v1; unsigned char :0; unsigned long long :0; };
struct Sf_BFu0c_BFu0s { empty v1; unsigned char :0; unsigned short :0; };
struct Sf_BFu0c_BFu15i { empty v1; unsigned char :0; unsigned int v2:15; };
struct Sf_BFu0c_BFu15ll { empty v1; unsigned char :0; unsigned long long v2:15; };
struct Sf_BFu0c_BFu15s { empty v1; unsigned char :0; unsigned short v2:15; };
struct Sf_BFu0c_BFu16i { empty v1; unsigned char :0; unsigned int v2:16; };
struct Sf_BFu0c_BFu16ll { empty v1; unsigned char :0; unsigned long long v2:16; };
struct Sf_BFu0c_BFu16s { empty v1; unsigned char :0; unsigned short v2:16; };
struct Sf_BFu0c_BFu17i { empty v1; unsigned char :0; unsigned int v2:17; };
struct Sf_BFu0c_BFu17ll { empty v1; unsigned char :0; unsigned long long v2:17; };
struct Sf_BFu0c_BFu1c { empty v1; unsigned char :0; unsigned char v2:1; };
struct Sf_BFu0c_BFu1i { empty v1; unsigned char :0; unsigned int v2:1; };
struct Sf_BFu0c_BFu1ll { empty v1; unsigned char :0; unsigned long long v2:1; };
struct Sf_BFu0c_BFu1s { empty v1; unsigned char :0; unsigned short v2:1; };
struct Sf_BFu0c_BFu31i { empty v1; unsigned char :0; unsigned int v2:31; };
struct Sf_BFu0c_BFu31ll { empty v1; unsigned char :0; unsigned long long v2:31; };
struct Sf_BFu0c_BFu32i { empty v1; unsigned char :0; unsigned int v2:32; };
struct Sf_BFu0c_BFu32ll { empty v1; unsigned char :0; unsigned long long v2:32; };
struct Sf_BFu0c_BFu33 { empty v1; unsigned char :0; unsigned long long v2:33; };
struct Sf_BFu0c_BFu7c { empty v1; unsigned char :0; unsigned char v2:7; };
struct Sf_BFu0c_BFu7i { empty v1; unsigned char :0; unsigned int v2:7; };
struct Sf_BFu0c_BFu7ll { empty v1; unsigned char :0; unsigned long long v2:7; };
struct Sf_BFu0c_BFu7s { empty v1; unsigned char :0; unsigned short v2:7; };
struct Sf_BFu0c_BFu8c { empty v1; unsigned char :0; unsigned char v2:8; };
struct Sf_BFu0c_BFu8i { empty v1; unsigned char :0; unsigned int v2:8; };
struct Sf_BFu0c_BFu8ll { empty v1; unsigned char :0; unsigned long long v2:8; };
struct Sf_BFu0c_BFu8s { empty v1; unsigned char :0; unsigned short v2:8; };
struct Sf_BFu0c_BFu9i { empty v1; unsigned char :0; unsigned int v2:9; };
struct Sf_BFu0c_BFu9ll { empty v1; unsigned char :0; unsigned long long v2:9; };
struct Sf_BFu0c_BFu9s { empty v1; unsigned char :0; unsigned short v2:9; };
struct Sf_BFu0c_C { empty v1; unsigned char :0; char v2; };
struct Sf_BFu0c_D { empty v1; unsigned char :0; double v2; };
struct Sf_BFu0c_F { empty v1; unsigned char :0; float v2; };
struct Sf_BFu0c_I { empty v1; unsigned char :0; int v2; };
struct Sf_BFu0c_Ip { empty v1; unsigned char :0; int * v2; };
struct Sf_BFu0c_L { empty v1; unsigned char :0; long long v2; };
struct Sf_BFu0c_S { empty v1; unsigned char :0; short v2; };
struct Sf_BFu0c_Sf { empty v1; unsigned char :0; empty v2; };
struct Sf_BFu0c_Uc { empty v1; unsigned char :0; unsigned char v2; };
struct Sf_BFu0c_Ui { empty v1; unsigned char :0; unsigned int v2; };
struct Sf_BFu0c_Ul { empty v1; unsigned char :0; unsigned long long v2; };
struct Sf_BFu0c_Us { empty v1; unsigned char :0; unsigned short v2; };
struct Sf_BFu0c_Vp { empty v1; unsigned char :0; void * v2; };
struct Sf_BFu0i { empty v1; unsigned int :0; };
struct Sf_BFu0i_BFu0c { empty v1; unsigned int :0; unsigned char :0; };
struct Sf_BFu0i_BFu0i { empty v1; unsigned int :0; unsigned int :0; };
struct Sf_BFu0i_BFu0ll { empty v1; unsigned int :0; unsigned long long :0; };
struct Sf_BFu0i_BFu0s { empty v1; unsigned int :0; unsigned short :0; };
struct Sf_BFu0i_BFu15i { empty v1; unsigned int :0; unsigned int v2:15; };
struct Sf_BFu0i_BFu15ll { empty v1; unsigned int :0; unsigned long long v2:15; };
struct Sf_BFu0i_BFu15s { empty v1; unsigned int :0; unsigned short v2:15; };
struct Sf_BFu0i_BFu16i { empty v1; unsigned int :0; unsigned int v2:16; };
struct Sf_BFu0i_BFu16ll { empty v1; unsigned int :0; unsigned long long v2:16; };
struct Sf_BFu0i_BFu16s { empty v1; unsigned int :0; unsigned short v2:16; };
struct Sf_BFu0i_BFu17i { empty v1; unsigned int :0; unsigned int v2:17; };
struct Sf_BFu0i_BFu17ll { empty v1; unsigned int :0; unsigned long long v2:17; };
struct Sf_BFu0i_BFu1c { empty v1; unsigned int :0; unsigned char v2:1; };
struct Sf_BFu0i_BFu1i { empty v1; unsigned int :0; unsigned int v2:1; };
struct Sf_BFu0i_BFu1ll { empty v1; unsigned int :0; unsigned long long v2:1; };
struct Sf_BFu0i_BFu1s { empty v1; unsigned int :0; unsigned short v2:1; };
struct Sf_BFu0i_BFu31i { empty v1; unsigned int :0; unsigned int v2:31; };
struct Sf_BFu0i_BFu31ll { empty v1; unsigned int :0; unsigned long long v2:31; };
struct Sf_BFu0i_BFu32i { empty v1; unsigned int :0; unsigned int v2:32; };
struct Sf_BFu0i_BFu32ll { empty v1; unsigned int :0; unsigned long long v2:32; };
struct Sf_BFu0i_BFu33 { empty v1; unsigned int :0; unsigned long long v2:33; };
struct Sf_BFu0i_BFu7c { empty v1; unsigned int :0; unsigned char v2:7; };
struct Sf_BFu0i_BFu7i { empty v1; unsigned int :0; unsigned int v2:7; };
struct Sf_BFu0i_BFu7ll { empty v1; unsigned int :0; unsigned long long v2:7; };
struct Sf_BFu0i_BFu7s { empty v1; unsigned int :0; unsigned short v2:7; };
struct Sf_BFu0i_BFu8c { empty v1; unsigned int :0; unsigned char v2:8; };
struct Sf_BFu0i_BFu8i { empty v1; unsigned int :0; unsigned int v2:8; };
struct Sf_BFu0i_BFu8ll { empty v1; unsigned int :0; unsigned long long v2:8; };
struct Sf_BFu0i_BFu8s { empty v1; unsigned int :0; unsigned short v2:8; };
struct Sf_BFu0i_BFu9i { empty v1; unsigned int :0; unsigned int v2:9; };
struct Sf_BFu0i_BFu9ll { empty v1; unsigned int :0; unsigned long long v2:9; };
struct Sf_BFu0i_BFu9s { empty v1; unsigned int :0; unsigned short v2:9; };
struct Sf_BFu0i_C { empty v1; unsigned int :0; char v2; };
struct Sf_BFu0i_D { empty v1; unsigned int :0; double v2; };
struct Sf_BFu0i_F { empty v1; unsigned int :0; float v2; };
struct Sf_BFu0i_I { empty v1; unsigned int :0; int v2; };
struct Sf_BFu0i_Ip { empty v1; unsigned int :0; int * v2; };
struct Sf_BFu0i_L { empty v1; unsigned int :0; long long v2; };
struct Sf_BFu0i_S { empty v1; unsigned int :0; short v2; };
struct Sf_BFu0i_Sf { empty v1; unsigned int :0; empty v2; };
struct Sf_BFu0i_Uc { empty v1; unsigned int :0; unsigned char v2; };
struct Sf_BFu0i_Ui { empty v1; unsigned int :0; unsigned int v2; };
struct Sf_BFu0i_Ul { empty v1; unsigned int :0; unsigned long long v2; };
struct Sf_BFu0i_Us { empty v1; unsigned int :0; unsigned short v2; };
struct Sf_BFu0i_Vp { empty v1; unsigned int :0; void * v2; };
struct Sf_BFu0ll { empty v1; unsigned long long :0; };
struct Sf_BFu0ll_BFu0c { empty v1; unsigned long long :0; unsigned char :0; };
struct Sf_BFu0ll_BFu0i { empty v1; unsigned long long :0; unsigned int :0; };
struct Sf_BFu0ll_BFu0ll { empty v1; unsigned long long :0; unsigned long long :0; };
struct Sf_BFu0ll_BFu0s { empty v1; unsigned long long :0; unsigned short :0; };
struct Sf_BFu0ll_BFu15i { empty v1; unsigned long long :0; unsigned int v2:15; };
struct Sf_BFu0ll_BFu15ll { empty v1; unsigned long long :0; unsigned long long v2:15; };
struct Sf_BFu0ll_BFu15s { empty v1; unsigned long long :0; unsigned short v2:15; };
struct Sf_BFu0ll_BFu16i { empty v1; unsigned long long :0; unsigned int v2:16; };
struct Sf_BFu0ll_BFu16ll { empty v1; unsigned long long :0; unsigned long long v2:16; };
struct Sf_BFu0ll_BFu16s { empty v1; unsigned long long :0; unsigned short v2:16; };
struct Sf_BFu0ll_BFu17i { empty v1; unsigned long long :0; unsigned int v2:17; };
struct Sf_BFu0ll_BFu17ll { empty v1; unsigned long long :0; unsigned long long v2:17; };
struct Sf_BFu0ll_BFu1c { empty v1; unsigned long long :0; unsigned char v2:1; };
struct Sf_BFu0ll_BFu1i { empty v1; unsigned long long :0; unsigned int v2:1; };
struct Sf_BFu0ll_BFu1ll { empty v1; unsigned long long :0; unsigned long long v2:1; };
struct Sf_BFu0ll_BFu1s { empty v1; unsigned long long :0; unsigned short v2:1; };
struct Sf_BFu0ll_BFu31i { empty v1; unsigned long long :0; unsigned int v2:31; };
struct Sf_BFu0ll_BFu31ll { empty v1; unsigned long long :0; unsigned long long v2:31; };
struct Sf_BFu0ll_BFu32i { empty v1; unsigned long long :0; unsigned int v2:32; };
struct Sf_BFu0ll_BFu32ll { empty v1; unsigned long long :0; unsigned long long v2:32; };
struct Sf_BFu0ll_BFu33 { empty v1; unsigned long long :0; unsigned long long v2:33; };
struct Sf_BFu0ll_BFu7c { empty v1; unsigned long long :0; unsigned char v2:7; };
struct Sf_BFu0ll_BFu7i { empty v1; unsigned long long :0; unsigned int v2:7; };
struct Sf_BFu0ll_BFu7ll { empty v1; unsigned long long :0; unsigned long long v2:7; };
struct Sf_BFu0ll_BFu7s { empty v1; unsigned long long :0; unsigned short v2:7; };
struct Sf_BFu0ll_BFu8c { empty v1; unsigned long long :0; unsigned char v2:8; };
struct Sf_BFu0ll_BFu8i { empty v1; unsigned long long :0; unsigned int v2:8; };
struct Sf_BFu0ll_BFu8ll { empty v1; unsigned long long :0; unsigned long long v2:8; };
struct Sf_BFu0ll_BFu8s { empty v1; unsigned long long :0; unsigned short v2:8; };
struct Sf_BFu0ll_BFu9i { empty v1; unsigned long long :0; unsigned int v2:9; };
struct Sf_BFu0ll_BFu9ll { empty v1; unsigned long long :0; unsigned long long v2:9; };
struct Sf_BFu0ll_BFu9s { empty v1; unsigned long long :0; unsigned short v2:9; };
struct Sf_BFu0ll_C { empty v1; unsigned long long :0; char v2; };
struct Sf_BFu0ll_D { empty v1; unsigned long long :0; double v2; };
struct Sf_BFu0ll_F { empty v1; unsigned long long :0; float v2; };
struct Sf_BFu0ll_I { empty v1; unsigned long long :0; int v2; };
struct Sf_BFu0ll_Ip { empty v1; unsigned long long :0; int * v2; };
struct Sf_BFu0ll_L { empty v1; unsigned long long :0; long long v2; };
struct Sf_BFu0ll_S { empty v1; unsigned long long :0; short v2; };
struct Sf_BFu0ll_Sf { empty v1; unsigned long long :0; empty v2; };
struct Sf_BFu0ll_Uc { empty v1; unsigned long long :0; unsigned char v2; };
struct Sf_BFu0ll_Ui { empty v1; unsigned long long :0; unsigned int v2; };
struct Sf_BFu0ll_Ul { empty v1; unsigned long long :0; unsigned long long v2; };
struct Sf_BFu0ll_Us { empty v1; unsigned long long :0; unsigned short v2; };
struct Sf_BFu0ll_Vp { empty v1; unsigned long long :0; void * v2; };
struct Sf_BFu0s { empty v1; unsigned short :0; };
struct Sf_BFu0s_BFu0c { empty v1; unsigned short :0; unsigned char :0; };
struct Sf_BFu0s_BFu0i { empty v1; unsigned short :0; unsigned int :0; };
struct Sf_BFu0s_BFu0ll { empty v1; unsigned short :0; unsigned long long :0; };
struct Sf_BFu0s_BFu0s { empty v1; unsigned short :0; unsigned short :0; };
struct Sf_BFu0s_BFu15i { empty v1; unsigned short :0; unsigned int v2:15; };
struct Sf_BFu0s_BFu15ll { empty v1; unsigned short :0; unsigned long long v2:15; };
struct Sf_BFu0s_BFu15s { empty v1; unsigned short :0; unsigned short v2:15; };
struct Sf_BFu0s_BFu16i { empty v1; unsigned short :0; unsigned int v2:16; };
struct Sf_BFu0s_BFu16ll { empty v1; unsigned short :0; unsigned long long v2:16; };
struct Sf_BFu0s_BFu16s { empty v1; unsigned short :0; unsigned short v2:16; };
struct Sf_BFu0s_BFu17i { empty v1; unsigned short :0; unsigned int v2:17; };
struct Sf_BFu0s_BFu17ll { empty v1; unsigned short :0; unsigned long long v2:17; };
struct Sf_BFu0s_BFu1c { empty v1; unsigned short :0; unsigned char v2:1; };
struct Sf_BFu0s_BFu1i { empty v1; unsigned short :0; unsigned int v2:1; };
struct Sf_BFu0s_BFu1ll { empty v1; unsigned short :0; unsigned long long v2:1; };
struct Sf_BFu0s_BFu1s { empty v1; unsigned short :0; unsigned short v2:1; };
struct Sf_BFu0s_BFu31i { empty v1; unsigned short :0; unsigned int v2:31; };
struct Sf_BFu0s_BFu31ll { empty v1; unsigned short :0; unsigned long long v2:31; };
struct Sf_BFu0s_BFu32i { empty v1; unsigned short :0; unsigned int v2:32; };
struct Sf_BFu0s_BFu32ll { empty v1; unsigned short :0; unsigned long long v2:32; };
struct Sf_BFu0s_BFu33 { empty v1; unsigned short :0; unsigned long long v2:33; };
struct Sf_BFu0s_BFu7c { empty v1; unsigned short :0; unsigned char v2:7; };
struct Sf_BFu0s_BFu7i { empty v1; unsigned short :0; unsigned int v2:7; };
struct Sf_BFu0s_BFu7ll { empty v1; unsigned short :0; unsigned long long v2:7; };
struct Sf_BFu0s_BFu7s { empty v1; unsigned short :0; unsigned short v2:7; };
struct Sf_BFu0s_BFu8c { empty v1; unsigned short :0; unsigned char v2:8; };
struct Sf_BFu0s_BFu8i { empty v1; unsigned short :0; unsigned int v2:8; };
struct Sf_BFu0s_BFu8ll { empty v1; unsigned short :0; unsigned long long v2:8; };
struct Sf_BFu0s_BFu8s { empty v1; unsigned short :0; unsigned short v2:8; };
struct Sf_BFu0s_BFu9i { empty v1; unsigned short :0; unsigned int v2:9; };
struct Sf_BFu0s_BFu9ll { empty v1; unsigned short :0; unsigned long long v2:9; };
struct Sf_BFu0s_BFu9s { empty v1; unsigned short :0; unsigned short v2:9; };
struct Sf_BFu0s_C { empty v1; unsigned short :0; char v2; };
struct Sf_BFu0s_D { empty v1; unsigned short :0; double v2; };
struct Sf_BFu0s_F { empty v1; unsigned short :0; float v2; };
struct Sf_BFu0s_I { empty v1; unsigned short :0; int v2; };
struct Sf_BFu0s_Ip { empty v1; unsigned short :0; int * v2; };
struct Sf_BFu0s_L { empty v1; unsigned short :0; long long v2; };
struct Sf_BFu0s_S { empty v1; unsigned short :0; short v2; };
struct Sf_BFu0s_Sf { empty v1; unsigned short :0; empty v2; };
struct Sf_BFu0s_Uc { empty v1; unsigned short :0; unsigned char v2; };
struct Sf_BFu0s_Ui { empty v1; unsigned short :0; unsigned int v2; };
struct Sf_BFu0s_Ul { empty v1; unsigned short :0; unsigned long long v2; };
struct Sf_BFu0s_Us { empty v1; unsigned short :0; unsigned short v2; };
struct Sf_BFu0s_Vp { empty v1; unsigned short :0; void * v2; };
struct Sf_BFu15i_BFu0c { empty v1; unsigned int v2:15; unsigned char :0; };
struct Sf_BFu15i_BFu0i { empty v1; unsigned int v2:15; unsigned int :0; };
struct Sf_BFu15i_BFu0ll { empty v1; unsigned int v2:15; unsigned long long :0; };
struct Sf_BFu15i_BFu0s { empty v1; unsigned int v2:15; unsigned short :0; };
struct Sf_BFu15ll_BFu0c { empty v1; unsigned long long v2:15; unsigned char :0; };
struct Sf_BFu15ll_BFu0i { empty v1; unsigned long long v2:15; unsigned int :0; };
struct Sf_BFu15ll_BFu0ll { empty v1; unsigned long long v2:15; unsigned long long :0; };
struct Sf_BFu15ll_BFu0s { empty v1; unsigned long long v2:15; unsigned short :0; };
struct Sf_BFu15s_BFu0c { empty v1; unsigned short v2:15; unsigned char :0; };
struct Sf_BFu15s_BFu0i { empty v1; unsigned short v2:15; unsigned int :0; };
struct Sf_BFu15s_BFu0ll { empty v1; unsigned short v2:15; unsigned long long :0; };
struct Sf_BFu15s_BFu0s { empty v1; unsigned short v2:15; unsigned short :0; };
struct Sf_BFu16i_BFu0c { empty v1; unsigned int v2:16; unsigned char :0; };
struct Sf_BFu16i_BFu0i { empty v1; unsigned int v2:16; unsigned int :0; };
struct Sf_BFu16i_BFu0ll { empty v1; unsigned int v2:16; unsigned long long :0; };
struct Sf_BFu16i_BFu0s { empty v1; unsigned int v2:16; unsigned short :0; };
struct Sf_BFu16ll_BFu0c { empty v1; unsigned long long v2:16; unsigned char :0; };
struct Sf_BFu16ll_BFu0i { empty v1; unsigned long long v2:16; unsigned int :0; };
struct Sf_BFu16ll_BFu0ll { empty v1; unsigned long long v2:16; unsigned long long :0; };
struct Sf_BFu16ll_BFu0s { empty v1; unsigned long long v2:16; unsigned short :0; };
struct Sf_BFu16s_BFu0c { empty v1; unsigned short v2:16; unsigned char :0; };
struct Sf_BFu16s_BFu0i { empty v1; unsigned short v2:16; unsigned int :0; };
struct Sf_BFu16s_BFu0ll { empty v1; unsigned short v2:16; unsigned long long :0; };
struct Sf_BFu16s_BFu0s { empty v1; unsigned short v2:16; unsigned short :0; };
struct Sf_BFu17i_BFu0c { empty v1; unsigned int v2:17; unsigned char :0; };
struct Sf_BFu17i_BFu0i { empty v1; unsigned int v2:17; unsigned int :0; };
struct Sf_BFu17i_BFu0ll { empty v1; unsigned int v2:17; unsigned long long :0; };
struct Sf_BFu17i_BFu0s { empty v1; unsigned int v2:17; unsigned short :0; };
struct Sf_BFu17ll_BFu0c { empty v1; unsigned long long v2:17; unsigned char :0; };
struct Sf_BFu17ll_BFu0i { empty v1; unsigned long long v2:17; unsigned int :0; };
struct Sf_BFu17ll_BFu0ll { empty v1; unsigned long long v2:17; unsigned long long :0; };
struct Sf_BFu17ll_BFu0s { empty v1; unsigned long long v2:17; unsigned short :0; };
struct Sf_BFu1c_BFu0c { empty v1; unsigned char v2:1; unsigned char :0; };
struct Sf_BFu1c_BFu0i { empty v1; unsigned char v2:1; unsigned int :0; };
struct Sf_BFu1c_BFu0ll { empty v1; unsigned char v2:1; unsigned long long :0; };
struct Sf_BFu1c_BFu0s { empty v1; unsigned char v2:1; unsigned short :0; };
struct Sf_BFu1i_BFu0c { empty v1; unsigned int v2:1; unsigned char :0; };
struct Sf_BFu1i_BFu0i { empty v1; unsigned int v2:1; unsigned int :0; };
struct Sf_BFu1i_BFu0ll { empty v1; unsigned int v2:1; unsigned long long :0; };
struct Sf_BFu1i_BFu0s { empty v1; unsigned int v2:1; unsigned short :0; };
struct Sf_BFu1ll_BFu0c { empty v1; unsigned long long v2:1; unsigned char :0; };
struct Sf_BFu1ll_BFu0i { empty v1; unsigned long long v2:1; unsigned int :0; };
struct Sf_BFu1ll_BFu0ll { empty v1; unsigned long long v2:1; unsigned long long :0; };
struct Sf_BFu1ll_BFu0s { empty v1; unsigned long long v2:1; unsigned short :0; };
struct Sf_BFu1s_BFu0c { empty v1; unsigned short v2:1; unsigned char :0; };
struct Sf_BFu1s_BFu0i { empty v1; unsigned short v2:1; unsigned int :0; };
struct Sf_BFu1s_BFu0ll { empty v1; unsigned short v2:1; unsigned long long :0; };
struct Sf_BFu1s_BFu0s { empty v1; unsigned short v2:1; unsigned short :0; };
struct Sf_BFu31i_BFu0c { empty v1; unsigned int v2:31; unsigned char :0; };
struct Sf_BFu31i_BFu0i { empty v1; unsigned int v2:31; unsigned int :0; };
struct Sf_BFu31i_BFu0ll { empty v1; unsigned int v2:31; unsigned long long :0; };
struct Sf_BFu31i_BFu0s { empty v1; unsigned int v2:31; unsigned short :0; };
struct Sf_BFu31ll_BFu0c { empty v1; unsigned long long v2:31; unsigned char :0; };
struct Sf_BFu31ll_BFu0i { empty v1; unsigned long long v2:31; unsigned int :0; };
struct Sf_BFu31ll_BFu0ll { empty v1; unsigned long long v2:31; unsigned long long :0; };
struct Sf_BFu31ll_BFu0s { empty v1; unsigned long long v2:31; unsigned short :0; };
struct Sf_BFu32i_BFu0c { empty v1; unsigned int v2:32; unsigned char :0; };
struct Sf_BFu32i_BFu0i { empty v1; unsigned int v2:32; unsigned int :0; };
struct Sf_BFu32i_BFu0ll { empty v1; unsigned int v2:32; unsigned long long :0; };
struct Sf_BFu32i_BFu0s { empty v1; unsigned int v2:32; unsigned short :0; };
struct Sf_BFu32ll_BFu0c { empty v1; unsigned long long v2:32; unsigned char :0; };
struct Sf_BFu32ll_BFu0i { empty v1; unsigned long long v2:32; unsigned int :0; };
struct Sf_BFu32ll_BFu0ll { empty v1; unsigned long long v2:32; unsigned long long :0; };
struct Sf_BFu32ll_BFu0s { empty v1; unsigned long long v2:32; unsigned short :0; };
struct Sf_BFu33_BFu0c { empty v1; unsigned long long v2:33; unsigned char :0; };
struct Sf_BFu33_BFu0i { empty v1; unsigned long long v2:33; unsigned int :0; };
struct Sf_BFu33_BFu0ll { empty v1; unsigned long long v2:33; unsigned long long :0; };
struct Sf_BFu33_BFu0s { empty v1; unsigned long long v2:33; unsigned short :0; };
struct Sf_BFu7c_BFu0c { empty v1; unsigned char v2:7; unsigned char :0; };
struct Sf_BFu7c_BFu0i { empty v1; unsigned char v2:7; unsigned int :0; };
struct Sf_BFu7c_BFu0ll { empty v1; unsigned char v2:7; unsigned long long :0; };
struct Sf_BFu7c_BFu0s { empty v1; unsigned char v2:7; unsigned short :0; };
struct Sf_BFu7i_BFu0c { empty v1; unsigned int v2:7; unsigned char :0; };
struct Sf_BFu7i_BFu0i { empty v1; unsigned int v2:7; unsigned int :0; };
struct Sf_BFu7i_BFu0ll { empty v1; unsigned int v2:7; unsigned long long :0; };
struct Sf_BFu7i_BFu0s { empty v1; unsigned int v2:7; unsigned short :0; };
struct Sf_BFu7ll_BFu0c { empty v1; unsigned long long v2:7; unsigned char :0; };
struct Sf_BFu7ll_BFu0i { empty v1; unsigned long long v2:7; unsigned int :0; };
struct Sf_BFu7ll_BFu0ll { empty v1; unsigned long long v2:7; unsigned long long :0; };
struct Sf_BFu7ll_BFu0s { empty v1; unsigned long long v2:7; unsigned short :0; };
struct Sf_BFu7s_BFu0c { empty v1; unsigned short v2:7; unsigned char :0; };
struct Sf_BFu7s_BFu0i { empty v1; unsigned short v2:7; unsigned int :0; };
struct Sf_BFu7s_BFu0ll { empty v1; unsigned short v2:7; unsigned long long :0; };
struct Sf_BFu7s_BFu0s { empty v1; unsigned short v2:7; unsigned short :0; };
struct Sf_BFu8c_BFu0c { empty v1; unsigned char v2:8; unsigned char :0; };
struct Sf_BFu8c_BFu0i { empty v1; unsigned char v2:8; unsigned int :0; };
struct Sf_BFu8c_BFu0ll { empty v1; unsigned char v2:8; unsigned long long :0; };
struct Sf_BFu8c_BFu0s { empty v1; unsigned char v2:8; unsigned short :0; };
struct Sf_BFu8i_BFu0c { empty v1; unsigned int v2:8; unsigned char :0; };
struct Sf_BFu8i_BFu0i { empty v1; unsigned int v2:8; unsigned int :0; };
struct Sf_BFu8i_BFu0ll { empty v1; unsigned int v2:8; unsigned long long :0; };
struct Sf_BFu8i_BFu0s { empty v1; unsigned int v2:8; unsigned short :0; };
struct Sf_BFu8ll_BFu0c { empty v1; unsigned long long v2:8; unsigned char :0; };
struct Sf_BFu8ll_BFu0i { empty v1; unsigned long long v2:8; unsigned int :0; };
struct Sf_BFu8ll_BFu0ll { empty v1; unsigned long long v2:8; unsigned long long :0; };
struct Sf_BFu8ll_BFu0s { empty v1; unsigned long long v2:8; unsigned short :0; };
struct Sf_BFu8s_BFu0c { empty v1; unsigned short v2:8; unsigned char :0; };
struct Sf_BFu8s_BFu0i { empty v1; unsigned short v2:8; unsigned int :0; };
struct Sf_BFu8s_BFu0ll { empty v1; unsigned short v2:8; unsigned long long :0; };
struct Sf_BFu8s_BFu0s { empty v1; unsigned short v2:8; unsigned short :0; };
struct Sf_BFu9i_BFu0c { empty v1; unsigned int v2:9; unsigned char :0; };
struct Sf_BFu9i_BFu0i { empty v1; unsigned int v2:9; unsigned int :0; };
struct Sf_BFu9i_BFu0ll { empty v1; unsigned int v2:9; unsigned long long :0; };
struct Sf_BFu9i_BFu0s { empty v1; unsigned int v2:9; unsigned short :0; };
struct Sf_BFu9ll_BFu0c { empty v1; unsigned long long v2:9; unsigned char :0; };
struct Sf_BFu9ll_BFu0i { empty v1; unsigned long long v2:9; unsigned int :0; };
struct Sf_BFu9ll_BFu0ll { empty v1; unsigned long long v2:9; unsigned long long :0; };
struct Sf_BFu9ll_BFu0s { empty v1; unsigned long long v2:9; unsigned short :0; };
struct Sf_BFu9s_BFu0c { empty v1; unsigned short v2:9; unsigned char :0; };
struct Sf_BFu9s_BFu0i { empty v1; unsigned short v2:9; unsigned int :0; };
struct Sf_BFu9s_BFu0ll { empty v1; unsigned short v2:9; unsigned long long :0; };
struct Sf_BFu9s_BFu0s { empty v1; unsigned short v2:9; unsigned short :0; };
struct Sf_C_BFu0c { empty v1; char v2; unsigned char :0; };
struct Sf_C_BFu0i { empty v1; char v2; unsigned int :0; };
struct Sf_C_BFu0ll { empty v1; char v2; unsigned long long :0; };
struct Sf_C_BFu0s { empty v1; char v2; unsigned short :0; };
struct Sf_D_BFu0c { empty v1; double v2; unsigned char :0; };
struct Sf_D_BFu0i { empty v1; double v2; unsigned int :0; };
struct Sf_D_BFu0ll { empty v1; double v2; unsigned long long :0; };
struct Sf_D_BFu0s { empty v1; double v2; unsigned short :0; };
struct Sf_F_BFu0c { empty v1; float v2; unsigned char :0; };
struct Sf_F_BFu0i { empty v1; float v2; unsigned int :0; };
struct Sf_F_BFu0ll { empty v1; float v2; unsigned long long :0; };
struct Sf_F_BFu0s { empty v1; float v2; unsigned short :0; };
struct Sf_I_BFu0c { empty v1; int v2; unsigned char :0; };
struct Sf_I_BFu0i { empty v1; int v2; unsigned int :0; };
struct Sf_I_BFu0ll { empty v1; int v2; unsigned long long :0; };
struct Sf_I_BFu0s { empty v1; int v2; unsigned short :0; };
struct Sf_Ip_BFu0c { empty v1; int * v2; unsigned char :0; };
struct Sf_Ip_BFu0i { empty v1; int * v2; unsigned int :0; };
struct Sf_Ip_BFu0ll { empty v1; int * v2; unsigned long long :0; };
struct Sf_Ip_BFu0s { empty v1; int * v2; unsigned short :0; };
struct Sf_L_BFu0c { empty v1; long long v2; unsigned char :0; };
struct Sf_L_BFu0i { empty v1; long long v2; unsigned int :0; };
struct Sf_L_BFu0ll { empty v1; long long v2; unsigned long long :0; };
struct Sf_L_BFu0s { empty v1; long long v2; unsigned short :0; };
struct Sf_S_BFu0c { empty v1; short v2; unsigned char :0; };
struct Sf_S_BFu0i { empty v1; short v2; unsigned int :0; };
struct Sf_S_BFu0ll { empty v1; short v2; unsigned long long :0; };
struct Sf_S_BFu0s { empty v1; short v2; unsigned short :0; };
struct Sf_Sf_BFu0c { empty v1; empty v2; unsigned char :0; };
struct Sf_Sf_BFu0i { empty v1; empty v2; unsigned int :0; };
struct Sf_Sf_BFu0ll { empty v1; empty v2; unsigned long long :0; };
struct Sf_Sf_BFu0s { empty v1; empty v2; unsigned short :0; };
struct Sf_Uc_BFu0c { empty v1; unsigned char v2; unsigned char :0; };
struct Sf_Uc_BFu0i { empty v1; unsigned char v2; unsigned int :0; };
struct Sf_Uc_BFu0ll { empty v1; unsigned char v2; unsigned long long :0; };
struct Sf_Uc_BFu0s { empty v1; unsigned char v2; unsigned short :0; };
struct Sf_Ui_BFu0c { empty v1; unsigned int v2; unsigned char :0; };
struct Sf_Ui_BFu0i { empty v1; unsigned int v2; unsigned int :0; };
struct Sf_Ui_BFu0ll { empty v1; unsigned int v2; unsigned long long :0; };
struct Sf_Ui_BFu0s { empty v1; unsigned int v2; unsigned short :0; };
struct Sf_Ul_BFu0c { empty v1; unsigned long long v2; unsigned char :0; };
struct Sf_Ul_BFu0i { empty v1; unsigned long long v2; unsigned int :0; };
struct Sf_Ul_BFu0ll { empty v1; unsigned long long v2; unsigned long long :0; };
struct Sf_Ul_BFu0s { empty v1; unsigned long long v2; unsigned short :0; };
struct Sf_Us_BFu0c { empty v1; unsigned short v2; unsigned char :0; };
struct Sf_Us_BFu0i { empty v1; unsigned short v2; unsigned int :0; };
struct Sf_Us_BFu0ll { empty v1; unsigned short v2; unsigned long long :0; };
struct Sf_Us_BFu0s { empty v1; unsigned short v2; unsigned short :0; };
struct Sf_Vp_BFu0c { empty v1; void * v2; unsigned char :0; };
struct Sf_Vp_BFu0i { empty v1; void * v2; unsigned int :0; };
struct Sf_Vp_BFu0ll { empty v1; void * v2; unsigned long long :0; };
struct Sf_Vp_BFu0s { empty v1; void * v2; unsigned short :0; };
struct Uc_BFu0c_Sf { unsigned char v1; unsigned char :0; empty v2; };
struct Uc_BFu0i_Sf { unsigned char v1; unsigned int :0; empty v2; };
struct Uc_BFu0ll_Sf { unsigned char v1; unsigned long long :0; empty v2; };
struct Uc_BFu0s_Sf { unsigned char v1; unsigned short :0; empty v2; };
struct Uc_Sf_BFu0c { unsigned char v1; empty v2; unsigned char :0; };
struct Uc_Sf_BFu0i { unsigned char v1; empty v2; unsigned int :0; };
struct Uc_Sf_BFu0ll { unsigned char v1; empty v2; unsigned long long :0; };
struct Uc_Sf_BFu0s { unsigned char v1; empty v2; unsigned short :0; };
struct Ui_BFu0c_Sf { unsigned int v1; unsigned char :0; empty v2; };
struct Ui_BFu0i_Sf { unsigned int v1; unsigned int :0; empty v2; };
struct Ui_BFu0ll_Sf { unsigned int v1; unsigned long long :0; empty v2; };
struct Ui_BFu0s_Sf { unsigned int v1; unsigned short :0; empty v2; };
struct Ui_Sf_BFu0c { unsigned int v1; empty v2; unsigned char :0; };
struct Ui_Sf_BFu0i { unsigned int v1; empty v2; unsigned int :0; };
struct Ui_Sf_BFu0ll { unsigned int v1; empty v2; unsigned long long :0; };
struct Ui_Sf_BFu0s { unsigned int v1; empty v2; unsigned short :0; };
struct Ul_BFu0c_Sf { unsigned long long v1; unsigned char :0; empty v2; };
struct Ul_BFu0i_Sf { unsigned long long v1; unsigned int :0; empty v2; };
struct Ul_BFu0ll_Sf { unsigned long long v1; unsigned long long :0; empty v2; };
struct Ul_BFu0s_Sf { unsigned long long v1; unsigned short :0; empty v2; };
struct Ul_Sf_BFu0c { unsigned long long v1; empty v2; unsigned char :0; };
struct Ul_Sf_BFu0i { unsigned long long v1; empty v2; unsigned int :0; };
struct Ul_Sf_BFu0ll { unsigned long long v1; empty v2; unsigned long long :0; };
struct Ul_Sf_BFu0s { unsigned long long v1; empty v2; unsigned short :0; };
struct Us_BFu0c_Sf { unsigned short v1; unsigned char :0; empty v2; };
struct Us_BFu0i_Sf { unsigned short v1; unsigned int :0; empty v2; };
struct Us_BFu0ll_Sf { unsigned short v1; unsigned long long :0; empty v2; };
struct Us_BFu0s_Sf { unsigned short v1; unsigned short :0; empty v2; };
struct Us_Sf_BFu0c { unsigned short v1; empty v2; unsigned char :0; };
struct Us_Sf_BFu0i { unsigned short v1; empty v2; unsigned int :0; };
struct Us_Sf_BFu0ll { unsigned short v1; empty v2; unsigned long long :0; };
struct Us_Sf_BFu0s { unsigned short v1; empty v2; unsigned short :0; };
struct Vp_BFu0c_Sf { void * v1; unsigned char :0; empty v2; };
struct Vp_BFu0i_Sf { void * v1; unsigned int :0; empty v2; };
struct Vp_BFu0ll_Sf { void * v1; unsigned long long :0; empty v2; };
struct Vp_BFu0s_Sf { void * v1; unsigned short :0; empty v2; };
struct Vp_Sf_BFu0c { void * v1; empty v2; unsigned char :0; };
struct Vp_Sf_BFu0i { void * v1; empty v2; unsigned int :0; };
struct Vp_Sf_BFu0ll { void * v1; empty v2; unsigned long long :0; };
struct Vp_Sf_BFu0s { void * v1; empty v2; unsigned short :0; };


static void Test_empty()
{
  {
    init_simple_test("empty");
    STRUCT_IF_C empty lv;
    check2(sizeof(lv), 0, "sizeof(empty)");
    check2(__alignof__(lv), 1, "__alignof__(empty)");
  }
}
ARRANGE_TO_CALL_ME(Test_empty, empty)
//============================================================================



static void Test_aBFu0c_BFu0c_Sf()
{
  {
    init_simple_test("aBFu0c_BFu0c_Sf");
    static STRUCT_IF_C aBFu0c_BFu0c_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0c_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_BFu0c_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu0c_Sf, aBFu0c_BFu0c_Sf)
//============================================================================



static void Test_aBFu0c_BFu0i_Sf()
{
  {
    init_simple_test("aBFu0c_BFu0i_Sf");
    static STRUCT_IF_C aBFu0c_BFu0i_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0c_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_BFu0i_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu0i_Sf, aBFu0c_BFu0i_Sf)
//============================================================================



static void Test_aBFu0c_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu0c_BFu0ll_Sf");
    static STRUCT_IF_C aBFu0c_BFu0ll_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0c_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_BFu0ll_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu0ll_Sf, aBFu0c_BFu0ll_Sf)
//============================================================================



static void Test_aBFu0c_BFu0s_Sf()
{
  {
    init_simple_test("aBFu0c_BFu0s_Sf");
    static STRUCT_IF_C aBFu0c_BFu0s_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0c_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_BFu0s_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu0s_Sf, aBFu0c_BFu0s_Sf)
//============================================================================



static void Test_aBFu0c_BFu15i_Sf()
{
  {
    init_simple_test("aBFu0c_BFu15i_Sf");
    static STRUCT_IF_C aBFu0c_BFu15i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0c_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0c_BFu15i_Sf");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu15i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu15i_Sf, aBFu0c_BFu15i_Sf)
//============================================================================



static void Test_aBFu0c_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu0c_BFu15ll_Sf");
    static STRUCT_IF_C aBFu0c_BFu15ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0c_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0c_BFu15ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu15ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu15ll_Sf, aBFu0c_BFu15ll_Sf)
//============================================================================



static void Test_aBFu0c_BFu15s_Sf()
{
  {
    init_simple_test("aBFu0c_BFu15s_Sf");
    static STRUCT_IF_C aBFu0c_BFu15s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0c_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0c_BFu15s_Sf");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu15s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu15s_Sf, aBFu0c_BFu15s_Sf)
//============================================================================



static void Test_aBFu0c_BFu16i_Sf()
{
  {
    init_simple_test("aBFu0c_BFu16i_Sf");
    static STRUCT_IF_C aBFu0c_BFu16i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0c_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0c_BFu16i_Sf");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu16i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu16i_Sf, aBFu0c_BFu16i_Sf)
//============================================================================



static void Test_aBFu0c_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu0c_BFu16ll_Sf");
    static STRUCT_IF_C aBFu0c_BFu16ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0c_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0c_BFu16ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu16ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu16ll_Sf, aBFu0c_BFu16ll_Sf)
//============================================================================



static void Test_aBFu0c_BFu16s_Sf()
{
  {
    init_simple_test("aBFu0c_BFu16s_Sf");
    static STRUCT_IF_C aBFu0c_BFu16s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0c_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0c_BFu16s_Sf");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu16s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu16s_Sf, aBFu0c_BFu16s_Sf)
//============================================================================



static void Test_aBFu0c_BFu17i_Sf()
{
  {
    init_simple_test("aBFu0c_BFu17i_Sf");
    static STRUCT_IF_C aBFu0c_BFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0c_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0c_BFu17i_Sf");
    check_field_offset(lv, v2, 3, "aBFu0c_BFu17i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu17i_Sf, aBFu0c_BFu17i_Sf)
//============================================================================



static void Test_aBFu0c_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu0c_BFu17ll_Sf");
    static STRUCT_IF_C aBFu0c_BFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0c_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0c_BFu17ll_Sf");
    check_field_offset(lv, v2, 3, "aBFu0c_BFu17ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu17ll_Sf, aBFu0c_BFu17ll_Sf)
//============================================================================



static void Test_aBFu0c_BFu1c_Sf()
{
  {
    init_simple_test("aBFu0c_BFu1c_Sf");
    static STRUCT_IF_C aBFu0c_BFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0c_BFu1c_Sf");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu1c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu1c_Sf, aBFu0c_BFu1c_Sf)
//============================================================================



static void Test_aBFu0c_BFu1i_Sf()
{
  {
    init_simple_test("aBFu0c_BFu1i_Sf");
    static STRUCT_IF_C aBFu0c_BFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0c_BFu1i_Sf");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu1i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu1i_Sf, aBFu0c_BFu1i_Sf)
//============================================================================



static void Test_aBFu0c_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu0c_BFu1ll_Sf");
    static STRUCT_IF_C aBFu0c_BFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0c_BFu1ll_Sf");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu1ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu1ll_Sf, aBFu0c_BFu1ll_Sf)
//============================================================================



static void Test_aBFu0c_BFu1s_Sf()
{
  {
    init_simple_test("aBFu0c_BFu1s_Sf");
    static STRUCT_IF_C aBFu0c_BFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0c_BFu1s_Sf");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu1s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu1s_Sf, aBFu0c_BFu1s_Sf)
//============================================================================



static void Test_aBFu0c_BFu31i_Sf()
{
  {
    init_simple_test("aBFu0c_BFu31i_Sf");
    static STRUCT_IF_C aBFu0c_BFu31i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0c_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0c_BFu31i_Sf");
    check_field_offset(lv, v2, 4, "aBFu0c_BFu31i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu31i_Sf, aBFu0c_BFu31i_Sf)
//============================================================================



static void Test_aBFu0c_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu0c_BFu31ll_Sf");
    static STRUCT_IF_C aBFu0c_BFu31ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0c_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0c_BFu31ll_Sf");
    check_field_offset(lv, v2, 4, "aBFu0c_BFu31ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu31ll_Sf, aBFu0c_BFu31ll_Sf)
//============================================================================



static void Test_aBFu0c_BFu32i_Sf()
{
  {
    init_simple_test("aBFu0c_BFu32i_Sf");
    static STRUCT_IF_C aBFu0c_BFu32i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0c_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0c_BFu32i_Sf");
    check_field_offset(lv, v2, 4, "aBFu0c_BFu32i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu32i_Sf, aBFu0c_BFu32i_Sf)
//============================================================================



static void Test_aBFu0c_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu0c_BFu32ll_Sf");
    static STRUCT_IF_C aBFu0c_BFu32ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0c_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0c_BFu32ll_Sf");
    check_field_offset(lv, v2, 4, "aBFu0c_BFu32ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu32ll_Sf, aBFu0c_BFu32ll_Sf)
//============================================================================



static void Test_aBFu0c_BFu33_Sf()
{
  {
    init_simple_test("aBFu0c_BFu33_Sf");
    static STRUCT_IF_C aBFu0c_BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu0c_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu0c_BFu33_Sf");
    check_field_offset(lv, v2, 5, "aBFu0c_BFu33_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu33_Sf, aBFu0c_BFu33_Sf)
//============================================================================



static void Test_aBFu0c_BFu7c_Sf()
{
  {
    init_simple_test("aBFu0c_BFu7c_Sf");
    static STRUCT_IF_C aBFu0c_BFu7c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0c_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0c_BFu7c_Sf");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu7c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu7c_Sf, aBFu0c_BFu7c_Sf)
//============================================================================



static void Test_aBFu0c_BFu7i_Sf()
{
  {
    init_simple_test("aBFu0c_BFu7i_Sf");
    static STRUCT_IF_C aBFu0c_BFu7i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0c_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0c_BFu7i_Sf");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu7i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu7i_Sf, aBFu0c_BFu7i_Sf)
//============================================================================



static void Test_aBFu0c_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu0c_BFu7ll_Sf");
    static STRUCT_IF_C aBFu0c_BFu7ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0c_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0c_BFu7ll_Sf");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu7ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu7ll_Sf, aBFu0c_BFu7ll_Sf)
//============================================================================



static void Test_aBFu0c_BFu7s_Sf()
{
  {
    init_simple_test("aBFu0c_BFu7s_Sf");
    static STRUCT_IF_C aBFu0c_BFu7s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0c_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0c_BFu7s_Sf");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu7s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu7s_Sf, aBFu0c_BFu7s_Sf)
//============================================================================



static void Test_aBFu0c_BFu8c_Sf()
{
  {
    init_simple_test("aBFu0c_BFu8c_Sf");
    static STRUCT_IF_C aBFu0c_BFu8c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0c_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0c_BFu8c_Sf");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu8c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu8c_Sf, aBFu0c_BFu8c_Sf)
//============================================================================



static void Test_aBFu0c_BFu8i_Sf()
{
  {
    init_simple_test("aBFu0c_BFu8i_Sf");
    static STRUCT_IF_C aBFu0c_BFu8i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0c_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0c_BFu8i_Sf");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu8i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu8i_Sf, aBFu0c_BFu8i_Sf)
//============================================================================



static void Test_aBFu0c_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu0c_BFu8ll_Sf");
    static STRUCT_IF_C aBFu0c_BFu8ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0c_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0c_BFu8ll_Sf");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu8ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu8ll_Sf, aBFu0c_BFu8ll_Sf)
//============================================================================



static void Test_aBFu0c_BFu8s_Sf()
{
  {
    init_simple_test("aBFu0c_BFu8s_Sf");
    static STRUCT_IF_C aBFu0c_BFu8s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0c_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0c_BFu8s_Sf");
    check_field_offset(lv, v2, 1, "aBFu0c_BFu8s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu8s_Sf, aBFu0c_BFu8s_Sf)
//============================================================================



static void Test_aBFu0c_BFu9i_Sf()
{
  {
    init_simple_test("aBFu0c_BFu9i_Sf");
    static STRUCT_IF_C aBFu0c_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0c_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0c_BFu9i_Sf");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu9i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu9i_Sf, aBFu0c_BFu9i_Sf)
//============================================================================



static void Test_aBFu0c_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu0c_BFu9ll_Sf");
    static STRUCT_IF_C aBFu0c_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0c_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0c_BFu9ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu9ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu9ll_Sf, aBFu0c_BFu9ll_Sf)
//============================================================================



static void Test_aBFu0c_BFu9s_Sf()
{
  {
    init_simple_test("aBFu0c_BFu9s_Sf");
    static STRUCT_IF_C aBFu0c_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0c_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0c_BFu9s_Sf");
    check_field_offset(lv, v2, 2, "aBFu0c_BFu9s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_BFu9s_Sf, aBFu0c_BFu9s_Sf)
//============================================================================



static void Test_aBFu0c_C_Sf()
{
  {
    init_simple_test("aBFu0c_C_Sf");
    static STRUCT_IF_C aBFu0c_C_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_C_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_C_Sf.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_C_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_C_Sf, aBFu0c_C_Sf)
//============================================================================



static void Test_aBFu0c_D_Sf()
{
  {
    init_simple_test("aBFu0c_D_Sf");
    static STRUCT_IF_C aBFu0c_D_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0c_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_D_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_D_Sf.v1");
    check_field_offset(lv, v2, 8, "aBFu0c_D_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_D_Sf, aBFu0c_D_Sf)
//============================================================================



static void Test_aBFu0c_F_Sf()
{
  {
    init_simple_test("aBFu0c_F_Sf");
    static STRUCT_IF_C aBFu0c_F_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_F_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_F_Sf.v1");
    check_field_offset(lv, v2, 4, "aBFu0c_F_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_F_Sf, aBFu0c_F_Sf)
//============================================================================



static void Test_aBFu0c_I_Sf()
{
  {
    init_simple_test("aBFu0c_I_Sf");
    static STRUCT_IF_C aBFu0c_I_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_I_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_I_Sf.v1");
    check_field_offset(lv, v2, 4, "aBFu0c_I_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_I_Sf, aBFu0c_I_Sf)
//============================================================================



static void Test_aBFu0c_Ip_Sf()
{
  {
    init_simple_test("aBFu0c_Ip_Sf");
    static STRUCT_IF_C aBFu0c_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0c_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Ip_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_Ip_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0c_Ip_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Ip_Sf, aBFu0c_Ip_Sf)
//============================================================================



static void Test_aBFu0c_L_Sf()
{
  {
    init_simple_test("aBFu0c_L_Sf");
    static STRUCT_IF_C aBFu0c_L_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0c_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_L_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_L_Sf.v1");
    check_field_offset(lv, v2, 8, "aBFu0c_L_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_L_Sf, aBFu0c_L_Sf)
//============================================================================



static void Test_aBFu0c_S_Sf()
{
  {
    init_simple_test("aBFu0c_S_Sf");
    static STRUCT_IF_C aBFu0c_S_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_S_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_S_Sf.v1");
    check_field_offset(lv, v2, 2, "aBFu0c_S_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_S_Sf, aBFu0c_S_Sf)
//============================================================================



static void Test_aBFu0c_Sf()
{
  {
    init_simple_test("aBFu0c_Sf");
    static STRUCT_IF_C aBFu0c_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf, aBFu0c_Sf)
//============================================================================



static void Test_aBFu0c_Sf_BFu0c()
{
  {
    init_simple_test("aBFu0c_Sf_BFu0c");
    static STRUCT_IF_C aBFu0c_Sf_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0c_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu0c, aBFu0c_Sf_BFu0c)
//============================================================================



static void Test_aBFu0c_Sf_BFu0i()
{
  {
    init_simple_test("aBFu0c_Sf_BFu0i");
    static STRUCT_IF_C aBFu0c_Sf_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0c_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu0i, aBFu0c_Sf_BFu0i)
//============================================================================



static void Test_aBFu0c_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu0c_Sf_BFu0ll");
    static STRUCT_IF_C aBFu0c_Sf_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0c_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu0ll, aBFu0c_Sf_BFu0ll)
//============================================================================



static void Test_aBFu0c_Sf_BFu0s()
{
  {
    init_simple_test("aBFu0c_Sf_BFu0s");
    static STRUCT_IF_C aBFu0c_Sf_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0c_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu0s, aBFu0c_Sf_BFu0s)
//============================================================================



static void Test_aBFu0c_Sf_BFu15i()
{
  {
    init_simple_test("aBFu0c_Sf_BFu15i");
    static STRUCT_IF_C aBFu0c_Sf_BFu15i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu15i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aBFu0c_Sf_BFu15i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aBFu0c_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu15i, aBFu0c_Sf_BFu15i)
//============================================================================



static void Test_aBFu0c_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu0c_Sf_BFu15ll");
    static STRUCT_IF_C aBFu0c_Sf_BFu15ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu15ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aBFu0c_Sf_BFu15ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aBFu0c_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu15ll, aBFu0c_Sf_BFu15ll)
//============================================================================



static void Test_aBFu0c_Sf_BFu15s()
{
  {
    init_simple_test("aBFu0c_Sf_BFu15s");
    static STRUCT_IF_C aBFu0c_Sf_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu15s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aBFu0c_Sf_BFu15s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aBFu0c_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu15s, aBFu0c_Sf_BFu15s)
//============================================================================



static void Test_aBFu0c_Sf_BFu16i()
{
  {
    init_simple_test("aBFu0c_Sf_BFu16i");
    static STRUCT_IF_C aBFu0c_Sf_BFu16i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu16i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aBFu0c_Sf_BFu16i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aBFu0c_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu16i, aBFu0c_Sf_BFu16i)
//============================================================================



static void Test_aBFu0c_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu0c_Sf_BFu16ll");
    static STRUCT_IF_C aBFu0c_Sf_BFu16ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu16ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aBFu0c_Sf_BFu16ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aBFu0c_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu16ll, aBFu0c_Sf_BFu16ll)
//============================================================================



static void Test_aBFu0c_Sf_BFu16s()
{
  {
    init_simple_test("aBFu0c_Sf_BFu16s");
    static STRUCT_IF_C aBFu0c_Sf_BFu16s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu16s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aBFu0c_Sf_BFu16s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aBFu0c_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu16s, aBFu0c_Sf_BFu16s)
//============================================================================



static void Test_aBFu0c_Sf_BFu17i()
{
  {
    init_simple_test("aBFu0c_Sf_BFu17i");
    static STRUCT_IF_C aBFu0c_Sf_BFu17i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu17i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aBFu0c_Sf_BFu17i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aBFu0c_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu17i, aBFu0c_Sf_BFu17i)
//============================================================================



static void Test_aBFu0c_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu0c_Sf_BFu17ll");
    static STRUCT_IF_C aBFu0c_Sf_BFu17ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0c_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu17ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aBFu0c_Sf_BFu17ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aBFu0c_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu17ll, aBFu0c_Sf_BFu17ll)
//============================================================================



static void Test_aBFu0c_Sf_BFu1c()
{
  {
    init_simple_test("aBFu0c_Sf_BFu1c");
    static STRUCT_IF_C aBFu0c_Sf_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu1c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0c_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu1c, aBFu0c_Sf_BFu1c)
//============================================================================



static void Test_aBFu0c_Sf_BFu1i()
{
  {
    init_simple_test("aBFu0c_Sf_BFu1i");
    static STRUCT_IF_C aBFu0c_Sf_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu1i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0c_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu1i, aBFu0c_Sf_BFu1i)
//============================================================================



static void Test_aBFu0c_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu0c_Sf_BFu1ll");
    static STRUCT_IF_C aBFu0c_Sf_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu1ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0c_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu1ll, aBFu0c_Sf_BFu1ll)
//============================================================================



static void Test_aBFu0c_Sf_BFu1s()
{
  {
    init_simple_test("aBFu0c_Sf_BFu1s");
    static STRUCT_IF_C aBFu0c_Sf_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu1s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0c_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu1s, aBFu0c_Sf_BFu1s)
//============================================================================



static void Test_aBFu0c_Sf_BFu31i()
{
  {
    init_simple_test("aBFu0c_Sf_BFu31i");
    static STRUCT_IF_C aBFu0c_Sf_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu31i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aBFu0c_Sf_BFu31i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aBFu0c_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu31i, aBFu0c_Sf_BFu31i)
//============================================================================



static void Test_aBFu0c_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu0c_Sf_BFu31ll");
    static STRUCT_IF_C aBFu0c_Sf_BFu31ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu31ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aBFu0c_Sf_BFu31ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aBFu0c_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu31ll, aBFu0c_Sf_BFu31ll)
//============================================================================



static void Test_aBFu0c_Sf_BFu32i()
{
  {
    init_simple_test("aBFu0c_Sf_BFu32i");
    static STRUCT_IF_C aBFu0c_Sf_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu32i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aBFu0c_Sf_BFu32i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aBFu0c_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu32i, aBFu0c_Sf_BFu32i)
//============================================================================



static void Test_aBFu0c_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu0c_Sf_BFu32ll");
    static STRUCT_IF_C aBFu0c_Sf_BFu32ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu32ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aBFu0c_Sf_BFu32ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aBFu0c_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu32ll, aBFu0c_Sf_BFu32ll)
//============================================================================



static void Test_aBFu0c_Sf_BFu33()
{
  {
    init_simple_test("aBFu0c_Sf_BFu33");
    static STRUCT_IF_C aBFu0c_Sf_BFu33 lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0c_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu33.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "aBFu0c_Sf_BFu33");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "aBFu0c_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu33, aBFu0c_Sf_BFu33)
//============================================================================



static void Test_aBFu0c_Sf_BFu7c()
{
  {
    init_simple_test("aBFu0c_Sf_BFu7c");
    static STRUCT_IF_C aBFu0c_Sf_BFu7c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu7c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0c_Sf_BFu7c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0c_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu7c, aBFu0c_Sf_BFu7c)
//============================================================================



static void Test_aBFu0c_Sf_BFu7i()
{
  {
    init_simple_test("aBFu0c_Sf_BFu7i");
    static STRUCT_IF_C aBFu0c_Sf_BFu7i lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu7i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0c_Sf_BFu7i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0c_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu7i, aBFu0c_Sf_BFu7i)
//============================================================================



static void Test_aBFu0c_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu0c_Sf_BFu7ll");
    static STRUCT_IF_C aBFu0c_Sf_BFu7ll lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu7ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0c_Sf_BFu7ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0c_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu7ll, aBFu0c_Sf_BFu7ll)
//============================================================================



static void Test_aBFu0c_Sf_BFu7s()
{
  {
    init_simple_test("aBFu0c_Sf_BFu7s");
    static STRUCT_IF_C aBFu0c_Sf_BFu7s lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu7s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0c_Sf_BFu7s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0c_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu7s, aBFu0c_Sf_BFu7s)
//============================================================================



static void Test_aBFu0c_Sf_BFu8c()
{
  {
    init_simple_test("aBFu0c_Sf_BFu8c");
    static STRUCT_IF_C aBFu0c_Sf_BFu8c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu8c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0c_Sf_BFu8c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0c_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu8c, aBFu0c_Sf_BFu8c)
//============================================================================



static void Test_aBFu0c_Sf_BFu8i()
{
  {
    init_simple_test("aBFu0c_Sf_BFu8i");
    static STRUCT_IF_C aBFu0c_Sf_BFu8i lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu8i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0c_Sf_BFu8i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0c_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu8i, aBFu0c_Sf_BFu8i)
//============================================================================



static void Test_aBFu0c_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu0c_Sf_BFu8ll");
    static STRUCT_IF_C aBFu0c_Sf_BFu8ll lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu8ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0c_Sf_BFu8ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0c_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu8ll, aBFu0c_Sf_BFu8ll)
//============================================================================



static void Test_aBFu0c_Sf_BFu8s()
{
  {
    init_simple_test("aBFu0c_Sf_BFu8s");
    static STRUCT_IF_C aBFu0c_Sf_BFu8s lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu8s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0c_Sf_BFu8s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0c_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu8s, aBFu0c_Sf_BFu8s)
//============================================================================



static void Test_aBFu0c_Sf_BFu9i()
{
  {
    init_simple_test("aBFu0c_Sf_BFu9i");
    static STRUCT_IF_C aBFu0c_Sf_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu9i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aBFu0c_Sf_BFu9i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aBFu0c_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu9i, aBFu0c_Sf_BFu9i)
//============================================================================



static void Test_aBFu0c_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu0c_Sf_BFu9ll");
    static STRUCT_IF_C aBFu0c_Sf_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu9ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aBFu0c_Sf_BFu9ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aBFu0c_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu9ll, aBFu0c_Sf_BFu9ll)
//============================================================================



static void Test_aBFu0c_Sf_BFu9s()
{
  {
    init_simple_test("aBFu0c_Sf_BFu9s");
    static STRUCT_IF_C aBFu0c_Sf_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_BFu9s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aBFu0c_Sf_BFu9s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aBFu0c_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_BFu9s, aBFu0c_Sf_BFu9s)
//============================================================================



static void Test_aBFu0c_Sf_C()
{
  {
    init_simple_test("aBFu0c_Sf_C");
    static STRUCT_IF_C aBFu0c_Sf_C lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_C)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_C.v1");
    check_field_offset(lv, v2, 0, "aBFu0c_Sf_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_C, aBFu0c_Sf_C)
//============================================================================



static void Test_aBFu0c_Sf_D()
{
  {
    init_simple_test("aBFu0c_Sf_D");
    static STRUCT_IF_C aBFu0c_Sf_D lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0c_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_D)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_D.v1");
    check_field_offset(lv, v2, 0, "aBFu0c_Sf_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_D, aBFu0c_Sf_D)
//============================================================================



static void Test_aBFu0c_Sf_F()
{
  {
    init_simple_test("aBFu0c_Sf_F");
    static STRUCT_IF_C aBFu0c_Sf_F lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_F)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_F.v1");
    check_field_offset(lv, v2, 0, "aBFu0c_Sf_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_F, aBFu0c_Sf_F)
//============================================================================



static void Test_aBFu0c_Sf_I()
{
  {
    init_simple_test("aBFu0c_Sf_I");
    static STRUCT_IF_C aBFu0c_Sf_I lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_I)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_I.v1");
    check_field_offset(lv, v2, 0, "aBFu0c_Sf_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_I, aBFu0c_Sf_I)
//============================================================================



static void Test_aBFu0c_Sf_Ip()
{
  {
    init_simple_test("aBFu0c_Sf_Ip");
    static STRUCT_IF_C aBFu0c_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0c_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_Ip.v1");
    check_field_offset(lv, v2, 0, "aBFu0c_Sf_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_Ip, aBFu0c_Sf_Ip)
//============================================================================



static void Test_aBFu0c_Sf_L()
{
  {
    init_simple_test("aBFu0c_Sf_L");
    static STRUCT_IF_C aBFu0c_Sf_L lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0c_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_L)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_L.v1");
    check_field_offset(lv, v2, 0, "aBFu0c_Sf_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_L, aBFu0c_Sf_L)
//============================================================================



static void Test_aBFu0c_Sf_S()
{
  {
    init_simple_test("aBFu0c_Sf_S");
    static STRUCT_IF_C aBFu0c_Sf_S lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_S)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_S.v1");
    check_field_offset(lv, v2, 0, "aBFu0c_Sf_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_S, aBFu0c_Sf_S)
//============================================================================



static void Test_aBFu0c_Sf_Sf()
{
  {
    init_simple_test("aBFu0c_Sf_Sf");
    static STRUCT_IF_C aBFu0c_Sf_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0c_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_Sf.v1");
    check_field_offset(lv, v2, 0, "aBFu0c_Sf_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_Sf, aBFu0c_Sf_Sf)
//============================================================================



static void Test_aBFu0c_Sf_Uc()
{
  {
    init_simple_test("aBFu0c_Sf_Uc");
    static STRUCT_IF_C aBFu0c_Sf_Uc lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_Uc.v1");
    check_field_offset(lv, v2, 0, "aBFu0c_Sf_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_Uc, aBFu0c_Sf_Uc)
//============================================================================



static void Test_aBFu0c_Sf_Ui()
{
  {
    init_simple_test("aBFu0c_Sf_Ui");
    static STRUCT_IF_C aBFu0c_Sf_Ui lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_Ui.v1");
    check_field_offset(lv, v2, 0, "aBFu0c_Sf_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_Ui, aBFu0c_Sf_Ui)
//============================================================================



static void Test_aBFu0c_Sf_Ul()
{
  {
    init_simple_test("aBFu0c_Sf_Ul");
    static STRUCT_IF_C aBFu0c_Sf_Ul lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0c_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_Ul.v1");
    check_field_offset(lv, v2, 0, "aBFu0c_Sf_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_Ul, aBFu0c_Sf_Ul)
//============================================================================



static void Test_aBFu0c_Sf_Us()
{
  {
    init_simple_test("aBFu0c_Sf_Us");
    static STRUCT_IF_C aBFu0c_Sf_Us lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_Us)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_Us.v1");
    check_field_offset(lv, v2, 0, "aBFu0c_Sf_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_Us, aBFu0c_Sf_Us)
//============================================================================



static void Test_aBFu0c_Sf_Vp()
{
  {
    init_simple_test("aBFu0c_Sf_Vp");
    static STRUCT_IF_C aBFu0c_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0c_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Sf_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0c_Sf_Vp.v1");
    check_field_offset(lv, v2, 0, "aBFu0c_Sf_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Sf_Vp, aBFu0c_Sf_Vp)
//============================================================================



static void Test_aBFu0c_Uc_Sf()
{
  {
    init_simple_test("aBFu0c_Uc_Sf");
    static STRUCT_IF_C aBFu0c_Uc_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0c_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Uc_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_Uc_Sf.v1");
    check_field_offset(lv, v2, 1, "aBFu0c_Uc_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Uc_Sf, aBFu0c_Uc_Sf)
//============================================================================



static void Test_aBFu0c_Ui_Sf()
{
  {
    init_simple_test("aBFu0c_Ui_Sf");
    static STRUCT_IF_C aBFu0c_Ui_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0c_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Ui_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_Ui_Sf.v1");
    check_field_offset(lv, v2, 4, "aBFu0c_Ui_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Ui_Sf, aBFu0c_Ui_Sf)
//============================================================================



static void Test_aBFu0c_Ul_Sf()
{
  {
    init_simple_test("aBFu0c_Ul_Sf");
    static STRUCT_IF_C aBFu0c_Ul_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0c_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Ul_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_Ul_Sf.v1");
    check_field_offset(lv, v2, 8, "aBFu0c_Ul_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Ul_Sf, aBFu0c_Ul_Sf)
//============================================================================



static void Test_aBFu0c_Us_Sf()
{
  {
    init_simple_test("aBFu0c_Us_Sf");
    static STRUCT_IF_C aBFu0c_Us_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0c_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Us_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_Us_Sf.v1");
    check_field_offset(lv, v2, 2, "aBFu0c_Us_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Us_Sf, aBFu0c_Us_Sf)
//============================================================================



static void Test_aBFu0c_Vp_Sf()
{
  {
    init_simple_test("aBFu0c_Vp_Sf");
    static STRUCT_IF_C aBFu0c_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0c_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0c_Vp_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0c_Vp_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0c_Vp_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0c_Vp_Sf, aBFu0c_Vp_Sf)
//============================================================================



static void Test_aBFu0i_BFu0c_Sf()
{
  {
    init_simple_test("aBFu0i_BFu0c_Sf");
    static STRUCT_IF_C aBFu0i_BFu0c_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_BFu0c_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu0c_Sf, aBFu0i_BFu0c_Sf)
//============================================================================



static void Test_aBFu0i_BFu0i_Sf()
{
  {
    init_simple_test("aBFu0i_BFu0i_Sf");
    static STRUCT_IF_C aBFu0i_BFu0i_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0i_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_BFu0i_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu0i_Sf, aBFu0i_BFu0i_Sf)
//============================================================================



static void Test_aBFu0i_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu0i_BFu0ll_Sf");
    static STRUCT_IF_C aBFu0i_BFu0ll_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0i_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_BFu0ll_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu0ll_Sf, aBFu0i_BFu0ll_Sf)
//============================================================================



static void Test_aBFu0i_BFu0s_Sf()
{
  {
    init_simple_test("aBFu0i_BFu0s_Sf");
    static STRUCT_IF_C aBFu0i_BFu0s_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0i_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_BFu0s_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu0s_Sf, aBFu0i_BFu0s_Sf)
//============================================================================



static void Test_aBFu0i_BFu15i_Sf()
{
  {
    init_simple_test("aBFu0i_BFu15i_Sf");
    static STRUCT_IF_C aBFu0i_BFu15i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0i_BFu15i_Sf");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu15i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu15i_Sf, aBFu0i_BFu15i_Sf)
//============================================================================



static void Test_aBFu0i_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu0i_BFu15ll_Sf");
    static STRUCT_IF_C aBFu0i_BFu15ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0i_BFu15ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu15ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu15ll_Sf, aBFu0i_BFu15ll_Sf)
//============================================================================



static void Test_aBFu0i_BFu15s_Sf()
{
  {
    init_simple_test("aBFu0i_BFu15s_Sf");
    static STRUCT_IF_C aBFu0i_BFu15s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0i_BFu15s_Sf");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu15s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu15s_Sf, aBFu0i_BFu15s_Sf)
//============================================================================



static void Test_aBFu0i_BFu16i_Sf()
{
  {
    init_simple_test("aBFu0i_BFu16i_Sf");
    static STRUCT_IF_C aBFu0i_BFu16i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0i_BFu16i_Sf");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu16i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu16i_Sf, aBFu0i_BFu16i_Sf)
//============================================================================



static void Test_aBFu0i_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu0i_BFu16ll_Sf");
    static STRUCT_IF_C aBFu0i_BFu16ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0i_BFu16ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu16ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu16ll_Sf, aBFu0i_BFu16ll_Sf)
//============================================================================



static void Test_aBFu0i_BFu16s_Sf()
{
  {
    init_simple_test("aBFu0i_BFu16s_Sf");
    static STRUCT_IF_C aBFu0i_BFu16s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0i_BFu16s_Sf");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu16s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu16s_Sf, aBFu0i_BFu16s_Sf)
//============================================================================



static void Test_aBFu0i_BFu17i_Sf()
{
  {
    init_simple_test("aBFu0i_BFu17i_Sf");
    static STRUCT_IF_C aBFu0i_BFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0i_BFu17i_Sf");
    check_field_offset(lv, v2, 3, "aBFu0i_BFu17i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu17i_Sf, aBFu0i_BFu17i_Sf)
//============================================================================



static void Test_aBFu0i_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu0i_BFu17ll_Sf");
    static STRUCT_IF_C aBFu0i_BFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0i_BFu17ll_Sf");
    check_field_offset(lv, v2, 3, "aBFu0i_BFu17ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu17ll_Sf, aBFu0i_BFu17ll_Sf)
//============================================================================



static void Test_aBFu0i_BFu1c_Sf()
{
  {
    init_simple_test("aBFu0i_BFu1c_Sf");
    static STRUCT_IF_C aBFu0i_BFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0i_BFu1c_Sf");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu1c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu1c_Sf, aBFu0i_BFu1c_Sf)
//============================================================================



static void Test_aBFu0i_BFu1i_Sf()
{
  {
    init_simple_test("aBFu0i_BFu1i_Sf");
    static STRUCT_IF_C aBFu0i_BFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0i_BFu1i_Sf");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu1i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu1i_Sf, aBFu0i_BFu1i_Sf)
//============================================================================



static void Test_aBFu0i_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu0i_BFu1ll_Sf");
    static STRUCT_IF_C aBFu0i_BFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0i_BFu1ll_Sf");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu1ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu1ll_Sf, aBFu0i_BFu1ll_Sf)
//============================================================================



static void Test_aBFu0i_BFu1s_Sf()
{
  {
    init_simple_test("aBFu0i_BFu1s_Sf");
    static STRUCT_IF_C aBFu0i_BFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0i_BFu1s_Sf");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu1s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu1s_Sf, aBFu0i_BFu1s_Sf)
//============================================================================



static void Test_aBFu0i_BFu31i_Sf()
{
  {
    init_simple_test("aBFu0i_BFu31i_Sf");
    static STRUCT_IF_C aBFu0i_BFu31i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0i_BFu31i_Sf");
    check_field_offset(lv, v2, 4, "aBFu0i_BFu31i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu31i_Sf, aBFu0i_BFu31i_Sf)
//============================================================================



static void Test_aBFu0i_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu0i_BFu31ll_Sf");
    static STRUCT_IF_C aBFu0i_BFu31ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0i_BFu31ll_Sf");
    check_field_offset(lv, v2, 4, "aBFu0i_BFu31ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu31ll_Sf, aBFu0i_BFu31ll_Sf)
//============================================================================



static void Test_aBFu0i_BFu32i_Sf()
{
  {
    init_simple_test("aBFu0i_BFu32i_Sf");
    static STRUCT_IF_C aBFu0i_BFu32i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0i_BFu32i_Sf");
    check_field_offset(lv, v2, 4, "aBFu0i_BFu32i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu32i_Sf, aBFu0i_BFu32i_Sf)
//============================================================================



static void Test_aBFu0i_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu0i_BFu32ll_Sf");
    static STRUCT_IF_C aBFu0i_BFu32ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0i_BFu32ll_Sf");
    check_field_offset(lv, v2, 4, "aBFu0i_BFu32ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu32ll_Sf, aBFu0i_BFu32ll_Sf)
//============================================================================



static void Test_aBFu0i_BFu33_Sf()
{
  {
    init_simple_test("aBFu0i_BFu33_Sf");
    static STRUCT_IF_C aBFu0i_BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu0i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu0i_BFu33_Sf");
    check_field_offset(lv, v2, 5, "aBFu0i_BFu33_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu33_Sf, aBFu0i_BFu33_Sf)
//============================================================================



static void Test_aBFu0i_BFu7c_Sf()
{
  {
    init_simple_test("aBFu0i_BFu7c_Sf");
    static STRUCT_IF_C aBFu0i_BFu7c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0i_BFu7c_Sf");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu7c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu7c_Sf, aBFu0i_BFu7c_Sf)
//============================================================================



static void Test_aBFu0i_BFu7i_Sf()
{
  {
    init_simple_test("aBFu0i_BFu7i_Sf");
    static STRUCT_IF_C aBFu0i_BFu7i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0i_BFu7i_Sf");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu7i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu7i_Sf, aBFu0i_BFu7i_Sf)
//============================================================================



static void Test_aBFu0i_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu0i_BFu7ll_Sf");
    static STRUCT_IF_C aBFu0i_BFu7ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0i_BFu7ll_Sf");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu7ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu7ll_Sf, aBFu0i_BFu7ll_Sf)
//============================================================================



static void Test_aBFu0i_BFu7s_Sf()
{
  {
    init_simple_test("aBFu0i_BFu7s_Sf");
    static STRUCT_IF_C aBFu0i_BFu7s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0i_BFu7s_Sf");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu7s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu7s_Sf, aBFu0i_BFu7s_Sf)
//============================================================================



static void Test_aBFu0i_BFu8c_Sf()
{
  {
    init_simple_test("aBFu0i_BFu8c_Sf");
    static STRUCT_IF_C aBFu0i_BFu8c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0i_BFu8c_Sf");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu8c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu8c_Sf, aBFu0i_BFu8c_Sf)
//============================================================================



static void Test_aBFu0i_BFu8i_Sf()
{
  {
    init_simple_test("aBFu0i_BFu8i_Sf");
    static STRUCT_IF_C aBFu0i_BFu8i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0i_BFu8i_Sf");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu8i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu8i_Sf, aBFu0i_BFu8i_Sf)
//============================================================================



static void Test_aBFu0i_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu0i_BFu8ll_Sf");
    static STRUCT_IF_C aBFu0i_BFu8ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0i_BFu8ll_Sf");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu8ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu8ll_Sf, aBFu0i_BFu8ll_Sf)
//============================================================================



static void Test_aBFu0i_BFu8s_Sf()
{
  {
    init_simple_test("aBFu0i_BFu8s_Sf");
    static STRUCT_IF_C aBFu0i_BFu8s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0i_BFu8s_Sf");
    check_field_offset(lv, v2, 1, "aBFu0i_BFu8s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu8s_Sf, aBFu0i_BFu8s_Sf)
//============================================================================



static void Test_aBFu0i_BFu9i_Sf()
{
  {
    init_simple_test("aBFu0i_BFu9i_Sf");
    static STRUCT_IF_C aBFu0i_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0i_BFu9i_Sf");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu9i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu9i_Sf, aBFu0i_BFu9i_Sf)
//============================================================================



static void Test_aBFu0i_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu0i_BFu9ll_Sf");
    static STRUCT_IF_C aBFu0i_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0i_BFu9ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu9ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu9ll_Sf, aBFu0i_BFu9ll_Sf)
//============================================================================



static void Test_aBFu0i_BFu9s_Sf()
{
  {
    init_simple_test("aBFu0i_BFu9s_Sf");
    static STRUCT_IF_C aBFu0i_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0i_BFu9s_Sf");
    check_field_offset(lv, v2, 2, "aBFu0i_BFu9s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_BFu9s_Sf, aBFu0i_BFu9s_Sf)
//============================================================================



static void Test_aBFu0i_C_Sf()
{
  {
    init_simple_test("aBFu0i_C_Sf");
    static STRUCT_IF_C aBFu0i_C_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_C_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_C_Sf.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_C_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_C_Sf, aBFu0i_C_Sf)
//============================================================================



static void Test_aBFu0i_D_Sf()
{
  {
    init_simple_test("aBFu0i_D_Sf");
    static STRUCT_IF_C aBFu0i_D_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0i_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_D_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_D_Sf.v1");
    check_field_offset(lv, v2, 8, "aBFu0i_D_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_D_Sf, aBFu0i_D_Sf)
//============================================================================



static void Test_aBFu0i_F_Sf()
{
  {
    init_simple_test("aBFu0i_F_Sf");
    static STRUCT_IF_C aBFu0i_F_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_F_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_F_Sf.v1");
    check_field_offset(lv, v2, 4, "aBFu0i_F_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_F_Sf, aBFu0i_F_Sf)
//============================================================================



static void Test_aBFu0i_I_Sf()
{
  {
    init_simple_test("aBFu0i_I_Sf");
    static STRUCT_IF_C aBFu0i_I_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_I_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_I_Sf.v1");
    check_field_offset(lv, v2, 4, "aBFu0i_I_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_I_Sf, aBFu0i_I_Sf)
//============================================================================



static void Test_aBFu0i_Ip_Sf()
{
  {
    init_simple_test("aBFu0i_Ip_Sf");
    static STRUCT_IF_C aBFu0i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0i_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Ip_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_Ip_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0i_Ip_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Ip_Sf, aBFu0i_Ip_Sf)
//============================================================================



static void Test_aBFu0i_L_Sf()
{
  {
    init_simple_test("aBFu0i_L_Sf");
    static STRUCT_IF_C aBFu0i_L_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0i_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_L_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_L_Sf.v1");
    check_field_offset(lv, v2, 8, "aBFu0i_L_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_L_Sf, aBFu0i_L_Sf)
//============================================================================



static void Test_aBFu0i_S_Sf()
{
  {
    init_simple_test("aBFu0i_S_Sf");
    static STRUCT_IF_C aBFu0i_S_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_S_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_S_Sf.v1");
    check_field_offset(lv, v2, 2, "aBFu0i_S_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_S_Sf, aBFu0i_S_Sf)
//============================================================================



static void Test_aBFu0i_Sf()
{
  {
    init_simple_test("aBFu0i_Sf");
    static STRUCT_IF_C aBFu0i_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf, aBFu0i_Sf)
//============================================================================



static void Test_aBFu0i_Sf_BFu0c()
{
  {
    init_simple_test("aBFu0i_Sf_BFu0c");
    static STRUCT_IF_C aBFu0i_Sf_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu0c, aBFu0i_Sf_BFu0c)
//============================================================================



static void Test_aBFu0i_Sf_BFu0i()
{
  {
    init_simple_test("aBFu0i_Sf_BFu0i");
    static STRUCT_IF_C aBFu0i_Sf_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0i_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu0i, aBFu0i_Sf_BFu0i)
//============================================================================



static void Test_aBFu0i_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu0i_Sf_BFu0ll");
    static STRUCT_IF_C aBFu0i_Sf_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0i_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu0ll, aBFu0i_Sf_BFu0ll)
//============================================================================



static void Test_aBFu0i_Sf_BFu0s()
{
  {
    init_simple_test("aBFu0i_Sf_BFu0s");
    static STRUCT_IF_C aBFu0i_Sf_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0i_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu0s, aBFu0i_Sf_BFu0s)
//============================================================================



static void Test_aBFu0i_Sf_BFu15i()
{
  {
    init_simple_test("aBFu0i_Sf_BFu15i");
    static STRUCT_IF_C aBFu0i_Sf_BFu15i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu15i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aBFu0i_Sf_BFu15i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aBFu0i_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu15i, aBFu0i_Sf_BFu15i)
//============================================================================



static void Test_aBFu0i_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu0i_Sf_BFu15ll");
    static STRUCT_IF_C aBFu0i_Sf_BFu15ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu15ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aBFu0i_Sf_BFu15ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aBFu0i_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu15ll, aBFu0i_Sf_BFu15ll)
//============================================================================



static void Test_aBFu0i_Sf_BFu15s()
{
  {
    init_simple_test("aBFu0i_Sf_BFu15s");
    static STRUCT_IF_C aBFu0i_Sf_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu15s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aBFu0i_Sf_BFu15s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aBFu0i_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu15s, aBFu0i_Sf_BFu15s)
//============================================================================



static void Test_aBFu0i_Sf_BFu16i()
{
  {
    init_simple_test("aBFu0i_Sf_BFu16i");
    static STRUCT_IF_C aBFu0i_Sf_BFu16i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu16i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aBFu0i_Sf_BFu16i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aBFu0i_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu16i, aBFu0i_Sf_BFu16i)
//============================================================================



static void Test_aBFu0i_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu0i_Sf_BFu16ll");
    static STRUCT_IF_C aBFu0i_Sf_BFu16ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu16ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aBFu0i_Sf_BFu16ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aBFu0i_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu16ll, aBFu0i_Sf_BFu16ll)
//============================================================================



static void Test_aBFu0i_Sf_BFu16s()
{
  {
    init_simple_test("aBFu0i_Sf_BFu16s");
    static STRUCT_IF_C aBFu0i_Sf_BFu16s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu16s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aBFu0i_Sf_BFu16s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aBFu0i_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu16s, aBFu0i_Sf_BFu16s)
//============================================================================



static void Test_aBFu0i_Sf_BFu17i()
{
  {
    init_simple_test("aBFu0i_Sf_BFu17i");
    static STRUCT_IF_C aBFu0i_Sf_BFu17i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu17i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aBFu0i_Sf_BFu17i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aBFu0i_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu17i, aBFu0i_Sf_BFu17i)
//============================================================================



static void Test_aBFu0i_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu0i_Sf_BFu17ll");
    static STRUCT_IF_C aBFu0i_Sf_BFu17ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0i_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu17ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aBFu0i_Sf_BFu17ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aBFu0i_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu17ll, aBFu0i_Sf_BFu17ll)
//============================================================================



static void Test_aBFu0i_Sf_BFu1c()
{
  {
    init_simple_test("aBFu0i_Sf_BFu1c");
    static STRUCT_IF_C aBFu0i_Sf_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu1c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0i_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu1c, aBFu0i_Sf_BFu1c)
//============================================================================



static void Test_aBFu0i_Sf_BFu1i()
{
  {
    init_simple_test("aBFu0i_Sf_BFu1i");
    static STRUCT_IF_C aBFu0i_Sf_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu1i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0i_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu1i, aBFu0i_Sf_BFu1i)
//============================================================================



static void Test_aBFu0i_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu0i_Sf_BFu1ll");
    static STRUCT_IF_C aBFu0i_Sf_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu1ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0i_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu1ll, aBFu0i_Sf_BFu1ll)
//============================================================================



static void Test_aBFu0i_Sf_BFu1s()
{
  {
    init_simple_test("aBFu0i_Sf_BFu1s");
    static STRUCT_IF_C aBFu0i_Sf_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu1s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0i_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu1s, aBFu0i_Sf_BFu1s)
//============================================================================



static void Test_aBFu0i_Sf_BFu31i()
{
  {
    init_simple_test("aBFu0i_Sf_BFu31i");
    static STRUCT_IF_C aBFu0i_Sf_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu31i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aBFu0i_Sf_BFu31i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aBFu0i_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu31i, aBFu0i_Sf_BFu31i)
//============================================================================



static void Test_aBFu0i_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu0i_Sf_BFu31ll");
    static STRUCT_IF_C aBFu0i_Sf_BFu31ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu31ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aBFu0i_Sf_BFu31ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aBFu0i_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu31ll, aBFu0i_Sf_BFu31ll)
//============================================================================



static void Test_aBFu0i_Sf_BFu32i()
{
  {
    init_simple_test("aBFu0i_Sf_BFu32i");
    static STRUCT_IF_C aBFu0i_Sf_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu32i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aBFu0i_Sf_BFu32i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aBFu0i_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu32i, aBFu0i_Sf_BFu32i)
//============================================================================



static void Test_aBFu0i_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu0i_Sf_BFu32ll");
    static STRUCT_IF_C aBFu0i_Sf_BFu32ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu32ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aBFu0i_Sf_BFu32ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aBFu0i_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu32ll, aBFu0i_Sf_BFu32ll)
//============================================================================



static void Test_aBFu0i_Sf_BFu33()
{
  {
    init_simple_test("aBFu0i_Sf_BFu33");
    static STRUCT_IF_C aBFu0i_Sf_BFu33 lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0i_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu33.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "aBFu0i_Sf_BFu33");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "aBFu0i_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu33, aBFu0i_Sf_BFu33)
//============================================================================



static void Test_aBFu0i_Sf_BFu7c()
{
  {
    init_simple_test("aBFu0i_Sf_BFu7c");
    static STRUCT_IF_C aBFu0i_Sf_BFu7c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu7c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0i_Sf_BFu7c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0i_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu7c, aBFu0i_Sf_BFu7c)
//============================================================================



static void Test_aBFu0i_Sf_BFu7i()
{
  {
    init_simple_test("aBFu0i_Sf_BFu7i");
    static STRUCT_IF_C aBFu0i_Sf_BFu7i lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu7i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0i_Sf_BFu7i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0i_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu7i, aBFu0i_Sf_BFu7i)
//============================================================================



static void Test_aBFu0i_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu0i_Sf_BFu7ll");
    static STRUCT_IF_C aBFu0i_Sf_BFu7ll lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu7ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0i_Sf_BFu7ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0i_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu7ll, aBFu0i_Sf_BFu7ll)
//============================================================================



static void Test_aBFu0i_Sf_BFu7s()
{
  {
    init_simple_test("aBFu0i_Sf_BFu7s");
    static STRUCT_IF_C aBFu0i_Sf_BFu7s lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu7s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0i_Sf_BFu7s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0i_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu7s, aBFu0i_Sf_BFu7s)
//============================================================================



static void Test_aBFu0i_Sf_BFu8c()
{
  {
    init_simple_test("aBFu0i_Sf_BFu8c");
    static STRUCT_IF_C aBFu0i_Sf_BFu8c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu8c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0i_Sf_BFu8c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0i_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu8c, aBFu0i_Sf_BFu8c)
//============================================================================



static void Test_aBFu0i_Sf_BFu8i()
{
  {
    init_simple_test("aBFu0i_Sf_BFu8i");
    static STRUCT_IF_C aBFu0i_Sf_BFu8i lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu8i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0i_Sf_BFu8i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0i_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu8i, aBFu0i_Sf_BFu8i)
//============================================================================



static void Test_aBFu0i_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu0i_Sf_BFu8ll");
    static STRUCT_IF_C aBFu0i_Sf_BFu8ll lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu8ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0i_Sf_BFu8ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0i_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu8ll, aBFu0i_Sf_BFu8ll)
//============================================================================



static void Test_aBFu0i_Sf_BFu8s()
{
  {
    init_simple_test("aBFu0i_Sf_BFu8s");
    static STRUCT_IF_C aBFu0i_Sf_BFu8s lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu8s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0i_Sf_BFu8s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0i_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu8s, aBFu0i_Sf_BFu8s)
//============================================================================



static void Test_aBFu0i_Sf_BFu9i()
{
  {
    init_simple_test("aBFu0i_Sf_BFu9i");
    static STRUCT_IF_C aBFu0i_Sf_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu9i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aBFu0i_Sf_BFu9i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aBFu0i_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu9i, aBFu0i_Sf_BFu9i)
//============================================================================



static void Test_aBFu0i_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu0i_Sf_BFu9ll");
    static STRUCT_IF_C aBFu0i_Sf_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu9ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aBFu0i_Sf_BFu9ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aBFu0i_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu9ll, aBFu0i_Sf_BFu9ll)
//============================================================================



static void Test_aBFu0i_Sf_BFu9s()
{
  {
    init_simple_test("aBFu0i_Sf_BFu9s");
    static STRUCT_IF_C aBFu0i_Sf_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_BFu9s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aBFu0i_Sf_BFu9s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aBFu0i_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_BFu9s, aBFu0i_Sf_BFu9s)
//============================================================================



static void Test_aBFu0i_Sf_C()
{
  {
    init_simple_test("aBFu0i_Sf_C");
    static STRUCT_IF_C aBFu0i_Sf_C lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_C)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_C.v1");
    check_field_offset(lv, v2, 0, "aBFu0i_Sf_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_C, aBFu0i_Sf_C)
//============================================================================



static void Test_aBFu0i_Sf_D()
{
  {
    init_simple_test("aBFu0i_Sf_D");
    static STRUCT_IF_C aBFu0i_Sf_D lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0i_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_D)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_D.v1");
    check_field_offset(lv, v2, 0, "aBFu0i_Sf_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_D, aBFu0i_Sf_D)
//============================================================================



static void Test_aBFu0i_Sf_F()
{
  {
    init_simple_test("aBFu0i_Sf_F");
    static STRUCT_IF_C aBFu0i_Sf_F lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_F)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_F.v1");
    check_field_offset(lv, v2, 0, "aBFu0i_Sf_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_F, aBFu0i_Sf_F)
//============================================================================



static void Test_aBFu0i_Sf_I()
{
  {
    init_simple_test("aBFu0i_Sf_I");
    static STRUCT_IF_C aBFu0i_Sf_I lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_I)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_I.v1");
    check_field_offset(lv, v2, 0, "aBFu0i_Sf_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_I, aBFu0i_Sf_I)
//============================================================================



static void Test_aBFu0i_Sf_Ip()
{
  {
    init_simple_test("aBFu0i_Sf_Ip");
    static STRUCT_IF_C aBFu0i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0i_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_Ip.v1");
    check_field_offset(lv, v2, 0, "aBFu0i_Sf_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_Ip, aBFu0i_Sf_Ip)
//============================================================================



static void Test_aBFu0i_Sf_L()
{
  {
    init_simple_test("aBFu0i_Sf_L");
    static STRUCT_IF_C aBFu0i_Sf_L lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0i_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_L)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_L.v1");
    check_field_offset(lv, v2, 0, "aBFu0i_Sf_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_L, aBFu0i_Sf_L)
//============================================================================



static void Test_aBFu0i_Sf_S()
{
  {
    init_simple_test("aBFu0i_Sf_S");
    static STRUCT_IF_C aBFu0i_Sf_S lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_S)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_S.v1");
    check_field_offset(lv, v2, 0, "aBFu0i_Sf_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_S, aBFu0i_Sf_S)
//============================================================================



static void Test_aBFu0i_Sf_Sf()
{
  {
    init_simple_test("aBFu0i_Sf_Sf");
    static STRUCT_IF_C aBFu0i_Sf_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0i_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_Sf.v1");
    check_field_offset(lv, v2, 0, "aBFu0i_Sf_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_Sf, aBFu0i_Sf_Sf)
//============================================================================



static void Test_aBFu0i_Sf_Uc()
{
  {
    init_simple_test("aBFu0i_Sf_Uc");
    static STRUCT_IF_C aBFu0i_Sf_Uc lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_Uc.v1");
    check_field_offset(lv, v2, 0, "aBFu0i_Sf_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_Uc, aBFu0i_Sf_Uc)
//============================================================================



static void Test_aBFu0i_Sf_Ui()
{
  {
    init_simple_test("aBFu0i_Sf_Ui");
    static STRUCT_IF_C aBFu0i_Sf_Ui lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_Ui.v1");
    check_field_offset(lv, v2, 0, "aBFu0i_Sf_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_Ui, aBFu0i_Sf_Ui)
//============================================================================



static void Test_aBFu0i_Sf_Ul()
{
  {
    init_simple_test("aBFu0i_Sf_Ul");
    static STRUCT_IF_C aBFu0i_Sf_Ul lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0i_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_Ul.v1");
    check_field_offset(lv, v2, 0, "aBFu0i_Sf_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_Ul, aBFu0i_Sf_Ul)
//============================================================================



static void Test_aBFu0i_Sf_Us()
{
  {
    init_simple_test("aBFu0i_Sf_Us");
    static STRUCT_IF_C aBFu0i_Sf_Us lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_Us)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_Us.v1");
    check_field_offset(lv, v2, 0, "aBFu0i_Sf_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_Us, aBFu0i_Sf_Us)
//============================================================================



static void Test_aBFu0i_Sf_Vp()
{
  {
    init_simple_test("aBFu0i_Sf_Vp");
    static STRUCT_IF_C aBFu0i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0i_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Sf_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0i_Sf_Vp.v1");
    check_field_offset(lv, v2, 0, "aBFu0i_Sf_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Sf_Vp, aBFu0i_Sf_Vp)
//============================================================================



static void Test_aBFu0i_Uc_Sf()
{
  {
    init_simple_test("aBFu0i_Uc_Sf");
    static STRUCT_IF_C aBFu0i_Uc_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0i_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Uc_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_Uc_Sf.v1");
    check_field_offset(lv, v2, 1, "aBFu0i_Uc_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Uc_Sf, aBFu0i_Uc_Sf)
//============================================================================



static void Test_aBFu0i_Ui_Sf()
{
  {
    init_simple_test("aBFu0i_Ui_Sf");
    static STRUCT_IF_C aBFu0i_Ui_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0i_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Ui_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_Ui_Sf.v1");
    check_field_offset(lv, v2, 4, "aBFu0i_Ui_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Ui_Sf, aBFu0i_Ui_Sf)
//============================================================================



static void Test_aBFu0i_Ul_Sf()
{
  {
    init_simple_test("aBFu0i_Ul_Sf");
    static STRUCT_IF_C aBFu0i_Ul_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0i_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Ul_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_Ul_Sf.v1");
    check_field_offset(lv, v2, 8, "aBFu0i_Ul_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Ul_Sf, aBFu0i_Ul_Sf)
//============================================================================



static void Test_aBFu0i_Us_Sf()
{
  {
    init_simple_test("aBFu0i_Us_Sf");
    static STRUCT_IF_C aBFu0i_Us_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0i_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Us_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_Us_Sf.v1");
    check_field_offset(lv, v2, 2, "aBFu0i_Us_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Us_Sf, aBFu0i_Us_Sf)
//============================================================================



static void Test_aBFu0i_Vp_Sf()
{
  {
    init_simple_test("aBFu0i_Vp_Sf");
    static STRUCT_IF_C aBFu0i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0i_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0i_Vp_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0i_Vp_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0i_Vp_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0i_Vp_Sf, aBFu0i_Vp_Sf)
//============================================================================



static void Test_aBFu0ll_BFu0c_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu0c_Sf");
    static STRUCT_IF_C aBFu0ll_BFu0c_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_BFu0c_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu0c_Sf, aBFu0ll_BFu0c_Sf)
//============================================================================



static void Test_aBFu0ll_BFu0i_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu0i_Sf");
    static STRUCT_IF_C aBFu0ll_BFu0i_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0ll_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_BFu0i_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu0i_Sf, aBFu0ll_BFu0i_Sf)
//============================================================================



static void Test_aBFu0ll_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu0ll_Sf");
    static STRUCT_IF_C aBFu0ll_BFu0ll_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0ll_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_BFu0ll_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu0ll_Sf, aBFu0ll_BFu0ll_Sf)
//============================================================================



static void Test_aBFu0ll_BFu0s_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu0s_Sf");
    static STRUCT_IF_C aBFu0ll_BFu0s_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0ll_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_BFu0s_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu0s_Sf, aBFu0ll_BFu0s_Sf)
//============================================================================



static void Test_aBFu0ll_BFu15i_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu15i_Sf");
    static STRUCT_IF_C aBFu0ll_BFu15i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0ll_BFu15i_Sf");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu15i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu15i_Sf, aBFu0ll_BFu15i_Sf)
//============================================================================



static void Test_aBFu0ll_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu15ll_Sf");
    static STRUCT_IF_C aBFu0ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0ll_BFu15ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu15ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu15ll_Sf, aBFu0ll_BFu15ll_Sf)
//============================================================================



static void Test_aBFu0ll_BFu15s_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu15s_Sf");
    static STRUCT_IF_C aBFu0ll_BFu15s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0ll_BFu15s_Sf");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu15s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu15s_Sf, aBFu0ll_BFu15s_Sf)
//============================================================================



static void Test_aBFu0ll_BFu16i_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu16i_Sf");
    static STRUCT_IF_C aBFu0ll_BFu16i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0ll_BFu16i_Sf");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu16i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu16i_Sf, aBFu0ll_BFu16i_Sf)
//============================================================================



static void Test_aBFu0ll_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu16ll_Sf");
    static STRUCT_IF_C aBFu0ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0ll_BFu16ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu16ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu16ll_Sf, aBFu0ll_BFu16ll_Sf)
//============================================================================



static void Test_aBFu0ll_BFu16s_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu16s_Sf");
    static STRUCT_IF_C aBFu0ll_BFu16s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0ll_BFu16s_Sf");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu16s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu16s_Sf, aBFu0ll_BFu16s_Sf)
//============================================================================



static void Test_aBFu0ll_BFu17i_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu17i_Sf");
    static STRUCT_IF_C aBFu0ll_BFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0ll_BFu17i_Sf");
    check_field_offset(lv, v2, 3, "aBFu0ll_BFu17i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu17i_Sf, aBFu0ll_BFu17i_Sf)
//============================================================================



static void Test_aBFu0ll_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu17ll_Sf");
    static STRUCT_IF_C aBFu0ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0ll_BFu17ll_Sf");
    check_field_offset(lv, v2, 3, "aBFu0ll_BFu17ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu17ll_Sf, aBFu0ll_BFu17ll_Sf)
//============================================================================



static void Test_aBFu0ll_BFu1c_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu1c_Sf");
    static STRUCT_IF_C aBFu0ll_BFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0ll_BFu1c_Sf");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu1c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu1c_Sf, aBFu0ll_BFu1c_Sf)
//============================================================================



static void Test_aBFu0ll_BFu1i_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu1i_Sf");
    static STRUCT_IF_C aBFu0ll_BFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0ll_BFu1i_Sf");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu1i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu1i_Sf, aBFu0ll_BFu1i_Sf)
//============================================================================



static void Test_aBFu0ll_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu1ll_Sf");
    static STRUCT_IF_C aBFu0ll_BFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0ll_BFu1ll_Sf");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu1ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu1ll_Sf, aBFu0ll_BFu1ll_Sf)
//============================================================================



static void Test_aBFu0ll_BFu1s_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu1s_Sf");
    static STRUCT_IF_C aBFu0ll_BFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0ll_BFu1s_Sf");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu1s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu1s_Sf, aBFu0ll_BFu1s_Sf)
//============================================================================



static void Test_aBFu0ll_BFu31i_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu31i_Sf");
    static STRUCT_IF_C aBFu0ll_BFu31i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0ll_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0ll_BFu31i_Sf");
    check_field_offset(lv, v2, 4, "aBFu0ll_BFu31i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu31i_Sf, aBFu0ll_BFu31i_Sf)
//============================================================================



static void Test_aBFu0ll_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu31ll_Sf");
    static STRUCT_IF_C aBFu0ll_BFu31ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0ll_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0ll_BFu31ll_Sf");
    check_field_offset(lv, v2, 4, "aBFu0ll_BFu31ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu31ll_Sf, aBFu0ll_BFu31ll_Sf)
//============================================================================



static void Test_aBFu0ll_BFu32i_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu32i_Sf");
    static STRUCT_IF_C aBFu0ll_BFu32i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0ll_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0ll_BFu32i_Sf");
    check_field_offset(lv, v2, 4, "aBFu0ll_BFu32i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu32i_Sf, aBFu0ll_BFu32i_Sf)
//============================================================================



static void Test_aBFu0ll_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu32ll_Sf");
    static STRUCT_IF_C aBFu0ll_BFu32ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0ll_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0ll_BFu32ll_Sf");
    check_field_offset(lv, v2, 4, "aBFu0ll_BFu32ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu32ll_Sf, aBFu0ll_BFu32ll_Sf)
//============================================================================



static void Test_aBFu0ll_BFu33_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu33_Sf");
    static STRUCT_IF_C aBFu0ll_BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu0ll_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu0ll_BFu33_Sf");
    check_field_offset(lv, v2, 5, "aBFu0ll_BFu33_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu33_Sf, aBFu0ll_BFu33_Sf)
//============================================================================



static void Test_aBFu0ll_BFu7c_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu7c_Sf");
    static STRUCT_IF_C aBFu0ll_BFu7c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0ll_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0ll_BFu7c_Sf");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu7c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu7c_Sf, aBFu0ll_BFu7c_Sf)
//============================================================================



static void Test_aBFu0ll_BFu7i_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu7i_Sf");
    static STRUCT_IF_C aBFu0ll_BFu7i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0ll_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0ll_BFu7i_Sf");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu7i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu7i_Sf, aBFu0ll_BFu7i_Sf)
//============================================================================



static void Test_aBFu0ll_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu7ll_Sf");
    static STRUCT_IF_C aBFu0ll_BFu7ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0ll_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0ll_BFu7ll_Sf");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu7ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu7ll_Sf, aBFu0ll_BFu7ll_Sf)
//============================================================================



static void Test_aBFu0ll_BFu7s_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu7s_Sf");
    static STRUCT_IF_C aBFu0ll_BFu7s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0ll_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0ll_BFu7s_Sf");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu7s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu7s_Sf, aBFu0ll_BFu7s_Sf)
//============================================================================



static void Test_aBFu0ll_BFu8c_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu8c_Sf");
    static STRUCT_IF_C aBFu0ll_BFu8c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0ll_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0ll_BFu8c_Sf");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu8c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu8c_Sf, aBFu0ll_BFu8c_Sf)
//============================================================================



static void Test_aBFu0ll_BFu8i_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu8i_Sf");
    static STRUCT_IF_C aBFu0ll_BFu8i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0ll_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0ll_BFu8i_Sf");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu8i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu8i_Sf, aBFu0ll_BFu8i_Sf)
//============================================================================



static void Test_aBFu0ll_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu8ll_Sf");
    static STRUCT_IF_C aBFu0ll_BFu8ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0ll_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0ll_BFu8ll_Sf");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu8ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu8ll_Sf, aBFu0ll_BFu8ll_Sf)
//============================================================================



static void Test_aBFu0ll_BFu8s_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu8s_Sf");
    static STRUCT_IF_C aBFu0ll_BFu8s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0ll_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0ll_BFu8s_Sf");
    check_field_offset(lv, v2, 1, "aBFu0ll_BFu8s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu8s_Sf, aBFu0ll_BFu8s_Sf)
//============================================================================



static void Test_aBFu0ll_BFu9i_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu9i_Sf");
    static STRUCT_IF_C aBFu0ll_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0ll_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0ll_BFu9i_Sf");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu9i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu9i_Sf, aBFu0ll_BFu9i_Sf)
//============================================================================



static void Test_aBFu0ll_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu9ll_Sf");
    static STRUCT_IF_C aBFu0ll_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0ll_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0ll_BFu9ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu9ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu9ll_Sf, aBFu0ll_BFu9ll_Sf)
//============================================================================



static void Test_aBFu0ll_BFu9s_Sf()
{
  {
    init_simple_test("aBFu0ll_BFu9s_Sf");
    static STRUCT_IF_C aBFu0ll_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0ll_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0ll_BFu9s_Sf");
    check_field_offset(lv, v2, 2, "aBFu0ll_BFu9s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_BFu9s_Sf, aBFu0ll_BFu9s_Sf)
//============================================================================



static void Test_aBFu0ll_C_Sf()
{
  {
    init_simple_test("aBFu0ll_C_Sf");
    static STRUCT_IF_C aBFu0ll_C_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_C_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_C_Sf.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_C_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_C_Sf, aBFu0ll_C_Sf)
//============================================================================



static void Test_aBFu0ll_D_Sf()
{
  {
    init_simple_test("aBFu0ll_D_Sf");
    static STRUCT_IF_C aBFu0ll_D_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0ll_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_D_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_D_Sf.v1");
    check_field_offset(lv, v2, 8, "aBFu0ll_D_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_D_Sf, aBFu0ll_D_Sf)
//============================================================================



static void Test_aBFu0ll_F_Sf()
{
  {
    init_simple_test("aBFu0ll_F_Sf");
    static STRUCT_IF_C aBFu0ll_F_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_F_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_F_Sf.v1");
    check_field_offset(lv, v2, 4, "aBFu0ll_F_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_F_Sf, aBFu0ll_F_Sf)
//============================================================================



static void Test_aBFu0ll_I_Sf()
{
  {
    init_simple_test("aBFu0ll_I_Sf");
    static STRUCT_IF_C aBFu0ll_I_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_I_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_I_Sf.v1");
    check_field_offset(lv, v2, 4, "aBFu0ll_I_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_I_Sf, aBFu0ll_I_Sf)
//============================================================================



static void Test_aBFu0ll_Ip_Sf()
{
  {
    init_simple_test("aBFu0ll_Ip_Sf");
    static STRUCT_IF_C aBFu0ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0ll_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Ip_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Ip_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0ll_Ip_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Ip_Sf, aBFu0ll_Ip_Sf)
//============================================================================



static void Test_aBFu0ll_L_Sf()
{
  {
    init_simple_test("aBFu0ll_L_Sf");
    static STRUCT_IF_C aBFu0ll_L_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0ll_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_L_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_L_Sf.v1");
    check_field_offset(lv, v2, 8, "aBFu0ll_L_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_L_Sf, aBFu0ll_L_Sf)
//============================================================================



static void Test_aBFu0ll_S_Sf()
{
  {
    init_simple_test("aBFu0ll_S_Sf");
    static STRUCT_IF_C aBFu0ll_S_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_S_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_S_Sf.v1");
    check_field_offset(lv, v2, 2, "aBFu0ll_S_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_S_Sf, aBFu0ll_S_Sf)
//============================================================================



static void Test_aBFu0ll_Sf()
{
  {
    init_simple_test("aBFu0ll_Sf");
    static STRUCT_IF_C aBFu0ll_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf, aBFu0ll_Sf)
//============================================================================



static void Test_aBFu0ll_Sf_BFu0c()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu0c");
    static STRUCT_IF_C aBFu0ll_Sf_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu0c, aBFu0ll_Sf_BFu0c)
//============================================================================



static void Test_aBFu0ll_Sf_BFu0i()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu0i");
    static STRUCT_IF_C aBFu0ll_Sf_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0ll_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu0i, aBFu0ll_Sf_BFu0i)
//============================================================================



static void Test_aBFu0ll_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu0ll");
    static STRUCT_IF_C aBFu0ll_Sf_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0ll_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu0ll, aBFu0ll_Sf_BFu0ll)
//============================================================================



static void Test_aBFu0ll_Sf_BFu0s()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu0s");
    static STRUCT_IF_C aBFu0ll_Sf_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0ll_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu0s, aBFu0ll_Sf_BFu0s)
//============================================================================



static void Test_aBFu0ll_Sf_BFu15i()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu15i");
    static STRUCT_IF_C aBFu0ll_Sf_BFu15i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu15i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aBFu0ll_Sf_BFu15i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aBFu0ll_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu15i, aBFu0ll_Sf_BFu15i)
//============================================================================



static void Test_aBFu0ll_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu15ll");
    static STRUCT_IF_C aBFu0ll_Sf_BFu15ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu15ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aBFu0ll_Sf_BFu15ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aBFu0ll_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu15ll, aBFu0ll_Sf_BFu15ll)
//============================================================================



static void Test_aBFu0ll_Sf_BFu15s()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu15s");
    static STRUCT_IF_C aBFu0ll_Sf_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu15s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aBFu0ll_Sf_BFu15s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aBFu0ll_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu15s, aBFu0ll_Sf_BFu15s)
//============================================================================



static void Test_aBFu0ll_Sf_BFu16i()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu16i");
    static STRUCT_IF_C aBFu0ll_Sf_BFu16i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu16i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aBFu0ll_Sf_BFu16i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aBFu0ll_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu16i, aBFu0ll_Sf_BFu16i)
//============================================================================



static void Test_aBFu0ll_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu16ll");
    static STRUCT_IF_C aBFu0ll_Sf_BFu16ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu16ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aBFu0ll_Sf_BFu16ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aBFu0ll_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu16ll, aBFu0ll_Sf_BFu16ll)
//============================================================================



static void Test_aBFu0ll_Sf_BFu16s()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu16s");
    static STRUCT_IF_C aBFu0ll_Sf_BFu16s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu16s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aBFu0ll_Sf_BFu16s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aBFu0ll_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu16s, aBFu0ll_Sf_BFu16s)
//============================================================================



static void Test_aBFu0ll_Sf_BFu17i()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu17i");
    static STRUCT_IF_C aBFu0ll_Sf_BFu17i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu17i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aBFu0ll_Sf_BFu17i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aBFu0ll_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu17i, aBFu0ll_Sf_BFu17i)
//============================================================================



static void Test_aBFu0ll_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu17ll");
    static STRUCT_IF_C aBFu0ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0ll_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu17ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aBFu0ll_Sf_BFu17ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aBFu0ll_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu17ll, aBFu0ll_Sf_BFu17ll)
//============================================================================



static void Test_aBFu0ll_Sf_BFu1c()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu1c");
    static STRUCT_IF_C aBFu0ll_Sf_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu1c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0ll_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu1c, aBFu0ll_Sf_BFu1c)
//============================================================================



static void Test_aBFu0ll_Sf_BFu1i()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu1i");
    static STRUCT_IF_C aBFu0ll_Sf_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu1i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0ll_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu1i, aBFu0ll_Sf_BFu1i)
//============================================================================



static void Test_aBFu0ll_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu1ll");
    static STRUCT_IF_C aBFu0ll_Sf_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu1ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0ll_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu1ll, aBFu0ll_Sf_BFu1ll)
//============================================================================



static void Test_aBFu0ll_Sf_BFu1s()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu1s");
    static STRUCT_IF_C aBFu0ll_Sf_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu1s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0ll_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu1s, aBFu0ll_Sf_BFu1s)
//============================================================================



static void Test_aBFu0ll_Sf_BFu31i()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu31i");
    static STRUCT_IF_C aBFu0ll_Sf_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu31i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aBFu0ll_Sf_BFu31i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aBFu0ll_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu31i, aBFu0ll_Sf_BFu31i)
//============================================================================



static void Test_aBFu0ll_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu31ll");
    static STRUCT_IF_C aBFu0ll_Sf_BFu31ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu31ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aBFu0ll_Sf_BFu31ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aBFu0ll_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu31ll, aBFu0ll_Sf_BFu31ll)
//============================================================================



static void Test_aBFu0ll_Sf_BFu32i()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu32i");
    static STRUCT_IF_C aBFu0ll_Sf_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu32i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aBFu0ll_Sf_BFu32i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aBFu0ll_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu32i, aBFu0ll_Sf_BFu32i)
//============================================================================



static void Test_aBFu0ll_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu32ll");
    static STRUCT_IF_C aBFu0ll_Sf_BFu32ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu32ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aBFu0ll_Sf_BFu32ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aBFu0ll_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu32ll, aBFu0ll_Sf_BFu32ll)
//============================================================================



static void Test_aBFu0ll_Sf_BFu33()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu33");
    static STRUCT_IF_C aBFu0ll_Sf_BFu33 lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0ll_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu33.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "aBFu0ll_Sf_BFu33");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "aBFu0ll_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu33, aBFu0ll_Sf_BFu33)
//============================================================================



static void Test_aBFu0ll_Sf_BFu7c()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu7c");
    static STRUCT_IF_C aBFu0ll_Sf_BFu7c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu7c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0ll_Sf_BFu7c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0ll_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu7c, aBFu0ll_Sf_BFu7c)
//============================================================================



static void Test_aBFu0ll_Sf_BFu7i()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu7i");
    static STRUCT_IF_C aBFu0ll_Sf_BFu7i lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu7i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0ll_Sf_BFu7i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0ll_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu7i, aBFu0ll_Sf_BFu7i)
//============================================================================



static void Test_aBFu0ll_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu7ll");
    static STRUCT_IF_C aBFu0ll_Sf_BFu7ll lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu7ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0ll_Sf_BFu7ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0ll_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu7ll, aBFu0ll_Sf_BFu7ll)
//============================================================================



static void Test_aBFu0ll_Sf_BFu7s()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu7s");
    static STRUCT_IF_C aBFu0ll_Sf_BFu7s lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu7s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0ll_Sf_BFu7s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0ll_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu7s, aBFu0ll_Sf_BFu7s)
//============================================================================



static void Test_aBFu0ll_Sf_BFu8c()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu8c");
    static STRUCT_IF_C aBFu0ll_Sf_BFu8c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu8c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0ll_Sf_BFu8c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0ll_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu8c, aBFu0ll_Sf_BFu8c)
//============================================================================



static void Test_aBFu0ll_Sf_BFu8i()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu8i");
    static STRUCT_IF_C aBFu0ll_Sf_BFu8i lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu8i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0ll_Sf_BFu8i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0ll_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu8i, aBFu0ll_Sf_BFu8i)
//============================================================================



static void Test_aBFu0ll_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu8ll");
    static STRUCT_IF_C aBFu0ll_Sf_BFu8ll lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu8ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0ll_Sf_BFu8ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0ll_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu8ll, aBFu0ll_Sf_BFu8ll)
//============================================================================



static void Test_aBFu0ll_Sf_BFu8s()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu8s");
    static STRUCT_IF_C aBFu0ll_Sf_BFu8s lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu8s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0ll_Sf_BFu8s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0ll_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu8s, aBFu0ll_Sf_BFu8s)
//============================================================================



static void Test_aBFu0ll_Sf_BFu9i()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu9i");
    static STRUCT_IF_C aBFu0ll_Sf_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu9i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aBFu0ll_Sf_BFu9i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aBFu0ll_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu9i, aBFu0ll_Sf_BFu9i)
//============================================================================



static void Test_aBFu0ll_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu9ll");
    static STRUCT_IF_C aBFu0ll_Sf_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu9ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aBFu0ll_Sf_BFu9ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aBFu0ll_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu9ll, aBFu0ll_Sf_BFu9ll)
//============================================================================



static void Test_aBFu0ll_Sf_BFu9s()
{
  {
    init_simple_test("aBFu0ll_Sf_BFu9s");
    static STRUCT_IF_C aBFu0ll_Sf_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_BFu9s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aBFu0ll_Sf_BFu9s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aBFu0ll_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_BFu9s, aBFu0ll_Sf_BFu9s)
//============================================================================



static void Test_aBFu0ll_Sf_C()
{
  {
    init_simple_test("aBFu0ll_Sf_C");
    static STRUCT_IF_C aBFu0ll_Sf_C lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_C)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_C.v1");
    check_field_offset(lv, v2, 0, "aBFu0ll_Sf_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_C, aBFu0ll_Sf_C)
//============================================================================



static void Test_aBFu0ll_Sf_D()
{
  {
    init_simple_test("aBFu0ll_Sf_D");
    static STRUCT_IF_C aBFu0ll_Sf_D lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0ll_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_D)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_D.v1");
    check_field_offset(lv, v2, 0, "aBFu0ll_Sf_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_D, aBFu0ll_Sf_D)
//============================================================================



static void Test_aBFu0ll_Sf_F()
{
  {
    init_simple_test("aBFu0ll_Sf_F");
    static STRUCT_IF_C aBFu0ll_Sf_F lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_F)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_F.v1");
    check_field_offset(lv, v2, 0, "aBFu0ll_Sf_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_F, aBFu0ll_Sf_F)
//============================================================================



static void Test_aBFu0ll_Sf_I()
{
  {
    init_simple_test("aBFu0ll_Sf_I");
    static STRUCT_IF_C aBFu0ll_Sf_I lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_I)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_I.v1");
    check_field_offset(lv, v2, 0, "aBFu0ll_Sf_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_I, aBFu0ll_Sf_I)
//============================================================================



static void Test_aBFu0ll_Sf_Ip()
{
  {
    init_simple_test("aBFu0ll_Sf_Ip");
    static STRUCT_IF_C aBFu0ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0ll_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_Ip.v1");
    check_field_offset(lv, v2, 0, "aBFu0ll_Sf_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_Ip, aBFu0ll_Sf_Ip)
//============================================================================



static void Test_aBFu0ll_Sf_L()
{
  {
    init_simple_test("aBFu0ll_Sf_L");
    static STRUCT_IF_C aBFu0ll_Sf_L lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0ll_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_L)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_L.v1");
    check_field_offset(lv, v2, 0, "aBFu0ll_Sf_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_L, aBFu0ll_Sf_L)
//============================================================================



static void Test_aBFu0ll_Sf_S()
{
  {
    init_simple_test("aBFu0ll_Sf_S");
    static STRUCT_IF_C aBFu0ll_Sf_S lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_S)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_S.v1");
    check_field_offset(lv, v2, 0, "aBFu0ll_Sf_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_S, aBFu0ll_Sf_S)
//============================================================================



static void Test_aBFu0ll_Sf_Sf()
{
  {
    init_simple_test("aBFu0ll_Sf_Sf");
    static STRUCT_IF_C aBFu0ll_Sf_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0ll_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_Sf.v1");
    check_field_offset(lv, v2, 0, "aBFu0ll_Sf_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_Sf, aBFu0ll_Sf_Sf)
//============================================================================



static void Test_aBFu0ll_Sf_Uc()
{
  {
    init_simple_test("aBFu0ll_Sf_Uc");
    static STRUCT_IF_C aBFu0ll_Sf_Uc lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_Uc.v1");
    check_field_offset(lv, v2, 0, "aBFu0ll_Sf_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_Uc, aBFu0ll_Sf_Uc)
//============================================================================



static void Test_aBFu0ll_Sf_Ui()
{
  {
    init_simple_test("aBFu0ll_Sf_Ui");
    static STRUCT_IF_C aBFu0ll_Sf_Ui lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_Ui.v1");
    check_field_offset(lv, v2, 0, "aBFu0ll_Sf_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_Ui, aBFu0ll_Sf_Ui)
//============================================================================



static void Test_aBFu0ll_Sf_Ul()
{
  {
    init_simple_test("aBFu0ll_Sf_Ul");
    static STRUCT_IF_C aBFu0ll_Sf_Ul lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0ll_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_Ul.v1");
    check_field_offset(lv, v2, 0, "aBFu0ll_Sf_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_Ul, aBFu0ll_Sf_Ul)
//============================================================================



static void Test_aBFu0ll_Sf_Us()
{
  {
    init_simple_test("aBFu0ll_Sf_Us");
    static STRUCT_IF_C aBFu0ll_Sf_Us lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_Us)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_Us.v1");
    check_field_offset(lv, v2, 0, "aBFu0ll_Sf_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_Us, aBFu0ll_Sf_Us)
//============================================================================



static void Test_aBFu0ll_Sf_Vp()
{
  {
    init_simple_test("aBFu0ll_Sf_Vp");
    static STRUCT_IF_C aBFu0ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0ll_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Sf_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Sf_Vp.v1");
    check_field_offset(lv, v2, 0, "aBFu0ll_Sf_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Sf_Vp, aBFu0ll_Sf_Vp)
//============================================================================



static void Test_aBFu0ll_Uc_Sf()
{
  {
    init_simple_test("aBFu0ll_Uc_Sf");
    static STRUCT_IF_C aBFu0ll_Uc_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0ll_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Uc_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Uc_Sf.v1");
    check_field_offset(lv, v2, 1, "aBFu0ll_Uc_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Uc_Sf, aBFu0ll_Uc_Sf)
//============================================================================



static void Test_aBFu0ll_Ui_Sf()
{
  {
    init_simple_test("aBFu0ll_Ui_Sf");
    static STRUCT_IF_C aBFu0ll_Ui_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0ll_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Ui_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Ui_Sf.v1");
    check_field_offset(lv, v2, 4, "aBFu0ll_Ui_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Ui_Sf, aBFu0ll_Ui_Sf)
//============================================================================



static void Test_aBFu0ll_Ul_Sf()
{
  {
    init_simple_test("aBFu0ll_Ul_Sf");
    static STRUCT_IF_C aBFu0ll_Ul_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0ll_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Ul_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Ul_Sf.v1");
    check_field_offset(lv, v2, 8, "aBFu0ll_Ul_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Ul_Sf, aBFu0ll_Ul_Sf)
//============================================================================



static void Test_aBFu0ll_Us_Sf()
{
  {
    init_simple_test("aBFu0ll_Us_Sf");
    static STRUCT_IF_C aBFu0ll_Us_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0ll_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Us_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Us_Sf.v1");
    check_field_offset(lv, v2, 2, "aBFu0ll_Us_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Us_Sf, aBFu0ll_Us_Sf)
//============================================================================



static void Test_aBFu0ll_Vp_Sf()
{
  {
    init_simple_test("aBFu0ll_Vp_Sf");
    static STRUCT_IF_C aBFu0ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0ll_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0ll_Vp_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0ll_Vp_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0ll_Vp_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0ll_Vp_Sf, aBFu0ll_Vp_Sf)
//============================================================================



static void Test_aBFu0s_BFu0c_Sf()
{
  {
    init_simple_test("aBFu0s_BFu0c_Sf");
    static STRUCT_IF_C aBFu0s_BFu0c_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0s_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_BFu0c_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu0c_Sf, aBFu0s_BFu0c_Sf)
//============================================================================



static void Test_aBFu0s_BFu0i_Sf()
{
  {
    init_simple_test("aBFu0s_BFu0i_Sf");
    static STRUCT_IF_C aBFu0s_BFu0i_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0s_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_BFu0i_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu0i_Sf, aBFu0s_BFu0i_Sf)
//============================================================================



static void Test_aBFu0s_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu0s_BFu0ll_Sf");
    static STRUCT_IF_C aBFu0s_BFu0ll_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0s_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_BFu0ll_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu0ll_Sf, aBFu0s_BFu0ll_Sf)
//============================================================================



static void Test_aBFu0s_BFu0s_Sf()
{
  {
    init_simple_test("aBFu0s_BFu0s_Sf");
    static STRUCT_IF_C aBFu0s_BFu0s_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0s_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_BFu0s_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu0s_Sf, aBFu0s_BFu0s_Sf)
//============================================================================



static void Test_aBFu0s_BFu15i_Sf()
{
  {
    init_simple_test("aBFu0s_BFu15i_Sf");
    static STRUCT_IF_C aBFu0s_BFu15i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0s_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0s_BFu15i_Sf");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu15i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu15i_Sf, aBFu0s_BFu15i_Sf)
//============================================================================



static void Test_aBFu0s_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu0s_BFu15ll_Sf");
    static STRUCT_IF_C aBFu0s_BFu15ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0s_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0s_BFu15ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu15ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu15ll_Sf, aBFu0s_BFu15ll_Sf)
//============================================================================



static void Test_aBFu0s_BFu15s_Sf()
{
  {
    init_simple_test("aBFu0s_BFu15s_Sf");
    static STRUCT_IF_C aBFu0s_BFu15s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu0s_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu0s_BFu15s_Sf");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu15s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu15s_Sf, aBFu0s_BFu15s_Sf)
//============================================================================



static void Test_aBFu0s_BFu16i_Sf()
{
  {
    init_simple_test("aBFu0s_BFu16i_Sf");
    static STRUCT_IF_C aBFu0s_BFu16i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0s_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0s_BFu16i_Sf");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu16i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu16i_Sf, aBFu0s_BFu16i_Sf)
//============================================================================



static void Test_aBFu0s_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu0s_BFu16ll_Sf");
    static STRUCT_IF_C aBFu0s_BFu16ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0s_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0s_BFu16ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu16ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu16ll_Sf, aBFu0s_BFu16ll_Sf)
//============================================================================



static void Test_aBFu0s_BFu16s_Sf()
{
  {
    init_simple_test("aBFu0s_BFu16s_Sf");
    static STRUCT_IF_C aBFu0s_BFu16s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu0s_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu0s_BFu16s_Sf");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu16s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu16s_Sf, aBFu0s_BFu16s_Sf)
//============================================================================



static void Test_aBFu0s_BFu17i_Sf()
{
  {
    init_simple_test("aBFu0s_BFu17i_Sf");
    static STRUCT_IF_C aBFu0s_BFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0s_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0s_BFu17i_Sf");
    check_field_offset(lv, v2, 3, "aBFu0s_BFu17i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu17i_Sf, aBFu0s_BFu17i_Sf)
//============================================================================



static void Test_aBFu0s_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu0s_BFu17ll_Sf");
    static STRUCT_IF_C aBFu0s_BFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu0s_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu0s_BFu17ll_Sf");
    check_field_offset(lv, v2, 3, "aBFu0s_BFu17ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu17ll_Sf, aBFu0s_BFu17ll_Sf)
//============================================================================



static void Test_aBFu0s_BFu1c_Sf()
{
  {
    init_simple_test("aBFu0s_BFu1c_Sf");
    static STRUCT_IF_C aBFu0s_BFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0s_BFu1c_Sf");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu1c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu1c_Sf, aBFu0s_BFu1c_Sf)
//============================================================================



static void Test_aBFu0s_BFu1i_Sf()
{
  {
    init_simple_test("aBFu0s_BFu1i_Sf");
    static STRUCT_IF_C aBFu0s_BFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0s_BFu1i_Sf");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu1i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu1i_Sf, aBFu0s_BFu1i_Sf)
//============================================================================



static void Test_aBFu0s_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu0s_BFu1ll_Sf");
    static STRUCT_IF_C aBFu0s_BFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0s_BFu1ll_Sf");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu1ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu1ll_Sf, aBFu0s_BFu1ll_Sf)
//============================================================================



static void Test_aBFu0s_BFu1s_Sf()
{
  {
    init_simple_test("aBFu0s_BFu1s_Sf");
    static STRUCT_IF_C aBFu0s_BFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu0s_BFu1s_Sf");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu1s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu1s_Sf, aBFu0s_BFu1s_Sf)
//============================================================================



static void Test_aBFu0s_BFu31i_Sf()
{
  {
    init_simple_test("aBFu0s_BFu31i_Sf");
    static STRUCT_IF_C aBFu0s_BFu31i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0s_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0s_BFu31i_Sf");
    check_field_offset(lv, v2, 4, "aBFu0s_BFu31i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu31i_Sf, aBFu0s_BFu31i_Sf)
//============================================================================



static void Test_aBFu0s_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu0s_BFu31ll_Sf");
    static STRUCT_IF_C aBFu0s_BFu31ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu0s_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu0s_BFu31ll_Sf");
    check_field_offset(lv, v2, 4, "aBFu0s_BFu31ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu31ll_Sf, aBFu0s_BFu31ll_Sf)
//============================================================================



static void Test_aBFu0s_BFu32i_Sf()
{
  {
    init_simple_test("aBFu0s_BFu32i_Sf");
    static STRUCT_IF_C aBFu0s_BFu32i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0s_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0s_BFu32i_Sf");
    check_field_offset(lv, v2, 4, "aBFu0s_BFu32i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu32i_Sf, aBFu0s_BFu32i_Sf)
//============================================================================



static void Test_aBFu0s_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu0s_BFu32ll_Sf");
    static STRUCT_IF_C aBFu0s_BFu32ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu0s_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu0s_BFu32ll_Sf");
    check_field_offset(lv, v2, 4, "aBFu0s_BFu32ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu32ll_Sf, aBFu0s_BFu32ll_Sf)
//============================================================================



static void Test_aBFu0s_BFu33_Sf()
{
  {
    init_simple_test("aBFu0s_BFu33_Sf");
    static STRUCT_IF_C aBFu0s_BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu0s_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu0s_BFu33_Sf");
    check_field_offset(lv, v2, 5, "aBFu0s_BFu33_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu33_Sf, aBFu0s_BFu33_Sf)
//============================================================================



static void Test_aBFu0s_BFu7c_Sf()
{
  {
    init_simple_test("aBFu0s_BFu7c_Sf");
    static STRUCT_IF_C aBFu0s_BFu7c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0s_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0s_BFu7c_Sf");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu7c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu7c_Sf, aBFu0s_BFu7c_Sf)
//============================================================================



static void Test_aBFu0s_BFu7i_Sf()
{
  {
    init_simple_test("aBFu0s_BFu7i_Sf");
    static STRUCT_IF_C aBFu0s_BFu7i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0s_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0s_BFu7i_Sf");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu7i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu7i_Sf, aBFu0s_BFu7i_Sf)
//============================================================================



static void Test_aBFu0s_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu0s_BFu7ll_Sf");
    static STRUCT_IF_C aBFu0s_BFu7ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0s_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0s_BFu7ll_Sf");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu7ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu7ll_Sf, aBFu0s_BFu7ll_Sf)
//============================================================================



static void Test_aBFu0s_BFu7s_Sf()
{
  {
    init_simple_test("aBFu0s_BFu7s_Sf");
    static STRUCT_IF_C aBFu0s_BFu7s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu0s_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu0s_BFu7s_Sf");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu7s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu7s_Sf, aBFu0s_BFu7s_Sf)
//============================================================================



static void Test_aBFu0s_BFu8c_Sf()
{
  {
    init_simple_test("aBFu0s_BFu8c_Sf");
    static STRUCT_IF_C aBFu0s_BFu8c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0s_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0s_BFu8c_Sf");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu8c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu8c_Sf, aBFu0s_BFu8c_Sf)
//============================================================================



static void Test_aBFu0s_BFu8i_Sf()
{
  {
    init_simple_test("aBFu0s_BFu8i_Sf");
    static STRUCT_IF_C aBFu0s_BFu8i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0s_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0s_BFu8i_Sf");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu8i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu8i_Sf, aBFu0s_BFu8i_Sf)
//============================================================================



static void Test_aBFu0s_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu0s_BFu8ll_Sf");
    static STRUCT_IF_C aBFu0s_BFu8ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0s_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0s_BFu8ll_Sf");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu8ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu8ll_Sf, aBFu0s_BFu8ll_Sf)
//============================================================================



static void Test_aBFu0s_BFu8s_Sf()
{
  {
    init_simple_test("aBFu0s_BFu8s_Sf");
    static STRUCT_IF_C aBFu0s_BFu8s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu0s_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu0s_BFu8s_Sf");
    check_field_offset(lv, v2, 1, "aBFu0s_BFu8s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu8s_Sf, aBFu0s_BFu8s_Sf)
//============================================================================



static void Test_aBFu0s_BFu9i_Sf()
{
  {
    init_simple_test("aBFu0s_BFu9i_Sf");
    static STRUCT_IF_C aBFu0s_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0s_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0s_BFu9i_Sf");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu9i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu9i_Sf, aBFu0s_BFu9i_Sf)
//============================================================================



static void Test_aBFu0s_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu0s_BFu9ll_Sf");
    static STRUCT_IF_C aBFu0s_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0s_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0s_BFu9ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu9ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu9ll_Sf, aBFu0s_BFu9ll_Sf)
//============================================================================



static void Test_aBFu0s_BFu9s_Sf()
{
  {
    init_simple_test("aBFu0s_BFu9s_Sf");
    static STRUCT_IF_C aBFu0s_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu0s_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu0s_BFu9s_Sf");
    check_field_offset(lv, v2, 2, "aBFu0s_BFu9s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_BFu9s_Sf, aBFu0s_BFu9s_Sf)
//============================================================================



static void Test_aBFu0s_C_Sf()
{
  {
    init_simple_test("aBFu0s_C_Sf");
    static STRUCT_IF_C aBFu0s_C_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_C_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_C_Sf.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_C_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_C_Sf, aBFu0s_C_Sf)
//============================================================================



static void Test_aBFu0s_D_Sf()
{
  {
    init_simple_test("aBFu0s_D_Sf");
    static STRUCT_IF_C aBFu0s_D_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_D_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_D_Sf.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_D_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_D_Sf, aBFu0s_D_Sf)
//============================================================================



static void Test_aBFu0s_F_Sf()
{
  {
    init_simple_test("aBFu0s_F_Sf");
    static STRUCT_IF_C aBFu0s_F_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_F_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_F_Sf.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_F_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_F_Sf, aBFu0s_F_Sf)
//============================================================================



static void Test_aBFu0s_I_Sf()
{
  {
    init_simple_test("aBFu0s_I_Sf");
    static STRUCT_IF_C aBFu0s_I_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_I_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_I_Sf.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_I_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_I_Sf, aBFu0s_I_Sf)
//============================================================================



static void Test_aBFu0s_Ip_Sf()
{
  {
    init_simple_test("aBFu0s_Ip_Sf");
    static STRUCT_IF_C aBFu0s_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ip_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ip_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Ip_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ip_Sf, aBFu0s_Ip_Sf)
//============================================================================



static void Test_aBFu0s_L_Sf()
{
  {
    init_simple_test("aBFu0s_L_Sf");
    static STRUCT_IF_C aBFu0s_L_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_L_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_L_Sf.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_L_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_L_Sf, aBFu0s_L_Sf)
//============================================================================



static void Test_aBFu0s_S_Sf()
{
  {
    init_simple_test("aBFu0s_S_Sf");
    static STRUCT_IF_C aBFu0s_S_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_S_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_S_Sf.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_S_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_S_Sf, aBFu0s_S_Sf)
//============================================================================



static void Test_aBFu0s_Sf()
{
  {
    init_simple_test("aBFu0s_Sf");
    static STRUCT_IF_C aBFu0s_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf, aBFu0s_Sf)
//============================================================================



static void Test_aBFu0s_Sf_BFu0c()
{
  {
    init_simple_test("aBFu0s_Sf_BFu0c");
    static STRUCT_IF_C aBFu0s_Sf_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0s_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu0c, aBFu0s_Sf_BFu0c)
//============================================================================



static void Test_aBFu0s_Sf_BFu0i()
{
  {
    init_simple_test("aBFu0s_Sf_BFu0i");
    static STRUCT_IF_C aBFu0s_Sf_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0s_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu0i, aBFu0s_Sf_BFu0i)
//============================================================================



static void Test_aBFu0s_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu0s_Sf_BFu0ll");
    static STRUCT_IF_C aBFu0s_Sf_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0s_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu0ll, aBFu0s_Sf_BFu0ll)
//============================================================================



static void Test_aBFu0s_Sf_BFu0s()
{
  {
    init_simple_test("aBFu0s_Sf_BFu0s");
    static STRUCT_IF_C aBFu0s_Sf_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0s_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu0s, aBFu0s_Sf_BFu0s)
//============================================================================



static void Test_aBFu0s_Sf_BFu15i()
{
  {
    init_simple_test("aBFu0s_Sf_BFu15i");
    static STRUCT_IF_C aBFu0s_Sf_BFu15i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu15i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu15i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aBFu0s_Sf_BFu15i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aBFu0s_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu15i, aBFu0s_Sf_BFu15i)
//============================================================================



static void Test_aBFu0s_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu0s_Sf_BFu15ll");
    static STRUCT_IF_C aBFu0s_Sf_BFu15ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu15ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu15ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aBFu0s_Sf_BFu15ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aBFu0s_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu15ll, aBFu0s_Sf_BFu15ll)
//============================================================================



static void Test_aBFu0s_Sf_BFu15s()
{
  {
    init_simple_test("aBFu0s_Sf_BFu15s");
    static STRUCT_IF_C aBFu0s_Sf_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu15s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu15s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aBFu0s_Sf_BFu15s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aBFu0s_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu15s, aBFu0s_Sf_BFu15s)
//============================================================================



static void Test_aBFu0s_Sf_BFu16i()
{
  {
    init_simple_test("aBFu0s_Sf_BFu16i");
    static STRUCT_IF_C aBFu0s_Sf_BFu16i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu16i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu16i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aBFu0s_Sf_BFu16i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aBFu0s_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu16i, aBFu0s_Sf_BFu16i)
//============================================================================



static void Test_aBFu0s_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu0s_Sf_BFu16ll");
    static STRUCT_IF_C aBFu0s_Sf_BFu16ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu16ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu16ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aBFu0s_Sf_BFu16ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aBFu0s_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu16ll, aBFu0s_Sf_BFu16ll)
//============================================================================



static void Test_aBFu0s_Sf_BFu16s()
{
  {
    init_simple_test("aBFu0s_Sf_BFu16s");
    static STRUCT_IF_C aBFu0s_Sf_BFu16s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu16s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu16s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aBFu0s_Sf_BFu16s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aBFu0s_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu16s, aBFu0s_Sf_BFu16s)
//============================================================================



static void Test_aBFu0s_Sf_BFu17i()
{
  {
    init_simple_test("aBFu0s_Sf_BFu17i");
    static STRUCT_IF_C aBFu0s_Sf_BFu17i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu17i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu17i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aBFu0s_Sf_BFu17i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aBFu0s_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu17i, aBFu0s_Sf_BFu17i)
//============================================================================



static void Test_aBFu0s_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu0s_Sf_BFu17ll");
    static STRUCT_IF_C aBFu0s_Sf_BFu17ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu0s_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu17ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu17ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aBFu0s_Sf_BFu17ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aBFu0s_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu17ll, aBFu0s_Sf_BFu17ll)
//============================================================================



static void Test_aBFu0s_Sf_BFu1c()
{
  {
    init_simple_test("aBFu0s_Sf_BFu1c");
    static STRUCT_IF_C aBFu0s_Sf_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu1c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu1c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0s_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu1c, aBFu0s_Sf_BFu1c)
//============================================================================



static void Test_aBFu0s_Sf_BFu1i()
{
  {
    init_simple_test("aBFu0s_Sf_BFu1i");
    static STRUCT_IF_C aBFu0s_Sf_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu1i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu1i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0s_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu1i, aBFu0s_Sf_BFu1i)
//============================================================================



static void Test_aBFu0s_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu0s_Sf_BFu1ll");
    static STRUCT_IF_C aBFu0s_Sf_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu1ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu1ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0s_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu1ll, aBFu0s_Sf_BFu1ll)
//============================================================================



static void Test_aBFu0s_Sf_BFu1s()
{
  {
    init_simple_test("aBFu0s_Sf_BFu1s");
    static STRUCT_IF_C aBFu0s_Sf_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu1s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu1s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aBFu0s_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu1s, aBFu0s_Sf_BFu1s)
//============================================================================



static void Test_aBFu0s_Sf_BFu31i()
{
  {
    init_simple_test("aBFu0s_Sf_BFu31i");
    static STRUCT_IF_C aBFu0s_Sf_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu31i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu31i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aBFu0s_Sf_BFu31i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aBFu0s_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu31i, aBFu0s_Sf_BFu31i)
//============================================================================



static void Test_aBFu0s_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu0s_Sf_BFu31ll");
    static STRUCT_IF_C aBFu0s_Sf_BFu31ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu31ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu31ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aBFu0s_Sf_BFu31ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aBFu0s_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu31ll, aBFu0s_Sf_BFu31ll)
//============================================================================



static void Test_aBFu0s_Sf_BFu32i()
{
  {
    init_simple_test("aBFu0s_Sf_BFu32i");
    static STRUCT_IF_C aBFu0s_Sf_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu32i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu32i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aBFu0s_Sf_BFu32i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aBFu0s_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu32i, aBFu0s_Sf_BFu32i)
//============================================================================



static void Test_aBFu0s_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu0s_Sf_BFu32ll");
    static STRUCT_IF_C aBFu0s_Sf_BFu32ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu32ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu32ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aBFu0s_Sf_BFu32ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aBFu0s_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu32ll, aBFu0s_Sf_BFu32ll)
//============================================================================



static void Test_aBFu0s_Sf_BFu33()
{
  {
    init_simple_test("aBFu0s_Sf_BFu33");
    static STRUCT_IF_C aBFu0s_Sf_BFu33 lv;
    check2(sizeof(lv), 5, "sizeof(aBFu0s_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu33)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu33.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "aBFu0s_Sf_BFu33");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "aBFu0s_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu33, aBFu0s_Sf_BFu33)
//============================================================================



static void Test_aBFu0s_Sf_BFu7c()
{
  {
    init_simple_test("aBFu0s_Sf_BFu7c");
    static STRUCT_IF_C aBFu0s_Sf_BFu7c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu7c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu7c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0s_Sf_BFu7c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0s_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu7c, aBFu0s_Sf_BFu7c)
//============================================================================



static void Test_aBFu0s_Sf_BFu7i()
{
  {
    init_simple_test("aBFu0s_Sf_BFu7i");
    static STRUCT_IF_C aBFu0s_Sf_BFu7i lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu7i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu7i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0s_Sf_BFu7i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0s_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu7i, aBFu0s_Sf_BFu7i)
//============================================================================



static void Test_aBFu0s_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu0s_Sf_BFu7ll");
    static STRUCT_IF_C aBFu0s_Sf_BFu7ll lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu7ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu7ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0s_Sf_BFu7ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0s_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu7ll, aBFu0s_Sf_BFu7ll)
//============================================================================



static void Test_aBFu0s_Sf_BFu7s()
{
  {
    init_simple_test("aBFu0s_Sf_BFu7s");
    static STRUCT_IF_C aBFu0s_Sf_BFu7s lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu7s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu7s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aBFu0s_Sf_BFu7s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aBFu0s_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu7s, aBFu0s_Sf_BFu7s)
//============================================================================



static void Test_aBFu0s_Sf_BFu8c()
{
  {
    init_simple_test("aBFu0s_Sf_BFu8c");
    static STRUCT_IF_C aBFu0s_Sf_BFu8c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu8c)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu8c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0s_Sf_BFu8c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0s_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu8c, aBFu0s_Sf_BFu8c)
//============================================================================



static void Test_aBFu0s_Sf_BFu8i()
{
  {
    init_simple_test("aBFu0s_Sf_BFu8i");
    static STRUCT_IF_C aBFu0s_Sf_BFu8i lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu8i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu8i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0s_Sf_BFu8i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0s_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu8i, aBFu0s_Sf_BFu8i)
//============================================================================



static void Test_aBFu0s_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu0s_Sf_BFu8ll");
    static STRUCT_IF_C aBFu0s_Sf_BFu8ll lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu8ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu8ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0s_Sf_BFu8ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0s_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu8ll, aBFu0s_Sf_BFu8ll)
//============================================================================



static void Test_aBFu0s_Sf_BFu8s()
{
  {
    init_simple_test("aBFu0s_Sf_BFu8s");
    static STRUCT_IF_C aBFu0s_Sf_BFu8s lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu8s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu8s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aBFu0s_Sf_BFu8s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aBFu0s_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu8s, aBFu0s_Sf_BFu8s)
//============================================================================



static void Test_aBFu0s_Sf_BFu9i()
{
  {
    init_simple_test("aBFu0s_Sf_BFu9i");
    static STRUCT_IF_C aBFu0s_Sf_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu9i)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu9i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aBFu0s_Sf_BFu9i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aBFu0s_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu9i, aBFu0s_Sf_BFu9i)
//============================================================================



static void Test_aBFu0s_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu0s_Sf_BFu9ll");
    static STRUCT_IF_C aBFu0s_Sf_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu9ll)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu9ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aBFu0s_Sf_BFu9ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aBFu0s_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu9ll, aBFu0s_Sf_BFu9ll)
//============================================================================



static void Test_aBFu0s_Sf_BFu9s()
{
  {
    init_simple_test("aBFu0s_Sf_BFu9s");
    static STRUCT_IF_C aBFu0s_Sf_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_BFu9s)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_BFu9s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aBFu0s_Sf_BFu9s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aBFu0s_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_BFu9s, aBFu0s_Sf_BFu9s)
//============================================================================



static void Test_aBFu0s_Sf_C()
{
  {
    init_simple_test("aBFu0s_Sf_C");
    static STRUCT_IF_C aBFu0s_Sf_C lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_C)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_C.v1");
    check_field_offset(lv, v2, 0, "aBFu0s_Sf_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_C, aBFu0s_Sf_C)
//============================================================================



static void Test_aBFu0s_Sf_D()
{
  {
    init_simple_test("aBFu0s_Sf_D");
    static STRUCT_IF_C aBFu0s_Sf_D lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_D)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_D.v1");
    check_field_offset(lv, v2, 0, "aBFu0s_Sf_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_D, aBFu0s_Sf_D)
//============================================================================



static void Test_aBFu0s_Sf_F()
{
  {
    init_simple_test("aBFu0s_Sf_F");
    static STRUCT_IF_C aBFu0s_Sf_F lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_F)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_F.v1");
    check_field_offset(lv, v2, 0, "aBFu0s_Sf_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_F, aBFu0s_Sf_F)
//============================================================================



static void Test_aBFu0s_Sf_I()
{
  {
    init_simple_test("aBFu0s_Sf_I");
    static STRUCT_IF_C aBFu0s_Sf_I lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_I)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_I.v1");
    check_field_offset(lv, v2, 0, "aBFu0s_Sf_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_I, aBFu0s_Sf_I)
//============================================================================



static void Test_aBFu0s_Sf_Ip()
{
  {
    init_simple_test("aBFu0s_Sf_Ip");
    static STRUCT_IF_C aBFu0s_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_Ip)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_Ip.v1");
    check_field_offset(lv, v2, 0, "aBFu0s_Sf_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_Ip, aBFu0s_Sf_Ip)
//============================================================================



static void Test_aBFu0s_Sf_L()
{
  {
    init_simple_test("aBFu0s_Sf_L");
    static STRUCT_IF_C aBFu0s_Sf_L lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_L)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_L.v1");
    check_field_offset(lv, v2, 0, "aBFu0s_Sf_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_L, aBFu0s_Sf_L)
//============================================================================



static void Test_aBFu0s_Sf_S()
{
  {
    init_simple_test("aBFu0s_Sf_S");
    static STRUCT_IF_C aBFu0s_Sf_S lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_S)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_S.v1");
    check_field_offset(lv, v2, 0, "aBFu0s_Sf_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_S, aBFu0s_Sf_S)
//============================================================================



static void Test_aBFu0s_Sf_Sf()
{
  {
    init_simple_test("aBFu0s_Sf_Sf");
    static STRUCT_IF_C aBFu0s_Sf_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aBFu0s_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_Sf.v1");
    check_field_offset(lv, v2, 0, "aBFu0s_Sf_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_Sf, aBFu0s_Sf_Sf)
//============================================================================



static void Test_aBFu0s_Sf_Uc()
{
  {
    init_simple_test("aBFu0s_Sf_Uc");
    static STRUCT_IF_C aBFu0s_Sf_Uc lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_Uc)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_Uc.v1");
    check_field_offset(lv, v2, 0, "aBFu0s_Sf_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_Uc, aBFu0s_Sf_Uc)
//============================================================================



static void Test_aBFu0s_Sf_Ui()
{
  {
    init_simple_test("aBFu0s_Sf_Ui");
    static STRUCT_IF_C aBFu0s_Sf_Ui lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_Ui)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_Ui.v1");
    check_field_offset(lv, v2, 0, "aBFu0s_Sf_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_Ui, aBFu0s_Sf_Ui)
//============================================================================



static void Test_aBFu0s_Sf_Ul()
{
  {
    init_simple_test("aBFu0s_Sf_Ul");
    static STRUCT_IF_C aBFu0s_Sf_Ul lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_Ul)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_Ul.v1");
    check_field_offset(lv, v2, 0, "aBFu0s_Sf_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_Ul, aBFu0s_Sf_Ul)
//============================================================================



static void Test_aBFu0s_Sf_Us()
{
  {
    init_simple_test("aBFu0s_Sf_Us");
    static STRUCT_IF_C aBFu0s_Sf_Us lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_Us)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_Us.v1");
    check_field_offset(lv, v2, 0, "aBFu0s_Sf_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_Us, aBFu0s_Sf_Us)
//============================================================================



static void Test_aBFu0s_Sf_Vp()
{
  {
    init_simple_test("aBFu0s_Sf_Vp");
    static STRUCT_IF_C aBFu0s_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Sf_Vp)");
    check_field_offset(lv, v1, 0, "aBFu0s_Sf_Vp.v1");
    check_field_offset(lv, v2, 0, "aBFu0s_Sf_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Sf_Vp, aBFu0s_Sf_Vp)
//============================================================================



static void Test_aBFu0s_Uc_Sf()
{
  {
    init_simple_test("aBFu0s_Uc_Sf");
    static STRUCT_IF_C aBFu0s_Uc_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu0s_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Uc_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_Uc_Sf.v1");
    check_field_offset(lv, v2, 1, "aBFu0s_Uc_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Uc_Sf, aBFu0s_Uc_Sf)
//============================================================================



static void Test_aBFu0s_Ui_Sf()
{
  {
    init_simple_test("aBFu0s_Ui_Sf");
    static STRUCT_IF_C aBFu0s_Ui_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu0s_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ui_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ui_Sf.v1");
    check_field_offset(lv, v2, 4, "aBFu0s_Ui_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ui_Sf, aBFu0s_Ui_Sf)
//============================================================================



static void Test_aBFu0s_Ul_Sf()
{
  {
    init_simple_test("aBFu0s_Ul_Sf");
    static STRUCT_IF_C aBFu0s_Ul_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu0s_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Ul_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_Ul_Sf.v1");
    check_field_offset(lv, v2, 8, "aBFu0s_Ul_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Ul_Sf, aBFu0s_Ul_Sf)
//============================================================================



static void Test_aBFu0s_Us_Sf()
{
  {
    init_simple_test("aBFu0s_Us_Sf");
    static STRUCT_IF_C aBFu0s_Us_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu0s_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Us_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_Us_Sf.v1");
    check_field_offset(lv, v2, 2, "aBFu0s_Us_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Us_Sf, aBFu0s_Us_Sf)
//============================================================================



static void Test_aBFu0s_Vp_Sf()
{
  {
    init_simple_test("aBFu0s_Vp_Sf");
    static STRUCT_IF_C aBFu0s_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu0s_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu0s_Vp_Sf)");
    check_field_offset(lv, v1, 0, "aBFu0s_Vp_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu0s_Vp_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu0s_Vp_Sf, aBFu0s_Vp_Sf)
//============================================================================



static void Test_aBFu15i_BFu0c_Sf()
{
  {
    init_simple_test("aBFu15i_BFu0c_Sf");
    static STRUCT_IF_C aBFu15i_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0c_Sf, aBFu15i_BFu0c_Sf)
//============================================================================



static void Test_aBFu15i_BFu0i_Sf()
{
  {
    init_simple_test("aBFu15i_BFu0i_Sf");
    static STRUCT_IF_C aBFu15i_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0i_Sf, aBFu15i_BFu0i_Sf)
//============================================================================



static void Test_aBFu15i_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu15i_BFu0ll_Sf");
    static STRUCT_IF_C aBFu15i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0ll_Sf, aBFu15i_BFu0ll_Sf)
//============================================================================



static void Test_aBFu15i_BFu0s_Sf()
{
  {
    init_simple_test("aBFu15i_BFu0s_Sf");
    static STRUCT_IF_C aBFu15i_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu0s_Sf, aBFu15i_BFu0s_Sf)
//============================================================================



static void Test_aBFu15i_Sf_BFu0c()
{
  {
    init_simple_test("aBFu15i_Sf_BFu0c");
    static STRUCT_IF_C aBFu15i_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu0c, aBFu15i_Sf_BFu0c)
//============================================================================



static void Test_aBFu15i_Sf_BFu0i()
{
  {
    init_simple_test("aBFu15i_Sf_BFu0i");
    static STRUCT_IF_C aBFu15i_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15i_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu0i, aBFu15i_Sf_BFu0i)
//============================================================================



static void Test_aBFu15i_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu15i_Sf_BFu0ll");
    static STRUCT_IF_C aBFu15i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15i_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu0ll, aBFu15i_Sf_BFu0ll)
//============================================================================



static void Test_aBFu15i_Sf_BFu0s()
{
  {
    init_simple_test("aBFu15i_Sf_BFu0s");
    static STRUCT_IF_C aBFu15i_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu0s, aBFu15i_Sf_BFu0s)
//============================================================================



static void Test_aBFu15ll_BFu0c_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu0c_Sf");
    static STRUCT_IF_C aBFu15ll_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0c_Sf, aBFu15ll_BFu0c_Sf)
//============================================================================



static void Test_aBFu15ll_BFu0i_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu0i_Sf");
    static STRUCT_IF_C aBFu15ll_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15ll_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0i_Sf, aBFu15ll_BFu0i_Sf)
//============================================================================



static void Test_aBFu15ll_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu0ll_Sf");
    static STRUCT_IF_C aBFu15ll_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15ll_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0ll_Sf, aBFu15ll_BFu0ll_Sf)
//============================================================================



static void Test_aBFu15ll_BFu0s_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu0s_Sf");
    static STRUCT_IF_C aBFu15ll_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu0s_Sf, aBFu15ll_BFu0s_Sf)
//============================================================================



static void Test_aBFu15ll_Sf_BFu0c()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu0c");
    static STRUCT_IF_C aBFu15ll_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu0c, aBFu15ll_Sf_BFu0c)
//============================================================================



static void Test_aBFu15ll_Sf_BFu0i()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu0i");
    static STRUCT_IF_C aBFu15ll_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15ll_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu0i, aBFu15ll_Sf_BFu0i)
//============================================================================



static void Test_aBFu15ll_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu0ll");
    static STRUCT_IF_C aBFu15ll_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15ll_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu0ll, aBFu15ll_Sf_BFu0ll)
//============================================================================



static void Test_aBFu15ll_Sf_BFu0s()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu0s");
    static STRUCT_IF_C aBFu15ll_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu0s, aBFu15ll_Sf_BFu0s)
//============================================================================



static void Test_aBFu15s_BFu0c_Sf()
{
  {
    init_simple_test("aBFu15s_BFu0c_Sf");
    static STRUCT_IF_C aBFu15s_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15s_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu0c_Sf, aBFu15s_BFu0c_Sf)
//============================================================================



static void Test_aBFu15s_BFu0i_Sf()
{
  {
    init_simple_test("aBFu15s_BFu0i_Sf");
    static STRUCT_IF_C aBFu15s_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15s_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu15s_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu0i_Sf, aBFu15s_BFu0i_Sf)
//============================================================================



static void Test_aBFu15s_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu15s_BFu0ll_Sf");
    static STRUCT_IF_C aBFu15s_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15s_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu15s_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu0ll_Sf, aBFu15s_BFu0ll_Sf)
//============================================================================



static void Test_aBFu15s_BFu0s_Sf()
{
  {
    init_simple_test("aBFu15s_BFu0s_Sf");
    static STRUCT_IF_C aBFu15s_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15s_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu0s_Sf, aBFu15s_BFu0s_Sf)
//============================================================================



static void Test_aBFu15s_Sf_BFu0c()
{
  {
    init_simple_test("aBFu15s_Sf_BFu0c");
    static STRUCT_IF_C aBFu15s_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15s_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu0c, aBFu15s_Sf_BFu0c)
//============================================================================



static void Test_aBFu15s_Sf_BFu0i()
{
  {
    init_simple_test("aBFu15s_Sf_BFu0i");
    static STRUCT_IF_C aBFu15s_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu15s_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu0i, aBFu15s_Sf_BFu0i)
//============================================================================



static void Test_aBFu15s_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu15s_Sf_BFu0ll");
    static STRUCT_IF_C aBFu15s_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu15s_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu0ll, aBFu15s_Sf_BFu0ll)
//============================================================================



static void Test_aBFu15s_Sf_BFu0s()
{
  {
    init_simple_test("aBFu15s_Sf_BFu0s");
    static STRUCT_IF_C aBFu15s_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15s_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu0s, aBFu15s_Sf_BFu0s)
//============================================================================



static void Test_aBFu16i_BFu0c_Sf()
{
  {
    init_simple_test("aBFu16i_BFu0c_Sf");
    static STRUCT_IF_C aBFu16i_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu0c_Sf, aBFu16i_BFu0c_Sf)
//============================================================================



static void Test_aBFu16i_BFu0i_Sf()
{
  {
    init_simple_test("aBFu16i_BFu0i_Sf");
    static STRUCT_IF_C aBFu16i_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu16i_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu16i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu0i_Sf, aBFu16i_BFu0i_Sf)
//============================================================================



static void Test_aBFu16i_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu16i_BFu0ll_Sf");
    static STRUCT_IF_C aBFu16i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu16i_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu16i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu0ll_Sf, aBFu16i_BFu0ll_Sf)
//============================================================================



static void Test_aBFu16i_BFu0s_Sf()
{
  {
    init_simple_test("aBFu16i_BFu0s_Sf");
    static STRUCT_IF_C aBFu16i_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16i_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu0s_Sf, aBFu16i_BFu0s_Sf)
//============================================================================



static void Test_aBFu16i_Sf_BFu0c()
{
  {
    init_simple_test("aBFu16i_Sf_BFu0c");
    static STRUCT_IF_C aBFu16i_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu0c, aBFu16i_Sf_BFu0c)
//============================================================================



static void Test_aBFu16i_Sf_BFu0i()
{
  {
    init_simple_test("aBFu16i_Sf_BFu0i");
    static STRUCT_IF_C aBFu16i_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu16i_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu0i, aBFu16i_Sf_BFu0i)
//============================================================================



static void Test_aBFu16i_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu16i_Sf_BFu0ll");
    static STRUCT_IF_C aBFu16i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu16i_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu0ll, aBFu16i_Sf_BFu0ll)
//============================================================================



static void Test_aBFu16i_Sf_BFu0s()
{
  {
    init_simple_test("aBFu16i_Sf_BFu0s");
    static STRUCT_IF_C aBFu16i_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16i_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu0s, aBFu16i_Sf_BFu0s)
//============================================================================



static void Test_aBFu16ll_BFu0c_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu0c_Sf");
    static STRUCT_IF_C aBFu16ll_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu0c_Sf, aBFu16ll_BFu0c_Sf)
//============================================================================



static void Test_aBFu16ll_BFu0i_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu0i_Sf");
    static STRUCT_IF_C aBFu16ll_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu16ll_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu16ll_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu0i_Sf, aBFu16ll_BFu0i_Sf)
//============================================================================



static void Test_aBFu16ll_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu0ll_Sf");
    static STRUCT_IF_C aBFu16ll_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu16ll_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu16ll_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu0ll_Sf, aBFu16ll_BFu0ll_Sf)
//============================================================================



static void Test_aBFu16ll_BFu0s_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu0s_Sf");
    static STRUCT_IF_C aBFu16ll_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16ll_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu0s_Sf, aBFu16ll_BFu0s_Sf)
//============================================================================



static void Test_aBFu16ll_Sf_BFu0c()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu0c");
    static STRUCT_IF_C aBFu16ll_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu0c, aBFu16ll_Sf_BFu0c)
//============================================================================



static void Test_aBFu16ll_Sf_BFu0i()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu0i");
    static STRUCT_IF_C aBFu16ll_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu16ll_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu0i, aBFu16ll_Sf_BFu0i)
//============================================================================



static void Test_aBFu16ll_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu0ll");
    static STRUCT_IF_C aBFu16ll_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu16ll_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu0ll, aBFu16ll_Sf_BFu0ll)
//============================================================================



static void Test_aBFu16ll_Sf_BFu0s()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu0s");
    static STRUCT_IF_C aBFu16ll_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16ll_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu0s, aBFu16ll_Sf_BFu0s)
//============================================================================



static void Test_aBFu16s_BFu0c_Sf()
{
  {
    init_simple_test("aBFu16s_BFu0c_Sf");
    static STRUCT_IF_C aBFu16s_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16s_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu0c_Sf, aBFu16s_BFu0c_Sf)
//============================================================================



static void Test_aBFu16s_BFu0i_Sf()
{
  {
    init_simple_test("aBFu16s_BFu0i_Sf");
    static STRUCT_IF_C aBFu16s_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu16s_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu16s_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu0i_Sf, aBFu16s_BFu0i_Sf)
//============================================================================



static void Test_aBFu16s_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu16s_BFu0ll_Sf");
    static STRUCT_IF_C aBFu16s_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu16s_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu16s_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu0ll_Sf, aBFu16s_BFu0ll_Sf)
//============================================================================



static void Test_aBFu16s_BFu0s_Sf()
{
  {
    init_simple_test("aBFu16s_BFu0s_Sf");
    static STRUCT_IF_C aBFu16s_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16s_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu0s_Sf, aBFu16s_BFu0s_Sf)
//============================================================================



static void Test_aBFu16s_Sf_BFu0c()
{
  {
    init_simple_test("aBFu16s_Sf_BFu0c");
    static STRUCT_IF_C aBFu16s_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16s_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu0c, aBFu16s_Sf_BFu0c)
//============================================================================



static void Test_aBFu16s_Sf_BFu0i()
{
  {
    init_simple_test("aBFu16s_Sf_BFu0i");
    static STRUCT_IF_C aBFu16s_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu16s_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu0i, aBFu16s_Sf_BFu0i)
//============================================================================



static void Test_aBFu16s_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu16s_Sf_BFu0ll");
    static STRUCT_IF_C aBFu16s_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu16s_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu0ll, aBFu16s_Sf_BFu0ll)
//============================================================================



static void Test_aBFu16s_Sf_BFu0s()
{
  {
    init_simple_test("aBFu16s_Sf_BFu0s");
    static STRUCT_IF_C aBFu16s_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16s_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu0s, aBFu16s_Sf_BFu0s)
//============================================================================



static void Test_aBFu17i_BFu0c_Sf()
{
  {
    init_simple_test("aBFu17i_BFu0c_Sf");
    static STRUCT_IF_C aBFu17i_BFu0c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu0c_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu0c_Sf, aBFu17i_BFu0c_Sf)
//============================================================================



static void Test_aBFu17i_BFu0i_Sf()
{
  {
    init_simple_test("aBFu17i_BFu0i_Sf");
    static STRUCT_IF_C aBFu17i_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu17i_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu17i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu0i_Sf, aBFu17i_BFu0i_Sf)
//============================================================================



static void Test_aBFu17i_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu17i_BFu0ll_Sf");
    static STRUCT_IF_C aBFu17i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu17i_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu17i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu0ll_Sf, aBFu17i_BFu0ll_Sf)
//============================================================================



static void Test_aBFu17i_BFu0s_Sf()
{
  {
    init_simple_test("aBFu17i_BFu0s_Sf");
    static STRUCT_IF_C aBFu17i_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu17i_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu17i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu0s_Sf, aBFu17i_BFu0s_Sf)
//============================================================================



static void Test_aBFu17i_Sf_BFu0c()
{
  {
    init_simple_test("aBFu17i_Sf_BFu0c");
    static STRUCT_IF_C aBFu17i_Sf_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu0c");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu0c, aBFu17i_Sf_BFu0c)
//============================================================================



static void Test_aBFu17i_Sf_BFu0i()
{
  {
    init_simple_test("aBFu17i_Sf_BFu0i");
    static STRUCT_IF_C aBFu17i_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu17i_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu0i");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu0i, aBFu17i_Sf_BFu0i)
//============================================================================



static void Test_aBFu17i_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu17i_Sf_BFu0ll");
    static STRUCT_IF_C aBFu17i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu17i_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu0ll");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu0ll, aBFu17i_Sf_BFu0ll)
//============================================================================



static void Test_aBFu17i_Sf_BFu0s()
{
  {
    init_simple_test("aBFu17i_Sf_BFu0s");
    static STRUCT_IF_C aBFu17i_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu17i_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu0s");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu0s, aBFu17i_Sf_BFu0s)
//============================================================================



static void Test_aBFu17ll_BFu0c_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu0c_Sf");
    static STRUCT_IF_C aBFu17ll_BFu0c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu0c_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu0c_Sf, aBFu17ll_BFu0c_Sf)
//============================================================================



static void Test_aBFu17ll_BFu0i_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu0i_Sf");
    static STRUCT_IF_C aBFu17ll_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu17ll_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu17ll_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu0i_Sf, aBFu17ll_BFu0i_Sf)
//============================================================================



static void Test_aBFu17ll_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu0ll_Sf");
    static STRUCT_IF_C aBFu17ll_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu17ll_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu17ll_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu0ll_Sf, aBFu17ll_BFu0ll_Sf)
//============================================================================



static void Test_aBFu17ll_BFu0s_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu0s_Sf");
    static STRUCT_IF_C aBFu17ll_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu17ll_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu17ll_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu0s_Sf, aBFu17ll_BFu0s_Sf)
//============================================================================



static void Test_aBFu17ll_Sf_BFu0c()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu0c");
    static STRUCT_IF_C aBFu17ll_Sf_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu0c");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu0c, aBFu17ll_Sf_BFu0c)
//============================================================================



static void Test_aBFu17ll_Sf_BFu0i()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu0i");
    static STRUCT_IF_C aBFu17ll_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu17ll_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu0i");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu0i, aBFu17ll_Sf_BFu0i)
//============================================================================



static void Test_aBFu17ll_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu0ll");
    static STRUCT_IF_C aBFu17ll_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu17ll_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu0ll");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu0ll, aBFu17ll_Sf_BFu0ll)
//============================================================================



static void Test_aBFu17ll_Sf_BFu0s()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu0s");
    static STRUCT_IF_C aBFu17ll_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu17ll_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu0s");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu0s, aBFu17ll_Sf_BFu0s)
//============================================================================



static void Test_aBFu1c_BFu0c_Sf()
{
  {
    init_simple_test("aBFu1c_BFu0c_Sf");
    static STRUCT_IF_C aBFu1c_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1c_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu0c_Sf, aBFu1c_BFu0c_Sf)
//============================================================================



static void Test_aBFu1c_BFu0i_Sf()
{
  {
    init_simple_test("aBFu1c_BFu0i_Sf");
    static STRUCT_IF_C aBFu1c_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu1c_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu1c_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu0i_Sf, aBFu1c_BFu0i_Sf)
//============================================================================



static void Test_aBFu1c_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu1c_BFu0ll_Sf");
    static STRUCT_IF_C aBFu1c_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu1c_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu1c_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu0ll_Sf, aBFu1c_BFu0ll_Sf)
//============================================================================



static void Test_aBFu1c_BFu0s_Sf()
{
  {
    init_simple_test("aBFu1c_BFu0s_Sf");
    static STRUCT_IF_C aBFu1c_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu1c_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu1c_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu0s_Sf, aBFu1c_BFu0s_Sf)
//============================================================================



static void Test_aBFu1c_Sf_BFu0c()
{
  {
    init_simple_test("aBFu1c_Sf_BFu0c");
    static STRUCT_IF_C aBFu1c_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1c_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu0c, aBFu1c_Sf_BFu0c)
//============================================================================



static void Test_aBFu1c_Sf_BFu0i()
{
  {
    init_simple_test("aBFu1c_Sf_BFu0i");
    static STRUCT_IF_C aBFu1c_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu1c_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu0i, aBFu1c_Sf_BFu0i)
//============================================================================



static void Test_aBFu1c_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu1c_Sf_BFu0ll");
    static STRUCT_IF_C aBFu1c_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu1c_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu0ll, aBFu1c_Sf_BFu0ll)
//============================================================================



static void Test_aBFu1c_Sf_BFu0s()
{
  {
    init_simple_test("aBFu1c_Sf_BFu0s");
    static STRUCT_IF_C aBFu1c_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu1c_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu0s, aBFu1c_Sf_BFu0s)
//============================================================================



static void Test_aBFu1i_BFu0c_Sf()
{
  {
    init_simple_test("aBFu1i_BFu0c_Sf");
    static STRUCT_IF_C aBFu1i_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu0c_Sf, aBFu1i_BFu0c_Sf)
//============================================================================



static void Test_aBFu1i_BFu0i_Sf()
{
  {
    init_simple_test("aBFu1i_BFu0i_Sf");
    static STRUCT_IF_C aBFu1i_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu1i_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu1i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu0i_Sf, aBFu1i_BFu0i_Sf)
//============================================================================



static void Test_aBFu1i_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu1i_BFu0ll_Sf");
    static STRUCT_IF_C aBFu1i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu1i_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu1i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu0ll_Sf, aBFu1i_BFu0ll_Sf)
//============================================================================



static void Test_aBFu1i_BFu0s_Sf()
{
  {
    init_simple_test("aBFu1i_BFu0s_Sf");
    static STRUCT_IF_C aBFu1i_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu1i_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu1i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu0s_Sf, aBFu1i_BFu0s_Sf)
//============================================================================



static void Test_aBFu1i_Sf_BFu0c()
{
  {
    init_simple_test("aBFu1i_Sf_BFu0c");
    static STRUCT_IF_C aBFu1i_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu0c, aBFu1i_Sf_BFu0c)
//============================================================================



static void Test_aBFu1i_Sf_BFu0i()
{
  {
    init_simple_test("aBFu1i_Sf_BFu0i");
    static STRUCT_IF_C aBFu1i_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu1i_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu0i, aBFu1i_Sf_BFu0i)
//============================================================================



static void Test_aBFu1i_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu1i_Sf_BFu0ll");
    static STRUCT_IF_C aBFu1i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu1i_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu0ll, aBFu1i_Sf_BFu0ll)
//============================================================================



static void Test_aBFu1i_Sf_BFu0s()
{
  {
    init_simple_test("aBFu1i_Sf_BFu0s");
    static STRUCT_IF_C aBFu1i_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu1i_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu0s, aBFu1i_Sf_BFu0s)
//============================================================================



static void Test_aBFu1ll_BFu0c_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu0c_Sf");
    static STRUCT_IF_C aBFu1ll_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu0c_Sf, aBFu1ll_BFu0c_Sf)
//============================================================================



static void Test_aBFu1ll_BFu0i_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu0i_Sf");
    static STRUCT_IF_C aBFu1ll_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu1ll_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu1ll_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu0i_Sf, aBFu1ll_BFu0i_Sf)
//============================================================================



static void Test_aBFu1ll_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu0ll_Sf");
    static STRUCT_IF_C aBFu1ll_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu1ll_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu1ll_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu0ll_Sf, aBFu1ll_BFu0ll_Sf)
//============================================================================



static void Test_aBFu1ll_BFu0s_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu0s_Sf");
    static STRUCT_IF_C aBFu1ll_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu1ll_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu1ll_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu0s_Sf, aBFu1ll_BFu0s_Sf)
//============================================================================



static void Test_aBFu1ll_Sf_BFu0c()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu0c");
    static STRUCT_IF_C aBFu1ll_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu0c, aBFu1ll_Sf_BFu0c)
//============================================================================



static void Test_aBFu1ll_Sf_BFu0i()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu0i");
    static STRUCT_IF_C aBFu1ll_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu1ll_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu0i, aBFu1ll_Sf_BFu0i)
//============================================================================



static void Test_aBFu1ll_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu0ll");
    static STRUCT_IF_C aBFu1ll_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu1ll_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu0ll, aBFu1ll_Sf_BFu0ll)
//============================================================================



static void Test_aBFu1ll_Sf_BFu0s()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu0s");
    static STRUCT_IF_C aBFu1ll_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu1ll_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu0s, aBFu1ll_Sf_BFu0s)
//============================================================================



static void Test_aBFu1s_BFu0c_Sf()
{
  {
    init_simple_test("aBFu1s_BFu0c_Sf");
    static STRUCT_IF_C aBFu1s_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1s_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu0c_Sf, aBFu1s_BFu0c_Sf)
//============================================================================



static void Test_aBFu1s_BFu0i_Sf()
{
  {
    init_simple_test("aBFu1s_BFu0i_Sf");
    static STRUCT_IF_C aBFu1s_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu1s_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu1s_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu0i_Sf, aBFu1s_BFu0i_Sf)
//============================================================================



static void Test_aBFu1s_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu1s_BFu0ll_Sf");
    static STRUCT_IF_C aBFu1s_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu1s_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu1s_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu0ll_Sf, aBFu1s_BFu0ll_Sf)
//============================================================================



static void Test_aBFu1s_BFu0s_Sf()
{
  {
    init_simple_test("aBFu1s_BFu0s_Sf");
    static STRUCT_IF_C aBFu1s_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu1s_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu1s_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu0s_Sf, aBFu1s_BFu0s_Sf)
//============================================================================



static void Test_aBFu1s_Sf_BFu0c()
{
  {
    init_simple_test("aBFu1s_Sf_BFu0c");
    static STRUCT_IF_C aBFu1s_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1s_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu0c, aBFu1s_Sf_BFu0c)
//============================================================================



static void Test_aBFu1s_Sf_BFu0i()
{
  {
    init_simple_test("aBFu1s_Sf_BFu0i");
    static STRUCT_IF_C aBFu1s_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu1s_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu0i, aBFu1s_Sf_BFu0i)
//============================================================================



static void Test_aBFu1s_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu1s_Sf_BFu0ll");
    static STRUCT_IF_C aBFu1s_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu1s_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu0ll, aBFu1s_Sf_BFu0ll)
//============================================================================



static void Test_aBFu1s_Sf_BFu0s()
{
  {
    init_simple_test("aBFu1s_Sf_BFu0s");
    static STRUCT_IF_C aBFu1s_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu1s_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu0s, aBFu1s_Sf_BFu0s)
//============================================================================



static void Test_aBFu31i_BFu0c_Sf()
{
  {
    init_simple_test("aBFu31i_BFu0c_Sf");
    static STRUCT_IF_C aBFu31i_BFu0c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu0c_Sf");
    check_field_offset(lv, v2, 4, "aBFu31i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu0c_Sf, aBFu31i_BFu0c_Sf)
//============================================================================



static void Test_aBFu31i_BFu0i_Sf()
{
  {
    init_simple_test("aBFu31i_BFu0i_Sf");
    static STRUCT_IF_C aBFu31i_BFu0i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31i_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu0i_Sf");
    check_field_offset(lv, v2, 4, "aBFu31i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu0i_Sf, aBFu31i_BFu0i_Sf)
//============================================================================



static void Test_aBFu31i_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu31i_BFu0ll_Sf");
    static STRUCT_IF_C aBFu31i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu31i_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu31i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu0ll_Sf, aBFu31i_BFu0ll_Sf)
//============================================================================



static void Test_aBFu31i_BFu0s_Sf()
{
  {
    init_simple_test("aBFu31i_BFu0s_Sf");
    static STRUCT_IF_C aBFu31i_BFu0s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31i_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu0s_Sf");
    check_field_offset(lv, v2, 4, "aBFu31i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu0s_Sf, aBFu31i_BFu0s_Sf)
//============================================================================



static void Test_aBFu31i_Sf_BFu0c()
{
  {
    init_simple_test("aBFu31i_Sf_BFu0c");
    static STRUCT_IF_C aBFu31i_Sf_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu0c");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu0c, aBFu31i_Sf_BFu0c)
//============================================================================



static void Test_aBFu31i_Sf_BFu0i()
{
  {
    init_simple_test("aBFu31i_Sf_BFu0i");
    static STRUCT_IF_C aBFu31i_Sf_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31i_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu0i");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu0i, aBFu31i_Sf_BFu0i)
//============================================================================



static void Test_aBFu31i_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu31i_Sf_BFu0ll");
    static STRUCT_IF_C aBFu31i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu31i_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu0ll");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu0ll, aBFu31i_Sf_BFu0ll)
//============================================================================



static void Test_aBFu31i_Sf_BFu0s()
{
  {
    init_simple_test("aBFu31i_Sf_BFu0s");
    static STRUCT_IF_C aBFu31i_Sf_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31i_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu0s");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu0s, aBFu31i_Sf_BFu0s)
//============================================================================



static void Test_aBFu31ll_BFu0c_Sf()
{
  {
    init_simple_test("aBFu31ll_BFu0c_Sf");
    static STRUCT_IF_C aBFu31ll_BFu0c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_BFu0c_Sf");
    check_field_offset(lv, v2, 4, "aBFu31ll_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31ll_BFu0c_Sf, aBFu31ll_BFu0c_Sf)
//============================================================================



static void Test_aBFu31ll_BFu0i_Sf()
{
  {
    init_simple_test("aBFu31ll_BFu0i_Sf");
    static STRUCT_IF_C aBFu31ll_BFu0i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31ll_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_BFu0i_Sf");
    check_field_offset(lv, v2, 4, "aBFu31ll_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31ll_BFu0i_Sf, aBFu31ll_BFu0i_Sf)
//============================================================================



static void Test_aBFu31ll_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu31ll_BFu0ll_Sf");
    static STRUCT_IF_C aBFu31ll_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu31ll_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu31ll_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31ll_BFu0ll_Sf, aBFu31ll_BFu0ll_Sf)
//============================================================================



static void Test_aBFu31ll_BFu0s_Sf()
{
  {
    init_simple_test("aBFu31ll_BFu0s_Sf");
    static STRUCT_IF_C aBFu31ll_BFu0s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31ll_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_BFu0s_Sf");
    check_field_offset(lv, v2, 4, "aBFu31ll_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31ll_BFu0s_Sf, aBFu31ll_BFu0s_Sf)
//============================================================================



static void Test_aBFu31ll_Sf_BFu0c()
{
  {
    init_simple_test("aBFu31ll_Sf_BFu0c");
    static STRUCT_IF_C aBFu31ll_Sf_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_Sf_BFu0c");
    check_field_offset(lv, v2, 4, "aBFu31ll_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31ll_Sf_BFu0c, aBFu31ll_Sf_BFu0c)
//============================================================================



static void Test_aBFu31ll_Sf_BFu0i()
{
  {
    init_simple_test("aBFu31ll_Sf_BFu0i");
    static STRUCT_IF_C aBFu31ll_Sf_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31ll_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_Sf_BFu0i");
    check_field_offset(lv, v2, 4, "aBFu31ll_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31ll_Sf_BFu0i, aBFu31ll_Sf_BFu0i)
//============================================================================



static void Test_aBFu31ll_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu31ll_Sf_BFu0ll");
    static STRUCT_IF_C aBFu31ll_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu31ll_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_Sf_BFu0ll");
    check_field_offset(lv, v2, 4, "aBFu31ll_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31ll_Sf_BFu0ll, aBFu31ll_Sf_BFu0ll)
//============================================================================



static void Test_aBFu31ll_Sf_BFu0s()
{
  {
    init_simple_test("aBFu31ll_Sf_BFu0s");
    static STRUCT_IF_C aBFu31ll_Sf_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31ll_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31ll_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31ll_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31ll_Sf_BFu0s");
    check_field_offset(lv, v2, 4, "aBFu31ll_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31ll_Sf_BFu0s, aBFu31ll_Sf_BFu0s)
//============================================================================



static void Test_aBFu32i_BFu0c_Sf()
{
  {
    init_simple_test("aBFu32i_BFu0c_Sf");
    static STRUCT_IF_C aBFu32i_BFu0c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu32i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_BFu0c_Sf");
    check_field_offset(lv, v2, 4, "aBFu32i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32i_BFu0c_Sf, aBFu32i_BFu0c_Sf)
//============================================================================



static void Test_aBFu32i_BFu0i_Sf()
{
  {
    init_simple_test("aBFu32i_BFu0i_Sf");
    static STRUCT_IF_C aBFu32i_BFu0i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu32i_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_BFu0i_Sf");
    check_field_offset(lv, v2, 4, "aBFu32i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32i_BFu0i_Sf, aBFu32i_BFu0i_Sf)
//============================================================================



static void Test_aBFu32i_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu32i_BFu0ll_Sf");
    static STRUCT_IF_C aBFu32i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu32i_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu32i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32i_BFu0ll_Sf, aBFu32i_BFu0ll_Sf)
//============================================================================



static void Test_aBFu32i_BFu0s_Sf()
{
  {
    init_simple_test("aBFu32i_BFu0s_Sf");
    static STRUCT_IF_C aBFu32i_BFu0s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu32i_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_BFu0s_Sf");
    check_field_offset(lv, v2, 4, "aBFu32i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32i_BFu0s_Sf, aBFu32i_BFu0s_Sf)
//============================================================================



static void Test_aBFu32i_Sf_BFu0c()
{
  {
    init_simple_test("aBFu32i_Sf_BFu0c");
    static STRUCT_IF_C aBFu32i_Sf_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu32i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_Sf_BFu0c");
    check_field_offset(lv, v2, 4, "aBFu32i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32i_Sf_BFu0c, aBFu32i_Sf_BFu0c)
//============================================================================



static void Test_aBFu32i_Sf_BFu0i()
{
  {
    init_simple_test("aBFu32i_Sf_BFu0i");
    static STRUCT_IF_C aBFu32i_Sf_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu32i_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_Sf_BFu0i");
    check_field_offset(lv, v2, 4, "aBFu32i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32i_Sf_BFu0i, aBFu32i_Sf_BFu0i)
//============================================================================



static void Test_aBFu32i_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu32i_Sf_BFu0ll");
    static STRUCT_IF_C aBFu32i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu32i_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_Sf_BFu0ll");
    check_field_offset(lv, v2, 4, "aBFu32i_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32i_Sf_BFu0ll, aBFu32i_Sf_BFu0ll)
//============================================================================



static void Test_aBFu32i_Sf_BFu0s()
{
  {
    init_simple_test("aBFu32i_Sf_BFu0s");
    static STRUCT_IF_C aBFu32i_Sf_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu32i_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32i_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32i_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32i_Sf_BFu0s");
    check_field_offset(lv, v2, 4, "aBFu32i_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32i_Sf_BFu0s, aBFu32i_Sf_BFu0s)
//============================================================================



static void Test_aBFu32ll_BFu0c_Sf()
{
  {
    init_simple_test("aBFu32ll_BFu0c_Sf");
    static STRUCT_IF_C aBFu32ll_BFu0c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu32ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu0c_Sf");
    check_field_offset(lv, v2, 4, "aBFu32ll_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32ll_BFu0c_Sf, aBFu32ll_BFu0c_Sf)
//============================================================================



static void Test_aBFu32ll_BFu0i_Sf()
{
  {
    init_simple_test("aBFu32ll_BFu0i_Sf");
    static STRUCT_IF_C aBFu32ll_BFu0i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu32ll_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu0i_Sf");
    check_field_offset(lv, v2, 4, "aBFu32ll_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32ll_BFu0i_Sf, aBFu32ll_BFu0i_Sf)
//============================================================================



static void Test_aBFu32ll_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu32ll_BFu0ll_Sf");
    static STRUCT_IF_C aBFu32ll_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu32ll_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu32ll_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32ll_BFu0ll_Sf, aBFu32ll_BFu0ll_Sf)
//============================================================================



static void Test_aBFu32ll_BFu0s_Sf()
{
  {
    init_simple_test("aBFu32ll_BFu0s_Sf");
    static STRUCT_IF_C aBFu32ll_BFu0s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu32ll_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_BFu0s_Sf");
    check_field_offset(lv, v2, 4, "aBFu32ll_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32ll_BFu0s_Sf, aBFu32ll_BFu0s_Sf)
//============================================================================



static void Test_aBFu32ll_Sf_BFu0c()
{
  {
    init_simple_test("aBFu32ll_Sf_BFu0c");
    static STRUCT_IF_C aBFu32ll_Sf_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu32ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_Sf_BFu0c");
    check_field_offset(lv, v2, 4, "aBFu32ll_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32ll_Sf_BFu0c, aBFu32ll_Sf_BFu0c)
//============================================================================



static void Test_aBFu32ll_Sf_BFu0i()
{
  {
    init_simple_test("aBFu32ll_Sf_BFu0i");
    static STRUCT_IF_C aBFu32ll_Sf_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu32ll_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_Sf_BFu0i");
    check_field_offset(lv, v2, 4, "aBFu32ll_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32ll_Sf_BFu0i, aBFu32ll_Sf_BFu0i)
//============================================================================



static void Test_aBFu32ll_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu32ll_Sf_BFu0ll");
    static STRUCT_IF_C aBFu32ll_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu32ll_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_Sf_BFu0ll");
    check_field_offset(lv, v2, 4, "aBFu32ll_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32ll_Sf_BFu0ll, aBFu32ll_Sf_BFu0ll)
//============================================================================



static void Test_aBFu32ll_Sf_BFu0s()
{
  {
    init_simple_test("aBFu32ll_Sf_BFu0s");
    static STRUCT_IF_C aBFu32ll_Sf_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu32ll_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu32ll_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "aBFu32ll_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "aBFu32ll_Sf_BFu0s");
    check_field_offset(lv, v2, 4, "aBFu32ll_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu32ll_Sf_BFu0s, aBFu32ll_Sf_BFu0s)
//============================================================================



static void Test_aBFu33_BFu0c_Sf()
{
  {
    init_simple_test("aBFu33_BFu0c_Sf");
    static STRUCT_IF_C aBFu33_BFu0c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu33_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu0c_Sf");
    check_field_offset(lv, v2, 5, "aBFu33_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu33_BFu0c_Sf, aBFu33_BFu0c_Sf)
//============================================================================



static void Test_aBFu33_BFu0i_Sf()
{
  {
    init_simple_test("aBFu33_BFu0i_Sf");
    static STRUCT_IF_C aBFu33_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu33_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(8,8), "aBFu33_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu33_BFu0i_Sf, aBFu33_BFu0i_Sf)
//============================================================================



static void Test_aBFu33_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu33_BFu0ll_Sf");
    static STRUCT_IF_C aBFu33_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu33_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,8), "aBFu33_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu33_BFu0ll_Sf, aBFu33_BFu0ll_Sf)
//============================================================================



static void Test_aBFu33_BFu0s_Sf()
{
  {
    init_simple_test("aBFu33_BFu0s_Sf");
    static STRUCT_IF_C aBFu33_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu33_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(6,6), "aBFu33_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu33_BFu0s_Sf, aBFu33_BFu0s_Sf)
//============================================================================



static void Test_aBFu33_Sf_BFu0c()
{
  {
    init_simple_test("aBFu33_Sf_BFu0c");
    static STRUCT_IF_C aBFu33_Sf_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu33_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_Sf_BFu0c");
    check_field_offset(lv, v2, 5, "aBFu33_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu33_Sf_BFu0c, aBFu33_Sf_BFu0c)
//============================================================================



static void Test_aBFu33_Sf_BFu0i()
{
  {
    init_simple_test("aBFu33_Sf_BFu0i");
    static STRUCT_IF_C aBFu33_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu33_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_Sf_BFu0i");
    check_field_offset(lv, v2, 5, "aBFu33_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu33_Sf_BFu0i, aBFu33_Sf_BFu0i)
//============================================================================



static void Test_aBFu33_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu33_Sf_BFu0ll");
    static STRUCT_IF_C aBFu33_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aBFu33_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_Sf_BFu0ll");
    check_field_offset(lv, v2, 5, "aBFu33_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu33_Sf_BFu0ll, aBFu33_Sf_BFu0ll)
//============================================================================



static void Test_aBFu33_Sf_BFu0s()
{
  {
    init_simple_test("aBFu33_Sf_BFu0s");
    static STRUCT_IF_C aBFu33_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aBFu33_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu33_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "aBFu33_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "aBFu33_Sf_BFu0s");
    check_field_offset(lv, v2, 5, "aBFu33_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu33_Sf_BFu0s, aBFu33_Sf_BFu0s)
//============================================================================



static void Test_aBFu7c_BFu0c_Sf()
{
  {
    init_simple_test("aBFu7c_BFu0c_Sf");
    static STRUCT_IF_C aBFu7c_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu7c_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "aBFu7c_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7c_BFu0c_Sf, aBFu7c_BFu0c_Sf)
//============================================================================



static void Test_aBFu7c_BFu0i_Sf()
{
  {
    init_simple_test("aBFu7c_BFu0i_Sf");
    static STRUCT_IF_C aBFu7c_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu7c_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu7c_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7c_BFu0i_Sf, aBFu7c_BFu0i_Sf)
//============================================================================



static void Test_aBFu7c_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu7c_BFu0ll_Sf");
    static STRUCT_IF_C aBFu7c_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu7c_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu7c_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7c_BFu0ll_Sf, aBFu7c_BFu0ll_Sf)
//============================================================================



static void Test_aBFu7c_BFu0s_Sf()
{
  {
    init_simple_test("aBFu7c_BFu0s_Sf");
    static STRUCT_IF_C aBFu7c_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu7c_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu7c_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7c_BFu0s_Sf, aBFu7c_BFu0s_Sf)
//============================================================================



static void Test_aBFu7c_Sf_BFu0c()
{
  {
    init_simple_test("aBFu7c_Sf_BFu0c");
    static STRUCT_IF_C aBFu7c_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu7c_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu7c_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7c_Sf_BFu0c, aBFu7c_Sf_BFu0c)
//============================================================================



static void Test_aBFu7c_Sf_BFu0i()
{
  {
    init_simple_test("aBFu7c_Sf_BFu0i");
    static STRUCT_IF_C aBFu7c_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu7c_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu7c_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7c_Sf_BFu0i, aBFu7c_Sf_BFu0i)
//============================================================================



static void Test_aBFu7c_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu7c_Sf_BFu0ll");
    static STRUCT_IF_C aBFu7c_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu7c_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu7c_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7c_Sf_BFu0ll, aBFu7c_Sf_BFu0ll)
//============================================================================



static void Test_aBFu7c_Sf_BFu0s()
{
  {
    init_simple_test("aBFu7c_Sf_BFu0s");
    static STRUCT_IF_C aBFu7c_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu7c_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7c_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7c_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7c_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu7c_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7c_Sf_BFu0s, aBFu7c_Sf_BFu0s)
//============================================================================



static void Test_aBFu7i_BFu0c_Sf()
{
  {
    init_simple_test("aBFu7i_BFu0c_Sf");
    static STRUCT_IF_C aBFu7i_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu7i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "aBFu7i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7i_BFu0c_Sf, aBFu7i_BFu0c_Sf)
//============================================================================



static void Test_aBFu7i_BFu0i_Sf()
{
  {
    init_simple_test("aBFu7i_BFu0i_Sf");
    static STRUCT_IF_C aBFu7i_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu7i_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu7i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7i_BFu0i_Sf, aBFu7i_BFu0i_Sf)
//============================================================================



static void Test_aBFu7i_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu7i_BFu0ll_Sf");
    static STRUCT_IF_C aBFu7i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu7i_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu7i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7i_BFu0ll_Sf, aBFu7i_BFu0ll_Sf)
//============================================================================



static void Test_aBFu7i_BFu0s_Sf()
{
  {
    init_simple_test("aBFu7i_BFu0s_Sf");
    static STRUCT_IF_C aBFu7i_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu7i_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu7i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7i_BFu0s_Sf, aBFu7i_BFu0s_Sf)
//============================================================================



static void Test_aBFu7i_Sf_BFu0c()
{
  {
    init_simple_test("aBFu7i_Sf_BFu0c");
    static STRUCT_IF_C aBFu7i_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu7i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu7i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7i_Sf_BFu0c, aBFu7i_Sf_BFu0c)
//============================================================================



static void Test_aBFu7i_Sf_BFu0i()
{
  {
    init_simple_test("aBFu7i_Sf_BFu0i");
    static STRUCT_IF_C aBFu7i_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu7i_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu7i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7i_Sf_BFu0i, aBFu7i_Sf_BFu0i)
//============================================================================



static void Test_aBFu7i_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu7i_Sf_BFu0ll");
    static STRUCT_IF_C aBFu7i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu7i_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu7i_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7i_Sf_BFu0ll, aBFu7i_Sf_BFu0ll)
//============================================================================



static void Test_aBFu7i_Sf_BFu0s()
{
  {
    init_simple_test("aBFu7i_Sf_BFu0s");
    static STRUCT_IF_C aBFu7i_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu7i_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7i_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7i_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7i_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu7i_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7i_Sf_BFu0s, aBFu7i_Sf_BFu0s)
//============================================================================



static void Test_aBFu7ll_BFu0c_Sf()
{
  {
    init_simple_test("aBFu7ll_BFu0c_Sf");
    static STRUCT_IF_C aBFu7ll_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu7ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "aBFu7ll_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7ll_BFu0c_Sf, aBFu7ll_BFu0c_Sf)
//============================================================================



static void Test_aBFu7ll_BFu0i_Sf()
{
  {
    init_simple_test("aBFu7ll_BFu0i_Sf");
    static STRUCT_IF_C aBFu7ll_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu7ll_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu7ll_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7ll_BFu0i_Sf, aBFu7ll_BFu0i_Sf)
//============================================================================



static void Test_aBFu7ll_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu7ll_BFu0ll_Sf");
    static STRUCT_IF_C aBFu7ll_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu7ll_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu7ll_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7ll_BFu0ll_Sf, aBFu7ll_BFu0ll_Sf)
//============================================================================



static void Test_aBFu7ll_BFu0s_Sf()
{
  {
    init_simple_test("aBFu7ll_BFu0s_Sf");
    static STRUCT_IF_C aBFu7ll_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu7ll_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu7ll_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7ll_BFu0s_Sf, aBFu7ll_BFu0s_Sf)
//============================================================================



static void Test_aBFu7ll_Sf_BFu0c()
{
  {
    init_simple_test("aBFu7ll_Sf_BFu0c");
    static STRUCT_IF_C aBFu7ll_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu7ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu7ll_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7ll_Sf_BFu0c, aBFu7ll_Sf_BFu0c)
//============================================================================



static void Test_aBFu7ll_Sf_BFu0i()
{
  {
    init_simple_test("aBFu7ll_Sf_BFu0i");
    static STRUCT_IF_C aBFu7ll_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu7ll_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu7ll_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7ll_Sf_BFu0i, aBFu7ll_Sf_BFu0i)
//============================================================================



static void Test_aBFu7ll_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu7ll_Sf_BFu0ll");
    static STRUCT_IF_C aBFu7ll_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu7ll_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu7ll_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7ll_Sf_BFu0ll, aBFu7ll_Sf_BFu0ll)
//============================================================================



static void Test_aBFu7ll_Sf_BFu0s()
{
  {
    init_simple_test("aBFu7ll_Sf_BFu0s");
    static STRUCT_IF_C aBFu7ll_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu7ll_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7ll_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7ll_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7ll_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu7ll_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7ll_Sf_BFu0s, aBFu7ll_Sf_BFu0s)
//============================================================================



static void Test_aBFu7s_BFu0c_Sf()
{
  {
    init_simple_test("aBFu7s_BFu0c_Sf");
    static STRUCT_IF_C aBFu7s_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu7s_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "aBFu7s_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7s_BFu0c_Sf, aBFu7s_BFu0c_Sf)
//============================================================================



static void Test_aBFu7s_BFu0i_Sf()
{
  {
    init_simple_test("aBFu7s_BFu0i_Sf");
    static STRUCT_IF_C aBFu7s_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu7s_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu7s_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7s_BFu0i_Sf, aBFu7s_BFu0i_Sf)
//============================================================================



static void Test_aBFu7s_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu7s_BFu0ll_Sf");
    static STRUCT_IF_C aBFu7s_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu7s_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu7s_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7s_BFu0ll_Sf, aBFu7s_BFu0ll_Sf)
//============================================================================



static void Test_aBFu7s_BFu0s_Sf()
{
  {
    init_simple_test("aBFu7s_BFu0s_Sf");
    static STRUCT_IF_C aBFu7s_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu7s_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu7s_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7s_BFu0s_Sf, aBFu7s_BFu0s_Sf)
//============================================================================



static void Test_aBFu7s_Sf_BFu0c()
{
  {
    init_simple_test("aBFu7s_Sf_BFu0c");
    static STRUCT_IF_C aBFu7s_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu7s_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu7s_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7s_Sf_BFu0c, aBFu7s_Sf_BFu0c)
//============================================================================



static void Test_aBFu7s_Sf_BFu0i()
{
  {
    init_simple_test("aBFu7s_Sf_BFu0i");
    static STRUCT_IF_C aBFu7s_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu7s_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu7s_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7s_Sf_BFu0i, aBFu7s_Sf_BFu0i)
//============================================================================



static void Test_aBFu7s_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu7s_Sf_BFu0ll");
    static STRUCT_IF_C aBFu7s_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu7s_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu7s_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7s_Sf_BFu0ll, aBFu7s_Sf_BFu0ll)
//============================================================================



static void Test_aBFu7s_Sf_BFu0s()
{
  {
    init_simple_test("aBFu7s_Sf_BFu0s");
    static STRUCT_IF_C aBFu7s_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu7s_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu7s_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "aBFu7s_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "aBFu7s_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu7s_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu7s_Sf_BFu0s, aBFu7s_Sf_BFu0s)
//============================================================================



static void Test_aBFu8c_BFu0c_Sf()
{
  {
    init_simple_test("aBFu8c_BFu0c_Sf");
    static STRUCT_IF_C aBFu8c_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu8c_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "aBFu8c_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8c_BFu0c_Sf, aBFu8c_BFu0c_Sf)
//============================================================================



static void Test_aBFu8c_BFu0i_Sf()
{
  {
    init_simple_test("aBFu8c_BFu0i_Sf");
    static STRUCT_IF_C aBFu8c_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu8c_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu8c_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8c_BFu0i_Sf, aBFu8c_BFu0i_Sf)
//============================================================================



static void Test_aBFu8c_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu8c_BFu0ll_Sf");
    static STRUCT_IF_C aBFu8c_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu8c_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu8c_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8c_BFu0ll_Sf, aBFu8c_BFu0ll_Sf)
//============================================================================



static void Test_aBFu8c_BFu0s_Sf()
{
  {
    init_simple_test("aBFu8c_BFu0s_Sf");
    static STRUCT_IF_C aBFu8c_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu8c_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu8c_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8c_BFu0s_Sf, aBFu8c_BFu0s_Sf)
//============================================================================



static void Test_aBFu8c_Sf_BFu0c()
{
  {
    init_simple_test("aBFu8c_Sf_BFu0c");
    static STRUCT_IF_C aBFu8c_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu8c_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu8c_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8c_Sf_BFu0c, aBFu8c_Sf_BFu0c)
//============================================================================



static void Test_aBFu8c_Sf_BFu0i()
{
  {
    init_simple_test("aBFu8c_Sf_BFu0i");
    static STRUCT_IF_C aBFu8c_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu8c_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu8c_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8c_Sf_BFu0i, aBFu8c_Sf_BFu0i)
//============================================================================



static void Test_aBFu8c_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu8c_Sf_BFu0ll");
    static STRUCT_IF_C aBFu8c_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu8c_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu8c_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8c_Sf_BFu0ll, aBFu8c_Sf_BFu0ll)
//============================================================================



static void Test_aBFu8c_Sf_BFu0s()
{
  {
    init_simple_test("aBFu8c_Sf_BFu0s");
    static STRUCT_IF_C aBFu8c_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu8c_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8c_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8c_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8c_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu8c_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8c_Sf_BFu0s, aBFu8c_Sf_BFu0s)
//============================================================================



static void Test_aBFu8i_BFu0c_Sf()
{
  {
    init_simple_test("aBFu8i_BFu0c_Sf");
    static STRUCT_IF_C aBFu8i_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu8i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "aBFu8i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8i_BFu0c_Sf, aBFu8i_BFu0c_Sf)
//============================================================================



static void Test_aBFu8i_BFu0i_Sf()
{
  {
    init_simple_test("aBFu8i_BFu0i_Sf");
    static STRUCT_IF_C aBFu8i_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu8i_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu8i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8i_BFu0i_Sf, aBFu8i_BFu0i_Sf)
//============================================================================



static void Test_aBFu8i_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu8i_BFu0ll_Sf");
    static STRUCT_IF_C aBFu8i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu8i_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu8i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8i_BFu0ll_Sf, aBFu8i_BFu0ll_Sf)
//============================================================================



static void Test_aBFu8i_BFu0s_Sf()
{
  {
    init_simple_test("aBFu8i_BFu0s_Sf");
    static STRUCT_IF_C aBFu8i_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu8i_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu8i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8i_BFu0s_Sf, aBFu8i_BFu0s_Sf)
//============================================================================



static void Test_aBFu8i_Sf_BFu0c()
{
  {
    init_simple_test("aBFu8i_Sf_BFu0c");
    static STRUCT_IF_C aBFu8i_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu8i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu8i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8i_Sf_BFu0c, aBFu8i_Sf_BFu0c)
//============================================================================



static void Test_aBFu8i_Sf_BFu0i()
{
  {
    init_simple_test("aBFu8i_Sf_BFu0i");
    static STRUCT_IF_C aBFu8i_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu8i_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu8i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8i_Sf_BFu0i, aBFu8i_Sf_BFu0i)
//============================================================================



static void Test_aBFu8i_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu8i_Sf_BFu0ll");
    static STRUCT_IF_C aBFu8i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu8i_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu8i_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8i_Sf_BFu0ll, aBFu8i_Sf_BFu0ll)
//============================================================================



static void Test_aBFu8i_Sf_BFu0s()
{
  {
    init_simple_test("aBFu8i_Sf_BFu0s");
    static STRUCT_IF_C aBFu8i_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu8i_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8i_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8i_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8i_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu8i_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8i_Sf_BFu0s, aBFu8i_Sf_BFu0s)
//============================================================================



static void Test_aBFu8ll_BFu0c_Sf()
{
  {
    init_simple_test("aBFu8ll_BFu0c_Sf");
    static STRUCT_IF_C aBFu8ll_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu8ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "aBFu8ll_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_BFu0c_Sf, aBFu8ll_BFu0c_Sf)
//============================================================================



static void Test_aBFu8ll_BFu0i_Sf()
{
  {
    init_simple_test("aBFu8ll_BFu0i_Sf");
    static STRUCT_IF_C aBFu8ll_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu8ll_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu8ll_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_BFu0i_Sf, aBFu8ll_BFu0i_Sf)
//============================================================================



static void Test_aBFu8ll_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu8ll_BFu0ll_Sf");
    static STRUCT_IF_C aBFu8ll_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu8ll_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu8ll_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_BFu0ll_Sf, aBFu8ll_BFu0ll_Sf)
//============================================================================



static void Test_aBFu8ll_BFu0s_Sf()
{
  {
    init_simple_test("aBFu8ll_BFu0s_Sf");
    static STRUCT_IF_C aBFu8ll_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu8ll_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu8ll_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_BFu0s_Sf, aBFu8ll_BFu0s_Sf)
//============================================================================



static void Test_aBFu8ll_Sf_BFu0c()
{
  {
    init_simple_test("aBFu8ll_Sf_BFu0c");
    static STRUCT_IF_C aBFu8ll_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu8ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Sf_BFu0c, aBFu8ll_Sf_BFu0c)
//============================================================================



static void Test_aBFu8ll_Sf_BFu0i()
{
  {
    init_simple_test("aBFu8ll_Sf_BFu0i");
    static STRUCT_IF_C aBFu8ll_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu8ll_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Sf_BFu0i, aBFu8ll_Sf_BFu0i)
//============================================================================



static void Test_aBFu8ll_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu8ll_Sf_BFu0ll");
    static STRUCT_IF_C aBFu8ll_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu8ll_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Sf_BFu0ll, aBFu8ll_Sf_BFu0ll)
//============================================================================



static void Test_aBFu8ll_Sf_BFu0s()
{
  {
    init_simple_test("aBFu8ll_Sf_BFu0s");
    static STRUCT_IF_C aBFu8ll_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu8ll_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Sf_BFu0s, aBFu8ll_Sf_BFu0s)
//============================================================================



static void Test_aBFu8s_BFu0c_Sf()
{
  {
    init_simple_test("aBFu8s_BFu0c_Sf");
    static STRUCT_IF_C aBFu8s_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu8s_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "aBFu8s_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu0c_Sf, aBFu8s_BFu0c_Sf)
//============================================================================



static void Test_aBFu8s_BFu0i_Sf()
{
  {
    init_simple_test("aBFu8s_BFu0i_Sf");
    static STRUCT_IF_C aBFu8s_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu8s_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu8s_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu0i_Sf, aBFu8s_BFu0i_Sf)
//============================================================================



static void Test_aBFu8s_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu8s_BFu0ll_Sf");
    static STRUCT_IF_C aBFu8s_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu8s_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu8s_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu0ll_Sf, aBFu8s_BFu0ll_Sf)
//============================================================================



static void Test_aBFu8s_BFu0s_Sf()
{
  {
    init_simple_test("aBFu8s_BFu0s_Sf");
    static STRUCT_IF_C aBFu8s_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu8s_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "aBFu8s_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu0s_Sf, aBFu8s_BFu0s_Sf)
//============================================================================



static void Test_aBFu8s_Sf_BFu0c()
{
  {
    init_simple_test("aBFu8s_Sf_BFu0c");
    static STRUCT_IF_C aBFu8s_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aBFu8s_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "aBFu8s_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_Sf_BFu0c, aBFu8s_Sf_BFu0c)
//============================================================================



static void Test_aBFu8s_Sf_BFu0i()
{
  {
    init_simple_test("aBFu8s_Sf_BFu0i");
    static STRUCT_IF_C aBFu8s_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu8s_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "aBFu8s_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_Sf_BFu0i, aBFu8s_Sf_BFu0i)
//============================================================================



static void Test_aBFu8s_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu8s_Sf_BFu0ll");
    static STRUCT_IF_C aBFu8s_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu8s_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "aBFu8s_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_Sf_BFu0ll, aBFu8s_Sf_BFu0ll)
//============================================================================



static void Test_aBFu8s_Sf_BFu0s()
{
  {
    init_simple_test("aBFu8s_Sf_BFu0s");
    static STRUCT_IF_C aBFu8s_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aBFu8s_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "aBFu8s_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_Sf_BFu0s, aBFu8s_Sf_BFu0s)
//============================================================================



static void Test_aBFu9i_BFu0c_Sf()
{
  {
    init_simple_test("aBFu9i_BFu0c_Sf");
    static STRUCT_IF_C aBFu9i_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu9i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "aBFu9i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9i_BFu0c_Sf, aBFu9i_BFu0c_Sf)
//============================================================================



static void Test_aBFu9i_BFu0i_Sf()
{
  {
    init_simple_test("aBFu9i_BFu0i_Sf");
    static STRUCT_IF_C aBFu9i_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu9i_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu9i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9i_BFu0i_Sf, aBFu9i_BFu0i_Sf)
//============================================================================



static void Test_aBFu9i_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu9i_BFu0ll_Sf");
    static STRUCT_IF_C aBFu9i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu9i_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu9i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9i_BFu0ll_Sf, aBFu9i_BFu0ll_Sf)
//============================================================================



static void Test_aBFu9i_BFu0s_Sf()
{
  {
    init_simple_test("aBFu9i_BFu0s_Sf");
    static STRUCT_IF_C aBFu9i_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu9i_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "aBFu9i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9i_BFu0s_Sf, aBFu9i_BFu0s_Sf)
//============================================================================



static void Test_aBFu9i_Sf_BFu0c()
{
  {
    init_simple_test("aBFu9i_Sf_BFu0c");
    static STRUCT_IF_C aBFu9i_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu9i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu9i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9i_Sf_BFu0c, aBFu9i_Sf_BFu0c)
//============================================================================



static void Test_aBFu9i_Sf_BFu0i()
{
  {
    init_simple_test("aBFu9i_Sf_BFu0i");
    static STRUCT_IF_C aBFu9i_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu9i_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu9i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9i_Sf_BFu0i, aBFu9i_Sf_BFu0i)
//============================================================================



static void Test_aBFu9i_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu9i_Sf_BFu0ll");
    static STRUCT_IF_C aBFu9i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu9i_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu9i_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9i_Sf_BFu0ll, aBFu9i_Sf_BFu0ll)
//============================================================================



static void Test_aBFu9i_Sf_BFu0s()
{
  {
    init_simple_test("aBFu9i_Sf_BFu0s");
    static STRUCT_IF_C aBFu9i_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu9i_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9i_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9i_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9i_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu9i_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9i_Sf_BFu0s, aBFu9i_Sf_BFu0s)
//============================================================================



static void Test_aBFu9ll_BFu0c_Sf()
{
  {
    init_simple_test("aBFu9ll_BFu0c_Sf");
    static STRUCT_IF_C aBFu9ll_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu9ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "aBFu9ll_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9ll_BFu0c_Sf, aBFu9ll_BFu0c_Sf)
//============================================================================



static void Test_aBFu9ll_BFu0i_Sf()
{
  {
    init_simple_test("aBFu9ll_BFu0i_Sf");
    static STRUCT_IF_C aBFu9ll_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu9ll_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu9ll_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9ll_BFu0i_Sf, aBFu9ll_BFu0i_Sf)
//============================================================================



static void Test_aBFu9ll_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu9ll_BFu0ll_Sf");
    static STRUCT_IF_C aBFu9ll_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu9ll_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu9ll_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9ll_BFu0ll_Sf, aBFu9ll_BFu0ll_Sf)
//============================================================================



static void Test_aBFu9ll_BFu0s_Sf()
{
  {
    init_simple_test("aBFu9ll_BFu0s_Sf");
    static STRUCT_IF_C aBFu9ll_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu9ll_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "aBFu9ll_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9ll_BFu0s_Sf, aBFu9ll_BFu0s_Sf)
//============================================================================



static void Test_aBFu9ll_Sf_BFu0c()
{
  {
    init_simple_test("aBFu9ll_Sf_BFu0c");
    static STRUCT_IF_C aBFu9ll_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu9ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu9ll_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9ll_Sf_BFu0c, aBFu9ll_Sf_BFu0c)
//============================================================================



static void Test_aBFu9ll_Sf_BFu0i()
{
  {
    init_simple_test("aBFu9ll_Sf_BFu0i");
    static STRUCT_IF_C aBFu9ll_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu9ll_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu9ll_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9ll_Sf_BFu0i, aBFu9ll_Sf_BFu0i)
//============================================================================



static void Test_aBFu9ll_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu9ll_Sf_BFu0ll");
    static STRUCT_IF_C aBFu9ll_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu9ll_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu9ll_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9ll_Sf_BFu0ll, aBFu9ll_Sf_BFu0ll)
//============================================================================



static void Test_aBFu9ll_Sf_BFu0s()
{
  {
    init_simple_test("aBFu9ll_Sf_BFu0s");
    static STRUCT_IF_C aBFu9ll_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu9ll_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9ll_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9ll_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9ll_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu9ll_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9ll_Sf_BFu0s, aBFu9ll_Sf_BFu0s)
//============================================================================



static void Test_aBFu9s_BFu0c_Sf()
{
  {
    init_simple_test("aBFu9s_BFu0c_Sf");
    static STRUCT_IF_C aBFu9s_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu9s_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "aBFu9s_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9s_BFu0c_Sf, aBFu9s_BFu0c_Sf)
//============================================================================



static void Test_aBFu9s_BFu0i_Sf()
{
  {
    init_simple_test("aBFu9s_BFu0i_Sf");
    static STRUCT_IF_C aBFu9s_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu9s_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "aBFu9s_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9s_BFu0i_Sf, aBFu9s_BFu0i_Sf)
//============================================================================



static void Test_aBFu9s_BFu0ll_Sf()
{
  {
    init_simple_test("aBFu9s_BFu0ll_Sf");
    static STRUCT_IF_C aBFu9s_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu9s_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "aBFu9s_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9s_BFu0ll_Sf, aBFu9s_BFu0ll_Sf)
//============================================================================



static void Test_aBFu9s_BFu0s_Sf()
{
  {
    init_simple_test("aBFu9s_BFu0s_Sf");
    static STRUCT_IF_C aBFu9s_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu9s_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "aBFu9s_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9s_BFu0s_Sf, aBFu9s_BFu0s_Sf)
//============================================================================



static void Test_aBFu9s_Sf_BFu0c()
{
  {
    init_simple_test("aBFu9s_Sf_BFu0c");
    static STRUCT_IF_C aBFu9s_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu9s_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "aBFu9s_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9s_Sf_BFu0c, aBFu9s_Sf_BFu0c)
//============================================================================



static void Test_aBFu9s_Sf_BFu0i()
{
  {
    init_simple_test("aBFu9s_Sf_BFu0i");
    static STRUCT_IF_C aBFu9s_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aBFu9s_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "aBFu9s_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9s_Sf_BFu0i, aBFu9s_Sf_BFu0i)
//============================================================================



static void Test_aBFu9s_Sf_BFu0ll()
{
  {
    init_simple_test("aBFu9s_Sf_BFu0ll");
    static STRUCT_IF_C aBFu9s_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aBFu9s_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "aBFu9s_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9s_Sf_BFu0ll, aBFu9s_Sf_BFu0ll)
//============================================================================



static void Test_aBFu9s_Sf_BFu0s()
{
  {
    init_simple_test("aBFu9s_Sf_BFu0s");
    static STRUCT_IF_C aBFu9s_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu9s_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu9s_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "aBFu9s_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "aBFu9s_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "aBFu9s_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu9s_Sf_BFu0s, aBFu9s_Sf_BFu0s)
//============================================================================



static void Test_aC_BFu0c_Sf()
{
  {
    init_simple_test("aC_BFu0c_Sf");
    static STRUCT_IF_C aC_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aC_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aC_BFu0c_Sf.v1");
    check_field_offset(lv, v2, 1, "aC_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu0c_Sf, aC_BFu0c_Sf)
//============================================================================



static void Test_aC_BFu0i_Sf()
{
  {
    init_simple_test("aC_BFu0i_Sf");
    static STRUCT_IF_C aC_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aC_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aC_BFu0i_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aC_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu0i_Sf, aC_BFu0i_Sf)
//============================================================================



static void Test_aC_BFu0ll_Sf()
{
  {
    init_simple_test("aC_BFu0ll_Sf");
    static STRUCT_IF_C aC_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aC_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aC_BFu0ll_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aC_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu0ll_Sf, aC_BFu0ll_Sf)
//============================================================================



static void Test_aC_BFu0s_Sf()
{
  {
    init_simple_test("aC_BFu0s_Sf");
    static STRUCT_IF_C aC_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aC_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aC_BFu0s_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aC_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu0s_Sf, aC_BFu0s_Sf)
//============================================================================



static void Test_aC_Sf_BFu0c()
{
  {
    init_simple_test("aC_Sf_BFu0c");
    static STRUCT_IF_C aC_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aC_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aC_Sf_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aC_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Sf_BFu0c, aC_Sf_BFu0c)
//============================================================================



static void Test_aC_Sf_BFu0i()
{
  {
    init_simple_test("aC_Sf_BFu0i");
    static STRUCT_IF_C aC_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aC_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aC_Sf_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aC_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Sf_BFu0i, aC_Sf_BFu0i)
//============================================================================



static void Test_aC_Sf_BFu0ll()
{
  {
    init_simple_test("aC_Sf_BFu0ll");
    static STRUCT_IF_C aC_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aC_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aC_Sf_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aC_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Sf_BFu0ll, aC_Sf_BFu0ll)
//============================================================================



static void Test_aC_Sf_BFu0s()
{
  {
    init_simple_test("aC_Sf_BFu0s");
    static STRUCT_IF_C aC_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aC_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aC_Sf_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aC_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Sf_BFu0s, aC_Sf_BFu0s)
//============================================================================



static void Test_aD_BFu0c_Sf()
{
  {
    init_simple_test("aD_BFu0c_Sf");
    static STRUCT_IF_C aD_BFu0c_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aD_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aD_BFu0c_Sf.v1");
    check_field_offset(lv, v2, 8, "aD_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu0c_Sf, aD_BFu0c_Sf)
//============================================================================



static void Test_aD_BFu0i_Sf()
{
  {
    init_simple_test("aD_BFu0i_Sf");
    static STRUCT_IF_C aD_BFu0i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aD_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aD_BFu0i_Sf.v1");
    check_field_offset(lv, v2, 8, "aD_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu0i_Sf, aD_BFu0i_Sf)
//============================================================================



static void Test_aD_BFu0ll_Sf()
{
  {
    init_simple_test("aD_BFu0ll_Sf");
    static STRUCT_IF_C aD_BFu0ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aD_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aD_BFu0ll_Sf.v1");
    check_field_offset(lv, v2, 8, "aD_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu0ll_Sf, aD_BFu0ll_Sf)
//============================================================================



static void Test_aD_BFu0s_Sf()
{
  {
    init_simple_test("aD_BFu0s_Sf");
    static STRUCT_IF_C aD_BFu0s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aD_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aD_BFu0s_Sf.v1");
    check_field_offset(lv, v2, 8, "aD_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu0s_Sf, aD_BFu0s_Sf)
//============================================================================



static void Test_aD_Sf_BFu0c()
{
  {
    init_simple_test("aD_Sf_BFu0c");
    static STRUCT_IF_C aD_Sf_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aD_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aD_Sf_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aD_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_Sf_BFu0c, aD_Sf_BFu0c)
//============================================================================



static void Test_aD_Sf_BFu0i()
{
  {
    init_simple_test("aD_Sf_BFu0i");
    static STRUCT_IF_C aD_Sf_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aD_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aD_Sf_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aD_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_Sf_BFu0i, aD_Sf_BFu0i)
//============================================================================



static void Test_aD_Sf_BFu0ll()
{
  {
    init_simple_test("aD_Sf_BFu0ll");
    static STRUCT_IF_C aD_Sf_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aD_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aD_Sf_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aD_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_Sf_BFu0ll, aD_Sf_BFu0ll)
//============================================================================



static void Test_aD_Sf_BFu0s()
{
  {
    init_simple_test("aD_Sf_BFu0s");
    static STRUCT_IF_C aD_Sf_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aD_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aD_Sf_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aD_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_Sf_BFu0s, aD_Sf_BFu0s)
//============================================================================



static void Test_aF_BFu0c_Sf()
{
  {
    init_simple_test("aF_BFu0c_Sf");
    static STRUCT_IF_C aF_BFu0c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aF_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aF_BFu0c_Sf.v1");
    check_field_offset(lv, v2, 4, "aF_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu0c_Sf, aF_BFu0c_Sf)
//============================================================================



static void Test_aF_BFu0i_Sf()
{
  {
    init_simple_test("aF_BFu0i_Sf");
    static STRUCT_IF_C aF_BFu0i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aF_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aF_BFu0i_Sf.v1");
    check_field_offset(lv, v2, 4, "aF_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu0i_Sf, aF_BFu0i_Sf)
//============================================================================



static void Test_aF_BFu0ll_Sf()
{
  {
    init_simple_test("aF_BFu0ll_Sf");
    static STRUCT_IF_C aF_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aF_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aF_BFu0ll_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aF_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu0ll_Sf, aF_BFu0ll_Sf)
//============================================================================



static void Test_aF_BFu0s_Sf()
{
  {
    init_simple_test("aF_BFu0s_Sf");
    static STRUCT_IF_C aF_BFu0s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aF_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aF_BFu0s_Sf.v1");
    check_field_offset(lv, v2, 4, "aF_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu0s_Sf, aF_BFu0s_Sf)
//============================================================================



static void Test_aF_Sf_BFu0c()
{
  {
    init_simple_test("aF_Sf_BFu0c");
    static STRUCT_IF_C aF_Sf_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aF_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aF_Sf_BFu0c.v1");
    check_field_offset(lv, v2, 4, "aF_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Sf_BFu0c, aF_Sf_BFu0c)
//============================================================================



static void Test_aF_Sf_BFu0i()
{
  {
    init_simple_test("aF_Sf_BFu0i");
    static STRUCT_IF_C aF_Sf_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aF_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aF_Sf_BFu0i.v1");
    check_field_offset(lv, v2, 4, "aF_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Sf_BFu0i, aF_Sf_BFu0i)
//============================================================================



static void Test_aF_Sf_BFu0ll()
{
  {
    init_simple_test("aF_Sf_BFu0ll");
    static STRUCT_IF_C aF_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aF_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aF_Sf_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "aF_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Sf_BFu0ll, aF_Sf_BFu0ll)
//============================================================================



static void Test_aF_Sf_BFu0s()
{
  {
    init_simple_test("aF_Sf_BFu0s");
    static STRUCT_IF_C aF_Sf_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aF_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aF_Sf_BFu0s.v1");
    check_field_offset(lv, v2, 4, "aF_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Sf_BFu0s, aF_Sf_BFu0s)
//============================================================================



static void Test_aI_BFu0c_Sf()
{
  {
    init_simple_test("aI_BFu0c_Sf");
    static STRUCT_IF_C aI_BFu0c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aI_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aI_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aI_BFu0c_Sf.v1");
    check_field_offset(lv, v2, 4, "aI_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aI_BFu0c_Sf, aI_BFu0c_Sf)
//============================================================================



static void Test_aI_BFu0i_Sf()
{
  {
    init_simple_test("aI_BFu0i_Sf");
    static STRUCT_IF_C aI_BFu0i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aI_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aI_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aI_BFu0i_Sf.v1");
    check_field_offset(lv, v2, 4, "aI_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aI_BFu0i_Sf, aI_BFu0i_Sf)
//============================================================================



static void Test_aI_BFu0ll_Sf()
{
  {
    init_simple_test("aI_BFu0ll_Sf");
    static STRUCT_IF_C aI_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aI_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aI_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aI_BFu0ll_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aI_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aI_BFu0ll_Sf, aI_BFu0ll_Sf)
//============================================================================



static void Test_aI_BFu0s_Sf()
{
  {
    init_simple_test("aI_BFu0s_Sf");
    static STRUCT_IF_C aI_BFu0s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aI_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aI_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aI_BFu0s_Sf.v1");
    check_field_offset(lv, v2, 4, "aI_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aI_BFu0s_Sf, aI_BFu0s_Sf)
//============================================================================



static void Test_aI_Sf_BFu0c()
{
  {
    init_simple_test("aI_Sf_BFu0c");
    static STRUCT_IF_C aI_Sf_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aI_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aI_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aI_Sf_BFu0c.v1");
    check_field_offset(lv, v2, 4, "aI_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aI_Sf_BFu0c, aI_Sf_BFu0c)
//============================================================================



static void Test_aI_Sf_BFu0i()
{
  {
    init_simple_test("aI_Sf_BFu0i");
    static STRUCT_IF_C aI_Sf_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aI_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aI_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aI_Sf_BFu0i.v1");
    check_field_offset(lv, v2, 4, "aI_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aI_Sf_BFu0i, aI_Sf_BFu0i)
//============================================================================



static void Test_aI_Sf_BFu0ll()
{
  {
    init_simple_test("aI_Sf_BFu0ll");
    static STRUCT_IF_C aI_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aI_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aI_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aI_Sf_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "aI_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aI_Sf_BFu0ll, aI_Sf_BFu0ll)
//============================================================================



static void Test_aI_Sf_BFu0s()
{
  {
    init_simple_test("aI_Sf_BFu0s");
    static STRUCT_IF_C aI_Sf_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aI_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aI_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aI_Sf_BFu0s.v1");
    check_field_offset(lv, v2, 4, "aI_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aI_Sf_BFu0s, aI_Sf_BFu0s)
//============================================================================



static void Test_aIp_BFu0c_Sf()
{
  {
    init_simple_test("aIp_BFu0c_Sf");
    static STRUCT_IF_C aIp_BFu0c_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aIp_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aIp_BFu0c_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu0c_Sf, aIp_BFu0c_Sf)
//============================================================================



static void Test_aIp_BFu0i_Sf()
{
  {
    init_simple_test("aIp_BFu0i_Sf");
    static STRUCT_IF_C aIp_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aIp_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aIp_BFu0i_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu0i_Sf, aIp_BFu0i_Sf)
//============================================================================



static void Test_aIp_BFu0ll_Sf()
{
  {
    init_simple_test("aIp_BFu0ll_Sf");
    static STRUCT_IF_C aIp_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aIp_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aIp_BFu0ll_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu0ll_Sf, aIp_BFu0ll_Sf)
//============================================================================



static void Test_aIp_BFu0s_Sf()
{
  {
    init_simple_test("aIp_BFu0s_Sf");
    static STRUCT_IF_C aIp_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aIp_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aIp_BFu0s_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu0s_Sf, aIp_BFu0s_Sf)
//============================================================================



static void Test_aIp_Sf_BFu0c()
{
  {
    init_simple_test("aIp_Sf_BFu0c");
    static STRUCT_IF_C aIp_Sf_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aIp_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aIp_Sf_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_Sf_BFu0c, aIp_Sf_BFu0c)
//============================================================================



static void Test_aIp_Sf_BFu0i()
{
  {
    init_simple_test("aIp_Sf_BFu0i");
    static STRUCT_IF_C aIp_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aIp_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aIp_Sf_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_Sf_BFu0i, aIp_Sf_BFu0i)
//============================================================================



static void Test_aIp_Sf_BFu0ll()
{
  {
    init_simple_test("aIp_Sf_BFu0ll");
    static STRUCT_IF_C aIp_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aIp_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aIp_Sf_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_Sf_BFu0ll, aIp_Sf_BFu0ll)
//============================================================================



static void Test_aIp_Sf_BFu0s()
{
  {
    init_simple_test("aIp_Sf_BFu0s");
    static STRUCT_IF_C aIp_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aIp_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aIp_Sf_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aIp_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_Sf_BFu0s, aIp_Sf_BFu0s)
//============================================================================



static void Test_aL_BFu0c_Sf()
{
  {
    init_simple_test("aL_BFu0c_Sf");
    static STRUCT_IF_C aL_BFu0c_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aL_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aL_BFu0c_Sf.v1");
    check_field_offset(lv, v2, 8, "aL_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_BFu0c_Sf, aL_BFu0c_Sf)
//============================================================================



static void Test_aL_BFu0i_Sf()
{
  {
    init_simple_test("aL_BFu0i_Sf");
    static STRUCT_IF_C aL_BFu0i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aL_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aL_BFu0i_Sf.v1");
    check_field_offset(lv, v2, 8, "aL_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_BFu0i_Sf, aL_BFu0i_Sf)
//============================================================================



static void Test_aL_BFu0ll_Sf()
{
  {
    init_simple_test("aL_BFu0ll_Sf");
    static STRUCT_IF_C aL_BFu0ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aL_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aL_BFu0ll_Sf.v1");
    check_field_offset(lv, v2, 8, "aL_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_BFu0ll_Sf, aL_BFu0ll_Sf)
//============================================================================



static void Test_aL_BFu0s_Sf()
{
  {
    init_simple_test("aL_BFu0s_Sf");
    static STRUCT_IF_C aL_BFu0s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aL_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aL_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aL_BFu0s_Sf.v1");
    check_field_offset(lv, v2, 8, "aL_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_BFu0s_Sf, aL_BFu0s_Sf)
//============================================================================



static void Test_aL_Sf_BFu0c()
{
  {
    init_simple_test("aL_Sf_BFu0c");
    static STRUCT_IF_C aL_Sf_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aL_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aL_Sf_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aL_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Sf_BFu0c, aL_Sf_BFu0c)
//============================================================================



static void Test_aL_Sf_BFu0i()
{
  {
    init_simple_test("aL_Sf_BFu0i");
    static STRUCT_IF_C aL_Sf_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aL_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aL_Sf_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aL_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Sf_BFu0i, aL_Sf_BFu0i)
//============================================================================



static void Test_aL_Sf_BFu0ll()
{
  {
    init_simple_test("aL_Sf_BFu0ll");
    static STRUCT_IF_C aL_Sf_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aL_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aL_Sf_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aL_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Sf_BFu0ll, aL_Sf_BFu0ll)
//============================================================================



static void Test_aL_Sf_BFu0s()
{
  {
    init_simple_test("aL_Sf_BFu0s");
    static STRUCT_IF_C aL_Sf_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aL_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aL_Sf_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aL_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Sf_BFu0s, aL_Sf_BFu0s)
//============================================================================



static void Test_aS_BFu0c_Sf()
{
  {
    init_simple_test("aS_BFu0c_Sf");
    static STRUCT_IF_C aS_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aS_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aS_BFu0c_Sf.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu0c_Sf, aS_BFu0c_Sf)
//============================================================================



static void Test_aS_BFu0i_Sf()
{
  {
    init_simple_test("aS_BFu0i_Sf");
    static STRUCT_IF_C aS_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aS_BFu0i_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aS_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu0i_Sf, aS_BFu0i_Sf)
//============================================================================



static void Test_aS_BFu0ll_Sf()
{
  {
    init_simple_test("aS_BFu0ll_Sf");
    static STRUCT_IF_C aS_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aS_BFu0ll_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aS_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu0ll_Sf, aS_BFu0ll_Sf)
//============================================================================



static void Test_aS_BFu0s_Sf()
{
  {
    init_simple_test("aS_BFu0s_Sf");
    static STRUCT_IF_C aS_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aS_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aS_BFu0s_Sf.v1");
    check_field_offset(lv, v2, 2, "aS_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu0s_Sf, aS_BFu0s_Sf)
//============================================================================



static void Test_aS_Sf_BFu0c()
{
  {
    init_simple_test("aS_Sf_BFu0c");
    static STRUCT_IF_C aS_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aS_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aS_Sf_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aS_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_Sf_BFu0c, aS_Sf_BFu0c)
//============================================================================



static void Test_aS_Sf_BFu0i()
{
  {
    init_simple_test("aS_Sf_BFu0i");
    static STRUCT_IF_C aS_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aS_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aS_Sf_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aS_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_Sf_BFu0i, aS_Sf_BFu0i)
//============================================================================



static void Test_aS_Sf_BFu0ll()
{
  {
    init_simple_test("aS_Sf_BFu0ll");
    static STRUCT_IF_C aS_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aS_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aS_Sf_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aS_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_Sf_BFu0ll, aS_Sf_BFu0ll)
//============================================================================



static void Test_aS_Sf_BFu0s()
{
  {
    init_simple_test("aS_Sf_BFu0s");
    static STRUCT_IF_C aS_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aS_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aS_Sf_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aS_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_Sf_BFu0s, aS_Sf_BFu0s)
//============================================================================



static void Test_aSf_BFu0c()
{
  {
    init_simple_test("aSf_BFu0c");
    static STRUCT_IF_C aSf_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c, aSf_BFu0c)
//============================================================================



static void Test_aSf_BFu0c_BFu0c()
{
  {
    init_simple_test("aSf_BFu0c_BFu0c");
    static STRUCT_IF_C aSf_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu0c, aSf_BFu0c_BFu0c)
//============================================================================



static void Test_aSf_BFu0c_BFu0i()
{
  {
    init_simple_test("aSf_BFu0c_BFu0i");
    static STRUCT_IF_C aSf_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu0i, aSf_BFu0c_BFu0i)
//============================================================================



static void Test_aSf_BFu0c_BFu0ll()
{
  {
    init_simple_test("aSf_BFu0c_BFu0ll");
    static STRUCT_IF_C aSf_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu0ll, aSf_BFu0c_BFu0ll)
//============================================================================



static void Test_aSf_BFu0c_BFu0s()
{
  {
    init_simple_test("aSf_BFu0c_BFu0s");
    static STRUCT_IF_C aSf_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu0s, aSf_BFu0c_BFu0s)
//============================================================================



static void Test_aSf_BFu0c_BFu15i()
{
  {
    init_simple_test("aSf_BFu0c_BFu15i");
    static STRUCT_IF_C aSf_BFu0c_BFu15i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu15i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu15i, aSf_BFu0c_BFu15i)
//============================================================================



static void Test_aSf_BFu0c_BFu15ll()
{
  {
    init_simple_test("aSf_BFu0c_BFu15ll");
    static STRUCT_IF_C aSf_BFu0c_BFu15ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu15ll, aSf_BFu0c_BFu15ll)
//============================================================================



static void Test_aSf_BFu0c_BFu15s()
{
  {
    init_simple_test("aSf_BFu0c_BFu15s");
    static STRUCT_IF_C aSf_BFu0c_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu15s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu15s, aSf_BFu0c_BFu15s)
//============================================================================



static void Test_aSf_BFu0c_BFu16i()
{
  {
    init_simple_test("aSf_BFu0c_BFu16i");
    static STRUCT_IF_C aSf_BFu0c_BFu16i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu16i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu16i, aSf_BFu0c_BFu16i)
//============================================================================



static void Test_aSf_BFu0c_BFu16ll()
{
  {
    init_simple_test("aSf_BFu0c_BFu16ll");
    static STRUCT_IF_C aSf_BFu0c_BFu16ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu16ll, aSf_BFu0c_BFu16ll)
//============================================================================



static void Test_aSf_BFu0c_BFu16s()
{
  {
    init_simple_test("aSf_BFu0c_BFu16s");
    static STRUCT_IF_C aSf_BFu0c_BFu16s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu16s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu16s, aSf_BFu0c_BFu16s)
//============================================================================



static void Test_aSf_BFu0c_BFu17i()
{
  {
    init_simple_test("aSf_BFu0c_BFu17i");
    static STRUCT_IF_C aSf_BFu0c_BFu17i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu0c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu17i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu17i, aSf_BFu0c_BFu17i)
//============================================================================



static void Test_aSf_BFu0c_BFu17ll()
{
  {
    init_simple_test("aSf_BFu0c_BFu17ll");
    static STRUCT_IF_C aSf_BFu0c_BFu17ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu0c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu17ll, aSf_BFu0c_BFu17ll)
//============================================================================



static void Test_aSf_BFu0c_BFu1c()
{
  {
    init_simple_test("aSf_BFu0c_BFu1c");
    static STRUCT_IF_C aSf_BFu0c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu1c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu1c, aSf_BFu0c_BFu1c)
//============================================================================



static void Test_aSf_BFu0c_BFu1i()
{
  {
    init_simple_test("aSf_BFu0c_BFu1i");
    static STRUCT_IF_C aSf_BFu0c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu1i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu1i, aSf_BFu0c_BFu1i)
//============================================================================



static void Test_aSf_BFu0c_BFu1ll()
{
  {
    init_simple_test("aSf_BFu0c_BFu1ll");
    static STRUCT_IF_C aSf_BFu0c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu1ll, aSf_BFu0c_BFu1ll)
//============================================================================



static void Test_aSf_BFu0c_BFu1s()
{
  {
    init_simple_test("aSf_BFu0c_BFu1s");
    static STRUCT_IF_C aSf_BFu0c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu1s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu1s, aSf_BFu0c_BFu1s)
//============================================================================



static void Test_aSf_BFu0c_BFu31i()
{
  {
    init_simple_test("aSf_BFu0c_BFu31i");
    static STRUCT_IF_C aSf_BFu0c_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu31i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu31i, aSf_BFu0c_BFu31i)
//============================================================================



static void Test_aSf_BFu0c_BFu31ll()
{
  {
    init_simple_test("aSf_BFu0c_BFu31ll");
    static STRUCT_IF_C aSf_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu31ll, aSf_BFu0c_BFu31ll)
//============================================================================



static void Test_aSf_BFu0c_BFu32i()
{
  {
    init_simple_test("aSf_BFu0c_BFu32i");
    static STRUCT_IF_C aSf_BFu0c_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu32i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu32i, aSf_BFu0c_BFu32i)
//============================================================================



static void Test_aSf_BFu0c_BFu32ll()
{
  {
    init_simple_test("aSf_BFu0c_BFu32ll");
    static STRUCT_IF_C aSf_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu32ll, aSf_BFu0c_BFu32ll)
//============================================================================



static void Test_aSf_BFu0c_BFu33()
{
  {
    init_simple_test("aSf_BFu0c_BFu33");
    static STRUCT_IF_C aSf_BFu0c_BFu33 lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu0c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu33.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "aSf_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "aSf_BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu33, aSf_BFu0c_BFu33)
//============================================================================



static void Test_aSf_BFu0c_BFu7c()
{
  {
    init_simple_test("aSf_BFu0c_BFu7c");
    static STRUCT_IF_C aSf_BFu0c_BFu7c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu7c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu7c, aSf_BFu0c_BFu7c)
//============================================================================



static void Test_aSf_BFu0c_BFu7i()
{
  {
    init_simple_test("aSf_BFu0c_BFu7i");
    static STRUCT_IF_C aSf_BFu0c_BFu7i lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu7i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu7i, aSf_BFu0c_BFu7i)
//============================================================================



static void Test_aSf_BFu0c_BFu7ll()
{
  {
    init_simple_test("aSf_BFu0c_BFu7ll");
    static STRUCT_IF_C aSf_BFu0c_BFu7ll lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu7ll, aSf_BFu0c_BFu7ll)
//============================================================================



static void Test_aSf_BFu0c_BFu7s()
{
  {
    init_simple_test("aSf_BFu0c_BFu7s");
    static STRUCT_IF_C aSf_BFu0c_BFu7s lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu7s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu7s, aSf_BFu0c_BFu7s)
//============================================================================



static void Test_aSf_BFu0c_BFu8c()
{
  {
    init_simple_test("aSf_BFu0c_BFu8c");
    static STRUCT_IF_C aSf_BFu0c_BFu8c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu8c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu8c, aSf_BFu0c_BFu8c)
//============================================================================



static void Test_aSf_BFu0c_BFu8i()
{
  {
    init_simple_test("aSf_BFu0c_BFu8i");
    static STRUCT_IF_C aSf_BFu0c_BFu8i lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu8i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu8i, aSf_BFu0c_BFu8i)
//============================================================================



static void Test_aSf_BFu0c_BFu8ll()
{
  {
    init_simple_test("aSf_BFu0c_BFu8ll");
    static STRUCT_IF_C aSf_BFu0c_BFu8ll lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu8ll, aSf_BFu0c_BFu8ll)
//============================================================================



static void Test_aSf_BFu0c_BFu8s()
{
  {
    init_simple_test("aSf_BFu0c_BFu8s");
    static STRUCT_IF_C aSf_BFu0c_BFu8s lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu8s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu8s, aSf_BFu0c_BFu8s)
//============================================================================



static void Test_aSf_BFu0c_BFu9i()
{
  {
    init_simple_test("aSf_BFu0c_BFu9i");
    static STRUCT_IF_C aSf_BFu0c_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu9i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu9i, aSf_BFu0c_BFu9i)
//============================================================================



static void Test_aSf_BFu0c_BFu9ll()
{
  {
    init_simple_test("aSf_BFu0c_BFu9ll");
    static STRUCT_IF_C aSf_BFu0c_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu9ll, aSf_BFu0c_BFu9ll)
//============================================================================



static void Test_aSf_BFu0c_BFu9s()
{
  {
    init_simple_test("aSf_BFu0c_BFu9s");
    static STRUCT_IF_C aSf_BFu0c_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_BFu9s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu0c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_BFu9s, aSf_BFu0c_BFu9s)
//============================================================================



static void Test_aSf_BFu0c_C()
{
  {
    init_simple_test("aSf_BFu0c_C");
    static STRUCT_IF_C aSf_BFu0c_C lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_C.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_C, aSf_BFu0c_C)
//============================================================================



static void Test_aSf_BFu0c_D()
{
  {
    init_simple_test("aSf_BFu0c_D");
    static STRUCT_IF_C aSf_BFu0c_D lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu0c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_D.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_D, aSf_BFu0c_D)
//============================================================================



static void Test_aSf_BFu0c_F()
{
  {
    init_simple_test("aSf_BFu0c_F");
    static STRUCT_IF_C aSf_BFu0c_F lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_F.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_F, aSf_BFu0c_F)
//============================================================================



static void Test_aSf_BFu0c_I()
{
  {
    init_simple_test("aSf_BFu0c_I");
    static STRUCT_IF_C aSf_BFu0c_I lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_I.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_I, aSf_BFu0c_I)
//============================================================================



static void Test_aSf_BFu0c_Ip()
{
  {
    init_simple_test("aSf_BFu0c_Ip");
    static STRUCT_IF_C aSf_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu0c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_Ip.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_Ip, aSf_BFu0c_Ip)
//============================================================================



static void Test_aSf_BFu0c_L()
{
  {
    init_simple_test("aSf_BFu0c_L");
    static STRUCT_IF_C aSf_BFu0c_L lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu0c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_L.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_L, aSf_BFu0c_L)
//============================================================================



static void Test_aSf_BFu0c_S()
{
  {
    init_simple_test("aSf_BFu0c_S");
    static STRUCT_IF_C aSf_BFu0c_S lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_S.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_S, aSf_BFu0c_S)
//============================================================================



static void Test_aSf_BFu0c_Sf()
{
  {
    init_simple_test("aSf_BFu0c_Sf");
    static STRUCT_IF_C aSf_BFu0c_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_Sf.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_Sf, aSf_BFu0c_Sf)
//============================================================================



static void Test_aSf_BFu0c_Uc()
{
  {
    init_simple_test("aSf_BFu0c_Uc");
    static STRUCT_IF_C aSf_BFu0c_Uc lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_Uc.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_Uc, aSf_BFu0c_Uc)
//============================================================================



static void Test_aSf_BFu0c_Ui()
{
  {
    init_simple_test("aSf_BFu0c_Ui");
    static STRUCT_IF_C aSf_BFu0c_Ui lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_Ui.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_Ui, aSf_BFu0c_Ui)
//============================================================================



static void Test_aSf_BFu0c_Ul()
{
  {
    init_simple_test("aSf_BFu0c_Ul");
    static STRUCT_IF_C aSf_BFu0c_Ul lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu0c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_Ul.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_Ul, aSf_BFu0c_Ul)
//============================================================================



static void Test_aSf_BFu0c_Us()
{
  {
    init_simple_test("aSf_BFu0c_Us");
    static STRUCT_IF_C aSf_BFu0c_Us lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_Us.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_Us, aSf_BFu0c_Us)
//============================================================================



static void Test_aSf_BFu0c_Vp()
{
  {
    init_simple_test("aSf_BFu0c_Vp");
    static STRUCT_IF_C aSf_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu0c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0c_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu0c_Vp.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0c_Vp, aSf_BFu0c_Vp)
//============================================================================



static void Test_aSf_BFu0i()
{
  {
    init_simple_test("aSf_BFu0i");
    static STRUCT_IF_C aSf_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i, aSf_BFu0i)
//============================================================================



static void Test_aSf_BFu0i_BFu0c()
{
  {
    init_simple_test("aSf_BFu0i_BFu0c");
    static STRUCT_IF_C aSf_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu0c, aSf_BFu0i_BFu0c)
//============================================================================



static void Test_aSf_BFu0i_BFu0i()
{
  {
    init_simple_test("aSf_BFu0i_BFu0i");
    static STRUCT_IF_C aSf_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu0i, aSf_BFu0i_BFu0i)
//============================================================================



static void Test_aSf_BFu0i_BFu0ll()
{
  {
    init_simple_test("aSf_BFu0i_BFu0ll");
    static STRUCT_IF_C aSf_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu0ll, aSf_BFu0i_BFu0ll)
//============================================================================



static void Test_aSf_BFu0i_BFu0s()
{
  {
    init_simple_test("aSf_BFu0i_BFu0s");
    static STRUCT_IF_C aSf_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu0s, aSf_BFu0i_BFu0s)
//============================================================================



static void Test_aSf_BFu0i_BFu15i()
{
  {
    init_simple_test("aSf_BFu0i_BFu15i");
    static STRUCT_IF_C aSf_BFu0i_BFu15i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu15i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu15i, aSf_BFu0i_BFu15i)
//============================================================================



static void Test_aSf_BFu0i_BFu15ll()
{
  {
    init_simple_test("aSf_BFu0i_BFu15ll");
    static STRUCT_IF_C aSf_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu15ll, aSf_BFu0i_BFu15ll)
//============================================================================



static void Test_aSf_BFu0i_BFu15s()
{
  {
    init_simple_test("aSf_BFu0i_BFu15s");
    static STRUCT_IF_C aSf_BFu0i_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu15s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu15s, aSf_BFu0i_BFu15s)
//============================================================================



static void Test_aSf_BFu0i_BFu16i()
{
  {
    init_simple_test("aSf_BFu0i_BFu16i");
    static STRUCT_IF_C aSf_BFu0i_BFu16i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu16i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu16i, aSf_BFu0i_BFu16i)
//============================================================================



static void Test_aSf_BFu0i_BFu16ll()
{
  {
    init_simple_test("aSf_BFu0i_BFu16ll");
    static STRUCT_IF_C aSf_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu16ll, aSf_BFu0i_BFu16ll)
//============================================================================



static void Test_aSf_BFu0i_BFu16s()
{
  {
    init_simple_test("aSf_BFu0i_BFu16s");
    static STRUCT_IF_C aSf_BFu0i_BFu16s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu16s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu16s, aSf_BFu0i_BFu16s)
//============================================================================



static void Test_aSf_BFu0i_BFu17i()
{
  {
    init_simple_test("aSf_BFu0i_BFu17i");
    static STRUCT_IF_C aSf_BFu0i_BFu17i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu0i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu17i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu17i, aSf_BFu0i_BFu17i)
//============================================================================



static void Test_aSf_BFu0i_BFu17ll()
{
  {
    init_simple_test("aSf_BFu0i_BFu17ll");
    static STRUCT_IF_C aSf_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu0i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu17ll, aSf_BFu0i_BFu17ll)
//============================================================================



static void Test_aSf_BFu0i_BFu1c()
{
  {
    init_simple_test("aSf_BFu0i_BFu1c");
    static STRUCT_IF_C aSf_BFu0i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu1c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu1c, aSf_BFu0i_BFu1c)
//============================================================================



static void Test_aSf_BFu0i_BFu1i()
{
  {
    init_simple_test("aSf_BFu0i_BFu1i");
    static STRUCT_IF_C aSf_BFu0i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu1i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu1i, aSf_BFu0i_BFu1i)
//============================================================================



static void Test_aSf_BFu0i_BFu1ll()
{
  {
    init_simple_test("aSf_BFu0i_BFu1ll");
    static STRUCT_IF_C aSf_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu1ll, aSf_BFu0i_BFu1ll)
//============================================================================



static void Test_aSf_BFu0i_BFu1s()
{
  {
    init_simple_test("aSf_BFu0i_BFu1s");
    static STRUCT_IF_C aSf_BFu0i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu1s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu1s, aSf_BFu0i_BFu1s)
//============================================================================



static void Test_aSf_BFu0i_BFu31i()
{
  {
    init_simple_test("aSf_BFu0i_BFu31i");
    static STRUCT_IF_C aSf_BFu0i_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu31i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu31i, aSf_BFu0i_BFu31i)
//============================================================================



static void Test_aSf_BFu0i_BFu31ll()
{
  {
    init_simple_test("aSf_BFu0i_BFu31ll");
    static STRUCT_IF_C aSf_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu31ll, aSf_BFu0i_BFu31ll)
//============================================================================



static void Test_aSf_BFu0i_BFu32i()
{
  {
    init_simple_test("aSf_BFu0i_BFu32i");
    static STRUCT_IF_C aSf_BFu0i_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu32i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu32i, aSf_BFu0i_BFu32i)
//============================================================================



static void Test_aSf_BFu0i_BFu32ll()
{
  {
    init_simple_test("aSf_BFu0i_BFu32ll");
    static STRUCT_IF_C aSf_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu32ll, aSf_BFu0i_BFu32ll)
//============================================================================



static void Test_aSf_BFu0i_BFu33()
{
  {
    init_simple_test("aSf_BFu0i_BFu33");
    static STRUCT_IF_C aSf_BFu0i_BFu33 lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu0i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu33.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "aSf_BFu0i_BFu33");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "aSf_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu33, aSf_BFu0i_BFu33)
//============================================================================



static void Test_aSf_BFu0i_BFu7c()
{
  {
    init_simple_test("aSf_BFu0i_BFu7c");
    static STRUCT_IF_C aSf_BFu0i_BFu7c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu7c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu7c, aSf_BFu0i_BFu7c)
//============================================================================



static void Test_aSf_BFu0i_BFu7i()
{
  {
    init_simple_test("aSf_BFu0i_BFu7i");
    static STRUCT_IF_C aSf_BFu0i_BFu7i lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu7i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu7i, aSf_BFu0i_BFu7i)
//============================================================================



static void Test_aSf_BFu0i_BFu7ll()
{
  {
    init_simple_test("aSf_BFu0i_BFu7ll");
    static STRUCT_IF_C aSf_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu7ll, aSf_BFu0i_BFu7ll)
//============================================================================



static void Test_aSf_BFu0i_BFu7s()
{
  {
    init_simple_test("aSf_BFu0i_BFu7s");
    static STRUCT_IF_C aSf_BFu0i_BFu7s lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu7s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu7s, aSf_BFu0i_BFu7s)
//============================================================================



static void Test_aSf_BFu0i_BFu8c()
{
  {
    init_simple_test("aSf_BFu0i_BFu8c");
    static STRUCT_IF_C aSf_BFu0i_BFu8c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu8c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu8c, aSf_BFu0i_BFu8c)
//============================================================================



static void Test_aSf_BFu0i_BFu8i()
{
  {
    init_simple_test("aSf_BFu0i_BFu8i");
    static STRUCT_IF_C aSf_BFu0i_BFu8i lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu8i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu8i, aSf_BFu0i_BFu8i)
//============================================================================



static void Test_aSf_BFu0i_BFu8ll()
{
  {
    init_simple_test("aSf_BFu0i_BFu8ll");
    static STRUCT_IF_C aSf_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu8ll, aSf_BFu0i_BFu8ll)
//============================================================================



static void Test_aSf_BFu0i_BFu8s()
{
  {
    init_simple_test("aSf_BFu0i_BFu8s");
    static STRUCT_IF_C aSf_BFu0i_BFu8s lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu8s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu8s, aSf_BFu0i_BFu8s)
//============================================================================



static void Test_aSf_BFu0i_BFu9i()
{
  {
    init_simple_test("aSf_BFu0i_BFu9i");
    static STRUCT_IF_C aSf_BFu0i_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu9i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu9i, aSf_BFu0i_BFu9i)
//============================================================================



static void Test_aSf_BFu0i_BFu9ll()
{
  {
    init_simple_test("aSf_BFu0i_BFu9ll");
    static STRUCT_IF_C aSf_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu9ll, aSf_BFu0i_BFu9ll)
//============================================================================



static void Test_aSf_BFu0i_BFu9s()
{
  {
    init_simple_test("aSf_BFu0i_BFu9s");
    static STRUCT_IF_C aSf_BFu0i_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_BFu9s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_BFu9s, aSf_BFu0i_BFu9s)
//============================================================================



static void Test_aSf_BFu0i_C()
{
  {
    init_simple_test("aSf_BFu0i_C");
    static STRUCT_IF_C aSf_BFu0i_C lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_C.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_C, aSf_BFu0i_C)
//============================================================================



static void Test_aSf_BFu0i_D()
{
  {
    init_simple_test("aSf_BFu0i_D");
    static STRUCT_IF_C aSf_BFu0i_D lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu0i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_D.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_D, aSf_BFu0i_D)
//============================================================================



static void Test_aSf_BFu0i_F()
{
  {
    init_simple_test("aSf_BFu0i_F");
    static STRUCT_IF_C aSf_BFu0i_F lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_F.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_F, aSf_BFu0i_F)
//============================================================================



static void Test_aSf_BFu0i_I()
{
  {
    init_simple_test("aSf_BFu0i_I");
    static STRUCT_IF_C aSf_BFu0i_I lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_I.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_I, aSf_BFu0i_I)
//============================================================================



static void Test_aSf_BFu0i_Ip()
{
  {
    init_simple_test("aSf_BFu0i_Ip");
    static STRUCT_IF_C aSf_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu0i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_Ip.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_Ip, aSf_BFu0i_Ip)
//============================================================================



static void Test_aSf_BFu0i_L()
{
  {
    init_simple_test("aSf_BFu0i_L");
    static STRUCT_IF_C aSf_BFu0i_L lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu0i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_L.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_L, aSf_BFu0i_L)
//============================================================================



static void Test_aSf_BFu0i_S()
{
  {
    init_simple_test("aSf_BFu0i_S");
    static STRUCT_IF_C aSf_BFu0i_S lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_S.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_S, aSf_BFu0i_S)
//============================================================================



static void Test_aSf_BFu0i_Sf()
{
  {
    init_simple_test("aSf_BFu0i_Sf");
    static STRUCT_IF_C aSf_BFu0i_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_Sf.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_Sf, aSf_BFu0i_Sf)
//============================================================================



static void Test_aSf_BFu0i_Uc()
{
  {
    init_simple_test("aSf_BFu0i_Uc");
    static STRUCT_IF_C aSf_BFu0i_Uc lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_Uc.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_Uc, aSf_BFu0i_Uc)
//============================================================================



static void Test_aSf_BFu0i_Ui()
{
  {
    init_simple_test("aSf_BFu0i_Ui");
    static STRUCT_IF_C aSf_BFu0i_Ui lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_Ui.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_Ui, aSf_BFu0i_Ui)
//============================================================================



static void Test_aSf_BFu0i_Ul()
{
  {
    init_simple_test("aSf_BFu0i_Ul");
    static STRUCT_IF_C aSf_BFu0i_Ul lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu0i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_Ul.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_Ul, aSf_BFu0i_Ul)
//============================================================================



static void Test_aSf_BFu0i_Us()
{
  {
    init_simple_test("aSf_BFu0i_Us");
    static STRUCT_IF_C aSf_BFu0i_Us lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_Us.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_Us, aSf_BFu0i_Us)
//============================================================================



static void Test_aSf_BFu0i_Vp()
{
  {
    init_simple_test("aSf_BFu0i_Vp");
    static STRUCT_IF_C aSf_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu0i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0i_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu0i_Vp.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0i_Vp, aSf_BFu0i_Vp)
//============================================================================



static void Test_aSf_BFu0ll()
{
  {
    init_simple_test("aSf_BFu0ll");
    static STRUCT_IF_C aSf_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll, aSf_BFu0ll)
//============================================================================



static void Test_aSf_BFu0ll_BFu0c()
{
  {
    init_simple_test("aSf_BFu0ll_BFu0c");
    static STRUCT_IF_C aSf_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu0c, aSf_BFu0ll_BFu0c)
//============================================================================



static void Test_aSf_BFu0ll_BFu0i()
{
  {
    init_simple_test("aSf_BFu0ll_BFu0i");
    static STRUCT_IF_C aSf_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu0i, aSf_BFu0ll_BFu0i)
//============================================================================



static void Test_aSf_BFu0ll_BFu0ll()
{
  {
    init_simple_test("aSf_BFu0ll_BFu0ll");
    static STRUCT_IF_C aSf_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu0ll, aSf_BFu0ll_BFu0ll)
//============================================================================



static void Test_aSf_BFu0ll_BFu0s()
{
  {
    init_simple_test("aSf_BFu0ll_BFu0s");
    static STRUCT_IF_C aSf_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu0s, aSf_BFu0ll_BFu0s)
//============================================================================



static void Test_aSf_BFu0ll_BFu15i()
{
  {
    init_simple_test("aSf_BFu0ll_BFu15i");
    static STRUCT_IF_C aSf_BFu0ll_BFu15i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu0ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu15i, aSf_BFu0ll_BFu15i)
//============================================================================



static void Test_aSf_BFu0ll_BFu15ll()
{
  {
    init_simple_test("aSf_BFu0ll_BFu15ll");
    static STRUCT_IF_C aSf_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu0ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu15ll, aSf_BFu0ll_BFu15ll)
//============================================================================



static void Test_aSf_BFu0ll_BFu15s()
{
  {
    init_simple_test("aSf_BFu0ll_BFu15s");
    static STRUCT_IF_C aSf_BFu0ll_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu0ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu15s, aSf_BFu0ll_BFu15s)
//============================================================================



static void Test_aSf_BFu0ll_BFu16i()
{
  {
    init_simple_test("aSf_BFu0ll_BFu16i");
    static STRUCT_IF_C aSf_BFu0ll_BFu16i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu0ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu16i, aSf_BFu0ll_BFu16i)
//============================================================================



static void Test_aSf_BFu0ll_BFu16ll()
{
  {
    init_simple_test("aSf_BFu0ll_BFu16ll");
    static STRUCT_IF_C aSf_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu0ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu16ll, aSf_BFu0ll_BFu16ll)
//============================================================================



static void Test_aSf_BFu0ll_BFu16s()
{
  {
    init_simple_test("aSf_BFu0ll_BFu16s");
    static STRUCT_IF_C aSf_BFu0ll_BFu16s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu0ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu16s, aSf_BFu0ll_BFu16s)
//============================================================================



static void Test_aSf_BFu0ll_BFu17i()
{
  {
    init_simple_test("aSf_BFu0ll_BFu17i");
    static STRUCT_IF_C aSf_BFu0ll_BFu17i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu0ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu0ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu17i, aSf_BFu0ll_BFu17i)
//============================================================================



static void Test_aSf_BFu0ll_BFu17ll()
{
  {
    init_simple_test("aSf_BFu0ll_BFu17ll");
    static STRUCT_IF_C aSf_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu0ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu17ll, aSf_BFu0ll_BFu17ll)
//============================================================================



static void Test_aSf_BFu0ll_BFu1c()
{
  {
    init_simple_test("aSf_BFu0ll_BFu1c");
    static STRUCT_IF_C aSf_BFu0ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu1c, aSf_BFu0ll_BFu1c)
//============================================================================



static void Test_aSf_BFu0ll_BFu1i()
{
  {
    init_simple_test("aSf_BFu0ll_BFu1i");
    static STRUCT_IF_C aSf_BFu0ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu1i, aSf_BFu0ll_BFu1i)
//============================================================================



static void Test_aSf_BFu0ll_BFu1ll()
{
  {
    init_simple_test("aSf_BFu0ll_BFu1ll");
    static STRUCT_IF_C aSf_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu1ll, aSf_BFu0ll_BFu1ll)
//============================================================================



static void Test_aSf_BFu0ll_BFu1s()
{
  {
    init_simple_test("aSf_BFu0ll_BFu1s");
    static STRUCT_IF_C aSf_BFu0ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu1s, aSf_BFu0ll_BFu1s)
//============================================================================



static void Test_aSf_BFu0ll_BFu31i()
{
  {
    init_simple_test("aSf_BFu0ll_BFu31i");
    static STRUCT_IF_C aSf_BFu0ll_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu31i, aSf_BFu0ll_BFu31i)
//============================================================================



static void Test_aSf_BFu0ll_BFu31ll()
{
  {
    init_simple_test("aSf_BFu0ll_BFu31ll");
    static STRUCT_IF_C aSf_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu31ll, aSf_BFu0ll_BFu31ll)
//============================================================================



static void Test_aSf_BFu0ll_BFu32i()
{
  {
    init_simple_test("aSf_BFu0ll_BFu32i");
    static STRUCT_IF_C aSf_BFu0ll_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu32i, aSf_BFu0ll_BFu32i)
//============================================================================



static void Test_aSf_BFu0ll_BFu32ll()
{
  {
    init_simple_test("aSf_BFu0ll_BFu32ll");
    static STRUCT_IF_C aSf_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu32ll, aSf_BFu0ll_BFu32ll)
//============================================================================



static void Test_aSf_BFu0ll_BFu33()
{
  {
    init_simple_test("aSf_BFu0ll_BFu33");
    static STRUCT_IF_C aSf_BFu0ll_BFu33 lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu0ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu33.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "aSf_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "aSf_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu33, aSf_BFu0ll_BFu33)
//============================================================================



static void Test_aSf_BFu0ll_BFu7c()
{
  {
    init_simple_test("aSf_BFu0ll_BFu7c");
    static STRUCT_IF_C aSf_BFu0ll_BFu7c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu7c, aSf_BFu0ll_BFu7c)
//============================================================================



static void Test_aSf_BFu0ll_BFu7i()
{
  {
    init_simple_test("aSf_BFu0ll_BFu7i");
    static STRUCT_IF_C aSf_BFu0ll_BFu7i lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu7i, aSf_BFu0ll_BFu7i)
//============================================================================



static void Test_aSf_BFu0ll_BFu7ll()
{
  {
    init_simple_test("aSf_BFu0ll_BFu7ll");
    static STRUCT_IF_C aSf_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu7ll, aSf_BFu0ll_BFu7ll)
//============================================================================



static void Test_aSf_BFu0ll_BFu7s()
{
  {
    init_simple_test("aSf_BFu0ll_BFu7s");
    static STRUCT_IF_C aSf_BFu0ll_BFu7s lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu7s, aSf_BFu0ll_BFu7s)
//============================================================================



static void Test_aSf_BFu0ll_BFu8c()
{
  {
    init_simple_test("aSf_BFu0ll_BFu8c");
    static STRUCT_IF_C aSf_BFu0ll_BFu8c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu8c, aSf_BFu0ll_BFu8c)
//============================================================================



static void Test_aSf_BFu0ll_BFu8i()
{
  {
    init_simple_test("aSf_BFu0ll_BFu8i");
    static STRUCT_IF_C aSf_BFu0ll_BFu8i lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu8i, aSf_BFu0ll_BFu8i)
//============================================================================



static void Test_aSf_BFu0ll_BFu8ll()
{
  {
    init_simple_test("aSf_BFu0ll_BFu8ll");
    static STRUCT_IF_C aSf_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu8ll, aSf_BFu0ll_BFu8ll)
//============================================================================



static void Test_aSf_BFu0ll_BFu8s()
{
  {
    init_simple_test("aSf_BFu0ll_BFu8s");
    static STRUCT_IF_C aSf_BFu0ll_BFu8s lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu8s, aSf_BFu0ll_BFu8s)
//============================================================================



static void Test_aSf_BFu0ll_BFu9i()
{
  {
    init_simple_test("aSf_BFu0ll_BFu9i");
    static STRUCT_IF_C aSf_BFu0ll_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu0ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu9i, aSf_BFu0ll_BFu9i)
//============================================================================



static void Test_aSf_BFu0ll_BFu9ll()
{
  {
    init_simple_test("aSf_BFu0ll_BFu9ll");
    static STRUCT_IF_C aSf_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu0ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu9ll, aSf_BFu0ll_BFu9ll)
//============================================================================



static void Test_aSf_BFu0ll_BFu9s()
{
  {
    init_simple_test("aSf_BFu0ll_BFu9s");
    static STRUCT_IF_C aSf_BFu0ll_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu0ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_BFu9s, aSf_BFu0ll_BFu9s)
//============================================================================



static void Test_aSf_BFu0ll_C()
{
  {
    init_simple_test("aSf_BFu0ll_C");
    static STRUCT_IF_C aSf_BFu0ll_C lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_C.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_C, aSf_BFu0ll_C)
//============================================================================



static void Test_aSf_BFu0ll_D()
{
  {
    init_simple_test("aSf_BFu0ll_D");
    static STRUCT_IF_C aSf_BFu0ll_D lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu0ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_D.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_D, aSf_BFu0ll_D)
//============================================================================



static void Test_aSf_BFu0ll_F()
{
  {
    init_simple_test("aSf_BFu0ll_F");
    static STRUCT_IF_C aSf_BFu0ll_F lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_F.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_F, aSf_BFu0ll_F)
//============================================================================



static void Test_aSf_BFu0ll_I()
{
  {
    init_simple_test("aSf_BFu0ll_I");
    static STRUCT_IF_C aSf_BFu0ll_I lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_I.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_I, aSf_BFu0ll_I)
//============================================================================



static void Test_aSf_BFu0ll_Ip()
{
  {
    init_simple_test("aSf_BFu0ll_Ip");
    static STRUCT_IF_C aSf_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu0ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_Ip.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_Ip, aSf_BFu0ll_Ip)
//============================================================================



static void Test_aSf_BFu0ll_L()
{
  {
    init_simple_test("aSf_BFu0ll_L");
    static STRUCT_IF_C aSf_BFu0ll_L lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu0ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_L.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_L, aSf_BFu0ll_L)
//============================================================================



static void Test_aSf_BFu0ll_S()
{
  {
    init_simple_test("aSf_BFu0ll_S");
    static STRUCT_IF_C aSf_BFu0ll_S lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_S.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_S, aSf_BFu0ll_S)
//============================================================================



static void Test_aSf_BFu0ll_Sf()
{
  {
    init_simple_test("aSf_BFu0ll_Sf");
    static STRUCT_IF_C aSf_BFu0ll_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_Sf.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_Sf, aSf_BFu0ll_Sf)
//============================================================================



static void Test_aSf_BFu0ll_Uc()
{
  {
    init_simple_test("aSf_BFu0ll_Uc");
    static STRUCT_IF_C aSf_BFu0ll_Uc lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_Uc.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_Uc, aSf_BFu0ll_Uc)
//============================================================================



static void Test_aSf_BFu0ll_Ui()
{
  {
    init_simple_test("aSf_BFu0ll_Ui");
    static STRUCT_IF_C aSf_BFu0ll_Ui lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_Ui.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_Ui, aSf_BFu0ll_Ui)
//============================================================================



static void Test_aSf_BFu0ll_Ul()
{
  {
    init_simple_test("aSf_BFu0ll_Ul");
    static STRUCT_IF_C aSf_BFu0ll_Ul lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu0ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_Ul.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_Ul, aSf_BFu0ll_Ul)
//============================================================================



static void Test_aSf_BFu0ll_Us()
{
  {
    init_simple_test("aSf_BFu0ll_Us");
    static STRUCT_IF_C aSf_BFu0ll_Us lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_Us.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_Us, aSf_BFu0ll_Us)
//============================================================================



static void Test_aSf_BFu0ll_Vp()
{
  {
    init_simple_test("aSf_BFu0ll_Vp");
    static STRUCT_IF_C aSf_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu0ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0ll_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu0ll_Vp.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0ll_Vp, aSf_BFu0ll_Vp)
//============================================================================



static void Test_aSf_BFu0s()
{
  {
    init_simple_test("aSf_BFu0s");
    static STRUCT_IF_C aSf_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s, aSf_BFu0s)
//============================================================================



static void Test_aSf_BFu0s_BFu0c()
{
  {
    init_simple_test("aSf_BFu0s_BFu0c");
    static STRUCT_IF_C aSf_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu0c, aSf_BFu0s_BFu0c)
//============================================================================



static void Test_aSf_BFu0s_BFu0i()
{
  {
    init_simple_test("aSf_BFu0s_BFu0i");
    static STRUCT_IF_C aSf_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu0i, aSf_BFu0s_BFu0i)
//============================================================================



static void Test_aSf_BFu0s_BFu0ll()
{
  {
    init_simple_test("aSf_BFu0s_BFu0ll");
    static STRUCT_IF_C aSf_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu0ll, aSf_BFu0s_BFu0ll)
//============================================================================



static void Test_aSf_BFu0s_BFu0s()
{
  {
    init_simple_test("aSf_BFu0s_BFu0s");
    static STRUCT_IF_C aSf_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu0s, aSf_BFu0s_BFu0s)
//============================================================================



static void Test_aSf_BFu0s_BFu15i()
{
  {
    init_simple_test("aSf_BFu0s_BFu15i");
    static STRUCT_IF_C aSf_BFu0s_BFu15i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu15i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu15i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu15i, aSf_BFu0s_BFu15i)
//============================================================================



static void Test_aSf_BFu0s_BFu15ll()
{
  {
    init_simple_test("aSf_BFu0s_BFu15ll");
    static STRUCT_IF_C aSf_BFu0s_BFu15ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu15ll, aSf_BFu0s_BFu15ll)
//============================================================================



static void Test_aSf_BFu0s_BFu15s()
{
  {
    init_simple_test("aSf_BFu0s_BFu15s");
    static STRUCT_IF_C aSf_BFu0s_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu15s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu15s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu15s, aSf_BFu0s_BFu15s)
//============================================================================



static void Test_aSf_BFu0s_BFu16i()
{
  {
    init_simple_test("aSf_BFu0s_BFu16i");
    static STRUCT_IF_C aSf_BFu0s_BFu16i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu16i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu16i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu16i, aSf_BFu0s_BFu16i)
//============================================================================



static void Test_aSf_BFu0s_BFu16ll()
{
  {
    init_simple_test("aSf_BFu0s_BFu16ll");
    static STRUCT_IF_C aSf_BFu0s_BFu16ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu16ll, aSf_BFu0s_BFu16ll)
//============================================================================



static void Test_aSf_BFu0s_BFu16s()
{
  {
    init_simple_test("aSf_BFu0s_BFu16s");
    static STRUCT_IF_C aSf_BFu0s_BFu16s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu16s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu16s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu16s, aSf_BFu0s_BFu16s)
//============================================================================



static void Test_aSf_BFu0s_BFu17i()
{
  {
    init_simple_test("aSf_BFu0s_BFu17i");
    static STRUCT_IF_C aSf_BFu0s_BFu17i lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu0s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu17i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu17i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu17i, aSf_BFu0s_BFu17i)
//============================================================================



static void Test_aSf_BFu0s_BFu17ll()
{
  {
    init_simple_test("aSf_BFu0s_BFu17ll");
    static STRUCT_IF_C aSf_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu0s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu17ll, aSf_BFu0s_BFu17ll)
//============================================================================



static void Test_aSf_BFu0s_BFu1c()
{
  {
    init_simple_test("aSf_BFu0s_BFu1c");
    static STRUCT_IF_C aSf_BFu0s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu1c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu1c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu1c, aSf_BFu0s_BFu1c)
//============================================================================



static void Test_aSf_BFu0s_BFu1i()
{
  {
    init_simple_test("aSf_BFu0s_BFu1i");
    static STRUCT_IF_C aSf_BFu0s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu1i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu1i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu1i, aSf_BFu0s_BFu1i)
//============================================================================



static void Test_aSf_BFu0s_BFu1ll()
{
  {
    init_simple_test("aSf_BFu0s_BFu1ll");
    static STRUCT_IF_C aSf_BFu0s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu1ll, aSf_BFu0s_BFu1ll)
//============================================================================



static void Test_aSf_BFu0s_BFu1s()
{
  {
    init_simple_test("aSf_BFu0s_BFu1s");
    static STRUCT_IF_C aSf_BFu0s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu1s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu1s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu1s, aSf_BFu0s_BFu1s)
//============================================================================



static void Test_aSf_BFu0s_BFu31i()
{
  {
    init_simple_test("aSf_BFu0s_BFu31i");
    static STRUCT_IF_C aSf_BFu0s_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu31i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu31i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu31i, aSf_BFu0s_BFu31i)
//============================================================================



static void Test_aSf_BFu0s_BFu31ll()
{
  {
    init_simple_test("aSf_BFu0s_BFu31ll");
    static STRUCT_IF_C aSf_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu31ll, aSf_BFu0s_BFu31ll)
//============================================================================



static void Test_aSf_BFu0s_BFu32i()
{
  {
    init_simple_test("aSf_BFu0s_BFu32i");
    static STRUCT_IF_C aSf_BFu0s_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu32i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu32i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu32i, aSf_BFu0s_BFu32i)
//============================================================================



static void Test_aSf_BFu0s_BFu32ll()
{
  {
    init_simple_test("aSf_BFu0s_BFu32ll");
    static STRUCT_IF_C aSf_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu32ll, aSf_BFu0s_BFu32ll)
//============================================================================



static void Test_aSf_BFu0s_BFu33()
{
  {
    init_simple_test("aSf_BFu0s_BFu33");
    static STRUCT_IF_C aSf_BFu0s_BFu33 lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu0s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu33)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu33.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "aSf_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "aSf_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu33, aSf_BFu0s_BFu33)
//============================================================================



static void Test_aSf_BFu0s_BFu7c()
{
  {
    init_simple_test("aSf_BFu0s_BFu7c");
    static STRUCT_IF_C aSf_BFu0s_BFu7c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu7c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu7c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu7c, aSf_BFu0s_BFu7c)
//============================================================================



static void Test_aSf_BFu0s_BFu7i()
{
  {
    init_simple_test("aSf_BFu0s_BFu7i");
    static STRUCT_IF_C aSf_BFu0s_BFu7i lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu7i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu7i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu7i, aSf_BFu0s_BFu7i)
//============================================================================



static void Test_aSf_BFu0s_BFu7ll()
{
  {
    init_simple_test("aSf_BFu0s_BFu7ll");
    static STRUCT_IF_C aSf_BFu0s_BFu7ll lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu7ll, aSf_BFu0s_BFu7ll)
//============================================================================



static void Test_aSf_BFu0s_BFu7s()
{
  {
    init_simple_test("aSf_BFu0s_BFu7s");
    static STRUCT_IF_C aSf_BFu0s_BFu7s lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu7s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu7s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu7s, aSf_BFu0s_BFu7s)
//============================================================================



static void Test_aSf_BFu0s_BFu8c()
{
  {
    init_simple_test("aSf_BFu0s_BFu8c");
    static STRUCT_IF_C aSf_BFu0s_BFu8c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu8c)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu8c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu8c, aSf_BFu0s_BFu8c)
//============================================================================



static void Test_aSf_BFu0s_BFu8i()
{
  {
    init_simple_test("aSf_BFu0s_BFu8i");
    static STRUCT_IF_C aSf_BFu0s_BFu8i lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu8i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu8i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu8i, aSf_BFu0s_BFu8i)
//============================================================================



static void Test_aSf_BFu0s_BFu8ll()
{
  {
    init_simple_test("aSf_BFu0s_BFu8ll");
    static STRUCT_IF_C aSf_BFu0s_BFu8ll lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu8ll, aSf_BFu0s_BFu8ll)
//============================================================================



static void Test_aSf_BFu0s_BFu8s()
{
  {
    init_simple_test("aSf_BFu0s_BFu8s");
    static STRUCT_IF_C aSf_BFu0s_BFu8s lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu8s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu8s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu8s, aSf_BFu0s_BFu8s)
//============================================================================



static void Test_aSf_BFu0s_BFu9i()
{
  {
    init_simple_test("aSf_BFu0s_BFu9i");
    static STRUCT_IF_C aSf_BFu0s_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu9i)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu9i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu9i, aSf_BFu0s_BFu9i)
//============================================================================



static void Test_aSf_BFu0s_BFu9ll()
{
  {
    init_simple_test("aSf_BFu0s_BFu9ll");
    static STRUCT_IF_C aSf_BFu0s_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu9ll, aSf_BFu0s_BFu9ll)
//============================================================================



static void Test_aSf_BFu0s_BFu9s()
{
  {
    init_simple_test("aSf_BFu0s_BFu9s");
    static STRUCT_IF_C aSf_BFu0s_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_BFu9s)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_BFu9s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_BFu9s, aSf_BFu0s_BFu9s)
//============================================================================



static void Test_aSf_BFu0s_C()
{
  {
    init_simple_test("aSf_BFu0s_C");
    static STRUCT_IF_C aSf_BFu0s_C lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_C)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_C.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_C, aSf_BFu0s_C)
//============================================================================



static void Test_aSf_BFu0s_D()
{
  {
    init_simple_test("aSf_BFu0s_D");
    static STRUCT_IF_C aSf_BFu0s_D lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu0s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_D)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_D.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_D, aSf_BFu0s_D)
//============================================================================



static void Test_aSf_BFu0s_F()
{
  {
    init_simple_test("aSf_BFu0s_F");
    static STRUCT_IF_C aSf_BFu0s_F lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_F)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_F.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_F, aSf_BFu0s_F)
//============================================================================



static void Test_aSf_BFu0s_I()
{
  {
    init_simple_test("aSf_BFu0s_I");
    static STRUCT_IF_C aSf_BFu0s_I lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_I)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_I.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_I, aSf_BFu0s_I)
//============================================================================



static void Test_aSf_BFu0s_Ip()
{
  {
    init_simple_test("aSf_BFu0s_Ip");
    static STRUCT_IF_C aSf_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu0s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_Ip)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_Ip.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_Ip, aSf_BFu0s_Ip)
//============================================================================



static void Test_aSf_BFu0s_L()
{
  {
    init_simple_test("aSf_BFu0s_L");
    static STRUCT_IF_C aSf_BFu0s_L lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu0s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_L)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_L.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_L, aSf_BFu0s_L)
//============================================================================



static void Test_aSf_BFu0s_S()
{
  {
    init_simple_test("aSf_BFu0s_S");
    static STRUCT_IF_C aSf_BFu0s_S lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_S)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_S.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_S, aSf_BFu0s_S)
//============================================================================



static void Test_aSf_BFu0s_Sf()
{
  {
    init_simple_test("aSf_BFu0s_Sf");
    static STRUCT_IF_C aSf_BFu0s_Sf lv;
    check2(sizeof(lv), 0, "sizeof(aSf_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_Sf.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_Sf, aSf_BFu0s_Sf)
//============================================================================



static void Test_aSf_BFu0s_Uc()
{
  {
    init_simple_test("aSf_BFu0s_Uc");
    static STRUCT_IF_C aSf_BFu0s_Uc lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu0s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_Uc)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_Uc.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_Uc, aSf_BFu0s_Uc)
//============================================================================



static void Test_aSf_BFu0s_Ui()
{
  {
    init_simple_test("aSf_BFu0s_Ui");
    static STRUCT_IF_C aSf_BFu0s_Ui lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu0s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_Ui)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_Ui.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_Ui, aSf_BFu0s_Ui)
//============================================================================



static void Test_aSf_BFu0s_Ul()
{
  {
    init_simple_test("aSf_BFu0s_Ul");
    static STRUCT_IF_C aSf_BFu0s_Ul lv;
    check2(sizeof(lv), 8, "sizeof(aSf_BFu0s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_Ul)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_Ul.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_Ul, aSf_BFu0s_Ul)
//============================================================================



static void Test_aSf_BFu0s_Us()
{
  {
    init_simple_test("aSf_BFu0s_Us");
    static STRUCT_IF_C aSf_BFu0s_Us lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu0s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_Us)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_Us.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_Us, aSf_BFu0s_Us)
//============================================================================



static void Test_aSf_BFu0s_Vp()
{
  {
    init_simple_test("aSf_BFu0s_Vp");
    static STRUCT_IF_C aSf_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu0s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu0s_Vp)");
    check_field_offset(lv, v1, 0, "aSf_BFu0s_Vp.v1");
    check_field_offset(lv, v2, 0, "aSf_BFu0s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu0s_Vp, aSf_BFu0s_Vp)
//============================================================================



static void Test_aSf_BFu15i_BFu0c()
{
  {
    init_simple_test("aSf_BFu15i_BFu0c");
    static STRUCT_IF_C aSf_BFu15i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu15i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu15i_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu15i_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu15i_BFu0c, aSf_BFu15i_BFu0c)
//============================================================================



static void Test_aSf_BFu15i_BFu0i()
{
  {
    init_simple_test("aSf_BFu15i_BFu0i");
    static STRUCT_IF_C aSf_BFu15i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu15i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu15i_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu15i_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu15i_BFu0i, aSf_BFu15i_BFu0i)
//============================================================================



static void Test_aSf_BFu15i_BFu0ll()
{
  {
    init_simple_test("aSf_BFu15i_BFu0ll");
    static STRUCT_IF_C aSf_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu15i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu15i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu15i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu15i_BFu0ll, aSf_BFu15i_BFu0ll)
//============================================================================



static void Test_aSf_BFu15i_BFu0s()
{
  {
    init_simple_test("aSf_BFu15i_BFu0s");
    static STRUCT_IF_C aSf_BFu15i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu15i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu15i_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu15i_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu15i_BFu0s, aSf_BFu15i_BFu0s)
//============================================================================



static void Test_aSf_BFu15ll_BFu0c()
{
  {
    init_simple_test("aSf_BFu15ll_BFu0c");
    static STRUCT_IF_C aSf_BFu15ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu15ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu15ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu15ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu15ll_BFu0c, aSf_BFu15ll_BFu0c)
//============================================================================



static void Test_aSf_BFu15ll_BFu0i()
{
  {
    init_simple_test("aSf_BFu15ll_BFu0i");
    static STRUCT_IF_C aSf_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu15ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu15ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu15ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu15ll_BFu0i, aSf_BFu15ll_BFu0i)
//============================================================================



static void Test_aSf_BFu15ll_BFu0ll()
{
  {
    init_simple_test("aSf_BFu15ll_BFu0ll");
    static STRUCT_IF_C aSf_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu15ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu15ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu15ll_BFu0ll, aSf_BFu15ll_BFu0ll)
//============================================================================



static void Test_aSf_BFu15ll_BFu0s()
{
  {
    init_simple_test("aSf_BFu15ll_BFu0s");
    static STRUCT_IF_C aSf_BFu15ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu15ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu15ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu15ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu15ll_BFu0s, aSf_BFu15ll_BFu0s)
//============================================================================



static void Test_aSf_BFu15s_BFu0c()
{
  {
    init_simple_test("aSf_BFu15s_BFu0c");
    static STRUCT_IF_C aSf_BFu15s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu15s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu15s_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu15s_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu15s_BFu0c, aSf_BFu15s_BFu0c)
//============================================================================



static void Test_aSf_BFu15s_BFu0i()
{
  {
    init_simple_test("aSf_BFu15s_BFu0i");
    static STRUCT_IF_C aSf_BFu15s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu15s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu15s_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu15s_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu15s_BFu0i, aSf_BFu15s_BFu0i)
//============================================================================



static void Test_aSf_BFu15s_BFu0ll()
{
  {
    init_simple_test("aSf_BFu15s_BFu0ll");
    static STRUCT_IF_C aSf_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu15s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu15s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu15s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu15s_BFu0ll, aSf_BFu15s_BFu0ll)
//============================================================================



static void Test_aSf_BFu15s_BFu0s()
{
  {
    init_simple_test("aSf_BFu15s_BFu0s");
    static STRUCT_IF_C aSf_BFu15s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu15s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu15s_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu15s_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "aSf_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "aSf_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu15s_BFu0s, aSf_BFu15s_BFu0s)
//============================================================================



static void Test_aSf_BFu16i_BFu0c()
{
  {
    init_simple_test("aSf_BFu16i_BFu0c");
    static STRUCT_IF_C aSf_BFu16i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu16i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu16i_BFu0c, aSf_BFu16i_BFu0c)
//============================================================================



static void Test_aSf_BFu16i_BFu0i()
{
  {
    init_simple_test("aSf_BFu16i_BFu0i");
    static STRUCT_IF_C aSf_BFu16i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu16i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu16i_BFu0i, aSf_BFu16i_BFu0i)
//============================================================================



static void Test_aSf_BFu16i_BFu0ll()
{
  {
    init_simple_test("aSf_BFu16i_BFu0ll");
    static STRUCT_IF_C aSf_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu16i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu16i_BFu0ll, aSf_BFu16i_BFu0ll)
//============================================================================



static void Test_aSf_BFu16i_BFu0s()
{
  {
    init_simple_test("aSf_BFu16i_BFu0s");
    static STRUCT_IF_C aSf_BFu16i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu16i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16i_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16i_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu16i_BFu0s, aSf_BFu16i_BFu0s)
//============================================================================



static void Test_aSf_BFu16ll_BFu0c()
{
  {
    init_simple_test("aSf_BFu16ll_BFu0c");
    static STRUCT_IF_C aSf_BFu16ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu16ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu16ll_BFu0c, aSf_BFu16ll_BFu0c)
//============================================================================



static void Test_aSf_BFu16ll_BFu0i()
{
  {
    init_simple_test("aSf_BFu16ll_BFu0i");
    static STRUCT_IF_C aSf_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu16ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu16ll_BFu0i, aSf_BFu16ll_BFu0i)
//============================================================================



static void Test_aSf_BFu16ll_BFu0ll()
{
  {
    init_simple_test("aSf_BFu16ll_BFu0ll");
    static STRUCT_IF_C aSf_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu16ll_BFu0ll, aSf_BFu16ll_BFu0ll)
//============================================================================



static void Test_aSf_BFu16ll_BFu0s()
{
  {
    init_simple_test("aSf_BFu16ll_BFu0s");
    static STRUCT_IF_C aSf_BFu16ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu16ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu16ll_BFu0s, aSf_BFu16ll_BFu0s)
//============================================================================



static void Test_aSf_BFu16s_BFu0c()
{
  {
    init_simple_test("aSf_BFu16s_BFu0c");
    static STRUCT_IF_C aSf_BFu16s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu16s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu16s_BFu0c, aSf_BFu16s_BFu0c)
//============================================================================



static void Test_aSf_BFu16s_BFu0i()
{
  {
    init_simple_test("aSf_BFu16s_BFu0i");
    static STRUCT_IF_C aSf_BFu16s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu16s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu16s_BFu0i, aSf_BFu16s_BFu0i)
//============================================================================



static void Test_aSf_BFu16s_BFu0ll()
{
  {
    init_simple_test("aSf_BFu16s_BFu0ll");
    static STRUCT_IF_C aSf_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu16s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu16s_BFu0ll, aSf_BFu16s_BFu0ll)
//============================================================================



static void Test_aSf_BFu16s_BFu0s()
{
  {
    init_simple_test("aSf_BFu16s_BFu0s");
    static STRUCT_IF_C aSf_BFu16s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu16s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu16s_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu16s_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "aSf_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "aSf_BFu16s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu16s_BFu0s, aSf_BFu16s_BFu0s)
//============================================================================



static void Test_aSf_BFu17i_BFu0c()
{
  {
    init_simple_test("aSf_BFu17i_BFu0c");
    static STRUCT_IF_C aSf_BFu17i_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu17i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu17i_BFu0c, aSf_BFu17i_BFu0c)
//============================================================================



static void Test_aSf_BFu17i_BFu0i()
{
  {
    init_simple_test("aSf_BFu17i_BFu0i");
    static STRUCT_IF_C aSf_BFu17i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu17i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu17i_BFu0i, aSf_BFu17i_BFu0i)
//============================================================================



static void Test_aSf_BFu17i_BFu0ll()
{
  {
    init_simple_test("aSf_BFu17i_BFu0ll");
    static STRUCT_IF_C aSf_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu17i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu17i_BFu0ll, aSf_BFu17i_BFu0ll)
//============================================================================



static void Test_aSf_BFu17i_BFu0s()
{
  {
    init_simple_test("aSf_BFu17i_BFu0s");
    static STRUCT_IF_C aSf_BFu17i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu17i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17i_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17i_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu17i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu17i_BFu0s, aSf_BFu17i_BFu0s)
//============================================================================



static void Test_aSf_BFu17ll_BFu0c()
{
  {
    init_simple_test("aSf_BFu17ll_BFu0c");
    static STRUCT_IF_C aSf_BFu17ll_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(aSf_BFu17ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu17ll_BFu0c, aSf_BFu17ll_BFu0c)
//============================================================================



static void Test_aSf_BFu17ll_BFu0i()
{
  {
    init_simple_test("aSf_BFu17ll_BFu0i");
    static STRUCT_IF_C aSf_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu17ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu17ll_BFu0i, aSf_BFu17ll_BFu0i)
//============================================================================



static void Test_aSf_BFu17ll_BFu0ll()
{
  {
    init_simple_test("aSf_BFu17ll_BFu0ll");
    static STRUCT_IF_C aSf_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu17ll_BFu0ll, aSf_BFu17ll_BFu0ll)
//============================================================================



static void Test_aSf_BFu17ll_BFu0s()
{
  {
    init_simple_test("aSf_BFu17ll_BFu0s");
    static STRUCT_IF_C aSf_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu17ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu17ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu17ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "aSf_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "aSf_BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu17ll_BFu0s, aSf_BFu17ll_BFu0s)
//============================================================================



static void Test_aSf_BFu1c_BFu0c()
{
  {
    init_simple_test("aSf_BFu1c_BFu0c");
    static STRUCT_IF_C aSf_BFu1c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu1c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1c_BFu0c, aSf_BFu1c_BFu0c)
//============================================================================



static void Test_aSf_BFu1c_BFu0i()
{
  {
    init_simple_test("aSf_BFu1c_BFu0i");
    static STRUCT_IF_C aSf_BFu1c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu1c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1c_BFu0i, aSf_BFu1c_BFu0i)
//============================================================================



static void Test_aSf_BFu1c_BFu0ll()
{
  {
    init_simple_test("aSf_BFu1c_BFu0ll");
    static STRUCT_IF_C aSf_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu1c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1c_BFu0ll, aSf_BFu1c_BFu0ll)
//============================================================================



static void Test_aSf_BFu1c_BFu0s()
{
  {
    init_simple_test("aSf_BFu1c_BFu0s");
    static STRUCT_IF_C aSf_BFu1c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_BFu1c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1c_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1c_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1c_BFu0s, aSf_BFu1c_BFu0s)
//============================================================================



static void Test_aSf_BFu1i_BFu0c()
{
  {
    init_simple_test("aSf_BFu1i_BFu0c");
    static STRUCT_IF_C aSf_BFu1i_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu1i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1i_BFu0c, aSf_BFu1i_BFu0c)
//============================================================================



static void Test_aSf_BFu1i_BFu0i()
{
  {
    init_simple_test("aSf_BFu1i_BFu0i");
    static STRUCT_IF_C aSf_BFu1i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu1i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1i_BFu0i, aSf_BFu1i_BFu0i)
//============================================================================



static void Test_aSf_BFu1i_BFu0ll()
{
  {
    init_simple_test("aSf_BFu1i_BFu0ll");
    static STRUCT_IF_C aSf_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu1i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1i_BFu0ll, aSf_BFu1i_BFu0ll)
//============================================================================



static void Test_aSf_BFu1i_BFu0s()
{
  {
    init_simple_test("aSf_BFu1i_BFu0s");
    static STRUCT_IF_C aSf_BFu1i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_BFu1i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1i_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1i_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1i_BFu0s, aSf_BFu1i_BFu0s)
//============================================================================



static void Test_aSf_BFu1ll_BFu0c()
{
  {
    init_simple_test("aSf_BFu1ll_BFu0c");
    static STRUCT_IF_C aSf_BFu1ll_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu1ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1ll_BFu0c, aSf_BFu1ll_BFu0c)
//============================================================================



static void Test_aSf_BFu1ll_BFu0i()
{
  {
    init_simple_test("aSf_BFu1ll_BFu0i");
    static STRUCT_IF_C aSf_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu1ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1ll_BFu0i, aSf_BFu1ll_BFu0i)
//============================================================================



static void Test_aSf_BFu1ll_BFu0ll()
{
  {
    init_simple_test("aSf_BFu1ll_BFu0ll");
    static STRUCT_IF_C aSf_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1ll_BFu0ll, aSf_BFu1ll_BFu0ll)
//============================================================================



static void Test_aSf_BFu1ll_BFu0s()
{
  {
    init_simple_test("aSf_BFu1ll_BFu0s");
    static STRUCT_IF_C aSf_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_BFu1ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1ll_BFu0s, aSf_BFu1ll_BFu0s)
//============================================================================



static void Test_aSf_BFu1s_BFu0c()
{
  {
    init_simple_test("aSf_BFu1s_BFu0c");
    static STRUCT_IF_C aSf_BFu1s_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu1s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1s_BFu0c, aSf_BFu1s_BFu0c)
//============================================================================



static void Test_aSf_BFu1s_BFu0i()
{
  {
    init_simple_test("aSf_BFu1s_BFu0i");
    static STRUCT_IF_C aSf_BFu1s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu1s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1s_BFu0i, aSf_BFu1s_BFu0i)
//============================================================================



static void Test_aSf_BFu1s_BFu0ll()
{
  {
    init_simple_test("aSf_BFu1s_BFu0ll");
    static STRUCT_IF_C aSf_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu1s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1s_BFu0ll, aSf_BFu1s_BFu0ll)
//============================================================================



static void Test_aSf_BFu1s_BFu0s()
{
  {
    init_simple_test("aSf_BFu1s_BFu0s");
    static STRUCT_IF_C aSf_BFu1s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_BFu1s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu1s_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu1s_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "aSf_BFu1s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu1s_BFu0s, aSf_BFu1s_BFu0s)
//============================================================================



static void Test_aSf_BFu31i_BFu0c()
{
  {
    init_simple_test("aSf_BFu31i_BFu0c");
    static STRUCT_IF_C aSf_BFu31i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu31i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu31i_BFu0c, aSf_BFu31i_BFu0c)
//============================================================================



static void Test_aSf_BFu31i_BFu0i()
{
  {
    init_simple_test("aSf_BFu31i_BFu0i");
    static STRUCT_IF_C aSf_BFu31i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu31i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu31i_BFu0i, aSf_BFu31i_BFu0i)
//============================================================================



static void Test_aSf_BFu31i_BFu0ll()
{
  {
    init_simple_test("aSf_BFu31i_BFu0ll");
    static STRUCT_IF_C aSf_BFu31i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu31i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu31i_BFu0ll, aSf_BFu31i_BFu0ll)
//============================================================================



static void Test_aSf_BFu31i_BFu0s()
{
  {
    init_simple_test("aSf_BFu31i_BFu0s");
    static STRUCT_IF_C aSf_BFu31i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu31i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31i_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31i_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu31i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu31i_BFu0s, aSf_BFu31i_BFu0s)
//============================================================================



static void Test_aSf_BFu31ll_BFu0c()
{
  {
    init_simple_test("aSf_BFu31ll_BFu0c");
    static STRUCT_IF_C aSf_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu31ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu31ll_BFu0c, aSf_BFu31ll_BFu0c)
//============================================================================



static void Test_aSf_BFu31ll_BFu0i()
{
  {
    init_simple_test("aSf_BFu31ll_BFu0i");
    static STRUCT_IF_C aSf_BFu31ll_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu31ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu31ll_BFu0i, aSf_BFu31ll_BFu0i)
//============================================================================



static void Test_aSf_BFu31ll_BFu0ll()
{
  {
    init_simple_test("aSf_BFu31ll_BFu0ll");
    static STRUCT_IF_C aSf_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu31ll_BFu0ll, aSf_BFu31ll_BFu0ll)
//============================================================================



static void Test_aSf_BFu31ll_BFu0s()
{
  {
    init_simple_test("aSf_BFu31ll_BFu0s");
    static STRUCT_IF_C aSf_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu31ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu31ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu31ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "aSf_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "aSf_BFu31ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu31ll_BFu0s, aSf_BFu31ll_BFu0s)
//============================================================================



static void Test_aSf_BFu32i_BFu0c()
{
  {
    init_simple_test("aSf_BFu32i_BFu0c");
    static STRUCT_IF_C aSf_BFu32i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu32i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu32i_BFu0c, aSf_BFu32i_BFu0c)
//============================================================================



static void Test_aSf_BFu32i_BFu0i()
{
  {
    init_simple_test("aSf_BFu32i_BFu0i");
    static STRUCT_IF_C aSf_BFu32i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu32i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu32i_BFu0i, aSf_BFu32i_BFu0i)
//============================================================================



static void Test_aSf_BFu32i_BFu0ll()
{
  {
    init_simple_test("aSf_BFu32i_BFu0ll");
    static STRUCT_IF_C aSf_BFu32i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu32i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu32i_BFu0ll, aSf_BFu32i_BFu0ll)
//============================================================================



static void Test_aSf_BFu32i_BFu0s()
{
  {
    init_simple_test("aSf_BFu32i_BFu0s");
    static STRUCT_IF_C aSf_BFu32i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu32i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32i_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32i_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu32i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu32i_BFu0s, aSf_BFu32i_BFu0s)
//============================================================================



static void Test_aSf_BFu32ll_BFu0c()
{
  {
    init_simple_test("aSf_BFu32ll_BFu0c");
    static STRUCT_IF_C aSf_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu32ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu32ll_BFu0c, aSf_BFu32ll_BFu0c)
//============================================================================



static void Test_aSf_BFu32ll_BFu0i()
{
  {
    init_simple_test("aSf_BFu32ll_BFu0i");
    static STRUCT_IF_C aSf_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu32ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu32ll_BFu0i, aSf_BFu32ll_BFu0i)
//============================================================================



static void Test_aSf_BFu32ll_BFu0ll()
{
  {
    init_simple_test("aSf_BFu32ll_BFu0ll");
    static STRUCT_IF_C aSf_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu32ll_BFu0ll, aSf_BFu32ll_BFu0ll)
//============================================================================



static void Test_aSf_BFu32ll_BFu0s()
{
  {
    init_simple_test("aSf_BFu32ll_BFu0s");
    static STRUCT_IF_C aSf_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_BFu32ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu32ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu32ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "aSf_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "aSf_BFu32ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu32ll_BFu0s, aSf_BFu32ll_BFu0s)
//============================================================================



static void Test_aSf_BFu33_BFu0c()
{
  {
    init_simple_test("aSf_BFu33_BFu0c");
    static STRUCT_IF_C aSf_BFu33_BFu0c lv;
    check2(sizeof(lv), 5, "sizeof(aSf_BFu33_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "aSf_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu33_BFu0c, aSf_BFu33_BFu0c)
//============================================================================



static void Test_aSf_BFu33_BFu0i()
{
  {
    init_simple_test("aSf_BFu33_BFu0i");
    static STRUCT_IF_C aSf_BFu33_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aSf_BFu33_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "aSf_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu33_BFu0i, aSf_BFu33_BFu0i)
//============================================================================



static void Test_aSf_BFu33_BFu0ll()
{
  {
    init_simple_test("aSf_BFu33_BFu0ll");
    static STRUCT_IF_C aSf_BFu33_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,8), "sizeof(aSf_BFu33_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "aSf_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu33_BFu0ll, aSf_BFu33_BFu0ll)
//============================================================================



static void Test_aSf_BFu33_BFu0s()
{
  {
    init_simple_test("aSf_BFu33_BFu0s");
    static STRUCT_IF_C aSf_BFu33_BFu0s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(aSf_BFu33_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu33_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu33_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "aSf_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "aSf_BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu33_BFu0s, aSf_BFu33_BFu0s)
//============================================================================



static void Test_aSf_BFu7c_BFu0c()
{
  {
    init_simple_test("aSf_BFu7c_BFu0c");
    static STRUCT_IF_C aSf_BFu7c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu7c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7c_BFu0c, aSf_BFu7c_BFu0c)
//============================================================================



static void Test_aSf_BFu7c_BFu0i()
{
  {
    init_simple_test("aSf_BFu7c_BFu0i");
    static STRUCT_IF_C aSf_BFu7c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu7c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7c_BFu0i, aSf_BFu7c_BFu0i)
//============================================================================



static void Test_aSf_BFu7c_BFu0ll()
{
  {
    init_simple_test("aSf_BFu7c_BFu0ll");
    static STRUCT_IF_C aSf_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu7c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7c_BFu0ll, aSf_BFu7c_BFu0ll)
//============================================================================



static void Test_aSf_BFu7c_BFu0s()
{
  {
    init_simple_test("aSf_BFu7c_BFu0s");
    static STRUCT_IF_C aSf_BFu7c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_BFu7c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7c_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7c_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7c_BFu0s, aSf_BFu7c_BFu0s)
//============================================================================



static void Test_aSf_BFu7i_BFu0c()
{
  {
    init_simple_test("aSf_BFu7i_BFu0c");
    static STRUCT_IF_C aSf_BFu7i_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu7i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7i_BFu0c, aSf_BFu7i_BFu0c)
//============================================================================



static void Test_aSf_BFu7i_BFu0i()
{
  {
    init_simple_test("aSf_BFu7i_BFu0i");
    static STRUCT_IF_C aSf_BFu7i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu7i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7i_BFu0i, aSf_BFu7i_BFu0i)
//============================================================================



static void Test_aSf_BFu7i_BFu0ll()
{
  {
    init_simple_test("aSf_BFu7i_BFu0ll");
    static STRUCT_IF_C aSf_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu7i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7i_BFu0ll, aSf_BFu7i_BFu0ll)
//============================================================================



static void Test_aSf_BFu7i_BFu0s()
{
  {
    init_simple_test("aSf_BFu7i_BFu0s");
    static STRUCT_IF_C aSf_BFu7i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_BFu7i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7i_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7i_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7i_BFu0s, aSf_BFu7i_BFu0s)
//============================================================================



static void Test_aSf_BFu7ll_BFu0c()
{
  {
    init_simple_test("aSf_BFu7ll_BFu0c");
    static STRUCT_IF_C aSf_BFu7ll_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu7ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7ll_BFu0c, aSf_BFu7ll_BFu0c)
//============================================================================



static void Test_aSf_BFu7ll_BFu0i()
{
  {
    init_simple_test("aSf_BFu7ll_BFu0i");
    static STRUCT_IF_C aSf_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu7ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7ll_BFu0i, aSf_BFu7ll_BFu0i)
//============================================================================



static void Test_aSf_BFu7ll_BFu0ll()
{
  {
    init_simple_test("aSf_BFu7ll_BFu0ll");
    static STRUCT_IF_C aSf_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7ll_BFu0ll, aSf_BFu7ll_BFu0ll)
//============================================================================



static void Test_aSf_BFu7ll_BFu0s()
{
  {
    init_simple_test("aSf_BFu7ll_BFu0s");
    static STRUCT_IF_C aSf_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_BFu7ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7ll_BFu0s, aSf_BFu7ll_BFu0s)
//============================================================================



static void Test_aSf_BFu7s_BFu0c()
{
  {
    init_simple_test("aSf_BFu7s_BFu0c");
    static STRUCT_IF_C aSf_BFu7s_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu7s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7s_BFu0c, aSf_BFu7s_BFu0c)
//============================================================================



static void Test_aSf_BFu7s_BFu0i()
{
  {
    init_simple_test("aSf_BFu7s_BFu0i");
    static STRUCT_IF_C aSf_BFu7s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu7s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7s_BFu0i, aSf_BFu7s_BFu0i)
//============================================================================



static void Test_aSf_BFu7s_BFu0ll()
{
  {
    init_simple_test("aSf_BFu7s_BFu0ll");
    static STRUCT_IF_C aSf_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu7s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7s_BFu0ll, aSf_BFu7s_BFu0ll)
//============================================================================



static void Test_aSf_BFu7s_BFu0s()
{
  {
    init_simple_test("aSf_BFu7s_BFu0s");
    static STRUCT_IF_C aSf_BFu7s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_BFu7s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu7s_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu7s_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "aSf_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "aSf_BFu7s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu7s_BFu0s, aSf_BFu7s_BFu0s)
//============================================================================



static void Test_aSf_BFu8c_BFu0c()
{
  {
    init_simple_test("aSf_BFu8c_BFu0c");
    static STRUCT_IF_C aSf_BFu8c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu8c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8c_BFu0c, aSf_BFu8c_BFu0c)
//============================================================================



static void Test_aSf_BFu8c_BFu0i()
{
  {
    init_simple_test("aSf_BFu8c_BFu0i");
    static STRUCT_IF_C aSf_BFu8c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu8c_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8c_BFu0i, aSf_BFu8c_BFu0i)
//============================================================================



static void Test_aSf_BFu8c_BFu0ll()
{
  {
    init_simple_test("aSf_BFu8c_BFu0ll");
    static STRUCT_IF_C aSf_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu8c_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8c_BFu0ll, aSf_BFu8c_BFu0ll)
//============================================================================



static void Test_aSf_BFu8c_BFu0s()
{
  {
    init_simple_test("aSf_BFu8c_BFu0s");
    static STRUCT_IF_C aSf_BFu8c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_BFu8c_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8c_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8c_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8c_BFu0s, aSf_BFu8c_BFu0s)
//============================================================================



static void Test_aSf_BFu8i_BFu0c()
{
  {
    init_simple_test("aSf_BFu8i_BFu0c");
    static STRUCT_IF_C aSf_BFu8i_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu8i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8i_BFu0c, aSf_BFu8i_BFu0c)
//============================================================================



static void Test_aSf_BFu8i_BFu0i()
{
  {
    init_simple_test("aSf_BFu8i_BFu0i");
    static STRUCT_IF_C aSf_BFu8i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu8i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8i_BFu0i, aSf_BFu8i_BFu0i)
//============================================================================



static void Test_aSf_BFu8i_BFu0ll()
{
  {
    init_simple_test("aSf_BFu8i_BFu0ll");
    static STRUCT_IF_C aSf_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu8i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8i_BFu0ll, aSf_BFu8i_BFu0ll)
//============================================================================



static void Test_aSf_BFu8i_BFu0s()
{
  {
    init_simple_test("aSf_BFu8i_BFu0s");
    static STRUCT_IF_C aSf_BFu8i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_BFu8i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8i_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8i_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8i_BFu0s, aSf_BFu8i_BFu0s)
//============================================================================



static void Test_aSf_BFu8ll_BFu0c()
{
  {
    init_simple_test("aSf_BFu8ll_BFu0c");
    static STRUCT_IF_C aSf_BFu8ll_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu8ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8ll_BFu0c, aSf_BFu8ll_BFu0c)
//============================================================================



static void Test_aSf_BFu8ll_BFu0i()
{
  {
    init_simple_test("aSf_BFu8ll_BFu0i");
    static STRUCT_IF_C aSf_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu8ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8ll_BFu0i, aSf_BFu8ll_BFu0i)
//============================================================================



static void Test_aSf_BFu8ll_BFu0ll()
{
  {
    init_simple_test("aSf_BFu8ll_BFu0ll");
    static STRUCT_IF_C aSf_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8ll_BFu0ll, aSf_BFu8ll_BFu0ll)
//============================================================================



static void Test_aSf_BFu8ll_BFu0s()
{
  {
    init_simple_test("aSf_BFu8ll_BFu0s");
    static STRUCT_IF_C aSf_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_BFu8ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8ll_BFu0s, aSf_BFu8ll_BFu0s)
//============================================================================



static void Test_aSf_BFu8s_BFu0c()
{
  {
    init_simple_test("aSf_BFu8s_BFu0c");
    static STRUCT_IF_C aSf_BFu8s_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_BFu8s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8s_BFu0c, aSf_BFu8s_BFu0c)
//============================================================================



static void Test_aSf_BFu8s_BFu0i()
{
  {
    init_simple_test("aSf_BFu8s_BFu0i");
    static STRUCT_IF_C aSf_BFu8s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu8s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8s_BFu0i, aSf_BFu8s_BFu0i)
//============================================================================



static void Test_aSf_BFu8s_BFu0ll()
{
  {
    init_simple_test("aSf_BFu8s_BFu0ll");
    static STRUCT_IF_C aSf_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu8s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8s_BFu0ll, aSf_BFu8s_BFu0ll)
//============================================================================



static void Test_aSf_BFu8s_BFu0s()
{
  {
    init_simple_test("aSf_BFu8s_BFu0s");
    static STRUCT_IF_C aSf_BFu8s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_BFu8s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu8s_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu8s_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "aSf_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "aSf_BFu8s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu8s_BFu0s, aSf_BFu8s_BFu0s)
//============================================================================



static void Test_aSf_BFu9i_BFu0c()
{
  {
    init_simple_test("aSf_BFu9i_BFu0c");
    static STRUCT_IF_C aSf_BFu9i_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu9i_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu9i_BFu0c, aSf_BFu9i_BFu0c)
//============================================================================



static void Test_aSf_BFu9i_BFu0i()
{
  {
    init_simple_test("aSf_BFu9i_BFu0i");
    static STRUCT_IF_C aSf_BFu9i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu9i_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu9i_BFu0i, aSf_BFu9i_BFu0i)
//============================================================================



static void Test_aSf_BFu9i_BFu0ll()
{
  {
    init_simple_test("aSf_BFu9i_BFu0ll");
    static STRUCT_IF_C aSf_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu9i_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu9i_BFu0ll, aSf_BFu9i_BFu0ll)
//============================================================================



static void Test_aSf_BFu9i_BFu0s()
{
  {
    init_simple_test("aSf_BFu9i_BFu0s");
    static STRUCT_IF_C aSf_BFu9i_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu9i_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9i_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu9i_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu9i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu9i_BFu0s, aSf_BFu9i_BFu0s)
//============================================================================



static void Test_aSf_BFu9ll_BFu0c()
{
  {
    init_simple_test("aSf_BFu9ll_BFu0c");
    static STRUCT_IF_C aSf_BFu9ll_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu9ll_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9ll_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu9ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu9ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu9ll_BFu0c, aSf_BFu9ll_BFu0c)
//============================================================================



static void Test_aSf_BFu9ll_BFu0i()
{
  {
    init_simple_test("aSf_BFu9ll_BFu0i");
    static STRUCT_IF_C aSf_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu9ll_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9ll_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu9ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu9ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu9ll_BFu0i, aSf_BFu9ll_BFu0i)
//============================================================================



static void Test_aSf_BFu9ll_BFu0ll()
{
  {
    init_simple_test("aSf_BFu9ll_BFu0ll");
    static STRUCT_IF_C aSf_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu9ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu9ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu9ll_BFu0ll, aSf_BFu9ll_BFu0ll)
//============================================================================



static void Test_aSf_BFu9ll_BFu0s()
{
  {
    init_simple_test("aSf_BFu9ll_BFu0s");
    static STRUCT_IF_C aSf_BFu9ll_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu9ll_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9ll_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu9ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu9ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu9ll_BFu0s, aSf_BFu9ll_BFu0s)
//============================================================================



static void Test_aSf_BFu9s_BFu0c()
{
  {
    init_simple_test("aSf_BFu9s_BFu0c");
    static STRUCT_IF_C aSf_BFu9s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu9s_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9s_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_BFu9s_BFu0c.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu9s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu9s_BFu0c, aSf_BFu9s_BFu0c)
//============================================================================



static void Test_aSf_BFu9s_BFu0i()
{
  {
    init_simple_test("aSf_BFu9s_BFu0i");
    static STRUCT_IF_C aSf_BFu9s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_BFu9s_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9s_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_BFu9s_BFu0i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu9s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu9s_BFu0i, aSf_BFu9s_BFu0i)
//============================================================================



static void Test_aSf_BFu9s_BFu0ll()
{
  {
    init_simple_test("aSf_BFu9s_BFu0ll");
    static STRUCT_IF_C aSf_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_BFu9s_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9s_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_BFu9s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu9s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu9s_BFu0ll, aSf_BFu9s_BFu0ll)
//============================================================================



static void Test_aSf_BFu9s_BFu0s()
{
  {
    init_simple_test("aSf_BFu9s_BFu0s");
    static STRUCT_IF_C aSf_BFu9s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_BFu9s_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_BFu9s_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_BFu9s_BFu0s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "aSf_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "aSf_BFu9s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_BFu9s_BFu0s, aSf_BFu9s_BFu0s)
//============================================================================



static void Test_aSf_C_BFu0c()
{
  {
    init_simple_test("aSf_C_BFu0c");
    static STRUCT_IF_C aSf_C_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_C_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_C_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_C_BFu0c.v1");
    check_field_offset(lv, v2, 0, "aSf_C_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_C_BFu0c, aSf_C_BFu0c)
//============================================================================



static void Test_aSf_C_BFu0i()
{
  {
    init_simple_test("aSf_C_BFu0i");
    static STRUCT_IF_C aSf_C_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_C_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_C_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_C_BFu0i.v1");
    check_field_offset(lv, v2, 0, "aSf_C_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_C_BFu0i, aSf_C_BFu0i)
//============================================================================



static void Test_aSf_C_BFu0ll()
{
  {
    init_simple_test("aSf_C_BFu0ll");
    static STRUCT_IF_C aSf_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_C_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_C_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_C_BFu0ll.v1");
    check_field_offset(lv, v2, 0, "aSf_C_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_C_BFu0ll, aSf_C_BFu0ll)
//============================================================================



static void Test_aSf_C_BFu0s()
{
  {
    init_simple_test("aSf_C_BFu0s");
    static STRUCT_IF_C aSf_C_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_C_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_C_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_C_BFu0s.v1");
    check_field_offset(lv, v2, 0, "aSf_C_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_C_BFu0s, aSf_C_BFu0s)
//============================================================================



static void Test_aSf_D_BFu0c()
{
  {
    init_simple_test("aSf_D_BFu0c");
    static STRUCT_IF_C aSf_D_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aSf_D_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_D_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_D_BFu0c.v1");
    check_field_offset(lv, v2, 0, "aSf_D_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_D_BFu0c, aSf_D_BFu0c)
//============================================================================



static void Test_aSf_D_BFu0i()
{
  {
    init_simple_test("aSf_D_BFu0i");
    static STRUCT_IF_C aSf_D_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aSf_D_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_D_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_D_BFu0i.v1");
    check_field_offset(lv, v2, 0, "aSf_D_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_D_BFu0i, aSf_D_BFu0i)
//============================================================================



static void Test_aSf_D_BFu0ll()
{
  {
    init_simple_test("aSf_D_BFu0ll");
    static STRUCT_IF_C aSf_D_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aSf_D_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_D_BFu0ll.v1");
    check_field_offset(lv, v2, 0, "aSf_D_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_D_BFu0ll, aSf_D_BFu0ll)
//============================================================================



static void Test_aSf_D_BFu0s()
{
  {
    init_simple_test("aSf_D_BFu0s");
    static STRUCT_IF_C aSf_D_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aSf_D_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_D_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_D_BFu0s.v1");
    check_field_offset(lv, v2, 0, "aSf_D_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_D_BFu0s, aSf_D_BFu0s)
//============================================================================



static void Test_aSf_F_BFu0c()
{
  {
    init_simple_test("aSf_F_BFu0c");
    static STRUCT_IF_C aSf_F_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_F_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_F_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_F_BFu0c.v1");
    check_field_offset(lv, v2, 0, "aSf_F_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_F_BFu0c, aSf_F_BFu0c)
//============================================================================



static void Test_aSf_F_BFu0i()
{
  {
    init_simple_test("aSf_F_BFu0i");
    static STRUCT_IF_C aSf_F_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_F_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_F_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_F_BFu0i.v1");
    check_field_offset(lv, v2, 0, "aSf_F_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_F_BFu0i, aSf_F_BFu0i)
//============================================================================



static void Test_aSf_F_BFu0ll()
{
  {
    init_simple_test("aSf_F_BFu0ll");
    static STRUCT_IF_C aSf_F_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_F_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_F_BFu0ll.v1");
    check_field_offset(lv, v2, 0, "aSf_F_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_F_BFu0ll, aSf_F_BFu0ll)
//============================================================================



static void Test_aSf_F_BFu0s()
{
  {
    init_simple_test("aSf_F_BFu0s");
    static STRUCT_IF_C aSf_F_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_F_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_F_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_F_BFu0s.v1");
    check_field_offset(lv, v2, 0, "aSf_F_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_F_BFu0s, aSf_F_BFu0s)
//============================================================================



static void Test_aSf_I_BFu0c()
{
  {
    init_simple_test("aSf_I_BFu0c");
    static STRUCT_IF_C aSf_I_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_I_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_I_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_I_BFu0c.v1");
    check_field_offset(lv, v2, 0, "aSf_I_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_I_BFu0c, aSf_I_BFu0c)
//============================================================================



static void Test_aSf_I_BFu0i()
{
  {
    init_simple_test("aSf_I_BFu0i");
    static STRUCT_IF_C aSf_I_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_I_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_I_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_I_BFu0i.v1");
    check_field_offset(lv, v2, 0, "aSf_I_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_I_BFu0i, aSf_I_BFu0i)
//============================================================================



static void Test_aSf_I_BFu0ll()
{
  {
    init_simple_test("aSf_I_BFu0ll");
    static STRUCT_IF_C aSf_I_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_I_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_I_BFu0ll.v1");
    check_field_offset(lv, v2, 0, "aSf_I_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_I_BFu0ll, aSf_I_BFu0ll)
//============================================================================



static void Test_aSf_I_BFu0s()
{
  {
    init_simple_test("aSf_I_BFu0s");
    static STRUCT_IF_C aSf_I_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_I_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_I_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_I_BFu0s.v1");
    check_field_offset(lv, v2, 0, "aSf_I_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_I_BFu0s, aSf_I_BFu0s)
//============================================================================



static void Test_aSf_Ip_BFu0c()
{
  {
    init_simple_test("aSf_Ip_BFu0c");
    static STRUCT_IF_C aSf_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_Ip_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_Ip_BFu0c.v1");
    check_field_offset(lv, v2, 0, "aSf_Ip_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Ip_BFu0c, aSf_Ip_BFu0c)
//============================================================================



static void Test_aSf_Ip_BFu0i()
{
  {
    init_simple_test("aSf_Ip_BFu0i");
    static STRUCT_IF_C aSf_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_Ip_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_Ip_BFu0i.v1");
    check_field_offset(lv, v2, 0, "aSf_Ip_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Ip_BFu0i, aSf_Ip_BFu0i)
//============================================================================



static void Test_aSf_Ip_BFu0ll()
{
  {
    init_simple_test("aSf_Ip_BFu0ll");
    static STRUCT_IF_C aSf_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_Ip_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Ip_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_Ip_BFu0ll.v1");
    check_field_offset(lv, v2, 0, "aSf_Ip_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Ip_BFu0ll, aSf_Ip_BFu0ll)
//============================================================================



static void Test_aSf_Ip_BFu0s()
{
  {
    init_simple_test("aSf_Ip_BFu0s");
    static STRUCT_IF_C aSf_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_Ip_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Ip_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_Ip_BFu0s.v1");
    check_field_offset(lv, v2, 0, "aSf_Ip_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Ip_BFu0s, aSf_Ip_BFu0s)
//============================================================================



static void Test_aSf_L_BFu0c()
{
  {
    init_simple_test("aSf_L_BFu0c");
    static STRUCT_IF_C aSf_L_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aSf_L_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_L_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_L_BFu0c.v1");
    check_field_offset(lv, v2, 0, "aSf_L_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_L_BFu0c, aSf_L_BFu0c)
//============================================================================



static void Test_aSf_L_BFu0i()
{
  {
    init_simple_test("aSf_L_BFu0i");
    static STRUCT_IF_C aSf_L_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aSf_L_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_L_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_L_BFu0i.v1");
    check_field_offset(lv, v2, 0, "aSf_L_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_L_BFu0i, aSf_L_BFu0i)
//============================================================================



static void Test_aSf_L_BFu0ll()
{
  {
    init_simple_test("aSf_L_BFu0ll");
    static STRUCT_IF_C aSf_L_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aSf_L_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_L_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_L_BFu0ll.v1");
    check_field_offset(lv, v2, 0, "aSf_L_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_L_BFu0ll, aSf_L_BFu0ll)
//============================================================================



static void Test_aSf_L_BFu0s()
{
  {
    init_simple_test("aSf_L_BFu0s");
    static STRUCT_IF_C aSf_L_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aSf_L_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_L_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_L_BFu0s.v1");
    check_field_offset(lv, v2, 0, "aSf_L_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_L_BFu0s, aSf_L_BFu0s)
//============================================================================



static void Test_aSf_S_BFu0c()
{
  {
    init_simple_test("aSf_S_BFu0c");
    static STRUCT_IF_C aSf_S_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_S_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_S_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_S_BFu0c.v1");
    check_field_offset(lv, v2, 0, "aSf_S_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_S_BFu0c, aSf_S_BFu0c)
//============================================================================



static void Test_aSf_S_BFu0i()
{
  {
    init_simple_test("aSf_S_BFu0i");
    static STRUCT_IF_C aSf_S_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_S_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_S_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_S_BFu0i.v1");
    check_field_offset(lv, v2, 0, "aSf_S_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_S_BFu0i, aSf_S_BFu0i)
//============================================================================



static void Test_aSf_S_BFu0ll()
{
  {
    init_simple_test("aSf_S_BFu0ll");
    static STRUCT_IF_C aSf_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_S_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_S_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_S_BFu0ll.v1");
    check_field_offset(lv, v2, 0, "aSf_S_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_S_BFu0ll, aSf_S_BFu0ll)
//============================================================================



static void Test_aSf_S_BFu0s()
{
  {
    init_simple_test("aSf_S_BFu0s");
    static STRUCT_IF_C aSf_S_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_S_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_S_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_S_BFu0s.v1");
    check_field_offset(lv, v2, 0, "aSf_S_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_S_BFu0s, aSf_S_BFu0s)
//============================================================================



static void Test_aSf_Sf_BFu0c()
{
  {
    init_simple_test("aSf_Sf_BFu0c");
    static STRUCT_IF_C aSf_Sf_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(aSf_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_Sf_BFu0c.v1");
    check_field_offset(lv, v2, 0, "aSf_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Sf_BFu0c, aSf_Sf_BFu0c)
//============================================================================



static void Test_aSf_Sf_BFu0i()
{
  {
    init_simple_test("aSf_Sf_BFu0i");
    static STRUCT_IF_C aSf_Sf_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(aSf_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_Sf_BFu0i.v1");
    check_field_offset(lv, v2, 0, "aSf_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Sf_BFu0i, aSf_Sf_BFu0i)
//============================================================================



static void Test_aSf_Sf_BFu0ll()
{
  {
    init_simple_test("aSf_Sf_BFu0ll");
    static STRUCT_IF_C aSf_Sf_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(aSf_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_Sf_BFu0ll.v1");
    check_field_offset(lv, v2, 0, "aSf_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Sf_BFu0ll, aSf_Sf_BFu0ll)
//============================================================================



static void Test_aSf_Sf_BFu0s()
{
  {
    init_simple_test("aSf_Sf_BFu0s");
    static STRUCT_IF_C aSf_Sf_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(aSf_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_Sf_BFu0s.v1");
    check_field_offset(lv, v2, 0, "aSf_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Sf_BFu0s, aSf_Sf_BFu0s)
//============================================================================



static void Test_aSf_Uc_BFu0c()
{
  {
    init_simple_test("aSf_Uc_BFu0c");
    static STRUCT_IF_C aSf_Uc_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aSf_Uc_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Uc_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_Uc_BFu0c.v1");
    check_field_offset(lv, v2, 0, "aSf_Uc_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Uc_BFu0c, aSf_Uc_BFu0c)
//============================================================================



static void Test_aSf_Uc_BFu0i()
{
  {
    init_simple_test("aSf_Uc_BFu0i");
    static STRUCT_IF_C aSf_Uc_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_Uc_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Uc_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_Uc_BFu0i.v1");
    check_field_offset(lv, v2, 0, "aSf_Uc_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Uc_BFu0i, aSf_Uc_BFu0i)
//============================================================================



static void Test_aSf_Uc_BFu0ll()
{
  {
    init_simple_test("aSf_Uc_BFu0ll");
    static STRUCT_IF_C aSf_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_Uc_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Uc_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_Uc_BFu0ll.v1");
    check_field_offset(lv, v2, 0, "aSf_Uc_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Uc_BFu0ll, aSf_Uc_BFu0ll)
//============================================================================



static void Test_aSf_Uc_BFu0s()
{
  {
    init_simple_test("aSf_Uc_BFu0s");
    static STRUCT_IF_C aSf_Uc_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aSf_Uc_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Uc_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_Uc_BFu0s.v1");
    check_field_offset(lv, v2, 0, "aSf_Uc_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Uc_BFu0s, aSf_Uc_BFu0s)
//============================================================================



static void Test_aSf_Ui_BFu0c()
{
  {
    init_simple_test("aSf_Ui_BFu0c");
    static STRUCT_IF_C aSf_Ui_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aSf_Ui_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Ui_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_Ui_BFu0c.v1");
    check_field_offset(lv, v2, 0, "aSf_Ui_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Ui_BFu0c, aSf_Ui_BFu0c)
//============================================================================



static void Test_aSf_Ui_BFu0i()
{
  {
    init_simple_test("aSf_Ui_BFu0i");
    static STRUCT_IF_C aSf_Ui_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aSf_Ui_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Ui_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_Ui_BFu0i.v1");
    check_field_offset(lv, v2, 0, "aSf_Ui_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Ui_BFu0i, aSf_Ui_BFu0i)
//============================================================================



static void Test_aSf_Ui_BFu0ll()
{
  {
    init_simple_test("aSf_Ui_BFu0ll");
    static STRUCT_IF_C aSf_Ui_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_Ui_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Ui_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_Ui_BFu0ll.v1");
    check_field_offset(lv, v2, 0, "aSf_Ui_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Ui_BFu0ll, aSf_Ui_BFu0ll)
//============================================================================



static void Test_aSf_Ui_BFu0s()
{
  {
    init_simple_test("aSf_Ui_BFu0s");
    static STRUCT_IF_C aSf_Ui_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aSf_Ui_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Ui_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_Ui_BFu0s.v1");
    check_field_offset(lv, v2, 0, "aSf_Ui_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Ui_BFu0s, aSf_Ui_BFu0s)
//============================================================================



static void Test_aSf_Ul_BFu0c()
{
  {
    init_simple_test("aSf_Ul_BFu0c");
    static STRUCT_IF_C aSf_Ul_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aSf_Ul_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Ul_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_Ul_BFu0c.v1");
    check_field_offset(lv, v2, 0, "aSf_Ul_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Ul_BFu0c, aSf_Ul_BFu0c)
//============================================================================



static void Test_aSf_Ul_BFu0i()
{
  {
    init_simple_test("aSf_Ul_BFu0i");
    static STRUCT_IF_C aSf_Ul_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aSf_Ul_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Ul_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_Ul_BFu0i.v1");
    check_field_offset(lv, v2, 0, "aSf_Ul_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Ul_BFu0i, aSf_Ul_BFu0i)
//============================================================================



static void Test_aSf_Ul_BFu0ll()
{
  {
    init_simple_test("aSf_Ul_BFu0ll");
    static STRUCT_IF_C aSf_Ul_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aSf_Ul_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Ul_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_Ul_BFu0ll.v1");
    check_field_offset(lv, v2, 0, "aSf_Ul_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Ul_BFu0ll, aSf_Ul_BFu0ll)
//============================================================================



static void Test_aSf_Ul_BFu0s()
{
  {
    init_simple_test("aSf_Ul_BFu0s");
    static STRUCT_IF_C aSf_Ul_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aSf_Ul_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Ul_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_Ul_BFu0s.v1");
    check_field_offset(lv, v2, 0, "aSf_Ul_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Ul_BFu0s, aSf_Ul_BFu0s)
//============================================================================



static void Test_aSf_Us_BFu0c()
{
  {
    init_simple_test("aSf_Us_BFu0c");
    static STRUCT_IF_C aSf_Us_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aSf_Us_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Us_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_Us_BFu0c.v1");
    check_field_offset(lv, v2, 0, "aSf_Us_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Us_BFu0c, aSf_Us_BFu0c)
//============================================================================



static void Test_aSf_Us_BFu0i()
{
  {
    init_simple_test("aSf_Us_BFu0i");
    static STRUCT_IF_C aSf_Us_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aSf_Us_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Us_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_Us_BFu0i.v1");
    check_field_offset(lv, v2, 0, "aSf_Us_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Us_BFu0i, aSf_Us_BFu0i)
//============================================================================



static void Test_aSf_Us_BFu0ll()
{
  {
    init_simple_test("aSf_Us_BFu0ll");
    static STRUCT_IF_C aSf_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_Us_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Us_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_Us_BFu0ll.v1");
    check_field_offset(lv, v2, 0, "aSf_Us_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Us_BFu0ll, aSf_Us_BFu0ll)
//============================================================================



static void Test_aSf_Us_BFu0s()
{
  {
    init_simple_test("aSf_Us_BFu0s");
    static STRUCT_IF_C aSf_Us_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aSf_Us_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Us_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_Us_BFu0s.v1");
    check_field_offset(lv, v2, 0, "aSf_Us_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Us_BFu0s, aSf_Us_BFu0s)
//============================================================================



static void Test_aSf_Vp_BFu0c()
{
  {
    init_simple_test("aSf_Vp_BFu0c");
    static STRUCT_IF_C aSf_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_Vp_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Vp_BFu0c)");
    check_field_offset(lv, v1, 0, "aSf_Vp_BFu0c.v1");
    check_field_offset(lv, v2, 0, "aSf_Vp_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Vp_BFu0c, aSf_Vp_BFu0c)
//============================================================================



static void Test_aSf_Vp_BFu0i()
{
  {
    init_simple_test("aSf_Vp_BFu0i");
    static STRUCT_IF_C aSf_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_Vp_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Vp_BFu0i)");
    check_field_offset(lv, v1, 0, "aSf_Vp_BFu0i.v1");
    check_field_offset(lv, v2, 0, "aSf_Vp_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Vp_BFu0i, aSf_Vp_BFu0i)
//============================================================================



static void Test_aSf_Vp_BFu0ll()
{
  {
    init_simple_test("aSf_Vp_BFu0ll");
    static STRUCT_IF_C aSf_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_Vp_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Vp_BFu0ll)");
    check_field_offset(lv, v1, 0, "aSf_Vp_BFu0ll.v1");
    check_field_offset(lv, v2, 0, "aSf_Vp_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Vp_BFu0ll, aSf_Vp_BFu0ll)
//============================================================================



static void Test_aSf_Vp_BFu0s()
{
  {
    init_simple_test("aSf_Vp_BFu0s");
    static STRUCT_IF_C aSf_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aSf_Vp_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aSf_Vp_BFu0s)");
    check_field_offset(lv, v1, 0, "aSf_Vp_BFu0s.v1");
    check_field_offset(lv, v2, 0, "aSf_Vp_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aSf_Vp_BFu0s, aSf_Vp_BFu0s)
//============================================================================



static void Test_aUc_BFu0c_Sf()
{
  {
    init_simple_test("aUc_BFu0c_Sf");
    static STRUCT_IF_C aUc_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aUc_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aUc_BFu0c_Sf.v1");
    check_field_offset(lv, v2, 1, "aUc_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_BFu0c_Sf, aUc_BFu0c_Sf)
//============================================================================



static void Test_aUc_BFu0i_Sf()
{
  {
    init_simple_test("aUc_BFu0i_Sf");
    static STRUCT_IF_C aUc_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aUc_BFu0i_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUc_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_BFu0i_Sf, aUc_BFu0i_Sf)
//============================================================================



static void Test_aUc_BFu0ll_Sf()
{
  {
    init_simple_test("aUc_BFu0ll_Sf");
    static STRUCT_IF_C aUc_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aUc_BFu0ll_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUc_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_BFu0ll_Sf, aUc_BFu0ll_Sf)
//============================================================================



static void Test_aUc_BFu0s_Sf()
{
  {
    init_simple_test("aUc_BFu0s_Sf");
    static STRUCT_IF_C aUc_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aUc_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aUc_BFu0s_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(2,2), "aUc_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_BFu0s_Sf, aUc_BFu0s_Sf)
//============================================================================



static void Test_aUc_Sf_BFu0c()
{
  {
    init_simple_test("aUc_Sf_BFu0c");
    static STRUCT_IF_C aUc_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(aUc_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aUc_Sf_BFu0c.v1");
    check_field_offset(lv, v2, 1, "aUc_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Sf_BFu0c, aUc_Sf_BFu0c)
//============================================================================



static void Test_aUc_Sf_BFu0i()
{
  {
    init_simple_test("aUc_Sf_BFu0i");
    static STRUCT_IF_C aUc_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUc_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aUc_Sf_BFu0i.v1");
    check_field_offset(lv, v2, 1, "aUc_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Sf_BFu0i, aUc_Sf_BFu0i)
//============================================================================



static void Test_aUc_Sf_BFu0ll()
{
  {
    init_simple_test("aUc_Sf_BFu0ll");
    static STRUCT_IF_C aUc_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUc_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUc_Sf_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Sf_BFu0ll, aUc_Sf_BFu0ll)
//============================================================================



static void Test_aUc_Sf_BFu0s()
{
  {
    init_simple_test("aUc_Sf_BFu0s");
    static STRUCT_IF_C aUc_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(aUc_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aUc_Sf_BFu0s.v1");
    check_field_offset(lv, v2, 1, "aUc_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Sf_BFu0s, aUc_Sf_BFu0s)
//============================================================================



static void Test_aUi_BFu0c_Sf()
{
  {
    init_simple_test("aUi_BFu0c_Sf");
    static STRUCT_IF_C aUi_BFu0c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aUi_BFu0c_Sf.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu0c_Sf, aUi_BFu0c_Sf)
//============================================================================



static void Test_aUi_BFu0i_Sf()
{
  {
    init_simple_test("aUi_BFu0i_Sf");
    static STRUCT_IF_C aUi_BFu0i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aUi_BFu0i_Sf.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu0i_Sf, aUi_BFu0i_Sf)
//============================================================================



static void Test_aUi_BFu0ll_Sf()
{
  {
    init_simple_test("aUi_BFu0ll_Sf");
    static STRUCT_IF_C aUi_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUi_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aUi_BFu0ll_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUi_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu0ll_Sf, aUi_BFu0ll_Sf)
//============================================================================



static void Test_aUi_BFu0s_Sf()
{
  {
    init_simple_test("aUi_BFu0s_Sf");
    static STRUCT_IF_C aUi_BFu0s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aUi_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aUi_BFu0s_Sf.v1");
    check_field_offset(lv, v2, 4, "aUi_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu0s_Sf, aUi_BFu0s_Sf)
//============================================================================



static void Test_aUi_Sf_BFu0c()
{
  {
    init_simple_test("aUi_Sf_BFu0c");
    static STRUCT_IF_C aUi_Sf_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(aUi_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aUi_Sf_BFu0c.v1");
    check_field_offset(lv, v2, 4, "aUi_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_Sf_BFu0c, aUi_Sf_BFu0c)
//============================================================================



static void Test_aUi_Sf_BFu0i()
{
  {
    init_simple_test("aUi_Sf_BFu0i");
    static STRUCT_IF_C aUi_Sf_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(aUi_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aUi_Sf_BFu0i.v1");
    check_field_offset(lv, v2, 4, "aUi_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_Sf_BFu0i, aUi_Sf_BFu0i)
//============================================================================



static void Test_aUi_Sf_BFu0ll()
{
  {
    init_simple_test("aUi_Sf_BFu0ll");
    static STRUCT_IF_C aUi_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUi_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUi_Sf_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "aUi_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_Sf_BFu0ll, aUi_Sf_BFu0ll)
//============================================================================



static void Test_aUi_Sf_BFu0s()
{
  {
    init_simple_test("aUi_Sf_BFu0s");
    static STRUCT_IF_C aUi_Sf_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(aUi_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aUi_Sf_BFu0s.v1");
    check_field_offset(lv, v2, 4, "aUi_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_Sf_BFu0s, aUi_Sf_BFu0s)
//============================================================================



static void Test_aUl_BFu0c_Sf()
{
  {
    init_simple_test("aUl_BFu0c_Sf");
    static STRUCT_IF_C aUl_BFu0c_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aUl_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aUl_BFu0c_Sf.v1");
    check_field_offset(lv, v2, 8, "aUl_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu0c_Sf, aUl_BFu0c_Sf)
//============================================================================



static void Test_aUl_BFu0i_Sf()
{
  {
    init_simple_test("aUl_BFu0i_Sf");
    static STRUCT_IF_C aUl_BFu0i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aUl_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aUl_BFu0i_Sf.v1");
    check_field_offset(lv, v2, 8, "aUl_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu0i_Sf, aUl_BFu0i_Sf)
//============================================================================



static void Test_aUl_BFu0ll_Sf()
{
  {
    init_simple_test("aUl_BFu0ll_Sf");
    static STRUCT_IF_C aUl_BFu0ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aUl_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aUl_BFu0ll_Sf.v1");
    check_field_offset(lv, v2, 8, "aUl_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu0ll_Sf, aUl_BFu0ll_Sf)
//============================================================================



static void Test_aUl_BFu0s_Sf()
{
  {
    init_simple_test("aUl_BFu0s_Sf");
    static STRUCT_IF_C aUl_BFu0s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aUl_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aUl_BFu0s_Sf.v1");
    check_field_offset(lv, v2, 8, "aUl_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu0s_Sf, aUl_BFu0s_Sf)
//============================================================================



static void Test_aUl_Sf_BFu0c()
{
  {
    init_simple_test("aUl_Sf_BFu0c");
    static STRUCT_IF_C aUl_Sf_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(aUl_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aUl_Sf_BFu0c.v1");
    check_field_offset(lv, v2, 8, "aUl_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Sf_BFu0c, aUl_Sf_BFu0c)
//============================================================================



static void Test_aUl_Sf_BFu0i()
{
  {
    init_simple_test("aUl_Sf_BFu0i");
    static STRUCT_IF_C aUl_Sf_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(aUl_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aUl_Sf_BFu0i.v1");
    check_field_offset(lv, v2, 8, "aUl_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Sf_BFu0i, aUl_Sf_BFu0i)
//============================================================================



static void Test_aUl_Sf_BFu0ll()
{
  {
    init_simple_test("aUl_Sf_BFu0ll");
    static STRUCT_IF_C aUl_Sf_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(aUl_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUl_Sf_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Sf_BFu0ll, aUl_Sf_BFu0ll)
//============================================================================



static void Test_aUl_Sf_BFu0s()
{
  {
    init_simple_test("aUl_Sf_BFu0s");
    static STRUCT_IF_C aUl_Sf_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(aUl_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aUl_Sf_BFu0s.v1");
    check_field_offset(lv, v2, 8, "aUl_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Sf_BFu0s, aUl_Sf_BFu0s)
//============================================================================



static void Test_aUs_BFu0c_Sf()
{
  {
    init_simple_test("aUs_BFu0c_Sf");
    static STRUCT_IF_C aUs_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aUs_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aUs_BFu0c_Sf.v1");
    check_field_offset(lv, v2, 2, "aUs_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu0c_Sf, aUs_BFu0c_Sf)
//============================================================================



static void Test_aUs_BFu0i_Sf()
{
  {
    init_simple_test("aUs_BFu0i_Sf");
    static STRUCT_IF_C aUs_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUs_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aUs_BFu0i_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(4,4), "aUs_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu0i_Sf, aUs_BFu0i_Sf)
//============================================================================



static void Test_aUs_BFu0ll_Sf()
{
  {
    init_simple_test("aUs_BFu0ll_Sf");
    static STRUCT_IF_C aUs_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUs_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aUs_BFu0ll_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aUs_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu0ll_Sf, aUs_BFu0ll_Sf)
//============================================================================



static void Test_aUs_BFu0s_Sf()
{
  {
    init_simple_test("aUs_BFu0s_Sf");
    static STRUCT_IF_C aUs_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aUs_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aUs_BFu0s_Sf.v1");
    check_field_offset(lv, v2, 2, "aUs_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu0s_Sf, aUs_BFu0s_Sf)
//============================================================================



static void Test_aUs_Sf_BFu0c()
{
  {
    init_simple_test("aUs_Sf_BFu0c");
    static STRUCT_IF_C aUs_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(aUs_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aUs_Sf_BFu0c.v1");
    check_field_offset(lv, v2, 2, "aUs_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_Sf_BFu0c, aUs_Sf_BFu0c)
//============================================================================



static void Test_aUs_Sf_BFu0i()
{
  {
    init_simple_test("aUs_Sf_BFu0i");
    static STRUCT_IF_C aUs_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(aUs_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aUs_Sf_BFu0i.v1");
    check_field_offset(lv, v2, 2, "aUs_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_Sf_BFu0i, aUs_Sf_BFu0i)
//============================================================================



static void Test_aUs_Sf_BFu0ll()
{
  {
    init_simple_test("aUs_Sf_BFu0ll");
    static STRUCT_IF_C aUs_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aUs_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aUs_Sf_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "aUs_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_Sf_BFu0ll, aUs_Sf_BFu0ll)
//============================================================================



static void Test_aUs_Sf_BFu0s()
{
  {
    init_simple_test("aUs_Sf_BFu0s");
    static STRUCT_IF_C aUs_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(aUs_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aUs_Sf_BFu0s.v1");
    check_field_offset(lv, v2, 2, "aUs_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_Sf_BFu0s, aUs_Sf_BFu0s)
//============================================================================



static void Test_aVp_BFu0c_Sf()
{
  {
    init_simple_test("aVp_BFu0c_Sf");
    static STRUCT_IF_C aVp_BFu0c_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aVp_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "aVp_BFu0c_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu0c_Sf, aVp_BFu0c_Sf)
//============================================================================



static void Test_aVp_BFu0i_Sf()
{
  {
    init_simple_test("aVp_BFu0i_Sf");
    static STRUCT_IF_C aVp_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aVp_BFu0i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "aVp_BFu0i_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu0i_Sf, aVp_BFu0i_Sf)
//============================================================================



static void Test_aVp_BFu0ll_Sf()
{
  {
    init_simple_test("aVp_BFu0ll_Sf");
    static STRUCT_IF_C aVp_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aVp_BFu0ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "aVp_BFu0ll_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu0ll_Sf, aVp_BFu0ll_Sf)
//============================================================================



static void Test_aVp_BFu0s_Sf()
{
  {
    init_simple_test("aVp_BFu0s_Sf");
    static STRUCT_IF_C aVp_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aVp_BFu0s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "aVp_BFu0s_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu0s_Sf, aVp_BFu0s_Sf)
//============================================================================



static void Test_aVp_Sf_BFu0c()
{
  {
    init_simple_test("aVp_Sf_BFu0c");
    static STRUCT_IF_C aVp_Sf_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aVp_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "aVp_Sf_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Sf_BFu0c, aVp_Sf_BFu0c)
//============================================================================



static void Test_aVp_Sf_BFu0i()
{
  {
    init_simple_test("aVp_Sf_BFu0i");
    static STRUCT_IF_C aVp_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aVp_Sf_BFu0i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "aVp_Sf_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Sf_BFu0i, aVp_Sf_BFu0i)
//============================================================================



static void Test_aVp_Sf_BFu0ll()
{
  {
    init_simple_test("aVp_Sf_BFu0ll");
    static STRUCT_IF_C aVp_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aVp_Sf_BFu0ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "aVp_Sf_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Sf_BFu0ll, aVp_Sf_BFu0ll)
//============================================================================



static void Test_aVp_Sf_BFu0s()
{
  {
    init_simple_test("aVp_Sf_BFu0s");
    static STRUCT_IF_C aVp_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(aVp_Sf_BFu0s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "aVp_Sf_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Sf_BFu0s, aVp_Sf_BFu0s)
//============================================================================



static void Test_BFu0c_BFu0c_Sf()
{
  {
    init_simple_test("BFu0c_BFu0c_Sf");
    static STRUCT_IF_C BFu0c_BFu0c_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0c_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0c_Sf, BFu0c_BFu0c_Sf)
//============================================================================



static void Test_BFu0c_BFu0i_Sf()
{
  {
    init_simple_test("BFu0c_BFu0i_Sf");
    static STRUCT_IF_C BFu0c_BFu0i_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0i_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0i_Sf, BFu0c_BFu0i_Sf)
//============================================================================



static void Test_BFu0c_BFu0ll_Sf()
{
  {
    init_simple_test("BFu0c_BFu0ll_Sf");
    static STRUCT_IF_C BFu0c_BFu0ll_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0ll_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0ll_Sf, BFu0c_BFu0ll_Sf)
//============================================================================



static void Test_BFu0c_BFu0s_Sf()
{
  {
    init_simple_test("BFu0c_BFu0s_Sf");
    static STRUCT_IF_C BFu0c_BFu0s_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0s_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_Sf, BFu0c_BFu0s_Sf)
//============================================================================



static void Test_BFu0c_BFu15i_Sf()
{
  {
    init_simple_test("BFu0c_BFu15i_Sf");
    static STRUCT_IF_C BFu0c_BFu15i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_Sf");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_Sf, BFu0c_BFu15i_Sf)
//============================================================================



static void Test_BFu0c_BFu15ll_Sf()
{
  {
    init_simple_test("BFu0c_BFu15ll_Sf");
    static STRUCT_IF_C BFu0c_BFu15ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_Sf");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_Sf, BFu0c_BFu15ll_Sf)
//============================================================================



static void Test_BFu0c_BFu15s_Sf()
{
  {
    init_simple_test("BFu0c_BFu15s_Sf");
    static STRUCT_IF_C BFu0c_BFu15s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_Sf");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_Sf, BFu0c_BFu15s_Sf)
//============================================================================



static void Test_BFu0c_BFu16i_Sf()
{
  {
    init_simple_test("BFu0c_BFu16i_Sf");
    static STRUCT_IF_C BFu0c_BFu16i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_Sf");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_Sf, BFu0c_BFu16i_Sf)
//============================================================================



static void Test_BFu0c_BFu16ll_Sf()
{
  {
    init_simple_test("BFu0c_BFu16ll_Sf");
    static STRUCT_IF_C BFu0c_BFu16ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_Sf");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_Sf, BFu0c_BFu16ll_Sf)
//============================================================================



static void Test_BFu0c_BFu16s_Sf()
{
  {
    init_simple_test("BFu0c_BFu16s_Sf");
    static STRUCT_IF_C BFu0c_BFu16s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_Sf");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_Sf, BFu0c_BFu16s_Sf)
//============================================================================



static void Test_BFu0c_BFu17i_Sf()
{
  {
    init_simple_test("BFu0c_BFu17i_Sf");
    static STRUCT_IF_C BFu0c_BFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_Sf");
    check_field_offset(lv, v2, 3, "BFu0c_BFu17i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_Sf, BFu0c_BFu17i_Sf)
//============================================================================



static void Test_BFu0c_BFu17ll_Sf()
{
  {
    init_simple_test("BFu0c_BFu17ll_Sf");
    static STRUCT_IF_C BFu0c_BFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_Sf");
    check_field_offset(lv, v2, 3, "BFu0c_BFu17ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_Sf, BFu0c_BFu17ll_Sf)
//============================================================================



static void Test_BFu0c_BFu1c_Sf()
{
  {
    init_simple_test("BFu0c_BFu1c_Sf");
    static STRUCT_IF_C BFu0c_BFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_Sf");
    check_field_offset(lv, v2, 1, "BFu0c_BFu1c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_Sf, BFu0c_BFu1c_Sf)
//============================================================================



static void Test_BFu0c_BFu1i_Sf()
{
  {
    init_simple_test("BFu0c_BFu1i_Sf");
    static STRUCT_IF_C BFu0c_BFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_Sf");
    check_field_offset(lv, v2, 1, "BFu0c_BFu1i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_Sf, BFu0c_BFu1i_Sf)
//============================================================================



static void Test_BFu0c_BFu1ll_Sf()
{
  {
    init_simple_test("BFu0c_BFu1ll_Sf");
    static STRUCT_IF_C BFu0c_BFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_Sf");
    check_field_offset(lv, v2, 1, "BFu0c_BFu1ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_Sf, BFu0c_BFu1ll_Sf)
//============================================================================



static void Test_BFu0c_BFu1s_Sf()
{
  {
    init_simple_test("BFu0c_BFu1s_Sf");
    static STRUCT_IF_C BFu0c_BFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_Sf");
    check_field_offset(lv, v2, 1, "BFu0c_BFu1s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_Sf, BFu0c_BFu1s_Sf)
//============================================================================



static void Test_BFu0c_BFu31i_Sf()
{
  {
    init_simple_test("BFu0c_BFu31i_Sf");
    static STRUCT_IF_C BFu0c_BFu31i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_Sf");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_Sf, BFu0c_BFu31i_Sf)
//============================================================================



static void Test_BFu0c_BFu31ll_Sf()
{
  {
    init_simple_test("BFu0c_BFu31ll_Sf");
    static STRUCT_IF_C BFu0c_BFu31ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_Sf");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_Sf, BFu0c_BFu31ll_Sf)
//============================================================================



static void Test_BFu0c_BFu32i_Sf()
{
  {
    init_simple_test("BFu0c_BFu32i_Sf");
    static STRUCT_IF_C BFu0c_BFu32i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_Sf");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_Sf, BFu0c_BFu32i_Sf)
//============================================================================



static void Test_BFu0c_BFu32ll_Sf()
{
  {
    init_simple_test("BFu0c_BFu32ll_Sf");
    static STRUCT_IF_C BFu0c_BFu32ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_Sf");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_Sf, BFu0c_BFu32ll_Sf)
//============================================================================



static void Test_BFu0c_BFu33_Sf()
{
  {
    init_simple_test("BFu0c_BFu33_Sf");
    static STRUCT_IF_C BFu0c_BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_Sf");
    check_field_offset(lv, v2, 5, "BFu0c_BFu33_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_Sf, BFu0c_BFu33_Sf)
//============================================================================



static void Test_BFu0c_BFu7c_Sf()
{
  {
    init_simple_test("BFu0c_BFu7c_Sf");
    static STRUCT_IF_C BFu0c_BFu7c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_Sf");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_Sf, BFu0c_BFu7c_Sf)
//============================================================================



static void Test_BFu0c_BFu7i_Sf()
{
  {
    init_simple_test("BFu0c_BFu7i_Sf");
    static STRUCT_IF_C BFu0c_BFu7i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_Sf");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_Sf, BFu0c_BFu7i_Sf)
//============================================================================



static void Test_BFu0c_BFu7ll_Sf()
{
  {
    init_simple_test("BFu0c_BFu7ll_Sf");
    static STRUCT_IF_C BFu0c_BFu7ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_Sf");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_Sf, BFu0c_BFu7ll_Sf)
//============================================================================



static void Test_BFu0c_BFu7s_Sf()
{
  {
    init_simple_test("BFu0c_BFu7s_Sf");
    static STRUCT_IF_C BFu0c_BFu7s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_Sf");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_Sf, BFu0c_BFu7s_Sf)
//============================================================================



static void Test_BFu0c_BFu8c_Sf()
{
  {
    init_simple_test("BFu0c_BFu8c_Sf");
    static STRUCT_IF_C BFu0c_BFu8c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_Sf");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_Sf, BFu0c_BFu8c_Sf)
//============================================================================



static void Test_BFu0c_BFu8i_Sf()
{
  {
    init_simple_test("BFu0c_BFu8i_Sf");
    static STRUCT_IF_C BFu0c_BFu8i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_Sf");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_Sf, BFu0c_BFu8i_Sf)
//============================================================================



static void Test_BFu0c_BFu8ll_Sf()
{
  {
    init_simple_test("BFu0c_BFu8ll_Sf");
    static STRUCT_IF_C BFu0c_BFu8ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_Sf");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_Sf, BFu0c_BFu8ll_Sf)
//============================================================================



static void Test_BFu0c_BFu8s_Sf()
{
  {
    init_simple_test("BFu0c_BFu8s_Sf");
    static STRUCT_IF_C BFu0c_BFu8s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_Sf");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_Sf, BFu0c_BFu8s_Sf)
//============================================================================



static void Test_BFu0c_BFu9i_Sf()
{
  {
    init_simple_test("BFu0c_BFu9i_Sf");
    static STRUCT_IF_C BFu0c_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_Sf");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_Sf, BFu0c_BFu9i_Sf)
//============================================================================



static void Test_BFu0c_BFu9ll_Sf()
{
  {
    init_simple_test("BFu0c_BFu9ll_Sf");
    static STRUCT_IF_C BFu0c_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_Sf");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_Sf, BFu0c_BFu9ll_Sf)
//============================================================================



static void Test_BFu0c_BFu9s_Sf()
{
  {
    init_simple_test("BFu0c_BFu9s_Sf");
    static STRUCT_IF_C BFu0c_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9s_Sf");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9s_Sf, BFu0c_BFu9s_Sf)
//============================================================================



static void Test_BFu0c_C_Sf()
{
  {
    init_simple_test("BFu0c_C_Sf");
    static STRUCT_IF_C BFu0c_C_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_C_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_C_Sf.v1");
    check_field_offset(lv, v2, 1, "BFu0c_C_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_C_Sf, BFu0c_C_Sf)
//============================================================================



static void Test_BFu0c_D_Sf()
{
  {
    init_simple_test("BFu0c_D_Sf");
    static STRUCT_IF_C BFu0c_D_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_D_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_D_Sf.v1");
    check_field_offset(lv, v2, 8, "BFu0c_D_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_D_Sf, BFu0c_D_Sf)
//============================================================================



static void Test_BFu0c_F_Sf()
{
  {
    init_simple_test("BFu0c_F_Sf");
    static STRUCT_IF_C BFu0c_F_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_F_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_F_Sf.v1");
    check_field_offset(lv, v2, 4, "BFu0c_F_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_F_Sf, BFu0c_F_Sf)
//============================================================================



static void Test_BFu0c_I_Sf()
{
  {
    init_simple_test("BFu0c_I_Sf");
    static STRUCT_IF_C BFu0c_I_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_I_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_I_Sf.v1");
    check_field_offset(lv, v2, 4, "BFu0c_I_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_I_Sf, BFu0c_I_Sf)
//============================================================================



static void Test_BFu0c_Ip_Sf()
{
  {
    init_simple_test("BFu0c_Ip_Sf");
    static STRUCT_IF_C BFu0c_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ip_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_Ip_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Ip_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Ip_Sf, BFu0c_Ip_Sf)
//============================================================================



static void Test_BFu0c_L_Sf()
{
  {
    init_simple_test("BFu0c_L_Sf");
    static STRUCT_IF_C BFu0c_L_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_L_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_L_Sf.v1");
    check_field_offset(lv, v2, 8, "BFu0c_L_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_L_Sf, BFu0c_L_Sf)
//============================================================================



static void Test_BFu0c_S_Sf()
{
  {
    init_simple_test("BFu0c_S_Sf");
    static STRUCT_IF_C BFu0c_S_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_S_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_S_Sf.v1");
    check_field_offset(lv, v2, 2, "BFu0c_S_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_S_Sf, BFu0c_S_Sf)
//============================================================================



static void Test_BFu0c_Sf()
{
  {
    init_simple_test("BFu0c_Sf");
    static STRUCT_IF_C BFu0c_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf, BFu0c_Sf)
//============================================================================



static void Test_BFu0c_Sf_BFu0c()
{
  {
    init_simple_test("BFu0c_Sf_BFu0c");
    static STRUCT_IF_C BFu0c_Sf_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu0c, BFu0c_Sf_BFu0c)
//============================================================================



static void Test_BFu0c_Sf_BFu0i()
{
  {
    init_simple_test("BFu0c_Sf_BFu0i");
    static STRUCT_IF_C BFu0c_Sf_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu0i, BFu0c_Sf_BFu0i)
//============================================================================



static void Test_BFu0c_Sf_BFu0ll()
{
  {
    init_simple_test("BFu0c_Sf_BFu0ll");
    static STRUCT_IF_C BFu0c_Sf_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu0ll, BFu0c_Sf_BFu0ll)
//============================================================================



static void Test_BFu0c_Sf_BFu0s()
{
  {
    init_simple_test("BFu0c_Sf_BFu0s");
    static STRUCT_IF_C BFu0c_Sf_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu0s, BFu0c_Sf_BFu0s)
//============================================================================



static void Test_BFu0c_Sf_BFu15i()
{
  {
    init_simple_test("BFu0c_Sf_BFu15i");
    static STRUCT_IF_C BFu0c_Sf_BFu15i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu15i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "BFu0c_Sf_BFu15i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu15i, BFu0c_Sf_BFu15i)
//============================================================================



static void Test_BFu0c_Sf_BFu15ll()
{
  {
    init_simple_test("BFu0c_Sf_BFu15ll");
    static STRUCT_IF_C BFu0c_Sf_BFu15ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu15ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "BFu0c_Sf_BFu15ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu15ll, BFu0c_Sf_BFu15ll)
//============================================================================



static void Test_BFu0c_Sf_BFu15s()
{
  {
    init_simple_test("BFu0c_Sf_BFu15s");
    static STRUCT_IF_C BFu0c_Sf_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu15s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "BFu0c_Sf_BFu15s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu15s, BFu0c_Sf_BFu15s)
//============================================================================



static void Test_BFu0c_Sf_BFu16i()
{
  {
    init_simple_test("BFu0c_Sf_BFu16i");
    static STRUCT_IF_C BFu0c_Sf_BFu16i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu16i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "BFu0c_Sf_BFu16i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu16i, BFu0c_Sf_BFu16i)
//============================================================================



static void Test_BFu0c_Sf_BFu16ll()
{
  {
    init_simple_test("BFu0c_Sf_BFu16ll");
    static STRUCT_IF_C BFu0c_Sf_BFu16ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu16ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "BFu0c_Sf_BFu16ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu16ll, BFu0c_Sf_BFu16ll)
//============================================================================



static void Test_BFu0c_Sf_BFu16s()
{
  {
    init_simple_test("BFu0c_Sf_BFu16s");
    static STRUCT_IF_C BFu0c_Sf_BFu16s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu16s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "BFu0c_Sf_BFu16s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu16s, BFu0c_Sf_BFu16s)
//============================================================================



static void Test_BFu0c_Sf_BFu17i()
{
  {
    init_simple_test("BFu0c_Sf_BFu17i");
    static STRUCT_IF_C BFu0c_Sf_BFu17i lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu17i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "BFu0c_Sf_BFu17i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu17i, BFu0c_Sf_BFu17i)
//============================================================================



static void Test_BFu0c_Sf_BFu17ll()
{
  {
    init_simple_test("BFu0c_Sf_BFu17ll");
    static STRUCT_IF_C BFu0c_Sf_BFu17ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu0c_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu17ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "BFu0c_Sf_BFu17ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu17ll, BFu0c_Sf_BFu17ll)
//============================================================================



static void Test_BFu0c_Sf_BFu1c()
{
  {
    init_simple_test("BFu0c_Sf_BFu1c");
    static STRUCT_IF_C BFu0c_Sf_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu1c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0c_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu1c, BFu0c_Sf_BFu1c)
//============================================================================



static void Test_BFu0c_Sf_BFu1i()
{
  {
    init_simple_test("BFu0c_Sf_BFu1i");
    static STRUCT_IF_C BFu0c_Sf_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu1i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0c_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu1i, BFu0c_Sf_BFu1i)
//============================================================================



static void Test_BFu0c_Sf_BFu1ll()
{
  {
    init_simple_test("BFu0c_Sf_BFu1ll");
    static STRUCT_IF_C BFu0c_Sf_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu1ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0c_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu1ll, BFu0c_Sf_BFu1ll)
//============================================================================



static void Test_BFu0c_Sf_BFu1s()
{
  {
    init_simple_test("BFu0c_Sf_BFu1s");
    static STRUCT_IF_C BFu0c_Sf_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu1s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0c_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu1s, BFu0c_Sf_BFu1s)
//============================================================================



static void Test_BFu0c_Sf_BFu31i()
{
  {
    init_simple_test("BFu0c_Sf_BFu31i");
    static STRUCT_IF_C BFu0c_Sf_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu31i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "BFu0c_Sf_BFu31i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu31i, BFu0c_Sf_BFu31i)
//============================================================================



static void Test_BFu0c_Sf_BFu31ll()
{
  {
    init_simple_test("BFu0c_Sf_BFu31ll");
    static STRUCT_IF_C BFu0c_Sf_BFu31ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu31ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "BFu0c_Sf_BFu31ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu31ll, BFu0c_Sf_BFu31ll)
//============================================================================



static void Test_BFu0c_Sf_BFu32i()
{
  {
    init_simple_test("BFu0c_Sf_BFu32i");
    static STRUCT_IF_C BFu0c_Sf_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu32i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "BFu0c_Sf_BFu32i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu32i, BFu0c_Sf_BFu32i)
//============================================================================



static void Test_BFu0c_Sf_BFu32ll()
{
  {
    init_simple_test("BFu0c_Sf_BFu32ll");
    static STRUCT_IF_C BFu0c_Sf_BFu32ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu32ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "BFu0c_Sf_BFu32ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu32ll, BFu0c_Sf_BFu32ll)
//============================================================================



static void Test_BFu0c_Sf_BFu33()
{
  {
    init_simple_test("BFu0c_Sf_BFu33");
    static STRUCT_IF_C BFu0c_Sf_BFu33 lv;
    check2(sizeof(lv), 5, "sizeof(BFu0c_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu33.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "BFu0c_Sf_BFu33");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu33, BFu0c_Sf_BFu33)
//============================================================================



static void Test_BFu0c_Sf_BFu7c()
{
  {
    init_simple_test("BFu0c_Sf_BFu7c");
    static STRUCT_IF_C BFu0c_Sf_BFu7c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu7c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0c_Sf_BFu7c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu7c, BFu0c_Sf_BFu7c)
//============================================================================



static void Test_BFu0c_Sf_BFu7i()
{
  {
    init_simple_test("BFu0c_Sf_BFu7i");
    static STRUCT_IF_C BFu0c_Sf_BFu7i lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu7i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0c_Sf_BFu7i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu7i, BFu0c_Sf_BFu7i)
//============================================================================



static void Test_BFu0c_Sf_BFu7ll()
{
  {
    init_simple_test("BFu0c_Sf_BFu7ll");
    static STRUCT_IF_C BFu0c_Sf_BFu7ll lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu7ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0c_Sf_BFu7ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu7ll, BFu0c_Sf_BFu7ll)
//============================================================================



static void Test_BFu0c_Sf_BFu7s()
{
  {
    init_simple_test("BFu0c_Sf_BFu7s");
    static STRUCT_IF_C BFu0c_Sf_BFu7s lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu7s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0c_Sf_BFu7s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu7s, BFu0c_Sf_BFu7s)
//============================================================================



static void Test_BFu0c_Sf_BFu8c()
{
  {
    init_simple_test("BFu0c_Sf_BFu8c");
    static STRUCT_IF_C BFu0c_Sf_BFu8c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu8c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0c_Sf_BFu8c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu8c, BFu0c_Sf_BFu8c)
//============================================================================



static void Test_BFu0c_Sf_BFu8i()
{
  {
    init_simple_test("BFu0c_Sf_BFu8i");
    static STRUCT_IF_C BFu0c_Sf_BFu8i lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu8i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0c_Sf_BFu8i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu8i, BFu0c_Sf_BFu8i)
//============================================================================



static void Test_BFu0c_Sf_BFu8ll()
{
  {
    init_simple_test("BFu0c_Sf_BFu8ll");
    static STRUCT_IF_C BFu0c_Sf_BFu8ll lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu8ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0c_Sf_BFu8ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu8ll, BFu0c_Sf_BFu8ll)
//============================================================================



static void Test_BFu0c_Sf_BFu8s()
{
  {
    init_simple_test("BFu0c_Sf_BFu8s");
    static STRUCT_IF_C BFu0c_Sf_BFu8s lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu8s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0c_Sf_BFu8s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu8s, BFu0c_Sf_BFu8s)
//============================================================================



static void Test_BFu0c_Sf_BFu9i()
{
  {
    init_simple_test("BFu0c_Sf_BFu9i");
    static STRUCT_IF_C BFu0c_Sf_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu9i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "BFu0c_Sf_BFu9i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu9i, BFu0c_Sf_BFu9i)
//============================================================================



static void Test_BFu0c_Sf_BFu9ll()
{
  {
    init_simple_test("BFu0c_Sf_BFu9ll");
    static STRUCT_IF_C BFu0c_Sf_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu9ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "BFu0c_Sf_BFu9ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu9ll, BFu0c_Sf_BFu9ll)
//============================================================================



static void Test_BFu0c_Sf_BFu9s()
{
  {
    init_simple_test("BFu0c_Sf_BFu9s");
    static STRUCT_IF_C BFu0c_Sf_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_BFu9s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "BFu0c_Sf_BFu9s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_BFu9s, BFu0c_Sf_BFu9s)
//============================================================================



static void Test_BFu0c_Sf_C()
{
  {
    init_simple_test("BFu0c_Sf_C");
    static STRUCT_IF_C BFu0c_Sf_C lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_C)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_C.v1");
    check_field_offset(lv, v2, 0, "BFu0c_Sf_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_C, BFu0c_Sf_C)
//============================================================================



static void Test_BFu0c_Sf_D()
{
  {
    init_simple_test("BFu0c_Sf_D");
    static STRUCT_IF_C BFu0c_Sf_D lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_D)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_D.v1");
    check_field_offset(lv, v2, 0, "BFu0c_Sf_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_D, BFu0c_Sf_D)
//============================================================================



static void Test_BFu0c_Sf_F()
{
  {
    init_simple_test("BFu0c_Sf_F");
    static STRUCT_IF_C BFu0c_Sf_F lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_F)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_F.v1");
    check_field_offset(lv, v2, 0, "BFu0c_Sf_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_F, BFu0c_Sf_F)
//============================================================================



static void Test_BFu0c_Sf_I()
{
  {
    init_simple_test("BFu0c_Sf_I");
    static STRUCT_IF_C BFu0c_Sf_I lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_I)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_I.v1");
    check_field_offset(lv, v2, 0, "BFu0c_Sf_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_I, BFu0c_Sf_I)
//============================================================================



static void Test_BFu0c_Sf_Ip()
{
  {
    init_simple_test("BFu0c_Sf_Ip");
    static STRUCT_IF_C BFu0c_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_Ip.v1");
    check_field_offset(lv, v2, 0, "BFu0c_Sf_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_Ip, BFu0c_Sf_Ip)
//============================================================================



static void Test_BFu0c_Sf_L()
{
  {
    init_simple_test("BFu0c_Sf_L");
    static STRUCT_IF_C BFu0c_Sf_L lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_L)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_L.v1");
    check_field_offset(lv, v2, 0, "BFu0c_Sf_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_L, BFu0c_Sf_L)
//============================================================================



static void Test_BFu0c_Sf_S()
{
  {
    init_simple_test("BFu0c_Sf_S");
    static STRUCT_IF_C BFu0c_Sf_S lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_S)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_S.v1");
    check_field_offset(lv, v2, 0, "BFu0c_Sf_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_S, BFu0c_Sf_S)
//============================================================================



static void Test_BFu0c_Sf_Sf()
{
  {
    init_simple_test("BFu0c_Sf_Sf");
    static STRUCT_IF_C BFu0c_Sf_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_Sf.v1");
    check_field_offset(lv, v2, 0, "BFu0c_Sf_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_Sf, BFu0c_Sf_Sf)
//============================================================================



static void Test_BFu0c_Sf_Uc()
{
  {
    init_simple_test("BFu0c_Sf_Uc");
    static STRUCT_IF_C BFu0c_Sf_Uc lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_Uc.v1");
    check_field_offset(lv, v2, 0, "BFu0c_Sf_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_Uc, BFu0c_Sf_Uc)
//============================================================================



static void Test_BFu0c_Sf_Ui()
{
  {
    init_simple_test("BFu0c_Sf_Ui");
    static STRUCT_IF_C BFu0c_Sf_Ui lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_Ui.v1");
    check_field_offset(lv, v2, 0, "BFu0c_Sf_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_Ui, BFu0c_Sf_Ui)
//============================================================================



static void Test_BFu0c_Sf_Ul()
{
  {
    init_simple_test("BFu0c_Sf_Ul");
    static STRUCT_IF_C BFu0c_Sf_Ul lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_Ul.v1");
    check_field_offset(lv, v2, 0, "BFu0c_Sf_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_Ul, BFu0c_Sf_Ul)
//============================================================================



static void Test_BFu0c_Sf_Us()
{
  {
    init_simple_test("BFu0c_Sf_Us");
    static STRUCT_IF_C BFu0c_Sf_Us lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_Us.v1");
    check_field_offset(lv, v2, 0, "BFu0c_Sf_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_Us, BFu0c_Sf_Us)
//============================================================================



static void Test_BFu0c_Sf_Vp()
{
  {
    init_simple_test("BFu0c_Sf_Vp");
    static STRUCT_IF_C BFu0c_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Sf_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_Sf_Vp.v1");
    check_field_offset(lv, v2, 0, "BFu0c_Sf_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Sf_Vp, BFu0c_Sf_Vp)
//============================================================================



static void Test_BFu0c_Uc_Sf()
{
  {
    init_simple_test("BFu0c_Uc_Sf");
    static STRUCT_IF_C BFu0c_Uc_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Uc_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_Uc_Sf.v1");
    check_field_offset(lv, v2, 1, "BFu0c_Uc_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Uc_Sf, BFu0c_Uc_Sf)
//============================================================================



static void Test_BFu0c_Ui_Sf()
{
  {
    init_simple_test("BFu0c_Ui_Sf");
    static STRUCT_IF_C BFu0c_Ui_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ui_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_Ui_Sf.v1");
    check_field_offset(lv, v2, 4, "BFu0c_Ui_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Ui_Sf, BFu0c_Ui_Sf)
//============================================================================



static void Test_BFu0c_Ul_Sf()
{
  {
    init_simple_test("BFu0c_Ul_Sf");
    static STRUCT_IF_C BFu0c_Ul_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Ul_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_Ul_Sf.v1");
    check_field_offset(lv, v2, 8, "BFu0c_Ul_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Ul_Sf, BFu0c_Ul_Sf)
//============================================================================



static void Test_BFu0c_Us_Sf()
{
  {
    init_simple_test("BFu0c_Us_Sf");
    static STRUCT_IF_C BFu0c_Us_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Us_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_Us_Sf.v1");
    check_field_offset(lv, v2, 2, "BFu0c_Us_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Us_Sf, BFu0c_Us_Sf)
//============================================================================



static void Test_BFu0c_Vp_Sf()
{
  {
    init_simple_test("BFu0c_Vp_Sf");
    static STRUCT_IF_C BFu0c_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_Vp_Sf)");
    check_field_offset(lv, v1, 0, "BFu0c_Vp_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_Vp_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_Vp_Sf, BFu0c_Vp_Sf)
//============================================================================



static void Test_BFu0i_BFu0c_Sf()
{
  {
    init_simple_test("BFu0i_BFu0c_Sf");
    static STRUCT_IF_C BFu0i_BFu0c_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0i_BFu0c_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_BFu0c_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu0c_Sf, BFu0i_BFu0c_Sf)
//============================================================================



static void Test_BFu0i_BFu0i_Sf()
{
  {
    init_simple_test("BFu0i_BFu0i_Sf");
    static STRUCT_IF_C BFu0i_BFu0i_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0i_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_BFu0i_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu0i_Sf, BFu0i_BFu0i_Sf)
//============================================================================



static void Test_BFu0i_BFu0ll_Sf()
{
  {
    init_simple_test("BFu0i_BFu0ll_Sf");
    static STRUCT_IF_C BFu0i_BFu0ll_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0i_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_BFu0ll_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu0ll_Sf, BFu0i_BFu0ll_Sf)
//============================================================================



static void Test_BFu0i_BFu0s_Sf()
{
  {
    init_simple_test("BFu0i_BFu0s_Sf");
    static STRUCT_IF_C BFu0i_BFu0s_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0i_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_BFu0s_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu0s_Sf, BFu0i_BFu0s_Sf)
//============================================================================



static void Test_BFu0i_BFu15i_Sf()
{
  {
    init_simple_test("BFu0i_BFu15i_Sf");
    static STRUCT_IF_C BFu0i_BFu15i_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu15i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu15i_Sf");
    check_field_offset(lv, v2, 2, "BFu0i_BFu15i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu15i_Sf, BFu0i_BFu15i_Sf)
//============================================================================



static void Test_BFu0i_BFu15ll_Sf()
{
  {
    init_simple_test("BFu0i_BFu15ll_Sf");
    static STRUCT_IF_C BFu0i_BFu15ll_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu15ll_Sf");
    check_field_offset(lv, v2, 2, "BFu0i_BFu15ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu15ll_Sf, BFu0i_BFu15ll_Sf)
//============================================================================



static void Test_BFu0i_BFu15s_Sf()
{
  {
    init_simple_test("BFu0i_BFu15s_Sf");
    static STRUCT_IF_C BFu0i_BFu15s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu15s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu15s_Sf");
    check_field_offset(lv, v2, 2, "BFu0i_BFu15s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu15s_Sf, BFu0i_BFu15s_Sf)
//============================================================================



static void Test_BFu0i_BFu16i_Sf()
{
  {
    init_simple_test("BFu0i_BFu16i_Sf");
    static STRUCT_IF_C BFu0i_BFu16i_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu16i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu16i_Sf");
    check_field_offset(lv, v2, 2, "BFu0i_BFu16i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu16i_Sf, BFu0i_BFu16i_Sf)
//============================================================================



static void Test_BFu0i_BFu16ll_Sf()
{
  {
    init_simple_test("BFu0i_BFu16ll_Sf");
    static STRUCT_IF_C BFu0i_BFu16ll_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu16ll_Sf");
    check_field_offset(lv, v2, 2, "BFu0i_BFu16ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu16ll_Sf, BFu0i_BFu16ll_Sf)
//============================================================================



static void Test_BFu0i_BFu16s_Sf()
{
  {
    init_simple_test("BFu0i_BFu16s_Sf");
    static STRUCT_IF_C BFu0i_BFu16s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu16s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu16s_Sf");
    check_field_offset(lv, v2, 2, "BFu0i_BFu16s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu16s_Sf, BFu0i_BFu16s_Sf)
//============================================================================



static void Test_BFu0i_BFu17i_Sf()
{
  {
    init_simple_test("BFu0i_BFu17i_Sf");
    static STRUCT_IF_C BFu0i_BFu17i_Sf lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu0i_BFu17i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu17i_Sf");
    check_field_offset(lv, v2, 3, "BFu0i_BFu17i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu17i_Sf, BFu0i_BFu17i_Sf)
//============================================================================



static void Test_BFu0i_BFu17ll_Sf()
{
  {
    init_simple_test("BFu0i_BFu17ll_Sf");
    static STRUCT_IF_C BFu0i_BFu17ll_Sf lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu0i_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu17ll_Sf");
    check_field_offset(lv, v2, 3, "BFu0i_BFu17ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu17ll_Sf, BFu0i_BFu17ll_Sf)
//============================================================================



static void Test_BFu0i_BFu1c_Sf()
{
  {
    init_simple_test("BFu0i_BFu1c_Sf");
    static STRUCT_IF_C BFu0i_BFu1c_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu1c_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_Sf");
    check_field_offset(lv, v2, 1, "BFu0i_BFu1c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu1c_Sf, BFu0i_BFu1c_Sf)
//============================================================================



static void Test_BFu0i_BFu1i_Sf()
{
  {
    init_simple_test("BFu0i_BFu1i_Sf");
    static STRUCT_IF_C BFu0i_BFu1i_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu1i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_Sf");
    check_field_offset(lv, v2, 1, "BFu0i_BFu1i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu1i_Sf, BFu0i_BFu1i_Sf)
//============================================================================



static void Test_BFu0i_BFu1ll_Sf()
{
  {
    init_simple_test("BFu0i_BFu1ll_Sf");
    static STRUCT_IF_C BFu0i_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_Sf");
    check_field_offset(lv, v2, 1, "BFu0i_BFu1ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu1ll_Sf, BFu0i_BFu1ll_Sf)
//============================================================================



static void Test_BFu0i_BFu1s_Sf()
{
  {
    init_simple_test("BFu0i_BFu1s_Sf");
    static STRUCT_IF_C BFu0i_BFu1s_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu1s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_Sf");
    check_field_offset(lv, v2, 1, "BFu0i_BFu1s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu1s_Sf, BFu0i_BFu1s_Sf)
//============================================================================



static void Test_BFu0i_BFu31i_Sf()
{
  {
    init_simple_test("BFu0i_BFu31i_Sf");
    static STRUCT_IF_C BFu0i_BFu31i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu31i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_Sf");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu31i_Sf, BFu0i_BFu31i_Sf)
//============================================================================



static void Test_BFu0i_BFu31ll_Sf()
{
  {
    init_simple_test("BFu0i_BFu31ll_Sf");
    static STRUCT_IF_C BFu0i_BFu31ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_Sf");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu31ll_Sf, BFu0i_BFu31ll_Sf)
//============================================================================



static void Test_BFu0i_BFu32i_Sf()
{
  {
    init_simple_test("BFu0i_BFu32i_Sf");
    static STRUCT_IF_C BFu0i_BFu32i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu32i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_Sf");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu32i_Sf, BFu0i_BFu32i_Sf)
//============================================================================



static void Test_BFu0i_BFu32ll_Sf()
{
  {
    init_simple_test("BFu0i_BFu32ll_Sf");
    static STRUCT_IF_C BFu0i_BFu32ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_Sf");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu32ll_Sf, BFu0i_BFu32ll_Sf)
//============================================================================



static void Test_BFu0i_BFu33_Sf()
{
  {
    init_simple_test("BFu0i_BFu33_Sf");
    static STRUCT_IF_C BFu0i_BFu33_Sf lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu0i_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_Sf");
    check_field_offset(lv, v2, 5, "BFu0i_BFu33_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu33_Sf, BFu0i_BFu33_Sf)
//============================================================================



static void Test_BFu0i_BFu7c_Sf()
{
  {
    init_simple_test("BFu0i_BFu7c_Sf");
    static STRUCT_IF_C BFu0i_BFu7c_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu7c_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_Sf");
    check_field_offset(lv, v2, 1, "BFu0i_BFu7c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu7c_Sf, BFu0i_BFu7c_Sf)
//============================================================================



static void Test_BFu0i_BFu7i_Sf()
{
  {
    init_simple_test("BFu0i_BFu7i_Sf");
    static STRUCT_IF_C BFu0i_BFu7i_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu7i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_Sf");
    check_field_offset(lv, v2, 1, "BFu0i_BFu7i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu7i_Sf, BFu0i_BFu7i_Sf)
//============================================================================



static void Test_BFu0i_BFu7ll_Sf()
{
  {
    init_simple_test("BFu0i_BFu7ll_Sf");
    static STRUCT_IF_C BFu0i_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_Sf");
    check_field_offset(lv, v2, 1, "BFu0i_BFu7ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu7ll_Sf, BFu0i_BFu7ll_Sf)
//============================================================================



static void Test_BFu0i_BFu7s_Sf()
{
  {
    init_simple_test("BFu0i_BFu7s_Sf");
    static STRUCT_IF_C BFu0i_BFu7s_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu7s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_Sf");
    check_field_offset(lv, v2, 1, "BFu0i_BFu7s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu7s_Sf, BFu0i_BFu7s_Sf)
//============================================================================



static void Test_BFu0i_BFu8c_Sf()
{
  {
    init_simple_test("BFu0i_BFu8c_Sf");
    static STRUCT_IF_C BFu0i_BFu8c_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu8c_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_Sf");
    check_field_offset(lv, v2, 1, "BFu0i_BFu8c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu8c_Sf, BFu0i_BFu8c_Sf)
//============================================================================



static void Test_BFu0i_BFu8i_Sf()
{
  {
    init_simple_test("BFu0i_BFu8i_Sf");
    static STRUCT_IF_C BFu0i_BFu8i_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu8i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_Sf");
    check_field_offset(lv, v2, 1, "BFu0i_BFu8i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu8i_Sf, BFu0i_BFu8i_Sf)
//============================================================================



static void Test_BFu0i_BFu8ll_Sf()
{
  {
    init_simple_test("BFu0i_BFu8ll_Sf");
    static STRUCT_IF_C BFu0i_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_Sf");
    check_field_offset(lv, v2, 1, "BFu0i_BFu8ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu8ll_Sf, BFu0i_BFu8ll_Sf)
//============================================================================



static void Test_BFu0i_BFu8s_Sf()
{
  {
    init_simple_test("BFu0i_BFu8s_Sf");
    static STRUCT_IF_C BFu0i_BFu8s_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu8s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_Sf");
    check_field_offset(lv, v2, 1, "BFu0i_BFu8s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu8s_Sf, BFu0i_BFu8s_Sf)
//============================================================================



static void Test_BFu0i_BFu9i_Sf()
{
  {
    init_simple_test("BFu0i_BFu9i_Sf");
    static STRUCT_IF_C BFu0i_BFu9i_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu9i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_Sf");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu9i_Sf, BFu0i_BFu9i_Sf)
//============================================================================



static void Test_BFu0i_BFu9ll_Sf()
{
  {
    init_simple_test("BFu0i_BFu9ll_Sf");
    static STRUCT_IF_C BFu0i_BFu9ll_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_Sf");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu9ll_Sf, BFu0i_BFu9ll_Sf)
//============================================================================



static void Test_BFu0i_BFu9s_Sf()
{
  {
    init_simple_test("BFu0i_BFu9s_Sf");
    static STRUCT_IF_C BFu0i_BFu9s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu9s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_Sf");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_BFu9s_Sf, BFu0i_BFu9s_Sf)
//============================================================================



static void Test_BFu0i_C_Sf()
{
  {
    init_simple_test("BFu0i_C_Sf");
    static STRUCT_IF_C BFu0i_C_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_C_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_C_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_C_Sf.v1");
    check_field_offset(lv, v2, 1, "BFu0i_C_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_C_Sf, BFu0i_C_Sf)
//============================================================================



static void Test_BFu0i_D_Sf()
{
  {
    init_simple_test("BFu0i_D_Sf");
    static STRUCT_IF_C BFu0i_D_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_D_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_D_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_D_Sf.v1");
    check_field_offset(lv, v2, 8, "BFu0i_D_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_D_Sf, BFu0i_D_Sf)
//============================================================================



static void Test_BFu0i_F_Sf()
{
  {
    init_simple_test("BFu0i_F_Sf");
    static STRUCT_IF_C BFu0i_F_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_F_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_F_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_F_Sf.v1");
    check_field_offset(lv, v2, 4, "BFu0i_F_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_F_Sf, BFu0i_F_Sf)
//============================================================================



static void Test_BFu0i_I_Sf()
{
  {
    init_simple_test("BFu0i_I_Sf");
    static STRUCT_IF_C BFu0i_I_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_I_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_I_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_I_Sf.v1");
    check_field_offset(lv, v2, 4, "BFu0i_I_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_I_Sf, BFu0i_I_Sf)
//============================================================================



static void Test_BFu0i_Ip_Sf()
{
  {
    init_simple_test("BFu0i_Ip_Sf");
    static STRUCT_IF_C BFu0i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Ip_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Ip_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Ip_Sf, BFu0i_Ip_Sf)
//============================================================================



static void Test_BFu0i_L_Sf()
{
  {
    init_simple_test("BFu0i_L_Sf");
    static STRUCT_IF_C BFu0i_L_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_L_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_L_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_L_Sf.v1");
    check_field_offset(lv, v2, 8, "BFu0i_L_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_L_Sf, BFu0i_L_Sf)
//============================================================================



static void Test_BFu0i_S_Sf()
{
  {
    init_simple_test("BFu0i_S_Sf");
    static STRUCT_IF_C BFu0i_S_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_S_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_S_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_S_Sf.v1");
    check_field_offset(lv, v2, 2, "BFu0i_S_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_S_Sf, BFu0i_S_Sf)
//============================================================================



static void Test_BFu0i_Sf()
{
  {
    init_simple_test("BFu0i_Sf");
    static STRUCT_IF_C BFu0i_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf, BFu0i_Sf)
//============================================================================



static void Test_BFu0i_Sf_BFu0c()
{
  {
    init_simple_test("BFu0i_Sf_BFu0c");
    static STRUCT_IF_C BFu0i_Sf_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0i_Sf_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu0c, BFu0i_Sf_BFu0c)
//============================================================================



static void Test_BFu0i_Sf_BFu0i()
{
  {
    init_simple_test("BFu0i_Sf_BFu0i");
    static STRUCT_IF_C BFu0i_Sf_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0i_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu0i, BFu0i_Sf_BFu0i)
//============================================================================



static void Test_BFu0i_Sf_BFu0ll()
{
  {
    init_simple_test("BFu0i_Sf_BFu0ll");
    static STRUCT_IF_C BFu0i_Sf_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0i_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu0ll, BFu0i_Sf_BFu0ll)
//============================================================================



static void Test_BFu0i_Sf_BFu0s()
{
  {
    init_simple_test("BFu0i_Sf_BFu0s");
    static STRUCT_IF_C BFu0i_Sf_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0i_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu0s, BFu0i_Sf_BFu0s)
//============================================================================



static void Test_BFu0i_Sf_BFu15i()
{
  {
    init_simple_test("BFu0i_Sf_BFu15i");
    static STRUCT_IF_C BFu0i_Sf_BFu15i lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_Sf_BFu15i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu15i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "BFu0i_Sf_BFu15i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "BFu0i_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu15i, BFu0i_Sf_BFu15i)
//============================================================================



static void Test_BFu0i_Sf_BFu15ll()
{
  {
    init_simple_test("BFu0i_Sf_BFu15ll");
    static STRUCT_IF_C BFu0i_Sf_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu15ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "BFu0i_Sf_BFu15ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "BFu0i_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu15ll, BFu0i_Sf_BFu15ll)
//============================================================================



static void Test_BFu0i_Sf_BFu15s()
{
  {
    init_simple_test("BFu0i_Sf_BFu15s");
    static STRUCT_IF_C BFu0i_Sf_BFu15s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_Sf_BFu15s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu15s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "BFu0i_Sf_BFu15s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "BFu0i_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu15s, BFu0i_Sf_BFu15s)
//============================================================================



static void Test_BFu0i_Sf_BFu16i()
{
  {
    init_simple_test("BFu0i_Sf_BFu16i");
    static STRUCT_IF_C BFu0i_Sf_BFu16i lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_Sf_BFu16i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu16i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "BFu0i_Sf_BFu16i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "BFu0i_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu16i, BFu0i_Sf_BFu16i)
//============================================================================



static void Test_BFu0i_Sf_BFu16ll()
{
  {
    init_simple_test("BFu0i_Sf_BFu16ll");
    static STRUCT_IF_C BFu0i_Sf_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu16ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "BFu0i_Sf_BFu16ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "BFu0i_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu16ll, BFu0i_Sf_BFu16ll)
//============================================================================



static void Test_BFu0i_Sf_BFu16s()
{
  {
    init_simple_test("BFu0i_Sf_BFu16s");
    static STRUCT_IF_C BFu0i_Sf_BFu16s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_Sf_BFu16s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu16s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "BFu0i_Sf_BFu16s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "BFu0i_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu16s, BFu0i_Sf_BFu16s)
//============================================================================



static void Test_BFu0i_Sf_BFu17i()
{
  {
    init_simple_test("BFu0i_Sf_BFu17i");
    static STRUCT_IF_C BFu0i_Sf_BFu17i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu0i_Sf_BFu17i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu17i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "BFu0i_Sf_BFu17i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "BFu0i_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu17i, BFu0i_Sf_BFu17i)
//============================================================================



static void Test_BFu0i_Sf_BFu17ll()
{
  {
    init_simple_test("BFu0i_Sf_BFu17ll");
    static STRUCT_IF_C BFu0i_Sf_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu0i_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu17ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "BFu0i_Sf_BFu17ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "BFu0i_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu17ll, BFu0i_Sf_BFu17ll)
//============================================================================



static void Test_BFu0i_Sf_BFu1c()
{
  {
    init_simple_test("BFu0i_Sf_BFu1c");
    static STRUCT_IF_C BFu0i_Sf_BFu1c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu1c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0i_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu1c, BFu0i_Sf_BFu1c)
//============================================================================



static void Test_BFu0i_Sf_BFu1i()
{
  {
    init_simple_test("BFu0i_Sf_BFu1i");
    static STRUCT_IF_C BFu0i_Sf_BFu1i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_BFu1i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu1i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0i_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu1i, BFu0i_Sf_BFu1i)
//============================================================================



static void Test_BFu0i_Sf_BFu1ll()
{
  {
    init_simple_test("BFu0i_Sf_BFu1ll");
    static STRUCT_IF_C BFu0i_Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu1ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0i_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu1ll, BFu0i_Sf_BFu1ll)
//============================================================================



static void Test_BFu0i_Sf_BFu1s()
{
  {
    init_simple_test("BFu0i_Sf_BFu1s");
    static STRUCT_IF_C BFu0i_Sf_BFu1s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_BFu1s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu1s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0i_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu1s, BFu0i_Sf_BFu1s)
//============================================================================



static void Test_BFu0i_Sf_BFu31i()
{
  {
    init_simple_test("BFu0i_Sf_BFu31i");
    static STRUCT_IF_C BFu0i_Sf_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_Sf_BFu31i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu31i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "BFu0i_Sf_BFu31i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu31i, BFu0i_Sf_BFu31i)
//============================================================================



static void Test_BFu0i_Sf_BFu31ll()
{
  {
    init_simple_test("BFu0i_Sf_BFu31ll");
    static STRUCT_IF_C BFu0i_Sf_BFu31ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu31ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "BFu0i_Sf_BFu31ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu31ll, BFu0i_Sf_BFu31ll)
//============================================================================



static void Test_BFu0i_Sf_BFu32i()
{
  {
    init_simple_test("BFu0i_Sf_BFu32i");
    static STRUCT_IF_C BFu0i_Sf_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_Sf_BFu32i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu32i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "BFu0i_Sf_BFu32i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu32i, BFu0i_Sf_BFu32i)
//============================================================================



static void Test_BFu0i_Sf_BFu32ll()
{
  {
    init_simple_test("BFu0i_Sf_BFu32ll");
    static STRUCT_IF_C BFu0i_Sf_BFu32ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu32ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "BFu0i_Sf_BFu32ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu32ll, BFu0i_Sf_BFu32ll)
//============================================================================



static void Test_BFu0i_Sf_BFu33()
{
  {
    init_simple_test("BFu0i_Sf_BFu33");
    static STRUCT_IF_C BFu0i_Sf_BFu33 lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu0i_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu33.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "BFu0i_Sf_BFu33");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu33, BFu0i_Sf_BFu33)
//============================================================================



static void Test_BFu0i_Sf_BFu7c()
{
  {
    init_simple_test("BFu0i_Sf_BFu7c");
    static STRUCT_IF_C BFu0i_Sf_BFu7c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu7c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0i_Sf_BFu7c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu7c, BFu0i_Sf_BFu7c)
//============================================================================



static void Test_BFu0i_Sf_BFu7i()
{
  {
    init_simple_test("BFu0i_Sf_BFu7i");
    static STRUCT_IF_C BFu0i_Sf_BFu7i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_BFu7i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu7i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0i_Sf_BFu7i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu7i, BFu0i_Sf_BFu7i)
//============================================================================



static void Test_BFu0i_Sf_BFu7ll()
{
  {
    init_simple_test("BFu0i_Sf_BFu7ll");
    static STRUCT_IF_C BFu0i_Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu7ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0i_Sf_BFu7ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu7ll, BFu0i_Sf_BFu7ll)
//============================================================================



static void Test_BFu0i_Sf_BFu7s()
{
  {
    init_simple_test("BFu0i_Sf_BFu7s");
    static STRUCT_IF_C BFu0i_Sf_BFu7s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_BFu7s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu7s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0i_Sf_BFu7s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu7s, BFu0i_Sf_BFu7s)
//============================================================================



static void Test_BFu0i_Sf_BFu8c()
{
  {
    init_simple_test("BFu0i_Sf_BFu8c");
    static STRUCT_IF_C BFu0i_Sf_BFu8c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu8c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0i_Sf_BFu8c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu8c, BFu0i_Sf_BFu8c)
//============================================================================



static void Test_BFu0i_Sf_BFu8i()
{
  {
    init_simple_test("BFu0i_Sf_BFu8i");
    static STRUCT_IF_C BFu0i_Sf_BFu8i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_BFu8i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu8i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0i_Sf_BFu8i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu8i, BFu0i_Sf_BFu8i)
//============================================================================



static void Test_BFu0i_Sf_BFu8ll()
{
  {
    init_simple_test("BFu0i_Sf_BFu8ll");
    static STRUCT_IF_C BFu0i_Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu8ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0i_Sf_BFu8ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu8ll, BFu0i_Sf_BFu8ll)
//============================================================================



static void Test_BFu0i_Sf_BFu8s()
{
  {
    init_simple_test("BFu0i_Sf_BFu8s");
    static STRUCT_IF_C BFu0i_Sf_BFu8s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_BFu8s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu8s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0i_Sf_BFu8s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu8s, BFu0i_Sf_BFu8s)
//============================================================================



static void Test_BFu0i_Sf_BFu9i()
{
  {
    init_simple_test("BFu0i_Sf_BFu9i");
    static STRUCT_IF_C BFu0i_Sf_BFu9i lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_Sf_BFu9i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu9i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "BFu0i_Sf_BFu9i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu9i, BFu0i_Sf_BFu9i)
//============================================================================



static void Test_BFu0i_Sf_BFu9ll()
{
  {
    init_simple_test("BFu0i_Sf_BFu9ll");
    static STRUCT_IF_C BFu0i_Sf_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu9ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "BFu0i_Sf_BFu9ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu9ll, BFu0i_Sf_BFu9ll)
//============================================================================



static void Test_BFu0i_Sf_BFu9s()
{
  {
    init_simple_test("BFu0i_Sf_BFu9s");
    static STRUCT_IF_C BFu0i_Sf_BFu9s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_Sf_BFu9s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_BFu9s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "BFu0i_Sf_BFu9s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_BFu9s, BFu0i_Sf_BFu9s)
//============================================================================



static void Test_BFu0i_Sf_C()
{
  {
    init_simple_test("BFu0i_Sf_C");
    static STRUCT_IF_C BFu0i_Sf_C lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_C)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_C.v1");
    check_field_offset(lv, v2, 0, "BFu0i_Sf_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_C, BFu0i_Sf_C)
//============================================================================



static void Test_BFu0i_Sf_D()
{
  {
    init_simple_test("BFu0i_Sf_D");
    static STRUCT_IF_C BFu0i_Sf_D lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_Sf_D)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_D)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_D.v1");
    check_field_offset(lv, v2, 0, "BFu0i_Sf_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_D, BFu0i_Sf_D)
//============================================================================



static void Test_BFu0i_Sf_F()
{
  {
    init_simple_test("BFu0i_Sf_F");
    static STRUCT_IF_C BFu0i_Sf_F lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_Sf_F)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_F)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_F.v1");
    check_field_offset(lv, v2, 0, "BFu0i_Sf_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_F, BFu0i_Sf_F)
//============================================================================



static void Test_BFu0i_Sf_I()
{
  {
    init_simple_test("BFu0i_Sf_I");
    static STRUCT_IF_C BFu0i_Sf_I lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_Sf_I)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_I)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_I.v1");
    check_field_offset(lv, v2, 0, "BFu0i_Sf_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_I, BFu0i_Sf_I)
//============================================================================



static void Test_BFu0i_Sf_Ip()
{
  {
    init_simple_test("BFu0i_Sf_Ip");
    static STRUCT_IF_C BFu0i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_Ip)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_Ip.v1");
    check_field_offset(lv, v2, 0, "BFu0i_Sf_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_Ip, BFu0i_Sf_Ip)
//============================================================================



static void Test_BFu0i_Sf_L()
{
  {
    init_simple_test("BFu0i_Sf_L");
    static STRUCT_IF_C BFu0i_Sf_L lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_Sf_L)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_L)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_L.v1");
    check_field_offset(lv, v2, 0, "BFu0i_Sf_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_L, BFu0i_Sf_L)
//============================================================================



static void Test_BFu0i_Sf_S()
{
  {
    init_simple_test("BFu0i_Sf_S");
    static STRUCT_IF_C BFu0i_Sf_S lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_Sf_S)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_S)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_S.v1");
    check_field_offset(lv, v2, 0, "BFu0i_Sf_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_S, BFu0i_Sf_S)
//============================================================================



static void Test_BFu0i_Sf_Sf()
{
  {
    init_simple_test("BFu0i_Sf_Sf");
    static STRUCT_IF_C BFu0i_Sf_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0i_Sf_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_Sf.v1");
    check_field_offset(lv, v2, 0, "BFu0i_Sf_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_Sf, BFu0i_Sf_Sf)
//============================================================================



static void Test_BFu0i_Sf_Uc()
{
  {
    init_simple_test("BFu0i_Sf_Uc");
    static STRUCT_IF_C BFu0i_Sf_Uc lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Sf_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_Uc)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_Uc.v1");
    check_field_offset(lv, v2, 0, "BFu0i_Sf_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_Uc, BFu0i_Sf_Uc)
//============================================================================



static void Test_BFu0i_Sf_Ui()
{
  {
    init_simple_test("BFu0i_Sf_Ui");
    static STRUCT_IF_C BFu0i_Sf_Ui lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_Sf_Ui)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_Ui)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_Ui.v1");
    check_field_offset(lv, v2, 0, "BFu0i_Sf_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_Ui, BFu0i_Sf_Ui)
//============================================================================



static void Test_BFu0i_Sf_Ul()
{
  {
    init_simple_test("BFu0i_Sf_Ul");
    static STRUCT_IF_C BFu0i_Sf_Ul lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_Ul)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_Ul.v1");
    check_field_offset(lv, v2, 0, "BFu0i_Sf_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_Ul, BFu0i_Sf_Ul)
//============================================================================



static void Test_BFu0i_Sf_Us()
{
  {
    init_simple_test("BFu0i_Sf_Us");
    static STRUCT_IF_C BFu0i_Sf_Us lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_Sf_Us)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_Us)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_Us.v1");
    check_field_offset(lv, v2, 0, "BFu0i_Sf_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_Us, BFu0i_Sf_Us)
//============================================================================



static void Test_BFu0i_Sf_Vp()
{
  {
    init_simple_test("BFu0i_Sf_Vp");
    static STRUCT_IF_C BFu0i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Sf_Vp)");
    check_field_offset(lv, v1, 0, "BFu0i_Sf_Vp.v1");
    check_field_offset(lv, v2, 0, "BFu0i_Sf_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Sf_Vp, BFu0i_Sf_Vp)
//============================================================================



static void Test_BFu0i_Uc_Sf()
{
  {
    init_simple_test("BFu0i_Uc_Sf");
    static STRUCT_IF_C BFu0i_Uc_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_Uc_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Uc_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_Uc_Sf.v1");
    check_field_offset(lv, v2, 1, "BFu0i_Uc_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Uc_Sf, BFu0i_Uc_Sf)
//============================================================================



static void Test_BFu0i_Ui_Sf()
{
  {
    init_simple_test("BFu0i_Ui_Sf");
    static STRUCT_IF_C BFu0i_Ui_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_Ui_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Ui_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_Ui_Sf.v1");
    check_field_offset(lv, v2, 4, "BFu0i_Ui_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Ui_Sf, BFu0i_Ui_Sf)
//============================================================================



static void Test_BFu0i_Ul_Sf()
{
  {
    init_simple_test("BFu0i_Ul_Sf");
    static STRUCT_IF_C BFu0i_Ul_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Ul_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_Ul_Sf.v1");
    check_field_offset(lv, v2, 8, "BFu0i_Ul_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Ul_Sf, BFu0i_Ul_Sf)
//============================================================================



static void Test_BFu0i_Us_Sf()
{
  {
    init_simple_test("BFu0i_Us_Sf");
    static STRUCT_IF_C BFu0i_Us_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_Us_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Us_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_Us_Sf.v1");
    check_field_offset(lv, v2, 2, "BFu0i_Us_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Us_Sf, BFu0i_Us_Sf)
//============================================================================



static void Test_BFu0i_Vp_Sf()
{
  {
    init_simple_test("BFu0i_Vp_Sf");
    static STRUCT_IF_C BFu0i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_Vp_Sf)");
    check_field_offset(lv, v1, 0, "BFu0i_Vp_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Vp_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0i_Vp_Sf, BFu0i_Vp_Sf)
//============================================================================



static void Test_BFu0ll_BFu0c_Sf()
{
  {
    init_simple_test("BFu0ll_BFu0c_Sf");
    static STRUCT_IF_C BFu0ll_BFu0c_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0ll_BFu0c_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_BFu0c_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu0c_Sf, BFu0ll_BFu0c_Sf)
//============================================================================



static void Test_BFu0ll_BFu0i_Sf()
{
  {
    init_simple_test("BFu0ll_BFu0i_Sf");
    static STRUCT_IF_C BFu0ll_BFu0i_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0ll_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_BFu0i_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu0i_Sf, BFu0ll_BFu0i_Sf)
//============================================================================



static void Test_BFu0ll_BFu0ll_Sf()
{
  {
    init_simple_test("BFu0ll_BFu0ll_Sf");
    static STRUCT_IF_C BFu0ll_BFu0ll_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0ll_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_BFu0ll_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu0ll_Sf, BFu0ll_BFu0ll_Sf)
//============================================================================



static void Test_BFu0ll_BFu0s_Sf()
{
  {
    init_simple_test("BFu0ll_BFu0s_Sf");
    static STRUCT_IF_C BFu0ll_BFu0s_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0ll_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_BFu0s_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu0s_Sf, BFu0ll_BFu0s_Sf)
//============================================================================



static void Test_BFu0ll_BFu15i_Sf()
{
  {
    init_simple_test("BFu0ll_BFu15i_Sf");
    static STRUCT_IF_C BFu0ll_BFu15i_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_BFu15i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0ll_BFu15i_Sf");
    check_field_offset(lv, v2, 2, "BFu0ll_BFu15i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu15i_Sf, BFu0ll_BFu15i_Sf)
//============================================================================



static void Test_BFu0ll_BFu15ll_Sf()
{
  {
    init_simple_test("BFu0ll_BFu15ll_Sf");
    static STRUCT_IF_C BFu0ll_BFu15ll_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0ll_BFu15ll_Sf");
    check_field_offset(lv, v2, 2, "BFu0ll_BFu15ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu15ll_Sf, BFu0ll_BFu15ll_Sf)
//============================================================================



static void Test_BFu0ll_BFu15s_Sf()
{
  {
    init_simple_test("BFu0ll_BFu15s_Sf");
    static STRUCT_IF_C BFu0ll_BFu15s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_BFu15s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0ll_BFu15s_Sf");
    check_field_offset(lv, v2, 2, "BFu0ll_BFu15s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu15s_Sf, BFu0ll_BFu15s_Sf)
//============================================================================



static void Test_BFu0ll_BFu16i_Sf()
{
  {
    init_simple_test("BFu0ll_BFu16i_Sf");
    static STRUCT_IF_C BFu0ll_BFu16i_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_BFu16i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0ll_BFu16i_Sf");
    check_field_offset(lv, v2, 2, "BFu0ll_BFu16i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu16i_Sf, BFu0ll_BFu16i_Sf)
//============================================================================



static void Test_BFu0ll_BFu16ll_Sf()
{
  {
    init_simple_test("BFu0ll_BFu16ll_Sf");
    static STRUCT_IF_C BFu0ll_BFu16ll_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0ll_BFu16ll_Sf");
    check_field_offset(lv, v2, 2, "BFu0ll_BFu16ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu16ll_Sf, BFu0ll_BFu16ll_Sf)
//============================================================================



static void Test_BFu0ll_BFu16s_Sf()
{
  {
    init_simple_test("BFu0ll_BFu16s_Sf");
    static STRUCT_IF_C BFu0ll_BFu16s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_BFu16s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0ll_BFu16s_Sf");
    check_field_offset(lv, v2, 2, "BFu0ll_BFu16s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu16s_Sf, BFu0ll_BFu16s_Sf)
//============================================================================



static void Test_BFu0ll_BFu17i_Sf()
{
  {
    init_simple_test("BFu0ll_BFu17i_Sf");
    static STRUCT_IF_C BFu0ll_BFu17i_Sf lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu0ll_BFu17i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0ll_BFu17i_Sf");
    check_field_offset(lv, v2, 3, "BFu0ll_BFu17i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu17i_Sf, BFu0ll_BFu17i_Sf)
//============================================================================



static void Test_BFu0ll_BFu17ll_Sf()
{
  {
    init_simple_test("BFu0ll_BFu17ll_Sf");
    static STRUCT_IF_C BFu0ll_BFu17ll_Sf lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu0ll_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0ll_BFu17ll_Sf");
    check_field_offset(lv, v2, 3, "BFu0ll_BFu17ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu17ll_Sf, BFu0ll_BFu17ll_Sf)
//============================================================================



static void Test_BFu0ll_BFu1c_Sf()
{
  {
    init_simple_test("BFu0ll_BFu1c_Sf");
    static STRUCT_IF_C BFu0ll_BFu1c_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_BFu1c_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0ll_BFu1c_Sf");
    check_field_offset(lv, v2, 1, "BFu0ll_BFu1c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu1c_Sf, BFu0ll_BFu1c_Sf)
//============================================================================



static void Test_BFu0ll_BFu1i_Sf()
{
  {
    init_simple_test("BFu0ll_BFu1i_Sf");
    static STRUCT_IF_C BFu0ll_BFu1i_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_BFu1i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0ll_BFu1i_Sf");
    check_field_offset(lv, v2, 1, "BFu0ll_BFu1i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu1i_Sf, BFu0ll_BFu1i_Sf)
//============================================================================



static void Test_BFu0ll_BFu1ll_Sf()
{
  {
    init_simple_test("BFu0ll_BFu1ll_Sf");
    static STRUCT_IF_C BFu0ll_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0ll_BFu1ll_Sf");
    check_field_offset(lv, v2, 1, "BFu0ll_BFu1ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu1ll_Sf, BFu0ll_BFu1ll_Sf)
//============================================================================



static void Test_BFu0ll_BFu1s_Sf()
{
  {
    init_simple_test("BFu0ll_BFu1s_Sf");
    static STRUCT_IF_C BFu0ll_BFu1s_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_BFu1s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0ll_BFu1s_Sf");
    check_field_offset(lv, v2, 1, "BFu0ll_BFu1s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu1s_Sf, BFu0ll_BFu1s_Sf)
//============================================================================



static void Test_BFu0ll_BFu31i_Sf()
{
  {
    init_simple_test("BFu0ll_BFu31i_Sf");
    static STRUCT_IF_C BFu0ll_BFu31i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_BFu31i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0ll_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0ll_BFu31i_Sf");
    check_field_offset(lv, v2, 4, "BFu0ll_BFu31i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu31i_Sf, BFu0ll_BFu31i_Sf)
//============================================================================



static void Test_BFu0ll_BFu31ll_Sf()
{
  {
    init_simple_test("BFu0ll_BFu31ll_Sf");
    static STRUCT_IF_C BFu0ll_BFu31ll_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0ll_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0ll_BFu31ll_Sf");
    check_field_offset(lv, v2, 4, "BFu0ll_BFu31ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu31ll_Sf, BFu0ll_BFu31ll_Sf)
//============================================================================



static void Test_BFu0ll_BFu32i_Sf()
{
  {
    init_simple_test("BFu0ll_BFu32i_Sf");
    static STRUCT_IF_C BFu0ll_BFu32i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_BFu32i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0ll_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0ll_BFu32i_Sf");
    check_field_offset(lv, v2, 4, "BFu0ll_BFu32i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu32i_Sf, BFu0ll_BFu32i_Sf)
//============================================================================



static void Test_BFu0ll_BFu32ll_Sf()
{
  {
    init_simple_test("BFu0ll_BFu32ll_Sf");
    static STRUCT_IF_C BFu0ll_BFu32ll_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0ll_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0ll_BFu32ll_Sf");
    check_field_offset(lv, v2, 4, "BFu0ll_BFu32ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu32ll_Sf, BFu0ll_BFu32ll_Sf)
//============================================================================



static void Test_BFu0ll_BFu33_Sf()
{
  {
    init_simple_test("BFu0ll_BFu33_Sf");
    static STRUCT_IF_C BFu0ll_BFu33_Sf lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu0ll_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0ll_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0ll_BFu33_Sf");
    check_field_offset(lv, v2, 5, "BFu0ll_BFu33_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu33_Sf, BFu0ll_BFu33_Sf)
//============================================================================



static void Test_BFu0ll_BFu7c_Sf()
{
  {
    init_simple_test("BFu0ll_BFu7c_Sf");
    static STRUCT_IF_C BFu0ll_BFu7c_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_BFu7c_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0ll_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0ll_BFu7c_Sf");
    check_field_offset(lv, v2, 1, "BFu0ll_BFu7c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu7c_Sf, BFu0ll_BFu7c_Sf)
//============================================================================



static void Test_BFu0ll_BFu7i_Sf()
{
  {
    init_simple_test("BFu0ll_BFu7i_Sf");
    static STRUCT_IF_C BFu0ll_BFu7i_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_BFu7i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0ll_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0ll_BFu7i_Sf");
    check_field_offset(lv, v2, 1, "BFu0ll_BFu7i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu7i_Sf, BFu0ll_BFu7i_Sf)
//============================================================================



static void Test_BFu0ll_BFu7ll_Sf()
{
  {
    init_simple_test("BFu0ll_BFu7ll_Sf");
    static STRUCT_IF_C BFu0ll_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0ll_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0ll_BFu7ll_Sf");
    check_field_offset(lv, v2, 1, "BFu0ll_BFu7ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu7ll_Sf, BFu0ll_BFu7ll_Sf)
//============================================================================



static void Test_BFu0ll_BFu7s_Sf()
{
  {
    init_simple_test("BFu0ll_BFu7s_Sf");
    static STRUCT_IF_C BFu0ll_BFu7s_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_BFu7s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0ll_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0ll_BFu7s_Sf");
    check_field_offset(lv, v2, 1, "BFu0ll_BFu7s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu7s_Sf, BFu0ll_BFu7s_Sf)
//============================================================================



static void Test_BFu0ll_BFu8c_Sf()
{
  {
    init_simple_test("BFu0ll_BFu8c_Sf");
    static STRUCT_IF_C BFu0ll_BFu8c_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_BFu8c_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0ll_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0ll_BFu8c_Sf");
    check_field_offset(lv, v2, 1, "BFu0ll_BFu8c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu8c_Sf, BFu0ll_BFu8c_Sf)
//============================================================================



static void Test_BFu0ll_BFu8i_Sf()
{
  {
    init_simple_test("BFu0ll_BFu8i_Sf");
    static STRUCT_IF_C BFu0ll_BFu8i_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_BFu8i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0ll_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0ll_BFu8i_Sf");
    check_field_offset(lv, v2, 1, "BFu0ll_BFu8i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu8i_Sf, BFu0ll_BFu8i_Sf)
//============================================================================



static void Test_BFu0ll_BFu8ll_Sf()
{
  {
    init_simple_test("BFu0ll_BFu8ll_Sf");
    static STRUCT_IF_C BFu0ll_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0ll_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0ll_BFu8ll_Sf");
    check_field_offset(lv, v2, 1, "BFu0ll_BFu8ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu8ll_Sf, BFu0ll_BFu8ll_Sf)
//============================================================================



static void Test_BFu0ll_BFu8s_Sf()
{
  {
    init_simple_test("BFu0ll_BFu8s_Sf");
    static STRUCT_IF_C BFu0ll_BFu8s_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_BFu8s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0ll_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0ll_BFu8s_Sf");
    check_field_offset(lv, v2, 1, "BFu0ll_BFu8s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu8s_Sf, BFu0ll_BFu8s_Sf)
//============================================================================



static void Test_BFu0ll_BFu9i_Sf()
{
  {
    init_simple_test("BFu0ll_BFu9i_Sf");
    static STRUCT_IF_C BFu0ll_BFu9i_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_BFu9i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0ll_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0ll_BFu9i_Sf");
    check_field_offset(lv, v2, 2, "BFu0ll_BFu9i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu9i_Sf, BFu0ll_BFu9i_Sf)
//============================================================================



static void Test_BFu0ll_BFu9ll_Sf()
{
  {
    init_simple_test("BFu0ll_BFu9ll_Sf");
    static STRUCT_IF_C BFu0ll_BFu9ll_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0ll_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0ll_BFu9ll_Sf");
    check_field_offset(lv, v2, 2, "BFu0ll_BFu9ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu9ll_Sf, BFu0ll_BFu9ll_Sf)
//============================================================================



static void Test_BFu0ll_BFu9s_Sf()
{
  {
    init_simple_test("BFu0ll_BFu9s_Sf");
    static STRUCT_IF_C BFu0ll_BFu9s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_BFu9s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0ll_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0ll_BFu9s_Sf");
    check_field_offset(lv, v2, 2, "BFu0ll_BFu9s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_BFu9s_Sf, BFu0ll_BFu9s_Sf)
//============================================================================



static void Test_BFu0ll_C_Sf()
{
  {
    init_simple_test("BFu0ll_C_Sf");
    static STRUCT_IF_C BFu0ll_C_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_C_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_C_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_C_Sf.v1");
    check_field_offset(lv, v2, 1, "BFu0ll_C_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_C_Sf, BFu0ll_C_Sf)
//============================================================================



static void Test_BFu0ll_D_Sf()
{
  {
    init_simple_test("BFu0ll_D_Sf");
    static STRUCT_IF_C BFu0ll_D_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu0ll_D_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_D_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_D_Sf.v1");
    check_field_offset(lv, v2, 8, "BFu0ll_D_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_D_Sf, BFu0ll_D_Sf)
//============================================================================



static void Test_BFu0ll_F_Sf()
{
  {
    init_simple_test("BFu0ll_F_Sf");
    static STRUCT_IF_C BFu0ll_F_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_F_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_F_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_F_Sf.v1");
    check_field_offset(lv, v2, 4, "BFu0ll_F_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_F_Sf, BFu0ll_F_Sf)
//============================================================================



static void Test_BFu0ll_I_Sf()
{
  {
    init_simple_test("BFu0ll_I_Sf");
    static STRUCT_IF_C BFu0ll_I_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_I_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_I_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_I_Sf.v1");
    check_field_offset(lv, v2, 4, "BFu0ll_I_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_I_Sf, BFu0ll_I_Sf)
//============================================================================



static void Test_BFu0ll_Ip_Sf()
{
  {
    init_simple_test("BFu0ll_Ip_Sf");
    static STRUCT_IF_C BFu0ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0ll_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Ip_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_Ip_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0ll_Ip_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Ip_Sf, BFu0ll_Ip_Sf)
//============================================================================



static void Test_BFu0ll_L_Sf()
{
  {
    init_simple_test("BFu0ll_L_Sf");
    static STRUCT_IF_C BFu0ll_L_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu0ll_L_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_L_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_L_Sf.v1");
    check_field_offset(lv, v2, 8, "BFu0ll_L_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_L_Sf, BFu0ll_L_Sf)
//============================================================================



static void Test_BFu0ll_S_Sf()
{
  {
    init_simple_test("BFu0ll_S_Sf");
    static STRUCT_IF_C BFu0ll_S_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_S_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_S_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_S_Sf.v1");
    check_field_offset(lv, v2, 2, "BFu0ll_S_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_S_Sf, BFu0ll_S_Sf)
//============================================================================



static void Test_BFu0ll_Sf()
{
  {
    init_simple_test("BFu0ll_Sf");
    static STRUCT_IF_C BFu0ll_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf, BFu0ll_Sf)
//============================================================================



static void Test_BFu0ll_Sf_BFu0c()
{
  {
    init_simple_test("BFu0ll_Sf_BFu0c");
    static STRUCT_IF_C BFu0ll_Sf_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0ll_Sf_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu0c, BFu0ll_Sf_BFu0c)
//============================================================================



static void Test_BFu0ll_Sf_BFu0i()
{
  {
    init_simple_test("BFu0ll_Sf_BFu0i");
    static STRUCT_IF_C BFu0ll_Sf_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0ll_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu0i, BFu0ll_Sf_BFu0i)
//============================================================================



static void Test_BFu0ll_Sf_BFu0ll()
{
  {
    init_simple_test("BFu0ll_Sf_BFu0ll");
    static STRUCT_IF_C BFu0ll_Sf_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0ll_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu0ll, BFu0ll_Sf_BFu0ll)
//============================================================================



static void Test_BFu0ll_Sf_BFu0s()
{
  {
    init_simple_test("BFu0ll_Sf_BFu0s");
    static STRUCT_IF_C BFu0ll_Sf_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0ll_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu0s, BFu0ll_Sf_BFu0s)
//============================================================================



static void Test_BFu0ll_Sf_BFu15i()
{
  {
    init_simple_test("BFu0ll_Sf_BFu15i");
    static STRUCT_IF_C BFu0ll_Sf_BFu15i lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_Sf_BFu15i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu15i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "BFu0ll_Sf_BFu15i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "BFu0ll_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu15i, BFu0ll_Sf_BFu15i)
//============================================================================



static void Test_BFu0ll_Sf_BFu15ll()
{
  {
    init_simple_test("BFu0ll_Sf_BFu15ll");
    static STRUCT_IF_C BFu0ll_Sf_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu15ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "BFu0ll_Sf_BFu15ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "BFu0ll_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu15ll, BFu0ll_Sf_BFu15ll)
//============================================================================



static void Test_BFu0ll_Sf_BFu15s()
{
  {
    init_simple_test("BFu0ll_Sf_BFu15s");
    static STRUCT_IF_C BFu0ll_Sf_BFu15s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_Sf_BFu15s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu15s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "BFu0ll_Sf_BFu15s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "BFu0ll_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu15s, BFu0ll_Sf_BFu15s)
//============================================================================



static void Test_BFu0ll_Sf_BFu16i()
{
  {
    init_simple_test("BFu0ll_Sf_BFu16i");
    static STRUCT_IF_C BFu0ll_Sf_BFu16i lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_Sf_BFu16i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu16i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "BFu0ll_Sf_BFu16i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "BFu0ll_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu16i, BFu0ll_Sf_BFu16i)
//============================================================================



static void Test_BFu0ll_Sf_BFu16ll()
{
  {
    init_simple_test("BFu0ll_Sf_BFu16ll");
    static STRUCT_IF_C BFu0ll_Sf_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu16ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "BFu0ll_Sf_BFu16ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "BFu0ll_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu16ll, BFu0ll_Sf_BFu16ll)
//============================================================================



static void Test_BFu0ll_Sf_BFu16s()
{
  {
    init_simple_test("BFu0ll_Sf_BFu16s");
    static STRUCT_IF_C BFu0ll_Sf_BFu16s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_Sf_BFu16s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu16s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "BFu0ll_Sf_BFu16s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "BFu0ll_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu16s, BFu0ll_Sf_BFu16s)
//============================================================================



static void Test_BFu0ll_Sf_BFu17i()
{
  {
    init_simple_test("BFu0ll_Sf_BFu17i");
    static STRUCT_IF_C BFu0ll_Sf_BFu17i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu0ll_Sf_BFu17i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu17i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "BFu0ll_Sf_BFu17i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "BFu0ll_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu17i, BFu0ll_Sf_BFu17i)
//============================================================================



static void Test_BFu0ll_Sf_BFu17ll()
{
  {
    init_simple_test("BFu0ll_Sf_BFu17ll");
    static STRUCT_IF_C BFu0ll_Sf_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu0ll_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu17ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "BFu0ll_Sf_BFu17ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "BFu0ll_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu17ll, BFu0ll_Sf_BFu17ll)
//============================================================================



static void Test_BFu0ll_Sf_BFu1c()
{
  {
    init_simple_test("BFu0ll_Sf_BFu1c");
    static STRUCT_IF_C BFu0ll_Sf_BFu1c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu1c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0ll_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu1c, BFu0ll_Sf_BFu1c)
//============================================================================



static void Test_BFu0ll_Sf_BFu1i()
{
  {
    init_simple_test("BFu0ll_Sf_BFu1i");
    static STRUCT_IF_C BFu0ll_Sf_BFu1i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_BFu1i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu1i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0ll_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu1i, BFu0ll_Sf_BFu1i)
//============================================================================



static void Test_BFu0ll_Sf_BFu1ll()
{
  {
    init_simple_test("BFu0ll_Sf_BFu1ll");
    static STRUCT_IF_C BFu0ll_Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu1ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0ll_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu1ll, BFu0ll_Sf_BFu1ll)
//============================================================================



static void Test_BFu0ll_Sf_BFu1s()
{
  {
    init_simple_test("BFu0ll_Sf_BFu1s");
    static STRUCT_IF_C BFu0ll_Sf_BFu1s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_BFu1s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu1s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0ll_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu1s, BFu0ll_Sf_BFu1s)
//============================================================================



static void Test_BFu0ll_Sf_BFu31i()
{
  {
    init_simple_test("BFu0ll_Sf_BFu31i");
    static STRUCT_IF_C BFu0ll_Sf_BFu31i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_Sf_BFu31i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu31i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "BFu0ll_Sf_BFu31i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "BFu0ll_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu31i, BFu0ll_Sf_BFu31i)
//============================================================================



static void Test_BFu0ll_Sf_BFu31ll()
{
  {
    init_simple_test("BFu0ll_Sf_BFu31ll");
    static STRUCT_IF_C BFu0ll_Sf_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu31ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "BFu0ll_Sf_BFu31ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "BFu0ll_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu31ll, BFu0ll_Sf_BFu31ll)
//============================================================================



static void Test_BFu0ll_Sf_BFu32i()
{
  {
    init_simple_test("BFu0ll_Sf_BFu32i");
    static STRUCT_IF_C BFu0ll_Sf_BFu32i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_Sf_BFu32i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu32i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "BFu0ll_Sf_BFu32i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "BFu0ll_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu32i, BFu0ll_Sf_BFu32i)
//============================================================================



static void Test_BFu0ll_Sf_BFu32ll()
{
  {
    init_simple_test("BFu0ll_Sf_BFu32ll");
    static STRUCT_IF_C BFu0ll_Sf_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu32ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "BFu0ll_Sf_BFu32ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "BFu0ll_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu32ll, BFu0ll_Sf_BFu32ll)
//============================================================================



static void Test_BFu0ll_Sf_BFu33()
{
  {
    init_simple_test("BFu0ll_Sf_BFu33");
    static STRUCT_IF_C BFu0ll_Sf_BFu33 lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu0ll_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu33.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "BFu0ll_Sf_BFu33");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "BFu0ll_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu33, BFu0ll_Sf_BFu33)
//============================================================================



static void Test_BFu0ll_Sf_BFu7c()
{
  {
    init_simple_test("BFu0ll_Sf_BFu7c");
    static STRUCT_IF_C BFu0ll_Sf_BFu7c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu7c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0ll_Sf_BFu7c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0ll_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu7c, BFu0ll_Sf_BFu7c)
//============================================================================



static void Test_BFu0ll_Sf_BFu7i()
{
  {
    init_simple_test("BFu0ll_Sf_BFu7i");
    static STRUCT_IF_C BFu0ll_Sf_BFu7i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_BFu7i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu7i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0ll_Sf_BFu7i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0ll_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu7i, BFu0ll_Sf_BFu7i)
//============================================================================



static void Test_BFu0ll_Sf_BFu7ll()
{
  {
    init_simple_test("BFu0ll_Sf_BFu7ll");
    static STRUCT_IF_C BFu0ll_Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu7ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0ll_Sf_BFu7ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0ll_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu7ll, BFu0ll_Sf_BFu7ll)
//============================================================================



static void Test_BFu0ll_Sf_BFu7s()
{
  {
    init_simple_test("BFu0ll_Sf_BFu7s");
    static STRUCT_IF_C BFu0ll_Sf_BFu7s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_BFu7s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu7s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0ll_Sf_BFu7s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0ll_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu7s, BFu0ll_Sf_BFu7s)
//============================================================================



static void Test_BFu0ll_Sf_BFu8c()
{
  {
    init_simple_test("BFu0ll_Sf_BFu8c");
    static STRUCT_IF_C BFu0ll_Sf_BFu8c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu8c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0ll_Sf_BFu8c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0ll_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu8c, BFu0ll_Sf_BFu8c)
//============================================================================



static void Test_BFu0ll_Sf_BFu8i()
{
  {
    init_simple_test("BFu0ll_Sf_BFu8i");
    static STRUCT_IF_C BFu0ll_Sf_BFu8i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_BFu8i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu8i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0ll_Sf_BFu8i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0ll_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu8i, BFu0ll_Sf_BFu8i)
//============================================================================



static void Test_BFu0ll_Sf_BFu8ll()
{
  {
    init_simple_test("BFu0ll_Sf_BFu8ll");
    static STRUCT_IF_C BFu0ll_Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu8ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0ll_Sf_BFu8ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0ll_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu8ll, BFu0ll_Sf_BFu8ll)
//============================================================================



static void Test_BFu0ll_Sf_BFu8s()
{
  {
    init_simple_test("BFu0ll_Sf_BFu8s");
    static STRUCT_IF_C BFu0ll_Sf_BFu8s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_BFu8s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu8s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0ll_Sf_BFu8s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0ll_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu8s, BFu0ll_Sf_BFu8s)
//============================================================================



static void Test_BFu0ll_Sf_BFu9i()
{
  {
    init_simple_test("BFu0ll_Sf_BFu9i");
    static STRUCT_IF_C BFu0ll_Sf_BFu9i lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_Sf_BFu9i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu9i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "BFu0ll_Sf_BFu9i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "BFu0ll_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu9i, BFu0ll_Sf_BFu9i)
//============================================================================



static void Test_BFu0ll_Sf_BFu9ll()
{
  {
    init_simple_test("BFu0ll_Sf_BFu9ll");
    static STRUCT_IF_C BFu0ll_Sf_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu9ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "BFu0ll_Sf_BFu9ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "BFu0ll_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu9ll, BFu0ll_Sf_BFu9ll)
//============================================================================



static void Test_BFu0ll_Sf_BFu9s()
{
  {
    init_simple_test("BFu0ll_Sf_BFu9s");
    static STRUCT_IF_C BFu0ll_Sf_BFu9s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_Sf_BFu9s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_BFu9s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "BFu0ll_Sf_BFu9s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "BFu0ll_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_BFu9s, BFu0ll_Sf_BFu9s)
//============================================================================



static void Test_BFu0ll_Sf_C()
{
  {
    init_simple_test("BFu0ll_Sf_C");
    static STRUCT_IF_C BFu0ll_Sf_C lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_C)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_C.v1");
    check_field_offset(lv, v2, 0, "BFu0ll_Sf_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_C, BFu0ll_Sf_C)
//============================================================================



static void Test_BFu0ll_Sf_D()
{
  {
    init_simple_test("BFu0ll_Sf_D");
    static STRUCT_IF_C BFu0ll_Sf_D lv;
    check2(sizeof(lv), 8, "sizeof(BFu0ll_Sf_D)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_D)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_D.v1");
    check_field_offset(lv, v2, 0, "BFu0ll_Sf_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_D, BFu0ll_Sf_D)
//============================================================================



static void Test_BFu0ll_Sf_F()
{
  {
    init_simple_test("BFu0ll_Sf_F");
    static STRUCT_IF_C BFu0ll_Sf_F lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_Sf_F)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_F)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_F.v1");
    check_field_offset(lv, v2, 0, "BFu0ll_Sf_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_F, BFu0ll_Sf_F)
//============================================================================



static void Test_BFu0ll_Sf_I()
{
  {
    init_simple_test("BFu0ll_Sf_I");
    static STRUCT_IF_C BFu0ll_Sf_I lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_Sf_I)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_I)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_I.v1");
    check_field_offset(lv, v2, 0, "BFu0ll_Sf_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_I, BFu0ll_Sf_I)
//============================================================================



static void Test_BFu0ll_Sf_Ip()
{
  {
    init_simple_test("BFu0ll_Sf_Ip");
    static STRUCT_IF_C BFu0ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0ll_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_Ip)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_Ip.v1");
    check_field_offset(lv, v2, 0, "BFu0ll_Sf_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_Ip, BFu0ll_Sf_Ip)
//============================================================================



static void Test_BFu0ll_Sf_L()
{
  {
    init_simple_test("BFu0ll_Sf_L");
    static STRUCT_IF_C BFu0ll_Sf_L lv;
    check2(sizeof(lv), 8, "sizeof(BFu0ll_Sf_L)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_L)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_L.v1");
    check_field_offset(lv, v2, 0, "BFu0ll_Sf_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_L, BFu0ll_Sf_L)
//============================================================================



static void Test_BFu0ll_Sf_S()
{
  {
    init_simple_test("BFu0ll_Sf_S");
    static STRUCT_IF_C BFu0ll_Sf_S lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_Sf_S)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_S)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_S.v1");
    check_field_offset(lv, v2, 0, "BFu0ll_Sf_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_S, BFu0ll_Sf_S)
//============================================================================



static void Test_BFu0ll_Sf_Sf()
{
  {
    init_simple_test("BFu0ll_Sf_Sf");
    static STRUCT_IF_C BFu0ll_Sf_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0ll_Sf_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_Sf.v1");
    check_field_offset(lv, v2, 0, "BFu0ll_Sf_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_Sf, BFu0ll_Sf_Sf)
//============================================================================



static void Test_BFu0ll_Sf_Uc()
{
  {
    init_simple_test("BFu0ll_Sf_Uc");
    static STRUCT_IF_C BFu0ll_Sf_Uc lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Sf_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_Uc)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_Uc.v1");
    check_field_offset(lv, v2, 0, "BFu0ll_Sf_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_Uc, BFu0ll_Sf_Uc)
//============================================================================



static void Test_BFu0ll_Sf_Ui()
{
  {
    init_simple_test("BFu0ll_Sf_Ui");
    static STRUCT_IF_C BFu0ll_Sf_Ui lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_Sf_Ui)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_Ui)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_Ui.v1");
    check_field_offset(lv, v2, 0, "BFu0ll_Sf_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_Ui, BFu0ll_Sf_Ui)
//============================================================================



static void Test_BFu0ll_Sf_Ul()
{
  {
    init_simple_test("BFu0ll_Sf_Ul");
    static STRUCT_IF_C BFu0ll_Sf_Ul lv;
    check2(sizeof(lv), 8, "sizeof(BFu0ll_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_Ul)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_Ul.v1");
    check_field_offset(lv, v2, 0, "BFu0ll_Sf_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_Ul, BFu0ll_Sf_Ul)
//============================================================================



static void Test_BFu0ll_Sf_Us()
{
  {
    init_simple_test("BFu0ll_Sf_Us");
    static STRUCT_IF_C BFu0ll_Sf_Us lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_Sf_Us)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_Us)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_Us.v1");
    check_field_offset(lv, v2, 0, "BFu0ll_Sf_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_Us, BFu0ll_Sf_Us)
//============================================================================



static void Test_BFu0ll_Sf_Vp()
{
  {
    init_simple_test("BFu0ll_Sf_Vp");
    static STRUCT_IF_C BFu0ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0ll_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Sf_Vp)");
    check_field_offset(lv, v1, 0, "BFu0ll_Sf_Vp.v1");
    check_field_offset(lv, v2, 0, "BFu0ll_Sf_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Sf_Vp, BFu0ll_Sf_Vp)
//============================================================================



static void Test_BFu0ll_Uc_Sf()
{
  {
    init_simple_test("BFu0ll_Uc_Sf");
    static STRUCT_IF_C BFu0ll_Uc_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0ll_Uc_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Uc_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_Uc_Sf.v1");
    check_field_offset(lv, v2, 1, "BFu0ll_Uc_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Uc_Sf, BFu0ll_Uc_Sf)
//============================================================================



static void Test_BFu0ll_Ui_Sf()
{
  {
    init_simple_test("BFu0ll_Ui_Sf");
    static STRUCT_IF_C BFu0ll_Ui_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu0ll_Ui_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Ui_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_Ui_Sf.v1");
    check_field_offset(lv, v2, 4, "BFu0ll_Ui_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Ui_Sf, BFu0ll_Ui_Sf)
//============================================================================



static void Test_BFu0ll_Ul_Sf()
{
  {
    init_simple_test("BFu0ll_Ul_Sf");
    static STRUCT_IF_C BFu0ll_Ul_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu0ll_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Ul_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_Ul_Sf.v1");
    check_field_offset(lv, v2, 8, "BFu0ll_Ul_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Ul_Sf, BFu0ll_Ul_Sf)
//============================================================================



static void Test_BFu0ll_Us_Sf()
{
  {
    init_simple_test("BFu0ll_Us_Sf");
    static STRUCT_IF_C BFu0ll_Us_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0ll_Us_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Us_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_Us_Sf.v1");
    check_field_offset(lv, v2, 2, "BFu0ll_Us_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Us_Sf, BFu0ll_Us_Sf)
//============================================================================



static void Test_BFu0ll_Vp_Sf()
{
  {
    init_simple_test("BFu0ll_Vp_Sf");
    static STRUCT_IF_C BFu0ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0ll_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0ll_Vp_Sf)");
    check_field_offset(lv, v1, 0, "BFu0ll_Vp_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0ll_Vp_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0ll_Vp_Sf, BFu0ll_Vp_Sf)
//============================================================================



static void Test_BFu0s_BFu0c_Sf()
{
  {
    init_simple_test("BFu0s_BFu0c_Sf");
    static STRUCT_IF_C BFu0s_BFu0c_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0s_BFu0c_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu0c_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_BFu0c_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu0c_Sf, BFu0s_BFu0c_Sf)
//============================================================================



static void Test_BFu0s_BFu0i_Sf()
{
  {
    init_simple_test("BFu0s_BFu0i_Sf");
    static STRUCT_IF_C BFu0s_BFu0i_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0s_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu0i_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_BFu0i_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu0i_Sf, BFu0s_BFu0i_Sf)
//============================================================================



static void Test_BFu0s_BFu0ll_Sf()
{
  {
    init_simple_test("BFu0s_BFu0ll_Sf");
    static STRUCT_IF_C BFu0s_BFu0ll_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0s_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu0ll_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_BFu0ll_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu0ll_Sf, BFu0s_BFu0ll_Sf)
//============================================================================



static void Test_BFu0s_BFu0s_Sf()
{
  {
    init_simple_test("BFu0s_BFu0s_Sf");
    static STRUCT_IF_C BFu0s_BFu0s_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0s_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_BFu0s_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu0s_Sf, BFu0s_BFu0s_Sf)
//============================================================================



static void Test_BFu0s_BFu15i_Sf()
{
  {
    init_simple_test("BFu0s_BFu15i_Sf");
    static STRUCT_IF_C BFu0s_BFu15i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_BFu15i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0s_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0s_BFu15i_Sf");
    check_field_offset(lv, v2, 2, "BFu0s_BFu15i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu15i_Sf, BFu0s_BFu15i_Sf)
//============================================================================



static void Test_BFu0s_BFu15ll_Sf()
{
  {
    init_simple_test("BFu0s_BFu15ll_Sf");
    static STRUCT_IF_C BFu0s_BFu15ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0s_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0s_BFu15ll_Sf");
    check_field_offset(lv, v2, 2, "BFu0s_BFu15ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu15ll_Sf, BFu0s_BFu15ll_Sf)
//============================================================================



static void Test_BFu0s_BFu15s_Sf()
{
  {
    init_simple_test("BFu0s_BFu15s_Sf");
    static STRUCT_IF_C BFu0s_BFu15s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_BFu15s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0s_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0s_BFu15s_Sf");
    check_field_offset(lv, v2, 2, "BFu0s_BFu15s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu15s_Sf, BFu0s_BFu15s_Sf)
//============================================================================



static void Test_BFu0s_BFu16i_Sf()
{
  {
    init_simple_test("BFu0s_BFu16i_Sf");
    static STRUCT_IF_C BFu0s_BFu16i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_BFu16i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0s_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0s_BFu16i_Sf");
    check_field_offset(lv, v2, 2, "BFu0s_BFu16i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu16i_Sf, BFu0s_BFu16i_Sf)
//============================================================================



static void Test_BFu0s_BFu16ll_Sf()
{
  {
    init_simple_test("BFu0s_BFu16ll_Sf");
    static STRUCT_IF_C BFu0s_BFu16ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0s_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0s_BFu16ll_Sf");
    check_field_offset(lv, v2, 2, "BFu0s_BFu16ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu16ll_Sf, BFu0s_BFu16ll_Sf)
//============================================================================



static void Test_BFu0s_BFu16s_Sf()
{
  {
    init_simple_test("BFu0s_BFu16s_Sf");
    static STRUCT_IF_C BFu0s_BFu16s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_BFu16s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0s_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0s_BFu16s_Sf");
    check_field_offset(lv, v2, 2, "BFu0s_BFu16s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu16s_Sf, BFu0s_BFu16s_Sf)
//============================================================================



static void Test_BFu0s_BFu17i_Sf()
{
  {
    init_simple_test("BFu0s_BFu17i_Sf");
    static STRUCT_IF_C BFu0s_BFu17i_Sf lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu0s_BFu17i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0s_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0s_BFu17i_Sf");
    check_field_offset(lv, v2, 3, "BFu0s_BFu17i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu17i_Sf, BFu0s_BFu17i_Sf)
//============================================================================



static void Test_BFu0s_BFu17ll_Sf()
{
  {
    init_simple_test("BFu0s_BFu17ll_Sf");
    static STRUCT_IF_C BFu0s_BFu17ll_Sf lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu0s_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0s_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0s_BFu17ll_Sf");
    check_field_offset(lv, v2, 3, "BFu0s_BFu17ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu17ll_Sf, BFu0s_BFu17ll_Sf)
//============================================================================



static void Test_BFu0s_BFu1c_Sf()
{
  {
    init_simple_test("BFu0s_BFu1c_Sf");
    static STRUCT_IF_C BFu0s_BFu1c_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_BFu1c_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0s_BFu1c_Sf");
    check_field_offset(lv, v2, 1, "BFu0s_BFu1c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu1c_Sf, BFu0s_BFu1c_Sf)
//============================================================================



static void Test_BFu0s_BFu1i_Sf()
{
  {
    init_simple_test("BFu0s_BFu1i_Sf");
    static STRUCT_IF_C BFu0s_BFu1i_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_BFu1i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0s_BFu1i_Sf");
    check_field_offset(lv, v2, 1, "BFu0s_BFu1i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu1i_Sf, BFu0s_BFu1i_Sf)
//============================================================================



static void Test_BFu0s_BFu1ll_Sf()
{
  {
    init_simple_test("BFu0s_BFu1ll_Sf");
    static STRUCT_IF_C BFu0s_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0s_BFu1ll_Sf");
    check_field_offset(lv, v2, 1, "BFu0s_BFu1ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu1ll_Sf, BFu0s_BFu1ll_Sf)
//============================================================================



static void Test_BFu0s_BFu1s_Sf()
{
  {
    init_simple_test("BFu0s_BFu1s_Sf");
    static STRUCT_IF_C BFu0s_BFu1s_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_BFu1s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0s_BFu1s_Sf");
    check_field_offset(lv, v2, 1, "BFu0s_BFu1s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu1s_Sf, BFu0s_BFu1s_Sf)
//============================================================================



static void Test_BFu0s_BFu31i_Sf()
{
  {
    init_simple_test("BFu0s_BFu31i_Sf");
    static STRUCT_IF_C BFu0s_BFu31i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_BFu31i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0s_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0s_BFu31i_Sf");
    check_field_offset(lv, v2, 4, "BFu0s_BFu31i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu31i_Sf, BFu0s_BFu31i_Sf)
//============================================================================



static void Test_BFu0s_BFu31ll_Sf()
{
  {
    init_simple_test("BFu0s_BFu31ll_Sf");
    static STRUCT_IF_C BFu0s_BFu31ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0s_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0s_BFu31ll_Sf");
    check_field_offset(lv, v2, 4, "BFu0s_BFu31ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu31ll_Sf, BFu0s_BFu31ll_Sf)
//============================================================================



static void Test_BFu0s_BFu32i_Sf()
{
  {
    init_simple_test("BFu0s_BFu32i_Sf");
    static STRUCT_IF_C BFu0s_BFu32i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_BFu32i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0s_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0s_BFu32i_Sf");
    check_field_offset(lv, v2, 4, "BFu0s_BFu32i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu32i_Sf, BFu0s_BFu32i_Sf)
//============================================================================



static void Test_BFu0s_BFu32ll_Sf()
{
  {
    init_simple_test("BFu0s_BFu32ll_Sf");
    static STRUCT_IF_C BFu0s_BFu32ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0s_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0s_BFu32ll_Sf");
    check_field_offset(lv, v2, 4, "BFu0s_BFu32ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu32ll_Sf, BFu0s_BFu32ll_Sf)
//============================================================================



static void Test_BFu0s_BFu33_Sf()
{
  {
    init_simple_test("BFu0s_BFu33_Sf");
    static STRUCT_IF_C BFu0s_BFu33_Sf lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu0s_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0s_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0s_BFu33_Sf");
    check_field_offset(lv, v2, 5, "BFu0s_BFu33_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu33_Sf, BFu0s_BFu33_Sf)
//============================================================================



static void Test_BFu0s_BFu7c_Sf()
{
  {
    init_simple_test("BFu0s_BFu7c_Sf");
    static STRUCT_IF_C BFu0s_BFu7c_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_BFu7c_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0s_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0s_BFu7c_Sf");
    check_field_offset(lv, v2, 1, "BFu0s_BFu7c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu7c_Sf, BFu0s_BFu7c_Sf)
//============================================================================



static void Test_BFu0s_BFu7i_Sf()
{
  {
    init_simple_test("BFu0s_BFu7i_Sf");
    static STRUCT_IF_C BFu0s_BFu7i_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_BFu7i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0s_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0s_BFu7i_Sf");
    check_field_offset(lv, v2, 1, "BFu0s_BFu7i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu7i_Sf, BFu0s_BFu7i_Sf)
//============================================================================



static void Test_BFu0s_BFu7ll_Sf()
{
  {
    init_simple_test("BFu0s_BFu7ll_Sf");
    static STRUCT_IF_C BFu0s_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0s_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0s_BFu7ll_Sf");
    check_field_offset(lv, v2, 1, "BFu0s_BFu7ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu7ll_Sf, BFu0s_BFu7ll_Sf)
//============================================================================



static void Test_BFu0s_BFu7s_Sf()
{
  {
    init_simple_test("BFu0s_BFu7s_Sf");
    static STRUCT_IF_C BFu0s_BFu7s_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_BFu7s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0s_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0s_BFu7s_Sf");
    check_field_offset(lv, v2, 1, "BFu0s_BFu7s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu7s_Sf, BFu0s_BFu7s_Sf)
//============================================================================



static void Test_BFu0s_BFu8c_Sf()
{
  {
    init_simple_test("BFu0s_BFu8c_Sf");
    static STRUCT_IF_C BFu0s_BFu8c_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_BFu8c_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0s_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0s_BFu8c_Sf");
    check_field_offset(lv, v2, 1, "BFu0s_BFu8c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu8c_Sf, BFu0s_BFu8c_Sf)
//============================================================================



static void Test_BFu0s_BFu8i_Sf()
{
  {
    init_simple_test("BFu0s_BFu8i_Sf");
    static STRUCT_IF_C BFu0s_BFu8i_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_BFu8i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0s_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0s_BFu8i_Sf");
    check_field_offset(lv, v2, 1, "BFu0s_BFu8i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu8i_Sf, BFu0s_BFu8i_Sf)
//============================================================================



static void Test_BFu0s_BFu8ll_Sf()
{
  {
    init_simple_test("BFu0s_BFu8ll_Sf");
    static STRUCT_IF_C BFu0s_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0s_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0s_BFu8ll_Sf");
    check_field_offset(lv, v2, 1, "BFu0s_BFu8ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu8ll_Sf, BFu0s_BFu8ll_Sf)
//============================================================================



static void Test_BFu0s_BFu8s_Sf()
{
  {
    init_simple_test("BFu0s_BFu8s_Sf");
    static STRUCT_IF_C BFu0s_BFu8s_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_BFu8s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0s_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0s_BFu8s_Sf");
    check_field_offset(lv, v2, 1, "BFu0s_BFu8s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu8s_Sf, BFu0s_BFu8s_Sf)
//============================================================================



static void Test_BFu0s_BFu9i_Sf()
{
  {
    init_simple_test("BFu0s_BFu9i_Sf");
    static STRUCT_IF_C BFu0s_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_BFu9i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0s_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0s_BFu9i_Sf");
    check_field_offset(lv, v2, 2, "BFu0s_BFu9i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu9i_Sf, BFu0s_BFu9i_Sf)
//============================================================================



static void Test_BFu0s_BFu9ll_Sf()
{
  {
    init_simple_test("BFu0s_BFu9ll_Sf");
    static STRUCT_IF_C BFu0s_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0s_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0s_BFu9ll_Sf");
    check_field_offset(lv, v2, 2, "BFu0s_BFu9ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu9ll_Sf, BFu0s_BFu9ll_Sf)
//============================================================================



static void Test_BFu0s_BFu9s_Sf()
{
  {
    init_simple_test("BFu0s_BFu9s_Sf");
    static STRUCT_IF_C BFu0s_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_BFu9s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0s_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0s_BFu9s_Sf");
    check_field_offset(lv, v2, 2, "BFu0s_BFu9s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_BFu9s_Sf, BFu0s_BFu9s_Sf)
//============================================================================



static void Test_BFu0s_C_Sf()
{
  {
    init_simple_test("BFu0s_C_Sf");
    static STRUCT_IF_C BFu0s_C_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_C_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_C_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_C_Sf.v1");
    check_field_offset(lv, v2, 1, "BFu0s_C_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_Sf, BFu0s_C_Sf)
//============================================================================



static void Test_BFu0s_D_Sf()
{
  {
    init_simple_test("BFu0s_D_Sf");
    static STRUCT_IF_C BFu0s_D_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_D_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_D_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_D_Sf.v1");
    check_field_offset(lv, v2, 8, "BFu0s_D_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_Sf, BFu0s_D_Sf)
//============================================================================



static void Test_BFu0s_F_Sf()
{
  {
    init_simple_test("BFu0s_F_Sf");
    static STRUCT_IF_C BFu0s_F_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_F_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_F_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_F_Sf.v1");
    check_field_offset(lv, v2, 4, "BFu0s_F_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_Sf, BFu0s_F_Sf)
//============================================================================



static void Test_BFu0s_I_Sf()
{
  {
    init_simple_test("BFu0s_I_Sf");
    static STRUCT_IF_C BFu0s_I_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_I_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_I_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_I_Sf.v1");
    check_field_offset(lv, v2, 4, "BFu0s_I_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_Sf, BFu0s_I_Sf)
//============================================================================



static void Test_BFu0s_Ip_Sf()
{
  {
    init_simple_test("BFu0s_Ip_Sf");
    static STRUCT_IF_C BFu0s_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Ip_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ip_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_Sf, BFu0s_Ip_Sf)
//============================================================================



static void Test_BFu0s_L_Sf()
{
  {
    init_simple_test("BFu0s_L_Sf");
    static STRUCT_IF_C BFu0s_L_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_L_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_L_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_L_Sf.v1");
    check_field_offset(lv, v2, 8, "BFu0s_L_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_Sf, BFu0s_L_Sf)
//============================================================================



static void Test_BFu0s_S_Sf()
{
  {
    init_simple_test("BFu0s_S_Sf");
    static STRUCT_IF_C BFu0s_S_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_S_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_S_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_S_Sf.v1");
    check_field_offset(lv, v2, 2, "BFu0s_S_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_Sf, BFu0s_S_Sf)
//============================================================================



static void Test_BFu0s_Sf()
{
  {
    init_simple_test("BFu0s_Sf");
    static STRUCT_IF_C BFu0s_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf, BFu0s_Sf)
//============================================================================



static void Test_BFu0s_Sf_BFu0c()
{
  {
    init_simple_test("BFu0s_Sf_BFu0c");
    static STRUCT_IF_C BFu0s_Sf_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0s_Sf_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu0c, BFu0s_Sf_BFu0c)
//============================================================================



static void Test_BFu0s_Sf_BFu0i()
{
  {
    init_simple_test("BFu0s_Sf_BFu0i");
    static STRUCT_IF_C BFu0s_Sf_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0s_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu0i, BFu0s_Sf_BFu0i)
//============================================================================



static void Test_BFu0s_Sf_BFu0ll()
{
  {
    init_simple_test("BFu0s_Sf_BFu0ll");
    static STRUCT_IF_C BFu0s_Sf_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0s_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu0ll, BFu0s_Sf_BFu0ll)
//============================================================================



static void Test_BFu0s_Sf_BFu0s()
{
  {
    init_simple_test("BFu0s_Sf_BFu0s");
    static STRUCT_IF_C BFu0s_Sf_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0s_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu0s, BFu0s_Sf_BFu0s)
//============================================================================



static void Test_BFu0s_Sf_BFu15i()
{
  {
    init_simple_test("BFu0s_Sf_BFu15i");
    static STRUCT_IF_C BFu0s_Sf_BFu15i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Sf_BFu15i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu15i.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "BFu0s_Sf_BFu15i");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "BFu0s_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu15i, BFu0s_Sf_BFu15i)
//============================================================================



static void Test_BFu0s_Sf_BFu15ll()
{
  {
    init_simple_test("BFu0s_Sf_BFu15ll");
    static STRUCT_IF_C BFu0s_Sf_BFu15ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu15ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "BFu0s_Sf_BFu15ll");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "BFu0s_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu15ll, BFu0s_Sf_BFu15ll)
//============================================================================



static void Test_BFu0s_Sf_BFu15s()
{
  {
    init_simple_test("BFu0s_Sf_BFu15s");
    static STRUCT_IF_C BFu0s_Sf_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Sf_BFu15s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu15s.v1");
    set_bf_and_test(lv, v2, 0, 0, 15, 1, "BFu0s_Sf_BFu15s");
    set_bf_and_test(lv, v2, 0, 0, 15, hide_ull(1LL<<14), "BFu0s_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu15s, BFu0s_Sf_BFu15s)
//============================================================================



static void Test_BFu0s_Sf_BFu16i()
{
  {
    init_simple_test("BFu0s_Sf_BFu16i");
    static STRUCT_IF_C BFu0s_Sf_BFu16i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Sf_BFu16i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu16i.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "BFu0s_Sf_BFu16i");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "BFu0s_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu16i, BFu0s_Sf_BFu16i)
//============================================================================



static void Test_BFu0s_Sf_BFu16ll()
{
  {
    init_simple_test("BFu0s_Sf_BFu16ll");
    static STRUCT_IF_C BFu0s_Sf_BFu16ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu16ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "BFu0s_Sf_BFu16ll");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "BFu0s_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu16ll, BFu0s_Sf_BFu16ll)
//============================================================================



static void Test_BFu0s_Sf_BFu16s()
{
  {
    init_simple_test("BFu0s_Sf_BFu16s");
    static STRUCT_IF_C BFu0s_Sf_BFu16s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Sf_BFu16s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu16s.v1");
    set_bf_and_test(lv, v2, 0, 0, 16, 1, "BFu0s_Sf_BFu16s");
    set_bf_and_test(lv, v2, 0, 0, 16, hide_ull(1LL<<15), "BFu0s_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu16s, BFu0s_Sf_BFu16s)
//============================================================================



static void Test_BFu0s_Sf_BFu17i()
{
  {
    init_simple_test("BFu0s_Sf_BFu17i");
    static STRUCT_IF_C BFu0s_Sf_BFu17i lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu0s_Sf_BFu17i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu17i.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "BFu0s_Sf_BFu17i");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "BFu0s_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu17i, BFu0s_Sf_BFu17i)
//============================================================================



static void Test_BFu0s_Sf_BFu17ll()
{
  {
    init_simple_test("BFu0s_Sf_BFu17ll");
    static STRUCT_IF_C BFu0s_Sf_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu0s_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu17ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 17, 1, "BFu0s_Sf_BFu17ll");
    set_bf_and_test(lv, v2, 0, 0, 17, hide_ull(1LL<<16), "BFu0s_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu17ll, BFu0s_Sf_BFu17ll)
//============================================================================



static void Test_BFu0s_Sf_BFu1c()
{
  {
    init_simple_test("BFu0s_Sf_BFu1c");
    static STRUCT_IF_C BFu0s_Sf_BFu1c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu1c.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0s_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu1c, BFu0s_Sf_BFu1c)
//============================================================================



static void Test_BFu0s_Sf_BFu1i()
{
  {
    init_simple_test("BFu0s_Sf_BFu1i");
    static STRUCT_IF_C BFu0s_Sf_BFu1i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_BFu1i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu1i.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0s_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu1i, BFu0s_Sf_BFu1i)
//============================================================================



static void Test_BFu0s_Sf_BFu1ll()
{
  {
    init_simple_test("BFu0s_Sf_BFu1ll");
    static STRUCT_IF_C BFu0s_Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu1ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0s_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu1ll, BFu0s_Sf_BFu1ll)
//============================================================================



static void Test_BFu0s_Sf_BFu1s()
{
  {
    init_simple_test("BFu0s_Sf_BFu1s");
    static STRUCT_IF_C BFu0s_Sf_BFu1s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_BFu1s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu1s.v1");
    set_bf_and_test(lv, v2, 0, 0, 1, 1, "BFu0s_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu1s, BFu0s_Sf_BFu1s)
//============================================================================



static void Test_BFu0s_Sf_BFu31i()
{
  {
    init_simple_test("BFu0s_Sf_BFu31i");
    static STRUCT_IF_C BFu0s_Sf_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Sf_BFu31i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu31i.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "BFu0s_Sf_BFu31i");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "BFu0s_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu31i, BFu0s_Sf_BFu31i)
//============================================================================



static void Test_BFu0s_Sf_BFu31ll()
{
  {
    init_simple_test("BFu0s_Sf_BFu31ll");
    static STRUCT_IF_C BFu0s_Sf_BFu31ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu31ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 31, 1, "BFu0s_Sf_BFu31ll");
    set_bf_and_test(lv, v2, 0, 0, 31, hide_ull(1LL<<30), "BFu0s_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu31ll, BFu0s_Sf_BFu31ll)
//============================================================================



static void Test_BFu0s_Sf_BFu32i()
{
  {
    init_simple_test("BFu0s_Sf_BFu32i");
    static STRUCT_IF_C BFu0s_Sf_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Sf_BFu32i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu32i.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "BFu0s_Sf_BFu32i");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "BFu0s_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu32i, BFu0s_Sf_BFu32i)
//============================================================================



static void Test_BFu0s_Sf_BFu32ll()
{
  {
    init_simple_test("BFu0s_Sf_BFu32ll");
    static STRUCT_IF_C BFu0s_Sf_BFu32ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu32ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 32, 1, "BFu0s_Sf_BFu32ll");
    set_bf_and_test(lv, v2, 0, 0, 32, hide_ull(1LL<<31), "BFu0s_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu32ll, BFu0s_Sf_BFu32ll)
//============================================================================



static void Test_BFu0s_Sf_BFu33()
{
  {
    init_simple_test("BFu0s_Sf_BFu33");
    static STRUCT_IF_C BFu0s_Sf_BFu33 lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu0s_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu33.v1");
    set_bf_and_test(lv, v2, 0, 0, 33, 1, "BFu0s_Sf_BFu33");
    set_bf_and_test(lv, v2, 0, 0, 33, hide_ull(1LL<<32), "BFu0s_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu33, BFu0s_Sf_BFu33)
//============================================================================



static void Test_BFu0s_Sf_BFu7c()
{
  {
    init_simple_test("BFu0s_Sf_BFu7c");
    static STRUCT_IF_C BFu0s_Sf_BFu7c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu7c.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0s_Sf_BFu7c");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0s_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu7c, BFu0s_Sf_BFu7c)
//============================================================================



static void Test_BFu0s_Sf_BFu7i()
{
  {
    init_simple_test("BFu0s_Sf_BFu7i");
    static STRUCT_IF_C BFu0s_Sf_BFu7i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_BFu7i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu7i.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0s_Sf_BFu7i");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0s_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu7i, BFu0s_Sf_BFu7i)
//============================================================================



static void Test_BFu0s_Sf_BFu7ll()
{
  {
    init_simple_test("BFu0s_Sf_BFu7ll");
    static STRUCT_IF_C BFu0s_Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu7ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0s_Sf_BFu7ll");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0s_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu7ll, BFu0s_Sf_BFu7ll)
//============================================================================



static void Test_BFu0s_Sf_BFu7s()
{
  {
    init_simple_test("BFu0s_Sf_BFu7s");
    static STRUCT_IF_C BFu0s_Sf_BFu7s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_BFu7s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu7s.v1");
    set_bf_and_test(lv, v2, 0, 0, 7, 1, "BFu0s_Sf_BFu7s");
    set_bf_and_test(lv, v2, 0, 0, 7, hide_ull(1LL<<6), "BFu0s_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu7s, BFu0s_Sf_BFu7s)
//============================================================================



static void Test_BFu0s_Sf_BFu8c()
{
  {
    init_simple_test("BFu0s_Sf_BFu8c");
    static STRUCT_IF_C BFu0s_Sf_BFu8c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu8c.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0s_Sf_BFu8c");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0s_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu8c, BFu0s_Sf_BFu8c)
//============================================================================



static void Test_BFu0s_Sf_BFu8i()
{
  {
    init_simple_test("BFu0s_Sf_BFu8i");
    static STRUCT_IF_C BFu0s_Sf_BFu8i lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_BFu8i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu8i.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0s_Sf_BFu8i");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0s_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu8i, BFu0s_Sf_BFu8i)
//============================================================================



static void Test_BFu0s_Sf_BFu8ll()
{
  {
    init_simple_test("BFu0s_Sf_BFu8ll");
    static STRUCT_IF_C BFu0s_Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu8ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0s_Sf_BFu8ll");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0s_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu8ll, BFu0s_Sf_BFu8ll)
//============================================================================



static void Test_BFu0s_Sf_BFu8s()
{
  {
    init_simple_test("BFu0s_Sf_BFu8s");
    static STRUCT_IF_C BFu0s_Sf_BFu8s lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_BFu8s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu8s.v1");
    set_bf_and_test(lv, v2, 0, 0, 8, 1, "BFu0s_Sf_BFu8s");
    set_bf_and_test(lv, v2, 0, 0, 8, hide_ull(1LL<<7), "BFu0s_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu8s, BFu0s_Sf_BFu8s)
//============================================================================



static void Test_BFu0s_Sf_BFu9i()
{
  {
    init_simple_test("BFu0s_Sf_BFu9i");
    static STRUCT_IF_C BFu0s_Sf_BFu9i lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Sf_BFu9i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu9i.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "BFu0s_Sf_BFu9i");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "BFu0s_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu9i, BFu0s_Sf_BFu9i)
//============================================================================



static void Test_BFu0s_Sf_BFu9ll()
{
  {
    init_simple_test("BFu0s_Sf_BFu9ll");
    static STRUCT_IF_C BFu0s_Sf_BFu9ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu9ll.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "BFu0s_Sf_BFu9ll");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "BFu0s_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu9ll, BFu0s_Sf_BFu9ll)
//============================================================================



static void Test_BFu0s_Sf_BFu9s()
{
  {
    init_simple_test("BFu0s_Sf_BFu9s");
    static STRUCT_IF_C BFu0s_Sf_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Sf_BFu9s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_BFu9s.v1");
    set_bf_and_test(lv, v2, 0, 0, 9, 1, "BFu0s_Sf_BFu9s");
    set_bf_and_test(lv, v2, 0, 0, 9, hide_ull(1LL<<8), "BFu0s_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_BFu9s, BFu0s_Sf_BFu9s)
//============================================================================



static void Test_BFu0s_Sf_C()
{
  {
    init_simple_test("BFu0s_Sf_C");
    static STRUCT_IF_C BFu0s_Sf_C lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_C)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_C.v1");
    check_field_offset(lv, v2, 0, "BFu0s_Sf_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_C, BFu0s_Sf_C)
//============================================================================



static void Test_BFu0s_Sf_D()
{
  {
    init_simple_test("BFu0s_Sf_D");
    static STRUCT_IF_C BFu0s_Sf_D lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Sf_D)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_D)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_D.v1");
    check_field_offset(lv, v2, 0, "BFu0s_Sf_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_D, BFu0s_Sf_D)
//============================================================================



static void Test_BFu0s_Sf_F()
{
  {
    init_simple_test("BFu0s_Sf_F");
    static STRUCT_IF_C BFu0s_Sf_F lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Sf_F)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_F)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_F.v1");
    check_field_offset(lv, v2, 0, "BFu0s_Sf_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_F, BFu0s_Sf_F)
//============================================================================



static void Test_BFu0s_Sf_I()
{
  {
    init_simple_test("BFu0s_Sf_I");
    static STRUCT_IF_C BFu0s_Sf_I lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Sf_I)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_I)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_I.v1");
    check_field_offset(lv, v2, 0, "BFu0s_Sf_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_I, BFu0s_Sf_I)
//============================================================================



static void Test_BFu0s_Sf_Ip()
{
  {
    init_simple_test("BFu0s_Sf_Ip");
    static STRUCT_IF_C BFu0s_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_Ip.v1");
    check_field_offset(lv, v2, 0, "BFu0s_Sf_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_Ip, BFu0s_Sf_Ip)
//============================================================================



static void Test_BFu0s_Sf_L()
{
  {
    init_simple_test("BFu0s_Sf_L");
    static STRUCT_IF_C BFu0s_Sf_L lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Sf_L)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_L)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_L.v1");
    check_field_offset(lv, v2, 0, "BFu0s_Sf_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_L, BFu0s_Sf_L)
//============================================================================



static void Test_BFu0s_Sf_S()
{
  {
    init_simple_test("BFu0s_Sf_S");
    static STRUCT_IF_C BFu0s_Sf_S lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Sf_S)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_S)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_S.v1");
    check_field_offset(lv, v2, 0, "BFu0s_Sf_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_S, BFu0s_Sf_S)
//============================================================================



static void Test_BFu0s_Sf_Sf()
{
  {
    init_simple_test("BFu0s_Sf_Sf");
    static STRUCT_IF_C BFu0s_Sf_Sf lv;
    check2(sizeof(lv), 0, "sizeof(BFu0s_Sf_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_Sf.v1");
    check_field_offset(lv, v2, 0, "BFu0s_Sf_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_Sf, BFu0s_Sf_Sf)
//============================================================================



static void Test_BFu0s_Sf_Uc()
{
  {
    init_simple_test("BFu0s_Sf_Uc");
    static STRUCT_IF_C BFu0s_Sf_Uc lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Sf_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_Uc.v1");
    check_field_offset(lv, v2, 0, "BFu0s_Sf_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_Uc, BFu0s_Sf_Uc)
//============================================================================



static void Test_BFu0s_Sf_Ui()
{
  {
    init_simple_test("BFu0s_Sf_Ui");
    static STRUCT_IF_C BFu0s_Sf_Ui lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Sf_Ui)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_Ui.v1");
    check_field_offset(lv, v2, 0, "BFu0s_Sf_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_Ui, BFu0s_Sf_Ui)
//============================================================================



static void Test_BFu0s_Sf_Ul()
{
  {
    init_simple_test("BFu0s_Sf_Ul");
    static STRUCT_IF_C BFu0s_Sf_Ul lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_Ul.v1");
    check_field_offset(lv, v2, 0, "BFu0s_Sf_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_Ul, BFu0s_Sf_Ul)
//============================================================================



static void Test_BFu0s_Sf_Us()
{
  {
    init_simple_test("BFu0s_Sf_Us");
    static STRUCT_IF_C BFu0s_Sf_Us lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Sf_Us)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_Us.v1");
    check_field_offset(lv, v2, 0, "BFu0s_Sf_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_Us, BFu0s_Sf_Us)
//============================================================================



static void Test_BFu0s_Sf_Vp()
{
  {
    init_simple_test("BFu0s_Sf_Vp");
    static STRUCT_IF_C BFu0s_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Sf_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_Sf_Vp.v1");
    check_field_offset(lv, v2, 0, "BFu0s_Sf_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Sf_Vp, BFu0s_Sf_Vp)
//============================================================================



static void Test_BFu0s_Uc_Sf()
{
  {
    init_simple_test("BFu0s_Uc_Sf");
    static STRUCT_IF_C BFu0s_Uc_Sf lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Uc_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Uc_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_Sf.v1");
    check_field_offset(lv, v2, 1, "BFu0s_Uc_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_Sf, BFu0s_Uc_Sf)
//============================================================================



static void Test_BFu0s_Ui_Sf()
{
  {
    init_simple_test("BFu0s_Ui_Sf");
    static STRUCT_IF_C BFu0s_Ui_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Ui_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Ui_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_Sf.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Ui_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_Sf, BFu0s_Ui_Sf)
//============================================================================



static void Test_BFu0s_Ul_Sf()
{
  {
    init_simple_test("BFu0s_Ul_Sf");
    static STRUCT_IF_C BFu0s_Ul_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Ul_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_Sf.v1");
    check_field_offset(lv, v2, 8, "BFu0s_Ul_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_Sf, BFu0s_Ul_Sf)
//============================================================================



static void Test_BFu0s_Us_Sf()
{
  {
    init_simple_test("BFu0s_Us_Sf");
    static STRUCT_IF_C BFu0s_Us_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Us_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Us_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_Sf.v1");
    check_field_offset(lv, v2, 2, "BFu0s_Us_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_Sf, BFu0s_Us_Sf)
//============================================================================



static void Test_BFu0s_Vp_Sf()
{
  {
    init_simple_test("BFu0s_Vp_Sf");
    static STRUCT_IF_C BFu0s_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Vp_Sf)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Vp_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_Sf, BFu0s_Vp_Sf)
//============================================================================



static void Test_BFu15i_BFu0c_Sf()
{
  {
    init_simple_test("BFu15i_BFu0c_Sf");
    static STRUCT_IF_C BFu15i_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu15i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "BFu15i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_Sf, BFu15i_BFu0c_Sf)
//============================================================================



static void Test_BFu15i_BFu0i_Sf()
{
  {
    init_simple_test("BFu15i_BFu0i_Sf");
    static STRUCT_IF_C BFu15i_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu15i_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu15i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_Sf, BFu15i_BFu0i_Sf)
//============================================================================



static void Test_BFu15i_BFu0ll_Sf()
{
  {
    init_simple_test("BFu15i_BFu0ll_Sf");
    static STRUCT_IF_C BFu15i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_Sf, BFu15i_BFu0ll_Sf)
//============================================================================



static void Test_BFu15i_BFu0s_Sf()
{
  {
    init_simple_test("BFu15i_BFu0s_Sf");
    static STRUCT_IF_C BFu15i_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu15i_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "BFu15i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_Sf, BFu15i_BFu0s_Sf)
//============================================================================



static void Test_BFu15i_Sf_BFu0c()
{
  {
    init_simple_test("BFu15i_Sf_BFu0c");
    static STRUCT_IF_C BFu15i_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu15i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Sf_BFu0c, BFu15i_Sf_BFu0c)
//============================================================================



static void Test_BFu15i_Sf_BFu0i()
{
  {
    init_simple_test("BFu15i_Sf_BFu0i");
    static STRUCT_IF_C BFu15i_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu15i_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Sf_BFu0i, BFu15i_Sf_BFu0i)
//============================================================================



static void Test_BFu15i_Sf_BFu0ll()
{
  {
    init_simple_test("BFu15i_Sf_BFu0ll");
    static STRUCT_IF_C BFu15i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15i_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Sf_BFu0ll, BFu15i_Sf_BFu0ll)
//============================================================================



static void Test_BFu15i_Sf_BFu0s()
{
  {
    init_simple_test("BFu15i_Sf_BFu0s");
    static STRUCT_IF_C BFu15i_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu15i_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15i_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Sf_BFu0s, BFu15i_Sf_BFu0s)
//============================================================================



static void Test_BFu15ll_BFu0c_Sf()
{
  {
    init_simple_test("BFu15ll_BFu0c_Sf");
    static STRUCT_IF_C BFu15ll_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu15ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "BFu15ll_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_Sf, BFu15ll_BFu0c_Sf)
//============================================================================



static void Test_BFu15ll_BFu0i_Sf()
{
  {
    init_simple_test("BFu15ll_BFu0i_Sf");
    static STRUCT_IF_C BFu15ll_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu15ll_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15ll_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu15ll_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_Sf, BFu15ll_BFu0i_Sf)
//============================================================================



static void Test_BFu15ll_BFu0ll_Sf()
{
  {
    init_simple_test("BFu15ll_BFu0ll_Sf");
    static STRUCT_IF_C BFu15ll_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15ll_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_Sf, BFu15ll_BFu0ll_Sf)
//============================================================================



static void Test_BFu15ll_BFu0s_Sf()
{
  {
    init_simple_test("BFu15ll_BFu0s_Sf");
    static STRUCT_IF_C BFu15ll_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu15ll_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15ll_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "BFu15ll_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_Sf, BFu15ll_BFu0s_Sf)
//============================================================================



static void Test_BFu15ll_Sf_BFu0c()
{
  {
    init_simple_test("BFu15ll_Sf_BFu0c");
    static STRUCT_IF_C BFu15ll_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu15ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15ll_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Sf_BFu0c, BFu15ll_Sf_BFu0c)
//============================================================================



static void Test_BFu15ll_Sf_BFu0i()
{
  {
    init_simple_test("BFu15ll_Sf_BFu0i");
    static STRUCT_IF_C BFu15ll_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu15ll_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15ll_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Sf_BFu0i, BFu15ll_Sf_BFu0i)
//============================================================================



static void Test_BFu15ll_Sf_BFu0ll()
{
  {
    init_simple_test("BFu15ll_Sf_BFu0ll");
    static STRUCT_IF_C BFu15ll_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15ll_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Sf_BFu0ll, BFu15ll_Sf_BFu0ll)
//============================================================================



static void Test_BFu15ll_Sf_BFu0s()
{
  {
    init_simple_test("BFu15ll_Sf_BFu0s");
    static STRUCT_IF_C BFu15ll_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu15ll_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15ll_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Sf_BFu0s, BFu15ll_Sf_BFu0s)
//============================================================================



static void Test_BFu15s_BFu0c_Sf()
{
  {
    init_simple_test("BFu15s_BFu0c_Sf");
    static STRUCT_IF_C BFu15s_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu15s_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "BFu15s_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_Sf, BFu15s_BFu0c_Sf)
//============================================================================



static void Test_BFu15s_BFu0i_Sf()
{
  {
    init_simple_test("BFu15s_BFu0i_Sf");
    static STRUCT_IF_C BFu15s_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu15s_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15s_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu15s_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_Sf, BFu15s_BFu0i_Sf)
//============================================================================



static void Test_BFu15s_BFu0ll_Sf()
{
  {
    init_simple_test("BFu15s_BFu0ll_Sf");
    static STRUCT_IF_C BFu15s_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15s_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_Sf, BFu15s_BFu0ll_Sf)
//============================================================================



static void Test_BFu15s_BFu0s_Sf()
{
  {
    init_simple_test("BFu15s_BFu0s_Sf");
    static STRUCT_IF_C BFu15s_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu15s_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15s_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "BFu15s_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0s_Sf, BFu15s_BFu0s_Sf)
//============================================================================



static void Test_BFu15s_Sf_BFu0c()
{
  {
    init_simple_test("BFu15s_Sf_BFu0c");
    static STRUCT_IF_C BFu15s_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu15s_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu15s_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_Sf_BFu0c, BFu15s_Sf_BFu0c)
//============================================================================



static void Test_BFu15s_Sf_BFu0i()
{
  {
    init_simple_test("BFu15s_Sf_BFu0i");
    static STRUCT_IF_C BFu15s_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu15s_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15s_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_Sf_BFu0i, BFu15s_Sf_BFu0i)
//============================================================================



static void Test_BFu15s_Sf_BFu0ll()
{
  {
    init_simple_test("BFu15s_Sf_BFu0ll");
    static STRUCT_IF_C BFu15s_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15s_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_Sf_BFu0ll, BFu15s_Sf_BFu0ll)
//============================================================================



static void Test_BFu15s_Sf_BFu0s()
{
  {
    init_simple_test("BFu15s_Sf_BFu0s");
    static STRUCT_IF_C BFu15s_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu15s_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu15s_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_Sf_BFu0s, BFu15s_Sf_BFu0s)
//============================================================================



static void Test_BFu16i_BFu0c_Sf()
{
  {
    init_simple_test("BFu16i_BFu0c_Sf");
    static STRUCT_IF_C BFu16i_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu16i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "BFu16i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16i_BFu0c_Sf, BFu16i_BFu0c_Sf)
//============================================================================



static void Test_BFu16i_BFu0i_Sf()
{
  {
    init_simple_test("BFu16i_BFu0i_Sf");
    static STRUCT_IF_C BFu16i_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu16i_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu16i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16i_BFu0i_Sf, BFu16i_BFu0i_Sf)
//============================================================================



static void Test_BFu16i_BFu0ll_Sf()
{
  {
    init_simple_test("BFu16i_BFu0ll_Sf");
    static STRUCT_IF_C BFu16i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16i_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16i_BFu0ll_Sf, BFu16i_BFu0ll_Sf)
//============================================================================



static void Test_BFu16i_BFu0s_Sf()
{
  {
    init_simple_test("BFu16i_BFu0s_Sf");
    static STRUCT_IF_C BFu16i_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu16i_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "BFu16i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16i_BFu0s_Sf, BFu16i_BFu0s_Sf)
//============================================================================



static void Test_BFu16i_Sf_BFu0c()
{
  {
    init_simple_test("BFu16i_Sf_BFu0c");
    static STRUCT_IF_C BFu16i_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu16i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16i_Sf_BFu0c, BFu16i_Sf_BFu0c)
//============================================================================



static void Test_BFu16i_Sf_BFu0i()
{
  {
    init_simple_test("BFu16i_Sf_BFu0i");
    static STRUCT_IF_C BFu16i_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu16i_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16i_Sf_BFu0i, BFu16i_Sf_BFu0i)
//============================================================================



static void Test_BFu16i_Sf_BFu0ll()
{
  {
    init_simple_test("BFu16i_Sf_BFu0ll");
    static STRUCT_IF_C BFu16i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16i_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16i_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16i_Sf_BFu0ll, BFu16i_Sf_BFu0ll)
//============================================================================



static void Test_BFu16i_Sf_BFu0s()
{
  {
    init_simple_test("BFu16i_Sf_BFu0s");
    static STRUCT_IF_C BFu16i_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu16i_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16i_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16i_Sf_BFu0s, BFu16i_Sf_BFu0s)
//============================================================================



static void Test_BFu16ll_BFu0c_Sf()
{
  {
    init_simple_test("BFu16ll_BFu0c_Sf");
    static STRUCT_IF_C BFu16ll_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu16ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "BFu16ll_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16ll_BFu0c_Sf, BFu16ll_BFu0c_Sf)
//============================================================================



static void Test_BFu16ll_BFu0i_Sf()
{
  {
    init_simple_test("BFu16ll_BFu0i_Sf");
    static STRUCT_IF_C BFu16ll_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu16ll_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16ll_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu16ll_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16ll_BFu0i_Sf, BFu16ll_BFu0i_Sf)
//============================================================================



static void Test_BFu16ll_BFu0ll_Sf()
{
  {
    init_simple_test("BFu16ll_BFu0ll_Sf");
    static STRUCT_IF_C BFu16ll_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16ll_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16ll_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16ll_BFu0ll_Sf, BFu16ll_BFu0ll_Sf)
//============================================================================



static void Test_BFu16ll_BFu0s_Sf()
{
  {
    init_simple_test("BFu16ll_BFu0s_Sf");
    static STRUCT_IF_C BFu16ll_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu16ll_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16ll_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "BFu16ll_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16ll_BFu0s_Sf, BFu16ll_BFu0s_Sf)
//============================================================================



static void Test_BFu16ll_Sf_BFu0c()
{
  {
    init_simple_test("BFu16ll_Sf_BFu0c");
    static STRUCT_IF_C BFu16ll_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu16ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16ll_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16ll_Sf_BFu0c, BFu16ll_Sf_BFu0c)
//============================================================================



static void Test_BFu16ll_Sf_BFu0i()
{
  {
    init_simple_test("BFu16ll_Sf_BFu0i");
    static STRUCT_IF_C BFu16ll_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu16ll_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16ll_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16ll_Sf_BFu0i, BFu16ll_Sf_BFu0i)
//============================================================================



static void Test_BFu16ll_Sf_BFu0ll()
{
  {
    init_simple_test("BFu16ll_Sf_BFu0ll");
    static STRUCT_IF_C BFu16ll_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16ll_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16ll_Sf_BFu0ll, BFu16ll_Sf_BFu0ll)
//============================================================================



static void Test_BFu16ll_Sf_BFu0s()
{
  {
    init_simple_test("BFu16ll_Sf_BFu0s");
    static STRUCT_IF_C BFu16ll_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu16ll_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16ll_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16ll_Sf_BFu0s, BFu16ll_Sf_BFu0s)
//============================================================================



static void Test_BFu16s_BFu0c_Sf()
{
  {
    init_simple_test("BFu16s_BFu0c_Sf");
    static STRUCT_IF_C BFu16s_BFu0c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu16s_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16s_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu0c_Sf");
    check_field_offset(lv, v2, 2, "BFu16s_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16s_BFu0c_Sf, BFu16s_BFu0c_Sf)
//============================================================================



static void Test_BFu16s_BFu0i_Sf()
{
  {
    init_simple_test("BFu16s_BFu0i_Sf");
    static STRUCT_IF_C BFu16s_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu16s_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16s_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu16s_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16s_BFu0i_Sf, BFu16s_BFu0i_Sf)
//============================================================================



static void Test_BFu16s_BFu0ll_Sf()
{
  {
    init_simple_test("BFu16s_BFu0ll_Sf");
    static STRUCT_IF_C BFu16s_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16s_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16s_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16s_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16s_BFu0ll_Sf, BFu16s_BFu0ll_Sf)
//============================================================================



static void Test_BFu16s_BFu0s_Sf()
{
  {
    init_simple_test("BFu16s_BFu0s_Sf");
    static STRUCT_IF_C BFu16s_BFu0s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu16s_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16s_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu0s_Sf");
    check_field_offset(lv, v2, 2, "BFu16s_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16s_BFu0s_Sf, BFu16s_BFu0s_Sf)
//============================================================================



static void Test_BFu16s_Sf_BFu0c()
{
  {
    init_simple_test("BFu16s_Sf_BFu0c");
    static STRUCT_IF_C BFu16s_Sf_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu16s_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu16s_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu0c");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16s_Sf_BFu0c, BFu16s_Sf_BFu0c)
//============================================================================



static void Test_BFu16s_Sf_BFu0i()
{
  {
    init_simple_test("BFu16s_Sf_BFu0i");
    static STRUCT_IF_C BFu16s_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu16s_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16s_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu0i");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16s_Sf_BFu0i, BFu16s_Sf_BFu0i)
//============================================================================



static void Test_BFu16s_Sf_BFu0ll()
{
  {
    init_simple_test("BFu16s_Sf_BFu0ll");
    static STRUCT_IF_C BFu16s_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16s_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16s_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16s_Sf_BFu0ll, BFu16s_Sf_BFu0ll)
//============================================================================



static void Test_BFu16s_Sf_BFu0s()
{
  {
    init_simple_test("BFu16s_Sf_BFu0s");
    static STRUCT_IF_C BFu16s_Sf_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu16s_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu16s_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu0s");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu16s_Sf_BFu0s, BFu16s_Sf_BFu0s)
//============================================================================



static void Test_BFu17i_BFu0c_Sf()
{
  {
    init_simple_test("BFu17i_BFu0c_Sf");
    static STRUCT_IF_C BFu17i_BFu0c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu17i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu17i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu0c_Sf");
    check_field_offset(lv, v2, 3, "BFu17i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17i_BFu0c_Sf, BFu17i_BFu0c_Sf)
//============================================================================



static void Test_BFu17i_BFu0i_Sf()
{
  {
    init_simple_test("BFu17i_BFu0i_Sf");
    static STRUCT_IF_C BFu17i_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu17i_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu17i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu17i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17i_BFu0i_Sf, BFu17i_BFu0i_Sf)
//============================================================================



static void Test_BFu17i_BFu0ll_Sf()
{
  {
    init_simple_test("BFu17i_BFu0ll_Sf");
    static STRUCT_IF_C BFu17i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17i_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu17i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17i_BFu0ll_Sf, BFu17i_BFu0ll_Sf)
//============================================================================



static void Test_BFu17i_BFu0s_Sf()
{
  {
    init_simple_test("BFu17i_BFu0s_Sf");
    static STRUCT_IF_C BFu17i_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu17i_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu17i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu17i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17i_BFu0s_Sf, BFu17i_BFu0s_Sf)
//============================================================================



static void Test_BFu17i_Sf_BFu0c()
{
  {
    init_simple_test("BFu17i_Sf_BFu0c");
    static STRUCT_IF_C BFu17i_Sf_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(BFu17i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu17i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu0c");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17i_Sf_BFu0c, BFu17i_Sf_BFu0c)
//============================================================================



static void Test_BFu17i_Sf_BFu0i()
{
  {
    init_simple_test("BFu17i_Sf_BFu0i");
    static STRUCT_IF_C BFu17i_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu17i_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu17i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu0i");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17i_Sf_BFu0i, BFu17i_Sf_BFu0i)
//============================================================================



static void Test_BFu17i_Sf_BFu0ll()
{
  {
    init_simple_test("BFu17i_Sf_BFu0ll");
    static STRUCT_IF_C BFu17i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17i_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu17i_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu0ll");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17i_Sf_BFu0ll, BFu17i_Sf_BFu0ll)
//============================================================================



static void Test_BFu17i_Sf_BFu0s()
{
  {
    init_simple_test("BFu17i_Sf_BFu0s");
    static STRUCT_IF_C BFu17i_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu17i_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu17i_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu0s");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17i_Sf_BFu0s, BFu17i_Sf_BFu0s)
//============================================================================



static void Test_BFu17ll_BFu0c_Sf()
{
  {
    init_simple_test("BFu17ll_BFu0c_Sf");
    static STRUCT_IF_C BFu17ll_BFu0c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu17ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu17ll_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0c_Sf");
    check_field_offset(lv, v2, 3, "BFu17ll_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0c_Sf, BFu17ll_BFu0c_Sf)
//============================================================================



static void Test_BFu17ll_BFu0i_Sf()
{
  {
    init_simple_test("BFu17ll_BFu0i_Sf");
    static STRUCT_IF_C BFu17ll_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu17ll_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu17ll_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu17ll_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0i_Sf, BFu17ll_BFu0i_Sf)
//============================================================================



static void Test_BFu17ll_BFu0ll_Sf()
{
  {
    init_simple_test("BFu17ll_BFu0ll_Sf");
    static STRUCT_IF_C BFu17ll_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu17ll_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_Sf, BFu17ll_BFu0ll_Sf)
//============================================================================



static void Test_BFu17ll_BFu0s_Sf()
{
  {
    init_simple_test("BFu17ll_BFu0s_Sf");
    static STRUCT_IF_C BFu17ll_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu17ll_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu17ll_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu17ll_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_Sf, BFu17ll_BFu0s_Sf)
//============================================================================



static void Test_BFu17ll_Sf_BFu0c()
{
  {
    init_simple_test("BFu17ll_Sf_BFu0c");
    static STRUCT_IF_C BFu17ll_Sf_BFu0c lv;
    check2(sizeof(lv), 3, "sizeof(BFu17ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu17ll_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu0c");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Sf_BFu0c, BFu17ll_Sf_BFu0c)
//============================================================================



static void Test_BFu17ll_Sf_BFu0i()
{
  {
    init_simple_test("BFu17ll_Sf_BFu0i");
    static STRUCT_IF_C BFu17ll_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu17ll_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu17ll_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu0i");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Sf_BFu0i, BFu17ll_Sf_BFu0i)
//============================================================================



static void Test_BFu17ll_Sf_BFu0ll()
{
  {
    init_simple_test("BFu17ll_Sf_BFu0ll");
    static STRUCT_IF_C BFu17ll_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu17ll_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu0ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Sf_BFu0ll, BFu17ll_Sf_BFu0ll)
//============================================================================



static void Test_BFu17ll_Sf_BFu0s()
{
  {
    init_simple_test("BFu17ll_Sf_BFu0s");
    static STRUCT_IF_C BFu17ll_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu17ll_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu17ll_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu0s");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Sf_BFu0s, BFu17ll_Sf_BFu0s)
//============================================================================



static void Test_BFu1c_BFu0c_Sf()
{
  {
    init_simple_test("BFu1c_BFu0c_Sf");
    static STRUCT_IF_C BFu1c_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "BFu1c_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_Sf, BFu1c_BFu0c_Sf)
//============================================================================



static void Test_BFu1c_BFu0i_Sf()
{
  {
    init_simple_test("BFu1c_BFu0i_Sf");
    static STRUCT_IF_C BFu1c_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu1c_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu1c_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_Sf, BFu1c_BFu0i_Sf)
//============================================================================



static void Test_BFu1c_BFu0ll_Sf()
{
  {
    init_simple_test("BFu1c_BFu0ll_Sf");
    static STRUCT_IF_C BFu1c_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_Sf, BFu1c_BFu0ll_Sf)
//============================================================================



static void Test_BFu1c_BFu0s_Sf()
{
  {
    init_simple_test("BFu1c_BFu0s_Sf");
    static STRUCT_IF_C BFu1c_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu1c_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "BFu1c_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_Sf, BFu1c_BFu0s_Sf)
//============================================================================



static void Test_BFu1c_Sf_BFu0c()
{
  {
    init_simple_test("BFu1c_Sf_BFu0c");
    static STRUCT_IF_C BFu1c_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Sf_BFu0c, BFu1c_Sf_BFu0c)
//============================================================================



static void Test_BFu1c_Sf_BFu0i()
{
  {
    init_simple_test("BFu1c_Sf_BFu0i");
    static STRUCT_IF_C BFu1c_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu1c_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Sf_BFu0i, BFu1c_Sf_BFu0i)
//============================================================================



static void Test_BFu1c_Sf_BFu0ll()
{
  {
    init_simple_test("BFu1c_Sf_BFu0ll");
    static STRUCT_IF_C BFu1c_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Sf_BFu0ll, BFu1c_Sf_BFu0ll)
//============================================================================



static void Test_BFu1c_Sf_BFu0s()
{
  {
    init_simple_test("BFu1c_Sf_BFu0s");
    static STRUCT_IF_C BFu1c_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu1c_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Sf_BFu0s, BFu1c_Sf_BFu0s)
//============================================================================



static void Test_BFu1i_BFu0c_Sf()
{
  {
    init_simple_test("BFu1i_BFu0c_Sf");
    static STRUCT_IF_C BFu1i_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu1i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "BFu1i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_Sf, BFu1i_BFu0c_Sf)
//============================================================================



static void Test_BFu1i_BFu0i_Sf()
{
  {
    init_simple_test("BFu1i_BFu0i_Sf");
    static STRUCT_IF_C BFu1i_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu1i_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu1i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_Sf, BFu1i_BFu0i_Sf)
//============================================================================



static void Test_BFu1i_BFu0ll_Sf()
{
  {
    init_simple_test("BFu1i_BFu0ll_Sf");
    static STRUCT_IF_C BFu1i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_Sf, BFu1i_BFu0ll_Sf)
//============================================================================



static void Test_BFu1i_BFu0s_Sf()
{
  {
    init_simple_test("BFu1i_BFu0s_Sf");
    static STRUCT_IF_C BFu1i_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu1i_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "BFu1i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_Sf, BFu1i_BFu0s_Sf)
//============================================================================



static void Test_BFu1i_Sf_BFu0c()
{
  {
    init_simple_test("BFu1i_Sf_BFu0c");
    static STRUCT_IF_C BFu1i_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Sf_BFu0c, BFu1i_Sf_BFu0c)
//============================================================================



static void Test_BFu1i_Sf_BFu0i()
{
  {
    init_simple_test("BFu1i_Sf_BFu0i");
    static STRUCT_IF_C BFu1i_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu1i_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Sf_BFu0i, BFu1i_Sf_BFu0i)
//============================================================================



static void Test_BFu1i_Sf_BFu0ll()
{
  {
    init_simple_test("BFu1i_Sf_BFu0ll");
    static STRUCT_IF_C BFu1i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1i_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Sf_BFu0ll, BFu1i_Sf_BFu0ll)
//============================================================================



static void Test_BFu1i_Sf_BFu0s()
{
  {
    init_simple_test("BFu1i_Sf_BFu0s");
    static STRUCT_IF_C BFu1i_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu1i_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1i_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Sf_BFu0s, BFu1i_Sf_BFu0s)
//============================================================================



static void Test_BFu1ll_BFu0c_Sf()
{
  {
    init_simple_test("BFu1ll_BFu0c_Sf");
    static STRUCT_IF_C BFu1ll_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu1ll_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1ll_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "BFu1ll_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_Sf, BFu1ll_BFu0c_Sf)
//============================================================================



static void Test_BFu1ll_BFu0i_Sf()
{
  {
    init_simple_test("BFu1ll_BFu0i_Sf");
    static STRUCT_IF_C BFu1ll_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu1ll_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1ll_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu1ll_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_Sf, BFu1ll_BFu0i_Sf)
//============================================================================



static void Test_BFu1ll_BFu0ll_Sf()
{
  {
    init_simple_test("BFu1ll_BFu0ll_Sf");
    static STRUCT_IF_C BFu1ll_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1ll_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_Sf, BFu1ll_BFu0ll_Sf)
//============================================================================



static void Test_BFu1ll_BFu0s_Sf()
{
  {
    init_simple_test("BFu1ll_BFu0s_Sf");
    static STRUCT_IF_C BFu1ll_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu1ll_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1ll_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "BFu1ll_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_Sf, BFu1ll_BFu0s_Sf)
//============================================================================



static void Test_BFu1ll_Sf_BFu0c()
{
  {
    init_simple_test("BFu1ll_Sf_BFu0c");
    static STRUCT_IF_C BFu1ll_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1ll_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1ll_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Sf_BFu0c, BFu1ll_Sf_BFu0c)
//============================================================================



static void Test_BFu1ll_Sf_BFu0i()
{
  {
    init_simple_test("BFu1ll_Sf_BFu0i");
    static STRUCT_IF_C BFu1ll_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu1ll_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1ll_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Sf_BFu0i, BFu1ll_Sf_BFu0i)
//============================================================================



static void Test_BFu1ll_Sf_BFu0ll()
{
  {
    init_simple_test("BFu1ll_Sf_BFu0ll");
    static STRUCT_IF_C BFu1ll_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1ll_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Sf_BFu0ll, BFu1ll_Sf_BFu0ll)
//============================================================================



static void Test_BFu1ll_Sf_BFu0s()
{
  {
    init_simple_test("BFu1ll_Sf_BFu0s");
    static STRUCT_IF_C BFu1ll_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu1ll_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1ll_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Sf_BFu0s, BFu1ll_Sf_BFu0s)
//============================================================================



static void Test_BFu1s_BFu0c_Sf()
{
  {
    init_simple_test("BFu1s_BFu0c_Sf");
    static STRUCT_IF_C BFu1s_BFu0c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu1s_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1s_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_Sf");
    check_field_offset(lv, v2, 1, "BFu1s_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_Sf, BFu1s_BFu0c_Sf)
//============================================================================



static void Test_BFu1s_BFu0i_Sf()
{
  {
    init_simple_test("BFu1s_BFu0i_Sf");
    static STRUCT_IF_C BFu1s_BFu0i_Sf lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu1s_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1s_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_Sf");
    check_field_offset(lv, v2, ABISELECT(4,4), "BFu1s_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_Sf, BFu1s_BFu0i_Sf)
//============================================================================



static void Test_BFu1s_BFu0ll_Sf()
{
  {
    init_simple_test("BFu1s_BFu0ll_Sf");
    static STRUCT_IF_C BFu1s_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1s_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0ll_Sf, BFu1s_BFu0ll_Sf)
//============================================================================



static void Test_BFu1s_BFu0s_Sf()
{
  {
    init_simple_test("BFu1s_BFu0s_Sf");
    static STRUCT_IF_C BFu1s_BFu0s_Sf lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu1s_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1s_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0s_Sf");
    check_field_offset(lv, v2, ABISELECT(2,2), "BFu1s_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0s_Sf, BFu1s_BFu0s_Sf)
//============================================================================



static void Test_BFu1s_Sf_BFu0c()
{
  {
    init_simple_test("BFu1s_Sf_BFu0c");
    static STRUCT_IF_C BFu1s_Sf_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1s_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1s_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu0c");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_Sf_BFu0c, BFu1s_Sf_BFu0c)
//============================================================================



static void Test_BFu1s_Sf_BFu0i()
{
  {
    init_simple_test("BFu1s_Sf_BFu0i");
    static STRUCT_IF_C BFu1s_Sf_BFu0i lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(BFu1s_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1s_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu0i");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_Sf_BFu0i, BFu1s_Sf_BFu0i)
//============================================================================



static void Test_BFu1s_Sf_BFu0ll()
{
  {
    init_simple_test("BFu1s_Sf_BFu0ll");
    static STRUCT_IF_C BFu1s_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1s_Sf_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_Sf_BFu0ll, BFu1s_Sf_BFu0ll)
//============================================================================



static void Test_BFu1s_Sf_BFu0s()
{
  {
    init_simple_test("BFu1s_Sf_BFu0s");
    static STRUCT_IF_C BFu1s_Sf_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu1s_Sf_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1s_Sf_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu0s");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_Sf_BFu0s, BFu1s_Sf_BFu0s)
//============================================================================



static void Test_BFu31i_BFu0c_Sf()
{
  {
    init_simple_test("BFu31i_BFu0c_Sf");
    static STRUCT_IF_C BFu31i_BFu0c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu31i_BFu0c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu0c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu0c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu0c_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_BFu0c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu0c_Sf, BFu31i_BFu0c_Sf)
//============================================================================



static void Test_BFu31i_BFu0i_Sf()
{
  {
    init_simple_test("BFu31i_BFu0i_Sf");
    static STRUCT_IF_C BFu31i_BFu0i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu31i_BFu0i_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu31i_BFu0i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu0i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu0i_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_BFu0i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu0i_Sf, BFu31i_BFu0i_Sf)
//============================================================================



static void Test_BFu31i_BFu0ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu0ll_Sf");
    static STRUCT_IF_C BFu31i_BFu0ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu31i_BFu0ll_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu31i_BFu0ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu0ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu0ll_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu31i_BFu0ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu0ll_Sf, BFu31i_BFu0ll_Sf)
//============================================================================



static void Test_BFu31i_BFu0s_Sf()
{
  {
    init_simple_test("BFu31i_BFu0s_Sf");
    static STRUCT_IF_C BFu31i_BFu0s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu31i_BFu0s_Sf)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu31i_BFu0s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu0s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu0s_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_BFu0s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu0s_Sf, BFu31i_BFu0s_Sf)
//============================================================================



static void Test_BFu31i_Sf_BFu0c()
{
  {
    init_simple_test("BFu31i_Sf_BFu0c");
    static STRUCT_IF_C BFu31i_Sf_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu31i_Sf_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu0c");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu0c, BFu31i_Sf_BFu0c)
//============================================================================



static void Test_BFu31i_Sf_BFu0i()
{
  {
    init_simple_test("BFu31i_Sf_BFu0i");
    static STRUCT_IF_C BFu31i_Sf_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu31i_Sf_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu31i_Sf_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu0i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu0i, BFu31i_Sf_BFu0i)
//============================================================================



static void Test_BFu31i_Sf_BFu0ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu0ll");
    static STRUCT_IF_C BFu31i_Sf_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu31i_Sf_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu31i_Sf_BFu0ll)");
    