// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
#include "testsuite.h"
typedef struct empty {} empty;
#pragma pack(1)
struct BFu31i_BFu31ll_Sf { unsigned int v1:31; unsigned long long v2:31; empty v3; };
struct BFu31i_BFu32i_Sf { unsigned int v1:31; unsigned int v2:32; empty v3; };
struct BFu31i_BFu32ll_Sf { unsigned int v1:31; unsigned long long v2:32; empty v3; };
struct BFu31i_BFu33_Sf { unsigned int v1:31; unsigned long long v2:33; empty v3; };
struct BFu31i_BFu7c_Sf { unsigned int v1:31; unsigned char v2:7; empty v3; };
struct BFu31i_BFu7i_Sf { unsigned int v1:31; unsigned int v2:7; empty v3; };
struct BFu31i_BFu7ll_Sf { unsigned int v1:31; unsigned long long v2:7; empty v3; };
struct BFu31i_BFu7s_Sf { unsigned int v1:31; unsigned short v2:7; empty v3; };
struct BFu31i_BFu8c_Sf { unsigned int v1:31; unsigned char v2:8; empty v3; };
struct BFu31i_BFu8i_Sf { unsigned int v1:31; unsigned int v2:8; empty v3; };
struct BFu31i_BFu8ll_Sf { unsigned int v1:31; unsigned long long v2:8; empty v3; };
struct BFu31i_BFu8s_Sf { unsigned int v1:31; unsigned short v2:8; empty v3; };
struct BFu31i_BFu9i_Sf { unsigned int v1:31; unsigned int v2:9; empty v3; };
struct BFu31i_BFu9ll_Sf { unsigned int v1:31; unsigned long long v2:9; empty v3; };
struct BFu31i_BFu9s_Sf { unsigned int v1:31; unsigned short v2:9; empty v3; };
struct BFu31i_C_Sf { unsigned int v1:31; char v2; empty v3; };
struct BFu31i_D_Sf { unsigned int v1:31; double v2; empty v3; };
struct BFu31i_F_Sf { unsigned int v1:31; float v2; empty v3; };
struct BFu31i_I_Sf { unsigned int v1:31; int v2; empty v3; };
struct BFu31i_Ip_Sf { unsigned int v1:31; int * v2; empty v3; };
struct BFu31i_L_Sf { unsigned int v1:31; long long v2; empty v3; };
struct BFu31i_S_Sf { unsigned int v1:31; short v2; empty v3; };
struct BFu31i_Sf { unsigned int v1:31; empty v2; };
struct BFu31i_Sf_BFu15i { unsigned int v1:31; empty v2; unsigned int v3:15; };
struct BFu31i_Sf_BFu15ll { unsigned int v1:31; empty v2; unsigned long long v3:15; };
struct BFu31i_Sf_BFu15s { unsigned int v1:31; empty v2; unsigned short v3:15; };
struct BFu31i_Sf_BFu16i { unsigned int v1:31; empty v2; unsigned int v3:16; };
struct BFu31i_Sf_BFu16ll { unsigned int v1:31; empty v2; unsigned long long v3:16; };
struct BFu31i_Sf_BFu16s { unsigned int v1:31; empty v2; unsigned short v3:16; };
struct BFu31i_Sf_BFu17i { unsigned int v1:31; empty v2; unsigned int v3:17; };
struct BFu31i_Sf_BFu17ll { unsigned int v1:31; empty v2; unsigned long long v3:17; };
struct BFu31i_Sf_BFu1c { unsigned int v1:31; empty v2; unsigned char v3:1; };
struct BFu31i_Sf_BFu1i { unsigned int v1:31; empty v2; unsigned int v3:1; };
struct BFu31i_Sf_BFu1ll { unsigned int v1:31; empty v2; unsigned long long v3:1; };
struct BFu31i_Sf_BFu1s { unsigned int v1:31; empty v2; unsigned short v3:1; };
struct BFu31i_Sf_BFu31i { unsigned int v1:31; empty v2; unsigned int v3:31; };
struct BFu31i_Sf_BFu31ll { unsigned int v1:31; empty v2; unsigned long long v3:31; };
struct BFu31i_Sf_BFu32i { unsigned int v1:31; empty v2; unsigned int v3:32; };
struct BFu31i_Sf_BFu32ll { unsigned int v1:31; empty v2; unsigned long long v3:32; };
struct BFu31i_Sf_BFu33 { unsigned int v1:31; empty v2; unsigned long long v3:33; };
struct BFu31i_Sf_BFu7c { unsigned int v1:31; empty v2; unsigned char v3:7; };
struct BFu31i_Sf_BFu7i { unsigned int v1:31; empty v2; unsigned int v3:7; };
struct BFu31i_Sf_BFu7ll { unsigned int v1:31; empty v2; unsigned long long v3:7; };
struct BFu31i_Sf_BFu7s { unsigned int v1:31; empty v2; unsigned short v3:7; };
struct BFu31i_Sf_BFu8c { unsigned int v1:31; empty v2; unsigned char v3:8; };
struct BFu31i_Sf_BFu8i { unsigned int v1:31; empty v2; unsigned int v3:8; };
struct BFu31i_Sf_BFu8ll { unsigned int v1:31; empty v2; unsigned long long v3:8; };
struct BFu31i_Sf_BFu8s { unsigned int v1:31; empty v2; unsigned short v3:8; };
struct BFu31i_Sf_BFu9i { unsigned int v1:31; empty v2; unsigned int v3:9; };
struct BFu31i_Sf_BFu9ll { unsigned int v1:31; empty v2; unsigned long long v3:9; };
struct BFu31i_Sf_BFu9s { unsigned int v1:31; empty v2; unsigned short v3:9; };
struct BFu31i_Sf_C { unsigned int v1:31; empty v2; char v3; };
struct BFu31i_Sf_D { unsigned int v1:31; empty v2; double v3; };
struct BFu31i_Sf_F { unsigned int v1:31; empty v2; float v3; };
struct BFu31i_Sf_I { unsigned int v1:31; empty v2; int v3; };
struct BFu31i_Sf_Ip { unsigned int v1:31; empty v2; int * v3; };
struct BFu31i_Sf_L { unsigned int v1:31; empty v2; long long v3; };
struct BFu31i_Sf_S { unsigned int v1:31; empty v2; short v3; };
struct BFu31i_Sf_Sf { unsigned int v1:31; empty v2; empty v3; };
struct BFu31i_Sf_Uc { unsigned int v1:31; empty v2; unsigned char v3; };
struct BFu31i_Sf_Ui { unsigned int v1:31; empty v2; unsigned int v3; };
struct BFu31i_Sf_Ul { unsigned int v1:31; empty v2; unsigned long long v3; };
struct BFu31i_Sf_Us { unsigned int v1:31; empty v2; unsigned short v3; };
struct BFu31i_Sf_Vp { unsigned int v1:31; empty v2; void * v3; };
struct BFu31i_Uc_Sf { unsigned int v1:31; unsigned char v2; empty v3; };
struct BFu31i_Ui_Sf { unsigned int v1:31; unsigned int v2; empty v3; };
struct BFu31i_Ul_Sf { unsigned int v1:31; unsigned long long v2; empty v3; };
struct BFu31i_Us_Sf { unsigned int v1:31; unsigned short v2; empty v3; };
struct BFu31i_Vp_Sf { unsigned int v1:31; void * v2; empty v3; };
struct BFu31ll_BFu15i_Sf { unsigned long long v1:31; unsigned int v2:15; empty v3; };
struct BFu31ll_BFu15ll_Sf { unsigned long long v1:31; unsigned long long v2:15; empty v3; };
struct BFu31ll_BFu15s_Sf { unsigned long long v1:31; unsigned short v2:15; empty v3; };
struct BFu31ll_BFu16i_Sf { unsigned long long v1:31; unsigned int v2:16; empty v3; };
struct BFu31ll_BFu16ll_Sf { unsigned long long v1:31; unsigned long long v2:16; empty v3; };
struct BFu31ll_BFu16s_Sf { unsigned long long v1:31; unsigned short v2:16; empty v3; };
struct BFu31ll_BFu17i_Sf { unsigned long long v1:31; unsigned int v2:17; empty v3; };
struct BFu31ll_BFu17ll_Sf { unsigned long long v1:31; unsigned long long v2:17; empty v3; };
struct BFu31ll_BFu1c_Sf { unsigned long long v1:31; unsigned char v2:1; empty v3; };
struct BFu31ll_BFu1i_Sf { unsigned long long v1:31; unsigned int v2:1; empty v3; };
struct BFu31ll_BFu1ll_Sf { unsigned long long v1:31; unsigned long long v2:1; empty v3; };
struct BFu31ll_BFu1s_Sf { unsigned long long v1:31; unsigned short v2:1; empty v3; };
struct BFu31ll_BFu31i_Sf { unsigned long long v1:31; unsigned int v2:31; empty v3; };
struct BFu31ll_BFu31ll_Sf { unsigned long long v1:31; unsigned long long v2:31; empty v3; };
struct BFu31ll_BFu32i_Sf { unsigned long long v1:31; unsigned int v2:32; empty v3; };
struct BFu31ll_BFu32ll_Sf { unsigned long long v1:31; unsigned long long v2:32; empty v3; };
struct BFu31ll_BFu33_Sf { unsigned long long v1:31; unsigned long long v2:33; empty v3; };
struct BFu31ll_BFu7c_Sf { unsigned long long v1:31; unsigned char v2:7; empty v3; };
struct BFu31ll_BFu7i_Sf { unsigned long long v1:31; unsigned int v2:7; empty v3; };
struct BFu31ll_BFu7ll_Sf { unsigned long long v1:31; unsigned long long v2:7; empty v3; };
struct BFu31ll_BFu7s_Sf { unsigned long long v1:31; unsigned short v2:7; empty v3; };
struct BFu31ll_BFu8c_Sf { unsigned long long v1:31; unsigned char v2:8; empty v3; };
struct BFu31ll_BFu8i_Sf { unsigned long long v1:31; unsigned int v2:8; empty v3; };
struct BFu31ll_BFu8ll_Sf { unsigned long long v1:31; unsigned long long v2:8; empty v3; };
struct BFu31ll_BFu8s_Sf { unsigned long long v1:31; unsigned short v2:8; empty v3; };
struct BFu31ll_BFu9i_Sf { unsigned long long v1:31; unsigned int v2:9; empty v3; };
struct BFu31ll_BFu9ll_Sf { unsigned long long v1:31; unsigned long long v2:9; empty v3; };
struct BFu31ll_BFu9s_Sf { unsigned long long v1:31; unsigned short v2:9; empty v3; };
struct BFu31ll_C_Sf { unsigned long long v1:31; char v2; empty v3; };
struct BFu31ll_D_Sf { unsigned long long v1:31; double v2; empty v3; };
struct BFu31ll_F_Sf { unsigned long long v1:31; float v2; empty v3; };
struct BFu31ll_I_Sf { unsigned long long v1:31; int v2; empty v3; };
struct BFu31ll_Ip_Sf { unsigned long long v1:31; int * v2; empty v3; };
struct BFu31ll_L_Sf { unsigned long long v1:31; long long v2; empty v3; };
struct BFu31ll_S_Sf { unsigned long long v1:31; short v2; empty v3; };
struct BFu31ll_Sf { unsigned long long v1:31; empty v2; };
struct BFu31ll_Sf_BFu15i { unsigned long long v1:31; empty v2; unsigned int v3:15; };
struct BFu31ll_Sf_BFu15ll { unsigned long long v1:31; empty v2; unsigned long long v3:15; };
struct BFu31ll_Sf_BFu15s { unsigned long long v1:31; empty v2; unsigned short v3:15; };
struct BFu31ll_Sf_BFu16i { unsigned long long v1:31; empty v2; unsigned int v3:16; };
struct BFu31ll_Sf_BFu16ll { unsigned long long v1:31; empty v2; unsigned long long v3:16; };
struct BFu31ll_Sf_BFu16s { unsigned long long v1:31; empty v2; unsigned short v3:16; };
struct BFu31ll_Sf_BFu17i { unsigned long long v1:31; empty v2; unsigned int v3:17; };
struct BFu31ll_Sf_BFu17ll { unsigned long long v1:31; empty v2; unsigned long long v3:17; };
struct BFu31ll_Sf_BFu1c { unsigned long long v1:31; empty v2; unsigned char v3:1; };
struct BFu31ll_Sf_BFu1i { unsigned long long v1:31; empty v2; unsigned int v3:1; };
struct BFu31ll_Sf_BFu1ll { unsigned long long v1:31; empty v2; unsigned long long v3:1; };
struct BFu31ll_Sf_BFu1s { unsigned long long v1:31; empty v2; unsigned short v3:1; };
struct BFu31ll_Sf_BFu31i { unsigned long long v1:31; empty v2; unsigned int v3:31; };
struct BFu31ll_Sf_BFu31ll { unsigned long long v1:31; empty v2; unsigned long long v3:31; };
struct BFu31ll_Sf_BFu32i { unsigned long long v1:31; empty v2; unsigned int v3:32; };
struct BFu31ll_Sf_BFu32ll { unsigned long long v1:31; empty v2; unsigned long long v3:32; };
struct BFu31ll_Sf_BFu33 { unsigned long long v1:31; empty v2; unsigned long long v3:33; };
struct BFu31ll_Sf_BFu7c { unsigned long long v1:31; empty v2; unsigned char v3:7; };
struct BFu31ll_Sf_BFu7i { unsigned long long v1:31; empty v2; unsigned int v3:7; };
struct BFu31ll_Sf_BFu7ll { unsigned long long v1:31; empty v2; unsigned long long v3:7; };
struct BFu31ll_Sf_BFu7s { unsigned long long v1:31; empty v2; unsigned short v3:7; };
struct BFu31ll_Sf_BFu8c { unsigned long long v1:31; empty v2; unsigned char v3:8; };
struct BFu31ll_Sf_BFu8i { unsigned long long v1:31; empty v2; unsigned int v3:8; };
struct BFu31ll_Sf_BFu8ll { unsigned long long v1:31; empty v2; unsigned long long v3:8; };
struct BFu31ll_Sf_BFu8s { unsigned long long v1:31; empty v2; unsigned short v3:8; };
struct BFu31ll_Sf_BFu9i { unsigned long long v1:31; empty v2; unsigned int v3:9; };
struct BFu31ll_Sf_BFu9ll { unsigned long long v1:31; empty v2; unsigned long long v3:9; };
struct BFu31ll_Sf_BFu9s { unsigned long long v1:31; empty v2; unsigned short v3:9; };
struct BFu31ll_Sf_C { unsigned long long v1:31; empty v2; char v3; };
struct BFu31ll_Sf_D { unsigned long long v1:31; empty v2; double v3; };
struct BFu31ll_Sf_F { unsigned long long v1:31; empty v2; float v3; };
struct BFu31ll_Sf_I { unsigned long long v1:31; empty v2; int v3; };
struct BFu31ll_Sf_Ip { unsigned long long v1:31; empty v2; int * v3; };
struct BFu31ll_Sf_L { unsigned long long v1:31; empty v2; long long v3; };
struct BFu31ll_Sf_S { unsigned long long v1:31; empty v2; short v3; };
struct BFu31ll_Sf_Sf { unsigned long long v1:31; empty v2; empty v3; };
struct BFu31ll_Sf_Uc { unsigned long long v1:31; empty v2; unsigned char v3; };
struct BFu31ll_Sf_Ui { unsigned long long v1:31; empty v2; unsigned int v3; };
struct BFu31ll_Sf_Ul { unsigned long long v1:31; empty v2; unsigned long long v3; };
struct BFu31ll_Sf_Us { unsigned long long v1:31; empty v2; unsigned short v3; };
struct BFu31ll_Sf_Vp { unsigned long long v1:31; empty v2; void * v3; };
struct BFu31ll_Uc_Sf { unsigned long long v1:31; unsigned char v2; empty v3; };
struct BFu31ll_Ui_Sf { unsigned long long v1:31; unsigned int v2; empty v3; };
struct BFu31ll_Ul_Sf { unsigned long long v1:31; unsigned long long v2; empty v3; };
struct BFu31ll_Us_Sf { unsigned long long v1:31; unsigned short v2; empty v3; };
struct BFu31ll_Vp_Sf { unsigned long long v1:31; void * v2; empty v3; };
struct BFu32i_BFu15i_Sf { unsigned int v1:32; unsigned int v2:15; empty v3; };
struct BFu32i_BFu15ll_Sf { unsigned int v1:32; unsigned long long v2:15; empty v3; };
struct BFu32i_BFu15s_Sf { unsigned int v1:32; unsigned short v2:15; empty v3; };
struct BFu32i_BFu16i_Sf { unsigned int v1:32; unsigned int v2:16; empty v3; };
struct BFu32i_BFu16ll_Sf { unsigned int v1:32; unsigned long long v2:16; empty v3; };
struct BFu32i_BFu16s_Sf { unsigned int v1:32; unsigned short v2:16; empty v3; };
struct BFu32i_BFu17i_Sf { unsigned int v1:32; unsigned int v2:17; empty v3; };
struct BFu32i_BFu17ll_Sf { unsigned int v1:32; unsigned long long v2:17; empty v3; };
struct BFu32i_BFu1c_Sf { unsigned int v1:32; unsigned char v2:1; empty v3; };
struct BFu32i_BFu1i_Sf { unsigned int v1:32; unsigned int v2:1; empty v3; };
struct BFu32i_BFu1ll_Sf { unsigned int v1:32; unsigned long long v2:1; empty v3; };
struct BFu32i_BFu1s_Sf { unsigned int v1:32; unsigned short v2:1; empty v3; };
struct BFu32i_BFu31i_Sf { unsigned int v1:32; unsigned int v2:31; empty v3; };
struct BFu32i_BFu31ll_Sf { unsigned int v1:32; unsigned long long v2:31; empty v3; };
struct BFu32i_BFu32i_Sf { unsigned int v1:32; unsigned int v2:32; empty v3; };
struct BFu32i_BFu32ll_Sf { unsigned int v1:32; unsigned long long v2:32; empty v3; };
struct BFu32i_BFu33_Sf { unsigned int v1:32; unsigned long long v2:33; empty v3; };
struct BFu32i_BFu7c_Sf { unsigned int v1:32; unsigned char v2:7; empty v3; };
struct BFu32i_BFu7i_Sf { unsigned int v1:32; unsigned int v2:7; empty v3; };
struct BFu32i_BFu7ll_Sf { unsigned int v1:32; unsigned long long v2:7; empty v3; };
struct BFu32i_BFu7s_Sf { unsigned int v1:32; unsigned short v2:7; empty v3; };
struct BFu32i_BFu8c_Sf { unsigned int v1:32; unsigned char v2:8; empty v3; };
struct BFu32i_BFu8i_Sf { unsigned int v1:32; unsigned int v2:8; empty v3; };
struct BFu32i_BFu8ll_Sf { unsigned int v1:32; unsigned long long v2:8; empty v3; };
struct BFu32i_BFu8s_Sf { unsigned int v1:32; unsigned short v2:8; empty v3; };
struct BFu32i_BFu9i_Sf { unsigned int v1:32; unsigned int v2:9; empty v3; };
struct BFu32i_BFu9ll_Sf { unsigned int v1:32; unsigned long long v2:9; empty v3; };
struct BFu32i_BFu9s_Sf { unsigned int v1:32; unsigned short v2:9; empty v3; };
struct BFu32i_C_Sf { unsigned int v1:32; char v2; empty v3; };
struct BFu32i_D_Sf { unsigned int v1:32; double v2; empty v3; };
struct BFu32i_F_Sf { unsigned int v1:32; float v2; empty v3; };
struct BFu32i_I_Sf { unsigned int v1:32; int v2; empty v3; };
struct BFu32i_Ip_Sf { unsigned int v1:32; int * v2; empty v3; };
struct BFu32i_L_Sf { unsigned int v1:32; long long v2; empty v3; };
struct BFu32i_S_Sf { unsigned int v1:32; short v2; empty v3; };
struct BFu32i_Sf { unsigned int v1:32; empty v2; };
struct BFu32i_Sf_BFu15i { unsigned int v1:32; empty v2; unsigned int v3:15; };
struct BFu32i_Sf_BFu15ll { unsigned int v1:32; empty v2; unsigned long long v3:15; };
struct BFu32i_Sf_BFu15s { unsigned int v1:32; empty v2; unsigned short v3:15; };
struct BFu32i_Sf_BFu16i { unsigned int v1:32; empty v2; unsigned int v3:16; };
struct BFu32i_Sf_BFu16ll { unsigned int v1:32; empty v2; unsigned long long v3:16; };
struct BFu32i_Sf_BFu16s { unsigned int v1:32; empty v2; unsigned short v3:16; };
struct BFu32i_Sf_BFu17i { unsigned int v1:32; empty v2; unsigned int v3:17; };
struct BFu32i_Sf_BFu17ll { unsigned int v1:32; empty v2; unsigned long long v3:17; };
struct BFu32i_Sf_BFu1c { unsigned int v1:32; empty v2; unsigned char v3:1; };
struct BFu32i_Sf_BFu1i { unsigned int v1:32; empty v2; unsigned int v3:1; };
struct BFu32i_Sf_BFu1ll { unsigned int v1:32; empty v2; unsigned long long v3:1; };
struct BFu32i_Sf_BFu1s { unsigned int v1:32; empty v2; unsigned short v3:1; };
struct BFu32i_Sf_BFu31i { unsigned int v1:32; empty v2; unsigned int v3:31; };
struct BFu32i_Sf_BFu31ll { unsigned int v1:32; empty v2; unsigned long long v3:31; };
struct BFu32i_Sf_BFu32i { unsigned int v1:32; empty v2; unsigned int v3:32; };
struct BFu32i_Sf_BFu32ll { unsigned int v1:32; empty v2; unsigned long long v3:32; };
struct BFu32i_Sf_BFu33 { unsigned int v1:32; empty v2; unsigned long long v3:33; };
struct BFu32i_Sf_BFu7c { unsigned int v1:32; empty v2; unsigned char v3:7; };
struct BFu32i_Sf_BFu7i { unsigned int v1:32; empty v2; unsigned int v3:7; };
struct BFu32i_Sf_BFu7ll { unsigned int v1:32; empty v2; unsigned long long v3:7; };
struct BFu32i_Sf_BFu7s { unsigned int v1:32; empty v2; unsigned short v3:7; };
struct BFu32i_Sf_BFu8c { unsigned int v1:32; empty v2; unsigned char v3:8; };
struct BFu32i_Sf_BFu8i { unsigned int v1:32; empty v2; unsigned int v3:8; };
struct BFu32i_Sf_BFu8ll { unsigned int v1:32; empty v2; unsigned long long v3:8; };
struct BFu32i_Sf_BFu8s { unsigned int v1:32; empty v2; unsigned short v3:8; };
struct BFu32i_Sf_BFu9i { unsigned int v1:32; empty v2; unsigned int v3:9; };
struct BFu32i_Sf_BFu9ll { unsigned int v1:32; empty v2; unsigned long long v3:9; };
struct BFu32i_Sf_BFu9s { unsigned int v1:32; empty v2; unsigned short v3:9; };
struct BFu32i_Sf_C { unsigned int v1:32; empty v2; char v3; };
struct BFu32i_Sf_D { unsigned int v1:32; empty v2; double v3; };
struct BFu32i_Sf_F { unsigned int v1:32; empty v2; float v3; };
struct BFu32i_Sf_I { unsigned int v1:32; empty v2; int v3; };
struct BFu32i_Sf_Ip { unsigned int v1:32; empty v2; int * v3; };
struct BFu32i_Sf_L { unsigned int v1:32; empty v2; long long v3; };
struct BFu32i_Sf_S { unsigned int v1:32; empty v2; short v3; };
struct BFu32i_Sf_Sf { unsigned int v1:32; empty v2; empty v3; };
struct BFu32i_Sf_Uc { unsigned int v1:32; empty v2; unsigned char v3; };
struct BFu32i_Sf_Ui { unsigned int v1:32; empty v2; unsigned int v3; };
struct BFu32i_Sf_Ul { unsigned int v1:32; empty v2; unsigned long long v3; };
struct BFu32i_Sf_Us { unsigned int v1:32; empty v2; unsigned short v3; };
struct BFu32i_Sf_Vp { unsigned int v1:32; empty v2; void * v3; };
struct BFu32i_Uc_Sf { unsigned int v1:32; unsigned char v2; empty v3; };
struct BFu32i_Ui_Sf { unsigned int v1:32; unsigned int v2; empty v3; };
struct BFu32i_Ul_Sf { unsigned int v1:32; unsigned long long v2; empty v3; };
struct BFu32i_Us_Sf { unsigned int v1:32; unsigned short v2; empty v3; };
struct BFu32i_Vp_Sf { unsigned int v1:32; void * v2; empty v3; };
struct BFu32ll_BFu15i_Sf { unsigned long long v1:32; unsigned int v2:15; empty v3; };
struct BFu32ll_BFu15ll_Sf { unsigned long long v1:32; unsigned long long v2:15; empty v3; };
struct BFu32ll_BFu15s_Sf { unsigned long long v1:32; unsigned short v2:15; empty v3; };
struct BFu32ll_BFu16i_Sf { unsigned long long v1:32; unsigned int v2:16; empty v3; };
struct BFu32ll_BFu16ll_Sf { unsigned long long v1:32; unsigned long long v2:16; empty v3; };
struct BFu32ll_BFu16s_Sf { unsigned long long v1:32; unsigned short v2:16; empty v3; };
struct BFu32ll_BFu17i_Sf { unsigned long long v1:32; unsigned int v2:17; empty v3; };
struct BFu32ll_BFu17ll_Sf { unsigned long long v1:32; unsigned long long v2:17; empty v3; };
struct BFu32ll_BFu1c_Sf { unsigned long long v1:32; unsigned char v2:1; empty v3; };
struct BFu32ll_BFu1i_Sf { unsigned long long v1:32; unsigned int v2:1; empty v3; };
struct BFu32ll_BFu1ll_Sf { unsigned long long v1:32; unsigned long long v2:1; empty v3; };
struct BFu32ll_BFu1s_Sf { unsigned long long v1:32; unsigned short v2:1; empty v3; };
struct BFu32ll_BFu31i_Sf { unsigned long long v1:32; unsigned int v2:31; empty v3; };
struct BFu32ll_BFu31ll_Sf { unsigned long long v1:32; unsigned long long v2:31; empty v3; };
struct BFu32ll_BFu32i_Sf { unsigned long long v1:32; unsigned int v2:32; empty v3; };
struct BFu32ll_BFu32ll_Sf { unsigned long long v1:32; unsigned long long v2:32; empty v3; };
struct BFu32ll_BFu33_Sf { unsigned long long v1:32; unsigned long long v2:33; empty v3; };
struct BFu32ll_BFu7c_Sf { unsigned long long v1:32; unsigned char v2:7; empty v3; };
struct BFu32ll_BFu7i_Sf { unsigned long long v1:32; unsigned int v2:7; empty v3; };
struct BFu32ll_BFu7ll_Sf { unsigned long long v1:32; unsigned long long v2:7; empty v3; };
struct BFu32ll_BFu7s_Sf { unsigned long long v1:32; unsigned short v2:7; empty v3; };
struct BFu32ll_BFu8c_Sf { unsigned long long v1:32; unsigned char v2:8; empty v3; };
struct BFu32ll_BFu8i_Sf { unsigned long long v1:32; unsigned int v2:8; empty v3; };
struct BFu32ll_BFu8ll_Sf { unsigned long long v1:32; unsigned long long v2:8; empty v3; };
struct BFu32ll_BFu8s_Sf { unsigned long long v1:32; unsigned short v2:8; empty v3; };
struct BFu32ll_BFu9i_Sf { unsigned long long v1:32; unsigned int v2:9; empty v3; };
struct BFu32ll_BFu9ll_Sf { unsigned long long v1:32; unsigned long long v2:9; empty v3; };
struct BFu32ll_BFu9s_Sf { unsigned long long v1:32; unsigned short v2:9; empty v3; };
struct BFu32ll_C_Sf { unsigned long long v1:32; char v2; empty v3; };
struct BFu32ll_D_Sf { unsigned long long v1:32; double v2; empty v3; };
struct BFu32ll_F_Sf { unsigned long long v1:32; float v2; empty v3; };
struct BFu32ll_I_Sf { unsigned long long v1:32; int v2; empty v3; };
struct BFu32ll_Ip_Sf { unsigned long long v1:32; int * v2; empty v3; };
struct BFu32ll_L_Sf { unsigned long long v1:32; long long v2; empty v3; };
struct BFu32ll_S_Sf { unsigned long long v1:32; short v2; empty v3; };
struct BFu32ll_Sf { unsigned long long v1:32; empty v2; };
struct BFu32ll_Sf_BFu15i { unsigned long long v1:32; empty v2; unsigned int v3:15; };
struct BFu32ll_Sf_BFu15ll { unsigned long long v1:32; empty v2; unsigned long long v3:15; };
struct BFu32ll_Sf_BFu15s { unsigned long long v1:32; empty v2; unsigned short v3:15; };
struct BFu32ll_Sf_BFu16i { unsigned long long v1:32; empty v2; unsigned int v3:16; };
struct BFu32ll_Sf_BFu16ll { unsigned long long v1:32; empty v2; unsigned long long v3:16; };
struct BFu32ll_Sf_BFu16s { unsigned long long v1:32; empty v2; unsigned short v3:16; };
struct BFu32ll_Sf_BFu17i { unsigned long long v1:32; empty v2; unsigned int v3:17; };
struct BFu32ll_Sf_BFu17ll { unsigned long long v1:32; empty v2; unsigned long long v3:17; };
struct BFu32ll_Sf_BFu1c { unsigned long long v1:32; empty v2; unsigned char v3:1; };
struct BFu32ll_Sf_BFu1i { unsigned long long v1:32; empty v2; unsigned int v3:1; };
struct BFu32ll_Sf_BFu1ll { unsigned long long v1:32; empty v2; unsigned long long v3:1; };
struct BFu32ll_Sf_BFu1s { unsigned long long v1:32; empty v2; unsigned short v3:1; };
struct BFu32ll_Sf_BFu31i { unsigned long long v1:32; empty v2; unsigned int v3:31; };
struct BFu32ll_Sf_BFu31ll { unsigned long long v1:32; empty v2; unsigned long long v3:31; };
struct BFu32ll_Sf_BFu32i { unsigned long long v1:32; empty v2; unsigned int v3:32; };
struct BFu32ll_Sf_BFu32ll { unsigned long long v1:32; empty v2; unsigned long long v3:32; };
struct BFu32ll_Sf_BFu33 { unsigned long long v1:32; empty v2; unsigned long long v3:33; };
struct BFu32ll_Sf_BFu7c { unsigned long long v1:32; empty v2; unsigned char v3:7; };
struct BFu32ll_Sf_BFu7i { unsigned long long v1:32; empty v2; unsigned int v3:7; };
struct BFu32ll_Sf_BFu7ll { unsigned long long v1:32; empty v2; unsigned long long v3:7; };
struct BFu32ll_Sf_BFu7s { unsigned long long v1:32; empty v2; unsigned short v3:7; };
struct BFu32ll_Sf_BFu8c { unsigned long long v1:32; empty v2; unsigned char v3:8; };
struct BFu32ll_Sf_BFu8i { unsigned long long v1:32; empty v2; unsigned int v3:8; };
struct BFu32ll_Sf_BFu8ll { unsigned long long v1:32; empty v2; unsigned long long v3:8; };
struct BFu32ll_Sf_BFu8s { unsigned long long v1:32; empty v2; unsigned short v3:8; };
struct BFu32ll_Sf_BFu9i { unsigned long long v1:32; empty v2; unsigned int v3:9; };
struct BFu32ll_Sf_BFu9ll { unsigned long long v1:32; empty v2; unsigned long long v3:9; };
struct BFu32ll_Sf_BFu9s { unsigned long long v1:32; empty v2; unsigned short v3:9; };
struct BFu32ll_Sf_C { unsigned long long v1:32; empty v2; char v3; };
struct BFu32ll_Sf_D { unsigned long long v1:32; empty v2; double v3; };
struct BFu32ll_Sf_F { unsigned long long v1:32; empty v2; float v3; };
struct BFu32ll_Sf_I { unsigned long long v1:32; empty v2; int v3; };
struct BFu32ll_Sf_Ip { unsigned long long v1:32; empty v2; int * v3; };
struct BFu32ll_Sf_L { unsigned long long v1:32; empty v2; long long v3; };
struct BFu32ll_Sf_S { unsigned long long v1:32; empty v2; short v3; };
struct BFu32ll_Sf_Sf { unsigned long long v1:32; empty v2; empty v3; };
struct BFu32ll_Sf_Uc { unsigned long long v1:32; empty v2; unsigned char v3; };
struct BFu32ll_Sf_Ui { unsigned long long v1:32; empty v2; unsigned int v3; };
struct BFu32ll_Sf_Ul { unsigned long long v1:32; empty v2; unsigned long long v3; };
struct BFu32ll_Sf_Us { unsigned long long v1:32; empty v2; unsigned short v3; };
struct BFu32ll_Sf_Vp { unsigned long long v1:32; empty v2; void * v3; };
struct BFu32ll_Uc_Sf { unsigned long long v1:32; unsigned char v2; empty v3; };
struct BFu32ll_Ui_Sf { unsigned long long v1:32; unsigned int v2; empty v3; };
struct BFu32ll_Ul_Sf { unsigned long long v1:32; unsigned long long v2; empty v3; };
struct BFu32ll_Us_Sf { unsigned long long v1:32; unsigned short v2; empty v3; };
struct BFu32ll_Vp_Sf { unsigned long long v1:32; void * v2; empty v3; };
struct BFu33_BFu15i_Sf { unsigned long long v1:33; unsigned int v2:15; empty v3; };
struct BFu33_BFu15ll_Sf { unsigned long long v1:33; unsigned long long v2:15; empty v3; };
struct BFu33_BFu15s_Sf { unsigned long long v1:33; unsigned short v2:15; empty v3; };
struct BFu33_BFu16i_Sf { unsigned long long v1:33; unsigned int v2:16; empty v3; };
struct BFu33_BFu16ll_Sf { unsigned long long v1:33; unsigned long long v2:16; empty v3; };
struct BFu33_BFu16s_Sf { unsigned long long v1:33; unsigned short v2:16; empty v3; };
struct BFu33_BFu17i_Sf { unsigned long long v1:33; unsigned int v2:17; empty v3; };
struct BFu33_BFu17ll_Sf { unsigned long long v1:33; unsigned long long v2:17; empty v3; };
struct BFu33_BFu1c_Sf { unsigned long long v1:33; unsigned char v2:1; empty v3; };
struct BFu33_BFu1i_Sf { unsigned long long v1:33; unsigned int v2:1; empty v3; };
struct BFu33_BFu1ll_Sf { unsigned long long v1:33; unsigned long long v2:1; empty v3; };
struct BFu33_BFu1s_Sf { unsigned long long v1:33; unsigned short v2:1; empty v3; };
struct BFu33_BFu31i_Sf { unsigned long long v1:33; unsigned int v2:31; empty v3; };
struct BFu33_BFu31ll_Sf { unsigned long long v1:33; unsigned long long v2:31; empty v3; };
struct BFu33_BFu32i_Sf { unsigned long long v1:33; unsigned int v2:32; empty v3; };
struct BFu33_BFu32ll_Sf { unsigned long long v1:33; unsigned long long v2:32; empty v3; };
struct BFu33_BFu33_Sf { unsigned long long v1:33; unsigned long long v2:33; empty v3; };
struct BFu33_BFu7c_Sf { unsigned long long v1:33; unsigned char v2:7; empty v3; };
struct BFu33_BFu7i_Sf { unsigned long long v1:33; unsigned int v2:7; empty v3; };
struct BFu33_BFu7ll_Sf { unsigned long long v1:33; unsigned long long v2:7; empty v3; };
struct BFu33_BFu7s_Sf { unsigned long long v1:33; unsigned short v2:7; empty v3; };
struct BFu33_BFu8c_Sf { unsigned long long v1:33; unsigned char v2:8; empty v3; };
struct BFu33_BFu8i_Sf { unsigned long long v1:33; unsigned int v2:8; empty v3; };
struct BFu33_BFu8ll_Sf { unsigned long long v1:33; unsigned long long v2:8; empty v3; };
struct BFu33_BFu8s_Sf { unsigned long long v1:33; unsigned short v2:8; empty v3; };
struct BFu33_BFu9i_Sf { unsigned long long v1:33; unsigned int v2:9; empty v3; };
struct BFu33_BFu9ll_Sf { unsigned long long v1:33; unsigned long long v2:9; empty v3; };
struct BFu33_BFu9s_Sf { unsigned long long v1:33; unsigned short v2:9; empty v3; };
struct BFu33_C_Sf { unsigned long long v1:33; char v2; empty v3; };
struct BFu33_D_Sf { unsigned long long v1:33; double v2; empty v3; };
struct BFu33_F_Sf { unsigned long long v1:33; float v2; empty v3; };
struct BFu33_I_Sf { unsigned long long v1:33; int v2; empty v3; };
struct BFu33_Ip_Sf { unsigned long long v1:33; int * v2; empty v3; };
struct BFu33_L_Sf { unsigned long long v1:33; long long v2; empty v3; };
struct BFu33_S_Sf { unsigned long long v1:33; short v2; empty v3; };
struct BFu33_Sf { unsigned long long v1:33; empty v2; };
struct BFu33_Sf_BFu15i { unsigned long long v1:33; empty v2; unsigned int v3:15; };
struct BFu33_Sf_BFu15ll { unsigned long long v1:33; empty v2; unsigned long long v3:15; };
struct BFu33_Sf_BFu15s { unsigned long long v1:33; empty v2; unsigned short v3:15; };
struct BFu33_Sf_BFu16i { unsigned long long v1:33; empty v2; unsigned int v3:16; };
struct BFu33_Sf_BFu16ll { unsigned long long v1:33; empty v2; unsigned long long v3:16; };
struct BFu33_Sf_BFu16s { unsigned long long v1:33; empty v2; unsigned short v3:16; };
struct BFu33_Sf_BFu17i { unsigned long long v1:33; empty v2; unsigned int v3:17; };
struct BFu33_Sf_BFu17ll { unsigned long long v1:33; empty v2; unsigned long long v3:17; };
struct BFu33_Sf_BFu1c { unsigned long long v1:33; empty v2; unsigned char v3:1; };
struct BFu33_Sf_BFu1i { unsigned long long v1:33; empty v2; unsigned int v3:1; };
struct BFu33_Sf_BFu1ll { unsigned long long v1:33; empty v2; unsigned long long v3:1; };
struct BFu33_Sf_BFu1s { unsigned long long v1:33; empty v2; unsigned short v3:1; };
struct BFu33_Sf_BFu31i { unsigned long long v1:33; empty v2; unsigned int v3:31; };
struct BFu33_Sf_BFu31ll { unsigned long long v1:33; empty v2; unsigned long long v3:31; };
struct BFu33_Sf_BFu32i { unsigned long long v1:33; empty v2; unsigned int v3:32; };
struct BFu33_Sf_BFu32ll { unsigned long long v1:33; empty v2; unsigned long long v3:32; };
struct BFu33_Sf_BFu33 { unsigned long long v1:33; empty v2; unsigned long long v3:33; };
struct BFu33_Sf_BFu7c { unsigned long long v1:33; empty v2; unsigned char v3:7; };
struct BFu33_Sf_BFu7i { unsigned long long v1:33; empty v2; unsigned int v3:7; };
struct BFu33_Sf_BFu7ll { unsigned long long v1:33; empty v2; unsigned long long v3:7; };
struct BFu33_Sf_BFu7s { unsigned long long v1:33; empty v2; unsigned short v3:7; };
struct BFu33_Sf_BFu8c { unsigned long long v1:33; empty v2; unsigned char v3:8; };
struct BFu33_Sf_BFu8i { unsigned long long v1:33; empty v2; unsigned int v3:8; };
struct BFu33_Sf_BFu8ll { unsigned long long v1:33; empty v2; unsigned long long v3:8; };
struct BFu33_Sf_BFu8s { unsigned long long v1:33; empty v2; unsigned short v3:8; };
struct BFu33_Sf_BFu9i { unsigned long long v1:33; empty v2; unsigned int v3:9; };
struct BFu33_Sf_BFu9ll { unsigned long long v1:33; empty v2; unsigned long long v3:9; };
struct BFu33_Sf_BFu9s { unsigned long long v1:33; empty v2; unsigned short v3:9; };
struct BFu33_Sf_C { unsigned long long v1:33; empty v2; char v3; };
struct BFu33_Sf_D { unsigned long long v1:33; empty v2; double v3; };
struct BFu33_Sf_F { unsigned long long v1:33; empty v2; float v3; };
struct BFu33_Sf_I { unsigned long long v1:33; empty v2; int v3; };
struct BFu33_Sf_Ip { unsigned long long v1:33; empty v2; int * v3; };
struct BFu33_Sf_L { unsigned long long v1:33; empty v2; long long v3; };
struct BFu33_Sf_S { unsigned long long v1:33; empty v2; short v3; };
struct BFu33_Sf_Sf { unsigned long long v1:33; empty v2; empty v3; };
struct BFu33_Sf_Uc { unsigned long long v1:33; empty v2; unsigned char v3; };
struct BFu33_Sf_Ui { unsigned long long v1:33; empty v2; unsigned int v3; };
struct BFu33_Sf_Ul { unsigned long long v1:33; empty v2; unsigned long long v3; };
struct BFu33_Sf_Us { unsigned long long v1:33; empty v2; unsigned short v3; };
struct BFu33_Sf_Vp { unsigned long long v1:33; empty v2; void * v3; };
struct BFu33_Uc_Sf { unsigned long long v1:33; unsigned char v2; empty v3; };
struct BFu33_Ui_Sf { unsigned long long v1:33; unsigned int v2; empty v3; };
struct BFu33_Ul_Sf { unsigned long long v1:33; unsigned long long v2; empty v3; };
struct BFu33_Us_Sf { unsigned long long v1:33; unsigned short v2; empty v3; };
struct BFu33_Vp_Sf { unsigned long long v1:33; void * v2; empty v3; };
struct BFu7c_BFu15i_Sf { unsigned char v1:7; unsigned int v2:15; empty v3; };
struct BFu7c_BFu15ll_Sf { unsigned char v1:7; unsigned long long v2:15; empty v3; };
struct BFu7c_BFu15s_Sf { unsigned char v1:7; unsigned short v2:15; empty v3; };
struct BFu7c_BFu16i_Sf { unsigned char v1:7; unsigned int v2:16; empty v3; };
struct BFu7c_BFu16ll_Sf { unsigned char v1:7; unsigned long long v2:16; empty v3; };
struct BFu7c_BFu16s_Sf { unsigned char v1:7; unsigned short v2:16; empty v3; };
struct BFu7c_BFu17i_Sf { unsigned char v1:7; unsigned int v2:17; empty v3; };
struct BFu7c_BFu17ll_Sf { unsigned char v1:7; unsigned long long v2:17; empty v3; };
struct BFu7c_BFu1c_Sf { unsigned char v1:7; unsigned char v2:1; empty v3; };
struct BFu7c_BFu1i_Sf { unsigned char v1:7; unsigned int v2:1; empty v3; };
struct BFu7c_BFu1ll_Sf { unsigned char v1:7; unsigned long long v2:1; empty v3; };
struct BFu7c_BFu1s_Sf { unsigned char v1:7; unsigned short v2:1; empty v3; };
struct BFu7c_BFu31i_Sf { unsigned char v1:7; unsigned int v2:31; empty v3; };
struct BFu7c_BFu31ll_Sf { unsigned char v1:7; unsigned long long v2:31; empty v3; };
struct BFu7c_BFu32i_Sf { unsigned char v1:7; unsigned int v2:32; empty v3; };
struct BFu7c_BFu32ll_Sf { unsigned char v1:7; unsigned long long v2:32; empty v3; };
struct BFu7c_BFu33_Sf { unsigned char v1:7; unsigned long long v2:33; empty v3; };
struct BFu7c_BFu7c_Sf { unsigned char v1:7; unsigned char v2:7; empty v3; };
struct BFu7c_BFu7i_Sf { unsigned char v1:7; unsigned int v2:7; empty v3; };
struct BFu7c_BFu7ll_Sf { unsigned char v1:7; unsigned long long v2:7; empty v3; };
struct BFu7c_BFu7s_Sf { unsigned char v1:7; unsigned short v2:7; empty v3; };
struct BFu7c_BFu8c_Sf { unsigned char v1:7; unsigned char v2:8; empty v3; };
struct BFu7c_BFu8i_Sf { unsigned char v1:7; unsigned int v2:8; empty v3; };
struct BFu7c_BFu8ll_Sf { unsigned char v1:7; unsigned long long v2:8; empty v3; };
struct BFu7c_BFu8s_Sf { unsigned char v1:7; unsigned short v2:8; empty v3; };
struct BFu7c_BFu9i_Sf { unsigned char v1:7; unsigned int v2:9; empty v3; };
struct BFu7c_BFu9ll_Sf { unsigned char v1:7; unsigned long long v2:9; empty v3; };
struct BFu7c_BFu9s_Sf { unsigned char v1:7; unsigned short v2:9; empty v3; };
struct BFu7c_C_Sf { unsigned char v1:7; char v2; empty v3; };
struct BFu7c_D_Sf { unsigned char v1:7; double v2; empty v3; };
struct BFu7c_F_Sf { unsigned char v1:7; float v2; empty v3; };
struct BFu7c_I_Sf { unsigned char v1:7; int v2; empty v3; };
struct BFu7c_Ip_Sf { unsigned char v1:7; int * v2; empty v3; };
struct BFu7c_L_Sf { unsigned char v1:7; long long v2; empty v3; };
struct BFu7c_S_Sf { unsigned char v1:7; short v2; empty v3; };
struct BFu7c_Sf { unsigned char v1:7; empty v2; };
struct BFu7c_Sf_BFu15i { unsigned char v1:7; empty v2; unsigned int v3:15; };
struct BFu7c_Sf_BFu15ll { unsigned char v1:7; empty v2; unsigned long long v3:15; };
struct BFu7c_Sf_BFu15s { unsigned char v1:7; empty v2; unsigned short v3:15; };
struct BFu7c_Sf_BFu16i { unsigned char v1:7; empty v2; unsigned int v3:16; };
struct BFu7c_Sf_BFu16ll { unsigned char v1:7; empty v2; unsigned long long v3:16; };
struct BFu7c_Sf_BFu16s { unsigned char v1:7; empty v2; unsigned short v3:16; };
struct BFu7c_Sf_BFu17i { unsigned char v1:7; empty v2; unsigned int v3:17; };
struct BFu7c_Sf_BFu17ll { unsigned char v1:7; empty v2; unsigned long long v3:17; };
struct BFu7c_Sf_BFu1c { unsigned char v1:7; empty v2; unsigned char v3:1; };
struct BFu7c_Sf_BFu1i { unsigned char v1:7; empty v2; unsigned int v3:1; };
struct BFu7c_Sf_BFu1ll { unsigned char v1:7; empty v2; unsigned long long v3:1; };
struct BFu7c_Sf_BFu1s { unsigned char v1:7; empty v2; unsigned short v3:1; };
struct BFu7c_Sf_BFu31i { unsigned char v1:7; empty v2; unsigned int v3:31; };
struct BFu7c_Sf_BFu31ll { unsigned char v1:7; empty v2; unsigned long long v3:31; };
struct BFu7c_Sf_BFu32i { unsigned char v1:7; empty v2; unsigned int v3:32; };
struct BFu7c_Sf_BFu32ll { unsigned char v1:7; empty v2; unsigned long long v3:32; };
struct BFu7c_Sf_BFu33 { unsigned char v1:7; empty v2; unsigned long long v3:33; };
struct BFu7c_Sf_BFu7c { unsigned char v1:7; empty v2; unsigned char v3:7; };
struct BFu7c_Sf_BFu7i { unsigned char v1:7; empty v2; unsigned int v3:7; };
struct BFu7c_Sf_BFu7ll { unsigned char v1:7; empty v2; unsigned long long v3:7; };
struct BFu7c_Sf_BFu7s { unsigned char v1:7; empty v2; unsigned short v3:7; };
struct BFu7c_Sf_BFu8c { unsigned char v1:7; empty v2; unsigned char v3:8; };
struct BFu7c_Sf_BFu8i { unsigned char v1:7; empty v2; unsigned int v3:8; };
struct BFu7c_Sf_BFu8ll { unsigned char v1:7; empty v2; unsigned long long v3:8; };
struct BFu7c_Sf_BFu8s { unsigned char v1:7; empty v2; unsigned short v3:8; };
struct BFu7c_Sf_BFu9i { unsigned char v1:7; empty v2; unsigned int v3:9; };
struct BFu7c_Sf_BFu9ll { unsigned char v1:7; empty v2; unsigned long long v3:9; };
struct BFu7c_Sf_BFu9s { unsigned char v1:7; empty v2; unsigned short v3:9; };
struct BFu7c_Sf_C { unsigned char v1:7; empty v2; char v3; };
struct BFu7c_Sf_D { unsigned char v1:7; empty v2; double v3; };
struct BFu7c_Sf_F { unsigned char v1:7; empty v2; float v3; };
struct BFu7c_Sf_I { unsigned char v1:7; empty v2; int v3; };
struct BFu7c_Sf_Ip { unsigned char v1:7; empty v2; int * v3; };
struct BFu7c_Sf_L { unsigned char v1:7; empty v2; long long v3; };
struct BFu7c_Sf_S { unsigned char v1:7; empty v2; short v3; };
struct BFu7c_Sf_Sf { unsigned char v1:7; empty v2; empty v3; };
struct BFu7c_Sf_Uc { unsigned char v1:7; empty v2; unsigned char v3; };
struct BFu7c_Sf_Ui { unsigned char v1:7; empty v2; unsigned int v3; };
struct BFu7c_Sf_Ul { unsigned char v1:7; empty v2; unsigned long long v3; };
struct BFu7c_Sf_Us { unsigned char v1:7; empty v2; unsigned short v3; };
struct BFu7c_Sf_Vp { unsigned char v1:7; empty v2; void * v3; };
struct BFu7c_Uc_Sf { unsigned char v1:7; unsigned char v2; empty v3; };
struct BFu7c_Ui_Sf { unsigned char v1:7; unsigned int v2; empty v3; };
struct BFu7c_Ul_Sf { unsigned char v1:7; unsigned long long v2; empty v3; };
struct BFu7c_Us_Sf { unsigned char v1:7; unsigned short v2; empty v3; };
struct BFu7c_Vp_Sf { unsigned char v1:7; void * v2; empty v3; };
struct BFu7i_BFu15i_Sf { unsigned int v1:7; unsigned int v2:15; empty v3; };
struct BFu7i_BFu15ll_Sf { unsigned int v1:7; unsigned long long v2:15; empty v3; };
struct BFu7i_BFu15s_Sf { unsigned int v1:7; unsigned short v2:15; empty v3; };
struct BFu7i_BFu16i_Sf { unsigned int v1:7; unsigned int v2:16; empty v3; };
struct BFu7i_BFu16ll_Sf { unsigned int v1:7; unsigned long long v2:16; empty v3; };
struct BFu7i_BFu16s_Sf { unsigned int v1:7; unsigned short v2:16; empty v3; };
struct BFu7i_BFu17i_Sf { unsigned int v1:7; unsigned int v2:17; empty v3; };
struct BFu7i_BFu17ll_Sf { unsigned int v1:7; unsigned long long v2:17; empty v3; };
struct BFu7i_BFu1c_Sf { unsigned int v1:7; unsigned char v2:1; empty v3; };
struct BFu7i_BFu1i_Sf { unsigned int v1:7; unsigned int v2:1; empty v3; };
struct BFu7i_BFu1ll_Sf { unsigned int v1:7; unsigned long long v2:1; empty v3; };
struct BFu7i_BFu1s_Sf { unsigned int v1:7; unsigned short v2:1; empty v3; };
struct BFu7i_BFu31i_Sf { unsigned int v1:7; unsigned int v2:31; empty v3; };
struct BFu7i_BFu31ll_Sf { unsigned int v1:7; unsigned long long v2:31; empty v3; };
struct BFu7i_BFu32i_Sf { unsigned int v1:7; unsigned int v2:32; empty v3; };
struct BFu7i_BFu32ll_Sf { unsigned int v1:7; unsigned long long v2:32; empty v3; };
struct BFu7i_BFu33_Sf { unsigned int v1:7; unsigned long long v2:33; empty v3; };
struct BFu7i_BFu7c_Sf { unsigned int v1:7; unsigned char v2:7; empty v3; };
struct BFu7i_BFu7i_Sf { unsigned int v1:7; unsigned int v2:7; empty v3; };
struct BFu7i_BFu7ll_Sf { unsigned int v1:7; unsigned long long v2:7; empty v3; };
struct BFu7i_BFu7s_Sf { unsigned int v1:7; unsigned short v2:7; empty v3; };
struct BFu7i_BFu8c_Sf { unsigned int v1:7; unsigned char v2:8; empty v3; };
struct BFu7i_BFu8i_Sf { unsigned int v1:7; unsigned int v2:8; empty v3; };
struct BFu7i_BFu8ll_Sf { unsigned int v1:7; unsigned long long v2:8; empty v3; };
struct BFu7i_BFu8s_Sf { unsigned int v1:7; unsigned short v2:8; empty v3; };
struct BFu7i_BFu9i_Sf { unsigned int v1:7; unsigned int v2:9; empty v3; };
struct BFu7i_BFu9ll_Sf { unsigned int v1:7; unsigned long long v2:9; empty v3; };
struct BFu7i_BFu9s_Sf { unsigned int v1:7; unsigned short v2:9; empty v3; };
struct BFu7i_C_Sf { unsigned int v1:7; char v2; empty v3; };
struct BFu7i_D_Sf { unsigned int v1:7; double v2; empty v3; };
struct BFu7i_F_Sf { unsigned int v1:7; float v2; empty v3; };
struct BFu7i_I_Sf { unsigned int v1:7; int v2; empty v3; };
struct BFu7i_Ip_Sf { unsigned int v1:7; int * v2; empty v3; };
struct BFu7i_L_Sf { unsigned int v1:7; long long v2; empty v3; };
struct BFu7i_S_Sf { unsigned int v1:7; short v2; empty v3; };
struct BFu7i_Sf { unsigned int v1:7; empty v2; };
struct BFu7i_Sf_BFu15i { unsigned int v1:7; empty v2; unsigned int v3:15; };
struct BFu7i_Sf_BFu15ll { unsigned int v1:7; empty v2; unsigned long long v3:15; };
struct BFu7i_Sf_BFu15s { unsigned int v1:7; empty v2; unsigned short v3:15; };
struct BFu7i_Sf_BFu16i { unsigned int v1:7; empty v2; unsigned int v3:16; };
struct BFu7i_Sf_BFu16ll { unsigned int v1:7; empty v2; unsigned long long v3:16; };
struct BFu7i_Sf_BFu16s { unsigned int v1:7; empty v2; unsigned short v3:16; };
struct BFu7i_Sf_BFu17i { unsigned int v1:7; empty v2; unsigned int v3:17; };
struct BFu7i_Sf_BFu17ll { unsigned int v1:7; empty v2; unsigned long long v3:17; };
struct BFu7i_Sf_BFu1c { unsigned int v1:7; empty v2; unsigned char v3:1; };
struct BFu7i_Sf_BFu1i { unsigned int v1:7; empty v2; unsigned int v3:1; };
struct BFu7i_Sf_BFu1ll { unsigned int v1:7; empty v2; unsigned long long v3:1; };
struct BFu7i_Sf_BFu1s { unsigned int v1:7; empty v2; unsigned short v3:1; };
struct BFu7i_Sf_BFu31i { unsigned int v1:7; empty v2; unsigned int v3:31; };
struct BFu7i_Sf_BFu31ll { unsigned int v1:7; empty v2; unsigned long long v3:31; };
struct BFu7i_Sf_BFu32i { unsigned int v1:7; empty v2; unsigned int v3:32; };
struct BFu7i_Sf_BFu32ll { unsigned int v1:7; empty v2; unsigned long long v3:32; };
struct BFu7i_Sf_BFu33 { unsigned int v1:7; empty v2; unsigned long long v3:33; };
struct BFu7i_Sf_BFu7c { unsigned int v1:7; empty v2; unsigned char v3:7; };
struct BFu7i_Sf_BFu7i { unsigned int v1:7; empty v2; unsigned int v3:7; };
struct BFu7i_Sf_BFu7ll { unsigned int v1:7; empty v2; unsigned long long v3:7; };
struct BFu7i_Sf_BFu7s { unsigned int v1:7; empty v2; unsigned short v3:7; };
struct BFu7i_Sf_BFu8c { unsigned int v1:7; empty v2; unsigned char v3:8; };
struct BFu7i_Sf_BFu8i { unsigned int v1:7; empty v2; unsigned int v3:8; };
struct BFu7i_Sf_BFu8ll { unsigned int v1:7; empty v2; unsigned long long v3:8; };
struct BFu7i_Sf_BFu8s { unsigned int v1:7; empty v2; unsigned short v3:8; };
struct BFu7i_Sf_BFu9i { unsigned int v1:7; empty v2; unsigned int v3:9; };
struct BFu7i_Sf_BFu9ll { unsigned int v1:7; empty v2; unsigned long long v3:9; };
struct BFu7i_Sf_BFu9s { unsigned int v1:7; empty v2; unsigned short v3:9; };
struct BFu7i_Sf_C { unsigned int v1:7; empty v2; char v3; };
struct BFu7i_Sf_D { unsigned int v1:7; empty v2; double v3; };
struct BFu7i_Sf_F { unsigned int v1:7; empty v2; float v3; };
struct BFu7i_Sf_I { unsigned int v1:7; empty v2; int v3; };
struct BFu7i_Sf_Ip { unsigned int v1:7; empty v2; int * v3; };
struct BFu7i_Sf_L { unsigned int v1:7; empty v2; long long v3; };
struct BFu7i_Sf_S { unsigned int v1:7; empty v2; short v3; };
struct BFu7i_Sf_Sf { unsigned int v1:7; empty v2; empty v3; };
struct BFu7i_Sf_Uc { unsigned int v1:7; empty v2; unsigned char v3; };
struct BFu7i_Sf_Ui { unsigned int v1:7; empty v2; unsigned int v3; };
struct BFu7i_Sf_Ul { unsigned int v1:7; empty v2; unsigned long long v3; };
struct BFu7i_Sf_Us { unsigned int v1:7; empty v2; unsigned short v3; };
struct BFu7i_Sf_Vp { unsigned int v1:7; empty v2; void * v3; };
struct BFu7i_Uc_Sf { unsigned int v1:7; unsigned char v2; empty v3; };
struct BFu7i_Ui_Sf { unsigned int v1:7; unsigned int v2; empty v3; };
struct BFu7i_Ul_Sf { unsigned int v1:7; unsigned long long v2; empty v3; };
struct BFu7i_Us_Sf { unsigned int v1:7; unsigned short v2; empty v3; };
struct BFu7i_Vp_Sf { unsigned int v1:7; void * v2; empty v3; };
struct BFu7ll_BFu15i_Sf { unsigned long long v1:7; unsigned int v2:15; empty v3; };
struct BFu7ll_BFu15ll_Sf { unsigned long long v1:7; unsigned long long v2:15; empty v3; };
struct BFu7ll_BFu15s_Sf { unsigned long long v1:7; unsigned short v2:15; empty v3; };
struct BFu7ll_BFu16i_Sf { unsigned long long v1:7; unsigned int v2:16; empty v3; };
struct BFu7ll_BFu16ll_Sf { unsigned long long v1:7; unsigned long long v2:16; empty v3; };
struct BFu7ll_BFu16s_Sf { unsigned long long v1:7; unsigned short v2:16; empty v3; };
struct BFu7ll_BFu17i_Sf { unsigned long long v1:7; unsigned int v2:17; empty v3; };
struct BFu7ll_BFu17ll_Sf { unsigned long long v1:7; unsigned long long v2:17; empty v3; };
struct BFu7ll_BFu1c_Sf { unsigned long long v1:7; unsigned char v2:1; empty v3; };
struct BFu7ll_BFu1i_Sf { unsigned long long v1:7; unsigned int v2:1; empty v3; };
struct BFu7ll_BFu1ll_Sf { unsigned long long v1:7; unsigned long long v2:1; empty v3; };
struct BFu7ll_BFu1s_Sf { unsigned long long v1:7; unsigned short v2:1; empty v3; };
struct BFu7ll_BFu31i_Sf { unsigned long long v1:7; unsigned int v2:31; empty v3; };
struct BFu7ll_BFu31ll_Sf { unsigned long long v1:7; unsigned long long v2:31; empty v3; };
struct BFu7ll_BFu32i_Sf { unsigned long long v1:7; unsigned int v2:32; empty v3; };
struct BFu7ll_BFu32ll_Sf { unsigned long long v1:7; unsigned long long v2:32; empty v3; };
struct BFu7ll_BFu33_Sf { unsigned long long v1:7; unsigned long long v2:33; empty v3; };
struct BFu7ll_BFu7c_Sf { unsigned long long v1:7; unsigned char v2:7; empty v3; };
struct BFu7ll_BFu7i_Sf { unsigned long long v1:7; unsigned int v2:7; empty v3; };
struct BFu7ll_BFu7ll_Sf { unsigned long long v1:7; unsigned long long v2:7; empty v3; };
struct BFu7ll_BFu7s_Sf { unsigned long long v1:7; unsigned short v2:7; empty v3; };
struct BFu7ll_BFu8c_Sf { unsigned long long v1:7; unsigned char v2:8; empty v3; };
struct BFu7ll_BFu8i_Sf { unsigned long long v1:7; unsigned int v2:8; empty v3; };
struct BFu7ll_BFu8ll_Sf { unsigned long long v1:7; unsigned long long v2:8; empty v3; };
struct BFu7ll_BFu8s_Sf { unsigned long long v1:7; unsigned short v2:8; empty v3; };
struct BFu7ll_BFu9i_Sf { unsigned long long v1:7; unsigned int v2:9; empty v3; };
struct BFu7ll_BFu9ll_Sf { unsigned long long v1:7; unsigned long long v2:9; empty v3; };
struct BFu7ll_BFu9s_Sf { unsigned long long v1:7; unsigned short v2:9; empty v3; };
struct BFu7ll_C_Sf { unsigned long long v1:7; char v2; empty v3; };
struct BFu7ll_D_Sf { unsigned long long v1:7; double v2; empty v3; };
struct BFu7ll_F_Sf { unsigned long long v1:7; float v2; empty v3; };
struct BFu7ll_I_Sf { unsigned long long v1:7; int v2; empty v3; };
struct BFu7ll_Ip_Sf { unsigned long long v1:7; int * v2; empty v3; };
struct BFu7ll_L_Sf { unsigned long long v1:7; long long v2; empty v3; };
struct BFu7ll_S_Sf { unsigned long long v1:7; short v2; empty v3; };
struct BFu7ll_Sf { unsigned long long v1:7; empty v2; };
struct BFu7ll_Sf_BFu15i { unsigned long long v1:7; empty v2; unsigned int v3:15; };
struct BFu7ll_Sf_BFu15ll { unsigned long long v1:7; empty v2; unsigned long long v3:15; };
struct BFu7ll_Sf_BFu15s { unsigned long long v1:7; empty v2; unsigned short v3:15; };
struct BFu7ll_Sf_BFu16i { unsigned long long v1:7; empty v2; unsigned int v3:16; };
struct BFu7ll_Sf_BFu16ll { unsigned long long v1:7; empty v2; unsigned long long v3:16; };
struct BFu7ll_Sf_BFu16s { unsigned long long v1:7; empty v2; unsigned short v3:16; };
struct BFu7ll_Sf_BFu17i { unsigned long long v1:7; empty v2; unsigned int v3:17; };
struct BFu7ll_Sf_BFu17ll { unsigned long long v1:7; empty v2; unsigned long long v3:17; };
struct BFu7ll_Sf_BFu1c { unsigned long long v1:7; empty v2; unsigned char v3:1; };
struct BFu7ll_Sf_BFu1i { unsigned long long v1:7; empty v2; unsigned int v3:1; };
struct BFu7ll_Sf_BFu1ll { unsigned long long v1:7; empty v2; unsigned long long v3:1; };
struct BFu7ll_Sf_BFu1s { unsigned long long v1:7; empty v2; unsigned short v3:1; };
struct BFu7ll_Sf_BFu31i { unsigned long long v1:7; empty v2; unsigned int v3:31; };
struct BFu7ll_Sf_BFu31ll { unsigned long long v1:7; empty v2; unsigned long long v3:31; };
struct BFu7ll_Sf_BFu32i { unsigned long long v1:7; empty v2; unsigned int v3:32; };
struct BFu7ll_Sf_BFu32ll { unsigned long long v1:7; empty v2; unsigned long long v3:32; };
struct BFu7ll_Sf_BFu33 { unsigned long long v1:7; empty v2; unsigned long long v3:33; };
struct BFu7ll_Sf_BFu7c { unsigned long long v1:7; empty v2; unsigned char v3:7; };
struct BFu7ll_Sf_BFu7i { unsigned long long v1:7; empty v2; unsigned int v3:7; };
struct BFu7ll_Sf_BFu7ll { unsigned long long v1:7; empty v2; unsigned long long v3:7; };
struct BFu7ll_Sf_BFu7s { unsigned long long v1:7; empty v2; unsigned short v3:7; };
struct BFu7ll_Sf_BFu8c { unsigned long long v1:7; empty v2; unsigned char v3:8; };
struct BFu7ll_Sf_BFu8i { unsigned long long v1:7; empty v2; unsigned int v3:8; };
struct BFu7ll_Sf_BFu8ll { unsigned long long v1:7; empty v2; unsigned long long v3:8; };
struct BFu7ll_Sf_BFu8s { unsigned long long v1:7; empty v2; unsigned short v3:8; };
struct BFu7ll_Sf_BFu9i { unsigned long long v1:7; empty v2; unsigned int v3:9; };
struct BFu7ll_Sf_BFu9ll { unsigned long long v1:7; empty v2; unsigned long long v3:9; };
struct BFu7ll_Sf_BFu9s { unsigned long long v1:7; empty v2; unsigned short v3:9; };
struct BFu7ll_Sf_C { unsigned long long v1:7; empty v2; char v3; };
struct BFu7ll_Sf_D { unsigned long long v1:7; empty v2; double v3; };
struct BFu7ll_Sf_F { unsigned long long v1:7; empty v2; float v3; };
struct BFu7ll_Sf_I { unsigned long long v1:7; empty v2; int v3; };
struct BFu7ll_Sf_Ip { unsigned long long v1:7; empty v2; int * v3; };
struct BFu7ll_Sf_L { unsigned long long v1:7; empty v2; long long v3; };
struct BFu7ll_Sf_S { unsigned long long v1:7; empty v2; short v3; };
struct BFu7ll_Sf_Sf { unsigned long long v1:7; empty v2; empty v3; };
struct BFu7ll_Sf_Uc { unsigned long long v1:7; empty v2; unsigned char v3; };
struct BFu7ll_Sf_Ui { unsigned long long v1:7; empty v2; unsigned int v3; };
struct BFu7ll_Sf_Ul { unsigned long long v1:7; empty v2; unsigned long long v3; };
struct BFu7ll_Sf_Us { unsigned long long v1:7; empty v2; unsigned short v3; };
struct BFu7ll_Sf_Vp { unsigned long long v1:7; empty v2; void * v3; };
struct BFu7ll_Uc_Sf { unsigned long long v1:7; unsigned char v2; empty v3; };
struct BFu7ll_Ui_Sf { unsigned long long v1:7; unsigned int v2; empty v3; };
struct BFu7ll_Ul_Sf { unsigned long long v1:7; unsigned long long v2; empty v3; };
struct BFu7ll_Us_Sf { unsigned long long v1:7; unsigned short v2; empty v3; };
struct BFu7ll_Vp_Sf { unsigned long long v1:7; void * v2; empty v3; };
struct BFu7s_BFu15i_Sf { unsigned short v1:7; unsigned int v2:15; empty v3; };
struct BFu7s_BFu15ll_Sf { unsigned short v1:7; unsigned long long v2:15; empty v3; };
struct BFu7s_BFu15s_Sf { unsigned short v1:7; unsigned short v2:15; empty v3; };
struct BFu7s_BFu16i_Sf { unsigned short v1:7; unsigned int v2:16; empty v3; };
struct BFu7s_BFu16ll_Sf { unsigned short v1:7; unsigned long long v2:16; empty v3; };
struct BFu7s_BFu16s_Sf { unsigned short v1:7; unsigned short v2:16; empty v3; };
struct BFu7s_BFu17i_Sf { unsigned short v1:7; unsigned int v2:17; empty v3; };
struct BFu7s_BFu17ll_Sf { unsigned short v1:7; unsigned long long v2:17; empty v3; };
struct BFu7s_BFu1c_Sf { unsigned short v1:7; unsigned char v2:1; empty v3; };
struct BFu7s_BFu1i_Sf { unsigned short v1:7; unsigned int v2:1; empty v3; };
struct BFu7s_BFu1ll_Sf { unsigned short v1:7; unsigned long long v2:1; empty v3; };
struct BFu7s_BFu1s_Sf { unsigned short v1:7; unsigned short v2:1; empty v3; };
struct BFu7s_BFu31i_Sf { unsigned short v1:7; unsigned int v2:31; empty v3; };
struct BFu7s_BFu31ll_Sf { unsigned short v1:7; unsigned long long v2:31; empty v3; };
struct BFu7s_BFu32i_Sf { unsigned short v1:7; unsigned int v2:32; empty v3; };
struct BFu7s_BFu32ll_Sf { unsigned short v1:7; unsigned long long v2:32; empty v3; };
struct BFu7s_BFu33_Sf { unsigned short v1:7; unsigned long long v2:33; empty v3; };
struct BFu7s_BFu7c_Sf { unsigned short v1:7; unsigned char v2:7; empty v3; };
struct BFu7s_BFu7i_Sf { unsigned short v1:7; unsigned int v2:7; empty v3; };
struct BFu7s_BFu7ll_Sf { unsigned short v1:7; unsigned long long v2:7; empty v3; };
struct BFu7s_BFu7s_Sf { unsigned short v1:7; unsigned short v2:7; empty v3; };
struct BFu7s_BFu8c_Sf { unsigned short v1:7; unsigned char v2:8; empty v3; };
struct BFu7s_BFu8i_Sf { unsigned short v1:7; unsigned int v2:8; empty v3; };
struct BFu7s_BFu8ll_Sf { unsigned short v1:7; unsigned long long v2:8; empty v3; };
struct BFu7s_BFu8s_Sf { unsigned short v1:7; unsigned short v2:8; empty v3; };
struct BFu7s_BFu9i_Sf { unsigned short v1:7; unsigned int v2:9; empty v3; };
struct BFu7s_BFu9ll_Sf { unsigned short v1:7; unsigned long long v2:9; empty v3; };
struct BFu7s_BFu9s_Sf { unsigned short v1:7; unsigned short v2:9; empty v3; };
struct BFu7s_C_Sf { unsigned short v1:7; char v2; empty v3; };
struct BFu7s_D_Sf { unsigned short v1:7; double v2; empty v3; };
struct BFu7s_F_Sf { unsigned short v1:7; float v2; empty v3; };
struct BFu7s_I_Sf { unsigned short v1:7; int v2; empty v3; };
struct BFu7s_Ip_Sf { unsigned short v1:7; int * v2; empty v3; };
struct BFu7s_L_Sf { unsigned short v1:7; long long v2; empty v3; };
struct BFu7s_S_Sf { unsigned short v1:7; short v2; empty v3; };
struct BFu7s_Sf { unsigned short v1:7; empty v2; };
struct BFu7s_Sf_BFu15i { unsigned short v1:7; empty v2; unsigned int v3:15; };
struct BFu7s_Sf_BFu15ll { unsigned short v1:7; empty v2; unsigned long long v3:15; };
struct BFu7s_Sf_BFu15s { unsigned short v1:7; empty v2; unsigned short v3:15; };
struct BFu7s_Sf_BFu16i { unsigned short v1:7; empty v2; unsigned int v3:16; };
struct BFu7s_Sf_BFu16ll { unsigned short v1:7; empty v2; unsigned long long v3:16; };
struct BFu7s_Sf_BFu16s { unsigned short v1:7; empty v2; unsigned short v3:16; };
struct BFu7s_Sf_BFu17i { unsigned short v1:7; empty v2; unsigned int v3:17; };
struct BFu7s_Sf_BFu17ll { unsigned short v1:7; empty v2; unsigned long long v3:17; };
struct BFu7s_Sf_BFu1c { unsigned short v1:7; empty v2; unsigned char v3:1; };
struct BFu7s_Sf_BFu1i { unsigned short v1:7; empty v2; unsigned int v3:1; };
struct BFu7s_Sf_BFu1ll { unsigned short v1:7; empty v2; unsigned long long v3:1; };
struct BFu7s_Sf_BFu1s { unsigned short v1:7; empty v2; unsigned short v3:1; };
struct BFu7s_Sf_BFu31i { unsigned short v1:7; empty v2; unsigned int v3:31; };
struct BFu7s_Sf_BFu31ll { unsigned short v1:7; empty v2; unsigned long long v3:31; };
struct BFu7s_Sf_BFu32i { unsigned short v1:7; empty v2; unsigned int v3:32; };
struct BFu7s_Sf_BFu32ll { unsigned short v1:7; empty v2; unsigned long long v3:32; };
struct BFu7s_Sf_BFu33 { unsigned short v1:7; empty v2; unsigned long long v3:33; };
struct BFu7s_Sf_BFu7c { unsigned short v1:7; empty v2; unsigned char v3:7; };
struct BFu7s_Sf_BFu7i { unsigned short v1:7; empty v2; unsigned int v3:7; };
struct BFu7s_Sf_BFu7ll { unsigned short v1:7; empty v2; unsigned long long v3:7; };
struct BFu7s_Sf_BFu7s { unsigned short v1:7; empty v2; unsigned short v3:7; };
struct BFu7s_Sf_BFu8c { unsigned short v1:7; empty v2; unsigned char v3:8; };
struct BFu7s_Sf_BFu8i { unsigned short v1:7; empty v2; unsigned int v3:8; };
struct BFu7s_Sf_BFu8ll { unsigned short v1:7; empty v2; unsigned long long v3:8; };
struct BFu7s_Sf_BFu8s { unsigned short v1:7; empty v2; unsigned short v3:8; };
struct BFu7s_Sf_BFu9i { unsigned short v1:7; empty v2; unsigned int v3:9; };
struct BFu7s_Sf_BFu9ll { unsigned short v1:7; empty v2; unsigned long long v3:9; };
struct BFu7s_Sf_BFu9s { unsigned short v1:7; empty v2; unsigned short v3:9; };
struct BFu7s_Sf_C { unsigned short v1:7; empty v2; char v3; };
struct BFu7s_Sf_D { unsigned short v1:7; empty v2; double v3; };
struct BFu7s_Sf_F { unsigned short v1:7; empty v2; float v3; };
struct BFu7s_Sf_I { unsigned short v1:7; empty v2; int v3; };
struct BFu7s_Sf_Ip { unsigned short v1:7; empty v2; int * v3; };
struct BFu7s_Sf_L { unsigned short v1:7; empty v2; long long v3; };
struct BFu7s_Sf_S { unsigned short v1:7; empty v2; short v3; };
struct BFu7s_Sf_Sf { unsigned short v1:7; empty v2; empty v3; };
struct BFu7s_Sf_Uc { unsigned short v1:7; empty v2; unsigned char v3; };
struct BFu7s_Sf_Ui { unsigned short v1:7; empty v2; unsigned int v3; };
struct BFu7s_Sf_Ul { unsigned short v1:7; empty v2; unsigned long long v3; };
struct BFu7s_Sf_Us { unsigned short v1:7; empty v2; unsigned short v3; };
struct BFu7s_Sf_Vp { unsigned short v1:7; empty v2; void * v3; };
struct BFu7s_Uc_Sf { unsigned short v1:7; unsigned char v2; empty v3; };
struct BFu7s_Ui_Sf { unsigned short v1:7; unsigned int v2; empty v3; };
struct BFu7s_Ul_Sf { unsigned short v1:7; unsigned long long v2; empty v3; };
struct BFu7s_Us_Sf { unsigned short v1:7; unsigned short v2; empty v3; };
struct BFu7s_Vp_Sf { unsigned short v1:7; void * v2; empty v3; };
struct BFu8c_BFu15i_Sf { unsigned char v1:8; unsigned int v2:15; empty v3; };
struct BFu8c_BFu15ll_Sf { unsigned char v1:8; unsigned long long v2:15; empty v3; };
struct BFu8c_BFu15s_Sf { unsigned char v1:8; unsigned short v2:15; empty v3; };
struct BFu8c_BFu16i_Sf { unsigned char v1:8; unsigned int v2:16; empty v3; };
struct BFu8c_BFu16ll_Sf { unsigned char v1:8; unsigned long long v2:16; empty v3; };
struct BFu8c_BFu16s_Sf { unsigned char v1:8; unsigned short v2:16; empty v3; };
struct BFu8c_BFu17i_Sf { unsigned char v1:8; unsigned int v2:17; empty v3; };
struct BFu8c_BFu17ll_Sf { unsigned char v1:8; unsigned long long v2:17; empty v3; };
struct BFu8c_BFu1c_Sf { unsigned char v1:8; unsigned char v2:1; empty v3; };
struct BFu8c_BFu1i_Sf { unsigned char v1:8; unsigned int v2:1; empty v3; };
struct BFu8c_BFu1ll_Sf { unsigned char v1:8; unsigned long long v2:1; empty v3; };
struct BFu8c_BFu1s_Sf { unsigned char v1:8; unsigned short v2:1; empty v3; };
struct BFu8c_BFu31i_Sf { unsigned char v1:8; unsigned int v2:31; empty v3; };
struct BFu8c_BFu31ll_Sf { unsigned char v1:8; unsigned long long v2:31; empty v3; };
struct BFu8c_BFu32i_Sf { unsigned char v1:8; unsigned int v2:32; empty v3; };
struct BFu8c_BFu32ll_Sf { unsigned char v1:8; unsigned long long v2:32; empty v3; };
struct BFu8c_BFu33_Sf { unsigned char v1:8; unsigned long long v2:33; empty v3; };
struct BFu8c_BFu7c_Sf { unsigned char v1:8; unsigned char v2:7; empty v3; };
struct BFu8c_BFu7i_Sf { unsigned char v1:8; unsigned int v2:7; empty v3; };
struct BFu8c_BFu7ll_Sf { unsigned char v1:8; unsigned long long v2:7; empty v3; };
struct BFu8c_BFu7s_Sf { unsigned char v1:8; unsigned short v2:7; empty v3; };
struct BFu8c_BFu8c_Sf { unsigned char v1:8; unsigned char v2:8; empty v3; };
struct BFu8c_BFu8i_Sf { unsigned char v1:8; unsigned int v2:8; empty v3; };
struct BFu8c_BFu8ll_Sf { unsigned char v1:8; unsigned long long v2:8; empty v3; };
struct BFu8c_BFu8s_Sf { unsigned char v1:8; unsigned short v2:8; empty v3; };
struct BFu8c_BFu9i_Sf { unsigned char v1:8; unsigned int v2:9; empty v3; };
struct BFu8c_BFu9ll_Sf { unsigned char v1:8; unsigned long long v2:9; empty v3; };
struct BFu8c_BFu9s_Sf { unsigned char v1:8; unsigned short v2:9; empty v3; };
struct BFu8c_C_Sf { unsigned char v1:8; char v2; empty v3; };
struct BFu8c_D_Sf { unsigned char v1:8; double v2; empty v3; };
struct BFu8c_F_Sf { unsigned char v1:8; float v2; empty v3; };
struct BFu8c_I_Sf { unsigned char v1:8; int v2; empty v3; };
struct BFu8c_Ip_Sf { unsigned char v1:8; int * v2; empty v3; };
struct BFu8c_L_Sf { unsigned char v1:8; long long v2; empty v3; };
struct BFu8c_S_Sf { unsigned char v1:8; short v2; empty v3; };
struct BFu8c_Sf { unsigned char v1:8; empty v2; };
struct BFu8c_Sf_BFu15i { unsigned char v1:8; empty v2; unsigned int v3:15; };
struct BFu8c_Sf_BFu15ll { unsigned char v1:8; empty v2; unsigned long long v3:15; };
struct BFu8c_Sf_BFu15s { unsigned char v1:8; empty v2; unsigned short v3:15; };
struct BFu8c_Sf_BFu16i { unsigned char v1:8; empty v2; unsigned int v3:16; };
struct BFu8c_Sf_BFu16ll { unsigned char v1:8; empty v2; unsigned long long v3:16; };
struct BFu8c_Sf_BFu16s { unsigned char v1:8; empty v2; unsigned short v3:16; };
struct BFu8c_Sf_BFu17i { unsigned char v1:8; empty v2; unsigned int v3:17; };
struct BFu8c_Sf_BFu17ll { unsigned char v1:8; empty v2; unsigned long long v3:17; };
struct BFu8c_Sf_BFu1c { unsigned char v1:8; empty v2; unsigned char v3:1; };
struct BFu8c_Sf_BFu1i { unsigned char v1:8; empty v2; unsigned int v3:1; };
struct BFu8c_Sf_BFu1ll { unsigned char v1:8; empty v2; unsigned long long v3:1; };
struct BFu8c_Sf_BFu1s { unsigned char v1:8; empty v2; unsigned short v3:1; };
struct BFu8c_Sf_BFu31i { unsigned char v1:8; empty v2; unsigned int v3:31; };
struct BFu8c_Sf_BFu31ll { unsigned char v1:8; empty v2; unsigned long long v3:31; };
struct BFu8c_Sf_BFu32i { unsigned char v1:8; empty v2; unsigned int v3:32; };
struct BFu8c_Sf_BFu32ll { unsigned char v1:8; empty v2; unsigned long long v3:32; };
struct BFu8c_Sf_BFu33 { unsigned char v1:8; empty v2; unsigned long long v3:33; };
struct BFu8c_Sf_BFu7c { unsigned char v1:8; empty v2; unsigned char v3:7; };
struct BFu8c_Sf_BFu7i { unsigned char v1:8; empty v2; unsigned int v3:7; };
struct BFu8c_Sf_BFu7ll { unsigned char v1:8; empty v2; unsigned long long v3:7; };
struct BFu8c_Sf_BFu7s { unsigned char v1:8; empty v2; unsigned short v3:7; };
struct BFu8c_Sf_BFu8c { unsigned char v1:8; empty v2; unsigned char v3:8; };
struct BFu8c_Sf_BFu8i { unsigned char v1:8; empty v2; unsigned int v3:8; };
struct BFu8c_Sf_BFu8ll { unsigned char v1:8; empty v2; unsigned long long v3:8; };
struct BFu8c_Sf_BFu8s { unsigned char v1:8; empty v2; unsigned short v3:8; };
struct BFu8c_Sf_BFu9i { unsigned char v1:8; empty v2; unsigned int v3:9; };
struct BFu8c_Sf_BFu9ll { unsigned char v1:8; empty v2; unsigned long long v3:9; };
struct BFu8c_Sf_BFu9s { unsigned char v1:8; empty v2; unsigned short v3:9; };
struct BFu8c_Sf_C { unsigned char v1:8; empty v2; char v3; };
struct BFu8c_Sf_D { unsigned char v1:8; empty v2; double v3; };
struct BFu8c_Sf_F { unsigned char v1:8; empty v2; float v3; };
struct BFu8c_Sf_I { unsigned char v1:8; empty v2; int v3; };
struct BFu8c_Sf_Ip { unsigned char v1:8; empty v2; int * v3; };
struct BFu8c_Sf_L { unsigned char v1:8; empty v2; long long v3; };
struct BFu8c_Sf_S { unsigned char v1:8; empty v2; short v3; };
struct BFu8c_Sf_Sf { unsigned char v1:8; empty v2; empty v3; };
struct BFu8c_Sf_Uc { unsigned char v1:8; empty v2; unsigned char v3; };
struct BFu8c_Sf_Ui { unsigned char v1:8; empty v2; unsigned int v3; };
struct BFu8c_Sf_Ul { unsigned char v1:8; empty v2; unsigned long long v3; };
struct BFu8c_Sf_Us { unsigned char v1:8; empty v2; unsigned short v3; };
struct BFu8c_Sf_Vp { unsigned char v1:8; empty v2; void * v3; };
struct BFu8c_Uc_Sf { unsigned char v1:8; unsigned char v2; empty v3; };
struct BFu8c_Ui_Sf { unsigned char v1:8; unsigned int v2; empty v3; };
struct BFu8c_Ul_Sf { unsigned char v1:8; unsigned long long v2; empty v3; };
struct BFu8c_Us_Sf { unsigned char v1:8; unsigned short v2; empty v3; };
struct BFu8c_Vp_Sf { unsigned char v1:8; void * v2; empty v3; };
struct BFu8i_BFu15i_Sf { unsigned int v1:8; unsigned int v2:15; empty v3; };
struct BFu8i_BFu15ll_Sf { unsigned int v1:8; unsigned long long v2:15; empty v3; };
struct BFu8i_BFu15s_Sf { unsigned int v1:8; unsigned short v2:15; empty v3; };
struct BFu8i_BFu16i_Sf { unsigned int v1:8; unsigned int v2:16; empty v3; };
struct BFu8i_BFu16ll_Sf { unsigned int v1:8; unsigned long long v2:16; empty v3; };
struct BFu8i_BFu16s_Sf { unsigned int v1:8; unsigned short v2:16; empty v3; };
struct BFu8i_BFu17i_Sf { unsigned int v1:8; unsigned int v2:17; empty v3; };
struct BFu8i_BFu17ll_Sf { unsigned int v1:8; unsigned long long v2:17; empty v3; };
struct BFu8i_BFu1c_Sf { unsigned int v1:8; unsigned char v2:1; empty v3; };
struct BFu8i_BFu1i_Sf { unsigned int v1:8; unsigned int v2:1; empty v3; };
struct BFu8i_BFu1ll_Sf { unsigned int v1:8; unsigned long long v2:1; empty v3; };
struct BFu8i_BFu1s_Sf { unsigned int v1:8; unsigned short v2:1; empty v3; };
struct BFu8i_BFu31i_Sf { unsigned int v1:8; unsigned int v2:31; empty v3; };
struct BFu8i_BFu31ll_Sf { unsigned int v1:8; unsigned long long v2:31; empty v3; };
struct BFu8i_BFu32i_Sf { unsigned int v1:8; unsigned int v2:32; empty v3; };
struct BFu8i_BFu32ll_Sf { unsigned int v1:8; unsigned long long v2:32; empty v3; };
struct BFu8i_BFu33_Sf { unsigned int v1:8; unsigned long long v2:33; empty v3; };
struct BFu8i_BFu7c_Sf { unsigned int v1:8; unsigned char v2:7; empty v3; };
struct BFu8i_BFu7i_Sf { unsigned int v1:8; unsigned int v2:7; empty v3; };
struct BFu8i_BFu7ll_Sf { unsigned int v1:8; unsigned long long v2:7; empty v3; };
struct BFu8i_BFu7s_Sf { unsigned int v1:8; unsigned short v2:7; empty v3; };
struct BFu8i_BFu8c_Sf { unsigned int v1:8; unsigned char v2:8; empty v3; };
struct BFu8i_BFu8i_Sf { unsigned int v1:8; unsigned int v2:8; empty v3; };
struct BFu8i_BFu8ll_Sf { unsigned int v1:8; unsigned long long v2:8; empty v3; };
struct BFu8i_BFu8s_Sf { unsigned int v1:8; unsigned short v2:8; empty v3; };
struct BFu8i_BFu9i_Sf { unsigned int v1:8; unsigned int v2:9; empty v3; };
struct BFu8i_BFu9ll_Sf { unsigned int v1:8; unsigned long long v2:9; empty v3; };
struct BFu8i_BFu9s_Sf { unsigned int v1:8; unsigned short v2:9; empty v3; };
struct BFu8i_C_Sf { unsigned int v1:8; char v2; empty v3; };
struct BFu8i_D_Sf { unsigned int v1:8; double v2; empty v3; };
struct BFu8i_F_Sf { unsigned int v1:8; float v2; empty v3; };
struct BFu8i_I_Sf { unsigned int v1:8; int v2; empty v3; };
struct BFu8i_Ip_Sf { unsigned int v1:8; int * v2; empty v3; };
struct BFu8i_L_Sf { unsigned int v1:8; long long v2; empty v3; };
struct BFu8i_S_Sf { unsigned int v1:8; short v2; empty v3; };
struct BFu8i_Sf { unsigned int v1:8; empty v2; };
struct BFu8i_Sf_BFu15i { unsigned int v1:8; empty v2; unsigned int v3:15; };
struct BFu8i_Sf_BFu15ll { unsigned int v1:8; empty v2; unsigned long long v3:15; };
struct BFu8i_Sf_BFu15s { unsigned int v1:8; empty v2; unsigned short v3:15; };
struct BFu8i_Sf_BFu16i { unsigned int v1:8; empty v2; unsigned int v3:16; };
struct BFu8i_Sf_BFu16ll { unsigned int v1:8; empty v2; unsigned long long v3:16; };
struct BFu8i_Sf_BFu16s { unsigned int v1:8; empty v2; unsigned short v3:16; };
struct BFu8i_Sf_BFu17i { unsigned int v1:8; empty v2; unsigned int v3:17; };
struct BFu8i_Sf_BFu17ll { unsigned int v1:8; empty v2; unsigned long long v3:17; };
struct BFu8i_Sf_BFu1c { unsigned int v1:8; empty v2; unsigned char v3:1; };
struct BFu8i_Sf_BFu1i { unsigned int v1:8; empty v2; unsigned int v3:1; };
struct BFu8i_Sf_BFu1ll { unsigned int v1:8; empty v2; unsigned long long v3:1; };
struct BFu8i_Sf_BFu1s { unsigned int v1:8; empty v2; unsigned short v3:1; };
struct BFu8i_Sf_BFu31i { unsigned int v1:8; empty v2; unsigned int v3:31; };
struct BFu8i_Sf_BFu31ll { unsigned int v1:8; empty v2; unsigned long long v3:31; };
struct BFu8i_Sf_BFu32i { unsigned int v1:8; empty v2; unsigned int v3:32; };
struct BFu8i_Sf_BFu32ll { unsigned int v1:8; empty v2; unsigned long long v3:32; };
struct BFu8i_Sf_BFu33 { unsigned int v1:8; empty v2; unsigned long long v3:33; };
struct BFu8i_Sf_BFu7c { unsigned int v1:8; empty v2; unsigned char v3:7; };
struct BFu8i_Sf_BFu7i { unsigned int v1:8; empty v2; unsigned int v3:7; };
struct BFu8i_Sf_BFu7ll { unsigned int v1:8; empty v2; unsigned long long v3:7; };
struct BFu8i_Sf_BFu7s { unsigned int v1:8; empty v2; unsigned short v3:7; };
struct BFu8i_Sf_BFu8c { unsigned int v1:8; empty v2; unsigned char v3:8; };
struct BFu8i_Sf_BFu8i { unsigned int v1:8; empty v2; unsigned int v3:8; };
struct BFu8i_Sf_BFu8ll { unsigned int v1:8; empty v2; unsigned long long v3:8; };
struct BFu8i_Sf_BFu8s { unsigned int v1:8; empty v2; unsigned short v3:8; };
struct BFu8i_Sf_BFu9i { unsigned int v1:8; empty v2; unsigned int v3:9; };
struct BFu8i_Sf_BFu9ll { unsigned int v1:8; empty v2; unsigned long long v3:9; };
struct BFu8i_Sf_BFu9s { unsigned int v1:8; empty v2; unsigned short v3:9; };
struct BFu8i_Sf_C { unsigned int v1:8; empty v2; char v3; };
struct BFu8i_Sf_D { unsigned int v1:8; empty v2; double v3; };
struct BFu8i_Sf_F { unsigned int v1:8; empty v2; float v3; };
struct BFu8i_Sf_I { unsigned int v1:8; empty v2; int v3; };
struct BFu8i_Sf_Ip { unsigned int v1:8; empty v2; int * v3; };
struct BFu8i_Sf_L { unsigned int v1:8; empty v2; long long v3; };
struct BFu8i_Sf_S { unsigned int v1:8; empty v2; short v3; };
struct BFu8i_Sf_Sf { unsigned int v1:8; empty v2; empty v3; };
struct BFu8i_Sf_Uc { unsigned int v1:8; empty v2; unsigned char v3; };
struct BFu8i_Sf_Ui { unsigned int v1:8; empty v2; unsigned int v3; };
struct BFu8i_Sf_Ul { unsigned int v1:8; empty v2; unsigned long long v3; };
struct BFu8i_Sf_Us { unsigned int v1:8; empty v2; unsigned short v3; };
struct BFu8i_Sf_Vp { unsigned int v1:8; empty v2; void * v3; };
struct BFu8i_Uc_Sf { unsigned int v1:8; unsigned char v2; empty v3; };
struct BFu8i_Ui_Sf { unsigned int v1:8; unsigned int v2; empty v3; };
struct BFu8i_Ul_Sf { unsigned int v1:8; unsigned long long v2; empty v3; };
struct BFu8i_Us_Sf { unsigned int v1:8; unsigned short v2; empty v3; };
struct BFu8i_Vp_Sf { unsigned int v1:8; void * v2; empty v3; };
struct BFu8ll_BFu15i_Sf { unsigned long long v1:8; unsigned int v2:15; empty v3; };
struct BFu8ll_BFu15ll_Sf { unsigned long long v1:8; unsigned long long v2:15; empty v3; };
struct BFu8ll_BFu15s_Sf { unsigned long long v1:8; unsigned short v2:15; empty v3; };
struct BFu8ll_BFu16i_Sf { unsigned long long v1:8; unsigned int v2:16; empty v3; };
struct BFu8ll_BFu16ll_Sf { unsigned long long v1:8; unsigned long long v2:16; empty v3; };
struct BFu8ll_BFu16s_Sf { unsigned long long v1:8; unsigned short v2:16; empty v3; };
struct BFu8ll_BFu17i_Sf { unsigned long long v1:8; unsigned int v2:17; empty v3; };
struct BFu8ll_BFu17ll_Sf { unsigned long long v1:8; unsigned long long v2:17; empty v3; };
struct BFu8ll_BFu1c_Sf { unsigned long long v1:8; unsigned char v2:1; empty v3; };
struct BFu8ll_BFu1i_Sf { unsigned long long v1:8; unsigned int v2:1; empty v3; };
struct BFu8ll_BFu1ll_Sf { unsigned long long v1:8; unsigned long long v2:1; empty v3; };
struct BFu8ll_BFu1s_Sf { unsigned long long v1:8; unsigned short v2:1; empty v3; };
struct BFu8ll_BFu31i_Sf { unsigned long long v1:8; unsigned int v2:31; empty v3; };
struct BFu8ll_BFu31ll_Sf { unsigned long long v1:8; unsigned long long v2:31; empty v3; };
struct BFu8ll_BFu32i_Sf { unsigned long long v1:8; unsigned int v2:32; empty v3; };
struct BFu8ll_BFu32ll_Sf { unsigned long long v1:8; unsigned long long v2:32; empty v3; };
struct BFu8ll_BFu33_Sf { unsigned long long v1:8; unsigned long long v2:33; empty v3; };
struct BFu8ll_BFu7c_Sf { unsigned long long v1:8; unsigned char v2:7; empty v3; };
struct BFu8ll_BFu7i_Sf { unsigned long long v1:8; unsigned int v2:7; empty v3; };
struct BFu8ll_BFu7ll_Sf { unsigned long long v1:8; unsigned long long v2:7; empty v3; };
struct BFu8ll_BFu7s_Sf { unsigned long long v1:8; unsigned short v2:7; empty v3; };
struct BFu8ll_BFu8c_Sf { unsigned long long v1:8; unsigned char v2:8; empty v3; };
struct BFu8ll_BFu8i_Sf { unsigned long long v1:8; unsigned int v2:8; empty v3; };
struct BFu8ll_BFu8ll_Sf { unsigned long long v1:8; unsigned long long v2:8; empty v3; };
struct BFu8ll_BFu8s_Sf { unsigned long long v1:8; unsigned short v2:8; empty v3; };
struct BFu8ll_BFu9i_Sf { unsigned long long v1:8; unsigned int v2:9; empty v3; };
struct BFu8ll_BFu9ll_Sf { unsigned long long v1:8; unsigned long long v2:9; empty v3; };
struct BFu8ll_BFu9s_Sf { unsigned long long v1:8; unsigned short v2:9; empty v3; };
struct BFu8ll_C_Sf { unsigned long long v1:8; char v2; empty v3; };
struct BFu8ll_D_Sf { unsigned long long v1:8; double v2; empty v3; };
struct BFu8ll_F_Sf { unsigned long long v1:8; float v2; empty v3; };
struct BFu8ll_I_Sf { unsigned long long v1:8; int v2; empty v3; };
struct BFu8ll_Ip_Sf { unsigned long long v1:8; int * v2; empty v3; };
struct BFu8ll_L_Sf { unsigned long long v1:8; long long v2; empty v3; };
struct BFu8ll_S_Sf { unsigned long long v1:8; short v2; empty v3; };
struct BFu8ll_Sf { unsigned long long v1:8; empty v2; };
struct BFu8ll_Sf_BFu15i { unsigned long long v1:8; empty v2; unsigned int v3:15; };
struct BFu8ll_Sf_BFu15ll { unsigned long long v1:8; empty v2; unsigned long long v3:15; };
struct BFu8ll_Sf_BFu15s { unsigned long long v1:8; empty v2; unsigned short v3:15; };
struct BFu8ll_Sf_BFu16i { unsigned long long v1:8; empty v2; unsigned int v3:16; };
struct BFu8ll_Sf_BFu16ll { unsigned long long v1:8; empty v2; unsigned long long v3:16; };
struct BFu8ll_Sf_BFu16s { unsigned long long v1:8; empty v2; unsigned short v3:16; };
struct BFu8ll_Sf_BFu17i { unsigned long long v1:8; empty v2; unsigned int v3:17; };
struct BFu8ll_Sf_BFu17ll { unsigned long long v1:8; empty v2; unsigned long long v3:17; };
struct BFu8ll_Sf_BFu1c { unsigned long long v1:8; empty v2; unsigned char v3:1; };
struct BFu8ll_Sf_BFu1i { unsigned long long v1:8; empty v2; unsigned int v3:1; };
struct BFu8ll_Sf_BFu1ll { unsigned long long v1:8; empty v2; unsigned long long v3:1; };
struct BFu8ll_Sf_BFu1s { unsigned long long v1:8; empty v2; unsigned short v3:1; };
struct BFu8ll_Sf_BFu31i { unsigned long long v1:8; empty v2; unsigned int v3:31; };
struct BFu8ll_Sf_BFu31ll { unsigned long long v1:8; empty v2; unsigned long long v3:31; };
struct BFu8ll_Sf_BFu32i { unsigned long long v1:8; empty v2; unsigned int v3:32; };
struct BFu8ll_Sf_BFu32ll { unsigned long long v1:8; empty v2; unsigned long long v3:32; };
struct BFu8ll_Sf_BFu33 { unsigned long long v1:8; empty v2; unsigned long long v3:33; };
struct BFu8ll_Sf_BFu7c { unsigned long long v1:8; empty v2; unsigned char v3:7; };
struct BFu8ll_Sf_BFu7i { unsigned long long v1:8; empty v2; unsigned int v3:7; };
struct BFu8ll_Sf_BFu7ll { unsigned long long v1:8; empty v2; unsigned long long v3:7; };
struct BFu8ll_Sf_BFu7s { unsigned long long v1:8; empty v2; unsigned short v3:7; };
struct BFu8ll_Sf_BFu8c { unsigned long long v1:8; empty v2; unsigned char v3:8; };
struct BFu8ll_Sf_BFu8i { unsigned long long v1:8; empty v2; unsigned int v3:8; };
struct BFu8ll_Sf_BFu8ll { unsigned long long v1:8; empty v2; unsigned long long v3:8; };
struct BFu8ll_Sf_BFu8s { unsigned long long v1:8; empty v2; unsigned short v3:8; };
struct BFu8ll_Sf_BFu9i { unsigned long long v1:8; empty v2; unsigned int v3:9; };
struct BFu8ll_Sf_BFu9ll { unsigned long long v1:8; empty v2; unsigned long long v3:9; };
struct BFu8ll_Sf_BFu9s { unsigned long long v1:8; empty v2; unsigned short v3:9; };
struct BFu8ll_Sf_C { unsigned long long v1:8; empty v2; char v3; };
struct BFu8ll_Sf_D { unsigned long long v1:8; empty v2; double v3; };
struct BFu8ll_Sf_F { unsigned long long v1:8; empty v2; float v3; };
struct BFu8ll_Sf_I { unsigned long long v1:8; empty v2; int v3; };
struct BFu8ll_Sf_Ip { unsigned long long v1:8; empty v2; int * v3; };
struct BFu8ll_Sf_L { unsigned long long v1:8; empty v2; long long v3; };
struct BFu8ll_Sf_S { unsigned long long v1:8; empty v2; short v3; };
struct BFu8ll_Sf_Sf { unsigned long long v1:8; empty v2; empty v3; };
struct BFu8ll_Sf_Uc { unsigned long long v1:8; empty v2; unsigned char v3; };
struct BFu8ll_Sf_Ui { unsigned long long v1:8; empty v2; unsigned int v3; };
struct BFu8ll_Sf_Ul { unsigned long long v1:8; empty v2; unsigned long long v3; };
struct BFu8ll_Sf_Us { unsigned long long v1:8; empty v2; unsigned short v3; };
struct BFu8ll_Sf_Vp { unsigned long long v1:8; empty v2; void * v3; };
struct BFu8ll_Uc_Sf { unsigned long long v1:8; unsigned char v2; empty v3; };
struct BFu8ll_Ui_Sf { unsigned long long v1:8; unsigned int v2; empty v3; };
struct BFu8ll_Ul_Sf { unsigned long long v1:8; unsigned long long v2; empty v3; };
struct BFu8ll_Us_Sf { unsigned long long v1:8; unsigned short v2; empty v3; };
struct BFu8ll_Vp_Sf { unsigned long long v1:8; void * v2; empty v3; };
struct BFu8s_BFu15i_Sf { unsigned short v1:8; unsigned int v2:15; empty v3; };
struct BFu8s_BFu15ll_Sf { unsigned short v1:8; unsigned long long v2:15; empty v3; };
struct BFu8s_BFu15s_Sf { unsigned short v1:8; unsigned short v2:15; empty v3; };
struct BFu8s_BFu16i_Sf { unsigned short v1:8; unsigned int v2:16; empty v3; };
struct BFu8s_BFu16ll_Sf { unsigned short v1:8; unsigned long long v2:16; empty v3; };
struct BFu8s_BFu16s_Sf { unsigned short v1:8; unsigned short v2:16; empty v3; };
struct BFu8s_BFu17i_Sf { unsigned short v1:8; unsigned int v2:17; empty v3; };
struct BFu8s_BFu17ll_Sf { unsigned short v1:8; unsigned long long v2:17; empty v3; };
struct BFu8s_BFu1c_Sf { unsigned short v1:8; unsigned char v2:1; empty v3; };
struct BFu8s_BFu1i_Sf { unsigned short v1:8; unsigned int v2:1; empty v3; };
struct BFu8s_BFu1ll_Sf { unsigned short v1:8; unsigned long long v2:1; empty v3; };
struct BFu8s_BFu1s_Sf { unsigned short v1:8; unsigned short v2:1; empty v3; };
struct BFu8s_BFu31i_Sf { unsigned short v1:8; unsigned int v2:31; empty v3; };
struct BFu8s_BFu31ll_Sf { unsigned short v1:8; unsigned long long v2:31; empty v3; };
struct BFu8s_BFu32i_Sf { unsigned short v1:8; unsigned int v2:32; empty v3; };
struct BFu8s_BFu32ll_Sf { unsigned short v1:8; unsigned long long v2:32; empty v3; };
struct BFu8s_BFu33_Sf { unsigned short v1:8; unsigned long long v2:33; empty v3; };
struct BFu8s_BFu7c_Sf { unsigned short v1:8; unsigned char v2:7; empty v3; };
struct BFu8s_BFu7i_Sf { unsigned short v1:8; unsigned int v2:7; empty v3; };
struct BFu8s_BFu7ll_Sf { unsigned short v1:8; unsigned long long v2:7; empty v3; };
struct BFu8s_BFu7s_Sf { unsigned short v1:8; unsigned short v2:7; empty v3; };
struct BFu8s_BFu8c_Sf { unsigned short v1:8; unsigned char v2:8; empty v3; };
struct BFu8s_BFu8i_Sf { unsigned short v1:8; unsigned int v2:8; empty v3; };
struct BFu8s_BFu8ll_Sf { unsigned short v1:8; unsigned long long v2:8; empty v3; };
struct BFu8s_BFu8s_Sf { unsigned short v1:8; unsigned short v2:8; empty v3; };
struct BFu8s_BFu9i_Sf { unsigned short v1:8; unsigned int v2:9; empty v3; };
struct BFu8s_BFu9ll_Sf { unsigned short v1:8; unsigned long long v2:9; empty v3; };
struct BFu8s_BFu9s_Sf { unsigned short v1:8; unsigned short v2:9; empty v3; };
struct BFu8s_C_Sf { unsigned short v1:8; char v2; empty v3; };
struct BFu8s_D_Sf { unsigned short v1:8; double v2; empty v3; };
struct BFu8s_F_Sf { unsigned short v1:8; float v2; empty v3; };
struct BFu8s_I_Sf { unsigned short v1:8; int v2; empty v3; };
struct BFu8s_Ip_Sf { unsigned short v1:8; int * v2; empty v3; };
struct BFu8s_L_Sf { unsigned short v1:8; long long v2; empty v3; };
struct BFu8s_S_Sf { unsigned short v1:8; short v2; empty v3; };
struct BFu8s_Sf { unsigned short v1:8; empty v2; };
struct BFu8s_Sf_BFu15i { unsigned short v1:8; empty v2; unsigned int v3:15; };
struct BFu8s_Sf_BFu15ll { unsigned short v1:8; empty v2; unsigned long long v3:15; };
struct BFu8s_Sf_BFu15s { unsigned short v1:8; empty v2; unsigned short v3:15; };
struct BFu8s_Sf_BFu16i { unsigned short v1:8; empty v2; unsigned int v3:16; };
struct BFu8s_Sf_BFu16ll { unsigned short v1:8; empty v2; unsigned long long v3:16; };
struct BFu8s_Sf_BFu16s { unsigned short v1:8; empty v2; unsigned short v3:16; };
struct BFu8s_Sf_BFu17i { unsigned short v1:8; empty v2; unsigned int v3:17; };
struct BFu8s_Sf_BFu17ll { unsigned short v1:8; empty v2; unsigned long long v3:17; };
struct BFu8s_Sf_BFu1c { unsigned short v1:8; empty v2; unsigned char v3:1; };
struct BFu8s_Sf_BFu1i { unsigned short v1:8; empty v2; unsigned int v3:1; };
struct BFu8s_Sf_BFu1ll { unsigned short v1:8; empty v2; unsigned long long v3:1; };
struct BFu8s_Sf_BFu1s { unsigned short v1:8; empty v2; unsigned short v3:1; };
struct BFu8s_Sf_BFu31i { unsigned short v1:8; empty v2; unsigned int v3:31; };
struct BFu8s_Sf_BFu31ll { unsigned short v1:8; empty v2; unsigned long long v3:31; };
struct BFu8s_Sf_BFu32i { unsigned short v1:8; empty v2; unsigned int v3:32; };
struct BFu8s_Sf_BFu32ll { unsigned short v1:8; empty v2; unsigned long long v3:32; };
struct BFu8s_Sf_BFu33 { unsigned short v1:8; empty v2; unsigned long long v3:33; };
struct BFu8s_Sf_BFu7c { unsigned short v1:8; empty v2; unsigned char v3:7; };
struct BFu8s_Sf_BFu7i { unsigned short v1:8; empty v2; unsigned int v3:7; };
struct BFu8s_Sf_BFu7ll { unsigned short v1:8; empty v2; unsigned long long v3:7; };
struct BFu8s_Sf_BFu7s { unsigned short v1:8; empty v2; unsigned short v3:7; };
struct BFu8s_Sf_BFu8c { unsigned short v1:8; empty v2; unsigned char v3:8; };
struct BFu8s_Sf_BFu8i { unsigned short v1:8; empty v2; unsigned int v3:8; };
struct BFu8s_Sf_BFu8ll { unsigned short v1:8; empty v2; unsigned long long v3:8; };
struct BFu8s_Sf_BFu8s { unsigned short v1:8; empty v2; unsigned short v3:8; };
struct BFu8s_Sf_BFu9i { unsigned short v1:8; empty v2; unsigned int v3:9; };
struct BFu8s_Sf_BFu9ll { unsigned short v1:8; empty v2; unsigned long long v3:9; };
struct BFu8s_Sf_BFu9s { unsigned short v1:8; empty v2; unsigned short v3:9; };
struct BFu8s_Sf_C { unsigned short v1:8; empty v2; char v3; };
struct BFu8s_Sf_D { unsigned short v1:8; empty v2; double v3; };
struct BFu8s_Sf_F { unsigned short v1:8; empty v2; float v3; };
struct BFu8s_Sf_I { unsigned short v1:8; empty v2; int v3; };
struct BFu8s_Sf_Ip { unsigned short v1:8; empty v2; int * v3; };
struct BFu8s_Sf_L { unsigned short v1:8; empty v2; long long v3; };
struct BFu8s_Sf_S { unsigned short v1:8; empty v2; short v3; };
struct BFu8s_Sf_Sf { unsigned short v1:8; empty v2; empty v3; };
struct BFu8s_Sf_Uc { unsigned short v1:8; empty v2; unsigned char v3; };
struct BFu8s_Sf_Ui { unsigned short v1:8; empty v2; unsigned int v3; };
struct BFu8s_Sf_Ul { unsigned short v1:8; empty v2; unsigned long long v3; };
struct BFu8s_Sf_Us { unsigned short v1:8; empty v2; unsigned short v3; };
struct BFu8s_Sf_Vp { unsigned short v1:8; empty v2; void * v3; };
struct BFu8s_Uc_Sf { unsigned short v1:8; unsigned char v2; empty v3; };
struct BFu8s_Ui_Sf { unsigned short v1:8; unsigned int v2; empty v3; };
struct BFu8s_Ul_Sf { unsigned short v1:8; unsigned long long v2; empty v3; };
struct BFu8s_Us_Sf { unsigned short v1:8; unsigned short v2; empty v3; };
struct BFu8s_Vp_Sf { unsigned short v1:8; void * v2; empty v3; };
struct BFu9i_BFu15i_Sf { unsigned int v1:9; unsigned int v2:15; empty v3; };
struct BFu9i_BFu15ll_Sf { unsigned int v1:9; unsigned long long v2:15; empty v3; };
struct BFu9i_BFu15s_Sf { unsigned int v1:9; unsigned short v2:15; empty v3; };
struct BFu9i_BFu16i_Sf { unsigned int v1:9; unsigned int v2:16; empty v3; };
struct BFu9i_BFu16ll_Sf { unsigned int v1:9; unsigned long long v2:16; empty v3; };
struct BFu9i_BFu16s_Sf { unsigned int v1:9; unsigned short v2:16; empty v3; };
struct BFu9i_BFu17i_Sf { unsigned int v1:9; unsigned int v2:17; empty v3; };
struct BFu9i_BFu17ll_Sf { unsigned int v1:9; unsigned long long v2:17; empty v3; };
struct BFu9i_BFu1c_Sf { unsigned int v1:9; unsigned char v2:1; empty v3; };
struct BFu9i_BFu1i_Sf { unsigned int v1:9; unsigned int v2:1; empty v3; };
struct BFu9i_BFu1ll_Sf { unsigned int v1:9; unsigned long long v2:1; empty v3; };
struct BFu9i_BFu1s_Sf { unsigned int v1:9; unsigned short v2:1; empty v3; };
struct BFu9i_BFu31i_Sf { unsigned int v1:9; unsigned int v2:31; empty v3; };
struct BFu9i_BFu31ll_Sf { unsigned int v1:9; unsigned long long v2:31; empty v3; };
struct BFu9i_BFu32i_Sf { unsigned int v1:9; unsigned int v2:32; empty v3; };
struct BFu9i_BFu32ll_Sf { unsigned int v1:9; unsigned long long v2:32; empty v3; };
struct BFu9i_BFu33_Sf { unsigned int v1:9; unsigned long long v2:33; empty v3; };
struct BFu9i_BFu7c_Sf { unsigned int v1:9; unsigned char v2:7; empty v3; };
struct BFu9i_BFu7i_Sf { unsigned int v1:9; unsigned int v2:7; empty v3; };
struct BFu9i_BFu7ll_Sf { unsigned int v1:9; unsigned long long v2:7; empty v3; };
struct BFu9i_BFu7s_Sf { unsigned int v1:9; unsigned short v2:7; empty v3; };
struct BFu9i_BFu8c_Sf { unsigned int v1:9; unsigned char v2:8; empty v3; };
struct BFu9i_BFu8i_Sf { unsigned int v1:9; unsigned int v2:8; empty v3; };
struct BFu9i_BFu8ll_Sf { unsigned int v1:9; unsigned long long v2:8; empty v3; };
struct BFu9i_BFu8s_Sf { unsigned int v1:9; unsigned short v2:8; empty v3; };
struct BFu9i_BFu9i_Sf { unsigned int v1:9; unsigned int v2:9; empty v3; };
struct BFu9i_BFu9ll_Sf { unsigned int v1:9; unsigned long long v2:9; empty v3; };
struct BFu9i_BFu9s_Sf { unsigned int v1:9; unsigned short v2:9; empty v3; };
struct BFu9i_C_Sf { unsigned int v1:9; char v2; empty v3; };
struct BFu9i_D_Sf { unsigned int v1:9; double v2; empty v3; };
struct BFu9i_F_Sf { unsigned int v1:9; float v2; empty v3; };
struct BFu9i_I_Sf { unsigned int v1:9; int v2; empty v3; };
struct BFu9i_Ip_Sf { unsigned int v1:9; int * v2; empty v3; };
struct BFu9i_L_Sf { unsigned int v1:9; long long v2; empty v3; };
struct BFu9i_S_Sf { unsigned int v1:9; short v2; empty v3; };
struct BFu9i_Sf { unsigned int v1:9; empty v2; };
struct BFu9i_Sf_BFu15i { unsigned int v1:9; empty v2; unsigned int v3:15; };
struct BFu9i_Sf_BFu15ll { unsigned int v1:9; empty v2; unsigned long long v3:15; };
struct BFu9i_Sf_BFu15s { unsigned int v1:9; empty v2; unsigned short v3:15; };
struct BFu9i_Sf_BFu16i { unsigned int v1:9; empty v2; unsigned int v3:16; };
struct BFu9i_Sf_BFu16ll { unsigned int v1:9; empty v2; unsigned long long v3:16; };
struct BFu9i_Sf_BFu16s { unsigned int v1:9; empty v2; unsigned short v3:16; };
struct BFu9i_Sf_BFu17i { unsigned int v1:9; empty v2; unsigned int v3:17; };
struct BFu9i_Sf_BFu17ll { unsigned int v1:9; empty v2; unsigned long long v3:17; };
struct BFu9i_Sf_BFu1c { unsigned int v1:9; empty v2; unsigned char v3:1; };
struct BFu9i_Sf_BFu1i { unsigned int v1:9; empty v2; unsigned int v3:1; };
struct BFu9i_Sf_BFu1ll { unsigned int v1:9; empty v2; unsigned long long v3:1; };
struct BFu9i_Sf_BFu1s { unsigned int v1:9; empty v2; unsigned short v3:1; };
struct BFu9i_Sf_BFu31i { unsigned int v1:9; empty v2; unsigned int v3:31; };
struct BFu9i_Sf_BFu31ll { unsigned int v1:9; empty v2; unsigned long long v3:31; };
struct BFu9i_Sf_BFu32i { unsigned int v1:9; empty v2; unsigned int v3:32; };
struct BFu9i_Sf_BFu32ll { unsigned int v1:9; empty v2; unsigned long long v3:32; };
struct BFu9i_Sf_BFu33 { unsigned int v1:9; empty v2; unsigned long long v3:33; };
struct BFu9i_Sf_BFu7c { unsigned int v1:9; empty v2; unsigned char v3:7; };
struct BFu9i_Sf_BFu7i { unsigned int v1:9; empty v2; unsigned int v3:7; };
struct BFu9i_Sf_BFu7ll { unsigned int v1:9; empty v2; unsigned long long v3:7; };
struct BFu9i_Sf_BFu7s { unsigned int v1:9; empty v2; unsigned short v3:7; };
struct BFu9i_Sf_BFu8c { unsigned int v1:9; empty v2; unsigned char v3:8; };
struct BFu9i_Sf_BFu8i { unsigned int v1:9; empty v2; unsigned int v3:8; };
struct BFu9i_Sf_BFu8ll { unsigned int v1:9; empty v2; unsigned long long v3:8; };
struct BFu9i_Sf_BFu8s { unsigned int v1:9; empty v2; unsigned short v3:8; };
struct BFu9i_Sf_BFu9i { unsigned int v1:9; empty v2; unsigned int v3:9; };
struct BFu9i_Sf_BFu9ll { unsigned int v1:9; empty v2; unsigned long long v3:9; };
struct BFu9i_Sf_BFu9s { unsigned int v1:9; empty v2; unsigned short v3:9; };
struct BFu9i_Sf_C { unsigned int v1:9; empty v2; char v3; };
struct BFu9i_Sf_D { unsigned int v1:9; empty v2; double v3; };
struct BFu9i_Sf_F { unsigned int v1:9; empty v2; float v3; };
struct BFu9i_Sf_I { unsigned int v1:9; empty v2; int v3; };
struct BFu9i_Sf_Ip { unsigned int v1:9; empty v2; int * v3; };
struct BFu9i_Sf_L { unsigned int v1:9; empty v2; long long v3; };
struct BFu9i_Sf_S { unsigned int v1:9; empty v2; short v3; };
struct BFu9i_Sf_Sf { unsigned int v1:9; empty v2; empty v3; };
struct BFu9i_Sf_Uc { unsigned int v1:9; empty v2; unsigned char v3; };
struct BFu9i_Sf_Ui { unsigned int v1:9; empty v2; unsigned int v3; };
struct BFu9i_Sf_Ul { unsigned int v1:9; empty v2; unsigned long long v3; };
struct BFu9i_Sf_Us { unsigned int v1:9; empty v2; unsigned short v3; };
struct BFu9i_Sf_Vp { unsigned int v1:9; empty v2; void * v3; };
struct BFu9i_Uc_Sf { unsigned int v1:9; unsigned char v2; empty v3; };
struct BFu9i_Ui_Sf { unsigned int v1:9; unsigned int v2; empty v3; };
struct BFu9i_Ul_Sf { unsigned int v1:9; unsigned long long v2; empty v3; };
struct BFu9i_Us_Sf { unsigned int v1:9; unsigned short v2; empty v3; };
struct BFu9i_Vp_Sf { unsigned int v1:9; void * v2; empty v3; };
struct BFu9ll_BFu15i_Sf { unsigned long long v1:9; unsigned int v2:15; empty v3; };
struct BFu9ll_BFu15ll_Sf { unsigned long long v1:9; unsigned long long v2:15; empty v3; };
struct BFu9ll_BFu15s_Sf { unsigned long long v1:9; unsigned short v2:15; empty v3; };
struct BFu9ll_BFu16i_Sf { unsigned long long v1:9; unsigned int v2:16; empty v3; };
struct BFu9ll_BFu16ll_Sf { unsigned long long v1:9; unsigned long long v2:16; empty v3; };
struct BFu9ll_BFu16s_Sf { unsigned long long v1:9; unsigned short v2:16; empty v3; };
struct BFu9ll_BFu17i_Sf { unsigned long long v1:9; unsigned int v2:17; empty v3; };
struct BFu9ll_BFu17ll_Sf { unsigned long long v1:9; unsigned long long v2:17; empty v3; };
struct BFu9ll_BFu1c_Sf { unsigned long long v1:9; unsigned char v2:1; empty v3; };
struct BFu9ll_BFu1i_Sf { unsigned long long v1:9; unsigned int v2:1; empty v3; };
struct BFu9ll_BFu1ll_Sf { unsigned long long v1:9; unsigned long long v2:1; empty v3; };
struct BFu9ll_BFu1s_Sf { unsigned long long v1:9; unsigned short v2:1; empty v3; };
struct BFu9ll_BFu31i_Sf { unsigned long long v1:9; unsigned int v2:31; empty v3; };
struct BFu9ll_BFu31ll_Sf { unsigned long long v1:9; unsigned long long v2:31; empty v3; };
struct BFu9ll_BFu32i_Sf { unsigned long long v1:9; unsigned int v2:32; empty v3; };
struct BFu9ll_BFu32ll_Sf { unsigned long long v1:9; unsigned long long v2:32; empty v3; };
struct BFu9ll_BFu33_Sf { unsigned long long v1:9; unsigned long long v2:33; empty v3; };
struct BFu9ll_BFu7c_Sf { unsigned long long v1:9; unsigned char v2:7; empty v3; };
struct BFu9ll_BFu7i_Sf { unsigned long long v1:9; unsigned int v2:7; empty v3; };
struct BFu9ll_BFu7ll_Sf { unsigned long long v1:9; unsigned long long v2:7; empty v3; };
struct BFu9ll_BFu7s_Sf { unsigned long long v1:9; unsigned short v2:7; empty v3; };
struct BFu9ll_BFu8c_Sf { unsigned long long v1:9; unsigned char v2:8; empty v3; };
struct BFu9ll_BFu8i_Sf { unsigned long long v1:9; unsigned int v2:8; empty v3; };
struct BFu9ll_BFu8ll_Sf { unsigned long long v1:9; unsigned long long v2:8; empty v3; };
struct BFu9ll_BFu8s_Sf { unsigned long long v1:9; unsigned short v2:8; empty v3; };
struct BFu9ll_BFu9i_Sf { unsigned long long v1:9; unsigned int v2:9; empty v3; };
struct BFu9ll_BFu9ll_Sf { unsigned long long v1:9; unsigned long long v2:9; empty v3; };
struct BFu9ll_BFu9s_Sf { unsigned long long v1:9; unsigned short v2:9; empty v3; };
struct BFu9ll_C_Sf { unsigned long long v1:9; char v2; empty v3; };
struct BFu9ll_D_Sf { unsigned long long v1:9; double v2; empty v3; };
struct BFu9ll_F_Sf { unsigned long long v1:9; float v2; empty v3; };
struct BFu9ll_I_Sf { unsigned long long v1:9; int v2; empty v3; };
struct BFu9ll_Ip_Sf { unsigned long long v1:9; int * v2; empty v3; };
struct BFu9ll_L_Sf { unsigned long long v1:9; long long v2; empty v3; };
struct BFu9ll_S_Sf { unsigned long long v1:9; short v2; empty v3; };
struct BFu9ll_Sf { unsigned long long v1:9; empty v2; };
struct BFu9ll_Sf_BFu15i { unsigned long long v1:9; empty v2; unsigned int v3:15; };
struct BFu9ll_Sf_BFu15ll { unsigned long long v1:9; empty v2; unsigned long long v3:15; };
struct BFu9ll_Sf_BFu15s { unsigned long long v1:9; empty v2; unsigned short v3:15; };
struct BFu9ll_Sf_BFu16i { unsigned long long v1:9; empty v2; unsigned int v3:16; };
struct BFu9ll_Sf_BFu16ll { unsigned long long v1:9; empty v2; unsigned long long v3:16; };
struct BFu9ll_Sf_BFu16s { unsigned long long v1:9; empty v2; unsigned short v3:16; };
struct BFu9ll_Sf_BFu17i { unsigned long long v1:9; empty v2; unsigned int v3:17; };
struct BFu9ll_Sf_BFu17ll { unsigned long long v1:9; empty v2; unsigned long long v3:17; };
struct BFu9ll_Sf_BFu1c { unsigned long long v1:9; empty v2; unsigned char v3:1; };
struct BFu9ll_Sf_BFu1i { unsigned long long v1:9; empty v2; unsigned int v3:1; };
struct BFu9ll_Sf_BFu1ll { unsigned long long v1:9; empty v2; unsigned long long v3:1; };
struct BFu9ll_Sf_BFu1s { unsigned long long v1:9; empty v2; unsigned short v3:1; };
struct BFu9ll_Sf_BFu31i { unsigned long long v1:9; empty v2; unsigned int v3:31; };
struct BFu9ll_Sf_BFu31ll { unsigned long long v1:9; empty v2; unsigned long long v3:31; };
struct BFu9ll_Sf_BFu32i { unsigned long long v1:9; empty v2; unsigned int v3:32; };
struct BFu9ll_Sf_BFu32ll { unsigned long long v1:9; empty v2; unsigned long long v3:32; };
struct BFu9ll_Sf_BFu33 { unsigned long long v1:9; empty v2; unsigned long long v3:33; };
struct BFu9ll_Sf_BFu7c { unsigned long long v1:9; empty v2; unsigned char v3:7; };
struct BFu9ll_Sf_BFu7i { unsigned long long v1:9; empty v2; unsigned int v3:7; };
struct BFu9ll_Sf_BFu7ll { unsigned long long v1:9; empty v2; unsigned long long v3:7; };
struct BFu9ll_Sf_BFu7s { unsigned long long v1:9; empty v2; unsigned short v3:7; };
struct BFu9ll_Sf_BFu8c { unsigned long long v1:9; empty v2; unsigned char v3:8; };
struct BFu9ll_Sf_BFu8i { unsigned long long v1:9; empty v2; unsigned int v3:8; };
struct BFu9ll_Sf_BFu8ll { unsigned long long v1:9; empty v2; unsigned long long v3:8; };
struct BFu9ll_Sf_BFu8s { unsigned long long v1:9; empty v2; unsigned short v3:8; };
struct BFu9ll_Sf_BFu9i { unsigned long long v1:9; empty v2; unsigned int v3:9; };
struct BFu9ll_Sf_BFu9ll { unsigned long long v1:9; empty v2; unsigned long long v3:9; };
struct BFu9ll_Sf_BFu9s { unsigned long long v1:9; empty v2; unsigned short v3:9; };
struct BFu9ll_Sf_C { unsigned long long v1:9; empty v2; char v3; };
struct BFu9ll_Sf_D { unsigned long long v1:9; empty v2; double v3; };
struct BFu9ll_Sf_F { unsigned long long v1:9; empty v2; float v3; };
struct BFu9ll_Sf_I { unsigned long long v1:9; empty v2; int v3; };
struct BFu9ll_Sf_Ip { unsigned long long v1:9; empty v2; int * v3; };
struct BFu9ll_Sf_L { unsigned long long v1:9; empty v2; long long v3; };
struct BFu9ll_Sf_S { unsigned long long v1:9; empty v2; short v3; };
struct BFu9ll_Sf_Sf { unsigned long long v1:9; empty v2; empty v3; };
struct BFu9ll_Sf_Uc { unsigned long long v1:9; empty v2; unsigned char v3; };
struct BFu9ll_Sf_Ui { unsigned long long v1:9; empty v2; unsigned int v3; };
struct BFu9ll_Sf_Ul { unsigned long long v1:9; empty v2; unsigned long long v3; };
struct BFu9ll_Sf_Us { unsigned long long v1:9; empty v2; unsigned short v3; };
struct BFu9ll_Sf_Vp { unsigned long long v1:9; empty v2; void * v3; };
struct BFu9ll_Uc_Sf { unsigned long long v1:9; unsigned char v2; empty v3; };
struct BFu9ll_Ui_Sf { unsigned long long v1:9; unsigned int v2; empty v3; };
struct BFu9ll_Ul_Sf { unsigned long long v1:9; unsigned long long v2; empty v3; };
struct BFu9ll_Us_Sf { unsigned long long v1:9; unsigned short v2; empty v3; };
struct BFu9ll_Vp_Sf { unsigned long long v1:9; void * v2; empty v3; };
struct BFu9s_BFu15i_Sf { unsigned short v1:9; unsigned int v2:15; empty v3; };
struct BFu9s_BFu15ll_Sf { unsigned short v1:9; unsigned long long v2:15; empty v3; };
struct BFu9s_BFu15s_Sf { unsigned short v1:9; unsigned short v2:15; empty v3; };
struct BFu9s_BFu16i_Sf { unsigned short v1:9; unsigned int v2:16; empty v3; };
struct BFu9s_BFu16ll_Sf { unsigned short v1:9; unsigned long long v2:16; empty v3; };
struct BFu9s_BFu16s_Sf { unsigned short v1:9; unsigned short v2:16; empty v3; };
struct BFu9s_BFu17i_Sf { unsigned short v1:9; unsigned int v2:17; empty v3; };
struct BFu9s_BFu17ll_Sf { unsigned short v1:9; unsigned long long v2:17; empty v3; };
struct BFu9s_BFu1c_Sf { unsigned short v1:9; unsigned char v2:1; empty v3; };
struct BFu9s_BFu1i_Sf { unsigned short v1:9; unsigned int v2:1; empty v3; };
struct BFu9s_BFu1ll_Sf { unsigned short v1:9; unsigned long long v2:1; empty v3; };
struct BFu9s_BFu1s_Sf { unsigned short v1:9; unsigned short v2:1; empty v3; };
struct BFu9s_BFu31i_Sf { unsigned short v1:9; unsigned int v2:31; empty v3; };
struct BFu9s_BFu31ll_Sf { unsigned short v1:9; unsigned long long v2:31; empty v3; };
struct BFu9s_BFu32i_Sf { unsigned short v1:9; unsigned int v2:32; empty v3; };
struct BFu9s_BFu32ll_Sf { unsigned short v1:9; unsigned long long v2:32; empty v3; };
struct BFu9s_BFu33_Sf { unsigned short v1:9; unsigned long long v2:33; empty v3; };
struct BFu9s_BFu7c_Sf { unsigned short v1:9; unsigned char v2:7; empty v3; };
struct BFu9s_BFu7i_Sf { unsigned short v1:9; unsigned int v2:7; empty v3; };
struct BFu9s_BFu7ll_Sf { unsigned short v1:9; unsigned long long v2:7; empty v3; };
struct BFu9s_BFu7s_Sf { unsigned short v1:9; unsigned short v2:7; empty v3; };
struct BFu9s_BFu8c_Sf { unsigned short v1:9; unsigned char v2:8; empty v3; };
struct BFu9s_BFu8i_Sf { unsigned short v1:9; unsigned int v2:8; empty v3; };
struct BFu9s_BFu8ll_Sf { unsigned short v1:9; unsigned long long v2:8; empty v3; };
struct BFu9s_BFu8s_Sf { unsigned short v1:9; unsigned short v2:8; empty v3; };
struct BFu9s_BFu9i_Sf { unsigned short v1:9; unsigned int v2:9; empty v3; };
struct BFu9s_BFu9ll_Sf { unsigned short v1:9; unsigned long long v2:9; empty v3; };
struct BFu9s_BFu9s_Sf { unsigned short v1:9; unsigned short v2:9; empty v3; };
struct BFu9s_C_Sf { unsigned short v1:9; char v2; empty v3; };
struct BFu9s_D_Sf { unsigned short v1:9; double v2; empty v3; };
struct BFu9s_F_Sf { unsigned short v1:9; float v2; empty v3; };
struct BFu9s_I_Sf { unsigned short v1:9; int v2; empty v3; };
struct BFu9s_Ip_Sf { unsigned short v1:9; int * v2; empty v3; };
struct BFu9s_L_Sf { unsigned short v1:9; long long v2; empty v3; };
struct BFu9s_S_Sf { unsigned short v1:9; short v2; empty v3; };
struct BFu9s_Sf { unsigned short v1:9; empty v2; };
struct BFu9s_Sf_BFu15i { unsigned short v1:9; empty v2; unsigned int v3:15; };
struct BFu9s_Sf_BFu15ll { unsigned short v1:9; empty v2; unsigned long long v3:15; };
struct BFu9s_Sf_BFu15s { unsigned short v1:9; empty v2; unsigned short v3:15; };
struct BFu9s_Sf_BFu16i { unsigned short v1:9; empty v2; unsigned int v3:16; };
struct BFu9s_Sf_BFu16ll { unsigned short v1:9; empty v2; unsigned long long v3:16; };
struct BFu9s_Sf_BFu16s { unsigned short v1:9; empty v2; unsigned short v3:16; };
struct BFu9s_Sf_BFu17i { unsigned short v1:9; empty v2; unsigned int v3:17; };
struct BFu9s_Sf_BFu17ll { unsigned short v1:9; empty v2; unsigned long long v3:17; };
struct BFu9s_Sf_BFu1c { unsigned short v1:9; empty v2; unsigned char v3:1; };
struct BFu9s_Sf_BFu1i { unsigned short v1:9; empty v2; unsigned int v3:1; };
struct BFu9s_Sf_BFu1ll { unsigned short v1:9; empty v2; unsigned long long v3:1; };
struct BFu9s_Sf_BFu1s { unsigned short v1:9; empty v2; unsigned short v3:1; };
struct BFu9s_Sf_BFu31i { unsigned short v1:9; empty v2; unsigned int v3:31; };
struct BFu9s_Sf_BFu31ll { unsigned short v1:9; empty v2; unsigned long long v3:31; };
struct BFu9s_Sf_BFu32i { unsigned short v1:9; empty v2; unsigned int v3:32; };
struct BFu9s_Sf_BFu32ll { unsigned short v1:9; empty v2; unsigned long long v3:32; };
struct BFu9s_Sf_BFu33 { unsigned short v1:9; empty v2; unsigned long long v3:33; };
struct BFu9s_Sf_BFu7c { unsigned short v1:9; empty v2; unsigned char v3:7; };
struct BFu9s_Sf_BFu7i { unsigned short v1:9; empty v2; unsigned int v3:7; };
struct BFu9s_Sf_BFu7ll { unsigned short v1:9; empty v2; unsigned long long v3:7; };
struct BFu9s_Sf_BFu7s { unsigned short v1:9; empty v2; unsigned short v3:7; };
struct BFu9s_Sf_BFu8c { unsigned short v1:9; empty v2; unsigned char v3:8; };
struct BFu9s_Sf_BFu8i { unsigned short v1:9; empty v2; unsigned int v3:8; };
struct BFu9s_Sf_BFu8ll { unsigned short v1:9; empty v2; unsigned long long v3:8; };
struct BFu9s_Sf_BFu8s { unsigned short v1:9; empty v2; unsigned short v3:8; };
struct BFu9s_Sf_BFu9i { unsigned short v1:9; empty v2; unsigned int v3:9; };
struct BFu9s_Sf_BFu9ll { unsigned short v1:9; empty v2; unsigned long long v3:9; };
struct BFu9s_Sf_BFu9s { unsigned short v1:9; empty v2; unsigned short v3:9; };
struct BFu9s_Sf_C { unsigned short v1:9; empty v2; char v3; };
struct BFu9s_Sf_D { unsigned short v1:9; empty v2; double v3; };
struct BFu9s_Sf_F { unsigned short v1:9; empty v2; float v3; };
struct BFu9s_Sf_I { unsigned short v1:9; empty v2; int v3; };
struct BFu9s_Sf_Ip { unsigned short v1:9; empty v2; int * v3; };
struct BFu9s_Sf_L { unsigned short v1:9; empty v2; long long v3; };
struct BFu9s_Sf_S { unsigned short v1:9; empty v2; short v3; };
struct BFu9s_Sf_Sf { unsigned short v1:9; empty v2; empty v3; };
struct BFu9s_Sf_Uc { unsigned short v1:9; empty v2; unsigned char v3; };
struct BFu9s_Sf_Ui { unsigned short v1:9; empty v2; unsigned int v3; };
struct BFu9s_Sf_Ul { unsigned short v1:9; empty v2; unsigned long long v3; };
struct BFu9s_Sf_Us { unsigned short v1:9; empty v2; unsigned short v3; };
struct BFu9s_Sf_Vp { unsigned short v1:9; empty v2; void * v3; };
struct BFu9s_Uc_Sf { unsigned short v1:9; unsigned char v2; empty v3; };
struct BFu9s_Ui_Sf { unsigned short v1:9; unsigned int v2; empty v3; };
struct BFu9s_Ul_Sf { unsigned short v1:9; unsigned long long v2; empty v3; };
struct BFu9s_Us_Sf { unsigned short v1:9; unsigned short v2; empty v3; };
struct BFu9s_Vp_Sf { unsigned short v1:9; void * v2; empty v3; };
struct C_BFu15i_Sf { char v1; unsigned int v2:15; empty v3; };
struct C_BFu15ll_Sf { char v1; unsigned long long v2:15; empty v3; };
struct C_BFu15s_Sf { char v1; unsigned short v2:15; empty v3; };
struct C_BFu16i_Sf { char v1; unsigned int v2:16; empty v3; };
struct C_BFu16ll_Sf { char v1; unsigned long long v2:16; empty v3; };
struct C_BFu16s_Sf { char v1; unsigned short v2:16; empty v3; };
struct C_BFu17i_Sf { char v1; unsigned int v2:17; empty v3; };
struct C_BFu17ll_Sf { char v1; unsigned long long v2:17; empty v3; };
struct C_BFu1c_Sf { char v1; unsigned char v2:1; empty v3; };
struct C_BFu1i_Sf { char v1; unsigned int v2:1; empty v3; };
struct C_BFu1ll_Sf { char v1; unsigned long long v2:1; empty v3; };
struct C_BFu1s_Sf { char v1; unsigned short v2:1; empty v3; };
struct C_BFu31i_Sf { char v1; unsigned int v2:31; empty v3; };
struct C_BFu31ll_Sf { char v1; unsigned long long v2:31; empty v3; };
struct C_BFu32i_Sf { char v1; unsigned int v2:32; empty v3; };
struct C_BFu32ll_Sf { char v1; unsigned long long v2:32; empty v3; };
struct C_BFu33_Sf { char v1; unsigned long long v2:33; empty v3; };
struct C_BFu7c_Sf { char v1; unsigned char v2:7; empty v3; };
struct C_BFu7i_Sf { char v1; unsigned int v2:7; empty v3; };
struct C_BFu7ll_Sf { char v1; unsigned long long v2:7; empty v3; };
struct C_BFu7s_Sf { char v1; unsigned short v2:7; empty v3; };
struct C_BFu8c_Sf { char v1; unsigned char v2:8; empty v3; };
struct C_BFu8i_Sf { char v1; unsigned int v2:8; empty v3; };
struct C_BFu8ll_Sf { char v1; unsigned long long v2:8; empty v3; };
struct C_BFu8s_Sf { char v1; unsigned short v2:8; empty v3; };
struct C_BFu9i_Sf { char v1; unsigned int v2:9; empty v3; };
struct C_BFu9ll_Sf { char v1; unsigned long long v2:9; empty v3; };
struct C_BFu9s_Sf { char v1; unsigned short v2:9; empty v3; };
struct C_C_Sf { char v1; char v2; empty v3; };
struct C_D_Sf { char v1; double v2; empty v3; };
struct C_F_Sf { char v1; float v2; empty v3; };
struct C_I_Sf { char v1; int v2; empty v3; };
struct C_Ip_Sf { char v1; int * v2; empty v3; };
struct C_L_Sf { char v1; long long v2; empty v3; };
struct C_S_Sf { char v1; short v2; empty v3; };
struct C_Sf { char v1; empty v2; };
struct C_Sf_BFu15i { char v1; empty v2; unsigned int v3:15; };
struct C_Sf_BFu15ll { char v1; empty v2; unsigned long long v3:15; };
struct C_Sf_BFu15s { char v1; empty v2; unsigned short v3:15; };
struct C_Sf_BFu16i { char v1; empty v2; unsigned int v3:16; };
struct C_Sf_BFu16ll { char v1; empty v2; unsigned long long v3:16; };
struct C_Sf_BFu16s { char v1; empty v2; unsigned short v3:16; };
struct C_Sf_BFu17i { char v1; empty v2; unsigned int v3:17; };
struct C_Sf_BFu17ll { char v1; empty v2; unsigned long long v3:17; };
struct C_Sf_BFu1c { char v1; empty v2; unsigned char v3:1; };
struct C_Sf_BFu1i { char v1; empty v2; unsigned int v3:1; };
struct C_Sf_BFu1ll { char v1; empty v2; unsigned long long v3:1; };
struct C_Sf_BFu1s { char v1; empty v2; unsigned short v3:1; };
struct C_Sf_BFu31i { char v1; empty v2; unsigned int v3:31; };
struct C_Sf_BFu31ll { char v1; empty v2; unsigned long long v3:31; };
struct C_Sf_BFu32i { char v1; empty v2; unsigned int v3:32; };
struct C_Sf_BFu32ll { char v1; empty v2; unsigned long long v3:32; };
struct C_Sf_BFu33 { char v1; empty v2; unsigned long long v3:33; };
struct C_Sf_BFu7c { char v1; empty v2; unsigned char v3:7; };
struct C_Sf_BFu7i { char v1; empty v2; unsigned int v3:7; };
struct C_Sf_BFu7ll { char v1; empty v2; unsigned long long v3:7; };
struct C_Sf_BFu7s { char v1; empty v2; unsigned short v3:7; };
struct C_Sf_BFu8c { char v1; empty v2; unsigned char v3:8; };
struct C_Sf_BFu8i { char v1; empty v2; unsigned int v3:8; };
struct C_Sf_BFu8ll { char v1; empty v2; unsigned long long v3:8; };
struct C_Sf_BFu8s { char v1; empty v2; unsigned short v3:8; };
struct C_Sf_BFu9i { char v1; empty v2; unsigned int v3:9; };
struct C_Sf_BFu9ll { char v1; empty v2; unsigned long long v3:9; };
struct C_Sf_BFu9s { char v1; empty v2; unsigned short v3:9; };
struct C_Sf_C { char v1; empty v2; char v3; };
struct C_Sf_D { char v1; empty v2; double v3; };
struct C_Sf_F { char v1; empty v2; float v3; };
struct C_Sf_I { char v1; empty v2; int v3; };
struct C_Sf_Ip { char v1; empty v2; int * v3; };
struct C_Sf_L { char v1; empty v2; long long v3; };
struct C_Sf_S { char v1; empty v2; short v3; };
struct C_Sf_Sf { char v1; empty v2; empty v3; };
struct C_Sf_Uc { char v1; empty v2; unsigned char v3; };
struct C_Sf_Ui { char v1; empty v2; unsigned int v3; };
struct C_Sf_Ul { char v1; empty v2; unsigned long long v3; };
struct C_Sf_Us { char v1; empty v2; unsigned short v3; };
struct C_Sf_Vp { char v1; empty v2; void * v3; };
struct C_Uc_Sf { char v1; unsigned char v2; empty v3; };
struct C_Ui_Sf { char v1; unsigned int v2; empty v3; };
struct C_Ul_Sf { char v1; unsigned long long v2; empty v3; };
struct C_Us_Sf { char v1; unsigned short v2; empty v3; };
struct C_Vp_Sf { char v1; void * v2; empty v3; };
struct D_BFu15i_Sf { double v1; unsigned int v2:15; empty v3; };
struct D_BFu15ll_Sf { double v1; unsigned long long v2:15; empty v3; };
struct D_BFu15s_Sf { double v1; unsigned short v2:15; empty v3; };
struct D_BFu16i_Sf { double v1; unsigned int v2:16; empty v3; };
struct D_BFu16ll_Sf { double v1; unsigned long long v2:16; empty v3; };
struct D_BFu16s_Sf { double v1; unsigned short v2:16; empty v3; };
struct D_BFu17i_Sf { double v1; unsigned int v2:17; empty v3; };
struct D_BFu17ll_Sf { double v1; unsigned long long v2:17; empty v3; };
struct D_BFu1c_Sf { double v1; unsigned char v2:1; empty v3; };
struct D_BFu1i_Sf { double v1; unsigned int v2:1; empty v3; };
struct D_BFu1ll_Sf { double v1; unsigned long long v2:1; empty v3; };
struct D_BFu1s_Sf { double v1; unsigned short v2:1; empty v3; };
struct D_BFu31i_Sf { double v1; unsigned int v2:31; empty v3; };
struct D_BFu31ll_Sf { double v1; unsigned long long v2:31; empty v3; };
struct D_BFu32i_Sf { double v1; unsigned int v2:32; empty v3; };
struct D_BFu32ll_Sf { double v1; unsigned long long v2:32; empty v3; };
struct D_BFu33_Sf { double v1; unsigned long long v2:33; empty v3; };
struct D_BFu7c_Sf { double v1; unsigned char v2:7; empty v3; };
struct D_BFu7i_Sf { double v1; unsigned int v2:7; empty v3; };
struct D_BFu7ll_Sf { double v1; unsigned long long v2:7; empty v3; };
struct D_BFu7s_Sf { double v1; unsigned short v2:7; empty v3; };
struct D_BFu8c_Sf { double v1; unsigned char v2:8; empty v3; };
struct D_BFu8i_Sf { double v1; unsigned int v2:8; empty v3; };
struct D_BFu8ll_Sf { double v1; unsigned long long v2:8; empty v3; };
struct D_BFu8s_Sf { double v1; unsigned short v2:8; empty v3; };
struct D_BFu9i_Sf { double v1; unsigned int v2:9; empty v3; };
struct D_BFu9ll_Sf { double v1; unsigned long long v2:9; empty v3; };
struct D_BFu9s_Sf { double v1; unsigned short v2:9; empty v3; };
struct D_C_Sf { double v1; char v2; empty v3; };
struct D_D_Sf { double v1; double v2; empty v3; };
struct D_F_Sf { double v1; float v2; empty v3; };
struct D_I_Sf { double v1; int v2; empty v3; };
struct D_Ip_Sf { double v1; int * v2; empty v3; };
struct D_L_Sf { double v1; long long v2; empty v3; };
struct D_S_Sf { double v1; short v2; empty v3; };
struct D_Sf { double v1; empty v2; };
struct D_Sf_BFu15i { double v1; empty v2; unsigned int v3:15; };
struct D_Sf_BFu15ll { double v1; empty v2; unsigned long long v3:15; };
struct D_Sf_BFu15s { double v1; empty v2; unsigned short v3:15; };
struct D_Sf_BFu16i { double v1; empty v2; unsigned int v3:16; };
struct D_Sf_BFu16ll { double v1; empty v2; unsigned long long v3:16; };
struct D_Sf_BFu16s { double v1; empty v2; unsigned short v3:16; };
struct D_Sf_BFu17i { double v1; empty v2; unsigned int v3:17; };
struct D_Sf_BFu17ll { double v1; empty v2; unsigned long long v3:17; };
struct D_Sf_BFu1c { double v1; empty v2; unsigned char v3:1; };
struct D_Sf_BFu1i { double v1; empty v2; unsigned int v3:1; };
struct D_Sf_BFu1ll { double v1; empty v2; unsigned long long v3:1; };
struct D_Sf_BFu1s { double v1; empty v2; unsigned short v3:1; };
struct D_Sf_BFu31i { double v1; empty v2; unsigned int v3:31; };
struct D_Sf_BFu31ll { double v1; empty v2; unsigned long long v3:31; };
struct D_Sf_BFu32i { double v1; empty v2; unsigned int v3:32; };
struct D_Sf_BFu32ll { double v1; empty v2; unsigned long long v3:32; };
struct D_Sf_BFu33 { double v1; empty v2; unsigned long long v3:33; };
struct D_Sf_BFu7c { double v1; empty v2; unsigned char v3:7; };
struct D_Sf_BFu7i { double v1; empty v2; unsigned int v3:7; };
struct D_Sf_BFu7ll { double v1; empty v2; unsigned long long v3:7; };
struct D_Sf_BFu7s { double v1; empty v2; unsigned short v3:7; };
struct D_Sf_BFu8c { double v1; empty v2; unsigned char v3:8; };
struct D_Sf_BFu8i { double v1; empty v2; unsigned int v3:8; };
struct D_Sf_BFu8ll { double v1; empty v2; unsigned long long v3:8; };
struct D_Sf_BFu8s { double v1; empty v2; unsigned short v3:8; };
struct D_Sf_BFu9i { double v1; empty v2; unsigned int v3:9; };
struct D_Sf_BFu9ll { double v1; empty v2; unsigned long long v3:9; };
struct D_Sf_BFu9s { double v1; empty v2; unsigned short v3:9; };
struct D_Sf_C { double v1; empty v2; char v3; };
struct D_Sf_D { double v1; empty v2; double v3; };
struct D_Sf_F { double v1; empty v2; float v3; };
struct D_Sf_I { double v1; empty v2; int v3; };
struct D_Sf_Ip { double v1; empty v2; int * v3; };
struct D_Sf_L { double v1; empty v2; long long v3; };
struct D_Sf_S { double v1; empty v2; short v3; };
struct D_Sf_Sf { double v1; empty v2; empty v3; };
struct D_Sf_Uc { double v1; empty v2; unsigned char v3; };
struct D_Sf_Ui { double v1; empty v2; unsigned int v3; };
struct D_Sf_Ul { double v1; empty v2; unsigned long long v3; };
struct D_Sf_Us { double v1; empty v2; unsigned short v3; };
struct D_Sf_Vp { double v1; empty v2; void * v3; };
struct D_Uc_Sf { double v1; unsigned char v2; empty v3; };
struct D_Ui_Sf { double v1; unsigned int v2; empty v3; };
struct D_Ul_Sf { double v1; unsigned long long v2; empty v3; };
struct D_Us_Sf { double v1; unsigned short v2; empty v3; };
struct D_Vp_Sf { double v1; void * v2; empty v3; };
struct F_BFu15i_Sf { float v1; unsigned int v2:15; empty v3; };
struct F_BFu15ll_Sf { float v1; unsigned long long v2:15; empty v3; };
struct F_BFu15s_Sf { float v1; unsigned short v2:15; empty v3; };
struct F_BFu16i_Sf { float v1; unsigned int v2:16; empty v3; };
struct F_BFu16ll_Sf { float v1; unsigned long long v2:16; empty v3; };
struct F_BFu16s_Sf { float v1; unsigned short v2:16; empty v3; };
struct F_BFu17i_Sf { float v1; unsigned int v2:17; empty v3; };
struct F_BFu17ll_Sf { float v1; unsigned long long v2:17; empty v3; };
struct F_BFu1c_Sf { float v1; unsigned char v2:1; empty v3; };
struct F_BFu1i_Sf { float v1; unsigned int v2:1; empty v3; };
struct F_BFu1ll_Sf { float v1; unsigned long long v2:1; empty v3; };
struct F_BFu1s_Sf { float v1; unsigned short v2:1; empty v3; };
struct F_BFu31i_Sf { float v1; unsigned int v2:31; empty v3; };
struct F_BFu31ll_Sf { float v1; unsigned long long v2:31; empty v3; };
struct F_BFu32i_Sf { float v1; unsigned int v2:32; empty v3; };
struct F_BFu32ll_Sf { float v1; unsigned long long v2:32; empty v3; };
struct F_BFu33_Sf { float v1; unsigned long long v2:33; empty v3; };
struct F_BFu7c_Sf { float v1; unsigned char v2:7; empty v3; };
struct F_BFu7i_Sf { float v1; unsigned int v2:7; empty v3; };
struct F_BFu7ll_Sf { float v1; unsigned long long v2:7; empty v3; };
struct F_BFu7s_Sf { float v1; unsigned short v2:7; empty v3; };
struct F_BFu8c_Sf { float v1; unsigned char v2:8; empty v3; };
struct F_BFu8i_Sf { float v1; unsigned int v2:8; empty v3; };
struct F_BFu8ll_Sf { float v1; unsigned long long v2:8; empty v3; };
struct F_BFu8s_Sf { float v1; unsigned short v2:8; empty v3; };
struct F_BFu9i_Sf { float v1; unsigned int v2:9; empty v3; };
struct F_BFu9ll_Sf { float v1; unsigned long long v2:9; empty v3; };
struct F_BFu9s_Sf { float v1; unsigned short v2:9; empty v3; };
struct F_C_Sf { float v1; char v2; empty v3; };
struct F_D_Sf { float v1; double v2; empty v3; };
struct F_F_Sf { float v1; float v2; empty v3; };
struct F_I_Sf { float v1; int v2; empty v3; };
struct F_Ip_Sf { float v1; int * v2; empty v3; };
struct F_L_Sf { float v1; long long v2; empty v3; };
struct F_S_Sf { float v1; short v2; empty v3; };
struct F_Sf { float v1; empty v2; };
struct F_Sf_BFu15i { float v1; empty v2; unsigned int v3:15; };
struct F_Sf_BFu15ll { float v1; empty v2; unsigned long long v3:15; };
struct F_Sf_BFu15s { float v1; empty v2; unsigned short v3:15; };
struct F_Sf_BFu16i { float v1; empty v2; unsigned int v3:16; };
struct F_Sf_BFu16ll { float v1; empty v2; unsigned long long v3:16; };
struct F_Sf_BFu16s { float v1; empty v2; unsigned short v3:16; };
struct F_Sf_BFu17i { float v1; empty v2; unsigned int v3:17; };
struct F_Sf_BFu17ll { float v1; empty v2; unsigned long long v3:17; };
struct F_Sf_BFu1c { float v1; empty v2; unsigned char v3:1; };
struct F_Sf_BFu1i { float v1; empty v2; unsigned int v3:1; };
struct F_Sf_BFu1ll { float v1; empty v2; unsigned long long v3:1; };
struct F_Sf_BFu1s { float v1; empty v2; unsigned short v3:1; };
struct F_Sf_BFu31i { float v1; empty v2; unsigned int v3:31; };
struct F_Sf_BFu31ll { float v1; empty v2; unsigned long long v3:31; };
struct F_Sf_BFu32i { float v1; empty v2; unsigned int v3:32; };
struct F_Sf_BFu32ll { float v1; empty v2; unsigned long long v3:32; };
struct F_Sf_BFu33 { float v1; empty v2; unsigned long long v3:33; };
struct F_Sf_BFu7c { float v1; empty v2; unsigned char v3:7; };
struct F_Sf_BFu7i { float v1; empty v2; unsigned int v3:7; };
struct F_Sf_BFu7ll { float v1; empty v2; unsigned long long v3:7; };
struct F_Sf_BFu7s { float v1; empty v2; unsigned short v3:7; };
struct F_Sf_BFu8c { float v1; empty v2; unsigned char v3:8; };
struct F_Sf_BFu8i { float v1; empty v2; unsigned int v3:8; };
struct F_Sf_BFu8ll { float v1; empty v2; unsigned long long v3:8; };
struct F_Sf_BFu8s { float v1; empty v2; unsigned short v3:8; };
struct F_Sf_BFu9i { float v1; empty v2; unsigned int v3:9; };
struct F_Sf_BFu9ll { float v1; empty v2; unsigned long long v3:9; };
struct F_Sf_BFu9s { float v1; empty v2; unsigned short v3:9; };
struct F_Sf_C { float v1; empty v2; char v3; };
struct F_Sf_D { float v1; empty v2; double v3; };
struct F_Sf_F { float v1; empty v2; float v3; };
struct F_Sf_I { float v1; empty v2; int v3; };
struct F_Sf_Ip { float v1; empty v2; int * v3; };
struct F_Sf_L { float v1; empty v2; long long v3; };
struct F_Sf_S { float v1; empty v2; short v3; };
struct F_Sf_Sf { float v1; empty v2; empty v3; };
struct F_Sf_Uc { float v1; empty v2; unsigned char v3; };
struct F_Sf_Ui { float v1; empty v2; unsigned int v3; };
struct F_Sf_Ul { float v1; empty v2; unsigned long long v3; };
struct F_Sf_Us { float v1; empty v2; unsigned short v3; };
struct F_Sf_Vp { float v1; empty v2; void * v3; };
struct F_Uc_Sf { float v1; unsigned char v2; empty v3; };
struct F_Ui_Sf { float v1; unsigned int v2; empty v3; };
struct F_Ul_Sf { float v1; unsigned long long v2; empty v3; };
struct F_Us_Sf { float v1; unsigned short v2; empty v3; };
struct F_Vp_Sf { float v1; void * v2; empty v3; };
struct I_BFu15i_Sf { int v1; unsigned int v2:15; empty v3; };
struct I_BFu15ll_Sf { int v1; unsigned long long v2:15; empty v3; };
struct I_BFu15s_Sf { int v1; unsigned short v2:15; empty v3; };
struct I_BFu16i_Sf { int v1; unsigned int v2:16; empty v3; };
struct I_BFu16ll_Sf { int v1; unsigned long long v2:16; empty v3; };
struct I_BFu16s_Sf { int v1; unsigned short v2:16; empty v3; };
struct I_BFu17i_Sf { int v1; unsigned int v2:17; empty v3; };
struct I_BFu17ll_Sf { int v1; unsigned long long v2:17; empty v3; };
struct I_BFu1c_Sf { int v1; unsigned char v2:1; empty v3; };
struct I_BFu1i_Sf { int v1; unsigned int v2:1; empty v3; };
struct I_BFu1ll_Sf { int v1; unsigned long long v2:1; empty v3; };
struct I_BFu1s_Sf { int v1; unsigned short v2:1; empty v3; };
struct I_BFu31i_Sf { int v1; unsigned int v2:31; empty v3; };
struct I_BFu31ll_Sf { int v1; unsigned long long v2:31; empty v3; };
struct I_BFu32i_Sf { int v1; unsigned int v2:32; empty v3; };
struct I_BFu32ll_Sf { int v1; unsigned long long v2:32; empty v3; };
struct I_BFu33_Sf { int v1; unsigned long long v2:33; empty v3; };
struct I_BFu7c_Sf { int v1; unsigned char v2:7; empty v3; };
struct I_BFu7i_Sf { int v1; unsigned int v2:7; empty v3; };
struct I_BFu7ll_Sf { int v1; unsigned long long v2:7; empty v3; };
struct I_BFu7s_Sf { int v1; unsigned short v2:7; empty v3; };
struct I_BFu8c_Sf { int v1; unsigned char v2:8; empty v3; };
struct I_BFu8i_Sf { int v1; unsigned int v2:8; empty v3; };
struct I_BFu8ll_Sf { int v1; unsigned long long v2:8; empty v3; };
struct I_BFu8s_Sf { int v1; unsigned short v2:8; empty v3; };
struct I_BFu9i_Sf { int v1; unsigned int v2:9; empty v3; };
struct I_BFu9ll_Sf { int v1; unsigned long long v2:9; empty v3; };
struct I_BFu9s_Sf { int v1; unsigned short v2:9; empty v3; };
struct I_C_Sf { int v1; char v2; empty v3; };
struct I_D_Sf { int v1; double v2; empty v3; };
struct I_F_Sf { int v1; float v2; empty v3; };
struct I_I_Sf { int v1; int v2; empty v3; };
struct I_Ip_Sf { int v1; int * v2; empty v3; };
struct I_L_Sf { int v1; long long v2; empty v3; };
struct I_S_Sf { int v1; short v2; empty v3; };
struct I_Sf { int v1; empty v2; };
struct I_Sf_BFu15i { int v1; empty v2; unsigned int v3:15; };
struct I_Sf_BFu15ll { int v1; empty v2; unsigned long long v3:15; };
struct I_Sf_BFu15s { int v1; empty v2; unsigned short v3:15; };
struct I_Sf_BFu16i { int v1; empty v2; unsigned int v3:16; };
struct I_Sf_BFu16ll { int v1; empty v2; unsigned long long v3:16; };
struct I_Sf_BFu16s { int v1; empty v2; unsigned short v3:16; };
struct I_Sf_BFu17i { int v1; empty v2; unsigned int v3:17; };
struct I_Sf_BFu17ll { int v1; empty v2; unsigned long long v3:17; };
struct I_Sf_BFu1c { int v1; empty v2; unsigned char v3:1; };
struct I_Sf_BFu1i { int v1; empty v2; unsigned int v3:1; };
struct I_Sf_BFu1ll { int v1; empty v2; unsigned long long v3:1; };
struct I_Sf_BFu1s { int v1; empty v2; unsigned short v3:1; };
struct I_Sf_BFu31i { int v1; empty v2; unsigned int v3:31; };
struct I_Sf_BFu31ll { int v1; empty v2; unsigned long long v3:31; };
struct I_Sf_BFu32i { int v1; empty v2; unsigned int v3:32; };
struct I_Sf_BFu32ll { int v1; empty v2; unsigned long long v3:32; };
struct I_Sf_BFu33 { int v1; empty v2; unsigned long long v3:33; };
struct I_Sf_BFu7c { int v1; empty v2; unsigned char v3:7; };
struct I_Sf_BFu7i { int v1; empty v2; unsigned int v3:7; };
struct I_Sf_BFu7ll { int v1; empty v2; unsigned long long v3:7; };
struct I_Sf_BFu7s { int v1; empty v2; unsigned short v3:7; };
struct I_Sf_BFu8c { int v1; empty v2; unsigned char v3:8; };
struct I_Sf_BFu8i { int v1; empty v2; unsigned int v3:8; };
struct I_Sf_BFu8ll { int v1; empty v2; unsigned long long v3:8; };
struct I_Sf_BFu8s { int v1; empty v2; unsigned short v3:8; };
struct I_Sf_BFu9i { int v1; empty v2; unsigned int v3:9; };
struct I_Sf_BFu9ll { int v1; empty v2; unsigned long long v3:9; };
struct I_Sf_BFu9s { int v1; empty v2; unsigned short v3:9; };
struct I_Sf_C { int v1; empty v2; char v3; };
struct I_Sf_D { int v1; empty v2; double v3; };
struct I_Sf_F { int v1; empty v2; float v3; };
struct I_Sf_I { int v1; empty v2; int v3; };
struct I_Sf_Ip { int v1; empty v2; int * v3; };
struct I_Sf_L { int v1; empty v2; long long v3; };
struct I_Sf_S { int v1; empty v2; short v3; };
struct I_Sf_Sf { int v1; empty v2; empty v3; };
struct I_Sf_Uc { int v1; empty v2; unsigned char v3; };
struct I_Sf_Ui { int v1; empty v2; unsigned int v3; };
struct I_Sf_Ul { int v1; empty v2; unsigned long long v3; };
struct I_Sf_Us { int v1; empty v2; unsigned short v3; };
struct I_Sf_Vp { int v1; empty v2; void * v3; };
struct I_Uc_Sf { int v1; unsigned char v2; empty v3; };
struct I_Ui_Sf { int v1; unsigned int v2; empty v3; };
struct I_Ul_Sf { int v1; unsigned long long v2; empty v3; };
struct I_Us_Sf { int v1; unsigned short v2; empty v3; };
struct I_Vp_Sf { int v1; void * v2; empty v3; };
struct Ip_BFu15i_Sf { int * v1; unsigned int v2:15; empty v3; };
struct Ip_BFu15ll_Sf { int * v1; unsigned long long v2:15; empty v3; };
struct Ip_BFu15s_Sf { int * v1; unsigned short v2:15; empty v3; };
struct Ip_BFu16i_Sf { int * v1; unsigned int v2:16; empty v3; };
struct Ip_BFu16ll_Sf { int * v1; unsigned long long v2:16; empty v3; };
struct Ip_BFu16s_Sf { int * v1; unsigned short v2:16; empty v3; };
struct Ip_BFu17i_Sf { int * v1; unsigned int v2:17; empty v3; };
struct Ip_BFu17ll_Sf { int * v1; unsigned long long v2:17; empty v3; };
struct Ip_BFu1c_Sf { int * v1; unsigned char v2:1; empty v3; };
struct Ip_BFu1i_Sf { int * v1; unsigned int v2:1; empty v3; };
struct Ip_BFu1ll_Sf { int * v1; unsigned long long v2:1; empty v3; };
struct Ip_BFu1s_Sf { int * v1; unsigned short v2:1; empty v3; };
struct Ip_BFu31i_Sf { int * v1; unsigned int v2:31; empty v3; };
struct Ip_BFu31ll_Sf { int * v1; unsigned long long v2:31; empty v3; };
struct Ip_BFu32i_Sf { int * v1; unsigned int v2:32; empty v3; };
struct Ip_BFu32ll_Sf { int * v1; unsigned long long v2:32; empty v3; };
struct Ip_BFu33_Sf { int * v1; unsigned long long v2:33; empty v3; };
struct Ip_BFu7c_Sf { int * v1; unsigned char v2:7; empty v3; };
struct Ip_BFu7i_Sf { int * v1; unsigned int v2:7; empty v3; };
struct Ip_BFu7ll_Sf { int * v1; unsigned long long v2:7; empty v3; };
struct Ip_BFu7s_Sf { int * v1; unsigned short v2:7; empty v3; };
struct Ip_BFu8c_Sf { int * v1; unsigned char v2:8; empty v3; };
struct Ip_BFu8i_Sf { int * v1; unsigned int v2:8; empty v3; };
struct Ip_BFu8ll_Sf { int * v1; unsigned long long v2:8; empty v3; };
struct Ip_BFu8s_Sf { int * v1; unsigned short v2:8; empty v3; };
struct Ip_BFu9i_Sf { int * v1; unsigned int v2:9; empty v3; };
struct Ip_BFu9ll_Sf { int * v1; unsigned long long v2:9; empty v3; };
struct Ip_BFu9s_Sf { int * v1; unsigned short v2:9; empty v3; };
struct Ip_C_Sf { int * v1; char v2; empty v3; };
struct Ip_D_Sf { int * v1; double v2; empty v3; };
struct Ip_F_Sf { int * v1; float v2; empty v3; };
struct Ip_I_Sf { int * v1; int v2; empty v3; };
struct Ip_Ip_Sf { int * v1; int * v2; empty v3; };
struct Ip_L_Sf { int * v1; long long v2; empty v3; };
struct Ip_S_Sf { int * v1; short v2; empty v3; };
struct Ip_Sf { int * v1; empty v2; };
struct Ip_Sf_BFu15i { int * v1; empty v2; unsigned int v3:15; };
struct Ip_Sf_BFu15ll { int * v1; empty v2; unsigned long long v3:15; };
struct Ip_Sf_BFu15s { int * v1; empty v2; unsigned short v3:15; };
struct Ip_Sf_BFu16i { int * v1; empty v2; unsigned int v3:16; };
struct Ip_Sf_BFu16ll { int * v1; empty v2; unsigned long long v3:16; };
struct Ip_Sf_BFu16s { int * v1; empty v2; unsigned short v3:16; };
struct Ip_Sf_BFu17i { int * v1; empty v2; unsigned int v3:17; };
struct Ip_Sf_BFu17ll { int * v1; empty v2; unsigned long long v3:17; };
struct Ip_Sf_BFu1c { int * v1; empty v2; unsigned char v3:1; };
struct Ip_Sf_BFu1i { int * v1; empty v2; unsigned int v3:1; };
struct Ip_Sf_BFu1ll { int * v1; empty v2; unsigned long long v3:1; };
struct Ip_Sf_BFu1s { int * v1; empty v2; unsigned short v3:1; };
struct Ip_Sf_BFu31i { int * v1; empty v2; unsigned int v3:31; };
struct Ip_Sf_BFu31ll { int * v1; empty v2; unsigned long long v3:31; };
struct Ip_Sf_BFu32i { int * v1; empty v2; unsigned int v3:32; };
struct Ip_Sf_BFu32ll { int * v1; empty v2; unsigned long long v3:32; };
struct Ip_Sf_BFu33 { int * v1; empty v2; unsigned long long v3:33; };
struct Ip_Sf_BFu7c { int * v1; empty v2; unsigned char v3:7; };
struct Ip_Sf_BFu7i { int * v1; empty v2; unsigned int v3:7; };
struct Ip_Sf_BFu7ll { int * v1; empty v2; unsigned long long v3:7; };
struct Ip_Sf_BFu7s { int * v1; empty v2; unsigned short v3:7; };
struct Ip_Sf_BFu8c { int * v1; empty v2; unsigned char v3:8; };
struct Ip_Sf_BFu8i { int * v1; empty v2; unsigned int v3:8; };
struct Ip_Sf_BFu8ll { int * v1; empty v2; unsigned long long v3:8; };
struct Ip_Sf_BFu8s { int * v1; empty v2; unsigned short v3:8; };
struct Ip_Sf_BFu9i { int * v1; empty v2; unsigned int v3:9; };
struct Ip_Sf_BFu9ll { int * v1; empty v2; unsigned long long v3:9; };
struct Ip_Sf_BFu9s { int * v1; empty v2; unsigned short v3:9; };
struct Ip_Sf_C { int * v1; empty v2; char v3; };
struct Ip_Sf_D { int * v1; empty v2; double v3; };
struct Ip_Sf_F { int * v1; empty v2; float v3; };
struct Ip_Sf_I { int * v1; empty v2; int v3; };
struct Ip_Sf_Ip { int * v1; empty v2; int * v3; };
struct Ip_Sf_L { int * v1; empty v2; long long v3; };
struct Ip_Sf_S { int * v1; empty v2; short v3; };
struct Ip_Sf_Sf { int * v1; empty v2; empty v3; };
struct Ip_Sf_Uc { int * v1; empty v2; unsigned char v3; };
struct Ip_Sf_Ui { int * v1; empty v2; unsigned int v3; };
struct Ip_Sf_Ul { int * v1; empty v2; unsigned long long v3; };
struct Ip_Sf_Us { int * v1; empty v2; unsigned short v3; };
struct Ip_Sf_Vp { int * v1; empty v2; void * v3; };
struct Ip_Uc_Sf { int * v1; unsigned char v2; empty v3; };
struct Ip_Ui_Sf { int * v1; unsigned int v2; empty v3; };
struct Ip_Ul_Sf { int * v1; unsigned long long v2; empty v3; };
struct Ip_Us_Sf { int * v1; unsigned short v2; empty v3; };
struct Ip_Vp_Sf { int * v1; void * v2; empty v3; };
struct L_BFu15i_Sf { long long v1; unsigned int v2:15; empty v3; };
struct L_BFu15ll_Sf { long long v1; unsigned long long v2:15; empty v3; };
struct L_BFu15s_Sf { long long v1; unsigned short v2:15; empty v3; };
struct L_BFu16i_Sf { long long v1; unsigned int v2:16; empty v3; };
struct L_BFu16ll_Sf { long long v1; unsigned long long v2:16; empty v3; };
struct L_BFu16s_Sf { long long v1; unsigned short v2:16; empty v3; };
struct L_BFu17i_Sf { long long v1; unsigned int v2:17; empty v3; };
struct L_BFu17ll_Sf { long long v1; unsigned long long v2:17; empty v3; };
struct L_BFu1c_Sf { long long v1; unsigned char v2:1; empty v3; };
struct L_BFu1i_Sf { long long v1; unsigned int v2:1; empty v3; };
struct L_BFu1ll_Sf { long long v1; unsigned long long v2:1; empty v3; };
struct L_BFu1s_Sf { long long v1; unsigned short v2:1; empty v3; };
struct L_BFu31i_Sf { long long v1; unsigned int v2:31; empty v3; };
struct L_BFu31ll_Sf { long long v1; unsigned long long v2:31; empty v3; };
struct L_BFu32i_Sf { long long v1; unsigned int v2:32; empty v3; };
struct L_BFu32ll_Sf { long long v1; unsigned long long v2:32; empty v3; };
struct L_BFu33_Sf { long long v1; unsigned long long v2:33; empty v3; };
struct L_BFu7c_Sf { long long v1; unsigned char v2:7; empty v3; };
struct L_BFu7i_Sf { long long v1; unsigned int v2:7; empty v3; };
struct L_BFu7ll_Sf { long long v1; unsigned long long v2:7; empty v3; };
struct L_BFu7s_Sf { long long v1; unsigned short v2:7; empty v3; };
struct L_BFu8c_Sf { long long v1; unsigned char v2:8; empty v3; };
struct L_BFu8i_Sf { long long v1; unsigned int v2:8; empty v3; };
struct L_BFu8ll_Sf { long long v1; unsigned long long v2:8; empty v3; };
struct L_BFu8s_Sf { long long v1; unsigned short v2:8; empty v3; };
struct L_BFu9i_Sf { long long v1; unsigned int v2:9; empty v3; };
struct L_BFu9ll_Sf { long long v1; unsigned long long v2:9; empty v3; };
struct L_BFu9s_Sf { long long v1; unsigned short v2:9; empty v3; };
struct L_C_Sf { long long v1; char v2; empty v3; };
struct L_D_Sf { long long v1; double v2; empty v3; };
struct L_F_Sf { long long v1; float v2; empty v3; };
struct L_I_Sf { long long v1; int v2; empty v3; };
struct L_Ip_Sf { long long v1; int * v2; empty v3; };
struct L_L_Sf { long long v1; long long v2; empty v3; };
struct L_S_Sf { long long v1; short v2; empty v3; };
struct L_Sf { long long v1; empty v2; };
struct L_Sf_BFu15i { long long v1; empty v2; unsigned int v3:15; };
struct L_Sf_BFu15ll { long long v1; empty v2; unsigned long long v3:15; };
struct L_Sf_BFu15s { long long v1; empty v2; unsigned short v3:15; };
struct L_Sf_BFu16i { long long v1; empty v2; unsigned int v3:16; };
struct L_Sf_BFu16ll { long long v1; empty v2; unsigned long long v3:16; };
struct L_Sf_BFu16s { long long v1; empty v2; unsigned short v3:16; };
struct L_Sf_BFu17i { long long v1; empty v2; unsigned int v3:17; };
struct L_Sf_BFu17ll { long long v1; empty v2; unsigned long long v3:17; };
struct L_Sf_BFu1c { long long v1; empty v2; unsigned char v3:1; };
struct L_Sf_BFu1i { long long v1; empty v2; unsigned int v3:1; };
struct L_Sf_BFu1ll { long long v1; empty v2; unsigned long long v3:1; };
struct L_Sf_BFu1s { long long v1; empty v2; unsigned short v3:1; };
struct L_Sf_BFu31i { long long v1; empty v2; unsigned int v3:31; };
struct L_Sf_BFu31ll { long long v1; empty v2; unsigned long long v3:31; };
struct L_Sf_BFu32i { long long v1; empty v2; unsigned int v3:32; };
struct L_Sf_BFu32ll { long long v1; empty v2; unsigned long long v3:32; };
struct L_Sf_BFu33 { long long v1; empty v2; unsigned long long v3:33; };
struct L_Sf_BFu7c { long long v1; empty v2; unsigned char v3:7; };
struct L_Sf_BFu7i { long long v1; empty v2; unsigned int v3:7; };
struct L_Sf_BFu7ll { long long v1; empty v2; unsigned long long v3:7; };
struct L_Sf_BFu7s { long long v1; empty v2; unsigned short v3:7; };
struct L_Sf_BFu8c { long long v1; empty v2; unsigned char v3:8; };
struct L_Sf_BFu8i { long long v1; empty v2; unsigned int v3:8; };
struct L_Sf_BFu8ll { long long v1; empty v2; unsigned long long v3:8; };
struct L_Sf_BFu8s { long long v1; empty v2; unsigned short v3:8; };
struct L_Sf_BFu9i { long long v1; empty v2; unsigned int v3:9; };
struct L_Sf_BFu9ll { long long v1; empty v2; unsigned long long v3:9; };
struct L_Sf_BFu9s { long long v1; empty v2; unsigned short v3:9; };
struct L_Sf_C { long long v1; empty v2; char v3; };
struct L_Sf_D { long long v1; empty v2; double v3; };
struct L_Sf_F { long long v1; empty v2; float v3; };
struct L_Sf_I { long long v1; empty v2; int v3; };
struct L_Sf_Ip { long long v1; empty v2; int * v3; };
struct L_Sf_L { long long v1; empty v2; long long v3; };
struct L_Sf_S { long long v1; empty v2; short v3; };
struct L_Sf_Sf { long long v1; empty v2; empty v3; };
struct L_Sf_Uc { long long v1; empty v2; unsigned char v3; };
struct L_Sf_Ui { long long v1; empty v2; unsigned int v3; };
struct L_Sf_Ul { long long v1; empty v2; unsigned long long v3; };
struct L_Sf_Us { long long v1; empty v2; unsigned short v3; };
struct L_Sf_Vp { long long v1; empty v2; void * v3; };
struct L_Uc_Sf { long long v1; unsigned char v2; empty v3; };
struct L_Ui_Sf { long long v1; unsigned int v2; empty v3; };
struct L_Ul_Sf { long long v1; unsigned long long v2; empty v3; };
struct L_Us_Sf { long long v1; unsigned short v2; empty v3; };
struct L_Vp_Sf { long long v1; void * v2; empty v3; };
struct S_BFu15i_Sf { short v1; unsigned int v2:15; empty v3; };
struct S_BFu15ll_Sf { short v1; unsigned long long v2:15; empty v3; };
struct S_BFu15s_Sf { short v1; unsigned short v2:15; empty v3; };
struct S_BFu16i_Sf { short v1; unsigned int v2:16; empty v3; };
struct S_BFu16ll_Sf { short v1; unsigned long long v2:16; empty v3; };
struct S_BFu16s_Sf { short v1; unsigned short v2:16; empty v3; };
struct S_BFu17i_Sf { short v1; unsigned int v2:17; empty v3; };
struct S_BFu17ll_Sf { short v1; unsigned long long v2:17; empty v3; };
struct S_BFu1c_Sf { short v1; unsigned char v2:1; empty v3; };
struct S_BFu1i_Sf { short v1; unsigned int v2:1; empty v3; };
struct S_BFu1ll_Sf { short v1; unsigned long long v2:1; empty v3; };
struct S_BFu1s_Sf { short v1; unsigned short v2:1; empty v3; };
struct S_BFu31i_Sf { short v1; unsigned int v2:31; empty v3; };
struct S_BFu31ll_Sf { short v1; unsigned long long v2:31; empty v3; };
struct S_BFu32i_Sf { short v1; unsigned int v2:32; empty v3; };
struct S_BFu32ll_Sf { short v1; unsigned long long v2:32; empty v3; };
struct S_BFu33_Sf { short v1; unsigned long long v2:33; empty v3; };
struct S_BFu7c_Sf { short v1; unsigned char v2:7; empty v3; };
struct S_BFu7i_Sf { short v1; unsigned int v2:7; empty v3; };
struct S_BFu7ll_Sf { short v1; unsigned long long v2:7; empty v3; };
struct S_BFu7s_Sf { short v1; unsigned short v2:7; empty v3; };
struct S_BFu8c_Sf { short v1; unsigned char v2:8; empty v3; };
struct S_BFu8i_Sf { short v1; unsigned int v2:8; empty v3; };
struct S_BFu8ll_Sf { short v1; unsigned long long v2:8; empty v3; };
struct S_BFu8s_Sf { short v1; unsigned short v2:8; empty v3; };
struct S_BFu9i_Sf { short v1; unsigned int v2:9; empty v3; };
struct S_BFu9ll_Sf { short v1; unsigned long long v2:9; empty v3; };
struct S_BFu9s_Sf { short v1; unsigned short v2:9; empty v3; };
struct S_C_Sf { short v1; char v2; empty v3; };
struct S_D_Sf { short v1; double v2; empty v3; };
struct S_F_Sf { short v1; float v2; empty v3; };
struct S_I_Sf { short v1; int v2; empty v3; };
struct S_Ip_Sf { short v1; int * v2; empty v3; };
struct S_L_Sf { short v1; long long v2; empty v3; };
struct S_S_Sf { short v1; short v2; empty v3; };
struct S_Sf { short v1; empty v2; };
struct S_Sf_BFu15i { short v1; empty v2; unsigned int v3:15; };
struct S_Sf_BFu15ll { short v1; empty v2; unsigned long long v3:15; };
struct S_Sf_BFu15s { short v1; empty v2; unsigned short v3:15; };
struct S_Sf_BFu16i { short v1; empty v2; unsigned int v3:16; };
struct S_Sf_BFu16ll { short v1; empty v2; unsigned long long v3:16; };
struct S_Sf_BFu16s { short v1; empty v2; unsigned short v3:16; };
struct S_Sf_BFu17i { short v1; empty v2; unsigned int v3:17; };
struct S_Sf_BFu17ll { short v1; empty v2; unsigned long long v3:17; };
struct S_Sf_BFu1c { short v1; empty v2; unsigned char v3:1; };
struct S_Sf_BFu1i { short v1; empty v2; unsigned int v3:1; };
struct S_Sf_BFu1ll { short v1; empty v2; unsigned long long v3:1; };
struct S_Sf_BFu1s { short v1; empty v2; unsigned short v3:1; };
struct S_Sf_BFu31i { short v1; empty v2; unsigned int v3:31; };
struct S_Sf_BFu31ll { short v1; empty v2; unsigned long long v3:31; };
struct S_Sf_BFu32i { short v1; empty v2; unsigned int v3:32; };
struct S_Sf_BFu32ll { short v1; empty v2; unsigned long long v3:32; };
struct S_Sf_BFu33 { short v1; empty v2; unsigned long long v3:33; };
struct S_Sf_BFu7c { short v1; empty v2; unsigned char v3:7; };
struct S_Sf_BFu7i { short v1; empty v2; unsigned int v3:7; };
struct S_Sf_BFu7ll { short v1; empty v2; unsigned long long v3:7; };
struct S_Sf_BFu7s { short v1; empty v2; unsigned short v3:7; };
struct S_Sf_BFu8c { short v1; empty v2; unsigned char v3:8; };
struct S_Sf_BFu8i { short v1; empty v2; unsigned int v3:8; };
struct S_Sf_BFu8ll { short v1; empty v2; unsigned long long v3:8; };
struct S_Sf_BFu8s { short v1; empty v2; unsigned short v3:8; };
struct S_Sf_BFu9i { short v1; empty v2; unsigned int v3:9; };
struct S_Sf_BFu9ll { short v1; empty v2; unsigned long long v3:9; };
struct S_Sf_BFu9s { short v1; empty v2; unsigned short v3:9; };
struct S_Sf_C { short v1; empty v2; char v3; };
struct S_Sf_D { short v1; empty v2; double v3; };
struct S_Sf_F { short v1; empty v2; float v3; };
struct S_Sf_I { short v1; empty v2; int v3; };
struct S_Sf_Ip { short v1; empty v2; int * v3; };
struct S_Sf_L { short v1; empty v2; long long v3; };
struct S_Sf_S { short v1; empty v2; short v3; };
struct S_Sf_Sf { short v1; empty v2; empty v3; };
struct S_Sf_Uc { short v1; empty v2; unsigned char v3; };
struct S_Sf_Ui { short v1; empty v2; unsigned int v3; };
struct S_Sf_Ul { short v1; empty v2; unsigned long long v3; };
struct S_Sf_Us { short v1; empty v2; unsigned short v3; };
struct S_Sf_Vp { short v1; empty v2; void * v3; };
struct S_Uc_Sf { short v1; unsigned char v2; empty v3; };
struct S_Ui_Sf { short v1; unsigned int v2; empty v3; };
struct S_Ul_Sf { short v1; unsigned long long v2; empty v3; };
struct S_Us_Sf { short v1; unsigned short v2; empty v3; };
struct S_Vp_Sf { short v1; void * v2; empty v3; };
struct Sf { empty v1; };
struct Sf_BFu15i { empty v1; unsigned int v2:15; };
struct Sf_BFu15i_BFu15i { empty v1; unsigned int v2:15; unsigned int v3:15; };
struct Sf_BFu15i_BFu15ll { empty v1; unsigned int v2:15; unsigned long long v3:15; };
struct Sf_BFu15i_BFu15s { empty v1; unsigned int v2:15; unsigned short v3:15; };
struct Sf_BFu15i_BFu16i { empty v1; unsigned int v2:15; unsigned int v3:16; };
struct Sf_BFu15i_BFu16ll { empty v1; unsigned int v2:15; unsigned long long v3:16; };
struct Sf_BFu15i_BFu16s { empty v1; unsigned int v2:15; unsigned short v3:16; };
struct Sf_BFu15i_BFu17i { empty v1; unsigned int v2:15; unsigned int v3:17; };
struct Sf_BFu15i_BFu17ll { empty v1; unsigned int v2:15; unsigned long long v3:17; };
struct Sf_BFu15i_BFu1c { empty v1; unsigned int v2:15; unsigned char v3:1; };
struct Sf_BFu15i_BFu1i { empty v1; unsigned int v2:15; unsigned int v3:1; };
struct Sf_BFu15i_BFu1ll { empty v1; unsigned int v2:15; unsigned long long v3:1; };
struct Sf_BFu15i_BFu1s { empty v1; unsigned int v2:15; unsigned short v3:1; };
struct Sf_BFu15i_BFu31i { empty v1; unsigned int v2:15; unsigned int v3:31; };
struct Sf_BFu15i_BFu31ll { empty v1; unsigned int v2:15; unsigned long long v3:31; };
struct Sf_BFu15i_BFu32i { empty v1; unsigned int v2:15; unsigned int v3:32; };
struct Sf_BFu15i_BFu32ll { empty v1; unsigned int v2:15; unsigned long long v3:32; };
struct Sf_BFu15i_BFu33 { empty v1; unsigned int v2:15; unsigned long long v3:33; };
struct Sf_BFu15i_BFu7c { empty v1; unsigned int v2:15; unsigned char v3:7; };
struct Sf_BFu15i_BFu7i { empty v1; unsigned int v2:15; unsigned int v3:7; };
struct Sf_BFu15i_BFu7ll { empty v1; unsigned int v2:15; unsigned long long v3:7; };
struct Sf_BFu15i_BFu7s { empty v1; unsigned int v2:15; unsigned short v3:7; };
struct Sf_BFu15i_BFu8c { empty v1; unsigned int v2:15; unsigned char v3:8; };
struct Sf_BFu15i_BFu8i { empty v1; unsigned int v2:15; unsigned int v3:8; };
struct Sf_BFu15i_BFu8ll { empty v1; unsigned int v2:15; unsigned long long v3:8; };
struct Sf_BFu15i_BFu8s { empty v1; unsigned int v2:15; unsigned short v3:8; };
struct Sf_BFu15i_BFu9i { empty v1; unsigned int v2:15; unsigned int v3:9; };
struct Sf_BFu15i_BFu9ll { empty v1; unsigned int v2:15; unsigned long long v3:9; };
struct Sf_BFu15i_BFu9s { empty v1; unsigned int v2:15; unsigned short v3:9; };
struct Sf_BFu15i_C { empty v1; unsigned int v2:15; char v3; };
struct Sf_BFu15i_D { empty v1; unsigned int v2:15; double v3; };
struct Sf_BFu15i_F { empty v1; unsigned int v2:15; float v3; };
struct Sf_BFu15i_I { empty v1; unsigned int v2:15; int v3; };
struct Sf_BFu15i_Ip { empty v1; unsigned int v2:15; int * v3; };
struct Sf_BFu15i_L { empty v1; unsigned int v2:15; long long v3; };
struct Sf_BFu15i_S { empty v1; unsigned int v2:15; short v3; };
struct Sf_BFu15i_Sf { empty v1; unsigned int v2:15; empty v3; };
struct Sf_BFu15i_Uc { empty v1; unsigned int v2:15; unsigned char v3; };
struct Sf_BFu15i_Ui { empty v1; unsigned int v2:15; unsigned int v3; };
struct Sf_BFu15i_Ul { empty v1; unsigned int v2:15; unsigned long long v3; };
struct Sf_BFu15i_Us { empty v1; unsigned int v2:15; unsigned short v3; };
struct Sf_BFu15i_Vp { empty v1; unsigned int v2:15; void * v3; };
struct Sf_BFu15ll { empty v1; unsigned long long v2:15; };
struct Sf_BFu15ll_BFu15i { empty v1; unsigned long long v2:15; unsigned int v3:15; };
struct Sf_BFu15ll_BFu15ll { empty v1; unsigned long long v2:15; unsigned long long v3:15; };
struct Sf_BFu15ll_BFu15s { empty v1; unsigned long long v2:15; unsigned short v3:15; };
struct Sf_BFu15ll_BFu16i { empty v1; unsigned long long v2:15; unsigned int v3:16; };
struct Sf_BFu15ll_BFu16ll { empty v1; unsigned long long v2:15; unsigned long long v3:16; };
struct Sf_BFu15ll_BFu16s { empty v1; unsigned long long v2:15; unsigned short v3:16; };
struct Sf_BFu15ll_BFu17i { empty v1; unsigned long long v2:15; unsigned int v3:17; };
struct Sf_BFu15ll_BFu17ll { empty v1; unsigned long long v2:15; unsigned long long v3:17; };
struct Sf_BFu15ll_BFu1c { empty v1; unsigned long long v2:15; unsigned char v3:1; };
struct Sf_BFu15ll_BFu1i { empty v1; unsigned long long v2:15; unsigned int v3:1; };
struct Sf_BFu15ll_BFu1ll { empty v1; unsigned long long v2:15; unsigned long long v3:1; };
struct Sf_BFu15ll_BFu1s { empty v1; unsigned long long v2:15; unsigned short v3:1; };
struct Sf_BFu15ll_BFu31i { empty v1; unsigned long long v2:15; unsigned int v3:31; };
struct Sf_BFu15ll_BFu31ll { empty v1; unsigned long long v2:15; unsigned long long v3:31; };
struct Sf_BFu15ll_BFu32i { empty v1; unsigned long long v2:15; unsigned int v3:32; };
struct Sf_BFu15ll_BFu32ll { empty v1; unsigned long long v2:15; unsigned long long v3:32; };
struct Sf_BFu15ll_BFu33 { empty v1; unsigned long long v2:15; unsigned long long v3:33; };
struct Sf_BFu15ll_BFu7c { empty v1; unsigned long long v2:15; unsigned char v3:7; };
struct Sf_BFu15ll_BFu7i { empty v1; unsigned long long v2:15; unsigned int v3:7; };
struct Sf_BFu15ll_BFu7ll { empty v1; unsigned long long v2:15; unsigned long long v3:7; };
struct Sf_BFu15ll_BFu7s { empty v1; unsigned long long v2:15; unsigned short v3:7; };
struct Sf_BFu15ll_BFu8c { empty v1; unsigned long long v2:15; unsigned char v3:8; };
struct Sf_BFu15ll_BFu8i { empty v1; unsigned long long v2:15; unsigned int v3:8; };
struct Sf_BFu15ll_BFu8ll { empty v1; unsigned long long v2:15; unsigned long long v3:8; };
struct Sf_BFu15ll_BFu8s { empty v1; unsigned long long v2:15; unsigned short v3:8; };
struct Sf_BFu15ll_BFu9i { empty v1; unsigned long long v2:15; unsigned int v3:9; };
struct Sf_BFu15ll_BFu9ll { empty v1; unsigned long long v2:15; unsigned long long v3:9; };
struct Sf_BFu15ll_BFu9s { empty v1; unsigned long long v2:15; unsigned short v3:9; };
struct Sf_BFu15ll_C { empty v1; unsigned long long v2:15; char v3; };
struct Sf_BFu15ll_D { empty v1; unsigned long long v2:15; double v3; };
struct Sf_BFu15ll_F { empty v1; unsigned long long v2:15; float v3; };
struct Sf_BFu15ll_I { empty v1; unsigned long long v2:15; int v3; };
struct Sf_BFu15ll_Ip { empty v1; unsigned long long v2:15; int * v3; };
struct Sf_BFu15ll_L { empty v1; unsigned long long v2:15; long long v3; };
struct Sf_BFu15ll_S { empty v1; unsigned long long v2:15; short v3; };
struct Sf_BFu15ll_Sf { empty v1; unsigned long long v2:15; empty v3; };
struct Sf_BFu15ll_Uc { empty v1; unsigned long long v2:15; unsigned char v3; };
struct Sf_BFu15ll_Ui { empty v1; unsigned long long v2:15; unsigned int v3; };
struct Sf_BFu15ll_Ul { empty v1; unsigned long long v2:15; unsigned long long v3; };
struct Sf_BFu15ll_Us { empty v1; unsigned long long v2:15; unsigned short v3; };
struct Sf_BFu15ll_Vp { empty v1; unsigned long long v2:15; void * v3; };
struct Sf_BFu15s { empty v1; unsigned short v2:15; };
struct Sf_BFu15s_BFu15i { empty v1; unsigned short v2:15; unsigned int v3:15; };
struct Sf_BFu15s_BFu15ll { empty v1; unsigned short v2:15; unsigned long long v3:15; };
struct Sf_BFu15s_BFu15s { empty v1; unsigned short v2:15; unsigned short v3:15; };
struct Sf_BFu15s_BFu16i { empty v1; unsigned short v2:15; unsigned int v3:16; };
struct Sf_BFu15s_BFu16ll { empty v1; unsigned short v2:15; unsigned long long v3:16; };
struct Sf_BFu15s_BFu16s { empty v1; unsigned short v2:15; unsigned short v3:16; };
struct Sf_BFu15s_BFu17i { empty v1; unsigned short v2:15; unsigned int v3:17; };
struct Sf_BFu15s_BFu17ll { empty v1; unsigned short v2:15; unsigned long long v3:17; };
struct Sf_BFu15s_BFu1c { empty v1; unsigned short v2:15; unsigned char v3:1; };
struct Sf_BFu15s_BFu1i { empty v1; unsigned short v2:15; unsigned int v3:1; };
struct Sf_BFu15s_BFu1ll { empty v1; unsigned short v2:15; unsigned long long v3:1; };
struct Sf_BFu15s_BFu1s { empty v1; unsigned short v2:15; unsigned short v3:1; };
struct Sf_BFu15s_BFu31i { empty v1; unsigned short v2:15; unsigned int v3:31; };
struct Sf_BFu15s_BFu31ll { empty v1; unsigned short v2:15; unsigned long long v3:31; };
struct Sf_BFu15s_BFu32i { empty v1; unsigned short v2:15; unsigned int v3:32; };
struct Sf_BFu15s_BFu32ll { empty v1; unsigned short v2:15; unsigned long long v3:32; };
struct Sf_BFu15s_BFu33 { empty v1; unsigned short v2:15; unsigned long long v3:33; };
struct Sf_BFu15s_BFu7c { empty v1; unsigned short v2:15; unsigned char v3:7; };
struct Sf_BFu15s_BFu7i { empty v1; unsigned short v2:15; unsigned int v3:7; };
struct Sf_BFu15s_BFu7ll { empty v1; unsigned short v2:15; unsigned long long v3:7; };
struct Sf_BFu15s_BFu7s { empty v1; unsigned short v2:15; unsigned short v3:7; };
struct Sf_BFu15s_BFu8c { empty v1; unsigned short v2:15; unsigned char v3:8; };
struct Sf_BFu15s_BFu8i { empty v1; unsigned short v2:15; unsigned int v3:8; };
struct Sf_BFu15s_BFu8ll { empty v1; unsigned short v2:15; unsigned long long v3:8; };
struct Sf_BFu15s_BFu8s { empty v1; unsigned short v2:15; unsigned short v3:8; };
struct Sf_BFu15s_BFu9i { empty v1; unsigned short v2:15; unsigned int v3:9; };
struct Sf_BFu15s_BFu9ll { empty v1; unsigned short v2:15; unsigned long long v3:9; };
struct Sf_BFu15s_BFu9s { empty v1; unsigned short v2:15; unsigned short v3:9; };
struct Sf_BFu15s_C { empty v1; unsigned short v2:15; char v3; };
struct Sf_BFu15s_D { empty v1; unsigned short v2:15; double v3; };
struct Sf_BFu15s_F { empty v1; unsigned short v2:15; float v3; };
struct Sf_BFu15s_I { empty v1; unsigned short v2:15; int v3; };
struct Sf_BFu15s_Ip { empty v1; unsigned short v2:15; int * v3; };
struct Sf_BFu15s_L { empty v1; unsigned short v2:15; long long v3; };
struct Sf_BFu15s_S { empty v1; unsigned short v2:15; short v3; };
struct Sf_BFu15s_Sf { empty v1; unsigned short v2:15; empty v3; };
struct Sf_BFu15s_Uc { empty v1; unsigned short v2:15; unsigned char v3; };
struct Sf_BFu15s_Ui { empty v1; unsigned short v2:15; unsigned int v3; };
struct Sf_BFu15s_Ul { empty v1; unsigned short v2:15; unsigned long long v3; };
struct Sf_BFu15s_Us { empty v1; unsigned short v2:15; unsigned short v3; };
struct Sf_BFu15s_Vp { empty v1; unsigned short v2:15; void * v3; };
struct Sf_BFu16i { empty v1; unsigned int v2:16; };
struct Sf_BFu16i_BFu15i { empty v1; unsigned int v2:16; unsigned int v3:15; };
struct Sf_BFu16i_BFu15ll { empty v1; unsigned int v2:16; unsigned long long v3:15; };
struct Sf_BFu16i_BFu15s { empty v1; unsigned int v2:16; unsigned short v3:15; };
struct Sf_BFu16i_BFu16i { empty v1; unsigned int v2:16; unsigned int v3:16; };
struct Sf_BFu16i_BFu16ll { empty v1; unsigned int v2:16; unsigned long long v3:16; };
struct Sf_BFu16i_BFu16s { empty v1; unsigned int v2:16; unsigned short v3:16; };
struct Sf_BFu16i_BFu17i { empty v1; unsigned int v2:16; unsigned int v3:17; };
struct Sf_BFu16i_BFu17ll { empty v1; unsigned int v2:16; unsigned long long v3:17; };
struct Sf_BFu16i_BFu1c { empty v1; unsigned int v2:16; unsigned char v3:1; };
struct Sf_BFu16i_BFu1i { empty v1; unsigned int v2:16; unsigned int v3:1; };
struct Sf_BFu16i_BFu1ll { empty v1; unsigned int v2:16; unsigned long long v3:1; };
struct Sf_BFu16i_BFu1s { empty v1; unsigned int v2:16; unsigned short v3:1; };
struct Sf_BFu16i_BFu31i { empty v1; unsigned int v2:16; unsigned int v3:31; };
struct Sf_BFu16i_BFu31ll { empty v1; unsigned int v2:16; unsigned long long v3:31; };
struct Sf_BFu16i_BFu32i { empty v1; unsigned int v2:16; unsigned int v3:32; };
struct Sf_BFu16i_BFu32ll { empty v1; unsigned int v2:16; unsigned long long v3:32; };
struct Sf_BFu16i_BFu33 { empty v1; unsigned int v2:16; unsigned long long v3:33; };
struct Sf_BFu16i_BFu7c { empty v1; unsigned int v2:16; unsigned char v3:7; };
struct Sf_BFu16i_BFu7i { empty v1; unsigned int v2:16; unsigned int v3:7; };
struct Sf_BFu16i_BFu7ll { empty v1; unsigned int v2:16; unsigned long long v3:7; };
struct Sf_BFu16i_BFu7s { empty v1; unsigned int v2:16; unsigned short v3:7; };
struct Sf_BFu16i_BFu8c { empty v1; unsigned int v2:16; unsigned char v3:8; };
struct Sf_BFu16i_BFu8i { empty v1; unsigned int v2:16; unsigned int v3:8; };
struct Sf_BFu16i_BFu8ll { empty v1; unsigned int v2:16; unsigned long long v3:8; };
struct Sf_BFu16i_BFu8s { empty v1; unsigned int v2:16; unsigned short v3:8; };
struct Sf_BFu16i_BFu9i { empty v1; unsigned int v2:16; unsigned int v3:9; };
struct Sf_BFu16i_BFu9ll { empty v1; unsigned int v2:16; unsigned long long v3:9; };
struct Sf_BFu16i_BFu9s { empty v1; unsigned int v2:16; unsigned short v3:9; };
struct Sf_BFu16i_C { empty v1; unsigned int v2:16; char v3; };
struct Sf_BFu16i_D { empty v1; unsigned int v2:16; double v3; };
struct Sf_BFu16i_F { empty v1; unsigned int v2:16; float v3; };
struct Sf_BFu16i_I { empty v1; unsigned int v2:16; int v3; };
struct Sf_BFu16i_Ip { empty v1; unsigned int v2:16; int * v3; };
struct Sf_BFu16i_L { empty v1; unsigned int v2:16; long long v3; };
struct Sf_BFu16i_S { empty v1; unsigned int v2:16; short v3; };
struct Sf_BFu16i_Sf { empty v1; unsigned int v2:16; empty v3; };
struct Sf_BFu16i_Uc { empty v1; unsigned int v2:16; unsigned char v3; };
struct Sf_BFu16i_Ui { empty v1; unsigned int v2:16; unsigned int v3; };
struct Sf_BFu16i_Ul { empty v1; unsigned int v2:16; unsigned long long v3; };
struct Sf_BFu16i_Us { empty v1; unsigned int v2:16; unsigned short v3; };
struct Sf_BFu16i_Vp { empty v1; unsigned int v2:16; void * v3; };
struct Sf_BFu16ll { empty v1; unsigned long long v2:16; };
struct Sf_BFu16ll_BFu15i { empty v1; unsigned long long v2:16; unsigned int v3:15; };
struct Sf_BFu16ll_BFu15ll { empty v1; unsigned long long v2:16; unsigned long long v3:15; };
struct Sf_BFu16ll_BFu15s { empty v1; unsigned long long v2:16; unsigned short v3:15; };
struct Sf_BFu16ll_BFu16i { empty v1; unsigned long long v2:16; unsigned int v3:16; };
struct Sf_BFu16ll_BFu16ll { empty v1; unsigned long long v2:16; unsigned long long v3:16; };
struct Sf_BFu16ll_BFu16s { empty v1; unsigned long long v2:16; unsigned short v3:16; };
struct Sf_BFu16ll_BFu17i { empty v1; unsigned long long v2:16; unsigned int v3:17; };
struct Sf_BFu16ll_BFu17ll { empty v1; unsigned long long v2:16; unsigned long long v3:17; };
struct Sf_BFu16ll_BFu1c { empty v1; unsigned long long v2:16; unsigned char v3:1; };
struct Sf_BFu16ll_BFu1i { empty v1; unsigned long long v2:16; unsigned int v3:1; };
struct Sf_BFu16ll_BFu1ll { empty v1; unsigned long long v2:16; unsigned long long v3:1; };
struct Sf_BFu16ll_BFu1s { empty v1; unsigned long long v2:16; unsigned short v3:1; };
struct Sf_BFu16ll_BFu31i { empty v1; unsigned long long v2:16; unsigned int v3:31; };
struct Sf_BFu16ll_BFu31ll { empty v1; unsigned long long v2:16; unsigned long long v3:31; };
struct Sf_BFu16ll_BFu32i { empty v1; unsigned long long v2:16; unsigned int v3:32; };
struct Sf_BFu16ll_BFu32ll { empty v1; unsigned long long v2:16; unsigned long long v3:32; };
struct Sf_BFu16ll_BFu33 { empty v1; unsigned long long v2:16; unsigned long long v3:33; };
struct Sf_BFu16ll_BFu7c { empty v1; unsigned long long v2:16; unsigned char v3:7; };
struct Sf_BFu16ll_BFu7i { empty v1; unsigned long long v2:16; unsigned int v3:7; };
struct Sf_BFu16ll_BFu7ll { empty v1; unsigned long long v2:16; unsigned long long v3:7; };
struct Sf_BFu16ll_BFu7s { empty v1; unsigned long long v2:16; unsigned short v3:7; };
struct Sf_BFu16ll_BFu8c { empty v1; unsigned long long v2:16; unsigned char v3:8; };
struct Sf_BFu16ll_BFu8i { empty v1; unsigned long long v2:16; unsigned int v3:8; };
struct Sf_BFu16ll_BFu8ll { empty v1; unsigned long long v2:16; unsigned long long v3:8; };
struct Sf_BFu16ll_BFu8s { empty v1; unsigned long long v2:16; unsigned short v3:8; };
struct Sf_BFu16ll_BFu9i { empty v1; unsigned long long v2:16; unsigned int v3:9; };
struct Sf_BFu16ll_BFu9ll { empty v1; unsigned long long v2:16; unsigned long long v3:9; };
struct Sf_BFu16ll_BFu9s { empty v1; unsigned long long v2:16; unsigned short v3:9; };
struct Sf_BFu16ll_C { empty v1; unsigned long long v2:16; char v3; };
struct Sf_BFu16ll_D { empty v1; unsigned long long v2:16; double v3; };
struct Sf_BFu16ll_F { empty v1; unsigned long long v2:16; float v3; };
struct Sf_BFu16ll_I { empty v1; unsigned long long v2:16; int v3; };
struct Sf_BFu16ll_Ip { empty v1; unsigned long long v2:16; int * v3; };
struct Sf_BFu16ll_L { empty v1; unsigned long long v2:16; long long v3; };
struct Sf_BFu16ll_S { empty v1; unsigned long long v2:16; short v3; };
struct Sf_BFu16ll_Sf { empty v1; unsigned long long v2:16; empty v3; };
struct Sf_BFu16ll_Uc { empty v1; unsigned long long v2:16; unsigned char v3; };
struct Sf_BFu16ll_Ui { empty v1; unsigned long long v2:16; unsigned int v3; };
struct Sf_BFu16ll_Ul { empty v1; unsigned long long v2:16; unsigned long long v3; };
struct Sf_BFu16ll_Us { empty v1; unsigned long long v2:16; unsigned short v3; };
struct Sf_BFu16ll_Vp { empty v1; unsigned long long v2:16; void * v3; };
struct Sf_BFu16s { empty v1; unsigned short v2:16; };
struct Sf_BFu16s_BFu15i { empty v1; unsigned short v2:16; unsigned int v3:15; };
struct Sf_BFu16s_BFu15ll { empty v1; unsigned short v2:16; unsigned long long v3:15; };
struct Sf_BFu16s_BFu15s { empty v1; unsigned short v2:16; unsigned short v3:15; };
struct Sf_BFu16s_BFu16i { empty v1; unsigned short v2:16; unsigned int v3:16; };
struct Sf_BFu16s_BFu16ll { empty v1; unsigned short v2:16; unsigned long long v3:16; };
struct Sf_BFu16s_BFu16s { empty v1; unsigned short v2:16; unsigned short v3:16; };
struct Sf_BFu16s_BFu17i { empty v1; unsigned short v2:16; unsigned int v3:17; };
struct Sf_BFu16s_BFu17ll { empty v1; unsigned short v2:16; unsigned long long v3:17; };
struct Sf_BFu16s_BFu1c { empty v1; unsigned short v2:16; unsigned char v3:1; };
struct Sf_BFu16s_BFu1i { empty v1; unsigned short v2:16; unsigned int v3:1; };
struct Sf_BFu16s_BFu1ll { empty v1; unsigned short v2:16; unsigned long long v3:1; };
struct Sf_BFu16s_BFu1s { empty v1; unsigned short v2:16; unsigned short v3:1; };
struct Sf_BFu16s_BFu31i { empty v1; unsigned short v2:16; unsigned int v3:31; };
struct Sf_BFu16s_BFu31ll { empty v1; unsigned short v2:16; unsigned long long v3:31; };
struct Sf_BFu16s_BFu32i { empty v1; unsigned short v2:16; unsigned int v3:32; };
struct Sf_BFu16s_BFu32ll { empty v1; unsigned short v2:16; unsigned long long v3:32; };
struct Sf_BFu16s_BFu33 { empty v1; unsigned short v2:16; unsigned long long v3:33; };
struct Sf_BFu16s_BFu7c { empty v1; unsigned short v2:16; unsigned char v3:7; };
struct Sf_BFu16s_BFu7i { empty v1; unsigned short v2:16; unsigned int v3:7; };
struct Sf_BFu16s_BFu7ll { empty v1; unsigned short v2:16; unsigned long long v3:7; };
struct Sf_BFu16s_BFu7s { empty v1; unsigned short v2:16; unsigned short v3:7; };
struct Sf_BFu16s_BFu8c { empty v1; unsigned short v2:16; unsigned char v3:8; };
struct Sf_BFu16s_BFu8i { empty v1; unsigned short v2:16; unsigned int v3:8; };
struct Sf_BFu16s_BFu8ll { empty v1; unsigned short v2:16; unsigned long long v3:8; };
struct Sf_BFu16s_BFu8s { empty v1; unsigned short v2:16; unsigned short v3:8; };
struct Sf_BFu16s_BFu9i { empty v1; unsigned short v2:16; unsigned int v3:9; };
struct Sf_BFu16s_BFu9ll { empty v1; unsigned short v2:16; unsigned long long v3:9; };
struct Sf_BFu16s_BFu9s { empty v1; unsigned short v2:16; unsigned short v3:9; };
struct Sf_BFu16s_C { empty v1; unsigned short v2:16; char v3; };
struct Sf_BFu16s_D { empty v1; unsigned short v2:16; double v3; };
struct Sf_BFu16s_F { empty v1; unsigned short v2:16; float v3; };
struct Sf_BFu16s_I { empty v1; unsigned short v2:16; int v3; };
struct Sf_BFu16s_Ip { empty v1; unsigned short v2:16; int * v3; };
struct Sf_BFu16s_L { empty v1; unsigned short v2:16; long long v3; };
struct Sf_BFu16s_S { empty v1; unsigned short v2:16; short v3; };
struct Sf_BFu16s_Sf { empty v1; unsigned short v2:16; empty v3; };
struct Sf_BFu16s_Uc { empty v1; unsigned short v2:16; unsigned char v3; };
struct Sf_BFu16s_Ui { empty v1; unsigned short v2:16; unsigned int v3; };
struct Sf_BFu16s_Ul { empty v1; unsigned short v2:16; unsigned long long v3; };
struct Sf_BFu16s_Us { empty v1; unsigned short v2:16; unsigned short v3; };
struct Sf_BFu16s_Vp { empty v1; unsigned short v2:16; void * v3; };
struct Sf_BFu17i { empty v1; unsigned int v2:17; };
struct Sf_BFu17i_BFu15i { empty v1; unsigned int v2:17; unsigned int v3:15; };
struct Sf_BFu17i_BFu15ll { empty v1; unsigned int v2:17; unsigned long long v3:15; };
struct Sf_BFu17i_BFu15s { empty v1; unsigned int v2:17; unsigned short v3:15; };
struct Sf_BFu17i_BFu16i { empty v1; unsigned int v2:17; unsigned int v3:16; };
struct Sf_BFu17i_BFu16ll { empty v1; unsigned int v2:17; unsigned long long v3:16; };
struct Sf_BFu17i_BFu16s { empty v1; unsigned int v2:17; unsigned short v3:16; };
struct Sf_BFu17i_BFu17i { empty v1; unsigned int v2:17; unsigned int v3:17; };
struct Sf_BFu17i_BFu17ll { empty v1; unsigned int v2:17; unsigned long long v3:17; };
struct Sf_BFu17i_BFu1c { empty v1; unsigned int v2:17; unsigned char v3:1; };
struct Sf_BFu17i_BFu1i { empty v1; unsigned int v2:17; unsigned int v3:1; };
struct Sf_BFu17i_BFu1ll { empty v1; unsigned int v2:17; unsigned long long v3:1; };
struct Sf_BFu17i_BFu1s { empty v1; unsigned int v2:17; unsigned short v3:1; };
struct Sf_BFu17i_BFu31i { empty v1; unsigned int v2:17; unsigned int v3:31; };
struct Sf_BFu17i_BFu31ll { empty v1; unsigned int v2:17; unsigned long long v3:31; };
struct Sf_BFu17i_BFu32i { empty v1; unsigned int v2:17; unsigned int v3:32; };
struct Sf_BFu17i_BFu32ll { empty v1; unsigned int v2:17; unsigned long long v3:32; };
struct Sf_BFu17i_BFu33 { empty v1; unsigned int v2:17; unsigned long long v3:33; };
struct Sf_BFu17i_BFu7c { empty v1; unsigned int v2:17; unsigned char v3:7; };
struct Sf_BFu17i_BFu7i { empty v1; unsigned int v2:17; unsigned int v3:7; };
struct Sf_BFu17i_BFu7ll { empty v1; unsigned int v2:17; unsigned long long v3:7; };
struct Sf_BFu17i_BFu7s { empty v1; unsigned int v2:17; unsigned short v3:7; };
struct Sf_BFu17i_BFu8c { empty v1; unsigned int v2:17; unsigned char v3:8; };
struct Sf_BFu17i_BFu8i { empty v1; unsigned int v2:17; unsigned int v3:8; };
struct Sf_BFu17i_BFu8ll { empty v1; unsigned int v2:17; unsigned long long v3:8; };
struct Sf_BFu17i_BFu8s { empty v1; unsigned int v2:17; unsigned short v3:8; };
struct Sf_BFu17i_BFu9i { empty v1; unsigned int v2:17; unsigned int v3:9; };
struct Sf_BFu17i_BFu9ll { empty v1; unsigned int v2:17; unsigned long long v3:9; };
struct Sf_BFu17i_BFu9s { empty v1; unsigned int v2:17; unsigned short v3:9; };
struct Sf_BFu17i_C { empty v1; unsigned int v2:17; char v3; };
struct Sf_BFu17i_D { empty v1; unsigned int v2:17; double v3; };
struct Sf_BFu17i_F { empty v1; unsigned int v2:17; float v3; };
struct Sf_BFu17i_I { empty v1; unsigned int v2:17; int v3; };
struct Sf_BFu17i_Ip { empty v1; unsigned int v2:17; int * v3; };
struct Sf_BFu17i_L { empty v1; unsigned int v2:17; long long v3; };
struct Sf_BFu17i_S { empty v1; unsigned int v2:17; short v3; };
struct Sf_BFu17i_Sf { empty v1; unsigned int v2:17; empty v3; };
struct Sf_BFu17i_Uc { empty v1; unsigned int v2:17; unsigned char v3; };
struct Sf_BFu17i_Ui { empty v1; unsigned int v2:17; unsigned int v3; };
struct Sf_BFu17i_Ul { empty v1; unsigned int v2:17; unsigned long long v3; };
struct Sf_BFu17i_Us { empty v1; unsigned int v2:17; unsigned short v3; };
struct Sf_BFu17i_Vp { empty v1; unsigned int v2:17; void * v3; };
struct Sf_BFu17ll { empty v1; unsigned long long v2:17; };
struct Sf_BFu17ll_BFu15i { empty v1; unsigned long long v2:17; unsigned int v3:15; };
struct Sf_BFu17ll_BFu15ll { empty v1; unsigned long long v2:17; unsigned long long v3:15; };
struct Sf_BFu17ll_BFu15s { empty v1; unsigned long long v2:17; unsigned short v3:15; };
struct Sf_BFu17ll_BFu16i { empty v1; unsigned long long v2:17; unsigned int v3:16; };
struct Sf_BFu17ll_BFu16ll { empty v1; unsigned long long v2:17; unsigned long long v3:16; };
struct Sf_BFu17ll_BFu16s { empty v1; unsigned long long v2:17; unsigned short v3:16; };
struct Sf_BFu17ll_BFu17i { empty v1; unsigned long long v2:17; unsigned int v3:17; };
struct Sf_BFu17ll_BFu17ll { empty v1; unsigned long long v2:17; unsigned long long v3:17; };
struct Sf_BFu17ll_BFu1c { empty v1; unsigned long long v2:17; unsigned char v3:1; };
struct Sf_BFu17ll_BFu1i { empty v1; unsigned long long v2:17; unsigned int v3:1; };
struct Sf_BFu17ll_BFu1ll { empty v1; unsigned long long v2:17; unsigned long long v3:1; };
struct Sf_BFu17ll_BFu1s { empty v1; unsigned long long v2:17; unsigned short v3:1; };
struct Sf_BFu17ll_BFu31i { empty v1; unsigned long long v2:17; unsigned int v3:31; };
struct Sf_BFu17ll_BFu31ll { empty v1; unsigned long long v2:17; unsigned long long v3:31; };
struct Sf_BFu17ll_BFu32i { empty v1; unsigned long long v2:17; unsigned int v3:32; };
struct Sf_BFu17ll_BFu32ll { empty v1; unsigned long long v2:17; unsigned long long v3:32; };
struct Sf_BFu17ll_BFu33 { empty v1; unsigned long long v2:17; unsigned long long v3:33; };
struct Sf_BFu17ll_BFu7c { empty v1; unsigned long long v2:17; unsigned char v3:7; };
struct Sf_BFu17ll_BFu7i { empty v1; unsigned long long v2:17; unsigned int v3:7; };
struct Sf_BFu17ll_BFu7ll { empty v1; unsigned long long v2:17; unsigned long long v3:7; };
struct Sf_BFu17ll_BFu7s { empty v1; unsigned long long v2:17; unsigned short v3:7; };
struct Sf_BFu17ll_BFu8c { empty v1; unsigned long long v2:17; unsigned char v3:8; };
struct Sf_BFu17ll_BFu8i { empty v1; unsigned long long v2:17; unsigned int v3:8; };
struct Sf_BFu17ll_BFu8ll { empty v1; unsigned long long v2:17; unsigned long long v3:8; };
struct Sf_BFu17ll_BFu8s { empty v1; unsigned long long v2:17; unsigned short v3:8; };
struct Sf_BFu17ll_BFu9i { empty v1; unsigned long long v2:17; unsigned int v3:9; };
struct Sf_BFu17ll_BFu9ll { empty v1; unsigned long long v2:17; unsigned long long v3:9; };
struct Sf_BFu17ll_BFu9s { empty v1; unsigned long long v2:17; unsigned short v3:9; };
struct Sf_BFu17ll_C { empty v1; unsigned long long v2:17; char v3; };
struct Sf_BFu17ll_D { empty v1; unsigned long long v2:17; double v3; };
struct Sf_BFu17ll_F { empty v1; unsigned long long v2:17; float v3; };
struct Sf_BFu17ll_I { empty v1; unsigned long long v2:17; int v3; };
struct Sf_BFu17ll_Ip { empty v1; unsigned long long v2:17; int * v3; };
struct Sf_BFu17ll_L { empty v1; unsigned long long v2:17; long long v3; };
struct Sf_BFu17ll_S { empty v1; unsigned long long v2:17; short v3; };
struct Sf_BFu17ll_Sf { empty v1; unsigned long long v2:17; empty v3; };
struct Sf_BFu17ll_Uc { empty v1; unsigned long long v2:17; unsigned char v3; };
struct Sf_BFu17ll_Ui { empty v1; unsigned long long v2:17; unsigned int v3; };
struct Sf_BFu17ll_Ul { empty v1; unsigned long long v2:17; unsigned long long v3; };
struct Sf_BFu17ll_Us { empty v1; unsigned long long v2:17; unsigned short v3; };
struct Sf_BFu17ll_Vp { empty v1; unsigned long long v2:17; void * v3; };
struct Sf_BFu1c { empty v1; unsigned char v2:1; };
struct Sf_BFu1c_BFu15i { empty v1; unsigned char v2:1; unsigned int v3:15; };
struct Sf_BFu1c_BFu15ll { empty v1; unsigned char v2:1; unsigned long long v3:15; };
struct Sf_BFu1c_BFu15s { empty v1; unsigned char v2:1; unsigned short v3:15; };
struct Sf_BFu1c_BFu16i { empty v1; unsigned char v2:1; unsigned int v3:16; };
struct Sf_BFu1c_BFu16ll { empty v1; unsigned char v2:1; unsigned long long v3:16; };
struct Sf_BFu1c_BFu16s { empty v1; unsigned char v2:1; unsigned short v3:16; };
struct Sf_BFu1c_BFu17i { empty v1; unsigned char v2:1; unsigned int v3:17; };
struct Sf_BFu1c_BFu17ll { empty v1; unsigned char v2:1; unsigned long long v3:17; };
struct Sf_BFu1c_BFu1c { empty v1; unsigned char v2:1; unsigned char v3:1; };
struct Sf_BFu1c_BFu1i { empty v1; unsigned char v2:1; unsigned int v3:1; };
struct Sf_BFu1c_BFu1ll { empty v1; unsigned char v2:1; unsigned long long v3:1; };
struct Sf_BFu1c_BFu1s { empty v1; unsigned char v2:1; unsigned short v3:1; };
struct Sf_BFu1c_BFu31i { empty v1; unsigned char v2:1; unsigned int v3:31; };
struct Sf_BFu1c_BFu31ll { empty v1; unsigned char v2:1; unsigned long long v3:31; };
struct Sf_BFu1c_BFu32i { empty v1; unsigned char v2:1; unsigned int v3:32; };
struct Sf_BFu1c_BFu32ll { empty v1; unsigned char v2:1; unsigned long long v3:32; };
struct Sf_BFu1c_BFu33 { empty v1; unsigned char v2:1; unsigned long long v3:33; };
struct Sf_BFu1c_BFu7c { empty v1; unsigned char v2:1; unsigned char v3:7; };
struct Sf_BFu1c_BFu7i { empty v1; unsigned char v2:1; unsigned int v3:7; };
struct Sf_BFu1c_BFu7ll { empty v1; unsigned char v2:1; unsigned long long v3:7; };
struct Sf_BFu1c_BFu7s { empty v1; unsigned char v2:1; unsigned short v3:7; };
struct Sf_BFu1c_BFu8c { empty v1; unsigned char v2:1; unsigned char v3:8; };
struct Sf_BFu1c_BFu8i { empty v1; unsigned char v2:1; unsigned int v3:8; };
struct Sf_BFu1c_BFu8ll { empty v1; unsigned char v2:1; unsigned long long v3:8; };
struct Sf_BFu1c_BFu8s { empty v1; unsigned char v2:1; unsigned short v3:8; };
struct Sf_BFu1c_BFu9i { empty v1; unsigned char v2:1; unsigned int v3:9; };
struct Sf_BFu1c_BFu9ll { empty v1; unsigned char v2:1; unsigned long long v3:9; };
struct Sf_BFu1c_BFu9s { empty v1; unsigned char v2:1; unsigned short v3:9; };
struct Sf_BFu1c_C { empty v1; unsigned char v2:1; char v3; };
struct Sf_BFu1c_D { empty v1; unsigned char v2:1; double v3; };
struct Sf_BFu1c_F { empty v1; unsigned char v2:1; float v3; };
struct Sf_BFu1c_I { empty v1; unsigned char v2:1; int v3; };
struct Sf_BFu1c_Ip { empty v1; unsigned char v2:1; int * v3; };
struct Sf_BFu1c_L { empty v1; unsigned char v2:1; long long v3; };
struct Sf_BFu1c_S { empty v1; unsigned char v2:1; short v3; };
struct Sf_BFu1c_Sf { empty v1; unsigned char v2:1; empty v3; };
struct Sf_BFu1c_Uc { empty v1; unsigned char v2:1; unsigned char v3; };
struct Sf_BFu1c_Ui { empty v1; unsigned char v2:1; unsigned int v3; };
struct Sf_BFu1c_Ul { empty v1; unsigned char v2:1; unsigned long long v3; };
struct Sf_BFu1c_Us { empty v1; unsigned char v2:1; unsigned short v3; };
struct Sf_BFu1c_Vp { empty v1; unsigned char v2:1; void * v3; };
struct Sf_BFu1i { empty v1; unsigned int v2:1; };
struct Sf_BFu1i_BFu15i { empty v1; unsigned int v2:1; unsigned int v3:15; };
struct Sf_BFu1i_BFu15ll { empty v1; unsigned int v2:1; unsigned long long v3:15; };
struct Sf_BFu1i_BFu15s { empty v1; unsigned int v2:1; unsigned short v3:15; };
struct Sf_BFu1i_BFu16i { empty v1; unsigned int v2:1; unsigned int v3:16; };
struct Sf_BFu1i_BFu16ll { empty v1; unsigned int v2:1; unsigned long long v3:16; };
struct Sf_BFu1i_BFu16s { empty v1; unsigned int v2:1; unsigned short v3:16; };
struct Sf_BFu1i_BFu17i { empty v1; unsigned int v2:1; unsigned int v3:17; };
struct Sf_BFu1i_BFu17ll { empty v1; unsigned int v2:1; unsigned long long v3:17; };
struct Sf_BFu1i_BFu1c { empty v1; unsigned int v2:1; unsigned char v3:1; };
struct Sf_BFu1i_BFu1i { empty v1; unsigned int v2:1; unsigned int v3:1; };
struct Sf_BFu1i_BFu1ll { empty v1; unsigned int v2:1; unsigned long long v3:1; };
struct Sf_BFu1i_BFu1s { empty v1; unsigned int v2:1; unsigned short v3:1; };
struct Sf_BFu1i_BFu31i { empty v1; unsigned int v2:1; unsigned int v3:31; };
struct Sf_BFu1i_BFu31ll { empty v1; unsigned int v2:1; unsigned long long v3:31; };
struct Sf_BFu1i_BFu32i { empty v1; unsigned int v2:1; unsigned int v3:32; };
struct Sf_BFu1i_BFu32ll { empty v1; unsigned int v2:1; unsigned long long v3:32; };
struct Sf_BFu1i_BFu33 { empty v1; unsigned int v2:1; unsigned long long v3:33; };
struct Sf_BFu1i_BFu7c { empty v1; unsigned int v2:1; unsigned char v3:7; };
struct Sf_BFu1i_BFu7i { empty v1; unsigned int v2:1; unsigned int v3:7; };
struct Sf_BFu1i_BFu7ll { empty v1; unsigned int v2:1; unsigned long long v3:7; };
struct Sf_BFu1i_BFu7s { empty v1; unsigned int v2:1; unsigned short v3:7; };
struct Sf_BFu1i_BFu8c { empty v1; unsigned int v2:1; unsigned char v3:8; };
struct Sf_BFu1i_BFu8i { empty v1; unsigned int v2:1; unsigned int v3:8; };
struct Sf_BFu1i_BFu8ll { empty v1; unsigned int v2:1; unsigned long long v3:8; };
struct Sf_BFu1i_BFu8s { empty v1; unsigned int v2:1; unsigned short v3:8; };
struct Sf_BFu1i_BFu9i { empty v1; unsigned int v2:1; unsigned int v3:9; };
struct Sf_BFu1i_BFu9ll { empty v1; unsigned int v2:1; unsigned long long v3:9; };
struct Sf_BFu1i_BFu9s { empty v1; unsigned int v2:1; unsigned short v3:9; };
struct Sf_BFu1i_C { empty v1; unsigned int v2:1; char v3; };
struct Sf_BFu1i_D { empty v1; unsigned int v2:1; double v3; };
struct Sf_BFu1i_F { empty v1; unsigned int v2:1; float v3; };
struct Sf_BFu1i_I { empty v1; unsigned int v2:1; int v3; };
struct Sf_BFu1i_Ip { empty v1; unsigned int v2:1; int * v3; };
struct Sf_BFu1i_L { empty v1; unsigned int v2:1; long long v3; };
struct Sf_BFu1i_S { empty v1; unsigned int v2:1; short v3; };
struct Sf_BFu1i_Sf { empty v1; unsigned int v2:1; empty v3; };
struct Sf_BFu1i_Uc { empty v1; unsigned int v2:1; unsigned char v3; };
struct Sf_BFu1i_Ui { empty v1; unsigned int v2:1; unsigned int v3; };
struct Sf_BFu1i_Ul { empty v1; unsigned int v2:1; unsigned long long v3; };
struct Sf_BFu1i_Us { empty v1; unsigned int v2:1; unsigned short v3; };
struct Sf_BFu1i_Vp { empty v1; unsigned int v2:1; void * v3; };
struct Sf_BFu1ll { empty v1; unsigned long long v2:1; };
struct Sf_BFu1ll_BFu15i { empty v1; unsigned long long v2:1; unsigned int v3:15; };
struct Sf_BFu1ll_BFu15ll { empty v1; unsigned long long v2:1; unsigned long long v3:15; };
struct Sf_BFu1ll_BFu15s { empty v1; unsigned long long v2:1; unsigned short v3:15; };
struct Sf_BFu1ll_BFu16i { empty v1; unsigned long long v2:1; unsigned int v3:16; };
struct Sf_BFu1ll_BFu16ll { empty v1; unsigned long long v2:1; unsigned long long v3:16; };
struct Sf_BFu1ll_BFu16s { empty v1; unsigned long long v2:1; unsigned short v3:16; };
struct Sf_BFu1ll_BFu17i { empty v1; unsigned long long v2:1; unsigned int v3:17; };
struct Sf_BFu1ll_BFu17ll { empty v1; unsigned long long v2:1; unsigned long long v3:17; };
struct Sf_BFu1ll_BFu1c { empty v1; unsigned long long v2:1; unsigned char v3:1; };
struct Sf_BFu1ll_BFu1i { empty v1; unsigned long long v2:1; unsigned int v3:1; };
struct Sf_BFu1ll_BFu1ll { empty v1; unsigned long long v2:1; unsigned long long v3:1; };
struct Sf_BFu1ll_BFu1s { empty v1; unsigned long long v2:1; unsigned short v3:1; };
struct Sf_BFu1ll_BFu31i { empty v1; unsigned long long v2:1; unsigned int v3:31; };
struct Sf_BFu1ll_BFu31ll { empty v1; unsigned long long v2:1; unsigned long long v3:31; };
struct Sf_BFu1ll_BFu32i { empty v1; unsigned long long v2:1; unsigned int v3:32; };
struct Sf_BFu1ll_BFu32ll { empty v1; unsigned long long v2:1; unsigned long long v3:32; };
struct Sf_BFu1ll_BFu33 { empty v1; unsigned long long v2:1; unsigned long long v3:33; };
struct Sf_BFu1ll_BFu7c { empty v1; unsigned long long v2:1; unsigned char v3:7; };
struct Sf_BFu1ll_BFu7i { empty v1; unsigned long long v2:1; unsigned int v3:7; };
struct Sf_BFu1ll_BFu7ll { empty v1; unsigned long long v2:1; unsigned long long v3:7; };
struct Sf_BFu1ll_BFu7s { empty v1; unsigned long long v2:1; unsigned short v3:7; };
struct Sf_BFu1ll_BFu8c { empty v1; unsigned long long v2:1; unsigned char v3:8; };
struct Sf_BFu1ll_BFu8i { empty v1; unsigned long long v2:1; unsigned int v3:8; };
struct Sf_BFu1ll_BFu8ll { empty v1; unsigned long long v2:1; unsigned long long v3:8; };
struct Sf_BFu1ll_BFu8s { empty v1; unsigned long long v2:1; unsigned short v3:8; };
struct Sf_BFu1ll_BFu9i { empty v1; unsigned long long v2:1; unsigned int v3:9; };
struct Sf_BFu1ll_BFu9ll { empty v1; unsigned long long v2:1; unsigned long long v3:9; };
struct Sf_BFu1ll_BFu9s { empty v1; unsigned long long v2:1; unsigned short v3:9; };
struct Sf_BFu1ll_C { empty v1; unsigned long long v2:1; char v3; };
struct Sf_BFu1ll_D { empty v1; unsigned long long v2:1; double v3; };
struct Sf_BFu1ll_F { empty v1; unsigned long long v2:1; float v3; };
struct Sf_BFu1ll_I { empty v1; unsigned long long v2:1; int v3; };
struct Sf_BFu1ll_Ip { empty v1; unsigned long long v2:1; int * v3; };
struct Sf_BFu1ll_L { empty v1; unsigned long long v2:1; long long v3; };
struct Sf_BFu1ll_S { empty v1; unsigned long long v2:1; short v3; };
struct Sf_BFu1ll_Sf { empty v1; unsigned long long v2:1; empty v3; };
struct Sf_BFu1ll_Uc { empty v1; unsigned long long v2:1; unsigned char v3; };
struct Sf_BFu1ll_Ui { empty v1; unsigned long long v2:1; unsigned int v3; };
struct Sf_BFu1ll_Ul { empty v1; unsigned long long v2:1; unsigned long long v3; };
struct Sf_BFu1ll_Us { empty v1; unsigned long long v2:1; unsigned short v3; };
struct Sf_BFu1ll_Vp { empty v1; unsigned long long v2:1; void * v3; };
struct Sf_BFu1s { empty v1; unsigned short v2:1; };
struct Sf_BFu1s_BFu15i { empty v1; unsigned short v2:1; unsigned int v3:15; };
struct Sf_BFu1s_BFu15ll { empty v1; unsigned short v2:1; unsigned long long v3:15; };
struct Sf_BFu1s_BFu15s { empty v1; unsigned short v2:1; unsigned short v3:15; };
struct Sf_BFu1s_BFu16i { empty v1; unsigned short v2:1; unsigned int v3:16; };
struct Sf_BFu1s_BFu16ll { empty v1; unsigned short v2:1; unsigned long long v3:16; };
struct Sf_BFu1s_BFu16s { empty v1; unsigned short v2:1; unsigned short v3:16; };
struct Sf_BFu1s_BFu17i { empty v1; unsigned short v2:1; unsigned int v3:17; };
struct Sf_BFu1s_BFu17ll { empty v1; unsigned short v2:1; unsigned long long v3:17; };
struct Sf_BFu1s_BFu1c { empty v1; unsigned short v2:1; unsigned char v3:1; };
struct Sf_BFu1s_BFu1i { empty v1; unsigned short v2:1; unsigned int v3:1; };
struct Sf_BFu1s_BFu1ll { empty v1; unsigned short v2:1; unsigned long long v3:1; };
struct Sf_BFu1s_BFu1s { empty v1; unsigned short v2:1; unsigned short v3:1; };
struct Sf_BFu1s_BFu31i { empty v1; unsigned short v2:1; unsigned int v3:31; };
struct Sf_BFu1s_BFu31ll { empty v1; unsigned short v2:1; unsigned long long v3:31; };
struct Sf_BFu1s_BFu32i { empty v1; unsigned short v2:1; unsigned int v3:32; };
struct Sf_BFu1s_BFu32ll { empty v1; unsigned short v2:1; unsigned long long v3:32; };
struct Sf_BFu1s_BFu33 { empty v1; unsigned short v2:1; unsigned long long v3:33; };
struct Sf_BFu1s_BFu7c { empty v1; unsigned short v2:1; unsigned char v3:7; };
struct Sf_BFu1s_BFu7i { empty v1; unsigned short v2:1; unsigned int v3:7; };
struct Sf_BFu1s_BFu7ll { empty v1; unsigned short v2:1; unsigned long long v3:7; };
struct Sf_BFu1s_BFu7s { empty v1; unsigned short v2:1; unsigned short v3:7; };
struct Sf_BFu1s_BFu8c { empty v1; unsigned short v2:1; unsigned char v3:8; };
struct Sf_BFu1s_BFu8i { empty v1; unsigned short v2:1; unsigned int v3:8; };
struct Sf_BFu1s_BFu8ll { empty v1; unsigned short v2:1; unsigned long long v3:8; };
struct Sf_BFu1s_BFu8s { empty v1; unsigned short v2:1; unsigned short v3:8; };
struct Sf_BFu1s_BFu9i { empty v1; unsigned short v2:1; unsigned int v3:9; };
struct Sf_BFu1s_BFu9ll { empty v1; unsigned short v2:1; unsigned long long v3:9; };
struct Sf_BFu1s_BFu9s { empty v1; unsigned short v2:1; unsigned short v3:9; };
struct Sf_BFu1s_C { empty v1; unsigned short v2:1; char v3; };
struct Sf_BFu1s_D { empty v1; unsigned short v2:1; double v3; };
struct Sf_BFu1s_F { empty v1; unsigned short v2:1; float v3; };
struct Sf_BFu1s_I { empty v1; unsigned short v2:1; int v3; };
struct Sf_BFu1s_Ip { empty v1; unsigned short v2:1; int * v3; };
struct Sf_BFu1s_L { empty v1; unsigned short v2:1; long long v3; };
struct Sf_BFu1s_S { empty v1; unsigned short v2:1; short v3; };
struct Sf_BFu1s_Sf { empty v1; unsigned short v2:1; empty v3; };
struct Sf_BFu1s_Uc { empty v1; unsigned short v2:1; unsigned char v3; };
struct Sf_BFu1s_Ui { empty v1; unsigned short v2:1; unsigned int v3; };
struct Sf_BFu1s_Ul { empty v1; unsigned short v2:1; unsigned long long v3; };
struct Sf_BFu1s_Us { empty v1; unsigned short v2:1; unsigned short v3; };
struct Sf_BFu1s_Vp { empty v1; unsigned short v2:1; void * v3; };
struct Sf_BFu31i { empty v1; unsigned int v2:31; };
struct Sf_BFu31i_BFu15i { empty v1; unsigned int v2:31; unsigned int v3:15; };
struct Sf_BFu31i_BFu15ll { empty v1; unsigned int v2:31; unsigned long long v3:15; };
struct Sf_BFu31i_BFu15s { empty v1; unsigned int v2:31; unsigned short v3:15; };
struct Sf_BFu31i_BFu16i { empty v1; unsigned int v2:31; unsigned int v3:16; };
struct Sf_BFu31i_BFu16ll { empty v1; unsigned int v2:31; unsigned long long v3:16; };
struct Sf_BFu31i_BFu16s { empty v1; unsigned int v2:31; unsigned short v3:16; };
struct Sf_BFu31i_BFu17i { empty v1; unsigned int v2:31; unsigned int v3:17; };
struct Sf_BFu31i_BFu17ll { empty v1; unsigned int v2:31; unsigned long long v3:17; };
struct Sf_BFu31i_BFu1c { empty v1; unsigned int v2:31; unsigned char v3:1; };
struct Sf_BFu31i_BFu1i { empty v1; unsigned int v2:31; unsigned int v3:1; };
struct Sf_BFu31i_BFu1ll { empty v1; unsigned int v2:31; unsigned long long v3:1; };
struct Sf_BFu31i_BFu1s { empty v1; unsigned int v2:31; unsigned short v3:1; };
struct Sf_BFu31i_BFu31i { empty v1; unsigned int v2:31; unsigned int v3:31; };
struct Sf_BFu31i_BFu31ll { empty v1; unsigned int v2:31; unsigned long long v3:31; };
struct Sf_BFu31i_BFu32i { empty v1; unsigned int v2:31; unsigned int v3:32; };
struct Sf_BFu31i_BFu32ll { empty v1; unsigned int v2:31; unsigned long long v3:32; };
struct Sf_BFu31i_BFu33 { empty v1; unsigned int v2:31; unsigned long long v3:33; };
struct Sf_BFu31i_BFu7c { empty v1; unsigned int v2:31; unsigned char v3:7; };
struct Sf_BFu31i_BFu7i { empty v1; unsigned int v2:31; unsigned int v3:7; };
struct Sf_BFu31i_BFu7ll { empty v1; unsigned int v2:31; unsigned long long v3:7; };
struct Sf_BFu31i_BFu7s { empty v1; unsigned int v2:31; unsigned short v3:7; };
struct Sf_BFu31i_BFu8c { empty v1; unsigned int v2:31; unsigned char v3:8; };
struct Sf_BFu31i_BFu8i { empty v1; unsigned int v2:31; unsigned int v3:8; };
struct Sf_BFu31i_BFu8ll { empty v1; unsigned int v2:31; unsigned long long v3:8; };
struct Sf_BFu31i_BFu8s { empty v1; unsigned int v2:31; unsigned short v3:8; };
struct Sf_BFu31i_BFu9i { empty v1; unsigned int v2:31; unsigned int v3:9; };
struct Sf_BFu31i_BFu9ll { empty v1; unsigned int v2:31; unsigned long long v3:9; };
struct Sf_BFu31i_BFu9s { empty v1; unsigned int v2:31; unsigned short v3:9; };
struct Sf_BFu31i_C { empty v1; unsigned int v2:31; char v3; };
struct Sf_BFu31i_D { empty v1; unsigned int v2:31; double v3; };
struct Sf_BFu31i_F { empty v1; unsigned int v2:31; float v3; };
struct Sf_BFu31i_I { empty v1; unsigned int v2:31; int v3; };
struct Sf_BFu31i_Ip { empty v1; unsigned int v2:31; int * v3; };
struct Sf_BFu31i_L { empty v1; unsigned int v2:31; long long v3; };
struct Sf_BFu31i_S { empty v1; unsigned int v2:31; short v3; };
struct Sf_BFu31i_Sf { empty v1; unsigned int v2:31; empty v3; };
struct Sf_BFu31i_Uc { empty v1; unsigned int v2:31; unsigned char v3; };
struct Sf_BFu31i_Ui { empty v1; unsigned int v2:31; unsigned int v3; };
struct Sf_BFu31i_Ul { empty v1; unsigned int v2:31; unsigned long long v3; };
struct Sf_BFu31i_Us { empty v1; unsigned int v2:31; unsigned short v3; };
struct Sf_BFu31i_Vp { empty v1; unsigned int v2:31; void * v3; };
struct Sf_BFu31ll { empty v1; unsigned long long v2:31; };
struct Sf_BFu31ll_BFu15i { empty v1; unsigned long long v2:31; unsigned int v3:15; };
struct Sf_BFu31ll_BFu15ll { empty v1; unsigned long long v2:31; unsigned long long v3:15; };
struct Sf_BFu31ll_BFu15s { empty v1; unsigned long long v2:31; unsigned short v3:15; };
struct Sf_BFu31ll_BFu16i { empty v1; unsigned long long v2:31; unsigned int v3:16; };
struct Sf_BFu31ll_BFu16ll { empty v1; unsigned long long v2:31; unsigned long long v3:16; };
struct Sf_BFu31ll_BFu16s { empty v1; unsigned long long v2:31; unsigned short v3:16; };
struct Sf_BFu31ll_BFu17i { empty v1; unsigned long long v2:31; unsigned int v3:17; };
struct Sf_BFu31ll_BFu17ll { empty v1; unsigned long long v2:31; unsigned long long v3:17; };
struct Sf_BFu31ll_BFu1c { empty v1; unsigned long long v2:31; unsigned char v3:1; };
struct Sf_BFu31ll_BFu1i { empty v1; unsigned long long v2:31; unsigned int v3:1; };
struct Sf_BFu31ll_BFu1ll { empty v1; unsigned long long v2:31; unsigned long long v3:1; };
struct Sf_BFu31ll_BFu1s { empty v1; unsigned long long v2:31; unsigned short v3:1; };
struct Sf_BFu31ll_BFu31i { empty v1; unsigned long long v2:31; unsigned int v3:31; };
struct Sf_BFu31ll_BFu31ll { empty v1; unsigned long long v2:31; unsigned long long v3:31; };
struct Sf_BFu31ll_BFu32i { empty v1; unsigned long long v2:31; unsigned int v3:32; };
struct Sf_BFu31ll_BFu32ll { empty v1; unsigned long long v2:31; unsigned long long v3:32; };
struct Sf_BFu31ll_BFu33 { empty v1; unsigned long long v2:31; unsigned long long v3:33; };
struct Sf_BFu31ll_BFu7c { empty v1; unsigned long long v2:31; unsigned char v3:7; };
struct Sf_BFu31ll_BFu7i { empty v1; unsigned long long v2:31; unsigned int v3:7; };
struct Sf_BFu31ll_BFu7ll { empty v1; unsigned long long v2:31; unsigned long long v3:7; };
struct Sf_BFu31ll_BFu7s { empty v1; unsigned long long v2:31; unsigned short v3:7; };
struct Sf_BFu31ll_BFu8c { empty v1; unsigned long long v2:31; unsigned char v3:8; };
struct Sf_BFu31ll_BFu8i { empty v1; unsigned long long v2:31; unsigned int v3:8; };
struct Sf_BFu31ll_BFu8ll { empty v1; unsigned long long v2:31; unsigned long long v3:8; };
struct Sf_BFu31ll_BFu8s { empty v1; unsigned long long v2:31; unsigned short v3:8; };
struct Sf_BFu31ll_BFu9i { empty v1; unsigned long long v2:31; unsigned int v3:9; };
struct Sf_BFu31ll_BFu9ll { empty v1; unsigned long long v2:31; unsigned long long v3:9; };
struct Sf_BFu31ll_BFu9s { empty v1; unsigned long long v2:31; unsigned short v3:9; };
struct Sf_BFu31ll_C { empty v1; unsigned long long v2:31; char v3; };
struct Sf_BFu31ll_D { empty v1; unsigned long long v2:31; double v3; };
struct Sf_BFu31ll_F { empty v1; unsigned long long v2:31; float v3; };
struct Sf_BFu31ll_I { empty v1; unsigned long long v2:31; int v3; };
struct Sf_BFu31ll_Ip { empty v1; unsigned long long v2:31; int * v3; };
struct Sf_BFu31ll_L { empty v1; unsigned long long v2:31; long long v3; };
struct Sf_BFu31ll_S { empty v1; unsigned long long v2:31; short v3; };
struct Sf_BFu31ll_Sf { empty v1; unsigned long long v2:31; empty v3; };
struct Sf_BFu31ll_Uc { empty v1; unsigned long long v2:31; unsigned char v3; };
struct Sf_BFu31ll_Ui { empty v1; unsigned long long v2:31; unsigned int v3; };
struct Sf_BFu31ll_Ul { empty v1; unsigned long long v2:31; unsigned long long v3; };
struct Sf_BFu31ll_Us { empty v1; unsigned long long v2:31; unsigned short v3; };
struct Sf_BFu31ll_Vp { empty v1; unsigned long long v2:31; void * v3; };
struct Sf_BFu32i { empty v1; unsigned int v2:32; };
struct Sf_BFu32i_BFu15i { empty v1; unsigned int v2:32; unsigned int v3:15; };
struct Sf_BFu32i_BFu15ll { empty v1; unsigned int v2:32; unsigned long long v3:15; };
struct Sf_BFu32i_BFu15s { empty v1; unsigned int v2:32; unsigned short v3:15; };
struct Sf_BFu32i_BFu16i { empty v1; unsigned int v2:32; unsigned int v3:16; };
struct Sf_BFu32i_BFu16ll { empty v1; unsigned int v2:32; unsigned long long v3:16; };
struct Sf_BFu32i_BFu16s { empty v1; unsigned int v2:32; unsigned short v3:16; };
struct Sf_BFu32i_BFu17i { empty v1; unsigned int v2:32; unsigned int v3:17; };
struct Sf_BFu32i_BFu17ll { empty v1; unsigned int v2:32; unsigned long long v3:17; };
struct Sf_BFu32i_BFu1c { empty v1; unsigned int v2:32; unsigned char v3:1; };
struct Sf_BFu32i_BFu1i { empty v1; unsigned int v2:32; unsigned int v3:1; };
struct Sf_BFu32i_BFu1ll { empty v1; unsigned int v2:32; unsigned long long v3:1; };
struct Sf_BFu32i_BFu1s { empty v1; unsigned int v2:32; unsigned short v3:1; };
struct Sf_BFu32i_BFu31i { empty v1; unsigned int v2:32; unsigned int v3:31; };
struct Sf_BFu32i_BFu31ll { empty v1; unsigned int v2:32; unsigned long long v3:31; };
struct Sf_BFu32i_BFu32i { empty v1; unsigned int v2:32; unsigned int v3:32; };
struct Sf_BFu32i_BFu32ll { empty v1; unsigned int v2:32; unsigned long long v3:32; };
struct Sf_BFu32i_BFu33 { empty v1; unsigned int v2:32; unsigned long long v3:33; };
struct Sf_BFu32i_BFu7c { empty v1; unsigned int v2:32; unsigned char v3:7; };
struct Sf_BFu32i_BFu7i { empty v1; unsigned int v2:32; unsigned int v3:7; };
struct Sf_BFu32i_BFu7ll { empty v1; unsigned int v2:32; unsigned long long v3:7; };
struct Sf_BFu32i_BFu7s { empty v1; unsigned int v2:32; unsigned short v3:7; };
struct Sf_BFu32i_BFu8c { empty v1; unsigned int v2:32; unsigned char v3:8; };
struct Sf_BFu32i_BFu8i { empty v1; unsigned int v2:32; unsigned int v3:8; };
struct Sf_BFu32i_BFu8ll { empty v1; unsigned int v2:32; unsigned long long v3:8; };
struct Sf_BFu32i_BFu8s { empty v1; unsigned int v2:32; unsigned short v3:8; };
struct Sf_BFu32i_BFu9i { empty v1; unsigned int v2:32; unsigned int v3:9; };
struct Sf_BFu32i_BFu9ll { empty v1; unsigned int v2:32; unsigned long long v3:9; };
struct Sf_BFu32i_BFu9s { empty v1; unsigned int v2:32; unsigned short v3:9; };
struct Sf_BFu32i_C { empty v1; unsigned int v2:32; char v3; };
struct Sf_BFu32i_D { empty v1; unsigned int v2:32; double v3; };
struct Sf_BFu32i_F { empty v1; unsigned int v2:32; float v3; };
struct Sf_BFu32i_I { empty v1; unsigned int v2:32; int v3; };
struct Sf_BFu32i_Ip { empty v1; unsigned int v2:32; int * v3; };
struct Sf_BFu32i_L { empty v1; unsigned int v2:32; long long v3; };
struct Sf_BFu32i_S { empty v1; unsigned int v2:32; short v3; };
struct Sf_BFu32i_Sf { empty v1; unsigned int v2:32; empty v3; };
struct Sf_BFu32i_Uc { empty v1; unsigned int v2:32; unsigned char v3; };
struct Sf_BFu32i_Ui { empty v1; unsigned int v2:32; unsigned int v3; };
struct Sf_BFu32i_Ul { empty v1; unsigned int v2:32; unsigned long long v3; };
struct Sf_BFu32i_Us { empty v1; unsigned int v2:32; unsigned short v3; };
struct Sf_BFu32i_Vp { empty v1; unsigned int v2:32; void * v3; };
struct Sf_BFu32ll { empty v1; unsigned long long v2:32; };
struct Sf_BFu32ll_BFu15i { empty v1; unsigned long long v2:32; unsigned int v3:15; };
struct Sf_BFu32ll_BFu15ll { empty v1; unsigned long long v2:32; unsigned long long v3:15; };
struct Sf_BFu32ll_BFu15s { empty v1; unsigned long long v2:32; unsigned short v3:15; };
struct Sf_BFu32ll_BFu16i { empty v1; unsigned long long v2:32; unsigned int v3:16; };
struct Sf_BFu32ll_BFu16ll { empty v1; unsigned long long v2:32; unsigned long long v3:16; };
struct Sf_BFu32ll_BFu16s { empty v1; unsigned long long v2:32; unsigned short v3:16; };
struct Sf_BFu32ll_BFu17i { empty v1; unsigned long long v2:32; unsigned int v3:17; };
struct Sf_BFu32ll_BFu17ll { empty v1; unsigned long long v2:32; unsigned long long v3:17; };
struct Sf_BFu32ll_BFu1c { empty v1; unsigned long long v2:32; unsigned char v3:1; };
struct Sf_BFu32ll_BFu1i { empty v1; unsigned long long v2:32; unsigned int v3:1; };
struct Sf_BFu32ll_BFu1ll { empty v1; unsigned long long v2:32; unsigned long long v3:1; };
struct Sf_BFu32ll_BFu1s { empty v1; unsigned long long v2:32; unsigned short v3:1; };
struct Sf_BFu32ll_BFu31i { empty v1; unsigned long long v2:32; unsigned int v3:31; };
struct Sf_BFu32ll_BFu31ll { empty v1; unsigned long long v2:32; unsigned long long v3:31; };
struct Sf_BFu32ll_BFu32i { empty v1; unsigned long long v2:32; unsigned int v3:32; };
struct Sf_BFu32ll_BFu32ll { empty v1; unsigned long long v2:32; unsigned long long v3:32; };
struct Sf_BFu32ll_BFu33 { empty v1; unsigned long long v2:32; unsigned long long v3:33; };
struct Sf_BFu32ll_BFu7c { empty v1; unsigned long long v2:32; unsigned char v3:7; };
struct Sf_BFu32ll_BFu7i { empty v1; unsigned long long v2:32; unsigned int v3:7; };
struct Sf_BFu32ll_BFu7ll { empty v1; unsigned long long v2:32; unsigned long long v3:7; };
struct Sf_BFu32ll_BFu7s { empty v1; unsigned long long v2:32; unsigned short v3:7; };
struct Sf_BFu32ll_BFu8c { empty v1; unsigned long long v2:32; unsigned char v3:8; };
struct Sf_BFu32ll_BFu8i { empty v1; unsigned long long v2:32; unsigned int v3:8; };
struct Sf_BFu32ll_BFu8ll { empty v1; unsigned long long v2:32; unsigned long long v3:8; };
struct Sf_BFu32ll_BFu8s { empty v1; unsigned long long v2:32; unsigned short v3:8; };
struct Sf_BFu32ll_BFu9i { empty v1; unsigned long long v2:32; unsigned int v3:9; };
struct Sf_BFu32ll_BFu9ll { empty v1; unsigned long long v2:32; unsigned long long v3:9; };
struct Sf_BFu32ll_BFu9s { empty v1; unsigned long long v2:32; unsigned short v3:9; };
struct Sf_BFu32ll_C { empty v1; unsigned long long v2:32; char v3; };
struct Sf_BFu32ll_D { empty v1; unsigned long long v2:32; double v3; };
struct Sf_BFu32ll_F { empty v1; unsigned long long v2:32; float v3; };
struct Sf_BFu32ll_I { empty v1; unsigned long long v2:32; int v3; };
struct Sf_BFu32ll_Ip { empty v1; unsigned long long v2:32; int * v3; };
struct Sf_BFu32ll_L { empty v1; unsigned long long v2:32; long long v3; };
struct Sf_BFu32ll_S { empty v1; unsigned long long v2:32; short v3; };
struct Sf_BFu32ll_Sf { empty v1; unsigned long long v2:32; empty v3; };
struct Sf_BFu32ll_Uc { empty v1; unsigned long long v2:32; unsigned char v3; };
struct Sf_BFu32ll_Ui { empty v1; unsigned long long v2:32; unsigned int v3; };
struct Sf_BFu32ll_Ul { empty v1; unsigned long long v2:32; unsigned long long v3; };
struct Sf_BFu32ll_Us { empty v1; unsigned long long v2:32; unsigned short v3; };
struct Sf_BFu32ll_Vp { empty v1; unsigned long long v2:32; void * v3; };
struct Sf_BFu33 { empty v1; unsigned long long v2:33; };
struct Sf_BFu33_BFu15i { empty v1; unsigned long long v2:33; unsigned int v3:15; };
struct Sf_BFu33_BFu15ll { empty v1; unsigned long long v2:33; unsigned long long v3:15; };
struct Sf_BFu33_BFu15s { empty v1; unsigned long long v2:33; unsigned short v3:15; };
struct Sf_BFu33_BFu16i { empty v1; unsigned long long v2:33; unsigned int v3:16; };
struct Sf_BFu33_BFu16ll { empty v1; unsigned long long v2:33; unsigned long long v3:16; };
struct Sf_BFu33_BFu16s { empty v1; unsigned long long v2:33; unsigned short v3:16; };
struct Sf_BFu33_BFu17i { empty v1; unsigned long long v2:33; unsigned int v3:17; };
struct Sf_BFu33_BFu17ll { empty v1; unsigned long long v2:33; unsigned long long v3:17; };
struct Sf_BFu33_BFu1c { empty v1; unsigned long long v2:33; unsigned char v3:1; };
struct Sf_BFu33_BFu1i { empty v1; unsigned long long v2:33; unsigned int v3:1; };
struct Sf_BFu33_BFu1ll { empty v1; unsigned long long v2:33; unsigned long long v3:1; };
struct Sf_BFu33_BFu1s { empty v1; unsigned long long v2:33; unsigned short v3:1; };
struct Sf_BFu33_BFu31i { empty v1; unsigned long long v2:33; unsigned int v3:31; };
struct Sf_BFu33_BFu31ll { empty v1; unsigned long long v2:33; unsigned long long v3:31; };
struct Sf_BFu33_BFu32i { empty v1; unsigned long long v2:33; unsigned int v3:32; };
struct Sf_BFu33_BFu32ll { empty v1; unsigned long long v2:33; unsigned long long v3:32; };
struct Sf_BFu33_BFu33 { empty v1; unsigned long long v2:33; unsigned long long v3:33; };
struct Sf_BFu33_BFu7c { empty v1; unsigned long long v2:33; unsigned char v3:7; };
struct Sf_BFu33_BFu7i { empty v1; unsigned long long v2:33; unsigned int v3:7; };
struct Sf_BFu33_BFu7ll { empty v1; unsigned long long v2:33; unsigned long long v3:7; };
struct Sf_BFu33_BFu7s { empty v1; unsigned long long v2:33; unsigned short v3:7; };
struct Sf_BFu33_BFu8c { empty v1; unsigned long long v2:33; unsigned char v3:8; };
struct Sf_BFu33_BFu8i { empty v1; unsigned long long v2:33; unsigned int v3:8; };
struct Sf_BFu33_BFu8ll { empty v1; unsigned long long v2:33; unsigned long long v3:8; };
struct Sf_BFu33_BFu8s { empty v1; unsigned long long v2:33; unsigned short v3:8; };
struct Sf_BFu33_BFu9i { empty v1; unsigned long long v2:33; unsigned int v3:9; };
struct Sf_BFu33_BFu9ll { empty v1; unsigned long long v2:33; unsigned long long v3:9; };
struct Sf_BFu33_BFu9s { empty v1; unsigned long long v2:33; unsigned short v3:9; };
struct Sf_BFu33_C { empty v1; unsigned long long v2:33; char v3; };
struct Sf_BFu33_D { empty v1; unsigned long long v2:33; double v3; };
struct Sf_BFu33_F { empty v1; unsigned long long v2:33; float v3; };
struct Sf_BFu33_I { empty v1; unsigned long long v2:33; int v3; };
struct Sf_BFu33_Ip { empty v1; unsigned long long v2:33; int * v3; };
struct Sf_BFu33_L { empty v1; unsigned long long v2:33; long long v3; };
struct Sf_BFu33_S { empty v1; unsigned long long v2:33; short v3; };
struct Sf_BFu33_Sf { empty v1; unsigned long long v2:33; empty v3; };
struct Sf_BFu33_Uc { empty v1; unsigned long long v2:33; unsigned char v3; };
struct Sf_BFu33_Ui { empty v1; unsigned long long v2:33; unsigned int v3; };
struct Sf_BFu33_Ul { empty v1; unsigned long long v2:33; unsigned long long v3; };
struct Sf_BFu33_Us { empty v1; unsigned long long v2:33; unsigned short v3; };
struct Sf_BFu33_Vp { empty v1; unsigned long long v2:33; void * v3; };
struct Sf_BFu7c { empty v1; unsigned char v2:7; };
struct Sf_BFu7c_BFu15i { empty v1; unsigned char v2:7; unsigned int v3:15; };
struct Sf_BFu7c_BFu15ll { empty v1; unsigned char v2:7; unsigned long long v3:15; };
struct Sf_BFu7c_BFu15s { empty v1; unsigned char v2:7; unsigned short v3:15; };
struct Sf_BFu7c_BFu16i { empty v1; unsigned char v2:7; unsigned int v3:16; };
struct Sf_BFu7c_BFu16ll { empty v1; unsigned char v2:7; unsigned long long v3:16; };
struct Sf_BFu7c_BFu16s { empty v1; unsigned char v2:7; unsigned short v3:16; };
struct Sf_BFu7c_BFu17i { empty v1; unsigned char v2:7; unsigned int v3:17; };
struct Sf_BFu7c_BFu17ll { empty v1; unsigned char v2:7; unsigned long long v3:17; };
struct Sf_BFu7c_BFu1c { empty v1; unsigned char v2:7; unsigned char v3:1; };
struct Sf_BFu7c_BFu1i { empty v1; unsigned char v2:7; unsigned int v3:1; };
struct Sf_BFu7c_BFu1ll { empty v1; unsigned char v2:7; unsigned long long v3:1; };
struct Sf_BFu7c_BFu1s { empty v1; unsigned char v2:7; unsigned short v3:1; };
struct Sf_BFu7c_BFu31i { empty v1; unsigned char v2:7; unsigned int v3:31; };
struct Sf_BFu7c_BFu31ll { empty v1; unsigned char v2:7; unsigned long long v3:31; };
struct Sf_BFu7c_BFu32i { empty v1; unsigned char v2:7; unsigned int v3:32; };
struct Sf_BFu7c_BFu32ll { empty v1; unsigned char v2:7; unsigned long long v3:32; };
struct Sf_BFu7c_BFu33 { empty v1; unsigned char v2:7; unsigned long long v3:33; };
struct Sf_BFu7c_BFu7c { empty v1; unsigned char v2:7; unsigned char v3:7; };
struct Sf_BFu7c_BFu7i { empty v1; unsigned char v2:7; unsigned int v3:7; };
struct Sf_BFu7c_BFu7ll { empty v1; unsigned char v2:7; unsigned long long v3:7; };
struct Sf_BFu7c_BFu7s { empty v1; unsigned char v2:7; unsigned short v3:7; };
struct Sf_BFu7c_BFu8c { empty v1; unsigned char v2:7; unsigned char v3:8; };
struct Sf_BFu7c_BFu8i { empty v1; unsigned char v2:7; unsigned int v3:8; };
struct Sf_BFu7c_BFu8ll { empty v1; unsigned char v2:7; unsigned long long v3:8; };
struct Sf_BFu7c_BFu8s { empty v1; unsigned char v2:7; unsigned short v3:8; };
struct Sf_BFu7c_BFu9i { empty v1; unsigned char v2:7; unsigned int v3:9; };
struct Sf_BFu7c_BFu9ll { empty v1; unsigned char v2:7; unsigned long long v3:9; };
struct Sf_BFu7c_BFu9s { empty v1; unsigned char v2:7; unsigned short v3:9; };
struct Sf_BFu7c_C { empty v1; unsigned char v2:7; char v3; };
struct Sf_BFu7c_D { empty v1; unsigned char v2:7; double v3; };
struct Sf_BFu7c_F { empty v1; unsigned char v2:7; float v3; };
struct Sf_BFu7c_I { empty v1; unsigned char v2:7; int v3; };
struct Sf_BFu7c_Ip { empty v1; unsigned char v2:7; int * v3; };
struct Sf_BFu7c_L { empty v1; unsigned char v2:7; long long v3; };
struct Sf_BFu7c_S { empty v1; unsigned char v2:7; short v3; };
struct Sf_BFu7c_Sf { empty v1; unsigned char v2:7; empty v3; };
struct Sf_BFu7c_Uc { empty v1; unsigned char v2:7; unsigned char v3; };
struct Sf_BFu7c_Ui { empty v1; unsigned char v2:7; unsigned int v3; };
struct Sf_BFu7c_Ul { empty v1; unsigned char v2:7; unsigned long long v3; };
struct Sf_BFu7c_Us { empty v1; unsigned char v2:7; unsigned short v3; };
struct Sf_BFu7c_Vp { empty v1; unsigned char v2:7; void * v3; };
struct Sf_BFu7i { empty v1; unsigned int v2:7; };
struct Sf_BFu7i_BFu15i { empty v1; unsigned int v2:7; unsigned int v3:15; };
struct Sf_BFu7i_BFu15ll { empty v1; unsigned int v2:7; unsigned long long v3:15; };
struct Sf_BFu7i_BFu15s { empty v1; unsigned int v2:7; unsigned short v3:15; };
struct Sf_BFu7i_BFu16i { empty v1; unsigned int v2:7; unsigned int v3:16; };
struct Sf_BFu7i_BFu16ll { empty v1; unsigned int v2:7; unsigned long long v3:16; };
struct Sf_BFu7i_BFu16s { empty v1; unsigned int v2:7; unsigned short v3:16; };
struct Sf_BFu7i_BFu17i { empty v1; unsigned int v2:7; unsigned int v3:17; };
struct Sf_BFu7i_BFu17ll { empty v1; unsigned int v2:7; unsigned long long v3:17; };
struct Sf_BFu7i_BFu1c { empty v1; unsigned int v2:7; unsigned char v3:1; };
struct Sf_BFu7i_BFu1i { empty v1; unsigned int v2:7; unsigned int v3:1; };
struct Sf_BFu7i_BFu1ll { empty v1; unsigned int v2:7; unsigned long long v3:1; };
struct Sf_BFu7i_BFu1s { empty v1; unsigned int v2:7; unsigned short v3:1; };
struct Sf_BFu7i_BFu31i { empty v1; unsigned int v2:7; unsigned int v3:31; };
struct Sf_BFu7i_BFu31ll { empty v1; unsigned int v2:7; unsigned long long v3:31; };
struct Sf_BFu7i_BFu32i { empty v1; unsigned int v2:7; unsigned int v3:32; };
struct Sf_BFu7i_BFu32ll { empty v1; unsigned int v2:7; unsigned long long v3:32; };
struct Sf_BFu7i_BFu33 { empty v1; unsigned int v2:7; unsigned long long v3:33; };
struct Sf_BFu7i_BFu7c { empty v1; unsigned int v2:7; unsigned char v3:7; };
struct Sf_BFu7i_BFu7i { empty v1; unsigned int v2:7; unsigned int v3:7; };
struct Sf_BFu7i_BFu7ll { empty v1; unsigned int v2:7; unsigned long long v3:7; };
struct Sf_BFu7i_BFu7s { empty v1; unsigned int v2:7; unsigned short v3:7; };
struct Sf_BFu7i_BFu8c { empty v1; unsigned int v2:7; unsigned char v3:8; };
struct Sf_BFu7i_BFu8i { empty v1; unsigned int v2:7; unsigned int v3:8; };
struct Sf_BFu7i_BFu8ll { empty v1; unsigned int v2:7; unsigned long long v3:8; };
struct Sf_BFu7i_BFu8s { empty v1; unsigned int v2:7; unsigned short v3:8; };
struct Sf_BFu7i_BFu9i { empty v1; unsigned int v2:7; unsigned int v3:9; };
struct Sf_BFu7i_BFu9ll { empty v1; unsigned int v2:7; unsigned long long v3:9; };
struct Sf_BFu7i_BFu9s { empty v1; unsigned int v2:7; unsigned short v3:9; };
struct Sf_BFu7i_C { empty v1; unsigned int v2:7; char v3; };
struct Sf_BFu7i_D { empty v1; unsigned int v2:7; double v3; };
struct Sf_BFu7i_F { empty v1; unsigned int v2:7; float v3; };
struct Sf_BFu7i_I { empty v1; unsigned int v2:7; int v3; };
struct Sf_BFu7i_Ip { empty v1; unsigned int v2:7; int * v3; };
struct Sf_BFu7i_L { empty v1; unsigned int v2:7; long long v3; };
struct Sf_BFu7i_S { empty v1; unsigned int v2:7; short v3; };
struct Sf_BFu7i_Sf { empty v1; unsigned int v2:7; empty v3; };
struct Sf_BFu7i_Uc { empty v1; unsigned int v2:7; unsigned char v3; };
struct Sf_BFu7i_Ui { empty v1; unsigned int v2:7; unsigned int v3; };
struct Sf_BFu7i_Ul { empty v1; unsigned int v2:7; unsigned long long v3; };
struct Sf_BFu7i_Us { empty v1; unsigned int v2:7; unsigned short v3; };
struct Sf_BFu7i_Vp { empty v1; unsigned int v2:7; void * v3; };
struct Sf_BFu7ll { empty v1; unsigned long long v2:7; };
struct Sf_BFu7ll_BFu15i { empty v1; unsigned long long v2:7; unsigned int v3:15; };
struct Sf_BFu7ll_BFu15ll { empty v1; unsigned long long v2:7; unsigned long long v3:15; };
struct Sf_BFu7ll_BFu15s { empty v1; unsigned long long v2:7; unsigned short v3:15; };
struct Sf_BFu7ll_BFu16i { empty v1; unsigned long long v2:7; unsigned int v3:16; };
struct Sf_BFu7ll_BFu16ll { empty v1; unsigned long long v2:7; unsigned long long v3:16; };
struct Sf_BFu7ll_BFu16s { empty v1; unsigned long long v2:7; unsigned short v3:16; };
struct Sf_BFu7ll_BFu17i { empty v1; unsigned long long v2:7; unsigned int v3:17; };
struct Sf_BFu7ll_BFu17ll { empty v1; unsigned long long v2:7; unsigned long long v3:17; };
struct Sf_BFu7ll_BFu1c { empty v1; unsigned long long v2:7; unsigned char v3:1; };
struct Sf_BFu7ll_BFu1i { empty v1; unsigned long long v2:7; unsigned int v3:1; };
struct Sf_BFu7ll_BFu1ll { empty v1; unsigned long long v2:7; unsigned long long v3:1; };
struct Sf_BFu7ll_BFu1s { empty v1; unsigned long long v2:7; unsigned short v3:1; };
struct Sf_BFu7ll_BFu31i { empty v1; unsigned long long v2:7; unsigned int v3:31; };
struct Sf_BFu7ll_BFu31ll { empty v1; unsigned long long v2:7; unsigned long long v3:31; };
struct Sf_BFu7ll_BFu32i { empty v1; unsigned long long v2:7; unsigned int v3:32; };
struct Sf_BFu7ll_BFu32ll { empty v1; unsigned long long v2:7; unsigned long long v3:32; };
struct Sf_BFu7ll_BFu33 { empty v1; unsigned long long v2:7; unsigned long long v3:33; };
struct Sf_BFu7ll_BFu7c { empty v1; unsigned long long v2:7; unsigned char v3:7; };
struct Sf_BFu7ll_BFu7i { empty v1; unsigned long long v2:7; unsigned int v3:7; };
struct Sf_BFu7ll_BFu7ll { empty v1; unsigned long long v2:7; unsigned long long v3:7; };
struct Sf_BFu7ll_BFu7s { empty v1; unsigned long long v2:7; unsigned short v3:7; };
struct Sf_BFu7ll_BFu8c { empty v1; unsigned long long v2:7; unsigned char v3:8; };
struct Sf_BFu7ll_BFu8i { empty v1; unsigned long long v2:7; unsigned int v3:8; };
struct Sf_BFu7ll_BFu8ll { empty v1; unsigned long long v2:7; unsigned long long v3:8; };
struct Sf_BFu7ll_BFu8s { empty v1; unsigned long long v2:7; unsigned short v3:8; };
struct Sf_BFu7ll_BFu9i { empty v1; unsigned long long v2:7; unsigned int v3:9; };
struct Sf_BFu7ll_BFu9ll { empty v1; unsigned long long v2:7; unsigned long long v3:9; };
struct Sf_BFu7ll_BFu9s { empty v1; unsigned long long v2:7; unsigned short v3:9; };
struct Sf_BFu7ll_C { empty v1; unsigned long long v2:7; char v3; };
struct Sf_BFu7ll_D { empty v1; unsigned long long v2:7; double v3; };
struct Sf_BFu7ll_F { empty v1; unsigned long long v2:7; float v3; };
struct Sf_BFu7ll_I { empty v1; unsigned long long v2:7; int v3; };
struct Sf_BFu7ll_Ip { empty v1; unsigned long long v2:7; int * v3; };
struct Sf_BFu7ll_L { empty v1; unsigned long long v2:7; long long v3; };
struct Sf_BFu7ll_S { empty v1; unsigned long long v2:7; short v3; };
struct Sf_BFu7ll_Sf { empty v1; unsigned long long v2:7; empty v3; };
struct Sf_BFu7ll_Uc { empty v1; unsigned long long v2:7; unsigned char v3; };
struct Sf_BFu7ll_Ui { empty v1; unsigned long long v2:7; unsigned int v3; };
struct Sf_BFu7ll_Ul { empty v1; unsigned long long v2:7; unsigned long long v3; };
struct Sf_BFu7ll_Us { empty v1; unsigned long long v2:7; unsigned short v3; };
struct Sf_BFu7ll_Vp { empty v1; unsigned long long v2:7; void * v3; };
struct Sf_BFu7s { empty v1; unsigned short v2:7; };
struct Sf_BFu7s_BFu15i { empty v1; unsigned short v2:7; unsigned int v3:15; };
struct Sf_BFu7s_BFu15ll { empty v1; unsigned short v2:7; unsigned long long v3:15; };
struct Sf_BFu7s_BFu15s { empty v1; unsigned short v2:7; unsigned short v3:15; };
struct Sf_BFu7s_BFu16i { empty v1; unsigned short v2:7; unsigned int v3:16; };
struct Sf_BFu7s_BFu16ll { empty v1; unsigned short v2:7; unsigned long long v3:16; };
struct Sf_BFu7s_BFu16s { empty v1; unsigned short v2:7; unsigned short v3:16; };
struct Sf_BFu7s_BFu17i { empty v1; unsigned short v2:7; unsigned int v3:17; };
struct Sf_BFu7s_BFu17ll { empty v1; unsigned short v2:7; unsigned long long v3:17; };
struct Sf_BFu7s_BFu1c { empty v1; unsigned short v2:7; unsigned char v3:1; };
struct Sf_BFu7s_BFu1i { empty v1; unsigned short v2:7; unsigned int v3:1; };
struct Sf_BFu7s_BFu1ll { empty v1; unsigned short v2:7; unsigned long long v3:1; };
struct Sf_BFu7s_BFu1s { empty v1; unsigned short v2:7; unsigned short v3:1; };
struct Sf_BFu7s_BFu31i { empty v1; unsigned short v2:7; unsigned int v3:31; };
struct Sf_BFu7s_BFu31ll { empty v1; unsigned short v2:7; unsigned long long v3:31; };
struct Sf_BFu7s_BFu32i { empty v1; unsigned short v2:7; unsigned int v3:32; };
struct Sf_BFu7s_BFu32ll { empty v1; unsigned short v2:7; unsigned long long v3:32; };
struct Sf_BFu7s_BFu33 { empty v1; unsigned short v2:7; unsigned long long v3:33; };
struct Sf_BFu7s_BFu7c { empty v1; unsigned short v2:7; unsigned char v3:7; };
struct Sf_BFu7s_BFu7i { empty v1; unsigned short v2:7; unsigned int v3:7; };
struct Sf_BFu7s_BFu7ll { empty v1; unsigned short v2:7; unsigned long long v3:7; };
struct Sf_BFu7s_BFu7s { empty v1; unsigned short v2:7; unsigned short v3:7; };
struct Sf_BFu7s_BFu8c { empty v1; unsigned short v2:7; unsigned char v3:8; };
struct Sf_BFu7s_BFu8i { empty v1; unsigned short v2:7; unsigned int v3:8; };
struct Sf_BFu7s_BFu8ll { empty v1; unsigned short v2:7; unsigned long long v3:8; };
struct Sf_BFu7s_BFu8s { empty v1; unsigned short v2:7; unsigned short v3:8; };
struct Sf_BFu7s_BFu9i { empty v1; unsigned short v2:7; unsigned int v3:9; };
struct Sf_BFu7s_BFu9ll { empty v1; unsigned short v2:7; unsigned long long v3:9; };
struct Sf_BFu7s_BFu9s { empty v1; unsigned short v2:7; unsigned short v3:9; };
struct Sf_BFu7s_C { empty v1; unsigned short v2:7; char v3; };
struct Sf_BFu7s_D { empty v1; unsigned short v2:7; double v3; };
struct Sf_BFu7s_F { empty v1; unsigned short v2:7; float v3; };
struct Sf_BFu7s_I { empty v1; unsigned short v2:7; int v3; };
struct Sf_BFu7s_Ip { empty v1; unsigned short v2:7; int * v3; };
struct Sf_BFu7s_L { empty v1; unsigned short v2:7; long long v3; };
struct Sf_BFu7s_S { empty v1; unsigned short v2:7; short v3; };
struct Sf_BFu7s_Sf { empty v1; unsigned short v2:7; empty v3; };
struct Sf_BFu7s_Uc { empty v1; unsigned short v2:7; unsigned char v3; };
struct Sf_BFu7s_Ui { empty v1; unsigned short v2:7; unsigned int v3; };
struct Sf_BFu7s_Ul { empty v1; unsigned short v2:7; unsigned long long v3; };
struct Sf_BFu7s_Us { empty v1; unsigned short v2:7; unsigned short v3; };
struct Sf_BFu7s_Vp { empty v1; unsigned short v2:7; void * v3; };
struct Sf_BFu8c { empty v1; unsigned char v2:8; };
struct Sf_BFu8c_BFu15i { empty v1; unsigned char v2:8; unsigned int v3:15; };
struct Sf_BFu8c_BFu15ll { empty v1; unsigned char v2:8; unsigned long long v3:15; };
struct Sf_BFu8c_BFu15s { empty v1; unsigned char v2:8; unsigned short v3:15; };
struct Sf_BFu8c_BFu16i { empty v1; unsigned char v2:8; unsigned int v3:16; };
struct Sf_BFu8c_BFu16ll { empty v1; unsigned char v2:8; unsigned long long v3:16; };
struct Sf_BFu8c_BFu16s { empty v1; unsigned char v2:8; unsigned short v3:16; };
struct Sf_BFu8c_BFu17i { empty v1; unsigned char v2:8; unsigned int v3:17; };
struct Sf_BFu8c_BFu17ll { empty v1; unsigned char v2:8; unsigned long long v3:17; };
struct Sf_BFu8c_BFu1c { empty v1; unsigned char v2:8; unsigned char v3:1; };
struct Sf_BFu8c_BFu1i { empty v1; unsigned char v2:8; unsigned int v3:1; };
struct Sf_BFu8c_BFu1ll { empty v1; unsigned char v2:8; unsigned long long v3:1; };
struct Sf_BFu8c_BFu1s { empty v1; unsigned char v2:8; unsigned short v3:1; };
struct Sf_BFu8c_BFu31i { empty v1; unsigned char v2:8; unsigned int v3:31; };
struct Sf_BFu8c_BFu31ll { empty v1; unsigned char v2:8; unsigned long long v3:31; };
struct Sf_BFu8c_BFu32i { empty v1; unsigned char v2:8; unsigned int v3:32; };
struct Sf_BFu8c_BFu32ll { empty v1; unsigned char v2:8; unsigned long long v3:32; };
struct Sf_BFu8c_BFu33 { empty v1; unsigned char v2:8; unsigned long long v3:33; };
struct Sf_BFu8c_BFu7c { empty v1; unsigned char v2:8; unsigned char v3:7; };
struct Sf_BFu8c_BFu7i { empty v1; unsigned char v2:8; unsigned int v3:7; };
struct Sf_BFu8c_BFu7ll { empty v1; unsigned char v2:8; unsigned long long v3:7; };
struct Sf_BFu8c_BFu7s { empty v1; unsigned char v2:8; unsigned short v3:7; };
struct Sf_BFu8c_BFu8c { empty v1; unsigned char v2:8; unsigned char v3:8; };
struct Sf_BFu8c_BFu8i { empty v1; unsigned char v2:8; unsigned int v3:8; };
struct Sf_BFu8c_BFu8ll { empty v1; unsigned char v2:8; unsigned long long v3:8; };
struct Sf_BFu8c_BFu8s { empty v1; unsigned char v2:8; unsigned short v3:8; };
struct Sf_BFu8c_BFu9i { empty v1; unsigned char v2:8; unsigned int v3:9; };
struct Sf_BFu8c_BFu9ll { empty v1; unsigned char v2:8; unsigned long long v3:9; };
struct Sf_BFu8c_BFu9s { empty v1; unsigned char v2:8; unsigned short v3:9; };
struct Sf_BFu8c_C { empty v1; unsigned char v2:8; char v3; };
struct Sf_BFu8c_D { empty v1; unsigned char v2:8; double v3; };
struct Sf_BFu8c_F { empty v1; unsigned char v2:8; float v3; };
struct Sf_BFu8c_I { empty v1; unsigned char v2:8; int v3; };
struct Sf_BFu8c_Ip { empty v1; unsigned char v2:8; int * v3; };
struct Sf_BFu8c_L { empty v1; unsigned char v2:8; long long v3; };
struct Sf_BFu8c_S { empty v1; unsigned char v2:8; short v3; };
struct Sf_BFu8c_Sf { empty v1; unsigned char v2:8; empty v3; };
struct Sf_BFu8c_Uc { empty v1; unsigned char v2:8; unsigned char v3; };
struct Sf_BFu8c_Ui { empty v1; unsigned char v2:8; unsigned int v3; };
struct Sf_BFu8c_Ul { empty v1; unsigned char v2:8; unsigned long long v3; };
struct Sf_BFu8c_Us { empty v1; unsigned char v2:8; unsigned short v3; };
struct Sf_BFu8c_Vp { empty v1; unsigned char v2:8; void * v3; };
struct Sf_BFu8i { empty v1; unsigned int v2:8; };
struct Sf_BFu8i_BFu15i { empty v1; unsigned int v2:8; unsigned int v3:15; };
struct Sf_BFu8i_BFu15ll { empty v1; unsigned int v2:8; unsigned long long v3:15; };
struct Sf_BFu8i_BFu15s { empty v1; unsigned int v2:8; unsigned short v3:15; };
struct Sf_BFu8i_BFu16i { empty v1; unsigned int v2:8; unsigned int v3:16; };
struct Sf_BFu8i_BFu16ll { empty v1; unsigned int v2:8; unsigned long long v3:16; };
struct Sf_BFu8i_BFu16s { empty v1; unsigned int v2:8; unsigned short v3:16; };
struct Sf_BFu8i_BFu17i { empty v1; unsigned int v2:8; unsigned int v3:17; };
struct Sf_BFu8i_BFu17ll { empty v1; unsigned int v2:8; unsigned long long v3:17; };
struct Sf_BFu8i_BFu1c { empty v1; unsigned int v2:8; unsigned char v3:1; };
struct Sf_BFu8i_BFu1i { empty v1; unsigned int v2:8; unsigned int v3:1; };
struct Sf_BFu8i_BFu1ll { empty v1; unsigned int v2:8; unsigned long long v3:1; };
struct Sf_BFu8i_BFu1s { empty v1; unsigned int v2:8; unsigned short v3:1; };
struct Sf_BFu8i_BFu31i { empty v1; unsigned int v2:8; unsigned int v3:31; };
struct Sf_BFu8i_BFu31ll { empty v1; unsigned int v2:8; unsigned long long v3:31; };
struct Sf_BFu8i_BFu32i { empty v1; unsigned int v2:8; unsigned int v3:32; };
struct Sf_BFu8i_BFu32ll { empty v1; unsigned int v2:8; unsigned long long v3:32; };
struct Sf_BFu8i_BFu33 { empty v1; unsigned int v2:8; unsigned long long v3:33; };
struct Sf_BFu8i_BFu7c { empty v1; unsigned int v2:8; unsigned char v3:7; };
struct Sf_BFu8i_BFu7i { empty v1; unsigned int v2:8; unsigned int v3:7; };
struct Sf_BFu8i_BFu7ll { empty v1; unsigned int v2:8; unsigned long long v3:7; };
struct Sf_BFu8i_BFu7s { empty v1; unsigned int v2:8; unsigned short v3:7; };
struct Sf_BFu8i_BFu8c { empty v1; unsigned int v2:8; unsigned char v3:8; };
struct Sf_BFu8i_BFu8i { empty v1; unsigned int v2:8; unsigned int v3:8; };
struct Sf_BFu8i_BFu8ll { empty v1; unsigned int v2:8; unsigned long long v3:8; };
struct Sf_BFu8i_BFu8s { empty v1; unsigned int v2:8; unsigned short v3:8; };
struct Sf_BFu8i_BFu9i { empty v1; unsigned int v2:8; unsigned int v3:9; };
struct Sf_BFu8i_BFu9ll { empty v1; unsigned int v2:8; unsigned long long v3:9; };
struct Sf_BFu8i_BFu9s { empty v1; unsigned int v2:8; unsigned short v3:9; };
struct Sf_BFu8i_C { empty v1; unsigned int v2:8; char v3; };
struct Sf_BFu8i_D { empty v1; unsigned int v2:8; double v3; };
struct Sf_BFu8i_F { empty v1; unsigned int v2:8; float v3; };
struct Sf_BFu8i_I { empty v1; unsigned int v2:8; int v3; };
struct Sf_BFu8i_Ip { empty v1; unsigned int v2:8; int * v3; };
struct Sf_BFu8i_L { empty v1; unsigned int v2:8; long long v3; };
struct Sf_BFu8i_S { empty v1; unsigned int v2:8; short v3; };
struct Sf_BFu8i_Sf { empty v1; unsigned int v2:8; empty v3; };
struct Sf_BFu8i_Uc { empty v1; unsigned int v2:8; unsigned char v3; };
struct Sf_BFu8i_Ui { empty v1; unsigned int v2:8; unsigned int v3; };
struct Sf_BFu8i_Ul { empty v1; unsigned int v2:8; unsigned long long v3; };
struct Sf_BFu8i_Us { empty v1; unsigned int v2:8; unsigned short v3; };
struct Sf_BFu8i_Vp { empty v1; unsigned int v2:8; void * v3; };
struct Sf_BFu8ll { empty v1; unsigned long long v2:8; };
struct Sf_BFu8ll_BFu15i { empty v1; unsigned long long v2:8; unsigned int v3:15; };
struct Sf_BFu8ll_BFu15ll { empty v1; unsigned long long v2:8; unsigned long long v3:15; };
struct Sf_BFu8ll_BFu15s { empty v1; unsigned long long v2:8; unsigned short v3:15; };
struct Sf_BFu8ll_BFu16i { empty v1; unsigned long long v2:8; unsigned int v3:16; };
struct Sf_BFu8ll_BFu16ll { empty v1; unsigned long long v2:8; unsigned long long v3:16; };
struct Sf_BFu8ll_BFu16s { empty v1; unsigned long long v2:8; unsigned short v3:16; };
struct Sf_BFu8ll_BFu17i { empty v1; unsigned long long v2:8; unsigned int v3:17; };
struct Sf_BFu8ll_BFu17ll { empty v1; unsigned long long v2:8; unsigned long long v3:17; };
struct Sf_BFu8ll_BFu1c { empty v1; unsigned long long v2:8; unsigned char v3:1; };
struct Sf_BFu8ll_BFu1i { empty v1; unsigned long long v2:8; unsigned int v3:1; };
struct Sf_BFu8ll_BFu1ll { empty v1; unsigned long long v2:8; unsigned long long v3:1; };
struct Sf_BFu8ll_BFu1s { empty v1; unsigned long long v2:8; unsigned short v3:1; };
struct Sf_BFu8ll_BFu31i { empty v1; unsigned long long v2:8; unsigned int v3:31; };
struct Sf_BFu8ll_BFu31ll { empty v1; unsigned long long v2:8; unsigned long long v3:31; };
struct Sf_BFu8ll_BFu32i { empty v1; unsigned long long v2:8; unsigned int v3:32; };
struct Sf_BFu8ll_BFu32ll { empty v1; unsigned long long v2:8; unsigned long long v3:32; };
struct Sf_BFu8ll_BFu33 { empty v1; unsigned long long v2:8; unsigned long long v3:33; };
struct Sf_BFu8ll_BFu7c { empty v1; unsigned long long v2:8; unsigned char v3:7; };
struct Sf_BFu8ll_BFu7i { empty v1; unsigned long long v2:8; unsigned int v3:7; };
struct Sf_BFu8ll_BFu7ll { empty v1; unsigned long long v2:8; unsigned long long v3:7; };
struct Sf_BFu8ll_BFu7s { empty v1; unsigned long long v2:8; unsigned short v3:7; };
struct Sf_BFu8ll_BFu8c { empty v1; unsigned long long v2:8; unsigned char v3:8; };
struct Sf_BFu8ll_BFu8i { empty v1; unsigned long long v2:8; unsigned int v3:8; };
struct Sf_BFu8ll_BFu8ll { empty v1; unsigned long long v2:8; unsigned long long v3:8; };
struct Sf_BFu8ll_BFu8s { empty v1; unsigned long long v2:8; unsigned short v3:8; };
struct Sf_BFu8ll_BFu9i { empty v1; unsigned long long v2:8; unsigned int v3:9; };
struct Sf_BFu8ll_BFu9ll { empty v1; unsigned long long v2:8; unsigned long long v3:9; };
struct Sf_BFu8ll_BFu9s { empty v1; unsigned long long v2:8; unsigned short v3:9; };
struct Sf_BFu8ll_C { empty v1; unsigned long long v2:8; char v3; };
struct Sf_BFu8ll_D { empty v1; unsigned long long v2:8; double v3; };
struct Sf_BFu8ll_F { empty v1; unsigned long long v2:8; float v3; };
struct Sf_BFu8ll_I { empty v1; unsigned long long v2:8; int v3; };
struct Sf_BFu8ll_Ip { empty v1; unsigned long long v2:8; int * v3; };
struct Sf_BFu8ll_L { empty v1; unsigned long long v2:8; long long v3; };
struct Sf_BFu8ll_S { empty v1; unsigned long long v2:8; short v3; };
struct Sf_BFu8ll_Sf { empty v1; unsigned long long v2:8; empty v3; };
struct Sf_BFu8ll_Uc { empty v1; unsigned long long v2:8; unsigned char v3; };
struct Sf_BFu8ll_Ui { empty v1; unsigned long long v2:8; unsigned int v3; };
struct Sf_BFu8ll_Ul { empty v1; unsigned long long v2:8; unsigned long long v3; };
struct Sf_BFu8ll_Us { empty v1; unsigned long long v2:8; unsigned short v3; };
struct Sf_BFu8ll_Vp { empty v1; unsigned long long v2:8; void * v3; };
struct Sf_BFu8s { empty v1; unsigned short v2:8; };
struct Sf_BFu8s_BFu15i { empty v1; unsigned short v2:8; unsigned int v3:15; };
struct Sf_BFu8s_BFu15ll { empty v1; unsigned short v2:8; unsigned long long v3:15; };
struct Sf_BFu8s_BFu15s { empty v1; unsigned short v2:8; unsigned short v3:15; };
struct Sf_BFu8s_BFu16i { empty v1; unsigned short v2:8; unsigned int v3:16; };
struct Sf_BFu8s_BFu16ll { empty v1; unsigned short v2:8; unsigned long long v3:16; };
struct Sf_BFu8s_BFu16s { empty v1; unsigned short v2:8; unsigned short v3:16; };
struct Sf_BFu8s_BFu17i { empty v1; unsigned short v2:8; unsigned int v3:17; };
struct Sf_BFu8s_BFu17ll { empty v1; unsigned short v2:8; unsigned long long v3:17; };
struct Sf_BFu8s_BFu1c { empty v1; unsigned short v2:8; unsigned char v3:1; };
struct Sf_BFu8s_BFu1i { empty v1; unsigned short v2:8; unsigned int v3:1; };
struct Sf_BFu8s_BFu1ll { empty v1; unsigned short v2:8; unsigned long long v3:1; };
struct Sf_BFu8s_BFu1s { empty v1; unsigned short v2:8; unsigned short v3:1; };
struct Sf_BFu8s_BFu31i { empty v1; unsigned short v2:8; unsigned int v3:31; };
struct Sf_BFu8s_BFu31ll { empty v1; unsigned short v2:8; unsigned long long v3:31; };
struct Sf_BFu8s_BFu32i { empty v1; unsigned short v2:8; unsigned int v3:32; };
struct Sf_BFu8s_BFu32ll { empty v1; unsigned short v2:8; unsigned long long v3:32; };
struct Sf_BFu8s_BFu33 { empty v1; unsigned short v2:8; unsigned long long v3:33; };
struct Sf_BFu8s_BFu7c { empty v1; unsigned short v2:8; unsigned char v3:7; };
struct Sf_BFu8s_BFu7i { empty v1; unsigned short v2:8; unsigned int v3:7; };
struct Sf_BFu8s_BFu7ll { empty v1; unsigned short v2:8; unsigned long long v3:7; };
struct Sf_BFu8s_BFu7s { empty v1; unsigned short v2:8; unsigned short v3:7; };
struct Sf_BFu8s_BFu8c { empty v1; unsigned short v2:8; unsigned char v3:8; };
struct Sf_BFu8s_BFu8i { empty v1; unsigned short v2:8; unsigned int v3:8; };
struct Sf_BFu8s_BFu8ll { empty v1; unsigned short v2:8; unsigned long long v3:8; };
struct Sf_BFu8s_BFu8s { empty v1; unsigned short v2:8; unsigned short v3:8; };
struct Sf_BFu8s_BFu9i { empty v1; unsigned short v2:8; unsigned int v3:9; };
struct Sf_BFu8s_BFu9ll { empty v1; unsigned short v2:8; unsigned long long v3:9; };
struct Sf_BFu8s_BFu9s { empty v1; unsigned short v2:8; unsigned short v3:9; };
struct Sf_BFu8s_C { empty v1; unsigned short v2:8; char v3; };
struct Sf_BFu8s_D { empty v1; unsigned short v2:8; double v3; };
struct Sf_BFu8s_F { empty v1; unsigned short v2:8; float v3; };
struct Sf_BFu8s_I { empty v1; unsigned short v2:8; int v3; };
struct Sf_BFu8s_Ip { empty v1; unsigned short v2:8; int * v3; };
struct Sf_BFu8s_L { empty v1; unsigned short v2:8; long long v3; };
struct Sf_BFu8s_S { empty v1; unsigned short v2:8; short v3; };
struct Sf_BFu8s_Sf { empty v1; unsigned short v2:8; empty v3; };
struct Sf_BFu8s_Uc { empty v1; unsigned short v2:8; unsigned char v3; };
struct Sf_BFu8s_Ui { empty v1; unsigned short v2:8; unsigned int v3; };
struct Sf_BFu8s_Ul { empty v1; unsigned short v2:8; unsigned long long v3; };
struct Sf_BFu8s_Us { empty v1; unsigned short v2:8; unsigned short v3; };
struct Sf_BFu8s_Vp { empty v1; unsigned short v2:8; void * v3; };
struct Sf_BFu9i { empty v1; unsigned int v2:9; };
struct Sf_BFu9i_BFu15i { empty v1; unsigned int v2:9; unsigned int v3:15; };
struct Sf_BFu9i_BFu15ll { empty v1; unsigned int v2:9; unsigned long long v3:15; };
struct Sf_BFu9i_BFu15s { empty v1; unsigned int v2:9; unsigned short v3:15; };
struct Sf_BFu9i_BFu16i { empty v1; unsigned int v2:9; unsigned int v3:16; };
struct Sf_BFu9i_BFu16ll { empty v1; unsigned int v2:9; unsigned long long v3:16; };
struct Sf_BFu9i_BFu16s { empty v1; unsigned int v2:9; unsigned short v3:16; };
struct Sf_BFu9i_BFu17i { empty v1; unsigned int v2:9; unsigned int v3:17; };
struct Sf_BFu9i_BFu17ll { empty v1; unsigned int v2:9; unsigned long long v3:17; };
struct Sf_BFu9i_BFu1c { empty v1; unsigned int v2:9; unsigned char v3:1; };
struct Sf_BFu9i_BFu1i { empty v1; unsigned int v2:9; unsigned int v3:1; };
struct Sf_BFu9i_BFu1ll { empty v1; unsigned int v2:9; unsigned long long v3:1; };
struct Sf_BFu9i_BFu1s { empty v1; unsigned int v2:9; unsigned short v3:1; };
struct Sf_BFu9i_BFu31i { empty v1; unsigned int v2:9; unsigned int v3:31; };
struct Sf_BFu9i_BFu31ll { empty v1; unsigned int v2:9; unsigned long long v3:31; };
struct Sf_BFu9i_BFu32i { empty v1; unsigned int v2:9; unsigned int v3:32; };
struct Sf_BFu9i_BFu32ll { empty v1; unsigned int v2:9; unsigned long long v3:32; };
struct Sf_BFu9i_BFu33 { empty v1; unsigned int v2:9; unsigned long long v3:33; };
struct Sf_BFu9i_BFu7c { empty v1; unsigned int v2:9; unsigned char v3:7; };
struct Sf_BFu9i_BFu7i { empty v1; unsigned int v2:9; unsigned int v3:7; };
struct Sf_BFu9i_BFu7ll { empty v1; unsigned int v2:9; unsigned long long v3:7; };
struct Sf_BFu9i_BFu7s { empty v1; unsigned int v2:9; unsigned short v3:7; };
struct Sf_BFu9i_BFu8c { empty v1; unsigned int v2:9; unsigned char v3:8; };
struct Sf_BFu9i_BFu8i { empty v1; unsigned int v2:9; unsigned int v3:8; };
struct Sf_BFu9i_BFu8ll { empty v1; unsigned int v2:9; unsigned long long v3:8; };
struct Sf_BFu9i_BFu8s { empty v1; unsigned int v2:9; unsigned short v3:8; };
struct Sf_BFu9i_BFu9i { empty v1; unsigned int v2:9; unsigned int v3:9; };
struct Sf_BFu9i_BFu9ll { empty v1; unsigned int v2:9; unsigned long long v3:9; };
struct Sf_BFu9i_BFu9s { empty v1; unsigned int v2:9; unsigned short v3:9; };
struct Sf_BFu9i_C { empty v1; unsigned int v2:9; char v3; };
struct Sf_BFu9i_D { empty v1; unsigned int v2:9; double v3; };
struct Sf_BFu9i_F { empty v1; unsigned int v2:9; float v3; };
struct Sf_BFu9i_I { empty v1; unsigned int v2:9; int v3; };
struct Sf_BFu9i_Ip { empty v1; unsigned int v2:9; int * v3; };
struct Sf_BFu9i_L { empty v1; unsigned int v2:9; long long v3; };
struct Sf_BFu9i_S { empty v1; unsigned int v2:9; short v3; };
struct Sf_BFu9i_Sf { empty v1; unsigned int v2:9; empty v3; };
struct Sf_BFu9i_Uc { empty v1; unsigned int v2:9; unsigned char v3; };
struct Sf_BFu9i_Ui { empty v1; unsigned int v2:9; unsigned int v3; };
struct Sf_BFu9i_Ul { empty v1; unsigned int v2:9; unsigned long long v3; };
struct Sf_BFu9i_Us { empty v1; unsigned int v2:9; unsigned short v3; };
struct Sf_BFu9i_Vp { empty v1; unsigned int v2:9; void * v3; };
struct Sf_BFu9ll { empty v1; unsigned long long v2:9; };
struct Sf_BFu9ll_BFu15i { empty v1; unsigned long long v2:9; unsigned int v3:15; };
struct Sf_BFu9ll_BFu15ll { empty v1; unsigned long long v2:9; unsigned long long v3:15; };
struct Sf_BFu9ll_BFu15s { empty v1; unsigned long long v2:9; unsigned short v3:15; };
struct Sf_BFu9ll_BFu16i { empty v1; unsigned long long v2:9; unsigned int v3:16; };
struct Sf_BFu9ll_BFu16ll { empty v1; unsigned long long v2:9; unsigned long long v3:16; };
struct Sf_BFu9ll_BFu16s { empty v1; unsigned long long v2:9; unsigned short v3:16; };
struct Sf_BFu9ll_BFu17i { empty v1; unsigned long long v2:9; unsigned int v3:17; };
struct Sf_BFu9ll_BFu17ll { empty v1; unsigned long long v2:9; unsigned long long v3:17; };
struct Sf_BFu9ll_BFu1c { empty v1; unsigned long long v2:9; unsigned char v3:1; };
struct Sf_BFu9ll_BFu1i { empty v1; unsigned long long v2:9; unsigned int v3:1; };
struct Sf_BFu9ll_BFu1ll { empty v1; unsigned long long v2:9; unsigned long long v3:1; };
struct Sf_BFu9ll_BFu1s { empty v1; unsigned long long v2:9; unsigned short v3:1; };
struct Sf_BFu9ll_BFu31i { empty v1; unsigned long long v2:9; unsigned int v3:31; };
struct Sf_BFu9ll_BFu31ll { empty v1; unsigned long long v2:9; unsigned long long v3:31; };
struct Sf_BFu9ll_BFu32i { empty v1; unsigned long long v2:9; unsigned int v3:32; };
struct Sf_BFu9ll_BFu32ll { empty v1; unsigned long long v2:9; unsigned long long v3:32; };
struct Sf_BFu9ll_BFu33 { empty v1; unsigned long long v2:9; unsigned long long v3:33; };
struct Sf_BFu9ll_BFu7c { empty v1; unsigned long long v2:9; unsigned char v3:7; };
struct Sf_BFu9ll_BFu7i { empty v1; unsigned long long v2:9; unsigned int v3:7; };
struct Sf_BFu9ll_BFu7ll { empty v1; unsigned long long v2:9; unsigned long long v3:7; };
struct Sf_BFu9ll_BFu7s { empty v1; unsigned long long v2:9; unsigned short v3:7; };
struct Sf_BFu9ll_BFu8c { empty v1; unsigned long long v2:9; unsigned char v3:8; };
struct Sf_BFu9ll_BFu8i { empty v1; unsigned long long v2:9; unsigned int v3:8; };
struct Sf_BFu9ll_BFu8ll { empty v1; unsigned long long v2:9; unsigned long long v3:8; };
struct Sf_BFu9ll_BFu8s { empty v1; unsigned long long v2:9; unsigned short v3:8; };
struct Sf_BFu9ll_BFu9i { empty v1; unsigned long long v2:9; unsigned int v3:9; };
struct Sf_BFu9ll_BFu9ll { empty v1; unsigned long long v2:9; unsigned long long v3:9; };
struct Sf_BFu9ll_BFu9s { empty v1; unsigned long long v2:9; unsigned short v3:9; };
struct Sf_BFu9ll_C { empty v1; unsigned long long v2:9; char v3; };
struct Sf_BFu9ll_D { empty v1; unsigned long long v2:9; double v3; };
struct Sf_BFu9ll_F { empty v1; unsigned long long v2:9; float v3; };
struct Sf_BFu9ll_I { empty v1; unsigned long long v2:9; int v3; };
struct Sf_BFu9ll_Ip { empty v1; unsigned long long v2:9; int * v3; };


static void Test_empty()
{
  {
    init_simple_test("empty");
    STRUCT_IF_C empty lv;
    check2(sizeof(lv), 0, "sizeof(empty)");
    check2(__alignof__(lv), 1, "__alignof__(empty)");
  }
}
ARRANGE_TO_CALL_ME(Test_empty, empty)
//============================================================================



static void Test_BFu31i_BFu31ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu31ll_Sf");
    static STRUCT_IF_C BFu31i_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFu31i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_ull(1LL<<30), "BFu31i_BFu31ll_Sf");
    check_field_offset(lv, v3, 8, "BFu31i_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu31ll_Sf, BFu31i_BFu31ll_Sf)
//============================================================================



static void Test_BFu31i_BFu32i_Sf()
{
  {
    init_simple_test("BFu31i_BFu32i_Sf");
    static STRUCT_IF_C BFu31i_BFu32i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, 1, "BFu31i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, hide_ull(1LL<<31), "BFu31i_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu31i_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu32i_Sf, BFu31i_BFu32i_Sf)
//============================================================================



static void Test_BFu31i_BFu32ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu32ll_Sf");
    static STRUCT_IF_C BFu31i_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, 1, "BFu31i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, hide_ull(1LL<<31), "BFu31i_BFu32ll_Sf");
    check_field_offset(lv, v3, 8, "BFu31i_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu32ll_Sf, BFu31i_BFu32ll_Sf)
//============================================================================



static void Test_BFu31i_BFu33_Sf()
{
  {
    init_simple_test("BFu31i_BFu33_Sf");
    static STRUCT_IF_C BFu31i_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu33_Sf");
    set_bf_and_test(lv, v2, 3, 7, 33, 1, "BFu31i_BFu33_Sf");
    set_bf_and_test(lv, v2, 3, 7, 33, hide_ull(1LL<<32), "BFu31i_BFu33_Sf");
    check_field_offset(lv, v3, 8, "BFu31i_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu33_Sf, BFu31i_BFu33_Sf)
//============================================================================



static void Test_BFu31i_BFu7c_Sf()
{
  {
    init_simple_test("BFu31i_BFu7c_Sf");
    static STRUCT_IF_C BFu31i_BFu7c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu31i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu31i_BFu7c_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu7c_Sf, BFu31i_BFu7c_Sf)
//============================================================================



static void Test_BFu31i_BFu7i_Sf()
{
  {
    init_simple_test("BFu31i_BFu7i_Sf");
    static STRUCT_IF_C BFu31i_BFu7i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu31i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu31i_BFu7i_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu7i_Sf, BFu31i_BFu7i_Sf)
//============================================================================



static void Test_BFu31i_BFu7ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu7ll_Sf");
    static STRUCT_IF_C BFu31i_BFu7ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu31i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu31i_BFu7ll_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu7ll_Sf, BFu31i_BFu7ll_Sf)
//============================================================================



static void Test_BFu31i_BFu7s_Sf()
{
  {
    init_simple_test("BFu31i_BFu7s_Sf");
    static STRUCT_IF_C BFu31i_BFu7s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu31i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu31i_BFu7s_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu7s_Sf, BFu31i_BFu7s_Sf)
//============================================================================



static void Test_BFu31i_BFu8c_Sf()
{
  {
    init_simple_test("BFu31i_BFu8c_Sf");
    static STRUCT_IF_C BFu31i_BFu8c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu31i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu31i_BFu8c_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu8c_Sf, BFu31i_BFu8c_Sf)
//============================================================================



static void Test_BFu31i_BFu8i_Sf()
{
  {
    init_simple_test("BFu31i_BFu8i_Sf");
    static STRUCT_IF_C BFu31i_BFu8i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu31i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu31i_BFu8i_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu8i_Sf, BFu31i_BFu8i_Sf)
//============================================================================



static void Test_BFu31i_BFu8ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu8ll_Sf");
    static STRUCT_IF_C BFu31i_BFu8ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu31i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu31i_BFu8ll_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu8ll_Sf, BFu31i_BFu8ll_Sf)
//============================================================================



static void Test_BFu31i_BFu8s_Sf()
{
  {
    init_simple_test("BFu31i_BFu8s_Sf");
    static STRUCT_IF_C BFu31i_BFu8s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu31i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu31i_BFu8s_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu8s_Sf, BFu31i_BFu8s_Sf)
//============================================================================



static void Test_BFu31i_BFu9i_Sf()
{
  {
    init_simple_test("BFu31i_BFu9i_Sf");
    static STRUCT_IF_C BFu31i_BFu9i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "BFu31i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "BFu31i_BFu9i_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu9i_Sf, BFu31i_BFu9i_Sf)
//============================================================================



static void Test_BFu31i_BFu9ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu9ll_Sf");
    static STRUCT_IF_C BFu31i_BFu9ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "BFu31i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "BFu31i_BFu9ll_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu9ll_Sf, BFu31i_BFu9ll_Sf)
//============================================================================



static void Test_BFu31i_BFu9s_Sf()
{
  {
    init_simple_test("BFu31i_BFu9s_Sf");
    static STRUCT_IF_C BFu31i_BFu9s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "BFu31i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "BFu31i_BFu9s_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_BFu9s_Sf, BFu31i_BFu9s_Sf)
//============================================================================



static void Test_BFu31i_C_Sf()
{
  {
    init_simple_test("BFu31i_C_Sf");
    static STRUCT_IF_C BFu31i_C_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_C_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_C_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu31i_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_C_Sf, BFu31i_C_Sf)
//============================================================================



static void Test_BFu31i_D_Sf()
{
  {
    init_simple_test("BFu31i_D_Sf");
    static STRUCT_IF_C BFu31i_D_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_D_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_D_Sf.v2");
    check_field_offset(lv, v3, 12, "BFu31i_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_D_Sf, BFu31i_D_Sf)
//============================================================================



static void Test_BFu31i_F_Sf()
{
  {
    init_simple_test("BFu31i_F_Sf");
    static STRUCT_IF_C BFu31i_F_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_F_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu31i_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_F_Sf, BFu31i_F_Sf)
//============================================================================



static void Test_BFu31i_I_Sf()
{
  {
    init_simple_test("BFu31i_I_Sf");
    static STRUCT_IF_C BFu31i_I_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_I_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu31i_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_I_Sf, BFu31i_I_Sf)
//============================================================================



static void Test_BFu31i_Ip_Sf()
{
  {
    init_simple_test("BFu31i_Ip_Sf");
    static STRUCT_IF_C BFu31i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu31i_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Ip_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "BFu31i_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Ip_Sf, BFu31i_Ip_Sf)
//============================================================================



static void Test_BFu31i_L_Sf()
{
  {
    init_simple_test("BFu31i_L_Sf");
    static STRUCT_IF_C BFu31i_L_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_L_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_L_Sf.v2");
    check_field_offset(lv, v3, 12, "BFu31i_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_L_Sf, BFu31i_L_Sf)
//============================================================================



static void Test_BFu31i_S_Sf()
{
  {
    init_simple_test("BFu31i_S_Sf");
    static STRUCT_IF_C BFu31i_S_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu31i_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_S_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_S_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu31i_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_S_Sf, BFu31i_S_Sf)
//============================================================================



static void Test_BFu31i_Sf()
{
  {
    init_simple_test("BFu31i_Sf");
    static STRUCT_IF_C BFu31i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf, BFu31i_Sf)
//============================================================================



static void Test_BFu31i_Sf_BFu15i()
{
  {
    init_simple_test("BFu31i_Sf_BFu15i");
    static STRUCT_IF_C BFu31i_Sf_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu31i_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu15i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu31i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu31i_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu15i, BFu31i_Sf_BFu15i)
//============================================================================



static void Test_BFu31i_Sf_BFu15ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu15ll");
    static STRUCT_IF_C BFu31i_Sf_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu31i_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu15ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu31i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu31i_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu15ll, BFu31i_Sf_BFu15ll)
//============================================================================



static void Test_BFu31i_Sf_BFu15s()
{
  {
    init_simple_test("BFu31i_Sf_BFu15s");
    static STRUCT_IF_C BFu31i_Sf_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu31i_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu15s");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu31i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu31i_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu15s, BFu31i_Sf_BFu15s)
//============================================================================



static void Test_BFu31i_Sf_BFu16i()
{
  {
    init_simple_test("BFu31i_Sf_BFu16i");
    static STRUCT_IF_C BFu31i_Sf_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(BFu31i_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu16i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu31i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu31i_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu16i, BFu31i_Sf_BFu16i)
//============================================================================



static void Test_BFu31i_Sf_BFu16ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu16ll");
    static STRUCT_IF_C BFu31i_Sf_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu31i_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu16ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu31i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu31i_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu16ll, BFu31i_Sf_BFu16ll)
//============================================================================



static void Test_BFu31i_Sf_BFu16s()
{
  {
    init_simple_test("BFu31i_Sf_BFu16s");
    static STRUCT_IF_C BFu31i_Sf_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu31i_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu16s");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu31i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu31i_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu16s, BFu31i_Sf_BFu16s)
//============================================================================



static void Test_BFu31i_Sf_BFu17i()
{
  {
    init_simple_test("BFu31i_Sf_BFu17i");
    static STRUCT_IF_C BFu31i_Sf_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(BFu31i_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu17i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu31i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu31i_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu17i, BFu31i_Sf_BFu17i)
//============================================================================



static void Test_BFu31i_Sf_BFu17ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu17ll");
    static STRUCT_IF_C BFu31i_Sf_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu31i_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu17ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu31i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu31i_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu17ll, BFu31i_Sf_BFu17ll)
//============================================================================



static void Test_BFu31i_Sf_BFu1c()
{
  {
    init_simple_test("BFu31i_Sf_BFu1c");
    static STRUCT_IF_C BFu31i_Sf_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu1c");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu31i_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu1c, BFu31i_Sf_BFu1c)
//============================================================================



static void Test_BFu31i_Sf_BFu1i()
{
  {
    init_simple_test("BFu31i_Sf_BFu1i");
    static STRUCT_IF_C BFu31i_Sf_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu1i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu31i_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu1i, BFu31i_Sf_BFu1i)
//============================================================================



static void Test_BFu31i_Sf_BFu1ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu1ll");
    static STRUCT_IF_C BFu31i_Sf_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu1ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu31i_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu1ll, BFu31i_Sf_BFu1ll)
//============================================================================



static void Test_BFu31i_Sf_BFu1s()
{
  {
    init_simple_test("BFu31i_Sf_BFu1s");
    static STRUCT_IF_C BFu31i_Sf_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu1s");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu31i_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu1s, BFu31i_Sf_BFu1s)
//============================================================================



static void Test_BFu31i_Sf_BFu31i()
{
  {
    init_simple_test("BFu31i_Sf_BFu31i");
    static STRUCT_IF_C BFu31i_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu31i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu31i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu31i, BFu31i_Sf_BFu31i)
//============================================================================



static void Test_BFu31i_Sf_BFu31ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu31ll");
    static STRUCT_IF_C BFu31i_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu31ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu31i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu31ll, BFu31i_Sf_BFu31ll)
//============================================================================



static void Test_BFu31i_Sf_BFu32i()
{
  {
    init_simple_test("BFu31i_Sf_BFu32i");
    static STRUCT_IF_C BFu31i_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu32i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu31i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu31i_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu32i, BFu31i_Sf_BFu32i)
//============================================================================



static void Test_BFu31i_Sf_BFu32ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu32ll");
    static STRUCT_IF_C BFu31i_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu32ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu31i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu31i_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu32ll, BFu31i_Sf_BFu32ll)
//============================================================================



static void Test_BFu31i_Sf_BFu33()
{
  {
    init_simple_test("BFu31i_Sf_BFu33");
    static STRUCT_IF_C BFu31i_Sf_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(BFu31i_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu33");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "BFu31i_Sf_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "BFu31i_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu33, BFu31i_Sf_BFu33)
//============================================================================



static void Test_BFu31i_Sf_BFu7c()
{
  {
    init_simple_test("BFu31i_Sf_BFu7c");
    static STRUCT_IF_C BFu31i_Sf_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu7c");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu31i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu31i_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu7c, BFu31i_Sf_BFu7c)
//============================================================================



static void Test_BFu31i_Sf_BFu7i()
{
  {
    init_simple_test("BFu31i_Sf_BFu7i");
    static STRUCT_IF_C BFu31i_Sf_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu7i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu31i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu31i_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu7i, BFu31i_Sf_BFu7i)
//============================================================================



static void Test_BFu31i_Sf_BFu7ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu7ll");
    static STRUCT_IF_C BFu31i_Sf_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu7ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu31i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu31i_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu7ll, BFu31i_Sf_BFu7ll)
//============================================================================



static void Test_BFu31i_Sf_BFu7s()
{
  {
    init_simple_test("BFu31i_Sf_BFu7s");
    static STRUCT_IF_C BFu31i_Sf_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu7s");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu31i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu31i_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu7s, BFu31i_Sf_BFu7s)
//============================================================================



static void Test_BFu31i_Sf_BFu8c()
{
  {
    init_simple_test("BFu31i_Sf_BFu8c");
    static STRUCT_IF_C BFu31i_Sf_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu8c");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu31i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu31i_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu8c, BFu31i_Sf_BFu8c)
//============================================================================



static void Test_BFu31i_Sf_BFu8i()
{
  {
    init_simple_test("BFu31i_Sf_BFu8i");
    static STRUCT_IF_C BFu31i_Sf_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu8i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu31i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu31i_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu8i, BFu31i_Sf_BFu8i)
//============================================================================



static void Test_BFu31i_Sf_BFu8ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu8ll");
    static STRUCT_IF_C BFu31i_Sf_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu8ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu31i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu31i_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu8ll, BFu31i_Sf_BFu8ll)
//============================================================================



static void Test_BFu31i_Sf_BFu8s()
{
  {
    init_simple_test("BFu31i_Sf_BFu8s");
    static STRUCT_IF_C BFu31i_Sf_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu8s");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu31i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu31i_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu8s, BFu31i_Sf_BFu8s)
//============================================================================



static void Test_BFu31i_Sf_BFu9i()
{
  {
    init_simple_test("BFu31i_Sf_BFu9i");
    static STRUCT_IF_C BFu31i_Sf_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(BFu31i_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu9i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu31i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu31i_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu9i, BFu31i_Sf_BFu9i)
//============================================================================



static void Test_BFu31i_Sf_BFu9ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu9ll");
    static STRUCT_IF_C BFu31i_Sf_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu31i_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu9ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu31i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu31i_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu9ll, BFu31i_Sf_BFu9ll)
//============================================================================



static void Test_BFu31i_Sf_BFu9s()
{
  {
    init_simple_test("BFu31i_Sf_BFu9s");
    static STRUCT_IF_C BFu31i_Sf_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu31i_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu9s");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu31i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu31i_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_BFu9s, BFu31i_Sf_BFu9s)
//============================================================================



static void Test_BFu31i_Sf_C()
{
  {
    init_simple_test("BFu31i_Sf_C");
    static STRUCT_IF_C BFu31i_Sf_C lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_C");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_C.v2");
    check_field_offset(lv, v3, 4, "BFu31i_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_C, BFu31i_Sf_C)
//============================================================================



static void Test_BFu31i_Sf_D()
{
  {
    init_simple_test("BFu31i_Sf_D");
    static STRUCT_IF_C BFu31i_Sf_D lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_D");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_D.v2");
    check_field_offset(lv, v3, 4, "BFu31i_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_D, BFu31i_Sf_D)
//============================================================================



static void Test_BFu31i_Sf_F()
{
  {
    init_simple_test("BFu31i_Sf_F");
    static STRUCT_IF_C BFu31i_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_F");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu31i_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_F, BFu31i_Sf_F)
//============================================================================



static void Test_BFu31i_Sf_I()
{
  {
    init_simple_test("BFu31i_Sf_I");
    static STRUCT_IF_C BFu31i_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_I");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu31i_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_I, BFu31i_Sf_I)
//============================================================================



static void Test_BFu31i_Sf_Ip()
{
  {
    init_simple_test("BFu31i_Sf_Ip");
    static STRUCT_IF_C BFu31i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu31i_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Ip");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Ip.v2");
    check_field_offset(lv, v3, 4, "BFu31i_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_Ip, BFu31i_Sf_Ip)
//============================================================================



static void Test_BFu31i_Sf_L()
{
  {
    init_simple_test("BFu31i_Sf_L");
    static STRUCT_IF_C BFu31i_Sf_L lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_L");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_L.v2");
    check_field_offset(lv, v3, 4, "BFu31i_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_L, BFu31i_Sf_L)
//============================================================================



static void Test_BFu31i_Sf_S()
{
  {
    init_simple_test("BFu31i_Sf_S");
    static STRUCT_IF_C BFu31i_Sf_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu31i_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_S");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_S.v2");
    check_field_offset(lv, v3, 4, "BFu31i_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_S, BFu31i_Sf_S)
//============================================================================



static void Test_BFu31i_Sf_Sf()
{
  {
    init_simple_test("BFu31i_Sf_Sf");
    static STRUCT_IF_C BFu31i_Sf_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu31i_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu31i_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_Sf, BFu31i_Sf_Sf)
//============================================================================



static void Test_BFu31i_Sf_Uc()
{
  {
    init_simple_test("BFu31i_Sf_Uc");
    static STRUCT_IF_C BFu31i_Sf_Uc lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Uc");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Uc.v2");
    check_field_offset(lv, v3, 4, "BFu31i_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_Uc, BFu31i_Sf_Uc)
//============================================================================



static void Test_BFu31i_Sf_Ui()
{
  {
    init_simple_test("BFu31i_Sf_Ui");
    static STRUCT_IF_C BFu31i_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Ui");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu31i_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_Ui, BFu31i_Sf_Ui)
//============================================================================



static void Test_BFu31i_Sf_Ul()
{
  {
    init_simple_test("BFu31i_Sf_Ul");
    static STRUCT_IF_C BFu31i_Sf_Ul lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Ul");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Ul.v2");
    check_field_offset(lv, v3, 4, "BFu31i_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_Ul, BFu31i_Sf_Ul)
//============================================================================



static void Test_BFu31i_Sf_Us()
{
  {
    init_simple_test("BFu31i_Sf_Us");
    static STRUCT_IF_C BFu31i_Sf_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu31i_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Us");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Us.v2");
    check_field_offset(lv, v3, 4, "BFu31i_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_Us, BFu31i_Sf_Us)
//============================================================================



static void Test_BFu31i_Sf_Vp()
{
  {
    init_simple_test("BFu31i_Sf_Vp");
    static STRUCT_IF_C BFu31i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu31i_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Vp");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Vp.v2");
    check_field_offset(lv, v3, 4, "BFu31i_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Sf_Vp, BFu31i_Sf_Vp)
//============================================================================



static void Test_BFu31i_Uc_Sf()
{
  {
    init_simple_test("BFu31i_Uc_Sf");
    static STRUCT_IF_C BFu31i_Uc_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31i_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Uc_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_Uc_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu31i_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Uc_Sf, BFu31i_Uc_Sf)
//============================================================================



static void Test_BFu31i_Ui_Sf()
{
  {
    init_simple_test("BFu31i_Ui_Sf");
    static STRUCT_IF_C BFu31i_Ui_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu31i_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Ui_Sf, BFu31i_Ui_Sf)
//============================================================================



static void Test_BFu31i_Ul_Sf()
{
  {
    init_simple_test("BFu31i_Ul_Sf");
    static STRUCT_IF_C BFu31i_Ul_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Ul_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_Ul_Sf.v2");
    check_field_offset(lv, v3, 12, "BFu31i_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Ul_Sf, BFu31i_Ul_Sf)
//============================================================================



static void Test_BFu31i_Us_Sf()
{
  {
    init_simple_test("BFu31i_Us_Sf");
    static STRUCT_IF_C BFu31i_Us_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu31i_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Us_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_Us_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu31i_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Us_Sf, BFu31i_Us_Sf)
//============================================================================



static void Test_BFu31i_Vp_Sf()
{
  {
    init_simple_test("BFu31i_Vp_Sf");
    static STRUCT_IF_C BFu31i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu31i_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Vp_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "BFu31i_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31i_Vp_Sf, BFu31i_Vp_Sf)
//============================================================================



static void Test_BFu31ll_BFu15i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu15i_Sf");
    static STRUCT_IF_C BFu31ll_BFu15i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, 1, "BFu31ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, hide_ull(1LL<<14), "BFu31ll_BFu15i_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu15i_Sf, BFu31ll_BFu15i_Sf)
//============================================================================



static void Test_BFu31ll_BFu15ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu15ll_Sf");
    static STRUCT_IF_C BFu31ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, 1, "BFu31ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, hide_ull(1LL<<14), "BFu31ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu15ll_Sf, BFu31ll_BFu15ll_Sf)
//============================================================================



static void Test_BFu31ll_BFu15s_Sf()
{
  {
    init_simple_test("BFu31ll_BFu15s_Sf");
    static STRUCT_IF_C BFu31ll_BFu15s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, 1, "BFu31ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, hide_ull(1LL<<14), "BFu31ll_BFu15s_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu15s_Sf, BFu31ll_BFu15s_Sf)
//============================================================================



static void Test_BFu31ll_BFu16i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu16i_Sf");
    static STRUCT_IF_C BFu31ll_BFu16i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, 1, "BFu31ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, hide_ull(1LL<<15), "BFu31ll_BFu16i_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu16i_Sf, BFu31ll_BFu16i_Sf)
//============================================================================



static void Test_BFu31ll_BFu16ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu16ll_Sf");
    static STRUCT_IF_C BFu31ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, 1, "BFu31ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, hide_ull(1LL<<15), "BFu31ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu16ll_Sf, BFu31ll_BFu16ll_Sf)
//============================================================================



static void Test_BFu31ll_BFu16s_Sf()
{
  {
    init_simple_test("BFu31ll_BFu16s_Sf");
    static STRUCT_IF_C BFu31ll_BFu16s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, 1, "BFu31ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, hide_ull(1LL<<15), "BFu31ll_BFu16s_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu16s_Sf, BFu31ll_BFu16s_Sf)
//============================================================================



static void Test_BFu31ll_BFu17i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu17i_Sf");
    static STRUCT_IF_C BFu31ll_BFu17i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 17, 1, "BFu31ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 17, hide_ull(1LL<<16), "BFu31ll_BFu17i_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu17i_Sf, BFu31ll_BFu17i_Sf)
//============================================================================



static void Test_BFu31ll_BFu17ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu17ll_Sf");
    static STRUCT_IF_C BFu31ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 17, 1, "BFu31ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 17, hide_ull(1LL<<16), "BFu31ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu17ll_Sf, BFu31ll_BFu17ll_Sf)
//============================================================================



static void Test_BFu31ll_BFu1c_Sf()
{
  {
    init_simple_test("BFu31ll_BFu1c_Sf");
    static STRUCT_IF_C BFu31ll_BFu1c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu31ll_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu31ll_BFu1c_Sf");
    check_field_offset(lv, v3, 4, "BFu31ll_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu1c_Sf, BFu31ll_BFu1c_Sf)
//============================================================================



static void Test_BFu31ll_BFu1i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu1i_Sf");
    static STRUCT_IF_C BFu31ll_BFu1i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu31ll_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu31ll_BFu1i_Sf");
    check_field_offset(lv, v3, 4, "BFu31ll_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu1i_Sf, BFu31ll_BFu1i_Sf)
//============================================================================



static void Test_BFu31ll_BFu1ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu1ll_Sf");
    static STRUCT_IF_C BFu31ll_BFu1ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu31ll_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu31ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 4, "BFu31ll_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu1ll_Sf, BFu31ll_BFu1ll_Sf)
//============================================================================



static void Test_BFu31ll_BFu1s_Sf()
{
  {
    init_simple_test("BFu31ll_BFu1s_Sf");
    static STRUCT_IF_C BFu31ll_BFu1s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu31ll_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu31ll_BFu1s_Sf");
    check_field_offset(lv, v3, 4, "BFu31ll_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu1s_Sf, BFu31ll_BFu1s_Sf)
//============================================================================



static void Test_BFu31ll_BFu31i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu31i_Sf");
    static STRUCT_IF_C BFu31ll_BFu31i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFu31ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_ull(1LL<<30), "BFu31ll_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu31ll_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu31i_Sf, BFu31ll_BFu31i_Sf)
//============================================================================



static void Test_BFu31ll_BFu31ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu31ll_Sf");
    static STRUCT_IF_C BFu31ll_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFu31ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_ull(1LL<<30), "BFu31ll_BFu31ll_Sf");
    check_field_offset(lv, v3, 8, "BFu31ll_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu31ll_Sf, BFu31ll_BFu31ll_Sf)
//============================================================================



static void Test_BFu31ll_BFu32i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu32i_Sf");
    static STRUCT_IF_C BFu31ll_BFu32i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, 1, "BFu31ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, hide_ull(1LL<<31), "BFu31ll_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu31ll_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu32i_Sf, BFu31ll_BFu32i_Sf)
//============================================================================



static void Test_BFu31ll_BFu32ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu32ll_Sf");
    static STRUCT_IF_C BFu31ll_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, 1, "BFu31ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, hide_ull(1LL<<31), "BFu31ll_BFu32ll_Sf");
    check_field_offset(lv, v3, 8, "BFu31ll_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu32ll_Sf, BFu31ll_BFu32ll_Sf)
//============================================================================



static void Test_BFu31ll_BFu33_Sf()
{
  {
    init_simple_test("BFu31ll_BFu33_Sf");
    static STRUCT_IF_C BFu31ll_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 3, 7, 33, 1, "BFu31ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 3, 7, 33, hide_ull(1LL<<32), "BFu31ll_BFu33_Sf");
    check_field_offset(lv, v3, 8, "BFu31ll_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu33_Sf, BFu31ll_BFu33_Sf)
//============================================================================



static void Test_BFu31ll_BFu7c_Sf()
{
  {
    init_simple_test("BFu31ll_BFu7c_Sf");
    static STRUCT_IF_C BFu31ll_BFu7c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu31ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu31ll_BFu7c_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu7c_Sf, BFu31ll_BFu7c_Sf)
//============================================================================



static void Test_BFu31ll_BFu7i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu7i_Sf");
    static STRUCT_IF_C BFu31ll_BFu7i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu31ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu31ll_BFu7i_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu7i_Sf, BFu31ll_BFu7i_Sf)
//============================================================================



static void Test_BFu31ll_BFu7ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu7ll_Sf");
    static STRUCT_IF_C BFu31ll_BFu7ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu31ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu31ll_BFu7ll_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu7ll_Sf, BFu31ll_BFu7ll_Sf)
//============================================================================



static void Test_BFu31ll_BFu7s_Sf()
{
  {
    init_simple_test("BFu31ll_BFu7s_Sf");
    static STRUCT_IF_C BFu31ll_BFu7s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu31ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu31ll_BFu7s_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu7s_Sf, BFu31ll_BFu7s_Sf)
//============================================================================



static void Test_BFu31ll_BFu8c_Sf()
{
  {
    init_simple_test("BFu31ll_BFu8c_Sf");
    static STRUCT_IF_C BFu31ll_BFu8c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu31ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu31ll_BFu8c_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu8c_Sf, BFu31ll_BFu8c_Sf)
//============================================================================



static void Test_BFu31ll_BFu8i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu8i_Sf");
    static STRUCT_IF_C BFu31ll_BFu8i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu31ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu31ll_BFu8i_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu8i_Sf, BFu31ll_BFu8i_Sf)
//============================================================================



static void Test_BFu31ll_BFu8ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu8ll_Sf");
    static STRUCT_IF_C BFu31ll_BFu8ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu31ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu31ll_BFu8ll_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu8ll_Sf, BFu31ll_BFu8ll_Sf)
//============================================================================



static void Test_BFu31ll_BFu8s_Sf()
{
  {
    init_simple_test("BFu31ll_BFu8s_Sf");
    static STRUCT_IF_C BFu31ll_BFu8s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu31ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu31ll_BFu8s_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu8s_Sf, BFu31ll_BFu8s_Sf)
//============================================================================



static void Test_BFu31ll_BFu9i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu9i_Sf");
    static STRUCT_IF_C BFu31ll_BFu9i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "BFu31ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "BFu31ll_BFu9i_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu9i_Sf, BFu31ll_BFu9i_Sf)
//============================================================================



static void Test_BFu31ll_BFu9ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu9ll_Sf");
    static STRUCT_IF_C BFu31ll_BFu9ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "BFu31ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "BFu31ll_BFu9ll_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu9ll_Sf, BFu31ll_BFu9ll_Sf)
//============================================================================



static void Test_BFu31ll_BFu9s_Sf()
{
  {
    init_simple_test("BFu31ll_BFu9s_Sf");
    static STRUCT_IF_C BFu31ll_BFu9s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "BFu31ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "BFu31ll_BFu9s_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_BFu9s_Sf, BFu31ll_BFu9s_Sf)
//============================================================================



static void Test_BFu31ll_C_Sf()
{
  {
    init_simple_test("BFu31ll_C_Sf");
    static STRUCT_IF_C BFu31ll_C_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_C_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_C_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu31ll_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_C_Sf, BFu31ll_C_Sf)
//============================================================================



static void Test_BFu31ll_D_Sf()
{
  {
    init_simple_test("BFu31ll_D_Sf");
    static STRUCT_IF_C BFu31ll_D_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu31ll_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_D_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_D_Sf.v2");
    check_field_offset(lv, v3, 12, "BFu31ll_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_D_Sf, BFu31ll_D_Sf)
//============================================================================



static void Test_BFu31ll_F_Sf()
{
  {
    init_simple_test("BFu31ll_F_Sf");
    static STRUCT_IF_C BFu31ll_F_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_F_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu31ll_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_F_Sf, BFu31ll_F_Sf)
//============================================================================



static void Test_BFu31ll_I_Sf()
{
  {
    init_simple_test("BFu31ll_I_Sf");
    static STRUCT_IF_C BFu31ll_I_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_I_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu31ll_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_I_Sf, BFu31ll_I_Sf)
//============================================================================



static void Test_BFu31ll_Ip_Sf()
{
  {
    init_simple_test("BFu31ll_Ip_Sf");
    static STRUCT_IF_C BFu31ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu31ll_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Ip_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "BFu31ll_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Ip_Sf, BFu31ll_Ip_Sf)
//============================================================================



static void Test_BFu31ll_L_Sf()
{
  {
    init_simple_test("BFu31ll_L_Sf");
    static STRUCT_IF_C BFu31ll_L_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu31ll_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_L_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_L_Sf.v2");
    check_field_offset(lv, v3, 12, "BFu31ll_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_L_Sf, BFu31ll_L_Sf)
//============================================================================



static void Test_BFu31ll_S_Sf()
{
  {
    init_simple_test("BFu31ll_S_Sf");
    static STRUCT_IF_C BFu31ll_S_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_S_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_S_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu31ll_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_S_Sf, BFu31ll_S_Sf)
//============================================================================



static void Test_BFu31ll_Sf()
{
  {
    init_simple_test("BFu31ll_Sf");
    static STRUCT_IF_C BFu31ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf, BFu31ll_Sf)
//============================================================================



static void Test_BFu31ll_Sf_BFu15i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu15i");
    static STRUCT_IF_C BFu31ll_Sf_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu15i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu31ll_Sf_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu31ll_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu15i, BFu31ll_Sf_BFu15i)
//============================================================================



static void Test_BFu31ll_Sf_BFu15ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu15ll");
    static STRUCT_IF_C BFu31ll_Sf_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu15ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu31ll_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu31ll_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu15ll, BFu31ll_Sf_BFu15ll)
//============================================================================



static void Test_BFu31ll_Sf_BFu15s()
{
  {
    init_simple_test("BFu31ll_Sf_BFu15s");
    static STRUCT_IF_C BFu31ll_Sf_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu15s");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu31ll_Sf_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu31ll_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu15s, BFu31ll_Sf_BFu15s)
//============================================================================



static void Test_BFu31ll_Sf_BFu16i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu16i");
    static STRUCT_IF_C BFu31ll_Sf_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu16i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu31ll_Sf_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu31ll_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu16i, BFu31ll_Sf_BFu16i)
//============================================================================



static void Test_BFu31ll_Sf_BFu16ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu16ll");
    static STRUCT_IF_C BFu31ll_Sf_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu16ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu31ll_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu31ll_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu16ll, BFu31ll_Sf_BFu16ll)
//============================================================================



static void Test_BFu31ll_Sf_BFu16s()
{
  {
    init_simple_test("BFu31ll_Sf_BFu16s");
    static STRUCT_IF_C BFu31ll_Sf_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu16s");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu31ll_Sf_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu31ll_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu16s, BFu31ll_Sf_BFu16s)
//============================================================================



static void Test_BFu31ll_Sf_BFu17i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu17i");
    static STRUCT_IF_C BFu31ll_Sf_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(BFu31ll_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu17i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu31ll_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu31ll_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu17i, BFu31ll_Sf_BFu17i)
//============================================================================



static void Test_BFu31ll_Sf_BFu17ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu17ll");
    static STRUCT_IF_C BFu31ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu31ll_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu17ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu31ll_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu31ll_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu17ll, BFu31ll_Sf_BFu17ll)
//============================================================================



static void Test_BFu31ll_Sf_BFu1c()
{
  {
    init_simple_test("BFu31ll_Sf_BFu1c");
    static STRUCT_IF_C BFu31ll_Sf_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu1c");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu31ll_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu1c, BFu31ll_Sf_BFu1c)
//============================================================================



static void Test_BFu31ll_Sf_BFu1i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu1i");
    static STRUCT_IF_C BFu31ll_Sf_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu1i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu31ll_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu1i, BFu31ll_Sf_BFu1i)
//============================================================================



static void Test_BFu31ll_Sf_BFu1ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu1ll");
    static STRUCT_IF_C BFu31ll_Sf_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu1ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu31ll_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu1ll, BFu31ll_Sf_BFu1ll)
//============================================================================



static void Test_BFu31ll_Sf_BFu1s()
{
  {
    init_simple_test("BFu31ll_Sf_BFu1s");
    static STRUCT_IF_C BFu31ll_Sf_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu1s");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu31ll_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu1s, BFu31ll_Sf_BFu1s)
//============================================================================



static void Test_BFu31ll_Sf_BFu31i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu31i");
    static STRUCT_IF_C BFu31ll_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu31i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu31ll_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu31i, BFu31ll_Sf_BFu31i)
//============================================================================



static void Test_BFu31ll_Sf_BFu31ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu31ll");
    static STRUCT_IF_C BFu31ll_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu31ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu31ll_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu31ll, BFu31ll_Sf_BFu31ll)
//============================================================================



static void Test_BFu31ll_Sf_BFu32i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu32i");
    static STRUCT_IF_C BFu31ll_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu32i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu31ll_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu31ll_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu32i, BFu31ll_Sf_BFu32i)
//============================================================================



static void Test_BFu31ll_Sf_BFu32ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu32ll");
    static STRUCT_IF_C BFu31ll_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu32ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu31ll_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu31ll_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu32ll, BFu31ll_Sf_BFu32ll)
//============================================================================



static void Test_BFu31ll_Sf_BFu33()
{
  {
    init_simple_test("BFu31ll_Sf_BFu33");
    static STRUCT_IF_C BFu31ll_Sf_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(BFu31ll_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu33");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "BFu31ll_Sf_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "BFu31ll_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu33, BFu31ll_Sf_BFu33)
//============================================================================



static void Test_BFu31ll_Sf_BFu7c()
{
  {
    init_simple_test("BFu31ll_Sf_BFu7c");
    static STRUCT_IF_C BFu31ll_Sf_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu7c");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu31ll_Sf_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu31ll_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu7c, BFu31ll_Sf_BFu7c)
//============================================================================



static void Test_BFu31ll_Sf_BFu7i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu7i");
    static STRUCT_IF_C BFu31ll_Sf_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu7i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu31ll_Sf_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu31ll_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu7i, BFu31ll_Sf_BFu7i)
//============================================================================



static void Test_BFu31ll_Sf_BFu7ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu7ll");
    static STRUCT_IF_C BFu31ll_Sf_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu7ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu31ll_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu31ll_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu7ll, BFu31ll_Sf_BFu7ll)
//============================================================================



static void Test_BFu31ll_Sf_BFu7s()
{
  {
    init_simple_test("BFu31ll_Sf_BFu7s");
    static STRUCT_IF_C BFu31ll_Sf_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu7s");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu31ll_Sf_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu31ll_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu7s, BFu31ll_Sf_BFu7s)
//============================================================================



static void Test_BFu31ll_Sf_BFu8c()
{
  {
    init_simple_test("BFu31ll_Sf_BFu8c");
    static STRUCT_IF_C BFu31ll_Sf_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu8c");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu31ll_Sf_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu31ll_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu8c, BFu31ll_Sf_BFu8c)
//============================================================================



static void Test_BFu31ll_Sf_BFu8i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu8i");
    static STRUCT_IF_C BFu31ll_Sf_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu8i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu31ll_Sf_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu31ll_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu8i, BFu31ll_Sf_BFu8i)
//============================================================================



static void Test_BFu31ll_Sf_BFu8ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu8ll");
    static STRUCT_IF_C BFu31ll_Sf_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu8ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu31ll_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu31ll_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu8ll, BFu31ll_Sf_BFu8ll)
//============================================================================



static void Test_BFu31ll_Sf_BFu8s()
{
  {
    init_simple_test("BFu31ll_Sf_BFu8s");
    static STRUCT_IF_C BFu31ll_Sf_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu8s");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu31ll_Sf_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu31ll_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu8s, BFu31ll_Sf_BFu8s)
//============================================================================



static void Test_BFu31ll_Sf_BFu9i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu9i");
    static STRUCT_IF_C BFu31ll_Sf_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu9i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu31ll_Sf_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu31ll_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu9i, BFu31ll_Sf_BFu9i)
//============================================================================



static void Test_BFu31ll_Sf_BFu9ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu9ll");
    static STRUCT_IF_C BFu31ll_Sf_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu9ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu31ll_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu31ll_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu9ll, BFu31ll_Sf_BFu9ll)
//============================================================================



static void Test_BFu31ll_Sf_BFu9s()
{
  {
    init_simple_test("BFu31ll_Sf_BFu9s");
    static STRUCT_IF_C BFu31ll_Sf_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu9s");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu31ll_Sf_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu31ll_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_BFu9s, BFu31ll_Sf_BFu9s)
//============================================================================



static void Test_BFu31ll_Sf_C()
{
  {
    init_simple_test("BFu31ll_Sf_C");
    static STRUCT_IF_C BFu31ll_Sf_C lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_C");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_C.v2");
    check_field_offset(lv, v3, 4, "BFu31ll_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_C, BFu31ll_Sf_C)
//============================================================================



static void Test_BFu31ll_Sf_D()
{
  {
    init_simple_test("BFu31ll_Sf_D");
    static STRUCT_IF_C BFu31ll_Sf_D lv;
    check2(sizeof(lv), 12, "sizeof(BFu31ll_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_D");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_D.v2");
    check_field_offset(lv, v3, 4, "BFu31ll_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_D, BFu31ll_Sf_D)
//============================================================================



static void Test_BFu31ll_Sf_F()
{
  {
    init_simple_test("BFu31ll_Sf_F");
    static STRUCT_IF_C BFu31ll_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_F");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu31ll_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_F, BFu31ll_Sf_F)
//============================================================================



static void Test_BFu31ll_Sf_I()
{
  {
    init_simple_test("BFu31ll_Sf_I");
    static STRUCT_IF_C BFu31ll_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_I");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu31ll_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_I, BFu31ll_Sf_I)
//============================================================================



static void Test_BFu31ll_Sf_Ip()
{
  {
    init_simple_test("BFu31ll_Sf_Ip");
    static STRUCT_IF_C BFu31ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu31ll_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_Ip");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_Ip.v2");
    check_field_offset(lv, v3, 4, "BFu31ll_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_Ip, BFu31ll_Sf_Ip)
//============================================================================



static void Test_BFu31ll_Sf_L()
{
  {
    init_simple_test("BFu31ll_Sf_L");
    static STRUCT_IF_C BFu31ll_Sf_L lv;
    check2(sizeof(lv), 12, "sizeof(BFu31ll_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_L");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_L.v2");
    check_field_offset(lv, v3, 4, "BFu31ll_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_L, BFu31ll_Sf_L)
//============================================================================



static void Test_BFu31ll_Sf_S()
{
  {
    init_simple_test("BFu31ll_Sf_S");
    static STRUCT_IF_C BFu31ll_Sf_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_S");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_S.v2");
    check_field_offset(lv, v3, 4, "BFu31ll_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_S, BFu31ll_Sf_S)
//============================================================================



static void Test_BFu31ll_Sf_Sf()
{
  {
    init_simple_test("BFu31ll_Sf_Sf");
    static STRUCT_IF_C BFu31ll_Sf_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu31ll_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu31ll_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_Sf, BFu31ll_Sf_Sf)
//============================================================================



static void Test_BFu31ll_Sf_Uc()
{
  {
    init_simple_test("BFu31ll_Sf_Uc");
    static STRUCT_IF_C BFu31ll_Sf_Uc lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_Uc");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_Uc.v2");
    check_field_offset(lv, v3, 4, "BFu31ll_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_Uc, BFu31ll_Sf_Uc)
//============================================================================



static void Test_BFu31ll_Sf_Ui()
{
  {
    init_simple_test("BFu31ll_Sf_Ui");
    static STRUCT_IF_C BFu31ll_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_Ui");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu31ll_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_Ui, BFu31ll_Sf_Ui)
//============================================================================



static void Test_BFu31ll_Sf_Ul()
{
  {
    init_simple_test("BFu31ll_Sf_Ul");
    static STRUCT_IF_C BFu31ll_Sf_Ul lv;
    check2(sizeof(lv), 12, "sizeof(BFu31ll_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_Ul");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_Ul.v2");
    check_field_offset(lv, v3, 4, "BFu31ll_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_Ul, BFu31ll_Sf_Ul)
//============================================================================



static void Test_BFu31ll_Sf_Us()
{
  {
    init_simple_test("BFu31ll_Sf_Us");
    static STRUCT_IF_C BFu31ll_Sf_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_Us");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_Us.v2");
    check_field_offset(lv, v3, 4, "BFu31ll_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_Us, BFu31ll_Sf_Us)
//============================================================================



static void Test_BFu31ll_Sf_Vp()
{
  {
    init_simple_test("BFu31ll_Sf_Vp");
    static STRUCT_IF_C BFu31ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu31ll_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_Vp");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_Vp.v2");
    check_field_offset(lv, v3, 4, "BFu31ll_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Sf_Vp, BFu31ll_Sf_Vp)
//============================================================================



static void Test_BFu31ll_Uc_Sf()
{
  {
    init_simple_test("BFu31ll_Uc_Sf");
    static STRUCT_IF_C BFu31ll_Uc_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu31ll_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Uc_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_Uc_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu31ll_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Uc_Sf, BFu31ll_Uc_Sf)
//============================================================================



static void Test_BFu31ll_Ui_Sf()
{
  {
    init_simple_test("BFu31ll_Ui_Sf");
    static STRUCT_IF_C BFu31ll_Ui_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu31ll_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Ui_Sf, BFu31ll_Ui_Sf)
//============================================================================



static void Test_BFu31ll_Ul_Sf()
{
  {
    init_simple_test("BFu31ll_Ul_Sf");
    static STRUCT_IF_C BFu31ll_Ul_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu31ll_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Ul_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_Ul_Sf.v2");
    check_field_offset(lv, v3, 12, "BFu31ll_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Ul_Sf, BFu31ll_Ul_Sf)
//============================================================================



static void Test_BFu31ll_Us_Sf()
{
  {
    init_simple_test("BFu31ll_Us_Sf");
    static STRUCT_IF_C BFu31ll_Us_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu31ll_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Us_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_Us_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu31ll_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Us_Sf, BFu31ll_Us_Sf)
//============================================================================



static void Test_BFu31ll_Vp_Sf()
{
  {
    init_simple_test("BFu31ll_Vp_Sf");
    static STRUCT_IF_C BFu31ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu31ll_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu31ll_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Vp_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "BFu31ll_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu31ll_Vp_Sf, BFu31ll_Vp_Sf)
//============================================================================



static void Test_BFu32i_BFu15i_Sf()
{
  {
    init_simple_test("BFu32i_BFu15i_Sf");
    static STRUCT_IF_C BFu32i_BFu15i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu32i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu32i_BFu15i_Sf");
    check_field_offset(lv, v3, 6, "BFu32i_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu15i_Sf, BFu32i_BFu15i_Sf)
//============================================================================



static void Test_BFu32i_BFu15ll_Sf()
{
  {
    init_simple_test("BFu32i_BFu15ll_Sf");
    static STRUCT_IF_C BFu32i_BFu15ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu32i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu32i_BFu15ll_Sf");
    check_field_offset(lv, v3, 6, "BFu32i_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu15ll_Sf, BFu32i_BFu15ll_Sf)
//============================================================================



static void Test_BFu32i_BFu15s_Sf()
{
  {
    init_simple_test("BFu32i_BFu15s_Sf");
    static STRUCT_IF_C BFu32i_BFu15s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu32i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu32i_BFu15s_Sf");
    check_field_offset(lv, v3, 6, "BFu32i_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu15s_Sf, BFu32i_BFu15s_Sf)
//============================================================================



static void Test_BFu32i_BFu16i_Sf()
{
  {
    init_simple_test("BFu32i_BFu16i_Sf");
    static STRUCT_IF_C BFu32i_BFu16i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu32i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu32i_BFu16i_Sf");
    check_field_offset(lv, v3, 6, "BFu32i_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu16i_Sf, BFu32i_BFu16i_Sf)
//============================================================================



static void Test_BFu32i_BFu16ll_Sf()
{
  {
    init_simple_test("BFu32i_BFu16ll_Sf");
    static STRUCT_IF_C BFu32i_BFu16ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu32i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu32i_BFu16ll_Sf");
    check_field_offset(lv, v3, 6, "BFu32i_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu16ll_Sf, BFu32i_BFu16ll_Sf)
//============================================================================



static void Test_BFu32i_BFu16s_Sf()
{
  {
    init_simple_test("BFu32i_BFu16s_Sf");
    static STRUCT_IF_C BFu32i_BFu16s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu32i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu32i_BFu16s_Sf");
    check_field_offset(lv, v3, 6, "BFu32i_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu16s_Sf, BFu32i_BFu16s_Sf)
//============================================================================



static void Test_BFu32i_BFu17i_Sf()
{
  {
    init_simple_test("BFu32i_BFu17i_Sf");
    static STRUCT_IF_C BFu32i_BFu17i_Sf lv;
    check2(sizeof(lv), 7, "sizeof(BFu32i_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu32i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu32i_BFu17i_Sf");
    check_field_offset(lv, v3, 7, "BFu32i_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu17i_Sf, BFu32i_BFu17i_Sf)
//============================================================================



static void Test_BFu32i_BFu17ll_Sf()
{
  {
    init_simple_test("BFu32i_BFu17ll_Sf");
    static STRUCT_IF_C BFu32i_BFu17ll_Sf lv;
    check2(sizeof(lv), 7, "sizeof(BFu32i_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu32i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu32i_BFu17ll_Sf");
    check_field_offset(lv, v3, 7, "BFu32i_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu17ll_Sf, BFu32i_BFu17ll_Sf)
//============================================================================



static void Test_BFu32i_BFu1c_Sf()
{
  {
    init_simple_test("BFu32i_BFu1c_Sf");
    static STRUCT_IF_C BFu32i_BFu1c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu32i_BFu1c_Sf");
    check_field_offset(lv, v3, 5, "BFu32i_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu1c_Sf, BFu32i_BFu1c_Sf)
//============================================================================



static void Test_BFu32i_BFu1i_Sf()
{
  {
    init_simple_test("BFu32i_BFu1i_Sf");
    static STRUCT_IF_C BFu32i_BFu1i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu32i_BFu1i_Sf");
    check_field_offset(lv, v3, 5, "BFu32i_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu1i_Sf, BFu32i_BFu1i_Sf)
//============================================================================



static void Test_BFu32i_BFu1ll_Sf()
{
  {
    init_simple_test("BFu32i_BFu1ll_Sf");
    static STRUCT_IF_C BFu32i_BFu1ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu32i_BFu1ll_Sf");
    check_field_offset(lv, v3, 5, "BFu32i_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu1ll_Sf, BFu32i_BFu1ll_Sf)
//============================================================================



static void Test_BFu32i_BFu1s_Sf()
{
  {
    init_simple_test("BFu32i_BFu1s_Sf");
    static STRUCT_IF_C BFu32i_BFu1s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu32i_BFu1s_Sf");
    check_field_offset(lv, v3, 5, "BFu32i_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu1s_Sf, BFu32i_BFu1s_Sf)
//============================================================================



static void Test_BFu32i_BFu31i_Sf()
{
  {
    init_simple_test("BFu32i_BFu31i_Sf");
    static STRUCT_IF_C BFu32i_BFu31i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu32i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu32i_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu32i_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu31i_Sf, BFu32i_BFu31i_Sf)
//============================================================================



static void Test_BFu32i_BFu31ll_Sf()
{
  {
    init_simple_test("BFu32i_BFu31ll_Sf");
    static STRUCT_IF_C BFu32i_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu32i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu32i_BFu31ll_Sf");
    check_field_offset(lv, v3, 8, "BFu32i_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu31ll_Sf, BFu32i_BFu31ll_Sf)
//============================================================================



static void Test_BFu32i_BFu32i_Sf()
{
  {
    init_simple_test("BFu32i_BFu32i_Sf");
    static STRUCT_IF_C BFu32i_BFu32i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu32i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu32i_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu32i_Sf, BFu32i_BFu32i_Sf)
//============================================================================



static void Test_BFu32i_BFu32ll_Sf()
{
  {
    init_simple_test("BFu32i_BFu32ll_Sf");
    static STRUCT_IF_C BFu32i_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu32i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu32ll_Sf");
    check_field_offset(lv, v3, 8, "BFu32i_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu32ll_Sf, BFu32i_BFu32ll_Sf)
//============================================================================



static void Test_BFu32i_BFu33_Sf()
{
  {
    init_simple_test("BFu32i_BFu33_Sf");
    static STRUCT_IF_C BFu32i_BFu33_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu32i_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu33_Sf");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "BFu32i_BFu33_Sf");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "BFu32i_BFu33_Sf");
    check_field_offset(lv, v3, 9, "BFu32i_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu33_Sf, BFu32i_BFu33_Sf)
//============================================================================



static void Test_BFu32i_BFu7c_Sf()
{
  {
    init_simple_test("BFu32i_BFu7c_Sf");
    static STRUCT_IF_C BFu32i_BFu7c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu32i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu32i_BFu7c_Sf");
    check_field_offset(lv, v3, 5, "BFu32i_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu7c_Sf, BFu32i_BFu7c_Sf)
//============================================================================



static void Test_BFu32i_BFu7i_Sf()
{
  {
    init_simple_test("BFu32i_BFu7i_Sf");
    static STRUCT_IF_C BFu32i_BFu7i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu32i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu32i_BFu7i_Sf");
    check_field_offset(lv, v3, 5, "BFu32i_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu7i_Sf, BFu32i_BFu7i_Sf)
//============================================================================



static void Test_BFu32i_BFu7ll_Sf()
{
  {
    init_simple_test("BFu32i_BFu7ll_Sf");
    static STRUCT_IF_C BFu32i_BFu7ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu32i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu32i_BFu7ll_Sf");
    check_field_offset(lv, v3, 5, "BFu32i_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu7ll_Sf, BFu32i_BFu7ll_Sf)
//============================================================================



static void Test_BFu32i_BFu7s_Sf()
{
  {
    init_simple_test("BFu32i_BFu7s_Sf");
    static STRUCT_IF_C BFu32i_BFu7s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu32i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu32i_BFu7s_Sf");
    check_field_offset(lv, v3, 5, "BFu32i_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu7s_Sf, BFu32i_BFu7s_Sf)
//============================================================================



static void Test_BFu32i_BFu8c_Sf()
{
  {
    init_simple_test("BFu32i_BFu8c_Sf");
    static STRUCT_IF_C BFu32i_BFu8c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu32i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu32i_BFu8c_Sf");
    check_field_offset(lv, v3, 5, "BFu32i_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu8c_Sf, BFu32i_BFu8c_Sf)
//============================================================================



static void Test_BFu32i_BFu8i_Sf()
{
  {
    init_simple_test("BFu32i_BFu8i_Sf");
    static STRUCT_IF_C BFu32i_BFu8i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu32i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu32i_BFu8i_Sf");
    check_field_offset(lv, v3, 5, "BFu32i_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu8i_Sf, BFu32i_BFu8i_Sf)
//============================================================================



static void Test_BFu32i_BFu8ll_Sf()
{
  {
    init_simple_test("BFu32i_BFu8ll_Sf");
    static STRUCT_IF_C BFu32i_BFu8ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu32i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu32i_BFu8ll_Sf");
    check_field_offset(lv, v3, 5, "BFu32i_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu8ll_Sf, BFu32i_BFu8ll_Sf)
//============================================================================



static void Test_BFu32i_BFu8s_Sf()
{
  {
    init_simple_test("BFu32i_BFu8s_Sf");
    static STRUCT_IF_C BFu32i_BFu8s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu32i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu32i_BFu8s_Sf");
    check_field_offset(lv, v3, 5, "BFu32i_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu8s_Sf, BFu32i_BFu8s_Sf)
//============================================================================



static void Test_BFu32i_BFu9i_Sf()
{
  {
    init_simple_test("BFu32i_BFu9i_Sf");
    static STRUCT_IF_C BFu32i_BFu9i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu32i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu32i_BFu9i_Sf");
    check_field_offset(lv, v3, 6, "BFu32i_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu9i_Sf, BFu32i_BFu9i_Sf)
//============================================================================



static void Test_BFu32i_BFu9ll_Sf()
{
  {
    init_simple_test("BFu32i_BFu9ll_Sf");
    static STRUCT_IF_C BFu32i_BFu9ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu32i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu32i_BFu9ll_Sf");
    check_field_offset(lv, v3, 6, "BFu32i_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu9ll_Sf, BFu32i_BFu9ll_Sf)
//============================================================================



static void Test_BFu32i_BFu9s_Sf()
{
  {
    init_simple_test("BFu32i_BFu9s_Sf");
    static STRUCT_IF_C BFu32i_BFu9s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu32i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu32i_BFu9s_Sf");
    check_field_offset(lv, v3, 6, "BFu32i_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_BFu9s_Sf, BFu32i_BFu9s_Sf)
//============================================================================



static void Test_BFu32i_C_Sf()
{
  {
    init_simple_test("BFu32i_C_Sf");
    static STRUCT_IF_C BFu32i_C_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_C_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_C_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu32i_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_C_Sf, BFu32i_C_Sf)
//============================================================================



static void Test_BFu32i_D_Sf()
{
  {
    init_simple_test("BFu32i_D_Sf");
    static STRUCT_IF_C BFu32i_D_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu32i_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_D_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_D_Sf.v2");
    check_field_offset(lv, v3, 12, "BFu32i_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_D_Sf, BFu32i_D_Sf)
//============================================================================



static void Test_BFu32i_F_Sf()
{
  {
    init_simple_test("BFu32i_F_Sf");
    static STRUCT_IF_C BFu32i_F_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_F_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu32i_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_F_Sf, BFu32i_F_Sf)
//============================================================================



static void Test_BFu32i_I_Sf()
{
  {
    init_simple_test("BFu32i_I_Sf");
    static STRUCT_IF_C BFu32i_I_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_I_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu32i_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_I_Sf, BFu32i_I_Sf)
//============================================================================



static void Test_BFu32i_Ip_Sf()
{
  {
    init_simple_test("BFu32i_Ip_Sf");
    static STRUCT_IF_C BFu32i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu32i_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Ip_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "BFu32i_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Ip_Sf, BFu32i_Ip_Sf)
//============================================================================



static void Test_BFu32i_L_Sf()
{
  {
    init_simple_test("BFu32i_L_Sf");
    static STRUCT_IF_C BFu32i_L_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu32i_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_L_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_L_Sf.v2");
    check_field_offset(lv, v3, 12, "BFu32i_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_L_Sf, BFu32i_L_Sf)
//============================================================================



static void Test_BFu32i_S_Sf()
{
  {
    init_simple_test("BFu32i_S_Sf");
    static STRUCT_IF_C BFu32i_S_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_S_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_S_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu32i_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_S_Sf, BFu32i_S_Sf)
//============================================================================



static void Test_BFu32i_Sf()
{
  {
    init_simple_test("BFu32i_Sf");
    static STRUCT_IF_C BFu32i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf, BFu32i_Sf)
//============================================================================



static void Test_BFu32i_Sf_BFu15i()
{
  {
    init_simple_test("BFu32i_Sf_BFu15i");
    static STRUCT_IF_C BFu32i_Sf_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu15i");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu32i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu32i_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu15i, BFu32i_Sf_BFu15i)
//============================================================================



static void Test_BFu32i_Sf_BFu15ll()
{
  {
    init_simple_test("BFu32i_Sf_BFu15ll");
    static STRUCT_IF_C BFu32i_Sf_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu15ll");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu32i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu32i_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu15ll, BFu32i_Sf_BFu15ll)
//============================================================================



static void Test_BFu32i_Sf_BFu15s()
{
  {
    init_simple_test("BFu32i_Sf_BFu15s");
    static STRUCT_IF_C BFu32i_Sf_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu15s");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu32i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu32i_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu15s, BFu32i_Sf_BFu15s)
//============================================================================



static void Test_BFu32i_Sf_BFu16i()
{
  {
    init_simple_test("BFu32i_Sf_BFu16i");
    static STRUCT_IF_C BFu32i_Sf_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu16i");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu32i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu32i_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu16i, BFu32i_Sf_BFu16i)
//============================================================================



static void Test_BFu32i_Sf_BFu16ll()
{
  {
    init_simple_test("BFu32i_Sf_BFu16ll");
    static STRUCT_IF_C BFu32i_Sf_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu16ll");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu32i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu32i_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu16ll, BFu32i_Sf_BFu16ll)
//============================================================================



static void Test_BFu32i_Sf_BFu16s()
{
  {
    init_simple_test("BFu32i_Sf_BFu16s");
    static STRUCT_IF_C BFu32i_Sf_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu16s");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu32i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu32i_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu16s, BFu32i_Sf_BFu16s)
//============================================================================



static void Test_BFu32i_Sf_BFu17i()
{
  {
    init_simple_test("BFu32i_Sf_BFu17i");
    static STRUCT_IF_C BFu32i_Sf_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(BFu32i_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu17i");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu32i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu32i_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu17i, BFu32i_Sf_BFu17i)
//============================================================================



static void Test_BFu32i_Sf_BFu17ll()
{
  {
    init_simple_test("BFu32i_Sf_BFu17ll");
    static STRUCT_IF_C BFu32i_Sf_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu32i_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu17ll");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu32i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu32i_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu17ll, BFu32i_Sf_BFu17ll)
//============================================================================



static void Test_BFu32i_Sf_BFu1c()
{
  {
    init_simple_test("BFu32i_Sf_BFu1c");
    static STRUCT_IF_C BFu32i_Sf_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu1c");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu32i_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu1c, BFu32i_Sf_BFu1c)
//============================================================================



static void Test_BFu32i_Sf_BFu1i()
{
  {
    init_simple_test("BFu32i_Sf_BFu1i");
    static STRUCT_IF_C BFu32i_Sf_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu1i");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu32i_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu1i, BFu32i_Sf_BFu1i)
//============================================================================



static void Test_BFu32i_Sf_BFu1ll()
{
  {
    init_simple_test("BFu32i_Sf_BFu1ll");
    static STRUCT_IF_C BFu32i_Sf_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu1ll");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu32i_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu1ll, BFu32i_Sf_BFu1ll)
//============================================================================



static void Test_BFu32i_Sf_BFu1s()
{
  {
    init_simple_test("BFu32i_Sf_BFu1s");
    static STRUCT_IF_C BFu32i_Sf_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu1s");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu32i_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu1s, BFu32i_Sf_BFu1s)
//============================================================================



static void Test_BFu32i_Sf_BFu31i()
{
  {
    init_simple_test("BFu32i_Sf_BFu31i");
    static STRUCT_IF_C BFu32i_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu31i");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu32i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu32i_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu31i, BFu32i_Sf_BFu31i)
//============================================================================



static void Test_BFu32i_Sf_BFu31ll()
{
  {
    init_simple_test("BFu32i_Sf_BFu31ll");
    static STRUCT_IF_C BFu32i_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu31ll");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu32i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu32i_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu31ll, BFu32i_Sf_BFu31ll)
//============================================================================



static void Test_BFu32i_Sf_BFu32i()
{
  {
    init_simple_test("BFu32i_Sf_BFu32i");
    static STRUCT_IF_C BFu32i_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu32i");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu32i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu32i, BFu32i_Sf_BFu32i)
//============================================================================



static void Test_BFu32i_Sf_BFu32ll()
{
  {
    init_simple_test("BFu32i_Sf_BFu32ll");
    static STRUCT_IF_C BFu32i_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu32ll");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu32i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu32ll, BFu32i_Sf_BFu32ll)
//============================================================================



static void Test_BFu32i_Sf_BFu33()
{
  {
    init_simple_test("BFu32i_Sf_BFu33");
    static STRUCT_IF_C BFu32i_Sf_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(BFu32i_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu33");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "BFu32i_Sf_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "BFu32i_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu33, BFu32i_Sf_BFu33)
//============================================================================



static void Test_BFu32i_Sf_BFu7c()
{
  {
    init_simple_test("BFu32i_Sf_BFu7c");
    static STRUCT_IF_C BFu32i_Sf_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu7c");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu32i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu32i_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu7c, BFu32i_Sf_BFu7c)
//============================================================================



static void Test_BFu32i_Sf_BFu7i()
{
  {
    init_simple_test("BFu32i_Sf_BFu7i");
    static STRUCT_IF_C BFu32i_Sf_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu7i");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu32i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu32i_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu7i, BFu32i_Sf_BFu7i)
//============================================================================



static void Test_BFu32i_Sf_BFu7ll()
{
  {
    init_simple_test("BFu32i_Sf_BFu7ll");
    static STRUCT_IF_C BFu32i_Sf_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu7ll");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu32i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu32i_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu7ll, BFu32i_Sf_BFu7ll)
//============================================================================



static void Test_BFu32i_Sf_BFu7s()
{
  {
    init_simple_test("BFu32i_Sf_BFu7s");
    static STRUCT_IF_C BFu32i_Sf_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu7s");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu32i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu32i_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu7s, BFu32i_Sf_BFu7s)
//============================================================================



static void Test_BFu32i_Sf_BFu8c()
{
  {
    init_simple_test("BFu32i_Sf_BFu8c");
    static STRUCT_IF_C BFu32i_Sf_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu8c");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu32i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu32i_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu8c, BFu32i_Sf_BFu8c)
//============================================================================



static void Test_BFu32i_Sf_BFu8i()
{
  {
    init_simple_test("BFu32i_Sf_BFu8i");
    static STRUCT_IF_C BFu32i_Sf_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu8i");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu32i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu32i_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu8i, BFu32i_Sf_BFu8i)
//============================================================================



static void Test_BFu32i_Sf_BFu8ll()
{
  {
    init_simple_test("BFu32i_Sf_BFu8ll");
    static STRUCT_IF_C BFu32i_Sf_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu8ll");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu32i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu32i_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu8ll, BFu32i_Sf_BFu8ll)
//============================================================================



static void Test_BFu32i_Sf_BFu8s()
{
  {
    init_simple_test("BFu32i_Sf_BFu8s");
    static STRUCT_IF_C BFu32i_Sf_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu8s");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu32i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu32i_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu8s, BFu32i_Sf_BFu8s)
//============================================================================



static void Test_BFu32i_Sf_BFu9i()
{
  {
    init_simple_test("BFu32i_Sf_BFu9i");
    static STRUCT_IF_C BFu32i_Sf_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu9i");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu32i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu32i_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu9i, BFu32i_Sf_BFu9i)
//============================================================================



static void Test_BFu32i_Sf_BFu9ll()
{
  {
    init_simple_test("BFu32i_Sf_BFu9ll");
    static STRUCT_IF_C BFu32i_Sf_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu9ll");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu32i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu32i_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu9ll, BFu32i_Sf_BFu9ll)
//============================================================================



static void Test_BFu32i_Sf_BFu9s()
{
  {
    init_simple_test("BFu32i_Sf_BFu9s");
    static STRUCT_IF_C BFu32i_Sf_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_BFu9s");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu32i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu32i_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_BFu9s, BFu32i_Sf_BFu9s)
//============================================================================



static void Test_BFu32i_Sf_C()
{
  {
    init_simple_test("BFu32i_Sf_C");
    static STRUCT_IF_C BFu32i_Sf_C lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_C");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_C.v2");
    check_field_offset(lv, v3, 4, "BFu32i_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_C, BFu32i_Sf_C)
//============================================================================



static void Test_BFu32i_Sf_D()
{
  {
    init_simple_test("BFu32i_Sf_D");
    static STRUCT_IF_C BFu32i_Sf_D lv;
    check2(sizeof(lv), 12, "sizeof(BFu32i_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_D");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_D.v2");
    check_field_offset(lv, v3, 4, "BFu32i_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_D, BFu32i_Sf_D)
//============================================================================



static void Test_BFu32i_Sf_F()
{
  {
    init_simple_test("BFu32i_Sf_F");
    static STRUCT_IF_C BFu32i_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_F");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu32i_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_F, BFu32i_Sf_F)
//============================================================================



static void Test_BFu32i_Sf_I()
{
  {
    init_simple_test("BFu32i_Sf_I");
    static STRUCT_IF_C BFu32i_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_I");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu32i_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_I, BFu32i_Sf_I)
//============================================================================



static void Test_BFu32i_Sf_Ip()
{
  {
    init_simple_test("BFu32i_Sf_Ip");
    static STRUCT_IF_C BFu32i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu32i_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_Ip");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_Ip.v2");
    check_field_offset(lv, v3, 4, "BFu32i_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_Ip, BFu32i_Sf_Ip)
//============================================================================



static void Test_BFu32i_Sf_L()
{
  {
    init_simple_test("BFu32i_Sf_L");
    static STRUCT_IF_C BFu32i_Sf_L lv;
    check2(sizeof(lv), 12, "sizeof(BFu32i_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_L");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_L.v2");
    check_field_offset(lv, v3, 4, "BFu32i_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_L, BFu32i_Sf_L)
//============================================================================



static void Test_BFu32i_Sf_S()
{
  {
    init_simple_test("BFu32i_Sf_S");
    static STRUCT_IF_C BFu32i_Sf_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_S");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_S.v2");
    check_field_offset(lv, v3, 4, "BFu32i_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_S, BFu32i_Sf_S)
//============================================================================



static void Test_BFu32i_Sf_Sf()
{
  {
    init_simple_test("BFu32i_Sf_Sf");
    static STRUCT_IF_C BFu32i_Sf_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu32i_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu32i_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_Sf, BFu32i_Sf_Sf)
//============================================================================



static void Test_BFu32i_Sf_Uc()
{
  {
    init_simple_test("BFu32i_Sf_Uc");
    static STRUCT_IF_C BFu32i_Sf_Uc lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_Uc");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_Uc.v2");
    check_field_offset(lv, v3, 4, "BFu32i_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_Uc, BFu32i_Sf_Uc)
//============================================================================



static void Test_BFu32i_Sf_Ui()
{
  {
    init_simple_test("BFu32i_Sf_Ui");
    static STRUCT_IF_C BFu32i_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_Ui");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu32i_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_Ui, BFu32i_Sf_Ui)
//============================================================================



static void Test_BFu32i_Sf_Ul()
{
  {
    init_simple_test("BFu32i_Sf_Ul");
    static STRUCT_IF_C BFu32i_Sf_Ul lv;
    check2(sizeof(lv), 12, "sizeof(BFu32i_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_Ul");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_Ul.v2");
    check_field_offset(lv, v3, 4, "BFu32i_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_Ul, BFu32i_Sf_Ul)
//============================================================================



static void Test_BFu32i_Sf_Us()
{
  {
    init_simple_test("BFu32i_Sf_Us");
    static STRUCT_IF_C BFu32i_Sf_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_Us");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_Us.v2");
    check_field_offset(lv, v3, 4, "BFu32i_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_Us, BFu32i_Sf_Us)
//============================================================================



static void Test_BFu32i_Sf_Vp()
{
  {
    init_simple_test("BFu32i_Sf_Vp");
    static STRUCT_IF_C BFu32i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu32i_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Sf_Vp");
    check_field_offset(lv, v2, 4, "BFu32i_Sf_Vp.v2");
    check_field_offset(lv, v3, 4, "BFu32i_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Sf_Vp, BFu32i_Sf_Vp)
//============================================================================



static void Test_BFu32i_Uc_Sf()
{
  {
    init_simple_test("BFu32i_Uc_Sf");
    static STRUCT_IF_C BFu32i_Uc_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32i_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Uc_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_Uc_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu32i_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Uc_Sf, BFu32i_Uc_Sf)
//============================================================================



static void Test_BFu32i_Ui_Sf()
{
  {
    init_simple_test("BFu32i_Ui_Sf");
    static STRUCT_IF_C BFu32i_Ui_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32i_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu32i_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Ui_Sf, BFu32i_Ui_Sf)
//============================================================================



static void Test_BFu32i_Ul_Sf()
{
  {
    init_simple_test("BFu32i_Ul_Sf");
    static STRUCT_IF_C BFu32i_Ul_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu32i_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Ul_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_Ul_Sf.v2");
    check_field_offset(lv, v3, 12, "BFu32i_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Ul_Sf, BFu32i_Ul_Sf)
//============================================================================



static void Test_BFu32i_Us_Sf()
{
  {
    init_simple_test("BFu32i_Us_Sf");
    static STRUCT_IF_C BFu32i_Us_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32i_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Us_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_Us_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu32i_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Us_Sf, BFu32i_Us_Sf)
//============================================================================



static void Test_BFu32i_Vp_Sf()
{
  {
    init_simple_test("BFu32i_Vp_Sf");
    static STRUCT_IF_C BFu32i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu32i_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32i_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32i_Vp_Sf");
    check_field_offset(lv, v2, 4, "BFu32i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "BFu32i_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32i_Vp_Sf, BFu32i_Vp_Sf)
//============================================================================



static void Test_BFu32ll_BFu15i_Sf()
{
  {
    init_simple_test("BFu32ll_BFu15i_Sf");
    static STRUCT_IF_C BFu32ll_BFu15i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu32ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu32ll_BFu15i_Sf");
    check_field_offset(lv, v3, 6, "BFu32ll_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu15i_Sf, BFu32ll_BFu15i_Sf)
//============================================================================



static void Test_BFu32ll_BFu15ll_Sf()
{
  {
    init_simple_test("BFu32ll_BFu15ll_Sf");
    static STRUCT_IF_C BFu32ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu32ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu32ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 6, "BFu32ll_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu15ll_Sf, BFu32ll_BFu15ll_Sf)
//============================================================================



static void Test_BFu32ll_BFu15s_Sf()
{
  {
    init_simple_test("BFu32ll_BFu15s_Sf");
    static STRUCT_IF_C BFu32ll_BFu15s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu32ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu32ll_BFu15s_Sf");
    check_field_offset(lv, v3, 6, "BFu32ll_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu15s_Sf, BFu32ll_BFu15s_Sf)
//============================================================================



static void Test_BFu32ll_BFu16i_Sf()
{
  {
    init_simple_test("BFu32ll_BFu16i_Sf");
    static STRUCT_IF_C BFu32ll_BFu16i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu32ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu32ll_BFu16i_Sf");
    check_field_offset(lv, v3, 6, "BFu32ll_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu16i_Sf, BFu32ll_BFu16i_Sf)
//============================================================================



static void Test_BFu32ll_BFu16ll_Sf()
{
  {
    init_simple_test("BFu32ll_BFu16ll_Sf");
    static STRUCT_IF_C BFu32ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu32ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu32ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 6, "BFu32ll_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu16ll_Sf, BFu32ll_BFu16ll_Sf)
//============================================================================



static void Test_BFu32ll_BFu16s_Sf()
{
  {
    init_simple_test("BFu32ll_BFu16s_Sf");
    static STRUCT_IF_C BFu32ll_BFu16s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu32ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu32ll_BFu16s_Sf");
    check_field_offset(lv, v3, 6, "BFu32ll_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu16s_Sf, BFu32ll_BFu16s_Sf)
//============================================================================



static void Test_BFu32ll_BFu17i_Sf()
{
  {
    init_simple_test("BFu32ll_BFu17i_Sf");
    static STRUCT_IF_C BFu32ll_BFu17i_Sf lv;
    check2(sizeof(lv), 7, "sizeof(BFu32ll_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu32ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu32ll_BFu17i_Sf");
    check_field_offset(lv, v3, 7, "BFu32ll_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu17i_Sf, BFu32ll_BFu17i_Sf)
//============================================================================



static void Test_BFu32ll_BFu17ll_Sf()
{
  {
    init_simple_test("BFu32ll_BFu17ll_Sf");
    static STRUCT_IF_C BFu32ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 7, "sizeof(BFu32ll_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu32ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu32ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 7, "BFu32ll_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu17ll_Sf, BFu32ll_BFu17ll_Sf)
//============================================================================



static void Test_BFu32ll_BFu1c_Sf()
{
  {
    init_simple_test("BFu32ll_BFu1c_Sf");
    static STRUCT_IF_C BFu32ll_BFu1c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu32ll_BFu1c_Sf");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu1c_Sf, BFu32ll_BFu1c_Sf)
//============================================================================



static void Test_BFu32ll_BFu1i_Sf()
{
  {
    init_simple_test("BFu32ll_BFu1i_Sf");
    static STRUCT_IF_C BFu32ll_BFu1i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu32ll_BFu1i_Sf");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu1i_Sf, BFu32ll_BFu1i_Sf)
//============================================================================



static void Test_BFu32ll_BFu1ll_Sf()
{
  {
    init_simple_test("BFu32ll_BFu1ll_Sf");
    static STRUCT_IF_C BFu32ll_BFu1ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu32ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu1ll_Sf, BFu32ll_BFu1ll_Sf)
//============================================================================



static void Test_BFu32ll_BFu1s_Sf()
{
  {
    init_simple_test("BFu32ll_BFu1s_Sf");
    static STRUCT_IF_C BFu32ll_BFu1s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu32ll_BFu1s_Sf");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu1s_Sf, BFu32ll_BFu1s_Sf)
//============================================================================



static void Test_BFu32ll_BFu31i_Sf()
{
  {
    init_simple_test("BFu32ll_BFu31i_Sf");
    static STRUCT_IF_C BFu32ll_BFu31i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu32ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu32ll_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu32ll_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu31i_Sf, BFu32ll_BFu31i_Sf)
//============================================================================



static void Test_BFu32ll_BFu31ll_Sf()
{
  {
    init_simple_test("BFu32ll_BFu31ll_Sf");
    static STRUCT_IF_C BFu32ll_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu32ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu32ll_BFu31ll_Sf");
    check_field_offset(lv, v3, 8, "BFu32ll_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu31ll_Sf, BFu32ll_BFu31ll_Sf)
//============================================================================



static void Test_BFu32ll_BFu32i_Sf()
{
  {
    init_simple_test("BFu32ll_BFu32i_Sf");
    static STRUCT_IF_C BFu32ll_BFu32i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu32ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu32ll_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu32i_Sf, BFu32ll_BFu32i_Sf)
//============================================================================



static void Test_BFu32ll_BFu32ll_Sf()
{
  {
    init_simple_test("BFu32ll_BFu32ll_Sf");
    static STRUCT_IF_C BFu32ll_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu32ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu32ll_Sf");
    check_field_offset(lv, v3, 8, "BFu32ll_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu32ll_Sf, BFu32ll_BFu32ll_Sf)
//============================================================================



static void Test_BFu32ll_BFu33_Sf()
{
  {
    init_simple_test("BFu32ll_BFu33_Sf");
    static STRUCT_IF_C BFu32ll_BFu33_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu32ll_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "BFu32ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "BFu32ll_BFu33_Sf");
    check_field_offset(lv, v3, 9, "BFu32ll_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu33_Sf, BFu32ll_BFu33_Sf)
//============================================================================



static void Test_BFu32ll_BFu7c_Sf()
{
  {
    init_simple_test("BFu32ll_BFu7c_Sf");
    static STRUCT_IF_C BFu32ll_BFu7c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu32ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu32ll_BFu7c_Sf");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu7c_Sf, BFu32ll_BFu7c_Sf)
//============================================================================



static void Test_BFu32ll_BFu7i_Sf()
{
  {
    init_simple_test("BFu32ll_BFu7i_Sf");
    static STRUCT_IF_C BFu32ll_BFu7i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu32ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu32ll_BFu7i_Sf");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu7i_Sf, BFu32ll_BFu7i_Sf)
//============================================================================



static void Test_BFu32ll_BFu7ll_Sf()
{
  {
    init_simple_test("BFu32ll_BFu7ll_Sf");
    static STRUCT_IF_C BFu32ll_BFu7ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu32ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu32ll_BFu7ll_Sf");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu7ll_Sf, BFu32ll_BFu7ll_Sf)
//============================================================================



static void Test_BFu32ll_BFu7s_Sf()
{
  {
    init_simple_test("BFu32ll_BFu7s_Sf");
    static STRUCT_IF_C BFu32ll_BFu7s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu32ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu32ll_BFu7s_Sf");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu7s_Sf, BFu32ll_BFu7s_Sf)
//============================================================================



static void Test_BFu32ll_BFu8c_Sf()
{
  {
    init_simple_test("BFu32ll_BFu8c_Sf");
    static STRUCT_IF_C BFu32ll_BFu8c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu32ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu32ll_BFu8c_Sf");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu8c_Sf, BFu32ll_BFu8c_Sf)
//============================================================================



static void Test_BFu32ll_BFu8i_Sf()
{
  {
    init_simple_test("BFu32ll_BFu8i_Sf");
    static STRUCT_IF_C BFu32ll_BFu8i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu32ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu32ll_BFu8i_Sf");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu8i_Sf, BFu32ll_BFu8i_Sf)
//============================================================================



static void Test_BFu32ll_BFu8ll_Sf()
{
  {
    init_simple_test("BFu32ll_BFu8ll_Sf");
    static STRUCT_IF_C BFu32ll_BFu8ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu32ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu32ll_BFu8ll_Sf");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu8ll_Sf, BFu32ll_BFu8ll_Sf)
//============================================================================



static void Test_BFu32ll_BFu8s_Sf()
{
  {
    init_simple_test("BFu32ll_BFu8s_Sf");
    static STRUCT_IF_C BFu32ll_BFu8s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu32ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu32ll_BFu8s_Sf");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu8s_Sf, BFu32ll_BFu8s_Sf)
//============================================================================



static void Test_BFu32ll_BFu9i_Sf()
{
  {
    init_simple_test("BFu32ll_BFu9i_Sf");
    static STRUCT_IF_C BFu32ll_BFu9i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu32ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu32ll_BFu9i_Sf");
    check_field_offset(lv, v3, 6, "BFu32ll_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu9i_Sf, BFu32ll_BFu9i_Sf)
//============================================================================



static void Test_BFu32ll_BFu9ll_Sf()
{
  {
    init_simple_test("BFu32ll_BFu9ll_Sf");
    static STRUCT_IF_C BFu32ll_BFu9ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu32ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu32ll_BFu9ll_Sf");
    check_field_offset(lv, v3, 6, "BFu32ll_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu9ll_Sf, BFu32ll_BFu9ll_Sf)
//============================================================================



static void Test_BFu32ll_BFu9s_Sf()
{
  {
    init_simple_test("BFu32ll_BFu9s_Sf");
    static STRUCT_IF_C BFu32ll_BFu9s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu32ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu32ll_BFu9s_Sf");
    check_field_offset(lv, v3, 6, "BFu32ll_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_BFu9s_Sf, BFu32ll_BFu9s_Sf)
//============================================================================



static void Test_BFu32ll_C_Sf()
{
  {
    init_simple_test("BFu32ll_C_Sf");
    static STRUCT_IF_C BFu32ll_C_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_C_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_C_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu32ll_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_C_Sf, BFu32ll_C_Sf)
//============================================================================



static void Test_BFu32ll_D_Sf()
{
  {
    init_simple_test("BFu32ll_D_Sf");
    static STRUCT_IF_C BFu32ll_D_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu32ll_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_D_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_D_Sf.v2");
    check_field_offset(lv, v3, 12, "BFu32ll_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_D_Sf, BFu32ll_D_Sf)
//============================================================================



static void Test_BFu32ll_F_Sf()
{
  {
    init_simple_test("BFu32ll_F_Sf");
    static STRUCT_IF_C BFu32ll_F_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_F_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu32ll_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_F_Sf, BFu32ll_F_Sf)
//============================================================================



static void Test_BFu32ll_I_Sf()
{
  {
    init_simple_test("BFu32ll_I_Sf");
    static STRUCT_IF_C BFu32ll_I_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_I_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu32ll_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_I_Sf, BFu32ll_I_Sf)
//============================================================================



static void Test_BFu32ll_Ip_Sf()
{
  {
    init_simple_test("BFu32ll_Ip_Sf");
    static STRUCT_IF_C BFu32ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu32ll_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Ip_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "BFu32ll_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Ip_Sf, BFu32ll_Ip_Sf)
//============================================================================



static void Test_BFu32ll_L_Sf()
{
  {
    init_simple_test("BFu32ll_L_Sf");
    static STRUCT_IF_C BFu32ll_L_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu32ll_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_L_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_L_Sf.v2");
    check_field_offset(lv, v3, 12, "BFu32ll_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_L_Sf, BFu32ll_L_Sf)
//============================================================================



static void Test_BFu32ll_S_Sf()
{
  {
    init_simple_test("BFu32ll_S_Sf");
    static STRUCT_IF_C BFu32ll_S_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_S_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_S_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu32ll_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_S_Sf, BFu32ll_S_Sf)
//============================================================================



static void Test_BFu32ll_Sf()
{
  {
    init_simple_test("BFu32ll_Sf");
    static STRUCT_IF_C BFu32ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf, BFu32ll_Sf)
//============================================================================



static void Test_BFu32ll_Sf_BFu15i()
{
  {
    init_simple_test("BFu32ll_Sf_BFu15i");
    static STRUCT_IF_C BFu32ll_Sf_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu15i");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu32ll_Sf_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu32ll_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu15i, BFu32ll_Sf_BFu15i)
//============================================================================



static void Test_BFu32ll_Sf_BFu15ll()
{
  {
    init_simple_test("BFu32ll_Sf_BFu15ll");
    static STRUCT_IF_C BFu32ll_Sf_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu15ll");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu32ll_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu32ll_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu15ll, BFu32ll_Sf_BFu15ll)
//============================================================================



static void Test_BFu32ll_Sf_BFu15s()
{
  {
    init_simple_test("BFu32ll_Sf_BFu15s");
    static STRUCT_IF_C BFu32ll_Sf_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu15s");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu32ll_Sf_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu32ll_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu15s, BFu32ll_Sf_BFu15s)
//============================================================================



static void Test_BFu32ll_Sf_BFu16i()
{
  {
    init_simple_test("BFu32ll_Sf_BFu16i");
    static STRUCT_IF_C BFu32ll_Sf_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu16i");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu32ll_Sf_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu32ll_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu16i, BFu32ll_Sf_BFu16i)
//============================================================================



static void Test_BFu32ll_Sf_BFu16ll()
{
  {
    init_simple_test("BFu32ll_Sf_BFu16ll");
    static STRUCT_IF_C BFu32ll_Sf_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu16ll");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu32ll_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu32ll_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu16ll, BFu32ll_Sf_BFu16ll)
//============================================================================



static void Test_BFu32ll_Sf_BFu16s()
{
  {
    init_simple_test("BFu32ll_Sf_BFu16s");
    static STRUCT_IF_C BFu32ll_Sf_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu16s");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu32ll_Sf_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu32ll_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu16s, BFu32ll_Sf_BFu16s)
//============================================================================



static void Test_BFu32ll_Sf_BFu17i()
{
  {
    init_simple_test("BFu32ll_Sf_BFu17i");
    static STRUCT_IF_C BFu32ll_Sf_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(BFu32ll_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu17i");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu32ll_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu32ll_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu17i, BFu32ll_Sf_BFu17i)
//============================================================================



static void Test_BFu32ll_Sf_BFu17ll()
{
  {
    init_simple_test("BFu32ll_Sf_BFu17ll");
    static STRUCT_IF_C BFu32ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu32ll_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu17ll");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu32ll_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu32ll_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu17ll, BFu32ll_Sf_BFu17ll)
//============================================================================



static void Test_BFu32ll_Sf_BFu1c()
{
  {
    init_simple_test("BFu32ll_Sf_BFu1c");
    static STRUCT_IF_C BFu32ll_Sf_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu1c");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu32ll_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu1c, BFu32ll_Sf_BFu1c)
//============================================================================



static void Test_BFu32ll_Sf_BFu1i()
{
  {
    init_simple_test("BFu32ll_Sf_BFu1i");
    static STRUCT_IF_C BFu32ll_Sf_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu1i");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu32ll_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu1i, BFu32ll_Sf_BFu1i)
//============================================================================



static void Test_BFu32ll_Sf_BFu1ll()
{
  {
    init_simple_test("BFu32ll_Sf_BFu1ll");
    static STRUCT_IF_C BFu32ll_Sf_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu1ll");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu32ll_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu1ll, BFu32ll_Sf_BFu1ll)
//============================================================================



static void Test_BFu32ll_Sf_BFu1s()
{
  {
    init_simple_test("BFu32ll_Sf_BFu1s");
    static STRUCT_IF_C BFu32ll_Sf_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu1s");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu32ll_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu1s, BFu32ll_Sf_BFu1s)
//============================================================================



static void Test_BFu32ll_Sf_BFu31i()
{
  {
    init_simple_test("BFu32ll_Sf_BFu31i");
    static STRUCT_IF_C BFu32ll_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu31i");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu32ll_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu32ll_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu31i, BFu32ll_Sf_BFu31i)
//============================================================================



static void Test_BFu32ll_Sf_BFu31ll()
{
  {
    init_simple_test("BFu32ll_Sf_BFu31ll");
    static STRUCT_IF_C BFu32ll_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu31ll");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu32ll_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu32ll_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu31ll, BFu32ll_Sf_BFu31ll)
//============================================================================



static void Test_BFu32ll_Sf_BFu32i()
{
  {
    init_simple_test("BFu32ll_Sf_BFu32i");
    static STRUCT_IF_C BFu32ll_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu32i");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu32ll_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu32i, BFu32ll_Sf_BFu32i)
//============================================================================



static void Test_BFu32ll_Sf_BFu32ll()
{
  {
    init_simple_test("BFu32ll_Sf_BFu32ll");
    static STRUCT_IF_C BFu32ll_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu32ll");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu32ll_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu32ll, BFu32ll_Sf_BFu32ll)
//============================================================================



static void Test_BFu32ll_Sf_BFu33()
{
  {
    init_simple_test("BFu32ll_Sf_BFu33");
    static STRUCT_IF_C BFu32ll_Sf_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(BFu32ll_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu33");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "BFu32ll_Sf_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "BFu32ll_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu33, BFu32ll_Sf_BFu33)
//============================================================================



static void Test_BFu32ll_Sf_BFu7c()
{
  {
    init_simple_test("BFu32ll_Sf_BFu7c");
    static STRUCT_IF_C BFu32ll_Sf_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu7c");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu32ll_Sf_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu32ll_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu7c, BFu32ll_Sf_BFu7c)
//============================================================================



static void Test_BFu32ll_Sf_BFu7i()
{
  {
    init_simple_test("BFu32ll_Sf_BFu7i");
    static STRUCT_IF_C BFu32ll_Sf_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu7i");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu32ll_Sf_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu32ll_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu7i, BFu32ll_Sf_BFu7i)
//============================================================================



static void Test_BFu32ll_Sf_BFu7ll()
{
  {
    init_simple_test("BFu32ll_Sf_BFu7ll");
    static STRUCT_IF_C BFu32ll_Sf_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu7ll");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu32ll_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu32ll_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu7ll, BFu32ll_Sf_BFu7ll)
//============================================================================



static void Test_BFu32ll_Sf_BFu7s()
{
  {
    init_simple_test("BFu32ll_Sf_BFu7s");
    static STRUCT_IF_C BFu32ll_Sf_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu7s");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu32ll_Sf_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu32ll_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu7s, BFu32ll_Sf_BFu7s)
//============================================================================



static void Test_BFu32ll_Sf_BFu8c()
{
  {
    init_simple_test("BFu32ll_Sf_BFu8c");
    static STRUCT_IF_C BFu32ll_Sf_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu8c");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu32ll_Sf_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu32ll_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu8c, BFu32ll_Sf_BFu8c)
//============================================================================



static void Test_BFu32ll_Sf_BFu8i()
{
  {
    init_simple_test("BFu32ll_Sf_BFu8i");
    static STRUCT_IF_C BFu32ll_Sf_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu8i");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu32ll_Sf_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu32ll_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu8i, BFu32ll_Sf_BFu8i)
//============================================================================



static void Test_BFu32ll_Sf_BFu8ll()
{
  {
    init_simple_test("BFu32ll_Sf_BFu8ll");
    static STRUCT_IF_C BFu32ll_Sf_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu8ll");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu32ll_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu32ll_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu8ll, BFu32ll_Sf_BFu8ll)
//============================================================================



static void Test_BFu32ll_Sf_BFu8s()
{
  {
    init_simple_test("BFu32ll_Sf_BFu8s");
    static STRUCT_IF_C BFu32ll_Sf_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu8s");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu32ll_Sf_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu32ll_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu8s, BFu32ll_Sf_BFu8s)
//============================================================================



static void Test_BFu32ll_Sf_BFu9i()
{
  {
    init_simple_test("BFu32ll_Sf_BFu9i");
    static STRUCT_IF_C BFu32ll_Sf_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu9i");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu32ll_Sf_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu32ll_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu9i, BFu32ll_Sf_BFu9i)
//============================================================================



static void Test_BFu32ll_Sf_BFu9ll()
{
  {
    init_simple_test("BFu32ll_Sf_BFu9ll");
    static STRUCT_IF_C BFu32ll_Sf_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu9ll");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu32ll_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu32ll_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu9ll, BFu32ll_Sf_BFu9ll)
//============================================================================



static void Test_BFu32ll_Sf_BFu9s()
{
  {
    init_simple_test("BFu32ll_Sf_BFu9s");
    static STRUCT_IF_C BFu32ll_Sf_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_BFu9s");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu32ll_Sf_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu32ll_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_BFu9s, BFu32ll_Sf_BFu9s)
//============================================================================



static void Test_BFu32ll_Sf_C()
{
  {
    init_simple_test("BFu32ll_Sf_C");
    static STRUCT_IF_C BFu32ll_Sf_C lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_C");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_C.v2");
    check_field_offset(lv, v3, 4, "BFu32ll_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_C, BFu32ll_Sf_C)
//============================================================================



static void Test_BFu32ll_Sf_D()
{
  {
    init_simple_test("BFu32ll_Sf_D");
    static STRUCT_IF_C BFu32ll_Sf_D lv;
    check2(sizeof(lv), 12, "sizeof(BFu32ll_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_D");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_D.v2");
    check_field_offset(lv, v3, 4, "BFu32ll_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_D, BFu32ll_Sf_D)
//============================================================================



static void Test_BFu32ll_Sf_F()
{
  {
    init_simple_test("BFu32ll_Sf_F");
    static STRUCT_IF_C BFu32ll_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_F");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu32ll_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_F, BFu32ll_Sf_F)
//============================================================================



static void Test_BFu32ll_Sf_I()
{
  {
    init_simple_test("BFu32ll_Sf_I");
    static STRUCT_IF_C BFu32ll_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_I");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu32ll_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_I, BFu32ll_Sf_I)
//============================================================================



static void Test_BFu32ll_Sf_Ip()
{
  {
    init_simple_test("BFu32ll_Sf_Ip");
    static STRUCT_IF_C BFu32ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu32ll_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_Ip");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_Ip.v2");
    check_field_offset(lv, v3, 4, "BFu32ll_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_Ip, BFu32ll_Sf_Ip)
//============================================================================



static void Test_BFu32ll_Sf_L()
{
  {
    init_simple_test("BFu32ll_Sf_L");
    static STRUCT_IF_C BFu32ll_Sf_L lv;
    check2(sizeof(lv), 12, "sizeof(BFu32ll_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_L");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_L.v2");
    check_field_offset(lv, v3, 4, "BFu32ll_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_L, BFu32ll_Sf_L)
//============================================================================



static void Test_BFu32ll_Sf_S()
{
  {
    init_simple_test("BFu32ll_Sf_S");
    static STRUCT_IF_C BFu32ll_Sf_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_S");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_S.v2");
    check_field_offset(lv, v3, 4, "BFu32ll_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_S, BFu32ll_Sf_S)
//============================================================================



static void Test_BFu32ll_Sf_Sf()
{
  {
    init_simple_test("BFu32ll_Sf_Sf");
    static STRUCT_IF_C BFu32ll_Sf_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu32ll_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu32ll_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_Sf, BFu32ll_Sf_Sf)
//============================================================================



static void Test_BFu32ll_Sf_Uc()
{
  {
    init_simple_test("BFu32ll_Sf_Uc");
    static STRUCT_IF_C BFu32ll_Sf_Uc lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_Uc");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_Uc.v2");
    check_field_offset(lv, v3, 4, "BFu32ll_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_Uc, BFu32ll_Sf_Uc)
//============================================================================



static void Test_BFu32ll_Sf_Ui()
{
  {
    init_simple_test("BFu32ll_Sf_Ui");
    static STRUCT_IF_C BFu32ll_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_Ui");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu32ll_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_Ui, BFu32ll_Sf_Ui)
//============================================================================



static void Test_BFu32ll_Sf_Ul()
{
  {
    init_simple_test("BFu32ll_Sf_Ul");
    static STRUCT_IF_C BFu32ll_Sf_Ul lv;
    check2(sizeof(lv), 12, "sizeof(BFu32ll_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_Ul");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_Ul.v2");
    check_field_offset(lv, v3, 4, "BFu32ll_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_Ul, BFu32ll_Sf_Ul)
//============================================================================



static void Test_BFu32ll_Sf_Us()
{
  {
    init_simple_test("BFu32ll_Sf_Us");
    static STRUCT_IF_C BFu32ll_Sf_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_Us");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_Us.v2");
    check_field_offset(lv, v3, 4, "BFu32ll_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_Us, BFu32ll_Sf_Us)
//============================================================================



static void Test_BFu32ll_Sf_Vp()
{
  {
    init_simple_test("BFu32ll_Sf_Vp");
    static STRUCT_IF_C BFu32ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu32ll_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Sf_Vp");
    check_field_offset(lv, v2, 4, "BFu32ll_Sf_Vp.v2");
    check_field_offset(lv, v3, 4, "BFu32ll_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Sf_Vp, BFu32ll_Sf_Vp)
//============================================================================



static void Test_BFu32ll_Uc_Sf()
{
  {
    init_simple_test("BFu32ll_Uc_Sf");
    static STRUCT_IF_C BFu32ll_Uc_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu32ll_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Uc_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_Uc_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu32ll_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Uc_Sf, BFu32ll_Uc_Sf)
//============================================================================



static void Test_BFu32ll_Ui_Sf()
{
  {
    init_simple_test("BFu32ll_Ui_Sf");
    static STRUCT_IF_C BFu32ll_Ui_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu32ll_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Ui_Sf, BFu32ll_Ui_Sf)
//============================================================================



static void Test_BFu32ll_Ul_Sf()
{
  {
    init_simple_test("BFu32ll_Ul_Sf");
    static STRUCT_IF_C BFu32ll_Ul_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu32ll_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Ul_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_Ul_Sf.v2");
    check_field_offset(lv, v3, 12, "BFu32ll_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Ul_Sf, BFu32ll_Ul_Sf)
//============================================================================



static void Test_BFu32ll_Us_Sf()
{
  {
    init_simple_test("BFu32ll_Us_Sf");
    static STRUCT_IF_C BFu32ll_Us_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu32ll_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Us_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_Us_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu32ll_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Us_Sf, BFu32ll_Us_Sf)
//============================================================================



static void Test_BFu32ll_Vp_Sf()
{
  {
    init_simple_test("BFu32ll_Vp_Sf");
    static STRUCT_IF_C BFu32ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu32ll_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu32ll_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Vp_Sf");
    check_field_offset(lv, v2, 4, "BFu32ll_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "BFu32ll_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu32ll_Vp_Sf, BFu32ll_Vp_Sf)
//============================================================================



static void Test_BFu33_BFu15i_Sf()
{
  {
    init_simple_test("BFu33_BFu15i_Sf");
    static STRUCT_IF_C BFu33_BFu15i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15i_Sf");
    check_field_offset(lv, v3, 6, "BFu33_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15i_Sf, BFu33_BFu15i_Sf)
//============================================================================



static void Test_BFu33_BFu15ll_Sf()
{
  {
    init_simple_test("BFu33_BFu15ll_Sf");
    static STRUCT_IF_C BFu33_BFu15ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15ll_Sf");
    check_field_offset(lv, v3, 6, "BFu33_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15ll_Sf, BFu33_BFu15ll_Sf)
//============================================================================



static void Test_BFu33_BFu15s_Sf()
{
  {
    init_simple_test("BFu33_BFu15s_Sf");
    static STRUCT_IF_C BFu33_BFu15s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15s_Sf");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15s_Sf");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15s_Sf");
    check_field_offset(lv, v3, 6, "BFu33_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15s_Sf, BFu33_BFu15s_Sf)
//============================================================================



static void Test_BFu33_BFu16i_Sf()
{
  {
    init_simple_test("BFu33_BFu16i_Sf");
    static STRUCT_IF_C BFu33_BFu16i_Sf lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu33_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu33_BFu16i_Sf");
    check_field_offset(lv, v3, 7, "BFu33_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16i_Sf, BFu33_BFu16i_Sf)
//============================================================================



static void Test_BFu33_BFu16ll_Sf()
{
  {
    init_simple_test("BFu33_BFu16ll_Sf");
    static STRUCT_IF_C BFu33_BFu16ll_Sf lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu33_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu33_BFu16ll_Sf");
    check_field_offset(lv, v3, 7, "BFu33_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16ll_Sf, BFu33_BFu16ll_Sf)
//============================================================================



static void Test_BFu33_BFu16s_Sf()
{
  {
    init_simple_test("BFu33_BFu16s_Sf");
    static STRUCT_IF_C BFu33_BFu16s_Sf lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu33_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu33_BFu16s_Sf");
    check_field_offset(lv, v3, 7, "BFu33_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16s_Sf, BFu33_BFu16s_Sf)
//============================================================================



static void Test_BFu33_BFu17i_Sf()
{
  {
    init_simple_test("BFu33_BFu17i_Sf");
    static STRUCT_IF_C BFu33_BFu17i_Sf lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu33_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu33_BFu17i_Sf");
    check_field_offset(lv, v3, 7, "BFu33_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu17i_Sf, BFu33_BFu17i_Sf)
//============================================================================



static void Test_BFu33_BFu17ll_Sf()
{
  {
    init_simple_test("BFu33_BFu17ll_Sf");
    static STRUCT_IF_C BFu33_BFu17ll_Sf lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu33_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu33_BFu17ll_Sf");
    check_field_offset(lv, v3, 7, "BFu33_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu17ll_Sf, BFu33_BFu17ll_Sf)
//============================================================================



static void Test_BFu33_BFu1c_Sf()
{
  {
    init_simple_test("BFu33_BFu1c_Sf");
    static STRUCT_IF_C BFu33_BFu1c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu33_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1c_Sf");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1c_Sf");
    check_field_offset(lv, v3, 5, "BFu33_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1c_Sf, BFu33_BFu1c_Sf)
//============================================================================



static void Test_BFu33_BFu1i_Sf()
{
  {
    init_simple_test("BFu33_BFu1i_Sf");
    static STRUCT_IF_C BFu33_BFu1i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu33_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1i_Sf");
    check_field_offset(lv, v3, 5, "BFu33_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1i_Sf, BFu33_BFu1i_Sf)
//============================================================================



static void Test_BFu33_BFu1ll_Sf()
{
  {
    init_simple_test("BFu33_BFu1ll_Sf");
    static STRUCT_IF_C BFu33_BFu1ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu33_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1ll_Sf");
    check_field_offset(lv, v3, 5, "BFu33_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1ll_Sf, BFu33_BFu1ll_Sf)
//============================================================================



static void Test_BFu33_BFu1s_Sf()
{
  {
    init_simple_test("BFu33_BFu1s_Sf");
    static STRUCT_IF_C BFu33_BFu1s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu33_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1s_Sf");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1s_Sf");
    check_field_offset(lv, v3, 5, "BFu33_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1s_Sf, BFu33_BFu1s_Sf)
//============================================================================



static void Test_BFu33_BFu31i_Sf()
{
  {
    init_simple_test("BFu33_BFu31i_Sf");
    static STRUCT_IF_C BFu33_BFu31i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu33_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu33_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu33_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu31i_Sf, BFu33_BFu31i_Sf)
//============================================================================



static void Test_BFu33_BFu31ll_Sf()
{
  {
    init_simple_test("BFu33_BFu31ll_Sf");
    static STRUCT_IF_C BFu33_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu33_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu33_BFu31ll_Sf");
    check_field_offset(lv, v3, 8, "BFu33_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu31ll_Sf, BFu33_BFu31ll_Sf)
//============================================================================



static void Test_BFu33_BFu32i_Sf()
{
  {
    init_simple_test("BFu33_BFu32i_Sf");
    static STRUCT_IF_C BFu33_BFu32i_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu33_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 32, 1, "BFu33_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 32, hide_ull(1LL<<31), "BFu33_BFu32i_Sf");
    check_field_offset(lv, v3, 9, "BFu33_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu32i_Sf, BFu33_BFu32i_Sf)
//============================================================================



static void Test_BFu33_BFu32ll_Sf()
{
  {
    init_simple_test("BFu33_BFu32ll_Sf");
    static STRUCT_IF_C BFu33_BFu32ll_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu33_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 32, 1, "BFu33_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 32, hide_ull(1LL<<31), "BFu33_BFu32ll_Sf");
    check_field_offset(lv, v3, 9, "BFu33_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu32ll_Sf, BFu33_BFu32ll_Sf)
//============================================================================



static void Test_BFu33_BFu33_Sf()
{
  {
    init_simple_test("BFu33_BFu33_Sf");
    static STRUCT_IF_C BFu33_BFu33_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu33_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu33_Sf");
    set_bf_and_test(lv, v2, 4, 1, 33, 1, "BFu33_BFu33_Sf");
    set_bf_and_test(lv, v2, 4, 1, 33, hide_ull(1LL<<32), "BFu33_BFu33_Sf");
    check_field_offset(lv, v3, 9, "BFu33_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu33_Sf, BFu33_BFu33_Sf)
//============================================================================



static void Test_BFu33_BFu7c_Sf()
{
  {
    init_simple_test("BFu33_BFu7c_Sf");
    static STRUCT_IF_C BFu33_BFu7c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu33_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7c_Sf");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7c_Sf");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7c_Sf");
    check_field_offset(lv, v3, 5, "BFu33_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7c_Sf, BFu33_BFu7c_Sf)
//============================================================================



static void Test_BFu33_BFu7i_Sf()
{
  {
    init_simple_test("BFu33_BFu7i_Sf");
    static STRUCT_IF_C BFu33_BFu7i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu33_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7i_Sf");
    check_field_offset(lv, v3, 5, "BFu33_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7i_Sf, BFu33_BFu7i_Sf)
//============================================================================



static void Test_BFu33_BFu7ll_Sf()
{
  {
    init_simple_test("BFu33_BFu7ll_Sf");
    static STRUCT_IF_C BFu33_BFu7ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu33_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7ll_Sf");
    check_field_offset(lv, v3, 5, "BFu33_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7ll_Sf, BFu33_BFu7ll_Sf)
//============================================================================



static void Test_BFu33_BFu7s_Sf()
{
  {
    init_simple_test("BFu33_BFu7s_Sf");
    static STRUCT_IF_C BFu33_BFu7s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu33_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7s_Sf");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7s_Sf");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7s_Sf");
    check_field_offset(lv, v3, 5, "BFu33_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7s_Sf, BFu33_BFu7s_Sf)
//============================================================================



static void Test_BFu33_BFu8c_Sf()
{
  {
    init_simple_test("BFu33_BFu8c_Sf");
    static STRUCT_IF_C BFu33_BFu8c_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8c_Sf");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8c_Sf");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8c_Sf");
    check_field_offset(lv, v3, 6, "BFu33_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8c_Sf, BFu33_BFu8c_Sf)
//============================================================================



static void Test_BFu33_BFu8i_Sf()
{
  {
    init_simple_test("BFu33_BFu8i_Sf");
    static STRUCT_IF_C BFu33_BFu8i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8i_Sf");
    check_field_offset(lv, v3, 6, "BFu33_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8i_Sf, BFu33_BFu8i_Sf)
//============================================================================



static void Test_BFu33_BFu8ll_Sf()
{
  {
    init_simple_test("BFu33_BFu8ll_Sf");
    static STRUCT_IF_C BFu33_BFu8ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8ll_Sf");
    check_field_offset(lv, v3, 6, "BFu33_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8ll_Sf, BFu33_BFu8ll_Sf)
//============================================================================



static void Test_BFu33_BFu8s_Sf()
{
  {
    init_simple_test("BFu33_BFu8s_Sf");
    static STRUCT_IF_C BFu33_BFu8s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8s_Sf");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8s_Sf");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8s_Sf");
    check_field_offset(lv, v3, 6, "BFu33_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8s_Sf, BFu33_BFu8s_Sf)
//============================================================================



static void Test_BFu33_BFu9i_Sf()
{
  {
    init_simple_test("BFu33_BFu9i_Sf");
    static STRUCT_IF_C BFu33_BFu9i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9i_Sf");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9i_Sf");
    check_field_offset(lv, v3, 6, "BFu33_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9i_Sf, BFu33_BFu9i_Sf)
//============================================================================



static void Test_BFu33_BFu9ll_Sf()
{
  {
    init_simple_test("BFu33_BFu9ll_Sf");
    static STRUCT_IF_C BFu33_BFu9ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9ll_Sf");
    check_field_offset(lv, v3, 6, "BFu33_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9ll_Sf, BFu33_BFu9ll_Sf)
//============================================================================



static void Test_BFu33_BFu9s_Sf()
{
  {
    init_simple_test("BFu33_BFu9s_Sf");
    static STRUCT_IF_C BFu33_BFu9s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9s_Sf");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9s_Sf");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9s_Sf");
    check_field_offset(lv, v3, 6, "BFu33_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9s_Sf, BFu33_BFu9s_Sf)
//============================================================================



static void Test_BFu33_C_Sf()
{
  {
    init_simple_test("BFu33_C_Sf");
    static STRUCT_IF_C BFu33_C_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_C_Sf");
    check_field_offset(lv, v2, 5, "BFu33_C_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu33_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_C_Sf, BFu33_C_Sf)
//============================================================================



static void Test_BFu33_D_Sf()
{
  {
    init_simple_test("BFu33_D_Sf");
    static STRUCT_IF_C BFu33_D_Sf lv;
    check2(sizeof(lv), 13, "sizeof(BFu33_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_D_Sf");
    check_field_offset(lv, v2, 5, "BFu33_D_Sf.v2");
    check_field_offset(lv, v3, 13, "BFu33_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_D_Sf, BFu33_D_Sf)
//============================================================================



static void Test_BFu33_F_Sf()
{
  {
    init_simple_test("BFu33_F_Sf");
    static STRUCT_IF_C BFu33_F_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu33_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_F_Sf");
    check_field_offset(lv, v2, 5, "BFu33_F_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu33_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_F_Sf, BFu33_F_Sf)
//============================================================================



static void Test_BFu33_I_Sf()
{
  {
    init_simple_test("BFu33_I_Sf");
    static STRUCT_IF_C BFu33_I_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu33_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_I_Sf");
    check_field_offset(lv, v2, 5, "BFu33_I_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu33_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_I_Sf, BFu33_I_Sf)
//============================================================================



static void Test_BFu33_Ip_Sf()
{
  {
    init_simple_test("BFu33_Ip_Sf");
    static STRUCT_IF_C BFu33_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu33_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ip_Sf");
    check_field_offset(lv, v2, 5, "BFu33_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(13,9), "BFu33_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ip_Sf, BFu33_Ip_Sf)
//============================================================================



static void Test_BFu33_L_Sf()
{
  {
    init_simple_test("BFu33_L_Sf");
    static STRUCT_IF_C BFu33_L_Sf lv;
    check2(sizeof(lv), 13, "sizeof(BFu33_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_L_Sf");
    check_field_offset(lv, v2, 5, "BFu33_L_Sf.v2");
    check_field_offset(lv, v3, 13, "BFu33_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_L_Sf, BFu33_L_Sf)
//============================================================================



static void Test_BFu33_S_Sf()
{
  {
    init_simple_test("BFu33_S_Sf");
    static STRUCT_IF_C BFu33_S_Sf lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_S_Sf");
    check_field_offset(lv, v2, 5, "BFu33_S_Sf.v2");
    check_field_offset(lv, v3, 7, "BFu33_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_S_Sf, BFu33_S_Sf)
//============================================================================



static void Test_BFu33_Sf()
{
  {
    init_simple_test("BFu33_Sf");
    static STRUCT_IF_C BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf");
    check_field_offset(lv, v2, 5, "BFu33_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf, BFu33_Sf)
//============================================================================



static void Test_BFu33_Sf_BFu15i()
{
  {
    init_simple_test("BFu33_Sf_BFu15i");
    static STRUCT_IF_C BFu33_Sf_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu15i");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "BFu33_Sf_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "BFu33_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu15i, BFu33_Sf_BFu15i)
//============================================================================



static void Test_BFu33_Sf_BFu15ll()
{
  {
    init_simple_test("BFu33_Sf_BFu15ll");
    static STRUCT_IF_C BFu33_Sf_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu15ll");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "BFu33_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "BFu33_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu15ll, BFu33_Sf_BFu15ll)
//============================================================================



static void Test_BFu33_Sf_BFu15s()
{
  {
    init_simple_test("BFu33_Sf_BFu15s");
    static STRUCT_IF_C BFu33_Sf_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu15s");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "BFu33_Sf_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "BFu33_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu15s, BFu33_Sf_BFu15s)
//============================================================================



static void Test_BFu33_Sf_BFu16i()
{
  {
    init_simple_test("BFu33_Sf_BFu16i");
    static STRUCT_IF_C BFu33_Sf_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu16i");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "BFu33_Sf_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "BFu33_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu16i, BFu33_Sf_BFu16i)
//============================================================================



static void Test_BFu33_Sf_BFu16ll()
{
  {
    init_simple_test("BFu33_Sf_BFu16ll");
    static STRUCT_IF_C BFu33_Sf_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu16ll");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "BFu33_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "BFu33_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu16ll, BFu33_Sf_BFu16ll)
//============================================================================



static void Test_BFu33_Sf_BFu16s()
{
  {
    init_simple_test("BFu33_Sf_BFu16s");
    static STRUCT_IF_C BFu33_Sf_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu16s");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "BFu33_Sf_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "BFu33_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu16s, BFu33_Sf_BFu16s)
//============================================================================



static void Test_BFu33_Sf_BFu17i()
{
  {
    init_simple_test("BFu33_Sf_BFu17i");
    static STRUCT_IF_C BFu33_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu17i");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "BFu33_Sf_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "BFu33_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu17i, BFu33_Sf_BFu17i)
//============================================================================



static void Test_BFu33_Sf_BFu17ll()
{
  {
    init_simple_test("BFu33_Sf_BFu17ll");
    static STRUCT_IF_C BFu33_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu17ll");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "BFu33_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "BFu33_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu17ll, BFu33_Sf_BFu17ll)
//============================================================================



static void Test_BFu33_Sf_BFu1c()
{
  {
    init_simple_test("BFu33_Sf_BFu1c");
    static STRUCT_IF_C BFu33_Sf_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu1c");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu33_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu1c, BFu33_Sf_BFu1c)
//============================================================================



static void Test_BFu33_Sf_BFu1i()
{
  {
    init_simple_test("BFu33_Sf_BFu1i");
    static STRUCT_IF_C BFu33_Sf_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu1i");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu33_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu1i, BFu33_Sf_BFu1i)
//============================================================================



static void Test_BFu33_Sf_BFu1ll()
{
  {
    init_simple_test("BFu33_Sf_BFu1ll");
    static STRUCT_IF_C BFu33_Sf_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu1ll");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu33_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu1ll, BFu33_Sf_BFu1ll)
//============================================================================



static void Test_BFu33_Sf_BFu1s()
{
  {
    init_simple_test("BFu33_Sf_BFu1s");
    static STRUCT_IF_C BFu33_Sf_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu1s");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu33_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu1s, BFu33_Sf_BFu1s)
//============================================================================



static void Test_BFu33_Sf_BFu31i()
{
  {
    init_simple_test("BFu33_Sf_BFu31i");
    static STRUCT_IF_C BFu33_Sf_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(BFu33_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu31i");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "BFu33_Sf_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "BFu33_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu31i, BFu33_Sf_BFu31i)
//============================================================================



static void Test_BFu33_Sf_BFu31ll()
{
  {
    init_simple_test("BFu33_Sf_BFu31ll");
    static STRUCT_IF_C BFu33_Sf_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu33_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu31ll");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "BFu33_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "BFu33_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu31ll, BFu33_Sf_BFu31ll)
//============================================================================



static void Test_BFu33_Sf_BFu32i()
{
  {
    init_simple_test("BFu33_Sf_BFu32i");
    static STRUCT_IF_C BFu33_Sf_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(BFu33_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu32i");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "BFu33_Sf_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "BFu33_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu32i, BFu33_Sf_BFu32i)
//============================================================================



static void Test_BFu33_Sf_BFu32ll()
{
  {
    init_simple_test("BFu33_Sf_BFu32ll");
    static STRUCT_IF_C BFu33_Sf_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(BFu33_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu32ll");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "BFu33_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "BFu33_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu32ll, BFu33_Sf_BFu32ll)
//============================================================================



static void Test_BFu33_Sf_BFu33()
{
  {
    init_simple_test("BFu33_Sf_BFu33");
    static STRUCT_IF_C BFu33_Sf_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(BFu33_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu33");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "BFu33_Sf_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu33, BFu33_Sf_BFu33)
//============================================================================



static void Test_BFu33_Sf_BFu7c()
{
  {
    init_simple_test("BFu33_Sf_BFu7c");
    static STRUCT_IF_C BFu33_Sf_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu7c");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu33_Sf_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu33_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu7c, BFu33_Sf_BFu7c)
//============================================================================



static void Test_BFu33_Sf_BFu7i()
{
  {
    init_simple_test("BFu33_Sf_BFu7i");
    static STRUCT_IF_C BFu33_Sf_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu7i");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu33_Sf_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu33_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu7i, BFu33_Sf_BFu7i)
//============================================================================



static void Test_BFu33_Sf_BFu7ll()
{
  {
    init_simple_test("BFu33_Sf_BFu7ll");
    static STRUCT_IF_C BFu33_Sf_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu7ll");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu33_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu33_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu7ll, BFu33_Sf_BFu7ll)
//============================================================================



static void Test_BFu33_Sf_BFu7s()
{
  {
    init_simple_test("BFu33_Sf_BFu7s");
    static STRUCT_IF_C BFu33_Sf_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu7s");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu33_Sf_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu33_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu7s, BFu33_Sf_BFu7s)
//============================================================================



static void Test_BFu33_Sf_BFu8c()
{
  {
    init_simple_test("BFu33_Sf_BFu8c");
    static STRUCT_IF_C BFu33_Sf_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu8c");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu33_Sf_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu33_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu8c, BFu33_Sf_BFu8c)
//============================================================================



static void Test_BFu33_Sf_BFu8i()
{
  {
    init_simple_test("BFu33_Sf_BFu8i");
    static STRUCT_IF_C BFu33_Sf_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu8i");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu33_Sf_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu33_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu8i, BFu33_Sf_BFu8i)
//============================================================================



static void Test_BFu33_Sf_BFu8ll()
{
  {
    init_simple_test("BFu33_Sf_BFu8ll");
    static STRUCT_IF_C BFu33_Sf_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu8ll");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu33_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu33_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu8ll, BFu33_Sf_BFu8ll)
//============================================================================



static void Test_BFu33_Sf_BFu8s()
{
  {
    init_simple_test("BFu33_Sf_BFu8s");
    static STRUCT_IF_C BFu33_Sf_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu8s");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu33_Sf_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu33_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu8s, BFu33_Sf_BFu8s)
//============================================================================



static void Test_BFu33_Sf_BFu9i()
{
  {
    init_simple_test("BFu33_Sf_BFu9i");
    static STRUCT_IF_C BFu33_Sf_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu9i");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "BFu33_Sf_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "BFu33_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu9i, BFu33_Sf_BFu9i)
//============================================================================



static void Test_BFu33_Sf_BFu9ll()
{
  {
    init_simple_test("BFu33_Sf_BFu9ll");
    static STRUCT_IF_C BFu33_Sf_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu9ll");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "BFu33_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "BFu33_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu9ll, BFu33_Sf_BFu9ll)
//============================================================================



static void Test_BFu33_Sf_BFu9s()
{
  {
    init_simple_test("BFu33_Sf_BFu9s");
    static STRUCT_IF_C BFu33_Sf_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_BFu9s");
    check_field_offset(lv, v2, 5, "BFu33_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "BFu33_Sf_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "BFu33_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_BFu9s, BFu33_Sf_BFu9s)
//============================================================================



static void Test_BFu33_Sf_C()
{
  {
    init_simple_test("BFu33_Sf_C");
    static STRUCT_IF_C BFu33_Sf_C lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_C");
    check_field_offset(lv, v2, 5, "BFu33_Sf_C.v2");
    check_field_offset(lv, v3, 5, "BFu33_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_C, BFu33_Sf_C)
//============================================================================



static void Test_BFu33_Sf_D()
{
  {
    init_simple_test("BFu33_Sf_D");
    static STRUCT_IF_C BFu33_Sf_D lv;
    check2(sizeof(lv), 13, "sizeof(BFu33_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_D");
    check_field_offset(lv, v2, 5, "BFu33_Sf_D.v2");
    check_field_offset(lv, v3, 5, "BFu33_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_D, BFu33_Sf_D)
//============================================================================



static void Test_BFu33_Sf_F()
{
  {
    init_simple_test("BFu33_Sf_F");
    static STRUCT_IF_C BFu33_Sf_F lv;
    check2(sizeof(lv), 9, "sizeof(BFu33_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_F");
    check_field_offset(lv, v2, 5, "BFu33_Sf_F.v2");
    check_field_offset(lv, v3, 5, "BFu33_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_F, BFu33_Sf_F)
//============================================================================



static void Test_BFu33_Sf_I()
{
  {
    init_simple_test("BFu33_Sf_I");
    static STRUCT_IF_C BFu33_Sf_I lv;
    check2(sizeof(lv), 9, "sizeof(BFu33_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_I");
    check_field_offset(lv, v2, 5, "BFu33_Sf_I.v2");
    check_field_offset(lv, v3, 5, "BFu33_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_I, BFu33_Sf_I)
//============================================================================



static void Test_BFu33_Sf_Ip()
{
  {
    init_simple_test("BFu33_Sf_Ip");
    static STRUCT_IF_C BFu33_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu33_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_Ip");
    check_field_offset(lv, v2, 5, "BFu33_Sf_Ip.v2");
    check_field_offset(lv, v3, 5, "BFu33_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_Ip, BFu33_Sf_Ip)
//============================================================================



static void Test_BFu33_Sf_L()
{
  {
    init_simple_test("BFu33_Sf_L");
    static STRUCT_IF_C BFu33_Sf_L lv;
    check2(sizeof(lv), 13, "sizeof(BFu33_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_L");
    check_field_offset(lv, v2, 5, "BFu33_Sf_L.v2");
    check_field_offset(lv, v3, 5, "BFu33_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_L, BFu33_Sf_L)
//============================================================================



static void Test_BFu33_Sf_S()
{
  {
    init_simple_test("BFu33_Sf_S");
    static STRUCT_IF_C BFu33_Sf_S lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_S");
    check_field_offset(lv, v2, 5, "BFu33_Sf_S.v2");
    check_field_offset(lv, v3, 5, "BFu33_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_S, BFu33_Sf_S)
//============================================================================



static void Test_BFu33_Sf_Sf()
{
  {
    init_simple_test("BFu33_Sf_Sf");
    static STRUCT_IF_C BFu33_Sf_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu33_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_Sf");
    check_field_offset(lv, v2, 5, "BFu33_Sf_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu33_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_Sf, BFu33_Sf_Sf)
//============================================================================



static void Test_BFu33_Sf_Uc()
{
  {
    init_simple_test("BFu33_Sf_Uc");
    static STRUCT_IF_C BFu33_Sf_Uc lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_Uc");
    check_field_offset(lv, v2, 5, "BFu33_Sf_Uc.v2");
    check_field_offset(lv, v3, 5, "BFu33_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_Uc, BFu33_Sf_Uc)
//============================================================================



static void Test_BFu33_Sf_Ui()
{
  {
    init_simple_test("BFu33_Sf_Ui");
    static STRUCT_IF_C BFu33_Sf_Ui lv;
    check2(sizeof(lv), 9, "sizeof(BFu33_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_Ui");
    check_field_offset(lv, v2, 5, "BFu33_Sf_Ui.v2");
    check_field_offset(lv, v3, 5, "BFu33_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_Ui, BFu33_Sf_Ui)
//============================================================================



static void Test_BFu33_Sf_Ul()
{
  {
    init_simple_test("BFu33_Sf_Ul");
    static STRUCT_IF_C BFu33_Sf_Ul lv;
    check2(sizeof(lv), 13, "sizeof(BFu33_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_Ul");
    check_field_offset(lv, v2, 5, "BFu33_Sf_Ul.v2");
    check_field_offset(lv, v3, 5, "BFu33_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_Ul, BFu33_Sf_Ul)
//============================================================================



static void Test_BFu33_Sf_Us()
{
  {
    init_simple_test("BFu33_Sf_Us");
    static STRUCT_IF_C BFu33_Sf_Us lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_Us");
    check_field_offset(lv, v2, 5, "BFu33_Sf_Us.v2");
    check_field_offset(lv, v3, 5, "BFu33_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_Us, BFu33_Sf_Us)
//============================================================================



static void Test_BFu33_Sf_Vp()
{
  {
    init_simple_test("BFu33_Sf_Vp");
    static STRUCT_IF_C BFu33_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu33_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Sf_Vp");
    check_field_offset(lv, v2, 5, "BFu33_Sf_Vp.v2");
    check_field_offset(lv, v3, 5, "BFu33_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Sf_Vp, BFu33_Sf_Vp)
//============================================================================



static void Test_BFu33_Uc_Sf()
{
  {
    init_simple_test("BFu33_Uc_Sf");
    static STRUCT_IF_C BFu33_Uc_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu33_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Uc_Sf");
    check_field_offset(lv, v2, 5, "BFu33_Uc_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu33_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Uc_Sf, BFu33_Uc_Sf)
//============================================================================



static void Test_BFu33_Ui_Sf()
{
  {
    init_simple_test("BFu33_Ui_Sf");
    static STRUCT_IF_C BFu33_Ui_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu33_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ui_Sf");
    check_field_offset(lv, v2, 5, "BFu33_Ui_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu33_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ui_Sf, BFu33_Ui_Sf)
//============================================================================



static void Test_BFu33_Ul_Sf()
{
  {
    init_simple_test("BFu33_Ul_Sf");
    static STRUCT_IF_C BFu33_Ul_Sf lv;
    check2(sizeof(lv), 13, "sizeof(BFu33_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ul_Sf");
    check_field_offset(lv, v2, 5, "BFu33_Ul_Sf.v2");
    check_field_offset(lv, v3, 13, "BFu33_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ul_Sf, BFu33_Ul_Sf)
//============================================================================



static void Test_BFu33_Us_Sf()
{
  {
    init_simple_test("BFu33_Us_Sf");
    static STRUCT_IF_C BFu33_Us_Sf lv;
    check2(sizeof(lv), 7, "sizeof(BFu33_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Us_Sf");
    check_field_offset(lv, v2, 5, "BFu33_Us_Sf.v2");
    check_field_offset(lv, v3, 7, "BFu33_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Us_Sf, BFu33_Us_Sf)
//============================================================================



static void Test_BFu33_Vp_Sf()
{
  {
    init_simple_test("BFu33_Vp_Sf");
    static STRUCT_IF_C BFu33_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(BFu33_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu33_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Vp_Sf");
    check_field_offset(lv, v2, 5, "BFu33_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(13,9), "BFu33_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Vp_Sf, BFu33_Vp_Sf)
//============================================================================



static void Test_BFu7c_BFu15i_Sf()
{
  {
    init_simple_test("BFu7c_BFu15i_Sf");
    static STRUCT_IF_C BFu7c_BFu15i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7c_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7c_BFu15i_Sf");
    check_field_offset(lv, v3, 3, "BFu7c_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15i_Sf, BFu7c_BFu15i_Sf)
//============================================================================



static void Test_BFu7c_BFu15ll_Sf()
{
  {
    init_simple_test("BFu7c_BFu15ll_Sf");
    static STRUCT_IF_C BFu7c_BFu15ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7c_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7c_BFu15ll_Sf");
    check_field_offset(lv, v3, 3, "BFu7c_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15ll_Sf, BFu7c_BFu15ll_Sf)
//============================================================================



static void Test_BFu7c_BFu15s_Sf()
{
  {
    init_simple_test("BFu7c_BFu15s_Sf");
    static STRUCT_IF_C BFu7c_BFu15s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7c_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7c_BFu15s_Sf");
    check_field_offset(lv, v3, 3, "BFu7c_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15s_Sf, BFu7c_BFu15s_Sf)
//============================================================================



static void Test_BFu7c_BFu16i_Sf()
{
  {
    init_simple_test("BFu7c_BFu16i_Sf");
    static STRUCT_IF_C BFu7c_BFu16i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7c_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7c_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "BFu7c_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16i_Sf, BFu7c_BFu16i_Sf)
//============================================================================



static void Test_BFu7c_BFu16ll_Sf()
{
  {
    init_simple_test("BFu7c_BFu16ll_Sf");
    static STRUCT_IF_C BFu7c_BFu16ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7c_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7c_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "BFu7c_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16ll_Sf, BFu7c_BFu16ll_Sf)
//============================================================================



static void Test_BFu7c_BFu16s_Sf()
{
  {
    init_simple_test("BFu7c_BFu16s_Sf");
    static STRUCT_IF_C BFu7c_BFu16s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7c_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7c_BFu16s_Sf");
    check_field_offset(lv, v3, 3, "BFu7c_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16s_Sf, BFu7c_BFu16s_Sf)
//============================================================================



static void Test_BFu7c_BFu17i_Sf()
{
  {
    init_simple_test("BFu7c_BFu17i_Sf");
    static STRUCT_IF_C BFu7c_BFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7c_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7c_BFu17i_Sf");
    check_field_offset(lv, v3, 3, "BFu7c_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu17i_Sf, BFu7c_BFu17i_Sf)
//============================================================================



static void Test_BFu7c_BFu17ll_Sf()
{
  {
    init_simple_test("BFu7c_BFu17ll_Sf");
    static STRUCT_IF_C BFu7c_BFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7c_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7c_BFu17ll_Sf");
    check_field_offset(lv, v3, 3, "BFu7c_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu17ll_Sf, BFu7c_BFu17ll_Sf)
//============================================================================



static void Test_BFu7c_BFu1c_Sf()
{
  {
    init_simple_test("BFu7c_BFu1c_Sf");
    static STRUCT_IF_C BFu7c_BFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7c_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1c_Sf");
    check_field_offset(lv, v3, 1, "BFu7c_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1c_Sf, BFu7c_BFu1c_Sf)
//============================================================================



static void Test_BFu7c_BFu1i_Sf()
{
  {
    init_simple_test("BFu7c_BFu1i_Sf");
    static STRUCT_IF_C BFu7c_BFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7c_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1i_Sf");
    check_field_offset(lv, v3, 1, "BFu7c_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1i_Sf, BFu7c_BFu1i_Sf)
//============================================================================



static void Test_BFu7c_BFu1ll_Sf()
{
  {
    init_simple_test("BFu7c_BFu1ll_Sf");
    static STRUCT_IF_C BFu7c_BFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7c_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1ll_Sf");
    check_field_offset(lv, v3, 1, "BFu7c_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1ll_Sf, BFu7c_BFu1ll_Sf)
//============================================================================



static void Test_BFu7c_BFu1s_Sf()
{
  {
    init_simple_test("BFu7c_BFu1s_Sf");
    static STRUCT_IF_C BFu7c_BFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7c_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1s_Sf");
    check_field_offset(lv, v3, 1, "BFu7c_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1s_Sf, BFu7c_BFu1s_Sf)
//============================================================================



static void Test_BFu7c_BFu31i_Sf()
{
  {
    init_simple_test("BFu7c_BFu31i_Sf");
    static STRUCT_IF_C BFu7c_BFu31i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7c_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7c_BFu31i_Sf");
    check_field_offset(lv, v3, 5, "BFu7c_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu31i_Sf, BFu7c_BFu31i_Sf)
//============================================================================



static void Test_BFu7c_BFu31ll_Sf()
{
  {
    init_simple_test("BFu7c_BFu31ll_Sf");
    static STRUCT_IF_C BFu7c_BFu31ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7c_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7c_BFu31ll_Sf");
    check_field_offset(lv, v3, 5, "BFu7c_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu31ll_Sf, BFu7c_BFu31ll_Sf)
//============================================================================



static void Test_BFu7c_BFu32i_Sf()
{
  {
    init_simple_test("BFu7c_BFu32i_Sf");
    static STRUCT_IF_C BFu7c_BFu32i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7c_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7c_BFu32i_Sf");
    check_field_offset(lv, v3, 5, "BFu7c_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu32i_Sf, BFu7c_BFu32i_Sf)
//============================================================================



static void Test_BFu7c_BFu32ll_Sf()
{
  {
    init_simple_test("BFu7c_BFu32ll_Sf");
    static STRUCT_IF_C BFu7c_BFu32ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7c_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7c_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "BFu7c_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu32ll_Sf, BFu7c_BFu32ll_Sf)
//============================================================================



static void Test_BFu7c_BFu33_Sf()
{
  {
    init_simple_test("BFu7c_BFu33_Sf");
    static STRUCT_IF_C BFu7c_BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7c_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7c_BFu33_Sf");
    check_field_offset(lv, v3, 5, "BFu7c_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu33_Sf, BFu7c_BFu33_Sf)
//============================================================================



static void Test_BFu7c_BFu7c_Sf()
{
  {
    init_simple_test("BFu7c_BFu7c_Sf");
    static STRUCT_IF_C BFu7c_BFu7c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7c_Sf");
    check_field_offset(lv, v3, 2, "BFu7c_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7c_Sf, BFu7c_BFu7c_Sf)
//============================================================================



static void Test_BFu7c_BFu7i_Sf()
{
  {
    init_simple_test("BFu7c_BFu7i_Sf");
    static STRUCT_IF_C BFu7c_BFu7i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7i_Sf");
    check_field_offset(lv, v3, 2, "BFu7c_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7i_Sf, BFu7c_BFu7i_Sf)
//============================================================================



static void Test_BFu7c_BFu7ll_Sf()
{
  {
    init_simple_test("BFu7c_BFu7ll_Sf");
    static STRUCT_IF_C BFu7c_BFu7ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7ll_Sf");
    check_field_offset(lv, v3, 2, "BFu7c_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7ll_Sf, BFu7c_BFu7ll_Sf)
//============================================================================



static void Test_BFu7c_BFu7s_Sf()
{
  {
    init_simple_test("BFu7c_BFu7s_Sf");
    static STRUCT_IF_C BFu7c_BFu7s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7s_Sf");
    check_field_offset(lv, v3, 2, "BFu7c_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7s_Sf, BFu7c_BFu7s_Sf)
//============================================================================



static void Test_BFu7c_BFu8c_Sf()
{
  {
    init_simple_test("BFu7c_BFu8c_Sf");
    static STRUCT_IF_C BFu7c_BFu8c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "BFu7c_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8c_Sf, BFu7c_BFu8c_Sf)
//============================================================================



static void Test_BFu7c_BFu8i_Sf()
{
  {
    init_simple_test("BFu7c_BFu8i_Sf");
    static STRUCT_IF_C BFu7c_BFu8i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "BFu7c_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8i_Sf, BFu7c_BFu8i_Sf)
//============================================================================



static void Test_BFu7c_BFu8ll_Sf()
{
  {
    init_simple_test("BFu7c_BFu8ll_Sf");
    static STRUCT_IF_C BFu7c_BFu8ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "BFu7c_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8ll_Sf, BFu7c_BFu8ll_Sf)
//============================================================================



static void Test_BFu7c_BFu8s_Sf()
{
  {
    init_simple_test("BFu7c_BFu8s_Sf");
    static STRUCT_IF_C BFu7c_BFu8s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "BFu7c_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8s_Sf, BFu7c_BFu8s_Sf)
//============================================================================



static void Test_BFu7c_BFu9i_Sf()
{
  {
    init_simple_test("BFu7c_BFu9i_Sf");
    static STRUCT_IF_C BFu7c_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9i_Sf");
    check_field_offset(lv, v3, 2, "BFu7c_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9i_Sf, BFu7c_BFu9i_Sf)
//============================================================================



static void Test_BFu7c_BFu9ll_Sf()
{
  {
    init_simple_test("BFu7c_BFu9ll_Sf");
    static STRUCT_IF_C BFu7c_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9ll_Sf");
    check_field_offset(lv, v3, 2, "BFu7c_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9ll_Sf, BFu7c_BFu9ll_Sf)
//============================================================================



static void Test_BFu7c_BFu9s_Sf()
{
  {
    init_simple_test("BFu7c_BFu9s_Sf");
    static STRUCT_IF_C BFu7c_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9s_Sf");
    check_field_offset(lv, v3, 2, "BFu7c_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9s_Sf, BFu7c_BFu9s_Sf)
//============================================================================



static void Test_BFu7c_C_Sf()
{
  {
    init_simple_test("BFu7c_C_Sf");
    static STRUCT_IF_C BFu7c_C_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_C_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_C_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu7c_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_C_Sf, BFu7c_C_Sf)
//============================================================================



static void Test_BFu7c_D_Sf()
{
  {
    init_simple_test("BFu7c_D_Sf");
    static STRUCT_IF_C BFu7c_D_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_D_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_D_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu7c_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_D_Sf, BFu7c_D_Sf)
//============================================================================



static void Test_BFu7c_F_Sf()
{
  {
    init_simple_test("BFu7c_F_Sf");
    static STRUCT_IF_C BFu7c_F_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_F_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_F_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu7c_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_F_Sf, BFu7c_F_Sf)
//============================================================================



static void Test_BFu7c_I_Sf()
{
  {
    init_simple_test("BFu7c_I_Sf");
    static STRUCT_IF_C BFu7c_I_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_I_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_I_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu7c_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_I_Sf, BFu7c_I_Sf)
//============================================================================



static void Test_BFu7c_Ip_Sf()
{
  {
    init_simple_test("BFu7c_Ip_Sf");
    static STRUCT_IF_C BFu7c_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7c_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ip_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ip_Sf, BFu7c_Ip_Sf)
//============================================================================



static void Test_BFu7c_L_Sf()
{
  {
    init_simple_test("BFu7c_L_Sf");
    static STRUCT_IF_C BFu7c_L_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_L_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_L_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu7c_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_L_Sf, BFu7c_L_Sf)
//============================================================================



static void Test_BFu7c_S_Sf()
{
  {
    init_simple_test("BFu7c_S_Sf");
    static STRUCT_IF_C BFu7c_S_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_S_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu7c_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_Sf, BFu7c_S_Sf)
//============================================================================



static void Test_BFu7c_Sf()
{
  {
    init_simple_test("BFu7c_Sf");
    static STRUCT_IF_C BFu7c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf, BFu7c_Sf)
//============================================================================



static void Test_BFu7c_Sf_BFu15i()
{
  {
    init_simple_test("BFu7c_Sf_BFu15i");
    static STRUCT_IF_C BFu7c_Sf_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu7c_Sf_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu7c_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu15i, BFu7c_Sf_BFu15i)
//============================================================================



static void Test_BFu7c_Sf_BFu15ll()
{
  {
    init_simple_test("BFu7c_Sf_BFu15ll");
    static STRUCT_IF_C BFu7c_Sf_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu7c_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu7c_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu15ll, BFu7c_Sf_BFu15ll)
//============================================================================



static void Test_BFu7c_Sf_BFu15s()
{
  {
    init_simple_test("BFu7c_Sf_BFu15s");
    static STRUCT_IF_C BFu7c_Sf_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu7c_Sf_BFu15s");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu7c_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu15s, BFu7c_Sf_BFu15s)
//============================================================================



static void Test_BFu7c_Sf_BFu16i()
{
  {
    init_simple_test("BFu7c_Sf_BFu16i");
    static STRUCT_IF_C BFu7c_Sf_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu7c_Sf_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu7c_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu16i, BFu7c_Sf_BFu16i)
//============================================================================



static void Test_BFu7c_Sf_BFu16ll()
{
  {
    init_simple_test("BFu7c_Sf_BFu16ll");
    static STRUCT_IF_C BFu7c_Sf_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu7c_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu7c_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu16ll, BFu7c_Sf_BFu16ll)
//============================================================================



static void Test_BFu7c_Sf_BFu16s()
{
  {
    init_simple_test("BFu7c_Sf_BFu16s");
    static STRUCT_IF_C BFu7c_Sf_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu7c_Sf_BFu16s");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu7c_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu16s, BFu7c_Sf_BFu16s)
//============================================================================



static void Test_BFu7c_Sf_BFu17i()
{
  {
    init_simple_test("BFu7c_Sf_BFu17i");
    static STRUCT_IF_C BFu7c_Sf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu7c_Sf_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu7c_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu17i, BFu7c_Sf_BFu17i)
//============================================================================



static void Test_BFu7c_Sf_BFu17ll()
{
  {
    init_simple_test("BFu7c_Sf_BFu17ll");
    static STRUCT_IF_C BFu7c_Sf_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu7c_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu7c_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu17ll, BFu7c_Sf_BFu17ll)
//============================================================================



static void Test_BFu7c_Sf_BFu1c()
{
  {
    init_simple_test("BFu7c_Sf_BFu1c");
    static STRUCT_IF_C BFu7c_Sf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7c_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu1c, BFu7c_Sf_BFu1c)
//============================================================================



static void Test_BFu7c_Sf_BFu1i()
{
  {
    init_simple_test("BFu7c_Sf_BFu1i");
    static STRUCT_IF_C BFu7c_Sf_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7c_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu1i, BFu7c_Sf_BFu1i)
//============================================================================



static void Test_BFu7c_Sf_BFu1ll()
{
  {
    init_simple_test("BFu7c_Sf_BFu1ll");
    static STRUCT_IF_C BFu7c_Sf_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7c_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu1ll, BFu7c_Sf_BFu1ll)
//============================================================================



static void Test_BFu7c_Sf_BFu1s()
{
  {
    init_simple_test("BFu7c_Sf_BFu1s");
    static STRUCT_IF_C BFu7c_Sf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7c_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu1s, BFu7c_Sf_BFu1s)
//============================================================================



static void Test_BFu7c_Sf_BFu31i()
{
  {
    init_simple_test("BFu7c_Sf_BFu31i");
    static STRUCT_IF_C BFu7c_Sf_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu7c_Sf_BFu31i");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu7c_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu31i, BFu7c_Sf_BFu31i)
//============================================================================



static void Test_BFu7c_Sf_BFu31ll()
{
  {
    init_simple_test("BFu7c_Sf_BFu31ll");
    static STRUCT_IF_C BFu7c_Sf_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu7c_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu7c_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu31ll, BFu7c_Sf_BFu31ll)
//============================================================================



static void Test_BFu7c_Sf_BFu32i()
{
  {
    init_simple_test("BFu7c_Sf_BFu32i");
    static STRUCT_IF_C BFu7c_Sf_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu7c_Sf_BFu32i");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu7c_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu32i, BFu7c_Sf_BFu32i)
//============================================================================



static void Test_BFu7c_Sf_BFu32ll()
{
  {
    init_simple_test("BFu7c_Sf_BFu32ll");
    static STRUCT_IF_C BFu7c_Sf_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu7c_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu7c_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu32ll, BFu7c_Sf_BFu32ll)
//============================================================================



static void Test_BFu7c_Sf_BFu33()
{
  {
    init_simple_test("BFu7c_Sf_BFu33");
    static STRUCT_IF_C BFu7c_Sf_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu33");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 1, 0, 33, 1, "BFu7c_Sf_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, hide_ull(1LL<<32), "BFu7c_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu33, BFu7c_Sf_BFu33)
//============================================================================



static void Test_BFu7c_Sf_BFu7c()
{
  {
    init_simple_test("BFu7c_Sf_BFu7c");
    static STRUCT_IF_C BFu7c_Sf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7c_Sf_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu7c, BFu7c_Sf_BFu7c)
//============================================================================



static void Test_BFu7c_Sf_BFu7i()
{
  {
    init_simple_test("BFu7c_Sf_BFu7i");
    static STRUCT_IF_C BFu7c_Sf_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7c_Sf_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu7i, BFu7c_Sf_BFu7i)
//============================================================================



static void Test_BFu7c_Sf_BFu7ll()
{
  {
    init_simple_test("BFu7c_Sf_BFu7ll");
    static STRUCT_IF_C BFu7c_Sf_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7c_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu7ll, BFu7c_Sf_BFu7ll)
//============================================================================



static void Test_BFu7c_Sf_BFu7s()
{
  {
    init_simple_test("BFu7c_Sf_BFu7s");
    static STRUCT_IF_C BFu7c_Sf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7c_Sf_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu7s, BFu7c_Sf_BFu7s)
//============================================================================



static void Test_BFu7c_Sf_BFu8c()
{
  {
    init_simple_test("BFu7c_Sf_BFu8c");
    static STRUCT_IF_C BFu7c_Sf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7c_Sf_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7c_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu8c, BFu7c_Sf_BFu8c)
//============================================================================



static void Test_BFu7c_Sf_BFu8i()
{
  {
    init_simple_test("BFu7c_Sf_BFu8i");
    static STRUCT_IF_C BFu7c_Sf_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7c_Sf_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7c_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu8i, BFu7c_Sf_BFu8i)
//============================================================================



static void Test_BFu7c_Sf_BFu8ll()
{
  {
    init_simple_test("BFu7c_Sf_BFu8ll");
    static STRUCT_IF_C BFu7c_Sf_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7c_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7c_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu8ll, BFu7c_Sf_BFu8ll)
//============================================================================



static void Test_BFu7c_Sf_BFu8s()
{
  {
    init_simple_test("BFu7c_Sf_BFu8s");
    static STRUCT_IF_C BFu7c_Sf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7c_Sf_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7c_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu8s, BFu7c_Sf_BFu8s)
//============================================================================



static void Test_BFu7c_Sf_BFu9i()
{
  {
    init_simple_test("BFu7c_Sf_BFu9i");
    static STRUCT_IF_C BFu7c_Sf_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu7c_Sf_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu7c_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu9i, BFu7c_Sf_BFu9i)
//============================================================================



static void Test_BFu7c_Sf_BFu9ll()
{
  {
    init_simple_test("BFu7c_Sf_BFu9ll");
    static STRUCT_IF_C BFu7c_Sf_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu7c_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu7c_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu9ll, BFu7c_Sf_BFu9ll)
//============================================================================



static void Test_BFu7c_Sf_BFu9s()
{
  {
    init_simple_test("BFu7c_Sf_BFu9s");
    static STRUCT_IF_C BFu7c_Sf_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu7c_Sf_BFu9s");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu7c_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_BFu9s, BFu7c_Sf_BFu9s)
//============================================================================



static void Test_BFu7c_Sf_C()
{
  {
    init_simple_test("BFu7c_Sf_C");
    static STRUCT_IF_C BFu7c_Sf_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_C");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_C.v2");
    check_field_offset(lv, v3, 1, "BFu7c_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_C, BFu7c_Sf_C)
//============================================================================



static void Test_BFu7c_Sf_D()
{
  {
    init_simple_test("BFu7c_Sf_D");
    static STRUCT_IF_C BFu7c_Sf_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_D");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_D.v2");
    check_field_offset(lv, v3, 1, "BFu7c_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_D, BFu7c_Sf_D)
//============================================================================



static void Test_BFu7c_Sf_F()
{
  {
    init_simple_test("BFu7c_Sf_F");
    static STRUCT_IF_C BFu7c_Sf_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_F");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_F.v2");
    check_field_offset(lv, v3, 1, "BFu7c_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_F, BFu7c_Sf_F)
//============================================================================



static void Test_BFu7c_Sf_I()
{
  {
    init_simple_test("BFu7c_Sf_I");
    static STRUCT_IF_C BFu7c_Sf_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_I");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_I.v2");
    check_field_offset(lv, v3, 1, "BFu7c_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_I, BFu7c_Sf_I)
//============================================================================



static void Test_BFu7c_Sf_Ip()
{
  {
    init_simple_test("BFu7c_Sf_Ip");
    static STRUCT_IF_C BFu7c_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7c_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_Ip");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_Ip.v2");
    check_field_offset(lv, v3, 1, "BFu7c_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_Ip, BFu7c_Sf_Ip)
//============================================================================



static void Test_BFu7c_Sf_L()
{
  {
    init_simple_test("BFu7c_Sf_L");
    static STRUCT_IF_C BFu7c_Sf_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_L");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_L.v2");
    check_field_offset(lv, v3, 1, "BFu7c_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_L, BFu7c_Sf_L)
//============================================================================



static void Test_BFu7c_Sf_S()
{
  {
    init_simple_test("BFu7c_Sf_S");
    static STRUCT_IF_C BFu7c_Sf_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_S");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_S.v2");
    check_field_offset(lv, v3, 1, "BFu7c_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_S, BFu7c_Sf_S)
//============================================================================



static void Test_BFu7c_Sf_Sf()
{
  {
    init_simple_test("BFu7c_Sf_Sf");
    static STRUCT_IF_C BFu7c_Sf_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7c_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_Sf.v2");
    check_field_offset(lv, v3, 1, "BFu7c_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_Sf, BFu7c_Sf_Sf)
//============================================================================



static void Test_BFu7c_Sf_Uc()
{
  {
    init_simple_test("BFu7c_Sf_Uc");
    static STRUCT_IF_C BFu7c_Sf_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_Uc");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_Uc.v2");
    check_field_offset(lv, v3, 1, "BFu7c_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_Uc, BFu7c_Sf_Uc)
//============================================================================



static void Test_BFu7c_Sf_Ui()
{
  {
    init_simple_test("BFu7c_Sf_Ui");
    static STRUCT_IF_C BFu7c_Sf_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_Ui");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_Ui.v2");
    check_field_offset(lv, v3, 1, "BFu7c_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_Ui, BFu7c_Sf_Ui)
//============================================================================



static void Test_BFu7c_Sf_Ul()
{
  {
    init_simple_test("BFu7c_Sf_Ul");
    static STRUCT_IF_C BFu7c_Sf_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_Ul");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_Ul.v2");
    check_field_offset(lv, v3, 1, "BFu7c_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_Ul, BFu7c_Sf_Ul)
//============================================================================



static void Test_BFu7c_Sf_Us()
{
  {
    init_simple_test("BFu7c_Sf_Us");
    static STRUCT_IF_C BFu7c_Sf_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_Us");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_Us.v2");
    check_field_offset(lv, v3, 1, "BFu7c_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_Us, BFu7c_Sf_Us)
//============================================================================



static void Test_BFu7c_Sf_Vp()
{
  {
    init_simple_test("BFu7c_Sf_Vp");
    static STRUCT_IF_C BFu7c_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7c_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Sf_Vp");
    check_field_offset(lv, v2, 1, "BFu7c_Sf_Vp.v2");
    check_field_offset(lv, v3, 1, "BFu7c_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Sf_Vp, BFu7c_Sf_Vp)
//============================================================================



static void Test_BFu7c_Uc_Sf()
{
  {
    init_simple_test("BFu7c_Uc_Sf");
    static STRUCT_IF_C BFu7c_Uc_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_Sf, BFu7c_Uc_Sf)
//============================================================================



static void Test_BFu7c_Ui_Sf()
{
  {
    init_simple_test("BFu7c_Ui_Sf");
    static STRUCT_IF_C BFu7c_Ui_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7c_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_Ui_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu7c_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_Sf, BFu7c_Ui_Sf)
//============================================================================



static void Test_BFu7c_Ul_Sf()
{
  {
    init_simple_test("BFu7c_Ul_Sf");
    static STRUCT_IF_C BFu7c_Ul_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu7c_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_Ul_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu7c_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_Sf, BFu7c_Ul_Sf)
//============================================================================



static void Test_BFu7c_Us_Sf()
{
  {
    init_simple_test("BFu7c_Us_Sf");
    static STRUCT_IF_C BFu7c_Us_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_Us_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu7c_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_Sf, BFu7c_Us_Sf)
//============================================================================



static void Test_BFu7c_Vp_Sf()
{
  {
    init_simple_test("BFu7c_Vp_Sf");
    static STRUCT_IF_C BFu7c_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7c_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_Sf");
    check_field_offset(lv, v2, 1, "BFu7c_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7c_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_Sf, BFu7c_Vp_Sf)
//============================================================================



static void Test_BFu7i_BFu15i_Sf()
{
  {
    init_simple_test("BFu7i_BFu15i_Sf");
    static STRUCT_IF_C BFu7i_BFu15i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_Sf");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_Sf, BFu7i_BFu15i_Sf)
//============================================================================



static void Test_BFu7i_BFu15ll_Sf()
{
  {
    init_simple_test("BFu7i_BFu15ll_Sf");
    static STRUCT_IF_C BFu7i_BFu15ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_Sf");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_Sf, BFu7i_BFu15ll_Sf)
//============================================================================



static void Test_BFu7i_BFu15s_Sf()
{
  {
    init_simple_test("BFu7i_BFu15s_Sf");
    static STRUCT_IF_C BFu7i_BFu15s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_Sf");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_Sf, BFu7i_BFu15s_Sf)
//============================================================================



static void Test_BFu7i_BFu16i_Sf()
{
  {
    init_simple_test("BFu7i_BFu16i_Sf");
    static STRUCT_IF_C BFu7i_BFu16i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_Sf, BFu7i_BFu16i_Sf)
//============================================================================



static void Test_BFu7i_BFu16ll_Sf()
{
  {
    init_simple_test("BFu7i_BFu16ll_Sf");
    static STRUCT_IF_C BFu7i_BFu16ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_Sf, BFu7i_BFu16ll_Sf)
//============================================================================



static void Test_BFu7i_BFu16s_Sf()
{
  {
    init_simple_test("BFu7i_BFu16s_Sf");
    static STRUCT_IF_C BFu7i_BFu16s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_Sf");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_Sf, BFu7i_BFu16s_Sf)
//============================================================================



static void Test_BFu7i_BFu17i_Sf()
{
  {
    init_simple_test("BFu7i_BFu17i_Sf");
    static STRUCT_IF_C BFu7i_BFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_Sf");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_Sf, BFu7i_BFu17i_Sf)
//============================================================================



static void Test_BFu7i_BFu17ll_Sf()
{
  {
    init_simple_test("BFu7i_BFu17ll_Sf");
    static STRUCT_IF_C BFu7i_BFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_Sf");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_Sf, BFu7i_BFu17ll_Sf)
//============================================================================



static void Test_BFu7i_BFu1c_Sf()
{
  {
    init_simple_test("BFu7i_BFu1c_Sf");
    static STRUCT_IF_C BFu7i_BFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7i_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1c_Sf");
    check_field_offset(lv, v3, 1, "BFu7i_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1c_Sf, BFu7i_BFu1c_Sf)
//============================================================================



static void Test_BFu7i_BFu1i_Sf()
{
  {
    init_simple_test("BFu7i_BFu1i_Sf");
    static STRUCT_IF_C BFu7i_BFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7i_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1i_Sf");
    check_field_offset(lv, v3, 1, "BFu7i_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1i_Sf, BFu7i_BFu1i_Sf)
//============================================================================



static void Test_BFu7i_BFu1ll_Sf()
{
  {
    init_simple_test("BFu7i_BFu1ll_Sf");
    static STRUCT_IF_C BFu7i_BFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7i_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1ll_Sf");
    check_field_offset(lv, v3, 1, "BFu7i_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1ll_Sf, BFu7i_BFu1ll_Sf)
//============================================================================



static void Test_BFu7i_BFu1s_Sf()
{
  {
    init_simple_test("BFu7i_BFu1s_Sf");
    static STRUCT_IF_C BFu7i_BFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7i_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1s_Sf");
    check_field_offset(lv, v3, 1, "BFu7i_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1s_Sf, BFu7i_BFu1s_Sf)
//============================================================================



static void Test_BFu7i_BFu31i_Sf()
{
  {
    init_simple_test("BFu7i_BFu31i_Sf");
    static STRUCT_IF_C BFu7i_BFu31i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7i_BFu31i_Sf");
    check_field_offset(lv, v3, 5, "BFu7i_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu31i_Sf, BFu7i_BFu31i_Sf)
//============================================================================



static void Test_BFu7i_BFu31ll_Sf()
{
  {
    init_simple_test("BFu7i_BFu31ll_Sf");
    static STRUCT_IF_C BFu7i_BFu31ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7i_BFu31ll_Sf");
    check_field_offset(lv, v3, 5, "BFu7i_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu31ll_Sf, BFu7i_BFu31ll_Sf)
//============================================================================



static void Test_BFu7i_BFu32i_Sf()
{
  {
    init_simple_test("BFu7i_BFu32i_Sf");
    static STRUCT_IF_C BFu7i_BFu32i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7i_BFu32i_Sf");
    check_field_offset(lv, v3, 5, "BFu7i_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu32i_Sf, BFu7i_BFu32i_Sf)
//============================================================================



static void Test_BFu7i_BFu32ll_Sf()
{
  {
    init_simple_test("BFu7i_BFu32ll_Sf");
    static STRUCT_IF_C BFu7i_BFu32ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7i_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "BFu7i_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu32ll_Sf, BFu7i_BFu32ll_Sf)
//============================================================================



static void Test_BFu7i_BFu33_Sf()
{
  {
    init_simple_test("BFu7i_BFu33_Sf");
    static STRUCT_IF_C BFu7i_BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7i_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7i_BFu33_Sf");
    check_field_offset(lv, v3, 5, "BFu7i_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu33_Sf, BFu7i_BFu33_Sf)
//============================================================================



static void Test_BFu7i_BFu7c_Sf()
{
  {
    init_simple_test("BFu7i_BFu7c_Sf");
    static STRUCT_IF_C BFu7i_BFu7c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7c_Sf");
    check_field_offset(lv, v3, 2, "BFu7i_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7c_Sf, BFu7i_BFu7c_Sf)
//============================================================================



static void Test_BFu7i_BFu7i_Sf()
{
  {
    init_simple_test("BFu7i_BFu7i_Sf");
    static STRUCT_IF_C BFu7i_BFu7i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7i_Sf");
    check_field_offset(lv, v3, 2, "BFu7i_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7i_Sf, BFu7i_BFu7i_Sf)
//============================================================================



static void Test_BFu7i_BFu7ll_Sf()
{
  {
    init_simple_test("BFu7i_BFu7ll_Sf");
    static STRUCT_IF_C BFu7i_BFu7ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7ll_Sf");
    check_field_offset(lv, v3, 2, "BFu7i_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7ll_Sf, BFu7i_BFu7ll_Sf)
//============================================================================



static void Test_BFu7i_BFu7s_Sf()
{
  {
    init_simple_test("BFu7i_BFu7s_Sf");
    static STRUCT_IF_C BFu7i_BFu7s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7s_Sf");
    check_field_offset(lv, v3, 2, "BFu7i_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7s_Sf, BFu7i_BFu7s_Sf)
//============================================================================



static void Test_BFu7i_BFu8c_Sf()
{
  {
    init_simple_test("BFu7i_BFu8c_Sf");
    static STRUCT_IF_C BFu7i_BFu8c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "BFu7i_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8c_Sf, BFu7i_BFu8c_Sf)
//============================================================================



static void Test_BFu7i_BFu8i_Sf()
{
  {
    init_simple_test("BFu7i_BFu8i_Sf");
    static STRUCT_IF_C BFu7i_BFu8i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "BFu7i_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8i_Sf, BFu7i_BFu8i_Sf)
//============================================================================



static void Test_BFu7i_BFu8ll_Sf()
{
  {
    init_simple_test("BFu7i_BFu8ll_Sf");
    static STRUCT_IF_C BFu7i_BFu8ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "BFu7i_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8ll_Sf, BFu7i_BFu8ll_Sf)
//============================================================================



static void Test_BFu7i_BFu8s_Sf()
{
  {
    init_simple_test("BFu7i_BFu8s_Sf");
    static STRUCT_IF_C BFu7i_BFu8s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "BFu7i_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8s_Sf, BFu7i_BFu8s_Sf)
//============================================================================



static void Test_BFu7i_BFu9i_Sf()
{
  {
    init_simple_test("BFu7i_BFu9i_Sf");
    static STRUCT_IF_C BFu7i_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9i_Sf");
    check_field_offset(lv, v3, 2, "BFu7i_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9i_Sf, BFu7i_BFu9i_Sf)
//============================================================================



static void Test_BFu7i_BFu9ll_Sf()
{
  {
    init_simple_test("BFu7i_BFu9ll_Sf");
    static STRUCT_IF_C BFu7i_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9ll_Sf");
    check_field_offset(lv, v3, 2, "BFu7i_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9ll_Sf, BFu7i_BFu9ll_Sf)
//============================================================================



static void Test_BFu7i_BFu9s_Sf()
{
  {
    init_simple_test("BFu7i_BFu9s_Sf");
    static STRUCT_IF_C BFu7i_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9s_Sf");
    check_field_offset(lv, v3, 2, "BFu7i_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9s_Sf, BFu7i_BFu9s_Sf)
//============================================================================



static void Test_BFu7i_C_Sf()
{
  {
    init_simple_test("BFu7i_C_Sf");
    static STRUCT_IF_C BFu7i_C_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_C_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_C_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu7i_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_C_Sf, BFu7i_C_Sf)
//============================================================================



static void Test_BFu7i_D_Sf()
{
  {
    init_simple_test("BFu7i_D_Sf");
    static STRUCT_IF_C BFu7i_D_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu7i_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_D_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_D_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu7i_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_D_Sf, BFu7i_D_Sf)
//============================================================================



static void Test_BFu7i_F_Sf()
{
  {
    init_simple_test("BFu7i_F_Sf");
    static STRUCT_IF_C BFu7i_F_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_F_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_F_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu7i_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_F_Sf, BFu7i_F_Sf)
//============================================================================



static void Test_BFu7i_I_Sf()
{
  {
    init_simple_test("BFu7i_I_Sf");
    static STRUCT_IF_C BFu7i_I_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_I_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_I_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu7i_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_I_Sf, BFu7i_I_Sf)
//============================================================================



static void Test_BFu7i_Ip_Sf()
{
  {
    init_simple_test("BFu7i_Ip_Sf");
    static STRUCT_IF_C BFu7i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7i_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ip_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7i_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ip_Sf, BFu7i_Ip_Sf)
//============================================================================



static void Test_BFu7i_L_Sf()
{
  {
    init_simple_test("BFu7i_L_Sf");
    static STRUCT_IF_C BFu7i_L_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu7i_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_L_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_L_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu7i_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_L_Sf, BFu7i_L_Sf)
//============================================================================



static void Test_BFu7i_S_Sf()
{
  {
    init_simple_test("BFu7i_S_Sf");
    static STRUCT_IF_C BFu7i_S_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_S_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_S_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu7i_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_S_Sf, BFu7i_S_Sf)
//============================================================================



static void Test_BFu7i_Sf()
{
  {
    init_simple_test("BFu7i_Sf");
    static STRUCT_IF_C BFu7i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf, BFu7i_Sf)
//============================================================================



static void Test_BFu7i_Sf_BFu15i()
{
  {
    init_simple_test("BFu7i_Sf_BFu15i");
    static STRUCT_IF_C BFu7i_Sf_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu7i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu7i_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu15i, BFu7i_Sf_BFu15i)
//============================================================================



static void Test_BFu7i_Sf_BFu15ll()
{
  {
    init_simple_test("BFu7i_Sf_BFu15ll");
    static STRUCT_IF_C BFu7i_Sf_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu7i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu7i_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu15ll, BFu7i_Sf_BFu15ll)
//============================================================================



static void Test_BFu7i_Sf_BFu15s()
{
  {
    init_simple_test("BFu7i_Sf_BFu15s");
    static STRUCT_IF_C BFu7i_Sf_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu7i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu7i_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu15s, BFu7i_Sf_BFu15s)
//============================================================================



static void Test_BFu7i_Sf_BFu16i()
{
  {
    init_simple_test("BFu7i_Sf_BFu16i");
    static STRUCT_IF_C BFu7i_Sf_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu7i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu7i_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu16i, BFu7i_Sf_BFu16i)
//============================================================================



static void Test_BFu7i_Sf_BFu16ll()
{
  {
    init_simple_test("BFu7i_Sf_BFu16ll");
    static STRUCT_IF_C BFu7i_Sf_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu7i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu7i_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu16ll, BFu7i_Sf_BFu16ll)
//============================================================================



static void Test_BFu7i_Sf_BFu16s()
{
  {
    init_simple_test("BFu7i_Sf_BFu16s");
    static STRUCT_IF_C BFu7i_Sf_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu7i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu7i_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu16s, BFu7i_Sf_BFu16s)
//============================================================================



static void Test_BFu7i_Sf_BFu17i()
{
  {
    init_simple_test("BFu7i_Sf_BFu17i");
    static STRUCT_IF_C BFu7i_Sf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu7i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu7i_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu17i, BFu7i_Sf_BFu17i)
//============================================================================



static void Test_BFu7i_Sf_BFu17ll()
{
  {
    init_simple_test("BFu7i_Sf_BFu17ll");
    static STRUCT_IF_C BFu7i_Sf_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu7i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu7i_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu17ll, BFu7i_Sf_BFu17ll)
//============================================================================



static void Test_BFu7i_Sf_BFu1c()
{
  {
    init_simple_test("BFu7i_Sf_BFu1c");
    static STRUCT_IF_C BFu7i_Sf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7i_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu1c, BFu7i_Sf_BFu1c)
//============================================================================



static void Test_BFu7i_Sf_BFu1i()
{
  {
    init_simple_test("BFu7i_Sf_BFu1i");
    static STRUCT_IF_C BFu7i_Sf_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7i_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu1i, BFu7i_Sf_BFu1i)
//============================================================================



static void Test_BFu7i_Sf_BFu1ll()
{
  {
    init_simple_test("BFu7i_Sf_BFu1ll");
    static STRUCT_IF_C BFu7i_Sf_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7i_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu1ll, BFu7i_Sf_BFu1ll)
//============================================================================



static void Test_BFu7i_Sf_BFu1s()
{
  {
    init_simple_test("BFu7i_Sf_BFu1s");
    static STRUCT_IF_C BFu7i_Sf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7i_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu1s, BFu7i_Sf_BFu1s)
//============================================================================



static void Test_BFu7i_Sf_BFu31i()
{
  {
    init_simple_test("BFu7i_Sf_BFu31i");
    static STRUCT_IF_C BFu7i_Sf_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu7i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu7i_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu31i, BFu7i_Sf_BFu31i)
//============================================================================



static void Test_BFu7i_Sf_BFu31ll()
{
  {
    init_simple_test("BFu7i_Sf_BFu31ll");
    static STRUCT_IF_C BFu7i_Sf_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu7i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu7i_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu31ll, BFu7i_Sf_BFu31ll)
//============================================================================



static void Test_BFu7i_Sf_BFu32i()
{
  {
    init_simple_test("BFu7i_Sf_BFu32i");
    static STRUCT_IF_C BFu7i_Sf_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu7i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu7i_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu32i, BFu7i_Sf_BFu32i)
//============================================================================



static void Test_BFu7i_Sf_BFu32ll()
{
  {
    init_simple_test("BFu7i_Sf_BFu32ll");
    static STRUCT_IF_C BFu7i_Sf_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu7i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu7i_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu32ll, BFu7i_Sf_BFu32ll)
//============================================================================



static void Test_BFu7i_Sf_BFu33()
{
  {
    init_simple_test("BFu7i_Sf_BFu33");
    static STRUCT_IF_C BFu7i_Sf_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu7i_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu33");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 1, 0, 33, 1, "BFu7i_Sf_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, hide_ull(1LL<<32), "BFu7i_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu33, BFu7i_Sf_BFu33)
//============================================================================



static void Test_BFu7i_Sf_BFu7c()
{
  {
    init_simple_test("BFu7i_Sf_BFu7c");
    static STRUCT_IF_C BFu7i_Sf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu7c, BFu7i_Sf_BFu7c)
//============================================================================



static void Test_BFu7i_Sf_BFu7i()
{
  {
    init_simple_test("BFu7i_Sf_BFu7i");
    static STRUCT_IF_C BFu7i_Sf_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu7i, BFu7i_Sf_BFu7i)
//============================================================================



static void Test_BFu7i_Sf_BFu7ll()
{
  {
    init_simple_test("BFu7i_Sf_BFu7ll");
    static STRUCT_IF_C BFu7i_Sf_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu7ll, BFu7i_Sf_BFu7ll)
//============================================================================



static void Test_BFu7i_Sf_BFu7s()
{
  {
    init_simple_test("BFu7i_Sf_BFu7s");
    static STRUCT_IF_C BFu7i_Sf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu7s, BFu7i_Sf_BFu7s)
//============================================================================



static void Test_BFu7i_Sf_BFu8c()
{
  {
    init_simple_test("BFu7i_Sf_BFu8c");
    static STRUCT_IF_C BFu7i_Sf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7i_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu8c, BFu7i_Sf_BFu8c)
//============================================================================



static void Test_BFu7i_Sf_BFu8i()
{
  {
    init_simple_test("BFu7i_Sf_BFu8i");
    static STRUCT_IF_C BFu7i_Sf_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7i_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu8i, BFu7i_Sf_BFu8i)
//============================================================================



static void Test_BFu7i_Sf_BFu8ll()
{
  {
    init_simple_test("BFu7i_Sf_BFu8ll");
    static STRUCT_IF_C BFu7i_Sf_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7i_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu8ll, BFu7i_Sf_BFu8ll)
//============================================================================



static void Test_BFu7i_Sf_BFu8s()
{
  {
    init_simple_test("BFu7i_Sf_BFu8s");
    static STRUCT_IF_C BFu7i_Sf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7i_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu8s, BFu7i_Sf_BFu8s)
//============================================================================



static void Test_BFu7i_Sf_BFu9i()
{
  {
    init_simple_test("BFu7i_Sf_BFu9i");
    static STRUCT_IF_C BFu7i_Sf_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu7i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu7i_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu9i, BFu7i_Sf_BFu9i)
//============================================================================



static void Test_BFu7i_Sf_BFu9ll()
{
  {
    init_simple_test("BFu7i_Sf_BFu9ll");
    static STRUCT_IF_C BFu7i_Sf_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu7i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu7i_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu9ll, BFu7i_Sf_BFu9ll)
//============================================================================



static void Test_BFu7i_Sf_BFu9s()
{
  {
    init_simple_test("BFu7i_Sf_BFu9s");
    static STRUCT_IF_C BFu7i_Sf_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu7i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu7i_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_BFu9s, BFu7i_Sf_BFu9s)
//============================================================================



static void Test_BFu7i_Sf_C()
{
  {
    init_simple_test("BFu7i_Sf_C");
    static STRUCT_IF_C BFu7i_Sf_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_C");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_C.v2");
    check_field_offset(lv, v3, 1, "BFu7i_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_C, BFu7i_Sf_C)
//============================================================================



static void Test_BFu7i_Sf_D()
{
  {
    init_simple_test("BFu7i_Sf_D");
    static STRUCT_IF_C BFu7i_Sf_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu7i_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_D");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_D.v2");
    check_field_offset(lv, v3, 1, "BFu7i_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_D, BFu7i_Sf_D)
//============================================================================



static void Test_BFu7i_Sf_F()
{
  {
    init_simple_test("BFu7i_Sf_F");
    static STRUCT_IF_C BFu7i_Sf_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_F");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_F.v2");
    check_field_offset(lv, v3, 1, "BFu7i_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_F, BFu7i_Sf_F)
//============================================================================



static void Test_BFu7i_Sf_I()
{
  {
    init_simple_test("BFu7i_Sf_I");
    static STRUCT_IF_C BFu7i_Sf_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_I");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_I.v2");
    check_field_offset(lv, v3, 1, "BFu7i_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_I, BFu7i_Sf_I)
//============================================================================



static void Test_BFu7i_Sf_Ip()
{
  {
    init_simple_test("BFu7i_Sf_Ip");
    static STRUCT_IF_C BFu7i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7i_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_Ip");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_Ip.v2");
    check_field_offset(lv, v3, 1, "BFu7i_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_Ip, BFu7i_Sf_Ip)
//============================================================================



static void Test_BFu7i_Sf_L()
{
  {
    init_simple_test("BFu7i_Sf_L");
    static STRUCT_IF_C BFu7i_Sf_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu7i_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_L");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_L.v2");
    check_field_offset(lv, v3, 1, "BFu7i_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_L, BFu7i_Sf_L)
//============================================================================



static void Test_BFu7i_Sf_S()
{
  {
    init_simple_test("BFu7i_Sf_S");
    static STRUCT_IF_C BFu7i_Sf_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_S");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_S.v2");
    check_field_offset(lv, v3, 1, "BFu7i_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_S, BFu7i_Sf_S)
//============================================================================



static void Test_BFu7i_Sf_Sf()
{
  {
    init_simple_test("BFu7i_Sf_Sf");
    static STRUCT_IF_C BFu7i_Sf_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7i_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_Sf.v2");
    check_field_offset(lv, v3, 1, "BFu7i_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_Sf, BFu7i_Sf_Sf)
//============================================================================



static void Test_BFu7i_Sf_Uc()
{
  {
    init_simple_test("BFu7i_Sf_Uc");
    static STRUCT_IF_C BFu7i_Sf_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_Uc");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_Uc.v2");
    check_field_offset(lv, v3, 1, "BFu7i_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_Uc, BFu7i_Sf_Uc)
//============================================================================



static void Test_BFu7i_Sf_Ui()
{
  {
    init_simple_test("BFu7i_Sf_Ui");
    static STRUCT_IF_C BFu7i_Sf_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_Ui");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_Ui.v2");
    check_field_offset(lv, v3, 1, "BFu7i_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_Ui, BFu7i_Sf_Ui)
//============================================================================



static void Test_BFu7i_Sf_Ul()
{
  {
    init_simple_test("BFu7i_Sf_Ul");
    static STRUCT_IF_C BFu7i_Sf_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu7i_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_Ul");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_Ul.v2");
    check_field_offset(lv, v3, 1, "BFu7i_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_Ul, BFu7i_Sf_Ul)
//============================================================================



static void Test_BFu7i_Sf_Us()
{
  {
    init_simple_test("BFu7i_Sf_Us");
    static STRUCT_IF_C BFu7i_Sf_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_Us");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_Us.v2");
    check_field_offset(lv, v3, 1, "BFu7i_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_Us, BFu7i_Sf_Us)
//============================================================================



static void Test_BFu7i_Sf_Vp()
{
  {
    init_simple_test("BFu7i_Sf_Vp");
    static STRUCT_IF_C BFu7i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7i_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Sf_Vp");
    check_field_offset(lv, v2, 1, "BFu7i_Sf_Vp.v2");
    check_field_offset(lv, v3, 1, "BFu7i_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Sf_Vp, BFu7i_Sf_Vp)
//============================================================================



static void Test_BFu7i_Uc_Sf()
{
  {
    init_simple_test("BFu7i_Uc_Sf");
    static STRUCT_IF_C BFu7i_Uc_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7i_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Uc_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu7i_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Uc_Sf, BFu7i_Uc_Sf)
//============================================================================



static void Test_BFu7i_Ui_Sf()
{
  {
    init_simple_test("BFu7i_Ui_Sf");
    static STRUCT_IF_C BFu7i_Ui_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7i_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ui_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_Ui_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu7i_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ui_Sf, BFu7i_Ui_Sf)
//============================================================================



static void Test_BFu7i_Ul_Sf()
{
  {
    init_simple_test("BFu7i_Ul_Sf");
    static STRUCT_IF_C BFu7i_Ul_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu7i_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ul_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_Ul_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu7i_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ul_Sf, BFu7i_Ul_Sf)
//============================================================================



static void Test_BFu7i_Us_Sf()
{
  {
    init_simple_test("BFu7i_Us_Sf");
    static STRUCT_IF_C BFu7i_Us_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7i_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Us_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_Us_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu7i_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Us_Sf, BFu7i_Us_Sf)
//============================================================================



static void Test_BFu7i_Vp_Sf()
{
  {
    init_simple_test("BFu7i_Vp_Sf");
    static STRUCT_IF_C BFu7i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7i_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Vp_Sf");
    check_field_offset(lv, v2, 1, "BFu7i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7i_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Vp_Sf, BFu7i_Vp_Sf)
//============================================================================



static void Test_BFu7ll_BFu15i_Sf()
{
  {
    init_simple_test("BFu7ll_BFu15i_Sf");
    static STRUCT_IF_C BFu7ll_BFu15i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7ll_BFu15i_Sf");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15i_Sf, BFu7ll_BFu15i_Sf)
//============================================================================



static void Test_BFu7ll_BFu15ll_Sf()
{
  {
    init_simple_test("BFu7ll_BFu15ll_Sf");
    static STRUCT_IF_C BFu7ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15ll_Sf, BFu7ll_BFu15ll_Sf)
//============================================================================



static void Test_BFu7ll_BFu15s_Sf()
{
  {
    init_simple_test("BFu7ll_BFu15s_Sf");
    static STRUCT_IF_C BFu7ll_BFu15s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7ll_BFu15s_Sf");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15s_Sf, BFu7ll_BFu15s_Sf)
//============================================================================



static void Test_BFu7ll_BFu16i_Sf()
{
  {
    init_simple_test("BFu7ll_BFu16i_Sf");
    static STRUCT_IF_C BFu7ll_BFu16i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7ll_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16i_Sf, BFu7ll_BFu16i_Sf)
//============================================================================



static void Test_BFu7ll_BFu16ll_Sf()
{
  {
    init_simple_test("BFu7ll_BFu16ll_Sf");
    static STRUCT_IF_C BFu7ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16ll_Sf, BFu7ll_BFu16ll_Sf)
//============================================================================



static void Test_BFu7ll_BFu16s_Sf()
{
  {
    init_simple_test("BFu7ll_BFu16s_Sf");
    static STRUCT_IF_C BFu7ll_BFu16s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7ll_BFu16s_Sf");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16s_Sf, BFu7ll_BFu16s_Sf)
//============================================================================



static void Test_BFu7ll_BFu17i_Sf()
{
  {
    init_simple_test("BFu7ll_BFu17i_Sf");
    static STRUCT_IF_C BFu7ll_BFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7ll_BFu17i_Sf");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu17i_Sf, BFu7ll_BFu17i_Sf)
//============================================================================



static void Test_BFu7ll_BFu17ll_Sf()
{
  {
    init_simple_test("BFu7ll_BFu17ll_Sf");
    static STRUCT_IF_C BFu7ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu17ll_Sf, BFu7ll_BFu17ll_Sf)
//============================================================================



static void Test_BFu7ll_BFu1c_Sf()
{
  {
    init_simple_test("BFu7ll_BFu1c_Sf");
    static STRUCT_IF_C BFu7ll_BFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7ll_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1c_Sf");
    check_field_offset(lv, v3, 1, "BFu7ll_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1c_Sf, BFu7ll_BFu1c_Sf)
//============================================================================



static void Test_BFu7ll_BFu1i_Sf()
{
  {
    init_simple_test("BFu7ll_BFu1i_Sf");
    static STRUCT_IF_C BFu7ll_BFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7ll_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1i_Sf");
    check_field_offset(lv, v3, 1, "BFu7ll_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1i_Sf, BFu7ll_BFu1i_Sf)
//============================================================================



static void Test_BFu7ll_BFu1ll_Sf()
{
  {
    init_simple_test("BFu7ll_BFu1ll_Sf");
    static STRUCT_IF_C BFu7ll_BFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7ll_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 1, "BFu7ll_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1ll_Sf, BFu7ll_BFu1ll_Sf)
//============================================================================



static void Test_BFu7ll_BFu1s_Sf()
{
  {
    init_simple_test("BFu7ll_BFu1s_Sf");
    static STRUCT_IF_C BFu7ll_BFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7ll_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1s_Sf");
    check_field_offset(lv, v3, 1, "BFu7ll_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1s_Sf, BFu7ll_BFu1s_Sf)
//============================================================================



static void Test_BFu7ll_BFu31i_Sf()
{
  {
    init_simple_test("BFu7ll_BFu31i_Sf");
    static STRUCT_IF_C BFu7ll_BFu31i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7ll_BFu31i_Sf");
    check_field_offset(lv, v3, 5, "BFu7ll_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu31i_Sf, BFu7ll_BFu31i_Sf)
//============================================================================



static void Test_BFu7ll_BFu31ll_Sf()
{
  {
    init_simple_test("BFu7ll_BFu31ll_Sf");
    static STRUCT_IF_C BFu7ll_BFu31ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7ll_BFu31ll_Sf");
    check_field_offset(lv, v3, 5, "BFu7ll_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu31ll_Sf, BFu7ll_BFu31ll_Sf)
//============================================================================



static void Test_BFu7ll_BFu32i_Sf()
{
  {
    init_simple_test("BFu7ll_BFu32i_Sf");
    static STRUCT_IF_C BFu7ll_BFu32i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7ll_BFu32i_Sf");
    check_field_offset(lv, v3, 5, "BFu7ll_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu32i_Sf, BFu7ll_BFu32i_Sf)
//============================================================================



static void Test_BFu7ll_BFu32ll_Sf()
{
  {
    init_simple_test("BFu7ll_BFu32ll_Sf");
    static STRUCT_IF_C BFu7ll_BFu32ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7ll_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "BFu7ll_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu32ll_Sf, BFu7ll_BFu32ll_Sf)
//============================================================================



static void Test_BFu7ll_BFu33_Sf()
{
  {
    init_simple_test("BFu7ll_BFu33_Sf");
    static STRUCT_IF_C BFu7ll_BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7ll_BFu33_Sf");
    check_field_offset(lv, v3, 5, "BFu7ll_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu33_Sf, BFu7ll_BFu33_Sf)
//============================================================================



static void Test_BFu7ll_BFu7c_Sf()
{
  {
    init_simple_test("BFu7ll_BFu7c_Sf");
    static STRUCT_IF_C BFu7ll_BFu7c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7c_Sf");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7c_Sf, BFu7ll_BFu7c_Sf)
//============================================================================



static void Test_BFu7ll_BFu7i_Sf()
{
  {
    init_simple_test("BFu7ll_BFu7i_Sf");
    static STRUCT_IF_C BFu7ll_BFu7i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7i_Sf");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7i_Sf, BFu7ll_BFu7i_Sf)
//============================================================================



static void Test_BFu7ll_BFu7ll_Sf()
{
  {
    init_simple_test("BFu7ll_BFu7ll_Sf");
    static STRUCT_IF_C BFu7ll_BFu7ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7ll_Sf");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7ll_Sf, BFu7ll_BFu7ll_Sf)
//============================================================================



static void Test_BFu7ll_BFu7s_Sf()
{
  {
    init_simple_test("BFu7ll_BFu7s_Sf");
    static STRUCT_IF_C BFu7ll_BFu7s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7s_Sf");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7s_Sf, BFu7ll_BFu7s_Sf)
//============================================================================



static void Test_BFu7ll_BFu8c_Sf()
{
  {
    init_simple_test("BFu7ll_BFu8c_Sf");
    static STRUCT_IF_C BFu7ll_BFu8c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7ll_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu8c_Sf, BFu7ll_BFu8c_Sf)
//============================================================================



static void Test_BFu7ll_BFu8i_Sf()
{
  {
    init_simple_test("BFu7ll_BFu8i_Sf");
    static STRUCT_IF_C BFu7ll_BFu8i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7ll_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu8i_Sf, BFu7ll_BFu8i_Sf)
//============================================================================



static void Test_BFu7ll_BFu8ll_Sf()
{
  {
    init_simple_test("BFu7ll_BFu8ll_Sf");
    static STRUCT_IF_C BFu7ll_BFu8ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7ll_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu8ll_Sf, BFu7ll_BFu8ll_Sf)
//============================================================================



static void Test_BFu7ll_BFu8s_Sf()
{
  {
    init_simple_test("BFu7ll_BFu8s_Sf");
    static STRUCT_IF_C BFu7ll_BFu8s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7ll_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu8s_Sf, BFu7ll_BFu8s_Sf)
//============================================================================



static void Test_BFu7ll_BFu9i_Sf()
{
  {
    init_simple_test("BFu7ll_BFu9i_Sf");
    static STRUCT_IF_C BFu7ll_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7ll_BFu9i_Sf");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu9i_Sf, BFu7ll_BFu9i_Sf)
//============================================================================



static void Test_BFu7ll_BFu9ll_Sf()
{
  {
    init_simple_test("BFu7ll_BFu9ll_Sf");
    static STRUCT_IF_C BFu7ll_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7ll_BFu9ll_Sf");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu9ll_Sf, BFu7ll_BFu9ll_Sf)
//============================================================================



static void Test_BFu7ll_BFu9s_Sf()
{
  {
    init_simple_test("BFu7ll_BFu9s_Sf");
    static STRUCT_IF_C BFu7ll_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7ll_BFu9s_Sf");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu9s_Sf, BFu7ll_BFu9s_Sf)
//============================================================================



static void Test_BFu7ll_C_Sf()
{
  {
    init_simple_test("BFu7ll_C_Sf");
    static STRUCT_IF_C BFu7ll_C_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_C_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_C_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu7ll_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_C_Sf, BFu7ll_C_Sf)
//============================================================================



static void Test_BFu7ll_D_Sf()
{
  {
    init_simple_test("BFu7ll_D_Sf");
    static STRUCT_IF_C BFu7ll_D_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu7ll_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_D_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_D_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu7ll_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_D_Sf, BFu7ll_D_Sf)
//============================================================================



static void Test_BFu7ll_F_Sf()
{
  {
    init_simple_test("BFu7ll_F_Sf");
    static STRUCT_IF_C BFu7ll_F_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_F_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_F_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu7ll_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_F_Sf, BFu7ll_F_Sf)
//============================================================================



static void Test_BFu7ll_I_Sf()
{
  {
    init_simple_test("BFu7ll_I_Sf");
    static STRUCT_IF_C BFu7ll_I_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_I_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_I_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu7ll_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_I_Sf, BFu7ll_I_Sf)
//============================================================================



static void Test_BFu7ll_Ip_Sf()
{
  {
    init_simple_test("BFu7ll_Ip_Sf");
    static STRUCT_IF_C BFu7ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7ll_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Ip_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7ll_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Ip_Sf, BFu7ll_Ip_Sf)
//============================================================================



static void Test_BFu7ll_L_Sf()
{
  {
    init_simple_test("BFu7ll_L_Sf");
    static STRUCT_IF_C BFu7ll_L_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu7ll_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_L_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_L_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu7ll_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_L_Sf, BFu7ll_L_Sf)
//============================================================================



static void Test_BFu7ll_S_Sf()
{
  {
    init_simple_test("BFu7ll_S_Sf");
    static STRUCT_IF_C BFu7ll_S_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_S_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_S_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu7ll_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_S_Sf, BFu7ll_S_Sf)
//============================================================================



static void Test_BFu7ll_Sf()
{
  {
    init_simple_test("BFu7ll_Sf");
    static STRUCT_IF_C BFu7ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf, BFu7ll_Sf)
//============================================================================



static void Test_BFu7ll_Sf_BFu15i()
{
  {
    init_simple_test("BFu7ll_Sf_BFu15i");
    static STRUCT_IF_C BFu7ll_Sf_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu7ll_Sf_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu7ll_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu15i, BFu7ll_Sf_BFu15i)
//============================================================================



static void Test_BFu7ll_Sf_BFu15ll()
{
  {
    init_simple_test("BFu7ll_Sf_BFu15ll");
    static STRUCT_IF_C BFu7ll_Sf_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu7ll_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu7ll_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu15ll, BFu7ll_Sf_BFu15ll)
//============================================================================



static void Test_BFu7ll_Sf_BFu15s()
{
  {
    init_simple_test("BFu7ll_Sf_BFu15s");
    static STRUCT_IF_C BFu7ll_Sf_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu7ll_Sf_BFu15s");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu7ll_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu15s, BFu7ll_Sf_BFu15s)
//============================================================================



static void Test_BFu7ll_Sf_BFu16i()
{
  {
    init_simple_test("BFu7ll_Sf_BFu16i");
    static STRUCT_IF_C BFu7ll_Sf_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu7ll_Sf_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu7ll_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu16i, BFu7ll_Sf_BFu16i)
//============================================================================



static void Test_BFu7ll_Sf_BFu16ll()
{
  {
    init_simple_test("BFu7ll_Sf_BFu16ll");
    static STRUCT_IF_C BFu7ll_Sf_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu7ll_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu7ll_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu16ll, BFu7ll_Sf_BFu16ll)
//============================================================================



static void Test_BFu7ll_Sf_BFu16s()
{
  {
    init_simple_test("BFu7ll_Sf_BFu16s");
    static STRUCT_IF_C BFu7ll_Sf_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu7ll_Sf_BFu16s");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu7ll_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu16s, BFu7ll_Sf_BFu16s)
//============================================================================



static void Test_BFu7ll_Sf_BFu17i()
{
  {
    init_simple_test("BFu7ll_Sf_BFu17i");
    static STRUCT_IF_C BFu7ll_Sf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7ll_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu7ll_Sf_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu7ll_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu17i, BFu7ll_Sf_BFu17i)
//============================================================================



static void Test_BFu7ll_Sf_BFu17ll()
{
  {
    init_simple_test("BFu7ll_Sf_BFu17ll");
    static STRUCT_IF_C BFu7ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7ll_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu7ll_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu7ll_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu17ll, BFu7ll_Sf_BFu17ll)
//============================================================================



static void Test_BFu7ll_Sf_BFu1c()
{
  {
    init_simple_test("BFu7ll_Sf_BFu1c");
    static STRUCT_IF_C BFu7ll_Sf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7ll_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu1c, BFu7ll_Sf_BFu1c)
//============================================================================



static void Test_BFu7ll_Sf_BFu1i()
{
  {
    init_simple_test("BFu7ll_Sf_BFu1i");
    static STRUCT_IF_C BFu7ll_Sf_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7ll_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu1i, BFu7ll_Sf_BFu1i)
//============================================================================



static void Test_BFu7ll_Sf_BFu1ll()
{
  {
    init_simple_test("BFu7ll_Sf_BFu1ll");
    static STRUCT_IF_C BFu7ll_Sf_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7ll_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu1ll, BFu7ll_Sf_BFu1ll)
//============================================================================



static void Test_BFu7ll_Sf_BFu1s()
{
  {
    init_simple_test("BFu7ll_Sf_BFu1s");
    static STRUCT_IF_C BFu7ll_Sf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7ll_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu1s, BFu7ll_Sf_BFu1s)
//============================================================================



static void Test_BFu7ll_Sf_BFu31i()
{
  {
    init_simple_test("BFu7ll_Sf_BFu31i");
    static STRUCT_IF_C BFu7ll_Sf_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu7ll_Sf_BFu31i");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu7ll_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu31i, BFu7ll_Sf_BFu31i)
//============================================================================



static void Test_BFu7ll_Sf_BFu31ll()
{
  {
    init_simple_test("BFu7ll_Sf_BFu31ll");
    static STRUCT_IF_C BFu7ll_Sf_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu7ll_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu7ll_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu31ll, BFu7ll_Sf_BFu31ll)
//============================================================================



static void Test_BFu7ll_Sf_BFu32i()
{
  {
    init_simple_test("BFu7ll_Sf_BFu32i");
    static STRUCT_IF_C BFu7ll_Sf_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu7ll_Sf_BFu32i");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu7ll_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu32i, BFu7ll_Sf_BFu32i)
//============================================================================



static void Test_BFu7ll_Sf_BFu32ll()
{
  {
    init_simple_test("BFu7ll_Sf_BFu32ll");
    static STRUCT_IF_C BFu7ll_Sf_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu7ll_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu7ll_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu32ll, BFu7ll_Sf_BFu32ll)
//============================================================================



static void Test_BFu7ll_Sf_BFu33()
{
  {
    init_simple_test("BFu7ll_Sf_BFu33");
    static STRUCT_IF_C BFu7ll_Sf_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu7ll_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu33");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 1, 0, 33, 1, "BFu7ll_Sf_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, hide_ull(1LL<<32), "BFu7ll_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu33, BFu7ll_Sf_BFu33)
//============================================================================



static void Test_BFu7ll_Sf_BFu7c()
{
  {
    init_simple_test("BFu7ll_Sf_BFu7c");
    static STRUCT_IF_C BFu7ll_Sf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7ll_Sf_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu7c, BFu7ll_Sf_BFu7c)
//============================================================================



static void Test_BFu7ll_Sf_BFu7i()
{
  {
    init_simple_test("BFu7ll_Sf_BFu7i");
    static STRUCT_IF_C BFu7ll_Sf_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7ll_Sf_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu7i, BFu7ll_Sf_BFu7i)
//============================================================================



static void Test_BFu7ll_Sf_BFu7ll()
{
  {
    init_simple_test("BFu7ll_Sf_BFu7ll");
    static STRUCT_IF_C BFu7ll_Sf_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7ll_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu7ll, BFu7ll_Sf_BFu7ll)
//============================================================================



static void Test_BFu7ll_Sf_BFu7s()
{
  {
    init_simple_test("BFu7ll_Sf_BFu7s");
    static STRUCT_IF_C BFu7ll_Sf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7ll_Sf_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu7s, BFu7ll_Sf_BFu7s)
//============================================================================



static void Test_BFu7ll_Sf_BFu8c()
{
  {
    init_simple_test("BFu7ll_Sf_BFu8c");
    static STRUCT_IF_C BFu7ll_Sf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7ll_Sf_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7ll_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu8c, BFu7ll_Sf_BFu8c)
//============================================================================



static void Test_BFu7ll_Sf_BFu8i()
{
  {
    init_simple_test("BFu7ll_Sf_BFu8i");
    static STRUCT_IF_C BFu7ll_Sf_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7ll_Sf_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7ll_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu8i, BFu7ll_Sf_BFu8i)
//============================================================================



static void Test_BFu7ll_Sf_BFu8ll()
{
  {
    init_simple_test("BFu7ll_Sf_BFu8ll");
    static STRUCT_IF_C BFu7ll_Sf_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7ll_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7ll_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu8ll, BFu7ll_Sf_BFu8ll)
//============================================================================



static void Test_BFu7ll_Sf_BFu8s()
{
  {
    init_simple_test("BFu7ll_Sf_BFu8s");
    static STRUCT_IF_C BFu7ll_Sf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7ll_Sf_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7ll_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu8s, BFu7ll_Sf_BFu8s)
//============================================================================



static void Test_BFu7ll_Sf_BFu9i()
{
  {
    init_simple_test("BFu7ll_Sf_BFu9i");
    static STRUCT_IF_C BFu7ll_Sf_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu7ll_Sf_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu7ll_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu9i, BFu7ll_Sf_BFu9i)
//============================================================================



static void Test_BFu7ll_Sf_BFu9ll()
{
  {
    init_simple_test("BFu7ll_Sf_BFu9ll");
    static STRUCT_IF_C BFu7ll_Sf_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu7ll_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu7ll_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu9ll, BFu7ll_Sf_BFu9ll)
//============================================================================



static void Test_BFu7ll_Sf_BFu9s()
{
  {
    init_simple_test("BFu7ll_Sf_BFu9s");
    static STRUCT_IF_C BFu7ll_Sf_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu7ll_Sf_BFu9s");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu7ll_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_BFu9s, BFu7ll_Sf_BFu9s)
//============================================================================



static void Test_BFu7ll_Sf_C()
{
  {
    init_simple_test("BFu7ll_Sf_C");
    static STRUCT_IF_C BFu7ll_Sf_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_C");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_C.v2");
    check_field_offset(lv, v3, 1, "BFu7ll_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_C, BFu7ll_Sf_C)
//============================================================================



static void Test_BFu7ll_Sf_D()
{
  {
    init_simple_test("BFu7ll_Sf_D");
    static STRUCT_IF_C BFu7ll_Sf_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu7ll_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_D");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_D.v2");
    check_field_offset(lv, v3, 1, "BFu7ll_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_D, BFu7ll_Sf_D)
//============================================================================



static void Test_BFu7ll_Sf_F()
{
  {
    init_simple_test("BFu7ll_Sf_F");
    static STRUCT_IF_C BFu7ll_Sf_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_F");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_F.v2");
    check_field_offset(lv, v3, 1, "BFu7ll_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_F, BFu7ll_Sf_F)
//============================================================================



static void Test_BFu7ll_Sf_I()
{
  {
    init_simple_test("BFu7ll_Sf_I");
    static STRUCT_IF_C BFu7ll_Sf_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_I");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_I.v2");
    check_field_offset(lv, v3, 1, "BFu7ll_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_I, BFu7ll_Sf_I)
//============================================================================



static void Test_BFu7ll_Sf_Ip()
{
  {
    init_simple_test("BFu7ll_Sf_Ip");
    static STRUCT_IF_C BFu7ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7ll_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_Ip");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_Ip.v2");
    check_field_offset(lv, v3, 1, "BFu7ll_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_Ip, BFu7ll_Sf_Ip)
//============================================================================



static void Test_BFu7ll_Sf_L()
{
  {
    init_simple_test("BFu7ll_Sf_L");
    static STRUCT_IF_C BFu7ll_Sf_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu7ll_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_L");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_L.v2");
    check_field_offset(lv, v3, 1, "BFu7ll_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_L, BFu7ll_Sf_L)
//============================================================================



static void Test_BFu7ll_Sf_S()
{
  {
    init_simple_test("BFu7ll_Sf_S");
    static STRUCT_IF_C BFu7ll_Sf_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_S");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_S.v2");
    check_field_offset(lv, v3, 1, "BFu7ll_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_S, BFu7ll_Sf_S)
//============================================================================



static void Test_BFu7ll_Sf_Sf()
{
  {
    init_simple_test("BFu7ll_Sf_Sf");
    static STRUCT_IF_C BFu7ll_Sf_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7ll_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_Sf.v2");
    check_field_offset(lv, v3, 1, "BFu7ll_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_Sf, BFu7ll_Sf_Sf)
//============================================================================



static void Test_BFu7ll_Sf_Uc()
{
  {
    init_simple_test("BFu7ll_Sf_Uc");
    static STRUCT_IF_C BFu7ll_Sf_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_Uc");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_Uc.v2");
    check_field_offset(lv, v3, 1, "BFu7ll_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_Uc, BFu7ll_Sf_Uc)
//============================================================================



static void Test_BFu7ll_Sf_Ui()
{
  {
    init_simple_test("BFu7ll_Sf_Ui");
    static STRUCT_IF_C BFu7ll_Sf_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_Ui");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_Ui.v2");
    check_field_offset(lv, v3, 1, "BFu7ll_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_Ui, BFu7ll_Sf_Ui)
//============================================================================



static void Test_BFu7ll_Sf_Ul()
{
  {
    init_simple_test("BFu7ll_Sf_Ul");
    static STRUCT_IF_C BFu7ll_Sf_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu7ll_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_Ul");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_Ul.v2");
    check_field_offset(lv, v3, 1, "BFu7ll_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_Ul, BFu7ll_Sf_Ul)
//============================================================================



static void Test_BFu7ll_Sf_Us()
{
  {
    init_simple_test("BFu7ll_Sf_Us");
    static STRUCT_IF_C BFu7ll_Sf_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_Us");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_Us.v2");
    check_field_offset(lv, v3, 1, "BFu7ll_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_Us, BFu7ll_Sf_Us)
//============================================================================



static void Test_BFu7ll_Sf_Vp()
{
  {
    init_simple_test("BFu7ll_Sf_Vp");
    static STRUCT_IF_C BFu7ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7ll_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Sf_Vp");
    check_field_offset(lv, v2, 1, "BFu7ll_Sf_Vp.v2");
    check_field_offset(lv, v3, 1, "BFu7ll_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Sf_Vp, BFu7ll_Sf_Vp)
//============================================================================



static void Test_BFu7ll_Uc_Sf()
{
  {
    init_simple_test("BFu7ll_Uc_Sf");
    static STRUCT_IF_C BFu7ll_Uc_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7ll_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Uc_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu7ll_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Uc_Sf, BFu7ll_Uc_Sf)
//============================================================================



static void Test_BFu7ll_Ui_Sf()
{
  {
    init_simple_test("BFu7ll_Ui_Sf");
    static STRUCT_IF_C BFu7ll_Ui_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7ll_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Ui_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_Ui_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu7ll_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Ui_Sf, BFu7ll_Ui_Sf)
//============================================================================



static void Test_BFu7ll_Ul_Sf()
{
  {
    init_simple_test("BFu7ll_Ul_Sf");
    static STRUCT_IF_C BFu7ll_Ul_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu7ll_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Ul_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_Ul_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu7ll_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Ul_Sf, BFu7ll_Ul_Sf)
//============================================================================



static void Test_BFu7ll_Us_Sf()
{
  {
    init_simple_test("BFu7ll_Us_Sf");
    static STRUCT_IF_C BFu7ll_Us_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7ll_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Us_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_Us_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu7ll_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Us_Sf, BFu7ll_Us_Sf)
//============================================================================



static void Test_BFu7ll_Vp_Sf()
{
  {
    init_simple_test("BFu7ll_Vp_Sf");
    static STRUCT_IF_C BFu7ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7ll_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7ll_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Vp_Sf");
    check_field_offset(lv, v2, 1, "BFu7ll_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7ll_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_Vp_Sf, BFu7ll_Vp_Sf)
//============================================================================



static void Test_BFu7s_BFu15i_Sf()
{
  {
    init_simple_test("BFu7s_BFu15i_Sf");
    static STRUCT_IF_C BFu7s_BFu15i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7s_BFu15i_Sf");
    check_field_offset(lv, v3, 3, "BFu7s_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu15i_Sf, BFu7s_BFu15i_Sf)
//============================================================================



static void Test_BFu7s_BFu15ll_Sf()
{
  {
    init_simple_test("BFu7s_BFu15ll_Sf");
    static STRUCT_IF_C BFu7s_BFu15ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7s_BFu15ll_Sf");
    check_field_offset(lv, v3, 3, "BFu7s_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu15ll_Sf, BFu7s_BFu15ll_Sf)
//============================================================================



static void Test_BFu7s_BFu15s_Sf()
{
  {
    init_simple_test("BFu7s_BFu15s_Sf");
    static STRUCT_IF_C BFu7s_BFu15s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7s_BFu15s_Sf");
    check_field_offset(lv, v3, 3, "BFu7s_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu15s_Sf, BFu7s_BFu15s_Sf)
//============================================================================



static void Test_BFu7s_BFu16i_Sf()
{
  {
    init_simple_test("BFu7s_BFu16i_Sf");
    static STRUCT_IF_C BFu7s_BFu16i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7s_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "BFu7s_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu16i_Sf, BFu7s_BFu16i_Sf)
//============================================================================



static void Test_BFu7s_BFu16ll_Sf()
{
  {
    init_simple_test("BFu7s_BFu16ll_Sf");
    static STRUCT_IF_C BFu7s_BFu16ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7s_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "BFu7s_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu16ll_Sf, BFu7s_BFu16ll_Sf)
//============================================================================



static void Test_BFu7s_BFu16s_Sf()
{
  {
    init_simple_test("BFu7s_BFu16s_Sf");
    static STRUCT_IF_C BFu7s_BFu16s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7s_BFu16s_Sf");
    check_field_offset(lv, v3, 3, "BFu7s_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu16s_Sf, BFu7s_BFu16s_Sf)
//============================================================================



static void Test_BFu7s_BFu17i_Sf()
{
  {
    init_simple_test("BFu7s_BFu17i_Sf");
    static STRUCT_IF_C BFu7s_BFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7s_BFu17i_Sf");
    check_field_offset(lv, v3, 3, "BFu7s_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu17i_Sf, BFu7s_BFu17i_Sf)
//============================================================================



static void Test_BFu7s_BFu17ll_Sf()
{
  {
    init_simple_test("BFu7s_BFu17ll_Sf");
    static STRUCT_IF_C BFu7s_BFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7s_BFu17ll_Sf");
    check_field_offset(lv, v3, 3, "BFu7s_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu17ll_Sf, BFu7s_BFu17ll_Sf)
//============================================================================



static void Test_BFu7s_BFu1c_Sf()
{
  {
    init_simple_test("BFu7s_BFu1c_Sf");
    static STRUCT_IF_C BFu7s_BFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7s_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu1c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7s_BFu1c_Sf");
    check_field_offset(lv, v3, 1, "BFu7s_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu1c_Sf, BFu7s_BFu1c_Sf)
//============================================================================



static void Test_BFu7s_BFu1i_Sf()
{
  {
    init_simple_test("BFu7s_BFu1i_Sf");
    static STRUCT_IF_C BFu7s_BFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7s_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu1i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7s_BFu1i_Sf");
    check_field_offset(lv, v3, 1, "BFu7s_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu1i_Sf, BFu7s_BFu1i_Sf)
//============================================================================



static void Test_BFu7s_BFu1ll_Sf()
{
  {
    init_simple_test("BFu7s_BFu1ll_Sf");
    static STRUCT_IF_C BFu7s_BFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7s_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7s_BFu1ll_Sf");
    check_field_offset(lv, v3, 1, "BFu7s_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu1ll_Sf, BFu7s_BFu1ll_Sf)
//============================================================================



static void Test_BFu7s_BFu1s_Sf()
{
  {
    init_simple_test("BFu7s_BFu1s_Sf");
    static STRUCT_IF_C BFu7s_BFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7s_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu1s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7s_BFu1s_Sf");
    check_field_offset(lv, v3, 1, "BFu7s_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu1s_Sf, BFu7s_BFu1s_Sf)
//============================================================================



static void Test_BFu7s_BFu31i_Sf()
{
  {
    init_simple_test("BFu7s_BFu31i_Sf");
    static STRUCT_IF_C BFu7s_BFu31i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7s_BFu31i_Sf");
    check_field_offset(lv, v3, 5, "BFu7s_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu31i_Sf, BFu7s_BFu31i_Sf)
//============================================================================



static void Test_BFu7s_BFu31ll_Sf()
{
  {
    init_simple_test("BFu7s_BFu31ll_Sf");
    static STRUCT_IF_C BFu7s_BFu31ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7s_BFu31ll_Sf");
    check_field_offset(lv, v3, 5, "BFu7s_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu31ll_Sf, BFu7s_BFu31ll_Sf)
//============================================================================



static void Test_BFu7s_BFu32i_Sf()
{
  {
    init_simple_test("BFu7s_BFu32i_Sf");
    static STRUCT_IF_C BFu7s_BFu32i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7s_BFu32i_Sf");
    check_field_offset(lv, v3, 5, "BFu7s_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu32i_Sf, BFu7s_BFu32i_Sf)
//============================================================================



static void Test_BFu7s_BFu32ll_Sf()
{
  {
    init_simple_test("BFu7s_BFu32ll_Sf");
    static STRUCT_IF_C BFu7s_BFu32ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7s_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "BFu7s_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu32ll_Sf, BFu7s_BFu32ll_Sf)
//============================================================================



static void Test_BFu7s_BFu33_Sf()
{
  {
    init_simple_test("BFu7s_BFu33_Sf");
    static STRUCT_IF_C BFu7s_BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7s_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7s_BFu33_Sf");
    check_field_offset(lv, v3, 5, "BFu7s_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu33_Sf, BFu7s_BFu33_Sf)
//============================================================================



static void Test_BFu7s_BFu7c_Sf()
{
  {
    init_simple_test("BFu7s_BFu7c_Sf");
    static STRUCT_IF_C BFu7s_BFu7c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7s_BFu7c_Sf");
    check_field_offset(lv, v3, 2, "BFu7s_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu7c_Sf, BFu7s_BFu7c_Sf)
//============================================================================



static void Test_BFu7s_BFu7i_Sf()
{
  {
    init_simple_test("BFu7s_BFu7i_Sf");
    static STRUCT_IF_C BFu7s_BFu7i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7s_BFu7i_Sf");
    check_field_offset(lv, v3, 2, "BFu7s_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu7i_Sf, BFu7s_BFu7i_Sf)
//============================================================================



static void Test_BFu7s_BFu7ll_Sf()
{
  {
    init_simple_test("BFu7s_BFu7ll_Sf");
    static STRUCT_IF_C BFu7s_BFu7ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7s_BFu7ll_Sf");
    check_field_offset(lv, v3, 2, "BFu7s_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu7ll_Sf, BFu7s_BFu7ll_Sf)
//============================================================================



static void Test_BFu7s_BFu7s_Sf()
{
  {
    init_simple_test("BFu7s_BFu7s_Sf");
    static STRUCT_IF_C BFu7s_BFu7s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7s_BFu7s_Sf");
    check_field_offset(lv, v3, 2, "BFu7s_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu7s_Sf, BFu7s_BFu7s_Sf)
//============================================================================



static void Test_BFu7s_BFu8c_Sf()
{
  {
    init_simple_test("BFu7s_BFu8c_Sf");
    static STRUCT_IF_C BFu7s_BFu8c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7s_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "BFu7s_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu8c_Sf, BFu7s_BFu8c_Sf)
//============================================================================



static void Test_BFu7s_BFu8i_Sf()
{
  {
    init_simple_test("BFu7s_BFu8i_Sf");
    static STRUCT_IF_C BFu7s_BFu8i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7s_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "BFu7s_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu8i_Sf, BFu7s_BFu8i_Sf)
//============================================================================



static void Test_BFu7s_BFu8ll_Sf()
{
  {
    init_simple_test("BFu7s_BFu8ll_Sf");
    static STRUCT_IF_C BFu7s_BFu8ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7s_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "BFu7s_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu8ll_Sf, BFu7s_BFu8ll_Sf)
//============================================================================



static void Test_BFu7s_BFu8s_Sf()
{
  {
    init_simple_test("BFu7s_BFu8s_Sf");
    static STRUCT_IF_C BFu7s_BFu8s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7s_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "BFu7s_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu8s_Sf, BFu7s_BFu8s_Sf)
//============================================================================



static void Test_BFu7s_BFu9i_Sf()
{
  {
    init_simple_test("BFu7s_BFu9i_Sf");
    static STRUCT_IF_C BFu7s_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7s_BFu9i_Sf");
    check_field_offset(lv, v3, 2, "BFu7s_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu9i_Sf, BFu7s_BFu9i_Sf)
//============================================================================



static void Test_BFu7s_BFu9ll_Sf()
{
  {
    init_simple_test("BFu7s_BFu9ll_Sf");
    static STRUCT_IF_C BFu7s_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7s_BFu9ll_Sf");
    check_field_offset(lv, v3, 2, "BFu7s_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu9ll_Sf, BFu7s_BFu9ll_Sf)
//============================================================================



static void Test_BFu7s_BFu9s_Sf()
{
  {
    init_simple_test("BFu7s_BFu9s_Sf");
    static STRUCT_IF_C BFu7s_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7s_BFu9s_Sf");
    check_field_offset(lv, v3, 2, "BFu7s_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_BFu9s_Sf, BFu7s_BFu9s_Sf)
//============================================================================



static void Test_BFu7s_C_Sf()
{
  {
    init_simple_test("BFu7s_C_Sf");
    static STRUCT_IF_C BFu7s_C_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_C_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_C_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu7s_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_C_Sf, BFu7s_C_Sf)
//============================================================================



static void Test_BFu7s_D_Sf()
{
  {
    init_simple_test("BFu7s_D_Sf");
    static STRUCT_IF_C BFu7s_D_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu7s_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_D_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_D_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu7s_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_D_Sf, BFu7s_D_Sf)
//============================================================================



static void Test_BFu7s_F_Sf()
{
  {
    init_simple_test("BFu7s_F_Sf");
    static STRUCT_IF_C BFu7s_F_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_F_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_F_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu7s_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_F_Sf, BFu7s_F_Sf)
//============================================================================



static void Test_BFu7s_I_Sf()
{
  {
    init_simple_test("BFu7s_I_Sf");
    static STRUCT_IF_C BFu7s_I_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_I_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_I_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu7s_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_I_Sf, BFu7s_I_Sf)
//============================================================================



static void Test_BFu7s_Ip_Sf()
{
  {
    init_simple_test("BFu7s_Ip_Sf");
    static STRUCT_IF_C BFu7s_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7s_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Ip_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7s_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Ip_Sf, BFu7s_Ip_Sf)
//============================================================================



static void Test_BFu7s_L_Sf()
{
  {
    init_simple_test("BFu7s_L_Sf");
    static STRUCT_IF_C BFu7s_L_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu7s_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_L_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_L_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu7s_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_L_Sf, BFu7s_L_Sf)
//============================================================================



static void Test_BFu7s_S_Sf()
{
  {
    init_simple_test("BFu7s_S_Sf");
    static STRUCT_IF_C BFu7s_S_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_S_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_S_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu7s_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_S_Sf, BFu7s_S_Sf)
//============================================================================



static void Test_BFu7s_Sf()
{
  {
    init_simple_test("BFu7s_Sf");
    static STRUCT_IF_C BFu7s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf, BFu7s_Sf)
//============================================================================



static void Test_BFu7s_Sf_BFu15i()
{
  {
    init_simple_test("BFu7s_Sf_BFu15i");
    static STRUCT_IF_C BFu7s_Sf_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu7s_Sf_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu7s_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu15i, BFu7s_Sf_BFu15i)
//============================================================================



static void Test_BFu7s_Sf_BFu15ll()
{
  {
    init_simple_test("BFu7s_Sf_BFu15ll");
    static STRUCT_IF_C BFu7s_Sf_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu7s_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu7s_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu15ll, BFu7s_Sf_BFu15ll)
//============================================================================



static void Test_BFu7s_Sf_BFu15s()
{
  {
    init_simple_test("BFu7s_Sf_BFu15s");
    static STRUCT_IF_C BFu7s_Sf_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu7s_Sf_BFu15s");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu7s_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu15s, BFu7s_Sf_BFu15s)
//============================================================================



static void Test_BFu7s_Sf_BFu16i()
{
  {
    init_simple_test("BFu7s_Sf_BFu16i");
    static STRUCT_IF_C BFu7s_Sf_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu7s_Sf_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu7s_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu16i, BFu7s_Sf_BFu16i)
//============================================================================



static void Test_BFu7s_Sf_BFu16ll()
{
  {
    init_simple_test("BFu7s_Sf_BFu16ll");
    static STRUCT_IF_C BFu7s_Sf_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu7s_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu7s_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu16ll, BFu7s_Sf_BFu16ll)
//============================================================================



static void Test_BFu7s_Sf_BFu16s()
{
  {
    init_simple_test("BFu7s_Sf_BFu16s");
    static STRUCT_IF_C BFu7s_Sf_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu7s_Sf_BFu16s");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu7s_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu16s, BFu7s_Sf_BFu16s)
//============================================================================



static void Test_BFu7s_Sf_BFu17i()
{
  {
    init_simple_test("BFu7s_Sf_BFu17i");
    static STRUCT_IF_C BFu7s_Sf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu7s_Sf_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu7s_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu17i, BFu7s_Sf_BFu17i)
//============================================================================



static void Test_BFu7s_Sf_BFu17ll()
{
  {
    init_simple_test("BFu7s_Sf_BFu17ll");
    static STRUCT_IF_C BFu7s_Sf_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu7s_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu7s_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu17ll, BFu7s_Sf_BFu17ll)
//============================================================================



static void Test_BFu7s_Sf_BFu1c()
{
  {
    init_simple_test("BFu7s_Sf_BFu1c");
    static STRUCT_IF_C BFu7s_Sf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7s_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu1c, BFu7s_Sf_BFu1c)
//============================================================================



static void Test_BFu7s_Sf_BFu1i()
{
  {
    init_simple_test("BFu7s_Sf_BFu1i");
    static STRUCT_IF_C BFu7s_Sf_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7s_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu1i, BFu7s_Sf_BFu1i)
//============================================================================



static void Test_BFu7s_Sf_BFu1ll()
{
  {
    init_simple_test("BFu7s_Sf_BFu1ll");
    static STRUCT_IF_C BFu7s_Sf_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7s_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu1ll, BFu7s_Sf_BFu1ll)
//============================================================================



static void Test_BFu7s_Sf_BFu1s()
{
  {
    init_simple_test("BFu7s_Sf_BFu1s");
    static STRUCT_IF_C BFu7s_Sf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu7s_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu1s, BFu7s_Sf_BFu1s)
//============================================================================



static void Test_BFu7s_Sf_BFu31i()
{
  {
    init_simple_test("BFu7s_Sf_BFu31i");
    static STRUCT_IF_C BFu7s_Sf_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu7s_Sf_BFu31i");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu7s_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu31i, BFu7s_Sf_BFu31i)
//============================================================================



static void Test_BFu7s_Sf_BFu31ll()
{
  {
    init_simple_test("BFu7s_Sf_BFu31ll");
    static STRUCT_IF_C BFu7s_Sf_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu7s_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu7s_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu31ll, BFu7s_Sf_BFu31ll)
//============================================================================



static void Test_BFu7s_Sf_BFu32i()
{
  {
    init_simple_test("BFu7s_Sf_BFu32i");
    static STRUCT_IF_C BFu7s_Sf_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu7s_Sf_BFu32i");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu7s_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu32i, BFu7s_Sf_BFu32i)
//============================================================================



static void Test_BFu7s_Sf_BFu32ll()
{
  {
    init_simple_test("BFu7s_Sf_BFu32ll");
    static STRUCT_IF_C BFu7s_Sf_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu7s_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu7s_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu32ll, BFu7s_Sf_BFu32ll)
//============================================================================



static void Test_BFu7s_Sf_BFu33()
{
  {
    init_simple_test("BFu7s_Sf_BFu33");
    static STRUCT_IF_C BFu7s_Sf_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu7s_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu33");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 1, 0, 33, 1, "BFu7s_Sf_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, hide_ull(1LL<<32), "BFu7s_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu33, BFu7s_Sf_BFu33)
//============================================================================



static void Test_BFu7s_Sf_BFu7c()
{
  {
    init_simple_test("BFu7s_Sf_BFu7c");
    static STRUCT_IF_C BFu7s_Sf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7s_Sf_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu7c, BFu7s_Sf_BFu7c)
//============================================================================



static void Test_BFu7s_Sf_BFu7i()
{
  {
    init_simple_test("BFu7s_Sf_BFu7i");
    static STRUCT_IF_C BFu7s_Sf_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7s_Sf_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu7i, BFu7s_Sf_BFu7i)
//============================================================================



static void Test_BFu7s_Sf_BFu7ll()
{
  {
    init_simple_test("BFu7s_Sf_BFu7ll");
    static STRUCT_IF_C BFu7s_Sf_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7s_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu7ll, BFu7s_Sf_BFu7ll)
//============================================================================



static void Test_BFu7s_Sf_BFu7s()
{
  {
    init_simple_test("BFu7s_Sf_BFu7s");
    static STRUCT_IF_C BFu7s_Sf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu7s_Sf_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu7s, BFu7s_Sf_BFu7s)
//============================================================================



static void Test_BFu7s_Sf_BFu8c()
{
  {
    init_simple_test("BFu7s_Sf_BFu8c");
    static STRUCT_IF_C BFu7s_Sf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7s_Sf_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7s_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu8c, BFu7s_Sf_BFu8c)
//============================================================================



static void Test_BFu7s_Sf_BFu8i()
{
  {
    init_simple_test("BFu7s_Sf_BFu8i");
    static STRUCT_IF_C BFu7s_Sf_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7s_Sf_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7s_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu8i, BFu7s_Sf_BFu8i)
//============================================================================



static void Test_BFu7s_Sf_BFu8ll()
{
  {
    init_simple_test("BFu7s_Sf_BFu8ll");
    static STRUCT_IF_C BFu7s_Sf_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7s_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7s_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu8ll, BFu7s_Sf_BFu8ll)
//============================================================================



static void Test_BFu7s_Sf_BFu8s()
{
  {
    init_simple_test("BFu7s_Sf_BFu8s");
    static STRUCT_IF_C BFu7s_Sf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu7s_Sf_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu7s_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu8s, BFu7s_Sf_BFu8s)
//============================================================================



static void Test_BFu7s_Sf_BFu9i()
{
  {
    init_simple_test("BFu7s_Sf_BFu9i");
    static STRUCT_IF_C BFu7s_Sf_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu7s_Sf_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu7s_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu9i, BFu7s_Sf_BFu9i)
//============================================================================



static void Test_BFu7s_Sf_BFu9ll()
{
  {
    init_simple_test("BFu7s_Sf_BFu9ll");
    static STRUCT_IF_C BFu7s_Sf_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu7s_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu7s_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu9ll, BFu7s_Sf_BFu9ll)
//============================================================================



static void Test_BFu7s_Sf_BFu9s()
{
  {
    init_simple_test("BFu7s_Sf_BFu9s");
    static STRUCT_IF_C BFu7s_Sf_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu7s_Sf_BFu9s");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu7s_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_BFu9s, BFu7s_Sf_BFu9s)
//============================================================================



static void Test_BFu7s_Sf_C()
{
  {
    init_simple_test("BFu7s_Sf_C");
    static STRUCT_IF_C BFu7s_Sf_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_C");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_C.v2");
    check_field_offset(lv, v3, 1, "BFu7s_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_C, BFu7s_Sf_C)
//============================================================================



static void Test_BFu7s_Sf_D()
{
  {
    init_simple_test("BFu7s_Sf_D");
    static STRUCT_IF_C BFu7s_Sf_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu7s_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_D");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_D.v2");
    check_field_offset(lv, v3, 1, "BFu7s_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_D, BFu7s_Sf_D)
//============================================================================



static void Test_BFu7s_Sf_F()
{
  {
    init_simple_test("BFu7s_Sf_F");
    static STRUCT_IF_C BFu7s_Sf_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_F");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_F.v2");
    check_field_offset(lv, v3, 1, "BFu7s_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_F, BFu7s_Sf_F)
//============================================================================



static void Test_BFu7s_Sf_I()
{
  {
    init_simple_test("BFu7s_Sf_I");
    static STRUCT_IF_C BFu7s_Sf_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_I");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_I.v2");
    check_field_offset(lv, v3, 1, "BFu7s_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_I, BFu7s_Sf_I)
//============================================================================



static void Test_BFu7s_Sf_Ip()
{
  {
    init_simple_test("BFu7s_Sf_Ip");
    static STRUCT_IF_C BFu7s_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7s_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_Ip");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_Ip.v2");
    check_field_offset(lv, v3, 1, "BFu7s_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_Ip, BFu7s_Sf_Ip)
//============================================================================



static void Test_BFu7s_Sf_L()
{
  {
    init_simple_test("BFu7s_Sf_L");
    static STRUCT_IF_C BFu7s_Sf_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu7s_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_L");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_L.v2");
    check_field_offset(lv, v3, 1, "BFu7s_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_L, BFu7s_Sf_L)
//============================================================================



static void Test_BFu7s_Sf_S()
{
  {
    init_simple_test("BFu7s_Sf_S");
    static STRUCT_IF_C BFu7s_Sf_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_S");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_S.v2");
    check_field_offset(lv, v3, 1, "BFu7s_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_S, BFu7s_Sf_S)
//============================================================================



static void Test_BFu7s_Sf_Sf()
{
  {
    init_simple_test("BFu7s_Sf_Sf");
    static STRUCT_IF_C BFu7s_Sf_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu7s_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_Sf.v2");
    check_field_offset(lv, v3, 1, "BFu7s_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_Sf, BFu7s_Sf_Sf)
//============================================================================



static void Test_BFu7s_Sf_Uc()
{
  {
    init_simple_test("BFu7s_Sf_Uc");
    static STRUCT_IF_C BFu7s_Sf_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_Uc");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_Uc.v2");
    check_field_offset(lv, v3, 1, "BFu7s_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_Uc, BFu7s_Sf_Uc)
//============================================================================



static void Test_BFu7s_Sf_Ui()
{
  {
    init_simple_test("BFu7s_Sf_Ui");
    static STRUCT_IF_C BFu7s_Sf_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_Ui");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_Ui.v2");
    check_field_offset(lv, v3, 1, "BFu7s_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_Ui, BFu7s_Sf_Ui)
//============================================================================



static void Test_BFu7s_Sf_Ul()
{
  {
    init_simple_test("BFu7s_Sf_Ul");
    static STRUCT_IF_C BFu7s_Sf_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu7s_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_Ul");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_Ul.v2");
    check_field_offset(lv, v3, 1, "BFu7s_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_Ul, BFu7s_Sf_Ul)
//============================================================================



static void Test_BFu7s_Sf_Us()
{
  {
    init_simple_test("BFu7s_Sf_Us");
    static STRUCT_IF_C BFu7s_Sf_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_Us");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_Us.v2");
    check_field_offset(lv, v3, 1, "BFu7s_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_Us, BFu7s_Sf_Us)
//============================================================================



static void Test_BFu7s_Sf_Vp()
{
  {
    init_simple_test("BFu7s_Sf_Vp");
    static STRUCT_IF_C BFu7s_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7s_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Sf_Vp");
    check_field_offset(lv, v2, 1, "BFu7s_Sf_Vp.v2");
    check_field_offset(lv, v3, 1, "BFu7s_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Sf_Vp, BFu7s_Sf_Vp)
//============================================================================



static void Test_BFu7s_Uc_Sf()
{
  {
    init_simple_test("BFu7s_Uc_Sf");
    static STRUCT_IF_C BFu7s_Uc_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Uc_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu7s_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Uc_Sf, BFu7s_Uc_Sf)
//============================================================================



static void Test_BFu7s_Ui_Sf()
{
  {
    init_simple_test("BFu7s_Ui_Sf");
    static STRUCT_IF_C BFu7s_Ui_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu7s_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Ui_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_Ui_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu7s_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Ui_Sf, BFu7s_Ui_Sf)
//============================================================================



static void Test_BFu7s_Ul_Sf()
{
  {
    init_simple_test("BFu7s_Ul_Sf");
    static STRUCT_IF_C BFu7s_Ul_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu7s_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Ul_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_Ul_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu7s_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Ul_Sf, BFu7s_Ul_Sf)
//============================================================================



static void Test_BFu7s_Us_Sf()
{
  {
    init_simple_test("BFu7s_Us_Sf");
    static STRUCT_IF_C BFu7s_Us_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu7s_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Us_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_Us_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu7s_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Us_Sf, BFu7s_Us_Sf)
//============================================================================



static void Test_BFu7s_Vp_Sf()
{
  {
    init_simple_test("BFu7s_Vp_Sf");
    static STRUCT_IF_C BFu7s_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7s_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7s_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Vp_Sf");
    check_field_offset(lv, v2, 1, "BFu7s_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu7s_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7s_Vp_Sf, BFu7s_Vp_Sf)
//============================================================================



static void Test_BFu8c_BFu15i_Sf()
{
  {
    init_simple_test("BFu8c_BFu15i_Sf");
    static STRUCT_IF_C BFu8c_BFu15i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8c_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8c_BFu15i_Sf");
    check_field_offset(lv, v3, 3, "BFu8c_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu15i_Sf, BFu8c_BFu15i_Sf)
//============================================================================



static void Test_BFu8c_BFu15ll_Sf()
{
  {
    init_simple_test("BFu8c_BFu15ll_Sf");
    static STRUCT_IF_C BFu8c_BFu15ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8c_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8c_BFu15ll_Sf");
    check_field_offset(lv, v3, 3, "BFu8c_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu15ll_Sf, BFu8c_BFu15ll_Sf)
//============================================================================



static void Test_BFu8c_BFu15s_Sf()
{
  {
    init_simple_test("BFu8c_BFu15s_Sf");
    static STRUCT_IF_C BFu8c_BFu15s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8c_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8c_BFu15s_Sf");
    check_field_offset(lv, v3, 3, "BFu8c_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu15s_Sf, BFu8c_BFu15s_Sf)
//============================================================================



static void Test_BFu8c_BFu16i_Sf()
{
  {
    init_simple_test("BFu8c_BFu16i_Sf");
    static STRUCT_IF_C BFu8c_BFu16i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8c_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8c_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "BFu8c_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu16i_Sf, BFu8c_BFu16i_Sf)
//============================================================================



static void Test_BFu8c_BFu16ll_Sf()
{
  {
    init_simple_test("BFu8c_BFu16ll_Sf");
    static STRUCT_IF_C BFu8c_BFu16ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8c_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8c_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "BFu8c_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu16ll_Sf, BFu8c_BFu16ll_Sf)
//============================================================================



static void Test_BFu8c_BFu16s_Sf()
{
  {
    init_simple_test("BFu8c_BFu16s_Sf");
    static STRUCT_IF_C BFu8c_BFu16s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8c_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8c_BFu16s_Sf");
    check_field_offset(lv, v3, 3, "BFu8c_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu16s_Sf, BFu8c_BFu16s_Sf)
//============================================================================



static void Test_BFu8c_BFu17i_Sf()
{
  {
    init_simple_test("BFu8c_BFu17i_Sf");
    static STRUCT_IF_C BFu8c_BFu17i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8c_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8c_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "BFu8c_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu17i_Sf, BFu8c_BFu17i_Sf)
//============================================================================



static void Test_BFu8c_BFu17ll_Sf()
{
  {
    init_simple_test("BFu8c_BFu17ll_Sf");
    static STRUCT_IF_C BFu8c_BFu17ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8c_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8c_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "BFu8c_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu17ll_Sf, BFu8c_BFu17ll_Sf)
//============================================================================



static void Test_BFu8c_BFu1c_Sf()
{
  {
    init_simple_test("BFu8c_BFu1c_Sf");
    static STRUCT_IF_C BFu8c_BFu1c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu1c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8c_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "BFu8c_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu1c_Sf, BFu8c_BFu1c_Sf)
//============================================================================



static void Test_BFu8c_BFu1i_Sf()
{
  {
    init_simple_test("BFu8c_BFu1i_Sf");
    static STRUCT_IF_C BFu8c_BFu1i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu1i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8c_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "BFu8c_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu1i_Sf, BFu8c_BFu1i_Sf)
//============================================================================



static void Test_BFu8c_BFu1ll_Sf()
{
  {
    init_simple_test("BFu8c_BFu1ll_Sf");
    static STRUCT_IF_C BFu8c_BFu1ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8c_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "BFu8c_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu1ll_Sf, BFu8c_BFu1ll_Sf)
//============================================================================



static void Test_BFu8c_BFu1s_Sf()
{
  {
    init_simple_test("BFu8c_BFu1s_Sf");
    static STRUCT_IF_C BFu8c_BFu1s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu1s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8c_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "BFu8c_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu1s_Sf, BFu8c_BFu1s_Sf)
//============================================================================



static void Test_BFu8c_BFu31i_Sf()
{
  {
    init_simple_test("BFu8c_BFu31i_Sf");
    static STRUCT_IF_C BFu8c_BFu31i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu8c_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu8c_BFu31i_Sf");
    check_field_offset(lv, v3, 5, "BFu8c_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu31i_Sf, BFu8c_BFu31i_Sf)
//============================================================================



static void Test_BFu8c_BFu31ll_Sf()
{
  {
    init_simple_test("BFu8c_BFu31ll_Sf");
    static STRUCT_IF_C BFu8c_BFu31ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu8c_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu8c_BFu31ll_Sf");
    check_field_offset(lv, v3, 5, "BFu8c_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu31ll_Sf, BFu8c_BFu31ll_Sf)
//============================================================================



static void Test_BFu8c_BFu32i_Sf()
{
  {
    init_simple_test("BFu8c_BFu32i_Sf");
    static STRUCT_IF_C BFu8c_BFu32i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu8c_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu8c_BFu32i_Sf");
    check_field_offset(lv, v3, 5, "BFu8c_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu32i_Sf, BFu8c_BFu32i_Sf)
//============================================================================



static void Test_BFu8c_BFu32ll_Sf()
{
  {
    init_simple_test("BFu8c_BFu32ll_Sf");
    static STRUCT_IF_C BFu8c_BFu32ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu8c_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu8c_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "BFu8c_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu32ll_Sf, BFu8c_BFu32ll_Sf)
//============================================================================



static void Test_BFu8c_BFu33_Sf()
{
  {
    init_simple_test("BFu8c_BFu33_Sf");
    static STRUCT_IF_C BFu8c_BFu33_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu8c_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8c_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8c_BFu33_Sf");
    check_field_offset(lv, v3, 6, "BFu8c_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu33_Sf, BFu8c_BFu33_Sf)
//============================================================================



static void Test_BFu8c_BFu7c_Sf()
{
  {
    init_simple_test("BFu8c_BFu7c_Sf");
    static STRUCT_IF_C BFu8c_BFu7c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8c_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8c_BFu7c_Sf");
    check_field_offset(lv, v3, 2, "BFu8c_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu7c_Sf, BFu8c_BFu7c_Sf)
//============================================================================



static void Test_BFu8c_BFu7i_Sf()
{
  {
    init_simple_test("BFu8c_BFu7i_Sf");
    static STRUCT_IF_C BFu8c_BFu7i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8c_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8c_BFu7i_Sf");
    check_field_offset(lv, v3, 2, "BFu8c_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu7i_Sf, BFu8c_BFu7i_Sf)
//============================================================================



static void Test_BFu8c_BFu7ll_Sf()
{
  {
    init_simple_test("BFu8c_BFu7ll_Sf");
    static STRUCT_IF_C BFu8c_BFu7ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8c_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8c_BFu7ll_Sf");
    check_field_offset(lv, v3, 2, "BFu8c_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu7ll_Sf, BFu8c_BFu7ll_Sf)
//============================================================================



static void Test_BFu8c_BFu7s_Sf()
{
  {
    init_simple_test("BFu8c_BFu7s_Sf");
    static STRUCT_IF_C BFu8c_BFu7s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8c_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8c_BFu7s_Sf");
    check_field_offset(lv, v3, 2, "BFu8c_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu7s_Sf, BFu8c_BFu7s_Sf)
//============================================================================



static void Test_BFu8c_BFu8c_Sf()
{
  {
    init_simple_test("BFu8c_BFu8c_Sf");
    static STRUCT_IF_C BFu8c_BFu8c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8c_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "BFu8c_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu8c_Sf, BFu8c_BFu8c_Sf)
//============================================================================



static void Test_BFu8c_BFu8i_Sf()
{
  {
    init_simple_test("BFu8c_BFu8i_Sf");
    static STRUCT_IF_C BFu8c_BFu8i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8c_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "BFu8c_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu8i_Sf, BFu8c_BFu8i_Sf)
//============================================================================



static void Test_BFu8c_BFu8ll_Sf()
{
  {
    init_simple_test("BFu8c_BFu8ll_Sf");
    static STRUCT_IF_C BFu8c_BFu8ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8c_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "BFu8c_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu8ll_Sf, BFu8c_BFu8ll_Sf)
//============================================================================



static void Test_BFu8c_BFu8s_Sf()
{
  {
    init_simple_test("BFu8c_BFu8s_Sf");
    static STRUCT_IF_C BFu8c_BFu8s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8c_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "BFu8c_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu8s_Sf, BFu8c_BFu8s_Sf)
//============================================================================



static void Test_BFu8c_BFu9i_Sf()
{
  {
    init_simple_test("BFu8c_BFu9i_Sf");
    static STRUCT_IF_C BFu8c_BFu9i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8c_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8c_BFu9i_Sf");
    check_field_offset(lv, v3, 3, "BFu8c_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu9i_Sf, BFu8c_BFu9i_Sf)
//============================================================================



static void Test_BFu8c_BFu9ll_Sf()
{
  {
    init_simple_test("BFu8c_BFu9ll_Sf");
    static STRUCT_IF_C BFu8c_BFu9ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8c_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8c_BFu9ll_Sf");
    check_field_offset(lv, v3, 3, "BFu8c_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu9ll_Sf, BFu8c_BFu9ll_Sf)
//============================================================================



static void Test_BFu8c_BFu9s_Sf()
{
  {
    init_simple_test("BFu8c_BFu9s_Sf");
    static STRUCT_IF_C BFu8c_BFu9s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8c_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8c_BFu9s_Sf");
    check_field_offset(lv, v3, 3, "BFu8c_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_BFu9s_Sf, BFu8c_BFu9s_Sf)
//============================================================================



static void Test_BFu8c_C_Sf()
{
  {
    init_simple_test("BFu8c_C_Sf");
    static STRUCT_IF_C BFu8c_C_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_C_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_C_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu8c_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_C_Sf, BFu8c_C_Sf)
//============================================================================



static void Test_BFu8c_D_Sf()
{
  {
    init_simple_test("BFu8c_D_Sf");
    static STRUCT_IF_C BFu8c_D_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu8c_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_D_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_D_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu8c_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_D_Sf, BFu8c_D_Sf)
//============================================================================



static void Test_BFu8c_F_Sf()
{
  {
    init_simple_test("BFu8c_F_Sf");
    static STRUCT_IF_C BFu8c_F_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_F_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_F_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu8c_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_F_Sf, BFu8c_F_Sf)
//============================================================================



static void Test_BFu8c_I_Sf()
{
  {
    init_simple_test("BFu8c_I_Sf");
    static STRUCT_IF_C BFu8c_I_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_I_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_I_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu8c_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_I_Sf, BFu8c_I_Sf)
//============================================================================



static void Test_BFu8c_Ip_Sf()
{
  {
    init_simple_test("BFu8c_Ip_Sf");
    static STRUCT_IF_C BFu8c_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8c_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Ip_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu8c_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Ip_Sf, BFu8c_Ip_Sf)
//============================================================================



static void Test_BFu8c_L_Sf()
{
  {
    init_simple_test("BFu8c_L_Sf");
    static STRUCT_IF_C BFu8c_L_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu8c_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_L_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_L_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu8c_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_L_Sf, BFu8c_L_Sf)
//============================================================================



static void Test_BFu8c_S_Sf()
{
  {
    init_simple_test("BFu8c_S_Sf");
    static STRUCT_IF_C BFu8c_S_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_S_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_S_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu8c_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_S_Sf, BFu8c_S_Sf)
//============================================================================



static void Test_BFu8c_Sf()
{
  {
    init_simple_test("BFu8c_Sf");
    static STRUCT_IF_C BFu8c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf, BFu8c_Sf)
//============================================================================



static void Test_BFu8c_Sf_BFu15i()
{
  {
    init_simple_test("BFu8c_Sf_BFu15i");
    static STRUCT_IF_C BFu8c_Sf_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu8c_Sf_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu8c_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu15i, BFu8c_Sf_BFu15i)
//============================================================================



static void Test_BFu8c_Sf_BFu15ll()
{
  {
    init_simple_test("BFu8c_Sf_BFu15ll");
    static STRUCT_IF_C BFu8c_Sf_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu8c_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu8c_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu15ll, BFu8c_Sf_BFu15ll)
//============================================================================



static void Test_BFu8c_Sf_BFu15s()
{
  {
    init_simple_test("BFu8c_Sf_BFu15s");
    static STRUCT_IF_C BFu8c_Sf_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu8c_Sf_BFu15s");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu8c_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu15s, BFu8c_Sf_BFu15s)
//============================================================================



static void Test_BFu8c_Sf_BFu16i()
{
  {
    init_simple_test("BFu8c_Sf_BFu16i");
    static STRUCT_IF_C BFu8c_Sf_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu8c_Sf_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu8c_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu16i, BFu8c_Sf_BFu16i)
//============================================================================



static void Test_BFu8c_Sf_BFu16ll()
{
  {
    init_simple_test("BFu8c_Sf_BFu16ll");
    static STRUCT_IF_C BFu8c_Sf_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu8c_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu8c_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu16ll, BFu8c_Sf_BFu16ll)
//============================================================================



static void Test_BFu8c_Sf_BFu16s()
{
  {
    init_simple_test("BFu8c_Sf_BFu16s");
    static STRUCT_IF_C BFu8c_Sf_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu8c_Sf_BFu16s");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu8c_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu16s, BFu8c_Sf_BFu16s)
//============================================================================



static void Test_BFu8c_Sf_BFu17i()
{
  {
    init_simple_test("BFu8c_Sf_BFu17i");
    static STRUCT_IF_C BFu8c_Sf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu8c_Sf_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu8c_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu17i, BFu8c_Sf_BFu17i)
//============================================================================



static void Test_BFu8c_Sf_BFu17ll()
{
  {
    init_simple_test("BFu8c_Sf_BFu17ll");
    static STRUCT_IF_C BFu8c_Sf_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu8c_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu8c_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu17ll, BFu8c_Sf_BFu17ll)
//============================================================================



static void Test_BFu8c_Sf_BFu1c()
{
  {
    init_simple_test("BFu8c_Sf_BFu1c");
    static STRUCT_IF_C BFu8c_Sf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8c_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu1c, BFu8c_Sf_BFu1c)
//============================================================================



static void Test_BFu8c_Sf_BFu1i()
{
  {
    init_simple_test("BFu8c_Sf_BFu1i");
    static STRUCT_IF_C BFu8c_Sf_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8c_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu1i, BFu8c_Sf_BFu1i)
//============================================================================



static void Test_BFu8c_Sf_BFu1ll()
{
  {
    init_simple_test("BFu8c_Sf_BFu1ll");
    static STRUCT_IF_C BFu8c_Sf_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8c_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu1ll, BFu8c_Sf_BFu1ll)
//============================================================================



static void Test_BFu8c_Sf_BFu1s()
{
  {
    init_simple_test("BFu8c_Sf_BFu1s");
    static STRUCT_IF_C BFu8c_Sf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8c_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu1s, BFu8c_Sf_BFu1s)
//============================================================================



static void Test_BFu8c_Sf_BFu31i()
{
  {
    init_simple_test("BFu8c_Sf_BFu31i");
    static STRUCT_IF_C BFu8c_Sf_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu8c_Sf_BFu31i");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu8c_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu31i, BFu8c_Sf_BFu31i)
//============================================================================



static void Test_BFu8c_Sf_BFu31ll()
{
  {
    init_simple_test("BFu8c_Sf_BFu31ll");
    static STRUCT_IF_C BFu8c_Sf_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu8c_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu8c_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu31ll, BFu8c_Sf_BFu31ll)
//============================================================================



static void Test_BFu8c_Sf_BFu32i()
{
  {
    init_simple_test("BFu8c_Sf_BFu32i");
    static STRUCT_IF_C BFu8c_Sf_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu8c_Sf_BFu32i");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu8c_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu32i, BFu8c_Sf_BFu32i)
//============================================================================



static void Test_BFu8c_Sf_BFu32ll()
{
  {
    init_simple_test("BFu8c_Sf_BFu32ll");
    static STRUCT_IF_C BFu8c_Sf_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu8c_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu8c_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu32ll, BFu8c_Sf_BFu32ll)
//============================================================================



static void Test_BFu8c_Sf_BFu33()
{
  {
    init_simple_test("BFu8c_Sf_BFu33");
    static STRUCT_IF_C BFu8c_Sf_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu8c_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu33");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 1, 0, 33, 1, "BFu8c_Sf_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, hide_ull(1LL<<32), "BFu8c_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu33, BFu8c_Sf_BFu33)
//============================================================================



static void Test_BFu8c_Sf_BFu7c()
{
  {
    init_simple_test("BFu8c_Sf_BFu7c");
    static STRUCT_IF_C BFu8c_Sf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8c_Sf_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8c_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu7c, BFu8c_Sf_BFu7c)
//============================================================================



static void Test_BFu8c_Sf_BFu7i()
{
  {
    init_simple_test("BFu8c_Sf_BFu7i");
    static STRUCT_IF_C BFu8c_Sf_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8c_Sf_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8c_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu7i, BFu8c_Sf_BFu7i)
//============================================================================



static void Test_BFu8c_Sf_BFu7ll()
{
  {
    init_simple_test("BFu8c_Sf_BFu7ll");
    static STRUCT_IF_C BFu8c_Sf_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8c_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8c_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu7ll, BFu8c_Sf_BFu7ll)
//============================================================================



static void Test_BFu8c_Sf_BFu7s()
{
  {
    init_simple_test("BFu8c_Sf_BFu7s");
    static STRUCT_IF_C BFu8c_Sf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8c_Sf_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8c_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu7s, BFu8c_Sf_BFu7s)
//============================================================================



static void Test_BFu8c_Sf_BFu8c()
{
  {
    init_simple_test("BFu8c_Sf_BFu8c");
    static STRUCT_IF_C BFu8c_Sf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8c_Sf_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu8c, BFu8c_Sf_BFu8c)
//============================================================================



static void Test_BFu8c_Sf_BFu8i()
{
  {
    init_simple_test("BFu8c_Sf_BFu8i");
    static STRUCT_IF_C BFu8c_Sf_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8c_Sf_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu8i, BFu8c_Sf_BFu8i)
//============================================================================



static void Test_BFu8c_Sf_BFu8ll()
{
  {
    init_simple_test("BFu8c_Sf_BFu8ll");
    static STRUCT_IF_C BFu8c_Sf_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8c_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu8ll, BFu8c_Sf_BFu8ll)
//============================================================================



static void Test_BFu8c_Sf_BFu8s()
{
  {
    init_simple_test("BFu8c_Sf_BFu8s");
    static STRUCT_IF_C BFu8c_Sf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8c_Sf_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu8s, BFu8c_Sf_BFu8s)
//============================================================================



static void Test_BFu8c_Sf_BFu9i()
{
  {
    init_simple_test("BFu8c_Sf_BFu9i");
    static STRUCT_IF_C BFu8c_Sf_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu8c_Sf_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu8c_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu9i, BFu8c_Sf_BFu9i)
//============================================================================



static void Test_BFu8c_Sf_BFu9ll()
{
  {
    init_simple_test("BFu8c_Sf_BFu9ll");
    static STRUCT_IF_C BFu8c_Sf_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu8c_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu8c_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu9ll, BFu8c_Sf_BFu9ll)
//============================================================================



static void Test_BFu8c_Sf_BFu9s()
{
  {
    init_simple_test("BFu8c_Sf_BFu9s");
    static STRUCT_IF_C BFu8c_Sf_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu8c_Sf_BFu9s");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu8c_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_BFu9s, BFu8c_Sf_BFu9s)
//============================================================================



static void Test_BFu8c_Sf_C()
{
  {
    init_simple_test("BFu8c_Sf_C");
    static STRUCT_IF_C BFu8c_Sf_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_C");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_C.v2");
    check_field_offset(lv, v3, 1, "BFu8c_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_C, BFu8c_Sf_C)
//============================================================================



static void Test_BFu8c_Sf_D()
{
  {
    init_simple_test("BFu8c_Sf_D");
    static STRUCT_IF_C BFu8c_Sf_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu8c_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_D");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_D.v2");
    check_field_offset(lv, v3, 1, "BFu8c_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_D, BFu8c_Sf_D)
//============================================================================



static void Test_BFu8c_Sf_F()
{
  {
    init_simple_test("BFu8c_Sf_F");
    static STRUCT_IF_C BFu8c_Sf_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_F");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_F.v2");
    check_field_offset(lv, v3, 1, "BFu8c_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_F, BFu8c_Sf_F)
//============================================================================



static void Test_BFu8c_Sf_I()
{
  {
    init_simple_test("BFu8c_Sf_I");
    static STRUCT_IF_C BFu8c_Sf_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_I");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_I.v2");
    check_field_offset(lv, v3, 1, "BFu8c_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_I, BFu8c_Sf_I)
//============================================================================



static void Test_BFu8c_Sf_Ip()
{
  {
    init_simple_test("BFu8c_Sf_Ip");
    static STRUCT_IF_C BFu8c_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8c_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_Ip");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_Ip.v2");
    check_field_offset(lv, v3, 1, "BFu8c_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_Ip, BFu8c_Sf_Ip)
//============================================================================



static void Test_BFu8c_Sf_L()
{
  {
    init_simple_test("BFu8c_Sf_L");
    static STRUCT_IF_C BFu8c_Sf_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu8c_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_L");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_L.v2");
    check_field_offset(lv, v3, 1, "BFu8c_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_L, BFu8c_Sf_L)
//============================================================================



static void Test_BFu8c_Sf_S()
{
  {
    init_simple_test("BFu8c_Sf_S");
    static STRUCT_IF_C BFu8c_Sf_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_S");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_S.v2");
    check_field_offset(lv, v3, 1, "BFu8c_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_S, BFu8c_Sf_S)
//============================================================================



static void Test_BFu8c_Sf_Sf()
{
  {
    init_simple_test("BFu8c_Sf_Sf");
    static STRUCT_IF_C BFu8c_Sf_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu8c_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_Sf.v2");
    check_field_offset(lv, v3, 1, "BFu8c_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_Sf, BFu8c_Sf_Sf)
//============================================================================



static void Test_BFu8c_Sf_Uc()
{
  {
    init_simple_test("BFu8c_Sf_Uc");
    static STRUCT_IF_C BFu8c_Sf_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_Uc");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_Uc.v2");
    check_field_offset(lv, v3, 1, "BFu8c_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_Uc, BFu8c_Sf_Uc)
//============================================================================



static void Test_BFu8c_Sf_Ui()
{
  {
    init_simple_test("BFu8c_Sf_Ui");
    static STRUCT_IF_C BFu8c_Sf_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_Ui");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_Ui.v2");
    check_field_offset(lv, v3, 1, "BFu8c_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_Ui, BFu8c_Sf_Ui)
//============================================================================



static void Test_BFu8c_Sf_Ul()
{
  {
    init_simple_test("BFu8c_Sf_Ul");
    static STRUCT_IF_C BFu8c_Sf_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu8c_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_Ul");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_Ul.v2");
    check_field_offset(lv, v3, 1, "BFu8c_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_Ul, BFu8c_Sf_Ul)
//============================================================================



static void Test_BFu8c_Sf_Us()
{
  {
    init_simple_test("BFu8c_Sf_Us");
    static STRUCT_IF_C BFu8c_Sf_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_Us");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_Us.v2");
    check_field_offset(lv, v3, 1, "BFu8c_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_Us, BFu8c_Sf_Us)
//============================================================================



static void Test_BFu8c_Sf_Vp()
{
  {
    init_simple_test("BFu8c_Sf_Vp");
    static STRUCT_IF_C BFu8c_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8c_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Sf_Vp");
    check_field_offset(lv, v2, 1, "BFu8c_Sf_Vp.v2");
    check_field_offset(lv, v3, 1, "BFu8c_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Sf_Vp, BFu8c_Sf_Vp)
//============================================================================



static void Test_BFu8c_Uc_Sf()
{
  {
    init_simple_test("BFu8c_Uc_Sf");
    static STRUCT_IF_C BFu8c_Uc_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Uc_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu8c_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Uc_Sf, BFu8c_Uc_Sf)
//============================================================================



static void Test_BFu8c_Ui_Sf()
{
  {
    init_simple_test("BFu8c_Ui_Sf");
    static STRUCT_IF_C BFu8c_Ui_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8c_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Ui_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_Ui_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu8c_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Ui_Sf, BFu8c_Ui_Sf)
//============================================================================



static void Test_BFu8c_Ul_Sf()
{
  {
    init_simple_test("BFu8c_Ul_Sf");
    static STRUCT_IF_C BFu8c_Ul_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu8c_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Ul_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_Ul_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu8c_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Ul_Sf, BFu8c_Ul_Sf)
//============================================================================



static void Test_BFu8c_Us_Sf()
{
  {
    init_simple_test("BFu8c_Us_Sf");
    static STRUCT_IF_C BFu8c_Us_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Us_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_Us_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu8c_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Us_Sf, BFu8c_Us_Sf)
//============================================================================



static void Test_BFu8c_Vp_Sf()
{
  {
    init_simple_test("BFu8c_Vp_Sf");
    static STRUCT_IF_C BFu8c_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8c_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Vp_Sf");
    check_field_offset(lv, v2, 1, "BFu8c_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu8c_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8c_Vp_Sf, BFu8c_Vp_Sf)
//============================================================================



static void Test_BFu8i_BFu15i_Sf()
{
  {
    init_simple_test("BFu8i_BFu15i_Sf");
    static STRUCT_IF_C BFu8i_BFu15i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu15i_Sf");
    check_field_offset(lv, v3, 3, "BFu8i_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu15i_Sf, BFu8i_BFu15i_Sf)
//============================================================================



static void Test_BFu8i_BFu15ll_Sf()
{
  {
    init_simple_test("BFu8i_BFu15ll_Sf");
    static STRUCT_IF_C BFu8i_BFu15ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu15ll_Sf");
    check_field_offset(lv, v3, 3, "BFu8i_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu15ll_Sf, BFu8i_BFu15ll_Sf)
//============================================================================



static void Test_BFu8i_BFu15s_Sf()
{
  {
    init_simple_test("BFu8i_BFu15s_Sf");
    static STRUCT_IF_C BFu8i_BFu15s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu15s_Sf");
    check_field_offset(lv, v3, 3, "BFu8i_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu15s_Sf, BFu8i_BFu15s_Sf)
//============================================================================



static void Test_BFu8i_BFu16i_Sf()
{
  {
    init_simple_test("BFu8i_BFu16i_Sf");
    static STRUCT_IF_C BFu8i_BFu16i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "BFu8i_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu16i_Sf, BFu8i_BFu16i_Sf)
//============================================================================



static void Test_BFu8i_BFu16ll_Sf()
{
  {
    init_simple_test("BFu8i_BFu16ll_Sf");
    static STRUCT_IF_C BFu8i_BFu16ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "BFu8i_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu16ll_Sf, BFu8i_BFu16ll_Sf)
//============================================================================



static void Test_BFu8i_BFu16s_Sf()
{
  {
    init_simple_test("BFu8i_BFu16s_Sf");
    static STRUCT_IF_C BFu8i_BFu16s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu16s_Sf");
    check_field_offset(lv, v3, 3, "BFu8i_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu16s_Sf, BFu8i_BFu16s_Sf)
//============================================================================



static void Test_BFu8i_BFu17i_Sf()
{
  {
    init_simple_test("BFu8i_BFu17i_Sf");
    static STRUCT_IF_C BFu8i_BFu17i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "BFu8i_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu17i_Sf, BFu8i_BFu17i_Sf)
//============================================================================



static void Test_BFu8i_BFu17ll_Sf()
{
  {
    init_simple_test("BFu8i_BFu17ll_Sf");
    static STRUCT_IF_C BFu8i_BFu17ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "BFu8i_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu17ll_Sf, BFu8i_BFu17ll_Sf)
//============================================================================



static void Test_BFu8i_BFu1c_Sf()
{
  {
    init_simple_test("BFu8i_BFu1c_Sf");
    static STRUCT_IF_C BFu8i_BFu1c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8i_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "BFu8i_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu1c_Sf, BFu8i_BFu1c_Sf)
//============================================================================



static void Test_BFu8i_BFu1i_Sf()
{
  {
    init_simple_test("BFu8i_BFu1i_Sf");
    static STRUCT_IF_C BFu8i_BFu1i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8i_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "BFu8i_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu1i_Sf, BFu8i_BFu1i_Sf)
//============================================================================



static void Test_BFu8i_BFu1ll_Sf()
{
  {
    init_simple_test("BFu8i_BFu1ll_Sf");
    static STRUCT_IF_C BFu8i_BFu1ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8i_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "BFu8i_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu1ll_Sf, BFu8i_BFu1ll_Sf)
//============================================================================



static void Test_BFu8i_BFu1s_Sf()
{
  {
    init_simple_test("BFu8i_BFu1s_Sf");
    static STRUCT_IF_C BFu8i_BFu1s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8i_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "BFu8i_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu1s_Sf, BFu8i_BFu1s_Sf)
//============================================================================



static void Test_BFu8i_BFu31i_Sf()
{
  {
    init_simple_test("BFu8i_BFu31i_Sf");
    static STRUCT_IF_C BFu8i_BFu31i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu8i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu31i_Sf");
    check_field_offset(lv, v3, 5, "BFu8i_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu31i_Sf, BFu8i_BFu31i_Sf)
//============================================================================



static void Test_BFu8i_BFu31ll_Sf()
{
  {
    init_simple_test("BFu8i_BFu31ll_Sf");
    static STRUCT_IF_C BFu8i_BFu31ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu8i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu31ll_Sf");
    check_field_offset(lv, v3, 5, "BFu8i_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu31ll_Sf, BFu8i_BFu31ll_Sf)
//============================================================================



static void Test_BFu8i_BFu32i_Sf()
{
  {
    init_simple_test("BFu8i_BFu32i_Sf");
    static STRUCT_IF_C BFu8i_BFu32i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu8i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu32i_Sf");
    check_field_offset(lv, v3, 5, "BFu8i_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu32i_Sf, BFu8i_BFu32i_Sf)
//============================================================================



static void Test_BFu8i_BFu32ll_Sf()
{
  {
    init_simple_test("BFu8i_BFu32ll_Sf");
    static STRUCT_IF_C BFu8i_BFu32ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu8i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "BFu8i_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu32ll_Sf, BFu8i_BFu32ll_Sf)
//============================================================================



static void Test_BFu8i_BFu33_Sf()
{
  {
    init_simple_test("BFu8i_BFu33_Sf");
    static STRUCT_IF_C BFu8i_BFu33_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu8i_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_Sf");
    check_field_offset(lv, v3, 6, "BFu8i_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu33_Sf, BFu8i_BFu33_Sf)
//============================================================================



static void Test_BFu8i_BFu7c_Sf()
{
  {
    init_simple_test("BFu8i_BFu7c_Sf");
    static STRUCT_IF_C BFu8i_BFu7c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_Sf");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7c_Sf, BFu8i_BFu7c_Sf)
//============================================================================



static void Test_BFu8i_BFu7i_Sf()
{
  {
    init_simple_test("BFu8i_BFu7i_Sf");
    static STRUCT_IF_C BFu8i_BFu7i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_Sf");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7i_Sf, BFu8i_BFu7i_Sf)
//============================================================================



static void Test_BFu8i_BFu7ll_Sf()
{
  {
    init_simple_test("BFu8i_BFu7ll_Sf");
    static STRUCT_IF_C BFu8i_BFu7ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_Sf");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7ll_Sf, BFu8i_BFu7ll_Sf)
//============================================================================



static void Test_BFu8i_BFu7s_Sf()
{
  {
    init_simple_test("BFu8i_BFu7s_Sf");
    static STRUCT_IF_C BFu8i_BFu7s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_Sf");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu7s_Sf, BFu8i_BFu7s_Sf)
//============================================================================



static void Test_BFu8i_BFu8c_Sf()
{
  {
    init_simple_test("BFu8i_BFu8c_Sf");
    static STRUCT_IF_C BFu8i_BFu8c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8c_Sf, BFu8i_BFu8c_Sf)
//============================================================================



static void Test_BFu8i_BFu8i_Sf()
{
  {
    init_simple_test("BFu8i_BFu8i_Sf");
    static STRUCT_IF_C BFu8i_BFu8i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8i_Sf, BFu8i_BFu8i_Sf)
//============================================================================



static void Test_BFu8i_BFu8ll_Sf()
{
  {
    init_simple_test("BFu8i_BFu8ll_Sf");
    static STRUCT_IF_C BFu8i_BFu8ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8ll_Sf, BFu8i_BFu8ll_Sf)
//============================================================================



static void Test_BFu8i_BFu8s_Sf()
{
  {
    init_simple_test("BFu8i_BFu8s_Sf");
    static STRUCT_IF_C BFu8i_BFu8s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu8s_Sf, BFu8i_BFu8s_Sf)
//============================================================================



static void Test_BFu8i_BFu9i_Sf()
{
  {
    init_simple_test("BFu8i_BFu9i_Sf");
    static STRUCT_IF_C BFu8i_BFu9i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_Sf");
    check_field_offset(lv, v3, 3, "BFu8i_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9i_Sf, BFu8i_BFu9i_Sf)
//============================================================================



static void Test_BFu8i_BFu9ll_Sf()
{
  {
    init_simple_test("BFu8i_BFu9ll_Sf");
    static STRUCT_IF_C BFu8i_BFu9ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_Sf");
    check_field_offset(lv, v3, 3, "BFu8i_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9ll_Sf, BFu8i_BFu9ll_Sf)
//============================================================================



static void Test_BFu8i_BFu9s_Sf()
{
  {
    init_simple_test("BFu8i_BFu9s_Sf");
    static STRUCT_IF_C BFu8i_BFu9s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_Sf");
    check_field_offset(lv, v3, 3, "BFu8i_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_BFu9s_Sf, BFu8i_BFu9s_Sf)
//============================================================================



static void Test_BFu8i_C_Sf()
{
  {
    init_simple_test("BFu8i_C_Sf");
    static STRUCT_IF_C BFu8i_C_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_C_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu8i_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_C_Sf, BFu8i_C_Sf)
//============================================================================



static void Test_BFu8i_D_Sf()
{
  {
    init_simple_test("BFu8i_D_Sf");
    static STRUCT_IF_C BFu8i_D_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu8i_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_D_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu8i_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_D_Sf, BFu8i_D_Sf)
//============================================================================



static void Test_BFu8i_F_Sf()
{
  {
    init_simple_test("BFu8i_F_Sf");
    static STRUCT_IF_C BFu8i_F_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_F_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu8i_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_F_Sf, BFu8i_F_Sf)
//============================================================================



static void Test_BFu8i_I_Sf()
{
  {
    init_simple_test("BFu8i_I_Sf");
    static STRUCT_IF_C BFu8i_I_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_I_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu8i_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_I_Sf, BFu8i_I_Sf)
//============================================================================



static void Test_BFu8i_Ip_Sf()
{
  {
    init_simple_test("BFu8i_Ip_Sf");
    static STRUCT_IF_C BFu8i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8i_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu8i_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ip_Sf, BFu8i_Ip_Sf)
//============================================================================



static void Test_BFu8i_L_Sf()
{
  {
    init_simple_test("BFu8i_L_Sf");
    static STRUCT_IF_C BFu8i_L_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu8i_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_L_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu8i_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_L_Sf, BFu8i_L_Sf)
//============================================================================



static void Test_BFu8i_S_Sf()
{
  {
    init_simple_test("BFu8i_S_Sf");
    static STRUCT_IF_C BFu8i_S_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_S_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu8i_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_S_Sf, BFu8i_S_Sf)
//============================================================================



static void Test_BFu8i_Sf()
{
  {
    init_simple_test("BFu8i_Sf");
    static STRUCT_IF_C BFu8i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf, BFu8i_Sf)
//============================================================================



static void Test_BFu8i_Sf_BFu15i()
{
  {
    init_simple_test("BFu8i_Sf_BFu15i");
    static STRUCT_IF_C BFu8i_Sf_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu8i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu8i_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu15i, BFu8i_Sf_BFu15i)
//============================================================================



static void Test_BFu8i_Sf_BFu15ll()
{
  {
    init_simple_test("BFu8i_Sf_BFu15ll");
    static STRUCT_IF_C BFu8i_Sf_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu8i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu8i_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu15ll, BFu8i_Sf_BFu15ll)
//============================================================================



static void Test_BFu8i_Sf_BFu15s()
{
  {
    init_simple_test("BFu8i_Sf_BFu15s");
    static STRUCT_IF_C BFu8i_Sf_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu8i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu8i_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu15s, BFu8i_Sf_BFu15s)
//============================================================================



static void Test_BFu8i_Sf_BFu16i()
{
  {
    init_simple_test("BFu8i_Sf_BFu16i");
    static STRUCT_IF_C BFu8i_Sf_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu8i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu8i_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu16i, BFu8i_Sf_BFu16i)
//============================================================================



static void Test_BFu8i_Sf_BFu16ll()
{
  {
    init_simple_test("BFu8i_Sf_BFu16ll");
    static STRUCT_IF_C BFu8i_Sf_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu8i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu8i_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu16ll, BFu8i_Sf_BFu16ll)
//============================================================================



static void Test_BFu8i_Sf_BFu16s()
{
  {
    init_simple_test("BFu8i_Sf_BFu16s");
    static STRUCT_IF_C BFu8i_Sf_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu8i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu8i_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu16s, BFu8i_Sf_BFu16s)
//============================================================================



static void Test_BFu8i_Sf_BFu17i()
{
  {
    init_simple_test("BFu8i_Sf_BFu17i");
    static STRUCT_IF_C BFu8i_Sf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu8i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu8i_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu17i, BFu8i_Sf_BFu17i)
//============================================================================



static void Test_BFu8i_Sf_BFu17ll()
{
  {
    init_simple_test("BFu8i_Sf_BFu17ll");
    static STRUCT_IF_C BFu8i_Sf_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu8i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu8i_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu17ll, BFu8i_Sf_BFu17ll)
//============================================================================



static void Test_BFu8i_Sf_BFu1c()
{
  {
    init_simple_test("BFu8i_Sf_BFu1c");
    static STRUCT_IF_C BFu8i_Sf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8i_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu1c, BFu8i_Sf_BFu1c)
//============================================================================



static void Test_BFu8i_Sf_BFu1i()
{
  {
    init_simple_test("BFu8i_Sf_BFu1i");
    static STRUCT_IF_C BFu8i_Sf_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8i_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu1i, BFu8i_Sf_BFu1i)
//============================================================================



static void Test_BFu8i_Sf_BFu1ll()
{
  {
    init_simple_test("BFu8i_Sf_BFu1ll");
    static STRUCT_IF_C BFu8i_Sf_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8i_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu1ll, BFu8i_Sf_BFu1ll)
//============================================================================



static void Test_BFu8i_Sf_BFu1s()
{
  {
    init_simple_test("BFu8i_Sf_BFu1s");
    static STRUCT_IF_C BFu8i_Sf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8i_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu1s, BFu8i_Sf_BFu1s)
//============================================================================



static void Test_BFu8i_Sf_BFu31i()
{
  {
    init_simple_test("BFu8i_Sf_BFu31i");
    static STRUCT_IF_C BFu8i_Sf_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu8i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu8i_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu31i, BFu8i_Sf_BFu31i)
//============================================================================



static void Test_BFu8i_Sf_BFu31ll()
{
  {
    init_simple_test("BFu8i_Sf_BFu31ll");
    static STRUCT_IF_C BFu8i_Sf_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu8i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu8i_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu31ll, BFu8i_Sf_BFu31ll)
//============================================================================



static void Test_BFu8i_Sf_BFu32i()
{
  {
    init_simple_test("BFu8i_Sf_BFu32i");
    static STRUCT_IF_C BFu8i_Sf_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu8i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu8i_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu32i, BFu8i_Sf_BFu32i)
//============================================================================



static void Test_BFu8i_Sf_BFu32ll()
{
  {
    init_simple_test("BFu8i_Sf_BFu32ll");
    static STRUCT_IF_C BFu8i_Sf_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu8i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu8i_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu32ll, BFu8i_Sf_BFu32ll)
//============================================================================



static void Test_BFu8i_Sf_BFu33()
{
  {
    init_simple_test("BFu8i_Sf_BFu33");
    static STRUCT_IF_C BFu8i_Sf_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu8i_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu33");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 1, 0, 33, 1, "BFu8i_Sf_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu33, BFu8i_Sf_BFu33)
//============================================================================



static void Test_BFu8i_Sf_BFu7c()
{
  {
    init_simple_test("BFu8i_Sf_BFu7c");
    static STRUCT_IF_C BFu8i_Sf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu7c, BFu8i_Sf_BFu7c)
//============================================================================



static void Test_BFu8i_Sf_BFu7i()
{
  {
    init_simple_test("BFu8i_Sf_BFu7i");
    static STRUCT_IF_C BFu8i_Sf_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu7i, BFu8i_Sf_BFu7i)
//============================================================================



static void Test_BFu8i_Sf_BFu7ll()
{
  {
    init_simple_test("BFu8i_Sf_BFu7ll");
    static STRUCT_IF_C BFu8i_Sf_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu7ll, BFu8i_Sf_BFu7ll)
//============================================================================



static void Test_BFu8i_Sf_BFu7s()
{
  {
    init_simple_test("BFu8i_Sf_BFu7s");
    static STRUCT_IF_C BFu8i_Sf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu7s, BFu8i_Sf_BFu7s)
//============================================================================



static void Test_BFu8i_Sf_BFu8c()
{
  {
    init_simple_test("BFu8i_Sf_BFu8c");
    static STRUCT_IF_C BFu8i_Sf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu8c, BFu8i_Sf_BFu8c)
//============================================================================



static void Test_BFu8i_Sf_BFu8i()
{
  {
    init_simple_test("BFu8i_Sf_BFu8i");
    static STRUCT_IF_C BFu8i_Sf_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu8i, BFu8i_Sf_BFu8i)
//============================================================================



static void Test_BFu8i_Sf_BFu8ll()
{
  {
    init_simple_test("BFu8i_Sf_BFu8ll");
    static STRUCT_IF_C BFu8i_Sf_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu8ll, BFu8i_Sf_BFu8ll)
//============================================================================



static void Test_BFu8i_Sf_BFu8s()
{
  {
    init_simple_test("BFu8i_Sf_BFu8s");
    static STRUCT_IF_C BFu8i_Sf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu8s, BFu8i_Sf_BFu8s)
//============================================================================



static void Test_BFu8i_Sf_BFu9i()
{
  {
    init_simple_test("BFu8i_Sf_BFu9i");
    static STRUCT_IF_C BFu8i_Sf_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu8i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu9i, BFu8i_Sf_BFu9i)
//============================================================================



static void Test_BFu8i_Sf_BFu9ll()
{
  {
    init_simple_test("BFu8i_Sf_BFu9ll");
    static STRUCT_IF_C BFu8i_Sf_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu8i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu9ll, BFu8i_Sf_BFu9ll)
//============================================================================



static void Test_BFu8i_Sf_BFu9s()
{
  {
    init_simple_test("BFu8i_Sf_BFu9s");
    static STRUCT_IF_C BFu8i_Sf_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu8i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_BFu9s, BFu8i_Sf_BFu9s)
//============================================================================



static void Test_BFu8i_Sf_C()
{
  {
    init_simple_test("BFu8i_Sf_C");
    static STRUCT_IF_C BFu8i_Sf_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_C");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_C.v2");
    check_field_offset(lv, v3, 1, "BFu8i_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_C, BFu8i_Sf_C)
//============================================================================



static void Test_BFu8i_Sf_D()
{
  {
    init_simple_test("BFu8i_Sf_D");
    static STRUCT_IF_C BFu8i_Sf_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu8i_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_D");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_D.v2");
    check_field_offset(lv, v3, 1, "BFu8i_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_D, BFu8i_Sf_D)
//============================================================================



static void Test_BFu8i_Sf_F()
{
  {
    init_simple_test("BFu8i_Sf_F");
    static STRUCT_IF_C BFu8i_Sf_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_F");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_F.v2");
    check_field_offset(lv, v3, 1, "BFu8i_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_F, BFu8i_Sf_F)
//============================================================================



static void Test_BFu8i_Sf_I()
{
  {
    init_simple_test("BFu8i_Sf_I");
    static STRUCT_IF_C BFu8i_Sf_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_I");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_I.v2");
    check_field_offset(lv, v3, 1, "BFu8i_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_I, BFu8i_Sf_I)
//============================================================================



static void Test_BFu8i_Sf_Ip()
{
  {
    init_simple_test("BFu8i_Sf_Ip");
    static STRUCT_IF_C BFu8i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8i_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_Ip");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_Ip.v2");
    check_field_offset(lv, v3, 1, "BFu8i_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_Ip, BFu8i_Sf_Ip)
//============================================================================



static void Test_BFu8i_Sf_L()
{
  {
    init_simple_test("BFu8i_Sf_L");
    static STRUCT_IF_C BFu8i_Sf_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu8i_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_L");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_L.v2");
    check_field_offset(lv, v3, 1, "BFu8i_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_L, BFu8i_Sf_L)
//============================================================================



static void Test_BFu8i_Sf_S()
{
  {
    init_simple_test("BFu8i_Sf_S");
    static STRUCT_IF_C BFu8i_Sf_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_S");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_S.v2");
    check_field_offset(lv, v3, 1, "BFu8i_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_S, BFu8i_Sf_S)
//============================================================================



static void Test_BFu8i_Sf_Sf()
{
  {
    init_simple_test("BFu8i_Sf_Sf");
    static STRUCT_IF_C BFu8i_Sf_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu8i_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_Sf.v2");
    check_field_offset(lv, v3, 1, "BFu8i_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_Sf, BFu8i_Sf_Sf)
//============================================================================



static void Test_BFu8i_Sf_Uc()
{
  {
    init_simple_test("BFu8i_Sf_Uc");
    static STRUCT_IF_C BFu8i_Sf_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_Uc");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_Uc.v2");
    check_field_offset(lv, v3, 1, "BFu8i_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_Uc, BFu8i_Sf_Uc)
//============================================================================



static void Test_BFu8i_Sf_Ui()
{
  {
    init_simple_test("BFu8i_Sf_Ui");
    static STRUCT_IF_C BFu8i_Sf_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_Ui");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_Ui.v2");
    check_field_offset(lv, v3, 1, "BFu8i_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_Ui, BFu8i_Sf_Ui)
//============================================================================



static void Test_BFu8i_Sf_Ul()
{
  {
    init_simple_test("BFu8i_Sf_Ul");
    static STRUCT_IF_C BFu8i_Sf_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu8i_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_Ul");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_Ul.v2");
    check_field_offset(lv, v3, 1, "BFu8i_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_Ul, BFu8i_Sf_Ul)
//============================================================================



static void Test_BFu8i_Sf_Us()
{
  {
    init_simple_test("BFu8i_Sf_Us");
    static STRUCT_IF_C BFu8i_Sf_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_Us");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_Us.v2");
    check_field_offset(lv, v3, 1, "BFu8i_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_Us, BFu8i_Sf_Us)
//============================================================================



static void Test_BFu8i_Sf_Vp()
{
  {
    init_simple_test("BFu8i_Sf_Vp");
    static STRUCT_IF_C BFu8i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8i_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Sf_Vp");
    check_field_offset(lv, v2, 1, "BFu8i_Sf_Vp.v2");
    check_field_offset(lv, v3, 1, "BFu8i_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Sf_Vp, BFu8i_Sf_Vp)
//============================================================================



static void Test_BFu8i_Uc_Sf()
{
  {
    init_simple_test("BFu8i_Uc_Sf");
    static STRUCT_IF_C BFu8i_Uc_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8i_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Uc_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu8i_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Uc_Sf, BFu8i_Uc_Sf)
//============================================================================



static void Test_BFu8i_Ui_Sf()
{
  {
    init_simple_test("BFu8i_Ui_Sf");
    static STRUCT_IF_C BFu8i_Ui_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8i_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ui_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_Ui_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu8i_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ui_Sf, BFu8i_Ui_Sf)
//============================================================================



static void Test_BFu8i_Ul_Sf()
{
  {
    init_simple_test("BFu8i_Ul_Sf");
    static STRUCT_IF_C BFu8i_Ul_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu8i_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ul_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_Ul_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu8i_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Ul_Sf, BFu8i_Ul_Sf)
//============================================================================



static void Test_BFu8i_Us_Sf()
{
  {
    init_simple_test("BFu8i_Us_Sf");
    static STRUCT_IF_C BFu8i_Us_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8i_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Us_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_Us_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu8i_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Us_Sf, BFu8i_Us_Sf)
//============================================================================



static void Test_BFu8i_Vp_Sf()
{
  {
    init_simple_test("BFu8i_Vp_Sf");
    static STRUCT_IF_C BFu8i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8i_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Vp_Sf");
    check_field_offset(lv, v2, 1, "BFu8i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu8i_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8i_Vp_Sf, BFu8i_Vp_Sf)
//============================================================================



static void Test_BFu8ll_BFu15i_Sf()
{
  {
    init_simple_test("BFu8ll_BFu15i_Sf");
    static STRUCT_IF_C BFu8ll_BFu15i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8ll_BFu15i_Sf");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu15i_Sf, BFu8ll_BFu15i_Sf)
//============================================================================



static void Test_BFu8ll_BFu15ll_Sf()
{
  {
    init_simple_test("BFu8ll_BFu15ll_Sf");
    static STRUCT_IF_C BFu8ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu15ll_Sf, BFu8ll_BFu15ll_Sf)
//============================================================================



static void Test_BFu8ll_BFu15s_Sf()
{
  {
    init_simple_test("BFu8ll_BFu15s_Sf");
    static STRUCT_IF_C BFu8ll_BFu15s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8ll_BFu15s_Sf");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu15s_Sf, BFu8ll_BFu15s_Sf)
//============================================================================



static void Test_BFu8ll_BFu16i_Sf()
{
  {
    init_simple_test("BFu8ll_BFu16i_Sf");
    static STRUCT_IF_C BFu8ll_BFu16i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8ll_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu16i_Sf, BFu8ll_BFu16i_Sf)
//============================================================================



static void Test_BFu8ll_BFu16ll_Sf()
{
  {
    init_simple_test("BFu8ll_BFu16ll_Sf");
    static STRUCT_IF_C BFu8ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu16ll_Sf, BFu8ll_BFu16ll_Sf)
//============================================================================



static void Test_BFu8ll_BFu16s_Sf()
{
  {
    init_simple_test("BFu8ll_BFu16s_Sf");
    static STRUCT_IF_C BFu8ll_BFu16s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8ll_BFu16s_Sf");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu16s_Sf, BFu8ll_BFu16s_Sf)
//============================================================================



static void Test_BFu8ll_BFu17i_Sf()
{
  {
    init_simple_test("BFu8ll_BFu17i_Sf");
    static STRUCT_IF_C BFu8ll_BFu17i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu8ll_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8ll_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "BFu8ll_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu17i_Sf, BFu8ll_BFu17i_Sf)
//============================================================================



static void Test_BFu8ll_BFu17ll_Sf()
{
  {
    init_simple_test("BFu8ll_BFu17ll_Sf");
    static STRUCT_IF_C BFu8ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu8ll_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "BFu8ll_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu17ll_Sf, BFu8ll_BFu17ll_Sf)
//============================================================================



static void Test_BFu8ll_BFu1c_Sf()
{
  {
    init_simple_test("BFu8ll_BFu1c_Sf");
    static STRUCT_IF_C BFu8ll_BFu1c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8ll_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu1c_Sf, BFu8ll_BFu1c_Sf)
//============================================================================



static void Test_BFu8ll_BFu1i_Sf()
{
  {
    init_simple_test("BFu8ll_BFu1i_Sf");
    static STRUCT_IF_C BFu8ll_BFu1i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8ll_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu1i_Sf, BFu8ll_BFu1i_Sf)
//============================================================================



static void Test_BFu8ll_BFu1ll_Sf()
{
  {
    init_simple_test("BFu8ll_BFu1ll_Sf");
    static STRUCT_IF_C BFu8ll_BFu1ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu1ll_Sf, BFu8ll_BFu1ll_Sf)
//============================================================================



static void Test_BFu8ll_BFu1s_Sf()
{
  {
    init_simple_test("BFu8ll_BFu1s_Sf");
    static STRUCT_IF_C BFu8ll_BFu1s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8ll_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu1s_Sf, BFu8ll_BFu1s_Sf)
//============================================================================



static void Test_BFu8ll_BFu31i_Sf()
{
  {
    init_simple_test("BFu8ll_BFu31i_Sf");
    static STRUCT_IF_C BFu8ll_BFu31i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu8ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu8ll_BFu31i_Sf");
    check_field_offset(lv, v3, 5, "BFu8ll_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu31i_Sf, BFu8ll_BFu31i_Sf)
//============================================================================



static void Test_BFu8ll_BFu31ll_Sf()
{
  {
    init_simple_test("BFu8ll_BFu31ll_Sf");
    static STRUCT_IF_C BFu8ll_BFu31ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu8ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu8ll_BFu31ll_Sf");
    check_field_offset(lv, v3, 5, "BFu8ll_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu31ll_Sf, BFu8ll_BFu31ll_Sf)
//============================================================================



static void Test_BFu8ll_BFu32i_Sf()
{
  {
    init_simple_test("BFu8ll_BFu32i_Sf");
    static STRUCT_IF_C BFu8ll_BFu32i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu8ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu8ll_BFu32i_Sf");
    check_field_offset(lv, v3, 5, "BFu8ll_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu32i_Sf, BFu8ll_BFu32i_Sf)
//============================================================================



static void Test_BFu8ll_BFu32ll_Sf()
{
  {
    init_simple_test("BFu8ll_BFu32ll_Sf");
    static STRUCT_IF_C BFu8ll_BFu32ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu8ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu8ll_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "BFu8ll_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu32ll_Sf, BFu8ll_BFu32ll_Sf)
//============================================================================



static void Test_BFu8ll_BFu33_Sf()
{
  {
    init_simple_test("BFu8ll_BFu33_Sf");
    static STRUCT_IF_C BFu8ll_BFu33_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu8ll_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8ll_BFu33_Sf");
    check_field_offset(lv, v3, 6, "BFu8ll_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu33_Sf, BFu8ll_BFu33_Sf)
//============================================================================



static void Test_BFu8ll_BFu7c_Sf()
{
  {
    init_simple_test("BFu8ll_BFu7c_Sf");
    static STRUCT_IF_C BFu8ll_BFu7c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8ll_BFu7c_Sf");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu7c_Sf, BFu8ll_BFu7c_Sf)
//============================================================================



static void Test_BFu8ll_BFu7i_Sf()
{
  {
    init_simple_test("BFu8ll_BFu7i_Sf");
    static STRUCT_IF_C BFu8ll_BFu7i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8ll_BFu7i_Sf");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu7i_Sf, BFu8ll_BFu7i_Sf)
//============================================================================



static void Test_BFu8ll_BFu7ll_Sf()
{
  {
    init_simple_test("BFu8ll_BFu7ll_Sf");
    static STRUCT_IF_C BFu8ll_BFu7ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8ll_BFu7ll_Sf");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu7ll_Sf, BFu8ll_BFu7ll_Sf)
//============================================================================



static void Test_BFu8ll_BFu7s_Sf()
{
  {
    init_simple_test("BFu8ll_BFu7s_Sf");
    static STRUCT_IF_C BFu8ll_BFu7s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8ll_BFu7s_Sf");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu7s_Sf, BFu8ll_BFu7s_Sf)
//============================================================================



static void Test_BFu8ll_BFu8c_Sf()
{
  {
    init_simple_test("BFu8ll_BFu8c_Sf");
    static STRUCT_IF_C BFu8ll_BFu8c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu8c_Sf, BFu8ll_BFu8c_Sf)
//============================================================================



static void Test_BFu8ll_BFu8i_Sf()
{
  {
    init_simple_test("BFu8ll_BFu8i_Sf");
    static STRUCT_IF_C BFu8ll_BFu8i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu8i_Sf, BFu8ll_BFu8i_Sf)
//============================================================================



static void Test_BFu8ll_BFu8ll_Sf()
{
  {
    init_simple_test("BFu8ll_BFu8ll_Sf");
    static STRUCT_IF_C BFu8ll_BFu8ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu8ll_Sf, BFu8ll_BFu8ll_Sf)
//============================================================================



static void Test_BFu8ll_BFu8s_Sf()
{
  {
    init_simple_test("BFu8ll_BFu8s_Sf");
    static STRUCT_IF_C BFu8ll_BFu8s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu8s_Sf, BFu8ll_BFu8s_Sf)
//============================================================================



static void Test_BFu8ll_BFu9i_Sf()
{
  {
    init_simple_test("BFu8ll_BFu9i_Sf");
    static STRUCT_IF_C BFu8ll_BFu9i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8ll_BFu9i_Sf");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu9i_Sf, BFu8ll_BFu9i_Sf)
//============================================================================



static void Test_BFu8ll_BFu9ll_Sf()
{
  {
    init_simple_test("BFu8ll_BFu9ll_Sf");
    static STRUCT_IF_C BFu8ll_BFu9ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8ll_BFu9ll_Sf");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu9ll_Sf, BFu8ll_BFu9ll_Sf)
//============================================================================



static void Test_BFu8ll_BFu9s_Sf()
{
  {
    init_simple_test("BFu8ll_BFu9s_Sf");
    static STRUCT_IF_C BFu8ll_BFu9s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8ll_BFu9s_Sf");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_BFu9s_Sf, BFu8ll_BFu9s_Sf)
//============================================================================



static void Test_BFu8ll_C_Sf()
{
  {
    init_simple_test("BFu8ll_C_Sf");
    static STRUCT_IF_C BFu8ll_C_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_C_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_C_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu8ll_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_C_Sf, BFu8ll_C_Sf)
//============================================================================



static void Test_BFu8ll_D_Sf()
{
  {
    init_simple_test("BFu8ll_D_Sf");
    static STRUCT_IF_C BFu8ll_D_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu8ll_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_D_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_D_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu8ll_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_D_Sf, BFu8ll_D_Sf)
//============================================================================



static void Test_BFu8ll_F_Sf()
{
  {
    init_simple_test("BFu8ll_F_Sf");
    static STRUCT_IF_C BFu8ll_F_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_F_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_F_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu8ll_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_F_Sf, BFu8ll_F_Sf)
//============================================================================



static void Test_BFu8ll_I_Sf()
{
  {
    init_simple_test("BFu8ll_I_Sf");
    static STRUCT_IF_C BFu8ll_I_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_I_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_I_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu8ll_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_I_Sf, BFu8ll_I_Sf)
//============================================================================



static void Test_BFu8ll_Ip_Sf()
{
  {
    init_simple_test("BFu8ll_Ip_Sf");
    static STRUCT_IF_C BFu8ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8ll_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Ip_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu8ll_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Ip_Sf, BFu8ll_Ip_Sf)
//============================================================================



static void Test_BFu8ll_L_Sf()
{
  {
    init_simple_test("BFu8ll_L_Sf");
    static STRUCT_IF_C BFu8ll_L_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu8ll_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_L_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_L_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu8ll_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_L_Sf, BFu8ll_L_Sf)
//============================================================================



static void Test_BFu8ll_S_Sf()
{
  {
    init_simple_test("BFu8ll_S_Sf");
    static STRUCT_IF_C BFu8ll_S_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_S_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_S_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu8ll_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_S_Sf, BFu8ll_S_Sf)
//============================================================================



static void Test_BFu8ll_Sf()
{
  {
    init_simple_test("BFu8ll_Sf");
    static STRUCT_IF_C BFu8ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf, BFu8ll_Sf)
//============================================================================



static void Test_BFu8ll_Sf_BFu15i()
{
  {
    init_simple_test("BFu8ll_Sf_BFu15i");
    static STRUCT_IF_C BFu8ll_Sf_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu8ll_Sf_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu8ll_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu15i, BFu8ll_Sf_BFu15i)
//============================================================================



static void Test_BFu8ll_Sf_BFu15ll()
{
  {
    init_simple_test("BFu8ll_Sf_BFu15ll");
    static STRUCT_IF_C BFu8ll_Sf_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu8ll_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu8ll_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu15ll, BFu8ll_Sf_BFu15ll)
//============================================================================



static void Test_BFu8ll_Sf_BFu15s()
{
  {
    init_simple_test("BFu8ll_Sf_BFu15s");
    static STRUCT_IF_C BFu8ll_Sf_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu8ll_Sf_BFu15s");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu8ll_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu15s, BFu8ll_Sf_BFu15s)
//============================================================================



static void Test_BFu8ll_Sf_BFu16i()
{
  {
    init_simple_test("BFu8ll_Sf_BFu16i");
    static STRUCT_IF_C BFu8ll_Sf_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu8ll_Sf_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu8ll_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu16i, BFu8ll_Sf_BFu16i)
//============================================================================



static void Test_BFu8ll_Sf_BFu16ll()
{
  {
    init_simple_test("BFu8ll_Sf_BFu16ll");
    static STRUCT_IF_C BFu8ll_Sf_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu8ll_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu8ll_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu16ll, BFu8ll_Sf_BFu16ll)
//============================================================================



static void Test_BFu8ll_Sf_BFu16s()
{
  {
    init_simple_test("BFu8ll_Sf_BFu16s");
    static STRUCT_IF_C BFu8ll_Sf_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu8ll_Sf_BFu16s");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu8ll_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu16s, BFu8ll_Sf_BFu16s)
//============================================================================



static void Test_BFu8ll_Sf_BFu17i()
{
  {
    init_simple_test("BFu8ll_Sf_BFu17i");
    static STRUCT_IF_C BFu8ll_Sf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8ll_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu8ll_Sf_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu8ll_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu17i, BFu8ll_Sf_BFu17i)
//============================================================================



static void Test_BFu8ll_Sf_BFu17ll()
{
  {
    init_simple_test("BFu8ll_Sf_BFu17ll");
    static STRUCT_IF_C BFu8ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu8ll_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu8ll_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu8ll_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu17ll, BFu8ll_Sf_BFu17ll)
//============================================================================



static void Test_BFu8ll_Sf_BFu1c()
{
  {
    init_simple_test("BFu8ll_Sf_BFu1c");
    static STRUCT_IF_C BFu8ll_Sf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8ll_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu1c, BFu8ll_Sf_BFu1c)
//============================================================================



static void Test_BFu8ll_Sf_BFu1i()
{
  {
    init_simple_test("BFu8ll_Sf_BFu1i");
    static STRUCT_IF_C BFu8ll_Sf_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8ll_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu1i, BFu8ll_Sf_BFu1i)
//============================================================================



static void Test_BFu8ll_Sf_BFu1ll()
{
  {
    init_simple_test("BFu8ll_Sf_BFu1ll");
    static STRUCT_IF_C BFu8ll_Sf_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8ll_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu1ll, BFu8ll_Sf_BFu1ll)
//============================================================================



static void Test_BFu8ll_Sf_BFu1s()
{
  {
    init_simple_test("BFu8ll_Sf_BFu1s");
    static STRUCT_IF_C BFu8ll_Sf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8ll_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu1s, BFu8ll_Sf_BFu1s)
//============================================================================



static void Test_BFu8ll_Sf_BFu31i()
{
  {
    init_simple_test("BFu8ll_Sf_BFu31i");
    static STRUCT_IF_C BFu8ll_Sf_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu8ll_Sf_BFu31i");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu8ll_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu31i, BFu8ll_Sf_BFu31i)
//============================================================================



static void Test_BFu8ll_Sf_BFu31ll()
{
  {
    init_simple_test("BFu8ll_Sf_BFu31ll");
    static STRUCT_IF_C BFu8ll_Sf_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu8ll_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu8ll_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu31ll, BFu8ll_Sf_BFu31ll)
//============================================================================



static void Test_BFu8ll_Sf_BFu32i()
{
  {
    init_simple_test("BFu8ll_Sf_BFu32i");
    static STRUCT_IF_C BFu8ll_Sf_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu8ll_Sf_BFu32i");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu8ll_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu32i, BFu8ll_Sf_BFu32i)
//============================================================================



static void Test_BFu8ll_Sf_BFu32ll()
{
  {
    init_simple_test("BFu8ll_Sf_BFu32ll");
    static STRUCT_IF_C BFu8ll_Sf_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu8ll_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu8ll_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu32ll, BFu8ll_Sf_BFu32ll)
//============================================================================



static void Test_BFu8ll_Sf_BFu33()
{
  {
    init_simple_test("BFu8ll_Sf_BFu33");
    static STRUCT_IF_C BFu8ll_Sf_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu8ll_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu33");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 1, 0, 33, 1, "BFu8ll_Sf_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, hide_ull(1LL<<32), "BFu8ll_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu33, BFu8ll_Sf_BFu33)
//============================================================================



static void Test_BFu8ll_Sf_BFu7c()
{
  {
    init_simple_test("BFu8ll_Sf_BFu7c");
    static STRUCT_IF_C BFu8ll_Sf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8ll_Sf_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8ll_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu7c, BFu8ll_Sf_BFu7c)
//============================================================================



static void Test_BFu8ll_Sf_BFu7i()
{
  {
    init_simple_test("BFu8ll_Sf_BFu7i");
    static STRUCT_IF_C BFu8ll_Sf_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8ll_Sf_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8ll_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu7i, BFu8ll_Sf_BFu7i)
//============================================================================



static void Test_BFu8ll_Sf_BFu7ll()
{
  {
    init_simple_test("BFu8ll_Sf_BFu7ll");
    static STRUCT_IF_C BFu8ll_Sf_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8ll_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8ll_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu7ll, BFu8ll_Sf_BFu7ll)
//============================================================================



static void Test_BFu8ll_Sf_BFu7s()
{
  {
    init_simple_test("BFu8ll_Sf_BFu7s");
    static STRUCT_IF_C BFu8ll_Sf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8ll_Sf_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8ll_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu7s, BFu8ll_Sf_BFu7s)
//============================================================================



static void Test_BFu8ll_Sf_BFu8c()
{
  {
    init_simple_test("BFu8ll_Sf_BFu8c");
    static STRUCT_IF_C BFu8ll_Sf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8ll_Sf_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu8c, BFu8ll_Sf_BFu8c)
//============================================================================



static void Test_BFu8ll_Sf_BFu8i()
{
  {
    init_simple_test("BFu8ll_Sf_BFu8i");
    static STRUCT_IF_C BFu8ll_Sf_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8ll_Sf_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu8i, BFu8ll_Sf_BFu8i)
//============================================================================



static void Test_BFu8ll_Sf_BFu8ll()
{
  {
    init_simple_test("BFu8ll_Sf_BFu8ll");
    static STRUCT_IF_C BFu8ll_Sf_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8ll_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu8ll, BFu8ll_Sf_BFu8ll)
//============================================================================



static void Test_BFu8ll_Sf_BFu8s()
{
  {
    init_simple_test("BFu8ll_Sf_BFu8s");
    static STRUCT_IF_C BFu8ll_Sf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8ll_Sf_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu8s, BFu8ll_Sf_BFu8s)
//============================================================================



static void Test_BFu8ll_Sf_BFu9i()
{
  {
    init_simple_test("BFu8ll_Sf_BFu9i");
    static STRUCT_IF_C BFu8ll_Sf_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu8ll_Sf_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu8ll_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu9i, BFu8ll_Sf_BFu9i)
//============================================================================



static void Test_BFu8ll_Sf_BFu9ll()
{
  {
    init_simple_test("BFu8ll_Sf_BFu9ll");
    static STRUCT_IF_C BFu8ll_Sf_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu8ll_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu8ll_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu9ll, BFu8ll_Sf_BFu9ll)
//============================================================================



static void Test_BFu8ll_Sf_BFu9s()
{
  {
    init_simple_test("BFu8ll_Sf_BFu9s");
    static STRUCT_IF_C BFu8ll_Sf_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu8ll_Sf_BFu9s");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu8ll_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_BFu9s, BFu8ll_Sf_BFu9s)
//============================================================================



static void Test_BFu8ll_Sf_C()
{
  {
    init_simple_test("BFu8ll_Sf_C");
    static STRUCT_IF_C BFu8ll_Sf_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_C");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_C.v2");
    check_field_offset(lv, v3, 1, "BFu8ll_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_C, BFu8ll_Sf_C)
//============================================================================



static void Test_BFu8ll_Sf_D()
{
  {
    init_simple_test("BFu8ll_Sf_D");
    static STRUCT_IF_C BFu8ll_Sf_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu8ll_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_D");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_D.v2");
    check_field_offset(lv, v3, 1, "BFu8ll_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_D, BFu8ll_Sf_D)
//============================================================================



static void Test_BFu8ll_Sf_F()
{
  {
    init_simple_test("BFu8ll_Sf_F");
    static STRUCT_IF_C BFu8ll_Sf_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_F");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_F.v2");
    check_field_offset(lv, v3, 1, "BFu8ll_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_F, BFu8ll_Sf_F)
//============================================================================



static void Test_BFu8ll_Sf_I()
{
  {
    init_simple_test("BFu8ll_Sf_I");
    static STRUCT_IF_C BFu8ll_Sf_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_I");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_I.v2");
    check_field_offset(lv, v3, 1, "BFu8ll_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_I, BFu8ll_Sf_I)
//============================================================================



static void Test_BFu8ll_Sf_Ip()
{
  {
    init_simple_test("BFu8ll_Sf_Ip");
    static STRUCT_IF_C BFu8ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8ll_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_Ip");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_Ip.v2");
    check_field_offset(lv, v3, 1, "BFu8ll_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_Ip, BFu8ll_Sf_Ip)
//============================================================================



static void Test_BFu8ll_Sf_L()
{
  {
    init_simple_test("BFu8ll_Sf_L");
    static STRUCT_IF_C BFu8ll_Sf_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu8ll_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_L");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_L.v2");
    check_field_offset(lv, v3, 1, "BFu8ll_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_L, BFu8ll_Sf_L)
//============================================================================



static void Test_BFu8ll_Sf_S()
{
  {
    init_simple_test("BFu8ll_Sf_S");
    static STRUCT_IF_C BFu8ll_Sf_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_S");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_S.v2");
    check_field_offset(lv, v3, 1, "BFu8ll_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_S, BFu8ll_Sf_S)
//============================================================================



static void Test_BFu8ll_Sf_Sf()
{
  {
    init_simple_test("BFu8ll_Sf_Sf");
    static STRUCT_IF_C BFu8ll_Sf_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu8ll_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_Sf.v2");
    check_field_offset(lv, v3, 1, "BFu8ll_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_Sf, BFu8ll_Sf_Sf)
//============================================================================



static void Test_BFu8ll_Sf_Uc()
{
  {
    init_simple_test("BFu8ll_Sf_Uc");
    static STRUCT_IF_C BFu8ll_Sf_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_Uc");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_Uc.v2");
    check_field_offset(lv, v3, 1, "BFu8ll_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_Uc, BFu8ll_Sf_Uc)
//============================================================================



static void Test_BFu8ll_Sf_Ui()
{
  {
    init_simple_test("BFu8ll_Sf_Ui");
    static STRUCT_IF_C BFu8ll_Sf_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_Ui");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_Ui.v2");
    check_field_offset(lv, v3, 1, "BFu8ll_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_Ui, BFu8ll_Sf_Ui)
//============================================================================



static void Test_BFu8ll_Sf_Ul()
{
  {
    init_simple_test("BFu8ll_Sf_Ul");
    static STRUCT_IF_C BFu8ll_Sf_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu8ll_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_Ul");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_Ul.v2");
    check_field_offset(lv, v3, 1, "BFu8ll_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_Ul, BFu8ll_Sf_Ul)
//============================================================================



static void Test_BFu8ll_Sf_Us()
{
  {
    init_simple_test("BFu8ll_Sf_Us");
    static STRUCT_IF_C BFu8ll_Sf_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_Us");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_Us.v2");
    check_field_offset(lv, v3, 1, "BFu8ll_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_Us, BFu8ll_Sf_Us)
//============================================================================



static void Test_BFu8ll_Sf_Vp()
{
  {
    init_simple_test("BFu8ll_Sf_Vp");
    static STRUCT_IF_C BFu8ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8ll_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Sf_Vp");
    check_field_offset(lv, v2, 1, "BFu8ll_Sf_Vp.v2");
    check_field_offset(lv, v3, 1, "BFu8ll_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Sf_Vp, BFu8ll_Sf_Vp)
//============================================================================



static void Test_BFu8ll_Uc_Sf()
{
  {
    init_simple_test("BFu8ll_Uc_Sf");
    static STRUCT_IF_C BFu8ll_Uc_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8ll_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Uc_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu8ll_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Uc_Sf, BFu8ll_Uc_Sf)
//============================================================================



static void Test_BFu8ll_Ui_Sf()
{
  {
    init_simple_test("BFu8ll_Ui_Sf");
    static STRUCT_IF_C BFu8ll_Ui_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8ll_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Ui_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_Ui_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu8ll_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Ui_Sf, BFu8ll_Ui_Sf)
//============================================================================



static void Test_BFu8ll_Ul_Sf()
{
  {
    init_simple_test("BFu8ll_Ul_Sf");
    static STRUCT_IF_C BFu8ll_Ul_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu8ll_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Ul_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_Ul_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu8ll_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Ul_Sf, BFu8ll_Ul_Sf)
//============================================================================



static void Test_BFu8ll_Us_Sf()
{
  {
    init_simple_test("BFu8ll_Us_Sf");
    static STRUCT_IF_C BFu8ll_Us_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8ll_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Us_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_Us_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu8ll_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Us_Sf, BFu8ll_Us_Sf)
//============================================================================



static void Test_BFu8ll_Vp_Sf()
{
  {
    init_simple_test("BFu8ll_Vp_Sf");
    static STRUCT_IF_C BFu8ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8ll_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8ll_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Vp_Sf");
    check_field_offset(lv, v2, 1, "BFu8ll_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu8ll_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8ll_Vp_Sf, BFu8ll_Vp_Sf)
//============================================================================



static void Test_BFu8s_BFu15i_Sf()
{
  {
    init_simple_test("BFu8s_BFu15i_Sf");
    static STRUCT_IF_C BFu8s_BFu15i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8s_BFu15i_Sf");
    check_field_offset(lv, v3, 3, "BFu8s_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu15i_Sf, BFu8s_BFu15i_Sf)
//============================================================================



static void Test_BFu8s_BFu15ll_Sf()
{
  {
    init_simple_test("BFu8s_BFu15ll_Sf");
    static STRUCT_IF_C BFu8s_BFu15ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8s_BFu15ll_Sf");
    check_field_offset(lv, v3, 3, "BFu8s_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu15ll_Sf, BFu8s_BFu15ll_Sf)
//============================================================================



static void Test_BFu8s_BFu15s_Sf()
{
  {
    init_simple_test("BFu8s_BFu15s_Sf");
    static STRUCT_IF_C BFu8s_BFu15s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8s_BFu15s_Sf");
    check_field_offset(lv, v3, 3, "BFu8s_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu15s_Sf, BFu8s_BFu15s_Sf)
//============================================================================



static void Test_BFu8s_BFu16i_Sf()
{
  {
    init_simple_test("BFu8s_BFu16i_Sf");
    static STRUCT_IF_C BFu8s_BFu16i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8s_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "BFu8s_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu16i_Sf, BFu8s_BFu16i_Sf)
//============================================================================



static void Test_BFu8s_BFu16ll_Sf()
{
  {
    init_simple_test("BFu8s_BFu16ll_Sf");
    static STRUCT_IF_C BFu8s_BFu16ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8s_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "BFu8s_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu16ll_Sf, BFu8s_BFu16ll_Sf)
//============================================================================



static void Test_BFu8s_BFu16s_Sf()
{
  {
    init_simple_test("BFu8s_BFu16s_Sf");
    static STRUCT_IF_C BFu8s_BFu16s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8s_BFu16s_Sf");
    check_field_offset(lv, v3, 3, "BFu8s_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu16s_Sf, BFu8s_BFu16s_Sf)
//============================================================================



static void Test_BFu8s_BFu17i_Sf()
{
  {
    init_simple_test("BFu8s_BFu17i_Sf");
    static STRUCT_IF_C BFu8s_BFu17i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8s_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "BFu8s_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu17i_Sf, BFu8s_BFu17i_Sf)
//============================================================================



static void Test_BFu8s_BFu17ll_Sf()
{
  {
    init_simple_test("BFu8s_BFu17ll_Sf");
    static STRUCT_IF_C BFu8s_BFu17ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8s_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "BFu8s_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu17ll_Sf, BFu8s_BFu17ll_Sf)
//============================================================================



static void Test_BFu8s_BFu1c_Sf()
{
  {
    init_simple_test("BFu8s_BFu1c_Sf");
    static STRUCT_IF_C BFu8s_BFu1c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu1c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8s_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "BFu8s_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu1c_Sf, BFu8s_BFu1c_Sf)
//============================================================================



static void Test_BFu8s_BFu1i_Sf()
{
  {
    init_simple_test("BFu8s_BFu1i_Sf");
    static STRUCT_IF_C BFu8s_BFu1i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu1i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8s_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "BFu8s_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu1i_Sf, BFu8s_BFu1i_Sf)
//============================================================================



static void Test_BFu8s_BFu1ll_Sf()
{
  {
    init_simple_test("BFu8s_BFu1ll_Sf");
    static STRUCT_IF_C BFu8s_BFu1ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8s_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "BFu8s_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu1ll_Sf, BFu8s_BFu1ll_Sf)
//============================================================================



static void Test_BFu8s_BFu1s_Sf()
{
  {
    init_simple_test("BFu8s_BFu1s_Sf");
    static STRUCT_IF_C BFu8s_BFu1s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu1s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8s_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "BFu8s_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu1s_Sf, BFu8s_BFu1s_Sf)
//============================================================================



static void Test_BFu8s_BFu31i_Sf()
{
  {
    init_simple_test("BFu8s_BFu31i_Sf");
    static STRUCT_IF_C BFu8s_BFu31i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu8s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu8s_BFu31i_Sf");
    check_field_offset(lv, v3, 5, "BFu8s_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu31i_Sf, BFu8s_BFu31i_Sf)
//============================================================================



static void Test_BFu8s_BFu31ll_Sf()
{
  {
    init_simple_test("BFu8s_BFu31ll_Sf");
    static STRUCT_IF_C BFu8s_BFu31ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu8s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu8s_BFu31ll_Sf");
    check_field_offset(lv, v3, 5, "BFu8s_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu31ll_Sf, BFu8s_BFu31ll_Sf)
//============================================================================



static void Test_BFu8s_BFu32i_Sf()
{
  {
    init_simple_test("BFu8s_BFu32i_Sf");
    static STRUCT_IF_C BFu8s_BFu32i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu8s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu8s_BFu32i_Sf");
    check_field_offset(lv, v3, 5, "BFu8s_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu32i_Sf, BFu8s_BFu32i_Sf)
//============================================================================



static void Test_BFu8s_BFu32ll_Sf()
{
  {
    init_simple_test("BFu8s_BFu32ll_Sf");
    static STRUCT_IF_C BFu8s_BFu32ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu8s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu8s_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "BFu8s_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu32ll_Sf, BFu8s_BFu32ll_Sf)
//============================================================================



static void Test_BFu8s_BFu33_Sf()
{
  {
    init_simple_test("BFu8s_BFu33_Sf");
    static STRUCT_IF_C BFu8s_BFu33_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu8s_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8s_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8s_BFu33_Sf");
    check_field_offset(lv, v3, 6, "BFu8s_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu33_Sf, BFu8s_BFu33_Sf)
//============================================================================



static void Test_BFu8s_BFu7c_Sf()
{
  {
    init_simple_test("BFu8s_BFu7c_Sf");
    static STRUCT_IF_C BFu8s_BFu7c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8s_BFu7c_Sf");
    check_field_offset(lv, v3, 2, "BFu8s_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu7c_Sf, BFu8s_BFu7c_Sf)
//============================================================================



static void Test_BFu8s_BFu7i_Sf()
{
  {
    init_simple_test("BFu8s_BFu7i_Sf");
    static STRUCT_IF_C BFu8s_BFu7i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8s_BFu7i_Sf");
    check_field_offset(lv, v3, 2, "BFu8s_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu7i_Sf, BFu8s_BFu7i_Sf)
//============================================================================



static void Test_BFu8s_BFu7ll_Sf()
{
  {
    init_simple_test("BFu8s_BFu7ll_Sf");
    static STRUCT_IF_C BFu8s_BFu7ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8s_BFu7ll_Sf");
    check_field_offset(lv, v3, 2, "BFu8s_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu7ll_Sf, BFu8s_BFu7ll_Sf)
//============================================================================



static void Test_BFu8s_BFu7s_Sf()
{
  {
    init_simple_test("BFu8s_BFu7s_Sf");
    static STRUCT_IF_C BFu8s_BFu7s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8s_BFu7s_Sf");
    check_field_offset(lv, v3, 2, "BFu8s_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu7s_Sf, BFu8s_BFu7s_Sf)
//============================================================================



static void Test_BFu8s_BFu8c_Sf()
{
  {
    init_simple_test("BFu8s_BFu8c_Sf");
    static STRUCT_IF_C BFu8s_BFu8c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "BFu8s_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu8c_Sf, BFu8s_BFu8c_Sf)
//============================================================================



static void Test_BFu8s_BFu8i_Sf()
{
  {
    init_simple_test("BFu8s_BFu8i_Sf");
    static STRUCT_IF_C BFu8s_BFu8i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "BFu8s_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu8i_Sf, BFu8s_BFu8i_Sf)
//============================================================================



static void Test_BFu8s_BFu8ll_Sf()
{
  {
    init_simple_test("BFu8s_BFu8ll_Sf");
    static STRUCT_IF_C BFu8s_BFu8ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "BFu8s_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu8ll_Sf, BFu8s_BFu8ll_Sf)
//============================================================================



static void Test_BFu8s_BFu8s_Sf()
{
  {
    init_simple_test("BFu8s_BFu8s_Sf");
    static STRUCT_IF_C BFu8s_BFu8s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "BFu8s_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu8s_Sf, BFu8s_BFu8s_Sf)
//============================================================================



static void Test_BFu8s_BFu9i_Sf()
{
  {
    init_simple_test("BFu8s_BFu9i_Sf");
    static STRUCT_IF_C BFu8s_BFu9i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8s_BFu9i_Sf");
    check_field_offset(lv, v3, 3, "BFu8s_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu9i_Sf, BFu8s_BFu9i_Sf)
//============================================================================



static void Test_BFu8s_BFu9ll_Sf()
{
  {
    init_simple_test("BFu8s_BFu9ll_Sf");
    static STRUCT_IF_C BFu8s_BFu9ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8s_BFu9ll_Sf");
    check_field_offset(lv, v3, 3, "BFu8s_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu9ll_Sf, BFu8s_BFu9ll_Sf)
//============================================================================



static void Test_BFu8s_BFu9s_Sf()
{
  {
    init_simple_test("BFu8s_BFu9s_Sf");
    static STRUCT_IF_C BFu8s_BFu9s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8s_BFu9s_Sf");
    check_field_offset(lv, v3, 3, "BFu8s_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_BFu9s_Sf, BFu8s_BFu9s_Sf)
//============================================================================



static void Test_BFu8s_C_Sf()
{
  {
    init_simple_test("BFu8s_C_Sf");
    static STRUCT_IF_C BFu8s_C_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_C_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_C_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu8s_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_C_Sf, BFu8s_C_Sf)
//============================================================================



static void Test_BFu8s_D_Sf()
{
  {
    init_simple_test("BFu8s_D_Sf");
    static STRUCT_IF_C BFu8s_D_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu8s_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_D_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_D_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu8s_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_D_Sf, BFu8s_D_Sf)
//============================================================================



static void Test_BFu8s_F_Sf()
{
  {
    init_simple_test("BFu8s_F_Sf");
    static STRUCT_IF_C BFu8s_F_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_F_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_F_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu8s_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_F_Sf, BFu8s_F_Sf)
//============================================================================



static void Test_BFu8s_I_Sf()
{
  {
    init_simple_test("BFu8s_I_Sf");
    static STRUCT_IF_C BFu8s_I_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_I_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_I_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu8s_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_I_Sf, BFu8s_I_Sf)
//============================================================================



static void Test_BFu8s_Ip_Sf()
{
  {
    init_simple_test("BFu8s_Ip_Sf");
    static STRUCT_IF_C BFu8s_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8s_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Ip_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu8s_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Ip_Sf, BFu8s_Ip_Sf)
//============================================================================



static void Test_BFu8s_L_Sf()
{
  {
    init_simple_test("BFu8s_L_Sf");
    static STRUCT_IF_C BFu8s_L_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu8s_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_L_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_L_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu8s_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_L_Sf, BFu8s_L_Sf)
//============================================================================



static void Test_BFu8s_S_Sf()
{
  {
    init_simple_test("BFu8s_S_Sf");
    static STRUCT_IF_C BFu8s_S_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_S_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_S_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu8s_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_S_Sf, BFu8s_S_Sf)
//============================================================================



static void Test_BFu8s_Sf()
{
  {
    init_simple_test("BFu8s_Sf");
    static STRUCT_IF_C BFu8s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf, BFu8s_Sf)
//============================================================================



static void Test_BFu8s_Sf_BFu15i()
{
  {
    init_simple_test("BFu8s_Sf_BFu15i");
    static STRUCT_IF_C BFu8s_Sf_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu8s_Sf_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu8s_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu15i, BFu8s_Sf_BFu15i)
//============================================================================



static void Test_BFu8s_Sf_BFu15ll()
{
  {
    init_simple_test("BFu8s_Sf_BFu15ll");
    static STRUCT_IF_C BFu8s_Sf_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu8s_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu8s_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu15ll, BFu8s_Sf_BFu15ll)
//============================================================================



static void Test_BFu8s_Sf_BFu15s()
{
  {
    init_simple_test("BFu8s_Sf_BFu15s");
    static STRUCT_IF_C BFu8s_Sf_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "BFu8s_Sf_BFu15s");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "BFu8s_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu15s, BFu8s_Sf_BFu15s)
//============================================================================



static void Test_BFu8s_Sf_BFu16i()
{
  {
    init_simple_test("BFu8s_Sf_BFu16i");
    static STRUCT_IF_C BFu8s_Sf_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu8s_Sf_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu8s_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu16i, BFu8s_Sf_BFu16i)
//============================================================================



static void Test_BFu8s_Sf_BFu16ll()
{
  {
    init_simple_test("BFu8s_Sf_BFu16ll");
    static STRUCT_IF_C BFu8s_Sf_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu8s_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu8s_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu16ll, BFu8s_Sf_BFu16ll)
//============================================================================



static void Test_BFu8s_Sf_BFu16s()
{
  {
    init_simple_test("BFu8s_Sf_BFu16s");
    static STRUCT_IF_C BFu8s_Sf_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "BFu8s_Sf_BFu16s");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "BFu8s_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu16s, BFu8s_Sf_BFu16s)
//============================================================================



static void Test_BFu8s_Sf_BFu17i()
{
  {
    init_simple_test("BFu8s_Sf_BFu17i");
    static STRUCT_IF_C BFu8s_Sf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu8s_Sf_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu8s_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu17i, BFu8s_Sf_BFu17i)
//============================================================================



static void Test_BFu8s_Sf_BFu17ll()
{
  {
    init_simple_test("BFu8s_Sf_BFu17ll");
    static STRUCT_IF_C BFu8s_Sf_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "BFu8s_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "BFu8s_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu17ll, BFu8s_Sf_BFu17ll)
//============================================================================



static void Test_BFu8s_Sf_BFu1c()
{
  {
    init_simple_test("BFu8s_Sf_BFu1c");
    static STRUCT_IF_C BFu8s_Sf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8s_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu1c, BFu8s_Sf_BFu1c)
//============================================================================



static void Test_BFu8s_Sf_BFu1i()
{
  {
    init_simple_test("BFu8s_Sf_BFu1i");
    static STRUCT_IF_C BFu8s_Sf_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8s_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu1i, BFu8s_Sf_BFu1i)
//============================================================================



static void Test_BFu8s_Sf_BFu1ll()
{
  {
    init_simple_test("BFu8s_Sf_BFu1ll");
    static STRUCT_IF_C BFu8s_Sf_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8s_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu1ll, BFu8s_Sf_BFu1ll)
//============================================================================



static void Test_BFu8s_Sf_BFu1s()
{
  {
    init_simple_test("BFu8s_Sf_BFu1s");
    static STRUCT_IF_C BFu8s_Sf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "BFu8s_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu1s, BFu8s_Sf_BFu1s)
//============================================================================



static void Test_BFu8s_Sf_BFu31i()
{
  {
    init_simple_test("BFu8s_Sf_BFu31i");
    static STRUCT_IF_C BFu8s_Sf_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu8s_Sf_BFu31i");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu8s_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu31i, BFu8s_Sf_BFu31i)
//============================================================================



static void Test_BFu8s_Sf_BFu31ll()
{
  {
    init_simple_test("BFu8s_Sf_BFu31ll");
    static STRUCT_IF_C BFu8s_Sf_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "BFu8s_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "BFu8s_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu31ll, BFu8s_Sf_BFu31ll)
//============================================================================



static void Test_BFu8s_Sf_BFu32i()
{
  {
    init_simple_test("BFu8s_Sf_BFu32i");
    static STRUCT_IF_C BFu8s_Sf_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu8s_Sf_BFu32i");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu8s_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu32i, BFu8s_Sf_BFu32i)
//============================================================================



static void Test_BFu8s_Sf_BFu32ll()
{
  {
    init_simple_test("BFu8s_Sf_BFu32ll");
    static STRUCT_IF_C BFu8s_Sf_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "BFu8s_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "BFu8s_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu32ll, BFu8s_Sf_BFu32ll)
//============================================================================



static void Test_BFu8s_Sf_BFu33()
{
  {
    init_simple_test("BFu8s_Sf_BFu33");
    static STRUCT_IF_C BFu8s_Sf_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(BFu8s_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu33");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 1, 0, 33, 1, "BFu8s_Sf_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, hide_ull(1LL<<32), "BFu8s_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu33, BFu8s_Sf_BFu33)
//============================================================================



static void Test_BFu8s_Sf_BFu7c()
{
  {
    init_simple_test("BFu8s_Sf_BFu7c");
    static STRUCT_IF_C BFu8s_Sf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8s_Sf_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8s_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu7c, BFu8s_Sf_BFu7c)
//============================================================================



static void Test_BFu8s_Sf_BFu7i()
{
  {
    init_simple_test("BFu8s_Sf_BFu7i");
    static STRUCT_IF_C BFu8s_Sf_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8s_Sf_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8s_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu7i, BFu8s_Sf_BFu7i)
//============================================================================



static void Test_BFu8s_Sf_BFu7ll()
{
  {
    init_simple_test("BFu8s_Sf_BFu7ll");
    static STRUCT_IF_C BFu8s_Sf_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8s_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8s_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu7ll, BFu8s_Sf_BFu7ll)
//============================================================================



static void Test_BFu8s_Sf_BFu7s()
{
  {
    init_simple_test("BFu8s_Sf_BFu7s");
    static STRUCT_IF_C BFu8s_Sf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "BFu8s_Sf_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "BFu8s_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu7s, BFu8s_Sf_BFu7s)
//============================================================================



static void Test_BFu8s_Sf_BFu8c()
{
  {
    init_simple_test("BFu8s_Sf_BFu8c");
    static STRUCT_IF_C BFu8s_Sf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8s_Sf_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu8c, BFu8s_Sf_BFu8c)
//============================================================================



static void Test_BFu8s_Sf_BFu8i()
{
  {
    init_simple_test("BFu8s_Sf_BFu8i");
    static STRUCT_IF_C BFu8s_Sf_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8s_Sf_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu8i, BFu8s_Sf_BFu8i)
//============================================================================



static void Test_BFu8s_Sf_BFu8ll()
{
  {
    init_simple_test("BFu8s_Sf_BFu8ll");
    static STRUCT_IF_C BFu8s_Sf_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8s_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu8ll, BFu8s_Sf_BFu8ll)
//============================================================================



static void Test_BFu8s_Sf_BFu8s()
{
  {
    init_simple_test("BFu8s_Sf_BFu8s");
    static STRUCT_IF_C BFu8s_Sf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "BFu8s_Sf_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu8s, BFu8s_Sf_BFu8s)
//============================================================================



static void Test_BFu8s_Sf_BFu9i()
{
  {
    init_simple_test("BFu8s_Sf_BFu9i");
    static STRUCT_IF_C BFu8s_Sf_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu8s_Sf_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu8s_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu9i, BFu8s_Sf_BFu9i)
//============================================================================



static void Test_BFu8s_Sf_BFu9ll()
{
  {
    init_simple_test("BFu8s_Sf_BFu9ll");
    static STRUCT_IF_C BFu8s_Sf_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu8s_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu8s_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu9ll, BFu8s_Sf_BFu9ll)
//============================================================================



static void Test_BFu8s_Sf_BFu9s()
{
  {
    init_simple_test("BFu8s_Sf_BFu9s");
    static STRUCT_IF_C BFu8s_Sf_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "BFu8s_Sf_BFu9s");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "BFu8s_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_BFu9s, BFu8s_Sf_BFu9s)
//============================================================================



static void Test_BFu8s_Sf_C()
{
  {
    init_simple_test("BFu8s_Sf_C");
    static STRUCT_IF_C BFu8s_Sf_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_C");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_C.v2");
    check_field_offset(lv, v3, 1, "BFu8s_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_C, BFu8s_Sf_C)
//============================================================================



static void Test_BFu8s_Sf_D()
{
  {
    init_simple_test("BFu8s_Sf_D");
    static STRUCT_IF_C BFu8s_Sf_D lv;
    check2(sizeof(lv), 9, "sizeof(BFu8s_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_D");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_D.v2");
    check_field_offset(lv, v3, 1, "BFu8s_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_D, BFu8s_Sf_D)
//============================================================================



static void Test_BFu8s_Sf_F()
{
  {
    init_simple_test("BFu8s_Sf_F");
    static STRUCT_IF_C BFu8s_Sf_F lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_F");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_F.v2");
    check_field_offset(lv, v3, 1, "BFu8s_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_F, BFu8s_Sf_F)
//============================================================================



static void Test_BFu8s_Sf_I()
{
  {
    init_simple_test("BFu8s_Sf_I");
    static STRUCT_IF_C BFu8s_Sf_I lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_I");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_I.v2");
    check_field_offset(lv, v3, 1, "BFu8s_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_I, BFu8s_Sf_I)
//============================================================================



static void Test_BFu8s_Sf_Ip()
{
  {
    init_simple_test("BFu8s_Sf_Ip");
    static STRUCT_IF_C BFu8s_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8s_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_Ip");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_Ip.v2");
    check_field_offset(lv, v3, 1, "BFu8s_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_Ip, BFu8s_Sf_Ip)
//============================================================================



static void Test_BFu8s_Sf_L()
{
  {
    init_simple_test("BFu8s_Sf_L");
    static STRUCT_IF_C BFu8s_Sf_L lv;
    check2(sizeof(lv), 9, "sizeof(BFu8s_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_L");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_L.v2");
    check_field_offset(lv, v3, 1, "BFu8s_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_L, BFu8s_Sf_L)
//============================================================================



static void Test_BFu8s_Sf_S()
{
  {
    init_simple_test("BFu8s_Sf_S");
    static STRUCT_IF_C BFu8s_Sf_S lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_S");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_S.v2");
    check_field_offset(lv, v3, 1, "BFu8s_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_S, BFu8s_Sf_S)
//============================================================================



static void Test_BFu8s_Sf_Sf()
{
  {
    init_simple_test("BFu8s_Sf_Sf");
    static STRUCT_IF_C BFu8s_Sf_Sf lv;
    check2(sizeof(lv), 1, "sizeof(BFu8s_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_Sf.v2");
    check_field_offset(lv, v3, 1, "BFu8s_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_Sf, BFu8s_Sf_Sf)
//============================================================================



static void Test_BFu8s_Sf_Uc()
{
  {
    init_simple_test("BFu8s_Sf_Uc");
    static STRUCT_IF_C BFu8s_Sf_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_Uc");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_Uc.v2");
    check_field_offset(lv, v3, 1, "BFu8s_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_Uc, BFu8s_Sf_Uc)
//============================================================================



static void Test_BFu8s_Sf_Ui()
{
  {
    init_simple_test("BFu8s_Sf_Ui");
    static STRUCT_IF_C BFu8s_Sf_Ui lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_Ui");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_Ui.v2");
    check_field_offset(lv, v3, 1, "BFu8s_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_Ui, BFu8s_Sf_Ui)
//============================================================================



static void Test_BFu8s_Sf_Ul()
{
  {
    init_simple_test("BFu8s_Sf_Ul");
    static STRUCT_IF_C BFu8s_Sf_Ul lv;
    check2(sizeof(lv), 9, "sizeof(BFu8s_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_Ul");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_Ul.v2");
    check_field_offset(lv, v3, 1, "BFu8s_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_Ul, BFu8s_Sf_Ul)
//============================================================================



static void Test_BFu8s_Sf_Us()
{
  {
    init_simple_test("BFu8s_Sf_Us");
    static STRUCT_IF_C BFu8s_Sf_Us lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_Us");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_Us.v2");
    check_field_offset(lv, v3, 1, "BFu8s_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_Us, BFu8s_Sf_Us)
//============================================================================



static void Test_BFu8s_Sf_Vp()
{
  {
    init_simple_test("BFu8s_Sf_Vp");
    static STRUCT_IF_C BFu8s_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8s_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Sf_Vp");
    check_field_offset(lv, v2, 1, "BFu8s_Sf_Vp.v2");
    check_field_offset(lv, v3, 1, "BFu8s_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Sf_Vp, BFu8s_Sf_Vp)
//============================================================================



static void Test_BFu8s_Uc_Sf()
{
  {
    init_simple_test("BFu8s_Uc_Sf");
    static STRUCT_IF_C BFu8s_Uc_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Uc_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu8s_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Uc_Sf, BFu8s_Uc_Sf)
//============================================================================



static void Test_BFu8s_Ui_Sf()
{
  {
    init_simple_test("BFu8s_Ui_Sf");
    static STRUCT_IF_C BFu8s_Ui_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu8s_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Ui_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_Ui_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu8s_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Ui_Sf, BFu8s_Ui_Sf)
//============================================================================



static void Test_BFu8s_Ul_Sf()
{
  {
    init_simple_test("BFu8s_Ul_Sf");
    static STRUCT_IF_C BFu8s_Ul_Sf lv;
    check2(sizeof(lv), 9, "sizeof(BFu8s_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Ul_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_Ul_Sf.v2");
    check_field_offset(lv, v3, 9, "BFu8s_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Ul_Sf, BFu8s_Ul_Sf)
//============================================================================



static void Test_BFu8s_Us_Sf()
{
  {
    init_simple_test("BFu8s_Us_Sf");
    static STRUCT_IF_C BFu8s_Us_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu8s_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Us_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_Us_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu8s_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Us_Sf, BFu8s_Us_Sf)
//============================================================================



static void Test_BFu8s_Vp_Sf()
{
  {
    init_simple_test("BFu8s_Vp_Sf");
    static STRUCT_IF_C BFu8s_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu8s_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8s_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Vp_Sf");
    check_field_offset(lv, v2, 1, "BFu8s_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "BFu8s_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu8s_Vp_Sf, BFu8s_Vp_Sf)
//============================================================================



static void Test_BFu9i_BFu15i_Sf()
{
  {
    init_simple_test("BFu9i_BFu15i_Sf");
    static STRUCT_IF_C BFu9i_BFu15i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu9i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu9i_BFu15i_Sf");
    check_field_offset(lv, v3, 3, "BFu9i_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu15i_Sf, BFu9i_BFu15i_Sf)
//============================================================================



static void Test_BFu9i_BFu15ll_Sf()
{
  {
    init_simple_test("BFu9i_BFu15ll_Sf");
    static STRUCT_IF_C BFu9i_BFu15ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu9i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu9i_BFu15ll_Sf");
    check_field_offset(lv, v3, 3, "BFu9i_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu15ll_Sf, BFu9i_BFu15ll_Sf)
//============================================================================



static void Test_BFu9i_BFu15s_Sf()
{
  {
    init_simple_test("BFu9i_BFu15s_Sf");
    static STRUCT_IF_C BFu9i_BFu15s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu9i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu9i_BFu15s_Sf");
    check_field_offset(lv, v3, 3, "BFu9i_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu15s_Sf, BFu9i_BFu15s_Sf)
//============================================================================



static void Test_BFu9i_BFu16i_Sf()
{
  {
    init_simple_test("BFu9i_BFu16i_Sf");
    static STRUCT_IF_C BFu9i_BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu9i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu9i_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "BFu9i_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu16i_Sf, BFu9i_BFu16i_Sf)
//============================================================================



static void Test_BFu9i_BFu16ll_Sf()
{
  {
    init_simple_test("BFu9i_BFu16ll_Sf");
    static STRUCT_IF_C BFu9i_BFu16ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu9i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu9i_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "BFu9i_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu16ll_Sf, BFu9i_BFu16ll_Sf)
//============================================================================



static void Test_BFu9i_BFu16s_Sf()
{
  {
    init_simple_test("BFu9i_BFu16s_Sf");
    static STRUCT_IF_C BFu9i_BFu16s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu9i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu9i_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "BFu9i_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu16s_Sf, BFu9i_BFu16s_Sf)
//============================================================================



static void Test_BFu9i_BFu17i_Sf()
{
  {
    init_simple_test("BFu9i_BFu17i_Sf");
    static STRUCT_IF_C BFu9i_BFu17i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu9i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu9i_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "BFu9i_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu17i_Sf, BFu9i_BFu17i_Sf)
//============================================================================



static void Test_BFu9i_BFu17ll_Sf()
{
  {
    init_simple_test("BFu9i_BFu17ll_Sf");
    static STRUCT_IF_C BFu9i_BFu17ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu9i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu9i_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "BFu9i_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu17ll_Sf, BFu9i_BFu17ll_Sf)
//============================================================================



static void Test_BFu9i_BFu1c_Sf()
{
  {
    init_simple_test("BFu9i_BFu1c_Sf");
    static STRUCT_IF_C BFu9i_BFu1c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9i_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9i_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "BFu9i_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu1c_Sf, BFu9i_BFu1c_Sf)
//============================================================================



static void Test_BFu9i_BFu1i_Sf()
{
  {
    init_simple_test("BFu9i_BFu1i_Sf");
    static STRUCT_IF_C BFu9i_BFu1i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9i_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9i_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "BFu9i_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu1i_Sf, BFu9i_BFu1i_Sf)
//============================================================================



static void Test_BFu9i_BFu1ll_Sf()
{
  {
    init_simple_test("BFu9i_BFu1ll_Sf");
    static STRUCT_IF_C BFu9i_BFu1ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9i_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9i_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "BFu9i_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu1ll_Sf, BFu9i_BFu1ll_Sf)
//============================================================================



static void Test_BFu9i_BFu1s_Sf()
{
  {
    init_simple_test("BFu9i_BFu1s_Sf");
    static STRUCT_IF_C BFu9i_BFu1s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9i_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9i_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "BFu9i_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu1s_Sf, BFu9i_BFu1s_Sf)
//============================================================================



static void Test_BFu9i_BFu31i_Sf()
{
  {
    init_simple_test("BFu9i_BFu31i_Sf");
    static STRUCT_IF_C BFu9i_BFu31i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu9i_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu9i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu9i_BFu31i_Sf");
    check_field_offset(lv, v3, 5, "BFu9i_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu31i_Sf, BFu9i_BFu31i_Sf)
//============================================================================



static void Test_BFu9i_BFu31ll_Sf()
{
  {
    init_simple_test("BFu9i_BFu31ll_Sf");
    static STRUCT_IF_C BFu9i_BFu31ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(BFu9i_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu9i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu9i_BFu31ll_Sf");
    check_field_offset(lv, v3, 5, "BFu9i_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu31ll_Sf, BFu9i_BFu31ll_Sf)
//============================================================================



static void Test_BFu9i_BFu32i_Sf()
{
  {
    init_simple_test("BFu9i_BFu32i_Sf");
    static STRUCT_IF_C BFu9i_BFu32i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu9i_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu9i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu9i_BFu32i_Sf");
    check_field_offset(lv, v3, 6, "BFu9i_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu32i_Sf, BFu9i_BFu32i_Sf)
//============================================================================



static void Test_BFu9i_BFu32ll_Sf()
{
  {
    init_simple_test("BFu9i_BFu32ll_Sf");
    static STRUCT_IF_C BFu9i_BFu32ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu9i_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu9i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu9i_BFu32ll_Sf");
    check_field_offset(lv, v3, 6, "BFu9i_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu32ll_Sf, BFu9i_BFu32ll_Sf)
//============================================================================



static void Test_BFu9i_BFu33_Sf()
{
  {
    init_simple_test("BFu9i_BFu33_Sf");
    static STRUCT_IF_C BFu9i_BFu33_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu9i_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "BFu9i_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "BFu9i_BFu33_Sf");
    check_field_offset(lv, v3, 6, "BFu9i_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu33_Sf, BFu9i_BFu33_Sf)
//============================================================================



static void Test_BFu9i_BFu7c_Sf()
{
  {
    init_simple_test("BFu9i_BFu7c_Sf");
    static STRUCT_IF_C BFu9i_BFu7c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9i_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9i_BFu7c_Sf");
    check_field_offset(lv, v3, 2, "BFu9i_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu7c_Sf, BFu9i_BFu7c_Sf)
//============================================================================



static void Test_BFu9i_BFu7i_Sf()
{
  {
    init_simple_test("BFu9i_BFu7i_Sf");
    static STRUCT_IF_C BFu9i_BFu7i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9i_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9i_BFu7i_Sf");
    check_field_offset(lv, v3, 2, "BFu9i_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu7i_Sf, BFu9i_BFu7i_Sf)
//============================================================================



static void Test_BFu9i_BFu7ll_Sf()
{
  {
    init_simple_test("BFu9i_BFu7ll_Sf");
    static STRUCT_IF_C BFu9i_BFu7ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9i_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9i_BFu7ll_Sf");
    check_field_offset(lv, v3, 2, "BFu9i_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu7ll_Sf, BFu9i_BFu7ll_Sf)
//============================================================================



static void Test_BFu9i_BFu7s_Sf()
{
  {
    init_simple_test("BFu9i_BFu7s_Sf");
    static STRUCT_IF_C BFu9i_BFu7s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9i_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9i_BFu7s_Sf");
    check_field_offset(lv, v3, 2, "BFu9i_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu7s_Sf, BFu9i_BFu7s_Sf)
//============================================================================



static void Test_BFu9i_BFu8c_Sf()
{
  {
    init_simple_test("BFu9i_BFu8c_Sf");
    static STRUCT_IF_C BFu9i_BFu8c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu9i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu9i_BFu8c_Sf");
    check_field_offset(lv, v3, 3, "BFu9i_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu8c_Sf, BFu9i_BFu8c_Sf)
//============================================================================



static void Test_BFu9i_BFu8i_Sf()
{
  {
    init_simple_test("BFu9i_BFu8i_Sf");
    static STRUCT_IF_C BFu9i_BFu8i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu9i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu9i_BFu8i_Sf");
    check_field_offset(lv, v3, 3, "BFu9i_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu8i_Sf, BFu9i_BFu8i_Sf)
//============================================================================



static void Test_BFu9i_BFu8ll_Sf()
{
  {
    init_simple_test("BFu9i_BFu8ll_Sf");
    static STRUCT_IF_C BFu9i_BFu8ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu9i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu9i_BFu8ll_Sf");
    check_field_offset(lv, v3, 3, "BFu9i_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu8ll_Sf, BFu9i_BFu8ll_Sf)
//============================================================================



static void Test_BFu9i_BFu8s_Sf()
{
  {
    init_simple_test("BFu9i_BFu8s_Sf");
    static STRUCT_IF_C BFu9i_BFu8s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu9i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu9i_BFu8s_Sf");
    check_field_offset(lv, v3, 3, "BFu9i_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu8s_Sf, BFu9i_BFu8s_Sf)
//============================================================================



static void Test_BFu9i_BFu9i_Sf()
{
  {
    init_simple_test("BFu9i_BFu9i_Sf");
    static STRUCT_IF_C BFu9i_BFu9i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu9i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu9i_BFu9i_Sf");
    check_field_offset(lv, v3, 3, "BFu9i_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu9i_Sf, BFu9i_BFu9i_Sf)
//============================================================================



static void Test_BFu9i_BFu9ll_Sf()
{
  {
    init_simple_test("BFu9i_BFu9ll_Sf");
    static STRUCT_IF_C BFu9i_BFu9ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu9i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu9i_BFu9ll_Sf");
    check_field_offset(lv, v3, 3, "BFu9i_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu9ll_Sf, BFu9i_BFu9ll_Sf)
//============================================================================



static void Test_BFu9i_BFu9s_Sf()
{
  {
    init_simple_test("BFu9i_BFu9s_Sf");
    static STRUCT_IF_C BFu9i_BFu9s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu9i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu9i_BFu9s_Sf");
    check_field_offset(lv, v3, 3, "BFu9i_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_BFu9s_Sf, BFu9i_BFu9s_Sf)
//============================================================================



static void Test_BFu9i_C_Sf()
{
  {
    init_simple_test("BFu9i_C_Sf");
    static STRUCT_IF_C BFu9i_C_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_C_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_C_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu9i_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_C_Sf, BFu9i_C_Sf)
//============================================================================



static void Test_BFu9i_D_Sf()
{
  {
    init_simple_test("BFu9i_D_Sf");
    static STRUCT_IF_C BFu9i_D_Sf lv;
    check2(sizeof(lv), 10, "sizeof(BFu9i_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_D_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_D_Sf.v2");
    check_field_offset(lv, v3, 10, "BFu9i_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_D_Sf, BFu9i_D_Sf)
//============================================================================



static void Test_BFu9i_F_Sf()
{
  {
    init_simple_test("BFu9i_F_Sf");
    static STRUCT_IF_C BFu9i_F_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu9i_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_F_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_F_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu9i_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_F_Sf, BFu9i_F_Sf)
//============================================================================



static void Test_BFu9i_I_Sf()
{
  {
    init_simple_test("BFu9i_I_Sf");
    static STRUCT_IF_C BFu9i_I_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu9i_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_I_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_I_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu9i_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_I_Sf, BFu9i_I_Sf)
//============================================================================



static void Test_BFu9i_Ip_Sf()
{
  {
    init_simple_test("BFu9i_Ip_Sf");
    static STRUCT_IF_C BFu9i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu9i_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Ip_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9i_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Ip_Sf, BFu9i_Ip_Sf)
//============================================================================



static void Test_BFu9i_L_Sf()
{
  {
    init_simple_test("BFu9i_L_Sf");
    static STRUCT_IF_C BFu9i_L_Sf lv;
    check2(sizeof(lv), 10, "sizeof(BFu9i_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_L_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_L_Sf.v2");
    check_field_offset(lv, v3, 10, "BFu9i_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_L_Sf, BFu9i_L_Sf)
//============================================================================



static void Test_BFu9i_S_Sf()
{
  {
    init_simple_test("BFu9i_S_Sf");
    static STRUCT_IF_C BFu9i_S_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_S_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_S_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu9i_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_S_Sf, BFu9i_S_Sf)
//============================================================================



static void Test_BFu9i_Sf()
{
  {
    init_simple_test("BFu9i_Sf");
    static STRUCT_IF_C BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf, BFu9i_Sf)
//============================================================================



static void Test_BFu9i_Sf_BFu15i()
{
  {
    init_simple_test("BFu9i_Sf_BFu15i");
    static STRUCT_IF_C BFu9i_Sf_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu15i");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu9i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu9i_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu15i, BFu9i_Sf_BFu15i)
//============================================================================



static void Test_BFu9i_Sf_BFu15ll()
{
  {
    init_simple_test("BFu9i_Sf_BFu15ll");
    static STRUCT_IF_C BFu9i_Sf_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu9i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu9i_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu15ll, BFu9i_Sf_BFu15ll)
//============================================================================



static void Test_BFu9i_Sf_BFu15s()
{
  {
    init_simple_test("BFu9i_Sf_BFu15s");
    static STRUCT_IF_C BFu9i_Sf_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu15s");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu9i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu9i_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu15s, BFu9i_Sf_BFu15s)
//============================================================================



static void Test_BFu9i_Sf_BFu16i()
{
  {
    init_simple_test("BFu9i_Sf_BFu16i");
    static STRUCT_IF_C BFu9i_Sf_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu16i");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu9i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu9i_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu16i, BFu9i_Sf_BFu16i)
//============================================================================



static void Test_BFu9i_Sf_BFu16ll()
{
  {
    init_simple_test("BFu9i_Sf_BFu16ll");
    static STRUCT_IF_C BFu9i_Sf_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu9i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu9i_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu16ll, BFu9i_Sf_BFu16ll)
//============================================================================



static void Test_BFu9i_Sf_BFu16s()
{
  {
    init_simple_test("BFu9i_Sf_BFu16s");
    static STRUCT_IF_C BFu9i_Sf_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu16s");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu9i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu9i_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu16s, BFu9i_Sf_BFu16s)
//============================================================================



static void Test_BFu9i_Sf_BFu17i()
{
  {
    init_simple_test("BFu9i_Sf_BFu17i");
    static STRUCT_IF_C BFu9i_Sf_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(BFu9i_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu17i");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu9i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu9i_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu17i, BFu9i_Sf_BFu17i)
//============================================================================



static void Test_BFu9i_Sf_BFu17ll()
{
  {
    init_simple_test("BFu9i_Sf_BFu17ll");
    static STRUCT_IF_C BFu9i_Sf_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(BFu9i_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu9i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu9i_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu17ll, BFu9i_Sf_BFu17ll)
//============================================================================



static void Test_BFu9i_Sf_BFu1c()
{
  {
    init_simple_test("BFu9i_Sf_BFu1c");
    static STRUCT_IF_C BFu9i_Sf_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu1c");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu9i_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu1c, BFu9i_Sf_BFu1c)
//============================================================================



static void Test_BFu9i_Sf_BFu1i()
{
  {
    init_simple_test("BFu9i_Sf_BFu1i");
    static STRUCT_IF_C BFu9i_Sf_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu1i");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu9i_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu1i, BFu9i_Sf_BFu1i)
//============================================================================



static void Test_BFu9i_Sf_BFu1ll()
{
  {
    init_simple_test("BFu9i_Sf_BFu1ll");
    static STRUCT_IF_C BFu9i_Sf_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu9i_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu1ll, BFu9i_Sf_BFu1ll)
//============================================================================



static void Test_BFu9i_Sf_BFu1s()
{
  {
    init_simple_test("BFu9i_Sf_BFu1s");
    static STRUCT_IF_C BFu9i_Sf_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu1s");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu9i_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu1s, BFu9i_Sf_BFu1s)
//============================================================================



static void Test_BFu9i_Sf_BFu31i()
{
  {
    init_simple_test("BFu9i_Sf_BFu31i");
    static STRUCT_IF_C BFu9i_Sf_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(BFu9i_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu31i");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu9i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu9i_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu31i, BFu9i_Sf_BFu31i)
//============================================================================



static void Test_BFu9i_Sf_BFu31ll()
{
  {
    init_simple_test("BFu9i_Sf_BFu31ll");
    static STRUCT_IF_C BFu9i_Sf_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu9i_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu9i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu9i_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu31ll, BFu9i_Sf_BFu31ll)
//============================================================================



static void Test_BFu9i_Sf_BFu32i()
{
  {
    init_simple_test("BFu9i_Sf_BFu32i");
    static STRUCT_IF_C BFu9i_Sf_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(BFu9i_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu32i");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu9i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu9i_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu32i, BFu9i_Sf_BFu32i)
//============================================================================



static void Test_BFu9i_Sf_BFu32ll()
{
  {
    init_simple_test("BFu9i_Sf_BFu32ll");
    static STRUCT_IF_C BFu9i_Sf_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(BFu9i_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu9i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu9i_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu32ll, BFu9i_Sf_BFu32ll)
//============================================================================



static void Test_BFu9i_Sf_BFu33()
{
  {
    init_simple_test("BFu9i_Sf_BFu33");
    static STRUCT_IF_C BFu9i_Sf_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(BFu9i_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu33");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu9i_Sf_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu9i_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu33, BFu9i_Sf_BFu33)
//============================================================================



static void Test_BFu9i_Sf_BFu7c()
{
  {
    init_simple_test("BFu9i_Sf_BFu7c");
    static STRUCT_IF_C BFu9i_Sf_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu7c");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu9i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu9i_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu7c, BFu9i_Sf_BFu7c)
//============================================================================



static void Test_BFu9i_Sf_BFu7i()
{
  {
    init_simple_test("BFu9i_Sf_BFu7i");
    static STRUCT_IF_C BFu9i_Sf_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu7i");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu9i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu9i_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu7i, BFu9i_Sf_BFu7i)
//============================================================================



static void Test_BFu9i_Sf_BFu7ll()
{
  {
    init_simple_test("BFu9i_Sf_BFu7ll");
    static STRUCT_IF_C BFu9i_Sf_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu9i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu9i_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu7ll, BFu9i_Sf_BFu7ll)
//============================================================================



static void Test_BFu9i_Sf_BFu7s()
{
  {
    init_simple_test("BFu9i_Sf_BFu7s");
    static STRUCT_IF_C BFu9i_Sf_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu7s");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu9i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu9i_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu7s, BFu9i_Sf_BFu7s)
//============================================================================



static void Test_BFu9i_Sf_BFu8c()
{
  {
    init_simple_test("BFu9i_Sf_BFu8c");
    static STRUCT_IF_C BFu9i_Sf_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu8c");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu9i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu9i_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu8c, BFu9i_Sf_BFu8c)
//============================================================================



static void Test_BFu9i_Sf_BFu8i()
{
  {
    init_simple_test("BFu9i_Sf_BFu8i");
    static STRUCT_IF_C BFu9i_Sf_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu8i");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu9i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu9i_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu8i, BFu9i_Sf_BFu8i)
//============================================================================



static void Test_BFu9i_Sf_BFu8ll()
{
  {
    init_simple_test("BFu9i_Sf_BFu8ll");
    static STRUCT_IF_C BFu9i_Sf_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu9i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu9i_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu8ll, BFu9i_Sf_BFu8ll)
//============================================================================



static void Test_BFu9i_Sf_BFu8s()
{
  {
    init_simple_test("BFu9i_Sf_BFu8s");
    static STRUCT_IF_C BFu9i_Sf_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu8s");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu9i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu9i_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu8s, BFu9i_Sf_BFu8s)
//============================================================================



static void Test_BFu9i_Sf_BFu9i()
{
  {
    init_simple_test("BFu9i_Sf_BFu9i");
    static STRUCT_IF_C BFu9i_Sf_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu9i");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu9i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu9i, BFu9i_Sf_BFu9i)
//============================================================================



static void Test_BFu9i_Sf_BFu9ll()
{
  {
    init_simple_test("BFu9i_Sf_BFu9ll");
    static STRUCT_IF_C BFu9i_Sf_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu9i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu9ll, BFu9i_Sf_BFu9ll)
//============================================================================



static void Test_BFu9i_Sf_BFu9s()
{
  {
    init_simple_test("BFu9i_Sf_BFu9s");
    static STRUCT_IF_C BFu9i_Sf_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu9s");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu9i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_BFu9s, BFu9i_Sf_BFu9s)
//============================================================================



static void Test_BFu9i_Sf_C()
{
  {
    init_simple_test("BFu9i_Sf_C");
    static STRUCT_IF_C BFu9i_Sf_C lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_C");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_C.v2");
    check_field_offset(lv, v3, 2, "BFu9i_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_C, BFu9i_Sf_C)
//============================================================================



static void Test_BFu9i_Sf_D()
{
  {
    init_simple_test("BFu9i_Sf_D");
    static STRUCT_IF_C BFu9i_Sf_D lv;
    check2(sizeof(lv), 10, "sizeof(BFu9i_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_D");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_D.v2");
    check_field_offset(lv, v3, 2, "BFu9i_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_D, BFu9i_Sf_D)
//============================================================================



static void Test_BFu9i_Sf_F()
{
  {
    init_simple_test("BFu9i_Sf_F");
    static STRUCT_IF_C BFu9i_Sf_F lv;
    check2(sizeof(lv), 6, "sizeof(BFu9i_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_F");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_F.v2");
    check_field_offset(lv, v3, 2, "BFu9i_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_F, BFu9i_Sf_F)
//============================================================================



static void Test_BFu9i_Sf_I()
{
  {
    init_simple_test("BFu9i_Sf_I");
    static STRUCT_IF_C BFu9i_Sf_I lv;
    check2(sizeof(lv), 6, "sizeof(BFu9i_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_I");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_I.v2");
    check_field_offset(lv, v3, 2, "BFu9i_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_I, BFu9i_Sf_I)
//============================================================================



static void Test_BFu9i_Sf_Ip()
{
  {
    init_simple_test("BFu9i_Sf_Ip");
    static STRUCT_IF_C BFu9i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu9i_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_Ip");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_Ip.v2");
    check_field_offset(lv, v3, 2, "BFu9i_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_Ip, BFu9i_Sf_Ip)
//============================================================================



static void Test_BFu9i_Sf_L()
{
  {
    init_simple_test("BFu9i_Sf_L");
    static STRUCT_IF_C BFu9i_Sf_L lv;
    check2(sizeof(lv), 10, "sizeof(BFu9i_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_L");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_L.v2");
    check_field_offset(lv, v3, 2, "BFu9i_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_L, BFu9i_Sf_L)
//============================================================================



static void Test_BFu9i_Sf_S()
{
  {
    init_simple_test("BFu9i_Sf_S");
    static STRUCT_IF_C BFu9i_Sf_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_S");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_S.v2");
    check_field_offset(lv, v3, 2, "BFu9i_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_S, BFu9i_Sf_S)
//============================================================================



static void Test_BFu9i_Sf_Sf()
{
  {
    init_simple_test("BFu9i_Sf_Sf");
    static STRUCT_IF_C BFu9i_Sf_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9i_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu9i_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_Sf, BFu9i_Sf_Sf)
//============================================================================



static void Test_BFu9i_Sf_Uc()
{
  {
    init_simple_test("BFu9i_Sf_Uc");
    static STRUCT_IF_C BFu9i_Sf_Uc lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_Uc");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu9i_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_Uc, BFu9i_Sf_Uc)
//============================================================================



static void Test_BFu9i_Sf_Ui()
{
  {
    init_simple_test("BFu9i_Sf_Ui");
    static STRUCT_IF_C BFu9i_Sf_Ui lv;
    check2(sizeof(lv), 6, "sizeof(BFu9i_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_Ui");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_Ui.v2");
    check_field_offset(lv, v3, 2, "BFu9i_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_Ui, BFu9i_Sf_Ui)
//============================================================================



static void Test_BFu9i_Sf_Ul()
{
  {
    init_simple_test("BFu9i_Sf_Ul");
    static STRUCT_IF_C BFu9i_Sf_Ul lv;
    check2(sizeof(lv), 10, "sizeof(BFu9i_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_Ul");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_Ul.v2");
    check_field_offset(lv, v3, 2, "BFu9i_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_Ul, BFu9i_Sf_Ul)
//============================================================================



static void Test_BFu9i_Sf_Us()
{
  {
    init_simple_test("BFu9i_Sf_Us");
    static STRUCT_IF_C BFu9i_Sf_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_Us");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_Us.v2");
    check_field_offset(lv, v3, 2, "BFu9i_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_Us, BFu9i_Sf_Us)
//============================================================================



static void Test_BFu9i_Sf_Vp()
{
  {
    init_simple_test("BFu9i_Sf_Vp");
    static STRUCT_IF_C BFu9i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu9i_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Sf_Vp");
    check_field_offset(lv, v2, 2, "BFu9i_Sf_Vp.v2");
    check_field_offset(lv, v3, 2, "BFu9i_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Sf_Vp, BFu9i_Sf_Vp)
//============================================================================



static void Test_BFu9i_Uc_Sf()
{
  {
    init_simple_test("BFu9i_Uc_Sf");
    static STRUCT_IF_C BFu9i_Uc_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9i_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Uc_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_Uc_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu9i_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Uc_Sf, BFu9i_Uc_Sf)
//============================================================================



static void Test_BFu9i_Ui_Sf()
{
  {
    init_simple_test("BFu9i_Ui_Sf");
    static STRUCT_IF_C BFu9i_Ui_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu9i_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Ui_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_Ui_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu9i_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Ui_Sf, BFu9i_Ui_Sf)
//============================================================================



static void Test_BFu9i_Ul_Sf()
{
  {
    init_simple_test("BFu9i_Ul_Sf");
    static STRUCT_IF_C BFu9i_Ul_Sf lv;
    check2(sizeof(lv), 10, "sizeof(BFu9i_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Ul_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_Ul_Sf.v2");
    check_field_offset(lv, v3, 10, "BFu9i_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Ul_Sf, BFu9i_Ul_Sf)
//============================================================================



static void Test_BFu9i_Us_Sf()
{
  {
    init_simple_test("BFu9i_Us_Sf");
    static STRUCT_IF_C BFu9i_Us_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Us_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu9i_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Us_Sf, BFu9i_Us_Sf)
//============================================================================



static void Test_BFu9i_Vp_Sf()
{
  {
    init_simple_test("BFu9i_Vp_Sf");
    static STRUCT_IF_C BFu9i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu9i_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Vp_Sf");
    check_field_offset(lv, v2, 2, "BFu9i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "BFu9i_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9i_Vp_Sf, BFu9i_Vp_Sf)
//============================================================================



static void Test_BFu9ll_BFu15i_Sf()
{
  {
    init_simple_test("BFu9ll_BFu15i_Sf");
    static STRUCT_IF_C BFu9ll_BFu15i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9ll_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu9ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu9ll_BFu15i_Sf");
    check_field_offset(lv, v3, 3, "BFu9ll_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9ll_BFu15i_Sf, BFu9ll_BFu15i_Sf)
//============================================================================



static void Test_BFu9ll_BFu15ll_Sf()
{
  {
    init_simple_test("BFu9ll_BFu15ll_Sf");
    static STRUCT_IF_C BFu9ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9ll_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu9ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu9ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 3, "BFu9ll_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9ll_BFu15ll_Sf, BFu9ll_BFu15ll_Sf)
//============================================================================



static void Test_BFu9ll_BFu15s_Sf()
{
  {
    init_simple_test("BFu9ll_BFu15s_Sf");
    static STRUCT_IF_C BFu9ll_BFu15s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu9ll_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu9ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu9ll_BFu15s_Sf");
    check_field_offset(lv, v3, 3, "BFu9ll_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9ll_BFu15s_Sf, BFu9ll_BFu15s_Sf)
//============================================================================



static void Test_BFu9ll_BFu16i_Sf()
{
  {
    init_simple_test("BFu9ll_BFu16i_Sf");
    static STRUCT_IF_C BFu9ll_BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu9ll_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu9ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu9ll_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "BFu9ll_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9ll_BFu16i_Sf, BFu9ll_BFu16i_Sf)
//============================================================================



static void Test_BFu9ll_BFu16ll_Sf()
{
  {
    init_simple_test("BFu9ll_BFu16ll_Sf");
    static STRUCT_IF_C BFu9ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu9ll_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu9ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu9ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "BFu9ll_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9ll_BFu16ll_Sf, BFu9ll_BFu16ll_Sf)
//============================================================================



static void Test_BFu9ll_BFu16s_Sf()
{
  {
    init_simple_test("BFu9ll_BFu16s_Sf");
    static STRUCT_IF_C BFu9ll_BFu16s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu9ll_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu9ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu9ll_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "BFu9ll_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9ll_BFu16s_Sf, BFu9ll_BFu16s_Sf)
//============================================================================



static void Test_BFu9ll_BFu17i_Sf()
{
  {
    init_simple_test("BFu9ll_BFu17i_Sf");
    static STRUCT_IF_C BFu9ll_BFu17i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu9ll_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu9ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu9ll_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "BFu9ll_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9ll_BFu17i_Sf, BFu9ll_BFu17i_Sf)
//============================================================================



static void Test_BFu9ll_BFu17ll_Sf()
{
  {
    init_simple_test("BFu9ll_BFu17ll_Sf");
    static STRUCT_IF_C BFu9ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu9ll_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu9ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu9ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "BFu9ll_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9ll_BFu17ll_Sf, BFu9ll_BFu17ll_Sf)
//============================================================================



static void Test_BFu9ll_BFu1c_Sf()
{
  {
    init_simple_test("BFu9ll_BFu1c_Sf");
    static STRUCT_IF_C BFu9ll_BFu1c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9ll_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9ll_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "BFu9ll_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9ll_BFu1c_Sf, BFu9ll_BFu1c_Sf)
//============================================================================



static void Test_BFu9ll_BFu1i_Sf()
{
  {
    init_simple_test("BFu9ll_BFu1i_Sf");
    static STRUCT_IF_C BFu9ll_BFu1i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9ll_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9ll_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "BFu9ll_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9ll_BFu1i_Sf, BFu9ll_BFu1i_Sf)
//============================================================================



static void Test_BFu9ll_BFu1ll_Sf()
{
  {
    init_simple_test("BFu9ll_BFu1ll_Sf");
    static STRUCT_IF_C BFu9ll_BFu1ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9ll_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "BFu9ll_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9ll_BFu1ll_Sf, BFu9ll_BFu1ll_Sf)
//============================================================================



static void Test_BFu9ll_BFu1s_Sf()
{
  {
    init_simple_test("BFu9ll_BFu1s_Sf");
    static STRUCT_IF_C BFu9ll_BFu1s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu9ll_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu9ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9ll_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "BFu9ll_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu9ll_BFu1s_Sf, BFu9ll_BFu1s_Sf)
//============================================================================



static void Test_BFu9